<?php
// Copyright 1999-2025. WebPros International GmbH. All rights reserved.

$messages = [
    'additional-key-info.title' => 'Egenskaper for ekstranøkkel',
    'additional-key-info.update' => 'Hent ekstranøkkel',
    'additional-key-info.updateDescription' => 'Hent ekstranøklene og installer dem.',
    'additional-key-info.download' => 'Nedlastingsnøkkel',
    'additional-key-info.downloadDescription' => 'Last ned aktiv lisensnøkkel.',
    'additional-key-info.install' => 'Installer nøkkel',
    'additional-key-info.installDescription' => 'Installer gjeldende lisensnøkkel.',
    'additional-key-info.revert' => 'Rull nøkkel tilbake',
    'additional-key-info.revertDescription' => 'Rull tilbake til tidligere installert lisensnøkkel.',
    'additional-key-info.revertNotAvailableDescription' => 'Ingen nøkkel installert.',
    'additional-key-info.installSuccess' => 'Installasjon av lisensnøkkel er startet.',

    'additional-key-revert.title' => 'Tilbakerulling av ekstranøkkel',
    'additional-key-revert.success' => 'Ekstranøkkelen ble tilbakerullet.',

    'additional-key-upload.title' => 'Installer en lisensnøkkel',
    'additional-key-upload.success' => 'Den nye ekstranøkkelen ble lastet opp.',

    'additional-keys.title' => 'Ekstra lisensnøkler',

    'change-subscriptions-owner.title' => 'Ny tildeling av valgte abonnementer',
    'change-subscriptions-owner.success' => 'Eier av abonnementet ble endret',

    'customers.hint' => 'Det er her du administrerer kontoer for kunder av hostingtjenesten: opprett kontoer sammen med tjenesteabonnementer, administrer eksisterende kunder og fjern kontoer. For å administrere nettsteder, epost eller andre tjenester som leveres til en kunde, gå til Kundepanelet deres ved å klikke på koblingen i den høyre kolonnen i listen.',

    'customer-domains.hint' => 'Dette er hvor du setter opp og administrer nettsteder.',

    'customer-subscriptions.hint' => 'Her administrerer du kundens abonnementer.',

    'domains.hint' => 'Her kan du se informasjon om alle domenenavn som er registrert i systemet, og kan fortsette til administrasjon av hostingtjenester. For å legge til et domene for deg selv eller for hosting-kunder, klikker du på «Legg til et domene». Du vil bli bedt om å opprette en ny kunde og et nytt abonnement når du oppretter et domene, eller du kan velge fra eksisterende kunder og abonnementer.',

    'database-servers.title' => 'Databaseservere',

    'database-server-create.title' => 'Ny databaseservere',

    'database-server-properties.title' => 'Databaseserver',

    'database-server-upgrade.drawerTitle' => 'MariaDB-oppgradering',
    'database-server-upgrade.drawerTitle.completed' => 'Oppgradering fullført',
    'database-server-upgrade.drawerSubTitle.line1' => 'Skuffen kan ikke lukkes mens oppdateringen pågår.',
    'database-server-upgrade.drawerSubTitle.line2' => 'Hvis det oppstår problemer under oppgraderingen, se %%troubleshootingArticle%%.',
    'database-server-upgrade.drawerSubTitle.completed' => 'MariaDB-databaseserveren er oppgradert til versjon %%releaseVersion%%. Hvis du opplever problemer, kan du følge instruksjonene i %%troubleshootingArticle%%.',
    'database-server-upgrade.upToDate' => 'Du har allerede installert LTS-versjonen.',
    'database-server-upgrade.troubleshootingArticle' => 'denne KB-artikkelen',
    'database-server-upgrade.troubleshootingArticleDescription' => 'Bruk %%troubleshootingArticle%% for å feilsøke oppgraderingsproblemer med MariaDB.',

    'database-server-upgrade.chooseReleaseStep.infoBlock.par1' => 'Oppgrader din lokale MariaDB-databaseserver til gjeldende versjon med langtidsstøtte (LTS).',
    'database-server-upgrade.chooseReleaseStep.infoBlock.par2' => 'Vi anbefaler på det sterkeste at du sikkerhetskopierer serveren din før oppgradering og starter oppgraderingen når nettstedet har få besøkende.',
    'database-server-upgrade.chooseReleaseStep.infoBlock.par3' => 'Under MariaDB-oppgraderingen vil Plesk-serveren og nettsteder den er vert for være utilgjengelig. MariaDB-oppgraderingen er normalt feilfri og tar omtrent ti minutter, men den kan likevel påvirke hele serveren.',
    'database-server-upgrade.chooseReleaseStep.infoBlock.par4' => 'Merk: Hvis du kjører MariaDB 5.5, vil Plesk først oppgradere til MariaDB 10.5. Etter at oppgraderingen er fullført, kan du starte denne installasjonsveilederen igjen for å oppdatere til gjeldende LTS-versjon av MariaDB.',
    'database-server-upgrade.chooseReleaseStep.currentVersionTitle' => 'Nåværende versjon',
    'database-server-upgrade.chooseReleaseStep.currentMariaDBVersion' => 'MariaDB %%version%%',
    'database-server-upgrade.chooseReleaseStep.selectVersion' => 'Velg versjon å oppgradere til',
    'database-server-upgrade.chooseReleaseStep.noMajorReleases' => 'Ingen store versjoner er sluppet',
    'database-server-upgrade.chooseReleaseStep.releaseNotes' => 'Versjonsmerknader',
    'database-server-upgrade.chooseReleaseStep.releaseDate' => 'Lanseringsdato: %%date%%',
    'database-server-upgrade.chooseReleaseStep.endOfLifeDate' => 'End of life-dato: %%date%%',
    'database-server-upgrade.chooseReleaseStep.notDetected' => 'Kun MariaDB-forgreninger levert av OS-leverandører eller MariaDB-leverandøren kan oppgraderes.',

    'database-server-upgrade.preUpgradeCheckProgressStep.title' => 'Kontroller før oppgradering',
    'database-server-upgrade.preUpgradeCheckProgressStep.configChecker' => 'Spalter MariaDB-konfigurasjonsfiler',
    'database-server-upgrade.preUpgradeCheckProgressStep.mysqlChecker' => 'Analyserer databaser med mysqlcheck',
    'database-server-upgrade.preUpgradeCheckProgressStep.packageManagerChecker' => 'Analyserer konfigurasjon for pakkeadministrator',
    'database-server-upgrade.preUpgradeCheckProgressStep.systemCompatibilityChecker' => 'Kontrollerer systemkompatibilitet',
    'database-server-upgrade.preUpgradeCheckProgressStep.webSocketChecker' => 'Kontrollerer WebSocket',

    'database-server-upgrade.preUpgradeCheckStep.shouldBeConfirmed' => 'For å fortsette oppgraderingen, må du krysse av alle rutene. Dette er nødvendig for å sikre at du godtar konfigurasjonsendringene oppgraderingen vil medføre og at du har gjenopprettingsmuligheter.',
    'database-server-upgrade.preUpgradeCheckStep.removedSystemVariables' => 'Følgende variabler blir fjernet for kompatibilitet med den nye versjonen:',
    'database-server-upgrade.preUpgradeCheckStep.fromFiles' => '{variable} fra {count, plural, one {filen {files}} other {# filer: {files}}}',
    'database-server-upgrade.preUpgradeCheckStep.accessToolsSection' => 'Alternativer for gjenoppretting (serverens kommandolinjekonsoll og Repair Kit)',
    'database-server-upgrade.preUpgradeCheckStep.sshAccess' => 'Jeg bekreftet at jeg har SSH-tilgang til serveren',
    'database-server-upgrade.preUpgradeCheckStep.sshAccessDescription' => 'Bruk en SSH-klient eller åpne %%sshTerminalExtension%% i en ny nettleserfane (ikke lukk SSH-terminalutvidelsesvinduet før oppgraderingen er fullført). Hvis oppgraderingen mislykkes, vil SSH-tilgang forenkle gjenoppretting.',
    'database-server-upgrade.preUpgradeCheckStep.sshTerminalExtension' => 'SSH Terminal-utvidelse',
    'database-server-upgrade.preUpgradeCheckStep.repairKitAccess' => 'Jeg bekrefter at jeg har tilgang til Repair Kit',
    'database-server-upgrade.preUpgradeCheckStep.repairKitAccessDescription' => 'Åpne %%repairKit%% i et nytt nettleservindu og logg inn med administratorbruker. Ikke lukk Repair Kit-utvidelsesvinduet før oppgraderingen er fullført.',
    'database-server-upgrade.preUpgradeCheckStep.repairKit' => 'Repair Kit',
    'database-server-upgrade.preUpgradeCheckStep.dumpSection' => 'Sikkerhetskopier databaser',
    'database-server-upgrade.preUpgradeCheckStep.withDump' => 'Sikkerhetskopier alle databaser serveren er vert for før oppgraderingen',
    'database-server-upgrade.preUpgradeCheckStep.withDumpDescription' => 'Plesk lagrer sikkerhetskopien av databaser i katalogen %%path%%.',
    'database-server-upgrade.preUpgradeCheckStep.webSocketNotAvailable' => 'WebSocket i Plesk er ikke tilgjengelig',
    'database-server-upgrade.preUpgradeCheckStep.webSocketNotAvailableDescription' => 'Du vil ikke kunne se oppgraderingsprosessens utdata i sanntid uten WebSocket.',

    'database-server-upgrade.submitPopover.title' => 'For å forhindre potensiell datatap, anbefaler vi på det sterkeste at du oppretter en dump av databaser serveren er vert for før du fortsetter. Fortsette uten å opprette dump?',

    'database-server-databases.title' => 'Databaser',

    'database-server-change-password.title' => 'Administratorpassord',

    'home.title' => 'Hjem',

    'license.title' => 'Lisensinformasjon',

    'primary-key-info.title' => 'Plesk lisensnøkkel',
    'primary-key-info.update' => 'Hent nøkler',
    'primary-key-info.updateDescription' => 'Hent inn bestilte lisensnøkler og installer dem.',
    'primary-key-info.upload' => 'Installer nøkkel',
    'primary-key-info.uploadDescription' => 'Last opp og installer en ny lisens.',
    'primary-key-info.revert' => 'Rull nøkkel tilbake',
    'primary-key-info.revertDescription' => 'Gå tilbake til tidligere installert lisensnøkkel.',
    'primary-key-info.expireTitle' => 'Plesk-lisensen din har utløpt',
    'primary-key-info.header' => 'Noen kritiske tjenester har derfor blitt utilgjengelige. %%warning%%',
    'primary-key-info.headWarning' => 'Nettstedene dine kan være i fare!',
    'primary-key-info.softwareUpdatesTitle' => 'Programvareoppdateringer',
    'primary-key-info.softwareUpdates' => '%%title%% er deaktiverte. Systemet ditt kan være sårbart ovenfor trusler.',
    'primary-key-info.websiteBackupsTitle' => 'Sikkerhetskopiering av nettsteder',
    'primary-key-info.websiteBackups' => '%%title%% er ikke lenger tilgjengelig. Du står i fare for å miste data.',
    'primary-key-info.sslCertificatesTitle' => 'SSL-/TLS-sertifikater',
    'primary-key-info.sslCertificates' => '%%title%% fornyes ikke automatisk. Dette kan gå ut over sikkerheten og påliteligheten.',
    'primary-key-info.monitoringTitle' => 'Overvåkning',
    'primary-key-info.monitoring' => '%%title%% er utilgjengelig. Det kan hende problemer som overbelastning og dårlig ytelse ikke blir oppdaget.',
    'primary-key-info.fileDbManagementTitle' => 'Administrasjon av filer og databaser',
    'primary-key-info.fileDbManagement' => '%%title%% er deaktivert. Du kan ikke administrere filer eller databaser på en god måte.',
    'primary-key-info.technicalSupportTitle' => 'Teknisk støtte',
    'primary-key-info.technicalSupport' => '%%title%% er utilgjengelig. Når du ikke har tilgang til nødvendig hjelp med serverproblemer, kan det føre til langvarige driftsavbrudd.',
    'primary-key-info.renewLicense' => 'Kjøp en ny Plesk-lisens nå for å få tilgang til tjenestene igjen.',
    'primary-key-info.footer' => 'Hvis du har spørsmål eller trenger hjelp,',
    'primary-key-info.supportLink' => 'kan du kontakte kundestøtte',

    'primary-key-revert.title' => 'Tilbakerulling av lisensnøkkel',
    'primary-key-revert.success' => 'Plesk-nøkkelen ble tilbakerullet.',

    'primary-key-upload.title' => 'Installer en lisensnøkkel',
    'primary-key-upload.success' => 'Den nye Plesk-nøkkelen ble lastet opp.',

    'resellers.hint' => 'Her kan du administrere forhandlerkontoer — kundene dine som videreselger hostingtjenester og hoster sine egne nettsteder. Her oppretter du kontoer sammen med tjenesteabonnementer, administrerer eksisterende forhandlere og fjerner kontoer.',

    'reseller-customers.hint' => 'Her kan du sette opp og administrere kunder.',

    'reseller-domains.hint' => 'Dette er hvor du setter opp og administrer nettsteder.',

    'reseller-subscriptions.hint' => 'Her kan du administrere abonnementene til videreforhandleren.',

    'subscriptions.hint' => 'Kundene mottar hostingtjenester fra deg ved å abonnere på en hostingplan. Du kan administrere disse abonnementene her, samt dine egne abonnementer som du oppretter for å hoste nettstedene dine. For å administrere nettsteder, epost eller andre tjenester som leveres sammen med et abonnement, gå til abonnentens Kundepanel ved å klikke på koblingen i den høyre kolonnen av listen.',

    'server-mail-settings.title' => 'Innstillinger',
    'server-mail-spam-filter.title' => 'Spamfiltrering',
    'server-mail-antivirus.title' => 'Antivirus',
    'server-mail-black-list.title' => 'Svarteliste',
    'server-mail-white-list.title' => 'Hviteliste',
    'server-mail-queue.title' => 'E-postkø',
    'server-mail-statistics.title' => 'Statistikk',
    'server-mail-smarthost.title' => 'Smartvert',

    'server-spam-filter.settings' => 'Innstillinger',
    'server-spam-filter.black-list' => 'Svarteliste',
    'server-spam-filter.white-list' => 'Hviteliste',

    'firewall.title' => 'Brannvegg administrasjon',
    'firewall-general.title' => 'Generelt',
    'firewall-general.toggleStatus' => 'Brannmurbeskyttelse',
    'firewall-general.buttonDefault' => 'Tilbakestill til standard',
    'firewall-general.buttonPanic' => 'Panikkmodus',
    'firewall-general.confirmationDefault' => 'Tilbakestill brannmurinnstillinger til standardverdier?',
    'firewall-general.confirmationPanic' => 'Slå på panikkmodus? Brukere vil ikke få tilgang til domenene sine, og noen nettverkstjenester kan slutte å fungere.',
    'firewall-general.successDefault' => 'Brannmurinnstillingene ble tilbakestilt til standard.',
    'firewall-general.successPanic' => 'Panikkmodus ble aktivert.',
    'firewall-general.info' => 'Av sikkerhetsgrunner blokkerer brannveggen alle forbindelsene unntatt de som eksplisitt er tillatt. Du kan tillate en tilkobling ved å opprette en regel. Se dokumentasjonen for mer informasjon',
    'firewall-general.interfaces' => 'Nettverksgrensesnitt',
    'firewall-icmp.title' => 'ICMP protokoll',
    'firewall-rules.title' => 'Brannmurregler',

    'dns.title' => 'DNS-innstillinger',
    'dns-records.title' => 'Soneoppføringsmal',
    'dns-soa-record.title' => 'Mal for soneinnstillinger',

    'php-handler.title' => 'Innstillinger for %%name%%',
    'php-handler.extensions.title' => 'Tillegg',
    'php-handler.extensions.description' => 'Disse innstillingene for PHP-utvidelser er kun for dette behandlingsprogrammet.',
    'php-handler.extensions.descriptionShared' => 'Disse innstillingene er felles for følgende PHP-behandlingsprogrammer: %%handlers%%. Innstillingene gjelder for alle nettsteder som bruker disse behandlingsprogrammene.',
    'php-handler.extensions.buttonManage' => 'Administrer PECL-pakker',
    'php-handler.extensions.manage.title' => 'Administrer PECL-pakker',
    'php-handler.extensions.manage.risks' => 'PHP-utvidelser leveres av tredjeparts PECL-pakker. De installeres på egen risiko.',
    'php-handler.extensions.manage.description' => 'Installer, oppgrader og avinstaller PECL-pakker. Endringene gjelder for alle nettsider som kjører på %%handlers%%.',
    'php-handler.extensions.manage.notFound' => 'Hvorfor er ikke den ønskede pakken på listen?',
    'php-handler.extensions.manage.limitations' => 'PHP-utvidelser som leveres av kontrollpanelleverandøren og OS-leverandører vises ikke i listen.',
    'php-handler.php-ini.title' => 'php.ini',


    'ServerInformation.refresh' => "Oppdater",
    'ServerInformation.sectionGeneral' => "Generelt",
    'ServerInformation.cpu' => "CPU",
    'ServerInformation.version' => "Versjon",
    'ServerInformation.os' => "Operativsystem",
    'ServerInformation.key' => "Plesk lisensnøkkel",
    'ServerInformation.uptime' => "Oppetid",
    'ServerInformation.uptimeValue' => "{days, plural, =0 {} one {# dag} other {# dager}} {hours, plural, one {# time} other {# time}} {minutes, plural, one {# minutt} other {# minutter}}",
    'ServerInformation.sectionCpu' => "CPU-bruk",
    'ServerInformation.la1min' => "Siste 1 minutt",
    'ServerInformation.la5min' => "Siste 5 minutter",
    'ServerInformation.la15min' => "Siste 15 minutter",
    'ServerInformation.sectionMemory' => "Minnebruk",
    'ServerInformation.memoryHardware' => "Maskinvare",
    'ServerInformation.memoryTotalNoKernel' => "Totalt (unntatt kjerne)",
    'ServerInformation.memoryTotal' => "Totalt",
    'ServerInformation.memoryUsed' => "Brukt",
    'ServerInformation.memoryFree' => "Ledig",
    'ServerInformation.memoryShared' => "Delt",
    'ServerInformation.memoryBuffer' => "Buffer",
    'ServerInformation.memoryCached' => "Hurtigbufret",
    'ServerInformation.memoryAvailable' => "Tilgjengelig",
    'ServerInformation.memoryUsage' => "Bruk",
    'ServerInformation.sectionSwap' => "Bruk av swap",
    'ServerInformation.sectionVirtualMemory' => "Bruk av virtuelt minne",
    'ServerInformation.swapTotal' => "Totalt",
    'ServerInformation.swapUsed' => "Brukt",
    'ServerInformation.swapFree' => "Ledig",
    'ServerInformation.swapUsage' => "Bruk",
    'ServerInformation.sectionHarddisk' => "Forbruk av harddisk",
    'ServerInformation.harddiskDirectory' => "Filsystem:",
    'ServerInformation.harddiskProtectedDir' => "Viktige mapper",
    'ServerInformation.harddiskTotal' => "Totalt",
    'ServerInformation.harddiskUsed' => "Brukt",
    'ServerInformation.harddiskAvailable' => "Tilgjengelig",
    'ServerInformation.harddiskCapacity' => "Kapasitet",
    'ServerInformation.sectionDomains' => "Domener",
    'ServerInformation.activeDomains' => "Aktiv",
    'ServerInformation.inactiveDomains' => "Inaktiv",
    'ServerInformation.problemDomains' => "Problemer",
    'ServerInformation.refreshed' => "Informasjon oppdatert.",

    'ServerAbout.copyright' => '© 2025 WebPros International GmbH. Med enerett.',
    'ServerAbout.linkLicenseManagement' => 'Gå til lisensinformasjon',
    'ServerAbout.panelVersion' => 'Versjon',
    'ServerAbout.installedPatchVersion' => 'Oppdater #%%patch%%',
    'ServerAbout.licenseKey' => 'Lisensnøkkel',
    'ServerAbout.productDescription' => 'Plesk er den ledende WebOps-plattformen for å kjøre, automatisere og utvikle applikasjoner, nettsteder og hosting-bedrifter.',
    'ServerAbout.readEula' => 'Les %%link%%.',
    'ServerAbout.linkEula' => 'Lisensavtale for sluttbrukere (EULA)',
    'ServerAbout.visitForum' => 'Besøk %%link%%',
    'ServerAbout.linkForum' => 'Plesk-forum',
    'ServerAbout.followUs' => 'Følg oss',
    'ServerAbout.visitSite' => 'Lær mer på %%link%%',
    'ServerAbout.linkSite' => 'plesk.com',
    'ServerAbout.visitBlog' => 'Finn inspirasjon på %%link%%',
    'ServerAbout.linkBlog' => 'Plesk-blogg',

    'ServerAbout.darkThemePromoTitle' => 'Gratulerer!',
    'ServerAbout.darkThemePromoDescription' => 'Du fant en magisk katt.',
    'ServerAbout.darkThemePromoButton' => 'Whoosh! Kom over til den mørke siden',
    'ServerAbout.darkThemeTourDescription' => 'Bytt til dette alternativet for å aktivere eller deaktivere mørkt tema for grensesnittet ditt.',
    'ServerAbout.darkThemeTourButton' => 'Forsto det',

    'ts-sessions.title' => 'Økter for terminalserver',
    'ts-sessions-properties.title' => 'Øktegenskaper',

    'BandwidthLimiting.bandwidthThrottling' => 'Du kan ikke styre begrensing av båndbredde fordi QoS ikke er installert.',
    'BandwidthLimiting.virtualHostingRequired' => 'Båndbreddebegrensning er kun tilgjengelig for domener med webhosting.',
    'BandwidthLimiting.bandwidthLabel' => 'Maksimalt båndbredde forbruk',
    'BandwidthLimiting.bandwidthHint' => 'Båndbreddegrensen gjelder kun data overført via HTTP-protokollen.',
    'BandwidthLimiting.maxConnectionLabel' => 'Tilkoblinger begrenset til',
    'BandwidthLimiting.maxConnectionHint' => 'Hvis du begrenser båndbredden, anbefaler vi at du også setter begrensning på antall samtidige tilkoblinger til nettstedet. Ellers vil webserver-prosessen øke belastningen på serveren ved hyppige forespørsler til nettstedet.',
    'BandwidthLimiting.kbps' => 'KB/s',
    'BandwidthLimiting.success' => 'Innstillinger for båndbreddegrenser ble endret.',
    'BandwidthLimiting.unlimited' => 'Ubegrenset',

    'ip-address-domains.title' => 'Nettsider som bruker %%type%% IP-adresse %%ipAddress%%',
    'ip-address-domains.site' => 'Område',
    'ip-address-domains.setAsDefault' => 'Angi som standard',
    'ip-address-domains.type-SHARED' => 'delt',
    'ip-address-domains.type-EXCLUSIVE' => 'dedikert',

    'HotlinkProtection.virtualHostingRequired' => 'Hotlink-beskyttelse er kun tilgjengelig for domener med webhosting.',
    'HotlinkProtection.enabledLabel' => 'Aktiver hotlink-beskyttelse',
    'HotlinkProtection.extensionsLabel' => 'Beskyttede filtyper',
    'HotlinkProtection.friendsLabel' => 'Adresser til trygge nettsteder',
    'HotlinkProtection.success' => 'Innstillinger for Hotlink-beskyttelse ble endret.',

    'Odbc.add' => 'Legg til ODBC DSN',
    'Odbc.resourceUsage' => '%%used%% opprettet / %%allowed%% tillatt.',
    'Odbc.limitExceeded' => 'Grensen for ODBC DSN-tilkoblinger er overskredet.',
    'Odbc.unlimited' => 'Ubegrenset',
    'Odbc.addTooltip' => 'Legg til ODBC-datakilde.',
    'Odbc.status' => 'Status',
    'Odbc.name' => 'Tilkoblingsnavn',
    'Odbc.driver' => 'Driver',
    'Odbc.description' => 'Koblingsbeskrivelse',
    'Odbc.hostname' => 'Vertsnavn',
    'Odbc.statusSystem' => 'Det er en system-DSN.',
    'Odbc.statusConfigured' => 'DSN er konfigurert.',
    'Odbc.statusNotConfigured' => 'DSN er ikke konfigurert.',
    'Odbc.noSelectionText' => 'Velg ett eller flere elementer for fjerning.',
    'Odbc.removeConfirmation' => 'Fjern {count, plural, one {}=1 {tilkoblingen {name}} other {# valgte tilkoblinger}}?',
    'Odbc.removeSuccess' => 'De valgte tilkoblingene ble fjernet.',

    'DomainAliasSettings.title' => 'Innstillinger for domenealias',
    'DomainAliasSettings.updateSuccess' => 'Egenskapene til domenealiaset %%name%% ble endret. %%apacheRestartInterval%%',
    'DomainAliasSettings.apacheRestartInterval' => 'Nettstedsinnstillingene vil bli aktivert om %%restartInterval%% minutter.',

    'Home.Backup.offStatus' => 'Dette er ikke en gyldig sikkerhetskopi. Data kan ikke gjenopprettes fra denne filen.',
    'Home.Backup.task-failedStatus' => 'Sikkerhetskopiering mislyktes.',
    'Home.Backup.activeSchedule' => 'Tidsplan: %%schedule%%',
    'Home.Backup.activeSchedules' => 'Tidsplaner: %%schedules%%',
    'Home.Backup.noSchedule' => "Tidsplan for sikkerhetskopiering er ikke angitt",
    'Home.Backup.period_hourly' => 'På timen %%schedule%%',
    'Home.Backup.period_daily' => 'Daglig %%schedule%%',
    'Home.Backup.period_weekly' => 'Ukentlig %%schedule%%',
    'Home.Backup.period_monthly' => 'Månedlig %%schedule%%',
    'Home.Backup.create' => 'Opprett en sikkerhetskopi',
    'Home.Backup.schedule' => 'Tidsplan',
    'Home.ChangeLog.seeHistory' => 'Se endringshistorikk',
    'Home.CustomButtons.add' => 'Legg til brukerdefinert knapp',
    'Home.CustomButtons.noButtons' => 'Det er ingen brukerdefinerte knapper',
    'Home.Customization.title' => 'Dashbord',
    'Home.Customization.description' => 'Velg hvilke alternativer du vil se',
    'Home.Customization.pleskSection' => 'Plesk',
    'Home.Customization.serverSection' => 'Server',
    'Home.Customization.securitySection' => 'Sikkerhet',
    'Home.Customization.backup' => 'Forrige sikkerhetskopi av server',
    'Home.Customization.ipBan' => 'Utestenging av IP-adresse',
    'Home.Customization.mailQueue' => 'E-postkø',
    'Home.Customization.mySubscriptions' => 'Mine abonnementer',
    'Home.Customization.overusedSubscriptions' => 'Abonnementer med overforbruk',
    'Home.Customization.serverInfo' => 'Serverinformasjon',
    'Home.Customization.updates' => 'Plesk oppdateringer',
    'Home.Customization.promo' => 'Kampanje',
    'Home.Customization.changeLog' => 'Nytt',
    'Home.Customization.customButtons' => 'Egendefinerte knapper',
    'Home.EmptyView.title' => 'Få mest mulig ut av kontrollpanelet ditt ved å velge hvilke alternativer du skal se.',
    'Home.EmptyView.titleLocked' => 'Kontrollpanelet er låst av tjenestetilbyderen din.',
    'Home.EmptyView.customize' => 'Tilpass',
    'Home.Extension.title' => 'Filtype',
    'Home.IpBan.banned' => 'Svartelistet',
    'Home.IpBan.trusted' => 'Klarert',
    'Home.IpBan.more' => 'Se mer',
    'Home.MailQueue.total' => 'Totalt',
    'Home.MailQueue.deferred' => 'Utsatt',
    'Home.MailQueue.held' => 'På vent',
    'Home.MailQueue.more' => 'Se mer',
    'Home.MailQueue.clean' => 'Tøm e-postkø',
    'Home.MailQueue.checkLogs' => 'Sjekk logger',
    'Home.MailQueue.repair' => 'Reparer',
    'Home.MailQueue.cleanConfirmQuestion' => 'Tøm e-postkøen?',
    'Home.MailQueue.cleanConfirmYes' => 'Ja',
    'Home.MailQueue.cleanConfirmNo' => 'Nei',
    'Home.MailQueue.queueCleaned' => 'E-postkø ble tømt.',
    'Home.MailQueue.Promo.title' => 'Få enkel tilgang til leverinsstatus og logger',
    'Home.MailQueue.Promo.link' => 'Prøv den nye e-postkøen nå',
    'Home.OverusedSubscriptions.empty' => 'Fant ingen abonnementer med overforbruk',
    'Home.OverusedSubscriptions.usage' => '%%formattedUsed%% av %%formattedValue%%',
    'Home.OverusedSubscriptions.more' => 'Se alle med overforbruk: [%%total%%]',
    'Home.OverusedSubscriptions.list' => 'Åpne i listen',
    'Home.PromoNewHomeView.title' => 'Velkommen til den nye hjemmesiden!',
    'Home.PromoNewHomeView.description' => 'Hvis du opplever problemer, bes du om å gi oss tilbakemelding. Dette hjelper oss med å forbedre tjenesten.',
    'Home.PromoNewHomeView.feedback' => 'Del tilbakemelding',
    'Home.PromoNewHomeView.switch' => 'Bytt tilbake til «Hjem»',
    'Home.ServerInfo.hostname' => 'Vertsnavn',
    'Home.ServerInfo.ipAddress' => 'IP-adresse',
    'Home.ServerInfo.publicIpAddress' => 'Offentlig IP-adresse',
    'Home.ServerInfo.os' => 'OS',
    'Home.ServerInfo.uptime' => 'Oppetid',
    'Home.ServerInfo.uptimeValue' => "{days, plural, =0 {} one {# dag} other {# dager}} {hours, plural, one {# time} other {# time}} {minutes, plural, one {# minutt} other {# minutter}}",
    'Home.ServerInfo.more' => 'Se mer',
    'Home.Subscriptions.add' => 'Legg til ny',
    'Home.Subscriptions.empty' => 'Opprett abonnementer som lar deg drifte flere nettsteder på et isolert område på serveren. %%link%%',
    'Home.Subscriptions.help' => 'Lær mer',
    'Home.Updates.title' => 'Produktoppdateringer',
    'Home.Updates.version' => '%%name%% %%version%%',
    'Home.Updates.patch' => '%%version%% oppdatering #%%patch%%',
    'Home.Updates.manageComponents' => 'Legg til eller fjern komponenter',
    'Home.Updates.lastUpdated' => 'Sist oppdatert %%lastUpdateDate%%',
    'Home.Updates.checkUpdates' => 'Se etter oppdateringer',
    'Home.Updates.enableAutoupdate' => 'Tillat automatiske oppdateringer',
    'Home.Updates.lastChecked' => 'Sist kontrollert %%lastCheckDate%%',
    'Home.Updates.newVersionAvailable' => '%%availableVersion%% er tilgjengelig',
    'Home.Updates.installNewVersion' => 'Installer nå',
    'Home.Updates.patchAvailable' => 'Mindre oppdateringer er tilgjengelige',
    'Home.Updates.patchAvailableVersion' => 'Mindre oppdateringer for %%currentVersion%% er tilgjengelige',
    'Home.Updates.installPatch' => 'Oppdater nå',
    'Home.Updates.pumUpdates' => '{total, select, 1 {Oppdatering for {package} er tilgjengelig} other {Oppdateringer for {package} er tilgjengelige}}',
    'Home.Updates.pumPackage' => '%%name%% %%availableVersion%%',
    'Home.Updates.pumPackages' => '{total, plural, one {# pakke} other {# pakker}}',
    'Home.Updates.installUpdates' => '{total, select, 1 {Oppdater nå} other {Oppdater alle}}',
    'Home.Promo.Customize.title' => 'Tilpass kontrollpanelet ditt!',
    'Home.Promo.Customize.content' => 'Tilpass kontrollpanelet for enkel tilgang til favorittfunksjonene dine',
    'Home.Promo.Customize.action' => 'Tilpass',
    'Home.Promo.SwitchToPuv.title' => 'Kjenner du til grensesnittvisninger i Plesk?',
    'Home.Promo.SwitchToPuv.content' => 'Hvis du ikke tilbyr hostingtjenester til kundene dine ved bruk av tjenesteabonnementer, kan du prøve grensesnittet som er mer praktisk for å administrere nettsider, filene deres, databaser, e-postkontoer og webapper.',
    'Home.Promo.SwitchToPuv.action' => 'Prøv nå',
    'Home.Status.error' => 'Feil',
    'Home.Status.warning' => 'Advarsel',
    'Home.Status.info' => 'Info',

    'HostingSettings.title' => 'Hostinginnstillinger',
    'HostingSettings.updateSuccess' => 'Innstillingene ble oppdatert.',
    'HostingSettings.emptyLogin' => 'Du må angi et brukernavn.',
    'HostingSettings.emptyPassword' => 'Du må angi et passord.',
    'HostingSettings.ipV6OnlyNotSupported' => 'FTP-serveren støtter ikke Ipv6. Du må tildele minst én Ipv4-adresse, ellers vil ikke brukeren kunne fortsette å laste opp filer til serveren via FTP',
    'HostingSettings.domainSettingsSection.sectionTitle' => 'Domeneinnstillinger',
    'HostingSettings.domainSettingsSection.domainName' => 'Domenenavn',
    'HostingSettings.domainSettingsSection.description' => 'For eksempel: eksempel.com ',

    'HostingSettings.submitPopover.title' => 'Fjern innholdet fra %%website%%',
    'HostingSettings.submitPopover.descriptionMainDomain' => 'Ved å bytte nettstedets hostingtype til %%type%%, fjernes alt for godt, inkludert følgende mapper:',
    'HostingSettings.submitPopover.descriptionSubDomain' => 'Ønsker du å endre hostingtype for nettstedet ditt?',

    'HostingSettings.domainSettingsSection.creatingWebspaceAlert' => 'For tilgang til flere innstillinger, angir du systemets brukeropplysninger og klikker deretter på «Opprett webspace».',
    'HostingSettings.domainSettingsSection.creatingHostingAlert' => 'For tilgang til flere innstillinger, klikker du på «Neste» for å opprette hosting.',
    'HostingSettings.domainSettingsSection.hostingTypeTitle' => 'Hosting-type',
    'HostingSettings.domainSettingsSection.hostingType.title' => 'Type',
    'HostingSettings.domainSettingsSection.hostingType.website' => 'Nettsted',
    'HostingSettings.domainSettingsSection.hostingType.forwarding' => 'Videresending',
    'HostingSettings.domainSettingsSection.hostingType.noHosting' => 'Ingen webhosting',
    'HostingSettings.domainSettingsSection.hostingType.noHostingHint' => 'Bruk domenets DNS-sone for å opprette mailbokser under dette domenenavnet',
    'HostingSettings.domainSettingsSection.hostingType.pathToTheWebsite' => 'Stien til nettstedets hjemmemappe',
    'HostingSettings.domainSettingsSection.preferredDomainTitle' => 'Foretrukket domene',
    'HostingSettings.domainSettingsSection.preferredDomainDescription' => 'Besøkende blir omdirigert hit via en SEO-vennlig HTTP 301-omdirigering.',
    'HostingSettings.domainSettingsSection.forwardVisitorsTo' => 'Videresend besøkende til',
    'HostingSettings.domainSettingsSection.forwardingType.title' => 'Videresending type',
    'HostingSettings.domainSettingsSection.forwardingType.movedPermanently' => 'Permanent flyttet (kode 301)',
    'HostingSettings.domainSettingsSection.forwardingType.movedPermanentlyDescription' => 'Omdiriger nettsidebesøkende til en annen nettside og vis dem måladressen. Slik omdirigering bevarer nettstedets søkerangering',
    'HostingSettings.domainSettingsSection.forwardingType.movedTemporarily' => 'Temporært flyttet (kode 302)',
    'HostingSettings.domainSettingsSection.forwardingType.movedTemporarilyDescription' => 'Viderekoble besøkende til en midlertidig områdekopi når du ikke vil at søkemotorer skal indeksere dette midlertidige området.',
    'HostingSettings.domainSettingsSection.forwardingType.frameForwarding' => 'Ramme videresending',
    'HostingSettings.domainSettingsSection.forwardingType.frameForwardingDescription' => 'Viderekoble besøk på nettsted til et annet område, men ikke vis dem måladressen, slik at de ikke vet om viderekoblingen.',
    'HostingSettings.domainSettingsSection.preferredDomain.title' => 'Foretrukket domene',
    'HostingSettings.domainSettingsSection.preferredDomain.none' => 'Ingen',
    'HostingSettings.domainSettingsSection.preferredDomain.www' => 'www.%%domainName%%',
    'HostingSettings.domainSettingsSection.documentRootTitle' => 'Dokumentrot',
    'HostingSettings.domainSettingsSection.documentRootHint' => 'Det er umulig å endre rottilgang for dokumentet fordi det finnes webprogrammer installert på dette nettstedet.',
    'HostingSettings.domainSettingsSection.save' => 'Lagre',
    'HostingSettings.domainSettingsSection.sameSsl.title' => 'Kompatibilitetsmodus',
    'HostingSettings.domainSettingsSection.sameSsl.enabled' => 'Kjør nettstedet i kompatibilitetsmodus for det eldre alternativet "Skille SSL/TLS og ikke-SSL/TLS innhold"',
    'HostingSettings.domainSettingsSection.sameSsl.hint' => 'Denne nettsiden kjører i kompatibilitetsmodus, og du kan ikke administrere den via Plesk-grensesnittet. Dette skyldes at du brukte det utdaterte alternativet «Separate SSL/TLS and non-SSL/TLS content» før oppgraderingen. Fra og med Plesk 11 lagrer nettsider tilgjengelig innhold fra HTTP- og HTTPS-tilkoblinger i samme katalog. Vi anbefaler at du flytter all data fra katalogen `httpsdocs/` til `httpdocs/`, og deretter slår av kompatibilitetsmodus. Dette fører også til at apper installert i `httpsdocs/` blir tilgjengelige via internett. Vær oppmerksom på at det ikke vil være mulig å slå på kompatibilitetsmodus igjen.',
    'HostingSettings.domainSettingsSection.security.secureSettingsDialogTitle' => 'Endre denne innstillingen?',
    'HostingSettings.domainSettingsSection.security.secureSettingsDialogDescription' => 'Endring av denne innstillingen er i strid med serverens sikkerhetsregler, og kan gå ut over ytelsen eller gjøre serveren sårbar for angrep.',
    'HostingSettings.domainSettingsSection.security.buttonChange' => 'Endre',
    'HostingSettings.domainSettingsSection.security.buttonRevert' => 'Gjenopprett',
    'HostingSettings.domainSettingsSection.security.secureSettingsPresetApplied' => 'Forhåndsdefinerte sikkerhetsinnstillinger er aktivert',
    'HostingSettings.domainSettingsSection.security.secureSettingsPresetMessage' => 'For økt sikkerhet kan du bruke den forhåndsdefinerte sikkerhetsinnstillingen. Merk at visse tillatelser gjør det mulig for abonnenter å endre disse innstillingene.',
    'HostingSettings.domainSettingsSection.security.applySecureSettingsPreset' => 'Bruk forhåndsdefinerte sikkerhetsinnstillinger',
    'HostingSettings.domainSettingsSection.security.exploreSecureSettings' => 'Les mer om sikre innstillinger for hosting',
    'HostingSettings.domainSettingsSection.security.sslTlsSupport' => 'SSL/TLS-støtte',
    'HostingSettings.domainSettingsSection.security.sslTlsSupportEnabled' => 'Aktivert',
    'HostingSettings.domainSettingsSection.security.sslTlsSupportDescription' => 'Krypter tilkoblinger mellom nettstedet og den besøkendes nettleser.',
    'HostingSettings.domainSettingsSection.security.certificate' => 'Sertifikat',
    'HostingSettings.domainSettingsSection.security.certificateDescription' => 'For å aktivere HTTPS, må du laste opp et SSL-/TLS-sertifikat til domenets lager, og deretter velge det der.',
    'HostingSettings.domainSettingsSection.security.permanentRedirect' => 'Omdirigerer brukere fra HTTP til HTTPS via en SEO-vennlig 301-omdirigering',
    'HostingSettings.domainSettingsSection.security.noCertificates' => 'Det er ingen SSL/TLS-sertifikater i ditt depot. Får å legge til et sertifikat, gå til %%link%%.',
    'HostingSettings.domainSettingsSection.security.noCertificatesLink' => 'Denne siden',
    'HostingSettings.domainSettingsSection.security.certificateFromDomainRepository' => '%%name%% (%%repository%%)',
    'HostingSettings.domainSettingsSection.security.certificateFromOtherRepository' => '%%name%% (annet lager)',
    'HostingSettings.domainSettingsSection.security.certificateNotSelected' => 'Ikke avmerket',
    'HostingSettings.domainSettingsSection.webScripting.title' => 'Webskripting',
    'HostingSettings.domainSettingsSection.webScripting.description' => 'Velg hvilke programmerings- og skriptspråk som skal tolkes av webserveren.',
    'HostingSettings.domainSettingsSection.webScripting.fastCgi' => 'FastCGI',
    'HostingSettings.domainSettingsSection.webScripting.cgi' => 'CGI',
    'HostingSettings.domainSettingsSection.webScripting.cgiReadonly' => 'cgi-bin mappen er plassert i %%value%%',
    'HostingSettings.domainSettingsSection.webScripting.ssi' => 'SSI',
    'HostingSettings.domainSettingsSection.webScripting.ssiHtml' => 'Bruk SSI for *.htm, *.html filer',
    'HostingSettings.domainSettingsSection.webScripting.asp' => 'Microsoft ASP',
    'HostingSettings.domainSettingsSection.webScripting.aspDotNet' => 'Microsoft ASP.NET',
    'HostingSettings.domainSettingsSection.webScripting.aspDotNetVersion' => 'Microsoft ASP.NET-versjon',
    'HostingSettings.domainSettingsSection.webScripting.perl' => 'Perl',
    'HostingSettings.domainSettingsSection.webScripting.python' => 'Python',
    'HostingSettings.domainSettingsSection.webScripting.customErrorDocuments' => 'Brukerdefinerte feildokumenter',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.title' => 'cgi-bin-mappen er plassert i',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.wwwRoot' => 'dokumentroten for dette domenet',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.webspace' => 'rotmappen for webområde',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.oldStyle' => 'rottilgang av gammel type for dette domenet',
    'HostingSettings.domainSettingsSection.webScripting.errorDocs' => 'Brukerdefinerte feildokumenter',
    'HostingSettings.domainSettingsSection.webScripting.writeModify' => 'Ekstra skrive/modifiseringstillatelser',
    'HostingSettings.domainSettingsSection.webScripting.webDeploy' => 'Web Deploy-publisering',
    'HostingSettings.domainSettingsSection.webStatistics.title' => 'Web statistikk',
    'HostingSettings.domainSettingsSection.webStatistics.tool' => 'Verktøy',
    'HostingSettings.domainSettingsSection.webStatistics.webstatProtected' => 'Beskytt tilgangen til nettstatistikk med FTP brukernavn og passord',
    'HostingSettings.domainSettingsSection.webStatistics.disabled' => 'Deaktivert',

    'HostingSettings.webspaceSettingsSection.sectionTitle' => 'Nettsted innstillinger',
    'HostingSettings.webspaceSettingsSection.ipAddresses' => 'IP-adresser',
    'HostingSettings.webspaceSettingsSection.quota.title' => 'Diskplasskvote',
    'HostingSettings.webspaceSettingsSection.quota.enabled' => 'Aktivert',
    'HostingSettings.webspaceSettingsSection.quota.description' => 'Forby handlinger på nettstedets filer hvis diskplasskvoten som er angitt i abonnementsinnstillingene (hvis aktuelt) overskrides.',
    'HostingSettings.webspaceSettingsSection.quota.unlimitedDesc' => 'Diskplasskvoten støttes ikke på grunn av serverens filsystemkonfigurasjon.',
    'HostingSettings.webspaceSettingsSection.quota.mbUnits' => 'MB',
    'HostingSettings.webspaceSettingsSection.quota.readonly' => '%%quota%% MB',
    'HostingSettings.webspaceSettingsSection.systemUser' => 'Systembrukerbevis',
    'HostingSettings.webspaceSettingsSection.systemUserUnixDesc' => 'Administrer nettstedet filer og mapper via FTP eller filadministrator. Få tilgang til serveren via SSH hvis tillatt.',
    'HostingSettings.webspaceSettingsSection.systemUserWinDesc' => 'Administrer nettstedet filer og mapper via FTP eller filadministrator. Få tilgang til serveren via fjernskrivebord hvis tillatt.',
    'HostingSettings.webspaceSettingsSection.systemUserLogin' => 'Brukernavn',
    'HostingSettings.webspaceSettingsSection.systemUserPasswd' => 'Passord',
    'HostingSettings.webspaceSettingsSection.systemUserPasswdDesc' => 'Angi et nytt passord her her for å endre systembrukerens passord.',
    'HostingSettings.webspaceSettingsSection.shell.unixTitle' => 'SSH-tilgang',
    'HostingSettings.webspaceSettingsSection.shell.winTitle' => 'Fjerntilgang',
    'HostingSettings.webspaceSettingsSection.shell.enabled' => 'Aktivert',
    'HostingSettings.webspaceSettingsSection.shell.description' => "Få tilgang til serveren med systemets brukeropplysninger.",
    'HostingSettings.webspaceSettingsSection.shell.type' => 'Type',
    'HostingSettings.webspaceSettingsSection.shell.disabled' => 'Deaktivert',
    'HostingSettings.webspaceSettingsSection.affectedDomainsLabel' => 'For {count, plural, other {# domener}}',
    'HostingSettings.webspaceSettingsSection.affectedDomainsDescription' => 'Følgende innstillinger gjelder for alle {count, plural, other {# domener på webspacet {name}}}:',

    'OdbcAdd.title' => 'Legg til ODBC DSN',
    'OdbcAdd.nameLabel' => 'Tilkoblingsnavn',
    'OdbcAdd.descriptionLabel' => 'Koblingsbeskrivelse',
    'OdbcAdd.driver' => 'Driver',
    'OdbcAdd.submit' => 'Opprett ODBC DSN',

    'OdbcEdit.title' => 'Konfigurer en ODBC kobling',
    'OdbcEdit.saveSuccess' => 'Tilkoblingsinnstillinger ble lagret.',
    'OdbcEdit.test' => 'Test tilkobling',
    'OdbcEdit.connectSuccess' => 'Tilkobling opprettet.',

    'OdbcEdit.excel.driver.label' => 'Driver',
    'OdbcEdit.excel.dbq.label' => 'Databasefilbane',
    'OdbcEdit.excel.defaultdir.label' => 'Standard datamappe',
    'OdbcEdit.excel.fil.label' => 'Databaseversjon',
    'OdbcEdit.excel.maxbuffersize.label' => 'Maks bufferstørrelse',
    'OdbcEdit.excel.pagetimeout.label' => 'Tidsavbrudd for side',

    'OdbcEdit.access.driver.label' => 'Driver',
    'OdbcEdit.access.dbq.label' => 'Databasefilbane',
    'OdbcEdit.access.uid.label' => 'Påloggings-ID',
    'OdbcEdit.access.pwd.label' => 'Passord',
    'OdbcEdit.access.pagetimeout.label' => 'Tidsavbrudd for side',
    'OdbcEdit.access.pagetimeout.description' => 'Tidsperioden, i tiendels sekunder, som en ubrukt side forblir i bufferet. Dette alternativet gjelder for datakildene som bruker Microsoft Access-driveren.',
    'OdbcEdit.access.maxbuffersize.label' => 'Maks bufferstørrelse',
    'OdbcEdit.access.maxbuffersize.description' => 'Størrelsen på det interne bufferet, i KB, plassert på en 256 KB grenselinje.',
    'OdbcEdit.access.readonly.label' => 'Skrivebeskyttet',
    'OdbcEdit.access.readonly.description' => 'Angir database som skrivebeskyttet for å hindre alle oppdateringer.',
    'OdbcEdit.access.exclusive.label' => 'Eksklusivt',
    'OdbcEdit.access.exclusive.description' => 'Angir databasen som eksklusiv for å nekte delte oppdateringer.',
    'OdbcEdit.access.safetransactions.label' => 'Sikre transaksjoner',
    'OdbcEdit.access.safetransactions.description' => 'Hvis den er satt til 0 (standardinnstillingen), vil transaksjoner bli utført umiddelbart. Hvis satt til 1, lagres alle transaksjoner på disken bare ved en skriveoperasjon, men ytelsen blir en anelse mindre.',
    'OdbcEdit.access.threads.label' => 'Tråder',
    'OdbcEdit.access.threads.description' => 'Antall bakgrunnstråder som maskinen kan bruke.',
    'OdbcEdit.access.maxscanrows.label' => 'Maks antall rader å skanne',
    'OdbcEdit.access.maxscanrows.description' => 'Antall rader som skal skannes når kolonnens datatype skal settes basert på eksisterende data.',
    'OdbcEdit.access.implicitcommitsync.label' => 'ImplicitCommitSync',
    'OdbcEdit.access.implicitcommitsync.description' => 'Angir hvordan endringer gjort utenfor en transaksjon skrives til databasen.',
    'OdbcEdit.access.usercommitsync.label' => 'UserCommitSync',
    'OdbcEdit.access.usercommitsync.description' => 'Angir om MS Access-driveren utfører eksplisitte brukerdefinerte transaksjoner asynkront.',

    'OdbcEdit.mssql.driver.label' => 'Driver',
    'OdbcEdit.mssql.server.label' => 'Server',
    'OdbcEdit.mssql.uid.label' => 'Påloggings-ID',
    'OdbcEdit.mssql.pwd.label' => 'Passord',
    'OdbcEdit.mssql.database.label' => 'Standard database',
    'OdbcEdit.mssql.app.label' => 'Applikasjonsnavn',
    'OdbcEdit.mssql.wsid.label' => 'Arbeidsstasjon-ID',
    'OdbcEdit.mssql.language.label' => 'Standardspråk',
    'OdbcEdit.mssql.oemtoansi.label' => 'Konvertering av utvidede tegn til OEM verdier',

    'OdbcEdit.mysql.driver.label' => 'MySQL ODBC driver',
    'OdbcEdit.mysql.server.label' => 'Server',
    'OdbcEdit.mysql.server.description' => 'Vertsnavn på MariaDB/MySQL-server',
    'OdbcEdit.mysql.database.label' => 'Standard database',
    'OdbcEdit.mysql.user.label' => 'Brukernavn',
    'OdbcEdit.mysql.user.description' => 'Brukernavnet som benyttes for å koble til MariaDB/MySQL',
    'OdbcEdit.mysql.password.label' => 'Passord',
    'OdbcEdit.mysql.password.description' => 'Passordet for brukerkontoen på serveren',
    'OdbcEdit.mysql.port.label' => 'Port',
    'OdbcEdit.mysql.port.description' => 'TCP/IP-port som skal brukes hvis serveren port to use if the server is not the local host',
    'OdbcEdit.mysql.socket.label' => 'Socket',
    'OdbcEdit.mysql.socket.description' => 'Windows navngitt datakanal du kan koble til hvis serveren er den lokale verten',
    'OdbcEdit.mysql.option.label' => 'Alternativ',
    'OdbcEdit.mysql.option.description' => 'Valgmuligheter som spesifiserer hvordan MyODBC skal fungere. Se <a target="_blank" href="https://www.linuxtopia.org/online_books/database_guides/mysql_5.1_database_reference_guide_OLD/connection-parameters.html">dokumentasjon.</a>',

    'ProtectedDirectoryList.add' => 'Legg til beskyttet mappe.',
    'ProtectedDirectoryList.addTooltip' => 'Opprett en beskyttet mappe.',
    'ProtectedDirectoryList.name' => 'Navn',
    'ProtectedDirectoryList.realmTitle' => 'Tittel på beskyttet område',
    'ProtectedDirectoryList.noSelectionText' => 'Velg ett eller flere elementer for fjerning.',
    'ProtectedDirectoryList.edit' => 'Rediger',
    'ProtectedDirectoryList.remove' => 'Fjern beskyttelse',
    'ProtectedDirectoryList.removeTooltip' => 'Fjern beskyttelse fra de valgte mappene.',
    'ProtectedDirectoryList.removeConfirmation' => 'Denne operasjonen fører til fjerning av beskyttelse fra {count, plural, =1 {mappen {name}} one {mappen {name}} other {# valgte mapper}}. {count, plural, =1 {Denne mappen} one {Denne mappen} other {Mappene}} blir fritt tilgjengelig for internettbrukere.',
    'ProtectedDirectoryList.removeSuccess' => 'De valgte mappene ble fjernet.',

    'ProtectedDirectoryAdd.title' => 'Opprett en beskyttet mappe',
    'ProtectedDirectoryAdd.submit' => 'Opprett',
    'ProtectedDirectoryAdd.success' => 'Den beskyttete mappen %%path%% ble opprettet',

    'ProtectedDirectoryEdit.title' => 'Innstillinger for beskyttede mapper',
    'ProtectedDirectoryEdit.success' => 'Innstillingene for beskyttet mappe ble endret',

    'ProtectedDirectoryUserAdd.title' => 'Opprett bruker av beskyttet katalog',
    'ProtectedDirectoryUserAdd.subtitle' => 'Katalog %%directory%%',
    'ProtectedDirectoryUserAdd.loginLabel' => 'Brukernavn',
    'ProtectedDirectoryUserAdd.passwordLabel' => 'Passord',
    'ProtectedDirectoryUserAdd.submit' => 'Opprett',
    'ProtectedDirectoryUserAdd.success' => 'Bruker %%login%% av den beskyttede katalogen ble opprettet.',

    'ProtectedDirectoryUserPassword.title' => 'Brukerpassord for beskyttet katalog',
    'ProtectedDirectoryUserPassword.subtitle' => 'Bruker %%login%%',
    'ProtectedDirectoryUserPassword.passwordLabel' => 'Passord',
    'ProtectedDirectoryUserPassword.submit' => 'Lagre',
    'ProtectedDirectoryUserPassword.success' => 'Brukerens legitimasjon ble lagret.',

    'SummaryReport.Layout.title' => 'Egenskaper for rapportoppsett',
    'SummaryReport.Layout.success' => 'Rapportoppsett %%name%% ble oppdatert.',

    'SummaryReport.Layout.Add.title' => 'Generer rapport oppsett',
    'SummaryReport.Layout.Add.success' => 'Rapportoppsett %%name%% ble opprettet.',

    'SummaryReport.Report.buttonLayouts' => 'Oppsett',
    'SummaryReport.Report.buttonSchedule' => 'Tidsplan',
    'SummaryReport.Report.buttonProperties' => 'Egenskaper',
    'SummaryReport.Report.buttonTrafficHistory' => 'Trafikkhistorie',
    'SummaryReport.Report.buttonPrint' => 'Skriv ut',
    'SummaryReport.Report.buttonSend' => 'Send som e-post',
    'SummaryReport.Report.successSent' => 'Rapporten ble sendt til %%email%%',

    'SummaryReport.Schedule.Properties.title' => 'Leveringsskjema for %%name%%',
    'SummaryReport.Schedule.Properties.success' => 'Tidsplan for rapportleveranse ble oppdatert.',

    'SummaryReport.Schedule.Add.title' => 'Opprett leveringsskjemaer for %%name%%',
    'SummaryReport.Schedule.Add.success' => 'Tidsplan for rapportlevering ble opprettet.',

    'VirtualDirectory.errNotExist' => 'Den virtuelle katalogen er koblet til fysisk mappe som ikke finnes.',
    'VirtualDirectory.errNoPermissions' => 'Du har ikke tillatelser til å vise innholdet i denne katalogen.',
    'VirtualDirectory.buttonProperties' => 'Egenskaper for mappe',
    'VirtualDirectory.buttonPropertiesHint' => 'Vis og endre egenskaper for virtuell mappe',
    'VirtualDirectory.buttonPermissions' => 'Tilgangstillatelser for mappen',
    'VirtualDirectory.buttonPermissionsHint' => 'Sett opp tilgangstillatelser for mappen.',
    'VirtualDirectory.buttonAspDotNet' => 'ASP.NET',
    'VirtualDirectory.buttonAspDotNetHint' => 'Konfigurer ASP.NET-innstillinger.',
    'VirtualDirectory.buttonPhp' => 'PHP',
    'VirtualDirectory.buttonPhpHint' => 'Konfigurer PHP-innstillinger.',
    'VirtualDirectory.tabBrowse' => 'Kataloger',
    'VirtualDirectory.tabBrowseHint' => 'Arbeid med fysiske og virtuelle filer og mapper under nettsted %%site%%.',
    'VirtualDirectory.tabMimeTypes' => 'MIME-typer',
    'VirtualDirectory.tabMimeTypesHint' => 'Administrer registrerte MIME-typer.',
    'VirtualDirectory.tabErrorDocs' => 'Feildokumenter',
    'VirtualDirectory.tabErrorDocsHint' => 'Administrer feildokumenter.',
    'VirtualDirectory.tabProtection' => 'Beskyttelse',
    'VirtualDirectory.tabProtectionHint' => 'Begrens tilgang til mappen med passordbeskyttelse.',

    'VirtualDirectory.errorDocType.default' => 'Standard',
    'VirtualDirectory.errorDocType.file' => 'Fil',
    'VirtualDirectory.errorDocType.url' => 'URL',

    'VirtualDirectory.CreateDirectory.title' => 'Opprett mappe',
    'VirtualDirectory.CreateDirectory.name' => 'Mappenavn',
    'VirtualDirectory.CreateDirectory.success' => 'Katalogen %%name%% ble opprettet.',
    'VirtualDirectory.CreateDirectory.errExists' => 'Katalogen med navn %%name%% finnes allerede.',

    'VirtualDirectory.CreateVirtualDirectory.title' => 'Opprett virtuell katalog',
    'VirtualDirectory.CreateVirtualDirectory.success' => 'Katalogen %%name%% ble opprettet.',

    'VirtualDirectory.EditVirtualDirectory.title' => 'Egenskaper for virtuell mappe',
    'VirtualDirectory.EditVirtualDirectory.success' => 'Den virtuelle mappen ble redigert.',
    'VirtualDirectory.EditVirtualDirectory.close' => 'Lukk',

    'VirtualDirectory.MimeTypeList.add' => 'Legg til MIME-type',
    'VirtualDirectory.MimeTypeList.edit' => 'Rediger MIME-type',
    'VirtualDirectory.MimeTypeList.addHint' => 'Registrer en ny MIME type.',
    'VirtualDirectory.MimeTypeList.columnExtension' => 'Filtype',
    'VirtualDirectory.MimeTypeList.columnContent' => 'Innhold',
    'VirtualDirectory.MimeTypeList.noSelectionText' => 'Velg ett eller flere elementer for fjerning.',
    'VirtualDirectory.MimeTypeList.removeConfirmation' => 'Vil du fjerne {count, plural, =1 {den valgte MIME-typen} one {# valgt MIME-type} other {# valgte MIME-typer}}?',
    'VirtualDirectory.MimeTypeList.removeSuccess' => 'De valgte MIME-typene ble fjernet.',

    'VirtualDirectory.CreateMimeType.title' => 'Legg til MIME-type',
    'VirtualDirectory.CreateMimeType.success' => 'Den nye MIME-typen ble registrert.',

    'VirtualDirectory.EditMimeType.title' => 'Rediger MIME-type',
    'VirtualDirectory.EditMimeType.success' => 'MIME-typen ble redigert.',

    'VirtualDirectory.ErrorDocList.columnCode' => 'Feil',
    'VirtualDirectory.ErrorDocList.columnName' => 'Beskrivelse',
    'VirtualDirectory.ErrorDocList.columnType' => 'Type',
    'VirtualDirectory.ErrorDocList.columnLocation' => 'Plassering',
    'VirtualDirectory.ErrorDocList.edit' => 'Rediger',

    'VirtualDirectory.EditErrorDoc.title' => 'Rediger feildokument',
    'VirtualDirectory.EditErrorDoc.success' => 'Feildokumentet ble redigert.',

    'VirtualDirectory.EditErrorDoc.EditErrorDocForm.error' => 'Feil',
    'VirtualDirectory.EditErrorDoc.EditErrorDocForm.type' => 'Type',
    'VirtualDirectory.EditErrorDoc.EditErrorDocForm.location' => 'Plassering',

    'VirtualDirectory.Protection.notSupported' => 'Mappebeskyttelse støttes ikke for denne mappen fordi navnet overskrider 245 tegn eller inneholder tegn som ikke støttes.',
    'VirtualDirectory.Protection.NoProtectionView.title' => 'Beskyttelse av den virtuelle mappen er deaktivert',
    'VirtualDirectory.Protection.NoProtectionView.protect' => 'Beskytt',
    'VirtualDirectory.Protection.NoProtectionView.successProtection' => 'Katalogen %%path%% ble beskyttet.',
    'VirtualDirectory.Protection.tools' => 'Verktøy',
    'VirtualDirectory.Protection.removeProtection' => 'Fjern beskyttelse',
    'VirtualDirectory.Protection.removeProtectionTooltip' => 'Opprett en URL-adresse som samsvarer med mappen som er tilgjengelig for alle.',
    'VirtualDirectory.Protection.removeProtectionConfirmation' => 'Vil du fjerne beskyttelsen av den virtuelle katalogen? Dette fjerner også alle beskyttede katalogbrukere og beskyttelsesinnstillingene for katalogen.',
    'VirtualDirectory.Protection.settings' => 'Innstillinger',
    'VirtualDirectory.Protection.settingsTooltip' => 'Vis mappens plassering og angi tittel for det beskyttede området.',

    'VirtualDirectory.AspDotNet.title' => 'Konfigurer ASP.NET-innstillinger',

    'VirtualDirectory.Php.title' => 'PHP-versjon',
    'VirtualDirectory.Php.version' => 'Versjon',
    'VirtualDirectory.Php.success' => 'PHP-versjon ble oppdatert.',


    'MassMailPage.sendEmail' => 'Send massepost',
    'MassMailPage.selectAtLeastOneTemplate' => 'Velg minst én mal',
    'MassMailPage.confirmRemoval' => 'Er du sikker på at du vil fjerne {count, select, 1 {den valgte malen} other {de valgte malene?}}?',
    'MassMailPage.remove' => 'Fjern',
    'MassMailPage.filters' => 'Filtre',
    'MassMailPage.name' => 'Malnavn',
    'MassMailPage.sender' => 'Avsender',
    'MassMailPage.recipients' => 'Mottakere',
    'MassMailPage.subject' => 'Emne',
    'MassMailPage.created' => 'Opprettelsesdato',
    'MassMailPage.send' => 'Send',
    'MassMailPage.recipientsNone' => 'Ingen',
    'MassMailPage.recipientsAdmins' => 'Administrator',
    'MassMailPage.recipientsResellers' => 'Alle forhandlere',
    'MassMailPage.recipientsResellersSelected' => 'Valgte forhandlere',
    'MassMailPage.recipientsResellersExcept' => 'Alle forhandlere unntatt valgte',
    'MassMailPage.recipientsClients' => 'Alle kunder',
    'MassMailPage.recipientsClientsSelected' => 'Valgte kunder',
    'MassMailPage.recipientsClientsExcept' => 'Alle kunder unntatt valgte',
    'MassMailPage.templatesRemoved' => 'Fjernet {count, select, 1 {malen} other {malene}}.',
    'MassMailPage.emptyViewTitle' => 'Det finnes ingen e-postmaler for masseutsendelser',
    'MassMailPage.addNew' => 'Opprett mal',
    'CreateMassMailTemplatePage.templateCreated' => 'Malen ble opprettet.',
    'EditMassMailTemplatePage.templateUpdated' => 'Malen ble endret.',
    'SendMassMailPage.emailSent' => 'E-posten ble sendt.',
    'SendMassMailPage.fieldIsRequired' => 'Feltet kan ikke være tomt',
    'SendMassMailPage.saveAsTemplate' => 'Lagre meldingen i en ny mal',
    'SendMassMailPage.newTemplateName' => 'Nytt malnavn',
    'SendMassMailPage.selectedTemplate' => 'Valgt mal',
    'SendMassMailPage.send' => 'Send',
    'VirtualHostTemplatePage.name' => 'Navn',
    'VirtualHostTemplatePage.sizeInBytes' => 'Størrelse',
    'VirtualHostTemplatePage.modified' => 'Endringsdato',
    'VirtualHostTemplatePage.permissions' => 'Tillatelser',
    'VirtualHostTemplatePage.user' => 'Bruker',
    'VirtualHostTemplatePage.group' => 'Gruppe',
    'VirtualHostTemplatePage.uploadTemplate' => 'Last opp',
    'VirtualHostTemplatePage.succesfullyUploaded' => 'Malen ble lastet opp.',
    'VirtualHostTemplatePage.root' => 'Virtuell malmappe',
    'VirtualHostTemplatePage.emptyViewTitle' => 'Ingen filer i malen',
    'VirtualHostTemplatePage.total' => 'Totalt antall elementer i mappen {breadcrumbs}: {total}',
    'VirtualHostTemplatePage.resetTemplate' => 'Angi standard',
    'VirtualHostTemplatePage.successfullyReset' => 'Malen ble endret til standard.',

    'TrafficUsageByDomain.List.service' => 'Tjeneste',
    'TrafficUsageByDomain.List.usage' => 'Brukt',
    'TrafficUsageByDomain.List.incoming' => 'Inn',
    'TrafficUsageByDomain.List.outgoing' => 'Ut',
    'TrafficUsageByDomain.List.percentOfAll' => '% av alle',

    'TrafficUsageByDomains.Viewer.List.domainName' => 'Domenenavn',
    'TrafficUsageByDomains.Viewer.List.clientName' => "Eiernavn",
    'TrafficUsageByDomains.Viewer.List.totalUsage' => 'Brukt',
    'TrafficUsageByDomains.Viewer.List.subscriptionLimit' => 'Grense',
    'TrafficUsageByDomains.Viewer.List.subscriptionLimitRemaining' => 'Tilgjengelig',
    'TrafficUsageByDomains.Viewer.List.subscriptionLimitUsagePercent' => 'Brukt (i %)',
    'TrafficUsageByDomains.Viewer.Filters.ownOnly' => 'Kun mine domener',
    'TrafficUsageByDomains.Viewer.Filters.resellerOnly' => 'Kun forhandlerdomener',
    'TrafficUsageByDomains.Viewer.Filters.clientName' => 'Eiernavn',

    'TrafficUsageByReseller.emptyView' => 'Forhandleren har ingen kunder',
    'TrafficUsageByReseller.TotalUsage.usageByResellerDomains' => '%%resellerDomainsLink%%: %%usage%%',
    'TrafficUsageByReseller.TotalUsage.resellerDomains' => "Forhandlerens egne domener",
    'TrafficUsageByReseller.TotalUsage.usageByCustomerDomains' => "Reseller customers' domains: %%usage%%",

    'InfoAndStatistics.Main.title' => 'Informasjon og statistikk',
    'InfoAndStatistics.Main.overview' => 'Oversikt',
    'InfoAndStatistics.Main.domains' => 'Domener',
    'InfoAndStatistics.Main.trafficUsage' => 'Trafikkforbruk',
    'InfoAndStatistics.Main.reports' => 'Rapporter',
    'InfoAndStatistics.Main.serverSettings' => 'Serverinnstillinger',
    'InfoAndStatistics.TrafficUsage.customers' => 'Kunder',
    'InfoAndStatistics.TrafficUsage.resellers' => 'Videreforhandler',
    'InfoAndStatistics.TrafficUsage.domains' => 'Domener',

    'ConfigureMailClient.title' => 'Choose Mail Client to configure',
    'ConfigureMailClient.description' => 'for %%email%%',
    'ConfigureMailClient.thunderbird' => 'Thunderbird',
    'ConfigureMailClient.manual' => 'Manuell',
    'ConfigureMailClient.Common.email' => 'E-post:',
    'ConfigureMailClient.Common.start' => 'Start',
    'ConfigureMailClient.Common.finish' => 'Fullfør',
    'ConfigureMailClient.Common.next' => 'Neste',
    'ConfigureMailClient.Common.prev' => 'Forr.',
    'ConfigureMailClient.Common.back' => 'Tilbake',
    'ConfigureMailClient.Common.manualLink' => 'Auto-configuration failed? Try manual Setup',
    'ConfigureMailClient.Thunderbird.title' => 'Follow the instruction to configure Thunderbird',
    'ConfigureMailClient.Thunderbird.description' => 'Open Mozilla Thunderbird on you computer. Plesk support any Thunderbird version on any OS',
    'ConfigureMailClient.Thunderbird.step1.title' => 'Open Thunderbird',
    'ConfigureMailClient.Thunderbird.step1.description' => 'Find ”Account settings” in Thunderbird main menu',
    'ConfigureMailClient.Thunderbird.step2.title' => 'Create New Mail Account',
    'ConfigureMailClient.Thunderbird.step2.description' => 'Click ”Account Actions” and choose ”Add Mail Account”',
    'ConfigureMailClient.Thunderbird.step3.title' => 'Legg inn følgende',
    'ConfigureMailClient.Thunderbird.step3.description' => 'Navnet ditt, slik du vil det skal se ut i meldingene dine.',
    'ConfigureMailClient.Thunderbird.step4.title' => 'Wait until auto-configuration will be ready',
    'ConfigureMailClient.Thunderbird.step4.description' => 'Thunderbird will find the settings automatically',

    'ConfigureMailClient.Outlook.title' => 'Follow the instruction to configure Outlook',
    'ConfigureMailClient.Outlook.warning' => 'Autodiscover is not compatible with Outlook version later 2019',
    'ConfigureMailClient.Outlook.warningTooltip' => 'Autodiscover is not compatible with Outlook version later 2019. These mail clients use Microsoft proxy servers for autodiscover requests, which is not supported in Plesk and Plesk Premium Email extension.',
    'ConfigureMailClient.Outlook.description' => 'Open Microsoft Office Outlook 2016 on your computer',
    'ConfigureMailClient.Outlook.step1.title' => 'Add new account',
    'ConfigureMailClient.Outlook.step1.description' => 'Gå til Fil > Legg til konto',
    'ConfigureMailClient.Outlook.step2.title' => 'Legg inn følgende',
    'ConfigureMailClient.Outlook.step2.description' => 'Navnet ditt, slik du vil det skal se ut i meldingene dine.',
    'ConfigureMailClient.Outlook.step3.title' => 'Wait until set up completes',
    'ConfigureMailClient.Outlook.step3.description1' => 'To exit the setup, click ”Finish”.',
    'ConfigureMailClient.Outlook.step3.description2' => 'To see the configured settings, select the “Change account settings” checkbox and then click ”Finish”',

    'ConfigureMailClient.Gmail.title' => 'Follow the instruction to configure Gmail on Android',
    'ConfigureMailClient.Gmail.description' => 'Open Gmail application on your mobile phone',
    'ConfigureMailClient.Gmail.step1.title' => 'Add new account',
    'ConfigureMailClient.Gmail.step1.description1' => 'In the top right corner, tap your profile picture and tap Add another account.',
    'ConfigureMailClient.Gmail.step1.description2' => 'Choose “Other”',
    'ConfigureMailClient.Gmail.step2.title' => 'Enter your email address',
    'ConfigureMailClient.Gmail.step2.description' => 'and then tap Next',
    'ConfigureMailClient.Gmail.step3.title' => 'Choose the account type and tap Next',
    'ConfigureMailClient.Gmail.step3.description' => 'To keep the copies of email messages on the server, select the IMAP option. If you do not want to keep them on the server, select POP3',
    'ConfigureMailClient.Gmail.step4.title' => 'Specify your email account password',
    'ConfigureMailClient.Gmail.step4.description' => 'and then tap Next',
    'ConfigureMailClient.Gmail.step5.title' => 'Choose email settings',
    'ConfigureMailClient.Gmail.step5.description' => 'The application will automatically fetch the incoming server settings. Select whether deleting emails from Inbox will also delete them from your Plesk server or not and tap Next.',
    'ConfigureMailClient.Gmail.step6.title' => 'Outgoing settings',
    'ConfigureMailClient.Gmail.step6.description1' => 'The application will automatically fetch the outgoing server settings. Tap Next.',
    'ConfigureMailClient.Gmail.step6.description2' => 'Keep the default Gmail sync settings or change them and tap Next.',
    'ConfigureMailClient.Gmail.step7.title' => 'Set up is done',
    'ConfigureMailClient.Gmail.step7.description1' => '(Optional) Change the account name and/or specify the name that will be displayed on sent messages',
    'ConfigureMailClient.Gmail.step7.description2' => 'Tap Next to exit the setup.',

    'ConfigureMailClient.Ios.title' => 'Scan QR code with your iPhone camera',
    'ConfigureMailClient.Ios.description' => 'Email client will be set up automatically. Or open the following link on the device:',
    'ConfigureMailClient.Ios.link'  =>  'Set up iOS Mail Client',

    'ConfigureMailClient.Manual.title' => 'Manual Configuration',
    'ConfigureMailClient.Manual.description' => 'for %%email%%',
    'ConfigureMailClient.Manual.username' => 'Brukernavn for e-postserver:',
    'ConfigureMailClient.Manual.outgoingServer' => 'Outgoing mail server (requires authentication):',
    'ConfigureMailClient.Manual.incomingServer' => 'Server for innkommende e-post:',
    'ConfigureMailClient.Manual.supportedIncomingProtocols' => 'Støttede innkommende e-postprotokoller:',
    'ConfigureMailClient.Manual.supportedOutgoingProtocols' => 'Støttede utgående e-postprotokoller:',

];