<?php
// Copyright 1999-2024. WebPros International GmbH. All rights reserved.

$messages = [
    'additional-key-info.title' => '追加キープロパティ',
    'additional-key-info.update' => '追加キーの取得',
    'additional-key-info.updateDescription' => '追加キーを取得しインストールします。',
    'additional-key-info.download' => 'キーをダウンロード',
    'additional-key-info.downloadDescription' => '現在のライセンスキーをダウンロードする',
    'additional-key-info.install' => 'キーのインストール',
    'additional-key-info.installDescription' => '現在のライセンスキーをインストールします。',
    'additional-key-info.revert' => 'キーをロールバック',
    'additional-key-info.revertDescription' => '以前にインストールしたライセンスキーに戻します。',
    'additional-key-info.revertNotAvailableDescription' => 'キーがインストールされていません。',
    'additional-key-info.installSuccess' => 'ライセンスキーのインストール作業が開始されました。',

    'additional-key-revert.title' => '追加キーのロールバック',
    'additional-key-revert.success' => '追加キーがロールバックされました。',

    'additional-key-upload.title' => 'ライセンスキーをインストールする',
    'additional-key-upload.success' => '新しい拡張キーがアップロードされました。',

    'additional-keys.title' => '追加のライセンスキー',

    'change-subscriptions-owner.title' => '選択した契約の再割り当て',
    'change-subscriptions-owner.success' => '契約の所有者が変更されました',

    'customers.hint' => 'ホスティングサービスの顧客のアカウントを管理します。サービス契約付きでアカウントを作成したり、既存リセラーの管理やアカウントの削除を行います。ウェブサイトやメールなど、顧客に提供されているサービスを管理するには、リストの右端にあるログインリンクをクリックして顧客パネルを開いてください。',

    'customer-domains.hint' => 'ウェブサイトの設定と管理を行います。',

    'customer-subscriptions.hint' => '顧客の契約を管理します。',

    'domains.hint' => 'システムに登録されたすべてのドメイン名についての情報を表示し、ホスティングサービスの管理に進むことができます。自社またはホスティング顧客用にドメインを追加するには、［ドメインを追加］をクリックしてください。 ドメインの作成時に、顧客と契約を新規作成するか、既存のものを選択するかを選ぶ必要があります。',

    'database-servers.title' => 'データベースサーバ',

    'database-server-create.title' => '新しいデータベースサーバ',

    'database-server-properties.title' => 'データベースサーバ',

    'database-server-upgrade.drawerTitle' => 'MariaDB アップグレード',
    'database-server-upgrade.drawerTitle.completed' => 'アップグレード完了',
    'database-server-upgrade.drawerSubTitle.line1' => 'アップグレードの実行中はドロワーを終了できません。',
    'database-server-upgrade.drawerSubTitle.line2' => 'アップグレード中に問題が発生した場合、%%troubleshootingArticle%% を参照してください。',
    'database-server-upgrade.drawerSubTitle.completed' => 'MariaDB データベースサーバがバージョン %%releaseVersion%% にアップグレードされました。問題が発生した場合は %%troubleshootingArticle%% の指示に従ってください。',
    'database-server-upgrade.upToDate' => 'LTS バージョンをインストール済みです。',
    'database-server-upgrade.troubleshootingArticle' => 'こちらの KB 記事',
    'database-server-upgrade.troubleshootingArticleDescription' => 'MariaDB のアップグレードに関する問題は、%%troubleshootingArticle%% を参考にトラブルシューティングしてください。',

    'database-server-upgrade.chooseReleaseStep.infoBlock.par1' => 'ローカルの MariaDB データベースサーバを最新の長期サポート（LTS）バージョンにアップグレードします。',
    'database-server-upgrade.chooseReleaseStep.infoBlock.par2' => 'アップグレードの前にサーバをバックアップすること、およびウェブサイトのオフピーク時間帯にアップグレードを開始することを強くお勧めします。',
    'database-server-upgrade.chooseReleaseStep.infoBlock.par3' => 'MariaDB のアップグレード中は Plesk サーバとホストされるウェブサイトが利用できなくなります。通常、MariaDB のアップグレードはエラーが発生せず、約 10 分で終了しますが、サーバ全体に影響を与える可能性もあります。',
    'database-server-upgrade.chooseReleaseStep.infoBlock.par4' => '注：MariaDB 5.5 を実行している場合、Plesk によってまず MariaDB 10.5 にアップグレードされます。このアップグレードが完了してから、このウィザードをもう一度開始して、MariaDB の最新の LTS バージョンにアップグレードしてください。',
    'database-server-upgrade.chooseReleaseStep.currentVersionTitle' => '現在のバージョン',
    'database-server-upgrade.chooseReleaseStep.currentMariaDBVersion' => 'MariaDB %%version%%',
    'database-server-upgrade.chooseReleaseStep.selectVersion' => 'アップグレード先のバージョンを選択してください',
    'database-server-upgrade.chooseReleaseStep.noMajorReleases' => 'メジャーリリースはありません',
    'database-server-upgrade.chooseReleaseStep.releaseNotes' => 'リリースノート',
    'database-server-upgrade.chooseReleaseStep.releaseDate' => 'リリース日：%%date%%',
    'database-server-upgrade.chooseReleaseStep.endOfLifeDate' => 'EOL：%%date%%',
    'database-server-upgrade.chooseReleaseStep.notDetected' => 'OS ベンダーまたは MariaDB ベンダーの提供した MariaDB フォークのみをアップグレードできます。',

    'database-server-upgrade.preUpgradeCheckProgressStep.title' => 'アップグレード前のチェック',
    'database-server-upgrade.preUpgradeCheckProgressStep.configChecker' => 'MariaDB 構成ファイルを解析中',
    'database-server-upgrade.preUpgradeCheckProgressStep.mysqlChecker' => 'mysqlcheck でデータベースを分析中',
    'database-server-upgrade.preUpgradeCheckProgressStep.packageManagerChecker' => 'パッケージマネージャの構成を分析中',
    'database-server-upgrade.preUpgradeCheckProgressStep.systemCompatibilityChecker' => 'システムの互換性をチェック中',
    'database-server-upgrade.preUpgradeCheckProgressStep.webSocketChecker' => 'WebSocket をチェック中',

    'database-server-upgrade.preUpgradeCheckStep.shouldBeConfirmed' => 'アップグレードを続けるには、すべてのチェックボックスをオンにしてください。アップグレードによって構成に変更が加えられることに同意すること、および復元オプションにアクセスできることを確認していただく必要があります。',
    'database-server-upgrade.preUpgradeCheckStep.removedSystemVariables' => '新しいバージョンとの互換性のために、以下の変数は削除されます。',
    'database-server-upgrade.preUpgradeCheckStep.fromFiles' => '{count, plural, other {# ファイル：{files}}} の {variable}',
    'database-server-upgrade.preUpgradeCheckStep.accessToolsSection' => '復元オプションへのアクセス（サーバのコマンドラインコンソールおよび Repair Kit）',
    'database-server-upgrade.preUpgradeCheckStep.sshAccess' => '私はサーバに SSH アクセスできます',
    'database-server-upgrade.preUpgradeCheckStep.sshAccessDescription' => 'SSH クライアントを使用するか、%%sshTerminalExtension%% を新しいブラウザタブで開いてください（アップグレードが終了するまで、SSH ターミナル拡張のウィンドウを閉じないでください）。アップグレードが失敗した場合、SSH アクセスができると復旧に役立ちます。',
    'database-server-upgrade.preUpgradeCheckStep.sshTerminalExtension' => 'SSH ターミナル拡張',
    'database-server-upgrade.preUpgradeCheckStep.repairKitAccess' => '私は Repair Kit にアクセスできます',
    'database-server-upgrade.preUpgradeCheckStep.repairKitAccessDescription' => '%%repairKit%% を新しいブラウザタブで開き、管理者のログイン情報でログインしてください。アップグレードが終了するまで、SSH ターミナル拡張のウィンドウを閉じないでください。',
    'database-server-upgrade.preUpgradeCheckStep.repairKit' => 'Repair Kit',
    'database-server-upgrade.preUpgradeCheckStep.dumpSection' => 'データベースのバックアップ',
    'database-server-upgrade.preUpgradeCheckStep.withDump' => 'アップグレードの前に、サーバでホストされているすべてのデータベースをバックアップする',
    'database-server-upgrade.preUpgradeCheckStep.withDumpDescription' => 'Plesk はデータベースのバックアップを %%path%% ディレクトリに保存します。',
    'database-server-upgrade.preUpgradeCheckStep.webSocketNotAvailable' => 'Plesk の WebSocket は使用できません',
    'database-server-upgrade.preUpgradeCheckStep.webSocketNotAvailableDescription' => 'WebSocket なしに、アップグレードプロセスのリアルタイムの出力を見ることはできません。',

    'database-server-upgrade.submitPopover.title' => 'データが失われる可能性を回避するため、ホストされているデータベースのダンプを作成してから続行することを強くお勧めします。ダンプを作成せずに続行しますか？',

    'database-server-databases.title' => 'データベース',

    'database-server-change-password.title' => '管理者パスワード',

    'home.title' => 'ホーム',

    'license.title' => 'ライセンス情報',

    'primary-key-info.title' => 'Plesk ライセンスキー',
    'primary-key-info.update' => 'キーを取得',
    'primary-key-info.updateDescription' => '注文したライセンスキーを検索/インストールします。',
    'primary-key-info.upload' => 'キーのインストール',
    'primary-key-info.uploadDescription' => '新しいライセンスキーをアップロードしてインストールします。',
    'primary-key-info.revert' => 'キーをロールバック',
    'primary-key-info.revertDescription' => '以前にインストールしたライセンスキーに戻します。',

    'primary-key-revert.title' => 'ライセンスキーのロールバック',
    'primary-key-revert.success' => 'Plesk キーがロールバックされました。',

    'primary-key-upload.title' => 'ライセンスキーをインストールする',
    'primary-key-upload.success' => '新しい Plesk キーがアップロードされました。',

    'resellers.hint' => 'リセラー（ホスティングサービスを再販し、自分のウェブサイトをホスティングする顧客）のアカウントを管理します。サービス契約に従って、アカウントの作成、既存のリセラーの管理、アカウントの削除を行います。',

    'reseller-customers.hint' => '顧客の設定と管理を行います。',

    'reseller-domains.hint' => 'ウェブサイトの設定と管理を行います。',

    'reseller-subscriptions.hint' => 'リセラーの契約を管理します。',

    'subscriptions.hint' => '顧客がホスティングプランを利用するには、ホスティングプランを契約する必要があります。この画面で、自社のウェブサイトのホスティング用に作成した契約とともに、これらの契約を管理することができます。契約で提供するサービス（ウェブサイトやメールなど）を管理するには、リストの右側にあるリンクをクリックして契約者の顧客パネルを開いてください。',

    'server-mail-settings.title' => '設定',
    'server-mail-spam-filter.title' => 'スパムフィルタ',
    'server-mail-antivirus.title' => 'アンチウイルス',
    'server-mail-black-list.title' => 'ブラックリスト',
    'server-mail-white-list.title' => 'ホワイトリスト',
    'server-mail-queue.title' => 'メールキュー',
    'server-mail-statistics.title' => '統計',
    'server-mail-smarthost.title' => 'スマートホスト',

    'server-spam-filter.settings' => '設定',
    'server-spam-filter.black-list' => 'ブラックリスト',
    'server-spam-filter.white-list' => 'ホワイトリスト',

    'firewall.title' => 'ファイアウォール管理',
    'firewall-general.title' => '全般',
    'firewall-general.toggleStatus' => 'ファイアウォール保護',
    'firewall-general.buttonDefault' => 'デフォルトにリセット',
    'firewall-general.buttonPanic' => 'パニックモード',
    'firewall-general.confirmationDefault' => 'ファイアウォール設定をデフォルトにリセットしますか？',
    'firewall-general.confirmationPanic' => 'パニックモードをオンにしますか？ユーザは自分のドメインにアクセスできなくなり、一部のネットワークサービスの機能が停止する可能性があります。',
    'firewall-general.successDefault' => 'ファイアウォール設定がデフォルトにリセットされました。',
    'firewall-general.successPanic' => 'パニックモードが有効になりました。',
    'firewall-general.info' => 'セキュリティ上の理由により、ファイアウォールは明示的に許可された接続以外のすべての接続をブロックします。接続を許可するためにルールを作成することができます。詳細はマニュアルを参照してください。',
    'firewall-general.interfaces' => 'ネットワークインターフェース',
    'firewall-icmp.title' => 'ICMP プロトコル',
    'firewall-rules.title' => 'ファイアウォールルール',

    'dns.title' => 'DNS 設定',
    'dns-records.title' => 'ゾーンレコードテンプレート',
    'dns-soa-record.title' => 'ゾーン設定テンプレート',

    'php-handler.title' => ' %%name%% の設定',
    'php-handler.extensions.title' => '拡張',
    'php-handler.extensions.description' => 'これらの PHP 拡張の設定は、このハンドラにのみ使用されます。',
    'php-handler.extensions.descriptionShared' => 'これらは、PHP ハンドラ %%handlers%% で共通の設定であり、このハンドラを使用するすべてのウェブサイトに適用されます。',
    'php-handler.extensions.buttonManage' => 'PECL パッケージを管理',
    'php-handler.extensions.manage.title' => 'PECL パッケージを管理',
    'php-handler.extensions.manage.risks' => 'PHP 拡張はサードパーティの PECL パッケージで提供されます。インストールはご自分の責任で行ってください。',
    'php-handler.extensions.manage.description' => 'PECL パッケージのインストール、アップグレード、アンインストールを行います。変更は %%handlers%% で実行されているすべてのウェブサイトに適用されます。',
    'php-handler.extensions.manage.notFound' => '必要なパッケージがリストにない理由',
    'php-handler.extensions.manage.limitations' => 'コントロールパネルのプロバイダおよび OS ベンダーから提供された PHP 拡張はリストに表示されません。',
    'php-handler.php-ini.title' => 'php.ini',


    'ServerInformation.refresh' => "更新",
    'ServerInformation.sectionGeneral' => "全般",
    'ServerInformation.cpu' => "CPU",
    'ServerInformation.version' => "バージョン",
    'ServerInformation.os' => "オペレーティングシステム",
    'ServerInformation.key' => "Plesk ライセンスキー",
    'ServerInformation.uptime' => "アップタイム",
    'ServerInformation.uptimeValue' => "{days, plural, =0 {} other {# 日}} {hours, plural, other {# 時間}} {minutes, plural, other {# 分}}",
    'ServerInformation.sectionCpu' => "CPU 使用量",
    'ServerInformation.la1min' => "過去 1 分間",
    'ServerInformation.la5min' => "過去 5 分間",
    'ServerInformation.la15min' => "過去 15 分間",
    'ServerInformation.sectionMemory' => "メモリ使用状況",
    'ServerInformation.memoryHardware' => "ハードウェア",
    'ServerInformation.memoryTotalNoKernel' => "合計（カーネルを除く）",
    'ServerInformation.memoryTotal' => "合計",
    'ServerInformation.memoryUsed' => "使用中",
    'ServerInformation.memoryFree' => "空き",
    'ServerInformation.memoryShared' => "共有",
    'ServerInformation.memoryBuffer' => "バッファ",
    'ServerInformation.memoryCached' => "キャッシュ",
    'ServerInformation.memoryAvailable' => "使用可能",
    'ServerInformation.memoryUsage' => "使用状況",
    'ServerInformation.sectionSwap' => "スワップ使用状況",
    'ServerInformation.sectionVirtualMemory' => "仮想メモリ使用状況",
    'ServerInformation.swapTotal' => "合計",
    'ServerInformation.swapUsed' => "使用中",
    'ServerInformation.swapFree' => "空き",
    'ServerInformation.swapUsage' => "使用状況",
    'ServerInformation.sectionHarddisk' => "ハードディスク使用状況",
    'ServerInformation.harddiskDirectory' => "ファイルシステム",
    'ServerInformation.harddiskProtectedDir' => "重要なディレクトリ",
    'ServerInformation.harddiskTotal' => "合計",
    'ServerInformation.harddiskUsed' => "使用中",
    'ServerInformation.harddiskAvailable' => "使用可能",
    'ServerInformation.harddiskCapacity' => "キャパシティ",
    'ServerInformation.sectionDomains' => "ドメイン",
    'ServerInformation.activeDomains' => "アクティブ",
    'ServerInformation.inactiveDomains' => "非アクティブ",
    'ServerInformation.problemDomains' => "問題",
    'ServerInformation.refreshed' => "情報が更新されました。",

    'ServerAbout.copyright' => '© 2024 WebPros International GmbH. All rights reserved.',
    'ServerAbout.linkLicenseManagement' => 'ライセンス情報へ移動する',
    'ServerAbout.panelVersion' => 'バージョン',
    'ServerAbout.installedPatchVersion' => '#%%patch%% のアップデート',
    'ServerAbout.licenseKey' => 'ライセンスキー',
    'ServerAbout.productDescription' => 'Plesk は業界をリードする WebOps プラットフォームであり、アプリケーションやウェブサイト、ホスティングビジネスの運用、自動化、拡張に使用できます。',
    'ServerAbout.readEula' => '%%link%%',
    'ServerAbout.linkEula' => 'エンドユーザライセンス契約（EULA）',
    'ServerAbout.visitForum' => '%%link%%',
    'ServerAbout.linkForum' => 'Plesk フォーラム',
    'ServerAbout.followUs' => 'フォロー',
    'ServerAbout.visitSite' => '%%link%% でもっと詳しく',
    'ServerAbout.linkSite' => 'plesk.com',
    'ServerAbout.visitBlog' => '%%link%%',
    'ServerAbout.linkBlog' => 'Plesk ブログ',

    'ServerAbout.darkThemePromoTitle' => 'おめでとうございます',
    'ServerAbout.darkThemePromoDescription' => '魔法の子猫を見つけました。',
    'ServerAbout.darkThemePromoButton' => 'シュッ！ダークサイドへようこそ',
    'ServerAbout.darkThemeTourDescription' => 'このオプションを切り替えて、インターフェースのダークテーマを有効/無効にしましょう。',
    'ServerAbout.darkThemeTourButton' => '了解しました',

    'ts-sessions.title' => 'ターミナルサーバセッション',
    'ts-sessions-properties.title' => 'セッションのプロパティ',

    'BandwidthLimiting.bandwidthThrottling' => 'QoS がインストールされていないため帯域幅制限をコントロールすることができません',
    'BandwidthLimiting.virtualHostingRequired' => '帯域幅制限は、ウェブホスティング付きのドメインでのみ実行できます。',
    'BandwidthLimiting.bandwidthLabel' => '最大帯域幅利用率',
    'BandwidthLimiting.bandwidthHint' => '帯域幅使用率の上限は、HTTP プロトコル経由のデータ転送にのみ適用されます。',
    'BandwidthLimiting.maxConnectionLabel' => '接続数の上限',
    'BandwidthLimiting.maxConnectionHint' => '帯域幅に上限を設定する場合、ウェブサイトへの同時接続数にも上限を設定することをお勧めします。 サイトへのアクセスが大量に発生すると、ウェブサーバプロセスが増大してウェブサーバの負荷が過剰に上昇する可能性があるためです。',
    'BandwidthLimiting.kbps' => 'KB/s',
    'BandwidthLimiting.success' => '帯域幅制限の設定が変更されました。',
    'BandwidthLimiting.unlimited' => '無制限',

    'ip-address-domains.title' => '%%type%% IP アドレス %%ipAddress%% を使用しているウェブサイト',
    'ip-address-domains.site' => 'サイト',
    'ip-address-domains.setAsDefault' => 'デフォルトとして選択',
    'ip-address-domains.type-SHARED' => '共用',
    'ip-address-domains.type-EXCLUSIVE' => '専用',

    'HotlinkProtection.virtualHostingRequired' => 'ホットリンク対策は、ウェブホスティング付きのドメインでのみ実行できます。',
    'HotlinkProtection.enabledLabel' => 'ホットリンク対策を有効化',
    'HotlinkProtection.extensionsLabel' => '保護されるファイル拡張子',
    'HotlinkProtection.friendsLabel' => '許可するウェブサイトのアドレス',
    'HotlinkProtection.success' => 'ホットリンク対策の設定を変更しました',

    'Odbc.add' => 'ODBC DSN を追加',
    'Odbc.resourceUsage' => '作成済み %%used%% 件/許可 %%allowed%% 件',
    'Odbc.limitExceeded' => 'ODBC DSN 接続の上限に達しました。',
    'Odbc.unlimited' => '無制限',
    'Odbc.addTooltip' => 'ODBC データソースを追加します。',
    'Odbc.status' => 'ステータス',
    'Odbc.name' => '接続名',
    'Odbc.driver' => 'ドライバ',
    'Odbc.description' => '接続の説明',
    'Odbc.hostname' => 'ホスト名',
    'Odbc.statusSystem' => 'システムDSNです',
    'Odbc.statusConfigured' => 'DSNは設定されています。',
    'Odbc.statusNotConfigured' => 'DSNは設定されていません',
    'Odbc.noSelectionText' => '削除するアイテムを 1 つ以上選択してください。',
    'Odbc.removeConfirmation' => '{count, plural, =1 {{name} 接続} other {# 件の選択された接続}}を削除しますか？',
    'Odbc.removeSuccess' => '選択された接続は削除されました。',

    'DomainAliasSettings.title' => 'ドメインエイリアス設定',
    'DomainAliasSettings.updateSuccess' => 'ドメインエイリアス %%name%% のプロパティが変更されました。%%apacheRestartInterval%%',
    'DomainAliasSettings.apacheRestartInterval' => 'ウェブサイト設定は %%restartInterval%% 分以内に適用されます。',

    'Home.Backup.offStatus' => '有効なバックアップではありません。このファイルからデータを復元できません。',
    'Home.Backup.task-failedStatus' => 'バックアップタスクが失敗しました。',
    'Home.Backup.activeSchedule' => 'スケジュール: %%schedule%%',
    'Home.Backup.activeSchedules' => 'スケジュール: %%schedules%%',
    'Home.Backup.noSchedule' => "バックアップスケジュールが設定されていません",
    'Home.Backup.period_hourly' => '時間単位: %%schedule%%',
    'Home.Backup.period_daily' => '毎日: %%schedule%%',
    'Home.Backup.period_weekly' => '毎週: %%schedule%%',
    'Home.Backup.period_monthly' => '毎月: %%schedule%%',
    'Home.Backup.create' => 'バックアップを作成',
    'Home.Backup.schedule' => 'スケジュール',
    'Home.ChangeLog.seeHistory' => '変更履歴を見る',
    'Home.CustomButtons.add' => 'カスタムボタンを追加',
    'Home.CustomButtons.noButtons' => 'カスタムボタンがありません',
    'Home.Customization.title' => 'ダッシュボード',
    'Home.Customization.description' => '表示したいオプションを選択します',
    'Home.Customization.pleskSection' => 'Plesk',
    'Home.Customization.serverSection' => 'サーバ',
    'Home.Customization.securitySection' => 'セキュリティ',
    'Home.Customization.backup' => '前回のサーババックアップ',
    'Home.Customization.ipBan' => 'IP アドレスによるアクセス制限',
    'Home.Customization.mailQueue' => 'メールキュー',
    'Home.Customization.mySubscriptions' => 'マイ契約',
    'Home.Customization.overusedSubscriptions' => '利用超過ありの契約',
    'Home.Customization.serverInfo' => 'サーバ情報',
    'Home.Customization.updates' => 'Plesk アップデート',
    'Home.Customization.promo' => 'プロモ',
    'Home.Customization.changeLog' => '最新情報',
    'Home.Customization.customButtons' => 'カスタムボタン',
    'Home.EmptyView.title' => '表示するオプションを選択して、ダッシュボードを最大限にご活用ください。',
    'Home.EmptyView.titleLocked' => 'ダッシュボードはサービスプロバイダによってロックされています。',
    'Home.EmptyView.customize' => 'カスタマイズ',
    'Home.Extension.title' => '拡張',
    'Home.IpBan.banned' => 'アクセス制限中',
    'Home.IpBan.trusted' => '信頼',
    'Home.IpBan.more' => '詳細',
    'Home.MailQueue.total' => '合計',
    'Home.MailQueue.deferred' => '遅延',
    'Home.MailQueue.held' => '保留',
    'Home.MailQueue.more' => '詳細',
    'Home.MailQueue.clean' => 'メールキューをクリア',
    'Home.MailQueue.checkLogs' => 'チェックログ',
    'Home.MailQueue.repair' => '修復',
    'Home.MailQueue.cleanConfirmQuestion' => 'メールキューをクリアしますか？',
    'Home.MailQueue.cleanConfirmYes' => 'はい',
    'Home.MailQueue.cleanConfirmNo' => 'いいえ',
    'Home.MailQueue.queueCleaned' => 'メールキューが正常にクリアされました。',
    'Home.MailQueue.Promo.title' => '配信ステータスとログへの簡単なアクセス',
    'Home.MailQueue.Promo.link' => '新しいメールキューを試す',
    'Home.OverusedSubscriptions.empty' => '利用超過ありの契約は見つかりませんでした',
    'Home.OverusedSubscriptions.usage' => '%%formattedUsed%% / %%formattedValue%%',
    'Home.OverusedSubscriptions.more' => '利用超過ありをすべて表示: [%%total%%]',
    'Home.OverusedSubscriptions.list' => 'リストに表示',
    'Home.PromoNewHomeView.title' => '新しいホームページへようこそ！',
    'Home.PromoNewHomeView.description' => '問題が発生した場合はフィードバックにてお知らせください。さらなる改善に活用させていただきます。',
    'Home.PromoNewHomeView.feedback' => 'フィードバックをシェアする',
    'Home.PromoNewHomeView.switch' => '「ホーム」に戻す',
    'Home.ServerInfo.hostname' => 'ホスト名',
    'Home.ServerInfo.ipAddress' => 'IP アドレス',
    'Home.ServerInfo.publicIpAddress' => 'パブリック IP アドレス',
    'Home.ServerInfo.os' => 'OS',
    'Home.ServerInfo.uptime' => 'アップタイム',
    'Home.ServerInfo.uptimeValue' => "{days, plural, =0 {} other {# 日}} {hours, plural, other {# 時間}} {minutes, plural, other {# 分}}",
    'Home.ServerInfo.more' => '詳細',
    'Home.Subscriptions.add' => '新規追加',
    'Home.Subscriptions.empty' => '複数の契約を作成して、サーバ上の独立した場所で複数のサイトをホストします。%%link%%',
    'Home.Subscriptions.help' => 'さらに詳しく',
    'Home.Updates.title' => '製品アップデート',
    'Home.Updates.version' => '%%name%% %%version%%',
    'Home.Updates.patch' => '%%version%% Update #%%patch%%',
    'Home.Updates.manageComponents' => 'コンポーネントを追加または削除',
    'Home.Updates.lastUpdated' => '最終更新: %%lastUpdateDate%%',
    'Home.Updates.checkUpdates' => 'アップデートの確認',
    'Home.Updates.enableAutoupdate' => '自動更新を許可',
    'Home.Updates.lastChecked' => '最終チェック: %%lastCheckDate%%',
    'Home.Updates.newVersionAvailable' => '%%availableVersion%% が利用可能です',
    'Home.Updates.installNewVersion' => '今すぐインストール',
    'Home.Updates.patchAvailable' => 'マイナーアップデートが利用可能です',
    'Home.Updates.patchAvailableVersion' => '%%currentVersion%% のマイナーアップデートが利用可能です',
    'Home.Updates.installPatch' => '今すぐ更新',
    'Home.Updates.pumUpdates' => '{total, select, 1 {{package} のアップデート} other {{package} のアップデート}}が使用できます',
    'Home.Updates.pumPackage' => '%%name%% %%availableVersion%%',
    'Home.Updates.pumPackages' => '{total, plural, other {# 件のパッケージ}}',
    'Home.Updates.installUpdates' => '{total, select, 1 {今すぐ更新} other {すべてを更新}}',
    'Home.Promo.Customize.title' => '自分だけのダッシュボードを作成しましょう！',
    'Home.Promo.Customize.content' => '新しいカスタマイズ可能なダッシュボードなら、よく使う機能にすぐに手が届きます',
    'Home.Promo.Customize.action' => 'カスタマイズ',
    'Home.Promo.SwitchToPuv.title' => 'Plesk のインターフェースビューをご存知ですか？',
    'Home.Promo.SwitchToPuv.content' => 'サービスプランを使用してホスティングサービスを顧客に提供していない場合、ウェブサイト、ウェブサイトのファイル、データベース、メールアカウント、ウェブアプリケーションをもっと便利に管理できるインターフェースをお試しください。',
    'Home.Promo.SwitchToPuv.action' => '今すぐ試す',
    'Home.Status.error' => 'エラー',
    'Home.Status.warning' => '警告',
    'Home.Status.info' => '情報',

    'HostingSettings.title' => 'ホスティング設定',
    'HostingSettings.updateSuccess' => '設定は更新されました。',
    'HostingSettings.emptyLogin' => 'ユーザ名を入力してください。',
    'HostingSettings.emptyPassword' => 'パスワードを入力してください。',
    'HostingSettings.ipV6OnlyNotSupported' => 'FTP サーバが IPv6 をサポートしていません。IPv4 アドレスを少なくとも 1 つ割り当ててください。これを行わないと、FTP 経由でサーバにファイルをアップロードできなくなります。',
    'HostingSettings.domainSettingsSection.sectionTitle' => 'ドメイン設定',
    'HostingSettings.domainSettingsSection.domainName' => 'ドメイン名',
    'HostingSettings.domainSettingsSection.description' => '例えば example.com ',

    'HostingSettings.submitPopover.title' => '%%website%% のコンテンツを削除',
    'HostingSettings.submitPopover.descriptionMainDomain' => 'ホスティングタイプを「ウェブサイト」から「%%type%%」に切り替えると、以下のディレクトリを含め、ウェブサイト全体のコンテンツが完全に削除されます。',
    'HostingSettings.submitPopover.descriptionSubDomain' => 'ウェブサイトのホスティングタイプを変更しますか？',

    'HostingSettings.domainSettingsSection.creatingWebspaceAlert' => 'その他の設定にアクセスするには、システムユーザのログイン情報を入力して、［ウェブスペースを作成］をクリックしてください。',
    'HostingSettings.domainSettingsSection.creatingHostingAlert' => 'その他の設定にアクセスするには、［次へ］をクリックしてホスティングを作成してください。',
    'HostingSettings.domainSettingsSection.hostingTypeTitle' => 'ホスティングタイプ',
    'HostingSettings.domainSettingsSection.hostingType.title' => 'タイプ',
    'HostingSettings.domainSettingsSection.hostingType.website' => 'ウェブサイト',
    'HostingSettings.domainSettingsSection.hostingType.forwarding' => '転送',
    'HostingSettings.domainSettingsSection.hostingType.noHosting' => 'ウェブホスティングなし',
    'HostingSettings.domainSettingsSection.hostingType.noHostingHint' => 'ドメイン名の下でメールボックスを管理するためにドメインの DNS ゾーンを使用する',
    'HostingSettings.domainSettingsSection.hostingType.pathToTheWebsite' => 'ウェブサイトのホームディレクトリへのパス',
    'HostingSettings.domainSettingsSection.preferredDomainTitle' => '優先ドメイン',
    'HostingSettings.domainSettingsSection.preferredDomainDescription' => '訪問者は SEO フレンドリーな HTTP 301 リダイレクトを介してここにリダイレクトされます。',
    'HostingSettings.domainSettingsSection.forwardVisitorsTo' => '訪問者の転送先',
    'HostingSettings.domainSettingsSection.forwardingType.title' => '転送タイプ',
    'HostingSettings.domainSettingsSection.forwardingType.movedPermanently' => '恒久的に移動（コード 301）',
    'HostingSettings.domainSettingsSection.forwardingType.movedPermanentlyDescription' => 'ウェブサイト訪問者を別のサイトへリダイレクトし、リダイレクト先アドレスを訪問者に表示します。このようなリダイレクトでは、サイトの検索ランキングが維持されます。',
    'HostingSettings.domainSettingsSection.forwardingType.movedTemporarily' => '一時的に移動（コード 302）',
    'HostingSettings.domainSettingsSection.forwardingType.movedTemporarilyDescription' => '検索エンジンに一時サイトをインデックスさせたくない時に、ウェブサイト訪問者を一時サイトコピーへリダイレクトします。',
    'HostingSettings.domainSettingsSection.forwardingType.frameForwarding' => 'フレーム転送',
    'HostingSettings.domainSettingsSection.forwardingType.frameForwardingDescription' => 'ウェブサイトの訪問者を他のサイトへリダイレクトしますが、転送先のアドレスは表示しません。 そのため、訪問者は転送されていることを把握できまません。',
    'HostingSettings.domainSettingsSection.preferredDomain.title' => '優先ドメイン',
    'HostingSettings.domainSettingsSection.preferredDomain.none' => 'なし',
    'HostingSettings.domainSettingsSection.preferredDomain.www' => 'www.%%domainName%%',
    'HostingSettings.domainSettingsSection.documentRootTitle' => 'ドキュメントルート',
    'HostingSettings.domainSettingsSection.documentRootHint' => 'このウェブサイトにウェブアプリケーションがインストールされているため、ドキュメントルートを変更できません',
    'HostingSettings.domainSettingsSection.save' => '保存',
    'HostingSettings.domainSettingsSection.sameSsl.title' => '互換モード',
    'HostingSettings.domainSettingsSection.sameSsl.enabled' => 'レガシーオプション「SSL/TLS コンテンツと非 SSL/TLS コンテンツを分ける」用に互換モードでウェブサイトを実行する',
    'HostingSettings.domainSettingsSection.sameSsl.hint' => 'このウェブサイトは互換モードで動作しており、Plesk インターフェースを使用して管理することはできません。これは、アップグレード前に非推奨の「SSL/TLS コンテンツと非 SSL/TLS コンテンツを分ける」オプションを使用していたためです。Plesk 11 以降は、HTTP 接続と HTTPS 接続で利用されるウェブサイトコンテンツが同じディレクトリに保存されます。すべてのデータを `httpsdocs/` ディレクトリから `httpdocs/` に移動してから、互換モードをオフにすることをお勧めします。 `httpsdocs/` ディレクトリにインストールされているアプリも、インターネット経由でアクセスできるようになります。互換モードを再度オンにすることはできませんので、注意してください。',
    'HostingSettings.domainSettingsSection.security.secureSettingsDialogTitle' => 'この設定を変更しますか？',
    'HostingSettings.domainSettingsSection.security.secureSettingsDialogDescription' => 'この設定を変更すると、サーバのセキュリティポリシーに反することになり、パフォーマンスに悪影響を及ぼすか、サーバが攻撃に対して脆弱になります。',
    'HostingSettings.domainSettingsSection.security.buttonChange' => '変更',
    'HostingSettings.domainSettingsSection.security.buttonRevert' => '戻す',
    'HostingSettings.domainSettingsSection.security.secureSettingsPresetApplied' => 'セキュア設定のプリセットが適用されています',
    'HostingSettings.domainSettingsSection.security.secureSettingsPresetMessage' => 'セキュリティを強化するために、セキュアプリセット設定を適用してください。なお、特定のパーミッションにより、契約者がこれらの設定を変更できます。ご注意ください。',
    'HostingSettings.domainSettingsSection.security.applySecureSettingsPreset' => 'セキュアプリセットを適用する',
    'HostingSettings.domainSettingsSection.security.exploreSecureSettings' => 'セキュアホスティング設定について',
    'HostingSettings.domainSettingsSection.security.sslTlsSupport' => 'SSL/TLS サポート',
    'HostingSettings.domainSettingsSection.security.sslTlsSupportEnabled' => '有効',
    'HostingSettings.domainSettingsSection.security.sslTlsSupportDescription' => 'ウェブサイトと訪問者のブラウザとの間の接続を暗号化します。',
    'HostingSettings.domainSettingsSection.security.certificate' => '証明書',
    'HostingSettings.domainSettingsSection.security.certificateDescription' => 'HTTPS を有効化するには、SSL/TLS 証明書をドメインのリポジトリにアップロードしてから、ここで選択してください。',
    'HostingSettings.domainSettingsSection.security.permanentRedirect' => 'SEO フレンドリーな HTTP 301 リダイレクトを介して訪問者を HTTP から HTTPS にリダイレクトする',
    'HostingSettings.domainSettingsSection.security.noCertificates' => 'リポジトリに SSL/TLS 証明書がありません。証明書を追加するには、%%link%%に進みます。',
    'HostingSettings.domainSettingsSection.security.noCertificatesLink' => 'このページ',
    'HostingSettings.domainSettingsSection.security.certificateFromDomainRepository' => '%%name%% (%%repository%%)',
    'HostingSettings.domainSettingsSection.security.certificateFromOtherRepository' => '%%name%%（その他のリポジトリ）',
    'HostingSettings.domainSettingsSection.security.certificateNotSelected' => '未選択',
    'HostingSettings.domainSettingsSection.webScripting.title' => 'ウェブスクリプティング',
    'HostingSettings.domainSettingsSection.webScripting.description' => 'ウェブサーバで解釈すべきプログラミング言語とスクリプティング言語を選択します。',
    'HostingSettings.domainSettingsSection.webScripting.fastCgi' => 'FastCGI',
    'HostingSettings.domainSettingsSection.webScripting.cgi' => 'CGI',
    'HostingSettings.domainSettingsSection.webScripting.cgiReadonly' => 'cgi-bin ディレクトリの場所：%%value%%',
    'HostingSettings.domainSettingsSection.webScripting.ssi' => 'SSI',
    'HostingSettings.domainSettingsSection.webScripting.ssiHtml' => '*.htm および *.html ファイルに SSI を使用',
    'HostingSettings.domainSettingsSection.webScripting.asp' => 'Microsoft ASP',
    'HostingSettings.domainSettingsSection.webScripting.aspDotNet' => 'Microsoft ASP.NET',
    'HostingSettings.domainSettingsSection.webScripting.aspDotNetVersion' => 'Microsoft ASP.NET バージョン',
    'HostingSettings.domainSettingsSection.webScripting.perl' => 'Perl',
    'HostingSettings.domainSettingsSection.webScripting.python' => 'Python',
    'HostingSettings.domainSettingsSection.webScripting.customErrorDocuments' => 'カスタムエラードキュメント',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.title' => 'cgi-bin ディレクトリの場所：',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.wwwRoot' => 'このドメインのドキュメントルート',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.webspace' => 'ウェブスペースのルートディレクトリ',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.oldStyle' => 'このドメインの旧スタイルのルート',
    'HostingSettings.domainSettingsSection.webScripting.errorDocs' => 'カスタムエラードキュメント',
    'HostingSettings.domainSettingsSection.webScripting.writeModify' => '追加の書込/変更パーミッション',
    'HostingSettings.domainSettingsSection.webScripting.webDeploy' => 'Web Deploy パブリッシング',
    'HostingSettings.domainSettingsSection.webStatistics.title' => 'ウェブ統計',
    'HostingSettings.domainSettingsSection.webStatistics.tool' => 'ツール',
    'HostingSettings.domainSettingsSection.webStatistics.webstatProtected' => 'ウェブ統計へのアクセスを FTP ユーザ名とパスワードで保護する',
    'HostingSettings.domainSettingsSection.webStatistics.disabled' => '無効',

    'HostingSettings.webspaceSettingsSection.sectionTitle' => 'ウェブスペース設定',
    'HostingSettings.webspaceSettingsSection.ipAddresses' => 'IP アドレス',
    'HostingSettings.webspaceSettingsSection.quota.title' => 'ディスク容量クォータ',
    'HostingSettings.webspaceSettingsSection.quota.enabled' => '有効',
    'HostingSettings.webspaceSettingsSection.quota.description' => '契約の設定に設定されたディスクスペースクォータ（もしあれば）を超過した場合、ウェブサイトのファイルでの操作を禁止します。',
    'HostingSettings.webspaceSettingsSection.quota.unlimitedDesc' => 'サーバのファイルシステムの構成により、ハードディスククォータはサポートされません。',
    'HostingSettings.webspaceSettingsSection.quota.mbUnits' => 'MB',
    'HostingSettings.webspaceSettingsSection.quota.readonly' => '%%quota%% MB',
    'HostingSettings.webspaceSettingsSection.systemUser' => 'システムユーザのクレデンシャル',
    'HostingSettings.webspaceSettingsSection.systemUserUnixDesc' => 'FTP またはファイルマネージャ経由でウェブサイトのファイルとフォルダを管理します。許可される場合、SSH 経由でサーバにアクセスします。',
    'HostingSettings.webspaceSettingsSection.systemUserWinDesc' => 'FTP またはファイルマネージャ経由でウェブサイトのファイルとフォルダを管理します。許可される場合、リモートデスクトップ経由でサーバにアクセスします。',
    'HostingSettings.webspaceSettingsSection.systemUserLogin' => 'ユーザ名',
    'HostingSettings.webspaceSettingsSection.systemUserPasswd' => 'パスワード',
    'HostingSettings.webspaceSettingsSection.systemUserPasswdDesc' => 'システムユーザのパスワードを変更するには、ここに新しいパスワードを指定します。',
    'HostingSettings.webspaceSettingsSection.shell.unixTitle' => 'SSH アクセス',
    'HostingSettings.webspaceSettingsSection.shell.winTitle' => 'リモートデスクトップアクセス',
    'HostingSettings.webspaceSettingsSection.shell.enabled' => '有効',
    'HostingSettings.webspaceSettingsSection.shell.description' => "システムユーザのログイン情報でサーバにアクセスします。",
    'HostingSettings.webspaceSettingsSection.shell.type' => 'タイプ',
    'HostingSettings.webspaceSettingsSection.shell.disabled' => '無効',
    'HostingSettings.webspaceSettingsSection.affectedDomainsLabel' => '{count, plural, other {# 件のドメイン}}用',
    'HostingSettings.webspaceSettingsSection.affectedDomainsDescription' => '以下の設定は、{count, plural, other {ウェブスペース {name} の全 # 件のドメイン}}で共通です：',

    'OdbcAdd.title' => 'ODBC DSN を追加',
    'OdbcAdd.nameLabel' => '接続名',
    'OdbcAdd.descriptionLabel' => '接続の説明',
    'OdbcAdd.driver' => 'ドライバ',
    'OdbcAdd.submit' => 'ODBC DSN を作成',

    'OdbcEdit.title' => 'ODBC 接続をセットアップ',
    'OdbcEdit.saveSuccess' => '接続の設定が保存されました。',
    'OdbcEdit.test' => 'テスト接続',
    'OdbcEdit.connectSuccess' => '接続に成功しました',

    'OdbcEdit.excel.driver.label' => 'ドライバ',
    'OdbcEdit.excel.dbq.label' => 'データベースファイルへのパス',
    'OdbcEdit.excel.defaultdir.label' => 'デフォルトデータディレクトリ',
    'OdbcEdit.excel.fil.label' => 'データベースバージョン',
    'OdbcEdit.excel.maxbuffersize.label' => '最大バッファサイズ',
    'OdbcEdit.excel.pagetimeout.label' => 'ページタイムアウト',

    'OdbcEdit.access.driver.label' => 'ドライバ',
    'OdbcEdit.access.dbq.label' => 'データベースファイルへのパス',
    'OdbcEdit.access.uid.label' => 'ログイン名',
    'OdbcEdit.access.pwd.label' => 'パスワード',
    'OdbcEdit.access.pagetimeout.label' => 'ページタイムアウト',
    'OdbcEdit.access.pagetimeout.description' => '未使用のページがバッファに留まる期間を 10 分の 1 秒単位で設定します。このオプションは Microsoft Access Driver を使用しているすべてのデータソースに適用されます。',
    'OdbcEdit.access.maxbuffersize.label' => '最大バッファサイズ',
    'OdbcEdit.access.maxbuffersize.description' => '内部バッファのサイズです。KB 単位で指定し、上限値は 256KB となっています。',
    'OdbcEdit.access.readonly.label' => '読み取り専用',
    'OdbcEdit.access.readonly.description' => 'すべてのアップデートも禁止するためには、データベースを読込専用と指定します。',
    'OdbcEdit.access.exclusive.label' => '排他的',
    'OdbcEdit.access.exclusive.description' => 'シェアアップデートを禁止するためには、データベースを排他として指定します。',
    'OdbcEdit.access.safetransactions.label' => '安全なトランザクション',
    'OdbcEdit.access.safetransactions.description' => '0 （デフォルト）に設定すると、すべてのトランザクションは即座にコミットされます。 1 に設定すると、すべてのトランザクションはコミット命令後ディスクに保存されますが、パフォーマンスは確実に低下してしまいます。',
    'OdbcEdit.access.threads.label' => 'スレッド数',
    'OdbcEdit.access.threads.description' => 'エンジンで使用するバックグラウンドスレッド数',
    'OdbcEdit.access.maxscanrows.label' => 'スキャンする最大行数',
    'OdbcEdit.access.maxscanrows.description' => '既存のデータに基づいて列のデータタイプを設定する際にスキャンする行数',
    'OdbcEdit.access.implicitcommitsync.label' => 'ImplicitCommitSync',
    'OdbcEdit.access.implicitcommitsync.description' => 'トランザクションの外部でデータベースへの書き込みが実行された場合どのように変更するかを指定します。',
    'OdbcEdit.access.usercommitsync.label' => 'UserCommitSync',
    'OdbcEdit.access.usercommitsync.description' => 'MS Access ドライバが明示的にユーザ定義のトランザクションを非同期的に取り扱うかを指定します。',

    'OdbcEdit.mssql.driver.label' => 'ドライバ',
    'OdbcEdit.mssql.server.label' => 'サーバ',
    'OdbcEdit.mssql.uid.label' => 'ログイン名',
    'OdbcEdit.mssql.pwd.label' => 'パスワード',
    'OdbcEdit.mssql.database.label' => 'デフォルトデータベース',
    'OdbcEdit.mssql.app.label' => 'アプリケーション名',
    'OdbcEdit.mssql.wsid.label' => 'ワークステーション ID',
    'OdbcEdit.mssql.language.label' => 'デフォルト言語',
    'OdbcEdit.mssql.oemtoansi.label' => '拡張文字を OEM 値に変換',

    'OdbcEdit.mysql.driver.label' => 'MySQL ODBC ドライバ',
    'OdbcEdit.mysql.server.label' => 'サーバ',
    'OdbcEdit.mysql.server.description' => 'MariaDB/MySQL サーバのホスト名',
    'OdbcEdit.mysql.database.label' => 'デフォルトデータベース',
    'OdbcEdit.mysql.user.label' => 'ユーザ名',
    'OdbcEdit.mysql.user.description' => 'MariaDB/MySQL に接続するためのユーザ名',
    'OdbcEdit.mysql.password.label' => 'パスワード',
    'OdbcEdit.mysql.password.description' => 'サーバ上のユーザアカウントのパスワード',
    'OdbcEdit.mysql.port.label' => 'ポート',
    'OdbcEdit.mysql.port.description' => 'サーバがローカルホストでは無い場合に使用する TCP/IP ポート',
    'OdbcEdit.mysql.socket.label' => 'ソケット',
    'OdbcEdit.mysql.socket.description' => 'サーバがローカルホストの場合、Windows の名前付きパイプに接続します。',
    'OdbcEdit.mysql.option.label' => 'オプション',
    'OdbcEdit.mysql.option.description' => 'MyODBC を動作させるためのオプションを設定します。 詳細は<a target="_blank" href="https://www.linuxtopia.org/online_books/database_guides/mysql_5.1_database_reference_guide_OLD/connection-parameters.html">ドキュメント</a>を参照してください',

    'ProtectedDirectoryList.add' => '保護ディレクトリを追加',
    'ProtectedDirectoryList.addTooltip' => '保護ディレクトリを作成します。',
    'ProtectedDirectoryList.name' => '名前',
    'ProtectedDirectoryList.realmTitle' => '保護エリアのタイトル',
    'ProtectedDirectoryList.noSelectionText' => '削除するアイテムを 1 つ以上選択してください。',
    'ProtectedDirectoryList.edit' => '編集',
    'ProtectedDirectoryList.remove' => '保護を解除',
    'ProtectedDirectoryList.removeTooltip' => '選択したディレクトリから保護を削除します。',
    'ProtectedDirectoryList.removeConfirmation' => 'この操作により、{count, plural, =1 {the {name} directory} other {選択された # 件のディレクトリ}}で保護が解除され、{count, plural, =1 {This directory} other {このディレクトリ}}はインターネットユーザが自由にアクセスできるようになります。',
    'ProtectedDirectoryList.removeSuccess' => '選択されたディレクトリは削除されました。',

    'ProtectedDirectoryAdd.title' => '保護ディレクトリを作成します',
    'ProtectedDirectoryAdd.submit' => '作成',
    'ProtectedDirectoryAdd.success' => '保護ディレクトリ %%path%% を作成しました',

    'ProtectedDirectoryEdit.title' => '保護ディレクトリ設定',
    'ProtectedDirectoryEdit.success' => '保護ディレクトリの設定を変更しました',

    'ProtectedDirectoryUserAdd.title' => '保護ディレクトリのユーザを作成',
    'ProtectedDirectoryUserAdd.subtitle' => 'ディレクトリ %%directory%%',
    'ProtectedDirectoryUserAdd.loginLabel' => 'ユーザ名',
    'ProtectedDirectoryUserAdd.passwordLabel' => 'パスワード',
    'ProtectedDirectoryUserAdd.submit' => '作成',
    'ProtectedDirectoryUserAdd.success' => '保護ディレクトリのユーザ %%login%% が作成されました。',

    'ProtectedDirectoryUserPassword.title' => '保護ディレクトリユーザのパスワード：',
    'ProtectedDirectoryUserPassword.subtitle' => 'ユーザ %%login%%',
    'ProtectedDirectoryUserPassword.passwordLabel' => 'パスワード',
    'ProtectedDirectoryUserPassword.submit' => '保存',
    'ProtectedDirectoryUserPassword.success' => 'ユーザのクレデンシャルが保存されました。',

    'SummaryReport.Layout.title' => 'レポートレイアウトプロパティ',
    'SummaryReport.Layout.success' => 'レポートレイアウト %%name%% がアップデートされました。',

    'SummaryReport.Layout.Add.title' => 'レポートレイアウトの作成',
    'SummaryReport.Layout.Add.success' => 'レポートレイアウト %%name%% が作成されました。',

    'SummaryReport.Report.buttonLayouts' => 'レイアウト',
    'SummaryReport.Report.buttonSchedule' => 'スケジュール',
    'SummaryReport.Report.buttonProperties' => 'プロパティ',
    'SummaryReport.Report.buttonTrafficHistory' => 'トラフィック履歴',
    'SummaryReport.Report.buttonPrint' => '印刷',
    'SummaryReport.Report.buttonSend' => 'メールで送信',
    'SummaryReport.Report.successSent' => 'レポートは %%email%% に送信されました',

    'SummaryReport.Schedule.Properties.title' => '%%name%%の配信スケジュール',
    'SummaryReport.Schedule.Properties.success' => 'レポート配信スケジュールが更新されました。',

    'SummaryReport.Schedule.Add.title' => '%%name%% の配信スケジュールを作成',
    'SummaryReport.Schedule.Add.success' => 'レポート配信スケジュールが作成されました。',

    'VirtualDirectory.errNotExist' => 'この仮想ディレクトリは存在しない物理フォルダにリンクされています。',
    'VirtualDirectory.errNoPermissions' => 'このディレクトリのコンテンツを表示するパーミッションがありません。',
    'VirtualDirectory.buttonProperties' => 'ディレクトリプロパティ',
    'VirtualDirectory.buttonPropertiesHint' => '仮想ディレクトリのプロパティを表示・変更します。',
    'VirtualDirectory.buttonPermissions' => 'ディレクトリアクセスパーミッション',
    'VirtualDirectory.buttonPermissionsHint' => 'ディレクトリアクセスパーミッションを設定します。',
    'VirtualDirectory.buttonAspDotNet' => 'ASP.NET',
    'VirtualDirectory.buttonAspDotNetHint' => 'ASP.NET 設定を構成します。',
    'VirtualDirectory.buttonPhp' => 'PHP',
    'VirtualDirectory.buttonPhpHint' => 'PHP 設定を構成します。',
    'VirtualDirectory.tabBrowse' => 'Directories',
    'VirtualDirectory.tabBrowseHint' => 'サイト %%site%% 下の物理ファイル/ディレクトリおよび仮想ファイル/ディレクトリについて作業を行います。',
    'VirtualDirectory.tabMimeTypes' => 'MIME タイプ',
    'VirtualDirectory.tabMimeTypesHint' => '登録された MIME タイプを管理します。',
    'VirtualDirectory.tabErrorDocs' => 'エラードキュメント',
    'VirtualDirectory.tabErrorDocsHint' => 'エラードキュメントを管理します。',
    'VirtualDirectory.tabProtection' => '保護',
    'VirtualDirectory.tabProtectionHint' => 'パスワード保護を用いてディレクトリへのアクセスを制限します。',

    'VirtualDirectory.errorDocType.default' => 'デフォルト',
    'VirtualDirectory.errorDocType.file' => 'ファイル',
    'VirtualDirectory.errorDocType.url' => 'URL',

    'VirtualDirectory.CreateDirectory.title' => 'ディレクトリを作成',
    'VirtualDirectory.CreateDirectory.name' => 'ディレクトリ名',
    'VirtualDirectory.CreateDirectory.success' => '%%name%% ディレクトリが作成されました。',
    'VirtualDirectory.CreateDirectory.errExists' => '%%name%% ディレクトリが既に存在します。',

    'VirtualDirectory.CreateVirtualDirectory.title' => '仮想ディレクトリを作成',
    'VirtualDirectory.CreateVirtualDirectory.success' => '%%name%% ディレクトリが作成されました。',

    'VirtualDirectory.EditVirtualDirectory.title' => '仮想ディレクトリのプロパティ',
    'VirtualDirectory.EditVirtualDirectory.success' => '仮想ディレクトリが編集されました。',
    'VirtualDirectory.EditVirtualDirectory.close' => '閉じる',

    'VirtualDirectory.MimeTypeList.add' => 'MIME タイプを追加',
    'VirtualDirectory.MimeTypeList.edit' => 'MIME タイプを編集',
    'VirtualDirectory.MimeTypeList.addHint' => '新しい MIME タイプの登録',
    'VirtualDirectory.MimeTypeList.columnExtension' => '拡張',
    'VirtualDirectory.MimeTypeList.columnContent' => 'コンテンツ',
    'VirtualDirectory.MimeTypeList.noSelectionText' => '削除するアイテムを 1 つ以上選択してください。',
    'VirtualDirectory.MimeTypeList.removeConfirmation' => '{count, plural, =1 {選択した MIME タイプ} other {選択した # 件の MIME タイプ}}を削除しますか？',
    'VirtualDirectory.MimeTypeList.removeSuccess' => '選択した MIME タイプが削除されました。',

    'VirtualDirectory.CreateMimeType.title' => 'MIME タイプを追加',
    'VirtualDirectory.CreateMimeType.success' => '新しい MIME タイプが登録されました。',

    'VirtualDirectory.EditMimeType.title' => 'MIME タイプを編集',
    'VirtualDirectory.EditMimeType.success' => 'MIME タイプが編集されました。',

    'VirtualDirectory.ErrorDocList.columnCode' => 'エラー',
    'VirtualDirectory.ErrorDocList.columnName' => '説明',
    'VirtualDirectory.ErrorDocList.columnType' => 'タイプ',
    'VirtualDirectory.ErrorDocList.columnLocation' => '場所',
    'VirtualDirectory.ErrorDocList.edit' => '編集',

    'VirtualDirectory.EditErrorDoc.title' => 'エラードキュメントを編集',
    'VirtualDirectory.EditErrorDoc.success' => 'エラードキュメントが編集されました。',

    'VirtualDirectory.EditErrorDoc.EditErrorDocForm.error' => 'エラー',
    'VirtualDirectory.EditErrorDoc.EditErrorDocForm.type' => 'タイプ',
    'VirtualDirectory.EditErrorDoc.EditErrorDocForm.location' => '場所',

    'VirtualDirectory.Protection.notSupported' => 'このディレクトリはディレクトリ保護をサポートしません。名前が 245 文字を超えているか、サポートされない文字が含まれています。',
    'VirtualDirectory.Protection.NoProtectionView.title' => '仮想ディレクトリ保護が無効です',
    'VirtualDirectory.Protection.NoProtectionView.protect' => '保護',
    'VirtualDirectory.Protection.NoProtectionView.successProtection' => 'ディレクトリ %%path%% が保護されるようになりました。',
    'VirtualDirectory.Protection.tools' => 'ツール',
    'VirtualDirectory.Protection.removeProtection' => '保護を解除',
    'VirtualDirectory.Protection.removeProtectionTooltip' => 'ディレクトリに対応する URL をすべての人からアクセス可能にします。',
    'VirtualDirectory.Protection.removeProtectionConfirmation' => '仮想ディレクトリから保護を削除しますか？すべての保護ディレクトリユーザとディレクトリ保護設定も削除されます。',
    'VirtualDirectory.Protection.settings' => '設定',
    'VirtualDirectory.Protection.settingsTooltip' => 'ディレクトリのロケーションを確認して、保護エリアのタイトルを入力してください。',

    'VirtualDirectory.AspDotNet.title' => 'ASP.NET 設定の構成',

    'VirtualDirectory.Php.title' => 'PHP バージョン',
    'VirtualDirectory.Php.version' => 'バージョン',
    'VirtualDirectory.Php.success' => 'PHP バージョンが更新されました。',


    'MassMailPage.sendEmail' => '一括メールを送信',
    'MassMailPage.selectAtLeastOneTemplate' => 'テンプレートを少なくとも 1 つ選択してください',
    'MassMailPage.confirmRemoval' => '選択した{count, select, 1 {テンプレート} other {テンプレート}}を削除しますか？',
    'MassMailPage.remove' => '削除',
    'MassMailPage.filters' => 'フィルタ',
    'MassMailPage.name' => 'テンプレート名',
    'MassMailPage.sender' => '送信者',
    'MassMailPage.recipients' => '受信者',
    'MassMailPage.subject' => '件名',
    'MassMailPage.created' => '作成日',
    'MassMailPage.send' => '送信',
    'MassMailPage.recipientsNone' => 'なし',
    'MassMailPage.recipientsAdmins' => '管理者',
    'MassMailPage.recipientsResellers' => 'すべてのリセラー',
    'MassMailPage.recipientsResellersSelected' => '選択したリセラー',
    'MassMailPage.recipientsResellersExcept' => '選択した以外のすべてのリセラー',
    'MassMailPage.recipientsClients' => 'すべての顧客',
    'MassMailPage.recipientsClientsSelected' => '選択した顧客',
    'MassMailPage.recipientsClientsExcept' => '選択以外のすべての顧客',
    'MassMailPage.templatesRemoved' => '{count, select, 1 {テンプレート} other {テンプレート}}が削除されました。',
    'MassMailPage.emptyViewTitle' => '一括メールメッセージテンプレートなし',
    'MassMailPage.addNew' => 'テンプレート作成',
    'CreateMassMailTemplatePage.templateCreated' => 'テンプレートが作成されました。',
    'EditMassMailTemplatePage.templateUpdated' => 'テンプレートが更新されました。',
    'SendMassMailPage.emailSent' => 'メールが送信されました。',
    'SendMassMailPage.fieldIsRequired' => 'フィールドは空にできません',
    'SendMassMailPage.saveAsTemplate' => '作成したメッセージを新しいテンプレートに保存',
    'SendMassMailPage.newTemplateName' => '新しいテンプレート名',
    'SendMassMailPage.selectedTemplate' => '選択したテンプレート',
    'SendMassMailPage.send' => '送信',
    'VirtualHostTemplatePage.name' => '名前',
    'VirtualHostTemplatePage.sizeInBytes' => 'サイズ',
    'VirtualHostTemplatePage.modified' => '変更日時',
    'VirtualHostTemplatePage.permissions' => 'パーミッション',
    'VirtualHostTemplatePage.user' => 'ユーザ',
    'VirtualHostTemplatePage.group' => 'グループ',
    'VirtualHostTemplatePage.uploadTemplate' => 'アップロード',
    'VirtualHostTemplatePage.succesfullyUploaded' => 'テンプレートがアップロードされました。',
    'VirtualHostTemplatePage.root' => '仮想テンプレートディレクトリ',
    'VirtualHostTemplatePage.emptyViewTitle' => 'テンプレートにファイルがありません',
    'VirtualHostTemplatePage.total' => 'ディレクトリ {breadcrumbs} 内の合計アイテム数: {total}',
    'VirtualHostTemplatePage.resetTemplate' => 'デフォルトを設定',
    'VirtualHostTemplatePage.successfullyReset' => 'テンプレートがデフォルトに変更されました。',

    'TrafficUsageByDomain.List.service' => 'サービス',
    'TrafficUsageByDomain.List.usage' => '使用中',
    'TrafficUsageByDomain.List.incoming' => 'In',
    'TrafficUsageByDomain.List.outgoing' => 'Out',
    'TrafficUsageByDomain.List.percentOfAll' => '全体に占める割合（%）',

    'TrafficUsageByDomains.Viewer.List.domainName' => 'ドメイン名',
    'TrafficUsageByDomains.Viewer.List.clientName' => "所有者名",
    'TrafficUsageByDomains.Viewer.List.totalUsage' => '使用中',
    'TrafficUsageByDomains.Viewer.List.subscriptionLimit' => '上限',
    'TrafficUsageByDomains.Viewer.List.subscriptionLimitRemaining' => '使用可能',
    'TrafficUsageByDomains.Viewer.List.subscriptionLimitUsagePercent' => '使用中 (%)',
    'TrafficUsageByDomains.Viewer.Filters.ownOnly' => 'マイ・ドメインのみ',
    'TrafficUsageByDomains.Viewer.Filters.resellerOnly' => 'リセラードメインのみ',
    'TrafficUsageByDomains.Viewer.Filters.clientName' => '所有者名',

    'TrafficUsageByReseller.emptyView' => 'このリセラーには顧客がいません',
    'TrafficUsageByReseller.TotalUsage.usageByResellerDomains' => '%%resellerDomainsLink%%: %%usage%%',
    'TrafficUsageByReseller.TotalUsage.resellerDomains' => "リセラー独自のドメイン",
    'TrafficUsageByReseller.TotalUsage.usageByCustomerDomains' => "リセラーの顧客のドメイン: %%usage%%",

    'InfoAndStatistics.Main.title' => '情報と統計',
    'InfoAndStatistics.Main.overview' => '概要',
    'InfoAndStatistics.Main.domains' => 'ドメイン',
    'InfoAndStatistics.Main.trafficUsage' => 'トラフィック使用状況',
    'InfoAndStatistics.Main.reports' => 'レポート',
    'InfoAndStatistics.Main.serverSettings' => 'サーバ設定',
    'InfoAndStatistics.TrafficUsage.customers' => '顧客',
    'InfoAndStatistics.TrafficUsage.resellers' => 'リセラー',
    'InfoAndStatistics.TrafficUsage.domains' => 'ドメイン',
];