<?php
// Copyright 1999-2024. WebPros International GmbH. All rights reserved.
// This file contains structured and commented locale keys for Plesk 9.x

global $PROD_NAME;

$GLOBALS['lmsg_arr'] += [
    ////
    //// LOGIN SCREEN
    ////

    'login_up__access_denied_account_disabled' => "Accès refusé. Votre compte a été suspendu.",
    'login_up__login_has_been_locked' => "Vous avez essayé de vous connecter en utilisant un mot de passe incorrect à trop de reprises. Pour des raisons de sécurité, vous ne pourrez pas vous connecter sous ce nom d'utilisateur pendant un certain temps.",
    'login_up__unable_to_check_pass' => "Impossible de vérifier le mot de passe : %1",
    'login_up__warning_limits_licence_key' => "L'un des éléments suivants a dépassé la limite définie par votre clé de licence : nombres de comptes utilisateur, domaines, comptes mail ou utilisateurs Web hébergés sur votre serveur.\nVeuillez contacter le département ventes de Plesk afin d'acheter une nouvelle clé de licence qui vous permettra d'héberger le nombre souhaité d'utilisateurs et de domaines. Veuillez contacter le département d'assistance technique de Plesk si vous pensez avoir reçu ce message par erreur.\nLimite de la licence pour les comptes utilisateur/domaines/comptes mail/utilisateurs Web/packs de langues : %2.\nNombre de comptes utilisateur/domaines/compte mail/utilisateurs Web/packs de langues actuellement hébergés : %3.", // PFW
    'login_up__short_warning_limits_licence_key' => "Le total des ressources que vous utilisez a dépassé les limites définies par la licence actuelle de votre produit. Veuillez contacter le département ventes de Plesk et acheter une nouvelle clé de licence.",
    'login_up__grace_period' => 'Vous bénéficiez actuellement de la période de grâce de la licence de votre produit. Pour mettre à jour la licence de votre produit, sélectionnez l\'option Récupérer des clés de licence sur la page %1Informations sur la licence%2.',
    'login_up__partner_license_message' => 'Vous bénéficiez actuellement d\'une licence produit limitée qui requiert l\'enregistrement avant l\'activation de l\'ensemble des fonctionnalités. Pour mettre à jour la licence de votre produit, sélectionnez l\'option Récupérer des clés de licence sur la page %1Informations sur la licence%2.',
    'login_up__system_admin_disabled' => 'Le super-utilisateur (root ou compte administrateur) n\'a pas le droit de se connecter à Plesk pour des raisons de sécurité.',

    ///
    /// Online help keys:
    ///

    'plesk_guide' => "Guide de l'administrateur de Plesk",
    'plesk_guide_reseller' => "Guide du revendeur de Plesk",
    'plesk_guide_client' => "Guide du client de Plesk",
    'plesk_guide_domain_admin' => "Guide de l'administrateur de domaines de Plesk",
    'plesk_guide_mailuser' => "Guide de l'utilisateur de messagerie de Plesk",

    ////
    //// COMMON KEYS FOR NAVIGATION THROUGHOUT PANEL
    ////

    ///
    /// NAVIGATION PANE
    ///

    'bt_search' => 'Rechercher', // multiple usage: TBI
    'ui__client_unknown__quick-search' => 'Clients',
    'ui__reseller_unknown__quick-search' => 'Revendeurs',
    'ui__client/domain_unknown__quick-search' => 'Domaines',
    'nav__general' => 'Menu principal',
    '__home' => 'Accueil',
    '__resellers' => 'Revendeurs',
    '__clients' => 'Clients',
    '__domains' => 'Domaines',
    '__applications' => 'Applications',
    '__settings' => 'Paramètres',
    'nav__system' => 'Système',
    '__master' => 'Maître',

    ///
    /// END OF NAVIGATION PANE
    ///

    ///
    /// NAVIGATION KEYS
    ///

    // up level
    'bt_up_level' => 'Niveau sup.',

    // object switcher

    ///
    /// END OF NAVIGATION KEYS
    ///

    ///
    /// LISTS
    ///

    // common operations on list objects
    'bt_remove_selected' => 'Supprimer',
    'bt_make_default' => 'Utiliser par défaut',

    // common list object operation errors
    'class_cList__empty_selection' => 'Aucun objet sélectionné.',

    // common list object search keys
    'clist__search_show' => 'Afficher la recherche',
    'clist__search_hide' => 'Masquer la recherche',

    'bt_show_all' => "Réinitialiser la recherche",

    // common object list info keys
    'clist__first' => 'Premier',
    'clist__last' => 'Dernier',
    'clist__prev' => '&lt;&lt;',
    'clist__next' => '&gt;&gt;',
    'clist__page' => 'Pages',
    'clist__page_size' => 'Entrées par page',
    'clist__info' => 'Total %1 : %4',
    'clist__info_empty' => 'Aucun(e) %1',
    'clist__info_filter' => '%5 %1 trouvés (%4 au total)',
    'clist__info_paging' => '%2-%3 %1 sur %4 en tout',
    'clist__info_paging_filter' => '%2-%3 %1 sur %5 trouvés (%4 au total)',

    ///
    /// END OF LISTS
    ///

    ////
    //// KEYS FOR USER HOME PAGES
    ////

    ///
    /// COMMON HOME PAGE KEYS
    ///

    // business object controls
    '__object_on' => 'Actif',
    '__object_off' => 'Suspendu',

    '__home_description' => 'Retournez à la page d\'accueil.',
    'indicator_title' => '%1% utilisé(s), %2% libre(s)', // tooltip for visual stats area

    ///
    /// END OF COMMON HOME PAGE KEYS
    ///

    ///
    /// SERVER ADMINISTRATOR
    ///

    '__invalid_url_requested' => 'Une URL incorrecte a été demandée.',

    // accounts
    // icons
    'ui__reseller_unknown__short-title' => "Comptes revendeur",
    'ui__reseller_unknown__title' => "Comptes revendeur",
    'ui__reseller_unknown__description' => "Gérez les comptes revendeur.",
    'ui__reseller/client_unknown__short-title' => 'Comptes client',
    'ui__reseller/client_unknown__title' => 'Comptes client',
    'ui__reseller/client_unknown__description' => 'Gérez les comptes client.',
    // dropdowns
    'ui__admin-alias_unknown__title' => "Comptes administrateur supplémentaires", // PFW
    'ui__admin-alias_unknown__short-title' => "Comptes administrateur supplémentaires", // PFW
    'ui__admin-alias_unknown__description' => "Affichez et gérez les comptes administrateur supplémentaires.", // PFW

    // server
    // icons
    'ui__server/mail__short-title' => "Paramètres de la messagerie pour l'ensemble du serveur",
    'ui__server/mail__title' => "Paramètres de la messagerie pour l'ensemble du serveur",
    'ui__server/mail__description' => "Configurez votre serveur de messagerie et configurez les paramètres de la messagerie valables pour l'ensemble du serveur.",
    'ui__server/dns__short-title' => 'Paramètres DNS',
    'ui__server/dns__title' => 'Paramètres DNS',
    'ui__server/dns__description' => 'Vérifiez et mettez à jour les paramètres DNS valables pour l\'ensemble du serveur.',
    'ui__server/services__title' => 'Gestion des services',
    'ui__server/services__description' => 'Démarrez, arrêtez ou redémarrez les services de Plesk.',
    'ui__server/crontab/task_unknown__short-title' => 'Tâches planifiées',
    'ui__server/crontab/task_unknown__title' => 'Tâches planifiées',
    'ui__server/crontab/task_unknown__description' => 'Ajoutez et supprimez les tâches planifiées pour l\'ensemble du serveur.',
    'ui__server/ip-address_unknown__short-title' => 'Adresses IP',
    'ui__server/ip-address_unknown__title' => 'Adresses IP',
    'ui__server/ip-address_unknown__description' => 'Affichez, ajoutez et supprimez les adresses IP, affectez les adresses IP aux revendeurs.',
    // dropdowns
    'ui__server/time__title' => 'Date/Heure du système',
    'ui__server/time__short-title' => 'Date/Heure du système',
    'ui__server/time__description' => 'Changez la date et l\'heure du système, configurez la synchronisation avec un serveur NTP.',
    'ui__server/maillists__title' => 'Configurer le serveur de listes de diffusion', // PFU
    'ui__server/maillists__short-title' => 'Configurer le serveur de listes de diffusion', // PFU
    'ui__server/maillists__description' => 'Configurez le serveur des listes de diffusion Mailman.', // PFU
    'ui__server/spam-filter__title' => 'Paramètres du filtre anti-spam',
    'ui__server/spam-filter__short-title' => 'Paramètres du filtre anti-spam',
    'ui__server/spam-filter__description' => 'Configurez le filtre anti-spam valable pour l\'ensemble du serveur.',
    'ui__server/preferences__title' => "Paramètres du serveur",
    'ui__server/preferences__short-title' => "Paramètres du serveur",
    'ui__server/preferences__description' => "Configurez le calcul de statistiques valables pour l'ensemble du serveur, changez le nom d'hôte du serveur et les autres paramètres du serveur.",

    // help & support
    // icons
    'ui__support__short-title' => 'Assistance',
    'ui__support__title' => 'Assistance',
    'ui__support__description' => 'Envoyez une requête pour l\'assistance technique ou consultez les tickets d\'assistance ouverts par vos clients.',
    'ui__license__short-title' => 'Informations sur la licence',
    'ui__license__title' => 'Informations sur la licence Plesk',
    'ui__license__description' => 'Affichez les informations sur la licence Plesk et commandez les nouvelles clés de licence.',
    'ui__help__short-title' => 'Aide',
    'ui__help__title' => 'Aide en ligne',
    'ui__help__description' => 'Affichez l\'aide en ligne.',
    'ui__news__short-title' => "Nouveautés",
    'ui__news__title' => "Nouveautés",
    'ui__news__description' => "Consultez la liste des changements dans cette version de Plesk.",
    'ui__server/autoinstaller__short-title' => 'Mises à jour',
    'ui__server/autoinstaller__title' => 'Mises à jour',
    'ui__server/autoinstaller__description' => 'Mettez à jour Plesk et ses composants.',
    // dropdowns

    // domains
    // icons
    'ui__client/domain_unknown__short-title' => 'Domaines',
    'ui__client/domain_unknown__title' => 'Domaines',
    'ui__client/domain_unknown__description' => 'Gérez les domaines.',
    // dropdowns
    'ui__client/domain/chowner_multi-select__title' => 'Affecter un nouveau propriétaire aux abonnements',
    'ui__client/domain/chowner_multi-select__short-title' => 'Affecter un nouveau propriétaire à l\'abonnement',
    'ui__client/domain/chowner_multi-select__description' => 'Affecter un nouveau propriétaire aux abonnements sélectionnés',
    'ui__client/domain/disable_multi__title' => 'Suspendre les domaines',
    'ui__client/domain/disable_multi__short-title' => 'Suspendre  les domaines',
    'ui__client/domain/disable_multi__description' => 'Suspendre les domaines sélectionnés',
    'ui__client/domain/enable_multi__title' => 'Activer les domaines',
    'ui__client/domain/enable_multi__short-title' => 'Activer les domaines',
    'ui__client/domain/enable_multi__description' => 'Activer les domaines sélectionnés',

    // icons
    'ui__admin/extras-domain__short-title' => 'Outils achetés dans MyPlesk.com',
    'ui__admin/extras-domain__title' => 'Outils achetés dans MyPlesk.com',
    'ui__admin/extras-domain__description' => 'Achetez d\'autres outils et services dans MyPlesk.com.',
    'ui__server/sitebuilder__short-title' => 'Paramètres de Presence Builder', // PFU
    'ui__server/sitebuilder__title' => 'Paramètres de Presence Builder', // PFU
    'ui__server/sitebuilder__description' => 'Configurez Presence Builder pour éditer les sites Web hébergés sur ce serveur.', // PFU
    // dropdowns
    'ui__admin/register-domain__title' => 'Enregistrer le domaine',
    'ui__admin/register-domain__short-title' => 'Enregistrer le domaine',
    'ui__admin/register-domain__description' => 'Enregistrez un nom de domaine via MyPlesk.com.',
    'ui__admin/manage-domain__title' => 'Gérer le domaine',
    'ui__admin/manage-domain__short-title' => 'Gérer le domaine',
    'ui__admin/manage-domain__description' => 'Gérez les noms de domaine enregistrés via MyPlesk.com.',
    'ui__server/register__title' => 'Enregistrer votre serveur',
    'ui__server/register__short-title' => 'Enregistrer le serveur',
    'ui__server/register__description' => 'Enregistrer votre serveur pour rejoindre un programme d\'affilié',

    // logs & statistics
    // icons
    'ui__actionlog__short-title' => 'Journal des actions',
    'ui__actionlog__title' => 'Journal des actions',
    'ui__actionlog__description' => 'Téléchargez le journal des actions et gérez les paramètres du journal des actions.',
    // dropdowns
    'ui__server/statistics__short-title' => 'Infos sur le serveur',
    'ui__server/statistics__title' => 'Infos sur le serveur',
    'ui__server/statistics__description' => 'Statistiques sur les services gérés par Plesk.',
    'ui__admin/report__title' => 'Rapport récapitulatif',
    'ui__admin/report__short-title' => 'Rapport récapitulatif',
    'ui__admin/report__description' => 'Affichez le rapport d\'utilisation du trafic et des ressources pour les revendeurs, clients et domaines.',

    // security
    // icons
    'ui__sessions/properties__short-title' => 'Durée de veille de la session',
    'ui__sessions/properties__title' => 'Durée de veille de la session',
    'ui__sessions/properties__description' => 'Définissez la période d\'inactivité de la session pour les sessions de Plesk.',
    'ui__cp-access__short-title' => 'Accès à Plesk',
    'ui__cp-access__title' => 'Accès à Plesk',
    'ui__cp-access__description' => 'Restreignez l\'accès à Plesk.',
    'ui__sessions__short-title' => 'Sessions actives',
    'ui__sessions__title' => 'Sessions actives',
    'ui__sessions__description' => 'Affichez les sessions Plesk actives.',
    // dropdowns
    'ui__server/certificate_unknown__title' => 'Certificats SSL/TLS',
    'ui__server/certificate_unknown__short-title' => 'Certificats SSL/TLS',
    'ui__server/certificate_unknown__description' => 'La liste des certificats SSL/TLS.',

    // account
    // icons
    'ui__admin-info__short-title' => 'Données personnelles',
    'ui__admin-info__title' => 'Données personnelles',
    'ui__admin-info__description' => 'Changez les données personnelles de votre compte.',
    'ui__admin-password__short-title' => 'Modifier le mot de passe',
    'ui__admin-password__title' => 'Modifier le mot de passe',
    'ui__admin-password__description' => 'Modifiez le mot de passe de votre compte.',
    // dropdowns

    ///
    /// END OF SERVER ADMINISTRATOR
    ///

    ///
    /// RESELLER
    ///

    // business objects

    // statistics
    // icons
    'ui__reseller/limits__short-title' => 'Utilisation des ressources',
    'ui__reseller/limits__title' => 'Utilisation des ressources',
    'ui__reseller/limits__description' => 'Affichez et gérez les ressources utilisées du revendeur %1.',
    'ui__reseller/limits_unknown__short-title' => 'Utilisation des ressources',
    'ui__reseller/limits_unknown__title' => 'Utilisation des ressources',
    'ui__reseller/limits_unknown__description' => 'Affichez et gérez les ressources utilisées du revendeur.',
    'ui__reseller/limits_self__short-title' => 'Utilisation des ressources',
    'ui__reseller/limits_self__title' => 'Utilisation des ressources',
    'ui__reseller/limits_self__description' => "Affichez et gérez vos ressources utilisées.",
    'ui__reseller/limits_readonly-self__short-title' => 'Utilisation des ressources',
    'ui__reseller/limits_readonly-self__title' => 'Utilisation des ressources',
    'ui__reseller/limits_readonly-self__description' => "Affichez les ressources que vous avez utilisées.",
    'ui__reseller/client/traffic_unknown__short-title' => 'Utilisation du trafic par client',
    'ui__reseller/client/traffic_unknown__title' => 'Afficher l\'utilisation du trafic par client',
    'ui__reseller/client/traffic_unknown__description' => 'Affichez les rapports d\'utilisation du trafic des comptes client.',
    'ui__client/traffic_unknown__short-title' => "Utilisation du trafic par client", // temporary for presets
    'ui__client/traffic_unknown__title' => "Afficher l'utilisation du trafic par client", // temporary for presets
    'ui__client/traffic_unknown__description' => "Affichez les rapports d'utilisation du trafic des comptes client.", //  temporary for presets
    'ui__client/domain/hosting/logs_unknown__short-title' => 'Gestionnaire de journaux',
    'ui__client/domain/hosting/logs_unknown__title' => 'Gestionnaire de journaux',
    'ui__client/domain/hosting/logs_unknown__description' => 'Affichez les journaux et configurez la rotation des journaux.',
    // dropdowns
    'ui__reseller/report__title' => 'Rapport récapitulatif',
    'ui__reseller/report__short-title' => 'Rapport récapitulatif',
    'ui__reseller/report__description' => 'Affichez le rapport d\'utilisation du trafic et des ressources pour ce revendeur.',
    'ui__reseller/report_unknown__title' => 'Rapport récapitulatif',
    'ui__reseller/report_unknown__short-title' => 'Rapport récapitulatif',
    'ui__reseller/report_unknown__description' => 'Affichez le rapport d\'utilisation du trafic et des ressources pour le revendeur.',
    'ui__reseller/report_self__title' => 'Rapport récapitulatif',
    'ui__reseller/report_self__short-title' => 'Rapport récapitulatif',
    'ui__reseller/report_self__description' => 'Affichez le rapport de votre utilisation du trafic et des ressources.',

    // account
    // icons
    'ui__client/logo_reseller__title' => 'Apparence de Plesk',
    'ui__client/logo_reseller__short-title' => 'Apparence de Plesk',
    'ui__client/logo_reseller__description' => 'Relookez Plesk pour le revendeur %1.',
    'ui__client/logo_unknown__title' => 'Apparence de Plesk', // temporary for presets
    'ui__client/logo_unknown__short-title' => 'Apparence de Plesk', // temporary for presets
    'ui__client/logo_unknown__description' => 'Relookez Plesk.', // temporary for presets
    'ui__client/logo_self-reseller__title' => 'Apparence de Plesk',
    'ui__client/logo_self-reseller__short-title' => 'Apparence de Plesk',
    'ui__client/logo_self-reseller__description' => 'Relookez votre version de Plesk.',
    'ui__reseller/permissions__title' => 'Droits',
    'ui__reseller/permissions__short-title' => 'Droits',
    'ui__reseller/permissions__description' => "Affichez ou modifiez les actions que le revendeur %1 peut exécuter dans Plesk.",
    'ui__reseller/permissions_unknown__short-title' => 'Droits',
    'ui__reseller/permissions_unknown__title' => 'Droits',
    'ui__reseller/permissions_unknown__description' => "Affichez ou modifiez les actions que le revendeur peut exécuter dans Plesk.",
    'ui__reseller/permissions_self__title' => 'Droits',
    'ui__reseller/permissions_self__short-title' => 'Droits',
    'ui__reseller/permissions_self__description' => 'Affichez la liste des actions que vous pouvez exécuter dans Plesk.',
    'ui__reseller/permissions_readonly-self__title' => 'Droits',
    'ui__reseller/permissions_readonly-self__short-title' => 'Droits',
    'ui__reseller/permissions_readonly-self__description' => 'Affichez la liste des actions que vous pouvez exécuter dans Plesk.',

    // domains
    // icons
    // Domains - see SERVER ADMINISTRATOR/DOMAINS

    // website
    // icons
    'ui__client/domain/domain-alias_unknown__short-title' => 'Alias de domaines',
    'ui__client/domain/domain-alias_unknown__title' => 'Alias de domaines',
    'ui__client/domain/domain-alias_unknown__description' => 'Affichez la liste des noms alternatifs de votre domaine.',
    //dropdowns
    'ui__client/domain/dns_unknown__title' => 'Paramètres DNS',
    'ui__client/domain/dns_unknown__short-title' => 'Paramètres de zone DNS',
    'ui__client/domain/dns_unknown__description' => 'Gérez les paramètres de la zone DNS d\'un domaine.',
    'ui__client/domain/dns_readonly-unknown__title' => 'Paramètres DNS',
    'ui__client/domain/dns_readonly-unknown__short-title' => 'Paramètres DNS',
    'ui__client/domain/dns_readonly-unknown__description' => 'Affichez les paramètres de la zone DNS d\'un domaine.',

    // applications & services
    // icons
    'ui__reseller/extras-domain__short-title' => 'Outils achetés dans MyPlesk.com',
    'ui__reseller/extras-domain__title' => 'Outils achetés dans MyPlesk.com',
    'ui__reseller/extras-domain__description' => 'Achetez d\'autres outils et services dans MyPlesk.com.',
    'ui__reseller/extras-domain_unknown__short-title' => 'Outils achetés dans MyPlesk.com',
    'ui__reseller/extras-domain_unknown__title' => 'Outils achetés dans MyPlesk.com',
    'ui__reseller/extras-domain_unknown__description' => 'Achetez d\'autres outils et services depuis MyPlesk.com.',
    'ui__reseller/extras-domain_self__short-title' => 'Outils achetés dans MyPlesk.com',
    'ui__reseller/extras-domain_self__title' => 'Outils achetés dans MyPlesk.com',
    'ui__reseller/extras-domain_self__description' => 'Achetez d\'autres outils et services dans MyPlesk.com.',
    'ui__reseller/register-domain__short-title' => 'Enregistrer le domaine',
    'ui__reseller/register-domain__title' => 'Enregistrer le domaine',
    'ui__reseller/register-domain__description' => 'Enregistrez un nom de domaine via MyPlesk.com.',
    'ui__reseller/register-domain_unknown__short-title' => 'Enregistrer le domaine',
    'ui__reseller/register-domain_unknown__title' => 'Enregistrer le domaine',
    'ui__reseller/register-domain_unknown__description' => 'Enregistrez un nom de domaine via MyPlesk.com.',
    'ui__reseller/register-domain_self__short-title' => 'Enregistrer le domaine',
    'ui__reseller/register-domain_self__title' => 'Enregistrer le domaine',
    'ui__reseller/register-domain_self__description' => 'Enregistrez un nom de domaine via MyPlesk.com.',
    // dropdowns
    'ui__reseller/manage-domain__title' => 'Gérer le domaine',
    'ui__reseller/manage-domain__short-title' => 'Gérer le domaine',
    'ui__reseller/manage-domain__description' => 'Gérez les noms de domaine enregistrés via MyPlesk.com.',
    'ui__reseller/manage-domain_unknown__title' => 'Gérer le domaine',
    'ui__reseller/manage-domain_unknown__short-title' => 'Gérer le domaine',
    'ui__reseller/manage-domain_unknown__description' => 'Gérez les noms de domaine enregistrés via MyPlesk.com.',
    'ui__reseller/manage-domain_self__title' => 'Gérer le domaine',
    'ui__reseller/manage-domain_self__short-title' => 'Gérer le domaine',
    'ui__reseller/manage-domain_self__description' => 'Gérez les noms de domaine enregistrés via MyPlesk.com.',

    // additional tools
    // icons
    'ui__client/ipaddress_unknown-reseller__title' => 'Adresses IP',
    'ui__client/ipaddress_unknown-reseller__short-title' => 'Adresses IP',
    'ui__client/ipaddress_unknown-reseller__description' => 'Gérez les adresses IP.',
    'ui__client/domain/certificate_unknown__short-title' => 'Certificats SSL/TLS',
    'ui__client/domain/certificate_unknown__title' => 'Certificats SSL/TLS',
    'ui__client/domain/certificate_unknown__description' => 'Installez et gérez des certificats SSL/TLS.',
    'ui__reseller/sessions__short-title' => 'Sessions actives',
    'ui__reseller/sessions__title' => 'Sessions actives',
    'ui__reseller/sessions__description' => 'Affichez les sessions de Plesk actives.',
    'ui__reseller/sessions_unknown__short-title' => 'Sessions actives',
    'ui__reseller/sessions_unknown__title' => 'Sessions actives',
    'ui__reseller/sessions_unknown__description' => 'Affichez les sessions Plesk actives.',
    'ui__reseller/sessions_self__short-title' => 'Sessions actives',
    'ui__reseller/sessions_self__title' => 'Sessions actives',
    'ui__reseller/sessions_self__description' => 'Affichez les sessions Plesk actives.',

    ///
    /// END OF RESELLER
    ///

    ///
    /// CLIENT
    ///

    // business objects
    'mn_list__mail_names_for_client' => 'Comptes mail sous le compte utilisateur %1',

    // domains
    // icons
    // Domains - SERVER ADMINISTRATOR/DOMAINS
    // Domain Templates - SERVER ADMINISTRATOR/DOMAINS

    // dropdowns
    // Create domain - see RESELLER/DOMAINS
    // Create domain template - see RESELLER/DOMAINS
    // Assign new owner for domains - see SERVER ADMINISTRATOR/DOMAINS
    // Convert Domain Administrator Accounts to Client Accounts - see SERVER ADMINISTRATOR/DOMAINS
    // Update Properties of Multiple Domains - see SERVER ADMINISTRATOR/DOMAINS

    // Suspend domains - see SERVER ADMINISTRATOR/DOMAINS
    // Activate domains - see SERVER ADMINISTRATOR/DOMAINS

    // mail
    // icons
    // Mail accounts - RESELLER/MAIL
    // Create mail account - RESELLER/MAIL
    // Create forwarder - RESELLER/MAIL
    // Create autoresponder - RESELLER/MAIL
    // Mailing lists - RESELLER/MAIL
    // Virus protection - RESELLER/MAIL
    // Spam filtering - RESELLER/MAIL
    // Open Webmail - RESELLER/MAIL
    // dropdowns
    // Mail settings - RESELLER/MAIL
    //Create mailing list - RESELLER/MAIL

    // files
    // icons
    // File manager - RESELLER/FILES
    // Anonymous FTP - RESELLER/FILES
    // FTP accounts - RESELLER/FILES    // PFW
    // SSH terminal - RESELLER/FILES    // PFU
    // Virtual directories - RESELLER/FILES    // PFW
    // Web directories - RESELLER/FILES    // PFW

    // statistics
    // icons
    // Web statistics - RESELLER/STATISTICS
    'ui__client/limits__short-title' => 'Utilisation des ressources',
    'ui__client/limits__title' => 'Utilisation des ressources',
    'ui__client/limits__description' => "Affichez et gérez les ressources utilisées du client %1.",
    'ui__client/limits_unknown__short-title' => 'Utilisation des ressources',
    'ui__client/limits_unknown__title' => 'Utilisation des ressources',
    'ui__client/limits_unknown__description' => 'Affichez et gérez les ressources utilisées du client.',
    'ui__client/limits_readonly__short-title' => 'Utilisation des ressources',
    'ui__client/limits_readonly__title' => 'Utilisation des ressources',
    'ui__client/limits_readonly__description' => 'Affichez les ressources utilisées du client %1.',
    'ui__client/limits_self__short-title' => 'Utilisation des ressources',
    'ui__client/limits_self__title' => 'Utilisation des ressources',
    'ui__client/limits_self__description' => "Affichez et gérez vos ressources utilisées.",
    'ui__client/limits_readonly-self__short-title' => 'Utilisation des ressources',
    'ui__client/limits_readonly-self__title' => 'Utilisation des ressources',
    'ui__client/limits_readonly-self__description' => "Affichez les ressources que vous avez utilisées.",
    'ui__client/domain/traffic_unknown__short-title' => "Utilisation du trafic par les domaines %1",
    'ui__client/domain/traffic_unknown__title' => "Afficher l'utilisation du trafic par domaines",
    'ui__client/domain/traffic_unknown__description' => "Affichez les rapports d'utilisation du trafic des domaines.",
    // Log manager - RESELLER/STATISTICS
    // dropdowns
    'ui__client/report__title' => 'Rapport récapitulatif',
    'ui__client/report__short-title' => 'Rapport récapitulatif',
    'ui__client/report__description' => 'Affichez le rapport d\'utilisation du trafic et des ressources pour ce client.',
    'ui__client/report_unknown__short-title' => 'Rapport récapitulatif',
    'ui__client/report_unknown__title' => 'Rapport récapitulatif',
    'ui__client/report_unknown__description' => 'Affichez le rapport d\'utilisation du trafic et des ressources pour le client.',
    'ui__client/report_self__short-title' => 'Rapport récapitulatif',
    'ui__client/report_self__title' => 'Rapport récapitulatif',
    'ui__client/report_self__description' => 'Affichez le rapport de l\'utilisation du trafic et des ressources.',

    // account
    // icons
    'ui__client/preferences__short-title' => 'Préférences de l\'interface',
    'ui__client/preferences__title' => 'Préférences de l\'interface',
    'ui__client/preferences__description' => 'Définissez les préférences de l\'interface de Plesk pour le client %1.',
    'ui__client/preferences_unknown__short-title' => 'Préférences de l\'interface',
    'ui__client/preferences_unknown__title' => 'Préférences de l\'interface',
    'ui__client/preferences_unknown__description' => "Définissez les préférences de l'interface de Plesk pour le client.",
    'ui__client/preferences_self__short-title' => 'Préférences de l\'interface',
    'ui__client/preferences_self__title' => 'Préférences de l\'interface',
    'ui__client/preferences_self__description' => 'Définissez les préférences de l\'interface de Plesk.',
    'ui__client/logo__title' => 'Apparence de Plesk',
    'ui__client/logo__short-title' => 'Apparence de Plesk',
    'ui__client/logo__description' => "Relookez Plesk pour le client %1.",
    'ui__client/logo_self__title' => 'Apparence de Plesk',
    'ui__client/logo_self__short-title' => 'Apparence de Plesk',
    'ui__client/logo_self__description' => 'Relookez Plesk en changeant l\'image du logo et la barre de titre du navigateur.',
    'ui__client/permissions__title' => 'Droits',
    'ui__client/permissions__short-title' => 'Droits',
    'ui__client/permissions__description' => "Affichez ou modifiez les actions que le client %1 peut exécuter dans Plesk.",
    'ui__client/permissions_unknown__short-title' => 'Droits',
    'ui__client/permissions_unknown__title' => 'Droits',
    'ui__client/permissions_unknown__description' => "Affichez ou modifiez les actions que le client peut exécuter dans Plesk.",
    'ui__client/permissions_self__title' => 'Droits',
    'ui__client/permissions_self__short-title' => 'Droits',
    'ui__client/permissions_self__description' => "Affichez la liste des actions que vous pouvez exécuter dans Plesk.",
    'ui__client/permissions_readonly-self__title' => 'Droits',
    'ui__client/permissions_readonly-self__short-title' => 'Droits',
    'ui__client/permissions_readonly-self__description' => "Affichez la liste des actions que vous pouvez exécuter dans Plesk.",

    // website
    // icons
    // Edit in SiteBuilder - RESELLER/WEBSITE
    // Web hosting settings - RESELLER/WEBSITE
    // Subdomains - RESELLER/WEBSITE
    // Domain aliases - RESELLER/ADDITIONAL TOOLS
    // Frontpage Webadmin - RESELLER/WEBSITE
    // Frontpage SSL/TLS Webadmin - RESELLER/WEBSITE
    // Web users - RESELLER/WEBSITE
    // Site preview - RESELLER/WEBSITE
    // dropdowns
    // DNS settings - RESELLER/WEBSITE
    // Change hosting type - RESELLER/WEBSITE
    // FrontPage management - RESELLER/WEBSITE    // PFW
    // Create subdomain - RESELLER/WEBSITE

    // applications & services
    // icons
    // Web applications - RESELLER/APPLICATIONS & SERVICES
    'ui__client/extras-domain__short-title' => 'Outils achetés dans MyPlesk.com',
    'ui__client/extras-domain__title' => 'Outils achetés dans MyPlesk.com',
    'ui__client/extras-domain__description' => 'Achetez d\'autres outils et services dans MyPlesk.com.',
    'ui__client/extras-domain_unknown__short-title' => 'Outils achetés dans MyPlesk.com',
    'ui__client/extras-domain_unknown__title' => 'Outils achetés dans MyPlesk.com',
    'ui__client/extras-domain_unknown__description' => 'Achetez d\'autres outils et services depuis MyPlesk.com.',
    'ui__client/extras-domain_self__short-title' => 'Outils achetés dans MyPlesk.com',
    'ui__client/extras-domain_self__title' => 'Outils achetés dans MyPlesk.com',
    'ui__client/extras-domain_self__description' => 'Achetez d\'autres outils et services dans MyPlesk.com.',
    // Databases - RESELLER/APPLICATIONS & SERVICES
    // Java applications - RESELLER/APPLICATIONS & SERVICES    // PFU
    'ui__client/register-domain__title' => 'Enregistrer le domaine',
    'ui__client/register-domain__short-title' => 'Enregistrer le domaine',
    'ui__client/register-domain__description' => 'Enregistrez un nom de domaine via MyPlesk.com.',
    'ui__client/register-domain_unknown__title' => 'Enregistrer le domaine',
    'ui__client/register-domain_unknown__short-title' => 'Enregistrer le domaine',
    'ui__client/register-domain_unknown__description' => 'Enregistrez un nom de domaine via MyPlesk.com.',
    'ui__client/register-domain_self__title' => 'Enregistrer le domaine',
    'ui__client/register-domain_self__short-title' => 'Enregistrer le domaine',
    'ui__client/register-domain_self__description' => 'Enregistrez un nom de domaine via MyPlesk.com.',
    // dropdowns
    // Install web application - RESELLER/APPLICATIONS & SERVICES
    // Create database - RESELLER/APPLICATIONS & SERVICES
    // Create database user - RESELLER/APPLICATIONS & SERVICES
    // Install Java application - RESELLER/APPLICATIONS & SERVICES
    'ui__client/manage-domain__title' => 'Gérer le domaine',
    'ui__client/manage-domain__short-title' => 'Gérer le domaine',
    'ui__client/manage-domain__description' => 'Gérez les noms de domaine enregistrés via MyPlesk.com.',
    'ui__client/manage-domain_unknown__title' => 'Gérer le domaine',
    'ui__client/manage-domain_unknown__short-title' => 'Gérer le domaine',
    'ui__client/manage-domain_unknown__description' => 'Gérez les noms de domaine enregistrés via MyPlesk.com.',
    'ui__client/manage-domain_self__title' => 'Gérer le domaine',
    'ui__client/manage-domain_self__short-title' => 'Gérer le domaine',
    'ui__client/manage-domain_self__description' => 'Gérez les noms de domaine enregistrés via MyPlesk.com.',

    // additional tools
    // icons
    'ui__client/ipaddress_unknown__title' => 'Adresses IP',
    'ui__client/ipaddress_unknown__short-title' => "Adresses IP",
    'ui__client/ipaddress_unknown__description' => "Gérez les adresses IP.",
    'ui__client/domain/domain-alias_readonly-unknown__short-title' => 'Alias de domaines',
    'ui__client/domain/domain-alias_readonly-unknown__title' => 'Alias de domaines',
    'ui__client/domain/domain-alias_readonly-unknown__description' => 'Affichez la liste des noms alternatifs de votre domaine.',
    // Scheduled tasks - RESELLER/ADDITIONAL TOOLS
    // SSL/TLS certificates - RESELLER/ADDITIONAL TOOLS
    'ui__client/sessions__short-title' => 'Sessions actives',
    'ui__client/sessions__title' => 'Sessions actives',
    'ui__client/sessions__description' => 'Affichez les sessions Plesk actives.',
    'ui__client/sessions_unknown__short-title' => 'Sessions actives',
    'ui__client/sessions_unknown__title' => 'Sessions actives',
    'ui__client/sessions_unknown__description' => 'Affichez les sessions Plesk actives.',
    'ui__client/sessions_self__short-title' => 'Sessions actives',
    'ui__client/sessions_self__title' => 'Sessions actives',
    'ui__client/sessions_self__description' => 'Affichez les sessions Plesk actives.',
    // Shared SSL/TLS - RESELLER/ADDITIONAL TOOLS    // PFW
    // ASP.NET settings - RESELLER/ADDITIONAL TOOLS    // PFW
    // PHP settings - RESELLER/ADDITIONAL TOOLS    // PFW
    // dropdowns
    //Schedule new task - RESELLER/ADDITIONAL TOOLS

    ///
    /// END OF CLIENT
    ///

    ///
    /// DOMAIN / DOMAIN ADMINISTRATOR
    ///

    // statistics
    // icons
    'ui__client/domain/traffic__short-title' => 'Utilisation du trafic %1.',
    'ui__client/domain/traffic__title' => 'Statistiques de transfert des données pour <b>%1</b>',
    'ui__client/domain/traffic__description' => 'Affichez les statistiques du transfert de données pour le domaine %1.',
    'ui__client/domain/traffic_self__short-title' => 'Utilisation du trafic',
    'ui__client/domain/traffic_self__title' => 'Afficher l\'utilisation du trafic de votre domaine',
    'ui__client/domain/traffic_self__description' => 'Affichez le rapport d\'utilisation du trafic pour votre domaine.',
    'ui__client/domain/hosting/logs__short-title' => 'Gestionnaire de journaux',
    'ui__client/domain/hosting/logs__title' => 'Gestionnaire de journaux',
    'ui__client/domain/hosting/logs__description' => 'Affichez les journaux et configurez la rotation des journaux.',
    'ui__client/domain/hosting/logs_self__short-title' => 'Gestionnaire de journaux',
    'ui__client/domain/hosting/logs_self__title' => 'Gestionnaire de journaux',
    'ui__client/domain/hosting/logs_self__description' => 'Affichez les journaux et configurez la rotation des journaux.',

    // domain administration
    // dropdowns
    'ui__client/domain/rename__title' => 'Renommer le domaine',
    'ui__client/domain/rename__short-title' => 'Renommer un domaine',
    'ui__client/domain/rename__description' => 'Renommez le domaine %1.',
    'ui__client/domain/rename_unknown__short-title' => 'Renommer le domaine',
    'ui__client/domain/rename_unknown__title' => 'Renommer le domaine',
    'ui__client/domain/rename_unknown__description' => 'Renommer un domaine',
    'ui__client/domain/chowner_select__title' => 'Affecter un nouveau propriétaire pour le domaine',
    'ui__client/domain/chowner_select__short-title' => 'Affecter un nouveau propriétaire pour l\'abonnement',
    'ui__client/domain/chowner_select__description' => 'Affecter un nouveau propriétaire pour l\'abonnement',
    'ui__client/domain/chowner_unknown-select__short-title' => 'Affecter un nouveau propriétaire pour l\'abonnement',
    'ui__client/domain/chowner_unknown-select__title' => 'Affecter un nouveau propriétaire pour l\'abonnement',
    'ui__client/domain/chowner_unknown-select__description' => 'Affectez un nouveau propriétaire pour un abonnement.',
    'ui__client/domain/toggle__title' => 'Suspendez ou activez le domaine.', // for HP customization
    'ui__client/domain/toggle__short-title' => 'Suspendez ou activez le domaine.', // for HP customization
    'ui__client/domain/toggle__description' => 'Suspendez ou activez le domaine %1.', // for HP customization
    'ui__client/domain/toggle_unknown__title' => 'Suspendez ou activez le domaine.', // for HP customization
    'ui__client/domain/toggle_unknown__short-title' => 'Suspendez ou activez le domaine.', // for HP customization
    'ui__client/domain/toggle_unknown__description' => 'Suspendez ou activez un domaine.', // for HP customization
    'ui__client/domain/toggle_enable__title' => 'Activer le domaine',
    'ui__client/domain/toggle_enable__short-title' => 'Activer un domaine',
    'ui__client/domain/toggle_enable__description' => 'Activez le domaine %1.',
    'ui__client/domain/toggle_disable__title' => 'Suspendre le  domaine',
    'ui__client/domain/toggle_disable__short-title' => 'Suspendre le  domaine',
    'ui__client/domain/toggle_disable__description' => 'Suspendez le domaine %1.',

    // website
    // icons
    // dropdowns
    'ui__client/domain/dns__title' => 'Paramètres DNS',
    'ui__client/domain/dns__short-title' => 'Paramètres DNS',
    'ui__client/domain/dns__description' => 'Gérez les paramètres de la zone DNS du domaine %1.',
    'ui__client/domain/dns_self__title' => 'Paramètres DNS',
    'ui__client/domain/dns_self__short-title' => 'Paramètres DNS',
    'ui__client/domain/dns_self__description' => 'Gérez les paramètres de la zone DNS de votre domaine.',
    'ui__client/domain/dns_disabled__title' => 'Paramètres DNS',
    'ui__client/domain/dns_disabled__short-title' => 'Paramètres DNS',
    'ui__client/domain/dns_disabled__description' => 'Gérez les paramètres de la zone DNS du domaine %1.',
    'ui__client/domain/dns_self-disabled__title' => 'Paramètres DNS',
    'ui__client/domain/dns_self-disabled__short-title' => 'Paramètres DNS',
    'ui__client/domain/dns_self-disabled__description' => 'Gérez les paramètres de la zone DNS de votre domaine.',
    'ui__client/domain/dns_readonly__title' => 'Paramètres DNS',
    'ui__client/domain/dns_readonly__short-title' => 'Paramètres DNS',
    'ui__client/domain/dns_readonly__description' => 'Affichez les paramètres de la zone DNS du domaine %1.',
    'ui__client/domain/dns_readonly-self__title' => 'Paramètres DNS',
    'ui__client/domain/dns_readonly-self__short-title' => 'Paramètres DNS',
    'ui__client/domain/dns_readonly-self__description' => 'Affichez les paramètres de la zone DNS de votre domaine.',
    'ui__client/domain/dns_readonly-self-disabled__title' => 'Paramètres DNS',
    'ui__client/domain/dns_readonly-self-disabled__short-title' => 'Paramètres DNS',
    'ui__client/domain/dns_readonly-self-disabled__description' => 'Affichez les paramètres de la zone DNS de votre domaine.',
    'ui__client/domain/dns_readonly-self-slave__title' => 'Paramètres DNS',
    'ui__client/domain/dns_readonly-self-slave__short-title' => 'Paramètres DNS',
    'ui__client/domain/dns_readonly-self-slave__description' => 'Affichez les paramètres de la zone DNS de votre domaine.',
    'ui__client/domain/dns_slave__title' => 'Paramètres DNS',
    'ui__client/domain/dns_slave__short-title' => 'Paramètres DNS',
    'ui__client/domain/dns_slave__description' => 'Gérez les paramètres de la zone DNS du domaine %1.',
    'ui__client/domain/dns_self-slave__title' => 'Paramètres DNS',
    'ui__client/domain/dns_self-slave__short-title' => 'Paramètres DNS',
    'ui__client/domain/dns_self-slave__description' => 'Gérez les paramètres de la zone DNS de votre domaine.',
    // FrontPage management - RESELLER/WEBSITE    // PFW

    // applications & services
    // icons
    'ui__client/domain/extras__short-title' => 'Outils achetés dans MyPlesk.com',
    'ui__client/domain/extras__title' => 'Outils achetés dans MyPlesk.com',
    'ui__client/domain/extras__description' => 'Achetez d\'autres outils et services dans MyPlesk.com.',
    'ui__client/domain/extras_unknown__short-title' => 'Outils achetés dans MyPlesk.com',
    'ui__client/domain/extras_unknown__title' => 'Outils achetés dans MyPlesk.com',
    'ui__client/domain/extras_unknown__description' => 'Achetez d\'autres outils et services depuis MyPlesk.com.',
    'ui__client/domain/extras_self__short-title' => 'Outils achetés dans MyPlesk.com',
    'ui__client/domain/extras_self__title' => 'Outils achetés dans MyPlesk.com',
    'ui__client/domain/extras_self__description' => 'Achetez d\'autres outils et services dans MyPlesk.com.',
    // Java applications - RESELLER/APPLICATIONS & SERVICES    // PFU
    'ui__client/domain/register__short-title' => 'Enregistrer le domaine',
    'ui__client/domain/register__title' => 'Enregistrer le domaine',
    'ui__client/domain/register__description' => 'Enregistrez un nom de domaine via MyPlesk.com.',
    'ui__client/domain/register_unknown__short-title' => 'Enregistrer le domaine',
    'ui__client/domain/register_unknown__title' => 'Enregistrer le domaine',
    'ui__client/domain/register_unknown__description' => 'Enregistrez un nom de domaine via MyPlesk.com.',
    'ui__client/domain/register_self__short-title' => 'Enregistrer le domaine',
    'ui__client/domain/register_self__title' => 'Enregistrer le domaine',
    'ui__client/domain/register_self__description' => 'Enregistrez un nom de domaine via MyPlesk.com.',
    // dropdowns
    // Create database user - RESELLER/APPLICATIONS & SERVICES

    // additional tools
    // icons
    // Domain aliases - RESELLER/ADDITIONAL TOOLS
    // Scheduled tasks - RESELLER/ADDITIONAL TOOLS    // PFU
    // SSL/TLS certificates - RESELLER/ADDITIONAL TOOLS
    // dropdowns


    ///
    /// END OF DOMAIN / DOMAIN ADMINISTRATOR
    ///

    ////
    //// KEYS FOR BUSINESS OBJECT LISTS/PAGES (RESELLERS, CLIENTS, DOMAINS)
    ////

    ///
    /// DOMAINS
    ///

    // Domains list page title - ui__client/domain_unknown__short-title (HOME)

    // tools
    'ui__client/domain#tools__title' => "Outils",
    // Below: TBD
    'ui__client/domain-summary-report_unknown__short-title' => 'Afficher les statistiques',
    'ui__client/domain-summary-report_unknown__title' => 'Afficher les statistiques',
    'ui__client/domain-summary-report_unknown__description' => 'Affichez les informations sur l\'utilisation des ressources par domaine.',
    'ui__client/domain-summary-report__short-title' => "Afficher les statistiques",
    'ui__client/domain-summary-report__title' => "Afficher les statistiques",
    'ui__client/domain-summary-report__description' => "Affichez les informations sur l'utilisation des ressources par domaine.",
    'ui__client/domain-summary-report_self__short-title' => "Afficher les statistiques",
    'ui__client/domain-summary-report_self__title' => "Afficher les statistiques",
    'ui__client/domain-summary-report_self__description' => "Affichez les informations sur l'utilisation des ressources par vos domaines.",
    // Traffic usage - ui__client/domain/traffic_unknown__short-title

    'ui__client/domain#list__title' => "Domaines", // DOMAINS

    // list object operation errors
    'ui__client/domain/delete__empty_selection' => 'Vous devez sélectionner les domaines que vous voulez supprimer',
    'ui__client/domain/chowner__empty_selection' => 'Vous devez sélectionner les domaines que vous voulez affecter à un autre propriétaire.',

    // list objects filtering
    'domains_list__name__filter_title' => 'Nom',
    'domains_list__state__filter_title' => 'Utilisation des ressources',
    'domains_list__filter_state_any' => 'Tou(te)s',
    'domains_list__filter_state_overuse' => 'surutilisation',
    'domains_list__filter_state_normal' => 'Dans les limites',
    'domains_list__status__filter_title' => 'Statut',
    'domains_list__filter_status_any' => 'Tou(te)s',
    'domains_list__filter_status_blocked' => 'Suspendu',
    'domains_list__filter_status_active' => 'Actif',
    'domains_list__ownership__filter_title' => 'Propriété',
    'domains_list__filter_ownership_all' => 'Tous les domaines',
    'domains_list__filter_ownership_personal' => 'Mes domaines uniquement',
    'domains_list__filter_owner_pname__filter_title' => 'Nom du propriétaire',
    'domains_list__subrows__filter_title' => 'Afficher',
    'domains_list__subrows_off' => 'Domaines uniquement',
    'domains_list__subrows_subdomain_domainaliases' => 'Avec des sous-domaines et des alias',
    'domains_list__subrows_subdomain' => 'Avec des sous-domaines',
    'domains_list__subrows_domainaliases' => 'Avec des alias',

    // objects list
    'domains_list__owner__title' => 'Propriétaire',

    ///
    /// END OF DOMAINS
    ///

    ////
    //// KEYS FOR APPLICATION VAULT AND WEB APPLICATION MANAGEMENT
    ////

    ///
    /// APPLICATION VAULT / APS CATALOG
    ///

    // Application Vault / APS Catalog promotional block
    'site_apps__promo_browse_for_applications' => "Parcourir les applications",
    'site_apps__promo_main_text' => "Le catalogue Application Packaging Standard (APS) contient la liste des applications qui peuvent être dimensionnées pour un domaine ou un espace Web. Si vous souhaitez dimensionner des applications qui ne sont pas actuellement dans le catalogue, vous pouvez facilement le faire en suivant les instructions de packaging APS sur www.apsstandard.com",
    'site_apps__promo_download_now' => "Téléchargez les applications :",
    'site_apps__promo_close' => "Fermer ce bloc",
    'site_apps__promo_preset__mostused' => '%1 la plus populaire',
    'site_apps__promo_preset__lessused' => '%1 suivante la plus populaire',
    'site_apps__promo_preset__all' => "Tout",
    'site_apps__promo_disclaimer_note' => 'Veuillez noter que les applications installées depuis le catalogue APS sont fournies par les parties tierces et ne sont pas prises en charge par Plesk.',
    'site_apps__promo_preset__page_title' => '%1 Applications APS',

    // Progress bar
    'site_apps__progress_initialization_message' => 'Ajout des applications...',

    // Errors
    'site_apps__no_applications_for_update' => 'Vous n\'avez aucune application installée dans le référentiel d\'applications.',
    'site_apps__incorrect_download_preset_configuration' => 'Des erreurs ont été trouvées dans la configuration des paramètres prédéfinis de téléchargement du Catalogue APS.',
    'site_apps__aps_catalog_url_is_invalid' => 'L\'URL indiquée n\'est pas correcte.',
    'site_apps__no_updates_at_the_moment' => 'Il n\'y a aucune mise à jour d\'applications disponible pour le moment.',
    'site_apps__incorrect_content_returned_by_catalog' => 'Des informations incorrectes ont été reçues à partir du catalogue des applications APS. Veuillez réessayer ultérieurement.',
    'site_apps__entered_aps_catalog_url_is_not_valid' => 'Les préférences du catalogue APS ont été sauvegardées mais Plesk n\'a pas pu établir de connexion au catalogue APS indiqué dans les préférences du catalogue APS (%1). Assurez-vous que l\'adresse du catalogue APS est correcte et que le catalogue APS est actif à cette adresse.',
    'site_apps__cannot_retrieve_updates' => 'Impossible de télécharger les mises à jour de l\'application pour le moment : impossible d\'établir la connexion au catalogue APS (%1). Assurez-vous que l\'adresse du catalogue APS est correcte et que le catalogue APS à cette adresse est actif.',
    'site_apps__no_site_applications_in_client_pool_to_install' => 'Il n\'y a aucune application Web disponible pour l\'installation.',
    'site_apps__site_applications_already_installed_in_root' => 'D\'autres applications Web sont déjà installées dans les répertoires root de ces hôtes virtuels.',
    'site_apps__dot_net_packages_not_supported_on_unix_platform' => "Les applications Web .NET ne sont pas prises en charge sur la plate-forme Unix/Linux.",
    'site_apps__server_wide_packages_not_supported' => 'Les applications Web sur tout le serveur ne sont pas prises en charge.',
    'site_apps__applications_added_to_queue_for_adding_to_application_vault' => "L'ajout de %1 applications Web supplémentaires dans le référentiel d'applications est planifiée.",
    'site_apps__applications_all_in_vault' => "Les applications Web sélectionnées sont déjà présentes dans le référentiel d'applications.",
    'site_apps__applications_already_in_download_queue' => "%1 applications Web sélectionnées sont en train d'être ajoutées dans le référentiel d'applications en ce moment.",
    'site_apps__applications_already_in_valut' => "%1 applications Web sélectionnées sont déjà dans le référentiel d'applications.",

    // UI errors

    ///
    /// END OF APPLICATION VAULT / APS CATALOG
    ///

    ///
    /// APS CATEGORIES
    ///

    // General
    'site_apps__not_categorized' => 'Autres (aucune catégorie)',

    // Errors
    'site_apps__no_applications_in_category' => 'Aucune application disponible dans cette catégorie. Veuillez sélectionner d\'autres catégories.',
    'site_apps__no_category_selected__please_specify' => 'Sélectionnez une catégorie dans le menu de gauche. Toutes les applications disponibles dans la catégorie sélectionnée seront listées dans cette fenêtre.',

    // Category: Back office
    // Category: Collaboration
    // Category: Front Office
    // Category: Infrastructure
    // Category: Personal
    // Category: Web

    ///
    /// END OF APS CATEGORIES
    ///

    ///
    /// APPLICATION VAULT
    ///

    //removal


    ///
    /// END OF APPLICATION VAULT
    ///

    ////
    //// KEYS FOR SETTINGS PAGE
    ////

    ///
    /// SERVER ADMINISTRATOR SETTINGS
    ///

    'administrator_account' => 'Compte administrateur',
    // Personal data - HOME/SERVER ADMINISTRATOR/ACCOUNT
    // Change password - HOME/SERVER ADMINISTRATOR/ACCOUNT
    // Interface preferences - HOME/SERVER ADMINISTRATOR/ACCOUNT

    'general' => 'Général',
    // Server settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_change_hostname' => 'Changer le nom d\'hôte',
    // System time - HOME/SERVER ADMINISTRATOR/SERVER
    // IP addresses - HOME/SERVER ADMINISTRATOR/SERVER
    // Scheduled tasks - HOME/SERVER ADMINISTRATOR/SERVER
    // FTP settings - HOME/SERVER ADMINISTRATOR/SERVER    // PFW

    'security' => 'Sécurité',
    'bt_setup_firewall' => 'Configurer le pare-feu',
    'bt_manage_firewall_rules' => 'Gérer les règles du pare-feu',
    'cu_firewall__rule' => 'Créer une règle de pare-feu',
    'cu_firewall__protocol' => 'Définir un protocole pour la règle (\'tcp\' ou \'udp\')',
    'cu_firewall__name' => "Définir un nom de règle",
    'cu_firewall__disabled' => 'Si \'true\' (vrai), la règle est désactivée après la création',
    // Session idle time - HOME/SERVER ADMINISTRATOR/SECURITY
    // SSL/TLS certificates - HOME/SERVER ADMINISTRATOR/SECURITY
    // Shared SSL/TLS - HOME/SERVER ADMINISTRATOR/SECURITY    // PFW

    'dns' => 'DNS',
    'bt_select_dns_server' => 'Sélectionner le serveur DNS', // PFW
    'bt_soa_records_template' => 'Template d\'enregistrements SOA',
    'bt_restrict_creation_of_subzones' => 'Limiter la création de sous-zones',

    'databases' => 'Bases de données',
    // Database hosting preferences - HOME/SERVER ADMINISTRATOR/SERVER

    'applications' => 'Applications',
    // ASP.NET settings - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES    // PFW
    // IIS application pool - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES    // PFW
    // SiteBuilder settings - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES

    'mail' => 'Boîte mail',
    'bt_select_mailserver' => 'Sélectionner le serveur de messagerie', // PFW
    // Mail server settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_select_antivirus' => 'Sélectionner l\'antivirus', // PFW
    'bt_virus_protection_settings' => 'Paramètres de protection antivirus',
    'bt_select_spamfilter' => 'Sélectionner le filtre anti-spam', // PFW
    // Spam filter settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_select_webmail' => 'Sélectionner la messagerie Web',
    // Set up mailing lists server - HOME/SERVER ADMINISTRATOR/SERVER    // PFU

    'logs_and_statistics' => 'Journaux & Statistiques',
    'bt_server_statistics_settings' => 'Paramètres des statistiques du serveur',
    'bt_select_web_statistics' => 'Logiciel des statistiques Web disponibles', // PFW
    // Action log - HOME/SERVER ADMINISTRATOR/LOGS & STATISTICS

    'control_panel_interface' => 'Interface de Plesk',

    'components_and_modules' => 'Composants & modules',
    // Server components - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_setup_watchdog' => 'Configurer Watchdog', // PFU
    'bt_setup_vpn' => 'Configurer le VPN', // PFU
    'bt_setup_samba' => 'Configurer Samba',    // PFU

    ///
    /// END OF SERVER ADMINISTRATOR SETTINGS
    ///

    ///
    /// DOMAIN SETTINGS
    ///

    'ui__client/domain/settings_self__title' => 'Paramètres',
    'ui__client/domain/settings_self__short-title' => 'Paramètres',
    'ui__client/domain/settings_self__description' => 'Affichez et changez les paramètres de domaine.',

    'domain_administrator_account' => 'Compte administrateur de domaines',
    // Interface preferences - HOME/DOMAIN ADMINISTRATOR/DOMAIN
    'bt_account_settings' => 'Paramètres du compte',

    'domain' => 'Domaine',
    'bt_dns_soa_records' => 'Enregistrements SOA DNS',
    // Mail settings - HOME/DOMAIN ADMINISTRATOR/MAIL
    'bt_task_scheduler_settings' => 'Paramètres du planificateur de tâches',

    'website' => 'Site Web',
    // Web hosting settings - HOME/DOMAIN ADMINISTRATOR/WEBSITE
    // Bandwidth limiting - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS
    'bt_web_users_scripting' => 'Script pour les utilisateurs Web',
    // Anonymous FTP - HOME/DOMAIN ADMINISTRATOR/FILES

    // Applications - SETTINGS/SERVER/APPLICATIONS    // PFW
    // ASP.NET settings - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW
    // PHP settings - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW
    // IIS application pool - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW

    // Security - SETTINGS/SERVER/SECURITY
    'bt_select_ssl_certificate' => 'Sélectionner le certificat SSL/TLS',
    // Shared SSL/TLS - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW

    // Logs & statistics - SETTINGS/SERVER/LOGS & STATISTICS
    'bt_web_statistics' => 'Statistiques Web',
    'bt_log_rotation_settings' => 'Paramètres de rotation des journaux',

    ///
    /// END OF DOMAIN SETTINGS
    ///

    ////
    //// KEYS FOR LIMITS AND PERMISSIONS
    ////

    ///
    /// LIMITS
    ///

    '__limits' => "Limites", // template

    // overuse & oversell
    'limits__overuse_oversell_policy_legend' => "Politique de survente et de surutilisation",
    'limits__overuse_policy_legend' => "surutilisation",
    'limits__oversell_policy_legend' => "Survendre",
    'limits__reseller_overuse_description' => "La politique de surutilisation indique à Plesk la procédure à suivre lorsque les ressources sont surutilisées.",
    'limits__overuse_text' => "Politique de surutilisation",

    // limit names
    'limit_group__disk_space_and_traffic' => 'Espace disque et trafic',
    'limit__disk_space' => 'Espace disque',
    'limit__max_traffic' => 'Trafic',
    'limit_group__client' => 'Clients',
    'limit__max_cl' => 'Clients',
    'limit_group__domain' => 'Domaines',
    'limit__max_dom' => 'Domaines',
    'limit__max_dom_powerUser' => 'Abonnements',
    'limit__max_subdom' => 'Sous-domaines',
    'limit__max_dom_aliases' => 'Alias de domaines',
    'limit__max_wu' => 'Utilisateurs Web',
    'limit__max_subftp_users' => 'Comptes FTP supplémentaires', // PFW
    'limit_group__mail' => 'Boîte mail',
    'limit__max_box' => 'Boîtes mail',
    'limit__mbox_quota' => 'Volume de la boîte mail',
    'limit__total_mboxes_quota' => 'Quota total de boîtes mail', // PFW
    'limit__max_maillists' => 'Listes de diffusion',
    'limit_group__database' => 'Bases de données',
    'limit__max_mssql_db' => 'Bases de données Microsoft SQL Server', // PFW
    'limit__mssql_dbase_space' => 'Quota total de bases de données MS SQL', // PFW
    'limit__max_odbc' => 'Connexions ODBC', // PFW
    // limit__max_db - CONFLICTED
    'limit__mysql_dbase_space' => 'Quota de bases de données MariaDB/MySQL', // PFW
    'limit__pgsql_dbase_space' => 'Quota de bases de données PostgreSQL', // PFW
    'limit_group__application' => 'Applications',
    'limit__max_iis_app_pools' => 'Pools d\'applications IIS', // PFW
    'limit_group__security' => 'Sécurité',
    'limit_group__validity' => 'Date d\'expiration',
    'limit__expiration' => 'Date d\'expiration',
    'limit__validity' => 'Période de validité',
    'limit__max_site_builder' => 'Sites publiés avec Presence Builder',
    'limit__max_site' => 'Domaines',
    'limit__mssql_dbase_filesize' => 'Taille du fichier de bases de données MS SQL',
    'limit__mssql_dbase_log_filesize' => 'Taille du fichier journal de la base de données MS SQL',
    'limit__mssql_dbase_filesize_hint' => 'La taille maximum du fichier d\'une base de données Microsoft SQL.',
    'limit__mssql_dbase_log_filesize_hint' => 'La taille maximum du fichier journal d\'une base de données Microsoft SQL.',
    'limit__units_mssql_dbase_filesize' => "Mo",
    'limit__units_mssql_dbase_log_filesize' => "Mo",

    'dom_pref__invalid_max_site_limit' => 'Limite des domaines incorrecte. La valeur minimum est de 1.',

    'property__has_wrong_value' => 'La valeur de la propriété %1 est incorrecte.',
    'property__name_outgoing_messages_domain_limit' => 'Définit la limite des mails sortants d\'un domaine (par heure). Pour définir la valeur illimitée, indiquez "-1". Pour utiliser la valeur indiquée dans les paramètres pour tout le serveur, indiquez "default".',
    'property__name_outgoing_messages_mbox_limit' => 'Définit la limite des messages sortants d\'une boîte mail (par heure). Pour définir la valeur illimitée, indiquez "-1". Pour utiliser la valeur indiquée dans les paramètres pour tout le serveur, indiquez "default".',
    'property__name_outgoing_messages_subscription_limit' => 'Définit la limite des messages sortants d\'un abonnement (par heure). Pour définir la valeur illimitée, indiquez "-1". Pour utiliser la valeur indiquée dans les paramètres pour tout le serveur, indiquez "Par défaut".',

    // for CLI report & email notifications
    '__resource_notify' => 'Notifier',
    '__general' => 'Général',
    '__template_shared' => 'Template partagé',
    'limit__overuse' => 'Politique de surutilisation',
    'limit__max_traffic_soft' => 'Notifier lorsque l\'utilisation du trafic max a été atteinte',
    'limit__disk_space_soft' => 'Notifier lorsque l\'utilisation de l\'espace disque max a été atteinte',
    '__overuse' => 'Politique de surutilisation',
    'performance__title' => 'Performances',
    'performance__bandwidth' => 'Utilisation maximum de la bande passante (Ko/s)',
    'performance__max_connections' => 'Connexions limitées à',

    'gch__hosting_php_isapi' => 'Exécuter PHP en tant qu\'extension ISAPI',
    'gch__hosting_ssi_html' => 'Utiliser SSI pour les fichiers *.htm, *.html',
    'gch__hosting_php_handler_type' => 'exécuter PHP comme',
    'gch__hosting_php_handler_id' => 'exécuter PHP comme',
    'gch__hosting_php_served_by_nginx' => 'PHP servi par Nginx',
    'gch__hosting_unpaid_website_status' => 'Statut des sites Web dans les abonnements suspendus',
    'gch__mn_no_autoresponder' => 'Il n\'y a aucune réponse automatique configurée pour le compte mail.',
    'gch__no_clients_selected' => "Aucun compte client sélectionné",
    'gch__no_domains_selected' => "Aucun domaine choisi",

    // limit units
    'limit__units_disk_space' => "Mo",
    'limit__units_max_traffic' => "Mo/mois",
    'limit__units_mbox_quota' => "Ko",
    'limit__units_mysql_dbase_space' => "Mo", // PFW
    'limit__units_mssql_dbase_space' => "Mo", // PFW
    'limit__units_pgsql_dbase_space' => "Mo", // PFW
    'limit__units_total_mboxes_quota' => "Mo", // PFW

    // manipulations and statuses of limits
    '__resource_name' => 'Nom de la ressource',
    '__resource_usage' => 'Utilisé',
    '__resource_limit' => 'Limite',

    '__used' => 'Utilisé',
    '__limit' => 'Limite',

    '__never_expires' => 'N\'expire jamais',
    '__resource_free' => '%1 libre sur %2',
    '__resource_unlimited' => '%1 utilisé sur un nombre illimité',

    '__unlimited' => 'Illimité',
    '__increment' => "Augmenter (+)",
    '__decrement' => "Réduire (-)",
    '__pt' => 'unités',
    '__procent' => '%',
    '__overused' => 'Surutilisé',
    '__left' => 'laissé',
    '__available' => 'Disponible',
    '__not_available' => 'Non inclus',

    ///
    /// END OF LIMITS
    ///

    ///
    /// PERMISSIONS
    ///

    //permissions hints

    ///
    /// END OF PERMISSIONS
    ///

    ////
    //// KEYS FOR STATISTICS AND REPORTS
    ////

    ///
    /// REPORT
    ///

    // administrator

    'ui__admin/report/layout/auto_unknown__short-title' => 'Planification d\'envoi',
    'ui__admin/report/layout/auto_unknown__title' => 'Planification d\'envoi du rapport',
    'ui__admin/report/layout/auto_unknown__description' => 'Choisissez la planification d\'envoi du rapport pour un style de rapport.',
    'ui__admin/report/layout/auto/properties_new__short-title' => 'Ajouter la planification d\'envoi du rapport',
    'ui__admin/report/layout/auto/properties_new__title' => 'Ajouter la planification d\'envoi du rapport',
    'ui__admin/report/layout/auto/properties_new__description' => 'Ajouter une nouvelle planification d\'envoi du rapport pour le rapport %1.',
    'ui__admin/report/layout/auto/properties__short-title' => 'Planification d\'envoi du rapport',
    'ui__admin/report/layout/auto/properties__title' => 'Planification d\'envoi du rapport',
    'ui__admin/report/layout/auto/properties__description' => 'Affichez et modifiez les propriétés de la planification de l\'envoi du rapport.',
    'ui__admin/report/layout/auto/delete_multi__short-title' => 'Supprimer la planification d\'envoi du rapport',
    'ui__admin/report/layout/auto/delete_multi__title' => 'Supprimer la planification d\'envoi du rapport',
    'ui__admin/report/layout/auto/delete_multi__description' => 'Supprimez les planifications d\'envoi du rapport sélectionné.',

    'ui__admin/report/layout_unknown__short-title' => 'Styles de rapport',

    // reselle
    'ui__reseller/traffic__short-title' => '%1',
    'ui__reseller/traffic__title' => 'Voir l\'utilisation du trafic pour <b>%1</b>',
    'ui__reseller/traffic__description' => 'Affichez les rapports d\'utilisation du trafic du compte revendeur %1.',
    'ui__reseller/traffic_self__short-title' => 'Mes',
    'ui__reseller/traffic_self__title' => 'Afficher l\'utilisation du trafic par client',
    'ui__reseller/traffic_self__description' => 'Affichez les rapports d\'utilisation du trafic de vos comptes client.',

    ///
    /// END OF REPORT
    ///

    ///
    /// SUMMARY / FULL REPORT
    ///

    // common full report
    'report__full_p' => 'P',
    'report__full_s' => 'S',
    'report__full_h' => 'H',
    'report__full_reseller_name' => 'Nom du revendeur', // reseller report
    'report__full_client_name' => 'Nom du client', // customer report
    'report__full_domain_name' => 'Nom de domaine', // domain report
    'report__full_owner' => 'Propriétaire', // customer & domain reports
    'report__full_creation_date' => 'Date de création',
    'report__full_size' => 'Taille',
    'report__full_traffic' => 'Trafic',
    'report__full_active_clients' => 'Clients actifs', // reseller report
    'report__full_clients' => 'Clients', // reseller report
    'report__full_active_domains' => 'Domaines actifs', // reseller & customer reports
    'report__full_domains' => 'Domaines', // reseller & customer reports
    'report__full_subdomains' => 'Sousdom',
    'report__full_mboxes' => 'BoîtesM',
    'report__full_disk_space' => 'Espace disque',
    'report__full_mail_groups' => 'RedirMail',
    'report__full_mail_autoresp' => 'Autorép',
    'report__full_mail_antispam' => 'ASpam',
    'report__full_mail_antivirus' => 'AVir',
    'report__full_mail_lists' => 'Listediff',
    'report__full_web_users' => 'UtiWeb',
    'report__full_mysql_databases' => 'BD MariaDB/MySQL',
    'report__full_mssql_databases' => 'MSSQL DB',
    'report__full_pgsql_databases' => 'BD PostgreSQL',

    // common summary report
    'report__section_general' => 'Général',
    'report__version' => 'Version du produit',
    'report__build' => 'Build du produit',
    'report__status' => 'Statut',
    'report__company_name' => 'Raison sociale',
    'report__personal_name' => 'Nom personnel',
    'report__login' => 'Nom d\'utilisateur',
    'report__phone' => 'Téléphone',
    'report__fax' => 'Fax',
    'report__email' => 'Adresse mail',
    'report__address' => 'Adresse',
    'report__city' => 'Ville',
    'report__state' => 'Région/Département',
    'report__zip_code' => 'Code postal/CP',
    'report__country' => 'Pays',
    'report__creation_date' => 'Date de création',
    'report__expiration_date' => 'Date d\'expiration',
    'report__dumps_total_size' => 'Taille totale des fichiers de sauvegarde',
    'report__section_resellers' => 'Revendeurs',
    'report__active_resellers' => 'Revendeurs avec des abonnements actifs',
    'report__resellers' => 'Revendeurs',
    'report__section_full_resellers' => 'Revendeurs',
    'report__section_clients' => 'Clients',
    'report__active_clients' => 'Clients avec des abonnements actifs',
    'report__clients' => 'Clients',
    'report__section_full_clients' => 'Clients',
    'report__section_personal_clients' => 'Clients personnels',
    'report__active_personal_clients' => 'Vos clients personnels avec des abonnements actifs',
    'report__personal_clients' => 'Clients personnels',
    'report__section_full_personal_clients' => 'Clients personnels',
    'report__section_domains' => 'Domaines',
    'report__disk_usage' => 'Utilisation du disque',
    'report__traffic' => 'Trafic',
    'report__active_domains' => 'Domaines actifs',
    'report__domains' => 'Domaines',
    'report__subdomains' => 'Sous-domaines',
    'report__mboxes' => 'Boîtes mail',
    'report__mail_groups' => 'Redirection de mails',
    'report__mail_autoresp' => 'Réponses automatiques',
    'report__mail_lists' => 'Listes de diffusion',
    'report__web_users' => 'Utilisateurs Web',
    'report__mysql_databases' => 'Bases de données MariaDB/MySQL',
    'report__mssql_databases' => 'Bases de données MSSQL',
    'report__pgsql_databases' => 'Bases de données PostgreSQL',
    'report__section_full_domains' => 'Domaines',
    'report__section_personal_domains' => 'Domaines personnels',
    // keys here are the same as in report__section_domains section
    'report__section_full_personal_domains' => 'Domaines personnels',

    //New for Plesk 10
    'report__sitebuilder_sites' => 'Sites publiés avec Presence Builder',
    'report__invalid_email' => 'Veuillez indiquer une adresse mail valide.',


    // CLI-specific sections
    'report__section_hosting' => 'Hébergement',
    'report__section_webusers' => 'Utilisateurs Web',
    'report__section_mailnames' => 'Comptes mail',
    'report__section_maillists' => 'Listes de diffusion',
    'report__section_databases' => 'Bases de données',
    'report__section_siteapps' => 'Applications Web',
    'report__section_aspnetapps' => 'Applications ASP.NET', // PFW
    'report__owner_pname' => "Nom personnel du fournisseur",
    'report__owner_login' => "Nom d'utilisateur du fournisseur",

    ///
    /// END OF SUMMARY / FULL REPORT
    ///

    'ui__reseller/report/layout/auto_unknown__short-title' => 'Planification d\'envoi',
    'ui__reseller/report/layout/auto_unknown__title' => 'Planification d\'envoi du rapport',
    'ui__reseller/report/layout/auto_unknown__description' => 'Choisissez la planification d\'envoi du rapport pour un style de rapport.',
    'ui__reseller/report/layout/auto/properties_new__short-title' => 'Ajouter la planification d\'envoi du rapport',
    'ui__reseller/report/layout/auto/properties_new__title' => 'Ajouter la planification d\'envoi du rapport',
    'ui__reseller/report/layout/auto/properties_new__description' => 'Ajouter une nouvelle planification d\'envoi du rapport pour le rapport %1.',
    'ui__reseller/report/layout/auto/properties__short-title' => 'Planification d\'envoi du rapport',
    'ui__reseller/report/layout/auto/properties__title' => 'Planification d\'envoi du rapport',
    'ui__reseller/report/layout/auto/properties__description' => 'Affichez et modifiez les propriétés de la planification de l\'envoi du rapport.',
    'ui__reseller/report/layout/auto/delete_multi__short-title' => 'Supprimer la planification d\'envoi du rapport',
    'ui__reseller/report/layout/auto/delete_multi__title' => 'Supprimer la planification d\'envoi du rapport',
    'ui__reseller/report/layout/auto/delete_multi__description' => 'Supprimez les planifications d\'envoi du rapport sélectionné.',

    'ui__reseller/report/layout_unknown__short-title' => 'Styles de rapport',

    // customer
    'ui__client/traffic__short-title' => '%1',
    'ui__client/traffic__title' => 'Voir l\'utilisation du trafic pour <b>%1</b>',
    'ui__client/traffic__description' => 'Affichez les rapports d\'utilisation du trafic pour le compte client %1.',
    'ui__client/traffic_self__short-title' => 'Utilisation du trafic',
    'ui__client/traffic_self__title' => 'Utilisation du trafic par domaine',
    'ui__client/traffic_self__description' => 'Affichez les rapports d\'utilisation du trafic de vos domaines.',

    ////
    //// KEYS FOR VARIOUS FEATURES
    ////

    ///
    /// SERVER INTERFACE
    ///

    // Locales
    // errors
    'locales__not_allowed' => 'Le pack de langue spécifié est installé, mais n\'est pas activé dans le système.',

    ///
    /// END OF SERVER INTERFACE
    ///

    ///
    /// HOME PAGE CUSTOMIZATION
    ///

    ///
    /// SESSIONS
    ///

    // Entry keys are under respective HP/ADDITIONAL TOOLS/ACTIVE SESSIONS

    // administrator
    'ui__sessions/delete__short-title' => 'Supprimer les sessions',
    'ui__sessions/delete__title' => 'Supprimer les sessions',
    'ui__sessions/delete__description' => 'Supprimez les sessions sélectionnées.',
    'ui__ftp-sessions__short-title' => 'Sessions FTP',
    'ui__ftp-sessions__title' => 'Sessions FTP',
    'ui__ftp-sessions__description' => 'Affichez les sessions FTP.',
    'ui__ftp-sessions/delete__short-title' => 'Supprimer les sessions FTP',
    'ui__ftp-sessions/delete__title' => 'Supprimer les sessions FTP',
    'ui__ftp-sessions/delete__description' => 'Supprimez les sessions FTP sélectionnées.',

    // reseller
    'ui__reseller/sessions/delete__short-title' => 'Supprimer les sessions',
    'ui__reseller/sessions/delete__title' => 'Supprimer les sessions',
    'ui__reseller/sessions/delete__description' => 'Supprimez les sessions sélectionnées.',
    'ui__reseller/sessions/delete_self__short-title' => 'Supprimer les sessions',
    'ui__reseller/sessions/delete_self__title' => 'Supprimer les sessions',
    'ui__reseller/sessions/delete_self__description' => 'Supprimez les sessions sélectionnées.',
    'ui__reseller/ftp-sessions__short-title' => 'Sessions FTP',
    'ui__reseller/ftp-sessions__title' => 'Sessions FTP',
    'ui__reseller/ftp-sessions__description' => 'Affichez les sessions FTP.',
    'ui__reseller/ftp-sessions_self__short-title' => 'Sessions FTP',
    'ui__reseller/ftp-sessions_self__title' => 'Sessions FTP',
    'ui__reseller/ftp-sessions_self__description' => 'Affichez les sessions FTP.',
    'ui__reseller/ftp-sessions/delete__short-title' => 'Supprimer les sessions FTP',
    'ui__reseller/ftp-sessions/delete__title' => 'Supprimer les sessions FTP',
    'ui__reseller/ftp-sessions/delete__description' => 'Supprimez les sessions FTP sélectionnées.',
    'ui__reseller/ftp-sessions/delete_self__short-title' => 'Supprimer les sessions FTP',
    'ui__reseller/ftp-sessions/delete_self__title' => 'Supprimer les sessions FTP',
    'ui__reseller/ftp-sessions/delete_self__description' => 'Supprimez les sessions FTP sélectionnées.',

    // customer
    'ui__client/sessions/delete__short-title' => 'Supprimer les sessions',
    'ui__client/sessions/delete__title' => 'Supprimer les sessions',
    'ui__client/sessions/delete__description' => 'Supprimez les sessions sélectionnées.',
    'ui__client/sessions/delete_self__short-title' => 'Supprimer les sessions',
    'ui__client/sessions/delete_self__title' => 'Supprimer les sessions',
    'ui__client/sessions/delete_self__description' => 'Supprimez les sessions sélectionnées.',

    // domain administrator

    'forgery_token_expired' => 'Le jeton de session a expiré.',

    ///
    /// END OF SESSIONS
    ///

    ///
    /// USER ACCOUNT CONVERSION
    ///

    //
    // USER ACCOUNT TYPE CHANGES
    //

    // resellers > customers
    'downgradeResellers__downgrade_resellers' => 'Les comptes revendeur suivants seront convertis en comptes client :',
    'downgradeResellers__downgrade' => 'Comptes revendeur qui seront convertis',
    // controls
    'downgradeResellers__submit_downgrade' => 'Exécutez la conversion du compte.',
    'downgradeResellers__cancel_downgrade' => 'Annulez la conversion du compte.',
    'downgradeResellers__confirm' => 'Confirmer la conversion',
    'downgradeResellers__confirm_message' => 'Confirmer la conversion du compte pour pouvoir continuer',
    // errors

    // customers > resellers
    'picker_client_multi__title' => 'Sélectionner les comptes client',
    'upgradeClients__upgrade_clients' => 'Les comptes client suivants seront convertis en comptes revendeur :',
    'upgradeClients__upgrade' => 'Comptes client qui seront convertis',
    // controls
    'upgradeClients__submit_upgrade' => 'Exécutez la conversion du compte.',
    'upgradeClients__cancel_upgrade' => 'Annulez la conversion du compte.',
    'upgradeClients__confirm' => 'Confirmer la conversion',
    'upgradeClients__confirm_message' => 'Confirmer la conversion du compte pour pouvoir continuer',
    // errors
    'upgradeClient__user_is_already_reseller' => 'Impossible de convertir le compte \'%1\' en compte revendeur : \'%1\' est déjà un revendeur.',

    // domain administrators > customers
    'upgradeDomainUser__upgrade_domain_users' => 'Les comptes administrateur de domaines suivants seront convertis en comptes client',
    'upgradeDomainUser__upgrade' => 'Comptes administrateur de domaines qui seront convertis',
    // controls
    'upgradeDomainUser__submit_upgrade' => 'Exécutez la conversion du compte.',
    'upgradeDomainUser__cancel_upgrade' => 'Annulez la conversion du compte.',
    'upgradeDomainUser__confirm' => 'Confirmer la conversion',
    'upgradeDomainUser__confirm_message' => 'Confirmer la conversion du compte pour pouvoir continuer',
    // errors
    'upgradeDomainUser__non_upgradeable' => 'Les comptes administrateur de domaines qui ne peuvent pas être convertis',
    'upgradeDomainUser__non_upgradeable_domain_users' => 'Les comptes administrateur de domaines suivants n\'ont pas pu être convertis en comptes client :',
    'upgradeDomainUser__some_domains_were_not_converted' => 'Plusieurs comptes administrateur de domaines n\'ont pas pu être convertis en comptes client.%%domainsList%%',
    'upgradeDomainUser__domain_user_does_not_exist' => 'Le compte administrateur de domaines n\'existe pas',
    'upgradeDomainUser__domain_owner_must_be_a_reseller' => "Le domaine doit appartenir directement à l'administrateur de serveur ou à un revendeur.",
    'upgradeDomainUser__all_logins_already_used' => 'Impossible de créer un compte pour le client résultant.',
    // notifications
    'upgradeDomainUser__upgrade_notification_subject' => 'Le compte administrateur de domaines a été converti',
    'upgradeDomainUser__upgrade_notification_body' => 'Votre compte administrateur de domaines a été converti en compte client, dont le nom d\'utilisateur est \'%%login%%\' et le mot de passe \'%%password%%\'.',

    //
    // USER ACCOUNT OWNER CHANGES
    //

    // Customer owner change
    // customers selection - reseller & admin home
    'picker_client__title' => 'Sélectionner les comptes client',
    // errors
    'clientOwnerChanger__owner_has_no_permission' => 'Le revendeur sélectionné n\'a pas le droit \'%1\', mais certains des clients ont ce droit.',
    'clientOwnerChanger__application_not_allowed' => 'L\'application \'%1\' n\'est pas disponible pour le revendeur sélectionné, mais elle est disponible pour certains clients.',

    // Domain owner change
    'ui__client/domain/chowner_multi-select__wizard-title' => 'Réaffecter les abonnements sélectionnés',
    // errors
    'domain_chown__empty_selection' => 'Vous devez choisir un nouveau propriétaire pour les domaines sélectionnés.',



    //
    // USER ACCOUNT STATE CHANGES
    //


    ///
    /// END OF USER ACCOUNT CONVERSION
    ///

    ///
    /// BANDWIDTH LIMITING
    ///

    'hosting_performance__traffic_bandwidth_label' => 'Utilisation maximum de la bande passante (%1)',
    'hosting_performance__max_connection_label' => 'Connexions limitées à',
    'performance__invalid_value' => "La valeur est incorrecte. Doit être comprise entre %1 et %2.",

    ///
    /// END OF BANDWIDTH LIMITING
    ///

    ///
    /// WEBMAIL SELECTION (these keys are currently PfU-only)
    ///

    'webmail__server_legend' => 'Messagerie Web',
    'webmail__server_text' => 'Clients de la messagerie Web disponibles',
    'webmail__none' => 'Aucun',

    ///
    /// END OF WEBMAIL SELECTION
    ///


    ////
    //// BACKUP/RESTORATION
    ////

    // random common keys:
    'backup__ip_mapping__server_ip' => 'Pool d\'IP du serveur',

    ///
    /// END OF BACKUP MANAGER ACTIONS
    ///

    ///
    /// LISTS
    ///


    // Common info/errors:
    'migration_db_server_not_find' => 'La base de données ne sera pas restaurée : il n\'y a pas de serveur de bases de données adéquat',

    ///
    /// END OF LISTS
    ///

    ///
    /// COMMON SCREENS
    ///

    // Back Up
    // Comments - __comments
    '__default_backup_comment_server' => "Sauvegarde du serveur.",
    '__default_backup_comment_reseller' => "Sauvegarde du compte revendeur créée par %1.",
    '__default_backup_comment_client' => "Sauvegarde du compte client créée par %1.",
    '__default_backup_comment_domain' => "Sauvegarde de l'abonnement créée par %1.",

    // Restoration & backup information

    // IP mapping
    'backup__ip_mapping__clients_ip' => "Pool d'IP du client %1",
    'backup__ip_mapping__resellers_ip' => "Pool d'adresses IP du revendeur %1",

    // Conflicts occured
    'backup__restore__object_vhost' => 'Hôte virtuel',
    'backup__restore__object_plesk_admin' => 'Administrateur Plesk',
    'backup__restore__object_ftpuser' => 'compte FTP',
    'backup__restore__object_frontpageuser' => 'compte Frontpage',
    'backup__restore__object_webuser' => 'utilisateur Web',
    'backup__restore__object_domain' => 'domaine',
    'backup__restore__object_subdomain' => 'sous-domaine',
    'backup__restore__object_domainalias' => 'alias de domaine',
    'backup__restore__object_client' => 'client',
    'backup__restore__object_reseller' => 'revendeur',
    'backup__restore__object_autoresponder' => 'Réponse automatique',
    'backup__restore__object_mailalias' => 'alias de messagerie',
    'backup__restore__object_database' => 'base de données',
    'backup__restore__object_mailname' => 'compte mail',
    'backup__restore__object_db_user' => 'utilisateur de la base de données',
    'backup__restore__object_ssl_certificate' => 'Certificat SSL/TLS',
    'backup__restore__resellers_cannot_restore_converted_to_customers' => 'Impossible de restaurer les revendeurs suivants, car ils ont été convertis en clients : \'%1\'.',
    'backup__restore__customers_cannot_restore_converted_to_resellers' => 'Impossible de restaurer les clients suivants, car ils ont été convertis en revendeurs : \'%1\'.',
    'backup__restore__customers_cannot_restore_moved_to_another_owners' => 'Impossible de restaurer les clients suivants, car ils ont été déplacés vers un autre revendeur : \'%1\'.',

    // Before migration starts
    'backup__restore__capability_not_enough_disk_text' => 'L\'espace disque sur le serveur de destination est insuffisant pour transférer tous les abonnements sélectionnés. Disponible : %1 Mo. Requis : %2 Mo. Remarque : l\'espace disque englobe le contenu Web, des messageries et des bases de données des domaines. L\'espace requis est calculé une fois par jour et stocké dans le cache. C\'est pourquoi la taille réelle des domaines peut différer de la taille calculée. Si vous vous assurez que les domaines sélectionnés n\'utilisent pas plus d\'espace que disponible, vous pouvez procéder au transfert.',
    'backup__restore__capability_not_enough_disk_resolution' => 'Veuillez libérer de l\'espace disque sur le serveur de destination.',
    'backup__restore__capability_source_not_enough_disk_text' => 'L\'espace disque sur le serveur source est insuffisant pour stocker les fichiers temporaires utilisés pour le transfert. Disponible : %1 Mo. Requis : %2 Mo.',
    'backup__restore__capability_source_not_enough_disk_resolution' => 'Veuillez libérer de l\'espace disque sur le serveur source.',
    'backup__restore__capability_not_enough_disk_resolution_url_text' => 'Infos sur le serveur',

    'backup__restore__capability_not_installed_component_text' => 'Le composant %1 n\'est pas installé sur le serveur de destination. %1 ne sera pas disponible pour tous les objets restaurés.',
    'backup__restore__capability_not_installed_component_resolution' => 'Veuillez installer %1. Cela pourrait prendre quelques minutes.',
    'backup__restore__capability_existing_sys_user_text' => 'Un utilisateur système avec le nom %1 existe déjà sur le serveur de destination.',
    'backup__restore__capability_existing_sys_user_resolution' => 'Veuillez renommer l\'utilisateur système existant sur le serveur de destination.',
    'backup__restore__capability_license_usage_text' => 'Les limites des ressources suivantes (définies par la clé de licence) seront dépassées sur le serveur de destination une fois le transfert de données effectué :',
    'backup__restore__capability_license_usage_resolution' => 'Veuillez installer sur le serveur de destination une autre clé de licence qui vous fournira le volume requis de ressources.',
    'backup__restore__capability_max_allowed_packet_text' => "Le paramètre 'max_allowed_packet' sur le serveur de bases de données source est %1. Il est plus élevé que celui du serveur de destination, en l'occurrence, %2. Certains objets de la base de données pour les domaines spécifiés ci-dessous ne seront peut-être pas restaurés.",
    'backup__restore__capability_max_allowed_packet_resolution' => "Veuillez augmenter la valeur 'max_allowed_packet' sur le serveur de bases de données de destination.",

    'backup__restore__capability_postgres_to_lower_version_text' => 'Impossible de transférer les bases de données PostgreSQL, car la version de PostgreSQL sur le serveur de destination est une version antérieure à celle installée sur le serveur source. La version actuelle est la version %1. La version requise est la version %2.',
    'backup__restore__capability_postgres_to_lower_version_text_resolution' => 'Veuillez installer la version requise de PostgreSQL sur le serveur de destination.',
    'backup__restore__capability_db_server_connection_problems' => 'Impossible de se connecter au serveur de bases de données de destination PostgreSQL. Les bases de données ne seront pas transférées à moins que vous ne restauriez la connexion.',
    'backup__restore__capability_db_server_connection_problems_resolution' => 'Veuillez vérifier les paramètres de connexion sur le serveur de bases de données de destination.',
    'backup__restore__capability_component_not_enabled_server_wide_text' => 'Le composant %1 est désactivé sur le serveur de destination.',
    'backup__restore__capability_component_not_enabled_server_wide_resolution' => 'Veuillez activer %1 sur le serveur de destination.',
    'backup__restore__capability_not_configured_component_text' => 'Le composant %1 n\'est pas configuré sur le serveur de destination.',
    'backup__restore__capability_not_configured_component_resolution' => 'Veuillez configurer %1 sur la page Outils & Paramètres.',

    'backup__restore__capability_webmail_is_not_available' => 'Le service de messagerie Web %1 n\'est pas disponible sur le serveur de destination. À la place, Plesk utilisera le service de messagerie suivant : %2.',
    'backup__restore__capability_webmail_is_not_available_resolution' => 'Pour utiliser la même messagerie Web que sur le serveur source, vous devez l\'installer sur ce serveur.',
    'backup__restore__capability_webmail_is_not_installed_resolution' => 'Pour utiliser la même messagerie Web que sur le serveur source, vous devez l\'installer sur le serveur de destination.',
    'backup__restore__capability_webmail_is_not_available_changed_on_subscriptions' => "Le service de messagerie Web '%1' n'est pas disponible sur le serveur de destination. À la place, pour les abonnements suivants %3, Plesk utilisera ce service de messagerie Web : %2.",
    'backup__restore__capability_webmail_is_not_installed_custom_resolution' => 'Veuillez installer la messagerie Web requise sur le serveur de destination.',
    'backup__restore__capability_webmail_is_not_available_url_text' => 'Paramètres de la messagerie Web',

    'backup__restore__capability_shell_is_not_available' => 'Le shell %1 n\'est pas disponible sur le serveur de destination. L\'un des shells disponibles sera utilisé à la place.',
    'backup__restore__capability_shell_is_not_available_resolution' => 'Pour utiliser le même shell que sur le serveur source, vous devez l\'activer (sous /etc/shells) ou l\'installer sur le serveur de destination.',

    'backup__restore__capability_acl_network_not_allowed_dns_template' => 'Le serveur DNS de destination ne prend pas en charge les réseaux dans le Template de restrictions des transferts. Les enregistrements avec des adresses IP de réseau dans les restrictions des transferts de DNS ne seront pas restaurés.',
    'backup__restore__capability_acl_network_not_allowed_dns_zone' => 'Le serveur DNS de destination ne prend pas en charge les réseaux dans le Template de restrictions des transferts, cependant certains abonnements ont des réseaux dans les restrictions des transferts de DNS. Les enregistrements avec des adresses IP de réseau dans les restrictions des transferts de DNS ne seront pas restaurés.',

    'backup__restore__capability_wrong_php_handler_text' => 'Le gestionnaire PHP %1 n\'est pas disponible sur le serveur de destination. À la place, Plesk utilisera le gestionnaire PHP : %2.',
    'backup__restore__capability_wrong_php_handler_resolution' => 'Si vous voulez utiliser le même gestionnaire PHP que sur le serveur source, vous devez l\'activer ou l\'installer sur le serveur de destination.',
    'bu_conflict_resolver_php_handler_replaced_in_plans' => 'Le gestionnaire PHP "%1" n\'est pas disponible. À la place, Plesk utilisera %2 pour les pack de services suivants : {{objects}}.',
    'bu_conflict_resolver_php_handler_replaced_in_sites' => 'Le gestionnaire PHP "%1" n\'est pas disponible. À la place, Plesk utilisera %2 pour les sites Web suivants : {{objects}}.',
    'bu_conflict_resolver_php_handler_not_allowed_in_sites' => 'Le gestionnaire PHP "%1" n\'est pas disponible. Il ne sera pas disponible pour les sites Web suivants : {{objects}}.',

    'backup__restore__capability_wrong_component_version_text' => '%1 %2 n\'est pas disponible sur le serveur de destination. La version par défaut sera utilisée à la place.',
    'backup__restore__capability_wrong_component_version_resolution' => 'Si vous voulez le même %1 que sur le serveur source, vous devez l\'activer ou l\'installer sur le serveur de destination.',

    'backup__restore__capability_antivirus_not_allowed_outgoing_text' => 'La politique d\'utilisation de l\'antivirus du serveur de destination n\'autorise pas la personnalisation des paramètres antivirus (par adresse mail) pour les mails sortants. Ces paramètres ne seront pas transférés.',
    'backup__restore__capability_antivirus_not_allowed_incoming_text' => 'La politique d\'utilisation de l\'antivirus du serveur de destination n\'autorise pas la personnalisation des paramètres antivirus (par adresse mail) pour les mails entrants. Ces paramètres ne seront pas transférés.',
    'backup__restore__capability_antivirus_not_allowed_personal_settings_text' => 'La politique d\'utilisation de l\'antivirus du serveur de destination n\'autorise pas la personnalisation des paramètres antivirus (par adresse mail). Ces paramètres ne seront pas transférés.',
    'backup__restore__capability_antivirus_not_allowed_personal_settings_resolution' => "Pour transférer des paramètres antivirus personnalisés (par adresse mail), veuillez activer les options correspondantes dans Outils & Paramètres > Paramètres de protection antivirus.",
    'backup__restore__capability_antivirus_not_active_text' => 'Aucun antivirus n\'a été activé. Aucun paramètre antivirus du serveur source ne fonctionnera tant que vous n\'aurez pas sélectionné de logiciel antivirus sur le serveur de destination.',
    'backup__restore__capability_antivirus_not_active_resolution' => 'Veuillez sélectionner le logiciel antivirus depuis : Outils & Paramètres > Paramètres de protection antivirus > section Paramètres antivirus.',

    'backup__restore__capability_antivirus_another_active_text' => 'Le logiciel antivirus %2 n\'est pas disponible sur les serveurs de destination. %1 sera utilisé à la place.',
    'backup__restore__capability_antivirus_another_active_resolution' => 'Pour utiliser le même antivirus que sur le serveur source, installez-le et sélectionnez-le depuis : Outils & Paramètres > Paramètres de protection antivirus > section Paramètres antivirus.',
    'backup__restore__capability_not_available_sni_text' => 'L\'extension SNI n\'est pas disponible sur le serveur de destination. Les sites Web qui ont la même adresse IP ne seront pas en mesure d\'utiliser des certificats SSL/TLS individuels.',
    'backup__restore__capability_not_available_sni_resolution' => "Vérifiez si le système d'exploitation sur le serveur de destination prend en charge l'extension SNI et si celle-ci est activée dans Plesk (sous Outils & Paramètres > Paramètres du serveur, option 'Activer la prise en charge de l'extension SNI, qui permet l'utilisation de certificats SSL/TLS individuels sur les sites Web avec la même adresse IP').",
    'backup__restore__capability_not_available_sni_resolution_url_text' => 'Paramètres du serveur',

    'backup__restore__capability_vhost_already_exists_text' => 'Le site Web %1 ne peut pas être transféré, car un site Web portant le même nom existe déjà sur le serveur de destination.',
    'backup__restore__capability_vhost_already_exists_resolution' => 'Veuillez renommer ou supprimer du serveur le site Web qui porte le même nom.',
    'backup__restore__capability_removed_vhosts' => 'Les abonnements suivants ne seront pas restaurés, car ils contiennent des noms de domaine qui existent déjà sur le serveur de destination : %1',
    'backup__restore__capability_duplicate_php_handler_text' => 'Il y a %3 gestionnaires PHP différents de type %1 et version %2 sur le serveur source. Cependant, seul un gestionnaire de type et de version appropriés sera utilisé sur le serveur de destination. Remarque : les paramètres PHP sur le serveur source et sur le serveur de destination peuvent être différents.',

    'backup__restore__capability_not_installed_frontpage_resolution' => 'Le Programme d\'installation de Plesk ne prend pas en charge Microsoft FrontPage.',
    'backup__restore__capability_not_installed_python_resolution' => 'Le Programme d\'installation de Plesk ne prend pas en charge Python. Veuillez installer Python manuellement.',

    'backup__restore__capability_mail_spamfilter_domain_keys_resolution_url_text' => 'Paramètres du serveur de messagerie',

    'backup__restore__capability_ftps_disabled' => 'L\'utilisation d\'une connexion FTPS sécurisée est autorisée sur le serveur source, mais interdite sur le serveur cible. Les applications utilisateur qui utilisent une connexion FTP risquent de ne pas fonctionner correctement.',
    'backup__restore__capability_ftps_required' => 'L\'utilisation d\'une connexion FTPS sécurisée est autorisée sur le serveur source, mais interdite sur le serveur cible. Les applications utilisateur qui utilisent une connexion FTP risquent de ne pas fonctionner correctement.',
    'backup__restore__capability_ftps_policy_resolution' => 'Modifiez la politique FTP sécurisé sous Outils & Paramètres > Politique de sécurité.',

    'backup__restore__capability_too_much_download_time_text' => '%1 mégaoctets de données seront déplacés du serveur source vers le serveur de destination en %2 heures.',
    'backup__restore__capability_too_much_download_time_resolution' => 'Pour bénéficier d\'un transfert plus rapide, vérifiez votre connexion réseau entre les serveurs source et cible et résolvez les problèmes le cas échéant.',
    'backup__restore__too_low_download_speed' => "moins de 0,01",
    'backup__restore__capability_too_slow_download_speed_resolution' => 'Pour bénéficier d\'un transfert plus rapide, vérifiez votre connexion réseau entre les serveurs source et de destination et résolvez les problèmes le cas échéant.',
    'backup__restore__capability_zero_download_speed_text' => 'La vitesse minimum de téléchargement acceptable est de %1 MBps. La vitesse de téléchargement entre le serveur source et le serveur de destination est de 0 MBps. Cela peut être dû à des problèmes de connexion réseau. Le transfert n\'est pas possible.',
    'backup__restore__capability_zero_download_speed_resolution' => 'Vérifiez votre connexion réseau entre les serveurs source et de destination et résolvez les problèmes.',
    'backup__restore__capability_too_slow_download_speed_text' => 'La vitesse minimum de téléchargement acceptable est de %2 MBps. La vitesse de téléchargement entre le serveur source et le serveur de destination est de %1 MBps. Cela peut augmenter la durée de transfert. Avec votre environnement actuel, la migration de %3 Mo prendra %4 heures.',
    'backup__restore__capability_too_slow_download_speed_text_without_diskusage' => 'La vitesse minimum de téléchargement acceptable est de %2 MBps. La vitesse de téléchargement entre le serveur source et le serveur de destination est de %1 MBps. Cela peut augmenter la durée de transfert.',

    'backup__restore__capability_remote_database_migration' => "Les domaines suivants utilisent des bases de données à distance : %1",
    'backup__restore__capability_remote_database_migration_resolution' => "Ne supprimez pas ces domaines du serveur source après le transfert si la version de Plesk sur le serveur source est antérieure à 11.5 ! À la place, nous vous recommandons de les suspendre. Si vous supprimez les domaines, les bases de données seront supprimées du serveur distant. Remarque : les fichiers dumpés des bases de données distantes seront stockés sur le serveur source dans le répertoire %1.",

    'backup__restore__capability_mysql_50_to_51_migration' => 'Les fichiers de sauvegarde des serveurs de bases de données MySQL antérieurs à la version 5.1 (%1) peuvent ne pas être restaurés sur MySQL 5.1.x, car cette version traite différemment les caractères Unicode.',
    'backup__restore__capability_mysql_50_to_51_migration_resolution' => '',
    'backup__restore__capability_mysql_50_to_51_migration_kb_link_title' => 'Veuillez lire l\'article de la base de connaissances correspondant, n° 136850.',

    'backup__restore__capability_courier_not_installed_text' => 'Courier-IMAP n\'est pas installé sur le serveur de destination.',
    'backup__restore__capability_courier_not_installed_resolution' => 'Veuillez installer Courier-IMAP à l\'aide du Programme d\'installation de Plesk.',
    'backup__restore__capability_dovecot_not_installed_text' => 'Dovecot n\'est pas installé sur le serveur de destination.',
    'backup__restore__capability_dovecot_not_installed_resolution' => 'Veuillez installer Dovecot à l\'aide du Programme d\'installation de Plesk.',

    'backup__restore__wrong_stat_ttl_value_text' => 'La durée de rétention des statistiques du trafic dans les configurations des objets suivants est inférieure à la valeur pour l\'ensemble du serveur sur le serveur de destination.',
    'backup__restore__wrong_stat_ttl_value_resolution' => 'Veuillez modifier la valeur de la durée de rétention des statistiques pour l\'ensemble du serveur sur le serveur de destination. Elle doit être égale ou inférieure à la plus petite valeur indiquée dans les configurations de domaines.',
    'bu_conflict_resolver_wrong_stat_ttl_value' => 'La durée de rétention des statistiques du trafic sur certains domaines est inférieure à la valeur pour l\'ensemble du serveur (%1). La valeur sera modifiée en %1 pour ces domaines.',
    'bu_conflict_resolver_wrong_stat_ttl_template_value' => 'La durée de conservation des statistiques du trafic sur certains packs de services est inférieure à la valeur pour l\'ensemble du serveur (%1). La valeur sera modifiée en %1 pour ces packs de services.',

    'backup__ip_mapping__map_dedicated_to_shared_ip' => 'Si vous mappez une adresse IP exclusive à une adresse IP partagée, cela désactive les protocoles anonymes FTP et HTTPS (sauf si la prise en charge SNI est activée).',

    'backup__restore__no_postgresql_commands_text' => 'Les abonnements utilisent une base de données PostgreSQL à distance. Ses fichiers de sauvegarde temporaires ne peuvent pas être générés, car les commandes pg_dump et psql sont absentes du serveur source.',
    'backup__restore__no_postgresql_commands_resolution' => 'Veuillez installer tout pack client PostgreSQL qui prend en charge ces commandes.',
    'backup__restore__capability_apache_modules_disabled_text' => 'Les modules Apache suivants sont désactivés sur le serveur de destination : %1.',
    'backup__restore__capability_apache_modules_disabled_resolution' => 'Veuillez activer ces modules pour éviter des problèmes éventuels.',
    'backup__restore__capability_apache_modules_not_installed_text' => 'Les modules Apache suivants ne sont pas installés sur le serveur de destination : %1.',
    'backup__restore__capability_apache_modules_not_installed_resolution' => 'Veuillez installer et activer ces modules pour éviter des problèmes éventuels.',

    'backup__restore__capability_license_not_supported_outgoing_antispam' => 'La limitation des mails sortants n\'est pas prise en charge par votre licence. Les paramètres de configuration correspondants ne seront pas transférés.',
    'backup__restore__capability_license_not_supported_outgoing_antispam_resolution' => 'Veuillez installer une autre clé de licence fournissant les fonctionnalités requises sur le serveur de destination.',
    'backup__restore__capability_disabled_outgoing_antispam' => 'La limitation des messages sortants est désactivée sur le serveur de destination. Les paramètres de configuration correspondants ne seront pas transférés.',
    'backup__restore__capability_disabled_outgoing_antispam_resolution' => 'Veuillez activer la limitation des messages sortants sur le serveur de destination.',
    'backup__restore__capability_disabled_outgoing_antispam_resolution_url_text' => 'Paramètres de la messagerie pour l\'ensemble du serveur',

    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported' => 'La limitation des mails sortants d\'une boîte mail n\'est pas prise en charge par le serveur de messagerie utilisé sur le serveur de destination. La valeur de cette limite ne sera pas transférée.',
    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported_resolution' => 'Veuillez changer le serveur de messagerie et utiliser le même que sur le serveur source.',
    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported_resolution_url_text' => 'Paramètres de la messagerie pour l\'ensemble du serveur',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported' => 'La limitation des mails sortants d\'un domaine n\'est pas prise en charge par le serveur de messagerie utilisé sur le serveur de destination. La valeur de cette limite ne sera pas transférée.',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported_resolution' => 'Veuillez changer le serveur de messagerie et utiliser le même que sur le serveur source.',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported_resolution_url_text' => 'Paramètres de la messagerie pour l\'ensemble du serveur',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported' => 'La limitation des mails sortants d\'un abonnement n\'est pas prise en charge par le serveur de messagerie utilisé sur le serveur de destination. La valeur de cette limite ne sera pas transférée.',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported_resolution' => 'Veuillez changer le serveur de messagerie et utiliser le même que sur le serveur source.',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported_resolution_url_text' => 'Paramètres de la messagerie pour l\'ensemble du serveur',

    'bu_conflict_resolver_absent_phosting' => 'Impossible de restaurer les fichiers spécifiés, car l\'hébergement physique pour les restaurer n\'existe pas. Créez d\'abord un domaine avec un hébergement physique, puis redémarrez la restauration de la sauvegarde.',
    'bu_conflict_resolver_resellers_management_is_not_supported' => 'Les données revendeur ne seront pas restaurées car la gestion des revendeurs n\'est pas prise en charge.',

    'backup__restore__capability_modsecurity_not_installed_text' => 'Le composant ModSecurity n\'est pas installé sur le serveur de destination.',
    'backup__restore__capability_modsecurity_not_installed_resolution' => 'Veuillez installer ModSecurity si vous souhaitez que le pare-feu applicatif continue de fonctionner pour les sites transférés. Remarque : l\'installation pourrait prendre quelques minutes.',
    'backup__restore__capability_modsecurity_not_installed_resolution_for_server' => 'Installez ModSecurity si vous souhaitez transférer les paramètres du pare-feu applicatif. Remarque : l\'installation pourrait prendre quelques minutes.',
    'backup__restore__capability_modsecurity_not_configured_text' => 'Le composant ModSecurity n\'est pas configuré sur le serveur de destination.',
    'backup__restore__capability_modsecurity_not_configured_resolution' => 'Configurez ModSecurity si vous souhaitez que le pare-feu applicatif continue de fonctionner pour les sites transférés.',
    'backup__restore__capability_modsecurity_not_configured_resolution_url_text' => 'Pare-feu applicatif (ModSecurity)',
    'backup__restore__capability_modsecurity_not_active_text' => 'ModSecurity est désactivé sur le serveur de destination.',
    'backup__restore__capability_modsecurity_not_active_resolution' => 'Activez ModSecurity si vous souhaitez que le pare-feu applicatif continue de fonctionner pour les sites transférés.',
    'backup__restore__capability_modsecurity_not_active_resolution_url_text' => 'Pare-feu applicatif (ModSecurity)',
    'bu_conflict_resolver_modsecurity_not_installed' => 'Le composant ModSecurity n\'est pas installé. Les paramètres du pare-feu applicatif ne seront pas restaurés pour les objets suivants : {{objects}}',
    'bu_conflict_resolver_absent_websites_subscription' => "Impossible de restaurer les sites Web, car ils appartiennent à l'abonnement %1 qui n'est pas trouvé dans Plesk.",
    'backup__restore__capability_not_installed_dns_text' => 'Le composant %1 n\'est pas installé sur le serveur de destination. Le service DNS ne sera pas disponible et les paramètres DNS seront perdus. Aucun site Web de client ne sera disponible.',
    'bu_conflict_resolver_dns_not_installed' => 'Le service DNS n\'est pas installé. Les paramètres DNS ne seront pas restaurés pour les objets suivants : {{objects}}',
    'backup__restore__subscriptions_cannot_restore_moved_to_another_owners' => 'Impossible de restaurer les abonnements suivants, car ils ont été déplacés vers d\'autres propriétaires : \'%1\'',
    'backup__restore__subscriptions_cannot_restore_moved_to_another_vendors' => 'Impossible de restaurer les abonnements suivants, car ils ont été déplacés vers d\'autres fournisseurs : \'%1\'',
    'bu_conflict_resolver_sitebuilder_restore_util_is_not_installed' => 'Impossible de trouver l\'utilitaire de restauration de Web Presence Builder pour restaurer les données de Web Presence Builder. Web Presence Builder n\'est probablement pas installé.',
    'backup__restore__capability_renamed_db' => 'Le nom de la base de données "%1" est déjà utilisé par un autre abonnement. Le nom de la base de données restaurée sera changé en "%2".',
    'backup__restore__capability_renamed_db_user' => 'Le nom d\'utilisateur de la base de données "%1" est déjà utilisé par un autre abonnement. Le nom d\'utilisateur de la base de données sera changé en "%2".',
    'backup__restore__capability_not_installed_perl_resolution' => 'Le Programme d\'installation de Plesk ne prend pas en charge Perl. Veuillez installer manuellement ActiveState Perl.',
    'backup__restore__capability_php_handler' => '%%version%% %%type%% (id=%%id%%)',
    'backup__restore__capability_php_handler_served_by_apache' => '%%version%% %%type%% servi(e) par Apache (id=%%id%%)',
    'backup__restore__capability_php_handler_served_by_nginx' => '%%version%% %%type%% servi(e) par Nginx (id=%%id%%)',


    '__sni' => 'SNI',
    '__kav' => 'Antivirus Kaspersky',
    '__drweb' => 'Odin Premium Antivirus',

    // Resource usage conflicts
    'backup__restore__resource_useage_conflicts' => 'Conflits d\'utilisation de ressources',
    'backup__restore__hint_resource_usage_conflicts' => 'Les conflits d\'utilisation de ressources se produisent lorsque les limites des ressources utilisées de l\'objet restauré sont dépassées lors de la restauration.',
    'backup__restore__text_resource_usage_resolution_policy_overusage' => 'Permettre la surutilisation',
    'backup__restore__hint_resource_usage_resolution_policy_overusage' => 'Restaurez l\'objet et permettez-lui d\'utiliser plus de ressources que prévu.',
    'backup__restore__text_resource_usage_resolution_policy_do_not_restore' => 'Ne pas restaurer',
    'backup__restore__hint_resource_usage_resolution_policy_do_not_restore' => 'Ne restaurez pas les objets qui ont des conflits d\'utilisation de ressources.',
    // Configuration conflicts
    'backup__restore__configuration_conflicts' => 'Conflits de configuration',
    'backup__restore__hint_configuration_conflicts' => 'Les conflits de configuration se produisent lorsque l\'objet restauré a des paramètres et des applications Web qui ne sont pas disponibles ou sont interdits par la politique du propriétaire de l\'objet ou du serveur actuel. Par exemple, des conflits de configuration se produiront si les comptes mail restaurés ont des paramètres de filtre anti-spam individuels tandis que la politique actuelle valable pour tout le serveur interdit aux comptes mail d\'avoir ce type de paramètres.',
    'backup__restore__text_configuration_resolution_policy_automatic' => 'Automatique',
    'backup__restore__hint_configuration_resolution_policy_automatic' => 'Restaurez l\'objet et activez automatiquement toutes les options de configurations conflictuelles que vos droits permettent de gérer.',
    'backup__restore__text_configuration_resolution_policy_do_not_restore' => 'Ne pas restaurer',
    'backup__restore__hint_configuration_resolution_policy_do_not_restore' => 'Ne restaurez pas les objets qui ont des conflits de configuration.',

    'backup__restore__dedicated_app_pool_restore_to_shared_text' => 'Les pools d\'applications IIS dédiés ne sont pas autorisés dans les paramètres de pools d\'applications IIS.',
    'backup__restore__dedicated_app_pool_restore_to_shared_resolution' => 'Veuillez changer les paramètres de votre pool d\'applications IIS dans les Outils & Paramètres > Pool d\'applications IIS > Paramètres généraux.',
    'backup__restore__shared_app_pool_restore_to_dedicated_text' => 'Les pools d\'applications IIS partagés ne sont pas autorisés dans les paramètres de pools d\'applications IIS.',
    'backup__restore__shared_app_pool_restore_to_dedicated_resolution' => 'Veuillez changer les paramètres de votre pool d\'applications IIS dans les Outils & Paramètres > Pool d\'applications IIS > Paramètres généraux.',

    'backup__restore__unable_allow_short_pop3 _names_text' => 'Les noms courts pour les comptes mail POP3/IMAP ne sont pas autorisés sur le serveur de destination.',
    'backup__restore__unable_allow_short_pop3 _names_resolution' => 'Les noms courts pour les comptes mail ne seront plus disponibles après la restauration des données.',

    // Restore status messages & errors:
    'backup__unable_to_open_log_file' => 'Impossible d\'ouvrir le fichier journal.',
    'backup__restore__customer_cannot_restore_nonexistent_subscription' => 'Impossible de restaurer l\'abonnement %1 : il a été supprimé de votre compte et vous n\'avez pas l\'autorisation de créer des abonnements. Si vous avez besoin de le restaurer, contactez votre fournisseur de services.',

    'backup__error11' => 'Espace disque insuffisant pour la sauvegarde.',
    'backup__error3011' => 'La connexion a été refusée : aucun programme n\'écoute sur l\'adresse et le port indiqués.',
    'backup__error3012' => 'Délai du temps de connexion dépassé.',
    'backup__error3013' => 'Le réseau est inaccessible.',
    'backup__error3014' => 'Aucun chemin d\'accès pour atteindre l\'hôte.',
    'backup__error3015' => 'Échec de la connexion.',
    'backup__error3016' => 'Impossible de résoudre le nom d\'hôte.',
    'backup__error3017' => 'Nom d\'utilisateur ou mot de passe incorrect.',
    'backup__error3018' => 'Échec de la connexion SSH.',

    'backup__error3110' => 'Impossible de se connecter à l\'agent de migration à distance : connexion à l\'hôte non disponible.',
    'backup__error3111' => 'L\'agent de migration est verrouillé en raison d\'une tâche de migration qui a échoué ou est utilisée par un autre processus de migration. Veuillez redémarrer l\'agent de migration sur le serveur source.',
    'backup__error3112' => 'La connexion à l\'hôte n\'est pas disponible ou l\'agent de migration n\'est pas exécuté sur l\'hôte source.',
    'backup__error3113' => 'Impossible de déployer l\'agent de migration sur un hôte Linux. Veuillez vérifier la connexion SSH à l\'hôte source.',
    'backup__error3114' => 'Impossible de déployer l\'agent de migration sur un hôte Linux : échec de la connexion SSH.',
    'backup__error3115' => 'Nom d\'utilisateur ou mot de passe incorrect.',
    'backup__error3116' => 'L\'utilisateur spécifié n\'a pas les privilèges administrateur.',

    'dns_t__unable_to_remove_ns_record' => 'Impossible de transférer l\'enregistrement NS du template DNS : chaque zone DNS doit avoir au moins un enregistrement NS.',
    'dns__unsupported_server_zone_transfer' => 'Impossible de transférer le Template de restrictions des transferts en raison de la configuration DNS sur l\'ensemble du serveur : les adresses réseau suivantes sont autorisées pour le transfert de zone sur certains domaines sur le serveur source, mais ces adresses sont interdites par le serveur DNS Microsoft : %1.',
    'dns__unsupported_domain_zone_transfer' => 'Impossible de transférer le Template de restrictions des transferts en raison de la configuration des domaines DNS : les adresses réseau suivantes sont autorisées pour le transfert de zone sur certains domaines, mais ces adresses sont interdites par le serveur DNS Microsoft : %1.',
    ///
    /// END OF COMMON SCREENS
    ///

    ///
    /// DATABASE BACKUP - PFW // TBD
    ///

    // Actions

    'dbbackup__check_network_settings_failed' => 'Impossible d\'accéder au répertoire réseau temporaire partagé pour les fichiers de sauvegarde. Veuillez vérifier les paramètres du répertoire réseau, du nom d\'utilisateur et du mot de passe. Erreur : %1',

    'migration_select_exist_db_server' => 'Sélectionner le serveur de bases de données de destination',

    'dbbackup__temp_dir_wrong_value' => 'Une valeur non valide pour le répertoire temporaire a été indiquée.',
    'dbbackup__network_temp_dir_wrong_value' => 'La valeur indiquée pour le répertoire réseau temporaire n\'est pas valide.',
    'dbbackup__server_backup_not_configured' => 'Les paramètres de sauvegarde de la base de données ne sont pas configurés sur le serveur.',
    'dbbackup__temp_dir' => 'Répertoire temporaire',
    'dbbackup__temp_dir_hint' => 'Chemin d\'accès à un dossier physique sur le serveur distant sur lequel se trouve le serveur MS SQL. Le serveur MS SQL doit être capable d\'accéder à ce dossier pour lire et écrire des fichiers de sauvegarde temporaires. Par exemple, C:\\DirectoryPath.',
    'dbbackup__network_temp_dir_hint' => 'Chemin d\'accès vers le partage réseau mappé au dossier physique indiqué ci-dessus. Plesk accèdera au dossier partagé pour télécharger et envoyer les fichiers de sauvegarde. Par exemple : \\\\ServerName\\DirectoryPath',
    'dbbackup__network_user_hint' => 'Le nom d\'utilisateur d\'un utilisateur réseau créé sur un serveur distant. Par exemple, ServerName\\UserName. L\'utilisateur doit avoir l\'accès au dossier partagé indiqué ci-dessus.',
    'dbbackup__network_password_hint' => 'Mot de passe de l\'utilisateur du réseau',

    'dbbackup__success_import_without_dublicate_users' => 'Les utilisateurs suivants n\'ont pas été importés : %1. Ils existent déjà sur le serveur de base de données.',

    ///
    /// END OF DATABASE BACKUP
    ///

    ///
    /// LOGS & LOG ROTATION
    ///

    'log_rot__compress' => "Compresser les fichiers journaux",
    'log_rot__log_rot_status' => "Statuts de la rotation des journaux",
    'log_rot__log_rot_period' => "Condition de rotation des journaux",
    'log_rot__log_rot_size' => "par taille",
    'log_rot__log_rot_time' => "par période",
    'log_rot__logrotation_enable' => "Activez la rotation des journaux.",
    'log_rot__mail' => "Envoyer les journaux traités à l'adresse",
    'log_rot__max_number_of_logfiles' => "Nombre maximum de fichiers journaux",
    'log_rot__time_period' => "période",
    'log_rot__unable_turn_off' => 'Impossible de désactiver la rotation des journaux, car celle-ci est forcée au niveau du serveur.',
    'log_rot__unable_set_period' => 'Impossible de définir une période de rotation des journaux différente de la rotation quotidienne, car cette période est forcée au niveau du serveur.',
    'log_rot__unable_set_max_log_files' => 'Impossible de définir un nombre maximum de fichiers journaux supérieur à la limite valable pour l\'ensemble du serveur %1.',

    /// action log
    // common/various
    'actionlog__digit_expected' => "Nombre attendu : %1",
    'actionlog__incorrect_rotation' => "Paramètres de rotation des journaux spécifiés non valables : %1",
    'actionlog__unknown_rot_period' => "Période de rotation inconnue: %1",
    'actionlog__unknown_rot_type' => "Type de rotation inconnu : %1",
    'actionlog__session_preferences' => 'Paramètres de la session',
    'actionlog__nis2_delete_prohibited' => 'Il est interdit de supprimer les enregistrements de journaux, car les restrictions de la directive NIS2 sont en vigueur.',
    'actionlog__nis2_forbidden_rot_type' => "Il est impossible d'utiliser le type de rotation de journaux '%1', car les restrictions de la directive NIS2 sont en vigueur.",
    // items (PFU schema)
    'actionlog__admin_info' => 'Profil de l\'administrateur',
    'actionlog__admin_preferences' => "Préférences de l'administrateur",
    'actionlog__service' => 'Service',
    'actionlog__ip_addr' => 'Adresse IP',
    'actionlog__client' => 'Compte client',
    'actionlog__client_status' => 'Statut du compte client',
    'actionlog__client_preferences' => "Préférences de l'interface du client",
    'actionlog__client_ip_pool' => "Pool d'IP du client",
    'actionlog__client_siteapp' => "Pool d'applications Web du client",
    'actionlog__client_guid' => "GUID du client",
    'actionlog__domain' => 'Domaine par défaut (premier domaine ajouté à un abonnement)',
    'actionlog__domain_owner' => 'Propriétaire de l\'abonnement',
    'actionlog__domain_plan' => 'Pack de services de l\'abonnement',
    'actionlog__domain_status' => 'Domaine par défaut, statut',
    'actionlog__domain_dns' => 'Domaine par défaut, zone DNS',
    'actionlog__subdomain' => 'Sous-domaine d\'un domaine par défaut',
    'actionlog__domain_alias' => 'Domaine par défaut, alias',
    'actionlog__domain_alias_dns' => 'Domaine par défaut, zone DNS alias',
    'actionlog__site' => 'Domaine',
    'actionlog__site_status' => 'Statut du domaine',
    'actionlog__site_dns' => 'Zone DNS du domaine',
    'actionlog__site_guid' => 'GUID du domaine',
    'actionlog__site_subdomain' => 'Sous-domaine',
    'actionlog__site_alias' => 'Alias de domaine',
    'actionlog__site_alias_dns' => 'Zone DNS alias du domaine',
    'actionlog__domain_limits' => 'Limites de l\'abonnement',
    'actionlog__domain_limit_size' => 'Limite d\'espace disque pour l\'abonnement',
    'actionlog__domain_limit_traffic' => 'Limite du trafic pour l\'abonnement',
    'actionlog__domain_limits_powerUser' => 'Limites de l\'abonnement',
    'actionlog__domain_limit_size_powerUser' => 'Limite d\'espace disque pour l\'abonnement',
    'actionlog__domain_limit_traffic_powerUser' => 'Limite du trafic pour l\'abonnement',
    'actionlog__domain_guid' => "Domaine par défaut, GUID",
    'actionlog__cp_user' => 'Utilisateur Plesk',
    'actionlog__mailname' => 'Compte mail',
    'actionlog__maillist' => 'Liste de diffusion',
    'actionlog__phosting' => 'Paramètres d\'hébergement',
    'actionlog__forwarding' => 'Hébergement standard ou redirection par cadre',
    'actionlog__webuser' => 'Compte de l\'utilisateur Web',
    'actionlog__site_application' => 'Application Web',
    'actionlog__license' => 'Clé de licence',
    'actionlog__additional_license' => 'Clé de licence supplémentaire',
    'actionlog__template_domain' => "Pack de services du revendeur",
    'actionlog__template_admin' => "Pack de services de l'administrateur",
    'actionlog__template_reseller' => 'Pack revendeur',
    'actionlog__admin_alias' => 'Compte administrateur supplémentaire', // PFW
    'actionlog__ftpuser' => 'Compte FTP supplémentaire', // PFW
    'actionlog__db_server' => 'Serveur de bases de données',
    'actionlog__db' => 'Base de données',
    'actionlog__db_user' => 'Compte utilisateur de la base de données',
    'actionlog__client_sapppkg_pool' => "Applications Web de l'utilisateur", // PFW, not used?
    'actionlog__remote_dns' => 'Statut du serveur DNS distant', // PFW
    'actionlog__reseller' => 'Compte revendeur',
    'actionlog__reseller_guid' => 'GUID du revendeur',
    'actionlog__reseller_ip_pool' => "Pool d'adresses IP du revendeur",
    'actionlog__reseller_limit_size' => 'Limite d\'espace disque pour le compte revendeur',
    'actionlog__reseller_limit_traffic' => 'Limite du trafic pour le compte revendeur',
    'actionlog__reseller_limits' => 'Limites du compte revendeur',
    'actionlog__reseller_permissions' => 'Droits du revendeur',
    'actionlog__reseller_preferences' => "Préférences de l'interface du revendeur",
    'actionlog__reseller_siteapp' => "Applications Web dans le pool du revendeur",
    'actionlog__reseller_status' => 'Statut du compte revendeur',
    'actionlog__health_status' => 'Statut de la santé du serveur',
    // actions (PFU schema)
    'actionlog__limit_reached' => 'atteinte',
    'actionlog__added' => 'ajouté',
    'actionlog__removed' => 'supprimé(e)',
    'actionlog__change' => 'modifié',
    'actionlog__update' => 'mis(e) à jour',
    'actionlog__move' => 'déplacé',
    'actionlog__upgrade' => 'Mis à niveau', // PFU?
    'actionlog__update_or_add' => 'Mis à jour ou ajouté',
    'actionlog__expired' => 'expiré',
    'actionlog__create' => 'créé(e)',
    'actionlog__delete' => 'supprimé(e)',
    'actionlog__service_stop' => 'arrêté',
    'actionlog__service_restart' => 'redémarré',
    'actionlog__service_start' => 'démarré',
    'actionlog__login' => 'connecté',
    'actionlog__logout' => 'déconnecté',
    'actionlog__install' => 'installé',
    'actionlog__uninstall' => 'désinstallé',
    'actionlog__reconfigure' => 'reconfiguré',
    // events (PFW schema)
    'actionlog__event_pw_reset' => 'Demande de réinitialisation du mot de passe',
    'actionlog__event_admin_update' => 'Le profil de l\'administrateur a été mis à jour.',
    'actionlog__event_admin_preferences_update' => "Préférences de l'administrateur mises à jour",
    'actionlog__event_service_restart' => 'Le service a été redémarré',
    'actionlog__event_service_start' => 'Le service a été démarré',
    'actionlog__event_service_stop' => 'Le service a été arrêté',
    'actionlog__event_ip_address_create' => 'L\'adresse IP a été créée',
    'actionlog__event_ip_address_delete' => 'L\'adresse IP a été supprimée',
    'actionlog__event_ip_address_update' => 'L\'adresse IP a été mise à jour.',
    'actionlog__event_client_create' => 'Compte client créé',
    'actionlog__event_client_delete' => 'Compte client supprimé',
    'actionlog__event_client_update' => 'Compte client mis à jour',
    'actionlog__event_client_status_update' => 'Statut du compte client mis à jour',
    'actionlog__event_client_preferences_update' => "Préférences de l'interface du client mises à jour",
    'actionlog__event_client_siteapp_added' => "Application Web ajoutée au pool d'applications du compte client",
    'actionlog__event_client_siteapp_removed' => "Application Web supprimée du pool d'applications du compte client",
    'actionlog__event_domain_limit_size_reached' => 'Limite d\'espace disque atteinte pour l\'abonnement',
    'actionlog__event_domain_limit_traffic_reached' => 'Limite du trafic atteinte pour l\'abonnement',
    'actionlog__event_domain_limit_size_reached_powerUser' => 'Limite d\'espace disque atteinte pour l\'abonnement',
    'actionlog__event_domain_limit_traffic_reached_powerUser' => 'Limite du trafic atteinte pour l\'abonnement',

    'actionlog__domain_limit_database' => 'Quota de bases de données pour l\'abonnement',
    'actionlog__event_domain_limit_mysql_quota_reached' => 'Quota de bases de données MariaDB/MySQL atteint pour l\'abonnement',
    'actionlog__event_domain_limit_mysql_soft_quota_reached' => 'Quota doux de bases de données MariaDB/MySQL atteint pour l\'abonnement',
    'actionlog__event_domain_limit_mssql_quota_reached' => 'Quota de bases de données Microsoft SQL Server atteint pour l\'abonnement',
    'actionlog__event_domain_limit_mssql_soft_quota_reached' => 'Quota doux de bases de données Microsoft SQL Server atteint pour l\'abonnement',
    'actionlog__event_plesk_component_upgrade' => 'Composant Plesk mis à jour',
    'actionlog__event_plesk_component_install' => 'Composant Plesk installé',
    'actionlog__event_plesk_component_uninstall' => 'Composant Plesk désinstallé',
    'actionlog__event_domain_create' => 'Domaine par défaut (premier domaine ajouté à un abonnement) créé',
    'actionlog__event_domain_delete' => 'Domaine par défaut (premier domaine ajouté à un abonnement) supprimé',
    'actionlog__event_domain_update' => 'Domaine par défaut (premier domaine ajouté à un abonnement) mis à jour',
    'actionlog__event_domain_owner_change' => 'Propriétaire de l\'abonnement modifié',
    'actionlog__event_domain_plan_change' => 'Pack de services de l\'abonnement modifié',
    'actionlog__event_domain_status_update' => 'Domaine par défaut, statut mis à jour',
    'actionlog__event_domain_dns_update' => 'Domaine par défaut, zone DNS mise à jour',
    'actionlog__event_subdomain_create' => 'Sous-domaine d\'un domaine par défaut créé',
    'actionlog__event_subdomain_delete' => 'Sous-domaine d\'un domaine par défaut supprimé',
    'actionlog__event_subdomain_update' => 'Sous-domaine d\'un domaine par défaut mis à jour',
    'actionlog__event_domain_alias_create' => 'Domaine par défaut, alias créé',
    'actionlog__event_domain_alias_delete' => 'Domaine par défaut, alias supprimé',
    'actionlog__event_domain_alias_update' => 'Domaine par défaut, alias mis à jour',
    'actionlog__event_domain_limits_update' => 'Limites de l\'abonnement mises à jour',
    'actionlog__event_cp_user_login' => 'Utilisateur de Plesk connecté',
    'actionlog__event_cp_user_logout' => 'Utilisateur de Plesk déconnecté',
    'actionlog__event_mailname_create' => 'Compte mail créé',
    'actionlog__event_mailname_delete' => 'Compte mail supprimé',
    'actionlog__event_mailname_clear' => 'Compte mail vidé',
    'actionlog__event_mailname_update' => 'Compte mail mis à jour',
    'actionlog__event_maillist_create' => 'Liste de diffusion créée',
    'actionlog__event_maillist_delete' => 'Liste de diffusion supprimée',
    'actionlog__event_maillist_update' => 'Liste de diffusion mise à jour',
    'actionlog__event_phys_hosting_create' => 'Hébergement physique créé',
    'actionlog__event_phys_hosting_delete' => 'Hébergement physique supprimé',
    'actionlog__event_phys_hosting_update' => 'Hébergement physique mis à jour',
    'actionlog__event_forwarding_create' => 'Hébergement standard ou redirection par cadre créé',
    'actionlog__event_forwarding_delete' => 'Hébergement standard ou redirection par cadre supprimé',
    'actionlog__event_forwarding_update' => 'Hébergement standard ou redirection par cadre mis à jour',
    'actionlog__event_webuser_create' => 'Compte de l\'utilisateur Web créé',
    'actionlog__event_webuser_delete' => 'Compte de l\'utilisateur Web supprimé',
    'actionlog__event_webuser_update' => 'Compte de l\'utilisateur Web mis à jour',
    'actionlog__event_siteapp_install' => 'Application Web installée',
    'actionlog__event_siteapp_reconfigure' => 'Application Web reconfigurée',
    'actionlog__event_siteapp_uninstall' => 'Application Web non installée',
    'actionlog__event_license_update' => 'Clé de licence mise à jour',
    'actionlog__event_admin_alias_create' => 'Le compte administrateur supplémentaire a été créé',
    'actionlog__event_admin_alias_delete' => 'Le compte administrateur supplémentaire a été supprimé',
    'actionlog__event_admin_alias_update' => 'Le compte administrateur supplémentaire a été mis à jour',
    'actionlog__event_ftpuser_create' => 'Compte FTP supplémentaire créé',
    'actionlog__event_ftpuser_update' => 'Compte FTP supplémentaire mis à jour',
    'actionlog__event_ftpuser_delete' => 'Compte FTP supplémentaire supprimé',
    'actionlog__event_template_domain_create' => "Pack de services du revendeur créé",
    'actionlog__event_template_domain_update' => "Pack de services du revendeur mis à jour",
    'actionlog__event_template_domain_delete' => "Pack de services du revendeur supprimé",
    'actionlog__event_template_admin_create' => "Pack de services de l'administrateur créé",
    'actionlog__event_template_admin_update' => "Pack de services de l'administrateur mis à jour",
    'actionlog__event_template_admin_delete' => "Pack de services de l'administrateur supprimé",
    'actionlog__event_database_server_create' => 'Serveur de bases de données créé',
    'actionlog__event_database_server_update' => 'Serveur de bases de données mis à jour',
    'actionlog__event_database_server_delete' => 'Serveur de bases de données supprimé',
    'actionlog__event_remote_dns_status_update' => 'Le statut du serveur DNS distant a été mis à jour.',
    'actionlog__event_session_preferences_update' => 'Paramètres de la session mis à jour',
    'actionlog__event_domain_alias_dns_update' => 'Domaine par défaut, zone DNS de l\'alias de domaine mise à jour',
    'actionlog__event_domain_move' => 'Domaine par défaut déplacé vers un nouvel abonnement',
    'actionlog__event_site_move' => 'Domaine déplacé vers un nouvel abonnement',
    'actionlog__event_site_subdomain_move' => 'Sous-domaine déplacé vers un nouvel abonnement',
    'actionlog__event_subdomain_move' => 'Sous-domaine d\'un domaine par défaut déplacé vers un nouvel abonnement',
    'actionlog__event_license_expired' => 'Licence de Plesk expirée',
    'actionlog__event_database_create' => 'Base de données créée',
    'actionlog__event_database_delete' => 'Base de données supprimée',
    'actionlog__event_database_user_create' => 'Compte utilisateur de la base de données créé',
    'actionlog__event_database_user_update' => 'Paramètres du compte utilisateur de la base de données mis à jour',
    'actionlog__event_database_user_delete' => 'Compte utilisateur de la base de données supprimé',
    'actionlog__event_client_guid_update' => "GUID du client mis à jour",
    'actionlog__event_domain_guid_update' => 'Domaine par défaut, GUID mis à jour',
    'actionlog__event_reseller_create' => 'Compte revendeur créé',
    'actionlog__event_reseller_delete' => 'Compte revendeur supprimé',
    'actionlog__event_reseller_update' => 'Compte revendeur mis à jour',
    'actionlog__event_reseller_guid_update' => 'GUID du revendeur mis à jour',
    'actionlog__event_reseller_ip_pool_update' => "Pool d'adresses IP du revendeur mis à jour",
    'actionlog__event_reseller_limit_size_reached' => 'Limite max. d\'espace disque atteinte pour le compte revendeur',
    'actionlog__event_reseller_limit_traffic_reached' => 'Limite max. du trafic atteinte pour le compte revendeur',
    'actionlog__event_reseller_limits_update' => 'Limites du compte revendeur mises à jour',
    'actionlog__event_reseller_permissions_update' => 'Droits du compte revendeur mis à jour',
    'actionlog__event_reseller_preferences_update' => "Préférences de l'interface du revendeur mises à jour",
    'actionlog__event_reseller_siteapp_added' => "Application ajoutée au pool d'applications du compte revendeur",
    'actionlog__event_reseller_siteapp_removed' => "Application supprimée du pool d'applications du compte revendeur",
    'actionlog__event_reseller_status_update' => 'Statut du compte revendeur mis à jour',
    'actionlog__event_template_reseller_create' => 'Pack revendeur créé',
    'actionlog__event_template_reseller_delete' => 'Pack revendeur supprimé',
    'actionlog__event_template_reseller_update' => 'Pack revendeur mis à jour',
    'actionlog__event_health_status_change' => 'Statut de la santé du serveur modifié',
    'actionlog__event_siteapp_upgrade' => 'App Web mise à niveau',
    'actionlog__event_extension_install' => 'Extension installée',
    'actionlog__event_extension_uninstall' => 'Extension désinstallée',
    'actionlog__event_extension_upgrade' => 'Extension mise à niveau',
    'actionlog__event_extension_status_update' => 'Statut de l’extension mis à jour',
    'actionlog__event_additional_license_expired' => 'La licence supplémentaire a expiré',
    'actionlog__event_hostname_changed' => 'Nom d\'hôte du serveur modifié',
    'actionlog__event_smb_user_create' => 'Autre utilisateur créé',
    'actionlog__event_smb_user_delete' => 'Autre utilisateur supprimé',
    'actionlog__event_smb_user_update' => 'Autre utilisateur mis à jour',
    'actionlog__dns_record' => 'Enregistrement DNS',
    'actionlog__dns_zone' => 'Zone DNS',

    // REMOTE SESSION
    'rsession_no_api_rpc_errmsg' => "L'API RPC de Plesk n'est pas installée sur l'hôte distant. Veuillez contacter votre fournisseur de services pour obtenir de l'aide.",
    'rsession_no_account_errmsg' => "Impossible d'accéder au service à distance sous votre compte. Le plus souvent, c'est parce que ce service n'est pas encore activé pour votre compte. Patientez quelques minutes puis réessayez. Si vous rencontrez le même problème, contactez votre administrateur système.",
    'rsession_no_domain_errmsg' => "Impossible d'accéder au service à distance pour ce domaine. Le plus souvent, c'est parce que ce service n'est pas encore activé pour ce domaine. Patientez quelques minutes puis réessayez. Si vous rencontrez le même problème, contactez votre administrateur système.",
    'rsession_unknown_errmsg' => "Le serveur distant a bloqué la tentative d'établissement d'une session. Demandez de l'aide à votre administrateur système. L'erreur était :  %1",
    'rsession_unknown2_errmsg' => "Une erreur inconnue s'est produite lors de l'établissement d'une session à distance. La plupart du temps, le serveur distant ne répond pas correctement ou ne répond pas du tout. Demandez à votre administrateur système de vérifier les détails de l'erreur dans le log d'erreurs du serveur Web.",
    'rsession_no_connect_errmsg' => "Impossible d'accéder au service à distance : la connexion à une session à distance a échoué. Demandez de l'aide à votre administrateur système.",

    // ANONYMOUS FTP
    'anonftp__allow_upload_incoming' => "Autoriser le chargement dans le répertoire incoming",
    'anonftp__allow_create_dirs' => 'Autoriser la création de répertoires dans le répertoire incoming',
    'anonftp__allow_download_incoming' => 'Autoriser les téléchargements à partir du répertoire incoming',
    'anonftp__display_login' => 'Afficher le message de connexion',
    'anonftp__login_text' => 'Texte du message',
    'anonftp__limit_incoming_disk_space' => "Limiter l'espace disque du répertoire incoming",
    'anonftp__limit_maximum_bandwidth' => "Limiter la vitesse de téléchargement pour ce domaine FTP virtuel",
    'anonftp__limit_maximum_connections' => "Limiter le nombre de connexions simultanées",
    'anonftp__unable_init' => "Impossible d'initialiser le compte FTP anonyme : %1",
    'anonftp__unable_set_quota' => "Impossible de définir la limite de l'espace disque pour le répertoire incoming : %1",
    'anonftp__unable_update' => "Impossible de mettre à jour la config. du compte FTP anonyme : %1",

    ///
    /// SSL/TLS CERTIFICATES
    ///

    // common keys
    '__certificates' => 'Certificats SSL/TLS', // page title
    // errors
    'class_sslcertificate__ca_not_signs' => "Le certificat CA ne signe pas le certificat.",
    'class_sslcertificate__incompatible_pvt_key_cert' => "La paire certificat/clé privée est incompatible.",
    'class_sslcertificate__invalid_cert_format' => "Format du certificat non valide.",
    'class_sslcertificate__invalid_private_key_format' => "Format de clé privée incorrect.",
    'class_sslcertificate__prob_invalid_priv_key' => "Le format de clé est probablement incorrect.",

    ///
    ///END OF SSL/TLS CERTIFICATES
    ///

    ///
    /// DONE MESSAGES
    ///

    // UI
    'ui____done' => 'L\'opération s\'est bien déroulée.',
    'ui__admin/extras-domain__done' => 'La page MyPlesk.com a été ouverte.',
    'ui__admin/report/layout/delete_multi__done' => 'Les styles de rapport sélectionnés ont été supprimés.',
    'ui__admin/report/traffic-history__done' => 'L\'opération s\'est bien déroulée.',
    'ui__admin/report__done' => 'L\'opération s\'est bien déroulée.',
    'ui__admin-alias/delete_multi__done' => "Les comptes administrateur supplémentaires sélectionnés ont été supprimés.",
    'ui__admin-alias/properties__done' => "Les propriétés du compte administrateur supplémentaire ont été mises à jour.",
    'ui__admin-alias/properties_new__done' => "Le compte administrateur supplémentaire a été créé.",
    'ui__admin-alias/properties_unknown__done' => "Les propriétés du compte administrateur supplémentaire ont été mises à jour.",
    'ui__admin-alias__done' => "Les informations sur le compte administrateur supplémentaire ont bien été mises à jour.",
    'ui__admin/manage-domain__done' => 'La page MyPlesk.com a été ouverte.',
    'ui__admin/register-domain__done' => 'La page MyPlesk.com a été ouverte.',
    'ui__admin/report/layout/auto/delete_multi__done' => 'Les planifications d\'envoi du rapport sélectionné ont été supprimées.',
    'ui__admin/report/layout/auto/properties__done' => 'La planification de l\'envoi du rapport a été mise à jour.',
    'ui__admin/report/layout/auto/properties_new__done' => 'La planification de l\'envoi du rapport a été créée.',
    'ui__client/domain/certificate/properties__done' => 'Les propriétés du certificat SSL/TLS ont été mises à jour.',
    'ui__client/domain/certificate/properties_new__done' => 'Le nouveau certificat SSL/TLS a été ajouté. Pour l\'activer, sélectionnez-le dans les Paramètres d\'hébergement du site Web (onglet Sites Web & Domaines /> nom de domaine).',
    'ui__client/domain/certificate__done' => 'L\'opération s\'est bien déroulée.',
    'ui__client/domain/certificate_self__done' => 'L\'opération s\'est bien déroulée.',
    'ui__client/domain/chowner__done' => 'L\'abonnement %1 appartient maintenant à un autre utilisateur.',
    'ui__client/domain/chowner_multi__done' => 'Le propriétaire de l\'abonnement a été changé.',
    'ui__client/domain/chowner_multi-select__done' => 'L\'opération s\'est bien déroulée.',
    'ui__client/domain/chowner_select__done' => 'L\'opération s\'est bien déroulée.',
    'ui__client/domain/dbbackup/create__done' => "La base de données a bien été sauvegardée", // PFW
    'ui__client/domain/dbbackup/get__done' => "La base de données a bien été sauvegardée", // PFW
    'ui__client/domain/dbbackup/orphaned__done' => "L'utilisateur orphelin a bien été réparé.", // PFW
    'ui__client/domain/dbbackup/remove__done' => "Les fichiers de sauvegarde ont bien été supprimés.", // PFW
    'ui__client/domain/dbbackup/restore__done' => "Le contenu de la base de données a bien été restauré.", // PFW
    'ui__client/domain/dbbackup/upload__done' => "L'opération s'est bien déroulée.", // PFW
    'ui__client/domain/dbbackup__done' => "L'opération s'est bien déroulée.", // PFW
    'ui__client/domain/dbbackup_self__done' => "L'opération s'est bien déroulée.", // PFW
    'ui__client/domain/dbbackup_unknown__done' => "L'opération s'est bien déroulée.", // PFW
    'ui__client/domain/delete__done' => "Le domaine %1 a été supprimé.",
    'ui__client/domain/delete_multi__done' => "Les domaines ont été supprimés.",
    'ui__client/domain/disable__done' => 'Le domaine %1 a été suspendu.',
    'ui__client/domain/disable_multi__done' => 'Les domaines sélectionnés ont été suspendus.',
    'ui__client/domain/enable__done' => 'Le site Web %1 a bien été activé.',
    'ui__client/domain/enable_multi__done' => 'Les sites Web sélectionnés ont été activés.',
    'ui__client/domain/extras__done' => 'La page MyPlesk.com a été ouverte.',
    'ui__client/domain/extras_self__done' => 'La page MyPlesk.com a été ouverte.',
    'ui__client/domain/hosting/logs/rotation__done' => 'Les paramètres de rotation des journaux ont été changés.',
    'ui__client/domain/hosting/logs/rotation_self__done' => 'Les paramètres de rotation des journaux ont été changés.',
    'ui__client/domain/hosting/logs__done' => 'L\'opération s\'est bien déroulée.',
    'ui__client/domain/hosting/logs_self__done' => 'L\'opération s\'est bien déroulée.',
    'ui__client/domain/hosting/setup__done' => 'L\'hébergement pour %1 a été configuré.',
    'ui__client/domain/hosting/ssh-terminal__done' => 'L\'opération s\'est bien déroulée.', // PFU
    'ui__client/domain/hosting/ssh-terminal_self__done' => 'L\'opération s\'est bien déroulée.', // PFU
    'ui__client/domain/mpc-certificates__done' => 'Certificats SSL/TLS disponibles dans la boutique en ligne',
    'ui__client/domain/mpc-certificates_self__done' => 'Certificats SSL/TLS disponibles dans la boutique en ligne',
    'ui__client/domain/register__done' => 'La page MyPlesk.com a été ouverte.',
    'ui__client/domain/register_self__done' => 'La page MyPlesk.com a été ouverte.',
    'ui__client/domain/rename__done' => 'Le nom de domaine a été changé.',
    'ui__client/domain/rename_self__done' => "Le nom de domaine a bien été changé.",
    'ui__client/domain/settings_self__done' => 'L\'opération s\'est bien déroulée.',
    'ui__client/domain/toggle_disable__done' => "Le domaine %1 a été suspendu.",
    'ui__client/domain/toggle_enable__done' => "Le domaine %1 a bien été activé.",
    'ui__client/domain/traffic__done' => 'L\'opération s\'est bien déroulée.',
    'ui__client/domain/traffic_self__done' => 'L\'opération s\'est bien déroulée.',
    'ui__client/domain/traffic_unknown__done' => 'L\'opération s\'est bien déroulée.',
    'ui__client/domain-summary-report__done' => 'L\'opération s\'est bien déroulée.',
    'ui__client/domain-summary-report_self__done' => 'L\'opération s\'est bien déroulée.',
    'ui__client/domain-summary-report_unknown__done' => 'L\'opération s\'est bien déroulée.',
    'ui__client/extras-domain__done' => 'La page MyPlesk.com a été ouverte.',
    'ui__client/extras-domain_self__done' => 'La page MyPlesk.com a été ouverte.',
    'ui__client/ipaddress/delete_multi__done' => 'L\'opération s\'est bien déroulée.',
    'ui__client/ipaddress/properties__done' => 'L\'opération s\'est bien déroulée.',
    'ui__client/ipaddress/properties_new__done' => 'L\'opération s\'est bien déroulée.',
    'ui__client/ip-pool/properties__done' => "Le pool d'adresses IP du client %1 a été mis à jour.",
    'ui__client/ip-pool/properties_self__done' => 'L\'opération s\'est bien déroulée.',
    'ui__client/limits__done' => "Les limites des ressources pour le client %1 ont été modifiées.",
    'ui__client/limits_self__done' => 'L\'opération s\'est bien déroulée.',
    'ui__client/logo__done' => 'Les nouveaux paramètres de marque pour le client %1 ont été appliqués.',
    'ui__client/logo_reseller__done' => 'Les nouveaux paramètres de marque de Plesk ont été enregistrés.',
    'ui__client/logo_self__done' => 'Les paramètres de la marque ont été appliqués.',
    'ui__client/logo_self-reseller__done' => 'Les paramètres de marque de votre version du panneau ont été enregistrés.',
    'ui__client/manage-domain__done' => 'La page MyPlesk.com a été ouverte.',
    'ui__client/manage-domain_self__done' => 'La page MyPlesk.com a été ouverte.',
    'ui__client/permissions__done' => "Les droits du client %1 ont été changés.",
    'ui__client/permissions_self__done' => 'L\'opération s\'est bien déroulée.',
    'ui__client/preferences__done' => "Les préférences pour le client %1 ont été changées.",
    'ui__client/preferences_self__done' => "Vos préférences ont été changées.",
    'ui__client/register-domain__done' => 'La page MyPlesk.com a été ouverte.',
    'ui__client/register-domain_self__done' => 'La page MyPlesk.com a été ouverte.',
    'ui__client/report/traffic-history__done' => 'L\'opération s\'est bien déroulée.',
    'ui__client/report/traffic-history_self__done' => 'L\'opération s\'est bien déroulée.',
    'ui__client/report__done' => 'L\'opération s\'est bien déroulée.',
    'ui__client/report_self__done' => 'L\'opération s\'est bien déroulée.',
    'ui__client/sessions/delete__done' => 'L\'opération s\'est bien déroulée.',
    'ui__client/sessions/delete_self__done' => 'L\'opération s\'est bien déroulée.',
    'ui__client/sessions__done' => 'L\'opération s\'est bien déroulée.',
    'ui__client/sessions_self__done' => 'L\'opération s\'est bien déroulée.',
    'ui__client/traffic__done' => "L'opération s'est bien déroulée.",
    'ui__client/traffic_unknown__done' => 'L\'opération s\'est bien déroulée.',
    'ui__cp-access__done' => 'L\'opération s\'est bien déroulée.',
    'ui__cp-session/properties__done' => 'L\'opération s\'est bien déroulée.',
    'ui__cp-session__done' => 'L\'opération s\'est bien déroulée.',
    'ui__ftp-sessions__done' => 'L\'opération s\'est bien déroulée.',
    'ui__license__done' => 'L\'opération s\'est bien déroulée.',
    'ui__logo__done' => "Les propriétés de marque de Plesk ont été changées.",
    'ui__longtasks/longtask/properties__done' => "Les paramètres de la tâche en arrière-plan ont bien été changés.",
    'ui__modules/watchdog/disk/properties__done' => 'Les paramètres de surveillance du nouveau disque ont été appliqués.', // PFU
    'ui__modules__done' => 'L\'opération s\'est bien déroulée.',
    'ui__modules__short-title' => 'Extensions',
    'ui__modules__title' => 'Extensions',
    'ui__reseller/client/traffic_unknown__done' => 'L\'opération s\'est bien déroulée.',
    'ui__reseller/extras-domain__done' => 'La page MyPlesk.com a été ouverte.',
    'ui__reseller/extras-domain_self__done' => 'La page MyPlesk.com a été ouverte.',
    'ui__reseller/ftp-sessions_self__done' => 'L\'opération s\'est bien déroulée.',
    'ui__reseller/limits__done' => "Les politiques d'utilisation de ressources et les limites des ressources du revendeur ont été changées.",
    'ui__reseller/limits_readonly-self__done' => 'L\'opération s\'est bien déroulée.',
    'ui__reseller/limits_self__done' => 'Les politiques d\'utilisation de ressources et les limites de vos ressources ont été changées.',
    'ui__reseller/manage-domain__done' => 'La page MyPlesk.com a été ouverte.',
    'ui__reseller/manage-domain_self__done' => 'La page MyPlesk.com a été ouverte.',
    'ui__reseller/permissions__done' => 'Les droits du revendeur %1 ont été changés.',
    'ui__reseller/permissions_readonly-self__done' => '',
    'ui__reseller/permissions_self__done' => 'L\'opération s\'est bien déroulée.',
    'ui__reseller/register-domain__done' => 'La page MyPlesk.com a été ouverte.',
    'ui__reseller/register-domain_self__done' => 'La page MyPlesk.com a été ouverte.',
    'ui__reseller/report/layout/auto/delete_multi__done' => 'Les planifications d\'envoi du rapport sélectionné ont été supprimées.',
    'ui__reseller/report/layout/auto/properties__done' => 'La planification de l\'envoi du rapport a été mise à jour.',
    'ui__reseller/report/layout/auto/properties_new__done' => 'La planification de l\'envoi du rapport a été ajoutée.',
    'ui__reseller/report/traffic-history__done' => 'L\'opération s\'est bien déroulée.',
    'ui__reseller/report/traffic-history_self__done' => 'L\'opération s\'est bien déroulée.',
    'ui__reseller/report__done' => 'L\'opération s\'est bien déroulée.',
    'ui__reseller/report_self__done' => 'L\'opération s\'est bien déroulée.',
    'ui__reseller/sessions/delete__done' => 'L\'opération s\'est bien déroulée',
    'ui__reseller/sessions/delete_self__done' => 'L\'opération s\'est bien déroulée',
    'ui__reseller/sessions__done' => 'L\'opération s\'est bien déroulée.',
    'ui__reseller/sessions_self__done' => 'L\'opération s\'est bien déroulée.',
    'ui__reseller/traffic__done' => 'L\'opération s\'est bien déroulée.',
    'ui__reseller/traffic_self__done' => 'L\'opération s\'est bien déroulée.',
    'ui__reseller/traffic_unknown__done' => 'L\'opération s\'est bien déroulée.',
    'ui__reseller/logo_self__title' => 'Apparence de Plesk',
    'ui__reseller/logo_self__done' => 'Les paramètres de marque de votre version de Plesk ont été enregistrés.',
    'ui__server/certificate/default_multi__done' => 'Le certificat SSL/TLS sélectionné a été configuré pour servir à protéger les connexions aux sites Web nouvellement hébergés.',
    'ui__server/certificate/delete_multi__done' => 'Les certificats SSL/TLS sélectionnés ont été supprimés.',
    'ui__server/certificate/download__done' => 'Le certificat SSL/TLS a été téléchargé.',
    'ui__server/certificate/properties__done' => 'Les propriétés du certificat SSL/TLS ont été mises à jour.',
    'ui__server/certificate/properties_new__done' => 'Le certificat SSL/TLS %1 a été créé.',
    'ui__server/certificate/setup_multi__done' => 'Le certificat SSL/TLS sélectionné a été configuré pour servir à protéger les connexions à Plesk.',
    'ui__server/certificate__done' => 'L\'opération s\'est bien déroulée.',
    'ui__server/cp-certificate-download__done' => "Le certificat SSL/TLS de Plesk a été téléchargé.",
    'ui__server/crontab/properties__done' => 'Les tâches planifiées de %1 ont été modifiées.',
    'ui__server/crontab/task/delete__done' => 'La tâche a été supprimée.',
    'ui__server/crontab/task/delete_multi__done' => 'Les tâches ont été supprimées.',
    'ui__server/crontab/task/properties__done' => 'Les tâches planifiées ont été mises à jour.',
    'ui__server/crontab/task/properties_new__done' => 'La nouvelle tâche a été planifiée.',
    'ui__server/crontab/task/toggle_disable__done' => 'La tâche planifiée %1 a été désactivée.',
    'ui__server/crontab/task/toggle_enable__done' => 'La tâche planifiée %1 a été activée.',
    'ui__server/crontab__done' => 'L\'opération s\'est bien déroulée.',
    'ui__server/dns__done' => 'L\'opération s\'est bien déroulée.',
    'ui__server/ip-address/client/delete__done' => "L'adresse IP été supprimée du pool d'adresses IP de l'utilisateur.",
    'ui__server/ip-address/client/delete_multi__done' => "L'adresse IP été supprimée des pools d'adresses IP des utilisateurs.",
    'ui__server/ip-address/client/properties_new__done' => 'L\'adresse IP a été affectée aux utilisateurs.',
    'ui__server/ip-address/ip-address/add-to-clients_add-target__done' => 'L\'adresse IP %1 a été affectée aux clients sélectionnés.',
    'ui__server/ip-addresses__done' => "L'opération s'est bien déroulée.",
    'ui__server/mail__done' => 'Les paramètres du serveur de messagerie ont été changés.',
    'ui__server/maillists__done' => 'L\'opération s\'est bien déroulée.',
    'ui__server/mpc-certificates__done' => 'La page de la boutique en ligne listant les certificats SSL/TLS disponibles a été ouverte.',
    'ui__server/pmm__done' => 'L\'opération s\'est bien déroulée.',
    'ui__server/preferences__done' => "Les paramètres du serveur ont été changés.",
    'ui__server/register__done' => 'La page MyPlesk.com était ouverte.',
    'ui__server/services__done' => 'L\'opération s\'est bien déroulée.',
    'ui__server/sitebuilder__done' => 'L\'opération s\'est bien déroulée.',
    'ui__server/spam-filter/black-list/address/delete__done' => 'L\'adresse %1 a été supprimée de la liste noire de l\'ensemble du serveur.',
    'ui__server/spam-filter/black-list/address/delete_multi__done' => 'Les adresses ont été supprimées de la liste noire de l\'ensemble du serveur.',
    'ui__server/spam-filter/black-list/address/properties_new__done' => 'Les adresses ont été ajoutées à la liste noire.',
    'ui__server/spam-filter/black-list/address__done' => 'Les adresses ont été ajoutées à la liste noire.',
    'ui__server/spam-filter/black-list__done' => 'L\'opération s\'est bien déroulée.', // PFU
    'ui__server/spam-filter/properties__done' => 'La configuration du filtre anti-spam a été modifiée.',
    'ui__server/spam-filter/toggle_disable__done' => 'Le filtre anti-spam a été désactivé pour l\'ensemble du serveur.',
    'ui__server/spam-filter/toggle_enable__done' => 'Le filtre anti-spam a été activé pour l\'ensemble du serveur.',
    'ui__server/spam-filter/white-list/address/delete__done' => 'L\'adresse %1 a été supprimée de la liste blanche de l\'ensemble du serveur.',
    'ui__server/spam-filter/white-list/address/delete_multi__done' => 'Les adresses ont été supprimées de la liste blanche de l\'ensemble du serveur.',
    'ui__server/spam-filter/white-list/address/properties_new__done' => 'Les adresses ont été ajoutées à la liste blanche.',
    'ui__server/spam-filter/white-list/address__done' => 'Les adresses ont été ajoutées à la liste blanche.',
    'ui__server/spam-filter/white-list__done' => 'L\'opération s\'est bien déroulée.', // PFU
    'ui__server/spam-filter__done' => 'L\'opération s\'est bien déroulée.',
    'ui__server/statistics__done' => 'L\'opération s\'est bien déroulée.',
    'ui__server/time__done' => "La date et l'heure du système ont été modifiées.",
    'ui__server__done' => "L'opération s'est bien déroulée.",
    'ui__sessions/properties__done' => 'L\'opération s\'est bien déroulée.',
    'ui__sessions__done' => 'L\'opération s\'est bien déroulée.',
    'ui__sessions/delete__done' => 'Les sessions sélectionnées ont été supprimées.',
    'ui__support__done' => 'Le formulaire de requête d\'assistance a été ouvert dans une autre fenêtre de navigateur ou un autre onglet.',

    ///
    /// END OF DONE MESSAGES
    ///

    ///
    /// ASSORTED COMMON KEYS / TBI
    ///

    // non-UI
    '__no_files_to_upload' => 'Aucun fichier à envoyer.',
    'login_up__access_denied_no_permission' => "Accès refusé. Vous n'avez pas le droit de vous connecter.",
    'mail__unable_remove_pattern' => "Impossible de supprimer l'adresse de la liste noire de serveurs : %1", // PFW
    'mail__incorrect_network_format' => 'Format du réseau incorrect : %1', // PFW
    'initconf__unable_change_passwd' => "Impossible de changer le mot de passe de l'administrateur : %1",
    'initconf__unable_get_passwd' => 'Impossible de récupérer le mot de passe de l\'administrateur actuel : %1 failed: %2',
    'initconf__invalid_hostname' => 'Erreur dans le nom d\'hôte "%1"',
    'initconf__unable_reconfig' => 'Impossible de configurer Plesk : reconfig failed: %1',
    'initconf__unable_update_admin' => 'Impossible de configurer les infos de contact administrateur : %1',
    '__refresh' => 'Actualiser',
    '__dalias_not_exist' => 'Cet alias de domaine n\'existe pas.',
    '__bug146523_explanation' => 'Les versions antérieures de Plesk autorisaient jusqu\'à 16 caractères pour les noms d\'utilisateur FTP. Cette version de Plesk limite le nombre maximum de caractères autorisés dans les noms d\'utilisateur FTP à 15. Pour résoudre ce problème, réduisez la longueur du nom d\'utilisateur FTP à 15 caractères pour les noms d\'utilisateur FTP concernés et changez au moins l\'un des caractères dans les noms d\'utilisateur FTP concernés pour éviter tout problème de doublons entre les noms d\'utilisateur. Nous sommes désolés pour la gêne occasionnée par ce changement.',
    'domain__cannot_change_webmail' => 'Impossible de mettre à changer la messagerie Web du domaine : %1',
    'sb_publish_disable_warning' => 'Si vous désactivez la création de sites avec Presence Builder, le site Web que vous avez créé auparavant avec Presence Builder sera supprimé et toutes les données du site seront perdues. Cliquez sur OK si vous voulez continuer.',
    '__sbnet_client_use_sbnet' => "Créer un compte utilisateur correspondant dans Presence Builder",
    'mail_resp_activate' => 'Activer la réponse automatique',
    'limitsManger__limit_available_error' => 'Impossible d\'affecter le volume requis de ressources ("%%limitName%%") : seulement %%available%% est disponible pour votre compte.',
    'limitsManger__limit_reserved_error' => 'Impossible d\'affecter moins de ressources ("%%limitName%%") que celles déjà utilisées.',
    'domain__unable_to_rename_vhost_dir_already_exists' => 'Impossible de renommer le domaine : un répertoire virtuel avec le nom spécifié existe déjà.',
    'domain_unable_to_rename' => 'Impossible de renommer le domaine.',

    // Greylisting
    'spamfilter__general_settings_legend' => 'Général',
    'spamfilter__spamassassin_status_legend' => 'Filtre anti-spam SpamAssassin',
    'spamfilter__spamassassin_settings_legend' => 'Paramètres SpamAssassin',
    'spamfilter__spamassassin_server_status_legend' =>  "Activer les paramètres de filtre anti-spam SpamAssassin valables pour tout le serveur",
    'spamfilter__spamassassin_user_status_legend' => 'Activer le filtre anti-spam SpamAssassin',
    'spamfilter__greylisting_status_legend' => 'Activer la protection anti-spam Greylisting valable pour l\'ensemble du serveur',
    'spamfilter__personal_settings_not_allowed' => 'L\'utilisation des paramètres individuels de filtre anti-spam n\'est pas autorisée par la politique du système.',
    'spamfilter__required_score' => 'Nombre de points qu\'un message doit avoir pour être qualifié comme spam',
    'spamfilter__rewrite_header_subject' => 'Insérer le texte suivant en tête de la ligne Objet de chaque mail reconnu comme spam',
    'spamfilter__use_mailuser_prefs' => 'Appliquer les paramètres individuels au filtre anti-spam',
    'spamfilter__score_error' => 'Le résultat ne doit pas être négatif. La partie après le point décimal doit être inférieure à 100 et ne doit pas compter plus deux chiffres après le point décimal.',
    'spamfilter__rewrite_header_error' => 'L\'objet du message peut contenir tout type de caractère imprimable, excepté le symbole #.',

    // template conflict keys
    'nonexistent_mail__mode_bounce' => 'Rejeter',
    'nonexistent_mail__mode_discard' => 'Ignorer',
    'nonexistent_mail__mode_catch_addr' => 'Transférer vers une adresse mail',
    'nonexistent_mail__mode_catch_ip' => 'Transférer vers l\'IP',
    'nonexistent_mail__bounce_not_supported' => 'Le mode Rejeter n\'est pas bris en charge.',
    'nonexistent_mail__discard_not_supported' => 'Le mode Ignorer n\'est pas pris en charge.',
    'nonexistent_mail__catch_not_supported' => 'La redirection vers une adresse de messagerie n\'est pas prise en charge.',
    'nonexistent_mail__redirect_not_supported' => 'La redirection vers l\'IP n\'est pas prise en charge.',
    'nonexistent_mail__ip_used_on_this_host' => 'L\'adresse IP résout vers l\'hôte local',
    'nonexistent_mail_address_should_be_local_domain' => 'Comme le contrôle des mails sortants est activé, l\'adresse mail pour les destinataires inexistants (%1) doit appartenir au domaine sélectionné. Si tel n\'est pas le cas, la politique "Rejeter" sera appliquée à la place du transfert.',
    'nonexistent_mail_address_should_be_local_domain_not_restricted' => 'Comme le contrôle des mails sortants est activé, l\'adresse mail indiquée pour le transfert des mails (%1) doit appartenir au domaine sélectionné. Si ce n\'est pas le cas, alors les messages envoyés à cette adresse ne seront pas comptés dans le contrôle des mails sortants.',
    // mail acc extras
    '__antivirus' => "Antivirus",

    // web apps

    // none available
    'ui__admin-alias__none-available' => 'Aucun autre compte administrateur n\'est disponible.', // PFW
    'ui__client/domain/certificate__none-available' => 'Le client n\'a aucun certificat SSL/TLS.',
    'ui__client/domain/certificate__none-available__1' => 'Le client n\'a aucun domaine doté de certificats SSL/TLS.',
    'ui__client/domain/certificate__none-available__2' => 'Domaine sans certificat SSL/TLS.',
    'ui__reseller/client__none-available' => 'Il n\'y a aucun revendeur avec des clients.',

    // empty selection for lists
    'ui__client/ipaddress/delete__empty_selection' => 'Vous devez sélectionner les adresses IP que vous voulez supprimer du pool d\'adresses IP.',
    'ui__server/ip-address/client/delete__empty_selection' => 'Vous devez sélectionner les comptes revendeur avec le pool d\'adresses IP à partir duquel vous voulez révoquer une adresse IP.',
    'ui__server/crontab/task/delete__empty_selection' => 'Vous devez sélectionner la tâche que vous voulez supprimer',

    // scripting languages errors
    'phosting__aspdotnet_not_enabled' => 'La prise en charge d\'ASP.NET est désactivée pour ce site Web.',
    'phosting__php_forced_by_site_isolation' => 'Impossible de changer les paramètres PHP : le droit d\'outrepasser la politique sécuritaire du serveur n\'est pas accordé.',
    'phosting__option_forced_by_site_isolation' => 'Impossible de changer les paramètres %1 : le droit d\'outrepasser la politique sécuritaire du serveur n\'est pas accordé.',
    'phosting__php_handler_id_not_registered' => 'Le gestionnaire PHP n\'est pas autorisé dans les paramètres d\'isolation du site. Le gestionnaire PHP par défaut sera utilisé.',
    'phosting__php_served_by_nginx_is_not_available' => 'Le gestionnaire PHP (application FPM servie par Nginx) n\'est pas autorisé par les paramètres d\'isolation du site. Le gestionnaire PHP par défaut sera utilisé.',

    // various UI
    'ui__client/ipaddress/properties_readonly__short-title' => 'Afficher la liste des adresses IP',
    'ui__client/ipaddress/properties_readonly__title' => 'Afficher la liste des adresses IP',
    'ui__client/ipaddress/properties_readonly__description' => 'Affichez la liste des adresses IP disponibles pour cet utilisateur.',
    'ui__server/certificate__short-title' => 'Certificats SSL/TLS',
    'ui__server/certificate__title' => 'Certificats SSL/TLS',
    'ui__server/certificate__description' => 'Consultez et gérez les certificats SSL/TLS.',

    'ui__client/ipaddress/delete_multi__wizard-title' => 'Supprimer les adresses IP',
    'ui__client/ipaddress/delete_multi__wizard__2_multi' => 'Sélectionner les adresses IP que vous voulez supprimer du pool d\'adresses IP du client %1',

    // mail

    'ui__client/ipaddress__short-title' => 'Adresse IP',
    'ui__client/ipaddress__title' => 'Adresse IP',
    'ui__client/ipaddress__description' => 'Affichez les infos sur l\'adresse IP.',
    'ui__server/ip-address__short-title' => 'Adresse IP',
    'ui__server/ip-address__title' => 'Adresse IP',
    'ui__server/ip-address__description' => 'Affichez les infos sur l\'adresse IP.',
    'ui__client/domain/hosting/setup__short-title' => 'Paramètres d\'hébergement Web',
    'ui__client/domain/hosting/setup__title' => 'Paramètres d\'hébergement Web',
    'ui__client/domain/hosting/setup__description' => 'Configurez les paramètres d\'hébergement Web du site Web %1.',

    // tooltips

    'b_get_password_cancel' => 'Revenir à l\'écran précédent sans envoyer le mail.',
    'b_get_password_send' => 'Cliquer sur OK pour envoyer un message de récupération du mot de passe à l\'adresse mail enregistrée dans le système.',



    'b_personaltrafficlist_search' => 'Entrez un mot-clé puis cliquez pour trouver les domaines.',
    'b_personaltrafficlist_show_all' => 'Affichez tous les domaines.',

    'b_back' => 'Retournez à la page précédente.',
    'b_next' => 'Allez à la page suivante.',

    'b_dnsnstemplatelist_remove' => 'Supprimez les serveurs de noms sélectionnés.',
    'b_dnsnstemplatelist_search' => 'Saisissez un mot-clé et cliquez pour chercher des serveurs de noms.',
    'b_dnsnstemplatelist_show_all' => 'Affichez tous les serveurs de noms.',

    'l_dnsnstemplatelist_ns' => 'Trier les enregistrements de templates DNS par serveur de noms.',

    // filesharing management tool
    'cu__serverfilesharing_fsLinksAsHttps' => 'Générer des liens vers les fichiers et dossiers',
    'cu__serverfilesharing_fsPublicFolderEnabled' => 'Activer les fichiers publics',
    'cu__serverfilesharing_fsPublicFolder' => 'Dossier pour stocker les fichiers publics',
    'cu__serverfilesharing_fsPublicUrl' => 'URL pour l\'accès des visiteurs aux dossiers publics',
    'cu__serverfilesharing_fsPartnerFolderEnabled' => 'Activer la protection par mot de passe des fichiers publics',
    'cu__serverfilesharing_fsPartnerFolder' => 'Dossier pour stocker les fichiers protégés par un mot de passe',
    'cu__serverfilesharing_fsPartnersLogin' => 'Nom d\'utilisateur pour accéder aux fichiers',
    'cu__serverfilesharing_fsPartnersPassword' => 'Mot de passe pour accéder aux fichiers',
    'cu__serverfilesharing_fsDomain' => 'URL du dossier Web root. Nom de domaine',
    'cu__serverfilesharing_fsPrefix' => 'URL du dossier Web root. Préfixe',
    'cu__serverfilesharing_commandUpdate' => 'Mettre à jour les paramètres de partage de fichiers',
    'cu__serverfilesharing_commandInfo' => 'Afficher les paramètres actuels de partage de fichiers',
    'subscription_rename_is_forbidden' => 'La politique appliquée à l\'ensemble du serveur interdit de renommer les abonnements.',
    ///
    /// END OF RANDOM COMMON KEYS
    ///

    ////
    //// CRONTAB - temporary
    ////

    // wizard:

    'ui__server/crontab/task_unknown__wizard-title' => 'Gérer les tâches planifiées sur le serveur',
    'ui__server/crontab/task_unknown__wizard__2_unknown' => 'Sélectionnez l\'utilisateur système dont vous voulez gérer les tâches planifiées.',

    'ui__server/crontab/task__short-title' => '%1',
    'ui__server/crontab/task__title' => 'Tâche planifiée %1',
    'ui__server/crontab/task__description' => 'Affichez les propriétés de la tâche planifiée %1.',

    ///
    /// SERVER
    ///

    'ui__server/crontab_unknown__short-title' => 'Utilisateurs système',
    'ui__server/crontab_unknown__title' => 'Utilisateurs système',
    'ui__server/crontab_unknown__description' => 'Utilisateurs système qui peuvent être propriétaires des tâches planifiées.',


    'ui__server/crontab__none-available' => 'Vous n\'avez pas de compte utilisateur système.',
    'ui__server/crontab_readonly-unknown__description' => 'Voir les tâches planifiées.',
    'ui__server/crontab_readonly-unknown__short-title' => 'Tâches planifiées',
    'ui__server/crontab_readonly-unknown__title' => 'Voir les tâches planifiées',
    'ui__server/crontab_readonly-unknown__wizard-title' => 'Affichez les tâches planifiées.',
    'ui__server/crontab_readonly__description' => 'Affichez les tâches planifiées de %1.',
    'ui__server/crontab_readonly__short-title' => 'Tâches planifiées de %1.',
    'ui__server/crontab_readonly__title' => 'Affichez les tâches planifiées de %1.',
    'ui__server/crontab_unknown__wizard-title' => 'Gérez les tâches planifiées.',

    'ui__server/crontab/properties__description' => 'Modifiez les tâches planifiées de %1.',

    'ui__server/crontab/properties__short-title' => 'Paramètres',
    'ui__server/crontab/properties__title' => 'Modifiez les tâches planifiées de %1',
    'ui__server/crontab/properties_readonly-unknown__description' => 'Affichez les tâches planifiées.',
    'ui__server/crontab/properties_readonly-unknown__short-title' => 'Paramètres',
    'ui__server/crontab/properties_readonly-unknown__title' => 'Voir les tâches planifiées',
    'ui__server/crontab/properties_readonly-unknown__wizard-title' => 'Affichez les tâches planifiées.',
    'ui__server/crontab/properties_readonly__description' => 'Affichez les tâches planifiées de %1.',
    'ui__server/crontab/properties_readonly__short-title' => 'Paramètres',
    'ui__server/crontab/properties_readonly__title' => 'Voir les tâches planifiées de %1',
    'ui__server/crontab/properties_unknown__description' => 'Modifiez des tâches planifiées.',
    'ui__server/crontab/properties_unknown__short-title' => 'Propriétés',
    'ui__server/crontab/properties_unknown__title' => 'Modifier des tâches planifiées',
    'ui__server/crontab/properties_unknown__wizard-title' => 'Modifiez des tâches planifiées.',
    'ui__server/crontab/properties_unknown__wizard__2_readonly-unknown' => 'Sélectionnez l\'utilisateur système dont vous voulez voir les tâches.',
    'ui__server/crontab/properties_unknown__wizard__2_unknown' => 'Sélectionnez l\'utilisateur système dont vous voulez éditer les tâches.',
    'ui__server/crontab/properties_unknown__wizard__3' => 'Cliquez sur Terminer pour appliquer les changements et pour quitter l\'assistant.',
    'ui__server/crontab/properties_unknown__wizard__3_readonly' => 'Cliquez sur Terminer pour quitter l\'assistant.',

    'ui__server/crontab/task__none-available' => 'Vous n\'avez pas de tâche planifiée.',
    'ui__server/crontab/task__none-available__2' => 'Il n\'y a pas de tâche planifiée pour l\'utilisateur système %1.',
    'ui__server/crontab/task_readonly-unknown__description' => 'Tâches planifiées.',
    'ui__server/crontab/task_readonly-unknown__short-title' => 'Tâches',
    'ui__server/crontab/task_readonly-unknown__title' => 'Tâches planifiées',

    'ui__server/crontab/task/delete__description' => 'Supprimer la tâche planifiée %1',

    'ui__server/crontab/task/delete__short-title' => 'Supprimer',
    'ui__server/crontab/task/delete__title' => 'Supprimer la tâche planifiée %1',
    'ui__server/crontab/task/delete_multi__description' => 'Supprimez les tâches planifiées.',

    'ui__server/crontab/task/delete_multi__short-title' => 'Supprimer',
    'ui__server/crontab/task/delete_multi__title' => 'Supprimer les tâches planifiées',
    'ui__server/crontab/task/delete_multi__wizard-title' => 'Supprimez les tâches planifiées.',
    'ui__server/crontab/task/delete_multi__wizard__2_unknown' => 'Sélectionnez l\'utilisateur système pour lequel vous voulez supprimer des tâches.',
    'ui__server/crontab/task/delete_multi__wizard__3_multi' => 'Sélectionnez les tâches que vous voulez supprimer.',
    'ui__server/crontab/task/delete_multi__wizard__4_multi' => 'Cochez la case pour confirmer la suppression de la tâche et cliquez sur Terminer pour quitter l\'assistant.',
    'ui__server/crontab/task/delete_unknown__description' => 'Supprimez une tâche planifiée.',
    'ui__server/crontab/task/delete_unknown__short-title' => 'Supprimer',
    'ui__server/crontab/task/delete_unknown__title' => 'Supprimer une tâche planifiée',
    'ui__server/crontab/task/delete_unknown__wizard-title' => 'Supprimez une tâche planifiée.',
    'ui__server/crontab/task/delete_unknown__wizard__2_unknown' => 'Sélectionnez l\'utilisateur système pour lequel vous voulez supprimer la tâche.',
    'ui__server/crontab/task/delete_unknown__wizard__3_unknown' => 'Sélectionnez la tâche que vous voulez supprimer.',
    'ui__server/crontab/task/delete_unknown__wizard__4' => 'Cochez la case pour confirmer la suppression de la tâche et cliquez sur Terminer pour quitter l\'assistant.',

    'ui__server/crontab/task/properties__description' => 'Modifiez des tâches planifiées.',

    'ui__server/crontab/task/properties__short-title' => 'Éditer la tâche %1',
    'ui__server/crontab/task/properties__title' => 'Modifier des tâches planifiées',
    'ui__server/crontab/task/properties_new__description' => 'Créez des tâches planifiées pour %1.',

    'ui__server/crontab/task/properties_new__short-title' => 'Ajouter une tâche',
    'ui__server/crontab/task/properties_new__title' => 'Créer des tâches planifiées pour %1',
    'ui__server/crontab/task/properties_new__wizard-title' => 'Créez une tâche planifiée.',
    'ui__server/crontab/task/properties_new__wizard__2_unknown' => 'Sélectionnez l\'utilisateur système pour lequel vous voulez créer une tâche planifiée.',
    'ui__server/crontab/task/properties_new__wizard__4_new' => 'Cliquez sur Terminer pour appliquer les changements et pour quitter l\'assistant.',
    'ui__server/crontab/task/properties_readonly-unknown__description' => 'Affichez les tâches planifiées.',
    'ui__server/crontab/task/properties_readonly-unknown__short-title' => 'Propriétés',
    'ui__server/crontab/task/properties_readonly-unknown__title' => 'Voir les tâches planifiées',
    'ui__server/crontab/task/properties_readonly-unknown__wizard-title' => 'Affichez les tâches planifiées.',
    'ui__server/crontab/task/properties_readonly__description' => 'Affichez les tâches planifiées.',
    'ui__server/crontab/task/properties_readonly__short-title' => 'Voir la tâche %1',
    'ui__server/crontab/task/properties_readonly__title' => 'Affichez les tâches planifiées.',
    'ui__server/crontab/task/properties_unknown-new__description' => 'Créez des tâches planifiées.',
    'ui__server/crontab/task/properties_unknown-new__short-title' => 'Ajouter une tâche',
    'ui__server/crontab/task/properties_unknown-new__title' => 'Créer des tâches planifiées',
    'ui__server/crontab/task/properties_unknown__description' => 'Modifiez des tâches planifiées.',
    'ui__server/crontab/task/properties_unknown__short-title' => 'Propriétés',
    'ui__server/crontab/task/properties_unknown__title' => 'Modifier des tâches planifiées',
    'ui__server/crontab/task/properties_unknown__wizard-title' => 'Modifiez des tâches planifiées.',
    'ui__server/crontab/task/properties_unknown__wizard__2_readonly-unknown' => 'Sélectionnez l\'utilisateur système dont vous voulez voir les tâches.',
    'ui__server/crontab/task/properties_unknown__wizard__2_unknown' => 'Sélectionnez l\'utilisateur système dont vous voulez modifier les tâches.',
    'ui__server/crontab/task/properties_unknown__wizard__3_readonly-unknown' => 'Sélectionnez la tâche planifiée.',
    'ui__server/crontab/task/properties_unknown__wizard__3_unknown' => 'Sélectionnez la tâche planifiée que vous voulez modifier.',
    'ui__server/crontab/task/properties_unknown__wizard__4' => 'Cliquez sur Terminer pour appliquer les changements et pour quitter l\'assistant.',
    'ui__server/crontab/task/properties_unknown__wizard__4_readonly' => 'Cliquez sur Terminer pour quitter l\'assistant.',

    'ui__server/crontab/task/toggle_disable__description' => 'Désactivez la tâche planifiée %1.',

    'ui__server/crontab/task/toggle_disable__short-title' => 'Désactiver',
    'ui__server/crontab/task/toggle_disable__title' => 'Désactiver la tâche planifiée %1',
    'ui__server/crontab/task/toggle_enable__description' => 'Activez la tâche planifiée %1.',

    'ui__server/crontab/task/toggle_enable__short-title' => 'Activer',
    'ui__server/crontab/task/toggle_enable__title' => 'Activer la tâche planifiée %1',
    'ui__server/crontab/task/toggle_unknown__description' => 'Activez ou désactivez des tâches planifiées.',
    'ui__server/crontab/task/toggle_unknown__short-title' => 'Activer ou désactiver',
    'ui__server/crontab/task/toggle_unknown__title' => 'Activer ou désactiver des tâches planifiées',
    'ui__server/crontab/task/toggle_unknown__wizard-title' => 'Activer ou désactiver des tâches planifiées',
    'ui__server/crontab/task/toggle_unknown__wizard__2_unknown' => 'Sélectionnez le compte utilisateur système pour lequel vous voulez activer ou désactiver les tâches.',
    'ui__server/crontab/task/toggle_unknown__wizard__3_unknown' => 'Sélectionnez la tâche que vous voulez activer ou désactiver.',


    /// not used on HP:

    'ui__client_unknown__short-title' => 'Comptes client', // not used on HP?
    'ui__client_unknown__title' => 'Comptes client', // not used on HP?
    'ui__client_unknown__description' => 'Gérez les comptes client.', // not used on HP?
    'ui__client/domain/disable_unknown__title' => 'Suspendre le  domaine', // not used on HP
    'ui__client/domain/disable_unknown__short-title' => 'Suspendre le  domaine', // not used on HP,
    'ui__client/domain/disable_unknown__description' => 'Suspendez un domaine.', // not used on HP
    'ui__client/domain/enable_unknown__title' => 'Activer un domaine', // not used on HP
    'ui__client/domain/enable_unknown__short-title' => 'Activer un domaine', // not used on HP
    'ui__client/domain/enable_unknown__description' => 'Activer un domaine.', // not used on HP

    //Additional FTP Accounts
    'ftp__management_domain' => "Comptes FTP sous le domaine %1", // for Additional FTP Accounts
    '__ftp_users_list' => "Comptes FTP",
    'ftp__user_name' => "Nom du compte FTP",
    'ftp__user_home' => "Répertoire principal",
    'ftp__invalid_path' => "Chemin d'accès indiqué incorrect",
    'i_ftp_ses_sub_user' => 'Session du compte FTP',
    '__new_passwd' => "Nouv. mot de passe %1",

    ////
    //// Errors with custom template of Apache configuration
    ////

    'apacheConfigurationFailedMessageSubject' => 'Impossible de configurer un serveur Web sur l\'hôte <%%host%%>',
    'apacheConfigurationFailedMessageBody' => "Impossible de générer le fichier de configuration du serveur Web sur l'hôte <%%host%%> à cause des erreurs suivantes :\n\n%%error%%\nVeuillez résoudre les erreurs dans les templates de configuration du serveur Web avant de relancer la génération du fichier.",

    'apacheConfigurationMessageAdminTitle' => 'Échec de la génération de la configuration du serveur Web',
    'apacheConfigurationMessageClientTitle' => 'Avertissement',

    'apacheConfigurationFailedAdminHomeMessage' => 'La nouvelle configuration du fichier n\'a pas été créée en raison d\'erreurs dans les templates de configuration. Le message détaillé d\'erreur a été envoyé à votre adresse mail. Veuillez vérifier vos mails, réparer les erreurs et cliquer %1 pour retenter de générer la configuration.',
    'apacheConfigurationFailedAdminHomeMessageLink' => 'ici', //used on linked text in apacheConfigurationFailedAdminHomeMessage
    'apacheConfigurationFailedAdminDomainMessage' =>  'La nouvelle configuration du domaine %1 n\'a pas été créée en raison d\'erreurs dans les templates de configuration. Le message détaillé d\'erreur a été envoyé à votre adresse mail. Veuillez vérifier vos mails, réparer les erreurs et cliquer %2 pour retenter de générer la configuration.',
    'apacheConfigurationFailedAdminDomainMessageLink' => 'ici', //used on linked text in apacheConfigurationFailedAdminDomainMessage

    'apacheConfigurationFailedUserDomainMessage' => 'La configuration du serveur Web pour le domaine %1 peut être incohérente. Veuillez contacter l\'administrateur de serveur pour résoudre ce problème.',

    'apacheConfigurationFailedAdminDomainsMessage' => 'La nouvelle configuration de certains domaines n\'a pas été créée en raison d\'erreurs dans les templates de configuration. Le message détaillé d\'erreur a été envoyé à votre adresse mail. Veuillez vérifier vos mails, réparer les erreurs et cliquer %1 pour retenter de générer la configuration.',
    'apacheConfigurationFailedAdminDomainsMessageLink' => 'ici', //used on linked text in apacheConfigurationFailedAdminDomainsMessage

    'apacheConfigurationFailedUserDomainsMessage' => 'La configuration du serveur Web pour certains de vos domaines risque d\'être incohérente. Veuillez contacter l\'administrateur du serveur pour résoudre ce problème.',



    ///HOSTING PARAMETERS
    '__apache_errdocs' => "Documents d'erreurs personnalisés",
    'dom_pref__webusers_script' => "Autoriser les utilisateurs Web à utiliser les scripts",
    '__seoRedirect' => 'Configurer le domaine préféré en tant que',
    '__seoRedirectToLanding' => 'domain.tld',
    '__seoRedirectToWww' => 'www.domain.tld',
    '__seoRedirectNone' => 'Aucun',

    '__sites' => 'Domaines',
    'domain_plan__perm_denied_manage_phosting' => 'Vous n\'avez pas le droit de gérer les paramètres d\'hébergement.',
    '__owned_by_client' => 'possédé par le client',
    'ui__client/permissions_readonly__description' => "Affichez les actions que le client %1 peut exécuter dans Plesk.",
    'backup__restore__object_client_template' => 'Template du client',
    '__template_name' => 'Nom du pack de services',
    'template__not_exists' => 'Le client n\'est pas abonné à un tel pack de services.',
    'template__exists' => 'Un pack portant le nom %1 existe déjà.',
    'clientOwnerChanger__ip_not_in_pool' => 'L\'adresse IP indiquée n\'est pas dans le pool du revendeur.',

    //// Change owner of subscription
    'chown__select_title' => "Choisir un nouvel abonné",
    'ui__client/domain/chowner_multi__wizard__3_multi-select' => 'Choisissez un nouveau propriétaire pour les abonnements sélectionnés et cliquez sur Suivant >>.',
    'domains__client_info' => "%1 abonnement(s), %2 abonnement(s) actif(s), %3 d'espace disque utilisé, %4 de trafic utilisé",
    '__possible_owners' => 'Potentiels nouveaux propriétaires d\'abonnements',

    'clients_list__filter_owner__filter_title' => 'Fournisseur',
    'clients_list__filter_owner_any' => 'Tous les utilisateurs',
    'clients_list__filter_owner_my' => 'Mes abonnés uniquement',
    'clients_list__filter_owner_name__filter_title' => 'Nom du fournisseur',

    '__owner' => "Fournisseur",
    'l_clientslist_owner' => 'Triez les comptes utilisateur par fournisseur.',
    'l_clientslist_date' => 'Triez les comptes utilisateur par la date de création.',
    'l_clientslist_name' => 'Triez les comptes utilisateur par nom.',
    'l_clientslist_domains' => 'Triez les comptes utilisateur par domaine.',
    'l_clientslist_cname' => 'Triez les comptes utilisateur par nom de société.',

    'ui__client/domain/chowner_multi__wizard-title' => 'Réaffecter les abonnements sélectionnés',
    'chown__check_title' => 'Changer l\'abonné',

    'ui__client/domain/chowner_multi__wizard__3_multi' => "Cliquez sur Terminer pour terminer la réaffectation. Une fois terminé, les abonnements sélectionnés seront affectés à un nouveau propriétaire, leur fournisseur sera remplacé par le fournisseur du nouveau propriétaire et ils seront dissociés de leurs packs de services pour obtenir le statut 'Personnalisé'.",

    'chown__error_check' => 'Certains problèmes se sont produits en essayant d\'affecter certains abonnements à un nouveau propriétaire.',
    'domain_chown_subscription_will_be_anonymous' => "Les abonnements seront dissociés de leurs actuels packs de services et porteront le statut 'Personnalisé'.",
    'chown__error_domains_exclude' => "Certains problèmes se sont produits en essayant d'affecter certains abonnements à un nouveau propriétaire. Ces abonnements sont surlignés.",
    'chown__ip_not_in_client_pool' => "L'adresse IP actuellement associée à cet abonnement n'a pas été ajoutée dans le pool d'adresses IP du nouveau propriétaire.",
    'chown__already_owned_by_client' => "Cet abonnement appartient déjà à cet utilisateur.",

    '__redirect_hint' => 'Vous serez redirigé vers la nouvelle adresse dans 15 secondes... Si vous n\'être pas automatiquement redirigé vers le nouvel emplacement, veuillez activer JavaScript ou cliquer sur l\'hyperlien %%link%%.',

    'backup__restore__object_maillist' => 'Liste de diffusion',
    'backup__restore__object_site' => 'Site',
    'backup__restore__object_user' => 'Utilisateur',
    'backup__restore__object_role' => 'Rôle',

    'limit__name_max_site' => 'Sites',

    'iis_pool__unable_rename_client' => "Impossible de renommer le pool d'applications IIS : %1.",

    'anonftp__is_not_supported_for_addon_domains' => 'Le service FTP anonyme est pris en charge uniquement pour le domaine principal d\'un abonnement.',
    'anonftp__is_not_supported_for_addon_domains_powerUser' => 'Le service FTP anonyme est pris en charge uniquement pour le domaine principal d\'un abonnement.',

    '__gb' => 'Go',
    '__tb' => 'To',
    '__gb_month' => 'Go/mois',
    '__tb_month' => 'To/mois',

    '__customers' => 'Clients',
    '__customer_name' => 'Nom du client',
    '__customer_total' => 'Nombre total de clients',
    '__site' => 'Site',
    '__def_site' => 'Site par défaut',
    '__subscription_name' => 'Nom de l\'abonnement',
    '__subscription_name_powerUser' => 'Nom de l\'abonnement',

    'limit__units_max_traffic_suffix' => '/mois',

    'dom_pref__discard' => "Rejeter",

    'mail__pattern_already_exists' => 'Le modèle "%1" est déjà dans la liste noire.',

    '__not_supported' => 'Non pris en charge',

    'plesk_key__sitebuilder' => 'Sites publiés avec Presence Builder',
    'limit__name_max_site_builder' => 'Sites publiés avec Presence Builder',
    'plesk_key__wpb-multi-language-sites-support' => 'Prise en charge des sites multilingues dans Presence Builder',

    'ui__client/domain/traffic-hosting__title' => 'Statistiques de transfert des données pour <b>%1</b>',
    'ui__client/domain/traffic-hosting__title_powerUser' => 'Statistiques de transfert des données pour <b>%1</b>',
    'ui__client/domain/traffic-hosting#list__title' => "Transfert de données par services",

    'login_up__access_denied_no_subscriptions' => "Accès refusé. Aucun abonnement n'est disponible pour ce compte.",

    'interval__day' => '%1 jour(s)',
    'interval__hour' => '%1 heure(s)',
    'interval__minute' => '%1 minute(s)',
    'interval__second' => '%1 seconde(s)',

    ///License options
    'plesk_key__backward_incompatibility' => 'Vous essayez d\'utiliser une clé de licence créée pour une autre version de Plesk. Contactez les représentants commerciaux de Plesk pour obtenir une clé de licence correcte.',
    //Standalone or virtualization
    'virtualization_any' => "Serveur physique ou toute solution de virtualisation",
    'virtualization_pvc' => "Conteneurs Virtuozzo",
    'virtualization_vmware' => "VMWare",
    'virtualization_hyperv' => "Microsoft Hyper-V",
    'virtualization_xen' => "Xen",
    'virtualization_kvm' => "KVM",
    'virtualization_parallels_server' => "Hyperviseur Virtuozzo",
    'plesk_key__virtualization' => "Valide pour les environnements suivants :",
    'plesk_key__virtualization_only_key' => 'La clé de licence est uniquement destinée à être utilisée avec Plesk dans un environnement virtuel %1.',
    'plesk_key__virtualizations_only_key' => 'La clé de licence est destinée uniquement à être utilisée avec Plesk fonctionnant dans les environnements virtuels suivants : %1.',
    //Language options
    'plesk_key__invalid_locale_signature' => 'L\'utilisation de packs de langues personnalisés est interdite.',
    'plesk_key__allowed-locales' => 'Langues disponibles',
    'plesk_key__allowed-locales-any' => 'Toute langue',

    /// Web hosting settings on domain/subdomain

    '__cgi_bin_mode' => 'le répertoire cgi-bin est situé dans',
    '_cgi_bin_mode_webspace' => 'répertoire root de l\'abonnement',
    '_cgi_bin_mode_www_root' => 'le document root de ce domaine',

    /// Custom buttons
    'custom_button__sort_key' => 'Priorité',
    'custom_button__place' => 'Emplacement',
    'custom_button__place_navigation' => 'Accès commun',
    'custom_button__place_admin' => 'Page d\'accueil de l\'administrateur',
    'custom_button__place_admin-settings' => 'Page Outils & Paramètres de l\'administrateur',
    'custom_button__place_reseller' => "Page d'accueil du revendeur",
    'custom_button__place_reseller-settings' => 'Page Outils & Utilitaires du revendeur',
    'custom_button__place_client' => 'Page d\'accueil du client',
    'custom_button__place_domain' => "Page Sites Web & Domaines de l'abonnement",
    'custom_button__place_domain_powerUser' => "Page Sites Web & Domaines de l'abonnement",
    'custom_button__place_domain-properties' => 'Outils du site Web',
    'custom_button__private' => 'Visible uniquement pour moi',
    'custom_button__image' => 'Image du fond d\'écran',
    'custom_button__conhelp' => "Texte de l'infobulle",
    'custom_button__edit' => "Paramètres d'un lien vers un autre service",
    'custom_button__include_client_cname' => "Inclure le nom de la raison sociale du client",
    'custom_button__include_client_email' => "Inclure l'adresse mail du client",
    'custom_button__include_client_id' => "Inclure l'ID du client",
    'custom_button__include_client_pname' => "Inclure le nom du contact du client",
    'custom_button__include_domain_id' => "Inclure l'ID de l'abonnement, l'ID du domaine et l'ID de l'alias de domaine",
    'custom_button__include_domain_id_powerUser' => "Inclure l'ID de l'abonnement, l'ID du domaine et l'ID de l'alias de domaine",

    'custom_button__include_domain_name' => "Inclure le nom de domaine primaire",
    'custom_button__include_ftp_user' => "Inclure le nom d'utilisateur FTP",
    'custom_button__include_ftp_pass' => "Inclure le mot de passe FTP",
    'custom_button__internal_open' => "Ouvrir l'URL dans Plesk",
    'custom_button__text' => "Intitulé du bouton",
    'custom_button__url' => "URL",

    'custom_button__not_image' => 'Ce fichier n\'est pas un fichier image.',
    'custom_button__big_image' => 'La taille du fichier ne doit pas dépasser 100 Ko.',
    'custom_button__failed_copy_image' => 'Impossible de copier le fichier : %1',


    'backup__restore__cannot_restore_non_power_user_dump_in_power_user_mode' => 'Impossible de restaurer une sauvegarde non Power User dans la Vue Power User.',
    '__unknown_network_interface' => 'Interface réseau inconnue',

    'init_conf__ip_address' => 'Adresse IP',

    //Confirmation page
    'bt_confirm' => 'Confirmer',
    'b_confirm' => 'Confirmez la propriété de vos sites.',

    'performance__iss_app_pool_forced_by_site_isolation' => 'Les paramètres du pool d\'applications IIS dédié sont définis en fonction de la politique de sécurité valable pour l\'ensemble du serveur (configuration de l\'isolation des sites).',
    'performance__iss_app_pool_forced_by_server_wide_settings' => 'Les paramètres du pool d\'applications IIS dédié sont définis en fonction des paramètres de performances valables pour l\'ensemble du serveur.',

    '__current' => 'Actuel',

    //// New Promos Block

    'promo__you_are_about_to_exceed_license_limit_max_dom' => 'Vous avez utilisé quasiment tous les domaines fournis avec votre licence de Plesk (90 % ou plus).',
    'promo__you_are_about_to_exceed_license_limit_max_dom_title' => 'Vous avez utilisé quasiment tous les domaines.',
    'promo__you_are_about_to_exceed_license_limit_max_site_builder' => 'Vous avez utilisé quasiment tous les sites Presence Builder fournis avec votre licence de Plesk (90 % ou plus).',
    'promo__you_are_about_to_exceed_license_limit_max_site_builder_title' => 'Vous avez utilisé presque tous les sites Presence Builder.',
    'promo__button_hide' => 'Masquer',
    'promo__button_next' => 'Suivant >>',
    'promo__button_prev' => '<< Précédent',
    'promo__button_license' => 'Mettre à jour la licence',

    'promo__google_integration_title' => 'Intégration avec les solutions Google',
    'promo__google_integration' => 'Configurez l\'intégration avec les solutions Google, tels que AdSense, Google Apps, outils pour les Webmasters.',
    'promo__google_integration_button' => 'Configuration',

    'promo__button_learn_more' => 'En savoir plus',

    //// Plesk Branding in 10.1
    'panel_branding__description' => 'Vous pouvez personnaliser l\'apparence de l\'interface et les paramètres d\'apparence à l\'aide des thèmes personnalisés. Pour en savoir plus sur la personnalisation des thèmes de Plesk, reportez-vous à %1.',
    'panel_branding__description_link' => 'document suivant',

    ///// File Manager new buttons
    'bt_extract_archive' => 'Extraire les fichiers',
    'filemanager_error_extracting_files' => 'Une erreur s\'est produite en dézippant les fichiers d\'archive : %1',
    'filemanager_no_archive_files_specified' => 'Indiquez les archives que vous voulez extraire.',
    'filemanager_not_zip_archive_specified' => '%1 ne peut pas être extrait, ce n\'est pas une archive ZIP.',
    'filemanager_files_successfully_extracted' => 'Les fichiers d\'archive ont été extraits.',
    'filemanager_error_file_download' => 'Échec du téléchargement du fichier : %1',
    'filemanager__user_poolgrp' => 'Groupe du pool d\'applications',

    'loading' => 'Chargement en cours...',
    'bt_create_archive' => 'Ajouter à l\'archive',
    'filemanager__pack' => "Chemin d'accès vers l'archive : %1",
    'filemanager__archive_name' => 'Nom du fichier d\'archive',
    'filemanager__empty_filename' => 'Veuillez entrer le nom du fichier d\'archive.',
    'filemanager_archive_created' => 'L\'archive a bien été créée.',
    'filemanager_error_creating_archive' => 'Impossible de créer l\'archive : %1',

    'cmd_dns__aaaa_dns_record_already_exist' => "Cet enregistrement entrera en conflit avec l'enregistrement AAAA pour la zone.",
    'defaultcomponents__ftp_ipv6_hosting_not_supported' => "(Le serveur FTP ne prend pas en charge d'adresse IPv6.)",
    'cmd_dns__glue_dns_record_conflict' => 'Cet enregistrement sera en conflit avec le glue record pour la zone \'%1\'.',
    '__ftp_ipv6_not_supported' => "(Le serveur FTP ne prend pas en charge d'adresse IPv6.)",
    '__ipv6_not_supported' => 'IPv6 n\'est pas pris en charge.',
    'mail__ipv6_not_supported' => 'IPv6 n\'est pas pris en charge par le serveur de messagerie.',
    'mail__relay_while_list_ipv6_not_supported' => 'La liste blanche de relais IPv6 n\'est pas prise en charge par le serveur de messagerie.',
    'mail__relay_while_list_ipv6_mask_mul_16' => 'La valeur du masque doit être un multiple de 16.',
    'mail__ip_or_mask_is_invalid' => 'L\'adresse IP ou masque est incorrect.',
    'nonexistent_mail__redirect_ipv6_not_supported' => 'La redirection vers les adresses IP IPv6 n\'est pas prise en charge.',
    'sa__invalid_trusted_networks' => 'Les réseaux de confiance indiqués sont incorrects : %1',
    'dns_add__enter_ipv6_address' => "Adresse IPv6",
    'license_trial_days_left' => 'Votre version de Plesk fonctionne avec une licence de test qui expirera dans %1 jours.',
    'excl_ipv6_num' => 'Adresse IPv6 dédiée',
    '__ip_mask' => "Masque de sous-réseau",
    '__ipv4_addr' => 'Adresse IPv4',
    '__ipv6_addr' => 'Adresse IPv6',
    'template__num_excl_ipv6s' => 'Affectez des adresses IPv6 dédiées au revendeur.',
    'anonftp__exclusive_ipv4_required' => 'Une adresse IPv4 dédiée est nécessaire pour configurer et utiliser un service FTP anonyme.',
    'anonftp__ipv4_already_used' => 'Vous ne pouvez pas configurer de service FTP anonyme pour ce site, car il est déjà configuré sur un autre domaine sur la même adresse IPv4.',


    'restart__kav' => "Antivirus Kaspersky",
    '__view_migration_log_detailed_info' => 'Voir le journal',

    'chown__ip_address_warn' => 'Avant de migrer l\'abonnement vers le nouveau propriétaire, vous devez sélectionner une nouvelle adresse IP pour cet abonnement.',
    'chown__no_ip_address' => 'Aucun',
    'chown__no_ipv4_address' => 'Aucune adresse IPv4',
    'chown__no_ipv6_address' => 'Aucune adresse IPv6',
    'chown__domain_exclude_already_owned_by_client' => 'L\'abonnement %1 appartient déjà à cet utilisateur.',
    'chown__error_ip_absent_in_ip_pool' => 'L\'adresse IP %1 est absente du pool d\'adresses IP de l\'utilisateur cible.',
    'chown__error_ip_not_exist' => 'L\'adresse IP portant l\'ID \'%1\' n\'existe pas.',
    'chown__error_domain_ip_not_selected' => 'Au moins une adresse IP pour le domaine %1 doit être sélectionnée. Vérifiez les valeurs sélectionnées pour le mappage de l\'adresse IP.',

    'mail__ip_or_mask_is_invalid_ipv6' => 'L\'adresse IPv6 ou le masque est incorrect : l\'adresse IP doit être une adresse unicast correcte.',

    '__subscriptions' => 'Abonnements',

    '__owned_by_reseller' => 'détenu par le revendeur',
    '__owned_by_provider' => 'détenu par le fournisseur',

    'service_plan__anonymous' => 'Personnalisé',
    'subscription_not_locked__change_limits_warning' => 'Cet abonnement n\'est pas verrouillé : les limites d\'utilisation des ressources seront changées lors de la synchronisation avec le pack de services.',
    'subscription_not_locked__change_permissions_warning' => 'Cet abonnement n\'est pas verrouillé : les droits seront changés lors de la synchronisation avec le pack de services.',

    'subscription__conflict_resolution_policy' => 'Politique de résolution des conflits',
    'subscription__conflict_resolution_policy_lock' => "Verrouiller l'abonnement",

    'backup__list__backup_warnings' => 'Avertissements',
    'backup__list__backup_info' => 'Informations',
    'backup__restore__object_reseller_template' => 'Template de revendeur',
    'backup__restore__object_domain_template' => 'Template de domaine',

    'ui__client/permissions_readonly__title' => 'Droits',
    'ui__client/permissions_readonly__short-title' => 'Droits',

    'subscription__unable_lock_anonymous' => 'Cet abonnement n\'est pas associé à un pack de services. Il ne peut donc pas être déverrouillé.',
    'subscription__unable_sync_anonymous' => 'Cet abonnement n\'est pas associé à un pack de services. Il ne peut donc pas être synchronisé.',
    'subscription__unable_sync_locked' => 'Cet abonnement est verrouillé. Il ne peut donc pas être synchronisé.',
    'subscription__locked' => 'L\'abonnement est verrouillé.',
    'component_name__urlrewrite' => "Réécriture de l'URL",
    '__quantity' => 'Quantité',
    'hst__www_root_dir_absent' =>  'Avertissement : le répertoire indiqué comme root du document n\'existe pas.',
    'object_creation__domain_is_not_a_webspace' => 'Cet objet peut être créé uniquement dans un abonnement.',
    'phosting__webspace_hosting_with_sites_cannot_be_deleted' => 'L\'abonnement Web contient des sites, c\'est pourquoi vous ne pouvez pas changer le type d\'hébergement ou le supprimer.',
    'phosting__apache_error_docs_are_not_enabled' => 'Les documents d\'erreurs personnalisés ne sont pas activés sur le domaine.',
    'phosting__addon_domain_ip_must_match_webspace' => 'Erreur : échec de la mise à jour de l\'adresse IP. Impossible d\'affecter aux domaines compagnons une adresse IP non affectée au domaine principal de l\'abonnement.',
    'domain_plan__unable_change' => 'Impossible de changer le pack de service : %1.',
    'domain_plan__different_hosting_type' => 'Le type d\'hébergement actuel est différent de celui indiqué dans le pack de services.',
    'domain_plan__addon_text' => 'Pack d\'add-ons',
    'domain_plan__addon_description' => 'Le pack d\'add-ons est utilisé en supplément d\'un pack d\'hébergement.',
    'asp_net__managed_runtime_version' => 'Version runtime gérée ASP.NET',
    'plan__can_not_change_hosting_type' => 'Impossible de changer le type d\'hébergement en éditant un pack.',
    'plan__apply_problems' => 'Pack non appliqué à cause de problèmes avec la fonctionnalité suivante : %1',
    'plan_save__subscription_update_problem' => 'Impossible d\'appliquer les changements des packs dans %1.',
    '__perm_denied_subscription_suspended_by_backuprestore' => "L'abonnement est temporairement suspendu jusqu'à la fin des procédures de sauvegarde et de restauration. Veuillez revenir ultérieurement.",
    '__login_incorrect_plain_shadow_password' => 'Vous avez indiqué un mot de passe incorrect pour le compte administrateur. Veuillez utiliser les identifiants (root) de l\'administrateur système ou obtenez le mot de passe correct. Pour en savoir plus sur l\'obtention du mot de passe, lisez le fichier /etc/psa/README.psa.shadow.',

    '__perm_denied_ip' => 'Vous ne pouvez pas envoyer l\'adresse IP dont vous n\'êtes pas propriétaire.',

    'dns__dns_zone_not_synchronized' => 'La zone DNS a été changée. Si vous souhaitez appliquer les changements du template DNS sur cette zone, cliquez sur le bouton \'Appliquer les changements du template DNS\' sur cette page ou choisissez l\'option \'Appliquer les changements dans toutes les zones\' dans le Panneau d\'administration du serveur, sous Outils & Paramètres > Paramètres du template DNS > Appliquer les modifications du template DNS.',
    'dns__dns_zone_synchronize_link' => 'Cliquer',
    'dns__dns_zone_synchronize_done' => 'La zone DNS a bien été synchronisée.',

    'dns__dns_zone_template_error' => 'Des problèmes se sont produits lors de la synchronisation des zones DNS avec le template de zone DNS.%1',

    'dns__soa_rname_type_owner' => 'Adresse mail du propriétaire du site Web',
    'dns__soa_rname_type_domain' => 'Adresse mail pour le domaine',
    'dns__soa_rname_type_external' => 'Adresse mail externe',
    'dns__soa_rname_enforce_email' => 'Interdire la modification de l\'adresse mail RNAME sur une base par domaine',
    'dns__soa_rname_label' => 'E-mail (RNAME)',
    'dns__soa_rname_hint' => 'Adresse mail de la personne responsable de la zone DNS du domaine. Réponse du serveur DNS en réponse aux requêtes SOA.',

    'dns__dns_zone_soa_sync_title' => 'Remplacer les paramètres SOA de tous les domaines existants',
    'dns__dns_zone_soa_sync_legend' => 'Confirmation requise',
    'dns__dns_zone_soa_sync_text' => 'Mettre à jour les entrées SOA de tous les domaines hébergés en appliquant les modifications faites sur le template SOA ?',

    'cu_db__repair_mysql_dbus' => "Réparez les mots de passe utilisateur MariaDB/MySQL. Cette opération est nécessaire si vous avez mis à niveau vers Plesk 11 depuis toute version antérieure.",

    'cu_scheduled_backup_comment' => 'Sauvegarde planifiée',
    'cu_scheduled_backup_error' => 'Une erreur s\'est produite pendant le processus de sauvegarde : %1',
    'cu_scheduled_backup_mail_subject' => '<%1> Une erreur s\'est produite pendant la sauvegarde planifiée.',
    'cu_scheduled_backup_mail_message' => "%1\nPoint d'entrée de Plesk : %2\n\nLes erreurs suivantes se sont produites pendant le processus de sauvegarde planifiée :\n\n%3",

    'cu_scheduled_backup_hourly' => 'Sauvegarde horaire',
    'cu_scheduled_backup_daily' => 'Sauvegarde quotidienne',
    'cu_scheduled_backup_weekly' => 'Sauvegarde hebdomadaire',
    'cu_scheduled_backup_monthly' => 'Sauvegarde mensuelle',
    'cu_scheduled_backup_comment_backup_all' => '%1. Intégralité de la configuration et du contenu.',
    'cu_scheduled_backup_comment_backup_vhost' => '%1. Intégralité de la configuration et du contenu sauf les e-mails.',
    'cu_scheduled_backup_comment_backup_mail' => '%1. Uniquement la configuration et les e-mails.',
    'cu_scheduled_backup_comment_backup_mail_file' => '%1. Intégralité de la configuration et du contenu, sauf les bases de données utilisateur.',
    'cu_scheduled_backup_comment_backup_mail_database' => '%1 Intégralité de la configuration et du contenu, sauf les fichiers utilisateur.',
    'cu_scheduled_backup_comment_backup_database' => '%1. Uniquement la configuration et les bases de données utilisateur.',
    'cu_scheduled_backup_comment_backup_file' => '%1. Uniquement la configuration et les fichiers utilisateur.',
    'cu_scheduled_backup_comment_backup_domain' => '%1. Configuration du domaine.',

    'cu_scheduled_backup_to_cloud_not_allowed' => 'Le stockage des sauvegardes planifiées dans un stockage cloud distant est une fonctionnalité premium. Contactez votre hébergeur pour la déverrouiller.',

    'i_backup_invalid_file' => 'Cette sauvegarde n\'est pas valide.Impossible de restaurer les données à partir de ce fichier. Cliquez sur le nom de la sauvegarde pour en savoir plus.',

    'ui__server/migration/download-agent__short-title' => 'Télécharger l\'Agent de transfert & de migration',
    'ui__server/migration/download-agent__title' => 'Télécharger l\'Agent de transfert & de migration',
    'ui__server/migration/download-agent__description' => 'Téléchargez la toute dernière version de l\'Agent de transfert & de migration à partir du site Web de Plesk.',

    'filemanager_resulting_archive_exists' => 'Le fichier %1 existe déjà dans le répertoire cible.',

    'agent_unable_to_connect' => 'Impossible de se connecter à l\'agent via \'%2\'. Veuillez vous assurer, d\'une part, que l\'agent est installé et fonctionne correctement et, d\'autre part, qu\'il n\'y a aucun problème de connexion avec l\'hôte \'%2\'.',
    'agent_test_connection_failed' => 'Échec de connexion à l\'agent via \'%2\'.',

    'agent_unable_to_resolve_host' => 'Impossible de localiser l\'hôte distant \'%1\'. Veuillez vous assurer qu\'il n\'y a aucun problème de connexion avec l\'hôte.',
    'agent_unknown_curl_error' => 'L\'erreur \'%1\' s\'est produite lors de la connexion à l\'agent via \'%2\'.',
    'agent_unexpected_htp_code' => 'Le code HTTP inattendu \'%1\' a été reçu pour la requête HTTP émise à l\'agent via \'%2\'.',
    'agent_unable_to_auth' => 'Authentification impossible via l\'hôte \'%1\'. Pour résoudre ce problème, suivez les instructions indiquées dans l\'article http://kb.plesk.com/116606.',
    'agent_internal_server_error' => 'Une erreur interne est survenue lors de l\'exécution de la commande sur l\'hôte distant \'%1\'.',
    'agent_response_is_empty' => 'Une réponse vide a été reçue pour la requête HTTP émise à l\'agent via \'%1\'.',

    'migration__disabled_due_to_local_file_does_not_exist' => 'Impossible de trouver l\'Agent de transfert & de migration dans le cache local.Veuillez réouvrir le Gestionnaire de transfert & de migration pour régler le problème.',

    '__hosting_webdeploy' => "Publication Web Deploy",
    'cu_domain__webdeploy' => "Publication Web Deploy (par défaut : %1)",
    'cu_dom_tpl__webdeploy' => "Publication Web Deploy (par défaut : %1)",
    'cu_subdomain__webdeploy' => "Publication Web Deploy (par défaut : %1)",
    'webdeploy__not_installed' => "Microsoft Web Deploy n'est pas installé sur le serveur",
    'webdeploy__forced_by_site_isolation' => "Impossible de changer les paramètres de publication de Web Deploy : vous n'avez pas le droit d'outrepasser la politique sécuritaire du serveur. Contactez votre fournisseur pour en savoir plus.",



    'backup__restore_options__admin__server_configuration_license' => 'Clé de licence',
    'migration_start_migrate_server_license' => 'Transférer la clé de licence',

    'defaultcomponents__delegation_rule_not_exist' => '(la règle de délégation requise \'appPoolPipeline, appPoolNetFx\' n\'existe pas)',

    '__o' => 'P',

    'i_backup_created_by_admin' => 'La sauvegarde a été créée par l\'administrateur.',
    'i_backup_created_by_reseller' => 'La sauvegarde a été créée par un revendeur.',
    'i_backup_created_by_client' => 'La sauvegarde a été créée par un client.',

    'migration__object_exists_on_target_host' => '(existe déjà sur l\'hôte cible)',

    '__customers_total' => 'Total par client',
    '__resellers_total' => 'Total par revendeur',
    '__reseller_total' => 'Total de revendeurs',


    'cu_cl_pref__manage_website_maintenance' => 'Accès aux opérations avancées : copie du site Web',
    'cu_cl_pref__manage_protected_dirs' => 'Gestion des répertoires protégés par un mot de passe',
    'cu_cl_pref__manage_mail_settings' => 'Modification des paramètres de la messagerie',


    'cu__command_update_php_settings' => 'Met à jour les paramètres PHP.',
    'cu__php_settings_option' => 'Définit le chemin d\'accès vers le fichier avec des paramètres PHP.',

    'cu__additional_php_settings_option' => 'Définit le chemin d\'accès vers le fichier avec d\'autres directives PHP.',
    'cu__command_show_php_settings' => 'Affiche les paramètres PHP actuels.',
    'cu__general_settings' => 'Paramètres généraux :',
    'cu__performance_settings' => 'Paramètres des performances :',
    'cu__php_fpm_settings' => 'Paramètres PHP-FPM :',
    'cu__additional_directives' => 'Directives supplémentaires :',

    'php_settings_permission_required' => 'Gestion des paramètres PHP communs',
    'php_settings_performance_permission_required' => 'Gestion des paramètres de performances de l\'hébergement',
    'php_settings_customized' => 'Les paramètres PHP ont été personnalisés.',
    'php_settings_synchronized_with_plan' => 'Les paramètres PHP doivent être synchronisés avec le pack.',
    'phosting__unknown_shell_type' => 'Shell non disponible',

    'login_up__access_denied_subscription_deleted' => 'Accès refusé : Votre abonnement a été supprimé.',

    'role_restricted_to_subscription' => '(transféré avec l\'abonnement : %1)',

    'filemanager__extract' => "Extraire les fichiers vers : %1",

    'cu__license_command_check_installed_license' => 'Vérifier la validité de la clé de licence installée (renvoie le code de sortie 0 si la clé est valide et 1 si la clé est invalide)',

    'promo__mobile_manager_title' => 'Plesk Server Manager',
    'promo__mobile_manager' => "Étendez la fonctionnalité de Plesk pour pouvoir contrôler et surveiller le serveur à partir des périphériques mobiles (BlackBerry, iPhone et Android).",
    'promo__mobile_monitor_title' => 'Plesk Server Monitor',
    'promo__mobile_monitor' => 'Obtenez à tout moment les informations les plus importantes sur les serveurs de Plesk à partir d\'un périphérique mobile (BlackBerry, iPhone et Android).',
    'promo__mobile_button' => 'En savoir plus',

    'ui__server/migration/video__short-title' => 'Tutoriels vidéo',
    'ui__server/migration/video__title' => 'Regarder les tutoriels vidéo',
    'ui__server/migration/video__description' => 'Regardez les tutoriels vidéo.',

    'subDomainNameHint' => 'Entrez * en tant que nom de sous-domaine pour créer un sous-domaine wildcard. Les visiteurs du site seront redirigés vers ce sous-domaine, peu importe le nom du sous-domaine qu\'ils entreront dans un navigateur.',
    'subdomains__wildcard_name_invalid' => "Le nom du sous-domaine est incorrect. Vous ne pouvez utiliser que des caractères alphanumériques, qu'un tiret (-), et qu'un astérisque (*) pour les noms de sous-domaines wildcard.",
    'subdomains__name_invalid' => "Le nom du sous-domaine est incorrect. Vous ne pouvez utiliser que des caractères alphanumériques et qu'un tiret (-) pour les noms de sous-domaines.",

    'domain__wildcard_no_www_prefix' => 'Impossible d\'utiliser le préfixe www pour les sous-domaines Wildcard.',

    '__service_title__milter' => "Plesk Postfix milter",
    '__service_description__milter' => "Filtre de la messagerie de Plesk Postfix",
    '__milter' => "Milter de Postfix",
    'restart__milter' => "Milter de Plesk (%1)",
    'restart__pop3' => "Serveur Courier POP 3",
    'restart__pop3s' => "Serveur Courier POP3 avec prise en charge SSL/TLS",
    'restart__imap' => "Serveur Courier IMAP",
    'restart__imaps' => "Serveur Courier IMAP avec prise en charge SSL/TLS",
    'restart__authdaemon' => "Démon d'authentification du Courier IMAP",
    'restart__imap-pop3' => "Serveur Dovecot IMAP et POP3",


    'addon_packages_not_supported' => 'Les add-ons pour les applications Web packagées au format APS ne sont pas pris en charge.',
    'cu_domain__unable_to_automaticaly_select_ip' => 'Impossible d\'affecter automatiquement une adresse IP au domaine. Veuillez indiquer une adresse IP à l\'aide de l\'option -ip.',

    'plesk_key__mb_accounts' => 'Comptes utilisateur (revendeurs et clients) dans le Customer & Business Manager',

    'actionlog__subdomain_dns' => 'Zone DNS du sous-domaine',
    'actionlog__site_subdomain_dns' => 'Zone DNS d\'un sous-domaine sous un autre domaine',

    // PfW only
    'actionlog__event_site_create' => 'Domaine créé',
    'actionlog__event_site_delete' => 'Domaine supprimé',
    'actionlog__event_site_update' => 'Domaine mis à jour',

    'actionlog__event_site_status_update' => 'Statut du domaine mis à jour',
    'actionlog__event_site_dns_update' => 'Zone DNS du domaine mise à jour',
    'actionlog__event_site_guid_update' => 'GUID du domaine mis à jour',

    'actionlog__event_site_subdomain_create' => 'Sous-domaine créé',
    'actionlog__event_site_subdomain_delete' => 'Sous-domaine supprimé',
    'actionlog__event_site_subdomain_update' => 'Sous-domaine mis à jour',

    'actionlog__event_site_alias_create' => 'Alias de domaine créé',
    'actionlog__event_site_alias_delete' => 'Alias de domaine supprimé',
    'actionlog__event_site_alias_update' => 'Alias de domaine mis à jour',

    'actionlog__event_site_alias_dns_update' => 'Zone DNS d\'un alias de domaine mise à jour',
    'actionlog__event_subdomain_dns_update' => 'Zone DNS d\'un sous-domaine sous le domaine par défaut mise à jour',
    'actionlog__event_site_subdomain_dns_update' => 'Zone DNS d\'un sous-domaine mise à jour',
    // End of PfW only

    'win_policy__bad_password' => 'Échec de la validation. Mot de passe incorrect.',
    'win_policy__password_too_short' => 'Échec de la validation. Le mot de passe n\'est pas conforme aux critères de la politique des mots de passe, car il est trop court.',
    'win_policy__password_too_long' => 'Échec de la validation. Le mot de passe n\'est pas conforme aux critères de la politique des mots de passe, car il est trop long.',
    'win_policy__password_not_complex_enough' => 'Échec de la validation. Votre mot de passe n\'est pas assez complexe et n\'est pas conforme à la politique du serveur. Pour avoir un mot de passe fort, celui-ci doit comporter au moins : huit caractères, dont un caractère minuscule et un caractère majuscule, trois chiffres et un caractère spécial (!, @, #, $, %, ^, &, *, ?, _, ~) ou un chiffre et deux caractères spéciaux.',

    //// Activation Code feature
    'plesk_key__license_update_failed' => 'Impossible de mettre à jour licence du produit.',


    'filemanager__error_path_is_not_allowed' => 'Chemin d\'accès interdit',
    'filemanager__error_path_is_invalid' => 'Chemin d\'accès incorrect',
    'filemanager__error_path_not_found' => 'Chemin d\'accès introuvable',
    'filemanager__error_path_already_exists' => 'Chemin d\'accès déjà existant',
    'filemanager__error_access_is_denied' => 'Accès refusé',
    'filemanager__error_directory_not_empty' => 'Le dossier n\'est pas vide.',
    'filemanager__error_sharing_violation' => 'Violation de partage',
    'filemanager__error_not_same_device' => 'Le chemin de destination n\'est pas sur le même appareil',
    'filemanager__unable_to_resolve_realpath' => "Le fichier %1 n'a pas été trouvé à l'endroit indiqué.",
    'filemanager__access_to_realpath_denied' => "Accès au realpath refusé : %1 vers %2.",
    'bt_exit' => 'Quitter',

    'filemanager__copy_error__' => "Impossible de copier %1 vers %2: %3",
    'filemanager__copy_move' => "Copier(déplacer) les fichiers de %1",
    'filemanager__count_size__' => 'Taille de la sélection : %1',
    'filemanager__count_size_error__' => 'Impossible de calculer la taille pour %1 : %2',
    'filemanager__create_dir_error__' => "Impossible de créer le répertoire %1: %2",
    'filemanager__dir_not_exists' => "Le répertoire %1 n'existe pas.",
    'filemanager__dirname' => "Nom du répertoire",
    'filemanager__filename' => "Nom du fichier",
    'filemanager__is_no_such' => "Il n'y a pas de fichier ou de répertoire avec ce nom : %1",
    'filemanager__empty_selection' => "Aucun fichier sélectionné.",
    'filemanager__move_error__' => "Impossible de déplacer %1 vers %2: %3",
    'filemanager__not_allowed' => "Vous n'êtes pas autorisé à modifier les droits de ce fichier.",
    'filemanager__remove' => "Supprimer le fichier de %1",
    'filemanager__remove_error__' => "Impossible de supprimer le fichier %1: %2",
    'filemanager__set_win_permissions_dir' => "Définir les droits pour le dossier %1",
    'filemanager__set_win_permissions_file' => "Définir les droits pour le fichier %1",
    'filemanager__touch_confirm' => "Êtes-vous sûr de vouloir changer l'horodatage des fichiers sélectionnés ?",
    'filemanager__upload_error__' => "Impossible d'envoyer %1 vers %2: %3",
    'filemanager__upload_file' => "Envoyer un fichier",
    'filemanager__upload_file_src' => "Chemin d'accès au fichier",
    'filemanager__max_image_size_exceeded' => 'Impossible d\'afficher l\'image. La taille de l\'image ne peut pas être supérieure à %2 octets.',

    '__fastcgi_unix_support' => 'Prise en charge FastCGI',

    'dns__subdomain_dns_zone_parent' => 'Les enregistrements DNS de ce sous-domaine sont stockés dans la zone DNS parente. Vous pouvez modifier la zone parente %1 ou créer une zone séparée pour le sous-domaine.',
    'dns__subdomain_dns_zone_parent_link' => 'ici',
    'dns__no_dns_zone' => 'Aucune zone DNS affectée avec ce domaine. Pour gérer les zones DNS pour votre domaine, vous devez cliquer sur le bouton \'Restaurer les paramètres par défaut\'.',
    'dns__unable_turn_on_subdomain_zone' => 'Impossible d\'activer la zone du sous-domaine, car un enregistrement CNAME pour ce sous-domaine se trouve dans la zone du domaine de son parent.',

    '__hosting_write_modify' => 'Autres droits d\'écriture et de modification',

    'aspdotnet__group_framework_version' => "Version du Framework",

    'bt_restore_default' => "Paramètres par défaut",
    'b_autoinstaller' => 'Mettez à jour Plesk ou ses composants.',
    'b_autoinstaller_configure' => 'Paramètres de mise à jour.',
    'b_autoinstaller_install' => 'Installez les composants sélectionnés.',

    '__iis_app_pool__use_dedicated' => 'Pool d\'applications IIS dédié',
    '__iis_app_pool__use_dedicated_addons' => 'Pool d\'applications IIS dédié pour chaque site Web',
    '__iis_app_pool__enable_32bit_app_on_win64' => 'Activer les applications 32 bits',
    '__iis_app_pool__load_user_profile' => 'Charger le profil utilisateur',
    'bt_iis_app_pool' => "Pool d'applications IIS",

    'performance__cpu_usage' => 'Utilisation maximum du CPU (%)',
    'performance__cpu_usage_action' => 'Limiter l\'action',
    'performance__cpu_usage_interval' => 'Intervalle limite (minutes)',
    'performance__cpu_usage_action_not_supported' => 'L\'action indiquée n\'est pas prise en charge par le serveur Web.',

    'performance__idle_timeout_action_not_supported' => 'L\'action indiquée en cas de délai d\'inactivité n\'est pas prise en charge par le serveur Web.',
    'performance__max_worker_processes' => 'Nombre maximum de processus de travail',
    'performance__idle_timeout' => 'Délai d\'inactivité (minutes)',
    'performance__idle_timeout_action' => 'Action en cas de délai d\'inactivité',
    'performance__recycling_by_time' => 'Recyclage à intervalle régulier (minutes)',
    'performance__recycling_by_requests' => 'Recyclage lorsque le nombre maximum de requêtes est atteint',
    'performance__recycling_by_virtual_memory' => 'Recyclage lorsque le volume maximum de mémoire virtuelle est utilisé',
    'performance__recycling_by_private_memory' => 'Recyclage lorsque le volume maximum de mémoire privée est utilisé',
    'performance__managed_pipeline_mode' => 'Mode pipeline géré',
    'performance__managed_pipeline_mode_not_supported' => 'Le mode indiqué n\'est pas pris en charge par le serveur Web.',

    'iis_app_pool' => 'Gestion du pool d\'applications IIS.',
    'b_iis_app_pool' => 'Gérer le pool d\'applications IIS.',
    'iis_app_pool_cl_dom' => 'Gestion du pool d\'applications IIS.',

    'bt_protect' => 'Protéger',
    'bt_unprotect' => 'Supprimer la protection',
    'bt_show_additional_users' => 'Afficher plus d\'utilisateurs',
    'bt_hide_additional_users' => 'Afficher moins d\'utilisateurs',
    'error_doc__code_400' => 'Mauvaise requête',
    'error_doc__code_401' => 'Non autorisé',
    'error_doc__code_401.1' => 'Pas autorisé - Échec de connexion',
    'error_doc__code_401.2' => 'Pas autorisé - Échec de connexion à cause de la configuration du serveur',
    'error_doc__code_401.3' => 'Pas autorisé - Pas autorisé du fait de l\'ACL sur la ressource',
    'error_doc__code_401.4' => 'Pas autorisé - Autorisation rejetée par le filtre',
    'error_doc__code_401.5' => 'Pas autorisé - Autorisation rejetée par ISAPI/CGI',
    'error_doc__code_401.7' => 'Non autorisé - Refus en raison de la politique d\'autorisation de l\'URL',
    'error_doc__code_403' => 'Interdit',
    'error_doc__code_403.1' => 'Interdit - Accès en exécution refusé',
    'error_doc__code_403.2' => 'Interdit - Accès en lecture refusé',
    'error_doc__code_403.3' => 'Interdit - Accès en écriture refusé',
    'error_doc__code_403.4' => 'Interdit - SSL requis',
    'error_doc__code_403.5' => 'Interdit - SSL 128 requis',
    'error_doc__code_403.6' => 'Interdit - Adresse IP rejetée',
    'error_doc__code_403.7' => 'Interdit - Certificat client requis',
    'error_doc__code_403.8' => 'Interdit - Accès au site refusé',
    'error_doc__code_403.9' => 'Interdit - Trop d\'utilisateurs',
    'error_doc__code_403.10' => 'Interdit - Configuration incorrecte',
    'error_doc__code_403.11' => 'Interdit - Changement du mot de passe',
    'error_doc__code_403.12' => 'Interdit - Accès mappage refusé',
    'error_doc__code_403.13' => 'Interdit - Certificat client révoqué',
    'error_doc__code_403.14' => 'Interdit - Listing répertoires refusé',
    'error_doc__code_403.15' => 'Interdit - Licences d\'accès client dépassées',
    'error_doc__code_403.16' => 'Interdit - Certificat du client non fiable ou défectueux',
    'error_doc__code_403.17' => 'Interdit - Le certificat du client a expiré ou n\'est pas encore valable',
    'error_doc__code_403.18' => 'Interdit - Impossible d\'exécuter la requête à partir de ce pool d\'applications',
    'error_doc__code_403.19' => 'Interdit - Accès CGI refusé',
    'error_doc__code_403.20' => 'Interdit - Échec de connexion à Passport',
    'error_doc__code_404' => 'Impossible à trouver',
    'error_doc__code_404.2' => 'Impossible à trouver- Refus en raison de la politique de verrouillage',
    'error_doc__code_404.3' => 'Impossible à trouver- Refus en raison de la politique MIMEMAP',
    'error_doc__code_405' => 'Méthode non autorisée',
    'error_doc__code_406' => 'Non acceptable',
    'error_doc__code_407' => 'Authentification du proxy requise',
    'error_doc__code_408' => 'Délai de requête dépassé',
    'error_doc__code_412' => 'Échec de la pré-condition',
    'error_doc__code_414' => 'URI de la requête trop longue',
    'error_doc__code_415' => 'Type de média non pris en charge.',
    'error_doc__code_431' => 'Champs d\'en-tête de requête trop volumineux',
    'error_doc__code_500' => 'Erreur serveur interne.',
    'error_doc__code_500.12' => 'Erreur serveur interne - Redémarrage de l\'application',
    'error_doc__code_500.13' => 'Erreur serveur interne - Serveur trop occupé',
    'error_doc__code_500.15' => 'Erreur serveur interne - Requêtes directes pour GLOBAL.ASA interdites',
    'error_doc__code_500.16' => 'Erreur serveur interne - Erreur accès UNC',
    'error_doc__code_500.17' => 'Erreur serveur interne - Impossible de trouver l\'autorisation URL pour la boutique',
    'error_doc__code_500.18' => 'Erreur serveur interne - Impossible d\'ouvrir l\'autorisation URL pour la boutique',
    'error_doc__code_500.19' => 'Erreur serveur interne - Méta-données du fichier incorrectes',
    'error_doc__code_500.100' => 'Erreur serveur interne - Erreur ASP',
    'error_doc__code_501' => 'Non implémenté',
    'error_doc__code_502' => 'Passerelle incorrecte',
    'error_doc__code_503' => 'Service temporairement indisponible',

    'mimetype_edit__already_exists' => 'Le type MIME est déjà défini pour cette extension.',
    'mimetype_edit__not_exists' => 'Le type MIME n\'existe pas.',

    'php__group_php_version' => "Version de PHP",

    'virtualdir__path' => 'Chemin d\'accès',
    'virtualdir__read' => 'Droit de lecture',
    'virtualdir__read_short' => 'Applications récurrentes',
    'virtualdir__write' => 'Droit d\'écriture',
    'virtualdir__write_short' => 'É',
    'virtualdir__source' => 'Accès aux sources du script',
    'virtualdir__source_short' => 'S',
    'virtualdir__browse' => 'Exploration des répertoires',
    'virtualdir__browse_short' => 'o',
    'virtualdir__script_execute' => 'Droits d\'exécution',
    'virtualdir__script_execute_short' => 'E',
    'virtualdir__log_visits' => 'Loguer les visites',
    'virtualdir__app_create' => 'Créer une application',
    'virtualdir__app_create_short' => 'A',
    'virtualdir__auth_anon' => 'Active l\'authentification anonyme',
    'virtualdir__auth_windows' => 'Active l\'authentification Windows',
    'virtualdir__auth_not_enabled' => 'L\'authentification Anonyme ou Windows doit être activée.',
    'virtualdir__require_ssl' => 'Exiger SSL/TLS',
    'virtualdir__enable_default_doc' => 'Utiliser les documents par défaut',
    'virtualdir__default_doc' => 'Ordre de recherche des documents par défaut',
    'virtualdir__enable_parent_paths' => 'Autoriser l\'utilisation de chemins d\'accès parents',
    'virtualdir__execute_in_mta' => 'Autoriser l\'exécution de l\'application en mode MTA (multi-threaded apartment)',
    'virtualdir_create__title' => 'Créer un répertoire virtuel dans %1',
    'virtualdir_edit__title' => 'Propriétés du répertoire virtuel %1',
    'virtualdir_edit__legend' => 'Répertoire virtuel',
    'virtualdir_edit__application_legend' => 'Paramètres de l\'application',
    'virtualdir_edit__security_legend' => 'Sécurité du répertoire',
    'virtualdir_edit__documents_legend' => 'Documents',
    'virtualdir_edit__list_legend' => 'Répertoires virtuels imbriqués',
    'virtualdir_error__path_not_in__' => 'Chemin d\'accès indiqué incorrect',
    'virtualdir_root' => 'Répertoires virtuels',
    'virtualdir_root__title' => 'Répertoires virtuels',
    'virtualdir_root__list_legend' => 'Répertoires virtuels',
    'virtualdir_se__none' => 'Aucun',
    'virtualdir_se__script' => 'Scripts uniquement',
    'virtualdir_se__script_execute' => 'Scripts et exécutables',
    'virtualdirs__title' => 'Répertoires virtuels',
    'virtualdirs__path_not_exists' => 'Chemin d\'accès incorrect.',
    'virtualdirs__select_for_remove' => "Sélectionner les répertoires virtuels qui doivent être supprimés.",
    'virtualdirs_remove__title' => 'Supprimer les répertoires virtuels',

    'asp_max_buffer_text' => 'Taille maximum de la mémoire tampon ASP (Ko)',
    'asp_max_body_text' => 'Taille maximum du contenu d\'une requête ASP (Ko)',
    'asp_buffers_legend' => 'Paramètres ASP',
    'asp_client_debug_text' => 'Activer le débogage du script ASP côté client',
    'asp_server_debug_text' => 'Activer le débogage du script ASP côté serveur',

    'permissions__group_or_user_name' => 'Noms de groupes ou d\'utilisateurs',
    'permissions__FullControl' => 'Contrôle total',
    'permissions__Modify' => 'Modifier',
    'permissions__ReadAndExecute' => 'Lire et exécuter',
    'permissions__ListFolderContents' => 'Lister le contenu du dossier',
    'permissions__Read' => 'Lire',
    'permissions__Write' => 'Écrire',
    'permissions__ReadControl' => 'Contrôle de lecture',
    'permissions__WriteControl' => 'Contrôle d\'écriture',
    'permissions__ExecuteControl' => 'Exécuter la commande',
    'permissions__TraverseFolderOrExecuteFile' => 'Parcourir un dossier / Exécuter un fichier',
    'permissions__ListFolderOrRead' => 'Lister dossiers / Lire données',
    'permissions__CreateFilesOrWrite' => 'Créer des fichiers / Écrire des données',
    'permissions__CreateFoldersOrAppend' => 'Créer des dossiers / Ajouter des données',
    'permissions__DeleteSubfoldersandFiles' => 'Supprimer des sous-dossiers et des fichiers',
    'permissions__Delete' => 'Supprimer',
    'permissions__ChangePermissions' => 'Modifier les droits',
    'permissions__TakeOwnership' => 'Devenir propriétaire',
    'permissions__inherited_from' => 'Hérité de',
    'permissions__not_inherited' => '<pas hérité>',
    'permissions__apply_to' => 'Appliquer à',
    'permissions__apply_onto' => 'Appliquer à :',
    'permissions__apply_onto1' => 'À ce dossier uniquement',
    'permissions__apply_onto2' => 'Aux sous-dossiers uniquement',
    'permissions__apply_onto3' => 'À ce dossier et aux sous-dossiers',
    'permissions__apply_onto4' => 'Aux fichiers uniquement',
    'permissions__apply_onto5' => 'À ce dossier et aux fichiers',
    'permissions__apply_onto6' => 'Au sous-dossier et aux fichiers uniquement',
    'permissions__apply_onto7' => 'À ce dossier, aux sous-dossiers et aux fichiers',

    'filemanager__not_allowed_dir' => "Vous n'êtes pas autorisé à modifier les droits de ce dossier.",

    'filemanager__allow' => "Autoriser",
    'filemanager__deny' => "Refuser",
    'filemanager__user_domusr' => 'Administrateur de site Web',
    'filemanager__user_webusr' => 'Utilisateur web',
    'filemanager__user_admins' => 'Administrateurs',
    'filemanager__user_system' => 'SYSTEME',
    'filemanager__user_aspnet' => 'Utilisateur ASP.NET',
    'filemanager__user_poolusr' => 'Utilisateur du pool d\'applications',
    'filemanager__user_sysaccount' => 'Utilisateur système supplémentaire',

    'bt_permissions_advanced' => 'Avancé',
    'b_permissions_advanced' => 'Cliquez pour voir et définir des droits spécifiques.',

    'hotlink-protection_invalid_friend_domain' => 'Nom de domaine de confiance non valide.',
    'hotlink-protection_duplicate_friend_domain' => 'Nom de domaine de confiance en double.',
    'hotlink-protection_invalid_extensions' => 'Les extensions de fichiers contiennent des caractères incorrects.',

    'i_domain_alias_status_on' => 'L\'alias de domaine est activé.',
    'i_domain_alias_status_off' => 'L\'alias de domaine est désactivé.',
    'i_domain_alias_status_with_parent' => 'L\'alias de domaine est désactivé parce que le domaine lui-même est arrêté.',
    'i_domain_alias_turn_off' => 'Cliquez pour désactiver.',
    'i_domain_alias_turn_on' => 'Cliquez pour activer.',

    'domain_alias__control_title' => 'Alias de domaine %1',
    'domain_alias__control_info_legend' => 'Infos',
    'domain_alias__control_status_title' => 'S',
    'domain_alias__control_name_title' => 'Nom du service',
    'domain_alias__control_details_title' => 'Détails',

    'domain_alias__invalid_values' => 'Le nom de domaine que vous avez indiqué est incorrect. Les noms de domaine peuvent comprendre des lettres, chiffres et tirets. Chaque partie du nom de domaine entre les points ne doit pas contenir plus de 63 symboles.',
    'domain_alias__domain_already_exists' => "Nom incorrect de l'alias de domaine %1. Le domaine %1 existe déjà.",
    'domain_alias__www_prefix_domain_already_exists' => "Nom incorrect de l'alias de domaine www.%1. Cet alias est déjà créé pour le domaine %1.",
    'domain_alias__webmail_enabled_domain_already_exists' => 'Nom incorrect de l\'alias de domaine webmail.%1. Cet alias est déjà créé pour le domaine %1.',
    'domain_alias__lists_enabled_domain_already_exists' => 'Nom incorrect de l\'alias de domaine lists.%1. Cet alias est déjà créé pour le domaine %1.',
    'domain_alias__dns_record_already_exists' => 'Impossible de configurer l\'alias de domaine %1, car un enregistrement DNS pointant vers l\'hôte %1 existe déjà.',
    'domain_alias__domain_alias_already_exists' => "Un alias de domaine portant un tel nom existe déjà.",
    'domain_aliases__mail_server_not_support_aliases' => 'Le serveur de messagerie ne prend pas en charge la fonctionnalité Alias de domaines. Les alias de domaines pourraient ne pas fonctionner correctement.',
    'domain_alias__restrict_domain_creation' => 'Le nom indiqué pour l\'alias de domaine est interdit par la politique appliquée à l\'ensemble du serveur. Si cet alias de domaine vous appartient, contactez votre hébergeur.',
    'domain_alias__restrict_creation_with_www' => 'Saisissez un nom de domaine sans le préfixe \'www\'. Le préfixe "www" sera ajouté automatiquement à la configuration du serveur Web.',
    'domain_unable_to_set_name' => 'Nom incorrect : %1.',

    'domain_alias__domain_service_dns_disabled' => 'Ce domaine est servi par un autre serveur DNS.',
    'domain_alias__domain_service_dns_enabled_master' => 'Ce serveur DNS sert désormais de serveur de noms principal pour cette zone DNS.',
    'domain_alias__domain_service_dns_enabled_slave' => 'Ce serveur DNS sert de serveur de noms secondaire pour cette zone DNS.',
    'domain_alias__domain_service_mail_enabled' => 'Le service de messagerie est activé pour le domaine.',
    'domain_alias__domain_service_mail_disabled' => 'Le service de messagerie est désactivé pour le domaine.',
    'domain_alias__domain_service_mail_mx' => '%1 est utilisé en tant que serveur de messagerie.',

    'domain_alias__service_seoRedirect_hint' => 'Lorsque les visiteurs cliquent sur l\'URL alias, ils sont redirigés vers l\'URL du domaine primaire. Plesk utilise la redirection permanente du moteur de recherche HTTP 301, ce qui signifie que le référencement du moteur de recherche est conservé.',

    'bt_task_run_now' => 'Exécuter maintenant',
    'ftp__read_perm' => "Droit de lecture",
    'ftp__write_perm' => "Droit d'écriture",

    'filemanager__upload_backup_file_hint' => 'Sur cette page, vous pouvez envoyer des fichiers de sauvegarde vers le stockage de Plesk. La taille maximum du fichier est limitée à deux gigaoctets.',

    '__default_for_mssql' => 'par défaut pour MS SQL',

    '__login_does_not_pass_validation' => "Le nom d'utilisateur est incorrect. Il doit être conforme aux critères suivants : %1",
    '__login_allowed_symbols' => 'Seuls les caractères alphanumériques dont les points, tirets et tirets-bas sont autorisés. Le premier caractère doit être alphanumérique.',

    'restart__nginx' => 'Reverse Proxy Server (Nginx)',
    'restart__php-fpm' => 'PHP-FPM %1',

    'admin_ed__i_would_like_recieve_announce' => "Je souhaite recevoir les informations générales sur le produit ainsi que les annonces de Plesk.",
    'admin_ed__i_would_like_recieve_tech_announce' => "Je souhaite recevoir les informations relatives à la sécurité ainsi que les autres notifications techniques de Plesk.",

    '__login_status_inactive' => 'Votre compte est inactif. Veuillez contacter l\'administrateur Plesk.',

    'migration__task_keep_in_process' => 'OK',
    'migration__task_keep_in_process_conhelp' => 'Retournez à la page Outils & Paramètres. La migration va se poursuivre en arrière-plan.',

    'ui__admin-alias-info__description' => "Éditez les informations sur le contact du compte administrateur supplémentaire.",
    'ui__admin-alias-info__short-title' => "Informations sur le contact",
    'ui__admin-alias-info__title' => "Informations sur le compte administrateur supplémentaire",
    'ui__admin-alias-password__description' => "Changez le mot de passe de l'administrateur supplémentaire.",

    'ui__admin-alias-password__short-title' => "Modifier le mot de passe",
    'ui__admin-alias-password__title' => "Mot de passe de l'administrateur supplémentaire",
    'ui__admin-alias__description' => "Affichez et changez les informations sur les comptes administrateur supplémentaires.",

    'chk_js__warning_about_ftp_login_syntax' => "Pour vous pouvez utiliser des caractères alphanumériques en minuscules, des traits et des tirets-bas dans le nom d'utilisateur.",
    'chk_js__warning_about_passwd_syntax' => "N'utilisez pas de guillemets, d'espaces et de caractères alphabétiques nationaux dans un mot de passe.\nLa longueur du mot de passe doit comprendre entre %1 et %2 caractères et ne doit pas contenir le nom d'utilisateur.",
    'chk_js__warning_about_plesk_login_syntax' => "Pour le nom d'utilisateur, vous pouvez utiliser des caractères alphanumériques en minuscules, des traits, des points, des tirets et des tirets-bas.",
    'chk_js__warning_about_admin_passwd_syntax' => "N'utilisez ni de guillemets, d'espaces, de demi-points ni de caractères alphabétiques nationaux dans un mot de passe.\nLa longueur du mot de passe doit comprendre entre %1 et %2 caractères et ne doit pas contenir le nom d'utilisateur.",

    'cmd_server__admin_alias_not_found' => "Impossible de trouver le compte administrateur supplémentaire.",

    'panel_branding__skins_already_exists' => "Remarque : Le thème '%1' existe déjà. Il sera remplacé par le thème que vous installez actuellement.",
    'panel_branding__skins_file_exists' => "Impossible de créer un répertoire pour le thème'%1' : un fichier avec un tel nom existe déjà dans le répertoire.",

    'actionlog__login_failed' => 'échec de connexion',
    'actionlog__event_cp_user_login_failed' => 'Échec de connexion de l\'utilisateur de Plesk',
    'actionlog__api_login_failed' => 'échec de connexion via l\'API',
    'actionlog__event_cp_user_api_login_failed' => 'Échec de connexion de l\'utilisateur de Plesk via l\'API',
    'actionlog__pw_reset' => 'demande de réinitialisation du mot de passe',
    'actionlog__pw_admin_force_reset' => 'demande de réinitialisation forcée du mot de passe de l\'administrateur',

    'ch_pass_admin__email_subject' => "Aide-mémoire du mot de passe Plesk",
    'ch_pass_admin__email_body' => "Bonjour %1 !\n\n\nLe mot de passe de l'administrateur ne peut pas être communiqué par e-mail pour des raisons de sécurité.\n\nPour vous connecter en tant qu'administrateur, utilisez la commande \"'plesk login\".\n\nPour définir un nouveau mot de passe \"admin\", utilisez la commande \"plesk bin admin --set-password -passwd <new_password>\"\n\n.",
    'ch_pass_admin__message_send_error' => 'Impossible d\'envoyer l\'e-mail : %1',

    'ch_pass_by_secret__email_subject' => "Aide-mémoire du mot de passe Plesk",
    'ch_pass_by_secret__email_body' => "Bonjour %2, \n\nPour définir un nouveau mot de passe, utilisez ce lien : %1 \n\nVotre identifiant : %3",
    'ch_pass_by_secret__message_send_error' => 'Transmission du code secret impossible : %1',
    'ch_pass_by_secret__title' => 'Modifier votre mot de passe',
    'ch_pass_by_secret__secret' => 'Code secret',

    'custom_button__noframe' => "Ne pas utiliser de cadre",

    'custom_button__internal_hint' => 'Indiquez si l\'URL doit être ouverte dans une page de Plesk ou dans une nouvelle fenêtre de navigateur.',
    'custom_button__noframe_hint' => 'Si vous ajoutez un bouton personnalisé qui mène à une extension ou une application de Plesk dans le Panneau Client, vous pouvez indiquer comment vous souhaitez afficher ce service / cette application : dans un cadre ou intégré à l\'interface de Plesk.',


    'actionlog__patch' => 'Mettre à jour',
    'actionlog__patch_available' => 'disponible',
    'actionlog__event_patch_available' => 'Mise à jour disponible',
    'actionlog__patch_installed' => 'installé',
    'actionlog__event_patch_installed' => 'Mise à jour installée',

    'actionlog__extension' => 'Extension',
    'actionlog__extension_status' => 'Statut de l’extension',
    'actionlog__cloning' => 'Clonage du serveur',
    'actionlog__cloning_complete' => 'terminé',
    'actionlog__event_cloning_complete' => 'Clonage du serveur terminé',

    'actionlog__ssl_web_binding' => 'Certificat SSL/TLS du domaine',
    'actionlog__ssl_web_binding_update' => 'attribué/non attribué.',
    'actionlog__event_ssl_web_binding_update' => 'Certificat SSL/TLS du domaine attribué/non attribué.',

    'actionlog__ssl_web_mail_binding' => 'Certificat SSL/TLS sur la messagerie Web',
    'actionlog__ssl_web_mail_binding_update' => 'attribué/non attribué.',
    'actionlog__event_ssl_web_mail_binding_update' => 'Certificat SSL/TLS sur la messagerie Web attribué/non attribué.',

    'actionlog__ssl_mail_binding' => 'Certificat SSL/TLS sur le serveur de messagerie',
    'actionlog__ssl_mail_binding_update' => 'attribué/non attribué.',
    'actionlog__event_ssl_mail_binding_update' => 'Certificat SSL/TLS sur le serveur de messagerie attribué/non attribué.',

    'actionlog__ssl_panel_binding' => 'Certificat SSL/TLS de Plesk',
    'actionlog__ssl_panel_binding_update' => 'attribué/non attribué.',
    'actionlog__event_ssl_panel_binding_update' => 'Certificat SSL/TLS sur Plesk attribué/non attribué.',

    'actionlog__hostname' => 'Nom d\'hôte du serveur',
    'actionlog__hostname_changed' => 'modifié',

    'actionlog__smb_user' => 'Autre utilisateur',
    'actionlog__smb_user_create' => 'Autre utilisateur créé',
    'actionlog__smb_user_delete' => 'Autre utilisateur supprimé',
    'actionlog__smb_user_update' => 'Autre utilisateur mis à jour',

    'actionlog__event_mail_management_status_update' => 'Mise à jour du statut de la gestion des mails',
    'actionlog__mail_management' => 'Statut de la gestion des mails',
    'actionlog__mail_management_status_update' => 'mis(e) à jour',

    'virtualization_openvz' => 'OpenVZ',

    '__domains_total' => 'Total par domaines',

    'passwordSecurityLevelCheckFailed' => 'Votre mot de passe n\'est pas assez complexe. D\'après la politique des serveurs, la complexité minimum des mots de passe est %1. Pour renforcer la complexité des mots de passe, utilisez des nombres, des majuscules et minuscules ainsi que des caractères spéciaux tels que !,@,#,$,%,^,&,*,?,_,~',
    'passwordSecurityLevelCheckFailedVeryWeak' => 'Très faible',
    'passwordSecurityLevelCheckFailedWeak' => 'Faible',
    'passwordSecurityLevelCheckFailedMediocre' => 'Moyen',
    'passwordSecurityLevelCheckFailedStrong' => 'Fort',
    'passwordSecurityLevelCheckFailedStronger' => 'Très fort',

    'ui__client/domain/dns/sync__description' => 'Appliquez les modifications du template DNS niveau serveur à la zone.',
    'ui__client/domain/dns/sync__disabled-warning' => 'Impossible d\'appliquer les modifications du template DNS à la zone car elle dépend d\'un autre serveur DNS.',
    'ui__client/domain/dns/sync__short-title' => 'Appliquer les modifications du template DNS',
    'ui__client/domain/dns/sync__done' => 'Les modifications du template DNS ont bien été appliquées à la zone.',
    'ui__client/domain/domain-alias/dns/sync__description' => 'Appliquez les modifications du template DNS niveau serveur à la zone.',
    'ui__client/domain/domain-alias/dns/sync__disabled-warning' => 'Impossible d\'appliquer les modifications du template DNS à la zone car elle dépend d\'un autre serveur DNS.',
    'ui__client/domain/domain-alias/dns/sync__short-title' => 'Appliquer les modifications du template DNS',
    'ui__client/domain/domain-alias/dns/sync__done' => 'Les modifications du template DNS ont bien été appliquées à la zone.',
    'dns__dns_default_ipv4_modified' => 'Les enregistrements avec cette adresse IP seront considérés comme modifiés par l\'utilisateur et ne seront pas synchronisés avec le template DNS valable pour tout le serveur.',
    'dns__dns_default_ipv6_modified' => 'Les enregistrements avec cette adresse IP seront considérés comme modifiés par l\'utilisateur et ne seront pas synchronisés avec le template DNS valable pour tout le serveur.',

    'dns__view_dns_record_master_title' => 'Affichage des enregistrements concernant une ressource',
    'dns__view_dns_record_off_title' => 'Affichage des enregistrements de serveurs de noms',
    'dns__view_dns_record_slave_title' => 'Affichage des enregistrements du serveur DNS primaire',

    'dns_unable_to_resolve_hostname' => "Impossible de résoudre le nom d'hôte \"%1\" : %2\nVérifiez si la résolution DNS du système d'exploitation est configurée et si elle fonctionne.",

    'no_database_server_available' => 'Aucun serveur de base de données n\'est disponible pour cet abonnement.',

    'database_used_by_application_can_not_be_moved' => 'Impossible de déplacer la base de données : une application de site Web utilise cette base de données.',
    'database_user_update_orphaned_is_restricted' => 'La mise à jour de comptes utilisateur orphelins d\'une base de données est interdite. Vous pouvez seulement les réparer.',

    'database_unable_to_get_max_filesize_default_message' => 'Impossible de déterminer la taille maximum du fichier de la base de données : \'%1\'',
    'database_unable_to_set_max_filesize_default_message' => 'Impossible de définir la taille maximum de la base de données : \'%1\'',
    'database_unable_to_get_max_log_filesize_default_message' => 'Impossible de déterminer la taille maximum du fichier de log de la base de données : \'%1\'',
    'database_unable_to_set_max_log_filesize_default_message' => 'Impossible de définir la taille maximum du fichier de log de la base de données : \'%1\'',

    'database_unable_to_get_max_filesize' => 'Impossible de déterminer la taille maximum de fichier de la base de données Microsoft SQL \'%1\'. Impossible de définir une nouvelle limite.',
    'database_unable_to_set_max_filesize' => 'Impossible de définir la taille maximum de fichier de la base de données Microsoft SQL \'%1\'.',
    'database_unable_to_get_max_log_filesize' => 'Impossible de déterminer la taille maximum du fichier de log de la base de données Microsoft SQL \'%1\'. Impossible de définir une nouvelle limite.',
    'database_unable_to_set_max_log_filesize' => 'Impossible de définir la taille maximum de fichier de log de la base de données Microsoft SQL \'%1\'.',

    'database_unable_to_create_because_max_filesize' => 'Impossible de créer la base de données Microsoft SQL \'%1\' : la taille du fichier est supérieure à la taille maximum autorisée.',
    'database_unable_to_move_because_max_filesize' => 'Impossible de déplacer la base de données Microsoft SQL \'%1\' : la taille du fichier est supérieure à la taille maximum autorisée %2.',
    'database_unable_to_create_because_max_log_filesize' => 'Impossible de créer la base de données Microsoft SQL \'%1\' : la taille du fichier de log est supérieure à la taille maximum autorisée.',
    'database_unable_to_move_because_max_log_filesize' => 'Impossible de déplacer la base de données Microsoft SQL \'%1\' : la taille du fichier de log est supérieure à la taille maximum autorisée %2.',
    'database_unable_to_restore_because_max_filesize' => 'Impossible de restaurer la base de données Microsoft SQL \'%1\' : la taille du fichier est supérieure à la taille maximum autorisée.',

    'sandbox_mssql_server_registered_as_usual_db_server' => 'Indiquez un autre Serveur MS SQL en tant que sandbox. Veuillez indiquer un autre Serveur MS SQL comme sandbox.',
    'database_server__mssql_server_registered_as_sandbox' => 'Une sandbox Serveur MS SQL identique est déjà enregistrée dans Plesk. Veuillez indiquer un autre Serveur MS SQL comme sandbox.',

    'database_server_mysql_unable_to_connect_via_cli' => 'Impossible de se connecter au serveur via \'%1\' : %2',

    'bu_conflict_resolver_feature_not_available' => 'La fonction %1 n\'est pas prise en charge par les nodes de service suivants : %2. Cette fonction sera désactivée pour tous les objets créés sur ces nodes.',
    'bu_conflict_resolver_feature_not_available_single_server' => 'La fonction %1 n\'est pas prise en charge par ce serveur. Cette fonction sera désactivée pour tous les objets restaurés.',
    'bu_conflict_resolver_component_unavailable_in_sites' => 'Le composant %1 n\'est pas installé. Il ne sera pas disponible pour les sites Web suivants : {{objects}}',
    'bu_conflict_resolver_component_replaced_in_sites' => 'Le composant %1 n\'est pas installé. Il sera remplacé par %2 pour les sites Web suivants : {{objects}}',

    'bu_conflict_resolver_restoration_of_object_end_to_dot_not_supported' => 'La version actuelle de Plesk ne prend pas en charge les noms d\'utilisateur contenant un point (.). Les clients et revendeurs portant de tels noms d\'utilisateurs ne seront pas restaurés.',
    'bu_conflict_resolver_unable_to_find_backup_part' => 'Impossible de trouver un fichier de sauvegarde avec les données pour %1 %2. Les données pour %1 %2 ne seront pas restaurées.',

    'bu_conflict_resolver_zone_master_removed' => "Impossible de restaurer l'enregistrement DNS principal : l'enregistrement dans la zone secondaire pointe vers l'adresse IP existante %1. L'enregistrement DNS principal sera supprimé de la zone secondaire.",
    'bu_conflict_resolver_dns_not_supported_https' => 'La prise en charge des enregistrements DNS HTTPS est désactivée. Les enregistrements HTTPS ne seront pas restaurés pour les domaines suivants : {{objects}}',

    'bu_conflict_resolver_not_available_scripting' => '%1 n\'est pas pris en charge.',
    'bu_conflict_resolver_not_available_scripting_in_sites' => '%1 n\'est pas pris en charge. Il ne sera pas disponible pour les sites Web suivants : {{objects}}',
    'bu_conflict_resolver_not_available_component' => 'Le composant %1 n\'est pas installé.',
    'bu_conflict_resolver_disabled_in_multi_server' => 'Il ne sera pas disponible pour les nodes de services suivants : {{objects}}',
    'bu_conflict_resolver_disabled_in_single_server' => 'Il ne sera pas disponible pour les objets suivants : {{objects}}',
    'bu_conflict_resolver_not_available_db' => 'Les serveurs de bases de données suivants ne sont pas disponibles sur ce serveur : %1.',

    'bu_conflict_resolver_smarthost_not_supported' => 'La gestion d\'hôte intelligent n\'est pas prise en charge. Les paramètres de l\'hôte intelligent ne seront pas restaurés.',

    'bu_conflict_resolver_mssql_native_dump_restore_not_available' => 'Le fichier de sauvegarde de la base de données MS SQL est stocké au format natif MS SQL. Ce format peut être restauré uniquement sur le serveur local MS SQL ou un serveur MS SQL distant avec des paramètres de sauvegarde entièrement configurés. Certaines de vos bases de données n\'ont pas été restaurées, car il n\'y a pas de serveur de bases de données MS SQL approprié dans Plesk. Les domaines suivants étaient concernés : {{objects}}. Consultez votre hébergeur.',

    'bu_conflict_resolver_not_available_webmail' => 'Le service de messagerie Web %1 n\'est pas disponible. Il sera remplacé par %2 pour les objets suivants : {{objects}}',
    'bu_conflict_resolver_not_available_webmail_plan' => 'Le service de messagerie Web %1 n\'est pas disponible. Il sera remplacé par %2 pour les packs de services suivants : {{objects}}',
    'bu_conflict_resolver_not_available_rename_db_user' => "Les bases de données de type '%1' ne prennent pas en charge les noms d'utilisateurs correspondants à des noms de bases de données. L'utilisateur '%2' sera renommé en '%3' pour la base de données '%4'.",

    'bu_conflict_resolver_wrong_hard_quota_value' => 'La limite d\'utilisation de l\'espace disque n\'est pas définie dans la configuration du serveur de destination. La valeur de ce paramètre sera modifiée en "Illimité".',
    'bu_conflict_resolver_wrong_max_connections_value' => 'La limite du nombre de connexions n\'est pas définie dans la configuration du serveur de destination. La valeur de ce paramètre sera modifiée en "Illimité".',
    'bu_conflict_resolver_wrong_traffic_bandwidth_value' => 'La limite d\'utilisation du trafic n\'est pas définie dans la configuration du serveur de destination. La valeur de ce paramètre sera modifiée en "Illimité".',
    'cu__pleskrestore_backup_file_extracted' => 'Le fichier de sauvegarde a été extrait vers "%1".',
    '__mod_bw_not_supported' => 'Le module mod_bw pour le serveur Web Apache n\'est pas pris en charge en raison de la configuration du système de fichiers. Les limites d\'utilisation du trafic et le nombre maximum de connexions de fonctionneront pas.',
    'bu_conflict_resolver_pop3_only_relay_auth_not_supported' => 'L\'autorisation POP3 pour le relais de mail n\'est pas prise en charge ; l\'autorisation POP3 avant SMTP sera utilisée à la place. ({{objects}})',
    'bu_conflict_resolver_service_plan_name' => 'Pack de services \'%1\'',
    'bu_conflict_resolver_replaced_in_plans' => '%1 n\'est pas pris en charge. Il sera remplacé par %2 pour les packs de services suivants : {{objects}}',
    'bu_conflict_resolver_replaced_in_sites' => '%1 n\'est pas pris en charge. Il sera remplacé par %2 pour les sites Web suivants : {{objects}}',
    'bu_conflict_resolver_absent_objects_in_dump' => 'Les objets suivants n\'ont pas été trouvés dans le fichier de sauvegarde : %1',
    'bu_conflict_resolver_absent_domains' => 'Impossible de restaurer certains objets, car ils appartiennent aux domaines suivants qui n\'ont pas été trouvés dans Plesk : %1',
    'bu_conflict_resolver_absent_parent_domains' => "Impossible de restaurer certains sites Web, car ils appartiennent aux domaines parents suivants qui n'ont pas été trouvés dans Plesk :\n%1",
    'bu_conflict_resolver_dns_not_supported' => 'Impossible de restaurer les zones DNS : le service DNS est désactivé dans la configuration du serveur.',
    'bu_conflict_resolver_mail_not_supported' => 'Impossible de restaurer les boîtes mail : le service de messagerie est désactivé dans la configuration du serveur.',
    'bu_conflict_resolver__cpu_limit_action_not_supported' => 'L\'option choisie pour limiter l\'action du CPU n\'est pas prise en charge par le serveur Web IIS. La valeur sera réinitialisée sur %1.',
    'bu_conflict_detector_server_ssl_cert_name' => 'Certificat SSL/TLS du serveur %1',
    'bu_conflict_detector_domain_ssl_cert_name' => 'Certificat SSL/TLS %2 du domaine %1',
    'bu_conflict_detector_ssl_cert_name' => 'Certificat SSL/TLS %1',
    'bu_conflict_resolver_absent_objects' => 'Les contenus des objets suivants ne peuvent pas être restaurés. Impossible de trouver les objets dans Plesk : %1',
    'bu_conflict_resolver_absent_objects_mailuser' => 'Les contenus des boîtes mail suivantes ne peuvent pas être restaurés, car les boîtes mail ne sont pas trouvées dans Plesk : %1',
    'bu_conflict_resolver_absent_objects_maillist' => 'Les contenus des listes de diffusion suivantes ne peuvent pas être restaurés, car les listes de diffusion ne sont pas trouvées dans Plesk : %1',
    'bu_conflict_resolver_absent_objects_database' => 'Les contenus des bases de données suivantes ne peuvent pas être restaurés. Impossible de trouver les bases de données dans Plesk : %1',
    'bu_conflict_resolver__remove_conflicted_aps_app' => 'La restauration de l\'application "%1" dans "%2" a échoué, car une autre application est déjà installée dans "%3". Supprimez l\'application installée, puis réessayez.',
    'bu_conflict_resolver_not_available_mail_autoresponders' => 'La fonction de réponse automatique n\'est pas prise en charge.',
    'bu_conflict_resolver_not_available_mail_content' => 'La restauration du contenu des mails n\'est pas prise en charge.',
    'bu_conflict_resolver_invalid_mail_name' => 'Les boîtes mail suivantes n\'ont pas été restaurées, car le sous-adressage est activé et certaines adresses e-mail contiennent le signe "%1" : %2',
    'bu_conflict_resolver_invalid_user_name' => 'Les utilisateurs suivants n\'ont pas été restaurés, car le sous-adressage est activé et certaines adresses e-mail contiennent le signe "%1" : %2',
    'bu_conflict_resolver_licenses_expired' => 'Les licences suivantes sont arrivées à expiration et ne seront pas restaurées : {{objects}}',
    'bu_conflict_resolver_licenses_invalid' => 'Les licences suivantes ne sont pas valides ou ont expiré et ne seront pas restaurées : {{objects}}',
    'expiration_unsupported' => "La limite 'expiration' n'est pas prise en charge.",

    'component_name__dbconnector' => "Connecteur de la base de données",
    'component_name__mysqlserver' => 'Serveur MariaDB/MySQL',
    'component_name__troubleshooting' => 'Résolution des problèmes',
    'component_name__savi' => 'Interface antivirus Sophos',

    '__subscription_has_no_license_key' => 'Les ressources de l\'abonnement sont fournies par le node de services n° %1 qui n\'a pas de clé de licence associée.',
    '__subscription_has_expired_license_key' => 'Les ressources de l\'abonnement sont fournies par le node de services n° %1 dont la clé de licence %2 a expiré.',

    '__cfgmonConfigurationFileSaveErrorSubject' => '<%%host%%> Impossible d\'enregistrer les fichiers de configuration',
    '__cfgmonConfigurationFileSaveErrorBody' => "Impossible d'enregistrer certains fichiers de configuration sur l'hôte <%%host%%>. Les erreurs suivantes sont survenues :\n\n%%errors%%",

    'mail__enable_email_subaddressing_cli_desc' => 'Cette option permet de configurer les adresses mail du type VERP pour les listes d&apos;adresses mail.',
    'mail__enter_right_ip_mask' => "Entrez une valeur entre 1 et 32 pour le masque IP",
    'mail__enter_right_ip_mask_24' => "Entrez une valeur entre 24 et 32 pour le masque IP",
    'mail__invalid_dom_name' => "Le domaine %1 n'est pas valide.",
    'mail__invalid_pop_lock_time' => "Temps de blocage du POP3 incorrect.",
    'mail__invalid_rbl_server' => "La zone DNS n'est pas valide.",
    'mail__total_files_size' => "Taille totale du répertoire: %1",
    'mail__filename_already_in_repository' => "Un fichier avec un nom identique existe déjà dans le répertoire.",
    'mail__no_white_list_mask_feature_24' => "Utiliser une valeur masque de 24 ou plus. Votre serveur de messagerie ne prend pas en charge le paramétrage de masques. Nous pouvons seulement émuler la configuration de masques pour des valeurs supérieures à 24.",
    'mail__unable_add_new_mail_name' => "Impossible d'ajouter le compte mail : %1",
    'mail_server_is_not_installed' => 'Le serveur de messagerie (Postfix ou Qmail) n\'est pas installé. Installez-le pour continuer.',
    'mail_server_not_available' => 'Aucun serveur de messagerie pris en charge n\'est disponible sur le node de services.',
    '__not_installed' => '(n\'est pas installé)',
    'mail__service_node_outgoing_messages_is_disabled' => 'Le filtre anti-spam des mails sortants est désactivé.',
    'mail__service_node_does_not_support_outgoing_messages_domain_limit' => 'Le node de services ne prend pas en charge la limitation du nombre de mails sortants depuis un domaine pour le domaine %1.',
    'mail__service_node_does_not_support_outgoing_messages_mbox_limit' => 'Le node de services ne prend pas en charge la limitation du nombre de mails sortants depuis une boîte mail pour le domaine %1.',

    'mail__outgoing_email_mode_explicit_ip_unspecified' => 'Indiquez une adresse ou au moins un type d\'adresse (IPv4 ou IPv6).',

    'mail__outgoing_email_mode_invalid' => 'Un mode non valide a été indiqué pour les mails sortants.',
    'mail__outgoing_email_mode_explicit_ip_v4_invalid' => 'Une adresse IPv4 non valide a été indiquée.',
    'mail__outgoing_email_mode_explicit_ip_v6_invalid' => 'Une adresse IPv6 non valide a été indiquée.',
    'mail__outgoing_email_mode_unavailable' => 'La modification du mode pour les mails sortants n\'est pas prise en charge, probablement parce que le serveur de messagerie Postfix n\'est pas installé sur ce serveur.',

    'mail__autoresponder_attachment_not_supported' => 'Le serveur de messagerie actuellement utilisé ne prend pas en charge la gestion des pièces jointes de réponse automatique.',

    'mail__smtp_white_list_not_supported' => 'Le serveur de messagerie utilisé actuellement ne prend pas en charge les listes blanches d\'adresses IP.',
    'mail__smtp_whitelist_cidr_not_supported' => 'Les masques CIDR ne sont pas pris en charge par le serveur de messagerie sélectionné actuellement. Spécifiez l\'adresse IP au format \'192.*.0.*\'.',
    'mail__smtp_whitelist_mask_not_supported' => 'Les modèles d\'IP wildcard ne sont pas pris en charge par le serveur de messagerie sélectionné actuellement. Spécifiez l\'adresse IP au format \'192.0.0.0/8\'.',

    'sfdk_server_wide_verify_failed' => 'Impossible de modifier les paramètres du service de vérification DKIM',

    'sfdk_domain__serverwide_disabled' => 'Désactivé d\'après la politique du serveur',
    'feature__domainkeys__serverwide_disabled' => 'La protection anti-spam DomainKeys pour l\'ensemble du serveur est désactivée',

    'defaultcomponents__error_set_default' => 'Impossible de définir %1 comme %2 par défaut : %3',
    'defaultcomponents__error_set_default_none' => 'Un composant par défaut est obligatoire pour %1 : %2',
    'defaultcomponents__required_package_not_default' => 'Le composant %1 requit pour son fonctionnement n\'est pas défini par défaut.',

    '__percentage' => '%',
    '__seconds' => 'Secondes',
    '__resource_remain' => 'Disponible',

    '__not_registered' => '(non enregistré)',
    '__php_handler_id' => 'Version de PHP',
    '__php_handler_id_string' => 'PHP %1 (%2)',
    '__php_handler_not_registered' => 'Le gestionnaire PHP "%1" n\'est pas enregistré. Il a probablement été supprimé du serveur. Enregistrez un gestionnaire avec les mêmes propriétés et réessayez.',
    '__php_handler_not_registered_on_domain' => 'Domaine"%1" : le gestionnaire PHP "%2" n\'est pas enregistré. Il a probablement été supprimé du serveur. Enregistrez un gestionnaire avec les mêmes propriétés et réessayez.',
    '__php_fpm_handler' => 'Application FPM',
    '__php_fpm-dedicated_handler' => 'Application FPM dédiée',

    'mailname_create_assigned_user_dublicate_error' => 'Impossible de créer un utilisateur pour cette boîte mail. L\'utilisateur avec le nom d\'utilisateur %1 existe déjà est dispose d\'une autre boîte mail.',
    'mailname_create_assigned_user_role_absent_error' => 'Impossible de créer un utilisateur pour cette boîte mail. Le rôle par défaut %1 de l\'utilisateur n\'existe pas.',

    'gphd__mime_types' => 'Types MIME',
    'gphd__handlers' => 'Gestionnaires Apache',
    'gphd__ip_restrictions_allow' => 'Autoriser l\'accès au site pour les hôtes et les réseaux indiqués (sauf ceux qui sont refusés)',
    'gphd__ip_restrictions_deny' => 'Refuser l\'accès au site pour les hôtes et les réseaux indiqués',
    'gphd__directory_index' => 'Fichiers Index',
    'gphd__nginx_transparent_mode' => 'Mode utilisé lorsque Apache traite du contenu statique et dynamique, tandis que Nginx transmet uniquement les requêtes et les réponses sans modification.',
    'gphd__nginx_serve_static' => 'Traiter les fichiers statiques directement avec Nginx',
    'gphd__nginx_static_extensions' => 'Extensions de fichiers statiques qui doivent être traités avec Nginx',
    'gphd__nginx_serve_php' => 'Traiter les fichiers PHP avec Nginx',
    'gphd__www_root' => 'Répertoire principal WWW',

    'eol__none' => 'Ne pas changer',
    'eol__lf' => 'Convertir au format Unix',
    'eol__cr' => 'Convertir au format OS X',
    'eol__crlf' => 'Convertir au format Windows',

    'ui__dns_bad_zone' => 'Zone "%1" incohérente :',
    'ui__dns_ns_has_no_address_records' => 'L\'enregistrement NS "%1" n\'a pas d\'enregistrement d\'adresse (A ou AAAA).',
    '__dns_bad_zone' => 'Zone "%1" incohérente :',
    '__dns_ns_has_no_address_records' => 'L\'enregistrement NS "%1" n\'a pas d\'enregistrement d\'adresse (A ou AAAA).',
    '__dns_ptr_is_wildcard' => 'L\'enregistrement PTR "%1" n\'est pas valide : l\'enregistrement dirige vers un domaine wildcard.',

    'firewall_database_user_remote_access_rule_name' => '[%1][%2] Autoriser l\'accès à distance pour l\'utilisateur de la base de données \'%3\' du client \'%4\'',
    'firewall_database_user_remote_access_rule_name_removed' => '[%1][%2] %3',
    'firewall_database_user_remote_access_mssql_server_port_undefined' => 'Impossible d\'autoriser les connexions à distance pour l\'utilisateur de la base de données \'%1\' : impossible de déterminer le numéro de port TCP utilisé par Microsoft SQL Server \'%2\'. Plusieurs causes sont possibles : soit le protocole TCP/IP n\'est pas activé dans la configuration réseau du serveur, soit le serveur est configuré pour utiliser des ports TCP dynamiques. Configurez le serveur afin qu\'il écoute un port TCP fixe spécifique et essayez à nouveau d\'autoriser les connexions à distance.',

    'command__convertResellerHasCustomer' => 'Le compte revendeur \'%1\' a un ou plusieurs comptes client. Pour convertir ce compte revendeur en compte client, transférez tout d\'abord ce ou ces comptes client vers un nouveau propriétaire ou convertissez-les en comptes revendeur.',
    'command__convertResellerNotReseller' => 'Seuls les comptes revendeur sélectionnés peuvent être convertis en comptes client. \'%1\' n\'est pas un revendeur.',
    'command__convertResellerToCustomerSubscriptionNotSynchronized' => 'Impossible de synchroniser l\'abonnement avec le pack de services. Les paramètres suivants de l\'abonnement sont en conflit avec le pack de services : %%problems%%.',

    'moveCustomer__wrong_customer_type' => 'Le compte \'%1\' est un compte revendeur. Les comptes revendeur ne peuvent pas être déplacés vers un nouveau propriétaire, car ils sont détenus par un administrateur de serveur.',
    'moveCustomer__wrong_owner_type' => "Le compte client '%1' peut uniquement être déplacé vers un revendeur ou un admin et non vers un autre client.",
    'moveCustomer__customer_already_belongs_to_owner' => 'Le compte client \'%1\' appartient déjà au propriétaire sélectionné.',
    'upgradeClient__user_is_admin' => 'Impossible de convertir le compte \'%1\' en compte revendeur : il s\'agit d\'un compte administrateur.',

    'mail__error_setting_max_connections_courier' => 'Impossible de définir le nombre maximal de connexions (IMAP, POP3, IMAP via SSL/TLS ou POP3 via SSL/TLS) : %1',
    'mail__error_setting_max_connections_dovecot' => 'Impossible de définir le nombre maximal de connexions (IMAP, POP3, IMAP via SSL/TLS ou POP3 via SSL/TLS) : %1',
    'mail__error_setting_max_connections_per_ip_courier' => 'Impossible de définir le nombre maximal de connexions (IMAP, POP3, IMAP via SSL/TLS ou POP3 via SSL/TLS) par adresse IP : %1',
    'mail__error_setting_max_connections_per_ip_dovecot' => 'Impossible de définir le nombre maximal de connexions (IMAP, POP3, IMAP via SSL/TLS ou POP3 via SSL/TLS) par adresse IP pour un utilisateur de messagerie spécifique : %1',
    'outgoing_messages_limit_value_invalid' => 'La valeur doit être comprise entre %%MIN%% et %%MAX%%. Seul l\'administrateur Plesk peut ajuster ce paramètre.',
    'outgoing_messages_server_settings_catch_address_are_not_local' => "Les domaines suivants utilisent des adresses mails externes pour la redirection des mails envoyés à des adresses inexistantes. Les mails envoyés à ces adresses ne seront pas comptés dans le contrôle des mails sortants :\n %1",
    'outgoing_messages_white_list_not_empty' => 'Les limites des mails sortants ne fonctionneront pas pour les expéditeurs dont les adresses IP sont incluses dans la liste blanche du serveur de messagerie. Par exemple, s\'il y a un hôte local (127.0.0.0 / 8, ::1 / 128) dans la liste blanche, tous les mails du serveur local seront envoyés avec succès, quelles que soient les limitations. Les expéditeurs peuvent utiliser soit leurs adresses IP locales (sites Web et scripts personnalisés hébergés sur le serveur local) soit des adresses IP externes (clients qui expédient les mails depuis des clients de messagerie installés sur leurs ordinateurs ou périphériques mobiles). Pour que ces limites s\'appliquent à tous les expéditeurs (adresses IP locales et externes), supprimez toutes les adresses IP et tous les réseaux de la liste blanche. Remarque : si vous supprimez l\'hôte local (127.0.0.0 / 8, ::1 / 128) de la liste blanche, cela risque de compromettre le fonctionnement de sites Web et scripts qui envoient des mails depuis ce serveur. Pour en savoir plus sur les limitations des mails sortants, consultez le Guide de l\'administrateur, section Protéger contre les spams sortants.',
    'outgoing_messages_relay_open' => 'Le relais de messagerie est ouvert : les limites de mails sortants ne fonctionneront pas.',

    'notification_aps_app_updates_available' => 'Les mises à jour sont disponibles pour les applications suivantes :',
    'notification_aps_app_updates_installed' => 'Les mises à jour sont automatiquement installées pour les applications suivantes :',
    'notification_aps_app_updates_requirements' => 'Les mises à jour sont disponibles pour les applications suivantes, mais ne peuvent pas être installées, car les paramètres d\'hébergement des sites Web correspondants ne répondent pas aux prérequis de l\'installation :',
    'notification_admin_aps_app_updates_available_item' => '%%name%% (%%url%%). Version installée : %%from%%. Version disponible : %%to%%.',
    'notification_admin_aps_app_updates_available_plugin_item' => 'Plug-in "%%name%%" sur %%parentName%% (%%url%%). Version installée : %%from%%. Version disponible : %%to%%.',
    'notification_admin_aps_app_updates_available_theme_item' => 'Thème "%%name%%" sur %%parentName%% (%%url%%). Version installée : %%from%%. Version disponible : %%to%%.',
    'notification_reseller_aps_app_updates_available_item' => '%%name%% (%%url%%). Version installée : %%from%%. Version disponible : %%to%%.',
    'notification_reseller_aps_app_updates_available_plugin_item' => 'Plug-in "%%name%%" sur %%parentName%% (%%url%%). Version installée : %%from%%. Version disponible : %%to%%.',
    'notification_reseller_aps_app_updates_available_theme_item' => 'Thème "%%name%%" sur %%parentName%% (%%url%%). Version installée : %%from%%. Version disponible : %%to%%.',
    'notification_client_aps_app_updates_available_item' => '%%name%% (%%url%%). Votre version : %%from%%. Version disponible : %%to%%.',
    'notification_client_aps_app_updates_available_plugin_item' => 'Plug-in "%%name%%" sur %%parentName%% (%%url%%). Votre version : %%from%%. Version disponible : %%to%%.',
    'notification_client_aps_app_updates_available_theme_item' => 'Thème "%%name%%" sur %%parentName%% (%%url%%). Votre version : %%from%%. Version disponible : %%to%%.',
    'notification_admin_aps_app_updates_installed_item' => '%%name%% (%%url%%). Nouvelle version : %%to%%. Version précédente : %%from%%.',
    'notification_reseller_aps_app_updates_installed_item' => '%%name%% (%%url%%). Nouvelle version : %%to%%. Version précédente : %%from%%.',
    'notification_client_aps_app_updates_installed_item' => '%%name%% (%%url%%). Nouvelle version : %%to%%. Version précédente : %%from%%.',
    'notification_admin_aps_app_updates_requirements_item' => '%%name%% (%%url%%). Version installée : %%from%%. Version disponible : %%to%%.',
    'notification_reseller_aps_app_updates_requirements_item' => '%%name%% (%%url%%). Version installée : %%from%%. Version disponible : %%to%%.',
    'notification_client_aps_app_updates_requirements_item' => '%%name%% (%%url%%). Votre version : %%from%%. Version disponible : %%to%%.',
    'notification_aps_app_updates_no_installation_url' => 'Application externe',

    'notification_outgoing_mail_exceeded_limits_domains' => 'Domaines',
    'notification_outgoing_mail_exceeded_limits_mails' => 'Adresses mail',
    'notification_outgoing_mail_exceeded_limits_subscriptions' => 'Abonnements',
    'notification_outgoing_mail_exceeded_limits_limit_value' => '%1 messages par heure',
    'notification_outgoing_mail_exceeded_limits_limit_value_unlimited' => 'Illimité',
    'notification_outgoing_mail_exceeded_limits_object' => '%1, la limite est %2',
    'notification_outgoing_mail_exceeded_limits_attempt' => '%1 tentative(s) de dépassement de limite du %2 au %3',
    'notification_outgoing_mail_exceeded_limits_attempt_still_exceeding' => '%1 tentative(s) de dépassement de limite depuis %2 jusqu\'à maintenant',

    'restart__docker' => "Docker",
    'restart__fail2ban' => "Bannissement d'adresses IP (Fail2Ban)",

    'backup__restore__capability_fail2ban_not_installed_text' => 'Le composant Fail2Ban n\'est pas installé sur le serveur de destination.',
    'backup__restore__capability_fail2ban_not_installed_resolution' => 'Installez Fail2Ban. Cela pourrait prendre quelques minutes.',

    'plesk_key__no_reseller_support' => 'Vous ne pouvez pas gérer les revendeurs en raison des restrictions de licence.',
    'plesk_key__no_customers_support' => 'Vous ne pouvez pas gérer les clients en raison des restrictions de licence.',
    'panel_interface_uimodes__service_provider_view_not_allowed' => 'Impossible de passer d\'utiliser la vue Fournisseur de services en raison des restrictions de licence.',
    'plesk_key__no_security_core_support' => 'Les fonctions du noyau de sécurité (ModSecurity et Fail2Ban) ne sont pas disponibles en raison des restrictions de licence.',
    'plesk_key__outgoing-antispam' => 'Contrôle des mails sortants',
    'plesk_key__security-core' => 'Noyau de sécurité (ModSecurity et Fail2Ban)',
    'plesk_key__can-manage-accounts' => 'Gestion des comptes',
    'plesk_key__can-manage-subscriptions' => 'Gestion des abonnements',
    'plesk_key__can-manage-customers' => 'Gestion des clients',
    'plesk_key__can-manage-resellers' => 'Gestion des revendeurs',
    'plesk_key__can-manage-custom-view' => 'Disponibilité du mode Restreint',
    'plesk_key__limits_exceeded_no_subscriptions_management' => 'La gestion des abonnements est désactivée mais vous avez plusieurs abonnements (%1).',
    'plesk_key__limits_exceeded_no_resellers_management' => 'La gestion des revendeurs est désactivée mais vous avez plusieurs revendeurs (%1).',
    'plesk_key__limits_exceeded_no_customers_management' => 'La gestion des clients est désactivée, mais vous avez plusieurs clients (%1).',
    'plesk_key__limits_unlimited_subscriptions' => 'Certaines ressources pour les abonnements que vous ne pouvez plus gérer dans l\'interface de Plesk (comme les limites des boîtes mail et l\'espace disque des domaines) sont désormais définies comme illimitées.',
    'plesk_key__no_subscriptions_support' => 'Vous ne pouvez pas gérer les abonnements en raison des restrictions de licence.',
    'plesk_key__no_custom_view_support' => 'Vous ne pouvez pas utiliser le mode Restreint du fait de restrictions de licence.',
    'plesk_key__trial_forbidden_region' => 'Désolé, actuellement Plesk n\'est pas disponible dans votre région.',
    'additional_key__main_key' => 'Clé correspondant à la clé principale : vous ne pouvez pas envoyer la clé principale en tant que clé supplémentaire.',

    'gch__hosting_waf_rule_engine' => 'Mode du pare-feu applicatif',

    'backup__fieldset__restoration_options' => 'Options de restauration',
    'backup__restore_options__restore' => 'Restaurer',
    'backup__restore_options__domain__domain_configuration' => 'Configuration du domaine',
    'backup__restore_options__domain__virtual_host_content' => 'Contenu de l\'hôte virtuel',
    'backup__restore_options__domain__mail' => 'Boîte mail',
    'backup__restore_options__domain__databases' => 'Bases de données',
    'backup__restore_options__client__client_configuration' => 'Configuration du compte client',
    'backup__restore_options__client__domains' => "Domaines du client",
    'backup__restore_options__reseller__reseller_configuration' => 'Configuration du compte revendeur',
    'backup__restore_options__reseller__personal_domains' => "Domaines du revendeur",
    'backup__restore_options__reseller__clients' => "Clients du revendeur",
    'backup__restore_options__admin__server_configuration' => 'Paramètres du serveur',
    'backup__restore_options__admin__administrator_configuration' => 'Configuration du compte administrateur',
    'backup__restore_options__admin__personal_domains' => "Domaines de l'administrateur",
    'backup__restore_options__admin__personal_clients' => "Clients de l'administrateur",
    'backup__restore_options__admin__resellers' => 'Revendeurs',

    'badge_new' => 'Nouveau',
    'upgrade_php_on_subscription' => 'Mettez à niveau PHP dans votre abonnement vers la version 5.3.0 ou une version ultérieure.',

    'pkey_notify__body_expiration_notification' => 'La clé de licence a expiré. Certaines fonctions ne sont peut-être pas disponibles. Veuillez contacter votre hébergeur.',

    'crontab__crontab_entry_exists' => "La tâche planifiée existe déjà.",
    'crontab__crontab_entry_not_exists' => "La tâche planifiée n'existe pas.",
    'crontab__invalid_values_found' => "Valeurs de paramètres incorrectes.",
    'crontab__cmd_max_len' => "La commande ne peut pas contenir plus de %1 caractères.",

    'domain__domain_exists' => "Il y a un domaine avec le préfixe 'www' et le même nom : %1.%2.",
    'domain__subdomain_exists' => "Il y a un sous-domaine avec le préfixe 'www' et le même nom : %1.%2.",
    'domain__dalias_exists' => "Il y a un alias de domaine avec le préfixe 'www' et le même nom : %1.%2.",
    'domain__record_exists' => "Il existe un enregistrement DNS vers l'hôte %1.%2.",

    'ip_addr__cannot_assign_certificate' => "Impossible de définir le certificat '%1' comme certificat par défaut : la clé privée manque.",
    'ip_addr__update_dns_error' => 'Des problèmes se sont produits pendant la mise à jour de l\'adresse IP dans les zones DNS. %1',
    'ip_addr__cannot_add_dhcp_enabled' => 'Impossible d\'ajouter l\'adresse IP. Cette interface réseau récupère automatiquement les adresses IP.',
    'ip_addr__cannot_remove_dhcp_enabled' => 'Impossible de supprimer l\'adresse IP %1. Cette interface réseau récupère automatiquement les adresses IP.',
    'ip_addr__cannot_repair_dhcp_enabled' => 'Impossible de réparer l\'adresse IP %1. Cette interface réseau récupère automatiquement les adresses IP.',
    'ip_addr__cannot_change_interface_dhcp_enabled' => 'Impossible de changer l\'interface de l\'adresse IP %1, car l\'interface réseau %2 récupère automatiquement les adresses IP.',

    'shm_lmsg__limit_for_resource_exceeded' => 'La limite de l\'abonnement pour le nombre de %%type%% est dépassée. La limite actuelle est %%limit%% ; %%usage%% sont utilisés.',
    'shm_lmsg__resource_is_forbidden_for_creation' => 'La création de %%type%% n\'est pas autorisée pour cet abonnement.',
    'shm_lmsg__resource_title__db-mysql' => 'Bases de données MariaDB/MySQL',
    'shm_lmsg__resource_title__db-mssql' => 'Bases de données MS SQL',
    'shm_lmsg__resource_title__db-postgresql' => 'Bases de données PostgreSQL',
    'shm_lmsg__resource_title__db-user' => 'Utilisateurs de BD',
    'shm_lmsg__resource_title__iis-application-pool' => 'Pools d\'applications IIS',
    'shm_lmsg__resource_title__additional-ftp-account' => 'Comptes FTP supplémentaires',

    'db_user_unable_remove_mysql_global_privileges' => 'Impossible de supprimer les privilèges globaux MariaDB/MySQL de l\'utilisateur de base de données %1. Raison : %2',
    'report__client_description' => 'Description',

    'db__user_role_error' => 'Un rôle d\'utilisateur de la base de données incorrect a été indiqué : %1. Choisissez l\'un des rôles suivants : %2.',

    'subscription_unable_to_set_max_filesize_warning' => 'Impossible de définir la taille limite du fichier pour les bases de données Microsoft SQL Server, car elles ont une taille de fichier supérieure : %1.',
    'subscription_unable_to_set_max_log_filesize_warning' => 'Impossible de définir la taille limite du fichier pour les bases de données Microsoft SQL Server suivantes, car elles ont une taille de fichier journal supérieure : %1.',
    'ipaddress__cannot_set_up_public_ip_need_ipaddress' => 'Impossible de configurer une adresse IP publique : une adresse IP privée doit exister.',
    'ipaddress__cannot_set_up_public_ip_need_ipv6' => 'Impossible de configurer une adresse IPv4 pour l\'adresse IPv6.',
    'ipaddress__cannot_set_up_public_ip_need_ipv4' => 'Impossible de configurer une adresse IPv6 pour l\'adresse IPv4.',
    'ipaddress__cannot_set_up_public_ip_invalid' => 'Impossible de configurer une adresse IP publique : adresse IP non valide.',

    '__user_already_exists' => "L'utilisateur %1 existe déjà.",
    '__user_name_is_empty' => "Vous devez préciser un nom d'utilisateur.",

    'upgrade_php_on_domain' => 'Impossible de trouver PHP version 5.3.0 ou ultérieure sur l\'un de vos domaines WordPress. Essayez de mettre à niveau PHP.',

    'component_name__waf' => 'Pare-feu des applications Web',
    'component_name__vcs' => 'Gestion de versions',

    'virtualization_lxc' => 'LXC',
    'virtualization_docker' => 'Docker',
    'possibleSpoofingDetected' => 'Une tentative possible de spoofing a été détectée : le lien que vous avez essayé d\'afficher présente un contenu non pertinent.',
    'forceResetPasswordUpdated' => 'Votre mot de passe a été modifié. Utilisez le nouveau mot de passe pour vous connecter à Plesk.',

    'php_handlers_error_no_available_instance' => 'Impossible de créer un sous-domaine : il n\'y a aucun gestionnaire PHP disponible.',
    'domain_error_unable_to_apply_hosting_settings' => 'Impossible d\'appliquer les paramètres d\'hébergement : %1',

    'plesk_not_configured' => 'Plesk n\'est pas configuré. Allez dans le Panneau de contrôle afin de procéder à la configuration post-installation.',
    'cmd_mail__mail_password_duplicated' => 'Cette combinaison adresse mail / mot de passe existe déjà sur le serveur de messagerie. Veuillez indiquer une autre adresse mail ou un autre mot de passe.',

    'extensionRequirementOs' => 'Le système d\'exploitation (%1) n\'est pas pris en charge par le pack.',
    'extensionRequirementPleskMinVersion' => 'Plesk %1 est la première version prise en charge par le pack.',
    'extensionRequirementPleskMaxVersion' => 'Aucune version à partir de Plesk %1 n\'est prise en charge par le pack.',
    'extensionBlacklisted' => 'L\'extension %1 n\'est pas autorisée pour l\'installation.',
    'extensionDisabled' => 'Extension désactivée.',


    'optimization_settings__unable_set_mpm_event' => 'Impossible de définir le mode mpm_event : le module Apache PHP5 est activé mais ce module est utilisé par les domaines.',
    'optimization_settings__unable_turn_off_php' => 'Impossible de désactiver le module Apache PHP5 : il est utilisé par les domaines.',

    'hst_def__fp_admin_login' =>  'Nom d\'utilisateur FTP',
    'hst_def__fp_admin_passwd' =>  'Mot de passe FTP',

    'database_user_orphaned_old_password_wrong' => "Impossible de réparer l'utilisateur orphelin '%1' : mot de passe incorrect.",
    'cannot_load_partner_central_property_key_no_exist' => "Impossible de récupérer les propriétés personnalisées : clé de licence inexistante.",
    'extensionScriptFailure' => "L'exécution de %1 a échoué avec le message suivant :\n%3",
    '__ssl_redirect' => "Redirection 301 permanente (SEO vérifié) de HTTP vers HTTPS",
    'component_name__dotnetcore' => '.NET Core',
    'mail__dkim_not_supported' => 'Gestion DKIM non prise en charge.',
    'mail__dmarc_not_supported' => 'Gestion DMARC non prise en charge en charge.',
    'mail__relay_white_list_not_supported' => 'Gestion avec relais de liste blanche non prise en charge.',
    'mail__black_list_not_supported' => 'Gestion des listes noires non prise en charge.',
    'mail__autoresponder_not_supported' => 'Gestion avec réponse automatique non prise en charge.',
    'defaultcomponents__not_supported_version' => '(version non prise en charge)',
    'component_name__nodejs' => 'Node.js',

    'certificate__not_found' => 'Certificat \'%1\' introuvable.',
    'certificate__unable_setup_certificate' => 'Impossible d\'installer le certificat : les contenus du certificat et de la clé privée manquent.',
    'certificate__used_by_panel' => 'L\'un des certificats que vous allez supprimer est utilisé pour la sécurité de Plesk.',
    'certificate__used_by_mail_server' => 'L\'un des certificats que vous allez supprimer est utilisé pour la sécurité du serveur de messagerie.',
    'certificate__used_by_domain_service' => 'L\'un des certificats que vous allez supprimer est utilisé par un service de domaine.',
    'mail_server__not_installed' => 'Impossible d\'installer le certificat pour le serveur de messagerie car ce dernier n\'est pas installé.',

    'email_activation_mail_subject' => 'Veuillez activer votre compte dans Plesk.',
    'email_activation_mail_body' => "Un compte a été créé sur le serveur Plesk %1\n\nDétails du compte :\nNom : %2\nAdresse mail : %3\n\nSi cette information est correcte et si ce compte a été créé pour vous, veuillez l'activer à l'aide du lien suivant :\n\n%4\n\nEn activant ce compte, vous autorisez le propriétaire du serveur à recueillir, traiter et utiliser vos données personnelles (noms et adresse e-mail) pour créer et prendre en charge votre compte, conformément aux lois applicables sur la protection des données actuellement en vigueur, en tant qu'élément d'un contrat.",

    'backup_transport_permission_name' => 'Gestion %1',
    'backup_transport_permission_description' => 'Autorise l\'utilisation de %1 pour stocker les sauvegardes.',

    'domain_move_err_target_no_hosting' => 'Impossible de déplacer le domaine vers un abonnement sans hébergement.',
    'domain_move_err_already_in_target' => 'Le domaine appartient déjà à l\'abonnement cible.',
    'domain_move_err_main_domain' => 'Le domaine principal ne peut être déplacé.',
    'domain_move_err_subdomain_without_parent' => 'Impossible de déplacer le sous-domaine %1 sans le domaine parent %2.',
    'domain_move_err_root_exists' => 'Le chemin cible de www_root %1 existe déjà.',
    'domain_move_err_nested_roots' => 'Impossible de déplacer le domaine car il partage le document root avec un autre domaine : %1.',
    'domain_move_err_no_mail_service' => 'Impossible de déplacer le domaine car le service de messagerie est désactivé sur l\'abonnement cible.',
    'domain_move_err_app' => "L'application installée sur %1 n'a pas été déplacée vers l'abonnement '%2' : %3",
    'domain_move_database_used_by_app' => "La base de données '%1' sur %2 est utilisée par l'application déplacée. Pour réaffecter la base de données à '%3', exécutez \" plesk bin database --assign-to-subscription \"",
    'domain_move_target_locked' => "La synchronisation de l'abonnement cible '%1' est verrouillée.",
    'domain_move_filesharing_disabled' => 'Partage de fichiers désactivé.',
    'domain_move_website_preview_disabled' => 'Aperçu du site Web désactivé.',
    'domain_move_additional_webserver_settings' => "Vérifiez les autres directives du serveur Web pour éviter tout problème de configuration.",
    'domain_move_no_permission' => "%1 n'est pas autorisé pour l'abonnement '%2'.",
    'domain_move_no_access' => "Pas d'accès à l'abonnement '%1'.",
    'domain_split_no_create_permission' => "La création du domaine n'est pas autorisée.",
    'domain_split_empty_login' => 'La connexion de l\'utilisateur système est nécessaire.',
    'domain_split_empty_password' => 'Le mot de passe de l\'utilisateur système est nécessaire.',
    'domain_split_err_home_exists' => 'Le domaine %1 ne peut pas être déplacé car son chemin d\'accès cible existe déjà en %2. Renommez le domaine pour le déplacer vers un nouvel abonnement.',
    'domain_split_err_no_hosting_subdomains' => 'Le domaine ne peut pas être déplacé vers un nouvel abonnement car le domaine n\'a pas d\'hébergement mais possède des sous-domaines. Pour déplacer le domaine, changez sa valeur "Type d\'hébergement" en "Hébergement de site web" (dans les paramètres d\'hébergement).',
    'domain_split_target_locked' => "L'abonnement cible '%1' est verrouillé pour synchr.",
    'domain_split_target_unsynced' => "L'abonnement cible '%1' n'était pas synchronisé avec le plan en raison de : %2.",
    'domain_merge_scheduled_backup_deactivated' => "La sauvegarde planifiée a été désactivée sur '%1'.",
    'domain_merge_database_error' => "La base de données '%1' installée sur %2 n'a pas été déplacée vers l'abonnement '%3': %4",
    'domain_merge_anon_ftp_deactivated' => "FTP anonyme sur '%1' était désactivé.",
    'domain_merge_smb_user_access' => "L'utilisateur supplémentaire '%1' a été déplacé vers l'abonnement '%2' mais l'accès de l'utilisateur à l'abonnement a été annulé.",
    'domain_merge_scheduled_tasks' => "Les tâches planifiées ont été déplacées vers l'abonnement cible. Revoir la configuration des tâches.",
    'domain_merge_scheduled_tasks_deactivated' => "Les tâches planifiées ont été déplacées vers l'abonnement cible et désactivées. Revoir la configuration des tâches.",
    'domain_merge_no_remove_permission' => "La suppression de l'abonnement n'est pas autorisée.",
    'domain_merge_err_has_addons' => 'Impossible de déplacer le domaine principal avec ses domaines supplémentaires ; déplacer le(s) domaine(s) %1 en premier.',
    'domain_merge_err_has_webusers' => 'Impossible de déplacer le domaine principal avec ses utilisateurs Web.',
    'domain_merge_err_root_exists' => 'Le chemin cible %1 existe déjà.',

    'database_server_edit_used_for_psa' => 'La mise à jour du serveur de base de données MariaDB/MySQL locale n\'est pas autorisée.',
    'suggest_repair_main_suggestion_ui' => '<b>Vous pouvez fixer cette erreur</b> à l\'aide de l\'utilitaire `plesk repair`.',
    'suggest_repair_main_suggestion_cli' =>  'Vous pouvez fixer cette erreur à l\'aide de l\'utilitaire `plesk repair`.',
    'suggest_repair_repair_kit_link_title' => 'allez dans Diagnostiquer et réparer',
    'suggest_repair_using_cli_and_ui' => 'Pour ce faire, exécutez la commande `plesk repair %1` via la CLI ou %2 et cliquez sur Réparer à côté de "Base de données Plesk".',
    'suggest_repair_using_cli' => 'Pour ce faire, exécutez la commande `plesk repair %1` via la CLI.',

    'backup__restore__capability_duplicate_php_handler_resolution' => '',
    'bu_conflict_resolver_dns_not_available' => 'Le service DNS n\'était pas disponible lorsque la sauvegarde a été créée. Toutefois, il y a des zones DNS actives dans la sauvegarde et elles seront autorisées pour les objets suivants : {{objects}}.',
    'plesk_key__system-resources-limits-enabled' => 'Contrôleur de ressources (cgroups)',
    'plesk_key__remote-smartermail-enabled' => 'Prise en charge de SmarterMail à distance',
    'plesk_key__complete-backup-solution' => 'Backup to Cloud Pro',
    'defaultcomponents__no_license' => '(Non autorisé par la clé de licence)',
    'plesk_key__validation_failed' => '%1(Code d\'erreur : %2)',
    'promo__button_details' => 'Détails',
    'promo__extension_catalog_title' => 'Catalogue des extensions',
    'promo__extension_catalog_description' => 'Consultez le nouveau catalogue des extensions et boostez Plesk avec toute une gamme d\'extensions puissantes !',
    'promo__button_open_catalog' => 'Ouvrir le catalogue',

    'backup__repository_check_login' => "Impossible d'accéder au stockage : %1 Assurez-vous d'avoir saisi les identifiants de stockage exacts.",
    'backup__repository_check_error_list' => "Impossible d'accéder au stockage : %1 Assurez-vous d'avoir saisi les paramètres de stockage exacts.",
    'backup__repository_check_error_mkdir' => "Impossible de créer le répertoire : %1 Vérifiez si vous disposez du droit de créer des dossiers dans le stockage.",
    'backup__repository_check_error_upload' => "Impossible de téléverser les fichiers vers le stockage : %1 Vérifiez si vous disposez du droit de téléverser des fichiers vers le stockage.",
    'backup__repository_check_error_download' => "Impossible de télécharger le fichier depuis le stockage : %1 Vérifiez si vous disposez du droit de téléverser et de télécharger les fichiers vers et depuis le stockage.",
    'backup__repository_check_error_resume-upload' => "Impossible de reprendre le téléversement de fichiers vers le stockage : %1 Vérifiez si vous disposez du droit de reprendre les téléversements vers le stockage.",
    'backup__repository_check_error_resume-download' => "Impossible de reprendre le téléchargement du fichier depuis le stockage : %1 Vérifiez si vous disposez du droit reprendre les téléchargements depuis le stockage.",
    'backup__repository_check_error_enable-utf8' => "Impossible de procéder au stockage : %1 Vérifiez si le stockage prend en charge l'encodage UTF-8.",
    'backup__repository_check_error_rm' => "Impossible de procéder au stockage : %1 Vérifiez si vous disposez du droit de supprimer des fichiers du stockage.",
    'backup__repository_check_error_rmdir' => "Impossible de procéder au stockage : %1 Vérifiez si vous disposez du droit de supprimer des dossiers du stockage.",

    'backup__ftp_repository_check_login' => "%1 Vous pouvez vérifier indépendamment à l'aide de la commande : %2",
    'backup__ftp_repository_check_error_list' => "%1 Vous pouvez vérifier indépendamment à l'aide de la commande : %2",
    'backup__ftp_repository_check_error_mkdir' => "%1 Vous pouvez vérifier indépendamment à l'aide de la commande : %2",
    'backup__ftp_repository_check_error_upload' => "%1 Vous pouvez vérifier indépendamment à l'aide des commandes : %2 %3",
    'backup__ftp_repository_check_error_download' => "%1 Vous pouvez vérifier indépendamment à l'aide des commandes : %2 %3",
    'backup__ftp_repository_check_error_resume-upload' => "%1 Vous pouvez vérifier indépendamment à l'aide des commandes : %2 %3 %4",
    'backup__ftp_repository_check_error_resume-download' => "%1 Vous pouvez vérifier indépendamment à l'aide des commandes : %2 %3",
    'backup__ftp_repository_check_error_enable-utf8' => "%1 Vous pouvez vérifier indépendamment à l'aide de la commande : %2",
    'backup__ftp_repository_check_error_rm' => "%1 Vous pouvez vérifier indépendamment à l'aide des commandes : %2 %3",
    'backup__ftp_repository_check_error_rmdir' => "%1 Vous pouvez vérifier indépendamment à l'aide des commandes : %2 %3",

    'sfdmarc_server_wide_enable_failed' => 'Impossible de modifier les paramètres de DMARC. Pour activer cette option, désactivez la protection antispam DKIM et SPF.',
    'spf_server_wide_disable_failed' => 'Impossible de modifier les paramètres de protection antispam SPF. Pour désactiver SPF, désactivez DMARC pour les mails entrants.',
    'sfdk_server_wide_verify_disable_failed' => 'Impossible de modifier les paramètres de protection antispam DKIM. Pour désactiver DKIM, désactivez DMARC pour les mails entrants.',

    'ccs_not_supported' => 'IIS Central Certificate Store n\'est pas configuré dans le système.',
    'ccs_not_enabled' => 'La gestion IIS Central Certificate Store n\'est pas activée dans Plesk.',
    'ad_not_supported' => 'Le serveur n\'est associé à aucun domaine.',

    'component_name__appinit' => "Initialisation de l'application",
    'component_name__cors' => "Cross-Origin Resource Sharing",
    'component_name__httpcompression' => 'Compression de contenu HTTP',
    'common_feature_is_not_supported' => 'Cette fonctionnalité n\'est plus prise en charge.',
    'common_feature_is_not_supported_in_proto' => 'Cette fonctionnalité n\'est plus prise en charge pour la version du protocole %1.',
    'autoinstaller__plesk_component' => 'Composant Plesk',
    'plesk_key__key_expired' => 'Votre clé de licence a expiré. Pour continuer à utiliser Plesk, achetez une %1 commerciale qui n\'expire pas.',
    'plesk_key__key_purchase' => 'clé de licence',

    'sa_action_move' => 'Déplacer le spam dans le dossier "Indésirables"',

    'bu_conflict_resolver_tomcat_not_supported' => 'Les applications Java ne sont plus prises en charge. Elles ne seront pas disponibles pour les sites Web suivants : {{objects}}.',
    'bu_conflict_resolver_unity_mobile_not_supported' => 'Les versions mobiles des sites Web hébergées avec UNITY Mobile ne sont plus prises en charge. Elles ne seront pas disponibles pour les sites Web suivants : {{objects}}.',
    'bu_conflict_resolver_antivirus_personal_management_not_allowed' => 'La politique d\'utilisation au niveau du serveur n\'autorise pas les paramètres antivirus personnels. Ils seront restaurés partiellement pour les comptes de messagerie sur les domaines suivants : {{objects}}.',

    'module__not_installed' => "L'extension %1 n'est pas installée.",

    'mail__mail_autodiscovery_server_error' => 'Spécifiez un nom de domaine personnalisé pour la découverte automatique du courrier.',
    'mail__error_mail_autodiscovery_enable' => 'Impossible de paramétrer la découverte automatique du courrier : %1',
    'mail__error_mail_autodiscovery_server' => 'Impossible de définir un nom de domaine personnalisé pour la découverte automatique du courrier : %1',
    'mail__error_mail_autodiscovery_reconfigure_dns' => 'Impossible de reconfigurer les enregistrements DNS de la découverte automatique des domaines : %1',

    'mail__smarthost_not_configured_error' => 'Aucun hôte intelligent n\'est configuré.',
    'mail__smarthost_attach_domains_error' => 'L\'association des domaines à l\'hôte intelligent a terminé avec des erreurs :',

    '__invalid_url' => 'L\'URL "%1" n\'est pas valide',
    'actionlog__cloning_start' => 'démarrer',
    'actionlog__event_cloning_start' => 'Démarrage du clonage du serveur',

    '__UPLOAD_ERR_FORM_SIZE' => "La taille du fichier chargé dépasse la limite autorisée",
    '__UPLOAD_ERR_INI_SIZE' => "La taille du fichier chargé dépasse la limite autorisée",
    '__UPLOAD_ERR_NO_FILE' => "Aucun fichier reçu",
    '__UPLOAD_ERR_OK' => "Fichier a été chargé correctement",
    '__UPLOAD_ERR_PARTIAL' => "Fichier n'a été chargé que partiellement. Veuillez re-essayer",
    '__UPLOAD_ERR_NO_TMP_DIR' => 'Il n\'y a pas de dossier temporaire.',
    '__UPLOAD_ERR_CANT_WRITE' => 'Le fichier n\'a pas pu être écrit sur le disque',
    '__UPLOAD_ERR_UNKNOWN' => 'Une erreur d\'envoi du fichier inconnu s\'est produite',
    '__accounts' => "Comptes",
    '__access' => "Accès",
    '__address' => "Adresse",
    '__addresses' => "Adresses",
    '__acl_records' => 'Enregistrements ACL',
    '__admin_repository' => "Référentiel de l'administrateur",
    '__all' => 'Tout',
    '__allowed' => "Autorisé",
    '__anonftp_status' => "FTP anonyme",
    '__antispam' => "Anti-spam",
    '__apache_restart' => "...%1 est en cours de redémarrage, veuillez patienter...",
    '__asp' => "Microsoft ASP",
    '__asp_dot_net' => "Microsoft ASP.NET",
    '__asp_dot_net_support' => "Prise en charge de Microsoft ASP.NET",
    '__asp_win_support' => "Prise en charge de Microsoft ASP",
    '__attachments' => "Pièces jointes",
    '__attachments_list' => "Pièces jointes",
    '__author' => 'Auteur',
    '__autoresp_name_already_exists' => "La réponse automatique portant le nom %1 existe déjà.",
    '__autoresponder' => "Réponse automatique",
    '__autoresponders' => "Réponses automatiques",
    '__autoresponders_list' => "Réponses automatiques",
    '__autoresponder_attachment_files' => "Fichiers en pièces jointes de la réponse automatique",
    '__auto_updates_list' => 'Mises à jour disponibles',
    '__avail' => "Disponible",
    '__backup_utilites' => "Utilitaires de sauvegardes",
    '__bind_status' => "Statut du serveur DNS",
    '__bu_is_not_installed' => "Ce service n'est pas disponible actuellement, parce que l'utilitaire de sauvegarde n'est pas installé.",
    '__bu_not_support_in_key' => "La fonction Sauvegarde n'est pas prise en charge par la licence.",
    '__notifications_not_support_in_key' => 'Les notifications ne sont pas prises en charge par la clé de licence',
    'disabled_by_key' => 'Non pris en charge par la clé de licence',
    '__bytes' => "octets",
    '__can_not_use_reserved_words' => "Vous ne pouvez pas utiliser de mots réservés.",
    '__certificate' => "Certificat",
    '__cgi_support' => "Prise en charge de CGI",
    '__city' => "Ville",
    '__cl_not_exist' => "Le compte client n'existe pas.",
    '__client' => 'Client',
    '__client_card' => "Carte du client",
    '__client_contact_name' => "Nom du contact client",
    '__client_form' => "Informations personnelles",
    '__client_ip_pool' => "Pool d'IP du client",
    '__client_limits' => "Limites du compte client",
    '__client_permissions' => "Droits du client",
    '__client_preferences' => "Préférences du client",
    '__client_status' => "Statut du client",
    '__client_name' => "Nom des clients",
    '__client_total' => "Nombre total de clients",
    '__client_with_login_name_already_exists' => "Un utilisateur portant ce nom d'utilisateur \"%1\" existe déjà.",
    '__client_domuser_with_login_already_exists' => "Le nom d'utilisateur '%1' est déjà utilisé par l'administrateur du domaine '%1'.",
    '__clients_global_changes' => "Modifier les comptes client sélectionnés",
    '__clients_list' => "Clients",
    '__cmd_not_found' => "Commande inconnue: %1",
    '__comments' => "Commentaires",
    '__company_name' => "Raison sociale",
    '__component_version' => "Version du composant",
    '__component_not_installed' => "Le composant %1 n'a pas été installé",
    '__confirm_overwrite' => "Confirmez l'écrasement.",
    '__confirm_stop' => "Vous devez confirmer l'arrêt de l'opération.",
    '__confirm_passwd' => "Confirmer le mot de passe %1",
    '__conhelp' => "Description",
    '__contact_name' => "Nom du contact",
    '__country' => "Pays",
    '__countries' => 'Pays',
    '__country_unknown' => 'Impossible de reconnaître le code du pays.',
    '__courier-imap' => 'Serveur Courier',
    '__create_domain' => 'Créer un domaine',
    '__crypted' => 'crypté',
    '__cp_access' => "Accès à Plesk",
    '__cp_user' => "Utilisateur Plesk",
    '__create' => "Créer",
    '__create_client_template_without_template' => "Créer un compte utilisateur sans template",
    '__create_domain_for' => "Créez un domaine pour <b>%1</b>",
    '__create_domain_template_without_template' => "Créer un domaine sans template",
    '__creation_date' => "Date de création",
    '__crontab_unix' => "Planificateur",
    '__crontab_win' => "Planificateur",
    '__ct_month_jan' => 'Janvier',
    '__ct_month_feb' => 'Février',
    '__ct_month_mar' => 'Mars',
    '__ct_month_apr' => 'Avril',
    '__ct_month_may' => 'Mai',
    '__ct_month_jun' => 'Juin',
    '__ct_month_jul' => 'Juillet',
    '__ct_month_aug' => 'Août',
    '__ct_month_sep' => 'Septembre',
    '__ct_month_oct' => 'Octobre',
    '__ct_month_nov' => 'Novembre',
    '__ct_month_dec' => 'Décembre',
    '__custom_button' => "Boutons personnalisés",
    '__custom_buttons_list' => "Liens vers d'autres services",
    '__daily' => "Ts les jours",
    '__database_not_activated' => "%1 n'a pas été activé sur la page d'administration du serveur.",
    '__database_not_installed' => "La base de données %1 n'est pas installée.",
    '__database_not_run' => "La base de données %1 n'est pas active.",
    '__database_is_corrupt' => "La base de données de Plesk est corrompue. Veuillez lancer l'utilitaire Reconfigurator pour résoudre le problème.",
    '__databases' => "Bases de données",
    '__databases_list' => "Bases de données",
    '__database_type_not_supported_by_key' => 'Pour utiliser un serveur %1, votre clé de licence doit le prendre en charge. Veuillez contacter votre représentant commercial Plesk.',
    '__date_immediately' => "Aujourd'hui",
    '__date_never' => "Jamais",
    '__day(s)' => "jour(s)",
    '__day0' => "Dim",
    '__day1' => "Lun",
    '__day2' => "Mar",
    '__day3' => "Mer",
    '__day4' => "Jeu",
    '__day5' => "Ven",
    '__day6' => "Sam",
    '__days' => "%1 jour(s)",
    '__db_admin_login_empty' => "Vous avez entré un nom d'utilisateur vide ce qui désactive le contrôle sur %1 dans l'interface. Voulez-vous continuer ?",
    '__db_unable_to_unregister' => 'Impossible de supprimer les paramètres de la connexion à la base de données',
    '__db_db_exists' => 'Il y a au moins une base de données sur le serveur.',
    '__db_unable_to_change_server_name' => 'Il n\'est pas possible de changer le nom du serveur',
    '__db_unable_to_change_port' => 'Il n\'est pas possible de changer le port pour le serveur',
    '__db_already_exist' => "La base de données %1 existe déjà.",
    '__db_credentials_invalid' => "Les données d'accès pour la base de données sont incorrectes.",
    '__db_invalid_password_characters' => 'Le mot de passe contient des caractères non valides.',
    '__db_engine' => "Moteur de base de données", // indirect
    '__db_type' => "Type de base de données",
    '__db_user' => "Utilisateur de BD",
    '__db_server' => 'Serveur de bases de données',
    '__def_domain' => "Domaine par défaut",
    '__default_for_mysql' => 'Par défaut pour MySQL',
    '__default_for_mariadb' => 'valeurs par défaut de MariaDB',
    '__default_for_percona' => 'valeurs par défaut de Percona',
    '__default_for_postgresql' => 'Par défaut pour PostgreSQL',
    '__delete' => "Supprimer",
    '__demo' => "Cette fonction n'est pas disponible dans la version démo.",
    '__directory' => "Répertoire",
    '__disable_lock_screen' => 'Empêcher les utilisateurs d\'utiliser Plesk jusqu\'au chargement complet des écrans de l\'interface',
    '__dismiss_news?' => "Voulez-vous vraiment fermer complètement le bloc des news ?\n\nSi vous faites cela, vous ne pourrez plus voir les news jusqu'à ce qu'il y en ait de nouvelles.",
    '__description' => "Description",
    '__disabled' => "Désactivé",
    '__disk_space_limit' => "Limite de l'espace disque",
    '__cgroups_cpu_usage_limit' => 'Limite de l\'utilisation du CPU',
    '__cgroups_ram_usage_limit' => 'Limite d\'utilisation RAM',
    '__cgroups_disk_read_usage_limit' => 'Volume limite de lecture de disque',
    '__cgroups_disk_write_usage_limit' => 'Volume limite d\'écriture sur le disque',
    '__disk_usage_by' => "Espace disque utilisé par %1",
    '__dns' => "DNS",
    '__dns_record_already_exist' => "L'enregistrement DNS '%1' existe déjà.",
    '__dns_master_should_be_remote' => "Il vous faut deux serveurs de noms d'autorité distincts sur des hôtes séparés.",
    '__dns_record_not_exist' => "Enregistrement DNS n'existe pas.",
    '__dns_server' => "Serveur DNS", // indirect
    '__dom_id_is_undefined' => "L'ID du domaine n'est pas défini.",
    '__dom_name' => "Nom de domaine",
    '__dom_name_is_invalid' => "Le nom de domaine est incorrect. Vérifiez que le nom de votre domaine comprend uniquement des caractères alphanumériques, des points et des tirets et ne dépasse pas 255 caractères en tout. Les parties du nom de domaine comprises entre les points ne doivent pas faire plus de 63 caractères.",
    '__dom_not_exist' => "Domaine inexistant.",
    '__domain' => "Domaine",
    '__domain_' => 'Domaine %1',
    '__domain_form' => "Form. domaine",
    '__domain_id' => "ID du domaine",
    '__domain_is_turned_off_for_backup' => "Le site Web %1 est temporairement désactivé pour des raisons de sauvegarde ou de restauration et est actuellement indisponible.",
    '__domain_limits' => "Limites du domaine",
    '__domain_name' => "Nom de domaine",
    '__mail_name_in_ASCII_form' => "Nom du compte mail au format ASCII",
    '__message_error' => 'Erreur',
    '__message_warning' => 'Avertissement',
    '__message_info' => 'Informations',
    '__domain_name_in_ASCII_form' => "Nom de domaine au format ASCII",
    '__domain_repository' => "Référentiel du domaine %1",
    '__domain_status' => "Statut du domaine",
    '__domain_found_tech' => "Technologie trouvée sur le domaine",
    '__domain_dns' => 'Zone DNS du domaine',
    '__domain_total' => "Volume total de l'abonnement",
    '__domain_total_powerUser' => "Volume total de l'abonnement",
    '__domain_user' => "Administrateur du domaine",
    '__domains_global_changes' => "Groupe d'opérations sur des domaines",
    '__mailnames_global_changes' => "Groupe d'opérations sur des comptes mail",
    '__backup_manager' => 'Gestionnaire de sauvegardes',
    '__domains_list' => "Domaines",
    'domains_list__list_header' => "domaines",
    //this is a part of phrases like No domains (and others), so it should not be capitalized
    '__double_www_warning' => "Le nom de domaine commence par www bien que c'est le préfixe WWW qui est utilisé. Continuer quand même ?",
    '__dovecot' => 'Serveur Dovecot IMAP et POP3',
    '__dsmail' => "Service de messagerie",
    '__dsmaillist' => "Service liste de diffusion",
    '__dumps_tot_size' => "Taille totale des fichiers de sauvegarde dans le stockage local",
    '__email' => "Adresse mail",
    '__email_addr_is_invalid' => "L'adresse mail est incorrecte.",
    '__enabled' => "Activé(e)",
    '__enter_cert_text' => "Entrer le texte du certificat",
    '__enter_size' => "Saisir une valeur",
    '__exclusive' => "Dédiée",
    '__expiration_date' => "Date d'expiration",
    '__fax' => "Fax",
    '__file' => "Fichier",
    '__file_is_empty' => "Le fichier est vide.",
    '__file_name' => "Nom du fichier",
    '__file_type' => 'Type de fichier',
    '__filemanager' => "Gestionnaire de fichiers",
    '__filepath_is_empty' => "Le chemin du fichier est vide",
    '__files_list' => "Fichiers",
    '__frontpage' => "Microsoft FrontPage",
    '__ftp' => "FTP", // +indirect
    '__ftp_settings' => "Paramètres FTP",
    '__ftp_serv' => "Serveur FTP", // indirect
    '__ftp_server_parameters_are_empty' => "Vous devriez d'abord paramétrer les propriétés de compte FTP !",
    '__ftp_status' => "Statut du serveur FTP",
    '__full_day0' => "Dimanche",
    '__full_day1' => "Lundi",
    '__full_day2' => "Mardi",
    '__full_day3' => "Mercredi",
    '__full_day4' => "Jeudi",
    '__full_day5' => "Vendredi",
    '__full_day6' => "Samedi",
    '__full_month1' => "Janvier",
    '__full_month10' => "Octobre",
    '__full_month11' => "Novembre",
    '__full_month12' => "Décembre",
    '__full_month2' => "Février",
    '__full_month3' => "Mars",
    '__full_month4' => "Avril",
    '__full_month5' => "Mai",
    '__full_month6' => "Juin",
    '__full_month7' => "Juillet",
    '__full_month8' => "Août",
    '__full_month9' => "Septembre",
    '__giga' => "G",
    '__h' => "H",
    '__hard_disk_quota' => "Quota dur de disque",
    '__hard_disk_quota_not_supported' => 'le quota dur de disque n\'est pas pris en charge en raison de la configuration du système de fichiers du serveur',
    '__help_topic_not_found' => 'Le sujet d\'aide (%1) que vous demandez n\'existe pas.',
    '__hosting_ip_dns_ip_not_equiv' => "Aucune des adresses IP indiquées dans les enregistrements DNS A concordent avec l'adresse IP utilisée pour l'hébergement.",
    '__hosting_scripting' => "Prise en charge de scripts pour l'hébergement",
    '__hosting_setup_page_title' => "Config. hébergement physique pour le domaine %1",
    '__hosting_title' => "Hébergement (%1)",
    '__hosting_type' => "Type d'hébergement",
    '__hostname_is_empty' => "Le nom d'hôte est vide.",
    '__hour(s)' => 'Heure(s)',
    '__hst_type_incorrect' => "Le type d'hébergement est incorrect.",
    '__http' => "HTTP", //indirect
    '__htype' => "H",
    '__idle_time' => "Période d'inactivité",
    '__iface' => "Interface",
    '__image' => "Image",
    '__imap_status' => "Statut du serveur IMAP",
    '__in' => "En",
    '__in_%' => "en %",
    '__incorrect_databases_login_pass' => "Les données d'accès que vous avez indiqué pour accéder à PostgreSQL sont incorrectes.",
    '__incorrect_ip_or_network_address' => 'Adresse IP ou réseau incorrecte',
    '__info' => 'Infos',
    '__install' => "Installer",
    '__install_prefix' => "Préfixe d'installation",
    '__invalid_cert_id' => "ID du certificat incorrect",
    '__invalid_context' => "Contexte incorrect : %1",
    '__invalid_db_usr_name' => "Le nom de l'utilisateur de la BD est incorrect.",
    '__invalid_dir_name' => "Le nom du répertoire est incorrect.",
    '__invalid_dom_name' => "Nom de domaine incorrect.",
    '__invalid_filename' => "Nom du fichier incorrect. N'utilisez pas les guillemets simples et/ou \"../\".",
    '__invalid_id' => "Identifiant incorrect.",
    '__invalid_lines_num' => "Valeur inappropriée pour le nombre de lignes, seuls les chiffres sont acceptés.",
    '__invalid_max_letter_size' => "La taille max du message est incorrecte.",
    '__invalid_restart_apache_interval' => "L'intervalle de redémarrage d'Apache est incorrecte.",
    '__invalid_tmpl_name' => "Nom de template non valable.",
    '__invalid_value' => "Valeur incorrecte.",
    '__ip_addr' => "Adresse IP",
    '__ip_address_and_mask' => "Adresse IP et masque de sous-réseau",
    '__ip_alias__mask' => "Adresse IP et masque de sous-réseau",
    '__ip_addr_is_invalid' => "Adresse IP incorrecte.",
    '__ip_addr_list' => "Adresses IP",
    '__ip_address_and_mask_hint' => 'Par exemple, %1',
    '__is_owner' => "P",
    '__java_engine' => "Java", // indirect
    '__jdk' => "JDK",
    '__kb' => "Ko",
    '__kbps' => "KO/s",
    '__kbytes' => "Koctets",
    '__key_for_virtuozzo_only' => "Votre clé de licence est destinée uniquement à une utilisation dans les conteneurs Virtuozzo.",
    '__key_limits_exceeding' => "Cette action dépasse la limite autorisée par votre licence. Si vous voyez ce message, contactez votre fournisseur ou l'éditeur du logiciel pour une discussion ou une révision des limites de votre licence.",
    '__kilo' => "K",
    '__keywords' => 'Mots-clés',
    '__lang_unknown' => 'Impossible de reconnaître la langue.',
    '__languages' => 'Langue',
    '__learn_more' => 'En savoir plus',
    '__loading' => 'Chargement en cours...',
    '__locales' => "Packs de langues",
    '__lists' => "Listes de diffusion",
    '__literal_bytes' => "o",
    '__processing' => "Veuillez patienter.<br>Chargement en cours...",
    '__locale' => "Langue de l'interface",
    '__locale_is_not_defined' => "Langue de l'interface non définie.",
    '__local_server_mysql' => 'Serveur local MariaDB/MySQL',
    '__local_server_postgresql' => 'Serveur local PostgreSQL',
    '__local_server_mssql' => 'Serveur MS SQL local',
    '__log_and_statistics_files' => 'Fichiers de log et rapports statistiques',
    '__config_files' => 'Fichiers de configuration',
    '__chroot_files' => 'Environnement chrooté',
    '__login' => "Nom d'utilisateur %1",
    '__login1' => "Nom d'utilisateur",
    '__login_disabled' => "Accès interdit",
    '__login_enabled' => "Connexion autorisée",
    '__login_incorrect' => "Vous avez entré un mot de passe ou nom d'utilisateur incorrect.",
    '__login_name' => "nom d'utilisateur %1",
    '__login_name_is_invalid' => "le nom d'utilisateur %1 est incorrect.",
    '__logon_time' => "Date/Heure de connexion",
    '__ma' => "Alias de messagerie",
    '__mail' => "Boîte mail",
    '__mail_alias_name' => "Nom de l'alias de messagerie",
    '__mail_autodiscovery' => 'Autodécouverte des mails',
    '__mail_exchanger_name_is_invalid' => "Nom de l'échangeur de mail est incorrect.",
    '__mail_groups' => "Groupes de messagerie",
    '__mail_list_engine' => "Logiciel pour listes de diffusion",
    '__mail_name' => "Compte mail",
    '__mail_name_form' => "Propriétés du compte mail",
    '__mail_names' => "Comptes mail",
    '__mail_serv' => "Serveur de mail",
    '__mail_user' => 'Utilisateur courriel',
    '__mailgroup' => "Groupe mail",
    '__maillist' => "Liste de diffusion",
    '__maillists' => "Listes de diffusion",
    '__maillist_member' => 'Membre de la liste de diffusion',
    '__mailname' => "Compte mail",
    '__mailname_redir_self' => "Le compte mail ne peut pas rediriger le mail vers lui-même.",
    '__max_dom_num_reached_for_cl' => "La limite du nombre de domaines a été atteinte pour ce compte client.",
    '__max_file_size_available' => "Le maximum de taille de fichier est %1",
    '__max_subdom_num_reached_for_cl' => "La limite du nombre de sous-domaines a été atteinte pour ce compte client.",
    '__max_subdom_num_reached_for_dom' => "La limite du nombre de sous-domaines a été atteinte pour le domaine.",
    '__max_subdom_num_reached_for_key' => "La limite du nombre des sous-domaines autorisés par la clé de licence a été atteinte.",
    '__max_traffic_limit' => "Limites du trafic",
    '__maximum_excl_ip_num' => "Comptes mail",
    '__mb' => "Mo",
    '__mbytes' => "Méga-octets",
    '__mb_month' => "Mo/mois",
    '__mb_sec' => "Mo/sec",
    '__gb_sec' => "Go/sec",
    '__tb_sec' => "To/sec",
    '__mega' => "M",
    '__minute(s)' => 'minute(s)',
    '__mls_not_in_key' => "Votre licence ne prend pas en charge l'interface multilingue.",
    '__modification_date' => "Date de modification",
    '__module' => "Extension",
    '__month' => "Mois",
    '__month(s)' => "Mois",
    '__month1' => "Jan",
    '__month10' => "Oct",
    '__month11' => "Nov",
    '__month12' => "Déc",
    '__month2' => "Fév",
    '__month3' => "Mar",
    '__month4' => "Avril",
    '__month5' => "Mai",
    '__month6' => "Juin",
    '__month7' => "Juillet",
    '__month8' => "Aoû",
    '__month9' => "Sept",
    '__monthly' => "Ts les mois",
    '__months' => "mois",
    '__moved_permanently' => 'Déplacé définitivement',
    '__mssql' => "Microsoft SQL Server",
    '__mssql__server' => "Serveur",
    'mssql__server' => "Nom du serveur Microsoft SQL",
    'mssql__unable_to_change_server_name_db_exists' => "Impossible de changer le nom du serveur : il y a au moins une base de données dessus.",
    '__mssql_status' => "Statut de Microsoft SQL server",
    '__multiply_login_deny' => "Impossible de vous connecter. Un autre utilisateur portant le même nom d'utilisateur (%1) est déjà connecté à Plesk.",
    '__mysql' => "MySQL",
    '__mysql_status' => "Statut du serveur MySQL",
    '__mysql_version' => "Version MySQL",
    '__mariadb' => "MariaDB",
    '__mariadb_status' => "Statut du serveur MariaDB",
    '__mariadb_version' => "Version de MariaDB",
    '__percona' => "Percona",
    '__percona_status' => "Statut du serveur Percona",
    '__percona_version' => "Version de Percona",
    '__name' => "Nom",
    '__name_invalid' => "Nom est incorrect.",
    '__nameserver' => "Serveur de noms",
    '__network' => "Réseau",
    '__networks' => "Réseaux",
    '__no' => "Non",
    '__no_ip_address_with_properly_type_available' => "Impossible de restaurer les données sauvegardées car il n'y a aucune adresse IP valable pour la restauration.",
    '__no_clients_specified' => "Aucun compte client n'est indiqué.",
    '__no_comments' => "Pas de commentaires.",
    '__nologin' => "Interdit",
    '__none' => "Aucun",
    '__not_configured' => "Non configuré",
    '__not_implemented_yet' => "Pas encore implémenté",
    '__not_supported_by_ftp' => "(Non pris en charge par le serveur FTP)",
    '__notification' => "Notification",
    '__num_displayed' => "%1 sur %2 affichés",
    '__num_is_invalid' => "Le nombre est incorrect.",
    '__object_not_found' => 'Objet introuvable : %1',
    '__of_all' => "% de TOUS",
    '__off' => "Désactivé",
    '__ok' => "OK",
    '__old_passwd' => "Ancien mot de passe %1",
    '__on' => "Activé",
    '__others' => "Autres",
    '__other_ip__will_be_added' => 'Autres adresses IP disponibles (seront ajoutées au pool IP du client)',
    '__out' => "Dehors",
    '__p' => "P",
    '__passwd' => "Mot de passe %1",
    '__passwd_is_invalid' => "Mot de passe %1 est incorrect.",
    '__path' => "Chemin d'accès",
    '__perl_unix_support' => "Prise en charge de Perl",
    '__perl_win_support' => "Prise en charge de Perl",
    '__perm_denied' => "Autorisation refusée.",
    '__permissions' => "Droits",
    '__personal_name' => "Nom personnel",
    '__pg_admin_not_activated' => "PostgreSQL n'a pas été activé sur la page d'administration du serveur.",
    '__pg_not_inst' => "PostgreSQL n'est pas installé.",
    '__pg_not_run_or_inst' => "PostgreSQL n'est pas installé ou n'est pas actif.",
    '__pg_not_support_in_key' => "PostgreSQL n'est pas pris en charge par votre licence.",
    '__phone' => "Téléphone",
    '__phosting' => "Hébergement physique",
    '__php_support' => "Prise en charge de PHP",
    '__php_run_as_isapi' => "Exécuter comme extension ISAPI",
    '__php_safe_mode' => "'safe_mode' de PHP activé",
    '__php_version' => "Version de PHP",
    '__physical' => "Hébergement physique",
    '__plesk_stat_pdir' => "Protéger le répertoire '/plesk-stat/webstat/'",
    '__plesk_stat_dir_name' => "Statistiques du domaine",
    '__plesk_stat_protect' => "Protéger l'accès aux statistiques Web avec le nom d'utilisateur et le mot de passe FTP de l'utilisateur",
    '__plesk_stat_protect_install' => "accessible via le répertoire protégé par le mot de passe '/plesk-stat/webstat/'",
    '__pop3_imap' => "POP3/IMAP", // indirect
    '__pop3_status' => "Statut du serveur POP3",
    '__popen_error' => "Une erreur s'est produite en appelant la fonction popen.",
    '__port' => 'Port',
    '__postgres' => "PostgreSQL",
    '__postgresql' => "PostgreSQL",
    '__postgresql_status' => "Statut de PostgreSQL",
    '__preferences' => "Paramètres",
    '__account_preferences' => "Paramètres du compte",
    '__interface_preferences_general' => 'Général',
    '__interface_preferences_default' => 'Préférences de l\'interface par défaut',
    '__interface_preferences_admin' => "Préférences de l'interface de l'administrateur",
    '__interface_template' => 'Template de personnalisation d\'interface',
    '__interface_preferences' => "Préférences de l'interface",
    '__proceed?' => "Voulez-vous continuer ?",
    '__provider_contact_name' => "Nom de contact du propriétaire",
    '__python_unix_support' => "Prise en charge de Python",
    '__python_win_support' => "Prise en charge de Python",
    '__quota' => "Quota",
    '__r' => "Applications récurrentes",
    '__reconfigure' => "Reconfigurer",
    '__record_type' => "Type d'enregistrement",
    '__release' => "Sortie",
    '__remote_db_not_supported_by_key' => 'Un hébergement distant de bases de données n\'est pas supporté par votre licence.',
    '__remove_protection' => 'Supprimer la protection',
    '__report' => "Rapport",
    '__report_size_na' => "Le service n'est pas disponible",
    '__reports_list' => "Rapports",
    '__requested' => "Demandé",
    '__required_fields' => "Champs obligatoires",
    '__resp_name_invalid' => "Le nom de la réponse automatique est incorrect. Utilisez uniquement des caractères alphanumériques, des points, des tirets bas et des espaces blancs.",
    '__c' => "A", // Access to panel
    '__s' => "S",
    '__server_name_is_invalid' => "Le nom du serveur est incorrect.",
    '__screenshots' => 'Captures d\'écran',
    '__script_warning' => "Si vous supprimez les possibilités de scripting sur ce domaine, tous les scripts affiliés au domaine s'afficheront en texte clair quand ils seront appelés par un navigateur Web. Nous recommandons à l'administrateur de supprimer tous les scripts liés au domaine en question.",
    '__sec' => "Secondes",
    '__second(s)' => "Seconde(s)",
    '__see_list_of_logged_in' => "Consultez la liste des utilisateurs déjà connectés.",
    '__select_certs_to_remove' => "Sélect. les certificats à supprimer.",
    '__select_files_to_remove' => "Sélect. fichiers à supprimer.",
    '__select_ip' => "Affecter l'adresse IP",
    '__select_ip_to_remove' => "Sélect. une adresse IP à supprimer.",
    '__select_domain_template' => "Utiliser les paramètres du template de domaine",
    '__select_templates_to_remove' => "Sélect. les templates à supprimer.",
    '__server' => "Serveur",
    '__server_total' => "Serveur Total",
    '__service' => "Service",
    '__service_title__plesk' => "Plesk",
    '__service_description__plesk' => "Plesk",
    '__service_title__mysql' => "Serveur de bases de données MariaDB/MySQL",
    '__service_description__mysql' => "Serveur de bases de données MariaDB/MySQL",
    '__service_title__web' => "Serveur Web",
    '__service_description__web' => "Serveur Web",
    '__service_title__smtp' => "Serveur SMTP",
    '__service_description__smtp' => "Serveur SMTP",
    '__service_title__mail' => "Serveur IMAP/POP3",
    '__service_description__mail' => "Serveur IMAP/POP3",
    '__service_title__dns' => "Serveur DNS",
    '__service_description__dns' => "Serveur DNS",
    '__service_title__postgresq' => "Serveur de bases de données PostgreSQL",
    '__service_description__postgresq' => "Serveur de bases de données PostgreSQL",
    '__service_title__spamassassin' => "Service SpamAssassin pour le filtrage des spams",
    '__service_description__spamassassin' => "Service SpamAssassin pour le filtrage des spams",
    '__services' => "Services",
    '__all_services' => "Tous les services",
    '__sessions' => "Sessions",
    'sessions__feature_ftp_session_manager_not_supported' => "La fonctionnalité Sessions FTP n'est pas prise en charge par le serveur FTP actuel",
    '__sessions_list' => "Sessions",
    '__set' => "Activer",
    '__shared' => "Partagé(s)",
    '__shell_access_warning' => "Autoriser l'accès au shell du système représente un gros risque pour la sécurité du système. N'autorisez l'accès au système qu'en parfaite connaissance de cause, et seulement à des utilisateurs de confiance. Voulez-vous vraiment autoriser l'accès ?",
    '__siteapp_not_support_in_key' => "Les applications Web ne sont pas prises en charge par la clé de licence",
    '__siteapp_cannot_reconfigure_with_remote_database' => 'La configuration de cette application Web a été changée manuellement. Pour protéger les modifications manuelles, la reconfiguration via Plesk n\'est plus disponible.',
    '__site_management' => "Publication Web", // indirect
    '__size' => "Taille",
    '__skins' => 'Skins',
    '__smtp' => "SMTP", // indirect
    '__smtp_status' => "Statut du serveur SMTP",
    '__some_fields_are_empty_or_invalid' => "Certains champs sont vides ou leur valeur est erronée.",
    '__no_email_addresses_selected' => 'Aucune adresse e-mail n\'a été sélectionnée.',
    '__unable_to_set_parameters' => "Impossible de définir les paramètres du composant.",
    '__spamassassin' => "Filtre anti-spam",
    '__spamassassin_status' => "Statut de SpamAssassin",
    '__spamd_status' => 'Statut du filtre anti-spam',
    '__splited_backup' => "(sauvegarde multi-volumes)",
    '__split_backup_file' => "Créer une sauvegarde multi-volumes",
    '__split_backup_size' => "Volume",
    '__split_backup_less_than_500' => "Des volumes inférieurs à 500 mégaoctets ne sont pas pris en charge",
    '__ssi' => "SSI",
    '__ssi_support' => "Prise en charge de SSI",
    '__ssi_with_html' => "utiliser SSI pour les fichiers *.htm, *.html",
    '__ssl' => 'SSL/TLS',
    '__ssl_support' => "Prise en charge SSL/TLS",
    '__same_ssl' => "Utiliser un seul répertoire pour l'hébergement de contenu SSL/TLS et non-SSL/TLS",
    '__same_ssl_cu' => "Contenu SSL/TLS et non-SSL/TLS commun",
    '__state' => "Région/Département",

    '__status__Active' => 'Actif',
    '__status__active' => 'actif',
    '__status__Passive' => 'Désactivé',
    '__status__passive' => 'Désactivé',
    '__status__off' => 'Désactivé',
    '__status__with_parent' => 'Désactivé',
    '__status__backup_restore' => 'suspendu temporairement pour cause de back-up ou de restauration',
    '__status__admin' => 'Suspendu par l\'administrateur du serveur',
    '__status__resseler' => 'Suspendu par le revendeur',
    '__status__client' => 'suspendu par le client',
    '__status__unknown' => 'Le statut est inconnu',

    '__status_of' => "Statut de %1",
    // end of akss part

    // shramko part

    '__stunnel' => "Stunnel",
    '__stunnel_server' => "Serveur Stunnel", // indirect
    '__subdomain' => "Sous-domaine",
    '__subdomain_name' => "Nom du sous-domaine",
    '__subdomain_name_in_ASCII_form' => "Le nom du sous-domaine est au format ASCII.",
    '__subdomains' => "Sous-domaines",
    '__domainaliases' => "Alias de domaines",
    '__subdomains_list' => "Sous-domaines",
    '__subdomains_not_support_in_key' => "Les opérations sur les sous-domaines ne sont pas prises en charge par votre licence",
    '__sys_user_type' => "Utilisateur FTP",
    '__sys_user_type_main' => "Utiliser le compte utilisateur FTP du domaine principal",
    '__sys_user_type_native' => "Créer un compte FTP distinct pour ce sous-domaine",
    '__target_domain' => "Domaine cible",
    '__template' => "Modèle",
    '__template_not_accepted' => "Impossible d'accepter le template : les limitations suivantes sont dépassées.",
    '__templates' => "Modèles",
    '__templates_list' => "Modèles",
    '__tera' => "T",
    '__title' => "Titre",
    '__tools' => "Outils",
    '__total' => "Total %1",
    '__total_size' => "Taille Totale",
    '__total_used' => "Utilisation Totale",
    '__traffic' => "Trafic",
    '__traffic_by_client' => "Trafic par client",
    '__traffic_by_domain' => "Trafic par domaine",
    '__traffic_by_service' => "Trafic par service",
    '__traffic_history' => "Historique du trafic",
    '__unable_change_locale' => "Impossible de changer la langue de l'interface : %1",
    '__unable_create_new_dom' => "Impossible de créer un domaine : %1",
    '__unable_define_dom_name' => "Impossible de définir le nom de domaine : %1",
    '__unable_define_necessary_properties' => "Impossible de définir les propriétés requises.",
    '__unable_define_properties' => "Impossible de définir les propriétés : %1",
    '__unable_exec_util' => "Impossible d'exécuter l'utilitaire : %1",
    '__unable_get_dns_a_recs' => "Impossible de récupérer les adresses IP pour les enregistrements DNS A pour ce compte d'hébergement : %1",
    '__unable_get_mbox_quota' => "Impossible de récupérer les informations sur le quota de courriel maximum.",
    '__unable_redirect_to_myself' => "Impossible de transférer vers le même compte.",
    '__unable_redirect_to_my_alias' => "Impossible de transférer le mail vers un alias de messagerie.",
    '__default_domain_redirect_to_myself' => "Impossible de définir ce domaine comme domaine par défaut pour cette adresse IP : \n redirection en boucle.",
    '__unable_remove_client' => "Impossible de supprimer le client : %1",
    '__unable_set_up_mbox_quota' => "Impossible de configurer le quota de courriel pour le domaine : %1",
    '__unable_setup_pass' => "Impossible config. mot de passe : %1",
    '__unable_to_create_new_account' => "Impossible de créer un compte : %1",
    '__unable_to_define_db_size' => "Impossible de définir la taille de la base de données.",
    '__unable_to_enable_short_names' => "Impossible d'autoriser l'utilisation des noms de compte mail courts pour les comptes POP3/IMAP.",
    '__unable_to_fetch_data_from_submit' => "Impossible de récupérer les données soumises : %1",
    '__unable_to_open_file' => "Impossible d'ouvrir le fichier %1: %2",
    '__unable_to_update_subdomain' => "Impossible de modifier le sous-domaine : %1",
    '__unable_update_cl_data' => "Impossible d'enregistrer les changements pour le compte utilisateur : %1",
    '__unable_update_db_params' => "Impossible de mettre à jour les paramètres de la base de données : %1",
    '__unable_update_dom_data' => "Impossible de mettre à jour les données du domaine : %1",
    '__undefined' => "non-définie",
    '__uninstall' => "Désinstaller",
    '__unknown_error' => "Erreur inconnue",
    '__unlimited_lower' => "Illimité",
    '__unset' => "Désactivé",
    '__update' => "Mettre à jour",
    '__uploaded_file_is_invalid' => "Le fichier chargé n'est pas bon : %1",
    '__url' => "URL",
    '__usage' => "Utilisation du disque",
    '__user_already_logged' => "Un autre utilisateur portant le même nom d'utilisateur (%1) est déjà connecté à Plesk.",
    '__version' => "Version",
    '__aps_license' => "Clé de licence",
    '__vh_type' => "Type d'hôte virtuel",
    '__vhosts_apache_status' => "Statut du serveur web",
    '__wrong_charset_conversion' => 'Mauvais jeu de caractères ; conversion de "%1" en "%2" non autorisée',
    '__warning_' => "Attention !",
    '__warning_excl_ip_num' => "Adresse IP dédiée",
    '__warning_expiration' => "Date d'expiration",
    '__web_scripting' => "Scripting web", // indirect
    '__web_serv' => "Serveur Web", // indirect
    '__web_statistic' => "Statistiques Web", // indirect
    '__webmail' => "Messagerie Web", // +indirect
    '__webstat_not_installed' => "Webalizer n'est peut-être pas installé sur le serveur. Veuillez contacter votre fournisseur de services pour être aidé avec l'installation Webalizer.",
    '__webstat_support' => "Statistiques Web",
    '__webstat_awstats_support' => "AWStats",
    '__webstat_webalizer_support' => "Webalizer",
    '__webstat_awstats' => "AWStats",
    '__webstat_webalizer' => "Webalizer",
    '__webstat_type_change_warning' => "Lorsque vous basculez d'un programme de statistiques à l'autre, tous les rapports créés par le précédent programme de statistiques utilisé sont supprimés et de nouveaux rapports créés en concordance avec les informations lues depuis les fichiers journaux conservés sur le serveur. En d'autres termes, si vous avez configuré le système (via Domaines > nom de domaine > Gestionnaire de journaux > Rotation des journaux) de sorte à conserver les fichiers journaux uniquement du mois dernier, les statistiques Web seront disponibles uniquement pour ce dernier mois. Voulez-vous vraiment basculer vers un autre pack de statistiques ?",
    '__webstat_perm_denied' => 'Vous n\'avez pas le droit de gérer les statistiques Web.',
    '__webuser' => "Utilisateur web",
    '__sysusers_list' => "Utilisateurs système",
    '__sysuser' => "Utilisateur système",
    '__weekly' => "Ttes les semaines",
    '__whats_new_in_version' => "Quelles sont les nouveautés de Plesk %1 ?",
    '__wrong_hosting_type__virtual_required' => "Cette opération n'est disponible que pour les domaines avec l'hébergement Web.",
    '__wrong_hosting_type__none' => 'Il n\'y a aucun hébergement Web configuré sur le domaine %1.',
    '__wrong_hosting_type__std_fwd' => 'Une redirection standard est configurée pour le domaine %1. Cette opération n\'est disponible que pour les domaines avec l\'hébergement Web.',
    '__wrong_hosting_type__frm_fwd' => 'Une redirection de frame est configurée pour le domaine %1. Cette opération n\'est disponible que pour les domaines avec l\'hébergement Web.',
    '__wu' => "Utilisateurs Web",
    '__www' => "WWW",
    '__www_prefix_was_changed' => "Le préfixe WWW a été changé. Assurez-vous bien de modifier le certificat SSL/TLS en conséquence.",
    '__year' => "Année",
    '__year(s)' => "Année(s)",
    '__yes' => "Oui",
    '__you' => "Vous",
    '__zip_code' => "Code postal/CP",
    '__form_normal' => "Normal(e)",
    '__form_advanced' => "Avancé",

    'admin_ed__edit_administrator_info' => "Édition du profil d'administrateur",
    'admin_ed__create_default_client' => "Je souhaite créer un nouveau compte client par défaut.",
    'admin_ed__unable_update' => "Impossible de mettre le profil de l'administrateur à jour : %1",

    'auth__update_admin_info' => "Veuillez compléter les données administrateur. Ces informations sont requises pour activer %1.",
    'auth__you_not_have_perm' => "Vous n'avez pas la permission de gérer ce domaine.",
    'auth__key_expired_admin' => 'Licence Plesk expirée. Pour continuer à utiliser Plesk, renouvelez votre licence ou achetez-en une nouvelle.',
    'auth__key_expired_admin_restricted' => 'Licence Plesk expirée. Contactez votre fournisseur de services pour continuer à utiliser Plesk.',
    'auth__key_expired_client' => 'Licence Plesk expirée. Consultez votre fournisseur d\'hébergement.',
    'autoinstaller__not_installed' => 'Le composant Installateur automatique n\'est pas installé.',
    'autoinstaller__release_action' => 'Opérations disponibles',
    'autoinstaller__release_action_icon' => 'S',
    'autoinstaller__release_action_upgrade' => 'Mise à niveau vers la nouvelle version de Plesk',
    'autoinstaller__release_action_update' => 'Mise à jour ou ajout de nouveaux composants',
    'autoinstaller__release_action_up2date' => 'Vous avez une version mise à jour',
    'autoinstaller__component_action' => 'Statut',
    'autoinstaller__component_action_icon' => 'S',
    'autoinstaller__component_action_install' => 'Ne pas installer',
    'autoinstaller__component_action_update' => 'Des mises à jour sont disponibles',
    'autoinstaller__component_action_upgrade' => 'Une mise à jour est disponible',
    'autoinstaller__component_action_up2date' => 'Vous avez une version mise à jour',
    'autoinstaller__component_action_error' => 'Pas de mise à jour disponible',
    'autoinstaller__component_serverbuildtime' => 'Dernière release',
    'autoinstaller__component_localbuildtime' => 'Votre release',
    'autoinstaller__component_installed_version' => 'Votre version',
    'autoinstaller__component_available_version' => 'Dernière version',
    'autoinstaller__component' => 'Composant',
    'autoinstaller__components' => 'Composants',
    'autoinstaller__components_title' => '%1 Composants',
    'autoinstaller__component_dependency_note' => 'requis pour l\'installation des composants que vous avez sélectionnés',
    'autoinstaller__install_confirm' => 'Oui, je souhaite installer ces composants',
    'autoinstaller__install_confirm_request' => 'Veuillez cocher la case pour confirmer',
    'autoinstaller__install_title' => 'Confirmez l\'installation des composants sélectionnés.',
    'autoinstaller__key_update_confirm' => 'Confirmer l\'omission de la clé de mise à jour et l\'installation de la clé par défaut',
    'autoinstaller__key_update_confirm_request' => 'Veuillez cocher la case pour confirmer.',
    'autoinstaller__key_update_failed' => '<p> Plesk ne peut pas mettre à jour votre licence.</p> <p> %1</p> <p>Si vous continuez la mise à niveau sans licence valable, la licence par défaut ayant des fonctionnalités réduites sera installée. Les administrateurs sont avertis qu\'ils doivent acheter une clé de licence avant de continuer la mise à niveau du produit.</p>',
    'autoinstaller__email' => 'Envoyer la notification à',
    'autoinstaller__email_admin' => "Adresse mail de l'administrateur",
    'autoinstaller__email_email' => 'Adresse mail personnalisée...',
    'autoinstaller__release' => 'Nom de la release',
    'autoinstaller__releases' => 'Releases disponibles',
    'autoinstaller__releases_title' => 'Plesk Updater',
    'autoinstaller__select_components_to_install' => 'Sélectionnez les composants qui doivent être installés.',
    'autoinstaller__status_error' => 'Erreur : %1',
    'autoinstaller__status_install_error' => 'Impossible de lancer l\'installation : %1',
    'autoinstaller__status_install_busy' => 'L\'installation n\'a pu être lancée : une autre procédure d\'installation est actuellement en cours.',
    'autoinstaller__status_install_ok' => 'Installation démarrée. Vous serez notifié de la progression de l\'installation par mail (%1).',
    'autoinstaller__status_query_busy' => 'L\'Installation est en cours.',
    'autoinstaller__status_query_error' => 'Impossible de déterminer le statut de l\'installation : %1',
    'autoinstaller__status_unknown' => 'Impossible de récupérer le statut de l\'installateur automatique.',
    'autoinstaller__status_busy' => 'L\'installateur automatique est occupé, veuillez patienter.',
    'autoinstaller__configure_title' => 'Paramètres de l\'Updater',
    'autoinstaller__preferences_legend' => 'Paramètres',
    'autoinstaller__target' => 'Répertoire temporaire d\'envoi',
    'autoinstaller__target_invalid' => "Spécifiez le chemin absolu",
    'autoinstaller__check_updates' => 'Vérifier les mises à jour lors de la connexion de l\'administrateur à Plesk',
    'autoinstaller__check_updates_warning' => 'De nouvelles <a href="%1">mises à jour</a> sont disponibles pour %2',
    'autoinstaller__source_type' => 'Type de source',
    'autoinstaller__source' => 'URL de la source',
    'autoinstaller_source__preferences_legend' => 'Paramètres',
    'autoinstaller_source__type' => 'Type de source',
    'autoinstaller_source__url_invalid' => 'URL incorrecte',
    'autoinstaller_source__url_invalid_network' => 'URL source incorrecte (Exemple : http://source, ftp://source)',
    'autoinstaller_source__url' => 'URL de la source',
    'autoinstaller__source_invalid_network' => 'L\'adresse réseau saisie est incorrecte',
    'backup__repository' => 'Emplacement du stockage des fichiers de sauvegarde',
    'backup__error_notify_email' => 'En cas d\'erreurs lors de la sauvegarde, envoyez des notifications à l\'adresse mail',
    'backup__dump_info' => "Informations sur la sauvegarde",
    'backup__dump_file_name_not_defined' => "Le nom du fichier de sauvegarde n'est pas indiqué.",
    'backup__local_file' => 'Fichier de sauvegarde local',
    'backup__domain_ftp' => 'Serveur FTP distant',
    'backup__wrong_path' => "Le chemin d'accès du stockage de fichiers de sauvegarde est incorrect : n'utilisez pas la séquence ../../",
    'backup__unable_to_connect_to_ftp_server' => "Impossible de se connecter au serveur FTP : %1",
    'backup__unable_to_read_file' => 'Impossible de lire le fichier de sauvegarde.',
    'backup__backup_task_does_not_exist' => "La tâche de sauvegarde n'existe pas, vous devez la créer avant de démarrer.",
    'backup__restore_params' => "Paramètres de restauration",
    'backup__confirmation' => "Avertissement : le domaine ne sera pas disponible pendant la sauvegarde/restauration.",
    'backup__backup_method' => 'Méthode de sauvegarde',
    'backup__dumpfile_name' => "Nom du fichier de sauvegarde",
    'backup__dumpfile_name_is_invalid' => "Le nom du fichier de sauvegarde est incorrect : n'utilisez que des caractères alphanumériques, des tirets, des points et des tirets-bas, n'utilisez pas de noms comme description.* en tant que nom de fichier de sauvegarde.",
    'backup__email_required' => "Votre adresse mail est requise pour vous tenir informé des progrès de la sauvegarde et de la restauration. Veuillez indiquer votre mail dans les détails du compte.",
    'backup__error_during_backup' => "Impossible de créer un fichier de sauvegarde : %1",
    'backup__input_email_warning' => "Vous devez soit indiquer l'adresse mail pour les notifications, soit décocher la case.",
    'backup__make_download' => "Ne pas stocker les fichiers de sauvegarde dans le stockage, les télécharger seulement",
    'backup__make_dump' => 'Créer un fichier de sauvegarde et le stocker dans le stockage local',
    'backup__makedump_to_ftp' => 'Créer le fichier de sauvegarde et le stocker sur le serveur FTP',
    'backup__restore_ip' => "Adresse de l'IP pour restauration",
    'backup__select_dumpfile' => "Sélectionnez un fichier de sauvegarde.",
    'backup__time' => "Heure de la sauvegarde",
    'backup__day' => 'Jour de la sauvegarde',
    'backup__view_dump_info' => "Voir l'info de sauvegarde du domaine %1",
    'backup__wrong_domain_name' => "Le fichier de sauvegarde contient les données du domaine %1 et ne peut être restauré sur le domaine %2.",
    'backup__incorrect_ftp_user_or_passwd' => "Nom d'utilisateur FTP ou mot de passe incorrect. Veuillez corriger les propriétés du compte FTP.",
    'backup__access_denied' => "Accès refusé. Veuillez corriger les propriétés du compte FTP",
    'backup__restore_from' => "Restaurer %1",
    'backup__domain_session_failed' => 'Le back-up du domaine %1 a échoué',
    'backup__client_session_failed' => 'Le client %1 n\'a pas été sauvegardé',
    'backup__domain_session_restore_failed' => 'La restauration du domaine %1 a échoué',
    'backup__client_session_restore_failed' => 'Le compte client %1 n\'a pas été restauré.',
    'backup__domain_session_complete' => 'Le back-up du domaine %1 est terminé',
    'backup__domain_session_backup' => 'Sauvegarde du domaine %1',
    'backup__client_session_backup' => 'Sauvegarde du client %1',
    'backup__domain_stop_title' => 'Annuler la sauvegarde du domaine %1',
    'backup__client_stop_title' => 'Annulation de la sauvegarde du compte client %1',
    'backup__domain_restore_stop_title' => 'Annulation de la restauration du domaine %1',
    'backup__client_restore_stop_title' => 'Annulation de la restauration du compte client %1',
    'backup__domain_session_backup_stop' => 'Vous êtes sur le point d\'annuler le processus de sauvegarde actif. Le fichier de sauvegarde ne sera pas créé.',
    'backup__backup_stop_confirm' => 'Oui, je veux arrêter la sauvegarde',
    'backup__restore_stop_confirm' => 'Oui, je veux stopper le processus de restauration.',
    'backup__domain_session_restore' => 'Restauration du domaine %1',
    'backup__domain_session_restore_stop' => 'Vous êtes sur le point d\'annuler le processus de restauration actif.',
    'backup__domain_backup_file_info' => 'Informations sur le fichier de sauvegarde du domaine',
    'backup__domain_backup_file_list' => 'Fichiers de sauvegarde existants',
    'backup__domain_backup_progress' => 'Progression de la sauvegarde du site Web %1',
    'backup__domain_restore_progress' => 'Progression de la restauration du site Web %1',
    'backup__domain_backup_progress_elapsed_time' => 'Temps écoulé : %1',
    'backup__domain_restore_progress_elapsed_time' => 'Temps écoulé : %1',
    'backup__domain_restore_session_complete' => 'Le domaine %1 est restauré.',
    'backup__domain_restore_session_complete_message' => 'Le domaine %1 a été restauré.',
    'backup__domain_backup_file_delete' => 'Les fichiers de sauvegarde suivants seront supprimés :',
    'backup__domain_backup_file_for_remove' => 'Choisissez les fichiers de sauvegarde que vous voulez supprimer.',
    'backup__backup_overwrite_file_confirm' => 'Confirmation de l\'écrasement',
    'backup__backup_overwrite_file_confirm_text' => 'Le fichier de sauvegarde "%1" existe déjà. Voulez-vous le remplacer ?',
    'backup__backup_confirm_overwrite' => 'Confirmer l\'écrasement du fichier',
    'backup__backup_overwrite_legeng' => 'Remplacer',
    'backup__backup_not_contain_domain' => 'Le fichier de sauvegarde ne contient pas d\'information sur le domaine %1',
    'backup__backup_not_contain_client' => 'Le fichier de sauvegarde ne contient pas d\'informations sur le compte client %1.',
    'backup__backup_client_info' => "Sauvegardez les détails du compte et des paramètres du client.",
    'backup__client_backup_progress' => 'Progression de la sauvegarde du compte client %1',
    'backup__client_session_complete' => 'Le compte client %1 est sauvegardé.',
    'backup__client_backup_file_info' => 'Informations sur le fichier de sauvegarde du client',
    'backup__restore_client_info' => "Restaurer les détails du compte et des paramètres du client",
    'backup__client_session_restore' => 'Restauration du compte client %1',
    'backup__client_db_server_map' => 'Mappage des serveurs de bases de données',
    'backup__domain_db_server_map' => 'Mappage des serveurs de bases de données',
    'backup__client_restore_session_complete_message' => 'Le compte client %1 a été restauré.',
    'backup__client_restore_session_complete' => 'Le compte client %1 a été restauré.',
    'backup__restore_select_some' => 'Veuillez sélectionner les objets que vous voulez restaurer.',
    'backup__client_restore_progress' => 'Progression de la restauration du compte client %1',
    'backup__new_backup' => 'Créer une nouvelle sauvegarde',
    'backup__done' => 'Fait :',
    'backup__done_domains' => '%1 domaine(s) sur %2',
    'backup__done_clients' => '%1 client(s) sur %2',
    'backup__remaining' => 'Reste(nt) :',
    'backup__remaining_domains' => '%1 domaine(s)',
    'backup__remaining_clients' => '%1 client(s)',
    'backup__overall_backup_progress' => 'Progression globale de la sauvegarde',
    'backup__comment_n_a' => 'n/a',
    'backup__command_ignore' => 'La commande "%1" est ignorée',
    'backup__no_objects' => 'Aucun objet n\'est sélectionné pour la sauvegarde',
    'backup__cli_warning_not_enough_ip' => 'ATTENTION : les adresses IP existantes ne suffisent pas pour faire le mappage d\'adresses IP par défaut :',
    'backup__local_repository' => "Stockage de Plesk",
    'backup__ftp_repository' => 'Stockage FTP',
    'backup__ftp_login' => 'Nom d\'utilisateur',
    'backup__ftp_password' => 'Mot de passe',
    'backup__ftp_account_settings' => 'Paramètres du compte FTP',
    'backup__ftp_account_preferences' => 'Paramètres du compte FTP',
    'backup__repository_not_exist' => 'Le répertoire n\'existe pas.',
    'backup__repository_not_readable' => 'Le répertoire indiqué est illisible.',
    'backup__ftp_repository_not_configure' => 'Pour utiliser un stockage de sauvegarde FTP, <a href="%1">indiquez le compte FTP</a> d\'abord.',
    'backup__ftp_repository_list_not_configure' => 'Les paramètres du compte n\'ont pas été précisés',
    'backup__repository_list_unable_listing' => 'Impossible de récupérer la liste des fichiers',
    'backup__ftp_repository_unable_listing' => 'Impossible de récupérer la liste des répertoires "%1" :',
    'backup__repository_legend' => 'Stockage des fichiers de sauvegarde',
    'backup__store_in_repository' => 'Stocker les fichiers dans',
    'backup__local_repository_lable' => 'Stockage local',
    'backup__ftp_repository_lable' => 'Stockage FTP',
    'backup__ftp_repository_not_configure_hint' => '(paramètres du compte non spécifiés)',
    'backup__ftp_repository_not_configure_or_forbidden_hint' => '(compte FTP non spécifié ou pas pris en charge)',
    'backup__other_user_process_modified' => 'Un autre utilisateur a arrêté la sauvegarde ou le processus de migration.',
    'backup__another_user_exist' => 'Cette opération en cours a été lancée par un autre utilisateur de Plesk. Cet utilisateur est encore connecté à Plesk.',
    'backup__ftp_repository_wait' => 'Veuillez patienter. Les informations du stockage FTP sont en cours de récupération',
    'backup__ftp_write_test_failed' => 'L\'écriture des données test sur le compte FTP %1 a échoué :',
    'backup__ftp_storage' => 'Stockage FTP(S)',
    'bt_upload_to_repository' => 'Charger les fichiers dans le stockage local',
    'bt_new_restore' => "Restaurer",
    'bt_backup_schedule' => "Planifier une sauvegarde",
    'backup_exist_backups' => "Fichiers de sauvegarde existants",
    'backup_dialog__page_title' => "Création du fichier de sauvegarde",
    'backup_dialog__please_wait' => "Le processus de sauvegarde va bientôt commencer. Cette opération peut prendre quelque temps. Veuillez patienter...",
    'backup_conf__page_title' => 'Configuration de la sauvegarde',
    'bt_accept' => "J'accepte",
    'bt_access' => "Accès",
    'bt_action_log' => "Journal des actions",
    'bt_add' => "Ajouter",
    'bt_add_client' => "Affecter aux utilisateurs",
    'bt_database_server_add' => 'Ajouter un serveur de bases de données',
    'bt_add_services' => "Ajout services",
    'bt_anonftp_stats' => "Stat. Ftp.Anon",
    'bt_anonymous_ftp' => "FTP anonyme",
    'bt_aspdotnet' => "ASP.NET",
    'bt_attach' => "Attacher",
    'bt_autoinstaller' => 'Updater',
    'bt_auto-updates' => 'Updater',
    'bt_back' => "<< Précédent",
    'bt_backup' => "Sauvegarder",
    'bt_backup_configure' => "Paramètres de sauvegarde",
    'bt_buy_certs' => "Acheter des certificats",
    'bt_card' => "Carte",
    'bt_cert' => "Certificat",
    'bt_certificates' => "Certificats",
    'bt_change_passwd' => "Modifier le mot de passe",
    'bt_clear' => "Effacer",
    'bt_client_templates' => "Templates de client",
    'bt_clients' => "Clients",
    'bt_codepage_change' => 'Changer le codage',
    'bt_comp_info' => "Gestion des composants",
    'bt_configure_maillists' => "Config. Mailman",
    'bt_configure' => 'Configuration',
    'bt_copy' => "Copier",
    'bt_copy_move' => "Copier/Déplacer",
    'bt_create' => "Créer",
    'bt_create_account' => "Créer un compte",
    'bt_create_dir' => "Ajouter un répertoire",
    'bt_create_file' => "Ajouter un fichier",
    'bt_count_size' => "Calculer la taille",
    'bt_crontab_unix' => "Crontab",
    'bt_crontab_win' => "Planificateur de tâches",
    'bt_custom_button_new' => "Ajouter un bouton",
    'bt_custom_buttons' => "Boutons personnalisés",
    'bt_customize' => "Personnaliser",
    'bt_databases' => "Bases de données",
    'bt_database_servers' => 'Serveurs de bases de données',
    'bt_sqlservers' => "Serveurs de bases de données",
    'bt_db_usr_new' => "Ajouter un utilisateur de base de données",
    'bt_db_new' => "Ajouter une base de données",
    'bt_db_phpmyadmin' => "Admin MySQL",
    'bt_dbuser_default' => "Paramètre par défaut pour DB Webadmin",
    'bt_decline' => "Je refuse",
    'bt_default' => "Par défaut",
    'bt_defaultcomponents' => "Services tiers",
    'bt_defaults' => "Par défaut",
    'bt_delete' => "Supprimer",
    'bt_directories' => "Répertoires protégés",
    'bt_disable' => "Désactiver",
    'bt_dns_zone_sync' => 'Appliquer les modifications du template DNS',
    'bt_dnsrecord_add' => 'Ajouter un enregistrement',
    'bt_do_backup' => "Sauvegarder",
    'bt_do_restore' => "Restaurer",
    'bt_do_upload' => "Envoyer",
    'bt_domain_aliases' => "Alias de domaines",
    'bt_domain_templates' => "Templates de domaine",
    'bt_domain_user' => "Admin. du domaine",
    'bt_domain_user_passwd' => "Mot de passe de l'administrateur de domaine",
    'bt_domains' => "Domaines",
    'bt_domain_alias_add' => 'Ajouter un alias de domaine',
    'bt_download' => "Télécharger",
    'bt_edit' => "Éditer",
    'bt_enable' => "Activer",
    'bt_export' => 'Exporter',
    'bt_extras' => "Extras",
    'bt_finish' => "Terminer",
    'bt_ftp_account' => "Propriétés du compte FTP",
    'bt_forget_password' => "Perdu votre mot de passe?",
    'bt_fp_ssl_webadmin' => "FP-SSL/TLS Webadmin",
    'bt_fp_webadmin' => "FP Webadmin",
    'bt_ftp_stats' => "Stat. FTP",
    'bt_get_password' => "Obtenir le mot de passe",
    'bt_global_changes' => "Modifier",
    'bt_help' => "Aide",
    'bt_hide_aliases' => "Masquer les alias",
    'bt_hide_toolbar' => 'Masquer la barre d\'outils',
    'bt_hide_subdomains' => "Masquer les sous-domaines",
    'bt_hide_domainaliases' => "Masquer les alias de domaines",
    'bt_home' => "Accueil",
    'bt_hosting' => "Hébergement",
    'bt_icf' => 'Pare-feu',
    'bt_install' => "Installer",
    'bt_ip_aliasing' => "Adresses IP",
    'bt_ip_add' => "Ajouter une adresse IP",
    'bt_ip_pool' => "Pool d'adresses IP",
    'bt_key_info' => "Informations sur la licence",
    'bt_key_buyonline_addons' => 'Commander les add-ons de Plesk',
    'bt_key_buyonline_upgrades' => 'Commander les mises à niveau de Plesk',
    'bt_key_buyonline_new' => 'Commander une nouvelle licence',
    'bt_limits' => "Limites",
    'bt_locale_add' => 'Ajouter un fichier de langue',
    'bt_locales' => 'Localisation',
    'bt_log_manager' => "Gestionnaire de journaux",
    'bt_login' => "Se connecter",
    'bt_logo' => "Marque",
    'bt_logo_send_link' => "Lien Attacher",
    'bt_logo_send_logo' => "Attacher le logo.",
    'bt_logout' => "Quitter",
    'bt_logrotation' => "Rotation des journaux",
    'bt_mail' => "Boîte mail",
    'bt_mail_alias_add' => "Ajouter un alias de messagerie",
    'bt_mail_aliases' => "Alias de messagerie",
    'bt_mail_group_add' => "Ajouter un membre",
    'bt_mail_groups' => "Groupes",
    'bt_mail_name_add' => "Ajouter un compte mail",
    'bt_mail_preferences' => "Paramètres",
    'bt_mail_group' => "Grpe messagerie",
    'bt_mail_mailbox' => "Boîte mail",
    'bt_mail_redirect' => "Outil de redirection",
    'bt_mail_resp_add' => "Ajouter une réponse automatique",
    'bt_mail_resp_attach_add' => "Ajouter une pièce jointe",
    'bt_mail_resp_files' => "Pièces j.",
    'bt_mail_responders' => "Réponses automatiques",
    'bt_mail_spamfilter' => "Filtre anti-spam",
    'bt_mail_webmail' => "Messagerie Web",
    'bt_maillist_new' => "Ajouter une liste de diffusion",
    'bt_maillists' => "Listes de diffusion",
    'bt_mailman' => "Mailman",
    'bt_make_dump' => "Faire une sauvegarde",
    'bt_manage' => "Gérer",
    'bt_master' => "Maître",
    'bt_migrate' => 'Migrer',
    'bt_modules_add' => 'Ajouter une extension',
    'bt_modules_manage' => 'Gérer les extensions',
    'bt_move' => "Déplacer",
    'bt_new_client' => "Ajouter un compte client",
    'bt_new_domain' => "Ajouter un domaine",
    'bt_next' => "Suivant >>",
    'bt_next_page' => "Suivant",
    'bt_network_add' => "Ajouter un réseau",
    'bt_notifications' => "Notifications",
    'bt_off' => "Désactivé",
    'bt_on' => "Activé",
    'bt_on_off' => "On/Off",
    'bt_performance' => 'Performances',
    'bt_permissions' => "Droits",
    'bt_phpmyadmin' => "PhpMyAdmin",
    'bt_postgre_sql' => "PostgreSQL",
    'bt_preferences' => "Paramètres",
    'bt_prev_page' => "Préc",
    'bt_preview' => 'Prévisualiser le site',
    'bt_print' => "Imprimer",
    'bt_reboot' => "Rebooter",
    'bt_reload' => "Actualiser",
    'bt_refresh' => "Actualiser",
    'bt_register' => "Enregistrer",
    'bt_remove' => "Supprimer",
    'bt_enable_selected' => 'Activer',
    'bt_disable_selected' => 'Désactiver',
    'bt_repair_ip' => "Réparer l'IP",
    'bt_report' => "Rapport",
    'bt_report_new' => "Ajouter un style",
    'bt_reset' => "Réinitialiser",
    'bt_restart_services' => "Gestion des services",
    'bt_save' => "Enregistrer",
    'bt_send_by_email' => "Envoyer par mail",
    'bt_send_file' => "Envoyer le fichier",
    'bt_send_mail' => "Envoyer un courriel",
    'bt_send_passwd' => "Envoyer un mot de passe",
    'bt_send_text' => "Envoyer le texte",
    'bt_server' => "Serveur",
    'bt_server_add' => "Ajouter un serveur",
    'bt_server_preferences' => "Paramètres du serveur",
    'bt_servers_list' => "Serveurs",
    'bt_sessions' => "Sessions",
    'bt_set' => "Appliquer",
    'bt_set_as_default' => "Prendre par défaut",
    'bt_setup' => 'Config.',
    'bt_show_aliases' => "Afficher les alias",
    'bt_show_subdomains' => "Voir les sous-domaines",
    'bt_show_domainaliases' => "Afficher les alias de domaines",
    'bt_shutdown' => "Arrêter",
    'bt_site_apppkgs' => "Référentiel d'applications",
    'bt_site_apppool' => "Pool d'applications",
    'bt_application-pool' => "Applications Web",
    'bt_site_apps' => "Applications Web",
    'bt_site_app_add' => "Installer l'application",
    'bt_site_builder' => "Prise en charge de Presence Builder",
    'bt_skeleton' => 'Template de l\'hôte virtuel',
    'bt_skins' => 'Skins',
    'bt_skin_add' => 'Ajouter le skin',
    'bt_skin_manual' => 'Référence des thèmes de Plesk personnalisés', // not used
    'bt_skin_download' => 'Télécharger le Skin',
    'bt_skin_replace' => 'Mettre à jour le skin',
    'bt_skip' => 'Ignorer',
    'bt_spamassassin' => "Filtre anti-spam",
    'bt_spamassassin_train' => "Apprentissage",
    'bt_spamfilter' => "Filtre anti-spam",
    'bt_start' => "Démarrer",
    'bt_stop' => "Arrêter",
    'bt_recycle' => "Recycler",
    'bt_statistics' => "Statistiques",
    'bt_subdomain_new' => "Ajouter un sous-domaine",
    'bt_subdomains' => "Sous-domaines",
    'bt_submit' => "Soumettre",
    'bt_summary_report' => "Rapport récapitulatif",
    'bt_support' => "Assistance",
    'bt_switch' => "Basculer",
    'bt_system_time' => "Date/Heure du système",
    'bt_task_new' => "Ajouter une tâche",
    'bt_dom_tmpl_add' => 'Ajouter un template de domaine',
    'bt_cl_tmpl_add' => 'Ajouter un template de client',
    'bt_cron_backup' => 'Paramètres des sauvegardes planifiées',
    'bt_test' => "Test de connexion",
    'bt_text' => "Texte",
    'bt_touch' => "Changer le Timestamp (horodatage)",
    'bt_traffic' => "Trafic",
    'bt_traffic_history' => "Historique du trafic",
    'bt_update' => "Mettre à jour",
    'bt_upload' => "Envoyer",
    'bt_upload_from_ftp' => "Envoi FTP",
    'bt_virtualdirs' => 'Répertoires virtuels',
    'bt_virtualdir_new' => 'Ajouter un répertoire virtuel',
    'bt_virtualdir_add' => 'Ajouter un répertoire virtuel',
    'bt_web_app_new' => "Installer l'application  Java",
    'bt_web_stats' => "Stats Web",
    'bt_web_stats_ssl' => "Statistiques Web SSL/TLS",
    'bt_web_user_add' => "Ajouter un utilisateur Web",
    'bt_web_users' => "Utilisateurs Web",
    'bt_webadmin' => "Admin Web",
    'bt_webalizer' => "Webalizer",
    'bt_whats_new_full' => "Voir la liste de toutes les modifications",
    'cert_add__unable_set_ca_cert' => "Impossible de mettre en place le certificat CA: %1",
    'cert_add__unable_set_cert' => "Impossible de mettre en place le certificat: %1",
    'cert_add__unable_set_private_key' => "Impossible de configurer la clé privée : %1",
    'certificates_list__certificate_used_as_default' => "L'un des certificats que vous allez supprimer est utilisé comme certificat par défaut.",
    'certificates_list__certificates_assigned_on_ip' => "un ou plusieurs certificats sont assignés aux domaines/adresses IP.",
    'ch_pass__admin_pass' => "Changement du mot de passe de l'administrateur",
    'ch_pass__old_pass' => "Ancien mot de passe",
    'ch_pass__pass_confirm' => "Confirmer",
    'ch_pass__unable_change_admin_pass' => "Impossible de changer le mot de passe de l'administrateur : %1",
    'check_mail_cycle__aliases' => "Un message envoyé de façon cyclique est détecté, l'adresse \"%1\" est contenue dans les alias de ce compte mail.",
    'check_mail_cycle__autoresponders' => "Le cycle de messagerie est détecté, l'adresse \"%1\" est contenue dans les réponses automatiques de ce compte mail.",
    'check_mail_cycle__mail_groups' => "Un message envoyé de façon cyclique est détecté, l'adresse \"%1\" fait partie du groupe de messagerie de ce compte mail.",
    'check_mail_cycle__mail_name' => "Un message envoyé de façon cyclique est détecté, l'adresse \"%1\" correspond à ce compte mail.",
    'check_mail_cycle__redirect' => "Le cycle de messagerie est détecté, l'adresse \"%1\" coïncide avec l'outil de redirection de ce compte mail.",
    'check_mail_dup__redirect' => "Un double transfert est détecté, l'adresse \"%1\" coïncide avec l'adresse de redirection de ce compte mail.",
    'check_mail_dup__mail_groups' => "Un double transfert est détecté, l'adresse \"%1\" est contenue dans le groupe de messagerie de ce compte mail.",
    'check_maillist_cycle__admin' => "Le cycle de messagerie est détecté, l'adresse mail de l'administrateur \"%1\" coïncide avec celle d'une liste de diffusion.",
    'check_maillist_cycle__member' => "Un courriel envoyé de façon cyclique est détecté, l'adresse \"%1\" coïncide avec l'adresse de la liste de diffusion.",

    // end of shramko part

    // serge part
    'cl_ed__edit_cl' => "Détails du compte %1",
    'cl_limits__cl' => "Limites du client %1",
    'cl_logo__setup_logo_pref' => "Définir les propriétés du logo pour le client %1",
    'cl_new__enter_new_cl_data' => "Entrer les informations sur le nouveau client",
    'cl_new__unable_to_sent_notification' => 'Le compte utilisateur a été créé cependant envoyer une notification au client a échoué : %1',
    'cl_perm__all_ip' => "Toutes les IP disponibles",
    'cl_perm__all_ip_based_hst_will_be_nb' => "Tous les comptes d'hébergement basé sur l'IP pour le client seront transférés en \"basé sur le nom\".",
    'cl_perm__allow_client_create_domain' => "Les champs que vous essayez de sélectionner ne s'appliquent qu'aux clients qui peuvent créer des domaines.",
    'cl_perm__allow_create_nb_w_ip' => "Le client peut créer un hébergement basé sur le nom à l'aide de %1",
    'cl_perm__allow_creation_ip_based_hosting' => "Autoriser la création de comptes d'hébergement sur IP fixe",
    'cl_perm__available_ips' => "IP disponibles",
    'cl_perm__change_limits' => "Réglages des limites",
    'cl_perm__cl_disk_space' => "Total de l'espace disque disponible",
    'cl_perm__cl_expiration' => "Période de validité du compte client",
    'cl_perm__cl_max_box' => "Boîtes mail",
    'cl_perm__cl_max_db' => "Bases de données",
    'cl_perm__cl_max_dom' => "Domaines",
    'cl_perm__cl_max_maillists' => "Listes de diffusion",
    'cl_perm__cl_max_subdom' => "Sous-domaines",
    'cl_perm__cl_max_traffic' => "Total du trafic disponible",
    'cl_perm__cl_max_wu' => "Utilisateurs Web",
    'cl_perm__cl_mbox_quota' => "La limite de la taille de la boîte mail pour ce compte utilisateur",
    'cl_perm__current_maximum_exp_date' => "La valeur maximum actuelle de la période de validité du domaine est %1; requis %2.",
    'cl_perm__current_maximum_mailbox_quota' => "L'espace disque maximum défini actuellement pour les boîtes aux lettres sur ce compte client est %1; vous demandez %2",
    'cl_perm__current_total_requested' => "La valeur totale actuelle des limites du domaine pour %1 est %2;requis %3.",
    'cl_perm__current_total_requested_dom' => "Le nombre actuel de %1 appartenant à ce client est de %2; requis %3.",
    'cl_perm__disk_space' => "Volume maximum d'espace disque",
    'cl_perm__dashboard_stdgui' => 'Interface utilisateur',
    'cl_perm__dashboard' => 'Affichage de la page d\'accueil',
    'cl_perm__stdgui' => 'Vue Standard',
    'cl_perm__manage_dashboard' => 'Gestion de la page d\'accueil',
    'cl_perm__dashboard_and_stdgui' => 'L\'affichage de la page d\'accueil et l\'affichage standard sont autorisés',
    'cl_perm__dashboard_only' => 'Seul l\'affichage de la page d\'accueil est autorisé',
    'cl_perm__stdgui_only' => 'Seule la vue Standard est autorisée',
    'cl_perm__edit_cl' => "Droits du client %1",
    'cl_perm__exp_date_exceeded' => "La période de validité que vous essayez de configurer dépasse la limite indiquée dans les domaines individuels liés à ce client.",
    'cl_perm__invalid_value' => "Valeur incorrecte, seuls les chiffres sont acceptés.",
    'cl_perm__limit_disk_space' => "%1 limite le total d'espace disque",
    'cl_perm__limit_expiration' => "%1 Limite de la période de validité du compte client",
    'cl_perm__limit_max_box' => "%1 limite le nombre maximum de boîtes aux lettres",
    'cl_perm__limit_max_db' => "%1 limite le maximum de base de données",
    'cl_perm__limit_max_dom' => "%1 limite le maximum de domaines",
    'cl_perm__limit_max_maillists' => "%1 limite la quantité maximum de listes de diffusion",
    'cl_perm__limit_max_subdom' => "%1 limite le maximum de sous-domaines",
    'cl_perm__limit_max_traffic' => "%1 limite le maximum de trafic",
    'cl_perm__limit_max_wu' => "%1 limite le maximum d'utilisateurs web",
    'cl_perm__limit_mbox_quota' => "%1 Définissez le quota de courriel",
    'cl_perm__limits_exceeded' => "Une ou plusieurs limites que vous essayez de définir sont déjà dépassées par les limites définies dans les domaines individuels appartenant à ce client.\nLa limite totale du client doit être plus ou moins égale à la somme totale des limites du domaine définies pour ce compte client.",
    'cl_perm__mailbox_quota_exceeded' => "La limite du total d'espace disque affecté aux boîtes mail que vous essayez de définir dépasse la limite définie dans les domaines individuels liés à ce compte client.",
    'cl_perm__mailbox_quota_exceeds_server_limit' => "La limite du total d'espace disque affecté aux boîtes mail que vous essayez de définir dépasse la limite imposée au niveau du serveur.",
    'cl_perm__make_dumps' => "Sauvegarder et restaurer des données",

    'cl_perm__max_box' => "Nombre maximum de boîtes mail",
    'cl_perm__max_db' => "Nombre max. de bases de données",
    'cl_perm__max_dom' => "domaines",
    'cl_perm__max_maillists' => "Quantité max. de listes de diffusion",
    'cl_perm__max_subdom' => "Sous-domaines",
    'cl_perm__max_traffic' => "Volume max. du trafic",
    'cl_perm__max_wu' => "nbre max. d'utils. web",
    'cl_perm__max_dom_aliases' => "alias de domaines",
    'cl_perm__mbox_quota' => "Quota de boîtes mail",
    'cl_perm__not_allow_create_nb_hst' => "Le client ne peut pas créer un hébergement basé sur le nom à l'aide de %",
    'cl_perm__this_ip_used_vrt_hst' => "Cette adresse IP est déjà utilisée pour un hébergement virtuel. \nPour supprimer cette adresse IP, supprimez le service d'hébergement ou changez son type en Name-Based.",
    'cl_perm__unable_off_ipb_creating' => "Le client a déjà configuré un service d'hébergement basé sur l'IP. Pour désactiver cette fonction pour le client, décochez \"Création de domaine\" ou supprimez les comptes d'hébergement basé sur l'IP.",
    'cl_perm__unable_off_nb_creating' => "Le client a déjà configuré un service d'hébergement basé sur le nom. Pour désactiver cette fonction pour le client, décochez \"Création de domaine\" ou supprimez les comptes d'hébergement basé sur le nom.",
    'cl_perm__unable_set_domain_limit' => "Impossible de limiter le nombre maximum de domaines inactifs : le client a déjà %1 domaines",
    'cl_perm__unable_update_client_limitations' => "Impossible de modifier les limites du compte client : %1",
    'cl_pref__edit_cl' => "Préférences du client %1",
    'class_anonftp__create_ftp_domain' => "Pas de domaine FTP virtuel pour ce dom_id, essayez d'abord d'en créer un.",
    'class_anonftp__incoming_disk_space_should_be_lower' => "La limite d'espace disque que vous essayez de définir (%1) ne doit pas dépasser la limite d'espace disque totale définie au niveau du domaine (%2).",
    'class_anonftp__invalid_input_only_digits' => "Une valeur incorrecte est indiquée, seuls des chiffres sont autorisés.",
    'class_anonftp__unable_change_ownerships' => "Impossible de changer le propriétaire ou les autorisations du fichier de quota : %1",
    'class_anonftp__unable_copy_quota_file' => "Impossible de copier le fichier de quota : %1",
    'class_anonftp__unable_get_disk_usage' => "Impossible de récupérer les informations sur l'utilisation du disque dans le répertoire entrant : %1",
    'class_anonftp__unable_parse_quota_file' => "Impossible de parser le fichier de quota.",
    'class_anonftp__unable_read_quota_file' => "Impossible de lire le fichier de quota: %1",
    'class_anonftp__unable_update_quota' => "Impossible de mettre à jour le quota : les fichiers dans le répertoire entrant utilisent %1 Ko d'espace disque, ce qui est supérieur à la nouvelle valeur de quota.",
    'class_anonftp__unable_write_temp_file' => "Impossible d'écrire dans le dossier temporaire : %1",
    'class_bsdomain__warn_max_date__' => "La date d'expiration a été définie à %1",
    'class_cList__empty' => "Pas d'élément.",
    'class_cList__header' => "%1 (%2)",
    'class_cList__not_found' => "Aucune occurrence trouvée pour <b>\"%1\"</b> dans %2 (%3 sur %4)",
    'class_cList__search_result' => "Résultat de recherche pour <b>\"%1\"</b> dans %2 (%3 sur %4)",
    'class_client__client_creation_notification' => "Notification de la création de clients.",
    'class_client__client_with_contact_name_already_exists' => "Le client portant le nom %1 existe déjà.",
    'class_client__disk_space' => "Espace disque",
    'class_client__invalid_max_dom' => "Nombre de domaines incorrect, seuls les chiffres sont acceptés.",
    'class_client__limit_exceed' => "Le total requis de %1 ne peut pas être alloué car cela dépasserait les allocations pour le compte du client %2 (%3). Si vous voulez allouer plus de ressources, allez dans Clients > nom de client > Limites et changez les allocations comme requis. Puis revenez à cet écran et essayez de réajuster les allocations.",
    'class_client__limit_exceed_unlimited' => "Si vous souhaitez allouer un total illimité de ressources (%1), vous devez tout d'abord aller dans Clients > nom du client > Limites, et sélectionnez la case Illimité correspondant au type de ressource requis. Puis revenez à cet écran et essayez de réajuster les allocations.",
    'class_client__max_box' => "Boîtes mail",
    'class_client__max_db' => "Bases de données",
    'class_client__max_maillists' => "Listes de diffusion",
    'class_client__max_subdom' => "Sous-domaines",
    'class_client__max_traffic' => "Trafic maximum",
    'class_client__max_wu' => "Utilisateurs Web",
    'class_client__max_dom_aliases' => "Alias de domaines",
    'class_client__mbox_quota' => "Quota de courriel",
    'class_client__unable_define_cl_status' => "Impossible de définir le statut du compte client : %1",
    'class_client__unable_define_inactive_dom' => "Impossible de définir les domaines inactifs %1.",
    'class_client__unable_del_ip' => "Impossible de supprimer les IP : %1",
    'class_db__db_name_not_set' => "Le nom de la base de données n'est pas défini.",
    'class_db__db_not_exist_for_curr_dom' => "La base de données n'existe pas pour ce domaine.",
    'class_db__invalid_db_or_dom_name' => "L'ID de la base de données ou du domaine est incorrecte pu le nom de la base de données n'est pas définie.",
    'class_db__invalid_pass' => "Le mot de passe est incorrect.",
    'class_db__mailgrp_member_exist' => "Le membre du groupe de mails existe déjà.",
    'class_db__access_hosts_notsupport' => 'Ce type de base de données ne prend pas en charge les paramètres des hôtes d\'accès',
    'class_db__unable_add' => 'Impossible d\'ajouter l\'enregistrement de l\'hôte d\'accès : %1',
    'class_db__unable_del' => 'Impossible de supprimer l\'enregistrement de l\'hôte d\'accès : %1',
    'class_db__inc_user_not_exist' => 'L\'utilisateur de BD "%1" n\'existe pas.',
    'class_db__inc_access_record_exist' => 'Cet enregistrement d\'accès existe déjà',
    'class_db__inc_access_record_not_exist' => 'Cet enregistrement d\'accès n\'existe pas',
    'class_db__inc_unable_del_last_record' => 'Impossible de supprimer le dernier enregistrement de l\'hôte d\'accès',
    'class_domtmpleditform__dns_master' => "Principal",
    'class_domtmpleditform__dns_slave' => "Secondaire",
    'class_domtmpleditform__dns_type' => "Type de la zone DNS du domaine",
    'clienttrafficlist_header' => "Trafic du domaine",
    'clienttrafficlist_header_of_client__' => "Trafic pour les domaines du client %1",
    'cmd_dns__a_dns_record_already_exist' => "Cet enregistrement entrera en conflit avec l'enregistrement A pour la zone.",
    'cmd_dns__domain_last_ns' => 'Impossible de supprimer le dernier enregistrement DNS NS pour le domaine',
    'cmd_dns__canonical_dom_name_is_invalid' => "Le nom canonique du domaine n'est pas correct.",
    'cmd_dns__cname_dns_record_already_exist' => "Cet enregistrement entrera en conflit avec l'enregistrement CNAME pour la zone.",
    'cmd_dns__cname_in_rr_combination' => 'Une combinaison incorrecte des enregistrements DNS est présente dans la zone DNS.',
    'cmd_dns__cname_coexist_with_data' => 'L\'enregistrement de la zone DNS CNAME ne peut pas coexister avec d\'autres enregistrements DNS dans la même zone.',
    'cmd_dns__dns_record_type_is_invalid' => "Un type d'enregistrement DNS est incorrect.",
    'cmd_dns__ext_host_is_not_resolved' => "Le nom canonique %1 ne résout pas vers un enregistrement A ou AAAA.",
    'cmd_dns__domain_restore_dns_zone_failed_add_record' => 'Impossible d\'ajouter l\'enregistrement %1 à la zone %2 : %3',
    'cmd_dns__mail_dom_name_is_invalid' => "Nom de l'échangeur de mail est incorrect.",
    'cmd_dns__mx_priority_is_invalid' => "Priorité MX incorrecte.",
    'cmd_dns__name_server_is_invalid' => "Le serveur de noms n'est pas bon.",
    'cmd_dns__network_mask_should_be_24_16_or_8' => "La valeur du masque de sous-réseau doit être 24, 16 ou 8.",
    'cmd_dns__this_dns_record_already_exists' => "Un enregistrement DNS de ce type existe déjà.",
    'cmd_dns__unable_add_record' => "Impossible d'ajouter '%1' enregistrement : %2",
    'cmd_dns__unable_add_a_record' => "Impossible d'ajouter un enreg. A : %1",
    'cmd_dns__unable_add_cname_record' => "Impossible d'ajouter un enreg. CNAME: %1",
    'cmd_dns__unable_add_dns_record' => "Impossible d'ajouter l'enregistrement DNS : %1.",
    'cmd_dns__unable_add_ext_ns_record' => "Impossible d'ajouter un enreg. EXT_NS: %1",
    'cmd_dns__unable_add_ns_record' => "Impossible d'ajouter un enreg. NS: %1",
    'cmd_dns__unable_add_ptr_record' => "Impossible d'ajouter un enreg. PTR: %1",
    'cmd_dns__unable_add_txt_record' => "Impossible d'ajouter des enregistrements TXT: %1",
    'cmd_dns__unable_create_dns_zone' => "Impossible de créer la zone DNS %1",
    'cmd_dns__unable_define_dns_record' => "Impossible de définir l'enregistrement DNS %1.",
    'cmd_dns__unable_get_default_dns_zone_status_set_true' => "Impossible de récupérer le statut des DNS par défaut : %1",
    'cmd_dns__unable_insert_a_record' => "Impossible d'ajouter l'enreg. A: %1",
    'cmd_dns__unable_insert_mx_record' => "Impossible d'ajouter l'enreg. MX: %1",
    'cmd_dns__unable_insert_ns_record' => "Impossible d'ajouter l'enreg NS: %1",
    'cmd_dns__unable_set_dns_zone_status' => "Impossible de configurer le statut de la zone DNS : %1",
    'cmd_domains__dom_already_exists' => "Le domaine %1 existe déjà.",
    'cmd_domains__dns_record_already_exists' => "Impossible de créer le domaine %1, car un enregistrement DNS vers l'hôte %1 existe déjà.",
    'cmd_domains__dom_already_exists1' => "Il y a %2 sous-domaines dans ce domaine. Le domaine %1 existe déjà.",
    'cmd_domains__dom_already_exists2' => "Le sous-domaine %1 existe déjà.",
    'cmd_domains__dalias_already_exists' => "Cet alias existe déjà.",
    'cmd_domains__domain_alias_already_exists' => 'Un alias de domaine portant un tel nom existe déjà.',
    'cmd_domains__unable_del_mail_for_dom' => "Impossible de supprimer le service de courriel du domaine: %1",
    'cmd_domains__unable_delete_anonymous_ftp' => "Impossible de supprimer le compte FTP anonyme du domaine : %1",
    'cmd_domains__unable_update_dom_param' => "Impossible de mettre à jour les paramètres du domaine : %1.",
    'cmd_domains__unable_rename_client_exist' => "le nom d'utilisateur de l'administrateur de domaine est déjà utilisé.",
    'cmd_hosting__hst_type_is_not_physical_hst' => "Le type d'hébergement n'est pas de type physique.",
    'cmd_hosting__unable_create_user' => "Impossible de créer un utilisateur %2: %1",
    'cmd_hosting__unable_define_ip_addr_for_name_based_virtual_hosts' => "Impossible de définir une adresse IP pour les hôtes virtuels en name-based : %1",
    'cmd_hosting__unable_del_old_hst' => "Impossible de supprimer l'hébergement préalablement configuré: %1",
    'cmd_hosting__unable_del_protected_directory' => "Impossible de supprimer le répertoire protégé : %1.",
    'cmd_hosting__unable_del_web_user' => "Impossible de supprimer l'utilisateur Web : %1",
    'cmd_hosting__unable_make/update_virtual_host' => "Impossible de créer ou mettre à jour l'hôte virtuel : %1",
    'cmd_hosting__unable_make_frame_forward_hst' => "Impossible de configurer l'hébergement en redirection par cadre.",
    'cmd_hosting__unable_rebuild_ftp_config' => "Impossible de recréer le fichier de configuration proftpd : %1.",
    'cmd_hosting__unable_set_up_ssl' => "Impossible de configurer SSL/TLS : %1.",
    'cmd_hosting__unable_unprotect_ssl_directory' => "Impossible d'enlever la protection du répertoire SSL/TLS : %1",
    'cmd_hosting__unable_update_dest_url' => "Impossible de mettre à jour l'URL de destination %1.",
    'cmd_hosting__unable_update_dns_zone_for_dom_unable_exec_util' => "Impossible de mettre à jour la zone de DNS pour le domaine : l'exécution de l'utilitaire a échoué.",
    'cmd_hosting__unable_update_ftp_passwd' => "Impossible de mettre à jour le mot de passe FTP %1.",
    'cmd_hosting__unable_update_user' => "Impossible de mettre à jour l'utilisateur %2: %1",
    'cmd_hosting__unknown_hst_type' => "Type d'hébergement inconnu.",
    'cmd_hosting__you_not_have_permission_del_hst' => "Vous n'avez pas l'autorisation d'arrêter le service d'hébergement.",
    'cmd_mail__autoresponder__not_configured' => "La réponse automatique pour ce compte mail n'est pas configurée",
    'cmd_mail__addr_already_used_in_mail_redirect' => "L'adresse %1 est déjà utilisée pour rediriger la messagerie.",
    'cmd_mail__alias_already_exists' => "l'alias existe déjà.",
    'cmd_mail__autoresp_id_and_mailname_id_not_match' => "L'ID de la réponse automatique et l'ID du compte mail ne coïncident pas.",
    'cmd_mail__autoresp_id_is_undefined' => "L'ID de la réponse automatique n'est pas défini.",
    'cmd_mail__mail_alias_already_exists_in_mail_name' => "Un alias de messagerie avec ce type de nom existe déjà pour le compte mail %1.",
    'cmd_mail__mail_name_already_exists_in_maillists' => "Le compte mail %1 est déjà abonné à cette liste de diffusion.",
    'cmd_mail__mail_name_alredy_exist_in_dom' => "Le compte mail %1 existe déjà dans ce domaine.",
    'cmd_mail__mail_name_not_exist' => "Ce compte mail n'existe pas.",
    'cmd_mail__mail_name_passwd_part' => "Le mot de passe ne doit pas contenir le nom du compte mail.",
    'cmd_mail__maillist_already_exist_in_this_dom' => "La liste de diffusion %1 existe déjà sur ce domaine.",
    'cmd_mail__mailname_already_exist_in_mg' => "Le compte mail %1 est déjà dans le groupe de messagerie.",
    'cmd_mail__mailname_already_exist_in_this_dom' => "Le compte mail %1 existe déjà dans ce domaine.",
    'cmd_mail__mailname_already_exists' => "Le compte mail existe déjà.",
    'cmd_mail__mailname_is_invalid' => "Le compte mail %1 est incorrect.",
    'cmd_mail__mailname_unable_update' => "Impossible de mettre à jour les propriétés des comptes mail :",
    'cmd_mail__max_autoresp_reached_for_this_dom' => "Le nombre maximum de réponses automatiques a été atteint pour ce domaine.",
    'cmd_mail__max_mail_groups_num_has_been_reached_for_this_dom' => "Le nombre maximum de groupes de messagerie a été atteint pour ce domaine.",
    'cmd_mail__max_num_of_redirects_has_been_reached_for_this_dom' => "Le nombre maximum d'outils de redirection a été atteint pour ce domaine.",
    'cmd_mail__max_postboxes_num_has_been_reached' => "Le nombre maximum de boîtes mails a été atteint.",
    'cmd_mail__no_members_specified' => "aucun membre spécifié.",
    'cmd_mail__the_passwd_is_too_simple_choose_another' => "Le mot de passe est trop simple, veuillez en choisir un autre.",
    'cmd_mail__this_addr_already_exist_in_mg_or_mn' => "Cette adresse mail est déjà utilisée.",
    'cmd_mail__unable_define_autoresp_id' => "Impossible de définir l'ID de la réponse automatique %1.",
    'cmd_mail__unable_update_mail_for_dom' => "Impossible de modifier les paramètres du service de messagerie pour le domaine %1",
    'cmd_mail__unable_del_mail_for_dom' => "Impossible de supprimer le service de messagerie du domaine %1.",
    'cmd_mail__unable_del_mail_redirection' => "Impossible de supprimer le service de la redirection de messagerie %1.",
    'cmd_mail__unable_remove_autoresp' => "Impossible de supprimer les réponses automatiques :  %1",
    'cmd_mail__unable_remove_mail_group_members' => "Impossible de supprimer les membres du groupe de messagerie : %1",
    'cmd_mail__unable_turn_off_mail_group' => "Impossible de désactiver le groupe de messagerie : %1",
    'cmd_mail__unable_update_mail_redirect' => "Impossible de reconfigurer le service de la redirection de messagerie %1.",
    'cmd_mail__uploaded_file_is_too_big' => "Le fichier envoyé est trop gros.",
    'cmd_mail__additionally' => "Additionnel:",
    'cmd_pd__invalid_login' => "Nom d'utilisateur incorrect.",
    'cmd_pd__this_user_already_exist' => "Un utilisateur de ce type existe déjà.",
    'cmd_pd__unable_define_hst_type' => "Impossible de définir le type d'hébergement.",
    'cmd_pd__unable_upd_pd_usr' => "Impossible de mettre à jour les propriétés de l'utilisateur du répertoire protégé : %1.",
    'cmd_pd__user_is_undefined' => "Utilisateur non défini.",
    'cmd_server__no_enough_free_disk_space' => "Pas assez d'espace disque.",
    'cmd_server__old_passwd_is_incorrect_please_try_again' => "Ancien mot de passe incorrect. Veuillez re-essayer.",
    'cmd_web_usr__max_web_users_reached_for_this_dom' => "Le nombre maximum d'utilisateurs web est atteint pour ce domaine.",
    'cmd_web_usr__unable_create_user' => "Impossible de créer l'utilisateur système: %1",
    'cmd_web_usr__unable_define_max_web_users_limit' => "Impossible de définir la limite maximum d'utilisateurs web: %1",
    'cmd_web_usr__user_already_exists' => "l'utilisateur existe déjà.",
    'cmd_web_usr__web_user_name_is_invalid' => "Le nom de l'utilisateur web %1 est incorrect.",
    'cmd_web_usr__web_user_not_exist' => "L'utilisateur web n'existe pas.",
    'common_func__exec_bad_argument' => "l'argument exec ne doit pas contenir de guillemets.",
    '__eol' => 'Retours à la ligne',
    'eol__binary_file' => 'Impossible de changer le style du retour à la ligne dans le fichier binaire.',
    'cp_access_admin_deny' => "L'accès de l'administrateur à partir de l'adresse '%1' est limité conformément à la politique de restriction d'accès aux adresses IP appliquée actuellement.",
    'create_domain_warn__' => "L'exception suivante a été faite pendant la création d'un domaine:",
    'create_domain__client_select' => 'Sélectionner les clients pour lesquels vous souhaitez créer le domaine',

    'dashboard__nav_button_name' => "Accueil",
    'dalias__list_title' => 'Alias de domaine pour le domaine %1',
    'dalias__list_legend' => 'Alias de domaines',
    'dalias__list_header' => 'Alias de domaines',
    'dalias__list_status' => 'S',
    'dalias__list_name' => 'Alias du nom de domaine',
    'dalias__list_ascii_name' => 'Au format ASCII',
    'dalias__remove_title' => 'Les alias de domaines suivants pour le domaine %1 seront supprimés :',
    'dalias__select_domain_aliases_to_remove' => 'Sélectionnez les alias de domaines que vous voulez supprimer.',
    'dalias__mail_turn_on_failed' => 'Impossible d\'activer le service de messagerie : %1',
    'dalias__web_turn_on_failed' => 'Impossible d\'activer le service Web : %1',
    'db_usr_edit__db_usr_name_old' => "Ancien nom d'utilisateur de la base de données",
    'database_server_edit_form__cannot_infer_type' => 'Impossible de déduire la méthode de connexion à partir des données fournies. Spécifiez "127.0.0.1" en tant que nom d\'hôte du serveur de bases de données pour vous connecter via TCP/IP avec le port fourni, ou laissez le champ port vierge pour utiliser le socket Unix "%1".',
    'database_server_edit_form__duplicate' => 'Un serveur de bases de données avec cette combinaison d\'adresse d\'hôte et de numéro de port est déjà enregistré.',
    'database_server_edit_form__host_is_invalid' => 'Le nom d\'hôte spécifié n\'est pas valide.',
    'database_server_edit_form__port_is_invalid' => 'Le numéro du port saisi n\'est pas valide.',
    'database_server_error__consult_admin' => 'Veuillez contacter l\'administrateur du serveur.',
    'database_server_error__last__connection_failed' => 'Échec de la dernière tentative pour contrôler ce serveur de bases de données à cause de problèmes de réseau.',
    'database_server_error__last__permission_denied' => 'La dernière tentative pour prendre le contrôle de ce serveur de bases de données a échoué car il n\'y a pas de privilèges administrateur pour ce compte.',
    'database_server_error__last__credentials_not_set' => "La dernière tentative de connexion à ce serveur a échoué, car aucun mot de passe et nom d'utilisateur administrateur valide n'a été indiqué.",
    'database_server_error__last__other_error' => 'Échec de la dernière tentative pour contrôler ce serveur de bases de données.',
    'database_server_error__real__connection_failed' => 'La connexion au serveur de bases de données a échoué à cause de problèmes de réseau :',
    'database_server_error__real__permission_denied' => 'La connexion au serveur de bases de données a échoué car le compte indiqué ne dispose pas des droits d\'administrateur :',
    'database_server_error__real__duplicate_object' => 'La connexion au serveur de bases de données a échoué à cause d\'un conflit de nom :',
    'database_server_error__real__unacceptable_name' => 'La connexion au serveur de bases de données a échoué car le nom de l\'objet est incorrect :',
    'database_server_error__real__unacceptable_password' => 'La connexion au serveur de bases de données a échoué car le mot de passe est incorrect :',
    'database_server_error__real__credentials_not_set' => "Plesk ne peut pas se connecter au serveur de bases de données, car aucun mot de passe et nom d'utilisateur administrateur valide n'a été indiqué.",
    'database_server_error__real__other_error' => 'Échec de la connexion au serveur de base de données :',
    'database_server_error__test__connection_failed' => 'Le test de connexion au serveur de bases de données a échoué à cause de problèmes de réseau :',
    'database_server_error__test__permission_denied' => 'Le test de connexion au serveur de bases de données a échoué, car le compte indiqué ne dispose pas des droits d\'administrateur :',
    'database_server_error__test__duplicate_object' => 'Le test de connexion au serveur de bases de données a échoué à cause d\'un conflit de nom :',
    'database_server_error__test__unacceptable_name' => 'Le test de connexion au serveur de bases de données a échoué à cause d\'un nom d\'objet non valide :',
    'database_server_error__test__unacceptable_password' => 'Le test de connexion au serveur de bases de données a échoué à cause d\'un mot de passe incorrect :',
    'database_server_error__test__credentials_not_set' => "Le test de connexion à ce serveur a échoué, car aucun mot de passe et nom d'utilisateur administrateur valide n'a été indiqué.",
    'database_server_error__test__other_error' => 'Le test de connexion au serveur de bases de données a échoué :',

    'db__create_new_db' => "Ajouter une base de données",
    'db__db_add' => "Ajouter une base de données",
    'db__db_for_dom' => "Bases de données du site Web %1",
    'db__db_id_undefined' => "L'ID de la base de données n'est pas défini.",
    'db__db_name' => "Nom de la base de données",
    'db__db_not_exist' => "La base de données n'existe pas.",
    'db__db_type' => "Type",
    'db__db_server' => "Serveur de bases de données",
    'db_server_not_exist' => "Le serveur de bases de données n'existe pas.",
    'db__db_user_not_exist' => "Cet utilisateur de BD n'existe pas.",
    'db__domain_not_exist' => "Domaine inexistant.",
    'db__enter_db_name' => "Entrer un nouveau nom de base de données.",
    'db__invalid_db_id' => "L'identifiant de la base de données est incorrect.",
    'db__invalid_db_name' => "Le nom de la base de données est incorrect. Il ne doit contenir que des signes de l'alphabet latin, des chiffres ou des tirets bas et ne doit pas excéder 63 caractères.",
    'db__max_db_reached_for_dom' => "La limite du nombre de BD autorisées pour ce domaine est dépassée.",
    'db__max_mssql_db_reached_for_dom' => "Le nombre maximum de bases de données Microsoft SQL est atteint pour ce domaine",
    'db__postgres_not_connect_for_admin' => "Connexion à  PostgreSQL impossible. Activez le support PostgreSQL sur la page d'administrateur du serveur.",
    'db__postgres_not_connect_for_client' => "Connexion à  PostgreSQL impossible. Consultez votre administrateur système pour avoir de l'aide.",
    'db__remove_db_on_domain' => "Les bases de données suivantes Java sous le site Web %2 que possède le client %1 seront supprimées :",
    'db__remove_db_on_domain_of_cl' => "Les bases de données suivantes pour le domaine %2 que possède le client %1 seront supprimées :",
    'db__remove_db_linked_resource' => 'Cette base de données est utilisée par une application Web. Elle peut être supprimée uniquement après la désinstallation de cette application Web.',
    'db__remove_db_users' => "Les utilisateurs suivants de la base de données %3 sous le site Web %2 que possède le client %1 seront supprimes :",
    'db__remove_db_users_of_cl' => "Les utilisateurs suivants de la base de données %3 sous le site Web %2 que possède le client %1 seront supprimes :",
    'db__select_db_for_remove' => "Sélect. les bases de données à supprimer.",
    'db__select_db_users_for_remove' => "Sélectionner les utilisateurs de base de données à supprimer.",
    'db__unable_create_db_user' => "Impossible de créer l'utilisateur de base de données: %1",
    'db__unable_define_db_name' => "Impossible de définir le nom de la base de données: %1",
    'db__unable_define_db_user' => "Impossible de définir l'utilisateur de base de données: %1",
    'db__unable_define_db_users' => "Impossible de définir l'utilisateur de base de données: %1",
    'db__unable_select_dom_name' => "Impossible de sélectionner le nom de domaine: %1",
    'db_edit__db_for_dom' => "Utilisateurs sur la base de données %1 du domaine %2",
    'db_edit__invalid_db_name' => "Le nom de la base de données est incorrect.",
    'db_edit__no_users' => "Il n'y a pas d'utilisateur ayant des droits d'accès pour cette base de données.",
    'db_edit__unable_define_db_usrs' => "Impossible de définir l'utilisateur de la base de données: %1",
    'db_edit__unable_select_db_usr' => "Impossible de sélectionner l'utilisateur de la base de données.",
    'db_edit__db_user_password_for_' => "Saisissez le mot de passe pour vous connecter en tant qu'utilisateur %1 de la DB.",
    'db_list__tab_title_db_type' => "T",
    'db_usr_edit__add_db_usr' => "Ajouter l'utilisateur de la base de données",
    'db_usr_edit__db_usr_name' => "Nom de l'utilisateur de la base de données",
    'db_usr_edit__edit_db_usr' => "Configurer les données d'accès du compte de l'utilisateur de la DB",
    'db_usr_edit__for_db' => "dans la base de données %1",
    'db_usr_edit__not_create_pass' => "Cette opération entraînera la création d'un compte utilisateur pour la base de données sans mot de passe.\nVoulez-vous créer un utilisateur sans lui assigner de mot de passe ?",
    'dbuser__only_one_user_can_be_default' => "Un seul utilisateur peut être défini comme utilisateur par défaut.",
    'db_server__cannot_delete_default' => "Impossible de supprimer le serveur par défaut de la base de données",
    'db_server__cannot_delete_local' => "Impossible de supprimer le serveur local de la base de données",
    'db_server__cannot_delete_used' => 'Un serveur de bases de données ne doit pas être supprimé tant que des bases de données ou des utilisateurs de bases de données y sont hébergés.',
    'demo__disabled_in_demo' => "Cette opération est impossible dans la version de démonstration",
    'defaultcomponents__title' => "Sélection des composants par défaut",
    'defaultcomponents__select_default' => "Sélectionnez le composant %1 par défaut", //to check
    'defaultcomponents__not_installed' => "(n'est pas installé)",
    'defaultcomponents__not_configured' => "(pas configuré)", // to check
    'defaultcomponents__not_opted_to_install_support_files' => "Les sélections de certaines catégories de services ne sont pas valables, ou aucune sélection n'a été faite.",
    'defaultcomponents__depends_on' => "(requiert %1)",
    'defaultcomponents__parameters' => "Paramètres de %1",
    'component_name__antivirus' => "Antivirus",
    'component_name__database' => "Serveur SQL",
    'component_name__sqladmin' => "MySQL Webadmin",
    'component_name__sqladminmysql' => "MySQL Webadmin",
    'component_name__dnsserver' => "Serveur DNS",
    'component_name__firewall' => "Pare-feu",
    'component_name__ftpserver' => "Serveur FTP",
    'component_name__java' => "Java",
    'component_name__mailserver' => "Serveur de messagerie",
    'component_name__local_mailserver' => "Serveur de messagerie local",
    'component_name__psa' => "Plesk",
    'component_name__script' => "Script Web",
    'component_name__spamfilter' => "Filtre anti-spam",
    'component_name__stats' => "Statistiques Web",
    'component_name__stunnel' => "Wrapper SSL/TLS",
    'component_name__webmail' => "Messagerie Web",
    'component_name__webpublish' => "Publication Web",
    'component_name__webserver' => "Serveur Web",
    'dns__dns_record_invalid_values' => 'Des valeurs incorrectes ont été indiquées pour l\'enregistrement DNS : %1 : %2',
    'dns__dns_record_not_found' => 'Enregistrement DNS non trouvé',
    'dns__dns_zone_invalid_values' => 'Les valeurs incorrectes du paramètre de la zone DNS ont été indiquées.',

    'dns__soa_mname_title' => 'Serveur de noms principal',
    'dns__soa_mname_legend' => 'Serveur de noms',
    'dns__soa_mname_autoselect' => '(Sélection automatique)',

    'dns__dns_zone_off_remove_title' => "Les enregistrements de ressource suivants seront supprimés de la zone %1:",
    'dns__dns_zone_master_remove_title' => "Suppression des enregistrements de ressources à partir de la zone DNS %1",
    'dns__dns_zone_slave_remove_title' => "Les enregistrements du serveur de noms principal suivants pour %1 seront supprimés :",
    'dns_add__param_ttl' => "TTL",
    'dns_add__enter_spf' => 'Taper la chaîne de l\'enregistrement',
    'dns_add__is_spf_syntax' => 'Enregistrement SPF',
    'dns_add__spf_value_is_invalid' => "La valeur d'enregistrement SPF est incorrecte, elle doit commencer par 'v=spf'",
    'dns__dns_zone_status' => "Statut de la zone DNS.",
    'dns__invalid_ip_address' => "L'adresse IP du nouveau serveur DNS principal est incorrecte ou vide.",
    'dns__ip_address' => "Adresse IP",
    'dns__master_dns_type' => "est un serveur DNS principal",
    'dns__masters' => "serveurs DNS principaux",
    'dns__soa_minimum_too_large' => 'Il est déconseillé de stocker les réponses négatives dans la mémoire pendant plus de 3 heures.',
    'dns__select_masters_to_remove' => "Sélectionnez les serveurs DNS primaires à supprimer.",
    'dns__select_template_record_to_remove' => 'Sélectionnez les enregistrements des templates DNS à supprimer.',
    'dns__nameservers_for_domain' => "Serveurs de noms pour le domaine",
    'dns__remove_dns_zone_of_domain__' => "Effacement de l'enregistrement DNS du domaine %1",
    'dns__remove_dns_zone_template__' => "Les enregistrements DNS suivants seront supprimés du template :",
    'dns__remove_this_dns_record?' => "Êtes-vous certain de vouloir supprimer cet enregistrement DNS ?",
    'dns__restore_default' => "Restauration de la zone DNS avec le template",
    'dns__restore_default_confirm' => "Restaurer la zone DNS ignorera la configuration de la zone DNS actuelle. Voulez-vous continuer quand même ?",
    'dns__restore_default_error' => "Erreur lors de la restauration de la zone DNS :",
    'dns__slave_dns_type' => "est un serveur DNS secondaire",
    'dns__subdomain_dns_rec_removed' => "L'enregistrement A a été supprimé de la zone de sous-domaine %1.",
    'dns__zone_switched_off_no_ns' => "La zone a été désactivée car il n'y a aucun enregistrement NS %1 alors qu'il en faut dans la zone. Pour ajouter l'enregistrement dans la zone, cliquez sur le bouton Ajouter un enregistrement.",
    'dns__cant_switch_on_no_ns' => "Impossible d'activer la zone, car elle ne contient aucun enregistrement NS %1 alors que la zone en requiert un. Pour ajouter l'enregistrement dans la zone, cliquez sur le bouton \"Ajouter un enregistrement\".",
    'dns__unable_activate/deactivate_dns' => "Impossible d'activer/désactiver les DNS : %1",
    'dns__unable_add_dns_master_duplicate_entry' => "Impossible d'ajouter le serveur DNS principal : doublon.",
    'dns__unable_add_dns_master_local_ip' => "Impossible d'ajouter l'adresse IP pour le serveur DNS principal : vous devez créer cet enregistrement sur un serveur distant.",
    'dns__unable_define_dns_record' => "Impossible de définir l'enregistrement DNS : %1",
    'dns__unable_get_dns_template_status' => "Impossible d'obtenir le statut du template DNS.",
    'dns__unable_remove_dns_rec' => "Impossible de supprimer l'enregistrement DNS: %1",
    'dns__warnings__' => "Le résultat de la modification de la zone DNS :",
    'dns__you_not_have_perm_manage_dns' => "Vous n'avez pas l'autorisation de gérer les zones DNS pour ce domaine.",
    'dns__cant_create_record_with_server_ip' => "Impossible d'ajouter cette adresse IP, car elle correspond à l'adresse IP de ce serveur géré par Plesk.",

    'dns__tabs_acl' => "Transferts de zones",
    'dns__acl_add_network_legend' => "Ajouter un réseau",
    'dns__acl_add_ip_legend' => "Ajouter une adresse IP",
    'dns__acl_network_not_allowed' => "Cette adresse réseau n'est pas autorisée niveau DNS par Windows.",
    'dns__acl_enter_ip_address_with_mask' => "Adresse IP/masque",
    'dns__acl_enter_ip_address' => "Adresse IP",
    'dns__acl_list_network_legend' => "Réseaux autorisés à obtenir une copie de la zone DNS",
    'dns__acl_list_ip_legend' => "Adresses IP autorisées à obtenir une copie de la zone DNS",
    'bt_dns_acl_add_network' => "Ajouter un réseau",
    'bt_dns_acl_add_ip' => "Ajouter une adresse IP",

    'dns_add__add_rec_for_zone' => "Ajout %1 pour la zone %2",
    'dns_add__canonical_dom_name_is_invalid' => "Le nom canonique du domaine n'est pas correct.",
    'dns_add__enter_canonical_name' => "Nom canonique",
    'dns_add__enter_dom_name' => "Nom de domaine",
    'dns_add__enter_ip_address' => "Adresse IP",
    'dns_add__enter_ip_mask' => "Adresse IP et masque réseau",
    'dns_add__enter_mail_domain' => "Domaine de messagerie",
    'dns_add__enter_mail_exchanger' => "Serveur d'échange de mails",
    'dns_add__enter_nameserver' => "Serveur de noms",
    'dns_add__enter_txt_record' => "Enregistrement TXT",
    'dns_add__enter_service_name' => "Nom du service",
    'dns_add__hint_service_name' => "Exemple : SIP (sans tiret bas)",
    'dns_add__enter_protocol' => "Protocole",
    'dns_add__hint_protocol_name' => "Exemple : TCP (sans tiret bas)",
    'dns_add__protocol_tcp' => "TCP",
    'dns_add__protocol_udp' => "UDP",
    'dns_add__enter_srv_priority' => "Priorité",
    'dns_add__specify_weight_of_service' => "Poids moyen pour les enregistrements qui ont la même priorité",
    'dns_add__enter_target_host' => "Hôte cible",
    'dns_add__hint_target_host' => "Exemple : example.com",
    'dns_add__enter_target_port' => "Port cible",
    'dns_add__caa_tag' => "Balise",
    'dns_add__caa_value' => "Valeur",
    'dns_add-invalid-A_ip' => "Adresse IP incorrecte.",
    'dns_add-invalid-AAAA_ip' => "Adresse IP incorrecte.",
    'dns_add-invalid-PTR_ip_mask' => "Paire d'adresse IP/masque de sous-réseau non valable.",
    'dns_add-invalid-SRV_service_name' => "Nom du service non valide",
    'dns_add-invalid-SRV_protocol_name' => "Protocole non valide",
    'dns_add-invalid-SRV_target_port' => "Port cible non valide",

    'dns_add__invalid_ip' => "Adresse IP incorrecte.",
    'dns_add__low' => "basse",
    'dns_add__mail_dom_name_is_invalid' => "Nom du domaine de messagerie incorrect.",
    'dns_add__nameserver_is_invalid' => "Le serveur de noms n'est pas bon.",
    'dns_add__record' => "enregistrement %1",
    'dns_add__select_prefer_for_mail_exchange_server' => "Spécifier la priorité du serveur d'échange de mails",
    'dns_add__unable_insert_new_dns_rec' => "Impossible d'ajouter un nouvel enregistrement DNS: %1",
    'dns_add__very_high' => "Très haut",
    'dom_ctrl__allowed' => "Autorisé",
    'dom_ctrl__db' => "Bases de données MariaDB/MySQL",
    'dom_ctrl__mssql_db' => "Bases de données MS SQL",
    'dom_ctrl__disk_space' => "Espace disque",
    'dom_ctrl__dom_adm' => "Domaine %1 de %2",
    'dom_ctrl__dom_cl' => "Domaine %1",
    'dom_ctrl__domain_has_forwarding_with_undefined_fwd_url' => "Une redirection est configurée pour ce domaine, mais l'URL de redirection n'est pas précisée.",
    'dom_ctrl__domain_has_frame_forwarding' => "Une redirection par cadre vers l'URL %1 est configurée pour ce domaine",
    'dom_ctrl__domain_has_no_hosting' => "Aucun type d'hébergement n'est configuré pour ce domaine",
    'dom_ctrl__domain_has_physical_hosting' => "L'hébergement Web est configuré pour ce domaine sur l'adresse IP %1",
    'dom_ctrl__domain_has_standard_forwarding' => "Une redirection standard sur l'URL %1 est configurée pour ce domaine",
    'dom_ctrl__maillists' => "Listes de diffusion",
    'dom_ctrl__mboxes' => "Boîtes mail",
    'dom_ctrl__mg' => "Redirection de mails",
    'dom_ctrl__resource_name' => "Ressource",
    'dom_ctrl__resp' => "Réponses automatiques",
    'dom_ctrl__subdom' => "Sous-domaines",
    'dom_ctrl__dom_aliases' => "Alias de domaines",
    'dom_ctrl__traffic' => "Trafic",
    'dom_ctrl__unable_activate/deactivate_dom' => "Impossible d'activer/suspendre le domaine : %1",
    'dom_ctrl__used' => "Utilisé",
    // end of serge part

    // maverick part
    'dom_ctrl__wu' => "Utilisateurs Web",
    'dom_pref__bounce_with_phrase' => "Rejeter avec un message",
    'dom_pref__bounce' => "Rejeter",
    'dom_pref__catch_addr' => "Transférer à l'adresse",
    'dom_pref__reject' => 'Rejeter',
    'dom_pref__confirm_domain_removing' => "Veuillez ne pas oublier d'informer l'utilisateur du domaine du changement de nom de domaine. Êtes vous certain de vouloir renommer le domaine?",
    'dom_pref__db_inconsystency' => "Inconsistance dans la base de données.",
    'dom_pref__dbs' => "bases de données",
    'dom_pref__delete_traffic_stat' => "Conserver les statistiques du trafic et du Web",
    'dom_pref__delete_traffic_stat_older' => "Conserver les statistiques du trafic et du Web",
    'dom_pref__dom_level_name_conflict' => "Le nom d'utilisateur de l'administrateur de domaine est en conflit avec un nom d'utilisateur de l'un des clients.",
    'dom_pref__invalid_disk_space_limit' => "Valeur d'espace disque maximum incorrecte. Valeur maximum : %1",
    'dom_pref__invalid_expiration_date_limit' => "Période de validité incorrecte.",
    'dom_pref__invalid_max_traffic_limit' => "Valeur du trafic maximum incorrecte. Valeur maximum : %1",
    'dom_pref__limits_of_dom' => "Limites pour le domaine %1",
    'dom_pref__mail_grps' => "groupes de messagerie",
    'dom_pref__mail_nonexistent_user' => "Que faire avec les mails envoyés à des utilisateurs inexistants",
    'dom_pref__mail_redirs' => "outils de redirection de mails",
    'dom_pref__mail_resps' => "réponses automatiques de la messagerie",
    'dom_pref__max_limit_is_invalid' => "%1 est incorrect.",
    'dom_pref__max_num_of_%objects_is_invalid' => "Le nombre maximum de %1 est incorrect.",
    'dom_pref__new_limit_less_currently_used' => "%1: requis - %2, utilisé actuellement - %3",
    'dom_pref__older_that' => "pendant",
    'dom_pref__postboxes' => "boîtes mail",
    'dom_pref__preferences_of_dom' => "Paramètres du domaine %1",
    'dom_pref__redirect_to_itself' => "Le domaine sera redirigé vers lui-même",
    'dom_pref__traffic_logging_period_couldnt_be_lower' => "Vous avez indiqué une durée de conservation des statistiques du domaine inférieure à la valeur définie pour le serveur (%1 mois). La période de conservation des statistiques est calquée sur la valeur par défaut pour le serveur (%1 mois).",
    'dom_pref__unable_add_www_prefix_in_dom' => "Impossible d'ajouter un préfixe www au domaine : %1",
    'dom_pref__unable_define_physical_hst_param' => "Impossible de définir les paramètres d'hébergement physique: %1",
    'dom_pref__unable_rename_domain' => "Impossible de renommer le domaine %1 : %2",
    'dom_pref__unable_set_up_mbox_quota' => "Impossible de configurer le quota de courriel pour ce domaine : %1",
    'dom_pref__unable_set_up_web_user_script' => "Impossible de configurer le scripting pour les utilisateurs web : %1",
    'dom_pref__unlimited' => "Illimité",
    'dom_pref__web_usrs' => "utilisateurs Web",
    'dom_pref__you_already_have_%object' => "Vous avez déjà %1",
    'cu_domain__error_unable_update_ftp_users' => 'Échec de la mise à jour des utilisateurs FTP du domaine : %1',
    'dom_cli__warning_ignore_quota' => 'ATTENTION : l\'option  "-hard_quota" est ignorée : le quota de disque n\'est pas pris en charge.',
    'dom_user_client_login_exist' => "Impossible d'autoriser l'accès de l'administrateur de domaine à Plesk sur le domaine %1 : ce nom d'utilisateur est déjà utilisé.",
    'domain__unable_to_turn_on_service' => "Impossible d'activer le service %1.",
    'domains__change_the_status_of_domain?' => "Êtes vous certain de vouloir changer le statut du domaine %1?",
    'domains__client_info_hiding_traffic' => "%1 domaines, %2 domaines actifs, %3 espace disque utilisé",
    'domains__unable_to_change_client_status' => "Impossible de changer le statut du compte client : %1",
    'domains__unable_update_apache_settings' => "Impossible de mettre à jour les paramètres Apache.",
    'domains__you_do_not_have_permissions_to_delete_domains' => "Vous n'avez pas la permission de supprimer un domaine.",
    'domains_list__unable_remove_doms' => "Impossible de supprimer les domaines : %1",
    'domaintrafficlist_header_of_domain__' => "Trafic du domaine %1",

    'domain_aliases_remove__select_domain_aliases_for_remove' => 'Sélectionnez les alias de domaines que vous voulez supprimer.',
    'domain_aliases_remove__title' => 'Suppression d\'alias de domaine',
    'domain_aliases__max_aliases_reached_for_dom' => "Le nombre maximum d'alias est atteint pour ce domaine.",
    'domain_edit__edit_title' => 'Éditer le nom de l\'alias de domaine',
    'domain_alias_edit__type' => 'Type de l\'alias de domaine',
    'domain_aliases__list_header' => 'Alias de domaines',
    'domain_aliases__name' => 'Nom',
    'domain_aliases__type' => 'Type',
    'domain_aliases__type_full' => 'Web+FTP+Mail',
    'domain_aliases__type_web_ftp' => 'WEB+FTP',
    'domain_aliases__page_title' => 'Alias de domaines',
    'domain_aliases__legend' => 'Alias de domaines',
    'domain_alias__domain_exists' => 'Un domaine portant un tel nom existe déjà',
    'domain_alias__subdomain_exists' => 'Un sous-domaine portant un tel nom existe déjà',
    'domain_alias__dns_record_exists' => 'Un enregistrement DNS avec le nom de l\'alias de domaine indiqué existe déjà',
    'domain_alias__domain_alias_exists' => "Un alias de domaine portant un tel nom existe déjà.",
    'domain_alias__invalid_type_full' => 'Le serveur de messagerie ne prend pas en charge les alias de domaines.',
    'domain_alias__redirect_exists' => 'La redirection vers elle-même a été détectée.',

    'ds__anonymous_ftp' => "FTP anonyme",
    'drweb__pagetitle' => 'Paramètres antivirus',
    'drweb__drweb' => 'Contrôle antivirus du mail',
    'drweb__drweb_direction' => 'Analyse de la messagerie à la recherche de virus',
    'drweb__drweb_direction_off' => 'Ne pas chercher s\'il y a des virus',
    'drweb__drweb_direction_any' => 'Mail entrant et sortant',
    'drweb__drweb_direction_from' => 'Uniquement les mails sortants',
    'drweb__drweb_direction_to' => 'Mail entrant uniquement',
    'drweb__disable_reason_key' => 'La licence ne prend pas en charge l\'antivirus.',
    'drweb__disable_reason_perm' => 'Vous n\'avez pas les droits requis pour gérer l\'antivirus.',
    'drweb__disable_reason_install' => 'L\'antivirus n\'est pas installé.',
    'drweb__filters' => 'Filtres antivirus',
    'ds__dns' => "Zone DNS",
    'ds__mail' => "Boîte mail",
    'dumps_list__deletion_page_title' => "Les fichiers de sauvegarde suivants du domaine %1 seront supprimés :",
    'dumps_list__dumpfile_is_invalid' => "Le fichier %1 n'est pas un fichier de sauvegarde de domaine valable.",
    'dumps_list__page_title' => "Stockage des fichiers de sauvegarde",
    'dumps_upload__page_title' => "Charger les fichiers de sauvegarde dans le stockage",
    'dumps_list__repository_is_not_exist' => "Le stockage des fichiers de sauvegarde n'existe pas.",
    'dumps_list__unable_to_remove' => "Impossible de supprimer le fichier de sauvegarde : %1",
    'dumps_list__dumpfile_can_conflict' => "Le nom de fichier indiqué est en conflit avec le fichier %1. Changez le nom du fichier.",
    'dusr_ed__allow_dl_usr_access' => "Autoriser l'accès à l'administrateur du domaine",
    'dusr_ed__information' => "Propriétés de l'administrateur du domaine %1",
    'dusr_ed__locale' => "Langue de l'administrateur du domaine",
    'dusr_ed__skin' => "Skin de l'interface de l'administrateur du domaine",
    'dusr_ed__personal_information' => 'Informations personnelles',
    'ess__error' => "Erreur",
    'example__' => "Exemple: %1",
    'extras__allow_certificate_purchasing' => "Autoriser l'achat de certificat",
    'extras__allow_domain_registration' => "Autoriser le dépôt de noms de domaine",
    'extras__allow_extras' => "Autoriser les services supplémentaires",
    'extras__buy_new_key' => "Votre clé de licence actuelle ne vous permet pas de modifier ces objets.",
    'extras__setup_services' => "Configurer des services en plus",

    'ruleeditform__error' => 'Impossible de mettre à jour la règle du pare-feu.',
    'ruleeditform__name_is_required' => 'Indiquez le nom de la règle.',
    'ruleeditform__profiles_is_required' => 'Sélectionnez au moins un profil.',
    'ruleeditform__invalid_ip' => 'L\'adresse IP ou le réseau indiqué n\'est pas valide.',
    'ruleeditform__invalid_port' => 'Le port indiqué n\'est pas valide. Les valeurs possibles sont 1000 ou 1000-1051',

    'get_password__encrypted_password' => "Impossible d'envoyer les informations du mot de passe : le mot de passe est stocké en forme encodée.",
    'get_password__mail_error' => "Une erreur s'est produite en essayant d'envoyer le mot de passe à l'adresse mail %1 : %2",
    'get_password__mail_ok' => "Le mot de passe a bien été envoyé par mail : %1",
    'get_password__message' => "Votre nom d'utilisateur pour accéder au système : %1\nVotre mot de passe est %2",
    'get_password__subject' => "Mot de passe pour accéder au système",
    'groups__available' => "Groupes de messagerie disponibles",
    'groups__groups_for_mailname' => "Groupes de messagerie auquel est inscrit le compte mail %1",
    'groups__member_of' => "Membre des groupes de messagerie suivants",
    'help__help_area' => "Espace Aide.",
    'hst_def__auth_disabled' => "Interdit",
    'hst_def__auth_enabled' => "Autorisé",
    'hst_def__change_curr_dns_ip' => "L'adresse IP actuelle de l'enregistrement A de DNS sera modifiée.",
    'hst_def__cr_hosting_ip_dns_ip_not_equiv' => "Aucune des adresses IP de l'enregistrement DNS A ne coïncide avec l'adresse IP affectée au compte d'hébergement en cours de création",
    'hst_def__dest_url' => "URL de destination",
    'hst_def__disk_quota' => "Quota de disque",
    'hst_def__disk_space_limit_exceed_incoming_quota' => "La limite de l'espace disque que vous essayez de changer dépasse la limite fixée pour le répertoire entrant du FTP anonyme. La limite d'espace du répertoire entrant du FTP anonyme ne doit pas dépasser la limite d'espace allouée au domaine.",
    'hst_def__frame_forwarding_definition' => "Assignement de redirection par cadre pour le domaine %1",
    'hst_def__ftpuser_for_hst_not_exist_in_system' => "Avertissement : l'utilisateur FTP %1 est utilisé dans les paramètres du compte d'hébergement, mais n'existe pas dans le système.",
    'hst_def__hst_type_is_not_defined' => "Le type d'hébergement n'est pas défini",
    'hst_def__ip_based' => "Sur IP fixe",
    'hst_def__name_based_power_anonymous_ftp_down' => "Le transfert de ce compte d'hébergement en adresse IP partagée entraînera l'indisponibilité du service FTP anonyme sur ce domaine. Voulez-vous continuer quand même ?",
    'hst_def__password_is_invalid_password_syntax' => "Le mot de passe est incorrect.\nN'utilisez pas d'apostrophes ni de caractères alphabétiques locaux dans le mot de passe.\nLa longueur du mot de passe doit être comprise entre 5 et 14 caractères. Le mot de passe ne doit pas contenir le nom d'utilisateur.",
    'hst_def__shell' => "Accès SSH au shell du serveur sous l'utilisateur système de l'abonnement",
    'hst_def__shell_windows' => "Accès Remote Desktop au serveur sous l'utilisateur système de l'abonnement",
    'hst_def__standard_forwarding_definition' => "Redirection standard pour le domaine %1",
    'hst_def__title_name_based' => "Basé sur le nom",
    'hst_def__unable_create/update_physic_hst' => "Impossible de créer/mettre à jour l'hébergement physique: %1",
    'hst_def__unable_create/update_std_fwd' => "Impossible de créer/mettre à jour la redirection standard: %1",
    'hst_def__unable_create_forwarding_myself' => "Impossible de créer une redirection sur le domaine lui-même.",
    'hst_def__unable_turn_same_ssl_while_ssl_off' => "Impossible d'autoriser l'utilisation d'un répertoire unique pour stocker les contenus SSL/TLS et non-SSL/TLS : la prise en charge SSL/TLS n'est pas activée.",
    'hst_def__unable_turn_on_ssl_cert_not_defined' => "Impossible d'activer la prise en charge SSL/TLS : aucun certificat SSL/TLS n'est installé.",
    'hst_def__url_is_invalid' => "L'URL est incorrecte.",
    'hst_def__virtual_host_access' => "Accès à l'hôte virtuel pour le domaine %1",
    'hst_def__virtual_host_uses_non_existed_ip_address' => "ATTENTION. Cet hôte virtuel utilise une adresse IP inexistante pour l'hébergement.",
    'hst_def__you_have_no_ips' => "Vous n'avez pas d'adresse IP de disponible, et vous n'avez pas l'autorisation de créer un hébergement en name-based.",
    'hst_sel__header' => "Pour héberger un site Web sur ce serveur, sélectionnez l'option Hébergement physique.\n Pour configurer la redirection de domaine vers un site sur une autre machine, sélectionnez l'option Redirection par cadre ou la Redirection standard.\n Avec la redirection standard, un utilisateur est redirigé vers le site et l'URL du site réel s'affiche dans le navigateur de l'utilisateur. L'utilisateur connaît ainsi la redirection. Avec la redirection par cadre, un utilisateur est redirigé vers le site sans savoir que le site réside en réalité ailleurs.",
    'hst_sel__physical_hst' => "Hébergement physique",
    'hst_sel__select_hst_type' => "Sélectionner un type d'hébergement pour le domaine",
    'hst_sel__select_hst_type_warning' => "Sélectionner un type d'hébergement pour le domaine",
    'hst_sel__hosting_exists' => "Impossible de créer l'hébergement car il est déjà configuré pour ce domaine. Vous allez être redirigé sur la page de gestion des hébergements.",
    'hst_sel__standard_frw' => "Redirection standard",
    'hst_sel__frame_frw' => "Redirection par cadre",
    '__frame_frw' => "Redirection par cadre",
    '__hosting_exists' => "Impossible de créer l'hébergement car il est déjà configuré pour ce domaine. Vous allez être redirigé sur la page de gestion des hébergements.",
    '__choose_hst_type' => "Sélectionnez le type d'hébergement requis.",
    '__no_hst_conf' => "Il n'y a pas d'hébergement configuré pour ce domaine.",
    '__physical_hst' => "Hébergement physique",
    '__select_hst_type' => "Sélectionner un type d'hébergement pour le domaine",
    '__standard_frw' => "Redirection standard",
    '__warning' => "Attention ! Tous les paramètres définis précédemment seront perdus. Êtes-vous sûr de vouloir changer le type d'hébergement ?",
    'i_cl_off' => "Le client est inactif.",
    'i_cl_off_by_admin' => "Le compte client est suspendu par l'administrateur de serveur.",
    'i_cl_off_expired' => "Le compte client a expiré.",
    'i_cl_on' => "Le compte client est actif.",

    'icf__title' => 'Pare-feu de connexion Internet',
    'icf__if_legend' => 'Interfaces',
    'icf__mode' => 'Mode',

    'invalid_value' => 'La valeur est incorrecte',

    'ip_addr__already_exists' => "L'adresse IP %1 existe déjà.",
    'ip_addr__cant_add' => "L'adresse IP %1 n'existe pas ou n'appartient pas au pool d'IP de l'autre client",
    'ip_alias__interface' => "Interface",
    'ip_alias__invalid_ip_nm_bsd_vrt_hsts' => "L'adresse IP %1 pour hébergement virtuel en name-based n'est pas correcte.",
    'ip_alias__invalid_ip_or_netmask' => "Paire d'adresse IP/masque de sous-réseau non valable.",
    'ip_alias__orig_ip_can_not_be_deleted' => "L'adresse IP %1 est celle du serveur IP original. Vous ne pouvez pas la supprimer.",
    'ip_alias__ip_is_invalid' => "L'adresse IP %1 est incorrecte.",
    'ip_alias__ip_mask_is_invalid' => "Le masque d'IP %1 est incorrect.",
    'ip_alias__ip_not_exist' => "L'adresse IP %1 n'existe pas.",
    'ip_alias__ip_address_and_mask' => 'Adresse IP et masque sous-réseau',
    'ip_alias__mask' => "Masque de sous-réseau",
    'ip_alias__remove_selected_ip_aliases?' => "Êtes vous certain de vouloir supprimer l'alias IP choisi?",
    'ip_alias__select_ip' => "Sélectionner au moins une adresse IP à enlever.",
    'ip_alias__this_ip_used_for_domain' => "L'adresse IP (%1) est utilisée pour le domaine %2.",
    'ip_alias__this_ip_used_for_nm_bsd_vrt_hsts' => "Cette adresse IP (%1) est utilisée pour l'hébergement virtuel en name-based.",
    'ip_alias__unable_add_ip' => "Impossible d'ajouter l'IP: %1",
    'ip_alias__unable_remove_ip' => "Impossible d'enlever l'IP: %1",
    'ip_ctrl__anonymous_ftp_exists_in_domain' => "Vous ne pouvez pas modifier le type d'adresse IP en \"Partagé\", car avec ce paramétrage, le serveur FTP anonyme ne sera plus accessible pour le domaine '%1'.",
    'ip_ctrl__ip_addr' => "Adresse IP %2 sur l'interface %1",
    'ip_ctrl__ip_exists_many_pools' => "Impossible de changer le type d'IP. Cette adresse IP appartient aux pools de plusieurs utilisateurs en même temps.",
    'ip_ctrl__ssl_cert' => "Certificat SSL/TLS",
    'limit__date_in_past' => "La période de validité n'est pas bonne. %1 est dans le passé.",
    'limit__enter_date' => "Inscrire la date",
    'limit__max_db' => "Bases de données",
    'limit__name_disk_space' => "espace disque",
    'limit__name_max_box' => "boîtes mail",
    'limit__name_max_db' => "Bases de données MariaDB/MySQL",
    'limit__name_max_dom' => "domaines",
    'limit__name_max_maillists' => "listes de diffusion",
    'limit__name_max_subdom' => "Sous-domaines",
    'limit__name_max_traffic' => "trafic",
    'limit__name_max_wu' => "utilisateurs Web",
    'limit__name_mbox_quota' => "Quota de boîtes mail",
    'limit__name_max_mn' => "Comptes mail",
    'limit__name_max_cl' => 'Clients',
    'limit__name_total_mboxes_quota' => "quota total de boîtes mail",
    'limit__name_mysql_dbase_space' => "Espace de la base de données MariaDB/MySQL",
    'limit__name_mssql_dbase_space' => "Espace de la base de données MSSQL",
    'limit__name_pgsql_dbase_space' => "Espace de la base de données PostgreSQL",
    'limit__name_expiration' => 'date d\'expiration',

    'locale_upload__unable_to_install' => 'Impossible d\'installer le fichier du pack de langues',
    'locale_upload__wrong_package' => 'Le fichier que vous avez envoyé ne contient pas de pack de langues valable pour cette version de Plesk.',
    'locale_upload__wrong_locale' => 'Le fichier que vous avez envoyé ne contient pas de pack de langues valable.',

    'ma__create_title' => 'Création d\'un alias de messagerie pour %1',
    'ma__edit_title' => "Éditer l'alias de messagerie %1",
    'ma__enter_new_alias' => "Saisir un nouv. alias.",
    'ma__invalid_alias' => "Alias de messagerie incorrect.",
    'ma__mail_aliases_mailname' => "Alias de messagerie pour le compte mail %1",
    'ma__mailname_does_not_exist' => "Ce compte mail n'existe pas.",
    'ma__select_ma_for_remove' => "Sélect. alias de messagerie à supprimer.",
    'ma__unable_to_add_new_ma' => "Impossible d'ajouter un alias de messagerie : %1",

    'mail_queue__not_allowed_by_license_key' => 'La licence ne permet pas de gérer la file d\'attente des mails.',
    'maillist__' => "Liste de diffusion %1",
    'maillist__already_exists' => "Liste de diffusion existe déjà.",
    'maillist__mail_alias_already_exists_in_this_domain' => "L'alias du mail %1 existe déjà dans ce domaine",
    'maillists__' => "Listes de diffusion %1",
    'maillists__limit_cl_max_maillists' => "Le nombre max de listes de diffusion a été atteint pour le client (limite : %1, utilisée : %2)",
    'maillists__limit_dom_max_maillists' => "La limite du nombre de listes de diffusion a été atteinte pour le domaine.",
    'maillists__list' => "Listes de diffusion",
    'maillists__mailman_not_installed_or_conf' => "\nLes extensions serveur Mailman ne sont pas installées ou configurées\nsur le serveur. Contactez l'administrateur du serveur pour obtenir une installation ou une configuration correcte.",
    'maillists__status' => "Le service Liste de diffusion est activé.",
    'maillists__unable_to_delete__' => "Impossible de supprimer la liste de diffusion : %1",
    'maillists__disabled_text' => 'Impossible de gérer les listes de diffusion car le composant du serveur des listes de diffusion de Mailman n\'est pas installé ou n\'est pas configuré.',
    'maillist_member__already_exists' => 'Ce membre existe déjà dans la liste de diffusion.',
    'maillist_member__not_exists' => 'Cet utilisateur n\'existe pas dans la liste de diffusion.',
    'mailserver_switching_warning' => "Attention !\n\nUn changement de serveur de messagerie n'est prévu que lors de la configuration initiale. Si le serveur est déjà en production, le changement peut engendrer les problèmes suivants : perte de configurations et du contenu de boîtes aux lettres. En outre, si le serveur vers lequel vous basculez est déjà configuré, divers conflits peuvent apparaître.\nSi le serveur est actuellement en production et si vous voulez vraiment basculer sur un autre, vous pouvez avertir vos clients pour qu'ils puissent télécharger et sauvegarder leurs mails.",
    'manager__access_denied' => "Accès refusé : %1",
    'manager__admin' => "Administrateur",
    'manager__client' => 'Client',
    'manager__domain' => "Domaine",
    'manager__domain_cl_limit_exceeding' => "La limite du nombre de domaines est atteinte pour ce compte client.",
    'manager__domain_is_not_yours' => "Le domaine %1 ne vous appartient pas.",
    'manager__domain_key_limit_exceeding' => "La limite de création de domaines définie par votre clé de licence est atteinte.",
    'manager__no_perm_to_call' => "Vous n'avez pas le droit d'appeler %1.",
    'manager__no_perm_to_create_domains' => "Vous n'avez pas le droit de créer les domaines.",
    'manager__no_perm_to_modify_domain' => "Vous n'avez pas le droit de modifier le domaine %1.",
    'manager__no_perm_to_modify_domains' => "Vous n'avez pas le droit de modifier les domaines.",
    'manager__no_perm_to_remove_domain' => "Vous n'avez pas le droit de supprimer le domaine %1.",
    'manager__no_perm_to_remove_domains' => "Vous n'avez pas le droit de supprimer les domaines.",
    'manager__node_doesnt_exist' => "%1 n'existe pas.",
    'manager__user_disabled' => "Votre compte est suspendu. Impossible d'exécuter le système.",
    'mail_quota_unsupported' => "non pris en charge par le serveur de messagerie",
    'mbox_quota_unsupported' => "non pris en charge par le serveur de messagerie",
    'mn__create_title' => "Créer un compte mail",
    'mn__edit_title' => "Paramètres",
    'mn__files_list_title' => "Pièces j.",
    'mn__files_remove' => "Supprimer les fichiers du répertoire d'attachements. Ces fichiers sont certainement utilisés par les réponses automatiques. Ils seront supprimés à la fois du répertoire et des réponses automatiques les utilisant",
    'mn__files_select_for_remove' => "Sélect. fichiers à supprimer.",
    'mn__mail_alias_form' => "Form. alias de messagerie",
    'mn__mail_aliases_list' => "Alias de messagerie",
    'mn__mailbox' => "Gestion de boîtes aux lettres",
    'mn__unable_define_mn' => "Impossible de configurer les comptes mail : %1",
    'mn__unable_remove_mbox_quota' => "Impossible de supprimer le quota de boîtes de messagerie :  %1",
    'mn__upload_file' => "Envoyer un fichier",
    'mn_edit__attach_filename_changed' => 'Le fichier envoyé %1 a été renommé en %2 car son nom contenait des caractères non ASCII.',
    'mn_edit__add_mail_group_members_or_turn_off_box' => "Vous devez ajouter un membre du groupe de messagerie avant d'activer celui-ci.",
    'mn_edit__add_resp_or_turn_off_box' => "Vous devez ajouter une réponse automatique ou décocher la réponse automatique.",
    'mn_edit__attachments' => "Pièces jointes",
    'mn_edit__dom_quota_less_then_quota' => "La taille de cette boîte de messagerie ne doit pas dépasser la limite du total d'espace disque affectée aux boîtes de messagerie dans ce domaine.",
    'mn_edit__enter_external_rcpnt_email' => "Entrer l'adresse mail externe du membre du groupe",
    'mn_edit__enter_mail_redir_or_turn_off_box' => "Tapez une adresse pour la redirection de messagerie ou décochez la case.",
    'mn_edit__ext_rcpnt_email_invalid' => "L'adresse mail du destinataire externe est incorrecte.",
    'mn_edit__file_exists' => "Le fichier existe déjà. L'écraser ?",
    'mn_edit__files_deld_from_repository' => "Ces fichiers seront supprimés du répertoire et des réponses automatiques les contenant. Voulez-vous continuer ?",
    'mn_edit__mail_name' => "Compte mail",
    'mn_edit__mail_name_invalid' => "Le nom du compte mail est incorrect.",
    'mn_edit__mail_redir' => "Outils de redirection de mails",
    'mn_edit__mail_redir_add' => "Ajouter un membre au groupe de messagerie",
    'mn_edit__mail_resps' => "Réponses automatiques de la messagerie",
    'mn_edit__mailbox' => "Boîte mail",
    'mn_edit__enable_mailbox' => "Boîte mail",
    'mn_edit__mailgroup' => "Groupe mail",
    'mn_edit__mailgroup_addresses' => "Membres du groupe de messagerie",
    'mn_edit__mailgroup_disabled' => "Disponible uniquement lorsque le compte mail est déjà ajouté.",
    'mn_edit__max_dom_quota' => "Défaut pour le domaine (%1)",
    'mn_edit__mbox_quota_invalid' => "Volume du quota de courriel incorrect.",
    'mn_edit__new_resp_name' => "Nouveau nom de la réponse automatique",
    'mn_edit__no_autoresponders' => "Vous devez ajouter au moins une réponse automatique avant d'activer ou de désactiver le service de réponses automatiques.",
    'mn_edit__no_file_sel' => "Pas de fichiers sélectionnés.",
    'mn_edit__no_mail_addresses' => "Aucune adresse mail n'a été indiquée ou sélectionnée.",
    'mn_edit__none' => "Aucun",
    'mn_edit__not_create_pass' => "Cela ne créera pas de mot de passe pour ce compte.\nSans mot de passe, l'utilisateur pourra ni afficher ni envoyer le mail.",
    'mn_edit__redir_email_invalid' => "L'adresse de redirection est incorrecte.",
    'mn_edit__redirect_addr' => "Adresse de redirection",
    'mn_edit__remove_autoresp?' => "Voulez-vous vraiment supprimer la réponse automatique ?",
    'mn_edit__remove_rcpnts?' => "Êtes-vous sûr de vouloir supprimer ces destinataires ?",
    'mn_edit__repository' => "Répertoire",
    'mn_edit__resps_attach' => "Fichiers en pièces jointes de la réponse automatique",
    'mn_edit__select_rcpnt_from_list' => "Sélect. au moins un destinataire à supprimer.",
    'mn_edit__select_registered_users' => "Sélect. utilisateurs enregistrés",
    'mn_edit__selected_postbox_have_not_setup_passwd' => "Vous avez choisi d'avoir une boîte mail mais n'avez pas configuré son mot de passe.",
    'mn_edit__unable_act_deact_mail_group' => "Impossible d'activer ou de désactiver le groupe de messagerie : %1",
    'mn_edit__unable_act_deact_mail_redir' => "Impossible d'activer ou de désactiver la redirection de messagerie : %1",
    'mn_edit__unable_act_deact_postbox' => "Impossible d'activer ou de désactiver la boîte mail : %1",
    'mn_edit__unable_act_deact_resp' => "Impossible d'activer ou de désactiver les réponses automatiques : %1",
    'mn_edit__unable_add_attach' => "Impossible d'ajouter une pièce jointe : %1",
    'mn_edit__unable_add_mail_group_member' => "Impossible d'ajouter un membre au groupe messagerie : %1",
    'mn_edit__unable_add_resp' => "Impossible d'ajouter une réponse automatique : %1",
    'mn_edit__unable_change_mail_name' => "Impossible de changer le nom du compte mail : %1",
    'mn_edit__unable_deactivate_mail_group' => "Impossible de désactiver groupe messagerie : %1",
    'mn_edit__unable_deactivate_resp' => "Impossible de désactiver les réponses automatiques de la messagerie :  %1",
    'mn_edit__unable_define_resp_id' => "Impossible de définir l'ID de la réponse automatique : %1",
    'mn_edit__unable_remove_attach' => "Impossible de supprimer une/des pièce(s) jointe(s) : %1",
    'mn_edit__unable_remove_autoresp' => "Impossible de supprimer la réponse automatique : %1",
    'mn_edit__unable_remove_mail_group_member' => "Impossible d'enlever des membres du groupe de messagerie : %1",
    'mn_edit__wrong_way' => 'Les messages destinés à %1 ne seront pas livrés, car aucune boîte mail ni outil de redirection de mails n\'est activé pour ce compte mail.',
    'mn_edit__mailbox_is_disabled_mail_not_removed' => 'La boîte de messagerie à l\'adresse %1 a été désactivée. Les messages dans la boîte de messagerie n\'ont pas été supprimés mais vous ne pourrez pas les récupérer via le protocole IMAP ou POP3.',
    'mn_list__mail_names_for_domain' => "Comptes mail pour le domaine %1",
    'mn_list__sa_cannot_unable' => "Impossible d'activer le filtre anti-spam.",
    'mn_list__tab_cp_access' => "V",
    'mn_list__tab_title_client' => 'Client',
    'mn_list__tab_title_domain' => 'Domaine',
    'mn_list__tab_title_autoresp' => "A",
    'mn_list__tab_title_box' => "o",
    'mn_list__tab_title_group' => "G",
    'mn_list__tab_title_name' => "Nom",
    'mn_list__tab_title_redirect' => "F",
    'mn_list__tab_title_spamfilter' => "S",
    'mn_list__tab_title_virusfilter' => 'AV',
    'mn_list__tab_title_drweb' => 'AV',
    'mn_list__unable_remove_mns' => "Impossible de supprimer les comptes mail : %1",
    'module_upload__module_was_installed' => 'Ce module est déjà installé. Si vous souhaitez installer une nouvelle version de ce module, veuillez désinstaller le module via Plesk et ensuite essayer de l\'installer.',
    'module_upload__unable_to_install' => 'Impossible d\'installer le fichier du module',
    'module_upload__wrong_package' => 'Le fichier envoyé n\'est pas le pack d\'un module pris en charge.',
    'module_upload__wrong_module' => 'Le fichier envoyé ne contient pas le pack d\'un module.',

    'news_articles_title' => 'Nouveautés de Plesk',
    'notification_text__invalid_subject_length' => "Longueur du sujet de notification incorrecte. Elle doit inclure entre 1 et 255 caractères.",
    'notification_text__invalid_text_length' => "Longueur du texte de notification incorrecte. Elle doit être comprise entre 1 et 65533 caractères.",
    'notification_text__subject' => "Sujet de notification",
    'notification_text__text' => "Texte du message",
    'notification_text__title' => "Éditer le message",
    'notification_text__unable_set_text' => "Impossible de modifier le texte de la notification :",

    'odbc__cant_add_dsn' => "Impossible d'ajouter DSN %1: %2",
    'odbc__cant_connect' => "Impossible de se connecter à la source de données en utilisant cette config. Réponse du serveur : %1",
    'odbc__cant_delete_dsn' => "Impossible de supprimer le DSN %1: %2",
    'odbc__cant_get_drivers_info' => "Impossible d'obtenir les informations sur les pilotes.",
    'odbc__cant_get_drivers' => "Impossible de récupérer la liste des pilotes ODBC: %1",
    'odbc__cant_open_info_file' => "Impossible d'ouvrir le fichier avec les informations de pilotes ODBC.",
    'odbc__cant_parse_string' => "Impossible d'analyser la chaîne de connexion.",
    'odbc__driver_not_set' => "Driver non configuré",
    'odbc__driver_or_name_not_set' => "Driver ou nom de la connexion ODBC non configuré",
    'odbc__dsn_already_exists' => "DSN avec ce nom (%1) existe déjà dans le système",
    'odbc__dsn_not_exists' => "Ce DSN n'existe pas",
    'odbc__enter_dsn_name' => "Entrer le nom de DSN",
    'odbc__invalid_dsn_name' => "Syntaxe du nom de la connexion ODBC (%1) est erronée : veuillez utiliser des caractères alphanumériques uniquement.",
    'odbc__no_such_driver' => "Un driver ODBC portant ce nom (%1) n'est pas pris en charge.",
    'odbc__unknown_driver' => "Nom du pilote inconnu (%1).",
    'odbc_dsn_system' => "système DSN",

    'pb__aliases' => "Alias",
    'pb__anonftp' => "FTP anonyme",
    'pb__autoinstaller_releases' => 'Updater',
    'pb__cert' => "Certificats",
    'pb__cl_pool' => "Adresses IP",
    'pb__cl_pool_ctrl' => "%1",
    'pb__cl_pref' => "Paramètres",
    'pb__cl_rpt' => "Rapport",
    'pb__cl_rpt_list' => "Personnaliser",
    'pb__cl_templates' => "Templates de client",
    'pb__cl_traffic' => "Trafic",
    'pb__cl_traffic_history' => "Historique du trafic",
    'pb__cl_traffic_of' => "Trafic de %1",
    'pb__client' => "%1",
    'pb__clients' => "Clients",
    'pb__comp_info' => "Composants du serveur",
    'pb__common_acl' => 'ACL d\'autorisation de transfert',
    'pb__cp_access' => "Accès",
    'pb__crontab' => "Planificateur",
    'pb__scheduler' => "Planificateur",
    'pb__custom_buttons' => "Boutons personnalisés",
    'pb__databases_db' => 'Bases de données',
    'pb__sqlservers_db' => 'Serveurs SQL', //to check
    'pb__db' => "Bases de données",
    'pb__db_edit' => "%1",
    'pb__db_server_edit' => '%1',
    'pb__db_servers' => 'Serveurs de bases de données',
    'pb__dl_usr_ed' => "Administrateur du domaine",
    'pb__dns' => "DNS",
    'pb__dns_template' => "DNS",
    'pb__dns_t' => "DNS",
    'pb__dom_ctrl' => "%1",
    'pb__dom_lim' => "Limites du domaine",
    'pb__dom_pref' => "Paramètres",
    'pb__dom_sum_report' => "Rapport récapitulatif du domaine",
    'pb__dom_templates' => "Templates de domaine",
    'pb__dom_traffic' => "Trafic de %1",
    'pb__domains' => "Domaines",
    'pb__domain_aliases' => 'Alias de domaines',
    'pb__dumps_list' => "Stockage des fichiers de sauvegarde",
    'pb__forwarding_setup' => "Config. redirection",
    'pb__filemanager' => "Gestionnaire de fichiers",
    'pb__ip_aliasing' => "Adresses IP",
    'pb__ip_clients' => "Suppression d'adresses IP",
    'pb__license_management' => 'Informations sur la licence',
    'pb__locales' => 'Localisation',
    'pb__log_files' => "Fichiers journaux",
    'pb__mail' => 'Boîte mail',
    'pb__mail_name_files' => "Pièces jointes",
    'pb__mail_name_redirects' => "Outils de redirection de mails",
    'pb__mail_name_resp_attach_add' => "Nouv. pièce jointe",
    'pb__mail_name_resp_edit' => "%1",
    'pb__mail_name_responders' => "Réponses automatiques de la messagerie",
    'pb__mail_names' => "Boîte mail",
    'pb__maillists' => "Listes de diffusion",
    'pb__modules' => 'Modules',
    'pb__modules_management' => 'Gérer les Modules',
    'pb__notifications' => "Notifications",
    'pb__odbc' => "ODBC",
    'pb__phosting_setup' => "Config. hébergement physique",
    'pb__prtd_dirs' => "Répertoires protégés",
    'pb__prtdir_edit' => "%1",
    'pb__report_list' => "Personnaliser",
    'pb__server' => "Serveur",
    'pb__sessions' => "Sessions",
    'pb__sapp_pool' => "Pool d'applications Web",
    'pb__siteapp_install' => 'Installation de l\'application Web',
    'pb__site_app_pkgs' => 'Applications Web',
    'pb__site_apps' => "Applications Web",
    'pb__additional_key_info' => 'Propriétés des licences',
    'pb__additional_key_properties' => 'Propriétés des licences',
    'pb__skins' => 'Skins',
    'pb__skin_info' => '%1',
    'pb__spamassassin' => "Filtre anti-spam",
    'pb__statistics' => "Statistiques",
    'pb__subdom_ctrl' => "%1",
    'pb__subdomains' => "Sous-domaines",
    'pb__templates' => "Modèles",
    'pb__virtualdirs' => 'Répertoires virtuels',
    'pb__web_users' => "Utilisateurs Web",
    'pdir__invalid_hst' => "Type d'hébergement incorrect. Doit être physique.",
    'pdir__pd_id_is_undefined' => "L'ID du répertoire protégé n'est pas défini.",
    'pdir__pdir_exist' => "Le répertoire portant ce nom est déjà protégé.",
    'pdir__pdir_not_exist' => "Répertoire protégé n'existe pas.",
    'pdir__pdir_usr_not_exist' => "L'utilisateur du répertoire protégé n'existe pas.",
    'pdir__remove_pdir_usrs' => "Les utilisateurs suivants du répertoire protégé %2 sous le site Web %1 seront supprimés :",
    'pdir__remove_pdir_usrs_on_subdom' => "Les utilisateurs suivants du répertoire protégé %2 sous le sous-domaine %1 seront supprimés :",
    'pdir__select_pdir_usrs_for_remove' => "Sélect. les utilisateurs du répertoire protégé à supprimer.",
    'pdir__select_pdirs_to_remove' => "Sélectionnez les répertoires dont vous voulez supprimer la protection.",
    'pdir__unable_define_pdir_users' => "Impossible de définir les utilisateurs du répertoire protégé.",
    'pdir__unable_define_pdirs_properties' => "Impossible de définir les propriétés des répertoires protégés : %1",
    'pdir__unable_select_dom_param' => "Impossible sélect. paramètres du domaine : %1",
    'pdir_ed__dir_already_protect' => "Ce répertoire est déjà protégé.",
    'pdir_ed__invalid_login' => "Votre nom d'utilisateur indiqué est incorrect.",
    'pdir_ed__login_exists' => "Cet utilisateur existe déjà. Essayez d'indiquer un autre nom d'utilisateur.",
    'pdir_ed__pdir_users' => "Utilisateurs du répertoire protégé",
    'pdir_ed__ssl' => "SSL/TLS",
    'pdir_ed__ssl_or_nonssl_should_be_checked' => "Au moins une case doit être cochée au niveau des cases SSL/TLS et non-SSL/TLS.",
    'pdir_ed__unable_cr_pdir_usr' => "Impossible de créer l'utilisateur de répertoire protégé : %1",
    'pdir_ed__unable_create_pdir' => "Impossible de créer le répertoire protégé : %1",
    'pdir_ed__unable_define_hst_type' => "Impossible de définir le type d'hébergement.",
    'pdir_ed__unable_update_pdir' => "Impossible de sauvegarder les paramètres du répertoire protégé : %1",
    'pdir_ed__wrong_symbol_in_header' => "Veuillez ne pas utiliser le caractère %1 dans le titre du répertoire.",
    'pdir_usr_ed__not_create_pass' => "Ceci ne créera pas de mot de passe pour le nouvel utilisateur du répertoire protégé.\nSans mot de passe, l'utilisateur ne pourra pas se connecter.",
    'pdir_usr_ed__unable_select_pdir_usr' => "Impossible de sélectionner l'utilisateur du répertoire protégé : %1",
    'pdir_usrs_list__unable_define_pdir_usrs' => "Impossible de définir les utilisateurs du répertoire protégé : %1",
    'pdir_usrs_list__unable_remove_pd_usrs' => "Impossible de supprimer les utilisateurs du répertoire protégé : %1",
    'phosting__anonftp_encrypt' => 'Le mot de passe de l\'utilisateur FTP est chiffré. C\'est pourquoi il ne peut pas être utilisé pour protéger le répertoire /plesk-stat/webstat/. Saisissez à nouveau votre mot de passe FTP ou décochez l\'option "accessible via le répertoire protégé par un mot de passe \'/plesk-stat/webstat/\'"',
    'phosting__hosting_and_dns_ip_difference_warning' => "Le nom de domaine %%domain_name%% se résout en l'adresse IP %%dns_ip_address%%. Votre site Web est affecté à l'adresse IP %%hosting_ip_address%%. Si votre site Web ne s'ouvre pas dans un navigateur Web lorsque vous vous y référez par son nom de domaine, allez dans l'écran de gestion DNS (Domaines > Nom de domaine > DNS) et changez les propriétés de l'enregistrement de la ressource A : affectez l'adresse IP %%hosting_ip_address%% au nom du domaine %%domain_name%%.",
    'phosting__ip_change_warning' => "L'adresse IP a changé. Les changements correspondant ont également été faits dans la zone DNS du domaine.",
    'phosting__other_hosting_exists_on_ip' => "Impossible de changer le certificat, car cette adresse IP est utilisée par un ou plusieurs comptes d'hébergement.",
    'phosting__unable_to_change_certificate' => "Impossible d'installer le certificat : %1",
    'phosting__unable_to_change_ip_address' => "Impossible de changer l'adresse  IP : %1",
    'phosting__unable_to_set_cert' => "Impossible de définir le certificat SSL/TLS : %1",
    'phosting__unable_update' => "Impossible de mettre à jour les paramètres d'hébergement : %1",
    'phosting__unable_manage' => "Impossible de gérer l'hébergement : %1",
    'phosting__failed_to_add_logs_fail2ban' => "Impossible de configurer fail2ban pour le suivi des logs du domaine. Les logs seront automatiquement suivi dès le prochain redémarrage du service fail2ban.\n%1",

    'picker_acl_record__tittle' => 'Sélectionnez une entrée ACL',
    'picker_autoresponder__title' => 'Sélectionner une réponse automatique',
    'picker_black_list__domain_name' => 'Sélectionnez un nom de domaine',
    'picker_certificate' => 'Sélectionnez un certificat SSL/TLS.',

    'picker_dns_zone_template__title' => 'Sélectionnez un enregistrement de ressource',
    'picker_domain__title' => 'Sélectionner un site Web',
    'picker_domain_alias__title' => 'Sélectionner un alias de domaine',
    'picker_resource_record__title' => 'Sélectionnez un enregistrement de ressource',
    'picker_disabled_resource_record__title' => 'Sélectionnez un serveur de noms',
    'picker_ip_address__title' => 'Sélectionner une adresse IP',
    'picker_ip_address_clients__title' => 'Sélectionner les clients qui utilisent cette adresse IP',
    'picker_mail_queue' => 'Sélectionner des mails',
    'picker_site_application__title' => 'Sélectionner une application Web',
    'picker_subdomain__title' => 'Sélectionnez un sous-domaine',
    'picker_web_user__title' => 'Sélectionnez un utilisateur Web',
    'picker_custom_button__title' => 'Sélectionnez un bouton personnalisé',
    'picker_license_key__title' => "Sélection de la clé de licence",
    'picker_spamfilter_address__title' => 'Sélectionnez une adresse figurant dans le filtre anti-spam',
    'picker_white_list__networks' => 'Sélection de réseaux',

    'plesk_key__action_logs' => "Journalisation des actions exécutées par les utilisateurs de Plesk",
    'plesk_key__app_vault' => "Référentiel d'applications",
    'plesk_key__backup' => "Fonctions de sauvegarde et restauration",
    'plesk_key__client_templs' => "Gestion des packs de services",
    'plesk_key__clients' => "Comptes utilisateur (clients et revendeurs)",
    'plesk_key__resellers_only' => "Comptes utilisateur (revendeurs)",
    'plesk_key__customers_only' => "Comptes utilisateur (clients)",
    'plesk_key__domains' => "Domaines",
    'plesk_key__domain_aliases' => "Alias de domaines",
    'plesk_key__subdomains_limit' => "Sous-domaines",
    'plesk_key__databases' => "Bases de données",
    'plesk_key__mssql_databases' => "Bases de données MS SQL",
    'plesk_key__manage_dashboard' => 'Personnalisation de la page d\'accueil',
    'plesk_key__drweb' => "Gestion antivirus",
    'plesk_key__event_manager' => "Gestionnaire d'événements",
    'plesk_key__expirations' => "Gestion des dates d'expiration des comptes",
    'plesk_key__group_ops' => "Modification de multiples objets à la fois",
    'plesk_key__expiration' => "Date d'expiration de la clé",
    'plesk_key__edition_name' => "Édition de Plesk",
    'plesk_key__key_number' => "N° de la clé de licence",
    'plesk_key__languages' => "Packs de langues",
    'plesk_key__mailnames' => "Comptes mail",
    'plesk_key__migration_manager' => "Gestionnaire de transfert & de migration",
    'plesk_key__mssql' => "Prise en charge de Microsoft SQL Server",
    'plesk_key__myplesk_func' => "Liens pour acheter des certificats SSL/TLS et des services d'enregistrement de domaine",
    'plesk_key__myplesk_server_id' => "Identifiant du serveur esclave MPC",
    'plesk_key__notifications' => "Gestion des notifications",
    'plesk_key__postgresql' => "Prise en charge du serveur de base de données PostgreSQL",
    'plesk_key__qmail_queue' => 'Gestion de la file d\'attente de mails',
    'plesk_key__remote_db' => 'Hébergement de la base de données à distance',
    'plesk_key__slave_servers' => "Serveurs esclaves",
    'plesk_key__spamassassin' => "Gestion du filtre anti-spam",
    'plesk_key__subdomains' => "Gestion des sous-domaines",
    'plesk_key__sys_access' => "Gestion de l'accès au serveur",
    'plesk_key__traffic_reports' => "Rapports d'utilisation du trafic",
    'plesk_key__tts' => "Help Desk",
    'plesk_key__virtuozzo' => "Valable pour les conteneurs Virtuozzo uniquement",
    'plesk_key__webusers' => "Utilisateurs Web",
    'plesk_key__cpu_cores' => 'Cœurs CPU',
    'plesk_key__ram' => 'Mémoire',
    'plesk_key__license_update_date' => 'Prochaine mise à jour de la licence',
    'plesk_key__autoinstaller_config' => 'Gestion des paramètres de l\'outil de mise à jour',
    'plesk_key__check_wrong' => "La clé de licence n'est pas valide. Pour utiliser Plesk, veuillez obtenir et installer une nouvelle clé de licence valide.",
    'plesk_key__upload_check_wrong' => 'La clé de licence envoyée n\'est pas correcte.',
    'plesk_key__revert_check_wrong' => 'La clé de licence installée précédemment n\'est pas correcte.',
    'plesk_key__viruozzo_only_key' => 'La clé de licence n\'est destinée qu\'à être utilisée avec Plesk dans les conteneurs Virtuozzo.',
    'plesk_key__ip_ranges_exceeded' => 'Vous ne pouvez utiliser cette copie d\'une licence Plesk qu\'avec les adresses IP suivantes : %2. Les adresses IP ci-après ne sont pas couvertes par votre licence : %1.', //%1 not allowed addresses list separated by comma, %2 allowed IP addresses list separated by comma
    'plesk_key__limits_exceeded' => 'Les ressources que vous utilisez actuellement dépassent les limites fixées par votre licence.',
    'plesk_key__wp-toolkit-deluxe' => 'WP Toolkit Deluxe',
    // For the keys below: %1 limit value, %2 used value, %3 delta value
    'plesk_key__limits_exceeded_lim_dom' => 'Le nombre de sites Web hébergés sur le serveur dépasse les limites définies par votre licence. Vous avez %2 sites hébergés ; votre licence permet de n\'héberger que %1 sites.',
    'plesk_key__limits_exceeded_lim_domain_aliases' => 'Le nombre d\'alias de domaines sur le serveur est supérieur au nombre maximum fixé par votre licence. Vous avez %2 alias de domaines ; votre licence n\'en autorise que %1.',
    'plesk_key__limits_exceeded_lim-subdom' => 'Le nombre de sous-domaines sur le serveur est supérieur aux limites définies par votre licence. Vous avez %2 sous-domaine(s). Votre licence autorise seulement %1 sous-domaine(s).',
    'plesk_key__limits_exceeded_lim-db' => 'Le nombre de bases de données sur le serveur est supérieur aux limites définies par votre licence. Vous avez %2 base(s) de données. Votre licence autorise seulement %1 base(s) de données.',
    'plesk_key__limits_exceeded_lim-mssql-db' => 'Le nombre de bases de données MS SQL sur le serveur est supérieur aux limites définies par votre licence. Vous avez %2 base(s) de données. Votre licence autorise seulement %1 base(s) de données.',
    'plesk_key__limits_exceeded_lim_cl' => 'Le nombre de comptes client en service dépasse les limites définies par votre licence. Vous avez %2 comptes client actuellement en service ; votre licence permet de ne servir que %1 comptes client.',
    'plesk_key__limits_exceeded_lim_mn' => 'Le nombre de comptes mail en service dépasse les limites définies par votre licence. Vous avez %2 compte(s) mail actuellement en service ; votre licence permet de ne servir que %1 compte(s) mail.',
    'plesk_key__limits_exceeded_lim_wu' => 'Le nombre de comptes d\'utilisateurs Web que vous gérez dépasse les limites fixées par votre licence. Vous gérez actuellement %2 comptes d\'utilisateurs Web, mais votre licence n\'en autorise que %1.',
    'plesk_key__limits_exceeded_MLS' => 'Le nombre de packs de langues actuellement installés dépasse les limites définies par votre licence. %2 packs de langue sont installés ; votre licence permet de n\'installer que %1 packs de langues.',
    'plesk_key__wrong_version' => 'Vous essayez d\'utiliser une clé de licence créée pour une autre version de Plesk. Contactez les représentants commerciaux de Plesk pour obtenir une clé de licence correcte.',
    'plesk_key__other_product' => 'Vous essayez d\'utiliser la clé de licence créée pour un autre produit. Contactez les représentants commerciaux de Plesk pour obtenir une clé de licence correcte.',
    'plesk_key__invalid_machine_id_trial' => 'Votre licence actuelle n\'est pas valide, car elle est déjà activée sur un autre serveur Plesk. Pour continuer à utiliser Plesk, vous devez installer une nouvelle licence ou réinstaller votre licence actuelle en saisissant son code d\'activation (si vous en avez un).',
    'plesk_key__invalid_machine_id_retail' => 'Votre licence actuelle n\'est plus valide, car elle est déjà activée sur un autre serveur Plesk. La CLUF WebPros (EULA, https://www.plesk.com/legal/) interdit d\'utiliser une licence unique sur deux ou plusieurs serveurs simultanément. Pour continuer à utiliser Plesk, installez une nouvelle licence ou réinstallez votre licence actuelle en saisissant son code d\'activation. Nous vous l\'avons envoyé par e-mail lors de l\'achat de la licence. <br>Vous ne trouvez plus votre code d\'activation ? Vous pouvez le récupérer à l\'aide de Plesk 360. Pour cela, connectez-vous à https://platform360.io/, à l\'aide de l\'adresse e-mail que vous avez utilisée lors de l\'achat de la licence. Cliquez sur l\'onglet "Licences" pour voir le code d\'activation de votre licence. Vous pouvez également contacter le service d\'assistance de Plesk (Licensing and Purchase - Licences et achats) via le formulaire en ligne (https://www.plesk.com/licensing-and-purchase-support/). Pensez à saisir votre numéro de licence dans la section "How can we help you?" (Comment pouvons-nous vous aide ?) du formulaire.',
    'plesk_key__limits_exceeded_error' => 'Impossible d\'installer la clé de licence : les totaux actuellement utilisés de ressources ont dépassé les limites définies dans la clé de licence envoyée.',
    'plesk_key__limits_exceeded_note' => 'les totaux actuellement utilisés de ressources ont dépassé les limites définies dans la clé de licence envoyée.',
    'plesk_key__hardware_limits_exceeded' => 'La configuration matérielle dépasse les limites définies par votre licence Plesk.',
    'plesk_key__hardware_limits_exceeded_lim-ram' => '%1 de mémoire installée sur le serveur. Toutefois, votre licence autorise %2 maximum.',
    'plesk_key__hardware_limits_exceeded_lim-cpu-cores' => '%1 cœurs CPU installés sur le serveur. Toutefois, votre licence autorise %2 maximum.',
    'plesk_key__key_file_invalid' => 'Le fichier de licence envoyé n\'est pas valable ou ne contient pas de licence.',
    'plesk_key__server_request_error' => 'Impossible de mettre à jour la licence. Vérifiez que les connexions au serveur de licences ka.plesk.com sur le port TCP %1 ne sont pas bloquées. <a href="https://support.plesk.com/hc/en-us/articles/12388137260695" target="_blank">Voyez comment procéder </a>.',
    'key__no_key_file_in_zip' => 'Le fichier .zip envoyé ne contient pas de fichier de licence',
    'key__key_upload' => 'Installation de la clé de licence',
    'additional_key__prop_name' => 'Propriété',
    'additional_key__prop_value' => 'Valeur',
    'additional_key__descr_name' => 'Nom de la licence',
    'additional_key__descr_key_number' => 'N° de la clé de licence',
    'additional_key__descr_key_vz' => "Cette clé de licence est destinée uniquement à une utilisation dans les conteneurs Virtuozzo.",
    'additional_key__descr_key_mailboxes' => 'Boîtes mail',
    'additional_key__descr_lim_date' => 'Date d\'expiration',
    'additional_key__descr_license_update_date' => 'Prochaine mise à jour de la licence',
    'additional_key__file_invalid' => 'Le fichier de licence envoyé n\'est pas valable ou ne contient pas de licence.',
    'additional_key__file_incompatible' => 'Le fichier de licence envoyé ne convient pas pour cette application.',
    'additional_key__not_exists' => 'Pas de licence installée.',
    'additional_key_update__result_response' => 'Réponse du serveur de gestion des licences : %1',
    'additional_key_update__result_network' => 'Impossible de se connecter au serveur de gestion des licences. Assurez-vous que votre réseau permet de communiquer avec %1: %2.',
    'additional_key_update__result_lock' => 'Mise à jour de la clé déjà en cours',
    'additional_key_update__result_internal_error' => 'Une erreur est survenue lors de la mise à jour de la clé de licence : %1',

    'proceed_to_cl_pool' => "Procéder à la configuration du pool d'IP du client",
    'proceed_to_hosting_setup' => "Effectuer la config. hébergement",
    'removeCerts__remove_certificates_cp' => "Les certificats suivants seront supprimés :",
    'removeCerts__remove_certificates_domain' => "Les certificats suivants appartenant à %1 seront supprimés :",
    'removeClientsIP_remove_clients_ip' => "Cette adresse IP sera supprimée des pools des clients suivants :",
    'removeMailAliases__remove_mail_aliases' => "Les alias de messagerie suivants pour le compte mail %1 seront supprimés :",
    'removeMailNames__remove_mailnames' => "Les comptes mail et les alias suivants seront supprimés du domaine : %1",
    'removeMailNames__remove_mailnames_of_cl' => "Les comptes mail suivants et les alias seront supprimés du domaine %2 possédé par le client %1 :",
    'removeMailNames__these_mailnames_will_not_delete' => "Ces comptes mail ne seront pas supprimés.",
    'removeFtpSessions__remove_title' => "Les sessions FTP suivantes seront arrêtées :",
    'removeTemplates__remove_templates' => "Les templates suivants seront supprimés :",
    'resp_edit__always_respond' => "toujours répondre",
    'resp_edit__reply_subject' => "Objet du mail de réponse",
    'resp_edit__answer_subject' => "Répondre avec ce sujet",
    'resp_edit__answer_txt' => "Répondre avec ce texte",
    'resp_edit__attach' => "Joindre les fichiers",
    'resp_edit__default_subject' => "Re: %1",
    'resp_edit__for' => "pour",
    'resp_edit__frw_rqst_email' => "Si un répondeur automatique est activé, transférer le message d'origine à l'adresse mail indiquée",
    'resp_edit__fwd_email_invalid' => "L'adresse mail de destination est incorrecte.",
    'resp_edit__in_body' => "quand les mots indiqués se trouvent dans le corps du message",
    'resp_edit__in_subject' => "quand les mots indiqués se trouvent dans l'objet du message",
    'resp_edit__invalid_resp_freq' => "La périodicité de réponse n'est pas valable.",
    'resp_edit__invalid_rqst_txt' => "Texte de requête non valable.",
    'resp_edit__invalid_store_lim_num' => "Valeur de la limite incorrecte.",
    'resp_edit__limits_title' => "Limites",
    'resp_edit__maximum_allowed_resp_freq_reached' => "Nbre maxi de réponses par jour dépasse le nombre fixé. Autorisé : %1, demandé : %2",
    'resp_edit__no_files_sel' => "Pas de fichiers sélectionnés.",
    'resp_edit__no_txt_supplied' => "Aucun texte fourni.",
    'resp_edit__reply_title' => "Répondre",
    'resp_edit__reply_to_address' => "Renvoyer à",
    'resp_edit__reply_to_invalid' => "Adresse de retour incorrecte.",
    'resp_edit__reply_uniq_email' => "Ne pas répondre à une adresse mail unique plus de",
    'resp_edit__conditions_title' => "Conditions",
    'resp_edit__request_title' => "Demander",
    'resp_edit__resp' => "Réponse automatique",
    'resp_edit__resp_name' => "Nom de la réponse automatique",
    'resp_edit__resp_not_exist' => "La réponse automatique n'existe pas.",
    'resp_edit__resp_status' => "Statut de la réponse automatique",
    'resp_edit__rqst_txt' => 'Précisez la condition pour cette réponse automatique',
    'resp_edit__select_files_on_server_for_attach' => "Sélect. les fichiers à joindre",
    'resp_edit__store_up_to' => "Stocker jusqu'à",
    'resp_edit__subj_line_invalid' => "La ligne objet est incorrecte.",
    'resp_edit__text_too_big' => "Le texte du message de réponse est trop long.",
    'resp_edit__times_in_a_day' => "fois par jour.",
    'resp_edit__unable_define_resp_cond' => "Impossible de définir la condition de la réponse automatique : %1",
    'resp_edit__unable_define_resp_status' => "Impossible de définir le statut de la réponse automatique : %1",
    'resp_edit__unable_turn_on_resp' => "Impossible d'activer la réponse automatique : %1",
    'resp_edit__uniq_email' => "adresses mail uniques",
    'resp_edit__content_type' => 'Format d\'envoi de mail',
    'resp_edit__content_type_text' => 'Texte brut',
    'resp_edit__content_type_html' => 'HTML',
    'resp_edit__charset' => 'Codage',
    'restart__dns' => 'Serveur DNS (%1)',
    'restart__drweb' => 'Plesk Premium Antivirus',
    'restart__mail' => "Serveur IMAP/POP3 (%1)",
    'restart__mssql' => "Serveur Microsoft SQL",
    'restart__mysql' => "Serveur MariaDB/MySQL",
    'restart__postgresql' => "PostgreSQL",
    'restart__psa' => "Services",
    'restart__smtp' => "Serveur SMTP (%1)",
    'restart__spamd' => "Filtre anti-spam",
    'restart__spamassassin' => "SpamAssassin",
    'restart__stunnel' => "Stunnel",
    'restart__web' => "Serveur WEB (%1)",
    'restart__ftp' => "Serveur FTP (%1)",
    'restart__service_start' => 'Veuillez attendre quelques instants que le service démarre.',
    'restart__service_stop' => 'Veuillez attendre quelques instants que le service s\'arrête.',
    'restart__service_restart' => 'Veuillez attendre quelques instants que le service redémarre.',
    'rm_domains__some_domains_are_not_exist' => "Certains des domaines indiqués n'existent pas. Il est possible qu'ils aient été supprimés par un autre utilisateur.",
    'rpt_cl_dom_data_bases' => "BDMySQL",
    'rpt_cl_dom_mssql_data_bases' => "DBMSSQL",
    'rpt_cl_dom_mail_groups' => "GrpMess",
    'rpt_cl_dom_mail_lists' => "ListDiff",
    'rpt_cl_dom_mail_resps' => "RépAuto",
    'rpt_cl_dom_mail_antispam' => "Anti-spam",
    'rpt_cl_dom_mail_antivirus' => "Antivirus",
    'rpt_cl_dom_postboxes' => "BLettr",
    'rpt_cl_dom_redirects' => "Outils de redirection",
    'rpt_cl_dom_subdomains' => "Sousdom",
    'rpt_cl_dom_domain_aliases' => "AliasDom",
    'rpt_cl_dom_web_users' => "UtilW",
    'rpt_cl_report_for_admin__' => "Rapport pour l'administrateur %1",
    'rpt_cl_report_for_reseller__' => "Rapport pour le revendeur %1",
    'rpt_cl_report_for_cl__' => "Rapport sur le client %1",
    'rpt_cl_section_domains' => "Domaines",
    'rpt_cl_section_full_domains' => "Domaines",
    'rpt_cl_section_general' => "Général",
    'rpt_create' => "Créer rapport",
    'rpt_empty' => "Le rapport doit contenir au moins une section",
    'rpt_dom_report_for_dom__' => "Rapport sur le domaine pour %1",
    'rpt_dom_section_databases' => "Bases de données",
    'rpt_dom_section_full_databases' => "Bases de données",
    'rpt_dom_section_full_maillists' => "Listes de diffusion",
    'rpt_dom_section_full_mailnames' => "Comptes mail",
    'rpt_dom_section_full_webusers' => "Utilisateurs Web",
    'rpt_dom_section_full_siteapps' => 'Applications Web',
    'rpt_dom_section_full_aspnetapps' => 'Applications Web ASP.NET',
    'rpt_dom_section_general' => "Général",
    'rpt_dom_section_hosting' => "Hébergement",
    'rpt_dom_section_maillists' => "Listes de diffusion",
    'rpt_dom_section_mailnames' => "Comptes mail",
    'rpt_dom_section_siteapps' => 'Applications Web',
    'rpt_dom_section_aspnetapps' => 'Applications Web ASP.NET',
    'rpt_dom_section_webusers' => "Utilisateurs Web",
    'rpt_dom_title_wa_status' => "S",
    'rpt_edit__' => "Éditer rapport %1",
    'rpt_enter_email_address' => "Tapez l'adresse mail à laquelle le rapport sera envoyé.",
    'rpt_list' => "Styles de rapports personnalisés",
    'rpt_section_full' => "Complète",
    'rpt_section_none' => "Aucun",
    'rpt_section_summary' => "Récapitulatif",
    'rpt_default_full' => 'Rapport complet',
    'rpt_default_summary' => 'Rapport récapitulatif',

    // end of kooper part

    // pit part

    'rpt_send_report_by_email_error__' => "Erreur lors de l'envoi du rapport : %1",
    'rpt_send_report_by_email_ok__' => "Le rapport a été envoyé à %1",
    'sa_action' => "Action",
    'sa_action_del' => "Supprimer",
    'sa_action_desc' => "Que faire avec le spam",
    'sa_action_save' => "Marquer comme spam et stocker dans la boîtes aux lettres",
    'sa_admin_blacklist' => "Liste noire de l'administrateur",
    'sa_admin_whitelist' => "Liste blanche de l'administrateur",
    'sa_db_del_confirm' => "Voulez-vous vraiment nettoyer la base de données du filtre anti-spam ?",
    'sa_eml_in_ignorelist' => "Le mail est dans la liste à ignorer",
    'sa_empty_email' => "Impossible d'ajouter un modèle de mail vide.",
    'sa_exists_email' => "Ce type de modèle de mail existe déjà.",
    'sa_disabled__mailname_not_filtering' => "Les paramètres actuels du serveur ne permettent pas d'utiliser le filtrage de la messagerie pour ce compte mail",
    'sa_disabled__filtering_is_disabled' => 'L\'administrateur du serveur a désactivé le filtre anti-spam.',
    'sa_disabled__hasnt_mailbox' => "Impossible de mettre en service le filtrage anti-spam s'il n'y a pas de boîte mail",
    'sa_enable_filter' => "Activer le filtre anti-spam",
    'sa_forget' => "Ne pas tenir compte",
    'sa_from' => "Du",
    'sa_ham' => "ham",
    'sa_pattern_is_invalid' => "Le modèle est incorrect.",
    'sa_spam' => "spam",
    'sa_trainer__page_title' => 'Apprentissage du filtre anti-spam',
    'sa_trainer__tools_legend' => 'Outils',
    'sa_trainer__info_legend' => 'Infos',
    'sa_trainer__messages_list_legend' => 'Messages dans votre boîte mail',
    'sa_trainer__c' => 'T',
    'sa_trainer__l' => 'V',
    'sa_trainer__subject' => 'Sujet',
    'sa_trainer__from' => 'Du',
    'sa_trainer__date' => 'Date',
    'sa_trainer__info_text' => 'Apprentissage de messages : %1 comme spam, %2 comme n\'étant pas des spam, %3 total.',
    'sa_trainer__messages' => 'message(s)',
    'sa_trainer__select__all' => 'Tout',
    'sa_trainer__select__spam_only' => 'Spam',
    'sa_trainer__select__ham_only' => 'Pas un spam',
    'sa_trainer__select__unknown_only' => 'Inconnu',
    'sa_trainer__cannot_remove_messages' => 'Impossible de supprimer les messages sélectionnés de la boîte mail.',
    'sa_trainer__remove_messages_confirm' => 'Voulez-vous vraiment supprimer les messages sélectionnés de la boîte mail ?',
    'sa_subj' => "Sujet",
    'sa_training' => "Apprentissage du filtre anti-spam",
    'sa_training_legend' => "Apprentissage du filtre Bayesien",
    'sa_use_srv_settings' => "Utiliser les paramètres valables pour l'ensemble du serveur",
    'sa_user_blacklist' => "Liste noire de l'utilisateur",
    'sa_user_whitelist' => "Liste blanche de l'utilisateur",
    'sa_usr_disabled_by_srv' => "Les paramètres individuels du filtre anti-spam ne sont pas autorisés par l'administrateur du serveur.",
    'sa_usr_no_postbox' => "Impossible d'activer le filtrage anti-spam car la boîte aux lettres est désactivée pour ce compte de messagerie.",
    'sa_filters' => 'Filtres anti-spam',
    'spamfilter__tools_legend' => 'Outils',
    'spamfilter__prefs_legend' => 'Paramètres',
    'spamfilter__max_children' => 'Nombre maximal de processus anti-spam à exécuter',
    'spamfilter__rewrite_header_subject_hint' => 'Laissez ce champ vide si vous ne voulez pas ajouter de texte. Tapez _SCORE_ si vous voulez inclure le score dans l\'objet du message.',
    'spamfilter__reject_spam' => 'Supprimer le spam à son arrivée dans la boîte mail',
    'spamfilter__enabled' => 'Activé',
    'spamfilter_addresses_list__items' => 'adresse(s)',
    'spamfilter_addresses__remove_title' => 'Les adresses suivantes seront supprimées de la liste :',
    'spamfilter_addresses__empty_selection' => 'Aucune adresse sélectionnée.',
    'server__admin_info' => "Profil de l'administrateur",
    'server__ctrl_panel' => "Plesk",
    'server__enter_bug_essence_below' => "Saisissez la description du bug ci-dessous",
    'server__power_management' => "Gestion de la puissance",
    'server__services' => "Services",
    'server__system' => "Système",
    'server__title' => "Administration du serveur",
    'server_preferences__admin_skin' => "Skin de l'interface de l'administrateur",
    'server_preferences__default_language' => "Langue par défaut",
    'server_preferences__default_skin' => "Skin par Défaut",
    'server_preferences__restart_apache_interval' => "Intervalle de redémarrage d'Apache",
    'server_preferences__system' => 'Paramètres du système',
    'mail__tabs_preferences' => "Paramètres",
    'mail__tabs_white_list' => "Liste blanche",
    'mail__tabs_smarthost' => "Hôte intelligent",
    'server_preferences__use_vocabulary' => "Vérifier les mots de passe pour les boîtes aux lettres dans le dictionnaire",
    'sessions__agreement' => "Oui, je veux terminer cette session.",
    'sessions__select_sessions_for_remove' => "Sélect. les sessions à terminer.",
    'sessions__tabs_cp_sessions' => 'Sessions de Plesk',
    'sessions__tabs_ftp_sessions' => 'Sessions FTP',
    'sessions__ftp_sessions_login' => 'Nom d\'utilisateur du compte FTP',
    'sessions__ftp_sessions_domain' => 'Nom de domaine',
    'sessions__ftp_sessions_path' => 'Emplacement actuel',
    'sessions__ftp_sessions_file' => 'Nom du fichier',
    'sessions__ftp_sessions_action' => 'Statut',
    'sessions__ftp_sessions_speed' => 'Vitesse, Ko/s',
    'sessions__ftp_sessions_comp' => 'Progression, %',

    'site_apps__access_level' => 'Niveau d\'accès',
    'site_apps__access_level_commercial' => 'Payant',
    'site_apps__access_level_free' => 'Gratuit',
    'site_apps__action_installer' => "Installation de l'application Web",
    'site_apps__action_reconfigure' => "Reconfiguration de l'application Web",
    'site_apps__custom_button_level' => 'Voulez-vous créer un bouton personnalisé pour accéder à cette application ?',
    'site_apps__custom_button_level_false_domain_user_only' => 'Non',
    'site_apps__custom_button_level_domain_user_only' => 'Oui',
    'site_apps__custom_button_level_false' => 'Non',
    'site_apps__custom_button_level_domain' => 'Oui et rendez-le disponible pour le domaine actuel uniquement',
    'site_apps__custom_button_level_client' => 'Oui et rendez-le disponible pour tous les domaines du client.',
    'site_apps__custom_button_level_admin' => 'Oui et rendez-le disponible pour tous les domaines',
    'site_apps__description' => "Description",
    'site_apps__dir_used_by_sapp__' => "Le répertoire \"%1\" est utilisé par une autre application Web.",
    'site_apps__dir_used_by_unknown__' => "Le répertoire \"%1\" existe déjà. Ses contenus seront réécrits si vous continuez.",
    'site_apps__dir_invalid_name__' => "Le nom du répertoire %1 est incorrect.",
    'site_apps__file_name' => 'Nom du fichier de l\'application Web',
    'site_apps__invalid_install_prefix' => "Préfixe d'installation non valable",
    'site_apps__invalid_package' => "L'application Web n'est pas valable",
    'site_apps__key_status' => 'Licensing',
    'site_apps__key_status_free' => 'Distribué gratuitement. Pas de licence nécessaire',
    'site_apps__key_status_ok' => 'La licence nécessaire est installée',
    'site_apps__key_status_problem' => 'La licence nécessaire n\'est pas installée',
    'site_apps__name' => "Nom",
    'site_apps__no_domains' => 'L\'application Web ne peut pas être installée. Une autre application Web est déjà installée dans le répertoire root de ce domaine. Considérez la création d\'un sous-domaine pour l\'application Web.',
    'site_apps__package_info_' => "Informations sur l'application Web",
    'site_apps__package_integrated' => "application intégrée, impossible de la supprimer",
    'site_apps__pool_select_packages_to_add' => 'Sélectionner les applications Web à ajouter au pool',
    'site_apps__release' => "Sortie",
    'site_apps__resource_used_by_sapp' => "La ressource est utilisée par l'application Web installée",
    'site_apps__root_used_by_sapp' => "Cette ressource est utilisée par une application Web installée",
    'site_apps__these_domains_will_not_delete' => 'Ces (sous-)domaines ne seront pas supprimés',
    'site_apps__upload_site_app_pkg_title' => 'Envoyer une nouvelle application Web',
    'site_apps__version' => "Version",
    'site_apps__access_to' => "Accès à %1",
    'site_builder_requires' => '%1 - %3',
    'skeleton__archiver_not_installed' => "Impossible de dézipper le pack de l'archive. Archiver n'est peut-être pas installé sur le serveur. Contactez l'administrateur {$PROD_NAME} pour installer le logiciel Archiver.",
    'skeleton__archive_corrupted' => "La vérification d'archive a déterminé que l'archive est corrompue ou que ce type d'archive n'est pas pris en charge.",
    'skeleton__archive_too_large' => "Le contrôle des archives a révélé que le fichier archive est trop grand.",
    'skeleton__not_supported_archive_type' => "Ce type d'archive (fichier %1) n'est pas pris en charge.",
    'skin_download__title' => 'Télécharger le Skin',
    'skin_download_now__title' => 'Téléchargement du Skin en cours',
    'skin_download_now__text' => 'Le pack de thèmes est en cours de création.<br>Cette procédure risque de prendre quelques minutes.<br> Une fois que la boîte de dialogue apparaît, vous pouvez continuer à utiliser Plesk.',
    'skin_file__help_for_using_types' => "Veuillez utiliser les archives du skin dans l'un des formats suivants :",
    'skin_info__title' => 'Propriétés du Skin',
    'skin_mng_err__rpm_not_skin' => 'Ce RPM n\'est pas un pack de thèmes de Plesk',
    'skin_mng_err__psa_install_noreloc' => 'Échec lors de l\'installation du skin basé sur le pack rpm dans l\'emplacement spécifié.',
    'skin_mng_err__already_exists' => 'Le répertoire d\'installation du skin existe déjà, et un pack de skins est déployé.',
    'skin_mng_err__rpm_upgrade_nonrpm' => 'Le fichier envoyé n\'est pas un pack de skins RPM valable.',
    'skin_mng_err__rpm_upgrade_noskin' => 'Le fichier envoyé n\'est pas un pack de skins valable.',
    'skin_mng_err__rpm_upgrade_base' => "Le fichier envoyé {$PROD_NAME} n'est pas un pack de skins valable.",
    'skin_mng_err__rpm_upgrade_other' => 'Impossible d\'installer le skin : format incorrect.',
    'skin_mng_err__no_a_skin' => "Le fichier envoyé {$PROD_NAME} n'est pas un pack de skins valable.",
    'skin_upload__title' => 'Envoyer un nouveau Skin',
    'skin_upload__already_exists' => "Le skin '%1' existe déjà.",
    'skin_upload__unable_to_apply' => "Le fichier envoyé ne contient pas de thèmes de Plesk ou le format de l'archive n'est pas pris en charge.",
    'skin_upload__unable_to_rename__' => "Impossible de renommer le skin %2 en %1 : %3.",
    'skin_upload__file_name' => 'Chemin d\'accès du fichier du pack de skins',
    'skins_list__title' => 'Référentiel des Skins',
    'skins_remove__title' => 'Suppression du Skin',
    'skins_remove__select_skins_for_remove' => 'Sélectionner les skins à supprimer',

    'spf__unable_update' => 'Impossible de mettre les paramètres SPF à jour',
    'statistics__active_domains' => "Domaines actifs",
    'statistics__clients' => "Clients",
    'statistics__subdomains' => "Sous-domaines",
    'statistics__cpu' => "CPU",
    'statistics__databases' => "Bases de données",
    'statistics__db_users' => "Utilisateurs de BD",
    'statistics__dirs' => "Répertoires protégés",
    'statistics__dom_active' => "Actif",
    'statistics__dom_passive' => "Passif",
    'statistics__dom_problem' => "Problème",
    'statistics__domains' => "Domaines",
    'statistics__domains_with_host' => "Domaines avec hébergement",
    'statistics__doms' => "Domaines",
    'statistics__filesystem' => "Système de fichier",
    'statistics__general' => "Général",
    'statistics__hdd_available' => "Disponible",
    'statistics__hdd_capacity' => "Capacité",
    'statistics__hdd_total' => "Volume total",
    'statistics__hdd_usage' => "Utilisation du disque dur",
    'statistics__hdd_used' => "Utilisé",
    'statistics__ip' => "Adresse IP",
    'statistics__key_number' => "N° de la clé de licence",
    'statistics__l1' => "Dernière minute",
    'statistics__l15' => "15 dernières minutes",
    'statistics__l5' => "5 dernières minutes",
    'statistics__la' => "Utilisation du CPU",
    'statistics__mail_autoresponders' => "Réponses automatiques",
    'statistics__mail_boxes' => "Boîtes mail",
    'statistics__mail_groups' => "Groupes de messagerie",
    'statistics__mail_lists' => "Listes de diffusion",
    'statistics__mail_redirects' => "Outils de redirection de mails",
    'statistics__mem' => "Utilisation mémoire",
    'statistics__mem_usage' => "Utilisation",
    'statistics__memory_available' => "Disponible",
    'statistics__memory_buffer' => "Buffer",
    'statistics__memory_cached' => "En cache",
    'statistics__memory_free' => "Libre",
    'statistics__memory_shared' => "Partagé(s)",
    'statistics__memory_total' => "Volume total",
    'statistics__memory_used' => "Utilisé",
    'statistics__os' => "OS",
    'statistics__problem_clients' => "Clients problématiques",
    'statistics__problem_domains' => "Domaines problèmes",
    'statistics__swap' => "Utilisation du fichier d'échange",
    'statistics__swap_free' => "Libre",
    'statistics__swap_total' => "Volume total",
    'statistics__swap_usage' => "Utilisation",
    'statistics__swap_used' => "Utilisé",
    'statistics__system_stat' => "Infos sur le serveur",
    'statistics__unable_define_active_doms' => "Impossible de déterminer le nbre de domaines actifs : %1",
    'statistics__unable_define_inactive_doms' => "Impossible de déterminer le nbre de domaines inactifs : %1",
    'statistics__failed_define_swap_usage' => 'Échec de la définition de l\'utilisation Swap',
    'statistics__failed_define_load_averages' => 'Échec de la définition des charges moyennes',
    'statistics__up_time' => "Durée de fonctionnement du système :",
    'statistics__ver' => "Version",
    'statistics__web_users' => "Utilisateurs Web",
    'statistics__mem_win' => "Utilisation de la mémoire physique",
    'statistics__memory_total_win' => "Volume total",
    'statistics__memory_used_win' => "Utilisé",
    'statistics__memory_free_win' => "Disponible",
    'statistics__swap_win' => "Utilisation de la mémoire virtuelle",
    'statistics__swap_total_win' => "Volume total",
    'statistics__swap_used_win' => "Utilisé",
    'statistics__swap_free_win' => "Disponible",
    'status__domain_has_reasons_to_be_off' => "Le domaine est toujours suspendu pour la raison suivante : %1",
    'subdomain__create__' => "Créer un sous-domaine sur le domaine %1",
    'subdomain__edit__' => "Gérer le sous-domaine %1",
    'subdomain__invalid_name' => "Nom de sous-domaine incorrect : utilisez uniquement des caractères alphanumériques et des tirets.",
    'subdomain__incorrect_name' => "Nom de sous-domaine incorrect.",
    'subdomains__maillists_enabled_in_domain' => "Listes de noms de sous-domaines incorrectes.%1 : ce nom de domaine est déjà utilisé par des listes de diffusion sous le domaine %1",
    'subdomains__dalias_exists' => 'Un alias de domaine portant un tel nom existe déjà.',
    'subdomains__name_exists' => "Un sous-domaine portant un tel nom existe déjà.",
    'subdomains__regular_domain_exists' => "Un domaine portant un tel nom existe déjà.",
    'subdomains__domain_alias_exists' => 'Un alias de domaine portant un tel nom existe déjà.',
    'subdomains__remove_subdomains_on_domain' => "Les sous-domaines du domaine %1 seront supprimés :",
    'subdomains__select_subdomains_for_remove' => "Sélect. les sous-domaines à supprimer.",
    'subdomains__webmail_enabled_in_domain' => "Nom de sous-domaine webmail.%1 incorrect : ce nom de domaine est utilisé pour accéder à la messagerie Web sous le domaine %1.",
    'subdomains__dns_record_already_exists' => 'Impossible de créer le sous-domaine %1 car un enregistrement DNS vers l\'hôte %1 existe déjà.',
    'subdomains__www_prefix_in_domain' => "Nom de sous-domaine www.%1 incorrect : le domaine %1 a déjà le préfixe WWW.",
    'subdomains__user_type_quota_exceeds' => 'Impossible de modifier le compte de l\'utilisateur, car son espace disque dépasserait alors le volume alloué.',
    'subdomains__creation_in_dns_slave' => "Le serveur de noms de Plesk sert de serveur de noms secondaire pour ce domaine. Pour que la résolution de votre sous-domaine se fasse correctement, assurez-vous que le fichier de zone du serveur principal contient bien l'enregistrement %1.",
    'sys_user__attributes_not_changed' => "\nLes attributs suivants de l'utilisateur système n'ont pas été modifiés : %1",
    'sys_user__no_access_without_password' => "Vous n'avez pas défini de mot de passe. L'utilisateur système sera créé, mais ne pourra pas se connecter au système, tant qu'il n'aura pas de mot de passe. Voulez-vous continuer?",
    'sys_user__no_hard_quota' => "non pris en charge",
    'sysuser__zero_quota_is_unlimited' => "0 pour illimité",
    'template__num_excl_ips' => "Attribuer des adresses IP dédiées au client",
    'template__sel_sh_ips' => "Adresses IP partagées sélectionnées",
    'template__av_sh_ips' => "Adresses IP partagées disponibles",
    'template__up_to_excl_ip' => "Jusqu'à %1 adresses IP",
    'templates__all_clients' => "tous les clients",
    'templates__cl_domain_templates' => "Templates pour %1",
    'templates__cl_templates' => "Templates de client",
    'time__invalid_ip' => "Adresse IP ou nom de domaine incorrect(e).",
    '__please_select_country' => 'Veuillez sélectionner votre pays',
    'time__unable_set_time' => "Impossible de définir l'heure du système : %1",
    'time__sinchronization_setup_error' => 'Impossible de définir les paramètres de synchronisation date/heure : timemng failed : %1',
    'time__sinchronization_disable_error' => 'Impossible de désactiver les paramètres de synchronisation date/heure : timemng failed : %1',
    'tmpl__create' => "Créer un template",
    'tmpl__edit__' => 'Template %1',
    'tmpl__logrotation_warn' => "La rotation des journaux sur le domaine créé avec ce template ne sera exécutée qu'en cas de création postérieure d'un compte d'hébergement physique.",
    'tmpl__name' => "Nom du template",
    'tmpl__dom_exist' => "Un template de domaine portant un tel nom existe déjà dans le pool de templates du client ou de l'administrateur.",
    'tmpl__name_invalid' => "Le nom du template est vide ou incorrect.",
    'tmpl__use_next_ip_addr' => "La prochaine adresse IP libre sera utilisée",
    'tmpl_name_already_exists' => "Il y a déjà un template du nom de '%1'.",
    'traffic__no_periods_found' => "Impossible d'afficher les statistiques du trafic et du Web. Cette fonction sera disponible uniquement après le prochain calcul des statistiques.",

    'vh_based__no_free_ip_for_vh' => "Il n'y a pas d'adresse IP libre pour un hébergement virtuel sur IP fixe. Veuillez ajouter une adresse IP.",

    'wu__at_domains_text' => "Autoriser le format d'accès webuser@%1",
    'wu__unable_create' => "Impossible de créer l'utilisateur web : %1",
    'wu_edit__disk_quota' => "Quota de disque",
    'wu_edit__invalid_pass' => "Mot de passe incorrect.",
    'wu_edit__invalid_quota' => "Le quota d'espace disque indiqué est incorrect. Veuillez entrer un entier positif.",
    'wu_edit__invalid_quota_value' => "Le quota dur de disque indiqué est inférieur à la consommation actuelle (%1Mo). Certaines fonctionnalités pourraient devenir inaccessibles. Voulez-vous continuer ?",
    'wu_edit__not_create_pass' => "Cette action ne créera pas de mot de passe pour le nouvel utilisateur Web.\nSans mot de passe, l'utilisateur ne pourra pas se connecter.",
    'wu_edit__unable_update' => "Impossible de mettre à jour les propriétés de l'utilisateur web : %1",

    'dns__tabs_general' => 'Paramètres de la zone',
    'dns__tabs_zone_settings' => 'Enregistrements SOA',
    'soa__seconds' => 'secondes',
    'soa__minutes' => 'minutes',
    'soa__hours' => 'heures',
    'soa__days' => 'jours',

    'DomainSubdirectory' => 'Sous-répertoire de destination',

    'filemanager__select_codepage' => 'Sélectionnez la page de code :',

    'bt_server_app_add' => 'Ajouter une application de serveur',
    'packages_list' => 'Applications pour serveur',

    'bt_packages_management' => 'Gestion des Packs',
    'pb__packages_management' => 'Gestion d\'application',
    'bt_package_new' => 'Ajouter une application',
    '__packages' => 'Applications pour serveur',

    'dom_ctrl__mysql_dbase_space' => 'Quota total de bases de données MariaDB/MySQL',
    'dom_ctrl__mssql_dbase_space' => 'Quota total de bases de données MS SQL',

    'dns_add__enter_ixfr_path' => 'Entrer le chemin IXFR',

    'cmd_dns__txt_dns_record_already_exist' => 'Un tel enregistrement SPF TXT existe déjà. Il ne peut y avoir qu\'un seul enregistrement SPF. Pour ajouter un enregistrement, supprimez d\'abord l\'enregistrement existant.',

    'component_name__network' => 'Mise en réseau',
    'component_name__sitebuilder' => 'Presence Builder',

    'bt_skin_set' => 'Appliquer le skin',
    'bt_set_skin' => 'Appliquer le skin',
    'firewall__rule_already_exists' => 'Une règle portant le nom "%1" existe déjà',
    'firewall__rule_readonly' => 'La règle "%1" est en lecture seule',
    'pb__firewall' => 'Pare-feu',

    '__webstat_smarterstats' => 'SmarterStats',

    'mn_list__tab_title_antivirus' => 'AV',

    'bt_antivirus' => 'Antivirus',
    'antivirus__antivirus' => 'Protection antivirus',
    'antivirus__antivirus_direction_off' => 'Désactivé',
    'antivirus__antivirus_direction_any' => 'Mail entrant et sortant',
    'antivirus__antivirus_direction_from' => 'Uniquement les mails sortants',
    'antivirus__antivirus_direction_to' => 'Mail entrant uniquement',
    'antivirus__unable_to_update_settings' => 'Impossible de changer les paramètres de l\'antivirus : %1.',




    '__normal' => 'Normal(e)',
    '__low' => 'Bas',
    '__high' => 'Haut',

    'mail__antivirus' => "Antivirus interne du serveur de mails",
    'mail__use_internal_antivirus' => 'Utiliser l\'antivirus interne',

    'sa__tabs_blacklist' => 'Liste noire',

    '__mysql_databases' => 'Bases de données MariaDB/MySQL',

    'cl_perm__mysql_dbase_space' => 'Quota total de bases de données MariaDB/MySQL',
    'cl_perm__mssql_dbase_space' => 'Quota total de bases de données MS SQL',
    'cl_perm__max_mssql_db' => 'Nombre maximum de bases de données Microsoft SQL Server',
    'cl_perm__total_mboxes_quota' => 'Quota total de boîtes mail',

    'i_i_cl_on' => 'Le compte client est actif.',
    'i_i_cl_off_by_admin' => 'Le compte client est suspendu par l\'administrateur.',

    'sa_exists_tn' => 'Le réseau est déjà dans la liste.',

    'defaultcomponents__not_activated' => 'pas activé',

    'bt_traffic_at_domains' => 'Trafic',

    '__awstats_perl_warning' => 'Si Perl n\'est pas installé, AWStats ne permettra pas aux utilisateurs de voir les statistiques des années précédentes.',

    'class_client__mysql_dbase_space' => 'La valeur est supérieure à la limite du client.',
    'class_client__mssql_dbase_space' => 'La valeur est supérieure à la limite du client.',
    'class_client__max_mssql_db' => 'La valeur est supérieure à la limite du client.',

    'dns__remove_transfer_restrictions_list_items' => 'Les réseaux suivants seront supprimés de la liste des contrôles d\'accès :',

    'bt_up' => "Monter",
    'bt_down' => "Descendre",

    'bt_install_selected' => 'Installer les clés de licence sélectionnées', // SELECTED


    'dom_pref__the_domain_resolves_to_another_ip_address' => 'Le domaine résout sur une autre adresse IP : (%1). Veuillez corriger les paramètres DNS.',

    'mn_edit__mailbox_enable_if_mailgroup_enabled' => 'Le serveur de messagerie que vous utilisez actuellement ne prend pas en charge la gestion simultanée de boîtes aux lettres et de groupes de messagerie. Cliquez sur OK pour activer les boîtes aux lettres et désactiver les groupes de messagerie. Cliquez sur Annuler pour laisser la configuration telle quelle.',

    'mn_edit__mailgroup_enable_if_mailbox_enabled' => 'Le serveur de messagerie que vous utilisez actuellement ne prend pas en charge la gestion simultanée de boîtes aux lettres et de groupes de messagerie. Cliquez sur OK pour activer les groupes de messagerie et désactiver les boîtes aux lettres. Cliquez sur Annuler pour laisser la configuration telle quelle.',

    'mysql_dbase_space_limit' => 'Limite de l\'espace disque pour la base de données MariaDB/MySQL',
    'mysql_dbase_usage' => 'Espace disque utilisé par la base de données MariaDB/MySQL',
    'mssql_dbase_space_limit' => 'Limite de l\'espace disque de la base de données du serveur Microsoft SQL',
    'mssql_dbase_usage' => 'Espace disque utilisé par la base de données du serveur Microsoft SQL',

    '__statistics' => "Statistiques", //indirect

    'dns__soa_minimum_value_is_big' => 'Si vous fixez une valeur minimum du TTL de plus de 3 heures, certains administrateurs de domaine pourraient ne plus pouvoir accéder vos domaines. Nous vous recommandons de ne prendre cette valeur que si votre registrar insiste.',

    'virusfilter__interface_not_available' => 'Aucun filtre antivirus n\'est disponible.',
    'virusfilter__none_virus_filter' => 'Aucun',
    'virusfilter__mailname_status_text' => 'Antivirus (%1)',
    'virusfilter__status_none' => 'Désactivé',
    'virusfilter__status_any' => 'Mails entrants et sortants',
    'virusfilter__status_outgoing' => 'Uniquement les mails sortants',
    'virusfilter__status_incoming' => 'Uniquement les mails entrants',

    'visibility__root_override_parse_error' => 'Il y a une erreur de syntaxe dans le fichier %1 dans le ligne %2.',

    'sb__not_support_publishing_api' => "Ce composant ne prend pas en charge les fonctionnalités pour la publication automatique.",

    'component_name__cphosting' => "Hébergement Plesk",

    'dom_pref__unable_set_up_total_mboxes_quota' => 'Le serveur de messagerie actuel ne prend pas en charge la configuration des quotas de courriel.',
    '__unable_get_total_mboxes_quota' => 'Le serveur de messagerie actuel ne prend pas en charge la configuration des quotas de courriel.',

    'install_prefix__parent_not_exists' => "Le répertoire parent n'existe pas.",

    'bt_change_version' => 'Changer de numéro de version',
    'pb__aspdotnet' => 'ASP.NET',

    '__check_all' => "Tout sélectionner",
    '__uncheck_all' => "Nettoyer tout",

    'dns__editing_domain_controller_zone' => "L'édition des enregistrements de la zone DNS pour le contrôleur de domaine peut perturber le bon fonctionnement du domaine",

    'pb__interface_management' => "Gestion de l'interface",
    'interface_management__tabs_skins' => "Skins",
    'interface_management__tabs_interface_templates' => "Templates d'interface",
    'interface_management__tabs_locales' => "Localisation",
    'locales_list__title' => "Référentiel des packs de langues",
    'locales_list__legend' => "Langues disponibles",
    'locales_list__active_title' => "S",
    'locales_list__locale_title' => "Pack de langues",
    'locales_list__lang_title' => "Langue",
    'locales_list__country_title' => "Pays",
    'locales_list__used_title' => "Utilisé",

    'backup__suspend_warning_during_backup' => "Le domaine sera indisponible pendant la sauvegarde.",
    'backup__suspend_warning_during_restore' => "Le domaine sera indisponible pendant la restauration",
    'backup__suspend_domain' => "Suspendre le  domaine",

    'locales_list__mls_limit' => "La licence actuelle de votre version de Plesk autorise l'utilisation de %2 langues. Pour le moment, vous avez %1 langues configurées comme étant disponibles pour les utilisateurs, ce qui dépasse le nombre fourni avec la licence. Veuillez sélectionner %2 langues que vous voulez utiliser et rendre les autres indisponibles pour les utilisateurs en cliquant sur leurs icônes dans la colonne 'S'.",

    'bt_change_owner' => 'Affecter un nouveau propriétaire',
    'chown__new_owner' => 'Nouveau propriétaire',
    'chown__selected_domains' => 'Abonnements sélectionnés',
    'chown__limits_legend' => 'Ressources',
    'chown__limit_name' => 'Nom de la ressource',
    'chown__limit_value' => 'Ressources allouées',
    'chown__limit_assigned_before' => 'Avant le transfert',
    'chown__limit_assigned_after' => 'Après le transfert',
    'chown__error_limits' => "Impossible de poursuivre le transfert d'abonnement : cet abonnement requière plus de ressources que ce que le fournisseur du nouveau propriétaire peut fournir.",
    'chown__error_no_domains' => 'Impossible de poursuivre le transfert d\'abonnement : soit aucun abonnement n\'est pas sélectionné, soit les abonnements sélectionnés appartiennent déjà à l\'utilisateur cible.',
    'chown__error_empty_ip_pool' => "Impossible de poursuivre le transfert d'abonnement : Le pool d'IP du fournisseur du nouveau propriétaire est vide. Veuillez vous assurer que le fournisseur a au moins l'adresse IP dans le pool.",
    'chown__please_select_new_domain_owner' => 'Sélectionner le nouveau propriétaire pour cet abonnement',
    'chown__old_ip_address' => 'Adresse IP actuelle',
    'chown__new_ip_address' => 'Nouvelle adresse IP',

    'chown__error_ssl_already_used' => "La prise en charge SSL/TLS est déjà activée sur les adresses IP de destination suivantes : %1. Par conséquent, les domaines suivants avec prise en charge SSL/TLS n'ont pas été transférés : %2. Réglez le problème puis réessayez.",
    'chown__sitebuilder_not_installed' => 'Presence Builder n\'est pas installé',
    'chown__domain_exclude_sitebuilder_not_installed' => 'Impossible de transférer le domaine %1 vers un autre propriétaire car Presence Builder n\'est pas installé.',

    'backup__backup_time' => 'Heure de la sauvegarde',
    'backup__backup_time_hour' => 'heures',
    'backup__backup_time_minute' => 'minutes',
    'backup__every' => 'tous les',
    'backup__day_of_month' => 'jour du mois',

    'subdomain__select_hst_type' => 'Sélectionnez le type d\'hébergement du sous-domaine',
    'hst_sel__subdom_subfolder_hst' => 'Sous-domaine sur un sous-dossier',
    'subdomain__www_root_folder_not_exists' => 'Le répertoire principal %1 du site n\'existe pas.',
    '__site_home_dir' => 'Répertoire principal du site',
    'subdomain__aspnet_disabled_domain' => 'désactivé par le domaine',

    'domains__remove_description' => 'Toutes les données sur le domaine, y compris le contenu et les paramètres du domaine et de ses sous-domaines respectifs, les données des applications Web, le contenu des boîtes mail, les paramètres antivirus et anti-spam, les fichiers de log, les données du répertoire de sauvegarde du domaine et les certificats SSL/TLS seront supprimées. Si vous n\'avez pas de fichier de sauvegarde de ces données sur votre machine locale, toutes les données seront perdues irrémédiablement.',
    'subdomains__remove_description' => 'Toutes les données du sous-domaine, y compris le contenu du sous-domaine et ses paramètres, les données des applications Web et les fichiers de log, seront supprimées. Si vous n\'avez pas sauvegardé ces données dans un fichier de sauvegarde sur votre machine locale, toutes les données seront perdues irrémédiablement.',

    'mail__tabs_spam_filtering' => 'Anti-spam',
    'mail__tabs_antivirus' => 'Antivirus',
    'antivirus__use_server_settings_scan' => 'Utiliser les paramètres par défaut valables pour tout le serveur (analyser)',
    'antivirus__use_server_settings_no_scan' => 'Utiliser les paramètres par défaut valables pour tout le serveur (ne pas analyser)',
    'antivirus__check_for_viruses' => 'Rechercher des virus',
    'antivirus__dont_check_for_viruses' => 'Ne pas rechercher de virus',
    'antivirus__incoming_mail' => 'Mail entrant',
    'antivirus__outgoing_mail' => 'Mail sortant',

    'domain_alias__CNAME_dns_record_exists' => 'Un enregistrement DNS CNAME portant ce nom existe déjà',
    'domain_alias__A_dns_record_exists' => 'Un enregistrement DNS A portant ce nom existe déjà',
    'domain_alias__bad_prefix' => 'Le préfixe de l\'alias de domaine est incorrect.',
    'domain_alias__domain_doesnt_exist' => "Ce domaine n'existe pas",

    'dns__zone_ttl_message_info' => 'Si aucune valeur TTL n\'est spécifiée, la valeur TTL dans le Template pour enregistrements SOA (%1) sera utilisée pour cet enregistrement DNS.',

    '__webalizer_support' => 'Webalizer',
    '__awstats_support' => 'AWStats',
    '__smarterstats_support' => 'SmarterStats',

    'site_apps__make_default_warning_message' => "Une fichier intitulé index.html sera créé pour la redirection vers l' application Web sélectionnée. Si un fichier intitulé index.html existe déjà, il sera sauvegardé en tant que index.html.old puis remplacé par le nouveau. Appuyez sur OK pour confirmer",

    'bt_ftp_ctrl' => "Comptes FTP supplémentaires",
    'ftp_users_no_permission' => "Vous n'êtes pas autorisé à gérer les comptes FTP de ce domaine",
    'ftp_users_limit_reached' => "Ce domaine a atteint le nombre maximum de comptes FTP autorisés",
    'pb__ftp_ctrl' => "Gestion de FTP",
    'class_client__max_subftp_users' => "Comptes FTP supplémentaires",

    '__client_form_settings' => "Paramètres du client",
    '__sbnet_client_keep_sbnet' => "Conserver le compte utilisateur correspondant dans Presence Builder",
    '__sbnet_cant_add_more_sites' => "Ce client a atteint le nombre limite de sites utilisables dans Presence Builder.",
    '__sbnet_legend_text' => "Intégration de Presence Builder",
    '__sbnet_synchronize_user_with_sbnet' => "Créer un compte utilisateur correspondant dans Presence Builder",
    '__sbnet_client_warning_delete_sb_user' => "Vous essayez de supprimer un compte utilisateur Presence Builder associé à ce client. Cette action supprimera tous les sites Web des utilisateurs ainsi que tous les autres paramètres importants du système Presence Builder. Vous ne pourrez plus modifier les sites Web existants via Presence Builder, même si vous réactivez cette option par la suite. Si vous créez à nouveau un compte utilisateur Presence Builder, vous devrez créer et publier tous les sites Web de A à Z. Voulez-vous désactiver la création et la publication de sites Web via Presence Builder ?",
    'sb__build_site_with_subdomains' => "Créer les sous-domaines Blog et Album photos",
    '__sbnet_client_dont_have_sbuser' => "Impossible de créer et de publier un site avec Presence Builder : utilisateur Presence Builder inexistant",

    '__component_disabled' => "Composant arrêté",

    'subdomains__physical_path_not_exist' => "Des sous-domaines sont liés à des dossiers physiques inexistants",

    'dnsserver_bind_to_msdns_switching_warning' => "Attention ! Seules les 254 premières adresses IP des masques de sous-réseaux /8 et /16 figurant dans la liste des contrôles d'accès seront transférées. Elles seront transférées en tant qu'adresses IP distinctes. Voulez-vous continuer ?",

    '__sbnet_net_framework_required_for_site' => "Les sites Presence Builder peuvent nécessiter la prise ne charge d'ASP.NET 2.0 sur votre domaine. Nous vous recommandons d'activer la prise en charge d'ASP.NET 2.0 si vous utilisez Presence Builder.",

    'subdomain_auto_create_dir' => "Créer un répertoire physique pour le sous-domaine",

    'sa_trainer__unable_to_get_messages_list' => "Impossible d'obtenir la liste des messages de la boîte mail : %1",
    'sa_trainer__pass_doesnt_exist' => "Le mot de passe de ce compte mail manque",

    '__sitebuilder_error' => "Une erreur s'est produite pendant la tentative de connexion à Presence Builder. Veuillez contacter votre fournisseur de services pour obtenir de l'aide.",
    'wsb_error_user_not_exist' => "Ce compte utilisateur Presence Builder n'existe pas.",
    'wsb_error_site_already_exist' => "Ce site existe déjà dans Presence Builder.",
    'wsb_error_site_limit_reached' => "Le nombre maximum de sites Presence Builder est atteint.",
    'wsb_error_internal_error' => "Une erreur interne à Presence Builder s'est produite. Veuillez contacter votre fournisseur de services pour obtenir de l'aide.",
    'wsb_error_user_already_exist' => "Un utilisateur Presence Builder portant ce nom existe déjà dans Presence Builder.",
    'sb_error_user_not_exist' => "L'utilisateur Presence Builder n'existe pas.",
    'wsb_error_object_not_found' => "Presence Builder n'a pas été en mesure de trouver l'hôte correct.",

    'mg_no_mail_groups' => "Pas de groupe de messagerie",

    'drweb__drweb_incoming' => 'Contrôle antivirus des messages entrants',
    'drweb__drweb_outgoing' => 'Contrôle antivirus des messages sortants',
    'drweb__disable_reason_serv' => 'Le serveur de messagerie ne prend pas en charge la configuration du filtre antivirus au niveau de la boîte mail.',

    'vz_sitebuilder3_client_cant_be_created' => "Impossible de créer un compte client : SiteBuilder version 3.1 ou ultérieure n'est pas installée",

    'chown__client_without_sitebuilder_support' => "Impossible de continuer le transfert des abonnements : le service Presence Builder n'est pas inclus dans le pack de services des nouveaux propriétaires ou de leurs fournisseurs.",

    // new limits

    'class_client__max_odbc' => "Connexions ODBC",
    'cl_perm__max_odbc' => "Nombre maximum de connexions ODBC",

    // domain aliases DNS
    'domain_alias__list_status' => 'S',
    'domain_alias__list_name' => 'Alias du nom de domaine',
    'domain_alias__list_ascii_name' => 'Au format ASCII',


    // Interface Customization Templates
    'interface_preferences' => 'Gestion de l\'interface',
    'pb__interface_templates' => 'Gestion de l\'interface',
    'pb__interface_clients' => 'Clients utilisant %1',

    // service management
    'bt_service_showall' => "Tout afficher",
    'bt_service_hideall' => "Tout masquer",
    'bt_service_start' => "Démarrer",
    'bt_service_stop' => "Arrêter",
    'bt_service_restart' => "Redémarrer",
    'bt_service_disable' => "Désactiver",
    'bt_service_manual' => "Manuel(le)",
    'bt_service_auto' => "Auto",
    'service_startup_auto' => 'Automatique',
    'service_startup_manual' => 'Manuel(le)',
    'service_startup_disabled' => 'Désactivé',
    'service_action_ok' => "L'opération avec le service %1 s'est déroulée correctement",
    'service_action_failed_disabled_service' => "L'opération n'a pas pu être réalisée avec le service %1 parce que celui-ci est hors service",
    'service_action_failed_error' => "L'opération n'a pas pu être réalisée : %1",
    'service_group_action_ok' => "L'opération avec les services suivants s'est déroulée correctement : %1",
    'service_group_action_disabled' => "L'opération n'a pas pu être réalisée avec les services suivants parce que ceux-ci sont hors service : %1",
    'service_group_action_failed' => "Impossible de réaliser l'opération avec les services suivants : %1. Pour obtenir des informations détaillées sur l'erreur, exécutez l'opération avec chaque service séparément",

    // php 4vs5
    'bt_php' => "Paramètres PHP",

    'bt_insert' => "Insérer",

    // wsb integration
    'wsb_error_sitebuilder_database_error' => "Une erreur s'est produite dans la base de données de Presence Builder.Veuillez contacter votre fournisseur de services pour obtenir de l'aide.",
    'wsb_error_sitebuilder_access_denied_error' => "Impossible d'accéder au fichier : Presence Builder ne dispose pas des droits d'accès pour le fichier ou le dossier requis. Veuillez contacter votre fournisseur de services pour obtenir de l'aide.",
    'wsb_error_sitebuilder_connection_failed' => "Impossible de se connecter à Presence Builder, en raison d'une perte de connexion. Veuillez contacter votre fournisseur de services pour obtenir de l'aide.",
    'wsb_error_critical_during_operation' => "Une erreur critique s'est produite dans Presence Builder :\n%1",
    'wsb_error_license_during_operation' => "Une erreur de licence Presence Builder s'est produite:\n%1",
    'wsb_error_during_operation' => "Une erreur s'est produite dans Presence Builder :\n%1",
    'wsb_error_license_error' => "Une erreur liée à la limitation du nombre licences Presence Builder s'est produite.",

    // Other
    '__confrim_service_stop' => "Attention ! Si vous stoppez le service %1, Plesk risque de ne plus fonctionner. Voulez-vous vraiment stopper le service %1 ?",
    'index_redirect_help_text' => 'Vous serez maintenant automatiquement redirigé sur le site Web demandé. Si votre navigateur ne prend pas en charge les redirections, veuillez cliquer %1 ici %2',
    'bt_default_settings' => "Restaurer paramètres p. déf.",
    'logfiles__remove_failed' => "Impossible de supprimer le fichier %1 : le fichier est verrouillé par une autre application. Veuillez réessayer plus tard.",
    'subdomain__invalid_homedirectory' => "Le répertoire principal indiqué pour le sous-domaine est incorrect.",
    'scheduler_item__empty_filename' => "Veuillez indiquer quel exécutable il faut lancer",
    'subdomains__overlapped_domain_exists' => 'Le sous-domaine et la zone DNS du domaine %1 se chevauchent.',
    'subdomains__overlapped_domain_alias_exists' => 'Le sous-domaine et la zone DNS de l\'alias du domaine %1 se chevauchent.',
    'services_action_none_selected' => 'L\'opération n\'a pas pu être réalisée : veuillez sélectionner les services requis',
    'cl_perm__max_subftp_users' => "Quantité maximum de comptes FTP supplémentaires",
    'login_up__access_denied_no_cp_access' => 'Accès refusé. Vous n\'avez pas le droit d\'accéder à Plesk.',
    'drweb__disable_reason_admin' => "Les paramètres du filtre antivirus au niveau de la boîte mail ne sont pas autorisés par la politique du serveur.",

    '__use_default' => 'Utiliser par défaut',

    'webalizer_hidden_referrer__already_exist' => 'Cette entrée existe déjà.',
    'webalizer_group_referrer__already_exist' => 'Un groupe de référenceurs porte déjà ce nom.',

    'pb__dashboard' => 'Accueil',

    'server_interface__page_title' => 'Paramètres d\'interface du serveur',
    'server_interface__tabs_locales' => 'Localisation',
    'server_interface__tabs_skins' => 'Skins',
    'server_interface__tabs_interface_templates' => 'Templates d\'interface',
    'bt_server_interface' => 'Préférences de l\'interface',
    'pb__server_interface' => 'Préférences de l\'interface',

    'bt_wizard_next' => 'Suivant >>',
    'bt_wizard_prev' => '<< Précédent',

    '__limit_exceeded_max_dom_server' => 'Vous ne pouvez pas héberger plus de domaines sur ce serveur car le nombre max de domaines autorisé sur le serveur par la clé de licence a été atteint. Contactez votre fournisseur de services pour résoudre ce problème.',
    '__limit_exceeded_max_subdom_server' => 'Vous ne pouvez pas héberger plus de sous-domaines sur ce serveur. Veuillez contacter votre fournisseur de services.',
    '__limit_exceeded_max_dom_aliases_server' => 'Vous ne pouvez pas configurer plus d\'alias de domaines sur ce serveur. Veuillez contacter votre fournisseur de services.',
    '__limit_exceeded_max_wu_server' => 'Vous ne pouvez pas créer plus d\'utilisateurs Web sur ce serveur car le nombre max d\'utilisateurs Web autorisé sur le serveur par la clé de licence a été atteint. Contactez votre fournisseur de services pour résoudre ce problème.',
    '__limit_exceeded_max_mn_server' => 'Vous ne pouvez pas créer plus de comptes mail sur ce serveur car le nombre max de comptes mail autorisé sur le serveur par la clé de licence a été atteint. Contactez votre fournisseur de services pour résoudre ce problème.',

    '__limit_exceeded_max_cl_useradmin' => 'Vous avez atteint le nombre maximum de comptes client définis par votre clé de licence (%2).',
    '__limit_exceeded_max_dom_useradmin' => 'Vous avez atteint le nombre maximum de domaines fixé par votre licence (%2).',
    '__limit_exceeded_max_subdom_useradmin' => 'Vous avez atteint le nombre maximum de sous-domaines définis par votre clé de licence (%2).',
    '__limit_exceeded_max_dom_aliases_useradmin' => 'Vous avez atteint le nombre maximum d\'alias de domaines définis par votre clé de licence (%2).',
    '__limit_exceeded_disk_space_useradmin' => 'Il ne vous reste plus d\'espace disque libre',
    '__limit_exceeded_max_wu_useradmin' => 'Vous avez atteint le nombre maximum de comptes utilisateur Web fixé par votre licence (%2).',
    '__limit_exceeded_max_db_useradmin' => 'Vous avez atteint le nombre maximum de bases de données fixé par votre licence (%2).',
    '__limit_exceeded_max_box_useradmin' => 'Vous avez atteint le nombre maximum de boîtes aux lettres fixé par votre licence (%2).',
    '__limit_exceeded_max_mn_useradmin' => 'Vous avez atteint le nombre maximum de comptes mail définis par votre clé de licence (%2).',
    '__limit_exceeded_max_maillists_useradmin' => 'Vous avez atteint le nombre maximum de listes de diffusion autorisées par votre licence (%2).',

    '__limit_exceeded_max_dom_userclient' => 'Vous avez atteint le nombre max de domaines (%2)',
    '__limit_exceeded_max_subdom_userclient' => 'Vous avez atteint le nombre maximum de sous-domaines (%2) autorisés par votre fournisseur de services',
    '__limit_exceeded_max_dom_aliases_userclient' => 'Vous avez atteint le nombre max d\'alias de domaines (%2).',
    '__limit_exceeded_disk_space_userclient' => 'Vous avez atteint la limite d\'utilisation de l\'espace disque (%2)',
    '__limit_exceeded_max_traffic_userclient' => 'Vous avez atteint la limite max d\'utilisation de la bande passante par mois (%2)',
    '__limit_exceeded_max_wu_userclient' => 'Vous avez atteint le nombre maximum d\'utilisateurs Web (%2) autorisés par votre fournisseur de services.',
    '__limit_exceeded_max_db_userclient' => 'Vous avez atteint le nombre max de bases de données (%2)',
    '__limit_exceeded_max_box_userclient' => 'Vous avez atteint la limite du nombre max de boîtes mails (%2)',
    '__limit_exceeded_max_maillists_userclient' => 'Vous avez atteint le nombre max de listes de diffusion (%2)',
    '__limit_exceeded_expiration_userclient' => 'Votre compte a expiré le %2',

    '__limit_exceeded_max_subdom_userdomain' => 'Vous avez atteint le nombre maximum de sous-domaines (%2) autorisés par votre fournisseur de services',
    '__limit_exceeded_max_dom_aliases_userdomain' => 'Vous avez atteint le nombre max d\'alias de domaines (%2).',
    '__limit_exceeded_disk_space_userdomain' => 'Vous avez atteint la limite d\'utilisation de l\'espace disque (%2)',
    '__limit_exceeded_max_traffic_userdomain' => 'Vous avez atteint la limite max d\'utilisation de la bande passante par mois (%2)',
    '__limit_exceeded_max_wu_userdomain' => 'Vous avez atteint le nombre max de comptes utilisateur Web (%2)',
    '__limit_exceeded_max_db_userdomain' => 'Vous avez atteint le nombre max de bases de données (%2)',
    '__limit_exceeded_max_box_userdomain' => 'Vous avez atteint la limite du nombre max de boîtes mails (%2)',
    '__limit_exceeded_max_maillists_userdomain' => 'Vous avez atteint le nombre max de listes de diffusion (%2)',
    '__limit_exceeded_expiration_userdomain' => 'Votre compte a expiré le %2',

    'sapp_error_validation_not_found' => 'Impossible de valider l\'application Web car un des fichiers requis (%1) n\'a pas été trouvé. Contacter votre représentant de l\'assistance technique pour obtenir de l\'aide.',
    'sapp_error_validation_spec_failed' => 'L\'application Web envoyée n\'est pas conforme aux spécifications PacksApp : %1.',
    'sapp_error_validation_register' => 'Impossible d\'enregistrer l\'application Web située dans le répertoire "%1": %2. Vous devez renommer l\'application Web du serveur car elle ne fonctionnera pas correctement.',

    'sapp__install_failed' => 'L\'installation des applications Web a échoué : %1',
    'sapp__install_res_failed' => 'Impossible de créer la ressource requise.',

    'server_preferences__subdomains_blog_and_photo' => 'Créer les sous-domaines Blog et Album photos par défaut',
    'plesk_key__blog_and_photo' => 'Possibilité de gérer le statut par défaut de la case Créer les sous-domaines Blog et Album photos',
    'ip_ctrl__cannot_make_exclusive_ip_with_more_than_one_client' => 'Impossible de transformer l\'adresse IP en adresse dédiée car elle est affectée à plus d\'un utilisateur.',

    // 8.1.1

    '__write_modify_warning' => 'Si vous choisissez d\'autres droits d\'écriture / de modification, certaines applications Web fonctionneront correctement, mais cela fera augmenter considérablement les risques pour la sécurité',
    '__write_modify_subdomain_warning' => 'Si vous choisissez d\'autres droits d\'écriture / de modification, certaines applications Web fonctionneront correctement, mais cela fera augmenter considérablement les risques pour la sécurité',

    'phosting__php_incorrect_version_used' => "Le système a détecté des problèmes en rapport avec la version de PHP. Pour résoudre ces problèmes, cochez la case ci-dessous correspondant à la version de PHP requise, puis cliquez sur OK. Pour désactiver PHP sur ce domaine, cliquez sur OK sans sélectionner la version de PHP.",
    'fp__mail_preferences' => 'Paramètres de la messagerie',

    'mail__invalid_white_pattern' => 'La valeur spécifiée n\'est pas valide. Utilisez les formats suivants : mail@exemple.com pour les adresses e-mail, exemple.com pour les domaines.',
    'mail__invalid_black_pattern' => 'La valeur indiquée est invalide. Utilisez le format suivant : mail@exemple.com pour les adresses mail, exemple.com pour les domaines.',

    'resp_edit__reply_as_html' => 'Envoyer au format HTML',
    'exception__path_very_long' => "Le chemin d'accès est trop long. Veuillez vous assurer qu'il y a moins de %1 caractères dans le chemin d'accès.",

    // 8.2


    //SAPP
    'sapp_on' => 'Activé',
    'sapp_off' => 'Désactivé',
    'sapp_directive_aspect' => 'Obligatoire',
    'sapp_databases_num' => 'Bases de données',
    'sapp_db_required' => 'Obligatoire',
    'sapp_Required' => 'Obligatoire',
    'sapp_Variant' => 'Variante',
    'sapp_db_id' => 'ID de la base de données',
    'sapp_db_id_type' => 'BD (id: %1) type',
    'sapp_db_id_min_version' => 'Version min BD (id: %1)',
    'sapp_db_id_table_prefix' => 'BD (id: %1) préfixe de la table',
    'sapp_Default' => 'Valeur par défaut',
    'sapp_apache_mod_req' => 'Module Apache',
    'sapp_dbtype_not_installed' => 'Ne pas installer',
    'sapp_apache_mod_not_installed' => 'Ne pas installer',
    'sapp_error_invalid_type' => 'L\'application "%1" ne prend pas en charge l\'action nécessaire.',
    'sapp_error_unknown_app_type' => 'Type d\'application non pris en charge : %1.',
    'sapp__ssl_text' => 'Installer l\'application sur un hôte virtuel "http://" ou "https://" ?',
    'sapp__app_to_upgrade' => 'Applications à mettre à niveau',
    'sapp__upgrade_apps_title' => 'Mettre à niveau les applications',
    'sapp__upgrade_to_ver' => 'Passer à une autre version',
    'sapp__choose_pkg_ver' => 'Sélectionnez un pack...',
    'sapp__pkg_cant_upgrade_pkg' => 'Le pack "%1" ne peut pas être utilisé pour mettre à niveau l\'application Web "%2".',
    'sapp__app_ugrade_error' => 'Impossible de mettre à niveau l\'application : %1. Veuillez contacter votre administrateur système.',
    'sapp__no_suitable_db_found' => 'Aucune base de données qui convienne n\'a été trouvée.',
    'sapp__upgrade_success' =>  'L\'application a bien été mise à niveau.',
    'sapp__pkg_info_changelog' => 'Historique des changements',
    'sapp_requirement_legend' => 'Fonctionnalités d\'hébergement  requises par l\'application',

    // other
    'bt_apply' => 'Appliquer',
    'mn_edit__add_alias_if_mailbox_disabled' => 'Pour créer un alias de messagerie, la boîte mail doit être activée sur ce compte mail. Voulez-vous activer cette boîte mail ?',
    'mn_edit__mailbox_disable_if_has_alias' => 'La désactivation de la boîte mail entraînera la suppression des alias de messageries puisqu\'ils s\'arrêteront de fonctionner. Voulez-vous désactiver la boîte mail ?',
    'antivirus__disable_reason_install' => 'Vous ne pouvez pas gérer l\'antivirus, car il n\'est pas installé.',
    'antivirus__disable_reason_key' => 'Vous ne pouvez pas gérer l\'antivirus, car il n\'est pas activé par une clé de licence correcte.',
    'antivirus__disable_reason_deny_personal_settings' => 'Vous ne pouvez pas gérer l\'antivirus, car la politique de serveurs interdit les paramètres antivirus individuels.',
    'change_foreign_user_password' => 'Modifier le mot de passe',
    'change_foreign_user_password_hint' => "L'utilisateur n'appartient pas à cette application. Cliquez sur le lien pour vous rendre sur une autre application et modifiez le mot de passe de l'utilisateur ici. Pour ce faire, vous devez disposer des droits appropriés de cette application.",
    'cf_url_text' => 'URL du JDBC',
    'cf_sendStringParametersAsUnicode_text' => 'Format de la chaîne',
    'lang_unknown' => 'Langue inconnue',
    'pb__cl_ed' => 'Détails du client',
    'pb__actionlog' => 'Journal des actions',
    'pb__cl_limits' => 'Limites du client',
    'pb__edit' => 'Éditer',
    'pb__subdom_edit' => 'Paramètres d\'hébergement',

    // NEW 8.3 FEATURES

    'backup_mail_content' => 'Sauvegarder le contenu des boîtes de messagerie',

    'maillist_import_result' => "\nAdresses mail au total dans ce fichier : %1\ndu total des adresses mail importées : %2\ndu total des adresses mail qui existent déjà : %3\ndu total des adresses mail en double dans le fichier indiqué : %4\ndu total des adresses mail incorrectes dans le fichier indiqué : %5",
    'maillist_import_error' => 'Impossible d\'importer la liste des adresses mail',

    //  spaw

    'spaw__unable_to_edit_no_body' => "Le fichier que vous avez sélectionné est vide ou ne contient pas de document HTML valide dans l'encodage sélectionné. Veuillez sélectionner l'encodage approprié ou simplement ajouter du contenu au fichier.",

    'dom_pref__external_mail_srv' => "Rediriger vers le serveur de messagerie externe avec l'adresse IP :",
    'mn_edit__store_messages' => 'Boîte mail',

    // aps

    'sapp__before_upgrade_notice' => 'Il est conseillé de sauvegarder l\'application et les données des utilisateurs avant de lancer la mise à niveau.',
    'sapp__application_properties' => 'Propriétés de l\'application',
    'sapp__application_root_descr' => 'Page principale de l\'application',

    'sapp__aps_license_invalid_id' => 'L\'ID de la clé de licence est incorrect : %1.',
    'sapp__aps_lic_key_alredy_exists' => 'La licence portant le numéro de clé %1 existe déjà dans la base de données.',
    'sapp__aps_lic_del_used' => 'Impossible de supprimer la clé de licence car elle est utilisée par une autre application installée.',
    'sapp__aps_lic_del_unknown' => 'Impossible de supprimer la clé de licence : %1',
    'sapp__aps_cappi_duplicate' => "Cette application existe déjà dans le pool d'applications de ce client.",
    'sapp__appi_not_shared_no_install' => "Il n'y a aucune application dans le pool d'applications du client.Si vous voulez installer cette application sur un site, vous devez tout d'abord ajouter cette application au pool d'applications du client.",
    'sapp__appi_shared_not_client' => "Il n'y a aucune application dans le pool d'applications du client. Si vous voulez mettre à niveau l'application vers une version indiquée, vous devez tout d'abord ajouter cette version de l'application au pool d'applications du client.",
    'sapp__apply_license_script_not_found' => 'Impossible de trouver le script "apply-license" pour cette application Web.',
    'sapp__unable_to_activate_key' => 'Une erreur s\'est produite lors d\'une tentative d\'activation d\'une clé de licence : %1',
    'sapp__unable_to_delete_ai_instances_exists' => 'Certaines applications Web installées requièrent la présence de cette application Web dans le système.',
    'sapp__unable_to_delete_ai_in_pool' => 'Cette application existe déjà dans le pool d\'un client. Si vous voulez supprimer cette application, vous devez tout d\'abord la supprimer de tous les pools d\'applications des clients ou la rendre gratuite.',
    'sapp__unable_to_delete_app_template' => 'Impossible de supprimer l\'application #%1 : %2',
    'sapp__limit_exceeded_client' => 'Vous avez atteint le nombre maximum de fois où vous pouvez installer cette application Web (%2).',


    // atis module

    '_week_on' => 'semaine(s)',
    '__week_first' => 'premier',
    '__week_second' => 'deuxième',
    '__week_third' => 'troisième',
    '__week_fourth' => 'quatrième',
    '__week_last' => 'dernier',
    '__not_started' => 'En cours de traitement',
    '__started' => 'En cours d\'exécution',
    '__cancel_pending' => 'En cours d\'annulation',
    '__canceled' => 'Annulé(e)',
    '__error' => 'Erreur',
    '__done' => 'Fait',

    '__php_cgi_handler' => 'Application CGI',
    '__php_isapi_handler' => 'Extension ISAPI',
    '__php_fastcgi_handler' => 'Application FastCGI',
    '__php_module_handler' => 'mod_php',
    '__php_run_as' => 'exécutez en tant que',

    'cf_dbfolder_text' => 'Dossier de la base de données',
    'cf_isnewdb_text' => 'Créer la base de données',
    'cf_isnewdb_title' => 'Veuillez cocher la case si la base de données doit être créée',

    'pb__site_apps_upgrade' => 'Mise à jour de l\'application Web',

    'detach' => 'Déconnecter',
    'preferences' => "Modifier le mot de passe",

    'toolsbar__switch_user?' => "Voulez-vous vraiment ouvrir une session sous un autre compte utilisateur ?",
    '__aps_left' => 'Nombre d\'installations disponibles',
    'aps__license_key' => 'Clé de licence',
    'aps__download_code' => 'Téléchargement de la clé de licence et code d\'activation',
    'aps__license_key_hint' => 'Récupération depuis le serveur de licences à l\'aide du code d\'activation',
    'aps__database_not_available' => 'indisponible, veuillez vérifier les limites du client ou du domaine',
    'aps__yes' => 'oui',
    'aps__no' => 'non',
    '__click_to_enlarge' => 'Cliquer pour élargir',
    'site_apps__back_to_list' => 'Revenir à la liste',
    'sapp__pkg_info_installation_requirements' => 'Exigences d\'installation',
    '__close_window' => 'Fermer',

    //SAPP END

    'skin_info__already_default' => 'Ce skin est déjà défini par défaut.',

    //move this to other file after splitting drweb to module
    'drweb:virus_filter_full_name' => 'Plesk Premium Antivirus',
    'drweb:properties_page_title' => 'Paramètres Plesk Premium Antivirus pour %1',
    'drweb:properties_legend' => 'Paramètres',
    'drweb:status' => 'Analyse de la messagerie à la recherche de virus',

    // sb integration
    'sitebuilder_wizard' => 'Assistant Presence Builder',
    'dom_site_builder' => 'Cliquez pour ouvrir l\'assistant Presence Builder.',
    'sb_plesk_admin_url' => 'URL du serveur Presence Builder. Vérifiez que cette adresse est résolue correctement dans le DNS.',
    'sb_plesk_admin_login' => 'Nom d\'utilisateur pour la connexion de l\'administrateur dans Presence Builder',
    'sb_plesk_admin_password' => 'Mot de passe de l\'administrateur',
    'sb_sitebuilder_preferences' => 'Identifiants d\'administrateurs Presence Builder',
    'sb__server' => 'Préférences de l\'administrateur système Presence Builder',
    'sb__sitebuilder_support' => 'Prise en charge de Presence Builder',
    'sb_keep_sb_user' => 'Conserver le compte utilisateur correspondant dans Presence Builder',
    'sb_create_sb_user' => 'Créer un compte utilisateur correspondant dans Presence Builder',
    'sb__build_site_using_sitebuilder' => "Créer un site Web à l'aide de Presence Builder",
    'sb_no_current_sb_server_set' => 'La connexion à Presence Builder n\'est pas encore configurée : vous devez ajouter un enregistrement A qui pointe vers le serveur Presence Builder dans le template de zone DNS.',
    'sb_unable_update_sb_server_sb_return_message' => "Impossible de récupérer les informations à partir du système Presence Builder :\n%1",
    'sb_unable_connect_sb_wrong_con_params' => "Impossible de se connecter à Presence Builder : nom d'utilisateur ou mot de passe incorrect.",
    'sb_init_sb_manager' => "Initialisation du gestionnaire Presence Builder : %1",
    'sb_err_couldnt_connect_sb' => "Échec de la connexion au système Presence Builder.",
    'sb_err_client_dont_have_sbuser' => "Le client n'a pas de compte utilisateur dans Presence Builder.",
    'sb_err_sitebuilder_not_configured' => "Presence Builder n'est pas configuré.",
    'sb_err_you_dont_have_sbaccount' => "Échec de votre authentification dans Presence Builder.",
    'sb_error_critical_during_operation' => "L'erreur suivante s'est produite dans Presence Builder :\n%1",
    'sb_err_sso_is_not_enabled' => "La prise en charge SSO (Single Sign On) n'est pas activée dans Plesk.",

    'warning__super_zone_exist' => "La zone %1 a bien été créée cependant le nom de cette zone est une sous-zone d'une autre zone %2 déjà existante qui appartient à un autre utilisateur %3. C'est possible, mais assurez-vous d'avoir choisi le bon compte utilisateur.",
    'error__super_zone_exist' => "Impossible de créer la zone DNS car sa superzone appartient à un autre utilisateur.",

    'locales__files_not_exits' => 'Impossible de changer la traduction : les fichiers du pack de langue de l\'interface indiqués n\'existent pas dans le système.',
    'locales__unavailable' => 'Impossible de changer la traduction : le pack de langue de l\'interface indiqué est indisponible.',

    // DB BU

    'pb__dbbackup_list' => 'Fichiers de sauvegarde de la base de données',
    // server
    'dbbackup__server_backup_settings' => 'Sauvegarde',
    'dbbackup__network_temp_dir' => 'Répertoire réseau temporaire',
    'dbbackup__network_user' => 'Nom d\'utilisateur',
    'dbbackup__network_pass' => 'Mot de passe',
    // domain
    'dbbackup__add_database_legend' => 'Restaurer la base de données sauvegardée',
    'dbbackup__add_database_restore' => 'Restaurer la base de données à partir du fichier de sauvegarde',
    'dbbackup__add_database_file' => 'Fichier de sauvegarde de la base de données',
    'dbbackup__add_database_user' => 'Nom d\'utilisateur par défaut',
    'dbbackup__add_database_pass' => 'Mot de passe de l\'utilisateur par défaut',
    'dbbackup__add_database_pass2' => 'Confirmation du mot de passe de l\'utilisateur par défaut',

    'bt_dbbackup_now' => 'Sauvegarder',

    'bt_repair' => 'Réparer',

    'dbbackup__mssql_dump_upload_not_allowed' => 'L\'envoi de dumps de bases de données SQL Server est interdit par l\'hébergeur.',

    // APS categories

    'cf_invalid_password' => 'Le mot de passe ne peut pas contenir plus de 16 caractères',
    'cf_invalid_description_length' => 'La description ne peut pas contenir plus de 256 symboles',
    'ip_addr__ip_used_by_external_mail_server' => 'L\'adresse IP %1 est déjà utilisée par le serveur de messagerie externe',

    // 8.4.1

    '__ftp_login_is_invalid' => 'Le nom d\'utilisateur ou mot de passe du compte FTP est incorrect. Veuillez indiquer des données d\'accès d\'utilisateur FTP correctes.',

    // 8.6

    'dns__dns_serial_update_limit_warning' => 'La limite des changements de numéros de série a été atteinte. Aucun changement sur la zone DNS peut être effectué aujourd\'hui.',
    'dns__zone_apply_changes' => 'Les changements appliqués aux enregistrements DNS ne sont pas encore enregistrés. Ces changements sont mis en surbrillance ci-dessous. Cliquez sur Mettre à jour pour appliquer les changements pour la zone DNS puis cliquez sur Annuler pour abonner les changements.',
    'dns__update_dns_zone' => 'Cliquer pour enregistrer les changements appliqués sur les enregistrements DNS',
    'dns__revert_dns_zone' => 'Cliquer pour annuler les changements appliqués sur les enregistrements DNS',
    'bt_revert' => 'Annuler',
    'dns__dns_zone_has_beed_updated' => 'Les changements appliqués aux enregistrements DNS ont été enregistrés.',
    'dns__dns_zone_has_beed_reverted' => 'Les changements appliqués aux enregistrements DNS ont été annulés.',
    'db__nondefault_server_not_allowed' => 'L\'utilisation du serveur de base de données qui n\'est pas défini par défaut n\'est pas autorisée',


    //// UI POINTER CAPTIONS START HERE
    ////
    // *** The strings below have been generated automatically from @@CAPTION directives.

    'ui__client__description' => 'Domaine et compte du client %1\\.',
    'ui__client__disabled-warning' => 'Le compte client %1 est suspendu.',
    'ui__client__none-available' => 'Il n\'y a aucun compte client configuré.',
    'ui__client__short-title' => '%1',
    'ui__client__title' => 'Client %1',
    'ui__client_self__description' => 'Liste de mes domaines.',
    'ui__client_self__short-title' => 'Mes domaines',
    'ui__client_self__title' => 'Mes domaines',


    'site_apps__non_removable' => 'Éléments qui ne peuvent pas être supprimés',
    'site_apps__non_removable_items' => 'Impossible de supprimer les applications Web suivantes :',

    'ui__client/custom-buttons/custom-button__none-available' => 'Il n\'y a pas de bouton personnalisé.',
    'ui__client/custom-buttons/custom-button__none-available__1' => 'Il n\'y a aucun bouton personnalisé dans le Panneau Client du client %1.',

    'ui__client/custom-buttons/custom-button/delete__description' => 'Supprimez le bouton %1.',
    'ui__client/custom-buttons/custom-button/delete__short-title' => 'Supprimer',
    'ui__client/custom-buttons/custom-button/delete__title' => 'Supprimer le bouton %1',
    'ui__client/custom-buttons/custom-button/delete_multi__description' => 'Supprimer les boutons personnalisés du Panneau Client du client',
    'ui__client/custom-buttons/custom-button/delete_multi__short-title' => 'Supprimer',
    'ui__client/custom-buttons/custom-button/delete_multi__title' => 'Supprimer les boutons personnalisés',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard-title' => 'Supprimer des boutons',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard__1_unknown' => 'Sélectionnez un client dont vous voulez supprimer les boutons personnalisés puis cliquez sur Suivant >>.',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard__3_multi' => 'Sélectionnez les boutons personnalisés que vous voulez supprimer puis cliquez sur Suivant >>.',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard__4_multi' => 'Cochez la case correspondante dans cette fenêtre pour confirmer la suppression des boutons puis cliquez sur Terminer.',
    'ui__client/custom-buttons/custom-button/delete_unknown__description' => 'Supprimez un bouton personnalisé du Panneau Client du client.',
    'ui__client/custom-buttons/custom-button/delete_unknown__short-title' => 'Supprimer',
    'ui__client/custom-buttons/custom-button/delete_unknown__title' => 'Supprimer un bouton personnalisé',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard-title' => 'Supprimer le bouton personnalisé',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard__1_unknown' => 'Sélectionnez un client dont vous voulez supprimer le bouton personnalisé puis cliquez sur Suivant >>.',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard__3_unknown' => 'Choisissez le bouton personnalisé que vous voulez supprimer puis cliquez sur Suivant  >>.',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard__4' => 'Cochez la case sur cet écran pour confirmer la suppression du bouton personnalisé puis cliquez sur Terminer.',

    'ui__client/custom-buttons/custom-button/properties__description' => 'Éditez les propriétés du bouton au niveau du client %1.',
    'ui__client/custom-buttons/custom-button/properties__short-title' => 'Paramètres',
    'ui__client/custom-buttons/custom-button/properties__title' => 'Modifier le bouton personnalisé du client %1',
    'ui__client/custom-buttons/custom-button/properties_new__wizard-title' => 'Ajouter un bouton personnalisé',
    'ui__client/custom-buttons/custom-button/properties_new__wizard__1_unknown' => 'Sélectionnez un client pour lequel vous voulez créer un bouton personnalisé dans le Panneau Client, puis cliquez sur Suivant >>.',
    'ui__client/custom-buttons/custom-button/properties_new__wizard__4_new' => 'Cliquez sur Terminer pour créer le bouton.',
    'ui__client/custom-buttons/custom-button/properties_unknown__description' => 'Changez les propriétés d\'un bouton dans le Panneau Client du client.',
    'ui__client/custom-buttons/custom-button/properties_unknown__short-title' => 'Propriétés',
    'ui__client/custom-buttons/custom-button/properties_unknown__title' => 'Changer les propriétés d\'un bouton dans le Panneau Client du client',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard-title' => 'Changer les propriétés du bouton personnalisé',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard__1_unknown' => 'Sélectionnez un client dont vous voulez modifier le bouton personnalisé puis cliquez sur Suivant >>.',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard__3_unknown' => 'Choisissez quel bouton personnalisé vous voulez modifier puis cliquez sur Suivant >>.',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard__4' => 'Quand vous avez fini d\'éditer les propriétés du bouton, cliquez sur Terminer pour appliquer les modifications et pour quitter l\'assistant.',

    'ui__client/custom-buttons/custom-button/toggle_private__description' => 'Rendre le bouton %1 inaccessible pour vos clients.',
    'ui__client/custom-buttons/custom-button/toggle_private__short-title' => 'Rendre inaccessible pour vos clients',
    'ui__client/custom-buttons/custom-button/toggle_private__title' => 'Rendre le bouton %1 inaccessible pour vos clients',
    'ui__client/custom-buttons/custom-button/toggle_public__description' => 'Permettez aux clients du client de voir le bouton %1.',
    'ui__client/custom-buttons/custom-button/toggle_public__short-title' => 'Rendre accessible pour vos clients',
    'ui__client/custom-buttons/custom-button/toggle_public__title' => 'Permettre aux clients du client de voir le bouton %1',
    'ui__client/custom-buttons/custom-button/toggle_unknown__description' => 'Rendre un bouton personnalisé accessible/inaccessible pour vos clients.',
    'ui__client/custom-buttons/custom-button/toggle_unknown__short-title' => 'Accessible/Inaccessible pour vos clients',
    'ui__client/custom-buttons/custom-button/toggle_unknown__title' => 'Rendre un bouton personnalisé accessible ou inaccessible pour vos clients',
    'ui__client/custom-buttons/custom-button/toggle_unknown__wizard-title' => 'Rendre un bouton personnalisé accessible/inaccessible pour vos clients.',
    'ui__client/custom-buttons/custom-button/toggle_unknown__wizard__1_unknown' => 'Sélectionnez un client dont vous voulez rendre accessible le bouton personnalisé aux utilisateurs du client puis cliquez sur Suivant >>.',
    'ui__client/custom-buttons/custom-button/toggle_unknown__wizard__3_unknown' => 'Choisissez le bouton personnalisé que vous voulez rendre accessible ou inaccessible pour vos clients puis cliquez sur Suivant >>.',

    'ui__client/domain__description' => 'Gérez le domaine %1.',
    'ui__client/domain__disabled-warning' => 'Le domaine %1 est suspendu.',
    'ui__client/domain__none-available' => 'Vous n\'avez aucun domaine.',
    'ui__client/domain__none-available__1' => 'Le compte de %1 n\'a aucun domaine.',
    'ui__client/domain__none-available__2' => 'Le compte de %1 n\'a aucun domaine.',
    'ui__client/domain__short-title' => '%1',
    'ui__client/domain__title' => 'Domaine %1',
    'ui__client/domain_self__description' => 'Gérez votre domaine.',
    'ui__client/domain_self__disabled-warning' => 'Votre domaine est suspendu.',
    'ui__client/domain_self__quick-search' => 'Mes domaines',
    'ui__client/domain_self__short-title' => 'Mon domaine',
    'ui__client/domain_self__title' => 'Mon domaine',

    'ui__client/domain/custom-buttons/custom-button__none-available' => 'Il n\'y a aucun bouton personnalisé situé dans le Panneau Client du client.',
    'ui__client/domain/custom-buttons/custom-button__none-available__1' => 'Le client %1 n\'a aucun bouton personnalisé dans le Panneau Client.',
    'ui__client/domain/custom-buttons/custom-button__none-available__2' => 'Il n\'y a aucun bouton personnalisé pour le domaine %1.',
    'ui__client/domain/custom-buttons/custom-button/delete__description' => 'Supprimez le bouton personnalisé %1.',
    'ui__client/domain/custom-buttons/custom-button/delete__short-title' => 'Supprimer',
    'ui__client/domain/custom-buttons/custom-button/delete__title' => 'Supprimer le bouton personnalisé %1',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__description' => 'Supprimer les boutons personnalisés.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__short-title' => 'Supprimer',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__title' => 'Supprimer les boutons personnalisés',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard-title' => 'Supprimer les boutons personnalisés',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__1_unknown' => 'Sélectionnez le client dont vous voulez supprimer les boutons dans le panneau d\'administration des domaines et cliquez sur Suivant >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__2_unknown' => 'Sélectionnez le domaine dans le panneau d\'administration duquel vous voulez supprimer les boutons et cliquez sur Suivant >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__4_multi' => 'Sélectionnez les boutons personnalisés que vous voulez supprimer puis cliquez sur Suivant >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__5_multi' => 'Cochez les cases adéquates pour confirmer la suppression des boutons puis cliquez sur Terminer pour exécuter l\'action et pour quitter l\'assistant.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__description' => 'Supprimer un bouton personnalisé.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__short-title' => 'Supprimer',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__title' => 'Supprimer un bouton personnalisé',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard-title' => 'Supprimer un bouton personnalisé',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__1_unknown' => 'Sélectionnez le client dont vous voulez supprimer le bouton personnalisé dans le panneau d\'administration des domaines et cliquez sur Suivant >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__2_unknown' => 'Sélectionnez le domaine dans le panneau d\'administration duquel vous voulez supprimer le bouton et cliquez sur Suivant >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__4_unknown' => 'Sélectionnez le bouton personnalisé que vous voulez supprimer puis cliquez sur Suivant >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__5' => 'Cochez la case pour confirmer la suppression du bouton personnalisé puis cliquez sur Terminer pour exécuter l\'action et pour quitter l\'assistant.',

    'ui__client/domain/custom-buttons/custom-button/properties__title' => "Changer les propriétés du bouton personnalisé %1",
    'ui__client/domain/custom-buttons/custom-button/properties__short-title' => "Propriétés",
    'ui__client/domain/custom-buttons/custom-button/properties__description' => "Changez les propriétés du bouton personnalisé %1 dans le Panneau Client.",

    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard-title' => 'Ajouter un bouton',
    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard__1_unknown' => 'Sélectionnez le client dans le Panneau Client duquel vous voulez placer le bouton, puis cliquez sur Suivant >>.',
    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard__2_unknown' => 'Sélectionnez l\'abonnement dans lequel vous voulez modifier les boutons puis cliquez sur Suivant >>.',
    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard__5_new' => 'Cliquez sur Terminer pour créer le bouton et pour quitter l\'assistant.',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__description' => "Changez les propriétés d'un bouton dans le Panneau Client.",
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__short-title' => 'Propriétés',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__title' => 'Changer les propriétés d\'un bouton dans le Panneau Client',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__wizard-title' => 'Éditer les propriétés de boutons',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__wizard__4_unknown' => "Sélectionnez le bouton personnalisé dont vous voulez modifier les paramètres puis cliquez sur Suivant >>.",
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__wizard__5' => 'Quand vous avez fini de modifier les propriétés du bouton, cliquez sur Terminer pour appliquer les changements et pour quitter l\'assistant.',

    'ui__client/domain/custom-buttons/custom-button/toggle_private__description' => 'Rendre le bouton %1 inaccessible pour les utilisateurs de la messagerie sur ce domaine.',
    'ui__client/domain/custom-buttons/custom-button/toggle_private__short-title' => 'Inaccessible pour les utilisateurs de la messagerie',
    'ui__client/domain/custom-buttons/custom-button/toggle_private__title' => 'Rendre le bouton %1 inaccessibles pour les utilisateurs de la messagerie sur ce domaine',
    'ui__client/domain/custom-buttons/custom-button/toggle_public__description' => 'Rendre le bouton %1 visible pour les utilisateurs de la messagerie sur le domaine.',

    'ui__client/domain/custom-buttons/custom-button/toggle_public__short-title' => 'Accessible pour les utilisateurs de messagerie inscrits sur ce domaine',
    'ui__client/domain/custom-buttons/custom-button/toggle_public__title' => 'Rendre le bouton personnalisé %1 visible pour les utilisateurs de la messagerie sur ce domaine',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__description' => 'Rendre un bouton personnalisé accessible ou inaccessible pour d\'autres utilisateurs.',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__short-title' => 'Accessible/Inaccessible pour les autres utilisateurs',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__title' => 'Rendre un bouton personnalisé accessible ou inaccessible pour les utilisateurs de la messagerie',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__wizard-title' => 'Rendre un bouton personnalisé accessible ou inaccessible pour d\'autres utilisateurs',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__wizard__2_unknown' => 'Sélectionnez un domaine sur lequel se trouve le bouton puis cliquez sur Suivant >>.',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__wizard__4_unknown' => 'Choisissez le bouton que vous voulez rendre accessible ou inaccessible pour les autres utilisateurs puis cliquez sur Suivant >>.',

    'ui__client/domain/delete__description' => 'Supprimer le domaine %1.',
    'ui__client/domain/delete__short-title' => 'Supprimer',
    'ui__client/domain/delete__title' => 'Supprimer le domaine %1',
    'ui__client/domain/delete_multi__description' => 'Supprimer les domaines.',

    'ui__client/domain/delete_multi__short-title' => 'Supprimer',
    'ui__client/domain/delete_multi__title' => 'Supprimer les domaines',
    'ui__client/domain/delete_multi__wizard-title' => 'Supprimer les domaines',
    'ui__client/domain/delete_multi__wizard__2_multi' => 'Sélectionnez les domaines que vous voulez supprimer puis cliquez sur Suivant >>.',
    'ui__client/domain/delete_multi__wizard__3_multi' => 'Confirmez la suppression des domaines en cochant la case, puis cliquez sur Terminer pour exécuter l\'action et quitter l\'assistant.',
    'ui__client/domain/delete_unknown__description' => 'Supprimer un domaine.',
    'ui__client/domain/delete_unknown__short-title' => 'Supprimer',
    'ui__client/domain/delete_unknown__title' => 'Supprimer le domaine',
    'ui__client/domain/delete_unknown__wizard-title' => 'Supprimer un domaine',
    'ui__client/domain/delete_unknown__wizard__2_unknown' => 'Choisissez le domaine que vous voulez supprimer puis cliquez sur Suivant >>.',
    'ui__client/domain/delete_unknown__wizard__3' => 'Cochez la case pour confirmer la suppression du domaine puis cliquez sur Terminer pour exécuter l\'action et pour quitter l\'assistant.',

    'ui__client/domain/hosting__none-available' => 'Il n\'y a aucun domaine avec un hébergement Web configuré. Créez un domaine, puis configurez l\'hébergement Web sur ce domaine pour accéder à ses fonctionnalités.',
    'ui__client/domain/hosting__none-available__1' => 'Ce compte utilisateur n\'a aucun domaine avec un hébergement Web configuré. Configurez l\'hébergement Web sur le domaine requis pour accéder à ses fonctionnalités.',
    'ui__client/domain/hosting__none-available__2' => 'L\'hébergement Web n\'est pas configuré pour le domaine %1. Configurez l\'hébergement Web sur le domaine %1 pour accéder à ses fonctionnalités.',

    'ui__client/domain/hosting/application#list_header__clients_number__title' => "Clients",
    'ui__client/domain/hosting/application#list_header__description__title' => "Description",
    'ui__client/domain/hosting/application#list_header__items_number__title' => "Éléments",
    'ui__client/domain/hosting/application#list_header__name__title' => "Nom",
    'ui__client/domain/hosting/application#list_header__release__title' => "Sortie",
    'ui__client/domain/hosting/application#list_header__sort_by_clients_number__title' => "Trier par client",
    'ui__client/domain/hosting/application#list_header__sort_by_description__title' => "Trier par description",
    'ui__client/domain/hosting/application#list_header__sort_by_items_number__title' => "Trier par éléments",
    'ui__client/domain/hosting/application#list_header__sort_by_name__title' => "Trier par nom",
    'ui__client/domain/hosting/application#list_header__sort_by_release__title' => "Trier par sortie",
    'ui__client/domain/hosting/application#list_header__sort_by_version__title' => "Trier par versions",
    'ui__client/domain/hosting/application#list_header__title' => "Applications Web",
    'ui__client/domain/hosting/application#list_header__version__title' => "Versions",

    'rpt_reseller_section_general' => 'Général',
    'rpt_reseller_section_domains' => 'Domaines',
    'rpt_reseller_section_clients' => 'Clients',
    'statistics__cl_active_domains' => "Domaines actifs",
    'rpt_reseller_cl_domains' => "Domaines",
    'rpt_reseller_cl_subdomains' => "Sous-domaines",
    'by__cl_domains' => "domaines des clients",
    'dom_ctrl__cl_mboxes' => "Boîtes mail",
    'rpt_reseller_cl_redirects' => "Outils de redirection",
    'rpt_reseller_cl_mail_groups' => "Groupes de messagerie",
    'rpt_reseller_cl_mail_resps' => "Réponses automatiques",
    'rpt_reseller_cl_mail_lists' => "Listes de diffusion",
    'rpt_reseller_cl_web_users' => "Utilisateurs Web",
    'rpt_reseller_cl_data_bases' => "Bases de données",

    'statistics__active_clients' => 'Clients avec des abonnements actifs',
    'statistics__clients_active_domains' => 'Domaines actifs',
    'statistics__clients_doms' => 'Domaines',
    'statistics__cl_doms' => 'Domaines',
    '__clients_subdomains' => 'Sous-domaines',
    '__clients_domains' => 'Domaines',
    'dom_ctrl__clients_mboxes' => 'Boîtes mail',
    'dom_ctrl__clients_redir' => 'Outils de redirection',
    'dom_ctrl__clients_mg' => 'Groupes de messagerie',
    'dom_ctrl__clients_resp' => 'Réponses automatiques',
    'dom_ctrl__clients_maillists' => 'Listes de diffusion',
    'dom_ctrl__clients_wu' => 'Utilisateurs Web',
    'dom_ctrl__clients_db' => 'Bases de données',

    'dom_ctrl__cl_redir' => 'Outils de redirection', // to resolve!
    'dom_ctrl__cl_mg' => 'Groupes de messagerie', // to resolve!
    'dom_ctrl__cl_resp' => 'Réponses automatiques', // to resolve!
    'dom_ctrl__cl_maillists' => 'Listes de diffusion', // to resolve!
    'dom_ctrl__cl_wu' => 'Utilisateurs Web', // to resolve!
    'dom_ctrl__cl_db' => 'Bases de données', // to resolve!

    'rpt_cl_section_clients' => 'Clients',

    'rpt_admin_section_general' => 'Général',
    'rpt_admin_section_resellers' => 'Revendeurs',
    'rpt_admin_section_clients' => 'Clients',
    'rpt_admin_section_personal_clients' => 'Clients personnels',
    'rpt_admin_section_domains' => 'Domaines',
    'rpt_admin_section_personal_domains' => 'Domaines personnels',

    'rpt_reseller_section_personal_domains' => 'Domaines personnels',

    'ui__client/domain/toggle_unknown__wizard__2_unknown' => 'Sélectionnez le domaine que vous voulez suspendre ou activer.',
    'ui__client/domain/toggle_unknown__wizard-title' => 'Suspendre ou activer un domaine',

    'ui__client/ip-pool__description' => 'Affectez et désaffectez les adresses IP et les certificats SSL/TLS du client %1.',
    'ui__client/ip-pool__short-title' => 'Pool d\'adresses IP',
    'ui__client/ip-pool__title' => 'Pool d\'IP du client %1',
    'ui__client/ip-pool_self__description' => 'Voir votre pool d\'adresses IP.',
    'ui__client/ip-pool_self__short-title' => 'Pool d\'adresses IP',
    'ui__client/ip-pool_self__title' => 'Mon pool d\'adresses IP',
    'ui__client/ip-pool/properties__description' => 'Configurez le pool d\'IP du client %1.',

    'ui__client/ip-pool/properties__short-title' => 'Pool d\'adresses IP',
    'ui__client/ip-pool/properties__title' => 'Configurer le pool d\'IP du client %1',
    'ui__client/ip-pool/properties_self__description' => 'Voir votre pool d\'adresses IP.',

    'ui__client/ip-pool/properties_self__short-title' => 'Mon pool d\'adresses IP',
    'ui__client/ip-pool/properties_self__title' => 'Mon pool d\'adresses IP',
    'ui__client/ip-pool/properties_unknown__description' => 'Affectez ou désaffectez les adresses IP et les certificats SSL/TLS du client.',
    'ui__client/ip-pool/properties_unknown__short-title' => 'Pool d\'adresses IP',
    'ui__client/ip-pool/properties_unknown__title' => 'Configurer le pool d\'IP du client',
    'ui__client/ip-pool/properties_unknown__wizard-title' => 'Configurer le pool d\'IP du client',
    'ui__client/ip-pool/properties_unknown__wizard__1_unknown' => 'Sélectionnez le client dont vous souhaitez configurer le pool d\'IP.',
    'ui__client/ip-pool/properties_unknown__wizard__3' => 'Quand vous avez fini de configurer le pool d\'adresses IP, cliquez sur Terminer pour appliquer les changements et pour quitter l\'assistant.',


    'ui__client/limits_readonly-unknown__description' => 'Affichez les limites des ressources pour un client.',
    'ui__client/limits_readonly-unknown__short-title' => 'Limites des ressources',
    'ui__client/limits_readonly-unknown__title' => 'Afficher les limites des ressources pour un compte client',
    'ui__client/limits_readonly-unknown__wizard-title' => 'Afficher ou changer les limites des ressources pour un client',

    'ui__client/limits_unknown__wizard-title' => 'Afficher ou changer les limites des ressources pour un client',
    'ui__client/limits_unknown__wizard__1_readonly-unknown' => 'Sélectionnez le client dont vous avez besoin.',
    'ui__client/limits_unknown__wizard__1_unknown' => 'Sélectionnez le client dont vous avez besoin.',
    'ui__client/limits_unknown__wizard__2' => 'Cliquez sur Terminer pour appliquer les changements.',
    'ui__client/limits_unknown__wizard__2_readonly' => 'Cliquez sur Terminer pour quitter l\'assistant.',
    'ui__client/limits_unknown__wizard__2_readonly-self' => 'Cliquez sur Terminer pour quitter l\'assistant.',
    'ui__client/limits_unknown__wizard__2_readonly-self-reseller' => 'Cliquez sur Terminer pour quitter l\'assistant.',

    'ui__client/permissions_unknown__wizard-title' => 'Afficher ou modifier les droits pour un client',
    'ui__client/permissions_unknown__wizard__1/properties_self' => 'Quand vous avez fini de consulter vos droits, cliquez sur Terminer pour appliquer les modifications et pour quitter l\'assistant.',
    'ui__client/permissions_unknown__wizard__1_unknown' => 'Sélectionnez le client dont vous voulez afficher ou changer les droits.',
    'ui__client/permissions_unknown__wizard__2' => 'Une fois les changements apportés aux droits du client effectués, cliquez sur Terminer pour appliquer les changements et quitter l\'assistant.',

    'ui__client/preferences_unknown__wizard-title' => 'Éditer les préférences du client',
    'ui__client/preferences_unknown__wizard__1_unknown' => 'Sélectionnez le client qui contient les préférences de l\'interface et de la session que vous voulez gérer.',
    'ui__client/preferences_unknown__wizard__2' => 'Une fois que les préférences du client sont changées, cliquez sur Terminer.',
    'ui__client/preferences_unknown__wizard__2_self' => 'Une fois que vos préférences sont changées, cliquez sur Terminer.',

    'ui__custom-buttons/custom-button__none-available' => 'Vous n\'avez pas de bouton personnalisé.',
    'ui__custom-buttons/custom-button/delete__description' => 'Supprimez le bouton personnalisé %1.',
    'ui__custom-buttons/custom-button/delete__short-title' => 'Supprimer',
    'ui__custom-buttons/custom-button/delete__title' => 'Supprimer le bouton personnalisé %1',
    'ui__custom-buttons/custom-button/delete_multi__description' => 'Supprimer les boutons personnalisés.',

    'ui__custom-buttons/custom-button/delete_multi__short-title' => 'Supprimer',
    'ui__custom-buttons/custom-button/delete_multi__title' => 'Supprimer les boutons personnalisés',
    'ui__custom-buttons/custom-button/delete_multi__wizard-title' => 'Supprimer les boutons personnalisés',
    'ui__custom-buttons/custom-button/delete_multi__wizard__2_multi' => 'Sélectionnez les boutons que vous voulez supprimer.',
    'ui__custom-buttons/custom-button/delete_multi__wizard__3_multi' => 'Cochez la case pour confirmer la suppression des boutons puis cliquez sur Terminer pour quitter l\'assistant.',
    'ui__custom-buttons/custom-button/delete_unknown__description' => 'Supprimer les boutons personnalisés.',
    'ui__custom-buttons/custom-button/delete_unknown__short-title' => 'Supprimer',
    'ui__custom-buttons/custom-button/delete_unknown__title' => 'Supprimer les boutons personnalisés',
    'ui__custom-buttons/custom-button/delete_unknown__wizard-title' => 'Supprimer les boutons personnalisés',
    'ui__custom-buttons/custom-button/delete_unknown__wizard__2_unknown' => 'Sélectionnez le bouton personnalisé que vous voulez supprimer.',
    'ui__custom-buttons/custom-button/delete_unknown__wizard__3' => 'Cochez la case pour confirmer la suppression du bouton puis cliquez sur Terminer pour quitter l\'assistant.',
    'ui__custom-buttons/custom-button/properties__description' => 'Éditer les propriétés du bouton %1.',

    'ui__custom-buttons/custom-button/properties__short-title' => 'Propriétés',
    'ui__custom-buttons/custom-button/properties__title' => 'Éditer les propriétés du bouton %1',

    'ui__custom-buttons/custom-button/properties_new__wizard-title' => 'Créer un bouton',
    'ui__custom-buttons/custom-button/properties_new__wizard__3_new' => 'Cliquez sur Terminer pour créer le bouton.',
    'ui__custom-buttons/custom-button/properties_unknown__description' => 'Éditer les propriétés d\'un bouton personnalisé.',
    'ui__custom-buttons/custom-button/properties_unknown__short-title' => 'Propriétés',
    'ui__custom-buttons/custom-button/properties_unknown__title' => 'Éditer les propriétés d\'un bouton personnalisé',
    'ui__custom-buttons/custom-button/properties_unknown__wizard-title' => 'Éditer les propriétés d\'un bouton personnalisé',
    'ui__custom-buttons/custom-button/properties_unknown__wizard__2_unknown' => 'Sélectionnez le bouton personnalisé dont vous voulez modifier les propriétés.',
    'ui__custom-buttons/custom-button/properties_unknown__wizard__3' => 'Cliquez sur Terminer pour appliquer les changements.',
    'ui__custom-buttons/custom-button/toggle_private__description' => 'Rendre le bouton personnalisé %1 inaccessible pour d\'autres utilisateurs.',

    'ui__custom-buttons/custom-button/toggle_private__short-title' => 'Inaccessible pour les autres utilisateurs',
    'ui__custom-buttons/custom-button/toggle_private__title' => 'Rendre le bouton personnalisé %1 inaccessible pour d\'autres utilisateurs',
    'ui__custom-buttons/custom-button/toggle_public__description' => 'Rendre le bouton personnalisé %1 accessible pour d\'autres utilisateurs.',

    'ui__custom-buttons/custom-button/toggle_public__short-title' => 'Accessible pour les autres utilisateurs',
    'ui__custom-buttons/custom-button/toggle_public__title' => 'Rendre le bouton personnalisé %1 accessible pour d\'autres utilisateurs',
    'ui__custom-buttons/custom-button/toggle_unknown__description' => 'Rendre le bouton personnalisé accessible ou inaccessible pour d\'autres utilisateurs.',
    'ui__custom-buttons/custom-button/toggle_unknown__short-title' => 'Accessible(s) ou inaccessible(s) pour les autres utilisateurs',
    'ui__custom-buttons/custom-button/toggle_unknown__title' => 'Rendre le bouton personnalisé accessible ou inaccessible pour d\'autres utilisateurs',
    'ui__custom-buttons/custom-button/toggle_unknown__wizard-title' => 'Rendre le bouton personnalisé accessible ou inaccessible pour d\'autres utilisateurs',
    'ui__custom-buttons/custom-button/toggle_unknown__wizard__2_unknown' => 'Sélectionnez le bouton personnalisé que vous voulez rendre accessible ou inaccessible pour les autres utilisateurs puis cliquez sur Suivant >>.',

    'ui__longtasks#list_header__name__title' => "Nom",
    'ui__longtasks#list_header__owner__title' => "Propriétaire",
    'ui__longtasks#list_header__start_time__title' => "Date et heure de création",
    'ui__longtasks#list_header__status__title' => "Statut",
    'ui__longtasks#list_header__title' => "Tâches",
    'ui__longtasks#list_header__finish_time__title' => "Durée d'exécution",
    'ui__longtasks#task_list_legend__title' => "Tâches",
    'ui__longtasks#tools_legend__title' => "Outils",
    'ui__longtasks__description' => "Gérer les tâches en arrière-plan",
    'ui__longtasks__short-title' => "Tâches en arrière-plan",
    'ui__longtasks__title' => "Tâches en arrière-plan",
    'ui__longtasks/longtask/properties#current_operation__title' => "Opération en cours :",
    'ui__longtasks/longtask/properties#finish_time__title' => "Temps estimé pour la réalisation :",
    'ui__longtasks/longtask/properties#general_legend__title' => "Général",
    'ui__longtasks/longtask/properties#owner__title' => "Tâche lancée par :",
    'ui__longtasks/longtask/properties#progress__title' => "Progression globale :",
    'ui__longtasks/longtask/properties#start_time__title' => "Tâche lancée à :",
    'ui__longtasks/longtask/properties#status_legend__title' => "Statut de la tâche",
    'ui__longtasks/longtask/properties__description' => "Informations sur la tâche en arrière-plan et sur son statut",

    'ui__longtasks/properties__description' => "Paramètres des tâches en arrière-plan",
    'ui__longtasks/properties__short-title' => "Paramètres",
    'ui__longtasks/properties__title' => "Tâches en arrière-plan",

    'ui__news/dismiss__description' => 'Cliquez pour fermer le cadre des actualités. Plesk n\'affichera pas ce cadre tant que les articles d\'actualités ne seront pas mis à jour.',

    'ui__news/dismiss__title' => 'Fermer les News',

    'ui__server__description' => 'Gestion du serveur.',
    'ui__server__short-title' => 'Gérer votre serveur',
    'ui__server__title' => 'Gestion du serveur',


    // UNUSED SINCE 9.2



    // END OF UNUSED SINCE 9.2

    'ui__server/ip-address__disabled-warning' => 'L\'adresse IP %1 est indisponible.',
    'ui__server/ip-address__none-available' => 'Il n\'y a aucune adresse IP.',
    'ui__server/ip-addresses/ip-address__title' => "Adresses IP",
    'ui__server/ip-address/client/properties_new__description' => "Affectez l'adresse IP %1 aux revendeurs.",
    'ui__server/ip-address/client/properties_new__short-title' => 'Affecter',
    'ui__server/ip-address/client/properties_new__title' => "Affecter l'adresse IP %1 aux revendeurs",
    'ui__server/ip-address/client__none-available' => 'Il n\'y a aucun compte utilisateur',
    'ui__server/ip-address/client_unknown__quick_search' => 'Utilisateurs',
    'ui__server/ip-address/client_unknown__wizard-title' => 'Liste des utilisateurs qui utilisent cette adresse IP.',
    'ui__server/ip-address/client_unknown__wizard__3_unknown' => 'Veuillez sélectionner l\'adresse IP.',
    'ui__server/ip-address/client/delete__description' => 'Dissociez l\'adresse IP du revendeur.',
    'ui__server/ip-address/client/delete__short-title' => 'Désassocier',
    'ui__server/ip-address/client/delete__title' => 'Dissocier l\'adresse IP du revendeur',
    'ui__server/ip-address/client/delete_multi__description' => "Dissociez l'adresse IP des pools des revendeurs.",

    'ui__server/ip-address/client/delete_multi__short-title' => 'Désassocier',
    'ui__server/ip-address/client/delete_multi__title' => 'Dissocier une adresse IP d\'un revendeur',
    'ui__server/ip-address/client/delete_multi__wizard-title' => "Supprimez l'adresse IP des pools des utilisateurs.",
    'ui__server/ip-address/client/delete_multi__wizard__3_unknown' => 'Sélectionnez l\'adresse IP que vous voulez désassocier des utilisateurs puis cliquez sur Suivant >>.',
    'ui__server/ip-address/client/delete_multi__wizard__3_multi' => 'Sélectionnez les utilisateurs pour lesquels vous voulez désassocier l\'adresse IP puis cliquez sur Suivant >>.',
    'ui__server/ip-address/client/delete_multi__wizard__4_multi' => 'Confirmez la désassociation de l\'adresse IP des utilisateurs en cochant la case puis cliquez sur Terminer pour terminer l\'assistant.',
    'ui__server/ip-address/client/delete_unknown__description' => 'Dissociez une adresse IP des revendeurs.',
    'ui__server/ip-address/client/delete_unknown__short-title' => 'Désassocier',
    'ui__server/ip-address/client/delete_unknown__title' => 'Dissocier une adresse IP des revendeurs',
    'ui__server/ip-address/client/delete_unknown__wizard-title' => 'Désassocier une adresse IP des utilisateurs',
    'ui__server/ip-address/client/delete_unknown__wizard__3_unknown' => 'Sélectionnez l\'adresse IP que vous voulez désassocier des utilisateurs puis cliquez sur Suivant >>.',
    'ui__server/ip-address/client/delete_unknown__wizard__4_unknown' => 'Sélectionnez l\'utilisateur pour lequel vous voulez désassocier l\'adresse IP puis cliquez sur Suivant >>.',
    'ui__server/ip-address/client/delete_unknown__wizard__5' => 'Confirmez la désassociation de l\'adresse IP des utilisateurs en cochant la case puis cliquez sur Terminer pour terminer l\'assistant.',

    'ui__server/ip-address/domain__description' => "Tous les domaines sur l'adresse IP %1.",
    'ui__server/ip-address/domain__short-title' => "Domaines",
    'ui__server/ip-address/domain__title' => "Domaines sur l'adresse IP %1",
    'ui__server/ip-address/domain_unknown__description' => "Tous les domaines sur l'adresse IP.",
    'ui__server/ip-address/domain_unknown__short-title' => "Domaines",
    'ui__server/ip-address/domain_unknown__title' => "Domaines sur l'adresse IP",
    'ui__server/ip-address/domain_unknown__wizard__3_unknown' => "Sélectionnez l'adresse IP qu'il vous faut puis cliquez sur Suivant >>.",

    'ui__server/ip-address/properties__description' => 'Changez les propriétés de l\'adresse IP %1.',
    'ui__server/ip-address/properties__short-title' => 'Propriétés',
    'ui__server/ip-address/properties__title' => 'Changer les propriétés de l\'adresse IP %1',

    'ui__server/ip-address/properties_new__wizard-title' => 'Ajouter une adresse IP',
    'ui__server/ip-address/properties_new__wizard__4_new' => 'Une fois les changements apportés aux propriétés de l\'adresse IP éditées, cliquez sur Terminer pour appliquer les changements.',
    'ui__server/ip-address/properties_unknown__description' => 'Changez les propriétés de l\'adresse IP.',
    'ui__server/ip-address/properties_unknown__short-title' => 'Propriétés',
    'ui__server/ip-address/properties_unknown__title' => 'Changer les propriétés de l\'adresse IP',
    'ui__server/ip-address/properties_unknown__wizard-title' => 'Changer les propriétés de l\'adresse IP',
    'ui__server/ip-address/properties_unknown__wizard__3_unknown' => 'Sélectionnez l\'adresse IP dont vous souhaitez changer les propriétés.',
    'ui__server/ip-address/properties_unknown__wizard__4' => 'Une fois les changements apportés aux propriétés de l\'adresse IP éditées, cliquez sur Terminer pour appliquer les changements.',

    'ui__server/spam-filter/black-list__description' => 'Configurez la liste noire du filtre anti-spam pour tout le serveur.',
    'ui__server/spam-filter/black-list__short-title' => 'Liste noire',
    'ui__server/spam-filter/black-list__title' => 'Liste noire du filtre anti-spam valable pour tout le serveur',

    'ui__server/spam-filter/black-list/address__addresses_available' => 'Ne seront ajoutées que les %1 premières adresses mail uniques.',
    'ui__server/spam-filter/black-list/address__description' => 'Adresse de la liste noire du filtre anti-spam.',

    'ui__server/spam-filter/black-list/address__empty_content' => 'Il n\'y a pas d\'adresse mail dans la liste.',
    'ui__server/spam-filter/black-list/address__file_size' => 'Le fichier envoyé est vide.',
    'ui__server/spam-filter/black-list/address__invalid_addresses' => 'Les adresses mail suivantes sont incorrectes : %1.',
    'ui__server/spam-filter/black-list/address__none-available' => 'Il n\'y a pas d\'adresse dans la liste noire du filtre anti-spam.',
    'ui__server/spam-filter/black-list/address__short-title' => 'Adresse',
    'ui__server/spam-filter/black-list/address__title' => 'Adresse %1 figurant sur la liste noire',
    'ui__server/spam-filter/black-list/address_unknown__description' => 'Ajoutez des adresses à la liste noire.',
    'ui__server/spam-filter/black-list/address_unknown__short-title' => 'Ajouter des adresses',
    'ui__server/spam-filter/black-list/address_unknown__title' => 'Ajouter des adresses à la liste noire',

    'ui__server/spam-filter/black-list/address/delete__description' => 'Supprimez l\'adresse %1 de la liste noire de tout le serveur.',

    'ui__server/spam-filter/black-list/address/delete__short-title' => 'Supprimer',
    'ui__server/spam-filter/black-list/address/delete__title' => 'Supprimer l\'adresse %1 de la liste noire de tout le serveur',
    'ui__server/spam-filter/black-list/address/delete_multi__description' => 'Retirez les adresses de la liste noire valable pour tout le serveur.',

    'ui__server/spam-filter/black-list/address/delete_multi__short-title' => 'Supprimer',
    'ui__server/spam-filter/black-list/address/delete_multi__title' => 'Retirer les adresses de la liste noire valable pour tout le serveur',
    'ui__server/spam-filter/black-list/address/delete_multi__wizard-title' => 'Suppression d\'adresses de la liste noire du filtre anti-spam valable pour tout le serveur',
    'ui__server/spam-filter/black-list/address/delete_multi__wizard__4_multi' => 'Sélectionnez les adresses figurant dans le filtre anti-spam que vous voulez retirer puis cliquez sur Suivant >>',
    'ui__server/spam-filter/black-list/address/delete_multi__wizard__5_multi' => 'Cochez la case pour confirmer le retrait des adresses du filtre anti-spam puis cliquez sur Terminer pour les supprimer définitivement et pour quitter l\'assistant.',
    'ui__server/spam-filter/black-list/address/delete_unknown__description' => 'Supprimez l\'adresse de la liste noire valable pour tout le serveur.',
    'ui__server/spam-filter/black-list/address/delete_unknown__short-title' => 'Supprimer',
    'ui__server/spam-filter/black-list/address/delete_unknown__title' => 'Supprimer l\'adresse de la liste noire valable pour tout le serveur',
    'ui__server/spam-filter/black-list/address/delete_unknown__wizard-title' => 'Suppression d\'adresses de la liste noire du filtre anti-spam valable pour tout le serveur',
    'ui__server/spam-filter/black-list/address/delete_unknown__wizard__4_unknown' => 'Sélectionnez l\'adresse figurant dans le filtre anti-spam que vous voulez retirer puis cliquez sur Suivant >>',
    'ui__server/spam-filter/black-list/address/delete_unknown__wizard__5' => 'Cochez la case pour confirmer le retrait de l\'adresse du filtre anti-spam puis cliquez sur Terminer pour exécuter l\'action et pour quitter l\'assistant.',

    'ui__server/spam-filter/black-list/address/properties__addresses_available' => 'Ne seront ajoutées que les %1 premières adresses mail uniques.',
    'ui__server/spam-filter/black-list/address/properties__empty_content' => 'Il n\'y a pas d\'adresse mail dans la liste.',
    'ui__server/spam-filter/black-list/address/properties__file_size' => 'Impossible d\'envoyer le fichier. La taille maximum du fichier à envoyer est limitée à %1.',
    'ui__server/spam-filter/black-list/address/properties__invalid_addresses' => 'Les adresses mail suivantes sont incorrectes : %1.',

    'ui__server/spam-filter/black-list/address/properties_unknown-new__description' => 'Ajoutez des adresses à la liste noire.',
    'ui__server/spam-filter/black-list/address/properties_unknown-new__short-title' => 'Ajouter des adresses',
    'ui__server/spam-filter/black-list/address/properties_unknown-new__title' => 'Ajouter des adresses à la liste noire',

    'ui__server/spam-filter/properties__description' => 'Configurez le filtre anti-spam valable pour l\'ensemble du serveur.',

    'ui__server/spam-filter/properties__short-title' => 'Paramètres',
    'ui__server/spam-filter/properties__title' => 'Paramètres du filtre anti-spam',

    'ui__server/spam-filter/toggle_disable__description' => 'Désactiver le filtre anti-spam pour tout le système.',

    'ui__server/spam-filter/toggle_disable__short-title' => 'Désactiver',
    'ui__server/spam-filter/toggle_disable__title' => 'Désactiver le filtre anti-spam',
    'ui__server/spam-filter/toggle_enable__description' => 'Activer le filtre anti-spam pour tout le serveur.',

    'ui__server/spam-filter/toggle_enable__short-title' => 'Activer',
    'ui__server/spam-filter/toggle_enable__title' => 'Activer le filtre anti-spam',
    'ui__server/spam-filter/toggle_unknown__description' => 'Activez ou désactivez le filtre anti-spam pour tout le système.',
    'ui__server/spam-filter/toggle_unknown__short-title' => 'Activer ou désactiver',
    'ui__server/spam-filter/toggle_unknown__title' => 'Activer ou désactiver le filtre anti-spam',
    'ui__server/spam-filter/toggle_unknown__wizard-title' => 'Activer ou désactiver un filtre anti-spam',

    'ui__server/spam-filter/white-list__description' => 'Configurez la liste blanche du filtre anti-spam valable pour tout le système.',
    'ui__server/spam-filter/white-list__short-title' => 'Liste blanche',
    'ui__server/spam-filter/white-list__title' => 'Liste blanche du filtre anti-spam valable pour tout le système',

    'ui__server/spam-filter/white-list/address__addresses_available' => 'Ne seront ajoutées que les %1 premières adresses mail uniques.',
    'ui__server/spam-filter/white-list/address__description' => 'Adresse de la liste blanche du filtre anti-spam.',

    'ui__server/spam-filter/white-list/address__empty_content' => 'Il n\'y a pas d\'adresse mail dans la liste.',
    'ui__server/spam-filter/white-list/address__file_size' => 'Le fichier envoyé est vide.',
    'ui__server/spam-filter/white-list/address__invalid_addresses' => 'Les adresses mail suivantes sont incorrectes : %1.',
    'ui__server/spam-filter/white-list/address__none-available' => 'Il n\'y a pas d\'adresse dans la liste blanche du filtre anti-spam valable pour tout le serveur.',
    'ui__server/spam-filter/white-list/address__short-title' => 'Adresse',
    'ui__server/spam-filter/white-list/address__title' => 'Adresse %1 de la liste blanche',
    'ui__server/spam-filter/white-list/address_unknown__description' => 'Ajoutez des adresses à la liste blanche.',
    'ui__server/spam-filter/white-list/address_unknown__short-title' => 'Ajouter des adresses',
    'ui__server/spam-filter/white-list/address_unknown__title' => 'Ajoutez des adresses à la liste blanche.',

    'ui__server/spam-filter/white-list/address/delete__description' => 'Retirer l\'adresse %1 de la liste blanche de tout le serveur.',

    'ui__server/spam-filter/white-list/address/delete__short-title' => 'Supprimer',
    'ui__server/spam-filter/white-list/address/delete__title' => 'Retirer l\'adresse %1 de la liste blanche de tout le serveur',
    'ui__server/spam-filter/white-list/address/delete_multi__description' => 'Supprimez les adresses de la liste blanche valable pour tout le serveur.',

    'ui__server/spam-filter/white-list/address/delete_multi__short-title' => 'Supprimer',
    'ui__server/spam-filter/white-list/address/delete_multi__title' => 'Supprimer les adresses de la liste blanche valable pour tout le serveur',
    'ui__server/spam-filter/white-list/address/delete_multi__wizard-title' => 'Suppression d\'adresses dans la liste blanche du filtre anti-spam valable pour tout le serveur',
    'ui__server/spam-filter/white-list/address/delete_multi__wizard__4_multi' => 'Sélectionnez les adresses figurant dans le filtre anti-spam que vous voulez retirer puis cliquez sur Suivant >>',
    'ui__server/spam-filter/white-list/address/delete_multi__wizard__5_multi' => 'Cochez la case pour confirmer le retrait des adresses du filtre anti-spam puis cliquez sur Terminer pour les supprimer définitivement et pour quitter l\'assistant.',
    'ui__server/spam-filter/white-list/address/delete_unknown__description' => 'Retirer l\'adresse de la liste blanche valable pour tout le serveur.',
    'ui__server/spam-filter/white-list/address/delete_unknown__short-title' => 'Supprimer',
    'ui__server/spam-filter/white-list/address/delete_unknown__title' => 'Retirer l\'adresse de la liste blanche valable pour tout le serveur',
    'ui__server/spam-filter/white-list/address/delete_unknown__wizard-title' => 'Suppression d\'adresses dans la liste blanche du filtre anti-spam valable pour tout le serveur',
    'ui__server/spam-filter/white-list/address/delete_unknown__wizard__4_unknown' => 'Sélectionnez l\'adresse figurant dans le filtre anti-spam que vous voulez retirer puis cliquez sur Suivant >>',
    'ui__server/spam-filter/white-list/address/delete_unknown__wizard__5' => 'Cochez la case pour confirmer le retrait de l\'adresse du filtre anti-spam puis cliquez sur Terminer pour exécuter l\'action et pour quitter l\'assistant.',

    'ui__server/spam-filter/white-list/address/properties__addresses_available' => 'Ne seront ajoutées que les %1 premières adresses mail uniques.',
    'ui__server/spam-filter/white-list/address/properties__empty_content' => 'Il n\'y a pas d\'adresse mail dans la liste.',
    'ui__server/spam-filter/white-list/address/properties__file_size' => 'Impossible d\'envoyer le fichier. La taille maximum du fichier à envoyer est limitée à %1.',
    'ui__server/spam-filter/white-list/address/properties__invalid_addresses' => 'Les adresses mail suivantes sont incorrectes : %1.',

    'ui__server/spam-filter/white-list/address/properties_unknown-new__description' => 'Ajoutez des adresses à la liste blanche.',
    'ui__server/spam-filter/white-list/address/properties_unknown-new__short-title' => 'Ajouter des adresses',
    'ui__server/spam-filter/white-list/address/properties_unknown-new__title' => 'Ajoutez des adresses à la liste blanche.',

    'ui__support#param_company__title' => "Raison sociale",
    'ui__support#param_email__title' => "Adresse mail",
    'ui__support#param_firstname__title' => "Prénom",
    'ui__support#param_keynumber__title' => "Numéro de la clé du produit",
    'ui__support#param_operatingsystem__title' => "Système d'exploitation",
    'ui__support#param_phone__title' => "Téléphone",
    'ui__support#param_psabuild__title' => "Build de Plesk",
    'ui__support#param_psainsttype__title' => "Type d'installation de Plesk",
    'ui__support#param_psaversion__title' => "Version de Plesk",

    // *** The strings above have been generated automatically from @@CAPTION directives.

    ////
    //// UI POINTER CAPTIONS END HERE


    // RESELLERS

    // Resellers
    'ui__reseller#tools__title' => "Outils",

    'ui__reseller/traffic-history_unknown__short-title' => "Voir le trafic par revendeur",
    'ui__reseller/traffic-history_unknown__title' => "Voir le trafic par revendeur",
    'ui__reseller/traffic-history_unknown__description' => "Affichez le trafic par compte revendeur.",
    'ui__reseller#list__title' => "Revendeurs",
    'accounts_list__name__filter_title' => "Nom",
    'accounts_list__resource__filter_title' => "Utilisation des ressources",
    'resellers_list__filter_resource_usage_any' => "Tou(te)s",
    'resellers_list__filter_resource_usage_overuse' => "surutilisation",
    'resellers_list__filter_resource_usage_normal' => "Dans les limites",
    'accounts_list__status__filter_title' => "Statut",
    'resellers_list__filter_status_any' => "Tou(te)s",
    'resellers_list__filter_status_blocked' => "Suspendu",
    'resellers_list__filter_status_active' => "Actif",
    'resellers_list__filter_clients__filter_title' => "Afficher",
    'resellers_list__filter_clients_on' => "Revendeurs avec leurs clients",
    'resellers_list__filter_clients_off' => "Revendeurs uniquement",
    '__disk_usage' => "Espace disque utilisé",
    'ui__reseller/traffic_unknown__short-title' => "Voir le trafic par revendeur",
    'ui__reseller/traffic_unknown__title' => "Voir le trafic par revendeur",
    'ui__reseller/traffic#list__title' => "Trafic par revendeur",
    'ui__reseller/traffic_unknown__description' => "Affichez les rapports d'utilisation du trafic.",

    // Resellers > Traffic by resellers
    '__traffic_by_reseller' => "Trafic par revendeur",

    '__reseller_name' => "Nom du revendeur",
    '__reseller' => "Revendeurs",
    'resellertrafficlist_header' => "Voir le trafic par revendeur",
    '__reseller_personal' => "Trafic utilisé par les domaines du revendeur",
    'ui__reseller/traffic-history__short-title' => "Trafic par revendeur",
    'ui__reseller/traffic-history__title' => "Trafic par revendeur",
    'ui__reseller/traffic-history__description' => "Affichez les rapports d'utilisation du trafic.",

    // Resellers > Create Reseller Account
    'ui__reseller__short-title' => "%1",

    // Resellers > Reseller preferences

    // Resellers > Reseller Account Templates

    // Resellers > Reseller Account Templates > Create Reseller Account Template
    'limits__oversell_text' => "Autoriser la survente",
    'limits__reseller_oversell_description' => "Les ventes supplémentaires permettent au revendeur de vendre plus de ressources que celles actuellement affectées à lui ou elle. Si les ventes supplémentaires sont autorisées, le revendeur est gouverné par l'utilisation actuelle des ressources au lieu de l'affectation initiale des ressources",
    'limits__overuse_block_text' => "Politique de surutilisation",
    'limits__overuse_block_true_text' => "La surutilisation n'est pas autorisée",
    'limits__reseller_overuse_block_true_description' => "Bloquez la surutilisation des ressources. L'utilisation actuelle des ressources ne peut pas dépasser l'affectation initiale des ressources",
    'limits__overuse_block_false_text' => "surutilisation autorisée",
    'limits__reseller_overuse_block_false_description' => "Ne bloquez pas la surutilisation des ressources, permettant au revendeur d'utiliser plus de ressources qu'il n'en a été fournies à l'origine. L'utilisation actuelle des ressources peut dépasser l'affectation initiale des ressources",
    'limits__reseller_overuse_notify_text' => "Notifier le revendeur qu'il a atteint les limites des ressources",
    'reseller_perm__manage_sh_access_disabled' => "Le revendeur ne peut ni autoriser ni interdire l'accès au shell",
    'reseller_perm__manage_sh_access_chrooted' => "Le revendeur ne peut autoriser l'accès qu'à un environnement chrooté",
    'reseller_perm__manage_sh_access_any' => "Le revendeur peut autoriser l'accès à tout type de shell",
    'template__reseller_num_excl_ips' => "Allouer des adresses IP dédiées au revendeur",

    // Reseller's Home page
    'ui__reseller#tools2__title' => "Compte",
    'ui__reseller#info__title' => "Infos",
    'ui__reseller#clientsTab__title' => "Clients",
    'ui__reseller#domainsTab__title' => "Domaines",
    'ui__reseller__title' => "Gérer un compte revendeur de %1",
    'domains__reseller_info' => "%1 clients, %2 domaines, %3 d'espace disque utilisé, %4 de données transférées.",
    'domains__reseller_info_hiding_traffic' => "%1 clients, %2 domaines, %3 d'espace disque utilisé.",
    'ui__reseller__description' => "Gérez un compte revendeur.",

    'ui__reseller/limits_unknown__wizard-title' => 'Afficher ou changer les limites des ressources pour un revendeur',
    'ui__reseller/limits_unknown__wizard__1_unknown' => 'Sélectionnez le revendeur dont vous avez besoin.',
    'ui__reseller/limits_unknown__wizard__2' => 'Cliquez sur Terminer pour appliquer les changements.',

    'ui__client/report_reseller__short-title' => "Rapport",
    'ui__client/report_reseller__title' => "Afficher le rapport du compte",
    'ui__client/report_reseller__description' => "Affichez le rapport du compte revendeur.",
    'ui__client/ip-pool_reseller__short-title' => "Pool d'adresses IP",
    'ui__client/ip-pool_reseller__description' => "Affectez les adresses IP et les certificats SSL/TLS au compte revendeur.",

    //'ui__client/preferences_reseller__short-title' => "Settings",
    //'ui__client/preferences_reseller__description' => "Set Plesk session settings.",

    'ui__reseller/preferences_unknown__wizard__2_self' => "Définissez les paramètres du compte puis cliquez sur Terminer.",

    //'ui__client/permissions_reseller__short-title' => "Permissions",
    //'ui__client/permissions_reseller__description' => "View or change permissions for the reseller's account.",

    'ui__reseller/permissions_unknown__wizard-title' => 'Afficher ou modifier les droits pour un revendeur',
    'ui__reseller/permissions_unknown__wizard__1_unknown' => 'Sélectionnez le revendeur dont vous voulez afficher ou changer les droits.',
    //'ui__reseller/permissions_unknown__wizard__1/properties_self' => 'When done with viewing your permissions, click Finish to to apply the changes and exit the wizard.',
    'ui__reseller/permissions_unknown__wizard__2' => 'Une fois les changements apportés aux droits du revendeur effectués, cliquez sur Terminer pour appliquer les changements et quitter l\'assistant.',

    // Customers > create customer account

    '__resellers_list' => 'Revendeurs',
    'picker_reseller__title' => 'Sélectionner le revendeur',

    // Resellers > reseller name > customer name
    'ui__client#tools1__title' => "Outils",
    'ui__client#tools2__title' => "Compte",
    'ui__client#info__title' => "Infos",
    'ui__client#clientslist__title' => "Clients",
    'ui__client#domainslist__title' => "Domaines",

    // Reseller's session in the Customer Panel - Home page

    'feature__aps_categories__reseller' => "Toutes les applications Web sont maintenant triées par catégories ce qui facilite le choix de l'application qu'il vous faut installer.",
    'feature__domainkeys__reseller' => "Vous pouvez utiliser le mécanisme d'authentification expéditeur de mail DKIM pour réduire le volume de spams et de phishing.",

    '__reseller_form' => "Formulaire du revendeur",

    // Reseller's session in the control panel - Home page > Manage Customer Settings
    'ui__client/preferences_unknown__wizard__reseller' => "Sélectionnez le compte client dont vous voulez changer les paramètres.",

    // Reseller's session in the control panel - Home page > Suspend/Activate Customer Account

    // Reseller's session in the control panel - Home page > Change Customer Limits
    'ui__client/limits_unknown__wizard__1' => "Pour changer les limites d'utilisation des ressources, cliquez sur les limites des ressources.",

    // Reseller's session in the control panel - Home page > Change Customer Permissions
    'ui__client/permissions_unknown__wizard__1' => "Pour modifier les droits liés aux opérations que le client peut exécuter dans Plesk, cliquez sur Droits.",

    // Reseller's session in the control panel - Home page > Create Customer Template
    'template__shared_text' => "Rendre ce template disponible pour les autres utilisateurs",
    'template__shared_description' => "Sélectionnez cette option si vous voulez que vos clients soient capables d'utiliser ce template.",

    // CLIENT (updated for reseller feature):

    // Customers
    'ui__client#tools__title' => 'Outils',

    'ui__client/traffic-history_unknown__short-title' => 'Afficher le trafic par clients',
    'ui__client/traffic-history_unknown__title' => 'Trafic par client',
    'ui__client/traffic-history_unknown__description' => 'Afficher le rapport d\'utilisation du trafic pour tous les clients',
    'ui__client/traffic-history__short-title' => 'Trafic par client',
    'ui__client/traffic-history__title' => 'Afficher le trafic par clients',
    'ui__client/traffic-history__description' => 'Afficher le rapport d\'utilisation du trafic pour tous les clients',

    'ui__client/traffic#list__title' => 'Trafic par clients',
    'ui__reseller/client/traffic#list__title' => 'Trafic par clients',

    'clients_list__filter_type__filter_title' => 'Afficher',
    'clients_list__filter_type_any' => 'Clients et revendeurs',
    'clients_list__filter_type_clients' => 'Clients uniquement',
    'clients_list__filter_type_resellers' => 'Revendeurs uniquement',
    'ui__client/domain_unknown-new__short-title' => "Créer un domaine",

    // Customers > View traffic by customers
    '__personal' => "Trafic utilisé par les domaines de l'utilisateur",
    'PersonalTrafficList_header_of_client__' => "Afficher le rapport d'utilisation du trafic pour votre compte",

    // DOMAINS

    // Domain > Domain Admin Permissions

    'domain_perm__manage_sh_access_disabled' => "L'administrateur de domaines ne peut ni autoriser ni interdire l'accès au shell.",
    'domain_perm__manage_sh_access_chrooted' => "L'administrateur de domaine ne peut autoriser l'accès qu'à un environnement chrooté.",
    'domain_perm__manage_sh_access_any' => "L'administrateur de domaines peut autoriser l'accès à tout type de shell.",

    // APS Catalog
    'bt_add_to_vault' => "Ajouter au référentiel",
    'bt_hide_updates' => "Masquer les mises à jour disponibles",
    'bt_show_updates' => "Afficher les mises à jour disponibles",

    '__site_apps__applications' => "Applications",
    //search elements
    // Application; Vendor; Packager; Certification level;

    '__site_apps__apps_selected_to_add_to_vault' => "Applications sélectionnées pour être ajoutées au référentiel",
    'site_apps__application_selected' => "Sélectionné",
    'site_apps__currently_in_vault' => "Autres versions déjà dans le référentiel :",
    'site_apps__new_versions' => "Nouvelles versions :",
    'site_apps__patches' => "Patchs :",
    'site_apps__applications_have_been_scheduled_for_adding_to_application_vault' => "Nombre d'applications planifiées à ajouter dans le référentiel : %1",
    'site_apps__applications_downloading_now' => "Les applications suivantes sont maintenant en cours de téléchargement : %1", // temporary workaround string, to be removed later

    'site_apps__package_already_exist_in_vault' => "Déjà dans le référentiel",

    // Server > Action Log
    'bt_skin_edit' => "Éditer la description du skin",
    'limits__oversell_legend' => "Ventes supplémentaires",
    'limitsManager__limit_available_error' => "Impossible d'affecter le total requis de ressources (%%quantity%% %%limitName%%). Seuls %%available%% %%limitName%% sont disponibles.",
    'limitsManager__limit_reserved_error' => "Impossible de définir la limite requise des ressources utilisées (%%quantity%% %%limitName%%) car la nouvelle valeur est inférieure au total des ressources réservées à vos clients ou utilisées par vous-même (%%reserved%% %%limitName%%) .",
    'limitsManager__limit_used_error' => "Impossible de définir la limite requise des ressources utilisées (%%quantity%% %%limitName%%) car la nouvelle valeur est inférieure au total actuel des ressources déjà utilisées par votre compte et vos sites (%%used%% %%limitName%%).",

    'ui__client/domain/traffic#list__title' => "Utilisation de la bande passante par services",

    'ui__client/domain/traffic_unknown-reseller__short-title' => "Afficher le rapport d'utilisation du trafic",
    'ui__client/domain/traffic_unknown-reseller__title' => "Afficher le rapport d'utilisation du trafic",

    'ui__client/domain_new__short-title' => "Créer un domaine",

    'ui__client_reseller__description' => "Gérez le compte revendeur %1.",
    'ui__client_reseller__short-title' => "%1",
    'ui__client_reseller__title' => "Gérer le compte revendeur",

    '__owner_name' => "Nom du propriétaire",
    'domains_list__resource__filter_title' => "Utilisation des ressources",

    // APS CATALOG
    'site_apps__application_catalog_preferences' => "Catalogue d'applications APS",
    'site_apps__applications_have_updates' => "Les versions mises à jour des applications suivantes sont disponibles :\n%1\nPour afficher les mises à jour, veuillez vous assurer que la zone Recherche est visible, cochez la case <b>Afficher les mises à jour uniquement</b> puis recherchez les applications dont vous avez besoin.",
    'site_apps__progress_adding_to_vault' => "Ajouter au référentiel :",
    'site_apps__progress_done_message' => "Progression :",
    'site_apps__progress_applications_left' => "%1 applications sur %2 restantes",
    'site_apps__download_item_long_task_title' => "Télécharger l'application APS (%1)",
    'site_apps__download_transaction_long_task_title' => "Télécharger les applications APS à partir du catalogue APS",
    'site_apps__last_check_for_updates' => "Dernière vérification pour les mises à jour : %1",
    'site_apps__all_sucessfully_added_to_app_vault' => "Toutes les applications sont bien ajoutées au référentiel d'applications.",
    'site_apps__number_of_apps_sucessfully_added_to_app_vault' => "%1 des applications planifiées ont bien été ajoutées au référentiel d'applications.",
    'site_apps__no_search_results' => 'Aucune application trouvée. Essayez différentes recherches ou parcourez les applications par catégories.',
    'site_apps__search_results_title' => 'Résultats de la recherche',
    '__site_apps__search_by_application' => 'Nom de l\'application',
    '__site_apps__search_by_vendor' => 'Vendeur',
    '__site_apps__search_by_vendor__all' => 'Tous les vendeurs',
    '__site_apps__search_by_packager' => 'Packager',
    '__site_apps__search_by_certification_level' => 'Niveau de certification',
    '__site_apps__search_by_cert__any' => 'Tou(te)s',
    '__site_apps__search_by_cert__silver_and_higher' => 'Silver et plus',
    '__site_apps__search_by_cert__gold_and_higher' => 'Gold et plus',
    '__retry' => 'Réessayer',
    'site_apps__application_packager_site' => 'Packager',
    'site_apps__add_to_pool_message' => "Les applications marquées comme \"disponibles pour tous\" sont automatiquement distribuées à tous les revendeurs et clients avec un nombre illimité d'installations. Les applications limitées sont distribuées manuellement à tous les revendeurs et clients sur une base individuelle avec un nombre explicite d'installations disponibles.",
    'site_apps__make_available_for_all' => "Rendre les applications sélectionnées disponibles pour tous les utilisateurs",

    'site_apps__broadcast_app_text' => "Les applications marquées comme \"disponibles pour tous\" sont automatiquement distribuées à tous les revendeurs et clients avec un nombre illimité d'installations. Les applications limitées sont distribuées manuellement à tous les revendeurs et clients sur une base individuelle avec un nombre explicite d'installations disponibles.",
    'site_apps__broadcast_app_name' => 'Rendre les application disponibles à tous les utilisateurs',

    // User Application Pool per application
    'site_apps__available_clients' => 'Utilisateurs disponibles',
    'site_apps__no_more_clients_to_add_to_pool' => 'Il n\'y a plus de compte d\'utilisateur que vous pouvez fournir à cette application',

    // Installed application instances
    'site_apps__installations' => 'Installations',

    // Hosting setup redesign
    '__domain_name_and_ip_address' => "Nom de domaine et adresse IP",
    '__assign_ip_address' => "Affecter l'adresse IP",
    '__switch_on_service' => "Activer le service",
    '__hosting_configuration' => "Configuration de l'hébergement",
    '__vrt_hst' => "Hébergement du site Web",
    '__vrt_hst_hint' => "Hébergez un site Web sur ce serveur.",
    '__fwd' => "Redirection",
    '__web_hosting_settings' => "Paramètres d'hébergement",
    '__fwd_hint' => "Redirigez les visiteurs vers un autre site Web.",
    '__none_hint' => "Ne pas héberger de site Web pour le moment.",
    '__login_hint' => "Ce nom d'utilisateur est utilisé pour accéder à votre site Web via FTP.",
    '__password_hint' => "Ce mot de passe est utilisé pour accéder à votre site Web via FTP.",
    '__advanced_hosting_setup' => "Configurer les paramètres avancés de l'hébergement du site Web",
    '__domain_creation_successful' => "Le domaine a été créé.",
    'bt_hosting_settings' => "Paramètres d'hébergement",
    '__change_hosting_type' => "Changer le type d'hébergement du domaine %1",
    '__hosting_type_change_warning' => "Si vous changez la redirection du type d'hébergement, tous les fichiers et répertoires liés à votre site sont supprimés du serveur. Assurez-vous d'enregistrer une copie locale de votre site.",
    '__current_hosting_type' => "Type d'hébergement actuel",
    '__new_hosting_type' => "Nouveau type d'hébergement",
    '__fwd_settings' => "Paramètres de redirection",
    '__fwd_settings_legend' => "Paramètres de redirection",
    '__fwd_destination_url' => "URL de destination",
    '__fwd_type' => "Type de redirection",
    '__fwd_type_standart' => "Redirection standard",
    '__fwd_type_standart_hint' => "Redirigez les visiteurs du site Web vers un autre site et indiquez-leur l'adresse de destination. Ils doivent être informés de la redirection.",
    '__fwd_type_frame' => "Redirection par cadre",
    '__fwd_type_frame_hint' => "Redirigez les visiteurs du site Web vers un autre site mais ne leur indiquez pas l'adresse de destination. Ils ne doivent rien savoir de la redirection.",
    '__hosting_type_template_warning' => "Le type d'hébergement sélectionné est différent du type indiqué dans le template. Si vous continuez, les paramètres d'hébergement Web dans le template sélectionné seront ignorés. Voulez-vous vraiment définir le type d'hébergement sélectionné ?",

    '__no_resellers_selected' => "Vous devez sélectionner au moins un compte revendeur.",

    'ui__client/logo_unknown__wizard-title' => 'Paramétrer le logo',
    'ui__client/logo_unknown__wizard__1_unknown' => 'Veuillez sélectionner le client dont vous voulez changer les propriétés du logo.',
    'ui__client/logo_unknown__wizard__2' => 'Cliquez sur Terminer pour appliquer les changements.',
    'ui__client/logo_unknown__wizard__2_self' => 'Cliquez sur Terminer pour appliquer les changements.',

    'ui__client/ipaddress/properties_new__short-title' => "Ajouter une adresse IP",
    'ui__client/ipaddress/properties_new__title' => 'Ajouter une adresse IP',
    'ui__client/ipaddress/properties_new__description' => "Ajoutez une adresse IP.",
    'ui__client/ipaddress/properties_unknown-new__short-title' => "Ajouter une adresse IP",
    'ui__client/ipaddress/properties_unknown-new__title' => "Ajouter une adresse IP",
    'ui__client/ipaddress/properties_unknown-new__description' => "Ajouter une adresse IP",
    'ui__client/ipaddress/delete_multi__short-title' => "Supprimer une adresse IP",
    'ui__client/ipaddress/delete_multi__description' => "Supprimer des adresses IP",
    'ippool_Manager__no_available_ips' => "Il n'y a aucune adresse IP vacante dans le pool d'IP.",
    'ippool_Manager__ip_shared' => "partagée",
    'ippool_Manager__ip_exclusive' => "dédiée",
    'ui__client/ipaddress/properties__title' => "Gérer les adresses IP",
    'ui__client/ipaddress/properties__description' => "Affichez ou changez les propriétés de l'adresse IP.",
    'ui__client/ipaddress_unknown-new__title' => "Ajouter une adresse IP",
    'ui__client/ipaddress_unknown-new__short-title' => "Ajouter une adresse IP",
    'ui__client/ipaddress_unknown-new__description' => "Ajoutez des adresses IP.",

    'ui__mass-mail#to_resellers_text__title' => "Revendeurs",
    'ui__mass-mail#to_domainusers_text__title' => "Administrateurs de domaines",
    'ui__mass-email#tools_legend__title' => "Outils",
    'ui__mass-email#list_legend__title' => 'Templates de mails de publipostage',
    'ui__mass-email#template_legend__title' => "Modèle",
    'ui__mass-email#from_email_text__title' => "Du",
    'ui__mass-email#to_text__title' => 'A',
    'ui__mass-email#to_resellers_text__title' => "Revendeurs",
    'ui__mass-email#to_clients_text__title' => "Clients",
    'ui__mass-email#to_domainusers_text__title' => "Administrateurs de domaines",
    'ui__mass-email#to_admin_text__title' => "Administrateur Plesk",
    'ui__mass-email#option_mode_all__title' => "Tout",
    'ui__mass-email#option_mode_select__title' => "Sélection uniquement",
    'ui__mass-email#option_mode_except__title' => "Tout sauf la sélection",
    'ui__mass-email#option_select_template__title' => '---Sélectionner un template---',
    'ui__mass-email#subject_text__title' => "Sujet",
    'ui__mass-email#body_text__title' => "Texte du message",
    'ui__mass-email#save_as_legend__title' => "Enregistrer en tant que template",
    'ui__mass-email#save_as_text__title' => "Enregistrer le message rédigé sous un nouveau template intitulé",
    'ui__reseller/preferences_unknown__wizard-title' => "Changer les paramètres du compte",
    'ui__reseller/preferences_unknown__wizard__1_unknown' => "Sélectionnez le revendeur dont vous voulez modifier les paramètres du compte puis cliquez sur Suivant.",
    'ui__reseller/preferences_unknown__wizard__2' => "Définissez les paramètres du compte puis cliquez sur OK.",
    'ippoolManager__ip_shared' => "partagée",
    'ippoolManager__ip_exclusive' => "dédiée",

    '__users_list' => "Utilisateurs",
    '__users' => "Utilisateurs",
    '__user_name' => "Nom de l'utilisateur",

    'limit__name_max_dom_aliases' => "alias de domaines",
    'limit__name_max_subftp_users' => "Comptes FTP supplémentaires",
    'limit__name_max_mssql_db' => "Bases de données Microsoft SQL Server",
    'limit__name_max_iis_app_pools' => "Pools d'applications IIS",
    'limit__name_max_odbc' => "Connexions ODBC",
    'total_mboxes_quota_unsupported' => 'non pris en charge par le serveur de messagerie',
    'limit_soft__disk_space' => 'Notifier lorsque la limite de l\'espace disque est atteinte',
    'limit_soft__max_traffic' => 'Notifier lorsque la limite du trafic est atteinte',
    'limitsManager__commit_failed' => "Impossible de changer les limites des ressources.",
    'limitsManager__date_in_past' => "Date d'expiration incorrecte %1.",
    'limitsManager__limit_not_supported' => "Impossible de définir le type de ressource %1.",
    'limitsManager__limit_oversell_inconsistency' => "Impossible d'affecter les sommes indiquées de ressources avec les ventes supplémentaires désactivées.",
    'limitsManager__limit_overuse_inconsistency' => "Les ressources utilisées dépassent les limites définies.",
    'limitsManager__no_resource_available' => "Aucune ressource de ce type (%%limitName%%) n'est disponible. Requis : %%quantity%%; Disponible : %%unused%%.",
    'limitsManager__no_total_resource_available' => "Aucune ressource de ce type (%%limitName%%) n'est disponible chez votre fournisseur de services. Requis : %%quantity%%; Disponible : %%unused%%.",
    'limitsManager__invalid_expiration_limit' => "La date d'expiration doit être inférieure ou égale à %1.",
    'limitsManager__invalid_disk_space_limit' => "Le total d'espace disque doit être inférieur ou égal à %1.",
    'limitsManager__invalid_max_traffic_limit' => "Le total du trafic doit être inférieur ou égal à %1.",
    'ippoolManager__ip_has_suballocations' => "Impossible de changer le type d'adresse IP déjà alloué à un utilisateur. L'adresse IP %%ip%% est déjà affectée à un ou à plusieurs utilisateurs en tant qu'adresse IP %%reserved%%.",
    'ippoolManager__ip_is_already_in_pool' => "Cette adresse IP exclusive est déjà affectée à l'utilisateur.",
    'ippoolManager__ip_is_not_in_pool' => "Il n'y a aucune adresse IP %%ip%% dans le pool.",
    'ippoolManager__can_not_allocate_ip' => "L'adresse IP %%ip%% est disponible uniquement en tant que %%available%%.",
    'ippoolManager__unable_to_set_default_type' => "Cette adresse IP %%ip%% ne peut pas être affectée comme étant dédiée.",
    'ippoolManager__ip_used_by_hst_or_frw' => "Cette adresse IP %%ip%% est déjà utilisée pour l'hébergement.",
    'ippoolManager__active_anon_ftp_on_ip' => "L'accès FTP anonyme est déjà activé pour l'adresse IP %%ip%%",
    'ippoolManager__no_vacant_ips' => "Il n'y a aucune adresse IP vacante.",
    'ippoolManager__no_available_ips' => "Il n'y a aucune adresse IP disponible.",
    'templates__dublicate_name' => "Un template portant ce nom existe déjà. Veuillez sélectionner un autre nom pour ce template.",
    'cl_perm__client_limits_exceeded' => "Les valeurs de la limite des ressources spécifiées dépassent les valeurs autorisées par votre pack d'hébergement ou ces valeurs offrent moins de ressources que celles actuellement utilisées par vos sites.",
    'cl_perm__reseller_limits_exceeded' => "Les valeurs de la limite des ressources spécifiées dépassent les valeurs autorisées par votre pack d'hébergement ou ces valeurs offrent moins de ressources que celles actuellement utilisées par les comptes utilisateur et sites.",

    'site_apps__preferences_show_all_versions_title' => "Afficher la liste complète des versions pour chaque application récupérée depuis le catalogue",
    'site_apps__preferences_show_all_versions_hint' => "Si cette option est sélectionnée, cela peut prendre un temps considérable pour récupérer toutes les versions de chaque application à chaque fois que vous ouvrez le catalogue. Si cette option n'est pas sélectionnée, seules les dernières versions seront affichées.",
    '__select_user_template' => "Créer un compte utilisateur basé sur un template",
    'ip_already_added_to_all_clients' => "Cette adresse IP exclusive est déjà affectée à tous les utilisateurs.",
    'ui__server/ip-address/client/delete#legend__description' => "Les adresses IP suivantes seront supprimées du système et des pools d'IP des utilisateurs :",

    'site_apps__cancelled_apps' => "Vous avez annulé l'ajout des applications suivantes : %2",

    'sb_url_is_not_resolved' => 'Impossible de résoudre l\'URL : vérifiez vos paramètres DNS. L\'URL %1 doit être résolue en adresse IP du serveur sur lequel Presence Builder installé.',

    'ip_addr__is_last_on_interface' => 'Impossible de supprimer l\'adresse IP %%ip%% car c\'est la dernière adresse IP présente sur l\'interface réseau.',
    'ip_addr__used_for_current_session' => 'Impossible de supprimer l\'adresse IP %%ip%% car  elle est utilisée par une session active',
    'ip_addr__used_for_hosting' => 'Impossible de supprimer l\'adresse IP %%ip%%, car elle est utilisée pour héberger un site Web',
    'ip_addr__is_main' => 'Impossible de supprimer l\'adresse IP %%ip%% car c\'est l\'adresse IP primaire d\'une interface réseau.',
    'ip_addr__ip_used_by_message_submission' => 'Impossible de supprimer l\'adresse IP %%ip%% car  elle est utilisée pour soumettre le mail',

    // RESELLER ACTION LOG

    '__cl_domains' => 'domaines des clients',
    'excl_ip_num' => 'Adresse IP dédiée',

    'sb_err_sitebuilder_not_installed' => 'Presence Builder n\'est pas installé.',

    '__perm_allow_oversell_can_not_be_revoked' => 'Le droit de permet les ventes supplémentaires ne peut pas être retiré de l\'utilisateur car ce dernier a déjà alloué plus de ressources que disponibles, ce qui le fait passer en mode de ventes supplémentaires.',
    'limitsManager__invalid_limit_value' => 'Une valeur incorrecte %%value%% a été indiquée pour la limite %%limit_name%%',
    'limit__max_mn' => 'Nombre max. de comptes mail',

    'limits__client_overuse_description' => 'La politique de surutilisation indique à Plesk la procédure à suivre lorsque l\'utilisation des ressources dépasse l\'allocation initiale des ressources.',
    'limits__client_overuse_block_true_description' => 'Bloquez la surutilisation des ressources. L\'utilisation actuelle des ressources ne peut pas dépasser l\'affectation initiale des ressources',
    'limits__client_overuse_block_false_description' => 'Ne bloquez pas la surutilisation des ressources, permettant au client d\'utiliser plus de ressources qu\'il n\'en a été fournies à l\'origine. L\'utilisation actuelle des ressources peut dépasser l\'affectation initiale des ressources',
    'limits__client_overuse_notify_text' => 'Notifier le client quant aux limites des ressources atteintes',

    'limits__domain_overuse_description' => 'La politique de surutilisation indique à Plesk la procédure à suivre lorsque l\'utilisation des ressources dépasse l\'allocation initiale des ressources.',
    'limits__domain_overuse_block_true_description' => 'La politique de surutilisation indique à Plesk la procédure à suivre lorsque les ressources sont surutilisées.',
    'limits__domain_overuse_block_false_description' => 'Ne bloquez pas la surutilisation des ressources, permettant au domaine t d\'utiliser plus de ressources qu\'il n\'en a été fournies à l\'origine. L\'utilisation actuelle des ressources peut dépasser l\'affectation initiale des ressources',
    'limits__domain_overuse_notify_text' => 'Notifier le propriétaire de domaines qu\'il a atteint les limites des ressources',

    'dns__dns_rr_delete' => 'Éléments qui seront supprimés',
    'dns__delete_rr' => 'Les enregistrements DNS suivants seront supprimés de la zone DNS :',
    'dns__dns_rr_delete_non_removable' => 'Éléments qui ne peuvent pas être supprimés',
    'dns__non_delete_rr' => 'Impossible de supprimer les enregistrements DNS suivants :',
    'dns__dns_rr_delete_confirm_message' => 'Confirmer la suppression des enregistrements DNS',

    'site_apps__format_is_unsupported_broadcast_not_set' => 'Format de l\'application Web inconnu : l\'application Web doit être certainement indisponible pour l\'installation et l\'utilisation.',

    '__php_handler_type_desc' => 'Exécuter PHP comme',
    'sfdk_domain_sign__failed' => 'Une erreur non identifiée s\'est produite en essayant d\'activer la signature de la messagerie avec DKIM sur le domaine. Consultez le log d\'erreurs du serveur pour en savoir plus.',

    // key management ported from cpp to php
    'pkey_notify__subj_update_success_notification' => 'Notification de réussite de la mise à jour de la clé Plesk',
    'pkey_notify__subj_update_deferral_notification' => 'Notification d\'ajournement de la mise à jour de la clé Plesk',
    'pkey_notify__subj_update_error_notification' => 'Notification d\'erreur de la mise à jour de la clé Plesk',
    'pkey_notify__update_successful' => 'La mise à jour de%1 est bien terminée.',
    'pkey_notify__update_failed_no_more_try' => 'Impossible de mettre à jour %1. La clé que vous essayez d\'envoyer est incorrecte. Vous ne devez plus essayer de mettre à jour cette clé.',
    'pkey_notify__update_failed_try_later' => 'Impossible de mettre à jour %1 : une erreur s\'est produite pendant le traitement de votre clé. Vous pouvez essayer de récupérer manuellement la clé dans Plesk (sous : Outils & Paramètres > Informations sur la licence) ou laisser Plesk exécuter la mise à jour dans les prochaines 24 heures. Si vous ne voulez plus recevoir cette notification, retirez cette clé de Plesk.',

    // spam assassin error messages
    'ui__server/spam-filter/toggle__unable_disable' => 'Impossible de désactiver le filtre anti-spam valable pour tout le serveur.',
    'ui__server/spam-filter/toggle__unable_enable' => 'Impossible d\'activer le filtre anti-spam valable pour tout le serveur',

    // Application vault/ application pool for admin mapping - TEMPORARY

    'rpt_reseller_section_full_domains' => 'Domaines',
    'rpt_reseller_dom_subdomains' => 'Sousdom',
    'rpt_reseller_dom_domain_aliases' => 'AliasDom',
    'rpt_reseller_dom_postboxes' => 'BLettr',
    'rpt_reseller_dom_redirects' => 'Outils de redirection',
    'rpt_reseller_dom_mail_groups' => 'GrpMess',
    'rpt_reseller_dom_mail_resps' => 'RépAuto',
    'rpt_reseller_dom_mail_antispam' => 'Anti-spam',
    'rpt_reseller_dom_mail_antivirus' => 'Antivirus',
    'rpt_reseller_dom_mail_lists' => 'ListDiff',
    'rpt_reseller_dom_web_users' => 'UtilW',
    'rpt_reseller_dom_data_bases' => 'BDMySQL',
    'rpt_reseller_dom_mssql_data_bases' => 'DBMSSQL',

    'rpt_reseller_section_full_clients' => 'Clients',
    '__cl_name' => 'Nom du client',
    '__cl_creation_date' => 'Date de création',
    '__clients_traffic' => 'Trafic du client',
    'rpt_reseller_cl_mail_antispam' => 'Anti-spam',
    'rpt_reseller_cl_mail_antivirus' => 'Antivirus',

    // CONHELPS FOR HOME PAGE
    // common:
    'sitebuilder_not_installed' => 'Presence Builder n\'est pas installé.',
    'sitebuilder_disabled' => 'Presence Builder est désactivé.',
    'b_sitebuilder_disabled' => 'Presence Builder est désactivé.',
    'webmail_not_installed' => 'Le logiciel de Messagerie Web n\'est pas installé.',
    'webmail_disabled' => 'Le service de messagerie Web est désactivé.',
    'spamassassin_not_installed' => 'SpamAssassin n\'est pas installé.',
    // pfu:
    'anonymous_ftp_shared' => 'Impossible de configurer un FTP anonyme : type d\'adresse IP partagée.',
    'anonymous_ftp_used' => 'Impossible de configurer un FTP anonyme : l\'adresse IP est utilisée par un autre domaine pour le service FTP anonyme.',
    // pfw:
    'aspdotnet_not_installed' => 'ASP.NET n\'est pas installé.',
    'site_builder_no_package' => 'Presence Builder n\'est pas disponible. Vérifiez si Presence Builder est installé et sélectionné comme composant actif.',
    'site_builder_not_configured' => 'Presence Builder n\'est pas configuré.',

    // LIST OF CLIENTS
    // under reseller
    'ui__reseller/client#tools__title' => 'Outils',
    'ui__reseller/client#clientslist__title' => 'Clients',

    //reseller accounts removal

    // NEW HOME PAGE WIZARDS

    // PFW-only

    // COMMON WIZARDS

    'ui__client/domain/hosting/anonymous-ftp_unknown__wizard-title' => 'Configurez un FTP anonyme sur le domaine.',
    'ui__client/domain/hosting/anonymous-ftp_unknown__wizard__2_unknown' => 'Sélectionnez le domaine pour lequel vous voulez configurer un FTP anonyme.',

    'ui__client/domain/hosting/logs_unknown__wizard-title' => 'Configurez le Gestionnaire de journaux pour le domaine et affichez les fichiers journaux du domaine',
    'ui__client/domain/hosting/logs_unknown__wizard__2_unknown' => 'Sélectionnez le domaine avec le Gestionnaire de logs que vous voulez configurer et les fichiers journaux que vous voulez afficher.',

    'ui__client/domain/certificate_unknown__wizard-title' => 'Gérer les certificats SSL/TLS pour le domaine',
    'ui__client/domain/certificate_unknown__wizard__2_unknown' => 'Sélectionnez les domaines avec les certificats SSL/TLS que vous voulez gérer.',

    'ui__client/domain/disable_multi__wizard-title' => 'Suspendre  les domaines',
    'ui__client/domain/disable_multi__wizard__2_multi' => 'Sélectionnez les domaines que vous voulez suspendre.',

    'ui__client/domain/enable_multi__wizard-title' => 'Activer les domaines',
    'ui__client/domain/enable_multi__wizard__2_multi' => 'Sélectionnez les domaines que vous voulez activer.',

    'ui__client/domain_unknown__wizard-title' => 'Afficher les domaines',
    'ui__client/domain_unknown__wizard__1_unknown' => 'Sélectionnez un client avec les domaines que vous voulez afficher.',

    'ui__client/domain/register_unknown__wizard-title' => 'Domaines',
    'ui__client/domain/register_unknown__wizard__2_unknown' => 'Sélectionnez les domaines que vous voulez enregistrer.',

    'ui__client/domain/extras_unknown__wizard-title' => 'Utiliser les outils de MyPlesk.com',
    'ui__client/domain/extras_unknown__wizard__2_unknown' => 'Sélectionnez le domaine que vous voulez gérer avec les outils de MyPlesk.com.',

    // various

    'ui__server/ip-address/client_unknown__short-title' => 'Utilisateurs de l\'adresse IP',
    'ui__server/ip-address/client_unknown__title' => 'Utilisateurs de l\'adresse IP',
    'ui__server/ip-address/client_unknown__description' => 'Utilisateurs de l\'adresse IP %1',

    'disabled_by_admin' => 'Désactivé par l\'administrateur de serveur',






    'ui__client/domain/chowner_multi__short-title' => 'Déclarer un autre propriétaire',
    'ui__client/domain/chowner_multi__title' => 'Changer la propriété de l\'abonnement',
    'ui__client/domain/chowner_multi__description' => 'Changez la propriété de l\'abonnement.',

    'ui__client/domain/chowner_multi__wizard__2_multi' => 'Sélectionnez les domaines dont vous voulez changer le propriétaire puis cliquez sur Suivant >>.',
    'ui__client/domain/chowner_unknown__short-title' => 'Déclarer un autre propriétaire',
    'ui__client/domain/chowner_unknown__title' => 'Changer la propriété de l\'abonnement',
    'ui__client/domain/chowner_unknown__description' => 'Changez la propriété de l\'abonnement.',

    'ui__client/domain/chowner_unknown__wizard-title' => 'Changer la propriété de l\'abonnement',

    //custom buttons reseller home support
    //ui captions
    'ui__reseller/custom-buttons/custom-button__none-available' => 'Il n\'y a pas de bouton personnalisé.',
    'ui__reseller/custom-buttons/custom-button__none-available__1' => 'Il n\'y a aucun bouton personnalisé dans l\'interface du revendeur %1.',

    'ui__reseller/custom-buttons/custom-button/delete__description' => 'Supprimez le bouton %1.',

    'ui__reseller/custom-buttons/custom-button/delete__short-title' => 'Supprimer',
    'ui__reseller/custom-buttons/custom-button/delete__title' => 'Supprimer le bouton %1',
    'ui__reseller/custom-buttons/custom-button/delete_multi__description' => 'Supprimer les boutons personnalisés de l\'interface revendeur',

    'ui__reseller/custom-buttons/custom-button/delete_multi__short-title' => 'Supprimer',
    'ui__reseller/custom-buttons/custom-button/delete_multi__title' => 'Supprimer les boutons personnalisés',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard-title' => 'Supprimer des boutons',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard__1_unknown' => 'Sélectionnez un revendeur dont vous voulez supprimer les boutons personnalisés puis cliquez sur Suivant >>.',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard__3_multi' => 'Sélectionnez les boutons personnalisés que vous voulez supprimer puis cliquez sur Suivant >>.',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard__4_multi' => 'Cochez la case correspondante dans cette fenêtre pour confirmer la suppression des boutons puis cliquez sur Terminer.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__description' => 'Supprimez un bouton personnalisé de l\'interface revendeur.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__short-title' => 'Supprimer',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__title' => 'Supprimer un bouton personnalisé',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard-title' => 'Supprimer le bouton personnalisé',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard__1_unknown' => 'Sélectionnez un revendeur dont vous voulez supprimer le bouton personnalisé puis cliquez sur Suivant >>.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard__3_unknown' => 'Choisissez le bouton personnalisé que vous voulez supprimer puis cliquez sur Suivant  >>.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard__4' => 'Cochez la case sur cet écran pour confirmer la suppression du bouton personnalisé puis cliquez sur Terminer.',

    'ui__reseller/custom-buttons/custom-button/properties__description' => 'Éditez les propriétés du bouton personnalisé au niveau du revendeur %1.',

    'ui__reseller/custom-buttons/custom-button/properties__short-title' => 'Paramètres',
    'ui__reseller/custom-buttons/custom-button/properties__title' => 'Modifier le bouton personnalisé du revendeur %1',

    'ui__reseller/custom-buttons/custom-button/properties_new__wizard-title' => 'Ajouter un bouton personnalisé',
    'ui__reseller/custom-buttons/custom-button/properties_new__wizard__1_unknown' => 'Sélectionnez un revendeur pour lequel vous voulez créer un bouton personnalisé dans l\'interface puis cliquez sur Suivant >>.',
    'ui__reseller/custom-buttons/custom-button/properties_new__wizard__4_new' => 'Cliquez sur Terminer pour créer le bouton.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__description' => 'Changez les propriétés d\'un bouton dans l\'interface du revendeur.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__short-title' => 'Propriétés',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__title' => 'Changer les propriétés d\'un bouton dans l\'interface du revendeur',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard-title' => 'Changer les propriétés du bouton personnalisé',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard__1_unknown' => 'Sélectionnez un revendeur dont vous voulez modifier le bouton personnalisé puis cliquez sur Suivant >>.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard__3_unknown' => 'Choisissez quel bouton personnalisé vous voulez modifier puis cliquez sur Suivant >>.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard__4' => 'Quand vous avez fini d\'éditer les propriétés du bouton, cliquez sur Terminer pour appliquer les modifications et pour quitter l\'assistant.',

    'ui__reseller/custom-buttons/custom-button/toggle_private__description' => 'Rendre le bouton %1 inaccessible pour vos clients.',

    'ui__reseller/custom-buttons/custom-button/toggle_private__short-title' => 'Rendre inaccessible pour vos clients',
    'ui__reseller/custom-buttons/custom-button/toggle_private__title' => 'Rendre le bouton %1 inaccessible pour vos clients',
    'ui__reseller/custom-buttons/custom-button/toggle_public__description' => 'Permettez aux clients du revendeurs de voir le bouton %1.',
    'ui__reseller/custom-buttons/custom-button/toggle_public__short-title' => 'Rendre accessible pour vos clients',
    'ui__reseller/custom-buttons/custom-button/toggle_public__title' => 'Permettre aux clients du revendeurs de voir le bouton %1',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__description' => 'Rendre un bouton personnalisé accessible/inaccessible pour vos clients.',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__short-title' => 'Accessible/Inaccessible pour vos clients',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__title' => 'Rendre un bouton personnalisé accessible ou inaccessible pour vos clients',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__wizard-title' => 'Rendre un bouton personnalisé accessible/inaccessible pour vos clients.',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__wizard__1_unknown' => 'Sélectionnez un revendeur dont vous voulez rendre accessible le bouton personnalisé aux clients du revendeur puis cliquez sur Suivant >>.',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__wizard__3_unknown' => 'Choisissez le bouton personnalisé que vous voulez rendre accessible ou inaccessible pour vos clients puis cliquez sur Suivant >>.',

    '__not_allowed' => 'Non autorisé',

    'ui__client/domain/chowner__wizard__3' => '',
    'ui__client/domain/chowner__wizard__3_select' => 'Sélectionnez le nouveau propriétaire pour ce domaine.',

    '__ip_addr_state_unknown' => "L'adresse IP n'est pas opérationnelle maintenant en raison du système qui continue à traiter votre demande. Veuillez patienter une minute.",


    'resellers_list__accounts' => 'Utilisateurs',

    'ip_addr__repair_is_not_allowed' => 'Impossible de réparer l\'adresse IP sous un environnement Virtuozzo.',

    'ui__reseller/client__none-available__1' => 'Le revendeur %1 n\'a aucun client.',

    'ippoolManager__ip_used_by_nohost_domain' => "L'adresse IP %%ip%% ne peut pas être supprimée, car elle est utilisée par un ou plusieurs domaines sans hébergement.",
    'ippoolManager__ip_used_for_mail_service' => "L'adresse IP %%ip%% ne peut pas être supprimée, car elle est utilisée par au moins un domaine pour l'adresse IP du service de messagerie.",
    'ippoolManager__ip_used_for_send_emails' => "L'adresse IP %%ip%% ne peut pas être supprimée, car elle est utilisée pour envoyer des mails depuis une IP spécifique (voir Paramètres du serveur de messagerie).",
    'ippoolManager__ip_used_in_dns_zone' => 'Impossible de supprimer l\'adresse IP %%ip%% car elle est utilisée par la zone DNS d\'un ou plusieurs domaines.',
    'ip_ctrl__cannot_manage_on_vz' => 'Cette installation de Plesk fonctionne dans les conteneurs Virtuozzo. Les nouvelles adresses IP ne peuvent être ajoutées que par l\'administrateur du node des conteneurs Virtuozzo.',

    'client_template__limits_auto_adjusted' => 'Les limites du template de client ont été automatiquement ajustées.',

    '__entries' => 'Entrées',

    '__path_is_not_set' => 'Le chemin d\'accès n\'est pas indiqué. Veuillez en entrer un correct.',

    'defaultcomponents__imap_required' => '(Le serveur de messagerie actuel ne prend pas en charge IMAP)',

    '__commercial_web_stats_not_installed' => 'Plesk prend en charge uniquement le logiciel des statistiques Web commercial pour le calcul des statistiques du sous-domaine. Aucun logiciel n\'est actuellement installé sur le système.',


    'server_settings_invalid_traffic_statistics' => 'Paramètre de conservation des statistiques du trafic non valide.',
    'server_settings_invalid_logrotate_period' => 'Paramètre de la période de rotation des journaux non valide.',

    'spam_filter/address/file_size' => 'Impossible d\'envoyer le fichier. La taille maximum du fichier à envoyer est limitée à %1.',
    'spam_filter/address/file_empty_content' => 'Il y a eu des problèmes pour lire les adresses e-mail depuis le fichier. Assurez-vous de téléverser un fichier avec un encodage UTF-8 contenant une ou plusieurs adresses e-mail, puis essayez à nouveau.',
    'spam_filter/address/addresses_empty_content' => 'Il n\'y a pas d\'adresse mail dans la liste.',
    'spam_filter/address/addresses_available' => 'Ne seront ajoutées que les %1 premières adresses mail uniques.',
    'spam_filter/address/invalid_addresses' => 'Les adresses mail suivantes sont incorrectes : %1.',

    'current_resources' => 'Ressources actuelles',
    'plan_limitations' => 'Limitations du pack',
    'cannot_switch_plan' => 'Impossible de basculer vers le pack sélectionné, car les ressources actuelles ci-après sont supérieures aux limitations du pack :',
];