<?php
// Copyright 1999-2024. WebPros International GmbH. All rights reserved.
$messages = [
    'access-network.subnetOrIpAddressLabel' => 'Adreça IP o subxarxa',
    'access-network.subnetOrIpAddressHint' => 'Por exemple, 2002:7b7b:7b7b::/48, 2002:7b7b:7b7b::1/48, 2002:7b7b:7b7b::1, 123.123.*.*, 123.123.0.0/16, 123.123.123.123/16, 123.123.123.123/32, 123.123.0.0/255.255.0.0, 123.123.123.123/255.255.0.0, 123.123.123.123/255.255.255.255, 123.123.123.123',

    'admin.announcement-settings.announcementLegend' => 'Newsletters',
    'admin.announcement-settings.getConsentLoading' => 'Recuperant informació sobre els newsletters...',
    'admin.announcement-settings.getConsentWarning' => 'No ha estat possible recuperar l\'estat de la seva subscripció.',
    'admin.announcement-settings.sendAnnounceConsent' => 'Desitjo rebre els newsletters de WebPros. Aquests inclouen informació general sobre el producte, així com informació tècnica i relacionada amb la seguretat. Autoritzo a WebPros a recopilar, processar i utilitzar les meves dades personals (email), incloent el processament transversal conforme a les lleis de protecció de dades aplicables en vigor per a l\'enviament dels newsletters ja sigui de forma directa o a través d\'un servei de tercers. Si no selecciona aquesta casella, es revocarà el meu consentiment, WebPros ja no enviarà emails i procedirà amb l\'eliminació permanent de les meves dades personals dels seus sistemes.',
    'admin.announcement-settings.sendAnnouncePersonalizedConsent' => 'Les companyies de WebPros citades aquí poden fer servir el meu nom i la meva direcció de correu electrònic (%%adminEmail%%) amb l\'objectiu de proporcionar-me contingut publicitari personalitzat, com ara butlletins i ofertes individuals relacionades amb els productes de WebPros. Les companyies que sol·liciten el meu consentiment són les següents: WebPros International LLC i WebPros International GmbH. La informació es farà servir d\'acord amb la %%privacyPolicy%% fins que retiri el meu consentiment, i es podrà compartir de forma interna amb altres entitats pertanyents al grup WebPros. Puc modificar o retirar el meu consentiment en qualsevol moment desmarcant la casella, fent clic a l\'enllaç d\'una de les publicacions que rebo o enviant un correu a emailing privacy@plesk.com',
    'admin.announcement-settings.privacyPolicy' => 'Política de privacitat de WebPros',
    'admin.announcement-settings.noConsent' => 'Cancel·lar la meva subscripció al newsletter de WebPros.',
    'admin.announcement-settings.reportConsentError' => 'No ha estat possible desar la seva configuració per a rebre informació de Plesk: %%error%%.',
    'admin.announcement-settings.profileUpdateError' => 'Ens sap greu, però en aquests moments no podem actualitzar el seu perfil. Torni-ho a provar en uns minuts.',
    'admin.announcement-settings.invalidConsentType' => "Tipus de consentiment desconegut: '%%type%%'",
    'admin.announcement-settings.retry' => 'Tornar a provar',
    'admin.announcement-settings.consentGivenInfo' => 'Esperem que hagi gaudit del nostre newsletter genèric. Ara li podem oferir una alternativa encara millor - personalitzada amb informació i suggeriments útils conforme a les seves necessitats particulars. Per tal de poder rebre el seu newsletter personalitzat, pot seleccionar la primera opció que es mostra a continuació i fer clic a ACCEPTAR.',

    'admin.personal-info.title' => 'Edició del perfil de l\'administrador',
    'admin.personal-info.pleskSettingsSectionLegend' => 'Configuració de Plesk',
    'admin.personal-info.settingsSectionLegend' => 'Configuració',

    'admin-alias.login' => 'Nom d\'usuari',
    'admin-alias.password' => 'Contrasenya',
    'admin-alias.passwordConfirmation' => 'Confirmi la contrasenya',
    'admin-alias.email' => 'Email',
    'admin-alias.contact' => 'Nom de contacte',
    'admin-alias.comments' => 'Comentaris',
    'admin-alias.emptyLogin' => 'Indiqui un nom d\'usuari.',
    'admin-alias.loginTooLong' => 'La longitud del nom d\'usuari és superior a 20 caràcters.',
    'admin-alias.emptyEmail' => 'Proporcioni una adreça de correu.',
    'admin-alias.emptyContactName' => 'Indiqui un nom de contacte.',
    'admin-alias.contactNameTooLong' => 'La longitud del nom de contacte és superior a 255 símbols.',
    'admin-alias.emptyPassword' => 'Indiqui una contrasenya.',
    'admin-alias.commentsTooLong' => 'La longitud del comentari és superior a 255 símbols.',
    'admin-alias.emailActivation' => 'Activar compte per email',
    'admin-alias.simplePanel' => 'Activar el mode restringit',
    'admin-alias.simplePanelHint' => 'Seleccioni aquesta opció si desitja limitar el número d\'accions que pot efectuar l\'administrador addicional a Plesk. Si desitja modificar les accions disponibles, vagi a %%link%%.',
    'admin-alias.simplePanelLink' => 'Eines i configuració> Configuració del mode restringit',
    'admin-alias.lockPowerUser' => 'Forçar el mode de visualització de Power User per l\'administrador addicional',
    'admin-alias.lockPowerUserHint' => 'Restringeixi la visualització a l\'administrador addicional de Plesk (sense accés a clients, revenedors i plans de serveis).',

    'admin-info.plesk-settings.multiplyLogin' => 'Permetre múltiples sessions sota aquest compte',
    'admin-info.plesk-settings.adminLanguage' => 'Idioma de la interfície de l\'administrador',
    'admin-info.plesk-settings.password' => 'Contrasenya',
    'admin-info.plesk-settings.passwordConfirmation' => 'Confirmi la contrasenya',
    'admin-info.plesk-settings.oldPassword' => 'Contrasenya anterior',
    'admin-info.plesk-settings.oldPasswordIsIncorrect' => 'La contrasenya anterior no és correcta. Torni-ho a provar.',

    'admin-panel.form.contact-info.login' => 'Nom d\'usuari',
    'admin-panel.form.contact-info.contactName' => 'Nom de contacte',
    'admin-panel.form.contact-info.emptyLogin' => 'Indiqui un nom d\'usuari.',
    'admin-panel.form.contact-info.emptyContactName' => 'Indiqui un nom de contacte.',
    'admin-panel.form.contact-info.loginTooLong' => 'El nom d\'usuari és massa llarg. La longitud màxima permesa és de %max% símbols.',
    'admin-panel.form.contact-info.contactNameTooLong' => 'El nom de contacte és massa llarg. La longitud màxima permesa és de %max% símbols.',
    'admin-panel.form.contact-info.email' => 'Adreça de correu',
    'admin-panel.form.contact-info.emptyEmail' => 'Proporcioni una adreça de correu.',
    'admin-panel.form.contact-info.companyName' => 'Nom de l\'empresa',
    'admin-panel.form.contact-info.longCompanyName' => 'El nom de l\'empresa és massa llarg. La longitud màxima permesa és de %max% símbols.',
    'admin-panel.form.contact-info.phone' => 'Número de telèfon',
    'admin-panel.form.contact-info.longPhone' => 'Aquest número de telèfon és massa llarg. La longitud màxima permesa és de %max% símbols.',
    'admin-panel.form.contact-info.fax' => 'Número de fax',
    'admin-panel.form.contact-info.imNumber' => 'Missatgeria instantània',
    'admin-panel.form.contact-info.longFax' => 'Aquest número de fax és massa llarg. La longitud màxima permesa és de %max% símbols.',
    'admin-panel.form.contact-info.phoneRegexNotMatch' => 'El número de telèfon indicat no és vàlid.',
    'admin-panel.form.contact-info.faxRegexNotMatch' => 'El número de fax no és correcte.',
    'admin-panel.form.contact-info.address' => 'Adreça',
    'admin-panel.form.contact-info.longAddress' => 'Aquesta adreça és massa llarga. La longitud màxima permesa és de %max% símbols.',
    'admin-panel.form.contact-info.city' => 'Ciutat',
    'admin-panel.form.contact-info.longCity' => 'El nom de la ciutat és massa llarg.',
    'admin-panel.form.contact-info.shortCity' => 'El nom de la ciutat és massa curt.',
    'admin-panel.form.contact-info.state' => 'Província o estat',
    'admin-panel.form.contact-info.postalCode' => 'Codi postal',
    'admin-panel.form.contact-info.country' => 'País',
    'admin-panel.form.contact-info.additionalInfo' => 'Informació addicional',
    'admin-panel.form.contact-info.additionalInfoHint' => 'Només text sense format. S\'ignoraran totes les etiquetes HTML.',
    'admin-panel.form.contact-info.duplicateEmail' => 'Al sistema ja existeix un usuari amb aquesta adreça de correu.',

    'admin-panel.form.domain-info-section.domainInfoSection' => 'Subscripció',
    'admin-panel.form.domain-info-section.domainInfoSectionForCustomerHint' => 'Propietats del lloc web aprovisionat juntament amb la subscripció.',
    'admin-panel.form.domain-info-section.domainInfoSectionForResellerHint' => 'Propietats del lloc web aprovisionat juntament amb la subscripció.',
    'admin-panel.form.domain-info-section.domainInfoSectionOwnHint' => 'Propietats del lloc web aprovisionat juntament amb la subscripció.',
    'admin-panel.form.domain-info-section.createSubscription' => 'Crear subscripció pel client',
    'admin-panel.form.domain-info-section.createSubscriptionHint' => 'Deseleccioni aquesta casella si en aquest moment no desitja crear una subscripció de servei de hosting ni crear un lloc web pel client. Si no disposa d\'una subscripció, el client no podrà accedir al panell del client.',
    'admin-panel.form.domain-info-section.domainName' => 'Nom del domini',
    'admin-panel.form.domain-info-section.emptyDomainName' => 'Indiqui un nom de domini.',
    'admin-panel.form.domain-info-section.shared' => 'compartida',
    'admin-panel.form.domain-info-section.exclusive' => 'dedicada',
    'admin-panel.form.domain-info-section.userName' => 'Nom d\'usuari',
    'admin-panel.form.domain-info-section.userNameHint' => 'Compte d\'usuari del sistema per a la gestió d\'arxius i carpetes dels llocs web creats dins de la subscripció.',
    'admin-panel.form.domain-info-section.emptyLogin' => 'Indiqui un nom d\'usuari.',
    'admin-panel.form.domain-info-section.password' => 'Contrasenya',
    'admin-panel.form.domain-info-section.emptyPassword' => 'Indiqui una contrasenya.',
    'admin-panel.form.domain-info-section.passwordConfirmation' => 'Confirmi la contrasenya',
    'admin-panel.form.domain-info-section.ipv4AddressHint' => "L'adreça IP on s'allotja el lloc web és una adreça de xarxa del host virtual del lloc web.",
    'admin-panel.form.domain-info-section.ipv4Address' => 'Adreça IPv4',
    'admin-panel.form.domain-info-section.ipv6AddressHint' => "L'adreça IP on s'allotja el lloc web és una adreça de xarxa del host virtual del lloc web.",
    'admin-panel.form.domain-info-section.ipv6Address' => 'Adreça IPv6',
    'admin-panel.form.domain-info-section.noIpAddressHint' => 'Cap',
    'admin-panel.form.domain-info-section.subscriptionSettings' => 'Configuració de subscripció addicional',
    'admin-panel.form.domain-info-section.credentials' => 'Credencials de l\'usuari del sistema',
    'admin-panel.form.domain-info-section.credentialsHint' => 'per accedir als arxius allotjats a través de FTP i SSH',
    'admin-panel.form.domain-info-section.credentialsHintWin' => 'per accedir als arxius allotjats a través de FTP i RDP',

    'admin-panel.form.login-info.userName' => 'Nom d\'usuari',
    'admin-panel.form.login-info.emptyUserName' => 'Indiqui un nom d\'usuari.',
    'admin-panel.form.login-info.password' => 'Contrasenya',
    'admin-panel.form.login-info.emptyPassword' => 'Indiqui una contrasenya.',
    'admin-panel.form.login-info.passwordConfirmation' => 'Confirmi la contrasenya',
    'admin-panel.form.login-info.internalEmailPasswordChanged' => 'Si canvia la contrasenya, també es canviarà la contrasenya de l\'adreça de correu interna',
    'admin-panel.form.login-info.emailActivation' => 'Activar compte per email',
    'admin-panel.form.login-info.emailActivationHint' => 'Un compte creat romà inactiu fins que l\'usuari l\'activi mitjançant l\'enllaç enviat per email o fins que l\'administrador l\'activi de forma manual.',

    'admin-panel.form.subscription-info-section.subscription' => 'Subscripció',
    'admin-panel.form.subscription-info-section.servicePlan' => 'Pla de serveis',
    'admin-panel.form.subscription-info-section.oldServicePlan' => 'Pla de serveis actual',
    'admin-panel.form.subscription-info-section.newServicePlan' => 'Nou pla de serveis',
    'admin-panel.form.subscription-info-section.adminPlan' => 'Pla simple',
    'admin-panel.form.subscription-info-section.none' => 'Cap',
    'admin-panel.form.subscription-info-section.addonPlans' => 'Complements',
    'admin-panel.form.subscription-info-section.customizeSubscription' => 'Personalitzi els paràmetres de la subscripció un cop s\'hagi modificat l\'associació del plan. Tingui en compte que això farà que la subscripció no es pugui sincronitzar.',
    'admin-panel.form.subscription-info-section.customizeSubscriptionOnCreateSubscription' => 'Personalitzi els paràmetres de la subscripció un cop creada.',
    'admin-panel.form.subscription-info-section.customizeSubscriptionForCustomer' => "Personalitzi els paràmetres de la subscripció un cop s'hagi creat el client.",
    'admin-panel.form.subscription-info-section.customizeSubscriptionForSelf' => 'Personalitzar els paràmetres de la subscripció un cop s\'hagi creat. Tingui en compte que això farà que la subscripció no es pugui sincronitzar.',
    'admin-panel.form.subscription-info-section.customizeSubscriptionHint' => 'Tingui en compte que això implica el bloqueig de la sincronització de la subscripció.',
    'admin-panel.form.subscription-info-section.buttonOk' => 'Afegir subscripció',

    'admin-panel.form.subscription.subscriptionNotSynchronized' => 'No ha estat possible sincronitzar la subscripció amb el pla de serveis. Els paràmetres de configuració de la subscripció detallats a continuació entren en conflicte amb el pla de serveis: %%problems%%.',

    'app.configure.otherSettings' => 'Altres',
    'app.configure.passwordConfirmation' => 'Confirmi la contrasenya',

    'app.update-settings.description' => '',
    'app.update-settings.forceUpdates' => 'Imposar actualitzacions per totes les aplicacions instal·lades',
    'app.update-settings.forceUpdatesHint' => 'Les aplicacions de tots els clients s\'actualitzaran automàticament tant bon punt hi hagi alguna actualització disponible. Els clients no podran desactivar l\'actualització automàtica per les seves aplicacions. Important! Utilitzi aquesta opció amb atenció, ja que les actualitzacions poden afectar la funcionalitat de l\'aplicació de forma significativa. Per exemple, les extensions de l\'aplicació poden deixar de funcionar si s\'utilitza una altra versió de l\'aplicació.',
    'app.update-settings.suggestUpdates' => 'Activar l\'opció "Actualitzar aquesta aplicació automàticament" per defecte',
    'app.update-settings.suggestUpdatesHint' => 'En el cas d\'aplicacions instal·lades recentment, s\'activarà l\'opció "Actualitzar aquesta aplicació automàticament" a la configuració de l\'aplicació.',

    'backup.server-settings.rotation' => 'Número màxim d\'arxius de backup complet a emmagatzemar (incloent tant els backups programats com els backups manuals)',
    'backup.server-settings.rotationDescription' => 'Els usuaris poden emmagatzemar aquesta quantitat de backups complets a l\'emmagatzematge del servidor. Si es supera el límit, únicament es conservaran els backups més recents. Això no afecta als backups incrementals.',
    'backup.server-settings.maxProcesses' => 'Número màxim de processos de backup programats executant-se a la vegada',
    'backup.server-settings.niceScheduled' => 'Executar els processos de backup programats amb prioritat baixa',
    'backup.server-settings.niceScheduledPriority' => 'Prioritat',
    'backup.server-settings.niceScheduledPriorityDescription' => 'Indiqui un valor entre 1 i 19 ambdós inclosos, sent el número més elevat la prioritat més baixa.',
    'backup.server-settings.niceScheduledIoPriority' => 'Prioritat d\'E/S',
    'backup.server-settings.niceScheduledIoPriorityDescription' => 'Indiqui un valor entre 0 i 7 ambdós inclosos, sent el número més elevat la prioritat més baixa.',
    'backup.server-settings.niceAlways' => 'Executar tots els processos de backup amb prioritat baixa',
    'backup.server-settings.niceAlwaysPriority' => 'Prioritat',
    'backup.server-settings.niceAlwaysPriorityDescription' => 'Indiqui un valor entre 1 i 19 ambdós inclosos, sent el número més elevat la prioritat més baixa.',
    'backup.server-settings.niceAlwaysIoPriority' => 'Prioritat d\'E/S',
    'backup.server-settings.niceAlwaysIoPriorityDescription' => 'Indiqui un valor entre 0 i 7 ambdós inclosos, sent el número més elevat la prioritat més baixa.',
    'backup.server-settings.compressionLevel' => 'Nivell de compressió',
    'backup.server-settings.compressionLevelNoCompression' => 'Sense compressió',
    'backup.server-settings.compressionLevelFastest' => 'Més ràpid',
    'backup.server-settings.compressionLevelFast' => 'Ràpid',
    'backup.server-settings.compressionLevelNormal' => 'Normal',
    'backup.server-settings.compressionLevelMaximum' => 'Màxim',
    'backup.server-settings.freeSpaceRequired' => 'Iniciï el backup només en el cas que el seu servidor disposi de la quantitat d\'espai al disc indicada (en megabytes)',
    'backup.server-settings.checkBackupDiskSpace' => 'Iniciï el backup només en el cas que el seu servidor disposi de suficient quantitat d\'espai al disc lliure',
    'backup.server-settings.mssqlNativeBackupEnabled' => 'Utilitzar la funcionalitat de backups nativa de MS SQL. En el cas de bases de dades remotes, comprovi que ha configurat les opcions de backup del servidor MS SQL remot a Eines i configuració > Servidors de base de dades.',
    'backup.server-settings.localFtpRestriction' => 'Permetre la configuració d\'un emmagatzematge de backups FTP al servidor local',
    'backup.server-settings.backupSecuritySettings' => 'Configuració de seguretat dels backups',
    'backup.server-settings.keepLocalBackupIfExportToFtpFailed' => 'Si s\'experimenta algun error amb la càrrega a l\'emmagatzematge remot, desar els backups a l\'emmagatzematge del servidor',
    'backup.server-settings.keepLocalBackupIfExportToFtpFailedDescription' => 'Si la càrrega a l\'emmagatzematge remot experimenta algun error, els backups programats i manuals per l\'emmagatzematge remot es desaran a l\'emmagatzematge del servidor local. Per a poder desar backups a l\'emmagatzematge del servidor, els usuaris han de disposar del permís corresponent.',
    'backup.server-settings.AllowScheduleHourly' => 'Permetre que els clients i revenedors programin la creació de còpies de seguretat per hora',

    'change-current-subscription.hint' => 'Aquí pot canviar l\'associació de la subscripció amb plans de serveis. Tingui en compte que si selecciona \'cap\' com a nou pla de serveis, la subscripció ja no estarà vinculada al pla de serveis i esdevindrà \'personalitzada\'.',
    'change-current-subscription.subscriptionNotSynchronized' => 'No ha estat possible sincronitzar la subscripció amb el pla de serveis. Els paràmetres de configuració de la subscripció detallats a continuació entren en conflicte amb el pla de serveis: %%problems%%.',

    'change-password.oldPassword' => 'Contrasenya anterior',
    'change-password.password' => 'Contrasenya nova',
    'change-password.passwordConfirmation' => 'Confirmi la contrasenya',
    'change-password.oldPasswordIsIncorrect' => 'La contrasenya anterior no és correcta. Torni-ho a provar.',
    'change-password.unableToFindAdditionalAdminAccount' => 'No ha estat possible trobar el compte d\'administrador addicional.',
    'change-password.warningAboutAdminPasswordSyntax' => "La contrasenya hauria d'estar formada per %%min%% - %%max%% caràcters i en cap cas hauria d'incloure el nom d'usuari.\nNo utilitzi cometes, espais ni caràcters de l'alfabet nacional en les contrasenyes.",
    'change-password.warningAboutWinAdminPasswordSyntax' => "No utilitzi cometes, espais, punt i coma ni caràcters de l'alfabet nacional en les contrasenyes.\nLa contrasenya hauria d'estar formada per %%min%% - %%max%% caràcters i en cap cas hauria d'incloure el nom d'usuari.",

    'change-reseller-oversell-policy.oversellPolicy' => 'Directiva de sobreventa',
    'change-reseller-oversell-policy.oversellPolicyAllowed' => 'Es permet la sobreventa',
    'change-reseller-oversell-policy.oversellPolicyAllowedHint' => 'La sobreventa permet a un revenedor vendre més recursos dels que se li han assignat amb un pla. Si es permet, el revenedor es regeix per l\'ús de recursos actual, enlloc de regir-se per l\'assignació inicial de recursos.',
    'change-reseller-oversell-policy.oversellPolicyNotAllowed' => 'No es permet la sobreventa',
    'change-reseller-oversell-policy.oversellPolicyNotAllowedHint' => 'Si no es permet, un revenedor només podrà vendre els recursos que se li hagin assignat inicialment amb un plan, sense tenir en compte la quantitat de recursos que estigui utilitzant.',

    'change-reseller-subscription.hint' => 'Aquí pot canviar l\'associació de la subscripció de revenedor amb el plan de serveis. Tingui en compte que si selecciona \'cap\' com a nou pla de serveis, la subscripció ja no estarà vinculada als plans de serveis i esdevindrà \'personalitzada\'.',
    'change-reseller-subscription.subscriptionNotSynchronized' => 'No ha estat possible sincronitzar la subscripció amb el pla de serveis. Els paràmetres de configuració de la subscripció detallats a continuació entren en conflicte amb el pla de serveis: %%problems%%.',
    'change-reseller-subscription.servicePlan' => 'Pla nou',
    'change-reseller-subscription.oldSubscription' => 'Pla actual',
    'change-reseller-subscription.none' => 'Cap',
    'change-reseller-subscription.infoSubscriptionChanged' => 'L\'associació de la subscripció amb el pla de serveis ha estat actualitzada.',
    'change-reseller-subscription.customizeSubscription' => 'Personalitzi els paràmetres de la subscripció un cop s\'hagi actualitzat la seva associació amb el pla de serveis. Tingui en compte que això farà que la subscripció no es pugui sincronitzar.',

    'change-subscription.hint' => 'Aquí pot canviar l\'associació de les subscripcions seleccionades amb els plans de serveis.',
    'change-subscription.selectPlanLegend' => 'Pla de serveis',
    'change-subscription.selectPlanDescription' => 'Si desitja canviar a un altre pla de serveis, esculli el pla nou a la llista. Tingui en compte que si selecciona \'cap\', les subscripcions ja no estaran vinculades al pla de serveis i esdevindran \'personalitzades\'.',
    'change-subscription.servicePlan' => 'Nou pla de serveis',
    'change-subscription.selectAddonPlansLegend' => 'Plans complementaris',
    'change-subscription.selectAddonPlansDescription' => 'Afegeixi o elimini plans complementaris.',
    'change-subscription.noChange' => 'no canviar',
    'change-subscription.none' => 'cap',
    'change-subscription.add' => 'afegir',
    'change-subscription.del' => 'eliminar',
    'change-subscription.separator' => '-------',

    'control-panel-access.network.subnetOrIpAddressLabel' => 'Adreça IP o subxarxa',
    'control-panel-access.network.subnetOrIpAddressHint' => 'Por exemple, 2002:7b7b:7b7b::/48, 2002:7b7b:7b7b::1/48, 2002:7b7b:7b7b::1, 123.123.*.*, 123.123.0.0/16, 123.123.123.123/16, 123.123.123.123/32, 123.123.0.0/255.255.0.0, 123.123.123.123/255.255.0.0, 123.123.123.123/255.255.255.255, 123.123.123.123',

    'control-panel-access.settings.accessPolicyLabel' => 'Accés a Plesk amb privilegis d\'administrador',
    'control-panel-access.settings.policyAllow' => 'Permès, excloent les xarxes presents a la llista.',
    'control-panel-access.settings.policyDeny' => 'Denegat des de les xarxes que no estan presents a la llista.',

    'create-subscription.title' => 'Addició d\'una subscripció',
    'create-subscription.titleOwn' => 'Addició de la seva pròpia subscripció',
    'create-subscription.poolIsEmpty' => 'No ha estat possible crear una subscripció perquè a Plesk no hi ha cap adreça IP compartida ni cap adreça IP dedicada lliure.',
    'create-subscription.infoNewSubscriptionCreated' => 'La subscripció %%name%% ha estat creada.',
    'create-subscription.createBeforeAppInstall' => 'Per a instal·lar l\'aplicació és necessari disposar d\'una subscripció.',

    'customer.hint' => 'Aquí pot donar d\'alta un client nou pels seus serveis de hosting. D\'aquesta manera crearà un compte de client a Plesk i una subscripció a un dels seus plans de hosting, podent també afegir-hi complements. La subscripció també pot proporcionar un conjunt personalitzat de recursos i serveis no vinculats a cap pla — en aquest cas, seleccioni \'Cap\' al costat del pla de serveis.',
    'customer.contactInfoSection' => 'Informació de contacte',
    'customer.additionalInfoSection' => 'Informació addicional del client',
    'customer.accessToPanelSection' => 'Accés a Plesk',
    'customer.contactInfoSectionHint' => 'Introdueixi la informació de contacte del client.',
    'customer.accessToPanelSectionHint' => 'Credencials que utilitzarà el client per accedir al panell del client.',
    'customer.unableCreateSubscription' => 'No es pot crear la subscripció: %%reason%%',
    'customer.poolIsEmpty' => 'L\'inventari IP està buit',
    'customer.buttonOk' => 'Afegir client',

    'database-settings.dbPrefixRadio' => 'Afegir un prefix i una ratlla baixa al principi dels noms de les bases de dades',
    'database-settings.dbPrefixNone' => 'Cap',
    'database-settings.dbPrefixUsername' => 'Nom d\'usuari',
    'database-settings.dbPrefixExternalId' => 'ID externa d\'una subscripció',
    'database-settings.dbPrefixCustom' => 'Prefix personalitzat',
    'database-settings.dbUserPrefixRadio' => 'Afegir un prefix i una ratlla baixa al principi dels noms d\'usuari de les bases de dades',
    'database-settings.dbUserPrefixHint' => 'Els noms d\'usuari de les bases de dades tindran la següent aparença: <prefix>_<database_user_name>. Degut a les restriccions de la longitud dels noms d\'usuari de la base de dades, pot ser que s\'abreviï <prefix>.',
    'database-settings.grantAlterDatabase' => 'Concedir el permís ALTER DATABASE a tots els usuaris de bases de dades Microsoft SQL Server',
    'database-settings.grantAlterDatabaseHint' => 'Aquest permís es concedirà a tots els usuaris nous i als existents.',
    'database-settings.aclRadio' => 'Configuració predeterminada per l\'accés remot dels usuaris de la base de dades MariaDB/MySQL',
    'database-settings.aclLocalhost' => 'Permetre únicament connexions locals',
    'database-settings.aclAny' => 'Permetre connexions remotes des de qualsevol host',
    'database-settings.aclCustom' => 'Permetre connexions remotes des de',
    'database-settings.aclDescription' => 'Aquesta opció només modifica els permisos dels usuaris. Per activar l\'accés remot al servidor MariaDB/MySQL local, seleccioni l\'opció corresponent a %%serverLink%%',
    'database-settings.aclDescriptionLink' => 'Configuració MariaDB/MySQL local',
    'database-settings.example' => "Per exemple:",
    'database-settings.aclExampleDescription' => "Els hosts indicats poden accedir a la base de dades en nom d'aquest usuari.",
    'database-settings.dbPrefixAlphaNumeric' => 'El valor del prefix només pot incloure valors alfanumèrics i guió baix.',

    'dns.add-acl-record.description' => 'Afegeixi una adreça IP d\'un servidor DNS que pugui rebre una còpia de la zona DNS.',
    'dns.add-acl-record.ipAddress' => 'Adreça IP',
    'dns.add-acl-record.ipAddressWithMask' => 'Adreça IP/màscara',

    'dns.settings.recursion' => 'Consultes DNS recursives',
    'dns.settings.recursionOn' => 'Acceptar totes les peticions',
    'dns.settings.recursionLocal' => 'Acceptar únicament peticions locals',
    'dns.settings.recursionLocalnets' => 'Permetre només per peticions des de xarxes locals',
    'dns.settings.recursionOff' => 'Denegar per totes les peticions',
    'dns.settings.customConfiguration' => 'Configuració DNS addicional',
    'dns.settings.customConfigurationPlaceholder' => 'La configuració indicada aquí invalidarà la configuració a nivell del servidor.',
    'dns.settings.customConfigurationHint' => 'Si no trobo alguna opció, afegeixi-la al camp que es mostra a dalt emprant la sintaxi de named.conf.',
    'dns.settings.customConfigurationExample' => 'Per exemple, per amagar el nom de host del servidor DNS, afegeixi la següent línia: ',
    'dns.settings.restoreDefaultButton' => 'Utilitzar configuració per defecte',

    'dns.template.synchronize-done' => 'La plantilla de la zona DNS s\'ha aplicat correctament.',
    'dns.template.synchronize-error' => 'La plantilla de la zona DNS no s\'ha pogut aplicar a algunes zones DNS.',
    'dns.template.synchronize-progress' => 'Aplicant la plantilla de zona DNS.',

    'domain-restriction.name' => 'Nom del domini',
    'domain-restriction.nameDescription' => 'Pot especificar un patró wildcard utilitzant el signe d\'asterisc (*). Per exemple, *.example.com',
    'domain-restriction.domainAlreadyExists' => 'El nom de domini indicat ja existeix a la llista.',

    'event-handler.eventLabel' => 'Event',
    'event-handler.priorityLabel' => 'Prioritat',
    'event-handler.userLabel' => 'Usuari',
    'event-handler.commandLabel' => 'Ordre',
    'event-handler.commandHint' => 'Per a obtenir uns millors resultats, introdueixi la ruta completa a l\'arxiu d\'un script al camp \'ordre\'. En cap cas li recomanem introduir ordres del sistema, ja que és possible que no funcionin. Per exemple, les ordres amb operadors de redireccionament de sortida /&gt; o &lt; no funcionaran.',
    'event-handler.priorityHighestText' => 'màxima',
    'event-handler.priorityHighText' => 'elevada',
    'event-handler.priorityNormalText' => 'normal',
    'event-handler.priorityLowText' => 'baixa',
    'event-handler.priorityLowestText' => 'mínima',
    'event-handler.priorityCustomText' => 'Personalitzada',
    'event-handler.priorityHighestOption' => 'màxima (%%value%%)',
    'event-handler.priorityHighOption' => 'elevada (%%value%%)',
    'event-handler.priorityNormalOption' => 'normal (%%value%%)',
    'event-handler.priorityLowOption' => 'baixa (%%value%%)',
    'event-handler.priorityLowestOption' => 'mínima (%%value%%)',

    'extension.upload.fileUpload' => 'Ruta a l\'arxiu del paquet de l\'extensió',

    'external-webmail.hint' => 'Un cop hagi registrat un webmail addicional a Plesk, aquest estarà a disposició dels seus clients i es mostrarà com a una opció a les propietats \'Correu\' de les subscripcions i els plans de hosting. El nom del webmail es mostrarà a la llista d\'opcions de webmail i l\'URL s\'obrirà quan es faci clic a l\'icona del webmail que apareix al costat d\'una bústia de correu al panell del client.',
    'external-webmail.name' => 'Nom del servei de webmail',
    'external-webmail.url' => 'URL del servei de webmail',
    'external-webmail.enabled' => 'Disponible',

    'ftp-settings.generalSection' => 'General',
    'ftp-settings.portRange' => 'Port o interval de ports per les connexions del mode FTP passiu',
    'ftp-settings.hintPortRange' => '(valor predeterminat: %%defaultPortRange%%)',

    'health.upload.hint' => 'Carregui la seva configuració de seguiment d\'estat del servidor. La configuració s\'aplicarà tan bon punt s\'hagi carregat.',
    'health.upload.selectFile' => 'Arxiu de configuració',

    'install-local-package.selectUploadType' => 'Seleccioni una de les següents opcions:',
    'install-local-package.uploadAsFile' => 'Carregar un paquet APS',
    'install-local-package.downloadFromCatalog' => 'Seleccionar una aplicació del catàleg d\'aplicacions',
    'install-local-package.formInfo' => "Ampliï la llista d'aplicacions disponibles carregant noves aplicacions o afegint aplicacions del catàleg d'aplicacions.",
    'install-local-package.invalidFileExtension' => 'L\'aplicació carregada ha de ser un arxiu comprimit ZIP amb l\'extensió .zip.',
    'install-local-package.packagesNotSelected' => 'No s\'ha seleccionat cap paquet.',
    'install-local-package.visible' => 'Posar a disposició dels clients',
    'install-local-package.isCommercial' => 'Aquesta aplicació és una aplicació comercial, motiu pel que és necessari adquirir una clau de llicència.',
    'install-local-package.visibleDescription' => 'Permeti als clients instal·lar l\'aplicació.',

    'ip-address.addTitle' => 'Afegir adreça IP',
    'ip-address.editTitle' => 'L\'adreça IP %%address%% a la interfície %%interface%%',
    'ip-address.generalSection' => 'General',
    'ip-address.interface' => 'Interfície',
    'ip-address.addressAndSubnetPrefixLength' => 'Adreça IP i màscara de subxarxa',
    'ip-address.addressHintIPv4' => 'Per exemple, 123.123.123.123/16, 123.123.123.123/255.255.0.0',
    'ip-address.addressHintIPv6' => 'Per exemple, 2002:7b7b:7b7b::1/64, 123.123.123.123/16, 123.123.123.123/255.255.0.0',
    'ip-address.publicIp' => 'Adreça IP pública',
    'ip-address.hintPublicIp' => 'Si el seu servidor Plesk es troba darrera d\'un NAT, pot utilitzar una adreça IP pública',
    'ip-address.distributionType' => 'L\'adreça IP es distribueix com a',
    'ip-address.distributionTypeShared' => 'Compartida',
    'ip-address.distributionTypeExclusive' => 'Dedicada',
    'ip-address.certificate' => 'Certificat SSL/TLS',
    'ip-address.defaultSite' => 'Lloc predeterminat',
    'ip-address.ftpOverSslNotSupportedByServer' => 'El servidor FTP instal·lat no suporta FTPS.',
    'ip-address.ftpOverSslIpv6NotSupportedByServer' => 'El servidor FTP instal·lat no suporta adreces IPv6.',
    'ip-address.interfaceDHCPEnabled' => 'No es pot afegir l\'adreça IP. Aquesta interfície de xarxa obté adreces IP de forma automàtica.',
    'ip-address.accessDomainOnAnyDomainWinWarning' => 'Nota: L\'URL personalitzada de Plesk es troba activada per tots els dominis desconeguts. Enlloc de mostrar-se el lloc predeterminat present a "https://%%ip%%/", es mostrarà la interfície de Plesk',
    'ip-address.ipAddressInterfaceNotAvailableWarning' => 'L\'adaptador de xarxa %%interface%% no existeix. Transfereixi aquesta adreça IP a un altre adaptador de xarxa o elimini\'l de la llista.',
    'ip-address.none' => 'Cap',

    'ip-ban.filter.name' => 'Nom',
    'ip-ban.filter.content' => 'Contingut',
    'ip-ban.filter.filterExistsError' => 'Ja existeix un filtre amb aquest nom.',

    'ip-ban.jail.name' => 'Nom',
    'ip-ban.jail.filter' => 'Filtre',
    'ip-ban.jail.filterDescription' => 'Seleccioni el filtre.',
    'ip-ban.jail.action' => 'Acció',
    'ip-ban.jail.actionDescription' => 'Seleccioni una acció i faci clic al botó per a afegir-la.',
    'ip-ban.jail.logPath' => 'Ruta del registre',
    'ip-ban.jail.banTime' => 'Període de prohibició de l\'adreça IP',
    'ip-ban.jail.maxRetry' => 'El número màxim d\'intents erronis d\'inici de sessió',
    'ip-ban.jail.timeUnit' => 'segons',
    'ip-ban.jail.addAction' => 'Afegir',
    'ip-ban.jail.chooseAction' => 'Seleccionar:',
    'ip-ban.jail.apache-auth-filter-description' => 'Errors d\'autorització d\'Apache (al accedir a l\'arxiu)',
    'ip-ban.jail.apache-auth[logging=all]-filter-description' => 'Errors d\'autorització d\'Apache (qualsevol accés)',
    'ip-ban.jail.apache-auth[logging=syslog]-filter-description' => 'Errors d\'autorització d\'Apache (al accedir a syslog)',
    'ip-ban.jail.apache-badbots-filter-description' => 'Spam bots i bad web crawlers',
    'ip-ban.jail.plesk-courierlogin-filter-description' => 'Errors d\'autenticació de Courier IMAP i POP3',
    'ip-ban.jail.plesk-dovecot-filter-description' => 'Errors d\'autenticació de Dovecot IMAP, POP3 i Sieve',
    'ip-ban.jail.plesk-dovecot[mode=aggressive]-filter-description' => 'Errors d\'autenticació de Dovecot IMAP, POP3 i Sieve (mode agressiu)',
    'ip-ban.jail.plesk-horde-filter-description' => 'Errors d\'autenticació de webmail Horde',
    'ip-ban.jail.plesk-modsecurity-filter-description' => 'Vulneracions de control d\'accés i seguretat del firewall per a aplicacions web (ModSecurity)',
    'ip-ban.jail.plesk-panel-filter-description' => 'Errors d\'autenticació de Plesk',
    'ip-ban.jail.plesk-qmail-filter-description' => 'Errors d\'autenticació de Qmail SMTP',
    'ip-ban.jail.plesk-roundcube-filter-description' => 'Errors d\'autenticació de webmail Roundcube',
    'ip-ban.jail.plesk-wordpress-filter-description' => 'Errors d\'autenticació de WordPress',
    'ip-ban.jail.plesk-manual-filter-description' => 'Filtre fictici per a la prohibició manual',
    'ip-ban.jail.postfix-filter-description' => 'Errors del client SMTP de Postfix (incloent RBL)',
    'ip-ban.jail.postfix[mode=aggressive]-filter-description' => 'Errors del client SMTP de Postfix, errors d\'autenticació i atacs de DDoS',
    'ip-ban.jail.postfix[mode=auth]-filter-description' => 'Errors d\'autenticació de Postfix SMTP i SASL',
    'ip-ban.jail.postfix[mode=ddos]-filter-description' => 'Atacs DDoS de SMTP de Postfix',
    'ip-ban.jail.postfix[mode=extra]-filter-description' => 'Errors del client SMTP de Postfix i errors d\'autenticació',
    'ip-ban.jail.postfix[mode=normal]-filter-description' => 'Errors del client SMTP de Postfix (incloent RBL)',
    'ip-ban.jail.postfix[mode=rbl]-filter-description' => 'Errors del client SMTP de Postfix (només RBL)',
    'ip-ban.jail.proftpd-filter-description' => 'Errors d\'inici de sessió de ProFTPD',
    'ip-ban.jail.recidive-filter-description' => 'Hosts prohibits repetidament per Fail2Ban',
    'ip-ban.jail.sshd-filter-description' => 'Errors d\'inici de sessió de SSH',
    'ip-ban.jail.sshd[mode=aggressive]-filter-description' => 'Errors d\'accés SSH, errors de negociació i atacs de DDoS',
    'ip-ban.jail.sshd[mode=ddos]-filter-description' => 'Errors d\'inici de sessió de SSH i atacs DDoS',
    'ip-ban.jail.sshd[mode=extra]-filter-description' => 'Errors de negociació i d\'inici de sessió de SSH',
    'ip-ban.jail.firewallcmd-allports-action-description' => 'Prohibir mitjançant firewall firewalld, a tots els ports',
    'ip-ban.jail.firewallcmd-multiport-action-description' => 'Prohibir mitjançant firewall firewalld, en múltiples ports',
    'ip-ban.jail.firewallcmd-new-action-description' => 'Prohibir mitjançant firewall firewalld, en un únic port',
    'ip-ban.jail.iptables-action-description' => 'Prohibir mitjançant firewall iptables, en un únic port',
    'ip-ban.jail.iptables-allports-action-description' => 'Prohibir mitjançant firewall iptables, a tots els ports',
    'ip-ban.jail.iptables-multiport-action-description' => 'Prohibir mitjançant firewall iptables, a múltiples ports',
    'ip-ban.jail.sendmail-action-description' => 'Enviar una notificació per correu a través de Sendmail',
    'ip-ban.jail.jailExistsError' => 'Ja existeix un jail amb aquest nom.',
    'ip-ban.jail.invalidInteger' => 'El valor especificat no és vàlid. Especifiqui un número enter.',

    'ip-ban.settings.pageHint' => 'Aquí pot configurar la prohibició d\'adreces IP per tal de protegir el seu servidor i els llocs web allotjats de trànsit malintencionat.',
    'ip-ban.settings.detectionEnabled' => 'Activar detecció d\'intrusió',
    'ip-ban.settings.banPeriod' => 'Període de prohibició de l\'adreça IP',
    'ip-ban.settings.banTimeWindow' => 'Interval de temps per a la detecció d\'atacs subsegüents',
    'ip-ban.settings.maxRetries' => 'Número d\'errors abans de prohibir l\'adreça IP',
    'ip-ban.settings.timeUnit' => 'segons',
    'ip-ban.settings.invalidInteger' => 'S\'ha proporcionat un valor que no és vàlid. Indiqui un número enter positiu.',

    'ip-ban.trusted-ip.ipAddress' => 'Adreça IP',
    'ip-ban.trusted-ip.hintIpAddress' => 'Una adreça IP, una màscara CIDR o un nom de host DNS.',
    'ip-ban.trusted-ip.ipAddressDescription' => 'Descripció',
    'ip-ban.trusted-ip.hintIpAddressDescription' => 'Explicació del perquè l\'adreça s\'ha afegit a la llista de confiança.',

    'login-info.hint' => 'Aquí pot canviar el nom d\'usuari i la contrasenya que el client utilitza per accedir al seu panell del client.',
    'login-info.resellerHint' => 'Aquí pot canviar el nom d\'usuari i/o contrasenya que el revenedor utilitza per accedir al seu Plesk.',
    'login-info.myProfileHint' => 'Aquí pot canviar la contrasenya que utilitza per accedir al seu Plesk.',

    'firewall-rule.titleEdit' => 'Edició d\'una regla de firewall',
    'firewall-rule.titleNew' => 'Afegint una regla',
    'firewall-rule.isEnabled' => 'Activar la regla',
    'firewall-rule.name' => 'Nom de la regla',
    'firewall-rule.profiles' => 'Perfils',
    'firewall-rule.profilesHint' => 'Seleccioni almenys un perfil.',
    'firewall-rule.profileDomain' => 'Domini',
    'firewall-rule.profilePrivate' => 'Privat',
    'firewall-rule.profilePublic' => 'Pública',
    'firewall-rule.action' => 'Acció',
    'firewall-rule.actionAllow' => 'Permetre',
    'firewall-rule.actionBlock' => 'Denegar',
    'firewall-rule.port' => 'Permetre les connexions al següent port o interval de ports',
    'firewall-rule.portHint' => 'Per exemple: 1000 o 1000-1051',
    'firewall-rule.protocolTcp' => 'Protocol TCP',
    'firewall-rule.protocolUdp' => 'Protocol UDP',
    'firewall-rule.remoteAddresses' => 'Adreces remotes',
    'firewall-rule.remoteAddressesHint' => 'Per exemple: 192.168.0.1 or 192.168.0.0/16',
    'firewall-rule.newRule' => 'Regla nova',
    'firewall-rule.successNew' => 'La regla de firewall ha estat afegida.',
    'firewall-rule.successEdit' => 'La regla de firewall ha estat actualitzada.',

    'mail.lists-server-settings.email' => "Correu de l'administrador de la llista de correu",
    'mail.lists-server-settings.emptyEmail' => 'Proporcioni una adreça de correu.',
    'mail.lists-server-settings.newPassword' => 'Contrasenya nova',
    'mail.lists-server-settings.emptyPassword' => 'Indiqui una contrasenya.',
    'mail.lists-server-settings.passwordConfirmation' => 'Confirmi la contrasenya',
    'mail.lists-server-settings.mailingListSoftwareWasConfigured' => 'El software de llista de correu ha estat configurat.',

    'mail.outgoing-messages.hint' => 'Aquí pot especificar el límit de correus sortints des d\'una bústia de correu.',
    'mail.outgoing-messages.mailBoxOutgoingMessages' => 'El número màxim de correus sortints',
    'mail.outgoing-messages.mailBoxOutgoingMessagesDomainDefault' => 'Predeterminat (%%domainOutgoingMessages%% correus/hora)',
    'mail.outgoing-messages.mailBoxOutgoingMessagesDomainSpecific' => 'Valor personalitzat per aquesta bústia de correu',
    'mail.outgoing-messages.mailBoxOutgoingMessagesDomainSpecificHint' => 'correus/hora',

    'mail-gate-settings.host' => 'Nom del host o adreça IP',
    'mail-gate-settings.port' => 'Port',
    'mail-gate-settings.login' => 'Nom d\'usuari',
    'mail-gate-settings.password' => 'Contrasenya',
    'mail-gate-settings.encryption' => 'El servidor SMTP requereix una connexió xifrada',
    'mail-gate-settings.allowUsers' => 'Permetre als scripts dels usuaris enviar correus a través d\'aquest servidor SMTP utilitzant les credencials indicades',
    'mail-gate-settings.useDefaultSettings' => 'Utilitzar el servidor de correu instal·lat amb Plesk i el compte de correu predeterminat creat per Plesk',

    'mail-gate.hint' => 'Aquí pot especificar el servidor SMTP que s\'ha d\'utilitzar quan no s\'hagi instal·lat el servidor de correu de Plesk o no se li permeti enviar correus. Plesk i els scripts dels usuaris utilitzaran aquest servidor com a una tramesa SMTP per a l\'enviament de correus, com per exemple notificacions per email.',
    'mail-gate.enableMailGate' => 'Permetre a Plesk enviar notificacions per correu a través d\'aquest servidor SMTP',
    'mail-gate.notifications' => 'Notificacions per correu a través d\'un servidor SMTP extern',
    'mail-gate.smtpSettings' => 'Configuració de servidor SMTP extern',

    'optimization-settings.apacheModulesSection' => 'Mòduls d\'Apache',
    'optimization-settings.apacheSettingsSection' => 'Configuració general',
    'optimization-settings.additionalPageHint' => 'Realitzi modificacions als mòduls únicament si entén perfectament les conseqüències de les seves accions. Tingui en compte que algunes modificacions poden empitjorar el rendiment d\'Apache o fins i tot fer que no estigui operatiu. ',
    'optimization-settings.pageHint' => 'Aquí pot optimitzar Plesk desactivant aquells mòduls d\'Apache que no utilitzi. Aquesta optimització millora l\'ús que es fa de la memòria i li permet donar servei a més clients de hosting. Tingui en compte que alguns mòduls són interdependents i només es poden activar o desactivar quan també s\'activa o es desactiva els mòduls dels que depenen.',
    'optimization-settings.advancedUsersOnlyWarning' => 'Aquesta funció és d\'ús exclusiu per usuaris avançats. ',
    'optimization-settings.apacheRestartInterval' => 'Interval de reinici d\'Apache (segons)',
    'optimization-settings.apacheRestartIntervalHint' => 'Un cop hagi especificat un interval, Plesk comprovarà els canvis efectuats als dominis i subdominis. En el cas que s\'hagin efectuat canvis que requereixin reiniciar el servidor web, Plesk reiniciarà Apache.',
    'optimization-settings.gracefulRestart' => 'Reinicie estable d\'Apache',
    'optimization-settings.gracefulRestartHint' => 'Seleccioni-ho per a evitar que tots els llocs web allotjats al servidor resultin inactius cada cop que modifiqui la configuració de hosting.',
    'optimization-settings.pipedLog' => 'Registres redireccionats',
    'optimization-settings.mpmMode' => 'Mode MPM',
    'optimization-settings.moduleDeprecated' => '(En desús)',

    'personal-info.contactInfoSection' => 'Informació de contacte',
    'personal-info.hint' => 'Aquí pot editar la informació de contacte de l\'usuari.',
    'personal-info.hintMyProfile' => 'Aquí pot editar la seva informació de contacte.',

    'php-handler.extension.title' => 'Instal·lar paquet PECL',
    'php-handler.extension.description' => "Pot instal·lar una versió beta d'una extensió indicant paràmetres addicionals amb el nom del paquet, com per exemple 'msgpack-beta'.",
    'php-handler.extension.name' => 'Nom del paquet',

    'php-handler.ini.formHint' => 'Aquest arxiu php.ini només l\'utilitza aquest controlador.',
    'php-handler.ini.formHintSharedIni' => 'Aquest arxiu php.ini també l\'utilitzen els següents controladors de PHP: %%handlers%%. La configuració és aplicable a tots els llocs web que utilitzen aquests controladors.',
    'php-handler.ini.incorrectTextForIniFile' => "La configuració especificada no és correcta i no es pot desar a l'arxiu php.ini. Error: %%message%%.",

    'plan-item-custom.planItemName' => 'Nom del servei',
    'plan-item-custom.buttonLabel' => 'Aquest nom també s\'utilitzarà com a etiqueta pel botó personalitzat.',
    'plan-item-custom.planItemDescription' => 'Descripció del servei',
    'plan-item-custom.buttonTooltip' => 'Aquest text també s\'utilitzarà com a identificador de funció pel botó personalitzat.',
    'plan-item-custom.url' => 'URL vinculada al botó personalitzat',
    'plan-item-custom.backgroundImage' => 'Imatge de fons pel botó personalitzat',
    'plan-item-custom.emptyItemName' => 'Proporcioni una etiqueta pel servei.',
    'plan-item-custom.emptyItemDescription' => 'Proporcioni un text per l\'identificador de funció del servei.',
    'plan-item-custom.emptyUrl' => 'Especifiqui una URL.',
    'plan-item-custom.longItemName' => 'L\'etiqueta per aquest servei és massa llarga. La longitud màxima permesa és de %max% símbols.',
    'plan-item-custom.longItemDescription' => 'El text per aquest servei és massa llarg. La longitud màxima permesa és de %max% símbols.',
    'plan-item-custom.longUrl' => 'Aquesta URL és massa llarga. La longitud màxima permesa és de %max% símbols.',
    'plan-item-custom.useCustomButton' => 'Utilitzar botó personalitzat pel servei',
    'plan-item-custom.useCustomButtonHint' => 'Afegeixi un botó personalitzat a la pàgina inicial i a les pàgines del lloc web de l\'usuari.',
    'plan-item-custom.openCustomButtonInSameWindow' => 'Obrir l\'URL a Plesk',
    'plan-item-custom.openCustomButtonInSameWindowDescription' => 'Indiqui si desitja que l\'URL s\'obri en una pàgina de Plesk o bé en una nova finestra del navegador.',
    'plan-item-custom.openCustomButtonWithoutFrame' => 'No utilitzar marcs',
    'plan-item-custom.openCustomButtonWithoutFrameDescription' => 'Si afegeix un botó personalitzat que redirecciona a una extensió de Plesk o a una aplicació present al panell del client, pot indicar com s\'hauria de mostrar aquesta extensió o aplicació: en un marc o com a part del GUI de Plesk.',
    'plan-item-custom.includeDomId' => 'Incloure ID de la subscripció',
    'plan-item-custom.includeDomIdDescription' => '&dom_id=<dom_id>',
    'plan-item-custom.includeDomName' => 'Incloure el nom de domini principal',
    'plan-item-custom.includeDomNameDescription' => '&dom_name=<dom_name>',
    'plan-item-custom.includeFtpUser' => 'Incloure nom d\'usuari FTP',
    'plan-item-custom.includeFtpUserDescription' => '&ftp_user=<ftp_user>',
    'plan-item-custom.includeFtpPass' => 'Incloure contrasenya FTP',
    'plan-item-custom.includeFtpPassDescription' => '&ftp_pass=<ftp_pass>',
    'plan-item-custom.includeClId' => 'Incloure ID del client',
    'plan-item-custom.includeClIdDescription' => '&cl_id=<cl_id>',
    'plan-item-custom.includeCname' => "Incloure nom de l'empresa del client",
    'plan-item-custom.includeCnameDescription' => '&cname=<cname>',
    'plan-item-custom.includePname' => "Incloure nom de contacte del client",
    'plan-item-custom.includePnameDescription' => '&pname=<pname>',
    'plan-item-custom.includeEmail' => "Incloure email del client",
    'plan-item-custom.includeEmailDescription' => '&email=<email>',

    'preview-domain-settings.previewType' => 'Triï com desitja previsualitzar els llocs web',
    'preview-domain-settings.previewQuick' => 'Previsualització ràpida per defecte',
    'preview-domain-settings.previewDisabled' => 'Desactivar previsualització ràpida',
    'preview-domain-settings.previewQuickDescription' => 'Opció recomanada que es pot començar a fer servir a l\'instant.',
    'preview-domain-settings.previewZoneTypeInternal' => 'Previsualització ràpida en un nom de domini a Plesk',
    'preview-domain-settings.previewZoneDomainIdDescription' => 'Seleccioni un dels seus llocs web servit per Plesk per a la previsualització.',
    'preview-domain-settings.previewZoneDomainCreate' => 'Per tal de poder utilitzar aquesta funció, %%link%% almenys un domini.',
    'preview-domain-settings.subscriptionCreateLink' => 'Crear',
    'preview-domain-settings.previewZoneTypeExternal' => 'Previsualització ràpida en un nom de domini extern',
    'preview-domain-settings.previewZoneDomainNameDescription' => 'Utilitzar un nom de domini extern (zona DNS). Si tria aquesta opció, afegeixi el següent registre DNS (de tipus A) a la zona de domini externa: *.<Plesk_IP>.external.dom. Aquí, <Plesk_IP>és l\'adreça IP del servidor Plesk, on els punts (.) per IPv4 o els dos punts (:) per IPv6 són substituïts per guions (-). Per exemple, *.192-0-2-12.external.dom. Si a Plesk s\'ha registrat més d\'una adreça IP, afegeixi un registre per cadascuna de les adreces.',
    'preview-domain-settings.sitePreviewProtection' => 'Requerir autenticació',
    'preview-domain-settings.sitePreviewProtectionDescription' => 'Requereixi les credencials FTP per a accedir a la vista prèvia.',
    'preview-domain-settings.nginxNotInstalled' => 'La previsualització ràpida per defecte no està disponible perquè el servidor web nginx no està instal·lat.',
    'preview-domain-settings.nginxDisabled' => 'La previsualització ràpida per defecte no està disponible perquè el servidor web nginx no està activat.',

    'reseller-preferences.settingsSection' => 'Configuració',
    'reseller-preferences.multiLogin' => 'Permetre múltiples sessions',
    'reseller-preferences.language' => 'Idioma de la interfície',
    'reseller-preferences.interfaceView' => 'Selecció de la seva interfície',
    'reseller-preferences.serviceProviderView' => 'Mode de visualització de Proveïdor de serveis',
    'reseller-preferences.serviceProviderViewHint' => 'Aquesta vista va dirigida a administradors de servidor que proporcionen i venen serveis de hosting web als seus clients mitjançant plans de serveis.',
    'reseller-preferences.powerUserView' => 'Mode de visualització Power User',
    'reseller-preferences.powerUserViewHint' => 'Aquesta vista és la més apropiada per la gestió de llocs web, els seus arxius, bases de dades, comptes de correu electrònic, aplicacions web i d\'altres serveis.',

    'reseller.hint' => 'Aquí pot donar d\'alta un revenedor nou pels seus serveis de hosting.',
    'reseller.contactInfoSection' => 'Informació de contacte',
    'reseller.contactInfoSectionHint' => 'Introdueixi la informació de contacte del revenedor.',
    'reseller.accessToPanelSection' => 'Accés a Plesk',
    'reseller.accessToPanelSectionHint' => 'Credencials que utilitzarà el revenedor per accedir a Plesk i gestionar els serveis als que està donat d\'alta.',
    'reseller.subscription' => 'Subscripció',
    'reseller.subscriptionSectionHint' => 'Seleccioni el pla de serveis al que desitja subscriure el revenedor.',
    'reseller.servicePlan' => 'Pla de serveis',
    'reseller.none' => 'cap',
    'reseller.customizeSubscription' => 'Personalitzi els paràmetres de la subscripció un cop s\'hagi creat el revenedor. Tingui en compte que això farà que la subscripció no es pugui sincronitzar.',
    'reseller.subscriptionNotSynchronized' => 'No ha estat possible sincronitzar la subscripció amb el pla de serveis. Els paràmetres de configuració de la subscripció detallats a continuació entren en conflicte amb el pla de serveis: %%problems%%.',

    'security-policy.encryptionSection' => 'Mode de seguretat millorada',
    'security-policy.encryptionSectionHint' => 'El mode de seguretat millorada proporciona una protecció avançada de les dades confidencials de Plesk. En aquest mode, Plesk utilitza múltiples mecanismes de seguretat totalment transparents pels usuaris de Plesk. Per tal de millorar la seguretat de Plesk, li recomanem activar aquest mode.',
    'security-policy.encryptionEnable' => 'Mode de seguretat millorada',
    'security-policy.securePassword' => 'Mode de seguretat millorada',
    'security-policy.strengthSection' => 'Seguretat de la contrasenya',
    'security-policy.strengthSectionHint' => 'La majoria de contrasenyes que els usuaris poden establir o modificar a Plesk són validades per tal de garantit que es compleixen els requisits mínims de seguretat de les contrasenyes. Les contrasenyes segures almenys estan formades per 9-12 caràcteres i inclouen dígits, lletres en minúscula i majúscula, caràcters especials i cap paraula del diccionari. Aquestes contrasenyes són més difícils d\'endevinar però també de recordar. <a href="%%link%%" target="_blank">Més informació sobre la seguretat de les contrasenyes</a>.',
    'security-policy.passwordStrength' => 'Seguretat mínima de la contrasenya',
    'security-policy.secureFtpSection' => 'FTP segur',
    'security-policy.ftpOverSsl' => 'Directiva d\'ús de FTPS',
    'security-policy.ftpOverSslHint' => 'FTPS s\'utilitza per a protegir les comunicacions entre el servidor FTP i els clients FTP externs mitjançant l\'ús del protocol SSL/TLS. Aquí pot seleccionar el tipus de connexions que s\'haurien de permetre.',
    'security-policy.ftpOverSslWithCustomOptionHint' => 'FTPS s\'utilitza per a protegir les comunicacions entre el servidor FTP i els clients FTP externs mitjançant l\'ús del protocol SSL/TLS. Aquí pot seleccionar el tipus de connexions que s\'haurien de permetre. L\'opció seleccionada s\'aplicarà a totes les adreces IP del servidor. Si desitja fer servir una configuració personalitzada per cadascuna de les adreces IP, seleccioni l\'opció corresponent i canviï la directiva FTPS a Eines i configuració> Adreces IP.',
    'security-policy.ftpOverSslCustomHint' => 'FTPS s\'utilitza per a protegir les comunicacions entre el servidor FTP i els clients FTP externs mitjançant l\'ús del protocol SSL/TLS.',
    'security-policy.ftpOverSslCustomDisabledHint' => 'FTPS s\'utilitza per a protegir les comunicacions entre el servidor FTP i els clients FTP externs mitjançant l\'ús del protocol SSL/TLS. Si desitja ajustar la configuració de FTPS per cadascuna de les adreces IP, en primer lloc seleccioni l\'opció "Utilitzar configuració personalitzada de FTPS per cada adreça IP" a Eines i configuració> Directiva de seguretat> FTP segur.',
    'security-policy.ftpOverSslOptionRequired' => 'Permetre únicament connexions FTPS segures',
    'security-policy.ftpOverSslOptionEnabled' => 'Permetre connexions FTPS segures i connexions FTP no segures',
    'security-policy.ftpOverSslOptionDisabled' => 'Permetre únicament connexions FTP que no siguin segures. No utilitzar FTPS',
    'security-policy.ftpOverSslOptionCustom' => 'Utilitzar directiva personalitzada de FTPS per cada adreça IP',
    'security-policy.prohibitWebConfigHandlersSection' => 'Directiva de controladors personalitzats',
    'security-policy.prohibitWebConfigHandlersSectionHint' => 'Si activa aquesta opció, els clients no podran sobreescriure els controladors IIS definits a nivell del servidor mitjançant l\'arxiu web.config.',
    'security-policy.prohibitWebConfigHandlers' => 'Prohibir l\'habilitat per a la inhabilitació de controladors a través de web.config',

    'server-mail-antivirus.used' => 'Antivirus utilitzat',
    'server-mail-antivirus.policy' => 'Utilitzar configuració a nivell del servidor',
    'server-mail-antivirus.policyOff' => 'Anàlisi desactivada',
    'server-mail-antivirus.policyAny' => 'Analitzar tant el correu entrant com el correu sortint',
    'server-mail-antivirus.policyFrom' => 'Només analitzar el correu sortint',
    'server-mail-antivirus.policyTo' => 'Només analitzar el correu entrant',
    'server-mail-antivirus.allowPersonalSettings' => 'Permetre una configuració personal',
    'server-mail-antivirus.allowPersonalSettingsDesc' => 'Permeti la substitució de la configuració a nivell del servidor a cada adreça de correu',
    'server-mail-antivirus.incoming' => 'pel correu entrant',
    'server-mail-antivirus.outgoing' => 'pel correu sortint',
    'server-mail-antivirus.success' => 'La configuració de l\'antivirus ha estat modificada.',

    'server-mail-black-list.title' => 'Afegir el domini a la llista negra',
    'server-mail-black-list.domainName' => 'Nom de domini',
    'server-mail-black-list.emailAddress' => 'Adreces de correu',
    'server-mail-black-list.emailAddressHint' => 'A l\'esquerra del signe @ no hi ha d\'haver cap caràcter que no sigui ASCII. Les adreces poden incloure els wildcards "*" i "?" − per exemple *@domain.com, user?@*.com. Les parts no ASCII dels noms de domini no poden incloure wildcards.',
    'server-mail-black-list.action' => 'Accions a realitzar amb el correu que coincideixi amb el criteri:',
    'server-mail-black-list.actionDelete' => 'Eliminar del servidor',
    'server-mail-black-list.actionSpam' => 'Marcar com spam',
    'server-mail-black-list.success' => 'El domini s\'ha afegit a la llista negra.',

    'server-mail-white-list.title' => 'Afegir la xarxa a la llista blanca',
    'server-mail-white-list.descEmailAddress' => 'Les adreces de correu indicades aquí no seran reconegudes com a spam per part de SpamAssassin.',
    'server-mail-white-list.descIpAddress' => 'Les entrades IP indicades aquí s\'afegiran a les excepcions del servidor de correu.',
    'server-mail-white-list.ipAddress' => 'Adreça IP/màscara',
    'server-mail-white-list.ipAddressHint' => 'L\'adreça IP pot incloure una màscara CIDR o wildcard.',
    'server-mail-white-list.emailAddress' => 'Adreces de correu',
    'server-mail-white-list.emailAddressHint' => 'A l\'esquerra del signe @ no hi ha d\'haver cap caràcter que no sigui ASCII. Les adreces poden incloure els wildcards "*" i "?" − per exemple *@domain.com, user?@*.com. Les parts no ASCII dels noms de domini no poden incloure wildcards.',
    'server-mail-white-list.emailAddressOrIp' => 'Email o adreces IP',
    'server-mail-white-list.wildcardPattern' => 'Les adreces IP poden incloure wildcards (per exemple, 123.123.*.123).',
    'server-mail-white-list.cidrPattern' => 'Les adreces IP poden incloure màscares CIDR (per exemple, 10.0.0.0/8).',
    'server-mail-white-list.success' => 'La xarxa s\'ha afegit a la llista blanca.',

    'server-mail-settings.general.title' => 'Opcions generals',
    'server-mail-settings.general.mailUiEnabled' => 'Activar funcions de gestió del correu a Plesk',
    'server-mail-settings.general.serverName' => 'Servidor de correu instal·lat',
    'server-mail-settings.general.changeServerName' => 'instal·lar i utilitzar un altre servidor de correu',
    'server-mail-settings.general.imapServerName' => 'Servidor IMAP/POP3 instal·lat',
    'server-mail-settings.general.changeImapServerName' => 'instal·lar i utilitzar un altre servidor IMAP/POP3',
    'server-mail-settings.general.changeServerHint' => 'Pot %%serverChangeLink%%',
    'server-mail-settings.general.maxMessageSize' => 'Tamany màxim del correu',
    'server-mail-settings.general.kbytes' => 'KBytes',
    'server-mail-settings.general.maxConnections' => 'Número màxim de connexions (IMAP, POP3, IMAP a través de SSL/TLS o POP3 a través de SSL/TLS)',
    'server-mail-settings.general.maxConnectionsHintCourier-IMAP' => 'El número màxim de servidors (IMAP o POP3) iniciats.',
    'server-mail-settings.general.maxConnectionsHintDovecot' => 'El número màxim d\'usuaris de correu que poden iniciar sessió a la vegada.',
    'server-mail-settings.general.maxConnectionsPerIpCourier-IMAP' => 'Número màxim de connexions per adreça IP',
    'server-mail-settings.general.maxConnectionsPerIpDovecot' => 'Número màxim de connexions per a un usuari per adreça IP',
    'server-mail-settings.general.maxConnectionsPerIpHintCourier-IMAP' => 'El número màxim de connexions (IMAP, POP3, IMAP a través de SSL/TLS o POP3 a través de SSL/TLS) que es poden acceptar des de la mateixa adreça IP.',
    'server-mail-settings.general.maxConnectionsPerIpHintDovecot' => 'El número màxim de connexions (IMAP, POP3, IMAP a través de SSL/TLS o POP3 a través de SSL/TLS) permeses per un usuari de correu des de cada adreça IP.',
    'server-mail-settings.general.messageSubmission' => 'Activar el servei SMTP al port 587',
    'server-mail-settings.general.messageSubmissionOnAllIp' => 'Activar el servei SMTP al port 587 a totes les adreces IP',
    'server-mail-settings.general.messageSubmissionBindTo' => 'Activat',
    'server-mail-settings.general.messageSubmissionAllIpAddresses' => 'totes les adreces IP',
    'server-mail-settings.general.outgoingEmailMode' => 'Mode d\'enviament dels correus sortints',
    'server-mail-settings.general.outgoingEmailModeDomainIp' => 'Enviar des de les adreces IP del domini',
    'server-mail-settings.general.outgoingEmailModeDomainName' => 'Enviar des de les adreces IP del domini i fer servir els noms de domini a la salutació SMTP',
    'server-mail-settings.general.outgoingEmailModeExplicitIp' => 'Enviar des de les adreces IP especificades',
    'server-mail-settings.general.outgoingEmailModeExplicitIpV4' => 'IPv4',
    'server-mail-settings.general.outgoingEmailModeExplicitIpV6' => 'IPv6',
    'server-mail-settings.general.outgoingEmailModeExplicitIpNone' => 'Cap',
    'server-mail-settings.general.subaddressing' => 'Activar subredireccionament de correu',
    'server-mail-settings.general.subaddressingHint' => 'Aquesta opció permet configurar adreces de correu %%verpStyleLink%% per llistes de correu',
    'server-mail-settings.general.verpStyleLink' => 'Estil VERP',
    'server-mail-settings.general.mboxQuotaWarning' => 'Activar advertència de quota de bústia de correu',
    'server-mail-settings.general.mboxQuotaWarningHint' => 'Enviar una notificació als usuaris de correu quan el seu ús de la quota de correu superi el 95%',
    'server-mail-settings.general.mboxQuotaWarningChange' => 'Personalitzar l\'advertència de quota de bústia predeterminada',
    'server-mail-settings.general.fixSender' => 'Corregir remitents establerts incorrectament pel correu sortint',
    'server-mail-settings.general.fixSenderHint' => 'Establir capçaleres de correu i adreces de remitents vàlides automàticament pel correu sortint de dominis per tal de reduir les possibilitats que es considerin spam',
    'server-mail-settings.general.maxMessageSizeHint' => 'En els missatges de correu amb arxius adjunts, el valor ha de ser un 35-40 % superior al de la mida de l\'adjunt. %%kbLink%%.',
    'server-mail-settings.general.maxMessageSizeHintLink' => 'Per a més informació, consulti l\'article de la base de coneixement',

    'server-mail-settings.autodiscover.title' => 'Detecció automàtica de correu',
    'server-mail-settings.autodiscover.description' => 'Descobreixi com funciona a la %%link%%',
    'server-mail-settings.autodiscover.link' => 'base de coneixement',
    'server-mail-settings.autodiscover.enabled' => 'Activar detecció automàtica de correu',
    'server-mail-settings.autodiscover.enabledHint' => 'Si activa aquesta funció, es reconfiguraran tots els dominis on s\'hagi activat la detecció automàtica',
    'server-mail-settings.autodiscover.customServer' => 'Indicar un nom de domini personalitzat per la detecció automàtica de correu',
    'server-mail-settings.autodiscover.customServerHint' => 'Nota: el nom de domini ha d\'estar protegit amb un certificat SSL/TLS vàlid.',
    'server-mail-settings.autodiscover.reconfigureDns' => 'Reconfigurar registres DNS de detecció automàtica',
    'server-mail-settings.autodiscover.reconfigureDnsHint' => 'Si activa aquesta funció, es reconfiguraran tots els registres DNS de detecció automàtica de dominis on s\'hagin activat la detecció automàtica',

    'server-mail-settings.relay.title' => 'Opcions de tramesa',
    'server-mail-settings.relay.type' => "Tramesa",
    'server-mail-settings.relay.open' => "Obrir",
    'server-mail-settings.relay.openSpamWarning' => "L'obertura de la retransmissió de correu exposa el seu servidor de correu a spam.",
    'server-mail-settings.relay.openSpamChange' => "Conservi l'opció només en cas que desitgi provar el servidor de correu de forma temporal o si el seu servidor Plesk es troba en una xarxa interna no accessible a través d'Internet.",
    'server-mail-settings.relay.closed' => "tancada",
    'server-mail-settings.relay.auth' => "autorització obligatòria: ",
    'server-mail-settings.relay.notSupported' => "no suportada pel servidor de correu",
    'server-mail-settings.relay.change' => 'Per tal que Plesk pugui enviar notificacions quan la tramesa estigui tancada, pot %%changeLink%%',
    'server-mail-settings.relay.changeLink' => 'canviar la configuració SMTP',
    'server-mail-settings.relay.pop3' => "POP3 abans que SMTP",
    'server-mail-settings.relay.lockTime' => "temps de bloqueig",
    'server-mail-settings.relay.min' => "min",
    'server-mail-settings.relay.smtp' => "SMTP",
    'server-mail-settings.relay.noRelayNetworks' => 'No utilitzar cap restricció de tramesa per les següents xarxes:',
    'server-mail-settings.relay.noRelayNetworksHint' => "Adreça IP/màscara",

    'server-mail-settings.outgoing.title' => 'Limitacions de correus sortints',
    'server-mail-settings.outgoing.description' => 'Aquests límits són els predeterminats. Aquests poden ser substituïts a cada pla de serveis i a cada subscripció. Els límits no funcionen a nivell del servidor, sinó que actuen com una plantilla pels plans i les subscripcions als que no s\'ha especificat cap límit personalitzat. Tingui en compte l\'activació de la limitació dels correus sortints pot afectar al rendiment del servidor de correu. %%link%%',
    'server-mail-settings.outgoing.learnMore' => 'Obtingui més informació sobre la limitació del correu sortint',
    'server-mail-settings.outgoing.enabled' => 'Activar limitacions pels correus sortints',
    'server-mail-settings.outgoing.countRecipients' => 'Comptar la quantitat de destinataris enlloc de missatges',
    'server-mail-settings.outgoing.countRecipientsHint' => 'Activa el mode que compta la quantitat de destinataris en lloc dels missatges quan es limita el correu sortint i es compten estadístiques. Per exemple, un missatge enviat a 10 destinataris es comptarà com deu missatges.',
    'server-mail-settings.outgoing.mailboxLimit' => 'Límit per defecte de correus sortints des d\'una bústia de correu (per hora)',
    'server-mail-settings.outgoing.domainLimit' => 'Límit per defecte de correus sortints des d\'un domini (per hora)',
    'server-mail-settings.outgoing.subscriptionLimit' => 'Límit per defecte de correus sortints des d\'una subscripció (per hora)',
    'server-mail-settings.outgoing.unlimited' => 'Il·limitats',
    'server-mail-settings.outgoing.sendmail' => 'Permetre a usuaris i scripts utilitzar Sendmail',
    'server-mail-settings.outgoing.sendmailHint' => 'Tant usuaris com scripts podran enviar correus en nom de l\'usuari del sistema de la subscripció mitjançant Sendmail, inclús en el cas que s\'hagin excedit els límits d\'una bústia i d\'un domini. El número màxim de correus que es poden enviar a través de Sendmail serà definit pel límit de tota una subscripció. Aquesta opció no permet als scripts utilitzar Sendmail a nivell del servidor, si bé actua com a opció predeterminada per a plans de serveis i subscripcions.',
    'server-mail-settings.outgoing.reportPeriod' => 'Mostrar informes basats en les estadístiques de les darreres',
    'server-mail-settings.outgoing.reportPeriodHint' => 'Es creen informes i a la pàgina inicial es mostra una alerta informant de les vegades que s\'ha intentat excedir el límit de correus sortints durant el període especificat.',
    'server-mail-settings.outgoing.notificationPeriod' => 'Enviar una notificació per correu cada',
    'server-mail-settings.outgoing.notificationPeriodHint' => 'Les notificacions proporcionen estadístiques sobre les vegades que s\'ha intentat excedir el límit de correus sortints durant el període especificat.',
    'server-mail-settings.outgoing.periodP1D' => '1 dia',
    'server-mail-settings.outgoing.periodP1W' => '1 setmana',
    'server-mail-settings.outgoing.periodP2W' => '2 setmanes',
    'server-mail-settings.outgoing.periodP1M' => '1 mes',
    'server-mail-settings.outgoing.periodPT15M' => '15 minuts',
    'server-mail-settings.outgoing.periodPT1H' => '1 hora',
    'server-mail-settings.outgoing.periodPT6H' => '6 hores',
    'server-mail-settings.outgoing.periodPT12H' => '12 hores',
    'server-mail-settings.outgoing.whiteListNotEmpty' => 'Els límits dels correus sortints no s\'aplicaran en el cas de remitents les adreces IP dels quals estiguin presents a la llista blanca del servidor de correu. Per exemple, si a la llista blanca s\'ha inclòs localhost (127.0.0.0 / 8, ::1 / 128), tots els correus procedents de servidor local s\'enviaran correctament sigui quin sigui el límit. Els remitents dels correus poden utilitzar adreces IP locals (llocs web i scripts personalitzats allotjats al servidor local) o adreces IP externes (clients que envien els correus mitjançant clients de correu instal·lats als seus ordinadors o dispositius mòbils). Si desitja que els límits s\'apliquin per a tots els remitents de correu (tant locals com externs), elimini totes les adreces de correu i xarxes de la llista blanca. Tingui en compte que si elimina localhost (127.0.0.0 / 8, ::1 / 128) de la llista blanca, és possible que s\'interrompin les operacions de llocs web i scripts que enviïn correus des d\'aquest servidor. Si desitja més informació sobre la limitació dels correus sortints, consulti la guia de l\'administrador, concretament l\'apartat Protecció contra l\'spam sortint.',
    'server-mail-settings.outgoing.relayIsOpen' => 'La tramesa de correu està oberta. Els límits dels correus sortints no s\'aplicaran.',
    'server-mail-settings.outgoing.domainLimitExceedsSubscriptionLimit' => 'El límit de correus sortints per un domini (%%value%%) no pot ser superior al límit per una subscripció (%%highLevelLimitValue%%).',
    'server-mail-settings.outgoing.mailboxLimitExceedsDomainLimit' => 'El límit de correus sortints per una adreça de correu (%%value%%) no pot ser superior al límit per un domini (%%highLevelLimitValue%%).',
    'server-mail-settings.outgoing.mailboxLimitExceedsSubscriptionLimit' => 'El límit de correus sortints per una adreça de correu (%%value%%) no pot ser superior al límit per una subscripció (%%highLevelLimitValue%%).',

    'server-mail-settings.mailman.title' => 'Configuració de Mailman',
    'server-mail-settings.mailman.secureLinks' => 'Emprar enllaços segurs a les llistes de correu',
    'server-mail-settings.mailman.secureLinksHint' => 'Activi o desactivi la generació d\'enllaços segurs (HTTPS) a les llistes de correu.',
    'server-mail-settings.mailman.noLocalhost' => 'Per poder utilitzar llistes de correu, és necessari que localhost (127.0.0.0/8, ::1/128) estigui present a la llista blanca del servidor de correu. De totes maneres, per fer ús del control dels correus sortint localhost no hauria d\'estar present a la llista blanca. Per a resoldre aquesta situació, si ha activat el control dels correus sortint, a la bústia pot fer servir el redireccionament de correu enlloc de fer servir llistes de correu.',
    'server-mail-settings.mailman.noLocalhostIpv4' => 'Per poder utilitzar llistes de correu, és necessari que localhost estigui present a la llista blanca del servidor de correu. De totes maneres, per fer ús del control dels correus sortint localhost no hauria d\'estar present a la llista blanca. Per a resoldre aquesta situació, si ha activat el control dels correus sortint, a la bústia pot fer servir el redireccionament de correu enlloc de fer servir llistes de correu. Tingui en compte que en aquest moment la llista blanca no inclou cap adreça localhost IPv4 (127.0.0.0/8), motiu pel qual el control del correus sortints funcionarà per a adreces IPv4.',
    'server-mail-settings.mailman.noLocalhostIpv6' => 'Per poder utilitzar llistes de correu, és necessari que localhost estigui present a la llista blanca del servidor de correu. De totes maneres, per fer ús del control dels correus sortint localhost no hauria d\'estar present a la llista blanca. Per a resoldre aquesta situació, si ha activat el control dels correus sortint, a la bústia pot fer servir el redireccionament de correu enlloc de fer servir llistes de correu. Tingui en compte que en aquest moment la llista blanca no inclou cap adreça localhost IPv6 (::1/128), motiu pel qual el control del correus sortints funcionarà per a adreces IPv6.',

    'server-mail-settings.spam-filter.dmarc' => 'DMARC',
    'server-mail-settings.spam-filter.dmarcEnabled' => 'Activar DMARC per comprovar el correu entrant',
    'server-mail-settings.spam-filter.dmarcHint' => 'Aquesta opció es troba disponible quan DKIM i SPF es troben activats pel correu entrant.',
    'server-mail-settings.spam-filter.dkim' => 'Protecció antispam DKIM',
    'server-mail-settings.spam-filter.singOutgoing' => 'Permetre la signatura del correu sortint',
    'server-mail-settings.spam-filter.verifyIncoming' => 'Verificar el correu entrant',
    'server-mail-settings.spam-filter.verifyIncomingHint' => 'Aquesta opció no es pot desactivar si DMARC està activat pel correu entrant.',
    'server-mail-settings.spam-filter.spf' => 'Protecció antispam SPF',
    'server-mail-settings.spam-filter.spfEnabled' => 'Activar protecció antispam SPF per a la comprovació dels correus entrants',
    'server-mail-settings.spam-filter.spfEnabledHint' => 'Aquesta opció no es pot desactivar si DMARC està activat pel correu entrant.',
    'server-mail-settings.spam-filter.ignoreErrors' => 'Les verificacions SPF segueixen efectuant-se fins i tot quan hi ha problemes en la cerca de DNS',
    'server-mail-settings.spam-filter.ignoreErrorsHint' => 'En primer lloc, SPF realitza una cerca de DNS. Seleccioni aquesta opció si desitja comprovar si la cerca de DNS experimenta algun error. Aquesta opció està deseleccionada si no té cap efecte sobre el mode de verificació actual.',
    'server-mail-settings.spam-filter.behavior' => 'Mode de verificació SPF',
    'server-mail-settings.spam-filter.behaviorHint' => 'A continuació, SPF aplica regles locals i de conjetura. El missatge pot ser rebutjat depenent del mode de verificació seleccionat i del resultat de la verificació.',
    'server-mail-settings.spam-filter.behaviorCreateHeadersNoBlock' => 'Només crear capçaleres SPF de recepció, mai no bloquejar',
    'server-mail-settings.spam-filter.behaviorUseTmpErrors' => 'Utilitzar avisos d\'error temporals quan s\'experimentin problemes de cerca de DNS',
    'server-mail-settings.spam-filter.behaviorRejectIfFail' => 'Rebutjar el correu quan SPF resolgui a "fail" (denegar)',
    'server-mail-settings.spam-filter.behaviorRejectIfSoftfail' => 'Rebutjar el correu quan SPF resolgui a "softfail"',
    'server-mail-settings.spam-filter.behaviorRejectIfNeutral' => 'Rebutjar el correu quan SPF resolgui a "neutral"',
    'server-mail-settings.spam-filter.behaviorRejectIfNoPass' => 'Rebutjar el correu quan SPF no resolgui a "pass"',
    'server-mail-settings.spam-filter.localRules' => 'Regles locals SPF',
    'server-mail-settings.spam-filter.guessRules' => 'Regles de conjetura SPF',
    'server-mail-settings.spam-filter.explanationText' => 'Text explicatiu SPF',
    'server-mail-settings.spam-filter.rbl' => "Protecció antispam basada en llistes negres del DNS",
    'server-mail-settings.spam-filter.rblEnabled' => "Activar protecció antispam basant-se en les llistes negres del DNS",
    'server-mail-settings.spam-filter.rblServer' => "Zones DNS pel servei DNSBL",
    'server-mail-settings.spam-filter.rblServerHint' => "Separi les entrades amb punt i coma. Per exemple: 'zen.spamhaus.org;dnsbl.example.net'",

    'server-mail-settings.auto-reply-headers.title' => 'Capçaleres de resposta automàtica addicionals',
    'server-mail-settings.auto-reply-headers.description' => 'Configuri capçaleres addicionals per qualsevol missatge de resposta automàtica procedent del servidor Plesk.',
    'server-mail-settings.auto-reply-headers.extra' => 'Capçaleres addicionals',

    'server-mail-settings.pop3-names.title' => "Noms pels comptes de correu POP3/IMAP",
    'server-mail-settings.pop3-names.disabled' => "Només es permet l'ús de noms complets de comptes de correu POP3/IMAP",
    'server-mail-settings.pop3-names.enabled' => "Es poden emprar noms curts (webmaster) i complets (webmaster@domain.com) de comptes de correu POP3/IMAP.",

    'server-mail-settings.success' => 'La configuració del servidor de correu ha estat modificada.',

    'server-mail-spam-filter.general' => 'General',
    'server-mail-spam-filter.isEnabled' => 'Activar la filtració d\'spam d\'SpamAssassin a nivell del servidor',
    'server-mail-spam-filter.notInstalled' => '(SpamAssassin no està instal·lat.)',
    'server-mail-spam-filter.greylistingSpamProtection' => 'Activar la protecció antispam greylisting a nivell del servidor',
    'server-mail-spam-filter.isUserSettingsEnabled' => 'Aplicar configuració individual a la filtració d\'spam',
    'server-mail-spam-filter.isUserSettingsEnabledHint' => "El filtre antispam està desactivat. El servidor de correu no suporta la configuració del filtre antispam a nivell de la bústia de correu.",
    'server-mail-spam-filter.settings' => 'Configuració d\'SpamAssassin',
    'server-mail-spam-filter.maxChildrenTitle' => 'Processos màxims',
    'server-mail-spam-filter.maxChildrenDescription' => 'Quantitat màxima de processos de treball spamd que es poden executar.',
    'server-mail-spam-filter.requiredHitsTitle' => 'Puntuació obligatòria',
    'server-mail-spam-filter.requiredHitsDescription' => 'La puntuació que ha de rebre un missatge per a considerar-lo spam.',
    'server-mail-spam-filter.maxMailLimit' => 'No filtrar si el tamany del correu és superior a aquest valor',
    'server-mail-spam-filter.maxMailLimitText' => 'tamany màxim',
    'server-mail-spam-filter.kbytes' => "KBytes",
    'server-mail-spam-filter.maxThreadsLimit' => 'Número de subprocessos que pot crear el filtre antispam',
    'server-mail-spam-filter.tagTitle' => 'Etiqueta d\'spam',
    'server-mail-spam-filter.tagDescription' => 'S\'afegirà el següent text al principi de l\'assumpte de cada missatge que es marqui com a spam.',
    'server-mail-spam-filter.alarmMessage' => 'Text d\'alerta de detecció d\'spam',
    'server-mail-spam-filter.languages' => 'Idiomes de confiança',
    'server-mail-spam-filter.locales' => 'Grups d\'idiomes',
    'server-mail-spam-filter.success' => 'La configuració del filtre antispam ha estat modificada.',
    'server-mail-spam-filter.personalSettingsWarning' => 'L\'administrador del servidor ha desactivat l\'habilitat per aplicar una configuració personal de filtració d\'spam. La configuració de filtració d\'spam especificada a continuació no serà aplicada.',

    'service-plan.admin-plan.subscription_section' => 'Comú',
    'service-plan.admin-plan.tools_section' => 'Eines i recursos',
    'service-plan.admin-plan.apps_section' => 'Aplicacions i bases de dades',
    'service-plan.admin-plan.panel_section' => 'Plesk',
    'service-plan.admin-plan.appearance_section' => 'Aparença de Plesk',
    'service-plan.admin-plan.statistics_section' => 'Estadístiques',
    'service-plan.admin-plan.general_section' => 'General',
    'service-plan.admin-plan.mail_section' => 'Correu',
    'service-plan.admin-plan.server_section' => 'Servidor',
    'service-plan.admin-plan.modules_section' => 'Extensions',
    'service-plan.admin-plan.troubleshooting_section' => 'Assistència i resolució d\'errors',
    'service-plan.admin-plan.simplePanel' => 'Mode restringit',
    'service-plan.admin-plan.enabled' => 'Activar el mode restringit',
    'service-plan.admin-plan.enabledDescription' => 'Seleccioni aquesta opció si desitja limitar el número d\'accions que pot efectuar l\'administrador a Plesk.',
    'service-plan.admin-plan.aliasEnabledDescription' => 'Seleccioni aquesta opció si desitja limitar el número d\'accions que pot efectuar l\'administrador addicional a Plesk.',

    'service-plan.applications-subscription.useFilterLabel' => 'Només proporcionar les aplicacions que seleccioni',
    'service-plan.applications-subscription.useFilterDescription' => 'Utilitzi aquesta opció per a seleccionar les aplicacions que haurien d\'estar a disposició del subscriptor.',
    'service-plan.applications-subscription.applications' => 'Aplicacions',
    'service-plan.applications-subscription.isCommercial' => 'Aquesta aplicació és una aplicació comercial, motiu pel que és necessari adquirir una clau de llicència.',

    'service-plan.applications.useFilterLabel' => 'Només proporcionar les aplicacions que seleccioni',
    'service-plan.applications.useFilterDescription' => 'Utilitzi aquesta opció per a seleccionar les aplicacions que haurien d\'estar a disposició dels subscriptors.',
    'service-plan.applications.applications' => 'Aplicacions',
    'service-plan.applications.isCommercial' => 'Aquesta aplicació és una aplicació comercial, motiu pel que és necessari adquirir una clau de llicència.',

    'service-plan.dns.dnsZoneType' => 'Zona DNS del domini',
    'service-plan.dns.dnsZoneTypeMaster' => 'Principal',
    'service-plan.dns.dnsZoneTypeSlave' => 'Secundari',

    'service-plan.extras.groupOtherServices' => 'Altres serveis',
    'service-plan.extras.none' => 'Cap',

    'service-plan.hosting.enablePhysicalHosting' => 'Activar hosting',
    'service-plan.hosting.sectionCoreHosting' => 'Propietats generals',
    'service-plan.hosting.sectionScripting' => 'Scripting',
    'service-plan.hosting.defaultDatabaseServer' => 'Servidor de base de dades predeterminat',
    'service-plan.hosting.versionCut' => 'v%%version%%',
    'service-plan.hosting.sectionAdvanced' => 'Avançat',
    'service-plan.hosting.phpSettingsHelpLink' => 'Descobreixi com escollir la configuració de PHP més apropiada',
    'service-plan.hosting.unpaidWebsiteStatusLabelSubscription' => 'Estat dels llocs web si es suspèn aquesta subscripció',
    'service-plan.hosting.unpaidWebsiteStatusLabel' => 'Estat dels llocs web en subscripcions suspeses',
    'service-plan.hosting.unpaidWebsiteStatusDescription' => 'L\'estat seleccionat s\'aplicarà a tots els llocs web sota les subscripcions del pla quan es suspengui la subscripció − per exemple quan aquesta caduqui o quan caduqui el seu període de pagament.',
    'service-plan.hosting.unpaidWebsiteStatusDescriptionSubscription' => 'L\'estat seleccionat s\'aplicarà als llocs web quan es suspengui la subscripció − per exemple quan aquesta caduqui o quan caduqui el seu període de pagament.',
    'service-plan.hosting.unpaidWebsiteStatusDisabled' => 'Desactivat',
    'service-plan.hosting.unpaidWebsiteStatusDisabledHint' => 'Els visitants dels llocs web seran redireccionats a la pàgina predeterminada del servidor web.',
    'service-plan.hosting.unpaidWebsiteStatusSuspended' => 'Suspès',
    'service-plan.hosting.unpaidWebsiteStatusSuspendedHint' => 'Els visitants dels llocs web seran redireccionats a la pàgina del document d\'error personalitzat amb el codi d\'error HTTP 503 del motor de cerca.',
    'service-plan.hosting.unpaidWebsiteStatusActive' => 'Actiu',
    'service-plan.hosting.unpaidWebsiteStatusActiveHint' => 'Es podrà seguir accedint als llocs web a través d\'Internet.',

    'service-plan.ip.sharedIpAddresses' => 'Assignar adreces IP compartides',
    'service-plan.ip.allocateExclusiveIp' => 'Assignar adreces IP dedicades',
    'service-plan.ip.allocateExclusiveIpV4' => 'Assignar adreces IPv4 dedicades',
    'service-plan.ip.allocateExclusiveIpV6' => 'Assignar adreces IPv6 dedicades',

    'service-plan.mail.mailService' => 'Servei de correu',
    'service-plan.mail.mailServiceDisabled' => 'Desactivat',
    'service-plan.mail.mailServiceDisabledIncoming' => 'Desactivat pel correu entrant',
    'service-plan.mail.mailServiceDisabledHint' => 'Plesk no proporcionarà cap servei de correu als dominis.',
    'service-plan.mail.mailServiceDisabledIncomingHint' => 'Els dominis només poden enviar correu i només mitjançant Sendmail.',
    'service-plan.mail.mailServiceEnabled' => 'Activat',
    'service-plan.mail.mailServiceEnabledHint' => 'Els dominis poden enviar i rebre correu.',
    'service-plan.mail.mailServiceNotConfigured' => 'No configurat',
    'service-plan.mail.mailServiceNotConfiguredHint' => 'Plesk no proporcionarà cap servei de correu als dominis.',
    'service-plan.mail.webMail' => 'Webmail',
    'service-plan.mail.mailingLists' => 'Activar llistes de correu',
    'service-plan.mail.mailToNonExistentUser' => 'Directiva sobre els correus enviats a usuaris inexistents',
    'service-plan.mail.mailToNonExistentUserBounce' => 'Tornar amb un missatge',
    'service-plan.mail.mailToNonExistentUserRedirect' => 'Reenviar a l\'adreça',
    'service-plan.mail.mailToNonExistentUserReject' => 'Rebutjar',
    'service-plan.mail.mailAutodiscovery' => 'Activar detecció automàtica de correu',
    'service-plan.mail.mailAutodiscoveryDescription' => 'Descobreixi com funciona a la <a href="%%link%%" target="_blank">base de coneixement</a>',
    'service-plan.mail.bounceMessage' => 'Aquesta adreça ja no accepta correus.',
    'service-plan.mail.mailToNonExistentUserexternalMailServer' => 'Redireccionar a un servidor de correu extern amb l\'adreça IP',
    'service-plan.mail.webmailDisabled' => '%%webmail%% − desactivat',

    'service-plan.misc.manualSubscriptionUpdateWarning' => 'Note: The setting Retain web and traffic statistics is not changed in subscriptions when you update it for a service plan. The only way to update this setting for each domain is changing it in the Plesk database. See <a href="https://support.plesk.com/hc/en-us/articles/12377479274007-How-to-configure-a-storage-period-for-statistics" target="_blank">this KB article</a> for more details.',
    'service-plan.misc.retainEnabled' => 'Conservar estadístiques web i de trànsit durant',
    'service-plan.misc.logRotation' => 'Rotació de registres',
    'service-plan.misc.logRotationCondition' => 'Condició de rotació de registres',
    'service-plan.misc.logRotationBySize' => 'Per tamany',
    'service-plan.misc.logRotationByTime' => 'Per hora',
    'service-plan.misc.logRotationDaily' => 'Cada dia',
    'service-plan.misc.logRotationWeekly' => 'Cada setmana',
    'service-plan.misc.logRotationMonthly' => 'Cada mes',
    'service-plan.misc.logRotationSizeDescription' => 'El valor de tamany ha de ser %%min%% - %%max%% KB.',
    'service-plan.misc.maximumNumberOfFiles' => 'Número màxim d\'arxius de registre',
    'service-plan.misc.compress' => 'Comprimir arxius de registre',
    'service-plan.misc.sendLogToEmail' => 'Un cop Plesk hagi recuperat les dades dels arxius de registre dels servidors FTP i web, enviar els registres per email a aquesta adreça',
    'service-plan.misc.kb' => 'KB',
    'service-plan.misc.months' => 'mesos',
    'service-plan.misc.logRotationPeriodGreater' => 'El període de rotació de registres no pot ser superior al límit a nivell del servidor de %%max%%.',

    'service-plan.performance.iisAppPoolAddonsHint' => 'Si està desactivat, tots els llocs web d\'una subscripció utilitzen el mateix conjunt d\'aplicacions IIS dedicat per la subscripció.',

    'service-plan.permissions-subscription.permissionsTabDescription' => 'Seleccioni els serveis i privilegis proporcionats amb la subscripció.',
    'service-plan.permissions-subscription.showMorePermissions' => 'Mostrar més permisos disponibles',
    'service-plan.permissions-subscription.hideMorePermissions' => 'Mostrar menys permisos',
    'service-plan.permissions-subscription.noShellManagement' => 'No permès',
    'service-plan.permissions-subscription.systemAccessLabel' => 'Gestió de l\'accés al servidor a través de SSH',
    'service-plan.permissions-subscription.systemAccessLabel_hint' => 'Permet als clients activar SSH pel seu usuari del sistema. En aquest cas, el paràmetre de hosting "Accés SSH al shell del servidor sota l\'usuari del sistema de la subscripció" actua com a predeterminat.',

    'service-plan.permissions.permissionsTabDescription' => 'Seleccioni els serveis i permisos proporcionats amb el pla.',
    'service-plan.permissions.permissionsAddonTabDescription' => 'Seleccioni els serveis i els privilegis que s\'haurien d\'afegir a les subscripcions amb aquest pla complementari. Tingui en compte que els permisos que no es seleccionin al complement no modificaran en cap cas els paràmetres de la subscripció.',
    'service-plan.permissions.permissionsBehaviorDescription' => 'Els permisos permeten als clients modificar determinades opcions de les seves subscripcions. Quan es crea una subscripció, Plesk aplica els valors predeterminats del pla a les opcions que el client pot canviar. Posteriorment, l\'actualització del pla o l\'aplicació d\'un pla complementari no invalida els canvis efectuats pel client.',
    'service-plan.permissions.showMorePermissions' => 'Mostrar més permisos disponibles',
    'service-plan.permissions.hideMorePermissions' => 'Mostrar menys permisos',
    'service-plan.permissions.noShellManagement' => 'No permès',
    'service-plan.permissions.systemAccessLabel' => 'Gestió de l\'accés al servidor a través de SSH',
    'service-plan.permissions.systemAccessLabel_hint' => 'En aquest cas, el paràmetre de hosting "Accés SSH al shell del servidor sota l\'usuari del sistema de la subscripció" actua com a predeterminat.',

    'service-plan.resources-subscription.overusePolicy' => 'Directiva de sobreús',
    'service-plan.resources-subscription.overusePolicyNotAllowed' => 'No es permet el sobreús',
    'service-plan.resources-subscription.overusePolicyNotAllowedHint' => 'No permeti el sobreús de recursos. Si l\'ús de recursos excedeix els valors del límit, una subscripció es suspèn automàticament.',
    'service-plan.resources-subscription.overusePolicySoftAllowed' => 'Es permet el sobreús de trànsit i d\'espai al disc',
    'service-plan.resources-subscription.overusePolicySoftAllowedHint' => 'Permeti el sobreús de trànsit i d\'espai al disc. No permeti el sobreús d\'altres recursos.',
    'service-plan.resources-subscription.overusePolicyAllowed' => 'Es permet el sobreús (no recomanat)',
    'service-plan.resources-subscription.overusePolicyAllowedHint' => 'Permeti al subscriptor utilitzar més recursos dels proporcionats inicialment amb la subscripció.',
    'service-plan.resources-subscription.overuseNotify' => 'Notificar-me per correu en cas de sobreús.',
    'service-plan.resources-subscription.oversellPolicy' => 'Directiva de sobreventa',
    'service-plan.resources-subscription.oversellPolicyAllowed' => 'Es permet la sobreventa',
    'service-plan.resources-subscription.oversellPolicyAllowedHint' => 'La sobreventa permet a un revenedor vendre més recursos dels que se li han assignat amb una subscripció. Si es permet, el revenedor es regeix per l\'ús de recursos actual, enlloc de regir-se per l\'assignació inicial de recursos.',
    'service-plan.resources-subscription.oversellPolicyNotAllowed' => 'No es permet la sobreventa',
    'service-plan.resources-subscription.oversellPolicyNotAllowedHint' => 'Si no es permet, un revenedor només podrà vendre els recursos que se li hagin assignat inicialment amb una subscripció, sense tenir en compte la quantitat de recursos que estigui utilitzant.',
    'service-plan.resources-subscription.mainGroupTitle' => 'Defineixi el límit d\'ús de recursos proporcionats amb la subscripció.',
    'service-plan.resources-subscription.additionalGroupTitle' => 'Mostrar més recursos disponibles',
    'service-plan.resources-subscription.hideMoreResources' => 'Mostrar menys recursos',

    'service-plan.resources.overusePolicy' => 'Directiva de sobreús',
    'service-plan.resources.overusePolicyNotAllowed' => 'No es permet el sobreús',
    'service-plan.resources.overusePolicyNotAllowedHint' => 'No permeti el sobreús de recursos. Si l\'ús de recursos excedeix els valors del límit, una subscripció es suspèn automàticament.',
    'service-plan.resources.overusePolicySoftAllowed' => 'Es permet el sobreús de trànsit i d\'espai al disc',
    'service-plan.resources.overusePolicySoftAllowedHint' => 'Permeti el sobreús de trànsit i d\'espai al disc. No permeti el sobreús d\'altres recursos.',
    'service-plan.resources.overusePolicyAllowed' => 'Es permet el sobreús (no recomanat)',
    'service-plan.resources.overusePolicyAllowedHint' => 'Permeti als clients utilitzar més recursos dels proporcionats inicialment pel pla.',
    'service-plan.resources.overuseNotify' => 'Notificar-me per correu en cas de sobreús.',
    'service-plan.resources.oversellPolicy' => 'Directiva de sobreventa',
    'service-plan.resources.oversellPolicyAllowed' => 'Es permet la sobreventa',
    'service-plan.resources.oversellPolicyAllowedHint' => 'La sobreventa permet a un revenedor vendre més recursos dels que se li han assignat amb un pla. Si es permet, el revenedor es regeix per l\'ús de recursos actual, enlloc de regir-se per l\'assignació inicial de recursos.',
    'service-plan.resources.oversellPolicyNotAllowed' => 'No es permet la sobreventa',
    'service-plan.resources.oversellPolicyNotAllowedHint' => 'Si no es permet, un revenedor només podrà vendre els recursos que se li hagin assignat inicialment amb un plan, sense tenir en compte la quantitat de recursos que estigui utilitzant.',
    'service-plan.resources.mainGroupTitle' => 'Defineixi els recursos proporcionats amb el pla.',
    'service-plan.resources.additionalGroupTitle' => 'Mostrar més recursos disponibles',
    'service-plan.resources.hideMoreResources' => 'Mostrar menys recursos',
    'service-plan.resources.allowSitebuilderUpsell' => 'Permeti al client crear llocs web Presence Builder de prova.',
    'service-plan.resources.allowSitebuilderUpsellDescription' => 'Aquesta opció permet al client crear més llocs web Presence Builder dels proporcionats amb el pla de serveis. Per tal de poder-los publicar, el client haurà de comprar aquests llocs web.',

    'service-plan.servicePlanName' => 'Nom del pla de serveis',
    'service-plan.resellerPlanName' => 'Nom del pla de revenedor',
    'service-plan.addonPlanName' => 'Nom del pla complementari',
    'service-plan.adminPlanPermissionsTab' => 'Eines administratives',
    'service-plan.adminPlanPermissionsTabDescription' => 'Seleccioni les funcions a disposició de l\'administrador quan estigui activat el mode restringit.',
    'service-plan.hostingPermissionsTab' => 'Eines de hosting',
    'service-plan.hostingPermissionsTabDescription' => 'Seleccioni la configuració i les eines de hosting web a disposició de l\'administració en mode de visualització Power User quan estigui activat el mode restringit.',
    'service-plan.resourcesTab' => 'Recursos',
    'service-plan.resourcesTabDescription' => 'Defineixi els recursos proporcionats amb el pla, així com la directiva sobre l\'ús de recursos.',
    'service-plan.subscriptionResourcesTabDescription' => 'Defineixi els recursos proporcionats amb la subscripció, així com la directiva sobre l\'ús de recursos.',
    'service-plan.hostingTab' => 'Paràmetres de hosting',
    'service-plan.hostingTabDescription' => 'Especifiqui els paràmetres del servei de hosting proporcionat amb el pla. Tingui en compte que la configuració de hosting especificada al plan complementari no s\'aplica a aquelles subscripcions a les que el pla complementari o el pla de servei hagi concedit el permís "Gestió de la configuració de hosting".',
    'service-plan.secureSettingsDescription' => 'Si desitja millor la seguretat del hosting proporcionat, %%link%%. Tingui en compte que alguns dels permisos, de concedir-se, permeten als subscriptors modificar aquestes opcions. %%helpLink%%.',
    'service-plan.secureSettingsLink' => 'apliqui la configuració segura predefinida',
    'service-plan.secureSettingsHelpLink' => 'Obtingui més informació sobre l\'opció de hosting segur',
    'service-plan.mailTab' => 'Correu',
    'service-plan.mailTabDescription' => 'Especifiqui els paràmetres del servei de correu proporcionat amb el pla.',
    'service-plan.dnsTab' => 'DNS',
    'service-plan.dnsTabDescription' => 'Especifiqui els paràmetres del servei de DNS proporcionats amb el pla.',
    'service-plan.performanceTab' => 'Rendiment',
    'service-plan.performanceTabDescription' => 'Especifiqui els paràmetres del sistema que afecten al rendiment de tots els serveis proporcionats amb el pla.',
    'service-plan.permissionsTab' => 'Permisos',
    'service-plan.miscTab' => 'Registres i estadístiques',
    'service-plan.miscTabDescription' => 'Especifiqui com s\'haurien d\'emmagatzemar les estadístiques i els registres de les subscripcions del pla. Tingui en compte que aquests paràmetres no es sincronitzen a les subscripcions.',
    'service-plan.miscTabAdminPlanDescription' => 'Especifiqui com s\'haurien d\'emmagatzemar els registres i les estadístiques de les subscripcions.',
    'service-plan.extrasTab' => 'Serveis addicionals',
    'service-plan.extrasTabDescription' => 'Seleccioni els serveis que s\'haurien d\'incloure al pla a més dels serveis de correu, hosting web i DNS.',
    'service-plan.ipTab' => 'Adreces IP',
    'service-plan.ipTabDescription' => 'Defineixi els paràmetres dels recursos IP proporcionats amb el pla.',
    'service-plan.applicationsTab' => 'Aplicacions',
    'service-plan.applicationsTabDescription' => 'Seleccioni les aplicacions que haurien d\'estar disponibles al pla. Pot optar per proporcionar totes les aplicacions disponibles del catàleg d\'aplicacions i aquelles que carregui al servidor o bé seleccionar les aplicacions manualment. Si desitja proporcionar totes les aplicacions disponibles, no haurà de fer res en aquesta pestanya i simplement haurà d\'anar a la pestanya Permisos i seleccionar l\'opció Accés al catàleg d\'aplicacions. Si pel contrari desitja seleccionar les aplicacions manualment, pot fer-ho en aquesta pestanya.',
    'service-plan.applicationsTabDescription-addon' => 'Seleccioni les aplicacions que haurien d\'estar disponibles al complement.',
    'service-plan.applicationsTabDescription-subscription' => 'Seleccioni les aplicacions que haurien d\'estar disponibles a la subscripció. Pot optar per proporcionar totes les aplicacions disponibles del catàleg d\'aplicacions i aquelles que carregui al servidor o bé seleccionar les aplicacions manualment. Si desitja proporcionar totes les aplicacions disponibles, no haurà de fer res en aquesta pestanya i simplement haurà d\'anar a la pestanya Permisos i seleccionar l\'opció Accés al catàleg d\'aplicacions. Si pel contrari desitja seleccionar les aplicacions manualment, pot fer-ho en aquesta pestanya.',
    'service-plan.planSyncSubsriptionWarning' => 'Algunes subscripcions no s\'han sincronitzat amb el pla. Aquestes s\'han marcat com a \'No sincronitzat\' a la llista de subscripcions. Si desitja tornar a provar la sincronització, vagi a la pàgina d\'informació general d\'una subscripció i faci clic al botó Sinc.',
    'service-plan.planSyncResellerWarning' => 'Alguns revenedors no s\'han sincronitzat amb el pla. Aquests s\'han marcat com a \'No sincronitzat\' a la llista de revenedors. Si desitja tornar a provar la sincronització, vagi a la pàgina d\'informació general d\'un revenedor i faci clic al botó Sinc.',
    'service-plan.planSyncAdminWarning' => 'No ha estat possible aplicar els canvis a les subscripcions perquè Plesk no proporciona alguns dels serveis o recursos que es veuen afectats per aquests canvis. Motiu: %%reason%%',
    'service-plan.duplicateName' => 'Ja existeix un pla amb aquest nom.',
    'service-plan.phpSettingsTab' => 'Configuració de PHP',
    'service-plan.phpHandlerNotFound' => 'No ha estat possible recuperar la informació sobre la versió de PHP del pla. Torni a instal·lar-la o seleccioni una altra versió de PHP pel pla de serveis.',
    'service-plan.phpHandlerNotRegistered' => "La versió %%fullVersion%% de PHP no està instal·lada. El scripting PHP pels dominis que utilitzin aquest pla de serveis no estarà disponible. Instal·li PHP <nobr> %%fullVersion%%</nobr> o seleccioni una altra versió de PHP pel pla de serveis.",

    'service-plan.phpSettingsTabDescription' => 'Aquí pot especificar la configuració de PHP per a cadascuna de les subscripcions, que substituirà la configuració establerta per l\'arxiu php.ini a nivell del servidor. Això pot resultar útil, per exemple, en cas que desitgi limitar el consum de recursos del sistema per part dels scripts PHP dels clients. Si es permet, els clients poden substituir aquesta configuració de PHP i fer servir la seva pròpia configuració per domini. Si el valor d\'un paràmetre s\'estableix al valor predeterminat, PHP utilitzarà el valor del paràmetre de la configuració de PHP a nivell del servidor. Tingui en compte que se suporten els següents marcadors: {DOCROOT} i {WEBSPACEROOT} corresponen al directori de l\'arrel del document d\'un domini i al directori arrel d\'una subscripció que obté la configuració personalitzada de PHP; {TMP} correspon al directori on s\'emmagatzemen els arxius temporals. Nota: La configuració següent es pot sobreescriure amb els paràmetres especificats als fitxers .htaccess, php.ini o .user.ini.',
    'service-plan.phpSettingsTabDescriptionAddon' => 'Aquí pot especificar la configuració de PHP per cadascuna de les subscripcions, que invalidarà la configuració definida pel pla de serveis principal. Això pot resultar útil en cas que desitgi eliminar algunes limitacions de PHP establertes al pla de serveis principal. Si el valor d\'un paràmetre s\'estableix al valor predeterminat, PHP utilitzarà el valor del paràmetre de la configuració de PHP del pla de serveis. Tingui en compte que es suporten els següents marcadors: {DOCROOT} i {WEBSPACEROOT} corresponen al directori de l\'arrel del document d\'un domini i al directori arrel d\'una subscripció que obté la configuració personalitzada de PHP; {TMP} correspon al directori on s\'emmagatzemen els arxius temporals.',
    'service-plan.phpSettingsPhpVersion' => 'La seva versió actual de PHP és %%version%%.',
    'service-plan.phpSettingsTabAdminPlanDescription' => 'Aquí pot especificar la configuració de PHP per cadascuna de les subscripcions, que invalidarà la configuració establerta per l\'arxiu php.ini a nivell del servidor. Si el valor d\'un paràmetre s\'estableix al valor predeterminat, PHP utilitzarà el valor del paràmetre de la configuració de PHP a nivell del servidor.',
    'service-plan.webServerSettingsTab' => 'Servidor web',
    'service-plan.webServerSettingsTabDescription' => 'Aquí pot especificar la configuració del servidor web Apache per aquest pla de serveis. Si Apache s\'executa amb nginx com a servidor frontend, aquí també pot especificar la configuració de nginx. La configuració especificada s\'aplicarà a tots els dominis nous. De totes maneres, quan la modifiqui, els canvis no s\'aplicaran als dominis existents.',
    'service-plan.servicesTab' => 'Serveis',
    'service-plan.servicesTabDescription' => 'Aquí pot especificar els serveis assignats al pla de serveis.',
    'service-plan.servicePropertiesTab' => 'Propietats de %%serviceName%%',
    'service-plan.servicePropertiesTabDescription' => 'Aquí pot especificar les propietats del servei %%serviceName%% assignat al pla de serveis.',
    'service-plan.longTaskWarning' => 'En aquest pla té %%subscriptionsCount%% subscripcions. Tingui en compte que la tasca de sincronització pot tardar bastant en completar-se i es realitzarà en segon terme.',
    'service-plan.hostingParametersTab' => 'Paràmetres de hosting',
    'service-plan.adminInfoSection' => 'Informació per l\'administrador',
    'service-plan.descriptionInPanel' => 'Descripció',
    'service-plan.longDescription' => 'La descripció indicada és massa llarga.',
    'service-plan.conflictPermissions' => 'No ha estat possible concedir els permisos detallats a continuació perquè aquests crearan conflictes amb el pla del revenedor: %%permissions%%.',

    'services.change-startup-type.startupTypeLabel' => 'Tipus d\'inici',
    'services.change-startup-type.autoStartupTypeLabel' => 'Automàtica',
    'services.change-startup-type.manualStartupTypeLabel' => 'Manual',
    'services.change-startup-type.disabledStartupTypeLabel' => 'Desactivar',
    'services.change-startup-type.autoActionError' => 'No ha estat possible establir el tipus d\'inici a \'auto\': %%error%%',
    'services.change-startup-type.manualActionError' => 'No ha estat possible establir el tipus d\'inici a \'manual\': %%error%%',
    'services.change-startup-type.disableActionError' => 'No ha estat possible establir el tipus d\'inici a \'desactivat\': %%error%%',

    'sessions.settings.restoreDefaultButton' => 'Restablir al valor per defecte',
    'sessions.settings.restoreDefaultButtonDescription' => 'Restauri els paràmetres de la sessió als valors predeterminats.',
    'sessions.settings.restoreDefaultButtonDescriptionDisable' => 'Els paràmetres de la sessió presenten els valors predeterminats.',
    'sessions.settings.idleTime' => 'Temps d\'inactivitat de la sessió',
    'sessions.settings.disableCheckSessionIp' => 'Permetre efectuar canvis d\'adreça IP durant una única sessió',
    'sessions.settings.minuteShortTitle' => 'min',

    'settings-ui.controls.title' => 'Controls',

    'settings-ui.interface-views.description' => "Posem a la seva disposició varies modes de visualització de la interfície d'usuari del producte. En funció del mode escollit, les funcions i opcions pot ser que es trobin en ubicacions diferents, podent fins i tot estar activats o desactivats. La finalitat dels diferents modes de visualització és adaptar-se millor al diferents perfils d'usuari.",
    'settings-ui.interface-views.panelSimpleLink' => 'Eines i configuració> Configuració del mode restringit',
    'settings-ui.interface-views.useCustomView' => 'Activar el mode restringit',
    'settings-ui.interface-views.useCustomViewHint' => 'Seleccioni aquesta opció si desitja limitar el número d\'accions que pot efectuar l\'administrador a Plesk. Per tal de canviar la disponibilitat de les accions, vagi a %%customViewSettingsLink%%.',
    'settings-ui.interface-views.powerUserViewHint' => 'Aquesta vista és la més apropiada per la gestió de llocs web, els seus arxius, bases de dades, comptes de correu electrònic, aplicacions web i d\'altres serveis.',
    'settings-ui.interface-views.selectUiModeTitle' => "Selecció de la seva interfície",
    'settings-ui.interface-views.uiModeTitlePowerUser' => "Vista Power User (per desenvolupadors i agències web)",
    'settings-ui.interface-views.uiModeTitleServiceProvider' => "Vista de proveïdor de serveis (per proveïdors de hosting web)",
    'settings-ui.interface-views.uiModeHintServiceProvider' => 'Aquesta vista va dirigida a administradors de servidor que proporcionen i venen serveis de hosting web als seus clients mitjançant plans de serveis.',
    'settings-ui.interface-views.visibilityMailBounce' => 'Amagar controls de devolució',
    'settings-ui.interface-views.visibilityMailBounceHint' => 'Amaga el botó que permet configurar com processar els correus enviats a adreces inexistents',

    'settings-ui.branding.description' => 'Personalitzi la interfície de Plesk canviant la manera en què es mostra la pàgina a la barra de nom del navegador i/o substituint el logo de Plesk present a la cantonada superior esquerra.',
    'settings-ui.branding.buttonDefault' => 'Logo predeterminat',
    'settings-ui.branding.sectionTitle' => 'Nom personalitzat',
    'settings-ui.branding.enableCustomTitle' => 'Habiliti un nom personalitzat a les pàgines de Plesk',
    'settings-ui.branding.customTitle' => 'Text del títol',
    'settings-ui.branding.sectionLogo' => 'Logo personalitzat',
    'settings-ui.branding.enableCustomLogo' => 'Habiliti un logo personalitzat pel panell',
    'settings-ui.branding.logo' => 'Arxiu de logo',
    'settings-ui.branding.logoUrl' => 'URL del logo',
    'settings-ui.branding.logoUrlEnabled' => 'Personalitzat',
    'settings-ui.branding.logoUrlDisabled' => 'Predeterminat',
    'settings-ui.branding.sectionFavicon' => 'Favicon personalitzat',
    'settings-ui.branding.enableCustomFavicon' => 'Habiliti un favicon personalitzat',
    'settings-ui.branding.sectionFaviconDesc' => 'El mateix favicon s\'ha de carregar en ambdós formats per així gaudir d\'un millor suport als diversos navegadors.',
    'settings-ui.branding.faviconSvg' => 'SVG d\'arxiu de favicon',
    'settings-ui.branding.faviconSvgHint' => 'Format permès: SVG',
    'settings-ui.branding.faviconIco' => 'ICO d\'arxiu de favicon',
    'settings-ui.branding.faviconIcoHint' => 'Format permès: ICO',
    'settings-ui.branding.show' => 'Mostrar',
    'settings-ui.branding.updateSuccess' => 'Les propietats de personalització de Plesk han estat modificades.',
    'settings-ui.branding.sectionBackground' => 'Fons de pantalla d\'inici de sessió personalitzat',
    'settings-ui.branding.enableCustomBackground' => 'Permetre imatge de fons',
    'settings-ui.branding.backgroundFile' => 'Imatge de fons',
    'settings-ui.branding.backgroundColor' => 'Color del fons',
    'settings-ui.branding.backgroundResetColor' => 'Restablir',
    'settings-ui.branding.backgroundFit' => 'Disseny del fons',
    'settings-ui.branding.background.fit.fill' => 'Omplir la pantalla',
    'settings-ui.branding.background.fit.fit' => 'Adaptar a la pantalla',
    'settings-ui.branding.background.fit.center' => 'Centrar',
    'settings-ui.branding.background.fit.tile' => 'Mosaic',

    'sitebuilder.trial.description' => 'Aquí pot configurar el mode Provar i comprar, anteriorment anomenat escenari d\'adquisició de clients. En aquest mode, el client pot crear un lloc web totalment funcional a l\'aplicació Presence Builder inclosa. De totes maneres, els clients no poden publicar els llocs web de prova fins que no contractin un pla de serveis de hosting o un complement pel pla. El mode Provar i comprar també es pot oferir als seus clients existents a través d\'un pla de hosting o un complement de pla. %%link%%',
    'sitebuilder.trial.descriptionLink' => 'Si desitja més informació, consulti la documentació.',
    'sitebuilder.trial.lifetimeLabel' => 'Durada del lloc web de prova',
    'sitebuilder.trial.lifetimeUnits' => 'dies',
    'sitebuilder.trial.lifetimeDescription' => 'Es tracta del tems que ha de passar abans que aquests llocs web de prova que no hagin estat comprats pels clients siguin eliminats del servidor.',
    'sitebuilder.trial.signupLabel' => 'Activar accés públic al mode de prova',
    'sitebuilder.trial.signupDescription' => 'Si desitja captar clients fent publicitat del hosting amb Presence Builder i proporcionant una demo, activi l\'accés públic al mode de prova i publiqui l\'URL d\'accés al mode de prova al seu lloc web.',
    'sitebuilder.trial.signupLinkLabel' => 'URL d\'accés al mode de prova',
    'sitebuilder.trial.signupLinkDescription' => 'Aquesta URL obrirà Presence Builder en mode de prova. Publiqui-la al seu lloc web per així promocionar el hosting amb Presence Builder i ampliar la seva cartera de clients.',
    'sitebuilder.trial.promotionLabel' => 'Mostrar una notificació sobre el mode de prova a l\'editor de Presence Builder',
    'sitebuilder.trial.promotionDescription' => 'Utilitzi aquesta opció si desitja mostrar una notificació addicional sobre l\'ús de Presence Builder en mode de prova.',

    'update-settings.policyHintForPum' => 'Aquí pot configurar la instal·lació automàtica d\'actualitzacions. El correu de notificació es pot enviar quan hi hagi actualitzacions que calgui instal·lar de forma manual o quan se n\'hagin instal·lat de forma automàtica.',
    'update-settings.policyHint' => 'El correu de notificació es pot enviar quan hi hagi actualitzacions que calgui instal·lar de forma manual o quan se n\'hagin instal·lat de forma automàtica.',
    'update-settings.branchDisabledDescription' => 'No notificar-me sobre l\'existència d\'actualitzacions',
    'update-settings.automaticPatchesInstallation' => 'Instal·lat les actualitzacions de Plesk automàticament (Recomanat)',
    'update-settings.automaticPatchesThirdParty' => 'Instal·lar automàticament les actualitzacions de components de tercers inclosos a Plesk',
    'update-settings.automaticSystemPackageUpdates' => 'Instal·lar automàticament les actualitzacions de paquets del sistema',
    'update-settings.automaticSystemPackageUpdatesHint' => 'Tingui en compte que això instal·larà automàticament actualitzacions dels components de tercers inclosos a Plesk',
    'update-settings.installerProxyMode' => 'Accedeix a Plesk Installer a través del port i el nom de host de Plesk',
    'update-settings.installerProxyModeHint' => 'Accedeix a la interfície web de Plesk Installer sense haver d\'obrir un port TCP 8447 addicional al firewall.',
    'update-settings.automaticPatchesNotification' => 'Notificar-me sobre les actualitzacions de paquets de sistema disponibles i instal·lades',
    'update-settings.systemPackageUpdatesNotificationsEmail' => 'Adreça de correu',
    'update-settings.systemPackageUpdatesNotificationsPeriod' => 'Freqüència d\'enviament del correu de notificació',
    'update-settings.daily' => 'Cada dia',
    'update-settings.weekly' => 'Cada setmana',
    'update-settings.generalSection' => 'General',
    'update-settings.notificationsSection' => 'Notificacions',
    'update-settings.safeUpdatesSection' => 'Actualitzacions segures',
    'update-settings.safeUpdatesSectionHint' => 'Plesk s\'encarrega que les actualitzacions de paquets del sistema s\'instal·lin des del mateix repositori des d\'on inicialment es van instal·lar els paquets. Aquest tipus d\'actualitzacions es consideren segures. Si les desactiva, és possible que el seu administrador de paquets del sistema instal·li actualitzacions des de qualsevol repositori del sistema.',
    'update-settings.safeUpdatesSectionWarn' => 'A menys que sigui un usuari avançat, li recomanem deixar activades les actualitzacions segures. Les actualitzacions indiscriminades dels paquets del sistema des d\'altres repositoris pot afectar negativament al funcionament del seu servidor.',
    'update-settings.allowSafeUpdates' => 'Activar actualitzacions segures pels paquets del sistema',

    'requiredFields' => 'Camps obligatoris',

    'ip-ban.banned-ip.ipAddress' => 'Adreça IP',
    'ip-ban.banned-ip.hintIpAddress' => 'Una adreça IP o una màscara CIDR.',
    'ip-ban.banned-ip.banType' => 'Prohibir l\'adreça IP: ',
    'ip-ban.banned-ip.banType_plesk-one-week-ban' => 'Durant una setmana',
    'ip-ban.banned-ip.banType_plesk-permanent-ban' => 'Permanentment',
];