<?php
// Copyright 1999-2024. WebPros International GmbH. All rights reserved.
$messages = [
    'additional-keys.keyNumber' => 'Sleutelnummer',
    'additional-keys.keyName' => 'Sleutelnaam',
    'additional-keys.keyApp' => 'Toepassing',
    'additional-keys.addGroup' => 'Toevoegen',
    'additional-keys.upload' => 'Nieuwe sleutel installeren',
    'additional-keys.uploadDescription' => 'Een nieuwe licentiesleutel uploaden en installeren.',
    'additional-keys.actionsGroup' => 'Acties',
    'additional-keys.install' => 'Installeren',
    'additional-keys.installAll' => 'Alles installeren',
    'additional-keys.installDescription' => 'Geselecteerde licentiesleutels installeren.',
    'additional-keys.installNoSelection' => 'Selecteer een of meer aanvullende licentiesleutels om te installeren, of klik op "Alles installeren".',
    'additional-keys.installSuccess' => 'Installatie van licentiesleutel is gestart.',
    'additional-keys.removeGroup' => 'Verwijderen',
    'additional-keys.remove' => 'Verwijderen',
    'additional-keys.removeDescription' => 'De geselecteerde licentiesleutels verwijderen.',
    'additional-keys.removeNoSelection' => 'Selecteer een of meer aanvullende licentiesleutels om te verwijderen.',
    'additional-keys.removeConfirmation' => 'Wilt u {count, plural, =1 {de licentiesleutel {name}} one {de # geselecteerde licentiesleutel} other {de # geselecteerde licentiesleutels}} wilt verwijderen?',
    'additional-keys.removeSuccess' => 'Geselecteerde licentiesleutels zijn verwijderd.',
    'additional-keys.download' => 'Sleutel downloaden',
    'additional-keys.downloadDescription' => 'Download de licentiesleutel.',
    'additional-keys.emptyViewTitle' => 'Geen aanvullende licentiesleutels',

    'backup.tasks.startDate' => 'Gestart om',
    'backup.tasks.targetRepo' => 'Doelopslag',
    'backup.tasks.progress' => 'Voortgang van taak',
    'backup.tasks.repoTypeLocal' => 'Server',
    'backup.tasks.repoTypeFtp' => 'Persoonlijke FTP',
    'backup.tasks.buttonRemoveTask' => 'Verwijderen',
    'backup.tasks.hintRemoveTask' => 'De geselecteerde geplande reservekopieën verwijderen.',
    'backup.tasks.buttonReload' => 'Opnieuw laden',
    'backup.tasks.hintReload' => 'De takenlijst opnieuw laden om de huidige status te achterhalen.',
    'backup.tasks.statusTaskWarnings' => 'Waarschuwingen',
    'backup.tasks.statusTaskInfo' => 'Informatie',
    'backup.tasks.statusTaskFailed' => 'Mislukt',

    'backup.disabledSelectHint' => 'De reservekopie kan niet worden verwijderd omdat deze deel uitmaakt van de reservekopie op server-, reseller- of cliënt-niveau.',
    'backup.buttonBackup' => 'Reservekopieën',
    'backup.hintBackup' => 'Een reservekopie maken.',
    'backup.buttonSchedule' => 'Rooster',
    'backup.hintSchedule' => 'Geef instellingen op voor ingeroosterde reservekopie.',
    'backup.buttonReload' => 'Opnieuw laden',
    'backup.hintReload' => 'De lijst met reservekopieën opnieuw laden.',
    'backup.buttonUpload' => 'Uploaden',
    'backup.hintUpload' => 'Upload een reservekopie vanaf uw computer naar de opslag van reservekopieën op de server.',
    'backup.buttonSettings' => 'Instellingen',
    'backup.hintSettings' => 'De algemene instellingen voor reservekopieën instellen om de belasting van de processor van de server te verlagen.',
    'backup.buttonRemoteStorages' => 'Instellingen externe opslag',
    'backup.hintRemoteStorages' => 'Stel uw persoonlijke externe opslag in voor het opslaan van reservekopieën.',
    'backup.buttonRemove' => 'Verwijderen',
    'backup.hintRemove' => 'Geselecteerde reservekopieën verwijderen uit de opslag van de server.',
    'backup.systemNotes' => 'Systeem-opmerkingen',
    'backup.incremental' => 'Incrementeel.',
    'backup.multiVolume' => 'Meerdelig.',
    'backup.remoteStorage' => 'In de opslag:%%storage%%',
    'backup.status' => 'S',
    'backup.statusOff' => 'Dit is geen geldige reservekopie. Gegevens uit dit bestand kunnen niet worden teruggeplaatst. Klik op de naam van de reservekopie voor meer details.',
    'backup.statusWarning' => 'Deze reservekopie is niet geheel intact. Klik op de naam van de reservekopie voor meer details.',
    'backup.statusInfo' => 'Dit is een geldige reservekopie. Gegevens van deze reservekopie kunnen worden teruggeplaatst, maar er kunnen kleine problemen optreden in de manier waarop de data wordt opgeslagen.',
    'backup.statusOn' => 'Dit is een geldige reservekopie. Gegevens kunnen vanuit deze reservekopie worden teruggeplaatst.',
    'backup.date' => 'Datum van aanmaken',
    'backup.name' => 'Naam',
    'backup.comment' => 'Opmerkingen',
    'backup.size' => 'Grootte',
    'backup.download' => 'Download reservekopie naar uw lokale computer.',
    'backup.downloadDisabled' => 'Het is tijdelijk niet mogelijk om de reservekopie te downloaden. Probeert u het later opnieuw of neem contact op met uw provider.',
    'backup.total' => 'Totaal reservekopieën: %%total%%, grootte: %%totalSize%%',
    'backup.totalFound' => '%%found%% reservekopieën gevonden (%%total%% totaal), grootte: %%totalSize%%',
    'backup.confirmOnDelete' => 'Wilt u de geselecteerde reservekopieën verwijderen?',
    'backup.incrementsRemovalLoading' => 'Bezig met laden...',
    'backup.incrementsRemovalConfirmation' => 'Ik bevestig dat ik de geselecteerde reservekopieën wil verwijderen.',
    'backup.backupHasIncrements' => 'De reservekopie %%backupName%% zal samen met de incrementele reservekopieën worden verwijderd: %%backupIncrements%%',
    'backup.ftpStorage' => 'FTP',
    'backup.ftpStorageErrorCredentials' => 'Onjuiste gebruikersnaam of wachtwoord voor FTP-opslag',
    'backup.ftpStorageErrorResolveHost' => "Kan de hostnaam niet opzoeken",
    'backup.ftpStorageErrorConnection' => "Kan geen verbinding maken met de externe server",
    'backup.unableToGetFtpDumpList' => 'Kan de lijst met reservekopieën in de FTP-opslag niet weergeven: %%errorMessage%%. Controleer de <a href="%%ftpSettingsUrl%%">instellingen van de FTP-opslag</a>.',
    'backup.unableToGetExtDumpList' => 'Kan de lijst met reservekopieën in de opslag %%storageTitle%% niet weergeven: %%errorMessage%%. Controleer de opslag-instellingen.',
    'backup.unableToGetLocalDumpList' => 'Kan de lijst met reservekopieën op de server niet weergeven: %%errorMessage%%',
    'backup.skippedFilesAtExtStorage' => 'Een aantal van de bestanden in de opslag %%storageTitle%% worden niet in de lijst weergegeven, omdat de namen van deze bestanden niet voldoen aan de naamconventies voor reservekopieën.Als u zeker weet dat deze bestanden geldige reservekopieën zijn, wijzig dan hun naam zo, dat ze in overeenstemming zijn met het volgende patroon:"backup_%%objectName%%&lt;YYMMDDHHmm&gt;.%%ext%%"',
    'backup.multiVolumeShow' => 'Volumes weergeven',
    'backup.multiVolumeHide' => 'Volumes verbergen',
    'backup.backEncryptionRequired' => 'Om veiligheidsredenen raden wij aan uw gevoelige data af te schermen door alleen beveiligde reservekopieën te gebruiken. Ga naar %%link%% en pas de beveiligingsinstellingen voor reservekopieën aan.',
    'backup.backupSettingPage' => 'Instellingen reservekopieën',
    'backup.statusTaskProgress' => 'Het reservekopie-taak wordt aangemaakt.',
    'backup.statusTaskWarnings' => 'Het maken of terugplaatsen van de reservekopie is voltooid, maar met waarschuwingen.',
    'backup.statusTaskInfo' => 'Informatie.',
    'backup.statusTaskFailed' => 'Het reservekopie-taak is mislukt.',
    'backup.statusTaskStopping' => 'Het maken of terugplaatsen van een reservekopie wordt nu stopgezet.',
    'backup.statusTaskStopped' => 'Het maken of terugplaatsen van een reservekopie is gestopt.',

    'backup.schedule.columnSchedule' => 'Rooster',
    'backup.schedule.columnContent' => 'Inhoud',
    'backup.schedule.columnStorage' => 'Opslag',
    'backup.schedule.periodHourly' => 'Vaste uur-interval',
    'backup.schedule.periodHourlySchedule' => 'elke {period, plural, one {# uur} other {# uur}}',
    'backup.schedule.periodDaily' => 'Dagelijks',
    'backup.schedule.periodDailySchedule' => 'om %%hours%%:%%minutes%%',
    'backup.schedule.periodWeekly' => 'Wekelijks',
    'backup.schedule.periodWeeklySchedule' => 'op %%day%% om %%hours%%:%%minutes%%',
    'backup.schedule.periodMonthly' => 'Maandelijks',
    'backup.schedule.periodMonthlySchedule' => 'op %%day%% om %%hours%%:%%minutes%%',
    'backup.schedule.periodCustom' => 'Aangepast',
    'backup.schedule.dayFirst' => 'eerste',
    'backup.schedule.dayLast' => 'laatste',
    'backup.schedule.day' => '{day, selectordinal, other {#}}',
    'backup.schedule.storageLocal' => 'Server-opslag',
    'backup.schedule.storageBoth' => 'Zowel serveropslag als %%remoteStorage%%',
    'backup.schedule.deactivateSuccess' => 'Ingeroosterde reservekopie is uitgeschakeld',

    'custombuttons.buttonAdd' => 'Link naar dienst toevoegen',
    'custombuttons.buttonAddDescription' => 'Een link naar een online dienst toevoegen en in Plesk plaatsen.',
    'custombuttons.buttonRemove' => 'Verwijderen',
    'custombuttons.buttonRemoveDescription' => 'De geselecteerde links verwijderen.',
    'custombuttons.removeConfirmMessage' => 'Wilt u de geselecteerde links verwijderen?',
    'custombuttons.headerPublic' => 'A',
    'custombuttons.headerLocation' => 'L',
    'custombuttons.headerImage' => 'Afbeelding',
    'custombuttons.headerPriority' => 'Prioriteit',
    'custombuttons.headerLabel' => 'Label',
    'custombuttons.headerUrl' => 'URL',
    'custombuttons.headerDescription' => 'Omschrijving',
    'custombuttons.publicEnabledDescription' => 'De link is zichtbaar voor gebruikers.',
    'custombuttons.publicDisabledDescription' => 'De link is niet zichtbaar voor gebruikers.',
    'custombuttons.altPublicEnabledIcon' => 'Openbaar',
    'custombuttons.altPublicDisabledIcon' => 'Privaat',
    'custombuttons.placeNavigationDescription' => 'De link is zichtbaar op alle pagina\'s.',
    'custombuttons.placeAdminDescription' => 'De link is zichtbaar op de startpagina van de beheerder.',
    'custombuttons.placeAdminSettingsDescription' => 'De link bevindt zich op de pagina Hulpprogramma\'s & instellingen van de beheerder.',
    'custombuttons.placeResellerDescription' => 'De link is zichtbaar op de startpagina van reseller',
    'custombuttons.placeResellerSettingsDescription' => 'De link bevindt zich op de pagina Hulpprogramma\'s van de reseller.',
    'custombuttons.placeClientDescription' => 'De link is zichtbaar op de startpagina van de cliënt.',
    'custombuttons.placeDomainDescription' => 'De link is zichtbaar op de pagina Websites & domeinen van het abonnement.',
    'custombuttons.placeDomainPropertiesDescription' => 'De link bevindt zich in het overzicht van de website-instellingen, die u kunt openen vanaf de pagina Websites & domeinen door te klikken op Meer weergeven onderaan een domeinnaam.',

    'databaseservers.addGroup' => 'Toevoegen',
    'databaseservers.addDatabaseServer' => 'Database-server toevoegen',
    'databaseservers.addDatabaseServerDescription' => 'Een database-server toevoegen.',
    'databaseservers.addDatabaseServerDescriptionDisabledByKey' => 'Externe databasehosting wordt niet ondersteund door de licentiesleutel.',
    'databaseservers.actionsGroup' => 'Acties',
    'databaseservers.hostingSettings' => 'Instellingen',
    'databaseservers.hostingSettingsDescription' => 'Instellingen databasehosting.',
    'databaseservers.refresh' => 'Vernieuwen',
    'databaseservers.refreshDescription' => 'Informatie over database-servers opnieuw ophalen.',
    'databaseservers.removeGroup' => 'Verwijderen',
    'databaseservers.remove' => 'Verwijderen',
    'databaseservers.removeDescription' => 'De geselecteerde database-servers verwijderen.',
    'databaseservers.lastError' => 'S',
    'databaseservers.type' => 'Servertype',
    'databaseservers.host' => 'Hostnaam',
    'databaseservers.hostLink' => 'De eigenschappen van de database-server bekijken of aanpassen.',
    'databaseservers.port' => 'Poort',
    'databaseservers.version' => 'versie',
    'databaseservers.databasesCount' => 'Databases',
    'databaseservers.databasesCountLink' => 'De op deze server gehoste database beheren.',
    'databaseservers.databaseUpgradeLink' => 'Upgrade de databaseserver die op deze server wordt gehost.',
    'databaseservers.databasesLTSVersion' => 'U beschikt al over de LTS-versie. Plesk zal uw MariaDB/MySQL-installatie automatisch bijwerken naar nieuwe puntreleases.',
    'databaseservers.webadmin' => 'Webadmin',
    'databaseservers.webadminHint' => 'Toegang tot deze server via DB Webadmin.',
    'databaseservers.downloadMsSqlClient' => 'Een lokale SQL-client downloaden',
    'databaseservers.downloadMsSqlClientHint' => 'Een lokale SQL-client downloaden',
    'databaseservers.changePassword' => 'Beheerderwachtwoord wijzigen',
    'databaseservers.changePasswordHint' => 'Wachtwoord van beheerder database-server wijzigen.',
    'databaseservers.mysql' => 'MySQL',
    'databaseservers.mssql' => 'Microsoft SQL-server',
    'databaseservers.postgresql' => 'PostgreSQL',
    'databaseservers.mariadb' => 'MariaDB',
    'databaseservers.percona' => 'Percona',
    'databaseservers.default_for_mysql' => 'standaard voor MySQL',
    'databaseservers.default_for_mssql' => 'standaard voor MS SQL',
    'databaseservers.default_for_postgresql' => 'standaard voor PostgreSQL',
    'databaseservers.default_for_mariadb' => 'standaard voor MariaDB',
    'databaseservers.default_for_percona' => 'standaard voor Percona',
    'databaseservers.status_no_error' => 'De laatste poging om met deze server te verbinden was succesvol.',
    'databaseservers.status_connection_failed' => 'De laatste poging om met deze server te verbinden mislukte vanwege netwerkproblemen.',
    'databaseservers.status_permission_denied' => 'Tijdens de laatste poging om verbinding met deze server te maken is de toegang geweigerd. Controleer de aanmeldgegevens van de beheerder voor de server.',
    'databaseservers.status_other_error' => 'Tijdens de laatste poging om verbinding met deze server te maken is een fout opgetreden.',
    'databaseservers.status_credentials_not_set' => 'U moet een geldige gebruikersnaam en wachtwoord van een beheerder opgeven voordat Plesk verbinding met deze server kan maken.',
    'databaseservers.mssqlServerPortUndefined' => 'Kan het TCP-poortnummer dat wordt gebruikt door Microsoft SQL-server \'%%host%%\' niet vaststellen: het TCP/IP-protocol is niet ingeschakeld in de netwerkconfiguratie van de server, of de server is ingesteld om dynamische TCP-poorten te gebruiken.',
    'databaseservers.mssqlServerPortUndefinedHint' => 'Om uw klanten de mogelijkheid te geven de firewall automatisch in te stellen voor externe toegang tot de database, moet u de SQL-server handmatig configureren om te luisteren op een specifieke, vaste TCP-poort.',
    'databaseservers.removeEmptySelection' => 'Geen database servers geselecteerd.',
    'databaseservers.removeConfirmation' => 'Weet u zeker dat u {count, plural, =1 {de database-server {name}} one {de # geselecteerde database-server} other {de # geselecteerde database-servers}} wilt verwijderen?',
    'databaseservers.removeSuccess' => 'Het verwijderen van de geselecteerde database-servers is geslaagd.',
    'databaseservers.upgradeNow' => 'Nu upgraden',


    'databaseserverdatabases.actionsGroup' => 'Acties',
    'databaseserverdatabases.assignToSubscription' => 'Naar abonnement verplaatsen',
    'databaseserverdatabases.assignToSubscriptionDescription' => 'De geselecteerde databases verplaatsen naar een ander abonnement.',
    'databaseserverdatabases.removeGroup' => 'Verwijderen',
    'databaseserverdatabases.remove' => 'Verwijderen',
    'databaseserverdatabases.removeDescription' => 'De geselecteerde databases verwijderen.',
    'databaseserverdatabases.name' => 'Naam',
    'databaseserverdatabases.subscription' => 'Abonnement',
    'databaseserverdatabases.client' => 'Abonnementhouder',
    'databaseserverdatabases.manageDatabase' => 'Hostingbeheer',
    'databaseserverdatabases.manageDatabaseDescription' => 'De database beheren.',
    'databaseserverdatabases.manageDatabaseInResellerPanel' => 'Openen in Reseller Panel',
    'databaseserverdatabases.manageDatabaseInResellerPanelDescription' => 'Beheer de database in het Reseller Panel van de abonnementhouder.',
    'databaseserverdatabases.manageDatabaseInCustomerPanel' => 'Openen in Hostingbeheer',
    'databaseserverdatabases.manageDatabaseInCustomerPanelDescription' => 'Beheer de database in Hostingbeheer van de abonnementhouder.',
    'databaseserverdatabases.emptySelection' => 'Geen databases geselecteerd.',
    'databaseserverdatabases.removeConfirmation' => 'Weet u zeker dat u {count, plural, =1 {de database {name}} one {de # geselecteerde database} other {de # geselecteerde databases}} wilt verwijderen?',
    'databaseserverdatabases.removeSuccess' => 'Het verwijderen van de geselecteerde database-servers is geslaagd.',

    'logbrowser.issuesFoundInTheLogs' => 'Problemen in de logs van de website',
    'logbrowser.learnAboutProblemsFaster' => 'Merk problemen met de website sneller op',
    'logbrowser.noProblemsFound' => 'Geen problemen in de logs van de website',
    'logbrowser.lastCheckDetectsProblems' => '%%checkType%%-controle van de logboeken heeft vastgesteld dat er problemen zijn die het goed functioneren van uw website kunnen belemmeren. Voor details en mogelijke oplossingen klikt u op "Controlerapport openen".',
    'logbrowser.lastCheckDetectsNoProblems' => '%%checkType%%-controle van het logboek heeft geen problemen gevonden die het goed functioneren van uw website in de weg staan.',
    'logbrowser.noChecksResults' => 'Er is een dagelijkse geautomatiseerde controle ingeschakeld, maar er zijn geen controles uitgevoerd.',
    'logbrowser.manual' => 'Een handmatige',
    'logbrowser.regular' => 'Een dagelijkse geautomatiseerde',
    'logbrowser.enableRegularCheck' => 'Een dagelijkse controle van de logboeken stelt vast of er problemen zijn die het juist functioneren van uw website in de weg kunnen staan. Als er problemen worden aangetroffen zal Plesk u informeren en wijzen op mogelijke oplossingen.',
    'logbrowser.new' => 'NIEUW',
    'logbrowser.openCheckReport' => 'Controleverslag openen',
    'logbrowser.openCheckSettings' => 'Controle-instellingen openen',

    'logbrowser.buttonStartRealtime' => 'Real-time updates starten',
    'logbrowser.buttonStartRealtimeHint' => 'Loggegevens in real-time bijwerken.',
    'logbrowser.buttonStopRealtime' => 'Real-time updates stoppen',
    'logbrowser.buttonStopRealtimeHint' => 'Loggegevens niet langer in real-time bijwerken.',
    'logbrowser.buttonRefresh' => 'Vernieuwen',
    'logbrowser.buttonRefreshHint' => 'Loggegevens vernieuwen.',
    'logbrowser.buttonClear' => 'Wissen',
    'logbrowser.buttonClearHint' => 'Reeds geladen ingangen verbergen.',
    'logbrowser.buttonAddCustom' => 'Als aangepast bestand toevoegen aan logbrowser',
    'logbrowser.buttonAddCustomHint' => 'Het bestand zal worden weergegeven in de Logbrowser, samen met andere logbestanden.',
    'logbrowser.date' => 'Datum',
    'logbrowser.dateFilterPlaceholder' => 'Van',
    'logbrowser.type' => 'Type',
    'logbrowser.ip' => 'IP',
    'logbrowser.ipFilterPlaceholder' => 'IP',
    'logbrowser.code' => 'Code',
    'logbrowser.codeFilterPlaceholder' => 'Code',
    'logbrowser.message' => 'Bericht',
    'logbrowser.messageFilterPlaceholder' => 'Bericht',
    'logbrowser.source' => 'Bron',
    'logbrowser.sourceFilterFiles' => '%%count%% bestanden',
    'logbrowser.sourceFilterAllLogs' => 'Alle logbestanden',
    'logbrowser.sourceFilterNoLogs' => 'Geen logbestanden',
    'logbrowser.manageLogFiles' => 'Logbestanden beheren',
    'logbrowser.addCustomLogFile' => 'Aangepast logbestand toevoegen',
    'logbrowser.customLogPopupTitle' => 'Aangepast logbestand toevoegen',
    'logbrowser.invalidLogFormat' => 'Het logbestand heeft een niet-ondersteunde notatie',
    'logbrowser.referer' => 'R',
    'logbrowser.refererHint' => 'Verwijzende site',
    'logbrowser.agent' => 'Agent',
    'logbrowser.agentHint' => 'Gebruikersagent',
    'logbrowser.size' => 'Grootte',
    'logbrowser.unknown' => 'Onbekend',
    'logbrowser.more' => 'Meer',
    'logbrowser.less' => 'Minder',
    'logbrowser.any' => 'Alle',
    'logbrowser.none' => 'Geen',
    'logbrowser.loadMoreOrUseFilters' => '%%loadMore%% of gebruik de filters om de lijst met ingangen te verkleinen.',
    'logbrowser.loadMore' => 'Voorgaande ingangen laden',
    'logbrowser.clear' => 'Wissen',
    'logbrowser.hourAgo' => 'Uur geleden',
    'logbrowser.prevDay' => 'Vorige dag',
    'logbrowser.linkInMessageToViewFile' => 'Klik om het bestand te bekijken.',
    'logbrowser.buttonUnlinkHint' => 'Klik als u niet langer updates van dit bestand in de Logbrowser wilt bijhouden',
    'logbrowser.buttonUnlinkConfirmationDescription' => 'Weet u zeker dat u updates van dit bestand niet langer in de Logbrowser wilt bijhouden?',
    'logbrowser.buttonUnlinkConfirmationYes' => 'Ja',
    'logbrowser.buttonUnlinkConfirmationNo' => 'Nee',
    'logbrowser.logRotation' => 'Logopschoning',
    'logbrowser.logRotationHint' => 'De instellingen voor logrotatie van de website configureren.',
    'logbrowser.logRotationTitle' => 'Logopschoning instellen',

    'notifications.title' => 'Versturen van meldingen per e-mail bij systeemevents instellen',
    'notifications.legendNotifications' => 'Meldingen',
    'notifications.legendSettings' => 'Instellingen',
    'notifications.headerEvent' => 'Event',
    'notifications.headerSendTo' => 'Melding versturen aan:',
    'notifications.headerText' => 'Tekst',
    'notifications.headerPreview' => 'Voorbeeld',
    'notifications.headerAdmin' => 'Beheerder',
    'notifications.headerReseller' => 'Reseller',
    'notifications.headerClient' => 'Cliënt',
    'notifications.headerEmailAddress' => 'E-mailadres',
    'notifications.expirationTime' => 'Waarschuwing versturen voor verlopen',
    'notifications.days' => 'aantal dagen van tevoren',
    'notifications.smtpSettings' => 'Om Plesk meldingen te laten versturen ook wanneer de relay is gesloten, kunt u %%link%%',
    'notifications.smtpSettingsLink' => 'de SMTP-instellingen wijzigen',
    'notifications.editHint' => 'De tekst van de melding bewerken.',
    'notifications.previewHint' => 'Bekijk hoe de melding er in e-mails uitziet.',
    'notifications.reseller_creation' => 'Aanmaken van reselleraccounts',
    'notifications.reseller_limits_exceed' => 'Beperking van verbruikte middelen overschreden door reselleraccount',
    'notifications.reseller_blocked' => 'Reselleraccount is opgeschort vanwege te hoog verbruik van middelen',
    'notifications.reseller_overuse_block' => 'De verbruiksbeperking van de reseller is bereikt door de abonnementen van de reseller vanwege meerverkoop',
    'notifications.client_creation' => 'Aanmaken van cliëntaccounts',
    'notifications.domain_creation' => 'Site aanmaken',
    'notifications.domain_exp_warning' => 'Waarschuwing bij vervallen van pakket',
    'notifications.domain_expiration' => 'Pakket is verlopen',
    'notifications.domain_limits_exceed' => 'Beperkingen van het verbruik overschreden door abonnement',
    'notifications.domain_blocked' => 'Pakket opgeschort wegens te hoog verbruik van middelen',
    'notifications.admin_aps_app_updates' => 'Updates van APS-toepassingen (samenvatting voor beheerder)',
    'notifications.reseller_aps_app_updates' => 'Updates van APS-toepassingen (samenvatting voor reseller)',
    'notifications.client_aps_app_updates' => 'Updates van APS-toepassingen (samenvatting voor cliënt)',
    'notifications.admin_pum_updates' => 'Systeemupdates: meldingen over nieuwe updates',
    'notifications.admin_outgoing_mail_exceeded_limits' => 'De beperkingen van de uitgaande mail zijn overschreden',
    'notifications.subscription_cgroups_limits_exceed' => 'RAM, CPU en schijf-I/O (Cgroups)',
    'notifications.admin_postponed_feedback' => 'Feedback-herinnering',
    'notifications.errorInvalidEmail' => 'Onjuist e-mailadres.',
    'notifications.errorInvalidExpTime' => 'Aantal dagen is ongeldig.',
    'notifications.errorUpdate' => 'Melding kan niet worden bijgewerkt: %%error%%',
    'notifications.updated' => 'Notificatie-instellingen zijn bijgewerkt',

    'outgoingmail.name' => 'Naam',
    'outgoingmail.maxOutgoingMessages' => 'Beperking per uur',
    'outgoingmail.numOfExceedingAttempts' => 'Pogingen na het bereiken van de grenswaarde',
    'outgoingmail.lastAttemptAt' => 'Laatste poging',
    'outgoingmail.mailStatus' => 'Mail-status',
    'outgoingmail.mailStatusSending' => 'Versturen',
    'outgoingmail.mailStatusNotSending' => 'Er wordt niets verstuurd',
    'outgoingmail.mailStatusSendingDesc' => 'Er wordt mail verstuurd.',
    'outgoingmail.mailStatusNotSendingDesc' => 'Er wordt geen mail verstuurd.',
    'outgoingmail.limitValueUnlimited' => 'Onbeperkt',

    'scheduler.tasks.headerCommand' => 'Opdracht',
    'scheduler.tasks.headerSchedule' => 'Rooster',
    'scheduler.tasks.headerSubscription' => 'Abonnement',
    'scheduler.tasks.headerSubscription_powerUser' => 'Webruimte',
    'scheduler.tasks.buttonToggleHintOn' => 'De taak is geactiveerd. Klik om de taak uit te schakelen.',
    'scheduler.tasks.buttonToggleHintOff' => 'De taak is uitgeschakeld. Klik om de taak te activeren.',
    'scheduler.tasks.add' => 'Taak toevoegen',
    'scheduler.tasks.hintAdd' => 'Een nieuwe taak inroosteren.',
    'scheduler.tasks.remove' => 'Verwijderen',
    'scheduler.tasks.hintRemove' => 'Geselecteerde taken verwijderen.',
    'scheduler.tasks.confirmOnDelete' => 'Wilt u de geselecteerde taken verwijderen?',
    'scheduler.tasks.sync' => 'Vernieuwen',
    'scheduler.tasks.hintSync' => 'De takenlijst opnieuw laden voor de laatste informatie.',
    'scheduler.tasks.settings' => 'Instellingen',
    'scheduler.tasks.hintSettings' => 'Instellingen van ingeroosterde taak bewerken.',
    'scheduler.tasks.deleteSuccess' => 'Ingeroosterde taken zijn verwijderd.',
    'scheduler.tasks.serverTask' => 'server (gebruiker:%%user%%)',
    'scheduler.tasks.unknownUser' => 'onbekend',
    'scheduler.tasks.runTaskNow' => 'Nu uitvoeren',
    'scheduler.tasks.runTaskNowHint' => 'De taak nu uitvoeren.',
    'scheduler.tasks.runningTask' => 'De taak "%%task%%" uitvoeren...',

    'server-components.bcTitle' => 'Servercomponenten',
    'server-components.title' => 'Plesk-componenten',
    'server-components.name' => 'Componentnaam',
    'server-components.version' => 'Componentversie',
    'server-components.refresh' => 'Vernieuwen',
    'server-components.componentName' => 'Geef naam van component op...',
    'server-components.noComponents' => 'Geen componenten gevonden',
    'server-components.componentsListUpdated' => 'De lijst met componenten is bijgewerkt',

    'server-components.componentName.urlrewrite' => 'URL-rewrite',
    'server-components.componentName.dbconnector' => "Database connector",
    'server-components.componentName.mysqlserver' => 'MariaDB/MySQL-server',
    'server-components.componentName.troubleshooting' => 'Probleemoplossing',
    'server-components.componentName.waf' => 'Firewall voor webtoepassingen',
    'server-components.componentName.vcs' => 'Versiecontrolesysteem',
    'server-components.componentName.dotnetcore' => '.NET Core',
    'server-components.componentName.nodejs' => 'Node.js',
    'server-components.componentName.appinit' => "Initialisatie van de applicatie",
    'server-components.componentName.cors' => "Cross-Origin Resource Sharing",
    'server-components.componentName.httpcompression' => 'HTTP-inhoudscompressie',
    'server-components.componentName.antivirus' => "Antivirus",
    'server-components.componentName.database' => "SQL-server",
    'server-components.componentName.sqladmin' => "MariaDB/MySQL-webadmin",
    'server-components.componentName.sqladminmysql' => "MariaDB/MySQL-webadmin",
    'server-components.componentName.dnsserver' => "DNS-server",
    'server-components.componentName.firewall' => "Firewall",
    'server-components.componentName.ftpserver' => "FTP-server",
    'server-components.componentName.java' => "Java",
    'server-components.componentName.mailserver' => "Mailsever",
    'server-components.componentName.local_mailserver' => "Lokale mailserver",
    'server-components.componentName.psa' => "Plesk",
    'server-components.componentName.script' => "Webscripting",
    'server-components.componentName.spamfilter' => "Spamfilter",
    'server-components.componentName.stats' => "Webstatistieken",
    'server-components.componentName.stunnel' => "SSL/TLS-wrapper",
    'server-components.componentName.webmail' => "Webmail",
    'server-components.componentName.webpublish' => "Webpublishing",
    'server-components.componentName.webserver' => "Webserver",
    'server-components.componentName.network' => 'Netwerken',
    'server-components.componentName.sitebuilder' => 'Presence Builder',
    'server-components.componentName.cphosting' => "Plesk hosting",
    'server-components.componentName.savi' => 'Scherm van Sophos Anti-Virus',

    'server-components.tooltip.disabled' => 'Uitgeschakeld',
    'server-components.tooltip.active' => 'Actief',
    'server-components.tooltip.notConfigured' => 'Niet ingesteld',
    'server-components.tooltip.notStarted' => 'Niet gestart, controleer de instellingen van de component',

    'server-components.defaultComponents.circularDependencies' => "Er zijn circulaire afhankelijkheden gevonden tussen de categorieën %%cat1%% en %%cat2%%",
    'server-components.defaultComponents.not_installed' => "(niet geïnstalleerd)",
    'server-components.defaultComponents.not_configured' => "(niet ingesteld)",
    'server-components.defaultComponents.not_opted_to_install_support_files' => "Sommige dienstcategorieën bevatten een ongeldige selectie, of er is geen selectie gemaakt.",
    'server-components.defaultComponents.depends_on' => "(%%name%% vereist)",
    'server-components.defaultComponents.not_activated' => 'niet geactiveerd',
    'server-components.defaultComponents.imap_required' => '(Huidige mailserver ondersteunt geen IMAP)',
    'server-components.defaultComponents.ftp_ipv6_hosting_not_supported' => "(FTP-server ondersteunt geen IPv6-adressen)",
    'server-components.defaultComponents.delegation_rule_not_exist' => '(de vereiste toewijzingsregel \'appPoolPipeline, appPoolNetFx\' is niet aanwezig)',
    'server-components.defaultComponents.not_supported_version' => '(niet-ondersteunde versie)',
    'server-components.defaultComponents.no_license' => '(niet toegestaan door licentiesleutel)',
    'server-components.defaultComponents.license_expired' => '(licentiesleutel is verlopen)',
    'server-components.defaultComponents.license_mailboxes_limit_exceeded' => '(de licentiebeperking van het aantal postvakken is overschreden)',
    'server-components.defaultComponents.title' => 'Selecteer standaard %%name%%-component',
    'server-components.defaultComponents.none' => 'Geen',
    'server-components.defaultComponents.yes' => 'Ja',
    'server-components.defaultComponents.no' => 'Nee',
    'server-components.defaultComponents.warning' => 'Let op!',
    'server-components.defaultComponents.parametersOfComponent' => 'Parameters van %%component%%',
    'server-components.defaultComponents.success' => 'Standaardcomponent is bijgewerkt',

    'server-components.defaultComponents.mailserverSwitchingWarning' => "Het wijzigen van de mailserver is alleen bedoeld voor tijdens de eerste installatie. Als de server al in gebruik is genomen, dan zou het de volgende problemen veroorzaken: verlies van instellingen en de inhoud van postvakken en, in gevallen waarbij de server die u wilt gaan gebruiken al is geconfigureerd, nog een aantal andere conflicten.\nAls deze server nu in gebruik is en u weet zeker dat u wilt overstappen naar een andere server, dan kunt u uw klanten daarvan op de hoogte stellen, zodat zij eerst hun mail kunnen downloaden en opslaan.",
    'server-components.defaultComponents.dnsserverBindToMsdnsSwitchingWarning' => "Alleen de eerste 254 IP-adressen van subnetten met /8 en /16-maskers die zich in de toegangsbeheerlijst (ACL) bevinden zullen worden overgedragen. Deze worden overgedragen als aparte IP-adressen. Wilt u doorgaan?",

    'server-components.componentConf.title' => 'Parameters van %%compDesc%%',
    'server-components.componentConf.parameterIsRequired' => 'Parameter is vereist',
    'server-components.componentConf.parameterShouldBeNumber' => 'Parameter moet een getal zijn',
    'server-components.componentConf.success' => 'Parameters zijn bijgewerkt',

    'spam-filter.groupAdd' => 'Toevoegen',
    'spam-filter.buttonAdd' => 'Domein toevoegen',
    'spam-filter.buttonAddAddress' => 'Adres toevoegen',
    'spam-filter.buttonAddToBlackListHint' => 'Domein aan de zwarte lijst toevoegen',
    'spam-filter.buttonAddToWhiteListHint' => 'Domein aan de whitelist toevoegen',
    'spam-filter.buttonAddAddressToBlackListHint' => 'Adres aan de zwarte lijst toevoegen',
    'spam-filter.buttonAddAddressToWhiteListHint' => 'Adres aan de whitelist toevoegen',
    'spam-filter.groupActions' => 'Acties',
    'spam-filter.buttonRemove' => 'Verwijderen',
    'spam-filter.entries' => 'Ingangen',
    'spam-filter.removeEmptySelection' => 'Geen ingangen geselecteerd.',
    'spam-filter.removeConfirmation' => 'Wilt u {count, plural, =1 {de ingang {name}} one {de # geselecteerde ingang} other {de # geselecteerde ingangen}} verwijderen?',
    'spam-filter.removeSuccess' => 'De geselecteerde ingangen zijn verwijderd.',
    'spam-filter.addAddressToBlackListEmptyTitle' => 'Lijst van bekende spam-adressen',
    'spam-filter.addAddressToWhiteListEmptyTitle' => 'Lijst van vertrouwde adressen',
    'spam-filter.addAddressToBlackListEmptyDescription' => 'Berichten van e-mailadressen op deze lijst zullen als spam worden behandeld.',
    'spam-filter.addAddressToWhiteListEmptyDescription' => 'Berichten van e-mailadressen op deze lijst zullen door het spamfilter worden overgeslagen.',

    'tasks.pollingOff' => 'Uit',
    'tasks.pollingDelay' => '%%delay%% s',
    'tasks.stopTaskConfirm' => 'Weet u zeker dat u de taak wilt stoppen?',
    'tasks.stopTaskError' => 'Het stoppen van de taak is mislukt',
    'tasks.stopTask' => 'Taak stoppen',
    'tasks.processedLoadFailed' => 'Kan lijst met processen niet laden',
    'tasks.retryTask' => 'Opnieuw proberen',
    'tasks.retryTaskFailed' => 'Het opnieuw proberen de taak uit te voeren is mislukt',
    'tasks.taskCreated' => 'Het aanmaken van de nieuwe taak is geslaagd',
    'tasks.moreDetails' => 'Zie paneel met logboek voor details',
    'tasks.searchTitle' => 'Zoeken',
    'tasks.searchPlaceholder' => 'Zoekopdracht',
    'tasks.refresh' => 'Vernieuwen',
    'tasks.refreshDescription' => 'Lijst met taken vernieuwen',
    'tasks.createTask' => 'Taak aanmaken',
    'tasks.openSwagger' => 'Swagger openen',
    'tasks.statusTitle' => 'Status',
    'tasks.createdTitle' => 'Aangemaakt',
    'tasks.descriptionTitle' => 'Omschrijving',
    'tasks.processes.dataLoadFailed' => 'Het ophalen van gegevens van de server is mislukt',
    'tasks.processes.commandLineLoadFailed' => 'Het is niet gelukt de taak uit te voeren',
    'tasks.processes.stopProcess' => 'Proces stoppen',
    'tasks.processes.stopProcessFailed' => 'Het stoppen van het proces is mislukt',
    'tasks.processes.stopProcessConfirm' => 'Weet u zeker dat u het proces wilt stoppen?',
    'tasks.processes.copyToClipboard' => 'Naar klembord kopiëren',
    'tasks.processes.concurrency' => 'Gelijktijdige uitvoering',
    'tasks.processes.taskIdSection' => 'Kenmerk taak',
    'tasks.processes.requestorIdSection' => 'Kenmerk aanvrager',
    'tasks.processes.timeoutSection' => 'Timeout',
    'tasks.processes.createdSection' => 'Aangemaakt',
    'tasks.processes.updatedSection' => 'Bijgewerkt',
    'tasks.processes.environmentSection' => 'Omgeving',
    'tasks.processes.idTitle' => 'Kenmerk',
    'tasks.processes.statusTitle' => 'Status',
    'tasks.processes.startedTitle' => 'Gestart',
    'tasks.processes.completedTitle' => 'Voltooid',
    'tasks.processes.pidTitle' => 'PID',
    'tasks.processes.exitCodeTitle' => 'Exit-code',

    'ts-sessions.columnStateTitle' => 'Staat',
    'ts-sessions.columnUserTitle' => 'Gebruiker',
    'ts-sessions.columnNameTitle' => 'Naam',
    'ts-sessions.refresh' => 'Vernieuwen',
    'ts-sessions.logoff' => 'Afmelden',
    'ts-sessions.logoffConfirmation' => '%%count%% sessie(s) afmelden?',
    'ts-sessions.logoffConfirmationSingle' => 'De sessie %%name%% afmelden?',
    'ts-sessions.logoffConfirmationButton' => 'Ja, afmelden',
    'ts-sessions.logoffNoSelection' => 'Selecteer een of meer sessies om af te melden',
    'ts-sessions.logoffSuccess' => 'Geselecteerde sessies zijn afgemeld.',
    'ts-sessions.disconnect' => 'Verbinding verbreken',
    'ts-sessions.disconnectConfirmation' => 'Verbinding van %%count%% sessie(s) verbreken?',
    'ts-sessions.disconnectConfirmationSingle' => 'Verbinding met sessie %%name%% verbreken?',
    'ts-sessions.disconnectConfirmationButton' => 'Ja, verbinding verbreken',
    'ts-sessions.disconnectSuccess' => 'De verbinding van de geselecteerde sessies is verwijderd.',
    'ts-sessions.disconnectNoSelection' => 'Selecteer een of meer sessies waarmee u de verbinding wilt verbreken',
    'ts-sessions.disconnectNotAvailable' => 'U kunt alleen actieve of verbonden sessies verbreken.',

    'client-ip-address.title' => 'IP-adressen',
    'client-ip-address.status' => 'Status',
    'client-ip-address.type' => 'Type',
    'client-ip-address.ipAddress' => 'IP-adres',
    'client-ip-address.certificate' => 'Certificaat',
    'client-ip-address.hosting' => 'Hosting',
    'client-ip-address.adminCertificateRepository' => "Opslag van beheerder",
    'client-ip-address.domainCertificateRepository' => 'Opslag van domein %%owner%%',
    'client-ip-address.typeShared' => 'Gedeeld',
    'client-ip-address.typeExclusive' => 'Exclusief',
    'client-ip-address.removeConfirmation' => '{count, plural, =1 {De IP-adressen {name} } one {De # geselecteerde IP-adressen} other {De # geselecteerde IP-adressen}} verwijderen uit de IP-voorziening van de gebruiker?',
    'client-ip-address.noItemsToRemove' => 'Selecteer een of meer items om te verwijderen.',
    'client-ip-address.ftpOverSSL' => 'FTP via SSL/TLS',
    'client-ip-address.ftpOverSSL-yes' => 'Ja',
    'client-ip-address.ftpOverSSL-no' => 'Nee',
    'client-ip-address.ftpOverSSL-allow' => 'Toestaan',
    'client-ip-address.ftpOverSSL-notAllowed' => 'Niet toegestaan',
    'client-ip-address.add' => 'IP-adres toevoegen',
    'client-ip-address.noAvailableIps' => 'Er zijn geen beschikbare IP-adressen.',
    'client-ip-address.isOk' => 'IP-adres functioneert naar behoren.',
    'client-ip-address.isBroken' => 'IP-adres is niet aanwezig op de netwerkkaart.',
    'client-ip-address.properties.title' => 'IP-adres %%address%% op netwerkkaart %%interface%%',
    'client-ip-address.properties.distributedType' => 'IP-adres verspreid als',
    'client-ip-address.properties.allocatedType' => 'IP-adres toegewezen als',
    'client-ip-address.properties.none' => 'Geen',
    'client-ip-address.properties.certificate' => 'SSL/TLS-certificaat',
    'client-ip-address.properties.defaultSite' => 'Standaard website',
    'client-ip-address.assign.title' => 'Selecteer IP-adressen',
    'client-ip-address.assign.description' => 'Beschikbare IP\'s',
    'client-ip-address.assign.success' => 'Het toevoegen van {count, plural, =1 {het IP-adres {name}} one {het # geselecteerde IP-adres} other {de # geselecteerde IP-adressen}} aan de IP-voorziening van de gebruiker is geslaagd',

    'ip-address-reseller-usage.title' => 'Resellers die %%type%% IP-adres %%ipAddress%% gebruiken',
    'ip-address-reseller-usage.nameColumnHeader' => 'Resellers',
    'ip-address-reseller-usage.assignButton' => 'Aan reseller toewijzen',
    'ip-address-reseller-usage.alreadyAssignedToAllClients' => 'Dit IP-adres is al aan alle gebruikers toegewezen.',
    'ip-address-reseller-usage.removeButton' => 'Verwijderen',
    'ip-address-reseller-usage.removeSuccess' => 'Het IP-adres is verwijderd uit {count, plural, =1 {de voorziening {name}} one {de # geselecteerde reseller-voorzieningen} other {de # geselecteerde IP-voorzieningen van resellers}}.',
    'ip-address-reseller-usage.removeConfirmation' => 'Verwijder het IP-adres uit {count, plural, =1 {de IP-voorziening {name}} one {de # geselecteerde IP-voorziening van resellers} other {de # geselecteerde IP-voorzieningen van resellers}}?',
    'ip-address-reseller-usage.typeSHARED' => 'Gedeeld',
    'ip-address-reseller-usage.typeEXCLUSIVE' => 'Exclusief',
    'ip-address-reseller-usage.assign.title' => "%%ipAddress%% toevoegen aan de reseller-voorziening",
    'ip-address-reseller-usage.assign.resellersToAdd' => 'Toe te voegen resellers',
    'ip-address-reseller-usage.assign.success' => 'Het IP-adres is toegevoegd aan {count, plural, =1 {de voorziening {name}} one {de # geselecteerde reseller-voorzieningen} other {de # geselecteerde IP-voorzieningen van resellers}}.'
];