<?php
// Copyright 1999-2024. WebPros International GmbH. All rights reserved.
$messages = [
    'adminaliases.statusActive' => 'Le compte est actif.',
    'adminaliases.statusInactive' => 'Le compte est suspendu. Cet administrateur ne peut pas se connecter à Plesk.',
    'adminaliases.buttonRemoveAdminAlias' => 'Supprimer',
    'adminaliases.hintRemoveAdminAlias' => 'Supprimez les comptes administrateur sélectionnés.',
    'adminaliases.confirmOnRemove' => 'Voulez-vous supprimer les comptes administrateur sélectionnés ?',
    'adminaliases.buttonAddNewAdminAlias' => 'Ajouter un compte administrateur',
    'adminaliases.hintAddNewAdminAlias' => 'Créez un compte administrateur supplémentaire.',
    'adminaliases.buttonMoreActions' => 'Plus',
    'adminaliases.buttonActivateAdminAlias' => 'Activer',
    'adminaliases.hintActivateAdminAlias' => 'Activez les comptes administrateur suspendus.',
    'adminaliases.buttonDeactivateAdminAlias' => 'Suspendre',
    'adminaliases.hintDeactivateAdminAlias' => 'Suspendez les comptes administrateur sélectionnés. Plesk refusera l\'accès pour ces administrateurs.',
    'adminaliases.confirmOnDelete' => 'Voulez-vous supprimer les comptes administrateur sélectionnés ?',
    'adminaliases.login' => 'Nom d\'utilisateur',
    'adminaliases.contact' => 'Nom du contact',
    'adminaliases.email' => 'Adresse mail',
    'adminaliases.comments' => 'Commentaires',

    'appinfo.installedAt' => 'Chemin d\'installation',
    'appinfo.noInstallationUrlAvailable' => 'Aucun(e)',
    'appinfo.subscriptionName' => 'Abonnement',
    'appinfo.subscriptionOwner' => 'Propriétaire de l\'abonnement',
    'appinfo.buttonLogin' => 'Ouvrir dans le Panneau Client',
    'appinfo.buttonLoginClassicMode' => 'Gérer l\'hébergement',
    'appinfo.hintLogin' => 'Ouvrez le Panneau Client de l\'abonné.',
    'appinfo.hintAdminLogin' => 'Gérez les services d\'hébergement associés à un certain compte d\'hébergement : domaines et DNS, bases de données et apps Web, mails, etc.',
    'appinfo.hintLoginClassicMode' => 'Gérez les services d\'hébergement associés à un certain compte d\'hébergement : domaines et DNS, bases de données et apps Web, mails, etc.',
    'appinfo.update' => 'Des mises à jour sont disponibles.',
    'appinfo.updateFailed' => 'Mise à jour échouée.',
    'appinfo.noUpdates' => 'Aucune mise à jour n\'est disponible.',
    'appinfo.foundUpdates' => 'Les mises à jour sont disponibles pour les applications suivantes :',
    'appinfo.buttonCheckForUpdates' => 'Vérifier les mises à jour',
    'appinfo.buttonCheckForUpdatesDescription' => 'Vérifiez les mises à jour disponibles.',
    'appinfo.buttonChangeSettings' => 'Paramètres',
    'appinfo.buttonChangeSettingsDescription' => 'Changez les paramètres valables pour l\'ensemble du serveur de l\'application.',
    'appinfo.appNotConfigured' => 'Non configuré',

    'appuploaded.name' => 'Nom',
    'appuploaded.numberOfInstances' => 'Nombre d\'installations',
    'appuploaded.buttonUploadNewApp' => 'Ajouter une application',
    'appuploaded.buttonUploadNewAppDescription' => 'Ajoutez un pack d\'applications dans le serveur.',
    'appuploaded.buttonRemove' => 'Supprimer',
    'appuploaded.buttonRemoveDescription' => 'Supprimez les packs sélectionnés.',
    'appuploaded.confirmOnDelete' => 'Voulez-vous vraiment supprimer les packs sélectionnés ?',
    'appuploaded.appInvisible' => 'Indisponible(s) pour les clients',
    'appuploaded.appGlobalSettingsNotSet' => 'Non configuré',
    'appuploaded.buttonMakeAppVisible' => 'Rendre disponible',
    'appuploaded.buttonMakeAppVisibleDescription' => 'Rendez l\'application disponible pour l\'installation par les clients.',
    'appuploaded.buttonMakeAppInvisible' => 'Rendre indisponible',
    'appuploaded.buttonMakeAppInvisibleDescription' => 'Rendez l\'application indisponible pour l\'installation par les clients.',

    'appusage.name' => 'Nom',
    'appusage.numberOfInstances' => 'Nombre d\'installations',
    'appusage.buttonCleanApplicationCache' => 'Effacer le cache',
    'appusage.buttonCleanApplicationCacheDescription' => 'Supprimez les fichiers temporaires téléchargés lors de l\'installation des apps.',
    'appusage.buttonRedirectToMarket' => 'Atteindre la boutique en ligne',
    'appusage.buttonRedirectToMarketDescription' => 'Achetez les licences des apps pour les installer sur les sites Web.',
    'appusage.updateFailed' => 'Mise à jour échouée.',
    'appusage.noUpdates' => 'Aucune mise à jour n\'est disponible.',
    'appusage.foundUpdates' => 'Les mises à jour sont disponibles pour les applications suivantes :',
    'appusage.buttonCheckForUpdates' => 'Vérifier les mises à jour',
    'appusage.buttonCheckForUpdatesDescription' => 'Vérifiez les mises à jour disponibles dans le Catalogue d\'applications.',
    'appusage.buttonUpdateSettings' => 'Paramètres de mise à jour',
    'appusage.buttonUpdateSettingsDescription' => 'Configurez les paramètres de mise à jour des applications pour l\'ensemble du serveur.',

    'controlpanelaccessnetworks.ipAddress' => 'Adresse IP',
    'controlpanelaccessnetworks.subnetMask' => 'Masque de sous-réseau',
    'controlpanelaccessnetworks.buttonAddNewNetwork' => 'Ajouter un réseau',
    'controlpanelaccessnetworks.buttonAddNewNetworkDescription' => 'Cliquez pour ajouter le réseau à la liste des restrictions d\'accès.',
    'controlpanelaccessnetworks.buttonRemove' => 'Supprimer',
    'controlpanelaccessnetworks.buttonRemoveDescription' => 'Cliquer pour enlever le réseau sélectionné.',
    'controlpanelaccessnetworks.confirmOnDelete' => 'Voulez-vous vraiment supprimer les réseaux sélectionnés ?',
    'controlpanelaccessnetworks.buttonSettings' => 'Paramètres',
    'controlpanelaccessnetworks.buttonSettingsDescription' => 'Cliquez pour changer la politique de restriction d\'accès.',
    'controlpanelaccessnetworks.loadingTitle' => 'Veuillez patienter. Chargement en cours...',

    'customers.filterCustomerName' => 'Nom du client',
    'customers.filterSubscription' => 'Abonnement',
    'customers.filterOptionSubscriptionAny' => 'Tout',
    'customers.filterOptionSubscriptionMy' => 'Mes packs',
    'customers.filterOptionSubscriptionReseller' => 'Packs de %%planOwnerContactName%%', // Note for translators: you can use here structure like "Plans of Reseller <name>" or alike if it is more convenient
    'customers.filterOptionSubscriptionCustom' => 'Personnalisé',
    'customers.filterOwnership' => 'Fournisseur',
    'customers.filterOptionOwnershipAny' => 'Tous les clients',
    'customers.filterOptionOwnershipMy' => 'Mes clients',
    'customers.filterOwnershipReseller' => 'Clients de %%resellerContactName%%\'s', //Note for translators: see 'filterOptionSubscriptionReseller'
    'customers.filterResourceUsage' => 'Utilisation des ressources',
    'customers.filterOptionResourceUsageAny' => 'Tout',
    'customers.filterOptionResourceUsageOveruse' => 'Ressources surutilisées',
    'customers.filterOptionResourceUsageOk' => 'Dans les limites',
    'customers.filterStatus' => 'Statut',
    'customers.filterOptionStatusAny' => 'Tout',
    'customers.filterOptionStatusSuspended' => 'Suspendu',
    'customers.filterOptionStatusActive' => 'Actif',
    'customers.filterDescription' => 'Description',
    'customers.statusOk' => 'Le compte client est actif.',
    'customers.statusInactive' => 'Le compte client est inactif : l\'accès au Panneau Client est verrouillé pour le client.',
    'customers.statusSuspended' => 'Le compte client est suspendu : l\'accès au Panneau Client est verrouillé pour le client et tous ses utilisateurs ; les domaines du client sont suspendus, ses services Web, FTP et de messagerie ne sont plus accessibles aux utilisateurs Internet.',
    'customers.customerName' => 'Nom du client',
    'customers.subscription' => 'Abonnement',
    'customers.setupDate' => 'Date de configuration',
    'customers.ownerName' => 'Fournisseur',
    'customers.buttonLogin' => 'Se connecter en tant que client',
    'customers.buttonLoginClassicMode' => 'Gérer l\'hébergement',
    'customers.hintLogin' => 'Connectez-vous en tant que client.',
    'customers.hintLoginClassicMode' => 'Gérez les services d\'hébergement associés au compte d\'hébergement du client : domaines et DNS, bases de données et apps Web, mails, etc.',
    'customers.buttonRemoveCustomer' => 'Supprimer',
    'customers.hintRemoveCustomer' => 'Supprimez les clients sélectionnés.',
    'customers.confirmOnRemove' => 'Voulez-vous vraiment supprimer les comptes client sélectionnés ?',
    'customers.buttonConvertCustomersToReseller' => 'Convertir en revendeur',
    'customers.hintConvertCustomersToReseller' => 'Convertissez les comptes client sélectionnés en comptes revendeur.',
    'customers.buttonAddNewCustomer' => 'Ajouter un client',
    'customers.hintAddNewCustomer' => 'Créez un compte client avec un abonnement.',
    'customers.buttonChangeStatus' => 'Changer le statut',
    'customers.hintChangeStatus' => 'Remplacez le statut du client par "Actif" ou par "Suspendu".',
    'customers.buttonSuspendCustomers' => 'Suspendre',
    'customers.hintSuspendCustomers' => 'Suspendez les comptes client sélectionnés. L\'accès au Panneau Client sera verrouillé pour les clients et tous leurs utilisateurs : les domaines des clients seront suspendus, leurs services Web, FTP et de messagerie ne seront plus accessibles aux utilisateurs Internet.',
    'customers.buttonActivateCustomers' => 'Activer',
    'customers.hintActivateCustomers' => 'Activez les comptes client sélectionnés.',
    'customers.buttonChangeOwner' => 'Déplacer vers',
    'customers.hintChangeOwner' => 'Déplacez les clients sélectionnés vers un autre revendeur.',
    'customers.customPlanName' => 'Personnalisé',
    'customers.selectNewIp' => 'Sélectionner une adresse IP',
    'customers.selectAnotherOwner' => 'Sélectionner un propriétaire',
    'customers.shared' => 'partagé',
    'customers.exclusive' => 'dédiée',
    'customers.confirmOnDelete' => 'Voulez-vous supprimer {count, plural, =1 {le compte client {name}} one {le compte client sélectionné} other {les # comptes clients sélectionnés}} ?',
    'customers.hintInfo' => '(?)',

    'customerserviceplans.planName' => 'Nom du pack',
    'customerserviceplans.planTraffic' => 'Trafic',
    'customerserviceplans.planDiskSpace' => 'Espace disque',
    'customerserviceplans.planSubscriptions' => 'Abonnements',
    'customerserviceplans.planOwner' => 'Fournisseur',
    'customerserviceplans.filterPlanItem' => 'Composant du pack personnalisé',
    'customerserviceplans.filterOptionPlanItemAny' => 'Tout',
    'customerserviceplans.filterOwnership' => 'Propriétaire du pack',
    'customerserviceplans.filterOptionOwnershipAny' => 'Tous les packs',
    'customerserviceplans.filterOptionOwnershipMy' => 'Mes packs',
    'customerserviceplans.filterOwnershipReseller' => 'Packs de %%resellerContactName%%\'s',
    'customerserviceplans.unlimited' => 'Illimité',
    'customerserviceplans.addonPlanType' => '(add-on)',
    'customerserviceplans.buttonAddNewPlan' => 'Ajouter un pack',
    'customerserviceplans.hintAddNewPlan' => 'Créez un pack d\'hébergement.',
    'customerserviceplans.buttonDuplicatePlans' => 'Cloner les packs',
    'customerserviceplans.hintDuplicatePlans' => 'Créez des copies des packs de services sélectionnés.',
    'customerserviceplans.buttonAddNewAddonPlan' => 'Ajouter un add-on',
    'customerserviceplans.hintAddNewAddonPlan' => 'Créez un add-on de pack d\'hébergement.',
    'customerserviceplans.buttonRemove' => 'Supprimer',
    'customerserviceplans.hintRemove' => 'Supprimez les packs de services sélectionnés.',
    'customerserviceplans.buttonMoreActions' => 'Plus d\'actions',
    'customerserviceplans.confirmOnDelete' => 'Voulez-vous vraiment supprimer les packs de service sélectionnés ?',
    'customerserviceplans.disabledSelectHint' => 'Le pack de services a au moins un abonnement qui lui est associé et ne peut pas être supprimé.',

    'domains.filterHint' => 'Filtrer les domaines par critère',
    'domains.filterDomainName' => 'Nom',
    'domains.filterStatus' => 'Statut',
    'domains.filterOptionStatusAny' => 'Tout',
    'domains.filterOptionStatusSuspended' => 'Suspendu',
    'domains.filterOptionStatusDisabled' => 'Désactivé',
    'domains.filterOptionStatusActive' => 'Actif',
    'domains.filterHostingType' => 'Type d\'hébergement',
    'domains.filterPhpHandler' => 'Gestionnaire PHP',
    'domains.filterOptionPhpHandlerAny' => 'Tou(te)s',
    'domains.filterOptionHostingTypeAny' => 'Tout',
    'domains.filterOptionHostingTypeNone' => 'Aucun hébergement',
    'domains.filterOptionHostingTypeForward' => 'Redirection du domaine',
    'domains.filterOptionHostingTypeAlias' => 'Alias de domaine',
    'domains.filterOptionHostingTypeVirtualHost' => 'Hébergement du domaine',
    'domains.filterOptionHostingTypeSubdomain' => 'Hébergement du sous-domaine',
    'domains.filterSubscriberName' => 'Abonné',
    'domains.filterServiceNode' => 'Node de service',
    'domains.filterServiceNodeOptionAny' => 'Tout',
    'domains.filterDescription' => 'Description',
    'domains.filterTitlePlaceholder' => 'Chercher les domaines…',
    'domains.filterTitle' => 'Filtre',
    'domains.filterApply' => 'Appliquer le filtre',
    'domains.filterClear' => 'Vider',
    'domains.statusDisabled' => 'Le domaine est désactivé.',
    'domains.statusSuspended' => 'Le domaine est suspendu.',
    'domains.domainName' => 'Nom de domaine',
    'domains.hostingType' => 'Type d\'hébergement',
    'domains.ownerName' => 'Abonné',
    'domains.setupDate' => 'Date de configuration',
    'domains.expirationDate' => 'Date d\'expiration',
    'domains.diskUsage' => 'Utilisation du disque',
    'domains.traffic' => 'Trafic',
    'domains.status' => 'Statut',
    'domains.description' => 'Description',
    'domains.resellerDescription' => 'Revendeur',
    'domains.ownerDescription' => 'Client',
    'domains.openSite' => 'Ouvrir',
    'domains.previewSite' => 'Aperçu',
    'domains.manageInResellerPanel' => 'Gérer dans le Panneau Revendeur',
    'domains.manageInCustomerPanel' => 'Gérer dans le Panneau Client',
    'domains.customPlanName' => 'Personnalisé',
    'domains.website' => 'Site Web',
    'domains.subdomainWebsite' => 'Site Web du sous-domaine',
    'domains.noHosting' => 'Aucun hébergement',
    'domains.forwardingTo' => 'Transférer à',
    'domains.aliasFor' => 'Alias pour',
    'domains.forwardingToDomain' => 'transférer vers %%domain%%',
    'domains.aliasForDomain' => 'alias pour %%domain%%',
    'domains.add' => 'Ajouter',
    'domains.buttonAddDomain' => 'Ajouter un domaine',
    'domains.hintAddDomain' => 'Hébergez un nouveau site Web sur ce serveur, configurez la redirection Web vers un autre site Web ou configurez une zone DNS de domaine si vous voulez avoir uniquement des adresses mail sous un domaine.',
    'domains.buttonAddSubdomain' => 'Ajouter un sous-domaine',
    'domains.hintAddSubdomain' => 'Créez un site dont l\'adresse est celle d\'un nom de domaine tiers comme "shop.exemple.com".',
    'domains.buttonAddDomainAlias' => 'Ajouter un alias de domaine',
    'domains.hintAddDomainAlias' => 'Configurez un autre nom de domaine pour votre site.',
    'domains.hintRemove' => 'Supprimez les sites Web sélectionnés et tout leur contenu Web, les apps, les bases de données et les mails.',
    'domains.removeConfirmation' => 'Voulez-vous supprimer {count, plural, =1 {le domaine {name}} one {le domaine sélectionné} other {les # domaines sélectionnés}} ?',
    'domains.removeConfirmationSubscription' => "Les domaines suivants seront également supprimés : %%domains%%",
    'domains.buttonSetStatus' => 'Définir le statut',
    'domains.hintSetStatus' => 'Remplacez le statut du domaine par "Actif", par "Suspendu" ou par "Désactivé".',
    'domains.activateActionStatus' => 'Actif',
    'domains.hintActivateDomains' => 'Activez les domaines sélectionnés.',
    'domains.disableActionStatus' => 'Désactivé',
    'domains.hintDisableDomains' => 'Désactivez les domaines sélectionnés.',
    'domains.suspendActionStatus' => 'Suspendu',
    'domains.hintSuspendDomains' => 'Suspendez les domaines sélectionnés.',
    'domains.changeStatusNoItems' => 'Sélectionnez un ou plusieurs domaines pour modifier leur statut.',
    'domains.removeNoItems' => 'Sélectionner un ou plusieurs domaines à supprimer',
    'domains.activated' => 'Les domaines et alias sélectionnés étaient activés',
    'domains.disabled' => 'Les domaines et les alias sélectionnés ont été désactivés.',
    'domains.suspended' => 'Les domaines et les alias sélectionnés ont été suspendus.',

    'dnsaclrecords.value' => 'Adresse IP',
    'dnsaclrecords.add' => 'Ajouter une adresse IP',
    'dnsaclrecords.remove' => 'Supprimer',
    'dnsaclrecords.hintRemove' => 'Supprimez les adresses IP sélectionnées.',
    'dnsaclrecords.confirmOnDelete' => 'Voulez-vous supprimer les adresses IP sélectionnées ?',
    'dnsaclrecords.emptyViewTitle' => 'Transfert de zone DNS non autorisé',
    'dnsaclrecords.emptyViewDescription1' => 'Pour des raisons de sécurité, vous pouvez autoriser le transfert de la zone DNS uniquement vers les serveurs spécifiés dans les enregistrements NS de la zone.',
    'dnsaclrecords.emptyViewDescription2' => 'Pour spécifier un ou plusieurs serveurs vers lesquels vous autorisez le transfert, cliquez sur "Ajouter une adresse IP".',

    'eventhandlers.event' => 'Événement',
    'eventhandlers.priority' => 'Priorité',
    'eventhandlers.priorityHighest' => 'la plus élevée (%%value%%)',
    'eventhandlers.priorityHigh' => 'élevée (%%value%%)',
    'eventhandlers.priorityNormal' => 'normale (%%value%%)',
    'eventhandlers.priorityLow' => 'basse (%%value%%)',
    'eventhandlers.priorityLowest' => 'la plus basse (%%value%%)',
    'eventhandlers.user' => 'Utilisateur',
    'eventhandlers.command' => 'Commande',
    'eventhandlers.buttonAddNewEventHandler' => 'Ajouter un gestionnaire d\'événements',
    'eventhandlers.buttonAddNewEventHandlerDescription' => 'Configurez un nouveau gestionnaire d\'événements.',
    'eventhandlers.buttonRemove' => 'Supprimer',
    'eventhandlers.buttonRemoveDescription' => 'Supprimez les gestionnaires d\'événements sélectionnés.',
    'eventhandlers.confirmOnDelete' => 'Voulez-vous vraiment supprimer les gestionnaires d\'événements sélectionnés ?',

    'firewallicmprules.status' => 'Statut',
    'firewallicmprules.on' => 'Cette règle est active.',
    'firewallicmprules.off' => 'Cette règle n\'est pas active.',
    'firewallicmprules.name' => 'Nom de la règle',
    'firewallicmprules.allowinboundrouterrequest' => 'Autoriser les "router request" entrants',
    'firewallicmprules.allowinboundtimestamprequest' => 'Autoriser les "timestamp request" entrants',
    'firewallicmprules.allowinboundmaskrequest' => 'Autoriser les "mask request" entrants',
    'firewallicmprules.allowoutboundsourcequench' => 'Autoriser les "source quench" sortants',
    'firewallicmprules.allowoutboundparameterproblem' => 'Autoriser les "parameter problem" sortants',
    'firewallicmprules.allowredirect' => 'Autoriser la redirection',
    'firewallicmprules.allowinboundechorequest' => 'Autoriser les "echo request" entrants',
    'firewallicmprules.allowoutboundtimeexceeded' => 'Autoriser les dépassements de délais sortants',
    'firewallicmprules.allowoutbounddestinationunreachable' => 'Autoriser les "destination unreachable" sortants',

    'firewallinterfaces.firewall' => 'Statut du pare-feu',
    'firewallinterfaces.firewallOn' => 'Le pare-feu est activé pour cette interface réseau.',
    'firewallinterfaces.firewallOff' => 'Le pare-feu est désactivé pour cette interface réseau.',
    'firewallinterfaces.connection' => 'Statut de l\'interface',
    'firewallinterfaces.connectionOn' => 'La connexion de l\'interface réseau est activée.',
    'firewallinterfaces.connectionOff' => 'La connexion de l\'interface réseau est désactivée.',
    'firewallinterfaces.name' => 'Nom de l\'interface',
    'firewallinterfaces.type' => 'Type d\'interface',
    'firewallinterfaces.statusOn' => 'Activé',
    'firewallinterfaces.statusOff' => 'Désactivé',

    'firewallrules.status' => 'Statut',
    'firewallrules.on' => 'Cette règle est active.',
    'firewallrules.off' => 'Cette règle n\'est pas active.',
    'firewallrules.name' => 'Nom de la règle',
    'firewallrules.description' => 'Description',
    'firewallrules.descriptionText' => '%%action%% les connexions entrantes depuis %%from%% sur le port %%port%%, profils : %%profiles%%',
    'firewallrules.allow' => 'Autoriser',
    'firewallrules.block' => 'Refuser',
    'firewallrules.fromAll' => 'tous',
    'firewallrules.groupAdd' => 'Ajouter',
    'firewallrules.buttonAdd' => 'Ajouter une règle',
    'firewallrules.buttonAddHint' => 'Ajoutez une règle de pare-feu',
    'firewallrules.groupActions' => 'Actions',
    'firewallrules.buttonRemove' => 'Supprimer',
    'firewallrules.removeEmptySelection' => 'Aucune règle de pare-feu sélectionnée.',
    'firewallrules.removeConfirmation' => 'Supprimer {count, plural, =1 {la règle de pare-feu {name}} one {# règle de pare-feu sélectionnée} other {# règles de pare-feu sélectionnées}} ?',
    'firewallrules.removeSuccess' => 'Les règles de pare-feu sélectionnées ont été supprimées.',

    'ftpsessions.buttonRemove' => 'Fermer',
    'ftpsessions.buttonRemoveDescription' => 'Fermez les sessions FTP sélectionnées.',
    'ftpsessions.buttonRefresh' => 'Actualiser',
    'ftpsessions.buttonRefreshDescription' => 'Actualisez les données à l\'écran.',
    'ftpsessions.typeColumnName' => 'T',
    'ftpsessions.statusColumnName' => 'S',
    'ftpsessions.loginColumnName' => 'Nom d\'utilisateur',
    'ftpsessions.domainColumnName' => 'Nom de domaine',
    'ftpsessions.currentLocationColumnName' => 'Emplacement actuel',
    'ftpsessions.fileNameColumnName' => 'Nom du fichier',
    'ftpsessions.speedColumnName' => 'Vitesse, Ko/s',
    'ftpsessions.progressColumnName' => 'Progression, %',
    'ftpsessions.ipAddressColumnName' => 'Adresse IP',
    'ftpsessions.logonTimeColumnName' => 'Date/Heure de connexion',
    'ftpsessions.idleTimeColumnName' => 'Période d\'inactivité',
    'ftpsessions.sessionTypeDomainAdminTooltip' => 'Session de l\'administrateur de domaine',
    'ftpsessions.sessionTypeSubDomainAdminTooltip' => 'Session de l\'utilisateur de sous-domaine',
    'ftpsessions.sessionTypeWebUserTooltip' => 'Session de l\'utilisateur Web',
    'ftpsessions.sessionTypeFtpAccountTooltip' => 'Session du compte FTP',
    'ftpsessions.sessionTypeAnonymousTooltip' => 'Session de l\'utilisateur FTP anonyme.',
    'ftpsessions.sessionTypeNotPleskUserTooltip' => 'Utilisateur FTP non enregistré dans Plesk.',
    'ftpsessions.sessionStatusIdle' => 'Inactif (pas de transaction).',
    'ftpsessions.sessionStatusUploadInProgress' => 'Envoi en cours.',
    'ftpsessions.sessionStatusDownloadInProgress' => 'Téléchargement en cours.',
    'ftpsessions.sessionStatusDownloadingDirsList' => 'Téléchargement d\'une liste de répertoires.',
    'ftpsessions.sessionStatusLastCmdIsType' => 'La dernière commande envoyée par le client est TYPE.',
    'ftpsessions.sessionStatusLastCmdIsPass' => 'La dernière commande envoyée par le client est PASS.',
    'ftpsessions.sessionStatusLastCmdIsNoop' => 'La dernière commande envoyée par le client est NOOP.',
    'ftpsessions.sessionStatusNotKnown' => 'Type d\'activité inconnue pour l\'utilisateur FTP.',
    'ftpsessions.confirmOnDelete' => 'Voulez-vous vraiment fermer les sessions sélectionnées ?',

    'ipaddresses.buttonAddNewIpAddress' => 'Ajouter une adresse IP',
    'ipaddresses.buttonAddNewIpAddressDescription' => 'Ajoutez une adresse IP au pool de serveur d\'adresses IP.',
    'ipaddresses.buttonRereadConfiguration' => 'Relire les IP',
    'ipaddresses.buttonRereadConfigurationDescription' => 'Synchronisez la liste des adresses IP avec la configuration des adaptateurs réseau.',
    'ipaddresses.buttonReloadPublic' => 'Mettre à jour les IP publiques',
    'ipaddresses.buttonReloadPublicDescription' => 'Mettre à jour les adresses IP publiques basées sur les métadonnées des instances hyperscaler',
    'ipaddresses.buttonFirewall' => 'Pare-feu',
    'ipaddresses.buttonFirewallDescription' => 'Configurez le pare-feu.',
    'ipaddresses.buttonRemove' => 'Supprimer',
    'ipaddresses.buttonRemoveDescription' => 'Supprimer',
    'ipaddresses.confirmOnDelete' => 'Supprimer les adresses IP sélectionnées ?',
    'ipaddresses.address' => 'Adresse IP',
    'ipaddresses.publicAddress' => 'Adresse IP publique',
    'ipaddresses.type' => 'Type d\'IP',
    'ipaddresses.interface' => 'Interface',
    'ipaddresses.resellerCount' => 'Revendeurs',
    'ipaddresses.subscriptionCount' => 'Sites',
    'ipaddresses.typeAny' => 'Tout',
    'ipaddresses.typeShared' => 'Partagée',
    'ipaddresses.typeExclusive' => 'Dédiée',
    'ipaddresses.typeSharedHint' => 'partagée',
    'ipaddresses.typeExclusiveHint' => 'dédiée',
    'ipaddresses.ipAddressBroken' => 'Cette adresse IP n\'est pas correctement configurée.',
    'ipaddresses.ipAddressBlacklisted' => 'Cette adresse IP est sur liste noire.',
    'ipaddresses.repair' => 'Réparer',
    'ipaddresses.buttonSearch' => 'Rechercher',
    'ipaddresses.buttonResetSearch' => 'Réinitialiser la recherche',
    'ipaddresses.removeConfirmation' => 'Voulez-vous vraiment supprimer {count, plural, =1 {l\'adresse IP {name}} one {l\'adresse IP sélectionnée} other {les # adresses IP sélectionnées}} ?',
    'ipaddresses.hint' => 'Affichez, ajoutez et supprimez des adresses IP.',
    'ipaddresses.hintWithResellers' => 'Affichez, ajoutez, supprimez des adresses IP et attribuez des adresses IP aux revendeurs.',
    'ipaddresses.repairSuccess' => 'L\'adresse IP %%address%% a été synchronisée avec le système.',
    'ipaddresses.removeSuccess' => 'Les adresses IP sélectionnées ont été supprimées.',

    'resourceusage.clientName' => 'Nom du client',
    'resourceusage.domainName' => 'Nom de domaine',
    'resourceusage.diskUsage' => 'DU',
    'resourceusage.traffic' => 'TR',
    'resourceusage.subDomainsCount' => 'SD',
    'resourceusage.webUsersCount' => 'UW',
    'resourceusage.databasesCount' => 'BD',
    'resourceusage.mailBoxesCount' => 'BMail',
    'resourceusage.autoRepliesCount' => 'MA',
    'resourceusage.mailForwardingsCount' => 'RM',
    'resourceusage.mailListsCount' => 'ML',
    'resourceusage.sendByEmail' => 'Cliquez pour envoyer ce rapport par mail',
    'resourceusage.buttonSendByEmail' => 'Envoyer par mail',
    'resourceusage.noResults' => 'Aucune information sur l\'utilisation des ressources du domaine.',
    'resourceusage.reportWasSent' => 'Information : le rapport a été envoyé par e-mail à l\'adresse %%email%%',

    'languages.headerStatus' => 'S',
    'languages.headerCode' => 'Pack de langues',
    'languages.headerLanguage' => 'Langue',
    'languages.headerCountry' => 'Pays',
    'languages.headerUsed' => 'Utilisé',
    'languages.filterCode' => 'Pack de langues',
    'languages.buttonDisable' => 'Désactiver',
    'languages.buttonDisableDescription' => 'Rendre les langues sélectionnées indisponibles aux utilisateurs.',
    'languages.disableDone' => 'Les langues sélectionnées ne sont plus disponibles aux utilisateurs.',
    'languages.buttonEnable' => 'Activer',
    'languages.buttonEnableDescription' => 'Rendre les langues sélectionnées disponibles aux utilisateurs.',
    'languages.enableDone' => 'Les langues sélectionnées sont maintenant disponibles aux utilisateurs.',
    'languages.buttonMakeDefault' => 'Utiliser par défaut',
    'languages.buttonMakeDefaultDescription' => 'Définissez la langue sélectionnée comme langue par défaut pour Plesk.',
    'languages.makeDefaultDone' => 'La langue sélectionnée a été définie comme langue par défaut pour Plesk.',
    'languages.makeDefaultSelectOne' => 'Sélectionnez une langue que vous voulez définir comme langue par défaut dans Plesk.',
    'languages.statusActive' => 'Cette langue n\'est pas disponible pour les utilisateurs de Plesk.',
    'languages.statusActiveUnavailable' => 'Cette langue n\'est plus à la disposition des utilisateurs car vous dépassez le nombre limite des packs de langues autorisés.',
    'languages.buttonHintStatusActive' => 'Cliquez sur l\'icône pour rendre la langue indisponible pour les utilisateurs.',
    'languages.statusInactive' => 'Cette langue n\'est pas à la disposition des utilisateurs.',
    'languages.buttonHintStatusInactive' => 'Cliquez sur l\'icône pour rendre la langue disponible pour les utilisateurs.',
    'languages.buttonHintStatusDefaultLangugage' => 'Il s\'agit de la langue par défaut, il est impossible de l\'interdire aux utilisateurs.',
    'languages.langUnknown' => 'Impossible de reconnaître la langue',
    'languages.countryUnknown' => 'Impossible de reconnaître le code du pays',

    'mailqueue.filterQueue' => 'Files d\'attente',
    'mailqueue.filterSubject' => 'Sujet',
    'mailqueue.filterSender' => 'Expéditeur',
    'mailqueue.filterRecipients' => 'Destinataire',
    'mailqueue.subject' => 'Sujet',
    'mailqueue.sender' => 'Expéditeur',
    'mailqueue.recipients' => 'Destinataires',
    'mailqueue.date' => 'Date',
    'mailqueue.age' => 'Âge',
    'mailqueue.size' => 'Taille',
    'mailqueue.buttonRefresh' => 'Actualiser',
    'mailqueue.buttonRefreshHint' => 'Actualisez les données sur l\'écran.',
    'mailqueue.buttonRemove' => 'Supprimer',
    'mailqueue.buttonRemoveHint' => 'Supprimez les messages sélectionnés de la file d\'attente de mails.',
    'mailqueue.confirmOnDelete' => 'Voulez-vous vraiment supprimer les messages sélectionnés de la file d\'attente de mails ?',
    'mailqueue.buttonClean' => 'Effacer',
    'mailqueue.buttonCleanHint' => 'Videz la file d\'attente de mails pour tous les messages.',
    'mailqueue.confirmOnClean' => 'Voulez-vous vraiment vider la file d\'attente ?',
    'mailqueue.queueAll' => 'Tout',
    'mailqueue.queueTodo' => 'Non pré-traités',
    'mailqueue.queueRemote' => 'Distant',
    'mailqueue.queueLocal' => 'Locaux',
    'mailqueue.queueLocalAndRemote' => 'Locaux et distants',
    'mailqueue.queueActive' => 'File d\'attente des mails actifs',
    'mailqueue.queueCorrupted' => 'File d\'attente des mails corrompus',
    'mailqueue.queueDeferred' => 'File d\'attente des mails différés',
    'mailqueue.queueHold' => 'File d\'attente des mails en attente',
    'mailqueue.queueIncoming' => 'File d\'attente des mails entrants',
    'mailqueue.postfixHint' => 'Messages dans la file d\'attente : %%deferred%% différés, %%hold%% en attente, %%incoming%% entrants, %%active%% actifs, %%corrupted%% corrompus, %%total%% au total.',
    'mailqueue.qmailHint' => 'Messages dans la file d\'attente : %%todo%% non pré-traités, %%local%% locaux, %%remote%% à distance, %%total%% au total.',
    'mailqueue.messagesDeleted' => 'Les messages sélectionnés ont été supprimés de la file d\'attente de mails.',
    'mailqueue.messagesNotDeleted' => 'Impossible de supprimer certains messages de la file d\'attente de mails : %%error%%',
    'mailqueue.queueCleaned' => 'La file d\'attente de mails a bien été effacée.',
    'mailqueue.queueNotCleaned' => 'Impossible d\'effacer la file d\'attente de mails : %%error%%.',

    'phpextensions.enable' => 'Activer l\'extension',
    'phpextensions.disable' => 'Désactiver l\'extension',

    'phpextensions.installable.status' => 'Statut',
    'phpextensions.installable.notInstalled' => 'Ne pas installer',
    'phpextensions.installable.outdated' => 'Obsolète, version la plus récente : %%latestVersion%%',
    'phpextensions.installable.latest' => 'Dernier',
    'phpextensions.installable.name' => 'pack',
    'phpextensions.installable.description' => 'Description',
    'phpextensions.installable.actionInstall' => 'Installer',
    'phpextensions.installable.actionUpgrade' => 'Mettre à niveau vers %%version%%',
    'phpextensions.installable.actionDocs' => 'Documentation',
    'phpextensions.installable.actionUninstall' => 'Désinstaller',
    'phpextensions.installable.uninstallConfirmation' => 'Voulez-vous vraiment désinstaller le package %%name%% ?',
    'phpextensions.installable.groupInstall' => 'Installer',
    'phpextensions.installable.groupReload' => 'Actualiser',
    'phpextensions.installable.buttonInstallCustom' => 'Installer le package',
    'phpextensions.installable.buttonInstallCustomHint' => 'Installer un package PECL',
    'phpextensions.installable.buttonReload' => 'Actualiser',
    'phpextensions.installable.buttonReloadHint' => 'Recharger le package PECL',
    'phpextensions.installable.emptyViewFilteredTitle' => 'Impossible de trouver des packages correspondants au filtre',
    'phpextensions.installable.emptyViewFilteredDescription' => 'Essayez d\'installer le package que vous cherchez.',

    'phphandlers.name' => 'Gestionnaire',
    'phphandlers.domains' => 'Domaines',
    'phphandlers.statusBroken' => 'Ce gestionnaire est corrompu.',
    'phphandlers.statusDisallowedApacheModule' => 'Impossible d\'activer le gestionnaire, car le module Apache correspondant est désactivé.',
    'phphandlers.domainsTitle' => '%%domains%% domaines utilisent PHP %%handler%%',
    'phphandlers.closeTitle' => 'Fermer',
    'phphandlers.handlerOutdated' => '(Obsolète)',
    'phphandlers.handlerDeprecated' => '(Dépréciée)',
    'phphandlers.handlerOutdatedAndDeprecated' => '(Obsolète, dépréciée)',

    'planitems.name' => 'Nom',
    'planitems.numberOfPlans' => 'Packs de services',
    'planitems.numberOfSubscriptions' => 'Abonnements',
    'planitems.itemInvisible' => 'Indisponible(s) pour les revendeurs',
    'planitems.buttonMakeItemVisible' => 'Rendre disponible',
    'planitems.buttonMakeItemVisibleDescription' => 'Laissez les revendeurs fournir les services sélectionnés avec leurs propres packs d\'hébergement. Les options correspondant à ces services s\'afficheront dans les propriétés du pack d\'hébergement, sur l\'onglet Autres services.',
    'planitems.buttonMakeItemInvisible' => 'Rendre indisponible',
    'planitems.buttonMakeItemInvisibleDescription' => 'Ne laissez pas les revendeurs fournir les services sélectionnés avec leurs packs d\'hébergement. Les options correspondant à ces services seront supprimées des propriétés du pack d\'hébergement.',
    'planitems.buttonAddNewCustomItemButton' => 'Ajouter un service',
    'planitems.buttonAddNewCustomItemButtonDescription' => 'Ajoutez un service à des options de pack.',
    'planitems.buttonRemoveCustomItem' => 'Supprimer le service',
    'planitems.buttonRemoveCustomItemDescription' => 'Supprimez les options correspondant aux services sélectionnés des propriétés du pack d\'hébergement.',
    'planitems.confirmOnDeleteSupportButton' => 'Voulez-vous vraiment retirer les options sélectionnées ?',

    'pumpackages.buttonUpdate' => 'Mettre à jour',
    'pumpackages.buttonUpdateDescription' => 'Mettez à jour les packs sélectionnés.',
    'pumpackages.buttonLock' => 'Verrouiller',
    'pumpackages.buttonLockDescription' => 'Verrouillez les packs sélectionnés pour empêcher les mises à jour.',
    'pumpackages.buttonUnlock' => 'Déverrouiller',
    'pumpackages.buttonUnlockDescription' => 'Déverrouillez les packs sélectionnés pour autoriser les mises à jour.',
    'pumpackages.buttonCheckUpdates' => 'Vérifier les mises à jour',
    'pumpackages.buttonCheckUpdatesDescription' => 'Vérifiez si des mises à jour de packs sont disponibles.',
    'pumpackages.name' => 'pack',
    'pumpackages.summary' => 'Description',
    'pumpackages.updates' => 'Mises à jour',
    'pumpackages.lockedCut' => 'V',
    'pumpackages.lockedHint' => 'Le pack est verrouillé.',
    'pumpackages.unlockedHint' => 'Ce pack est déverrouillé.',
    'pumpackages.updated' => 'À jour',
    'pumpackages.update' => 'Mettre à jour vers %%version%%',
    'pumpackages.unknownRepo' => 'inconnu',
    'pumpackages.allUpToDate' => 'Tous les packs sont à jour.',
    'pumpackages.allUpToDateLastChecked' => 'Vérifié le %%date%%',
    'pumpackages.recheckUpdates' => 'Revérifier',
    'pumpackages.popupInfoTitle' => 'Détails du pack %%package%%',
    'pumpackages.loading' => 'Veuillez patienter...',
    'pumpackages.error' => 'Impossible d\'obtenir la liste des packs : %%message%%',
    'pumpackages.currentVersion' => 'Version actuelle : %%version%%',
    'pumpackages.notInstalled' => 'Ne pas installer',
    'pumpackages.popupUpdateTitle' => 'Mettre à jour les packs',
    'pumpackages.popupUpdatePackagesListTitle' => 'Installer les mises à jour suivantes :',
    'pumpackages.popupUpdateLockedPackagesListTitle' => 'Les packs suivants sont requis, mais verrouillés à la mise à jour :',
    'pumpackages.popupUpdateDependencies' => '%%count%% packs dépendants',
    'pumpackages.unlockPackagesForUpdateOnly' => 'Déverrouiller les packs pour autoriser cette mise à jour uniquement',
    'pumpackages.lockedError' => 'L\'outil Mises à jour système installe déjà les mises à jour en mode automatique Essayez ultérieurement.',
    'pumpackages.duplicatesError' => 'Erreur : impossible de récupérer les informations de mise à jour, car certains packages sont en double. Supprimez les doublons des packages suivants : %%duplicates%%',
    'pumpackages.updateInfoError' => 'Erreur : impossible de recevoir les informations de mise à jour pour le ou les packs',
    'pumpackages.selectedPackagesUpToDate' => 'Tous les packs sélectionnés sont mis à jour.',
    'pumpackages.taskUpdatingPackages' => 'Mise à jour de %%count%% pack(s)...',
    'pumpackages.popupLockTitle' => 'Verrouiller les packs',
    'pumpackages.popupLockDescription' => 'Si vous verrouillez un pack, il ne sera pas mis à jour par l\'outil Mises à jour système, sauf si vous mettez à jour Plesk. Si d\'autres packs requièrent une version plus récente de ce pack pour leur propre mise à jour, ils ne seront pas mis à jour. Remarque : vous pouvez toujours mettre à jour un pack verrouillé via les outils d\'origine de la console. Pour mettre à jour un pack verrouillé depuis l\'interface Plesk, déverrouillez-le d\'abord.',
    'pumpackages.popupLockPackagesListTitle' => 'Verrouiller les packs suivants :',
    'pumpackages.popupUnlockTitle' => 'Déverrouiller les packs',
    'pumpackages.popupUnlockDescription' => 'Ces packs ne peuvent pas être mis à jour, car ils sont verrouillés pour empêcher les mises à jour. Remarque : vous pourrez toujours mettre à jour un pack verrouillé via les procédures d\'origine dans la console ou en mettant à jour Plesk. Pour mettre à jour un pack verrouillé depuis l\'interface Plesk, déverrouillez-le d\'abord.',
    'pumpackages.popupUnlockPackagesListTitle' => 'Déverrouiller les packs suivants :',
    'pumpackages.updatesAvailable' => 'Des mises à jour sont disponibles pour %%count%% packs système',
    'pumpackages.lastedChecked' => '(vérifié le %%date%%)',
    'pumpackages.updateAll' => 'Tout mettre à jour',
    'pumpackages.packageManagerDbInconsistent' => 'Les informations sur certains packs peuvent être erronées : des incohérences peuvent être détectées dans la base de données du gestionnaire de packs du système. Résolvez ce problème manuellement.',

    'resellers.filterResellerName' => 'Nom du revendeur',
    'resellers.filterSubscription' => 'Abonnement',
    'resellers.filterOptionSubscriptionAny' => 'Tout',
    'resellers.filterOptionSubscriptionCustom' => 'Personnalisé',
    'resellers.filterResourceUsage' => 'Utilisation des ressources',
    'resellers.filterOptionResourceUsageAny' => 'Tout',
    'resellers.filterOptionResourceUsageOveruse' => 'Ressources surutilisées',
    'resellers.filterOptionResourceUsageOk' => 'Dans les limites',
    'resellers.filterStatus' => 'Statut',
    'resellers.filterOptionStatusAny' => 'Tout',
    'resellers.filterOptionStatusSuspended' => 'Suspendu',
    'resellers.filterOptionStatusActive' => 'Actif',
    'resellers.filterSubscriptionStatus' => 'État de l\'abonnement',
    'resellers.filterOptionSubscriptionStatusAny' => 'Tout',
    'resellers.filterOptionSubscriptionStatusLocked' => 'Verrouillé',
    'resellers.filterOptionSubscriptionStatusUnsynchronized' => 'Non synchronisé',
    'resellers.filterDescription' => 'Description',
    'resellers.buttonAddNewReseller' => 'Ajouter un revendeur',
    'resellers.hintAddNewReseller' => 'Créez un compte revendeur.',
    'resellers.buttonRemove' => 'Supprimer',
    'resellers.hintRemove' => 'Supprimez les revendeurs sélectionnés et tous leurs packs de services, clients et abonnements.',
    'resellers.confirmOnDelete' => 'Voulez-vous supprimer {count, plural, =1 {le compte revendeur {name}} one {le compte revendeur sélectionné} other {les # comptes revendeurs sélectionnés}} et tous {count, plural, one {ses} other {leurs}} packs de services, clients et abonnements ?',
    'resellers.buttonConvertToCustomer' => 'Convertir en clients',
    'resellers.hintConvertToCustomer' => 'Convertissez les revendeurs sélectionnés en clients.',
    'resellers.buttonChangeStatus' => 'Changer le statut',
    'resellers.hintChangeStatus' => 'Remplacez le statut du revendeur par "Actif" ou par "Suspendu".',
    'resellers.buttonActivateResellers' => 'Activer',
    'resellers.hintActivateResellers' => 'Activez les comptes revendeur sélectionnés.',
    'resellers.buttonSuspendResellers' => 'Suspendre',
    'resellers.hintSuspendResellers' => 'Suspendez les comptes revendeur sélectionnés. L\'accès au Panneau Client sera bloqué pour les revendeurs et tous leurs clients ; les domaines des revendeurs et de leurs clients seront suspendus, leurs services Web, FTP et de messagerie ne seront plus accessibles aux utilisateurs Internet.',
    'resellers.resellerName' => 'Nom du revendeur',
    'resellers.planName' => 'Pack de services',
    'resellers.setupDate' => 'Date de configuration',
    'resellers.customers' => 'Clients',
    'resellers.customPlanName' => 'Personnalisé',
    'resellers.buttonLogin' => 'Se connecter en tant que revendeur',
    'resellers.hintLogin' => 'Gérez les services d\'hébergement associés au compte d\'hébergement du revendeur.',
    'resellers.statusOk' => 'Le statut du revendeur est OK : le compte est actif, l\'abonnement est synchronisé avec le pack.',
    'resellers.statusSuspended' => 'Le compte revendeur est suspendu : l\'accès au Panneau Client est bloqué pour le revendeur et tous ses clients ; les domaines du revendeur et de ses clients sont suspendus, leurs services Web, FTP et de messagerie ne sont plus accessibles aux utilisateurs Internet.',
    'resellers.statusLocked' => 'L\'abonnement est verrouillé pour la synchronisation : Il est exclu de la synchronisation car les paramètres d\'abonnement ont été personnalisés.',
    'resellers.statusUnsynchronized' => 'L\'abonnement n\'est pas synchronisé avec le pack revendeur .Il existe certains services et ressources que le pack revendeur offre mais que l\'abonnement ne fournit pas.',

    'resellerserviceplans.planName' => 'Nom du pack',
    'resellerserviceplans.planTraffic' => 'Trafic',
    'resellerserviceplans.planDiskSpace' => 'Espace disque',
    'resellerserviceplans.planSubscriptions' => 'Revendeurs',
    'resellerserviceplans.unlimited' => 'Illimité',
    'resellerserviceplans.buttonAddNewPlan' => 'Ajouter un pack',
    'resellerserviceplans.hintAddNewPlan' => 'Créez un pack revendeur.',
    'resellerserviceplans.buttonDuplicatePlans' => 'Cloner les packs',
    'resellerserviceplans.hintDuplicatePlans' => 'Créez des copies des packs revendeur sélectionnés.',
    'resellerserviceplans.buttonRemove' => 'Supprimer',
    'resellerserviceplans.hintRemove' => 'Supprimez les packs revendeur sélectionnés.',
    'resellerserviceplans.confirmOnDelete' => 'Voulez-vous vraiment supprimer les packs de revendeurs sélectionnés ?',
    'resellerserviceplans.disabledSelectHint' => 'Les packs revendeur ont au moins un abonnement qui lui est associé et ne peut pas être supprimé.',

    'restricteddomains.name' => 'Nom de domaine',
    'restricteddomains.buttonAddNewDomain' => 'Ajouter un nom de domaine',
    'restricteddomains.buttonEnableList' => 'Activer',
    'restricteddomains.hintAddNewDomain' => 'Ajoutez un nom de domaine interdit.',
    'restricteddomains.hintEnableList' => 'Activez la vérification des noms de domaine pendant la création de domaines.',
    'restricteddomains.buttonDisableList' => 'Désactiver',
    'restricteddomains.hintDisableList' => 'Désactivez la vérification des noms de domaine pendant la création de domaines.',
    'restricteddomains.buttonRemoveDomain' => 'Supprimer',
    'restricteddomains.hintRemoveDomain' => 'Supprimez les noms de domaine sélectionnés.',
    'restricteddomains.confirmOnRemove' => 'Supprimez les noms de domaines sélectionnés ?',
    'restricteddomains.buttonMoreActions' => 'Plus',

    'servermailblacklist.groupAdd' => 'Ajouter',
    'servermailblacklist.buttonAdd' => 'Ajouter un domaine',
    'servermailblacklist.buttonAddHint' => 'Ajouter le domaine à la liste noire',
    'servermailblacklist.groupActions' => 'Actions',
    'servermailblacklist.buttonRemove' => 'Supprimer',
    'servermailblacklist.entries' => 'Entrées',
    'servermailblacklist.action' => 'Action',
    'servermailblacklist.deleteAction' => 'Retirer du serveur',
    'servermailblacklist.spamAction' => 'Marquer comme spam',
    'servermailblacklist.spamAssassinDisabled' => 'Les éléments entrants ne seront pas signalés comme spam, car SpamAssassin n\'est pas installé ou parce qu\'il est désactivé.',
    'servermailblacklist.removeEmptySelection' => 'Aucune entrée n\'est sélectionnée.',
    'servermailblacklist.removeConfirmation' => 'Supprimer {count, plural, =1 {l\'entrée {name}} one {# entrée sélectionnée} other {# entrées sélectionnées}} ?',
    'servermailblacklist.removeSuccess' => 'Les entrées sélectionnées ont été supprimées.',

    'servermailwhitelist.groupAdd' => 'Ajouter',
    'servermailwhitelist.buttonAdd' => 'Ajouter un réseau',
    'servermailwhitelist.buttonAddHint' => 'Ajouter le réseau à la liste blanche',
    'servermailwhitelist.groupActions' => 'Actions',
    'servermailwhitelist.buttonRemove' => 'Supprimer',
    'servermailwhitelist.entries' => 'Entrées',
    'servermailwhitelist.whiteListNotEmpty' => 'Les limites des mails sortants ne fonctionneront pas pour les expéditeurs dont les adresses IP sont incluses dans la liste blanche du serveur de messagerie. Par exemple, s\'il y a un hôte local (127.0.0.0 / 8, ::1 / 128) dans la liste blanche, tous les mails du serveur local seront envoyés avec succès, quelles que soient les limitations. Les expéditeurs peuvent utiliser soit leurs adresses IP locales (sites Web et scripts personnalisés hébergés sur le serveur local) soit des adresses IP externes (clients qui expédient les mails depuis des clients de messagerie installés sur leurs ordinateurs ou périphériques mobiles). Pour que ces limites s\'appliquent à tous les expéditeurs (adresses IP locales et externes), supprimez toutes les adresses IP et tous les réseaux de la liste blanche. Remarque : si vous supprimez l\'hôte local (127.0.0.0 / 8, ::1 / 128) de la liste blanche, cela risque de compromettre le fonctionnement de sites Web et scripts qui envoient des mails depuis ce serveur. Pour en savoir plus sur les limitations des mails sortants, consultez le Guide de l\'administrateur, section Protéger contre les spams sortants.',
    'servermailwhitelist.removeEmptySelection' => 'Aucune entrée n\'est sélectionnée.',
    'servermailwhitelist.removeConfirmation' => 'Supprimer {count, plural, =1 {l\'entrée {name}} one {# entrée sélectionnée} other {# entrées sélectionnées}} ?',
    'servermailwhitelist.webmailAffected' => 'Supprimer {count, plural, =1 {le réseau} one {le réseau} other {les réseaux}} risque de rendre l\'envoi d\'e-mail impossible : %%list%%',
    'servermailwhitelist.webmailAffectedSingle' => 'Supprimer ce réseau risque de rendre l\'envoi d\'e-mails depuis la messagerie Web impossible.',
    'servermailwhitelist.removeSuccess' => 'Les entrées sélectionnées ont été supprimées.',

    'serverprotection.bannedips.pageHint' => 'Sur cette page, vous pouvez afficher les adresses IP bannies, désactiver leur bannissement ou les déplacer vers les adresses IP de confiance.',
    'serverprotection.bannedips.ip' => 'Adresse IP',
    'serverprotection.bannedips.banDate' => 'Bannie le',
    'serverprotection.bannedips.jail' => 'Jail utilisée',
    'serverprotection.bannedips.buttonRemoveIp' => 'Ne plus bannir',
    'serverprotection.bannedips.hintRemoveIp' => 'Supprimez les adresses IP sélectionnées de la liste des adresses bannies.',
    'serverprotection.bannedips.buttonMoveToTrustedIp' => 'Déplacer vers les IP de confiance',
    'serverprotection.bannedips.hintMoveToTrustedIp' => 'Déplacez les adresses IP sélectionnées vers la liste des adresses de confiance.',
    'serverprotection.bannedips.buttonEnable' => 'Activer le bannissement d\'adresses IP',
    'serverprotection.bannedips.hintEnable' => 'Activez le bannissement automatique d\'adresses IP et de réseaux qui génèrent du trafic malveillant pour votre serveur.',
    'serverprotection.bannedips.buttonDisable' => 'Désactiver le bannissement d\'adresses IP',
    'serverprotection.bannedips.hintDisable' => 'Désactivez le bannissement automatique d\'adresses IP et de réseaux qui génèrent du trafic malveillant pour votre serveur.',
    'serverprotection.bannedips.errorEnableFailed' => 'Impossible d\'activer le bannissement d\'adresses IP : %%error%%.',
    'serverprotection.bannedips.errorDisableFailed' => 'Impossible de désactiver le bannissement d\'adresses IP : %%error%%.',

    'serverprotection.filters.pageHint' => 'Sur cette page, vous pouvez gérer les filtres jail.',
    'serverprotection.filters.buttonAddFilter' => 'Ajouter un filtre',
    'serverprotection.filters.hintAddFilter' => 'Ajoutez un filtre.',
    'serverprotection.filters.buttonRemoveFilter' => 'Supprimer',
    'serverprotection.filters.hintRemoveFilter' => 'Supprimez le ou les filtres sélectionnés.',
    'serverprotection.filters.name' => 'Nom du filtre',

    'serverprotection.jails.pageHint' => 'Sur cette page, vous pouvez voir la liste des jails utilisées pour la détection d\'adresses IP abusives.',
    'serverprotection.jails.buttonAddJail' => 'Ajouter une jail',
    'serverprotection.jails.hintAddJail' => 'Ajoutez une jail.',
    'serverprotection.jails.buttonDisableJails' => 'Désactiver',
    'serverprotection.jails.hintDisableJails' => 'Désactivez les jails sélectionnées.',
    'serverprotection.jails.buttonActivateJails' => 'Activer',
    'serverprotection.jails.hintActivateJails' => 'Activez les jails sélectionnées.',
    'serverprotection.jails.buttonRemoveJail' => 'Supprimer',
    'serverprotection.jails.hintRemoveJail' => 'Supprimez les jails sélectionnées.',
    'serverprotection.jails.buttonManageFilters' => 'Gérer les filtres',
    'serverprotection.jails.hintManageFilters' => 'Gérez les filtres des jails.',
    'serverprotection.jails.name' => 'Nom de la jail',
    'serverprotection.jails.disabled' => 'Inactif',
    'serverprotection.jails.active' => 'Actif',
    'serverprotection.jails.status' => 'Statut',
    'serverprotection.jails.confirmOnDelete' => 'Voulez-vous vraiment supprimer les jails sélectionnées ?',

    'serverprotection.logs.pageHint' => 'Sur cette page, vous pouvez voir les journaux Fail2Ban.',
    'serverprotection.logs.name' => 'Fichier',
    'serverprotection.logs.viewHint' => 'Affichez le fichier journal.',
    'serverprotection.logs.buttonDownloadHint' => 'Télécharger le fichier journal',

    'serverprotection.trustedips.pageHint' => 'Sur cette page, vous pouvez voir les adresses IP de confiance, ajouter et supprimer des adresses IP de la liste des adresses de confiance.',
    'serverprotection.trustedips.ip' => 'Adresse IP',
    'serverprotection.trustedips.ipDesc' => 'Description',
    'serverprotection.trustedips.addDate' => 'Ajoutée aux adresses IP de confiance le',
    'serverprotection.trustedips.comment' => 'Commentaire',
    'serverprotection.trustedips.buttonRemoveIp' => 'Supprimer',
    'serverprotection.trustedips.hintRemoveIp' => 'Supprimez les adresses IP sélectionnées de la liste des adresses de confiance.',
    'serverprotection.trustedips.buttonAddTrustedIp' => 'Ajouter une adresse IP de confiance',
    'serverprotection.trustedips.hintAddTrustedIp' => 'Ajoutez une adresse IP à la liste des adresses IP de confiance.',
    'serverprotection.trustedips.buttonEditTrustedIp' => 'Éditer la description',
    'serverprotection.trustedips.buttonEditHint' => 'Modifiez la description d\'une adresse IP.',

    'services.stateColumnHeader' => 'Statut',
    'services.nameColumnHeader' => 'Service',
    'services.startupTypeColumnHeader' => 'Type de démarrage',
    'services.autoStartupType' => 'Automatique',
    'services.manualStartupType' => 'Manuel(le)',
    'services.disabledStartupType' => 'Désactivé',
    'services.changeStartupTypeTooltip' => 'Modifier le type de démarrage pour le service',
    'services.drwebName' => 'Plesk Premium Antivirus',
    'services.postgresqlName' => 'PostgreSQL',
    'services.tomcatName' => 'Tomcat Java',
    'services.imap-pop3Name' => 'Serveur Dovecot IMAP et POP3',
    'services.pop3Name' => 'Serveur Courier POP3',
    'services.pop3sName' => 'Serveur Courier POP 3 avec prise en charge SSL/TLS',
    'services.imapName' => 'Serveur Courier IMAP',
    'services.imapsName' => 'Serveur Courier IMAP avec prise en charge SSL/TLS',
    'services.authdaemonName' => 'Démon d\'authentification du Courier IMAP',
    'services.dnsName' => 'Serveur DNS (%%displayName%%)',
    'services.fail2banName' => 'Bannissement d\'adresses IP (Fail2Ban)',
    'services.kavName' => 'Antivirus Kaspersky',
    'services.milterName' => "Milter de Plesk (%%displayName%%)",
    'services.nginxName' => 'Reverse Proxy Server (Nginx)',
    'services.smtpName' => 'Serveur SMTP (%%displayName%%)',
    'services.spamassassinName' => "SpamAssassin",
    'services.webName' => "Serveur Web (%%displayName%%)",
    'services.resctrlName' => "Contrôleur de ressources (cgroups)",
    'services.activeState' => 'Activé',
    'services.inActiveState' => 'Désactivé',
    'services.do-restart' => 'Redémarrage',
    'services.do-start' => 'Lancement',
    'services.do-stop' => 'Désactivation',
    'services.do-changeStartup' => 'En cours de traitement',
    'services.notConfiguredState' => 'Non configuré',
    'services.notInstalledState' => 'Ne pas installer',
    'services.running-start' => 'Le service est déjà démarré.',
    'services.notRunning-start' => 'Démarrer le service.',
    'services.running-stop' => 'Arrêter le service.',
    'services.notRunning-stop' => 'Le service est déjà arrêté.',
    'services.running-restart' => 'Redémarrer le service.',
    'services.notRunning-restart' => 'Service arrêté.',
    'services.startServiceDrWeb' => 'Pour commencer à utiliser le service antivirus, vous devez avoir au moins une boîte mail sur laquelle le contrôle antivirus est activé.',
    'services.serviceDisabled' => 'Cette fonction n\'est pas disponible soit parce que votre clé de licence ne la prend pas en charge soit parce que le service n\'est pas installé ou configuré correctement.',
    'services.serviceDisabledStartupType' => 'Service désactivé.',
    'services.phpHandlerSettingsByOsVendor' => '%%displayName%% par fournisseur d\'OS',
    'services.phpFpm' => 'PHP-FPM %%displayName%%',
    'services.urlrewriteComponentName' => "Réécriture de l'URL",
    'services.dbconnectorComponentName' => "Connecteur de la base de données",
    'services.tomcatComponentName' => 'Apache Tomcat',
    'services.mysqlserverComponentName' => 'Serveur MariaDB/MySQL',
    'services.troubleshootingComponentName' => 'Résolution des problèmes',
    'services.wafComponentName' => 'Pare-feu applicatif',
    'services.vcsComponentName' => 'Gestion de versions',
    'services.antivirusComponentName' => "Antivirus",
    'services.databaseComponentName' => "Serveur SQL",
    'services.sqladminComponentName' => "MySQL Webadmin",
    'services.sqladminmysqlComponentName' => "MySQL Webadmin",
    'services.dnsserverComponentName' => "Serveur DNS",
    'services.firewallComponentName' => "Pare-feu",
    'services.ftpserverComponentName' => "Serveur FTP",
    'services.javaComponentName' => "Java",
    'services.mailserverComponentName' => "Serveur de messagerie",
    'services.pleskagentComponentName' => "Plesk Agent",
    'services.psaComponentName' => "Plesk",
    'services.scriptComponentName' => "Script Web",
    'services.spamfilterComponentName' => "Filtre anti-spam",
    'services.statsComponentName' => "Statistiques Web",
    'services.stunnelComponentName' => "Wrapper SSL/TLS",
    'services.webmailComponentName' => "Messagerie Web",
    'services.webpublishComponentName' => "Publication Web",
    'services.webserverComponentName' => "Serveur Web",
    'services.backupsystemComponentName' => 'Système de sauvegarde',
    'services.networkComponentName' => 'Réseau',
    'services.sitebuilderComponentName' => 'Presence Builder',
    'services.saviComponentName' => 'Interface antivirus Sophos',
    'services.waitMessage' => 'Veuillez patienter.',
    'services.buttonRefreshComponents' => 'Actualiser',
    'services.searchTitle' => 'Trouver les services...',
    'services.hintRefreshComponents' => 'Actualiser la liste des composants',

    'sessions.searchTitle' => 'Rechercher les sessions actives',
    'sessions.buttonRefresh' => 'Actualiser',
    'sessions.buttonRefreshDescription' => 'Synchronisez la liste des sessions avec les sessions ouvertes.',
    'sessions.buttonRemove' => 'Fermer',
    'sessions.buttonRemoveDescription' => 'Fermez les sessions sélectionnées.',
    'sessions.removeConfirmMessage' => 'Voulez-vous fermer les sessions sélectionnées ?',
    'sessions.buttonSettings' => 'Paramètres de la session',
    'sessions.buttonSettingsDescription' => 'Changez les paramètres de la session.',
    'sessions.headerType' => 'T',
    'sessions.headerLogin' => 'Nom d\'utilisateur',
    'sessions.headerIpAddress' => 'Adresse IP',
    'sessions.headerLogonTime' => 'Date/Heure de connexion',
    'sessions.headerIdleTime' => 'Période d\'inactivité',
    'sessions.typeAdmin' => 'Session administrateur',
    'sessions.typeReseller' => 'Session du revendeur',
    'sessions.typeClient' => 'Session du client',
    'sessions.altAdminIcon' => 'Admin',
    'sessions.altResellerIcon' => 'Revendeur',
    'sessions.altClientIcon' => 'Client',

    'sslcertificates.name' => 'Nom',
    'sslcertificates.used' => 'Utilisé',
    'sslcertificates.csrHint' => 'Le composant CSR est fourni.',
    'sslcertificates.noCsrHint' => 'Le composant CSR n\'est pas fourni.',
    'sslcertificates.privateKeyHint' => 'Le composant de la clé privée est fourni.',
    'sslcertificates.noPrivateKeyHint' => 'Le composant de la clé privée n\'est pas fourni.',
    'sslcertificates.certificateHint' => 'Le composant du certificat est fourni.',
    'sslcertificates.noCertificateHint' => 'Le composant du certificat n\'est pas fourni.',
    'sslcertificates.caCertificateHint' => 'Le composant du certificat CA est fourni.',
    'sslcertificates.noCaCertificateHint' => 'Le composant du certificat CA n\'est pas fourni.',
    'sslcertificates.buttonDownloadHint' => 'Téléchargez tous les composants du certificat.',
    'sslcertificates.remove' => 'Supprimer',
    'sslcertificates.hintRemove' => 'Supprimez les certificats SSL/TLS sélectionnés du répertoire de domaines.',
    'sslcertificates.confirmOnDelete' => 'Supprimer les certificats SSL/TLS sélectionnés ?',
    'sslcertificates.addCertificate' => 'Ajouter',
    'sslcertificates.hintAddCertificate' => 'Ajoutez un certificat SSL/TLS.',
    'sslcertificates.viewCertificates' => 'Voir',
    'sslcertificates.hintViewCertificates' => 'Affichez la liste des certificats SSL/TLS achetés chez votre fournisseur.',
    'sslcertificates.unableSetupPanelCertificate' => 'Impossible d\'installer le certificat dans Plesk : les contenus du certificat et de la clé privée manquent.',
    'sslcertificates.makeDefault' => 'Utiliser par défaut',
    'sslcertificates.hintMakeDefault' => 'Utilisez le certificat SSL/TLS sélectionné pour protéger les connexions aux nouveaux sites Web.',
    'sslcertificates.unableMakeDefault' => 'Impossible d\'installer le certificat par défaut : aucun certificat avec clé privée n\'a été sélectionné.',
    'sslcertificates.successMakeDefault' => 'Le certificat SSL/TLS sélectionné a été configuré comme certificat par défaut. Ce certificat peut être utilisé à la fois pour les sites Web existants et nouveaux. Les sites Web utilisant le certificat précédant par défaut continueront d\'utiliser ce certificat.',
    'sslcertificates.selectOne' => 'Sélectionnez un certificat SSL/TLS.',

    'subscriptions.filterDomainName' => 'Nom',
    'subscriptions.filterSubscription' => 'Pack de services',
    'subscriptions.filterOptionSubscriptionAny' => 'Tout',
    'subscriptions.filterOptionSubscriptionMy' => 'Mes packs',
    'subscriptions.filterOptionSubscriptionReseller' => 'Packs de %%planOwnerContactName%%',
    'subscriptions.filterOptionSubscriptionCustom' => 'Personnalisé',
    'subscriptions.filterOptionSubscriptionAddonType' => '(add-on)',
    'subscriptions.filterResourceUsage' => 'Utilisation des ressources',
    'subscriptions.filterOptionResourceUsageAny' => 'Tout',
    'subscriptions.filterOptionResourceUsageOveruse' => 'Ressources surutilisées',
    'subscriptions.filterOptionResourceUsageOk' => 'Dans les limites',
    'subscriptions.filterPlanItem' => 'Composant du pack personnalisé',
    'subscriptions.filterOptionPlanItemAny' => 'Tout',
    'subscriptions.filterProvider' => 'Fournisseur',
    'subscriptions.filterOptionProviderAny' => 'Tous les abonnements',
    'subscriptions.filterOptionProviderMy' => 'Mes abonnements',
    'subscriptions.filterProviderReseller' => 'Abonnements de %%resellerContactName%%',
    'subscriptions.filterStatus' => 'Statut',
    'subscriptions.filterOptionStatusAny' => 'Tout',
    'subscriptions.filterOptionStatusSuspended' => 'Suspendu',
    'subscriptions.filterOptionStatusActive' => 'Actif',
    'subscriptions.filterSubscriptionStatus' => 'État de l\'abonnement',
    'subscriptions.filterOptionSubscriptionStatusAny' => 'Tout',
    'subscriptions.filterOptionSubscriptionStatusLocked' => 'Verrouillé',
    'subscriptions.filterOptionSubscriptionStatusUnsynchronized' => 'Non synchronisé',
    'subscriptions.filterSubscriberName' => 'Abonné',
    'subscriptions.filterDescription' => 'Description',
    'subscriptions.subscriptionName' => 'Abonnement',
    'subscriptions.subscriberName' => 'Abonné',
    'subscriptions.setupDate' => 'Date de configuration',
    'subscriptions.expirationDate' => 'Date d\'expiration',
    'subscriptions.description' => 'Description',
    'subscriptions.resellerDescription' => 'Revendeur',
    'subscriptions.ownerDescription' => 'Client',
    'subscriptions.manageInResellerPanel' => 'Gérer dans le Panneau Revendeur',
    'subscriptions.manageInCustomerPanel' => 'Gérer dans le Panneau Client',
    'subscriptions.buttonAddNewOwnSubscription' => 'Ajouter un abonnement personnel',
    'subscriptions.hintAddNewOwnSubscription' => 'Créez un abonnement pour votre propre utilisation.',
    'subscriptions.buttonAddNewSubscription' => 'Ajouter un abonnement',
    'subscriptions.hintAddNewSubscription' => 'Créez un abonnement.',
    'subscriptions.buttonChangeSubscription' => 'Changer le pack',
    'subscriptions.hintChangeSubscription' => 'Associez les abonnements sélectionnés à un autre pack de services et ajoutez/supprimez les add-ons des packs si le fournisseur des abonnements en offre.',
    'subscriptions.buttonRemove' => 'Supprimer',
    'subscriptions.hintRemove' => 'Supprimez les abonnements sélectionnés.',
    'subscriptions.confirmOnRemove' => 'Voulez-vous vraiment retirer l\'abonnement sélectionné ?',
    'subscriptions.buttonSetStatus' => 'Définir le statut',
    'subscriptions.hintSetStatus' => 'Remplacez le statut de l\'abonnement par "Actif" ou par "Suspendu".',
    'subscriptions.buttonActivateSubscriptions' => 'Actif',
    'subscriptions.hintActivateSubscriptions' => 'Activez les abonnements sélectionnés.',
    'subscriptions.buttonSuspendSubscriptions' => 'Suspendu',
    'subscriptions.hintSuspendSubscriptions' => 'Suspendez les abonnements sélectionnés. Tous les services fournis avec les abonnements seront gelés et inaccessibles pour les utilisateurs Internet.',
    'subscriptions.buttonChangeOwner' => 'Changer l\'abonné',
    'subscriptions.hintChangeOwner' => 'Réaffectez les abonnements sélectionnés à un autre abonné. Cela changera également le fournisseur des abonnements, désassociera les abonnements de leurs packs de services et les transformera en "Personnalisé".',
    'subscriptions.customPlanName' => 'Personnalisé',
    'subscriptions.statusOk' => 'Le statut de l\'abonnement est OK : l\'abonnement est actif et synchronisé avec le pack.',
    'subscriptions.statusSuspended' => 'L\'abonnement est suspendu : tous les services fournis avec les abonnements sont gelés et inaccessibles pour les utilisateurs Internet.',
    'subscriptions.statusSuspendedReasonExpired' => 'L\'abonnement est suspendu car il a expiré : tous les services fournis avec l\'abonnement sont gelés et ne sont pas accessibles aux utilisateurs Internet.',
    'subscriptions.statusLocked' => 'L\'abonnement est verrouillé pour la synchronisation : Il est exclu de la synchronisation car les paramètres d\'abonnement ont été personnalisés.',
    'subscriptions.statusUnsynchronized' => 'L\'abonnement n\'est pas synchronisé avec le pack de services. Il existe certains services et ressources que le pack offre mais que l\'abonnement ne fournit pas.',
    'subscriptions.confirmOnDelete' => 'Voulez-vous supprimer {count, plural, =1 {l\'abonnement {name}} one {l\'abonnement sélectionné} other {les # abonnements sélectionnés}} ?',
    'subscriptions.hintInfo' => '(?)',
    'subscriptions.webserverConfigurationDomainHintAdmin' => "La configuration du serveur Web pour les domaines de l'abonnement risque d'être incohérente. Veuillez résoudre les erreurs dans les templates de la configuration Apache et essayez à nouveau de générer le fichier de configuration.",
    'subscriptions.webserverConfigurationDomainHintReseller' => "La configuration du serveur Web pour les domaines de l'abonnement risque d'être incohérente. Veuillez contacter l'administrateur de serveur pour résoudre ce problème.",
    'subscriptions.unlinkedDomainHint' => 'Certaines adresses IP de domaines sont inopérantes et exclues de la configuration du serveur. Vérifiez les associations entre IP et domaines et mettez-les à jour le cas échéant.',
    'subscriptions.hintTitle' => 'Récapitulatif de l\'abonnement',
    'subscriptions.hintWaitMessage' => 'Chargement en cours...',
    'subscriptions.removeConfirmationSubscription' => "Les domaines suivants seront également supprimés : %%domains%%",

    'summaryreportlayouts.delivery' => 'Remise',
    'summaryreportlayouts.name' => 'Nom',
    'summaryreportlayouts.general' => 'Général',
    'summaryreportlayouts.clients' => 'Clients',
    'summaryreportlayouts.resellers' => 'Revendeurs',
    'summaryreportlayouts.personalClients' => 'Clients personnels',
    'summaryreportlayouts.domains' => 'Domaines',
    'summaryreportlayouts.personalDomains' => 'Domaines personnels',
    'summaryreportlayouts.section.FULL' => 'Complète',
    'summaryreportlayouts.section.NONE' => 'Aucun',
    'summaryreportlayouts.section.SUMMARY' => 'Récapitulatif',
    'summaryreportlayouts.groupRemove' => 'Supprimer',
    'summaryreportlayouts.buttonRemove' => 'Supprimer',
    'summaryreportlayouts.buttonRemoveHint' => 'Supprimez les styles sélectionnés.',
    'summaryreportlayouts.removeEmptySelection' => 'Sélectionnez un ou plusieurs styles à supprimer',
    'summaryreportlayouts.removeConfirmation' => 'Voulez-vous vraiment supprimer {count, plural, =1 {le style {name} } one {le style sélectionné} other {les # styles}} ?',
    'summaryreportlayouts.groupAdd' => 'Ajouter',
    'summaryreportlayouts.buttonAdd' => 'Ajouter un style',
    'summaryreportlayouts.buttonAddHint' => 'Ajouter un style au rapport',
    'summaryreportlayouts.autoDeliveryOn' => 'Ce rapport est programmé pour être envoyé.',
    'summaryreportlayouts.autoDeliveryOff' => 'Ce rapport n\'est pas envoyé automatiquement.',
    'summaryreportlayouts.removeSuccess' => 'Les styles sélectionnés ont été supprimés.',

    'summaryreportschedules.status' => 'S',
    'summaryreportschedules.on' => 'Activé',
    'summaryreportschedules.off' => 'Désactivé',
    'summaryreportschedules.period' => 'Fréquence',
    'summaryreportschedules.lastSentDate' => 'Dernière date d\'expédition',
    'summaryreportschedules.email' => 'Envoyer à/au',
    'summaryreportschedules.disabled' => 'Désactivé',
    'summaryreportschedules.day' => 'Ts les jours',
    'summaryreportschedules.week' => 'Ttes les semaines',
    'summaryreportschedules.month' => 'Ts les mois',
    'summaryreportschedules.groupAdd' => 'Ajouter',
    'summaryreportschedules.buttonAdd' => 'Ajouter une planification',
    'summaryreportschedules.buttonAddHint' => 'Ajouter une planification pour la remise',
    'summaryreportschedules.groupRemove' => 'Supprimer',
    'summaryreportschedules.buttonRemove' => 'Supprimer',
    'summaryreportschedules.buttonRemoveHint' => 'Supprimez les planifications sélectionnées.',
    'summaryreportschedules.removeEmptySelection' => 'Sélectionnez une ou plusieurs planifications à supprimer.',
    'summaryreportschedules.removeConfirmation' => 'Voulez-vous vraiment supprimer {count, plural, one {}=1 {la planification de remise sélectionnée} other {les # planifications de remise sélectionnées}} ?',
    'summaryreportschedules.removeSuccess' => 'Les planifications de remises sélectionnées ont été supprimées.',

    'traffichistory.year' => 'Année',
    'traffichistory.month' => 'Mois',
    'traffichistory.trafficUsage' => 'Utilisation du trafic',
    'traffichistory.noData' => 'Aucune donnée d\'historique disponible.',

    'webappfirewalllogfiles.name' => 'Nom',
    'webappfirewalllogfiles.modificationDate' => 'Date de modification',
    'webappfirewalllogfiles.fileSize' => 'Taille',
    'webappfirewalllogfiles.remove' => 'Supprimer',
    'webappfirewalllogfiles.hintRemove' => 'Supprimez les fichiers journaux sélectionnés. Seuls les fichiers journaux traités peuvent être supprimés.',
    'webappfirewalllogfiles.confirmOnDelete' => 'Supprimer les fichiers journaux sélectionnés ?',
    'webappfirewalllogfiles.viewHint' => 'Cliquez pour voir le fichier journal.',
    'webappfirewalllogfiles.buttonDownloadHint' => 'Cliquer ici pour télécharger le fichier journal.',

    'webmails.name' => 'Nom',
    'webmails.url' => 'URL',
    'webmails.buttonAddNewWebmail' => 'Enregistrer une messagerie Web',
    'webmails.hintAddNewWebmail' => 'Enregistrez un service de messagerie Web supplémentaire dans Plesk.',
    'webmails.buttonEnableWebmail' => 'Activer',
    'webmails.hintEnableWebmail' => 'Rendez les services de la messagerie Web sélectionnés disponibles pour les clients.',
    'webmails.buttonDisableWebmail' => 'Désactiver',
    'webmails.hintDisableWebmail' => 'Rendez les services de la messagerie Web sélectionnés indisponibles pour les clients.',
    'webmails.buttonRemoveWebmail' => 'Supprimer',
    'webmails.hintRemoveWebmail' => 'Supprimez l\'enregistrement des services de messagerie Web supplémentaires sélectionnés. Remarque : vous ne pouvez pas supprimer une messagerie Web installée avec le Programme d\'installation de Plesk sur cette page. Pour cela, allez sous Outils >  Mises à jour.',
    'webmails.confirmOnDelete' => 'Voulez-vous vraiment supprimer les enregistrements de messagerie Web sélectionnés de Plesk ?',
    'webmails.statusSuspended' => 'La messagerie Web n\'est pas disponible.',
    'webmails.statusOk' => 'La messagerie Web est disponible.',
];