<?php
// Copyright 1999-2024. WebPros International GmbH. All rights reserved.
$messages = [
    'aps-install.queue' => 'Installazione di %%name%% su %%path%% in corso...',
    'aps-install.queueNoPath' => 'Installazione di %%name%% in corso...',
    'aps-install.done' => '%%name%% è stato installato su %%path%%. Puoi visualizzare le credenziali per accedere all\'applicazione sotto.%%additionalMessage%%',
    'aps-install.doneNoPath' => '%%name%% è stato installato. Puoi visualizzare le credenziali per accedere all\'applicazione sotto.%%additionalMessage%%',
    'aps-install.doneAdvanced' => '%%name%% è stato installato su %%path%%. %%additionalMessage%%',
    'aps-install.doneAdvancedNoPath' => '%%name%% è stato installato. %%additionalMessage%%',
    'aps-install.error' => 'Installazione di %%name%% su %%path%% non riuscita. %%errorMessage%%',
    'aps-install.errorNoPath' => 'Installazione di %%name%% non riuscita. %%errorMessage%%',

    'aps-update.queueDownload' => 'Download di %%packageName%% in corso...',
    'aps-update.errorDownload' => 'Il download di %%packageName%% non è riuscito:',
    'aps-update.queueInstall' => 'Aggiornamento di un\'installazione di %%name%% per %%domainName%%...',
    'aps-update.doneInstall' => 'L\'installazione di %%name%% per %%domainName%% è stata aggiornata.',
    'aps-update.errorInstall' => 'L\'aggiornamento di un\'installazione di %%name%% per %%domainName%% non è riuscito:',
    'aps-update.queueInstallMulti' => 'Aggiornamento di %%instances%% installazioni di %%name%% in corso...',
    'aps-update.doneInstallMulti' => '%%successes%% installazioni di %%name%% sono state aggiornate.',
    'aps-update.errorInstallMulti' => 'L\'aggiornamento di %%failures%% installazioni di %%name%% non è riuscito:',
    'aps-update.incorrectUpdateInformation' => 'Informazione dell\'aggiornamento errata.',

    'common.hideCompletedTasks' => 'Nascondi Completati',
    'common.progressBarHide' => 'Nascondi',
    'common.progressBarShow' => 'Mostra',
    'common.close' => 'Chiudi',
    'common.refresh' => 'Aggiorna la pagina',
    'common.taskInProgress' => '%%count%% attività in corso...',
    'common.percentCompleted' => '%%percent%%% completato',
    'common.allTasksCompleted' => 'Tutte le attività %%num%% sono state completate correttamente.',
    'common.minimize' => 'Nascondi',
    'common.statusDone' => 'Fatto',
    'common.statusError' => 'Non riuscita',
    'common.statusNotStarted' => 'Accodato',
    'common.statusCanceled' => 'Annullato',
    'common.progressDialogLink' => 'avanzamento dettagliato',

    'database-check.queue' => 'Verifica tabelle del database %%database%% in corso...',
    'database-check.done' => 'Il database %%database%% non presenta errori.',
    'database-check.error' => 'Impossibile verificare l\'esistenza di errori nel database %%database%%.',
    'database-check.done-with-errors' => "Il database %%database%% ha %%number%% problemi. \n %%link%%",
    'database-check.info-link-title' => 'Vedi dettagli e risolvi',

    'database-download.queue' => 'Preparazione di un dump %%database%% per l\'esportazione in corso...',
    'database-download.done' => 'Il dump di %%database%% è pronto. È possibile eseguire il %%downloadLink%%.',
    'database-download.downloadLink' => 'scarica',
    'database-download.error' => 'Impossibile esportare un dump di %%database%%:',

    'database-repair.queue' => 'Riparazione tabelle del database %%database%% in corso...',
    'database-repair.done' => 'Il database %%database%% non presenta errori.',
    'database-repair.error' => 'Impossibile riparare il database %%database%%.',
    'database-repair.done-with-errors' => "Il database %%database%% ha %%number%% problemi. \n %%link%%",
    'database-repair.info-link-title' => 'Vedi dettagli',

    'database-upload.queue' => 'Esegui l\'import di un dump di %%database%%...',
    'database-upload.done' => 'Il dump di %%database%% è stato importato.',
    'database-upload.error' => 'Impossibile importare il dump di %%database%%:',
    'database-upload.done-with-errors' => "Il dump di %%database%% è stato importato con errori.",
    'database-upload.orphanedUsersSuccess' => 'Il database %%database%% è stato importato. Tuttavia, alcuni utenti diventano orfani (senza avere login associati sul server database). Per essere in grado di accedere ai database, assegna dei login a tali utenti. %%viewUsersLink%%.',
    'database-upload.orphanedUsersError' => 'I seguenti utenti diventano orfani (senza avere login associati sul server database): %%orphanedUsers%%.',
    'database-upload.orphanedUsersLink' => 'Visualizza utenti',

    'domain-app-scan.queue' => 'Analisi delle applicazioni in corso...',
    'domain-app-scan.done' => 'Analisi per le applicazioni completata.',
    'domain-app-scan.error' => 'Analisi per le applicazioni conclusa con errori.',

    'domain-move.queue' => 'Spostamento di %%domainName%% in %%webspaceName%%',
    'domain-move.done' => '%%domainName%% è stato spostato in %%webspaceName%%',
    'domain-move.error' => '%%domainName%% non è stato spostato in %%webspaceName%%',

    'domain-split.queue' => 'Spostamento di %%domainName%% in un nuovo abbonamento',
    'domain-split.done' => '%%domainName%% è stato spostato in un nuovo abbonamento',
    'domain-split.error' => '%%domainName%% non è stato spostato in un nuovo abbonamento',

    'file-manager-import-file.done' => 'Il file %%fileName%% è stato importato nella cartella <a href="%%listUrl%%">%%fileDir%%</a>.',
    'file-manager-import-file.error' => 'Impossibile importare il file %%fileName%%: %%errorMessage%%.<br><a href="%%url%%">Scarica sul mio computer</a>',
    'file-manager-import-file.queue' => 'Importazione del file %%fileName%% da %%host%%.',
    'file-manager-import-file.progress' => 'Importazione del file %%fileName%% da %%host%% (%%value%% MB).',
    'file-manager-import-file.errors.auth' => 'Errore di autenticazione. Assicurati di aver inserito le credenziali corrette',
    'file-manager-import-file.errors.resolve' => 'Impossibile risolvere il nome host %%host%%. Assicurati di aver fornito l\'URL corretto',
    'file-manager-import-file.errors.connect' => 'Impossibile connettersi al server %%host%%. Assicurati di aver fornito l\'URL corretto',
    'file-manager-import-file.errors.notFound' => 'Il file remoto non è stato trovato o non è accessibile. Assicurati di fornire l\'URL corretto e che il file sia accessibile',
    'file-manager-import-file.errors.maxSize' => 'Il limite dello spazio su disco o dello spazio gratuito %%diskSpaceLimit%% è stato superato',
    'file-manager-import-file.errors.lowSpeedTime' => 'Impossibile importare il file perché la velocità di trasferimento è troppo bassa: negli ultimi %%lowSpeedTime%% secondi sono stati trasferiti meno di %%lowSpeedLimit%% byte. È possibile che il sito su cui si trova il file debba gestire molto traffico al momento. Prova a importare il file più tardi',
    'file-manager-import-file.errors.certificate' => 'Impossibile importare il file perché il certificato SSL/TLS del server %%host%% non è sicuro. Assicurati che il sito web in cui si trova il file sia protetto da un certificato affidabile',
    'file-manager-import-file.errors.redirects' => 'Limite massimo di reindirizzamenti (%%maxRedirects%%) superato. Assicurati che il server %%host%% funzioni correttamente',

    'force-log-rotation.queue' => 'Applicazione delle impostazioni di rotazione globale dei registri',
    'force-log-rotation.done' => 'Le impostazioni di rotazione globale dei registri sono state applicate.',
    'force-log-rotation.error' => 'L’applicazione della rotazione globale dei registri è terminata con errori',
    'force-log-rotation.systemLogRotationError' => 'Registri di sistema: %%error%%',
    'force-log-rotation.planLogRotationError' => 'Piano di servizio %%name%%: %%error%%',
    'force-log-rotation.domainLogRotationError' => 'Dominio %%name%%: %%error%%',

    'initial-setup.queue' => 'Inizializzazione di Plesk in corso...',
    'initial-setup.done' => 'Plesk è stato inizializzato.',
    'initial-setup.doneWithErrors' => 'Si è verificato un errore durante l’inizializzazione di Plesk.',
    'initial-setup.error' => 'Inizializzazione di Plesk non riuscita.',
    'initial-setup.step.setupPanel' => 'Configurazione Plesk Panel',
    'initial-setup.step.requestLicense' => 'Richiesta di licenza',
    'initial-setup.step.configureServer' => 'Configurazione del server web',
    'initial-setup.step.secureServer' => 'Protezione del server',

    'ip-update.queue' => 'Aggiornamento dell\'indirizzo IP',
    'ip-update.done' => 'Indirizzo IP aggiornato.',
    'ip-update.error' => 'L\'aggiornamento dell\'indirizzo IP è terminato con errori',
    'ip-update.updating' => 'Aggiornamento dell\'indirizzo IP',
    'ip-update.updatingWebServer' => 'Aggiornamento dell\'indirizzo IP: aggiornamento server web',
    'ip-update.updatingFtpServer' => 'Aggiornamento dell\'indirizzo IP: aggiornamento server FTP',
    'ip-update.updatingDnsZones' => 'Aggiornamento dell\'indirizzo IP: aggiornamento zone DNS',
    'ip-update.restartingDnsService' => 'Aggiornamento dell\'indirizzo IP: riavvio server DNS',

    'ip-reload-public.queue' => 'Aggiornamento degli indirizzi IP pubblici utilizzando i metadati del cloud',
    'ip-reload-public.done' => 'Indirizzi IP pubblici aggiornati',

    'logrotate_anonymize_ips.queue' => 'Anonimizza indirizzi IP nei registri',
    'logrotate_anonymize_ips.queueRevert' => 'Annulla anonimizzazione degli indirizzi IP nei registri',
    'logrotate_anonymize_ips.done' => 'Gli indirizzi IP sono stati anonimizzati.',
    'logrotate_anonymize_ips.doneRevert' => 'L’anonimizzazione degli indirizzi IP è stata annullata.',
    'logrotate_anonymize_ips.error' => 'L\'anonimizzazione degli indirizzi e-mail è terminata con errori',
    'logrotate_anonymize_ips.errorRevert' => 'L\'annullamento dell’anonimizzazione degli indirizzi IP è terminato con errori',

    'panel-components-install.queue' => 'Installare i componenti selezionati',
    'panel-components-install.done' => 'I componenti selezionati sono stati installati correttamente.',
    'panel-components-install.error' => 'Impossibile installare i componenti. Una notifica con la descrizione dell\'errore è stata inviata al tuo indirizzo e-mail.',

    'panel-update.queue' => 'Installazione di aggiornamenti di Plesk in corso. L’operazione può richiedere qualche istante. %%warning%%',
    'panel-update.warning' => 'Non effettuare operazioni di gestione in Plesk fino al completamento dell\'aggiornamento.',
    'panel-update.done' => 'Plesk è stato aggiornato. Per ulteriori informazioni consulta il %%changelog%%.',
    'panel-update.changelog' => 'Changelog di Plesk',
    'panel-update.error' => 'Aggiornamento di Plesk non riuscito. %%errorDetails%%',
    'panel-update.support' => 'Per risolvere questo problema, è possibile inviare all\'assistenza Plesk il registro aggiornato. %%failedLog%% Copia il registro sul tuo computer prima di chiudere questo messaggio.',
    'panel-update.failedLog' => 'Visualizza il registro di aggiornamento a partire dal %%date%%.',

    'pum-update-packages.queue' => 'Aggiornamento %%count%% pacchetti.',
    'pum-update-packages.done' => 'L\'aggiornamento di %%count%% pacchetti è andato a buon fine.',
    'pum-update-packages.error' => 'Aggiornamento non riuscito.',

    'scheduler-run-task.queue' => 'Esecuzione dell\'attività "%%task%%" in corso...',
    'scheduler-run-task.done' => 'Attività di "%%task%%" completata in %%seconds%% secondi.',
    'scheduler-run-task.error' => 'Attività "%%task%%" completata con errori in %%seconds%% secondi.',
    'scheduler-run-task.popupSeeDetails' => 'vedi dettagli',
    'scheduler-run-task.popupTitle' => 'Esegui attività pianificata',
    'scheduler-run-task.popupDone' => 'Attività di "%%task%%" completata in %%seconds%% secondi, output:',
    'scheduler-run-task.popupError' => 'Attività "%%task%%" completata con errori in %%seconds%% secondi, output:',
    'scheduler-run-task.popupClose' => 'Chiudi',

    'sdk.queue' => 'L\'attività "%%name%%" è in corso...',
    'sdk.error' => 'L\'attività "%%name%%" non è riuscita.',
    'sdk.done' => 'L\'attività "%%name%%" è terminata.',
    'sdk.canceled' => 'L\'attività "%%name%%" è stata annullata.',

    'sync-php-settings.queue' => 'Applicazione delle impostazioni PHP globali %%version%% ai domini',
    'sync-php-settings.done' => 'Le impostazioni PHP globali %%version%% sono state applicate ai domini',
    'sync-php-settings.error' => 'Si è verificato un errore durante l\'applicazione della configurazione PHP globale %%version%% ai domini',

    'sync-service-plan.queue' => 'Sincronizzazione del piano di servizio %%name%% con gli abbonamenti',
    'sync-service-plan.done' => 'Il piano di servizio %%name%% è stato sincronizzato con gli abbonamenti',
    'sync-service-plan.doneWithErrors' => 'La sincronizzazione del piano di servizio %%name%% è stata completata. Alcuni abbonamenti non erano sincronizzati con il piano',
    'sync-service-plan.error' => 'Si è verificato un errore durante la Sincronizzazione del piano di servizio %%name%% con gli abbonamenti',

    'domain-create.queue' => 'Creazione dominio %%domainName%%',
    'domain-create.done' => 'Il dominio %%domainName%% è stato creato',
    'domain-create.error' => 'Creazione del dominio %%domainName%% non riuscita',
    'domain-create.warning' => 'Il dominio %%domainName%% è stato creato con alcuni problemi:<br>%%problems%%',
    'domain-create.refreshUrl' => 'Mostra',
    'domain-create.steps.createCustomer' => 'Creazione cliente',
    'domain-create.steps.createSubscription' => 'Creazione abbonamento',
    'domain-create.steps.createDomain' => 'Aggiunta di un dominio',
    'domain-create.steps.configureDns' => 'Configurazione della zona DNS',
    'domain-create.steps.createHosting' => 'Creazione hosting fisico',
    'domain-create.steps.configurePhp' => 'Configurazione PHP',
    'domain-create.steps.configureMail' => 'Configurazione della posta',

    'domain-delete.queue' => 'Eliminazione dell\'elaborazione dei domini',
    'domain-delete.done' => 'Dominio eliminato',
    'domain-delete.error' => 'Eliminazione dominio non riuscita',
    'domain-delete.step.domains' => 'Eliminazione dominio…',

    'domain-resolve-checking.warning' => 'Rilevato problema con la risoluzione del dominio %%domainName%%: <br> %%errors%%',

    'customer-create.queue' => 'Creazione del cliente %%customerName%% in corso',
    'customer-create.done' => 'Cliente %%customerName%% creato',
    'customer-create.error' => 'Creazione cliente %%customerName%% non riuscita',
    'customer-create.warning' => 'Il cliente %%customerName%% è stato creato con alcuni problemi:<br>%%problems%%',
    'customer-create.warnings.notSynchronizedLink' => 'Prova a eseguire una sincronizzazione manuale.',

    'customer-delete.queue' => 'Eliminazione dell\'elaborazione dei clienti',
    'customer-delete.done' => 'Clienti eliminati',
    'customer-delete.error' => 'Eliminazione dei clienti non riuscita',

    'reseller-delete.queue' => 'Eliminazione dell\'elaborazione dei rivenditori',
    'reseller-delete.done' => 'Rivenditori eliminati',
    'reseller-delete.error' => 'Eliminazione dei rivenditori non riuscita',

    'subscription-create.queue' => 'Creazione dell\'abbonamento %%subscriptionName%% in corso',
    'subscription-create.done' => 'Abbonamento %%subscriptionName%% creato',
    'subscription-create.error' => 'Creazione dell\'abbonamento %%subscriptionName%% non riuscita',
    'subscription-create.warning' => 'L\'abbonamento %%subscriptionName%% è stato creato con alcuni problemi:<br>%%problems%%',
    'subscription-create.warnings.notSynchronizedLink' => 'Prova a eseguire una sincronizzazione manuale.',

    'subscription-delete.queue' => 'Eliminazione dell\'elaborazione di abbonamenti',
    'subscription-delete.done' => 'Abbonamenti eliminati',
    'subscription-delete.error' => 'Eliminazione abbonamenti non riuscita',

    'websites-diagnostic.queue' => 'Esecuzione diagnostica siti',
    'websites-diagnostic.done' => 'Diagnostica siti completata',
    'websites-diagnostic.error' => 'Diagnostica siti completata con errori',

    'install-php-extension.queue' => 'Installazione del pacchetto %%extensionName%% sul gestore PHP %%phpHandlerName%%',
    'install-php-extension.done' => 'Il pacchetto %%extensionName%% è stato installato sul gestore PHP %%phpHandlerName%%',
    'install-php-extension.error' => 'Installazione del pacchetto %%extensionName%% sul gestore PHP %%phpHandlerName%% non riuscita',
    'install-php-extension.step.validate' => 'Verifica requisiti',
    'install-php-extension.step.dependencies' => 'Risoluzione dipendenze',
    'install-php-extension.step.process' => 'Installazione pacchetto',
    'install-php-extension.step.enable' => 'Abilitazione estensione',
    'install-php-extension.step.sync' => 'Sincronizzazione siti',
    'install-php-extension.errorReason' => 'La lista di pacchetti disponibili è fornita da PECL. Le motivazioni più comuni per il fallimento dell\'installazione sono le seguenti:',
    'install-php-extension.errorReasonDependencies' => '- Il pacchetto ha delle dipendenze esterne su librerie aggiuntive.',
    'install-php-extension.errorReasonRequirements' => '- Il pacchetto non soddisfa i requisiti d\'installazione (sistema operativo, versione di PHP e così via).',
    'install-php-extension.errorReasonOutdated' => '- Il pacchetto è obsoleto.',
    'install-php-extension.errorOutput' => 'Per identificare il motivo dell\'installazione non riuscita, esamina l\'output dell\'utility.',

    'uninstall-php-extension.queue' => 'Disinstallazione del pacchetto %%extensionName%% sul gestore PHP %%phpHandlerName%%',
    'uninstall-php-extension.done' => 'Il pacchetto %%extensionName%% è stato disinstallato dal gestore PHP %%phpHandlerName%%',
    'uninstall-php-extension.error' => 'Disinstallazione del pacchetto %%extensionName%% sul gestore PHP %%phpHandlerName%% non riuscita',
    'uninstall-php-extension.step.validate' => 'Verifica requisiti',
    'uninstall-php-extension.step.process' => 'Disinstallazione pacchetto',
    'uninstall-php-extension.step.sync' => 'Sincronizzazione siti Web',

    'upgrade-database-server.queue' => 'Aggiornamento del server database...',
    'upgrade-database-server.error' => 'Impossibile aggiornare il server database',
    'upgrade-database-server.done' => 'Il server database è stato aggiornato',
    'upgrade-database-server.step.validate' => 'Verifica del sistema...',
    'upgrade-database-server.step.dump' => 'Creare un dump dei database',
    'upgrade-database-server.step.disableService' => 'Disattivazione del vecchio servizio del sistema',
    'upgrade-database-server.step.configureRepo' => 'Configurazione del nuovo archivio',
    'upgrade-database-server.step.upgradePackages' => 'Aggiornamento del server database...',
    'upgrade-database-server.step.updateConfiguration' => 'Aggiornamento della configurazione del server in corso',
    'upgrade-database-server.step.startService' => 'Inizializzazione del nuovo servizio del sistema',
    'upgrade-database-server.step.upgradeTablesStructure' => 'Aggiornare la struttura di tutte le tabelle',
    'upgrade-database-server.step.sync' => 'Sincronizzare i componenti del sistema',

    'update-spam-filter-individual-settings.queue' => 'Aggiornamento delle impostazioni del filtro antispam',
    'update-spam-filter-individual-settings.done' => 'Le impostazioni del filtro antispam sono state aggiornate',
    'update-spam-filter-individual-settings.error' => 'Aggiornamento delle impostazioni del filtro antispam non riuscito',
    'update-spam-filter-individual-settings.mailNameError' => 'Indirizzo email di %%name%%: %%error%%',

    'update-default-cert.queue' => 'Aggiornamento del certificato predefinito',
    'update-default-cert.done' => 'Il certificato predefinito è stato aggiornato.',
    'update-default-cert.error' => 'L\'aggiornamento del certificato predefinito si è concluso con degli errori.',
    'update-default-cert.step.updating' => 'Aggiornamento del certificato predefinito…',
];