<?php
// Copyright 1999-2024. WebPros International GmbH. All rights reserved.
// This file contains structured and commented locale keys for Plesk 9.x

global $PROD_NAME;

$GLOBALS['lmsg_arr'] += [
    ////
    //// LOGIN SCREEN
    ////

    'login_up__access_denied_account_disabled' => "ปฏิเสธการเข้าถึง บัญชีของคุณถูกระงับการใช้งาน",
    'login_up__login_has_been_locked' => "คุณพยายามที่จะล็อกอินโดยใช้รหัสผ่านผิดหลายครั้งเกินไป ด้วยเหตุผลด้านความปลอดภัย คุณจะไม่สามารถล็อกอินด้วยชื่อผู้ใช้นี้ได้ในบางครั้ง",
    'login_up__unable_to_check_pass' => "ไม่สามารถตรวจสอบรหัสผ่าน: %1",
    'login_up__warning_limits_licence_key' => "หนึ่งในรายการต่อไปนี้มีการใช้งานเกินขีดจำกัดที่กำหนดโดยรหัสลิขสิทธิ์ของคุณ: จำนวนบัญชีผู้ใช้ โดเมน บัญชีเมล หรือผู้ใช้เว็บที่โฮสต์บนเซิร์ฟเวอร์ของคุณ\nโปรดติดต่อฝ่ายขายของ Plesk เพื่อซื้อรหัสที่อนุญาตให้คุณสามารถโฮสต์ผู้ใช้และโดเมนได้ตามจำนวนที่คุณต้องการ โปรดติดต่อฝ่ายสนับสนุนทางเทคนิคของ Plesk หากคุณรู้สึกว่าคุณได้รับข้อความนี้ด้วยความเข้าใจผิด\nขีดจำกัดตามลิขสิทธิ์สำหรับบัญชีผู้ใช้ /โดเมน/บัญชีเมล/ผู้ใช้เว็บ/แพ็คภาษา: %2.\nปริมาณของบัญชีผู้ใช้ /โดเมน/บัญชีเมล/ผู้ใช้เว็บ/แพ็คภาษาที่โฮสต์อยู่ในปัจจุบัน: %3.", // PFW
    'login_up__short_warning_limits_licence_key' => "ปริมาณของทรัพยากรที่คุณใช้งานนั้นเกินขีดจำกัดที่กำหนดโดยลิขสิทธิ์ผลิตภัณฑ์ในปัจจุบันของคุณแล้ว โปรดติดต่อฝ่ายขายของ Plesk และซื้อรหัสลิขสิทธิ์ใหม่",
    'login_up__grace_period' => 'คุณกำลังใช้งานภายใต้ระยะเวลาทดลองฟรี เพื่ออัพเดทลิขสิทธิ์ของผลิตภัณฑ์ เลือกตัวเลือกเรียกรหัสลิขสิทธิ์คืนที่อยู่ใน%1Liหน้าข้อมูลใบอุญาต%2',
    'login_up__partner_license_message' => 'คุณกำลังใช้งานร่วมกับผลิตภัณฑ์ที่มีการจำกัดลิขสิทธิ์ซึ่งจำเป็นต้องลงทะเบียนก่อนที่จะมีการเปิดใช้งานชุดคุณลักษณะแบบเต็มรูปแบบ เพื่ออัพเดทลิขสิทธิ์ของผลิตภัณฑ์ ให้เลือกตัวเลือกเรียกรหัสลิขสิทธิ์คืนใน%1Liหน้าข้อมูลใบอุญาต%2',
    'login_up__system_admin_disabled' => 'ห้ามผู้บริหารระบบ (บัญชีรูทหรือบัญชีผู้ดูแลระบบ) เข้าสู่ระบบ Plesk สำหรับเหตุผลทางด้านความปลอดภัย',

    ///
    /// Online help keys:
    ///

    'plesk_guide' => "คำแนะนำของผู้ดูแลระบบ Plesk",
    'plesk_guide_reseller' => "คำแนะนำของตัวแทนจำหน่าย Plesk",
    'plesk_guide_client' => "คำแนะนำของลูกค้า Plesk",
    'plesk_guide_domain_admin' => "คำแนะนำของผู้ดูแลระบบโดเมน Plesk",
    'plesk_guide_mailuser' => "คำแนะนำของผู้ใช้อีเมล Plesk",

    ////
    //// COMMON KEYS FOR NAVIGATION THROUGHOUT PANEL
    ////

    ///
    /// NAVIGATION PANE
    ///

    'bt_search' => 'ค้นหา', // multiple usage: TBI
    'ui__client_unknown__quick-search' => 'ลูกค้า',
    'ui__reseller_unknown__quick-search' => 'ตัวแทนจำหน่าย',
    'ui__client/domain_unknown__quick-search' => 'โดเมน',
    'nav__general' => 'เมนูหลัก',
    '__home' => 'หน้าหลัก',
    '__resellers' => 'ตัวแทนจำหน่าย',
    '__clients' => 'ลูกค้า',
    '__domains' => 'โดเมน',
    '__applications' => 'แอพพลิเคชั่น',
    '__settings' => 'การตั้งค่า',
    'nav__system' => 'ระบบ',
    '__master' => 'มาสเตอร์',

    ///
    /// END OF NAVIGATION PANE
    ///

    ///
    /// NAVIGATION KEYS
    ///

    // up level
    'bt_up_level' => 'เพิ่มระดับ',

    // object switcher

    ///
    /// END OF NAVIGATION KEYS
    ///

    ///
    /// LISTS
    ///

    // common operations on list objects
    'bt_remove_selected' => 'ลบ',
    'bt_make_default' => 'ทำให้เป็นค่าเริ่มต้น',

    // common list object operation errors
    'class_cList__empty_selection' => 'ไม่มีออบเจกต์ที่เลือก',

    // common list object search keys
    'clist__search_show' => 'แสดงการค้นหา',
    'clist__search_hide' => 'ซ่อนการค้นหา',

    'bt_show_all' => "ตั้งค่าการค้นหาใหม่",

    // common object list info keys
    'clist__first' => 'ครั้งแรก',
    'clist__last' => 'สุดท้าย',
    'clist__prev' => '&lt;&lt;',
    'clist__next' => '&gt;&gt;',
    'clist__page' => 'หน้า',
    'clist__page_size' => 'รายการต่อหน้า',
    'clist__info' => 'ทั้งหมด %1: %4',
    'clist__info_empty' => 'ไม่มี %1',
    'clist__info_filter' => 'พบ %5 %1 (ทั้งหมด %4)',
    'clist__info_paging' => '%2-%3 %1 จากทั้งหมด %4',
    'clist__info_paging_filter' => '%2-%3 %1 จากที่พบ%5 (ทั้งหมด %4)',

    ///
    /// END OF LISTS
    ///

    ////
    //// KEYS FOR USER HOME PAGES
    ////

    ///
    /// COMMON HOME PAGE KEYS
    ///

    // business object controls
    '__object_on' => 'ใช้งานอยู่',
    '__object_off' => 'ระงับชั่วคราวแล้ว',

    '__home_description' => 'ไปยังหน้าหลัก',
    'indicator_title' => 'ใช้แล้ว %1% ว่าง %2%', // tooltip for visual stats area

    ///
    /// END OF COMMON HOME PAGE KEYS
    ///

    ///
    /// SERVER ADMINISTRATOR
    ///

    '__invalid_url_requested' => 'มีการร้องขอ URL ที่ไม่ถูกต้อง',

    // accounts
    // icons
    'ui__reseller_unknown__short-title' => "บัญชีตัวแทนจำหน่าย",
    'ui__reseller_unknown__title' => "บัญชีตัวแทนจำหน่าย",
    'ui__reseller_unknown__description' => "จัดการบัญชีตัวแทนจำหน่าย",
    'ui__reseller/client_unknown__short-title' => 'บัญชีลูกค้า',
    'ui__reseller/client_unknown__title' => 'บัญชีลูกค้า',
    'ui__reseller/client_unknown__description' => 'จัดการบัญชีตัวลูกค้า',
    // dropdowns
    'ui__admin-alias_unknown__title' => "บัญชีผู้ดูแลระบบเพิ่มเติม", // PFW
    'ui__admin-alias_unknown__short-title' => "บัญชึผู้ดูแลระบบเพิ่มเติม", // PFW
    'ui__admin-alias_unknown__description' => "ดูและจัดการบัญชีผู้ดูแลระบบเพิ่มเติม", // PFW

    // server
    // icons
    'ui__server/mail__short-title' => "การตั้งค่าทั้งเซิร์ฟเวอร์",
    'ui__server/mail__title' => "การตั้งค่าทั้งเซิร์ฟเวอร์",
    'ui__server/mail__description' => "ติดตั้งเซิร์ฟเวอร์เมลของคุณและปรับตั้งค่าการตั้งค่าเมลทั่วทั้งเซิร์ฟเวอร์",
    'ui__server/dns__short-title' => 'การตั้งค่า DNS',
    'ui__server/dns__title' => 'การตั้งค่า DNS',
    'ui__server/dns__description' => 'ตรวจสอบและอัพเดทการตั้งค่า DNS ทั่วทั้งเซิร์ฟเวอร์',
    'ui__server/services__title' => 'การจัดการบริการ',
    'ui__server/services__description' => 'เริ่ม หยุด หรือรีสตาร์ทบริการ Plesk',
    'ui__server/crontab/task_unknown__short-title' => 'งานตามตาราง',
    'ui__server/crontab/task_unknown__title' => 'งานตามตาราง',
    'ui__server/crontab/task_unknown__description' => 'เพิ่มหรือลบเซิร์ฟเวอร์งานตามตารางทั่วทั้งเซิร์ฟเวอร์',
    'ui__server/ip-address_unknown__short-title' => 'IP แอดเดรส',
    'ui__server/ip-address_unknown__title' => 'IP แอดเดรส',
    'ui__server/ip-address_unknown__description' => 'ดู เพิ่ม และลบ IP แอดเดรส กำหนด IP แอดเดรสให้กับตัวแทนจำหน่าย',
    // dropdowns
    'ui__server/time__title' => 'เวลาของระบบ',
    'ui__server/time__short-title' => 'เวลาของระบบ',
    'ui__server/time__description' => 'เปลี่ยนเวลาและวันที่ของระบบ ตั้งให้ซิงโครไนซ์กับเซิร์ฟเวอร์ NTP',
    'ui__server/maillists__title' => 'ติดตั้งเซิร์ฟเวอร์รายการชื่อส่งจดหมาย', // PFU
    'ui__server/maillists__short-title' => 'ติดตั้งเซิร์ฟเวอร์รายการชื่อส่งจดหมาย', // PFU
    'ui__server/maillists__description' => 'ติดตั้งเซิร์ฟเวอร์รายชื่อผู้รับจดหมาย Mailman', // PFU
    'ui__mass-email__short-title' => "ข้อความอีเมล์จำนวนมาก", // PFW
    'ui__mass-email__title' => "ข้อความอีเมล์จำนวนมาก", // PFW
    'ui__mass-email__description' => "ส่งข้อความอีเมลไปยังผู้ใช้หลายคนในครั้งเดียว", // PFW
    'ui__mass-mail__title' => 'ข้อความอีเมล์จำนวนมาก', // PFU
    'ui__mass-mail__short-title' => 'ข้อความอีเมล์จำนวนมาก', // PFU
    'ui__mass-mail__description' => 'ส่งข้อความอีเมลไปยังผู้ใช้หลายคนในครั้งเดียว', // PFU
    'ui__server/spam-filter__title' => 'การตั้งค่าตัวกรองสแปม',
    'ui__server/spam-filter__short-title' => 'การตั้งค่าตัวกรองสแปม',
    'ui__server/spam-filter__description' => 'ติดตั้งตัวกรองสแปมทั่วทั้งเซิร์ฟเวอร์',
    'ui__server/preferences__title' => "การตั้งค่าเซิร์ฟเวอร์",
    'ui__server/preferences__short-title' => "การตั้งค่าเซิร์ฟเวอร์",
    'ui__server/preferences__description' => "ตั้งค่าการคำนวนสถิติทั้งเซิร์ฟเวอร์ เปลี่ยนชื่อโฮสต์ของเซิร์ฟเวอร์และเปลี่ยนการตั้งค่าเซิร์ฟเวอร์อื่น",

    // help & support
    // icons
    'ui__support__short-title' => 'การสนับสนุน',
    'ui__support__title' => 'การสนับสนุน',
    'ui__support__description' => 'ส่งการสนับสนุนทางเทคนิคที่ร้องขอหรือตรวจสอบตั๋วการสนับสนุนที่จัดทำโดยลูกค้า',
    'ui__license__short-title' => 'ข้อมูลใบอนุญาต',
    'ui__license__title' => 'ข้อมูลใบอนุญาต Plesk',
    'ui__license__description' => 'ดูข้อมูลเกี่ยวกับลิขสิทธิ์ Plesk ของคุณและสั่งซื้อรหัสลิขสิทธิ์ใหม่',
    'ui__help__short-title' => 'ช่วยเหลือ',
    'ui__help__title' => 'ความช่วยเหลือออนไลน์',
    'ui__help__description' => 'ดูความช่วยเหลือออนไลน์',
    'ui__news__short-title' => "มีอะไรใหม่",
    'ui__news__title' => "มีอะไรใหม่",
    'ui__news__description' => "ดูรายการการเปลี่ยนแปลงในเวอร์ชั่นของ Plesk",
    'ui__server/autoinstaller__short-title' => 'อัพเดต',
    'ui__server/autoinstaller__title' => 'อัพเดต',
    'ui__server/autoinstaller__description' => 'อัพเดต Plesk และคอมโพเนนท์',
    // dropdowns

    // domains
    // icons
    'ui__client/domain_unknown__short-title' => 'โดเมน',
    'ui__client/domain_unknown__title' => 'โดเมน',
    'ui__client/domain_unknown__description' => 'การจัดการโดเมน',
    'ui__server/skeleton__short-title' => 'แม่แบบโฮสต์เสมือน',
    'ui__server/skeleton__title' => 'แม่แบบโฮสต์เสมือน',
    'ui__server/skeleton__description' => 'ระบุไฟล์หรือโฟลเดอร์ที่ควรอยู่ในสารบบของโดเมนที่สร้างขึ้นใหม่',
    // dropdowns
    'ui__client/domain/chowner_multi-select__title' => 'กำหนดเจ้าของใหม่ไปยังการสมัคร',
    'ui__client/domain/chowner_multi-select__short-title' => 'กำหนดเจ้าของการสมัครใหม่',
    'ui__client/domain/chowner_multi-select__description' => 'กำหนดเจ้าของใหม่สำหรับการสมัครที่เลือก',
    'ui__client/domain/disable_multi__title' => 'ระงับการใช้โดเมน',
    'ui__client/domain/disable_multi__short-title' => 'ระงับการใช้โดเมน',
    'ui__client/domain/disable_multi__description' => 'ระงับการใช้โดเมนที่เลือก',
    'ui__client/domain/enable_multi__title' => 'โดเมนที่เปิดใช้งาน',
    'ui__client/domain/enable_multi__short-title' => 'โดเมนที่เปิดใช้งาน',
    'ui__client/domain/enable_multi__description' => 'เปิดใช้งานโดเมนที่เลือก',

    // icons
    'ui__admin/extras-domain__short-title' => 'เครื่องมือจาก MyPlesk.com',
    'ui__admin/extras-domain__title' => 'เครื่องมือจาก MyPlesk.com',
    'ui__admin/extras-domain__description' => 'รับเครื่องมือและบริการเพิ่มเติมจาก MyPlesk.com',
    'ui__server/sitebuilder__short-title' => 'การตั้งค่า Presence Builder', // PFU
    'ui__server/sitebuilder__title' => 'การตั้งค่า Presence Builder', // PFU
    'ui__server/sitebuilder__description' => 'ตั้งค่า Presence Builder สำหรับแก้ไขเว็บไซต์ที่โฮสต์บนเซิร์ฟเวอร์นี้', // PFU
    // dropdowns
    'ui__admin/register-domain__title' => 'ลงทะเบียนโดเมน',
    'ui__admin/register-domain__short-title' => 'ลงทะเบียนโดเมน',
    'ui__admin/register-domain__description' => 'ลงทะเบียนชื่อโดเมนผ่านทาง MyPlesk.com',
    'ui__admin/manage-domain__title' => 'จัดการโดเมน',
    'ui__admin/manage-domain__short-title' => 'จัดการโดเมน',
    'ui__admin/manage-domain__description' => 'จัดการชื่อโดเมนที่ลงทะเบียนผ่านทาง MyPlesk.com',
    'ui__server/register__title' => 'ลงทะเบียนเซิร์ฟเวอร์ของคุณ',
    'ui__server/register__short-title' => 'ลงทะเบียนเซิร์ฟเวอร์',
    'ui__server/register__description' => 'ลงทะเบียนเซิร์ฟเวอร์ของคุณเพื่อเข้าร่วมกับธุรกิจตัวแทนโฆษณาออนไลน์',

    // logs & statistics
    // icons
    'ui__actionlog__short-title' => 'บันทึกการทำงาน',
    'ui__actionlog__title' => 'บันทึกการทำงาน',
    'ui__actionlog__description' => 'ดาวน์โหลดบันทึกการทำงานทำและจัดการการตั้งค่าบันทึกการทำงาน',
    // dropdowns
    'ui__server/statistics__short-title' => 'ข้อมูลเซิร์ฟเวอร์',
    'ui__server/statistics__title' => 'ข้อมูลเซิร์ฟเวอร์',
    'ui__server/statistics__description' => 'สถิติของการบริการจัดการโดย Plesk',
    'ui__admin/report__title' => 'รายงานสรุป',
    'ui__admin/report__short-title' => 'รายงานสรุป',
    'ui__admin/report__description' => 'ดูรายงานการใช้ทรัพยากรและการรับส่งข้อมูลสำหรับตัวแทนจำหน่าย ลูกค้า และโดเมนนี้',

    // security
    // icons
    'ui__sessions/properties__short-title' => 'ช่วงเวลาว่าง',
    'ui__sessions/properties__title' => 'ช่วงเวลาว่าง',
    'ui__sessions/properties__description' => 'ตั้งค่าเซสชั่นเวลาเดินเครื่องเปล่าสำหรับเซสชั่น Plesk',
    'ui__cp-access__short-title' => 'การเข้าถึง Plesk',
    'ui__cp-access__title' => 'การเข้าถึง Plesk',
    'ui__cp-access__description' => 'จำกัดการเข้าถึง Plesk',
    'ui__sessions__short-title' => 'ใช้งานช่วงเวลา',
    'ui__sessions__title' => 'ใช้งานช่วงเวลา',
    'ui__sessions__description' => 'ดูเซสชั่น Plesk ที่ใช้งานอยู่',
    // dropdowns
    'ui__server/certificate_unknown__title' => 'การรับรอง SSL/TLS',
    'ui__server/certificate_unknown__short-title' => 'การรับรอง SSL/TLS',
    'ui__server/certificate_unknown__description' => 'รายชื่อการรับรอง SSL/TLS',

    // account
    // icons
    'ui__admin-info__short-title' => 'ข้อมูลส่วนตัว',
    'ui__admin-info__title' => 'ข้อมูลส่วนตัว',
    'ui__admin-info__description' => 'เปลี่ยนข้อมูลส่วนตัวสำหรับบัญชีของคุณ',
    'ui__admin-password__short-title' => 'เปลี่ยนรหัสผ่าน',
    'ui__admin-password__title' => 'เปลี่ยนรหัสผ่าน',
    'ui__admin-password__description' => 'เปลี่ยนรหัสผ่านสำหรับบัญชีของคุณ',
    // dropdowns

    ///
    /// END OF SERVER ADMINISTRATOR
    ///

    ///
    /// RESELLER
    ///

    // business objects

    // files
    // icons
    'ui__client/domain/hosting/web-directories_unknown__title' => 'ไดเร็กทอรี่เสมือน', // PFW
    'ui__client/domain/hosting/web-directories_unknown__short-title' => 'ไดเร็กทอรี่เสมือน', // PFW
    'ui__client/domain/hosting/web-directories_unknown__description' => 'ทำงานกับไฟล์เสมือน ไฟล์โครงร่าง และไดเร็กทอรี่ภายในเว็บไซต์', // PFW

    // statistics
    // icons
    'ui__reseller/limits__short-title' => 'การใช้ทรัพยากร',
    'ui__reseller/limits__title' => 'การใช้ทรัพยากร',
    'ui__reseller/limits__description' => 'ดูและจัดการการใช้ทรัพยากรของตัวแทนจำหน่าย %1',
    'ui__reseller/limits_unknown__short-title' => 'การใช้ทรัพยากร',
    'ui__reseller/limits_unknown__title' => 'การใช้ทรัพยากร',
    'ui__reseller/limits_unknown__description' => 'ดูและจัดการการใช้ทรัพยากรของคุณ',
    'ui__reseller/limits_self__short-title' => 'การใช้ทรัพยากร',
    'ui__reseller/limits_self__title' => 'การใช้ทรัพยากร',
    'ui__reseller/limits_self__description' => "ดูและจัดการการใช้ทรัพยากรของคุณ",
    'ui__reseller/limits_readonly-self__short-title' => 'การใช้ทรัพยากร',
    'ui__reseller/limits_readonly-self__title' => 'การใช้ทรัพยากร',
    'ui__reseller/limits_readonly-self__description' => "ดูการใช้ทรัพยากร",
    'ui__reseller/client/traffic_unknown__short-title' => 'การใช้งานรับส่งข้อมูลโดยลูกค้า',
    'ui__reseller/client/traffic_unknown__title' => 'ดูการใช้งานการรับส่งข้อมูลโดยลูกค้า',
    'ui__reseller/client/traffic_unknown__description' => 'ดูรายงานการใช้งานการรับส่งข้อมูลสำหรับบัญชีลูกค้า',
    'ui__client/traffic_unknown__short-title' => "การใช้งานรับส่งข้อมูลโดยลูกค้า", // temporary for presets
    'ui__client/traffic_unknown__title' => "ดูการใช้งานการรับส่งข้อมูลโดยลูกค้า", // temporary for presets
    'ui__client/traffic_unknown__description' => "ดูรายงานการใช้งานการรับส่งข้อมูลสำหรับบัญชีลูกค้า", //  temporary for presets
    'ui__client/domain/hosting/logs_unknown__short-title' => 'ตัวจัดการบันทึก',
    'ui__client/domain/hosting/logs_unknown__title' => 'ตัวจัดการบันทึก',
    'ui__client/domain/hosting/logs_unknown__description' => 'ดูบันทึกและปรับตั้งค่าการหมุนบันทึก',
    // dropdowns
    'ui__reseller/report__title' => 'รายงานสรุป',
    'ui__reseller/report__short-title' => 'รายงานสรุป',
    'ui__reseller/report__description' => 'ดูรายงานการใช้ทรัพยากรและทราฟฟิคสำหรับตัวแทนจำหน่ยนี้',
    'ui__reseller/report_unknown__title' => 'รายงานสรุป',
    'ui__reseller/report_unknown__short-title' => 'รายงานสรุป',
    'ui__reseller/report_unknown__description' => 'ดูรายงานการใช้ทรัพยากรและทราฟฟิคสำหรับตัวแทนจำหน่าย',
    'ui__reseller/report_self__title' => 'รายงานสรุป',
    'ui__reseller/report_self__short-title' => 'รายงานสรุป',
    'ui__reseller/report_self__description' => 'ดูรายงานการใช้ทรัพยากรทราฟฟิคของคุณ',

    // account
    // icons
    'ui__client/logo_reseller__title' => 'การสร้างแบรนด์ Plesk',
    'ui__client/logo_reseller__short-title' => 'การสร้างแบรนด์ Plesk',
    'ui__client/logo_reseller__description' => 'สร้างแบรนด์ Plesk สำหรับตัวแทนจำหน่าย %1',
    'ui__client/logo_unknown__title' => 'การสร้างแบรนด์ Plesk', // temporary for presets
    'ui__client/logo_unknown__short-title' => 'การสร้างแบรนด์ Plesk', // temporary for presets
    'ui__client/logo_unknown__description' => 'การสร้างแบรนด์ Plesk ใหม่', // temporary for presets
    'ui__client/logo_self-reseller__title' => 'การสร้างแบรนด์ Plesk',
    'ui__client/logo_self-reseller__short-title' => 'การสร้างแบรนด์ Plesk',
    'ui__client/logo_self-reseller__description' => 'สร้างแบรนด์ Plesk ของคุณอีกครั้ง',
    'ui__reseller/permissions__title' => 'การอนุญาต',
    'ui__reseller/permissions__short-title' => 'การอนุญาต',
    'ui__reseller/permissions__description' => "ดูหรือเปลี่ยนการกระทำที่ตัวแทนจำหน่าย %1 สามารถดำเนินการใน Plesk ได้",
    'ui__reseller/permissions_unknown__short-title' => 'การอนุญาต',
    'ui__reseller/permissions_unknown__title' => 'การอนุญาต',
    'ui__reseller/permissions_unknown__description' => "ดูหรือเปลี่ยนการกระทำที่ตัวแทนจำหน่ายสามารถดำเนินการใน Plesk ได้",
    'ui__reseller/permissions_self__title' => 'การอนุญาต',
    'ui__reseller/permissions_self__short-title' => 'การอนุญาต',
    'ui__reseller/permissions_self__description' => 'ดูรายการงานที่คุณสามารถดำเนินการใน Plesk ได้',
    'ui__reseller/permissions_readonly-self__title' => 'การอนุญาต',
    'ui__reseller/permissions_readonly-self__short-title' => 'การอนุญาต',
    'ui__reseller/permissions_readonly-self__description' => 'ดูรายการงานที่คุณสามารถดำเนินการใน Plesk ได้',

    // domains
    // icons
    // Domains - see SERVER ADMINISTRATOR/DOMAINS
    // Domain Templates - see SERVER ADMINISTRATOR/DOMAINS
    'ui__client/skeleton__title' => 'แม่แบบโฮสต์เสมือน',
    'ui__client/skeleton__short-title' => 'แม่แบบโฮสต์เสมือน',
    'ui__client/skeleton__description' => 'ระบุไฟล์หรือโฟลเดอร์ที่ควรอยู่ในสารบบของโดเมนที่สร้างขึ้นใหม่',
    'ui__client/skeleton_unknown__short-title' => 'แม่แบบโฮสต์เสมือน',
    'ui__client/skeleton_unknown__title' => 'แม่แบบโฮสต์เสมือน',
    'ui__client/skeleton_unknown__description' => 'ระบุไฟล์หรือโฟลเดอร์ที่ควรอยู่ในสารบบของโดเมนที่สร้างขึ้นใหม่',

    // website
    // icons
    'ui__client/domain/domain-alias_unknown__short-title' => 'โดเมนนามแฝง',
    'ui__client/domain/domain-alias_unknown__title' => 'โดเมนนามแฝง',
    'ui__client/domain/domain-alias_unknown__description' => 'ดูรายการชื่ออื่นสำหรับโดเมนของคุณ',
    //dropdowns
    'ui__client/domain/dns_unknown__title' => 'การตั้งค่า DNS',
    'ui__client/domain/dns_unknown__short-title' => 'การตั้งค่า DNS',
    'ui__client/domain/dns_unknown__description' => 'จัดการการตั้งค่า DNS โซนสำหรับโดเมน',
    'ui__client/domain/dns_readonly-unknown__title' => 'การตั้งค่า DNS',
    'ui__client/domain/dns_readonly-unknown__short-title' => 'การตั้งค่า DNS',
    'ui__client/domain/dns_readonly-unknown__description' => 'ดูการตั้งค่า DNS โซนสำหรับโดเมนของคุณ',

    // applications & services
    // icons
    'ui__reseller/extras-domain__short-title' => 'เครื่องมือจาก MyPlesk.com',
    'ui__reseller/extras-domain__title' => 'เครื่องมือจาก MyPlesk.com',
    'ui__reseller/extras-domain__description' => 'รับเครื่องมือและบริการเพิ่มเติมจาก MyPlesk.com',
    'ui__reseller/extras-domain_unknown__short-title' => 'เครื่องมือจาก MyPlesk.com',
    'ui__reseller/extras-domain_unknown__title' => 'เครื่องมือจาก MyPlesk.com',
    'ui__reseller/extras-domain_unknown__description' => 'รับเครื่องมือและบริการเพิ่มเติมจาก MyPlesk.com',
    'ui__reseller/extras-domain_self__short-title' => 'เครื่องมือจาก MyPlesk.com',
    'ui__reseller/extras-domain_self__title' => 'เครื่องมือจาก MyPlesk.com',
    'ui__reseller/extras-domain_self__description' => 'รับเครื่องมือและบริการเพิ่มเติมจาก MyPlesk.com',
    'ui__reseller/register-domain__short-title' => 'ลงทะเบียนโดเมน',
    'ui__reseller/register-domain__title' => 'ลงทะเบียนโดเมน',
    'ui__reseller/register-domain__description' => 'ลงทะเบียนชื่อโดเมนผ่านทาง MyPlesk.com',
    'ui__reseller/register-domain_unknown__short-title' => 'ลงทะเบียนโดเมน',
    'ui__reseller/register-domain_unknown__title' => 'ลงทะเบียนโดเมน',
    'ui__reseller/register-domain_unknown__description' => 'ลงทะเบียนชื่อโดเมนผ่านทาง MyPlesk.com',
    'ui__reseller/register-domain_self__short-title' => 'ลงทะเบียนโดเมน',
    'ui__reseller/register-domain_self__title' => 'ลงทะเบียนโดเมน',
    'ui__reseller/register-domain_self__description' => 'ลงทะบียนชื่อโดเมนผ่าน MyPlesk.com',
    // dropdowns
    'ui__reseller/manage-domain__title' => 'จัดการโดเมน',
    'ui__reseller/manage-domain__short-title' => 'จัดการโดเมน',
    'ui__reseller/manage-domain__description' => 'จัดการชี่อโดเมนที่ลงทะเบียนผ่าน MyPlesk.com',
    'ui__reseller/manage-domain_unknown__title' => 'จัดการโดเมน',
    'ui__reseller/manage-domain_unknown__short-title' => 'จัดการโดเมน',
    'ui__reseller/manage-domain_unknown__description' => 'จัดการชี่อโดเมนที่ลงทะเบียนผ่าน MyPlesk.com',
    'ui__reseller/manage-domain_self__title' => 'จัดการโดเมน',
    'ui__reseller/manage-domain_self__short-title' => 'จัดการโดเมน',
    'ui__reseller/manage-domain_self__description' => 'จัดการชี่อโดเมนที่ลงทะเบียนผ่าน MyPlesk.com',

    // additional tools
    // icons
    'ui__client/ipaddress_unknown-reseller__title' => 'IP แอดเดรส',
    'ui__client/ipaddress_unknown-reseller__short-title' => 'IP แอดเดรส',
    'ui__client/ipaddress_unknown-reseller__description' => 'จัดการ IP แอดเดรส',
    'ui__client/domain/certificate_unknown__short-title' => 'การรับรอง SSL/TLS',
    'ui__client/domain/certificate_unknown__title' => 'การรับรอง SSL/TLS',
    'ui__client/domain/certificate_unknown__description' => 'ติดตั้งและจัดการการรับรอง SSL/TLS',
    'ui__reseller/sessions__short-title' => 'ช่วงเวลาที่ใช้งานอยู่',
    'ui__reseller/sessions__title' => 'ช่วงเวลาที่ใช้งานอยู่',
    'ui__reseller/sessions__description' => 'ดูเซสชั่น Plesk ที่ใช้งานอยู่',
    'ui__reseller/sessions_unknown__short-title' => 'ช่วงเวลาที่ใช้งานอยู่',
    'ui__reseller/sessions_unknown__title' => 'ช่วงเวลาที่ใช้งานอยู่',
    'ui__reseller/sessions_unknown__description' => 'ดูเซสชั่น Plesk ที่ใช้งานอยู่',
    'ui__reseller/sessions_self__short-title' => 'ช่วงเวลาที่ใช้งานอยู่',
    'ui__reseller/sessions_self__title' => 'ช่วงเวลาที่ใช้งานอยู่',
    'ui__reseller/sessions_self__description' => 'ดูเซสชั่น Plesk ที่ใช้งานอยู่',

    ///
    /// END OF RESELLER
    ///

    ///
    /// CLIENT
    ///

    // business objects
    'mn_list__mail_names_for_client' => 'บัญชีเมลในบัญชีผู้ใช้ %1',

    // domains
    // icons
    // Domains - SERVER ADMINISTRATOR/DOMAINS
    // Domain Templates - SERVER ADMINISTRATOR/DOMAINS
    // Virtual host template - RESELLER/DOMAINS
    'ui__client/skeleton_self__short-title' => 'แม่แบบโฮสต์เสมือน',
    'ui__client/skeleton_self__title' => 'แม่แบบโฮสต์เสมือน',
    'ui__client/skeleton_self__description' => 'ระบุไฟล์หรือโฟลเดอร์ที่ควรอยู่ในสารบบของโดเมนที่สร้างขึ้นใหม่',
    // dropdowns
    // Create domain - see RESELLER/DOMAINS
    // Create domain template - see RESELLER/DOMAINS
    // Assign new owner for domains - see SERVER ADMINISTRATOR/DOMAINS
    // Convert Domain Administrator Accounts to Client Accounts - see SERVER ADMINISTRATOR/DOMAINS
    // Update Properties of Multiple Domains - see SERVER ADMINISTRATOR/DOMAINS

    // Suspend domains - see SERVER ADMINISTRATOR/DOMAINS
    // Activate domains - see SERVER ADMINISTRATOR/DOMAINS

    // mail
    // icons
    // Mail accounts - RESELLER/MAIL
    // Create mail account - RESELLER/MAIL
    // Create forwarder - RESELLER/MAIL
    // Create autoresponder - RESELLER/MAIL
    // Mailing lists - RESELLER/MAIL
    // Virus protection - RESELLER/MAIL
    // Spam filtering - RESELLER/MAIL
    // Open Webmail - RESELLER/MAIL
    // dropdowns
    // Mail settings - RESELLER/MAIL
    //Create mailing list - RESELLER/MAIL

    // files
    // icons
    // File manager - RESELLER/FILES
    // Anonymous FTP - RESELLER/FILES
    // FTP accounts - RESELLER/FILES    // PFW
    // SSH terminal - RESELLER/FILES    // PFU
    // Virtual directories - RESELLER/FILES    // PFW
    // Web directories - RESELLER/FILES    // PFW

    // statistics
    // icons
    // Web statistics - RESELLER/STATISTICS
    'ui__client/limits__short-title' => 'การใช้ทรัพยากร',
    'ui__client/limits__title' => 'การใช้ทรัพยากร',
    'ui__client/limits__description' => "ดูและจัดการการใช้ทรัพยากรของลูกค้า %1",
    'ui__client/limits_unknown__short-title' => 'การใช้ทรัพยากร',
    'ui__client/limits_unknown__title' => 'การใช้ทรัพยากร',
    'ui__client/limits_unknown__description' => 'ดูและจัดการการใช้ทรัพยากรของลูกค้า',
    'ui__client/limits_readonly__short-title' => 'การใช้ทรัพยากร',
    'ui__client/limits_readonly__title' => 'การใช้ทรัพยากร',
    'ui__client/limits_readonly__description' => 'ดูการใช้งานทรัพยากรของลูกค้า %1',
    'ui__client/limits_self__short-title' => 'การใช้ทรัพยากร',
    'ui__client/limits_self__title' => 'การใช้ทรัพยากร',
    'ui__client/limits_self__description' => "ดูและจัดการการใช้ทรัพยากรของคุณ",
    'ui__client/limits_readonly-self__short-title' => 'การใช้ทรัพยากร',
    'ui__client/limits_readonly-self__title' => 'การใช้ทรัพยากร',
    'ui__client/limits_readonly-self__description' => "ดูการใช้ทรัพยากร",
    'ui__client/domain/traffic_unknown__short-title' => "การใช้งานการรับส่งข้อมูลโดเมน %1",
    'ui__client/domain/traffic_unknown__title' => "ดูการใช้ทราฟฟิคโดยโดเมน",
    'ui__client/domain/traffic_unknown__description' => "ดูรายงานการใช้ทราฟฟิคสำหรับโดเมน",
    // Log manager - RESELLER/STATISTICS
    // dropdowns
    'ui__client/report__title' => 'รายงานสรุป',
    'ui__client/report__short-title' => 'รายงานสรุป',
    'ui__client/report__description' => 'ดูรายงานการใช้ทรัพยากรและการรับส่งข้อมูลสำหรับลูกค้ารายนี้',
    'ui__client/report_unknown__short-title' => 'รายงานสรุป',
    'ui__client/report_unknown__title' => 'รายงานสรุป',
    'ui__client/report_unknown__description' => 'ดูรายงานการใช้ทรัพยากรและการรับส่งข้อมูลสำหรับลูกค้า',
    'ui__client/report_self__short-title' => 'รายงานสรุป',
    'ui__client/report_self__title' => 'รายงานสรุป',
    'ui__client/report_self__description' => 'ดูรายงานการใช้ทรัพยากรและทราฟฟิค',

    // account
    // icons
    'ui__client/preferences__short-title' => 'การตั้งค่าหน้าจอ',
    'ui__client/preferences__title' => 'การตั้งค่าหน้าจอ',
    'ui__client/preferences__description' => 'การตั้งค่าอินเตอร์เฟส Plesk สำหรับลูกค้า %1',
    'ui__client/preferences_unknown__short-title' => 'การตั้งค่าหน้าจอ',
    'ui__client/preferences_unknown__title' => 'การตั้งค่าหน้าจอ',
    'ui__client/preferences_unknown__description' => "การตั้งค่าอินเตอร์เฟสสำหรับ Plesk ของลูกค้า",
    'ui__client/preferences_self__short-title' => 'การตั้งค่าหน้าจอ',
    'ui__client/preferences_self__title' => 'การตั้งค่าหน้าจอ',
    'ui__client/preferences_self__description' => 'การตั้งค่าอินเตอร์เฟสสำหรับ Plesk ของคุณ',
    'ui__client/logo__title' => 'การสร้างแบรนด์ Plesk',
    'ui__client/logo__short-title' => 'การสร้างแบรนด์ Plesk',
    'ui__client/logo__description' => "การสร้างแบรนด์ Plesk ของ %1\\ ลูกค้า",
    'ui__client/logo_self__title' => 'การสร้างแบรนด์ Plesk',
    'ui__client/logo_self__short-title' => 'การสร้างแบรนด์ Plesk',
    'ui__client/logo_self__description' => 'สร้างแบรนด์ Plesk อีกครั้ง เปลี่ยนภาพโลโก้ และบาร์หัวข้อเบราเซอร์',
    'ui__client/permissions__title' => 'การอนุญาต',
    'ui__client/permissions__short-title' => 'การอนุญาต',
    'ui__client/permissions__description' => "ดูหรือเปลี่ยนการกระทำที่ลูกค้า %1 สามารถดำเนินการใน Plesk ได้",
    'ui__client/permissions_unknown__short-title' => 'การอนุญาต',
    'ui__client/permissions_unknown__title' => 'การอนุญาต',
    'ui__client/permissions_unknown__description' => "ดูหรือเปลี่ยนการกระทำที่ลูกค้าสามารถดำเนินการใน Plesk ได้",
    'ui__client/permissions_self__title' => 'การอนุญาต',
    'ui__client/permissions_self__short-title' => 'การอนุญาต',
    'ui__client/permissions_self__description' => "ดูรายการงานที่คุณสามารถดำเนินการใน Plesk ได้",
    'ui__client/permissions_readonly-self__title' => 'การอนุญาต',
    'ui__client/permissions_readonly-self__short-title' => 'การอนุญาต',
    'ui__client/permissions_readonly-self__description' => "ดูรายการงานที่คุณสามารถดำเนินการใน Plesk ได้",

    // website
    // icons
    // Edit in SiteBuilder - RESELLER/WEBSITE
    // Web hosting settings - RESELLER/WEBSITE
    // Subdomains - RESELLER/WEBSITE
    // Domain aliases - RESELLER/ADDITIONAL TOOLS
    // Frontpage Webadmin - RESELLER/WEBSITE
    // Frontpage SSL/TLS Webadmin - RESELLER/WEBSITE
    // Web users - RESELLER/WEBSITE
    // Site preview - RESELLER/WEBSITE
    // dropdowns
    // DNS settings - RESELLER/WEBSITE
    // Change hosting type - RESELLER/WEBSITE
    // FrontPage management - RESELLER/WEBSITE    // PFW
    // Create subdomain - RESELLER/WEBSITE

    // applications & services
    // icons
    // Web applications - RESELLER/APPLICATIONS & SERVICES
    'ui__client/extras-domain__short-title' => 'เครื่องมือจาก MyPlesk.com',
    'ui__client/extras-domain__title' => 'เครื่องมือจาก MyPlesk.com',
    'ui__client/extras-domain__description' => 'รับเครื่องมือและบริการเพิ่มเติมจาก MyPlesk.com',
    'ui__client/extras-domain_unknown__short-title' => 'เครื่องมือจาก MyPlesk.com',
    'ui__client/extras-domain_unknown__title' => 'เครื่องมือจาก MyPlesk.com',
    'ui__client/extras-domain_unknown__description' => 'รับเครื่องมือและบริการเพิ่มเติมจาก MyPlesk.com',
    'ui__client/extras-domain_self__short-title' => 'เครื่องมือจาก MyPlesk.com',
    'ui__client/extras-domain_self__title' => 'เครื่องมือจาก MyPlesk.com',
    'ui__client/extras-domain_self__description' => 'รับเครื่องมือและบริการเพิ่มเติมจาก MyPlesk.com',
    // Databases - RESELLER/APPLICATIONS & SERVICES
    // Java applications - RESELLER/APPLICATIONS & SERVICES    // PFU
    'ui__client/register-domain__title' => 'ลงทะเบียนโดเมน',
    'ui__client/register-domain__short-title' => 'ลงทะเบียนโดเมน',
    'ui__client/register-domain__description' => 'ลงทะบียนชื่อโดเมนผ่าน MyPlesk.com',
    'ui__client/register-domain_unknown__title' => 'ลงทะเบียนโดเมน',
    'ui__client/register-domain_unknown__short-title' => 'ลงทะเบียนโดเมน',
    'ui__client/register-domain_unknown__description' => 'ลงทะเบียนชือโดเมนผ่าน MyPlesk.com',
    'ui__client/register-domain_self__title' => 'ลงทะเบียนโดเมน',
    'ui__client/register-domain_self__short-title' => 'ลงทะเบียนโดเมน',
    'ui__client/register-domain_self__description' => 'ลงทะเบียนชื่อโดเมนผ่านทาง MyPlesk.com',
    // dropdowns
    // Install web application - RESELLER/APPLICATIONS & SERVICES
    // Create database - RESELLER/APPLICATIONS & SERVICES
    // Create database user - RESELLER/APPLICATIONS & SERVICES
    // Install Java application - RESELLER/APPLICATIONS & SERVICES
    'ui__client/manage-domain__title' => 'จัดการโดเมน',
    'ui__client/manage-domain__short-title' => 'จัดการโดเมน',
    'ui__client/manage-domain__description' => 'จัดการชี่อโดเมนที่ลงทะเบียนผ่าน MyPlesk.com',
    'ui__client/manage-domain_unknown__title' => 'จัดการโดเมน',
    'ui__client/manage-domain_unknown__short-title' => 'จัดการโดเมน',
    'ui__client/manage-domain_unknown__description' => 'จัดการชี่อโดเมนที่ลงทะเบียนผ่าน MyPlesk.com',
    'ui__client/manage-domain_self__title' => 'จัดการโดเมน',
    'ui__client/manage-domain_self__short-title' => 'จัดการโดเมน',
    'ui__client/manage-domain_self__description' => 'จัดการชี่อโดเมนที่ลงทะเบียนผ่าน MyPlesk.com',

    // additional tools
    // icons
    'ui__client/ipaddress_unknown__title' => 'IP แอดเดรส',
    'ui__client/ipaddress_unknown__short-title' => "IP แอดเดรส",
    'ui__client/ipaddress_unknown__description' => "จัดการ IP แอดเดรส",
    'ui__client/domain/domain-alias_readonly-unknown__short-title' => 'โดเมนนามแฝง',
    'ui__client/domain/domain-alias_readonly-unknown__title' => 'โดเมนนามแฝง',
    'ui__client/domain/domain-alias_readonly-unknown__description' => 'ดูรายการชื่ออื่นสำหรับโดเมนของคุณ',
    // Scheduled tasks - RESELLER/ADDITIONAL TOOLS
    // SSL/TLS certificates - RESELLER/ADDITIONAL TOOLS
    'ui__client/sessions__short-title' => 'ช่วงเวลาที่ใช้งานอยู่',
    'ui__client/sessions__title' => 'ช่วงเวลาที่ใช้งานอยู่',
    'ui__client/sessions__description' => 'ดูเซสชั่น Plesk ที่ใช้งานอยู่',
    'ui__client/sessions_unknown__short-title' => 'ช่วงเวลาที่ใช้งานอยู่',
    'ui__client/sessions_unknown__title' => 'ช่วงเวลาที่ใช้งานอยู่',
    'ui__client/sessions_unknown__description' => 'ดูเซสชั่น Plesk ที่ใช้งานอยู่',
    'ui__client/sessions_self__short-title' => 'ช่วงเวลาที่ใช้งานอยู่',
    'ui__client/sessions_self__title' => 'ช่วงเวลาที่ใช้งานอยู่',
    'ui__client/sessions_self__description' => 'ดูเซสชั่น Plesk ที่ใช้งานอยู่',
    // Shared SSL/TLS - RESELLER/ADDITIONAL TOOLS    // PFW
    // ASP.NET settings - RESELLER/ADDITIONAL TOOLS    // PFW
    // PHP settings - RESELLER/ADDITIONAL TOOLS    // PFW
    // dropdowns
    //Schedule new task - RESELLER/ADDITIONAL TOOLS

    ///
    /// END OF CLIENT
    ///

    ///
    /// DOMAIN / DOMAIN ADMINISTRATOR
    ///

    // files
    // icons
    'ui__client/domain/hosting/web-directories__title' => 'ไดเร็กทอรี่เสมือน', // PFW
    'ui__client/domain/hosting/web-directories__short-title' => 'ไดเร็กทอรี่เสมือน', // PFW
    'ui__client/domain/hosting/web-directories__description' => 'ทำงานกับไฟล์เสมือน ไฟล์โครงร่าง และไดเร็กทอรี่ภายในไซต์ %1', // PFW
    'ui__client/domain/hosting/web-directories_self__title' => 'ไดเร็กทอรี่เสมือน', // PFW
    'ui__client/domain/hosting/web-directories_self__short-title' => 'ไดเร็กทอรี่เสมือน', // PFW
    'ui__client/domain/hosting/web-directories_self__description' => 'ทำงานกับไฟล์เสมือน ไฟล์โครงร่าง และไดเร็กทอรี่ภายในเว็บไซต์ของคุณ', // PFW

    // statistics
    // icons
    'ui__client/domain/traffic__short-title' => '%1 การใช้งานการส่งต่อข้อมูล',
    'ui__client/domain/traffic__title' => 'สถิติการส่งต่อข้อมูลสำหรับ <b>%1</b>',
    'ui__client/domain/traffic__description' => 'ดูการส่งต่อข้อมูลสำหรับโดเมน %1',
    'ui__client/domain/traffic_self__short-title' => 'การใช้ทราฟฟิค',
    'ui__client/domain/traffic_self__title' => 'ดูการใช้ทราฟฟิคสำหรับโดเมนของคุณ',
    'ui__client/domain/traffic_self__description' => 'ดูรายงานการใช้ทราฟฟิคสำหรับโดเมนของคุณ',
    'ui__client/domain/hosting/logs__short-title' => 'ตัวจัดการบันทึก',
    'ui__client/domain/hosting/logs__title' => 'ตัวจัดการบันทึก',
    'ui__client/domain/hosting/logs__description' => 'ดูบันทึกและปรับตั้งค่าการหมุนบันทึก',
    'ui__client/domain/hosting/logs_self__short-title' => 'ตัวจัดการบันทึก',
    'ui__client/domain/hosting/logs_self__title' => 'ตัวจัดการบันทึก',
    'ui__client/domain/hosting/logs_self__description' => 'ดูบันทึกและปรับตั้งค่าการหมุนบันทึก',

    // domain administration
    // dropdowns
    'ui__client/domain/rename__title' => 'ตั้งชื่อโดเมนใหม่',
    'ui__client/domain/rename__short-title' => 'ตั้งชื่อโดเมนใหม่',
    'ui__client/domain/rename__description' => 'ตั้งชื่อโดเมน %1 ใหม่',
    'ui__client/domain/rename_unknown__short-title' => 'ตั้งชื่อโดเมนใหม่',
    'ui__client/domain/rename_unknown__title' => 'ตั้งชื่อโดเมนใหม่',
    'ui__client/domain/rename_unknown__description' => 'ตั้งชื่อโดเมนใหม่',
    'ui__client/domain/chowner_select__title' => 'กำหนดเจ้าของใหม่ไปยังโดเมน',
    'ui__client/domain/chowner_select__short-title' => 'กำหนดเจ้าของใหม่ไปยังการสมัคร',
    'ui__client/domain/chowner_select__description' => 'กำหนดเจ้าของใหม่ไปยังการสมัครนี้',
    'ui__client/domain/chowner_unknown-select__short-title' => 'กำหนดเจ้าของใหม่ไปยังการสมัคร',
    'ui__client/domain/chowner_unknown-select__title' => 'กำหนดเจ้าของใหม่ไปยังการสมัคร',
    'ui__client/domain/chowner_unknown-select__description' => 'กำหนดเจ้าของใหม่ไปยังการสมัคร',
    'ui__client/domain/toggle__title' => 'ระงับหรือเปิดใช้งานโดเมน', // for HP customization
    'ui__client/domain/toggle__short-title' => 'ระงับหรือเปิดใช้งานโดเมน', // for HP customization
    'ui__client/domain/toggle__description' => 'ระงับหรือเปิดใช้งานโดเมน %1', // for HP customization
    'ui__client/domain/toggle_unknown__title' => 'ระงับหรือเปิดใช้งานโดเมน', // for HP customization
    'ui__client/domain/toggle_unknown__short-title' => 'ระงับหรือเปิดใช้งานโดเมน', // for HP customization
    'ui__client/domain/toggle_unknown__description' => 'ระงับหรือเปิดใช้งานโดเมน', // for HP customization
    'ui__client/domain/toggle_enable__title' => 'โดเมนที่เปิดใช้งาน',
    'ui__client/domain/toggle_enable__short-title' => 'โดเมนที่เปิดใช้งาน',
    'ui__client/domain/toggle_enable__description' => 'ใช้งานโดเมน %1',
    'ui__client/domain/toggle_disable__title' => 'ระงับการใช้โดเมน',
    'ui__client/domain/toggle_disable__short-title' => 'ระงับการใช้โดเมน',
    'ui__client/domain/toggle_disable__description' => 'ระงับการใช้โดเมน %1',

    // website
    // icons
    // dropdowns
    'ui__client/domain/dns__title' => 'การตั้งค่า DNS',
    'ui__client/domain/dns__short-title' => 'การตั้งค่า DNS',
    'ui__client/domain/dns__description' => 'จัดการการตั้งค่า DNS โซนสำหรับโดเมน %1',
    'ui__client/domain/dns_self__title' => 'การตั้งค่า DNS',
    'ui__client/domain/dns_self__short-title' => 'การตั้งค่า DNS',
    'ui__client/domain/dns_self__description' => 'จัดการการตั้งค่า DNS โซนสำหรับโดเมนของคุณ',
    'ui__client/domain/dns_disabled__title' => 'การตั้งค่า DNS',
    'ui__client/domain/dns_disabled__short-title' => 'การตั้งค่า DNS',
    'ui__client/domain/dns_disabled__description' => 'จัดการการตั้งค่า DNS โซนสำหรับโดเมน %1',
    'ui__client/domain/dns_self-disabled__title' => 'การตั้งค่า DNS',
    'ui__client/domain/dns_self-disabled__short-title' => 'การตั้งค่า DNS',
    'ui__client/domain/dns_self-disabled__description' => 'จัดการการตั้งค่า DNS โซนสำหรับโดเมนของคุณ',
    'ui__client/domain/dns_readonly__title' => 'การตั้งค่า DNS',
    'ui__client/domain/dns_readonly__short-title' => 'การตั้งค่า DNS',
    'ui__client/domain/dns_readonly__description' => 'ดูการตั้งค่า DNS โซนสำหรับโดเมน %1',
    'ui__client/domain/dns_readonly-self__title' => 'การตั้งค่า DNS',
    'ui__client/domain/dns_readonly-self__short-title' => 'การตั้งค่า DNS',
    'ui__client/domain/dns_readonly-self__description' => 'ดูการตั้งค่า DNS โซนสำหรับโดเมนของคุณ',
    'ui__client/domain/dns_readonly-self-disabled__title' => 'การตั้งค่า DNS',
    'ui__client/domain/dns_readonly-self-disabled__short-title' => 'การตั้งค่า DNS',
    'ui__client/domain/dns_readonly-self-disabled__description' => 'ดูการตั้งค่า DNS โซนสำหรับโดเมนของคุณ',
    'ui__client/domain/dns_readonly-self-slave__title' => 'การตั้งค่า DNS',
    'ui__client/domain/dns_readonly-self-slave__short-title' => 'การตั้งค่า DNS',
    'ui__client/domain/dns_readonly-self-slave__description' => 'ดูการตั้งค่า DNS โซนสำหรับโดเมนของคุณ',
    'ui__client/domain/dns_slave__title' => 'การตั้งค่า DNS',
    'ui__client/domain/dns_slave__short-title' => 'การตั้งค่า DNS',
    'ui__client/domain/dns_slave__description' => 'จัดการการตั้งค่า DNS โซนสำหรับโดเมน %1',
    'ui__client/domain/dns_self-slave__title' => 'การตั้งค่า DNS',
    'ui__client/domain/dns_self-slave__short-title' => 'การตั้งค่า DNS',
    'ui__client/domain/dns_self-slave__description' => 'จัดการการตั้งค่า DNS โซนสำหรับโดเมนของคุณ',
    // FrontPage management - RESELLER/WEBSITE    // PFW

    // applications & services
    // icons
    'ui__client/domain/extras__short-title' => 'เครื่องมือจาก MyPlesk.com',
    'ui__client/domain/extras__title' => 'เครื่องมือจาก MyPlesk.com',
    'ui__client/domain/extras__description' => 'รับเครื่องมือและบริการเพิ่มเติมจาก MyPlesk.com',
    'ui__client/domain/extras_unknown__short-title' => 'เครื่องมือจาก MyPlesk.com',
    'ui__client/domain/extras_unknown__title' => 'เครื่องมือจาก MyPlesk.com',
    'ui__client/domain/extras_unknown__description' => 'รับเครื่องมือและบริการเพิ่มเติมจาก MyPlesk.com',
    'ui__client/domain/extras_self__short-title' => 'เครื่องมือจาก MyPlesk.com',
    'ui__client/domain/extras_self__title' => 'เครื่องมือจาก MyPlesk.com',
    'ui__client/domain/extras_self__description' => 'รับเครื่องมือและบริการเพิ่มเติมจาก MyPlesk.com',
    // Java applications - RESELLER/APPLICATIONS & SERVICES    // PFU
    'ui__client/domain/register__short-title' => 'ลงทะเบียนโดเมน',
    'ui__client/domain/register__title' => 'ลงทะเบียนโดเมน',
    'ui__client/domain/register__description' => 'ลงทะเบียนชื่อโดเมนผ่านทาง MyPlesk.com',
    'ui__client/domain/register_unknown__short-title' => 'ลงทะเบียนโดเมน',
    'ui__client/domain/register_unknown__title' => 'ลงทะเบียนโดเมน',
    'ui__client/domain/register_unknown__description' => 'ลงทะเบียนชื่อโดเมนผ่านทาง MyPlesk.com',
    'ui__client/domain/register_self__short-title' => 'ลงทะเบียนโดเมน',
    'ui__client/domain/register_self__title' => 'ลงทะเบียนโดเมน',
    'ui__client/domain/register_self__description' => 'ลงทะเบียนชื่อโดเมนผ่านทาง MyPlesk.com',
    // dropdowns
    // Create database user - RESELLER/APPLICATIONS & SERVICES

    // additional tools
    // icons
    // Domain aliases - RESELLER/ADDITIONAL TOOLS
    // Scheduled tasks - RESELLER/ADDITIONAL TOOLS    // PFU
    // SSL/TLS certificates - RESELLER/ADDITIONAL TOOLS
    // dropdowns


    ///
    /// END OF DOMAIN / DOMAIN ADMINISTRATOR
    ///

    ////
    //// KEYS FOR BUSINESS OBJECT LISTS/PAGES (RESELLERS, CLIENTS, DOMAINS)
    ////

    ///
    /// DOMAINS
    ///

    // Domains list page title - ui__client/domain_unknown__short-title (HOME)

    // tools
    'ui__client/domain#tools__title' => "เครื่องมือ",
    // Below: TBD
    'ui__client/domain-summary-report_unknown__short-title' => 'ดูสถิติ',
    'ui__client/domain-summary-report_unknown__title' => 'ดูสถิติ',
    'ui__client/domain-summary-report_unknown__description' => 'ดูข้อมูลเกี่ยวกับการใช้ทรัพยากรโดยใช้โดเมน',
    'ui__client/domain-summary-report__short-title' => "ดูสถิติ",
    'ui__client/domain-summary-report__title' => "ดูสถิติ",
    'ui__client/domain-summary-report__description' => "ดูข้อมูลเกี่ยวกับการใช้ทรัพยากรโดยใช้โดเมน",
    'ui__client/domain-summary-report_self__short-title' => "ดูสถิติ",
    'ui__client/domain-summary-report_self__title' => "ดูสถิติ",
    'ui__client/domain-summary-report_self__description' => "ดูข้อมูลเกี่ยวกับการใช้ทรัพยากรโดยใช้โดเมนของคุณ",
    // Traffic usage - ui__client/domain/traffic_unknown__short-title

    'ui__client/domain#list__title' => "โดเมน", // DOMAINS

    // list object operation errors
    'ui__client/domain/delete__empty_selection' => 'คุณต้องเลือกโดเมนที่คุณต้องการลบ',
    'ui__client/domain/chowner__empty_selection' => 'คุณต้องเลือกโดเมนที่คุณต้องการกำหนดเจ้าของใหม่',

    // list objects filtering
    'domains_list__name__filter_title' => 'ชื่อ',
    'domains_list__state__filter_title' => 'การใช้ทรัพยากร',
    'domains_list__filter_state_any' => 'ใดๆ',
    'domains_list__filter_state_overuse' => 'ใช้งานมากเกินไป',
    'domains_list__filter_state_normal' => 'ภายในขีดจำกัด',
    'domains_list__status__filter_title' => 'สถานะ',
    'domains_list__filter_status_any' => 'ใดๆ',
    'domains_list__filter_status_blocked' => 'ระงับชั่วคราวแล้ว',
    'domains_list__filter_status_active' => 'ใช้งานอยู่',
    'domains_list__ownership__filter_title' => 'ความเป็นเจ้าของ',
    'domains_list__filter_ownership_all' => 'โดเมนทั้งหมด',
    'domains_list__filter_ownership_personal' => 'โดเมนของฉันเท่านั้น',
    'domains_list__filter_owner_pname__filter_title' => 'ชื่อเจ้าของ',
    'domains_list__subrows__filter_title' => 'แสดง',
    'domains_list__subrows_off' => 'โดเมนเท่านั้น',
    'domains_list__subrows_subdomain_domainaliases' => 'ด้วยซับโดเมนและนามแฝง',
    'domains_list__subrows_subdomain' => 'ด้วยซับโดเมน',
    'domains_list__subrows_domainaliases' => 'ด้วยนามแผง',

    // objects list
    'domains_list__owner__title' => 'เจ้าของ',

    ///
    /// END OF DOMAINS
    ///

    ////
    //// KEYS FOR APPLICATION VAULT AND WEB APPLICATION MANAGEMENT
    ////

    ///
    /// APPLICATION VAULT / APS CATALOG
    ///

    // Application Vault / APS Catalog promotional block
    'site_apps__promo_browse_for_applications' => "เรียกดูแอพพลิเคชั่น",
    'site_apps__promo_main_text' => "แคตาล็อคมาตรฐานแพคเกจแอพพลิเคชั่น (Application Packaging Standard (APS)) ประกอบด้วยรายชื่อของแอพพลิเคชั่นที่สามารถจัดเตรียมไว้ในโดเมน หรือพื้นที่ว่างของเว็บ หากคุณต้องการแอพพลิเคชั่นที่มีมีอยู่ในรายการ คุณเพียงแค่ทำตามคำแนะนำของ APS แพคเกจใน www.apsstandard.com",
    'site_apps__promo_download_now' => "ดาวน์โหลดแอพพลิเคชั่น",
    'site_apps__promo_close' => "ปิดบล็อคนี้",
    'site_apps__promo_preset__mostused' => '%1 ยอดนิยม',
    'site_apps__promo_preset__lessused' => 'ยอดนิยม %1 ถัดไป',
    'site_apps__promo_preset__all' => "ทั้งหมด",
    'site_apps__promo_disclaimer_note' => 'โปรดทราบว่า แอพพลิเคชั่นที่ติดตั้งจากแคตาล็อค APS จัดทำโดยบุคคลที่สาม และ Plesk ไม่รองรับแอพพลิเคชั่นดังกล่าว',
    'site_apps__promo_preset__page_title' => '%1 แอพพลิเคชั่น APS',

    // Progress bar
    'site_apps__progress_initialization_message' => 'กำลังเพิ่มแอพพลิเคชั่น...',

    // Errors
    'site_apps__no_applications_for_update' => 'คุณไม่มีแอพพลิเคชั่นที่ติดตั้งในแอพพลิเคชั่น Vault',
    'site_apps__incorrect_download_preset_configuration' => 'ข้อผิดพลาดที่พบในการกำหนดค่าของการตั้งค่าดาวน์โหลดแคตตาล็อก APS ล่วงหน้า',
    'site_apps__aps_catalog_url_is_invalid' => 'URL ที่ระบุไม่ถูกต้อง',
    'site_apps__no_updates_at_the_moment' => 'ไม่มีการอัพเดทแอพพลิเคชั่นที่อยู่ในขณะนี้',
    'site_apps__incorrect_content_returned_by_catalog' => 'ข้อมูลที่ได้รับจากแอพพลิเคชั่นแคตาล็อค APS ไม่ถูกต้อง โปรดลองใหม่อีกครั้ง',
    'site_apps__entered_aps_catalog_url_is_not_valid' => 'บันทึกการตั้งค่าแคตตาล็อก APS แล้วแต่ไม่สามารถติดตั้งการเชื่อมต่อกับแคตตาล็อก APS ที่ระบุในการตั้งค่าแคตตาล็อก APS (%1) ได้  ตรวจสอบว่าแอดเดรสแคตตาล็อก APS ถูกต้องแล้วและแคตตาล็อก APS ใช้งานในที่อยู่นี้',
    'site_apps__cannot_retrieve_updates' => 'ไม่สามารถดาวน์โหลดอัพเดทแอพพลิเคชั่นได้ในขณะนี้: ไม่สามารถสร้างการเชื่อมต่อไปยังแคตาล็อค APS (%1) ตรวจสอบให้แน่ใจว่า ที่อยู่ของแคตาล็อค APS นั้นถูกต้อง และมีการใช้งานแคตาล็อค APS',
    'site_apps__no_site_applications_in_client_pool_to_install' => 'ไม่มีแอพพลิเคชั่นเว็บสำหรับการติดตั้ง',
    'site_apps__site_applications_already_installed_in_root' => 'แอพพลิเคชั่นเว็บอื่นที่ติดตั้งอยู่แล้วในสารบบรากของโฮสต์เสมือน',
    'site_apps__dot_net_packages_not_supported_on_unix_platform' => "แอพพลิเคชั่นเว็บ .NET ไม่รองรับUnix/Linux",
    'site_apps__server_wide_packages_not_supported' => 'แอพพลิเคชั่นเว็บไม่รองรับทั่วทั้งเซิร์ฟเวอร์',
    'site_apps__applications_added_to_queue_for_adding_to_application_vault' => "%1 มากกว่าแอพพลิเคชั่นเว็บได้รับการกำหนดตารางเพิ่มเติมไปยังแอพพลิเคชั่น Vault",
    'site_apps__applications_all_in_vault' => "แอพพลิเคชั่นเว็บที่เลือกมีแสดงอยู่ในแอพพลิเคชั่นแล้ว",
    'site_apps__applications_already_in_download_queue' => "%1 แอพพลิเคชั่นเว็บที่เลือกได้รับการเพิ่มไปยังแอพพลิเคชั่น Vault แล้วในขณะนี้",
    'site_apps__applications_already_in_valut' => "%1 แอพพลิเคชั่นเว็บที่เลือกมีอยู่ในแอพพลิเคชั่นแล้ว",

    // UI errors

    ///
    /// END OF APPLICATION VAULT / APS CATALOG
    ///

    ///
    /// APS CATEGORIES
    ///

    // General
    'site_apps__not_categorized' => 'อื่นๆ (ไม่แบ่งประเภท)',

    // Errors
    'site_apps__no_applications_in_category' => 'ไม่มีอแอพพลิเคชั่นในประเภทนี้ โปรดเลือกประเภทอื่น',
    'site_apps__no_category_selected__please_specify' => 'เลือกประเภทในเมนูซ้าย รายการแอพพลิเคชั่นทั้งหมดที่อยู่ในประเภทที่เลือกจะแสดงขึ้นในหน้าต่างนี้',

    // Category: Back office
    // Category: Collaboration
    // Category: Front Office
    // Category: Infrastructure
    // Category: Personal
    // Category: Web

    ///
    /// END OF APS CATEGORIES
    ///

    ///
    /// APPLICATION VAULT
    ///

    //removal


    ///
    /// END OF APPLICATION VAULT
    ///

    ////
    //// KEYS FOR SETTINGS PAGE
    ////

    ///
    /// SERVER ADMINISTRATOR SETTINGS
    ///

    'administrator_account' => 'บัญชีผู้ดูแลระบบ',
    // Personal data - HOME/SERVER ADMINISTRATOR/ACCOUNT
    // Change password - HOME/SERVER ADMINISTRATOR/ACCOUNT
    // Interface preferences - HOME/SERVER ADMINISTRATOR/ACCOUNT

    'general' => 'ทั่วไป',
    // Server settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_change_hostname' => 'เปลี่ยนชื่อโฮสต์',
    // System time - HOME/SERVER ADMINISTRATOR/SERVER
    // IP addresses - HOME/SERVER ADMINISTRATOR/SERVER
    // Scheduled tasks - HOME/SERVER ADMINISTRATOR/SERVER
    // FTP settings - HOME/SERVER ADMINISTRATOR/SERVER    // PFW

    'security' => 'ความปลอดภัย',
    'bt_setup_firewall' => 'ตืดตั้งไฟร์วอลล์',
    'bt_manage_firewall_rules' => 'จัดการหลักเณฑ์ไฟร์วอลล์',
    'cu_firewall__rule' => 'สร้างกฎไฟร์วอลล์',
    'cu_firewall__protocol' => 'ตั้งค่าโปรโตคอลสำหรับกฎ (\'tcp\' หรือ \'udp\')',
    'cu_firewall__name' => "ตั้งชื่อกฎ",
    'cu_firewall__disabled' => 'หาก \'จริง\' จะไม่เปิดใช้งานกฎหลังจากการสร้าง',
    // Session idle time - HOME/SERVER ADMINISTRATOR/SECURITY
    // SSL/TLS certificates - HOME/SERVER ADMINISTRATOR/SECURITY
    // Shared SSL/TLS - HOME/SERVER ADMINISTRATOR/SECURITY    // PFW

    'dns' => 'DNS',
    'bt_select_dns_server' => 'เลือกเซิร์ฟเวอร์ DNS', // PFW
    'bt_soa_records_template' => 'แม่แบบบันทึก SOA',
    'bt_restrict_creation_of_subzones' => 'จัดกัดการสร้างซับโซน',

    'databases' => 'ฐานข้อมูล',
    // Database hosting preferences - HOME/SERVER ADMINISTRATOR/SERVER

    'applications' => 'แอพพลิเคชั่น',
    // ASP.NET settings - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES    // PFW
    // IIS application pool - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES    // PFW
    // SiteBuilder settings - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES

    'mail' => 'เมล',
    'bt_select_mailserver' => 'เลื่อกเซริฟ์เวอร์เมล', // PFW
    // Mail server settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_select_antivirus' => 'เลือกโปรแกรมการป้องกันไวรัส', // PFW
    'bt_virus_protection_settings' => 'การตั้งค่าการป้องกันไวรัส',
    'bt_select_spamfilter' => 'เลือกตัวกรองสแปม', // PFW
    // Spam filter settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_select_webmail' => 'เลือกเว็บเมล',
    // Set up mailing lists server - HOME/SERVER ADMINISTRATOR/SERVER    // PFU

    'logs_and_statistics' => 'บันทึกและสถิติ',
    'bt_server_statistics_settings' => 'การตั้งค่าของสถิติเซิร์ฟเวอร์',
    'bt_select_web_statistics' => 'มีซอฟต์แวร์สถิติเว็บอยู่', // PFW
    // Action log - HOME/SERVER ADMINISTRATOR/LOGS & STATISTICS

    'control_panel_interface' => 'อินเตอร์เฟส Plesk',

    'components_and_modules' => 'คอมโพเนนท์และโมดูล',
    // Server components - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_setup_watchdog' => 'ติดตั้ง Watchdog', // PFU
    'bt_setup_vpn' => 'ติดตั้ง VPN', // PFU
    'bt_setup_samba' => 'ติดตั้งแซมบา',    // PFU

    ///
    /// END OF SERVER ADMINISTRATOR SETTINGS
    ///

    ///
    /// DOMAIN SETTINGS
    ///

    'ui__client/domain/settings_self__title' => 'การตั้งค่า',
    'ui__client/domain/settings_self__short-title' => 'การตั้งค่า',
    'ui__client/domain/settings_self__description' => 'ดูและเปลี่ยนการตั้งค่าโดเมน',

    'domain_administrator_account' => 'บัญชีผู้ดูแลระบบโดเมน',
    // Interface preferences - HOME/DOMAIN ADMINISTRATOR/DOMAIN
    'bt_account_settings' => 'การตั้งค่าบัญชี',

    'domain' => 'โดเมน',
    'bt_dns_soa_records' => 'บันทึก DNS SOA',
    // Mail settings - HOME/DOMAIN ADMINISTRATOR/MAIL
    'bt_task_scheduler_settings' => 'การตั้งค่าตารางงาน',

    'website' => 'เว็บไซต์',
    // Web hosting settings - HOME/DOMAIN ADMINISTRATOR/WEBSITE
    // Bandwidth limiting - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS
    'bt_web_users_scripting' => 'บทคำสั่งสำหรับผู้ใช้เว็บ',
    // Anonymous FTP - HOME/DOMAIN ADMINISTRATOR/FILES

    // Applications - SETTINGS/SERVER/APPLICATIONS    // PFW
    // ASP.NET settings - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW
    // PHP settings - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW
    // IIS application pool - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW

    // Security - SETTINGS/SERVER/SECURITY
    'bt_select_ssl_certificate' => 'เลือกการรับรอง SSL/TLS',
    // Shared SSL/TLS - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW

    // Logs & statistics - SETTINGS/SERVER/LOGS & STATISTICS
    'bt_web_statistics' => 'สถิติเว็บ',
    'bt_log_rotation_settings' => 'การตั้งค่าการหมุนบันทึก',

    ///
    /// END OF DOMAIN SETTINGS
    ///

    ////
    //// KEYS FOR LIMITS AND PERMISSIONS
    ////

    ///
    /// LIMITS
    ///

    '__limits' => "จำกัด", // template

    // overuse & oversell
    'limits__overuse_oversell_policy_legend' => "นโยบายสำหรับการใช้งานมากเกินไป และการขายเกินกว่าที่ผลิตได้",
    'limits__overuse_policy_legend' => "ใช้งานมากเกินไป",
    'limits__oversell_policy_legend' => "การขายเกินกว่าที่ผลิตได้",
    'limits__reseller_overuse_description' => "นโยบายการใช้งานเกินกำหนดสามารถบอก Plesk ได้ว่าควรทำอย่างไรเมื่อมีการใช้ทรัพยากรมากเกินไป",
    'limits__overuse_text' => "นโยบายสำหรับการใช้งานมากเกินไป",

    // limit names
    'limit_group__disk_space_and_traffic' => 'พื้นที่ดิสก์และทราฟฟิค',
    'limit__disk_space' => 'พื้นที่ดิสก์',
    'limit__max_traffic' => 'การรับส่งข้อมูล',
    'limit_group__client' => 'ลูกค้า',
    'limit__max_cl' => 'ลูกค้า',
    'limit_group__domain' => 'โดเมน',
    'limit__max_dom' => 'โดเมน',
    'limit__max_dom_powerUser' => 'การสมัคร',
    'limit__max_subdom' => 'โดเมนย่อย',
    'limit__max_dom_aliases' => 'โดเมนนามแฝง',
    'limit__max_wu' => 'ผู้ใช้เว็บ',
    'limit__max_subftp_users' => 'บัญชี FTP เพิ่มเติม', // PFW
    'limit_group__mail' => 'เมล',
    'limit__max_box' => 'กล่องจดหมาย',
    'limit__mbox_quota' => 'ขนาดกล่องเมล์',
    'limit__total_mboxes_quota' => 'โควต้าทั้งหมดของกล่องจดหมาย', // PFW
    'limit__max_maillists' => 'รายชื่อผู้รับจดหมาย',
    'limit_group__database' => 'ฐานข้อมูล',
    'limit__max_mssql_db' => 'ฐานข้อมูลเซิร์ฟเวอร์ Microsoft SQL', // PFW
    'limit__mssql_dbase_space' => 'โควต้าฐานข้อมูล MS SQL ทั้งหมด', // PFW
    'limit__max_odbc' => 'การเชื่อมต่อ ODBC', // PFW
    // limit__max_db - CONFLICTED
    'limit__mysql_dbase_space' => 'โควต้าฐานข้อมูล MySQL', // PFW
    'limit__pgsql_dbase_space' => 'โควต้าฐานข้อมูล PostgreSQL', // PFW
    'limit_group__application' => 'แอพพลิเคชั่น',
    'limit__max_iis_app_pools' => 'แอพพลิเคชั่นกลุ่ม IIS', // PFW
    'limit_group__security' => 'ความปลอดภัย',
    'limit_group__validity' => 'วันที่หมดอายุ',
    'limit__expiration' => 'วันที่หมดอายุ',
    'limit__validity' => 'ช่วงเวลาที่ใช้ได้',
    'limit__max_site_builder' => 'ไซต์ที่ประกาศด้วย Presence Builder',
    'limit__max_site' => 'โดเมน',
    'limit__mssql_dbase_filesize' => 'ขนาดไฟล์ฐานข้อมูล MS SQL',
    'limit__mssql_dbase_log_filesize' => 'ขนาดไฟล์บันทึกฐานข้อมูล MS SQL',
    'limit__mssql_dbase_filesize_hint' => 'ขนาดสูงสุดของไฟล์ฐานข้อมูล Microsoft SQL',
    'limit__mssql_dbase_log_filesize_hint' => 'ขนาดสูงสุดของไฟล์บันทึกฐานข้อมูล Microsoft SQL',
    'limit__units_mssql_dbase_filesize' => "MB",
    'limit__units_mssql_dbase_log_filesize' => "MB",

    'dom_pref__invalid_max_site_limit' => 'ขีดจำกัดโดเมนไม่ถูกต้อง ค่าเริ่มต่ำสุดคือ 1',

    'property__has_wrong_value' => 'คุณสมบัติ %1 มีค่าไม่ถูกต้อง',
    'property__name_outgoing_messages_domain_limit' => 'ตั้งค่าขีดจำกัดของข้อความขาออกจากโดเมน (ต่อชั่วโมง) เพื่อตั้งค่าแบบไม่จำกัด "-1" ที่ระบุ ระบุ "ค่าเริ่มต้น" เพื่อตั้งค่าที่ระบุในการตั้งค่าทั้งเซิร์ฟเวอร์',
    'property__name_outgoing_messages_mbox_limit' => 'ตั้งค่าขีดจำกัดของข้อความขาออกจากกล่องจดหมาย (ต่อชั่วโมง) เพื่อตั้งค่าแบบไม่จำกัด "-1" ที่ระบุ ระบุ "ค่าเริ่มต้น" เพื่อตั้งค่าที่ระบุในการตั้งค่าทั้งเซิร์ฟเวอร์',
    'property__name_outgoing_messages_subscription_limit' => 'ตั้งค่าขีดจำกัดของข้อความขาออกจากการสมัครใช้บริการ (ต่อชั่วโมง) เพื่อตั้งค่าแบบไม่จำกัด "-1" ที่ระบุ ระบุ "ค่าเริ่มต้น" เพื่อตั้งค่าที่ระบุในการตั้งค่าทั้งเซิร์ฟเวอร์',

    // for CLI report & email notifications
    '__resource_notify' => 'แจ้งเตือน',
    '__general' => 'ทั่วไป',
    '__template_shared' => 'แม่แบบที่ได้รับการแบ่งปัน',
    'limit__overuse' => 'นโยบายสำหรับการใช้งานมากเกินไป',
    'limit__max_traffic_soft' => 'แจ้งเตือนเมื่อการใช้งานถึงที่กำหนด',
    'limit__disk_space_soft' => 'แจ้งเตือนเมื่อการใช้งานพื้นที่ดิสก์ถึงกำหนด',
    '__overuse' => 'นโยบายสำหรับการใช้งานมากเกินไป',
    'performance__title' => 'สมรรถนะ',
    'performance__bandwidth' => 'การใช้แบนวิดธ์สูงสุด (KB/s)',
    'performance__max_connections' => 'จำกัดการเชื่อมต่อไปยัง',

    'gch__hosting_php_isapi' => 'ใช้งาน PHP ในฐานะส่วนขยายของ ISAPI',
    'gch__hosting_ssi_html' => 'ใช้ SSI สำหรับไฟล์ *.htm *.html',
    'gch__hosting_php_handler_type' => 'ใช้งาน PHP ในฐานะ',
    'gch__hosting_php_handler_id' => 'ใช้งาน PHP ในฐานะ',
    'gch__hosting_php_served_by_nginx' => 'PHP ให้บริการโดย nginx',
    'gch__hosting_unpaid_website_status' => 'สถานะของเว็บไซต์ในการสมัครสมาชิกที่มีการระงับการใช้งาน',
    'gch__mn_no_autoresponder' => 'ไม่มีการตั้งค่าการตอบกลับอัตโนมัติสำหรับบัญชีเมล',
    'gch__no_clients_selected' => "ไม่มีบัญชีลูกค้าที่เลือก",
    'gch__no_domains_selected' => "ไม่มีโดเมนที่เลือก",

    // limit units
    'limit__units_disk_space' => "MB",
    'limit__units_max_traffic' => "MB/เดือน",
    'limit__units_mbox_quota' => "KB",
    'limit__units_mysql_dbase_space' => "MB", // PFW
    'limit__units_mssql_dbase_space' => "MB", // PFW
    'limit__units_pgsql_dbase_space' => "MB", // PFW
    'limit__units_total_mboxes_quota' => "MB", // PFW

    // manipulations and statuses of limits
    '__resource_name' => 'ชื่อทรัพยากร',
    '__resource_usage' => 'ใช้แล้ว',
    '__resource_limit' => 'ขีดจำกัด',

    '__used' => 'ใช้แล้ว',
    '__limit' => 'ขีดจำกัด',

    '__never_expires' => 'ไม่เคยหมดอายุ',
    '__resource_free' => '%1 ฟรีของ %2',
    '__resource_unlimited' => 'ใช้ไปแล้ว %1 จากไม่จำกัดจำนวนการใช้',

    '__unlimited' => 'ไม่จำกัด',
    '__increment' => "เพิ่ม(+)",
    '__decrement' => "ลดลง(-)",
    '__pt' => 'หน่วย',
    '__procent' => '%',
    '__overused' => 'ใช้มากเกินไปแล้ว',
    '__left' => 'ซ้าย',
    '__available' => 'มี',
    '__not_available' => 'ไม่รวม',

    ///
    /// END OF LIMITS
    ///

    ///
    /// PERMISSIONS
    ///

    //permissions hints

    ///
    /// END OF PERMISSIONS
    ///

    ////
    //// KEYS FOR STATISTICS AND REPORTS
    ////

    ///
    /// REPORT
    ///

    // administrator

    'ui__admin/report/layout/auto_unknown__short-title' => 'ตารางการส่ง',
    'ui__admin/report/layout/auto_unknown__title' => 'ตารางการส่งรายงาน',
    'ui__admin/report/layout/auto_unknown__description' => 'เลือกตารางการส่งรายงานสำหรับรูปแบบรายงาน',
    'ui__admin/report/layout/auto/properties_new__short-title' => 'เพิ่มตารางการส่งรายงาน',
    'ui__admin/report/layout/auto/properties_new__title' => 'เพิ่มตารางการส่งรายงาน',
    'ui__admin/report/layout/auto/properties_new__description' => 'เพิ่มตารางเวลาในการส่งรายงานสำหรับรายงาน %1',
    'ui__admin/report/layout/auto/properties__short-title' => 'ตารางการส่งรายงาน',
    'ui__admin/report/layout/auto/properties__title' => 'ตารางการส่งรายงาน',
    'ui__admin/report/layout/auto/properties__description' => 'ดูและแก้ไขคุณสมบัติของตารางการส่งรายงาน',
    'ui__admin/report/layout/auto/delete_multi__short-title' => 'ลบตารางการส่งรายงาน',
    'ui__admin/report/layout/auto/delete_multi__title' => 'ลบตารางการส่งรายงาน',
    'ui__admin/report/layout/auto/delete_multi__description' => 'ลบตารางการส่งรายงานที่เลือก',

    'ui__admin/report/layout_unknown__short-title' => 'รูปแบบรายงาน',

    // reselle
    'ui__reseller/traffic__short-title' => '%1',
    'ui__reseller/traffic__title' => 'ดูปริมาณการใช้งานสำหรับ <b>%1</b>',
    'ui__reseller/traffic__description' => 'ดูรายการการใช้ทราฟฟิคสำหรับบัญชีตัวเทนจำหน่าย %1',
    'ui__reseller/traffic_self__short-title' => 'ของฉัน',
    'ui__reseller/traffic_self__title' => 'ดูการใช้งานการรับส่งข้อมูลโดยลูกค้า',
    'ui__reseller/traffic_self__description' => 'ดูรายงานการใช้งานการรับส่งข้อมูลสำหรับบัญชีลูกค้าของคุณ',

       ///
    /// END OF REPORT
    ///

    ///
    /// SUMMARY / FULL REPORT
    ///

    // common full report
    'report__full_p' => 'P',
    'report__full_s' => 'S',
    'report__full_h' => 'H',
    'report__full_reseller_name' => 'ชื่อตัวแทนจำหน่าย', // reseller report
    'report__full_client_name' => 'ชื่อลูกค้า', // customer report
    'report__full_domain_name' => 'ชื่อโดเมน', // domain report
    'report__full_owner' => 'เจ้าของ', // customer & domain reports
    'report__full_creation_date' => 'วันที่สร้าง',
    'report__full_size' => 'ขนาด',
    'report__full_traffic' => 'การรับส่งข้อมูล',
    'report__full_active_clients' => 'ลูกค้าที่ใช้งาน', // reseller report
    'report__full_clients' => 'ลูกค้า', // reseller report
    'report__full_active_domains' => 'โดเมนที่ใช้งานอยู่', // reseller & customer reports
    'report__full_domains' => 'โดเมน', // reseller & customer reports
    'report__full_subdomains' => 'Subdom',
    'report__full_mboxes' => 'Mboxes',
    'report__full_disk_space' => 'พื้นที่ดิสก์',
    'report__full_mail_groups' => 'MForw',
    'report__full_mail_autoresp' => 'Resp',
    'report__full_mail_antispam' => 'ASpam',
    'report__full_mail_antivirus' => 'AVir',
    'report__full_mail_lists' => 'MailList',
    'report__full_web_users' => 'WebUsr',
    'report__full_mysql_databases' => 'MySQL DB',
    'report__full_mssql_databases' => 'MSSQL DB',
    'report__full_pgsql_databases' => 'PostgreSQL DB',

    // common summary report
    'report__section_general' => 'ทั่วไป',
    'report__version' => 'รุ่นผลิตภัณฑ์',
    'report__build' => 'การสร้างผลิตภัณฑ์',
    'report__status' => 'สถานะ',
    'report__company_name' => 'ชื่อบริษัท',
    'report__personal_name' => 'ชื่อส่วนตัว',
    'report__login' => 'ชื่อผู้ใช้',
    'report__phone' => 'โทรศัพท์',
    'report__fax' => 'แฟกซ์',
    'report__email' => 'อีเมล์',
    'report__address' => 'ที่อยู่',
    'report__city' => 'เมือง',
    'report__state' => 'รัฐ/จังหวัด',
    'report__zip_code' => 'รหัสไปรษณีย์',
    'report__country' => 'ประเทศ',
    'report__creation_date' => 'วันที่สร้าง',
    'report__expiration_date' => 'วันที่หมดอายุ',
    'report__dumps_total_size' => 'ขนาดไฟล์สำรองทั้งหมด',
    'report__section_resellers' => 'ตัวแทนจำหน่าย',
    'report__active_resellers' => 'ตัวแทนจำหน่ายที่มีการสมัครที่ใช้งานอยู่',
    'report__resellers' => 'ตัวแทนจำหน่าย',
    'report__section_full_resellers' => 'ตัวแทนจำหน่าย',
    'report__section_clients' => 'ลูกค้า',
    'report__active_clients' => 'ลูกค้าที่มีการสมัครที่ใช้งานอยู่',
    'report__clients' => 'ลูกค้า',
    'report__section_full_clients' => 'ลูกค้า',
    'report__section_personal_clients' => 'ลูกค้าของตนเอง',
    'report__active_personal_clients' => 'ลูกค้าที่มีการสมัครที่ใช้งานอยู่ซึ่งคุณเป็นเจ้าของ',
    'report__personal_clients' => 'ลูกค้าของตนเอง',
    'report__section_full_personal_clients' => 'ลูกค้าของตนเอง',
    'report__section_domains' => 'โดเมน',
    'report__disk_usage' => 'การใช้ดิสก์',
    'report__traffic' => 'การรับส่งข้อมูล',
    'report__active_domains' => 'โดเมนที่ใช้งานอยู่',
    'report__domains' => 'โดเมน',
    'report__subdomains' => 'โดเมนย่อย',
    'report__mboxes' => 'กล่องจดหมาย',
    'report__mail_groups' => 'การส่งต่อเมล',
    'report__mail_autoresp' => 'การตอบกลับอัตโนมัติ',
    'report__mail_lists' => 'รายชื่อผู้รับจดหมาย',
    'report__web_users' => 'ผู้ใช้เว็บ',
    'report__mysql_databases' => 'ฐานข้อมูล MSSQL',
    'report__mssql_databases' => 'ฐานข้อมูล MSSQL',
    'report__pgsql_databases' => 'ฐานข้อมูล PostgreSQL',
    'report__section_full_domains' => 'โดเมน',
    'report__section_personal_domains' => 'โดเมนส่วนตัว',
    // keys here are the same as in report__section_domains section
    'report__section_full_personal_domains' => 'โดเมนส่วนตัว',

    //New for Plesk 10
    'report__sitebuilder_sites' => 'ไซต์ที่ประกาศด้วย Presence Builder',
    'report__invalid_email' => 'โปรดระบุอีเมลแอดเดรสที่ถูกต้อง',


    // CLI-specific sections
    'report__section_hosting' => 'โฮสติ้ง',
    'report__section_webusers' => 'ผู้ใช้เว็บ',
    'report__section_mailnames' => 'บัญชีเมล',
    'report__section_maillists' => 'รายการจดหมาย',
    'report__section_databases' => 'ฐานข้อมูล',
    'report__section_siteapps' => 'แอพพลิเคชั่นเว็บ',
    'report__section_aspnetapps' => 'แอพพลิเคชั่น ASP.NET', // PFW
    'report__owner_pname' => "ชื่อส่วนบุคคลของผู้ให้บริการ",
    'report__owner_login' => "ชื่อของผู้ให้บริการ",

    ///
    /// END OF SUMMARY / FULL REPORT
    ///

    'ui__reseller/report/layout/auto_unknown__short-title' => 'ตารางการส่ง',
    'ui__reseller/report/layout/auto_unknown__title' => 'ตารางการส่งรายงาน',
    'ui__reseller/report/layout/auto_unknown__description' => 'เลือกตารางการส่งรายงานสำหรับรูปแบบรายงาน',
    'ui__reseller/report/layout/auto/properties_new__short-title' => 'เพิ่มตารางการส่งรายงาน',
    'ui__reseller/report/layout/auto/properties_new__title' => 'เพิ่มตารางการส่งรายงาน',
    'ui__reseller/report/layout/auto/properties_new__description' => 'เพิ่มตารางเวลาในการส่งรายงานสำหรับรายงาน %1',
    'ui__reseller/report/layout/auto/properties__short-title' => 'ตารางการส่งรายงาน',
    'ui__reseller/report/layout/auto/properties__title' => 'ตารางการส่งรายงาน',
    'ui__reseller/report/layout/auto/properties__description' => 'ดูและแก้ไขคุณสมบัติของตารางการส่งรายงาน',
    'ui__reseller/report/layout/auto/delete_multi__short-title' => 'ลบตารางการส่งรายงาน',
    'ui__reseller/report/layout/auto/delete_multi__title' => 'ลบตารางการส่งรายงาน',
    'ui__reseller/report/layout/auto/delete_multi__description' => 'ลบตารางการส่งรายงานที่เลือก',

    'ui__reseller/report/layout_unknown__short-title' => 'รูปแบบรายงาน',

    // customer
    'ui__client/traffic__short-title' => '%1',
    'ui__client/traffic__title' => 'ดูปริมาณการใช้งานสำหรับ <b>%1</b>',
    'ui__client/traffic__description' => 'ดูรายงานการใช้งานการรับส่งข้อมูลสำหรับบัญชีลูกค้า %1',
    'ui__client/traffic_self__short-title' => 'การใช้ทราฟฟิค',
    'ui__client/traffic_self__title' => 'การใช้งานรับส่งข้อมูลโดยโดเมน',
    'ui__client/traffic_self__description' => 'ดูรายงานการใช้ทราฟฟิคสำหรับโดเมนของคุณ',

    ////
    //// KEYS FOR VARIOUS FEATURES
    ////

    ///
    /// SERVER INTERFACE
    ///

    // Locales
    // errors
    'locales__not_allowed' => 'ติดตั้งแพ็คภาษาเริ่มต้นที่ระบุแล้วแต่ไม่สามารถใช้งานในระบบได้',

    ///
    /// END OF SERVER INTERFACE
    ///

    ///
    /// HOME PAGE CUSTOMIZATION
    ///

    ///
    /// SESSIONS
    ///

    // Entry keys are under respective HP/ADDITIONAL TOOLS/ACTIVE SESSIONS

    // administrator
    'ui__sessions/delete__short-title' => 'ลบช่วงเวลา',
    'ui__sessions/delete__title' => 'ลบช่วงเวลา',
    'ui__sessions/delete__description' => 'ลบช่วงเวลาที่เลือก',
    'ui__ftp-sessions__short-title' => 'ช่วงเวลา FTP',
    'ui__ftp-sessions__title' => 'ช่วงเวลา FTP',
    'ui__ftp-sessions__description' => 'ดูช่วงเวลา FTP',
    'ui__ftp-sessions/delete__short-title' => 'ลบช่วงเวลา FTP',
    'ui__ftp-sessions/delete__title' => 'ลบช่วงเวลา FTP',
    'ui__ftp-sessions/delete__description' => 'ลบช่วงเวลา FTP ที่เลือก',

    // reseller
    'ui__reseller/sessions/delete__short-title' => 'ลบช่วงเวลา',
    'ui__reseller/sessions/delete__title' => 'ลบช่วงเวลา',
    'ui__reseller/sessions/delete__description' => 'ลบช่วงเวลาที่เลือก',
    'ui__reseller/sessions/delete_self__short-title' => 'ลบช่วงเวลา',
    'ui__reseller/sessions/delete_self__title' => 'ลบช่วงเวลา',
    'ui__reseller/sessions/delete_self__description' => 'ลบช่วงเวลาที่เลือก',
    'ui__reseller/ftp-sessions__short-title' => 'ช่วงเวลา FTP',
    'ui__reseller/ftp-sessions__title' => 'ช่วงเวลา FTP',
    'ui__reseller/ftp-sessions__description' => 'ดูช่วงเวลา FTP',
    'ui__reseller/ftp-sessions_self__short-title' => 'ช่วงเวลา FTP',
    'ui__reseller/ftp-sessions_self__title' => 'ช่วงเวลา FTP',
    'ui__reseller/ftp-sessions_self__description' => 'ดูช่วงเวลา FTP',
    'ui__reseller/ftp-sessions/delete__short-title' => 'ลบช่วงเวลา FTP',
    'ui__reseller/ftp-sessions/delete__title' => 'ลบช่วงเวลา FTP',
    'ui__reseller/ftp-sessions/delete__description' => 'ลบช่วงเวลา FTP ที่เลือก',
    'ui__reseller/ftp-sessions/delete_self__short-title' => 'ลบช่วงเวลา FTP',
    'ui__reseller/ftp-sessions/delete_self__title' => 'ลบช่วงเวลา FTP',
    'ui__reseller/ftp-sessions/delete_self__description' => 'ลบช่วงเวลา FTP ที่เลือก',

    // customer
    'ui__client/sessions/delete__short-title' => 'ลบช่วงเวลา',
    'ui__client/sessions/delete__title' => 'ลบช่วงเวลา',
    'ui__client/sessions/delete__description' => 'ลบช่วงเวลาที่เลือก',
    'ui__client/sessions/delete_self__short-title' => 'ลบช่วงเวลา',
    'ui__client/sessions/delete_self__title' => 'ลบช่วงเวลา',
    'ui__client/sessions/delete_self__description' => 'ลบช่วงเวลาที่เลือก',

    // domain administrator

    'forgery_token_expired' => 'โทเค็นสำหรับเซสชันหมดอายุแล้ว',

    ///
    /// END OF SESSIONS
    ///

    ///
    /// USER ACCOUNT CONVERSION
    ///

    //
    // USER ACCOUNT TYPE CHANGES
    //

    // resellers > customers
    'downgradeResellers__downgrade_resellers' => 'บัญชีตัวแทนจำหน่ายดังต่อไปนี้ที่สามารถแปลงเป็นบัญชีลูกค้าได้',
    'downgradeResellers__downgrade' => 'บัญชีตัวแทนจำหน่ายที่จะได้รับการแปลง',
    // controls
    'downgradeResellers__submit_downgrade' => 'ทำการแปลงบัญชี',
    'downgradeResellers__cancel_downgrade' => 'ยกเลิกการแปลงบัญชี',
    'downgradeResellers__confirm' => 'ยืนยันการแปลง',
    'downgradeResellers__confirm_message' => 'ยืนยันการแปลงบัญชีเพื่อดำเนินการต่อ',
    // errors

    // customers > resellers
    'picker_client_multi__title' => 'เลือกบัญชีลูกค้า',
    'upgradeClients__upgrade_clients' => 'บัญชีลูกค้าดังต่อไปนี้ที่สามารถแปลงเป็นบัญชีตัวแทนจำหน่ายได้',
    'upgradeClients__upgrade' => 'บัญชีลูกค้าที่จะได้รับการแปลง',
    // controls
    'upgradeClients__submit_upgrade' => 'ดำเนินการสแปลงของบัญชี',
    'upgradeClients__cancel_upgrade' => 'ยกเลิกการแปลงของบัญชี',
    'upgradeClients__confirm' => 'ยืนยันการแปลง',
    'upgradeClients__confirm_message' => 'ยืนยันให้ดำเนินการแปลงของบัญชีต่อ',
    // errors
    'upgradeClient__user_is_already_reseller' => 'ไม่สามารถแปลงบบัญชี \'%1\' เป็นบัญชีตัวแทนจำหน่ายได้ \'%1\' เป็นตัวแทนจำหน่ายอยู่แล้ว',

    // domain administrators > customers
    'upgradeDomainUser__upgrade_domain_users' => 'บัญชีผู้ดูแลระบบโดเมนต่อไปนี้จะได้รับการแปลงเป็นบัญชีลูกค้า',
    'upgradeDomainUser__upgrade' => 'บัญชีผู้ดูแลระบบโดเมนจะได้รับการแปลง',
    // controls
    'upgradeDomainUser__submit_upgrade' => 'ดำเนินการแปลงของบัญชี',
    'upgradeDomainUser__cancel_upgrade' => 'ยกเลิกการแปลงของบัญชี',
    'upgradeDomainUser__confirm' => 'ยืนยันการแปลง',
    'upgradeDomainUser__confirm_message' => 'ยืนยันให้ดำเนินการแปลงของบัญชีต่อ',
    // errors
    'upgradeDomainUser__non_upgradeable' => 'ไม่สามารถแปลงบัญชีผู้ดูแลระบบโดเมนได้',
    'upgradeDomainUser__non_upgradeable_domain_users' => 'บัญชีผู้ดูแลระบบโดเมนต่อไปนี้ไม่สามารถแปลงเป็นบัญชีลูกค้าได้',
    'upgradeDomainUser__some_domains_were_not_converted' => 'บัญชีผู้ดูแลระบบโดเมนหลายบัญชีต่อไปนี้ไม่สามารถแปลงเป็นบัญชีลูกค้าได้ %%domainsList%%',
    'upgradeDomainUser__domain_user_does_not_exist' => 'บัญชีผู้ดูแลระบบโดเมนไม่มีอยู่',
    'upgradeDomainUser__domain_owner_must_be_a_reseller' => "โดเมนควรเป็นของผู้ดูแลระบบเซิร์ฟเวอร์หรือตัวแทนจำหน่ายโดยตรง",
    'upgradeDomainUser__all_logins_already_used' => 'ไม่สามารถสร้างบัญชีสำหรับลูกค้าตามผลลัพธ์ได้',
    // notifications
    'upgradeDomainUser__upgrade_notification_subject' => 'แปลงบัญชีผู้ดูแลระบบโดเมนแล้ว',
    'upgradeDomainUser__upgrade_notification_body' => 'บัญชีผู้ดูแลระบบโดเมนของคุณได้รับการแปลงเป็นบัญชีลูกค้าด้วยชื่อผู้ใช้ \'%%login%%\' และรหัสผ่าน \'%%password%%\'',

    //
    // USER ACCOUNT OWNER CHANGES
    //

    // Customer owner change
    // customers selection - reseller & admin home
    'picker_client__title' => 'เลือกบัญชีลูกค้า',
    // errors
    'clientOwnerChanger__owner_has_no_permission' => 'ตัวแทนจำหน่ายที่เลือกไม่มีการอนุญาต \'%1\' แต่ลูกค้าบางรายมีการอนุญาตนี้',
    'clientOwnerChanger__application_not_allowed' => 'ไม่มีแอพพลิเคชั่น \'%1\' ของตัวแทนจำหน่ายที่เลือกแต่มีลูกค้าบางราย',

    // Domain owner change
    'ui__client/domain/chowner_multi-select__wizard-title' => 'กำหนดการสมัครที่เลือกใหม่',
    // errors
    'domain_chown__empty_selection' => 'คุณต้องเลือกเจ้าของใหม่ของโดเมนที่เลือก',



    //
    // USER ACCOUNT STATE CHANGES
    //


    ///
    /// END OF USER ACCOUNT CONVERSION
    ///

    ///
    /// BANDWIDTH LIMITING
    ///

    'hosting_performance__traffic_bandwidth_label' => 'การใช้งานแบนวิดธ์ขั้นสูงสุด (%1)',
    'hosting_performance__max_connection_label' => 'จำกัดการเชื่อมต่อไปยัง',
    'performance__invalid_value' => "ค่าไม่ถูกต้อง ค่าควรอยู่ในช่วงตั้งแต่ %1 ถึง %2",

    ///
    /// END OF BANDWIDTH LIMITING
    ///

    ///
    /// WEBMAIL SELECTION (these keys are currently PfU-only)
    ///

    'webmail__server_legend' => 'เว็บเมล',
    'webmail__server_text' => 'เว็บเมลไคลเอนท์ที่มีอยู่',
    'webmail__none' => 'ไม่มี',

    ///
    /// END OF WEBMAIL SELECTION
    ///


    ////
    //// BACKUP/RESTORATION
    ////

    // random common keys:
    'backup__ip_mapping__server_ip' => 'เซิร์ฟเวอร์ IP กลุ่ม',

    ///
    /// END OF BACKUP MANAGER ACTIONS
    ///

    ///
    /// LISTS
    ///


    // Common info/errors:
    'migration_db_server_not_find' => 'ฐานข้อมูลจะไม่ได้รับการซ่อมแซม: ไม่มีเซิร์ฟเวอร์ฐานข้อมูลที่เหมาะสม',

    ///
    /// END OF LISTS
    ///

    ///
    /// COMMON SCREENS
    ///

    // Back Up
    // Comments - __comments
    '__default_backup_comment_server' => "การสำรองข้อมูลเซิร์ฟเวอร์",
    '__default_backup_comment_reseller' => "สร้างการสำรองข้อมูลบัญชีตัวแทนจำหน่ายโดย %1",
    '__default_backup_comment_client' => "สร้างการสำรองข้อมูลบัญชีลูกค้าโดย %1",
    '__default_backup_comment_domain' => "สร้างการสำรองข้อมูลการสมัครโดย %1",

    // Restoration & backup information

    // IP mapping
    'backup__ip_mapping__clients_ip' => "กลุ่ม IP ของลูกค้า %1",
    'backup__ip_mapping__resellers_ip' => "กลุ่ม IP ของตัวแทนจำหน่าย %1",

    // Conflicts occured
    'backup__restore__object_vhost' => 'โฮสต์เสมือน',
    'backup__restore__object_plesk_admin' => 'ผู้ดูแลระบบ Plesk',
    'backup__restore__object_ftpuser' => 'บัญชี FTP',
    'backup__restore__object_frontpageuser' => 'บัญชี FrontPage',
    'backup__restore__object_webuser' => 'ผู้ใช้เว็บ',
    'backup__restore__object_domain' => 'โดเมน',
    'backup__restore__object_subdomain' => 'ซับโดเมน',
    'backup__restore__object_domainalias' => 'โดเมนนามแฝง',
    'backup__restore__object_client' => 'ลูกค้า',
    'backup__restore__object_reseller' => 'ตัวแทนจำหน่าย',
    'backup__restore__object_autoresponder' => 'การตอบกลับอัตโนมัติ',
    'backup__restore__object_mailalias' => 'เมลนามแฝง',
    'backup__restore__object_database' => 'ฐานข้อมูล',
    'backup__restore__object_mailname' => 'บัญชีเมล',
    'backup__restore__object_db_user' => 'ผู้ใช้ฐานข้อมูล',
    'backup__restore__object_ssl_certificate' => 'การรับรอง SSL/TLS',
    'backup__restore__resellers_cannot_restore_converted_to_customers' => 'ตัวแทนจำหน่ายต่อไปนี้ไม่สามารถกู้คืนได้เนื่องจากได้รับการแปลงไปเป็นลูกค้า: \'%1\'.',
    'backup__restore__customers_cannot_restore_converted_to_resellers' => 'ลูกค้าต่อไปนี้ไม่สามารถกู้คืนได้เนื่องจากได้รับการแปลงไปเป็นตัวแทนจำหน่าย: \'%1\'.',
    'backup__restore__customers_cannot_restore_moved_to_another_owners' => 'ลูกค้าต่อไปนี้ไม่สามารถกู้คืนได้เนื่องจากได้รับการย้ายไปยังเจ้าของรายอื่นๆ: \'%1\'.',

    // Before migration starts
    'backup__restore__capability_not_enough_disk_text' => 'พื้นที่ดิสก์ไม่เพียงพอบนเซิร์ฟเวอร์ปลายทางเพื่อส่งต่อการสมัครใช้้บริการที่เลือก มีอยู่: %1 MB จำเป็นต้องใช้: %2 MB โปรดทราบว่าจะทำการคำนวณพื้นที่ที่จำเป็นต้องใช้จากผลรวมของเว็บ เมล และเนื้อหาฐานข้อมูลของโดเมน จะคำนวณพื้นที่ที่จำเป็นต้องใช้หนึ่งครั้งต่อวันและเก็บไว้ที่แคช ดังนั้นขนาดจริงของโดเมนอาจแตกต่างจากไซต์ที่คำนวณไว้แล้ว หากคุณตรวจสอบแล้วว่าโดเมนที่เลือกไม่กินพื้นที่ที่มีอยู่มากเกินไปคุณสามารถที่จำดำเนินการส่งต่อได้',
    'backup__restore__capability_not_enough_disk_resolution' => 'กรุณาปลดปล่อยพื้นที่ดิสก์บนเซิร์ฟเวอร์ปลายทาง',
    'backup__restore__capability_source_not_enough_disk_text' => 'พื้นที่ดิสก์ไม่เพียงพอบนเซิร์ฟเวอร์ต้นทางที่ใช้เก็บไฟล์เพื่อการส่งต่อ มีอยู่: %1 MB จำเป็นต้องใช้: %2 MB',
    'backup__restore__capability_source_not_enough_disk_resolution' => 'กรุณาปลดปล่อยพื้นที่ดิสก์บนเซิร์ฟเวอร์ต้นทาง',
    'backup__restore__capability_not_enough_disk_resolution_url_text' => 'ข้อมูลเซิร์ฟเวอร์',

    'backup__restore__capability_not_installed_component_text' => 'ไม่มีการติดตั้งคอมโพเนนท์ %1 บนเซิร์ฟเวอร์ปลายทาง ไม่มี %1 อยู่สำหรับออบเจ็กต์ที่กู้คืนมาทั้งหมด',
    'backup__restore__capability_not_installed_component_resolution' => 'กรุณาติดตั้ง %1 และโปรดทราบว่าการดำเนินการอาจใช้เวลาสักครู่',
    'backup__restore__capability_existing_sys_user_text' => 'มีชื่อผู้ใช้ระบบ %1 อยู่แล้วบนเซิร์ฟเวอร์ปลายทาง',
    'backup__restore__capability_existing_sys_user_resolution' => 'กรุณาตั้งชื่อผู้ใช้ระบบที่มีอยู่บนเซิร์ฟเวอร์ปลายทางใหม่อีกครั้ง',
    'backup__restore__capability_license_usage_text' => 'หลังจากการส่งข้อมูลการจำกัดทรัพยากรต่อไปนี้ (กำหนดโดยรหัสลิขสิทธิ์) จะเกินกำหนดบนเซิร์ฟเวอร์ปลายทาง',
    'backup__restore__capability_license_usage_resolution' => 'กรุณาติดตั้งบนเซิร์ฟเวอร์ปลายทางรหัสลิขสิทธิ์อื่นๆ จะจัดปริมาณทรัพยากรที่ต้องการไว้ให้',
    'backup__restore__capability_max_allowed_packet_text' => "พารามิเตอร์ 'max_allowed_packet' บนเซิร์ฟเวอร์ฐานข้อมูลต้นทางคือ %1 ที่ใหญ่กว่าบนเซิร์ฟเวอร์ปลายทางซึ่งก็คือ %2 และอาจไม่มีการกู้คืนออบเจ็กต์ฐานข้อมูลบางอย่างสำหรับโดเมนที่ระบุอยู่ด้านล่าง",
    'backup__restore__capability_max_allowed_packet_resolution' => "กรุณาเพิ่มค่า 'max_allowed_packet' บนเซิร์ฟเวอร์ฐานข้อมูลปลายทาง",

    'backup__restore__capability_postgres_to_lower_version_text' => 'ไม่สามารถส่งต่อฐานข้อมูล PostgreSQL ได้เพราะเวอร์ชั่น PostgreSQL บนเซิร์ฟเวอร์ปลายทางเก่ากว่าบนเซิร์ฟเวอร์ต้นทาง เวอร์ชั่นในปัจจุบันคือ %1 แต่เวอร์ชั่นที่ต้องการคือ %2',
    'backup__restore__capability_postgres_to_lower_version_text_resolution' => 'กรุณาติดตั้งเวอร์ชั่น PostgreSQL ที่ต้องการบนเซิร์ฟเวอร์ปลายทาง',
    'backup__restore__capability_db_server_connection_problems' => 'ไม่สามารถเชื่อมต่อเซิร์ฟเวอร์ฐานข้อมูล PostgreSQL ปลายทางได้ ไม่มีการส่งต่อฐานข้อมูลนอกจากคุณได้กู้คืนการเชื่ิอมต่อแล้ว',
    'backup__restore__capability_db_server_connection_problems_resolution' => 'กรุณาเช็คการตั้งค่าการเชื่อมต่อบนเซิร์ฟเวอร์ฐานข้อมูลปลายทาง',
    'backup__restore__capability_component_not_enabled_server_wide_text' => 'คอมโพเนนท์ %1 ปิดทำงานบนเซิร์ฟเวอร์ปลายทาง',
    'backup__restore__capability_component_not_enabled_server_wide_resolution' => 'กรุณาเปิด %1 บนเซิร์ฟเวอร์ปลายทาง',
    'backup__restore__capability_not_configured_component_text' => 'ไม่มีการกำหนดค่าคอมโพเนนท์ %1 บนเซิร์ฟเวอร์ปลายทาง',
    'backup__restore__capability_not_configured_component_resolution' => 'กรุณากำหนดค่า %1 ที่อยู่บนเครื่องมือ & หน้าการตั้งค่า',

    'backup__restore__capability_webmail_is_not_available' => 'ไม่มีการบริการเว็บเมล %1 บนเซิร์ฟเวอร์ปลายทาง แทนที่ Plesk จะใช้บริการเว็บเมลต่อไปนี้: %2.',
    'backup__restore__capability_webmail_is_not_available_resolution' => 'หากต้องการใช้เว็บเมลเดียวกันกับที่ใช้อยู่บนเซิร์ฟเวอร์ต้นทาง คุณควรติดตั้งเว็บเมลนั้นบนเซิร์ฟเวอร์เครื่องนี้',
    'backup__restore__capability_webmail_is_not_installed_resolution' => 'เพื่อใช้เว็บเมลเดียวกันกับที่ใช้อยู่บนเซิร์ฟเวอร์ต้นทางคุณควรติดตั้งเว็บเมลนั้นบนเซิร์ฟเวอร์ปลายทาง',
    'backup__restore__capability_webmail_is_not_available_changed_on_subscriptions' => "ไม่มีเว็บเมล '%1' บนเซิร์ฟเวอร์ปลายทาง แทนที่การสมัครใช้บริการต่อไปนี้: %3 Plesk จะใช้บริการเว็บเมลต่อไปนี้: %2.",
    'backup__restore__capability_webmail_is_not_installed_custom_resolution' => 'กรุณาติดตั้งเว็บเมลที่จำเป็นบนเซิร์ฟเวอร์ปลายทางของคุณ',
    'backup__restore__capability_webmail_is_not_available_url_text' => 'การตั้งค่าเว็บเมล',

    'backup__restore__capability_shell_is_not_available' => 'ไม่มีเชลล์ %1 บนเซิร์ฟเวอร์ปลายทาง จะใช้หนึ่งในเชลล์ที่มีอยู่แทน',
    'backup__restore__capability_shell_is_not_available_resolution' => 'เพื่อใช้เชลล์เดียวกันกับเชลล์บนเซิร์ฟเวอร์ต้นทางคุณควรเปิด (ใน /etc/shells) หรือติดตั้งบนเซิร์ฟเวอร์ปลายทาง',

    'backup__restore__capability_acl_network_not_allowed_dns_template' => 'เซิร์ฟเวอร์ DNS ปลายทางไม่สนับสนุนเครือข่ายในแม่แบบการจำกัดการส่งต่อ ไม่ทำการกู้คืนบันทึกที่มี IP แอดเดรสเครือข่ายในการจำกัดการส่งต่อ DNS',
    'backup__restore__capability_acl_network_not_allowed_dns_zone' => 'เซิร์ฟเวอร์ DNS ปลายทางไม่สนับสนุนเครือข่ายในแม่แบบการจำกัดการส่งต่อ แต่การสมัครใช้บริการบางอย่างมีเครือข่ายในการจำกัดการส่งต่อ DNS อยู่แล้ว ไม่ทำการกู้คืนบันทึกที่มี IP แอดเดรสเครือข่ายในการจำกัดการส่งต่อ DNS',

    'backup__restore__capability_wrong_php_handler_text' => 'ไม่มีตัวจัดการ PHP %1 บนเซิร์ฟเวอร์ปลายทาง แทนที่ Plesk จะใช้ตัวจัดการ PHP ต่อไปนี้: %2.',
    'backup__restore__capability_wrong_php_handler_resolution' => 'เพื่อใช้ตัวจัดการ PHP เดียวกันกับที่ใช้อยู่บนเซิร์ฟเวอร์ต้นทางคุณควรเปิดหรือติดตั้งเว็บเมลนั้นบนเซิร์ฟเวอร์ปลายทาง',
    'bu_conflict_resolver_php_handler_replaced_in_plans' => 'ตัวจัดการ PHP %1 ไม่พร้อมใช้งาน Plesk จะใช้บริการ%2 ดังต่อไปนี้แทน: {{objects}}',
    'bu_conflict_resolver_php_handler_replaced_in_sites' => 'ตัวจัดการ PHP %1 ไม่พร้อมใช้งาน Plesk จะใช้เว็บไซต์%2 ดังต่อไปนี้แทน: {{objects}}',
    'bu_conflict_resolver_php_handler_not_allowed_in_sites' => 'ตัวจัดการ PHP %1 ไม่พร้อมใช้งานสำหรับเว็บไซต์ต่อไปนี้: {{objects}}',

    'backup__restore__capability_wrong_component_version_text' => 'ไม่มี %1 %2 บนเซิร์ฟเวอร์ปลายทาง จะไม่มีการใช้เวอร์ชั่นเริ่มต้นแทน',
    'backup__restore__capability_wrong_component_version_resolution' => 'เพื่อใช้ %1 เดียวกันกับที่ใช้อยู่บนเซิร์ฟเวอร์ต้นทางคุณควรเปิดหรือติดตั้งเว็บเมลนั้นบนเซิร์ฟเวอร์ปลายทาง',

    'backup__restore__capability_antivirus_not_allowed_outgoing_text' => 'นโยบายการใช้งานโปรแกรมป้องกันไวรัสบนเซิร์ฟเวอร์ปลายทางไม่อนุญาตให้ทำการตั้งค่าโปรแกรมป้องกันไวรัสส่วนบุคคล (ต่ออีเมลแอดเดรส) สำหรับเมลขาออก จะไม่มีการส่งต่อการตั้งค่าเหล่านี้',
    'backup__restore__capability_antivirus_not_allowed_incoming_text' => 'นโยบายการใช้งานโปรแกรมป้องกันไวรัสบนเซิร์ฟเวอร์ปลายทางไม่อนุญาตให้ทำการตั้งค่าโปรแกรมป้องกันไวรัสส่วนบุคคล (ต่ออีเมลแอดเดรส) สำหรับเมลขาเข้า จะไม่มีการส่งต่อการตั้งค่าเหล่านี้',
    'backup__restore__capability_antivirus_not_allowed_personal_settings_text' => 'นโยบายการใช้งานโปรแกรมป้องกันไวรัสบนเซิร์ฟเวอร์ปลายทางไม่อนุญาตให้ทำการตั้งค่าโปรแกรมป้องกันไวรัสส่วนบุคคล (ต่ออีเมลแอดเดรส) จะไม่มีการส่งต่อการตั้งค่าเหล่านี้',
    'backup__restore__capability_antivirus_not_allowed_personal_settings_resolution' => "เพื่อส่งต่อการตั้งค่าโปรแกรมป้องกันไวรัสส่วนบุคคล (ต่ออีเมลแอดเดรส) กรุณาเปิดตัวเลือกที่สอดคล้องกันในการตั้งค่าและเครื่องมือ > การตั้งค่าการป้องกันไวรัส",
    'backup__restore__capability_antivirus_not_active_text' => 'ไม่เปิดซอฟต์แวร์โปรแกรมป้องกันไวรัส การตั้งค่าโปรแกรมป้องกันไวรัสทั้งหมดจากเซิร์ฟเวอร์ต้นทางจะไม่ทำงานจนกว่าคุณจะเลือกซอฟต์แวร์โปรแกรมป้องกันไวรัสบนเซิร์ฟเวอร์ปลายทาง',
    'backup__restore__capability_antivirus_not_active_resolution' => 'กรุณาเลือกซอฟต์แวร์โปรแกรมป้องกันไวรัสในการตั้งค่าและเครื่องมือ > การตั้งค่าการป้องกันไวรัส > ส่วนการตั้งค่าแอนติไวรัส',

    'backup__restore__capability_antivirus_another_active_text' => 'ไม่มีซอฟต์แวร์โปรแกรมป้องกันไวรัส %2 บนเซิร์ฟเวอร์ปลายทาง จะใช้ %1 แทน',
    'backup__restore__capability_antivirus_another_active_resolution' => 'หากต้องการใช้โปรแกรมป้องกันไวรัสเดียวกันกับบนเซิร์ฟเวอร์ต้นทาง กรุณาติดตั้งและเลือกโปรแกรมป้องกันไวรัสในการตั้งค่าและเครื่องมือ > การตั้งค่าการป้องกันไวรัส > ส่วนการตั้งค่าแอนติไวรัส',
    'backup__restore__capability_not_available_sni_text' => 'ไม่มี SNI บนเซิร์ฟเวอร์ปลายทาง เว็บไซต์ที่มี IP แอดเดรสเดียวกันจะไม่สามารถใช้การรับรอง SSL/TLS ส่วนบุคคลได้',
    'backup__restore__capability_not_available_sni_resolution' => "กรุณาตรวจสอบว่าระบบในการดำเนินการบนเซิร์ฟเวอร์ปลายทางสนับสนุนการทำงาน SNI และเปิดตัวสนับสนุน SNI ใน Plesk (กล่องเครื่องหมาย 'เปิดตัวสนับสนุน SNI ที่อนุญาติให้ใช้การรับรอง SSL/TLS ส่วนบุคคลบนเว็บไซต์ที่มี IP แอดเดรสเดียวกัน' ในเครื่องมือและการตั้งค่า > การตั้งค่าเซิร์ฟเวอร์)",
    'backup__restore__capability_not_available_sni_resolution_url_text' => 'การตั้งค่าเซิร์ฟเวอร์',

    'backup__restore__capability_vhost_already_exists_text' => 'ไม่สามารถส่งต่อเว็บไซต์ %1 ได้: มีเว็บไซต์ที่มีชื่อเดียวกันอยู่แล้วบนเซิร์ฟเวอร์ปลายทาง',
    'backup__restore__capability_vhost_already_exists_resolution' => 'กรุณาเปลี่ยนชื่อหรือลบเว็บไซต์ที่ใช้ชื่ิอเดียวกันออกจากเซิร์ฟเวอร์',
    'backup__restore__capability_removed_vhosts' => 'ไม่มีการกู้คืนการสมัครดังต่อไปนี้เพราะการสมัครประกอบด้วยชื่อโดเมนที่มีอยู่บนเซิร์ฟเวอร์ปลายทางแล้ว: %1',
    'backup__restore__capability_duplicate_php_handler_text' => 'บนเซิร์ฟเวอร์ต้นทางมีระบบจัดการ PHP ที่ต่างกัน %3 ของประเภท %1 และเวอร์ชั่น %2 มีการใช้ระบบจัดการในประเภทที่เหมาะสมและเวอร์ชั่นบนเซิร์ฟเวอร์ปลายทางแทนได้ โปรดทราบว่าการตั้งค่า PHP บนเซิร์ฟเวอร์ปลายทางและต้นทางอาจมีความแตกต่างกัน',

    'backup__restore__capability_not_installed_frontpage_resolution' => 'Plesk Installer ไม่สนับสนุน Microsoft Frontpage',
    'backup__restore__capability_not_installed_python_resolution' => 'Plesk Installer ไม่สนับสนุน Python โปรดติดตั้ง Python ด้วยตนเอง',

    'backup__restore__capability_mail_spamfilter_domain_keys_resolution_url_text' => 'การตั้งค่าเซิร์ฟเวอร์เมล',

    'backup__restore__capability_ftps_disabled' => 'อนุญาติให้ใช้ FTPS ที่ปลอดภัยบนเซิร์ฟเวอร์ต้นทางแต่ห้ามใช้ที่เป้าหมาย แอพผู้ใช้ที่ใช้งาน FTP ไม่สามารถทำงานได้อย่างถูกต้อง',
    'backup__restore__capability_ftps_required' => 'อนุญาติให้ใช้ FTPS ที่ไม่ปลอดภัยบนเซิร์ฟเวอร์ต้นทางแต่ห้ามใช้ที่เป้าหมาย แอพผู้ใช้ที่ใช้งาน FTP ไม่สามารถทำงานได้อย่างถูกต้อง',
    'backup__restore__capability_ftps_policy_resolution' => 'เปลี่ยนนโยบายความปลอดภัย FTP ในการตั้งค่าและเครื่องมือ > นโยบายด้านความปลอดภัย',

    'backup__restore__capability_too_much_download_time_text' => 'จะทำการย้ายข้อมูล %1 เมกกะไบต์จากเซิร์ฟเวอร์ต้นทางไปยังปลายทางในอีก %2 ชั่วโมง',
    'backup__restore__capability_too_much_download_time_resolution' => 'กรุณาตรวจสอบการเชื่อมต่อเครือข่ายเซิร์ฟเวอร์ต้นทางและปลายทางและทำหารแก้ปัญหา (หากมี) เพื่อการส่งต่อที่รวดเร็วขึ้น',
    'backup__restore__too_low_download_speed' => "น้อยกว่า 0.01",
    'backup__restore__capability_too_slow_download_speed_resolution' => 'กรุณาตรวจสอบการเชื่อมต่อเครือข่ายเซิร์ฟเวอร์ต้นทางและปลายทางและทำหารแก้ปัญหา (หากมี) เพื่อการส่งต่อที่รวดเร็วขึ้น',
    'backup__restore__capability_zero_download_speed_text' => 'ความเร็วในการดาวน์โหลดน้อยสุดที่ยอมรับได้คือ %1 MB ต่อวินาที ความเร็วในการดาวน์โหลดระหว่างเซิร์ฟเวอร์ต้นทางและปลายทางคือ 0 MB ต่อวินาที อาจเกิดจากปัญหาการเชื่อมต่อเครือข่าย ไม่สามารถทำการส่งต่อ',
    'backup__restore__capability_zero_download_speed_resolution' => 'กรุณาตรวจสอบการเชื่อมต่อเครือข่ายของคุณระหว่างเซิร์ฟเวอร์ปลายทางและต้นทางและแก้ปัญหา',
    'backup__restore__capability_too_slow_download_speed_text' => 'ความเร็วในการดาวน์โหลดน้อยสุดที่ยอมรับได้คือ %2 MB ต่อวินาที ความเร็วในการดาวน์โหลดระหว่างเซิร์ฟเวอร์ต้นทางและปลายทางคือ %1 MB ต่อวินาที อาจช่วยเพิ่มเวลาในการส่งต่อ ในสภาพแวดล้อมปัจจุบัน การย้ายข้อมูล %3 MB อาจใช้เวลา %4 ชั่วโมง',
    'backup__restore__capability_too_slow_download_speed_text_without_diskusage' => 'ความเร็วในการดาวน์โหลดน้อยสุดที่ยอมรับได้คือ %2 MB ต่อวินาที ความเร็วในการดาวน์โหลดระหว่างเซิร์ฟเวอร์ต้นทางและปลายทางคือ %1 MB ต่อวินาที อาจช่วยเพิ่มเวลาในการส่งต่อ',

    'backup__restore__capability_remote_database_migration' => "โดเมนดังต่อไปนี้ใช้งานฐานข้อมูลระยะไกล: %1",
    'backup__restore__capability_remote_database_migration_resolution' => "ห้ามลบโดเมนเหล่านี้ออกจากเซิร์ฟเวอร์ต้นทางหลังจากการส่งต่อหากเวอร์ชั่น Plesk บนเซิร์ฟเวอร์ต้นทางนั้นเก่ากว่า 11.5! ให้ระงับใช้งานโดเมนเหล่านั้นแทน ฐานข้อมูลจะลบจากเซิร์ฟเวอร์ระยะไกลหากคุณลบโดเมนออก หมายเหตุ: มีการเก็บการถ่ายโอนไฟล์ของฐานข้อมูลระยะไกลบนเซิร์ฟเวอร์ต้นทางในไดเร็กทอรี่ %1",

    'backup__restore__capability_mysql_50_to_51_migration' => 'ไฟล์สำรองข้อมูลของเซิร์ฟเวอร์ฐานข้อมูล MySQL ที่เก่ากว่า 5.1 (%1) ไม่อาจกู้คืนค่าได้บน MySQL 5.1.x เพราะ MySQL 5.1.x จัดการกับตัวอักษรยูนิโคดแตกต่างกัน',
    'backup__restore__capability_mysql_50_to_51_migration_resolution' => '',
    'backup__restore__capability_mysql_50_to_51_migration_kb_link_title' => 'กรุณาอ่านบทความพื้นฐานองค์ความรู้ที่เกี่ยวข้อง #136850',

    'backup__restore__capability_courier_not_installed_text' => 'ไม่มีการติดตั้ง Courier-IMAP บนเซิร์ฟเวอร์ปลายทาง',
    'backup__restore__capability_courier_not_installed_resolution' => 'โปรดติดตั้ง Courier-IMAP โดยการใช้ Plesk Installer',
    'backup__restore__capability_dovecot_not_installed_text' => 'ไม่มีการติดตั้ง Dovecot บนเซิร์ฟเวอร์ปลายทาง',
    'backup__restore__capability_dovecot_not_installed_resolution' => 'โปรดติดตั้ง Dovecot โดยการใช้ Plesk Installer',

    'backup__restore__wrong_stat_ttl_value_text' => 'เวลาการเก็บสถิติการรับส่งข้อมูลในการกำหนดค่าของออบเจ็กต์ต่อไปนี้ต้องน้อยกว่าค่าของทั้งเซิร์ฟเวอร์ที่อยู่บนเซิร์ฟเวอร์ปลายทาง',
    'backup__restore__wrong_stat_ttl_value_resolution' => 'กรุณาเปลี่ยนค่าทั้งเซิร์ฟเวอร์สำหรับเวลาในการเก็บสถิติบนเซิร์ฟเวอร์ปลายทาง ตั้งเวลาให้เท่ากับหรือน้อยกว่าค่าที่น้อยที่สุดในการกำหนดค่าของโดเมน',
    'bu_conflict_resolver_wrong_stat_ttl_value' => 'เวลาการเก็บสถิติการรับส่งข้อมูลบนโดเมนบางอันน้อยกว่าค่าของทั้งเซิร์ฟเวอร์ (%1) ค่าจะเปลี่ยนไปเป็น %1 สำหรับโดเมนเหล่านี้',
    'bu_conflict_resolver_wrong_stat_ttl_template_value' => 'เวลาในการเก็บสถิติการรับส่งข้อมูลบนแผนบริการบางแผนน้อยกว่าค่าของทั้งเซิร์ฟเวอร์ (%1) ค่าจะเปลี่ยนไปเป็น %1 สำหรับแผนการบริการเหล่านี้',

    'backup__ip_mapping__map_dedicated_to_shared_ip' => 'การแม็พปิ้ง IP แอดเดรสผูกขาดไปยัง IP แอดเดรสแบบแบ่งปันจะไม่เปิดใช้งาน FTP และ HTTPS นิรนาม (เว้นแต่ตัวสนับสนุน SNI เปิดอยู่)',

    'backup__restore__no_postgresql_commands_text' => 'การสมัครใช้ฐานข้อมูล PostgreSQL ระยะไกลและไฟล์สำรองข้อมูลชั่วคราวไม่สามารถสร้างได้เพราะคำสั่ง pg_dump และ psql บนเซิร์ฟเวอร์ต้นทางหายไป',
    'backup__restore__no_postgresql_commands_resolution' => 'กรุณาติตั้งแพคเกจไคลเอนท์ PostgreSQL ที่สนับสนุนคำสั่งเหล่านี้',
    'backup__restore__capability_apache_modules_disabled_text' => 'โมดูล Apache ดังต่อไปนี้ไม่สามารถเปิดใช้งานได้บนเซิร์ฟเวอร์ปลายทาง %1.',
    'backup__restore__capability_apache_modules_disabled_resolution' => 'กรุณาเปิดโมดูลเพื่อป้องกันปัญหาที่อาจเกิดขึ้น',
    'backup__restore__capability_apache_modules_not_installed_text' => 'โมดูล Apache ดังต่อไปนี้ไม่สามารถติดตั้งได้บนเซิร์ฟเวอร์ปลายทาง %1.',
    'backup__restore__capability_apache_modules_not_installed_resolution' => 'กรุณาติดตั้งและเปิดโมดูลเพื่อป้องกันปัญหาที่อาจเกิดขึ้น',

    'backup__restore__capability_license_not_supported_outgoing_antispam' => 'ไม่สนับสนุนการจำกัดข้อความขาออกเนื่องจากลิขสิทธิ์ของคุณ จะไม่มีการส่งต่อการตั้งค่าการกำหนดค่าที่สอดคล้องกัน',
    'backup__restore__capability_license_not_supported_outgoing_antispam_resolution' => 'กรุณาติดตั้งบนเซิร์ฟเวอร์ปลายทางรหัสลิขสิทธิ์อื่นๆ ที่จัดคุณสมบัติที่ต้องการไว้ให้',
    'backup__restore__capability_disabled_outgoing_antispam' => 'ปิดการจำกัดข้อความขาออกบนเซิร์ฟเวอร์ปลายทาง จะไม่มีการส่งต่อการตั้งค่าการกำหนดค่าที่สอดคล้องกัน',
    'backup__restore__capability_disabled_outgoing_antispam_resolution' => 'กรุณาเปิดการจำกัดข้อความขาออกบนเซิร์ฟเวอร์ปลายทาง',
    'backup__restore__capability_disabled_outgoing_antispam_resolution_url_text' => 'การตั้งค่าเมลทั้งเซิร์ฟเวอร์',

    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported' => 'เมลเซิร์ฟเวอร์ที่ใช้งานอยู่บนเซิร์ฟเวอร์ปลายทางไม่สนับสนุนการจำกัดข้อความขาออกจากกล่องจดหมาย จะไม่มีการส่งต่อค่าในการจำกัดนี้',
    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported_resolution' => 'กรุณาเปลี่ยนเซิร์ฟเวอร์เมลให้เหมือนกับที่คุณใช้งานอยู่ในเซิร์ฟเวอร์ปลายทาง',
    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported_resolution_url_text' => 'การตั้งค่าเมลทั้งเซิร์ฟเวอร์',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported' => 'เมลเซิร์ฟเวอร์ที่ใช้งานอยู่บนเซิร์ฟเวอร์ปลายทางไม่สนับสนุนการจำกัดข้อความขาออกจากโดเมน จะไม่มีการส่งต่อค่าในการจำกัดนี้',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported_resolution' => 'กรุณาเปลี่ยนเซิร์ฟเวอร์เมลให้เหมือนกับที่คุณใช้งานอยู่ในเซิร์ฟเวอร์ปลายทาง',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported_resolution_url_text' => 'การตั้งค่าเมลทั้งเซิร์ฟเวอร์',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported' => 'เมลเซิร์ฟเวอร์ที่ใช้งานอยู่บนเซิร์ฟเวอร์ปลายทางไม่สนับสนุนการจำกัดข้อความขาออกจากการสมัครใช้บริการ จะไม่มีการส่งต่อค่าในการจำกัดนี้',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported_resolution' => 'กรุณาเปลี่ยนเซิร์ฟเวอร์เมลให้เหมือนกับที่คุณใช้งานอยู่ในเซิร์ฟเวอร์ปลายทาง',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported_resolution_url_text' => 'การตั้งค่าเมลทั้งเซิร์ฟเวอร์',

    'bu_conflict_resolver_absent_phosting' => 'ไม่สามารถกู้คืนไฟล์ที่ระบุได้เพราะไม่มีการโฮสต์โครงร่างในการกู้คืนอยู่ ก่อนอื่นกรุณาสร้างโดเมนด้วยการโฮสต์โครงร่างจากนั้นเริ่มต้นการกู้คืนการสำรองข้อมูลอีกครั้ง',
    'bu_conflict_resolver_resellers_management_is_not_supported' => 'ระบบจะไม่กู้คืนข้อมูลผู้จัดจำหน่ายเนื่องจากไม่รองรับระบบจัดการผู้จัดจำหน่าย',

    'backup__restore__capability_modsecurity_not_installed_text' => 'ไม่มีการติดตั้งคอมโพเนนท์ ModSecurity บนเซิร์ฟเวอร์ปลายทาง',
    'backup__restore__capability_modsecurity_not_installed_resolution' => 'กรุณาติดตั้ง ModSecurity เพื่อให้ไฟร์วอลล์แอพพลิเคชั่นเว็บทำงานต่อไปในไซต์การส่งต่อ โปรดทราบว่าการติดตั้งนี้อาจใช้เวลาสักครู่',
    'backup__restore__capability_modsecurity_not_installed_resolution_for_server' => 'ติดตั้ง ModSecurity หากคุณต้องการส่งต่อการตั้งค่าของไฟร์วอลล์แอพพลิเคชั่นเว็บ โปรดทราบว่าการติดตั้งนี้อาจใช้เวลาสักครู่',
    'backup__restore__capability_modsecurity_not_configured_text' => 'ไม่มีการกำหนดค่าคอมโพเนนท์ ModSecurity บนเซิร์ฟเวอร์ปลายทาง',
    'backup__restore__capability_modsecurity_not_configured_resolution' => 'กำหนดค่า ModSecurity หากคุณต้องการให้ไฟร์วอลล์แอพพลิเคชั่นเว็บทำงานต่อไปในไซต์การส่งต่อ',
    'backup__restore__capability_modsecurity_not_configured_resolution_url_text' => 'ไฟร์วอลล์ของเว็บแอปพลิเคชัน (ModSecurity)',
    'backup__restore__capability_modsecurity_not_active_text' => 'ปิดใช้งาน ModSecurity บนเซิร์ฟเวอร์ปลายทาง',
    'backup__restore__capability_modsecurity_not_active_resolution' => 'เปิดใช้งาน ModSecurity หากคุณต้องการให้ไฟร์วอลล์แอพพลิเคชั่นเว็บทำงานต่อไปในไซต์การส่งต่อ',
    'backup__restore__capability_modsecurity_not_active_resolution_url_text' => 'ไฟร์วอลล์ของเว็บแอปพลิเคชัน (ModSecurity)',
    'bu_conflict_resolver_modsecurity_not_installed' => 'ไม่พบการติดตั้งคอมโพเนนท์ของ ModSecurity ไม่ทำการกู้คืนการตั้งค่าไฟร์วอลล์แอพพลิเคชั่นเว็บสำหรับออบเจ็กต์ต่อไปนี้: {{objects}}',
    'bu_conflict_resolver_absent_websites_subscription' => "ไม่สามารถกู้คืนเว็บไซต์ได้เพราะเป็นของการสมัคร %1 ที่ไม่พบอยู่ใน Plesk",
    'backup__restore__capability_not_installed_dns_text' => 'ไม่มีการติดตั้งคอมโพเนนท์ %1 บนเซิร์ฟเวอร์ปลายทาง จะไม่มีการบริการ DNS และการตั้งค่า DNS จะสูญหาย ลดเว็บไซต์ของลูกค้าทั้งหมดลง',
    'bu_conflict_resolver_dns_not_installed' => 'ไม่ได้ติดตั้งบริการ DNS ไม่ทำการกู้คืนการตั้งค่า DNS สำหรับออบเจ็กต์ต่อไปนี้: {{objects}}',
    'backup__restore__subscriptions_cannot_restore_moved_to_another_owners' => 'การสมัครต่อไปนี้ไม่สามารถกู้คืนได้เนื่องจากได้รับการย้ายไปยังเจ้าของรายอื่น: \'%1\'',
    'backup__restore__subscriptions_cannot_restore_moved_to_another_vendors' => 'การสมัครต่อไปนี้ไม่สามารถกู้คืนได้เนื่องจากได้รับการย้ายไปยังผู้ให้บริการรายอื่น: \'%1\'',
    'bu_conflict_resolver_sitebuilder_restore_util_is_not_installed' => 'ไม่สามารถหายูทิลิตี้การกู้คืนข้อมูล Web Presence Builder เพื่อกู้คืนข้อมูล Web Presence Builder พบ อาจยังไม่มีการติดตั้ง Web Presence Builder',
    'backup__restore__capability_renamed_db' => 'ผู้สมัครสมาชิกรายอื่นใช้ชื่อฐานข้อมูล "%1" นี้แล้ว ระบบจะเปลี่ยนชื่อของฐานข้อมูลที่กู้คืนมาเป็น "%2" แทน',
    'backup__restore__capability_renamed_db_user' => 'ผู้สมัครสมาชิกรายอื่นใช้ชื่อผู้ใช้ฐานข้อมูล "%1" นี้แล้ว ระบบจะเปลี่ยนชื่อของผู้ใช้ฐานข้อมูลที่กู้คืนมาเป็น "%2" แทน',
    'backup__restore__capability_not_installed_perl_resolution' => 'Plesk Installer ไม่สนับสนุน Perl โปรดติดตั้ง ActiveState Perl ด้วยตนเอง',
    'backup__restore__capability_php_handler' => '%%version%% %%type%% (id=%%id%%)',
    'backup__restore__capability_php_handler_served_by_apache' => '%%version%% %%type%% ให้บริการโดย Apache (id=%%id%%)',
    'backup__restore__capability_php_handler_served_by_nginx' => '%%version%% %%type%% ให้บริการโดย nginx (id=%%id%%)',


    '__sni' => 'SNI',
    '__kav' => 'โปรแกรมป้องกันไวรัส Kaspersky',
    '__drweb' => 'Odin Premium Antivirus',

    // Resource usage conflicts
    'backup__restore__resource_useage_conflicts' => 'ความขัดแย้งของการใช้ทรัพยากร',
    'backup__restore__hint_resource_usage_conflicts' => 'ความขัดแย้งของการใช้ทรัพยากรเกิดขึ้นเมื่อมีการกู้คืนออบเจ็กต์เกินกว่าขีดจำกัดของการกู้คืน',
    'backup__restore__text_resource_usage_resolution_policy_overusage' => 'ใช้มากเกินไปได้',
    'backup__restore__hint_resource_usage_resolution_policy_overusage' => 'กู้คืนออบเจ็กต์และให้ออบเจ็กต์ใช้ทรัพยากรมากกว่าที่ให้ไว้ตอนแรก',
    'backup__restore__text_resource_usage_resolution_policy_do_not_restore' => 'ห้ามกู้คืน',
    'backup__restore__hint_resource_usage_resolution_policy_do_not_restore' => 'ห้ามกู้คืนออบเจ็กต์ที่มีความขัดแย้งของการใช้ทรัพยากร',
    // Configuration conflicts
    'backup__restore__configuration_conflicts' => 'ความขัดแย้งของการปรับตั้งค่า',
    'backup__restore__hint_configuration_conflicts' => 'ความขัดแย้งของการปรับตั้งค่าเกิดขึ้นเมื่อสิ่งที่ได้รับการกู้คืนมีการตั้งค่าและแอพพลิชั่นเว็บที่ไม่มีอยู่ หรือต้องห้ามจากเจ้าของเซิร์ฟเวอร์หรือออบเจ็กปัจจุบัน ตัวอย่างเช่น ความขัดแย้งของการปรับตั้งค่าจะเกิดขึ้น หากบัญชีเมลที่กู้คืนมีการตั้งค่าตัวกรองสแปมไว้ ในขณะที่มีนโยบายห้ามการตั้งค่าเหล่านี้ในบัญชีเมลทั่วทั้งเซิร์ฟเวอร์',
    'backup__restore__text_configuration_resolution_policy_automatic' => 'อัตโนมัติ',
    'backup__restore__hint_configuration_resolution_policy_automatic' => 'กู้คืนออบเจ็กต์และเปิดตัวเลือกความขัดแย้งของการปรับตั้งค่าอัตโนมัติทั้งหมดที่คุณได้รับอนุญาตให้จัดการ',
    'backup__restore__text_configuration_resolution_policy_do_not_restore' => 'ห้ามกู้คืน',
    'backup__restore__hint_configuration_resolution_policy_do_not_restore' => 'ห้ามกู้คืนออบเจ็กต์ที่มีความขัดแย้งในการปรับตั้งค่า',

    'backup__restore__dedicated_app_pool_restore_to_shared_text' => 'กลุ่มแอพพลิเคชั่น IIS เฉพาะไม่ได้รับอนุญาตให้ใช้งานในการตั้งค่ากลุ่มแอพพลิเคชั่น IIS',
    'backup__restore__dedicated_app_pool_restore_to_shared_resolution' => 'กรุณาเปลี่ยนการตั้งค่ากลุ่มแอพพลิเคชั่น IIS ของคุณในการตั้งค่าและเครื่องมือ>กลุ่มแอพพลิเคชั่น IIS> การตั้งค่าโกลบอล',
    'backup__restore__shared_app_pool_restore_to_dedicated_text' => 'กลุ่มแอพพลิเคชั่น IIS แบบแบ่งปันไม่ได้รับอนุญาตให้ใช้งานในการตั้งค่ากลุ่มแอพพลิเคชั่น IIS',
    'backup__restore__shared_app_pool_restore_to_dedicated_resolution' => 'กรุณาเปลี่ยนการตั้งค่ากลุ่มแอพพลิเคชั่น IIS ของคุณในการตั้งค่าและเครื่องมือ>กลุ่มแอพพลิเคชั่น IIS> การตั้งค่าโกลบอล',

    'backup__restore__unable_allow_short_pop3 _names_text' => 'บัญชีเมล POP3/IMAP อย่างสั้นไม่ได้รับอนุญาตให้ใช้งานบนเซิร์ฟเวอร์ปลายทาง',
    'backup__restore__unable_allow_short_pop3 _names_resolution' => 'ชื่อสั้นสำหรับบัญชีเมลจะไม่มีอยู่หลังจากการกู้คืนข้อมูล',

    // Restore status messages & errors:
    'backup__unable_to_open_log_file' => 'ไม่สามารถเปิดไฟล์การเข้าระบบ',
    'backup__restore__customer_cannot_restore_nonexistent_subscription' => 'ไม่สามารถกู้คืนการสมัคร %1 ได้: ลบการสมัครออกจากบัญชีของคุณและคุณไม่ได้รับอนุญาตให้สร้างการสมัคร หากคุณต้องการกู้คืนกรุณาติดต่อผู้ให้บริการของคุณ',

    'backup__error11' => 'พื้นที่ดิสก์ไม่เพียงพอในการสำรองข้อมูล',
    'backup__error3011' => 'การเชื่อมต่อถูกปฏิเสธ: ไม่มีโปรแกรมทีกำลังฟังที่อยู่ที่ระบุและพอร์ท',
    'backup__error3012' => 'การหมดเวลาการเชื่อมต่อ',
    'backup__error3013' => 'ไม่สามารถเข้าถึงเครือข่ายได้',
    'backup__error3014' => 'ไม่มีเส้นทางในการโฮสต์',
    'backup__error3015' => 'การเชื่อมต่อล้มเหลว',
    'backup__error3016' => 'ไม่สามารถแก้ไขชื่อโฮสต์นี้ได้',
    'backup__error3017' => 'ชื่อหรือรหัสผ่านผู้ใช้ไม่ถูกต้อง',
    'backup__error3018' => 'การเชื่อมต่อ SSH ล้มเหลว',

    'backup__error3110' => 'ไม่สามารถเชื่อมต่อกับตัวแทนการย้ายระยะไกลได้ ไม่มีการเชื่อมต่อกับโฮสต์',
    'backup__error3111' => 'มีการล็อคตัวแทนการย้ายเพราะงานการย้ายล้มเหลวหรือมีการใช้งานอยู่โดยการดำเนินการย้ายอื่นๆ กรุณารีสตาร์ทตัวแทนการย้ายบนเซิร์ฟเวอร์แหล่งที่มา',
    'backup__error3112' => 'ไม่มีการเชื่อมต่อกับโฮสต์หรือตัวแทนการย้ายไม่ทำงานบนโฮสต์แหล่งที่มา',
    'backup__error3113' => 'ไม่สามารถใช้งานตัวแทนการย้ายไปยังโฮสต์ Linux กรุณาเช็คการเชื่อมต่อ SSH ไปยังโฮสต์แหล่งที่มา',
    'backup__error3114' => 'ไม่สามารถใช้งานตัวแทนการย้ายไปยังโฮสต์ Linux: การเชื่อมต่อ SSH ล้มเหลว',
    'backup__error3115' => 'ชื่อหรือรหัสผ่านผู้ใช้ไม่ถูกต้อง',
    'backup__error3116' => 'ผู้ใช้ที่ระบุไม่มีสิทธิ์ของผู้ดูแลระบบ',

    'dns_t__unable_to_remove_ns_record' => 'ไม่สามารถลบบันทึก NS ออกจากแม่แบบ DNS: แต่ละ DNS โซนต้องมีอย่างน้อยหนึ่งบันทึก NS',
    'dns__unsupported_server_zone_transfer' => 'ไม่สามารถส่งต่อแม่แบบการจำกัดการส่งต่อเพราะการกำหนดค่า DNS ทั่วทั้งเซิร์ฟเวอร์: ในเซิร์ฟเวอร์ต้นทางที่อยู่เครือข่ายต่อไปนี้ได้รับอนุญาตสำหรับส่งต่อโซน แต่ที่อยู่เหล่านี้ห้ามใช้งานโดย Microsoft DNS Server: %1',
    'dns__unsupported_domain_zone_transfer' => 'ไม่สามารถส่งต่อแม่แบบการจำกัดการส่งต่อเพราะการกำหนดค่า DNS ของโดเมน: ในบางโดเมนที่อยู่เครือข่ายต่อไปนี้ได้รับอนุญาตสำหรับส่งต่อโซน แต่ที่อยู่เหล่านี้ห้ามใช้งานโดย Microsoft DNS Server: %1',
    ///
    /// END OF COMMON SCREENS
    ///

    ///
    /// DATABASE BACKUP - PFW // TBD
    ///

    // Actions

    'dbbackup__check_network_settings_failed' => 'ไม่สามารถเข้าถึงไดเร็กทอรี่เครือข่ายชั่วคราวที่แบ่งปันสำหรับไฟล์สำรองข้อมูลได้ กรุณาตรวจสอบไดเร็กทอรี่เครือข่าย ชื่อผู้ใช้ และการตั้งค่ารหัสผ่าน ข้อผิดพลาด: %1',

    'migration_select_exist_db_server' => 'เลือกเซิร์ฟเวอร์ฐานข้อมูลปลายทาง',

    'dbbackup__temp_dir_wrong_value' => 'มีการระบุค่าไม่ถูกต้องสำหรับไดเร็กทอรี่ชั่วคราว',
    'dbbackup__network_temp_dir_wrong_value' => 'มีการระบุค่าไม่ถูกต้องสำหรับไดเร็กทอรี่เครือข่ายชั่วคราว',
    'dbbackup__server_backup_not_configured' => 'ยังไม่ได้ปรับตั้งค่าการตั้งค่าการสำรองฐานข้อมูลนี้บนเซิร์ฟเวอร์',
    'dbbackup__temp_dir' => 'ไดเร็กทอรี่ชั่วคราว',
    'dbbackup__temp_dir_hint' => 'เส้นทางไปยังโฟลเดอร์ที่มีอยู่จริงบนเซิร์ฟเวอร์ระยะไกลซึ่งมีเซิร์ฟเวอร์ MS SQL ติดตั้งอยู่ เซิร์ฟเวอร์ MS SQL ต้องสามารถเข้าถึงโฟลเดอร์นี้ได้เพื่อการอ่านและเขียนไฟล์สำรองข้อมูลแบบชั่วคราวได้ ตัวอย่างเช่น C:\\DirectoryPath',
    'dbbackup__network_temp_dir_hint' => 'เส้นทางไปยังการแบ่งปันเครือข่ายนำทางไปที่โฟลเดอร์ที่มีอยู่จริงซึ่งระบุไว้ข้างต้น Plesk จะเข้าถึงโฟลเดอร์ที่ใช้ร่วมกันเพื่อดาวน์โหลดและปลดล็อคไฟล์สำรองข้อมูล ตัวอย่างเช่น \\\\ชื่อเซิร์ฟเวอร์\\พาธไดเรกทอรี่',
    'dbbackup__network_user_hint' => 'ชื่อผู้ใช้ของผู้ใช้เครือข่ายที่สร้างอยู่บนเซิร์ฟเวอร์ระยะไกล ตัวอย่างเช่น ชื่อเซิร์ฟเวอร์\\ชื่อผู้ใช้ ผู้ใช้ต้องสามารถเข้าถึงโฟลเดอร์ที่ใช้ร่วมกันตามที่ระบุไว้ข้างต้นได้',
    'dbbackup__network_password_hint' => 'รหัสผ่านของผู้ใช้เครือข่าย',

    'dbbackup__success_import_without_dublicate_users' => 'ระบบไม่ได้นำเข้าผู้ใช้ต่อไปนี้: %1. มีผู้ใช้เหล่านี้อยู่บนเซิร์ฟเวอร์ฐานข้อมูลแล้ว',

    ///
    /// END OF DATABASE BACKUP
    ///

    ///
    /// LOGS & LOG ROTATION
    ///

    'log_rot__compress' => "บีบอัดไฟล์บันทึก",
    'log_rot__log_rot_status' => "สถานะของกระบวนการหมุนเวียนบันทึก",
    'log_rot__log_rot_period' => "เงื่อนไขการหมุนเวียนการบันทึก",
    'log_rot__log_rot_size' => "ตามขนาด",
    'log_rot__log_rot_time' => "ตามเวลา",
    'log_rot__logrotation_enable' => "เปิดการหมุนเวียนการบันทึก",
    'log_rot__mail' => "ส่งไฟล์บันทึกที่ได้รับการประมวลผลแล้วไปยังอีเมล",
    'log_rot__max_number_of_logfiles' => "จำนวนไฟล์บันทึกสูงสุด",
    'log_rot__time_period' => "ระยะเวลา",
    'log_rot__unable_turn_off' => 'ไม่สามารถปิดการหมุนบันทึกได้เนื่องจากมีการบังคับไว้ในระดับเซิร์ฟเวอร์',
    'log_rot__unable_set_period' => 'ไม่สามารถกำหนดช่วงเวลาในการหมุนบันทึกต่างจาก \'ประจำวัน\' ได้ เนื่องจากมีการบังคับในระดับเซิร์ฟเวอร์',
    'log_rot__unable_set_max_log_files' => 'ไม่สามารถกำหนดจำนวนสูงสุดของไฟล์บันทึกมากกว่าขีดจำกัดของทั้งเซิร์ฟเวอร์ได้ %1',

    /// action log
    // common/various
    'actionlog__digit_expected' => "จำนวนที่คาดไว้: %1",
    'actionlog__incorrect_rotation' => "พารามิเตอร์การหมุนบันทึกที่ระบุไว้ไม่ถูกต้อง: %1",
    'actionlog__unknown_rot_period' => "ระยะเวลาการหมุนที่ไม่รู้จัก: %1",
    'actionlog__unknown_rot_type' => "ประเภทการหมุนที่ไม่รู้จัก: %1",
    'actionlog__session_preferences' => 'การตั้งค่าช่วงเวลา',
    'actionlog__nis2_delete_prohibited' => 'ห้ามไม่ให้ลบบันทึกการเข้าระบบ เนื่องจากมีการบังคับใช้ข้อบังคับของระเบียบ NIS2 อยู่',
    'actionlog__nis2_forbidden_rot_type' => "ไม่สามารถใช้ประเภทการหมุนเวียนบันทึก '%1' ได้ เนื่องจากมีการบังคับใช้ข้อบังคับของระเบียบ NIS2 อยู่",
    // items (PFU schema)
    'actionlog__admin_info' => 'ข้อมูลผู้ดูแลระบบ',
    'actionlog__admin_preferences' => "การปรับตั้งค่าของผู้ดูแลระบบ",
    'actionlog__service' => 'บริการ',
    'actionlog__ip_addr' => 'ที่อยู่ IP',
    'actionlog__client' => 'บัญชีลูกค้า',
    'actionlog__client_status' => 'สถานะบัญชีลูกค้า',
    'actionlog__client_preferences' => "การตั้งค่าหน้าจอของลูกค้า",
    'actionlog__client_ip_pool' => "กลุ่ม IP ของลูกค้า",
    'actionlog__client_siteapp' => "กลุ่มแอพพลิเคชั่นเว็บของลูกค้า",
    'actionlog__client_guid' => "ลูกค้า GUID",
    'actionlog__domain' => 'โดเมนตามค่าเริ่มต้น (โดเมนแรกที่เพิ่มไปยังการสมัครใช้บริการ)',
    'actionlog__domain_owner' => 'เจ้าของการสมัครสมาชิก',
    'actionlog__domain_plan' => 'แผนบริการสำหรับการสมัครใช้บริการ',
    'actionlog__domain_status' => 'โดเมนเริ่มต้น สถานะ',
    'actionlog__domain_dns' => 'โดเมนเริ่มต้น โซน DNS',
    'actionlog__subdomain' => 'ซับโดเมนของโดเมนเริ่มต้น',
    'actionlog__domain_alias' => 'โดเมนเริ่มต้น นามแฝง',
    'actionlog__domain_alias_dns' => 'โดเมนเริ่มต้น โซน DNS นามแฝง',
    'actionlog__site' => 'โดเมน',
    'actionlog__site_status' => 'สถานะโดเมน',
    'actionlog__site_dns' => 'โดเมน DNS โซน',
    'actionlog__site_guid' => 'โดเมน GUID',
    'actionlog__site_subdomain' => 'ซับโดเมน',
    'actionlog__site_alias' => 'นามแฝงโดเมน',
    'actionlog__site_alias_dns' => 'นามแฝงโดเมน DNS โซน',
    'actionlog__domain_limits' => 'ขีดจำกัดการสมัครใช้บริการ',
    'actionlog__domain_limit_size' => 'ขีดจำกัดพื้นที่ดิสก์สำหรับการสมัคร',
    'actionlog__domain_limit_traffic' => 'ขีดจำกัดการรับส่งข้อมูลสำหรับการสมัคร',
    'actionlog__domain_limits_powerUser' => 'ขีดจำกัดการสมัครใช้บริการ',
    'actionlog__domain_limit_size_powerUser' => 'ขีดจำกัดพื้นที่ดิสก์สำหรับการสมัครใช้บริการ',
    'actionlog__domain_limit_traffic_powerUser' => 'ขีดจำกัดการรับส่งข้อมูลสำหรับการสมัครใช้บริการ',
    'actionlog__domain_guid' => "โดเมนเริ่มต้น GUID",
    'actionlog__cp_user' => 'ผู้ใช้ Plesk',
    'actionlog__mailname' => 'บัญชีเมล',
    'actionlog__maillist' => 'รายชื่อผู้รับจดหมาย',
    'actionlog__phosting' => 'การตั้งค่าโฮสติ้ง',
    'actionlog__forwarding' => 'โฮสติ้งมาตรฐานหรือการส่งต่อเฟรม',
    'actionlog__webuser' => 'บัญชีผู้ใช้เว็บ',
    'actionlog__site_application' => 'แอพพลิเคชั่นเว็บ',
    'actionlog__license' => 'รหัสลิขสิทธิ์',
    'actionlog__additional_license' => 'คีย์ใบอนุญาตเพิ่มเติม',
    'actionlog__template_domain' => "แผนการบริการของตัวแทนจำหน่าย",
    'actionlog__template_admin' => "แผนการบริการของผู้ดูแลระบบ",
    'actionlog__template_reseller' => 'แผนการของตัวแทนจำหน่าย',
    'actionlog__admin_alias' => 'บัญชีผู้ดูแลระบบเพิ่มเติม', // PFW
    'actionlog__ftpuser' => 'บัญชี FTP เพิ่มเติม', // PFW
    'actionlog__db_server' => 'เซิร์ฟเวอร์ฐานข้อมูล',
    'actionlog__db' => 'ฐานข้อมูล',
    'actionlog__db_user' => 'บัญชีผู้ใช้ฐานข้อมูล',
    'actionlog__client_sapppkg_pool' => "แอพพลิเคชั่นเว็บของผู้ใช้", // PFW, not used?
    'actionlog__remote_dns' => 'สถานะการควบคุมเซิฟเวอร์ DNS ระยะไกล', // PFW
    'actionlog__reseller' => 'บัญชีตัวแทนจำหน่าย',
    'actionlog__reseller_guid' => 'GUID ตัวแทนจำหน่าย',
    'actionlog__reseller_ip_pool' => "IP กลุ่มตัวแทนจำหน่าย",
    'actionlog__reseller_limit_size' => 'ขีดจำกัดของพื้นที่ดิสก์ของบัญชีตัวแทนจำหน่าย',
    'actionlog__reseller_limit_traffic' => 'ขีดจำกัดของทราฟฟิคของบัญชีตัวแทนจำหน่าย',
    'actionlog__reseller_limits' => 'ขีดจำกัดบัญชีตัวแทนจำหน่าย',
    'actionlog__reseller_permissions' => 'การอนุญาตของผู้แทนจำหน่าย',
    'actionlog__reseller_preferences' => "การตั้งค่าหน้าจอของตัวแทนจำหน่าย",
    'actionlog__reseller_siteapp' => "แอพพลิเคชั่นเว็บในกลุ่มตัวแทนจำหน่าย",
    'actionlog__reseller_status' => 'สถานะบัญชีผู้แทนจำหน่าย',
    'actionlog__health_status' => 'สถานะสภาพเซิร์ฟเวอร์',
    // actions (PFU schema)
    'actionlog__limit_reached' => 'ถึงแล้ว',
    'actionlog__added' => 'เพิ่มแล้ว',
    'actionlog__removed' => 'ลบแล้ว',
    'actionlog__change' => 'เปลี่ยนแล้ว',
    'actionlog__update' => 'อัพเดทแล้ว',
    'actionlog__move' => 'ย้ายแล้ว',
    'actionlog__upgrade' => 'อัพเกรดแล้ว', // PFU?
    'actionlog__update_or_add' => 'อัพเดทหรือเพิ่มแล้ว',
    'actionlog__expired' => 'หมดอายุแล้ว',
    'actionlog__create' => 'สร้างแล้ว',
    'actionlog__delete' => 'ลบแล้ว',
    'actionlog__service_stop' => 'หยุดการทำงานแล้ว',
    'actionlog__service_restart' => 'เริ่มต้นใหม่แล้ว',
    'actionlog__service_start' => 'เริ่มต้นแล้ว',
    'actionlog__login' => 'เข้าสู่ระบบแล้ว',
    'actionlog__logout' => 'ออกจากระบบแล้ว',
    'actionlog__install' => 'ติดตั้งแล้ว',
    'actionlog__uninstall' => 'ถอนการติดตั้งแล้ว',
    'actionlog__reconfigure' => 'ปรับตั้งค่าใหม่แล้ว',
    // events (PFW schema)
    'actionlog__event_pw_reset' => 'คำขอรีเซ็ตรหัสผ่าน',
    'actionlog__event_admin_update' => 'อัพเดทข้อมูลผู้ดูแลระบบแล้ว',
    'actionlog__event_admin_preferences_update' => "อัพเดตการปรับตั้งค่าของผู้ดูแลระบบแล้ว",
    'actionlog__event_service_restart' => 'เริ่มบริการใหม่อีกครั้ง',
    'actionlog__event_service_start' => 'บริการเริ่มทำงานแล้ว',
    'actionlog__event_service_stop' => 'บริการหยุดการทำงานแล้ว',
    'actionlog__event_ip_address_create' => 'สร้าง IP แอดเดรสแล้ว',
    'actionlog__event_ip_address_delete' => 'ลบ IP แอดเดรสแล้ว',
    'actionlog__event_ip_address_update' => 'อัพเดท IP แอดเดรสแล้ว',
    'actionlog__event_client_create' => 'สร้างบัญชีลูกค้า',
    'actionlog__event_client_delete' => 'ลบบัญชีลูกค้า',
    'actionlog__event_client_update' => 'อัพเดตบัญชีลูกค้า',
    'actionlog__event_client_status_update' => 'อัพเดตสถานะบัญชีลูกค้า',
    'actionlog__event_client_preferences_update' => "การอัพเดตหน้าจอของลูกค้า",
    'actionlog__event_client_siteapp_added' => "แอพพลิเคชั่นเว็บที่เพิ่มไปยังกลุ่มแอพพลิเคชั่นของบัญชีลูกค้า",
    'actionlog__event_client_siteapp_removed' => "แอพพลิเคชั่นเว็บที่ลบออกจากกลุ่มแอพพลิเคชั่นของบัญชีลูกค้า",
    'actionlog__event_domain_limit_size_reached' => 'ถึงขีดจำกัดพื้นที่ดิสก์สำหรับการสมัครแล้ว',
    'actionlog__event_domain_limit_traffic_reached' => 'ถึงขีดจำกัดการรับส่งข้อมูลสำหรับการสมัครแล้ว',
    'actionlog__event_domain_limit_size_reached_powerUser' => 'ถึงขีดจำกัดพื้นที่ดิสก์สำหรับการสมัครใช้บริการแล้ว',
    'actionlog__event_domain_limit_traffic_reached_powerUser' => 'ถึงขีดจำกัดการรับส่งข้อมูลสำหรับการสมัครใช้บริการแล้ว',

    'actionlog__domain_limit_database' => 'โควต้าฐานข้อมูลสำหรับการสมัครสมาชิก',
    'actionlog__event_domain_limit_mysql_quota_reached' => 'ถึงขีดจำกัดโควต้าฐานข้อมูล MySQL สำหรับการสมัครสมาชิกแล้ว',
    'actionlog__event_domain_limit_mysql_soft_quota_reached' => 'ถึงขีดจำกัดซอฟต์โควต้าฐานข้อมูล MySQL สำหรับการสมัครสมาชิกแล้ว',
    'actionlog__event_domain_limit_mssql_quota_reached' => 'ถึงขีดจำกัดโควต้าฐานข้อมูลเซิร์ฟเวอร์ Microsoft SQL สำหรับการสมัครสมาชิกแล้ว',
    'actionlog__event_domain_limit_mssql_soft_quota_reached' => 'ถึงขีดจำกัดซอฟต์โควต้าฐานข้อมูลเซิร์ฟเวอร์ Microsoft SQL สำหรับการสมัครสมาชิกแล้ว',
    'actionlog__event_plesk_component_upgrade' => 'อัพเดตคอมโพเนนท์ของ Plesk แล้ว',
    'actionlog__event_plesk_component_install' => 'ติดตั้งคอมโพเนนท์ของ Plesk แล้ว',
    'actionlog__event_plesk_component_uninstall' => 'ถอนการติดตั้งคอมโพเนนท์ของ Plesk แล้ว',
    'actionlog__event_domain_create' => 'สร้างโดเมนตามค่าเริ่มต้น (โดเมนแรกที่เพิ่มไปยังการสมัครใช้บริการ) แล้ว',
    'actionlog__event_domain_delete' => 'ลบโดเมนตามค่าเริ่มต้น (โดเมนแรกที่เพิ่มไปยังการสมัครใช้บริการ) ออกแล้ว',
    'actionlog__event_domain_update' => 'อัพเดตโดเมนตามค่าเริ่มต้น (โดเมนแรกที่เพิ่มไปยังการสมัครใช้บริการ) แล้ว',
    'actionlog__event_domain_owner_change' => 'เปลี่ยนเจ้าของการสมัครใช้บริการ',
    'actionlog__event_domain_plan_change' => 'เปลี่ยนแปลงแผนบริการสำหรับการสมัครใช้บริการแล้ว',
    'actionlog__event_domain_status_update' => 'โดเมนเริ่มต้น อัพเดตสถานะ',
    'actionlog__event_domain_dns_update' => 'โดเมนเริ่มต้น อัพเดต DNS โซน',
    'actionlog__event_subdomain_create' => 'สร้างซับโดเมนของโดเมนเริ่มต้น',
    'actionlog__event_subdomain_delete' => 'ลบซับโดเมนของโดเมนเริ่มต้น',
    'actionlog__event_subdomain_update' => 'อัพเดตซับโดเมนของโดเมนเริ่มต้น',
    'actionlog__event_domain_alias_create' => 'โดเมนเริ่มต้น สร้างนามแฝง',
    'actionlog__event_domain_alias_delete' => 'โดเมนเริ่มต้น ลบนามแฝง',
    'actionlog__event_domain_alias_update' => 'โดเมนเริ่มต้น อัพเดตนามแฝง',
    'actionlog__event_domain_limits_update' => 'อัพเดตขีดจำกัดการสมัครใช้บริการ',
    'actionlog__event_cp_user_login' => 'ผู้ใช้ Plesk ล็อกอิน',
    'actionlog__event_cp_user_logout' => 'ผู้ใช้ Plesk ออกจากระบบ',
    'actionlog__event_mailname_create' => 'สร้างบัญชีเมล',
    'actionlog__event_mailname_delete' => 'ลบบัญชีเมล',
    'actionlog__event_mailname_update' => 'อัพเดตบัญชีเมล',
    'actionlog__event_maillist_create' => 'สร้างรายชื่อผู้รับจดหมายแล้ว',
    'actionlog__event_maillist_delete' => 'ลบรายชื่อผู้รับจดหมายแล้ว',
    'actionlog__event_maillist_update' => 'อัพเดทรายชื่อผู้รับจดหมายแล้ว',
    'actionlog__event_phys_hosting_create' => 'สร้างโฮสติ้งกายภาพแล้ว',
    'actionlog__event_phys_hosting_delete' => 'ลบโฮสติ้งกายภาพแล้ว',
    'actionlog__event_phys_hosting_update' => 'อัพเดทโฮสติ้งกายภาพแล้ว',
    'actionlog__event_forwarding_create' => 'สร้างโฮสติ้งมาตรฐานหรือการส่งต่อเฟรมแล้ว',
    'actionlog__event_forwarding_delete' => 'ลบโฮสติ้งมาตรฐานหรือการส่งต่อเฟรมแล้ว',
    'actionlog__event_forwarding_update' => 'อัพเดทโฮสติ้งมาตรฐานหรือการส่งต่อเฟรมแล้ว',
    'actionlog__event_webuser_create' => 'สร้างบัญชีผู้ใช้เว็บแล้ว',
    'actionlog__event_webuser_delete' => 'ลบบัญชีผู้ใช้เว็บแล้ว',
    'actionlog__event_webuser_update' => 'อัพเดทบัญชีผู้ใช้เว็บแล้ว',
    'actionlog__event_siteapp_install' => 'ติดตั้งแอพพลิเคชั่นเว็บ',
    'actionlog__event_siteapp_reconfigure' => 'ปรับตั้งค่าแอพพลิเคชั่นเว็บ',
    'actionlog__event_siteapp_uninstall' => 'ถอนการติดตั้งแอพพลิเคชั่นเว็บ',
    'actionlog__event_license_update' => 'อัพเดทรหัสลิขสิทธิ์แล้ว',
    'actionlog__event_admin_alias_create' => 'สร้างบัญชีผู้ดูแลระบบเพิ่มเติมแล้ว',
    'actionlog__event_admin_alias_delete' => 'ลบบัญชีผู้ดูแลระบบเพิ่มเติมแล้ว',
    'actionlog__event_admin_alias_update' => 'อัพเดทบัญชีผู้ดูแลระบบเพิ่มเติมแล้ว',
    'actionlog__event_ftpuser_create' => 'สร้างบัญชี FTP เพิ่มเติม',
    'actionlog__event_ftpuser_update' => 'อัพเดตบัญชี FTP เพิ่มเติม',
    'actionlog__event_ftpuser_delete' => 'ลบบัญชี FTP เพิ่มเติม',
    'actionlog__event_template_domain_create' => "สร้างแผนการบริการของตัวแทนจำหน่าย",
    'actionlog__event_template_domain_update' => "อัพเดตแผนการบริการของตัวแทนจำหน่าย",
    'actionlog__event_template_domain_delete' => "ลบแผนการบริการของตัวแทนจำหน่าย",
    'actionlog__event_template_admin_create' => "สร้างแผนการบริการของผู้ดูแลระบบ",
    'actionlog__event_template_admin_update' => "อัพเดตแผนการบริการของผู้ดูแลระบบ",
    'actionlog__event_template_admin_delete' => "ลบแผนการบริการของผู้ดูแลระบบ",
    'actionlog__event_database_server_create' => 'สร้างเซิร์ฟเวอร์ฐานข้อมูลแล้ว',
    'actionlog__event_database_server_update' => 'อัพเดทเซิร์ฟเวอร์ฐานข้อมูลแล้ว',
    'actionlog__event_database_server_delete' => 'ลบเซิร์ฟเวอร์ฐานข้อมูลแล้ว',
    'actionlog__event_remote_dns_status_update' => 'อัพเดทสถานะการควบคุมเซิฟเวอร์ DNS ระยะไกลแล้ว',
    'actionlog__event_session_preferences_update' => 'อัพเดตการตั้งค่าเซสชั่น',
    'actionlog__event_domain_alias_dns_update' => 'โดเมนเริ่มต้น อัพเดต DNS โซนของนามแฝงโดเมน',
    'actionlog__event_domain_move' => 'โดเมนตั้งต้นได้ย้ายไปยังระบบสมัครสมาชิกใหม่แล้ว',
    'actionlog__event_site_move' => 'โดเมนได้ย้ายไปยังระบบสมัครสมาชิกใหม่แล้ว',
    'actionlog__event_site_subdomain_move' => 'โดเมนย่อยได้ย้ายไปยังระบบสมัครสมาชิกใหม่แล้ว',
    'actionlog__event_subdomain_move' => 'โดเมนย่อยของโดเมนตั้งต้นได้ย้ายไปยังระบบสมัครสมาชิกใหม่แล้ว',
    'actionlog__event_license_expired' => 'ลิขสิทธิ์ Plesk หมดอายุแล้ว',
    'actionlog__event_database_create' => 'สร้างฐานข้อมูลแล้ว',
    'actionlog__event_database_delete' => 'ลบฐานข้อมูลแล้ว',
    'actionlog__event_database_user_create' => 'สร้างบัญชีผู้ใช้งานฐานข้อมูลแล้ว',
    'actionlog__event_database_user_update' => 'อัพเดตการตั้งค่าบัญชีผู้ใช้ฐานข้อมูล',
    'actionlog__event_database_user_delete' => 'ลบบัญชีผู้ใช้งานฐานข้อมูลแล้ว',
    'actionlog__event_client_guid_update' => "อัพเดต GUID ลูกค้า",
    'actionlog__event_domain_guid_update' => 'โดเมนเริ่มต้น อัพเดต GUID',
    'actionlog__event_reseller_create' => 'สร้างบัญชีตัวแทนจำหน่ายแล้ว',
    'actionlog__event_reseller_delete' => 'ลบบัญชีตัวแทนจำหน่ายแล้ว',
    'actionlog__event_reseller_update' => 'อัพเดทบัญชีผู้แทนจำหน่ายแล้ว',
    'actionlog__event_reseller_guid_update' => 'อัพเดท GUID ของตัวแทนจำหน่ายแล้ว',
    'actionlog__event_reseller_ip_pool_update' => "อัพเดท IP กลุ่มตัวแทนจำหน่ายแล้ว",
    'actionlog__event_reseller_limit_size_reached' => 'พื้นที่ดิสก์ของบัญชีตัวแทนจำหน่ายถึงขีดจำกัดแล้ว',
    'actionlog__event_reseller_limit_traffic_reached' => 'ทราฟฟิคของบัญชีตัวแทนจำหน่ายถึงขีดจำกัดแล้ว',
    'actionlog__event_reseller_limits_update' => 'อัพเดทขีดจำกัดของตัวแทนจำหน่ายแล้ว',
    'actionlog__event_reseller_permissions_update' => 'อัพเดทการอนุญาตของบัญชีตัวแทนจำหน่ายแล้ว',
    'actionlog__event_reseller_preferences_update' => "อัพเดทการตั้งค่าหน้าจอของตัวแทนจำหน่ายแล้ว",
    'actionlog__event_reseller_siteapp_added' => "เพิ่มแอพพลิเคชั่นไปยังแอพพลิเคชั่นกลุ่มบัญชีผู้แทนจำหน่ายแล้ว",
    'actionlog__event_reseller_siteapp_removed' => "ลบแอพพลิเคชั่นออกจากแอพพลิเคชั่นกลุ่มบัญชีผู้แทนจำหน่ายแล้ว",
    'actionlog__event_reseller_status_update' => 'อัพเดทสถานะบัญชีผู้แทนจำหน่ายแล้ว',
    'actionlog__event_template_reseller_create' => 'สร้างแผนการของตัวแทนจำหน่าย',
    'actionlog__event_template_reseller_delete' => 'ลบแผนการของตัวแทนจำหน่าย',
    'actionlog__event_template_reseller_update' => 'อัพเดตแผนการของตัวแทนจำหน่าย',
    'actionlog__event_health_status_change' => 'เปลี่ยนสถานะสภาพเซิร์ฟเวอร์',
    'actionlog__event_siteapp_upgrade' => 'อัพเกรดแอพเว็บ',
    'actionlog__event_extension_install' => 'ติดตั้งส่วนขยายแล้ว',
    'actionlog__event_extension_uninstall' => 'ถอนการติดตั้งส่วนขยายแล้ว',
    'actionlog__event_extension_upgrade' => 'อัพเกรดส่วนขยายแล้ว',
    'actionlog__event_extension_status_update' => 'อัพเดตสถานะส่วนขยายแล้ว',
    'actionlog__event_additional_license_expired' => 'ใบอนุญาตเพิ่มเติมหมดอายุแล้ว',
    'actionlog__event_hostname_changed' => 'เปลี่ยนชื่อโฮสต์ของเซิร์ฟเวอร์แล้ว',
    'actionlog__event_smb_user_create' => 'สร้างผู้ใช้เพิ่มเติมแล้ว',
    'actionlog__event_smb_user_delete' => 'ลบผู้ใช้เพิ่มเติมแล้ว',
    'actionlog__event_smb_user_update' => 'อัปเดตผู้ใช้เพิ่มเติมแล้ว',

    // REMOTE SESSION
    'rsession_no_api_rpc_errmsg' => "ไม่มีการติดตั้ง Plesk API RPC บนโฮสต์ระยะไกล ติดต่อผู้ให้บริการของคุณเพื่อขอคำแนะนำ",
    'rsession_no_account_errmsg' => "ไม่สามารถเข้าถึงบริการทางไกลจากบัญชีของคุณได้ สาเหตุที่พบบ่อยที่สุดสำหรับบัญชีของคุณคือ ยังไม่มีการเปิดบริการดังกล่าวสำหรับบัญชีนี้ โปรดรอสักครู่ จากนั้นให้ลองใหม่อีกครั้ง หากคุณยังพบกับข้อผิดพลาดดังกล่าวอีก ให้ติดต่อผู้ดูแลระบบ",
    'rsession_no_domain_errmsg' => "ไม่สามารถเข้าถึงบริการทางไกลสำหรับโดเมนนี้ สาเหตุที่พบบ่อยที่สุดสำหรับโดเมนของคุณคือ ยังไม่มีการเปิดบริการดังกล่าวสำหรับบัญชีนี้ โปรดรอสักครู่ จากนั้นให้ลองใหม่อีกครั้ง หากคุณยังพบกับข้อผิดพลาดดังกล่าวอีก ให้ติดต่อผู้ดูแลระบบ",
    'rsession_unknown_errmsg' => "เซิร์ฟเวอร์ทางไกลได้ปฏิเสธที่ความพยายามในการเชื่อมต่อช่วงเวลา โปรดติดต่อผู้ดูแลระบบของคุณสำหรับควมช่วยเหลือ ข้อผิดพลาดคือ %1",
    'rsession_unknown2_errmsg' => "มีข้อผิดพลาดที่ไม่รู้จักเกิดขึ้นในขณะการเชื่อมต่อช่วงเวลาระยะไกล ปัญหาที่พบบ่อยที่สุดคือ เซิร์ฟเวอรืทางไกลไม่ตอบรับ หรือไม่ตอบรับเลย ให้สขอผู้ดูแลระบบของคูณตรวจสอบรายละเอียดของข้อผิดพลาดในบันทึกข้อผิดพลาดของเซิร์ฟเวอร์เว็บ",
    'rsession_no_connect_errmsg' => "ไม่สารถเข้าถึงบริการทางไกล: การเชื่อมต่อไปยังช่วงเวลาระยะไกลล้มเหลว ให้ติดต่อผู้ดูและระบบของคุณสำหรับความช่วยเหลือ",

    // ANONYMOUS FTP
    'anonftp__allow_upload_incoming' => "อนุญาตให้อัพโหลดไปยังไดเร็กทอรี่ที่กำลังนำเข้า",
    'anonftp__allow_create_dirs' => 'อนุญาตให้สร้างไดเร็กทอรี่ในไดเร็กทอรี่ที่กำลังนำเข้า',
    'anonftp__allow_download_incoming' => 'อนุญาตให้ดาวน์โหลดจากไดเร็กทอรี่ที่กำลังนำเข้า',
    'anonftp__display_login' => 'แสดงข้อความการเข้าสู่ระบบ',
    'anonftp__login_text' => 'ข้อความตัวอักษร',
    'anonftp__limit_incoming_disk_space' => "จำกัดพื้นที่ดิสก์ในสารบบที่กำลังนำเข้า",
    'anonftp__limit_maximum_bandwidth' => "จำกัดการดาวน์โหลดแบนด์วิดธ์สำหรับโดเมน FTP เสมือน",
    'anonftp__limit_maximum_connections' => "จำกัดจำนวนของการเชื่อมต่อพร้อมกัน",
    'anonftp__unable_init' => "ไม่สามารถเริ่มต้นบัญชี FTP แบบนิรนาม: %1",
    'anonftp__unable_set_quota' => "ไม่สามารถตั้งค่าจำกัดพื้นที่ดิสก์ของสารบบที่กำลังนำเข้า: %1",
    'anonftp__unable_update' => "ไม่สามารถอัพเดทคุณสมบัติของบัญชี FTP แบบนิรนาม: %1",

    ///
    /// SSL/TLS CERTIFICATES
    ///

    // common keys
    '__certificates' => 'การรับรอง SSL/TLS', // page title
    // errors
    'class_sslcertificate__ca_not_signs' => "การรับรอง CA ไม่ได้ลงนามกับการรับรอง",
    'class_sslcertificate__incompatible_pvt_key_cert' => "รหัสส่วนตัว/การจับคู่การรับรองเข้ากันไม่ได้",
    'class_sslcertificate__invalid_cert_format' => "รูปแบบการรับรองไม่ถูกต้อง",
    'class_sslcertificate__invalid_private_key_format' => "รูปแบบรหัสส่วนตัวไม่ถูกต้อง",
    'class_sslcertificate__prob_invalid_priv_key' => "บางทีอาจเป็นเพราะรูปแบบรหัสส่วนตัวไม่ถูกต้อง",

    ///
    ///END OF SSL/TLS CERTIFICATES
    ///

    ///
    /// WEB DIRECTORIES (PFW)
    ///

    //
    // DOMAIN
    //

    // Web Directories tab
    // Web Directories - ui__client/domain/hosting/web-directories__title (HOME/DOMAIN)
    'ui__client/domain/hosting/web-directories/create-virtual-dir__short-title' => 'สร้างสารบบเสมือน',
    'ui__client/domain/hosting/web-directories/create-virtual-dir__title' => 'สร้างสารบบเสมือน',
    'ui__client/domain/hosting/web-directories/create-virtual-dir__description' => 'สร้างไดเร็กทอรี่เสมือน',
    'ui__client/domain/hosting/web-directories/create-virtual-dir_self__short-title' => 'สร้างสารบบเสมือน',
    'ui__client/domain/hosting/web-directories/create-virtual-dir_self__title' => 'สร้างสารบบเสมือน',
    'ui__client/domain/hosting/web-directories/create-virtual-dir_self__description' => 'สร้างไดเร็กทอรี่เสมือน',
    'ui__client/domain/hosting/web-directories/properties__short-title' => 'คุณสมบัติของสารบบ',
    'ui__client/domain/hosting/web-directories/properties__title' => 'คุณสมบัติของสารบบเสมือน',
    'ui__client/domain/hosting/web-directories/properties__description' => 'ดูและเปลี่ยนแปลงคุณสมบัติของสารบบเสมือน',
    'ui__client/domain/hosting/web-directories/properties_self__short-title' => 'คุณสมบัติของสารบบ',
    'ui__client/domain/hosting/web-directories/properties_self__title' => 'คุณสมบัติของสารบบเสมือน',
    'ui__client/domain/hosting/web-directories/properties_self__description' => 'ดูและเปลี่ยนแปลงคุณสมบัติของสารบบเสมือน',

    // MIME Types tab
    'ui__client/domain/hosting/web-directories/mime-type_unknown__short-title' => 'ประเภท MIME',
    'ui__client/domain/hosting/web-directories/mime-type_unknown__title' => 'ประเภท MIME',
    'ui__client/domain/hosting/web-directories/mime-type_unknown__description' => 'ดูรายการของประเภท MIME ที่ลงทะเบียน',
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__short-title' => 'เพิ่มประเภท MIME',
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__title' => 'เพิ่มประเภท MIME',
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__description' => 'ลงทะเบียนระเภท MIME ใหม่',

    // Error documents tab
    'ui__client/domain/hosting/web-directories/error-doc_unknown__short-title' => 'เอกสารที่ผิดพลาด',
    'ui__client/domain/hosting/web-directories/error-doc_unknown__title' => 'เอกสารที่ผิดพลาด',
    'ui__client/domain/hosting/web-directories/error-doc_unknown__description' => 'ดูและเปลี่ยนแปลงเอกสารทีผิดพลาด',

    // Protection tab
    'ui__client/domain/hosting/web-directories/protection__short-title' => 'การป้องกัน',
    'ui__client/domain/hosting/web-directories/protection__title' => 'การป้องกันสารบบ',
    'ui__client/domain/hosting/web-directories/protection__description' => 'จำกัดการเข้าถึงไดเร็กทอรี่ด้วยการป้องกันด้วยรหัสผ่าน',
    'ui__client/domain/hosting/web-directories/protection_self__short-title' => 'การป้องกัน',
    'ui__client/domain/hosting/web-directories/protection_self__title' => 'การป้องกันสารบบ',
    'ui__client/domain/hosting/web-directories/protection_self__description' => 'จำกัดการเข้าถึงไดเร็กทอรี่ด้วยการป้องกันด้วยรหัสผ่าน',
    'ui__client/domain/hosting/web-directories/protection/properties__short-title' => 'การตั้งค่า',
    'ui__client/domain/hosting/web-directories/protection/properties__description' => 'ดูตำแหน่งไดเร็กทอรี่และระบุหัวข้อสำหรับพื้นที่ที่ได้รับการป้องกัน',
    'ui__client/domain/hosting/web-directories/protection/user/properties__title' => 'การตั้งค่าผู้ใช้',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__title' => 'เพิ่มผู้ใช้',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__short-title' => 'เพิ่มผู้ใช้',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__description' => 'เพิ่มบัญชีผู้ใช้ที่อนุญาตให้เข้าถึงไดเร็กทอรี่ที่ำได้รับการป้องกัน',
    'ui__client/domain/hosting/web-directories/protection/properties__done' => 'นำการตั้งค่าใหม่มาใช้งาน',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__done' => 'เพิ่มบัญชีผู้ใช้แล้ว',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__short-title' => 'ลบ',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__description' => 'ลบบัญชีผู้ใช้ของไดเร็กทอรี่ที่ำได้รับการป้องกัน',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__title' => 'ลบบัญชีผู้ใช้',
    'ui__client/domain/hosting/web-directories/protection/user/delete#legend__description' => 'ยืนยันการลบบัญชีผู้ใช้',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__done' => 'ลบบัญชีผู้ใช้ออกแล้ว',

    //
    // SUBDOMAIN
    //

    // Web Directories tab

    // list object operations

    // MIME Types tab

    // Protection tab
    // Error documents tab

    ///
    /// END OF WEB DIRECTORIES
    ///

    ///
    /// SUBDOMAIN PAGE
    ///


    ///
    /// END OF SUBDOMAIN PAGE
    ///

    ///
    /// DONE MESSAGES
    ///

    // UI
    'ui____done' => 'การดำเนินการเสร็จสมบูรณ์แล้ว',
    'ui__admin/extras-domain__done' => 'หน้า MyPlesk.com เปิดอยู่',
    'ui__admin/report/layout/delete_multi__done' => 'ลบรูปแบบรายงานที่เลือกแล้ว',
    'ui__admin/report/traffic-history__done' => 'การดำเนินการเสร็จสมบูรณ์แล้ว',
    'ui__admin/report__done' => 'การดำเนินการเสร็จสมบูรณ์แล้ว',
    'ui__admin-alias/delete_multi__done' => "ลบบัญชีผู้ดูแลระบบเพิ่มเติมที่เลือกแล้ว",
    'ui__admin-alias/properties__done' => "อัพเดทคุณสมบัติของบัญชีผู้ดูแลระบบเพิ่มเติมแล้ว",
    'ui__admin-alias/properties_new__done' => "สร้างบัญชีผู้ดูแลระบบเพิ่มเติมแล้ว",
    'ui__admin-alias/properties_unknown__done' => "อัพเดทคุณสมบัติของบัญชีผู้ดูแลระบบเพิ่มเติมแล้ว",
    'ui__admin-alias__done' => "อัพเดทข้อมูลบัญชีผู้ดูแลระบบเพิ่มเติมสำเร็จแล้ว",
    'ui__admin/manage-domain__done' => 'หน้า MyPlesk.com เปิดอยู่',
    'ui__admin/register-domain__done' => 'หน้า MyPlesk.com เปิดอยู่',
    'ui__admin/report/layout/auto/delete_multi__done' => 'ลบตารางการส่งรายงานที่เลือกแล้ว',
    'ui__admin/report/layout/auto/properties__done' => 'อัพเดทตารางการส่งรายงานแล้ว',
    'ui__admin/report/layout/auto/properties_new__done' => 'สร้างตารางการส่งรายงานแล้ว',
    'ui__client/domain/certificate/properties__done' => 'อัพเดทคุณสมบัติการรับรอง SSL/TLS แล้ว',
    'ui__client/domain/certificate/properties_new__done' => 'เพิ่มการรับรอง SSL/TLS ใหม่แล้ว เพื่อทำให้ใช้งานได้ ต้องตรวจสอบว่าได้ทำการเลือกที่การตั้งค่าการโฮสต์เว็บไซต์ (ที่แท็บเว็บไซต์และโดเมน > ชื่อโดเมน)',
    'ui__client/domain/certificate__done' => 'การดำเนินการเสร็จสมบูรณ์แล้ว',
    'ui__client/domain/certificate_self__done' => 'การดำเนินการเสร็จสมบูรณ์แล้ว',
    'ui__client/domain/chowner__done' => 'การสมัคร %1 เป็นของผู้ใช้อื่นแล้ว',
    'ui__client/domain/chowner_multi__done' => 'เปลี่ยนเจ้าของการสมัคร',
    'ui__client/domain/chowner_multi-select__done' => 'การดำเนินการเสร็จสมบูรณ์แล้ว',
    'ui__client/domain/chowner_select__done' => 'การดำเนินการเสร็จสมบูรณ์แล้ว',
    'ui__client/domain/dbbackup/create__done' => "สำรองข้อมูลฐานข้อมูลสำเร็จแล้ว", // PFW
    'ui__client/domain/dbbackup/get__done' => "สำรองข้อมูลฐานข้อมูลสำเร็จแล้ว", // PFW
    'ui__client/domain/dbbackup/orphaned__done' => "ซ่อมผู้ใช้ที่โดนละทิ้งสำเร็จแล้ว", // PFW
    'ui__client/domain/dbbackup/remove__done' => "ลบไฟล์สำรองข้อมูลสำเร็จแล้ว", // PFW
    'ui__client/domain/dbbackup/restore__done' => "กู้คืนเนื้อหาฐานข้อมูลเรียบร้อยแล้ว", // PFW
    'ui__client/domain/dbbackup/upload__done' => "การดำเนินการเสร็จสมบูรณ์แล้ว", // PFW
    'ui__client/domain/dbbackup__done' => "การดำเนินการเสร็จสมบูรณ์แล้ว", // PFW
    'ui__client/domain/dbbackup_self__done' => "การดำเนินการเสร็จสมบูรณ์แล้ว", // PFW
    'ui__client/domain/dbbackup_unknown__done' => "การดำเนินการเสร็จสมบูรณ์แล้ว", // PFW
    'ui__client/domain/delete__done' => "ลบโดเมน %1 แล้ว",
    'ui__client/domain/delete_multi__done' => "ลบโดเมนแล้ว",
    'ui__client/domain/disable__done' => 'ระงับใช้งานโดเมน %1 แล้ว',
    'ui__client/domain/disable_multi__done' => 'ระงับการใช้งานโดเมนที่เลือก',
    'ui__client/domain/enable__done' => 'เปิดใช้งานเว็บไซต์ %1 แล้ว',
    'ui__client/domain/enable_multi__done' => 'เปิดใช้งานเว็บไซต์ที่เลือก',
    'ui__client/domain/extras__done' => 'หน้า MyPlesk.com เปิดอยู่',
    'ui__client/domain/extras_self__done' => 'หน้า MyPlesk.com เปิดอยู่',
    'ui__client/domain/hosting/logs/rotation__done' => 'เปลี่ยนการตั้งค่าการหมุนเวียนบันทึก',
    'ui__client/domain/hosting/logs/rotation_self__done' => 'เปลี่ยนการตั้งค่าการหมุนเวียนบันทึก',
    'ui__client/domain/hosting/logs__done' => 'การดำเนินการเสร็จสมบูรณ์แล้ว',
    'ui__client/domain/hosting/logs_self__done' => 'การดำเนินการเสร็จสมบูรณ์แล้ว',
    'ui__client/domain/hosting/setup__done' => 'ปรับตั้งค่าโฮสติ้งสำหรับ %1 แล้ว',
    'ui__client/domain/hosting/ssh-terminal__done' => 'การดำเนินการเสร็จสมบูรณ์แล้ว', // PFU
    'ui__client/domain/hosting/ssh-terminal_self__done' => 'การดำเนินการเสร็จสมบูรณ์แล้ว', // PFU
    'ui__client/domain/hosting/web-directories/create-dir__done' => 'สร้างไดเร็กทอรี่เสมือนภายในเว็บไซต์ %1 แล้ว', // PFW
    'ui__client/domain/hosting/web-directories/create-virtual-dir__done' => 'สร้างไดเร็กทอรี่เสมือนแล้ว', // PFW
    'ui__client/domain/hosting/web-directories/delete__done' => 'ลบไดเร็กทอรี่ที่เลือกแล้ว', // PFW
    'ui__client/domain/hosting/web-directories/delete_self__done' => 'ลบไดเร็กทอรี่ที่เลือกแล้ว', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__done' => 'อัพเดทเอกสารที่ผิดพลาดโดยตั้งค่าเอง', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__done' => 'ลบประเภทประเภท MIME ที่เลือกแล้ว', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__done' => 'ลงทะเบียนประเภท MIME แล้ว', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties__done' => 'การดำเนินการเสร็จสมบูรณ์แล้ว', // PFW
    'ui__client/domain/hosting/web-directories/permissions__done' => 'อัพเดทการอนุญาตการเข้าถึงสารบบแล้ว', // PFW
    'ui__client/domain/hosting/web-directories/permissions_self__done' => 'อัพเดทการอนุญาตการเข้าถึงไดเร็กทอรี่แล้ว', // PFW
    'ui__client/domain/hosting/web-directories/php__done' => 'อัพเดทการตั้งค่า PHP สำหรับ %1 แล้ว', // PFW
    'ui__client/domain/hosting/web-directories/php_self__done' => 'อัพเดทการตั้งค่า PHP สำหรับ %1 แล้ว', // PFW
    'ui__client/domain/hosting/web-directories/properties__done' => 'อัพเดตคุณสมบัติไดเร็กทอรี่', // PFW
    'ui__client/domain/hosting/web-directories/properties_self__done' => 'อัพเดตคุณสมบัติไดเร็กทอรี่', // PFW
    'ui__client/domain/hosting/web-directories/protection__done' => 'อัพเดตการตั้งค่าการป้องกันไดเร็กทอรี่แล้ว', // PFW
    'ui__client/domain/hosting/web-directories/protection_self__done' => 'อัพเดตการตั้งค่าการป้องกันไดเร็กทอรี่แล้ว', // PFW
    'ui__client/domain/hosting/web-directories__done' => 'การดำเนินการเสร็จสมบูรณ์แล้ว', // PFW
    'ui__client/domain/hosting/web-directories_self__done' => "การดำเนินการเสร็จสมบูรณ์แล้ว", // PFW
    'ui__client/domain/mpc-certificates__done' => 'มีการรับรอง SSL/TLS อยู่ในร้านค้าออนไลน์',
    'ui__client/domain/mpc-certificates_self__done' => 'มีการรับรอง SSL/TLS อยู่ในร้านค้าออนไลน์',
    'ui__client/domain/register__done' => 'หน้า MyPlesk.com เปิดอยู่',
    'ui__client/domain/register_self__done' => 'หน้า MyPlesk.com เปิดอยู่',
    'ui__client/domain/rename__done' => 'เปลี่ยนชื่อโดเมนแล้ว',
    'ui__client/domain/rename_self__done' => "เปลี่ยนชื่อโดเมนสำเร็จแล้ว",
    'ui__client/domain/settings_self__done' => 'การดำเนินการเสร็จสมบูรณ์แล้ว',
    'ui__client/domain/toggle_disable__done' => "ระงับการใช้โดเมน %1 แล้ว",
    'ui__client/domain/toggle_enable__done' => "เปิดใช้งานโดเมน %1 แล้ว",
    'ui__client/domain/traffic__done' => 'การดำเนินการเสร็จสมบูรณ์แล้ว',
    'ui__client/domain/traffic_self__done' => 'การดำเนินการเสร็จสมบูรณ์แล้ว',
    'ui__client/domain/traffic_unknown__done' => 'การดำเนินการเสร็จสมบูรณ์แล้ว',
    'ui__client/domain-summary-report__done' => 'การดำเนินการเสร็จสมบูรณ์แล้ว',
    'ui__client/domain-summary-report_self__done' => 'การดำเนินการเสร็จสมบูรณ์แล้ว',
    'ui__client/domain-summary-report_unknown__done' => 'การดำเนินการเสร็จสมบูรณ์แล้ว',
    'ui__client/extras-domain__done' => 'หน้า MyPlesk.com เปิดอยู่',
    'ui__client/extras-domain_self__done' => 'หน้า MyPlesk.com เปิดอยู่',
    'ui__client/ipaddress/delete_multi__done' => 'การดำเนินการเสร็จสมบูรณ์แล้ว',
    'ui__client/ipaddress/properties__done' => 'การดำเนินการเสร็จสมบูรณ์แล้ว',
    'ui__client/ipaddress/properties_new__done' => 'การดำเนินการเสร็จสมบูรณ์แล้ว',
    'ui__client/ip-pool/properties__done' => "อัพเดตกลุ่ม IP ของ %1\\ ลูกค้าแล้ว",
    'ui__client/ip-pool/properties_self__done' => 'การดำเนินการเสร็จสมบูรณ์แล้ว',
    'ui__client/limits__done' => "เปลี่ยนการจำกัดทรัพยากรสำหรับลูกค้า %1",
    'ui__client/limits_self__done' => 'การดำเนินการเสร็จสมบูรณ์แล้ว',
    'ui__client/logo__done' => 'นำการตั้งค่าการสร้างแบรนด์ใหม่สำหรับลูกค้า %1 ไปใช้งาน',
    'ui__client/logo_reseller__done' => 'นำการตั้งค่าการสร้างแบรนด์บนแผงควบคุมใหม่มาใช้งาน',
    'ui__client/logo_self__done' => 'นำการตั้งค่าการสร้างแบรนด์มาใช้งาน',
    'ui__client/logo_self-reseller__done' => 'นำการตั้งค่าการสร้างแบรนด์บนแผงควบคุมมาใช้งาน',
    'ui__client/manage-domain__done' => 'หน้า MyPlesk.com เปิดอยู่',
    'ui__client/manage-domain_self__done' => 'หน้า MyPlesk.com เปิดอยู่',
    'ui__client/permissions__done' => "การอนุญาตของลูกค้า %1 ได้รับการเปลี่ยนแปลงแล้ว",
    'ui__client/permissions_self__done' => 'การดำเนินการเสร็จสมบูรณ์แล้ว',
    'ui__client/preferences__done' => "เปลี่ยนการตั้งค่าสำหรับลูกค้า %1",
    'ui__client/preferences_self__done' => "เปลี่ยนการตั้งค่าของคุณแล้ว",
    'ui__client/register-domain__done' => 'หน้า MyPlesk.com เปิดอยู่',
    'ui__client/register-domain_self__done' => 'หน้า MyPlesk.com เปิดอยู่',
    'ui__client/report/traffic-history__done' => 'การดำเนินการเสร็จสมบูรณ์แล้ว',
    'ui__client/report/traffic-history_self__done' => 'การดำเนินการเสร็จสมบูรณ์แล้ว',
    'ui__client/report__done' => 'การดำเนินการเสร็จสมบูรณ์แล้ว',
    'ui__client/report_self__done' => 'การดำเนินการเสร็จสมบูรณ์แล้ว',
    'ui__client/sessions/delete__done' => 'การดำเนินการเสร็จสมบูรณ์แล้ว',
    'ui__client/sessions/delete_self__done' => 'การดำเนินการเสร็จสมบูรณ์แล้ว',
    'ui__client/sessions__done' => 'การดำเนินการเสร็จสมบูรณ์แล้ว',
    'ui__client/sessions_self__done' => 'การดำเนินการเสร็จสมบูรณ์แล้ว',
    'ui__client/skeleton__done' => 'การดำเนินการเสร็จสมบูรณ์แล้ว',
    'ui__client/skeleton_self__done' => 'การดำเนินการเสร็จสมบูรณ์แล้ว',
    'ui__client/traffic__done' => "การดำเนินการเสร็จสมบูรณ์แล้ว",
    'ui__client/traffic_unknown__done' => 'การดำเนินการเสร็จสมบูรณ์แล้ว',
    'ui__cp-access__done' => 'การดำเนินการเสร็จสมบูรณ์แล้ว',
    'ui__cp-session/properties__done' => 'การดำเนินการเสร็จสมบูรณ์แล้ว',
    'ui__cp-session__done' => 'การดำเนินการเสร็จสมบูรณ์แล้ว',
    'ui__ftp-sessions__done' => 'การดำเนินการเสร็จสมบูรณ์แล้ว',
    'ui__license__done' => 'การดำเนินการเสร็จสมบูรณ์แล้ว',
    'ui__logo__done' => "เปลี่ยนคุณสมบัติการสร้างแบรนด์ Plesk",
    'ui__longtasks/longtask/properties__done' => "เปลี่ยนการตั้งค่างานพื้นหลังสำเร็จแล้ว",
    'ui__mass-email/delete__done' => "ลบแม่แบบข้อความ %1 แล้ว", // PFW
    'ui__mass-email/delete_multi__done' => "ลบแม่แบบข้อความแล้ว",  // PFW
    'ui__mass-email/send_main__done' => "การดำเนินการเสร็จสมบูรณ์แล้ว",  // PFW
    'ui__mass-email/send_selectclients__done' => "เลือกบัญชีลูกค้าเสร็จสมบูรณ์แล้ว",  // PFW
    'ui__mass-email/send_selectdomainusers__done' => "เลือกบัญชีผู้ดูแลระบบโดเมนเสร็จสมบูรณ์แล้ว",  // PFW
    'ui__mass-email/send_selectresellers__done' => 'เลือกบัญชีตัวแทนจำหน่ายเสร็จสมบูรณ์แล้ว',  // PFW
    'ui__mass-email/template/properties_main__done' => 'บันทึกการเปลี่ยนแปลงแม่แบบข้อความอีเมล์จำนวนมากแล้ว', // PFW
    'ui__mass-email/template/properties_new-main__done' => 'สร้างแม่แบบข้อความอีเมล์จำนวนมาก', // PFW
    'ui__mass-email/template/properties_new-selectclients__done' => 'เลือกบัญชีลูกค้าสำหรับแม่แบบข้อความอีเมล์จำนวนมากแล้ว',  // PFW
    'ui__mass-email/template/properties_new-selectdomainusers__done' => 'เลือกบัญชีผู้ดูแลระบบโดเมนสำหรับแม่แบบข้อความอีเมล์จำนวนมากแล้ว', // PFW
    'ui__mass-email/template/properties_new-selectresellers__done' => 'เลือกบัญชีตัวแทนจำหน่ายสำหรับแม่แบบข้อความอีเมล์จำนวนมากแล้ว',  // PFW
    'ui__mass-email/template/properties_unknown__done' => "เปลี่ยนแม่แบบข้อความอีเมล์จำนวนมาก",  // PFW
    'ui__mass-email/template/properties__invalid_values' => 'ค่าที่ระบุไม่ถูกต้อง', // PFW
    'ui__mass-email__done' => "การดำเนินการเสร็จสมบูรณ์แล้ว", // PFW
    'ui__mass-mail__done' => "การดำเนินการเสร็จสมบูรณ์แล้ว", // PFU
    'ui__mass-mail/delete__done' => 'ลบแม่แบบข้อความ %1 แล้ว', // PFU
    'ui__mass-mail/delete_multi__done' => 'ลบแม่แบบข้อความแล้ว', // PFU
    'ui__mass-mail/properties__done' => 'เปลี่ยนแม่แบบข้อความ %1 แล้ว', // PFU
    'ui__mass-mail/properties_new__done' => 'สร้างแม่แบบข้อความ %1 แล้ว', // PFU
    'ui__mass-mail/send__done' => 'ส่งข้อความแล้ว', // PFU
    'ui__mass-mail/send_new__done' => 'ส่งข้อความแล้ว', // PFU
    'ui__mass-mail/send_unknown__done' => 'ส่งข้อความแล้ว',  // PFU
    'ui__mass-mail/send_unknown-new__done' => 'ส่งข้อความแล้ว', // PFU
    'ui__mass-mail/template/properties_new__done' => 'สร้างแม่แบบข้อความใหม่', // PFU
    'ui__mass-mail/template/properties__done' => 'เปลี่ยนแม่แบบข้อความ', // PFU
    'ui__modules/watchdog/disk/properties__done' => 'นำการตั้งค่าการตรวจสอบดิสก์ใหม่มาใช้งาน', // PFU
    'ui__modules__done' => 'การดำเนินการเสร็จสมบูรณ์แล้ว',
    'ui__modules__short-title' => 'ส่วนขยาย',
    'ui__modules__title' => 'ส่วนขยาย',
    'ui__reseller/client/traffic_unknown__done' => 'การดำเนินการเสร็จสมบูรณ์แล้ว',
    'ui__reseller/extras-domain__done' => 'หน้า MyPlesk.com เปิดอยู่',
    'ui__reseller/extras-domain_self__done' => 'หน้า MyPlesk.com เปิดอยู่',
    'ui__reseller/ftp-sessions_self__done' => 'การดำเนินการเสร็จสมบูรณ์แล้ว',
    'ui__reseller/limits__done' => "เปลี่ยนนโยบายการจำกัดทรัพยากรและการใช้งานทรัพยากรของตัวแทนจำหน่ายแล้ว",
    'ui__reseller/limits_readonly-self__done' => 'การดำเนินการเสร็จสมบูรณ์แล้ว',
    'ui__reseller/limits_self__done' => 'เปลี่ยนนโยบายการจำกัดทรัพยากรและการใช้งานทรัพยากรของคุณแล้ว',
    'ui__reseller/manage-domain__done' => 'หน้า MyPlesk.com เปิดอยู่',
    'ui__reseller/manage-domain_self__done' => 'หน้า MyPlesk.com เปิดอยู่',
    'ui__reseller/permissions__done' => 'การอนุญาตของผู้แทนจำหน่าย %1 ได้รับการเปลี่ยนแปลงแล้ว',
    'ui__reseller/permissions_readonly-self__done' => '',
    'ui__reseller/permissions_self__done' => 'การดำเนินการเสร็จสมบูรณ์แล้ว',
    'ui__reseller/register-domain__done' => 'หน้า MyPlesk.com เปิดอยู่',
    'ui__reseller/register-domain_self__done' => 'หน้า MyPlesk.com เปิดอยู่',
    'ui__reseller/report/layout/auto/delete_multi__done' => 'ลบตารางการส่งรายงานที่เลือกแล้ว',
    'ui__reseller/report/layout/auto/properties__done' => 'อัพเดทตารางการส่งรายงานแล้ว',
    'ui__reseller/report/layout/auto/properties_new__done' => 'เพิ่มตารางการส่งรายงานแล้ว',
    'ui__reseller/report/traffic-history__done' => 'การดำเนินการเสร็จสมบูรณ์แล้ว',
    'ui__reseller/report/traffic-history_self__done' => 'การดำเนินการเสร็จสมบูรณ์แล้ว',
    'ui__reseller/report__done' => 'การดำเนินการเสร็จสมบูรณ์แล้ว',
    'ui__reseller/report_self__done' => 'การดำเนินการเสร็จสมบูรณ์แล้ว',
    'ui__reseller/sessions/delete__done' => 'การดำเนินการเสร็จสมบูรณ์แล้ว',
    'ui__reseller/sessions/delete_self__done' => 'การดำเนินการเสร็จสมบูรณ์แล้ว',
    'ui__reseller/sessions__done' => 'การดำเนินการเสร็จสมบูรณ์แล้ว',
    'ui__reseller/sessions_self__done' => 'การดำเนินการเสร็จสมบูรณ์แล้ว',
    'ui__reseller/traffic__done' => 'การดำเนินการเสร็จสมบูรณ์แล้ว',
    'ui__reseller/traffic_self__done' => 'การดำเนินการเสร็จสมบูรณ์แล้ว',
    'ui__reseller/traffic_unknown__done' => 'การดำเนินการเสร็จสมบูรณ์แล้ว',
    'ui__reseller/logo_self__title' => 'การสร้างแบรนด์ Plesk',
    'ui__reseller/logo_self__done' => 'นำการตั้งค่าการสร้างแบรนด์บน Plesk มาใช้งาน',
    'ui__server/certificate/default_multi__done' => 'การรับรอง SSL/TLS ที่เลือกได้รับการตั้งค่าให้ใช้สำหรับการเชื่อมต่อที่ปลอดภัยไปยังเว็บไซต์การโฮสต์ใหม่',
    'ui__server/certificate/delete_multi__done' => 'ลบการรับรอง SSL/TLS ที่เลือกออกแล้ว',
    'ui__server/certificate/download__done' => 'ดาวน์โหลดการรับรอง SSL/TLS แล้ว',
    'ui__server/certificate/properties__done' => 'อัพเดทคุณสมบัติการรับรอง SSL/TLS แล้ว',
    'ui__server/certificate/properties_new__done' => 'สร้างการรับรอง SSL/TLS %1 แล้ว',
    'ui__server/certificate/setup_multi__done' => 'การรับรอง SSL/TLS ที่เลือกนี้ได้รับการตั้งค่าให้ใช้สำหรับการเชื่อมต่อที่ปลอดภัยไปยัง Plesk',
    'ui__server/certificate__done' => 'การดำเนินการเสร็จสมบูรณ์แล้ว',
    'ui__server/cp-certificate-download__done' => "ดาวน์โหลดการรับรอง SSL/TLS ของ Plesk แล้ว",
    'ui__server/crontab/properties__done' => 'เปลี่ยนแปลงงานตามตารางของ %1 แล้ว',
    'ui__server/crontab/task/delete__done' => 'ลบงานแล้ว',
    'ui__server/crontab/task/delete_multi__done' => 'ลบงานตามตารางแล้ว',
    'ui__server/crontab/task/properties__done' => 'อัพเดทงานตามตาราง',
    'ui__server/crontab/task/properties_new__done' => 'กำหนดตารางให้งานใหม่แล้ว',
    'ui__server/crontab/task/toggle_disable__done' => 'ปิดการใช้งานตาราง %1 แล้ว',
    'ui__server/crontab/task/toggle_enable__done' => 'เปิดการใช้งานงานตามตาราง %1 แล้ว',
    'ui__server/crontab__done' => 'การดำเนินการเสร็จสมบูรณ์แล้ว',
    'ui__server/dns__done' => 'การดำเนินการเสร็จสมบูรณ์แล้ว',
    'ui__server/ip-address/client/delete__done' => "ลบ IP แอดเดรสออกจาก IP กลุ่มของผู้ใช้",
    'ui__server/ip-address/client/delete_multi__done' => "ลบ IP แอดเดรสออกจาก IP กลุ่มของผู้ใช้",
    'ui__server/ip-address/client/properties_new__done' => 'กำหนด IP แอดเดรสสำหรับผู้ใช้',
    'ui__server/ip-address/ip-address/add-to-clients_add-target__done' => 'กำหนด IP แอดเดรส %1 ให้กับลูกค้าที่เลือก',
    'ui__server/ip-addresses__done' => "การดำเนินการเสร็จสมบูรณ์แล้ว",
    'ui__server/mail/statistics/spam/recipients__done' => "การดำเนินการเสร็จสมบูรณ์แล้ว",
    'ui__server/mail/statistics/spam/summary__done' => "การดำเนินการเสร็จสมบูรณ์แล้ว",
    'ui__server/mail/statistics/spam__done' => "การดำเนินการเสร็จสมบูรณ์แล้ว",
    'ui__server/mail/statistics/virus/recipients__done' => "การดำเนินการเสร็จสมบูรณ์แล้ว",
    'ui__server/mail/statistics/virus/summary__done' => "การดำเนินการเสร็จสมบูรณ์แล้ว",
    'ui__server/mail/statistics/virus/viruses__done' => "การดำเนินการเสร็จสมบูรณ์แล้ว",
    'ui__server/mail/statistics/virus__done' => "การดำเนินการเสร็จสมบูรณ์แล้ว",
    'ui__server/mail/statistics__done' => "การดำเนินการเสร็จสมบูรณ์แล้ว",
    'ui__server/mail__done' => 'เปลี่ยนการตั้งค่าเซิร์ฟเวอร์เมลแล้ว',
    'ui__server/maillists__done' => 'การดำเนินการเสร็จสมบูรณ์แล้ว',
    'ui__server/mpc-certificates__done' => 'เปิดรายการหน้าร้านค้าออนไลน์ที่ได้รับการรับรอง SSL/TLS',
    'ui__server/pmm__done' => 'การดำเนินการเสร็จสมบูรณ์แล้ว',
    'ui__server/preferences__done' => "เปลี่ยนการตั้งค่าเซิร์ฟเวอร์แล้ว",
    'ui__server/register__done' => 'หน้า MyPlesk.com เปิดอยู่',
    'ui__server/services__done' => 'การดำเนินการเสร็จสมบูรณ์แล้ว',
    'ui__server/sitebuilder__done' => 'การดำเนินการเสร็จสมบูรณ์แล้ว',
    'ui__server/skeleton__done' => 'การดำเนินการเสร็จสมบูรณ์แล้ว',
    'ui__server/spam-filter/black-list/address/delete__done' => 'ลบที่อยู่ %1 จากบัญชีดำทั่วทั้งเซิร์ฟเวอร์',
    'ui__server/spam-filter/black-list/address/delete_multi__done' => 'ลบที่อยู่จากบัญชีดำทั่วทั้งเซิร์ฟเวอร์',
    'ui__server/spam-filter/black-list/address/properties_new__done' => 'เพิ่มที่อยู่เข้าไปในบัญชีดำแล้ว',
    'ui__server/spam-filter/black-list/address__done' => 'เพิ่มที่อยู่เข้าไปในบัญชีดำแล้ว',
    'ui__server/spam-filter/black-list__done' => 'การดำเนินการเสร็จสมบูรณ์แล้ว', // PFU
    'ui__server/spam-filter/properties__done' => 'เปลี่ยนการตั้งค่าตัวกรองสแปมแล้ว',
    'ui__server/spam-filter/toggle_disable__done' => 'ปิดใช้งานตัวกรองสแปมของทั่วทั้งระบบ',
    'ui__server/spam-filter/toggle_enable__done' => 'เปิดใช้งานตัวกรองสแปมของทั่วทั้งระบบ',
    'ui__server/spam-filter/white-list/address/delete__done' => 'ลบที่อยู่ %1 จากบัญชีที่ปลอดภัยทั่วทั้งเซิร์ฟเวอร์',
    'ui__server/spam-filter/white-list/address/delete_multi__done' => 'ลบที่อยู่จากบัญชีที่ปลอดภัยทั่วทั้งเซิร์ฟเวอร์',
    'ui__server/spam-filter/white-list/address/properties_new__done' => 'เพิ่มที่อยู่เข้าไปในบัญชีขาวแล้ว',
    'ui__server/spam-filter/white-list/address__done' => 'เพิ่มที่อยู่เข้าไปในบัญชีที่ปลอดภัยแล้ว',
    'ui__server/spam-filter/white-list__done' => 'การดำเนินการเสร็จสมบูรณ์แล้ว', // PFU
    'ui__server/spam-filter__done' => 'การดำเนินการเสร็จสมบูรณ์แล้ว',
    'ui__server/statistics__done' => 'การดำเนินการเสร็จสมบูรณ์แล้ว',
    'ui__server/time__done' => "เปลี่ยเวลาและวันที่ของระบบแล้ว",
    'ui__server__done' => "การดำเนินการเสร็จสมบูรณ์แล้ว",
    'ui__sessions/properties__done' => 'การดำเนินการเสร็จสมบูรณ์แล้ว',
    'ui__sessions__done' => 'การดำเนินการเสร็จสมบูรณ์แล้ว',
    'ui__sessions/delete__done' => 'ลบช่วงเวลาที่เลือกแล้ว',
    'ui__support__done' => 'เปิดแบบฟอร์มการขอความช่วยเหลือในหน้าต่างเบราเซอร์หรือแท็บใหม่',

    ///
    /// END OF DONE MESSAGES
    ///

    ///
    /// ASSORTED COMMON KEYS / TBI
    ///

    // non-UI
    '__no_files_to_upload' => 'ไม่มีไฟล์สำหรับอัพโหลด',
    'login_up__access_denied_no_permission' => "ไม่อนุญาตให้เข้าสู่ระบบ คุณไม่ได้รับการอนุญาตให้ล็อกอิน",
    'mail__unable_remove_pattern' => "ไม่สามารถลบที่อยู่จากบัญชีดำของเซิร์ฟเวอร์: %1", // PFW
    'mail__incorrect_network_format' => 'รูปแบบเครือข่ายไม่ถูกต้อง: %1', // PFW
    'initconf__unable_change_passwd' => "ไม่สามารถเปลี่ยนรหัสผ่านของผู้ดูแลระบบ: %1",
    'initconf__unable_get_passwd' => 'ไม่สามารถรับรหัสผ่านของผู้ดูแลระบบปัจจุบัน: %1 ล้มเหลว: %2',
    'initconf__invalid_hostname' => 'ความผิดพลาดชื่อโฮสต์ "%1"',
    'initconf__unable_reconfig' => 'ไม่สามารถกำหนดค่า Plesk: การกำหนดค่าใหม่ล้มเหลว: %1',
    'initconf__unable_update_admin' => 'ไม่สามารถอัพเดตข้อมูลติดต่อผู้ดูแลระบบ %1',
    '__refresh' => 'รีเฟรช',
    '__dalias_not_exist' => 'โดเมนนามแฝงไม่มีอยู่',
    '__bug146523_explanation' => 'อนุญาตให้ Plesk ในเวอร์ชันก่อนหน้าสามารถใช้ตัวอักษรเกิน 16 ตัวได้สำหรับชื่อผู้ใช้ FTP เวอร์ชั่นของ Plesk จำกัดจำนวนสูงสุดของตัวอักษรที่อนุญาตให้ใช้ในชื่อผู้ใช้ FTP ถึง 15 ตัว เพื่อแก้ปัญหานี้ต้องลดความยาวชื่อผู้ใช้ FTP ที่มากถึง 15 ตัวลงและเปลี่ยนอย่างน้อยหนึ่งตัวอักษรที่อาจกระทบต่อชื่อผู้ใช้ FTP เพื่อหลีกเลี่ยงปัญหาการซ้ำกันของชื่อผู้ใช้ เราต้องขออภัยในความไม่สะดวกใดๆ ที่อาจเกิดขึ้นจากการเปลี่ยนแปลงครั้งนี้',
    'domain__cannot_change_webmail' => 'ไม่สามารถเปลี่ยนเว็บเมลสำหรับโดเมน: %1',
    'sb_publish_disable_warning' => 'หากคุณปิดการสร้างเว็บไซต์ด้วย Presence Builder จะมีการลบการสร้างเว็บไซต์ก่อนหน้านี้ใน Presence Builder ออกและข้อมูลเว็บไซต์จะหายไป คลิกตกลงหากคุณต้องการดำเนินการต่อ',
    '__sbnet_client_use_sbnet' => "สร้างบัญชีผู้ใช้ที่สอดคล้องกันใน Presence Builder",
    'mail_resp_activate' => 'ใช้งานการตอบกลับอัตโนมัติ',
    'limitsManger__limit_available_error' => 'ไม่สามารถจัดสรรจำนวนของทรัพยากรที่ต้องการได้ ("%%limitName%%"): บัญชีของคุณสามารถใช้งานได้แต่ %%available%% เท่านั้น',
    'limitsManger__limit_reserved_error' => 'ไม่สามารถจัดสรรทรัพยากร ("%%limitName%%") ที่เหลือน้อยกว่าที่ใช้งานไปแล้วได้',
    'domain__unable_to_rename_vhost_dir_already_exists' => 'ไม่สามารถตั้งชื่อโดเมนใหม่ได้: มีไดเร็กทอรี่เสมือนจริงที่มีชื่อที่ระบุอยู่แล้ว',
    'domain_unable_to_rename' => 'ไม่สามารถตั้งชื่อโดเมนใหม่ได้',

    // Greylisting
    'spamfilter__general_settings_legend' => 'ทั่วไป',
    'spamfilter__spamassassin_status_legend' => 'ตัวกรองสแปม SpamAssassin',
    'spamfilter__spamassassin_settings_legend' => 'การตั้งค่า SpamAssassin',
    'spamfilter__spamassassin_server_status_legend' =>  "เปิดตัวกรองสแปม SpamAssassin ทั่วทั้งเซิร์ฟเวอร์",
    'spamfilter__spamassassin_user_status_legend' => 'เปิดตัวกรองสแปม SpamAssassin',
    'spamfilter__greylisting_status_legend' => 'เปิดการป้องกันสแปมเกรย์ลิสติ้งทั่วทั้งเซิร์ฟเวอร์',
    'spamfilter__personal_settings_not_allowed' => 'การตั้งค่าตัวกรองสแปมรายบุคคลที่ใช้ไม่ได้รับอนุญาตจากนโยบายระบบ',
    'spamfilter__required_score' => 'สกอร์ซึ่งข้อความต้องยอมรับคุณสมับติของการเป็นสแปม',
    'spamfilter__rewrite_header_subject' => 'เพิ่มข้อความดังต่อไปนี้ที่ส่วนต้นของหัวข้อของแต่ละข้อความที่เป็นสแปม',
    'spamfilter__use_mailuser_prefs' => 'นำการตั้งค่าของแต่ละบุคคลมาใช้กับตัวกรองสแปม',
    'spamfilter__score_error' => 'คะแนนไม่ควรจะเป็นลบ ส่วนก่อนจุดทศนิยมต้องน้อยกว่า 100 และอาจรวมแล้วไม่เกินสองหลักหลังจุดทศนิยม',
    'spamfilter__rewrite_header_error' => 'ชื่อเรื่องของข้อความประกอบด้วยตัวอักษรพิมพ์ใดก็ได้ยกเว้นเครื่องหมายเลข (#)',

    // template conflict keys
    'nonexistent_mail__mode_bounce' => 'เด้งกลับ',
    'nonexistent_mail__mode_discard' => 'ละทิ้ง',
    'nonexistent_mail__mode_catch_addr' => 'ส่งต่อไปยังอีเมลแอดเดรส',
    'nonexistent_mail__mode_catch_ip' => 'ส่งต่อไปยัง IP',
    'nonexistent_mail__bounce_not_supported' => 'ไม่รองรับโหมดเด้งกลับ',
    'nonexistent_mail__discard_not_supported' => 'ไม่รองรับโหมดละทิ้ง',
    'nonexistent_mail__catch_not_supported' => 'ไม่สนับสนุนการส่งต่อไปยังอีเมลแอดเดรส',
    'nonexistent_mail__redirect_not_supported' => 'ไม่รองรับการส่งต่อไปยัง IP',
    'nonexistent_mail__ip_used_on_this_host' => 'IP แอดเดรสกลายเป็นโลคัลโฮสต์',
    'nonexistent_mail_address_should_be_local_domain' => 'เนื่องจากมีการเปิดตัวควบคุมเมลขาออก อีเมลแอดเดรส %1 สำหรับผู้รับที่ไม่มีอยู่จริงควรอยู่ในโดเมนที่เลือกไว้ หากไม่เป็นเช่นนั้น จะนำนโยบาย "Reject" มาใช้แทนการส่งต่อ',
    'nonexistent_mail_address_should_be_local_domain_not_restricted' => 'เนื่องจากเปิดการควบคุมเมลขาออกแล้ว อีเมลแอดเดรสที่ระบุสำหรับการส่งต่อเมล (%1) ควรเป็นสมาชิกของโดเมนที่เลือกไว้ หากไม่ใช่อีเมลแอดเดรสของสมาชิก ข้อความที่ส่งไปยังที่อยู่นี้จะไม่นับว่าอยู่ในการควบคุมเมลขาออก',
    // mail acc extras
    '__antivirus' => "แอนติไวรัส",

    // web apps

    // none available
    'ui__admin-alias__none-available' => 'ไม่มีบัญชีผู้ดูแลระบบเพิ่มเติม', // PFW
    'ui__client/domain/certificate__none-available' => 'ลูกค้าไม่มีการรับรอง SSL/TLS',
    'ui__client/domain/certificate__none-available__1' => 'ลูกค้าไม่มีโดเมนที่มีการรับรอง SSL/TLS',
    'ui__client/domain/certificate__none-available__2' => 'โดเมนไม่มีการรับรอง SSL/TLS',
    'ui__reseller/client__none-available' => 'ไม่มีตัวแทนจำหน่ายของลูกค้า',

    // empty selection for lists
    'ui__client/ipaddress/delete__empty_selection' => 'คุณต้องเลือก IP แอดเดรสที่คุณต้องการลบออกจากกลุ่ม IP',
    'ui__server/ip-address/client/delete__empty_selection' => 'คุณต้องเลือกบัญชีตัวแทนจำหน่ายจากกลุ่ม IP ที่คุณต้องการเพิกถอน IP แอดเดรส',
    'ui__server/crontab/task/delete__empty_selection' => 'คุณต้องเลือกงานที่คุณต้องการยกเลิก',

    // scripting languages errors
    'phosting__aspdotnet_not_enabled' => 'ปิดตัวสนับสนุน ASP.NET สำหรับเว็บไซต์นี้',
    'phosting__php_forced_by_site_isolation' => 'ไม่สามารถเปลี่ยนการตั้งค่า PHP: ไม่ยอมรับการอนุญาตให้ยกเลิกนโยบายการรักษาความปลอดภัยของทั้งเซิร์ฟเวอร์',
    'phosting__option_forced_by_site_isolation' => 'ไม่สามารถเปลี่ยนการตั้งค่า %1 ได้:  ไม่ยอมรับการอนุญาตให้ยกเลิกนโยบายการรักษาความปลอดภัยของทั้งเซิร์ฟเวอร์',
    'phosting__php_handler_id_not_registered' => 'ตัวจัดการ PHP ไม่ได้รับอนุญาตในการตั้งค่าการแยกไซต์ นำตัวจัดการ PHP เริ่มต้นมาใช้',
    'phosting__php_served_by_nginx_is_not_available' => 'ตัวจัดการ PHP (แอพพลิเคชั่น FPM ที่บริการโดย nginx) ไม่ได้รับอนุญาตในการตั้งค่าการแยกไซต์ นำตัวจัดการ PHP เริ่มต้นมาใช้',

    // various UI
    'ui__client/ipaddress/properties_readonly__short-title' => 'ดูรายชื่อ IP แอดเดรส',
    'ui__client/ipaddress/properties_readonly__title' => 'ดูรายชื่อ IP แอดเดรส',
    'ui__client/ipaddress/properties_readonly__description' => 'ดูรายชื่อ IP แอดเดรสที่มีอยู่สำหรับผู้ใช้นี้',
    'ui__server/certificate__short-title' => 'การรับรอง SSL/TLS',
    'ui__server/certificate__title' => 'การรับรอง SSL/TLS',
    'ui__server/certificate__description' => 'ดูและจัดการการรับรอง SSL/TLS',

    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__short-title' => 'ลบประเภท MIME',
    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__title' => 'ลบประเภท MIME',
    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__description' => 'ลบประเภท MIME ที่เลือก',
    'ui__client/domain/hosting/web-directories/mime-type/properties_unknown-new__short-title' => 'เพิ่มประเภท MIME',
    'ui__client/domain/hosting/web-directories/mime-type/properties_unknown-new__title' => 'เพิ่มประเภท MIME',
    'ui__client/domain/hosting/web-directories/mime-type/properties_unknown-new__description' => 'ลงทะเบียนประเภท MIME',

    'ui__client/ipaddress/delete_multi__wizard-title' => 'ลบ IP แอดเดรส',
    'ui__client/ipaddress/delete_multi__wizard__2_multi' => 'เลือก IP แอดเดรสที่คุณต้องการลบออกจากกลุ่ม IP ของลูกค้า %1',

    // mail

    'ui__client/ipaddress__short-title' => 'ที่อยู่ IP',
    'ui__client/ipaddress__title' => 'ที่อยู่ IP',
    'ui__client/ipaddress__description' => 'ดูข้อมูลเกี่ยวกับ IP แอดเดรส',
    'ui__server/ip-address__short-title' => 'ที่อยู่ IP',
    'ui__server/ip-address__title' => 'ที่อยู่ IP',
    'ui__server/ip-address__description' => 'ดูข้อมูลเกี่ยวกับ IP แอดเดรส',
    'ui__client/domain/hosting/setup__short-title' => 'การตั้งค่าการโฮสต์เว็บ',
    'ui__client/domain/hosting/setup__title' => 'การตั้งค่าการโฮสต์เว็บ',
    'ui__client/domain/hosting/setup__description' => 'ตั้งค่าการโฮสต์เว็บสำหรับเว็บไซต์ %1',
    'ui__client/domain/hosting/web-directories/mime-type/properties__short-title' => 'ประเภท MIME', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties__title' => 'คุณสมบัติประเภท MIME', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties__description' => 'ดูคุณสมบัติของประเภท MIME', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__short-title' => 'เอกสารที่ผิดพลาด', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__title' => 'เอกสารที่ผิดพลาด', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__description' => 'คุณสมบัติของเอกสารที่ผิดพลาด', // PFW

    // tooltips

    'b_get_password_cancel' => 'ย้อนกลับไปที่หน้าจอก่อนหน้าโดยไม่ต้องส่งอีเมล',
    'b_get_password_send' => 'คลิกตกลงเพื่อส่งข้อความการเรียกคืนรหัสผ่านไปยังอีเมลแอดเดรสที่ลงทะเบียนไว้ในระบบ',



    'b_personaltrafficlist_search' => 'ป้อนรูปแบบการค้นหา และคลิกเพื่อค้นหาโดเมน',
    'b_personaltrafficlist_show_all' => 'แสดงโดเมนทั้งหมด',

    'b_back' => 'กลับไปยังหน้าก่อนหน้านี้',
    'b_next' => 'ไปยังหน้าถัดไป',

    'b_dnsnstemplatelist_remove' => 'ลบชื่อเซิร์ฟเวอร์ที่เลือก',
    'b_dnsnstemplatelist_search' => 'ระบุรูปแบบการค้นหาและคลิกเพื่อค้นหาชื่อเซิร์ฟเวอร์',
    'b_dnsnstemplatelist_show_all' => 'แสดงรายชื่อเซิร์ฟเวอร์ทั้งหมด',

    'l_dnsnstemplatelist_ns' => 'จัดเรียงรายการแม่แบบ DNS ตามชื่อเซิร์ฟเวอร์',

    // filesharing management tool
    'cu__serverfilesharing_fsLinksAsHttps' => 'สร้างลิงค์ที่ปลอดภัยไปยังไฟล์และโฟลเดอร์',
    'cu__serverfilesharing_fsPublicFolderEnabled' => 'ใช้งานไฟล์สาธารณะ',
    'cu__serverfilesharing_fsPublicFolder' => 'โฟลเดอร์สำหรับพื้นที่เก็บข้อมูลไฟล์สาธารณะ',
    'cu__serverfilesharing_fsPublicUrl' => 'URL สำหรับผู้เข้าชมในการเข้าถึงไฟล์สาธารณะ',
    'cu__serverfilesharing_fsPartnerFolderEnabled' => 'ใช้งานการป้องกันด้วยรหัสผ่านกับไฟล์สาธารณะ',
    'cu__serverfilesharing_fsPartnerFolder' => 'โฟลเดอร์สำหรับพื้นที่เก็บข้อมูลไฟล์ที่ป้องกันด้วยรหัสผ่าน',
    'cu__serverfilesharing_fsPartnersLogin' => 'ชื่อผู้ใช้ในการเข้าถึงไฟล์',
    'cu__serverfilesharing_fsPartnersPassword' => 'รหัสผ่านในการเข้าถึงไฟล์',
    'cu__serverfilesharing_fsDomain' => 'URL รูทโฟลเดอร์ของเว็บ ชื่อโดเมน',
    'cu__serverfilesharing_fsPrefix' => 'URL รูทโฟลเดอร์ของเว็บ ส่วนต้น',
    'cu__serverfilesharing_commandUpdate' => 'อัพเดตการตั้งค่าการแบ่งปันไฟล์',
    'cu__serverfilesharing_commandInfo' => 'แสดงการตั้งค่าการแบ่งปันไฟล์ในปัจจุบัน',
    'subscription_rename_is_forbidden' => 'ห้ามการเปลี่ยนชื่อการสมัครตามนโยบายของทั้งเซิร์ฟเวอร์',
    ///
    /// END OF RANDOM COMMON KEYS
    ///

    ////
    //// CRONTAB - temporary
    ////

    // wizard:

    'ui__server/crontab/task_unknown__wizard-title' => 'จัดการงานตามตารางบนเซิร์ฟเวอร์',
    'ui__server/crontab/task_unknown__wizard__2_unknown' => 'เลือกผู้ใช้ระบบที่คุณต้องการจัดการงานตามตาราง',

    'ui__server/crontab/task__short-title' => '%1',
    'ui__server/crontab/task__title' => 'งานตามตาราง %1',
    'ui__server/crontab/task__description' => 'ดูคุณสมบัติของงานตามตาราง %1',

    ///
    /// SERVER
    ///

    'ui__server/crontab_unknown__short-title' => 'ผู้ใข้ระบบ',
    'ui__server/crontab_unknown__title' => 'ผู้ใช้ระบบ',
    'ui__server/crontab_unknown__description' => 'ผู้ใช้ระบบซึ่งสามารถเป็นเจ้าของงานตามตาราง',


    'ui__server/crontab__none-available' => 'คุณไม่มีบัญชีผู้ใช้ระบบ',
    'ui__server/crontab_readonly-unknown__description' => 'ดูงานตามตาราง',
    'ui__server/crontab_readonly-unknown__short-title' => 'งานตามตาราง',
    'ui__server/crontab_readonly-unknown__title' => 'ดูงานตามตาราง',
    'ui__server/crontab_readonly-unknown__wizard-title' => 'ดูงานตามตาราง',
    'ui__server/crontab_readonly__description' => 'ดูงานตามตารางของ %1',
    'ui__server/crontab_readonly__short-title' => 'งานตามตารางของ %1',
    'ui__server/crontab_readonly__title' => 'ดูงานตามตารางของ %1',
    'ui__server/crontab_unknown__wizard-title' => 'จัดการงานตามระบบ',

    'ui__server/crontab/properties__description' => 'แก้ไขงานตามตาราง %1',

    'ui__server/crontab/properties__short-title' => 'การตั้งค่า',
    'ui__server/crontab/properties__title' => 'แก้ไขงานตามตารางของ %1',
    'ui__server/crontab/properties_readonly-unknown__description' => 'ดูงานตามตาราง',
    'ui__server/crontab/properties_readonly-unknown__short-title' => 'การตั้งค่า',
    'ui__server/crontab/properties_readonly-unknown__title' => 'ดูงานตามตาราง',
    'ui__server/crontab/properties_readonly-unknown__wizard-title' => 'ดูงานตามตาราง',
    'ui__server/crontab/properties_readonly__description' => 'ดูงานตามตารางของ %1',
    'ui__server/crontab/properties_readonly__short-title' => 'การตั้งค่า',
    'ui__server/crontab/properties_readonly__title' => 'ดูงานตามตารางของ %1',
    'ui__server/crontab/properties_unknown__description' => 'แก้ไขงานตามตาราง',
    'ui__server/crontab/properties_unknown__short-title' => 'คุณสมบัติ',
    'ui__server/crontab/properties_unknown__title' => 'แก้ไขงานตามตาราง',
    'ui__server/crontab/properties_unknown__wizard-title' => 'แก้ไขงานตามตาราง',
    'ui__server/crontab/properties_unknown__wizard__2_readonly-unknown' => 'เลือกผู้ใช้ระบบที่คุณต้องการดูงาน',
    'ui__server/crontab/properties_unknown__wizard__2_unknown' => 'เลือกผู้ใช้ระบบที่คุณต้องการเปลี่ยน',
    'ui__server/crontab/properties_unknown__wizard__3' => 'คลิกเสร็จสิ้นเพื่อนำการเปลี่ยนแปลงไปใช้และออกจากโปรแกรมช่วยติดตั้ง',
    'ui__server/crontab/properties_unknown__wizard__3_readonly' => 'คลิกเสร็จสิ้นเพื่อออกจากโปรแกรมช่วยติดตั้ง',

    'ui__server/crontab/task__none-available' => 'คุณไม่มีงานตามตาราง',
    'ui__server/crontab/task__none-available__2' => 'ผู้ใช้ระบบ %1 ไม่มีงานตามตาราง',
    'ui__server/crontab/task_readonly-unknown__description' => 'งานตามตาราง',
    'ui__server/crontab/task_readonly-unknown__short-title' => 'งาน',
    'ui__server/crontab/task_readonly-unknown__title' => 'งานตามตาราง',

    'ui__server/crontab/task/delete__description' => 'ลบงานตามตาราง %1',

    'ui__server/crontab/task/delete__short-title' => 'ลบ',
    'ui__server/crontab/task/delete__title' => 'ลบงานตามตาราง %1',
    'ui__server/crontab/task/delete_multi__description' => 'ลบงานตามตาราง',

    'ui__server/crontab/task/delete_multi__short-title' => 'ลบ',
    'ui__server/crontab/task/delete_multi__title' => 'ลบงานตามตาราง',
    'ui__server/crontab/task/delete_multi__wizard-title' => 'ลบงานตามตาราง',
    'ui__server/crontab/task/delete_multi__wizard__2_unknown' => 'เลือกผู้ใช้ระบบที่คุณต้องการลบงาน',
    'ui__server/crontab/task/delete_multi__wizard__3_multi' => 'เลือกงานที่คุณต้องการลบ',
    'ui__server/crontab/task/delete_multi__wizard__4_multi' => 'ยืนยันการลบงานโดยการเลือกช่องกาเครื่องหมาย และคลิกเสร็จสิ้นเพื่อดำเนินการโปรแกรมช่วยติดตั้งให้สมบูรณ์',
    'ui__server/crontab/task/delete_unknown__description' => 'ลบงานตามตาราง',
    'ui__server/crontab/task/delete_unknown__short-title' => 'ลบ',
    'ui__server/crontab/task/delete_unknown__title' => 'ลบงานตามตาราง',
    'ui__server/crontab/task/delete_unknown__wizard-title' => 'ลบงานตามตาราง',
    'ui__server/crontab/task/delete_unknown__wizard__2_unknown' => 'เลือกผู้ใช้ระบบที่คุณต้องการลบงาน',
    'ui__server/crontab/task/delete_unknown__wizard__3_unknown' => 'เลื่อกงานที่คุณต้องการลบ',
    'ui__server/crontab/task/delete_unknown__wizard__4' => 'ยืนยันการลบงานโดยการเลือกช่องกาเครื่องหมาย และคลิกเสร็จสิ้นเพื่อดำเนินการโปรแกรมช่วยติดตั้งให้สมบูรณ์',

    'ui__server/crontab/task/properties__description' => 'แก้ไขงานตามตาราง',

    'ui__server/crontab/task/properties__short-title' => 'แก้ไขงาน %1',
    'ui__server/crontab/task/properties__title' => 'แก้ไขงานตามตาราง',
    'ui__server/crontab/task/properties_new__description' => 'สร้างงานตามตารางเวลาสำหรับ %1',

    'ui__server/crontab/task/properties_new__short-title' => 'เพิ่มงาน',
    'ui__server/crontab/task/properties_new__title' => 'สร้างงานตามตารางเวลาสำหรับ %1',
    'ui__server/crontab/task/properties_new__wizard-title' => 'สร้างงานตามตารางเวลา',
    'ui__server/crontab/task/properties_new__wizard__2_unknown' => 'เลือกผู้ใช้ระบบที่คุณต้องการสร้างงานตามตารางให้',
    'ui__server/crontab/task/properties_new__wizard__4_new' => 'คลิกเสร็จสิ้นเพื่อนำการเปลี่ยนแปลงไปใช้และออกจากโปรแกรมช่วยติดตั้ง',
    'ui__server/crontab/task/properties_readonly-unknown__description' => 'ดูงานตามตาราง',
    'ui__server/crontab/task/properties_readonly-unknown__short-title' => 'คุณสมบัติ',
    'ui__server/crontab/task/properties_readonly-unknown__title' => 'ดูงานตามตาราง',
    'ui__server/crontab/task/properties_readonly-unknown__wizard-title' => 'ดูงานตามตาราง',
    'ui__server/crontab/task/properties_readonly__description' => 'ดูงานตามตาราง',
    'ui__server/crontab/task/properties_readonly__short-title' => 'ดูงาน %1',
    'ui__server/crontab/task/properties_readonly__title' => 'ดูงานตามตาราง',
    'ui__server/crontab/task/properties_unknown-new__description' => 'สร้างงานตามตารางเวลา',
    'ui__server/crontab/task/properties_unknown-new__short-title' => 'เพิ่มงาน',
    'ui__server/crontab/task/properties_unknown-new__title' => 'สร้างงานตามตารางเวลา',
    'ui__server/crontab/task/properties_unknown__description' => 'แก้ไขงานตามตาราง',
    'ui__server/crontab/task/properties_unknown__short-title' => 'คุณสมบัติ',
    'ui__server/crontab/task/properties_unknown__title' => 'แก้ไขงานตามตาราง',
    'ui__server/crontab/task/properties_unknown__wizard-title' => 'แก้ไขงานตามตาราง',
    'ui__server/crontab/task/properties_unknown__wizard__2_readonly-unknown' => 'เลือกผู้ใช้ระบบที่คุณต้องการดูงาน',
    'ui__server/crontab/task/properties_unknown__wizard__2_unknown' => 'เลือกผู้ใช้ระบบที่คุณต้องการเปลี่ยน',
    'ui__server/crontab/task/properties_unknown__wizard__3_readonly-unknown' => 'เลือกงานตามตาราง',
    'ui__server/crontab/task/properties_unknown__wizard__3_unknown' => 'เลือกงานตามตารางที่คุณต้องการเปลี่ยน',
    'ui__server/crontab/task/properties_unknown__wizard__4' => 'คลิกเสร็จสิ้นเพื่อนำการเปลี่ยนแปลงไปใช้และออกจากโปรแกรมช่วยติดตั้ง',
    'ui__server/crontab/task/properties_unknown__wizard__4_readonly' => 'คลิกเสร็จสิ้นเพื่อออกจากโปรแกรมช่วยติดตั้ง',

    'ui__server/crontab/task/toggle_disable__description' => 'ปิดการใช้งานตาราง %1',

    'ui__server/crontab/task/toggle_disable__short-title' => 'ปิดใช้งาน',
    'ui__server/crontab/task/toggle_disable__title' => 'ปิดการใช้งานงานตามตาราง %1',
    'ui__server/crontab/task/toggle_enable__description' => 'เปิดการใช้งานงานตามตาราง %1',

    'ui__server/crontab/task/toggle_enable__short-title' => 'เปิดการใช้งาน',
    'ui__server/crontab/task/toggle_enable__title' => 'เปิดการใช้งานงานตามตาราง %1',
    'ui__server/crontab/task/toggle_unknown__description' => 'เปิดหรือปิดการใช้งานงานตามตาราง',
    'ui__server/crontab/task/toggle_unknown__short-title' => 'เปิดหรือปิดการใช้งาน',
    'ui__server/crontab/task/toggle_unknown__title' => 'เปิดหรือปิดการใช้งานงานตามตาราง',
    'ui__server/crontab/task/toggle_unknown__wizard-title' => 'เปิดหรือปิดการใช้งานงานตามตาราง',
    'ui__server/crontab/task/toggle_unknown__wizard__2_unknown' => 'เลือกบัญชีผู้ใช้ระบบที่คุณต้องการเปิดหรือปิดงานตามตาราง',
    'ui__server/crontab/task/toggle_unknown__wizard__3_unknown' => 'เลือกงานที่คุณต้องการเปิดหรือปิดการใช้งาน',


    /// not used on HP:

    'ui__client_unknown__short-title' => 'บัญชีลูกค้า', // not used on HP?
    'ui__client_unknown__title' => 'บัญชีลูกค้า', // not used on HP?
    'ui__client_unknown__description' => 'จัดการบัญชีตัวลูกค้า', // not used on HP?
    'ui__client/domain/disable_unknown__title' => 'ระงับการใช้โดเมน', // not used on HP
    'ui__client/domain/disable_unknown__short-title' => 'ระงับการใช้โดเมน', // not used on HP,
    'ui__client/domain/disable_unknown__description' => 'ระงับการใช้โดเมน', // not used on HP
    'ui__client/domain/enable_unknown__title' => 'โดเมนที่เปิดใช้งาน', // not used on HP
    'ui__client/domain/enable_unknown__short-title' => 'โดเมนที่เปิดใช้งาน', // not used on HP
    'ui__client/domain/enable_unknown__description' => 'เปิดใช้งานโดเมน', // not used on HP

    //Additional FTP Accounts
    'ftp__management_domain' => "บัญชี FTP ในโดเมน %1", // for Additional FTP Accounts
    '__ftp_users_list' => "บัญชี FTP",
    'ftp__user_name' => "ชื่อบัญชี FTP",
    'ftp__user_home' => "สารบบหลัก",
    'ftp__invalid_path' => "พาธที่ระบุไม่ถูกต้อง",
    'i_ftp_ses_sub_user' => 'ช่วงเวลาของบัญชี FTP',
    '__new_passwd' => "รหัสผ่านใหม่ %1",

    ////
    //// Errors with custom template of Apache configuration
    ////

    'apacheConfigurationFailedMessageSubject' => 'ไม่สามารถกำหนดค่าเซิร์ฟเวอร์เว็บบนโฮสต์ <%%host%%>',
    'apacheConfigurationFailedMessageBody' => "ไม่สามารถสร้างการกำหนดค่าไฟล์เซิร์ฟเวอร์เว็บบนโฮสต์ <%%host%%>ได้เพราะข้อผิดพลาดดังต่อไปนี้:\n\n%%error%%\n\nกรุณาแก้ปัญหาข้อผิดพลาดในแม่แบบการกำหนดค่าเซิร์ฟเวอร์เว็บและสร้างไฟล์อีกครั้ง",

    'apacheConfigurationMessageAdminTitle' => 'การสร้างการกำหนดค่าเซิร์ฟเวอร์เว็บล้มเหลว',
    'apacheConfigurationMessageClientTitle' => 'คำเตือน',

    'apacheConfigurationFailedAdminHomeMessage' => 'ไม่มีการสร้างการกำหนดค่าไฟล์ใหม่เนื่องจากข้อผิดพลาดในแม่แบบการกำหนดค่า ส่งข้อความรายละเอียดข้อผิดพลาดไปยังอีเมลของคุณแล้ว กรุณาตรวจสอบอีเมล แก้ข้อผิดพลาด และคลิก %1 เพื่อลองสร้างการกำหนดค่าใหม่อีกครั้ง',
    'apacheConfigurationFailedAdminHomeMessageLink' => 'ที่นี่', //used on linked text in apacheConfigurationFailedAdminHomeMessage
    'apacheConfigurationFailedAdminDomainMessage' =>  'ไม่มีการสร้างการกำหนดค่าใหม่ของโดเมน %1 เนื่องจากข้อผิดพลาดในแม่แบบการกำหนดค่า ส่งข้อความรายละเอียดข้อผิดพลาดไปยังอีเมลของคุณแล้ว กรุณาตรวจสอบอีเมล แก้ข้อผิดพลาด และคลิก %2 เพื่อลองสร้างการกำหนดค่าใหม่อีกครั้ง',
    'apacheConfigurationFailedAdminDomainMessageLink' => 'ที่นี่', //used on linked text in apacheConfigurationFailedAdminDomainMessage

    'apacheConfigurationFailedUserDomainMessage' => 'การกำหนดค่าเซิร์ฟเวอร์เว็บสำหรับโดเมน %1 อาจไม่สอดคล้องกัน กรุณาติดต่อกับผู้ดูแลระบบเซิร์ฟเวอร์เพื่อแก้ไขปัญหา',

    'apacheConfigurationFailedAdminDomainsMessage' => 'ไม่มีการสร้างการกำหนดค่าใหม่ของโดเมนบางอันเนื่องจากข้อผิดพลาดในแม่แบบการกำหนดค่า ส่งข้อความรายละเอียดข้อผิดพลาดไปยังอีเมลของคุณแล้ว กรุณาตรวจสอบอีเมล แก้ข้อผิดพลาด และคลิก %1 เพื่อลองสร้างการกำหนดค่าใหม่อีกครั้ง',
    'apacheConfigurationFailedAdminDomainsMessageLink' => 'ที่นี่', //used on linked text in apacheConfigurationFailedAdminDomainsMessage

    'apacheConfigurationFailedUserDomainsMessage' => 'การปรับตั้งค่าเซิร์ฟเวอร์เว็บสำหรับบางส่วนของโดเมนของคุณอาจทำให้เกิดความไม่สอดคล้อง โปรดติดต่อผู้ดูแลระบบเซิร์ฟเวอร์เพื่อแก้ไขปัญหานี้',



    ///HOSTING PARAMETERS
    '__apache_errdocs' => "เอกสารข้อผิดพลาดที่กำหนดเอง",
    'dom_pref__webusers_script' => "อนุญาตให้ผู้ใช้เว็บใช้สคริปส์ได้",
    '__seoRedirect' => 'กำหนดค่าโดเมนที่ต้องการเป็น',
    '__seoRedirectToLanding' => 'domain.tld',
    '__seoRedirectToWww' => 'www.domain.tld',
    '__seoRedirectNone' => 'ไม่มี',

    '__sites' => 'โดเมน',
    'domain_plan__perm_denied_manage_phosting' => 'คุณไม่ได้รับอนุญาตให้จัดการกับการตั้งค่าการโฮสต์',
    '__owned_by_client' => 'เป็นเจ้าของโดยลูกค้า',
    'ui__client/permissions_readonly__description' => "ดูการกระทำที่ลูกค้า %1 สามารถดำเนินการใน Plesk ได้",
    'backup__restore__object_client_template' => 'แม่แบบลูกค้า',
    '__template_name' => 'ชื่อแผนบริการ',
    'template__not_exists' => 'ไม่มีแผนบริการดังกล่าว',
    'template__exists' => 'มีแผนที่มีชื่อ name %1 อยู่แล้ว',
    'clientOwnerChanger__ip_not_in_pool' => 'IP แอดเดรสที่ระบุไม่อยู่ในกลุ่มตัวแทนจำหน่าย',

    //// Change owner of subscription
    'chown__select_title' => "เลือกผู้สมัครรายใหม่",
    'ui__client/domain/chowner_multi__wizard__3_multi-select' => 'เลือกเจ้าของใหม่สำหรับการสมัครที่เลือกและคลิกต่อไป>>.',
    'domains__client_info' => "%1 การสมัครใช้บริการ %2 การสมัครใช้บริการที่ใช้งาน %3 พื้นที่ดิสก์ที่ใช้ %4 การรับส่งข้อมูลที่ใช้",
    '__possible_owners' => 'อาจมีเจ้าของใหม่ของการสมัคร',

    'clients_list__filter_owner__filter_title' => 'ผู้ให้บริการ',
    'clients_list__filter_owner_any' => 'ผู้ใช้ทั้งหมด',
    'clients_list__filter_owner_my' => 'ผู้สมัครของฉันเท่านั้น',
    'clients_list__filter_owner_name__filter_title' => 'ชื่อผู้ให้บริการ',

    '__owner' => "ผู้ให้บริการ",
    'l_clientslist_owner' => 'จัดเรียงบัญชีผู้ใช้ตามผู้ให้บริการ',
    'l_clientslist_date' => 'จัดเรียงบัญชีผู้ใช้ตามวันที่สร้าง',
    'l_clientslist_name' => 'จัดเรียงบัญชีผู้ใช้ตามชื่อ',
    'l_clientslist_domains' => 'จัดเรียงบัญชีผู้ใช้ตามโดเมน',
    'l_clientslist_cname' => 'จัดเรียงบัญชีผู้ใช้ตามชื่อบริษัท',

    'ui__client/domain/chowner_multi__wizard-title' => 'กำหนดการสมัครที่เลือกใหม่',
    'chown__check_title' => 'เปลี่ยนสมาชิก',

    'ui__client/domain/chowner_multi__wizard__3_multi' => "คลิกเสร็จสิ้นเพื่อกำหนดใหม่ให้เสร็จสมบูรณ์ เมื่อเสร็จแล้ว การกำหนดการสมัครที่เลือกไปยังเจ้าของใหม่ จะมีการเปลี่ยนผู้ให้บริการไปเป็นผู้ให้บริการของเจ้าของรายใหม่ และการสมัครจะไม่อยู่ในแผนบริการและเปลี่ยนเป็น 'กำหนดเอง' แทน",

    'chown__error_check' => 'เกิดปัญหาบางอย่างขึ้นในขณะที่พยายามจะมอบหมายการสมัครใช้บริการให้แก่เจ้าของรายใหม่',
    'domain_chown_subscription_will_be_anonymous' => "การสมัครใช้บริการไม่อยู่ในแผนการบริการปัจจุบันและกลายเป็น 'กำหนดเอง'",
    'chown__error_domains_exclude' => "เกิดปัญหาบางอย่างขึ้นในขณะที่พยายามจะมอบหมายการสมัครใช้บริการให้แก่เจ้าของรายใหม่ ไฮไลต์การสมัครใช้บริการเหล่านี้",
    'chown__ip_not_in_client_pool' => "ไม่มีการเพิ่ม IP แอดเดรสที่สอดคล้องกับการสมัครไปยังกลุ่ม IP ของเจ้าของรายใหม่",
    'chown__already_owned_by_client' => "การสมัครเป็นของผู้ใช้รายนี้แล้ว",

    '__redirect_hint' => 'จะเปลี่ยนเส้นทางคุณไปยังที่อยู่ใหม่ใน 15 วินาที... หากไม่มีการนำคุณไปยังตำแหน่งใหม่โดยอัตโนมัติ กรุณาใช้งาน Javascript หรือคลิกที่ไฮเปอร์ลิงค์ %%link%%',

    'backup__restore__object_maillist' => 'รายการจดหมาย',
    'backup__restore__object_site' => 'ไซต์',
    'backup__restore__object_user' => 'ผู้ใช้',
    'backup__restore__object_role' => 'บทบาท',

    'limit__name_max_site' => 'ไซต์',

    'iis_pool__unable_rename_client' => "ไม่สามารถเปลี่ยนชื่อกลุ่มแอพพลิเคชั่น IIS: %1.",

    'anonftp__is_not_supported_for_addon_domains' => 'รองรับการใช้งานบริการ FTP นิรนามในโดเมนหลักของการสมัครใช้บริการเท่านั้น',
    'anonftp__is_not_supported_for_addon_domains_powerUser' => 'รองรับการใช้งานบริการ FTP นิรนามในโดเมนหลักของการสมัครใช้บริการเท่านั้น',

    '__gb' => 'GB',
    '__tb' => 'TB',
    '__gb_month' => 'GB/เดือน',
    '__tb_month' => 'TB/เดือน',

    '__customers' => 'ลูกค้า',
    '__customer_name' => 'ชื่อลูกค้า',
    '__customer_total' => 'ลูกค้าทั้งหมด',
    '__site' => 'ไซต์',
    '__def_site' => 'เว็บไซต์เริ่มต้น',
    '__subscription_name' => 'ชื่อการสมัคร',
    '__subscription_name_powerUser' => 'ชื่อการสมัครใช้บริการ',

    'limit__units_max_traffic_suffix' => '/เดือน',

    'dom_pref__discard' => "ปฏิเสธ",

    'mail__pattern_already_exists' => 'มีรูปแบบ "%1" อยู่ในบัญชีดำแล้ว',

    '__not_supported' => 'ไม่สนับสนุน',

    'plesk_key__sitebuilder' => 'ไซต์ที่ประกาศด้วย Presence Builder',
    'limit__name_max_site_builder' => 'ไซต์ที่ประกาศด้วย Presence Builder',
    'plesk_key__wpb-multi-language-sites-support' => 'การสนับสนุนสำหรับไซต์การใช้งานหลายภาษาใน Presence Builder',

    'ui__client/domain/traffic-hosting__title' => 'สถิติการส่งต่อข้อมูลสำหรับ <b>%1</b>',
    'ui__client/domain/traffic-hosting__title_powerUser' => 'สถิติการส่งต่อข้อมูลสำหรับ <b>%1</b>',
    'ui__client/domain/traffic-hosting#list__title' => "ส่งต่อข้อมูลผ่านการบริการ",

    'login_up__access_denied_no_subscriptions' => "ไม่อนุญาตให้เข้าสู่ระบบ ไม่มีการสมัครสำหรับบัญชีนี้",

    'interval__day' => '%1 วัน',
    'interval__hour' => '%1 ชั่วโมง',
    'interval__minute' => '%1 นาที',
    'interval__second' => '%1 วินาที',

    ///License options
    'plesk_key__backward_incompatibility' => 'คุณกำลังพยายามใช้ลิขสิทธิ์ที่สร้างขึ้นมาเพื่อ Plesk เวอร์ชั่นอื่น ติดต่อตัวแทนจำหน่าย Plesk เพื่อขอรับรหัสลิขสิทธิ์ที่ถูกต้อง',
    //Standalone or virtualization
    'virtualization_any' => "เซิร์ฟเวอร์โครงร่างหรือการแก้ปัญหาแบบเสมือน",
    'virtualization_pvc' => "Virtuozzo Containers",
    'virtualization_vmware' => "VMWare",
    'virtualization_hyperv' => "Microsoft Hyper-V",
    'virtualization_xen' => "Xen",
    'virtualization_kvm' => "KVM",
    'virtualization_parallels_server' => "Virtuozzo Server",
    'plesk_key__virtualization' => "ทำให้ถูกต้องสำหรับสภาพแวดล้อมต่อไปนี้:",
    'plesk_key__virtualization_only_key' => 'รหัสลิขสิทธิ์มีวัตถุประสงค์เพื่อใช้กับการดำเนินงาน Plesk ภายในสภาพแวดล้อมเสมือน %1 เท่านั้น',
    'plesk_key__virtualizations_only_key' => 'รหัสลิขสิทธิ์มีวัตถุประสงค์เพื่อใช้กับการดำเนินงาน Plesk ภายในสภาพแวดล้อมเสมือนดังต่อไปนี้เท่านั้น: %1.',
    //Language options
    'plesk_key__invalid_locale_signature' => 'ห้ามการใช้แพ็คภาษาแบบกำหนดเอง',
    'plesk_key__allowed-locales' => 'ภาษาที่มี',
    'plesk_key__allowed-locales-any' => 'ภาษาใดก็ได้',

    /// Web hosting settings on domain/subdomain

    '__cgi_bin_mode' => 'ไดเร็กทอรี่ cgi-bin ติดตั้งอยู่ที่',
    '_cgi_bin_mode_webspace' => 'รูทไดเร็กทอรี่ของการสมัครใช้บริการ',
    '_cgi_bin_mode_www_root' => 'รูทเอกสารของโดเมน',

    /// Custom buttons
    'custom_button__sort_key' => 'ความสำคัญ',
    'custom_button__place' => 'ที่ตั้ง',
    'custom_button__place_navigation' => 'การเข้าถึงทั่วไป',
    'custom_button__place_admin' => 'หน้าหลักของผู้ดูแลระบบ',
    'custom_button__place_admin-settings' => 'เครื่องมือของผู้ดูแลระบบ & หน้าการตั้งค่า',
    'custom_button__place_reseller' => "หน้าหลักของตัวแทนจำหน่าย",
    'custom_button__place_reseller-settings' => 'เครื่องมือของตัวแทนจำหน่าย & หน้ายูทิลิตี้',
    'custom_button__place_client' => 'หน้าหลักของลูกค้า',
    'custom_button__place_domain' => "หน้าโดเมนและเว็บไซต์ของการสมัครใช้บริการ",
    'custom_button__place_domain_powerUser' => "หน้าโดเมนและเว็บไซต์ของการสมัครใช้บริการ",
    'custom_button__place_domain-properties' => 'เครื่องมือของเว็บไซต์',
    'custom_button__private' => 'แสดงให้ฉันเห็นเท่านั้น',
    'custom_button__image' => 'รูปพื้นหลัง',
    'custom_button__conhelp' => "ข้อความแนะนำ",
    'custom_button__edit' => "การตั้งค่าของลิงค์ไปที่บริการเพิ่มเติม",
    'custom_button__include_client_cname' => "รวมถึงชื่อบริษัทของลูกค้า",
    'custom_button__include_client_email' => "รวมถึงอีเมลของลูกค้า",
    'custom_button__include_client_id' => "รวมถึง ID ของลูกค้า",
    'custom_button__include_client_pname' => "รวมถึงชื่อผู้ติดต่อของลูกค้า",
    'custom_button__include_domain_id' => "รวมถึง ID การสมัครใช้บริการ ID โดเมนและ ID นามแฝง",
    'custom_button__include_domain_id_powerUser' => "รวมถึง ID การสมัครใช้บริการ ID โดเมนและ ID นามแฝง",

    'custom_button__include_domain_name' => "รวมถึงชื่อโดเมนหลัก",
    'custom_button__include_ftp_user' => "รวมชื่อผู้ใช้ FTP",
    'custom_button__include_ftp_pass' => "รวมถึงรหัสผ่าน FTP",
    'custom_button__internal_open' => "เปิด URL ใน Plesk",
    'custom_button__text' => "ป้ายปุ่ม",
    'custom_button__url' => "URL",

    'custom_button__not_image' => 'ไฟล์นี้ไม่ใช่ไฟล์ภาพ',
    'custom_button__big_image' => 'ขนาดไฟล์ต้องไม่เกิน 100 KB',
    'custom_button__failed_copy_image' => 'ไม่สามารถคัดลอกไฟล์ได้: %1',


    'backup__restore__cannot_restore_non_power_user_dump_in_power_user_mode' => 'ไม่สามารถกู้คืนการสำรองข้อมูลผู้ใช้ที่ไม่อยู่ในขั้นสูงในมุมมองผู้ใช้ขั้นสูงได้',
    '__unknown_network_interface' => 'อินเตอร์เฟสเครือข่ายที่ไม่รู้จัก',

    'init_conf__ip_address' => 'ที่อยู่ IP',

    //Confirmation page
    'bt_confirm' => 'ยืนยัน',
    'b_confirm' => 'ยืนยันความเป็นเจ้าของไซต์ของคุณ',

    'performance__iss_app_pool_forced_by_site_isolation' => 'การตั้งค่าของแอพลิเคชัน IIS เฉพาะตั้งค่าตามนโยบายด้านความปลอดภัยของทั้งเซิร์ฟเวอร์ (การกำหนดค่าการแยกไซต์)',
    'performance__iss_app_pool_forced_by_server_wide_settings' => 'การตั้งค่าของแอพลิเคชัน IIS เฉพาะตั้งค่าตามการตั้งค่าประสิทธิภาพการทำงานทั้งเซิร์ฟเวอร์',

    '__current' => 'ปัจจุบัน',
    'ui__client/domain/hosting/web-directories/protection/user/properties__done' => 'อัพเดตคุณสมบัติผู้ใช้',



    //// New Promos Block

    'promo__you_are_about_to_exceed_license_limit_max_dom' => 'คุณใช้โดเมนทั้งหมดที่จัดไว้ให้ตามลิขสิทธิ์ Plesk เกือบเต็มจำนวนแล้ว (90% หรือมากกว่า)',
    'promo__you_are_about_to_exceed_license_limit_max_dom_title' => 'คุณใช้โดเมนทั้งหมดเกือบเต็มจำนวนแล้ว',
    'promo__you_are_about_to_exceed_license_limit_max_site_builder' => 'คุณใช้ไซต์ Presence Builder ทั้งหมดที่จัดไว้ให้ตามลิขสิทธิ์ Plesk เกือบเต็มจำนวนแล้ว (90% หรือมากกว่า)',
    'promo__you_are_about_to_exceed_license_limit_max_site_builder_title' => 'คุณใช้ไซต์ Presence Builder ทั้งหมดเกือบเต็มจำนวนแล้ว',
    'promo__button_hide' => 'ซ่อน',
    'promo__button_next' => 'ถัดไป>>',
    'promo__button_prev' => '<< ก่อนหน้า',
    'promo__button_license' => 'อัพเดตใบอนุญาต',

    'promo__google_integration_title' => 'การทำงานร่วมกับบริการของ Google',
    'promo__google_integration' => 'การกำหนดค่าการทำงานร่วมกับบริการของ Google เช่น AdSense, Google Apps, เครื่องมือ Webmaster',
    'promo__google_integration_button' => 'ปรับตั้งค่า',

    'promo__button_learn_more' => 'เรียนรู้เพิ่มเติม',

    //// Plesk Branding in 10.1
    'panel_branding__description' => 'คุณสามารถกำหนดลักษณะและการตั้งค่าการสร้างแบรนด์ได้โดยวิธีการกำหนดธีมด้วยตนเอง สำหรับคำแนะนำในการกำหนดธีม Plesk ดูข้อมูลได้ที่ %1',
    'panel_branding__description_link' => 'เอกสารต่อไปนี้',

    ///// File Manager new buttons
    'bt_extract_archive' => 'ตัดทอนไฟล์',
    'b_filemanager__extract' => 'ตัดทอนไฟล์จากที่จัดเก็บที่เลือกเข้าไปยังไดเร็กทอรี่ในปัจจุบัน โปรดทราบว่าอาจมีการแสดงชื่อไฟล์ไม่ถูกต้องหลังจากการตัดทอนหากในชื่อมีเอกลักษณ์ประจำชาติ',
    'filemanager_error_extracting_files' => 'เกิดความผิดพลาดในขณะที่ทำการตัดทอนไฟล์ที่จัดเก็บ: %1',
    'filemanager_no_archive_files_specified' => 'ระบุที่จัดเก็บที่คุณต้องการตัดทอน',
    'filemanager_not_zip_archive_specified' => 'ไม่สามารถตัดทอน %1 ได้เพราะไม่ใช่ที่จัดเก็บแบบ ZIP',
    'filemanager_files_successfully_extracted' => 'ตัดทอนไฟล์ที่จัดเก็บแล้ว',
    'filemanager_error_file_download' => 'การดาวน์โหลดไฟล์ล้มเหลว: %1',
    'filemanager__user_poolgrp' => 'กลุ่มของกลุ่มการใช้งานแอพพลิเคชั่น',

    'loading' => 'กำลังโหลด...',
    'bt_create_archive' => 'เพิ่มการจัดเก็บ',
    'filemanager__pack' => "พาธไปยังที่จัดเก็บ: %1",
    'filemanager__archive_name' => 'ที่จัดเก็บชื่อไฟล์',
    'filemanager__empty_filename' => 'กรุณาป้อนชื่อไฟล์ที่จัดเก็บ',
    'filemanager_archive_created' => 'สร้างที่จัดเก็บสำเร็จแล้ว',
    'filemanager_error_creating_archive' => 'ไม่สามารถสร้างที่จัดเก็บ: %1',

    'cmd_dns__aaaa_dns_record_already_exist' => "บันทึกนี้ขัดกับบันทึก AAAA สำหรับโซน",
    'defaultcomponents__ftp_ipv6_hosting_not_supported' => "(เซิร์ฟเวอร์ FTP ไม่สนับสนุน IPv6 แอดเดรส)",
    'cmd_dns__glue_dns_record_conflict' => 'บันทึกนี้ขัดกับกลูเร็คคอร์ดของโซน \'%1\'',
    '__ftp_ipv6_not_supported' => "(เซิร์ฟเวอร์ FTP ไม่สนับสนุน IPv6 แอดเดรส)",
    '__ipv6_not_supported' => 'ไม่สนับสนุน IPv6',
    'mail__ipv6_not_supported' => 'IPv6 ไม่ได้รับการสนับสนุนโดยเซิร์ฟเวอร์เมล',
    'mail__relay_while_list_ipv6_not_supported' => 'การถ่ายทอดบัญชีที่ปลอดภัย IPv6 ไม่ได้รับการสนับสนุนโดยเซิร์ฟเวอร์เมล',
    'mail__relay_while_list_ipv6_mask_mul_16' => 'ค่ามาสก์ต้องเป็นผลคูณของ 16',
    'mail__ip_or_mask_is_invalid' => 'IP แอดเดรสหรือมาสก์ไม่ถูกต้อง',
    'nonexistent_mail__redirect_ipv6_not_supported' => 'ไม่สนับสนุนการส่งต่อไปยัง IPv6 IP แอดเดรส',
    'sa__invalid_trusted_networks' => 'เครือข่ายที่เชื่อถือได้ที่ระบุมาไม่ถูกต้อง: %1',
    'dns_add__enter_ipv6_address' => "ที่อยู่ IPv6",
    'license_trial_days_left' => 'Plesk ของคุณดำเนินการด้วยลิขสิทธิ์การทดลองใช้งานที่จะหมดอายุใน %1 วัน',
    'excl_ipv6_num' => 'IPv6 แอดเดรสเฉพาะ',
    '__ip_mask' => "ซับเน็ท",
    '__ipv4_addr' => 'IPv4 แอดเดรส',
    '__ipv6_addr' => 'ที่อยู่ IPv6',
    'template__num_excl_ipv6s' => 'จัดสรรที่อยู่ IPv6 เฉพาะให้กับตัวแทนจำหน่าย',
    'anonftp__exclusive_ipv4_required' => 'จำเป็นต้องใช้ IPv4 แอดเดรสเฉพาะเพื่อตั้งค่าและใช้บริการ FTP นิรนาม',
    'anonftp__ipv4_already_used' => 'คุณไม่สามารถตั้งค่าบริการ FTP นิรนามสำหรับไซต์นี้ได้เพราะมีการกำหนดค่าบนโดเมนอื่นด้วย IPv4 แอดเดรสเดียวกันแล้ว',


    'restart__kav' => "โปรแกรมป้องกันไวรัส Kaspersky",
    '__view_migration_log_detailed_info' => 'ดูบันทึก',

    'chown__ip_address_warn' => 'ก่อนที่จะทำการย้ายการสมัครไปยังเจ้าของรายใหม่คุณต้องเลือก IP แอดเดรสใหม่สำหรับการสมัครใช้บริการ',
    'chown__no_ip_address' => 'ไม่มี',
    'chown__no_ipv4_address' => 'ไม่มี IPv4 แอดเดรส',
    'chown__no_ipv6_address' => 'ไม่มี IPv6 แอดเดรส',
    'chown__domain_exclude_already_owned_by_client' => 'การสมัคร %1 เป็นของผู้ใช้รายนั้นแล้ว',
    'chown__error_ip_absent_in_ip_pool' => 'ไม่มีการแสดง IP แอดเดรส %1 ในกลุ่ม IP ของผู้ใช้เป้าหมาย',
    'chown__error_ip_not_exist' => 'ไม่มี IP แอดเดรสที่มี ID \'%1\' อยู่',
    'chown__error_domain_ip_not_selected' => 'ควรเลือกอย่างน้อยหนึ่ง IP แอดเดรสสำหรับโดเมน %1 ตรวจสอบค่าที่เลือกสำหรับการแม็พปิ้ง IP',

    '__new_passwd_single' => "รหัสผ่าน",
    '__confirm_passwd_single' => "ยืนยันรหัสผ่าน",

    'mail__ip_or_mask_is_invalid_ipv6' => 'IPv6 แอดเดรสหรือมาสก์ไม่ถูกต้อง: IP แอดเดรสควรจะเป็นที่อยู่แบบผู้รับเดี่ยวที่ถูกต้อง',

    '__subscriptions' => 'การสมัคร',

    '__owned_by_reseller' => 'เป็นเจ้าของโดยตัวแทนจำหน่าย',
    '__owned_by_provider' => 'เป็นเจ้าของโดยผู้ให้บริการ',

    'service_plan__anonymous' => 'กำหนดเอง',
    'subscription_not_locked__change_limits_warning' => 'ไม่มีการล็อคการสมัครใช้บริการ: การจำกัดการใช้งานทรัพยากรจะเปลี่ยนแปลงไประหว่างการปรับข้อมูลตามแผนบริการ',
    'subscription_not_locked__change_permissions_warning' => 'ไม่มีการล็อคการสมัครใช้บริการ: การอนุญาตจะเปลี่ยนแปลงไประหว่างการปรับข้อมูลตามแผนบริการ',

    'subscription__conflict_resolution_policy' => 'นโยบายการแก้ไขความขัดแย้ง',
    'subscription__conflict_resolution_policy_lock' => "ล็อคการสมัคร",

    'backup__list__backup_warnings' => 'คำเตือน',
    'backup__list__backup_info' => 'ข้อมูล',
    'backup__restore__object_reseller_template' => 'แม่แบบตัวแทนจำหน่าย',
    'backup__restore__object_domain_template' => 'แม่แบบโดเมน',

    'ui__client/permissions_readonly__title' => 'การอนุญาต',
    'ui__client/permissions_readonly__short-title' => 'การอนุญาต',

    'subscription__unable_lock_anonymous' => 'การสมัครนี้ไม่เชื่อมโยงกับแผนบริการดังนั้นจึงไม่สามารถปลดล็อคได้',
    'subscription__unable_sync_anonymous' => 'การสมัครนี้ไม่เชื่อมโยงกับแผนบริการดังนั้นจึงไม่สามารถปรับข้อมูลได้',
    'subscription__unable_sync_locked' => 'ล็อคการสมัครนี้แล้วดังนั้นจึงไม่สามารถปรับข้อมูลได้',
    'subscription__locked' => 'ล็อคการสมัครแล้ว',
    'component_name__urlrewrite' => "ตัวเขียนซ้ำ URL",
    '__quantity' => 'ปริมาณ',
    'hst__www_root_dir_absent' =>  'คำเตือน: ไม่มีไดเรกทอรีที่ระบุว่าเป็นรูทเอกสารอยู่',
    'object_creation__domain_is_not_a_webspace' => 'สามารถสร้างออบเจ็กต์นี้ได้ในการสมัครใช้บริการเท่านั้น',
    'phosting__webspace_hosting_with_sites_cannot_be_deleted' => 'การสมัครใช้บริการประกอบด้วยไซต์ ดังนั้นคุณไม่สามารถเปลี่ยนหรือลบชนิดการโฮสติ้งได้',
    'phosting__addon_domain_ip_must_match_webspace' => 'ข้อผิดพลาด: ไม่สามารถอัพเดต IP แอดเดรส โดเมน Addon ไม่สามารถกำหนด IP แอดเดรสให้กับโดเมนหลักของระบบสมัครสมาชิกได้',
    'domain_plan__unable_change' => 'ไม่สามารถเปลี่ยนแผนการบริการได้: %1.',
    'domain_plan__different_hosting_type' => 'ประเภทในการโฮสต์ปัจจุบันแตกต่างจากประเภทที่ระบุในแผนการบริการ',
    'domain_plan__addon_text' => 'แผนการเสริม',
    'domain_plan__addon_description' => 'ใช้แผนการเพิ่มเติมเพื่อเสริมแผนการจัดการโฮสต์',
    'asp_net__managed_runtime_version' => 'ASP.NET จัดการเวอร์ชั่นเฉพาะใช้งาน',
    'plan__can_not_change_hosting_type' => 'ไม่สามารถเปลี่ยนประเภทการโฮสต์ได้เมื่อมีการแก้ไขแผน',
    'plan__apply_problems' => 'ไม่สามารถใช้แผนได้เนื่องจากปัญหาด้านการทำงานดังต่อไปนี้: %1',
    'plan_save__subscription_update_problem' => 'ไม่สามารถใช้การเปลี่ยนแปลงแผน %1 ได้',
    '__perm_denied_subscription_suspended_by_backuprestore' => "มีการระงับการสมัครใช้บริการชั่วคราวจนกว่ากระบวนการในการสำรองข้อมูลหรือการเรียกคืนจะเสร็จสมบูรณ์ กรุณากลับมาภายหลัง",
    '__login_incorrect_plain_shadow_password' => 'คุณระบุรหัสผ่านไม่ถูกต้องไปยังบัญชีของผู้ดูแลระบบ กรุณาใช้ข้อมูลประจำตัวของผู้ดูแลระบบ (รูท) หรือขอรับรหัสผ่านที่ถูกต้อง เพื่อเรียนรู้เพิ่มเติมเกี่ยวกับการขอรับรหัสผ่าน กรุณาอ่านที่ไฟล์ /etc/psa/README.psa.shadow',

    '__perm_denied_ip' => 'คุณไม่สามารถส่งที่อยู่ IP ที่คุณไม่ได้เป็นเจ้าของ',

    'dns__dns_zone_not_synchronized' => 'ปรับแก้โซน DNS แล้ว หากคุณต้องการใช้งานการเปลี่ยนแปลงแม่แบบ DNS ไปยังโซนนี้ให้คลิกที่ปุ่ม \'ใช้การเปลี่ยนแปลงแม่แบบ DNS\' บนหน้านี้ หรือเลือก \'ใช้การเปลี่ยนแปลงกับทุกส่วน\' ในแผงการจัดการเซิต์ฟเวอร์ > เครื่องมือและการตั้งค่า >การตั้งค่าแม่แบบ DNS> ใช้การเปลี่ยนแปลงแม่แบบ DNS',
    'dns__dns_zone_synchronize_link' => 'คลิก',
    'dns__dns_zone_synchronize_done' => 'ซิงค์ DNS โซนสำเร็จแล้ว',

    'dns__dns_zone_template_error' => 'มีปัญหาในขณะที่ซิงก์โซน DNS เข้ากับแม่แบบโซน DNS %1',

    'dns__soa_rname_type_owner' => 'ที่อยู่อีเมลของเจ้าของเว็บไซต์',
    'dns__soa_rname_type_domain' => 'ที่อยู่อีเมลโดเมน',
    'dns__soa_rname_type_external' => 'ที่อยู่อีเมลภายนอก',
    'dns__soa_rname_enforce_email' => 'ไม่อนุญาตให้เปลี่ยนที่อยู่อีเมล RNAME บนพื้นฐานโดเมนแต่ละอัน',
    'dns__soa_rname_label' => 'อีเมล (RNAME)',
    'dns__soa_rname_hint' => 'ที่อยู่อีเมลของบุคคลที่รับผิดชอบโซน DNS ของโดเมน ส่งคืนโดยเซิร์ฟเวอร์ DNS เพื่อตอบสนองต่อการค้นหา SOA',

    'dns__dns_zone_soa_sync_title' => 'การแทนที่การตั้งค่า SOA สำหรับโดเมนที่มีอยู่ทั้งหมด',
    'dns__dns_zone_soa_sync_legend' => 'จำเป็นต้องใช้การยืนยัน',
    'dns__dns_zone_soa_sync_text' => 'อัปเดตบันทึก SOA ของโดเมนที่โฮสต์ทั้งหมดโดยใช้การเปลี่ยนแปลงที่ดำเนินการกับแม่แบบ SOA หรือไม่',

    'cu_db__repair_mysql_dbus' => "ซ่อมแซมรหัสผ่านผู้ใช้ MySQL หากคุณอัพเกรดเป็น Plesk 11 จากเวอร์ชั่นก่อนหน้าการดำเนินการนี้มีความจำเป็นมาก",

    'cu_scheduled_backup_comment' => 'การสำรองข้อมูลที่จัดกำหนดเวลาไว้',
    'cu_scheduled_backup_error' => 'เกิดข้อผิดพลาดขึ้นในระหว่างกระบวนการสำรองข้อมูล: %1',
    'cu_scheduled_backup_mail_subject' => '<%1> เกิดข้อผิดพลาดขึ้นในระหว่างการสำรองข้อมูลที่จัดกำหนดเวลาไว้',
    'cu_scheduled_backup_mail_message' => "%1\nจุดเข้าใช้งานของ Plesk: %2\n\nเกิดข้อผิดพลาดต่อไปนี้ขึ้นในระหว่างกระบวนการสำรองข้อมูลที่กำหนดเวลาไว้:\n\n%3",

    'cu_scheduled_backup_hourly' => 'สำรองข้ามูลรายชั่วโมง',
    'cu_scheduled_backup_daily' => 'สำรองข้อมูลรายวัน',
    'cu_scheduled_backup_weekly' => 'สำรองข้อมูลรายสัปดาห์',
    'cu_scheduled_backup_monthly' => 'สำรองข้ามูลรายเดือน',
    'cu_scheduled_backup_comment_backup_all' => '%1. เนื้อหาและการกำหนดค่าทั้งหมด',
    'cu_scheduled_backup_comment_backup_vhost' => '%1. เนื้อหาและการกำหนดค่าทั้งหมดยกเว้นข้อความอีเมล.',
    'cu_scheduled_backup_comment_backup_mail' => '%1. การกำหนดค่าและข้อความอีเมลเท่านั้น',
    'cu_scheduled_backup_comment_backup_mail_file' => '%1. เนื้อหาและการกำหนดค่าทั้งหมดยกเว้นฐานข้อมูลผู้ใช้',
    'cu_scheduled_backup_comment_backup_mail_database' => '%1. เนื้อหาและการกำหนดค่าทั้งหมดยกเว้นฐานไฟล์ผู้ใช้',
    'cu_scheduled_backup_comment_backup_database' => '%1. การกำหนดค่าและฐานข้อมูลผู้ใช้เท่านั้น',
    'cu_scheduled_backup_comment_backup_file' => '%1. การกำหนดค่าและไฟล์ผู้ใช้เท่านั้น',
    'cu_scheduled_backup_comment_backup_domain' => '%1. การปรับตั้งค่าโดเมน.',

    'cu_scheduled_backup_to_cloud_not_allowed' => 'การจัดเก็บการสำรองข้อมูลตามกำหนดเวลาในพื้นที่เก็บข้อมูลบนคลาวด์ระยะไกลเป็นฟีเจอร์ระดับพรีเมียม โปรดติดต่อผู้ให้บริการโฮสต์ของคุณเพื่อปลดล๊อคการใช้งาน',

    'i_backup_invalid_file' => 'นี่ไม่ใช่การสำรองข้อมูลที่ถูกต้อง ไม่สามารถกู้คืนข้อมูลจากไฟล์นี้ได้ คลิกที่ชื่อการสำรองข้อมูลสำหรับรายละเอียด',

    'ui__server/migration/download-agent__short-title' => 'ดาวน์โหลดตัวแทนการส่งต่อ & การย้าย',
    'ui__server/migration/download-agent__title' => 'ดาวน์โหลดตัวแทนการส่งต่อ & การย้าย',
    'ui__server/migration/download-agent__description' => 'ดาวน์โหลดเวอร์ชั่นล่าสุดของตัวแทนการส่งต่อและการย้ายจากเว็บไซต์ Plesk',

    'filemanager_resulting_archive_exists' => 'มีไฟล์ %1 อยู่แล้วในไดเร็กทอรี่เป้าหมาย',

    'agent_unable_to_connect' => 'ไม่สามารถเชื่อมต่อกับตัวแทนที่ \'%2\' ได้ กรุณาตรวจสอบว่าตัวแทนได้รับการติดตั้งและใช้งานโดยไม่มีปัญหาในการเชื่อมต่อกับโฮสต์ \'%2\'',
    'agent_test_connection_failed' => 'การเชื่อมต่อไปยังตัวแทน \'%2\' ล้มเหลว',

    'agent_unable_to_resolve_host' => 'ไม่สามารถกำหนดที่ตั้งโฮสต์ระยะไกล \'%1\' ได้ กรุณาตรวจสอบว่าไม่มีปัญหาในการเชื่อมต่อกับโฮสต์',
    'agent_unknown_curl_error' => 'ข้อผิดพลาด \'%1\' เกิดขึ้นระหว่างการเชื่อมต่อกับตัวแทน \'%2\'',
    'agent_unexpected_htp_code' => 'ได้รับรหัส HTTP ที่ไม่คาดคิด \'%1\' ในการร้องขอ HTTP ไปยังตัวแทนที่ \'%2\'',
    'agent_unable_to_auth' => 'ไม่สามารถพิสูจน์โฮสต์ \'%1\' ได้ เพื่อแก้ไขปัญหานี้ กรุณาปฏิบัติตามคำแนะนำที่ http://kb.plesk.com/116606',
    'agent_internal_server_error' => 'พบข้อผิดพลาดเซิร์ฟเวอร์ภายในระหว่างการดำเนินการตามคำสั่งในโฮสต์ระยะไกล \'%1\'',
    'agent_response_is_empty' => 'ได้รับการตอบสนองว่างเปล่าในการร้องขอ HTTP ไปยังตัวแทนที่ \'%1\'',

    'migration__disabled_due_to_local_file_does_not_exist' => 'ไม่สามารถหาตัวแทนการส่งต่อ & การย้ายแคชในระบบพบ กรุณาเปิดตัวจัดการการส่งต่อ & การย้ายเพื่อแก้ปัญหานี้',

    '__hosting_webdeploy' => "การเผยแพร่เว็บที่ใช้งานจริง",
    'cu_domain__webdeploy' => "การเผยแพร่เว็บที่ใช้งานจริง (ค่าเริ่มต้น: %1)",
    'cu_dom_tpl__webdeploy' => "การเผยแพร่เว็บที่ใช้งานจริง (ค่าเริ่มต้น: %1)",
    'cu_subdomain__webdeploy' => "การเผยแพร่เว็บที่ใช้งานจริง (ค่าเริ่มต้น: %1)",
    'webdeploy__not_installed' => "ไม่มีการติดตั้ง Microsoft Web Deploy บนเซิร์ฟเวอร์",
    'webdeploy__forced_by_site_isolation' => "ไม่สามารถเปลี่ยนการตั้งค่าการเผยแพร่เว็บที่ใช้งานจริง: คุณไม่ได้รับอนุญาตให้ยกเลิกนโยบายความปลอดภัยของทั้งเซิร์ฟเวอร์ ติดต่อผู้ให้บริิการสำหรับรายละเอียด",



    'backup__restore_options__admin__server_configuration_license' => 'รหัสลิขสิทธิ์',
    'migration_start_migrate_server_license' => 'ส่งต่อรหัสลิขสิทธิ์',

    'defaultcomponents__delegation_rule_not_exist' => '(ไม่มีกฎการมอบหมายงานที่ต้องการ \'appPoolPipeline, appPoolNetFx\' อยู่)',

    '__o' => 'O',

    'i_backup_created_by_admin' => 'ผู้ดูแลระบบสร้างการสำรองข้อมูลขึ้น',
    'i_backup_created_by_reseller' => 'ตัวแทนจำหน่ายสร้างการสำรองข้อมูลขึ้น',
    'i_backup_created_by_client' => 'ลูกค้าสร้างการสำรองข้อมูลขึ้น',

    'migration__object_exists_on_target_host' => '(มีอยู่บนโฮสต์เป้าหมายแล้ว)',

    '__customers_total' => 'รวมทั้งหมดโดยลูกค้า',
    '__resellers_total' => 'ทั้งหมดโดยตัวแทนจำหน่าย',
    '__reseller_total' => 'ตัวแทนจำหน่ายทั้งหมด',


    'cu_cl_pref__manage_website_maintenance' => 'การเข้าถึงการดำเนินการขั้นสูง: การคัดลอกเว็บไซต์',
    'cu_cl_pref__manage_protected_dirs' => 'การกำหนดค่าสารบบที่ได้รับการป้องกันด้วยรหัสผ่าน',
    'cu_cl_pref__manage_mail_settings' => 'ความสามารถในการเปลี่ยนการตั้งค่าจดหมาย',


    'cu__command_update_php_settings' => 'อัพเดตการตั้งค่า PHP',
    'cu__php_settings_option' => 'ตั้งค่าพาธไปยังไฟล์ที่มีการตั้งค่า PHP',

    'cu__additional_php_settings_option' => 'ตั้งค่าพาธไปยังไฟล์ที่มีคำสั่ง PHP เพิ่มเติม',
    'cu__command_show_php_settings' => 'แสดงการตั้งค่า PHP ในปัจจุบัน',
    'cu__general_settings' => 'การตั้งค่าทั่วไป:',
    'cu__performance_settings' => 'การตั้งค่าประสิทธิภาพการทำงาน:',
    'cu__php_fpm_settings' => 'การตั้งค่า PHP-FPM:',
    'cu__additional_directives' => 'คำสั่งเพิ่มเติม:',

    'php_settings_permission_required' => 'การจัดการการตั้งค่า PHP ทั่วไป',
    'php_settings_performance_permission_required' => 'การจัดการการตั้งค่าประสิทธิภาพโฮสติ้ง',
    'php_settings_customized' => 'การตั้งค่า PHP ได้รับการปรับแต่ง',
    'php_settings_synchronized_with_plan' => 'ปรับข้อมูลการตั้งค่า PHP ตามแผน',
    'phosting__unknown_shell_type' => 'การปกป้องไม่พร้อมใช้งาน',

    'login_up__access_denied_subscription_deleted' => 'ปฏิเสธการเข้าถึง: ลบการสมัครของคุณแล้ว',

    'role_restricted_to_subscription' => '(ส่งต่อตามการสมัครใช้บริการ: %1)',

    'filemanager__extract' => "ตัดทอนไฟล์ไปที่: %1",

    'cu__license_command_check_installed_license' => 'ตรวจสอบความถูกต้องของการติดตั้งรหัสลิขสิทธิ์ (ส่งกลับรหัสออก 0 หากรหัสถูกต้องและ 1 หากรหัสไม่ถูกต้อง)',

    'promo__mobile_manager_title' => 'ตัวจัดการแบบเคลื่อนที่ของเซิร์ฟเวอร์ Plesk',
    'promo__mobile_manager' => "ขยายฟังก์ชั่นการทำงานของ Plesk เพื่อให้สามารถควบคุมและตรวจสอบเซิร์ฟเวอร์จากอุปกรณ์เคลื่อนที่ได้ (BlackBerry iPhone และ Android)",
    'promo__mobile_monitor_title' => 'การตรวจสอบแบบเคลื่อนที่ของเซิร์ฟเวอร์ Plesk',
    'promo__mobile_monitor' => 'การขอรับข้อมูลที่สำคัญที่สุดเกี่ยวกับเซิร์ฟเวอร์ของ Plesk ได้ทุกที่ทุกเวลาจากอุปกรณ์เคลื่อนที่ (BlackBerry iPhone และ Android)',
    'promo__mobile_button' => 'เรียนรู้เพิ่มเติม',

    'ui__server/migration/video__short-title' => 'วีดีโอสอนการใช้งาน',
    'ui__server/migration/video__title' => 'ดูวีดีโอสอนการใช้งาน',
    'ui__server/migration/video__description' => 'ดูวีดีโอสอนการใช้งาน',

    'subDomainNameHint' => 'ใส่ * ตามชื่อโดเมนเพื่อสร้างตัวแทนของซับโดเมน จะเปลี่ยนเส้นทางผู้เยี่ยมชมไซต์ไปที่ซับโดเมนนี้แทนโดยไม่คำนึงถึงชื่อของซับโดเมนที่ป้อนลงในเบราเซอร์',
    'subdomains__wildcard_name_invalid' => "ชื่อซับโดเมนไม่ถูกต้อง คุณสามารถใช้ตัวอักษร ตัวเลข เครื่องหมายขีด (-) และดอกจัน (*) สำหรับชื่อตัวแทนของซับโดเมน",
    'subdomains__name_invalid' => "ชื่อซับโดเมนไม่ถูกต้อง คุณสามารถใช้ตัวอักษร ตัวเลข และเครื่องหมายขีด (-) สำหรับชื่อซับโดเมน",

    'domain__wildcard_no_www_prefix' => 'เป็นไปไม่ได้ที่จะใช้ www ส่วนต้นสำหรับซับโดเมนตัวแทน',

    '__service_title__milter' => "มิลเตอร์ Plesk Postfix",
    '__service_description__milter' => "ตัวกรองเมล Plesk Postfix",
    '__milter' => "มิลเตอร์ Postfix",
    'restart__milter' => "Plesk มิลเตอร์ (%1)",
    'restart__pop3' => "เซิร์ฟเวอร์ POP3 ของผู้ส่ง",
    'restart__pop3s' => "เซิร์ฟเวอร์ POP3 ของผู้ส่งที่มีการสนับสนุน SSL/TLS",
    'restart__imap' => "เซิร์ฟเวอร์ IMAP ของผู้ส่ง",
    'restart__imaps' => "เซิร์ฟเวอร์ IMAP ของผู้ส่งที่มีการสนับสนุน SSL/TLS",
    'restart__authdaemon' => "ดีมอนรับรองความถูกต้อง IMAP ของผู้ส่ง",
    'restart__imap-pop3' => "Dovecot IMAP และเซิร์ฟเวอร์ POP3",


    'addon_packages_not_supported' => 'ไมสนับสนุนส่วนเสริมสำหรับแอพเว็บแพคเกจ APS',
    'cu_domain__unable_to_automaticaly_select_ip' => 'ไม่สามารถมอบหมาย IP แอดเดรสไปยังโดเมนโดยอัตโนมัติได้ กรุณาระบุ IP แอดเดรสโดยใช้ตัวเลือก -ip',

    'plesk_key__mb_accounts' => 'บัญชีผู้ใช้ (ตัวแทนจำหน่ายและลูกค้า) ของลูกค้าและผู้จัดการธุรกิจ',

    'actionlog__subdomain_dns' => 'ซับโดเมน DNS โซน',
    'actionlog__site_subdomain_dns' => 'DNS โซนของซับโดเมนภายในโดเมนเพิ่มเติม',

    // PfW only
    'actionlog__event_site_create' => 'สร้างโดเมน',
    'actionlog__event_site_delete' => 'ลบโดเมน',
    'actionlog__event_site_update' => 'อัพเดตโดเมน',

    'actionlog__event_site_status_update' => 'อัพเดตสถานะโดเมน',
    'actionlog__event_site_dns_update' => 'อัพเดตโดเมน DNS โซน',
    'actionlog__event_site_guid_update' => 'อัพเดตโดเมน GUID',

    'actionlog__event_site_subdomain_create' => 'สร้างซับโดเมน',
    'actionlog__event_site_subdomain_delete' => 'ลบซับโดเมน',
    'actionlog__event_site_subdomain_update' => 'อัพเดตซับโดเมน',

    'actionlog__event_site_alias_create' => 'สร้างนามแฝงโดเมน',
    'actionlog__event_site_alias_delete' => 'ลบนามแฝงโดเมน',
    'actionlog__event_site_alias_update' => 'อัพเดตนามแฝงโดเมน',

    'actionlog__event_site_alias_dns_update' => 'อัพเดต DNS โซนของนามแฝงโดเมน',
    'actionlog__event_subdomain_dns_update' => 'อัพเดต DNS โซนของซับโดเมนภายใต้โดเมนเริ่มต้นแล้ว',
    'actionlog__event_site_subdomain_dns_update' => 'อัพเดต DNS โซนของซับโดเมน',
    // End of PfW only

    'win_policy__bad_password' => 'การตรวจสอบล้มเหลว รหัสผ่านไม่ถูกต้อง',
    'win_policy__password_too_short' => 'การตรวจสอบความถูกต้องล้มเหลว รหัสผ่านไม่ตรงกับเงื่อนไขรหัสผ่านที่ต้องการ เพราะว่ารหัสผ่านสั้นเกินไป',
    'win_policy__password_too_long' => 'การตรวจสอบข้อมูลล้มเหลว รหัสผ่านไม่ตรงกับเงื่อนไขสำหรับการสร้างรหัสผ่าน เพราะว่ารหัสผ่านยาวเกินไป',
    'win_policy__password_not_complex_enough' => 'การตรวจสอบข้อมูลล้มเหลว รหัสผ่านไม่ซับซ้อนพอและไม่ตรงกับข้อกำหนดของนโยบายรหัสผ่าน รหัสผ่านที่มีความแข็งแรงจะต้องประกอบด้วยอย่างน้อยอักขระทั้งหมดต่อไปนี้: ตัวอักษรแปดตัว เครื่องหมายขีดบนหรือล่างหนึ่งตัว หมายเลขสามตัวและอักษรพิเศษหนึ่งตัว (!, @, #, $, %, ^, &, *, ?, _, ~) หรือหมายเลขหนึ่งตัวและอักษรพิเศษอีกสองตัว',

    //// Activation Code feature
    'plesk_key__license_update_failed' => 'ไม่สามารถอัพเดตใบอนุญาตสิทธิการใช้งานของผลิตภัณฑ์',


    'filemanager__error_path_is_not_allowed' => 'พาธไม่ได้รับอนุญาต',
    'filemanager__error_path_is_invalid' => 'พาธไม่ถูกต้อง',
    'filemanager__error_path_not_found' => 'ไม่พบพาธ',
    'filemanager__error_path_already_exists' => 'พาธนี้มีอยู่แล้ว',
    'filemanager__error_access_is_denied' => 'ปฏิเสธการเข้าถึง',
    'filemanager__error_directory_not_empty' => 'โฟลเดอร์ไม่ว่าง',
    'filemanager__error_sharing_violation' => 'การละเมืดการใช้งานร่วมกัน',
    'filemanager__error_not_same_device' => 'พาธปลายทางไม่ได้อยู่บนอุปกรณ์เดียวกัน',
    'filemanager__binary_data_access' => 'ไฟล์นี้เป็นแบบไฟล์ทวิภาค คุณต้องการเปิดไฟล์หรือไม่?',
    'filemanager__unable_to_resolve_realpath' => "ไม่สามารถหาไฟล์ %1 ในตำแหน่งที่ระบุพบ",
    'filemanager__access_to_realpath_denied' => "การเข้าถึงเรียลพาธถูกปฏิเสธ: %1 ถึง %2",
    'bt_exit' => 'ออก',

    'filemanager__chdir_error__' => "ไม่สามารถเปลี่ยนสารบบไปยัง %1: %2",
    'filemanager__chmod_dir' => "เปลี่ยนการอนุญาตสำหรับสารบบ %1",
    'filemanager__chmod_error__' => "ไม่สามารถเปลี่ยนการอนุญาตสำหรับไฟล์ %1: %2",
    'filemanager__chmod_file' => "เปลี่ยนการอนุญาตสำหรับไฟล์ %1",
    'filemanager__copy_error__' => "ไม่สามารถคัดลอก %1 ไปยัง %2: %3",
    'filemanager__copy_move' => "คัดลอก (ย้าย) ไฟล์จาก %1",
    'filemanager__count_size__' => 'ขนาดที่เลือก: %1',
    'filemanager__count_size_error__' => 'ไม่สามารถคำนวณขนาดสำหรับ %1: %2',
    'filemanager__create_dir_error__' => "ไม่สามารถสร้างสารบบ %1: %2",
    'filemanager__dir_not_exists' => "ไม่มีสารบบ %1",
    'filemanager__dirname' => "ชื่อไดเร็กทอรี่",
    'filemanager__filename' => "ชื่อไฟล์",
    'filemanager__is_no_such' => "ไม่มีไฟล์ หรือสารบบที่ชื่อ %1",
    'filemanager__empty_selection' => "ไม่มีไฟล์ที่เลือก",
    'filemanager__move_error__' => "ไม่สามารถย้ายได้ %1 ไปยัง %2: %3",
    'filemanager__not_allowed' => "คุณไม่ได้รับอนุญาตให้เปลี่ยนการอนุญาตสำหรับไฟล์นี้",
    'filemanager__remove' => "ลบไฟล์จาก %1",
    'filemanager__remove_error__' => "ไม่สามารถลบไฟล์ %1: %2",
    'filemanager__rename_dir' => "เปลี่ยนชื่อสารบบ %1",
    'filemanager__rename_error__' => "ไม่สามารถเปลี่ยนชื่อ %1 ที่ %2: %3",
    'filemanager__rename_file' => "เปลี่ยนชื่อไฟล์ %1",
    'filemanager__set_win_permissions_dir' => "ตั้งการอนุญาตสำหรับโฟลเดอร์ %1",
    'filemanager__set_win_permissions_file' => "ตั้งการอนุญาตสำหรับไฟล์ %1",
    'filemanager__touch_confirm' => "คุณต้องการเปลี่ยนตราเวลาของไฟล์ที่เลือกไว้หรือไม่?",
    'filemanager__upload_error__' => "ไม่สามารถอัพโหลด %1 ไปยัง %2: %3 ได้",
    'filemanager__upload_file' => "อัพโหลดไฟล์",
    'filemanager__upload_file_src' => "พาธไปยังไฟล์",
    'filemanager__max_image_size_exceeded' => 'ไม่สามารถแสดงภาพได้ ขนาดของไซต์ไม่สามารถดีกว่า %2 ไบต์ได้',

    '__fastcgi_unix_support' => 'รองรับการทำงาน FastCGI',

    'dns__subdomain_dns_zone_parent' => 'การบันทึก DNS ของซับโดเมนนี้เก็บอยู่ใน DNS โซนหลัก คุณสามารถปรับแก้โซนหลัก %1 หรือสร้างโซนแยกสำหรับซับโดเมน',
    'dns__subdomain_dns_zone_parent_link' => 'ที่นี่',
    'dns__no_dns_zone' => 'ไม่มี DNS โซนใดๆ ได้รับการมอบหมายในโดเมน คุณต้องกดที่ปุ่ม \'เรียกคืนค่าเริ่มต้น\' เพื่อจัดการ DNS โซนสำหรับโดเมนของคุณ',
    'dns__unable_turn_on_subdomain_zone' => 'ไม่สามารถเปิดโซนของซับโดเมนได้เพราะมีบันทึก CNAME สำหรับซับโดเมนนี้ในโซนของโดเมนหลักแล้ว',

    '__hosting_write_modify' => 'เขียน/แก้ไขการอนุญาตเพิ่มเติม',

    'aspdotnet__group_framework_version' => "เวอร์ชั่นของโครงร่าง",

    'bt_restore_default' => "ตั้งใปเป็นค่าเริ่มต้น",
    'b_autoinstaller' => 'อัพเดต Plesk หรือคอมโพเนนท์',
    'b_autoinstaller_configure' => 'การตั้งค่าการอัปเดต',
    'b_autoinstaller_install' => 'ติดตั้งคอมโพเนนท์ที่เลือก',

    '__iis_app_pool__use_dedicated' => 'กลุ่มแอพพลิเคชั่น IIS เฉพาะ',
    '__iis_app_pool__use_dedicated_addons' => 'กลุ่มแอพพลิเคชั่น IIS เฉพาะสำหรับแต่ละเว็บไซต์',
    '__iis_app_pool__enable_32bit_app_on_win64' => 'เปิดใช้งานแอปพลิเคชันแบบ 32 บิต',
    '__iis_app_pool__load_user_profile' => 'โหลดโปรไฟล์ผู้ใช้',
    'bt_iis_app_pool' => "แอพพลิเคชั่นกลุ่ม IIS",

    'performance__cpu_usage' => 'การใช้งาน CPU สูงสุด (%)',
    'performance__cpu_usage_action' => 'การทำงานตามขีดจำกัด',
    'performance__cpu_usage_interval' => 'การจำกัดรอบ (นาที)',
    'performance__cpu_usage_action_not_supported' => 'การทำงานที่ระบุไม่ได้รับการสนับสนุนจากเซิร์ฟเวอร์เว็บ IIS',

    'performance__idle_timeout_action_not_supported' => 'การใช้งานการหมดเวลาเครื่องเดินเปล่าที่ระบุไม่ได้รับการสนับสนุนจากเซิร์ฟเวอร์เว็บ IIS',
    'performance__max_worker_processes' => 'จำนวนสูงสุดของกระบวนการของผู้ปฏิบัติงาน',
    'performance__idle_timeout' => 'การหมดเวลาเครื่องเดินเปล่า (นาที)',
    'performance__idle_timeout_action' => 'การหมดเวลาเครื่องเดินเปล่า',
    'performance__recycling_by_time' => 'การรีไซเคิลในช่วงเวลาปกติ (นาที)',
    'performance__recycling_by_requests' => 'การรีไซเคิลเมื่อมีการร้องขอถึงจำนวนสูงสุด',
    'performance__recycling_by_virtual_memory' => 'การรีไซเคิลเมื่อใช้จำนวนสูงสุดของหน่วยความจำเสมือน',
    'performance__recycling_by_private_memory' => 'การรีไซเคิลเมื่อใช้จำนวนสูงสุดของหน่วยความจำส่วนตัว',
    'performance__managed_pipeline_mode' => 'โหมดการทำงานแบบสายท่อการจัดการ',
    'performance__managed_pipeline_mode_not_supported' => 'โหมดที่ระบุไม่ได้รับการสนับสนุนจากเซิร์ฟเวอร์เว็บ',

    'iis_app_pool' => 'การปรับแต่งแอพพลิเคชั่นกลุ่ม IIS',
    'b_iis_app_pool' => 'จัดการกับกลุ่มแอพพลิเคชั่น IIS',
    'iis_app_pool_cl_dom' => 'การปรับแต่งแอพพลิเคชั่นกลุ่ม IIS',

    'l_webdirerrordocslist_code' => 'จัดเรียงความผิดพลาดของเอกสารตามรหัสมายเลขที่เกิดความผิดพลาด',
    'l_webdirerrordocslist_name' => 'จัดเรียงความผิดพลาดของเอกสารตามรายละเอียดความผิดพลาด',
    'l_webdirerrordocslist_type' => 'จัดเรียงความผิดพลาดของเอกสารตามประเภทของเอกสารที่เกิดความผิดพลาด',
    'l_webdirerrordocslist_location' => 'จัดเรียงความผิดพลาดของเอกสารตามสถานที่ที่เกิดความผิดพลาด',

    'b_webdirerrordocslist_search' => 'ระบุแบบค้นหาและคลิกเพื่อทำการค้นหาเอกสารที่ผิดพลาด',
    'b_webdirerrordocslist_remove' => 'ลบเอกสารที่ผิดพลาดที่เลือก',
    'b_webdirerrordocslist_show_all' => 'แสดงเอกสารที่ผิดพลาดทั้งหมด',

    'l_webdirmimetypeslist_name' => 'จัดเรียงประเภท MIME ตามนามสกุลไฟล์',
    'l_webdirmimetypeslist_content' => 'จัดเรียงประเภท MIME ตามข้อมูล',

    'b_webdirmimetypeslist_remove' => 'ลบประเภท MIME ที่เลือก',
    'b_webdirmimetypeslist_search' => 'ป้อนรูปแบบการค้นหาและคลิกเพื่อทำการค้นหาประเภทของ MIME',
    'b_webdirmimetypeslist_show_all' => 'แสดงประเภทของ MIME ทั้งหมด',

    'b_webdir_preferences' => "การตั้งค่าไดเร็กทอรี่เสมือน",
    'b_webdir_permissions' => "การอนุญาตไดเร็กทอรี่เสมือน",
    'b_webdir_permissions_disabled' => "ไม่มีการจัดการการอนุญาตไดเร็กทอรี่อยู่",
    'b_to_webdirs' => 'กลับไปยังการจัดการไดเร็กทอรี่',
    'b_to_webdir_mime_types' => 'กลับไปยังการจัดการประเภท MIME',
    'b_to_webdir_error_docs' => 'กลับไปยังการจัดการเอกสารที่ผิดพลาด',
    'b_to_webdir_protection' => 'กลับไปยังการจัดการการป้องกันไดเร็กทอรี่เสมือน',

    'webdirs__title' => 'ไดเร็กทอรี่เสมือน %1',
    'webdirs__preferences_title' => 'การตั้งค่าไดเร็กทอรี่เสมือน',
    'webdirs__tabs_general' => 'ทั่วไป',
    'webdirs__tabs_mime_types' => 'ประเภท MIME',
    'webdirs__tabs_error_docs' => 'เอกสารผิดพลาด',

    'webdirs__tabs_permissions' => 'การอนุญาต',
    'webdir__remove_vdirs' => 'จะลบไดเร็กทอรี่เสมือนดังต่อไปนี้:',
    'webdir__remove_mime_types' => 'ประเภทของ MIME ดังต่อไปนี้จะถูกลบ',
    'webdir__mime_types_title' => 'ประเภท MIME',
    'webdir__protection_disable_confirm' => 'คุณต้องการจะลบการป้องกันออกจากสารบบใช่หรือไม่?',
    'webdir__protect_title' => 'URL ของผู้ใช้งานที่ได้รับการป้องกัน',
    'webdirs__permissions_title' => 'การอนุญาตไดเร็กทอรี่เสมือน',
    'error_doc__list_code' => 'ผิดพลาด',
    'error_doc__list_code_description' => 'รายละเอียด',
    'error_doc__list_type' => 'ประเภท',
    'error_doc__list_location' => 'ที่ตั้ง',
    'error_doc__code' => 'ผิดพลาด',
    'error_doc__type' => 'ประเภท',
    'error_doc__type_file' => 'ไฟล์',
    'error_doc__type_url' => 'URL',
    'error_doc__location' => 'ที่ตั้ง',
    'error_doc__legend' => 'เอกสารที่ผิดพลาด',
    'error_doc__edit_title' => 'แก้ไขเอกสารที่ผิดพลาด',
    'error_doc_erorr_invalid_url_location' => 'URL นี้ไม่ถูกต้อง โปรดระบุ URL ที่ถูกต้อง',
    'error_doc_erorr_invalid_file_location' => 'การพาธไฟล์ไม่ถูกต้อง โปรดระบุพาธไฟล์ที่ถูกต้อง',
    'error_doc__type_default' => 'ค่าเริ่มต้น',

    'webdirs__tabs_protection' => 'การป้องกัน',
    'pb_webdirs' => 'ไดเร็กทอรี่เสมือน',

    'webdirs_mime_types_remove_title' => 'ประเภทของ MIME ดังต่อไปนี้จะถูกลบ',
    'webdirs_preferences_title' => 'การตั้งค่าไดเร็กทอรี่เสมือน',
    'webdirs_permissions_title' => 'การอนุญาตพิเศษสำหรับไฟล์และโฟลเดอร์',
    'webdi_protection_disable_confirm' => 'คุณแน่ใจหรือไม่ว่าคุณต้องการลบการป้องกันไดเร็กทอรี่เสมือน? การทำเช่นนี้จะเป็นการลบการป้องกันผู้ใช้ไดเร็กทอรี่ทั้งหมดและการตั้งค่าการป้องกันไดเร็กทอรี่',
    'bt_protect' => 'ควบคุม',
    'bt_unprotect' => 'ลบการป้องกัน',
    'bt_show_additional_users' => 'แสดงบัญชีอื่น',
    'bt_hide_additional_users' => 'แสดงผู้ใช้งานน้อยกว่า',
    'error_doc__list_title' => 'เอกสารที่ผิดพลาด',
    'error_doc__list_header' => 'เอกสารที่ผิดพลาด',
    'error_doc__code_400' => 'คำขอที่เป็นอันตราย',
    'error_doc__code_401' => 'ไม่ได้สิทธิ์',
    'error_doc__code_401.1' => 'ไม่ได้สิทธิ์ - การเข้าระบบผิดพลาด',
    'error_doc__code_401.2' => 'ไม่ได้สิทธิ์ - การเข้าระบบผิดพลาดเนื่องจากการปรับตั้งค่าเซิร์ฟเวอร์',
    'error_doc__code_401.3' => 'ไม่ได้สิทธิ์ - ไม่ได้สิทธิ์เนื่องจาก ACL ในทรัพยากร',
    'error_doc__code_401.4' => 'ไม่ได้สิทธิ์ - การได้รับสิทธิ์ผิดพลาดโดยตัวกรอง',
    'error_doc__code_401.5' => 'ไม่ได้สิทธิ์ - การได้รับสิทธิ์ผิดพลาดโดยแอพ ISAPI/CGI',
    'error_doc__code_401.7' => 'ไม่ได้รับอนุญาต - ปฏิเสธเนื่องจากนโยบาย URL ที่ไม่ได้รับอนุญาต',
    'error_doc__code_403' => 'ต้องห้าม',
    'error_doc__code_403.1' => 'ต้องห้าม - ปฏิเสธการเข้าใช้',
    'error_doc__code_403.2' => 'ต้องห้ามต - ปฏิเสธการอ่าน',
    'error_doc__code_403.3' => 'ต้องห้าม - ปฏิเสธการเขียนเพื่อบันทึก',
    'error_doc__code_403.4' => 'ต้องห้าม - ต้องมี SSL',
    'error_doc__code_403.5' => 'ข้อห้าม - จำเป็นต้องมี SSL 128',
    'error_doc__code_403.6' => 'ต้องห้าม - ปฏิเสธ IP แอดเดรส',
    'error_doc__code_403.7' => 'ต้องห้าม - ต้องมีการรับรองไคลเอนท์',
    'error_doc__code_403.8' => 'ต้องห้าม - ปฏิเสธการเข้าเว็บไซด์',
    'error_doc__code_403.9' => 'ต้องห้าม - มีผู้ใช้มากเกินไป',
    'error_doc__code_403.10' => 'ข้อห้าม - การกำหนดค่าไม่ถูกต้อง',
    'error_doc__code_403.11' => 'ข้อห้าม - เปลี่ยนรหัสผ่าน',
    'error_doc__code_403.12' => 'ข้อห้าม - ปฏิเสธการเข้าใช้แม็พเปอร์',
    'error_doc__code_403.13' => 'ต้องห้าม - มีการเพิกถอนการรับรองของไคลเอนท์',
    'error_doc__code_403.14' => 'ข้อห้าม - ปฏิเสธรายการไดเร็กทอรี่',
    'error_doc__code_403.15' => 'ข้อห้าม - เกินลิขสิทธิ์การเข้าถึงไคลเอนท์',
    'error_doc__code_403.16' => 'ข้อห้าม - ใบรับรองของไคลเอ็นท์ที่ไม่น่าเชื่อถือหรือไม่ถูกต้อง',
    'error_doc__code_403.17' => 'ต้องห้าม - การรับรองไคลเอนท์หมดอายุ หรือยังไม่ถูกต้อง',
    'error_doc__code_403.18' => 'ต้องห้าม - ไม่สามารถดำเนินการได้จากแอพพลิเคชั่นกลุ่มนี้',
    'error_doc__code_403.19' => 'ข้อห้าม - ปฏิเสธการเข้าถึง CGI',
    'error_doc__code_403.20' => 'ข้อห้าม - การล็อกอินเข้าเส้นทางล้มเหลว',
    'error_doc__code_404' => 'ไม่พบ',
    'error_doc__code_404.2' => 'ไม่พบ - ปฏิเสธเนื่องจากนโยบายล็อกดาวน์',
    'error_doc__code_404.3' => 'ไม่พบ - ปฏิเสธเนื่องจากนโยบาย MIMEMAP',
    'error_doc__code_405' => 'ขั้นตอนที่ไม่ได้รับอนุญาต',
    'error_doc__code_406' => 'ไม่สามารถยอมรับได้',
    'error_doc__code_407' => 'จำเป็นต้องใช้การตรวจสอบตัวตน Proxy',
    'error_doc__code_412' => 'เงื่อนไขล้มเหลว',
    'error_doc__code_414' => 'URI ที่ร้องขอยาวเกินไป',
    'error_doc__code_415' => 'ไม่สนับสนุนประเภทมีเดียร์',
    'error_doc__code_500' => 'ข้อผิดพลาดเซิร์ฟเวอร์ภายใน',
    'error_doc__code_500.12' => 'ข้อผิดพลาดเซิร์ฟเวอร์ภายใน - การรีสตาร์ทแอพพลิเคชั่น',
    'error_doc__code_500.13' => 'ข้อผิดพลาดเซิร์ฟเวอร์ภายใน - เซิร์ฟเวอร์ยุ่งเกินไป',
    'error_doc__code_500.15' => 'ข้อผิดพลาดเซิร์ฟเวอร์ภายใน - การร้องขอโดยตรงสำหรับข้อห้าม GLOBAL.ASA',
    'error_doc__code_500.16' => 'ข้อผิดพลาดเซิร์ฟเวอร์ภายใน - ข้อผิดพลาดการเข้าถึง UNC',
    'error_doc__code_500.17' => 'ข้อผิดพลาดเซิร์ฟเวอร์ภายใน - ไม่พบการจัดเก็บที่ได้รับอนุญาต URL',
    'error_doc__code_500.18' => 'ข้อผิดพลาดเซิร์ฟเวอร์ภายใน - ไม่สามารถเปิดการจัดเก็บที่ได้รับอนุญาต URL',
    'error_doc__code_500.19' => 'ข้อผิดพลาดเซิร์ฟเวอร์ภายใน - เมตาดาต้าไฟล์ไม่ดี',
    'error_doc__code_500.100' => 'ข้อผิดพลาดเซิร์ฟเวอร์ภายใน - ข้อผิดพลาด ASP',
    'error_doc__code_501' => 'ไม่ได้นำไปปฏิบัติ',
    'error_doc__code_502' => 'เกตเวย์ไม่ดี',
    'error_doc__code_503' => 'ไม่พบการบริการชั่วคราว',

    'mimetype__extension' => 'ขยาย',
    'mimetype__content' => 'รายละเอียดภายใน',
    'mimetypeslist__title' => 'ประเภท MIME',
    'mimetypes__title' => 'ประเภท MIME',
    'mimetypes__select_to_remove' => 'เลือกประเภท MIME ที่คุณต้องการลบ',
    'mimetypes__select_for_remove' => "เลือกประเภท MIME เพื่อลบ",
    'mimetypes_remove__title' => 'ลบประเภท MIME',
    'mimetype__legend' => 'ประเภท MIME',
    'mimetype_edit__title' => 'แก้ไขประเภท MIME',
    'mimetype_edit__already_exists' => 'กำหนดประเภทของ MIME สำหรับนามสกุลไฟล์นี้แล้ว',
    'mimetype_edit__not_exists' => 'ไม่มีประเภท MIME',
    'mimetype__content_type_other' => 'ตั้งค่าเอง...',

    'b_webdir_protection_enable' => 'สร้าง URL ที่สอดคล้องกับไดเร็กทอรี่ที่มีการป้องกันด้วยรหัสผ่าน',
    'b_webdir_protection_disable' => 'สร้าง URL ที่สอดคล้องกับไดเร็กทอรี่ที่สามารถเข้าใช้งานได้ทั้งหมด',
    'b_webdir_protection_disabled' => 'ไม่เปิดใช้งานการป้องกันไดเร็กทอรี่เสมือน',

    'b_pd_usr_create' => 'คลิกเพื่อสร้างบัญชีผู้ใช้ URL ที่ได้รับการป้องกัน',
    'php__group_php_version' => "เวอร์ชั่น PHP",

    'virtualdir__name' => 'ชื่อ',
    'virtualdir__path' => 'พาธ',
    'virtualdir__read' => 'อ่านการอนุญาต',
    'virtualdir__read_short' => 'R',
    'virtualdir__write' => 'เขียนการอนุญาต',
    'virtualdir__write_short' => 'W',
    'virtualdir__source' => 'การเข้าสู่ทรัพยากรบทคำสั่ง',
    'virtualdir__source_short' => 'S',
    'virtualdir__browse' => 'เรียกข้อมูลสารบบ',
    'virtualdir__browse_short' => 'B',
    'virtualdir__script_execute' => 'กระทำการอนุญาต',
    'virtualdir__script_execute_short' => 'E',
    'virtualdir__log_visits' => 'เข้าระบบผู้เยี่ยมชม',
    'virtualdir__app_create' => 'สร้างแอพพลิเคชั่น',
    'virtualdir__app_create_short' => 'A',
    'virtualdir__auth_anon' => 'เปิดใช้งานการตรวจสอบความถูกต้องแบบไม่ระบุชื่อ',
    'virtualdir__auth_windows' => 'เปิดใช้งานการตรวจสอบความถูกต้อง Windows',
    'virtualdir__auth_not_enabled' => 'ต้องเปิดใช้งานการตรวจสอบความถูกต้องแบบไม่ระบุชื่อหรือ Windows',
    'virtualdir__require_ssl' => 'จำเป็นต้องใช้ SSL/TLS',
    'virtualdir__enable_default_doc' => 'ใช้เอกสารเริ่มต้น',
    'virtualdir__default_doc' => 'ค่าเริ่มต้นมาตฐานในการค้นหาเอกสาร',
    'virtualdir__enable_parent_paths' => 'อนุญาตให้ใช้พาธผู้ปกครอง',
    'virtualdir__execute_in_mta' => 'อนุญาตแอพพลิเคชั่นกระทำการในโหมด MTA (มัลติ เธรด อพาร์ทเม้นต์)',
    'virtualdir_create__title' => 'สร้างสารบบเสมือนใน %1',
    'virtualdir_edit__title' => 'คุณสมบัติของสารบบเสมือน %1',
    'virtualdir_edit__legend' => 'สารบบเสมือน',
    'virtualdir_edit__application_legend' => 'การตั้งค่าแอพพลิเคชั่น',
    'virtualdir_edit__security_legend' => 'ระบบความปลอดภัยของสารบบ',
    'virtualdir_edit__documents_legend' => 'เอกสาร',
    'virtualdir_edit__list_legend' => 'สารบบบเสมือนซ้อนใน',
    'virtualdir_error__path_not_in__' => 'พาธที่ระบุไม่ถูกต้อง',
    'virtualdir_error__already_exists' => 'มีไดเร็กทอรี่ชื่อนี้อยู่แล้ว',
    'virtualdir_root' => 'สารบบเสมือน',
    'virtualdir_root__title' => 'สารบบเสมือน',
    'virtualdir_root__list_legend' => 'สารบบเสมือน',
    'virtualdir_se__none' => 'ไม่มี',
    'virtualdir_se__script' => 'บทคำสั่งเท่านั้น',
    'virtualdir_se__script_execute' => 'บทคำสั่งและการดำเนินการ',
    'virtualdirs__title' => 'สารบบเสมือน',
    'virtualdirs__path_not_exists' => 'พาทไม่ถูกต้อง',
    'virtualdirs__select_for_remove' => "เลือกสารบบเสมือนที่จะลบ",
    'virtualdirs_remove__title' => 'ลบสารบบเสมือน',
    'virtualdirs_phys_dir_exist' => 'มีไดเร็กทอรี่โครงร่างที่ใช้ชื่อนี้อยู่แล้ว หากดำเนินการต่อจะไม่สามารถเข้าใช้งานได้ คุณต้องการดำเนินการต่อใช่ไหม?',
    'virtualdir_auto_create_dir' => "สร้างสารบบทางกายภาพโดยใช้ชื่อเหมือนกันสารบบเสมือน",

    'asp_max_default_text' => 'กำหนดโดยสารบบของผู้ปกครอง (%1 KB)',
    'asp_max_default_text_site' => 'กำหนดโดย IIS (%1 KB)',
    'asp_max_buffer_text' =>'ขนาดสูงสุดของบัพเฟอร์ ASP (KB)',
    'asp_max_body_text' => 'ขนาดสูงสุดของการขอ ASP ทั้งหมด (KB)',
    'asp_buffers_legend' =>'การตั้งค่า ASP',

    'asp_debug_default_text' =>'กำหนดโดยสารบบของผู้ปกครอง',
    'asp_debug_default_text_site' =>'กำหนดโดย IIS',
    'asp_client_debug_text' =>'ทำให้ ASP ฝั่งไคลแอนต์แก้ไขข้อบกพร่องของสคริปต์',
    'asp_server_debug_text' =>'ทำให้ ASP ฝั่งเซิร์ฟเวอร์แก้ไขข้อบกพร่องของสคริปต์',

    'webdirs__physical_path_not_exist' => "ไม่มีพาธที่ระบุ",

    'permissions__group_or_user_name' => 'กลุ่มหรือชื่อผู้ใช้',
    'permissions__FullControl' => 'ควบคุมได้ทั้งหมด',
    'permissions__Modify' => 'แก้ไข',
    'permissions__ReadAndExecute' => 'อ่านและดำเนินการ',
    'permissions__ListFolderContents' => 'สารบัญของรายการโฟลเดอร์',
    'permissions__Read' => 'อ่าน',
    'permissions__Write' => 'เขียน',
    'permissions__ReadControl' => 'อ่านส่วนควบคุม',
    'permissions__WriteControl' => 'ควบคุมการเขียน',
    'permissions__ExecuteControl' => 'ควบคุมการดำเนินการ',
    'permissions__TraverseFolderOrExecuteFile' => 'แฟ้มข้อมูลที่กีดขวาง / ไฟลฺ์ดำเนินการ',
    'permissions__ListFolderOrRead' => 'รายการโฟลเดอร์ / อ่านข้อมูล',
    'permissions__CreateFilesOrWrite' => 'สร้างไฟล์/เขียนข้อมูล',
    'permissions__CreateFoldersOrAppend' => 'สร้างโฟลเดอร์/ใส่ข้อมูล',
    'permissions__DeleteSubfoldersandFiles' => 'ลบโฟลเดอร์และไฟล์',
    'permissions__Delete' => 'ลบ',
    'permissions__ChangePermissions' => 'เปลี่ยนการอนุญาต',
    'permissions__TakeOwnership' => 'เข้าแสดงความเป็นเจ้าของ',
    'permissions__inherited_from' => 'รับช่วงจาก',
    'permissions__not_inherited' => '<ไม่ได้รับช่วงต่อ>',
    'permissions__apply_to' => 'นำไปใช้กับ',
    'permissions__apply_onto' => 'นำไปใช้กับ:',
    'permissions__apply_onto1' => 'โฟลเดอร์นี้เท่านั้น',
    'permissions__apply_onto2' => 'ซับโฟลเดอร์เท่านั้น',
    'permissions__apply_onto3' => 'โฟลเดอร์และซับโฟลเดอร์นี้',
    'permissions__apply_onto4' => 'ไฟล์เท่านั้น',
    'permissions__apply_onto5' => 'โฟลเดอร์และไฟล์นี้',
    'permissions__apply_onto6' => 'ซับโฟลเดอร์และไฟล์เท่านั้น',
    'permissions__apply_onto7' => 'โฟลเดอร์ ซับโฟลเดอร์ และไฟล์นี้',

    'filemanager__not_allowed_dir' => "คุณไม่ได้รับอนุญาตให้ทำการเปลี่ยนการอนุญาตของโฟลเดอร์นี้",

    'filemanager__allow' => "อนุญาต",
    'filemanager__deny' => "ปฏิเสธ",
    'filemanager__user_domusr' => 'ผู้ดูแลระบบเว็บไซต์',
    'filemanager__user_webusr' => 'ผู้ใช้เว็บ',
    'filemanager__user_admins' => 'ผู้ดูแลระบบ',
    'filemanager__user_system' => 'ระบบ',
    'filemanager__user_aspnet' => 'ผู้ใช้ ASP.NET',
    'filemanager__user_poolusr' => 'ผู้ใช้แอพพลิเคชั่นกลุ่ม',
    'filemanager__user_sysaccount' => 'ผู้ใช้ระบบเพิ่มเติม',

    'bt_permissions_advanced' => 'ขั้นสูง',
    'b_permissions_advanced' => 'คลิกเพื่อดูและตั้งค่าการอนุญาตการใช้พิเศษ',

    'hotlink-protection_invalid_friend_domain' => 'ชื่อไม่ถูกต้องสำหรับโดเมนที่ใช้งานง่าย',
    'hotlink-protection_duplicate_friend_domain' => 'ชื่อซ้ำสำหรับโดเมนที่ใช้งานง่าย',
    'hotlink-protection_invalid_extensions' => 'ส่วนขยายไฟล์ประกอบด้วยตัวอักษรที่ไม่ถูกต้อง',

    'i_domain_alias_status_on' => 'โดเมนนามแฝงทำงานอยู่',
    'i_domain_alias_status_off' => 'โดเมนนามแฝงไม่ทำงาน',
    'i_domain_alias_status_with_parent' => 'โดเมนนามแฝงไม่สามารถทำงานเพราะโดเมนปิดอยู่',
    'i_domain_alias_turn_off' => 'คลิกเพื่อปิดการทำงาน',
    'i_domain_alias_turn_on' => 'คลิกเพื่อเปิดการทำงาน',
    'i_domain_alias_mail_on' => 'โดเมนนามแฝงนี้สามารถใช้งานบริการเมลได้',
    'i_domain_alias_mail_off' => 'โดเมนนามแฝงนี้ไม่สามารถใช้งานบริการเมลได้',
    'i_domain_alias_mail_with_parent' => 'ไม่สามารถใช้งานบริการเมลได้ เนื่องจากนามโดเมนนามแฝงปิดอยู่',
    'i_domain_alias_web_on' => 'โดเมนนามแฝงนี้สามารถใช้งานบริการเว็บได้',
    'i_domain_alias_web_off' => 'โดเมนนามแฝงนี้ไม่สามารถใช้งานบริการเว็บได้',
    'i_domain_alias_web_with_parent' => 'ไม่สามารถใช้งานบริการเว็บได้ เนื่องจากโดเมนนามแฝงปิดอยู่',
    'i_domain_alias_dns_on' => 'บริการสร้างนามแฝงของ DNS เปิดสำหรับนามแฝงของโดเมนนี้',
    'i_domain_alias_dns_off' => 'บริการสร้างนามแฝงของ DNS ถูกปิดใช้งานสำหรับนามแฝงของโดเมนนี้',
    'i_domain_alias_dns_with_parent' => 'ปิดใช้งานการปรับข้อมูล DNS กับโดเมนหลักให้ตรงกันเนื่องมาจากการปิดใช้งานโดเมนนามแฝง',
    'i_domain_alias_seoRedirect_on' => 'การเปลี่ยนเส้นทางด้วยรหัส HTTP 301 เปิดสำหรับนามแฝงของโดเมนนี้',
    'i_domain_alias_seoRedirect_off' => 'การเปลี่ยนเส้นทางด้วยรหัส HTTP 301 ถูกปิดสำหรับนามแฝงของโดเมนนี้',
    'i_domain_alias_seoRedirect_with_parent' => 'การเปลี่ยนเส้นทางด้วยรหัส HTTP 301 ถูกปิดเนื่องจากนามแฝงของโดเมนถูกปิดอยู่',

    'domain_alias__control_title' => 'โดเมนนามแฝง %1',
    'domain_alias__control_info_legend' => 'ข้อมูล',
    'domain_alias__control_status_title' => 'S',
    'domain_alias__control_name_title' => 'ชื่อบริการ',
    'domain_alias__control_details_title' => 'รายละเอียด',

    'domain_alias__invalid_values' => 'ชื่อโดเมนที่คุณระบุไม่ถูกต้อง ชื่อโดเมนสามารถประกอบด้วยตัวอักษร ตัวเลข และขีดสั้น แต่ละส่วนของชื่อโดเมนระหว่างจุดไม่ควรยาวเกิน 63 ตัว',
    'domain_alias__domain_already_exists' => "ชื่อของโดเมนนามแฝง %1 ไม่ถูกต้อง มีชื่อโดเมน %1 อยู่แล้ว",
    'domain_alias__www_prefix_domain_already_exists' => "ชื่อไม่ถูกต้องของโดเมนนามแฝง www. %1 สร้างนามแฝงสำหรับโดเมน %1 แล้ว",
    'domain_alias__webmail_enabled_domain_already_exists' => 'ชื่อไม่ถูกต้องของเว็บเมลโดเมนนามแฝง %1 สร้างนามแฝงสำหรับโดเมน %1 แล้ว',
    'domain_alias__lists_enabled_domain_already_exists' => 'ชื่อไม่ถูกต้องของรายการโดเมนนามแฝง %1 สร้างนามแฝงสำหรับโดเมน %1 แล้ว',
    'domain_alias__dns_record_already_exists' => 'ไม่สามารถตั้งค่าโดเมนนามแฝง %1 เนื่องจากรายการ DNS ชี้ไปยังโฮสต์ %1 ที่มีอยู่แล้ว',
    'domain_alias__domain_alias_already_exists' => "มีโดเมนนามแฝงที่ใช้ชื่อนี้อยู่แล้ว",
    'domain_aliases__mail_server_not_support_aliases' => 'ไม่สามารถใช้คุณลักษณะของโดเมนนามแฝงได้ภายใต้เซิร์ฟเวอร์เมลนี้ โดเมนนามแฝงอาจทำงานไม่ถูกต้อง',
    'domain_alias__restrict_domain_creation' => 'นโยบายเซิร์ฟเวอร์ห้ามใช้ชื่อที่ระบุสำหรับโดเมนนามแฝง หากโดเมนนามแฝงนี้เป็นของคุณ โปรดติดต่อผู้ให้บริการโฮสต์',
    'domain_alias__restrict_creation_with_www' => 'โปรดใส่ชื่อโดเมนโดยไม่ต้องมีส่วนนำเป็น \'www\' ระบบจะเพิ่มส่วนนำ www สำหรับโดเมนไปยังการกำหนดค่าเซิร์ฟเวอร์ของเว็บไซต์โดยอัตโนมัติ',
    'domain_unable_to_set_name' => 'ชื่อ %1 ไม่ถูกต้อง',

    'domain_alias__domain_service_dns_disabled' => 'เซิร์ฟเวอร์ DNS อื่นใช้บริการโดเมนนี้แล้ว',
    'domain_alias__domain_service_dns_enabled_master' => 'เซิร์ฟเวอร์ DNS นี้ทำงานเหมือนเซิร์ฟเวอร์ชื่อหลักสำหรับ DNS โซนนี้',
    'domain_alias__domain_service_dns_enabled_slave' => 'เซิร์ฟเวอร์ DNS นี้ทำงานเหมือนเซิร์ฟเวอร์ชื่อรองสำหรับ DNS โซนนี้',
    'domain_alias__domain_service_mail_enabled' => 'เปิดบริการเมลสำหรับโดเมน',
    'domain_alias__domain_service_mail_disabled' => 'ปิดบริการเมลสำหรับโดเมน',
    'domain_alias__domain_service_mail_mx' => 'ใช้ %1 เป็นเซิร์ฟเวอร์เมล',

    'domain_alias__service_seoRedirect_hint' => 'เมื่อผู้เข้าชมเปิด URL ของนามแฝงก็จะเปลี่ยนเส้นทางไปยัง URL ของโดเมนหลัก Plesk ใช้การเปลี่ยนเส้นทางเครื่องมือค้นหาอย่างง่าย HTTP 301 ซึ่งหมายความว่าการจัดอันดับเครื่องมือค้นหาไม่สามารถแบ่ง URL ได้',

    'bt_task_run_now' => 'เริ่มทำงานเดียวนี้',
    'ftp__read_perm' => "อ่านการอนุญาต",
    'ftp__write_perm' => "เขียนการอนุญาต",

    'filemanager__upload_backup_file_hint' => 'คุณสามารถอัพโหลดไฟล์การสำรองข้อมูลไปยังพื้นที่จัดเก็บข้อมูลของ Plesk ได้ที่นี่ ขนาดไฟล์สูงสุดไม่เกินสองกิกะไบต์',

    '__default_for_mssql' => 'ค่าเริม่ต้นในส่วน MS SQL',

    '__login_does_not_pass_validation' => "ชื่อผู้ใช้นี้ไม่ถูกต้อง ตรวจสอบให้แน่ใจว่าเป็นไปตามข้อกำหนดต่อไปนี้: %1",
    '__login_allowed_symbols' => 'อนุญาตให้ใช้เฉพาะตัวอักษร ตัวเลข วรรค ขีดคั่น และขีดล่างเท่านั้น ตัวอักษรตัวแรกควรจะเป็นตัวอักษรและตัวเลข',

    'restart__nginx' => 'เซิร์ฟเวอร์ Proxy แบบย้อนกลับ (nginx)',
    'restart__php-fpm' => 'PHP-FPM %1',

    'admin_ed__i_would_like_recieve_announce' => "ฉันต้องการรับข้อมูลและประกาศเกี่ยวกับผลิตภัณฑ์ทั่วไปจาก Plesk",
    'admin_ed__i_would_like_recieve_tech_announce' => "ฉันต้องการรับข้อมูลที่เกี่ยวข้องกับความปลอดภัยและการแจ้งเตือนทางเทคนิคอื่นๆ จาก Plesk",

    '__login_status_inactive' => 'บัญชีของคุณไม่ได้ใช้งาน โปรดติดต่อผู้ดูแลระบบ Plesk',

    'migration__task_keep_in_process' => 'ตกลง',
    'migration__task_keep_in_process_conhelp' => 'กลับไปที่เครื่องมือ & หน้าการตั้งค่า การย้ายข้อมูลจะดำเนินการต่อในพื้นหลัง',

    'ui__admin-alias-info__description' => "แก้ไขข้อมูลผู้ติดต่อของบัญชีผู้ดูแลระบบเพิ่มเติม",
    'ui__admin-alias-info__short-title' => "ข้อมูลการติดต่อ",
    'ui__admin-alias-info__title' => "ข้อมูลบัญชีผู้ดูแลระบบเพิ่มเติม",
    'ui__admin-alias-password__description' => "เปลี่ยนแปลงรหัสผ่านของผู้ดูแลระบบเพิ่มเติม",

    'ui__admin-alias-password__short-title' => "เปลี่ยนรหัสผ่าน",
    'ui__admin-alias-password__title' => "รหัสผ่านของผู้ดูแลระบบเพิ่มเติม",
    'ui__admin-alias__description' => "ดูและเปลี่ยนข้อมูลบัญชีผู้ดูแลระบบเพิ่มเติม",

    'chk_js__warning_about_login_syntax' => "คุณสามารถใช้ตัวเลขและตัวอักษรตัวเล็ก ขีด และ ขีดล่างในชื่อผู้ใช้ได้ ชื่อผู้ใช้ต้องขึ้นต้นด้วยตัวอักษร รหัสผ่านต้องไม่มีชื่อผู้ใช้และเครื่องหมายคำพูด",
    'chk_js__warning_about_ftp_login_syntax' => "คุณสามารถใช้ตัวเลขและตัวอักษร ขีด และ ขีดล่างในชื่อผู้ใช้ได้",
    'chk_js__warning_about_login_syntax_win' => "คุณสามารถใช้ตัวเลขและตัวอักษรตัวเล็ก ขีด จุด และ ขีดล่างในชื่อผู้ใช้ได้ ชื่อผู้ใช้ต้องขึ้นต้นด้วยตัวอักษรหรือตัวเลข รหัสผ่านต้องไม่มีชื่อผู้ใช้และเครื่องหมายคำพูด",
    'chk_js__warning_about_passwd_syntax' => "ห้ามใช้เครื่องหมายคำพูด ช่องว่างและตัวอักษรประจำชาติในรหัสผ่าน \nรหัสผ่านควรมีความยาวระหว่าง %1 ถึง %2 ตัวอักษร และไม่ควรมีชื่อผู้ใช้อยู่.",
    'chk_js__warning_about_plesk_login_syntax' => "คุณสามารถใช้ตัวเลขและตัวอักษรตัวเล็ก จุด ขีด และ ขีดล่างในชื่อผู้ใช้ได้",
    'chk_js__warning_about_plesk_login_syntax_win' => "คุณสามารถใช้ตัวเลขและตัวอักษรตัวเล็ก ขีด และ ขีดล่างในชื่อผู้ใช้ได้ ชื่อผู้ใช้ต้องขึ้นต้นด้วยตัวอักษร",
    'chk_js__warning_about_plesk_passwd_syntax' => "ห้ามใช้เครื่องหมายคำพูด ช่องว่างและตัวอักษรประจำชาติในรหัสผ่าน \n รหัสผ่านควรมีความยาวระหว่าง %1 ถึง %2 ตัวอักษรและไม่ควรมีชื่อผู้ใช้อยู่.",
    'chk_js__warning_about_pam_passwd_error' => "บัญชีผู้ใช้ในระบบที่ผิดได้รับการระบุ: %1",

    'cmd_server__admin_alias_not_found' => "ไม่สามารถหาบัญชีผู้ดูแลระบบเพิ่มเติมพบ",

    'panel_branding__skins_already_exists' => "หมายเหตุ: มีธีม '%1' อยู่แล้ว จะแทนที่ด้วยธีมที่คุณกำลังติดตั้งในปัจจุบัน",
    'panel_branding__skins_file_exists' => "ไม่สามารถสร้างไดเร็กทอรี่สำหรับธีมได้ '%1': มีไฟล์ชื่อนี้อยู่แล้ว",

    'actionlog__login_failed' => 'การเข้าสู่ระบบล้มเหลว',
    'actionlog__event_cp_user_login_failed' => 'ผู้ใช้ Plesk ไม่สามารถล็อกอินได้',
    'actionlog__api_login_failed' => 'การล็อกอินผ่าน API ล้มเหลว',
    'actionlog__event_cp_user_api_login_failed' => 'การล็อกอินของผู้ใช้ Plesk ผ่าน API ล้มเหลว',
    'actionlog__pw_reset' => 'ร้องขอการรีเซตรหัสผ่านแล้ว',
    'actionlog__pw_admin_force_reset' => 'ขอให้บังคับรีเซ็ตรหัสผ่านของผู้ดูแลระบบ',

    'ch_pass_admin__email_subject' => "ตัวแจ้งเตือนรหัสผ่านของ Plesk",
    'ch_pass_admin__email_body' => "สวัสดี %1.\n\nห้ามส่งรหัสผ่านของผู้ดูแลระบบผ่านอีเมลเพื่อเหตุผลด้านความปลอดภัย\n\nหากต้องการล็อกอินในฐานะ 'admin' ให้ใช้คำสั่ง 'plesk login'\n\nหากต้องการตั้งค่า 'รหัสผ่าน admin'' ใหม่ให้ใช้คำสั่ง the 'plesk bin admin --set-password -passwd <new_password>'\n\n",
    'ch_pass_admin__message_send_error' => 'ไม่สามารถส่งอีเมลได้: %1',

    'ch_pass_by_secret__email_subject' => "ตัวแจ้งเตือนรหัสผ่านของ Plesk",
    'ch_pass_by_secret__email_body' => "สวัสดี %2\n\nหากต้องการตั้งค่ารหัสผ่านใหม่ โปรดทำตามลิงก์: %1\n\nข้อมูลการลงชื่อเข้าใช้ของคุณ: %3",
    'ch_pass_by_secret__message_send_error' => 'ไม่สามารถส่งรหัสลับ: %1',
    'ch_pass_by_secret__title' => 'เปลี่ยนรหัสผ่านของคุณ',
    'ch_pass_by_secret__secret' => 'รหัสลับ',

    'custom_button__noframe' => "ไม่ใช้เฟรม",

    'custom_button__internal_hint' => 'ระบุว่าจะเปิด URL ในหน้า Plesk หรือในหน้าต่างเบราเซอร์ใหม่',
    'custom_button__noframe_hint' => 'หากคุณเพิ่มปุ่มแบบกำหนดเองที่จะนำไปยังส่วนขยาย Plesk หรือแอพในแผงการจัดการลูกค้า คุณสามารถระบุวิธีการแสดงแอพ/ส่วนขยายนี้ได้: ในเฟรมหรือเป็นส่วนหนึ่งของ Plesk GUI',


    'actionlog__patch' => 'อัพเดต',
    'actionlog__patch_available' => 'มี',
    'actionlog__event_patch_available' => 'มีอัพเดตพร้อมใช้งาน',
    'actionlog__patch_installed' => 'ติดตั้งแล้ว',
    'actionlog__event_patch_installed' => 'ติดตั้งอัพเดต',

    'actionlog__extension' => 'ส่วนขยาย',
    'actionlog__extension_status' => 'สถานะของส่วนขยาย',
    'actionlog__cloning' => 'การโคลนเซิร์ฟเวอร์',
    'actionlog__cloning_complete' => 'สมบูรณ์',
    'actionlog__event_cloning_complete' => 'การโคลนเซิร์ฟเวอร์เสร็จสมบูรณ์',

    'actionlog__ssl_web_binding' => 'ใบรับรอง SSL/TLS บนโดเมน',
    'actionlog__ssl_web_binding_update' => 'มอบหมาย/ยกเลิกการมอบหมายแล้ว',
    'actionlog__event_ssl_web_binding_update' => 'มอบหมาย/ยกเลิกการมอบหมายใบรับรอง SSL/TLS บนโดเมนแล้ว',

    'actionlog__ssl_web_mail_binding' => 'ใบรับรอง SSL/TLS บนเว็บเมล',
    'actionlog__ssl_web_mail_binding_update' => 'มอบหมาย/ยกเลิกการมอบหมายแล้ว',
    'actionlog__event_ssl_web_mail_binding_update' => 'มอบหมาย/ยกเลิกการมอบหมายใบรับรอง SSL/TLS บนเมลเว็บเมลแล้ว',

    'actionlog__ssl_mail_binding' => 'ใบรับรอง SSL/TLS บนเมลเซิร์ฟเวอร์',
    'actionlog__ssl_mail_binding_update' => 'มอบหมาย/ยกเลิกการมอบหมายแล้ว',
    'actionlog__event_ssl_mail_binding_update' => 'มอบหมาย/ยกเลิกการมอบหมายใบรับรอง SSL/TLS บนเมลเซิร์ฟเวอร์แล้ว',

    'actionlog__ssl_panel_binding' => 'ใบรับรอง SSL/TLS บน Plesk',
    'actionlog__ssl_panel_binding_update' => 'มอบหมาย/ยกเลิกการมอบหมายแล้ว',
    'actionlog__event_ssl_panel_binding_update' => 'มอบหมาย/ยกเลิกการมอบหมายใบรับรอง SSL/TLS บน Plesk แล้ว',

    'actionlog__hostname' => 'ชื่อโฮสต์ของเซิร์ฟเวอร์',
    'actionlog__hostname_changed' => 'เปลี่ยนแล้ว',

    'actionlog__smb_user' => 'ผู้ใช้เพิ่มเติม',
    'actionlog__smb_user_create' => 'สร้างผู้ใช้เพิ่มเติมแล้ว',
    'actionlog__smb_user_delete' => 'ลบผู้ใช้เพิ่มเติมแล้ว',
    'actionlog__smb_user_update' => 'อัปเดตผู้ใช้เพิ่มเติมแล้ว',

    'actionlog__event_mail_management_status_update' => 'อัปเดตสถานะการจัดการเมล',
    'actionlog__mail_management' => 'สถานะการจัดการเมล',
    'actionlog__mail_management_status_update' => 'อัพเดทแล้ว',

    'virtualization_openvz' => 'OpenVZ',

    '__domains_total' => 'ทั้งหมดโดยโดเมน',

    'chk_js__warning_about_admin_passwd_syntax' => "ห้ามใช้เครื่องหมายคำพูด ช่องว่าง เซมิโคลอน และตัวอักษรประจำชาติในรหัสผ่าน\nรหัสผ่านต้องยาว %1 และ %2 ตัวอักษร และไม่ควรมีชื่อผู้ใช้อยู่",

    'passwordSecurityLevelCheckFailed' => 'รหัสผ่านไม่ซับซ้อนพอ ตามนโยบายของเซิร์ฟเวอร์ ความแข็งแรงของรหัสผ่านที่น้อยที่สุดคือ %1 เพื่อเพิ่มความแข็งแรงของรหัสผ่านให้ใช้หมายเลข ตัวอักษรเล็กใหญ่ และตัวอักษรพิเศษ เช่น !,@,#,$,%,^,&,*,?,_,~',
    'passwordSecurityLevelCheckFailedVeryWeak' => 'อ่อนแอมาก',
    'passwordSecurityLevelCheckFailedWeak' => 'อ่อนแอ',
    'passwordSecurityLevelCheckFailedMediocre' => 'ปานกลาง',
    'passwordSecurityLevelCheckFailedStrong' => 'แข็งแรง',
    'passwordSecurityLevelCheckFailedStronger' => 'แข็งแรงมาก',

    'ui__client/domain/dns/sync__description' => 'ใช้งานการเปลี่ยนแปลงจากแม่แบบ DNS เซิร์ฟเวอร์ทั้งหมดไปที่โซน',
    'ui__client/domain/dns/sync__disabled-warning' => 'ไม่สามารถใช้การเปลี่ยนแปลงแม่แบบ DNS ในโซนได้เนื่องจากมีการใช้งานโซนนี้ในเซิร์ฟเวอร์ DNS อื่นแล้ว',
    'ui__client/domain/dns/sync__short-title' => 'ใช้งานการเปลี่ยนแปลงแม่แบบ DNS',
    'ui__client/domain/dns/sync__done' => 'นำการเปลี่ยนแปลงจากแม่แบบ DNS ไปใช้ในโซนสำเร็จแล้ว',
    'ui__client/domain/domain-alias/dns/sync__description' => 'ใช้งานการเปลี่ยนแปลงจากแม่แบบ DNS เซิร์ฟเวอร์ทั้งหมดไปที่โซน',
    'ui__client/domain/domain-alias/dns/sync__disabled-warning' => 'ไม่สามารถใช้การเปลี่ยนแปลงแม่แบบ DNS ในโซนได้เนื่องจากมีการใช้งานโซนนี้ในเซิร์ฟเวอร์ DNS อื่นแล้ว',
    'ui__client/domain/domain-alias/dns/sync__short-title' => 'ใช้งานการเปลี่ยนแปลงแม่แบบ DNS',
    'ui__client/domain/domain-alias/dns/sync__done' => 'นำการเปลี่ยนแปลงจากแม่แบบ DNS ไปใช้ในโซนสำเร็จแล้ว',
    'dns__dns_default_ipv4_modified' => 'การบันทึกโดยใช้ IP แอดเดรสนี้จะได้รับการพิจารณาในฐานะผู้ใช้ที่มีการแก้ไข และจะไม่สามารถประสานงานกับแม่แบบ DNS ทั้งเซิร์ฟเวอร์ได้',
    'dns__dns_default_ipv6_modified' => 'การบันทึกโดยใช้ IP แอดเดรสนี้จะได้รับการพิจารณาในฐานะผู้ใช้ที่มีการแก้ไข และจะไม่สามารถประสานงานกับแม่แบบ DNS ทั้งเซิร์ฟเวอร์ได้',

    'dns__view_dns_record_master_title' => 'การดูบันทึกทรัพยากร',
    'dns__view_dns_record_off_title' => 'การดูบันทึกเซิร์ฟเวอร์ชื่อ',
    'dns__view_dns_record_slave_title' => 'การดูบันทึกเซิร์ฟเวอร์ DNS หลัก',

    'dns_unable_to_resolve_hostname' => "ไม่สามารถแก้ไขชื่อโฮสต์ \"%1\": %2โปรดตรวจอบให้แน่ใจว่าได้ตั้งค่าตัวแก้ไข DNS อย่างเหมาะสมและมีการทำงานอย่างถูกต้อง",

    'no_database_server_available' => 'ไม่มีเซิร์ฟเวอร์ฐานข้อมูลสำหรับการสมัครนี้',

    'database_used_by_application_can_not_be_moved' => 'ไม่สามารถย้ายฐานข้อมูลได้: การใช้งานเว็บไซต์ใช้ฐานข้อมูลนี้',
    'database_user_update_orphaned_is_restricted' => 'ไม่อนุญาตให้ทำการอัพเดตบัญชีฐานข้อมูลที่ถอนออกไปแล้ว คุณสามารถทำได้แค่ลบหรือซ่อมแซมเท่านั้น',

    'database_unable_to_get_max_filesize_default_message' => 'ไม่สามารถกำหนดขนาดไฟล์สูงสูดของฐานข้อมูลได้: \'%1\'',
    'database_unable_to_set_max_filesize_default_message' => 'ไม่สามารถตั้งขนาดไฟล์สูงสูดของฐานข้อมูลได้: \'%1\'',
    'database_unable_to_get_max_log_filesize_default_message' => 'ไม่สามารถกำหนดขนาดไฟล์บันทึกสูงสูดของฐานข้อมูลได้: \'%1\'',
    'database_unable_to_set_max_log_filesize_default_message' => 'ไม่สามารถตั้งขนาดไฟล์บันทึกสูงสูดของฐานข้อมูลได้: \'%1\'',

    'database_unable_to_get_max_filesize' => 'ไม่สามารถกำหนดขีดจำกัดปัจจุบันของขนาดไฟล์ฐานข้อมูล Microsoft SQL \'%1\' ได้ ไม่สามารถทำการตั้งค่าขีดจำกัดใหม่ได้',
    'database_unable_to_set_max_filesize' => 'ไม่สามารถตั้งขีดจำกัดขนาดไฟล์ของฐานข้อมูล Microsoft SQL ได้\'%1\'',
    'database_unable_to_get_max_log_filesize' => 'ไม่สามารถกำหนดขีดจำกัดปัจจุบันของขนาดไฟล์บันทึกฐานข้อมูล Microsoft SQL \'%1\' ได้ ไม่สามารถทำการตั้งค่าขีดจำกัดใหม่ได้',
    'database_unable_to_set_max_log_filesize' => 'ไม่สามารถตั้งขีดจำกัดขนาดไฟล์ของฐานข้อมูล Microsoft SQL ได้ \'%1\'',

    'database_unable_to_create_because_max_filesize' => 'ไม่สามารถสร้างฐานข้อมูล Microsoft SQL \'%1\': ขนาดไฟล์ของฐานข้อมูลนั้นมากกว่าขนาดสูงสุดที่อนุญาตให้ใช้',
    'database_unable_to_move_because_max_filesize' => 'ไม่สามารถย้ายฐานข้อมูล Microsoft SQL \'%1\': ขนาดไฟล์ของฐานข้อมูลนั้นมากกว่าขนาดสูงสุดที่อนุญาตให้ใช้: %2.',
    'database_unable_to_create_because_max_log_filesize' => 'ไม่สามารถสร้างฐานข้อมูล Microsoft SQL \'%1\': ขนาดไฟล์บันทึกของฐานข้อมูลนั้นมากกว่าขนาดสูงสุดที่อนุญาตให้ใช้',
    'database_unable_to_move_because_max_log_filesize' => 'ไม่สามารถย้ายฐานข้อมูล Microsoft SQL \'%1\': ขนาดไฟล์บันทึกของฐานข้อมูลนั้นมากกว่าขนาดสูงสุดที่อนุญาตให้ใช้: %2.',
    'database_unable_to_restore_because_max_filesize' => 'ไม่สามารถกู้คืนฐานข้อมูล Microsoft SQL \'%1\': ขนาดไฟล์ของฐานข้อมูลนั้นมากกว่าขนาดสูงสุดที่อนุญาตให้ใช้',

    'sandbox_mssql_server_registered_as_usual_db_server' => 'มีผู้ลงทะเบียนเซิร์ฟเวอร์ MS SQL แบบเดียวกันแล้วใน Plesk โปรดระบุเซิร์ฟเวอร์ MS SQL อื่นเป็นหลุมทรายแทน',
    'database_server__mssql_server_registered_as_sandbox' => 'มีผู้ลงทะเบียนเซิร์ฟเวอร์ MS SQL หลุมทรายแบบเดียวกันแล้วใน Plesk โปรดระบุเซิร์ฟเวอร์ MS SQL อื่นเป็นหลุมทรายแทน',

    'database_server_mysql_unable_to_connect_via_cli' => 'ไม่สามารถเชื่อมต่อกับเซิร์ฟเวอร์ผ่าน \'%1\': %2',

    'bu_conflict_resolver_feature_not_available' => 'ไม่สนับสนุนคุณสมบัติ %1 ในโหนดบริการต่อไปนี้: %2. ปิดใช้งานคุณสมบัตินี้สำหรับออบเจ็กต์ที่สร้างบนโหนดเหล่านี้',
    'bu_conflict_resolver_feature_not_available_single_server' => 'เซิร์ฟเวอร์นี้ไม่สนับสนุนคุณสมบัติ %1 ปิดใช้งานคุณสมบัติสำหรับออบเจ็กต์ที่กู้คืนมาทั้งหมด',
    'bu_conflict_resolver_component_unavailable_in_sites' => 'ยังไม่มีการติดตั้งคอมโพเนนท์ %1 ไม่พร้อมใช้งานในเว็บไซต์ดังต่อไปนี้: {{objects}}',
    'bu_conflict_resolver_component_replaced_in_sites' => 'ยังไม่มีการติดตั้งคอมโพเนนท์ %1 แทนที่เว็บไซต์ต่อไปนี้ได้ด้วย %2 : {{objects}}',

    'bu_conflict_resolver_restoration_of_object_end_to_dot_not_supported' => 'เวอร์ชั่น Plesk ปัจจุบันไม่สนับสนุนชื่อผู้ใช้ที่มีช่วงตัวอักษรนี้ (.) ลูกค้าและตัวแทนจำหน่ายที่มีชื่อผู้ใช้แบบนั้นจะไม่สามารถกู้คืนได้',
    'bu_conflict_resolver_unable_to_find_backup_part' => 'ไม่สามารถหาไฟล์สำรองข้อมูลที่มีข้อมูลของ %1 %2 พบจึงไม่มีการสำรองข้อมูลของ %1 %2',

    'bu_conflict_resolver_zone_master_removed' => "ไม่สามารถกู้คืนบันทึก DNS หลัก: การบันทึกในโซนรองบ่งชี้ไปยัง IP แอดเดรส %1 ที่มีอยู่ จะมีการลบบันทึก DNS หลักออกจากโซนรอง",

    'bu_conflict_resolver_not_available_scripting' => 'ไม่สนับสนุน %1',
    'bu_conflict_resolver_not_available_scripting_in_sites' => 'ไม่สนับสนุน %1 ไม่พร้อมใช้งานในเว็บไซต์ดังต่อไปนี้: {{objects}}',
    'bu_conflict_resolver_not_available_component' => 'ยังไม่มีการติดตั้งคอมโพเนนท์ %1',
    'bu_conflict_resolver_disabled_in_multi_server' => 'ไม่พร้อมใช้งานในโหนดการบริการต่อไปนี้: {{objects}}',
    'bu_conflict_resolver_disabled_in_single_server' => 'ไม่พร้อมใช้งานในอ็อบเจกต์ดังต่อไปนี้: {{objects}}',
    'bu_conflict_resolver_not_available_db' => 'ไม่มีเซิร์ฟเวอร์ฐานข้อมูลต่อไปนี้อยู่บนเซิร์ฟเวอร์: %1.',

    'bu_conflict_resolver_mssql_native_dump_restore_not_available' => 'ระบบจัดเก็บไฟล์สำรองข้อมูลในฐานข้อมูล MS SQL ไว้ในรูปแบบ MS SQL ดั้งเดิม ซึ่งสามารถกู้คืนไปที่เซิร์ฟเวอร์ MS SQL ในระบบหรือเซิร์ฟเวอร์ MS SQL ระยะไกลด้วยการตั้งค่าการสำรองข้อมูลที่กำหนดมาอย่างเต็มรูปแบบได้เท่านั้น ไม่สามารถกู้คืนฐานข้อมูลบางฐานข้อมูลของคุณได้ เนื่องจากไม่มีเซิร์ฟเวอร์ MS SQL ที่เหมาะสมลงทะเบียนใน Plesk มีผลกระทบต่อโดเมนดังต่อไปนี้: {{objects}} โปรดติดต่อผู้ให้บริการโฮสติ้งของคุณ',

    'bu_conflict_resolver_not_available_webmail' => 'ไม่สามารถใช้บริการเว็บเมล %1 ได้ แทนที่ออบเจ็กต์ต่อไปนี้ได้ด้วย %2 : {{objects}}',
    'bu_conflict_resolver_not_available_webmail_plan' => 'ไม่สามารถใช้บริการเว็บเมล %1 ได้ แทนที่แผนการบริการต่อไปนี้ได้ด้วย %2 : {{objects}}',
    'bu_conflict_resolver_not_available_rename_db_user' => "ฐานข้อมูลของประเภท '%1' ไม่สนับสนุนชื่อผู้ใช้ที่ตรงกับชื่อฐานข้อมูล ผู้ใช้ '%2' จะเปลี่ยนชื่อ '%3' สำหรับฐานข้อมูล '%4'",

    'bu_conflict_resolver_wrong_hard_quota_value' => 'ไม่มีการตั้งค่าขีดจำกัดในการใช้พื้นที่ดิสก์ในการกำหนดค่าเซิร์ฟเวอร์ปลายทาง ไม่มีการเปลี่ยนค่าของการตั้งค่านี้ไปยัง "ไม่จำกัด"',
    'bu_conflict_resolver_wrong_max_connections_value' => 'ไม่มีการตั้งค่าขีดจำกัดปริมาณการเชื่อมต่อในการกำหนดค่าเซิร์ฟเวอร์ปลายทาง ไม่มีการเปลี่ยนค่าของการตั้งค่านี้ไปยัง "ไม่จำกัด"',
    'bu_conflict_resolver_wrong_traffic_bandwidth_value' => 'ไม่มีการตั้งค่าขีดจำกัดในการใช้การรับส่งข้อมูลการกำหนดค่าเซิร์ฟเวอร์ปลายทาง ไม่มีการเปลี่ยนค่าของการตั้งค่านี้ไปยัง "ไม่จำกัด"',
    'cu__pleskrestore_backup_file_extracted' => 'ตัดทอนไฟล์สำรองข้อมูลไปยัง "%1" แล้ว',
    '__mod_bw_not_supported' => 'ไม่สนับสนุนโมดูล mod_bw สำหรับเว็บเซิร์ฟเวอร์ Apache เนื่องจากการกำหนดค่าของระบบไฟล์ ข้อจำกัดในการใช้งานการรับส่งข้อมูลและจำนวนสูงสุดของการเชื่อมต่อจะไม่ทำงาน',
    'bu_conflict_resolver_pop3_only_relay_auth_not_supported' => 'การอนุญาต POP3 สำหรับการถ่ายทอดเมลไม่ได้รับการสนับสนุน จะไม่มีการใช้ POP3 แทนก่อนการอนุญาต SMTP ({{objects}})',
    'bu_conflict_resolver_service_plan_name' => 'แผนการบริการ \'%1\'',
    'bu_conflict_resolver_replaced_in_plans' => 'ไม่สนับสนุน %1 แทนที่แผนการบริการต่อไปนี้ได้ด้วย %2 : {{objects}}',
    'bu_conflict_resolver_replaced_in_sites' => 'ไม่สนับสนุน %1 แทนที่เว็บไซต์ต่อไปนี้ได้ด้วย %2 : {{objects}}',
    'bu_conflict_resolver_absent_objects_in_dump' => 'ไม่พบออบเจ็กต์ต่อไปนี้ในไฟล์สำรองข้อมูล: %1',
    'bu_conflict_resolver_absent_domains' => 'ออบเจ็กต์บางอย่างไม่สามารถกู้คืนได้เพราะเป็นของโดเมนดังต่อไปนี้ที่หาไม่พบใน Plesk %1',
    'bu_conflict_resolver_absent_parent_domains' => "บางเว็บไซต์ไม่สามารถกู้คืนได้เพราะเป็นของโดเมนหลักดังต่อไปนี้ที่หาไม่พบใน Plesk\n%1",
    'bu_conflict_resolver_dns_not_supported' => 'ไม่สามารถกู้คืน DNS โซน: ปิดบริการ DNS ในการกำหนดค่าเซิร์ฟเวอร์',
    'bu_conflict_resolver_mail_not_supported' => 'ไม่สามารถกู้คืนกล่องจดหมาย: ปิดบริการเมลในการกำหนดค่าเซิร์ฟเวอร์',
    'bu_conflict_resolver__cpu_limit_action_not_supported' => 'การทำงานตามขีดจำกัด CPU ที่ระบุไม่ได้รับการสนับสนุนจากเซิร์ฟเวอร์เว็บ IIS จะมีการตั้งค่าใหม่ไปที่ %1',
    'bu_conflict_detector_server_ssl_cert_name' => 'เซิร์ฟเวอร์การรับรอง SSL/TLS %1',
    'bu_conflict_detector_domain_ssl_cert_name' => 'การรับรอง SSL/TLS %2 ของโดเมน %1',
    'bu_conflict_detector_ssl_cert_name' => 'การรับรอง SSL/TLS %1',
    'bu_conflict_resolver_absent_objects' => 'เนื้อหาของออบเจ็กต์ต่อไปนี้ไม่สามารถกู้คืนได้เพราะไม่พบออบเจ็กต์ใน Plesk: %1',
    'bu_conflict_resolver_absent_objects_mailuser' => 'เนื้อหาของกล่องจดหมายต่อไปนี้ไม่สามารถกู้คืนได้เพราะไม่พบกล่องจดหมายใน Plesk: %1',
    'bu_conflict_resolver_absent_objects_maillist' => 'เนื้อหาของรายการจดหมายต่อไปนี้ไม่สามารถกู้คืนได้เพราะไม่พบรายการจดหมายใน Plesk: %1',
    'bu_conflict_resolver_absent_objects_database' => 'เนื้อหาของฐานข้อมูลต่อไปนี้ไม่สามารถกู้คืนได้เพราะไม่พบฐานข้อมูลใน Plesk: %1',
    'bu_conflict_resolver__remove_conflicted_aps_app' => 'การกู้คืนแอพพลิเคชั่น "%1" ใน "%2" ล้มเหลวเนื่องจากติดตั้งแอพพลิเคชั่นอื่นใน "%3" แล้ว คุณสามารถลบแอพพลิเคชั่นที่ติดตั้งแล้วลองอีกครั้ง',
    'bu_conflict_resolver_not_available_mail_autoresponders' => 'ไม่รองรับฟังก์ชั่นการตอบกลับเมลอัตโนมัติ',
    'bu_conflict_resolver_not_available_mail_content' => 'ไม่รองรับการกู้คืนเนื้อหาเมล',
    'bu_conflict_resolver_invalid_mail_name' => 'กล่องจดหมายต่อไปนี้ไม่ได้รับการกู้คืนเนื่องจากมีการเปิดใช้ที่อยู่อีเมลย่อยและที่อยู่บางบัญชีประกอบด้วยสัญลักษณ์ "%1": %2',
    'bu_conflict_resolver_invalid_user_name' => 'ผู้ใช้งานต่อไปนี้ไม่ได้รับการกู้คืนเนื่องจากมีการเปิดใช้ที่อยู่อีเมลย่อยและที่อยู่บางบัญชีประกอบด้วยสัญลักษณ "%1": %2์',
    'bu_conflict_resolver_licenses_expired' => 'ใบอนุญาตใช้งานต่อไปนี้หมดอายุแล้วและจะไม่ได้การกู้คืน: {{objects}}',
    'bu_conflict_resolver_licenses_invalid' => 'ใบอนุญาตใช้งานต่อไปนี้ใช้งานไม่ได้หรือหมดอายุแล้วและจะไม่ได้การกู้คืน: {{objects}}',
    'expiration_unsupported' => "ไม่สนับสนุนขีดจำกัด 'การหมดอายุ'",

    'component_name__dbconnector' => "ตัวเชื่อมต่อฐานข้อมูล",
    'component_name__mysqlserver' => 'เซิร์ฟเวอร์ MySQL',
    'component_name__troubleshooting' => 'การแก้ไขปัญหา',
    'component_name__savi' => 'อินเทอร์เฟซ Sophos Anti-Virus',

    '__subscription_has_no_license_key' => 'ทรัพยากรสำหรับการสมัครสมาชิกที่จัดให้โดยโหนดบริการ #%1 ที่ไม่้มีรหัสลิขสิทธิ์ที่เกี่ยวข้อง',
    '__subscription_has_expired_license_key' => 'ทรัพยากรสำหรับการสมัครสมาชิกที่จัดให้โดยโหนดบริการ #%1 ที่มีรหัสลิขสิทธิ์ %2 หมดอายุแล้ว',

    '__cfgmonConfigurationFileSaveErrorSubject' => '<%%host%%> ไม่สามารถบันทึกการกำหนดค่าไฟล์ได้',
    '__cfgmonConfigurationFileSaveErrorBody' => "ไม่สามารถบันทึกการกำหนดค่าไฟล์บนโฮสต์ <%%host%%>: มีข้อผิดพลาดต่อไปนี้เกิดขึ้น:\n\n%%errors%%",

    'mail__enable_email_subaddressing_cli_desc' => 'ทางเลือกนี้ช่วยให้สามารถตั้งค่าที่อยู่อีเมลแบบ VERP สำหรับบัญชีอีเมลได้ ้',
    'mail__enter_right_ip_mask' => "ป้อนค่า IP มาสก์ระหว่าง 1 ถึง 32",
    'mail__enter_right_ip_mask_24' => "ป้อนค่า IP มาสก์ระหว่าง 24 ถึง 32",
    'mail__invalid_dom_name' => "ชื่อโดเมน %1 ไม่ถูกต้อง",
    'mail__invalid_pop_lock_time' => "เวลาล็อค POP3 ไม่ถูกต้อง",
    'mail__invalid_rbl_server' => "ชื่อโซน DNS ไม่ถูกต้อง",
    'mail__total_files_size' => "ขนาดที่จัดเก็บข้อมูลข้อมูล: %1",
    'mail__filename_already_in_repository' => "ไฟล์ชื่อเดียวกันมีอยู่แล้วในที่เก็บ",
    'mail__no_white_list_mask_feature_24' => "ใช้ค่ามาส์กที่มีค่าเท่ากับ 24 หรือสูงกว่า\nเซิร์ฟเวอร์จดหมายของคุณไม่รองรับการตั้งค่ามาส์ก เราสามารถจำลองการตั้งค่ามาส์กได้เฉพาะค่าที่น้อยกว่า 24 เท่านั้น",
    'mail__unable_add_new_mail_name' => "ไม่สามารถเพิ่มบัญชีจดหมายได้: %1",
    'mail_server_is_not_installed' => 'ไม่มีการติดตั้งเซิร์ฟเวอร์จดหมาย (Postfix หรือ Qmail) โปรดติดตั้งเพื่อดำเนินงานต่อไป',
    'mail_server_not_available' => 'ไม่มีการสนับสนุนเซิร์ฟเวอร์เมลที่อยู่บนโหนดการบริการ',
    '__not_installed' => '(ยังไม่ได้ติดตั้ง)',
    'mail__service_node_outgoing_messages_is_disabled' => 'ปิดใช้งานตัวกรองสแปมบนข้อความอีเมลขาออก',
    'mail__service_node_does_not_support_outgoing_messages_domain_limit' => 'โหนดบริการไม่สนับสนุนการจำกัดปริมาณข้อความอีเมลขาออกจากโดเมนสำหรับโดเมน %1',
    'mail__service_node_does_not_support_outgoing_messages_mbox_limit' => 'โหนดบริการไม่สนับสนุนการจำกัดปริมาณข้อความอีเมลขาออกจากกล่องจดหมายสำหรับโดเมน %1',

    'mail__outgoing_email_mode_explicit_ip_unspecified' => 'ระบุที่อยู่อย่างน้อยหนึ่งประเภท (IPv4 หรือ IPv6)',

    'mail__outgoing_email_mode_invalid' => 'การระบุโหมดเมลขาออกไม่ถูกต้อง',
    'mail__outgoing_email_mode_explicit_ip_v4_invalid' => 'มีการระบุ IPv4 แอดเดรสที่ไม่ถูกต้อง',
    'mail__outgoing_email_mode_explicit_ip_v6_invalid' => 'มีการระบุ IPv6 แอดเดรสที่ไม่ถูกต้อง',
    'mail__outgoing_email_mode_unavailable' => 'ระบบไม่รองรับการเปลี่ยนโหมดสำหรับจดหมายขาออก เนื่องจากไม่ได้ติดตั้งเมลเซิร์ฟเวอร์ Postfix บนเซิร์ฟเวอร์เครื่องนี้',

    'mail__autoresponder_attachment_not_supported' => 'เซิร์ฟเวอร์เมลที่ใช้อยู่ในปัจจุบันไม่รองรับการจัดการรายการแนบสำหรับตัวตอบรับอัตโนมัติ',

    'mail__smtp_white_list_not_supported' => 'เซิร์ฟเวอร์เมลที่ใช้งานอยู่ในปัจจุบันไม่รองรับการอนุญาตรายการที่อยู่ IP',
    'mail__smtp_whitelist_cidr_not_supported' => 'เซิร์ฟเวอร์เมลที่ที่เลือกไว้ในปัจจุบันไม่รองรับมาสก์ CIDR โปรดระบุที่อยู่ IP ในรูปแบบ \'192.*.0.*\'',
    'mail__smtp_whitelist_mask_not_supported' => 'เซิร์ฟเวอร์เมลที่ที่เลือกไว้ในปัจจุบันไม่รองรับรูปแบบ IP แบบ Wildcard โปรดระบุที่อยู่ IP ในรูปแบบ \'192.0.0.0/8\'',

    'sfdk_server_wide_verify_failed' => 'ไม่สามารถเปลี่ยนการตั้งค่าสำหรับบริการตรวจสอบความถูกต้องของ DKIM',

    'sfdk_domain__serverwide_disabled' => 'ปิดการใช้นโยบายเซิร์ฟเวอร์',
    'feature__domainkeys__serverwide_disabled' => 'ปิดการป้องกันสแปม DKIM ทั่วทั้งเซิร์ฟเวอร์',

    'defaultcomponents__error_set_default' => 'ไม่สามารถตั้งค่า %1 ตามค่าเริ่มต้น %2: %3',
    'defaultcomponents__error_set_default_none' => 'ไม่สามารถตั้งค่าไม่มีคอมโพแนนท์เริ่มต้นสำหรับ %1: %2',
    'defaultcomponents__required_package_not_default' => 'จำเป็นต้องใช้คอมโพเนนท์ %1 สำหรับการทำงานที่ไม่ใช่ค่าเริ่มต้น',

    '__percentage' => '%',
    '__seconds' => 'วินาที',
    '__resource_remain' => 'เหลืออยู่',

    '__not_registered' => '(ไม่ได้ลงทะเบียน)',
    '__php_handler_id' => 'เวอร์ชั่น PHP',
    '__php_handler_id_string' => 'PHP %1 (%2)',
    '__php_handler_not_registered' => 'ไม่ได้ลงทะเบียนตัวจัดการ PHP "%1" อาจได้รับการลบออกจากเซิร์ฟเวอร์แล้ว ลงทะเบียนตัวจัดการด้วยคุณสมบัติเดียวกันและลองอีกครั้ง',
    '__php_handler_not_registered_on_domain' => 'โดเมน "%1": ไม่ได้ลงทะเบียนตัวจัดการ PHP "%2" อาจได้รับการลบออกจากเซิร์ฟเวอร์แล้ว ลงทะเบียนตัวจัดการด้วยคุณสมบัติเดียวกันและลองอีกครั้ง',
    '__php_fpm_handler' => 'โปรแกรม FPM',
    '__php_fpm-dedicated_handler' => 'แอพพลิเคชัน FPM เฉพาะ',

    'mailname_create_assigned_user_dublicate_error' => 'ไม่สามารถสร้างผู้ใช้สำหรับกล่องจดหมายได้ ผู้ใช้ที่มีชื่อผู้ใช้ %1 อยู่แล้วและมีกล่องจดหมายอื่น',
    'mailname_create_assigned_user_role_absent_error' => 'ไม่สามารถสร้างผู้ใช้สำหรับกล่องจดหมายได้ ไม่มีบทบาทเริ่มต้น %1 ของผู้ใช้อยู่',

    'gphd__mime_types' => 'ประเภท MIME',
    'gphd__handlers' => 'ตัวจัดการ Apache',
    'gphd__ip_restrictions_allow' => 'อนุญาตให้เข้าถึงเว็บไซต์สำหรับโฮสต์และเครือข่ายที่ระบุ (ไม่รวมเว็บที่ได้รับการปฏิเสธ)',
    'gphd__ip_restrictions_deny' => 'ปฏิเสธการเข้าถึงไซต์สำหรับโฮสต์และเครือข่ายที่ระบุ',
    'gphd__directory_index' => 'ไฟล์ดัชนี',
    'gphd__nginx_transparent_mode' => 'โหมด Apache จัดการทั้งเนื้อหาด้านสถิติและไดนามิค ในขณะที่ nginx ส่งผ่านคำร้องขอ HTTP และตอบสนองโดยไม่ทำการแก้ไขใดๆ',
    'gphd__nginx_serve_static' => 'เซิร์ฟไฟล์คงที่โดยตรงด้วย nginx',
    'gphd__nginx_static_extensions' => 'ส่วนขยายไฟล์สถิติที่ต้องจัดการโดย nginx',
    'gphd__nginx_serve_php' => 'ไฟล์การประมวลผล PHP โดย nginx',
    'gphd__www_root' => 'รูทไดเรกทอรี่ WWW',

    'eol__none' => 'ห้ามแก้ไข',
    'eol__lf' => 'แปลงเป็นรูปแบบ Unix',
    'eol__cr' => 'แปลงเป็นรูปแบบ MacOS',
    'eol__crlf' => 'แปลงเป็นรูปแบบ Windows',

    'ui__dns_bad_zone' => 'โซนที่ไม่สอดคล้องกัน "%1":',
    'ui__dns_ns_has_no_address_records' => 'บันทึก NS "%1" ไม่มีบันทึกที่อยู่ (A หรือ AAAA)',
    '__dns_bad_zone' => 'โซนที่ไม่สอดคล้องกัน "%1":',
    '__dns_ns_has_no_address_records' => 'บันทึก NS "%1" ไม่มีบันทึกที่อยู่ (A หรือ AAAA)',
    '__dns_ptr_is_wildcard' => 'บันทึก PTR "%1" ไม่ถูกต้อง: จุดเข้าใช้งานการบันทึกไปที่ตัวแทนโดเมน',

    'firewall_database_user_remote_access_rule_name' => '[%1][%2] อนุญาตให้เชื่อมต่อระยะไกลสำหรับผู้ใช้ฐานข้อมูล \'%3\' ของลูกค้า \'%4\'',
    'firewall_database_user_remote_access_rule_name_removed' => '[%1][%2] %3',
    'firewall_database_user_remote_access_mssql_server_port_undefined' => 'ไม่อนุญาตให้เชื่อมต่อระยะไกลกับผู้ใช้ฐานข้อมูล \'%1\': ไม่สามารถที่จะตรวจสอบหมายเลขพอร์ท TCP ที่ใช้งานโดยเซิร์ฟเวอร์ Microsoft SQL \'%2\' ได้ เหตุผลที่อาจเป็นไปได้มีดังต่อไปนี้: โปรโตคอล TCP/IP ไม่สามารถใช้งานในการกำหนดค่าเครือข่ายเซิร์ฟเวอร์หรือเซิร์ฟเวอร์ที่กำหนดค่าให้ใช้พอร์ท TCP ไดนามิค กำหนดค่าเซิร์ฟเวอร์ที่ฟังพอร์ท TCP ที่ได้รับการแก้ไขเฉพาะและพยายามเชื่อมต่อระยะไกลอีกครั้ง',

    'command__convertResellerHasCustomer' => 'บัญชีตัวแทนจำหน่าย \'%1\' มีบัญชีลูกค้าหนึ่งหรือหลากหลายบัญชี เพื่อแปลงบัญชีตัวแทนจำหน่ายนี้ไปเป็นบัญชีลูกค้า ก่อนอื่นต้องส่งต่อบัญชีลูกค้าไปยังเจ้าของใหม่หรือแปลงบัญชีไปเป็นบัญตัวแทนจำหน่าย',
    'command__convertResellerNotReseller' => 'เฉพาะบัญชีตัวแทนจำหน่ายเท่านั้นที่สามารถแปลงเป็นบัญชีลูกค้าได้ \'%1\' ไม่ใช่ตัวแทนจำหน่าย',
    'command__convertResellerToCustomerSubscriptionNotSynchronized' => 'ไม่สามารถซิงค์ข้อมูลการสมัครสมาชิกกับแผนบริการ การตั้งค่าดังต่อไปนี้ไม่ตรงกับแผนบริการ: %%problems%%',

    'moveCustomer__wrong_customer_type' => 'บัญชี \'%1\' เป็นบัญชีตัวแทนจำหน่าย บัญชีตัวแทนจำหน่ายไม่สามารถย้ายไปยังเจ้าของใหม่ได้เพราะผู้ดูแลระบบเซิร์ฟเวอร์เป็นเจ้าของอยู่แล้ว',
    'moveCustomer__wrong_owner_type' => "สามารถย้ายบัญชีลูกค้า '%1' ไปยังตัวแทนจำหน่ายหรือแอดมินได้เท่านั้น ไม่สามารถย้ายไปยังลูกค้ารายอื่นๆ ได้",
    'moveCustomer__customer_already_belongs_to_owner' => 'บัญชีลูกค้า \'%1\' เป็นของเจ้าของที่เลือกอยู่แล้ว',
    'upgradeClient__user_is_admin' => 'ไม่สามารถแปลงบัญชี \'%1\' เป็นบัญชีตัวแทนจำหน่ายได้เพราะเป็นบัญชีของผู้ดูแลระบบ',

    'mail__error_setting_max_connections_courier' => 'ไม่สามารถกำหนดจำนวนสูงสุดของการเชื่อมต่อ (IMAP POP3 IMAP ผ่าน SSL/TLS หรือ POP3 ผ่าน SSL/TLS): %1',
    'mail__error_setting_max_connections_dovecot' => 'ไม่สามารถกำหนดจำนวนสูงสุดของการเชื่อมต่อ (IMAP POP3 IMAP ผ่าน SSL/TLS หรือ POP3 ผ่าน SSL/TLS): %1',
    'mail__error_setting_max_connections_per_ip_courier' => 'ไม่สามารถกำหนดจำนวนสูงสุดของการเชื่อมต่อ (IMAP POP3 IMAP ผ่าน SSL/TLS หรือ POP3 ผ่าน SSL/TLS) ต่อ IP แอดเดรส: %1',
    'mail__error_setting_max_connections_per_ip_dovecot' => 'ไม่สามารถกำหนดจำนวนสูงสุดของการเชื่อมต่อ (IMAP POP3 IMAP ผ่าน SSL/TLS หรือ POP3 ผ่าน SSL/TLS) ต่อ IP แอดเดรสสำหรับผู้ใช้เมลที่ระบุ: %1',
    'outgoing_messages_limit_value_invalid' => 'ค่าต้องอยู่ระหว่างช่วง %%MIN%%..%%MAX%% ผู้ดูแลระบบ Plesk เท่านั้นที่สามารถปรับการตั้งค่านี้ได้',
    'outgoing_messages_server_settings_catch_address_are_not_local' => "โดเมนต่อไปนี้ใช้อีเมลแอดเดรสภายนอกเพื่อการส่งต่อเมลของเมลที่ส่งไปยังที่อยู่ที่ไม่มีอยู่จริง ข้อความที่ส่งไปยังที่อยู่เหล่านี้จะไม่นับรวมอยู่ในการควบคุมจดหมายขาออก:\n %1",
    'outgoing_messages_white_list_not_empty' => 'ขีดจำกัดของเมลขาออกจะไม่ทำงานสำหรับผู้ส่งเมลที่ IP แอดเดรสอยู่ในบัญชีที่ปลอดภัยของเซิร์ฟเวอร์เมล ตัวอย่างเช่น หากมีโฮสต์ในระบบ (127.0.0.0 / 8, ::1 / 128) อยู่ในบัญชีที่ปลอดภัย เมลทั้งหมดจากเซิร์ฟเวอร์ในระบบจะสามารถส่งได้โดยไม่มีการจำกัดปริมาณ ผู้ส่งเมลสามารถใช้ได้ทั้ง IP แอดเดรสในระบบ (เว็บไซต์และสคริปต์แบบกำหนดเองที่โฮสต์บนเซิร์ฟเวอร์ในระบบ) หรือนอกระบบ (ลูกค้าที่ส่งเมลจากเมลไคลเอนท์ที่ติดตั้งบนคอมพิวเตอร์หรืออุปกรณ์เคลื่อนที่) เพื่อทำให้การจำกัดใช้งานได้กับผู้ส่งเมลทุกคน (ทั้งในระบบและนอกระบบ) ต้องลบ IP แอดเดรสและเครือข่ายทั้งหมดจากบัญชีที่ปลอดภัย โปรดทราบว่าการลบโฮสต์ในระบบ (127.0.0.0 / 8, ::1 / 128) จากบัญชีที่ปลอดภัยอาจส่งผลกระทบต่อการดำเนินงานของเว็บไซต์และสคริปต์ที่ส่งเมลจากเซิร์ฟเวอร์นี้ สำหรับรายละเอียดเกี่ยวกับการจำกัดเมลขาออก ดูได้ที่คำแนะนำของผู้ดูแลระบบ การป้องกันจากสแปมขาออก',
    'outgoing_messages_relay_open' => 'การถ่ายโอนเมลเปิดอยู่: ขีดจำกัดของเมลขาออกจะไม่ทำงาน',

    'notification_aps_app_updates_available' => 'มีการอัพเดตใหม่สำหรับแอพพลิเคชั่นต่อไปนี้่:',
    'notification_aps_app_updates_installed' => 'ติดตั้งอัพเดตโดยอัตโนมัติสำหรับแอพพลิเคชั่นต่อไปนี้:',
    'notification_aps_app_updates_requirements' => 'มีการอัพเดตสำหรับแอพพลิเคชั่นดังต่อไปนี้ แต่ไม่สามารถติดตั้งได้เนื่องจากการตั้งค่าโฮสติ้งของเว็บไซต์ที่สอดคล้องกันไม่ตอบสนองความต้องการในการติดตั้ง:',
    'notification_admin_aps_app_updates_available_item' => '%%name%% (%%url%%) ติดตั้งเวอร์ชั่น: %%from%% เวอร์ชันที่มีอยู่: %%to%%',
    'notification_admin_aps_app_updates_available_plugin_item' => 'ปลั๊กอิน "%%name%%" บน %%parentName%% (%%url%%) ติดตั้งเวอร์ชั่น: %%from%% เวอร์ชันที่มีอยู่: %%to%%',
    'notification_admin_aps_app_updates_available_theme_item' => 'ธีม "%%name%%" บน %%parentName%% (%%url%%) ติดตั้งเวอร์ชั่น: %%from%% เวอร์ชันที่มีอยู่: %%to%%',
    'notification_reseller_aps_app_updates_available_item' => '%%name%% (%%url%%) ติดตั้งเวอร์ชั่น: %%from%% เวอร์ชันที่มีอยู่: %%to%%',
    'notification_reseller_aps_app_updates_available_plugin_item' => 'ปลั๊กอิน "%%name%%" บน %%parentName%% (%%url%%) ติดตั้งเวอร์ชั่น: %%from%% เวอร์ชันที่มีอยู่: %%to%%',
    'notification_reseller_aps_app_updates_available_theme_item' => 'ธีม "%%name%%" บน %%parentName%% (%%url%%) ติดตั้งเวอร์ชั่น: %%from%% เวอร์ชันที่มีอยู่: %%to%%',
    'notification_client_aps_app_updates_available_item' => '%%name%% (%%url%%) เวอร์ชั่นของคุณ: %%from%% เวอร์ชันที่มีอยู่: %%to%%',
    'notification_client_aps_app_updates_available_plugin_item' => 'ปลั๊กอิน "%%name%%" บน %%parentName%% (%%url%%) เวอร์ชั่นของคุณ: %%from%% เวอร์ชันที่มีอยู่: %%to%%',
    'notification_client_aps_app_updates_available_theme_item' => 'ธีม "%%name%%" บน %%parentName%% (%%url%%) เวอร์ชั่นของคุณ: %%from%% เวอร์ชันที่มีอยู่: %%to%%',
    'notification_admin_aps_app_updates_installed_item' => '%%name%% (%%url%%) เวอร์ชั่นใหม่: %%to%% เวอร์ชั่นก่อนหน้า: %%from%%',
    'notification_reseller_aps_app_updates_installed_item' => '%%name%% (%%url%%) เวอร์ชั่นใหม่: %%to%% เวอร์ชั่นก่อนหน้า: %%from%%',
    'notification_client_aps_app_updates_installed_item' => '%%name%% (%%url%%) เวอร์ชั่นใหม่: %%to%% เวอร์ชั่นก่อนหน้า: %%from%%',
    'notification_admin_aps_app_updates_requirements_item' => '%%name%% (%%url%%) ติดตั้งเวอร์ชั่น: %%from%% เวอร์ชันที่มีอยู่: %%to%%',
    'notification_reseller_aps_app_updates_requirements_item' => '%%name%% (%%url%%) ติดตั้งเวอร์ชั่น: %%from%% เวอร์ชันที่มีอยู่: %%to%%',
    'notification_client_aps_app_updates_requirements_item' => '%%name%% (%%url%%) เวอร์ชั่นของคุณ: %%from%% เวอร์ชันที่มีอยู่: %%to%%',
    'notification_aps_app_updates_no_installation_url' => 'แอพภายนอก',

    'notification_outgoing_mail_exceeded_limits_domains' => 'โดเมน',
    'notification_outgoing_mail_exceeded_limits_mails' => 'อีเมลแอดเดรส',
    'notification_outgoing_mail_exceeded_limits_subscriptions' => 'การสมัคร',
    'notification_outgoing_mail_exceeded_limits_limit_value' => '%1 ข้อความต่อชั่วโมง',
    'notification_outgoing_mail_exceeded_limits_limit_value_unlimited' => 'ไม่จำกัด',
    'notification_outgoing_mail_exceeded_limits_object' => '%1 ขีดจำกัดคือ %2',
    'notification_outgoing_mail_exceeded_limits_attempt' => '%1 ความพยายามที่จะใช้งานเกินขีดจำกัดจาก %2 ถึง %3',
    'notification_outgoing_mail_exceeded_limits_attempt_still_exceeding' => '%1 ความพยายามที่จะใช้งานเกินขีดจำกัดจาก %2 จนถึงตอนนี้',

    'restart__docker' => "Docker",
    'restart__fail2ban' => "การแบน IP แอดเดรส (Fail2ban)",

    'backup__restore__capability_fail2ban_not_installed_text' => 'ไม่มีการติดตั้งคอมโพเนนท์ Fail2ban บนเซิร์ฟเวอร์ปลายทาง',
    'backup__restore__capability_fail2ban_not_installed_resolution' => 'ติดตั้ง Fail2ban โปรดทราบว่าการดำเนินการอาจใช้เวลาสักครู่',

    'plesk_key__no_reseller_support' => 'คุณไม่สามารถจัดการกับตัวแทนจำหน่ายได้เนื่องจากข้อจำกัดสิทธิ์การใช้งาน',
    'plesk_key__no_customers_support' => 'คุณไม่สามารถจัดการกับลูกค้าได้เนื่องจากข้อจำกัดสิทธิ์การใช้งาน',
    'panel_interface_uimodes__service_provider_view_not_allowed' => 'ไม่สามารถสลับไปใช้มุมมองผู้ให้บริการได้เนื่องจากข้อจำกัดลิขสิทธิ์',
    'plesk_key__no_security_core_support' => 'คุณสมบัติหลักด้านความปลอดภัย (ModSecurity และ fail2ban) ไม่สามารถใช้ได้เนื่องจากข้อจำกัดสิทธิ์การใช้งาน',
    'plesk_key__outgoing-antispam' => 'ควบคุมเมลขาออก',
    'plesk_key__security-core' => 'การรักษาความปลอดภัยหลัก (ModSecurity และ Fail2Ban)',
    'plesk_key__can-manage-accounts' => 'การจัดการบัญชี',
    'plesk_key__can-manage-subscriptions' => 'การจัดการการสมัครใช้บริการ',
    'plesk_key__can-manage-customers' => 'การจัดการลูกค้า',
    'plesk_key__can-manage-resellers' => 'การจัดการตัวแทนจำหน่าย',
    'plesk_key__can-manage-custom-view' => 'ความพร้อมใช้งานโหมดจำกัดการใช้งาน',
    'plesk_key__limits_exceeded_no_subscriptions_management' => 'ปิดใช้งานการจัดการการสมัครแต่คุณมีการสมัครอีกมากมาย (%1)',
    'plesk_key__limits_exceeded_no_resellers_management' => 'ปิดใช้งานการจัดการตัวแทนจำหน่ายแต่คุณมีตัวแทนจำหน่ายอีกหลายราย (%1)',
    'plesk_key__limits_exceeded_no_customers_management' => 'ปิดใช้งานการจัดการลูกค้า แต่คุณมีลูกค้าอีกหลายราย (%1)',
    'plesk_key__limits_unlimited_subscriptions' => 'ทรัพยากรการสมัครสมาชิกบางประเภทที่คุณไม่สามารถจัดการในหน้าอินเทอร์เฟซ Plesk ได้แล้ว (เช่น การจำกัดกล่องจดหมายและพื้นที่เก็บข้อมูลของโดเมน) จะถูกตั้งค่าเป็นไม่จำกัดในตอนนี้',
    'plesk_key__no_subscriptions_support' => 'คุณไม่สามารถจัดการกับการสมัครได้เนื่องจากข้อจำกัดสิทธิ์การใช้งาน',
    'plesk_key__no_custom_view_support' => 'คุณไม่สามารถใช้โหมดจำกัดการใช้งานได้เนื่องจากข้อจำกัดสิทธิ์การใช้งาน',
    'plesk_key__trial_forbidden_region' => 'ขออภัย Plesk ไม่พร้อมใช้งานในภูมิภาคของคุณในขณะนี้',
    'additional_key__main_key' => 'รหัสนี้เป็นรหัสหลัก: คุณไม่สามารถอัพโหลดรหัสหลักมาใช้เป็นรหัสเสริมได้',

    'gch__hosting_waf_rule_engine' => 'โหมดไฟร์วอลล์แอพพลิเคชั่นเว็บ',

    'backup__fieldset__restoration_options' => 'ตัวเลือกการซ่อมแซม',
    'backup__restore_options__restore' => 'กู้คืน',
    'backup__restore_options__domain__domain_configuration' => 'การปรับตั้งค่าโดเมน',
    'backup__restore_options__domain__virtual_host_content' => 'เนื้อหาโฮสต์เสมือน',
    'backup__restore_options__domain__mail' => 'เมล',
    'backup__restore_options__domain__databases' => 'ฐานข้อมูล',
    'backup__restore_options__client__client_configuration' => 'การกำหนดค่าบัญชีลูกค้า',
    'backup__restore_options__client__domains' => "โดเมนของลูกค้า",
    'backup__restore_options__reseller__reseller_configuration' => 'การปรับตั้งค่าบัญชีตัวแทนจำหน่าย',
    'backup__restore_options__reseller__personal_domains' => "โดเมนของตัวแทนจำหน่าย",
    'backup__restore_options__reseller__clients' => "ลูกค้าของตัวแทนจำหน่าย",
    'backup__restore_options__admin__server_configuration' => 'การตั้งค่าเซิร์ฟเวอร์',
    'backup__restore_options__admin__administrator_configuration' => 'การปรับตั้งค่าบัญชีผู้ดูแลระบบ',
    'backup__restore_options__admin__personal_domains' => "โดเมนของผู้ดูแลระบบ",
    'backup__restore_options__admin__personal_clients' => "ลูกค้าของผู้ดูแลระบบ",
    'backup__restore_options__admin__resellers' => 'ตัวแทนจำหน่าย',

    'badge_new' => 'ใหม่',
    'upgrade_php_on_subscription' => 'อัพเกรด PHP บนการสมัครของคุณเป็นเวอร์ชั่น 5.3.0 หรือใหม่กว่า',

    'pkey_notify__body_expiration_notification' => 'รหัสลิขสิทธิ์หมดอายุแล้ว คุณลักษณะบางอย่างอาจยังไม่พร้อมใช้งาน โปรดติดต่อผู้ให้บริการโฮสติ้งของคุณ',

    'crontab__crontab_entry_exists' => "งานที่กำหนดมีอยู่แล้ว",
    'crontab__crontab_entry_not_exists' => "ไม่มีงานที่ระบุ",
    'crontab__invalid_values_found' => "ค่าพารามิเตอร์ไม่ถูกต้อง",
    'crontab__cmd_max_len' => "คำสั่งนี้จะต้องมีความยาวไม่เกิน %1 ตัวอักษร",

    'domain__domain_exists' => "มีโดเมนชื่อเดียวกันที่ขึ้นต้นด้วย 'www': %1.%2.",
    'domain__subdomain_exists' => "มีโดเมนย่อยชื่อเดียวกันที่ขึ้นต้นด้วย 'www': %1.%2.",
    'domain__dalias_exists' => "มีโดเมนนามแฝงชื่อเดียวกันที่ขึ้นต้นด้วย 'www': %1.%2.",
    'domain__record_exists' => "มีรายการ DNS ที่ชี้ไปยังโฮสต์ %1.%2.",

    'ip_addr__cannot_assign_certificate' => "ไม่สามารถตั้งค่าการรับรอง '%1' เป็นค่าเริ่มต้นได้: รหัสส่วนตัวหายไป",
    'ip_addr__update_dns_error' => 'เกิดปัญหาขึ้นในขณะที่ทำการอัพเดตที่อยู่ IP ในเขตข้อมูล DNS %1',
    'ip_addr__cannot_add_dhcp_enabled' => 'ไม่สามารถเพิ่ม IP แอดเดรสได้ อินเทอร์เฟสของเครือข่ายนี้จะได้รับ IP แอดเดรสโดยอัตโนมัติ',
    'ip_addr__cannot_remove_dhcp_enabled' => 'ไม่สามารถลบ IP แอดเดรส %1 ออกได้ อินเทอร์เฟสของเครือข่ายนี้จะได้รับ IP แอดเดรสโดยอัตโนมัติ',
    'ip_addr__cannot_repair_dhcp_enabled' => 'ไม่สามารถซ่อมแซม IP แอดเดรส %1 อินเทอร์เฟสของเครือข่ายนี้จะได้รับ IP แอดเดรสโดยอัตโนมัติ',
    'ip_addr__cannot_change_interface_dhcp_enabled' => 'ไม่สามารถเปลี่ยนอิเทอร์เฟสของ IP แอดเดรส %1 ได้เนื่องจากอินเทอร์เฟสของเครือข่าย %2 ได้รับ IP แอดเดรสโดยอัตโนมัติ',

    'shm_lmsg__limit_for_resource_exceeded' => 'เกินขีดจำกัดของการสมัครสมาชิกในจำนวนของ %%type%% ขีดจำกัดในปัจจุบันคือ %%limit%% และมีการใช้งาน %%usage%% แล้ว',
    'shm_lmsg__resource_is_forbidden_for_creation' => 'ไม่อนุญาตให้สร้าง %%type%% สำหรับการสมัครสมาชิกนี้',
    'shm_lmsg__resource_title__db-mysql' => 'ฐานข้อมูล MSSQL',
    'shm_lmsg__resource_title__db-mssql' => 'ฐานข้อมูล MS SQL',
    'shm_lmsg__resource_title__db-postgresql' => 'ฐานข้อมูล PostgreSQL',
    'shm_lmsg__resource_title__db-user' => 'ผู้ใช้ฐานข้อมูล',
    'shm_lmsg__resource_title__iis-application-pool' => 'แอพพลิเคชั่นกลุ่ม IIS',
    'shm_lmsg__resource_title__additional-ftp-account' => 'บัญชี FTP เพิ่มเติม',

    'db_user_unable_remove_mysql_global_privileges' => 'ไม่สามารถลบสิทธิพิเศษในการใช้งานทั่วโลกของ MySQL ของผู้ใช้ฐานข้อมูล %1 ได้ เหตุผล: %2',
    'report__client_description' => 'รายละเอียด',

    'db__user_role_error' => 'ค้นพบฐานข้อมูลหน้าที่ของผู้ใช้งานที่ไม่ถูกต้อง: %1. %1กรุณาเลือกหนึ่งในหน้าที่ต่อไปนี้: %2.',

    'subscription_unable_to_set_max_filesize_warning' => 'ไม่สามารถจำกัดขนาดไฟล์สำหรับฐานข้อมูลเซิฟเวอร์ Microsoft SQL ได้เนื่องจากฐานข้อมูลมีขนาดไฟล์ที่ใหญ่กว่า: %1.',
    'subscription_unable_to_set_max_log_filesize_warning' => 'ไม่สามารถจำกัดขนาดไฟล์บันทึกสำหรับฐานข้อมูลเซิฟเวอร์ Microsoft SQL ดังต่อไปนี้เนื่องจากฐานข้อมูลมีขนาดไฟล์บันทึกที่ใหญ่กว่า: %1.',
    'ipaddress__cannot_set_up_public_ip_need_ipaddress' => 'ไม่สามารถสร้างที่อยู่ IP สาธารณะได้: จะต้องมีที่อยู่ IP ส่วนตัวก่อน',
    'ipaddress__cannot_set_up_public_ip_need_ipv6' => 'ไม่สามารถสร้างที่อยู่ IPv4 สาธารณะสำหรับที่อยู่ IPv6 ได้',
    'ipaddress__cannot_set_up_public_ip_need_ipv4' => 'ไม่สามารถสร้างที่อยู่ IPv6 สาธารณะสำหรับที่อยู่ IPv4 ได้',
    'ipaddress__cannot_set_up_public_ip_invalid' => 'ไม่สามารถสร้างที่อยู่ IP สาธารณะได้: ที่อยู่ IP ไม่ถูกต้อง',

    '__user_already_exists' => "มีผู้ใช้ %1 อยู่แล้ว",
    '__user_name_is_empty' => "กรุณาระบุชื่อผู้ใช้งาน",

    'upgrade_php_on_domain' => 'ไม่สามารถค้นหา PHP เวอร์ชั่น 5.3.0 หรือใหม่กว่าบนโดเมน WordPress ของคุณ ขอให้ลองทำการปรับปรุง PHP',

    'component_name__waf' => 'ไฟร์วอลล์ของแอพพลิเคชั่นเว็บ',
    'component_name__vcs' => 'ระบบการควบคุมเวอร์ชั่น',

    'virtualization_lxc' => 'LXC',
    'virtualization_docker' => 'Docker',
    'possibleSpoofingDetected' => 'ระบบตรวจพบความเป็นไปได้ที่อาจมีความพยายามทำการสปูฟ: ลิงค์พยายามแสดงเนื้อหาที่ไม่เกี่ยวข้อง',
    'forceResetPasswordUpdated' => 'เปลี่ยนรหัสผ่านของคุณแล้ว ใช้รหัสผ่านใหม่เพื่อเข้าสู่ระบบใน Plesk',

    'php_handlers_error_no_available_instance' => 'ไม่สามารถสร้างโดเมนได้: ไม่มีตัวดำเนินการ PHP ที่พร้อมใช้งาน',
    'domain_error_unable_to_apply_hosting_settings' => 'ไม่สามารถใช้งานการตั้งค่าโฮสติ้งได้: %1',

    'plesk_not_configured' => 'ไม่ได้กำหนดค่า Plesk ไปที่แผงควบคุมเพื่อดำเนินการกำหนดค่าในการติดตั้งล่วงหน้า',
    'cmd_mail__mail_password_duplicated' => 'มีคู่ของที่อยู่อีเมลและรหัสผ่านที่ระบุไว้แล้วบนเซิร์ฟเวอร์เมล โปรดระบุที่อยู่อีเมลหรือรหัสผ่านอื่น',

    'extensionRequirementOs' => 'แพ็คเกจนี้ไม่สนับสนุนระบบปฏิบัติการ (%1)',
    'extensionRequirementPleskMinVersion' => 'Plesk %1 คือเวอร์ชั่นเก่าที่สุดที่แพคเกจนี้สนับสนุน',
    'extensionRequirementPleskMaxVersion' => 'แพคเกจนี้ไม่สนับสนุนเวอร์ชั่นที่เริ่มจาก Plesk %1',
    'extensionBlacklisted' => 'ไม่อนุญาตให้ใช้ส่วนขยาย %1 สำหรับการติดตั้ง',
    'extensionDisabled' => 'ปิดการทำงานส่วนขยาย',


    'optimization_settings__unable_set_mpm_event' => 'ไม่สามารถตั้งค่าโหมด mpm_event: ต้องปิดโมดูล Apache PHP5 แต่มีโดเมนที่กำลังใช้โมดูลดังกล่าว',
    'optimization_settings__unable_turn_off_php' => 'ไม่สามารถปิดโมดูล Apache PHP5: ถูกใช้โดยโดเมน',

    'hst_def__fp_admin_login' =>  'ชื่อผู้ใช้ FTP',
    'hst_def__fp_admin_passwd' =>  'รหัสผ่าน FTP',

    'database_user_orphaned_old_password_wrong' => "ไม่สามารถแก้ไขผู้ใช้ตกค้าง '%1': รหัสผ่านไม่ถูกต้อง",
    'cannot_load_partner_central_property_key_no_exist' => "ไม่สามารถเรียกคืนคุณสมบัติในการทำงานแบบกำหนดเองได้: ไม่มีรหัสลิขสิทธิ์",
    'extensionScriptFailure' => "ไม่สามารถประมวลผล %1 พร้อมข้อความดังต่อไปนี้:\n%3",
    '__ssl_redirect' => "SEO-safe 301 แบบถาวรเปลี่ยนเส้นทางจาก HTTP ไปยัง HTTPS",
    'component_name__dotnetcore' => '.NET Core',
    'mail__dkim_not_supported' => 'ไม่รองรับการจัดการ DKIM',
    'mail__dmarc_not_supported' => 'ไม่รองรับการจัดการ DMARC',
    'mail__relay_white_list_not_supported' => 'ไม่รองรับการจัดการรายการถ่ายทอดที่อนุญาต',
    'mail__black_list_not_supported' => 'ไม่รองรับการจัดการรายการบัญชีดำ',
    'mail__autoresponder_not_supported' => 'ไม่รองรับการจัดการโปรแกรมตอบสนองอัตโนมัติ',
    'defaultcomponents__not_supported_version' => '(ไม่ใช่เวอร์ชั่นที่รองรับ)',
    'component_name__nodejs' => 'Node.js',

    'certificate__not_found' => 'ไม่พบการรับรอง \'%1\'',
    'certificate__unable_setup_certificate' => 'ไม่สามารถติดตั้งการรับรองได้: รหัสส่วนตัวและเนื้อหาของการรับรองสูญหาย',
    'certificate__used_by_panel' => 'หนึ่งในการรับรองที่คุณกำลังจะลบออกเคยใช้สำหรับการรักษาความปลอดภัย Plesk',
    'certificate__used_by_mail_server' => 'หนึ่งในการรับรองที่คุณกำลังจะลบออกเคยใช้สำหรับการรักษาความปลอดภัยเซิร์ฟเวอร์เมล',
    'certificate__used_by_domain_service' => 'บริการโดเมนมีการใช้งานใบรับรองที่คุณกำลังจะลบออก',
    'mail_server__not_installed' => 'ไม่สามารถติดตั้งการรับรองสำหรับเซิร์ฟเวอร์เมลได้ เนื่องจากไม่ได้ติดตั้งเซิร์ฟเวอร์เมล',

    'email_activation_mail_subject' => 'โปรดเปิดใช้งานบัญชีขิงคุณใน Plesk',
    'email_activation_mail_body' => "บัญชีถูกสร้างขึ้นในเซิร์ฟเวอร์ Plesk  %1\n\nรายละเอียดของบัญชี:\nชื่อ: %2\nอีเมลแอดเดรส: %3\n\nหากข้อมูลนี้ถูกต้องและมีการสร้างบัญชีให้แก่คุณแล้ว โปรดเปิดใช้งานบัญชีด้วยลิงก์ต่อไปนี้:\n\n%4\n\nโดยการเปิดใช้งานบัญชี หมายความว่าคุณอนุญาตให้เจ้าของเซิร์ฟเวอร์เก็บรวบรวม จัดเก็บ ประมวลผล และใช้ข้อมูลส่วนบุคคลของคุณ (ชื่อและอีเมล) ในการสร้างและการสนับสนุนบัญชีของคุณ ตามกฎหมายว่าด้วยการคุ้มครองข้อมูลที่มีผลบังคับใช้อย่างแท้จริงในปัจจุบัน ซึ่งถือเป็นส่วนหนึ่งของสัญญา",

    'backup_transport_permission_name' => '%1 การจัดการ',
    'backup_transport_permission_description' => 'ยินยอมให้ใช้ %1 เพื่อสำรองข้อมูล',

    'domain_move_err_target_no_hosting' => 'ไม่สามารถย้ายโดเมนไปยังการสมัครสมาชิกได้โดยไม่มีโฮสติ้ง',
    'domain_move_err_already_in_target' => 'โดเมนนี้เป็นของการสมัครสมาชิกเป้าหมายอยู่แล้ว',
    'domain_move_err_main_domain' => 'ไม่สามารถย้ายโดเมนหลักได้',
    'domain_move_err_subdomain_without_parent' => 'ไม่สามารถย้ายโดเมนย่อย %1 ได้โดยไม่มีโดเมนพาเรน %2',
    'domain_move_err_root_exists' => 'พาธเป้าหมายสำหรับ www_root %1 มีอยู่แล้ว',
    'domain_move_err_nested_roots' => 'ไม่สามารถย้ายโดเมนได้เนื่องจากมีการแชร์ root ของเอกสารร่วมกับโดเมนอื่น: %1',
    'domain_move_err_no_mail_service' => 'ไม่สามารถย้ายโดเมนได้เนื่องจากบริการจดหมายถูกปิดใช้งานบนการสมัครสมาชิกเป้าหมาย',
    'domain_move_err_app' => "แอปพลิเคชันที่ติดตั้งอยู่บน %1 ไม่ได้ถูกย้ายไปยังการสมัครสมาชิก '%2' แล้ว: %3",
    'domain_move_database_used_by_app' => "ฐานข้อมูล '%1' บน %2 ถูกใช้งานโดยแอปพลิเคชันที่ถูกเคลื่อนย้าย หากต้องการกำหนดฐานข้อมูลให้กับ '%3' ใหม่อีกครั้ง ให้เรียกใช้คำสั่ง `plesk bin database --assign-to-subscription`",
    'domain_move_target_locked' => "การสมัครสมาชิกเป้าหมาย '%1' ถูกล็อกสำหรับการซิงค์",
    'domain_move_filesharing_disabled' => 'การแชร์ไฟล์ถูกปิดใช้งาน',
    'domain_move_website_preview_disabled' => 'การดูตัวอย่างเว็บไซต์ถูกปิดใช้งาน',
    'domain_move_additional_webserver_settings' => "ตรวจสอบคำสั่งเสริมบนเว็บเซิร์ฟเวอร์ของโดเมนเพื่อป้องกันมิให้การกำหนดค่าเสียหาย",
    'domain_move_no_permission' => "%1 ไม่ได้รับอนุญาตสำหรับระบบสมัครสมาชิก '%2'",
    'domain_move_no_access' => "ไมมีสิทธิเข้าถึงระบบสมัครสมาชิก '%1'",
    'domain_split_no_create_permission' => "ไม่อนุญาตให้สร้างโดเมน",
    'domain_split_empty_login' => 'ต้องใส่ข้อมูลประจำตัวของผู้ใช้ระบบ',
    'domain_split_empty_password' => 'ต้องใส่รหัสผ่านของผู้ใช้ระบบ',
    'domain_split_err_home_exists' => 'ไม่สามารถย้ายโดเมน %1 ได้เนื่องจากพาธเป้าหมายนี้มีอยู่แล้วใน %2 เปลี่ยนชื่อโดเมนเพื่อย้ายไปยังระบบสมัครสมาชิกใหม่',
    'domain_split_err_no_hosting_subdomains' => 'คุณจะไม่สามารถย้ายโดเมนไปยังระบบสมัครสมาชิกใหม่ได้ เนื่องจากโดเมนไม่มีโฮสติ้งแต่มีโดเมนย่อย หากต้องการย้ายโดเมน โปรดเปลี่ยนค่า "ประเภทโฮสติ้ง" ให้เป็น "โฮสติ้งเว็บไซต์" (ในการตั้งค่าโฮสติ้ง)',
    'domain_split_target_locked' => "การสมัครสมาชิกเป้าหมาย '%1' ถูกล็อกสำหรับการซิงค์",
    'domain_split_target_unsynced' => "การสมัครสมาชิกเป้าหมาย '%1' ไม่ได้ซิงค์กับแผน เนื่องจาก: %2",
    'domain_merge_scheduled_backup_deactivated' => "ระบบสำรองข้อมูลตามกำหนดเวลาบน '%1\\’ ถูกปิดใช้งาน",
    'domain_merge_database_error' => "ไม่ได้ย้ายฐานข้อมูล '%1\\’ บน %2 ไปยังระบบสมัครสมาชิก '%3': %4",
    'domain_merge_anon_ftp_deactivated' => "FTP นิรนามบน '%1' ถูกปิดสวิตช์",
    'domain_merge_smb_user_access' => "ผู้ใช้ '%1' ถูกย้ายไปยังระบบสมัครสมาชิก '%2' แล้ว แต่สิทธิในการสมัครสมาชิกของผู้ใช้ถูกเพิกถอน",
    'domain_merge_scheduled_tasks' => "งานที่มีกำหนดเวลาถูกย้ายไปยังระบบสมัครสมาชิกเป้าหมาย ตรวจสอบการกำหนดค่างาน",
    'domain_merge_scheduled_tasks_deactivated' => "งานที่มีกำหนดเวลาถูกย้ายไปยังระบบสมัครสมาชิกเป้าหมายและปิดใช้งานแล้ว ตรวจสอบการกำหนดค่างาน",
    'domain_merge_no_remove_permission' => "ห้ามลบการสมัครสมาชิก",
    'domain_merge_err_has_addons' => 'ไม่สามารถย้ายโดเมนหลักที่มีโดเมนเพิ่มเติมได้ โปรดย้ายโดเมน %1 เสียก่อน',
    'domain_merge_err_has_webusers' => 'ไม่สามารถย้ายโดเมนหลักที่มีผู้ใช้เว็บได้',
    'domain_merge_err_root_exists' => 'พาธเป้าหมาย %1 มีอยู่แล้ว',

    'database_server_edit_used_for_psa' => 'ไม่อนุญาตให้อัปเดตเซิร์ฟเวอร์ของฐานข้อมูล MySQL แบบเฉพาะที่',
    'suggest_repair_main_suggestion_ui' => '<b>คุณสามารถแก้ไขข้อผิดพลาดนี้</b> ใช้โปรแกรม `plesk repair`',
    'suggest_repair_main_suggestion_cli' =>  'คุณสามารถแก้ไขข้อผิดพลาดนี้ได้โดยใช้โปรแกรม `plesk repair`',
    'suggest_repair_repair_kit_link_title' => 'ไปที่ตรวจวิเคราะและซ่อมแซม',
    'suggest_repair_using_cli_and_ui' => 'เพื่อกระทำการดังกล่าว เปิดใช้คำสั่ง `plesk repair %1`ผ่าน CLI หรือไม่ก็ %2 แล้วคลิก ซ่อมแซม ถัดจาก   “Plesk Database”',
    'suggest_repair_using_cli' => 'เพื่อกระทำการดังกล่าว เปิดใช้คำสั่ง `plesk repair %1`ผ่าน CLI',

    'backup__restore__capability_duplicate_php_handler_resolution' => '',
    'bu_conflict_resolver_dns_not_available' => 'บริการ DNS ไม่พร้อมใช้งานเมื่อมีการสร้างข้อมูลสำรองไว้แล้ว อย่างไรก็ตาม ยังมีโซน DNS ในข้อมูลสำรองที่ใช้งานได้และจะถูกเปิดใช้สำหรับวัตถุประสงค์ต่อไปนี้: {{objects}}',
    'plesk_key__system-resources-limits-enabled' => 'ตัวควบคุมทรัพยากร (cgroups)',
    'plesk_key__remote-smartermail-enabled' => 'การสนับสนุนของระบบ Smartermail ทางไกล',
    'plesk_key__complete-backup-solution' => 'Backup to Cloud Pro',
    'defaultcomponents__no_license' => '(ไม่ได้รับอนุญาตจากรหัสลิขสิทธิ์)',
    'plesk_key__validation_failed' => '%1 (รหัสข้อผิดพลาด: %2)',
    'promo__button_details' => 'รายละเอียด',
    'promo__extension_catalog_title' => 'แคตตาล็อกโปรแกรมส่วนเสริม',
    'promo__extension_catalog_description' => 'ตรวจสอบแคตตาล็อกโปรแกรมส่วนเสริมใหม่และเพิ่มความสามารถให้ Plesk ของคุณด้วยโปรแกรมส่วนเสริมที่มีประสิทธิภาพหลากหลาย!',
    'promo__button_open_catalog' => 'เปิดแคตตาล็อก',

    'backup__repository_check_login' => "ไม่สามารถเข้าถึงพื้นที่จัดเก็บข้อมูล: %1 โปรดตรวจสอบให้แน่ใจว่าคุณป้อนรหัสที่ถูกต้อง",
    'backup__repository_check_error_list' => "ไม่สามารถเข้าถึงพื้นที่จัดเก็บข้อมูลได้: %1 โปรดตรวจสอบให้แน่ใจว่าคุณตั้งค่าพื้นที่จัดเก็บถูกต้อง",
    'backup__repository_check_error_mkdir' => "ไม่สามารถสร้างไดเรคทอรีได้: %1 โปรดตรวจสอบว่าคุณได้รับอนุญาตให้สร้างโฟลเดอร์ในพื้นที่จัดเก็บหรือไม่",
    'backup__repository_check_error_upload' => "ไม่สามารถอัปโหลดไฟล์ไปยังพื้นที่จัดเก็บข้อมูลได้: %1 โปรดตรวจสอบว่าคุณได้รับอนุญาตให้อัปโหลดไฟล์ไปยังพื้นที่จัดเก็บหรือไม่",
    'backup__repository_check_error_download' => "ไม่สามารถดาวโหลดไฟล์จากพื้นที่จัดเก็บข้อมูลได้: %1 โปรดตรวจสอบว่าคุณได้รับอนุญาตให้อัปโหลดและดาวน์โหลดไฟล์จากพื้นที่จัดเก็บหรือไม่",
    'backup__repository_check_error_resume-upload' => "ไม่สามารถดำเนินการอัปโหลดไฟล์ไปยังพื้นที่จัดเก็บข้อมูลต่อได้: %1 โปรดตรวจสอบว่าคุณได้รับอนุญาตให้ดำเนินการอัปโหลดไปยังพื้นที่จัดเก็บต่อหรือไม่",
    'backup__repository_check_error_resume-download' => "ไม่สามารถดำเนินการดาวน์โหลดไฟล์จากพื้นที่จัดเก็บข้อมูลต่อได้: %1 โปรดตรวจสอบว่าคุณได้รับอนุญาตให้ดำเนินการดาวน์โหลดจากพื้นที่จัดเก็บต่อหรือไม่",
    'backup__repository_check_error_enable-utf8' => "ไม่สามารถจัดการพื้นที่จัดเก็บข้อมูลได้: %1 โปรดตรวจสอบว่าพื้นที่จัดเก็บรองรับการเข้ารหัส UTF8 หรือไม่",
    'backup__repository_check_error_rm' => "ไม่สามารถจัดการพื้นที่จัดเก็บข้อมูลได้: %1 โปรดตรวจสอบว่าคุณได้รับอนุญาตให้ลบไฟล์ออกจากพื้นที่จัดเก็บหรือไม่",
    'backup__repository_check_error_rmdir' => "ไม่สามารถจัดการพื้นที่จัดเก็บข้อมูลได้: %1 โปรดตรวจสอบว่าคุณได้รับอนุญาตให้ลบโฟลเดอร์ออกจากพื้นที่จัดเก็บหรือไม่",

    'backup__ftp_repository_check_login' => "%1 คุณสามารถทำการตรวจสอบโดยอิสระด้วยคำสั่ง: %2",
    'backup__ftp_repository_check_error_list' => "%1 คุณสามารถทำการตรวจสอบโดยอิสระด้วยคำสั่ง: %2",
    'backup__ftp_repository_check_error_mkdir' => "%1 คุณสามารถทำการตรวจสอบโดยอิสระด้วยคำสั่ง: %2",
    'backup__ftp_repository_check_error_upload' => "%1 คุณสามารถทำการตรวจสอบโดยอิสระด้วยคำสั่ง: %2 %3",
    'backup__ftp_repository_check_error_download' => "%1 คุณสามารถทำการตรวจสอบโดยอิสระด้วยคำสั่ง: %2 %3",
    'backup__ftp_repository_check_error_resume-upload' => "%1 คุณสามารถทำการตรวจสอบโดยอิสระด้วยคำสั่ง: %2 %3 %4",
    'backup__ftp_repository_check_error_resume-download' => "%1 คุณสามารถทำการตรวจสอบโดยอิสระด้วยคำสั่ง: %2 %3",
    'backup__ftp_repository_check_error_enable-utf8' => "%1 คุณสามารถทำการตรวจสอบโดยอิสระด้วยคำสั่ง: %2",
    'backup__ftp_repository_check_error_rm' => "%1 คุณสามารถทำการตรวจสอบโดยอิสระด้วยคำสั่ง: %2 %3",
    'backup__ftp_repository_check_error_rmdir' => "%1 คุณสามารถทำการตรวจสอบโดยอิสระด้วยคำสั่ง: %2 %3",

    'sfdmarc_server_wide_enable_failed' => 'ไม่สามารถเปลี่ยนการตั้งค่าสำหรับ DMARC ได้ หากต้องการเปิดใช้ทางเลือกนี้ โปรดเปิด DKIM และ SPF ป้องกันสแปม',
    'spf_server_wide_disable_failed' => 'ไม่สามารถเปลี่ยนการตั้งค่าสำหรับ SPF ป้องกันสแปมได้ หากต้องปิดใช้งาน SPF โปรดปิด DMARC สำหรับเมลขาเข้า',
    'sfdk_server_wide_verify_disable_failed' => 'ไม่สามารถเปลี่ยนการตั้งค่าสำหรับ DKIM ป้องกันสแปมได้ หากต้องการปิดใช้งาน DKIM โปรดปิด DMARC สำหรับเมลขาเข้า',

    'ccs_not_supported' => 'ไม่ได้ตั้งค่าการจัดการพื้นที่จัดเก็บใบรับรองจากเครือข่ายที่ใช้ร่วมกันบน IIS ในระบบ',
    'ccs_not_enabled' => 'ไม่ได้เปิดใช้งานระบบจัดการพื้นที่จัดเก็บใบรับรองจากเครือข่ายที่ใช้ร่วมกันบน IIS ใน Plesk',
    'ad_not_supported' => 'เซิร์ฟเวอร์ไม่ได้เชื่อมโยงเข้ากับโดเมน',

    'component_name__appinit' => "การกำหนดค่าเริ่มต้นของแอพพลิเคชัน",
    'component_name__cors' => "แชร์ทรัพยากรข้ามแพลตฟอร์ม",
    'component_name__httpcompression' => 'การบีบอัดไฟล์ข้อมูลให้มีขนาดเล็กลง',
    'common_feature_is_not_supported' => 'ไม่รองรับฟีเจอร์นี้อีกต่อไป',
    'common_feature_is_not_supported_in_proto' => 'ฟีเจอร์นี้ไม่รองรับโพรโทคอลรุ่น %1',
    'autoinstaller__plesk_component' => 'คอมโพเนนท์ของ Plesk',
    'plesk_key__key_expired' => 'รหัสลิขสิทธิ์ของคุณหมดอายุแล้ว หากต้องการใช้ Plesk ต่อ โปรดสั่งซื้อใบอนุญาตสำหรับธุรกิจแบบตลอดชีพ %1',
    'plesk_key__key_purchase' => 'รหัสลิขสิทธิ์',

    'sa_action_move' => 'ย้ายสแปมไปที่โฟลเดอร์ “อีเมลขยะ”',

    'bu_conflict_resolver_tomcat_not_supported' => 'จาวาแอพพลิเคชันไม่ได้รับการสนับสนุนอีกต่อไปซึ่งจะทำให้ไม่สามารถใช้งานได้ในเว็บไซต์ต่อไปนี้: {{objects}}',
    'bu_conflict_resolver_unity_mobile_not_supported' => 'ไม่รองรับเว็บไซต์เวอร์ชันโทรศัพท์มือถือที่โฮสต์ด้วย UNITY Mobile อีกต่อไปซึ่งจะทำให้ไม่สามารถใช้งานได้สำหรับเว็บไซต์ต่อไปนี้: {{objects}}',
    'bu_conflict_resolver_antivirus_personal_management_not_allowed' => 'นโยบายการใช้งานทั่วทั้งเครือข่ายไม่อนุญาตให้ใช้การตั้งค่าป้องกันไวรัสส่วนบุคคล ซึ่งข้อมูลจะถูกกู้คืนเพียงบางส่วนสำหรับบัญชีอีเมลบนโดเมนต่อไปนี้: {{objects}}',

    'module__not_installed' => "ไม่ได้ติดตั้งโปรแกรมส่วนเสริม %1",

    'mail__mail_autodiscovery_server_error' => 'ระบุชื่อโดเมนที่กำหนดเองสำหรับการค้นหาจดหมายอัตโนมัติ',
    'mail__error_mail_autodiscovery_enable' => 'ไม่สามารถตั้งค่าการค้นหาจดหมายอัตโนมัติได้: %1',
    'mail__error_mail_autodiscovery_server' => 'ไม่สามารถตั้งค่าชื่อโดเมนที่กำหนดเองสำหรับการค้นหาจดหมายอัตโนมัติได้: %1',
    'mail__error_mail_autodiscovery_reconfigure_dns' => 'ไม่สามารถปรับแต่งค่าของโดเมนที่ค้นหาระเบียน DNS อัตโนมัติได้: %1',

    '__invalid_url' => 'URL "%1" ไม่ถูกต้อง',
    'actionlog__cloning_start' => 'เริ่ม',
    'actionlog__event_cloning_start' => 'เริ่มต้นการโคลนเซิร์ฟเวอร์',

    '__UPLOAD_ERR_FORM_SIZE' => "ไฟล์ที่อัพโฟลดมีขนาดเกินกว่าที่ได้รับอนุญาต",
    '__UPLOAD_ERR_INI_SIZE' => "ไฟล์ที่อัพโฟลดมีขนาดเกินกว่าที่ได้รับอนุญาต",
    '__UPLOAD_ERR_NO_FILE' => "ไม่มีไฟล์ที่ได้รับ",
    '__UPLOAD_ERR_OK' => "อัพโหลดไฟล์สำเร็จแล้ว",
    '__UPLOAD_ERR_PARTIAL' => "ไฟล์ได้รับการอัพโหลดบางส่วน โปรดลองใหม่อีกครั้ง",
    '__UPLOAD_ERR_NO_TMP_DIR' => 'โฟลเดอร์ชั่วคราวสูญหาย',
    '__UPLOAD_ERR_CANT_WRITE' => 'การบันทึกใส่ดิสผิดพลาด',
    '__UPLOAD_ERR_UNKNOWN' => 'การอัพโหลดไฟล์เกิดข้อผิดพลาดขึ้น',
    '__accounts' => "บัญชี",
    '__access' => "การเข้าถึง",
    '__address' => "ที่อยู่",
    '__addresses' => "ที่อยู่",
    '__acl_records' => 'รายการ ACL',
    '__admin_repository' => "ที่จัดเก็บของผู้ดูแลระบบ",
    '__all' => 'ทั้งหมด',
    '__allowed' => "ได้รับอนุญาตแล้ว",
    '__anonftp_status' => "FTP นิรนาม",
    '__antispam' => "แอนติสแปม",
    '__apache_restart' => "...%1 เซิร์ฟเวอร์เว็บกำลังจะรีสตาร์ท โปรดรอสุกครู่...",
    '__asp' => "Microsoft ASP",
    '__asp_dot_net' => "Microsoft ASP.NET",
    '__asp_dot_net_support' => "รองรับ Microsoft ASP.NET",
    '__asp_win_support' => "รองรับ Microsoft ASP",
    '__attachments' => "เอกสารแนบ",
    '__attachments_list' => "เอกสารแนบ",
    '__author' => 'ผู้แต่ง',
    '__autoresp_name_already_exists' => "การตอบกลับอัตโนมัติที่มีชื่อ %1 มีอยู่แล้ว",
    '__autoresponder' => "การตอบกลับอัตโนมัติ",
    '__autoresponders' => "การตอบกลับอัตโนมัติ",
    '__autoresponders_list' => "การตอบกลับอัตโนมัติ",
    '__autoresponder_attachment_files' => "ไฟล์ที่แนบมากับการตอบกลับอัตโนมัติ",
    '__auto_updates_list' => 'มีอัพเดท',
    '__avail' => "มีอยู่",
    '__backup_utilites' => "ยูทิลิตี้การสำรองข้อมูล",
    '__bind_status' => "สถานะเซิร์ฟเวอร์ DNS",
    '__bu_is_not_installed' => "ไม่มีบริการนี้ในขณะนี้ เนื่องจากยังไม่ได้ติดตั้งยูทิลิตี้การสำรองข้อมูล",
    '__bu_not_support_in_key' => "รหัสลิขสิทธิ์ไม่รองรับความสามารถในการสำรองข้อมูล",
    '__notifications_not_support_in_key' => 'รหัสลิขสิทธิ์ไม่รองรับการแจ้งเตือน',
    'disabled_by_key' => 'ไม่รองรับโดยรหัสลิขสิทธิ์ของคุณ',
    '__bytes' => "ไบต์",
    '__can_not_use_reserved_words' => "คุณไม่สามารถใช้คำที่ได้รับการสงวนไว้ได้",
    '__certificate' => "การรับรอง",
    '__cgi_support' => "รองรับ CGI",
    '__change_date' => "วันที่ทำการแก้ไข",
    '__city' => "เมือง",
    '__cl_not_exist' => "ไม่มีบัญชีลูกค้าอยู่",
    '__client' => 'ลูกค้า',
    '__client_card' => "บัตรลูกค้า",
    '__client_contact_name' => "ชื่อติดต่อของลูกค้า",
    '__client_form' => "ข้อมูลส่วนบุคคล",
    '__client_ip_pool' => "กลุ่ม IP ของลูกค้า",
    '__client_limits' => "ขีดจำกัดบัญชีลูกค้า",
    '__client_permissions' => "การอนุญาตของลูกค้า",
    '__client_preferences' => "ความชอบของลูกค้า",
    '__client_status' => "สถานะลูกค้า",
    '__client_name' => "ชื่อผู้ใช้",
    '__client_total' => "จำนวนลูกค้าสุทธิ",
    '__client_with_login_name_already_exists' => "ผู้ใช้ที่มีชื่อผู้ใช้ \"%1\" มีอยู่แล้ว",
    '__client_domuser_with_login_already_exists' => "ผู้ดูแลระบบของโดเมน '%1' ใช้ชื่อผู้ใช้ '%1' แล้ว",
    '__clients_global_changes' => "แก้ไขบัญชีลูกค้าที่เลือก",
    '__clients_list' => "ลูกค้า",
    '__cmd_not_found' => "คำสั่งที่ไม่รู้จัก: %1",
    '__comments' => "ข้อเสนอแนะ",
    '__company_name' => "ชื่อบริษัท",
    '__component_version' => "เวอร์ชั่นของคอมโพเนนท์",
    '__component_not_installed' => "ไม่ได้ติดตั้งคอมโพเนนท์ %1",
    '__confirm_del' => "คุณต้องยืนยันการลบ",
    '__confirm_overwrite' => "ยืนยันการเขียนทับ",
    '__confirm_stop' => "คุณต้องยืนยันการหยุดกระบวนการ",
    '__confirm_passwd' => "ยืนยัน %1 รหัสผ่าน",
    '__confirm_removal' => "ยืนยันการเขียนทับ",
    '__conhelp' => "รายละเอียด",
    '__contact_name' => "ชื่อผู้ติดต่อ",
    '__country' => "ประเทศ",
    '__countries' => 'ประเทศ',
    '__country_unknown' => 'ไม่สามารถจำซับโค้ดของประเทศได้',
    '__courier-imap' => 'เซิร์ฟเวอร์ส่งข้อมูล',
    '__create_domain' => 'สร้างโดเมน',
    '__crypted' => 'เข้ารหัสแล้ว',
    '__cp_access' => "การเข้าถึง Plesk",
    '__cp_user' => "ผู้ใช้ Plesk",
    '__create' => "สร้าง",
    '__create_client_template_without_template' => "สร้างบัญชีผู้ใช้โดยไม่มีแม่แบบ",
    '__create_domain_for' => "สร้างโดเมนสำหรับ <b>%1</b>",
    '__create_domain_template_without_template' => "สร้างโดเมนใหม่โดยไม่มีแม่แบบ",
    '__creation_date' => "วันที่สร้าง",
    '__crontab_unix' => "ตัวจัดลำดับ",
    '__crontab_win' => "ตัวจัดลำดับ",
    '__ct_month_jan' => 'มกราคม',
    '__ct_month_feb' => 'กุมภาพันธ์',
    '__ct_month_mar' => 'มีนาคม',
    '__ct_month_apr' => 'เมษายน',
    '__ct_month_may' => 'พ.ค.',
    '__ct_month_jun' => 'มิถุนายน',
    '__ct_month_jul' => 'กรกฎาคม',
    '__ct_month_aug' => 'สิงหาคม',
    '__ct_month_sep' => 'กันยายน',
    '__ct_month_oct' => 'ตุลาคม',
    '__ct_month_nov' => 'พฤศจิกายน',
    '__ct_month_dec' => 'ธันวาคม',
    '__custom_button' => "ปุ่มที่ตั้งค่าเอง",
    '__custom_buttons_list' => "ลิงค์ไปยังบริการเสริม",
    '__daily' => "ประจำวัน",
    '__database_not_activated' => "ยังไม่ได้เปิดใช้งาน %1 ในหน้าผู้ดูแลระบบเซิร์ฟเวอร์",
    '__database_not_installed' => "ยังไม้ได้ติดตั้งฐานข้อมูล %1",
    '__database_not_run' => "ยังไม้ได้ติดตั้งฐานข้อมูล %1",
    '__database_is_corrupt' => "ฐานข้อมูลของ Plesk ถูกรบกวน โปรดเปิดยูทิลิตี้ในการปรับตั้งค่าเพื่อทำการซ่อมแซม",
    '__databases' => "ฐานข้อมูล",
    '__databases_list' => "ฐานข้อมูล",
    '__database_type_not_supported_by_key' => 'หากต้องการใช้เซิร์ฟเวอร์ %1 คุณต้องการการสนับสนุนในลิขสิทธิ์ของคุณ โปรดปรึกษาตัวแทนจำหน่าย Plesk ของคุณ',
    '__date_immediately' => "วันนี้",
    '__date_never' => "ไม่เคย",
    '__day(s)' => "วัน",
    '__day0' => "อาทิตย์",
    '__day1' => "จันทร์",
    '__day2' => "อ.",
    '__day3' => "พุธ",
    '__day4' => "พฤ.",
    '__day5' => "ศุกร์",
    '__day6' => "เสาร์",
    '__days' => "%1 วัน",
    '__db_admin_login_empty' => "คุณใส่ชื่อผู้ใช้ที่ว่างเปล่าลงไป กำลังปิดการควบคุมบนหน้าจอ %1 คุณต้องการดำเนินการต่อใช่หรือไม่",
    '__db_unable_to_unregister' => 'ไม่สามารถลบพารามิเตอร์ของการเชื่อมต่อฐานข้อมูลได้',
    '__db_db_exists' => 'มีฐานข้อมูลอย่างน้อยหนึ่งฐานข้อมูลบนเซิร์ฟเวอร์',
    '__db_unable_to_change_server_name' => 'ชื่อของเซิร์ฟเวอร์ไม่สามารถเปลี่ยนได้',
    '__db_unable_to_change_port' => 'พอร์ทของเซิร์ฟเวอร์ไม่สามารถเปลี่ยนได้',
    '__db_already_exist' => "มีฐานข้อมูล %1 แล้ว",
    '__db_credentials_invalid' => "ไม่มีฐานข้อมูลที่อ้างอิงถึง",
    '__db_invalid_password_characters' => 'รหัสผ่านมีอักขระที่ไม่ถูกต้อง',
    '__db_engine' => "โปรแกรมฐานข้อมูล", // indirect
    '__db_type' => "ประเภทฐานข้อมูล",
    '__db_user' => "ผู้ใช้ฐานข้อมูล",
    '__db_server' => 'เซิร์ฟเวอร์ฐานข้อมูล',
    '__def_domain' => "ค่าเริ่มต้นสำหรับโดเมน",
    '__default_for_mysql' => 'ค่าเริ่มต้นสำหรับ MySQL',
    '__default_for_mariadb' => 'ค่าเริ่มต้นสำหรับ MariaDB',
    '__default_for_percona' => 'ค่าเริ่มต้นสำหรับ Percona',
    '__default_for_postgresql' => 'ค่าเริ่มต้นสำหรับ PostgreSQL',
    '__delete' => "ลบ",
    '__demo' => "ไม่มีฟังก์ชั่นนี้ในเวอร์ชั่นตัวอย่าง",
    '__directory' => "ไดเร็กทอรี่",
    '__disable_lock_screen' => 'ป้องกันผู้ใช้จากการทำงานกับ Plesk จนกว่าหน้าจอจะโหลดโดยสมบูรณ์',
    '__dismiss_news?' => "คุณแน่ใจหรือไม่ว่าต้องการปิดบล็อคข่าวทั้งหมด? \n\nคุณจะไม่สามารถดูบล็อคข่านได้อีกจนกระทั่งมีข่าวมากขึ้น",
    '__description' => "รายละเอียด",
    '__disabled' => "ปิด",
    '__disk_space_limit' => "จำกัดพื้นที่ดิสก์",
    '__cgroups_cpu_usage_limit' => 'ขีดจำกัดในการใช้งาน CPU',
    '__cgroups_ram_usage_limit' => 'ขีดจำกัดในการใช้งาน RAM',
    '__cgroups_disk_read_usage_limit' => 'ขีดจำกัดแบนด์วิดธ์ของดิสก์สำหรับการอ่าน',
    '__cgroups_disk_write_usage_limit' => 'ขีดจำกัดแบนด์วิดธ์ของดิสก์สำหรับการเขียน',
    '__disk_usage_by' => "พื้นที่ดิสก์ที่ใช้โดย %1",
    '__dns' => "DNS",
    '__dns_record_already_exist' => "มีระเบียน DNS '%1' อยู่แล้ว",
    '__dns_master_should_be_remote' => "คุณควรมีเซิร์ฟเวอร์ที่มีขื่อทีเชื่อถือได้สองชื่อที่แตกต่างกันในโฮสต์ที่แนกจากกัน",
    '__dns_record_not_exist' => "ไม่มีรายการ DNS",
    '__dns_server' => "เซิร์ฟเวอร์ DNS", // indirect
    '__dom_id_is_undefined' => "ไม่ได้กำหนด ID ของโดเมน",
    '__dom_name' => "ชื่อโดเมน",
    '__dom_name_is_invalid' => "ชื่อโดเมนไม่ถูกต้อง โปรดตรวจสอบให้แน่ในว่า ชื่อโดเมนของคุณประกอบด้วยตัวอักษรและตัวเลขจุด และเครื่องหมายยัติภังค์เท่านั้น และต้องมีความยาวของสัญลักษณ์ไม่เกินกว่า 255 ตัว ในแต่ละส่วนของชื่อโดเมนระหว่างจุดไม่ควรมีสัญลักษณ์เกินกว่า 63 ตัว",
    '__dom_not_exist' => "ไม่มีโดเมนอยู่",
    '__domain' => "โดเมน",
    '__domain_' => 'โดเมน %1',
    '__domain_form' => "รูปแบบโดเมน",
    '__domain_id' => "ID โดเมน",
    '__domain_is_turned_off_for_backup' => "ปิดเว็บไซต์ %1 ชั่วคราวเพื่อทำการสำรอง หรือกู้คืนข้อมูล และโดเมนจะไม่สามารถใช้งานได้ในขณะนี้",
    '__domain_limits' => "ขีดจำกัดโดเมน",
    '__domain_name' => "ชื่อโดเมน",
    '__mail_name_in_ASCII_form' => "ชื่อบัญชีเมลในรูปแบบ ASCII",
    '__message_error' => 'ผิดพลาด',
    '__message_warning' => 'คำเตือน',
    '__message_info' => 'ข้อมูล',
    '__domain_name_in_ASCII_form' => "ชื่อโดเมนในรูปแบบ ASCII",
    '__domain_repository' => "ที่จัดเก็บของโดเมน %1",
    '__domain_status' => "สถานะโดเมน",
    '__domain_found_tech' => "พบเทคโนโลยีบนโดเมน",
    '__domain_dns' => 'โดเมน DNS โซน',
    '__domain_total' => "จำนวนการสมัครรับบริการสุทธิ",
    '__domain_total_powerUser' => "จำนวนการสมัครรับบริการสุทธิ",
    '__domain_user' => "ผู้ดูแลระบบโดเมน",
    '__domains_global_changes' => "แก้ไขโดเมนที่เลือก",
    '__mailnames_global_changes' => "แก้ไขบัญชีเมลที่เลือก",
    '__backup_manager' => 'ตัวจัดการการสำรองข้อมูล',
    '__domains_list' => "โดเมน",
    'domains_list__list_header' => "โดเมน",
    //this is a part of phrases like No domains (and others), so it should not be capitalized
    '__double_www_warning' => "ชื่อโดเมนที่ขึ้นต้นด้วย www แม้ว่าจะใช้ WWW \nนำหน้า ดำเนินการต่อ?",
    '__dovecot' => 'Dovecot IMAP และเซิร์ฟเวอร์ POP3',
    '__dsmail' => "บริการเมล",
    '__dsmaillist' => "บริการรายชื่อสำหรับส่งจดหมาย",
    '__dumps_tot_size' => "ขนาดไฟล์สำรองทั้งหมดของพื้นที่จัดเก็บข้อมูลในระบบ",
    '__email' => "อีเมล์",
    '__email_addr_is_invalid' => "ที่อยู่อีเมลไม่ถูกต้อง",
    '__enabled' => "เปิด",
    '__enter_cert_text' => "ป้องข้อความการรับรอง",
    '__enter_size' => "ป้อนขนาด",
    '__exclusive' => "เฉพาะ",
    '__expiration_date' => "วันที่หมดอายุ",
    '__fax' => "แฟกซ์",
    '__file' => "ไฟล์",
    '__file_is_empty' => "ไฟล์ว่าง",
    '__file_name' => "ชื่อไฟล์",
    '__file_type' => 'ประเภทไฟล์',
    '__filemanager' => "ตัวจัดการไฟล์",
    '__filepath_is_empty' => "พาธไปยังไฟล์ว่าง",
    '__files_list' => "ไฟล์",
    '__frontpage' => "Microsoft FrontPage",
    '__ftp' => "FTP", // +indirect
    '__ftp_settings' => "การตั้งค่า FTP",
    '__ftp_serv' => "เซิร์ฟเวอร์ FTP", // indirect
    '__ftp_server_parameters_are_empty' => "คุณควรตั้งค่าคุณสมบัติของบัญชี FTP เป็นอันดับแรก!",
    '__ftp_status' => "สถานะเซิร์ฟเวอร์ FTP",
    '__full_day0' => "วันอาทิตย์",
    '__full_day1' => "วันจันทร์",
    '__full_day2' => "วันอังคาร",
    '__full_day3' => "วันพุธ",
    '__full_day4' => "วันพฤหัสบดี",
    '__full_day5' => "วันศุกร์",
    '__full_day6' => "วันเสาร์",
    '__full_month1' => "มกราคม",
    '__full_month10' => "ตุลาคม",
    '__full_month11' => "พฤศจิกายน",
    '__full_month12' => "ธันวาคม",
    '__full_month2' => "กุมภาพันธ์",
    '__full_month3' => "มีนาคม",
    '__full_month4' => "เมษายน",
    '__full_month5' => "พ.ค.",
    '__full_month6' => "มิถุนายน",
    '__full_month7' => "กรกฎาคม",
    '__full_month8' => "สิงหาคม",
    '__full_month9' => "กันยายน",
    '__giga' => "G",
    '__group' => "กลุ่ม",
    '__h' => "H",
    '__hard_disk_quota' => "โควต้าฮาร์ดดิสก์",
    '__hard_disk_quota_not_supported' => 'โควต้าฮาร์ดดิสก์ไม่รองรับ เนื่องจากการปรับตั้งค่าของระบบไฟล์เซิร์ฟเวอร์',
    '__header_text_is_invalid' => "หัวเรื่องของพื้นที่ได้รับการป้องกันไม่ถูกต้อง",
    '__help_topic_not_found' => 'ไม่มีหัวข้อความช่วยเหลือที่คุณต้องการ (%1)',
    '__hosting_ip_dns_ip_not_equiv' => "ไม่มี IP แอดเดรสที่ระบุในรายการ DNS ที่ตรงกับ IP แอดเดรสที่ใช้สำหรับโฮสติ้ง",
    '__hosting_scripting' => "สนับสนุนบทคำสั่งโฮสติ้ง",
    '__hosting_setup_page_title' => "ตั้งค่าโฮสติ้งเว็บสำหรับโดเมน %1",
    '__hosting_title' => "โฮสติ้ง (%1)",
    '__hosting_type' => "ประเภทโฮสติ้ง",
    '__hostname_is_empty' => "ชื่อโฮสต์ว่าง",
    '__hour(s)' => 'ชั่วโมง',
    '__hst_type_incorrect' => "ประเภทโฮสติ้งไม่ถูกต้อง",
    '__http' => "HTTP", //indirect
    '__htype' => "H",
    '__idle_time' => "เวลาว่าง",
    '__iface' => "หน้าจอ",
    '__image' => "ภาพ",
    '__imap_status' => "สถานะเซิร์ฟเวอร์ IMAP",
    '__in' => "ใน",
    '__in_%' => "ใน %",
    '__incorrect_databases_login_pass' => "ข้อมูลประจำตัวที่คุณระบุเพื่อการเข้าถึง PostgreSQL ไม่ถูกต้อง",
    '__incorrect_ip_or_network_address' => 'IP แอดเดรส หรือเครือข่ายไม่ถูกต้อง',
    '__info' => 'ข้อมูล',
    '__install' => "ติดตั้ง",
    '__install_prefix' => "ติดตั้ง",
    '__invalid_cert_id' => "การรับรอง ID ไม่ถูกต้อง",
    '__invalid_context' => "บริบทไม่ถูกต้อง: %1",
    '__invalid_db_usr_name' => "ชื่อผู้ใช้ฐานข้อมูลไม่ถูกต้อง",
    '__invalid_dir_name' => "ชื่อสารบบไม่ถูกต้อง",
    '__invalid_dom_name' => "ชื่อโดเมนไม่ถูกต้อง",
    '__invalid_filename' => "ชื่อไฟล์ไม่ถูกต้อง ห้ามให้โควต้าเดี่ยว และ/หรือการรวม \"../\"",
    '__invalid_id' => "ตัวระบุไม่ถูกต้อง",
    '__invalid_lines_num' => "มีค่าที่ไม่เหมาะสมสำหรับจำนวนแถว อนุญาตให้ใช้เฉพาะตัวเลขเท่านั้น",
    '__invalid_max_letter_size' => "ขนาดข้อความสูงสุดไม่ถูกต้อง",
    '__invalid_pdir_name' => "ชื่อสารบบที่ได้รับการป้องกันไม่ถูกต้อง",
    '__invalid_restart_apache_interval' => "ช่วงเวลารีสตาร์ท Apache ไม่ถูกต้อง",
    '__invalid_tmpl_name' => "ชื่อแม่แบบไม่ถูกต้อง",
    '__invalid_value' => "ค่าไม่เหมาะสม",
    '__ip_addr' => "IP แอดเดรส",
    '__ip_address_and_mask' => "IP แอดเดรสและซับเน็ตมาส์ก",
    '__ip_alias__mask' => "IP แอดเดรสและซับเน็ตมาส์ก",
    '__ip_addr_is_invalid' => "IP แอดเดรสไม่ถูกต้อง",
    '__ip_addr_list' => "IP แอดเดรส",
    '__ip_address_and_mask_hint' => 'ตัวอย่าง %1',
    '__is_owner' => "O",
    '__java_engine' => "จาวา", // indirect
    '__jdk' => "JDK",
    '__kb' => "KB",
    '__kbps' => "KB/s",
    '__kbytes' => "กิโลไบต์",
    '__key_for_virtuozzo_only' => "รหัสลิขสิทธิ์ของคุณใช้สำหรับ Virtuozzo Containers เท่านั้น",
    '__key_limits_exceeding' => "การดำเนินการนี้เกินการจำกัดที่กำหนดโดยลิขสิทธิ์โปรแกรมของคุณ หากคุณได้รับข้อความนี้ คุณอาจต้องติดต่อผู้ให้บริการ หรือผู้ผลิตเพื่อชี้แจงหรือขยายการจำกัดของลิขสิทธิ์นี้",
    '__kilo' => "K",
    '__keywords' => 'คำสำคัญ',
    '__lang_unknown' => 'ไม่สามารถจำภาษาได้',
    '__languages' => 'ภาษา',
    '__learn_more' => 'เรียนรู้เพิ่มเติม',
    '__loading' => 'กำลังโหลด...',
    '__locales' => "ชุดภาษา",
    '__lists' => "รายชื่อผู้รับจดหมาย",
    '__literal_bytes' => "B",
    '__processing' => "โปรดรอสักครู่ <br>กำลังโหลด...",
    '__locale' => "ภาษาของอินเตอร์เฟส",
    '__locale_is_not_defined' => "ไม่ได้ระบุภาษาของหน้าจอ",
    '__local_server_mysql' => 'เซิร์ฟเวอร์ MySQL ในระบบ',
    '__local_server_postgresql' => 'เซิร์ฟเวอร์ PostgreSQL ในระบบ',
    '__local_server_mssql' => 'เซิร์ฟเวอร์ MySQL ในเครื่อง',
    '__log_and_statistics_files' => 'ไฟล์การเข้าสู่ระบบและรายงานสถิติ',
    '__config_files' => 'ไฟล์การกำหนดค่า',
    '__chroot_files' => 'สภาพแวดล้อม Chrooted',
    '__login' => "%1 เข้าสู่ระบบ",
    '__login1' => "เข้าสู่ระบบ",
    '__login_disabled' => "ห้ามเข้าสู่ระบบ",
    '__login_enabled' => "อนุญาตให้เข้าสู่ระบบได้",
    '__login_incorrect' => "คุณใส่ชื่อผู้ใช้หรือรหัสผ่านที่ไม่ถูกต้อง",
    '__login_name' => "%1 ชื่อผู้ใช้",
    '__login_name_is_invalid' => "%1 ชื่อผู้ใช้ไม่ถูกต้อง",
    '__logon_time' => "เวลาการเข้าสู่ระบบ",
    '__ma' => "เมลนามแฝง",
    '__mail' => "เมล",
    '__mail_alias_name' => "ชื่อเมลนามแฝง",
    '__mail_autodiscovery' => 'การค้นหาจดหมายอัตโนมัติ',
    '__mail_exchanger_name_is_invalid' => "ชื่อตัวแลกเปลี่ยนเมลไม่ถูกต้อง",
    '__mail_groups' => "กลุ่มเมล",
    '__mail_list_engine' => "โปรแกรมรายชื่อสำหรับส่งจดหมาย",
    '__mail_name' => "บัญชีเมล",
    '__mail_name_form' => "คุณสมบัติของบัญชีเมล",
    '__mail_names' => "บัญชีเมล",
    '__mail_serv' => "เซิร์ฟเวอร์เมล",
    '__mail_user' => 'ผู้ใช้เมล',
    '__mailgroup' => "กลุ่มเมล",
    '__maillist' => "รายชื่อผู้รับจดหมาย",
    '__maillists' => "รายชื่อผู้รับจดหมาย",
    '__maillist_member' => 'สมาชิกรายชื่อสำหรับส่งจดหมาย',
    '__mailname' => "บัญชีเมล",
    '__mailname_redir_self' => "บัญชีเมลไม่สามารถส่งต่อเมลหาตัวเองได้",
    '__max_dom_num_reached_for_cl' => "จำนวนโดเมนที่กำหนดไว้ถึงขีดจำกัดสำหรับบัญชีลูกค้านี้",
    '__max_file_size_available' => "ขนาดไฟล์ที่ได้รับอนุญาตสูงสุด %1",
    '__max_subdom_num_reached_for_cl' => "จำนวนซับโดเมนที่กำหนดไว้ถึงขีดจำกัดสำหรับบัญชีลูกค้านี้",
    '__max_subdom_num_reached_for_dom' => "เกินขีดจำกัดของจำนวนซับโดเมนสำหรับโดเมน",
    '__max_subdom_num_reached_for_key' => "เกินขีดจำกัดจำนวนซับโดเมินที่อนุญาตในลิขสิทธิ์",
    '__max_traffic_limit' => "ขีดจำกัดทราฟฟิค",
    '__maximum_excl_ip_num' => "บัญชีเมล",
    '__mb' => "MB",
    '__mbytes' => "เมกะไบต์",
    '__mb_month' => "MB/เดือน",
    '__mb_sec' => "MB/วินาที",
    '__gb_sec' => "GB/วินาที",
    '__tb_sec' => "TB/วินาที",
    '__mega' => "M",
    '__minute(s)' => 'นาที',
    '__mls_not_in_key' => "รหัสผลิตภัณฑ์ของคุณไม่รองรับหน้าจอแบบหลายภาษา",
    '__modification_date' => "วันที่ทำการแก้ไข",
    '__module' => "ขยาย",
    '__month' => "เดือน",
    '__month(s)' => "เดือน",
    '__month1' => "ม.ค.",
    '__month10' => "ต.ค.",
    '__month11' => "พ.ย.",
    '__month12' => "ธ.ค.",
    '__month2' => "ก.พ.",
    '__month3' => "มี.ค.",
    '__month4' => "เมษายน",
    '__month5' => "พ.ค.",
    '__month6' => "มิถุนายน",
    '__month7' => "กรกฎาคม",
    '__month8' => "ส.ค.",
    '__month9' => "ก.ย.",
    '__monthly' => "รายเดือน",
    '__months' => "เดือน",
    '__moved_permanently' => 'ย้ายถาวร',
    '__mssql' => "เซิร์ฟเวอร์ Microsoft SQL",
    '__mssql__server' => "เซิร์ฟเวอร์",
    'mssql__server' => "ชื่อ Microsoft SQL server",
    'mssql__unable_to_change_server_name_db_exists' => "ไม่สามารถเปลี่ยนชื่อเซิร์ฟเวอร์ได้: เนื่องจากมีอย่างน้อยหนึ่งฐานข้อมูลในนั้น",
    '__mssql_status' => "สถานะเซิร์ฟเวอร์ Microsoft SQL",
    '__multiply_login_deny' => "ไม่สามารถเข้าระบบได้ ผู้ใช้รายอื่นที่มีชื่อผู้ใช้เหมือนกัน (%1) เข้าระบบ Plesk ไปแล้ว",
    '__mysql' => "MySQL",
    '__mysql_status' => "สถานะเซิร์ฟเวอร์ MySQL",
    '__mysql_version' => "เวอร์ชั่น MySQL",
    '__mariadb' => "MariaDB",
    '__mariadb_status' => "สถานะเซิร์ฟเวอร์ MariaDB",
    '__mariadb_version' => "เวอร์ชัน MariaDB",
    '__percona' => "Percona",
    '__percona_status' => "สถานะเซิร์ฟเวอร์ Percona",
    '__percona_version' => "เวอร์ชัน Percona",
    '__name' => "ชื่อ",
    '__name_invalid' => "nameserver",
    '__nameserver' => "ชื่อ",
    '__network' => "ชื่อไม่ถูกต้อง",
    '__networks' => "เครือข่าย",
    '__no' => "ไม่",
    '__no_ip_address_with_properly_type_available' => "ไม่สามารถกู้คืนข้อมูลสำรองได้ เพราะว่าไม่มี IP แอดเดรสที่เหมาะสมสำหรับการกู้คืน",
    '__no_clients_specified' => "ไม่ได้ระบุบัญชีลูกค้า",
    '__no_comments' => "ไม่มีข้อเสนอแนะ",
    '__nologin' => "ต้องห้าม",
    '__none' => "ไม่มี",
    '__not_configured' => "ไม่ได้กำหนดค่า",
    '__not_implemented_yet' => "ยังไม่ได้นำไปใช้งาน",
    '__not_supported_by_ftp' => "(ไม่รองรับโดยเซิร์ฟเวอร์ FTP)",
    '__notification' => "การแจ้งเตือน",
    '__num_displayed' => "แสดง %1 จาก %2",
    '__num_is_invalid' => "จำนวนไม่ถูกต้อง",
    '__object_not_found' => 'ไม่พบออบเจ็กต์: %1',
    '__of_all' => "% ของทั้งหมด",
    '__off' => "ปิด",
    '__ok' => "ตกลง",
    '__old_passwd' => "รหัสผ่านเก่า %1",
    '__on' => "เปิด",
    '__others' => "อื่นๆ",
    '__other_ip__will_be_added' => 'IP แอดเดรสอื่นๆ (จะถูกเพิ่มไปยังกลุ่ม IP ของลูกค้า)',
    '__out' => "ออก",
    '__p' => "P",
    '__passwd' => "รหัสผ่าน %1",
    '__passwd_is_invalid' => "%1 รหัสผ่านไม่ถูกต้อง",
    '__passwd_not_match' => "รหัสผ่านไม่ตรงกัน!",
    '__path' => "พาธ",
    '__perl_unix_support' => "รองรับ Perl",
    '__perl_win_support' => "รองรับ Perl",
    '__perm_denied' => "ปฏิเสธการอนุญาต",
    '__permissions' => "การอนุญาต",
    '__personal_name' => "ชื่อส่วนตัว",
    '__pg_admin_not_activated' => "ไม่ได้เปิดใช้งาน PostgreSQL ในหน้าการบริหารจัดการเซิร์ฟเวอร์",
    '__pg_not_inst' => "ไม่ได้ติดตั้ง PostgreSQL",
    '__pg_not_run_or_inst' => "ไม่ได้ติดตั้ง หรือไม่ได้เริ่มการใช้งาน PostgreSQL",
    '__pg_not_support_in_key' => "รหัสลิขสิทธิ์ไม่รองรับ PostgreSQL",
    '__phone' => "โทรศัพท์",
    '__phosting' => "โฮสติ้งทางกายภาพ",
    '__php_support' => "สนับสนุน PHP",
    '__php_run_as_isapi' => "ใช้งานในฐานะส่วนต่อขยายของ ISAPI",
    '__php_safe_mode' => "PHP 'safe_mode' บน",
    '__php_version' => "เวอร์ชั่น PHP",
    '__physical' => "โฮสติ้งทางกายภาพ",
    '__plesk_stat_pdir' => "ป้องกันสารบบ '/plesk-stat/webstat/'",
    '__plesk_stat_dir_name' => "สถิติโดเมน",
    '__plesk_stat_protect' => "ป้องกันการเข้าถึงสถิติเว็บด้วยชื่อผู้ใช้และรหัสผ่าน  FTP ของผู้ใช้",
    '__plesk_stat_protect_install' => "สามารถเข้าถึงได้โดยผ่านสารบบที่ได้รับการป้องกันด้วยรหัสผ่าน '/plesk-stat/webstat/'",
    '__pop3_imap' => "POP3/IMAP", // indirect
    '__pop3_status' => "สถานะเซิร์ฟเวอร์ POP3",
    '__popen_error' => "เกิดข้อผิดพลาดขึ้นในขณะที่ทำการเรียกฟังก์ชั่น popen",
    '__port' => 'พอร์ท',
    '__postgres' => "PostgreSQL",
    '__postgresql' => "PostgreSQL",
    '__postgresql_status' => "สถานะ PostgreSQL",
    '__preferences' => "การตั้งค่า",
    '__account_preferences' => "การตั้งค่าบัญชี",
    '__interface_preferences_general' => 'ทั่วไป',
    '__interface_preferences_default' => 'ปรับตั้งค่าหน้าจอเริ่มต้น',
    '__interface_preferences_admin' => "ปรับตั้งค่าหน้าจอผู้ใช้ระบบ",
    '__interface_template' => 'แม่แบบการกำหนดค่าหน้าจอ',
    '__interface_preferences' => "การตั้งค่าหน้าจอ",
    '__proceed?' => "คุณต้องการดำเนินการต่อใช่ไหม?",
    '__protect_dir_user' => "ผู้ใช้สารบบที่ได้รับการป้องกัน",
    '__protect_dir_users' => "ผู้ใช้สารบบที่ได้รับการป้องกัน",
    '__provider_contact_name' => "ชื่อติดต่อของเจ้าของ",
    '__python_unix_support' => "รองรับ Python",
    '__python_win_support' => "รองรับ Python",
    '__quota' => "โควตา",
    '__r' => "R",
    '__reconfigure' => "ปรับตั้งค่าใหม่",
    '__record_type' => "ประเภทบันทึก",
    '__release' => "ออกวางจำหน่าย",
    '__remote_db_not_supported_by_key' => 'รหัสลิขสิทธิ์ของคุณไม่รองรับโฮสติ้งฐานข้อมูลทางไกล',
    '__remove' => "ลบ",
    '__remove_confirmation' => "ยืนยันการลบ",
    '__remove_protection' => 'ลบการป้องกัน',
    '__report' => "รายงาน",
    '__report_size_na' => "ไม่มีบริการ",
    '__reports_list' => "รายงาน",
    '__requested' => "ร้องขอแล้ว",
    '__required_fields' => "ช่องที่ต้องใส่ข้อมูล",
    '__resp_name_invalid' => "ชื่อการตอบกลับอัตโนมัติไม่ถูกต้อง ใช้เพียงตัวอักษระและตัวเลข จุด ขีดล่าง และเว้นวรรคเท่านั้น",
    '__c' => "A", // Access to panel
    '__s' => "S",
    '__server_name_is_invalid' => "ชื่อเซิร๋ฟเวอร์ไม่ถูกต้อง",
    '__screenshots' => 'ภาพถ่ายหน้าจอ',
    '__script_warning' => "ด้วยการลบความสามารถของบทคำสั่งจากโดเมนนี้ บทคำสั่งที่มีอิทธิพลทั้งหมดจะปรากฏขึ้นในข้อความธรรมดาเมื่อเรียกดูโดยเบราว์เซอร์ แนะนำให้ผู้ดูแลระบบลบบทคำสั่งทั้งหมดจากโดเมนที่ให้มา",
    '__sec' => "วินาที",
    '__second(s)' => "วินาที",
    '__see_list_of_logged_in' => "ดูรายการผู้ใช้ที่เข้าระบบปัจจุบัน",
    '__select_certs_to_remove' => "เลือกการรับรองเพื่อลบ",
    '__select_files_to_remove' => "เลือกไฟล์เพื่อลบ",
    '__select_ip' => "กำหนด IP แอดเดรส",
    '__select_ip_to_remove' => "เลือก IP แอดเดรสเพื่อลบ",
    '__select_domain_template' => "ใช้การตั้งค่าแม่แบบโดเมน",
    '__select_templates_to_remove' => "เลือกแม่แบบเพื่อลบ",
    '__server' => "เซิร์ฟเวอร์",
    '__server_total' => "เซิร์ฟเวอร์ทั้งหมด",
    '__service' => "บริการ",
    '__service_title__plesk' => "Plesk",
    '__service_description__plesk' => "Plesk",
    '__service_title__mysql' => "เซิร์ฟเวอร์ฐานข้อมูล MySQL",
    '__service_description__mysql' => "เซิร์ฟเวอร์ฐานข้อมูล MySQL",
    '__service_title__web' => "เซิร์ฟเวอร์เว็บ",
    '__service_description__web' => "เซิร์ฟเวอร์เว็บ",
    '__service_title__smtp' => "เซิร์ฟเวอร์ SMTP",
    '__service_description__smtp' => "เซิร์ฟเวอร์ SMTP",
    '__service_title__mail' => "เซิร์ฟเวอร์ IMAP/POP3",
    '__service_description__mail' => "เซิร์ฟเวอร์ IMAP/POP3",
    '__service_title__dns' => "เซิร์ฟเวอร์ DNS",
    '__service_description__dns' => "เซิร์ฟเวอร์ DNS",
    '__service_title__postgresq' => "เซิร์ฟเวอร์ฐานข้อมูล PostgreSQL",
    '__service_description__postgresq' => "เซิร์ฟเวอร์ฐานข้อมูล PostgreSQL",
    '__service_title__spamassassin' => "บริการตัวกรองสแปม SpamAssassin",
    '__service_description__spamassassin' => "บริการตัวกรองสแปม SpamAssassin",
    '__services' => "บริการ",
    '__all_services' => "บริการทั้งหมด",
    '__sessions' => "ช่วงเวลา",
    'sessions__feature_ftp_session_manager_not_supported' => "คุณลักษณะของ FTP Sessions ไม่ได้รับการรับรองโดย FTP เซิร์ฟเวอร์ในปัจจุบัน",
    '__sessions_list' => "ช่วงเวลา",
    '__set' => "เปิด",
    '__shared' => "ใช้ร่วมกัน",
    '__shell_access_warning' => "การอนุญาตให้เชลล์เข้าถึงระบบเป็นสิ่งที่อันตรายต่อการรักษาความปลอดภัยของระบบเป็นอย่างสูง อนุญาตการเข้าถึงระบบเฉพาะในกรณีที่คุณเข้าใจว่าคุณกำลังทำอะไรอยู่อย่างชัดแจ้งเท่านั้น และเฉพาะจากผู้ใช้ที่เชื่อถือได้เท่านั้น คุณต้องการที่จะอนุญาตการเข้าถึงจริงๆ ใช่หรือไม่?",
    '__siteapp_not_support_in_key' => "รหัสลิขสิทธิ์ไม่รองรับแอพพลิเคชั่นเว็บ",
    '__siteapp_cannot_reconfigure_with_remote_database' => 'การตั้งค่าของแอพพลิเคชั่นเว็บนี้ถูกเปลี่ยนแปลง เพื่อที่จะป้องกันการเปลี่ยนแปลง ระบบจะปิดการใช้งานของการตั้งค่าผ่าน Plesk',
    '__site_management' => "เว็บเผยแพร่", // indirect
    '__size' => "ขนาด",
    '__skeleton' => 'แม่แบบโฮสต์เสมือนจริง',
    '__skins' => 'สกิน',
    '__smtp' => "SMTP", // indirect
    '__smtp_status' => "สถานะของเซิร์ฟเวอร์ SMTP",
    '__some_fields_are_empty_or_invalid' => "มีบางช่องว่างหรือมีค่าที่ไม่เหมาะสม",
    '__unable_to_set_parameters' => "ไม่สามารถตั้งพารามิเตอร์ของคอมโพแนนท์ได้",
    '__spamassassin' => "ตัวกรองสแปม",
    '__spamassassin_status' => "สถานะ SpamAssassin",
    '__spamd_status' => 'สถานะตัวกรองสแปม',
    '__splited_backup' => "(การสำรองข้อมูล multivolume)",
    '__split_backup_file' => "สร้างการสำรองข้อมูล multivolume",
    '__split_backup_size' => "ขนาดปริมาณ",
    '__split_backup_less_than_500' => "ไม่รองรับปริมาณที่มีขนาดน้อยกว่า 500 เมกะไบต์",
    '__ssi' => "SSI",
    '__ssi_support' => "รองรับ SSI",
    '__ssi_with_html' => "ใช้ SSI สำหรับไฟล์ *.htm *.html",
    '__ssl' => 'SSL/TLS',
    '__ssl_support' => "การสนับสนุน SSL/TLS",
    '__same_ssl' => "ใช้สารบบเดี่ยวสำหรับเก็บเนื้อหา SSL/TLS และ Non-SSL/TLS",
    '__same_ssl_cu' => "เนื้อหา SSL/TLS และ Non-SSL/TLS ทั่วไป",
    '__state' => "รัฐ/จังหวัด",

    '__status__Active' => 'ใช้งานอยู่',
    '__status__active' => 'ใช้งานอยู่',
    '__status__Passive' => 'ปิด',
    '__status__passive' => 'ปิด',
    '__status__off' => 'ปิด',
    '__status__with_parent' => 'ปิด',
    '__status__backup_restore' => 'ระงับชั่วคราวเพื่อการสำรองข้อมูลหรือการกู้คืน',
    '__status__admin' => 'ระงับโดยผู้ดูแลระบบเซิร์ฟเวอร์',
    '__status__resseler' => 'ระงับโดยตัวแทนจำหน่าย',
    '__status__client' => 'ถูกระงับโดยลูกค้า',
    '__status__unknown' => 'สถานะไม่รู้จัก',

    '__status_of' => "%1 สถานะ",
    // end of akss part

    // shramko part

    '__stunnel' => "Stunnel",
    '__stunnel_server' => "เซิร์ฟเวอร์ Stunnel", // indirect
    '__subdomain' => "ซับโดเมน",
    '__subdomain_name' => "ชื่อซับโดเมน",
    '__subdomain_name_in_ASCII_form' => "ชื่อซับโดเมนในรูปแบบ ASCII",
    '__subdomains' => "โดเมนย่อย",
    '__domainaliases' => "โดเมนนามแฝง",
    '__subdomains_list' => "โดเมนย่อย",
    '__subdomains_not_support_in_key' => "รหัสลิขสิทธิ์ไม่รองรับการทำงานของซับโดเมน",
    '__sys_user_type' => "ผู้ใช้ FTP",
    '__sys_user_type_main' => "ใช้บัญชี FTP ของโดเมนหลัก",
    '__sys_user_type_native' => "สร้างบัญชีผู้ใช้ FTP แยกสำหรับซับโดเมนนี้",
    '__t' => "T",
    '__target_domain' => "โดเมนเป้าหมาย",
    '__template' => "แม่แบบ",
    '__template_not_accepted' => "ไม่สามารถยอมรับแม่แบบ: เกินขีดจำกัดดังต่อไปนี้",
    '__templates' => "แม่แบบ",
    '__templates_list' => "แม่แบบ",
    '__tera' => "T",
    '__title' => "ชื่อเรื่อง",
    '__tools' => "เครื่องมือ",
    '__total' => "ทั้งหมด %1",
    '__total_size' => "ขนาดทั้งหมด",
    '__total_used' => "การใช้ทั้งหมด",
    '__traffic' => "การรับส่งข้อมูล",
    '__traffic_by_client' => "ทราฟฟิคโดยลูกค้า",
    '__traffic_by_domain' => "ทราฟฟิคโดยโดเมน",
    '__traffic_by_service' => "ทราฟฟิคโดยบริการ",
    '__traffic_history' => "ประวัติทราฟฟิค",
    '__unable_change_locale' => "ไม่สามารถเปลี่ยนแปลงภาษาของหน้าจอ: %1",
    '__unable_create_new_dom' => "ไม่สามารถสร้างโดเมนได้: %1",
    '__unable_define_dom_name' => "ไม่สามารถกำหนดชื่อโดเมน: %1",
    '__unable_define_necessary_properties' => "ไม่สามารถกำหนดคุณสมบัติทั้งหมดที่ต้องการ",
    '__unable_define_properties' => "ไม่สามารถกำหนดคุณสมบัติ: %1",
    '__unable_exec_util' => "ไม่สามารถดำเนินการใช้ยูทิลิตี้: %1",
    '__unable_get_dns_a_recs' => "ไม่สามารถเรียกคืน IP แอดเดรสสำหรับรายการ DNS สำหรับบัญชีโฮสติ้งนี้: %1",
    '__unable_get_mbox_quota' => "ไม่สามารถเรียกคืนข้อมูลเกี่ยวกับการขจำกัดขนาดกล่องจดหมาย",
    '__unable_redirect_to_myself' => "ไม่สามารถส่งต่อไปยังบัญชีเดิมได้",
    '__unable_redirect_to_my_alias' => "ไม่สามารถส่งต่้อเมลนี้ไปยังนามแฝงเมลได้",
    '__default_domain_redirect_to_myself' => "ไม่สามารถตั้งค่าโดเมนเป็นค่าเริ่มต้นสำหรับ IP แอดเดรส: \nตรวจพบว่ามีการเปลี่ยนทิศทางใหม่เอง",
    '__unable_remove_client' => "ไม่สามารถลบลูกค้่า %1",
    '__unable_set_up_mbox_quota' => "ไม่สามารถตั้งการจำกัดขนาดกล่องจดหมายสำหรับโดเมน: %1",
    '__unable_setup_pass' => "ไม่สามารถตั้งรหัสผ่าน: %1",
    '__unable_to_create_new_account' => "ไม่สามารถสร้างบัญชีได้: %1",
    '__unable_to_define_db_size' => "ไม่สามารถกำหนดขนาดของฐานข้อมูลได้",
    '__unable_to_enable_short_names' => "ไม่สามารถให้ใช้ชื่อย่อบัญชีเมลสำหรับบัญชี POP3/IMAP ได้",
    '__unable_to_fetch_data_from_submit' => "ไม่สามารถนำข้อมูลที่ส่งมาได้: %1",
    '__unable_to_open_file' => "ไม่สามารถเปิดไฟล์ %1: %2",
    '__unable_to_update_subdomain' => "ไม่สามารถทำการเปลี่ยนแปลงไปยังซับโดเมน: %1",
    '__unable_update_cl_data' => "ไม่สามารถบันทึกการเปลี่ยนแปลงไปยังบัญชีผู้ใช้: %1",
    '__unable_update_db_params' => "ไม่สามารถอัพเดทพารามิเตอร์ฐานข้อมูล: %1",
    '__unable_update_dom_data' => "ไม่สามารถอัพเดทข้อมูลโดเมน: %1",
    '__undefined' => "คลุมเครือ",
    '__uninstall' => "ถอนการติดตั้ง",
    '__unknown_error' => "ข้อผิดพลาดที่ไม่รู้จัก",
    '__unlimited_lower' => "ไม่จำกัด",
    '__unset' => "ปิด",
    '__update' => "อัพเดต",
    '__uploaded_file_is_invalid' => "ไฟล์ที่อัพโหลดไม่ถูกต้อง: %1",
    '__url' => "URL",
    '__usage' => "การใช้ดิสก์",
    '__user' => 'ผู้ใช้',
    '__user_already_logged' => "ผู้ใช้รายอื่นที่มีชื่อผู้ใช้เหมือนกัน (%1) เข้าระบบ Plesk ไปแล้ว",
    '__version' => "เวอร์ชั่น",
    '__aps_license' => "รหัสลิขสิทธิ์",
    '__vh_type' => "ประเภทโฮสต์เสมือน",
    '__vhosts_apache_status' => "สถานะเซิร์ฟเวอร์เว็บ",
    '__wrong_charset_conversion' => 'charset ไม่ถูกต้อง ไม่อนุญาตให้แปลงผันจาก "%1" เป็น "%2"',
    '__warning_' => "คำเตือน!",
    '__warning_excl_ip_num' => "IP แอดเดรสเฉพาะ",
    '__warning_expiration' => "วันที่หมดอายุ",
    '__web_scripting' => "บทคำสั่งเว็บ", // indirect
    '__web_serv' => "เซิร์ฟเวอร์เว็บ", // indirect
    '__web_statistic' => "สถิติเว็บ", // indirect
    '__webmail' => "เว็บเมล", // +indirect
    '__webstat_not_installed' => "ยังไม่ติดตั้ง Webalizer ในเซิร์ฟเวอร์ ติดต่อผู้ให้บริการของคุณเพื่อขอความช่วยเหลือในการติดตั้ง Webalizer",
    '__webstat_support' => "สถิติเว็บ",
    '__webstat_awstats_support' => "AWStats",
    '__webstat_webalizer_support' => "Webalizer",
    '__webstat_awstats' => "AWStats",
    '__webstat_webalizer' => "Webalizer",
    '__webstat_type_change_warning' => "เมื่อคุณเปลี่ยนจากโปรแกรมสถิติหนึ่งไปยังอีกโปรแกรมหนึ่ง รายงานทั้งหมดที่สร้างโดยโปรแกรมสถิติก่อนหน้านี้จะถูกลบ และรายงานใหม่จะถูกสร้างขึ้นมาตามข้อมูลที่อยู่ในไฟล์บันทึกที่เก็บอยู่ในเซิร์ฟเวอร์ ซึ่งหมายความว่า หากคุณตั้งค่าระบบ (ที่โดเมน>โดเมนเนม >บันทึกระบบจัดการ> บันทึกการหมุน) เพื่อเก็บไฟล์บันทึกสำหรับเดือนเดียวเท่านั้น สถิติเว็บจะมีให้เลือกใช้ได้ในเดือนสุดท้ายเท่านั้น คุณต้องการเปลี่ยนไปใช้แพ็คเกจสถิติอื่นหรือไม่",
    '__webstat_perm_denied' => 'คุณไม่ได้รับอนุญาตให้จัดการกับสถิติเว็บ',
    '__webuser' => "ผู้ใช้เว็บ",
    '__sysusers_list' => "ผู้ใช้ระบบ",
    '__sysuser' => "ผู้ใช้ระบบ",
    '__weekly' => "รายสัปดาห์",
    '__whats_new_in_version' => "มีอะไรใหม่ๆ ใน Plesk %1 บ้าง",
    '__wrong_hosting_type__virtual_required' => "การดำเนินการนี้ใช้ได้เฉพาะโดเมนกับการโฮสติ้งเว็บเท่านั้น",
    '__wrong_hosting_type__none' => 'ไม่มีโฮสติ้งเว็บที่ปรับตั้งค่าในโดเมน %1',
    '__wrong_hosting_type__std_fwd' => 'โดเมน %1 มีการส่งต่อแบบมาตรฐานที่ถูกตั้งค่าแล้ว การดำเนินการนี้ใช้ได้เฉพาะโดเมนกับการโฮสติ้งเว็บเท่านั้น',
    '__wrong_hosting_type__frm_fwd' => 'โดเมน %1 มีการส่งต่อที่ถูกตั้งค่าแล้ว การดำเนินการนี้ใช้ได้เฉพาะโดเมนกับการโฮสติ้งเว็บเท่านั้น',
    '__wu' => "ผู้ใช้เว็บ",
    '__www' => "WWW",
    '__www_prefix_was_changed' => "เปลี่ยนส่วนหน้าของ WWW แล้ว ตรวจสอบให้แน่ใจว่าได้ทำการแก้ไขการรับรอง SSL/TLS อย่างสอดคล้องกันแล้ว",
    '__year' => "ปี",
    '__year(s)' => "ปี",
    '__yes' => "ใช่",
    '__you' => "คุณ",
    '__zip_code' => "รหัสไปรษณีย์",
    '__form_normal' => "ปกติ",
    '__form_advanced' => "ขั้นสูง",

    'admin_ed__edit_administrator_info' => "แก้ไขโพรไฟล์ของผู้ดูแล",
    'admin_ed__create_default_client' => "ฉันต้องการสร้างบัญชีลูกค้าตามค่าเริ่มต้น",
    'admin_ed__unable_update' => "ไม่สามารถอัพเดทข้อมูลของผู้ดูแลระบบ: %1",

    'auth__update_admin_info' => "โปรดป้อนข้อมูลของผู้ดูแลระบบ ข้อมูลนี้จำเป็นเพื่อทำการ %1",
    'auth__you_not_have_perm' => "คุณไม่ได้รับอนุญาตให้จัดการโดเมนนี้",
    'auth__key_expired_admin' => 'ใบอนุญาตใช้งาน Plesk ของคุณหมดอายุแล้ว หากต้องการใช้ Plesk อย่างต่อเนื่อง โปรดต่ออายุใบอนุญาตใช้งานของคุณหรือซื้อใบอนุญาตใช้งานใหม่',
    'auth__key_expired_admin_restricted' => 'ใบอนุญาตใช้งาน Plesk ของคุณหมดอายุแล้ว ติดต่อกับผู้ให้บริการของคุณเพื่อใช้งาน Plesk อย่างต่อเนื่อง',
    'auth__key_expired_client' => 'ใบอนุญาตใช้งาน Plesk หมดอายุแล้ว โปรดติดต่อผู้ให้บริการโฮสติ้งของคุณ',
    'autoinstaller__not_installed' => 'ยังไม่ได้ติดตั้งคอมโพเนนท์ Autoinstaller',
    'autoinstaller__release_action' => 'มีการเนินการ',
    'autoinstaller__release_action_icon' => 'S',
    'autoinstaller__release_action_upgrade' => 'อัพเกรตไปยังเวอร์ชั่นใหม่ของ Plesk',
    'autoinstaller__release_action_update' => 'การอัพเดทหรือการเพิ่มคอมโพเนนท์ใหม่',
    'autoinstaller__release_action_up2date' => 'คุณมีเวอร์ชั่นล่าสุดแล้ว',
    'autoinstaller__component_action' => 'สถานะ',
    'autoinstaller__component_action_icon' => 'S',
    'autoinstaller__component_action_install' => 'ไม่ได้ติดตั้ง',
    'autoinstaller__component_action_update' => 'มีอัพเดตพร้อมใช้งาน',
    'autoinstaller__component_action_upgrade' => 'มีการอัพเดทอยู่',
    'autoinstaller__component_action_up2date' => 'คุณมีเวอร์ชั่นล่าสุดแล้ว',
    'autoinstaller__component_action_error' => 'ไม่มีอัพเดท',
    'autoinstaller__component_serverbuildtime' => 'การโปรแกรมล่าสุด',
    'autoinstaller__component_localbuildtime' => 'การปล่อยโปรแกรมของคุณ',
    'autoinstaller__component_installed_version' => 'เวอร์ชั่นของคุณ',
    'autoinstaller__component_available_version' => 'เวอร์ชั่นล่าสุด',
    'autoinstaller__component' => 'คอมโพเนนท์',
    'autoinstaller__components' => 'คอมโพเนนท์',
    'autoinstaller__components_title' => '%1 คอมโพเนนท์',
    'autoinstaller__component_dependency_note' => 'ต้องทำการติดตั้งคอมโพเนนท์ที่คุณเลือก',
    'autoinstaller__install_confirm' => 'ใช่ ฉันต้องการติดตั้งคอมโพเนนท์เหล่านี้',
    'autoinstaller__install_confirm_request' => 'โปรดเลือกกล่องกาเครื่องหมายเพื่อยืนยัน',
    'autoinstaller__install_title' => 'ยืนยันการติดตั้งของคอมโพเนนท์ที่เลือก',
    'autoinstaller__key_update_confirm' => 'ยืนยันการข้ามการอัพเดทรหัส และติดตั้งรหัสเริ่มต้น',
    'autoinstaller__key_update_confirm_request' => 'โปรดเลือกกล่องกาเครื่องหมายเพื่อยืนยัน',
    'autoinstaller__key_update_failed' => '<p>Plesk ไม่สามารถอัพเดตลิขสิทธิ์ผลิตภัณฑ์ของคุณได้</p><p>%1</p><p>ดำเนินการต่อด้วยการอัพเกรดโดยไม่มีลิขสิทธิ์ผลิตภัณฑ์ที่เหมาะสมจะทำให้การติดตั้งลิขสิทธิ์เริ่มต้นมีคุณสมบัติที่จำกัด แนะนำให้ผู้ดูแลสอบถามถึงรหัสลิขสิทธิ์ที่เหมาะสมก่อนดำเนินการอัพเกรดผลิตภัณฑ์</p>',
    'autoinstaller__email' => 'ส่งการแจ้งเตือนไปยัง',
    'autoinstaller__email_admin' => "อีเมลของผู้ดูแลระบบ",
    'autoinstaller__email_email' => 'ที่อยู่อีเมลที่กำหนดเอง...',
    'autoinstaller__release' => 'ชื่อการปล่อย',
    'autoinstaller__releases' => 'มีการปล่อยโปรแกรม',
    'autoinstaller__releases_title' => 'Plesk Updater',
    'autoinstaller__select_components_to_install' => 'เลือกคอมโพเนนท์เพื่อติดตั้ง',
    'autoinstaller__status_error' => 'ข้อผิดพลาด: %1',
    'autoinstaller__status_install_error' => 'ไม่สามารถเริ่มตเนการติดตั้งได้: %1',
    'autoinstaller__status_install_busy' => 'ไม่สามารถเริ้มต้นการติดตั้งได้: มีขั้นตอนการติดตั้งอื่นกำลังทำงานอยู่',
    'autoinstaller__status_install_ok' => 'เริ่มการติดตั้งแล้ว คุณจะได้รับการแจ้งเตือนความคืบหน้าของการติดตั้งผ่านทางอีเมล (%1)',
    'autoinstaller__status_query_busy' => 'กำลังดำเนินการติดตั้ง',
    'autoinstaller__status_query_error' => 'ไม่สามารถเรียกคืนสถานะการติดตั้งได้: %1',
    'autoinstaller__status_unknown' => 'ไม่สามารถเรียกคืนสถานะ autoinstaller',
    'autoinstaller__status_busy' => 'Autoinstaller ไม่ว่าง โปรดรอสักครู่',
    'autoinstaller__configure_title' => 'การตั้งค่าตัวอัพเดท',
    'autoinstaller__preferences_legend' => 'การตั้งค่า',
    'autoinstaller__target' => 'สารบบดาวน์โหลดชั่วคราว',
    'autoinstaller__target_invalid' => "ระบุพาธที่แน่นอน",
    'autoinstaller__check_updates' => 'ตรวจสอบการอัพเดตจากการเข้าใช้ Plesk ของผู้ดูแล',
    'autoinstaller__check_updates_warning' => 'ใหม่ <a href="%1">updates</a> มีสำหรับ %2',
    'autoinstaller__source_type' => 'ประเภททรัพยากร',
    'autoinstaller__source' => 'URL ทรัพยากร',
    'autoinstaller_source__preferences_legend' => 'การตั้งค่า',
    'autoinstaller_source__type' => 'ประเภททรัพยากร',
    'autoinstaller_source__url_invalid' => 'ทรัพยากรไม่ถูกต้อง',
    'autoinstaller_source__url_invalid_network' => 'URL ทรัพยากรไม่ถูกต้อง (เช่น: http://source, ftp://source)',
    'autoinstaller_source__url' => 'URL ทรัพยากร',
    'autoinstaller__source_invalid_network' => 'ที่อยู่เครือข่ายที่คุณระบุไม่ถูกต้อง',
    'backup__repository' => 'ตำแหน่งของพื้นที่จัดเก็บไฟล์สำรองข้อมูล',
    'backup__error_notify_email' => 'หากเกิดความผิดพลาดระหว่างการสำรองข้อมูล ให้แจ้งเตือนไปยังอีเมล',
    'backup__dump_info' => "ข้อมูลการสำรองข้อมูล",
    'backup__dump_file_name_not_defined' => "ไม่ได้ระบุชื่อไฟล์สำรอง",
    'backup__local_file' => 'ไฟล์สำรองในเครื่อง',
    'backup__domain_ftp' => 'เซิร์ฟเวอร์ FTP ทางไกล',
    'backup__wrong_path' => "เส้นทางไปยังพื้นที่จัดเก็บไฟล์สำรองข้อมูลไม่ถูกต้อง: ห้ามใช้ลำดับของตัวอักษร ../../",
    'backup__unable_to_connect_to_ftp_server' => "ไม่สามารถเชื่อมต่อกับเซิร์ฟเวอร์ FTP: %1",
    'backup__unable_to_read_file' => 'ไม่สามารถอ่านไฟล์สำรองได้',
    'backup__backup_task_does_not_exist' => "ไม่มีงานสำรองข้อมูล คุณควรสร้างงานก่อนเปิด",
    'backup__restore_params' => "พารามิเตอร์การกู้คืน",
    'backup__confirmation' => "คำเตือน: โดเมนจะไม่สามารถใช้งานได้ในระหว่างการสำรองหรือการกู้คืนข้อมูล",
    'backup__backup_method' => 'วิธีการสำรองข้อมูล',
    'backup__dumpfile_name' => "ชื่อไฟล์สำรอง",
    'backup__dumpfile_name_is_invalid' => "ชื่อไฟล์สำรองไม่ถูกต้อง: ใช้ตัวอักษรและตัวเลข ขีด จุด และเครื่องหม่ายขีดเส้นใต้เท่านั้น ห้ามใช้ชื่อที่เป็นคำอธิบาย * เป็นชื่อไฟล์สำรอง",
    'backup__email_required' => "ต้องใช้ที่อยู่อีเมลของคุณเพื่อแจ้งให้คุณทราบถึงความคืบหน้าการสำรองและกู้คืนข้อมูล  โปรดระบุอีเมลของคุณในรายละเอียดบัญชี",
    'backup__error_during_backup' => "ไม่สามารถสร้างไฟล์สำรอง: %1",
    'backup__input_email_warning' => "คุณควรระบุอีเมลสำหรับการแจ้งเตือนหรือล้างกล่องเครื่องหมาย",
    'backup__make_download' => "ห้ามจัดเก็บไฟล์สำรองในพื้นที่จัดเก็บข้อมูล ทำได้เฉพาะการดาวน์โหลดไฟล์เท่านั้น",
    'backup__make_dump' => 'สร้างไฟล์สำรองและจัดเก็บไว้ในพื้นที่จัดเก็บข้อมูลในระบบ',
    'backup__makedump_to_ftp' => 'สร้างไฟล์สำรองและจัดเก็บในเซิร์ฟเวอร์ FTP ทางไกล',
    'backup__restore_ip' => "IP แอดเดรสสำหรับการกู้คืน",
    'backup__select_dumpfile' => "โปรดเลือกสิ่งที่คุณต้องการกู้คืน",
    'backup__time' => "เวลาในการสำรองข้อมูล",
    'backup__day' => 'วันที่ทำไฟล์สำรอง',
    'backup__view_dump_info' => "ดูข้อมูลการสำรองของโดเมน %1",
    'backup__wrong_domain_name' => "ไฟล์สำรองประกอบด้วยข้อมูลของโดเมน %1 ดังนั้น จึงไม่สามารถกู้คืนในโดเมน %2 ได้",
    'backup__incorrect_ftp_user_or_passwd' => "ผู้ใช่ หรือรหัสผ่าน FTP ไม่ถูกต้อง โปรดแก่ไขคุณสมบัติบัญชี FTP",
    'backup__access_denied' => "การเข้าถึงได้รับการปฏิเสธ โปรดแก้ไขคุณสมบัติบัญชี FTP",
    'backup__restore_from' => "กู้คืน %1",
    'backup__domain_session_failed' => 'ยังไม่ได้ทำการสำรองข้อมูลของโดเมน %1',
    'backup__client_session_failed' => 'ยังไม่ได้ทำการสำรองข้อมูลของลูกค้า %1',
    'backup__domain_session_restore_failed' => 'ยังไม่ได้กู้คืนข้อมูลของโดเมน %1',
    'backup__client_session_restore_failed' => 'ยังไม่ได้กู้คืนบัญชีลูกค้า %1',
    'backup__domain_session_complete' => 'ทำการสำรองข้อมูลของโดเมน %1 แล้ว',
    'backup__domain_session_backup' => 'ข้อมูลสำรองของโดเมน %1',
    'backup__client_session_backup' => 'สำรองข้อมูลของลูกค้า %1',
    'backup__domain_stop_title' => 'กำลังยกเลิกการสำรองข้อมูลของโดเมน %1',
    'backup__client_stop_title' => 'ยกเลิกการสำรองข้อมูลบัญชีลูกค้า %1',
    'backup__domain_restore_stop_title' => 'กำลังยกเลิกการกู้คืนข้อมูลของโดเมน %1',
    'backup__client_restore_stop_title' => 'ยกเลิกการกู้คืนข้อมูลบัญชีลูกค้า %1',
    'backup__domain_session_backup_stop' => 'คุณกำลังจะยกเลิกการดำเนินการสำรองข้อมูล ไฟล์ที่ำสำรองแล้วจะไม่ถูกสร้างขึ้นมา',
    'backup__backup_stop_confirm' => 'ใช่ ฉันต้องการหยุดกระบวนการสำรองข้อมูล',
    'backup__restore_stop_confirm' => 'ใช่ ฉันต้องการหยุดกระบวนการกู้คืนข้อมูล',
    'backup__domain_session_restore' => 'ข้อมูลที่กู้คืนของโดเมน %1',
    'backup__domain_session_restore_stop' => 'คุณกำลังจะยกเลิกการดำเนินการกู้คืนข้อมูล',
    'backup__domain_backup_file_info' => 'ข้อมูลไฟล์สำรองของโดเมน',
    'backup__domain_backup_file_list' => 'ไฟล์สำรองที่มีอยู่',
    'backup__domain_backup_progress' => 'ความคืบหน้าการสำรองข้อมูลเว็บไซต์ %1',
    'backup__domain_restore_progress' => 'ความคืบหน้าการกู้คืนข้อมูลเว็บไซต์ %1',
    'backup__domain_backup_progress_elapsed_time' => 'เวลาที่ผ่านไป: %1',
    'backup__domain_restore_progress_elapsed_time' => 'เวลาที่ผ่านไป: %1',
    'backup__domain_restore_session_complete' => 'กู้คืนโดเมน %1 แล้ว',
    'backup__domain_restore_session_complete_message' => 'กู้ึคืนโดเมน %1 แล้ว',
    'backup__domain_backup_file_delete' => 'ไฟล์สำรองดังต่อไปนี้จะได้รับการลบ:',
    'backup__domain_backup_file_for_remove' => 'เลือกไฟล์สำรองที่คุณต้องการลบ',
    'backup__backup_overwrite_file_confirm' => 'การยืนยันการแทนที่',
    'backup__backup_overwrite_file_confirm_text' => 'มีไฟล์สำรองชื่อ "%1" อยู่แล้ว คุณต้องการแทนที่ไฟล์นั้นหรือไม่?',
    'backup__backup_confirm_overwrite' => 'ยืนยันการแทนที่ไฟล์',
    'backup__backup_overwrite_legeng' => 'แทนที่',
    'backup__backup_not_contain_domain' => 'ไฟล์สำรองไม่มีข้อมูลเกี่ยวกับโดเมน %1',
    'backup__backup_not_contain_client' => 'ไฟล์สำรองไม่มีข้อมูลเกี่ยวกับบัญชีลูกค้า %1',
    'backup__backup_client_info' => "สำรองการตั้งค่าของลูกค้าและรายละเอียดบัญชี",
    'backup__client_backup_progress' => 'ความคืบหน้าของการสำรองข้อมูลบัญชีลูกค้า %1',
    'backup__client_session_complete' => 'สำรองข้อมูลของลูกค้า %1 แล้ว',
    'backup__client_backup_file_info' => 'ข้อมูลไฟล์สำรองของลูกค้า',
    'backup__restore_client_info' => "กู้คืนการตั้งค่าของลูกค้าและรายละเอียดบัญชี",
    'backup__client_session_restore' => 'กำลังกู้คืนข้อมูลของบัญชีลูกค้า %1',
    'backup__client_db_server_map' => 'การแปลงเซิร์ฟเวอร์ฐานข้อมูล',
    'backup__domain_db_server_map' => 'การแปลงเซิร์ฟเวอร์ฐานข้อมูล',
    'backup__client_restore_session_complete_message' => 'กู้คืนข้อมูลบัญชีลูกค้า %1 แล้ว',
    'backup__client_restore_session_complete' => 'กู้คืนข้อมูลบัญชีลูกค้า %1 แล้ว',
    'backup__restore_select_some' => 'โปรดเลือกสิ่งที่คุณต้องการกู้คืน',
    'backup__client_restore_progress' => 'ความคืบหน้าการกู้คืนข้อมูลของบัญชีลูกค้า %1',
    'backup__new_backup' => 'การสร้างการสำรองข้อมูลใหม่',
    'backup__done' => 'เสร็จแล้ว:',
    'backup__done_domains' => '%1 โดเมนจาก %2',
    'backup__done_clients' => '%1 ลูกค้าจาก %2',
    'backup__remaining' => 'เหลืออยู่:',
    'backup__remaining_domains' => '%1 โดเมน',
    'backup__remaining_clients' => '%1 ลูกค้า',
    'backup__overall_backup_progress' => 'ความคืบหน้าในการสำรองข้อมูลทั้งหมด',
    'backup__comment_n_a' => 'n/a',
    'backup__command_ignore' => 'เพิกเฉยต่อคำสั่ง "%1"',
    'backup__no_objects' => 'ไม่มีสิ่งใดให้ทำการสำรอง',
    'backup__cli_warning_not_enough_ip' => 'คำเตือน: IP แอดเดรสไม่เพียงพอที่จะทำการแปลงค่า IP หลัก',
    'backup__local_repository' => "พื้นที่จัดเก็บข้อมูลของ Plesk",
    'backup__ftp_repository' => 'พื้นที่จัดเก็บข้อมูล FTP',
    'backup__ftp_login' => 'ชื่อผู้ใช้',
    'backup__ftp_password' => 'รหัสผ่าน',
    'backup__ftp_account_settings' => 'การตั้งค่าบัญชี FTP',
    'backup__ftp_account_preferences' => 'การตั้งค่าบัญชี FTP',
    'backup__repository_not_exist' => 'ไม่มีไดเร็กทอรี่นี้',
    'backup__repository_not_readable' => 'ไม่สามารถอ่านสารบบที่ระบุได้',
    'backup__ftp_repository_not_configure' => 'เพื่อใช้พื้นที่จัดเก็บการสำรองข้อมูล FTP <a href=\'%1\'> ให้ระบุบัญชี FTP</a> ก่อน',
    'backup__ftp_repository_list_not_configure' => 'ไม่ได้ระบุการตั้งค่าบัญชี',
    'backup__repository_list_unable_listing' => 'ไม่สามารถเรียกคืนรายการไฟล์ได้',
    'backup__ftp_repository_unable_listing' => 'ไม่สามารถเรียกคืนรายการของสารบบ "%1":',
    'backup__repository_legend' => 'พื้นที่จัดเก็บไฟล์สำรองข้อมูล',
    'backup__store_in_repository' => 'เก็บไฟล์ใน',
    'backup__local_repository_lable' => 'พื้นที่จัดเก็บข้อมูลในระบบ',
    'backup__ftp_repository_lable' => 'พื้นที่จัดเก็บข้อมูล FTP',
    'backup__ftp_repository_not_configure_hint' => '(ไม่ได้ระบุการตั้งค่าบัญชี)',
    'backup__ftp_repository_not_configure_or_forbidden_hint' => '(ไม่ได้ระบุ หรือไม่รองรับบัญชี FTP)',
    'backup__other_user_process_modified' => 'ผู้ใช้อื่นได้หยุดกระบวนการสำรองหรือกระบวนการย้ายข้อมูล',
    'backup__another_user_exist' => 'การปฏิบัติการที่กำลังดำเนินการอยู่ เริ่มดำเนินการโดยผู้ใชเ Plesk คนอื่น ผู้ใช้นี้ยังอยู่ในระบบ Plesk',
    'backup__ftp_repository_wait' => 'โปรดรอสักครู่ในขณะที่ทำการเรียกคืนข้อมูลเกี่ยวกับพื้นที่จัดเก็บข้อมูล FTP',
    'backup__ftp_write_test_failed' => 'การเขียนข้อมูลทดสอบไปยังบัญชี FTP %1 ล้มเหลว',
    'backup__ftp_storage' => 'พื้นที่จัดเก็บข้อมูล FTP',
    'bt_upload_to_repository' => 'อัพโหลดไฟล์ไปยังพื้นที่จัดเก็บข้อมูลในระบบ',
    'bt_new_restore' => "กู้คืน",
    'bt_backup_schedule' => "การสำรองข้อมูลตาราง",
    'backup_exist_backups' => "ไฟล์สำรองที่มีอยู่",
    'backup_dialog__page_title' => "การสร้างไฟล์สำรอง",
    'backup_dialog__please_wait' => "กระบวนการสำรองไฟล์กำลังจะเริ่มต้น อาจใช้เวลาซักครู่ โปรดรอ...",
    'backup_conf__page_title' => 'การปรับตั้งค่าการสำรองข้อูล',
    'bt_accept' => "ยอมรับ",
    'bt_access' => "การเข้าถึง",
    'bt_action_log' => "บันทึกการทำงาน",
    'bt_add' => "เพิ่ม",
    'bt_add_client' => "เพิ่มที่อยู่ใหม่",
    'bt_database_server_add' => 'เพิ่มเซิร์ฟเวอร์ฐานข้อมูล',
    'bt_add_services' => "เพิ่มบริการ",
    'bt_anonftp_stats' => "Anon.FTP Stats",
    'bt_anonymous_ftp' => "FTP นิรนาม",
    'bt_aspdotnet' => "ASP.NET",
    'bt_attach' => "แนบ",
    'bt_autoinstaller' => 'ตัวอัพเดท',
    'bt_auto-updates' => 'ตัวอัพเดท',
    'bt_back' => "<< กลับ",
    'bt_backup' => "สำรองข้อมูล",
    'bt_backup_configure' => "ตั้งค่าการสำรองข้อมูล",
    'bt_buy_certs' => "ซื้อการรับรอง",
    'bt_card' => "การ์ด",
    'bt_cert' => "การรับรอง",
    'bt_certificates' => "การรับรอง",
    'bt_change_passwd' => "เปลี่ยนรหัสผ่าน",
    'bt_clear' => "ล้าง",
    'bt_client_templates' => "แม่แบบลูกค้า",
    'bt_clients' => "ลูกค้า",
    'bt_codepage_change' => 'เปลี่ยนการเข้ารหัส',
    'bt_comp_info' => "การจัดการคอมโพเนนท์",
    'bt_configure_maillists' => "ติดตั้ง Mailman",
    'bt_configure' => 'ปรับตั้งค่า',
    'bt_copy' => "คัดลอก",
    'bt_copy_move' => "คัดลอก/ย้าย",
    'bt_create' => "สร้าง",
    'bt_create_account' => "สร้างบัญชี",
    'bt_create_dir' => "เพิ่มไดเร็กทอรี่",
    'bt_create_file' => "เพิ่มไฟล์",
    'bt_count_size' => "คำนวณขนาด",
    'bt_crontab_unix' => "Crontab",
    'bt_crontab_win' => "ตัวจัดลำดับงาน",
    'bt_custom_button_new' => "เพิ่มปุ่ม",
    'bt_custom_buttons' => "ปุ่มที่กำหนดเอง",
    'bt_customize' => "กำหนดเอง",
    'bt_databases' => "ฐานข้อมูล",
    'bt_database_servers' => 'เซิร์ฟเวอร์ฐานข้อมูล',
    'bt_sqlservers' => "เซิร์ฟเวอร์ฐานข้อมูล",
    'bt_db_usr_new' => "เพิ่มผู้ใช้ฐานข้อมูล",
    'bt_db_new' => "เพิ่มฐานข้อมูล",
    'bt_db_phpmyadmin' => "MySQL Admin",
    'bt_dbuser_default' => "ตั้งค่าเริ่มต้นสำหรับ DB Webadmin",
    'bt_decline' => "ปฏิเสธ",
    'bt_default' => "ค่าเริ่มต้น",
    'bt_defaultcomponents' => "บริการของบุคคลที่สาม",
    'bt_defaults' => "ค่าเริ่มต้น",
    'bt_delete' => "ลบ",
    'bt_directories' => "ไดเร็กทอรี่ที่ได้รับการป้องกัน",
    'bt_disable' => "ปิด",
    'bt_dns_zone_sync' => 'ใช้งานการเปลี่ยนแปลงแม่แบบ DNS',
    'bt_dnsrecord_add' => 'เพิ่มบันทึก',
    'bt_do_backup' => "สำรองข้อมูล",
    'bt_do_restore' => "กู้คืน",
    'bt_do_upload' => "อัพโหลด",
    'bt_domain_aliases' => "นามแฝงโดเมน",
    'bt_domain_templates' => "แม่แบบโดเมน",
    'bt_domain_user' => "ผู้ดูแลระบบโดเมน",
    'bt_domain_user_passwd' => "รหัสผ่านผู้ดูแลระบบโดเมน",
    'bt_domains' => "โดเมน",
    'bt_domain_alias_add' => 'เพิ่มโดเมนนามแฝง',
    'bt_download' => "ดาวน์โหลด",
    'bt_edit' => "แก้ไข",
    'bt_enable' => "เปิด",
    'bt_export' => 'ส่งออก',
    'bt_extras' => "สิ่งที่เพิ่มมาเป็นพิเศษ",
    'bt_finish' => "เสร็จสิ่น",
    'bt_ftp_account' => "คุณสมบัติบัญชี FTP",
    'bt_forget_password' => "ลืมรหัสผ่าน?",
    'bt_fp_ssl_webadmin' => "FP-SSL/TLS Webadmin",
    'bt_fp_webadmin' => "FP Webadmin",
    'bt_ftp_stats' => "FTP Stats",
    'bt_get_password' => "รับรหัสผ่าน",
    'bt_global_changes' => "แก้ไข",
    'bt_help' => "ช่วยเหลือ",
    'bt_hide_aliases' => "ซ่อนนามแฝง",
    'bt_hide_toolbar' => 'ซ่อนแถบเครื่องมือ',
    'bt_hide_subdomains' => "ซ่อนซับโดเมน",
    'bt_hide_domainaliases' => "ซ่อนโดเมนนามแฝง",
    'bt_home' => "หน้าหลัก",
    'bt_hosting' => "โฮสติ้ง",
    'bt_icf' => 'ไฟร์วอลล์',
    'bt_install' => "ติดตั้ง",
    'bt_ip_aliasing' => "IP แอดเดรส",
    'bt_ip_add' => "เพิ่ม IP แอดเดรส",
    'bt_ip_pool' => "IP กลุ่ม",
    'bt_key_info' => "ข้อมูลใบอนุญาต",
    'bt_key_buyonline_addons' => 'สั่งเรียกส่วนเสริมต่างๆ ของ Plesk',
    'bt_key_buyonline_upgrades' => 'สั่งเรียกการอัพเกรด Plesk',
    'bt_key_buyonline_new' => 'สั่งซื้อรหัสใหม่',
    'bt_limits' => "จำกัด",
    'bt_locale_add' => 'เพิ่ม Locale',
    'bt_locales' => 'Locale',
    'bt_log_manager' => "ตัวจัดการบันทึก",
    'bt_login' => "เข้าสู่ระบบ",
    'bt_logo' => "การสร้างแบรนด์",
    'bt_logo_send_link' => "แนบลิงก์",
    'bt_logo_send_logo' => "แนบโลโก้",
    'bt_logout' => "ออกจากระบบ",
    'bt_logrotation' => "การหมุนเวียนบันทึก",
    'bt_mail' => "เมล",
    'bt_mail_alias_add' => "เพิ่มเมลนามแฝง",
    'bt_mail_aliases' => "เมลจดหมาย",
    'bt_mail_group_add' => "เพิ่มสมาชิก",
    'bt_mail_groups' => "กลุ่ม",
    'bt_mail_name_add' => "เพิ่มบัญชีเมล",
    'bt_mail_preferences' => "การตั้งค่า",
    'bt_mail_group' => "กลุ่มเมล",
    'bt_mail_mailbox' => "กล่องจดหมาย",
    'bt_mail_redirect' => "ผู้ส่งต่อ",
    'bt_mail_resp_add' => "เพิ่มการตอบกลับอัตโนมัติ",
    'bt_mail_resp_attach_add' => "เพิ่มเอกสารแนบ",
    'bt_mail_resp_files' => "ไฟล์เอกสารแนบ",
    'bt_mail_responders' => "การตอบกลับอัตโนมัติ",
    'bt_mail_spamfilter' => "ตัวกรองสแปม",
    'bt_mail_webmail' => "เว็บเมล",
    'bt_maillist_new' => "เพิ่มรายการจดหมาย",
    'bt_maillists' => "รายการจดหมาย",
    'bt_mailman' => "Mailman",
    'bt_make_dump' => "สร้างการสำรองข้อมูล",
    'bt_manage' => "จัดการ",
    'bt_master' => "มาสเตอร์",
    'bt_migrate' => 'ย้าย',
    'bt_modules_add' => 'เพิ่มนามสกุล',
    'bt_modules_manage' => 'จัดการนามสกุล',
    'bt_move' => "ย้าย",
    'bt_mimetypes' => 'ประเภท MIME',
    'bt_mimetype_new' => 'เพิ่มประเภท MIME',
    'bt_new_client' => "เพิ่มบัญชีลูกค้า",
    'bt_new_domain' => "เพิ่มโดเมน",
    'bt_next' => "ถัดไป>>",
    'bt_next_page' => "ถัดไป",
    'bt_network_add' => "เพิ่มเครือข่าย",
    'bt_notifications' => "การแจ้งเตือน",
    'bt_off' => "ปิด",
    'bt_on' => "เปิด",
    'bt_on_off' => "เปิด/ปิด",
    'bt_pd_new' => "เพิ่มไดเร็กทอรี่ที่ได้รับการป้องกัน",
    'bt_pd_user_new' => "เพิ่มผู้ใช้",
    'bt_performance' => 'สมรรถนะ',
    'bt_permissions' => "การอนุญาต",
    'bt_phpmyadmin' => "PhpMyAdmin",
    'bt_postgre_sql' => "PostgreSQL",
    'bt_preferences' => "การตั้งค่า",
    'bt_prev_page' => "ก่อนหน้า",
    'bt_preview' => 'ตัวอย่างเว็บไซต์',
    'bt_print' => "พิมพ์",
    'bt_reboot' => "รีบูต",
    'bt_reload' => "โหลดใหม่",
    'bt_refresh' => "รีเฟรช",
    'bt_register' => "ลงทะเบียน",
    'bt_remove' => "ลบ",
    'bt_enable_selected' => 'เปิด',
    'bt_disable_selected' => 'ปิด',
    'bt_repair_ip' => "ซ่อมแซม IP",
    'bt_report' => "รายงาน",
    'bt_report_new' => "เพิ่มรูปแบบ",
    'bt_reset' => "รีเซ็ต",
    'bt_restart_services' => "การจัดการบริการ",
    'bt_save' => "บันทึก",
    'bt_send_by_email' => "ส่งผ่านอีเมล",
    'bt_send_file' => "ส่งไฟล์",
    'bt_send_mail' => "ส่งเมล",
    'bt_send_passwd' => "ส่งรหัสผ่าน",
    'bt_send_text' => "ส่งข้อความ",
    'bt_server' => "เซิร์ฟเวอร์",
    'bt_server_add' => "เพิ่มเซิร์ฟเวอร์",
    'bt_server_preferences' => "การตั้งค่าเซิร์ฟเวอร์",
    'bt_servers_list' => "เซิร์ฟเวอร์",
    'bt_sessions' => "ช่วงเวลา",
    'bt_set' => "ตั้งค่า",
    'bt_set_as_default' => "ตั้งเป็นค่าเริ่มต้น",
    'bt_setup' => 'ตั้งค่า',
    'bt_show_aliases' => "แสดงนามแฝง",
    'bt_show_subdomains' => "แสดงซับโดเมน",
    'bt_show_domainaliases' => "แสดงโดเมนนามแฝง",
    'bt_shutdown' => "ปิด",
    'bt_site_apppkgs' => "ตู้นิรภัยของแอพพลิเคชั่น",
    'bt_site_apppool' => "แอพพลิเคชั่นกลุ่ม",
    'bt_application-pool' => "แอพพลิเคชั่นเว็บ",
    'bt_site_apps' => "แอพพลิเคชั่นเว็บ",
    'bt_site_app_add' => "ติดตั้งแอพพลิเคชั่น",
    'bt_site_builder' => "การสนับสนุน Presence Builder",
    'bt_skeleton' => 'แม่แบบโฮสต์เสมือน',
    'bt_skins' => 'สกิน',
    'bt_skin_add' => 'เพิ่มสกิน',
    'bt_skin_manual' => 'Plesk Skins Reference แบบตั้งค่าเอง', // not used
    'bt_skin_download' => 'ดาวน์โหลดสกิน',
    'bt_skin_replace' => 'อัพเดทสกิน',
    'bt_skip' => 'ข้าม',
    'bt_spamassassin' => "ตัวกรองสแปม",
    'bt_spamassassin_train' => "การฝึกอบรม",
    'bt_spamfilter' => "ตัวกรองสแปม",
    'bt_start' => "เริ่ม",
    'bt_stop' => "หยุด",
    'bt_recycle' => "รีไซเคิล",
    'bt_statistics' => "สถิติ",
    'bt_subdomain_new' => "เพิ่มโดเมนย่อย",
    'bt_subdomains' => "โดเมนย่อย",
    'bt_submit' => "ส่ง",
    'bt_summary_report' => "รายงานสรุป",
    'bt_support' => "การสนับสนุน",
    'bt_switch' => "สลับ",
    'bt_system_time' => "เวลาของระบบ",
    'bt_task_new' => "เพิ่มงาน",
    'bt_dom_tmpl_add' => 'เพิ่มแม่แบบโดเมน',
    'bt_cl_tmpl_add' => 'เพิ่มแม่แบบลูกค้า',
    'bt_cron_backup' => 'การตั้งค่าการสำรองข้อมูลตามตาราง',
    'bt_test' => "ทดสอบการเชื่อมต่อ",
    'bt_text' => "ข้อความ",
    'bt_touch' => "เปลี่ยนตราเวลา",
    'bt_traffic' => "การรับส่งข้อมูล",
    'bt_traffic_history' => "ประวัติทราฟฟิค",
    'bt_update' => "อัพเดต",
    'bt_upload' => "อัพโหลด",
    'bt_upload_from_ftp' => "อัพโหลด FTP",
    'bt_virtualdirs' => 'ไดเร็กทอรี่เสมือน',
    'bt_virtualdir_new' => 'เพิ่มไดเร็กทอรี่เสมือน',
    'bt_virtualdir_add' => 'เพิ่มไดเร็กทอรี่เสมือน',
    'bt_web_app_new' => "ติดตั้งแอพพลิเคชั่นจาวา",
    'bt_web_stats' => "สถิติเว็บ",
    'bt_web_stats_ssl' => "SSL/TLS สำหรับสถิติเว็บ",
    'bt_web_user_add' => "เพิ่มผู้ใช้เว็บ",
    'bt_web_users' => "ผู้ใช้เว็บ",
    'bt_webadmin' => "Webadmin",
    'bt_webalizer' => "Webalizer",
    'bt_whats_new_full' => "ดูรายการการเปลี่ยนแปลงแบบเต็มรูปแบบ",
    'cert_add__unable_set_ca_cert' => "ไม่สามารถตั้งการรับรอง CA: %1",
    'cert_add__unable_set_cert' => "ไม่สามารถตั้งการรับรอง: %1",
    'cert_add__unable_set_private_key' => "ไม่สามารถตั้งรหัสส่วนตัว: %1",
    'certificates_list__certificate_used_as_default' => "หนึ่งในการรับรองที่คุณกำลังลบออกเคยใช้เป็นการรับรองเริ่มต้น",
    'certificates_list__certificates_assigned_on_ip' => "กำหนดการรับรองหนึ่งรายการขึ้นไปไปยัง IP แอดเดรส/โดเมน",
    'ch_pass__admin_pass' => "กำลังเปลี่ยนรหัสผ่านของผู้ดูแลระบบ",
    'ch_pass__old_pass' => "รหัสผ่านเก่า",
    'ch_pass__pass_confirm' => "ยืนยัน",
    'ch_pass__unable_change_admin_pass' => "ไม่สามารถเปลี่ยนรหัสผ่านของผู้ดูแลระบบ: %1",
    'check_mail_cycle__aliases' => "ตรวจสอบพบรอบจดหมาย ที่อยู่ \"%1\" อยู่ในนามแฝงของบัญชีเมลนี้",
    'check_mail_cycle__autoresponders' => "ตรวจสอบพบรอบจดหมาย ที่อยู่ \"%1\" อยู่ในการตอบกลับอัตโนมัติของบัญชีเมลนี้",
    'check_mail_cycle__mail_groups' => "ตรวจสอบพบรอบจดหมาย ที่อยู่ \"%1\" อยู่ในกลุ่มของบัญชีเมลนี้",
    'check_mail_cycle__mail_name' => "ตรวจสอบพบรอบจดหมาย ที่อยู่ \"%1\" เกิดขึ้นในเวลาใกล้เคียงกับบัญชีเมลนี้",
    'check_mail_cycle__redirect' => "ตรวจสอบพบรอบจดหมาย ที่อยู่ \"%1\" เกิดขึ้นในเวลาใกล้เคียงกับผู้ส่งต่อบัญชีเมลนี้",
    'check_mail_dup__redirect' => "พบการส่งต่อแบบซ้ำซ้อนรอบจดหมาย ที่อยู่ \"%1\" เกิดขึ้นในเวลาใกล้เคียงกับที่อยู่การส่งต่อบัญชีเมลนี้",
    'check_mail_dup__mail_groups' => "พบการส่งต่อแบบซ้ำซ้อนรอบจดหมาย ที่อยู่ \"%1\" อยู่ในกลุ่มของบัญชีเมลนี้",
    'check_maillist_cycle__admin' => "ตรวจสอบพบรอบจดหมาย อีเมลของผู้ดูแล \"%1\" เกิดขึ้นในเวลาใกล้เคียงกับบัญชีเมลนี้",
    'check_maillist_cycle__member' => "ตรวจสอบพบรอบจดหมาย ที่อยู่ \"%1\" เกิดขึ้นในเวลาใกล้เคียงกับบัญชีเมลนี้",
    'chk_js__enter_login_and_passwd' => "ใส่ชื่อผู้ใช้และรหัสผ่าน",
    'chk_js__enter_login_name' => "ใส่ชื่อผู้ใช้",
    'chk_js__enter_passwd' => "ป้อนรหัสผ่าน",

    // end of shramko part

    // serge part
    'cl_ed__edit_cl' => "รายละเอียดบัญชี %1",
    'cl_limits__cl' => "ขีดจำกัดลูกค้า %1",
    'cl_logo__setup_logo_pref' => "ตั้งคุณสมบัติโลโก้สำหรับลูกค้า %1",
    'cl_new__enter_new_cl_data' => "ป้อนข้อมูลของลูกค้าใหม่",
    'cl_new__unable_to_sent_notification' => 'สร้างบัญชีผู้ใช้แล้ว แต่การแจ้งไปยังลูกค้าล้มเหลว: %1',
    'cl_perm__all_ip' => "IP ทั้งหมดที่มี",
    'cl_perm__all_ip_based_hst_will_be_nb' => "บัญชีโฮสติ้งแบบมี IP เป็นพื้นฐานสำหรับลูกค้าจะโอนไปยังแบบมีชื่อเป็นพื้นฐาน",
    'cl_perm__allow_client_create_domain' => "พื้นที่ที่คุณกำลังเลือกสามารถใช้ได้เฉพาะลูกค้าที่ได้รับอนุญาตในการสร้างโดเมนเท่านั้น",
    'cl_perm__allow_create_nb_w_ip' => "ลูกค้าสามารถสร้างโฮสติ้งแบบมีชื่อเป็นพื้นฐานได้โดยใช้ %1",
    'cl_perm__allow_creation_ip_based_hosting' => "อนุญาตให้ทำการสร้างบัญชีโฮสติ้งที่ใช้ IP",
    'cl_perm__available_ips' => "IP ที่มี",
    'cl_perm__change_limits' => "การปรับการจำกัด",
    'cl_perm__cl_disk_space' => "พื้นทิ่ดิสก์ว่างทั้งหมด",
    'cl_perm__cl_expiration' => "ช่วงเวลาที่ใช้ได้ของบัญชีลูกค้า",
    'cl_perm__cl_max_box' => "กล่องจดหมาย",
    'cl_perm__cl_max_db' => "ฐานข้อมูล",
    'cl_perm__cl_max_dom' => "โดเมน",
    'cl_perm__cl_max_maillists' => "รายชื่อผู้รับจดหมาย",
    'cl_perm__cl_max_subdom' => "โดเมนย่อย",
    'cl_perm__cl_max_traffic' => "จำนวนสูงสุดของทราฟฟิค",
    'cl_perm__cl_max_wu' => "ผู้ใช้เว็บ",
    'cl_perm__cl_mbox_quota' => "จำกัดขนาดกล่องจดหมายของบัญชีผู้ใช้นี้",
    'cl_perm__current_maximum_exp_date' => "ค่าสูงสุดปัจจุบันของระยะเวลาที่ใช้งานได้ของโดเมนคือ %1; :ซึ่งต้องการ %2",
    'cl_perm__current_maximum_mailbox_quota' => "ขีดจำกัดของพื้นที่ดิสก์ที่กำหนดในปัจจุบันที่ได้รับการจัดสรรไว้สำหรับเก็บกล่องจดหมายในบัญชีผู้ใช้นี้คือ %1; ซึ่งต้องการ %2",
    'cl_perm__current_total_requested' => "ค่าทั้งหมดปัจจุบันของขีดจำกัดของโดเมนสำหรับ %1 คือ %2; ซึ่งต้องการ %3",
    'cl_perm__current_total_requested_dom' => "จำนวนของ %1 ในปัจจุบันเป็นของลูกค้ารายนี้คือ %2 แล้วร้องขอ %3",
    'cl_perm__disk_space' => "พื้นที่ดิสก์สูงสุด",
    'cl_perm__dashboard_stdgui' => 'หน้าจอผู้ใช้',
    'cl_perm__dashboard' => 'ดูหน้าหลัก',
    'cl_perm__stdgui' => 'มุมมองมาตรฐาน',
    'cl_perm__manage_dashboard' => 'การจัดการหน้าหลัก',
    'cl_perm__dashboard_and_stdgui' => 'อนุญาตให้ดูหน้าหลักและดูมุมมองมาตรฐาน',
    'cl_perm__dashboard_only' => 'อนุญาตให้ดูหน้าหลักเท่านั้น',
    'cl_perm__stdgui_only' => 'อนุญาตเฉพาะมุมมองมาตรฐานเท่านั้น',
    'cl_perm__edit_cl' => "การอนุญาตลูกค้า %1",
    'cl_perm__exp_date_exceeded' => "ช่วงเวลาที่ใช้ได้ที่คุณกำลังตั้งค่าเกินขีดจำกัดที่ระบุในโดเมนส่วนตัวที่เกี่ยวข้องกับลูกค้ารายนี้",
    'cl_perm__invalid_value' => "ค่าไม่ถูกต้อง ใส่ได้แต่ตัวเลขเท่านั้น",
    'cl_perm__limit_disk_space' => "%1 จำกัดจำนวนของพื้นที่ดิสก์ทั้งหมด",
    'cl_perm__limit_expiration' => "%1 จำกัดช่วงเวลาที่ใช้งานได้สำหรับบัญชีลูกค้า",
    'cl_perm__limit_max_box' => "%1 จำกัดจำนวนสูงสุดของกล่องจดหมาย",
    'cl_perm__limit_max_db' => "%1 จำนวนสูงสุดของฐานข้อมูล",
    'cl_perm__limit_max_dom' => "%1 จำนวนสูงสุดของโดเมน",
    'cl_perm__limit_max_maillists' => "%1 จำนวนสูงของรายชื่อสำหรับส่งจดหมาย",
    'cl_perm__limit_max_subdom' => "%1 จำนวนสูงสุดของซับโดเมน",
    'cl_perm__limit_max_traffic' => "%1 จำนวนสูงสุดของทราฟฟิค",
    'cl_perm__limit_max_wu' => "%1 จำนวนสูงสุดของผู้ใช้เว็บ",
    'cl_perm__limit_mbox_quota' => "%1 ตั้งโควต้ากล่องจดหมาย",
    'cl_perm__limits_exceeded' => "ขีดจำกัดหนึ่งหรือหลายๆ อันที่คุณกำลังตั้งเกินขีดจำกัดที่ระบุอยู่ในโดเมนส่วนตัวที่เป็นของลูกค้ารายนี้\nขีดจำกัดสุทธิสำหรับลูกค้าต้องมากกว่าหรือเท่ากับขีดจำกัดของโดเมนทั้งหมดที่ระบุอยู่ในบัญชีลูกค้า",
    'cl_perm__mailbox_quota_exceeded' => "ขีดจำกัดของจำนวนพื้นที่ดิสก์ที่จัดสรรในกล่องจดหมายที่คุณกำลังตั้งค่าเกินขีดจำกัดที่ระบุในโดเมนส่วนตัวที่เกี่ยวข้องกับบัญชีลูกค้ารายนี้",
    'cl_perm__mailbox_quota_exceeds_server_limit' => "ขีดจำกัดของพื้นที่ดิสก์ที่จัดสรรไว้สำหรับกล่องจดหมายที่คุณพยายามตั้งค่าเกินกว่าการจำกัดที่ระดับของเซิร์ฟเวอร์",
    'cl_perm__make_dumps' => "สำรองและกู้คืนข้อมูล",

    'cl_perm__max_box' => "จำนวนสูงสุดของกล่องจดหมาย",
    'cl_perm__max_db' => "จำนวนสูงสุดของฐานข้อมูล",
    'cl_perm__max_dom' => "โดเมน",
    'cl_perm__max_maillists' => "จำนวนสูงสุดของรายชื่อสำหรับส่งจดหมาย",
    'cl_perm__max_subdom' => "โดเมนย่อย",
    'cl_perm__max_traffic' => "จำนวนสูงสุดของทราฟฟิค",
    'cl_perm__max_wu' => "จำนวนสูงสุดของผู้ใช้เว็บ",
    'cl_perm__max_dom_aliases' => "โดเมนนามแฝง",
    'cl_perm__mbox_quota' => "โควต้ากล่องจดหมาย",
    'cl_perm__not_allow_create_nb_hst' => "ลูกค้าไม่สามารถสร้างโฮสติ้งแบบมีชื่อเป็นพื้นฐานได้",
    'cl_perm__this_ip_used_vrt_hst' => "IP แอดเดรสนี้ใช้โดยโฮสติ้งเสมือน เพื่อทำการลบ \nIP แอดเดรส ให้ลบบริการโฮสติ้งหรือเปลี่ยนแปลงประเภทโดยใช้ชื่อ",
    'cl_perm__unable_off_ipb_creating' => "ลูกค้าได้ตั้งค่าโฮสติ้งแบบมี IP เป็นพื้นฐานแล้ว ล้างกล่องเครื่องหมาย \"การสร้างโดเมน\" หรือลบบัญชีโฮสติ้งที่มี IP เป็นพื้นฐานทั้งหมด หากต้องการปิดการใช้คุณสมบัตินี้สำหรับลูกค้า",
    'cl_perm__unable_off_nb_creating' => "ลูกค้าได้ตั้งค่าโฮสติ้งแบบมีชื่อเป็นพื้นฐานแล้ว ล้างกล่องเครื่องหมาย \"การสร้างโดเมน\" หรือลบบัญชีโฮสติ้งที่มีชื่อเป็นพื้นฐานทั้งหมด หากต้องการปิดการใช้คุณสมบัตินี้สำหรับลูกค้า",
    'cl_perm__unable_set_domain_limit' => "ไม่สามารถจำกัดจำนวนสูงสุดของโดเมน: ลูกค้ามี %1 โดเมนแล้ว",
    'cl_perm__unable_update_client_limitations' => "ไม่สามารถเปลี่ยนขีดจำกัดของบัญชีลูกค้า: %1",
    'cl_pref__edit_cl' => "ความชอบของลูกค้า %1",
    'class_anonftp__create_ftp_domain' => "ไม่มีโดเมนเสมือน FTP สำหรับโดเมนนี้ dom_id ลองสร้างโดเมนก่อน",
    'class_anonftp__incoming_disk_space_should_be_lower' => "ขีดจำกัดพื้นที่ดิสก์ที่คุณพยายามตั้งค่า (%1) ไม่ควรเกินขีดจำกัดพื้นที่ดิสก์ทั้งหมดที่กำหนดไว้ที่ระดับโดเมน (%2)",
    'class_anonftp__invalid_input_only_digits' => "ค่าที่ระบุไม่ถูกต้อง ใส่ได้แต่ตัวเลขเท่านั้น",
    'class_anonftp__unable_change_ownerships' => "ไม่สามารถเปลี่ยนเจ้าของหรือการอนุญาตสำหรับไฟล์โควต้า: %1",
    'class_anonftp__unable_copy_quota_file' => "ไม่สามารถคัดลอกไฟล์โควต้า: %1",
    'class_anonftp__unable_get_disk_usage' => "ไม่สามารถเรียกคืนข้อมูลการใช้ดิสก์ในสารบบที่เข้ามา: %1",
    'class_anonftp__unable_parse_quota_file' => "ไม่สามารถแจงส่วนของไฟล์โควต้า",
    'class_anonftp__unable_read_quota_file' => "ไม่สามารถอ่านไฟล์โควต้า: %1",
    'class_anonftp__unable_update_quota' => "ไม่สามารถอัพเดทโควต้า: ไฟล์ในสารบบที่เข้ามาใช้พื้นที่ดิสก์ %1 KBs ซึ่งเกินกว่าค่าโควต้าใหม่",
    'class_anonftp__unable_write_temp_file' => "ไม่สามารถเขียนไปยังไฟล์ชั่วคราว: %1",
    'class_bsdomain__warn_max_date__' => "ตั้งวันหมดอายุเป็น %1",
    'class_cList__empty' => "ไม่มีรายการ",
    'class_cList__header' => "%1 (%2)",
    'class_cList__not_found' => "ไม่มีไฟล์ที่ตรงกันสำหรับ <b>\"%1\"</b> in %2 (%3 of %4)",
    'class_cList__search_result' => "ผลของการค้นหาสำหรับ <b>\"%1\"</b> in %2 (%3 of %4)",
    'class_client__client_creation_notification' => "แจ้งเืตือนการสร้างลูกค้า",
    'class_client__client_with_contact_name_already_exists' => "ลูกค้าที่มีชื่อ %1 อยู่แล้ว",
    'class_client__disk_space' => "พื้นที่ดิสก์",
    'class_client__invalid_max_dom' => "ค่าจำนวนโดเมนไม่ถูกต้อง ใส่ได้แต่ตัวเลขเท่านั้น",
    'class_client__limit_exceed' => "จำนวน %1 ที่ร้องขอไม่สามารถจัดสรรได้เพราะ จะเกินจำกัดการจัดสรรสำหรับบัญชีของลูกค้า %2 (%3) หากคุณต้องการจัดสรรทรัพยากรมากกว่านี้ ไปยัง ลูกค้า > ชื่อลูกค้า > ขีดจำกัดและเปลี่ยนการจัดสรรตามต้องการ แล้วกลับมายังหน้านี้และลองปรับการจัดสรรอีกครั้ง",
    'class_client__limit_exceed_unlimited' => "หากคุณต้องการจัดสรรจำนวนทรัพยากรแบบไม่มีขีดจำกัด (%1) คุณต้องไปที่ลูกค้า > ชื่อลูกค้า > ขีดจำกัดก่อน และเลือกกล่องเครื่องหมายไม่มีขีดจำกัด ตามประเภททรัพยากรที่ต้องการ แล้วกลับมายังหน้านี้และลองปรับการจัดสรรอีกครั้ง",
    'class_client__max_box' => "กล่องจดหมาย",
    'class_client__max_db' => "ฐานข้อมูล",
    'class_client__max_maillists' => "รายชื่อผู้รับจดหมาย",
    'class_client__max_subdom' => "โดเมนย่อย",
    'class_client__max_traffic' => "ทราฟฟิคสูงสุด",
    'class_client__max_wu' => "ผู้ใช้เว็บ",
    'class_client__max_dom_aliases' => "โดเมนนามแฝง",
    'class_client__mbox_quota' => "โควต้ากล่องจดหมาย",
    'class_client__unable_define_cl_status' => "ไม่สามารถระบุสถานะของบัญชีลูกค้า: %1",
    'class_client__unable_define_inactive_dom' => "ไม่สามารถกำหนดโดเมน %1 ที่ไม่ใช้งานได้",
    'class_client__unable_del_ip' => "ไม่สามารถลบ IP: %1",
    'class_db__db_name_not_set' => "ไม่ได้กำหนดชื่อฐานข้อมูล",
    'class_db__db_not_exist_for_curr_dom' => "ไม่ฐานข้อมูลสำหรับโดเมนนี้",
    'class_db__invalid_db_or_dom_name' => "โดเมนหรือหมายเลขฐานข้อมูลไม่ถูกต้อง หรือไม่มีการกำหนดชื่อฐานข้อมูล",
    'class_db__invalid_pass' => "รหัสผ่านไม่ถูกต้อง",
    'class_db__mailgrp_member_exist' => "มีสมาชิกกลุ่มเมลอยู่แล้ว",
    'class_db__access_hosts_notsupport' => 'การตั้งค่าการเข้าถึงโฮสต์ไม่รองรับประเภทของฐานข้อมูลนี้',
    'class_db__unable_add' => 'ไม่สามารถเพื่มรายการการเข้าสู่โฮสต์: %1',
    'class_db__unable_del' => 'ไม่สามารถลบการเข้าถึงรายการการเข้าสู่โฮสต์: %1',
    'class_db__inc_user_not_exist' => 'ไม่มีผู้ใช้ฐานข้อมูล "%1"',
    'class_db__inc_access_record_exist' => 'รายการการเข้าถึงนี้มีอยู่แล้ว',
    'class_db__inc_access_record_not_exist' => 'ไม่มีรายการการเข้าถึงที่ให้มา',
    'class_db__inc_unable_del_last_record' => 'ไม่สามารถลบรายการการเข้าถึงโฮสต์ล่าสุด',
    'class_domtmpleditform__dns_master' => "ชื่อหลัก",
    'class_domtmpleditform__dns_slave' => "ชื่อรอง",
    'class_domtmpleditform__dns_type' => "ประเภทของโดเมน DNS โซน",
    'clienttrafficlist_header' => "ทราฟฟิคที่โดเมน",
    'clienttrafficlist_header_of_client__' => "ทราฟฟิคที่โดเมนของลูกค้า %1",
    'cmd_dns__a_dns_record_already_exist' => "บันทึกนี้ขัดกับบันทึก A สำหรับโซน",
    'cmd_dns__domain_last_ns' => 'ไม่สามารถลบระเบียน NS สุดท้ายใน DNS สำหรับโดเมนได้',
    'cmd_dns__canonical_dom_name_is_invalid' => "แบบบัญญัติของชื้อโดเมนไม่ถูกต้อง",
    'cmd_dns__cname_dns_record_already_exist' => "บันทึกนี้ขัดกับบันทึก CNAME สำหรับโซน",
    'cmd_dns__cname_in_rr_combination' => 'การรวมรายการ DNS ที่ปรากฏใน DNS โซนไม่ถูกต้อง',
    'cmd_dns__cname_coexist_with_data' => 'รายการการ CNAME DNS โซนไม่สามารถอยู่ร่วมกันกับรายการ DNS อื่นในโซนเดียวกันได้',
    'cmd_dns__dns_record_type_is_invalid' => "ประเภทรายการ DNS ไม่ถูกต้อง",
    'cmd_dns__ext_host_is_not_resolved' => "ชื่อตามมาตรฐานที่ยอมรับ %1 ไม่สามารถแก้ไขเป็น A หรือ AAAA ได้",
    'cmd_dns__domain_restore_dns_zone_failed_add_record' => 'ไม่สามารถเพิ่ม %1 ข้อมูลในโซน %2: %3',
    'cmd_dns__mail_dom_name_is_invalid' => "ชื่อตัวแลกเปลี่ยนเมลไม่ถูกต้อง",
    'cmd_dns__mx_priority_is_invalid' => "ลำดับความสำคัญ MX ไม่ถูกต้อง",
    'cmd_dns__name_server_is_invalid' => "ชื่อเซิร์ฟเวอร์ไม่ถูกต้อง",
    'cmd_dns__network_mask_should_be_24_16_or_8' => "ค่ามาสก์ของเครือข่ายควรเป็น 24 16 หรือ 8",
    'cmd_dns__this_dns_record_already_exists' => "บันทึก DNS มีอยู่แล้ว",
    'cmd_dns__unable_add_record' => "ไม่สามารถเพิ่มรายการ '%1': %2",
    'cmd_dns__unable_add_a_record' => "ไม่สามารถเพิ่มรายการ: %1",
    'cmd_dns__unable_add_cname_record' => "ไม่สามารถเพิ่มรายการ CNAME: %1",
    'cmd_dns__unable_add_dns_record' => "ไม่สามารถเพิ่มรายการ DNS: %1",
    'cmd_dns__unable_add_ext_ns_record' => "ไม่สามารถเพิ่มรายการ EXT_NS: %1",
    'cmd_dns__unable_add_ns_record' => "ไม่สามารถเพิ่มรายการ NS: %1",
    'cmd_dns__unable_add_ptr_record' => "ไม่สามารถเพิ่มรายการ PTR: %1",
    'cmd_dns__unable_add_txt_record' => "ไม่สามารถเพิ่มรายการ TXT: %1",
    'cmd_dns__unable_create_dns_zone' => "ไม่สามารถสร้าง DNS โซน: %1",
    'cmd_dns__unable_define_dns_record' => "ไม่สามารถกำหนดรายการ DNS: %1",
    'cmd_dns__unable_get_default_dns_zone_status_set_true' => "ไม่สามารถเรียกคืนสถานะ DNS โซนเริ่มต้นได้: %1",
    'cmd_dns__unable_insert_a_record' => "ไม่สามารถแทรกรายการ: %1",
    'cmd_dns__unable_insert_mx_record' => "ไม่สามารถแทรกรายการ MX : %1",
    'cmd_dns__unable_insert_ns_record' => "ไม่สามารถแทรกรายการ NS: %1",
    'cmd_dns__unable_set_dns_zone_status' => "ไม่สามารถตั้งสถานะ DNS โซน: %1",
    'cmd_domains__dom_already_exists' => "มีโดเมน %1 อยู่แล้ว",
    'cmd_domains__dns_record_already_exists' => "ไม่สามารถสร้างโดเมน %1 เนื่องจากรายการ DNS ชี้ไปยังโฮสต์ %1 ที่มีอยู่แล้ว",
    'cmd_domains__dom_already_exists1' => "มี %2 ซับโดเมนในโดเมนนี้ โดเมน %1 มีอยู่แล้ว",
    'cmd_domains__dom_already_exists2' => "ซับโดเมน %1 มีอยู่แล้ว",
    'cmd_domains__dalias_already_exists' => "มีนามแฝงนี้อยู่แล้ว",
    'cmd_domains__domain_alias_already_exists' => 'มีโดเมนนามแฝงที่ใช้ชื่อนี้อยู่แล้ว',
    'cmd_domains__unable_del_mail_for_dom' => "ไม่สามารถลบบริการเมลสำหรับโดเมน: %1",
    'cmd_domains__unable_delete_anonymous_ftp' => "ไม่สามารถลบบัญชี FTP นิรนามสำหรับโดเมน: %1",
    'cmd_domains__unable_update_dom_param' => "ไม่สามารถอัพเดทพารามิเตอร์ของโดเมน :%1",
    'cmd_domains__unable_rename_client_exist' => "ชื่อผู้ใช้ของผู้ดูแลโดเมนมีคนใช้แล้ว",
    'cmd_hosting__hst_type_is_not_physical_hst' => "ประเภทโฮสติ้งไม่ใช่แบบทางกายภาพ",
    'cmd_hosting__unable_create_user' => "ไม่สามารถสร้างผู้ใช้ %2: %1",
    'cmd_hosting__unable_define_ip_addr_for_name_based_virtual_hosts' => "ไม่สามารถระบุ IP แอดเดรสโดยใช้ชื่อโฮสต์เสมือน: %1",
    'cmd_hosting__unable_del_old_hst' => "ไม่สามารถลบการตั้งค่าโฮสติ้งก่อนหน้านี้: %1",
    'cmd_hosting__unable_del_protected_directory' => "ไม่สามารถลบสารบบที่ได้รับการป้องกัน: %1",
    'cmd_hosting__unable_del_web_user' => "ไม่สามารถลบผู้ใช้เว็บ: %1",
    'cmd_hosting__unable_make/update_virtual_host' => "ไม่สามารถสร้างหรืออัพเดทโฮสต์เสมือน: %1",
    'cmd_hosting__unable_make_frame_forward_hst' => "ไม่สามารถตั้งค่าโฮสติ้งการส่งต่อเฟรมได้",
    'cmd_hosting__unable_rebuild_ftp_config' => "ไม่สามารถสร้างไฟล์การปรับตั้งค่า proftpd ใหม่ได้: %1",
    'cmd_hosting__unable_set_up_ssl' => "ไม่สามารถตั้งค่า SSL/TLS: %1.",
    'cmd_hosting__unable_unprotect_ssl_directory' => "ไม่สามารถลบการป้องกันจากสารบบ SSL/TLS: %1",
    'cmd_hosting__unable_update_dest_url' => "ไม่สารถอัพเดท URL ปลายทาง: %1",
    'cmd_hosting__unable_update_dns_zone_for_dom_unable_exec_util' => "ไม่สามารถอัพเดท DNS โซนสำหรับโดเมน: การดำเนินการของยูทิลิตี้ล้มเหลว",
    'cmd_hosting__unable_update_ftp_passwd' => "ไม่สามารถอัพเดทรหัสผ่าน FTP %1",
    'cmd_hosting__unable_update_user' => "ไม่สามารถอัพเดทผู้ใช้ %2: %1",
    'cmd_hosting__unknown_hst_type' => "ประเภทโฮสติ้งที่ไม่รู้จัก",
    'cmd_hosting__you_not_have_permission_del_hst' => "คุณไม่มีการอนุญาตให้ยุติการใช้งานบริการโฮสติ้ง",
    'cmd_mail__autoresponder__not_configured' => "ยังไม่ตั้งค่าการตอบกลับอัตโนมัติสำหรับบัญชีเมลนี้",
    'cmd_mail__addr_already_used_in_mail_redirect' => "ที่อยู่ %1 กำลังใช้ในการส่งต่อเมล",
    'cmd_mail__alias_already_exists' => "มีนามแฝงนี้แล้ว",
    'cmd_mail__autoresp_id_and_mailname_id_not_match' => "ID ของการตอบกลับอัตโนมัติและ ID ของบัญชีเมลไม่เหมือนกัน",
    'cmd_mail__autoresp_id_is_undefined' => "ID ของการตอบกลับอัตโนมัติไม่สามารถระบุได้",
    'cmd_mail__mail_alias_already_exists_in_mail_name' => "นามแฝงของเมลที่มีชื่อนี้มีอยู่แล้วสำหรับบัญชีเมล %1",
    'cmd_mail__mail_name_already_exists_in_maillists' => "มีการสมัครใช้บริการบัญชีเมล %1 นี้ในรายชื่อสำหรับส่งจดหมายแล้ว",
    'cmd_mail__mail_name_alredy_exist_in_dom' => "มีบัญชีเมล %1 แล้วในโดเมนนี้",
    'cmd_mail__mail_name_not_exist' => "ไม่มีบัญชีเมล",
    'cmd_mail__mail_name_passwd_part' => "รหัสผ่านไม่ควรมีส่วนใดส่วนหนึ่งของชื่อบัญชีเมล",
    'cmd_mail__maillist_already_exist_in_this_dom' => "มีรายชื่อสำหรับส่งจดหมาย %1 แล้วในโดเมน",
    'cmd_mail__mailname_already_exist_in_mg' => "มีบัญชีเมล %1 แล้วในกลุ่มเมล",
    'cmd_mail__mailname_already_exist_in_this_dom' => "มีบัญชีเมล %1 แล้วในโดเมนนี้",
    'cmd_mail__mailname_already_exists' => "มีบัญชีเมลแล้ว",
    'cmd_mail__mailname_is_invalid' => "ชื่อบัญชีเมล %1 ไม่ถูกต้อง",
    'cmd_mail__mailname_unable_update' => "ไม่สามารถอัพเดทคุณสมบัติของบัญชีเมล:",
    'cmd_mail__max_autoresp_reached_for_this_dom' => "เกินจำนวนสูงสุดของการตอบกลับอัตโนมัติสำหรับโดเมนนี้",
    'cmd_mail__max_mail_groups_num_has_been_reached_for_this_dom' => "เกินจำนวนสูงสุดของกลุ่มเมลสำหรับโดเมนนี้",
    'cmd_mail__max_num_of_redirects_has_been_reached_for_this_dom' => "เกินจำนวนสูงสุดของผู้ส่งต่อสำหรับโดเมนนี้",
    'cmd_mail__max_postboxes_num_has_been_reached' => "เกินจำนวนสูงสุดของกล่องข้อความ",
    'cmd_mail__no_members_specified' => "ไม่มีสมาชิกที่ระบุ",
    'cmd_mail__the_passwd_is_too_simple_choose_another' => "รหัสผ่านง่ายเกินไป โปรดเลือกรหัสผ่านอื่น",
    'cmd_mail__this_addr_already_exist_in_mg_or_mn' => "ที่อยู่อีเมลนี้ถูกใช้แล้ว",
    'cmd_mail__unable_define_autoresp_id' => "ไม่สามารถระบุ ID ของการตอบกลับอัตโนมัติ %1",
    'cmd_mail__unable_update_mail_for_dom' => "การตั้งค่าบริการเมลสำหรับโดเมนล้มเหลว: %1",
    'cmd_mail__unable_del_mail_for_dom' => "ไม่สามารถลบบริการเมลจากโดเมน %1",
    'cmd_mail__unable_del_mail_redirection' => "ไม่สามารถลบบริการการส่งต่อเมล %1",
    'cmd_mail__unable_remove_autoresp' => "ไม่สามารถลบการตอบกลับอัตโนมัติ %1",
    'cmd_mail__unable_remove_mail_group_members' => "ไม่สามารถลบสมาชิกของกลุ่มเมล: %1",
    'cmd_mail__unable_turn_off_mail_group' => "การปิดกลุ่มเมลล้มเหลว: %1",
    'cmd_mail__unable_update_mail_redirect' => "ไม่สามารถตั้งค่าบริการการส่งต่อเมล %1",
    'cmd_mail__uploaded_file_is_too_big' => "ไฟล์ที่อัพโหลดมีขนาดใหญ่เกินไป",
    'cmd_mail__additionally' => "นอกจากนี้:",
    'cmd_pd__invalid_login' => "ชื่อผู้ใช้ไม่ถูกต้อง",
    'cmd_pd__this_user_already_exist' => "ผู้ใช้ดังกล่าวมีอยู่แล้ว",
    'cmd_pd__unable_define_hst_type' => "ไม่สามารถกำหนดประเภทโฮสติ้งได้",
    'cmd_pd__unable_upd_pd_usr' => "ไม่สามารถอัพเดทคุณสมบัติของผู้ใช้ที่ได้รับการป้องกัน: %1",
    'cmd_pd__user_is_undefined' => "ผู้ใช้ไม่ได้รับการกำหนด",
    'cmd_server__no_enough_free_disk_space' => "พื้นที่ดิสก์ไม่เพียงพอ",
    'cmd_server__old_passwd_is_incorrect_please_try_again' => "รหัสผ่านเก่าไม่ถูกต้อง โปรดลองใหม่อีกครั้ง",
    'cmd_web_usr__max_web_users_reached_for_this_dom' => "ถึงขีดจำกัดสูงสุดของผู้ใช้เว็บสำหรับโดเมนนี้",
    'cmd_web_usr__unable_create_user' => "ไม่สามารถสร้างผู้ใช้ระบบ: %1",
    'cmd_web_usr__unable_define_max_web_users_limit' => "ไม่สามารถกำหนดขีดจำกัดสุดสุดของผู้ใช้เว็บ: %1",
    'cmd_web_usr__user_already_exists' => "มีผู้ใช้แล้ว",
    'cmd_web_usr__web_user_name_is_invalid' => "ชื่อผู้ใช้เว็บ %1 ไม่ถูกต้อง",
    'cmd_web_usr__web_user_not_exist' => "ไม่มีผู้ใช้เว็บ",
    'common_func__exec_bad_argument' => "อาร์กิวเมนท์ exec ไม่ควรมีเครื่องหมาย '",
    '__eol' => 'แบ่งบรรทัด',
    'eol__binary_file' => 'ไม่สามารถเปลี่ยนแปลงรูปแบบการแบ่งบรรทัดในไฟล์ทวิภาค',
    'cp_access_admin_deny' => "จำกัดการเข้าถึงส่วนผู้ดูแลระบบจากที่อยู่ '%1' โดยต้องสอดคล้องกับนโยบายการจำกัดการเข้าถึงที่ใช้ในปัจจุบัน",
    'create_domain_warn__' => "ข้อยกเว้นดังต่อไปนี้ได้รับการสร้างขึ้นในระหว่างการสร้างโดเมน:",
    'create_domain__client_select' => 'เลือกลูกค้าเพื่อสร้างโดเมนให้',

    'dashboard__nav_button_name' => "หน้าหลัก",
    'dalias__list_title' => 'โดเมนนามแฝงของโดเมน %1',
    'dalias__list_legend' => 'โดเมนนามแฝง',
    'dalias__list_header' => 'โดเมนนามแฝง',
    'dalias__list_status' => 'S',
    'dalias__list_name' => 'ชื่อนามแฝงโดเมน',
    'dalias__list_ascii_name' => 'ในรูปแบบ ASCII',
    'dalias__remove_title' => 'โดเมนนามแฝงของโดเมน %1 ดังต่อไปนี้จะได้รับการลบ:',
    'dalias__select_domain_aliases_to_remove' => 'เลือกโดเมนนามแฝงที่จะลบ',
    'dalias__mail_turn_on_failed' => 'ไม่สามารถเปิดบริการเมล: %1',
    'dalias__web_turn_on_failed' => 'ไม่สามารถเปิดบริการเมล: %1',
    'db_usr_edit__db_usr_name_old' => "ชื่อผู้ใช้ฐานข้อมูลเก่า",
    'database_server_edit_form__cannot_infer_type' => 'ไม่สามารถสรุปวิธีการเชื่อมต่อจากข้อมูลที่ให้มา ให้ระบุ "127.0.0.1" เป็นชื่อโฮสต์ของเซิร์ฟเวอร์ฐานข้อมูลเพื่อเชื่อมต่อผ่าน TCP/IP ด้วยพอร์ตที่ให้มา หรือปล่อยช่องพอร์ตว่างไว้เพื่อใช้ซ็อกเก็ต Unix "%1"',
    'database_server_edit_form__duplicate' => 'ชื่อโฮสต์หรือ IP แอดเดรส',
    'database_server_edit_form__host_is_invalid' => 'ชื่อโฮสต์ที่ระบุไม่ถูกต้อง',
    'database_server_edit_form__port_is_invalid' => 'หมายเลขพอร์ตที่ระบุไม่ถูกต้อง',
    'database_server_error__consult_admin' => 'โปรดติดต่อผู้ดูแลระบบเซิร์ฟเวอร์',
    'database_server_error__last__connection_failed' => 'ความพยายามครั้งล่าสุดในการควบคุมเซิร์ฟเวอร์ฐานข้อมูลนี้ล้มเหลว เนื่องจากปัญหาของเครือข่าย',
    'database_server_error__last__permission_denied' => 'ความพยายามครั้งล่าสุดในการควบคุมเซิร์ฟเวอร์ฐานข้อมูลนี้ล้มเหลว เนื่องจากบัญชีที่ให้มาไม่ได้มีสิทธิ์ของผู้ดูแล',
    'database_server_error__last__credentials_not_set' => "ความพยายามครั้งล่าสุดในการเชื่อมต่อกับเซิร์ฟเวอร์ล้มเหลว เพราะไม่สามารถระบุชื่อผู้ใช้และรหัสผ่านของผู้ดูแลที่ถูกต้องได้",
    'database_server_error__last__other_error' => 'ความพยายามครั้งล่าสุดในการควบคุมเซิร์ฟเวอร์ฐานข้อมูลนี้ล้มเหลว',
    'database_server_error__real__connection_failed' => 'การเชื่อมต่อไปยังเซิร์ฟเวอร์ฐานข้อมูลล้มเหลว เนื่องจากปัญหาของเครือข่าย:',
    'database_server_error__real__permission_denied' => 'การเชื่อมต่อไปยังเซิร์ฟเวอร์ฐานข้อมูลล้มเหลว เนื่องจากบัญชีที่ให้มาไม่ได้มีสิทธิ์ของผู้ดูแล',
    'database_server_error__real__duplicate_object' => 'การเชื่อมต่อไปยังเซิร์ฟเวอร์ฐานข้อมูลล้มเหลว เนื่องจากชื่อชนกัน:',
    'database_server_error__real__unacceptable_name' => 'การเชื่อมต่อไปยังเซิร์ฟเวอร์ฐานข้อมูลล้มเหลว เนื่องจากชื่อออบเจ็กต์ไม่ถูกต้อง:',
    'database_server_error__real__unacceptable_password' => 'การเชื่อมต่อไปยังเซิร์ฟเวอร์ฐานข้อมูลล้มเหลว เนื่องจากไม่สามารถรับได้',
    'database_server_error__real__credentials_not_set' => "Plesk ไม่สามารถเชื่อมต่อกับเซิร์ฟเวอร์ฐานข้อมูลได้ เพราะไม่สามารถระบุชื่อผู้ใช้และรหัสผ่านของผู้ดูแลที่ถูกต้องได้",
    'database_server_error__real__other_error' => 'การเชื่อมต่อไปยังเซิร์ฟเวอร์ฐานข้อมูลล้มเหลว:',
    'database_server_error__test__connection_failed' => 'การทดสอบเชื่อมต่อไปยังเซิร์ฟเวอร์บานข้อมูลล้มเหลว เนื่องจากปัญหาของเครือข่าย:',
    'database_server_error__test__permission_denied' => 'การทดลองเชื่อมต่อไปยังเซิร์ฟเวอร์ฐานข้อมูลล้มเหลว เนื่องจากบัญชีที่ให้มาไม่ได้มีสิทธิ์ของผู้ดูแล',
    'database_server_error__test__duplicate_object' => 'การทดสอบเชื่อมต่อไปยังเซิร์ฟเวอร์บานข้อมูลล้มเหลว เนื่องจากชื่อชนกัน:',
    'database_server_error__test__unacceptable_name' => 'การทดลองเชื่อมต่อไปยังเซิร์ฟเวอร์ฐานข้อมูลล้มเหลว เนื่องจากชื่อออบเจ็กต์ไม่ถูกต้อง:',
    'database_server_error__test__unacceptable_password' => 'การทดลองเชื่อมต่อไปยังเซิร์ฟเวอร์ฐานข้อมูลล้มเหลว เนื่องจากไม่สามารถรับได้',
    'database_server_error__test__credentials_not_set' => "การทดสอบการเชื่อมต่อกับเซิร์ฟเวอร์ล้มเหลว เพราะไม่สามารถระบุชื่อผู้ใช้และรหัสผ่านของผู้ดูแลที่ถูกต้องได้",
    'database_server_error__test__other_error' => 'ทดสอบการเชื่อมต่อไปยังเซิร์ฟเวอร์ฐานข้อมูลล้มเหลว:',

    'db__create_new_db' => "เพิ่มฐานข้อมูล",
    'db__db_add' => "เพิ่มฐานข้อมูล",
    'db__db_for_dom' => "ฐานข้อมูลของเว็บไซต์ %1",
    'db__db_id_undefined' => "ยังไม่ได้กำหนดหมายเลขฐานข้อมูล",
    'db__db_name' => "ชื่อฐานข้อมูล",
    'db__db_not_exist' => "ไม่มีฐานข้อมูล",
    'db__db_type' => "ประเภท",
    'db__db_server' => "เซิร์ฟเวอร์ฐานข้อมูล",
    'db_server_not_exist' => "ไม่มีเซิร์ฟเวอร์ฐานข้อมูล",
    'db__db_user_not_exist' => "ไม่มีฐานข้อมูล",
    'db__domain_not_exist' => "ไม่มีโดเมนอยู่",
    'db__enter_db_name' => "ป้อนชื่อฐานข้อมูลใหม่",
    'db__invalid_db_id' => "ตัวกำหนดฐานข้อมูลไม่ถูกต้อง",
    'db__invalid_db_name' => "ชื่อฐานข้อมูลไม่ถูกต้อง ชื่อฐานข้อมูลควรประกอบด้วยตัวอักษรละติน สัญลักษณ์ ตัวเลข ขีดล่าง หรือขีดกลางเท่านั้น และต้องไม่เกิน 63 ตัว",
    'db__max_db_reached_for_dom' => "จำนวนฐานข้อมูลถึงขีดจำกัดสำหรับโดเมนนี้แล้ว",
    'db__max_mssql_db_reached_for_dom' => "ไม่สามารถเชื่อมต่อไปยัง PostgreSQL เปิดการสนับสนุน PostgreSQL บนหน้าการบริหารจัดการเซิร์ฟเวอร์",
    'db__postgres_not_connect_for_admin' => "ไม่สามารถเชื่อมต่อไปยัง PostgreSQL ให้ปรึกษาผู้ดูแลระบบสำหรับความช่วยเหลือ",
    'db__postgres_not_connect_for_client' => "ไม่สามารถเชื่อมต่อไปยัง PostgreSQL ให้ปรึกษาผู้ดูแลระบบสำหรับความช่วยเหลือ",
    'db__remove_db_on_domain' => "ฐานข้อมูลภายใต้เว็บไซต์ %2 ที่ลูกค้า %1 เป็นเจ้าของจะถูกลบออก:",
    'db__remove_db_on_domain_of_cl' => "ฐานข้อมูลสำหรับโดเมน %2 ที่ลูกค้า %1 เป็นเจ้าของจะถูกลบออก:",
    'db__remove_db_linked_resource' => 'ฐานข้อมูลนี้ใช้โดยแอพพลิเคชั่นเว็บ ซึ่งสามารถลบออกได้หลังจากถอนการติดตั้งแอพพลิเคชั่นนี้เท่านนั้น',
    'db__remove_db_users' => "ผู้ใช้ฐานข้อมูล %3 ในเว็บไซต์ที่ %2 ลูกค้า %1 เป็นเจ้าของจะถูกลบออก:",
    'db__remove_db_users_of_cl' => "ผู้ใช้ฐานข้อมูล %3 ในเว็บไซต์ที่ %2 ลูกค้า %1 เป็นเจ้าของจะถูกลบออก:",
    'db__select_db_for_remove' => "เลือกฐานข้อมูลที่จะลบ",
    'db__select_db_users_for_remove' => "เลือกฐานข้อมูลผู้ใช้ที่จะลบ",
    'db__unable_create_db_user' => "ไม่สามารถสร้างผู้ใช้ฐานข้อมูล: %1",
    'db__unable_define_db_name' => "ไม่สามารถกำหนดชื่อฐานข้อมูล: %1",
    'db__unable_define_db_user' => "ไม่สามารถกำหนดผู้ใช้ฐานข้อมูล: %1",
    'db__unable_define_db_users' => "ไม่สามารถกำหนดผู้ใช้ฐานข้อมูล: %1",
    'db__unable_select_dom_name' => "ไม่สามารถเลือกชื่อโดเมน: %1",
    'db_edit__db_for_dom' => "ผู้ใช้สำหรับฐานข้อมูล %1 บนโดเมน %2",
    'db_edit__invalid_db_name' => "ชื่อฐานข้อมูลไม่ถูกต้อง",
    'db_edit__no_users' => "ไม่มีผู้ใช้ที่มีสิทธิสำหรับฐานข้อมูลนี้",
    'db_edit__unable_define_db_usrs' => "ไม่สามารถกำหนดผู้ใช้ฐานข้อมูล: %1",
    'db_edit__unable_select_db_usr' => "ไม่สามารถเลือกผู้ใช้ฐานข้อมูล",
    'db_edit__db_user_password_for_' => "โปรดพิมพ์รหัสผ่านเพื่อเข้าระบบในฐานะผู้ใช้ฐานข้อมูล %1",
    'db_list__tab_title_db_type' => "T",
    'db_usr_edit__add_db_usr' => "เพิ่มผู้ใช้ฐานข้อมูล",
    'db_usr_edit__db_usr_name' => "ชื่อผู้ใช้ฐานข้อมูล",
    'db_usr_edit__edit_db_usr' => "ตั้งข้อมูลประจำตัวสำหรับบัญชีผู้ใช้ฐานข้อมูล",
    'db_usr_edit__for_db' => "ในฐานข้อมูล %1",
    'db_usr_edit__not_create_pass' => "การดำเนินการนี้จะส่งผลในการสร้างบัญชีผู้ใช้ฐานข้อมูลที่ไม่ต้องใช้รหัสผ่าน \nคุณต้องการสร้างผู้ใช้โดยไม่ทำการกำหนดรหัสผ่านหรือไม่?",
    'dbuser__only_one_user_can_be_default' => "สามารถตั้งผู้ใช้เป็นค่าเริ่มต้นได้เหนึ่งหนึ่งบัญชีเท่านั้น",
    'db_server__cannot_delete_default' => "ไม่สามารถลบเซิร์ฟเวอร์ฐานข้อมูลเริ่มต้นได้",
    'db_server__cannot_delete_local' => "ไม่สามารถลบเซิร์ฟเวอร์ฐานข้อมูลในเครื่องได้",
    'db_server__cannot_delete_used' => 'ไม่สามารถลบเซิร์ฟเวอร์ฐานข้อมูลในระหว่างมีฐานข้อมูลหรือฐานข้อมูลผู้ใช้อยู่ภายในได้',
    'demo__disabled_in_demo' => "เวอร์ชั่นตัวอย่างไม่รองรับการดำเนินการนี้",
    'defaultcomponents__title' => "กำลังเลือกค่าเริ่มต้นของคอมโพเนนท์",
    'defaultcomponents__select_default' => "เลือกค่าเริ่มต้นของคอมโพเนนท์ %1",//to check
    'defaultcomponents__not_installed' => "(ยังไม่ได้ติดตั้ง)",
    'defaultcomponents__not_configured' => "(ไม่ได้ปรับตั้งค่า)", // to check
    'defaultcomponents__not_opted_to_install_support_files' => "การเลือกประเภทของบางบริการไม่ถูกต้อง หรือไม่มีการเลือกประเภทไว้",
    'defaultcomponents__depends_on' => "(ต้องการ %1)",
    'defaultcomponents__parameters' => "พารามิเตอร์ของ %1",
    'component_name__antivirus' => "ป้องกันไวรัส",
    'component_name__database' => "เซิร์ฟเวอร์ SQL",
    'component_name__sqladmin' => "MySQL Webadmin",
    'component_name__sqladminmysql' => "MySQL Webadmin",
    'component_name__dnsserver' => "เซิร์ฟเวอร์ DNS",
    'component_name__firewall' => "ไฟร์วอลล์",
    'component_name__ftpserver' => "เซิร์ฟเวอร์ FTP",
    'component_name__java' => "จาวา",
    'component_name__mailserver' => "เซิร์ฟเวอร์เมล",
    'component_name__local_mailserver' => "เซิร์ฟเวอร์เมลภายในเครื่อง",
    'component_name__psa' => "Plesk",
    'component_name__script' => "บทคำสั่งเว็บ",
    'component_name__spamfilter' => "ตัวกรองสแปม",
    'component_name__stats' => "สถิติเว็บ",
    'component_name__stunnel' => "SSL/TLS Wrapper",
    'component_name__webmail' => "เว็บเมล",
    'component_name__webpublish' => "เว็บเผยแพร่",
    'component_name__webserver' => "เว็บเซิร์ฟเวอร์",
    'dns__dns_record_invalid_values' => 'ระบุค่าบันทึก DNS ไว้ไม่ถูกต้อง: %1: %2',
    'dns__dns_record_not_found' => 'ไม่พบระเบียน DNS',
    'dns__dns_zone_invalid_values' => 'พารามิเตอร์ DNS โซนที่ระบุไม่ถูกต้อง',

    'dns__soa_mname_title' => 'ชื่อเซิร์ฟเวอร์หลัก',
    'dns__soa_mname_legend' => 'เนมเซิร์ฟเวอร์',
    'dns__soa_mname_autoselect' => '(เลือกโดยอัตโนมัติ)',

    'dns__dns_zone_off_remove_title' => "รายการทรัพยากรดังต่อไปนี้จะได้รับการลบออกจากโซน %1",
    'dns__dns_zone_master_remove_title' => "กำลังลบรายการทรัพยากรจาก DNS Zone %1",
    'dns__dns_zone_slave_remove_title' => "รายการเซิร์ฟเวอร์ชื่อหลักดังต่อไปนี้สำหรับ %1 จะได่รับการลบ:",
    'dns_add__param_ttl' => "TTL",
    'dns_add__enter_spf' => 'ป้อนรายการ',
    'dns_add__is_spf_syntax' => 'รายการ SPF',
    'dns_add__spf_value_is_invalid' => "ค่าของรายการ SPF ไม่ถูกต้อง ควรขึ้นต้นด้วย 'v=spf'",
    'dns__dns_zone_status' => "สถานะ DNS โซน",
    'dns__invalid_ip_address' => "IP แอดเดรสเซิร์ฟเวอร์ DNS หลักใหม่ไม่ถูกต้อง หรือว่าง",
    'dns__ip_address' => "IP แอดเดรส",
    'dns__master_dns_type' => "เป็นเซิร์ฟเวอร์ DNS หลัก",
    'dns__masters' => "เซิร์ฟเวอร์ DNS หลัก",
    'dns__soa_minimum_too_large' => 'ไม่แนะนำให้ใช้แคชตอบสนองในเชิงลบนานกว่าสามชั่วโมง',
    'dns__select_masters_to_remove' => "เลือกเซิร์ฟเวอร์ DNS เบื้องต้นเพื่อลบ",
    'dns__select_template_record_to_remove' => 'เลือกแม่แบบรายการ DNS เพื่อลบ',
    'dns__nameservers_for_domain' => "Nameservers สำหรับโดเมน",
    'dns__remove_dns_zone_of_domain__' => "การลบรายการ DNS จากโดเมน %1",
    'dns__remove_dns_zone_template__' => "รายการ DNS ดังต่อไปนี้จะได้รับการลบออกจากแม่แบบ:",
    'dns__remove_this_dns_record?' => "คุณแน่ใจหรือไม่ว่าต้องการลบรายการ DNS?",
    'dns__restore_default' => "การกู้คืน DNS โซนโดยแม่แบบ",
    'dns__restore_default_confirm' => "การกู้คืน DNS โซนจะเป็นการละทิ้งการปรับตั้งค่า DNS โซนในขณะนี้  ดำเนินการต่อหรือไม่",
    'dns__restore_default_error' => "การกู้คืน DNS โซนผิดพลาด",
    'dns__slave_dns_type' => "เป็นเซิร์ฟเวอร์ DNS รอง",
    'dns__subdomain_dns_rec_removed' => "ลบรายการ A ออกจากโซนซับโดเมนแล้ว %1",
    'dns__zone_switched_off_no_ns' => "โซนได้รับการปิด เนื่องจากไม่มีรายการ NS %1 ซึ่งต้องแสดงขึ้นในโซน เพื่อเพิ่มรายการไปยังโซน ให้คลิกปุ่มเพิ่มรายการ",
    'dns__cant_switch_on_no_ns' => "ไม่สามารถเปิดโซนได้ เนื่องจากไม่มีรายการ %1 ซึ่งต้องแสดงในโซน เพื่อเพิ่มรายการไปยังโซน คลิกปุ่มเพิ่มรายการ",
    'dns__unable_activate/deactivate_dns' => "ไม่สามารถใช้งาน/ยุติการใช้งาน DNS: %1",
    'dns__unable_add_dns_master_duplicate_entry' => "ไม่สามารถเพิ่มเซิร์ฟเวอร์ DNS หลัก: รายการซ้ำ",
    'dns__unable_add_dns_master_local_ip' => "ไม่สามารถเพิ่ม IP แอดเดรสสำหรับเซิร์ฟเวอร์ DNS หลัก: รายการนี้สามารถสร้างบนเซิร์ฟเวอร์ทางไกลได้",
    'dns__unable_define_dns_record' => "ไม่สามารถกำหนดรายการ DNS: %1",
    'dns__unable_get_dns_template_status' => "ไม่สามารถเรียกคืนสถานะแม่แบบ DNS",
    'dns__unable_remove_dns_rec' => "ไม่สามารถลบรายการ DNS: %1",
    'dns__warnings__' => "ผลของการแก้ไข DNS โซน:",
    'dns__you_not_have_perm_manage_dns' => "คุณไม่ได้รับอนุญาตให้จัดการ DNS โซนในโดเมนนี้",
    'dns__cant_create_record_with_server_ip' => "ไม่สามารถเพิ่ม IP แอดเดรสนี้ได้ เพราะไปตรงกับ IP แอดเดรสของเซิร์ฟเวอร์ที่ Plesk เป็นตัวจัดการ",

    'dns__tabs_acl' => "ถ่ายโอนโซน",
    'dns__acl_add_network_legend' => "เพิ่มเครือข่าย",
    'dns__acl_add_ip_legend' => "เพิ่ม IP แอดเดรส",
    'dns__acl_network_not_allowed' => "DNS ในวินโดวส์ไม่อนุญาตให้มีที่อยู่เครือข่ายนี้",
    'dns__acl_enter_ip_address_with_mask' => "IP แอดเดรส/มาสก์",
    'dns__acl_enter_ip_address' => "ที่อยู่ IP",
    'dns__acl_list_network_legend' => "เครือข่ายอนุญาตให้มีสำเนาของ DNS โซนได้",
    'dns__acl_list_ip_legend' => "IP แอดเดรสอนุญาตให้มีสำเนาของ DNS โซนได้",
    'bt_dns_acl_add_network' => "เพิ่มเครือข่าย",
    'bt_dns_acl_add_ip' => "เพิ่ม IP แอดเดรส",

    'dns_add__add_rec_for_zone' => "เพิ่ม %1 สำหรับโซน %2",
    'dns_add__canonical_dom_name_is_invalid' => "แบบบัญญัติของชื้อโดเมนไม่ถูกต้อง",
    'dns_add__enter_canonical_name' => "ชื่อบัญญัติ",
    'dns_add__enter_dom_name' => "ชื่อโดเมน",
    'dns_add__enter_ip_address' => "ที่อยู่ IP",
    'dns_add__enter_ip_mask' => "IP แอดเดรสและมาส์กเครือข่าย",
    'dns_add__enter_mail_domain' => "โดเมนเมล",
    'dns_add__enter_mail_exchanger' => "เซิร์ฟเวอร์การแลกเปลี่ยนเมล",
    'dns_add__enter_nameserver' => "ชื่อเซิร์ฟเวอร์",
    'dns_add__enter_txt_record' => "บันทึก TXT",
    'dns_add__enter_service_name' => "ชื่อบริการ",
    'dns_add__hint_service_name' => "ตัวอย่าง: SIP (โดยไม่มีเครื่องหมายขีดเส้นใต้)",
    'dns_add__enter_protocol' => "โปรโตคอล",
    'dns_add__hint_protocol_name' => "ตัวอย่าง: TCP (โดยไม่มีเครื่องหมายขีดเส้นใต้)",
    'dns_add__protocol_tcp' => "TCP",
    'dns_add__protocol_udp' => "UDP",
    'dns_add__enter_srv_priority' => "ความสำคัญ",
    'dns_add__specify_weight_of_service' => "น้ำหนักสัมพัทธ์ของบันทึกที่มีลำดับความสำคัญเดียวกัน",
    'dns_add__enter_target_host' => "โฮสต์เป้าหมาย",
    'dns_add__hint_target_host' => "ตัวอย่าง: example.com",
    'dns_add__enter_target_port' => "พอร์ทเป้าหมาย",
    'dns_add__caa_tag' => "แท็ก",
    'dns_add__caa_value' => "ค่า",
    'dns_add-invalid-A_ip' => "IP แอดเดรสไม่ถูกต้อง",
    'dns_add-invalid-AAAA_ip' => "IP แอดเดรสไม่ถูกต้อง",
    'dns_add-invalid-PTR_ip_mask' => "จับคู่ IP แอดเดรส/เน็ตมาสก์ไม่ถูกต้อง",
    'dns_add-invalid-SRV_service_name' => "ชื่อบริการไม่ถูกต้อง",
    'dns_add-invalid-SRV_protocol_name' => "โปรโตคอลไม่ถูกต้อง",
    'dns_add-invalid-SRV_target_port' => "พอร์ตปลายทางไม่ถูกต้อง",

    'dns_add__invalid_ip' => "IP แอดเดรสไม่ถูกต้อง",
    'dns_add__low' => "ต่ำ",
    'dns_add__mail_dom_name_is_invalid' => "ชื่อโดเมนเมลไม่ถูกต้อง",
    'dns_add__nameserver_is_invalid' => "ชื่อเซิร์ฟเวอร์ไม่ถูกต้อง",
    'dns_add__record' => "รายการ %1",
    'dns_add__select_prefer_for_mail_exchange_server' => "ระบุความสำคัญของเซิร์ฟเวอร์แลกเปลี่ยนเมล",
    'dns_add__unable_insert_new_dns_rec' => "ไม่สามารถแทรกรายการ DNS ใหม่: %1",
    'dns_add__very_high' => "สูงมาก",
    'dom_ctrl__allowed' => "ได้รับอนุญาตแล้ว",
    'dom_ctrl__db' => "ฐานข้อมูล MSSQL",
    'dom_ctrl__mssql_db' => "ฐานข้อมูล MS SQL",
    'dom_ctrl__disk_space' => "พื้นที่ดิสก์",
    'dom_ctrl__dom_adm' => "โดเมน %1 ของ %2",
    'dom_ctrl__dom_cl' => "โดเมน %1",
    'dom_ctrl__domain_has_forwarding_with_undefined_fwd_url' => "โดเมนได้ส่งต่อการตั้งค่ากับ URL ที่ส่งต่อโดยไม่ได้กำหนด",
    'dom_ctrl__domain_has_frame_forwarding' => "โดเมนมีการส่งต่อเฟรมไปยัง URL %1",
    'dom_ctrl__domain_has_no_hosting' => "โดเมนไม่มีโฮสติ้งที่ได้รับการปรับตั้งค่า",
    'dom_ctrl__domain_has_physical_hosting' => "เว็บโฮสติ้งถูกตั้งค่าสำหรับโดเมนนี้ใน IP แอดเดรส %1",
    'dom_ctrl__domain_has_standard_forwarding' => "โดเมนมีมาตรฐานการส่งต่อไปยัง URL %1",
    'dom_ctrl__maillists' => "รายชื่อผู้รับจดหมาย",
    'dom_ctrl__mboxes' => "กล่องจดหมาย",
    'dom_ctrl__mg' => "การส่งต่อเมล",
    'dom_ctrl__resource_name' => "ทรัพยกร",
    'dom_ctrl__resp' => "การตอบกลับอัตโนมัติ",
    'dom_ctrl__subdom' => "โดเมนย่อย",
    'dom_ctrl__dom_aliases' => "โดเมนนามแฝง",
    'dom_ctrl__traffic' => "การรับส่งข้อมูล",
    'dom_ctrl__unable_activate/deactivate_dom' => "ไม่สามารถใช้งาน/ยุติการใช้งานโดเมน: %1",
    'dom_ctrl__used' => "ใช้แล้ว",
    // end of serge part

    // maverick part
    'dom_ctrl__wu' => "ผู้ใช้เว็บ",
    'dom_pref__bounce_with_phrase' => "ตีกลับด้วยข้อความ",
    'dom_pref__bounce' => "เด้งกลับ",
    'dom_pref__catch_addr' => "ส่งต่อไปยังที่อยู่",
    'dom_pref__reject' => 'ปฏิเสธ',
    'dom_pref__confirm_domain_removing' => "โปรดอย่าลืมแจ้งการเปลี่ยนชื่อโดเมนให้ผู้เข้าเยี่ยมชมโดเมนรับทราบ คุณแน่ใจหรือไม่ว่าคุณต้องการตั้งชื่อโดเมนใหม่?",
    'dom_pref__db_inconsystency' => "ฐานข้อมูลไม่สอดคล้องกัน",
    'dom_pref__dbs' => "ฐานข้อมูล",
    'dom_pref__delete_traffic_stat' => "จัดเก็บเว็บและสถิติทราฟฟิค",
    'dom_pref__delete_traffic_stat_older' => "จัดเก็บเว็บและสถิติทราฟฟิค",
    'dom_pref__dom_level_name_conflict' => "ชื่อผู้ใช้ของผู้ดูแลโดเมนขัดกับชื่อผู้ใช้ของหนึ่งในลูกค้า",
    'dom_pref__invalid_disk_space_limit' => "ขีดจำกัดของพื้นที่ดิสก์ไม่ถูกต้อง ค่าสูงสุด %1",
    'dom_pref__invalid_expiration_date_limit' => "ระยะเวลาที่ใช้งานได้ไม่ถูกต้อง",
    'dom_pref__invalid_max_traffic_limit' => "ขีดจำกัดทราฟฟิคไม่ถูกต้อง ค่าสูงสุด %1",
    'dom_pref__limits_of_dom' => "จำกัดสำหรับโดเมน %1",
    'dom_pref__mail_grps' => "กลุ่มเมล",
    'dom_pref__mail_nonexistent_user' => "ทำอย่างไรหากเมลได้ส่งไปยังผู้ใช้ที่ไม่มีอยู่จริง",
    'dom_pref__mail_redirs' => "ผู้ส่งต่อเมล",
    'dom_pref__mail_resps' => "จัดการการตอบกลับอัตโนมัติ",
    'dom_pref__max_limit_is_invalid' => "%1 ไม่ถูกต้อง",
    'dom_pref__max_num_of_%objects_is_invalid' => "จำนวนสูงสุดของ %1 ไม่ถูกต้อง",
    'dom_pref__new_limit_less_currently_used' => "%1: ร้องขอ - %2 ใช้ไปแล้วในปัจจุบัน -%3",
    'dom_pref__older_that' => "สำหรับ",
    'dom_pref__postboxes' => "กล่องจดหมาย",
    'dom_pref__preferences_of_dom' => "การตั้งค่าโดเมน %1",
    'dom_pref__redirect_to_itself' => "โดเมนจะตั้งค่าการส่งต่อไปยังโดเมน",
    'dom_pref__traffic_logging_period_couldnt_be_lower' => "เวลาการเก็บรักษาสถิติทราฟฟิคโดเมนที่คุณระบุมีค่าน้อยกว่าค่าทั้งหมดที่กำหนดไว้สำหรับเซิร์ฟเวอร์ (%1 เดือน) ระยะเวลาการเก็บรักษาสถิติได้รับการตั้งไว้ให้เท่ากับค่าเริ่มต้นของเซิรืฟเวอร์ (%1 เดือน)",
    'dom_pref__unable_add_www_prefix_in_dom' => "ไม่สามารถเพิ่ม www ไว้ด้านหน้าโดเมน: %1",
    'dom_pref__unable_define_physical_hst_param' => "ไม่สามารถกำหนดพารามิเตอร์ของโฮสติ้ทางงกายภาพ: %1",
    'dom_pref__unable_rename_domain' => "ไม่สามารถตั้งชื่อโดเมน %1 ใหม่ได้: %2",
    'dom_pref__unable_set_up_mbox_quota' => "ไม่สามารถตั้งโควต้ากล่องจดหมายสำหรับโดเมนนี้: %1",
    'dom_pref__unable_set_up_web_user_script' => "ไม่สามารถตั้งค่าบทคำสั่งสำหรับผู้ใช้เว็บ: %1",
    'dom_pref__unlimited' => "ไม่จำกัด",
    'dom_pref__web_usrs' => "ผู้ใช้เว็บ",
    'dom_pref__you_already_have_%object' => "คุณมี %1 แล้ว",
    'cu_domain__error_unable_update_ftp_users' => 'อัปเดตผู้ใช้งาน FTP ของโดเมนไม่สำเร็จ: %1',
    'dom_cli__warning_ignore_quota' => 'คำเตือน: มีการเพิกเฉยต่อตัวเลือก "-hard_quota": ไม่รองรับโควต้าของฮาร์ดดิสก์',
    'dom_user_client_login_exist' => "ไม่สามารถให้ผู้ดูแลโดเมนเข้าถึง Plesk ในโดเมน %1 ได้ ชื่อผู้ใช้นี้กำลังใช้งานอยู่",
    'domain__unable_to_turn_on_service' => "การเปิดบริการ %1 ล้มเหลว",
    'domains__change_the_status_of_domain?' => "คุณแน่ใจหรือไม่ว่าต้องการเปลี่ยนแปลงสถานะของโดเมน: %1?",
    'domains__client_info_hiding_traffic' => "%1 โดเมน %2 โดเมนที่ใช้งาน %3 พื้นที่ดิสก์ที่ใช้",
    'domains__unable_to_change_client_status' => "ไม่สามารถเปลี่ยนสถานะของบัญชีลูกค้า: %1",
    'domains__unable_update_apache_settings' => "ไม่สามารถอัพเดทการตั้งค่า Apache",
    'domains__you_do_not_have_permissions_to_delete_domains' => "คุณไม่ได้รับอนุญาตให้จัลบโดเมน",
    'domains__you_want_change_the_status_of_the_cl??' => "คุณแน่ใจหรือไม่ว่าต้องการเปลี่ยนแปลงสถานะของบัญชีลูกค้า",
    'domains__you_want_change_the_cp_access_of_the_cl??' => "คุณแน่ใจหรือไม่ว่าต้องการดำเนินการนี้?",
    'domains_list__unable_remove_doms' => "ไม่สามารถลบโดเมน: %1",
    'domaintrafficlist_header_of_domain__' => "ทราฟฟิคที่โดเมน %1",

    'domain_aliases_remove__select_domain_aliases_for_remove' => 'เลือกโดเมนนามแฝงที่จะลบ',
    'domain_aliases_remove__title' => 'ลบโดเมนนามแฝง',
    'domain_aliases__max_aliases_reached_for_dom' => "จำนวนนามแฝงที่กำหนดไว้สำหรับโดเมนนี้ถึงขีดจำกัดสูงสุด",
    'domain_edit__edit_title' => 'แก้ไขชื่อโดเมนนามแฝง',
    'domain_alias_edit__type' => 'ประเภทโดเมนนามแฝง',
    'domain_aliases__list_header' => 'โดเมนนามแฝง',
    'domain_aliases__name' => 'ชื่อ',
    'domain_aliases__type' => 'ประเภท',
    'domain_aliases__type_full' => 'เว็บไซด์+FTP+เมล',
    'domain_aliases__type_web_ftp' => 'เว็บไซด์+FTP',
    'domain_aliases__page_title' => 'โดเมนนามแฝง',
    'domain_aliases__legend' => 'โดเมนนามแฝง',
    'domain_alias__domain_exists' => 'โดเมนที่มีชื่อนั้นมีอยู่แล้ว',
    'domain_alias__subdomain_exists' => 'ซับโดเมนที่มีชื่อนั้นมีอยู่แล้ว',
    'domain_alias__dns_record_exists' => 'บันทึก DNS ที่มีชื่อโดเมนนามแฝงที่ระบุ มีอยู่แล้ว',
    'domain_alias__domain_alias_exists' => "นามแฝงของโดเมนที่มีชื่อนั้นมีอยู่แล้ว",
    'domain_alias__invalid_type_full' => 'โดเมนนามแฝงไม่ถูกรองรับโดยเซิร์ฟเวอร์เมล',
    'domain_alias__redirect_exists' => 'ตรวจพบการโอนกลับไปหาตัวเอง',

    'ds__anonymous_ftp' => "FTP นิรนาม",
    'drweb__pagetitle' => 'การตั้งค่าโปรแกรมป้องกันไวรัส',
    'drweb__drweb' => 'การตรวจสอบเมลด้วยแอนติไวรัส',
    'drweb__drweb_direction' => 'ทำการตรวจสอบเมลเพื่อหาไวรัส',
    'drweb__drweb_direction_off' => 'อย่าตรวจสอบไวรัส',
    'drweb__drweb_direction_any' => 'เมลขาเข้าและขาออก',
    'drweb__drweb_direction_from' => 'เมลขาออกเท่านั้น',
    'drweb__drweb_direction_to' => 'เมลขาเข้าเท่านั้น',
    'drweb__disable_reason_key' => 'รหัสลิขสิทธิ์ไม่สนับสนุนการทำงานของแอนติไวรัส',
    'drweb__disable_reason_perm' => 'คุณไม่ได้รับอนุญาตให้จัดการกับแอนติไวรัส',
    'drweb__disable_reason_install' => 'ไม่ได้ติดตั้งแอนติไวรัส',
    'drweb__filters' => 'ตัวกรองแอนติไวรัส',
    'ds__dns' => "DNS โซน",
    'ds__mail' => "เมล",
    'dumps_list__deletion_page_title' => "ไฟล์สำรองดังต่อไปนี้ของโดเมน %1 จะได้รับการลบ:",
    'dumps_list__dumpfile_is_invalid' => "ไฟล์ %1 ไม่ใช่ไฟล์สำรองข้อมูลของโดเมนที่ถูกต้อง",
    'dumps_list__page_title' => "พื้นที่จัดเก็บไฟล์สำรองข้อมูล",
    'dumps_upload__page_title' => "การอัพโหลดไฟล์สำรองข้อมูลไปยังพื้นที่จัดเก็บ",
    'dumps_list__repository_is_not_exist' => "ไม่มีพื้นที่จัดเก็บไฟล์สำรองข้อมูลอยู่",
    'dumps_list__unable_to_remove' => "ไม่สามารถลบไฟล์สำรอง: %1",
    'dumps_list__dumpfile_can_conflict' => "ชื่อไฟล์ที่คุณระบุขัดแย้งกับไฟล์ %1 โปรดระบุขื่อไฟล์อื่น",
    'dusr_ed__allow_dl_usr_access' => "อนุญาตให้เข้าถึงโดเมนของผู้ดูแลระบบ",
    'dusr_ed__information' => "คุณสมบัติโดเมน %1 ของผู้ดูแลระบบ",
    'dusr_ed__locale' => "ภาษาของโดเมนผู้ดูแลระบบ",
    'dusr_ed__skin' => "สกินสำหรับหน้าจอของโดเมนผู้ดูแลระบบ",
    'dusr_ed__personal_information' => 'ข้อมูลส่วนบุคคล',
    'ess__error' => "ผิดพลาด",
    'example__' => "ตัวอย่าง: %1",
    'extras__allow_certificate_purchasing' => "อนุญาตให้ทำการซื้อการรับรอง",
    'extras__allow_domain_registration' => "อนุญาตให้ทำการลงทะเบียนโดเมน",
    'extras__allow_extras' => "อนุญาตให้ใช้งานบริการพิเศษ",
    'extras__buy_new_key' => "ลิขสิทธิ์ปัจจุบันของคุณไม่อนุญาตให้ดัดแปลงสิ่งนี้",
    'extras__setup_services' => "ตั้งค่าบริการเสริม",

    'ruleeditform__error' => 'ไม่สามารถอัปเดตกฎไฟร์วอลล์ได้',
    'ruleeditform__name_is_required' => 'ระบุชื่อกฎ',
    'ruleeditform__profiles_is_required' => 'เลือกอย่างน้อยหนึ่งโพรไฟล์',
    'ruleeditform__invalid_ip' => 'IP แอดเดรสหรือเครือข่ายที่ระบุไม่ถูกต้อง',
    'ruleeditform__invalid_port' => 'พอร์ทที่ระบุไม่ถูกต้อง ค่าที่เป็นไปได้คือ 1000 หรือ 1000-1051',

    'filemanager__items' => 'รายการในสารบบ %1',
    'filemanager__items_paging' => 'รายการในสารบบ %1',

    'get_password__encrypted_password' => "ไม่สามารถส่งข้อมูลรหัสผ่านได้: รหัสผ่านถูกจัดเก็บในรูปแบบที่ต้องเข้ารหัส",
    'get_password__mail_error' => "เกิดความผิดพลาดเมื่อกำลังส่งรหัสผ่านไปยังอีเมล %1: %2",
    'get_password__mail_ok' => "รหัสผ่านถูกส่งไปที่อีเมลแล้ว %1",
    'get_password__message' => "ชื่อผู้ใช้ของคุณสำหรับการเข้าระบบ: %1\nรหัสผ่านของคุณคือ %2",
    'get_password__subject' => "รหัสผ่านสำหรับการเข้าสู่ระบบ",
    'groups__available' => "กลุ่มเมลที่มี",
    'groups__groups_for_mailname' => "กลุ่มเมลซึ่งได้มีการลงทะเบียนบัญชีเมล %1",
    'groups__member_of' => "สมาชิกของกลุ่มเมลดังต่อไปนี้",
    'help__help_area' => "พื้นที่สหรับความช่วยเหลือ",
    'hst_def__auth_disabled' => "ต้องห้าม",
    'hst_def__auth_enabled' => "ได้รับอนุญาต",
    'hst_def__change_curr_dns_ip' => "IP แอดเดรสของรายการ DNS จะถูกเปลี่ยน",
    'hst_def__cr_hosting_ip_dns_ip_not_equiv' => "ไม่มี IP แอดเดรสของรายการ DNS ที่ตรงกับ IP แอดเดรสที่กำหนดไปยังบัญชีโฮสติ้งที่ได้รับการสร้างขึ้น",
    'hst_def__dest_url' => "URL ปลายทาง",
    'hst_def__disk_quota' => "โควต้าดิสก์",
    'hst_def__disk_space_limit_exceed_incoming_quota' => "ขีดจำกัดของพื้นที่ดิสก์ที่คุณพยายามจะตั้งค่านั้นเกินกว่าขีดจำกัดของพื้นที่ดิสก์ในสารบบขาเข้าของ FTP นิรนาม ขีดจำกัดพื้นที่ดิสก์ในสารบบขาเข้าของ FTP นิรนามต้องไม่เกินขีดจำกัดพื้นที่ดิสก์ของโดเมน",
    'hst_def__frame_forwarding_definition' => "การกำหนดการส่งต่อเฟรมสำหรับโดเมน %1",
    'hst_def__ftpuser_for_hst_not_exist_in_system' => "คำเตือน: ผู้ใช้ FTP %1 ถูกใช้ในการตั้งค่าการโฮสติ้งบัญชีแ่ต่ไม่มีอยู่จริงในระบบ",
    'hst_def__hst_type_is_not_defined' => "ไม่ได้ระบุประเภทของโฮสติ้ง",
    'hst_def__ip_based' => "ตาม IP ที่ใช้",
    'hst_def__name_based_power_anonymous_ftp_down' => "การถ่ายโอนบัญชีโฮสติ้งนี้ไปยัง IP แอดเดรสที่แบ่งปันจะทำให้ไม่มีบริการ FTP นิรนามของโดเมนดำเนินการต่อ?",
    'hst_def__password_is_invalid_password_syntax' => "รหัสผ่านไม่ถูกต้อง ห้ามใช้\nและตัวอักษรประจำชาติในรหัสผ่าน ความยาวของรหัสผ่านควรมีตัวอักษรตั้งแต่ \n5 ถึง 14 ตัว รหัสผ่านไม่ควรประกอบด้วยชื่อผู้ใช้",
    'hst_def__shell' => "การเข้าถึง SSH ในเซิร์ฟเวอร์ภายใต้ผู้ใช้ระบบของการสมัครรับบริการ",
    'hst_def__shell_windows' => "การเข้าถึงเดสก์ท็อปทางไกลในเซิร์ฟเวอร์ภายใต้ผู้ใช้ระบบของการสมัครรับบริการ",
    'hst_def__standard_forwarding_definition' => "การกำหนดการส่งต่อแบบมาตรฐานสำหรับโดเมน %1",
    'hst_def__title_name_based' => "ตามชื่อที่ใข้",
    'hst_def__unable_create/update_physic_hst' => "ไม่สามารถสร้าง/อัพเดทโฮสติ้งทาวกายภาพ: %1",
    'hst_def__unable_create/update_std_fwd' => "ไม่สามารถสร้าง/อัพเดทการส่งต่อแบบมาตรฐาน: %1",
    'hst_def__unable_create_forwarding_myself' => "ไม่สามารถสร้างการส่งต่อไปยังโดเมนเอง",
    'hst_def__unable_turn_same_ssl_while_ssl_off' => "ไม่สามารถอนุญาตให้ใช้ไดเร็กทอรี่เดี่ยวสำหรับการจัดเก็บเนื้อหาที่เป็น SSL/TLS และเนื้อหาที่ไม่ใช่ SSL/TLS ได้ ไม่ได้เปิดการสนับสนุน SSL/TLS",
    'hst_def__unable_turn_on_ssl_cert_not_defined' => "ไม่สามารถเปิดการสนับสนุน SSL/TLS: ไม่ได้ติดตั้งการรับรอง SSL/TLS",
    'hst_def__url_is_invalid' => "URL ไม่ถูกต้อง",
    'hst_def__virtual_host_access' => "การเข้าถึงโฮสต์เสมือนสำหรับโดเมน %1",
    'hst_def__virtual_host_uses_non_existed_ip_address' => "การเตือน โฮสต์เหมือนนี้กำลังใช้ IP แอดเดรสที่ไม่มีอยู่จริงสำหรับการโฮสติ้ง",
    'hst_def__you_have_no_ips' => "คุณไม่มี IP แอดเดรสว่าง และคุณไม่ได้รับอนุญาตให้สร้างโฮสติ้งโดยใช้ชื่อ",
    'hst_sel__header' => "ในการโฮสต์เว็บไซต์ในเซิร์ฟเวอร์นี้ เลือกตัวเลือกการโฮสแบบ Physical\n เลือกการส่งต่อแบบ Frame หรือการส่งต่อแบบ Standard เพื่อตั้งค่าการส่งต่อโดเมนไปยังไซต์ในเครื่องอื่น\n การส่งต่อแบบ Standard ผู้ใช้จะโอนไปยังไซต์และ URL ของไซต์ที่แท้จริงจะแสดงในเบราวเซอร์ของผู้ใช้ เพื่อให้ผู้ใช้ทราบเกี่ยวกับการโอน การส่งต่อแบบ Frame ผู้ใช้จะโอนไปยังไซต์โดยไม่ทราบว่าไซต์นั้นอยู่ในที่อีกแห่งหนึ่ง",
    'hst_sel__physical_hst' => "โฮสติ้งทางกายภาพ",
    'hst_sel__select_hst_type' => "เลือกประเภทโฮสติ้งสำหรับโดเมน",
    'hst_sel__select_hst_type_warning' => "เลือกประเภทโฮสติ้งสำหรับโดเมน",
    'hst_sel__hosting_exists' => "ไม่สามารถสร้างโฮสติ้ง เนื่องจากได้รับการปรับตั้งค่าสำหรับโดเมนนี้แล้ว คุณจะได้รับการนำไปสู่หน้าการจัดการโฮสติ้งโดยตรง",
    'hst_sel__standard_frw' => "การส่งต่อแบบมาตรฐาน",
    'hst_sel__frame_frw' => "การส่งต่อเฟรม",
    '__frame_frw' => "การส่งต่อเฟรม",
    '__hosting_exists' => "ไม่สามารถสร้างโฮสติ้ง เนื่องจากได้รับการปรับตั้งค่าสำหรับโดเมนนี้แล้ว คุณจะได้รับการนำไปสู่หน้าการจัดการโฮสติ้งโดยตรง",
    '__choose_hst_type' => "เลือกประเภทโฮสติ้งที่จำเป็น",
    '__no_hst_conf' => "ไม่มีโฮสติ้งที่ได้รับการปรับตั้งค่าสำหรับโดเมนของคุณ",
    '__physical_hst' => "โฮสติ้งทางกายภาพ",
    '__select_hst_type' => "เลือกประเภทโฮสติ้งสำหรับโดเมน",
    '__standard_frw' => "การส่งต่อแบบมาตรฐาน",
    '__warning' => "คำเตือน! พารามิเตอร์ที่ตั้งไว้ก่อนหน้าจะถูกละทิ้ง คุณแน่ใจว่ต้องการเปลี่ยนประเภทโฮสติ้งหรือไม่?",
    'i_cl_off' => "ลูกค้ายังไม่เปิดใช้งาน",
    'i_cl_off_by_admin' => "บัญชีลูกค้าถูกระงับโดยผู้ดูแลเซิร์ฟเวอร์",
    'i_cl_off_expired' => "บัญชีลูกค้าหมดอายุ",
    'i_cl_on' => "ลูกค้าเปิดใช้งาน",

    'icf__title' => 'ไฟร์วอลล์ของการเชื่อมต่ออินเทอร์เน็ต',
    'icf__if_legend' => 'หน้าจอ',
    'icf__mode' => 'โหมด',

    'invalid_value' => 'ค่าไม่ถูกต้อง',

    'ip_addr__already_exists' => "มี IP แอดเดรส %1 อยู่แล้ว",
    'ip_addr__cant_add' => "IP %1 ไม่มีอยู่หรือเป็นของกลุ่ม IP ของลูกค้ารายอื่น",
    'ip_alias__interface' => "หน้าจอ",
    'ip_alias__invalid_ip_nm_bsd_vrt_hsts' => "%1 IP แอดเดรสสำหรับโฮสติ้งตามชื่อไม่ถูกต้อง",
    'ip_alias__invalid_ip_or_netmask' => "จับคู่ IP แอดเดรส/เน็ตมาสก์ไม่ถูกต้อง",
    'ip_alias__orig_ip_can_not_be_deleted' => "IP แอดเดรส %1 เป็น IP เซิร์ฟเวอร์ดั้งเดิม ดังนั้น คุณไม่สมารถลบออกได้",
    'ip_alias__ip_is_invalid' => "%1 IP address ไม่ถูกต้อง",
    'ip_alias__ip_mask_is_invalid' => "%1 IP mask ไม่ถูกต้อง",
    'ip_alias__ip_not_exist' => "ไม่มี IP แอดเดรส %1 อยู่",
    'ip_alias__ip_address_and_mask' => 'IP แอดเดรสและซับเน็ตมาสก์',
    'ip_alias__mask' => "ซับเน็ท",
    'ip_alias__remove_selected_ip_aliases?' => "คุณแน่ใจหรือไม่ว่าต้องการลบ IP แอดเดรสที่เลือก?",
    'ip_alias__select_ip' => "เลือก IP แอดเดรสอย่างน้อยหนึ่งอันเพื่อลบจากรายการ",
    'ip_alias__this_ip_used_for_domain' => "(%1) IP แอดเดรสนี้ใช้สำหรับโดเมน %2",
    'ip_alias__this_ip_used_for_nm_bsd_vrt_hsts' => "(%1) IP แอดเดรสนี้ใช้สำหรับโฮสต์เสมือนตามชื่อ",
    'ip_alias__unable_add_ip' => "ไม่สามารถเพิ่ม IP: %1",
    'ip_alias__unable_remove_ip' => "ไม่สามารถลบ IP: %1",
    'ip_ctrl__anonymous_ftp_exists_in_domain' => "คุณไม่สามารถเปลี่ยนแปลงประเภทของ IP แอดเดรสที่แบ่งปนได้ เนื่องจากจะทำให้ FTP สำหรับโดเมน '%1' ไม่สามารถใช้งานได้",
    'ip_ctrl__ip_addr' => "IP แอดเดรส %2 บนหน้าจอ %1",
    'ip_ctrl__ip_exists_many_pools' => "คุณไม่สามารถเปลี่ยนแปลงประเภทของ IP ได้ IP แอดเดรสนี้เป็นของกลุ่มของผู้ใช้หลายบัญชีในคราวเดียวกัน",
    'ip_ctrl__ssl_cert' => "การรับรอง SSL/TLS",
    'limit__date_in_past' => "ระยะเวลาที่ใช้งานได้ไม่ถูกต้อง %1 อยู่ในอดีตที่ผ่านมา",
    'limit__enter_date' => "ป้อนวันที่",
    'limit__max_db' => "ฐานข้อมูล",
    'limit__name_disk_space' => "พื้นที่ดิสก์",
    'limit__name_max_box' => "กล่องจดหมาย",
    'limit__name_max_db' => "ฐานข้อมูล MSSQL",
    'limit__name_max_dom' => "โดเมน",
    'limit__name_max_maillists' => "รายชื่อผู้รับจดหมาย",
    'limit__name_max_subdom' => "โดเมนย่อย",
    'limit__name_max_traffic' => "การรับส่งข้อมูล",
    'limit__name_max_wu' => "ผู้ใช้เว็บ",
    'limit__name_mbox_quota' => "โควต้ากล่องจดหมาย",
    'limit__name_max_mn' => "บัญชีเมล",
    'limit__name_max_cl' => 'ไคลเอนท์',
    'limit__name_total_mboxes_quota' => "โควต้าทั้งหมดของกล่องจดหมาย",
    'limit__name_mysql_dbase_space' => "พื้นที่ฐานข้อมูล MySQL",
    'limit__name_mssql_dbase_space' => "พื้นที่ฐานข้อมูล MSSQL",
    'limit__name_pgsql_dbase_space' => "พื้นที่ฐานข้อมูล PostgreSQL",
    'limit__name_expiration' => 'วันที่หมดอายุ',

    'locale_upload__unable_to_install' => 'ไม่สามารถติดตั้งไฟล์ชุดภาษาได้',
    'locale_upload__wrong_package' => 'ไฟล์ที่คุณอัพโหลดไม่มีชุดภาษาที่ถูกต้องสำหรับเวอร์ชั่น Plesk นี้',
    'locale_upload__wrong_locale' => 'ไฟล์ที่คุณอัพโหลดไม่มีชุดภาษาที่ถูกต้อง',

    'ma__create_title' => 'การสร้างเมลนามแฝงสำหรับ %1',
    'ma__edit_title' => "แก้ไขเมลนามแฝง %1",
    'ma__enter_new_alias' => "ป้อนนามแฝงใหม่",
    'ma__invalid_alias' => "เมลนามแฝงไม่ถูกต้อง",
    'ma__mail_aliases_mailname' => "เมลนามแฝงสำหรับบัญชีเมล %1",
    'ma__mailname_does_not_exist' => "ไม่มีบัญชีเมล",
    'ma__select_ma_for_remove' => "เลือกเมลนามแฝงเพื่อลบ",
    'ma__unable_to_add_new_ma' => "ไม่สามารถเพิ่มเมลนามแฝงได้: %1",

    'mail_queue__not_allowed_by_license_key' => 'รหัสลิขสิทธิ์ไม่อนุญาตให้มีการใช้การจัดการคิวเมล',
    'maillist__' => "รายชื่อสำหรับส่งจดหมาย %1",
    'maillist__already_exists' => "มีรายชื่อผู้สมัครรับจดหมายอยู่แล้ว",
    'maillist__mail_alias_already_exists_in_this_domain' => "มีเมลนามแฝง %1 นี้อยู่ในโดเมนแล้ว",
    'maillists__' => "รายชื่อสำหรับส่งจดหมาย %1",
    'maillists__limit_cl_max_maillists' => "เกินขีดจำกัดของจำนวนรายการส่งเมลสำหรับลูกค้า (ขีดจำกัด: %1 ใช้ไป %2)",
    'maillists__limit_dom_max_maillists' => "เกินขีดจำกัดของจำนวนรายการส่งเมลสำหรับโดเมน",
    'maillists__list' => "รายชื่อผู้รับจดหมาย",
    'maillists__mailman_not_installed_or_conf' => "\nไม่ได้ติดตั้งหรือปรับตั้งค่าการขยายของเซิร์ฟเวอร์ Mailman \nบนเซิร์ฟเวอร์นี้ ให้ติดต่อผู้ดูแลระบบเซิร์ฟเวอร์เพื่อขอรับการติดตั้งหรือการปรับตั้งค่าการขยายเซิร์ฟเวอร์ Mailman ที่เหมาะสม",
    'maillists__status' => "มีการเปิดใช้บริการรายชื่อสำหรับส่งจดหมาย",
    'maillists__unable_to_delete__' => "ไม่สามารถลบรายชื่อสำหรับส่งจดหมาย: %1",
    'maillists__disabled_text' => 'คุณไม่สามารถจัดการรายชื่อสำหรับส่งจดหมาย เนื่องจากยังไม่ได้ติดตั้งหรือปรับตั้งค่าคอมโพเนนท์ของเซิร์ฟเวอร์รายชื่อสำหรับส่งจดหมาย Mailman',
    'maillist_member__already_exists' => 'มีรายชื่อสำหรับส่งจดหมายอยู่แล้ว',
    'maillist_member__not_exists' => 'ไม่มีผู้ใช้นั้นในรายชื่อสำหรับส่งจดหมาย',
    'mailserver_switching_warning' => "คำเตือน!\n\nการเปลี่ยนแปลงเซิร์ฟเวอร์เมลก็เพื่อสำหรับการติดตั้งเริ่มต้นเท่านั้น ถ้าเซิร์ฟเวอร์ถูกใช้งานอยู่แล้ว เนื่องจากปัญหาดังต่อไปนี้นี้: สูญเสียการตั้งค่าและเนื้อหาของกล่องจดหมายและในกรณีที่คุณเปลี่ยนไปใช้งานเซิร์ฟเวอร์ที่ได้ปรับตั้งค่าแล้ว เกิดความขัดแย้งหลากหลาย ถ้าใช้งานเซิร์ฟเวอร์อยู่ในขณะนี้ \nและคุณแน่ใจว่าจะเปลี่ยนไปยังอีกเซิร์ฟเวอร์ คุณสามารถแจ้งเตือนลูกค้าของคุณเกี่ยวกับปฎิบัติการนี้เพื่อที่จะได้ดาวน์โหลดและบันทึกเมลของเขาไว้ก่อน",
    'manager__access_denied' => "ปฏิเสธการเข้าถึง: %1",
    'manager__admin' => "ผู้ดูแลระบบ",
    'manager__client' => 'ลูกค้า',
    'manager__domain' => "โดเมน",
    'manager__domain_cl_limit_exceeding' => "จำนวนโดเมนที่กำหนดไว้สำหรับถึงขีดจำกัดสำหรับบัญชีลูกค้านี้",
    'manager__domain_is_not_yours' => "โดเมน %1 ไม่ได้เป็นของคุณ",
    'manager__domain_key_limit_exceeding' => "การสร้างขีดจำกัดบนโดเมนได้รับการกำหนดโดยรหัสลิขสิทธิ์ถึงขีดจำกัดแล้ว",
    'manager__no_perm_to_call' => "คุณไม่ได้รับการอนุญาตให้โทร %1",
    'manager__no_perm_to_create_domains' => "คุณไม่ได้รับการอนุญาตให้สร้างโดเมน",
    'manager__no_perm_to_modify_domain' => "คุณไม่ได้รับการอนุญาตให้แก้ไขโดเมน %1",
    'manager__no_perm_to_modify_domains' => "คุณไม่ได้รับการอนุญาตให้แก้ไขโดเมน",
    'manager__no_perm_to_remove_domain' => "คุณไม่ได้รับการอนุญาตให้ลบโดเมน %1",
    'manager__no_perm_to_remove_domains' => "คุณไม่ได้รับการอนุญาตให้ลบโดเมน",
    'manager__node_doesnt_exist' => "ไม่มี %1 อยู่",
    'manager__user_disabled' => "บัญชีของคุณถูกระงับ คุณไม่สามารถลบโดเมน",
    'mail_quota_unsupported' => "ไม่รองรับเซิร์ฟเวอร์เมล",
    'mbox_quota_unsupported' => "ไม่รองรับเซิร์ฟเวอร์เมล",
    'mn__create_title' => "สร้างบัญชีเมล",
    'mn__edit_title' => "การตั้งค่า",
    'mn__files_list_title' => "ไฟล์เอกสารแนบ",
    'mn__files_remove' => "ลบไฟล์ออกจากที่จัดเก็บเอกสารแนบ ไฟล์เหล่านี้อาจใช้ได้การตอบกลับอัตโนมัติ ไฟล์จะถูกลบออกจากที่จัดเก็บและการตอบกลับอัตโนมัติที่กำลังใช้งานอยู่",
    'mn__files_select_for_remove' => "เลือกไฟล์เพื่อลบ",
    'mn__mail_alias_form' => "เมลนามแฝงจาก",
    'mn__mail_aliases_list' => "เมลนามแฝง",
    'mn__mailbox' => "การจัดการกล่องจดหมาย",
    'mn__unable_define_mn' => "ไม่สามารถตั้งค่าบัญชีเมล: %1",
    'mn__unable_remove_mbox_quota' => "ไม่สามารถลบโควต้ากล่องจดหมาย: %1",
    'mn__upload_file' => "อัพโหลดไฟล์",
    'mn_edit__attach_filename_changed' => 'ไฟล์ที่อัพโหลด %1 เปลี่ยนชื่อเป็น %2 เพราะชื่อมีตัวอักษรที่ไม่ใช่ ASCII',
    'mn_edit__add_mail_group_members_or_turn_off_box' => "คุณควรเพิ่มสมาชิกกลุ่มเมลก่อนเปิดการใช้งานกลุ่มเมล",
    'mn_edit__add_resp_or_turn_off_box' => "คุณควรเพิ่มการตอบกลับอัตโนมัติหรือยกเลิกการทำเครื่องหมายที่กล่องของการตอบกลับอัตโนมัติ",
    'mn_edit__attachments' => "เอกสารแนบ",
    'mn_edit__dom_quota_less_then_quota' => "ขนาดของกล่องจดหมายนี้ต้องไม่เกินขีดจำกัดของพื้นที่ดิสก์ที่จัดสรรไว้สำหรับกล่องจดหมายในโดเมนนี้",
    'mn_edit__enter_external_rcpnt_email' => "ใส่อีเมลของสมาชิกของกลุ่มเมลนอก",
    'mn_edit__enter_mail_redir_or_turn_off_box' => "พิมพ์ที่อยู่สำหรับการส่งต่อเมลหรือยกเลิกการทำเครื่องหมายที่กล่อง",
    'mn_edit__ext_rcpnt_email_invalid' => "ที่อยู่อีเมลของผู้ีัรับนอกไม่ถูกต้อง",
    'mn_edit__file_exists' => "มีไฟล์อยู่แล้ว เขียนทับหรือไม่?",
    'mn_edit__files_deld_from_repository' => "ไฟล์เหล่านี้จะถูกลบจากที่จัดเก็บและการตอบกลับอัตโนมัติ คุณต้องการดำเนินการต่อใช่ไหม",
    'mn_edit__mail_name' => "บัญชีเมล",
    'mn_edit__mail_name_invalid' => "ชื่อบัญชีเมลไม่ถูกต้อง",
    'mn_edit__mail_redir' => "ผู้ส่งต่อเมล",
    'mn_edit__mail_redir_add' => "เพิ่มสมาชิกกลุ่มเมล",
    'mn_edit__mail_resps' => "จัดการการตอบกลับอัตโนมัติ",
    'mn_edit__mailbox' => "กล่องจดหมาย",
    'mn_edit__enable_mailbox' => "กล่องจดหมาย",
    'mn_edit__mailgroup' => "กลุ่มเมล",
    'mn_edit__mailgroup_addresses' => "สมาชิกกลุ่มเมล",
    'mn_edit__mailgroup_disabled' => "มีเมื่อมีการเพิ่มบัญชีเมลแล้วเท่านั้น",
    'mn_edit__max_dom_quota' => "ค่าเริ่มต้นสำหรับโดเมน (%1)",
    'mn_edit__mbox_quota_invalid' => "ขนาดกล่องหมายที่ระบุไม่ถูกต้อง",
    'mn_edit__new_resp_name' => "ชื่อการตอบกลับอัตโนมัติใหม่",
    'mn_edit__no_autoresponders' => "คุณควรเพิ่มการตอบกลับอัตโนมัติอย่างน้อย 1 ครั้งก่อนเปิด/ปิดบริการนี้",
    'mn_edit__no_file_sel' => "ยังไม่ได้เลือกไฟล์",
    'mn_edit__no_mail_addresses' => "ไม่ได้ระบุหรือเลือกที่อยู่อีเมล",
    'mn_edit__none' => "ไม่มี",
    'mn_edit__not_create_pass' => "รหัสผ่านจะไม่ถูกสร้างสำหรับบัญชีนี้\nหากไม่มีรหัสผ่าน ผู้ใช้จะไม่สามารถดูหรือส่งเมลได้",
    'mn_edit__redir_email_invalid' => "ที่อยู่ที่กำลังส่งต่อไม่ถูกต้อง",
    'mn_edit__redirect_addr' => "ที่อยู่ที่กำลังส่งต่อ",
    'mn_edit__remove_autoresp?' => "คุณแน่ใจหรือไม่ว่าต้องการลบการตอบกลับอัตโนมัติ",
    'mn_edit__remove_rcpnts?' => "คุณแน่ใจหรือไม่ว่าต้องการลบผู้รับเหล่านี้?",
    'mn_edit__repository' => "ที่จัดเก็บข้อมูล",
    'mn_edit__resps_attach' => "ไฟล์ที่แนบมากับการตอบกลับอัตโนมัติ",
    'mn_edit__select_rcpnt_from_list' => "เลือกผู้รับอย่างน้อยหนึ่งรายจากรายการเพื่อลบ",
    'mn_edit__select_registered_users' => "เลือกผู้ใช้ที่ลงทะเบียนแล้ว",
    'mn_edit__selected_postbox_have_not_setup_passwd' => "คุณได้เลือกที่จะมีกล่องจดหมายแต่ยังไม่ได้ตั้งรหัสผ่าน",
    'mn_edit__unable_act_deact_mail_group' => "ไม่สามารถเปิดหรือปิดการใช้งานกลุ่มเมลได้: %1",
    'mn_edit__unable_act_deact_mail_redir' => "ไม่สามารถเปิดหรือปิดการใช้งานการส่งต่อเมลได้: %1",
    'mn_edit__unable_act_deact_postbox' => "ไม่สามารถเปิดหรือปิดการใช้งานกล่องจดหมายได้: %1",
    'mn_edit__unable_act_deact_resp' => "ไม่สามารถเปิดหรือปิดการใช้งานการตอบกลับอัตโนมัติได้: %1",
    'mn_edit__unable_add_attach' => "ไม่สามารถเพิ่มไฟล์แนบ: %1",
    'mn_edit__unable_add_mail_group_member' => "ไม่สามารถเพิ่มสมาชิกกลุ่มเมล: %1",
    'mn_edit__unable_add_resp' => "ไม่สามารถเพิ่มการตอบกลับอัตโนมัติ: %1",
    'mn_edit__unable_change_mail_name' => "ไม่สามารถเปลี่ยนชื่อบัญชีเมล: %1",
    'mn_edit__unable_deactivate_mail_group' => "ไม่สามารถยุติการใช้งานกลุ่มเมล: %1",
    'mn_edit__unable_deactivate_resp' => "ไม่สามารถปิดการใช้งานการตอบกลับอัตโนมัติของเิมลได้ %1",
    'mn_edit__unable_define_resp_id' => "ไม่สามารถระบุ ID ของการตอบกลับอัตโนมัติ: %1",
    'mn_edit__unable_remove_attach' => "ไม่สามารถลบไฟล์แนบ: %1",
    'mn_edit__unable_remove_autoresp' => "ไม่สามารถลบการตอบกลับอัตโนมัติ %1",
    'mn_edit__unable_remove_mail_group_member' => "ไม่สามารถลบสมาชิกกลุ่มเมล: %1",
    'mn_edit__wrong_way' => 'ข้อความที่ส่งถึง %1 จะยังไม่ได้ส่ง เนื่องจากบัญชีเมลไม่มีกล่องจดหมายหรือเปิดตัวส่งต่อเมล',
    'mn_edit__mailbox_is_disabled_mail_not_removed' => 'มีการปิดกล่องจดหมายที่ที่อยู่ %1 ข้อความในกล่องจดหมายจะไม่ได้รับการลบออก แต่คุณจำไม่สามารถเรียกคืนข้อมูลดังกล่าวผ่านทางโปรโตคอล IMAP หรือ POP3',
    'mn_list__mail_names_for_domain' => "บัญชีเมลในโดเมน %1",
    'mn_list__sa_cannot_unable' => "ไม่สามารถเปิดตัวกรองสแปม",
    'mn_list__tab_cp_access' => "L",
    'mn_list__tab_title_client' => 'ลูกค้า',
    'mn_list__tab_title_domain' => 'โดเมน',
    'mn_list__tab_title_autoresp' => "A",
    'mn_list__tab_title_box' => "B",
    'mn_list__tab_title_group' => "G",
    'mn_list__tab_title_name' => "ชื่อ",
    'mn_list__tab_title_redirect' => "F",
    'mn_list__tab_title_spamfilter' => "S",
    'mn_list__tab_title_virusfilter' => 'AV',
    'mn_list__tab_title_drweb' => 'AV',
    'mn_list__unable_remove_mns' => "ไม่สามารถลบบัญชีเมล: %1",
    'module_upload__module_was_installed' => 'ได้ติดตั้งโมดูลนี้แล้ว หากคุณต้องการติดตั้งเวอร์ชั่นของโมดูลตัวใหม่ โปรดถอนการติดตั้งโมดูลผ่าน Plesk และลองติดตั้งใหม่อีกครั้ง',
    'module_upload__unable_to_install' => 'ไม่สามารถตติดตั้งไฟล์แพคเกจโมดูล',
    'module_upload__wrong_package' => 'ไฟล์ที่อัพโหลดไม่รองรับแพคเกจโมดูล',
    'module_upload__wrong_module' => 'ไฟลืที่อัพโหลดไม่มีแพคเกจโมดูล',

    'news_articles_title' => 'ข่าวสาร Plesk',
    'notification_text__invalid_subject_length' => "ความยาวสำหรับชื่อเรื่องสำหรับประกาศไม่ถูกต้อง ควรมีความยาวตั้งแต่ 1 ถึง 255 ตัวอักษร",
    'notification_text__invalid_text_length' => "ความยาวข้อความแจ้งเตือนไม่ถูกต้อง ควรมีความยามตั้งแต่ 1 ถึง 65533 ตัวอักษร",
    'notification_text__subject' => "ชื่อเรื่องประกาศ",
    'notification_text__text' => "ข้อความแจ้งเตือน",
    'notification_text__title' => "แก้ไขการแจ้งเตือน",
    'notification_text__unable_set_text' => "ไม่สามารถแก้ไขข้อความแจ้งเตือน",

    'odbc__cant_add_dsn' => "ไม่สามารถเพิ่ม DSN %1: %2",
    'odbc__cant_connect' => "ไม่สามารถเชื่อมต่อการใช้ทรัพยากรข้อมูลโดยการใช้การตั้งค่าที่ระบุ เซิร์ฟเวอร์กลายเป็น: %1",
    'odbc__cant_delete_dsn' => "ไม่สามารถลบ DSN %1: %2",
    'odbc__cant_get_drivers_info' => "ไม่สามารถโหลดข้อมูลเกี่ยวกับไดรเวอร์",
    'odbc__cant_get_drivers' => "ไม่สามารถเรียกคืนรายการไดร์เวอร์: %1",
    'odbc__cant_open_info_file' => "ไม่สามารถเปิดไฟล์ด้วยข้อมูลไดรเวอร์ ODBC ได้",
    'odbc__cant_parse_string' => "ไม่สามารถแจงส่วนสายการเชื่อมต่อ",
    'odbc__driver_not_set' => "ไม่ได้ตั้งไดร์เวอร์",
    'odbc__driver_or_name_not_set' => "ยังไม่ได้ตั้งไดร์เวอร์หรือชื่อของการเชื่อมต่อ ODBC",
    'odbc__dsn_already_exists' => "มี DNS ที่มีชื่อ (%1) อยู่แล้วในระบบ",
    'odbc__dsn_not_exists' => "ไม่มี DSN นี้",
    'odbc__enter_dsn_name' => "ป้อนชื่อ DSN",
    'odbc__invalid_dsn_name' => "วากยสัมพันธ์สำหรับชื่อการเชื่อมต่อไม่ถูกต้อง (%1): โปรดใช้ตัวอักษรหรือตัวเลขเท่านั้น",
    'odbc__no_such_driver' => "ไม่สนับสนุนไดรฟ์เวอร์ ODBC ที่มีชื่อ (%1)",
    'odbc__unknown_driver' => "ไม่ทราบชื่อไดรเวอร์ (%1)",
    'odbc_dsn_system' => "ระบบ DSN",

    'pb__aliases' => "นามแฝง",
    'pb__anonftp' => "FTP นิรนาม",
    'pb__autoinstaller_releases' => 'ตัวอัพเดท',
    'pb__cert' => "การรับรอง",
    'pb__cl_pool' => "IP แอดเดรส",
    'pb__cl_pool_ctrl' => "%1",
    'pb__cl_pref' => "การตั้งค่า",
    'pb__cl_rpt' => "รายงาน",
    'pb__cl_rpt_list' => "กำหนดเอง",
    'pb__cl_templates' => "แม่แบบลูกค้า",
    'pb__cl_traffic' => "การรับส่งข้อมูล",
    'pb__cl_traffic_history' => "ประวัติทราฟฟิค",
    'pb__cl_traffic_of' => "ทราฟฟิคของ %1",
    'pb__client' => "%1",
    'pb__clients' => "ลูกค้า",
    'pb__comp_info' => "คอมโพเนนท์ของเซิร์ฟเวอร์",
    'pb__common_acl' => 'อนุญาตให้ถ่ายโอน ACL',
    'pb__cp_access' => "การเข้าถึง",
    'pb__crontab' => "ตัวจัดลำดับ",
    'pb__scheduler' => "ตัวจัดลำดับ",
    'pb__custom_buttons' => "ปุ่มที่กำหนดเอง",
    'pb__databases_db' => 'ฐานข้อมูล',
    'pb__sqlservers_db' => 'SQL Servers',//to check
    'pb__db' => "ฐานข้อมูล",
    'pb__db_edit' => "%1",
    'pb__db_server_edit' => '%1',
    'pb__db_servers' => 'เซิร์ฟเวอร์ฐานข้อมูล',
    'pb__dl_usr_ed' => "ผู้ดูแลระบบโดเมน",
    'pb__dns' => "DNS",
    'pb__dns_template' => "DNS",
    'pb__dns_t' => "DNS",
    'pb__dom_ctrl' => "%1",
    'pb__dom_lim' => "ขีดจำกัดโดเมน",
    'pb__dom_pref' => "การตั้งค่า",
    'pb__dom_sum_report' => "รายงานสรุปการใช้โดเมน",
    'pb__dom_templates' => "แม่แบบโดเมน",
    'pb__dom_traffic' => "ทราฟฟิคของ %1",
    'pb__domains' => "โดเมน",
    'pb__domain_aliases' => 'นามแฝงโดเมน',
    'pb__dumps_list' => "พื้นที่จัดเก็บไฟล์สำรองข้อมูล",
    'pb__forwarding_setup' => "ตั้งค่าการส่งต่อ",
    'pb__filemanager' => "ตัวจัดการไฟล์",
    'pb__ip_aliasing' => "IP แอดเดรส",
    'pb__ip_clients' => "การลบ IP แอดเดรส",
    'pb__license_management' => 'ข้อมูลใบอนุญาต',
    'pb__locales' => 'Locale',
    'pb__log_files' => "ไฟล์เข้าระบบ",
    'pb__mail' => 'เมล',
    'pb__mail_name_files' => "ไฟล์แนบ",
    'pb__mail_name_redirects' => "ผู้ส่งต่อเมล",
    'pb__mail_name_resp_attach_add' => "ไฟล์เอกสารแนบใหม่",
    'pb__mail_name_resp_edit' => "%1",
    'pb__mail_name_responders' => "จัดการการตอบกลับอัตโนมัติ",
    'pb__mail_names' => "เมล",
    'pb__maillists' => "รายชื่อผู้รับจดหมาย",
    'pb__mimetypes' => 'ประเภท MIME',
    'pb__modules' => 'โดมูล',
    'pb__modules_management' => 'จัดการโมดูล',
    'pb__notifications' => "การแจ้งเตือน",
    'pb__odbc' => "ODBC",
    'pb__phosting_setup' => "การตั้งค่าโฮสติ้งทาวกายภาพ",
    'pb__prtd_dirs' => "ไดเร็กทอรี่ที่ได้รับการป้องกัน",
    'pb__prtdir_edit' => "%1",
    'pb__report_list' => "กำหนดเอง",
    'pb__server' => "เซิร์ฟเวอร์",
    'pb__sessions' => "ช่วงเวลา",
    'pb__sapp_pool' => "แอพพลิเคชั่นเว็บกลุ่ม",
    'pb__siteapp_install' => 'การติดตั้งแอพพลิเคชั่นเว็บ',
    'pb__site_app_pkgs' => 'แอพพลิเคชั่นเว็บ',
    'pb__site_apps' => "แอพพลิเคชั่นเว็บ",
    'pb__additional_key_info' => 'คุณสมบัติรหัส',
    'pb__additional_key_properties' => 'คุณสมบัติรหัส',
    'pb__skeleton' => 'แม่แบบโฮสต์เสมือน',
    'pb__skins' => 'สกิน',
    'pb__skin_info' => '%1',
    'pb__spamassassin' => "ตัวกรองสแปม",
    'pb__statistics' => "สถิติ",
    'pb__subdom_ctrl' => "%1",
    'pb__subdomains' => "โดเมนย่อย",
    'pb__templates' => "แม่แบบ",
    'pb__virtualdirs' => 'สารบบเสมือน',
    'pb__web_users' => "ผู้ใช้เว็บ",
    'pdir__enter_dir_name' => "ป้อนชื่อสารบบ",
    'pdir__invalid_hst' => "ประเภทโฮสติ้งไม่ถูกต้อง ต้องเป็นแบบกายภาพ",
    'pdir__pd_id_is_undefined' => "ไม่สามารถกำหนดหมายเลขของสารบบที่ได้รับการป้องกัน",
    'pdir__pdir_exist' => "สารบบชื่อนี้ได้รับการป้องกันแล้ว",
    'pdir__pdir_not_exist' => "ไม่มีสารบบที่ได้รับการป้องกันอยู่",
    'pdir__pdir_usr_not_exist' => "ไม่มีผู้ใช้สารบบที่ได้รับการป้องกันอยู่",
    'pdir__remove_pdir_usrs' => "ผู้ใช้ดังต่อไปนี้ของสารบบที่ได้รับการป้องกัน %2 ภายใต้เว็บไซต์ %1 จะถูกลบ:",
    'pdir__remove_pdir_usrs_on_subdom' => "ผู้ใช้ดังต่อไปนี้ของสารบบที่ได้รับการป้องกัน %2 ภายใต้ซับโดเมน %1 จะถูกลบ:",
    'pdir__select_pdir_usrs_for_remove' => "เลือกผู้ใช้สารบบที่ได้รับการป้องกันเพื่อลบ",
    'pdir__select_pdirs_to_remove' => "เลือกสารบบเพื่อลบการป้องกันออก",
    'pdir__unable_define_pdir_users' => "ไม่สามารถกำหนดผู้ใช้สารบบที่ได้รับการป้องกัน",
    'pdir__unable_define_pdirs_properties' => "ไม่สามารถตั้งค่าคุณสมบัติของสารบบที่ได้รับการป้องกัน: %1",
    'pdir__unable_select_dom_param' => "ไม่สามารถเลือกพารามิเตอร์โดเมน: %1",
    'pdir_ed__create_pdir_for_domain' => "สร้างไดเร็กทอรี่ที่ได้รับการป้องกันภายใน %1",
    'pdir_ed__create_pdir_for_subdomain' => "สร้างไดเร็กทอรี่ที่ได้รับการป้องกันภายในโดเมนย่อย %1",
    'pdir_ed__dir_already_protect' => "สารบบได้รับการป้องกันแล้ว",
    'pdir_ed__head_txt' => "หัวเรื่องของพื้นที่ได้รับการป้องกัน",
    'pdir_ed__invalid_login' => "คุณระบุชื่อผู้ใช้ไม่ถูกต้อง",
    'pdir_ed__login_exists' => "มีผู้ใช้นี้อยู่แล้ว โปรดลองระบุชื่อผู้ใช้ใหม่อีกครั้ง",
    'pdir_ed__new_usr' => "ชื่อผู้ใช้",
    'pdir_ed__non_ssl' => "Non-SSL/TLS",
    'pdir_ed__cgi_bin' => "cgi-bin",
    'pdir_ed__path' => "ชื่อไดเร็กทอรี่",
    'pdir_ed__pdir_for_domain' => "สารบบที่ได้รับการป้องกัน %1 บนโดเมน %2",
    'pdir_ed__pdir_for_subdomain' => "สารบบที่ได้รับการป้องกัน %1 ภายใต้ซับโดเมน %2",
    'pdir_ed__pdir_location' => "สถานที่ตั้งของสารบบ",
    'pdir_ed__pdir_users' => "ผู้ใช้สารบบที่ได้รับการป้องกัน",
    'pdir_ed__ssl' => "SSL/TLS",
    'pdir_ed__ssl_or_nonssl_should_be_checked' => "ควรทำเครื่องหมายที่กล่อง SSL/TLS และ Non-SSL/TLS อย่างน้อย 1 กล่อง",
    'pdir_ed__unable_cr_pdir_usr' => "ไม่สามารถสร้างผู้ใช้สารบบที่ได้รับการป้องกัน: %1",
    'pdir_ed__unable_create_pdir' => "ไม่สามารถสร้างสารบบที่ได้รับการป้องกัน: %1",
    'pdir_ed__unable_define_hst_type' => "ไม่สามารถกำหนดประเภทของโฮสติ้งได้",
    'pdir_ed__unable_update_pdir' => "ไม่สามารถบันทึกการตั้งค่าของสารรบบที่ได้รับการป้องกันได้: %1",
    'pdir_ed__wrong_symbol_in_header' => "โปรดอย่าใช้ตัวอักษร %1 ในหัวสารบบ",
    'pdir_usr_ed__create_pdir_usr_for_pd' => "สร้างผู้ใช้สำหรับสารบบที่ได้รับการป้องกัน: %1",
    'pdir_usr_ed__not_create_pass' => "สิ่งนี้จะไม่สร้างรหัสผ่านสำหรับผู้ใช้สารบบที่ได้รับการป้องกัน \nหากไม่มีรหัสผ่านผู้ใช้จะไม่สามารถเข้าสู่ระบบได้",
    'pdir_usr_ed__pass_for_pdir_usr' => "รหัสผ่านสำหรับผู้ใช้ที่ได้รับการป้องกัน: %1",
    'pdir_usr_ed__unable_select_pdir_usr' => "ไม่สามารถเลือกผู้ใช้สารบบที่ได้รับการป้องกัน: %1",
    'pdir_usrs_list__unable_define_pdir_usrs' => "ไม่สามารถกำหนดผู้ใช้สารบบที่ได้รับการป้องกัน: %1",
    'pdir_usrs_list__unable_remove_pd_usrs' => "ไม่สามารถลบผู้ใช้สารบบที่ได้รับการป้องกัน: %1",
    'phosting__anonftp_encrypt' => 'รหัสผ่านของผู้ใช้ FTP ได้รับการเข้ารหัส ดังนั้น จึงไม่สามารถใช้สำหรับสารบบที่ได้รับการป้องกัน /plesk-stat/webstat/ โปรดป้อนรหัสผ่าน FTP ของคุณอีกครั้ง หรือยกเลิกการเลือกตัวเลือก "accessible via password protected directory \'/plesk-stat/webstat/\'"',
    'phosting__hosting_and_dns_ip_difference_warning' => "ชื่อโดเมน %%domain_name%% จะแยกไปยัง IP แอดเดรส %%dns_ip_address%% เว็บไซต์ของคุณได้ถูกมอบหมายไปยัง IP แอดเดรส %%hosting_ip_address%% หากเว็บไซต์ของคุณไม่เปิดอยู่ในเว็บเบราวเซอร์เมื่อคุณได้อ้างอิงถึงโดยใช้ชื่อโดเมน ให้ไปที่หน้าจอการจัดการ DNS (ที่โดเมน > โดเมนเนม > DNS) และเปลี่ยนคุณสมบัติของทรัพยากร A  มอบหมาย IP แอดเดรส %%hosting_ip_address%% ไปยังชื่อโดเมน %%domain_name%%",
    'phosting__ip_change_warning' => "หมายเลข IP แอดเดรสได้รับการเปลี่ยนแปลง การเปลี่ยนแปลงดังกล่าวจะส่งผลไปยัง DNS โซน ของโดเมนด้วย",
    'phosting__other_hosting_exists_on_ip' => "ไม่สามารถเปลี่ยนแปลงการรับรองได้ เนื่องจาก IP แอดเดรสนี้ถูกใช้ในบัญชีโฮสติ้งอื่นๆ",
    'phosting__unable_to_change_certificate' => "ไม่สามารถติดตั้งการรับรอง: %1",
    'phosting__unable_to_change_ip_address' => "ไม่สามารถเปลี่ยนแปลง IP แอดเดรส: %1",
    'phosting__unable_to_set_cert' => "ไม่สามารถตั้งค่าการรับรอง SSL/TLS: %1",
    'phosting__unable_update' => "ไม่สามารถอัพเดตการตั้งค่าโฮสติ้งได้ %1",
    'phosting__unable_manage' => "ไม่สามารถจัดการโฮสติ้ง: %1",
    'phosting__failed_to_add_logs_fail2ban' => "ไม่สามารถกำหนดค่า fail2ban เพื่อติดตามตรวจสอบบันทึกของโดเมนได้ บันทึกจะถูกติดตามตรวจสอบโดยอัตโนมัติเมื่อมีการรีสตาร์ทบริการ fail2ban ในครั้งต่อไป\n%1",

    'picker_acl_record__tittle' => 'เลือกรายการ ACL',
    'picker_autoresponder__title' => 'เลือกการตอบกลับอัตโนมัติ',
    'picker_black_list__domain_name' => 'เลือกชื่อโดเมน',
    'picker_certificate' => 'เลือกการรับรอง SSL/TLS',

    'picker_dns_zone_template__title' => 'เลือกรายการทรัพยากร',
    'picker_domain__title' => 'เลือกเว็บไซต์',
    'picker_domain_alias__title' => 'เลือกโดเมนนามแฝง',
    'picker_resource_record__title' => 'เลือกรายการทรัพยากร',
    'picker_disabled_resource_record__title' => 'เลือกชื่อเซิร์ฟเวอร์',
    'picker_ip_address__title' => 'เลือก IP แอดเดรส',
    'picker_ip_address_clients__title' => 'เลือกลูกค้าทีใช้ IP แอดเดรสนี้',
    'picker_mail_queue' => 'เลือกข้อความในอีเมล',
    'picker_site_application__title' => 'เลื่อกแอพพลิเคชั่นเว็บ',
    'picker_subdomain__title' => 'เลือกซับโดเมน',
    'picker_web_user__title' => 'เลือกผู้ใช้เว็บ',
    'picker_custom_button__title' => 'เลือกปุ่มที่ตั้งค่าเอง',
    'picker_license_key__title' => "การเลือกรหัสลิขสิทธิ์",
    'picker_spamfilter_address__title' => 'เลือกที่อยู่ตัวกรองสแปม',
    'picker_white_list__networks' => 'การเลือกเครือข่าย',

    'plesk_key__action_logs' => "บันทึกกิจกรรมที่ทำโดยผู้ใช้ Plesk",
    'plesk_key__app_vault' => "ตู้นิรภัยของแอพพลิเคชั่น",
    'plesk_key__backup' => "ฟังก์ชั่นการสำรองและการกู้คืนข้อมูล",
    'plesk_key__client_templs' => "การจัดการการวางแผนการบริการ",
    'plesk_key__clients' => "บัญชีผู้ใช้ (ตัวแทนจำหน่ายและลูกค้า)",
    'plesk_key__resellers_only' => "บัญชีผู้ใช้ (ตัวแทนจำหน่าย)",
    'plesk_key__customers_only' => "บัญชีผู้ใช้ (ลูกค้า)",
    'plesk_key__domains' => "โดเมน",
    'plesk_key__domain_aliases' => "โดเมนนามแฝง",
    'plesk_key__manage_dashboard' => 'การตั้งค่าหน้าหลักเอง',
    'plesk_key__drweb' => "การจัดการแอนติไวรัส",
    'plesk_key__event_manager' => "ตัวจัดการเหตุการณ์",
    'plesk_key__expirations' => "การจัดการวันหมดอายุของบัญชี",
    'plesk_key__group_ops' => "การดัดแปลงสิ่งต่างๆ ในครั้งเดียว",
    'plesk_key__expiration' => "วันหมดอายุของรหัส",
    'plesk_key__edition_name' => "Plesk Edition",
    'plesk_key__key_number' => "หมายเลขรหัส",
    'plesk_key__languages' => "ชุดภาษา",
    'plesk_key__mailnames' => "บัญชีเมล",
    'plesk_key__migration_manager' => "ตัวจัดการโอนถ่ายและการย้าย",
    'plesk_key__mssql' => "สนับสนุนเซิร์ฟเวอร์ Microsoft SQL",
    'plesk_key__myplesk_func' => "ลิงค์สำหรับการซื้อการรับรอง SSL/TLS และบริการจดทะเบียนโดเมน",
    'plesk_key__myplesk_server_id' => "ตัวกำหนดเซิร์ฟเวอร์ MPC สลาฟ",
    'plesk_key__notifications' => "การจัดการการแจ้งเตือน",
    'plesk_key__postgresql' => "สนับสนุนเซิร์ฟเวอร์ฐานข้อมูล PostgreSQL",
    'plesk_key__qmail_queue' => 'การจัดการคิวของเมล',
    'plesk_key__remote_db' => 'โฮสติ้งฐานข้อมูลระยะไกล',
    'plesk_key__slave_servers' => "เซิร์ฟเวอร์สลาฟ",
    'plesk_key__spamassassin' => "การจัดการตัวกรองสแปม",
    'plesk_key__subdomains' => "การจัดการโดเมนย่อย",
    'plesk_key__sys_access' => "การจัดการการเข้าถึงเซิร์ฟเวอร์",
    'plesk_key__traffic_reports' => "รายงานการใช้ทราฟฟิค",
    'plesk_key__tts' => "แผนกช่วยเหลือ",
    'plesk_key__virtuozzo' => "สามารถใช้ได้กับ Virtuozzo Containers เท่านั้น",
    'plesk_key__webusers' => "ผู้ใช้เว็บ",
    'plesk_key__license_update_date' => 'การอัพเดทรหัสลิขสิทธิ์ครั้งถัดไป',
    'plesk_key__autoinstaller_config' => 'การจัดการการตั้งค่าการอัพเดต',
    'plesk_key__check_wrong' => "รหัสลิขสิทธิ์ไม่ถูกต้อง โปรดติดตั้งรหัสลิขสิทธิ์ใหม่หากต้องการใช้ Plesk",
    'plesk_key__upload_check_wrong' => 'รหัสลิขสิทธิ์ที่อัพโหลดแล้วไม่ถูกต้อง',
    'plesk_key__revert_check_wrong' => 'รหัสลิขสิทธิ์ที่ติดตั้งไว้ก่อนหน้านี้ไม่ถูกต้อง',
    'plesk_key__update_check_wrong' => 'รหัสลิขสิทธิ์ที่อัพเดทแล้วไม่ถูกต้อง',
    'plesk_key__viruozzo_only_key' => 'รหัสลิขสิทธิ์นี้มีเพื่อสำหรับการใช้งานกับ Plesk ที่ติดตั้งใน Virtuozzo Containers เท่านั้น',
    'plesk_key__ip_ranges_exceeded' => 'คุณสามารถใช้สำเนา Plesk ที่จดลิขสิทธิ์นี้ได้ด้วย IP แอดเดรสดังต่อไปนี้: %2. ลิขสิทธิ์ของคุณไม่ครอบคลุม IP แอดเดรสดังต่อไปนี้: %1.', //%1 not allowed addresses list separated by comma, %2 allowed IP addresses list separated by comma
    'plesk_key__limits_exceeded' => 'จำนวนทรัพยากรที่ใช้ในปัจจุบันเกินกว่าขีดจำกัดที่ใบอนุญาตของคุณกำหนดไว้',
    'plesk_key__wp-toolkit-deluxe' => 'WP Toolkit Deluxe',
    // For the keys below: %1 limit value, %2 used value, %3 delta value
    'plesk_key__limits_exceeded_lim_dom' => 'จำนวนเว็บไซต์ที่โฮสต์อยู่ในเซิร์ฟเวอร์นี้เกินขีดจำกัดจำนวนที่กำหนดโดยลิขสิทธิ์ คุณมี %2 ไซต์ที่โฮสต์อยู่ ลิขสิทธิ์ของคุณอนุญาตให้โฮส %1 ไซต์',
    'plesk_key__limits_exceeded_lim_domain_aliases' => 'จำนวนโดเมนนามแฝงบนเซิร์ฟเวอร์นี้เกินกว่าขีดจำกัดที่กำหนดโดยลิขสิทธิ์ของคุณ คุณมี %2 โดเมนนามแฝง ลิขสิทธิ์ของคุณอนุญาตให้โฮสติ้งได้เพียง %1 โดเมนนามแฝงเท่านั้น',
    'plesk_key__limits_exceeded_lim_cl' => 'จำนวนบัญชีลูกค้าที่ได้บริการเกินขีดจำกัดจำนวนที่กำหนดโดยลิขสิทธิ์ ปัจจุบัน คุณมี %2 บัญชีลูกค้าที่ได้รับบริการ ลิขสิทธิ์ของคุณอนุญาตให้บริการเพียง %1 บัญชีลูกค้า',
    'plesk_key__limits_exceeded_lim_mn' => 'จำนวนบัญชีอีเมลที่ได้บริการเกินขีดจำกัดจำนวนที่กำหนดโดยลิขสิทธิ์ ปัจจุบัน คุณมี %2 บัญชีอีเมลที่ได้รับบริการ ลิขสิทธิ์ของคุณอนุญาตให้บริการเพียง %1 บัญชีอีเมล',
    'plesk_key__limits_exceeded_lim_wu' => 'จำนวนบัญชีผู้ใช้เกินกว่าขีดจำกัดที่กำหนดโดยลิขสิทธิ์ของคุณ คุณมี %2 บัญชีผู้ใช้เว็บที่ใช้งานอยู่ ลิขสิทธิ์ของคุณอนุญาตให้ใช้งานได้เพียง %1 บัญชีผู้ใช้เว็บเท่านั้น',
    'plesk_key__limits_exceeded_MLS' => 'จำนวนของชุดภาษาที่ติดตั้งแล้วเกินกว่าขีดจำกัดที่กำหนดโดยลิขสิทธิ์ คุณมี %2 ชุดภาษาที่ติดตั้งแล้ว ลิขสิทธิ์ของคุณอนุญาตให้คุณทำการติดตั้งได้เพียง %1 ชุดภาษาเท่านั้น',
    'plesk_key__wrong_version' => 'คุณกำลังพยายามใช้ลิขสิทธิ์ที่สร้างขึ้นมาเพื่อ Plesk เวอร์ชั่นอื่น ติดต่อตัวแทนจำหน่าย Plesk เพื่อขอรับรหัสลิขสิทธิ์ที่ถูกต้อง',
    'plesk_key__other_product' => 'คุณกำลังพยายามใช้ลิขสิทธิ์ที่สร้างขึ้นมาเพื่อผลิตภัณฑ์อื่น ติดต่อตัวแทนจำหน่าย Plesk เพื่อขอรับรหัสลิขสิทธิ์ที่ถูกต้อง',
    'plesk_key__invalid_machine_id_trial' => 'ใบอนุญาตใช้งานในปัจจุบันของคุณใช้งานไม่ได้ เนื่องจากได้เปิดใช้งานกับเซิร์ฟเวอร์ Plesk อื่นแล้ว หากต้องการใช้งาน Plesk ต่อไป ให้ติดตั้งใบอนุญาตใช้งานใหม่หรือติดตั้งใบอนุญาตใช้งานปัจจุบันอีกครั้งโดยการป้อนโค้ดเปิดใช้งาน (หากคุณมี)',
    'plesk_key__invalid_machine_id_retail' => 'ใบอนุญาตใช้สิทธิ์ของคุณใช้ไม่ได้ เนื่องจากได้เปิดใช้งานบนเซิร์ฟเวอร์ Plesk อื่นไปแล้ว ข้อตกลงด้านใบอนุญาตใช้สิทธิ์ของผู้ใช้ปลายทาง WebPros (https://www.plesk.com/legal/) ห้ามไม่ให้ใช้ใบอนุญาตใช้สิทธิใบเดียวสองเซิร์ฟเวอร์ขึ้นไปในเวลาเดียวกัน หากต้องการใช้ Plesk ให้ติดตั้งใบอนุญาตใช้สิทธิใหม่หรือติดตั้งใบอนุญาตใช้สิทธิปัจจุบันอีกครั้งโดยการป้อนรหัสเปิดใช้งาน ซึ่งจะส่งให้คุณทางอีเมลตอนที่คุณซื้อใบอนุญาตใช้สิทธิ<br>หารหัสเปิดใช้งานไม่เจอใช่หรือไม่? คุณสามารถรับอีกครั้งโดยใช้ Plesk 360 โดยการเข้าสู่ระบบบน https://platform360.io/ ด้วยอีเมลที่คุณใช้ซื้อใบอนุญาตใช้สิทธิ จากนั้นให้ไปที่ "Licenses" แล้วดูรหัสเปิดใช้งานใบอนุญาตใช้สิทธิของคุณ หรือคุณสามารถติดต่อฝ่ายสนับสนุนด้านการออกใบอนุญาตใช้สิทธิและสั่งซื้อโดยใช้แบบฟอร์มออนไลน์ (https://www.plesk.com/licensing-and-purchase-support/) โปรดอย่าลืมบอกหมายเลขใบอนุญาตใช้สิทธิในส่วน "How can we help you?" ของแบบฟอร์ม',
    'plesk_key__limits_exceeded_error' => 'ไม่สามารถติดตั้งรหัสลิขสิทธิ์ได้: จำนวนทรัพยากรที่ใช้ในปัจจุบันเกินขีดจำกัดที่กำหนดไว้ในรหัสลิขสิทธิ์ที่อัพโหลดแล้ว',
    'plesk_key__limits_exceeded_note' => 'จำนวนทรัพยากรที่ใช้ในปัจจุบันเกินขีดจำกัดที่กำหนดไว้ในรหัสลิขสิทธิ์ที่อัพโหลดแล้ว',
    'plesk_key__key_file_invalid' => 'ไฟล์รหัสที่อัพโหลดไม่ถูกต้อง หรือไม่มีรหัสลิขสิทธิ์',
    'plesk_key__server_request_error' => 'ไม่สามารถอัปเดตลิขสิทธิ์ได้ โปรดแน่ใจว่าการเชื่อมต่อกับเซิร์ฟเวอร์ดูแลลิขสิทธิ์ ka.plesk.com บน TCP พอร์ต %1 ไม่ได้ถูกบล็อก <a href="https://support.plesk.com/hc/en-us/articles/12388137260695" target="_blank">ดูวิธีการ </a>',
    'key__no_key_file_in_zip' => 'ไฟล์ .zip ที่อัพโหลดไม่มีไฟล์รหัส',
    'key__key_upload' => 'การติดตั้งรหัสลิขสิทธิ์',
    'additional_key__prop_name' => 'คุณสมบัติ',
    'additional_key__prop_value' => 'ค่า',
    'additional_key__descr_name' => 'ชื่อรหัส',
    'additional_key__descr_key_number' => 'หมายเลขรหัส',
    'additional_key__descr_key_vz' => "รหัสลิขสิทธิ์ของคุณใช้สำหรับ Virtuozzo Containers เท่านั้น",
    'additional_key__descr_key_mailboxes' => 'กล่องเมล์',
    'additional_key__descr_lim_date' => 'วันที่หมดอายุ',
    'additional_key__descr_license_update_date' => 'การอัพเดทรหัสลิขสิทธิ์ครั้งถัดไป',
    'additional_key__file_invalid' => 'ไฟล์รหัสที่อัพโหลดไม่ถูกต้อง หรือไม่มีรหัสลิขสิทธิ์',
    'additional_key__file_incompatible' => 'ไฟลรหัสที่อัพโหลดไม่ถูกต้องสำหรับแอพพลเคชั่นนี้',
    'additional_key__expired' => 'รหัสเพิ่มเติมหมดอายุ',
    'additional_key__not_exists' => 'ไม่ได้ติดตั้งรหัสลิขสิทธิ์',
    'additional_key__viruozzo_only_key' => 'รหัสลิขสิทธิ์นี้มีเพื่อสำหรับการใช้งานกับ Plesk ที่ติดตั้งใน Virtuozzo Containers เท่านั้น',
    'additional_key_update__result_response' => 'การตอบสนองของเซิร์ฟเวอร์ลิขสิทธิ์: %1',
    'additional_key_update__result_network' => 'ไม่สามารถเชื่อมต่อกับเซิร์ฟเวอร์ลิขสิทธิ์ได้ โปรดตรวจสอบให้แน่ใจว่า เครือข่ายของคุณยอมให้ทำการติดต่อไปยัง %1: %2',
    'additional_key_update__result_lock' => 'การอัพเดทรหัสกำลังอยู่ในระหว่างการดำเนินการแล้ว',
    'additional_key_update__result_internal_error' => 'เกิดข้อผิดพลาดขึ้นในขณะทำการอัพเดทรหัสลิขสิทธิ์: %1',

    'proceed_to_cl_pool' => "ดำเนินการปรับตั้งค่า IP กลุ่มของลูกค้า",
    'proceed_to_hosting_setup' => "คลิกเพื่อไปยังการตั้งค่าโฮสติ้ง",
    'removeCerts__remove_certificates_cp' => "การรับรองดังต่อไปนี้จะได้รับการลบ:",
    'removeCerts__remove_certificates_domain' => "การรับรองที่เป็นของ %1 ดังต่อไปนี้จะได้รับการลบ:",
    'removeClientsIP_remove_clients_ip' => "IP แอดเดรสนี้จะถูกลบออกจากกลุ่มของลูกค้าต่อไปนี้:",
    'removeMailAliases__remove_mail_aliases' => "โดเมนนามแฝงดังต่อไปนี้สำหรับบัญชี %1 จะถูกลบ:",
    'removeMailNames__remove_mailnames' => "บัญชีเมลและนามแฝงดังต่อไปนี้จะได้รับการลบออกจากโดเมน %1:",
    'removeMailNames__remove_mailnames_of_cl' => "บัญชีเมลและนามแฝงดังต่อไปนี้จะได้รับการลบออกจากโดเมน %2 ที่ลูกค้า %1 เป็นเจ้าของ:",
    'removeMailNames__these_mailnames_will_not_delete' => "บัญชีเมลเหล่านี้จะไม่ถูกลบ:",
    'removeFtpSessions__remove_title' => "ช่วงเวลา FTP ดังต่อไปนี้จะได้รับการลบ:",
    'removeTemplates__remove_templates' => "แม่แบบดังต่อไปนี้จะได้รับการลบ:",
    'resp_edit__always_respond' => "ตอบสนองเสมอ",
    'resp_edit__reply_subject' => "หัวข้อที่ตอบกลับ",
    'resp_edit__answer_subject' => "ตอบด้วยหัวข้อเรื่อง",
    'resp_edit__answer_txt' => "ตอบด้วยข้อความ",
    'resp_edit__attach' => "แนบไฟล์",
    'resp_edit__default_subject' => "ตอบกลับ: %1",
    'resp_edit__for' => "สำหรับ",
    'resp_edit__frw_rqst_email' => "ด้วยเป็นการตอบกลับแบบอัตโนมัติ โปรดส่งข้อความต้นแบบต่อไปยังอีเมลที่ระบุ",
    'resp_edit__fwd_email_invalid' => "ที่อยูู่่อีเมลปลายทางไม่ถูกต้อง",
    'resp_edit__in_body' => "เมื่อพบคำที่ระบุในข้อความ",
    'resp_edit__in_subject' => "เมื่อพบคำที่ระบุในหัวข้อ",
    'resp_edit__invalid_resp_freq' => "ความถี่ในการตอบกลับไม่ถูกต้อง",
    'resp_edit__invalid_rqst_txt' => "ข้อความการร้องขอไม่ถูกต้อง",
    'resp_edit__invalid_store_lim_num' => "ค่าขีดจำกัดไม่ถูกต้อง",
    'resp_edit__limits_title' => "จำกัด",
    'resp_edit__maximum_allowed_resp_freq_reached' => "จำนวนการตอบสนองสูงสุดในแต่ละวันเกินกว่าอัตราที่กำหนดแล้ว อนุญาต: %1 ร้องขอ: %2",
    'resp_edit__no_files_sel' => "ยังไม่ได้เลือกไฟล์",
    'resp_edit__no_txt_supplied' => "ไม่มีข้อความที่ให้มา",
    'resp_edit__reply_title' => "ตอบกลับ",
    'resp_edit__reply_to_address' => "กลับไปยังที่อยู่",
    'resp_edit__reply_to_invalid' => "กลับไปยังที่อยู้ที่ถูกต้อง",
    'resp_edit__reply_uniq_email' => "ตอบกลับไปยังที่อยู่อีเมลที่ไม่เหมือนใครที่ไม่มากกว่า",
    'resp_edit__conditions_title' => "เงื่อนไข",
    'resp_edit__request_title' => "ขอ",
    'resp_edit__resp' => "การตอบกลับอัตโนมัติ",
    'resp_edit__resp_name' => "ชื่อการตอบกลับอัตโนมัติ",
    'resp_edit__resp_not_exist' => "การตอบกลับอัตโนมัติไม่มีอยู่",
    'resp_edit__resp_status' => "สถานะการตอบกลับอัตโนมัติ",
    'resp_edit__rqst_txt' => 'ระบุเงื่อนไขสำหรับการตอบกลับอัตโนมัติ',
    'resp_edit__select_files_on_server_for_attach' => "เลือกไฟล์ที่คุณต้องการแนบ",
    'resp_edit__store_up_to' => "จัดเก็บได้ถึง",
    'resp_edit__subj_line_invalid' => "บรรทัดหัวข้อไม่ถูกต้อง",
    'resp_edit__text_too_big' => "ข้อความตอบกลับมีขนาดใหญ่เกินไป",
    'resp_edit__times_in_a_day' => "ครั้งต่อวัน",
    'resp_edit__unable_define_resp_cond' => "ไม่สามารถระบุเงื่อนไขของการตอบกลับอัตโนมัติ: %1",
    'resp_edit__unable_define_resp_status' => "ไม่สามารถระบุสถานะของการตอบกลับอัตโนมัติ: %1",
    'resp_edit__unable_turn_on_resp' => "ไม่สามารถเปิดการตอบกลับอัตโนมัติได้: %1",
    'resp_edit__uniq_email' => "ที่อยู่อีเมลที่ไม่เหมือนใคร",
    'resp_edit__content_type' => 'รูปแบบการส่งเมล',
    'resp_edit__content_type_text' => 'ข้อความธรรมดา',
    'resp_edit__content_type_html' => 'HTML',
    'resp_edit__charset' => 'การเข้ารหัส',
    'restart__dns' => 'เซิร์ฟเวอร์ DNS (%1)',
    'restart__drweb' => 'โปรแกรมป้องกันไวรัสระดับพรีเมี่ยมของ Plesk',
    'restart__mail' => "เซิร์ฟเวอร์ IMAP/POP3 (%1)",
    'restart__mssql' => "เซิร์ฟเวอร์ Microsoft SQL",
    'restart__mysql' => "เซิร์ฟเวอร์ MySQL",
    'restart__postgresql' => "PostgreSQL",
    'restart__psa' => "บริการ",
    'restart__smtp' => "SMTP เซิร์ฟเวอร์ (%1)",
    'restart__spamd' => "ตัวกรองสแปม",
    'restart__spamassassin' => "SpamAssassin",
    'restart__stunnel' => "Stunnel",
    'restart__web' => "เซิร์ฟเวอร์เว็บ (%1)",
    'restart__ftp' => "เซิร์ฟเวอร์ FTP (%1)",
    'restart__service_start' => 'โปรดให้เวลาสำหรับให้บริการเริ่มการทำงาน',
    'restart__service_stop' => 'โปรดให้เวลาสำหรับให้บริการหยุดการทำงาน',
    'restart__service_restart' => 'โปรดให้เวลาสำหรับให้บริการทำการรีสตาร์ท',
    'rm_domains__some_domains_are_not_exist' => "โดเมนที่ระบุบางโดเมนไม่มีอยู่ เป็นไปได้ว่าอาจถูกลบโดยผู้ใช้รายอื่น",
    'rpt_cl_dom_data_bases' => "DBMySQL",
    'rpt_cl_dom_mssql_data_bases' => "DBMSSQL",
    'rpt_cl_dom_mail_groups' => "MGroups",
    'rpt_cl_dom_mail_lists' => "MLists",
    'rpt_cl_dom_mail_resps' => "AResp.",
    'rpt_cl_dom_mail_antispam' => "แอนติสแปม",
    'rpt_cl_dom_mail_antivirus' => "ป้องกันไวรัส",
    'rpt_cl_dom_postboxes' => "MBoxes",
    'rpt_cl_dom_redirects' => "ผู้ส่งต่อ",
    'rpt_cl_dom_subdomains' => "Subdom",
    'rpt_cl_dom_domain_aliases' => "DAliases",
    'rpt_cl_dom_web_users' => "WUsers",
    'rpt_cl_report_for_admin__' => "รายงานสำหรับผู้ดูแลระบบ %1",
    'rpt_cl_report_for_reseller__' => "รายงานสำหรับตัวแทนจำหน่าย %1",
    'rpt_cl_report_for_cl__' => "รายงานเกี่ยวกับลูกค้า %1",
    'rpt_cl_section_domains' => "โดเมน",
    'rpt_cl_section_full_domains' => "โดเมน",
    'rpt_cl_section_general' => "ทั่วไป",
    'rpt_create' => "สร้างรายงาน",
    'rpt_empty' => "รายงานควรประกอบด้วยอย่างน้อยหนึ่งส่วน",
    'rpt_dom_report_for_dom__' => "รายงานโดเมนสำหรับ %1",
    'rpt_dom_section_databases' => "ฐานข้อมูล",
    'rpt_dom_section_full_databases' => "ฐานข้อมูล",
    'rpt_dom_section_full_maillists' => "รายชื่อผู้รับจดหมาย",
    'rpt_dom_section_full_mailnames' => "บัญชีเมล",
    'rpt_dom_section_full_webusers' => "ผู้ใช้เว็บ",
    'rpt_dom_section_full_siteapps' => 'แอพพลิเคชั่นเว็บ',
    'rpt_dom_section_full_aspnetapps' => 'แอพพลิเคชั่นเว็บ ASP.NET',
    'rpt_dom_section_general' => "ทั่วไป",
    'rpt_dom_section_hosting' => "โฮสติ้ง",
    'rpt_dom_section_maillists' => "รายชื่อผู้รับจดหมาย",
    'rpt_dom_section_mailnames' => "บัญชีเมล",
    'rpt_dom_section_siteapps' => 'แอพพลิเคชั่นเว็บ',
    'rpt_dom_section_aspnetapps' => 'แอพพลิเคชั่นเว็บ ASP.NET',
    'rpt_dom_section_webusers' => "ผู้ใช้เว็บ",
    'rpt_dom_title_wa_status' => "S",
    'rpt_edit__' => "แก้ไขรายงาน %1",
    'rpt_enter_email_address' => "ใส่ที่อยู่อีเมล รายงานที่จะถูกส่ง",
    'rpt_list' => "รูปแบบรายงานที่กำหนดเอง",
    'rpt_section_full' => "เต็ม",
    'rpt_section_none' => "ไม่มี",
    'rpt_section_summary' => "สรุป",
    'rpt_default_full' => 'รายงานฉบับเต็ม',
    'rpt_default_summary' => 'รายงานสรุป',

    // end of kooper part

    // pit part

    'rpt_send_report_by_email_error__' => "การส่งรายงานผิดพลาด: %1",
    'rpt_send_report_by_email_ok__' => "รายงานถูกส่งไปที่ %1 แล้ว",
    'sa_action' => "กระทำ",
    'sa_action_del' => "ลบ",
    'sa_action_desc' => "สิ่งที่ต้องทำกับเมลสแปม",
    'sa_action_save' => "ทำเครื่องหมายเป็นสแปมและเก็บลงในกล่องจดหมาย",
    'sa_admin_blacklist' => "บัญชีดำของผู้ดูแลระบบ",
    'sa_admin_whitelist' => "รายการที่ปลอดภัยของผู้ดูแลระบบ",
    'sa_db_del_confirm' => "คุณแน่ใจหรือไม่ว่าต้องการล้างฐานข้อมูลตัวกรองสแปม",
    'sa_eml_in_ignorelist' => "อีเมลอยู่ในรายการที่ไม่ต้องสนใจ",
    'sa_empty_email' => "ไม่สามารถเพิ่มรูปแบบอีเมลที่ว่างเปล่าได้",
    'sa_exists_email' => "มีรูปแบบอีเมลนั้นอยู่แล้ว",
    'sa_disabled__mailname_not_filtering' => "การตั้งค่าเซิร์ฟเวอร์ปัจจุบันไม่อนุญาตให้ใช้ตัวกรองเมลสำหรับบัญชีเมลนี้",
    'sa_disabled__filtering_is_disabled' => 'มีการปืดตัวกรองสแปมโดยผู้ดูแลระบนเซิร์ฟเวอร์',
    'sa_disabled__hasnt_mailbox' => "เป็นไปไม่ได้ที่จะเปิดตัวกรองสแปมดยปราศจากกล่องข้อความ",
    'sa_enable_filter' => "เปิดตัวกรองสแปม",
    'sa_forget' => "ลิม",
    'sa_from' => "จาก",
    'sa_ham' => "แฮม",
    'sa_pattern_is_invalid' => "รูปแบบไม่ถูกต้อง",
    'sa_spam' => "สแปม",
    'sa_trainer__page_title' => 'ฝึกอบรมเกี่ยวกับตัวกรองแปสม',
    'sa_trainer__tools_legend' => 'เครื่องมือ',
    'sa_trainer__info_legend' => 'ข้อมูล',
    'sa_trainer__messages_list_legend' => 'ข้อความในกล่องจดหมายของคุณ',
    'sa_trainer__c' => 'T',
    'sa_trainer__l' => 'L',
    'sa_trainer__subject' => 'ชื่อเรื่อง',
    'sa_trainer__from' => 'จาก',
    'sa_trainer__date' => 'วันที่',
    'sa_trainer__info_text' => 'ข้อความที่เรียนรู้ว่าเป็นสแปม: %1 เป็นสแปม %2 ไม่ใช่สแปม %3 ทั้งหมด',
    'sa_trainer__messages' => 'ข้อความ',
    'sa_trainer__select__all' => 'ทั้งหมด',
    'sa_trainer__select__spam_only' => 'สแปม',
    'sa_trainer__select__ham_only' => 'ไม่ใช่สแปม',
    'sa_trainer__select__unknown_only' => 'ไม่รู้จัก',
    'sa_trainer__cannot_remove_messages' => 'ไม่สามารถลบข้อความที่เลือกออกจากกล่องจดหมายได้',
    'sa_trainer__remove_messages_confirm' => 'คุณแน่ใจหรือไม่ว่าต้องการลบข้อความที่เลือกออกจากกล่องจดหมาย?',
    'sa_subj' => "ชื่อเรื่อง",
    'sa_training' => "ฝึกอบรมเกี่ยวกับตัวกรองแปสม",
    'sa_training_legend' => "ฝึกอบรมเกี่ยวกับตัวกรอง Bayesian",
    'sa_use_srv_settings' => "ตั้งค่าการใช้ทั่วทั้งเซิร์ฟเวอร์",
    'sa_user_blacklist' => "บัญชีดำของผู้ใช้",
    'sa_user_whitelist' => "รายการที่ปลอดภัยของผู้ใช้",
    'sa_usr_disabled_by_srv' => "ตั้งค่าการใช้ทั้วทั้งเซิร์ฟเวอร์",
    'sa_usr_no_postbox' => "ไม่สามารถเปิดใช้ระบบกรองสแปมได้เนืองจากกล่องจดหมายถูกปิดสวิตช์สำหรับบัญชีอีเมลนี้",
    'sa_filters' => 'ตัวกรองสแปม',
    'spamfilter__tools_legend' => 'เครื่องมือ',
    'spamfilter__prefs_legend' => 'การตั้งค่า',
    'spamfilter__max_children' => 'จำนวนสูงสุดของสแปมตัวปฏิบัติงานที่ทำงาน',
    'spamfilter__rewrite_header_subject_hint' => 'หากคุณไม่ต้องการเพิ่มข้อความใดๆ ควรปล่อยฟิลด์นี้ให้ว่างไว้ พิมพ์ _SCORE_ หากคุณต้องการเพิ่มคะแนนในหัวข้อของข้อความ',
    'spamfilter__reject_spam' => 'ลบเมลสแปมเมื่อเข้ามายังกล่องจดหมาย',
    'spamfilter__enabled' => 'เปิด',
    'spamfilter_addresses_list__items' => 'ที่อยู่',
    'spamfilter_addresses__remove_title' => 'ที่อยู่ดังต่อไปนี้จะได้รับการลบออกจากรายการ:',
    'spamfilter_addresses__empty_selection' => 'ไม่มีที่อยู่ที่เลือก',
    'server__admin_info' => "ข้อมูลผู้ดูแลระบบ",
    'server__ctrl_panel' => "Plesk",
    'server__enter_bug_essence_below' => "ป้อนรายละเอียดของจุดบกพร่องกด้านล่าง",
    'server__power_management' => "การจัดการพลังงาน",
    'server__services' => "บริการ",
    'server__system' => "ระบบ",
    'server__title' => "การบริหารจัดการเซิร์ฟเวอร์",
    'server_preferences__admin_skin' => "สกินหน้าจอของผู้ดูแลระบบ",
    'server_preferences__default_language' => "ภาษาเริ่มต้น",
    'server_preferences__default_skin' => "สกินเริ่มต้น",
    'server_preferences__restart_apache_interval' => "ช่วงเวลารีสตาร์ท Apache ไม่ถูกต้อง",
    'server_preferences__system' => 'การตั้งค่าระบบ',
    'mail__tabs_preferences' => "การตั้งค่า",
    'mail__tabs_white_list' => "รายการที่ปลอดภัย",
    'server_preferences__use_vocabulary' => "ตรวจสอบรหัสผ่านสำหรับกล่องจดหมายในสารบบ",
    'sessions__agreement' => "ใช่ ฉันต้องการสิ้นสุดช่วงเวลาเหล่านี้",
    'sessions__select_sessions_for_remove' => "เลือกข่วงเวลาที่ต้องการสิ้นสุด",
    'sessions__tabs_cp_sessions' => 'ช่วงเวลา Plesk',
    'sessions__tabs_ftp_sessions' => 'ช่วงเวลา FTP',
    'sessions__ftp_sessions_login' => 'ชื่อผู้ใช้บัญชี FTP',
    'sessions__ftp_sessions_domain' => 'ชื่อโดเมน',
    'sessions__ftp_sessions_path' => 'สถานที่ปัจจุบัน',
    'sessions__ftp_sessions_file' => 'ชื่อไฟล์',
    'sessions__ftp_sessions_action' => 'สถานะ',
    'sessions__ftp_sessions_speed' => 'ความเร็ว กิโลไบต์/วินาที',
    'sessions__ftp_sessions_comp' => 'ความกว้าวหน้า %',

    'site_apps__access_level' => 'ระดับการเข้าถึง',
    'site_apps__access_level_commercial' => 'การค้า',
    'site_apps__access_level_free' => 'ฟรี',
    'site_apps__action_installer' => "การติดตั้งแอพพลิเคชั่นเว็บ",
    'site_apps__action_reconfigure' => "การปรับตั้งค่าแอพพลิเคชั่นเว็บ",
    'site_apps__custom_button_level' => 'คุณต้องการสร้างปุ่มแบบกำหนดเองสำหรับการเข้าถึงแอพพลิเคชั่นนี้หรือไม่?',
    'site_apps__custom_button_level_false_domain_user_only' => 'ไม่',
    'site_apps__custom_button_level_domain_user_only' => 'ใช่',
    'site_apps__custom_button_level_false' => 'ไม่',
    'site_apps__custom_button_level_domain' => 'ใช่ และทำให้สามารถใช้ได้กับโดเมนปัจจุบันเท่านั้น',
    'site_apps__custom_button_level_client' => 'ใช่ และทำให้สามารถใช้ได้กับโดเมนของลูกค้าทั้งหมด',
    'site_apps__custom_button_level_admin' => 'ใช่ และทำให้สามารถใช้ได้กับโดเมนทั้งหมด',
    'site_apps__description' => "รายละเอียด",
    'site_apps__dir_used_by_sapp__' => "มีการใช้สารบบ \"%1\" จากแอพพลิเคชั่นเว็บอื่น",
    'site_apps__dir_used_by_unknown__' => "มีสารบบ \"%1\" อยู่แล้ว หากคุณดำเนินการต่อเนื้อหาของสารบบดังกล่าวจะได้รับการถูกเขียนทับ",
    'site_apps__dir_invalid_name__' => "ชื่อสารบบ %1 ไม่ถูกต้อง",
    'site_apps__file_name' => 'ชื่อไฟล์ของแอพพลิเคชั่นเว็บ',
    'site_apps__invalid_install_prefix' => "การติดตั้งคำนำหน้าไม่ถูกต้อง",
    'site_apps__invalid_package' => "แอพพลิเคชั่นเว็บไม่ถูกต้อง",
    'site_apps__key_status' => 'การออกใบอนุญาต',
    'site_apps__key_status_free' => 'แจกจ่ายฟรี ไม่จำเป็นต้องมีรหัสลิขสิทธิ์',
    'site_apps__key_status_ok' => 'ติดตั้งรหัสลิขสิทธิ์ที่จำเป็นแล้ว',
    'site_apps__key_status_problem' => 'ไม่ได้ติดตั้งรหัสลิขสิทธิ์ที่จำเป็น',
    'site_apps__name' => "ชื่อ",
    'site_apps__no_domains' => 'ไม่สามารถติดตั้งแอพพลิเคชั่นเว็บ มีการติดตั้งแอพพลิเคชั่นเว็บอื่นในสารบบรากของโดเมนนี้แล้ว โปรดพิจารณาการสร้างซับโดเมนสำหรับแอพพลิเคชั่นเว็บ',
    'site_apps__package_info_' => "ข้อมูลแอพพลิเคชั่นเว็บ",
    'site_apps__package_integrated' => "ไม่สามารถลบแอพพลิเคชั่นที่ติดตั้งมากับระบบได้",
    'site_apps__pool_select_packages_to_add' => 'เลือกแอพพลิเคชั่นเว็บที่จะเพิ่มลงในกลุ่ม',
    'site_apps__release' => "ออกวางจำหน่าย",
    'site_apps__resource_used_by_sapp' => "ทรัพยากรนี้ใช้โดยแอพพลิเคชั่นที่ได้รับการติดตั้ง",
    'site_apps__root_used_by_sapp' => "ทรัพยากรนี้ใช้โดยแอพพลิเคชั่นที่ได้รับการติดตั้ง",
    'site_apps__these_domains_will_not_delete' => 'ผลการค้นหา',
    'site_apps__upload_site_app_pkg_title' => 'อัพโหลดแอพพลิเคชั่นเว็บใหม่',
    'site_apps__version' => "เวอร์ชั่น",
    'site_apps__access_to' => "การเข้าถึง %1",
    'site_builder_requires' => '%1 - %3',
    'skeleton__admin_label' => "แม่แบบโฮสต์เสมือนจริง",
    'skeleton__client_label' => "%1 แม่แบบโฮสต์เสมือน",
    'skeleton__admin_page' => "จัดการแม่แบบโฮสต์เสมือน",
    'skeleton__files_list' => "ไฟล์และสารบบ",
    'skeleton__archiver_not_installed' => "ไม่สามารถแยกที่เก็บไฟล์ถาวร ยังไม่ได้ติดตั้งตัวเก็บไฟล์ถาวรบนเซิร์ฟเวอร์ ให้ติดต่อผู้ดูแลระบบ {$PROD_NAME} เพื่อทำการติดการติดตั้งซอฟต์แวร์ตัวเก็บไฟล์ถาวร",
    'skeleton__client_page' => "จัดการแม่แบบโฮสต์เสมือน",
    'skeleton__archive_corrupted' => "การตรวจสอบที่เก็บไฟล์ถาวรตรวจพบว่า ไฟล์ที่จัดเก็บถาวรเสียหายหรือไม่รองรับประเภภทที่จัดเก็บไฟล์ถาวรนี้",
    'skeleton__archive_too_large' => "การตรวจสอบที่เก็บไฟล์ถาวรตรวจพบว่า ไฟล์ที่จัดเก็บถาวรมีขนาดใหญ่เกินไป",
    'skeleton__not_supported_archive_type' => "ไม่รองรับประเภทหน่วยเก็บสกินถาวรนี้ (ไฟล์ %1)",
    'skeleton__upload_archive_file' => "อัพโหลดไฟล์ที่เก็บถาวร",
    'skin_download__title' => 'ดาวน์โหลดสกิน',
    'skin_download_now__title' => 'กำลังดาวน์โหลดสกิน',
    'skin_download_now__text' => 'การสร้างแพคเกจสกินอยู่ในขั้นดำเนินการ<br>การดำเนินการอาจใช้เวลาสักครู่<br>เมื่อหน้า่ต่างสนทนาปรากฏขึ้น คุณจะสามารถใช้ Plesk ต่อได้',
    'skin_file__help_for_using_types' => "โปรดใช้หน่วยเก็บสกินถาวรจากรูปแบบดังต่อไปนี้:",
    'skin_info__title' => 'คุณสมบัติสกิน',
    'skin_mng_err__rpm_not_skin' => 'RPM นี้ไม่มีในแพ็คเกจสกินของ Plesk',
    'skin_mng_err__psa_install_noreloc' => 'ไม่สามารถติดตั้งสกินแบบรอบต่อนาทีในสถานที่ที่ระบุได้',
    'skin_mng_err__already_exists' => 'มีการติดตั้งสรบบสกินแล้ว และมีการนำแพคเกจสกินไปใช้แล้ว',
    'skin_mng_err__rpm_upgrade_nonrpm' => 'ไฟล์ที่อัพโหลดไม่ใช่แพคเกจสกินรอบต่อนาที',
    'skin_mng_err__rpm_upgrade_noskin' => 'ไฟล์ที่อัพโหลดไม่ใช่แพคเกจสกิน',
    'skin_mng_err__rpm_upgrade_base' => "ไฟล์ที่อัพโหลดไม่ใช่แพคเกจสกิน {$PROD_NAME} ที่ถูกต้อง",
    'skin_mng_err__rpm_upgrade_other' => 'ไม่สามารถติดตั้งสกิน: รูปแบบสกินไม่ถูกต้อง',
    'skin_mng_err__no_a_skin' => "ไฟล์ที่อัพโหลดไม่ใช่แพคเกจสกิน {$PROD_NAME} ที่ถูกต้อง",
    'skin_upload__title' => 'อัพโหลดสกินใหม่',
    'skin_upload__already_exists' => "มีสกิน '%1' แล้ว",
    'skin_upload__unable_to_apply' => "ไฟล์ที่อัพโหลดไม่มีสกินของ Plesk หรือรูปแบบของอาไคฟ์ ไม่ได้รับการรองรับ",
    'skin_upload__unable_to_rename__' => "ไม่สามารถตั้งชื่อสกิน %2 เป็น %1: %3",
    'skin_upload__file_name' => 'พาธไปยังไฟล์แพคเกจสกิน',
    'skins_list__title' => 'ที่จัดเก็บสกิน',
    'skins_remove__title' => 'การลบสกิน',
    'skins_remove__select_skins_for_remove' => 'เลือกสกินที่เพื่อลบ',

    'spf__unable_update' => 'ไม่สามารถอัพเดทพารามิเตอร์ SPF',
    'statistics__active_domains' => "โดเมนที่ใช้งานอยู่",
    'statistics__clients' => "ลูกค้า",
    'statistics__subdomains' => "โดเมนย่อย",
    'statistics__cpu' => "CPU",
    'statistics__databases' => "ฐานข้อมูล",
    'statistics__db_users' => "ผู้ใช้ฐานข้อมูล",
    'statistics__dirs' => "สารบบที่ได้รับการป้องกัน",
    'statistics__dom_active' => "ใช้งานอยู่",
    'statistics__dom_passive' => "ไม่ได้ใช้งาน",
    'statistics__dom_problem' => "ปัญหา",
    'statistics__domains' => "โดเมน",
    'statistics__domains_with_host' => "โดเมนพร้อมโฮสติ้ง",
    'statistics__doms' => "โดเมน",
    'statistics__filesystem' => "ระบบไฟล์",
    'statistics__general' => "ทั่วไป",
    'statistics__hdd_available' => "มีอยู่",
    'statistics__hdd_capacity' => "ความจุ",
    'statistics__hdd_total' => "ทั้งหมด",
    'statistics__hdd_usage' => "การใช้งานฮาร์ดิสก์",
    'statistics__hdd_used' => "ใช้แล้ว",
    'statistics__ip' => "ที่อยู่ IP",
    'statistics__key_number' => "หมายเลขรหัส",
    'statistics__l1' => "1 นาทีสาสุด",
    'statistics__l15' => "15 นาทีล่าสุด",
    'statistics__l5' => "5 นาทีล่าสุด",
    'statistics__la' => "การใช้งาน CPU",
    'statistics__mail_autoresponders' => "การตอบกลับอัตโนมัติ",
    'statistics__mail_boxes' => "กล่องจดหมาย",
    'statistics__mail_groups' => "กลุ่มเมล",
    'statistics__mail_lists' => "รายชื่อผู้รับจดหมาย",
    'statistics__mail_redirects' => "ผู้ส่งต่อเมล",
    'statistics__mem' => "การใช้งานหน่วยความจำ",
    'statistics__mem_usage' => "การใช้งาน",
    'statistics__memory_available' => "มีอยู่",
    'statistics__memory_buffer' => "บัพเฟอร์",
    'statistics__memory_cached' => "แคช",
    'statistics__memory_free' => "ฟรี",
    'statistics__memory_shared' => "ใช้ร่วมกัน",
    'statistics__memory_total' => "ทั้งหมด",
    'statistics__memory_used' => "ใช้แล้ว",
    'statistics__os' => "ระบบปฏิบัติการ",
    'statistics__problem_clients' => "ลูกค้าที่มีปัญหา",
    'statistics__problem_domains' => "ปัญหาโดเมน",
    'statistics__swap' => "การใช้ Swap",
    'statistics__swap_free' => "ฟรี",
    'statistics__swap_total' => "ทั้งหมด",
    'statistics__swap_usage' => "การใช้งาน",
    'statistics__swap_used' => "ใช้แล้ว",
    'statistics__system_stat' => "ข้อมูลเซิร์ฟเวอร์",
    'statistics__unable_define_active_doms' => "ไม่สามารถระบุจำนวนโดเมนที่ใช้งาน: %1",
    'statistics__unable_define_inactive_doms' => "ไม่สามารถระบุจำนวนโดเมนที่ใช้งาน: %1",
    'statistics__failed_define_swap_usage' => 'กำหนดการใช้ Swap ไม่สำเร็จ',
    'statistics__failed_define_load_averages' => 'กำหนด Load Averages ไม่สำเร็จ',
    'statistics__up_time' => "ช่วงเวลาใช้งานระบบ:",
    'statistics__ver' => "เวอร์ชั่น",
    'statistics__web_users' => "ผู้ใช้เว็บ",
    'statistics__mem_win' => "ความจำตัวเครื่องที่ใช้ได้",
    'statistics__memory_total_win' => "ทั้งหมด",
    'statistics__memory_used_win' => "ใช้แล้ว",
    'statistics__memory_free_win' => "มีอยู่",
    'statistics__swap_win' => "ความจำเสมือนที่ใช้ได้",
    'statistics__swap_total_win' => "ทั้งหมด",
    'statistics__swap_used_win' => "ใช้แล้ว",
    'statistics__swap_free_win' => "มีอยู่",
    'status__domain_has_reasons_to_be_off' => "โดเมนยังคงถูกระงับการใช้งานด้วยเหตุดังต่อไปนี้: %1",
    'subdomain__create__' => "สร้างซับโดเมนในโดเมน %1",
    'subdomain__edit__' => "จัดการซับโดเมน %1",
    'subdomain__invalid_name' => "ชื่อซับโดเมนไม่ถูกต้อง: ใช้ตัวอักษรหรือตัวเลขและเครื่องหมาย - เท่านั้น",
    'subdomain__incorrect_name' => "ชื่อซับโดเมนไม่ถูกต้อง",
    'subdomains__maillists_enabled_in_domain' => "รายชื่อซับโดเมนไม่ถูกต้อง %1: มีการใช้ชื่อโดเมนโดยรายชื่อสำหรับส่งจดหมายในโดเมน %1 อยู่แล้ว",
    'subdomains__dalias_exists' => 'มีโดเมนนามแฝงที่ใช้ชื่อนี้อยู่แล้ว',
    'subdomains__name_exists' => "ซับโดเมนที่มีชื่อนั้นมีอยู่แล้ว",
    'subdomains__regular_domain_exists' => "โดเมนที่มีชื่อนั้นมีอยู่แล้ว",
    'subdomains__domain_alias_exists' => 'มีโดเมนนามแฝงที่ใช้ชื่อนี้อยู่แล้ว',
    'subdomains__remove_subdomains_on_domain' => "ซับโดเมนดังต่อไปนี้สำหรับโดเมน %1 จะได้รับการลบออก:",
    'subdomains__select_subdomains_for_remove' => "เลือกซับโดเมนเพื่อลบ",
    'subdomains__webmail_enabled_in_domain' => "เว็บเมลชื่อซับโดเมนไม่ถูกต้อง %1: ชื่อโดเมนนี้ถูกใช้กับการเข้าสู่เว็บเมลภายใต้โดเมน %1",
    'subdomains__dns_record_already_exists' => 'ไม่สามารถสร้างซับโดเมน %1 เนื่องจากรายการ DNS ชี้ไปยังโฮสต์ %1',
    'subdomains__www_prefix_in_domain' => "ชื่อซับโดเมน www.%1 ไม่ถูกต้อง: %1 มีคำนำหน้า WWW แล้ว",
    'subdomains__user_type_quota_exceeds' => 'ไม่สามารถเปลี่ยนแปลงบัญชีผู้ใช้ เพราะจะส่งผลให้เกินพื้นที่ดิสก์ที่ได้รับการจัดสรร',
    'subdomains__creation_in_dns_slave' => "เซิร์ฟเวอร์ชื่อของ Plesk ทำหน้าที่เป็นเซิร์ฟเวอร์ชื่อลับดับสองสำหรับโดเมนนี้ เพื่อให้ซับโดเมนของคุณแยกแยะได้ถูกต้อง ตรวจว่าไฟล์โซนในเซิร์ฟเวอร์ DNS หลักมีบันทึก %1",
    'sys_user__attributes_not_changed' => "\nคุณลักษณะของผู้ใช้ระบบดังต่อไปนี้จะไม่เปลี่ยนแปลง: %1",
    'sys_user__no_access_without_password' => "คุณไม่ตั้งรหัสผ่าน ผู้ใช้ระบบจะได้รับการสร้าง แต่จะไม่สามารถเข้าสู่ระบบได้ จนกว่าจะได้รับมอบรหัสผ่าน คุณต้องการที่จะดำเนินการต่อหรือไม่?",
    'sys_user__no_hard_quota' => "ไม่รองรับ",
    'sysuser__zero_quota_is_unlimited' => "0 สำหรับไม่จำกัด",
    'template__num_excl_ips' => "จัดสรร IP แอดเดรสเฉพาะให้ลูกค้า",
    'template__sel_sh_ips' => "เลือก IP แอดเดรสที่แบ่งปัน",
    'template__av_sh_ips' => "มี IP แอดเดรสที่แบ่งปัน",
    'template__up_to_excl_ip' => "มากถึง %1 IP แอดเดรส",
    'templates__all_clients' => "ลูกค้าทั้งหมด",
    'templates__cl_domain_templates' => "แม่แบบสำหรับ %1",
    'templates__cl_templates' => "แม่แบบลูกค้า",
    'time__invalid_ip' => "IP แอดเดรส และชื่อโดเมนไม่ถูกต้อง",
    '__please_select_country' => 'โปรด ระบุประเทศของคุณ',
    'time__unable_set_time' => "ไม่สามารถตั้งเวลาระบบ: %1",
    'time__sinchronization_setup_error' => 'ไม่สามารถตั้งค่าการซิงโครไนซ์เวลาได้: การจับเวลาล้มเหลว: %1',
    'time__sinchronization_disable_error' => 'ไม่สามารถปิดการซิงโครไนซ์เวลาได้: การจับเวลาล้มเหลว: %1',
    'tmpl__create' => "สร้างแม่แบบ",
    'tmpl__edit__' => 'แม่แบบ %1',
    'tmpl__logrotation_warn' => "การหมุนเข้าสู่ระบบบนโดเมนที่สร้างโดยแม่แบบนี้จะทำงานในกรณีที่มีการสร้างบัญชีโฮสติ้งทางกายภาพให้ไว้เท่านั้น",
    'tmpl__name' => "ชื่อแม่แบบ",
    'tmpl__dom_exist' => "แม่แบบโดเมนที่มีชื่อนั้นมีอยู่แล้วในกลุ่มแบบของผู้ดูแลหรือลูกค้า",
    'tmpl__name_invalid' => "ชื่อแม่แบบไม่ถูกต้องหรือว่าง",
    'tmpl__use_next_ip_addr' => "IP แอดเดรสถัดไปจะได้รับการใช้",
    'tmpl_name_already_exists' => "มีแม่แบบชื่อ '%1' อยู่แล้ว",
    'traffic__no_periods_found' => "ไม่สามารถแสดงเว็บหรือสถิติทราฟฟิคได้ ฟังก์ชั่นนี้จะใช้ได้หลังจากการคำนวนสถิติครั้งต่อไปเท่านั้น",

    'vh_based__no_free_ip_for_vh' => "ไม่มี IP แอดเดรสว่างสำหรับโฮสติ้งตาม IP โปรดเพิ่ม IP แอดเดรส",

    'wu__at_domains_text' => "รูปแบบการอนุญาตผู้ใช้งานเว็บ @%1",
    'wu__unable_create' => "ไม่สามารถผู้ใช้เว็บ: %1",
    'wu_edit__disk_quota' => "โควต้าดิสก์",
    'wu_edit__invalid_pass' => "รหัสผ่านไม่ถูกต้อง",
    'wu_edit__invalid_quota' => "ค่าโควต้าพื้นที่ดิสก์ที่ระบุไม่ถูกต้อง โปรดป้อนจำนวนเต็มบวก",
    'wu_edit__invalid_quota_value' => "โควต้าของพื้นที่การใช้งานที่ระบุนี้ น้อยกว่าพื้นที่การใช้งานที่ใช้อยู่ในปัจจุบัน (%1MB) ฟังก์ชั่นการใช้งานบางอย่างไม่สามารถใช้ได้ แน่ใจแล้วหรือที่จะดำเนินการต่อไป?",
    'wu_edit__not_create_pass' => "การดำเนินการนี้จะไม่สามารถสร้างรหัสผ่านใหม่สำหรับผู้ใช้เว็บใหม่ \nผู้ใช้ไม่สามารถเข้าสู่ระบบได้หากไม่มีรหัสผ่าน",
    'wu_edit__unable_update' => "ไม่สามารถอัพเดทคุณสมบัติของผู้ใช้เว็บได้ %1",

    'bt_webdirs' => 'ไดเร็กทอรี่เสมือน',

    'dns__tabs_general' => 'การตั้งค่าโซน',
    'dns__tabs_zone_settings' => 'รายการ SOA',
    'soa__seconds' => 'วินาที',
    'soa__minutes' => 'นาที',
    'soa__hours' => 'ชั่วโมง',
    'soa__days' => 'วัน',

    'DomainSubdirectory' => 'ปลายทางของสารบบย่อย',

    'filemanager__select_codepage' => 'เลือก codepage:',

    'bt_server_app_add' => 'เพิ่มแอพพลิเคชั่นเซิร์ฟเวอร์',
    'packages_list' => 'แอพพลิเคชั่นเซิร์ฟเวอร์',

    'bt_packages_management' => 'การจัดการแพคเกจ',
    'pb__packages_management' => 'ปรับตั้งค่าแอพพลิเคชั่น',
    'bt_package_new' => 'เพิ่มแอพพลิเคชั่น',
    '__packages' => 'แอพพลิเคชั่นเซิร์ฟเวอร์',

    'dom_ctrl__mysql_dbase_space' => 'โควต้าฐานข้อมูล MySQL ทั้งหมด',
    'dom_ctrl__mssql_dbase_space' => 'โควต้าฐานข้อมูล MS SQL ทั้งหมด',

    'dns_add__enter_ixfr_path' => 'ระบุ IXFR Path',

    'cmd_dns__txt_dns_record_already_exist' => 'มีบันทึก SPF TXT อยู่แล้ว มีบันทึก SPF ได้เพียงหนึ่งบันทึกเท่านั้น เพื่อเพิ่มบันทึก ให้ลบบันทึกที่มีอยู่แล้วออกก่อน',

    'component_name__network' => 'เครือข่าย',
    'component_name__sitebuilder' => 'Presence Builder',

    'bt_skin_set' => 'ตั้งสกิน',
    'bt_set_skin' => 'ตั้งสกิน',
    'firewall__rule_already_exists' => 'มีกฎที่มีชื่อ "%1" อยู่แล้ว',
    'firewall__rule_readonly' => 'กฎ "%1" อ่านได้เท่านั้น',
    'pb__firewall' => 'ไฟร์วอลล์',

    '__webstat_smarterstats' => 'SmarterStats',

    'error_doc__erorr_invalid_file_location' => 'ที่ตั้งของไฟล์ไม่ถูกต้อง',

    'error_doc__erorr_invalid_url_location' =>  'รูปแบบ URL ไม่ถูกต้อง โปรดระบุ URL ที่ถูกต้องกับโฮสต์เสมือน (เว็บไซต์)',

    'mn_list__tab_title_antivirus' => 'AV',

    'bt_antivirus' => 'ป้องกันไวรัส',
    'antivirus__antivirus' => 'การป้องกันด้วยแอนติไวรัส',
    'antivirus__antivirus_direction_off' => 'ปิด',
    'antivirus__antivirus_direction_any' => 'เมลขาเข้าและขาออก',
    'antivirus__antivirus_direction_from' => 'เมลขาออกเท่านั้น',
    'antivirus__antivirus_direction_to' => 'เมลขาเข้าเท่านั้น',
    'antivirus__unable_to_update_settings' => 'ไม่สามารถเปลียนการตั้งค่าการป้องกันไวรัสได้: %1',




    '__normal' => 'ปกติ',
    '__low' => 'ต่ำ',
    '__high' => 'สูง',

    'mail__antivirus' => "แอนติไวรัสเซิร์ฟเวอร์เมลภายใน",
    'mail__use_internal_antivirus' => 'ใช้แอนติไวรัสภายใน',

    'sa__tabs_blacklist' => 'บัญชีดำ',

    '__mysql_databases' => 'ฐานข้อมูล MySQL',

    'cl_perm__mysql_dbase_space' => 'โควต้าฐานข้อมูล MySQL ทั้งหมด',
    'cl_perm__mssql_dbase_space' => 'โควต้าฐานข้อมูล MS SQL ทั้งหมด',
    'cl_perm__max_mssql_db' => 'จำนวนสูงสุดของฐานข้อมูลเซิร์ฟเวอร์ Microsoft SQL',
    'cl_perm__total_mboxes_quota' => 'โควต้าทั้งหมดของกล่องจดหมาย',

    'i_i_cl_on' => 'บัญชีลูกค้าเปิดใช้งาน',
    'i_i_cl_off_by_admin' => 'บัญชีลูกค้าถูกระงับโดยผู้ดูแล',

    'sa_exists_tn' => 'มีเครือข่ายอยู่ในรายการแล้ว',

    'webdir__select_mime_types_to_remove' => 'เลือกชนิด MIME ที่คุณต้องการลบ',

    'defaultcomponents__not_activated' => 'ไม่ทำงาน',

    'bt_traffic_at_domains' => 'การรับส่งข้อมูล',

    '__awstats_perl_warning' => 'ถ้ายังไม่ได้ติดตั้ง Perl AWStats จะไม่อนุญาตให้ผู้ใช้งานตรวจสอบสถิติการใช้งานของปีก่อนหน้านี้ได้',

    'class_client__mysql_dbase_space' => 'ค่าเกินขีดจำกัดของลูกค้า',
    'class_client__mssql_dbase_space' => 'ค่าเกินขีดจำกัดของลูกค้า',
    'class_client__max_mssql_db' => 'ค่าเกินขีดจำกัดของลูกค้า',

    'dns__remove_transfer_restrictions_list_items' => 'เครือข่ายดังกล่าวจะถูกลบออกจากรายการควบคุม:',

    'bt_up' => "ขึ้น",
    'bt_down' => "ดาวน์",
    'virtualdir__type_default_doc_name_to_add' => 'ระบุชื่อไฟล์เพิ่มในรายการ',
    'virtualdir__select_default_doc_to_remove' => 'เลือกไฟล์เพื่อลบจากรายการ',
    'virtualdir__select_directory' => 'เลือกไดเรกทอรี่',

    'bt_install_selected' => 'ติดตั้งรหัสอนุญาตที่เลือกไว้', // SELECTED


    'dom_pref__the_domain_resolves_to_another_ip_address' => 'โดเมนกำหนดไว้กับ IP แอดเดรสอีกหมายเลข: (%1) โปรดแก้ไขการตั้งค่า DNS',

    'mn_edit__mailbox_enable_if_mailgroup_enabled' => 'เซิร์ฟเวอร์เมลที่ใช้งานอยู่ปัจจุบันไม่สามารถรองรับได้การเปิดใช้งานพร้อมกันๆ ของทั้งกล่องจดหมายและกลุ่มเมล กดตกลงเพื่อเปิดใช้งานกล่องจดหมายแต่ปิดใช้งานกลุ่มเมล กดยกเลิกถ้าไม่ต้องการเปลี่ยนแปลงใดๆ',

    'mn_edit__mailgroup_enable_if_mailbox_enabled' => 'เซิร์ฟเวอร์เมลที่ใช้งานอยู่ปัจจุบันไม่สามารถรองกรับการเปิดใช้งานพร้อมๆ กันของทั้งกล่องจดหมายและกลุ่มเมลได้ กดตกลงเพื่อเปิดใช้งานกลุ่มเมลแต่ปิดใช้งานกล่องจดหมาย กดยกเลิกเพื่อไม่ทำการเปลี่ยนแปลงใดๆ',

    'mysql_dbase_space_limit' => 'จำกัดพื้นที่ของฐานข้อมูล MySQL',
    'mysql_dbase_usage' => 'พื้นที่การใช้งานของฐานข้อมูล MySQL',
    'mssql_dbase_space_limit' => 'จำกัดพื้นที่ของฐานข้อมูล Microsoft SQL Server',
    'mssql_dbase_usage' => 'พื้นที่การใช้งานของฐานข้อมูล Microsoft SQL Server',

    '__statistics' => "สถิติ", //indirect

    'dns__soa_minimum_value_is_big' => 'การตั้งค่าขั้นต่ำของ TTL ไว้มากกว่า 3 ชั่วโมงอาจส่งผลให้ผู้ดูแลระบบบางท่านไม่สามารถใช้งานโดเมนได้ แนะนำให้ใช้การตั้งค่าแบบนั้นในกรณีที่มีการลงทะเบียนชื่อโดเมน',

    'virusfilter__interface_not_available' => 'ไม่มีตัวกรองไวรัส',
    'virusfilter__none_virus_filter' => 'ไม่มี',
    'virusfilter__mailname_status_text' => 'แอนติไวรัส (%1)',
    'virusfilter__status_none' => 'ปิด',
    'virusfilter__status_any' => 'จดหมายเข้าและออก',
    'virusfilter__status_outgoing' => 'จดหมายออกเท่านั้น',
    'virusfilter__status_incoming' => 'จดหมายเข้าเท่านั้น',

    'visibility__root_override_parse_error' => 'มีผิดไวยากรณ์ในไฟล์ %1 ในแถว %2',

    'sb__not_support_publishing_api' => "จัดแสดงแบบอัตโนมัติไม่ได้รับรองโดยคอมโพแนนท์",

    'component_name__cphosting' => "Plesk Hosting",

    'dom_pref__unable_set_up_total_mboxes_quota' => 'เซิร์ฟเวอร์เมลในปัจจุบันไม่รองรับการตั้งค่าโควต้ากล่องจดหมาย',
    '__unable_get_total_mboxes_quota' => 'เซิร์ฟเวอร์เมลในปัจจุบันไม่รองรับการตั้งค่าโควต้ากล่องจดหมาย',

    'install_prefix__parent_not_exists' => "ไม่มีสารบบผู้ปกครอง",

    'bt_change_version' => 'เปลี่ยนเวอร์ชั่น',
    'pb__aspdotnet' => 'ASP.NET',

    '__check_all' => "เลือกทั้งหมด",
    '__uncheck_all' => "ล้างทั้งหมด",

    'dns__editing_domain_controller_zone' => "แก้ไขรายการ DNS โซนสำหรับตัวควบคุมโดเมน อาจส่งผลให้การทำงานของโดเมนมีปัญหา",

    'pb__interface_management' => "การจัดการหน้าจอ",
    'interface_management__tabs_skins' => "สกิน",
    'interface_management__tabs_interface_templates' => "แม่แบบหน้าจอ",
    'interface_management__tabs_locales' => "Locale",
    'locales_list__title' => "ที่จัดเก็บชุดภาษา",
    'locales_list__legend' => "ภาษาที่มี",
    'locales_list__active_title' => "S",
    'locales_list__locale_title' => "ชุดภาษา",
    'locales_list__lang_title' => "ภาษา",
    'locales_list__country_title' => "ประเทศ",
    'locales_list__used_title' => "ใช้แล้ว",

    'backup__suspend_warning_during_backup' => "โดเมนจะไม่สามารถใช้ได้ชั่วคราวระหว่างทำการสำรองไฟล์",
    'backup__suspend_warning_during_restore' => "โดเมนจะไม่สามารถใช้ได้ระหว่างทำการกู้คืนไฟล์",
    'backup__suspend_domain' => "ระงับการใช้โดเมน",

    'locales_list__mls_limit' => "ลิขสิทธิ์ Plesk ปัจจุบันของคุณให้ใช้ %2 ภาษาได้ ขณะนี้ คุณได้ตั้งค่า %1 ภาษาสำหรับผู้ใช้ ซึ่งเกินขีดจำกัดของจำนวนที่ให้มากับลิขสิทธิ์ โปรดเลือก %2 ภาษาที่ต้องการ และให้ผู้ใช้คนอื่นใช้ภาษาอื่นไม่ได้โดยคลิกที่ไอคอนในคอลัมน์ \\S'",

    'bt_change_owner' => 'กำหนดเจ้าของใหม่',
    'chown__new_owner' => 'เจ้าของใหม่',
    'chown__selected_domains' => 'เลือกการบอกรับ',
    'chown__limits_legend' => 'ทรัพยากร',
    'chown__limit_name' => 'ชื่อทรัพยากร',
    'chown__limit_value' => 'ทรัพยากรที่ได้รับการจัดสรร',
    'chown__limit_assigned_before' => 'ก่อนการถ่ายโอน',
    'chown__limit_assigned_after' => 'หลังจากถ่ายโอน',
    'chown__error_limits' => "ไม่สามารถดำเนินการโอนการสมัครรับบริการได้: การสมัครรับบริการนี้ต้องการทรัพยากรที่หาได้จากผู้ให้บริการของเ้จ้าของคนใหม่",
    'chown__error_no_domains' => 'ไม่สามารถดำเนินการโอนการสมัครรับบริการได้: ไม่ได้เลือกการสมัครรับบริการ หรือการสมัครรับบริการที่เลือกนั้นเป็นของเป้าหมายผู้ใช้คนอื่นแล้ว',
    'chown__error_empty_ip_pool' => "ไม่สามารถดำเนินการโอนการสมัครรับบริการได้: กลุ่ม IP ของผู้ให้บริการเจ้าของคนใหม่ว่างเปล่า โปรดตรวจสอบว่าผู้ให้บริการมีอย่างน้อย 1 IP แอดเดรสในกลุ่ม",
    'chown__please_select_new_domain_owner' => 'เลือกเจ้าของใหม่สำหรับการสมัครรับบริการนี้',
    'chown__old_ip_address' => 'IP แอดเดรสปัจจุบัน',
    'chown__new_ip_address' => 'IP แอดเดรสใหม่',

    'chown__error_ssl_already_used' => "ใช้งานการสนับสนุน SSL/TLS เรียบร้อยแล้วบน IP ปลายทางต่อไปนี้: %1 ดังนั้น จึงไม่สามารถส่งต่อโดเมนที่มีการสนับสนุน SSL/TLS ต่อไปนี้ได้: %2. โปรดแก้ไขปัญหานี้ แล้วลองอีกครั้ง",
    'chown__sitebuilder_not_installed' => 'ยังไมได้ติดตั้ง Presence Builder',
    'chown__domain_exclude_sitebuilder_not_installed' => 'โดเมน %1 ไม่สามารถโอนไปยังเจ้าของใหม่ได้ เพราะ ยังไม่ได้ติดตั้ง Presence Builder',

    'backup__backup_time' => 'เวลาในการสำรองข้อมูล',
    'backup__backup_time_hour' => 'ชั่วโมง',
    'backup__backup_time_minute' => 'นาที',
    'backup__every' => 'ทุกๆ',
    'backup__day_of_month' => 'วันของเดือน',

    'subdomain__select_hst_type' => 'เลือกประเภทของโฮสติ้งสำหรับซับโดเมน',
    'hst_sel__subdom_subfolder_hst' => 'ซับโดเมนบนโฟลเดอร์ย่อย',
    'subdomain__www_root_folder_not_exists' => 'ไม่มีสารบบหลัก %1 อยู่',
    '__site_home_dir' => 'หน้าหลักของสารบบเว็บไซต์',
    'subdomain__aspnet_disabled_domain' => 'ปิดโดยโดเมน',

    'domains__remove_description' => 'จะลบข้อมูลโดเมนทั้งหมด รวมถึงเนื้อหาและการตั้งค่าของโดเมนและโดเมนย่อยที่เกี่ยวข้อง ข้อมูลแอพพลิเคชั่นเว็บ เนื้อหากล่องจดหมาย เมล การตั้งค่าการกรองสแปมและการป้องกันไวรัส ไฟล์บันทึก ข้อมูลในที่จัดเก็บข้อมูลสำหรับการสำรองข้อมูลโดเมนและการรับรอง SSL/TLS ออก หากคุณไม่มีไฟล์สำรองข้อมูลบนเครื่องภายในระบบของคุณ ข้อมูลทั้งหมดจะหายไปอย่างถาวร',
    'subdomains__remove_description' => 'ข้อมูลซับโดเมนทั้งหมด รวมทั้งเนื้อหาของซับโดเมนและการตั้งค่า ข้อมูลแอพพลิเคชั่นเว็บ และ lไฟล์การเข้าระบบจะถูกลบทิ้ง ถ้าคุณไม่มีการสำรองไฟล์ไว้ที่เครื่องของคุณ ข้อมูลทั้งหมดนี้จะถูกลบอย่างถาวร',

    'mail__tabs_spam_filtering' => 'ตัวกรองกันสแปม',
    'mail__tabs_antivirus' => 'ป้องกันไวรัส',
    'antivirus__use_server_settings_scan' => 'ใช้การตั้งค่าเริ่มต้นทั่วทั้งเซิร์ฟเวอร์ (สแกน)',
    'antivirus__use_server_settings_no_scan' => 'ใช้การตั้งค่าเริ่มต้นทั่วทั้งเซิร์ฟเวอร์ (ห้ามสแกน)',
    'antivirus__check_for_viruses' => 'สแกนไวรัส',
    'antivirus__dont_check_for_viruses' => 'อย่าสแกนไวรัส',
    'antivirus__incoming_mail' => 'เมลขาเข้า',
    'antivirus__outgoing_mail' => 'เมลขาออก',

    'domain_alias__CNAME_dns_record_exists' => 'บันทึก DNS CNAME ที่มีชื่อนั้นมีอยู่แล้ว',
    'domain_alias__A_dns_record_exists' => 'บันทึก DNS A ที่มีชื่อนั้นมีอยู่แล้ว',
    'domain_alias__bad_prefix' => 'คำนำหน้าไม่ถูกต้องสำหรับโดเมนนามแฝง',
    'domain_alias__domain_doesnt_exist' => "ไม่มีโดเมนอยู่",

    'dns__zone_ttl_message_info' => 'หากไม่ได้มีการระบุค่า TTL ไว้ ระบบจะใช้ค่าในแม่แบบบันทึก SOA (%1) สำหรับระเบียน DNS นี้',

    '__webalizer_support' => 'Webalizer',
    '__awstats_support' => 'AWStats',
    '__smarterstats_support' => 'SmarterStats',

    'site_apps__make_default_warning_message' => "ไฟล์ชื่อ index.html จะถูกสร้างขึ้นเพื่อโอนไปยังแอพพลิเคชั่นเว็บที่เลือก หากไฟล์ชื่อ index.html มีอยู่แล้ว ไฟล์จะถูกสำรองเป็น index.html.old และแทนที่ด้วยไฟล์ใหม่ กดปุ่มตกลงเพื่อยืนยัน",

    'bt_ftp_ctrl' => "บัญชี FTP เพิ่มเติม",
    'ftp_users_no_permission' => "คุณไม่ได้รับอนุญาตในการจัดการบัญชี FTP ของโดเมนนี้",
    'ftp_users_limit_reached' => "บัญชี FTP ถึงขีดจำกัดสูงสุดสำหรับโดเมนนี้",
    'pb__ftp_ctrl' => "การจัดการ FTP",
    'class_client__max_subftp_users' => "บัญชี FTP เพิ่มเติม",

    '__client_form_settings' => "การตั้งค่าลูกค้า",
    '__sbnet_client_keep_sbnet' => "เก็บบัญชีลูกค้าที่เกี่ยวข้องใน Presence Builder",
    '__sbnet_cant_add_more_sites' => "เกินขีดจำกัดของจำนวนไซต์ที่ลูกค้าสามารถใช้ Presence Builder แล้ว",
    '__sbnet_legend_text' => "การผสมผสาน Presence Builder",
    '__sbnet_synchronize_user_with_sbnet' => "สร้างบัญชีผู้ใช้ที่สอดคล้องกันใน Presence Builder",
    '__sbnet_client_warning_delete_sb_user' => "คุณกำลังลบบัญชีผู้ใช้ Presence Builder ที่เกี่ยวข้องกับลูกค้ารายนี้ ระบบจะลบเว็บไซต์และการตั้งค่าอื่นๆ ที่เกี่ยวข้องของผู้ใช้ทั้งหมดจากระบบ Presence Builder โดยลบความสามารถในการแก้ไขเว็บไซต์ที่มีอยู่ผ่าน Presence Builder แม้หากคุณกลับมาเปิดตัวเลือกนี้ในภายหลัง หากคุณสร้างบัญชีผู้ใช้ Presence Builder อีกในภายหลัง คุณจะต้องสร้างและตีพิมพ์เว็บไซต์ของคุณโดยเริ่มจากศูนย์ คุณต้องการจะปิดการสร้างและการตีพิมพ์เว็บไซต์ผ่าน Presence Builder หรือไม่",
    'sb__build_site_with_subdomains' => "สร้างบล็อคและอัลบั้มรูปภาพซับโดเมน",
    '__sbnet_client_dont_have_sbuser' => "ไม่สามารถสร้างหรือตีพิมพ์ไซต์โดยการใช้ Presence Builder ได้: ผู้ใช้ Presence Builder ไม่้มีอยู่จริง",

    '__component_disabled' => "ปิด Component แล้ว",

    'subdomains__physical_path_not_exist' => "มีซับโดเมนที่เชื่อมต่ออยู่กับโฟลเอร์ที่ไม่มีตัวตน",

    'dnsserver_bind_to_msdns_switching_warning' => "คำเตือน: มีเพียง 254 IP แอดเดรสแรกเท่านั้นที่มีมาสก์ /8 และ /16 ที่จัดเก็บไว้ในรายการควบคุมจะถูกทำการโยกย้าย และจะถูกย้ายแยกเป็นหลายหมายเลข IP แอดเดรส คุณต้องการดำเนินการต่อหรือไม่?",

    '__sbnet_net_framework_required_for_site' => "ไซต์ Presence Builder อาจต้องการการรองรับ ASP.NET 2.0 ในโดเมนของคุณ เราแนะนำให้เปิดใช้งาน ASP.NET 2.0 หากคุณกำลังใช้ Presence Builder อยู่",

    'subdomain_auto_create_dir' => "สร้าง physical directory ของซับโดเมน",

    'sa_trainer__unable_to_get_messages_list' => "ไม่สามารถรับรายการของข้อความในกล่องจดหมาย: %1",
    'sa_trainer__pass_doesnt_exist' => "รหัสผ่านสำหรับบัญชีเมลนี้สูญหาย",

    '__sitebuilder_error' => "เกิดข้อผิดพลาดขึ้นระหว่างกำลังเชื่อมต่อกับ Presence Builder ติดต่อผู้ให้บริการโฮสต์เพื่อขอคำแนะนำ",
    'wsb_error_user_not_exist' => "บัญชีผู้ใช้ Presence Builder นี้ไม่้มีอยู่จริง",
    'wsb_error_site_already_exist' => "มีไซต์นี้อยู่แล้วใน Presence Builder",
    'wsb_error_site_limit_reached' => "เกินขีดจำกัดของจำนวนไซต์ของ Presence Builder",
    'wsb_error_internal_error' => "เกิดข้อผิดพลาดใน Internal Presence Builder: ติดต่อผู้ให้บริการโฮสต์เพื่อขอคำแนะนำ",
    'wsb_error_user_already_exist' => "มีผู้ใช้ Presence Builder ที่มีชื่อนั้นอยู่แล้วใน Presence Builder",
    'sb_error_user_not_exist' => "ผู้ใช้ Presence Builder ไม่้มีอยู่จริง",
    'wsb_error_object_not_found' => "Presence Builder ไม่สามารถหารายการโฮสต์ที่ถูกต้องได้",

    'mg_no_mail_groups' => "ไม่มีกลุ่มเมล",

    'drweb__drweb_incoming' => 'แอนติไวรัสทำการตรวจสอบเมลขาเข้า',
    'drweb__drweb_outgoing' => 'แอนติไวรัสทำการตรวจสอบเมลขาออก',
    'drweb__disable_reason_serv' => 'เซิร์ฟเวอร์เมลไม่สนับสนุนการตั้งค่าตัวกรองของโปรแกรมป้องกันไวรัสสำหรับระดับกล่องจดหมายนี้',

    'vz_sitebuilder3_client_cant_be_created' => "ไม่สามารถสร้างบัญชีลูกค้า: ยังไม่ติดตั้ง SiteBuilder เวอร์ชั่น 3.1 หรือมากกว่า",

    'chown__client_without_sitebuilder_support' => "ไม่สามารถดำเนินการโอนการสมัครรับบริการได้: บริการ Presence Builder ไม่รวมอยู่ในแผนบริการของเจ้าของคนใหม่หรือผู้ให้บริการ",

    // new limits

    'class_client__max_odbc' => "การเชื่อมต่อ ODBC",
    'cl_perm__max_odbc' => "จำนวนสูงสุดของการเชื่อมต่อ ODBC",

    // domain aliases DNS
    'domain_alias__list_status' => 'S',
    'domain_alias__list_name' => 'ชื่อนามแฝงโดเมน',
    'domain_alias__list_ascii_name' => 'ในรูปแบบ ASCII',


    // Interface Customization Templates
    'interface_preferences' => 'การจัดการหน้าจอ',
    'pb__interface_templates' => 'การจัดการอินเทอร์เฟซ',
    'pb__interface_clients' => 'ลูกค้าที่ใช้ %1',

    // service management
    'bt_service_showall' => "แสดงทั้งหมด",
    'bt_service_hideall' => "ซ่อนทั้งหมด",
    'bt_service_start' => "เริ่ม",
    'bt_service_stop' => "หยุด",
    'bt_service_restart' => "รีสตาร์ท",
    'bt_service_disable' => "ปิด",
    'bt_service_manual' => "คู่มือการใช้งาน",
    'bt_service_auto' => "อัตโนมัติ",
    'service_startup_auto' => 'อัตโนมัติ',
    'service_startup_manual' => 'คู่มือการใช้งาน',
    'service_startup_disabled' => 'ปิด',
    'service_action_ok' => "การปฎิบัติการพร้อมด้วยการบริการ %1 เสร็จสิ้นแล้ว",
    'service_action_failed_disabled_service' => "ไม่สามารถสิ้นสุดการปฎิบัติการนี้พร้อมทั้งการบริการ %1 เนื่องจากได้ปิดการทำงานแล้ว",
    'service_action_failed_error' => "ไม่สามารถสิ้นสุดการปฎิบัติการ: %1",
    'service_group_action_ok' => "การปฎิบัติการพร้อมทั้งการบริการดังกล่าวนี้เสร็จสิ้นแล้ว: \n%1",
    'service_group_action_disabled' => "ไม่สามารถสิ้นสุดการปฎิบัติการพร้อมทั้งการบริการดังกล่าวนี้เนื่องจากได้ถูกปิดการทำงานแล้ว: \n%1",
    'service_group_action_failed' => "การรับรายละเอียดของข้อมูลผิดพลาด: \n%1 \nการปฎิบัติการนี้พร้อมทั้งการบริการแบบแยก",

    // php 4vs5
    'bt_php' => "การตั้งค่า PHP",

    // Mass mail

    'massmail__resellers_list_available_for_select' => 'ตัวแทนจำหน่ายที่มี',
    'massmail__resellers_list_selected' => 'ตัวแทนจำหน่ายที่เลือก',
    'massmail__clients_list_available_for_select' => 'ลูกค้าที่มี',
    'massmail__clients_list_selected' => 'ลูกค้าที่เลือก',
    'massmail__advanced' => 'ขั้นสูง',
    'bt_massmail_send' => 'ส่ง',
    'massmail__save_template_name' => 'บันทึกข้อความไปยังแม่แบบใหม่ที่ได้กำหนดชื่อไว้',
    'massmail__template' => 'แม่แบบ',
    'massmail__compose_mail' => 'ข้อความ',
    'massmail__from' => 'จาก',
    'massmail__to' => 'ถึง',
    'massmail__subject' => 'ชื่อเรื่อง',
    'massmail__body' => 'ข้อความตัวอักษร',
    'massmail__body_hint' => 'ใช้ <name>ตัวแปรในการป้อนชื่อผู้ใช้ลงในข้อความของคุณโดยอัตโนมัติ',
    'massmail__send_to_clients' => "ลูกค้า",
    'massmail__send_to_domainusers' => "ผู้ดูแลระบบโดเมน",
    'massmail__send_to_admins' => "ผู้ดูแล Plesk",
    'massmail_select' => 'เลือกที่อยู่',
    'massmail_showhide_selected' => "แสดง/ซ่อนที่เลือก",
    'massmail_send_all' => "ทั้งหมด",
    'massmail_send_selected' => "ที่เลือกเท่านั้น",
    'massmail_send_except' => "ทั้งหมดยกเว้นที่เลือก",
    'bt_new_mass_mail_template' => "เพิ่มแม่แบบอีเมลจำนวนมาก",
    '__mass_mail_templates_list' => "รายการแม่แบบข้อความอีเมลจำนวนมาก",
    'massmail__template_name' => 'ชื่อแม่แบบ',
    'massmail__receivers' => 'ผู้รับ',
    'massmail__created' => 'ผู้ส่ง',
    'massmail__date_created' => 'วันที่สร้าง',
    'massmail__compose' => 'ส่ง',
    'mass_mail__resellers_all' => 'ตัวแทนจำหน่ายทั้งหมด',
    'mass_mail__clients_all' => 'ลูกค้าทั้งหมเ',
    'mass_mail__domainusers_all' => 'ผู้ดูแลระบบโดเมนทั้งหมด',
    'mass_mail__resellers_selected' => 'ตัวแทนจำหน่ายที่เลือก',
    'mass_mail__clients_selected' => 'ลูกค้าที่เลือก',
    'mass_mail__domainusers_selected' => 'ผู้ดูแลระบบโดเมนที่เลือก',
    'mass_mail__resellers_except' => 'ตัวแทนจำหน่ายทั้งหมดยกเว้นทีเลือก',
    'mass_mail__clients_except' => 'ลูกค้าทั้งหมดยกเว้นที่เลือก',
    'mass_mail__domainusers_except' => 'ผู้ดูแลโดเมนทั้งหมดที่ยกเว้นไว้ได้ถูกเลือกแล้ว',
    'mass_mail__admins_all' => 'ผู้ดูแลระบบทั้งหมด',
    'massmailtemplateslist__title' => 'แม่แบบข้อความอีเมลจำนวนมาก',
    'massmail__insert_from_template' => "แทรกข้อมูลจากแม่แบบ",
    'massmail__select_template' => "เลือกแม่แบบ",
    'massmail__body_short_hint' => "(ข้อความตัวอักษรเท่านั้น)",
    'massmail__from_short_hint' => "(อีเมลหรือชื่อ)",
    'bt_insert' => "แทรก",
    'massmail__mail_send_successfully' => "ข้อความถูกส่งเรียบร้อยแล้ว",
    'massmail__mail_send_successfully_with_some_errors' => "ข้อความถูกส่งออกไปแล้ว แต่พบว่ามีความผิดพลาดเกิดขึ้นหลายประการทำให้ผู้รับบางท่านอาจยังไม่ได้รับข้อความ สำหรับข้อมูลเพิ่มเติ่ม สามารถดูได้ที่ไฟล์เข้าระบบดังกล่าว: %plesk_dir%\\admin\\logs\\send_mass_mail.log",
    'massmail__mail_send_failed' => "ข้อความยังไม่ได้ส่งไป โปรดตรวจสอบว่าได้เลือกผู้รับอย่างน้อย 1 คน และเซิร์ฟเวอร์เมลของ Plesk ทำงานอย่างถูกต้อง สำหรับข้อมูลเพิ่มเติม โปรดดูไฟล์บันทึกดังต่อไปนี้ที่ %plesk_dir%\\admin\\logs\\send_mass_mail.log",
    'massmail__template_data_inserted' => "ระบบได้ใส่ข้อมูลจากแม่แบบ %1 อย่างสมบูรณ์",
    'massmail__template_added_successfully' => "ได้บันทึกแม่แบบข้อความด้วยชื่อ %1",

    // wsb integration
    'wsb_error_sitebuilder_database_error' => "เกิดข้อผิดพลาดในฐานข้อมูลของ Presence Builder ติดต่อผู้ให้บริการโฮสต์เพื่อขอคำแนะนำ",
    'wsb_error_sitebuilder_access_denied_error' => "ไม่สามารถเข้าถึงไฟล์ได้: Presence Builder ไม่มีสิทธิในการเข้าถึงไฟล์หรือโฟลเดอร์ที่ต้องการ ติดต่อผู้ให้บริการโฮสต์เพื่อขอคำแนะนำ",
    'wsb_error_sitebuilder_connection_failed' => "ไม่สามารถเชื่อมต่อกับ Presence Builder ได้ เนื่องจากการเชื่อมต่อสูญหาย ติดต่อผู้ให้บริการโฮสต์เพื่อขอคำแนะนำ",
    'wsb_error_critical_during_operation' => "เกิดข้อผิดพลาดใน Critical Presence Builder:\n%1",
    'wsb_error_license_during_operation' => "เกิดข้อผิดพลาดในลิขสิทธิ์ของ Presence Builder:\n%1",
    'wsb_error_during_operation' => "เกิดข้อผิดพลาดใน Presence Builder:\n%1",
    'wsb_error_license_error' => "เกินขีดจำกัดของลิขสิทธิ์ของ Presence Builder แล้ว",

    // Other
    '__confrim_service_stop' => "คำเตือน! หากคุณหยุดใช้บริการ %1 Plesk อาจหยุดทำงาน คุณแน่ใจหรือไม่ว่าต้องการจะหยุดใช้บริการ %1",
    'virtualdir__name_is_reserved' => "ชื่อนี้ได้ถูกจองไว้แล้ว",
    'index_redirect_help_text' => 'คุณจะถูกเชื่อมต่อไปยังเว็บไซต์ที่ต้องการโดยอัตโนมัติ ถ้าเบราว์เซอร์ของคุณไม่รองรับการเชื่อมต่อ โปรดคลิก %1 ที่นี่ %2',
    'bt_default_settings' => "กู้คืนค่าเริ่มต้น",
    'logfiles__remove_failed' => "ไม่สามารถลบไฟล์ %1: เนื่องจากถูกล็อคโดยแอพพลิเคชั่นอื่น โปรดลองอีกครั้ง",
    'subdomain__invalid_homedirectory' => "สารบบหลักของซับโดเมนที่ระบุไม่ถูกต้อง",
    'scheduler_item__empty_filename' => "โปรดระบุไฟล์ปฏิบัติการ ที่จะปฎิบัติการ",
    'subdomains__overlapped_domain_exists' => 'มีการใช้งานซับโดเมนซ้ำกันใน DNS โซนของโดเมน %1',
    'subdomains__overlapped_domain_alias_exists' => 'มีการใช้งานซับโดเมนซ้ำกันใน DNS โซนของโดเมน %1',
    'services_action_none_selected' => 'ไม่สามารถสิ้นสุดการปฎิบัติการนี้: โปรดเลือกการบริการที่ต้องการ',
    'cl_perm__max_subftp_users' => "จำนวนสูงสุดของบัญชี FTP เพิ่มเติม",
    'login_up__access_denied_no_cp_access' => 'ไม่อนุญาตให้เข้าสู่ระบบ คุณไม่ได้รับอนุญาตให้เข้าสู่ Plesk',
    'drweb__disable_reason_admin' => "การตั้งค่าตัวกรองโปรแกรมป้องกันไวรัสในระดับกล่องจดหมายไม่ได้รับอนุญาตโดยนโยบายเซิร์ฟเวอร์",

    'webdirs__name_is_invalid' => 'ใช้เฉพาะตัวเลขและตัวอักษร ขีดล่าง และขีดในชื่อของสารบบ',
    'webdirs__physical_path_is_invalid' => 'พาธกายภาพไม่ถูกต้องหรือไม่มีอยู่',
    '__use_default' => 'ใช้ค่าเริ่มต้น',

    'webalizer_hidden_referrer__already_exist' => 'รายการดังกล่าวมีอยู่แล้ว',
    'webalizer_group_referrer__already_exist' => 'ผู้อ้างกลุ่มที่มีชื่อนั้นมีอยู่แล้ว',

    'pb__dashboard' => 'หน้าหลัก',

    'server_interface__page_title' => 'การตั้งค่าหน้าจอเซิร์ฟเวอร์',
    'server_interface__tabs_locales' => 'Locale',
    'server_interface__tabs_skins' => 'สกิน',
    'server_interface__tabs_interface_templates' => 'แม่แบบหน้าจอ',
    'bt_server_interface' => 'รายการโปรดอินเทอร์เฟซ',
    'pb__server_interface' => 'รายการโปรดอินเทอร์เฟซ',

    'bt_wizard_next' => 'ถัดไป>>',
    'bt_wizard_prev' => '<< กลับ',

    '__limit_exceeded_max_dom_server' => 'คุณสามารถโฮสต์โดเมนในเซิร์ฟเวอร์นี้ได้มากกว่านี้ เพราะว่าเกินขีดจำกัดของจำนวนโดเมนที่อนุญาตในเซิร์ฟเวอร์โดยลิขสิทธิ์แล้ว ติดต่อกับผู้ให้บริการของคุณเพื่อแก้ไขปัญหา',
    '__limit_exceeded_max_subdom_server' => 'คุณไม่สามารถโฮสต์ซับโดเมนในเซิร์ฟเวอร์นี้ได้มากกว่านี้แล้ว โปรดติดต่อผู้ให้บริการของคุณ',
    '__limit_exceeded_max_dom_aliases_server' => 'คุณไม่สามารถตั้งโดเมนนามแฝงได้อีกแล้วในเซิร์ฟเวอร์นี้ โปรดติดต่อผู้ให้บริการของคุณ',
    '__limit_exceeded_max_wu_server' => 'คุณไม่สามารถสร้างผู้ใช้เว็บได้มากกว่านี้ เพราะว่าเกินขีดจำกัดของจำนวนผู้ใช้เว็บที่อนุญาตในเซิร์ฟเวอร์โดยลิขสิทธิ์แล้ว ติดต่อกับผู้ให้บริการของคุณเพื่อแก้ไขปัญหา',
    '__limit_exceeded_max_mn_server' => 'คุณไม่สามารถสร้างบัญชีเมลได้มากกว่านี้ เพราะว่าเกินขีดจำกัดของจำนวนบัญชีเมลที่อนุญาตในเซิร์ฟเวอร์โดยลิขสิทธิ์แล้ว ติดต่อกับผู้ให้บริการของคุณเพื่อแก้ไขปัญหา',

    '__limit_exceeded_max_cl_useradmin' => 'คุณใช้งานถึงขีดจำกัดของจำนวนบัญชีลูกค้าที่กำหนดโดยรหัสลิขสิทธิ์ของคุณ (%2)',
    '__limit_exceeded_max_dom_useradmin' => 'คุณใช้งานถึงขีดจำกัดของจำนวนโดเมนที่กำหนดโดยรหัสลิขสิทธิ์ของคุณ (%2)',
    '__limit_exceeded_max_subdom_useradmin' => 'คุณใช้งานถึงขีดจำกัดของจำนวนซับโดเมนที่กำหนดโดยรหัสลิขสิทธิ์ของคุณ (%2)',
    '__limit_exceeded_max_dom_aliases_useradmin' => 'คุณใช้งานถึงขีดจำกัดของจำนวนโดเมนนามแฝงที่กำหนดโดยรหัสลิขสิทธิ์ของคุณ (%2)',
    '__limit_exceeded_disk_space_useradmin' => 'คุณไม่มีพื้นที่ดิสก์ว่างเหลือ',
    '__limit_exceeded_max_wu_useradmin' => 'คุณใช้งานถึงขีดจำกัดของจำนวนบัญชีผู้ใช้เว็บที่กำหนดโดยรหัสลิขสิทธิ์ของคุณ (%2)',
    '__limit_exceeded_max_db_useradmin' => 'คุณใช้งานถึงขีดของจำนวนฐานข้อมูลที่กำหนดโดรหัสลิขสิทธิ์ของคุณ (%2)',
    '__limit_exceeded_max_box_useradmin' => 'คุณใช้งานถึงขีดจำกัดของจำนวนกล่องจดหมายที่กำหนดโดยรหัสลิขสิทธิ์ของคุณ (%2)',
    '__limit_exceeded_max_mn_useradmin' => 'คุณใช้งานถึงขีดจำกัดของจำนวนบัญชีอีเมลที่กำหนดโดยรหัสลิขสิทธิ์ของคุณ (%2)',
    '__limit_exceeded_max_maillists_useradmin' => 'คุณใช้งานถึงขีดจำกัดของจำนวนจดหมายที่กำหนดโดยรหัสลิขสิทธิ์ของคุณ (%2)',

    '__limit_exceeded_max_dom_userclient' => 'คุณใช้งานถึงขีดจำกัดของจำนวนโดเมน (%2)',
    '__limit_exceeded_max_subdom_userclient' => 'คุณใช้งานถึงขีดจำกัดของจำนวนซับโดเมน (%2) ที่อนุญาตโดยผู้ให้บริการของคุณ',
    '__limit_exceeded_max_dom_aliases_userclient' => 'คุณใช้งานถึงขีดจำกัดของจำนวนโดเมนนามแฝง (%2)',
    '__limit_exceeded_disk_space_userclient' => 'คุณใช้พื้นที่ดิสก์ถึงขีดจำกัดการใช้ (%2)',
    '__limit_exceeded_max_traffic_userclient' => 'คุณใช้งานถึงขีดจำกัดของจำนวนการใช้แบนวิดธ์ต่อเดือน (%2)',
    '__limit_exceeded_max_wu_userclient' => 'คุณใช้งานถึงขีดจำกัดของจำนวนผู้ใช้เว็บ (%2) ที่อนุญาตโดยผู้ให้บริการของคุณ',
    '__limit_exceeded_max_db_userclient' => 'คุณใช้งานถึงขีดของจำนวนฐานข้อมูล (%2)',
    '__limit_exceeded_max_box_userclient' => 'คุณใช้งานถึงขีดจำกัดของจำนวนกล่องจดหมาย (%2)',
    '__limit_exceeded_max_maillists_userclient' => 'คุณใช้งานถึงขีดจำกัดของจำนวนจดหมาย (%2)',
    '__limit_exceeded_expiration_userclient' => 'บัญชีของหมดอายุในวัน %2',

    '__limit_exceeded_max_subdom_userdomain' => 'คุณใช้งานถึงขีดจำกัดของจำนวนซับโดเมน (%2) ที่อนุญาตโดยผู้ให้บริการของคุณ',
    '__limit_exceeded_max_dom_aliases_userdomain' => 'คุณใช้งานถึงขีดจำกัดของจำนวนโดเมนนามแฝง (%2)',
    '__limit_exceeded_disk_space_userdomain' => 'คุณใช้พื้นที่ดิสก์ถึงขีดจำกัดการใช้ (%2)',
    '__limit_exceeded_max_traffic_userdomain' => 'คุณใช้งานถึงขีดจำกัดของจำนวนการใช้แบนวิดธ์ต่อเดือน (%2)',
    '__limit_exceeded_max_wu_userdomain' => 'คุณใช้งานถึงขีดจำกัดของจำนวนลัญชีผู้ใช้เว็บ (%2)',
    '__limit_exceeded_max_db_userdomain' => 'คุณใช้งานถึงขีดของจำนวนฐานข้อมูล (%2)',
    '__limit_exceeded_max_box_userdomain' => 'คุณใช้งานถึงขีดจำกัดของจำนวนกล่องจดหมาย (%2)',
    '__limit_exceeded_max_maillists_userdomain' => 'คุณใช้งานถึงขีดจำกัดของจำนวนจดหมาย (%2)',
    '__limit_exceeded_expiration_userdomain' => 'บัญชีของหมดอายุในวัน %2',

    'mmt__to_none' => 'ไม่มี',
    'mmt__to_admin' => 'ผู้ดูแลระบบ',
    'mmt__to_resellers_all' => 'ตัวแทนจำหน่ายทั้งหมด',
    'mmt__to_resellers_select' => 'ตัวแทนจำหน่ายที่เลือก',
    'mmt__to_resellers_select__available' => 'ตัวแทนจำหน่ายที่มี',
    'mmt__to_resellers_except' => 'ตัวแทนจำหน่ายทั้งหมดยกเว้นทีเลือก',
    'mmt__to_clients_all' => 'ลูกค้าทั้งหมเ',
    'mmt__to_clients_select' => 'ลูกค้าที่เลือก',
    'mmt__to_clients_select__available' => 'ลูกค้าที่มี',
    'mmt__to_clients_except' => 'ลูกค้าทั้งหมดยกเว้นที่เลือก',

    'mmt__unable_send_empty_selection' => 'ไม่สามารถส่งเมลรวมได้ ไม่มีที่อยู่อีเมลที่เลือกไว้',
    'mmt__unable_send_to__' => 'ไม่สามารถส่งเวลจำนวนมากไปยัง:',
    'mmt__unable_send_to_email' => '%1 <%2>',

    'sapp_error_validation_not_found' => 'ไม่สามารถตรวจสอบความถูกต้องของแอพพลิเคชั่นเว็บได้ เนื่องจากไม่พบไฟลืที่จำเป็น (%1) ให้ติดต่อตัวแทนฝ่ายเทคนิคสำหรับความช่วยเหลือ',
    'sapp_error_validation_spec_failed' => 'แอพพลิเคชั่นเว็บที่อัพโหลดไม่สอดคล้องกับลักษณะจำเพาะของ AppPacks: %1',
    'sapp_error_validation_register' => 'ไม่สามารถลงทะเบียนแอพพลิเคชั่นเว็บที่อยู่ในสารบบ "%1": %2 ได้ คุณควรลบแอพพลิเคชั่นเว็บจากเซิร์ฟเวอร์ เนื่องจากอาจทำให้เกิดการทำงานที่ไม่ถูกต้องได้',

    'sapp__install_failed' => 'การติดตั้งแอพพลิเคชั่นเว็บล้มเหลว: %1',
    'sapp__install_res_failed' => 'ไม่สามารถสร้างทรัพยากรที่ต้องการได้',

    'server_preferences__subdomains_blog_and_photo' => 'สร้างบล็อคและอัลบั้มรูปภาพของซับโดเมนโดยค่ามาตรฐาน',
    'plesk_key__blog_and_photo' => 'ความสามารถในการจัดการค่าเริ่มต้นในการสร้างบล็อกและกล่องกาเครื่องหมายของซับโดเมนของคลังภาพ',
    'ip_ctrl__cannot_make_exclusive_ip_with_more_than_one_client' => 'ไม่สามารถเปลี่ยนประเภทของ IP แอดเดรสไปยังแอดเดรสแบบเฉพาะได้ เพราะมีผู้ใช้มากกว่า 1 ราย',

    // 8.1.1

    '__write_modify_warning' => 'เลือกการเขียน/การปรับตั้งค่าเพิ่มเติมของการยินยอมเข้าใช้งานอาจจะทำให้แอพพลิเคชั่นเว็บบางตัวใช้งานได้ดี แต่ก็ทำให้เกิดความเสี่ยงสูงในเรื่องความปลอดภัยด้วยเช่นกัน',
    '__write_modify_subdomain_warning' => 'เลือกการเขียน/การปรับตั้งค่าเพิ่มเติมของการยินยอมเข้าใช้งานอาจจะทำให้แอพพลิเคชั่นเว็บบางตัวใช้งานได้ดี แต่ก็ทำให้เกิดความเสี่ยงสูงในเรื่องความปลอดภัยด้วยเช่นกัน',

    'phosting__php_incorrect_version_used' => "พบปัญหาเกิดขึ้นกับเวอร์ชั่นของ PHP.เพิ่อแก้ไขปํญหานี้ คลิกเลือกเครื่องหมายถูกที่กล่องการเครื่องหมายที่เป็นเวอร์ชั่น PHP ที่ต้องการข้างล่างนี้ และคลิกตกลง เพื่อปิดการทำงานของ PHP บนโดเมนนี้ คลิกตกลงโดยไม่ต้องคลิกเครื่องหมายถูกที่เวอร์ชั่นของ PHP",
    'fp__mail_preferences' => 'การตั้งค่าเมล',

    'mail__invalid_white_pattern' => 'ค่าที่ระบุไม่ถูกต้อง ใช้รูปแบบดังต่อไปนี้: mail@example.com สำหรับที่อยู่อีเมล example.com สำหรับโดเมน',
    'mail__invalid_black_pattern' => 'ค่าที่ระบุไม่ถูกต้อง ใช้รูปแบบดังต่อไปนี้: mail@example.com สำหรับที่อยู่อีเมล example.com สำหรับโดเมน',

    'resp_edit__reply_as_html' => 'ถูกส่งไปที่ HTML',
    'exception__path_very_long' => "พาธยาวเกินไป โปรดตรวจสอบว่ามีตัวอักษรน้่อยว่า %1 ในพาธ",

    // 8.2


    //SAPP
    'sapp_on' => 'เปิด',
    'sapp_off' => 'ปิด',
    'sapp_directive_aspect' => 'ที่จำเป็น',
    'sapp_databases_num' => 'ฐานข้อมูล',
    'sapp_db_required' => 'ที่จำเป็น',
    'sapp_Required' => 'ที่จำเป็น',
    'sapp_Variant' => 'ตัวแปร',
    'sapp_db_id' => 'หมายเลขฐานข้อมูล',
    'sapp_db_id_type' => 'ประเภท DB (id: %1)',
    'sapp_db_id_min_version' => 'เวอร์ชั่น DB (id: %1) min',
    'sapp_db_id_table_prefix' => 'ตารางคำนำหน้า DB (id: %1)',
    'sapp_Default' => 'ค่าเริ่มต้น',
    'sapp_apache_mod_req' => 'โมดูล Apache',
    'sapp_dbtype_not_installed' => 'ยังไม่ได้ติดตั้ง',
    'sapp_apache_mod_not_installed' => 'ยังไม่ได้ติดตั้ง',
    'sapp__value_error_empty' => 'ไม่อนุญาตให้เว้นค่าว่าง',
    'sapp_error_invalid_type' => 'แอพพลิเคชั่น "%1" ไม่รองรับการกระทำที่จำเป็น',
    'sapp_error_unknown_app_type' => 'ประเภทของแอพพลิเคชั่นที่ไม่รองรับ: %1',
    'sapp__ssl_text' => 'ติดตั้งแอพพลิเคชั่นไปยังโฮสต์เสมือน "http://" or "https://"?',
    'sapp__app_to_upgrade' => 'อัพเกรดแอพพลิเคชั่นแล้ว',
    'sapp__upgrade_apps_title' => 'อัพเกรดแอพพลิเคชั่น',
    'sapp__upgrade_to_ver' => 'อัพเกรดไปยังเวอร์ชั่น',
    'sapp__choose_pkg_ver' => 'เลือกแพคเกจ...',
    'sapp__pkg_cant_upgrade_pkg' => 'ไม่สามารถใช้แพคเกจ "%1" สำหรับการอัพเกรดแอพพลิเคชั่น "%2"',
    'sapp__app_ugrade_error' => 'ไม่สามารถอัพเกรดแอพพลิเคชั่น %1 โปรดติดต่อผู้ดูแลระบบของคุณ',
    'sapp__no_suitable_db_found' => 'ไม่พบฐานข่อมูลที่เหมาะสม',
    'sapp__upgrade_success' =>  'อัพเกรดแอพพลิเคชั่นสำเร็จแล้ว',
    'sapp__pkg_info_changelog' => 'ประวัติของการเปลี่ยน',
    'sapp_requirement_legend' => 'คุณสมบัติโฮสติ้งที่ต้องการโดยแอพพลิเคชั่น',

    // other
    'bt_apply' => 'นำไปใช้',
    'mn_edit__add_alias_if_mailbox_disabled' => 'เพื่อสร้างเมลนามแฝง คุณควรเปิดบัญชีเมลนี้ก่อน คุณต้องการเปิดกล่องจดหมายหรือไม่?',
    'mn_edit__mailbox_disable_if_has_alias' => 'การปิดใช้งานกล่องจดหมายจะส่งผลให้เมลนามแฝงถูกลบ คุณต้องการปิดใช้งานกล่องจดหมายหรือไม่?',
    'antivirus__disable_reason_install' => 'คุณไม่สามารถจัดการกับแอนติไวรัสได้ เพราะยังไม่ได้ติดตั้ง',
    'antivirus__disable_reason_key' => 'คุณไม่สามารถจัดการกับแอนติไวรัสได้ เพราะยังไม่ได้เปิดใช้งานโดยรหัสลิขสิทธิ์ที่ถูกต้อง',
    'antivirus__disable_reason_deny_personal_settings' => 'คุณไม่สามารถจัดการกับการป้องกันไวรัสได้ เพราะนโยบายของเซิร์ฟเวอร์ห้ามการตั้งค่าป้องกันไวรัสส่วนบุคคล',
    'change_foreign_user_password' => 'เปลี่ยนรหัสผ่าน',
    'change_foreign_user_password_hint' => "ผู้ใช้ที่ไม่ใช่เจ้าของแอพพลิเคชั่นนี้ ให้คลิกลิงก์เพื่อไปยังแอพพลิเคชั่นอื่น และเปลี่ยนรหัสผู้ใช้ที่นั่น เพื่อทำการเช่นนั้น คุณต้องมีแอพพลิเคชั่นที่ถูกต้องเหมาะสม",
    'cf_url_text' => 'JDBC URL',
    'cf_sendStringParametersAsUnicode_text' => 'รูปแบบสตริง',
    'lang_unknown' => 'ภาษาที่ไม่รู้จัก',
    'pb__cl_ed' => 'รายละเอียดลูกค้า',
    'pb__actionlog' => 'บันทึกการทำงาน',
    'pb__cl_limits' => 'ขีดจำกัดลูกค้า',
    'pb__edit' => 'แก้ไข',
    'pb__subdom_edit' => 'การตั้งค่าโฮสติ้ง',

    // NEW 8.3 FEATURES

    'backup_mail_content' => 'สำรองข้อมูลของกล่องจดหมาย',

    'maillist_import_result' => "\nจำนวนสุทธิของที่อยู่อีเมลในไฟล์: %1\nจำนวนของที่อยู่อีเมลที่ส่งออกไป: %2\nจำนวนของที่อยู่อีเมลที่มีอยู่แล้ว: %3\nจำนวนของที่อยู่อีเมลซ้ำซ้อนในไฟล์ที่ระบุ: %4\nจำนวนของที่อยู่อีเมลที่ไม่ถูกต้องในไฟล์: %5",
    'maillist_import_error' => 'ไม่สามารถนำรายการที่อยู่อีเมลเข้ามาได้',

    //  spaw

    'spaw__unable_to_edit_no_body' => "ไฟล์ที่คุณเลือกอาจว่างเปล่าหรือไม่มีเอกสาร HTML ที่ถูกต้องในการเข้ารหัสที่เลือกไว้ โปรดเลือกการเข้ารหัสที่ถูกต้องหรือเพิ่มเนื้อหาไปยังไฟล์",

    'dom_pref__external_mail_srv' => "โอนไปยังเซิร์ฟเวอร์เมลภายนอกด้วย IP แอดเดรส:",
    'mn_edit__store_messages' => 'กล่องจดหมาย',

    // aps

    'sapp__before_upgrade_notice' => 'แนะนำให้ทำการสำรองแอพพลิเคชั่นและข้อมูลผู้ใช้ก่อนเริ่มต้นกระบวนการอัพเกรด',
    'sapp__application_properties' => 'คุณสมบัติของแอพพลิเคชั่น',
    'sapp__application_root_descr' => 'หน้าหลักของแอพพิลเคชั่น',

    'sapp__aps_license_invalid_id' => 'รหัสลิขสิทธิ์มีหมายเลขไม่ถูกต้อง: %1',
    'sapp__aps_lic_key_alredy_exists' => 'มีลิขสิทธิ์รหัส %1 อยู่แล้วในฐานข้อมูล',
    'sapp__aps_lic_del_used' => 'ไม่สามารถลบรหัสลิขสิทธิ์ เนื่องจากมีการใช้รหัสลิขสิทธิ์จากแอพพลิเคชั่นที่ติดตั้งไว้แล้ว',
    'sapp__aps_lic_del_unknown' => 'ไม่สามารถลบรหัสลิขสิทธิ์: %1',
    'sapp__aps_cappi_duplicate' => "แอพพลิเคชั่นนี้อยู่ในกลุ่มแอพพลิเคชั่นของลูกค้าแล้ว",
    'sapp__appi_not_shared_no_install' => "ไม่มีแอพพลิเคชั่นนั้นในกลุ่มแอพพลิเคชั่นของลูกค้า หากคุณต้องการถอนการติดตั้งแอพพลิเคชั่นในไซต์ คุณต้องเพิ่มแอพพลิเคชั่นนี้ไปยังกลุ่มแอพพลิเคชั่นของลูกค้าก่อน",
    'sapp__appi_shared_not_client' => "ไม่มีแอพพลิเคชั่นนั้นในกลุ่มแอพพลิเคชั่นของลูกค้า หากคุณต้องการอัพเกรดแอพพลิเคชั่นให้เป็นเวอร์ชั่นที่ระบุ คุณต้องเพิ่มแอพพลิเคชั่นเวอร์ชั่นนี้ไปยังกลุ่มแอพพลิเคชั่นของลูกค้าก่อน",
    'sapp__apply_license_script_not_found' => 'ไม่สามารถค้นหาบทคำสั่ง "apply-license" สำหรับแอพพลิเคชั่นนเว็บนี้',
    'sapp__unable_to_activate_key' => 'เกิดข้อผิดพลาดขึ้นระหว่างความพยายามในการเปิดการใช้งานรหัสลิขสิทธิ์: %1',
    'sapp__unable_to_delete_ai_instances_exists' => 'มีการติดตั้งแอพพลิเคชั่นเว็บที่ต้องการการแสดงตัวของแอพพลเคชั่นเว็บนี้ในระบบ',
    'sapp__unable_to_delete_ai_in_pool' => 'แอพพลิเคชั่นนี้ยังอยู่ในกลุ่มแอพพลิเคชั่นของลูกค้า หากคุณต้องการลบแอพพลิเคชั่นนี้ คุณต้องลบออกจากกลุ่มแอพพลิเคชั่นของลูกค้าทั้งหมด หรือลบออกไปโดยไม่คิดค่าใช้จ่าย',
    'sapp__unable_to_delete_app_template' => 'ไม่สามารถลบแอพพลิเคชั่น #%1: %2',
    'sapp__limit_exceeded_client' => 'คุณถึงขีดจำกัดของจำนวนที่คุณสามารถติดตั้งแอพพลิเคชั่นเว็บ (%2)',


    // atis module

    '_week_on' => 'อยู่ในสัปห์ดาห์',
    '__week_first' => 'แรก',
    '__week_second' => 'ลำดับที่สอง',
    '__week_third' => 'ลำดับที่สาม',
    '__week_fourth' => 'ลำดับที่สี่',
    '__week_last' => 'สุดท้าย',
    '__not_started' => 'กำลังรอ',
    '__started' => 'กำลังทำงาน',
    '__cancel_pending' => 'กำลังยกเลิก',
    '__canceled' => 'ยกเลิกแล้ว',
    '__error' => 'ผิดพลาด',
    '__done' => 'เสร็จสิ้น',

    '__php_cgi_handler' => 'แอพพลิเคชั่น CGI',
    '__php_isapi_handler' => 'การขยาย ISAPI',
    '__php_fastcgi_handler' => 'แอพพลิเคชั่น FastCGI',
    '__php_module_handler' => 'mod_php',
    '__php_run_as' => 'ใช้งานในฐานะ',

    'cf_dbfolder_text' =>'แฟ้มเก็บฐานข้อมูล',
    'cf_isnewdb_text' => 'สร้างฐานข้อมูล',
    'cf_isnewdb_title' => 'เลือกกล่องเครื่องหมาย หากต้องสร้างฐานข้อมูล',

    'pb__site_apps_upgrade' => 'การอัพเกรดแอพพลิเคชั่นเว็บ',

    'detach' => 'ยุติการเชื่อมต่อ',
    'preferences' => "เปลี่ยนรหัสผ่าน",

    'toolsbar__switch_user?' => "คุณแน่ใจหรือว่าต้องการเข้าสู่ระบบด้วยบัญชีผู้ใช้อื่น?",
    '__aps_left' => 'การติดตั้งที่เหลือ',
    'aps__license_key' => 'รหัสลิขสิทธิ์',
    'aps__download_code' => 'ดาวน์โหลดรหัสลิขสืทธิ์และรหัสเปิดการใช้งาน',
    'aps__license_key_hint' => 'กู้คืนจากเซิร์ฟเวอร์ที่ให้การอนุญาตโดยใช้รหัสเปืดการใข้งาน',
    'aps__database_not_available' => 'ไม่สามารถเลือกได้ โปรดตรวจสอบโดเมนหรือขีดจำกัดของลูกค้า',
    'aps__yes' => 'ใช่',
    'aps__no' => 'ไม่',
    '__click_to_enlarge' => 'คลิกเพื่อขยาย',
    'site_apps__back_to_list' => 'กลับไปยังรายการ',
    'sapp__pkg_info_installation_requirements' => 'ความต้องการในการติดตั้ง',
    '__close_window' => 'ปิด',

    //SAPP END

    'skin_info__already_default' => 'มีการตั้งสกินนี้เป็นหนึ่งในค่าเริ่มต้นแล้ว',

    //move this to other file after splitting drweb to module
    'drweb:virus_filter_full_name' => 'โปรแกรมป้องกันไวรัสระดับพรีเมี่ยมของ Plesk',
    'drweb:properties_page_title' => 'การตั้งค่าโปรแกรมป้องกันไวรัสระดับพรีเมี่ยมของ Plesk สำหรับ %1',
    'drweb:properties_legend' => 'การตั้งค่า',
    'drweb:status' => 'ทำการตรวจสอบเมลเพื่อหาไวรัส',

    // sb integration
    'sitebuilder_wizard' => 'Presence Builder Wizard',
    'dom_site_builder' => 'คลิกเพื่อเปิด Presence Builder Wizard',
    'sb_plesk_admin_url' => 'URL ของเซิร์ฟเวอร์ Presence Builder ตรวจสอบว่าที่อยู่นี้จะแยกไปยัง DNS อย่างถูกต้อง',
    'sb_plesk_admin_login' => 'ชื่อผู้ใช้สำหรับการเข้าระบบผู้ดูแลเซิร์ฟเวอร์ไปยัง Presence Builder',
    'sb_plesk_admin_password' => 'รหัสผ่านของผู้ดูแลระบบ',
    'sb_sitebuilder_preferences' => 'หลักฐานของผู้ดูแลของ Presence Builder',
    'sb__server' => 'ความชอบของผู้ดูแลระบบ Presence Builder',
    'sb__sitebuilder_support' => 'Presence Builder Support',
    'sb_keep_sb_user' => 'เก็บบัญชีลูกค้าที่เกี่ยวข้องใน Presence Builder',
    'sb_create_sb_user' => 'สร้างบัญชีผู้ใช้ที่สอดคล้องกันใน Presence Builder',
    'sb__build_site_using_sitebuilder' => "สร้างเว็บไซต์โดยใช้ Presence Builder",
    'sb_no_current_sb_server_set' => 'ยังไม่ได้ตั้งค่าการเชื่อมต่อไปยัง Presence Builder: คุณต้องเพิ่มบันทึก A ในแม่แบบ DNS โซน ซึ่งจะส่งตรงไปยังเซิร์ฟเวอร์ของ Presence Builder',
    'sb_unable_update_sb_server_sb_return_message' => "ไม่สามารถเรียกคืนข้อมูลจากระบบ Presence Builder ได้:\n%1",
    'sb_unable_connect_sb_wrong_con_params' => "ไม่สามารถเชื่อมต่อไปยัง Presence Builder ได้: ชื่อผู้ใช้หรือรหัสผ่านไม่ถูกต้อง",
    'sb_init_sb_manager' => "กำลังกำหนดค่าเริ่มต้นของตัวจัดการ Presence Builder %1",
    'sb_err_couldnt_connect_sb' => "การเชื่อมต่อกับระบบ Presence Builder ล้มเหลว",
    'sb_err_client_dont_have_sbuser' => "ลูกค้ารายนี้ไม่มีบัญชีผู้ใช้ใน Presence Builder",
    'sb_err_sitebuilder_not_configured' => "ยังไม่ได้ตั้งค่า Presence Builder",
    'sb_err_you_dont_have_sbaccount' => "การอนุญาตให้คุณเข้า Presence Builder ล้มเหลว",
    'sb_error_critical_during_operation' => "ข้อผิดพลาดที่เกิดขึ้นใน Presence Builder มีดังนี้:\n%1",
    'sb_err_sso_is_not_enabled' => "ไม่ได้เปิดการสนับสนุนการลงชื่อเข้าใช้ครั้งเดียวใน Plesk",

    'warning__super_zone_exist' => "สร้างโซน %1 แล้ว แต่อย่างไรก็ตาม ชื่อโซนนี้เป็นโซนย่อยของโซน %2 ที่มีอยู่ซึ่งเป็นของผู้ใช้อืjน %3 ซึ่งเป็นเรื่องที่เป็นไปได้ แต่โปรดตรวจสอบให้แน่ใจว่า คุณได้เลือกบัญชีผู้ใช้ที่ถูกต้อง",
    'error__super_zone_exist' => "ไม่สามารถสร้าง DNS โซน เนื่องจากซุปเปอร์โซนเป็นของผู้ใช้อื่น",

    'locales__files_not_exits' => 'ไม่สามารถเปลี่ยนแปลง Locale : ไม่มีไฟล์ชุดภาษาของหน้าจอที่ระบุในระบบ',
    'locales__unavailable' => 'ไม่สามารถเปลี่ยน Locale: ไม่มีไฟล์ชุดภาษาของหน้าจอ',

    // DB BU

    'pb__dbbackup_list' => 'ไฟล์สำรองของฐานข้อมูล',
    // server
    'dbbackup__server_backup_settings' => 'การสำรองข้อมูล',
    'dbbackup__network_temp_dir' => 'สารบบเครือข่ายชั่วคราว',
    'dbbackup__network_user' => 'ชื่อผู้ใช้',
    'dbbackup__network_pass' => 'รหัสผ่าน',
    // domain
    'dbbackup__add_database_legend' => 'กู้คืนการสำรองฐานข้อมูล',
    'dbbackup__add_database_restore' => 'กู้คืนฐานข้อมูลจากไฟล์สำรอง',
    'dbbackup__add_database_file' => 'ไฟล์สำรองของฐานข้อมูล',
    'dbbackup__add_database_user' => 'ชื่อผู้ใช้งานเริ่มต้น',
    'dbbackup__add_database_pass' => 'รหัสผ่านผู้ใช้งานเริ่มต้น',
    'dbbackup__add_database_pass2' => 'การยืนยันรหัสผ่านเริ่มต้นของผู้ใช้งาน',

    'bt_dbbackup_now' => 'สำรองข้อมูล',

    'bt_repair' => 'ซ่อมแซม',

    'dbbackup__mssql_dump_upload_not_allowed' => 'ผู้ให้บริการโฮสติ้งห้ามการอัพโหลฐานข้อมูลเซิร์ฟเวอร์ SQL',

    // APS categories

    'cf_invalid_password' => 'รหัสผ่านไม่ควรยาวเกิน 16 ตัวอักษร',
    'cf_invalid_description_length' => 'การอธิบายนี้ไม่ควรมีเครื่องหมายยาวเกิน 256 ตัว',
    'ip_addr__ip_used_by_external_mail_server' => 'IP address %1 ได้ถูกใช้งานโดยเซิร์ฟเวอร์เมลภายนอกแล้ว',

    // 8.4.1

    '__ftp_login_is_invalid' => 'ชื่อผู้ใช้บัญชี FTP และรหัสผ่านไม่ถูกต้อง โปรดระบุหลักฐานผู้ใช้ FTP ที่ถูกต้อง',

    // 8.6

    'dns__dns_serial_update_limit_warning' => 'การเปลี่ยนหมายเลขซีเรียลเกินขีดจำกัด ไม่สามารถดำเนินการเปลี่ยนแปลง DNS โซน วันนี้ได้',
    'dns__zone_apply_changes' => 'การเปลี่ยนแปลงที่ทำไปยังรายการ DNS ยังไม่ได้รับการบันทึก การเปลี่ยนแปลงที่ทำลงไปจะได้รับการเน้นด้านล่าง คลิกอัพเดทเพื่อนำการเปลี่ยนแปลงไปใช้กับ DNS โซน หรือคลิกกลับสู่สภาพเดิมเพื่อละทิ้งการเปลี่ยนแปลง',
    'dns__update_dns_zone' => 'คลิกเพื่อบันทึกการเปลี่ยนแปลงที่ทำกับรายการ DNS',
    'dns__revert_dns_zone' => 'คลิกเพื่อยกเลิกการเปลี่ยนแปลงที่ได้ทำไปยังรายการ DNS',
    'bt_revert' => 'คืนค่าเดิม',
    'dns__dns_zone_has_beed_updated' => 'การเปลี่ยนแปลงที่ทำไปยังรายการ DNS ได้รับการบันทึก',
    'dns__dns_zone_has_beed_reverted' => 'การเปลี่ยนแปลงที่ทำไปยังรายการ DNS ได้รับการยกเลิก',
    'db__nondefault_server_not_allowed' => 'ไม่อนุญาตให้ใช้เซิร์ฟเวอร์ฐานข้อมูลที่ไม่ใช่ค่าเริ่มต้น',


    //// UI POINTER CAPTIONS START HERE
    ////
    // *** The strings below have been generated automatically from @@CAPTION directives.

    'ui__client__description' => 'บัญชีลูกค้า %1 และโดเมน',
    'ui__client__disabled-warning' => 'บัญชีของลูกค้า %1 ถูกระงับ',
    'ui__client__none-available' => 'ไม่มีบัญชีลูกค้าที่ตั้งค่าแล้ว',
    'ui__client__short-title' => '%1',
    'ui__client__title' => 'ลูกค้า %1',
    'ui__client_self__description' => 'รายการโดเมนของฉัน',
    'ui__client_self__short-title' => 'โดเมนของฉัน',
    'ui__client_self__title' => 'โดเมนของฉัน',


    'site_apps__non_removable' => 'รายการที่ไม่สามารถลบได้',
    'site_apps__non_removable_items' => 'ไม่สามารถลบแอพพลิคชั่นเว็บดังต่อไปนี้ได้:',

    'ui__client/custom-buttons/custom-button__none-available' => 'ไม่มีปุ่มที่ตั้งค่าเอง',
    'ui__client/custom-buttons/custom-button__none-available__1' => 'ไม่มีปุ่มตั้งค่าในแผงการควบคุมลูกค้าของลูกค้า %1',

    'ui__client/custom-buttons/custom-button/delete__description' => 'ลบปุ่ม %1',
    'ui__client/custom-buttons/custom-button/delete__short-title' => 'ลบ',
    'ui__client/custom-buttons/custom-button/delete__title' => 'ลบปุ่ม %1',
    'ui__client/custom-buttons/custom-button/delete_multi__description' => 'ลบปุ่มแบบกำหนดเองจากแผงการจัดการลูกค้าของลูกค้า',
    'ui__client/custom-buttons/custom-button/delete_multi__short-title' => 'ลบ',
    'ui__client/custom-buttons/custom-button/delete_multi__title' => 'ลบปุ่มที่ตั้งค่าเอง',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard-title' => 'ลบปุ่ม',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard__1_unknown' => 'เลือกลูกค้าซึ่งคุณต้องการลบปุ่มที่ตั้งค่าเอง และคลิกถัดไป >>',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard__3_multi' => 'เลือกปุ่มที่คุณต้องการลบ และคลิกถัดไป >>',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard__4_multi' => 'ยืนยันการลบปุ่มโดยการเลือกช่องกาเครื่องหมายบนหน้าจอนี้ และจากนั้นคลิกเสร็จสิ้น',
    'ui__client/custom-buttons/custom-button/delete_unknown__description' => 'ลบปุ่มแบบกำหนดเองจากแผงการจัดการลูกค้าของลูกค้า',
    'ui__client/custom-buttons/custom-button/delete_unknown__short-title' => 'ลบ',
    'ui__client/custom-buttons/custom-button/delete_unknown__title' => 'ลบปุ่มที่ตั้งค่าเอง',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard-title' => 'ลบปุ่มที่ตั้งค่าเอง',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard__1_unknown' => 'เลือกลูกค้าซึ่งคุณต้องการลบปุ่มที่ตั้งค่าเอง และคลิกถัดไป >>',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard__3_unknown' => 'เลือกปุ่มที่ตั้งค่าเองที่คุณต้องการลบ และคลิกถัดไป >>',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard__4' => 'ยืนยันการลบปุ่มที่ตั้งค่าเองโดยการเลือกช่องกาเครื่องหมายบนหน้าจอนี้ และจากนั้นคลิกเสร็จสิ้น',

    'ui__client/custom-buttons/custom-button/properties__description' => 'แก้ไขคุณสมบัติของปุ่มที่ตั้งค่าเองระดับลูกค้า %1',
    'ui__client/custom-buttons/custom-button/properties__short-title' => 'การตั้งค่า',
    'ui__client/custom-buttons/custom-button/properties__title' => 'แก้ไขปุ่มที่ตั้งค่าเองของลูกค้า%1',
    'ui__client/custom-buttons/custom-button/properties_new__wizard-title' => 'เพิ่มปุ่มที่ตั้งค่าเอง',
    'ui__client/custom-buttons/custom-button/properties_new__wizard__1_unknown' => 'เลือกลูกค้าที่มีแผงการควบคุมลูกค้าที่คุณต้องการสร้างปุ่มตั้งค่าให้ และคลิกถัดไป >>',
    'ui__client/custom-buttons/custom-button/properties_new__wizard__4_new' => 'คลิกเสร็จสิ้นเพื่อสร้างปุ่ม',
    'ui__client/custom-buttons/custom-button/properties_unknown__description' => 'เปลี่ยนคุณสมบัติของปุ่มในแผงการควบคุมลูกค้าของลูกค้า',
    'ui__client/custom-buttons/custom-button/properties_unknown__short-title' => 'คุณสมบัติ',
    'ui__client/custom-buttons/custom-button/properties_unknown__title' => 'เปลี่ยนคุณสมบัติของปุ่มในแผงการควบคุมลูกค้าของลูกค้า',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard-title' => 'เปลี่ยนคุณสมบัติของปุ่มที่ตั้งค่าเอง',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard__1_unknown' => 'เลือกลูกค้าซึ่งคุณต้องการเปลี่ยนปุ่มที่ตั้งค่าเอง และคลิกถัดไป >>',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard__3_unknown' => 'เลือกปุ่มที่ตั้งค่าเองที่คุณต้องการแก้ไข และคลิกถัดไป >>',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard__4' => 'เมื่อทำการแก้ไขคุณสมบัติของปุ่มเรียบร้อยแล้ว ให้คลิกเสร็จสิ้นเพื่อนำการเปลี่ยนแปลงไปใช้ และออกจากโปรแกรมช่วยติดตั้ง',

    'ui__client/custom-buttons/custom-button/toggle_private__description' => 'ทำให้ลูกค้าของคุณไม่สามารถใช้ปุ่ม %1 ได้',
    'ui__client/custom-buttons/custom-button/toggle_private__short-title' => 'ทำให้ลูกค้าของคุณไม่สามารถใช้ได้',
    'ui__client/custom-buttons/custom-button/toggle_private__title' => 'ทำให้ลูกค้าของคุณไม่สามารถใช้ปุ่ม %1 ได้',
    'ui__client/custom-buttons/custom-button/toggle_public__description' => 'ทำให้ผู้ใช้ของลูกค้าเห็นปุ่ม %1',
    'ui__client/custom-buttons/custom-button/toggle_public__short-title' => 'ทำให้ลูกค้าของคุณสามารถใช้ได้',
    'ui__client/custom-buttons/custom-button/toggle_public__title' => 'ทำให้ผู้ใช้ของลูกค้าเห็นปุ่ม %1',
    'ui__client/custom-buttons/custom-button/toggle_unknown__description' => 'ทำให้ลูกค้าของคุณสามารถใช้/ไม่สามารถใช้ปุ่มที่ตั้งค่าเองได้',
    'ui__client/custom-buttons/custom-button/toggle_unknown__short-title' => 'มี/ไม่มีให้ลูกค้าของคุณ',
    'ui__client/custom-buttons/custom-button/toggle_unknown__title' => 'ทำให้ลูกค้าของคุณสามารถใช้/ไม่สามารถใช้ปุ่มที่ตั้งค่าเองได้',
    'ui__client/custom-buttons/custom-button/toggle_unknown__wizard-title' => 'ทำให้ลูกค้าของคุณสามารถใช้/ไม่สามารถใช้ปุ่มที่ตั้งค่าเองได้',
    'ui__client/custom-buttons/custom-button/toggle_unknown__wizard__1_unknown' => 'เลือกลูกค้าที่คุณต้องการให้ผู้ใช้ของลูกค้าสามารถใช้หรือไม่สามารถใช่ปุ่มที่กำหดเองได้ และคลิกถัดไป >>',
    'ui__client/custom-buttons/custom-button/toggle_unknown__wizard__3_unknown' => 'เลือกปุ่มที่ตั้งค่าเองที่คุณต้องการทำให้ลูกค้าของคุณสามารถใช้หรือไม่สามารถใช้ปุ่มได้ และคลิกถัดไป >>',

    'ui__client/domain__description' => 'จัดกการโดเมน %1',
    'ui__client/domain__disabled-warning' => 'ระงับโดเมน %1 แล้ว',
    'ui__client/domain__none-available' => 'คุณไม่มีโดเมน',
    'ui__client/domain__none-available__1' => 'บัญชีของ %1 ไม่มีโดเมน',
    'ui__client/domain__none-available__2' => 'บัญชีของ %1 ไม่มีโดเมน',
    'ui__client/domain__short-title' => '%1',
    'ui__client/domain__title' => 'โดเมน %1',
    'ui__client/domain_self__description' => 'จัดการกับโดเมนของคุณ',
    'ui__client/domain_self__disabled-warning' => 'ระงับโดเมนของคุณแล้ว',
    'ui__client/domain_self__quick-search' => 'โดเมนของฉัน',
    'ui__client/domain_self__short-title' => 'โดเมนของฉัน',
    'ui__client/domain_self__title' => 'โดเมนของฉัน',

    'ui__client/domain/custom-buttons/custom-button__none-available' => 'ไม่มีปุ่มแบบกำหนดเองในแผงการจัดการลูกค้าของลูกค้า',
    'ui__client/domain/custom-buttons/custom-button__none-available__1' => 'ลูกค้า %1 ไม่มีปุ่มแบบกำหนดเองในแผงการจัดการลูกค้า',
    'ui__client/domain/custom-buttons/custom-button__none-available__2' => 'ไม่มีปุ่มที่ตั้งค่าเองสำหรับโดเมน %1',
    'ui__client/domain/custom-buttons/custom-button/delete__description' => 'ลบปุ่มที่ตั้งค่าเอง %1',
    'ui__client/domain/custom-buttons/custom-button/delete__short-title' => 'ลบ',
    'ui__client/domain/custom-buttons/custom-button/delete__title' => 'ลบปุ่มที่ตั้งค่าเอง %1',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__description' => 'ลบปุ่มที่ตั้งค่าเอง',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__short-title' => 'ลบ',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__title' => 'ลบปุ่มที่ตั้งค่าเอง',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard-title' => 'ลบปุ่มที่ตั้งค่าเอง',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__1_unknown' => 'เลือกลูกค้าที่มีแผงการดูแลโดเมนที่คุณต้องการลบปุ่ม และคลิกถัดไป >>',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__2_unknown' => 'เลือกโดเมนจากแผงผู้ดูแลระบบที่คุณต้องการลบปุ่ม และคลิกถัดไป >>',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__4_multi' => 'เลือกปุ่มที่คุณต้องการลบ และคลิกถัดไป >>',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__5_multi' => 'ยืนยันการลบปุ่มโดยการเลือกกล่องกาเครื่องหมายตามลำดับ และคลิกเสร็จสิ้นเพื่อลบปุ่มและออกจากโปรแกรมช่วยติดตั้ง',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__description' => 'ลบปุ่มที่ตั้งค่าเอง',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__short-title' => 'ลบ',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__title' => 'ลบปุ่มที่ตั้งค่าเอง',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard-title' => 'ลบปุ่มที่ตั้งค่าเอง',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__1_unknown' => 'เลือกลูกค้าที่มีแผงการดูแลโดเมนที่คุณต้องการลบปุ่มตั้งค่า และคลิกถัดไป >>',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__2_unknown' => 'เลือกโดเมนจากแผงผู้ดูแลระบบที่คุณต้องการลบปุ่ม และคลิกถัดไป >>',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__4_unknown' => 'เลือกปุ่มที่ตั้งค่าเองที่คุณต้องการลบ และคลิกถัดไป >>',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__5' => 'ยืนยันการลบปุ่มที่ตั้งค่าเองโดยการเลือกช่องกาเครื่องหมาย และจากนั้นคลิกเสร็จสิ้นเพื่อลบปุ่มและออกจากโปรแกรมช่วยติดตั้ง',

    'ui__client/domain/custom-buttons/custom-button/properties__title' => "เปลี่ยนคุณสมบัติของปุ่มที่ตั้งค่าเอง %1",
    'ui__client/domain/custom-buttons/custom-button/properties__short-title' => "คุณสมบัติ",
    'ui__client/domain/custom-buttons/custom-button/properties__description' => "เปลี่ยนคุณสมบัติของปุ่มที่ตั้งค่าเอง %1 ในแผงการจัดการลูกค้า",

    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard-title' => 'เพิ่มปุ่ม',
    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard__1_unknown' => 'เลือกลูกค้าที่มีแผงควบคุมลูกค้าที่คุณวางปุ่มให้ และคลิกถัดไป >>',
    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard__2_unknown' => 'เลือกการสมัครรับบริการที่คุณต้องการเปลี่ยนปุ่ม และคลิกถัดไป >>',
    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard__5_new' => 'คลิกเสร็จสิ้นเพื่อสร้างปุ่ม และออกจากโปรแกรมช่วยติดตั้ง',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__description' => "เปลี่ยนคุณสมบัติของปุ่มในแผงการจัดการลูกค้า",
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__short-title' => 'คุณสมบัติ',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__title' => 'เปลี่ยนคุณสมบัติของปุ่มในแผงการจัดการลูกค้า',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__wizard-title' => 'เปลี่ยนคุณสมบัติของปุ่ม',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__wizard__4_unknown' => "เลือกปุ่มที่ตั้งค่าเองที่คุณต้องการแก้ไขการตั้งค่า และคลิกถัดไป >>",
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__wizard__5' => 'เมื่อทำการเปลี่ยนแปลงคุณสมบัติของปุ่มเรียบร้อยแล้ว ให้คลิกเสร็จสิ้นเพื่อนำการเปลี่ยนแปลงไปใช้ และออกจากโปรแกรมช่วยติดตั้ง',

    'ui__client/domain/custom-buttons/custom-button/toggle_private__description' => 'ทำให้ผู้ใช้เมลในโดเมนนี้สามารถใช้ปุ่ม %1 ได้',
    'ui__client/domain/custom-buttons/custom-button/toggle_private__short-title' => 'ไม่มีให้แก่ผู้ใช้เมล',
    'ui__client/domain/custom-buttons/custom-button/toggle_private__title' => 'ทำให้ผู้ใช้เมลในโดเมนนี้สามารถใช้ปุ่ม %1 ได้',
    'ui__client/domain/custom-buttons/custom-button/toggle_public__description' => 'ทำให้ผู้ใช้เมลในโดเมนนี้มองเห็นปุ่ม %1 ได้',

    'ui__client/domain/custom-buttons/custom-button/toggle_public__short-title' => 'สามารถเข้าถึงผู้ใช้เมลในโดเมนนี้',
    'ui__client/domain/custom-buttons/custom-button/toggle_public__title' => 'ทำให้ผู้ใช้เมลในโดเมนนี้มองเห็นปุ่ม %1 ได้',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__description' => 'ทำให้ผู้ใช้อื่นสามารถใช้หรือไม่สามารถใช้ปุ่มที่ตั้งค่าเองได้',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__short-title' => 'มี/ไม่มีให้ผู้ใช้อื่น',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__title' => 'ทำให้ผู้ใช้เมลสามารถใช้หรือไม่สามารถใช้ปุ่มที่ตั้งค่าเองได้',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__wizard-title' => 'ทำให้ผู้ใช้อื่นสามารถใช้หรือไม่สามารถใช้ปุ่มที่ตั้งค่าเองได้',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__wizard__2_unknown' => 'เลือกโดเมนที่คุณต้องการวางปุ่ม และคลิกถัดไป >>',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__wizard__4_unknown' => 'เลือกปุ่มที่คุณต้องการทำให้ผู้ใช้อื่นสามารถใช้หรือไม่สามารถใช้ปุ่มได้ และคลิกถัดไป >>',

    'ui__client/domain/delete__description' => 'ลบโดเมน %1',
    'ui__client/domain/delete__short-title' => 'ลบ',
    'ui__client/domain/delete__title' => 'ลบโดเมน %1',
    'ui__client/domain/delete_multi__description' => 'ลบโดเมน',

    'ui__client/domain/delete_multi__short-title' => 'ลบ',
    'ui__client/domain/delete_multi__title' => 'ลบโดเมน',
    'ui__client/domain/delete_multi__wizard-title' => 'ลบโดเมน',
    'ui__client/domain/delete_multi__wizard__2_multi' => 'เลือกโดเมนที่คุณต้องการลบและคลิกปุ่ม ถัดไป >>',
    'ui__client/domain/delete_multi__wizard__3_multi' => 'ยืนยันการลบโดเมน โดยการเลือกกล่องกาเครื่องหมาย และคลิกเสร็จสิ้นเพื่อดำเนินการโปรแกรมช่วยติดตั้งให้เสร็จสมบูรณ์',
    'ui__client/domain/delete_unknown__description' => 'ลบโดเมน',
    'ui__client/domain/delete_unknown__short-title' => 'ลบ',
    'ui__client/domain/delete_unknown__title' => 'ลบโดเมน',
    'ui__client/domain/delete_unknown__wizard-title' => 'ลบโดเมน',
    'ui__client/domain/delete_unknown__wizard__2_unknown' => 'เลือกโดเมนที่คุณต้องการลบและคลิกปุ่ม ถัดไป >>',
    'ui__client/domain/delete_unknown__wizard__3' => 'ยืนยันการลบโดเมน โดยการเลือกกล่องกาเครื่องหมาย และคลิกเสร็จสิ้นเพื่อดำเนินการโปรแกรมช่วยติดตั้งให้เสร็จสมบูรณ์',

    'ui__client/domain/hosting__none-available' => 'ไม่มีโดเมนที่โฮสติ้งเว็บได้รับการปรับตั้งค่า สร้างโดเมนและปรับตั้งค่าโฮสติ้งเว็บเพื่อเข้าถึงฟังก์ชั่นการทำงานนี้',
    'ui__client/domain/hosting__none-available__1' => 'บัญชีผู้ใช้ยังไม่มีโดเมนที่โฮสติ้งเว็บได้รับการปรับตั้งค่า ปรับตั้งค่าโฮสติ้งเว็บเพื่อเข้าถึงฟังก์ชั่นการทำงานนี้',
    'ui__client/domain/hosting__none-available__2' => 'โฮสติ้งเว็บยังไม่ได้รับการปรับตั้งค่าสำหรับโดเมน %1 ปรับตั้งค่าโฮสติ้งเว็บบนโดเมน %1 เพื่อเข้าถึงฟังก์ชั่นการทำงานนี้',

    'ui__client/domain/hosting/application#list_header__clients_number__title' => "ลูกค้า",
    'ui__client/domain/hosting/application#list_header__description__title' => "รายละเอียด",
    'ui__client/domain/hosting/application#list_header__items_number__title' => "รายการ",
    'ui__client/domain/hosting/application#list_header__name__title' => "ชื่อ",
    'ui__client/domain/hosting/application#list_header__release__title' => "ออกวางจำหน่าย",
    'ui__client/domain/hosting/application#list_header__sort_by_clients_number__title' => "จัดเรียงตามลูกค้า",
    'ui__client/domain/hosting/application#list_header__sort_by_description__title' => "จัดเรียงโดยรายละเอียด",
    'ui__client/domain/hosting/application#list_header__sort_by_items_number__title' => "จัดเรียงโดยเรื่อง",
    'ui__client/domain/hosting/application#list_header__sort_by_name__title' => "จัดเรียงโดยชื่อ",
    'ui__client/domain/hosting/application#list_header__sort_by_release__title' => "จัดเรียงโดยการปล่อย",
    'ui__client/domain/hosting/application#list_header__sort_by_version__title' => "จัดเรียงโดยเวอร์ชั่น",
    'ui__client/domain/hosting/application#list_header__title' => "แอพพลิเคชั่นเว็บ",
    'ui__client/domain/hosting/application#list_header__version__title' => "เวอร์ชั่น",

    'rpt_reseller_section_general' => 'ทั่วไป',
    'rpt_reseller_section_domains' => 'โดเมน',
    'rpt_reseller_section_clients' => 'ลูกค้า',
    'statistics__cl_active_domains' => "โดเมนที่ใช้งานอยู่",
    'rpt_reseller_cl_domains' => "โดเมน",
    'rpt_reseller_cl_subdomains' => "โดเมนย่อย",
    'by__cl_domains' => "โดเมนของไคลเอนท์",
    'dom_ctrl__cl_mboxes' => "กล่องจดหมาย",
    'rpt_reseller_cl_redirects' => "ผู้ส่งต่อ",
    'rpt_reseller_cl_mail_groups' => "กลุ่มเมล",
    'rpt_reseller_cl_mail_resps' => "การตอบกลับอัตโนมัติ",
    'rpt_reseller_cl_mail_lists' => "รายชื่อผู้รับจดหมาย",
    'rpt_reseller_cl_web_users' => "ผู้ใช้เว็บ",
    'rpt_reseller_cl_data_bases' => "ฐานข้อมูล",

    'statistics__active_clients' => 'ลูกค้าที่มีการสมัครที่ใช้งานอยู่',
    'statistics__clients_active_domains' => 'โดเมนที่ใช้งานอยู่',
    'statistics__clients_doms' => 'โดเมน',
    'statistics__cl_doms' => 'โดเมน',
    '__clients_subdomains' => 'โดเมนย่อย',
    '__clients_domains' => 'โดเมน',
    'dom_ctrl__clients_mboxes' => 'กล่องจดหมาย',
    'dom_ctrl__clients_redir' => 'ผู้ส่งต่อ',
    'dom_ctrl__clients_mg' => 'กลุ่มเมล',
    'dom_ctrl__clients_resp' => 'การตอบกลับอัตโนมัติ',
    'dom_ctrl__clients_maillists' => 'รายชื่อผู้รับจดหมาย',
    'dom_ctrl__clients_wu' => 'ผู้ใช้เว็บ',
    'dom_ctrl__clients_db' => 'ฐานข้อมูล',

    'dom_ctrl__cl_redir' => 'ผู้ส่งต่อ', // to resolve!
    'dom_ctrl__cl_mg' => 'กลุ่มเมล', // to resolve!
    'dom_ctrl__cl_resp' => 'การตอบกลับอัตโนมัติ', // to resolve!
    'dom_ctrl__cl_maillists' => 'รายชื่อผู้รับจดหมาย', // to resolve!
    'dom_ctrl__cl_wu' => 'ผู้ใช้เว็บ', // to resolve!
    'dom_ctrl__cl_db' => 'ฐานข้อมูล', // to resolve!

    'rpt_cl_section_clients' => 'ลูกค้า',

    'rpt_admin_section_general' => 'ทั่วไป',
    'rpt_admin_section_resellers' => 'ตัวแทนจำหน่าย',
    'rpt_admin_section_clients' => 'ลูกค้า',
    'rpt_admin_section_personal_clients' => 'ลูกค้าของตนเอง',
    'rpt_admin_section_domains' => 'โดเมน',
    'rpt_admin_section_personal_domains' => 'โดเมนส่วนตัว',

    'rpt_reseller_section_personal_domains' => 'โดเมนส่วนตัว',

    'ui__client/domain/toggle_unknown__wizard__2_unknown' => 'เลือกโดเมนที่คุณต้องการระงับหรือเปิดใช้งาน',
    'ui__client/domain/toggle_unknown__wizard-title' => 'ระงับหรือเปิดใช้งานโดเมน',

    'ui__client/ip-pool__description' => 'มอบหมาย IP แอดเดรสและการรับรอง SSL/TLS ไปยังลูกค้า %1',
    'ui__client/ip-pool__short-title' => 'IP กลุ่ม',
    'ui__client/ip-pool__title' => 'กลุ่ม IP ของลูกค้า %1',
    'ui__client/ip-pool_self__description' => 'ดู IP กลุ่มของคุณ',
    'ui__client/ip-pool_self__short-title' => 'IP กลุ่ม',
    'ui__client/ip-pool_self__title' => 'IP กลุ่มของฉัน',
    'ui__client/ip-pool/properties__description' => 'ตั้งค่ากลุ่ม IP สำหรับลูกค้า %1',

    'ui__client/ip-pool/properties__short-title' => 'IP กลุ่ม',
    'ui__client/ip-pool/properties__title' => 'ตั้งค่ากลุ่ม IP สำหรับลูกค้า %1',
    'ui__client/ip-pool/properties_self__description' => 'ดู IP กลุ่มของคุณ',

    'ui__client/ip-pool/properties_self__short-title' => 'IP กลุ่มของฉัน',
    'ui__client/ip-pool/properties_self__title' => 'IP กลุ่มของฉัน',
    'ui__client/ip-pool/properties_unknown__description' => 'มอบหมาย IP แอดเดรสและการรับรอง SSL/TLS จากลูกค้า',
    'ui__client/ip-pool/properties_unknown__short-title' => 'IP กลุ่ม',
    'ui__client/ip-pool/properties_unknown__title' => 'ตั้งค่ากลุ่ม IP ของลูกค้า',
    'ui__client/ip-pool/properties_unknown__wizard-title' => 'ตั้งค่ากลุ่ม IP ของลูกค้า',
    'ui__client/ip-pool/properties_unknown__wizard__1_unknown' => 'เลือกลูกค้าที่มีกลุ่ม IP ที่คุณต้องการปรับตั้งค่าการตั้งค่า',
    'ui__client/ip-pool/properties_unknown__wizard__3' => 'เมื่อทำการปรับตั้งค่า IP กลุ่มเสร็จสิ้นแล้ว ให้คลิกเสร็จสิ้นเพื่อดำเนินการโปรแกรมช่วยติดตั้งให้สมบูรณ์',


    'ui__client/limits_readonly-unknown__description' => 'ดูขีดจำกัดทรัพยากรสำหรับลูกค้า',
    'ui__client/limits_readonly-unknown__short-title' => 'ขีดจำกัดทรัพยากร',
    'ui__client/limits_readonly-unknown__title' => 'ดูขีดจำกัดทรัพยากรสำหรับบัญชีลูกค้า',
    'ui__client/limits_readonly-unknown__wizard-title' => 'ดูหรือเปลี่ยนแปลงขีดจำกัดของทรัพยากรสำหรับลูกค้า',

    'ui__client/limits_unknown__wizard-title' => 'ดูหรือเปลี่ยนแปลงขีดจำกัดของทรัพยากรสำหรับลูกค้า',
    'ui__client/limits_unknown__wizard__1_readonly-unknown' => 'เลือกลูกค้าที่คุณต้องการ',
    'ui__client/limits_unknown__wizard__1_unknown' => 'เลือกลูกค้าที่คุณต้องการ',
    'ui__client/limits_unknown__wizard__2' => 'เพื่อนำการเปลี่ยนแปลงไปใช้ ให้คลิกเสร็จสิ้น',
    'ui__client/limits_unknown__wizard__2_readonly' => 'เพื่อออกจากโปรแกรมช่วยติดตั้ง ให้คลิกเสร็จสิ้น',
    'ui__client/limits_unknown__wizard__2_readonly-self' => 'เพื่อออกจากโปรแกรมช่วยติดตั้ง ให้คลิกเสร็จสิ้น',
    'ui__client/limits_unknown__wizard__2_readonly-self-reseller' => 'เพื่อออกจากโปรแกรมช่วยติดตั้ง ให้คลิกเสร็จสิ้น',

    'ui__client/permissions_unknown__wizard-title' => 'ดูหรือเปลี่ยนแปลงการอนุญาตสำหรับลูกค้า',
    'ui__client/permissions_unknown__wizard__1/properties_self' => 'เมื่อทำการดูการอนุญาตเรียบร้อยแล้ว ให้คลิกเสร็จสิ้นเพื่อนำการเปลี่ยนแปลงไปใช้ และออกจากโปรแกรมช่วยติดตั้ง',
    'ui__client/permissions_unknown__wizard__1_unknown' => 'เลือกลูกค้าซึ่งคุณต้องการดูหรือเปลี่ยนแปลงการอนุญาต',
    'ui__client/permissions_unknown__wizard__2' => 'เมื่อทำการเปลี่ยนแปลงการอนุญาตให้ลูกค้าแล้ว ให้คลิกเสร็จสิ้นเพื่อนำการเปลี่ยนแปลงไปใช้ และออกจากโปรแกรมช่วยติดตั้ง',

    'ui__client/preferences_unknown__wizard-title' => 'แก้ไขความชอบของลูกค้า',
    'ui__client/preferences_unknown__wizard__1_unknown' => 'เลือกลูกค้าที่มีช่วงเวลาและความชอบด้านอินเตอร์เฟซที่คุณต้องการเปลี่ยน',
    'ui__client/preferences_unknown__wizard__2' => 'เมื่อเสร็จสิ้นการเปลี่ยนความชอบของลูกค้าแล้ว คลิกปุ่มเสร็จสิ้น',
    'ui__client/preferences_unknown__wizard__2_self' => 'เมื่อเสร็จสิ้นการเปลี่ยนความชอบของคุณแล้ว คลิกปุ่มเสร็จสิ้น',

    'ui__custom-buttons/custom-button__none-available' => 'คุณไม่มีปุ่มที่ตั้งค่าเอง',
    'ui__custom-buttons/custom-button/delete__description' => 'ลบปุ่มที่ตั้งค่าเอง %1',
    'ui__custom-buttons/custom-button/delete__short-title' => 'ลบ',
    'ui__custom-buttons/custom-button/delete__title' => 'ลบปุ่มที่ตั้งค่าเอง %1',
    'ui__custom-buttons/custom-button/delete_multi__description' => 'ลบปุ่มที่ตั้งค่าเอง',

    'ui__custom-buttons/custom-button/delete_multi__short-title' => 'ลบ',
    'ui__custom-buttons/custom-button/delete_multi__title' => 'ลบปุ่มที่ตั้งค่าเอง',
    'ui__custom-buttons/custom-button/delete_multi__wizard-title' => 'ลบปุ่มที่ตั้งค่าเอง',
    'ui__custom-buttons/custom-button/delete_multi__wizard__2_multi' => 'เลือกปุ่มที่คุณต้องการลบ',
    'ui__custom-buttons/custom-button/delete_multi__wizard__3_multi' => 'ยืนยันการลบปุ่มด้วยการเลือกกล่องกาเครื่องหมาย และคลิกเสร็จสิ้นเพื่อเสร็จสิ้นโปรแกรมช่วยติดตั้ง',
    'ui__custom-buttons/custom-button/delete_unknown__description' => 'ลบปุ่มที่ตั้งค่าเอง',
    'ui__custom-buttons/custom-button/delete_unknown__short-title' => 'ลบ',
    'ui__custom-buttons/custom-button/delete_unknown__title' => 'ลบปุ่มที่ตั้งค่าเอง',
    'ui__custom-buttons/custom-button/delete_unknown__wizard-title' => 'ลบปุ่มที่ตั้งค่าเอง',
    'ui__custom-buttons/custom-button/delete_unknown__wizard__2_unknown' => 'เลือกปุ่มที่ตั้งค่าเองที่คุณต้องการลบ',
    'ui__custom-buttons/custom-button/delete_unknown__wizard__3' => 'ยืนยันการลบปุ่มด้วยการเลือกกล่องกาเครื่องหมาย และคลิกเสร็จสิ้นเพื่อเสร็จสิ้นโปรแกรมช่วยติดตั้ง',
    'ui__custom-buttons/custom-button/properties__description' => 'เปลี่ยนแปลงคุณสมบัติของปุ่ม %1',

    'ui__custom-buttons/custom-button/properties__short-title' => 'คุณสมบัติ',
    'ui__custom-buttons/custom-button/properties__title' => 'เปลี่ยนแปลงคุณสมบัติของปุ่ม %1',

    'ui__custom-buttons/custom-button/properties_new__wizard-title' => 'สร้างปุ่ม',
    'ui__custom-buttons/custom-button/properties_new__wizard__3_new' => 'คลิกเสร็จสิ้นเพื่อสร้างปุ่ม',
    'ui__custom-buttons/custom-button/properties_unknown__description' => 'เปลี่ยนคุณสมบัติของปุ่มที่ตั้งค่าเอง',
    'ui__custom-buttons/custom-button/properties_unknown__short-title' => 'คุณสมบัติ',
    'ui__custom-buttons/custom-button/properties_unknown__title' => 'เปลี่ยนคุณสมบัติของปุ่มที่ตั้งค่าเอง',
    'ui__custom-buttons/custom-button/properties_unknown__wizard-title' => 'เปลี่ยนคุณสมบัติของปุ่มที่ตั้งค่าเอง',
    'ui__custom-buttons/custom-button/properties_unknown__wizard__2_unknown' => 'เลือกปุ่มที่ตั้งค่าเองที่คุณต้องการเปลี่ยนแปลงคุณสมบัติ',
    'ui__custom-buttons/custom-button/properties_unknown__wizard__3' => 'เพื่อนำการเปลี่ยนแปลงไปใช้ ให้คลิกเสร็จสิ้น',
    'ui__custom-buttons/custom-button/toggle_private__description' => 'สร้างปุ่มที่ตั้งค่าเอง %1 ให้บัญชีอื่นไม่สามารถใช้ได้',

    'ui__custom-buttons/custom-button/toggle_private__short-title' => 'บัญชีอื่นไม่สามารถใช้ได้',
    'ui__custom-buttons/custom-button/toggle_private__title' => 'สร้างปุ่มที่ตั้งค่าเอง %1 ให้บัญชีอื่นไม่สามารถใช้ได้',
    'ui__custom-buttons/custom-button/toggle_public__description' => 'สร้างปุ่มที่ตั้งค่าเอง %1 ให้บัญชีอื่นสามารถใช้ได้',

    'ui__custom-buttons/custom-button/toggle_public__short-title' => 'บัญชีอื่นสามารถใช้ได้',
    'ui__custom-buttons/custom-button/toggle_public__title' => 'สร้างปุ่มที่ตั้งค่าเอง %1 ให้บัญชีอื่นสามารถใช้ได้',
    'ui__custom-buttons/custom-button/toggle_unknown__description' => 'สร้างปุ่มที่ตั้งค่าเองให้บัญชีอื่นสามารถใช้หรือไม่ก็ได้',
    'ui__custom-buttons/custom-button/toggle_unknown__short-title' => 'บัญชีอื่นสามารถใช้หรือไม่ก็ได้',
    'ui__custom-buttons/custom-button/toggle_unknown__title' => 'สร้างปุ่มที่ตั้งค่าเองให้บัญชีอื่นสามารถใช้หรือไม่ก็ได้',
    'ui__custom-buttons/custom-button/toggle_unknown__wizard-title' => 'สร้างปุ่มที่ตั้งค่าเองให้บัญชีอื่นสามารถใช้หรือไม่ก็ได้',
    'ui__custom-buttons/custom-button/toggle_unknown__wizard__2_unknown' => 'เลือกปุ่มที่ตั้งค่าเองที่คุณต้องการทำให้ผู้ใช้อื่นสามารถใช้หรือไม่สามารถใช้ได้ และคลิกถัดไป >>',

    'ui__longtasks#list_header__name__title' => "ชื่อ",
    'ui__longtasks#list_header__owner__title' => "เจ้าของ",
    'ui__longtasks#list_header__start_time__title' => "เวลาที่สร้าง",
    'ui__longtasks#list_header__status__title' => "สถานะ",
    'ui__longtasks#list_header__title' => "งาน",
    'ui__longtasks#list_header__finish_time__title' => "เวลาในการดำเนินการแล้วเสร็จ",
    'ui__longtasks#task_list_legend__title' => "งาน",
    'ui__longtasks#tools_legend__title' => "เครื่องมือ",
    'ui__longtasks__description' => "จัดการกับพื้นหลังของงาน",
    'ui__longtasks__short-title' => "พื้นหลังของงาน",
    'ui__longtasks__title' => "พื้นหลังของงาน",
    'ui__longtasks/longtask/properties#current_operation__title' => "การดำเนินการขณะนี้:",
    'ui__longtasks/longtask/properties#finish_time__title' => "ระยะเวลาที่คาดการณ์ว่าจะเสร็จสิ้น:",
    'ui__longtasks/longtask/properties#general_legend__title' => "ทั่วไป",
    'ui__longtasks/longtask/properties#owner__title' => "เริ่มงานโดย:",
    'ui__longtasks/longtask/properties#progress__title' => "ขั้นตอนทั้งหมด:",
    'ui__longtasks/longtask/properties#start_time__title' => "เริ่มทำงาน:",
    'ui__longtasks/longtask/properties#status_legend__title' => "สถานะงาน",
    'ui__longtasks/longtask/properties__description' => "พื้นหลังของงานและรายละเอียดข้อมูล",

    'ui__longtasks/properties__description' => "ตั้งค่าพื้นหลังของงาน",
    'ui__longtasks/properties__short-title' => "การตั้งค่า",
    'ui__longtasks/properties__title' => "พื้นหลังของงาน",

    // updated
    'ui__mass-mail/template#list_header__title' => 'แม่แบบข้อความอีเมลจำนวนมาก',
    'ui__mass-mail/template#list_header__name__title' => 'ชื่อแม่แบบ',
    'ui__mass-mail/template#list_header__from_email__title' => 'ผู้ส่ง',
    'ui__mass-mail/template#list_header__to__title' => 'ผู้รับ',
    'ui__mass-mail/template#list_header__subject__title' => 'ชื่อเรื่อง',
    'ui__mass-mail/template#list_header__cdate__title' => 'วันที่สร้าง',
    'ui__mass-mail/template#list_header__send__title' => 'ส่ง',

    'ui__mass-mail/template/properties__short-title' => '%1',
    'ui__mass-mail/template/properties__title' => 'แก้ไขแม่แบบข้อความอีเมลจำนวนมาก',
    'ui__mass-mail/template/properties__description' => 'แก้ไขแม่แบบข้อความอีเมลจำนวนมากนี้',

    'ui__mass-mail/template/properties_unknown-new__short-title' => 'เพิ่มแม่แบบอีเมลจำนวนมาก',
    'ui__mass-mail/template/properties_unknown-new__title' => 'เพิ่มแม่แบบอีเมลจำนวนมาก',
    'ui__mass-mail/template/properties_unknown-new__description' => 'เพิ่มแม่แบบข้อความอีเมลจำนวนมาก',
    'ui__mass-mail/send__short-title' => 'ส่งอีเมลจำนวนมาก',
    'ui__mass-mail/send__title' => 'ส่งข้อความอีเมลจำนวนมาก',
    'ui__mass-mail/send__description' => 'ส่งข้อความอีเมลจำนวนมากไปยังผู้รับที่เลือก',
    'ui__mass-mail/template/delete_multi__short-title' => 'ลบแม่แบบอีเมลจำนวนมาก',
    'ui__mass-mail/template/delete_multi__title' => 'ลบแม่แบบข้อความอีเมลจำนวนมากเหล่านี้:',
    'ui__mass-mail/template/delete_multi__description' => 'การลบแม่แบบข้อความอีเมลจำนวนมากที่เลือก',
    'ui__mass-mail/template/delete_multi__done' => 'แม่แบบข้อความที่เลือกถูกลบแล้ว',
    'ui__mass-mail/template/properties__invalid_values' => 'ค่าที่ระบุไม่ถูกต้อง',


    // old
    'ui__mass-mail#body_text__description' => 'คุณสามารถใช้ตัวแปรในเนื้อหาของข้อความ (แต่ไม่สามารถใช้ได้ในส่วนหัวกระดาษ) เนื่องจากจะถูกแทนที่ด้วยชื่อของลูกค้าหรือผู้ขาย',
    'ui__mass-mail#body_text__title' => 'ข้อความตัวอักษร',
    'ui__mass-mail#compose_legend__title' => 'ข้อความ',
    'ui__mass-mail#from_email_text__title' => 'จาก (ที่อยู่อีเมล์)',
    'ui__mass-mail#list_header__cdate__title' => 'สร้างเสร็จแล้ว',
    'ui__mass-mail#list_header__from_email__title' => 'จาก',
    'ui__mass-mail#list_header__name__title' => 'ชื่อ',
    'ui__mass-mail#list_header__send__title' => 'สร้างข้อความ',
    'ui__mass-mail#list_header__subject__title' => 'ชื่อเรื่อง',
    'ui__mass-mail#list_header__title' => 'แม่แบบข้อความอีเมลจำนวนมาก',
    'ui__mass-mail#list_header__to__title' => 'ถึง',
    'ui__mass-mail#list_legend__title' => 'แม่แบบข้อความอีเมลจำนวนมาก',
    'ui__mass-mail#load_template_text__title' => 'โหลด',
    'ui__mass-mail#name_text__title' => 'ชื่อแม่แบบ',
    'ui__mass-mail#option_mode_all__title' => 'ทั้งหมด',
    'ui__mass-mail#option_mode_except__title' => 'ทั้งหมดยกเว้นที่เลือก',
    'ui__mass-mail#option_mode_select__title' => 'ที่เลือกเท่านั้น',
    'ui__mass-mail#option_select_template__title' => '---เลือกแม่แบบ---',
    'ui__mass-mail#picker_legend__title' => 'แม่แบบข้อความอีเมล',
    'ui__mass-mail#picker_title__title' => 'เลือกแม่แบบ',
    'ui__mass-mail#save_as_legend__title' => 'บันทึกเป็นแม่แบบ',
    'ui__mass-mail#save_as_text__title' => 'บันข้อความที่เขียนไปยังแม่แบบใหม่ที่ตั้งชื่อ',
    'ui__mass-mail#subject_text__title' => 'ชื่อเรื่อง',
    'ui__mass-mail#template_legend__title' => 'แม่แบบ',
    'ui__mass-mail#to_admin_text__title' => 'ผู้ดูแลระบบ Plesk',
    'ui__mass-mail#to_clients_text__title' => 'ลูกค้า',
    'ui__mass-mail#to_domains_text__title' => 'ผู้ดูแลระบบโดเมน',
    'ui__mass-mail#to_select_text__title' => 'เลือกที่อยู่',
    'ui__mass-mail#to_show_hide_text__title' => 'แสดง/ซ่อนที่เลือก',
    'ui__mass-mail#to_text__title' => 'ถึง',
    'ui__mass-mail#tools_legend__title' => 'เครื่องมือ',
    'ui__mass-mail__already_exists' => 'มีแม่แบบที่มีชื่อ %1 อยู่แล้ว',
    'ui__mass-mail__none-available' => 'คุณไม่มีแม่แบบข้อความ',

    'ui__mass-mail/delete__description' => 'ลบแม่แบบข้อความอีเมลจำนวนมาก %1',

    'ui__mass-mail/delete__empty_selection' => 'โปรดเลือกแม่แบบที่คุณต้องการลบ',
    'ui__mass-mail/delete__short-title' => 'ลบ %1',
    'ui__mass-mail/delete__title' => 'ลบแม่แบบข้อความอีเมลจำนวนมาก %1',
    'ui__mass-mail/delete_multi__description' => 'ลบแม่แบบข้อความอีเมลจำนวนมาก',

    'ui__mass-mail/delete_multi__short-title' => 'ลบ',
    'ui__mass-mail/delete_multi__title' => 'ลบแม่แบบข้อความอีเมลจำนวนมาก',
    'ui__mass-mail/delete_multi__wizard-title' => 'การลบแม่แบบข้อความอีเมลจำนวนมาก',
    'ui__mass-mail/delete_multi__wizard__1_multi' => 'เลือกแม่แบบข้อความอีเมลจำนวนมากที่คุณต้องการลบ',
    'ui__mass-mail/delete_multi__wizard__2_multi' => 'ยืนยันการลบแม่แบบโดยการเลือกช่องกาเครื่องหมาย และคลิกเสร็จสิ้นเพื่อเสร็จสิ้นโปรแกรมข่วยติดตั้ง',
    'ui__mass-mail/delete_unknown__description' => 'ลบแม่แบบข้อความอีเมลจำนวนมาก',
    'ui__mass-mail/delete_unknown__short-title' => 'ลบ',
    'ui__mass-mail/delete_unknown__title' => 'ลบแม่แบบข้อความอีเมลจำนวนมาก',
    'ui__mass-mail/delete_unknown__wizard-title' => 'การลบแม่แบบข้อความอีเมลจำนวนมาก',
    'ui__mass-mail/delete_unknown__wizard__1_unknown' => 'เลือกแม่แบบข้อความอีเมลจำนวนมากที่คุณต้องการลบ',
    'ui__mass-mail/delete_unknown__wizard__2' => 'ยืนยันการลบแม่แบบโดยการเลือกช่องกาเครื่องหมาย และคลิกเสร็จสิ้นเพื่อเสร็จสิ้นโปรแกรมข่วยติดตั้ง',

    'ui__mass-mail/properties__description' => 'แก้ไขแม่แบบข้อความอีเมล %1',

    'ui__mass-mail/properties__invalid_values' => 'ค่าที่ระบุไม่ถูกต้อง',
    'ui__mass-mail/properties__short-title' => '%1',
    'ui__mass-mail/properties__title' => 'แก้ไขแม่แบบข้อความอีเมล %1',

    'ui__mass-mail/properties_new__wizard-title' => 'สร้างแม่แบบข้อความอีเมลจำนวนมาก',
    'ui__mass-mail/properties_unknown-new__description' => 'สร้างแม่แบบข้อความอีเมล',
    'ui__mass-mail/properties_unknown-new__short-title' => 'เพิ่มแม่แบบข้อความอีเมล',
    'ui__mass-mail/properties_unknown-new__title' => 'สร้างแม่แบบข้อความอีเมล',
    'ui__mass-mail/properties_unknown__wizard-title' => 'แก้ไขแม่แบบข้อความอีเมลจำนวนมาก',
    'ui__mass-mail/properties_unknown__wizard__1_unknown' => 'เลือกแม่แบบที่คุณต้องการแก้ไข และคลิกถัดไป >>',
    'ui__mass-mail/properties_unknown__wizard__2' => 'เมื่อทำการแก้ไขแม่แบบเรียบร้อยแล้ว ให้คลิกเสร็จสิ้นเพื่อนำการเปลี่ยนแปลงไปใช้ และออกจากโปรแกรมช่วยติดตั้ง',

    'ui__mass-mail/send__invalid_values' => 'คุณระบุค่าไม่ถูกต้อง',

    'ui__mass-mail/send_new__wizard-title' => 'สร้างแม่แบบข้อความและ้ส่งอีเมล',
    'ui__mass-mail/send_unknown-new__description' => 'ส่งอีเมลไปยังผู้ีัรับที่เลือก',

    'ui__mass-mail/send_unknown-new__short-title' => 'ส่งอีเมลจำนวนมาก',
    'ui__mass-mail/send_unknown-new__title' => 'ส่งข้อความอีเมลจำนวนมาก',
    'ui__mass-mail/send_unknown__description' => 'ส่งอีเมลไปยังผู้ีัรับที่เลือก',

    'ui__mass-mail/send_unknown__short-title' => 'ส่งอีเมลจำนวนมาก',
    'ui__mass-mail/send_unknown__title' => 'ส่งข้อความอีเมลจำนวนมาก',
    'ui__mass-mail/send_unknown__wizard-title' => 'ส่งข้อความอีเมลจำนวนมาก',
    'ui__mass-mail/send_unknown__wizard__1_unknown' => 'เลือกแม่แบบที่คุณต้องการ และคลิกถัดไป >>',
    'ui__mass-mail/send_unknown__wizard__2' => 'เมื่อทำการแก้ไขคุณสมบัติของแม่แบบเรียบร้อยแล้ว ให้คลิกเสร็จสิ้นเพื่อส่งข้อความ และออกจากโปรแกรมช่วยติดตั้ง',

    'ui__mass-email/delete__description' => 'การลบแม่แบบข้อความอีเมลจำนวนมากที่เลือก',

    'ui__mass-email/delete__empty_selection' => "เลือกแม่แบบที่คุณต้องการลบ",
    'ui__mass-email/delete__short-title' => "ลบ %1",
    'ui__mass-email/delete__title' => "ลบแม่แบบข้อความอีเมลจำนวนมาก %1",
    'ui__mass-email/delete_multi__description' => "ลบแม่แบบข้อความอีเมลจำนวนมาก",

    'ui__mass-email/delete_multi__short-title' => "ลบ",
    'ui__mass-email/delete_multi__title' => "ลบแม่แบบข้อความอีเมลจำนวนมาก",
    'ui__mass-email/delete_multi__wizard__mass-mail/delete_multi' => "ยืนยันการลบแม่แบบโดยการเลือกช่องกาเครื่องหมาย และคลิกเสร็จสิ้นเพื่อเสร็จสิ้นโปรแกรมข่วยติดตั้ง",
    'ui__mass-email/delete_multi__wizard__mass-mail_multi' => "เลือกแม่แบบข้อความอีเมลจำนวนมากที่คุณต้องการลบ",
    'ui__mass-email/delete_multi__wizard-title' => "การลบแม่แบบข้อความอีเมลจำนวนมาก",
    'ui__mass-email/delete_unknown__description' => "ลบแม่แบบข้อความอีเมลจำนวนมาก",
    'ui__mass-email/delete_unknown__short-title' => "ลบ",
    'ui__mass-email/delete_unknown__title' => "ลบแม่แบบข้อความอีเมลจำนวนมาก",
    'ui__mass-email/delete_unknown__wizard__mass-mail/delete' => "ยืนยันการลบแม่แบบโดยการเลือกช่องกาเครื่องหมาย และคลิกเสร็จสิ้นเพื่อเสร็จสิ้นโปรแกรมข่วยติดตั้ง",
    'ui__mass-email/delete_unknown__wizard__mass-mail_unknown' => "เลือกแม่แบบข้อความอีเมลจำนวนมากที่คุณต้องการลบ",
    'ui__mass-email/delete_unknown__wizard-title' => "การลบแม่แบบข้อความอีเมลจำนวนมาก",
    'ui__mass-email/send__description' => "ส่งอีเมลไปยังผู้ีัรับที่เลือก",
    'ui__mass-email/send__short-title' => "ส่งอีเมลจำนวนมาก",
    'ui__mass-email/send__title' => "ส่งข้อความอีเมลจำนวนมาก",
    'ui__mass-email/send_main__description' => "ส่งอีเมลไปยังผู้ีัรับที่เลือก",

    'ui__mass-email/send_main__short-title' => "ส่งอีเมลจำนวนมาก",
    'ui__mass-email/send_main__title' => "ส่งข้อความอีเมลจำนวนมาก",
    'ui__mass-email/send_selectresellers__title' => 'เลือกตัวแทนจำหน่าย',
    'ui__mass-email/send_selectresellers__short-title' => 'ตัวแทนจำหน่าย',
    'ui__mass-email/send_selectresellers__description' => 'เลือกบัญชีตัวแทนจำหน่าย',

    'ui__mass-email/send_selectclients__description' => "เลือกบัญชีลูกค้า",

    'ui__mass-email/send_selectclients__short-title' => "ลูกค้า",
    'ui__mass-email/send_selectclients__title' => "เลือกลูกค้า",
    'ui__mass-email/send_selectdomainusers__description' => "เลือกบัญชีผู้ดูแลระบบโดเมน",

    'ui__mass-email/send_selectdomainusers__short-title' => "ผู้ดูแลระบบโดเมน",
    'ui__mass-email/send_selectdomainusers__title' => "เลือกผู้ดูแลระบบโดเมน",
    'ui__mass-email/template/properties_main__description' => "สร้างแม่แบบข้อความอีเมลจำนวนมาก",
    'ui__mass-email/template/properties_main__short-title' => "แก้ไขแม่แบบ",
    'ui__mass-email/template/properties_main__title' => "แก้ไขแม่แบบข้อความอีเมลจำนวนมาก",
    'ui__mass-email/template/properties_new-main__description' => "สร้างแม่แบบสำหรับข้อความอีเมลจำนวนมาก",
    'ui__mass-email/template/properties_new-main__short-title' => "สร้างแม่แบบข้อความอีเมลจำนวนมาก",
    'ui__mass-email/template/properties_new-main__title' => "สร้างแม่แบบข้อความอีเมลจำนวนมาก",
    'ui__mass-email/template/properties_new-selectclients__description' => "เลือกลูกค้าที่จะรับข้อความอีเมลจำนวนมากโดยยึดตามแม่แบบนี้",
    'ui__mass-email/template/properties_new-selectclients__title' => "เลือกลูกค้าที่จะรับข้อความอีเมลจำนวนมากโดยยึดตามแม่แบบนี้",
    'ui__mass-email/template/properties_new-selectdomainusers__description' => "เลือกผู้ดูแลระบบโดเมนที่จะรับข้อความอีเมลจำนวนมากโดยยึดตามแม่แบบนี้",
    'ui__mass-email/template/properties_new-selectdomainusers__title' => "เลือกผู้ดูแลระบบโดเมนที่จะรับข้อความอีเมลจำนวนมากโดยยึดตามแม่แบบนี้",
    'ui__mass-email/template/properties_selectclients__title' => "เลือกลูกค้าที่จะรับข้อความอีเมลจำนวนมากโดยยึดตามแม่แบบนี้",
    'ui__mass-email/template/properties_selectdomainusers__title' => "เลือกผู้ดูแลระบบโดเมนที่จะรับข้อความอีเมลจำนวนมากโดยยึดตามแม่แบบนี้",

    'ui__mass-email/template/properties_unknown-new__description' => "สร้างแม่แบบข้อความอีเมลจำนวนมาก",
    'ui__mass-email/template/properties_unknown-new__short-title' => "สร้างแม่แบบ",
    'ui__mass-email/template/properties_unknown-new__title' => "การสร้างแม่แบบข้อความอีเมลจำนวนมาก",
    'ui__news/dismiss__description' => 'คลิกเพื่อปิดหน้าต่างข่าวสาร Plesk จะไม่แสดงหน้าต่างนี้จนกว่าข่าวสารจะได้รับการอัพเดต',

    'ui__news/dismiss__title' => 'ปิดข่าว',

    'ui__server__description' => 'การจัดการเซิร์ฟเวอร์',
    'ui__server__short-title' => 'จัดการเซิร์ฟเวอร์ของคุณ',
    'ui__server__title' => 'จัดการกับเซิร์ฟเวอร์',


    // UNUSED SINCE 9.2



    // END OF UNUSED SINCE 9.2

    'ui__server/ip-address__disabled-warning' => 'ไม่สามารถใช้ IP แอดเดรส %1 ได้',
    'ui__server/ip-address__none-available' => 'ไม่มี IP แอดเดรส',
    'ui__server/ip-addresses/ip-address__title' => "IP แอดเดรส",
    'ui__server/ip-address/client/properties_new__description' => "มอบหมาย IP แอดเดรส %1 ให้ตัวแทนจำหน่าย",
    'ui__server/ip-address/client/properties_new__short-title' => 'กำหนด',
    'ui__server/ip-address/client/properties_new__title' => "มอบหมาย IP แอดเดรส %1 ให้ตัวแทนจำหน่าย",
    'ui__server/ip-address/client__none-available' => 'ไม่มีบัญชีผู้ใข้',
    'ui__server/ip-address/client_unknown__quick_search' => 'ผู้ใช้',
    'ui__server/ip-address/client_unknown__wizard-title' => 'รายการผู้ใช้ซึ่งใช้ IP แอดเดรส',
    'ui__server/ip-address/client_unknown__wizard__3_unknown' => 'โปรดเลือก IP แอดเดรส',
    'ui__server/ip-address/client/delete__description' => 'ยกเลิกการกำหนด IP แอดเดรสจากตัวแทนจำหน่าย',
    'ui__server/ip-address/client/delete__short-title' => 'ยกเลิกการกำหนด',
    'ui__server/ip-address/client/delete__title' => 'ยกเลิกการกำหนด IP แอดเดรสจากตัวแทนจำหน่าย',
    'ui__server/ip-address/client/delete_multi__description' => "ยกเลิกการกำหนด IP แอดเดรสจากกลุ่มตัวแทนจำหน่าย",

    'ui__server/ip-address/client/delete_multi__short-title' => 'ยกเลิกการกำหนด',
    'ui__server/ip-address/client/delete_multi__title' => 'ยกเลิกการกำหนด IP แอดเดรสจากตัวแทนจำหน่าย',
    'ui__server/ip-address/client/delete_multi__wizard-title' => "ลบ IP แอดเดรสจากกลุ่มผู้ใช้",
    'ui__server/ip-address/client/delete_multi__wizard__3_unknown' => 'เลือก IP แอดเดรสที่คุณต้องการยกเลิกการกำหนดจากผู้ใช้ และคลิกถัดไป >>',
    'ui__server/ip-address/client/delete_multi__wizard__3_multi' => 'เลือกผู้ใช้ที่คุณต้องการยกเลิกการกำหนด IP แอดเดรส และคลิกถัดไป >>',
    'ui__server/ip-address/client/delete_multi__wizard__4_multi' => 'ยืนยันการยกเลิกการกำหนด IP แอดเดรสจาหผู้ใช้ โดยการเลือกกล่องกาเครื่องหมาย และคลิกเสร็จสิ้นเพื่อดำเนินการโปรแกรมช่วยติดตั้งให้สมบูรณ์',
    'ui__server/ip-address/client/delete_unknown__description' => 'ยกเลิกการกำหนด IP แอดเดรสจากตัวแทนจำหน่าย',
    'ui__server/ip-address/client/delete_unknown__short-title' => 'ยกเลิกการกำหนด',
    'ui__server/ip-address/client/delete_unknown__title' => 'ยกเลิกการกำหนด IP แอดเดรสจากตัวแทนจำหน่าย',
    'ui__server/ip-address/client/delete_unknown__wizard-title' => 'ยกเลิกการกำหนด IP แอดเดรสจากผู้ใช้',
    'ui__server/ip-address/client/delete_unknown__wizard__3_unknown' => 'เลือก IP แอดเดรสที่คุณต้องการยกเลิกการกำหนดจากผู้ใช้ และคลิกถัดไป >>',
    'ui__server/ip-address/client/delete_unknown__wizard__4_unknown' => 'เลือกผู้ใช้ที่คุณต้องการยกเลิกการกำหนด IP แอดเดรส และคลิกถัดไป >>',
    'ui__server/ip-address/client/delete_unknown__wizard__5' => 'ยืนยันการยกเลิกการกำหนด IP แอดเดรสจาหผู้ใช้ โดยการเลือกกล่องกาเครื่องหมาย และคลิกเสร็จสิ้นเพื่อดำเนินการโปรแกรมช่วยติดตั้งให้สมบูรณ์',

    'ui__server/ip-address/domain__description' => "โดเมนทั้งหมดบน IP แอดเดรส %1",
    'ui__server/ip-address/domain__short-title' => "โดเมน",
    'ui__server/ip-address/domain__title' => "โดเมนทั้งหมดบน IP แอดเดรส %1",
    'ui__server/ip-address/domain_unknown__description' => "โดเมนทั้งหมดบน IP แอดเดรส",
    'ui__server/ip-address/domain_unknown__short-title' => "โดเมน",
    'ui__server/ip-address/domain_unknown__title' => "โดเมนบน IP แอดเดรส",
    'ui__server/ip-address/domain_unknown__wizard__3_unknown' => "เลือก IP แอดเดรสที่คุณต้องการ และคลิกถัดไป >>",

    'ui__server/ip-address/properties__description' => 'เปลี่ยนแปลงคุณสมบัติของ IP แอดเดรส %1',
    'ui__server/ip-address/properties__short-title' => 'คุณสมบัติ',
    'ui__server/ip-address/properties__title' => 'เปลี่ยนแปลงคุณสมบัติของ IP แอดเดรส %1',

    'ui__server/ip-address/properties_new__wizard-title' => 'เพิ่ม IP แอดเดรส',
    'ui__server/ip-address/properties_new__wizard__4_new' => 'เมื่อทำการเปลี่ยนแปลงคุณสมบบัติ IP แอดเดรสเสร็จสิ้นแล้ว ให้คลิกเสร็จสิ้นเพื่อนำการเปลี่ยนแปลงไปใช้',
    'ui__server/ip-address/properties_unknown__description' => 'เปลี่ยนแปลงคุณสมบัติของ IP แอดเดรส',
    'ui__server/ip-address/properties_unknown__short-title' => 'คุณสมบัติ',
    'ui__server/ip-address/properties_unknown__title' => 'เปลี่ยนแปลงคุณสมบัติของ IP แอดเดรส',
    'ui__server/ip-address/properties_unknown__wizard-title' => 'เปลี่ยนแปลงคุณสมบัติของ IP แอดเดรส',
    'ui__server/ip-address/properties_unknown__wizard__3_unknown' => 'เลือก IP แอดเดรสที่คุณต้องการเปลี่ยนแปลงคุณสมบัติ',
    'ui__server/ip-address/properties_unknown__wizard__4' => 'เมื่อทำการเปลี่ยนแปลงคุณสมบบัติ IP แอดเดรสเสร็จสิ้นแล้ว ให้คลิกเสร็จสิ้นเพื่อนำการเปลี่ยนแปลงไปใช้',

    'ui__server/spam-filter/black-list__description' => 'ตั้งบัญชีดำสำหรับตัวกรองสแปมทั่วทั้งเซิร์ฟเวอร์',
    'ui__server/spam-filter/black-list__short-title' => 'บัญชีดำ',
    'ui__server/spam-filter/black-list__title' => 'บัญชีดำสำหรับตัวกรองสแปมทั่วทั้งเซิร์ฟเวอร์',

    'ui__server/spam-filter/black-list/address__addresses_available' => 'ที่อยู่อีเมลที่ไม่เหมือนใคร %1 เท่านั้นที่ได้จะได้เพิ่้มเข้าไป',
    'ui__server/spam-filter/black-list/address__description' => 'ที่อยู่บัญชีดำของตัวกรองสแปม',

    'ui__server/spam-filter/black-list/address__empty_content' => 'ไม่มีที่อยู่อีเมลในรายการ',
    'ui__server/spam-filter/black-list/address__file_size' => 'ไฟล์ที่อัพโหลดยังว่าง',
    'ui__server/spam-filter/black-list/address__invalid_addresses' => 'ที่อยู่อีเมลดังต่อไปนี้ไม่ถูกต้อง: %1.',
    'ui__server/spam-filter/black-list/address__none-available' => 'ไม่มีที่อยู่ในบัญชีดำตัวกรองสแปม',
    'ui__server/spam-filter/black-list/address__short-title' => 'ที่อยู่',
    'ui__server/spam-filter/black-list/address__title' => 'ที่อยู่บัญชีดำ %1',
    'ui__server/spam-filter/black-list/address_unknown__description' => 'เพิ่มที่อยู่ไปยังบัญชีดำ',
    'ui__server/spam-filter/black-list/address_unknown__short-title' => 'เพิ่มที่อยู่',
    'ui__server/spam-filter/black-list/address_unknown__title' => 'เพิ่มที่อยู่ไปยังบัญชีดำ',

    'ui__server/spam-filter/black-list/address/delete__description' => 'ลบที่อยู่ %1 ออกจากบัญชีดำทั่วทั้งเซิร์ฟเวอร์',

    'ui__server/spam-filter/black-list/address/delete__short-title' => 'ลบ',
    'ui__server/spam-filter/black-list/address/delete__title' => 'ลบที่อยู่ %1 ออกจากบัญชีดำทั่วทั้งเซิร์ฟเวอร์',
    'ui__server/spam-filter/black-list/address/delete_multi__description' => 'ลบ IP แอดเดรสจากบัญชีดำทั่วทั้งเซิร์ฟเวอร์',

    'ui__server/spam-filter/black-list/address/delete_multi__short-title' => 'ลบ',
    'ui__server/spam-filter/black-list/address/delete_multi__title' => 'ลบที่อยู่ออกจากบัญชีดำทั่วทั้งเซิร์ฟเวอร์',
    'ui__server/spam-filter/black-list/address/delete_multi__wizard-title' => 'การลบที่อยู่ออกจากบัญชีดำตัวกรองสแปมทั้วทั้งเซิร์ฟเวอร์',
    'ui__server/spam-filter/black-list/address/delete_multi__wizard__4_multi' => 'เลือกที่อยู่ตัวกรองสแปมที่คุณต้องการลบ และคลิกถัดไป >>',
    'ui__server/spam-filter/black-list/address/delete_multi__wizard__5_multi' => 'ยืนยันการลบที่อยู่ตัวกรองสแปมโดยการเลือกกล่องกาเครื่องหมาย และคลิกเสร็จสิ้นเพื่อดำเนินการลบอย่างสมบูรณ์ และออกจากโปรแกรมช่วยติดตั้ง',
    'ui__server/spam-filter/black-list/address/delete_unknown__description' => 'ลบที่อยู่ออกจากบัญชีดำทั่วทั้งเซิร์ฟเวอร์',
    'ui__server/spam-filter/black-list/address/delete_unknown__short-title' => 'ลบ',
    'ui__server/spam-filter/black-list/address/delete_unknown__title' => 'ลบที่อยู่ออกจากบัญชีดำทั่วทั้งเซิร์ฟเวอร์',
    'ui__server/spam-filter/black-list/address/delete_unknown__wizard-title' => 'การลบที่อยู่ออกจากบัญชีดำตัวกรองสแปมทั้วทั้งเซิร์ฟเวอร์',
    'ui__server/spam-filter/black-list/address/delete_unknown__wizard__4_unknown' => 'เลือกที่อยู่ตัวกรองสแปมที่คุณต้องการลบ และคลิกถัดไป >>',
    'ui__server/spam-filter/black-list/address/delete_unknown__wizard__5' => 'ยืนยันการลบที่อยู่ตัวกรองสแปมโดยการเลือกกล่องกาเครื่องหมาย และคลิกเสร็จสิ้นเพื่อดำเนินการลบอย่างสมบูรณ์ และออกจากโปรแกรมช่วยติดตั้ง',

    'ui__server/spam-filter/black-list/address/properties__addresses_available' => 'ที่อยู่อีเมลที่ไม่เหมือนใคร %1 เท่านั้นที่ได้จะได้เพิ่้มเข้าไป',
    'ui__server/spam-filter/black-list/address/properties__empty_content' => 'ไม่มีที่อยู่อีเมลในรายการ',
    'ui__server/spam-filter/black-list/address/properties__file_size' => 'ไม่สามารถอัพโหลดไฟล์ได้ ขนาดของไฟล์ที่ใหญ่ที่สุดที่สามารถอัพโหลดได้คือ %1',
    'ui__server/spam-filter/black-list/address/properties__invalid_addresses' => 'ที่อยู่อีเมลดังต่อไปนี้ไม่ถูกต้อง: %1.',

    'ui__server/spam-filter/black-list/address/properties_unknown-new__description' => 'เพิ่มที่อยู่ไปยังบัญชีดำ',
    'ui__server/spam-filter/black-list/address/properties_unknown-new__short-title' => 'เพิ่มที่อยู่',
    'ui__server/spam-filter/black-list/address/properties_unknown-new__title' => 'เพิ่มที่อยู่ไปยังบัญชีดำ',

    'ui__server/spam-filter/properties__description' => 'ติดตั้งตัวกรองสแปมทั่วทั้งเซิร์ฟเวอร์',

    'ui__server/spam-filter/properties__short-title' => 'การตั้งค่า',
    'ui__server/spam-filter/properties__title' => 'การตั้งค่าตัวกรองสแปม',

    'ui__server/spam-filter/toggle_disable__description' => 'ปิดการทำงานการกรองสแปมในระบบทั้งหมด',

    'ui__server/spam-filter/toggle_disable__short-title' => 'ปิดใช้งาน',
    'ui__server/spam-filter/toggle_disable__title' => 'ปิดการใช้งานการกรองสแปม',
    'ui__server/spam-filter/toggle_enable__description' => 'เปิดการใช้งานการกรองสแปมในระบบทั้งหมด',

    'ui__server/spam-filter/toggle_enable__short-title' => 'เปิดการใช้งาน',
    'ui__server/spam-filter/toggle_enable__title' => 'เปิดการใช้งานการกรองสแปม',
    'ui__server/spam-filter/toggle_unknown__description' => 'เปิดหรือปิดการใช้งานการกรองสแปมในระบบทั้งหมด',
    'ui__server/spam-filter/toggle_unknown__short-title' => 'เปิดหรือปิดการใช้งาน',
    'ui__server/spam-filter/toggle_unknown__title' => 'เปิดหรือปิดการกรองสแปม',
    'ui__server/spam-filter/toggle_unknown__wizard-title' => 'เปิดหรือปิดตัวกรองสแปม',

    'ui__server/spam-filter/white-list__description' => 'ตั้งบัญชี่ที่ปลอดภัยสำหรับตัวกรองสแปมทั่วทั้งเซิร์ฟเวอร์',
    'ui__server/spam-filter/white-list__short-title' => 'บัญชีที่ปลอดภั',
    'ui__server/spam-filter/white-list__title' => 'บัญชี่ที่ปลอดภัยของตัวกรองสแปมทั่วทั้งเซิร์ฟเวอร์',

    'ui__server/spam-filter/white-list/address__addresses_available' => 'ที่อยู่อีเมลที่ไม่เหมือนใคร %1 เท่านั้นที่ได้จะได้เพิ่้มเข้าไป',
    'ui__server/spam-filter/white-list/address__description' => 'ที่อยู่บัญชี่ที่ปลอดภัยของตัวกรองสแปม',

    'ui__server/spam-filter/white-list/address__empty_content' => 'ไม่มีที่อยู่อีเมลในรายการ',
    'ui__server/spam-filter/white-list/address__file_size' => 'ไฟล์ที่อัพโหลดยังว่าง',
    'ui__server/spam-filter/white-list/address__invalid_addresses' => 'ที่อยู่อีเมลดังต่อไปนี้ไม่ถูกต้อง: %1.',
    'ui__server/spam-filter/white-list/address__none-available' => 'ไม่มีที่อยู่ในบัญชี่ที่ปลอดภัยตัวกรองสแปมทั่วทั้งเซิร์ฟเวอร์',
    'ui__server/spam-filter/white-list/address__short-title' => 'ที่อยู่',
    'ui__server/spam-filter/white-list/address__title' => 'ที่อยู่บัญชี่ที่ปลอดภัย %1',
    'ui__server/spam-filter/white-list/address_unknown__description' => 'เพิ่มที่อยู่ไปยังบัญชี่ที่ปลอดภัย',
    'ui__server/spam-filter/white-list/address_unknown__short-title' => 'เพิ่มที่อยู่',
    'ui__server/spam-filter/white-list/address_unknown__title' => 'เพิ่มที่อยู่ไปยังบัญชี่ที่ปลอดภัย',

    'ui__server/spam-filter/white-list/address/delete__description' => 'ลบที่อยู่ %1 ออกจากบัญชี่ที่ปลอดภัยทั่วทั้งเซิร์ฟเวอร์',

    'ui__server/spam-filter/white-list/address/delete__short-title' => 'ลบ',
    'ui__server/spam-filter/white-list/address/delete__title' => 'ลบที่อยู่ %1 ออกจากบัญชี่ที่ปลอดภัยทั่วทั้งเซิร์ฟเวอร์',
    'ui__server/spam-filter/white-list/address/delete_multi__description' => 'ลบที่อยู่จากบัญชี่ที่ปลอดภัยทั่วทั้งเซิร์ฟเวอร์',

    'ui__server/spam-filter/white-list/address/delete_multi__short-title' => 'ลบ',
    'ui__server/spam-filter/white-list/address/delete_multi__title' => 'ลบที่อยู่จากบัญชี่ที่ปลอดภัยทั่วทั้งเซิร์ฟเวอร์',
    'ui__server/spam-filter/white-list/address/delete_multi__wizard-title' => 'การลบที่อยู่ออกจากบัญชี่ที่ปลอดภัยตัวกรองสแปมทั่วทั้งเซิร์ฟเวอร์',
    'ui__server/spam-filter/white-list/address/delete_multi__wizard__4_multi' => 'เลือกที่อยู่ตัวกรองสแปมที่คุณต้องการลบ และคลิกถัดไป >>',
    'ui__server/spam-filter/white-list/address/delete_multi__wizard__5_multi' => 'ยืนยันการลบที่อยู่ตัวกรองสแปมโดยการเลือกกล่องกาเครื่องหมาย และคลิกเสร็จสิ้นเพื่อดำเนินการลบอย่างสมบูรณ์ และออกจากโปรแกรมช่วยติดตั้ง',
    'ui__server/spam-filter/white-list/address/delete_unknown__description' => 'ลบที่อยู่จากบัญชี่ที่ปลอดภัยทั่วทั้งเซิร์ฟเวอร์',
    'ui__server/spam-filter/white-list/address/delete_unknown__short-title' => 'ลบ',
    'ui__server/spam-filter/white-list/address/delete_unknown__title' => 'ลบที่อยู่จากบัญชี่ที่ปลอดภัยทั่วทั้งเซิร์ฟเวอร์',
    'ui__server/spam-filter/white-list/address/delete_unknown__wizard-title' => 'การลบที่อยู่ออกจากบัญชี่ที่ปลอดภัยตัวกรองสแปมทั่วทั้งเซิร์ฟเวอร์',
    'ui__server/spam-filter/white-list/address/delete_unknown__wizard__4_unknown' => 'เลือกที่อยู่ตัวกรองสแปมที่คุณต้องการลบ และคลิกถัดไป >>',
    'ui__server/spam-filter/white-list/address/delete_unknown__wizard__5' => 'ยืนยันการลบที่อยู่ตัวกรองสแปมโดยการเลือกกล่องกาเครื่องหมาย และคลิกเสร็จสิ้นเพื่อดำเนินการลบอย่างสมบูรณ์ และออกจากโปรแกรมช่วยติดตั้ง',

    'ui__server/spam-filter/white-list/address/properties__addresses_available' => 'ที่อยู่อีเมลที่ไม่เหมือนใคร %1 เท่านั้นที่ได้จะได้เพิ่้มเข้าไป',
    'ui__server/spam-filter/white-list/address/properties__empty_content' => 'ไม่มีที่อยู่อีเมลในรายการ',
    'ui__server/spam-filter/white-list/address/properties__file_size' => 'ไม่สามารถอัพโหลดไฟล์ได้ ขนาดของไฟล์ที่ใหญ่ที่สุดที่สามารถอัพโหลดได้คือ %1',
    'ui__server/spam-filter/white-list/address/properties__invalid_addresses' => 'ที่อยู่อีเมลดังต่อไปนี้ไม่ถูกต้อง: %1.',

    'ui__server/spam-filter/white-list/address/properties_unknown-new__description' => 'เพิ่มที่อยู่ไปยังบัญชี่ที่ปลอดภัย',
    'ui__server/spam-filter/white-list/address/properties_unknown-new__short-title' => 'เพิ่มที่อยู่',
    'ui__server/spam-filter/white-list/address/properties_unknown-new__title' => 'เพิ่มที่อยู่ไปยังบัญชี่ที่ปลอดภัย',

    'ui__server/mail/statistics#apply__description' => "นำตัวกรองมาใช้",
    'ui__server/mail/statistics#apply__title' => "นำไปใช้",
    'ui__server/mail/statistics#custom_from__title' => "จาก",
    'ui__server/mail/statistics#custom_to__title' => "ถึง",
    'ui__server/mail/statistics#period_all__title' => "ทั้งหมด",
    'ui__server/mail/statistics#period_custom__title' => "กำหนดเอง",
    'ui__server/mail/statistics#period_month__title' => "เดือนปัจจุบัน",
    'ui__server/mail/statistics#period_prev_month__title' => "เดือนก่อนหน้านี้",
    'ui__server/mail/statistics#period_prev_week__title' => "สัปดาห์ก่อนหน้านี้",
    'ui__server/mail/statistics#period_today__title' => "วันนี้",
    'ui__server/mail/statistics#period_week__title' => "สัปดาห์ปัจจุบัน",
    'ui__server/mail/statistics#period_yesterday__title' => "เมื่อวาน",
    'ui__server/mail/statistics#show_for_period__title' => "แสดงสำหรับช่วงเวลา",
    'ui__server/mail/statistics#tools_legend__title' => "เครื่องมือ",
    'ui__server/mail/statistics__description' => "ดูสถิติสแปมและไวรัว",

    'ui__server/mail/statistics__short-title' => "สถิติ",
    'ui__server/mail/statistics__title' => "สถิติ",
    'ui__server/mail/statistics/spam#statistics_legend__title' => "สถิติสแปม",
    'ui__server/mail/statistics/spam#tools_legend__title' => "เครื่องมือ",
    'ui__server/mail/statistics/spam__description' => "ดูสถิติสแปม",

    'ui__server/mail/statistics/spam__short-title' => "สถิติสแปม",
    'ui__server/mail/statistics/spam__title' => "สถิติสแปม",
    'ui__server/mail/statistics/spam/recipients#list_header__name__title' => "Mailname",
    'ui__server/mail/statistics/spam/recipients#list_header__ratio__title' => "% ของทั้งหมด",
    'ui__server/mail/statistics/spam/recipients#list_header__sort_by_name__title' => "จัดเรียงโดยบัญชีเมล",
    'ui__server/mail/statistics/spam/recipients#list_header__sort_by_ratio__title' => "จัดเรียงโดย % ของทั้งหมด",
    'ui__server/mail/statistics/spam/recipients#list_header__sort_by_val__title' => "จัดเรียงโดยการได้รับสแปม",
    'ui__server/mail/statistics/spam/recipients#list_header__title' => "บัญชีเมล",
    'ui__server/mail/statistics/spam/recipients#list_header__val__title' => "ได้รับสแปม",
    'ui__server/mail/statistics/spam/recipients__description' => "ผู้รับ",

    'ui__server/mail/statistics/spam/recipients__short-title' => "ผู้รับ",
    'ui__server/mail/statistics/spam/recipients__title' => "ผู้รับ",
    'ui__server/mail/statistics/spam/summary#clean__title' => "สะอาด",
    'ui__server/mail/statistics/spam/summary#infected__title' => "ติดเชื้อ",
    'ui__server/mail/statistics/spam/summary#list_header__name__title' => "สถานะ",
    'ui__server/mail/statistics/spam/summary#list_header__ratio__title' => "% ของทั้งหมด",
    'ui__server/mail/statistics/spam/summary#list_header__val__title' => "การนับ",
    'ui__server/mail/statistics/spam/summary#protected__title' => "ป้องกันแล้ว",
    'ui__server/mail/statistics/spam/summary#skipped__title' => "ไม่ได้ตรวจสอบ",
    'ui__server/mail/statistics/spam/summary__description' => "สรุป",

    'ui__server/mail/statistics/spam/summary__short-title' => "สรุป",
    'ui__server/mail/statistics/spam/summary__title' => "สรุป",
    'ui__server/mail/statistics/virus#statistics_legend__title' => "สถิติไวรัส",
    'ui__server/mail/statistics/virus#tools_legend__title' => "เครื่องมือ",
    'ui__server/mail/statistics/virus__description' => "ดูสถิติไวรัส",

    'ui__server/mail/statistics/virus__short-title' => "สถิติไวรัส",
    'ui__server/mail/statistics/virus__title' => "สถิติไวรัส",
    'ui__server/mail/statistics/virus/recipients#list_header__name__title' => "บัญชีเมล",
    'ui__server/mail/statistics/virus/recipients#list_header__ratio__title' => "% ของทั้งหมด",
    'ui__server/mail/statistics/virus/recipients#list_header__sort_by_name__title' => "จัดเรียงโดยชื่อเมล",
    'ui__server/mail/statistics/virus/recipients#list_header__sort_by_ratio__title' => "จัดเรียงโดย % ของทั้งหมด",
    'ui__server/mail/statistics/virus/recipients#list_header__sort_by_val__title' => "จัดเรียงโดยการได้รับไวรัส",
    'ui__server/mail/statistics/virus/recipients#list_header__title' => "บัญชีเมล",
    'ui__server/mail/statistics/virus/recipients#list_header__val__title' => "ได้รับไวรัส",
    'ui__server/mail/statistics/virus/recipients__description' => "ผู้รับ",

    'ui__server/mail/statistics/virus/recipients__short-title' => "ผู้รับ",
    'ui__server/mail/statistics/virus/recipients__title' => "ผู้รับ",
    'ui__server/mail/statistics/virus/summary#clean__title' => "สะอาด",
    'ui__server/mail/statistics/virus/summary#infected__title' => "ติดเชื้อ",
    'ui__server/mail/statistics/virus/summary#list_header__name__title' => "สถานะ",
    'ui__server/mail/statistics/virus/summary#list_header__ratio__title' => "% ของทั้งหมด",
    'ui__server/mail/statistics/virus/summary#list_header__val__title' => "การนับ",
    'ui__server/mail/statistics/virus/summary#protected__title' => "ป้องกันแล้ว",
    'ui__server/mail/statistics/virus/summary#skipped__title' => "ไม่ได้ตรวจสอบ",
    'ui__server/mail/statistics/virus/summary__description' => "สรุป",

    'ui__server/mail/statistics/virus/summary__short-title' => "สรุป",
    'ui__server/mail/statistics/virus/summary__title' => "สรุป",
    'ui__server/mail/statistics/virus/viruses#list_header__name__title' => "ชื่อ",
    'ui__server/mail/statistics/virus/viruses#list_header__ratio__title' => "% ของทั้งหมด",
    'ui__server/mail/statistics/virus/viruses#list_header__sort_by_name__title' => "จัดเรียงโดยชื่อ",
    'ui__server/mail/statistics/virus/viruses#list_header__sort_by_ratio__title' => "จัดเรียงโดย % ของทั้งหมด",
    'ui__server/mail/statistics/virus/viruses#list_header__sort_by_val__title' => "จัดเรียงโดยออบเจ็กที่ติดไวรัส",
    'ui__server/mail/statistics/virus/viruses#list_header__title' => "ไวรัส",
    'ui__server/mail/statistics/virus/viruses#list_header__val__title' => "ออบเจ็กที่ติดไวรัส",
    'ui__server/mail/statistics/virus/viruses__description' => "ไวรัส",

    'ui__server/mail/statistics/virus/viruses__short-title' => "ไวรัส",
    'ui__server/mail/statistics/virus/viruses__title' => "ไวรัส",

    'ui__support#param_company__title' => "บริษท",
    'ui__support#param_email__title' => "อีเมล์",
    'ui__support#param_firstname__title' => "ชื่อแรก",
    'ui__support#param_keynumber__title' => "หมายเลขผลิตภัณฑ์",
    'ui__support#param_operatingsystem__title' => "ระบบปฏิบัติการ",
    'ui__support#param_phone__title' => "โทรศัพท์",
    'ui__support#param_psabuild__title' => "สร้าง Plesk",
    'ui__support#param_psainsttype__title' => "ประเภทการติดตั้ง Plesk",
    'ui__support#param_psaversion__title' => "เวอร์ชั่น Plesk",

    // *** The strings above have been generated automatically from @@CAPTION directives.

    ////
    //// UI POINTER CAPTIONS END HERE


    // RESELLERS

    // Resellers
    'ui__reseller#tools__title' => "เครื่องมือ",

    'ui__reseller/traffic-history_unknown__short-title' => "ดูทราฟฟิคโดยตัวแทนจำหน่าย",
    'ui__reseller/traffic-history_unknown__title' => "ดูทราฟฟิคโดยตัวแทนจำหน่าย",
    'ui__reseller/traffic-history_unknown__description' => "ดูทราฟฟิคของบัญชีตัวแทนจำหน่าย",
    'ui__reseller#list__title' => "ตัวแทนจำหน่าย",
    'accounts_list__name__filter_title' => "ชื่อ",
    'accounts_list__resource__filter_title' => "การใช้ทรัพยากร",
    'resellers_list__filter_resource_usage_any' => "ใดๆ",
    'resellers_list__filter_resource_usage_overuse' => "ใช้งานมากเกินไป",
    'resellers_list__filter_resource_usage_normal' => "ภายในขีดจำกัด",
    'accounts_list__status__filter_title' => "สถานะ",
    'resellers_list__filter_status_any' => "ใดๆ",
    'resellers_list__filter_status_blocked' => "ระงับชั่วคราวแล้ว",
    'resellers_list__filter_status_active' => "ใช้งานอยู่",
    'resellers_list__filter_clients__filter_title' => "แสดง",
    'resellers_list__filter_clients_on' => "ตัวแทนจำหน่ายกับลูกค้า",
    'resellers_list__filter_clients_off' => "ตัวแทนจำหน่ายเท่านั้น",
    '__disk_usage' => "พื้นที่ดิสก์ที่ใช้",
    'ui__reseller/traffic_unknown__short-title' => "ดูทราฟฟิคโดยตัวแทนจำหน่าย",
    'ui__reseller/traffic_unknown__title' => "ดูทราฟฟิคโดยตัวแทนจำหน่าย",
    'ui__reseller/traffic#list__title' => "ทราฟฟิคโดยตัวแทนจำหน่าย",
    'ui__reseller/traffic_unknown__description' => "ดูรายงานการใช้ทราฟฟิค",

    // Resellers > Traffic by resellers
    '__traffic_by_reseller' => "ทราฟฟิคโดยตัวแทนจำหน่าย",

    '__reseller_name' => "ชื่อตัวแทนจำหน่าย",
    '__reseller' => "ตัวแทนจำหน่าย",
    'resellertrafficlist_header' => "ดูทราฟฟิคโดยตัวแทนจำหน่าย",
    '__reseller_personal' => "ทราฟฟิคที่ใช้โดยโดเมนของตัวแทนจำหน่าย",
    'ui__reseller/traffic-history__short-title' => "ทราฟฟิคโดยตัวแทนจำหน่าย",
    'ui__reseller/traffic-history__title' => "ทราฟฟิคโดยตัวแทนจำหน่าย",
    'ui__reseller/traffic-history__description' => "ดูรายงานการใช้ทราฟฟิค",

    // Resellers > Create Reseller Account
    'ui__reseller__short-title' => "%1",

    // Resellers > Reseller preferences

    // Resellers > Reseller Account Templates

    // Resellers > Reseller Account Templates > Create Reseller Account Template
    'limits__oversell_text' => "อนุญาตให้ขายเกินกว่าจำนวนที่ผลิตได้",
    'limits__reseller_oversell_description' => "การขายเกินกว่าจำนวนที่ผลิตได้ให้ตัวแทนจำหน่ายขายทรัพยากรได้มากกว่าที่ได้รับการจัดสรร หากอนุญาตให้ทำได้ ตัวแทนจำหน่ายจะอยู่ภายใต้การใช้ทรัพยากรจริงแทนที่กาจัดสรรทรัพยากร",
    'limits__overuse_block_text' => "นโยบายสำหรับการใช้งานมากเกินไป",
    'limits__overuse_block_true_text' => "ไม่อนุญาตให้ใช้มากเกินไป",
    'limits__reseller_overuse_block_true_description' => "บล็อคการใช้ทรัพยากรเกิน การใช้ทรัพยากรจริงไม่สามารถเกินกว่าค่าค่าที่ได้รับการจัดสรรไว้เริ่มต้น",
    'limits__overuse_block_false_text' => "อนุญาตให้ใช้มากเกินไป",
    'limits__reseller_overuse_block_false_description' => "ห้ามบล็อคการใช้ทรัพยากรเดิน อนุญาตให้ตัวแทนจำหน่ายใช้ทรัพยากรมากกว่าค่าเริ่มต้นที่ให้ไว้ การใช้ทรัพยากรจริงเกินกว่าค่าที่ได้รับการจัดสรรไว้เริ่มต้น",
    'limits__reseller_overuse_notify_text' => "แจ้งเตือนตัวแทนจำหน่ายเกี่ยวกับการถึงขีดจำกัดของทรัพยากร",
    'reseller_perm__manage_sh_access_disabled' => "ตัวแทนจำหน่ายไม่สามารถอนุญาตหรือห้ามการเข้าถึงเชลล์ได้",
    'reseller_perm__manage_sh_access_chrooted' => "ตัวแทนจำหน่ายสามรถอนุญาตให้เข้าถึงสภาพแวดล้อม Chrooted",
    'reseller_perm__manage_sh_access_any' => "ตัวแทนจำหน่ายสามารถอนุญาตให้เข้าถึงเชลล์ประเภทใดๆ ก็ได้",
    'template__reseller_num_excl_ips' => "จัดสรร IP แอดเดรสเฉพาะให้ตัวแทนจำหน่าย",

    // Reseller's Home page
    'ui__reseller#tools2__title' => "บัญชี",
    'ui__reseller#info__title' => "ข้อมูล",
    'ui__reseller#clientsTab__title' => "ลูกค้า",
    'ui__reseller#domainsTab__title' => "โดเมน",
    'ui__reseller__title' => "จัดการบัญชีตัวแทนจำหน่าย %1",
    'domains__reseller_info' => "%1 ลูกค้า %2 โดเมน %3 พื้นที่ดิสก์ที่ใช้ %4 ข้อมูลที่โอนถ่าย",
    'domains__reseller_info_hiding_traffic' => "%1 ลูกค้า %2 โดเมน %3 พื้นที่ดิสก์ที่ใช้",
    'ui__reseller__description' => "จัดการบัญชีตัวแทนจำหน่าย",

    'ui__reseller/limits_unknown__wizard-title' => 'ดูหรือเปลี่ยนแปลงขีดจำกัดของทรัพยากรสำหรับตัวแทนจำหน่าย',
    'ui__reseller/limits_unknown__wizard__1_unknown' => 'เลือกตัวแทนจำหน่ายที่คุณต้องการ',
    'ui__reseller/limits_unknown__wizard__2' => 'เพื่อนำการเปลี่ยนแปลงไปใช้ ให้คลิกเสร็จสิ้น',

    'ui__client/report_reseller__short-title' => "รายงาน",
    'ui__client/report_reseller__title' => "ดูรายงานบัญชี",
    'ui__client/report_reseller__description' => "ดูรายงานของบัญชีตัวแทนจำหน่าย",
    'ui__client/ip-pool_reseller__short-title' => "IP กลุ่ม",
    'ui__client/ip-pool_reseller__description' => "กำหนด IP แอดเดรส และการรับรอง SSL/TLS ไปยังบัญชีตัวแทนจำหน่าย",

    //'ui__client/preferences_reseller__short-title' => "Settings",
    //'ui__client/preferences_reseller__description' => "Set Plesk session settings.",

    'ui__reseller/preferences_unknown__wizard__2_self' => "ระบุการตั้งค่าบัญชีและคลิกปุ่มเสร็จสิ้น",

    //'ui__client/permissions_reseller__short-title' => "Permissions",
    //'ui__client/permissions_reseller__description' => "View or change permissions for the reseller's account.",

    'ui__reseller/permissions_unknown__wizard-title' => 'ดูหรือเปลี่ยนแปลงการอนุญาตสำหรับตัวแทนจำหน่าย',
    'ui__reseller/permissions_unknown__wizard__1_unknown' => 'เลือกตัวแทนจำหน่ายซึ่งคุณต้องการดูหรือเปลี่ยนแปลงการอนุญาต',
    //'ui__reseller/permissions_unknown__wizard__1/properties_self' => 'When done with viewing your permissions, click Finish to to apply the changes and exit the wizard.',
    'ui__reseller/permissions_unknown__wizard__2' => 'เมื่อทำการเปลี่ยนแปลงเสร็จสิ้นการอนุญาตให้ตัวแทนจำหน่ายแล้ว ให้คลิกเสร็จสิ้นเพื่อนำการเปลี่ยนแปลงไปใช้ และออกจากโปรแกรมช่วยติดตั้ง',

    // Customers > create customer account

    '__resellers_list' => 'ตัวแทนจำหน่าย',
    'picker_reseller__title' => 'เลือกตัวแทนจำหน่าย',

    // Resellers > reseller name > customer name
    'ui__client#tools1__title' => "เครื่องมือ",
    'ui__client#tools2__title' => "บัญชี",
    'ui__client#info__title' => "ข้อมูล",
    'ui__client#clientslist__title' => "ลูกค้า",
    'ui__client#domainslist__title' => "โดเมน",

    // Reseller's session in the Customer Panel - Home page

    'feature__aps_categories__reseller' => "แอพพลิเคชั่นเว็บทั้งหมดได้รับการจัดเรียงโดยประเภทอยู่ในขณะนี้ ซึ่งจะช่วยให้ง่ายต่อการเลือกแอพพลิเคชั่นที่เหมาะสมในการติดตั้ง",
    'feature__domainkeys__reseller' => "คุณสามารถใช้ระบบตรวจสอบผู้ส่งอีเมล DKIM เพื่อลดจำนวนสแปมและอีเมลฟิชชิ่งได้",

    '__reseller_form' => "ตัวแทนจำหน่ายจาก",

    // Reseller's session in the control panel - Home page > Manage Customer Settings
    'ui__client/preferences_unknown__wizard__reseller' => "เลือกบัญชีลูกค้าที่มีการตั้งค่า่ที่คุณต้องการเปลี่ยน",

    // Reseller's session in the control panel - Home page > Suspend/Activate Customer Account

    // Reseller's session in the control panel - Home page > Change Customer Limits
    'ui__client/limits_unknown__wizard__1' => "เพื่อเปลี่ยนแปลงขีดจำกัดการใช้ทรัพยากร ให้คลิกขีดขำกัดทรัพยากร",

    // Reseller's session in the control panel - Home page > Change Customer Permissions
    'ui__client/permissions_unknown__wizard__1' => "คลิก Permission เพื่อเปลี่ยนการอนุญาตให้ดำเนินการของลูกค้าใน Plesk",

    // Reseller's session in the control panel - Home page > Create Customer Template
    'template__shared_text' => "ทำให้ผู้ใช้อื่นสามารใช้แม่แบบนี้",
    'template__shared_description' => "เลือกตัวเลือกนี้ หากคุณต้องการให้ลูกค้าสามารถใช้แม่แบบนี้",

    // CLIENT (updated for reseller feature):

    // Customers
    'ui__client#tools__title' => 'เครื่องมือ',

    'ui__client/traffic-history_unknown__short-title' => 'ดูทราฟฟิคโดยลูกค้า',
    'ui__client/traffic-history_unknown__title' => 'ทราฟฟิคโดยลูกค้า',
    'ui__client/traffic-history_unknown__description' => 'ดูรายงานการใช้ทราฟฟิคสำหรับลูกค้าทั้งหมด',
    'ui__client/traffic-history__short-title' => 'ทราฟฟิคโดยลูกค้า',
    'ui__client/traffic-history__title' => 'ดูทราฟฟิคโดยลูกค้า',
    'ui__client/traffic-history__description' => 'ดูรายงานการใช้ทราฟฟิคสำหรับลูกค้าทั้งหมด',

    'ui__client/traffic#list__title' => 'ทราฟฟิคโดยลูกค้า',
    'ui__reseller/client/traffic#list__title' => 'ทราฟฟิคโดยลูกค้า',

    'clients_list__filter_type__filter_title' => 'แสดง',
    'clients_list__filter_type_any' => 'ลูกค้าและตัวแทนจำหน่าย',
    'clients_list__filter_type_clients' => 'เฉพาะลูกค้า',
    'clients_list__filter_type_resellers' => 'ตัวแทนจำหน่ายเท่านั้น',
    'ui__client/domain_unknown-new__short-title' => "สร้างโดเมน",

    // Customers > View traffic by customers
    '__personal' => "ทราฟฟิคที่ใช้โดยโดเมนของผู้ใช้",
    'PersonalTrafficList_header_of_client__' => "ดูรายงานการใช้ทราฟฟิคสำหรับบัญชีของคุณ",

    // DOMAINS

    // Domain > Domain Admin Permissions

    'domain_perm__manage_sh_access_disabled' => "ผู้ดูแลโดเมนไม่สามารถอนุญาตหรือห้ามการเข้าถึงเชลล์ได้",
    'domain_perm__manage_sh_access_chrooted' => "ผู้ดูแลระบบโดเมนสามารถให้การอนุญาตการเข้าถึงสภาพแวดล้อม chrooted เท่านั้น",
    'domain_perm__manage_sh_access_any' => "ผู้ดูแลระบบโดเมนสามารถให้การอนุญาตการเข้าถึงเชลล์ประเภทใดๆ ก็ได้",

    // APS Catalog
    'bt_add_to_vault' => "เพิ่มไปยังตู้นิรภัย",
    'bt_hide_updates' => "ซ่อนการอัพเดทที่มี",
    'bt_show_updates' => "แสดงการอัพเดทที่มี",

    '__site_apps__applications' => "แอพพลิเคชั่น",
    //search elements
    // Application; Vendor; Packager; Certification level;

    '__site_apps__apps_selected_to_add_to_vault' => "แอพพลิเคชั่นที่เลือกสำหรับการเพิ่มไปยังตู้นิรภัย",
    'site_apps__application_selected' => "เลือกแล้ว",
    'site_apps__currently_in_vault' => "มีเวอร์ชั่นอื่นในตู้นิรภัยแล้ว",
    'site_apps__new_versions' => "เวอร์ชั่นใหม่:",
    'site_apps__patches' => "แพทช์:",
    'site_apps__applications_have_been_scheduled_for_adding_to_application_vault' => "จำนวนของแอพพลิเคชั่นที่ตั้งตารางไว้สำหรับเพิ่ไปยังตู้นิรภัย: %1",
    'site_apps__applications_downloading_now' => "กำลังดาวน์โหลดแอพพลิเคชั่นดังต่อไปนี้: %1", // temporary workaround string, to be removed later

    'site_apps__package_already_exist_in_vault' => "อยู่ในตู้นิรภัยแล้ว",

    // Server > Action Log
    'bt_skin_edit' => "แก้ไขรายละเอียดสกิน",
    'domains__you_want_change_the_status_of_the_reseller??' => "คุณแน่ใจหรือไม่ว่าต้องการดำเนินการนี้?",
    'limits__oversell_legend' => "การขายเกินกว่าจำนวนที่ผลิตได้",
    'limitsManager__limit_available_error' => "ไม่สามารถจัดสรรจำนวนทรัพยากร (%%quantity%% %%limitName%%) ได้ มีเฉพาะ %%available%% %%limitName%% เท่านั้น",
    'limitsManager__limit_reserved_error' => "ไม่สามารถตั้งขีดจำกัดการใช้ทรัพยากรที่จำเป็นได้ (%%quantity%% %%limitName%%) เนื่องจากค่าใหม่มีค่าน้อยกว่าจำนวนของทรัพยากรที่สงวนไว้สำหรับลูกค้าของคุณ หรือที่ใช้โดยตัวคุณ (%%reserved%% %%limitName%%)",
    'limitsManager__limit_used_error' => "ไม่สามารถตั้งขีดจำกัดการใช้ทรัพยากรที่จำเป็นได้ (%%quantity%% %%limitName%%) เนื่องจากค่าใหม่มีค่าน้อยกว่าจำนวนของทรัพยากรที่สงวนไว้สำหรับลูกค้าของคุณ หรือที่ใช้โดยตัวคุณ (%%used%% %%limitName%%)",

    'ui__client/domain/traffic#list__title' => "การใช้งานแบนด์วิธโดยบริการ",

    'ui__client/domain/traffic_unknown-reseller__short-title' => "ดูรายงานการใช้ทราฟฟิค",
    'ui__client/domain/traffic_unknown-reseller__title' => "ดูรายงานการใช้ทราฟฟิค",

    'ui__client/domain_new__short-title' => "สร้างโดเมน",

    'ui__client_reseller__description' => "จัดการบัญชีตัวแทนจำหน่าย %1",
    'ui__client_reseller__short-title' => "%1",
    'ui__client_reseller__title' => "จัดการบัญชีตัวแทนจำหน่าย",

    '__owner_name' => "ชื่อเจ้าของ",
    'domains_list__resource__filter_title' => "การใช้ทรัพยากร",

    // APS CATALOG
    'site_apps__application_catalog_preferences' => "แคตาล็อคแอพพลิเคชั่น APS",
    'site_apps__applications_have_updates' => "มีเวอร์ชั่นอัพเดทของแอพพลิเคชั่นดังต่อไปนี้: \n%1\nเพื่อดูการอัเพดท ตรวจสอบให้แน่ใจว่า มีพื้นที่การค้นหา เลือกกล่องกาเครื่องหมาย <b>แสดงอัพเดทเท่านั้น</b> และค้นหาแอพพลิเคชั่นที่คุณต้องการ",
    'site_apps__progress_adding_to_vault' => "การเพื่อไปยังตู้นิรภัย:",
    'site_apps__progress_done_message' => "ความก้าวหน้า:",
    'site_apps__progress_applications_left' => "%1 ของ %2 แอพพลิเคชั่นที่เหลือ",
    'site_apps__download_item_long_task_title' => "ดาวน์โหลดแอพพลิเคชั่น APS (%1)",
    'site_apps__download_transaction_long_task_title' => "ดาวน์โหลดแอพพลิเคชั่น APS จากแคตาล็อค APS",
    'site_apps__last_check_for_updates' => "ตรวจสอบครั้งล่าสุดสำหรับการอัพเดท: %1",
    'site_apps__all_sucessfully_added_to_app_vault' => "แอพพลิเคชั่นที่ตั้งตารางไว้ทั้งหมดได้เพิ่มเข้าไปยังตู้นิรภัยของแอพพลิเคชั่นสำเร็จแล้ว",
    'site_apps__number_of_apps_sucessfully_added_to_app_vault' => "เพิ่มแอพพลิเคชั่นตามตาราง %1 ไปยังตู้นิรภัยของแอพพลิเคชั่นสำเร็จแล้ว",
    'site_apps__no_search_results' => 'ไม่สามารถติดตั้งแอพพลิเคชั่นเว็บ มีการติดตั้งแอพพลิเคชั่นเว็บอื่นในสารบบรากของโดเมนนี้แล้ว โปรดพิจารณาการสร้างซับโดเมนสำหรับแอพพลิเคชั่นเว็บ',
    'site_apps__search_results_title' => 'ผลการค้นหา',
    '__site_apps__search_by_application' => 'ชื่อแอพพลิเคชั่น',
    '__site_apps__search_by_vendor' => 'ผู้จัดจำหน่าย',
    '__site_apps__search_by_vendor__all' => 'ผู้ขายทั้งหมด',
    '__site_apps__search_by_packager' => 'ผู้บรรจุ',
    '__site_apps__search_by_certification_level' => 'ระดับการรับรอง',
    '__site_apps__search_by_cert__any' => 'ใดๆ',
    '__site_apps__search_by_cert__silver_and_higher' => 'ระดับเงินหรือมากกว่า',
    '__site_apps__search_by_cert__gold_and_higher' => 'ระดับทองหรือมากกว่า',
    '__retry' => 'ลองใหม่',
    'site_apps__application_packager_site' => 'ผู้บรรจุ',
    'site_apps__add_to_pool_message' => "แอพพลิเคชั่นที่หมายหัวว่า \"available for all\" จะถูกแจกจ่ายไปยังตัวแทนจำหน่ายและลูกค้าทั้งหมดโดยอัตโนมัติด้วยจำนวนการติดตั้งที่ไม่มีจำกัด แอพพลิเคชั่นหวงห้ามจะถูกแจกจ่ายไปยังตัวแทนจำหน่ายและลูกค้าทั้งหมดด้วยตัวเองบนความสัมพันธ์ส่วนบุคคลด้วยจำนวนการติดตั้งที่ระบุมาให้",
    'site_apps__make_available_for_all' => "ทำให้แอพพลิเคชั่นใช้ได้กับผู้ใช้ทั้งหมด",

    'site_apps__broadcast_app_text' => "แอพพลิเคชั่นที่หมายหัวว่า \"available for all\" จะถูกแจกจ่ายไปยังตัวแทนจำหน่ายและลูกค้าทั้งหมดโดยอัตโนมัติด้วยจำนวนการติดตั้งที่ไม่มีจำกัด แอพพลิเคชั่นหวงห้ามจะถูกแจกจ่ายไปยังตัวแทนจำหน่ายและลูกค้าทั้งหมดด้วยตัวเองบนความสัมพันธ์ส่วนบุคคลด้วยจำนวนการติดตั้งที่ระบุมาให้",
    'site_apps__broadcast_app_name' => 'ทำให้แอพพลิเคชั่นใช้ได้กับผู้ใช้ทั้งหมด',

    // User Application Pool per application
    'site_apps__available_clients' => 'ผู้ใช้ที่มี',
    'site_apps__no_more_clients_to_add_to_pool' => 'ไม่มีผู้ใช้บัญชีนี้ที่คุณสามารถให้แอพพลิเคชั่นนี้อีกต่อไป',

    // Installed application instances
    'site_apps__installations' => 'การติดตั้ง',

    // Hosting setup redesign
    '__domain_name_and_ip_address' => "ชื่อโดเมนและ IP แอดเดรส",
    '__assign_ip_address' => "กำหนด IP แอดเดรส",
    '__switch_on_service' => "เปิดบริการ",
    '__hosting_configuration' => "การปรับตั้งค่าโฮสติ้ง",
    '__vrt_hst' => "การโฮสต์เว็บไซต์",
    '__vrt_hst_hint' => "โฮสต์เว็บไซต์นี้ในเซิร์ฟเวอร์นี้",
    '__fwd' => "การส่งต่อ",
    '__web_hosting_settings' => "การตั้งค่าโฮสติ้ง",
    '__fwd_hint' => "นำผู้เยี่ยมชมไปยังเว็บไซต์อื่น",
    '__none_hint' => "ห้ามโฮสต์เว็บไซต์ในตอนนี้",
    '__login_hint' => "ชื่อผู้ใช้นี้ใช้ในการเข้าถึงเว็บไซต์ของคุณผ่าน FTP",
    '__password_hint' => "รหัสผ่านนี้ใช้ในการเข้าถึงเว็บไซต์ของคุณผ่าน FTP",
    '__advanced_hosting_setup' => "ตั้งค่าการตั้งค่าการโฮสติ้งเว็บไซต์ขั้นสูง",
    '__domain_creation_successful' => "สร้างโดเมนแล้ว",
    'bt_hosting_settings' => "การตั้งค่าโฮสติ้ง",
    '__change_hosting_type' => "เปลี่ยนประเภทโฮสติ้งสำหรับโดเมน %1",
    '__hosting_type_change_warning' => "เมื่อคุณเปลี่ยนประเภทของโฮสติ้งเพื่อส่งต่อ หรือไม่มีโฮสติ้ง ไฟล์และสารบบทั้งหมดที่เกี่ยวข้องกับเว็บไซต์ของคุณจะได้รับการลบออกจากเซิร์ฟเวอร์ ตรวจสอบให้แน่ใจว่า ได้บันทึกสำเนาเว็บไซต์ของคุณไว้ในเครื่อง",
    '__current_hosting_type' => "ประเภทของโฮสติ้งปัจจุบน",
    '__new_hosting_type' => "เครือข่าย",
    '__fwd_settings' => "การตั้งค่าการส่งต่อ",
    '__fwd_settings_legend' => "การตั้งค่าการส่งต่อ",
    '__fwd_destination_url' => "URL ปลายทาง",
    '__fwd_type' => "ประเภทการส่งต่อ",
    '__fwd_type_standart' => "การส่งต่อแบบมาตรฐาน",
    '__fwd_type_standart_hint' => "นำผู้เยี่ยมชมไปยังเว็บไซต์อื่น และแสดงที่อยู่ปลายทาง เพื่อให้ทราบว่ากำลังถูกโอนไปยังเว็บอื่น",
    '__fwd_type_frame' => "การส่งต่อเฟรม",
    '__fwd_type_frame_hint' => "เปลี่ยนเส้นทางผู้เยี่ยมชมเว็บไซต์ไปยังไซต์อื่นๆ แต่จะไม่มีการแสดงที่อยู่ปลายทางดังนั้นผู้เยี่ยมชมจึงไม่รู้เกี่ยวกับการเปลี่ยนทิศทาง",
    '__hosting_type_template_warning' => "ประเภทการโฮสติ้งที่คุณเลือกแตกต่างจากประเภทที่ระบุในแม่แบบ หากคุณดำเนินการต่อ การตั้งค่าการโฮสติ้งเว็บในแม่แบบที่เลือกจะถูกเมินเฉย คุณแน่ใจหรือไม่ว่าคุณต้องการตั้งค่าประเภทการโฮสติ้งที่เลือก",

    '__no_resellers_selected' => "คุณต้องเลือกบัญชีผู้แทนจำหน่ายอย่างน่อยหนึ่งบัญชี",

    'ui__client/logo_unknown__wizard-title' => 'ตั้งค่าโลโก้',
    'ui__client/logo_unknown__wizard__1_unknown' => 'โปรดเลือกลูกค้าที่มีคุณสมบัติโลโก้ที่คุณต้องการเปลี่ยนแปลง',
    'ui__client/logo_unknown__wizard__2' => 'คลิกเสร็จสิ้นเพื่อนำการเปลี่ยนแปลงไปใช้',
    'ui__client/logo_unknown__wizard__2_self' => 'คลิกเสร็จสิ้นเพื่อนำการเปลี่ยนแปลงไปใช้',

    'ui__client/ipaddress/properties_new__short-title' => "เพิ่ม IP แอดเดรส",
    'ui__client/ipaddress/properties_new__title' => 'เพิ่ม IP แอดเดรส',
    'ui__client/ipaddress/properties_new__description' => "เพิ่ม IP แอดเดรส",
    'ui__client/ipaddress/properties_unknown-new__short-title' => "เพิ่ม IP แอดเดรส",
    'ui__client/ipaddress/properties_unknown-new__title' => "เพิ่ม IP แอดเดรส",
    'ui__client/ipaddress/properties_unknown-new__description' => "เพิ่ม IP แอดเดรส",
    'ui__client/ipaddress/delete_multi__short-title' => "ลบ IP แอดเดรส",
    'ui__client/ipaddress/delete_multi__description' => "ลบ IP แอดเดรส",
    'ippool_Manager__no_available_ips' => "ไม่มี IP แอดเดรสว่างใน IP กลุ่ม",
    'ippool_Manager__ip_shared' => "ใช้ร่วมกัน",
    'ippool_Manager__ip_exclusive' => "เฉพาะ",
    'ui__client/ipaddress/properties__title' => "จัดการ IP แอดเดรส",
    'ui__client/ipaddress/properties__description' => "ดูหรือเปลี่ยนแปลงคุณสมบัติของ IP แอดเดรส",
    'ui__client/ipaddress_unknown-new__title' => "เพิ่ม IP แอดเดรส",
    'ui__client/ipaddress_unknown-new__short-title' => "เพิ่ม IP แอดเดรส",
    'ui__client/ipaddress_unknown-new__description' => "เพิ่ม IP แอดเดรส",

    'ui__mass-mail#to_resellers_text__title' => "ตัวแทนจำหน่าย",
    'ui__mass-mail#to_domainusers_text__title' => "ผู้ดูแลระบบโดเมน",
    'ui__mass-email#tools_legend__title' => "เครื่องมือ",
    'ui__mass-email#list_legend__title' => 'แม่แบบข้อความอีเมลจำนวนมาก',
    'ui__mass-email#template_legend__title' => "แม่แบบ",
    'ui__mass-email#from_email_text__title' => "จาก",
    'ui__mass-email#to_text__title' => 'ถึง',
    'ui__mass-email#to_resellers_text__title' => "ตัวแทนจำหน่าย",
    'ui__mass-email#to_clients_text__title' => "ลูกค้า",
    'ui__mass-email#to_domainusers_text__title' => "ผู้ดูแลระบบโดเมน",
    'ui__mass-email#to_admin_text__title' => "ผู้ดูแลระบบ Plesk",
    'ui__mass-email#option_mode_all__title' => "ทั้งหมด",
    'ui__mass-email#option_mode_select__title' => "ที่เลือกเท่านั้น",
    'ui__mass-email#option_mode_except__title' => "ทั้งหมดยกเว้นที่เลือก",
    'ui__mass-email#option_select_template__title' => '---เลือกแม่แบบ---',
    'ui__mass-email#subject_text__title' => "ชื่อเรื่อง",
    'ui__mass-email#body_text__title' => "ข้อความตัวอักษร",
    'ui__mass-email#save_as_legend__title' => "บันทึกเป็นแม่แบบ",
    'ui__mass-email#save_as_text__title' => "บันข้อความที่เขียนไปยังแม่แบบใหม่ที่ตั้งชื่อ",
    'ui__reseller/preferences_unknown__wizard-title' => "เปลี่ยนการตั้งค่าบัญชี",
    'ui__reseller/preferences_unknown__wizard__1_unknown' => "เลือกตัวแทนจำหน่ายซึ่งมีการตั้งค่าบัญชีที่คุณต้องการเปลี่ยน และคลิกถัดไป",
    'ui__reseller/preferences_unknown__wizard__2' => "ระบุการตั้งค่าบัญชีและคลิกปุ่มตกลง",
    'ippoolManager__ip_shared' => "ใช้ร่วมกัน",
    'ippoolManager__ip_exclusive' => "เฉพาะ",

    '__users_list' => "ผู้ใช้",
    '__users' => "ผู้ใช้",
    '__user_name' => "ชื่อผู้ใช้",

    'limit__name_max_dom_aliases' => "โดเมนนามแฝง",
    'limit__name_max_subftp_users' => "บัญชี FTP เพิ่มเติม",
    'limit__name_max_mssql_db' => "ฐานข้อมูลเซิร์ฟเวอร์ Microsoft SQL",
    'limit__name_max_iis_app_pools' => "แอพพลิเคชั่นกลุ่ม IIS",
    'limit__name_max_odbc' => "การเชื่อมต่อ ODBC",
    'total_mboxes_quota_unsupported' => 'ไม่รองรับเซิร์ฟเวอร์เมล',
    'limit_soft__disk_space' => 'แจ้งเตือนหากพื้นที่ดิสก์ใกล้เต็ม',
    'limit_soft__max_traffic' => 'แจ้งเตือนหากทราฟฟิคใกล้เต็ม',
    'limitsManager__commit_failed' => "ไม่สามารถเปลี่ยนแปลงขีดจำกัดของทรัพยากรได้",
    'limitsManager__date_in_past' => "วันหมดอายุไม่ถูกต้อง %1",
    'limitsManager__limit_not_supported' => "ไม่สามารถตั้งค่าขีดจำกัดสำหรับประเภททรัพยากร %1",
    'limitsManager__limit_oversell_inconsistency' => "ไม่สามารถจัดสรรจำนวนทรัพยากรที่มีการปิดการขายเกินกว่าที่ผลิตได้",
    'limitsManager__limit_overuse_inconsistency' => "การใช้ทรัพยากรเกิดกว่าขีดจำกัดที่กำหนด",
    'limitsManager__no_resource_available' => "ไม่ทรัพยากรสำหรับประเภท (%%limitName%%) นี้เหลือ ที่ร้องขอ: %%quantity%%; available: %%unused%%.",
    'limitsManager__no_total_resource_available' => "ไม่ทรัพยากรสำหรับประเภท (%%limitName%%) นี้จากผู้ให้บริการของคุณ ที่ร้องขอ: %%quantity%%; available: %%unused%%.",
    'limitsManager__invalid_expiration_limit' => "วันหมดอายุต้องไม่น้อยกว่าหรือเท่ากับ %1",
    'limitsManager__invalid_disk_space_limit' => "จำนวนพื้นที่ดิสก์ต้องไม่น้อยกว่าหรือเท่ากับ %1",
    'limitsManager__invalid_max_traffic_limit' => "จำนวนของทราฟฟิคต้องไม่น้อยกว่าหรือเท่ากับ %1",
    'ippoolManager__ip_has_suballocations' => "ไม่สามารถเปลี่ยนแปลงประเภทของ IP แอดเดรสที่จัดสรรไว้สำหรับผู้ใช้ มีการจัดสรร IP แอดเดรส %%ip%% ไปยังผู้ใช้เป็นแบบ IP แอดเดรส %%reserved%%",
    'ippoolManager__ip_is_already_in_pool' => "IP แอดเดรสไปรับการกำหนดไปยงผู้ใช้แล้ว",
    'ippoolManager__ip_is_not_in_pool' => "ไม่มี IP แอดเดรส %%ip%% ในกลุ่ม",
    'ippoolManager__can_not_allocate_ip' => "IP แอดเดรส %%ip%% มีเฉพาะที่เป๋น %%available%%",
    'ippoolManager__unable_to_set_default_type' => "IP แอดเดรส %%ip%% ไม่สามารถจัดสรรตามที่ระบุได้",
    'ippoolManager__ip_used_by_hst_or_frw' => "IP แอดเดรส %%ip%% ใช้เป็นโฮสติ้งแล้ว",
    'ippoolManager__active_anon_ftp_on_ip' => "การเข้าถึง FTP นิรนามได้รับการเปิดแล้วสำหรับ IP แอดเดรส %%ip%%",
    'ippoolManager__no_vacant_ips' => "ไม่มี IP แอดเดรสว่าง",
    'ippoolManager__no_available_ips' => "ไม่มี IP แอดเดรส",
    'templates__dublicate_name' => "แม่แบบที่มีชื่อนั้นมีอยู่แล้ว โปรดเลือกชื่ออื่นสำหรับแม่แบบนี้",
    'cl_perm__client_limits_exceeded' => "ค่าขีดจำกัดของทรัพยากรที่ระบุเกินกว่าค่าที่ได้รับตามแผนโฮสติ้ง หรือค่าที่ให้เหล่านี้น้อยกว่าทรัพยากรที่ใช้โดยเว็บไซต์ของคูณ",
    'cl_perm__reseller_limits_exceeded' => "ค่าขีดจำกัดของทรัพยากรที่ระบุเกินกว่าค่าที่ได้รับอนุญาตตามแผนโฮสติ้ง หรือค่าที่ให้เหล่านี้น้อยกว่าทรัพยากรที่ใช้โดยเว็บไซต์ของคูณ",

    'site_apps__preferences_show_all_versions_title' => "แสดงรายการเต็มของเวอร์ชั่นสำหรับแต่ละแอพพลิเคชั่นที่เรียกคืนจากแคตาล็อค",
    'site_apps__preferences_show_all_versions_hint' => "หากเลือกตั้งเลือกนี้ อาจจะมีการใช้เวลาพอสมควรในการเรียกคืนเวอร์ชั่นของแต่ละแอพพลิเคชั่นในทุกครั้งที่คุณเปิดแคตาล็อคพอสมควร หากไม่เลือกตัวเลือกนี้ จะแสดงเพียงแค่เวอร์ชั่นล่าสุดเท่านั้น",
    '__select_user_template' => "สร้างบัญชีผู้ใช้จากแม่แบบ",
    'ip_already_added_to_all_clients' => "IP แอดเดรสนี้ได้รับการกำหนดไปยังผู้ใช้ทั้งหมด",
    'ui__server/ip-address/client/delete#legend__description' => "IP แอดเดรส ดังต่อไปนี้จะได้รับการลบออกจากระบบและ IP กลุ่มของผู้ใช้:",

    'site_apps__cancelled_apps' => "คุณได้ทำการยกเลิกแอพพลิเคชั่นดังต่อไปนี้เพิ่มเติม: %2",

    'sb_url_is_not_resolved' => 'URL ไม่สามารถแยกแยะได้: ตรวจสอบการตั้งค่า DNS ของคุณ: URL %1 ต้องแยกใน IP แอดเดรสของเซิร์ฟเวอร์ด้วย Presence Builder ที่ติดตั้งแล้ว',

    'ip_addr__is_last_on_interface' => 'ไม่สามารถลบ IP แอดเดรส %%ip%% ได้ เนื่องจากเป็น IP แอดเดรสสุกท้ายที่แสดงบนหน้าจอเครือข่าย',
    'ip_addr__used_for_current_session' => 'ไม่สามารถลบ IP แอดเดรส %%ip%% ได้เนื่องจากมีการใช้งานโดยช่วงเวลาที่ทำงาน',
    'ip_addr__used_for_hosting' => 'ไม่สามารถลบ IP แอดเดรส %%ip%% ได้เนื่องจากมีการใ้ช้ในการโฮสติ้งเว็บไซต์',
    'ip_addr__is_main' => 'ไม่สามารถลบ IP แอดเดรส %%ip%% ได้ เนื่องจากเป็น IP แอดเดรสเบื้องต้นของหน้าจอเครือข่าย',
    'ip_addr__ip_used_by_message_submission' => 'ไม่สามารถลบ IP แอดเดรส %%ip%% ได้ เนื่องจากมีการใช้งานสำหรับการส่งข้อความจดหมาย',

    // RESELLER ACTION LOG

    '__cl_domains' => 'โดเมนของลูกค้า',
    'excl_ip_num' => 'IP แอดเดรสเฉพาะ',

    'sb_err_sitebuilder_not_installed' => 'ยังไม่ได้ติดตั้ง Presence Builder',

    '__perm_allow_oversell_can_not_be_revoked' => 'การอนุญาตเพื่อไม่ให้ผู้ขายสามารถเพิกถอนการขายมากกว่าการผลิตได้ เนื่องจากผู้ใช้ได้รับการจัดสรรทรัพยากรที่มากกว่าที่มีอยู่ ไปยังโหมดการขายมากกว่าที่ผลิตได้',
    'limitsManager__invalid_limit_value' => 'ค่า %%value%% ที่ระบุไว้สำหรับขีดจำกัด %%limit_name%% ไม่ถูกต้อง',
    'confirmationForm_default_agreement_text' => 'ยืนยันการดำเนินการ',
    'confirmationForm_default_confirm_message' => 'โปรดยืนยันการดำเนินการ',
    'limit__max_mn' => 'จำนวนสูงสุดของบัญชีเมล',

    'limits__client_overuse_description' => 'นโยบายการใช้เกินบอก Plesk ว่าต้องทำอย่างไรเมื่อการใช้ทรัพยากรเกินจำกัดการจัดสรรทรัพยากรในแรกเริ่ม',
    'limits__client_overuse_block_true_description' => 'บล็อคการใช้ทรัพยากรเกิน การใช้ทรัพยากรจริงไม่สามารถเกินกว่าค่าค่าที่ได้รับการจัดสรรไว้เริ่มต้น',
    'limits__client_overuse_block_false_description' => 'ห้ามบล็อคการใช้ืทรัพยากรเกิน อนุญาตให้ลูกค้าใช้ทรัพยากรได้มากกว่าที่ให้มาในครั้งแรกได้ การใช้งานทรัพยากรที่แท้จริงสามารถใช้เกินการจัดสรรทรัพยากรในแรกเริ่มได้',
    'limits__client_overuse_notify_text' => 'แจ้งเตือนลูกค้าเกี่ยวกับการถึงขีดจำกัดของทรัพยากร',

    'limits__domain_overuse_description' => 'นโยบายการใช้เกินบอก Plesk ว่าต้องทำอย่างไรเมื่อการใช้ทรัพยากรเกินจำกัดการจัดสรรทรัพยากรในแรกเริ่ม',
    'limits__domain_overuse_block_true_description' => 'นโยบายการใช้งานเกินกำหนดสามารถบอก Plesk ได้ว่าควรทำอย่างไรเมื่อมีการใช้ทรัพยากรมากเกินไป',
    'limits__domain_overuse_block_false_description' => 'ห้ามบล็อคการใช้ทรัพยากรเดิน อนุญาตให้โดเมนใช้ทรัพยากรมากกว่าค่าเริ่มต้นที่ให้ไว้ การใช้ทรัพยากรจริงเกินกว่าค่าที่ได้รับการจัดสรรไว้เริ่มต้น',
    'limits__domain_overuse_notify_text' => 'แจ้งเตือนเจ้าของโดเมนเกี่ยวกับการถึงขีดจำกัดของทรัพยากร',


    'cancel_remove' => 'ยกเลิกการเปลี่ยนแปลงใดๆ และกลับไปยังหน้าก่อนหน้านี้',

    'dns__dns_rr_delete' => 'รายการที่จะได้รับการลบ',
    'dns__delete_rr' => 'รายการ DNS ดังต่อไปนี้จะได้รับการลบออกจาก DNS โซน:',
    'dns__dns_rr_delete_non_removable' => 'รายการที่ไม่สามารถลบได้',
    'dns__non_delete_rr' => 'ไม่สามรถบลรายการ DNS ดังต่อไปนี้:',
    'dns__dns_rr_delete_confirm_message' => 'ยืนยันการลบรายการ DNS',

    'site_apps__format_is_unsupported_broadcast_not_set' => 'รูปแบบแอพพลิเตคชั่นเว็บที่ไม่รูจัก: แอพพลิเคชั่นเว็บอาจจะไม่มีอยู่สำหรับการติดตั้งการใช้งาน',

    '__php_handler_type_desc' => 'ใช้งาน PHP ในฐานะ',
    'sfdk_domain_sign__failed' => 'มีข้อผิดพลาดที่ไม่สามารถระบุได้เกิดขึ้น เมื่อคุณกำลังเปิดการเข้าสู่เมลด้วย DKIM ในโดเมน อ้างอิงถึงบันทึกข้อผิดพลาดของเซิร์ฟเวอร์สำหรับข้อมูลเพิ่มเติม',

    // key management ported from cpp to php
    'pkey_notify__subj_update_success_notification' => 'การแจ้งเตือนการอัพเดต Plesk สำเร็จ',
    'pkey_notify__subj_update_deferral_notification' => 'การแจ้งเตือนการเลื่อนอัพเดต Plesk',
    'pkey_notify__subj_update_error_notification' => 'การแจ้งเตือนข้อผิดพลาดการอัพเดต Plesk',
    'pkey_notify__update_successful' => '%1 อัพเดทเสร็จสมบูรณ์แล้ว',
    'pkey_notify__update_failed_no_more_try' => 'ไม่สามารถอัพเดต %1 ได้ คีย์ที่คุณพยายามส่งไม่ถูกต้อง คุณไม่ควรลองอัพเดตคีย์นี้อีกแล้ว',
    'pkey_notify__update_failed_try_later' => 'ไม่สามารถอัพเดท %1: เกิดข้อผิดพลาดขึ้นในขณะที่กำลังประมวลผลรหัสของคุณ คุณสามารถเรียกใช้รหัสใน Plesk ได้ด้วยตนเอง (เครื่องมือและการตั้งค่า>ข้อมูลใบอุญาต) หรือปล่อยให้ Plesk ลองอัพเดตรหัสในอีก 24 ชั่วโมง หากคุณไม่ต้องการรับการแจ้งเตือนใดๆ ให้ลบรหัสนี้ออกจาก Plesk',

    // spam assassin error messages
    'ui__server/spam-filter/toggle__unable_disable' => 'ไม่สามารถปิดการกรองสแปมทั่วทั้งเซิร์ฟเวอร์',
    'ui__server/spam-filter/toggle__unable_enable' => 'ไม่สามารถเปิดการกรองสแปมทั่วทั้งเซิร์ฟเวอร์',

    // Application vault/ application pool for admin mapping - TEMPORARY

    'rpt_reseller_section_full_domains' => 'โดเมน',
    'rpt_reseller_dom_subdomains' => 'Subdom',
    'rpt_reseller_dom_domain_aliases' => 'DAliases',
    'rpt_reseller_dom_postboxes' => 'MBoxes',
    'rpt_reseller_dom_redirects' => 'ผู้ส่งต่อ',
    'rpt_reseller_dom_mail_groups' => 'MGroups',
    'rpt_reseller_dom_mail_resps' => 'AResp.',
    'rpt_reseller_dom_mail_antispam' => 'ป้องกันสแปม',
    'rpt_reseller_dom_mail_antivirus' => 'ป้องกันไวรัส',
    'rpt_reseller_dom_mail_lists' => 'MLists',
    'rpt_reseller_dom_web_users' => 'WUsers',
    'rpt_reseller_dom_data_bases' => 'DBMySQL',
    'rpt_reseller_dom_mssql_data_bases' => 'DBMSSQL',

    'rpt_reseller_section_full_clients' => 'ลูกค้า',
    '__cl_name' => 'ชื่อลูกค้า',
    '__cl_creation_date' => 'วันที่สร้าง',
    '__clients_traffic' => 'ทราฟฟิคลูกค้า',
    'rpt_reseller_cl_mail_antispam' => 'ป้องกันสแปม',
    'rpt_reseller_cl_mail_antivirus' => 'ป้องกันไวรัส',

    // CONHELPS FOR HOME PAGE
    // common:
    'sitebuilder_not_installed' => 'ยังไม่ได้ติดตั้ง Presence Builder',
    'sitebuilder_disabled' => 'Presence Builder ปิดอยู่',
    'b_sitebuilder_disabled' => 'Presence Builder ปิดอยู่',
    'webmail_not_installed' => 'ไม่มีการติดตั้งซอฟต์แวร์เว็บเมล',
    'webmail_disabled' => 'ปิดบริการเว็บเมลแล้ว',
    'spamassassin_not_installed' => 'ไม่ได้ติดตั้ง SpamAssassin',
    // pfu:
    'anonymous_ftp_shared' => 'ไม่สามารถตั้งค่า FTP นิรนาม: ประเภท IP แอดเดรสที่แบ่งปัน',
    'anonymous_ftp_used' => 'ไม่สามารถตั้งค่า FTP นิรนาม: IP แอดเดรสที่ใช้โดยโดเมนอื่นสำหรับบริการ FTP นิรนาม',
    // pfw:
    'aspdotnet_not_installed' => 'ไม่มีการติดตั้ง ASP.NET',
    'site_builder_no_package' => 'ไม่มี Presence Builder โปรดตรวจสอบว่าได้ติดตั้งและเลือก Presence Builder เป็นคอมโพเนนท์ที่ใช้งานได้',
    'site_builder_not_configured' => 'ยังไม่ได้ตั้งค่า Presence Builder',

    // LIST OF CLIENTS
    // under reseller
    'ui__reseller/client#tools__title' => 'เครื่องมือ',
    'ui__reseller/client#clientslist__title' => 'ลูกค้า',

    //reseller accounts removal





    // NEW HOME PAGE WIZARDS

    // PFW-only

    'ui__client/domain/hosting/web-directories_unknown__wizard-title' => 'จัดการสารบบเสมือนภายใต้เว็บไซต์',
    'ui__client/domain/hosting/web-directories_unknown__wizard__2_unknown' => "เลือกเว็บไซต์ที่คุณต้องการจัดการสารบบเสมือน",

    // COMMON WIZARDS


    'ui__client/domain/hosting/anonymous-ftp_unknown__wizard-title' => 'ตั้งค่า FTP นิรนามบนโดเมน',
    'ui__client/domain/hosting/anonymous-ftp_unknown__wizard__2_unknown' => 'เลือกโดเมนที่คุณต้องการตั้งค่า FTP โดยไม่ระบุชื่อ.',

    'ui__client/domain/hosting/logs_unknown__wizard-title' => 'เลือกโดเมนที่คุณต้องการตั้งค่าตัวจัดการการเข้าสู่ระบบ และไฟล์การเข้าสู่ระบบที่คุณต้องการดู',
    'ui__client/domain/hosting/logs_unknown__wizard__2_unknown' => 'เลือกโดเมนที่คุณต้องการตั้งค่าตัวจัดการการเข้าสู่ระบบ และไฟล์การเข้าสู่ระบบที่คุณต้องการดู',

    'ui__client/domain/certificate_unknown__wizard-title' => 'จัดการการรับรอง SSL/TLS สำหรับโดเมน',
    'ui__client/domain/certificate_unknown__wizard__2_unknown' => 'เลือกโดเมนที่คุณต้องการจัดการการรับรอง SSL/TLS',

    'ui__client/domain/disable_multi__wizard-title' => 'ระงับโดเมน',
    'ui__client/domain/disable_multi__wizard__2_multi' => 'เลือกโดเมนที่คุณต้องการระงับ',

    'ui__client/domain/enable_multi__wizard-title' => 'โดเมนที่ยังใช้งานอยู่',
    'ui__client/domain/enable_multi__wizard__2_multi' => 'เลือกโดเมนที่คุณต้องการเปิดใช้งาน',

    'ui__client/domain_unknown__wizard-title' => 'ดูโดเมน',
    'ui__client/domain_unknown__wizard__1_unknown' => 'เลือกลูกค้าที่มีโดเมนที่คุณต้องการดู',

    'ui__client/domain/register_unknown__wizard-title' => 'ลงทะเบียนโดเมน',
    'ui__client/domain/register_unknown__wizard__2_unknown' => 'เลือกโดเมนที่คุณต้องการลงทะเบียน',

    'ui__client/domain/extras_unknown__wizard-title' => 'ใช้เครื่องมือจาก MyPlesk.com',
    'ui__client/domain/extras_unknown__wizard__2_unknown' => 'เลือกโดเมนที่คุณต้องการจัดการด้วยเครื่องมือจาก MyPlesk.com',

    // various

    'ui__server/ip-address/client_unknown__short-title' => 'ผู้ใช้ IP แอดเดรส',
    'ui__server/ip-address/client_unknown__title' => 'ผู้ใช้ IP แอดเดรส',
    'ui__server/ip-address/client_unknown__description' => 'ผู้ใช้ของ IP แอดเดรส %1',

    'disabled_by_admin' => 'ปิดการใช้งานผู้ดูแลระบบเซิร์ฟเวอร์',






    'ui__client/domain/chowner_multi__short-title' => 'เปลี่ยนความเป็นเจ้าของ',
    'ui__client/domain/chowner_multi__title' => 'เปลี่ยนความเป็นเจ้าของการสมัครรับบริการ',
    'ui__client/domain/chowner_multi__description' => 'เปลี่ยนความเป็นเจ้าของการสมัครรับบริการ',

    'ui__client/domain/chowner_multi__wizard__2_multi' => 'เลือกโดเมนที่คุณต้องการเปลี่ยนความเป็นเจ้าของ และคลิกถัดไป >>',
    'ui__client/domain/chowner_unknown__short-title' => 'เปลี่ยนความเป็นเจ้าของ',
    'ui__client/domain/chowner_unknown__title' => 'เปลี่ยนความเป็นเจ้าของการสมัครรับบริการ',
    'ui__client/domain/chowner_unknown__description' => 'เปลี่ยนความเป็นเจ้าของการสมัครรับบริการ',

    'ui__client/domain/chowner_unknown__wizard-title' => 'เปลี่ยนความเป็นเจ้าของการสมัครรับบริการ',

    //custom buttons reseller home support
    //ui captions
    'ui__reseller/custom-buttons/custom-button__none-available' => 'ไม่มีปุ่มที่ตั้งค่าเอง',
    'ui__reseller/custom-buttons/custom-button__none-available__1' => 'ไม่มีปุ่มตั้งค่าในหน้าจอของตัวแทนจำหน่าย %1',

    'ui__reseller/custom-buttons/custom-button/delete__description' => 'ลบปุ่ม %1',

    'ui__reseller/custom-buttons/custom-button/delete__short-title' => 'ลบ',
    'ui__reseller/custom-buttons/custom-button/delete__title' => 'ลบปุ่ม %1',
    'ui__reseller/custom-buttons/custom-button/delete_multi__description' => 'ลบปุ่มตั้งค่าจากหน้าจอของตัวแทนจำหน่าย',

    'ui__reseller/custom-buttons/custom-button/delete_multi__short-title' => 'ลบ',
    'ui__reseller/custom-buttons/custom-button/delete_multi__title' => 'ลบปุ่มที่ตั้งค่าเอง',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard-title' => 'ลบปุ่ม',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard__1_unknown' => 'เลือกตัวแทนจำหน่ายซึ่งคุณต้องการลบปุ่มที่ตั้งค่าเอง และคลิกถัดไป >>',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard__3_multi' => 'เลือกปุ่มที่คุณต้องการลบ และคลิกถัดไป >>',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard__4_multi' => 'ยืนยันการลบปุ่มโดยการเลือกช่องกาเครื่องหมายบนหน้าจอนี้ และจากนั้นคลิกเสร็จสิ้น',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__description' => 'ลบปุ่มตั้งค่าจากหน้าจอของตัวแทนจำหน่าย',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__short-title' => 'ลบ',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__title' => 'ลบปุ่มที่ตั้งค่าเอง',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard-title' => 'ลบปุ่มที่ตั้งค่าเอง',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard__1_unknown' => 'เลือกตัวแทนจำหน่ายซึ่งคุณต้องการลบปุ่มที่ตั้งค่าเอง และคลิกถัดไป >>',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard__3_unknown' => 'เลือกปุ่มที่ตั้งค่าเองที่คุณต้องการลบ และคลิกถัดไป >>',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard__4' => 'ยืนยันการลบปุ่มที่ตั้งค่าเองโดยการเลือกช่องกาเครื่องหมายบนหน้าจอนี้ และจากนั้นคลิกเสร็จสิ้น',

    'ui__reseller/custom-buttons/custom-button/properties__description' => 'แก้ไขคุณสมบัติของปุ่มที่ตั้งค่าเองระดับตัวแทนจำหน่าย %1',

    'ui__reseller/custom-buttons/custom-button/properties__short-title' => 'การตั้งค่า',
    'ui__reseller/custom-buttons/custom-button/properties__title' => 'แก้ไขปุ่มที่ตั้งค่าเองของตัวแทนจำหน่าย %1',

    'ui__reseller/custom-buttons/custom-button/properties_new__wizard-title' => 'เพิ่มปุ่มที่ตั้งค่าเอง',
    'ui__reseller/custom-buttons/custom-button/properties_new__wizard__1_unknown' => 'เลือกตัวแทนจำหน่ายที่มีหน้าจอที่คุณต้องการสร้างปุ่มตั้งค่าให้ และคลิกถัดไป >>',
    'ui__reseller/custom-buttons/custom-button/properties_new__wizard__4_new' => 'คลิกเสร็จสิ้นเพื่อสร้างปุ่ม',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__description' => 'เปลี่ยนคุณสมบัติของปุ่มในหน้าจอของตัวแทนจำหน่าย',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__short-title' => 'คุณสมบัติ',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__title' => 'เปลี่ยนคุณสมบัติของปุ่มในหน้าจอของตัวแทนจำหน่าย',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard-title' => 'เปลี่ยนคุณสมบัติของปุ่มที่ตั้งค่าเอง',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard__1_unknown' => 'เลือกตัวแทนจำหน่ายซึ่งคุณต้องการแก้ไขปุ่มที่ตั้งค่าเอง และคลิกถัดไป >>',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard__3_unknown' => 'เลือกปุ่มที่ตั้งค่าเองที่คุณต้องการแก้ไข และคลิกถัดไป >>',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard__4' => 'เมื่อทำการแก้ไขคุณสมบัติของปุ่มเรียบร้อยแล้ว ให้คลิกเสร็จสิ้นเพื่อนำการเปลี่ยนแปลงไปใช้ และออกจากโปรแกรมช่วยติดตั้ง',

    'ui__reseller/custom-buttons/custom-button/toggle_private__description' => 'ทำให้ลูกค้าของคุณไม่สามารถใช้ปุ่ม %1 ได้',

    'ui__reseller/custom-buttons/custom-button/toggle_private__short-title' => 'ทำให้ลูกค้าของคุณไม่สามารถใช้ได้',
    'ui__reseller/custom-buttons/custom-button/toggle_private__title' => 'ทำให้ลูกค้าของคุณไม่สามารถใช้ปุ่ม %1 ได้',
    'ui__reseller/custom-buttons/custom-button/toggle_public__description' => 'ทำให้ลูกค้าของตัวแทนจำหน่ายเห็นปุ่ม %1',
    'ui__reseller/custom-buttons/custom-button/toggle_public__short-title' => 'ทำให้ลูกค้าของคุณสามารถใช้ได้',
    'ui__reseller/custom-buttons/custom-button/toggle_public__title' => 'ทำให้ลูกค้าของตัวแทนจำหน่ายเห็นปุ่ม %1',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__description' => 'ทำให้ลูกค้าของคุณสามารถใช้/ไม่สามารถใช้ปุ่มที่ตั้งค่าเองได้',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__short-title' => 'มี/ไม่มีให้ลูกค้าของคุณ',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__title' => 'ทำให้ลูกค้าของคุณสามารถใช้/ไม่สามารถใช้ปุ่มที่ตั้งค่าเองได้',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__wizard-title' => 'ทำให้ลูกค้าของคุณสามารถใช้/ไม่สามารถใช้ปุ่มที่ตั้งค่าเองได้',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__wizard__1_unknown' => 'เลือกตัวแทนจำหน่ายที่คุณต้องการให้ลูกค้าของตัวแทนจำหน่ายนั้นสามารถใช้หรือไม่สามารถใช่ปุ่มที่กำหนดเองได้ และคลิกถัดไป >>',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__wizard__3_unknown' => 'เลือกปุ่มที่ตั้งค่าเองที่คุณต้องการทำให้ลูกค้าของคุณสามารถใช้หรือไม่สามารถใช้ปุ่มได้ และคลิกถัดไป >>',

    '__not_allowed' => 'ไม่อนุญาต',

    'ui__client/domain/chowner__wizard__3' => '',
    'ui__client/domain/chowner__wizard__3_select' => 'เลือกเจ้าของใหม่ของโดเมน',

    '__ip_addr_state_unknown' => "ไม่ได้ใช้งาน IP แอดเดรสในขณะนี้ เนื่องจากระบบยังประมวลผลตามที่คุณร้องขอ โปรดรอสักครู่",


    'resellers_list__accounts' => 'ผู้ใช้',

    'ip_addr__repair_is_not_allowed' => 'ไม่สามารถซ่อมแซม IP แอดเดรสในสภาพแวดล้อม Virtuozzo ได้',

    'ui__reseller/client__none-available__1' => 'ตัวแทนจำหน่าย %1 ไม่มีลูกค้า',

    'ippoolManager__ip_used_by_nohost_domain' => "ไม่สามารถลบที่อยู่ IP %%ip%% ได้ เนื่องจากมีโดเมนแบบไม่มีโฮสติ้งจำนวนหนึ่งหรือมากกว่านั้นใช้ที่อยู่ IP นี้",
    'ippoolManager__ip_used_for_mail_service' => "ไม่สามารถลบที่อยู่ IP %%ip%% ได้ เนื่องจากมีโดเมนจำนวนหนึ่งหรือมากกว่านั้นใช้เป็นที่อยู่ IP สำหรับบริการเมลของพวกเขา",
    'ippoolManager__ip_used_for_send_emails' => "ไม่สามารถลบที่อยู่ IP %%ip%% ได้ เนื่องจากถูกใช้เพื่อส่งอีเมลจาก IP ที่ระบุ (ดูในการตั้งค่าเซิร์ฟเวอร์เมล)",
    'ippoolManager__ip_used_in_dns_zone' => 'ไม่สามารถลบ IP แอดเดรส %%ip%% ได้ เนื่องจากมีการใช้ IP แอดเดรสนี้โดย DNS โซนของโดเมนหนึ่งโดเมนหรือมากกว่า',
    'ip_ctrl__cannot_manage_on_vz' => 'การติดตั้ง Plesk กำลังดำเนินการภายใต้ Virtuozzo Containers IP แอดเดรสใหม่สามารถเพิ่มได้โดยผู้ดูแล Virtuozzo Containers เท่านั้น',

    'client_template__limits_auto_adjusted' => 'ขีดจำกัดของแม่แบบลูกค้าได้ถูกปรับใหม่แล้วอัตโนมัติ',

    '__entries' => 'รายการ',

    '__path_is_not_set' => 'ไม่ได้ระบุพาธ โปรดระบุพาธที่ถูกต้อง',

    'defaultcomponents__imap_required' => '(เซิร์ฟเวอร์เมลปัจจุบันไม่รองรับ IMAP)',

    '__commercial_web_stats_not_installed' => 'Plesk รองรับเฉพาะซอฟต์แวร์สถิติเว็บทางพาณิชย์สำหรับการคำนวณสถิติของซับโดเมนเท่านั้น ไม่ได้ติดตั้งซอฟต์แวร์ดังกล่าวในระบบ',


    'server_settings_invalid_traffic_statistics' => 'พารามิเตอร์สถิติการรับส่งข้อมูลไม่ถูกต้อง',
    'server_settings_invalid_logrotate_period' => 'พารามิเตอร์ระยะเวลาการหมุนเวียนบันทึกไม่ถูกต้อง',

    'spam_filter/address/file_size' => 'ไม่สามารถอัพโหลดไฟล์ได้ ขนาดของไฟล์ที่ใหญ่ที่สุดที่สามารถอัพโหลดได้คือ %1',
    'spam_filter/address/file_empty_content' => 'เกิดปัญหาในการอ่านที่อยู่อีเมลจากไฟล์ โปรดตรวจสอบให้แน่ใจว่าคุณอัพโหลดไฟล์ด้วยการเข้ารหัส UTF-8 ที่มีที่อยู่อีเมลอย่างน้อย 1 รายการ แล้วลองอีกครั้ง',
    'spam_filter/address/addresses_empty_content' => 'ไม่มีที่อยู่อีเมลในรายการ',
    'spam_filter/address/addresses_available' => 'ที่อยู่อีเมลที่ไม่เหมือนใคร %1 เท่านั้นที่ได้จะได้เพิ่้มเข้าไป',
    'spam_filter/address/invalid_addresses' => 'ที่อยู่อีเมลดังต่อไปนี้ไม่ถูกต้อง: %1.',
];