<?php
// Copyright 1999-2024. WebPros International GmbH. All rights reserved.
$messages = [
    'problem-detail.nginx-upstream-sent-too-big-header.name' => 'Nginx "502 Bad Gateway: upstream sent too big header while reading response header"',
    'problem-detail.nginx-upstream-sent-too-big-header.description' => 'Ska bli klar snart.',
    'problem-detail.nginx-upstream-sent-too-big-header.cause' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.title' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.text' => '',
    'problem-detail.apache-followsymlinks-not-allowed.name' => 'Apache "500 Internal Server Error: Option FollowSymLinks not allowed here"',
    'problem-detail.apache-followsymlinks-not-allowed.description' => 'Ska bli klar snart.',
    'problem-detail.apache-followsymlinks-not-allowed.cause' => '',
    'problem-detail.phpfpm-server-reached-max-children.name' => 'PHP-FPM "server reached max_children setting"',
    'problem-detail.phpfpm-server-reached-max-children.description' => '<h4>Symptom</h4><ul><li><p>Webbplatser som har PHP-hanterare inställd som <strong>FPM-applikation från Apache</strong> eller <strong>FPM-applikation från nginx</strong> i <strong>Domäner</strong> &gt; <strong>example.com</strong> &gt; <strong>PHP-inställningar</strong> uppvisar ett av följande problem:</p><ul><li><p>laddar långsamt</p></li><li><p>ej tillgängliga (permanent eller periodiskt) med 50x-fel i webbläsaren:</p><pre>502 Bad Gateway</pre><hr><pre>503 Service Temporarily Unavailable</pre><hr><pre>504 Gateway Time-out</pre></li></ul></li><li><p>Följande meddelande visas i felloggfilen för PHP-FPM <code>/var/log/plesk-php<strong>XX</strong>-fpm/error.log</code> (där <em>XX</em> är en PHP-version som används av webbplatserna):</p><pre>WARNING: [pool example.com] server reached max_children setting (*), consider raising it</pre><ul><li><p>The message above is usually accompanied with this error:</p><pre>unable to read what child say: Bad file descriptor (9)</pre></li></ul></li><li><p>If nginx is enabled on the server, one of the following error messages may appear in domain\'s error logfile <code>/var/www/vhosts/system/example.com/logs/proxy_error_log</code>:</p><pre style="white-space: pre-wrap;">[error] 11456#0: *118348 connect() to unix:///var/www/vhosts/system/example.com/php-fpm.sock failed (11: Resource temporarily unavailable) while connecting to upstream, client: 203.0.113.2, server: example.com, request: "GET / HTTP/1.1", upstream: "fastcgi://unix:///var/www/vhosts/system/example.com/php-fpm.sock:", host: "example.com"</pre><hr><pre style="white-space: pre-wrap;">[error] 20058#0: *4725139 upstream prematurely closed connection while reading response header from upstream, client: 203.0.113.2, server: example.com, request: "POST /path/to/some/file HTTP/2.0", upstream:</pre></li></ul>',
    'problem-detail.phpfpm-server-reached-max-children.cause' => ' <p>PHP-FPM <code>pm.max_children</code> har nåtts av webbplats(erna).</p>',
    'problem-detail.phpfpm-server-reached-max-children.solution1.title' => 'Höj gränsen pm.max_children',
    'problem-detail.phpfpm-server-reached-max-children.solution1.text' => '<p>Höj gränsen för <code>pm.max_children</code> för de påverkade domänerna:</p><ol><li><p>Anslut till Plesk-servern via <a href="https://support.plesk.com/hc/en-us/articles/12377512781975" target="_blank" rel="noopener">SSH</a>.</p></li><li><p>Hitta de påverkade domänerna med kommandot nedan:</p><div class="pul-alert pul-alert--info pul-status-message pul-status-message--info"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Obs:</strong> Siffran till vänster anger hur många gånger gränsen för <code>pm.max_children</code> har nåtts av webbplatsen.</div><pre style="white-space: pre-wrap;"># grep -r "server reached max_children setting" /var/log/*php*-fpm/error.log | cut -d\' \' -f5 | tr -d \']\' | sort | uniq -c | sort -nr<br><br>100 example.com<br>50 example.net<br>25 example.org<br>&lt;...&gt;</pre></li><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377667582743" target="_blank" rel="noopener">Logga in på Plesk</a>.</p></li><li><p>Gå till <strong>Domäner</strong> &gt; <strong>example.com</strong> &gt; <strong>PHP-inställningar</strong> &gt; <strong>PHP-FPM-inställningar</strong>.</p></li><li><p>Höj <code>pm.max_children</code>-värdet för domänen och verkställ ändringarna. Höj värdet för alla domäner som listas i steg 2.</p></li></ol>',
    'problem-detail.nginx-too-many-open-files.name' => 'Nginx "Too many open files"',
    'problem-detail.nginx-too-many-open-files.description' => '<p>nginx kan inte starta/ladda om på en Plesk-server: Too many open files</p><h4>Symptom</h4><ul><li><p>nginx-tjänsten kan inte starta/ladda om med följande fel i <code>/var/log/nginx/error.log</code>-filen:</p><pre style="white-space: pre-wrap;">nginx: [emerg] open() "/var/www/vhosts/system/example.com/logs/proxy_access_ssl_log" failed (24: Too many open files)</pre></li><li><p>Some or all websites are not accessible</p></li><li><p>Varningen visas i <strong>Verktyg &amp; inställningar &gt; Diagnostisera &amp; reparera</strong>:</p><pre style="white-space: pre-wrap;">Checking for nginx ULIMIT value N domains have been found on server. Problem with nginx default limit for open files is possible</pre></li><li><p>Webbapplikationerna NodeJS och Ruby visar 502 Bad Gateway-fel när man utför vissa Plesk-uppgifter, som att skapa domäner, prenumerationer, ändringar i Apache eller Nginx etc.:</p><pre style="white-space: pre-wrap;">Server Error<br>502 Bad Gateway <br>Web server received an invalid response while acting as a gateway or proxy server.</pre></li><li><p>Efter <a href="https://support.plesk.com/hc/en-us/articles/12377676289815-How-to-install-SSL-certificate-for-a-domain-in-Plesk" target="_blank" rel="noopener noreferrer">att ha installerat ett nytt certifikat för domänen</a> så visas det gamla fortfarande i webbläsaren, men rätt certifikat är valt i sidan för <strong>Domäner &gt; example.com &gt; Värdtjänstinställningar</strong>.</p></li></ul>',
    'problem-detail.nginx-too-many-open-files.cause' => '<p>Nginx virtuella värd öppnar fyra loggfiler för varje virtuell värd med fysisk värdtjänst:</p><ul><li>proxy_access_log</li><li>proxy_access_ssl_log</li><li>webmail_access_log</li><li>webmail_access_ssl_log</li></ul><p>Detta resulterar i att maxantalet öppna filer överskrids av nginx-servern, på grund av det höga antalet domäner (vanligtvis fler än 100).</p>',
    'problem-detail.nginx-too-many-open-files.solution1.title' => 'Höj gränsen för öppna filer',
    'problem-detail.nginx-too-many-open-files.solution1.text' => '<div class="pul-alert pul-alert--warning pul-status-message pul-status-message--warning"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Varning:</strong> Att köra verktyget <code>websrv_ulimits</code> utan alternativet <strong>--no-restart</strong> påbörjar återuppbyggning av webbkonfigurationsfilerna för alla domäner och kan leda till betydande nedtid om man är värd för många webbplatser.<br><br>Kör kommandot under underhållstiden.</div><p>Det är god praxis att ställa in gränsvärdet för öppna filer till högre än <strong>antalet domäner i Plesk * 16</strong>, minst. I exemplet nedan beskrivs det hur man ställer in gränsen till 4096:</p><ol><li><p>Anslut till servern via <a href="https://support.plesk.com/hc/en-us/articles/12377512781975" target="_blank" rel="noopener noreferrer">SSH</a></p></li><li><p>Ställ in gränsen för öppna filer till 4096 för både Apache och Nginx:</p><pre># /usr/local/psa/admin/sbin/websrv_ulimits --set 4096 --no-restart</pre></li><li><p>Starta om Apache- och nginx-tjänsterna i <strong><a href="https://support.plesk.com/hc/en-us/articles/12377667582743" target="_blank" rel="noopener noreferrer">Plesk</a> &gt;</strong> <strong>Verktyg &amp; inställningar &gt; Tjänstehantering</strong> för att verkställa ändringarna.</p></li><li><p>Kontrollera att "Max open files limit" verkställdes ordentligt efter att webbtjänsterna startat om:</p><pre># grep \'Max open files\' /proc/$(cat /var/run/nginx.pid)/limits<br>Max open files 4096 4096 file</pre></li><li><p>Om lösningen ovan inte hjälpte, ställ in gränsen med verktyget <code>ulimit</code>:</p><pre># ulimit -n 4096</pre></li></ol>',
    'problem-detail.apache-modsec-response-body-too-large.name' => 'ModSecurity "Response body too large"',
    'problem-detail.apache-modsec-response-body-too-large.description' => 'Ska bli klar snart.',
    'problem-detail.apache-modsec-response-body-too-large.cause' => '',
    'problem-detail.modsec-access-denied.name' => 'ModSecurity "Access denied with code 403"',
    'problem-detail.modsec-access-denied.description' => '<h4>Symptom</h4><ul><li><p>ModSecurity installeras och aktiveras i <strong>Verktyg och inställningar > Webbprogram brandvägg (ModSecurity) > Webbprogram brandvägg modus > På</strong>.</p></li><li>En webbplats där Plesk är värd kan inte laddas. Det är inte möjligt att utföra operationer på webbplatsen, såsom att hantera WordPress, komma ått webmail eller komma åt <code>robots.txt</code>-filen. Webbläsaren kan visa ett av följande meddelanden: <pre>ERR_CONNECTION_REFUSED</pre><hr><pre>403 Forbidden</pre><hr><pre>500 Internal Server Error</pre><hr><pre>ERR_CONNECTION_TIMED_OUT</pre></li><li>Ett ModSecurity-felmeddelande som det nedan visas i loggfilen <code>/var/log/modsec_audit.log</code> eller på sidan Loggar i Plesk (<strong>Domäner</strong> &gt; <strong>example.com</strong> &gt; <strong>Loggar</strong>): <pre>ModSecurity: Åtkomst nekad med kod 403 (fas 2). Operatör GE matchad 5 vid TX:anomaly_score. [file "/etc/apache2/modsecurity.d/rules/owasp_modsecurity_crs_3-plesk/REQUEST-949-BLOCKING-EVALUATION.conf"] [line "57"] [id "949110"] [msg "Inkommande anomalipoäng överskrider (Totalpoäng: 5)"] [allvarlighet "KRITISK"] [tag "application-multi"] [tag "language-multi"] [tag "platform-multi"] [tag "attack-generic"] [hostname "example.com"] [uri "/robots.txt"] [unique_id "XPsROH8AAQEAABEiZFcAAABC"]</pre></li>',
    'problem-detail.modsec-access-denied.cause' => '<p>Modsecurity webbprogram brandvägg är aktiverad med en väldigt restriktiv uppsättning regler, som OWASP, Comodo eller en egen regeluppsättning, som Imunify360. Restriktiva regeluppsättningar kan blockera visa operationer på webbplatsen.</p><p><Strong>Obs:</strong> ModSecurity-felet kan indikera en attack mot din server. Använd endast lösningarna nedan om du är säker på att ModSecurity blockerar giltig användning av din webbplats.</p>',
    'problem-detail.modsec-access-denied.solution1.title' => 'Inaktivera ModSecurity-regeluppsättningen efter ID eller tagg',
    'problem-detail.modsec-access-denied.solution1.text' => '<ol><li><p>Hitta ID för regeln som blockerar legitim användning av din webbplats. Du hittar ID inuti felmeddelandena i loggfilen <code>/var/log/modsec_audit.log</code>. ID är ett heltal inom citationstecken med prefixet <code>id</code> inom hakparentes, till exempel <strong>[id "210831"]</strong>.</p></li><li><a href="https://support.plesk.com/hc/en-us/articles/12377453278871" target="_blank" rel="noopener">Inaktivera specifika regeluppsättningar i Plesk</a>.</li></ol>',
    'problem-detail.modsec-access-denied.solution2.title' => 'Byt till en annan ModSecurity-regeluppsättning',
    'problem-detail.modsec-access-denied.solution2.text' => '<ol><li><p>Byt till en mindre restriktiv ModSecurity-regeluppsättning, såsom "Atomic ModSecurity Ruleset". För att göra det går du till <strong>Verktyg och inställningar</strong> > <strong>Webbprogram brandvägg (ModSecurity)</strong> > <strong>Inställningar</strong>, välj <strong>Atomic Standard</strong> och klicka sedan på <strong>OK</strong> för att tillämpa ändringarna.</p></li></ol>',
    'problem-detail.php-allowed-memory-size-exhausted.name' => 'PHP "Internal Server error 500: Allowed memory size of XXX exhausted"',
    'problem-detail.php-allowed-memory-size-exhausted.description' => '<h4>Symptom</h4><ul><li><p>En webbplats med Plesk som värd är inte åtkomlig:</p><pre>500 Internal Server Error</pre></li><li><p>Följande felmeddelande visas i webbplatsloggen:</p><pre>Fick felet "PHP message: PHP Fatal error: Allowed memory size of 4194304 bytes exhausted (tried to allocate 4000032 bytes) i /var/www/vhosts/example.com/httpdocs/somethingBig.php på rad 3"</pre></li> </ul>',
    'problem-detail.php-allowed-memory-size-exhausted.cause' => '<p>Webbplatsen har inte tillräckligt med allokerat minne för att behandlas.</p>',
    'problem-detail.php-allowed-memory-size-exhausted.solution1.title' => 'Höj memory_limited för webbplatsen',
    'problem-detail.php-allowed-memory-size-exhausted.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377510316183" target="_blank" rel="noopener">Läs KB-artikeln och följ instruktionerna</a>.</p></li></ol>',
    'problem-detail.php-open-basedir-restriction-in-effect.name' => 'PHP "open_basedir restriction in effect"',
    'problem-detail.php-open-basedir-restriction-in-effect.description' => '<h4>Symptom</h4><ul><li><p>En webbplats är inte åtkomlig, med ett av följande fel i webbläsaren:</p><pre>404 file not found</pre><hr><pre>500 Internal Server Error</pre><hr><pre>Error 500 move_uploaded_file(): open_basedir restriction in effect. File(/path/to/the/directory) is not within the allowed path(s): (/var/www/vhosts/example.com/:/tmp/)</pre></li><li><p>Följande felmeddelande visas på domänens loggsida (<strong>Domäner</strong> > <strong>example.com</strong> > <strong>Loggar</strong>):</p><pre><...> open_basedir restriction in effect. File(/path/to/the/directory) is not within the allowed path(s) <...></pre><hr><pre>Uncaught Exception: Session: Configured save path "/path/to/the/directory" is not a directory, doesn\'t exist or cannot be created.</pre></li></ul>',
    'problem-detail.php-open-basedir-restriction-in-effect.cause' => 'PHP-skriptet försöker komma åt en katalog som inte tillåter åtkomst. Begränsningen definieras av PHP-direktivet <code>open_basedir</code> individuellt för varje domän. Som standard tillåter <code>open_basedir</code> åtkomst till <code>tmp</code> och domänens rotkataloger för dokument, såväl som systemets standardsökväg för sessioner.',
    'problem-detail.php-open-basedir-restriction-in-effect.solution1.title' => 'Lägg till den ytterligare sökvägen till direktivet open_basedir',
    'problem-detail.php-open-basedir-restriction-in-effect.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377510714135" target="_blank" rel="noopener">Läs KB-artikeln och följ instruktionerna</a>.</p></li></ol>',
    'problem-detail.php-open-basedir-restriction-in-effect.solution2.title' => 'Inaktivera direktivet open_basedir',
    'problem-detail.php-open-basedir-restriction-in-effect.solution2.text' => '<ol><li><p>Gå till <strong>Domäner &gt example.com &gt PHP-inställningar</strong>, och ställ in <code>open_basedir</code>-direktivet till "inga".</p></li></ol>',
    'problem-detail.apache-client-denied-by-server.name' => 'Apache .htaccess "403 Forbidden: pcfg_openfile: unable to check htaccess file, ensure it is readable"',
    'problem-detail.apache-client-denied-by-server.description' => '<h4>Symptom</h4><ul><li><p>Webbplatsen visar ett fel som liknar följande:</p><pre>Server Error 403<br>Forbidden</pre></li><li><p>The <code>/var/www/vhosts/system/example.com/logs/error_log</code> log file contains errors like the following one:</p><pre>AH01797: client denied by server configuration: /var/www/vhosts/example.com/index.php</pre></li></ul>',
    'problem-detail.apache-client-denied-by-server.cause' => '<p>Nuvarande Apache-konfiguration tillåter inte åtkomst till webbplatsen.</p><p>För filer som .htaccess och .htpasswd är det väntat, eftersom dessa filer inte får vara åtkomliga via webbservern.</p>',
    'problem-detail.apache-client-denied-by-server.solution1.title' => 'Kontrollera serverkonfigurationen och .htaccess-filerna',
    'problem-detail.apache-client-denied-by-server.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377654829463" target="_blank" rel="noopener">Läs KB-artikeln och följ instruktionerna</a>.</p></li></ol>',
    'problem-detail.apache-no-directory-index.name' => 'Apache "Cannot access a website directory in Plesk: 403 Forbidden"',
    'problem-detail.apache-no-directory-index.description' => '<h4>Symptom</h4><ul><li><p>Kan inte komma åt en specifik plats på webbplatsen, såsom, <code>http://example.com/some_folder</code>. Följande fel uppstår:</p><pre>Server Error 403<br>Forbidden</pre></li><li><p>Följande fel visas i <code>/var/www/vhosts/example.com/logs/error_log<code/>-filen:</p><pre>[autoindex:error] [pid 16314:tid 140300215322368] [client 203.0.113.2:55714] AH01276: Cannot serve directory /var/www/vhosts/example.com/httpdocs/some_folder/: No matching DirectoryIndex (index.html,index.cgi,index.pl,index.php,index.xhtml,index.htm,index.shtml) found, and server-generated directory index forbidden by Options directive</pre></li></ul>',
    'problem-detail.apache-no-directory-index.cause' => '<p>Den efterfrågade katalogen innehåller inte indexfiler eller så är katalogsökning inte aktiverat.</p>',
    'problem-detail.apache-no-directory-index.solution1.title' => 'Lägg till en indexfil i katalogen',
    'problem-detail.apache-no-directory-index.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377654829463" target="_blank" rel="noopener">Läs KB-artikeln och följ instruktionerna</a>.</p></li></ol>',
    'problem-detail.apache-no-directory-index.solution2.title' => 'Aktivera katalogsökning',
    'problem-detail.apache-no-directory-index.solution2.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377172809495" target="_blank" rel="noopener">Läs KB-artikeln och följ instruktionerna</a>.</p></li></ol>',
    'problem-detail.nginx-no-directory-index.name' => 'Nginx "Cannot access a website directory in Plesk: 403 Forbidden"',
    'problem-detail.nginx-no-directory-index.description' => '<h4>Symptom</h4><ul><li><p>Kan inte komma åt en specifik plats på webbplatsen, såsom, <code>http://example.com/some_folder</code>. Följande fel uppstår:</p><pre>Server Error 403<br>Forbidden</pre></li><li><p>Följande fel visas i <code>/var/www/vhosts/example.com/logs/error_log-filen</code>:</p><pre>[autoindex:error] [pid 16314:tid 140300215322368] [client 203.0.113.2:55714] AH01276: Cannot serve directory /var/www/vhosts/example.com/httpdocs/some_folder/: No matching DirectoryIndex (index.html,index.cgi,index.pl,index.php,index.xhtml,index.htm,index.shtml) found, and server-generated directory index forbidden by Options directive</pre></li></ul>',
    'problem-detail.nginx-no-directory-index.cause' => '<p>Den efterfrågade katalogen innehåller inte indexfiler eller så är katalogsökning inte aktiverat.</p>',
    'problem-detail.nginx-no-directory-index.solution1.title' => 'Lägg till en indexfil i katalogen',
    'problem-detail.nginx-no-directory-index.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377654829463" target="_blank" rel="noopener">Läs KB-artikeln och följ instruktionerna</a>.</p></li></ol>',
    'problem-detail.nginx-no-directory-index.solution2.title' => 'Aktivera katalogsökning',
    'problem-detail.nginx-no-directory-index.solution2.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377172809495" target="_blank" rel="noopener">Läs KB-artikeln och följ instruktionerna</a>.</p></li></ol>',
    'problem-detail.apache-reached-max-request-workers.name' => 'Apache "server reached MaxRequestWorkers setting"',
    'problem-detail.apache-reached-max-request-workers.description' => 'Ska bli klar snart.',
    'problem-detail.apache-reached-max-request-workers.cause' => '',
    'problem-detail.php-post-content-length-exceeds-limit.name' => 'PHP-gräns för förfrågningskropp "client intended to send too large body"',
    'problem-detail.php-post-content-length-exceeds-limit.description' => 'Ska bli klar snart.',
    'problem-detail.php-post-content-length-exceeds-limit.cause' => '',
    'problem-detail.nginx-client-sent-too-large-body.name' => 'PHP-gräns för förfrågningskropp "client intended to send too large body"',
    'problem-detail.nginx-client-sent-too-large-body.description' => 'Ska bli klar snart.',
    'problem-detail.nginx-client-sent-too-large-body.cause' => '',
    'problem-detail.php-failed-to-read-session-data.name' => 'PHP-sessioner "503 Internal Server Error" eller "Failed to read session data"',
    'problem-detail.php-failed-to-read-session-data.description' => 'Ska bli klar snart.',
    'problem-detail.php-failed-to-read-session-data.cause' => '',
    'problem-detail.apache-unable-to-check-htaccess-file.name' => 'Apache .htaccess "403 Forbidden: pcfg_openfile: unable to check htaccess file, ensure it is readable"',
    'problem-detail.apache-unable-to-check-htaccess-file.description' => '<h4>Symptom</h4><ul><li><p>En webbplats med Plesk som värd fungerar inte:</p><pre>You don\'t have permission to access / on this server. <br> Vidare visades ett 403 Forbidden-fel vid försök att använda ett ErrorDocument för att hantera begäran.</pre><p>Istället för felet ovan kan du även se en tom sida.</p></li><li><p>Domänens fellogg i <strong>Domäner &gt example.com &gt Loggar</strong> innehåller följanmde:</p><pre>(13)Permission denied: [client 203.0.113.2:39024] AH00529: /var/www/vhosts/example.com/httpdocs/.htaccess pcfg_openfile: unable to check htaccess file, ensure it is readable and that "/var/www/vhosts/example.com/httpdocs/" is executable</pre></li></ul>',
    'problem-detail.apache-unable-to-check-htaccess-file.cause' => 'Felaktiga behörigheter för domänens filer eller mappar.',
    'problem-detail.apache-unable-to-check-htaccess-file.solution1.title' => 'Reparera behörigheter för webbplatsinnehållet',
    'problem-detail.apache-unable-to-check-htaccess-file.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377773681815" target="_blank" rel="noopener">Läs KB-artikeln och följ instruktionerna</a>.</p></li></ol>',
];