<?php
// Copyright 1999-2024. WebPros International GmbH. All rights reserved.
$messages = [
    'app.instances.title' => 'Applicazioni installate',
    'app.instances.buttonCheckForUpdates' => 'Verificare gli aggiornamenti disponibili',
    'app.instances.buttonScan' => 'Analizza',
    'app.instances.hintButtonScan' => 'Esegui l\'analisi dei file del tuo abbonamento per le applicazioni.',
    'app.instances.taskScan' => 'Analisi delle applicazioni in corso...',
    'app.instances.undefinedApp' => 'Non definito',
    'app.instances.name' => 'Nome',
    'app.instances.installedTo' => 'Percorso d\'installazione',
    'app.instances.uninstall' => 'Rimuovi',
    'app.instances.update' => 'Aggiornamento disponibile',
    'app.instances.noUpdates' => 'Nessun aggiornamento trovato. Tutte le applicazioni sono aggiornate.',
    'app.instances.foundUpdates' => 'Aggiornamenti disponibili:',
    'app.instances.noInstallationUrlAvailable' => 'Nessuno',

    'app.packages.title' => 'Applicazioni disponibili',
    'app.packages.name' => 'Nome',
    'app.packages.version' => 'Versione',
    'app.packages.summary' => 'Sommario',
    'app.packages.install' => 'Installare',

    'app.services.title' => 'Servizi disponibili',
    'app.services.serviceID' => 'ID del servizio',
    'app.services.name' => 'Nome',
    'app.services.summary' => 'Sommario',
    'app.services.instantiate' => 'Creare un\'istanza',

    'app.subserviceinstances.remove' => 'Rimuovi',
    'app.subserviceinstances.hintRemove' => 'Rimuovi le istanze di servizio selezionate.',
    'app.subserviceinstances.confirmOnDelete' => 'Rimuovere le istanze di servizio selezionate?',
    'app.subserviceinstances.serviceName' => 'Nome di servizio',
    'app.subserviceinstances.userName' => 'Utente',

    'contentfiles.name' => 'Nome',
    'contentfiles.changeDate' => 'Modificato',
    'contentfiles.size' => 'Dimens.',
    'contentfiles.permissions' => 'Permessi',
    'contentfiles.user' => 'Utente',
    'contentfiles.group' => 'Gruppo',
    'contentfiles.buttonUploadFiles' => 'Carica file',
    'contentfiles.buttonUploadDirectory' => 'Carica cartella',
    'contentfiles.buttonImportFileViaUrl' => 'Importa file tramite URL',
    'contentfiles.hintUploadFiles' => 'Carica file nella directory attuale.',
    'contentfiles.buttonDeleteFile' => 'Rimuovi',
    'contentfiles.hintDeleteFile' => 'Rimuovi i file selezionati.',
    'contentfiles.buttonPurgeFile' => 'Rimuovi',
    'contentfiles.hintPurgeFile' => 'Rimuovi i file selezionati in modo permanente.',
    'contentfiles.buttonPurgeAll' => 'Cestino vuoto',
    'contentfiles.buttonRotationSettings' => 'Impostazioni rotazione',
    'contentfiles.hintRotationSettings' => 'Personalizza impostazioni di rotazione',
    'contentfiles.hintPurgeAll' => 'Rimuovi tutti i file e le directory dal Cestino in modo permanente.',
    'contentfiles.buttonCopyFiles' => 'Copia',
    'contentfiles.hintCopyFiles' => 'Copia i file selezionati in un\'altra directory.',
    'contentfiles.buttonMoveFiles' => 'Sposta',
    'contentfiles.hintMoveFiles' => 'Sposta i file selezionati verso un\'altra directory.',
    'contentfiles.buttonMoreActions' => 'Altro',
    'contentfiles.buttonCalculateSize' => 'Calcolo dimensione',
    'contentfiles.hintCalculateSize' => 'Calcola la dimensione totale dei file selezionati.',
    'contentfiles.buttonChangeTimestamp' => 'Cambia zona oraria',
    'contentfiles.hintChangeTimestamp' => 'Cambia zona oraria dei file selezionati.',
    'contentfiles.buttonArchiveActions' => 'Archivio',
    'contentfiles.buttonExtractArchive' => 'Estrai file',
    'contentfiles.hintExtractArchive' => 'Estrai file dagli archivi selezionati nella corrente directory.',
    'contentfiles.buttonCreateArchive' => 'Aggiungi all\'archivio',
    'contentfiles.hintCreateArchive' => 'Aggiungi i file selezionati a un archivio.',
    'contentfiles.buttonNewActions' => 'Nuovo',
    'contentfiles.buttonNewFile' => 'Crea File',
    'contentfiles.hintNewFile' => 'Crea un file.',
    'contentfiles.buttonNewDirectory' => 'Crea Directory',
    'contentfiles.hintNewDirectory' => 'Crea una directory.',
    'contentfiles.rootDirectory' => 'Directory principale',
    'contentfiles.buttonView' => 'Vedi opzioni',
    'contentfiles.hintView' => 'Cambia le impostazioni di File Manager.',
    'contentfiles.confirmOnDelete' => 'Vuoi davvero rimuovere definitivamente {count, plural, =1 {il file e la directory {name}} other {i # file e directory selezionati}}?',
    'contentfiles.confirmOnDeleteToTrash' => 'Spostare {count, plural, =1 {il file e la directory {name}} other {i # file e directory selezionati}} nel cestino?',
    'contentfiles.deleteWithForce' => 'Non spostare nel Cestino ma rimuovi definitivamente {count, plural, =1 {il file e la directory {name}} other {i # file e directory selezionati}}.',
    'contentfiles.confirmOnPurge' => 'Rimuovere definitivamente {count, plural, =1 {il file e la directory {name}} other {i # file e directory selezionati}}?',
    'contentfiles.confirmOnPurgeAll' => 'Rimuovere tutti i file e le directory dal Cestino in modo permanente?',
    'contentfiles.waitMessage' => 'Attendere prego...',
    'contentfiles.readonlyHint' => 'Questa directory è solo di lettura: Non è possibile creare file o directory in essa.',
    'contentfiles.directoryNotFound' => 'Impossibile trovare la directory %%directory%%: %%error%%',
    'contentfiles.symlinksOutOfWebspaceProhibited' => 'I collegamenti simbolici fuori dallo spazio web sono proibiti %%symlink%%: %%error%%',
    'contentfiles.dragAndDropArea' => 'Trascina qui file e cartelle per caricarli',
    'contentfiles.nonUTF8' => 'File Manager non può aprire file e directory i cui nomi contengono caratteri non UTF-8',
    'contentfiles.non4ByteChar' => 'File Manager non può aprire file e directory i cui nomi contengono caratteri da 4 byte.',
    'contentfiles.searchInFilename' => 'Cerca nel nome file',
    'contentfiles.searchInFilenameAndContent' => 'Cerca nel nome file e nel contenuto',
    'contentfiles.searchInContent' => 'Cerca nel contenuto',
    'contentfiles.menuItemFilename' => 'Solo nome file',
    'contentfiles.menuItemFilenameAndContent' => 'Nome file e contenuto',
    'contentfiles.menuItemContent' => 'Solo contenuto',
    'contentfiles.noEntriesFound' => 'Nessun articolo trovato.',
    'contentfiles.loadingTitle' => 'Ricerca in corso...',
    'contentfiles.searchError' => 'Impossibile cercare file nella directory attuale.',
    'contentfiles.searchErrorTimeout' => 'La ricerca richiedeva troppo tempo ed è stata annullata.',
    'contentfiles.item-action-view' => 'Mostra',
    'contentfiles.item-action-textCodeEditor' => 'Modifica nell\'editor di codice',
    'contentfiles.item-action-visualEdit' => 'Modifica in Editor HTML',
    'contentfiles.item-action-textEdit' => 'Modifica in Text Editor',
    'contentfiles.item-action-browse' => 'Aprire nel browser',
    'contentfiles.item-action-logBrowser' => 'Apri in Log Browser',
    'contentfiles.item-action-download' => 'Scarica',
    'contentfiles.item-action-permissions' => 'Cambiare Permessi',
    'contentfiles.item-action-rename' => 'Rinomina',
    'contentfiles.item-action-extractArchive' => 'Estrai file',
    'contentfiles.item-action-imageView' => 'Mostra',
    'contentfiles.imageViewer' => 'Visualizzatore di immagini',
    'contentfiles.tooltipReadOnly' => 'La directory corrente è di sola lettura: impossibile creare file o directory al suo interno.',

    'database.issues.type' => 'Tipo',
    'database.issues.table' => 'Tabella',
    'database.issues.code' => 'Codice',
    'database.issues.problem' => 'Problema',
    'database.issues.icon-title-att' => 'Avviso',
    'database.issues.icon-title-warning' => 'Errore',

    'database.users.login' => 'Nome',
    'database.users.server' => 'Server database',
    'database.users.database' => 'Database',
    'database.users.remove' => 'Rimuovi',
    'database.users.hintRemove' => 'Rimuovi gli utenti del database selezionati.',
    'database.users.confirmOnDelete' => 'Vuoi davvero rimuovere {count, plural, =1 {l\'utente del database {login}} one {l\'utente # del database selezionato} other {i # indirizzi e-mail selezionati}}?',
    'database.users.disabledSelectHint' => 'Usato da un\'app web installata',
    'database.users.orphanedHint' => 'Rimasto orfano dopo il processo di ripristino, %%orphanedRepairLink%% l\'utente.',
    'database.users.orphanedRepairLink' => 'ripara',
    'database.users.anyDatabase' => 'Qualsiasi database',
    'database.users.serverTypeMysql' => 'MySQL',
    'database.users.serverTypeMariadb' => 'MariaDB',
    'database.users.serverTypePercona' => 'Percona',
    'database.users.serverTypePostgresql' => 'PostgreSQL',
    'database.users.serverTypeMssql' => 'MS SQL',

    'databases.assignToSubscription' => 'Sposta verso abbonamento',
    'databases.assignToSubscription_powerUser' => 'Sposta verso spazio web',
    'databases.assignToSubscriptionPopupTitle' => 'Sposta i database vero un altro abbonamento',
    'databases.assignToSubscriptionPopupTitle_powerUser' => 'Sposta i database verso un altro spazio web',
    'databases.assignToSubscriptionPopupDesc' => 'I database selezionati saranno spostati verso l\'abbonamento selezionato. Gli utenti del database saranno spostati a meno che possano accedere ad altri database.',
    'databases.assignToSubscriptionPopupDesc_powerUser' => 'I database selezionati saranno spostati verso lo spazio web selezionato. Gli utenti del database saranno spostati a meno che possano accedere ad altri database. Tieni presente che dopo il trasferimento, gli utenti precedenti non saranno in grado di aprire il database per gestire i contenuti usando il link in Plesk.',
    'databases.loading' => 'caricamento in corso',
    'databases.name' => 'Nome',
    'databases.type' => 'T',
    'databases.server' => 'Server del database',
    'databases.users' => 'Utenti',
    'databases.remove' => 'Rimuovi',
    'databases.hintRemove' => 'Rimuovi i database selezionati.',
    'databases.confirmOnDelete' => 'Vuoi davvero rimuovere {count, plural, =1 {il database {name}} one {il database # selezionato} other {i # database selezionati}}?',
    'databases.typeMysql' => 'MySQL',
    'databases.typeMariadb' => 'MariaDB',
    'databases.typePercona' => 'Percona',
    'databases.typePostgresql' => 'PostgreSQL',
    'databases.typeMssql' => 'Server MS SQL',
    'databases.serverMysql' => 'Server MySQL locale',
    'databases.serverPostgresql' => 'Server PostgreSQL locale',
    'databases.serverMssql' => 'Server MS SQL locale',
    'databases.disabledSelectHint' => 'Usato da un\'app web installata',
    'databases.buttonMakeCopy' => 'Copia',
    'databases.buttonMakeCopyHint' => 'Crea una copia esatta del database o copia il suo contenuto in un database esistente.',
    'databases.buttonWebadmin' => 'Webadmin',
    'databases.buttonWebadminHint' => 'Gestisci i database usando un\'interfaccia web.',
    'databases.buttonConnectionInfo' => 'Informazioni della connessione',
    'databases.buttonConnectionInfoHint' => 'Informazioni come il nome di host e le credenziali dell\'utente del database, necessarie per connettere a questo database.',
    'databases.buttonPhpMyAdmin' => 'PhpMyAdmin',
    'databases.buttonMSSQLClientInstruction' => 'Scarica un client SQL locale',
    'databases.buttonMSSQLClientInstructionHint' => 'Scarica un client SQL locale',
    'databases.buttonDownloadDump' => 'Esporta Dump',
    'databases.buttonDownloadDumpHint' => 'Esporta una copia di questo database.',
    'databases.buttonUploadDump' => 'Importa Dump',
    'databases.buttonUploadDumpHint' => 'Importa la tua copia di questo database.',
    'databases.buttonDelete' => 'Rimuovi database',
    'databases.buttonDeleteHint' => 'Rimuovi questo database.',
    'databases.buttonDeleteDisabledHint' => 'Impossibile rimuovere il database.È usato da un\'applicazione web installata.',
    'databases.buttonDeleteConfirmationText' => 'Vuoi davvero rimuovere il database %%name%%?',
    'databases.buttonActiveList' => 'Elenco attivo',
    'databases.buttonActiveListHint' => 'Passa da una modalità di visualizzazione all\'altra',
    'databases.buttonCheckAndFix' => 'Controlla e ripara',
    'databases.buttonCheckAndFixHint' => 'Verifica l\'esistenza di problemi, come la strutta della tabella danneggiata, e risolvili.',
    'databases.buttonAssignToSubscription' => 'Sposta verso abbonamento',
    'databases.buttonAssignToSubscriptionHint' => 'Sposta i database vero un altro abbonamento',
    'databases.buttonAssignToSubscription_powerUser' => 'Sposta verso spazio web',
    'databases.buttonAssignToSubscriptionHint_powerUser' => 'Sposta i database verso un altro spazio web.',
    'databases.promptPassword' => 'Inserisci la password per accedere come utente del database %%login%%.',
    'databases.promptPasswordPopupTitle' => 'Inserisci la password',
    'databases.taskCheckDatabase' => 'Verifica database',
    'databases.taskRepairDatabase' => 'Ripara database',
    'databases.downloadTask' => 'Preparazione di un dump di %%database%% per l\'esportazione...',
    'databases.downloadPopupTitle' => 'Esporta Dump',
    'databases.downloadHint' => 'Stai per creare un dump di %%database%% e scaricarlo.',
    'databases.downloadRelativePath' => 'Salva il dump nella seguente directory',
    'databases.downloadDumpName' => 'Nome di file del dump',
    'databases.downloadDumpAutomatically' => 'Esegui il download automatico del dump dopo la creazione',
    'databases.errorDumpNameEmpty' => 'Indica un nome di dump.',
    'databases.errorDumpNameInvalid' => 'Un nome di dump non può contenere i seguenti caratteri: %%chars%%.',
    'databases.errorDumpNameTooLong' => 'Il nome di file del dump è troppo lungo. Il percorso di un dump on deve superare i %%maxLength%% simboli.',
    'databases.uploadTask' => 'Esegui l\'import di un dump di %%database%%...',
    'databases.uploadPopupTitle' => 'Import del dump del database',
    'databases.uploadHint' => 'Carica un dump da un computer locale o importa un dump archiviato sul tuo server di hosting.',
    'databases.uploadFromFile' => 'Carica',
    'databases.uploadFromWebspace' => 'Importa',
    'databases.recreateDatabase' => 'Crea il database nuovamente',
    'databases.uploading' => 'Importazione in corso...',
    'databases.waitMessage' => 'Attendere prego...',
    'databases.rootDirectory' => 'Directory Root',
    'databases.connectionInfoTitle' => 'Informazione di connessione per %%database%%',
    'databases.connectionInfoDesc' => 'È possibile usare i dettagli di connessione di questo database, per esempio, quando ti sia richiesto di specificarne alcuni durante l\'installazione di un\'applicazione web.',
    'databases.connectionInfoServerAddress' => 'Host',
    'databases.connectionInfoDatabaseName' => 'Nome del database',
    'databases.connectionInfoUserLogin' => 'Nome utente',
    'databases.connectionInfoUserPassword' => 'Password',
    'databases.connectionInfoNoUserLogin' => 'Nessun utente predefinito',
    'databases.buttonClose' => 'Chiudi',
    'databases.nothingFound' => "Nessuna corrispondenza trovata",
    'databases.moreObjectsAvailable' => 'Ci sono ancora %%count%% oggetti disponibili.',

    'dnsaclrecords.value' => 'Indirizzo IP',
    'dnsaclrecords.add' => 'Aggiungi indirizzo IP',
    'dnsaclrecords.remove' => 'Rimuovi',
    'dnsaclrecords.hintRemove' => 'Elimina gli indirizzi IP selezionati.',
    'dnsaclrecords.confirmOnDelete' => 'Rimuovere gli indirizzi IP selezionati?',
    'dnsaclrecords.emptyViewTitle' => 'Il trasferimento di zona non è consentito',
    'dnsaclrecords.emptyViewDescription1' => 'Per motivi di sicurezza, puoi consentire il trasferimento della zona DNS solo verso server registrati nei record NS della zona.',
    'dnsaclrecords.emptyViewDescription2' => 'Per impostare uno o più server verso i quali è consentito il trasferimento, fai clic su "Aggiungi indirizzo IP".',

    'dnsrecords.host' => 'Host',
    'dnsrecords.type' => 'Tipo di record',
    'dnsrecords.value' => 'Valore',
    'dnsrecords.nameServer' => 'Server di nomi',
    'dnsrecords.ipAddress' => 'Indirizzo IP',
    'dnsrecords.ttl' => 'TTL',
    'dnsrecords.buttonCheckHint' => 'Esegui il test della zona DNS sullo stesso server di nomi.',
    'dnsrecords.remove' => 'Rimuovi',
    'dnsrecords.removeRecord' => 'Rimuovere %%selectedRowTitle%%? Non puoi annullare questa azione.',
    'dnsrecords.removeRecords' => 'Rimuovere %%selectedRows%% record? Non puoi annullare questa azione.',
    'dnsrecords.hintRemove' => 'Cancella i DNS selezionati.',
    'dnsrecords.confirmOnDelete' => 'Vuoi davvero rimuovere {count, plural, =1 {il record DNS {host}} one {il # record DNS selezionato} other {i # record DNS selezionati}}?',
    'dnsrecords.turnOff' => 'Disabilita',
    'dnsrecords.hintTurnOff' => 'Disattiva il servizio DNS locale per la zona DNS %%name%%',
    'dnsrecords.turnOn' => 'Abilita',
    'dnsrecords.hintTurnOn' => 'Attiva il servizio DNS locale per la zona %%name%%',
    'dnsrecords.toggleTypeToSlave' => 'Imposta secondario',
    'dnsrecords.toggleTypeToMaster' => 'Imposta primario',
    'dnsrecords.hintToggleTypeToMaster' => 'Fai in modo che questo server agisca come server di nomi primario per la zona %%name%%.',
    'dnsrecords.hintToggleTypeToSlave' => 'Fai in modo che questo server agisca come server di nomi secondario per la zona %%name%%.',
    'dnsrecords.hintToggleTypeDisabled' => 'Impossibile cambiare la modalità del servizio della zona DNS perché la zona DNS %%name%% è servita da un altro server.',
    'dnsrecords.addRecord' => 'Aggiungere record',
    'dnsrecords.hintSpecifyNameServer' => 'Specifica un nuovo server di nomi per %%name%%',
    'dnsrecords.hintAddPrimaryDns' => 'Aggiungi un server DNS primario per %%name%%',
    'dnsrecords.hintAddRecord' => 'Crea un registro della risorsa nella zona DNS %%name%%',
    'dnsrecords.restoreDefault' => 'Reimposta a predefinito',
    'dnsrecords.hintRestoreDefault' => 'Crea di nuovo la zona DNS secondo il modello DNS del server. Tutti i registri delle risorse personalizzate saranno rimossi e si perderanno tutte le modifiche effettuate alla zona dall\'utente.',
    'dnsrecords.syncZone' => 'Applica modello DNS',
    'dnsrecords.hintSyncZone' => 'Applica le modifiche effettuate al modello DNS del server alla zona. I nuovi registri delle risorse possono essere aggiunti e quelli esistenti possono essere rimossi. I registri delle risorse aggiunti o modificati dall\'utente non saranno interessati.',
    'dnsrecords.applyChanges' => 'Le modifiche eseguite nei record DNS non sono ancora salvate. Le modifiche sono segnate nella lista di record. Clicca su Aggiorna per applicare le modifiche alla zona DNS. Clicca su Ripristina per annullare le modifiche.',
    'dnsrecords.updateButtonTitle' => 'Aggiorna',
    'dnsrecords.updateButtonDescription' => 'Salva le modifiche effettuate ai record DNS.',
    'dnsrecords.revertButtonTitle' => 'Ripristina',
    'dnsrecords.revertButtonDescription' => 'Annulla le modifiche effettuate sui record DNS.',
    'dnsrecords.syncZoneFrom' => 'Applica modifiche del modello DNS',
    'dnsrecords.moreActions' => 'Altre azioni',
    'dnsrecords.search' => 'Ricerca',
    'dnsrecords.templateNotSynchronized' => 'Il modello di zona DNS è stato modificato e le modifiche verranno applicate a tutti i nuovi domini creati. Puoi anche %%link%%',
    'dnsrecords.templateNotSynchronizedLinkText' => 'applica le modifiche a tutti i domini ospitati',
    'dnsrecords.soaTemplateNotSynchronized' => 'Il modello SOA è stato modificato e le modifiche verranno applicate a tutti i nuovi domini creati. Puoi anche %%link%%',

    'emails.name' => 'Indirizzo e-mail',
    'emails.owner' => 'Utente',
    'emails.remove' => 'Rimuovere',
    'emails.addNewEmail' => 'Crea indirizzo e-mail',
    'emails.hintAddNewEmail' => 'Crea un indirizzo email e assegnalo ad un utente.',
    'emails.recalculateUsage' => 'Aggiorna le statistiche di utilizzo',
    'emails.hintRecalculateUsage' => 'Calcola di nuovo lo spazio su disco reale utilizzato dalle caselle postali.',
    'emails.outgoingSpamSettings' => 'Limita messaggi in uscita',
    'emails.hintOutgoingSpamSettings' => 'Imposta un limite sui messaggi in uscita per le caselle postali selezionate. Da ogni casella postale, non sarà possibile inviare più messaggi di quelli da te specificati.',
    'emails.searchByEmail' => 'Indirizzo e-mail',
    'emails.hintRemove' => 'Rimuovi gli indirizzi e-mail selezionati.',
    'emails.webMailDisabledHint' => 'Il software webmail non è installato.',
    'emails.webMailHint' => 'Apri webmail per questo indirizzo e-mail in una nuova finestra del browser.',
    'emails.editHint' => 'Scopri come configurare il tuo account e-mail in un programma client di posta, come Microsoft Outook, Outlook Express, Thunderbird e Apple Mail.',
    'emails.confirmOnDelete' => 'Vuoi davvero rimuovere {count, plural, one {} =1 {l\'indirizzo e-mail {name}} other {i # indirizzi e-mail selezionati}}?',
    'emails.redirectDetailsSingle' => '%%firstAddress%%',
    'emails.redirectDetailsMultiple' => '%%firstAddress%% (e %%countLeft%% ancora)',
    'emails.autoresponderEnabled' => 'La risposta automatica è attivata.',
    'emails.autoresponderEnabledTill' => 'La risposta automatica è attivata fino al %%endDate%%.',
    'emails.spaceUsage' => 'Utilizzo',
    'emails.noMailbox' => 'Nessuna casella postale',
    'emails.statusNotOperable' => 'Il servizio di posta non è attivo.',

    'failedrequestfiles.downloadZip' => 'Scarica ZIP',
    'failedrequestfiles.downloadZipHint' => 'Scarica i file selezionati in un archivio ZIP.',
    'failedrequestfiles.name' => 'Nome',
    'failedrequestfiles.modificationDate' => 'Data di modifica',
    'failedrequestfiles.remove' => 'Rimuovi',
    'failedrequestfiles.hintRemove' => 'Elimina i file della richiesta non riuscita che hai selezionato.',
    'failedrequestfiles.confirmOnDelete' => 'Rimuovere i file della richiesta non riuscita che hai selezionato?',
    'failedrequestfiles.viewHint' => 'Fai clic per visualizzare il file della richiesta non riuscita.',
    'failedrequestfiles.buttonChangeTracing' => 'Cambia opzioni di rintracciamento',
    'failedrequestfiles.buttonChangeTracingHint' => 'Cambia le impostazioni di rintracciamento della richiesta non riuscita al momento definite.',
    'failedrequestfiles.buttonDisableTracing' => 'Arresta rintracciamento',
    'failedrequestfiles.buttonDisableTracingHint' => 'Arresta rintracciamento.',
    'failedrequestfiles.buttonEnableTracing' => 'Avvia rintracciamento',
    'failedrequestfiles.buttonEnableTracingHint' => 'Avvia rintracciamento.',
    'failedrequestfiles.buttonRefresh' => 'Aggiorna',
    'failedrequestfiles.buttonRefreshHint' => 'Fai clic qui per mostrare tutte le richieste non riuscite che coincidono con i criteri specificati. Tieni presente che le richieste non riuscite appena registrate non vengono automaticamente mostrate.',

    'files.name' => 'Nome',
    'files.modificationDate' => 'Modificato',
    'files.size' => 'Dimensione',
    'files.share' => 'Condivisione',
    'files.shareHint' => 'Sposta i file selezionati alla cartella File Condivisi, rendendoli accessibili per tutti gli impiegati autorizzati in Plesk.',
    'files.publish' => 'Pubblicare',
    'files.publishHint' => 'Copiare i file selezionati nella cartella File Pubblici, rendendoli pubblicamente accessibili per i clienti e gli utenti del sito web. È possibile proteggere l\'accesso a questi file con una password.',
    'files.email' => 'Link e-mail',
    'files.emailHint' => 'Inviare un link per e-mail che consenta ad altri impiegati e clienti di accedere ai file selezionati.',
    'files.delete' => 'Eliminare',
    'files.deleteHint' => 'Eliminare i file selezionati',
    'files.moreActions' => 'Di più',
    'files.createFolder' => 'Nuova Cartella',
    'files.createFolderHint' => 'Crea una cartella nella corrente cartella',
    'files.copy' => 'Copiare',
    'files.copyHint' => 'Copiare i file o cartelle selezionati in una destinazione a vostra scelta.',
    'files.move' => 'Spostare',
    'files.moveHint' => 'Spostare i file o cartelle selezionati verso una destinazione di vostra scelta.',
    'files.protectedDescription' => 'L\'accesso ai file in questa cartella è protetto da una password. Gli utenti dovranno fornire questa password quando cercheranno di accedere a questi file.',
    'files.nothingSelected' => 'Nessun file o cartella selezionati.',

    'gitrepositories.lastCommitInfo' => 'Ultima informazione di commit:',
    'gitrepositories.deploymentActions' => 'Azioni di implementazione aggiuntive:',

    'logfiles.name' => 'Nome',
    'logfiles.path' => 'Percorso',
    'logfiles.modificationDate' => 'Data di Modifica',
    'logfiles.fileSize' => 'Dimensione',
    'logfiles.logRotation' => 'Rotazione di registro',
    'logfiles.logRotationHint' => 'Configura le impostazioni di rotazione di registri per il sito web.',
    'logfiles.logRotationTitle' => 'Configura rotazione registro',
    'logfiles.remove' => 'Rimuovi',
    'logfiles.hintRemove' => 'Cancella i file di registro selezionati. Potete cancellare soltanto file di registro.',
    'logfiles.confirmOnDelete' => 'Rimuovere i file di registro selezionati?',
    'logfiles.viewHint' => 'Clicca per visualizzare il file di registro.',
    'logfiles.buttonDownloadHint' => 'Clicca per effettuare il download del log.',
    'logfiles.buttonViewHint' => 'Clicca per visualizzare il file di registro in una nuova finestra.',
    'logfiles.addCustomLog' => 'Aggiungi accesso personalizzato',
    'logfiles.addCustomLogHint' => 'Apri un file qualsiasi in Log Browser.',
    'logfiles.customLogPopupTitle' => 'Aggiungi accesso personalizzato',
    'logfiles.invalidLogFormat' => 'Il file di registro contiene un formato non supportato.',
    'logfiles.buttonUnlinkHint' => 'Clicca per smettere di seguire gli aggiornamenti in questo file nel Log Browser',
    'logfiles.buttonUnlinkConfirmationDescription' => 'Sei sicuro di non volere più seguire gli aggiornamenti in questo file nel Log Browser?',
    'logfiles.buttonUnlinkConfirmationYes' => 'Sì',
    'logfiles.buttonUnlinkConfirmationNo' => 'Nessuno',
    'logfiles.accessLog' => 'Accesso Apache',
    'logfiles.accessLogProcessed' => 'Accesso Apache (rotato)',
    'logfiles.accessSslLog' => 'Accesso SSL/TLS Apache',
    'logfiles.accessSslLogProcessed' => 'Accesso SSL/TLS Apache (rotato)',
    'logfiles.errorLog' => 'Errore di Apache',
    'logfiles.proxyAccessLog' => 'Accesso nginx',
    'logfiles.proxyAccessSslLog' => 'Accesso SSL/TLS nginx',
    'logfiles.proxyErrorLog' => 'Errore nginx',
    'logfiles.phpErrorLog' => 'Errore PHP',
    'logfiles.iisAccessLog' => 'Accesso IIS',
    'logfiles.iisLog' => 'IIS (%%name%%)',
    'logfiles.audit' => 'ModSecurity',
    'logfiles.passenger' => 'Node.js',
    'logfiles.iisnode' => 'Node.js',
    'logfiles.laravel' => 'Laravel',
    'logfiles.dotnetcore' => '.NET Core',

    'maillists.title' => 'Liste di Posta',
    'maillists.remove' => 'Rimuovere',
    'maillists.name' => 'Indirizzo',
    'maillists.subscribers' => 'Utenti',
    'maillists.hintRemove' => 'Rimuovere le liste di posta selezionate.',
    'maillists.confirmOnDelete' => 'Rimuovere le liste di posta selezionate?',
    'maillists.openWebPanel' => 'Gestire la lista',
    'maillists.statusNotEnabled' => 'Disattivato.',
    'maillists.statusNotOperable' => 'Il servizio di mailing list è disattivato.',

    'mailsettings.name' => 'Nome di Dominio',
    'mailsettings.mailService' => 'Servizio di posta',
    'mailsettings.webmail' => 'WebMail',
    'mailsettings.nonexist' => 'Posta inviata a utenti inesistenti',
    'mailsettings.webmailNone' => 'Nessuno',
    'mailsettings.nonExistBounce' => 'Rimbalzo con messaggio',
    'mailsettings.nonExistCatch' => 'Inoltra a %%catchAddress%%',
    'mailsettings.nonExistCatchDescription' => 'L\'indirizzo deve appartenere al dominio selezionato. Soltanto l\'amministratore può indicare un indirizzo esterno o un indirizzo per diversi domini.',
    'mailsettings.nonExistExternal' => 'Reindirizza a %%catchIp%%',
    'mailsettings.nonExistReject' => 'Rifiuta',
    'mailsettings.nonExistDiscard' => 'Rifiuta',
    'mailsettings.statusEnabled' => 'Attivato',
    'mailsettings.statusDisabled' => 'Disattivato',
    'mailsettings.statusDisabledIncoming' => 'Disattivato per posta in arrivo',
    'mailsettings.statusNotConfigured' => 'Non configurato',
    'mailsettings.searchByName' => 'Nome di Dominio',
    'mailsettings.editOutgoingSpamSettings' => 'Modificare limite',
    'mailsettings.numberOutgoingMessages' => 'Numero di messaggi in uscita',

    'roles.title' => 'Ruoli Utente',
    'roles.name' => 'Nome di Ruolo',
    'roles.description' => 'Descrizione',
    'roles.remove' => 'Rimuovere',
    'roles.numberOfUsers' => 'Utenti',
    'roles.hintRemove' => 'Rimuovere i ruoli utente selezionati. È possibile rimuovere i ruoli solo se non sono stati assegnati a un account utente.',
    'roles.disabledSelectHint' => 'Questo ruolo è stato assegnato a uno o più account utente. È possibile rimuovre i ruoli solo se non sono stati assegnati a un account utente.',
    'roles.builtInItemHint' => 'Impossibile modificare o rimuovere questo ruolo.',
    'roles.confirmOnDelete' => 'Rimuovere i ruoli utenti selezionati?',

    'sites.selectdns.domain' => 'Dominio',
    'sites.selectdns.dnsStatus' => 'Stato',
    'sites.selectdns.statusOff' => 'La gestione della zona DNS è disattivata.',
    'sites.selectdns.statusMaster' => 'La zona DNS è in modalità master.',
    'sites.selectdns.statusSlave' => 'La zona DNS è in modalità slave.',
    'sites.selectdns.linkManage' => 'Gestisci',

    'sites.selectfrontpage.domain' => 'Dominio',
    'sites.selectfrontpage.linkManage' => 'Gestisci',

    'sites.selectsimple.domain' => 'Dominio',
    'sites.selectsimple.linkManage' => 'Gestisci',
    'sites.selectsimple.linkView' => 'Visualizza',

    'sites.selectstatistics.domain' => 'Dominio',
    'sites.selectstatistics.linkView' => 'Visualizza',

    'sites.selecttrafficstatistics.domain' => 'Dominio',
    'sites.selecttrafficstatistics.linkView' => 'Visualizza',

    'sites.selectwebdeploy.domain' => 'Dominio',
    'sites.selectwebdeploy.linkDownload' => 'Scarica',

    'sites.unitymobile.website' => 'Sito web',
    'sites.unitymobile.mobileSite' => 'Nome del sito mobile',
    'sites.unitymobile.createSite' => 'Crea sito mobile',
    'sites.unitymobile.launchEditor' => 'Modifica contenuto del sito',
    'sites.unitymobile.changeSiteName' => 'Modifica nome sito',
    'sites.unitymobile.delete' => 'Rimuovi',
    'sites.unitymobile.confirmDeleteTitle' => 'Si desidera rimuovere questo sito mobile?',
    'sites.unitymobile.confirmDeleteDescription' => 'Tutti i contenuti del sito verranno persi.',

    'sites.domainHeader' => 'Dominio',
    'sites.hostingHeader' => 'Hosting',
    'sites.diskUsage' => 'Utilizzo del disco',
    'sites.traffic' => 'Traffico',
    'sites.buttonAddDomain' => 'Aggiungi dominio',
    'sites.buttonAddDomainHint' => 'Ospita un nuovo sito web su questo server, configura l\'inoltro web verso un altro sito web o configura una zona DNS del dominio se desideri avere solo indirizzi e-mail in un nome di dominio.',
    'sites.buttonAddSubdomain' => 'Aggiungi sottodominio',
    'sites.buttonAddSubdomainHint' => 'Crea un sito indirizzato da un nome di dominio di terzo livello, come shop.esempio.com.',
    'sites.buttonAddDomainAlias' => 'Aggiungi alias di dominio',
    'sites.buttonAddDomainAliasHint' => 'Configura un nome di dominio aggiuntivo per il tuo sito.',
    'sites.buttonRemove' => 'Rimuovi',
    'sites.buttonRemoveHint' => 'Rimuovi i siti selezionati e tutto il contenuto web all\'interno, includento le applicazioni ed i dati di posta.',
    'sites.buttonActivate' => 'Attiva',
    'sites.buttonSuspend' => 'Sospendi',
    'sites.buttonClassicList' => 'Elenco classico',
    'sites.buttonClassicListHint' => 'Passa da una modalità di visualizzazione all\'altra',
    'sites.buttonActiveList' => 'Elenco attivo',
    'sites.buttonActiveListHint' => 'Passa da una modalità di visualizzazione all\'altra',
    'sites.buttonDynamicList' => 'Elenco dinamico',
    'sites.buttonDynamicListHint' => 'Passa da una modalità di visualizzazione all\'altra',
    'sites.buttonFileManager' => 'Manager di File',
    'sites.buttonMail' => 'Posta',
    'sites.buttonDatabases' => 'Database',
    'sites.buttonDatabasesCreate' => 'Aggiungi database',
    'sites.buttonDatabasesTogglerText' => 'Oppure',
    'sites.buttonDatabasesToggle' => 'Selezionare un database esistente',
    'sites.buttonDatabasesEdit' => 'Apri',
    'sites.buttonDatabasesPromptPassword' => 'Inserisci la password per accedere come utente del database %%login%%.',
    'sites.removeConfirmation' => 'Vuoi davvero rimuovere {count, plural, one {} =1 {il sito {name}} other {i # siti selezionati}}?',
    'sites.removeConfirmationSubscription' => "Verranno rimossi anche i seguenti siti:\n%%domains%%",
    'sites.manageFilesHint' => 'Vai alla cartella del sito web per gestire i file del sito web.',
    'sites.sitebuilderHint' => 'Modifica il sito in Presence Builder.',
    'sites.webstatisticsHint' => 'Visualizza le statistiche sulle visite al sito web.',
    'sites.webstatisticsSslHint' => 'Visualizza i report sulle visite dei tuoi siti web attraverso SSL/TLS.',
    'sites.certificatesHint' => 'Gestisci certificati SSL/TLS.',
    'sites.logsHint' => 'Visualizza registri.',
    'sites.previewHint' => 'Visualizza l\'anteprima del sito web nel tuo browser.',
    'sites.dnsHint' => 'Cambia le impostazioni della zona DNS.',
    'sites.disabledSelectHint' => 'Il dominio non può essere rimosso.',
    'sites.websiteAt' => 'Sito web su',
    'sites.noHosting' => 'Nessun hosting web',
    'sites.forwardingTo' => 'Inoltra verso',
    'sites.add' => 'aggiungi',
    'sites.name' => 'Nome del dominio',
    'sites.inactive' => 'Inattivo',
    'sites.disabled' => 'Disabilitato',
    'sites.suspended' => 'Sospeso',
    'sites.moreActions' => 'Altre azioni',
    'sites.domainAliasDescription' => 'Alias per %%siteDisplayName%% %%servicesDescription%%',
    'sites.domainAliasServiceDescription' => '(Servizi attivati: %%service%%)',
    'sites.domainAliasServicesDescription' => '(Servizi attivati: %%services%%)',
    'sites.web' => 'Web',
    'sites.mail' => 'Posta',
    'sites.dns' => 'DNS',
    'sites.tomcat' => 'Applicazioni Java',
    'sites.seoRedirect' => 'Reindirizzamento',
    'sites.sitebuilder' => 'Presence Builder',
    'sites.sitebuilderLink' => 'Modifica sito web',
    'sites.error503PageLink' => 'Modifica pagina di errore',
    'sites.modeTitle' => 'Modalità di visualizzazione',
    'sites.quickStart' => 'Inizia a creare il sito web utilizzando uno dei metodi disponibili:',
    'sites.quickStartSitebuilderName' => 'Utilizzo di Presence Builder',
    'sites.quickStartSitebuilderDescription' => 'Crea il tuo sito utilizzando il nostro Website Builder professionale.',
    'sites.quickStartSitebuilderLink' => 'Crea sito',
    'sites.quickStartSiteJetBuilderName' => 'Usa Sitejet Builder',
    'sites.quickStartSiteJetBuilderDescription' => 'Crea il tuo sito utilizzando il nostro Website Builder professionale.',
    'sites.quickStartSiteJetBuilderLink' => 'Crea sito',
    'sites.quickStartApplicationsName' => 'Installa un\'applicazione',
    'sites.quickStartApplicationsDescription' => 'Crea il tuo sito installando un\'app web, quale Joomla! o Drupal.',
    'sites.quickStartApplicationsLink' => 'Installa app',
    'sites.quickStartCustomName' => 'Crea un sito web personalizzato',
    'sites.quickStartCustomDescription' => 'Carica il contenuto web e aggiungi i database.',
    'sites.quickStartCustomFilesLink' => 'File',
    'sites.quickStartCustomDatabasesLink' => 'Database',
    'sites.resellerDescription' => 'Rivenditore',
    'sites.ownerDescription' => 'Cliente',

    'sites.filterDomainName' => 'Nome',
    'sites.filterStatus' => 'Stato',
    'sites.filterOptionStatusAny' => 'Qualsiasi',
    'sites.filterOptionStatusSuspended' => 'Sospeso',
    'sites.filterOptionStatusDisabled' => 'Disabilitato',
    'sites.filterOptionStatusActive' => 'Attivo',
    'sites.filterHostingType' => 'Tipologia di hosting',
    'sites.filterOptionHostingTypeAny' => 'Qualsiasi',
    'sites.filterOptionHostingTypeNone' => 'Nessun hosting',
    'sites.filterOptionHostingTypeForward' => 'Inoltro di domini',
    'sites.filterOptionHostingTypeAlias' => 'Alias di dominio',
    'sites.filterOptionHostingTypeVirtualHost' => 'Hosting del dominio',
    'sites.filterOptionHostingTypeSubdomain' => 'Hosting di sottodomini',
    'sites.filterOptionPhpHandlerAny' => 'Qualsiasi',
    'sites.filterDescription' => 'Descrizione',

    'sslcertificates.name' => 'Nome',
    'sslcertificates.used' => 'Usato',
    'sslcertificates.csrHint' => 'CSR fornito.',
    'sslcertificates.noCsrHint' => 'CSR non fornito.',
    'sslcertificates.privateKeyHint' => 'Chiave privata fornita.',
    'sslcertificates.noPrivateKeyHint' => 'Chiave privata non fornita.',
    'sslcertificates.certificateHint' => 'Certificato fornito.',
    'sslcertificates.noCertificateHint' => 'Certificato non fornito.',
    'sslcertificates.caCertificateHint' => 'Certificato CA fornito.',
    'sslcertificates.noCaCertificateHint' => 'Certificato CA non fornito.',
    'sslcertificates.buttonDownloadHint' => 'Scarica tutti i componenti del certificato.',
    'sslcertificates.webmail' => 'Proteggi Webmail',
    'sslcertificates.hintWebmail' => 'Utilizzare il certificato SSL/TLS selezionato per proteggere la webmail nel dominio.',
    'sslcertificates.remove' => 'Rimuovi',
    'sslcertificates.hintRemove' => 'Rimuovi i certificati SSL/TLS selezionati dall\'archivio del dominio.',
    'sslcertificates.confirmOnDelete' => 'Rimuovere i certificati SSL/TLS selezionati?',
    'sslcertificates.addCertificate' => 'Aggiungere Certificato SSL/TLS',
    'sslcertificates.hintAddCertificate' => 'Aggiungi un certificato SSL/TLS.',
    'sslcertificates.viewCertificates' => 'Visualizza certificati',
    'sslcertificates.hintViewCertificates' => 'Visualizza la lista di certificati SSL/TLS che hai acquistato dal provider.',
    'sslcertificates.webmailCertificate' => 'Protegge la Webmail',
    'sslcertificates.mailCertificate' => 'Protegge la posta',
    'sslcertificates.mailAndWebmailCertificate' => 'Protegge sia la posta che la Webmail',
    'sslcertificates.mail' => 'Proteggi la posta',
    'sslcertificates.hintMail' => 'Utilizza il certificato SSL/TLS selezionato per proteggere la posta per il dominio.',

    'subscriptions.subscription' => 'Abbonamento',
    'subscriptions.price' => 'Tassa',
    'subscriptions.renewalDate' => 'Data di scadenza',
    'subscriptions.setupDate' => 'Data di configurazione',
    'subscriptions.domains' => 'Siti web',
    'subscriptions.systemUser' => 'Utente di sistema',
    'subscriptions.ipAddress' => 'Indirizzo IP',
    'subscriptions.addonDomains' => 'Domini aggiuntivi',
    'subscriptions.diskSpace' => 'Spazio su disco',
    'subscriptions.moreDomains' => '... e %%count%% altri domini',
    'subscriptions.buy' => 'Acquista nuovo abbonamento',
    'subscriptions.create' => 'Crea abbonamento',
    'subscriptions.create_powerUser' => 'Crea spazio web',
    'subscriptions.renew' => 'Rinnovo',
    'subscriptions.confirmOnCancel' => 'Vuoi annullare l\'abbonamento?',
    'subscriptions.subscriptionSuspended' => 'Sospeso',
    'subscriptions.myResources' => 'Le mie risorse',
    'subscriptions.planName' => 'Piano di servizio',
    'subscriptions.switchToLink' => 'Passa all\'abbonamento',
    'subscriptions.switchToLinkHint' => 'Passa a questo abbonamento.',
    'subscriptions.switchToLinkPowerUser' => 'Passare allo spazio web',
    'subscriptions.switchToLinkHintPowerUser' => 'Passare a questo spazio web.',
    'subscriptions.buttonRemove' => 'Rimuovi',
    'subscriptions.buttonRemoveDescription' => 'Rimuovi gli spazi web selezionati',
    'subscriptions.confirmOnDelete' => 'Rimuovi gli spazi web selezionati?',
    'subscriptions.buttonAddNew' => 'Aggiungi spazio web',
    'subscriptions.buttonAddNewDescription' => 'Creare uno spazio web.',
    'subscriptions.subscription_powerUser' => 'Spazio web',
    'subscriptions.subscriptionPowerUser' => 'Spazio web',
    'subscriptions.confirmOnCancel_powerUser' => 'Vuoi cancellare lo spazio web?',
    'subscriptions.subscriptionSuspended_powerUser' => 'Sospeso',
    'subscriptions.switchToLink_powerUser' => 'Passa allo spazio web',
    'subscriptions.switchToLinkHint_powerUser' => 'Passa a questo spazio web.',
    'subscriptions.primaryDomain' => 'Dominio principale',
    'subscriptions.ftpAccess' => 'Accesso a FTP',

    'users.contactName' => 'Nome del contatto',
    'users.email' => 'Indirizzo e-mail',
    'users.role' => 'Ruolo',
    'users.contacts' => 'Contatti',
    'users.phone' => 'Telefono',
    'users.roleFilter' => 'Ruolo utente',
    'users.filterAnyRole' => 'Qualsiasi',
    'users.activate' => 'Riattiva',
    'users.deactivate' => 'Sospendere',
    'users.remove' => 'Rimuovere',
    'users.status' => 'Stato',
    'users.statusBlocked' => 'Inattivo',
    'users.buttonAddNewUser' => 'Crea Account Utente',
    'users.hintAddNewUser' => 'Crea un account utente.',
    'users.hintRemove' => 'Rimuovere gli account utente selezionati.',
    'users.disabledSelectHint' => 'Impossibile rimuovere questo account utente perché si tratta di un account utente incorporato o del proprio account utente.',
    'users.confirmOnDelete' => 'Rimuovere gli account utente selezionati?',

    'webusers.name' => 'Nome',
    'webusers.add' => 'Aggiungi utente web',
    'webusers.hintAdd' => 'Aggiungi un account utente web. %%resourceUsage%%',
    'webusers.settings' => 'Impostazioni',
    'webusers.hintSettings' => "Impostazioni dell'utente web.",
    'webusers.remove' => 'Rimuovi',
    'webusers.hintRemove' => 'Rimuovi gli utenti web selezionati.',
    'webusers.confirmOnDelete' => 'Rimuovere gli utenti web selezionati?',
    'webusers.buttonOpenHomepageHint' => "Fai clic per accedere alla home page dell'utente web tramite il browser.",

    'virtualdirectories.protection' => 'P',
    'virtualdirectories.name' => 'Nome',
    'virtualdirectories.actionOpen' => 'Apri nel browser',
    'virtualdirectories.actionEdit' => 'Modifica impostazioni',
    'virtualdirectories.actionPermissions' => 'Gestisci permessi',
    'virtualdirectories.up_levelType' => 'Livello superiore',
    'virtualdirectories.directoryType' => 'Directory fisica',
    'virtualdirectories.virtual_directoryType' => 'Directory virtuale',
    'virtualdirectories.fileType' => 'File fisico',
    'virtualdirectories.protectionOn' => 'Questa directory è protetta',
    'virtualdirectories.protectionOff' => 'Questa directory non è protetta',
    'virtualdirectories.isMissing' => 'Questa directory virtuale è collegata a una cartella fisica inesistente',
    'virtualdirectories.buttonRemove' => 'Rimuovi',
    'virtualdirectories.noSelectionText' => 'Seleziona uno o più elementi da rimuovere',
    'virtualdirectories.removeConfirmation' => 'Vuoi rimuovere {count, plural, =1 {{name}} one {l\'elemento selezionato} other {# elementi}}?',
    'virtualdirectories.removeSuccess' => 'Gli elementi selezionati sono stati rimossi.',
    'virtualdirectories.buttonCreateVirtualDir' => 'Creare Directory Virtuale',
    'virtualdirectories.buttonCreateVirtualDirHint' => 'Crea una directory virtuale',
    'virtualdirectories.buttonCreateDir' => 'Crea Directory',
    'virtualdirectories.buttonCreateDirHint' => 'Crea una directory',
];