<?php
// Copyright 1999-2024. Plesk International GmbH. All rights reserved.
$messages = [
    'title' => 'Vérification des journaux du site Web',

    'regularCheck' => 'Vérification automatique',
    'manualCheck' => 'Vérification manuelle',

    'promoTitle' => 'Détection rapide des dysfonctionnements ou de l\'indisponibilité de vos sites Web',
    'promoDescription' => 'Les problèmes de sites Web sont souvent visibles pour les utilisateurs mais pas pour les administrateurs, sauf s\'ils analysent constamment les journaux de leurs sites Web. Notre tout nouveau système de vérification des journaux de sites Web automatise cette tâche et vous aide à résoudre efficacement les problèmes.',
    'promoMore' => 'En savoir plus',
    'promoButton' => 'J\'ai compris !',
    'checkEnabledTitle' => 'Vérification automatique activée',
    'checkDisabledTitle' => 'Vérification automatique désactivée',
    'disabledDescription' => 'Activez la vérification automatique pour détecter les problèmes qui peuvent rendre vos sites indisponibles ou perturber leur fonctionnement.',
    'websitesAllChecked' => '{count, plural, one {# site Web est vérifié} other {# sites Web sont vérifiés}} tous les jours',
    'websitesAllCheckedAt' => '{count, plural, one {# site Web est vérifié} other {# sites Web sont vérifiés}} tous les jours à %%time%%',
    'websitesChecked' => '%%count%% sur %%totalCount%% sites Web seront vérifiés tous les jours',
    'websitesCheckedAt' => '%%count%% sur %%totalCount%% sites Web seront vérifiés tous les jours à %%time%%',
    'checkedWebsites' => 'Liste des sites Web vérifiés',
    'lastCheckDescription' => 'La dernière vérification a duré %%duration%% minutes.',
    'durationLess' => 'moins de 0,1',
    'month0' => '%%date%% jan',
    'month1' => '%%date%% fév',
    'month2' => '%%date%% mar',
    'month3' => '%%date%% avr',
    'month4' => '%%date%% mai',
    'month5' => '%%date%% jun',
    'month6' => '%%date%% jul',
    'month7' => '%%date%% aoû',
    'month8' => '%%date%% sep',
    'month9' => '%%date%% oct',
    'month10' => '%%date%% nov',
    'month11' => '%%date%% déc',
    'export' => 'Exporter le rapport au format CSV',
    'buttonRun' => 'Exécuter une vérification manuelle',
    'buttonRunDescription' => 'Pour revérifier les sites Web déjà corrigés ou détecter les problèmes qui ne sont pas apparus lors de la dernière vérification.',

    'websites.title' => 'Sites Web à vérifier',
    'websites.description' => '%%selected%% sur %%total%% sites Web sont sélectionnés',
    'websites.search' => 'Trouver des sites Web...',
    'websites.new' => 'Tous les sites Web créés récemment',
    'websites.newHint' => 'Cochez pour lancer automatiquement les vérifications de tous les nouveaux sites Web.',
    'websites.existing' => 'Tous les sites Web existants',
    'websites.buttonSave' => 'Enregistrer',
    'websites.buttonCancel' => 'Annuler',
    'websites.updateSuccess' => 'Les paramètres ont été mis à jour',

    'tabs.problemDetails' => 'Détails du problème',
    'tabs.affectedWebsites' => 'Sites Web concernés',

    'chart.requests' => 'Requêtes',
    'chart.errors' => 'Erreurs',

    'affected-websites.selected' => '%%selectedCount%% sur %%totalCount%% sites Web ont été sélectionnés',
    'affected-websites.none' => 'Aucun',
    'affected-websites.all' => 'Tout',
    'affected-websites.searchForWebsite' => 'Rechercher des sites Web',
    'affected-websites.websites' => 'Sites Web',
    'affected-websites.showProblemDetails' => 'Afficher les détails du problème',

    'problem-report.domainTitle' => 'Problème signalé sur %%domain%%',
    'problem-report.cumulativeTitle' => 'Problème signalé sur {count, plural, one {# site Web} other {# sites Web}}',
    'problem-report.serverwideTitle' => 'Problème signalé pour tout le serveur',
    'problem-report.problemAppearsOn' => 'Ce problème se produit sur {count, plural, one {# site Web} other {# sites Web}} au total.',
    'problem-report.seeTheConsolidatedReport' => 'Voir le rapport consolidé',
    'problem-report.cause' => 'Cause principale',
    'problem-report.possibleSolutions' => 'Solutions possibles',
    'problem-report.useAnOption' => 'Utiliser une option pour une solution automatique',
    'problem-report.repairTheWebsite' => 'Réparer le site Web',
    'problem-report.selectAndRepair' => 'Sélectionner et réparer plusieurs sites Web',
    'problem-report.distributionOfTheProblem' => 'Apparition du problème sur le temps',
    'problem-report.serverTimezone' => 'Fuseau horaire du serveur (UTC%%utcShift%%)',
    'problem-report.yourTimezone' => 'Votre fuseau horaire (UTC%%utcShift%%)',
    'problem-report.logEntries' => 'Exemple d\'entrées de journaux signalant le problème',
    'problem-report.pleaseKeepInMind' => 'Remarque : Plesk effectue en permanence des rotations de journaux et risque d\'archiver ou de supprimer les entrées de journaux mentionnées.',
    'problem-report.weRecommendToRecheck' => '%%recheckWebsite%% : recommandé après chaque tentative de correction.',
    'problem-report.recheckWebsite' => 'Revérifier le site Web manuellement',
    'problem-report.option' => 'Option %%number%% :',
    'problem-report.recommended' => 'recommandé',
    'problem-report.numberOfEntries' => 'Nombre d\'entrées',
    'problem-report.logEntry' => 'Entrée du journal',
    'problem-report.logFile' => 'Fichier journal',
    'problem-report.openWebsiteLogs' => 'Ouvrir les journaux du site Web',
    'problem-report.thisIsServerWideProblem' => 'Ce problème concernant tout le serveur affecte tous les sites Web hébergés.',
    'problem-report.serverWideTitle' => 'Problème signalé pour tout le serveur',
    'problem-report.checkDetectedIssue' => 'La vérification a détecté un problème (fuseau horaire du serveur - UTC%%timezone%%) :',
    'problem-report.todayAt' => 'aujourd\'hui à %%time%%',
    'problem-report.yesterdayAt' => 'hier à %%time%%',
    'problem-report.dateAt' => '%%date%% à %%time%%',
    'problem-report.firstProblemTime' => 'Première fois - %%info%%',
    'problem-report.lastProblemTime' => 'Dernière fois - %%info%%',

    'distribution-over-time.title' => 'Apparition du problème sur le temps',
    'distribution-over-time.titleYesterday' => 'Répartition du problème sur la période (hier)',
    'distribution-over-time.titleToday' => 'Répartition du problème sur la période (aujourd\'hui)',
    'distribution-over-time.serverTimezone' => 'Fuseau horaire du serveur (UTC%%utcShift%%)',
    'distribution-over-time.yourTimezone' => 'Votre fuseau horaire (UTC%%utcShift%%)',
    'distribution-over-time.weRecomendComparing' => 'Nous vous recommandons de comparer le graphique de répartition des erreurs avec %%link%% dans Monitoring.',
    'distribution-over-time.resourceUsageCharts' => 'Graphique d\'utilisation des ressources',
    'distribution-over-time.noDataForRecentTime' => 'Aucune donnée pour la période récente. %%suggestion%%',
    'distribution-over-time.pleseEnableRegularCheck' => 'Activez la vérification automatique ou vérifiez manuellement le site Web.',
    'distribution-over-time.pleseIncludeWebsiteForCheck' => 'Ajoutez le site Web à la liste des sites vérifiés automatiquement ou vérifiez le site Web manuellement.',
    'distribution-over-time.pleaseWaitUntilRegularCheckWillBeStarted' => 'Patientez jusqu\'au démarrage de la vérification automatique ou vérifiez manuellement le site Web.',
    'distribution-over-time.enableRegularCheck' => 'Activer la vérification automatique',
    'distribution-over-time.addWebsiteToRegularCheckList' => 'Ajoutez le site Web à la liste des sites vérifiés automatiquement',
    'distribution-over-time.runManualCheck' => 'Exécuter une vérification manuelle',

    'report.title' => 'Rapport de la dernière vérification',
    'report.groupByWebsites' => 'Regroupé par sites Web',
    'report.groupByProblems' => 'Par problème',
    'report.columnWebsite' => 'Site Web',
    'report.columnStatus' => 'Problèmes',
    'report.columnProblem' => 'Problème',
    'report.columnAppearedOn' => 'Detected on',
    'report.serverWideName' => 'Problèmes affectant tout le serveur',
    'report.serverWideDescription' => 'Ces problèmes affectent tout le serveur et les sites Web hébergés.',
    'report.statusProblemsFound' => '%%count%% trouvé(s)',
    'report.statusProblemsFoundFull' => '{count, plural, one {# problème trouvé} other {# problèmes trouvés}}',
    'report.statusProblemsSolved' => '%%count%% disparu(s)',
    'report.statusProblemsSolvedFull' => '{count, plural, one {# problème a disparu} other {# problèmes ont disparus}}',
    'report.statusSuccess' => '0 problème',
    'report.serverWide' => 'Tout le serveur',
    'report.appearedOn' => '{count, plural, one {# site Web} other {# sites Web}}',
    'report.recheckWebsite' => 'Revérifier le site Web',
    'report.actionOpen' => 'Ouvrir',
    'report.actionManage' => 'Gérer',
    'report.actionLogs' => 'Afficher les journaux',
    'report.searchWebsite' => 'Trouver des sites Web...',
    'report.searchProblem' => 'Détecter les problèmes...',
    'report.groupByProblemsTotal' => '{totalRows, plural, one {# problème} other {# problèmes}} sur {websitesCount, plural, one {# site Web} other {# sites Web}}',
    'report.noProblemsTitle' => 'Aucun problème détecté sur {websitesCount, plural, one {# site Web} other {# sites Web}}',
    'report.noProblemsDescription' => 'Apparemment, vos sites Web fonctionnent bien, bravo !',

    'problems.columnTitle' => 'Problème',
    'problems.columnRegular' => 'Vérification automatique',
    'problems.columnManual' => 'Vérification manuelle',
    'problems.run' => '%%fromTime%% %%fromDate%% - %%toTime%% %%toDate%%',
    'problems.runSameDay' => '%%fromTime%% - %%toTime%% à %%toDate%%',
    'problems.notRun' => 'pas encore effectué',
    'problems.resultDetected' => 'Détecté',
    'problems.resultNotDetected' => 'Non détecté',
    'problems.resultNoProblems' => '0 problème',

    'new-check.title' => 'Vérification manuelle',
    'new-check.titleForWebsite' => 'Vérification manuelle du site %%website%%',
    'new-check.titleRunning' => 'Vérification manuelle : {count, plural, one {# site Web} other {# sites Web}}',
    'new-check.description' => '%%selected%% sur %%total%% sites Web sont sélectionnés',
    'new-check.depth' => 'Période de vérification',
    'new-check.checkTheLast' => 'Check the last',
    'new-check.selectHours' => 'Heures',
    'new-check.selectMinutes' => 'Minutes',
    'new-check.ifYouHaveAnyProblemActivities' => 'Si vous avez essayé de corriger les problèmes du site Web, définissez la période après cette tentative, sinon Plesk risque de vous signaler des problèmes que vous avez peut-être déjà résolus.',
    'new-check.weAlsoRecommendVisiting' => 'Avant d\'exécuter une vérification manuelle, nous vous recommandons de %%visitingTheWebsite%% et d\'essayer de reproduire le problème.',
    'new-check.visitingTheWebsite' => 'visiter le Web',
    'new-check.hours' => 'dernières heures',
    'new-check.websites' => 'Sites Web à vérifier',
    'new-check.buttonSave' => 'Vérifier',
    'new-check.buttonCancel' => 'Annuler',
    'new-check.search' => 'Trouver des sites Web...',
    'new-check.checkProblems' => 'Sites Web avec des problèmes lors de la dernière vérification',
    'new-check.allWebsites' => 'Tous les sites Web',
];