<?php
// Copyright 1999-2024. Plesk International GmbH. All rights reserved.
$messages = [
    'adminaliases.statusActive' => 'The account is active.',
    'adminaliases.statusInactive' => 'The account is suspended: This administrator is unable to log in to Plesk.',
    'adminaliases.buttonRemoveAdminAlias' => 'Remove',
    'adminaliases.hintRemoveAdminAlias' => 'Remove selected administrator accounts.',
    'adminaliases.confirmOnRemove' => 'Do you really want to remove the selected administrator accounts?',
    'adminaliases.buttonAddNewAdminAlias' => 'Add Administrator Account',
    'adminaliases.hintAddNewAdminAlias' => 'Create an additional administrator account.',
    'adminaliases.buttonMoreActions' => 'More',
    'adminaliases.buttonActivateAdminAlias' => 'Activate',
    'adminaliases.hintActivateAdminAlias' => 'Activate suspended administrator accounts.',
    'adminaliases.buttonDeactivateAdminAlias' => 'Suspend',
    'adminaliases.hintDeactivateAdminAlias' => 'Suspend selected administrator accounts. Plesk will deny access for these administrators.',
    'adminaliases.confirmOnDelete' => 'Do you really want to remove the selected administrator accounts?',
    'adminaliases.login' => 'Username',
    'adminaliases.contact' => 'Contact name',
    'adminaliases.email' => 'Email',
    'adminaliases.comments' => 'Comments',

    'appinfo.installedAt' => 'Installation path',
    'appinfo.noInstallationUrlAvailable' => 'None',
    'appinfo.subscriptionName' => 'Subscription',
    'appinfo.subscriptionOwner' => 'Subscription owner',
    'appinfo.buttonLogin' => 'Open in Customer Panel',
    'appinfo.buttonLoginClassicMode' => 'Manage Hosting',
    'appinfo.hintLogin' => 'Open the subscriber\'s Customer Panel.',
    'appinfo.hintAdminLogin' => 'Manage hosting services associated with a certain hosting account: Domains and DNS, web apps and databases, mail, and so on.',
    'appinfo.hintLoginClassicMode' => 'Manage hosting services associated with a certain hosting account: Domains and DNS, web apps and databases, mail, and so on.',
    'appinfo.update' => 'Updates are available.',
    'appinfo.updateFailed' => 'Updating failed.',
    'appinfo.noUpdates' => 'No updates are available.',
    'appinfo.foundUpdates' => 'Updates are available for the following apps: ',
    'appinfo.buttonCheckForUpdates' => 'Check for Updates',
    'appinfo.buttonCheckForUpdatesDescription' => 'Check for available updates.',
    'appinfo.buttonChangeSettings' => 'Settings',
    'appinfo.buttonChangeSettingsDescription' => 'Change server-wide settings of the app.',
    'appinfo.appNotConfigured' => 'Not configured',

    'appuploaded.name' => 'Name',
    'appuploaded.numberOfInstances' => 'Number of installations',
    'appuploaded.buttonUploadNewApp' => 'Add App',
    'appuploaded.buttonUploadNewAppDescription' => 'Add an app package to the server.',
    'appuploaded.buttonRemove' => 'Remove',
    'appuploaded.buttonRemoveDescription' => 'Remove selected packages.',
    'appuploaded.confirmOnDelete' => 'Are you sure you want to remove the selected packages?',
    'appuploaded.appInvisible' => 'Not available to customers',
    'appuploaded.appGlobalSettingsNotSet' => 'Not configured',
    'appuploaded.buttonMakeAppVisible' => 'Make Available',
    'appuploaded.buttonMakeAppVisibleDescription' => 'Make apps available for installation by customers.',
    'appuploaded.buttonMakeAppInvisible' => 'Make Unavailable',
    'appuploaded.buttonMakeAppInvisibleDescription' => 'Make apps unavailable for installation by customers.',

    'appusage.name' => 'Name',
    'appusage.numberOfInstances' => 'Number of installations',
    'appusage.buttonCleanApplicationCache' => 'Clear Cache',
    'appusage.buttonCleanApplicationCacheDescription' => 'Delete temporary files downloaded during installation of apps.',
    'appusage.buttonRedirectToMarket' => 'Go to Online Store',
    'appusage.buttonRedirectToMarketDescription' => 'Purchase app licenses for installing on websites.',
    'appusage.updateFailed' => 'Updating failed.',
    'appusage.noUpdates' => 'No updates are available.',
    'appusage.foundUpdates' => 'Updates are available for the following apps: ',
    'appusage.buttonCheckForUpdates' => 'Check for Updates',
    'appusage.buttonCheckForUpdatesDescription' => 'Check for available updates in Application Catalog.',
    'appusage.buttonUpdateSettings' => 'Update Settings',
    'appusage.buttonUpdateSettingsDescription' => 'Server-wide app update settings.',

    'controlpanelaccessnetworks.ipAddress' => 'IP address',
    'controlpanelaccessnetworks.subnetMask' => 'Subnet Mask',
    'controlpanelaccessnetworks.buttonAddNewNetwork' => 'Add Network',
    'controlpanelaccessnetworks.buttonAddNewNetworkDescription' => 'Click to add the network to the access restriction list.',
    'controlpanelaccessnetworks.buttonRemove' => 'Remove',
    'controlpanelaccessnetworks.buttonRemoveDescription' => 'Click to remove the selected networks from the list.',
    'controlpanelaccessnetworks.confirmOnDelete' => 'Do you want to remove the selected networks?',
    'controlpanelaccessnetworks.buttonSettings' => 'Settings',
    'controlpanelaccessnetworks.buttonSettingsDescription' => 'Click to change the access restriction policy.',
    'controlpanelaccessnetworks.loadingTitle' => 'Please wait. Loading...',

    'customers.filterCustomerName' => 'Customer Name',
    'customers.filterSubscription' => 'Subscription',
    'customers.filterOptionSubscriptionAny' => 'Any',
    'customers.filterOptionSubscriptionMy' => 'My Plans',
    'customers.filterOptionSubscriptionReseller' => '%%planOwnerContactName%%\'s Plans', // Note for translators: you can use here structure like "Plans of Reseller <name>" or alike if it is more convenient
    'customers.filterOptionSubscriptionCustom' => 'Custom',
    'customers.filterOwnership' => 'Provider',
    'customers.filterOptionOwnershipAny' => 'All customers',
    'customers.filterOptionOwnershipMy' => 'My Customers',
    'customers.filterOwnershipReseller' => '%%resellerContactName%%\'s Customers', //Note for translators: see 'filterOptionSubscriptionReseller'
    'customers.filterResourceUsage' => 'Resource Usage',
    'customers.filterOptionResourceUsageAny' => 'Any',
    'customers.filterOptionResourceUsageOveruse' => 'Overused Resources',
    'customers.filterOptionResourceUsageOk' => 'Within Limits',
    'customers.filterStatus' => 'Status',
    'customers.filterOptionStatusAny' => 'Any',
    'customers.filterOptionStatusSuspended' => 'Suspended',
    'customers.filterOptionStatusActive' => 'Active',
    'customers.filterDescription' => 'Description',
    'customers.statusOk' => 'The customer account is active.',
    'customers.statusInactive' => 'The customer account is inactive: Access to the Customer Panel is blocked for the customer.',
    'customers.statusSuspended' => 'The customer account is suspended: Access to the Customer Panel is blocked for the customer and all their users; the customer\'s domains are suspended, their Web, FTP and mail services are no longer accessible to the Internet users.',
    'customers.customerName' => 'Customer Name',
    'customers.subscription' => 'Subscription',
    'customers.setupDate' => 'Setup Date',
    'customers.ownerName' => 'Provider',
    'customers.buttonLogin' => 'Log In as Customer',
    'customers.buttonLoginClassicMode' => 'Manage Hosting',
    'customers.hintLogin' => 'Log in as the customer.',
    'customers.hintLoginClassicMode' => 'Manage hosting services associated with the customer\'s hosting account: Domains and DNS, web apps and databases, mail, and so on.',
    'customers.buttonRemoveCustomer' => 'Remove',
    'customers.hintRemoveCustomer' => 'Remove selected customers.',
    'customers.confirmOnRemove' => 'Do you really want to remove selected customer accounts?',
    'customers.buttonConvertCustomersToReseller' => 'Convert to Resellers',
    'customers.hintConvertCustomersToReseller' => 'Convert the selected customer accounts to reseller accounts.',
    'customers.buttonAddNewCustomer' => 'Add Customer',
    'customers.hintAddNewCustomer' => 'Create a customer account with subscription.',
    'customers.buttonChangeStatus' => 'Change Status',
    'customers.buttonSuspendCustomers' => 'Suspend',
    'customers.hintSuspendCustomers' => 'Suspend the selected customer accounts. Access to the Customer Panel will be blocked for the customers and all their users; the customers\' domains will be suspended, their Web, FTP, and mail services will no longer be accessible to the Internet users.',
    'customers.buttonActivateCustomers' => 'Activate',
    'customers.hintActivateCustomers' => 'Activate selected customer accounts.',
    'customers.buttonChangeOwner' => 'Move To',
    'customers.hintChangeOwner' => 'Move the selected customers to another reseller.',
    'customers.customPlanName' => 'Custom',
    'customers.selectNewIp' => 'Select an IP address',
    'customers.selectAnotherOwner' => 'Select an owner',
    'customers.shared' => 'shared',
    'customers.exclusive' => 'dedicated',
    'customers.confirmOnDelete' => 'Are you sure to remove {count, plural, =1 {the {name} customer account} one {the # selected customer account} other {the # selected customer accounts}}?',
    'customers.hintInfo' => '(?)',

    'customerserviceplans.planName' => 'Plan Name',
    'customerserviceplans.planTraffic' => 'Traffic',
    'customerserviceplans.planDiskSpace' => 'Disk Space',
    'customerserviceplans.planSubscriptions' => 'Subscriptions',
    'customerserviceplans.planOwner' => 'Provider',
    'customerserviceplans.filterPlanItem' => 'Custom Plan Item',
    'customerserviceplans.filterOptionPlanItemAny' => 'Any',
    'customerserviceplans.filterOwnership' => 'Plan Owner',
    'customerserviceplans.filterOptionOwnershipAny' => 'All Plans',
    'customerserviceplans.filterOptionOwnershipMy' => 'My Plans',
    'customerserviceplans.filterOwnershipReseller' => '%%resellerContactName%%\'s Plans',
    'customerserviceplans.unlimited' => 'Unlimited',
    'customerserviceplans.addonPlanType' => '(add-on)',
    'customerserviceplans.buttonAddNewPlan' => 'Add a Plan',
    'customerserviceplans.hintAddNewPlan' => 'Create a hosting plan.',
    'customerserviceplans.buttonDuplicatePlans' => 'Clone Plans',
    'customerserviceplans.hintDuplicatePlans' => 'Create copies of the selected service plans.',
    'customerserviceplans.buttonAddNewAddonPlan' => 'Add an Add-on',
    'customerserviceplans.hintAddNewAddonPlan' => 'Create a hosting plan add-on.',
    'customerserviceplans.buttonRemove' => 'Remove',
    'customerserviceplans.hintRemove' => 'Remove the selected service plans.',
    'customerserviceplans.buttonMoreActions' => 'More Actions',
    'customerserviceplans.confirmOnDelete' => 'Do you really want to remove the selected service plans?',
    'customerserviceplans.disabledSelectHint' => 'The service plan has at least one subscription associated with it and cannot be removed.',

    'domains.filterDomainName' => 'Name',
    'domains.filterStatus' => 'Status',
    'domains.filterOptionStatusAny' => 'Any',
    'domains.filterOptionStatusSuspended' => 'Suspended',
    'domains.filterOptionStatusDisabled' => 'Disabled',
    'domains.filterOptionStatusActive' => 'Active',
    'domains.filterHostingType' => 'Hosting Type',
    'domains.filterPhpHandler' => 'PHP Handler',
    'domains.filterOptionPhpHandlerAny' => 'Any',
    'domains.filterOptionHostingTypeAny' => 'Any',
    'domains.filterOptionHostingTypeNone' => 'No hosting',
    'domains.filterOptionHostingTypeForward' => 'Domain Forwarding',
    'domains.filterOptionHostingTypeAlias' => 'Domain Alias',
    'domains.filterOptionHostingTypeVirtualHost' => 'Domain Hosting',
    'domains.filterOptionHostingTypeSubdomain' => 'Subdomain Hosting',
    'domains.filterSubscriberName' => 'Subscriber',
    'domains.filterServiceNode' => 'Service Node',
    'domains.filterServiceNodeOptionAny' => 'Any',
    'domains.filterDescription' => 'Description',
    'domains.filterTitlePlaceholder' => 'Find domains...',
    'domains.filterTitle' => 'Filter',
    'domains.filterApply' => 'Apply filter',
    'domains.filterClear' => 'Clear',
    'domains.statusDisabled' => 'The domain is disabled.',
    'domains.statusSuspended' => 'The domain is suspended.',
    'domains.domainName' => 'Domain Name',
    'domains.hostingType' => 'Hosting Type',
    'domains.ownerName' => 'Subscriber',
    'domains.setupDate' => 'Setup Date',
    'domains.expirationDate' => 'Expiration date',
    'domains.diskUsage' => 'Disk Usage',
    'domains.traffic' => 'Traffic',
    'domains.status' => 'Status',
    'domains.description' => 'Description',
    'domains.resellerDescription' => 'Reseller',
    'domains.ownerDescription' => 'Customer',
    'domains.openSite' => 'Open',
    'domains.previewSite' => 'Preview',
    'domains.manageInResellerPanel' => 'Manage in Reseller Panel',
    'domains.manageInCustomerPanel' => 'Manage in Customer Panel',
    'domains.customPlanName' => 'Custom',
    'domains.website' => 'Website',
    'domains.subdomainWebsite' => 'Subdomain Website',
    'domains.noHosting' => 'No hosting',
    'domains.forwardingTo' => 'Forward to',
    'domains.aliasFor' => 'Alias for',
    'domains.forwardingToDomain' => 'forward to %%domain%%',
    'domains.aliasForDomain' => 'alias for %%domain%%',
    'domains.add' => 'add',
    'domains.buttonAddDomain' => 'Add Domain',
    'domains.hintAddDomain' => 'Host a new website on this server, set up web forwarding to another website, or set up a domain DNS zone if you want to have only email addresses under a domain name.',
    'domains.buttonAddSubdomain' => 'Add Subdomain',
    'domains.hintAddSubdomain' => 'Create a site addressed by a third-level domain name, like shop.example.com.',
    'domains.buttonAddDomainAlias' => 'Add Domain Alias',
    'domains.hintAddDomainAlias' => 'Set up an additional domain name for your site.',
    'domains.hintRemove' => 'Remove the selected websites and all their web content, apps, databases, and mail.',
    'domains.removeConfirmation' => 'Are you sure to remove {count, plural, =1 {the {name} domain} one {the # selected domain} other {the # selected domains}}?',
    'domains.removeConfirmationSubscription' => "The following domains will also be removed:\n%%domains%%",
    'domains.buttonSetStatus' => 'Set Status',
    'domains.activateActionStatus' => 'Active',
    'domains.hintActivateDomains' => 'Make the selected domains active.',
    'domains.disableActionStatus' => 'Disabled',
    'domains.hintDisableDomains' => 'Disable the selected domains.',
    'domains.suspendActionStatus' => 'Suspended',
    'domains.hintSuspendDomains' => 'Suspend the selected domains.',
    'domains.changeStatusNoItems' => 'Select one or more domains to change their status',
    'domains.removeNoItems' => 'Select one or more domains to remove',
    'domains.activated' => 'The selected domains and aliases were activated',
    'domains.disabled' => 'The selected domains and aliases were disabled',
    'domains.suspended' => 'The selected domains and aliases were suspended',

    'dnsaclrecords.value' => 'IP Address',
    'dnsaclrecords.add' => 'Add IP Address',
    'dnsaclrecords.remove' => 'Remove',
    'dnsaclrecords.hintRemove' => 'Delete the selected IP addresses.',
    'dnsaclrecords.confirmOnDelete' => 'Remove the selected IP addresses?',
    'dnsaclrecords.emptyViewTitle' => 'Zone transfer is not allowed',
    'dnsaclrecords.emptyViewDescription1' => 'For security reasons, you can allow a transfer of the DNS zone only to servers specified in the NS records of the zone.',
    'dnsaclrecords.emptyViewDescription2' => 'To specify one or more servers you allow the transfer to, click "Add IP Address".',

    'eventhandlers.event' => 'Event',
    'eventhandlers.priority' => 'Priority',
    'eventhandlers.priorityHighest' => 'highest (%%value%%)',
    'eventhandlers.priorityHigh' => 'high (%%value%%)',
    'eventhandlers.priorityNormal' => 'normal (%%value%%)',
    'eventhandlers.priorityLow' => 'low (%%value%%)',
    'eventhandlers.priorityLowest' => 'lowest (%%value%%)',
    'eventhandlers.user' => 'User',
    'eventhandlers.command' => 'Command',
    'eventhandlers.buttonAddNewEventHandler' => 'Add Event Handler',
    'eventhandlers.buttonAddNewEventHandlerDescription' => 'Set up a new event handler.',
    'eventhandlers.buttonRemove' => 'Remove',
    'eventhandlers.buttonRemoveDescription' => 'Remove the selected event handlers.',
    'eventhandlers.confirmOnDelete' => 'Remove the selected event handlers?',

    'firewallicmprules.status' => 'Status',
    'firewallicmprules.on' => 'The rule is active.',
    'firewallicmprules.off' => 'The rule is not active.',
    'firewallicmprules.name' => 'Rule name',
    'firewallicmprules.allowinboundrouterrequest' => 'Allow inbound router request',
    'firewallicmprules.allowinboundtimestamprequest' => 'Allow inbound timestamp request',
    'firewallicmprules.allowinboundmaskrequest' => 'Allow inbound mask request',
    'firewallicmprules.allowoutboundsourcequench' => 'Allow outbound source quench',
    'firewallicmprules.allowoutboundparameterproblem' => 'Allow outbound parameter problem',
    'firewallicmprules.allowredirect' => 'Allow redirect',
    'firewallicmprules.allowinboundechorequest' => 'Allow inbound echo request',
    'firewallicmprules.allowoutboundtimeexceeded' => 'Allow outbound time exceeded',
    'firewallicmprules.allowoutbounddestinationunreachable' => 'Allow outbound destination unreachable',

    'firewallinterfaces.firewall' => 'Firewall status',
    'firewallinterfaces.firewallOn' => 'The firewall is turned on for this network interface.',
    'firewallinterfaces.firewallOff' => 'The firewall is turned off for this network interface.',
    'firewallinterfaces.connection' => 'Interface status',
    'firewallinterfaces.connectionOn' => 'The network interface connection is turned on.',
    'firewallinterfaces.connectionOff' => 'The network interface connection is turned off.',
    'firewallinterfaces.name' => 'Interface name',
    'firewallinterfaces.type' => 'Interface type',
    'firewallinterfaces.statusOn' => 'On',
    'firewallinterfaces.statusOff' => 'Off',

    'firewallrules.status' => 'Status',
    'firewallrules.on' => 'The rule is active.',
    'firewallrules.off' => 'The rule is not active.',
    'firewallrules.name' => 'Rule name',
    'firewallrules.description' => 'Description',
    'firewallrules.descriptionText' => '%%action%% incoming connections from %%from%% on port %%port%%, profiles: %%profiles%%',
    'firewallrules.allow' => 'Allow',
    'firewallrules.block' => 'Deny',
    'firewallrules.fromAll' => 'all',
    'firewallrules.groupAdd' => 'Add',
    'firewallrules.buttonAdd' => 'Add Rule',
    'firewallrules.buttonAddHint' => 'Add a firewall rule',
    'firewallrules.groupActions' => 'Actions',
    'firewallrules.buttonRemove' => 'Remove',
    'firewallrules.removeEmptySelection' => 'No firewall rules selected.',
    'firewallrules.removeConfirmation' => 'Remove {count, plural, =1 {the {name} firewall rule} one {the # selected firewall rule} other {the # selected firewall rules}}?',
    'firewallrules.removeSuccess' => 'The selected firewall rules were removed.',

    'ftpsessions.buttonRemove' => 'Close',
    'ftpsessions.buttonRemoveDescription' => 'Close the selected FTP sessions',
    'ftpsessions.buttonRefresh' => 'Refresh',
    'ftpsessions.buttonRefreshDescription' => 'Refresh data on the screen',
    'ftpsessions.typeColumnName' => 'T',
    'ftpsessions.statusColumnName' => 'S',
    'ftpsessions.loginColumnName' => 'Login',
    'ftpsessions.domainColumnName' => 'Domain name',
    'ftpsessions.currentLocationColumnName' => 'Current location',
    'ftpsessions.fileNameColumnName' => 'File name',
    'ftpsessions.speedColumnName' => 'Speed, KB/S',
    'ftpsessions.progressColumnName' => 'Progress, %',
    'ftpsessions.ipAddressColumnName' => 'IP address',
    'ftpsessions.logonTimeColumnName' => 'Logon time',
    'ftpsessions.idleTimeColumnName' => 'Idle time',
    'ftpsessions.sessionTypeDomainAdminTooltip' => 'Domain administrator\'s session.',
    'ftpsessions.sessionTypeSubDomainAdminTooltip' => 'Subdomain administrator\'s session.',
    'ftpsessions.sessionTypeWebUserTooltip' => 'Web user\'s session.',
    'ftpsessions.sessionTypeFtpAccountTooltip' => 'FTP account session.',
    'ftpsessions.sessionTypeAnonymousTooltip' => 'Anonymous FTP user session.',
    'ftpsessions.sessionTypeNotPleskUserTooltip' => 'FTP user who is not registered in Plesk.',
    'ftpsessions.sessionStatusIdle' => 'Idle (no transactions).',
    'ftpsessions.sessionStatusUploadInProgress' => 'Upload is in progress.',
    'ftpsessions.sessionStatusDownloadInProgress' => 'Download is in progress.',
    'ftpsessions.sessionStatusDownloadingDirsList' => 'Downloading a list of directories.',
    'ftpsessions.sessionStatusLastCmdIsType' => 'The last command sent by customer is TYPE.',
    'ftpsessions.sessionStatusLastCmdIsPass' => 'The last command sent by customer is PASS.',
    'ftpsessions.sessionStatusLastCmdIsNoop' => 'The last command sent by customer is NOOP.',
    'ftpsessions.sessionStatusNotKnown' => 'Unrecognized FTP activity.',
    'ftpsessions.confirmOnDelete' => 'Do you really want to end selected sessions?',

    'ipaddresses.buttonAddNewIpAddress' => 'Add IP Address',
    'ipaddresses.buttonAddNewIpAddressDescription' => 'Add an IP address to the server pool of IP addresses.',
    'ipaddresses.buttonRereadConfiguration' => 'Reread IP',
    'ipaddresses.buttonRereadConfigurationDescription' => 'Synchronize the list of IP addresses with the configuration of network adapters.',
    'ipaddresses.buttonReloadPublic' => 'Update public IPs',
    'ipaddresses.buttonReloadPublicDescription' => 'Update public IP addresses based on the hyperscaler instance metadata',
    'ipaddresses.buttonFirewall' => 'Firewall',
    'ipaddresses.buttonFirewallDescription' => 'Set up firewall.',
    'ipaddresses.buttonRemove' => 'Remove',
    'ipaddresses.buttonRemoveDescription' => 'Remove',
    'ipaddresses.confirmOnDelete' => 'Remove selected IP addresses?',
    'ipaddresses.address' => 'IP Address',
    'ipaddresses.publicAddress' => 'Public IP Address',
    'ipaddresses.type' => 'IP Type',
    'ipaddresses.interface' => 'Interface',
    'ipaddresses.resellerCount' => 'Resellers',
    'ipaddresses.subscriptionCount' => 'Sites',
    'ipaddresses.typeAny' => 'Any',
    'ipaddresses.typeShared' => 'Shared',
    'ipaddresses.typeExclusive' => 'Dedicated',
    'ipaddresses.typeSharedHint' => 'shared',
    'ipaddresses.typeExclusiveHint' => 'dedicated',
    'ipaddresses.ipAddressBroken' => 'This IP address is not configured properly.',
    'ipaddresses.ipAddressBlacklisted' => 'This IP address is blacklisted.',
    'ipaddresses.repair' => 'Repair',
    'ipaddresses.buttonSearch' => 'Search',
    'ipaddresses.buttonResetSearch' => 'Reset Search',
    'ipaddresses.removeConfirmation' => 'Are you sure to remove {count, plural, =1 {the {name} IP-address} one {the # selected IP-address} other {the # selected IP-addresses}}?',
    'ipaddresses.hint' => 'View, add, remove IP addresses.',
    'ipaddresses.hintWithResellers' => 'View, add, remove IP addresses, and assign IP addresses to resellers.',
    'ipaddresses.repairSuccess' => 'The IP address %%address%% was synchronized with the system.',
    'ipaddresses.removeSuccess' => 'The selected IP addresses were removed.',

    'languages.headerStatus' => 'S',
    'languages.headerCode' => 'Language pack',
    'languages.headerLanguage' => 'Language',
    'languages.headerCountry' => 'Country',
    'languages.headerUsed' => 'Used',
    'languages.filterCode' => 'Language pack',
    'languages.buttonDisable' => 'Disable',
    'languages.buttonDisableDescription' => 'Make the selected languages not available to users.',
    'languages.disableDone' => 'The selected languages are no longer available to users.',
    'languages.buttonEnable' => 'Enable',
    'languages.buttonEnableDescription' => 'Make the selected languages available to users.',
    'languages.enableDone' => 'The selected languages become available to users.',
    'languages.buttonMakeDefault' => 'Make Default',
    'languages.buttonMakeDefaultDescription' => 'Make the selected language the default for Plesk.',
    'languages.makeDefaultDone' => 'The selected language was set as the default for Plesk.',
    'languages.makeDefaultSelectOne' => 'Select a language you want to make the default for Plesk.',
    'languages.statusActive' => 'This language is available to Plesk users.',
    'languages.statusActiveUnavailable' => 'This language has become unavailable to users because your limit on the number of allowed languages is exceeded.',
    'languages.buttonHintStatusActive' => 'Click this icon to make the language unavailable to users.',
    'languages.statusInactive' => 'This language is not available to users.',
    'languages.buttonHintStatusInactive' => 'Click this icon to make the language available to users.',
    'languages.buttonHintStatusDefaultLangugage' => 'This is the default language: you cannot make it unavailable to users.',
    'languages.langUnknown' => 'Unable to recognize the language',
    'languages.countryUnknown' => 'Unable to recognize the country subcode',

    'mailqueue.filterQueue' => 'Queues',
    'mailqueue.filterSubject' => 'Subject',
    'mailqueue.filterSender' => 'Sender',
    'mailqueue.filterRecipients' => 'Recipient',
    'mailqueue.subject' => 'Subject',
    'mailqueue.sender' => 'Sender',
    'mailqueue.recipients' => 'Recipients',
    'mailqueue.date' => 'Date',
    'mailqueue.age' => 'Age',
    'mailqueue.size' => 'Size',
    'mailqueue.buttonRefresh' => 'Refresh',
    'mailqueue.buttonRefreshHint' => 'Refresh data on the screen.',
    'mailqueue.buttonRemove' => 'Remove',
    'mailqueue.buttonRemoveHint' => 'Remove the selected messages from the mail queue.',
    'mailqueue.confirmOnDelete' => 'Do you really want to remove the selected messages from the mail queue?',
    'mailqueue.buttonClean' => 'Clear',
    'mailqueue.buttonCleanHint' => 'Clear the mail queue of all messages.',
    'mailqueue.confirmOnClean' => 'Do you really want to clear the mail queue?',
    'mailqueue.queueAll' => 'All',
    'mailqueue.queueTodo' => 'Not Preprocessed',
    'mailqueue.queueRemote' => 'Remote',
    'mailqueue.queueLocal' => 'Local',
    'mailqueue.queueLocalAndRemote' => 'Local and Remote',
    'mailqueue.queueActive' => 'Active messages queue',
    'mailqueue.queueCorrupted' => 'Corrupted messages queue',
    'mailqueue.queueDeferred' => 'Deferred messages queue',
    'mailqueue.queueHold' => 'On hold messages queue',
    'mailqueue.queueIncoming' => 'Incoming messages queue',
    'mailqueue.postfixHint' => 'Messages in queue: %%deferred%% deferred, %%hold%% held, %%incoming%% incoming, %%active%% active, %%corrupted%% corrupted, %%total%% total.',
    'mailqueue.qmailHint' => 'Messages in queue: %%todo%% not preprocessed, %%local%% local, %%remote%% remote, %%total%% total.',
    'mailqueue.messagesDeleted' => 'The selected messages were removed from the mail queue.',
    'mailqueue.messagesNotDeleted' => 'Unable to remove some messages from the mail queue: %%error%%',
    'mailqueue.queueCleaned' => 'The mail queue was successfully cleared.',
    'mailqueue.queueNotCleaned' => 'Unable to clear the mail queue: %%error%%.',

    'phpextensions.enable' => 'Enable extension',
    'phpextensions.disable' => 'Disable extension',

    'phpextensions.installable.status' => 'Status',
    'phpextensions.installable.notInstalled' => 'Not installed',
    'phpextensions.installable.outdated' => 'Outdated, latest version is %%latestVersion%%',
    'phpextensions.installable.latest' => 'Latest',
    'phpextensions.installable.name' => 'Package',
    'phpextensions.installable.description' => 'Description',
    'phpextensions.installable.actionInstall' => 'Install',
    'phpextensions.installable.actionUpgrade' => 'Upgrade to %%version%%',
    'phpextensions.installable.actionDocs' => 'Documentation',
    'phpextensions.installable.actionUninstall' => 'Uninstall',
    'phpextensions.installable.uninstallConfirmation' => 'Are you sure to uninstall %%name%% package?',
    'phpextensions.installable.groupInstall' => 'Install',
    'phpextensions.installable.groupReload' => 'Reload',
    'phpextensions.installable.buttonInstallCustom' => 'Install package',
    'phpextensions.installable.buttonInstallCustomHint' => 'Install any PECL package',
    'phpextensions.installable.buttonReload' => 'Reload',
    'phpextensions.installable.buttonReloadHint' => 'Reload PECL packages',
    'phpextensions.installable.emptyViewFilteredTitle' => 'Could not find any packages matching the filter',
    'phpextensions.installable.emptyViewFilteredDescription' => 'Try installing the package you are searching for.',

    'phphandlers.name' => 'Handler',
    'phphandlers.domains' => 'Domains',
    'phphandlers.statusBroken' => 'This handler is corrupted.',
    'phphandlers.statusDisallowedApacheModule' => 'The handler cannot be enabled because the corresponding Apache module is turned off.',
    'phphandlers.domainsTitle' => '%%domains%% domains use PHP %%handler%%',
    'phphandlers.closeTitle' => 'Close',
    'phphandlers.handlerOutdated' => '(Outdated)',
    'phphandlers.handlerDeprecated' => '(Deprecated)',
    'phphandlers.handlerOutdatedAndDeprecated' => '(Outdated, Deprecated)',

    'planitems.name' => 'Name',
    'planitems.numberOfPlans' => 'Service Plans',
    'planitems.numberOfSubscriptions' => 'Subscriptions',
    'planitems.itemInvisible' => 'Not available to resellers',
    'planitems.buttonMakeItemVisible' => 'Make Available',
    'planitems.buttonMakeItemVisibleDescription' => 'Let resellers provide the selected services with their own hosting plans. The options corresponding to these services will be shown in hosting plan properties, on the Additional Services tab.',
    'planitems.buttonMakeItemInvisible' => 'Make Unavailable',
    'planitems.buttonMakeItemInvisibleDescription' => 'Do not let resellers provide the selected services with their hosting plans. The options corresponding to these services will be removed from the hosting plan properties.',
    'planitems.buttonAddNewCustomItemButton' => 'Add Service',
    'planitems.buttonAddNewCustomItemButtonDescription' => 'Add a service to plan options.',
    'planitems.buttonRemoveCustomItem' => 'Remove Service',
    'planitems.buttonRemoveCustomItemDescription' => 'Remove the options corresponding to the selected services from hosting plan properties.',
    'planitems.confirmOnDeleteSupportButton' => 'Are you sure you want to remove the selected options?',

    'pumpackages.buttonUpdate' => 'Update',
    'pumpackages.buttonUpdateDescription' => 'Update the selected packages.',
    'pumpackages.buttonLock' => 'Lock',
    'pumpackages.buttonLockDescription' => 'Lock the selected packages to prevent updates.',
    'pumpackages.buttonUnlock' => 'Unlock',
    'pumpackages.buttonUnlockDescription' => 'Unlock the selected packages to allow updates.',
    'pumpackages.buttonCheckUpdates' => 'Check for Updates',
    'pumpackages.buttonCheckUpdatesDescription' => 'Check for package updates.',
    'pumpackages.name' => 'Package',
    'pumpackages.summary' => 'Description',
    'pumpackages.updates' => 'Updates',
    'pumpackages.lockedCut' => 'L',
    'pumpackages.lockedHint' => 'The package is locked.',
    'pumpackages.unlockedHint' => 'The package is unlocked.',
    'pumpackages.updated' => 'Up-to-date',
    'pumpackages.update' => 'Update to %%version%%',
    'pumpackages.unknownRepo' => 'unknown',
    'pumpackages.allUpToDate' => 'All packages are up-to-date',
    'pumpackages.allUpToDateLastChecked' => 'Checked on %%date%%',
    'pumpackages.recheckUpdates' => 'Recheck Now',
    'pumpackages.popupInfoTitle' => 'The %%package%% Package Details',
    'pumpackages.loading' => 'Please wait...',
    'pumpackages.error' => 'Unable to get packages list: %%message%%',
    'pumpackages.currentVersion' => 'current version: %%version%%',
    'pumpackages.notInstalled' => 'not installed',
    'pumpackages.popupUpdateTitle' => 'Update Packages',
    'pumpackages.popupUpdatePackagesListTitle' => 'Install the following updates:',
    'pumpackages.popupUpdateLockedPackagesListTitle' => 'The following required packages are locked for updating:',
    'pumpackages.popupUpdateDependencies' => '%%count%% dependent packages',
    'pumpackages.unlockPackagesForUpdateOnly' => 'Unlock the packages to allow this update only',
    'pumpackages.lockedError' => 'The System Updates tool is already installing updates in automatic mode. Please try later.',
    'pumpackages.duplicatesError' => 'Error: Unable to receive update information because some packages have duplicates. Remove duplicates of the following packages: %%duplicates%%',
    'pumpackages.updateInfoError' => 'Error: Unable to receive update information for the package(s)',
    'pumpackages.selectedPackagesUpToDate' => 'All the selected packages are up-to-date.',
    'pumpackages.taskUpdatingPackages' => 'Updating %%count%% package(s)...',
    'pumpackages.popupLockTitle' => 'Lock Packages',
    'pumpackages.popupLockDescription' => 'If you lock a package, it will not be updated by the System Updates tool (unless you update Plesk itself). If other packages require a newer version of this package for their updates, they will not be updated. Note that you can still update a locked package via native means in the console. To update a locked package from the Plesk interface, unlock it first.',
    'pumpackages.popupLockPackagesListTitle' => 'Lock the following packages:',
    'pumpackages.popupUnlockTitle' => 'Unlock Packages',
    'pumpackages.popupUnlockDescription' => 'These packages cannot be updated because they were locked to prevent updates. Note that you can still update a locked package via native means in the console, or while updating Plesk itself. To update a locked packages from the Plesk interface, unlock it first.',
    'pumpackages.popupUnlockPackagesListTitle' => 'Unlock the following packages:',
    'pumpackages.updatesAvailable' => 'Updates for %%count%% system packages are available',
    'pumpackages.lastedChecked' => '(checked on %%date%%)',
    'pumpackages.updateAll' => 'Update All',
    'pumpackages.packageManagerDbInconsistent' => 'Information on some packages might not be actual: inconsistencies were detected in the system\'s package manager database. Please resolve this issue manually.',

    'resellers.filterResellerName' => 'Reseller Name',
    'resellers.filterSubscription' => 'Subscription',
    'resellers.filterOptionSubscriptionAny' => 'Any',
    'resellers.filterOptionSubscriptionCustom' => 'Custom',
    'resellers.filterResourceUsage' => 'Resource Usage',
    'resellers.filterOptionResourceUsageAny' => 'Any',
    'resellers.filterOptionResourceUsageOveruse' => 'Overused resources',
    'resellers.filterOptionResourceUsageOk' => 'Within limits',
    'resellers.filterStatus' => 'Status',
    'resellers.filterOptionStatusAny' => 'Any',
    'resellers.filterOptionStatusSuspended' => 'Suspended',
    'resellers.filterOptionStatusActive' => 'Active',
    'resellers.filterSubscriptionStatus' => 'Subscription State',
    'resellers.filterOptionSubscriptionStatusAny' => 'Any',
    'resellers.filterOptionSubscriptionStatusLocked' => 'Locked',
    'resellers.filterOptionSubscriptionStatusUnsynchronized' => 'Unsynced',
    'resellers.filterDescription' => 'Description',
    'resellers.buttonAddNewReseller' => 'Add Reseller',
    'resellers.hintAddNewReseller' => 'Create a reseller account.',
    'resellers.buttonRemove' => 'Remove',
    'resellers.hintRemove' => 'Remove the selected resellers and all their service plans, customers and subscriptions.',
    'resellers.confirmOnDelete' => 'Are you sure to remove {count, plural, =1 {the {name} reseller account} one {the # selected reseller account} other {the # selected reseller accounts}} and all {count, plural, one {its} other {their}} service plans, customers and subscriptions?',
    'resellers.buttonConvertToCustomer' => 'Convert to Customers',
    'resellers.hintConvertToCustomer' => 'Convert the selected resellers to customers.',
    'resellers.buttonChangeStatus' => 'Change Status',
    'resellers.buttonActivateResellers' => 'Activate',
    'resellers.hintActivateResellers' => 'Activate the selected reseller accounts.',
    'resellers.buttonSuspendResellers' => 'Suspend',
    'resellers.hintSuspendResellers' => 'Suspend the selected reseller accounts. Access to Customer Panel will be blocked for the resellers and all their customers; the domains of the resellers and their customers will be suspended, their Web, FTP and mail services will no longer be accessible by the Internet users.',
    'resellers.resellerName' => 'Reseller Name',
    'resellers.planName' => 'Service Plan',
    'resellers.setupDate' => 'Setup Date',
    'resellers.customers' => 'Customers',
    'resellers.customPlanName' => 'Custom',
    'resellers.buttonLogin' => 'Log In as Reseller',
    'resellers.hintLogin' => 'Manage hosting services associated with the reseller\'s hosting account.',
    'resellers.statusOk' => 'This reseller account status is OK: the account is active, the subscription is synced with the plan.',
    'resellers.statusSuspended' => 'This reseller account is suspended: Access to Customer Panel is blocked for the reseller and all their customers; the domains of the reseller and their customers are suspended, their Web, FTP and mail services are no longer accessible to the Internet users.',
    'resellers.statusLocked' => 'The subscription is locked for synchronization: It is excluded from syncing with the service plan because the subscription parameters were customized.',
    'resellers.statusUnsynchronized' => 'The subscription is unsynced with reseller plan: There are some services or resources that the reseller plan offers but the subscription does not provide.',

    'resellerserviceplans.planName' => 'Plan Name',
    'resellerserviceplans.planTraffic' => 'Traffic',
    'resellerserviceplans.planDiskSpace' => 'Disk Space',
    'resellerserviceplans.planSubscriptions' => 'Resellers',
    'resellerserviceplans.unlimited' => 'Unlimited',
    'resellerserviceplans.buttonAddNewPlan' => 'Add Plan',
    'resellerserviceplans.hintAddNewPlan' => 'Create a reseller plan.',
    'resellerserviceplans.buttonDuplicatePlans' => 'Clone Plans',
    'resellerserviceplans.hintDuplicatePlans' => 'Create copies of the selected reseller plans.',
    'resellerserviceplans.buttonRemove' => 'Remove',
    'resellerserviceplans.hintRemove' => 'Remove the selected reseller plans.',
    'resellerserviceplans.confirmOnDelete' => 'Do you really want to remove the selected reseller plans?',
    'resellerserviceplans.disabledSelectHint' => 'Reseller plans with at least one associated subscription cannot be removed.',

    'restricteddomains.name' => 'Domain Name',
    'restricteddomains.buttonAddNewDomain' => 'Add Domain Name',
    'restricteddomains.buttonEnableList' => 'Enable',
    'restricteddomains.hintAddNewDomain' => 'Add a prohibited domain name.',
    'restricteddomains.hintEnableList' => 'Turn on the checking of domain names during domain creation.',
    'restricteddomains.buttonDisableList' => 'Disable',
    'restricteddomains.hintDisableList' => 'Turn off the checking of domain names during domain creation.',
    'restricteddomains.buttonRemoveDomain' => 'Remove',
    'restricteddomains.hintRemoveDomain' => 'Remove the selected domain names.',
    'restricteddomains.confirmOnRemove' => 'Remove the selected domain names?',
    'restricteddomains.buttonMoreActions' => 'More',

    'servermailblacklist.groupAdd' => 'Add',
    'servermailblacklist.buttonAdd' => 'Add Domain',
    'servermailblacklist.buttonAddHint' => 'Add domain to the black list',
    'servermailblacklist.groupActions' => 'Actions',
    'servermailblacklist.buttonRemove' => 'Remove',
    'servermailblacklist.entries' => 'Entries',
    'servermailblacklist.action' => 'Action',
    'servermailblacklist.deleteAction' => 'Delete from server',
    'servermailblacklist.spamAction' => 'Mark as spam',
    'servermailblacklist.spamAssassinDisabled' => 'Entries will not be marked as spam because SpamAssassin is not installed or is switched off',
    'servermailblacklist.removeEmptySelection' => 'No entries selected.',
    'servermailblacklist.removeConfirmation' => 'Remove {count, plural, =1 {the {name} entry} one {the # selected entry} other {the # selected entries}}?',
    'servermailblacklist.removeSuccess' => 'The selected entries were removed.',

    'servermailwhitelist.groupAdd' => 'Add',
    'servermailwhitelist.buttonAdd' => 'Add Network',
    'servermailwhitelist.buttonAddHint' => 'Add network to the white list',
    'servermailwhitelist.groupActions' => 'Actions',
    'servermailwhitelist.buttonRemove' => 'Remove',
    'servermailwhitelist.entries' => 'Entries',
    'servermailwhitelist.whiteListNotEmpty' => 'The limits on outgoing mail will not work for mail senders whose IP addresses are in the mail server\'s white list. For example, if there is localhost (127.0.0.0 / 8, ::1 / 128) in the white list, all mail from the local server will be successfully sent regardless of the limitations. Mail senders can use either local IP addresses (websites and custom scripts hosted on the local server) or external ones (customers who send mail from mail clients installed on their computers or mobile devices). To make the limits work for all mail senders (both local and external), remove all IP addresses and networks from the white list. Note that removing localhost (127.0.0.0 / 8, ::1 / 128) from the white list might disrupt the operation of websites and scripts that send mail from this server. For details about limitations on outgoing mail, see the Administrator\'s Guide, Protection from Outbound Spam.',
    'servermailwhitelist.removeEmptySelection' => 'No entries selected.',
    'servermailwhitelist.removeConfirmation' => 'Remove {count, plural, =1 {the {name} entry} one {the # selected entry} other {the # selected entries}}?',
    'servermailwhitelist.webmailAffected' => 'Removing the following {count, plural, =1 {network} one {network} other {networks}} might make sending mail from webmail impossible: %%list%%',
    'servermailwhitelist.webmailAffectedSingle' => 'Removing this network might make sending mail from webmail impossible.',
    'servermailwhitelist.removeSuccess' => 'The selected entries were removed.',

    'serverprotection.bannedips.pageHint' => 'Here you can view banned IP addresses, unban them, or move to the list of trusted IP addresses.',
    'serverprotection.bannedips.ip' => 'IP address',
    'serverprotection.bannedips.banDate' => 'Banned at',
    'serverprotection.bannedips.jail' => 'Used jail',
    'serverprotection.bannedips.buttonRemoveIp' => 'Unban',
    'serverprotection.bannedips.hintRemoveIp' => 'Remove the selected IP addresses from the list of banned addresses.',
    'serverprotection.bannedips.buttonMoveToTrustedIp' => 'Move to Trusted IPs',
    'serverprotection.bannedips.hintMoveToTrustedIp' => 'Move the selected IP addresses to the list of trusted addresses.',
    'serverprotection.bannedips.buttonEnable' => 'Switch On IP Address Banning',
    'serverprotection.bannedips.hintEnable' => 'Switch on automatic banning of IP addresses and networks that generate malicious traffic for your server.',
    'serverprotection.bannedips.buttonDisable' => 'Switch Off IP Address Banning',
    'serverprotection.bannedips.hintDisable' => 'Switch off automatic banning of IP addresses and networks that generate malicious traffic for your server.',
    'serverprotection.bannedips.errorEnableFailed' => 'Cannot switch on IP Address Banning: %%error%%.',
    'serverprotection.bannedips.errorDisableFailed' => 'Cannot switch Off IP Address Banning: %%error%%.',

    'serverprotection.filters.pageHint' => 'Here you can manage jails filters.',
    'serverprotection.filters.buttonAddFilter' => 'Add Filter',
    'serverprotection.filters.hintAddFilter' => 'Add a filter.',
    'serverprotection.filters.buttonRemoveFilter' => 'Remove',
    'serverprotection.filters.hintRemoveFilter' => 'Remove the selected filters.',
    'serverprotection.filters.name' => 'Filter name',

    'serverprotection.jails.pageHint' => 'Here you can view the list of jails used for detection of abusive IP addresses.',
    'serverprotection.jails.buttonAddJail' => 'Add Jail',
    'serverprotection.jails.hintAddJail' => 'Add a jail.',
    'serverprotection.jails.buttonDisableJails' => 'Switch Off',
    'serverprotection.jails.hintDisableJails' => 'Switch off the selected jails.',
    'serverprotection.jails.buttonActivateJails' => 'Switch On',
    'serverprotection.jails.hintActivateJails' => 'Switch on the selected jails.',
    'serverprotection.jails.buttonRemoveJail' => 'Remove',
    'serverprotection.jails.hintRemoveJail' => 'Remove the selected jails.',
    'serverprotection.jails.buttonManageFilters' => 'Manage Filters',
    'serverprotection.jails.hintManageFilters' => 'Here you can manage jail filters.',
    'serverprotection.jails.name' => 'Jail name',
    'serverprotection.jails.disabled' => 'Inactive',
    'serverprotection.jails.active' => 'Active',
    'serverprotection.jails.status' => 'Status',
    'serverprotection.jails.confirmOnDelete' => 'Do you really want to remove the selected jails?',

    'serverprotection.logs.pageHint' => 'Here you can view Fail2ban logs.',
    'serverprotection.logs.name' => 'File',
    'serverprotection.logs.viewHint' => 'View the log file.',
    'serverprotection.logs.buttonDownloadHint' => 'Download the Log File',

    'serverprotection.trustedips.pageHint' => 'Here you can view trusted IP addresses, add IP addresses to and remove from the list of trusted addresses.',
    'serverprotection.trustedips.ip' => 'IP address',
    'serverprotection.trustedips.ipDesc' => 'Description',
    'serverprotection.trustedips.addDate' => 'Added to trusted at',
    'serverprotection.trustedips.comment' => 'Comment',
    'serverprotection.trustedips.buttonRemoveIp' => 'Remove',
    'serverprotection.trustedips.hintRemoveIp' => 'Remove the selected IP addresses from the list of trusted addresses.',
    'serverprotection.trustedips.buttonAddTrustedIp' => 'Add Trusted IP',
    'serverprotection.trustedips.hintAddTrustedIp' => 'Add an IP address to the list of trusted addresses.',
    'serverprotection.trustedips.buttonEditTrustedIp' => 'Edit description',
    'serverprotection.trustedips.buttonEditHint' => 'Edit description of an IP address.',

    'services.stateColumnHeader' => 'State',
    'services.nameColumnHeader' => 'Service',
    'services.startupTypeColumnHeader' => 'Startup Type',
    'services.autoStartupType' => 'Automatic',
    'services.manualStartupType' => 'Manual',
    'services.disabledStartupType' => 'Disabled',
    'services.changeStartupTypeTooltip' => 'Change startup type for service',
    'services.drwebName' => 'Plesk Premium Antivirus',
    'services.postgresqlName' => 'PostgreSQL',
    'services.tomcatName' => 'Tomcat Java',
    'services.imap-pop3Name' => 'Dovecot IMAP and POP3 server',
    'services.pop3Name' => 'Courier POP3 server',
    'services.pop3sName' => 'Courier POP3 server with SSL/TLS support',
    'services.imapName' => 'Courier IMAP server',
    'services.imapsName' => 'Courier IMAP server with SSL/TLS support',
    'services.authdaemonName' => 'Courier IMAP authentication daemon',
    'services.dnsName' => 'DNS Server (%%displayName%%)',
    'services.fail2banName' => 'IP Address Banning (Fail2ban)',
    'services.kavName' => 'Kaspersky Antivirus',
    'services.milterName' => "Plesk milter (%%displayName%%)",
    'services.nginxName' => 'Reverse Proxy Server (nginx)',
    'services.smtpName' => 'SMTP Server (%%displayName%%)',
    'services.spamassassinName' => "SpamAssassin",
    'services.webName' => "Web Server (%%displayName%%)",
    'services.resctrlName' => "Resource Controller (Cgroups)",
    'services.activeState' => 'On',
    'services.inActiveState' => 'Off',
    'services.do-restart' => 'Restarting',
    'services.do-start' => 'Launching',
    'services.do-stop' => 'Switching off',
    'services.do-changeStartup' => 'Processing',
    'services.notConfiguredState' => 'Not configured',
    'services.notInstalledState' => 'Not installed',
    'services.running-start' => 'Service is already started.',
    'services.notRunning-start' => 'Start the service.',
    'services.running-stop' => 'Stop the service.',
    'services.notRunning-stop' => 'Service is already stopped.',
    'services.running-restart' => 'Restart the service.',
    'services.notRunning-restart' => 'Service is stopped.',
    'services.startServiceDrWeb' => 'In order to start the Antivirus service you should have at least one mailbox with antivirus checking enabled.',
    'services.serviceDisabled' => 'This feature is not available because either your license key does not support it or the service is not installed or properly configured.',
    'services.serviceDisabledStartupType' => 'Service disabled.',
    'services.phpHandlerSettingsByOsVendor' => '%%displayName%% by OS vendor',
    'services.phpFpm' => 'PHP-FPM %%displayName%%',
    'services.urlrewriteComponentName' => "URL Rewrite",
    'services.dbconnectorComponentName' => "Database Connector",
    'services.tomcatComponentName' => 'Apache Tomcat',
    'services.mysqlserverComponentName' => 'MySQL Server',
    'services.troubleshootingComponentName' => 'Troubleshooting',
    'services.wafComponentName' => 'Web Application Firewall',
    'services.vcsComponentName' => 'Version Control System',
    'services.antivirusComponentName' => "Antivirus",
    'services.databaseComponentName' => "SQL Server",
    'services.sqladminComponentName' => "MySQL Webadmin",
    'services.sqladminmysqlComponentName' => "MySQL Webadmin",
    'services.dnsserverComponentName' => "DNS Server",
    'services.firewallComponentName' => "Firewall",
    'services.ftpserverComponentName' => "FTP Server",
    'services.javaComponentName' => "Java",
    'services.mailserverComponentName' => "Mail Server",
    'services.pleskagentComponentName' => "Plesk Agent",
    'services.psaComponentName' => "Plesk",
    'services.scriptComponentName' => "Web Scripting",
    'services.spamfilterComponentName' => "Spam Filter",
    'services.statsComponentName' => "Web Statistics",
    'services.stunnelComponentName' => "SSL/TLS Wrapper",
    'services.webmailComponentName' => "Webmail",
    'services.webpublishComponentName' => "Web Publishing",
    'services.webserverComponentName' => "Web Server",
    'services.backupsystemComponentName' => 'Backup System',
    'services.networkComponentName' => 'Networking',
    'services.sitebuilderComponentName' => 'Presence Builder',
    'services.saviComponentName' => 'Sophos Anti-Virus Interface',
    'services.waitMessage' => 'Please, wait',
    'services.buttonRefreshComponents' => 'Refresh',
    'services.searchTitle' => 'Find services...',
    'services.hintRefreshComponents' => 'Refresh components list',

    'sessions.searchTitle' => 'Search for active sessions',
    'sessions.buttonRefresh' => 'Refresh',
    'sessions.buttonRefreshDescription' => 'Synchronize the list of sessions with the currently open sessions.',
    'sessions.buttonRemove' => 'Close',
    'sessions.buttonRemoveDescription' => 'Close the selected sessions.',
    'sessions.removeConfirmMessage' => 'Do you want to close the selected sessions?',
    'sessions.buttonSettings' => 'Session Settings',
    'sessions.buttonSettingsDescription' => 'Change session parameters.',
    'sessions.headerType' => 'T',
    'sessions.headerLogin' => 'Login',
    'sessions.headerIpAddress' => 'IP address',
    'sessions.headerLogonTime' => 'Logon time',
    'sessions.headerIdleTime' => 'Idle time',
    'sessions.typeAdmin' => 'Administrator\'s session.',
    'sessions.typeReseller' => 'Reseller session.',
    'sessions.typeClient' => 'Customer session.',
    'sessions.altAdminIcon' => 'Admin',
    'sessions.altResellerIcon' => 'Reseller',
    'sessions.altClientIcon' => 'Customer',

    'sslcertificates.name' => 'Name',
    'sslcertificates.used' => 'Used',
    'sslcertificates.csrHint' => 'The CSR component is supplied.',
    'sslcertificates.noCsrHint' => 'The CSR component is not supplied.',
    'sslcertificates.privateKeyHint' => 'The Private key component is supplied.',
    'sslcertificates.noPrivateKeyHint' => 'The Private key component is not supplied.',
    'sslcertificates.certificateHint' => 'The Certificate component is supplied.',
    'sslcertificates.noCertificateHint' => 'The Certificate component is not supplied.',
    'sslcertificates.caCertificateHint' => 'The CA Certificate component is supplied.',
    'sslcertificates.noCaCertificateHint' => 'The CA Certificate component is not supplied.',
    'sslcertificates.buttonDownloadHint' => 'Download all certificate components.',
    'sslcertificates.remove' => 'Remove',
    'sslcertificates.hintRemove' => 'Remove the selected SSL/TLS certificates from the domain repository.',
    'sslcertificates.confirmOnDelete' => 'Remove the selected SSL/TLS certificates?',
    'sslcertificates.addCertificate' => 'Add',
    'sslcertificates.hintAddCertificate' => 'Add an SSL/TLS certificate.',
    'sslcertificates.viewCertificates' => 'View',
    'sslcertificates.hintViewCertificates' => 'View the list of SSL/TLS certificates that you purchased from your provider.',
    'sslcertificates.unableSetupPanelCertificate' => 'Unable to install the certificate in Plesk: The private key and certificate contents are missing.',
    'sslcertificates.makeDefault' => 'Make Default',
    'sslcertificates.hintMakeDefault' => 'Use the selected SSL/TLS certificate for securing connections to newly created websites.',
    'sslcertificates.unableMakeDefault' => 'Unable to install the default certificate: No certificate with the private key was selected.',
    'sslcertificates.successMakeDefault' => 'The selected SSL/TLS certificate was configured as the default one. It can be used to secure both existing and newly created websites. Websites using the previous default certificate will continue using that certificate.',
    'sslcertificates.selectOne' => 'Select one SSL/TLS certificate.',

    'subscriptions.filterDomainName' => 'Name',
    'subscriptions.filterSubscription' => 'Service Plan',
    'subscriptions.filterOptionSubscriptionAny' => 'Any',
    'subscriptions.filterOptionSubscriptionMy' => 'My Plans',
    'subscriptions.filterOptionSubscriptionReseller' => '%%planOwnerContactName%%\'s Plans',
    'subscriptions.filterOptionSubscriptionCustom' => 'Custom',
    'subscriptions.filterOptionSubscriptionAddonType' => '(add-on)',
    'subscriptions.filterResourceUsage' => 'Resource Usage',
    'subscriptions.filterOptionResourceUsageAny' => 'Any',
    'subscriptions.filterOptionResourceUsageOveruse' => 'Overused resources',
    'subscriptions.filterOptionResourceUsageOk' => 'Within limits',
    'subscriptions.filterPlanItem' => 'Custom Plan Item',
    'subscriptions.filterOptionPlanItemAny' => 'Any',
    'subscriptions.filterProvider' => 'Provider',
    'subscriptions.filterOptionProviderAny' => 'All subscriptions',
    'subscriptions.filterOptionProviderMy' => 'My subscriptions',
    'subscriptions.filterProviderReseller' => '%%resellerContactName%%\'s subscriptions',
    'subscriptions.filterStatus' => 'Status',
    'subscriptions.filterOptionStatusAny' => 'Any',
    'subscriptions.filterOptionStatusSuspended' => 'Suspended',
    'subscriptions.filterOptionStatusActive' => 'Active',
    'subscriptions.filterSubscriptionStatus' => 'Subscription State',
    'subscriptions.filterOptionSubscriptionStatusAny' => 'Any',
    'subscriptions.filterOptionSubscriptionStatusLocked' => 'Locked',
    'subscriptions.filterOptionSubscriptionStatusUnsynchronized' => 'Unsynced',
    'subscriptions.filterSubscriberName' => 'Subscriber',
    'subscriptions.filterDescription' => 'Description',
    'subscriptions.subscriptionName' => 'Subscription',
    'subscriptions.subscriberName' => 'Subscriber',
    'subscriptions.setupDate' => 'Setup Date',
    'subscriptions.expirationDate' => 'Expiration Date',
    'subscriptions.description' => 'Description',
    'subscriptions.resellerDescription' => 'Reseller',
    'subscriptions.ownerDescription' => 'Customer',
    'subscriptions.manageInResellerPanel' => 'Manage in Reseller Panel',
    'subscriptions.manageInCustomerPanel' => 'Manage in Customer Panel',
    'subscriptions.buttonAddNewOwnSubscription' => 'Add Own Subscription',
    'subscriptions.hintAddNewOwnSubscription' => 'Create a subscription for your own usage.',
    'subscriptions.buttonAddNewSubscription' => 'Add Subscription',
    'subscriptions.hintAddNewSubscription' => 'Create a subscription.',
    'subscriptions.buttonChangeSubscription' => 'Change Plan',
    'subscriptions.hintChangeSubscription' => 'Associate selected subscriptions with another service plan, and add or remove plan add-ons if the subscriptions\' provider offers them.',
    'subscriptions.buttonRemove' => 'Remove',
    'subscriptions.hintRemove' => 'Remove selected subscriptions.',
    'subscriptions.confirmOnRemove' => 'Do you really want to remove selected subscriptions?',
    'subscriptions.buttonSetStatus' => 'Set Status',
    'subscriptions.buttonActivateSubscriptions' => 'Active',
    'subscriptions.hintActivateSubscriptions' => 'Make selected subscriptions active.',
    'subscriptions.buttonSuspendSubscriptions' => 'Suspended',
    'subscriptions.hintSuspendSubscriptions' => 'Suspend selected subscriptions. All services provided with the subscriptions will be frozen and not accessible to Internet users.',
    'subscriptions.buttonChangeOwner' => 'Change Subscriber',
    'subscriptions.hintChangeOwner' => 'Reassign selected subscriptions to another subscriber. This will also change the subscriptions\' provider, unbind the subscriptions from their service plans and make them \'Custom\'.',
    'subscriptions.customPlanName' => 'Custom',
    'subscriptions.statusOk' => 'Subscription status is OK: the subscription is active and synced with the plan.',
    'subscriptions.statusSuspended' => 'The subscription is suspended: All services provided with the subscription are frozen and not accessible to Internet users.',
    'subscriptions.statusSuspendedReasonExpired' => 'The subscription is suspended because it is expired: All services provided with the subscription are frozen and not accessible to Internet users.',
    'subscriptions.statusLocked' => 'The subscription is locked for synchronization: It is excluded from syncing with the service plan because the subscription parameters were customized.',
    'subscriptions.statusUnsynchronized' => 'The subscription is unsynced with service plan: There are some services or resources that the plan offers but the subscription does not provide.',
    'subscriptions.confirmOnDelete' => 'Are you sure to remove {count, plural, =1 {the {name} subscription} one {the # selected subscription} other {the # selected subscriptions}}?',
    'subscriptions.hintInfo' => '(?)',
    'subscriptions.webserverConfigurationDomainHintAdmin' => "Web server configuration for the subscription's domains may be inconsistent. Please fix errors in templates of Apache configuration and retry generating the configuration file.",
    'subscriptions.webserverConfigurationDomainHintReseller' => "Web server configuration for the subscription's domains may be inconsistent. Please contact server administrator to resolve the problem.",
    'subscriptions.unlinkedDomainHint' => 'Some of domain IP addresses are inoperative and excluded from server configuration. Check domain IP bindings and update if needed.',
    'subscriptions.hintTitle' => 'Subscription summary',
    'subscriptions.hintWaitMessage' => 'Loading...',
    'subscriptions.removeConfirmationSubscription' => "The following domains will also be removed:\n%%domains%%",

    'summaryreportlayouts.delivery' => 'Delivery',
    'summaryreportlayouts.name' => 'Name',
    'summaryreportlayouts.general' => 'General',
    'summaryreportlayouts.clients' => 'Customers',
    'summaryreportlayouts.resellers' => 'Resellers',
    'summaryreportlayouts.personalClients' => 'Personal clients',
    'summaryreportlayouts.domains' => 'Domains',
    'summaryreportlayouts.personalDomains' => 'Personal domains',
    'summaryreportlayouts.section.FULL' => 'Full',
    'summaryreportlayouts.section.NONE' => 'None',
    'summaryreportlayouts.section.SUMMARY' => 'Summary',
    'summaryreportlayouts.groupRemove' => 'Remove',
    'summaryreportlayouts.buttonRemove' => 'Remove',
    'summaryreportlayouts.buttonRemoveHint' => 'Remove the selected layouts.',
    'summaryreportlayouts.removeEmptySelection' => 'Select one or more layouts to remove',
    'summaryreportlayouts.removeConfirmation' => 'Remove {count, plural, =1 {{name} layout} one {the selected layout} other {# layouts}}?',
    'summaryreportlayouts.groupAdd' => 'Add',
    'summaryreportlayouts.buttonAdd' => 'Add Layout',
    'summaryreportlayouts.buttonAddHint' => 'Add a report layout',
    'summaryreportlayouts.autoDeliveryOn' => 'This report is scheduled for delivery.',
    'summaryreportlayouts.autoDeliveryOff' => 'This report is not delivered automatically.',
    'summaryreportlayouts.removeSuccess' => 'The selected layouts were removed.',

    'summaryreportschedules.status' => 'S',
    'summaryreportschedules.on' => 'Enabled',
    'summaryreportschedules.off' => 'Disabled',
    'summaryreportschedules.period' => 'Frequency',
    'summaryreportschedules.lastSentDate' => 'Last delivery date',
    'summaryreportschedules.email' => 'Deliver to',
    'summaryreportschedules.disabled' => 'Switched off',
    'summaryreportschedules.day' => 'Daily',
    'summaryreportschedules.week' => 'Weekly',
    'summaryreportschedules.month' => 'Monthly',
    'summaryreportschedules.groupAdd' => 'Add',
    'summaryreportschedules.buttonAdd' => 'Add Schedule',
    'summaryreportschedules.buttonAddHint' => 'Add a delivery schedule',
    'summaryreportschedules.groupRemove' => 'Remove',
    'summaryreportschedules.buttonRemove' => 'Remove',
    'summaryreportschedules.buttonRemoveHint' => 'Remove the selected schedules.',
    'summaryreportschedules.removeEmptySelection' => 'Select one or more delivery schedules to remove.',
    'summaryreportschedules.removeConfirmation' => 'Remove {count, plural, =1 {the selected delivery schedule} other {the # selected delivery schedules}}?',
    'summaryreportschedules.removeSuccess' => 'The selected delivery schedules were removed.',

    'traffichistory.year' => 'Year',
    'traffichistory.month' => 'Month',
    'traffichistory.trafficUsage' => 'Traffic Usage',
    'traffichistory.noData' => 'No history data available.',

    'webappfirewalllogfiles.name' => 'Name',
    'webappfirewalllogfiles.modificationDate' => 'Modification date',
    'webappfirewalllogfiles.fileSize' => 'Size',
    'webappfirewalllogfiles.remove' => 'Remove',
    'webappfirewalllogfiles.hintRemove' => 'Remove the selected log files. Only processed log files can be removed.',
    'webappfirewalllogfiles.confirmOnDelete' => 'Remove the selected log files?',
    'webappfirewalllogfiles.viewHint' => 'Click to view the log file.',
    'webappfirewalllogfiles.buttonDownloadHint' => 'Click to download the log file.',

    'webmails.name' => 'Name',
    'webmails.url' => 'URL',
    'webmails.buttonAddNewWebmail' => 'Register Webmail',
    'webmails.hintAddNewWebmail' => 'Register an additional webmail service in Plesk.',
    'webmails.buttonEnableWebmail' => 'Enable',
    'webmails.hintEnableWebmail' => 'Make the selected webmail services available to customers.',
    'webmails.buttonDisableWebmail' => 'Disable',
    'webmails.hintDisableWebmail' => 'Make the selected webmail services unavailable to customers.',
    'webmails.buttonRemoveWebmail' => 'Remove',
    'webmails.hintRemoveWebmail' => 'Remove registration of the selected additional webmail services. Note that a webmail installed with Plesk Installer cannot be removed here, use Tools > Updates instead.',
    'webmails.confirmOnDelete' => 'Do you really want to remove the selected webmail registrations from Plesk?',
    'webmails.statusSuspended' => 'Webmail is not available.',
    'webmails.statusOk' => 'Webmail is available.',
];
