<?php
// Copyright 1999-2023. Plesk International GmbH. All rights reserved.
$messages = [
    'adminaliases.statusActive' => 'La cuenta está activa.',
    'adminaliases.statusInactive' => 'La cuenta ha sido suspendida: este administrador no puede acceder a Plesk.',
    'adminaliases.buttonRemoveAdminAlias' => 'Eliminar',
    'adminaliases.hintRemoveAdminAlias' => 'Elimine las cuentas de administrador seleccionadas.',
    'adminaliases.confirmOnRemove' => '¿Realmente desea eliminar las cuentas de administrador seleccionadas?',
    'adminaliases.buttonAddNewAdminAlias' => 'Añadir cuenta de administrador',
    'adminaliases.hintAddNewAdminAlias' => 'Cree una cuenta de administrador adicional.',
    'adminaliases.buttonMoreActions' => 'Más',
    'adminaliases.buttonActivateAdminAlias' => 'Activar',
    'adminaliases.hintActivateAdminAlias' => 'Active cuentas de administrador suspendidas.',
    'adminaliases.buttonDeactivateAdminAlias' => 'Suspender',
    'adminaliases.hintDeactivateAdminAlias' => 'Suspenda las cuentas de administrador seleccionadas. Plesk denegará el acceso a estos administradores.',
    'adminaliases.confirmOnDelete' => '¿Realmente desea eliminar las cuentas de administrador seleccionadas?',
    'adminaliases.login' => 'Nombre de usuario',
    'adminaliases.contact' => 'Nombre de contacto',
    'adminaliases.email' => 'Email',
    'adminaliases.comments' => 'Comentarios',

    'appinfo.installedAt' => 'Ruta de instalación',
    'appinfo.noInstallationUrlAvailable' => 'Ninguno',
    'appinfo.subscriptionName' => 'Suscripción',
    'appinfo.subscriptionOwner' => 'Propietario de la suscripción',
    'appinfo.buttonLogin' => 'Abrir en el panel del cliente',
    'appinfo.buttonLoginClassicMode' => 'Administrar hosting',
    'appinfo.hintLogin' => 'Abra el panel del cliente del suscriptor.',
    'appinfo.hintAdminLogin' => 'Administre servicios de hosting asociados con una determinada cuenta de hosting: dominios y DNS, aplicaciones web y bases de datos, correo, etc.',
    'appinfo.hintLoginClassicMode' => 'Administre servicios de hosting asociados con una determinada cuenta de hosting: dominios y DNS, aplicaciones web y bases de datos, correo, etc.',
    'appinfo.update' => 'Actualizaciones disponibles.',
    'appinfo.updateFailed' => 'Error de actualización.',
    'appinfo.noUpdates' => 'Ninguna actualización disponible.',
    'appinfo.foundUpdates' => 'Existen actualizaciones para las siguientes apps: ',
    'appinfo.buttonCheckForUpdates' => 'Buscar actualizaciones',
    'appinfo.buttonCheckForUpdatesDescription' => 'Compruebe la existencia de actualizaciones disponibles.',
    'appinfo.buttonChangeSettings' => 'Configuración',
    'appinfo.buttonChangeSettingsDescription' => 'Cambie la configuración de la aplicación a nivel de servidor.',
    'appinfo.appNotConfigured' => 'No configurado',

    'appuploaded.name' => 'Nombre',
    'appuploaded.numberOfInstances' => 'Nº de instalaciones',
    'appuploaded.buttonUploadNewApp' => 'Añadir app',
    'appuploaded.buttonUploadNewAppDescription' => 'Añada un paquete de aplicación al servidor.',
    'appuploaded.buttonRemove' => 'Eliminar',
    'appuploaded.buttonRemoveDescription' => 'Elimine los paquetes seleccionados.',
    'appuploaded.confirmOnDelete' => '¿Está seguro de que desea eliminar los paquetes seleccionados?',
    'appuploaded.appInvisible' => 'No disponible para los clientes',
    'appuploaded.appGlobalSettingsNotSet' => 'No configurado',
    'appuploaded.buttonMakeAppVisible' => 'Hacer disponible',
    'appuploaded.buttonMakeAppVisibleDescription' => 'Haga que las aplicaciones estén disponibles para que así sus clientes puedan instalarlas.',
    'appuploaded.buttonMakeAppInvisible' => 'Hacer no disponible',
    'appuploaded.buttonMakeAppInvisibleDescription' => 'Haga que las aplicaciones no estén disponibles para que así sus clientes no puedan instalarlas.',

    'appusage.name' => 'Nombre',
    'appusage.numberOfInstances' => 'Nº de instalaciones',
    'appusage.buttonCleanApplicationCache' => 'Borrar caché',
    'appusage.buttonCleanApplicationCacheDescription' => 'Elimine archivos temporales descargados durante la instalación de aplicaciones.',
    'appusage.buttonRedirectToMarket' => 'Ir a la tienda online',
    'appusage.buttonRedirectToMarketDescription' => 'Adquiera licencias de aplicación para poderlas instalar en sitios web.',
    'appusage.updateFailed' => 'Error de actualización.',
    'appusage.noUpdates' => 'Ninguna actualización disponible.',
    'appusage.foundUpdates' => 'Existen actualizaciones para las siguientes apps: ',
    'appusage.buttonCheckForUpdates' => 'Buscar actualizaciones',
    'appusage.buttonCheckForUpdatesDescription' => 'Buscar actualizaciones en el catálogo de aplicaciones.',
    'appusage.buttonUpdateSettings' => 'Configuración de actualización',
    'appusage.buttonUpdateSettingsDescription' => 'Configuración de actualización de las aplicaciones a nivel del servidor.',

    'controlpanelaccessnetworks.ipAddress' => 'Dirección IP',
    'controlpanelaccessnetworks.subnetMask' => 'Máscara de subred',
    'controlpanelaccessnetworks.buttonAddNewNetwork' => 'Añadir red',
    'controlpanelaccessnetworks.buttonAddNewNetworkDescription' => 'Haga clic para añadir la red a la lista de restricciones de acceso.',
    'controlpanelaccessnetworks.buttonRemove' => 'Eliminar',
    'controlpanelaccessnetworks.buttonRemoveDescription' => 'Haga clic para eliminar las redes seleccionadas de la lista.',
    'controlpanelaccessnetworks.confirmOnDelete' => '¿Desea eliminar las redes seleccionadas?',
    'controlpanelaccessnetworks.buttonSettings' => 'Configuración',
    'controlpanelaccessnetworks.buttonSettingsDescription' => 'Haga clic para modificar la directiva de restricciones de acceso.',
    'controlpanelaccessnetworks.loadingTitle' => 'Espere. Cargando...',

    'customers.filterCustomerName' => 'Nombre del cliente',
    'customers.filterSubscription' => 'Suscripción',
    'customers.filterOptionSubscriptionAny' => 'Cualquiera',
    'customers.filterOptionSubscriptionMy' => 'Mis planes',
    'customers.filterOptionSubscriptionReseller' => 'Planes de %%planOwnerContactName%%', // Note for translators: you can use here structure like "Plans of Reseller <name>" or alike if it is more convenient
    'customers.filterOptionSubscriptionCustom' => 'Personalizado',
    'customers.filterOwnership' => 'Proveedor',
    'customers.filterOptionOwnershipAny' => 'Todos los clientes',
    'customers.filterOptionOwnershipMy' => 'Mis clientes',
    'customers.filterOwnershipReseller' => 'Clientes de %%resellerContactName%%', //Note for translators: see 'filterOptionSubscriptionReseller'
    'customers.filterResourceUsage' => 'Uso de recursos',
    'customers.filterOptionResourceUsageAny' => 'Cualquiera',
    'customers.filterOptionResourceUsageOveruse' => 'Recursos que presentan sobreuso',
    'customers.filterOptionResourceUsageOk' => 'Dentro de los límites',
    'customers.filterStatus' => 'Estado',
    'customers.filterOptionStatusAny' => 'Cualquiera',
    'customers.filterOptionStatusSuspended' => 'Suspendido',
    'customers.filterOptionStatusActive' => 'Activo',
    'customers.filterDescription' => 'Descripción',
    'customers.statusOk' => 'La cuenta de cliente está activa.',
    'customers.statusInactive' => 'La cuenta de cliente no está activa. El cliente no puede acceder al panel porque está bloqueado.',
    'customers.statusSuspended' => 'La cuenta del cliente ha sido suspendida: el acceso al panel, tanto para el cliente como para todos sus usuarios, está bloqueado; los dominios del cliente han sido suspendidos y los usuarios de internet ya no podrán acceder a sus servicios de correo, FTP y web.',
    'customers.customerName' => 'Nombre del cliente',
    'customers.subscription' => 'Suscripción',
    'customers.setupDate' => 'Fecha de alta',
    'customers.ownerName' => 'Proveedor',
    'customers.buttonLogin' => 'Iniciar sesión como cliente',
    'customers.buttonLoginClassicMode' => 'Administrar hosting',
    'customers.hintLogin' => 'Inicie sesión como cliente.',
    'customers.hintLoginClassicMode' => 'Administre los servicios de hosting relacionados con la cuenta de hosting del cliente: dominios y DNS, aplicaciones web y bases de datos, correo, etc.',
    'customers.buttonRemoveCustomer' => 'Eliminar',
    'customers.hintRemoveCustomer' => 'Elimine los clientes seleccionados.',
    'customers.confirmOnRemove' => '¿Desea eliminar las cuentas de cliente seleccionadas?',
    'customers.buttonConvertCustomersToReseller' => 'Convertir en revendedores',
    'customers.hintConvertCustomersToReseller' => 'Convierta las cuentas de cliente seleccionadas en cuentas de revendedor.',
    'customers.buttonAddNewCustomer' => 'Añadir cliente',
    'customers.hintAddNewCustomer' => 'Cree una cuenta de cliente con una suscripción.',
    'customers.buttonChangeStatus' => 'Cambiar estado',
    'customers.buttonSuspendCustomers' => 'Suspender',
    'customers.hintSuspendCustomers' => 'Suspenda las cuentas de cliente seleccionadas. Se bloqueará el acceso al panel tanto para los clientes como para todos sus usuarios; los dominios del cliente serán suspendidos y los usuarios de internet ya no podrán acceder a sus servicios de correo, FTP y web.',
    'customers.buttonActivateCustomers' => 'Activar',
    'customers.hintActivateCustomers' => 'Active las cuentas de cliente seleccionadas.',
    'customers.buttonChangeOwner' => 'Transferir a',
    'customers.hintChangeOwner' => 'Transfiera los clientes seleccionados a otro revendedor.',
    'customers.customPlanName' => 'Personalizado',
    'customers.selectNewIp' => 'Seleccione una dirección IP',
    'customers.selectAnotherOwner' => 'Seleccione un propietario',
    'customers.shared' => 'compartido',
    'customers.exclusive' => 'dedicado',
    'customers.confirmOnDelete' => '¿Está seguro de que desea eliminar la(s) {count, plural, =1 {the {name} customer account} one {the # selected customer account} other {# cuenta(s) de cliente seleccionada(s)}}?',
    'customers.hintInfo' => '(?)',

    'customerserviceplans.planName' => 'Nombre del plan',
    'customerserviceplans.planTraffic' => 'Tráfico',
    'customerserviceplans.planDiskSpace' => 'Espacio en disco',
    'customerserviceplans.planSubscriptions' => 'Suscripciones',
    'customerserviceplans.planOwner' => 'Proveedor',
    'customerserviceplans.filterPlanItem' => 'Elemento de plan personalizado',
    'customerserviceplans.filterOptionPlanItemAny' => 'Cualquiera',
    'customerserviceplans.filterOwnership' => 'Propietario del plan',
    'customerserviceplans.filterOptionOwnershipAny' => 'Todos los planes',
    'customerserviceplans.filterOptionOwnershipMy' => 'Mis planes',
    'customerserviceplans.filterOwnershipReseller' => 'Planes de %%resellerContactName%%',
    'customerserviceplans.unlimited' => 'Ilimitado',
    'customerserviceplans.addonPlanType' => '(complemento)',
    'customerserviceplans.buttonAddNewPlan' => 'Añadir un plan',
    'customerserviceplans.hintAddNewPlan' => 'Cree un plan de hosting.',
    'customerserviceplans.buttonDuplicatePlans' => 'Clonar planes',
    'customerserviceplans.hintDuplicatePlans' => 'Cree copias de los planes de servicio seleccionados.',
    'customerserviceplans.buttonAddNewAddonPlan' => 'Añadir un complemento',
    'customerserviceplans.hintAddNewAddonPlan' => 'Cree un complemento para un plan de hosting.',
    'customerserviceplans.buttonRemove' => 'Eliminar',
    'customerserviceplans.hintRemove' => 'Elimine los planes de servicio seleccionados.',
    'customerserviceplans.buttonMoreActions' => 'Otras acciones',
    'customerserviceplans.confirmOnDelete' => '¿Desea eliminar los planes de servicio seleccionados?',
    'customerserviceplans.disabledSelectHint' => 'El plan de servicio al menos tiene una suscripción asociada a este y no puede ser eliminado.',

    'domains.filterDomainName' => 'Nombre',
    'domains.filterStatus' => 'Estado',
    'domains.filterOptionStatusAny' => 'Cualquiera',
    'domains.filterOptionStatusSuspended' => 'Suspendida',
    'domains.filterOptionStatusDisabled' => 'Desactivado',
    'domains.filterOptionStatusActive' => 'Activa',
    'domains.filterHostingType' => 'Tipo de hosting',
    'domains.filterPhpHandler' => 'Controlador PHP',
    'domains.filterOptionPhpHandlerAny' => 'Cualquiera',
    'domains.filterOptionHostingTypeAny' => 'Cualquiera',
    'domains.filterOptionHostingTypeNone' => 'Sin hosting',
    'domains.filterOptionHostingTypeForward' => 'Redirección de dominios',
    'domains.filterOptionHostingTypeAlias' => 'Alias de dominio',
    'domains.filterOptionHostingTypeVirtualHost' => 'Hosting de dominios',
    'domains.filterOptionHostingTypeSubdomain' => 'Hosting de subdominios',
    'domains.filterSubscriberName' => 'Suscriptor',
    'domains.filterServiceNode' => 'Nodo de servicio',
    'domains.filterServiceNodeOptionAny' => 'Cualquiera',
    'domains.filterDescription' => 'Descripción',
    'domains.filterTitlePlaceholder' => 'Buscar dominios...',
    'domains.filterTitle' => 'Filtrar',
    'domains.filterApply' => 'Aplicar filtro',
    'domains.filterClear' => 'Borrar',
    'domains.statusDisabled' => 'El dominio está deshabilitado.',
    'domains.statusSuspended' => 'El dominio está suspendido.',
    'domains.domainName' => 'Nombre de dominio',
    'domains.hostingType' => 'Tipo de hosting',
    'domains.ownerName' => 'Suscriptor',
    'domains.setupDate' => 'Fecha de alta',
    'domains.expirationDate' => 'Fecha de expiración',
    'domains.diskUsage' => 'Uso de disco',
    'domains.traffic' => 'Tráfico',
    'domains.status' => 'Estado',
    'domains.description' => 'Descripción',
    'domains.resellerDescription' => 'Revendedor',
    'domains.ownerDescription' => 'Cliente',
    'domains.openSite' => 'Abrir',
    'domains.previewSite' => 'Previsualizar',
    'domains.manageInResellerPanel' => 'Administrar en panel del revendedor',
    'domains.manageInCustomerPanel' => 'Administrar en panel del cliente',
    'domains.customPlanName' => 'Personalizado',
    'domains.website' => 'Sitio web',
    'domains.subdomainWebsite' => 'Sitio web de subdominio',
    'domains.noHosting' => 'Sin hosting',
    'domains.forwardingTo' => 'Redireccionar a',
    'domains.aliasFor' => 'Alias para',
    'domains.forwardingToDomain' => 'reenviar a %%domain%%',
    'domains.aliasForDomain' => 'alias para %%domain%%',
    'domains.add' => 'añadir',
    'domains.buttonAddDomain' => 'Añadir dominio',
    'domains.hintAddDomain' => 'Aloje un sitio web nuevo en este servidor, configure el redireccionamiento a otro sitio web o defina una zona DNS de dominio, en el caso de que en un nombre de dominio solo desee tener direcciones de email.',
    'domains.buttonAddSubdomain' => 'Añadir subdominio',
    'domains.hintAddSubdomain' => 'Cree un sitio gestionado por un nombre de dominio de tercer nivel, como shop.example.com.',
    'domains.buttonAddDomainAlias' => 'Añadir alias de dominio',
    'domains.hintAddDomainAlias' => 'Configure un nombre de dominio adicional para su sitio.',
    'domains.hintRemove' => 'Elimine los sitios web seleccionados y todo su contenido web, incluyendo aplicaciones, bases de datos y correo.',
    'domains.removeConfirmation' => '¿Está seguro de que desea eliminar el/los {count, plural, =1 {the {name} domain} one {the # selected domain} other {# dominio(s) seleccionado(s)}}?',
    'domains.removeConfirmationSubscription' => "También se eliminarán los siguientes dominios:\n%%domains%%",
    'domains.buttonSetStatus' => 'Definir estado',
    'domains.activateActionStatus' => 'Activo',
    'domains.hintActivateDomains' => 'Haga que los dominios seleccionados estén activos.',
    'domains.disableActionStatus' => 'Desactivado',
    'domains.hintDisableDomains' => 'Deshabilite los dominios seleccionados.',
    'domains.suspendActionStatus' => 'Suspendido',
    'domains.hintSuspendDomains' => 'Suspenda los dominios seleccionados.',
    'domains.changeStatusNoItems' => 'Selecciona uno o varios dominios para cambiar su estado',
    'domains.removeNoItems' => 'Selecciona el dominio o dominios que quieras eliminar',
    'domains.activated' => 'Los dominios y alias seleccionados han sido activados',
    'domains.disabled' => 'Se han desactivado los dominios y alias seleccionados',
    'domains.suspended' => 'Se han suspendido los dominios y alias seleccionados',

    'dnsaclrecords.value' => 'Dirección IP',
    'dnsaclrecords.add' => 'Añadir dirección IP',
    'dnsaclrecords.remove' => 'Eliminar',
    'dnsaclrecords.hintRemove' => 'Elimine las direcciones IP seleccionadas.',
    'dnsaclrecords.confirmOnDelete' => '¿Desea eliminar las direcciones IP seleccionadas?',
    'dnsaclrecords.emptyViewTitle' => 'No se permite la transferencia de zonas',
    'dnsaclrecords.emptyViewDescription1' => 'Por motivos de seguridad, puede permitir una transferencia de la zona DNS únicamente a servidores indicados en los registros NS de la zona.',
    'dnsaclrecords.emptyViewDescription2' => 'Para especificar uno o más servidores a los que permitir la transferencia, haga clic en "Añadir dirección IP".',

    'eventhandlers.event' => 'Evento',
    'eventhandlers.priority' => 'Prioridad',
    'eventhandlers.priorityHighest' => 'la más alta (%%value%%)',
    'eventhandlers.priorityHigh' => 'alta (%%value%%)',
    'eventhandlers.priorityNormal' => 'normal (%%value%%)',
    'eventhandlers.priorityLow' => 'baja (%%value%%)',
    'eventhandlers.priorityLowest' => 'la más baja (%%value%%)',
    'eventhandlers.user' => 'Usuario',
    'eventhandlers.command' => 'Comando',
    'eventhandlers.buttonAddNewEventHandler' => 'Añadir controlador de eventos',
    'eventhandlers.buttonAddNewEventHandlerDescription' => 'Cree un nuevo controlador de eventos.',
    'eventhandlers.buttonRemove' => 'Eliminar',
    'eventhandlers.buttonRemoveDescription' => 'Elimine los controladores de eventos seleccionados.',
    'eventhandlers.confirmOnDelete' => '¿Desea eliminar los controladores de eventos seleccionados?',

    'firewallicmprules.status' => 'Estado',
    'firewallicmprules.on' => 'La regla está activa.',
    'firewallicmprules.off' => 'La regla no está activa.',
    'firewallicmprules.name' => 'Nombre de la regla',
    'firewallicmprules.allowinboundrouterrequest' => 'Permitir solicitud entrante router',
    'firewallicmprules.allowinboundtimestamprequest' => 'Permitir solicitud entrante timestamp',
    'firewallicmprules.allowinboundmaskrequest' => 'Permitir solicitud entrante máscara',
    'firewallicmprules.allowoutboundsourcequench' => 'Permitir solicitud saliente apagar',
    'firewallicmprules.allowoutboundparameterproblem' => 'Permitir problema con parámetro saliente',
    'firewallicmprules.allowredirect' => 'Permitir redireccionar',
    'firewallicmprules.allowinboundechorequest' => 'Permitir solicitud entrante echo',
    'firewallicmprules.allowoutboundtimeexceeded' => 'Permitir solicitud saliente tiempo excedido',
    'firewallicmprules.allowoutbounddestinationunreachable' => 'Permitir destino inalcanzable',

    'firewallinterfaces.firewall' => 'Estado del firewall',
    'firewallinterfaces.firewallOn' => 'El firewall para esta interfaz de red está activado.',
    'firewallinterfaces.firewallOff' => 'El firewall para esta interfaz de red está desactivado.',
    'firewallinterfaces.connection' => 'Estado de la interfaz',
    'firewallinterfaces.connectionOn' => 'La conexión de interfaz de red está activada.',
    'firewallinterfaces.connectionOff' => 'La conexión de interfaz de red está desactivada.',
    'firewallinterfaces.name' => 'Nombre de la interfaz',
    'firewallinterfaces.type' => 'Tipo de interfaz',
    'firewallinterfaces.statusOn' => 'Habilitado',
    'firewallinterfaces.statusOff' => 'Deshabilitado',

    'firewallrules.status' => 'Estado',
    'firewallrules.on' => 'La regla está activa.',
    'firewallrules.off' => 'La regla no está activa.',
    'firewallrules.name' => 'Nombre de la regla',
    'firewallrules.description' => 'Descripción',
    'firewallrules.descriptionText' => '%%action%% conexiones entrantes desde %%from%% en el puerto %%port%%, perfiles: %%profiles%%',
    'firewallrules.allow' => 'Permitir',
    'firewallrules.block' => 'Denegar',
    'firewallrules.fromAll' => 'todas',
    'firewallrules.groupAdd' => 'Añadir',
    'firewallrules.buttonAdd' => 'Añadir regla',
    'firewallrules.buttonAddHint' => 'Añada una regla de firewall',
    'firewallrules.groupActions' => 'Acciones',
    'firewallrules.buttonRemove' => 'Eliminar',
    'firewallrules.removeEmptySelection' => 'No se ha seleccionado ninguna regla de firewall.',
    'firewallrules.removeConfirmation' => '¿Está seguro de que desea eliminar {count, plural, =1 {la regla de firewall {name}} one {# la regla de firewall seleccionada} other {las reglas de firewall seleccionadas}}?',
    'firewallrules.removeSuccess' => 'Las reglas de firewall seleccionadas han sido eliminadas.',

    'ftpsessions.buttonRemove' => 'Cerrar',
    'ftpsessions.buttonRemoveDescription' => 'Cierre las sesiones FTP seleccionadas',
    'ftpsessions.buttonRefresh' => 'Actualizar',
    'ftpsessions.buttonRefreshDescription' => 'Actualice los datos que aparecen en pantalla',
    'ftpsessions.typeColumnName' => 'T',
    'ftpsessions.statusColumnName' => 'Estado',
    'ftpsessions.loginColumnName' => 'Nombre de usuario',
    'ftpsessions.domainColumnName' => 'Nombre del dominio',
    'ftpsessions.currentLocationColumnName' => 'Ubicación actual',
    'ftpsessions.fileNameColumnName' => 'Nombre del archivo',
    'ftpsessions.speedColumnName' => 'Velocidad, KB/S',
    'ftpsessions.progressColumnName' => 'Progreso, %',
    'ftpsessions.ipAddressColumnName' => 'Dirección IP',
    'ftpsessions.logonTimeColumnName' => 'Hora de inicio de sesión',
    'ftpsessions.idleTimeColumnName' => 'Tiempo de inactividad',
    'ftpsessions.sessionTypeDomainAdminTooltip' => 'Sesión de administrador de dominio.',
    'ftpsessions.sessionTypeSubDomainAdminTooltip' => 'Sesión de administrador del subdominio.',
    'ftpsessions.sessionTypeWebUserTooltip' => 'Sesión de usuario web.',
    'ftpsessions.sessionTypeFtpAccountTooltip' => 'Sesión de cuenta FTP.',
    'ftpsessions.sessionTypeAnonymousTooltip' => 'Sesión de usuario FTP anónimo.',
    'ftpsessions.sessionTypeNotPleskUserTooltip' => 'Usuario FTP no registrado en Plesk.',
    'ftpsessions.sessionStatusIdle' => 'Inactivo (sin transacciones).',
    'ftpsessions.sessionStatusUploadInProgress' => 'Carga en curso.',
    'ftpsessions.sessionStatusDownloadInProgress' => 'Descarga en curso.',
    'ftpsessions.sessionStatusDownloadingDirsList' => 'Descargando una lista de directorios.',
    'ftpsessions.sessionStatusLastCmdIsType' => 'El último comando enviado por el cliente es TYPE.',
    'ftpsessions.sessionStatusLastCmdIsPass' => 'El último comando enviado por el cliente es PASS.',
    'ftpsessions.sessionStatusLastCmdIsNoop' => 'El último comando enviado por el cliente es NOOP.',
    'ftpsessions.sessionStatusNotKnown' => 'Actividad FTP no reconocida.',
    'ftpsessions.confirmOnDelete' => '¿Desea finalizar las sesiones seleccionadas?',

    'ipaddresses.buttonAddNewIpAddress' => 'Añadir dirección IP',
    'ipaddresses.buttonAddNewIpAddressDescription' => 'Añada una dirección IP al grupo de direcciones IP del servidor.',
    'ipaddresses.buttonRereadConfiguration' => 'Releer IP',
    'ipaddresses.buttonRereadConfigurationDescription' => 'Sincronice la lista de direcciones IP con la configuración de adaptadores de red.',
    'ipaddresses.buttonReloadPublic' => 'Actualizar IPs públicas',
    'ipaddresses.buttonReloadPublicDescription' => 'Actualice direcciones IP públicas basándose en los metadatos de la instancia hyperscaler',
    'ipaddresses.buttonFirewall' => 'Firewall',
    'ipaddresses.buttonFirewallDescription' => 'Configure el firewall.',
    'ipaddresses.buttonRemove' => 'Eliminar',
    'ipaddresses.buttonRemoveDescription' => 'Eliminar',
    'ipaddresses.confirmOnDelete' => '¿Eliminar las direcciones IP seleccionadas?',
    'ipaddresses.address' => 'Dirección IP',
    'ipaddresses.publicAddress' => 'Dirección IP pública',
    'ipaddresses.type' => 'Tipo de IP',
    'ipaddresses.interface' => 'Interfaz',
    'ipaddresses.resellerCount' => 'Revendedores',
    'ipaddresses.subscriptionCount' => 'Sitios',
    'ipaddresses.typeAny' => 'Cualquiera',
    'ipaddresses.typeShared' => 'Compartida',
    'ipaddresses.typeExclusive' => 'Dedicada',
    'ipaddresses.typeSharedHint' => 'compartida',
    'ipaddresses.typeExclusiveHint' => 'dedicada',
    'ipaddresses.ipAddressBroken' => 'Esta dirección IP no se ha configurado correctamente.',
    'ipaddresses.ipAddressBlacklisted' => 'Esta dirección IP está en la lista negra.',
    'ipaddresses.repair' => 'Reparar',
    'ipaddresses.buttonSearch' => 'Buscar',
    'ipaddresses.buttonResetSearch' => 'Restablecer búsqueda',
    'ipaddresses.removeConfirmation' => '¿Está seguro de que desea eliminar {count, plural, =1 {la dirección IP {name}} one {la dirección IP # seleccionada} other {las # direcciones IP seleccionadas}}?',
    'ipaddresses.hint' => 'Vea, añada y elimine direcciones IP.',
    'ipaddresses.hintWithResellers' => 'Vea, añada, elimine direcciones IP y asigne direcciones IP a revendedores.',
    'ipaddresses.repairSuccess' => 'La dirección IP %%address%% se ha sincronizado con el sistema.',
    'ipaddresses.removeSuccess' => 'Las direcciones IP seleccionadas han sido eliminadas.',

    'languages.headerStatus' => 'Estado',
    'languages.headerCode' => 'Paquete de idioma',
    'languages.headerLanguage' => 'Idioma',
    'languages.headerCountry' => 'País',
    'languages.headerUsed' => 'Usado',
    'languages.filterCode' => 'Paquete de idioma',
    'languages.buttonDisable' => 'Desactivar',
    'languages.buttonDisableDescription' => 'Haga que los idiomas seleccionados no estén disponibles para los usuarios.',
    'languages.disableDone' => 'Los idiomas seleccionados ya no están disponibles para los usuarios.',
    'languages.buttonEnable' => 'Activar',
    'languages.buttonEnableDescription' => 'Haga que los idiomas seleccionados estén disponibles para los usuarios.',
    'languages.enableDone' => 'Los idiomas seleccionados están a disposición de los usuarios.',
    'languages.buttonMakeDefault' => 'Hacer predeterminado',
    'languages.buttonMakeDefaultDescription' => 'Convierta el idioma seleccionado en el idioma predeterminado de Plesk.',
    'languages.makeDefaultDone' => 'El idioma seleccionado se ha establecido como el idioma predeterminado de Plesk.',
    'languages.makeDefaultSelectOne' => 'Seleccione el idioma que desea convertir en el idioma predeterminado de Plesk.',
    'languages.statusActive' => 'Este idioma está disponible para los usuarios de Plesk.',
    'languages.statusActiveUnavailable' => 'Este idioma ya no está disponible para los usuarios porque se ha excedido el número máximo de idiomas permitidos.',
    'languages.buttonHintStatusActive' => 'Haga clic en este icono para que el idioma no esté disponible para los usuarios.',
    'languages.statusInactive' => 'Este idioma no está disponible para los usuarios.',
    'languages.buttonHintStatusInactive' => 'Haga clic en este icono para que el idioma esté disponible para los usuarios.',
    'languages.buttonHintStatusDefaultLangugage' => 'Este es el idioma predeterminado: no puede deshabilitarlo para los usuarios.',
    'languages.langUnknown' => 'No se puede reconocer el idioma',
    'languages.countryUnknown' => 'No se pudo reconocer el subcódigo de país',

    'mailqueue.filterQueue' => 'Colas',
    'mailqueue.filterSubject' => 'Asunto',
    'mailqueue.filterSender' => 'Remitente',
    'mailqueue.filterRecipients' => 'Destinatario',
    'mailqueue.subject' => 'Asunto',
    'mailqueue.sender' => 'Remitente',
    'mailqueue.recipients' => 'Destinatarios',
    'mailqueue.date' => 'Fecha',
    'mailqueue.age' => 'Antigüedad',
    'mailqueue.size' => 'Tamaño',
    'mailqueue.buttonRefresh' => 'Actualizar',
    'mailqueue.buttonRefreshHint' => 'Actualice los datos en pantalla.',
    'mailqueue.buttonRemove' => 'Eliminar',
    'mailqueue.buttonRemoveHint' => 'Elimine los mensajes seleccionados de la cola de correo.',
    'mailqueue.confirmOnDelete' => '¿Realmente desea eliminar los mensajes seleccionados de la cola de correo?',
    'mailqueue.buttonClean' => 'Borrar',
    'mailqueue.buttonCleanHint' => 'Borre la cola de correo de todos los mensajes.',
    'mailqueue.confirmOnClean' => '¿Realmente desea borrar la cola de correo?',
    'mailqueue.queueAll' => 'Todos',
    'mailqueue.queueTodo' => 'No preprocesado',
    'mailqueue.queueRemote' => 'Remoto',
    'mailqueue.queueLocal' => 'Local',
    'mailqueue.queueLocalAndRemote' => 'Local y remoto',
    'mailqueue.queueActive' => 'Cola de mensajes activos',
    'mailqueue.queueCorrupted' => 'Cola de mensajes corruptos',
    'mailqueue.queueDeferred' => 'Cola de mensajes pospuestos',
    'mailqueue.queueHold' => 'Cola de mensajes en espera',
    'mailqueue.queueIncoming' => 'Cola de mensajes entrantes',
    'mailqueue.postfixHint' => 'Mensajes en la cola: %%deferred%% pospuestos, %%hold%% en espera, %%incoming%% entrantes, %%active%% activos, %%corrupted%% corruptos, %%total%% en total.',
    'mailqueue.qmailHint' => 'Mensajes en la cola: %%todo%% not preprocessed, %%local%% local, %%remote%% remote, %%total%% total.',
    'mailqueue.messagesDeleted' => 'Los mensajes seleccionados se han eliminado de la cola de correo.',
    'mailqueue.messagesNotDeleted' => 'No se han podido eliminar algunos mensajes de la cola de correo: %%error%%',
    'mailqueue.queueCleaned' => 'La cola de correo se ha borrado correctamente.',
    'mailqueue.queueNotCleaned' => 'No se ha podido borrar la cola de correo: %%error%%.',

    'phpextensions.enable' => 'Activar extensión',
    'phpextensions.disable' => 'Desactivar extensión',

    'phpextensions.installable.status' => 'Estado',
    'phpextensions.installable.notInstalled' => 'No instalado',
    'phpextensions.installable.outdated' => 'Obsoleto, la última versión es %%latestVersion%%',
    'phpextensions.installable.latest' => 'Último',
    'phpextensions.installable.name' => 'Paquete',
    'phpextensions.installable.description' => 'Descripción',
    'phpextensions.installable.actionInstall' => 'Instalar',
    'phpextensions.installable.actionUpgrade' => 'Actualizar a %%version%%',
    'phpextensions.installable.actionDocs' => 'Documentación',
    'phpextensions.installable.actionUninstall' => 'Desinstalar',
    'phpextensions.installable.uninstallConfirmation' => '¿Está seguro de que desea desinstalar el paquete %%name%%?',
    'phpextensions.installable.groupInstall' => 'Instalar',
    'phpextensions.installable.groupReload' => 'Volver a cargar',
    'phpextensions.installable.buttonInstallCustom' => 'Instalar paquete',
    'phpextensions.installable.buttonInstallCustomHint' => 'Instalar cualquier paquete PECL',
    'phpextensions.installable.buttonReload' => 'Volver a cargar',
    'phpextensions.installable.buttonReloadHint' => 'Volver a cargar paquetes PECL',
    'phpextensions.installable.emptyViewFilteredTitle' => 'No se encontró ningún paquete que coincida con el filtro',
    'phpextensions.installable.emptyViewFilteredDescription' => 'Pruebe a instalar el paquete que está buscando.',

    'phphandlers.name' => 'Controlador',
    'phphandlers.domains' => 'Dominios',
    'phphandlers.statusBroken' => 'Este controlador está dañado.',
    'phphandlers.statusDisallowedApacheModule' => 'No es posible activar el controlador porque el módulo Apache correspondiente está desactivado.',
    'phphandlers.domainsTitle' => '%%domains%% dominios utilizan PHP %%handler%%',
    'phphandlers.closeTitle' => 'Cerrar',
    'phphandlers.handlerOutdated' => '(Obsoleto)',
    'phphandlers.handlerDeprecated' => '(En desuso)',
    'phphandlers.handlerOutdatedAndDeprecated' => '(Obsoleto, en desuso)',

    'planitems.name' => 'Nombre',
    'planitems.numberOfPlans' => 'Planes de servicio',
    'planitems.numberOfSubscriptions' => 'Suscripciones',
    'planitems.itemInvisible' => 'No disponible para revendedores',
    'planitems.buttonMakeItemVisible' => 'Hacer disponible',
    'planitems.buttonMakeItemVisibleDescription' => 'Permita a los revendedores proporcionar los servicios seleccionados con sus planes de hosting. Las opciones correspondientes a estos servicios se mostrarán en las propiedades del plan de hosting, en la pestaña Servicios adicionales.',
    'planitems.buttonMakeItemInvisible' => 'Hacer no disponible',
    'planitems.buttonMakeItemInvisibleDescription' => 'No permita a los revendedores proporcionar los servicios seleccionados con sus planes de hosting. Las opciones correspondientes a estos servicios serán eliminadas de las propiedades del plan de hosting.',
    'planitems.buttonAddNewCustomItemButton' => 'Añadir servicio',
    'planitems.buttonAddNewCustomItemButtonDescription' => 'Añada un servicio a las opciones del plan.',
    'planitems.buttonRemoveCustomItem' => 'Eliminar servicio',
    'planitems.buttonRemoveCustomItemDescription' => 'Elimine las opciones correspondientes a los servicios seleccionados de las propiedades del plan de hosting.',
    'planitems.confirmOnDeleteSupportButton' => '¿Está seguro de que desea eliminar las opciones seleccionadas?',

    'pumpackages.buttonUpdate' => 'Actualizar',
    'pumpackages.buttonUpdateDescription' => 'Actualice los paquetes seleccionados.',
    'pumpackages.buttonLock' => 'Bloquear',
    'pumpackages.buttonLockDescription' => 'Bloquee los paquetes seleccionados para impedir su actualización.',
    'pumpackages.buttonUnlock' => 'Desbloquear',
    'pumpackages.buttonUnlockDescription' => 'Desbloquee los paquetes seleccionados para que puedan ser actualizados.',
    'pumpackages.buttonCheckUpdates' => 'Buscar actualizaciones',
    'pumpackages.buttonCheckUpdatesDescription' => 'Busque actualizaciones de paquetes.',
    'pumpackages.name' => 'Paquete',
    'pumpackages.summary' => 'Descripción',
    'pumpackages.updates' => 'Actualizaciones',
    'pumpackages.lockedCut' => 'L',
    'pumpackages.lockedHint' => 'El paquete está bloqueado.',
    'pumpackages.unlockedHint' => 'El paquete está desbloqueado.',
    'pumpackages.updated' => 'Actualizado',
    'pumpackages.update' => 'Actualizar a %%version%%',
    'pumpackages.unknownRepo' => 'desconocido',
    'pumpackages.allUpToDate' => 'Todos los paquetes están debidamente actualizados',
    'pumpackages.allUpToDateLastChecked' => 'Comprobado el %%date%%',
    'pumpackages.recheckUpdates' => 'Volver a comprobar',
    'pumpackages.popupInfoTitle' => 'Detalles del paquete %%package%%',
    'pumpackages.loading' => 'Espere...',
    'pumpackages.error' => 'No se pudo obtener la lista de paquetes: %%message%%',
    'pumpackages.currentVersion' => 'versión actual: %%version%%',
    'pumpackages.notInstalled' => 'no instalado',
    'pumpackages.popupUpdateTitle' => 'Actualización de paquetes',
    'pumpackages.popupUpdatePackagesListTitle' => 'Instale las siguientes actualizaciones:',
    'pumpackages.popupUpdateLockedPackagesListTitle' => 'Los siguientes paquetes requeridos están bloqueados y no pueden actualizarse:',
    'pumpackages.popupUpdateDependencies' => '%%count%% paquetes dependientes',
    'pumpackages.unlockPackagesForUpdateOnly' => 'Desbloquear los paquetes solo para aplicar esta actualización',
    'pumpackages.lockedError' => 'La herramienta Actualizaciones del sistema ya está instalando actualizaciones de forma automática. Inténtelo transcurridos unos minutos.',
    'pumpackages.duplicatesError' => 'Error: no pudo recibirse la información de actualización porque algunos paquetes tienen duplicados. Elimine los duplicados de los siguientes paquetes: %%duplicates%%',
    'pumpackages.updateInfoError' => 'Error. No se pudo recibir la información acerca de la actualización del/de los paquete(s)',
    'pumpackages.selectedPackagesUpToDate' => 'Todos los paquetes seleccionados están debidamente actualizados.',
    'pumpackages.taskUpdatingPackages' => 'Actualizando %%count%% paquete(s)...',
    'pumpackages.popupLockTitle' => 'Bloqueo de paquetes',
    'pumpackages.popupLockDescription' => 'Si bloquea un paquete, este no podrá actualizarse mediante la herramienta Actualizaciones del sistema, a menos que actualice el propio Plesk. Si existen otros paquetes que requieren una versión más reciente de este paquete para poderse actualizar, estos no serán actualizados. Tenga en cuenta que podrá seguir actualizando un paquete bloqueado mediante los medios nativos en la consola. Si desea actualizar un paquete bloqueado a través de la interfaz de Plesk, primero deberá desbloquearlo.',
    'pumpackages.popupLockPackagesListTitle' => 'Bloquear los siguientes paquetes:',
    'pumpackages.popupUnlockTitle' => 'Desbloqueo de paquetes',
    'pumpackages.popupUnlockDescription' => 'Estos paquetes no pueden actualizarse porque fueron bloqueados para así impedir su actualización. Tenga en cuenta que puede actualizar un paquete bloqueado de forma nativa en la consola o mientras actualiza el propio Plesk. Para actualizar un paquete bloqueado a través de la interfaz de Plesk, primero deberá desbloquearlo.',
    'pumpackages.popupUnlockPackagesListTitle' => 'Desbloquear los siguientes paquetes:',
    'pumpackages.updatesAvailable' => 'Existen actualizaciones para %%count%% paquetes de sistema',
    'pumpackages.lastedChecked' => '(comprobado el %%date%%)',
    'pumpackages.updateAll' => 'Actualizar todo',
    'pumpackages.packageManagerDbInconsistent' => 'Es posible que la información sobre algunos paquetes no esté actualizada, puesto que se han detectado algunas incoherencias en la base de datos del administrador de paquetes del sistema. Rogamos las resuelva de forma manual.',

    'resellers.filterResellerName' => 'Nombre del revendedor',
    'resellers.filterSubscription' => 'Suscripción',
    'resellers.filterOptionSubscriptionAny' => 'Cualquiera',
    'resellers.filterOptionSubscriptionCustom' => 'Personalizado',
    'resellers.filterResourceUsage' => 'Uso de recursos',
    'resellers.filterOptionResourceUsageAny' => 'Cualquiera',
    'resellers.filterOptionResourceUsageOveruse' => 'Recursos que presentan sobreuso',
    'resellers.filterOptionResourceUsageOk' => 'Dentro de los límites',
    'resellers.filterStatus' => 'Estado',
    'resellers.filterOptionStatusAny' => 'Cualquiera',
    'resellers.filterOptionStatusSuspended' => 'Suspendido',
    'resellers.filterOptionStatusActive' => 'Activo',
    'resellers.filterSubscriptionStatus' => 'Estado de la suscripción',
    'resellers.filterOptionSubscriptionStatusAny' => 'Cualquiera',
    'resellers.filterOptionSubscriptionStatusLocked' => 'Bloqueado',
    'resellers.filterOptionSubscriptionStatusUnsynchronized' => 'No sincronizado',
    'resellers.filterDescription' => 'Descripción',
    'resellers.buttonAddNewReseller' => 'Añadir revendedor',
    'resellers.hintAddNewReseller' => 'Cree una cuenta de revendedor.',
    'resellers.buttonRemove' => 'Eliminar',
    'resellers.hintRemove' => 'Elimine los revendedores seleccionados y todos sus planes de servicios, clientes y suscripciones.',
    'resellers.confirmOnDelete' => '¿Está seguro de que desea eliminar la(s) {count, plural, =1 {the {name} reseller account} one {the # selected reseller account} other {# cuenta(s) de revendedor seleccionada(s)}} y {count, plural, one {its} other {su(s)}} planes de servicio, clientes y suscripciones?',
    'resellers.buttonConvertToCustomer' => 'Convertir en clientes',
    'resellers.hintConvertToCustomer' => 'Convierta los revendedores seleccionados en clientes.',
    'resellers.buttonChangeStatus' => 'Cambiar estado',
    'resellers.buttonActivateResellers' => 'Activar',
    'resellers.hintActivateResellers' => 'Active las cuentas de revendedor seleccionadas.',
    'resellers.buttonSuspendResellers' => 'Suspender',
    'resellers.hintSuspendResellers' => 'Suspenda las cuentas de revendedor seleccionadas. Se bloqueará el acceso al panel del cliente tanto para los revendedores como para todos sus clientes; Se suspenderán los dominios de los revendedores y sus clientes y los usuarios de internet ya no podrán acceder a sus servicios de correo, FTP y web.',
    'resellers.resellerName' => 'Nombre del revendedor',
    'resellers.planName' => 'Plan de servicio',
    'resellers.setupDate' => 'Fecha de alta',
    'resellers.customers' => 'Clientes',
    'resellers.customPlanName' => 'Personalizado',
    'resellers.buttonLogin' => 'Iniciar sesión como revendedor',
    'resellers.hintLogin' => 'Administre los servicios de hosting asociados a la cuenta de hosting del revendedor.',
    'resellers.statusOk' => 'El estado de esta cuenta de revendedor es correcto: la cuenta está activa y la suscripción está sincronizada con el plan.',
    'resellers.statusSuspended' => 'Esta cuenta de revendedor está suspendida: el acceso al panel del cliente está bloqueado para el revendedor y todos sus clientes; Los dominios del revendedor y sus clientes están suspendidos y los usuarios de Internet ya no pueden acceder a sus servicios de correo, FTP y web.',
    'resellers.statusLocked' => 'La suscripción está bloqueada para sincronización: Esta se excluye de la sincronización con el plan de servicio porque los parámetros de la suscripción han sido personalizados.',
    'resellers.statusUnsynchronized' => 'La suscripción no está sincronizada con el plan del revendedor: Existen algunos recursos o servicios que el plan del revendedor sí ofrece pero que la suscripción no proporciona.',

    'resellerserviceplans.planName' => 'Nombre del plan',
    'resellerserviceplans.planTraffic' => 'Tráfico',
    'resellerserviceplans.planDiskSpace' => 'Espacio en disco',
    'resellerserviceplans.planSubscriptions' => 'Revendedores',
    'resellerserviceplans.unlimited' => 'Ilimitado',
    'resellerserviceplans.buttonAddNewPlan' => 'Añadir plan',
    'resellerserviceplans.hintAddNewPlan' => 'Cree un plan de revendedor.',
    'resellerserviceplans.buttonDuplicatePlans' => 'Clonar planes',
    'resellerserviceplans.hintDuplicatePlans' => 'Cree copias de los planes de revendedor seleccionados.',
    'resellerserviceplans.buttonRemove' => 'Eliminar',
    'resellerserviceplans.hintRemove' => 'Elimine los planes de revendedor seleccionados.',
    'resellerserviceplans.confirmOnDelete' => '¿Desea eliminar los planes de revendedor seleccionados?',
    'resellerserviceplans.disabledSelectHint' => 'No se pueden eliminar planes de revendedor que tengan asociados una o más suscripciones.',

    'restricteddomains.name' => 'Nombre de dominio',
    'restricteddomains.buttonAddNewDomain' => 'Añadir nombre de dominio',
    'restricteddomains.buttonEnableList' => 'Activar',
    'restricteddomains.hintAddNewDomain' => 'Añada un nombre de dominio prohibido.',
    'restricteddomains.hintEnableList' => 'Active la comprobación de los nombres de dominio durante la creación de dominios.',
    'restricteddomains.buttonDisableList' => 'Desactivar',
    'restricteddomains.hintDisableList' => 'Desactive la comprobación de los nombres de dominio durante la creación de dominios.',
    'restricteddomains.buttonRemoveDomain' => 'Eliminar',
    'restricteddomains.hintRemoveDomain' => 'Elimine los nombres de dominio seleccionados.',
    'restricteddomains.confirmOnRemove' => '¿Desea eliminar los nombres de dominio seleccionados?',
    'restricteddomains.buttonMoreActions' => 'Más',

    'servermailblacklist.groupAdd' => 'Añadir',
    'servermailblacklist.buttonAdd' => 'Añadir dominio',
    'servermailblacklist.buttonAddHint' => 'Añadir dominio a la lista negra',
    'servermailblacklist.groupActions' => 'Acciones',
    'servermailblacklist.buttonRemove' => 'Eliminar',
    'servermailblacklist.entries' => 'Entradas',
    'servermailblacklist.action' => 'Acción',
    'servermailblacklist.deleteAction' => 'Eliminar del servidor',
    'servermailblacklist.spamAction' => 'Marcar como spam',
    'servermailblacklist.spamAssassinDisabled' => 'Las entradas no se marcarán como spam porque SpamAssassin no está instalado o está desactivado',
    'servermailblacklist.removeEmptySelection' => 'No se ha seleccionado ninguna entrada.',
    'servermailblacklist.removeConfirmation' => '¿Está seguro de que desea eliminar {count, plural, =1 {la entrada {name}} one {la # entrada seleccionada} other {las # entradas seleccionadas}}?',
    'servermailblacklist.removeSuccess' => 'Las entradas seleccionadas han sido eliminadas.',

    'servermailwhitelist.groupAdd' => 'Añadir',
    'servermailwhitelist.buttonAdd' => 'Añadir red',
    'servermailwhitelist.buttonAddHint' => 'Añada la red a la lista blanca',
    'servermailwhitelist.groupActions' => 'Acciones',
    'servermailwhitelist.buttonRemove' => 'Eliminar',
    'servermailwhitelist.entries' => 'Entradas',
    'servermailwhitelist.whiteListNotEmpty' => 'Los límites del correo saliente no funcionarán en el caso de remitentes cuya dirección IP esté presente en la lista blanca del servidor de correo. Por ejemplo, si en la lista blanca existe localhost (127.0.0.0 / 8, ::1 / 128), todos los correos procedentes del servidor local se enviarán correctamente sean cuales sean las limitaciones establecidas. Aquellos que envíen correos pueden utilizar direcciones IP locales (sitios web y scripts personalizados alojados en el servidor local) o direcciones IP externas (clientes que envían correos a través de clientes de correo instalados en sus ordenadores o dispositivos móviles). Para que se apliquen los límites establecidos para todos los remitentes de correo (tanto locales como externos), elimine todas las direcciones IP y redes de la lista blanca. Tenga en cuenta que la eliminación de localhost (127.0.0.0 / 8, ::1 / 128) de la lista blanca puede ocasionar una interrupción de los sitios web y scripts que envían correos desde este servidor. Si desea más información acerca de las limitaciones del correo saliente, consulte la sección Protección frente a spam saliente de la guía del administrador.',
    'servermailwhitelist.removeEmptySelection' => 'No se ha seleccionado ninguna entrada.',
    'servermailwhitelist.removeConfirmation' => '¿Está seguro de que desea eliminar {count, plural, =1 {la entrada {name}} one {la # entrada seleccionada} other {las # entradas seleccionadas}}?',
    'servermailwhitelist.webmailAffected' => 'La eliminación de {count, plural, =1 {la siguiente red} one {la siguiente red} other {las siguientes redes}} puede imposibilitar el envío de correo desde el webmail: %%list%%',
    'servermailwhitelist.webmailAffectedSingle' => 'La eliminación de esta red puede imposibilitar el envío de correo desde el webmail.',
    'servermailwhitelist.removeSuccess' => 'Las entradas seleccionadas han sido eliminadas.',

    'serverprotection.bannedips.pageHint' => 'Aquí puede ver las direcciones IP prohibidas, cancelar su prohibición o bien moverlas a la lista de direcciones IP de confianza.',
    'serverprotection.bannedips.ip' => 'Dirección IP',
    'serverprotection.bannedips.banDate' => 'Fecha de la prohibición',
    'serverprotection.bannedips.jail' => 'Jail usado',
    'serverprotection.bannedips.buttonRemoveIp' => 'Cancelar la prohibición',
    'serverprotection.bannedips.hintRemoveIp' => 'Elimine las direcciones IP seleccionadas de la lista de direcciones prohibidas.',
    'serverprotection.bannedips.buttonMoveToTrustedIp' => 'Mover a IPs de confianza',
    'serverprotection.bannedips.hintMoveToTrustedIp' => 'Mueva las direcciones IP seleccionadas a la lista de direcciones de confianza.',
    'serverprotection.bannedips.buttonEnable' => 'Activar la prohibición de direcciones IP',
    'serverprotection.bannedips.hintEnable' => 'Active la prohibición automática de redes y direcciones IP que generan tráfico malintencionado para su servidor.',
    'serverprotection.bannedips.buttonDisable' => 'Desactivar la prohibición de direcciones IP',
    'serverprotection.bannedips.hintDisable' => 'Desactive la prohibición automática de redes y direcciones IP que generan tráfico malintencionado para su servidor.',
    'serverprotection.bannedips.errorEnableFailed' => 'No es posible activar la prohibición de direcciones IP: %%error%%.',
    'serverprotection.bannedips.errorDisableFailed' => 'No es posible desactivar la prohibición de direcciones IP: %%error%%.',

    'serverprotection.filters.pageHint' => 'Aquí puede gestionar los filtros de jails.',
    'serverprotection.filters.buttonAddFilter' => 'Añadir filtro',
    'serverprotection.filters.hintAddFilter' => 'Añada un filtro.',
    'serverprotection.filters.buttonRemoveFilter' => 'Eliminar',
    'serverprotection.filters.hintRemoveFilter' => 'Elimine los filtros seleccionados.',
    'serverprotection.filters.name' => 'Nombre del filtro',

    'serverprotection.jails.pageHint' => 'Aquí puede ver la lista de jails utilizados para la detección de direcciones IP abusivas.',
    'serverprotection.jails.buttonAddJail' => 'Añadir jail',
    'serverprotection.jails.hintAddJail' => 'Añada un jail.',
    'serverprotection.jails.buttonDisableJails' => 'Desactivar',
    'serverprotection.jails.hintDisableJails' => 'Desactive los jails seleccionados.',
    'serverprotection.jails.buttonActivateJails' => 'Activar',
    'serverprotection.jails.hintActivateJails' => 'Active los jails seleccionados.',
    'serverprotection.jails.buttonRemoveJail' => 'Eliminar',
    'serverprotection.jails.hintRemoveJail' => 'Elimine los jails seleccionados.',
    'serverprotection.jails.buttonManageFilters' => 'Administrar filtros',
    'serverprotection.jails.hintManageFilters' => 'Aquí puede gestionar los filtros de jails.',
    'serverprotection.jails.name' => 'Nombre del jail',
    'serverprotection.jails.disabled' => 'Inactivo',
    'serverprotection.jails.active' => 'Activo',
    'serverprotection.jails.status' => 'Estado',
    'serverprotection.jails.confirmOnDelete' => '¿Está seguro de que desea eliminar los jails seleccionados?',

    'serverprotection.logs.pageHint' => 'Aquí puede ver los registros de Fail2ban.',
    'serverprotection.logs.name' => 'Archivo',
    'serverprotection.logs.viewHint' => 'Vea el archivo de registro.',
    'serverprotection.logs.buttonDownloadHint' => 'Descargue el archivo de registro',

    'serverprotection.trustedips.pageHint' => 'Aquí puede ver las direcciones IP de confianza y añadir o eliminar direcciones IP de la lista de direcciones de confianza.',
    'serverprotection.trustedips.ip' => 'Dirección IP',
    'serverprotection.trustedips.ipDesc' => 'Descripción',
    'serverprotection.trustedips.addDate' => 'Fecha de adición a IPs de confianza',
    'serverprotection.trustedips.comment' => 'Comentario',
    'serverprotection.trustedips.buttonRemoveIp' => 'Eliminar',
    'serverprotection.trustedips.hintRemoveIp' => 'Elimine las direcciones IP seleccionadas de la lista de direcciones de confianza.',
    'serverprotection.trustedips.buttonAddTrustedIp' => 'Añadir IP de confianza',
    'serverprotection.trustedips.hintAddTrustedIp' => 'Añada una dirección IP a la lista de direcciones de confianza.',
    'serverprotection.trustedips.buttonEditTrustedIp' => 'Editar descripción',
    'serverprotection.trustedips.buttonEditHint' => 'Edite la descripción de una dirección IP.',

    'serviceinstances.name' => 'Nombre del servicio',
    'serviceinstances.type' => 'Tipo de servicio',
    'serviceinstances.requiredServices' => 'Servicios necesarios',
    'serviceinstances.description' => 'Descripción',
    'serviceinstances.buttonAddServiceToSubscription' => 'Añadir servicio',
    'serviceinstances.buttonAddServiceToSubscriptionHint' => 'Añada un servicio a la suscripción.',
    'serviceinstances.buttonRemove' => 'Eliminar',
    'serviceinstances.buttonRemoveHint' => 'Eliminar los servicios seleccionados.',
    'serviceinstances.confirmOnDelete' => '¿Está seguro de que desea eliminar los servicios seleccionados?',
    'serviceinstances.isEnabled' => 'La instancia de servicio está activada',
    'serviceinstances.isDisabled' => 'La instancia de servicio está desactivada',

    'servicenodes.buttonAddServiceNode' => 'Añadir nodo de servicio',
    'servicenodes.buttonAddServiceNodeDescription' => 'Añadir descripción del nodo de servicio',
    'servicenodes.buttonRemoveServiceNode' => 'Eliminar nodo de servicio',
    'servicenodes.buttonRemoveServiceNodeDescription' => 'Eliminar descripción del nodo de servicio',
    'servicenodes.description' => 'Descripción',
    'servicenodes.ipAddress' => 'Dirección IP',
    'servicenodes.confirmOnDelete' => '¿Realmente desea eliminar los nodos de servicio seleccionados? ',
    'servicenodes.disabledSelectHint' => 'No se pudo eliminar el nodo de servicio porque existen direcciones IP asociadas con el mismo.',

    'services.stateColumnHeader' => 'Estado',
    'services.nameColumnHeader' => 'Servicio',
    'services.startupTypeColumnHeader' => 'Tipo de inicio',
    'services.autoStartupType' => 'Automático',
    'services.manualStartupType' => 'Manual',
    'services.disabledStartupType' => 'Deshabilitado',
    'services.changeStartupTypeTooltip' => 'Cambie el tipo de inicio para el servicio',
    'services.drwebName' => 'Plesk Premium Antivirus',
    'services.postgresqlName' => 'PostgreSQL',
    'services.tomcatName' => 'Tomcat Java',
    'services.imap-pop3Name' => 'Servidor Dovecot IMAP y POP3',
    'services.pop3Name' => 'Servidor Courier POP3',
    'services.pop3sName' => 'Servidor Courier POP3 con soporte para SSL/TLS',
    'services.imapName' => 'Servidor Courier IMAP',
    'services.imapsName' => 'Servidor Courier IMAP con soporte para SSL/TLS',
    'services.authdaemonName' => 'Daemon de autenticación de Courier IMAP',
    'services.dnsName' => 'Servidor DNS (%%displayName%%)',
    'services.fail2banName' => 'Prohibición de direcciones IP (Fail2ban)',
    'services.kavName' => 'Kaspersky Antivirus',
    'services.milterName' => "Milter de Plesk (%%displayName%%)",
    'services.nginxName' => 'Servidor proxy inverso (nginx)',
    'services.smtpName' => 'Servidor SMTP (%%displayName%%)',
    'services.spamassassinName' => "SpamAssassin",
    'services.webName' => "Servidor web (%%displayName%%)",
    'services.resctrlName' => "Controlador de recursos (cgroups)",
    'services.activeState' => 'Habilitado',
    'services.inActiveState' => 'Deshabilitado',
    'services.do-restart' => 'Reiniciando',
    'services.do-start' => 'Iniciando',
    'services.do-stop' => 'Desactivando',
    'services.do-changeStartup' => 'Procesando',
    'services.notConfiguredState' => 'No configurado',
    'services.notInstalledState' => 'No instalado',
    'services.running-start' => 'El servicio ya se ha iniciado.',
    'services.notRunning-start' => 'Inicie el servicio.',
    'services.running-stop' => 'Detenga el servicio.',
    'services.notRunning-stop' => 'El servicio ya ha está detenido.',
    'services.running-restart' => 'Reinicie el servicio.',
    'services.notRunning-restart' => 'El servicio está detenido.',
    'services.startServiceDrWeb' => 'Para poder iniciar el servicio de antivirus, al menos debe disponer de un buzón de correo que tenga activada la comprobación antivirus.',
    'services.serviceDisabled' => 'Esta función no está disponible porque su llave de licencia no la soporta o bien porque el servicio no está instalado o configurado correctamente.',
    'services.serviceDisabledStartupType' => 'Servicio deshabilitado.',
    'services.phpHandlerSettingsByOsVendor' => '%%displayName%% del proveedor del SO',
    'services.phpFpm' => 'PHP-FPM %%displayName%%',
    'services.urlrewriteComponentName' => "URL Rewrite",
    'services.dbconnectorComponentName' => "Conector de bases de datos",
    'services.tomcatComponentName' => 'Apache Tomcat',
    'services.mysqlserverComponentName' => 'MySQL Server',
    'services.troubleshootingComponentName' => 'Resolución de problemas',
    'services.wafComponentName' => 'Firewall para aplicaciones web',
    'services.vcsComponentName' => 'Sistema de control de versiones',
    'services.antivirusComponentName' => "Antivirus",
    'services.databaseComponentName' => "SQL Server",
    'services.sqladminComponentName' => "MySQL Webadmin",
    'services.sqladminmysqlComponentName' => "MySQL Webadmin",
    'services.dnsserverComponentName' => "Servidor DNS",
    'services.firewallComponentName' => "Firewall",
    'services.ftpserverComponentName' => "Servidor FTP",
    'services.javaComponentName' => "Java",
    'services.mailserverComponentName' => "Servidor de correo",
    'services.pleskagentComponentName' => "Plesk Agent",
    'services.psaComponentName' => "Plesk",
    'services.scriptComponentName' => "Scripting web",
    'services.spamfilterComponentName' => "Filtro antispam",
    'services.statsComponentName' => "Estadísticas web",
    'services.stunnelComponentName' => "Contenedor SSL/TLS",
    'services.webmailComponentName' => "Webmail",
    'services.webpublishComponentName' => "Publicación web",
    'services.webserverComponentName' => "Servidor web",
    'services.backupsystemComponentName' => 'Sistema de backups',
    'services.networkComponentName' => 'Redes',
    'services.sitebuilderComponentName' => 'Presence Builder',
    'services.saviComponentName' => 'Interfaz del antivirus Sophos',
    'services.waitMessage' => 'Rogamos espere',
    'services.buttonRefreshComponents' => 'Actualizar',
    'services.searchTitle' => 'Encontrar servicios...',
    'services.hintRefreshComponents' => 'Actualice la lista de componentes',

    'sessions.searchTitle' => 'Búsqueda de sesiones activas',
    'sessions.buttonRefresh' => 'Actualizar',
    'sessions.buttonRefreshDescription' => 'Sincronice la lista de sesiones con las sesiones abiertas en este momento.',
    'sessions.buttonRemove' => 'Cerrar',
    'sessions.buttonRemoveDescription' => 'Cierre las sesiones seleccionadas.',
    'sessions.removeConfirmMessage' => '¿Desea cerrar las sesiones seleccionadas?',
    'sessions.buttonSettings' => 'Configuración de la sesión',
    'sessions.buttonSettingsDescription' => 'Modifique los parámetros de la sesión.',
    'sessions.headerType' => 'T',
    'sessions.headerLogin' => 'Nombre de usuario',
    'sessions.headerIpAddress' => 'Dirección IP',
    'sessions.headerLogonTime' => 'Hora de inicio de sesión',
    'sessions.headerIdleTime' => 'Tiempo de inactividad',
    'sessions.typeAdmin' => 'Sesión del administrador.',
    'sessions.typeReseller' => 'Sesión de revendedor.',
    'sessions.typeClient' => 'Sesión de cliente.',
    'sessions.altAdminIcon' => 'Admin',
    'sessions.altResellerIcon' => 'Revendedor',
    'sessions.altClientIcon' => 'Cliente',

    'sslcertificates.name' => 'Nombre',
    'sslcertificates.used' => 'Usado',
    'sslcertificates.csrHint' => 'Se proporciona el componente CSR.',
    'sslcertificates.noCsrHint' => 'No se proporciona el componente CSR.',
    'sslcertificates.privateKeyHint' => 'Se proporciona el componente de clave privada.',
    'sslcertificates.noPrivateKeyHint' => 'No se proporciona el componente de clave privada.',
    'sslcertificates.certificateHint' => 'Se proporciona el componente Certificado.',
    'sslcertificates.noCertificateHint' => 'No se proporciona el componente Certificado.',
    'sslcertificates.caCertificateHint' => 'Se proporciona el componente Certificado CA.',
    'sslcertificates.noCaCertificateHint' => 'No se proporciona el componente Certificado CA.',
    'sslcertificates.buttonDownloadHint' => 'Descargue todos los componentes de certificado.',
    'sslcertificates.remove' => 'Eliminar',
    'sslcertificates.hintRemove' => 'Elimine los certificados SSL/TLS seleccionados del repositorio del dominio.',
    'sslcertificates.confirmOnDelete' => '¿Desea eliminar los certificados SSL/TLS seleccionados?',
    'sslcertificates.addCertificate' => 'Añadir',
    'sslcertificates.hintAddCertificate' => 'Añada un certificado SSL/TLS.',
    'sslcertificates.viewCertificates' => 'Ver',
    'sslcertificates.hintViewCertificates' => 'Vea la lista de certificados SSL/TLS que ha comprado a su proveedor.',
    'sslcertificates.unableSetupPanelCertificate' => 'No se pudo instalar el certificado en Plesk porque no se ha encontrado el contenido del certificado y la clave privada.',
    'sslcertificates.makeDefault' => 'Hacer predeterminado',
    'sslcertificates.hintMakeDefault' => 'Use el certificado SSL/TLS seleccionado para la protección de las conexiones a sitios web nuevos.',
    'sslcertificates.unableMakeDefault' => 'No se pudo instalar el certificado predeterminado porque no se seleccionó ningún certificado con clave privada.',
    'sslcertificates.successMakeDefault' => 'El certificado SSL/TLS seleccionado se ha configurado como el certificado predeterminado. Este puede usarse para proteger los sitios web nuevos así como los sitios ya existentes. Aquellos sitios web que utilicen el certificado predeterminado anterior seguirán usando dicho certificado.',
    'sslcertificates.selectOne' => 'Seleccione un certificado SSL/TLS.',

    'subscriptions.filterDomainName' => 'Nombre',
    'subscriptions.filterSubscription' => 'Plan de servicio',
    'subscriptions.filterOptionSubscriptionAny' => 'Cualquiera',
    'subscriptions.filterOptionSubscriptionMy' => 'Mis planes',
    'subscriptions.filterOptionSubscriptionReseller' => 'Planes de %%planOwnerContactName%%',
    'subscriptions.filterOptionSubscriptionCustom' => 'Personalizado',
    'subscriptions.filterOptionSubscriptionAddonType' => '(complemento)',
    'subscriptions.filterResourceUsage' => 'Uso de recursos',
    'subscriptions.filterOptionResourceUsageAny' => 'Cualquiera',
    'subscriptions.filterOptionResourceUsageOveruse' => 'Recursos que presentan sobreuso',
    'subscriptions.filterOptionResourceUsageOk' => 'Dentro de los límites',
    'subscriptions.filterPlanItem' => 'Elemento de plan personalizado',
    'subscriptions.filterOptionPlanItemAny' => 'Cualquiera',
    'subscriptions.filterProvider' => 'Proveedor',
    'subscriptions.filterOptionProviderAny' => 'Todas las suscripciones',
    'subscriptions.filterOptionProviderMy' => 'Mis suscripciones',
    'subscriptions.filterProviderReseller' => 'Suscripciones de %%resellerContactName%%',
    'subscriptions.filterStatus' => 'Estado',
    'subscriptions.filterOptionStatusAny' => 'Cualquiera',
    'subscriptions.filterOptionStatusSuspended' => 'Suspendido',
    'subscriptions.filterOptionStatusActive' => 'Activo',
    'subscriptions.filterSubscriptionStatus' => 'Estado de la suscripción',
    'subscriptions.filterOptionSubscriptionStatusAny' => 'Cualquiera',
    'subscriptions.filterOptionSubscriptionStatusLocked' => 'Bloqueado',
    'subscriptions.filterOptionSubscriptionStatusUnsynchronized' => 'No sincronizado',
    'subscriptions.filterSubscriberName' => 'Suscriptor',
    'subscriptions.filterDescription' => 'Descripción',
    'subscriptions.subscriptionName' => 'Suscripción',
    'subscriptions.subscriberName' => 'Suscriptor',
    'subscriptions.setupDate' => 'Fecha de alta',
    'subscriptions.expirationDate' => 'Fecha de expiración',
    'subscriptions.description' => 'Descripción',
    'subscriptions.resellerDescription' => 'Revendedor',
    'subscriptions.ownerDescription' => 'Cliente',
    'subscriptions.manageInResellerPanel' => 'Administrar en panel del revendedor',
    'subscriptions.manageInCustomerPanel' => 'Administrar en panel del cliente',
    'subscriptions.buttonAddNewOwnSubscription' => 'Añadir suscripción propia',
    'subscriptions.hintAddNewOwnSubscription' => 'Cree una suscripción para uso propio.',
    'subscriptions.buttonAddNewSubscription' => 'Añadir suscripción',
    'subscriptions.hintAddNewSubscription' => 'Cree una suscripción.',
    'subscriptions.buttonChangeSubscription' => 'Cambiar plan',
    'subscriptions.hintChangeSubscription' => 'Asocie las suscripciones seleccionadas con otro plan de servicio y elimine o añada complementos de plan si el proveedor de las suscripciones los ofrece.',
    'subscriptions.buttonRemove' => 'Eliminar',
    'subscriptions.hintRemove' => 'Elimine las suscripciones seleccionadas.',
    'subscriptions.confirmOnRemove' => '¿Desea eliminar las suscripciones seleccionadas?',
    'subscriptions.buttonSetStatus' => 'Definir estado',
    'subscriptions.buttonActivateSubscriptions' => 'Activo',
    'subscriptions.hintActivateSubscriptions' => 'Active las suscripciones seleccionadas.',
    'subscriptions.buttonSuspendSubscriptions' => 'Suspendido',
    'subscriptions.hintSuspendSubscriptions' => 'Suspenda las suscripciones seleccionadas. Todos los servicios proporcionados con las suscripciones serán bloqueados y los usuarios de Internet no podrán acceder a ellos.',
    'subscriptions.buttonChangeOwner' => 'Cambiar suscriptor',
    'subscriptions.hintChangeOwner' => 'Vuelva a asignar las suscripciones seleccionadas a otro suscriptor. Esta acción también modificará el proveedor de las suscripciones, desvinculará las suscripciones de sus planes de servicio y las convertirá en \'Personalizadas\'.',
    'subscriptions.customPlanName' => 'Personalizado',
    'subscriptions.statusOk' => 'El estado de la suscripción es correcto: la suscripción está activa y sincronizada con el plan.',
    'subscriptions.statusSuspended' => 'La suscripción está suspendida: Todos los servicios proporcionados con la suscripción están bloqueados y los usuarios de Internet no pueden acceder a ellos.',
    'subscriptions.statusSuspendedReasonExpired' => 'La suscripción está suspendida porque ha expirado: Todos los servicios proporcionados con la suscripción están bloqueados y los usuarios de Internet no pueden acceder a ellos.',
    'subscriptions.statusLocked' => 'La suscripción está bloqueada para sincronización: Esta se excluye de la sincronización con el plan de servicio porque los parámetros de la suscripción han sido personalizados.',
    'subscriptions.statusUnsynchronized' => 'La suscripción no está sincronizada con el plan de servicio: Existen algunos recursos o servicios ofrecidos por el plan pero no ofrecidos por la suscripción.',
    'subscriptions.confirmOnDelete' => '¿Está seguro de que desea eliminar la(s) {count, plural, =1 {the {name} subscription} one {the # selected subscription} other {# suscripcion(es) seleccionada(s)}}?',
    'subscriptions.hintInfo' => '(?)',
    'subscriptions.webserverConfigurationDomainHintAdmin' => "La configuración del servidor web para los dominios de la suscripción puede no ser coherente. Corrija los errores en las plantillas de configuración de Apache e intente volver a generar el archivo de configuración.",
    'subscriptions.webserverConfigurationDomainHintReseller' => "La configuración del servidor web para los dominios de la suscripción puede no ser coherente. Póngase en contacto con el administrador del servidor para resolver el problema.",
    'subscriptions.unlinkedDomainHint' => 'Algunas de las direcciones IP del dominio no están operativas y se excluyen de la configuración del servidor. Compruebe las vinculaciones de IPs del dominio y actualícelas si es necesario.',
    'subscriptions.hintTitle' => 'Resumen de suscripciones',
    'subscriptions.hintWaitMessage' => 'Cargando...',
    'subscriptions.removeConfirmationSubscription' => "También se eliminarán los siguientes dominios:\n%%domains%%",

    'summaryreportlayouts.delivery' => 'Entrega',
    'summaryreportlayouts.name' => 'Nombre',
    'summaryreportlayouts.general' => 'General',
    'summaryreportlayouts.clients' => 'Clientes',
    'summaryreportlayouts.resellers' => 'Revendedores',
    'summaryreportlayouts.personalClients' => 'Clientes personales',
    'summaryreportlayouts.domains' => 'Dominios',
    'summaryreportlayouts.personalDomains' => 'Dominios personales',
    'summaryreportlayouts.section.FULL' => 'Completo',
    'summaryreportlayouts.section.NONE' => 'Ninguno',
    'summaryreportlayouts.section.SUMMARY' => 'Resumen',
    'summaryreportlayouts.groupRemove' => 'Eliminar',
    'summaryreportlayouts.buttonRemove' => 'Eliminar',
    'summaryreportlayouts.buttonRemoveHint' => 'Eliminar los diseños seleccionados.',
    'summaryreportlayouts.removeEmptySelection' => 'Seleccione los diseños a eliminar',
    'summaryreportlayouts.removeConfirmation' => '¿Quieres eliminar {count, plural, =1 {el dise ño {name}} one {el dise} other {# diseños}}?',
    'summaryreportlayouts.groupAdd' => 'Añadir',
    'summaryreportlayouts.buttonAdd' => 'Añadir diseño',
    'summaryreportlayouts.buttonAddHint' => 'Añadir un diseño de informe',
    'summaryreportlayouts.autoDeliveryOn' => 'Este informe está programado para su entrega.',
    'summaryreportlayouts.autoDeliveryOff' => 'Este informe no se entrega automáticamente.',
    'summaryreportlayouts.removeSuccess' => 'Se han eliminado los diseños seleccionados.',

    'summaryreportschedules.status' => 'S',
    'summaryreportschedules.on' => 'Activado',
    'summaryreportschedules.off' => 'Desactivado',
    'summaryreportschedules.period' => 'Frecuencia',
    'summaryreportschedules.lastSentDate' => 'Ultimo envío',
    'summaryreportschedules.email' => 'Enviar a',
    'summaryreportschedules.disabled' => 'Desactivado',
    'summaryreportschedules.day' => 'Diariamente',
    'summaryreportschedules.week' => 'Semanalmente',
    'summaryreportschedules.month' => 'Mensualmente',
    'summaryreportschedules.groupAdd' => 'Añadir',
    'summaryreportschedules.buttonAdd' => 'Añadir programación',
    'summaryreportschedules.buttonAddHint' => 'Añadir una programación de entrega',
    'summaryreportschedules.groupRemove' => 'Eliminar',
    'summaryreportschedules.buttonRemove' => 'Eliminar',
    'summaryreportschedules.buttonRemoveHint' => 'Eliminar las programaciones seleccionadas.',
    'summaryreportschedules.removeEmptySelection' => 'Selecciona la programación o programaciones de entrega que quieres eliminar.',
    'summaryreportschedules.removeConfirmation' => '¿Quieres eliminar {count, plural, =1 {la programación de entrega seleccionada} other {las # programaciones de entrega seleccionadas}}?',
    'summaryreportschedules.removeSuccess' => 'Se han eliminado las programaciones de entrega seleccionadas.',

    'traffichistory.year' => 'Año',
    'traffichistory.month' => 'Mes',
    'traffichistory.trafficUsage' => 'Uso de tráfico',
    'traffichistory.noData' => 'Ningún dato de historial disponible.',

    'webappfirewalllogfiles.name' => 'Nombre',
    'webappfirewalllogfiles.modificationDate' => 'Fecha de modificación',
    'webappfirewalllogfiles.fileSize' => 'Tamaño',
    'webappfirewalllogfiles.remove' => 'Eliminar',
    'webappfirewalllogfiles.hintRemove' => 'Elimine los archivos de registro seleccionados. Tenga en cuenta que solo pueden eliminarse archivos de registro procesados.',
    'webappfirewalllogfiles.confirmOnDelete' => '¿Desea eliminar los archivos de registro seleccionados?',
    'webappfirewalllogfiles.viewHint' => 'Haga clic para ver el archivo de registro.',
    'webappfirewalllogfiles.buttonDownloadHint' => 'Haga clic para descargar el archivo de registro.',

    'webmails.name' => 'Nombre',
    'webmails.url' => 'URL',
    'webmails.buttonAddNewWebmail' => 'Registrar webmail',
    'webmails.hintAddNewWebmail' => 'Registre un servicio de webmail adicional en Plesk.',
    'webmails.buttonEnableWebmail' => 'Activar',
    'webmails.hintEnableWebmail' => 'Haga que los servicios de webmail seleccionados estén disponibles para sus clientes.',
    'webmails.buttonDisableWebmail' => 'Desactivar',
    'webmails.hintDisableWebmail' => 'Haga que los servicios de webmail seleccionados no estén disponibles para sus clientes.',
    'webmails.buttonRemoveWebmail' => 'Eliminar',
    'webmails.hintRemoveWebmail' => 'Elimine el registro de los servicios webmail adicionales seleccionados. Tenga en cuenta que aquí no puede eliminar un webmail instalado con Plesk Installer, sino que deberá eliminarlo a través de Herramientas>Actualizaciones.',
    'webmails.confirmOnDelete' => '¿Realmente desea eliminar los registros de webmail seleccionados de Plesk?',
    'webmails.statusSuspended' => 'Webmail no disponible.',
    'webmails.statusOk' => 'Webmail disponible.',
];