<?php
// Copyright 1999-2023. Plesk International GmbH. All rights reserved.
$messages = [
    'anonymous-ftp.description' => 'Dacă site-ul este găzduit la o adresă IP dedicată (nepartajată cu alți utilizatori sau site-uri), puteți configura un director în site, pe care alți utilizatori îl vor putea folosi anonim pentru încărcarea sau descărcarea fișierelor prin FTP. După activarea serviciului de FTP anonim, utilizatorii se vor putea conecta la director la o adresă de tipul ftp://ftp.domeniuldvs.ro folosind numele de utilizator „anonymous” și o parolă oarecare.',
    'anonymous-ftp.displayLogin' => 'Afișare mesaj de conectare',
    'anonymous-ftp.loginText' => 'Textul mesajului',
    'anonymous-ftp.incomingDir' => 'Se permite încărcarea de fișiere în directorul „incoming”',
    'anonymous-ftp.incomingSubDir' => 'Se permite crearea de directoare în directorul „incoming”',
    'anonymous-ftp.incomingReadable' => 'Se permite descărcarea de fișiere din directorul „incoming”',
    'anonymous-ftp.quota' => 'Limitarea spațiului pe disc în directorul „incoming”',
    'anonymous-ftp.maxConnections' => 'Limitarea numărului de conexiuni simultane',
    'anonymous-ftp.bandwidth' => 'Limitarea lățimii de bandă la descărcare pentru acest domeniu FTP virtual',
    'anonymous-ftp.unlimited' => 'Nelimitat',

    'aps.catalog.loading' => 'Se încarcă...',
    'aps.catalog.searchName' => 'Aplicație',
    'aps.catalog.searchVendor' => 'Furnizor',
    'aps.catalog.searchPackager' => 'Utilitar de împachetare',
    'aps.catalog.searchLicenseType' => 'Tip licență',
    'aps.catalog.searchLicenseTypeAny' => 'Oricare',
    'aps.catalog.searchLicenseTypeFreeware' => 'Gratuit',
    'aps.catalog.searchLicenseTypeCommercial' => 'Comercial',
    'aps.catalog.showSearch' => 'Afișare căutare',
    'aps.catalog.hideSearch' => 'Ascundere căutare',
    'aps.catalog.buttonSearch' => 'Căutare',
    'aps.catalog.buttonResetSearch' => 'Resetare căutare',
    'aps.catalog.showCategories' => 'Selectați o categorie de mai jos sau căutați aplicații folosind caseta de căutare',
    'aps.catalog.searchResults' => 'Rezultatele căutării',
    'aps.catalog.buttonInstall' => 'Instalare',
    'aps.catalog.buttonInstallTooltip' => 'Instalarea rapidă a celei mai recente versiuni a aplicației, cu parametrii impliciți optimi.',
    'aps.catalog.buttonAdvancedInstall' => 'Instalare (personalizat)',
    'aps.catalog.buttonAdvancedInstallTooltip' => 'Instalarea celei mai recente versiuni a aplicației, cu personalizarea tuturor parametrilor.',
    'aps.catalog.buttonInstallOldVersion' => 'Instalare versiune',
    'aps.catalog.buttonInstallOldVersionTooltip' => 'Instalarea versiunii selectate a aplicației, cu personalizarea tuturor parametrilor.',
    'aps.catalog.buttonInstallDescription' => 'Instalați aplicația pe un site dacă aveți un cod de activare sau dacă doriți să o încercați.',
    'aps.catalog.buttonInstallDescriptionFree' => 'Instalarea acestei aplicații gratuite pe site.',
    'aps.catalog.version' => 'Versiune',
    'aps.catalog.moreVersions' => 'Mai multe versiuni',
    'aps.catalog.release' => 'Nr. de lansare',
    'aps.catalog.overview' => 'Prezentare generală',
    'aps.catalog.noApplicationsInCategory' => 'În această categorie nu este disponibilă nicio aplicație. Selectați o altă categorie.',
    'aps.catalog.noCategoriesSelected' => 'Selectați o categorie pentru a vedea toate aplicațiile disponibile în aceasta.',
    'aps.catalog.noSearchResults' => 'Căutarea nu a identificat nicio aplicație.',
    'aps.catalog.connectionFailed' => 'Conectarea la catalogul de aplicații nu a reușit. %%retryLink%%.',
    'aps.catalog.retry' => 'Reîncercare',
    'aps.catalog.categoriesError' => 'În acest moment nu se poate încărca lista categoriilor.',
    'aps.catalog.applicationsError' => 'În acest moment nu se poate încărca lista aplicațiilor.',
    'aps.catalog.detailsError' => 'În acest moment nu se pot încărca detaliile despre aplicație.',
    'aps.catalog.searchError' => 'În acest moment nu se pot încărca rezultatele căutării.',
    'aps.catalog.changelogEntry' => 'v%%version%% (nr. de lansare %%release%%) - %%description%%',
    'aps.catalog.changelog' => 'Istoricul modificărilor',
    'aps.catalog.officialApplicationSite' => 'Informații despre furnizor',
    'aps.catalog.returnToCategories' => '<< Înapoi la lista de aplicații',
    'aps.catalog.buttonUninstall' => 'Ștergere',
    'aps.catalog.gotoHome' => 'Pagina de pornire',
    'aps.catalog.all' => 'Toate',
    'aps.catalog.buttonDetails' => 'Informații suplimentare',
    'aps.catalog.buttonBuy' => 'Cumpărare imediată',
    'aps.catalog.buttonBuyTooltip' => 'Cumpărarea aplicației',
    'aps.catalog.buttonBuyDescription' => 'Vizitați magazinul nostru și cumpărați un cod de activare pentru aplicație.',
    'aps.catalog.buttonDownload' => 'Descărcare',
    'aps.catalog.buttonDownloadDescription' => 'Descărcați aplicația dacă aveți un cod de activare sau dacă doriți să o încercați.',
    'aps.catalog.marketplaceMoreInfo' => 'Pentru informații suplimentare, vizitați %%link%%.',
    'aps.catalog.marketplaceMoreInfoLink' => 'site-ul distribuitorului aplicației',

    'aps.configure.installedAt' => "Instalată în",
    'aps.configure.otherSettings' => "Altele",
    'aps.configure.globalSettings' => 'Setări de împachetare',
    'aps.configure.passwordConfirmation' => 'Confirmare parolă',
    'aps.configure.databaseParams' => 'Parametri de bază de date',
    'aps.configure.noInstallationUrlAvailable' => 'Fără (aplicație externă)',
    'aps.configure.updateSettingsSection' => 'Setări de actualizare',
    'aps.configure.forceUpdates' => 'Dacă apar actualizări ale acestei aplicații, se vor instala automat',
    'aps.configure.forceUpdatesHint' => 'Aplicația va fi actualizată automat la cele mai noi versiuni. Avertisment: Aveți grijă dacă utilizați această opțiune, pentru că actualizările pot afecta semnificativ funcționarea aplicației. De exemplu, extensiile de aplicație pot înceta să funcționeze în momentul trecerii la o nouă versiune a aplicației.',

    'aps.install.showAllSettings' => 'Afișarea tuturor setărilor',
    'aps.install.showLessSettings' => 'Afișare configurației minime de setări',
    'aps.install.install' => 'Instalare',
    'aps.install.otherSettings' => 'Alte setări',
    'aps.install.globalSettings' => 'Setări de împachetare',
    'aps.install.passwordConfirmation' => 'Confirmare parolă',
    'aps.install.provisionsSectionLabel' => 'Cale de instalare',
    'aps.install.context' => 'Specificați locația în care trebuie instalată această aplicație web',
    'aps.install.registerAsWebmailSection' => 'Înregistrare e-mail prin web',
    'aps.install.registerAsWebmailDescription' => "Selectați această opțiune dată aplicația este un client de e-mail prin web. Datorită acestei selecții, aplicația va apărea alături de celelalte servicii de e-mail prin web în setările de E-mail ale abonamentelor și ale planurilor de servicii. Administratorul poate configura URL-ul de acces public al serviciului de e-mail prin web: Administrarea serverului> Setări> E-mail prin web.",
    'aps.install.registerAsWebmailLabel' => 'Înregistrare ca serviciu de e-mail prin web',
    'aps.install.addItem' => 'Adăugare',
    'aps.install.removeItem' => 'Ștergere',
    'aps.install.updateSettingsSection' => 'Setări de actualizare',
    'aps.install.forceUpdates' => 'Dacă apar actualizări ale acestei aplicații, se vor instala automat',
    'aps.install.forceUpdatesHint' => 'Aplicația va fi actualizată automat la cele mai noi versiuni. Avertisment: Aveți grijă dacă utilizați această opțiune, pentru că actualizările pot afecta semnificativ funcționarea aplicației. De exemplu, extensiile de aplicație pot înceta să funcționeze în momentul trecerii la o nouă versiune a aplicației.',

    'aps.invalid-requirements.requirementsLegend' => 'Cerințe',
    'aps.invalid-requirements.domainLegend' => 'Site web',
    'aps.invalid-requirements.context' => 'Alegerea unui alt site web',
    'aps.invalid-requirements.backToApplicationList' => 'Înapoi la lista de aplicații',

    'aps.license.title' => 'Instalarea %%packageName%%',
    'aps.license.doYouAcceptLicense' => 'Pentru a instala această aplicație, trebuie să citiți acordul de licență cu utilizatorul final și să-i acceptați termenii.',
    'aps.license.licenseAgree' => 'Accept termenii acestui acord de licență',

    'aps.services-list-customization.settings' => 'Setări',

    'asp-dot-net.change-version.frameworkVersion' => 'Versiune de framework ASP.NET',

    'asp-dot-net.settings.casSettingsSection' => "Securitatea accesului la resurse prin cod",
    'asp-dot-net.settings.clientScriptsSection' => "Setările bibliotecii de scripturi",
    'asp-dot-net.settings.connStringsSection' => "Manager șir de conectare",
    'asp-dot-net.settings.customErrorsSection' => "Setări de erori personalizate",
    'asp-dot-net.settings.frameworkVersionSection' => "Versiune framework",
    'asp-dot-net.settings.globalizationSection' => "Setări de globalizare",
    'asp-dot-net.settings.otherSection' => "Setări de sesiune",
    'asp-dot-net.settings.pageAndRuntimeSection' => "Compilare și depanare",
    'asp-dot-net.settings.authMode' => "Mod autentificare",
    'asp-dot-net.settings.connStrings' => "Șiruri de conectare",
    'asp-dot-net.settings.connStringsInvalid' => "Unele câmpuri sunt necompletate sau conțin o valoare necorespunzătoare.",
    'asp-dot-net.settings.connStringName' => "Nume",
    'asp-dot-net.settings.connStringValue' => "Parametri de conectare",
    'asp-dot-net.settings.connStringsDescription' => "Nume/parametri de conectare",
    'asp-dot-net.settings.culture' => "Setări de limbă și regionale",
    'asp-dot-net.settings.customErrMode' => "Mod erori personalizate",
    'asp-dot-net.settings.customErrorRedirect' => "URL de redirecționare",
    'asp-dot-net.settings.customErrorStatus' => "Cod de stare",
    'asp-dot-net.settings.customErrorStatusInvalid' => "Codul de stare trebuie să fie un număr întreg.",
    'asp-dot-net.settings.customErrors' => "Erori personalizate",
    'asp-dot-net.settings.customErrorsDescription' => "Cod de stare/URL de redirecționare",
    'asp-dot-net.settings.customErrorsInvalid' => "Unele câmpuri sunt necompletate sau conțin o valoare necorespunzătoare.",
    'asp-dot-net.settings.debugMode' => "Pornire depanare",
    'asp-dot-net.settings.defLanguage' => "Limba implicită a paginilor web",
    'asp-dot-net.settings.tempDirectory' => "Director temporar",
    'asp-dot-net.settings.fileEnc' => "Codificare fișier",
    'asp-dot-net.settings.fileEncInvalid' => "Valoarea specificată a parametrului Codificare fișier este incorectă.",
    'asp-dot-net.settings.pathToLib' => "Calea către biblioteca de scripturi Microsoft",
    'asp-dot-net.settings.pathToLibInstall' => "Instalare",
    'asp-dot-net.settings.reqEnc' => "Codificare solicitare",
    'asp-dot-net.settings.reqEncInvalid' => "Valoarea specificată a parametrului Codificare solicitare este incorectă.",
    'asp-dot-net.settings.resEnc' => "Codificare răspuns",
    'asp-dot-net.settings.resEncInvalid' => "Valoarea specificată a parametrului Codificare răspuns este incorectă.",
    'asp-dot-net.settings.sessTimeout' => "Expirare sesiune (minute)",
    'asp-dot-net.settings.sessTimeoutInvalid' => "Valoarea specificată a parametrului Expirare sesiune este incorectă. Introduceți un număr întreg pozitiv, mai mic decât sau egal cu %%max%%.",
    'asp-dot-net.settings.connStringDuplicate' => "Numele șirului de conectare este în uz.",
    'asp-dot-net.settings.customErrorInvalidCode' => "Codul de stare trebuie să fie cuprins între 100 și 999",
    'asp-dot-net.settings.customErrorDuplicate' => "Codul de stare este în uz.",
    'asp-dot-net.settings.trustLevel' => "Nivel de încredere CAS",
    'asp-dot-net.settings.uiCulture' => "Setări de limbă și regionale pentru interfață",
    'asp-dot-net.settings.version' => "Versiune",
    'asp-dot-net.settings.trustLevelAllowOverride' => 'Se permite ignorarea nivelului de încredere CAS pe site',
    'asp-dot-net.settings.addConnStrings' => 'Adăugare șir de conectare',
    'asp-dot-net.settings.addCustomErrors' => 'Adăugare eroare personalizată',
    'asp-dot-net.settings.buttonRemove' => 'Ștergere',
    'asp-dot-net.settings.updateSuccess' => 'Actualizarea s-a terminat cu succes',

    'database.clone.formDescription' => 'Copierea conținutului bazei de date într-una două sau existentă. În cazul copierii într-o bază de date existentă, tabelele din baza de date sursă sunt adăugate la lista de tabele din baza destinație. Avertisment: dacă numele de tabele coincid, tabelul din sursă îl va înlocui pe cel din destinație.',
    'database.clone.copyData' => 'Se creează o copie completă',
    'database.clone.copyDataHint' => 'Dacă selectați această opțiune, se va copia întreaga bază de date (inclusiv structura și datele). Dacă nu selectați opțiunea, se copiază doar structura tabelelor.',
    'database.clone.server' => 'Server de baze de date destinație',
    'database.clone.versionCut' => 'v%%version%%',
    'database.clone.externalServer' => 'Altul...',
    'database.clone.database' => 'Baza de date destinație',
    'database.clone.newDatabase' => 'Se creează o bază de date cu numele',
    'database.clone.existingDatabase' => 'Copierea se face într-o bază de date existentă',
    'database.clone.externalDbHost' => 'Denumire gazdă sau adresă IP',
    'database.clone.externalDbLogin' => 'Nume utilizator',
    'database.clone.externalDbPassword' => 'Parolă',
    'database.clone.subscription' => 'Abonament destinație',
    'database.clone.subscription_powerUser' => 'Spațiu web destinație',
    'database.clone.cloneInProgress' => 'Clonarea bazei de date %%source%% în baza de date %%destination%%. Veți primi prin e-mail notificări privind desfășurarea procesului (%%email%%).',
    'database.clone.unableToClone' => 'Imposibil de copiat baza de date: „%%source%%”.',
    'database.clone.unableToCreateExternalDatabase' => 'Imposibil de creat o bază de date „%%destination%%” pe serverul specificat.',
    'database.clone.databaseCloned' => 'Baza de date „%%source%%” a fost copiată.',
    'database.clone.emailSubjSuccess' => 'Baza de date „%%sourceDatabase%%” a fost copiată.',
    'database.clone.emailSubjFailure' => 'Copierea bazei de date „%%sourceDatabase%%” nu a reușit.',
    'database.clone.emailBodySuccess' => 'Baza de date „%%sourceDatabase%%” (%%sourceHost%%) a fost copiată în baza de date „%%destDatabase%%” (%%destHost%%).',
    'database.clone.emailBodyFailure' => 'Imposibil de copiat baza de date „%%sourceDatabase%%” (%%sourceHost%%) în baza de date „%%destDatabase%%” (%%destHost%%). Procedura de copiere nu a reușit.',
    'database.clone.localServer' => 'server local',

    'database.repair-orphaned.formDescription' => 'După procesul de restaurare acest utilizator va trece în starea de orfan. Introduceți o parolă pentru acest utilizator, în vederea rezolvării problemei. Dacă acest utilizator trebuie să fie unul de sistem (sys) fără parolă, executați utilitarul de reparare cu câmpul de parolă necompletat.',
    'database.repair-orphaned.login' => 'Nume utilizator bază de date',
    'database.repair-orphaned.pass' => 'Parolă',
    'database.repair-orphaned.pass2' => 'Confirmare parolă',
    'database.repair-orphaned.users' => 'La unii utilizatori este nevoie de intervenție. Există mai mulți utilizatori trecuți în stare de orfan, care trebuie reparați pentru a putea funcționa corect.',
    'database.repair-orphaned.orphaned' => 'Utilizatorul a trecut în starea de organ. %%gui begin:link%%Reparare imediată%%gui end:link%%.',
    'database.repair-orphaned.repair' => 'Reparare',

    'database.repair.fixSelected' => 'Repararea utilizatorilor selectați',
    'database.repair.fix' => 'Reparare',

    'database.user.password' => 'Parolă',
    'database.user.passwordConfirmation' => 'Confirmare parolă',
    'database.user.server' => 'Server de baze de date',
    'database.user.versionCut' => 'v%%version%%',
    'database.user.database' => 'Bază de date',
    'database.user.anyDatabase' => 'Oricare',
    'database.user.dataAccess' => 'Acces la date',
    'database.user.structureAccess' => 'Acces la structură',
    'database.user.globalAccess' => 'Privilegii globale',
    'database.user.globalAccessHint' => 'Privilegiile globale sunt valabile pentru toate bazele de date din acest cont de găzduire.',
    'database.user.aclRadio' => 'Controlul accesului',
    'database.user.aclLocalhost' => 'Nu se acceptă decât conexiuni locale',
    'database.user.aclAny' => 'Se acceptă conexiunile la distanță de la orice gazdă',
    'database.user.aclCustom' => 'Se acceptă conexiunile la distanță de la',
    'database.user.aclExample' => "thomas.loc.gov %.loc.gov x.y.% 144.155.166.177 144.155.166.% 144.155.166.0/255.255.255.0 Gazdele specificate pot accesa baza de date în numele acestui utilizator.",
    'database.user.remoteAccess' => 'Acces la distanță',
    'database.user.remoteAccessExample' => "10.1.0.0/16 192.168.1.110 Baza de date se poate accesa de la adresele IP specificate, în numele acestui utilizator. Modificările făcute în această listă vor suferi o moderare preliminară din partea furnizorului de servicii de găzduire.",
    'database.user.example' => "De exemplu: %%example%%",
    'database.user.denied' => 'Se utilizează regulile din firewallul de sistem',
    'database.user.allowed' => 'Se acceptă conexiunile la distanță de la',
    'database.user.default' => 'În mod implicit %%webadmin%% se va accesa cu acreditările acestui utilizator',
    'database.user.remoteAccessHint' => 'Contactați furnizorul de servicii de găzduire și asigurați-vă că opțiunea pe care ați specificat-o mai sus va fi compatibilă cu actualele reguli de firewall, legate de accesul la MySQL.',
    'database.user.phpMyAdmin' => 'phpMyAdmin',
    'database.user.webAdmin' => 'Administrator web',
    'database.user.role' => 'Rol',
    'database.user.roleReadWrite' => 'Citire și scriere',
    'database.user.roleWriteOnly' => 'Doar scriere',
    'database.user.roleReadOnly' => 'Doar citire',
    'database.user.roleCustom' => 'Personalizat',

    'database.generalSection' => 'General',
    'database.name' => 'Nume bază de date',
    'database.server' => 'Server de baze de date',
    'database.versionCut' => 'v%%version%%',
    'database.relatedDomain' => 'Site care utilizează baza de date',
    'database.noDomainRelations' => 'Niciun site nu utilizează baza de date',
    'database.userSection' => 'Utilizatori',
    'database.userSectionDescription' => 'Crearea utilizatorului de baze de date implicit. Plesk va accesa baza de date în numele acestui utilizator. Dacă bazei de bate nu i se atribuie și utilizatori de bază de date, aceasta nu va fi accesibilă.',
    'database.createUser' => 'Se creează un utilizator de baze de date',
    'database.username' => 'Nume utilizator bază de date',
    'database.password' => 'Parolă',
    'database.passwordConfirmation' => 'Confirmare parolă',
    'database.allDbAccess' => 'Utilizatorul are acces la toate bazele de date în cadrul abonamentului selectat',
    'database.aclRadio' => 'Controlul accesului',
    'database.aclLocalhost' => 'Nu se acceptă decât conexiuni locale',
    'database.aclAny' => 'Se acceptă conexiunile la distanță de la orice gazdă',
    'database.aclCustom' => 'Se acceptă conexiunile la distanță de la',
    'database.aclExample' => "thomas.loc.gov %.loc.gov x.y.% 144.155.166.177 144.155.166.% 144.155.166.0/255.255.255.0 Gazdele specificate pot accesa baza de date în numele acestui utilizator.",
    'database.remoteAccess' => 'Acces la distanță',
    'database.remoteAccessExample' => "10.1.0.0/16 192.168.1.110 Baza de date se poate accesa de la adresele IP specificate, în numele acestui utilizator. Modificările făcute în această listă vor suferi o moderare preliminară din partea furnizorului de servicii de găzduire.",
    'database.example' => "De exemplu: %%example%%",
    'database.denied' => 'Se utilizează regulile din firewallul de sistem',
    'database.allowed' => 'Se acceptă conexiunile la distanță de la',

    'deployment-section.deploymentDisabledHint' => 'Încărcare fișiere dintr-un depozit Git',
    'deployment-section.deploymentEnabledHint' => 'Activare integrare cu Git',
    'deployment-section.deploymentSectionLegend' => 'Fișiere de copiat în serviciul de găzduire',
    'deployment-section.deploymentSectionDescriptionHint' => 'Dacă lăsați suportul Git dezactivat, directoarele rădăcină (de site web, de aplicație și de document) vor fi create goale, iar site-ul va afișa pagina implicită în browser. Va trebui să încărcați fișierele site-ului în directorul rădăcină de documente folosind un program de FTP sau Managerul de fișiere. De asemenea, puteți activa Git imediat sau ulterior (în Site-uri web și domenii) și puteți încărca fișierele dintr-un depozit Git.',

    'dns-zone.add-acl-record.description' => 'Adăugarea adresei IP a unui server DNS autorizat să primească o copie a zonei DNS.',
    'dns-zone.add-acl-record.ipAddress' => 'Adresă IP',
    'dns-zone.add-acl-record.ipAddressWithMask' => 'Adresă IP/mască',

    'dns-zone.record.add-title' => "Adăugare înregistrare de resursă la șablonul de zonă",
    'dns-zone.record.add-ns-title' => "Adăugare server de nume",
    'dns-zone.record.edit-title' => "Editare înregistrare resursă",
    'dns-zone.record.edit-success' => "Înregistrarea DNS a fost actualizată.",
    'dns-zone.record.add-success' => "Înregistrarea DNS a fost creată.",
    'dns-zone.record.type' => "Tip înregistrare",
    'dns-zone.record.domainName' => "Nume domeniu",
    'dns-zone.record.domainNamePostfix' => ".<domain>",
    'dns-zone.record.nameServer' => "Server de nume",
    'dns-zone.record.protocol' => "Protocol",
    'dns-zone.record.priority' => "Nivel de prioritate",
    'dns-zone.record.priorityLow' => "scăzută (%%priority%%)",
    'dns-zone.record.priorityHigh' => "foarte ridicată (%%priority%%)",
    'dns-zone.record.weightLow' => "scăzută (%%weight%%)",
    'dns-zone.record.weightHigh' => "foarte ridicată (%%weight%%)",
    'dns-zone.record.ipAddress' => "Adresă IP",
    'dns-zone.record.ipAddressDescription' => "De exemplu, 123.123.123.123",
    'dns-zone.record.ipAddressDescriptionExt' => "De exemplu, <ip>, 123.123.123.123",
    'dns-zone.record.ipAddressV6' => "Adresă IPv6",
    'dns-zone.record.ipAddressV6Description' => "De exemplu, 2002:7b7b:7b7b::1",
    'dns-zone.record.ipAddressV6DescriptionExt' => "De exemplu, <ipv6>, 2002:7b7b:7b7b::1",
    'dns-zone.record.ipAddressWithMaskDescription' => "De exemplu, 2002:7b7b:7b7b::1/48, 123.123.123.123/16",
    'dns-zone.record.ipAddressWithMaskDescriptionExt' => "De exemplu, <ipv6>, <ip>, 2002:7b7b:7b7b::1/48, 123.123.123.123/16",
    'dns-zone.record.masterIpAddressDescription' => "De exemplu, 2002:7b7b:7b7b::1, 123.123.123.123",
    'dns-zone.record.canonicalName' => "Nume canonic",
    'dns-zone.record.mailDomain' => "Domeniu de e-mail",
    'dns-zone.record.mxServer' => "Server de schimb de e-mailuri",
    'dns-zone.record.mxServerPriority' => "Specificați prioritatea serverului de schimb de e-mailuri",
    'dns-zone.record.txtRecord' => "Înregistrare TXT",
    'dns-zone.record.txtRecordString' => "Introduceți șirul de înregistrare",
    'dns-zone.record.txtSpfSyntax' => "Înregistrare SPF",
    'dns-zone.record.txtRecordDescription' => "",
    'dns-zone.record.invalidTxtRecord' => "Valorile specificate pentru înregistrarea TXT sunt incorecte.",
    'dns-zone.record.dsRecord' => "Înregistrare DS",
    'dns-zone.record.dsRecordDescription' => "De exemplu, 60485 5 1 2BB183AF5F22588179A53B0A98631FAD1A292118",
    'dns-zone.record.invalidDsRecord' => "S-a specificat o valoare incorectă pentru înregistrarea DS.",
    'dns-zone.record.serviceName' => "Nume serviciu",
    'dns-zone.record.serviceNameDescription' => "Exemplu: SIP (fără caracter de subliniere)",
    'dns-zone.record.protocolNameDescription' => "Exemplu: TCP (fără caracter de subliniere)",
    'dns-zone.record.srvWeight' => "Ponderea relativă a înregistrărilor cu aceeași prioritate",
    'dns-zone.record.targetHost' => "Gazda de destinație",
    'dns-zone.record.targetHostDescription' => "Exemplu: exemplu.com",
    'dns-zone.record.targetPort' => "Port de destinație",
    'dns-zone.record.retrieveDataError' => "Datele înregistrării nu au fost găsite.",
    'dns-zone.record.unknownTypeError' => "Tip de înregistrare DNS necunoscut.",
    'dns-zone.record.nullMxRecordMustBeTheOnly' => 'Dacă există altă înregistrare MX, nu se poate configura cea non-NULL.',
    'dns-zone.record.cannotHaveMxNullRecordAndMxRecord' => 'Dacă există înregistrarea MX NULL, nu se poate configura cea non-NULL.',
    'dns-zone.record.masterShouldBeRemote' => "Trebuie să aveți două servere de nume autorizate pe gazde diferite.",
    'dns-zone.record.caaTag' => "Etichetă",
    'dns-zone.record.caaRecord' => "Valoare",
    'dns-zone.record.caaRecordDescription' => "",
    'dns-zone.record.ttl' => "TTL",
    'dns-zone.record.ttl-seconds' => "Secunde",
    'dns-zone.record.invalidValue' => 'Valoarea este incorectă. Trebuie să fie cuprinsă între 1 secundă și 2147483647 de secunde.',
    'dns-zone.record.ttlDefaultValue' => 'Valoare implicită: %%value%% secunde',
    'dns-zone.record.invalidTTL' => 'Valoarea TTL specificată este incorectă.',
    'dns-zone.record.invalidIpAddress' => 'Adresa IP specificată este incorectă.',
    'dns-zone.record.invalidIpMaskPair' => 'Perechea adresă IP/mască specificată este incorectă.',
    'dns-zone.record.invalidCName' => 'Numele canonic specificat este incorect.',
    'dns-zone.record.invalidSRVPort' => 'Portul specificat este incorect.',

    'dns-zone.restore-default.formHint' => "Aici puteți restaura configurația de zonă originală, conform setărilor din șablonul DNS implicit utilizat pe server. Selectați adresele IP care se vor utiliza la restaurarea zonei și specificați dacă prefixul www este obligatoriu pentru domeniu.",
    'dns-zone.restore-default.ipv4' => "Adresă IPv4",
    'dns-zone.restore-default.ipv4Hint' => "De exemplu, 123.123.123.123",
    'dns-zone.restore-default.ipv6' => "Adresă IPv6",
    'dns-zone.restore-default.ipv6Hint' => "De exemplu, 2002:7b7b:7b7b::1",
    'dns-zone.restore-default.invalidIpAddress' => 'Adresa IP specificată este incorectă.',
    'dns-zone.restore-default.customIpHint' => "Înregistrările cu această adresă IP vor fi considerate modificate de către utilizator și nu vor fi sincronizate cu șablonul DNS la nivel de server.",
    'dns-zone.restore-default.wwwPrefix' => "prefix www",
    'dns-zone.restore-default.previewRecords' => "Restaurați înregistrările utilizate pentru previzualizarea site-ului",

    'dns-zone.soa-record.soaMnameSection' => 'Server de nume principal',
    'dns-zone.soa-record.soaMname' => 'Server de nume',
    'dns-zone.soa-record.soaMnameAutoselect' => '(Selectare automată)',
    'dns-zone.soa-record.soaRecordSection' => 'Înregistrare SOA',
    'dns-zone.soa-record.ttl' => 'TTL',
    'dns-zone.soa-record.refresh' => 'Reîmprospătare',
    'dns-zone.soa-record.retry' => 'Reîncercare',
    'dns-zone.soa-record.expire' => 'Expirare',
    'dns-zone.soa-record.minimum' => 'Minimum',
    'dns-zone.soa-record.rnameType' => 'E-mail (RNAME)',
    'dns-zone.soa-record.rnameTypeHint' => 'Adresa de e-mail a persoanei responsabile pentru zona DNS a domeniului. Returnat de serverul DNS ca răspuns la interogările SOA.',
    'dns-zone.soa-record.rnameTypeOwner' => 'Adresa de e-mail a proprietarului site-ului',
    'dns-zone.soa-record.rnameTypeDomain' => 'Adresa de e-mail a domeniului',
    'dns-zone.soa-record.rnameTypeDomainHint' => 'Introduceți doar partea locală (înainte de @<domain>)',
    'dns-zone.soa-record.rnameTypeExternal' => 'Adresă de e-mail externă',
    'dns-zone.soa-record.rnameEnforceEmail' => 'Interzicerea modificării adresei de e-mail RNAME la nivel de domeniu',
    'dns-zone.soa-record.invalidValue' => 'Valoarea este incorectă. Trebuie să fie cuprinsă între 1 secundă și 68 de ani.',
    'dns-zone.soa-record.advancedSection' => 'Funcții DNS avansate',
    'dns-zone.soa-record.serialNumberFormat' => 'Se utilizează formatul de număr de serie recomandat de IETF și de RIPE',
    'dns-zone.soa-record.serialNumberFormatHint' => 'Selectați opțiunea dacă domeniul are probleme la verificarea SOA a instituției de înregistrare. Multe instituție impun acest forma de număr de serie.',
    'dns-zone.soa-record.restoreDefaultButton' => 'Se utilizează setările implicite',
    'dns-zone.soa-record.zoneDefaultsSection' => 'Valori implicite zone',
    'dns-zone.soa-record.unitSeconds' => 'secunde',
    'dns-zone.soa-record.unitMinutes' => 'minute',
    'dns-zone.soa-record.unitHours' => 'ore',
    'dns-zone.soa-record.unitDays' => 'zile',
    'dns-zone.soa-record.unitWeeks' => 'săptămâni',
    'dns-zone.soa-record.refreshValueIsSmallWarning' => 'Intervalul de reîmprospătare este sub o oră, ceea ce poate duce la o creștere critică a traficului serverului și a utilizării resurselor.',
    'dns-zone.soa-record.minimumValueIsBigWarning' => 'Setarea unei valori TTL minime de peste 3 ore poate împiedica accesul la domeniu al anumitor administratori de domeniu. Se recomandă să setați o asemenea valoare numai dacă instituția de înregistrare insistă asupra acestui lucru.',
    'dns-zone.soa-record.success' => 'Proprietățile înregistrării SOA au fost actualizate.',
    'dns-zone.soa-record.restoreDefaultSuccess' => 'Înregistrarea SOA implicită a fost restabilită.',

    'domain-info-section.domainName' => 'Nume domeniu',
    'domain-info-section.emptyDomainName' => 'Introduceți un nume de domeniu.',
    'domain-info-section.ipAddress' => 'Adresă IP',
    'domain-info-section.shared' => 'partajată',
    'domain-info-section.exclusive' => 'dedicată',
    'domain-info-section.ipAddressHint' => "Adresa IP la care se găzduiește site-ul este o adresă de rețea a gazdei virtuale a site-ului. Această adresă IP va fi utilizată pentru toate site-urile web create în baza abonamentului.",
    'domain-info-section.ipAddressHint_powerUser' => "Adresa IP la care se găzduiește site-ul este o adresă de rețea a gazdei virtuale a site-ului. Această adresă IP va fi utilizată pentru toate site-urile web create în spațiul web.",
    'domain-info-section.userName' => 'Nume utilizator',
    'domain-info-section.userNameHint' => 'Contul de utilizator de sistem asociat spațiului web este utilizat pentru accesarea prin FTP și SSH a fișierelor găzduite.',
    'domain-info-section.emptyLogin' => 'Introduceți un nume de utilizator.',
    'domain-info-section.password' => 'Parolă',
    'domain-info-section.emptyPassword' => 'Introduceți parola.',
    'domain-info-section.passwordConfirmation' => 'Repetați parola',

    'email-address.generalTab' => 'General',
    'email-address.generalHint' => 'În cazul în care contul de e-mail este asociat unui utilizator suplimentar (accesul la Panoul de client este activat), modificările pe care le faceți în această pagină vor afecta setările utilizatorului respectiv. Concret, dacă modificați adresa de e-mail și parola, și numele de conectare și parola utilizatorului suplimentar vor fi modificate cu noile valori.',
    'email-address.redirectTab' => 'Redirecționare',
    'email-address.redirectHint' => 'Configurați redirecționarea mesajelor de e-mail la una sau mai multe adrese.',
    'email-address.aliasesTab' => 'Aliasuri de e-mail',
    'email-address.autoResponderTab' => 'Răspuns automat',
    'email-address.antispamTab' => 'Filtru antispam',
    'email-address.autoResponderHint' => 'Configurarea unui răspuns automat la orice mesaj de e-mail care intră în căsuța poștală. Răspunsul automat este o modalitate standard prin care puteți anunța persoanele cu care corespondați că nu sunteți la birou sau ați plecat în concediu.',
    'email-address.antivirusTab' => 'Antivirus',
    'email-address.name' => 'Adresă e-mail',
    'email-address.externalEmail' => 'Adresă de e-mail externă',
    'email-address.externalEmailHint' => 'Se va utiliza pentru resetarea parolei în cazul în care nu mai puteți accesa adresa de e-mail principală.',
    'email-address.user' => 'Atribuit utilizatorilor',
    'email-address.password' => 'Parolă',
    'email-address.passwordConfirmation' => 'Confirmare parolă',
    'email-address.responderEnable' => 'Se activează răspunsul automat',
    'email-address.responderSubject' => 'Subiectul răspunsului automat',
    'email-address.responderContentType' => 'Formatul mesajelor',
    'email-address.responderContentTypeHint' => 'Formatul text simplu este acceptat de toate programele client de e-mail. Drept urmare, toți destinatarii vor vedea mesajul așa cum îl vedeți și dvs. Mesajele HTML arată mai bine, pentru că permit formatarea textului cu diferite stiluri de fonturi. În schimb, unele programe client de e-mail nu acceptă mesajele HTML și este posibil ca unii destinatari să nu vadă textul formatat.',
    'email-address.responderContentTypeTextPlain' => 'Text simplu',
    'email-address.responderContentTypeTextHtml' => 'HTML',
    'email-address.responderCodepage' => 'Codificare',
    'email-address.responderCodepageHint' => 'Codificarea definește maniera de afișare a caracterelor din text. Codificarea recomandată este UTF-8.',
    'email-address.responderReplyTo' => 'Redirecționare către',
    'email-address.responderReplyToHint' => 'După trimiterea răspunsului automat, mesajul original se redirecționează către adresa de e-mail specificată.',
    'email-address.responderForwardAddress' => 'Redirecționare către',
    'email-address.responderForwardAddressHint' => 'După trimiterea răspunsului automat, mesajul original se redirecționează către adresa de e-mail specificată.',
    'email-address.responderMessage' => 'Textul răspunsului automat',
    'email-address.responderReplyToEqualsEmail' => 'Adresa de e-mail specificată pentru redirecționare este identică cu această adresă.',
    'email-address.responderForwardAddressEqualsEmail' => 'Adresa de e-mail specificată pentru redirecționare este identică cu această adresă.',
    'email-address.responderReplyLimit' => 'Răspunsul automat se trimite la o adresă de e-mail unică de cel mult (... ori pe zi)',
    'email-address.buttonAddResponderAttachment' => 'Adăugare atașare',
    'email-address.buttonRemoveResponderAttachment' => 'Ștergere',
    'email-address.responderAttachment' => 'Atașarea unui fișier',
    'email-address.redirectEnable' => 'Se activează redirecționarea de e-mail',
    'email-address.redirectRemoveEnable' => 'Copiile mesajelor de e-mail redirecționate nu se salvează în căsuța poștală Plesk',
    'email-address.redirectAddress' => 'Mesajele primite se redirecționează către adresa',
    'email-address.redirectAddressHint' => 'Specificați adresele de e-mail. Puteți să tastați fiecare adresă pe un rând separat sau să separați adresele cu caractere spațiu, virgule sau caractere punct și virgulă.',
    'email-address.role' => 'Rolul utilizatorului',
    'email-address.roleHint' => 'Rolurile le acordă utilizatorilor privilegii administrative și acces la aplicațiile pe care le-ați selectat pentru rol.',
    'email-address.errorRedirectAddress' => 'Ați specificat o adresă de e-mail incorectă: %value%.',
    'email-address.errorRedirectAddressMultiple' => 'Ați specificat adrese de e-mail incorecte: %value%.',
    'email-address.mailAlias' => "Alias de e-mail",
    'email-address.mailAliasNone' => 'Niciunul',
    'email-address.mailAliasHint' => "Aliasurile de e-mail sunt adrese alternative asociate unei adrese de e-mail principale. Toate mesajele trimise la aliasuri vor fi recepționate de adresa principală.",
    'email-address.buttonAddMailAlias' => 'Adăugare alias de e-mail',
    'email-address.buttonRemoveMailAlias' => 'Ștergere',
    'email-address.emptyEmail' => 'Specificarea adresei de e-mail către care se vor redirecționa toate mesajele primite.',
    'email-address.emailsIsEqual' => 'Adresa de e-mail externă este identică cu cea principală. Specificați o altă adresă de e-mail externă.',
    'email-address.emptyPassword' => 'Trebuie să introduceți o parolă.',
    'email-address.emptyPasswordConfirmation' => 'Trebuie să confirmați parola.',
    'email-address.emptyAlias' => "Specificarea unui alias de e-mail pentru această adresă.",
    'email-address.aliasEqualsEmail' => 'Aliasul de e-mail specificat este identic cu adresa de e-mail.',
    'email-address.passwordHint' => 'Se va utiliza pentru accesarea căsuței poștale și pentru conectarea la Plesk (dacă opțiunea corespunzătoare este activată).',
    'email-address.cyclicRedirect' => 'Nu se poate configura redirecționarea mesajelor de e-mail de la o adresă de e-mail la aceeași adresă.',
    'email-address.errorMailnameReserved' => 'Adresa de e-mail specificată este deja în uz.',
    'email-address.antivirusEnable' => 'Se activează protecția antivirus pentru această adresă de e-mail',
    'email-address.antivirusHint' => 'Serviciul antivirus blochează mesajele de e-mail care conțin viruși și anunță atât expeditorul, cât și destinatarul.',
    'email-address.antivirusSettings' => 'Verificarea antivirus se face',
    'email-address.antivirusSettingOnlyIncomingMail' => 'numai pentru mesajele primite',
    'email-address.antivirusSettingOnlyOutgoingMail' => 'numai pentru mesajele trimise',
    'email-address.antivirusSettingOnlyIncomingAndOutgoingMail' => 'pentru mesajele primite și trimise',
    'email-address.antispamHint' => 'Serviciul de filtrare antispam detectează mesajele spam trimise la o adresă de e-mail. Puteți seta filtrul antispam să șteargă mesajele nedorite, să le marcheze drept spam prin modificarea subiectului sau să le mute în folderul special de spam, accesibil prin programe client de e-mail, prin IMAP. Filtrele antispam utilizează o varietate de teste locale și în rețea pentru a identifica semnăturile de spam.',
    'email-address.antispamEnable' => 'Activare filtrare antispam pentru această adresă de e-mail',
    'email-address.antispamSettings' => 'Ce se întâmplă cu mesajele clasificate drept spam',
    'email-address.antispamSettingsMark' => 'Mesajele spam vor fi marcate prin adăugarea următorului text la subiect',
    'email-address.antispamSettingsMarkHint' => 'Lăsați acest câmp necompletat dacă nu doriți să adăugați text. Tastați _SCORE_ dacă doriți să includeți punctajul în subiectul mesajului.',
    'email-address.antispamReportTextHint' => 'Tastați textul pe care doriți să-l adăugați la conținutul mesajelor spam.',
    'email-address.antispamSettingsDelete' => 'Ștergerea tuturor mesajelor spam',
    'email-address.antispamSettingsDeleteHint' => 'Mesajele spam vor fi șterse din căsuța poștală.',
    'email-address.antispamSettingsMove' => 'Mesajele spam se mută în folderul Spam',
    'email-address.antispamSettingsMoveHint' => 'Mutarea tuturor mesajelor spam în folderul numit Spam. Acest folder poate fi accesat cu clientul de e-mail sau prin intermediul programului de e-mail prin web. Dacă utilizați un cont de e-mail IMAP, puteți folosi folderul Spam pentru a instrui filtrul antispam.',
    'email-address.antispamSettingsMoveWarning' => '„Mutare spam în folderul Spam” nu funcționează decât dacă dezactivați opțiunea „Copiile mesajelor de e-mail redirecționate nu se salvează" în fila „Redirecționare”.',
    'email-address.antispamSettingsMoveJunk' => 'Mutarea mesajelor spam în folderul „E-mail nedorit”',
    'email-address.antispamSettingsMoveJunkHint' => 'Toate mesajele spam vor fi mutate în folderul numit „E-mail nedorit”. Acest folder poate fi accesat cu clientul de e-mail sau prin intermediul programului de e-mail prin web. Dacă utilizați un cont de e-mail IMAP, puteți folosi folderul „E-mail nedorit” pentru a instrui filtrul antispam.',
    'email-address.antispamShowAdvancedSection' => 'Afișarea setărilor avansate',
    'email-address.antispamHideAdvancedSection' => 'Ascundere setări avansate',
    'email-address.antispamLearnMore' => 'Aflați cum se instruiește filtrul antispam.',
    'email-address.antispamFilterScoreTitle' => 'Sensibilitatea filtrului',
    'email-address.antispamFilterScoreHint' => 'Filtrul antispam face mai multe teste diferite asupra conținutului și subiectului fiecărui mesaj. Drept urmare, fiecare mesaj este evaluat cu un anumit punctaj. Cu cât acesta este mai mare, cu atât mai probabil este ca mesajul să fie spam. În mod implicit, sensibilitatea filtrului este setat astfel încât toate mesajele cu 7 puncte sau mai multe să fie considerate spam. Dacă primiți multe mesaje spam cu setarea actuală, puteți crește sensibilitatea filtrului: încercați să setați o valoare mai mică, de exemplu, 6. Dacă nu primiți e-mailuri legitime din cauză că filtrul antispam le include la mesaje nedorite, încercați să reduceți sensibilitatea filtrului: setați o valoare mai mare, de exemplu, 8.',
    'email-address.antispamFilterScore' => 'Sensibilitatea filtrului antispam',
    'email-address.antispamWhiteListTitle' => 'Listă albă',
    'email-address.antispamWhiteListHint' => 'Mesajele de e-mail provenite de la utilizatorii trecuți în lista albă nu sunt verificate de filtrul antispam.',
    'email-address.antispamWhiteListField' => 'Listă albă',
    'email-address.antispamWhiteListFieldHint' => 'Tastați numele de domenii, câte unul pe rând. Adresele pot conține caracterele generice „*” și „?”, de exemplu, *@domeniu.ro, utilizator?@*.ro.',
    'email-address.antispamBlackListTitle' => 'Listă neagră',
    'email-address.antispamBlackListHint' => 'Mesajele de e-mail provenite de la utilizatorii trecuți în lista neagră se consideră spam.',
    'email-address.antispamBlackListField' => 'Listă neagră',
    'email-address.antispamBlackListFieldHint' => 'Tastați numele de domenii, câte unul pe rând. Adresele pot conține caracterele generice „*” și „?”, de exemplu, *@domeniu.ro, utilizator?@*.ro.',
    'email-address.antispamTrustedLanguagesTitle' => 'Limbi de încredere',
    'email-address.antispamTrustedLanguagesHint' => 'Filtrul nu va opri niciodată mesajele de e-mail scrise în această limbă.',
    'email-address.antispamTrustedLocalesTitle' => 'Setări regionale de încredere',
    'email-address.antispamTrustedLocalesHint' => 'Filtrul nu va opri niciodată mesajele de e-mail care utilizează grupurile de setări regional specificate. Grupurile de setări regionale includ seturile de caractere utilizate cel mai frecvent. De exemplu, setul de caractere Vest conține coduri pentru literele utilizate în engleză și în limbile din Europa de Vest.',
    'email-address.antispamTrustedNetworksTitle' => 'Rețele de încredere',
    'email-address.antispamTrustedNetworksHint' => 'Se consideră că gazdele de transmitere din rețelele de încredere nu sunt utilizate de spammeri, nu sunt servere de transmitere deschise, nici servere proxy deschise.',
    'email-address.antispamIpAddressesField' => 'Adrese IP',
    'email-address.antispamIpAddressesFieldHint' => 'Specificați adresa IP și masca de subrețea.',
    'email-address.mailBoxQuotaDomainDefault' => 'Dimensiune implicită (%%domainMboxQuota%%)',
    'email-address.mailBoxQuotaDomainDefaultNew' => 'Dimensiune implicită',
    'email-address.mailBoxOutgoingMessages' => 'Numărul maxim de mesaje de e-mail trimise',
    'email-address.mailBoxOutgoingMessagesDomainDefault' => 'Implicit (%%domainOutgoingMessages%% mesaje pe oră)',
    'email-address.mailBoxOutgoingMessagesDomainSpecific' => 'Valoare personalizată pentru căsuța poștală',
    'email-address.mailBoxOutgoingMessagesDomainSpecificHint' => 'mesaje',
    'email-address.mailBoxOutgoingMessagesDomainDefaultNew' => 'Implicit',
    'email-address.mailBoxQuotaDomainDefaultReadonly' => 'Dimensiune implicită',
    'email-address.mailBoxQuotaDomainSpecific' => 'Altă dimensiune',
    'email-address.mailBoxQuotaDomainSpecificReadonly' => 'Dimensiune căsuță poștală',
    'email-address.mailBoxQuotaUnlimited' => 'Nelimitat',
    'email-address.mailBoxLimitReached' => 'A fost atins numărul limită de căsuțe poștale.',
    'email-address.postboxEnabled' => 'Căsuță poștală',
    'email-address.postboxEnabledYes' => 'Pornit',
    'email-address.postboxEnabledNo' => 'Oprit',
    'email-address.description' => 'Deschidere în Plesk',
    'email-address.descriptionHint' => 'Descrierea este vizibilă tuturor persoanelor care au acces la acest cont de e-mail.',
    'email-address.longDescription' => 'Descrierea specificată este prea lungă. Poate avea cel mult %%max%% simboluri.',
    'email-address.loginAsUser' => 'Se poate folosi pentru conectarea la Plesk',
    'email-address.loginAsUserDescription' => '(nume utilizator: %%username%%)',
    'email-address.maxCustomSizeDesc' => 'Dimensiunea căsuței poștală nu poate depăși dimensiunea implicită.',
    'email-address.endDateEnable' => 'Răspunsul automat se dezactivează pe',

    'failed-request.enable-tracing.description' => 'Urmărirea solicitărilor nereușite necesită multe resurse. Urmărirea se va opri automat în %%days%% zile. O puteți opri manual în orice moment.',
    'failed-request.enable-tracing.statusCodes' => 'Coduri de stare',
    'failed-request.enable-tracing.statusCodesDescription' => 'Exemplu: 401.3-999, 405',
    'failed-request.enable-tracing.provider' => 'Furnizor',

    'file-manager.show.buttonReload' => 'Reîncărcare',
    'file-manager.show.buttonSave' => 'Salvare',
    'file-manager.show.buttonSaveAs' => 'Salvare ca',
    'file-manager.show.buttonReset' => 'Resetare',
    'file-manager.show.buttonTextCodeEditor' => 'Editare în editor de cod',
    'file-manager.show.buttonTextEdit' => 'Editare în editor de texte',
    'file-manager.show.buttonWysiwygEdit' => 'Editare în editor HTML',
    'file-manager.show.eolLabel' => 'Tip de caractere rând nou:',
    'file-manager.show.saveAs' => 'Salvare ca:',
    'file-manager.show.saveCodepage' => 'Salvare cu codificarea:',
    'file-manager.show.loadCodepage' => 'Fișierul original se vizualizează cu codificarea:',
    'file-manager.show.loadCodepageHint' => 'Avertisment: Modificările nesalvate se pierd la reîncărcarea fișierului.',
    'file-manager.show.fileExists' => "Fișierul sau folderul %%fileName%% există deja. Nu puteți avea un folder și un fișier cu același nume.",
    'file-manager.show.popupTitle' => 'Salvare ca',
    'file-manager.show.popupFilename' => 'Nume fișier:',

    'file-manager.permissions.filePermissions' => 'Permisiuni de fișiere',
    'file-manager.permissions.directoryPermissions' => 'Permisiuni de director',
    'file-manager.permissions.buttonSubmit' => 'Salvare',
    'file-manager.permissions.buttonApply' => 'Salvare și continuare',
    'file-manager.permissions.buttonCancel' => 'Revocare',
    'file-manager.permissions.buttonAdvanced' => 'Avansat',

    'file-manager.unix-file-permissions.group' => 'Grup',
    'file-manager.unix-file-permissions.owner' => 'Proprietar',
    'file-manager.unix-file-permissions.others' => 'Alții',
    'file-manager.unix-file-permissions.readMode' => 'Citire',
    'file-manager.unix-file-permissions.writeMode' => 'Scriere',
    'file-manager.unix-file-permissions.execMode' => 'Executare/căutare',
    'file-manager.unix-file-permissions.changeRecursive' => 'Modificarea recursivă a permisiunilor',

    'file-manager.windows-permissions.allow' => 'Se permite',
    'file-manager.windows-permissions.deny' => 'Refuzare',
    'file-manager.windows-permissions.inheritFromParent' => 'Se permite propagarea tuturor permisiunilor care se pot moșteni, de la părinte către acest obiect și cele subordonate obiectului. Se includ acestea împreună cu intrările definite explicit aici',
    'file-manager.windows-permissions.replaceOnChildren' => 'Intrările de permisiuni ale tuturor obiectelor copil se înlocuiesc cu cele afișate aici',
    'file-manager.windows-permissions.buttonAdvanced' => 'Avansat',
    'file-manager.windows-permissions.applyTo' => 'Se aplică la:',
    'file-manager.windows-permissions.folderOnly' => 'Doar acestui folder',
    'file-manager.windows-permissions.subfolderOnly' => 'Doar subfolderelor',
    'file-manager.windows-permissions.filesOnly' => 'Doar fișierelor',
    'file-manager.windows-permissions.permissionsFor' => 'Permisiuni de',
    'file-manager.windows-permissions.applyOnto1' => 'Doar acestui folder',
    'file-manager.windows-permissions.applyOnto2' => 'Doar subfolderelor',
    'file-manager.windows-permissions.applyOnto3' => 'Acestui folder și subfolderelor sale',
    'file-manager.windows-permissions.applyOnto4' => 'Doar fișierelor',
    'file-manager.windows-permissions.applyOnto5' => 'Acestui folder și fișierelor din acesta',
    'file-manager.windows-permissions.applyOnto6' => 'Doar subfolderelor și fișierelor',
    'file-manager.windows-permissions.applyOnto7' => 'Acestui folder, subfolderelor și fișierelor',
    'file-manager.windows-permissions.notInherited' => '<fără moștenire>',

    'file-manager.editor.titleTextEditor' => 'Editor de text',
    'file-manager.editor.titleCodeEditor' => 'Editor de cod',
    'file-manager.editor.titleCodeViewer' => 'Vizualizare',
    'file-manager.editor.buttonSubmit' => 'Salvare',
    'file-manager.editor.buttonApply' => 'Salvare și continuare',
    'file-manager.editor.buttonSaveAs' => 'Salvare ca ...',
    'file-manager.editor.buttonCancel' => 'Revocare',
    'file-manager.editor.exitConfirmationYes' => 'Da',
    'file-manager.editor.exitConfirmationNo' => 'Nu',
    'file-manager.editor.fileOverwrite' => 'Fișierul există deja.',
    'file-manager.editor.fileOverwriteDescription' => 'Deja există un fișier cu același nume. Îl suprascrieți?',
    'file-manager.editor.exitConfirmation' => 'Sigur închideți fișierul și renunțați la modificările nesalvate?',
    'file-manager.editor.buttonCodeEditor' => 'Editare în editor de cod',
    'file-manager.editor.buttonTextEditor' => 'Editare în editor de texte',
    'file-manager.editor.buttonHtmlEditor' => 'Editare în editor HTML',

    'file-manager.import-file.buttonSubmit' => 'Import',
    'file-manager.import-file.fieldUrl' => 'URL-ul fișierului',
    'file-manager.import-file.fieldUrlDescription' => 'Specificați URL-ul sursă, de exemplu, „https://example.com/example.tgz”.',
    'file-manager.import-file.fieldUrlFullDescription' => 'Modelul complet de URL este: „https://utilizator:parola@example.com/example.tgz”. Numele de utilizator și parola sunt opționale. Se acceptă protocoalele http, https, ftp, ftps. Utilizați codificarea URL pentru acele părți ale URL-ului care conțin caractere speciale sau spații.',
    'file-manager.import-file.failure' => 'Imposibil de importat fișierul.',

    'file-manager.rotation-settings.title' => 'Setări de rotație pentru coșul de reciclare',
    'file-manager.rotation-settings.rotationBySize' => 'Rotație în funcție de dimensiune',
    'file-manager.rotation-settings.rotationBySizeUnits' => 'MB',
    'file-manager.rotation-settings.rotationBySizeHint' => 'Opțiunea șterge fișierele noi dacă se depășește limita specificată pentru coșul de reciclare.',
    'file-manager.rotation-settings.rotationByDate' => 'Rotație în funcție de dată',
    'file-manager.rotation-settings.rotationByDateUnits' => 'Zile',
    'file-manager.rotation-settings.rotationByDateHint' => 'Opțiunea șterge fișierele care au stat în coșul de reciclare mai mult decât numărul de zile specificat.',

    'ftp-user.description' => 'Dacă lucrați la site-ul web împreună cu altcineva sau găzduiți subdomenii pentru alți utilizatori, se recomandă să creați conturi FTP separate pentru ceilalți.',
    'ftp-user.generalSection' => 'General',
    'ftp-user.login' => 'Nume cont FTP',
    'ftp-user.home' => 'Director de pornire',
    'ftp-user.systemArea' => 'Crearea unui cont FTP cu acces la fișiere în afara directorului de pornire',
    'ftp-user.password' => 'Parolă',
    'ftp-user.passwordConfirmation' => 'Confirmare parolă',
    'ftp-user.hardQuotaSection' => 'Cotă spațiu pe disc',
    'ftp-user.hardQuota' => 'Cotă spațiu pe disc',
    'ftp-user.hardQuotaUnlimited' => 'Nelimitat',
    'ftp-user.permissionsSection' => 'Permisiuni',
    'ftp-user.permissionRead' => 'Permisiune de citire',
    'ftp-user.permissionWrite' => 'Permisiune de scriere',
    'ftp-user.popupTitle' => 'Selectare director',

    'mail-list.listName' => 'Adresă listă de e-mail',
    'mail-list.enabled' => 'Activat',
    'mail-list.administratorEmail' => 'Adresa de e-mail a administratorului de liste de e-mail',
    'mail-list.password' => 'Parolă',
    'mail-list.passwordConfirmation' => 'Confirmare parolă',
    'mail-list.subscribers' => 'Abonați',
    'mail-list.subscribersHint' => 'Specificați adresele de e-mail. Puteți să tastați fiecare adresă pe un rând separat sau să separați adresele cu spații, virgule sau caractere punct și virgulă.',
    'mail-list.notify' => 'La crearea listei de e-mail se va notifica administratorul',
    'mail-list.emptyPassword' => 'Introduceți parola.',
    'mail-list.emptyPasswordConfirmation' => 'Confirmați parola.',
    'mail-list.errorSubscribers' => 'Adrese de e-mail incorecte: %value%.',
    'mail-list.errorMaillistReserved' => 'Adresa de listă de e-mail specificată este deja în uz.',

    'mail-settings.hint' => 'Aici puteți modifica setările serviciului de e-mail pentru acest domeniu.',
    'mail-settings.service' => 'Se activează serviciul de e-mail pentru acest domeniu',
    'mail-settings.nonExist' => 'Ce se întâmplă cu mesajele trimise unor utilizator inexistenți',
    'mail-settings.nonExistBounceWithMessage' => 'Se refuză cu mesaj',
    'mail-settings.nonExistBounce' => 'Se refuză',
    'mail-settings.nonExistCatch' => 'Se redirecționează la adresa',
    'mail-settings.nonExistCatchDescription' => 'Adresa trebuie să aparțină domeniului selectat. Doar administratorul poate specifica o adresă de e-mail externă sau o singură adresă pentru mai multe domenii.',
    'mail-settings.nonExistExternal' => 'Se redirecționează către un server de e-mail extern cu adresa IP',
    'mail-settings.nonExistReject' => 'Refuzare',
    'mail-settings.nonExistDiscard' => 'Refuzare',
    'mail-settings.webmail' => 'Webmail',
    'mail-settings.webmailNone' => 'Niciunul',
    'mail-settings.webmailComponentNotInstalled' => 'Componenta de e-mail prin web nu a fost instalată.',
    'mail-settings.webmailSubdomainAlreadyExists' => 'Există un subdomeniu cu numele %%subdomain%%.',
    'mail-settings.webmailCertificate' => 'Certificat SSL/TLS pentru webmail',
    'mail-settings.webmailCertificateNone' => 'Neselectat',
    'mail-settings.mailCertificate' => 'Certificat SSL/TLS pentru e-mail',
    'mail-settings.mailCertificateNone' => 'Neselectat',
    'mail-settings.serverCertificateNotSelected' => 'Certificatul a fost atribuit, dar e-mailul domeniului nu a fost securizat. Pentru a termina securizarea e-mailului în domeniu, %%certLink%%.',
    'mail-settings.serverCertificatesList' => 'securizați serverul de e-mail',
    'mail-settings.mailLists' => 'Se activează listele de e-mail',
    'mail-settings.mailAutodiscovery' => 'Activare descoperire automată e-mail',
    'mail-settings.mailAutodiscoveryDescription' => 'Aflați cum funcționează, din %%link%%',
    'mail-settings.mailAutodiscoveryDescriptionLink' => 'baza de cunoștințe',
    'mail-settings.domainKeys' => 'Utilizarea sistemului de protecție antispam DKIM pentru semnarea mesajelor de e-mail trimise',
    'mail-settings.greyListing' => 'Protecția antispam cu liste gri se activează pentru toate conturile de e-mail din acest domeniu',
    'mail-settings.howToConfigureExternalDns' => 'Cum se configurează un server DNS extern',
    'mail-settings.howToConfigureExternalDnsAlways' => 'Pentru a activa semnăturile DKIM în cazul utilizării unui server DNS extern, trebuie să configurați personal înregistrările DNS DKIM pe serverul DNS.',
    'mail-settings.howToConfigureExternalDnsEnabled' => 'Pentru a face acest lucru, utilizați înregistrările DNS DKIM de mai jos:',
    'mail-settings.howToConfigureExternalDnsEnabledAliases' => 'Dacă utilizați aliasuri de domeniu pentru a trimite e-mailuri, adăugați înregistrări DNS DKIM și pentru acestea. Utilizați aceleași înregistrări ca pentru domeniul principal, dar cu aliasul de domeniu.',
    'mail-settings.howToConfigureExternalDnsDisabled' => 'Pentru a vedea ce înregistrări DNS DKIM trebuie să configurați, bifați caseta de selectare „%%option%%”, aplicați opțiunea și redeschideți acest pop-up.',
    'mail-settings.mailServiceDisabled' => 'Dezactivat',
    'mail-settings.mailServiceDisabledIncoming' => 'Dezactivat pentru e-mailurile primite',
    'mail-settings.mailServiceDisabledHint' => 'Plesk nu va asigura niciun serviciu de e-mail în acest domeniu.',
    'mail-settings.mailServiceDisabledIncomingHint' => 'Acest domeniu nu permite decât trimiterea de e-mailuri și numai prin Sendmail.',
    'mail-settings.mailServiceEnabled' => 'Activat',
    'mail-settings.mailServiceEnabledHint' => 'Acest domeniu permite trimiterea și primirea de e-mailuri.',
    'mail-settings.mailServiceNotConfigured' => 'Neconfigurat',
    'mail-settings.mailServiceNotConfiguredHint' => 'Plesk nu va asigura niciun serviciu de e-mail în acest domeniu.',
    'mail-settings.warning' => 'Această acțiune duce la ștergerea definitivă a căsuțelor poștale din domeniu, împreună cu mesajele de e-mail primite, respectiv trimise.',
    'mail-settings.show.title' => 'Ștergerea tuturor căsuțelor poștale și e-mailurilor din %%domain%%',
    'mail-settings.show.checkbox' => 'Ștergerea definitivă a tuturor căsuțelor poștale din <b>%%domain%%</b>, inclusiv a e-mailurilor primite, respectiv trimise.',

    'role.roleSection' => 'General',
    'role.name' => 'Numele de rol de utilizator',
    'role.description' => 'Descriere',
    'role.generalPermissionsSection' => 'Acces la serviciile Plesk',
    'role.applicationsAccessSection' => 'Acces la aplicații',
    'role.permissionAllow' => 'Acordat',
    'role.permissionDeny' => 'Refuzat',
    'role.emptyRoleName' => 'Introduceți un nume pentru rol.',
    'role.installedAt' => 'Instalat în',
    'role.noInstallationUrlAvailable' => 'Aplicație externă',
    'role.invalidRoleName' => 'Numele de rol de utilizator pe care l-ați specificat este incorect. În numele rolului nu se pot folosi semne de întrebare și ghilimele.',
    'role.longRoleName' => 'Numele de rol de utilizator pe care l-ați specificat este prea lung.',
    'role.somePermissionsAreNotAllowedForSomeSubscriptions' => 'Unele operații pot deveni indisponibile din următoarele motive: nu s-a acordat permisiune pentru operație prin abonamentul selectat sau volumul resurselor alocate nu este suficient pentru executarea operației.',
    'role.servicesPermissionsDescription' => 'Definirea accesului la aplicațiile instalate sau la serviciile Plesk pentru toți utilizatorii cu acest rol. Dacă acordați unui utilizator acces la o aplicație, aceasta va deveni disponibilă pentru utilizatorul respectiv în Panoul de client.',
    'role.emailActivation' => 'Activarea conturilor acestui rol prin e-mail',

    'service.admin-access.adminAccess' => 'Acces administrativ',
    'service.admin-access.customCredentialsDescriptionNoEntryPoints' => 'Aceste acreditări vor fi utilizate pentru accesul administrativ la această aplicație.',
    'service.admin-access.login' => 'Nume de utilizator administrativ',
    'service.admin-access.password' => 'Parolă administrativă',
    'service.admin-access.passwordConfirmation' => 'Confirmare parolă',

    'service.info.service-entry-point.availableAt' => 'Disponibil la',
    'service.info.service-entry-point.customize' => 'Personalizare comandă rapidă',
    'service.info.service-entry-point.displayNameLabel' => 'Nume comandă rapidă',
    'service.info.service-entry-point.displayNameDescription' => 'Introduceți un nume pentru această comandă rapidă. Numele se afișează sub pictograma comenzii rapide. Comenzile rapide se amplasează în paginile Serviciile mele ale utilizatorilor cărora li s-a acordat acces la această aplicație.',
    'service.info.service-entry-point.descriptionLabel' => 'Descrierea comenzii rapide',
    'service.info.service-entry-point.descriptionDescription' => 'Introduceți o descriere a acestei comenzi rapide. Descrierea se afișează ca sfat ecran, în momentul în care cursorul de mouse este adus pe comanda rapidă.',
    'service.info.service-entry-point.iconLabel' => 'Faceți clic pentru a selecta pictograma comenzii rapide',
    'service.info.service-entry-point.iconCurrent' => 'Pictogramă actuală',
    'service.info.service-entry-point.errorEmptyName' => 'Trebuie să introduceți un nume de comandă rapidă',
    'service.info.service-entry-point.errorLongName' => 'Numele comenzii rapide trebuie să aibă între 1 și 255 de caractere.',
    'service.info.service-entry-point.errorLongDescription' => 'Descrierea comenzii rapide trebuie să aibă între 0 și 255 de caractere.',
    'service.info.service-entry-point.hiddenLabel' => 'Ascundere comandă rapidă',
    'service.info.service-entry-point.hiddenDescription' => 'Nu arătați această comandă rapidă utilizatorilor.',

    'service.info.service-permission.assignedUser' => "Se acordă acces de administrator acestui utilizator",
    'service.info.service-permission.assignedUserNone' => 'Fără atribuire către utilizatori',

    'shared-ssl.master-ssl.switchedOn' => 'Activare SSL/TLS partajat',
    'shared-ssl.master-ssl.domainName' => 'Numele de domeniu al site-ului căruia îi aparține certificatul SSL/TLS care se va partaja cu alte site-uri',
    'shared-ssl.master-ssl.none' => 'Niciunul',
    'shared-ssl.master-ssl.noDomainsWithSslWarning' => 'Nu se poate activa SSL/TLS partajat: nu există domenii cu suport SSL/TLS activat.',

    'user.email.email' => 'Adresă e-mail',
    'user.email.emptyEmail' => 'Trebuie să introduceți o adresă de e-mail.',
    'user.email.internalEmailHint' => 'Creați o adresă de e-mail în Plesk sau utilizați una externă.',
    'user.email.longInternalEmail' => 'Adresa de e-mail este prea lungă.',
    'user.email.longInternalEmailMailboxAddressMailServer' => 'Partea cu numele de utilizator din adresa de e-mail este prea lungă pentru acest server de e-mail. Specificați un nume de utilizator care nu depășește %%max%% simboluri.',
    'user.email.longInternalEmailFullAddressMailServer' => 'Adresa de e-mail este prea lungă pentru acest server de e-mail. Specificați o adresă care nu depășește %%max%% simboluri.',
    'user.email.externalEmail' => 'Adresă de e-mail externă',
    'user.email.externalEmailHint' => 'Se va utiliza pentru resetarea parolei în cazul în care nu mai puteți accesa adresa de e-mail principală.',
    'user.email.emailsIsEqual' => 'Adresa de e-mail externă este identică cu cea principală. Specificați o altă adresă de e-mail externă.',
    'user.email.atLeastOneEmailShouldBeSet' => 'Specificați adresa de e-mail internă sau externă.',

    'user.profileSection' => 'Informații generale',
    'user.contactName' => 'Nume contact',
    'user.email' => 'Adresă e-mail',
    'user.role' => 'Rolul utilizatorului',
    'user.accountSection' => 'Preferințe Plesk',
    'user.login' => 'Nume utilizator',
    'user.password' => 'Parolă',
    'user.buttonBack' => 'Înapoi',
    'user.generalTab' => 'General',
    'user.applicationsAccessSection' => 'Servicii',
    'user.generalPermissionsSection' => 'Privilegii',
    'user.contactsTab' => 'Detalii contact',
    'user.passwordConfirmation' => 'Confirmare parolă',
    'user.internalEmailPasswordChanged' => 'Dacă schimbați parola, se va schimba și parola adresei de e-mail interne.',
    'user.emailName' => 'Adresă e-mail',
    'user.emailType' => 'Tip de e-mail',
    'user.companyName' => 'Nume companie',
    'user.phone' => 'Număr de telefon',
    'user.imNumber' => 'Mesaje instant',
    'user.fax' => 'Număr de fax',
    'user.address' => 'Adresă',
    'user.city' => 'Localitate',
    'user.state' => 'Stat sau provincie',
    'user.zip' => 'Cod poștal sau ZIP',
    'user.country' => 'Țară',
    'user.additionalInfo' => 'Informații suplimentare',
    'user.additionalInfoHint' => 'Doar text simplu: toate etichetele HTML vor fi ignorate.',
    'user.language' => 'Limba Plesk',
    'user.buttonChangePassword' => 'Schimbare parolă',
    'user.permissionAllow' => 'Acordat',
    'user.permissionDeny' => 'Refuzat',
    'user.permissionInherited' => 'Definit de rol',
    'user.emptyContactName' => 'Trebuie să introduceți un nume de contact.',
    'user.emptyLogin' => 'Trebuie să introduceți un nume de utilizator.',
    'user.emptyPassword' => 'Trebuie să introduceți o parolă.',
    'user.emptyPasswordConfirmation' => 'Trebuie să confirmați parola.',
    'user.chooseDomainBoxTitle' => 'Selectați un alt domeniu:',
    'user.userIsActive' => 'Utilizatorul este activ',
    'user.userIsActiveHint' => 'Utilizatorii activi pot accesa Plesk.',
    'user.emailActivation' => 'Activare cont prin e-mail',
    'user.emailHint' => 'Pentru a pune la dispoziția utilizatorului o adresă de e-mail găzduită pe acest server, accesați fila E-mail, creați adresa de e-mail dorită și asociați-o utilizatorului.',
    'user.emailContactHint' => 'Dacă doriți să utilizați o adresă de e-mail găzduită pe acest server, contactați furnizorul de servicii.',
    'user.personalEmailHint' => "Adresa de e-mail a acestui utilizator poate fi modificată în fila E-mail.",
    'user.externalMailRedirectHint' => 'Redirecționarea se poate activa numai pentru adresele de e-mail găzduite pe acest server. Pentru a crea o adresă de e-mail, accesați fila E-mail.',
    'user.externalMailRedirectHint2' => 'Redirecționarea se poate activa numai pentru adresele de e-mail găzduite pe acest server.',
    'user.externalMailAutoResponderHint' => 'Răspunsul automat se poate activa numai pentru adresele de e-mail găzduite pe acest server. Pentru a crea o adresă de e-mail, accesați fila E-mail.',
    'user.externalMailAutoResponderHint2' => 'Răspunsul automat se poate activa numai pentru adresele de e-mail găzduite pe acest server.',
    'user.roleHint' => 'Rolurile le acordă utilizatorilor privilegii administrative și acces la aplicațiile pe care le-ați selectat pentru rol.',
    'user.cannotManageMail' => "Nu aveți permisiunea de a administra setările și serviciile de e-mail.",
    'user.longCompanyName' => 'Numele de companie specificat este prea lung.',
    'user.longPhone' => 'Numărul de telefon specificat este prea lung.',
    'user.longFax' => 'Numărul de fax specificat este prea lung.',
    'user.longAddress' => 'Adresa specificată este prea lungă.',
    'user.longCity' => 'Numele de localitate specificat este prea lung.',
    'user.phoneRegexNotMatch' => 'Numărul de telefon specificat este incorect.',
    'user.faxRegexNotMatch' => 'Numărul de fax specificat este incorect.',
    'user.shortCity' => 'Numele de localitate specificat este prea scurt.',
    'user.limitSubscription' => 'Acces la abonamente',
    'user.limitSubscriptionHint' => 'Utilizatorilor li se permite să acceseze doar un abonament specificat. Valoarea „Toate” le acordă acces la toate abonamentele din contul de găzduire.',
    'user.limitSubscriptionAll' => 'Toate',
    'user.deletedSubscription' => 'Abonament șters',

    'web.add-domain-alias.title' => 'Adăugare alias de domeniu',
    'web.add-domain-alias.createdSuccessfully' => "Aliasul de domeniu %%name%% a fost creat.",
    'web.add-domain-alias.domainAliasName' => 'Denumire alias de domeniu',
    'web.add-domain-alias.domainAliasNameHint' => 'De exemplu, exemplu.net',
    'web.add-domain-alias.forDomain' => 'pentru domeniul',
    'web.add-domain-alias.settingsSectionLegend' => 'Setări',
    'web.add-domain-alias.settingsDns' => 'Zona DNS se sincronizează cu domeniul principal',
    'web.add-domain-alias.settingsMail' => 'Serviciu de e-mail',
    'web.add-domain-alias.settingsWeb' => 'Serviciu web',
    'web.add-domain-alias.settingsSeoRedirect' => 'Redirecționare cu codul HTTP 301',
    'web.add-domain-alias.settingsSeoRedirectHint' => 'Atunci când vizitatorii deschid URL-ul corespunzător aliasului, vor fi redirecționați către URL-ul domeniului principal. Plesk utilizează redirecționarea HTTP 301, compatibilă cu motoarele de căutare, ceea ce înseamnă că în clasamentul întocmit de motorul de căutare URL-urile nu vor apărea separat.',
    'web.add-domain-alias.settingsTomcat' => 'Aplicații web Java',
    'web.add-domain-alias.invalidDomainGuid' => 'Domeniu incorect',

    'web.add-domain.formTitle' => 'Se adaugă domeniul nou',
    'web.add-domain.portalLink' => 'Portal de servicii',
    'web.add-domain.domainName' => 'Nume domeniu',
    'web.add-domain.domainNameHint' => "De exemplu, exemplu.com",
    'web.add-domain.assignToCustomer' => 'Acest domeniu se atribuie unui client',
    'web.add-domain.customer' => 'Selectați un client',
    'web.add-domain.createNewCustomer' => 'Crearea unui client nou',
    'web.add-domain.selectExistingCustomer' => 'Selectați un client existent:',
    'web.add-domain.customerContactInfoHint' => 'Introduceți informațiile de contact ale clientului. Toate celelalte informații, cum ar fi numărul de telefon și adresa, le puteți introduce mai târziu.',
    'web.add-domain.customerLoginInfoHint' => 'Acreditările de acces la panoul de client',
    'web.add-domain.target' => 'Spațiu web',
    'web.add-domain.createNewTarget' => 'Crearea unui abonament nou',
    'web.add-domain.createNewTarget_powerUser' => 'Creare spațiu web nou',
    'web.add-domain.selectExistingTarget' => 'Selectați un abonament existent:',
    'web.add-domain.selectExistingTarget_powerUser' => 'Selectați un spațiu web existent:',
    'web.add-domain.dns' => 'Se activează serviciul DNS',
    'web.add-domain.dnsHint' => '',
    'web.add-domain.mail' => 'Se activează serviciul de e-mail',
    'web.add-domain.mailHint' => '',
    'web.add-domain.mailHintNoPermission' => 'Funcționează dacă setările abonamentului fac posibilă administrarea permisiunilor de e-mail pe domenii. Dacă setările nu permit acest lucru, starea efectivă a serviciului de e-mail se va prelua din abonament.',
    'web.add-domain.hostingManagementOptions' => 'Tip găzduire',
    'web.add-domain.websiteHosting' => 'Găzduire de site web',
    'web.add-domain.websiteForwarding' => 'Redirecționare',
    'web.add-domain.websiteNoHosting' => 'Fără găzduire',
    'web.add-domain.hostingSettingsSectionLegend' => 'Setări de găzduire',
    'web.add-domain.domainCreatedSuccessfully' => 'Domeniul %%domainName%% a fost creat cu succes.',
    'web.add-domain.webspaceLegend' => 'Setări de spațiu web',
    'web.add-domain.addWhmWebsiteTitle' => 'Adăugarea unui site web nou',
    'web.add-domain.addWhmWebsiteHint' => "Puteți alege să găzduiți un site web pe server.",
    'web.add-domain.selectWhmDomain' => 'Selectare domeniu',
    'web.add-domain.customerLegend' => 'Informații despre client',
    'web.add-domain.credentials' => 'Acreditările utilizatorului de sistem',
    'web.add-domain.credentialsHint' => 'pentru accesarea prin FTP și SSH a fișierelor găzduite',
    'web.add-domain.credentialsHintWin' => 'pentru accesarea prin FTP și RDP a fișierelor găzduite',
    'web.add-domain.buttonAddDomain' => 'Adăugare domeniu',

    'web.add-subdomain.formTitle' => 'Adăugarea unui subdomeniu',
    'web.add-subdomain.formGeneralHint' => 'Subdomeniile sunt adrese internet ale diferitelor secțiuni ale site-ului web. Utilizează numele domeniului principal și un prefix. De exemplu, dacă aveți domeniul domeniu.ro, un subdomeniu al acestuia poate fi magazin.domeniu.ro.',
    'web.add-subdomain.formGeneralHintAdditional' => 'De asemenea, puteți crea un subdomeniu generic prin introducerea caracterului * în locul numelui. Vizitatorii site-ului vor fi redirecționați către acest subdomeniu, indiferent de numele de subdomeniu pe care îl introduc în browser.',
    'web.add-subdomain.subdomainName' => 'Nume subdomeniu',
    'web.add-subdomain.subdomainNameHint' => 'Introduceți * pentru a crea un subdomeniu generic.',
    'web.add-subdomain.forDomain' => 'Domeniu părinte',
    'web.add-subdomain.subdomainCreatedSuccessfully' => 'Subdomeniul a fost creat.',
    'web.add-subdomain.hostingSettingsSectionLegend' => 'Setări de găzduire',

    'web.change-hosting.formGeneralHint' => 'Puteți alege să găzduiți site-ul pe server (găzduire de site web), să configurați o redirecționare către un alt site (redirecționare) sau să utilizați zona DNS a domeniului pentru a avea căsuțe poștale în acest domeniu (fără găzduire).',
    'web.change-hosting.changed' => 'Tipul de găzduire al %%domainName%% a fost modificat cu succes.',
    'web.change-hosting.hostingManagementOptions' => 'Tip găzduire',
    'web.change-hosting.websiteHosting' => 'Găzduire de site web',
    'web.change-hosting.websiteForwarding' => 'Redirecționare',
    'web.change-hosting.websiteNoHosting' => 'Fără găzduire web',
    'web.change-hosting.hostingSettingsSectionLegend' => 'Setări de găzduire',
    'web.change-hosting.userName' => 'Nume utilizator',
    'web.change-hosting.userNameHint' => 'Utilizator de sistem pentru administrarea fișierelor și a folderelor din abonament.',
    'web.change-hosting.userNameHint_powerUser' => 'Utilizator de sistem pentru administrarea fișierelor și a folderelor din spațiul web.',
    'web.change-hosting.emptyLogin' => 'Trebuie să specificați un nume de utilizator.',
    'web.change-hosting.password' => 'Parolă',
    'web.change-hosting.emptyPassword' => 'Trebuie să specificați o parolă.',
    'web.change-hosting.passwordConfirmation' => 'Confirmare parolă',
    'web.change-hosting.warningInstalledApplications' => 'Există aplicații web instalate pe site. Dacă modificați tipul de găzduire, acestea vor înceta să fie accesibile.',
    'web.change-hosting.removeWebsiteHostingTitle' => 'Avertisment: Conținutul site-ului va fi șters.',
    'web.change-hosting.removeWebsiteHostingDescription' => 'Modificați tipul de găzduire al acestui site?',
    'web.change-hosting.removeWebsiteHostingDescriptionFolders' => 'Se vor șterge următoarele foldere, cu conținut:',
    'web.change-hosting.removeWebsiteHostingDescriptionAllFolders' => 'Se va șterge tot conținutul folderului rădăcină al spațiului web.',

    'web.change-status.changed' => 'Starea site-ului din %%domainName%% a fost modificată cu succes.',
    'web.change-status.statusManagementOptions' => 'Starea site-ului web',
    'web.change-status.statusDisabled' => 'Dezactivat (denumit în trecut Suspendat)',
    'web.change-status.statusSuspended' => 'Suspendat',
    'web.change-status.statusActive' => 'Activ',
    'web.change-status.statusDisabledHint' => 'Site-ul nu va mai fi găzduit pe server și nu va fi accesibil decât prin programe client FTP și prin managerul de fișiere. Vizitatorii vor vedea pagina implicită a serverului web. Serviciul de e-mail nu va fi disponibil.',
    'web.change-status.statusSuspendedHint' => 'Site-ul web va fi găzduit în continuare pe server, dar vizitatorii vor fi redirecționați către pagina cu documentul de eroare personalizat, cu codul HTTP 503. Serviciul de e-mail va rămâne utilizabil. Aici puteți %%link%%.',
    'web.change-status.statusSuspendedHintNoLink' => 'Deși site-ul web rămâne găzduit pe server, vizitatorii vor fi redirecționați către pagina cu documentul de eroare personalizat, cu codul HTTP 503 (care poate fi prelucrat de motoarele de căutare). Serviciul de e-mail va rămâne utilizabil.',
    'web.change-status.error503PageLink' => 'edita documentul de eroare personalizat',
    'web.change-status.statusActiveHint' => 'Site-ul va funcționa ca de obicei.',
    'web.change-status.notActivatedSuspended' => 'Domeniul sau site-ul web %%domainName%% nu poate fi activat pentru că a fost suspendat de furnizorul de servicii de găzduire.',
    'web.change-status.notActivatedDisabled' => 'Domeniul sau site-ul web %%domainName%% nu poate fi activat pentru că a fost dezactivat de furnizorul de servicii de găzduire.',

    'web.edit.formTitle' => 'Acces de găzduire web pentru %%name%%',
    'web.edit.formGeneralHint' => 'Aici puteți vedea adresele IP asociate abonamentului dvs. și puteți schimba numele de utilizator și parola utilizatorului de sistem.',
    'web.edit.formGeneralHint_powerUser' => 'Aici puteți vedea adresele IP asociate acestui spațiu web și puteți schimba numele de utilizator și parola utilizatorului de sistem.',
    'web.edit.ipAddressesLegend' => 'Adrese IP',
    'web.edit.ipAddresses' => 'Adrese IP',
    'web.edit.certificateLegend' => 'Certificat',
    'web.edit.certificateFromDomainRepository' => '%%name%% (%%repositoryName%%)',
    'web.edit.certificateFromOtherRepository' => '%%name%% (proprietarul este un alt utilizator)',
    'web.edit.userAccountLegend' => 'Utilizator de sistem',
    'web.edit.systemUserHint' => 'Aici puteți specifica utilizatorul din sistemul de operare, care se va folosi pentru administrarea fișierelor și a folderelor din abonament, prin FTP sau prin managerul de fișiere. Utilizatorul de sistem se folosește și pentru a accesa Plesk prin SSH (pe Linux) sau prin RDP (pe Windows), cu condiția acordării permisiunilor corespunzătoare.',
    'web.edit.systemUserHint_powerUser' => 'Aici puteți specifica utilizatorul din sistemul de operare, care se va folosi pentru administrarea fișierelor și a folderelor din spațiul web, prin FTP sau prin managerul de fișiere. Utilizatorul de sistem se folosește și pentru a accesa Plesk prin SSH (pe Linux) sau prin RDP (pe Windows), cu condiția acordării permisiunilor corespunzătoare.',
    'web.edit.login' => 'Nume utilizator',
    'web.edit.emptyLogin' => 'Specificați un nume de utilizator.',
    'web.edit.password' => 'Parolă',
    'web.edit.passwordConfirmation' => 'Confirmare parolă',
    'web.edit.emptyPassword' => 'Specificați o parolă.',
    'web.edit.emptyPasswordConfirmation' => 'Confirmați parola.',
    'web.edit.shellUnix' => "Accesarea serverului prin SSH",
    'web.edit.shellHintUnix' => "Accesarea serverului prin SSH, cu acreditările utilizatorului de sistem.",
    'web.edit.shellWin' => 'Accesare serverului prin desktop la distanță',
    'web.edit.shellHintWin' => "Accesarea serverului prin desktop la distanță, cu acreditările utilizatorului de sistem.",
    'web.edit.diskQuotaLegend' => 'Cotă fixă de spațiu pe disc',
    'web.edit.diskQuotaHint' => 'Cota fixă de spațiu pe disc este limita de spațiu pe disc ce se poate utiliza. Dacă este setată o cotă fixă și tot spațiul pe disc este ocupat, nu se mai pot face operații cu fișiere.',
    'web.edit.diskQuota' => 'Cotă fixă de spațiu pe disc',
    'web.edit.diskQuotaUnlimited' => 'Nelimitat',
    'web.edit.diskQuotaLimited' => '%%limit%% MB',
    'web.edit.diskQuotaNotSupported' => 'Nelimitat. Cota de hard disk nu este acceptată din cauza configurării sistemului de fișiere pe server.',
    'web.edit.limitMbUnits' => 'MB',
    'web.edit.successfullyUpdated' => 'Setările de găzduire au fost actualizate cu succes.',
    'web.edit.affectedDomainsLegend' => 'Site-urile web pentru care sunt valabile aceste setări',
    'web.edit.affectedDomainsHint' => 'Următoarele site-uri web sunt asociate cu actualul utilizator de sistem. Modificările de setări de găzduire a site-urilor pe care le faceți în această pagină vor fi valabile pentru toate site-urile web.',

    'web.mobile.create.formTitle' => 'Creare site pentru dispozitive mobile',
    'web.mobile.create.formGeneralHint' => 'Specificați numele site-ului pentru dispozitiv mobile – un URL prin care se poate accesa site-ul pentru mobil. De obicei se folosește un prefix ca „m”, „mob”, „mobi”, „mobile” etc. De exemplu: mobile.exemplu.to. Ulterior, puteți folosi acest URL într-un link ca „Versiune pentru mobil” pe site-ul obișnuit, astfel încât vizitatori să poate comuta între cele două versiuni: cea pentru mobil și cea obișnuită.',
    'web.mobile.create.prefix' => 'Nume site',
    'web.mobile.create.emptySiteName' => 'Numele site-ului pentru dispozitive mobile nu poate rămâne necompletat, acest lucru ar intra în conflict cu site-ul obișnuit.',

    'web.security-section.securitySectionLegend' => 'Securitate',
    'web.security-section.securitySectionHint' => 'Pentru a securiza tranzacțiile cu site-ul, utilizați protocolul SSL/TLS, care criptează toate datele și le transferă prin conexiune securizată. Pentru a folosi SSL/TLS, mutați acest site la o adresă IP dedicată, instalați pe acesta un certificat SSL/TLS și selectați mai jos certificatul respectiv.',
    'web.security-section.securitySectionSniHint' => 'Pentru a securiza tranzacțiile cu site-ul, utilizați protocolul SSL/TLS, care criptează toate datele și le transferă prin conexiune securizată. Pentru a folosi SSL/TLS, instalați pe acesta un certificat SSL/TLS și selectați mai jos certificatul respectiv.',
    'web.security-section.enableSslSupport' => 'Suport SSL/TLS',
    'web.security-section.enableSslRedirect' => 'Redirecționare 301 permanentă, sigură pentru SEO, de la HTTP la HTTPS',

    'web.seo-settings.seoRedirectDirection' => 'Domeniu preferat',
    'web.seo-settings.seoRedirectDirectionHint' => 'Selectați URL-ul (cu sau fără prefixul www.) către care vor fi trimiși vizitatorii site-ului printr-o redirecționare HTTP 301 ce poate fi prelucrată de motoarele de căutare.',
    'web.seo-settings.seoRedirectDirectionNone' => 'Niciunul',

    'web.settings.formGeneralHint' => 'Aici puteți configura setările de găzduire ale site-ului și puteți selecta funcțiile disponibile pentru site.',
    'web.settings.hostingType' => 'Tip găzduire',
    'web.settings.websiteHosting' => 'Site web',
    'web.settings.forwardingHosting' => 'Redirecționare',
    'web.settings.noHosting' => 'Fără găzduire',
    'web.settings.changeHosting' => 'Modificare',
    'web.settings.websiteStatus' => 'Starea site-ului web',
    'web.settings.changeStatus' => 'Modificare',
    'web.settings.active' => 'Activ',
    'web.settings.suspended' => 'Suspendat',
    'web.settings.disabled' => 'Dezactivat',
    'web.settings.webScriptingSectionLegend' => 'Scripturi și statistici web',
    'web.settings.webScriptingSectionHint' => 'Specificați care dintre următoarele limbaje de programare și de scripturi vor fi interpretate, executate sau procesate în altă manieră de serverul web.',
    'web.settings.__asp_win_support' => 'Suport Microsoft ASP',
    'web.settings.__asp_dot_net_support' => 'Suport Microsoft ASP.NET',
    'web.settings.__asp_dot_net_version' => 'Versiune',
    'web.settings.__asp_dot_net_version_readonly' => 'versiunea %%value%%',
    'web.settings.__ssi_support' => 'Suport SSI',
    'web.settings.__ssi_with_html' => 'pentru fișierele *.htm, *.html se utilizează SSI',
    'web.settings.__php_support' => 'Suport PHP',
    'web.settings.__php_run_as' => 'PHP se execută ca',
    'web.settings.__php_served_by_apache' => 'deservit(ă) de Apache',
    'web.settings.__php_served_by_nginx' => 'deservit(ă) de nginx',
    'web.settings.__cgi_support' => 'Suport CGI',
    'web.settings.__cgi_bin_mode' => 'directorul cgi-bin se află în',
    'web.settings.__cgi_bin_mode_webspace' => 'directorul rădăcină al spațiului web',
    'web.settings.__cgi_bin_mode_www_root' => 'rădăcina de documente a acestui domeniu',
    'web.settings.__cgi_bin_mode_old_style' => 'rădăcina de tip vechi a acestui domeniu',
    'web.settings.__cgi_bin_mode_readonly' => 'directorul cgi-bin se află în %%value%%',
    'web.settings.__perl_unix_support' => 'Suport Perl',
    'web.settings.__perl_win_support' => 'Suport Perl',
    'web.settings.__python_unix_support' => 'Suport Python',
    'web.settings.__python_win_support' => 'Suport Python',
    'web.settings.__fastcgi_unix_support' => 'Suport FastCGI',
    'web.settings.__webstat_support' => 'Statistici web',
    'web.settings.__plesk_stat_protect' => 'Accesul la statisticile web se face cu numele de utilizator FTP și cu parola corespunzătoare',
    'web.settings.__plesk_stat_protected' => 'Accesul la statisticile web se face cu numele de utilizator FTP și cu parola corespunzătoare',
    'web.settings.__apache_errdocs' => 'Documente de eroare personalizate',
    'web.settings.__php_module_handler' => 'mod_php',
    'web.settings.__php_fastcgi_handler' => 'Aplicație FastCGI',
    'web.settings.__php_cgi_handler' => 'Aplicație CGI',
    'web.settings.__php_isapi_handler' => 'Extensie ISAPI',
    'web.settings.__php_version' => 'Versiune PHP',
    'web.settings.__hosting_write_modify' => 'Permisiuni de scriere/modificare suplimentare',
    'web.settings.__hosting_webdeploy' => 'Publicare Web Deploy',
    'web.settings.awstats' => 'AWStats',
    'web.settings.webalizer' => 'Webalizer',
    'web.settings.smarterstats' => 'SmarterStats',
    'web.settings.__none' => 'Fără',
    'web.settings.activate' => 'Activare',
    'web.settings.deactivate' => 'Suspendare',
    'web.settings.__php_support_readonly' => 'versiunea: %%version%%; handler: %%handler%%',
    'web.settings.__php_support_readonly_not_registered' => 'neînregistrat',
    'web.settings.domainName' => 'Nume domeniu',
    'web.settings.domainNameHint' => "De exemplu, exemplu.com",
    'web.settings.sameSslCompatibilitySectionLegend' => 'Mod de compatibilitate pentru opțiunea veche „Separare conținut SSL/TLS și non-SSL/TLS”',
    'web.settings.sameSslCompatibilityModeCheckbox' => 'Site-ul funcționează în modul compatibilitate pentru opțiunea veche „Separare conținut SSL/TLS și non-SSL/TLS”',
    'web.settings.sameSslCompatibilityHint' => 'Această secțiune apare pentru că ați folosit opțiunea „Separare conținut SSL/TLS și non-SSL/TLS” înainte de upgrade. Opțiunea a fost abandonată în Plesk 11. Toate site-urile create în Plesk 11 stochează elementele de conținut disponibile prin conexiuni HTTP și HTTPS în același director. Acest lucru înseamnă că site-ul rămâne funcțional în modul compatibilitate, dar nu îl puteți administra prin Plesk. Se recomandă cu tărie mutarea tuturor datelor din directorul httpsdocs/ în httpdocs/ și dezactivarea ulterioară a modului de compatibilitate. După ce dezactivați modul de compatibilitate, nu îl veți putea reactiva, iar această secțiune nu va mai apărea. Rețineți: dacă instalați aplicații în directorul httpsdocs/ cât timp modul de compatibilitate este activat, aplicațiile nu vor fi accesibile prin internet. Dacă doriți să instalați aplicații în httpsdocs/, dezactivați modul de compatibilitate.',
    'web.settings.willBeAppliedAfterApacheRestartInterval' => 'Setările site-ului web vor fi aplicate în %%restartInterval%% minute.',
    'web.settings.phpSettingsDescription' => 'În această pagină se afișează configurația PHP a site-ului web. Aceste setări sunt specifice site-ului și nu afectează alte site-uri din abonament. Dacă furnizorul de servicii de găzduire vă acordă permisiunea corespunzătoare, puteți schimba configurația PHP. Configurația PHP particularizată se poate folosi, de exemplu, pentru a limita consumul resurselor de sistem în scripturile PHP sau pentru a îndeplini cerințele unei anumite aplicații web. Dacă setați un parametru la valoarea implicită, PHP ia valoarea parametrului respectiv din configurația la nivel de server.',
    'web.settings.phpSettingsAvailableVariables' => 'În valorile de parametri puteți folosi următoarele elemente de substituit:',
    'web.settings.phpSettingsVariableDocroot' => '{DOCROOT} pentru directorul rădăcină cu documente al site-ului web. Valoarea actuală este %%DOCROOT%%. %%HTTPS_DOCROOT%%',
    'web.settings.phpSettingsVariableDocrootHttpsSame' => 'Directorul rădăcină de documente HTTPS este identic cu cel setat pentru http.',
    'web.settings.phpSettingsVariableDocrootHttpsDifferent' => 'Directorul rădăcină de documente HTTPS este %%DOCROOT%%.',
    'web.settings.phpSettingsVariableWebspaceRoot' => '{WEBSPACEROOT} pentru directorul rădăcină cu documente al principalului site web al abonamentului.',
    'web.settings.phpSettingsVariableTmp' => '{TMP} pentru directorul în care se stochează fișierele temporare.',
    'web.settings.phpSettingsPhpVersion' => 'Utilizați versiunea de PHP %%version%%.',
    'web.settings.phpSettingsPhpDisabled' => 'PHP este dezactivat.',
    'web.settings.phpHandlerTypeHint' => 'Rețineți: modificarea tipului de handler PHP poate împiedica funcționarea scripturilor PHP existente pe site.',
    'web.settings.fpmDedicatedHandlerHint' => 'Utilizarea acestui handler crește stabilitatea site-ului, dar și ocuparea memoriei.',
    'web.settings.phpHandlerChangeHint' => 'Ați schimbat setările de handler PHP. Dacă salvați aceste modificări, scripturile PHP de pe site se pot opri timp de %%interval%%, din cauza configurației de server.',
    'web.settings.phpHandlerTypeHelpLink' => 'Aflați cum se aleg cele mai potrivite setări PHP',
    'web.settings.phpHandlerTypeNotAvailableHint' => 'Suportul PHP nu se poate activa: configurația de găzduire actuală nu include nicio versiune PHP disponibilă pentru acest domeniu.',
    'web.settings.phpHandlerTypeNotAvailableHelpLink' => 'Aflați cum se activează celelalte versiuni PHP.',
    'web.settings.phpHandlerBroken' => 'Handlerul PHP selectat este deteriorat. Selectați un alt handler.',
    'web.settings.phpHandlerOutdated' => '(Învechit)',
    'web.settings.phpHandlerDeprecated' => '(Abandonat)',

    'web.setupService.formTitle' => 'Configurare serviciu: %%serviceReference%%',
    'web.setupService.successfullyUpdated' => 'Serviciul „%%serviceReference%%” a fost actualizat cu succes.',

    'web.site-copy.subdomainsGroup' => 'Subdomeniile %%siteName%%:',
    'web.site-copy.destinationTypeSection' => 'Destinație copiere',
    'web.site-copy.destinationType' => 'Locul în care se vor copia fișierele site-ului',
    'web.site-copy.destinationTypeSite' => 'Site web în Plesk',
    'web.site-copy.destinationTypeSiteDescription' => 'Fișierele site-ului se copiază într-un alt site propriu, găzduit în acest cont. Dacă aveți acces FTP la un alt cont de pe acest server, utilizați opțiunea Spațiu de stocare FTP.',
    'web.site-copy.destinationTypeSiteDescription_powerUser' => 'Fișierele site-ului se copiază într-un alt site găzduit pe acest server.',
    'web.site-copy.destinationTypeSiteSelect' => 'Nume site',
    'web.site-copy.destinationSiteRootIsSubDirOfSourceRoot' => "Fișierele site-ului %%source%% nu pot fi copiate în %%destination%% pentru că și %%destination%% face parte din fișierele respectivă – directorul rădăcină de documente este un subdirector al rădăcinii de documente %%source%%.",
    'web.site-copy.unableToDeleteSourceRootIsSubdirOfDestinationRoot' => "Fișierele site-ului %%destination%% nu pot fi șterse pentru că fișierele din %%source%% fac parte din acestea– directorul rădăcină de documente %%source%% este un subdirector în %%destination%%.",
    'web.site-copy.destinationTypeFtp' => 'Spațiu de stocare FTP',
    'web.site-copy.destinationTypeFtpDescription' => 'Copierea fișierelor site-ului web într-un cont FTP de pe acest server sau de pe unul extern.',
    'web.site-copy.destinationTypeFtpDescription_powerUser' => 'Copierea fișierelor site-ului web într-un cont FTP de pe un server extern.',
    'web.site-copy.destinationTypeFtpHost' => "Nume de gazdă server",
    'web.site-copy.destinationTypeFtpPort' => "Port",
    'web.site-copy.destinationTypeFtpFolder' => 'Director',
    'web.site-copy.destinationTypeFtpUser' => 'Nume utilizator',
    'web.site-copy.destinationTypeFtpPassword' => 'Parolă',
    'web.site-copy.destinationTypeFtpMode' => 'Metodă de conectare FTP',
    'web.site-copy.destinationTypeFtpModeActive' => 'Mod activ',
    'web.site-copy.destinationTypeFtpModeActiveDescription' => 'În modul activ, Plesk își trimite adresa IP și numărul de port la care va aștepta conexiunile de la un server extern, iar serverul inițiază conexiunea TCP. Acest mod este recomandat în cazul în care serverul administrat prin Plesk nu este protejat cu un firewall.',
    'web.site-copy.destinationTypeFtpModePassive' => 'Mod pasiv',
    'web.site-copy.destinationTypeFtpModePassiveDescription' => 'Modul pasiv se poate utiliza în cazul în care serverul administrat prin Plesk se află în spatele unui firewall și nu poate primi conexiuni TCP din exterior.',
    'web.site-copy.existingFiles' => 'Ce se întâmplă cu fișierele existente',
    'web.site-copy.existingFilesKeep' => 'Se păstrează fișierele existente în site-ul destinație',
    'web.site-copy.existingFilesKeepDescription' => 'Suprascrierea fișierelor existente, cu același nume, din site-ul destinație.',
    'web.site-copy.existingFilesDelete' => 'Se șterg toate fișierele existente',
    'web.site-copy.existingFilesDeleteDescription' => 'Toate fișierele existente din site-ul destinație sunt șterse înainte de copiere.',
    'web.site-copy.emptyLogin' => 'Specificați nume de utilizator corespunzător unui cont FTP.',
    'web.site-copy.emptyHost' => 'Specificați un nume de gazdă server.',
    'web.site-copy.emptyPort' => 'Specificați un port de gazdă server.',
    'web.site-copy.copyInProgress' => 'Se copiază site-ul %%sourceName%% în %%destinationName%%. Veți primi prin e-mail notificări privind desfășurarea procesului (%%email%%).',
    'web.site-copy.unableToCopy' => 'Copierea fișierelor site-ului nu a reușit.',
    'web.site-copy.siteCopied' => 'Fișierele site-ului au fost copiate.',
    'web.site-copy.emailSubjSuccess' => 'Fișierele site-ului „%%source%%” au fost copiate.',
    'web.site-copy.emailSubjFailure' => 'Copierea fișierelor site-ului „%%source%%” nu a reușit.',
    'web.site-copy.emailBodySuccess' => 'Fișierele site-ului „%%source%%” au fost copiate în „%%destination%%”.',
    'web.site-copy.emailBodyFailure' => 'Copierea fișierelor site-ului „%%source%%” în „%%destination%%” nu a reușit: %%message%%',

    'web._shared.forwardingSettingsSectionLegend' => 'Setări de redirecționare',
    'web._shared.forwardDestination' => 'Adresă de destinație',
    'web._shared.forwardDestinationHint' => 'URL-ul site-ului web țintă.',
    'web._shared.forwardingTypeOptions' => 'Tip de redirecționare',
    'web._shared.forwardingFrame' => 'Redirecționare cu cadre',
    'web._shared.forwardingFrameHint' => 'Vizitatorii sunt redirecționați către un alt site, dar nu li se arată adresa destinație, deci nu află despre redirecționare.',
    'web._shared.forwardingHttpCode301' => 'Mutat definitiv (cod 301)',
    'web._shared.forwardingHttpCode301Hint' => 'Vizitatorii sunt redirecționați către un alt site și li se arată adresa destinație. O asemenea redirecționare păstrează locul site-ului în clasamentele motorului de căutare.',
    'web._shared.forwardingHttpCode302' => 'Mutat temporar (cod 302)',
    'web._shared.forwardingHttpCode302Hint' => 'Vizitatorii site-ului sunt redirecționați către o copie temporară a site-ului, în cazul în care nu doriți ca motoarele de căutare să indexeze site-ul temporar respectiv.',
    'web._shared.documentRoot' => 'Rădăcina de documente',
    'web._shared.documentRootHint' => 'Calea către directorul de pornire al site-ului.',
    'web._shared.documentRootHintDisabledDueApplications' => 'Imposibil de modificat directorul rădăcină de documente, pentru că există aplicații web instalate pe site.',
    'web._shared.ipAddress' => 'Adresă IP',
    'web._shared.shared' => 'partajat',
    'web._shared.exclusive' => 'dedicat',
    'web._shared.ipAddressHint' => "Adresa IP la care se găzduiește site-ul este o adresă de rețea a gazdei virtuale a site-ului.",
    'web._shared.certificateFromDomainRepository' => '%%name%% (%%repositoryName%%)',
    'web._shared.certificateFromOtherRepository' => '%%name%% (alt depozit)',
    'web._shared.certificate' => 'Certificat',
    'web._shared.sameCertificatesHint' => 'Certificatul selectat va fi utilizat pentru toate site-urile găzduite la aceeași adresă IP dedicată.',
    'web._shared.differentCertificatesHint' => 'Acest abonament este asociat cu două adrese IP dedicate, cu două certificate diferite. Certificatul selectat va înlocui eventualele certificate instalate în site-urile găzduite la aceste două adrese IP.',
    'web._shared.differentIpTypesCertificateHint' => 'Acest abonament este asociat cu o adresă IP partajată și una dedicată. Certificatul selectat va fi utilizat și pentru toate celelalte site-uri găzduite la adresa IP dedicată.',
    'web._shared.certificateNotSelected' => 'Neselectat',
    'web._shared.sslCertificatesRepositoryIsEmptyHint' => 'În depozit nu există certificate SSL/TLS. Pentru a adăuga un certificat, accesați %%link%%.',
    'web._shared.sslCertificatesRepositoryLink' => 'această pagină',

    'web-user.settings.allowScripts' => 'Utilizatorilor web li se permite să utilizeze scripturi',

    'web-user.name' => 'Nume de utilizator pentru conectarea la server prin FTP',
    'web-user.longName' => 'Acest nume de utilizator este prea lung (se acceptă cel mult %max% simboluri).',
    'web-user.password' => 'Parolă',
    'web-user.passwordConfirmation' => 'Confirmare parolă',
    'web-user.hardDiskQuota' => 'Cotă spațiu pe disc',
    'web-user.hardDiskQuotaUnlimited' => 'Nelimitat',
    'web-user.hardDiskQuotaIsNotSupported' => '(cota de hard disk nu este acceptată din cauza configurării sistemului de fișiere pe server)',
    'web-user.megabytes' => 'MB',

    'requiredFields' => 'Câmpuri obligatorii',
];