<?php
// Copyright 1999-2023. Plesk International GmbH. All rights reserved.
// This file contains structured and commented locale keys for Plesk 9.x

global $PROD_NAME;

$GLOBALS['lmsg_arr'] += [
    ////
    //// LOGIN SCREEN
    ////

    'login_up__access_denied_account_disabled' => "アクセスが拒否されました。アカウントは一時停止されています。",
    'login_up__login_has_been_locked' => "間違ったパスワードが何度も入力されたため、セキュリティ上の理由によりしばらくこのユーザ名でログインできません",
    'login_up__unable_to_check_pass' => "パスワードをチェックできません。%1",
    'login_up__warning_limits_licence_key' => "ユーザアカウント数、ドメイン数、メールアカウント数、またはサーバでホスティングされているウェブユーザ数のいずれかが、ライセンスキーに規定されている上限を超過しています。\nPlesk 営業担当までご相談のうえ、必要な数のユーザとドメインをホスティングできるキーをお求めください。このメールにお心当たりがない場合には、Plesk テクニカルサポートまでお知らせください。\nライセンスに規定されたユーザアカウント/ドメイン/メールアカウント/ウェブユーザ/言語パックの上限： %2。\n現在ホスティングしているユーザアカウント/ドメイン/メールアカウント/ウェブユーザ/言語パックの数： %3。", // PFW
    'login_up__short_warning_limits_licence_key' => "ご使用のリソース量が、製品ライセンスに規定されている上限を超過しました。Plesk 営業担当までご相談のうえ、新規ライセンスキーをご購入ください。",
    'login_up__grace_period' => '製品ライセンスの失効猶予期間中です。製品ライセンスを更新するには、 %1ライセンス情報ページ%2で［キーを取得］オプションを選択してください。',
    'login_up__partner_license_message' => '現在、完全な機能セットをアクティブ化するために登録を必要とする、制限付きの製品ライセンスを使用しています。製品ライセンスを更新するには、すべての機能を利用するためには、%1ライセンス情報ページ%2で［キーを取得］オプションを選択してください。',
    'login_up__system_admin_disabled' => 'スーパーユーザ（root または管理者アカウント）は、セキュリティ上の理由から Plesk へのログインが禁止されています。',

    ///
    /// Online help keys:
    ///

    'plesk_guide' => "Plesk 管理者ガイド",
    'plesk_guide_reseller' => "Plesk リセラーガイド",
    'plesk_guide_client' => "Plesk カスタマガイド",
    'plesk_guide_domain_admin' => "Plesk ドメイン管理者ガイド",
    'plesk_guide_mailuser' => "Plesk メールユーザガイド",

    ////
    //// COMMON KEYS FOR NAVIGATION THROUGHOUT PANEL
    ////

    ///
    /// NAVIGATION PANE
    ///

    'bt_search' => '検索', // multiple usage: TBI
    'ui__client_unknown__quick-search' => '顧客',
    'ui__reseller_unknown__quick-search' => 'リセラー',
    'ui__client/domain_unknown__quick-search' => 'ドメイン',
    'nav__general' => 'メインメニュー',
    '__home' => 'ホーム',
    '__resellers' => 'リセラー',
    '__clients' => '顧客',
    '__domains' => 'ドメイン',
    '__applications' => 'アプリケーション',
    '__settings' => '設定',
    'nav__system' => 'システム',
    '__master' => 'マスター',

    ///
    /// END OF NAVIGATION PANE
    ///

    ///
    /// NAVIGATION KEYS
    ///

    // up level
    'bt_up_level' => '1 つ上のレベルへ',

    // object switcher

    ///
    /// END OF NAVIGATION KEYS
    ///

    ///
    /// LISTS
    ///

    // common operations on list objects
    'bt_remove_selected' => '削除',
    'bt_make_default' => 'デフォルトに指定',

    // common list object operation errors
    'class_cList__empty_selection' => 'オブジェクトが選択されていません',

    // common list object search keys
    'clist__search_show' => '検索を表示',
    'clist__search_hide' => '検索エリアを隠す',

    'bt_show_all' => "検索結果をリセット",

    // common object list info keys
    'clist__first' => '最初',
    'clist__last' => '最後',
    'clist__prev' => '&lt;&lt;',
    'clist__next' => '&gt;&gt;',
    'clist__page' => 'ページ',
    'clist__page_size' => 'ページあたりのエントリ数',
    'clist__info' => '%1：全 %4 件',
    'clist__info_empty' => '%1 なし',
    'clist__info_filter' => '%5 件の%1が見つかりました（全 %4 件中）',
    'clist__info_paging' => '全 %4 件のうち %2～%3 %1 まで表示',
    'clist__info_paging_filter' => '%2-%3 %1 / %5 件が見つかりました（全 %4 件中）',

    ///
    /// END OF LISTS
    ///

    ////
    //// KEYS FOR USER HOME PAGES
    ////

    ///
    /// COMMON HOME PAGE KEYS
    ///

    // business object controls
    '__object_on' => 'アクティブ',
    '__object_off' => '一時停止',

    '__home_description' => 'ホームページに戻る',
    'indicator_title' => '%1% 使用中、残り %2%', // tooltip for visual stats area

    ///
    /// END OF COMMON HOME PAGE KEYS
    ///

    ///
    /// SERVER ADMINISTRATOR
    ///

    '__invalid_url_requested' => '無効な URL が要求されました。',

    // accounts
    // icons
    'ui__reseller_unknown__short-title' => "リセラーアカウント",
    'ui__reseller_unknown__title' => "リセラーアカウント",
    'ui__reseller_unknown__description' => "リセラーアカウントを管理します。",
    'ui__reseller/client_unknown__short-title' => '顧客アカウント',
    'ui__reseller/client_unknown__title' => '顧客アカウント',
    'ui__reseller/client_unknown__description' => '顧客アカウントを管理します。',
    // dropdowns
    'ui__admin-alias_unknown__title' => "追加管理者アカウント", // PFW
    'ui__admin-alias_unknown__short-title' => "追加管理者アカウント", // PFW
    'ui__admin-alias_unknown__description' => "管理者サブアカウントについて情報を表示および変更する", // PFW

    // server
    // icons
    'ui__server/mail__short-title' => "サーバ全体のメール設定",
    'ui__server/mail__title' => "サーバ全体のメール設定",
    'ui__server/mail__description' => "メールサーバを設定し、サーバ全体のメール設定を行います。",
    'ui__server/dns__short-title' => 'DNS 設定',
    'ui__server/dns__title' => 'DNS 設定',
    'ui__server/dns__description' => 'サーバ全体の DNS 設定を表示およびアップデートする',
    'ui__server/services__title' => 'サービス管理',
    'ui__server/services__description' => 'Plesk サービスを起動、停止、または再起動します。',
    'ui__server/crontab/task_unknown__short-title' => 'スケジュール済みタスク',
    'ui__server/crontab/task_unknown__title' => 'スケジュール済みタスク',
    'ui__server/crontab/task_unknown__description' => 'サーバ全体のスケジュール済みタスクを追加および削除する',
    'ui__server/ip-address_unknown__short-title' => 'IP アドレス',
    'ui__server/ip-address_unknown__title' => 'IP アドレス',
    'ui__server/ip-address_unknown__description' => 'IP アドレスの表示/追加/削除を行い、リセラーに IP アドレスを割り当てます。',
    // dropdowns
    'ui__server/time__title' => 'システム時間',
    'ui__server/time__short-title' => 'システム時間',
    'ui__server/time__description' => 'NTP サーバとの同期設定、システム日時の変更を行う',
    'ui__server/maillists__title' => 'メーリングリストサーバのセットアップ', // PFU
    'ui__server/maillists__short-title' => 'メーリングリストサーバのセットアップ', // PFU
    'ui__server/maillists__description' => 'Mailman メーリングリストサーバを設定します。', // PFU
    'ui__mass-email__short-title' => "一括メールメッセージ", // PFW
    'ui__mass-email__title' => "一括メールメッセージ", // PFW
    'ui__mass-email__description' => "メールメッセージを複数のユーザ宛てに同時送信します。", // PFW
    'ui__mass-mail__title' => '一括メールメッセージ', // PFU
    'ui__mass-mail__short-title' => '一括メールメッセージ', // PFU
    'ui__mass-mail__description' => 'メールメッセージを複数のユーザ宛てに同時送信します。', // PFU
    'ui__server/spam-filter__title' => 'スパムフィルタ設定',
    'ui__server/spam-filter__short-title' => 'スパムフィルタ設定',
    'ui__server/spam-filter__description' => 'サーバ全体のスパムフィルタを設定する',
    'ui__server/preferences__title' => "サーバ設定",
    'ui__server/preferences__short-title' => "サーバ設定",
    'ui__server/preferences__description' => "サーバ全体の統計計算の設定、サーバのホスト名の変更、その他のサーバ設定の変更を行います。",

    // help & support
    // icons
    'ui__support__short-title' => 'サポート',
    'ui__support__title' => 'サポート',
    'ui__support__description' => 'テクニカルサポートにリクエストを送信するか、顧客からのサポートチケットを確認します。',
    'ui__license__short-title' => 'ライセンス情報',
    'ui__license__title' => 'Plesk ライセンス情報',
    'ui__license__description' => 'Plesk ライセンスの情報を表示し、新しいライセンスキーを注文します。',
    'ui__help__short-title' => 'ヘルプ',
    'ui__help__title' => 'オンラインヘルプ',
    'ui__help__description' => 'オンラインヘルプを表示する',
    'ui__news__short-title' => "最新情報",
    'ui__news__title' => "最新情報",
    'ui__news__description' => "このバージョンの Plesk における変更の一覧を示します。",
    'ui__server/autoinstaller__short-title' => 'アップデート',
    'ui__server/autoinstaller__title' => 'アップデート',
    'ui__server/autoinstaller__description' => 'Plesk およびそのコンポーネントを更新します。',
    // dropdowns

    // domains
    // icons
    'ui__client/domain_unknown__short-title' => 'ドメイン',
    'ui__client/domain_unknown__title' => 'ドメイン',
    'ui__client/domain_unknown__description' => 'ドメイン管理',
    'ui__server/skeleton__short-title' => '仮想ホストテンプレート',
    'ui__server/skeleton__title' => '仮想ホストテンプレート',
    'ui__server/skeleton__description' => '新しく作成するドメインのディレクトリに配置するファイルとフォルダを指定する',
    // dropdowns
    'ui__client/domain/chowner_multi-select__title' => '契約に新しい所有者の割り当て',
    'ui__client/domain/chowner_multi-select__short-title' => '新しい契約所有者の割り当て',
    'ui__client/domain/chowner_multi-select__description' => '選択した契約に新しい所有者の割り当て',
    'ui__client/domain/disable_multi__title' => 'ドメインを一時停止',
    'ui__client/domain/disable_multi__short-title' => 'ドメインを一時停止',
    'ui__client/domain/disable_multi__description' => '選択したドメインを一時停止',
    'ui__client/domain/enable_multi__title' => 'ドメインをアクティブ化',
    'ui__client/domain/enable_multi__short-title' => 'ドメインをアクティブ化',
    'ui__client/domain/enable_multi__description' => '選択したドメインをアクティブ化',

    // icons
    'ui__admin/extras-domain__short-title' => 'MyPlesk.com ツール',
    'ui__admin/extras-domain__title' => 'MyPlesk.com ツール',
    'ui__admin/extras-domain__description' => 'MyPlesk.com より拡張ツールとサービスを取得する',
    'ui__server/aspdotnet__short-title' => 'ASP.NET 設定', // PFW
    'ui__server/aspdotnet__title' => 'ASP.NET 設定', // PFW
    'ui__server/aspdotnet__description' => 'サーバ全体の ASP.NET 設定を行う', // PFW
    'ui__server/sitebuilder__short-title' => 'Presence Builder 設定', // PFU
    'ui__server/sitebuilder__title' => 'Presence Builder 設定', // PFU
    'ui__server/sitebuilder__description' => 'このサーバでホストされるウェブサイトの編集用に Presence Builder をセットアップします。', // PFU
    // dropdowns
    'ui__admin/register-domain__title' => 'ドメイン登録',
    'ui__admin/register-domain__short-title' => 'ドメイン登録',
    'ui__admin/register-domain__description' => 'MyPlesk.com でドメイン名を登録する',
    'ui__admin/manage-domain__title' => 'ドメイン管理',
    'ui__admin/manage-domain__short-title' => 'ドメイン管理',
    'ui__admin/manage-domain__description' => 'MyPlesk.com で登録ドメインを管理する',
    'ui__server/register__title' => 'サーバ登録',
    'ui__server/register__short-title' => 'サーバ登録',
    'ui__server/register__description' => 'サーバを登録してアフィリエイトプログラムに参加する',

    // logs & statistics
    // icons
    'ui__actionlog__short-title' => 'アクションログ',
    'ui__actionlog__title' => 'アクションログ',
    'ui__actionlog__description' => 'アクションログをダウンロードし、アクションログ設定を管理する',
    // dropdowns
    'ui__server/statistics__short-title' => 'サーバ情報',
    'ui__server/statistics__title' => 'サーバ情報',
    'ui__server/statistics__description' => 'Plesk で管理されているサービスの統計です。',
    'ui__admin/report__title' => '概要レポート',
    'ui__admin/report__short-title' => '概要レポート',
    'ui__admin/report__description' => 'リセラー、顧客、およびドメインのトラフィックとリソースの使用レポートを表示します。',

    // security
    // icons
    'ui__sessions/properties__short-title' => 'セッションアイドル時間',
    'ui__sessions/properties__title' => 'セッションアイドル時間',
    'ui__sessions/properties__description' => 'Plesk セッションのアイドル時間を設定します。',
    'ui__cp-access__short-title' => 'Plesk へのアクセス',
    'ui__cp-access__title' => 'Plesk へのアクセス',
    'ui__cp-access__description' => 'Plesk へのアクセスを制限する。',
    'ui__sessions__short-title' => 'アクティブセッション',
    'ui__sessions__title' => 'アクティブセッション',
    'ui__sessions__description' => 'アクティブな Plesk セッションを表示します。',
    // dropdowns
    'ui__server/certificate_unknown__title' => 'SSL/TLS 証明書',
    'ui__server/certificate_unknown__short-title' => 'SSL/TLS 証明書',
    'ui__server/certificate_unknown__description' => 'SSL/TLS 証明書の一覧。',

    // account
    // icons
    'ui__admin-info__short-title' => '個人データ',
    'ui__admin-info__title' => '個人データ',
    'ui__admin-info__description' => 'アカウントの個人データを変更する',
    'ui__admin-password__short-title' => 'パスワード変更',
    'ui__admin-password__title' => 'パスワード変更',
    'ui__admin-password__description' => 'アカウントのパスワードを変更する',
    // dropdowns

    ///
    /// END OF SERVER ADMINISTRATOR
    ///

    ///
    /// RESELLER
    ///

    // business objects

    // files
    // icons
    'ui__client/domain/hosting/protected-directories_unknown__short-title' => 'パスワード保護ディレクトリ',
    'ui__client/domain/hosting/protected-directories_unknown__title' => 'パスワード保護ディレクトリ',
    'ui__client/domain/hosting/protected-directories_unknown__description' => '選択したウェブサイトエリアへのアクセスを保護します。',
    'ui__client/domain/hosting/web-directories_unknown__title' => '仮想ディレクトリ', // PFW
    'ui__client/domain/hosting/web-directories_unknown__short-title' => '仮想ディレクトリ', // PFW
    'ui__client/domain/hosting/web-directories_unknown__description' => 'ウェブサイト下の物理ファイル/ディレクトリおよび仮想ファイル/ディレクトリについて作業を行います。', // PFW

    // statistics
    // icons
    'ui__reseller/limits__short-title' => 'リソース利用状況',
    'ui__reseller/limits__title' => 'リソース利用状況',
    'ui__reseller/limits__description' => 'リセラー %1 のリソース使用量を表示および管理する',
    'ui__reseller/limits_unknown__short-title' => 'リソース利用状況',
    'ui__reseller/limits_unknown__title' => 'リソース利用状況',
    'ui__reseller/limits_unknown__description' => 'リセラーのリソース使用量を表示および管理する',
    'ui__reseller/limits_self__short-title' => 'リソース利用状況',
    'ui__reseller/limits_self__title' => 'リソース利用状況',
    'ui__reseller/limits_self__description' => "リソース使用量を表示および管理する",
    'ui__reseller/limits_readonly-self__short-title' => 'リソース利用状況',
    'ui__reseller/limits_readonly-self__title' => 'リソース利用状況',
    'ui__reseller/limits_readonly-self__description' => "リソース使用状況を表示します。",
    'ui__reseller/client/traffic_unknown__short-title' => '顧客ごとのトラフィック使用量',
    'ui__reseller/client/traffic_unknown__title' => '顧客ごとのトラフィック使用量を表示',
    'ui__reseller/client/traffic_unknown__description' => '顧客アカウントのトラフィック使用量レポートを表示します。',
    'ui__client/traffic_unknown__short-title' => "顧客ごとのトラフィック使用量", // temporary for presets
    'ui__client/traffic_unknown__title' => "顧客ごとのトラフィック使用状況を表示", // temporary for presets
    'ui__client/traffic_unknown__description' => "顧客アカウントのトラフィック使用量レポートを表示します。", //  temporary for presets
    'ui__client/domain/hosting/logs_unknown__short-title' => 'ログマネージャ',
    'ui__client/domain/hosting/logs_unknown__title' => 'ログマネージャ',
    'ui__client/domain/hosting/logs_unknown__description' => 'ログを表示し、ログローテーションを設定する',
    // dropdowns
    'ui__reseller/report__title' => '概要レポート',
    'ui__reseller/report__short-title' => '概要レポート',
    'ui__reseller/report__description' => 'このリセラーのトラフィックおよびリソース使用量に関するレポートを表示する',
    'ui__reseller/report_unknown__title' => '概要レポート',
    'ui__reseller/report_unknown__short-title' => '概要レポート',
    'ui__reseller/report_unknown__description' => 'リセラーのトラフィックおよびリソース使用量レポートを表示する',
    'ui__reseller/report_self__title' => '概要レポート',
    'ui__reseller/report_self__short-title' => '概要レポート',
    'ui__reseller/report_self__description' => 'トラフィックおよびリソース使用量に関するレポートを表示する',

    // account
    // icons
    'ui__client/logo_reseller__title' => 'Plesk ブランディング',
    'ui__client/logo_reseller__short-title' => 'Plesk ブランディング',
    'ui__client/logo_reseller__description' => 'Plesk をリセラー %1 に合わせてリブランドします。',
    'ui__client/logo_unknown__title' => 'Plesk ブランディング', // temporary for presets
    'ui__client/logo_unknown__short-title' => 'Plesk ブランディング', // temporary for presets
    'ui__client/logo_unknown__description' => 'Plesk をリブランドします。', // temporary for presets
    'ui__client/logo_self-reseller__title' => 'Plesk ブランディング',
    'ui__client/logo_self-reseller__short-title' => 'Plesk ブランディング',
    'ui__client/logo_self-reseller__description' => 'Plesk をリブランドします。',
    'ui__reseller/permissions__title' => 'パーミッション',
    'ui__reseller/permissions__short-title' => 'パーミッション',
    'ui__reseller/permissions__description' => "リセラー %1 が Plesk で実行できるアクションを表示または変更します。",
    'ui__reseller/permissions_unknown__short-title' => 'パーミッション',
    'ui__reseller/permissions_unknown__title' => 'パーミッション',
    'ui__reseller/permissions_unknown__description' => "リセラーが Plesk で実行できるアクションを表示または変更します。",
    'ui__reseller/permissions_self__title' => 'パーミッション',
    'ui__reseller/permissions_self__short-title' => 'パーミッション',
    'ui__reseller/permissions_self__description' => 'Plesk で実行可能なアクションの一覧を表示します。',
    'ui__reseller/permissions_readonly-self__title' => 'パーミッション',
    'ui__reseller/permissions_readonly-self__short-title' => 'パーミッション',
    'ui__reseller/permissions_readonly-self__description' => 'Plesk で実行可能なアクションの一覧を表示します。',

    // domains
    // icons
    // Domains - see SERVER ADMINISTRATOR/DOMAINS
    // Domain Templates - see SERVER ADMINISTRATOR/DOMAINS
    'ui__client/skeleton__title' => '仮想ホストテンプレート',
    'ui__client/skeleton__short-title' => '仮想ホストテンプレート',
    'ui__client/skeleton__description' => '新しく作成するドメインのディレクトリに配置するファイルとフォルダを指定する',
    'ui__client/skeleton_unknown__short-title' => '仮想ホストテンプレート',
    'ui__client/skeleton_unknown__title' => '仮想ホストテンプレート',
    'ui__client/skeleton_unknown__description' => '新しく作成するドメインのディレクトリに配置するファイルとフォルダを指定する',

    // website
    // icons
    'ui__client/domain/domain-alias_unknown__short-title' => 'ドメインエイリアス',
    'ui__client/domain/domain-alias_unknown__title' => 'ドメインエイリアス',
    'ui__client/domain/domain-alias_unknown__description' => 'ドメインの別名リストを表示する',
    //dropdowns
    'ui__client/domain/dns_unknown__title' => 'DNS 設定',
    'ui__client/domain/dns_unknown__short-title' => 'DNS 設定',
    'ui__client/domain/dns_unknown__description' => 'ドメイン DNS ゾーン設定を管理',
    'ui__client/domain/dns_readonly-unknown__title' => 'DNS 設定',
    'ui__client/domain/dns_readonly-unknown__short-title' => 'DNS 設定',
    'ui__client/domain/dns_readonly-unknown__description' => 'ドメインの DNS ゾーン設定を表示します。',

    // applications & services
    // icons
    'ui__reseller/extras-domain__short-title' => 'MyPlesk.com ツール',
    'ui__reseller/extras-domain__title' => 'MyPlesk.com ツール',
    'ui__reseller/extras-domain__description' => 'MyPlesk.com より拡張ツールとサービスを取得する',
    'ui__reseller/extras-domain_unknown__short-title' => 'MyPlesk.com ツール',
    'ui__reseller/extras-domain_unknown__title' => 'MyPlesk.com ツール',
    'ui__reseller/extras-domain_unknown__description' => 'MyPlesk.com の拡張ツールとサービスを取得する',
    'ui__reseller/extras-domain_self__short-title' => 'MyPlesk.com ツール',
    'ui__reseller/extras-domain_self__title' => 'MyPlesk.com ツール',
    'ui__reseller/extras-domain_self__description' => 'MyPlesk.com より拡張ツールとサービスを取得する',
    'ui__reseller/register-domain__short-title' => 'ドメイン登録',
    'ui__reseller/register-domain__title' => 'ドメイン登録',
    'ui__reseller/register-domain__description' => 'MyPlesk.com でドメイン名を登録する',
    'ui__reseller/register-domain_unknown__short-title' => 'ドメイン登録',
    'ui__reseller/register-domain_unknown__title' => 'ドメイン登録',
    'ui__reseller/register-domain_unknown__description' => 'MyPlesk.com でドメイン登録する',
    'ui__reseller/register-domain_self__short-title' => 'ドメイン登録',
    'ui__reseller/register-domain_self__title' => 'ドメイン登録',
    'ui__reseller/register-domain_self__description' => 'MyPlesk.com でドメイン名を登録する',
    // dropdowns
    'ui__reseller/manage-domain__title' => 'ドメイン管理',
    'ui__reseller/manage-domain__short-title' => 'ドメイン管理',
    'ui__reseller/manage-domain__description' => 'MyPlesk.com で登録ドメインを管理する',
    'ui__reseller/manage-domain_unknown__title' => 'ドメイン管理',
    'ui__reseller/manage-domain_unknown__short-title' => 'ドメイン管理',
    'ui__reseller/manage-domain_unknown__description' => 'MyPlesk.com で登録したドメイン名を管理',
    'ui__reseller/manage-domain_self__title' => 'ドメイン管理',
    'ui__reseller/manage-domain_self__short-title' => 'ドメイン管理',
    'ui__reseller/manage-domain_self__description' => 'MyPlesk.com で登録ドメインを管理する',

    // additional tools
    // icons
    'ui__client/ipaddress_unknown-reseller__title' => 'IP アドレス',
    'ui__client/ipaddress_unknown-reseller__short-title' => 'IP アドレス',
    'ui__client/ipaddress_unknown-reseller__description' => 'IP アドレスを管理します。',
    'ui__client/domain/certificate_unknown__short-title' => 'SSL/TLS 証明書',
    'ui__client/domain/certificate_unknown__title' => 'SSL/TLS 証明書',
    'ui__client/domain/certificate_unknown__description' => 'SSL/TLS 証明書をインストール・管理します。',
    'ui__reseller/sessions__short-title' => 'アクティブセッション',
    'ui__reseller/sessions__title' => 'アクティブセッション',
    'ui__reseller/sessions__description' => 'アクティブな Plesk セッションを表示します。',
    'ui__reseller/sessions_unknown__short-title' => 'アクティブセッション',
    'ui__reseller/sessions_unknown__title' => 'アクティブセッション',
    'ui__reseller/sessions_unknown__description' => 'アクティブな Plesk セッションを表示します。',
    'ui__reseller/sessions_self__short-title' => 'アクティブセッション',
    'ui__reseller/sessions_self__title' => 'アクティブセッション',
    'ui__reseller/sessions_self__description' => 'アクティブな Plesk セッションを表示します。',

    ///
    /// END OF RESELLER
    ///

    ///
    /// CLIENT
    ///

    // business objects
    'mn_list__mail_names_for_client' => 'ユーザアカウント %1 のメールアカウント',

    // domains
    // icons
    // Domains - SERVER ADMINISTRATOR/DOMAINS
    // Domain Templates - SERVER ADMINISTRATOR/DOMAINS
    // Virtual host template - RESELLER/DOMAINS
    'ui__client/skeleton_self__short-title' => '仮想ホストテンプレート',
    'ui__client/skeleton_self__title' => '仮想ホストテンプレート',
    'ui__client/skeleton_self__description' => '新しく作成するドメインのディレクトリに配置するファイルとフォルダを指定する',
    // dropdowns
    // Create domain - see RESELLER/DOMAINS
    // Create domain template - see RESELLER/DOMAINS
    // Assign new owner for domains - see SERVER ADMINISTRATOR/DOMAINS
    // Convert Domain Administrator Accounts to Client Accounts - see SERVER ADMINISTRATOR/DOMAINS
    // Update Properties of Multiple Domains - see SERVER ADMINISTRATOR/DOMAINS

    // Suspend domains - see SERVER ADMINISTRATOR/DOMAINS
    // Activate domains - see SERVER ADMINISTRATOR/DOMAINS

    // mail
    // icons
    // Mail accounts - RESELLER/MAIL
    // Create mail account - RESELLER/MAIL
    // Create forwarder - RESELLER/MAIL
    // Create autoresponder - RESELLER/MAIL
    // Mailing lists - RESELLER/MAIL
    // Virus protection - RESELLER/MAIL
    // Spam filtering - RESELLER/MAIL
    // Open Webmail - RESELLER/MAIL
    // dropdowns
    // Mail settings - RESELLER/MAIL
    //Create mailing list - RESELLER/MAIL

    // files
    // icons
    // File manager - RESELLER/FILES
    // Anonymous FTP - RESELLER/FILES
    // FTP accounts - RESELLER/FILES    // PFW
    // SSH terminal - RESELLER/FILES    // PFU
    // Password protected directories - RESELLER/FILES
    // Virtual directories - RESELLER/FILES    // PFW
    // Web directories - RESELLER/FILES    // PFW

    // statistics
    // icons
    // Web statistics - RESELLER/STATISTICS
    'ui__client/limits__short-title' => 'リソース使用',
    'ui__client/limits__title' => 'リソース使用',
    'ui__client/limits__description' => "顧客 %1 のリソース使用量を表示および管理します。",
    'ui__client/limits_unknown__short-title' => 'リソース使用',
    'ui__client/limits_unknown__title' => 'リソース使用',
    'ui__client/limits_unknown__description' => '顧客のリソース使用量を表示および管理します。',
    'ui__client/limits_readonly__short-title' => 'リソース使用',
    'ui__client/limits_readonly__title' => 'リソース使用',
    'ui__client/limits_readonly__description' => '顧客 %1 のリソース使用量を表示します。',
    'ui__client/limits_self__short-title' => 'リソース使用',
    'ui__client/limits_self__title' => 'リソース使用',
    'ui__client/limits_self__description' => "リソース使用量の表示と管理",
    'ui__client/limits_readonly-self__short-title' => 'リソース使用',
    'ui__client/limits_readonly-self__title' => 'リソース使用',
    'ui__client/limits_readonly-self__description' => "リソース使用状況を表示します。",
    'ui__client/domain/traffic_unknown__short-title' => "ドメイン %1 のトラフィック使用量",
    'ui__client/domain/traffic_unknown__title' => "ドメインごとのトラフィック使用量を表示",
    'ui__client/domain/traffic_unknown__description' => "ドメインのトラフィック使用量レポートを表示する",
    // Log manager - RESELLER/STATISTICS
    // dropdowns
    'ui__client/report__title' => '概要レポート',
    'ui__client/report__short-title' => '概要レポート',
    'ui__client/report__description' => 'この顧客のトラフィックとリソースの使用レポートを表示します。',
    'ui__client/report_unknown__short-title' => '概要レポート',
    'ui__client/report_unknown__title' => '概要レポート',
    'ui__client/report_unknown__description' => '顧客のトラフィックとリソースの使用レポートを表示します。',
    'ui__client/report_self__short-title' => '概要レポート',
    'ui__client/report_self__title' => '概要レポート',
    'ui__client/report_self__description' => 'トラフィックおよびリソースの使用状況についてレポートを表示する',

    // account
    // icons
    'ui__client/preferences__short-title' => 'インターフェース設定',
    'ui__client/preferences__title' => 'インターフェース設定',
    'ui__client/preferences__description' => '顧客 %1 の Plesk インターフェース設定を行います。',
    'ui__client/preferences_unknown__short-title' => 'インターフェース設定',
    'ui__client/preferences_unknown__title' => 'インターフェース設定',
    'ui__client/preferences_unknown__description' => "顧客の Plesk にインターフェース設定を行います。",
    'ui__client/preferences_self__short-title' => 'インターフェース設定',
    'ui__client/preferences_self__title' => 'インターフェース設定',
    'ui__client/preferences_self__description' => 'Plesk のインターフェース設定を行います。',
    'ui__client/logo__title' => 'Plesk ブランディング',
    'ui__client/logo__short-title' => 'Plesk ブランディング',
    'ui__client/logo__description' => "顧客 %1 の Plesk をリブランドします。",
    'ui__client/logo_self__title' => 'Plesk ブランディング',
    'ui__client/logo_self__short-title' => 'Plesk ブランディング',
    'ui__client/logo_self__description' => 'Plesk のリブランディング - ロゴ画像とブラウザタイトルバーを変更します。',
    'ui__client/permissions__title' => 'パーミッション',
    'ui__client/permissions__short-title' => 'パーミッション',
    'ui__client/permissions__description' => "顧客 %1 が Plesk で実行できるアクションを表示または変更します。",
    'ui__client/permissions_unknown__short-title' => 'パーミッション',
    'ui__client/permissions_unknown__title' => 'パーミッション',
    'ui__client/permissions_unknown__description' => "顧客が Plesk で実行できるアクションを表示または変更します。",
    'ui__client/permissions_self__title' => 'パーミッション',
    'ui__client/permissions_self__short-title' => 'パーミッション',
    'ui__client/permissions_self__description' => "Plesk で実行可能なアクションの一覧を表示します。",
    'ui__client/permissions_readonly-self__title' => 'パーミッション',
    'ui__client/permissions_readonly-self__short-title' => 'パーミッション',
    'ui__client/permissions_readonly-self__description' => "Plesk で実行可能なアクションの一覧を表示します。",

    // website
    // icons
    // Edit in SiteBuilder - RESELLER/WEBSITE
    // Web hosting settings - RESELLER/WEBSITE
    // Subdomains - RESELLER/WEBSITE
    // Domain aliases - RESELLER/ADDITIONAL TOOLS
    // Frontpage Webadmin - RESELLER/WEBSITE
    // Frontpage SSL/TLS Webadmin - RESELLER/WEBSITE
    // Web users - RESELLER/WEBSITE
    // Site preview - RESELLER/WEBSITE
    // dropdowns
    // DNS settings - RESELLER/WEBSITE
    // Change hosting type - RESELLER/WEBSITE
    // FrontPage management - RESELLER/WEBSITE    // PFW
    // Create subdomain - RESELLER/WEBSITE

    // applications & services
    // icons
    // Web applications - RESELLER/APPLICATIONS & SERVICES
    'ui__client/extras-domain__short-title' => 'MyPlesk.com ツール',
    'ui__client/extras-domain__title' => 'MyPlesk.com ツール',
    'ui__client/extras-domain__description' => 'MyPlesk.com より拡張ツールとサービスを取得する',
    'ui__client/extras-domain_unknown__short-title' => 'MyPlesk.com ツール',
    'ui__client/extras-domain_unknown__title' => 'MyPlesk.com ツール',
    'ui__client/extras-domain_unknown__description' => 'MyPlesk.com の拡張ツールとサービスを取得する',
    'ui__client/extras-domain_self__short-title' => 'MyPlesk.com ツール',
    'ui__client/extras-domain_self__title' => 'MyPlesk.com ツール',
    'ui__client/extras-domain_self__description' => 'MyPlesk.com より拡張ツールとサービスを取得する',
    // Databases - RESELLER/APPLICATIONS & SERVICES
    // Java applications - RESELLER/APPLICATIONS & SERVICES    // PFU
    'ui__client/register-domain__title' => 'ドメイン登録',
    'ui__client/register-domain__short-title' => 'ドメイン登録',
    'ui__client/register-domain__description' => 'MyPlesk.com でドメイン名を登録する',
    'ui__client/register-domain_unknown__title' => 'ドメイン登録',
    'ui__client/register-domain_unknown__short-title' => 'ドメイン登録',
    'ui__client/register-domain_unknown__description' => 'MyPlesk.com でドメイン名登録する',
    'ui__client/register-domain_self__title' => 'ドメイン登録',
    'ui__client/register-domain_self__short-title' => 'ドメイン登録',
    'ui__client/register-domain_self__description' => 'MyPlesk.com でドメイン名を登録する',
    // dropdowns
    // Install web application - RESELLER/APPLICATIONS & SERVICES
    // Create database - RESELLER/APPLICATIONS & SERVICES
    // Create database user - RESELLER/APPLICATIONS & SERVICES
    // Install Java application - RESELLER/APPLICATIONS & SERVICES
    'ui__client/manage-domain__title' => 'ドメイン管理',
    'ui__client/manage-domain__short-title' => 'ドメイン管理',
    'ui__client/manage-domain__description' => 'MyPlesk.com で登録ドメインを管理する',
    'ui__client/manage-domain_unknown__title' => 'ドメイン管理',
    'ui__client/manage-domain_unknown__short-title' => 'ドメイン管理',
    'ui__client/manage-domain_unknown__description' => 'MyPlesk.com で登録したドメイン名を管理',
    'ui__client/manage-domain_self__title' => 'ドメイン管理',
    'ui__client/manage-domain_self__short-title' => 'ドメイン管理',
    'ui__client/manage-domain_self__description' => 'MyPlesk.com で登録ドメインを管理する',

    // additional tools
    // icons
    'ui__client/ipaddress_unknown__title' => 'IP アドレス',
    'ui__client/ipaddress_unknown__short-title' => "IP アドレス",
    'ui__client/ipaddress_unknown__description' => "IP アドレスを管理します。",
    'ui__client/domain/domain-alias_readonly-unknown__short-title' => 'ドメインエイリアス',
    'ui__client/domain/domain-alias_readonly-unknown__title' => 'ドメインエイリアス',
    'ui__client/domain/domain-alias_readonly-unknown__description' => 'ドメインの別名リストを表示する',
    // Scheduled tasks - RESELLER/ADDITIONAL TOOLS
    // SSL/TLS certificates - RESELLER/ADDITIONAL TOOLS
    'ui__client/sessions__short-title' => 'アクティブセッション',
    'ui__client/sessions__title' => 'アクティブセッション',
    'ui__client/sessions__description' => 'アクティブな Plesk セッションを表示します。',
    'ui__client/sessions_unknown__short-title' => 'アクティブセッション',
    'ui__client/sessions_unknown__title' => 'アクティブセッション',
    'ui__client/sessions_unknown__description' => 'アクティブな Plesk セッションを表示します。',
    'ui__client/sessions_self__short-title' => 'アクティブセッション',
    'ui__client/sessions_self__title' => 'アクティブセッション',
    'ui__client/sessions_self__description' => 'アクティブな Plesk セッションを表示します。',
    // Shared SSL/TLS - RESELLER/ADDITIONAL TOOLS    // PFW
    // ASP.NET settings - RESELLER/ADDITIONAL TOOLS    // PFW
    // PHP settings - RESELLER/ADDITIONAL TOOLS    // PFW
    // dropdowns
    //Schedule new task - RESELLER/ADDITIONAL TOOLS

    ///
    /// END OF CLIENT
    ///

    ///
    /// DOMAIN / DOMAIN ADMINISTRATOR
    ///

    // files
    // icons
    'ui__client/domain/hosting/protected-directories__short-title' => 'パスワード保護ディレクトリ',
    'ui__client/domain/hosting/protected-directories__title' => 'パスワード保護ディレクトリ',
    'ui__client/domain/hosting/protected-directories__description' => '選択したウェブサイトエリアへのアクセスを保護します。',
    'ui__client/domain/hosting/protected-directories_self__short-title' => 'パスワード保護ディレクトリ',
    'ui__client/domain/hosting/protected-directories_self__title' => 'パスワード保護ディレクトリ',
    'ui__client/domain/hosting/protected-directories_self__description' => '選択したウェブサイトエリアへのアクセスを保護します。',
    'ui__client/domain/hosting/web-directories__title' => '仮想ディレクトリ', // PFW
    'ui__client/domain/hosting/web-directories__short-title' => '仮想ディレクトリ', // PFW
    'ui__client/domain/hosting/web-directories__description' => 'サイト %1 下の物理ファイル/ディレクトリおよび仮想ファイル/ディレクトリについて作業を行います。', // PFW
    'ui__client/domain/hosting/web-directories_self__title' => '仮想ディレクトリ', // PFW
    'ui__client/domain/hosting/web-directories_self__short-title' => '仮想ディレクトリ', // PFW
    'ui__client/domain/hosting/web-directories_self__description' => 'ウェブサイト下の物理ファイル/ディレクトリおよび仮想ファイル/ディレクトリについて作業を行います。', // PFW

    // statistics
    // icons
    'ui__client/domain/traffic__short-title' => '%1 トラフィック使用',
    'ui__client/domain/traffic__title' => '<b>%1</b> のデータ転送統計',
    'ui__client/domain/traffic__description' => 'ドメイン %1 のデータ転送統計を表示します。',
    'ui__client/domain/traffic_self__short-title' => 'トラフィック使用',
    'ui__client/domain/traffic_self__title' => 'ドメインのトラフィック使用量を表示する',
    'ui__client/domain/traffic_self__description' => 'ドメインのトラフィック使用量レポートを表示する',
    'ui__client/domain/hosting/logs__short-title' => 'ログマネージャ',
    'ui__client/domain/hosting/logs__title' => 'ログマネージャ',
    'ui__client/domain/hosting/logs__description' => 'ログを表示し、ログローテーションを設定する',
    'ui__client/domain/hosting/logs_self__short-title' => 'ログマネージャ',
    'ui__client/domain/hosting/logs_self__title' => 'ログマネージャ',
    'ui__client/domain/hosting/logs_self__description' => 'ログを表示し、ログローテーションを設定する',

    // domain administration
    // dropdowns
    'ui__client/domain/rename__title' => 'ドメインの名称変更',
    'ui__client/domain/rename__short-title' => 'ドメイン名変更',
    'ui__client/domain/rename__description' => 'ドメイン %1 の名称変更',
    'ui__client/domain/rename_unknown__short-title' => 'ドメイン名の変更',
    'ui__client/domain/rename_unknown__title' => 'ドメイン名の変更',
    'ui__client/domain/rename_unknown__description' => 'ドメイン名の変更',
    'ui__client/domain/chowner_select__title' => 'ドメインに新しい所有者を割り当てる',
    'ui__client/domain/chowner_select__short-title' => '契約に新しい所有者の割り当て',
    'ui__client/domain/chowner_select__description' => '契約に新しい所有者の割り当て',
    'ui__client/domain/chowner_unknown-select__short-title' => '顧客に新しい所有者の割り当て',
    'ui__client/domain/chowner_unknown-select__title' => '顧客に新しい所有者の割り当て',
    'ui__client/domain/chowner_unknown-select__description' => '契約に新しい所有者の割り当て',
    'ui__client/domain/toggle__title' => 'ドメインを一時停止またはアクティブ化', // for HP customization
    'ui__client/domain/toggle__short-title' => 'ドメインを一時停止またはアクティブ化', // for HP customization
    'ui__client/domain/toggle__description' => 'ドメイン %1 を一時停止またはアクティブ化します。', // for HP customization
    'ui__client/domain/toggle_unknown__title' => 'ドメインを一時停止またはアクティブ化', // for HP customization
    'ui__client/domain/toggle_unknown__short-title' => 'ドメインを一時停止またはアクティブ化', // for HP customization
    'ui__client/domain/toggle_unknown__description' => 'ドメインを一時停止またはアクティブ化します。', // for HP customization
    'ui__client/domain/toggle_enable__title' => 'ドメインをアクティブ化',
    'ui__client/domain/toggle_enable__short-title' => 'ドメインをアクティブ化',
    'ui__client/domain/toggle_enable__description' => 'ドメイン %1 をアクティブ化します。',
    'ui__client/domain/toggle_disable__title' => 'ドメインを一時停止',
    'ui__client/domain/toggle_disable__short-title' => 'ドメインを一時停止',
    'ui__client/domain/toggle_disable__description' => 'ドメイン %1 を一時停止します。',

    // website
    // icons
    // dropdowns
    'ui__client/domain/dns__title' => 'DNS 設定',
    'ui__client/domain/dns__short-title' => 'DNS 設定',
    'ui__client/domain/dns__description' => 'ドメイン %1 のDNS ゾーンを管理する',
    'ui__client/domain/dns_self__title' => 'DNS 設定',
    'ui__client/domain/dns_self__short-title' => 'DNS 設定',
    'ui__client/domain/dns_self__description' => 'ドメイン DNS ゾーン %1 を管理',
    'ui__client/domain/dns_disabled__title' => 'DNS 設定',
    'ui__client/domain/dns_disabled__short-title' => 'DNS 設定',
    'ui__client/domain/dns_disabled__description' => 'ドメイン %1 のDNS ゾーンを管理します。',
    'ui__client/domain/dns_self-disabled__title' => 'DNS 設定',
    'ui__client/domain/dns_self-disabled__short-title' => 'DNS 設定',
    'ui__client/domain/dns_self-disabled__description' => 'ドメインの DNS ゾーン設定を管理する',
    'ui__client/domain/dns_readonly__title' => 'DNS 設定',
    'ui__client/domain/dns_readonly__short-title' => 'DNS 設定',
    'ui__client/domain/dns_readonly__description' => 'ドメイン %1 の DNS ゾーン設定を表示する',
    'ui__client/domain/dns_readonly-self__title' => 'DNS 設定',
    'ui__client/domain/dns_readonly-self__short-title' => 'DNS 設定',
    'ui__client/domain/dns_readonly-self__description' => 'ドメインの DNS ゾーン設定を表示する',
    'ui__client/domain/dns_readonly-self-disabled__title' => 'DNS 設定',
    'ui__client/domain/dns_readonly-self-disabled__short-title' => 'DNS 設定',
    'ui__client/domain/dns_readonly-self-disabled__description' => 'ドメインの DNS ゾーン設定を表示します。',
    'ui__client/domain/dns_readonly-self-slave__title' => 'DNS 設定',
    'ui__client/domain/dns_readonly-self-slave__short-title' => 'DNS 設定',
    'ui__client/domain/dns_readonly-self-slave__description' => 'ドメインの DNS ゾーン設定を表示する',
    'ui__client/domain/dns_slave__title' => 'DNS 設定',
    'ui__client/domain/dns_slave__short-title' => 'DNS 設定',
    'ui__client/domain/dns_slave__description' => 'ドメイン %1 の DNS ゾーン設定を管理する',
    'ui__client/domain/dns_self-slave__title' => 'DNS 設定',
    'ui__client/domain/dns_self-slave__short-title' => 'DNS 設定',
    'ui__client/domain/dns_self-slave__description' => 'ドメインの DNS ゾーン設定を管理する',
    // FrontPage management - RESELLER/WEBSITE    // PFW

    // applications & services
    // icons
    'ui__client/domain/extras__short-title' => 'MyPlesk.com ツール',
    'ui__client/domain/extras__title' => 'MyPlesk.com ツール',
    'ui__client/domain/extras__description' => 'MyPlesk.com より拡張ドメインツールおよびサービスを取得する',
    'ui__client/domain/extras_unknown__short-title' => 'MyPlesk.com のツール',
    'ui__client/domain/extras_unknown__title' => 'MyPlesk.com のツール',
    'ui__client/domain/extras_unknown__description' => 'MyPlesk.com の拡張ツールとサービスを取得する',
    'ui__client/domain/extras_self__short-title' => 'MyPlesk.com のツール',
    'ui__client/domain/extras_self__title' => 'MyPlesk.com のツール',
    'ui__client/domain/extras_self__description' => 'MyPlesk.com より拡張ドメインツールとサービスを取得する',
    // Java applications - RESELLER/APPLICATIONS & SERVICES    // PFU
    'ui__client/domain/register__short-title' => 'ドメイン登録',
    'ui__client/domain/register__title' => 'ドメイン登録',
    'ui__client/domain/register__description' => 'MyPlesk.com でドメインを登録する',
    'ui__client/domain/register_unknown__short-title' => 'ドメイン登録',
    'ui__client/domain/register_unknown__title' => 'ドメイン登録',
    'ui__client/domain/register_unknown__description' => 'MyPlesk.com でドメイン名登録する',
    'ui__client/domain/register_self__short-title' => 'ドメイン登録',
    'ui__client/domain/register_self__title' => 'ドメイン登録',
    'ui__client/domain/register_self__description' => 'MyPlesk.com を用いてドメイン登録する',
    // dropdowns
    // Create database user - RESELLER/APPLICATIONS & SERVICES

    // additional tools
    // icons
    // Domain aliases - RESELLER/ADDITIONAL TOOLS
    // Scheduled tasks - RESELLER/ADDITIONAL TOOLS    // PFU
    // SSL/TLS certificates - RESELLER/ADDITIONAL TOOLS
    // dropdowns


    ///
    /// END OF DOMAIN / DOMAIN ADMINISTRATOR
    ///

    ////
    //// KEYS FOR BUSINESS OBJECT LISTS/PAGES (RESELLERS, CLIENTS, DOMAINS)
    ////

    ///
    /// DOMAINS
    ///

    // Domains list page title - ui__client/domain_unknown__short-title (HOME)

    // tools
    'ui__client/domain#tools__title' => "ツール",
    // Below: TBD
    'ui__client/domain-summary-report_unknown__short-title' => '統計の表示',
    'ui__client/domain-summary-report_unknown__title' => '統計の表示',
    'ui__client/domain-summary-report_unknown__description' => 'ドメイン別のリソース使用量に関する情報を表示します。',
    'ui__client/domain-summary-report__short-title' => "統計の表示",
    'ui__client/domain-summary-report__title' => "統計の表示",
    'ui__client/domain-summary-report__description' => "ドメイン別のリソース使用量に関する情報を表示します。",
    'ui__client/domain-summary-report_self__short-title' => "統計の表示",
    'ui__client/domain-summary-report_self__title' => "統計の表示",
    'ui__client/domain-summary-report_self__description' => "ドメインのリソース使用量に関する情報を表示する",
    // Traffic usage - ui__client/domain/traffic_unknown__short-title

    'ui__client/domain#list__title' => "ドメイン", // DOMAINS

    // list object operation errors
    'ui__client/domain/delete__empty_selection' => '削除したいドメインを選択する必要があります。',
    'ui__client/domain/chowner__empty_selection' => '新しい所有者を割り当てたいドメインを選択する必要があります。',

    // list objects filtering
    'domains_list__name__filter_title' => '名前',
    'domains_list__state__filter_title' => 'リソース利用状況',
    'domains_list__filter_state_any' => 'すべて',
    'domains_list__filter_state_overuse' => '利用超過',
    'domains_list__filter_state_normal' => '制限内',
    'domains_list__status__filter_title' => 'ステータス',
    'domains_list__filter_status_any' => 'すべて',
    'domains_list__filter_status_blocked' => '一時停止',
    'domains_list__filter_status_active' => 'アクティブ',
    'domains_list__ownership__filter_title' => '所有者',
    'domains_list__filter_ownership_all' => 'すべてのドメイン',
    'domains_list__filter_ownership_personal' => 'マイ・ドメインのみ',
    'domains_list__filter_owner_pname__filter_title' => '所有者名',
    'domains_list__subrows__filter_title' => '表示する',
    'domains_list__subrows_off' => 'ドメインのみ',
    'domains_list__subrows_subdomain_domainaliases' => 'サブドメインおよびアカウントを含む',
    'domains_list__subrows_subdomain' => 'サブドメインを含む',
    'domains_list__subrows_domainaliases' => 'エイリアスを含む',

    // objects list
    'domains_list__owner__title' => '所有者',

    ///
    /// END OF DOMAINS
    ///

    ////
    //// KEYS FOR APPLICATION VAULT AND WEB APPLICATION MANAGEMENT
    ////

    ///
    /// APPLICATION VAULT / APS CATALOG
    ///

    // Application Vault / APS Catalog promotional block
    'site_apps__promo_browse_for_applications' => "アプリケーションを探す",
    'site_apps__promo_main_text' => "APS（Application Packaging Standard）カタログには、ドメインまたはウェブスペースに導入できるアプリケーションの一覧が含まれています。カタログにないアプリケーションを導入したい場合は、www.apsstandard.com の指示に従って簡単に APS パッケージングできます。",
    'site_apps__promo_download_now' => "ダウンロードするアプリケーション:",
    'site_apps__promo_close' => "このブロックを閉じる",
    'site_apps__promo_preset__mostused' => '最も使われている %1 件',
    'site_apps__promo_preset__lessused' => '次に最も使われている %1 件',
    'site_apps__promo_preset__all' => "すべて",
    'site_apps__promo_disclaimer_note' => 'APS カタログからインストール可能なアプリケーションはサードパーティ製であり、Plesk ではサポートを提供いたしません。',
    'site_apps__promo_preset__page_title' => '%1 APS アプリケーション',

    // Progress bar
    'site_apps__progress_initialization_message' => 'アプリケーション追加中...',

    // Errors
    'site_apps__no_applications_for_update' => 'アプリケーションヴォルトにアプリケーションがインストールされていません',
    'site_apps__incorrect_download_preset_configuration' => 'APS カタログダウンロードプリセットの設定にエラーが見つかりました',
    'site_apps__aps_catalog_url_is_invalid' => '指定した URL が空です',
    'site_apps__no_updates_at_the_moment' => '現在利用可能なアプリケーションアップデートがありません',
    'site_apps__incorrect_content_returned_by_catalog' => 'APS アプリケーションカタログより無効な情報を取得しました。再度実行してください',
    'site_apps__entered_aps_catalog_url_is_not_valid' => 'APS カタログ設定が保存されましたが、Plesk は APS カタログ設定（%1）に指定された APS カタログへの接続を確立できません。APS カタログアドレスが正しく、このアドレスの APS カタログがアクティブであることを確認してください。',
    'site_apps__cannot_retrieve_updates' => 'アプリケーションアップデートをダウンロードできません。APS カタログ（%1）への接続を確立できません。APS カタログのアドレスが正しく、このアドレスの APS カタログが有効であることを確認してください。',
    'site_apps__no_site_applications_in_client_pool_to_install' => 'インストールできるウェブアプリケーションがありません',
    'site_apps__site_applications_already_installed_in_root' => 'これらの仮想ホストのルートディレクトリには他のウェブアプリケーションが既にインストールされています。',
    'site_apps__dot_net_packages_not_supported_on_unix_platform' => ".NET Web アプリケーションは Unix/Linux プラットフォームではサポートされていません",
    'site_apps__server_wide_packages_not_supported' => 'サーバ全体のウェブアプリケーションはサポートされていません',
    'site_apps__applications_added_to_queue_for_adding_to_application_vault' => "%1 ウェブアプリケーションのヴォルト追加がスケジュールされています。",
    'site_apps__applications_all_in_vault' => "選択したウェブアプリケーションはアプリケーションヴォルトに既に存在します。",
    'site_apps__applications_already_in_download_queue' => "%1 ウェブアプリケーションが、アプリケーションヴォルトへと追加されようとしています。",
    'site_apps__applications_already_in_valut' => "%1 ウェブアプリケーションは、既にアプリケーションヴォルト上に存在します。",

    // UI errors

    ///
    /// END OF APPLICATION VAULT / APS CATALOG
    ///

    ///
    /// APS CATEGORIES
    ///

    // General
    'site_apps__not_categorized' => 'その他（未分類）',

    // Errors
    'site_apps__no_applications_in_category' => 'このカテゴリに利用可能なアプリケーションがありません。他のカテゴリを選択してください',
    'site_apps__no_category_selected__please_specify' => '左側のメニューにてカテゴリを選択する。選択したカテゴリで利用可能なアプリケーションが、このウインドウ上に表示されます。',

    // Category: Back office
    // Category: Collaboration
    // Category: Front Office
    // Category: Infrastructure
    // Category: Personal
    // Category: Web

    ///
    /// END OF APS CATEGORIES
    ///

    ///
    /// APPLICATION VAULT
    ///

    //removal


    ///
    /// END OF APPLICATION VAULT
    ///

    ////
    //// KEYS FOR SETTINGS PAGE
    ////

    ///
    /// SERVER ADMINISTRATOR SETTINGS
    ///

    'administrator_account' => '管理者アカウント',
    // Personal data - HOME/SERVER ADMINISTRATOR/ACCOUNT
    // Change password - HOME/SERVER ADMINISTRATOR/ACCOUNT
    // Interface preferences - HOME/SERVER ADMINISTRATOR/ACCOUNT

    'general' => '全般',
    // Server settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_change_hostname' => 'ホスト名を変更',
    // System time - HOME/SERVER ADMINISTRATOR/SERVER
    // IP addresses - HOME/SERVER ADMINISTRATOR/SERVER
    // Scheduled tasks - HOME/SERVER ADMINISTRATOR/SERVER
    // FTP settings - HOME/SERVER ADMINISTRATOR/SERVER    // PFW

    'security' => 'セキュリティ',
    'bt_setup_firewall' => 'ファイアウォールの設定',
    'bt_manage_firewall_rules' => 'ファイアウォールルールを管理',
    'cu_firewall__rule' => 'ファイアウォールルールを作成',
    'cu_firewall__protocol' => 'ルールのプロトコルを設定（「tcp」または「udp」）',
    'cu_firewall__name' => "ルール名を設定",
    'cu_firewall__disabled' => '「true」の場合、作成後にルールが無効になります。',
    // Session idle time - HOME/SERVER ADMINISTRATOR/SECURITY
    // SSL/TLS certificates - HOME/SERVER ADMINISTRATOR/SECURITY
    // Shared SSL/TLS - HOME/SERVER ADMINISTRATOR/SECURITY    // PFW

    'dns' => 'DNS',
    'bt_select_dns_server' => 'DNS サーバの選択', // PFW
    'bt_soa_records_template' => 'SOA レコードテンプレート',
    'bt_restrict_creation_of_subzones' => 'サブゾーン作成の制限',

    'databases' => 'データベース',
    // Database hosting preferences - HOME/SERVER ADMINISTRATOR/SERVER

    'applications' => 'アプリケーション',
    // ASP.NET settings - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES    // PFW
    // IIS application pool - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES    // PFW
    // SiteBuilder settings - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES

    'mail' => 'メール',
    'bt_select_mailserver' => 'メールサーバの選択', // PFW
    // Mail server settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_select_antivirus' => 'アンチウイルスの選択', // PFW
    'bt_virus_protection_settings' => 'ウイルス防御設定',
    'bt_select_spamfilter' => 'スパムフィルタを選択する', // PFW
    // Spam filter settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_select_webmail' => 'ウェブメールの選択',
    // Set up mailing lists server - HOME/SERVER ADMINISTRATOR/SERVER    // PFU

    'logs_and_statistics' => 'ログと統計',
    'bt_server_statistics_settings' => 'サーバ統計の設定',
    'bt_select_web_statistics' => '利用可能なウェブ統計ソフトウェア', // PFW
    // Action log - HOME/SERVER ADMINISTRATOR/LOGS & STATISTICS

    'control_panel_interface' => 'Plesk インターフェース',

    'components_and_modules' => 'コンポーネント & モジュール',
    // Server components - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_setup_watchdog' => 'Watchdog の設定', // PFU
    'bt_setup_vpn' => 'VPN の設定', // PFU
    'bt_setup_samba' => 'samba の設定',    // PFU

    ///
    /// END OF SERVER ADMINISTRATOR SETTINGS
    ///

    ///
    /// DOMAIN SETTINGS
    ///

    'ui__client/domain/settings_self__title' => '設定',
    'ui__client/domain/settings_self__short-title' => '設定',
    'ui__client/domain/settings_self__description' => 'ドメイン設定の表示と変更',

    'domain_administrator_account' => 'ドメイン管理者アカウント',
    // Interface preferences - HOME/DOMAIN ADMINISTRATOR/DOMAIN
    'bt_account_settings' => 'アカウント設定',

    'domain' => 'ドメイン',
    'bt_dns_soa_records' => 'DNS SOA レコード',
    // Mail settings - HOME/DOMAIN ADMINISTRATOR/MAIL
    'bt_task_scheduler_settings' => 'タスクスケジューラ設定',

    'website' => 'ウェブサイト',
    // Web hosting settings - HOME/DOMAIN ADMINISTRATOR/WEBSITE
    // Bandwidth limiting - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS
    'bt_web_users_scripting' => 'ウェブユーザ用スクリプティング',
    // Anonymous FTP - HOME/DOMAIN ADMINISTRATOR/FILES

    // Applications - SETTINGS/SERVER/APPLICATIONS    // PFW
    // ASP.NET settings - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW
    // PHP settings - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW
    // IIS application pool - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW

    // Security - SETTINGS/SERVER/SECURITY
    // Password protected directories - HOME/DOMAIN ADMINISTRATOR/FILES
    'bt_select_ssl_certificate' => 'SSL/TLS 証明書を選択',
    // Shared SSL/TLS - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW

    // Logs & statistics - SETTINGS/SERVER/LOGS & STATISTICS
    'bt_web_statistics' => 'ウェブ統計',
    'bt_log_rotation_settings' => 'ログローテーション設定',

    ///
    /// END OF DOMAIN SETTINGS
    ///

    ////
    //// KEYS FOR LIMITS AND PERMISSIONS
    ////

    ///
    /// LIMITS
    ///

    '__limits' => "上限", // template

    // overuse & oversell
    'limits__overuse_oversell_policy_legend' => "利用超過および販売超過ポリシー",
    'limits__overuse_policy_legend' => "利用超過",
    'limits__oversell_policy_legend' => "販売超過",
    'limits__reseller_overuse_description' => "Plesk は利用超過ポリシーにより、リソースの利用超過が発生したときにどのように処理するかを判断します。",
    'limits__overuse_text' => "利用超過ポリシー",

    // limit names
    'limit_group__disk_space_and_traffic' => 'ディスクスペースとトラフィック',
    'limit__disk_space' => 'ディスクスペース',
    'limit__max_traffic' => 'トラフィック',
    'limit_group__client' => '顧客',
    'limit__max_cl' => '顧客',
    'limit_group__domain' => 'ドメイン',
    'limit__max_dom' => 'ドメイン',
    'limit__max_dom_powerUser' => '契約',
    'limit__max_subdom' => 'サブドメイン',
    'limit__max_dom_aliases' => 'ドメインエイリアス',
    'limit__max_wu' => 'ウェブユーザ',
    'limit__max_subftp_users' => '追加 FTP アカウント', // PFW
    'limit_group__mail' => 'メール',
    'limit__max_box' => 'メールボックス',
    'limit__mbox_quota' => 'メールボックスサイズ',
    'limit__total_mboxes_quota' => '総メールボックスクォータ', // PFW
    'limit__max_maillists' => 'メーリングリスト',
    'limit_group__database' => 'データベース',
    'limit__max_mssql_db' => 'Microsoft SQL サーバデータベース', // PFW
    'limit__mssql_dbase_space' => '合計 MS SQL データベースクォータ', // PFW
    'limit__max_odbc' => 'ODBC 接続', // PFW
    // limit__max_db - CONFLICTED
    'limit__mysql_dbase_space' => 'MySQL データベースクォータ', // PFW?
    'limit_group__application' => 'アプリケーション',
    'limit__max_iis_app_pools' => 'IIS アプリケーションプール', // PFW
    'limit_group__security' => 'セキュリティ',
    'limit_group__validity' => '有効期限',
    'limit__expiration' => '有効期限',
    'limit__validity' => '有効期限',
    'limit__max_site_builder' => 'Presence Builder で公開するサイト数',
    'limit__max_site' => 'ドメイン',
    'limit__mssql_dbase_filesize' => 'MS SQL データベースファイルサイズ',
    'limit__mssql_dbase_log_filesize' => 'MS SQL データベースのログファイルサイズ',
    'limit__mssql_dbase_filesize_hint' => 'Microsoft SQL データベースのファイルの最大サイズ。',
    'limit__mssql_dbase_log_filesize_hint' => 'Microsoft SQL データベースのログファイルの最大サイズ。',
    'limit__units_mssql_dbase_filesize' => "MB",
    'limit__units_mssql_dbase_log_filesize' => "MB",

    'dom_pref__invalid_max_site_limit' => '無効なドメイン上限です。 最小値は 1 です。',

    'property__has_wrong_value' => 'プロパティ %1 の値が正しくありません。',
    'property__name_outgoing_messages_domain_limit' => 'ドメインからの送信メッセージ数の上限（1 時間あたり）を設定します。無制限に設定するには、"-1" を指定します。サーバ全体の設定に指定された値を設定するには、"default" を指定します。',
    'property__name_outgoing_messages_mbox_limit' => 'メールボックスからの送信メッセージ数の上限（1 時間あたり）を設定します。無制限に設定するには、"-1" を指定します。サーバ全体の設定に指定された値を設定するには、"default" を指定します。',
    'property__name_outgoing_messages_subscription_limit' => '契約からの送信メッセージ数の上限（1 時間あたり）を設定します。無制限に設定するには、"-1" を指定します。サーバ全体の設定に指定された値を設定するには、"default" を指定します。',

    // for CLI report & email notifications
    '__resource_notify' => '通知',
    '__general' => '全般',
    '__template_shared' => '共有テンプレート',
    'limit__overuse' => '利用超過ポリシー',
    'limit__max_traffic_soft' => 'トラフィック使用量が上限に達したら通知する',
    'limit__disk_space_soft' => 'ディスクスペース使用量が上限に達したら通知する',
    '__overuse' => '利用超過ポリシー',
    'performance__title' => 'パフォーマンス',
    'performance__bandwidth' => '帯域幅使用率の上限（KB/s）',
    'performance__max_connections' => '接続数の上限',

    'gch__hosting_php_isapi' => 'PHP を ISAPI 拡張として実行',
    'gch__hosting_ssi_html' => 'SSI を *.htm、*.html ファイルで使用',
    'gch__hosting_php_handler_type' => 'PHP の実行タイプ',
    'gch__hosting_php_handler_id' => 'PHP の実行タイプ',
    'gch__hosting_php_served_by_nginx' => 'PHP を nginx で処理',
    'gch__hosting_unpaid_website_status' => '一時停止中の契約に含まれるウェブサイトのステータス',
    'gch__mn_no_autoresponder' => 'メールアカウントに自動応答が設定されていません',
    'gch__no_clients_selected' => "顧客アカウントが選択されていません",
    'gch__no_domains_selected' => "ドメインが選択されていません",

    // limit units
    'limit__units_disk_space' => "MB",
    'limit__units_max_traffic' => "MB/月",
    'limit__units_mbox_quota' => "KB",
    'limit__units_mysql_dbase_space' => "MB", // PFW
    'limit__units_mssql_dbase_space' => "MB", // PFW
    'limit__units_total_mboxes_quota' => "MB", // PFW

    // manipulations and statuses of limits
    '__resource_name' => 'リソース名',
    '__resource_usage' => '使用中',
    '__resource_limit' => '上限',

    '__used' => '使用中',
    '__limit' => '上限',

    '__never_expires' => '無期限',
    '__resource_free' => '%2 のうち残り %1',
    '__resource_unlimited' => '%1 使用中',

    '__unlimited' => '無制限',
    '__increment' => "増加（+）",
    '__decrement' => "減少（-）",
    '__pt' => '単位',
    '__procent' => '%',
    '__overused' => '利用超過',
    '__left' => '左',
    '__available' => '使用可能',
    '__not_available' => '含まれない',

    ///
    /// END OF LIMITS
    ///

    ///
    /// PERMISSIONS
    ///

    //permissions hints

    ///
    /// END OF PERMISSIONS
    ///

    ////
    //// KEYS FOR STATISTICS AND REPORTS
    ////

    ///
    /// REPORT
    ///

    // administrator

    'ui__admin/report/traffic-history__short-title' => 'トラフィック履歴を表示',
    'ui__admin/report/traffic-history__title' => 'トラフィック履歴を表示',
    'ui__admin/report/traffic-history__description' => 'リセラー、顧客、およびドメインのトラフィック履歴を表示します。',
    'admin_traffic_history__title' => '転送量履歴',

    'ui__admin/report/layout/auto_unknown__short-title' => '配信スケジュール',
    'ui__admin/report/layout/auto_unknown__title' => 'レポート配信スケジュール',
    'ui__admin/report/layout/auto_unknown__description' => 'レポートレイアウトのレポート配信スケジュールを選択します。',
    'ui__admin/report/layout/auto/properties_new__short-title' => 'レポート配信スケジュールを追加',
    'ui__admin/report/layout/auto/properties_new__title' => 'レポート配信スケジュールを追加',
    'ui__admin/report/layout/auto/properties_new__description' => 'レポート %1 のレポート配信スケジュールを作成します。',
    'ui__admin/report/layout/auto/properties__short-title' => 'レポート配信スケジュール',
    'ui__admin/report/layout/auto/properties__title' => 'レポート配信スケジュール',
    'ui__admin/report/layout/auto/properties__description' => 'レポート配信スケジュールのプロパティを表示および変更します。',
    'ui__admin/report/layout/auto/delete_multi__short-title' => 'レポート配信スケジュールの削除',
    'ui__admin/report/layout/auto/delete_multi__title' => 'レポート配信スケジュールの削除',
    'ui__admin/report/layout/auto/delete_multi__description' => '選択したレポート配信スケジュールを削除します。',

    'ui__admin/report/layout_unknown__short-title' => 'レポートレイアウト',
    'ui__admin/report/layout_unknown__title' => 'レポートレイアウト',
    'ui__admin/report/layout_unknown__description' => 'レポートレイアウトの表示と管理',
    'ui__admin/report/layout/properties_unknown-new__short-title' => 'レポートレイアウトの作成',
    'ui__admin/report/layout/properties_unknown-new__title' => 'レポートレイアウトの作成',
    'ui__admin/report/layout/properties_unknown-new__description' => 'レポートレイアウトを作成します。',
    'ui__admin/report/layout/delete_multi__short-title' => 'レポートレイアウトの削除',
    'ui__admin/report/layout/delete_multi__title' => 'レポートレイアウトの削除',
    'ui__admin/report/layout/delete_multi__description' => '選択したレポートレイアウトの削除',
    'ui__admin/report/layout/properties__short-title' => 'プロパティ',
    'ui__admin/report/layout/properties__title' => 'レポートレイアウトプロパティ',
    'ui__admin/report/layout/properties__description' => 'レポートレイアウトプロパティの編集',

    // reseller
    'reseller_traffic_history__title' => "リセラー %1 の転送量履歴",

    'ui__reseller/traffic__short-title' => '%1',
    'ui__reseller/traffic__title' => '<b>%1</b> のトラフィック使用量を表示',
    'ui__reseller/traffic__description' => 'リセラーアカウント %1 のトラフィック使用量レポートを表示する',
    'ui__reseller/traffic_self__short-title' => '自分の',
    'ui__reseller/traffic_self__title' => '顧客ごとのトラフィック使用量を表示',
    'ui__reseller/traffic_self__description' => '顧客アカウントのトラフィック使用量レポートを表示します。',

    'ui__reseller/report/traffic-history__short-title' => 'トラフィック履歴を表示する',
    'ui__reseller/report/traffic-history__title' => 'トラフィック履歴を表示する',
    'ui__reseller/report/traffic-history__description' => "リセラー %1 のトラフィック履歴を表示する",
    'ui__reseller/report/traffic-history_self__short-title' => 'トラフィック履歴を表示',
    'ui__reseller/report/traffic-history_self__title' => 'トラフィック履歴を表示',
    'ui__reseller/report/traffic-history_self__description' => 'トラフィック履歴を表示します。',

       ///
    /// END OF REPORT
    ///

    ///
    /// SUMMARY / FULL REPORT
    ///

    // common full report
    'report__full_p' => 'P',
    'report__full_s' => 'S',
    'report__full_h' => 'H',
    'report__full_reseller_name' => 'リセラー名', // reseller report
    'report__full_client_name' => '顧客名', // customer report
    'report__full_domain_name' => 'ドメイン名', // domain report
    'report__full_owner' => '所有者', // customer & domain reports
    'report__full_creation_date' => '作成日',
    'report__full_size' => 'サイズ',
    'report__full_traffic' => 'トラフィック',
    'report__full_active_clients' => 'アクティブな顧客', // reseller report
    'report__full_clients' => '顧客', // reseller report
    'report__full_active_domains' => 'アクティブドメイン', // reseller & customer reports
    'report__full_domains' => 'ドメイン', // reseller & customer reports
    'report__full_subdomains' => 'サブドメイン',
    'report__full_mboxes' => 'メールボックス',
    'report__full_disk_space' => 'ディスクスペース',
    'report__full_mail_groups' => 'MForw',
    'report__full_mail_autoresp' => '応答',
    'report__full_mail_antispam' => 'ASpam',
    'report__full_mail_antivirus' => 'AVir',
    'report__full_mail_lists' => 'メーリングリスト',
    'report__full_web_users' => 'ウェブユーザ',
    'report__full_mysql_databases' => 'MySQL DB',
    'report__full_mssql_databases' => 'MSSQL DB',

    // common summary report
    'report__section_general' => '全般',
    'report__version' => '製品バージョン',
    'report__build' => '製品ビルド',
    'report__status' => 'ステータス',
    'report__company_name' => '会社名',
    'report__personal_name' => '個人名',
    'report__login' => 'ユーザ名',
    'report__phone' => '電話',
    'report__fax' => 'ファックス',
    'report__email' => 'メール',
    'report__address' => 'アドレス',
    'report__city' => '市区町村',
    'report__state' => '都道府県',
    'report__zip_code' => '郵便番号',
    'report__country' => '国',
    'report__creation_date' => '作成日',
    'report__expiration_date' => '有効期限',
    'report__dumps_total_size' => '総バックアップファイルサイズ',
    'report__section_resellers' => 'リセラー',
    'report__active_resellers' => '契約が有効なリセラー',
    'report__resellers' => 'リセラー',
    'report__section_full_resellers' => 'リセラー',
    'report__section_clients' => '顧客',
    'report__active_clients' => '契約が有効な顧客',
    'report__clients' => '顧客',
    'report__section_full_clients' => '顧客',
    'report__section_personal_clients' => '自社の顧客',
    'report__active_personal_clients' => '契約が有効な自社の顧客',
    'report__personal_clients' => '自社の顧客',
    'report__section_full_personal_clients' => '自社の顧客',
    'report__section_domains' => 'ドメイン',
    'report__disk_usage' => 'ディスク使用量',
    'report__traffic' => 'トラフィック',
    'report__active_domains' => 'アクティブドメイン',
    'report__domains' => 'ドメイン',
    'report__subdomains' => 'サブドメイン',
    'report__mboxes' => 'メールボックス',
    'report__mail_groups' => 'メール転送',
    'report__mail_autoresp' => '自動応答',
    'report__mail_lists' => 'メーリングリスト',
    'report__web_users' => 'ウェブユーザ',
    'report__mysql_databases' => 'MySQL データベース',
    'report__mssql_databases' => 'MSSQL データベース',
    'report__section_full_domains' => 'ドメイン',
    'report__section_personal_domains' => '個人ドメイン',
    // keys here are the same as in report__section_domains section
    'report__section_full_personal_domains' => '個人ドメイン',

    //New for Plesk 10
    'report__sitebuilder_sites' => 'Presence Builder で公開するサイト数',
    'report__invalid_email' => '有効なメールアドレスを入力してください。',


    // CLI-specific sections
    'report__section_hosting' => 'ホスティング',
    'report__section_webusers' => 'ウェブユーザ',
    'report__section_mailnames' => 'メールアカウント',
    'report__section_maillists' => 'メーリングリスト',
    'report__section_databases' => 'データベース',
    'report__section_siteapps' => 'ウェブアプリケーション',
    'report__section_aspnetapps' => 'ASP.NET アプリケーション', // PFW
    'report__owner_pname' => "プロバイダの個人名",
    'report__owner_login' => "プロバイダのユーザ名",

    ///
    /// END OF SUMMARY / FULL REPORT
    ///

    'ui__reseller/report/layout/auto_unknown__short-title' => '配信スケジュール',
    'ui__reseller/report/layout/auto_unknown__title' => 'レポート配信スケジュール',
    'ui__reseller/report/layout/auto_unknown__description' => 'レポートレイアウトのレポート配信スケジュールを選択します。',
    'ui__reseller/report/layout/auto/properties_new__short-title' => 'レポート配信スケジュールを追加',
    'ui__reseller/report/layout/auto/properties_new__title' => 'レポート配信スケジュールを追加',
    'ui__reseller/report/layout/auto/properties_new__description' => 'レポート %1 のレポート配信スケジュールを作成します。',
    'ui__reseller/report/layout/auto/properties__short-title' => 'レポート配信スケジュール',
    'ui__reseller/report/layout/auto/properties__title' => 'レポート配信スケジュール',
    'ui__reseller/report/layout/auto/properties__description' => 'レポート配信スケジュールのプロパティを表示および変更します。',
    'ui__reseller/report/layout/auto/delete_multi__short-title' => 'レポート配信スケジュールの削除',
    'ui__reseller/report/layout/auto/delete_multi__title' => 'レポート配信スケジュールの削除',
    'ui__reseller/report/layout/auto/delete_multi__description' => '選択したレポート配信スケジュールを削除します。',

    'ui__reseller/report/layout_unknown__short-title' => 'レポートレイアウト',
    'ui__reseller/report/layout_unknown__title' => 'レポートレイアウト',
    'ui__reseller/report/layout_unknown__description' => 'レポートレイアウトの表示と管理',
    'ui__reseller/report/layout/properties_unknown-new__short-title' => 'レポートレイアウトの作成',
    'ui__reseller/report/layout/properties_unknown-new__title' => 'レポートレイアウトの作成',
    'ui__reseller/report/layout/properties_unknown-new__description' => 'レポートレイアウトを作成します。',
    'ui__reseller/report/layout/properties_new__short-title' => 'レポートレイアウトの作成',
    'ui__reseller/report/layout/properties_new__title' => 'レポートレイアウトの作成',
    'ui__reseller/report/layout/properties_new__description' => 'レポートレイアウトを作成します。',
    'ui__reseller/report/layout/delete_multi__short-title' => 'レポートレイアウトの削除　',
    'ui__reseller/report/layout/delete_multi__title' => 'レポートレイアウトの削除',
    'ui__reseller/report/layout/delete_multi__description' => '選択したレポートレイアウトの削除',
    'ui__reseller/report/layout/properties__short-title' => 'プロパティ',
    'ui__reseller/report/layout/properties__title' => 'レポートレイアウトプロパティ',
    'ui__reseller/report/layout/properties__description' => 'レポートレイアウトプロパティの編集',

    // customer
    'cl_traffic_history__title' => "顧客 %1 のトラフィック履歴",

    'ui__client/traffic__short-title' => '%1',
    'ui__client/traffic__title' => '<b>%1</b> のトラフィック使用量を表示',
    'ui__client/traffic__description' => '顧客アカウント%1 のトラフィック使用量レポートを表示します。',
    'ui__client/traffic_self__short-title' => 'トラフィック使用',
    'ui__client/traffic_self__title' => 'ドメインごとのトラフィック使用量',
    'ui__client/traffic_self__description' => 'ドメインのトラフィック使用量レポートを表示します。',

    'ui__client/report/traffic-history__short-title' => 'トラフィック履歴を表示',
    'ui__client/report/traffic-history__title' => 'トラフィック履歴を表示',
    'ui__client/report/traffic-history__description' => '顧客 %1 のトラフィック履歴を表示します。',
    'ui__client/report/traffic-history_self__short-title' => 'トラフィック履歴を表示',
    'ui__client/report/traffic-history_self__title' => 'トラフィック履歴を表示',
    'ui__client/report/traffic-history_self__description' => 'トラフィック履歴を表示します。',

    ////
    //// KEYS FOR VARIOUS FEATURES
    ////

    ///
    /// SERVER INTERFACE
    ///

    // Locales
    // errors
    'locales__not_allowed' => '指定した言語パックはインストールされていますが、システムで有効化されていません。',

    ///
    /// END OF SERVER INTERFACE
    ///

    ///
    /// HOME PAGE CUSTOMIZATION
    ///

    ///
    /// SESSIONS
    ///

    // Entry keys are under respective HP/ADDITIONAL TOOLS/ACTIVE SESSIONS

    // administrator
    'ui__sessions/delete__short-title' => 'セッション削除',
    'ui__sessions/delete__title' => 'セッション削除',
    'ui__sessions/delete__description' => '選択したセッションの削除',
    'ui__ftp-sessions__short-title' => 'FTP セッション',
    'ui__ftp-sessions__title' => 'FTP セッション',
    'ui__ftp-sessions__description' => 'FTP セッションを表示します。',
    'ui__ftp-sessions/delete__short-title' => 'FTP セッションの削除',
    'ui__ftp-sessions/delete__title' => 'FTP セッションの削除',
    'ui__ftp-sessions/delete__description' => '選択した FTP セッションの削除',

    // reseller
    'ui__reseller/sessions/delete__short-title' => 'セッションの削除',
    'ui__reseller/sessions/delete__title' => 'セッションの削除',
    'ui__reseller/sessions/delete__description' => '選択したセッションの削除',
    'ui__reseller/sessions/delete_self__short-title' => 'セッションの削除',
    'ui__reseller/sessions/delete_self__title' => 'セッションの削除',
    'ui__reseller/sessions/delete_self__description' => '選択したセッションの削除',
    'ui__reseller/ftp-sessions__short-title' => 'FTP セッション',
    'ui__reseller/ftp-sessions__title' => 'FTP セッション',
    'ui__reseller/ftp-sessions__description' => 'FTP セッションを表示します。',
    'ui__reseller/ftp-sessions_self__short-title' => 'FTP セッション',
    'ui__reseller/ftp-sessions_self__title' => 'FTP セッション',
    'ui__reseller/ftp-sessions_self__description' => 'FTP セッションを表示します。',
    'ui__reseller/ftp-sessions/delete__short-title' => 'FTP セッションの削除',
    'ui__reseller/ftp-sessions/delete__title' => 'FTP セッションの削除',
    'ui__reseller/ftp-sessions/delete__description' => '選択した FTP セッションの削除',
    'ui__reseller/ftp-sessions/delete_self__short-title' => 'FTP セッションの削除',
    'ui__reseller/ftp-sessions/delete_self__title' => 'FTP セッションの削除',
    'ui__reseller/ftp-sessions/delete_self__description' => '選択した FTP セッションの削除',

    // customer
    'ui__client/sessions/delete__short-title' => 'セッションの削除',
    'ui__client/sessions/delete__title' => 'セッションの削除',
    'ui__client/sessions/delete__description' => '選択したセッションの削除',
    'ui__client/sessions/delete_self__short-title' => 'セッションの削除',
    'ui__client/sessions/delete_self__title' => 'セッションの削除',
    'ui__client/sessions/delete_self__description' => '選択したセッションの削除',

    // domain administrator

    'forgery_token_expired' => 'セッショントークンの期限が切れました。',

    ///
    /// END OF SESSIONS
    ///

    ///
    /// USER ACCOUNT CONVERSION
    ///

    //
    // USER ACCOUNT TYPE CHANGES
    //

    // resellers > customers
    'downgradeResellers__downgrade_resellers' => '以下のリセラーアカウントを顧客アカウントに変換します。',
    'downgradeResellers__downgrade' => '変換されるリセラーアカウント',
    // controls
    'downgradeResellers__submit_downgrade' => 'アカウント変換を実行する',
    'downgradeResellers__cancel_downgrade' => 'アカウント変換のキャンセル',
    'downgradeResellers__confirm' => '変換の確認',
    'downgradeResellers__confirm_message' => 'アカウント変換の続行を確認する',
    // errors

    // customers > resellers
    'picker_client_multi__title' => '顧客アカウントの選択',
    'upgradeClients__upgrade_clients' => '以下の顧客アカウントをリセラーアカウントに変換します。',
    'upgradeClients__upgrade' => '変換される顧客アカウント',
    // controls
    'upgradeClients__submit_upgrade' => 'アカウント変換を実行する',
    'upgradeClients__cancel_upgrade' => 'アカウント変換をキャンセルする',
    'upgradeClients__confirm' => '変換の確認',
    'upgradeClients__confirm_message' => 'アカウント変換の続行を確認する',
    // errors
    'upgradeClient__user_is_already_reseller' => 'アカウント \'%1\' をリセラーアカウントに変換することができません。\'%1\' は既にリセラーです。',

    // domain administrators > customers
    'upgradeDomainUser__upgrade_domain_users' => '以下のドメイン管理者アカウントが顧客アカウントに変換されます。',
    'upgradeDomainUser__upgrade' => 'ドメイン管理者アカウントは変換されます。',
    // controls
    'upgradeDomainUser__submit_upgrade' => 'アカウント変換を実行する',
    'upgradeDomainUser__cancel_upgrade' => 'アカウント変換のキャンセル',
    'upgradeDomainUser__confirm' => '変換の確認',
    'upgradeDomainUser__confirm_message' => 'アカウント変換の続行を確認する',
    // errors
    'upgradeDomainUser__non_upgradeable' => 'ドメイン管理者アカウントを変換できません',
    'upgradeDomainUser__non_upgradeable_domain_users' => '以下のドメイン管理者アカウントは顧客アカウントに変換できません。',
    'upgradeDomainUser__some_domains_were_not_converted' => '顧客アカウントに変換できないドメイン管理者アカウントがあります。 %%domainsList%%',
    'upgradeDomainUser__domain_user_does_not_exist' => 'ドメイン管理者アカウントが存在しません',
    'upgradeDomainUser__domain_owner_must_be_a_reseller' => "サーバ管理者またはリセラーに直接属するドメイン",
    'upgradeDomainUser__all_logins_already_used' => 'その顧客用のアカウントを作成できません',
    // notifications
    'upgradeDomainUser__upgrade_notification_subject' => 'ドメイン管理者アカウントを変換しました',
    'upgradeDomainUser__upgrade_notification_body' => 'ドメイン管理者アカウントを顧客アカウントに変換しました。 ログイン名「%%login%%」、パスワード「%%password%%」です。',

    //
    // USER ACCOUNT OWNER CHANGES
    //

    // Customer owner change
    // customers selection - reseller & admin home
    'picker_client__title' => '顧客アカウントの選択',
    // errors
    'clientOwnerChanger__owner_has_no_permission' => '選択したリセラーにパーミッション \'%1\' がありませんが、一部の顧客はこのパーミッションを付与されています。',
    'clientOwnerChanger__application_not_allowed' => '選択したリセラーがアプリケーション \'%1\' を使用できませんが、一部の顧客は使用することができます。',

    // Domain owner change
    'ui__client/domain/chowner_multi-select__wizard-title' => '選択した契約の再割り当て',
    // errors
    'domain_chown__empty_selection' => '選択したドメインの新しい所有者を選択する必要があります。',



    //
    // USER ACCOUNT STATE CHANGES
    //


    ///
    /// END OF USER ACCOUNT CONVERSION
    ///

    ///
    /// BANDWIDTH LIMITING
    ///

    'hosting_performance__traffic_bandwidth_label' => '帯域幅使用率の上限（%1）',
    'hosting_performance__max_connection_label' => '接続数の上限',
    'performance__invalid_value' => "無効な値です。%1 から %2 の値を指定してください",

    ///
    /// END OF BANDWIDTH LIMITING
    ///

    ///
    /// WEBMAIL SELECTION (these keys are currently PfU-only)
    ///

    'webmail__server_legend' => 'ウェブメール',
    'webmail__server_text' => '使用可能なウェブメールクライアント',
    'webmail__none' => 'なし',

    ///
    /// END OF WEBMAIL SELECTION
    ///


    ////
    //// BACKUP/RESTORATION
    ////

    // random common keys:
    'backup__ip_mapping__server_ip' => 'サーバ IP プール',

    ///
    /// END OF BACKUP MANAGER ACTIONS
    ///

    ///
    /// LISTS
    ///


    // Common info/errors:
    'migration_db_server_not_find' => 'データベースは復元されません。適合するデータベースサーバがありません',

    ///
    /// END OF LISTS
    ///

    ///
    /// COMMON SCREENS
    ///

    // Back Up
    // Comments - __comments
    '__default_backup_comment_server' => "サーババックアップ",
    '__default_backup_comment_reseller' => "リセラーアカウントのバックアップが %1 によって作成されました。",
    '__default_backup_comment_client' => "顧客アカウントのバックアップが %1 によって作成されました。",
    '__default_backup_comment_domain' => "契約のバックアップが %1 によって作成されました。",

    // Restoration & backup information

    // IP mapping
    'backup__ip_mapping__title' => 'IP アドレスマッピングの定義',
    'backup__ip_mapping__download' => '現在の IP マッピングをファイルに保存',
    'b_backup__ip_mapping__download' => 'IP マッピング設定をダウンロードします。',
    'b_backup__ip_mapping__download_is_empty' => 'IP マッピング設定が空です',
    'backup__ip_mapping_upload__title' => 'IP マッピングファイルをアップロード',
    'backup__ip_mapping__upload' => 'IP マッピングファイルをアップロード',
    'b_backup__ip_mapping__upload' => 'IP マッピング設定をアップロードします。',
    'backup__ip_mapping__list__header' => 'IP マッピング',
    'backup__ip_mapping__list__adddress' => '古い IP アドレス',
    'backup__ip_mapping__list__select_ip' => '新しい IP アドレス',
    'backup__ip_mapping__clients_ip' => "顧客 %1 の IP プール",
    'backup__ip_mapping__resellers_ip' => "リセラー %1 の IP プール",
    'backup__ip_mapping__exclusive_ip_must_be_unique' => '専用 IP アドレスは一意の IP アドレスにのみマッピングする必要があります。一覧内のそれぞれの専用 IP アドレスに対して一意の IP アドレスを選択してください。',
    'backup__ip_mapping__legend' => 'IP マッピング',
    'backup__ip_mapping__upload_legend' => 'アップロード',
    'backup__ip_mapping__upload_file_text' => 'IP マッピングファイル',
    'backup__ip_mapping__upload_file_hint' => 'IP マッピングファイルはテキストファイルです。ファイルの各行ごとに、IP のマッピングを次の形式で指定してください。<old IP address> <new IP address>',
    'backup__ip_mapping__ip_address_not_found' => 'このタイプの IP アドレスには空きがありません。',
    'backup__ip_mapping__ip_address_not_found_hint' => 'データを移管できません。IP アドレスのマッピングが不完全です。宛先サーバ上のプールに空き IP アドレスがありません。',
    'backup__ip_mapping__ftp_will_be_disabled' => 'この IP アドレスのドメインでは、非セキュア FTP 接続は禁止されています。',
    'backup__ip_mapping__ftps_will_be_disabled' => 'この IP アドレスのドメインでは、セキュア FTPS 接続は禁止されています。',

    // Conflicts occured
    'legend_conflicts_occured' => '競合',
    'backup__restore__object_vhost' => '仮想ホスト',
    'backup__restore__object_plesk_admin' => 'Plesk 管理者',
    'backup__restore__object_ftpuser' => 'FTP アカウント',
    'backup__restore__object_frontpageuser' => 'Frontpage アカウント',
    'backup__restore__object_webuser' => 'ウェブユーザ',
    'backup__restore__object_domain' => 'ドメイン',
    'backup__restore__object_subdomain' => 'サブドメイン',
    'backup__restore__object_domainalias' => 'ドメインエイリアス',
    'backup__restore__object_client' => '顧客',
    'backup__restore__object_reseller' => 'リセラー',
    'backup__restore__object_autoresponder' => '自動応答',
    'backup__restore__object_mailalias' => 'メールエイリアス',
    'backup__restore__object_database' => 'データベース',
    'backup__restore__object_mailname' => 'メールアカウント',
    'backup__restore__object_db_user' => 'データベースユーザ',
    'backup__restore__object_ssl_certificate' => 'SSL/TLS 証明書',
    'backup__restore__resellers_cannot_restore_converted_to_customers' => '以下のリセラーは顧客に変換されたため、復元することはできません。\'%1\'。',
    'backup__restore__customers_cannot_restore_converted_to_resellers' => '以下の顧客はリセラーに変換されたため、復元することはできません。\'%1\'。',
    'backup__restore__customers_cannot_restore_moved_to_another_owners' => '以下の顧客は別の所有者に移管されたため、復元することはできません：%1',

    // Before migration starts
    'backup__restore__capability_not_enough_disk_text' => '選択した契約すべてを移管するには、宛先サーバのディスクスペースが不十分です。使用可能：%1 MB。必要：%2 MB。必要なスペースは、ドメインのウェブ、メール、データベースコンテンツを合計して計算します。必要なスペースは 1 日 1 回計算され、キャッシュに保存されるため、ドメインの実際のサイズは計算されたサイズと異なる場合があります。選択したドメインが空き容量以上のスペースを占有しないことを確認したら、移管に進みます。',
    'backup__restore__capability_not_enough_disk_resolution' => '宛先サーバでディスクスペースを開放してください。',
    'backup__restore__capability_source_not_enough_disk_text' => 'ソースサーバのディスクスペースに、転送用の一時ファイルを保存できる十分な容量がありません。空き： %1 MB、必要： %2 MB。',
    'backup__restore__capability_source_not_enough_disk_resolution' => 'ソースサーバでディスクスペースを開放してください。',
    'backup__restore__capability_not_enough_disk_resolution_url_text' => 'サーバ情報',

    'backup__restore__capability_not_installed_component_text' => '宛先サーバにコンポーネント %1 がインストールされていません。復元したすべてのオブジェクトで %1 が使用できなくなります。',
    'backup__restore__capability_not_installed_component_resolution' => '%1 をインストールしてください。数分かかる可能性があります。',
    'backup__restore__capability_existing_sys_user_text' => '名前が %1 のシステムユーザは宛先サーバに既に存在します。',
    'backup__restore__capability_existing_sys_user_resolution' => '宛先サーバで既存のシステムユーザの名前を変更してください。',
    'backup__restore__capability_license_usage_text' => 'データ転送後に、ライセンスキーに定義されている以下のリソース制限が宛先サーバで超過します。',
    'backup__restore__capability_license_usage_resolution' => '必要な量のリソースを提供できる別のライセンスキーを宛先サーバにインストールしてください。',
    'backup__restore__capability_max_allowed_packet_text' => "ソースデータベースサーバの「max_allowed_packet」パラメータが、宛先サーバの %2 より大きい %1 に設定されています。以下に指定されたドメイン用のいくつかのデータベースオブジェクトが復元されない可能性があります。",
    'backup__restore__capability_max_allowed_packet_resolution' => "宛先データベースサーバで「max_allowed_packet」値を増加させてください。",

    'backup__restore__capability_postgres_to_lower_version_text' => 'PostgreSQL データベースを転送できません。宛先サーバの PostgreSQL バージョンが、ソースサーバより古くなっています。現在のバージョンは %1 ですが、バージョン %2 を使用する必要があります。',
    'backup__restore__capability_postgres_to_lower_version_text_resolution' => '必要なバージョンの PostgreSQL を宛先サーバにインストールしてください。',
    'backup__restore__capability_db_server_connection_problems' => '宛先 PostgreSQL データベースサーバに接続できません。接続を修復しなければ、データベースを転送できません。',
    'backup__restore__capability_db_server_connection_problems_resolution' => '宛先データベースサーバの接続設定を確認してください。',
    'backup__restore__capability_component_not_enabled_server_wide_text' => '宛先サーバでコンポーネント %1 がオフになっています。',
    'backup__restore__capability_component_not_enabled_server_wide_resolution' => '宛先サーバで %1 をオンにしてください。',
    'backup__restore__capability_not_configured_component_text' => '宛先サーバでコンポーネント %1 が構成されていません。',
    'backup__restore__capability_not_configured_component_resolution' => '［ツールと設定］ページで %1 を構成してください。',

    'backup__restore__capability_webmail_is_not_available' => '宛先サーバに %1 ウェブメールサービスがありません。このサービスの代わりに、ウェブメールサービス %2 が使用されます。',
    'backup__restore__capability_webmail_is_not_available_resolution' => 'ソースサーバと同じウェブメールを使用するには、このサーバにもインストールする必要があります。',
    'backup__restore__capability_webmail_is_not_installed_resolution' => 'ソースサーバと同じウェブメールを使用するには、宛先サーバもこのウェブメールをインストールする必要があります。',
    'backup__restore__capability_webmail_is_not_available_changed_on_subscriptions' => "宛先サーバに '%1' ウェブメールがありません。このサービスの代わりに、契約 %3 ではウェブメールサービス %2 が使用されます。",
    'backup__restore__capability_webmail_is_not_installed_custom_resolution' => '必要なウェブメールを宛先サーバにインストールしてください。',
    'backup__restore__capability_webmail_is_not_available_url_text' => 'ウェブメール設定',

    'backup__restore__capability_shell_is_not_available' => '宛先サーバにシェル %1 がありません。代わりに、いずれかの使用可能なシェルが使用されます。',
    'backup__restore__capability_shell_is_not_available_resolution' => 'ソースサーバと同じシェルを使用するには、/etc/shells でオンにするか、宛先サーバにインストールする必要があります。',

    'backup__restore__capability_acl_network_not_allowed_dns_template' => '宛先 DNS サーバは、転送制限テンプレート内のネットワークをサポートしません。DNS 転送制限内のネットワーク IP アドレスを持つレコードは復元されません。',
    'backup__restore__capability_acl_network_not_allowed_dns_zone' => '宛先 DNS サーバは転送制限テンプレート内のネットワークをサポートしませんが、一部の契約に DNS 転送制限内のネットワークがあります。DNS 転送制限内のネットワーク IP アドレスを持つレコードは復元されません。',

    'backup__restore__capability_wrong_php_handler_text' => '宛先サーバに PHP ハンドラ %1 がありません。代わりに、PHP ハンドラ %2 が使用されます。',
    'backup__restore__capability_wrong_php_handler_resolution' => 'ソースサーバと同じ%1を使用するには、宛先サーバでオンにするか宛先サーバにインストールする必要があります。',
    'bu_conflict_resolver_php_handler_replaced_in_plans' => 'PHP ハンドラ %1 は使用できません。代わりに、以下のサービスプランに対して %2 が使用されます。{{objects}}',
    'bu_conflict_resolver_php_handler_replaced_in_sites' => 'PHP ハンドラ %1 は使用できません。代わりに、以下のウェブサイトに対して %2 が使用されます。{{objects}}',
    'bu_conflict_resolver_php_handler_not_allowed_in_sites' => 'PHP ハンドラ %1 は利用できません。次のウェブサイトで利用不可になります： {{objects}}',

    'backup__restore__capability_wrong_component_version_text' => '宛先サーバに %1 %2 がありません。代わりに、デフォルトバージョンが使用されます。',
    'backup__restore__capability_wrong_component_version_resolution' => 'ソースサーバと同じ%1を使用するには、宛先サーバでオンにするかインストールする必要があります。',

    'backup__restore__capability_antivirus_not_allowed_outgoing_text' => '宛先サーバのアンチウイルス使用ポリシーでは、送信メールに対する個人的な（メールアドレスごとの）アンチウイルス設定は許可されていません。これらの設定は転送されません。',
    'backup__restore__capability_antivirus_not_allowed_incoming_text' => '宛先サーバのアンチウイルス使用ポリシーでは、受信メールに対する個人的な（メールアドレスごとの）アンチウイルス設定は許可されていません。これらの設定は転送されません。',
    'backup__restore__capability_antivirus_not_allowed_personal_settings_text' => '宛先サーバのアンチウイルス使用ポリシーでは、個人的な（メールアドレスごとの）アンチウイルス設定は許可されていません。これらの設定は転送されません。',
    'backup__restore__capability_antivirus_not_allowed_personal_settings_resolution' => "個人的な（メールアドレスごとの）アンチウイルス設定を転送するには、［ツールと設定］>［ウイルス防御設定］で該当するオプションをオンにしてください。",
    'backup__restore__capability_antivirus_not_active_text' => 'オンになっているアンチウイルスソフトウェアがありません。宛先サーバでアンチウイルスソフトウェアを選択するまで、ソースサーバのすべてのアンチウイルス設定が機能しません。',
    'backup__restore__capability_antivirus_not_active_resolution' => 'アンチウイルスソフトウェアを［ツールと設定］>［ウイルス防御設定］>［アンチウイルス設定］セクションで選択してください。',

    'backup__restore__capability_antivirus_another_active_text' => 'アンチウイルスソフトウェア %2 が宛先サーバ上にありません。代わりに %1 が使用されます。',
    'backup__restore__capability_antivirus_another_active_resolution' => 'ソースサーバと同じアンチウイルスを使用するには、［ツールと設定］>［ウイルス防御設定］>［アンチウイルス設定］セクションで選択してください。',
    'backup__restore__capability_not_available_sni_text' => '宛先サーバが SNI に対応していません。同じ IP アドレスを持つ複数のウェブサイトで異なる SSL/TLS 証明書を使用することはできません。',
    'backup__restore__capability_not_available_sni_resolution' => "宛先サーバの OS が SNI に対応していること、および Plesk で SNI サポートがオンになっていることを確認してください（［ツールと設定］>［サーバ設定］の［SNI サポートを有効にして、同じ IP アドレスを持つ複数のウェブサイトで異なる SSL/TLS 証明書を使用できるようにする］）。",
    'backup__restore__capability_not_available_sni_resolution_url_text' => 'サーバ設定',

    'backup__restore__capability_vhost_already_exists_text' => 'ウェブサイト %1 を移管できません。同じ名前のウェブサイトは宛先サーバに既に存在します。',
    'backup__restore__capability_vhost_already_exists_resolution' => '同じ名前のウェブサイトの名前を変更するか、サーバから削除してください。',
    'backup__restore__capability_removed_vhosts' => '次の契約には、宛先サーバに既に存在するドメイン名が含まれているため、復元されません。%1',
    'backup__restore__capability_duplicate_php_handler_text' => 'ソースサーバに、タイプ %1、バージョン %2 の PHP ハンドラが %3 個あります。宛先サーバではこれらの代わりに、該当するタイプとバージョンのハンドラが 1 つ使用されます。ソースサーバと宛先サーバで PHP 設定が異なる可能性があります。',

    'backup__restore__capability_not_installed_frontpage_resolution' => 'Plesk Installer は Microsoft Frontpage をサポートしません。',
    'backup__restore__capability_not_installed_python_resolution' => 'Plesk Installer は Python をサポートしていません。Python は手動でインストールしてください。',

    'backup__restore__capability_mail_spamfilter_domain_keys_resolution_url_text' => 'メールサーバ設定',

    'backup__restore__capability_ftps_disabled' => 'セキュア FTPS の使用は、ソースサーバでは許可され、宛先サーバでは禁止されています。FTP を使用するユーザのアプリケーションが正しく機能しない可能性があります。',
    'backup__restore__capability_ftps_required' => '非セキュア FTP の使用は、ソースサーバでは許可され、宛先サーバでは禁止されています。FTP を使用するユーザのアプリケーションが正しく機能しない可能性があります。',
    'backup__restore__capability_ftps_policy_resolution' => '［ツールと設定］>［セキュリティポリシー］でセキュア FTP ポリシーを変更してください。',

    'backup__restore__capability_too_much_download_time_text' => '%1 メガバイトのデータが %2 時間以内にソースサーバから宛先サーバへ移動されます。',
    'backup__restore__capability_too_much_download_time_resolution' => '転送を高速化するためには、ソースサーバと宛先サーバの間のネットワーク接続を確認し、（もしあれば）問題を解決してください。',
    'backup__restore__too_low_download_speed' => "0.01 未満",
    'backup__restore__capability_too_slow_download_speed_resolution' => '転送を高速化するためには、ソースサーバと宛先サーバの間のネットワーク接続を確認し、（もしあれば）問題を解決してください。',
    'backup__restore__capability_zero_download_speed_text' => '許容される最低限のダウンロード速度は %1 MBps ですが、ソースサーバと宛先サーバの間のダウンロード速度は 0 MBps です。ネットワーク接続に問題がある可能性があります。移管はできません。',
    'backup__restore__capability_zero_download_speed_resolution' => 'ソースサーバと宛先サーバの間のネットワーク接続をチェックしてください。',
    'backup__restore__capability_too_slow_download_speed_text' => '許容される最低限のダウンロード速度は %2 MBps で、ソースサーバと宛先サーバの間のダウンロード速度は %1 MBps です。この結果、移管の所要時間が長くなる可能性があります。現在の環境では、%3 MB の移行には %4 時間かかります。',
    'backup__restore__capability_too_slow_download_speed_text_without_diskusage' => '許容される最低限のダウンロード速度は %2 MBps で、ソースサーバと宛先サーバの間のダウンロード速度は %1 MBps です。この結果、移管の所要時間が長くなる可能性があります。',

    'backup__restore__capability_remote_database_migration' => "次のドメインはリモートデータベースを使用しています。%1",
    'backup__restore__capability_remote_database_migration_resolution' => "ソースサーバの Plesk が 11.5 より前のバージョンである場合、移管後にソースサーバからこれらのドメインを削除しないでください。代わりに、一時停止するようにしてください。ドメインを削除してしまうと、データベースがリモートサーバから削除されます。注：リモートデータベースのダンプファイルは、ソースサーバの %1 ディレクトリに保存されます。",

    'backup__restore__capability_mysql_50_to_51_migration' => 'MySQL 5.1.x では Unicode 文字の処理方法が異なるため、バージョン 5.1 より古い MySQL データベースサーバのバックアップファイル（%1）は MySQL 5.1.x に復元できない可能性があります。',
    'backup__restore__capability_mysql_50_to_51_migration_resolution' => '',
    'backup__restore__capability_mysql_50_to_51_migration_kb_link_title' => '関連する KB 記事 #136850 を参照してください。',

    'backup__restore__capability_courier_not_installed_text' => 'Courier-IMAP が宛先サーバにインストールされていません。',
    'backup__restore__capability_courier_not_installed_resolution' => 'Plesk Installer を使用して、Courier-IMAP をインストールしてください。',
    'backup__restore__capability_dovecot_not_installed_text' => 'Dovecot が宛先サーバにインストールされていません。',
    'backup__restore__capability_dovecot_not_installed_resolution' => 'Plesk Installer を使用して Dovecot をインストールしてください。',

    'backup__restore__wrong_stat_ttl_value_text' => '以下のオブジェクトの構成に設定されているトラフィック統計の保持時間が、宛先サーバ全体での設定よりも短くなっています。',
    'backup__restore__wrong_stat_ttl_value_resolution' => '宛先サーバでの統計情報保持時間に対するサーバ全体の値を変更してください。この時間は、ドメイン構成での最小値以下に設定してください。',
    'bu_conflict_resolver_wrong_stat_ttl_value' => '一部のドメインのトラフィック統計保持時間がサーバ全体の値（%1）より短くなっています。これらのドメインに対して値が %1 に変更されます。',
    'bu_conflict_resolver_wrong_stat_ttl_template_value' => '一部のサービスプランのトラフィック統計を保持する期間が、サーバ全体の値（%1）より短くなっています。これらのサービスプランに対し、この値が %1 に変更されます。',

    'backup__ip_mapping__map_dedicated_to_shared_ip' => '専用 IP アドレスから共用アドレスへのマッピングによって、匿名 FTP および HTTPS が無効になります（SNI サポートが有効な場合を除く）。',

    'backup__restore__no_postgresql_commands_text' => 'この契約はリモート PostgreSQL データベースを使用します。ソースサーバに pg_dump および psql コマンドがないため、その一時バックアップファイルを生成することができません。',
    'backup__restore__no_postgresql_commands_resolution' => 'これらのコマンドをサポートする PostgreSQL クライアントパッケージをインストールしてください。',
    'backup__restore__capability_apache_modules_disabled_text' => '次の Apache モジュールが宛先サーバで無効になっています。%1。',
    'backup__restore__capability_apache_modules_disabled_resolution' => '問題を回避するには、これらのモジュールを有効化してください。',
    'backup__restore__capability_apache_modules_not_installed_text' => '次の Apache モジュールが宛先サーバにインストールされていません。%1。',
    'backup__restore__capability_apache_modules_not_installed_resolution' => '問題を回避するには、これらのモジュールをインストールして有効化してください。',

    'backup__restore__capability_license_not_supported_outgoing_antispam' => '送信メッセージの制限は、お使いのライセンスではサポートされていません。該当する設定は移管されません。',
    'backup__restore__capability_license_not_supported_outgoing_antispam_resolution' => '必要な機能を提供する別のライセンスキーを宛先サーバにインストールしてください。',
    'backup__restore__capability_disabled_outgoing_antispam' => '送信メッセージの制限が宛先サーバでオフになっています。該当する設定は移管されません。',
    'backup__restore__capability_disabled_outgoing_antispam_resolution' => '宛先サーバで送信メッセージの制限をオンにしてください。',
    'backup__restore__capability_disabled_outgoing_antispam_resolution_url_text' => 'サーバ全体のメール設定',

    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported' => 'メールボックスからの送信メッセージの制限が、宛先サーバで使用しているメールサーバではサポートされていません。この制限の値は移管されません。',
    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported_resolution' => 'メールサーバを、ソースサーバと同じものに変更してください。',
    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported_resolution_url_text' => 'サーバ全体のメール設定',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported' => 'ドメインからの送信メッセージの制限が、宛先サーバで使用しているメールサーバではサポートされていません。この制限の値は移管されません。',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported_resolution' => 'メールサーバを、ソースサーバと同じものに変更してください。',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported_resolution_url_text' => 'サーバ全体のメール設定',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported' => '契約からの送信メッセージの制限が、宛先サーバで使用しているメールサーバではサポートされていません。この制限の値は移管されません。',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported_resolution' => 'メールサーバを、ソースサーバと同じものに変更してください。',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported_resolution_url_text' => 'サーバ全体のメール設定',

    'bu_conflict_resolver_absent_phosting' => '指定したファイルを復元することができません。これらを復元するための物理ホスティングが存在しないためです。まず物理ホスティング付きのドメインを作成してから、バックアップの復元をもう一度お試しください。',
    'bu_conflict_resolver_resellers_management_is_not_supported' => 'リセラー管理がサポートされていないため、リセラーデータは復元されません。',

    'backup__restore__capability_modsecurity_not_installed_text' => 'ModSecurity コンポーネントが宛先サーバにインストールされていません。',
    'backup__restore__capability_modsecurity_not_installed_resolution' => '移管したサイトでファイアウォールが機能するようにするには、ModSecurity をインストールしてください。インストールには数分かかる可能性があります。',
    'backup__restore__capability_modsecurity_not_installed_resolution_for_server' => 'ウェブアプリケーションファイアウォールの設定を移管したい場合は、ModSecurity をインストールしてください。インストールには数分かかる可能性があります。',
    'backup__restore__capability_modsecurity_not_configured_text' => '宛先サーバで ModSecurity コンポーネントが構成されていません。',
    'backup__restore__capability_modsecurity_not_configured_resolution' => '移管したサイトでウェブアプリケーションファイアウォールが機能するようにするには、ModSecurity を構成してください。',
    'backup__restore__capability_modsecurity_not_configured_resolution_url_text' => 'ウェブアプリケーションファイアウォール（ModSecurity）',
    'backup__restore__capability_modsecurity_not_active_text' => 'ModSecurity が宛先サーバでオフになっています。',
    'backup__restore__capability_modsecurity_not_active_resolution' => '移管したサイトでウェブアプリケーションファイアウォールが機能するようにするには、ModSecurity をアクティブ化してください。',
    'backup__restore__capability_modsecurity_not_active_resolution_url_text' => 'ウェブアプリケーションファイアウォール（ModSecurity）',
    'bu_conflict_resolver_modsecurity_not_installed' => 'ModSecurity コンポーネントがインストールされていません。ウェブアプリケーションファイアウォール設定は以下のオブジェクトに対して復元されません。{{objects}}',
    'bu_conflict_resolver_absent_websites_subscription' => "ウェブサイトを復元することができません。Plesk 内に存在しない契約 %1 に属しているためです。",
    'backup__restore__capability_not_installed_dns_text' => '宛先サーバにコンポーネント %1 がインストールされていません。DNS サービスが使用できなくなり、DNS 設定が失われます。すべての顧客ウェブサイトがダウンします。',
    'bu_conflict_resolver_dns_not_installed' => 'DNS サービスがインストールされていません。DNS 設定が次のオブジェクトに対して復元されません。{{objects}}',
    'backup__restore__subscriptions_cannot_restore_moved_to_another_owners' => '以下の契約は別の所有者に移管されたため、復元することはできません：%1',
    'backup__restore__subscriptions_cannot_restore_moved_to_another_vendors' => '以下の契約は別のプロバイダに移管されたため、復元することはできません。\'%1\'',
    'bu_conflict_resolver_sitebuilder_restore_util_is_not_installed' => 'Web Presence Builder のデータを復元するための Web Presence Builder 復元ユーティリティがみつかりません。Web Presence Builder がインストールされていない可能性があります。',
    'backup__restore__capability_renamed_db' => 'データベース名 "%1" は別の契約で既に使用されています。復元されたデータベースの名前は "%2" に変更されます。',
    'backup__restore__capability_renamed_db_user' => 'データベースユーザ名 "%1" は別の契約で既に使用されています。復元されたデータベースユーザの名前は "%2" に変更されます。',
    'backup__restore__capability_not_installed_perl_resolution' => 'Plesk Installer は Perl をサポートしていません。ActiveState Perl は手動でインストールしてください。',
    'backup__restore__capability_php_handler' => '%%version%% %%type%% (id=%%id%%)',
    'backup__restore__capability_php_handler_served_by_apache' => '%%version%% %%type%% + Apache (id=%%id%%)',
    'backup__restore__capability_php_handler_served_by_nginx' => '%%version%% %%type%% + nginx (id=%%id%%)',


    '__sni' => 'SNI',
    '__kav' => 'Kaspersky アンチウイルス',
    '__drweb' => 'Odin Premium Antivirus',

    // Timing conflicts
    'backup__restore__timing_conflicts' => 'タイミングの競合',
    'backup__restore__hint_timing_conflicts' => '変更日がより新しい復元対象オブジェクトが既に存在しているか、復元対象オブジェクトが現在システムに存在しない場合、タイミングの競合が発生します。',
    'backup__restore__text_timing_resolution_policy_overwrite' => 'バックアップから構成とデータを使用',
    'backup__restore__hint_timing_resolution_policy_overwrite' => 'システムに存在するオブジェクト設定およびデータを、バックアップファイル上の設定とデータで完全に上書きします。復元するオブジェクトが現在異なる所有者に属している場合にも、オブジェクトはバックアップ時点の所有者のまま復元されます。',
    'backup__restore__text_timing_resolution_policy_proceed' =>  '構成は現在のシステムから、データはバックアップから使用する',
    'backup__restore__hint_timing_resolution_policy_proceed' => 'バックアップファイルのデータに現在のオブジェクトデータを上書きしますが、システムに存在する現在の設定はそのままにします。復元するオブジェクトが異なる所有者に属している場合、オブジェクトは現行の所有者に対して復元されます。',
    'backup__restore__text_timing_resolution_policy_do_not_restore' => '復元しません',
    'backup__restore__hint_timing_resolution_policy_do_not_restore' => '時間的な競合が発生するオブジェクトを復元しません',
    // Resource usage conflicts
    'backup__restore__resource_useage_conflicts' => 'リソース利用の競合',
    'backup__restore__hint_resource_usage_conflicts' => '復元時、復元するオブジェクトのリソース使用量が制限値を超過する場合、リソース使用量の競合が発生します。',
    'backup__restore__text_resource_usage_resolution_policy_overusage' => '利用超過の許可',
    'backup__restore__hint_resource_usage_resolution_policy_overusage' => 'オブジェクトを復元し、初期段階よりも多くのリソースを割り当てます。',
    'backup__restore__text_resource_usage_resolution_policy_do_not_restore' => '復元しません',
    'backup__restore__hint_resource_usage_resolution_policy_do_not_restore' => 'リソース使用の競合が発生するオブジェクトを復元しません',
    // Configuration conflicts
    'backup__restore__configuration_conflicts' => '設定の競合',
    'backup__restore__hint_configuration_conflicts' => '構成上の競合は、復元したオブジェクトでは設定されているのにも関わらず、現在のサーバまたはオブジェクト所有者ポリシーでウェブアプリケーションを利用できない場合に発生します。構成上の競合の一例として、復元されるメールアカウントに個々のスパムフィルタ設定が行われているのにも関わらず、現在のサーバポリシーにおいて個々のメールアカウント上での設定が拒否されている場合などに当てはまります。',
    'backup__restore__text_configuration_resolution_policy_automatic' => '自動',
    'backup__restore__hint_configuration_resolution_policy_automatic' => 'オブジェクトを復元し、パーミッションで管理が許可されているすべての競合設定オプションを自動的にオンにします。',
    'backup__restore__text_configuration_resolution_policy_do_not_restore' => '復元しません',
    'backup__restore__hint_configuration_resolution_policy_do_not_restore' => '設定上の競合が発生するオブジェクトを復元しません',

    'backup__restore__dedicated_app_pool_restore_to_shared_text' => '専用 IIS アプリケーションプールは IIS アプリケーションプール設定で許可されません。',
    'backup__restore__dedicated_app_pool_restore_to_shared_resolution' => '［ツールと設定］>［IIS アプリケーションプール］>［グローバル設定］で IIS アプリケーションプール設定を変更してください。',
    'backup__restore__shared_app_pool_restore_to_dedicated_text' => '共用 IIS アプリケーションプールは IIS アプリケーションプール設定で許可されません。',
    'backup__restore__shared_app_pool_restore_to_dedicated_resolution' => '［ツールと設定］>［IIS アプリケーションプール］>［グローバル設定］で IIS アプリケーションプール設定を変更してください。',

    'backup__restore__unable_allow_short_pop3 _names_text' => '宛先サーバで POP3/IMAP メールアカウント名の短縮形が許可されません。',
    'backup__restore__unable_allow_short_pop3 _names_resolution' => 'メールアカウントの短縮形は、データの復元後は使用できません。',

    // Restore status messages & errors:
    'backup__unable_to_open_log_file' => 'ログファイルが開きません。',
    'backup__restore__customer_cannot_restore_nonexistent_subscription' => '契約 %1 を復元できません。アカウントから既に削除されています。契約を作成するパーミッションをお持ちではありません。復元する必要がある場合は、サービスプロバイダまでご連絡ください。',

    'backup__error11' => 'バックアップに十分なディスクスペースがありません。',
    'backup__error3011' => '接続が拒否されました。指定したアドレスおよびポートを listen しているプログラムはありません。',
    'backup__error3012' => '接続がタイムアウトしました。',
    'backup__error3013' => 'ネットワークに接続できません。',
    'backup__error3014' => 'ホストへのルートがありません。',
    'backup__error3015' => '接続に失敗しました。',
    'backup__error3016' => 'ホスト名を解決できません。',
    'backup__error3017' => 'ユーザ名またはパスワードが正しくありません。',
    'backup__error3018' => 'SSH 接続に失敗しました。',

    'backup__error3110' => 'リモート移行エージェントに接続できません。ホストへの接続がありません。',
    'backup__error3111' => '移行エージェントが、失敗した移行タスクによってロックされているか、別の移行プロセスで使用されています。ソースサーバで移行エージェントを再起動してください。',
    'backup__error3112' => 'ホストへの接続がないか、移行エージェントがソースホスト上で起動していません。',
    'backup__error3113' => 'Linux ホストに移行エージェントをデプロイできません。ソースホストへの SSH 接続を確認してください。',
    'backup__error3114' => 'Linux ホストに移行エージェントをデプロイできません。SSH 接続に失敗しました。',
    'backup__error3115' => 'ユーザ名またはパスワードが正しくありません。',
    'backup__error3116' => '指定したユーザに管理権限がありません。',

    'backup__scheduled_backup_settings__backup_of_domain_all_at_domain' => 'すべての構成とコンテンツ',
    'backup__scheduled_backup_settings__backup_of_domain_vhost_only' => 'メール以外のすべての構成とコンテンツ',
    'backup__scheduled_backup_settings__backup_of_domain_mail_only' => 'メールの構成とコンテンツのみ',

    'dns_t__unable_to_remove_ns_record' => 'DNS テンプレートから NS レコードを削除できません。各 DNS ゾーンに、NS レコードが 1 つ以上必要です。',
    'dns__unsupported_server_zone_transfer' => 'サーバ全体の DNS 構成が原因で、転送制限テンプレートを転送できません。ソースサーバで、次のネットワークアドレス（%1）がゾーン転送に対して許可されていますが、これらのアドレスは Microsoft DNS Server によって禁止されています。',
    'dns__unsupported_domain_zone_transfer' => 'ドメインの DNS 構成が原因で、転送制限テンプレートを転送できません。一部のドメインで、次のネットワークアドレス（%1）がゾーン転送に対して許可されていますが、これらのアドレスは Microsoft DNS Server によって禁止されています。',
    ///
    /// END OF COMMON SCREENS
    ///

    ///
    /// DATABASE BACKUP - PFW // TBD
    ///

    // Actions

    'backup__db_mapping__title' => 'データベースサーバマッピングの定義',
    'dbbackup__check_network_settings_failed' => 'バックアップファイルのために共有の一時ネットワークディレクトリにアクセスすることができません。ネットワークディレクトリ、ユーザ名、パスワードの設定をチェックしてください。エラー：%1',

    'migration_select_exist_db_server' => '移行先データベースサーバを選択',

    'dbbackup__temp_dir_wrong_value' => '一時ディレクトリに無効な値が指定されました。',
    'dbbackup__network_temp_dir_wrong_value' => '一時ネットワークディレクトリに無効な値が指定されました。',
    'dbbackup__server_backup_not_configured' => 'データベースバックアップ設定がサーバで構成されていません。',
    'dbbackup__temp_dir' => '一時ディレクトリ',
    'dbbackup__temp_dir_hint' => 'MS SQL サーバが存在するリモートサーバにおける物理フォルダへのパス。MS SQL サーバは、一時バックアップファイルの読み取りおよび書き込みのためにこのフォルダにアクセスできる必要があります。例：C:¥¥DirectoryPath',
    'dbbackup__network_temp_dir_hint' => '上記の物理フォルダにマッピングされたネットワークシェアへのパス。Plesk は、バックアップファイルのダウンロードとアップロードのために共有フォルダにアクセスします。例：\\\\ServerName\\DirectoryPath',
    'dbbackup__network_user_hint' => 'リモートサーバに作成されたネットワークユーザのユーザ名。例： ServerName\\UserName。ユーザには、上に指定した共有フォルダへのアクセス権が必要です。',
    'dbbackup__network_password_hint' => 'ネットワークユーザのパスワード',

    'dbbackup__success_import_without_dublicate_users' => 'ユーザ %1 はインポートされていません。これらは既にデータベースサーバに存在します。',

    ///
    /// END OF DATABASE BACKUP
    ///

    ///
    /// LOGS & LOG ROTATION
    ///

    'log_rot__compress' => "ログファイルを圧縮",
    'log_rot__log_rot_status' => "ログローテーションのステータス",
    'log_rot__log_rot_period' => "ログローテーション条件",
    'log_rot__log_rot_size' => "サイズ単位",
    'log_rot__log_rot_time' => "時間単位",
    'log_rot__logrotation_enable' => "ログローテーションをオンにする",
    'log_rot__mail' => "処理済みのログファイルをメールで送信",
    'log_rot__max_number_of_logfiles' => "最大ログファイル数",
    'log_rot__time_period' => "期間",
    'log_rot__unable_turn_off' => 'ログローテーションをオフに設定できません。サーバレベルで適用されています',
    'log_rot__unable_set_period' => 'ログローテーション期間を「毎日」以外に設定できません。サーバレベルで適用されています',
    'log_rot__unable_set_max_log_files' => 'ログファイルの最大数はサーバ全体の上限である %1 より多く設定できません',

    /// action log
    // common/various
    'actionlog__digit_expected' => "期待される数値：%1",
    'actionlog__incorrect_rotation' => "指定されたログ範囲のパラメータが無効です。%1",
    'actionlog__unknown_rot_period' => "範囲が不明です。%1",
    'actionlog__unknown_rot_type' => "範囲タイプが不明です。%1",
    'actionlog__session_preferences' => 'セッション設定',
    // items (PFU schema)
    'actionlog__admin_info' => '管理者情報',
    'actionlog__admin_preferences' => "管理者の設定",
    'actionlog__service' => 'サービス',
    'actionlog__ip_addr' => 'IP アドレス',
    'actionlog__client' => '顧客アカウント',
    'actionlog__client_status' => '顧客アカウントのステータス',
    'actionlog__client_preferences' => "顧客のインターフェース設定",
    'actionlog__client_ip_pool' => "顧客の IP プール",
    'actionlog__client_siteapp' => "顧客のウェブアプリケーションプール",
    'actionlog__client_guid' => "顧客 GUID",
    'actionlog__domain' => 'デフォルトドメイン（契約に追加される最初のドメイン）',
    'actionlog__domain_owner' => '契約の所有者',
    'actionlog__domain_plan' => '契約のサービスプラン',
    'actionlog__domain_status' => 'デフォルトドメイン、ステータス',
    'actionlog__domain_dns' => 'デフォルトドメイン、DNS ゾーン',
    'actionlog__subdomain' => 'デフォルトドメインのサブドメイン',
    'actionlog__domain_alias' => 'デフォルトドメイン、エイリアス',
    'actionlog__domain_alias_dns' => 'デフォルトドメイン、エイリアス DNS ゾーン',
    'actionlog__site' => 'ドメイン',
    'actionlog__site_status' => 'ドメインステータス',
    'actionlog__site_dns' => 'ドメイン DNS ゾーン',
    'actionlog__site_guid' => 'ドメイン GUID',
    'actionlog__site_subdomain' => 'サブドメイン',
    'actionlog__site_alias' => 'ドメインエイリアス',
    'actionlog__site_alias_dns' => 'ドメインエイリアス DNS ゾーン',
    'actionlog__domain_limits' => '契約の上限',
    'actionlog__domain_limit_size' => '契約のディスクスペースの上限',
    'actionlog__domain_limit_traffic' => '契約のトラフィック上限',
    'actionlog__domain_limits_powerUser' => '契約の上限',
    'actionlog__domain_limit_size_powerUser' => '契約のディスクスペース上限',
    'actionlog__domain_limit_traffic_powerUser' => '契約のトラフィック上限',
    'actionlog__domain_guid' => "デフォルトドメイン、GUID",
    'actionlog__cp_user' => 'Plesk ユーザ',
    'actionlog__mailname' => 'メールアカウント',
    'actionlog__maillist' => 'メーリングリスト',
    'actionlog__phosting' => 'ホスティング設定',
    'actionlog__forwarding' => 'スタンダード/フレーム転送ホスティング',
    'actionlog__webuser' => 'ウェブユーザアカウント',
    'actionlog__site_application' => 'ウェブアプリケーション',
    'actionlog__license' => 'ライセンスキー',
    'actionlog__additional_license' => '追加ライセンスキー',
    'actionlog__template_domain' => "リセラーのサービスプラン",
    'actionlog__template_admin' => "管理者のサービスプラン",
    'actionlog__template_reseller' => 'リセラープラン',
    'actionlog__admin_alias' => '追加管理者アカウント', // PFW
    'actionlog__ftpuser' => '追加 FTP アカウント', // PFW
    'actionlog__db_server' => 'データベースサーバ',
    'actionlog__db' => 'データベース',
    'actionlog__db_user' => 'データベースユーザアカウント',
    'actionlog__client_sapppkg_pool' => "ユーザのウェブアプリケーション", // PFW, not used?
    'actionlog__remote_dns' => 'リモート DNS サーバのステータス', // PFW
    'actionlog__reseller' => 'リセラーアカウント',
    'actionlog__reseller_guid' => 'リセラー GUID',
    'actionlog__reseller_ip_pool' => "リセラー IP プール",
    'actionlog__reseller_limit_size' => 'リセラーアカウントのディスクスペースの上限',
    'actionlog__reseller_limit_traffic' => 'リセラーアカウントのトラフィック上限',
    'actionlog__reseller_limits' => 'リセラーアカウントの上限',
    'actionlog__reseller_permissions' => 'リセラーパーミッション',
    'actionlog__reseller_preferences' => "リセラーのインターフェース設定",
    'actionlog__reseller_siteapp' => "リセラープール内のウェブアプリケーション",
    'actionlog__reseller_status' => 'リセラーアカウントのステータス',
    'actionlog__health_status' => 'サーバヘルスステータス',
    // actions (PFU schema)
    'actionlog__limit_reached' => '到達',
    'actionlog__added' => '追加',
    'actionlog__removed' => '削除',
    'actionlog__change' => '変更',
    'actionlog__update' => '更新',
    'actionlog__move' => '移動済み',
    'actionlog__upgrade' => 'アップグレード', // PFU?
    'actionlog__update_or_add' => '更新または追加',
    'actionlog__expired' => '期限切れ',
    'actionlog__create' => '作成',
    'actionlog__delete' => '削除',
    'actionlog__service_stop' => '停止',
    'actionlog__service_restart' => '再起動',
    'actionlog__service_start' => '起動',
    'actionlog__login' => 'ログイン',
    'actionlog__logout' => 'ログアウト',
    'actionlog__install' => 'インストール',
    'actionlog__uninstall' => 'アンインストール',
    'actionlog__reconfigure' => '再構成',
    // events (PFW schema)
    'actionlog__event_pw_reset' => 'パスワード再設定リクエスト',
    'actionlog__event_admin_update' => '管理者情報の更新',
    'actionlog__event_admin_preferences_update' => "管理者の設定の更新",
    'actionlog__event_service_restart' => 'サービス再起動',
    'actionlog__event_service_start' => 'サービス起動',
    'actionlog__event_service_stop' => 'サービス停止',
    'actionlog__event_ip_address_create' => 'IP アドレス作成',
    'actionlog__event_ip_address_delete' => 'IP アドレス削除',
    'actionlog__event_ip_address_update' => 'IP アドレス更新',
    'actionlog__event_client_create' => '顧客アカウントの作成',
    'actionlog__event_client_delete' => '顧客アカウントの更新',
    'actionlog__event_client_update' => '顧客アカウントの更新',
    'actionlog__event_client_status_update' => '顧客アカウントのステータスの更新',
    'actionlog__event_client_preferences_update' => "顧客のインターフェース設定の更新",
    'actionlog__event_client_siteapp_added' => "ウェブアプリケーションを顧客アカウントのアプリケーションプールに追加",
    'actionlog__event_client_siteapp_removed' => "顧客アカウントのアプリケーションプールからウェブアプリケーションを削除",
    'actionlog__event_domain_limit_size_reached' => '契約のディスクスペースの上限に到達',
    'actionlog__event_domain_limit_traffic_reached' => '契約のトラフィック上限に到達',
    'actionlog__event_domain_limit_size_reached_powerUser' => '契約のディスク容量上限に到達',
    'actionlog__event_domain_limit_traffic_reached_powerUser' => '契約のトラフィック上限に到達',

    'actionlog__domain_limit_database' => '契約のデータベースクォータ',
    'actionlog__event_domain_limit_mysql_quota_reached' => '契約の MySQL データベースクォータに到達',
    'actionlog__event_domain_limit_mysql_soft_quota_reached' => '契約の MySQL データベースソフトクォータに到達',
    'actionlog__event_domain_limit_mssql_quota_reached' => '契約の Microsoft SQL Server データベースクォータに到達',
    'actionlog__event_domain_limit_mssql_soft_quota_reached' => '契約の Microsoft SQL Server データベースクォータに到達',
    'actionlog__event_plesk_component_upgrade' => 'Plesk コンポーネントの更新',
    'actionlog__event_plesk_component_install' => 'Plesk コンポーネントのインストール',
    'actionlog__event_plesk_component_uninstall' => 'Plesk コンポーネントのアンインストール',
    'actionlog__event_domain_create' => 'デフォルトドメイン（契約に追加される最初のドメイン）の作成',
    'actionlog__event_domain_delete' => 'デフォルトドメイン（契約に追加される最初のドメイン）の削除',
    'actionlog__event_domain_update' => 'デフォルトドメイン（契約に追加される最初のドメイン）の更新',
    'actionlog__event_domain_owner_change' => '契約所有者の変更',
    'actionlog__event_domain_plan_change' => '契約のサービスプランの変更',
    'actionlog__event_domain_status_update' => 'デフォルトドメイン、ステータスの更新',
    'actionlog__event_domain_dns_update' => 'デフォルトドメイン、DNS ゾーンの更新',
    'actionlog__event_subdomain_create' => 'デフォルトドメインのサブドメイン作成',
    'actionlog__event_subdomain_delete' => 'デフォルトドメインのサブドメイン削除',
    'actionlog__event_subdomain_update' => 'デフォルトドメインのサブドメイン更新',
    'actionlog__event_domain_alias_create' => 'デフォルトドメイン、エイリアス作成',
    'actionlog__event_domain_alias_delete' => 'デフォルトドメイン、エイリアス削除',
    'actionlog__event_domain_alias_update' => 'デフォルトドメイン、エイリアス更新',
    'actionlog__event_domain_limits_update' => '契約制限の更新',
    'actionlog__event_cp_user_login' => 'Plesk ユーザのログイン',
    'actionlog__event_cp_user_logout' => 'Plesk ユーザのログアウト',
    'actionlog__event_mailname_create' => 'メールアカウント作成',
    'actionlog__event_mailname_delete' => 'メールアカウント削除',
    'actionlog__event_mailname_update' => 'メールアカウント更新',
    'actionlog__event_maillist_create' => 'メーリングリスト作成',
    'actionlog__event_maillist_delete' => 'メーリングリスト削除',
    'actionlog__event_maillist_update' => 'メーリングリスト更新',
    'actionlog__event_phys_hosting_create' => '物理ホスティング作成',
    'actionlog__event_phys_hosting_delete' => '物理ホスティング削除',
    'actionlog__event_phys_hosting_update' => '物理ホスティング更新',
    'actionlog__event_forwarding_create' => '標準またはフレーム転送ホスティングの作成',
    'actionlog__event_forwarding_delete' => '標準またはフレーム転送ホスティングの削除',
    'actionlog__event_forwarding_update' => '標準またはフレーム転送ホスティングの更新',
    'actionlog__event_webuser_create' => 'ウェブユーザアカウントの作成',
    'actionlog__event_webuser_delete' => 'ウェブユーザアカウントの削除',
    'actionlog__event_webuser_update' => 'ウェブユーザアカウントの更新',
    'actionlog__event_siteapp_install' => 'ウェブアプリケーションのインストール',
    'actionlog__event_siteapp_reconfigure' => 'ウェブアプリケーションの再構成',
    'actionlog__event_siteapp_uninstall' => 'ウェブアプリケーションのアンインストール',
    'actionlog__event_license_update' => 'ライセンスキー更新',
    'actionlog__event_admin_alias_create' => '追加管理者アカウントの作成',
    'actionlog__event_admin_alias_delete' => '追加管理者アカウントの削除',
    'actionlog__event_admin_alias_update' => '追加管理者アカウントの更新',
    'actionlog__event_ftpuser_create' => '追加 FTP アカウントの作成',
    'actionlog__event_ftpuser_update' => '追加 FTP アカウントの更新',
    'actionlog__event_ftpuser_delete' => '追加 FTP アカウントの削除',
    'actionlog__event_template_domain_create' => "リセラーのサービスプランの作成",
    'actionlog__event_template_domain_update' => "リセラーのサービスプランの更新",
    'actionlog__event_template_domain_delete' => "リセラーのサービスプランの削除",
    'actionlog__event_template_admin_create' => "管理者のサービスプランの作成",
    'actionlog__event_template_admin_update' => "管理者のサービスプランの更新",
    'actionlog__event_template_admin_delete' => "管理者のサービスプランの作成",
    'actionlog__event_database_server_create' => 'データベースサーバの作成',
    'actionlog__event_database_server_update' => 'データベースサーバの更新',
    'actionlog__event_database_server_delete' => 'データベースサーバの削除',
    'actionlog__event_remote_dns_status_update' => 'リモート DNS サーバのステータスの更新',
    'actionlog__event_session_preferences_update' => 'セッション設定の更新',
    'actionlog__event_domain_alias_dns_update' => 'デフォルトドメイン、ドメインエイリアスの DNS ゾーンの更新',
    'actionlog__event_domain_move' => 'デフォルトドメインが新しい契約に移動されました',
    'actionlog__event_site_move' => 'ドメインが新しい契約に移動されました',
    'actionlog__event_site_subdomain_move' => 'サブドメインが新しい契約に移動されました',
    'actionlog__event_subdomain_move' => 'デフォルトドメインのサブドメインが新しい契約に移動されました',
    'actionlog__event_license_expired' => 'Plesk ライセンス期限切れ',
    'actionlog__event_database_create' => 'データベース作成',
    'actionlog__event_database_delete' => 'データベース削除',
    'actionlog__event_database_user_create' => 'データベースユーザアカウントの作成',
    'actionlog__event_database_user_update' => 'データベースユーザアカウント設定の更新',
    'actionlog__event_database_user_delete' => 'データベースユーザアカウントの削除',
    'actionlog__event_client_guid_update' => "顧客 GUID の更新",
    'actionlog__event_domain_guid_update' => 'デフォルトドメイン、GUID の更新',
    'actionlog__event_reseller_create' => 'リセラーアカウントの作成',
    'actionlog__event_reseller_delete' => 'リセラーアカウントの削除',
    'actionlog__event_reseller_update' => 'リセラーアカウントの更新',
    'actionlog__event_reseller_guid_update' => 'リセラー GUID の更新',
    'actionlog__event_reseller_ip_pool_update' => "リセラー IP プールの更新",
    'actionlog__event_reseller_limit_size_reached' => 'リセラーアカウントのディスクスペースの上限に到達',
    'actionlog__event_reseller_limit_traffic_reached' => 'リセラーアカウントのトラフィック上限に到達',
    'actionlog__event_reseller_limits_update' => 'リセラーアカウント制限の更新',
    'actionlog__event_reseller_permissions_update' => 'リセラーアカウントパーミッションの更新',
    'actionlog__event_reseller_preferences_update' => "リセラーのインターフェース設定の更新",
    'actionlog__event_reseller_siteapp_added' => "リセラーアカウントのアプリケーションプールにアプリケーションを追加",
    'actionlog__event_reseller_siteapp_removed' => "リセラーアカウントのアプリケーションプールからアプリケーションを削除",
    'actionlog__event_reseller_status_update' => 'リセラーアカウントのステータスの更新',
    'actionlog__event_template_reseller_create' => 'リセラープランの作成',
    'actionlog__event_template_reseller_delete' => 'リセラープランの削除',
    'actionlog__event_template_reseller_update' => 'リセラープランの更新',
    'actionlog__event_health_status_change' => 'サーバヘルスステータスの変更',
    'actionlog__event_siteapp_upgrade' => 'ウェブアプリケーションのアップグレード',
    'actionlog__event_extension_install' => '拡張のインストール',
    'actionlog__event_extension_uninstall' => '拡張のアンインストール',
    'actionlog__event_extension_upgrade' => '拡張のアップグレード',
    'actionlog__event_extension_status_update' => '拡張ステータスの更新',
    'actionlog__event_additional_license_expired' => '追加ライセンスの期限切れ',
    'actionlog__event_hostname_changed' => 'サーバのホスト名が変更されました',
    'actionlog__event_smb_user_create' => '追加ユーザが作成されました',
    'actionlog__event_smb_user_delete' => '追加ユーザが削除れました',
    'actionlog__event_smb_user_update' => '追加ユーザが更新されました',

    // REMOTE SESSION
    'rsession_no_api_rpc_errmsg' => "リモートホストに Plesk API RPC がインストールされていません。サービスプロバイダまでお問い合わせください。",
    'rsession_no_account_errmsg' => "このアカウントにおいてリモートサービスにアクセスすることができません。主な原因としては、アカウントに対して当該サービスが有効にされていない可能性があります。しばらくお待ちになり、再度お試しください。再びこのエラーが発生する場合は、システム管理者にお問い合わせください",
    'rsession_no_domain_errmsg' => "このドメインにおいてリモートサービスにアクセスすることができません。主な原因としては、ドメインに対して当該サービスが有効にされていない可能性があります。しばらくお待ちになり、再度お試しください。再びこのエラーが発生する場合は、システム管理者にお問い合わせくださいU",
    'rsession_unknown_errmsg' => "リモートサーバはセッションの確立を破棄しました。問題解決のためにシステム管理者にお問い合わせください。エラーは %1 となります。",
    'rsession_unknown2_errmsg' => "リモートセッションを発行する際不明なエラーが発生しました。リモートサーバが正常に応答していないか、全く応答していない可能性があります。ウェブサーバのエラーログでエラーの詳細を確認するようシステム管理者に依頼してください。",
    'rsession_no_connect_errmsg' => "リモートサービスにアクセスすることができません。リモートセッションの接続に失敗しました。システム管理者に連絡してください",

    // ANONYMOUS FTP
    'anonftp__allow_upload_incoming' => "受信ディレクトリへのアップロードを許可",
    'anonftp__allow_create_dirs' => '受信ディレクトリでのディレクトリの作成を許可',
    'anonftp__allow_download_incoming' => '受信ディレクトリからのダウンロードを許可',
    'anonftp__display_login' => 'ログインメッセージを表示',
    'anonftp__login_text' => 'メッセージテキスト',
    'anonftp__limit_incoming_disk_space' => "受信ディレクトリのディスクスペースを制限する",
    'anonftp__limit_maximum_bandwidth' => "この仮想 FTP ドメインのダウンロード帯域幅を制限する",
    'anonftp__limit_maximum_connections' => "同時接続の数を制限する",
    'anonftp__unable_init' => "匿名 FTP アカウントを初期化できません。%1",
    'anonftp__unable_set_quota' => "受信ディレクトリのディスクスペースを設定できません。%1",
    'anonftp__unable_update' => "匿名 FTPアカウントプロパティを更新できません。%1",

    ///
    /// SSL/TLS CERTIFICATES
    ///

    // common keys
    '__certificates' => 'SSL/TLS 証明書', // page title
    // errors
    'class_sslcertificate__ca_not_signs' => "CA 証明書は証明書をサインしていません",
    'class_sslcertificate__incompatible_pvt_key_cert' => "秘密キー/証明書のペアが一致していません",
    'class_sslcertificate__invalid_cert_format' => "無効な証明書フォーマットです。",
    'class_sslcertificate__invalid_private_key_format' => "秘密キーのフォーマットが無効です",
    'class_sslcertificate__prob_invalid_priv_key' => "秘密キーのフォーマットが無効である可能性があります。",

    ///
    ///END OF SSL/TLS CERTIFICATES
    ///

    ///
    /// WEB DIRECTORIES (PFW)
    ///

    //
    // DOMAIN
    //

    // Web Directories tab
    // Web Directories - ui__client/domain/hosting/web-directories__title (HOME/DOMAIN)
    'ui__client/domain/hosting/web-directories/create-virtual-dir__short-title' => '仮想ディレクトリを作成',
    'ui__client/domain/hosting/web-directories/create-virtual-dir__title' => '仮想ディレクトリを作成',
    'ui__client/domain/hosting/web-directories/create-virtual-dir__description' => '仮想ディレクトリを作成します。',
    'ui__client/domain/hosting/web-directories/create-virtual-dir_self__short-title' => '仮想ディレクトリの作成　',
    'ui__client/domain/hosting/web-directories/create-virtual-dir_self__title' => '仮想ディレクトリを作成',
    'ui__client/domain/hosting/web-directories/create-virtual-dir_self__description' => '仮想ディレクトリを作成します。',
    'ui__client/domain/hosting/web-directories/create-dir__short-title' => 'ディレクトリを作成',
    'ui__client/domain/hosting/web-directories/create-dir__title' => 'ディレクトリを作成',
    'ui__client/domain/hosting/web-directories/create-dir__description' => 'ディレクトリを作成します。',
    'ui__client/domain/hosting/web-directories/create-dir_self__short-title' => 'ディレクトリを作成',
    'ui__client/domain/hosting/web-directories/create-dir_self__title' => 'ディレクトリを作成',
    'ui__client/domain/hosting/web-directories/create-dir_self__description' => 'ディレクトリを作成します。',
    'ui__client/domain/hosting/web-directories/properties__short-title' => 'ディレクトリプロパティ',
    'ui__client/domain/hosting/web-directories/properties__title' => '仮想ディレクトリのプロパティ',
    'ui__client/domain/hosting/web-directories/properties__description' => '仮想ディレクトリプロパティを表示・変更する',
    'ui__client/domain/hosting/web-directories/properties_self__short-title' => 'ディレクトリプロパティ',
    'ui__client/domain/hosting/web-directories/properties_self__title' => '仮想ディレクトリプロパティ',
    'ui__client/domain/hosting/web-directories/properties_self__description' => '仮想ディレクトリプロパティの表示と変更',
    'ui__client/domain/hosting/web-directories/permissions__short-title' => 'ディレクトリアクセスパーミッション',
    'ui__client/domain/hosting/web-directories/permissions__title' => 'ディレクトリアクセスパーミッション',
    'ui__client/domain/hosting/web-directories/permissions__description' => 'ディレクトリアクセスパーミッションの設定',
    'ui__client/domain/hosting/web-directories/permissions_self__short-title' => 'ディレクトリアクセスパーミッション',
    'ui__client/domain/hosting/web-directories/permissions_self__title' => 'ディレクトリアクセスパーミッション',
    'ui__client/domain/hosting/web-directories/permissions_self__description' => 'ディレクトリアクセスパーミッションをセットアップする',
    'ui__client/domain/hosting/web-directories/aspdotnet__short-title' => 'ASP.NET 設定',
    'ui__client/domain/hosting/web-directories/aspdotnet__title' => '%1 の ASP.NET 設定',
    'ui__client/domain/hosting/web-directories/aspdotnet__description' => '仮想ディレクトリ %1 の ASP.NET 設定を構成する',
    'ui__client/domain/hosting/web-directories/aspdotnet_self__short-title' => 'ASP.NET 設定',
    'ui__client/domain/hosting/web-directories/aspdotnet_self__title' => '%1 の ASP.NET 設定',
    'ui__client/domain/hosting/web-directories/aspdotnet_self__description' => '仮想ディレクトリ %1 の ASP.NET 設定を行います。',
    'ui__client/domain/hosting/web-directories/php__short-title' => 'PHP 設定',
    'ui__client/domain/hosting/web-directories/php__title' => '%1 の PHP 設定',
    'ui__client/domain/hosting/web-directories/php__description' => '仮想ディレクトリ %1 の PHP 設定を行います。',
    'ui__client/domain/hosting/web-directories/php_self__short-title' => 'PHP 設定',
    'ui__client/domain/hosting/web-directories/php_self__title' => '%1 の PHP 設定',
    'ui__client/domain/hosting/web-directories/php_self__description' => '仮想ディレクトリ %1 の PHP 設定を行います。',

    // list object operations
    'ui__client/domain/hosting/web-directories/delete__short-title' => '削除',
    'ui__client/domain/hosting/web-directories/delete__title' => '仮想ディレクトリの削除',
    'ui__client/domain/hosting/web-directories/delete__description' => '選択した仮想ディレクトリを削除します。',
    'ui__client/domain/hosting/web-directories/delete_self__short-title' => '削除',
    'ui__client/domain/hosting/web-directories/delete_self__title' => '仮想ディレクトリの削除',
    'ui__client/domain/hosting/web-directories/delete_self__description' => '選択した仮想ディレクトリを削除します。',
    'ui__client/domain/hosting/web-directories/delete#legend__description' => '以下の仮想ディレクトリが削除されます。',
    'ui__client/domain/hosting/web-directories/delete__empty_selection' => '削除するディレクトリを選択する必要があります。',

    // MIME Types tab
    'ui__client/domain/hosting/web-directories/mime-type_unknown__short-title' => 'MIME タイプ',
    'ui__client/domain/hosting/web-directories/mime-type_unknown__title' => 'MIME タイプ',
    'ui__client/domain/hosting/web-directories/mime-type_unknown__description' => '登録 MIME タイプ一覧を表示します。',
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__short-title' => 'MIME タイプを追加',
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__title' => 'MIME タイプを追加',
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__description' => '新しい MIME タイプの登録',

    // Error documents tab
    'ui__client/domain/hosting/web-directories/error-doc_unknown__short-title' => 'エラードキュメント',
    'ui__client/domain/hosting/web-directories/error-doc_unknown__title' => 'エラードキュメント',
    'ui__client/domain/hosting/web-directories/error-doc_unknown__description' => 'エラードキュメントの表示と変更',

    // Protection tab
    'ui__client/domain/hosting/web-directories/protection__short-title' => '保護',
    'ui__client/domain/hosting/web-directories/protection__title' => 'ディレクトリ保護',
    'ui__client/domain/hosting/web-directories/protection__description' => 'パスワード保護を用いてディレクトリへのアクセスを制限します。',
    'ui__client/domain/hosting/web-directories/protection_self__short-title' => '保護',
    'ui__client/domain/hosting/web-directories/protection_self__title' => 'ディレクトリ保護',
    'ui__client/domain/hosting/web-directories/protection_self__description' => 'パスワード保護を用いてディレクトリへのアクセスを制限します。',
    'ui__client/domain/hosting/web-directories/protection/properties__short-title' => '設定',
    'ui__client/domain/hosting/web-directories/protection/properties__description' => 'ディレクトリのロケーションを確認して、保護エリアのタイトルを入力してください。',
    'ui__client/domain/hosting/web-directories/protection/user/properties__title' => 'ユーザ設定',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__title' => 'ユーザを追加する',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__short-title' => 'ユーザを追加する',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__description' => '保護ディレクトリへのアクセスを許可するユーザアカウントを追加してください',
    'ui__client/domain/hosting/web-directories/protection/properties__done' => '新しい設定を適用しました',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__done' => 'ユーザアカウントを追加しました',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__short-title' => '削除',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__description' => '保護ディレクトリのユーザを削除します。',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__title' => 'ユーザアカウントを削除する',
    'ui__client/domain/hosting/web-directories/protection/user/delete#legend__description' => 'ユーザアカウントの削除を確認してください。',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__done' => 'ユーザアカウントを削除しました',

    //
    // SUBDOMAIN
    //

    // Web Directories tab

    // list object operations

    // MIME Types tab

    // Protection tab
    // Error documents tab

    ///
    /// END OF WEB DIRECTORIES
    ///

    ///
    /// SUBDOMAIN PAGE
    ///


    ///
    /// END OF SUBDOMAIN PAGE
    ///

    ///
    /// DONE MESSAGES
    ///

    // UI
    'ui____done' => '操作が正常に完了しました',
    'ui__admin/extras-domain__done' => 'MyPlesk.com ページが開きました',
    'ui__admin/report/layout/delete_multi__done' => '選択したレポートレイアウトが削除されました',
    'ui__admin/report/traffic-history__done' => '操作は正常に完了しました',
    'ui__admin/report__done' => '操作は正常に完了しました',
    'ui__admin-alias/delete_multi__done' => "選択した管理者サブアカウントを削除しました",
    'ui__admin-alias/properties__done' => "管理者サブアカウントプロパティがアップデートされました",
    'ui__admin-alias/properties_new__done' => "管理者サブアカウントが作成されました",
    'ui__admin-alias/properties_unknown__done' => "管理者サブアカウントプロパティがアップデートされました",
    'ui__admin-alias__done' => "管理者サブアカウント情報が正常にアップデートされました",
    'ui__admin/manage-domain__done' => 'MyPlesk.com ページが開きました',
    'ui__admin/register-domain__done' => 'MyPlesk.com ページが開きました',
    'ui__admin/report/layout/auto/delete_multi__done' => '選択したレポート配信スケジュールが削除されました。',
    'ui__admin/report/layout/auto/properties__done' => 'レポート配信スケジュールが更新されました。',
    'ui__admin/report/layout/auto/properties_new__done' => 'レポート配信スケジュールが作成されました。',
    'ui__admin/report/layout/properties__done' => 'レポートレイアウト %1 がアップデートされました',
    'ui__admin/report/layout/properties_new__done' => 'レポートレイアウト %1 が作成されました',
    'ui__client/domain/certificate/properties__done' => 'SSL/TLS 証明書のプロパティが更新されました。',
    'ui__client/domain/certificate/properties_new__done' => '新しい SSL/TLS 証明書が追加されました。機能させるためには、ウェブホスティング設定（［ウェブサイトとドメイン］タブ > ドメイン名）でこの証明書を選択してください。',
    'ui__client/domain/certificate__done' => '操作が正常に完了しました',
    'ui__client/domain/certificate_self__done' => '操作が正常に完了しました',
    'ui__client/domain/chowner__done' => '契約 %1 の所有者が他のユーザに移動しました',
    'ui__client/domain/chowner_multi__done' => '契約の所有者が変更されました',
    'ui__client/domain/chowner_multi-select__done' => '操作が正常に完了しました',
    'ui__client/domain/chowner_select__done' => '操作が正常に完了しました',
    'ui__client/domain/dbbackup/create__done' => "データベースは正常にバックアップされました", // PFW
    'ui__client/domain/dbbackup/get__done' => "データベースは正常にバックアップされました", // PFW
    'ui__client/domain/dbbackup/orphaned__done' => "孤立したユーザが正常に修復されました", // PFW
    'ui__client/domain/dbbackup/remove__done' => "バックアップファイルが正常に削除されました", // PFW
    'ui__client/domain/dbbackup/restore__done' => "データベースコンテンツが正常に復元されました。", // PFW
    'ui__client/domain/dbbackup/upload__done' => "操作が正常に完了しました", // PFW
    'ui__client/domain/dbbackup__done' => "操作が正常に完了しました", // PFW
    'ui__client/domain/dbbackup_self__done' => "操作が正常に完了しました", // PFW
    'ui__client/domain/dbbackup_unknown__done' => "操作が正常に完了しました", // PFW
    'ui__client/domain/delete__done' => "ドメイン %1 が削除されました",
    'ui__client/domain/delete_multi__done' => "ドメインが削除されました",
    'ui__client/domain/disable__done' => 'ドメイン %1 が一時停止しました。',
    'ui__client/domain/disable_multi__done' => '選択したドメインが一時停止されました。',
    'ui__client/domain/enable__done' => 'ウェブサイト %1 をアクティブ化しました。',
    'ui__client/domain/enable_multi__done' => '選択したウェブサイトがアクティブ化されました。',
    'ui__client/domain/extras__done' => 'MyPlesk.com ページが開きました',
    'ui__client/domain/extras_self__done' => 'MyPlesk.com ページが開きました',
    'ui__client/domain/hosting/logs/rotation__done' => 'ログローテーションの設定を変更しました',
    'ui__client/domain/hosting/logs/rotation_self__done' => 'ログローテーションの設定を変更しました',
    'ui__client/domain/hosting/logs__done' => '操作が正常に完了しました',
    'ui__client/domain/hosting/logs_self__done' => '操作が正常に完了しました',
    'ui__client/domain/hosting/protected-directories__done' => '操作が正常に完了しました',
    'ui__client/domain/hosting/protected-directories_self__done' => '操作が正常に完了しました',
    'ui__client/domain/hosting/setup__done' => '%1 のホスティングが設定されました',
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version__done' => 'ASP.NET バージョンが変更されました', // PFW
    'ui__client/domain/hosting/ssh-terminal__done' => '操作が正常に完了しました', // PFU
    'ui__client/domain/hosting/ssh-terminal_self__done' => '操作が正常に完了しました', // PFU
    'ui__client/domain/hosting/web-directories/aspdotnet__done' => '%1 の ASP.NET 設定を変更しました', // PFW
    'ui__client/domain/hosting/web-directories/create-dir__done' => 'ウェブサイト %1 下に仮想ディレクトリを作成しました', // PFW
    'ui__client/domain/hosting/web-directories/create-virtual-dir__done' => '仮想ディレクトリを作成しました', // PFW
    'ui__client/domain/hosting/web-directories/delete__done' => '選択した仮想ディレクトリを削除しました', // PFW
    'ui__client/domain/hosting/web-directories/delete_self__done' => '選択した仮想ディレクトリを削除しました', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__done' => 'カスタムエラードキュメントがアップデートされました', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__done' => '選択した MIME タイプが削除されました', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__done' => '新しい MIME タイプが登録されました', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties__done' => '操作が正常に完了しました', // PFW
    'ui__client/domain/hosting/web-directories/permissions__done' => 'ディレクトリアクセスパーミッションが更新されました。', // PFW
    'ui__client/domain/hosting/web-directories/permissions_self__done' => 'ディレクトリアクセスパーミッションが更新されました', // PFW
    'ui__client/domain/hosting/web-directories/php__done' => '%1 の PHP 設定がアップデートされました', // PFW
    'ui__client/domain/hosting/web-directories/php_self__done' => '%1 の PHP 設定が更新されました', // PFW
    'ui__client/domain/hosting/web-directories/properties__done' => 'ディレクトリプロパティを更新しました', // PFW
    'ui__client/domain/hosting/web-directories/properties_self__done' => 'ディレクトリプロパティを更新しました', // PFW
    'ui__client/domain/hosting/web-directories/protection__done' => 'ディレクトリ保護の設定を更新しました', // PFW
    'ui__client/domain/hosting/web-directories/protection_self__done' => 'ディレクトリ保護の設定を更新しました', // PFW
    'ui__client/domain/hosting/web-directories__done' => '操作が正常に完了しました', // PFW
    'ui__client/domain/hosting/web-directories_self__done' => "操作が正常に完了しました", // PFW
    'ui__client/domain/mpc-certificates__done' => 'オンラインストアで入手可能な SSL/TLS 証明書',
    'ui__client/domain/mpc-certificates_self__done' => 'オンラインストアで入手可能な SSL/TLS 証明書',
    'ui__client/domain/register__done' => 'MyPlesk.com ページが開きました',
    'ui__client/domain/register_self__done' => 'MyPlesk.com ページが開きました',
    'ui__client/domain/rename__done' => 'ドメイン名を変更しました',
    'ui__client/domain/rename_self__done' => "ドメイン名を変更しました",
    'ui__client/domain/settings_self__done' => '操作が正常に完了しました',
    'ui__client/domain/toggle_disable__done' => "ドメイン %1 が一時停止しました。",
    'ui__client/domain/toggle_enable__done' => "ドメイン %1 をアクティブ化されました。",
    'ui__client/domain/traffic__done' => '操作が正常に完了しました',
    'ui__client/domain/traffic_self__done' => '操作が正常に完了しました',
    'ui__client/domain/traffic_unknown__done' => '操作が正常に完了しました',
    'ui__client/domain-summary-report__done' => '操作が正常に完了しました',
    'ui__client/domain-summary-report_self__done' => '操作が正常に完了しました',
    'ui__client/domain-summary-report_unknown__done' => '操作が正常に完了しました',
    'ui__client/extras-domain__done' => 'MyPlesk.com ページが開きました',
    'ui__client/extras-domain_self__done' => 'MyPlesk.com ページが開きました',
    'ui__client/ipaddress/delete_multi__done' => '操作が正常に完了しました',
    'ui__client/ipaddress/properties__done' => '操作が正常に完了しました',
    'ui__client/ipaddress/properties_new__done' => '操作が正常に完了しました',
    'ui__client/ip-pool/properties__done' => "顧客 %1 の IP プールを更新しました",
    'ui__client/ip-pool/properties_self__done' => '操作が正常に完了しました',
    'ui__client/limits__done' => "顧客 %1 のリソース上限を変更しました",
    'ui__client/limits_self__done' => '操作が正常に完了しました',
    'ui__client/logo__done' => '顧客 %1 の新しいブランディング設定を適用しました',
    'ui__client/logo_reseller__done' => '新しいパネルブランディング設定が適用されました。',
    'ui__client/logo_self__done' => 'ブランディング設定を適用しました。',
    'ui__client/logo_self-reseller__done' => 'パネルブランディング設定が適用されました。',
    'ui__client/manage-domain__done' => 'MyPlesk.com ページが開きました',
    'ui__client/manage-domain_self__done' => 'MyPlesk.com ページが開きました',
    'ui__client/permissions__done' => "顧客 %1 のパーミッションを変更しました",
    'ui__client/permissions_self__done' => '正常に完了しました',
    'ui__client/preferences__done' => "顧客 %1 のプリファレンスを変更しました",
    'ui__client/preferences_self__done' => "プリファレンスを変更しました",
    'ui__client/register-domain__done' => 'MyPlesk.com ページが開きました',
    'ui__client/register-domain_self__done' => 'MyPlesk.com ページが開きました',
    'ui__client/report/traffic-history__done' => '操作が正常に完了しました',
    'ui__client/report/traffic-history_self__done' => '操作が正常に完了しました',
    'ui__client/report__done' => '操作が正常に完了しました　',
    'ui__client/report_self__done' => '操作が正常に完了しました',
    'ui__client/sessions/delete__done' => '操作が正常に完了しました',
    'ui__client/sessions/delete_self__done' => '操作が正常に完了しました',
    'ui__client/sessions__done' => '操作が正常に完了しました',
    'ui__client/sessions_self__done' => '操作が正常に完了しました',
    'ui__client/skeleton__done' => '操作が正常に完了しました',
    'ui__client/skeleton_self__done' => '操作が正常に完了しました　',
    'ui__client/traffic__done' => "操作が正常に完了しました",
    'ui__client/traffic_unknown__done' => '操作が正常に完了しました　',
    'ui__cp-access__done' => '操作が正常に完了しました',
    'ui__cp-session/properties__done' => '操作が正常に完了しました',
    'ui__cp-session__done' => '操作が正常に完了しました　',
    'ui__ftp-sessions__done' => '操作が正常に完了しました',
    'ui__license__done' => '操作が正常に完了しました',
    'ui__logo__done' => "Plesk のブランディングプロパティが変更されました。",
    'ui__longtasks/longtask/properties__done' => "バックグラウンドタスク設定を変更しました",
    'ui__mass-email/delete__done' => "メッセージテンプレート %1 が削除されました", // PFW
    'ui__mass-email/delete_multi__done' => "メッセージテンプレートが削除されました",  // PFW
    'ui__mass-email/send_main__done' => "操作が正常に完了しました",  // PFW
    'ui__mass-email/send_selectclients__done' => "顧客アカウントを選択しました",  // PFW
    'ui__mass-email/send_selectdomainusers__done' => "ドメイン管理者アカウントを選択しました",  // PFW
    'ui__mass-email/send_selectresellers__done' => 'リセラーアカウントを選択しました',  // PFW
    'ui__mass-email/template/properties_main__done' => '一括メールメッセージテンプレートの変更が保存されました。', // PFW
    'ui__mass-email/template/properties_new-main__done' => '一括メールメッセージテンプレートが作成されました。', // PFW
    'ui__mass-email/template/properties_new-selectclients__done' => '一括メールメッセージテンプレート用に顧客アカウントが選択されました。',  // PFW
    'ui__mass-email/template/properties_new-selectdomainusers__done' => '一括メールメッセージテンプレート用にドメイン管理者アカウントが選択されました。', // PFW
    'ui__mass-email/template/properties_new-selectresellers__done' => '一括メールメッセージテンプレート用にリセラーアカウントが選択されました。',  // PFW
    'ui__mass-email/template/properties_unknown__done' => "一括メールメッセージテンプレートが変更されました。",  // PFW
    'ui__mass-email/template/properties__invalid_values' => '無効な値が指定されました。', // PFW
    'ui__mass-email__done' => "操作が正常に完了しました", // PFW
    'ui__mass-mail__done' => "操作が正常に完了しました", // PFU
    'ui__mass-mail/delete__done' => 'メッセージテンプレート %1 が削除されました', // PFU
    'ui__mass-mail/delete_multi__done' => 'メッセージテンプレートが削除されました', // PFU
    'ui__mass-mail/properties__done' => 'テンプレート %1 が変更されました', // PFU
    'ui__mass-mail/properties_new__done' => 'テンプレート %1 が作成されました', // PFU
    'ui__mass-mail/send__done' => 'メッセージは送信済みです', // PFU
    'ui__mass-mail/send_new__done' => 'メッセージは送信済みです', // PFU
    'ui__mass-mail/send_unknown__done' => 'メッセージは送信済みです',  // PFU
    'ui__mass-mail/send_unknown-new__done' => 'メッセージは送信済みです', // PFU
    'ui__mass-mail/template/properties_new__done' => '新しいメッセージテンプレートが作成されました', // PFU
    'ui__mass-mail/template/properties__done' => 'メッセージテンプレートを変更しました', // PFU
    'ui__modules/watchdog/disk/properties__done' => '新しいディスクモニタリング設定を適用しました', // PFU
    'ui__modules__done' => '操作が正常に完了しました',
    'ui__modules__short-title' => '拡張',
    'ui__modules__title' => '拡張',
    'ui__reseller/client/traffic_unknown__done' => '操作が正常に完了しました',
    'ui__reseller/extras-domain__done' => 'MyPlesk.com ページが開きました',
    'ui__reseller/extras-domain_self__done' => 'MyPlesk.com ページが開きました',
    'ui__reseller/ftp-sessions_self__done' => '操作が正常に完了しました',
    'ui__reseller/limits__done' => "リセラーのリソース上限とリソース使用ポリシーを変更しました",
    'ui__reseller/limits_readonly-self__done' => '操作が正常に完了しました',
    'ui__reseller/limits_self__done' => 'リソース上限とリソース使用ポリシーを変更しました',
    'ui__reseller/manage-domain__done' => 'MyPlesk.com ページが開きました',
    'ui__reseller/manage-domain_self__done' => 'MyPlesk.com ページが開きました',
    'ui__reseller/permissions__done' => 'リセラー %1 のパーミッションが変更されました',
    'ui__reseller/permissions_readonly-self__done' => '',
    'ui__reseller/permissions_self__done' => '操作が正常に完了しました',
    'ui__reseller/register-domain__done' => 'MyPlesk.com ページが開きました',
    'ui__reseller/register-domain_self__done' => 'MyPlesk.com ページが開きました',
    'ui__reseller/report/layout/auto/delete_multi__done' => '選択したレポート配信レイアウトが削除されます。',
    'ui__reseller/report/layout/auto/properties__done' => 'レポート配信スケジュールが更新されました。',
    'ui__reseller/report/layout/auto/properties_new__done' => 'レポート配信スケジュールを追加しました',
    'ui__reseller/report/layout/properties__done' => 'レポートレイアウトを変更しました',
    'ui__reseller/report/layout/properties_new__done' => '新しいレポートレイアウトを作成しました',
    'ui__reseller/report/traffic-history__done' => '操作が正常に完了しました',
    'ui__reseller/report/traffic-history_self__done' => '操作が正常に完了しました',
    'ui__reseller/report__done' => '操作が正常に完了しました',
    'ui__reseller/report_self__done' => '操作が正常に完了しました',
    'ui__reseller/sessions/delete__done' => '操作は正常に完了しました',
    'ui__reseller/sessions/delete_self__done' => '操作は正常に完了しました',
    'ui__reseller/sessions__done' => '操作が正常に完了しました',
    'ui__reseller/sessions_self__done' => '操作が正常に完了しました',
    'ui__reseller/traffic__done' => '操作が正常に完了しました',
    'ui__reseller/traffic_self__done' => '操作が正常に完了しました',
    'ui__reseller/traffic_unknown__done' => '操作が正常に完了しました',
    'ui__reseller/logo_self__title' => 'Plesk ブランディング',
    'ui__reseller/logo_self__done' => 'Plesk ブランディング設定が適用されました。',
    'ui__server/aspdotnet__done' => 'サーバ全体の ASP.NET 設定を変更しました', // PFW
    'ui__server/certificate/default_multi__done' => '選択された SSL/TLS 証明書は、新たにホストされたウェブサイトへの接続のセキュリティ強化用にセットアップされました。',
    'ui__server/certificate/delete_multi__done' => '選択された SSL/TLS 証明書は削除されました。',
    'ui__server/certificate/download__done' => 'SSL/TLS 証明書はダウンロードされました。',
    'ui__server/certificate/properties__done' => 'SSL/TLS 証明書のプロパティが更新されました。',
    'ui__server/certificate/properties_new__done' => 'SSL/TLS 証明書 %1 は作成されました。',
    'ui__server/certificate/setup_multi__done' => '選択された SSL/TLS 証明書は、Plesk への接続のセキュリティ強化用にセットアップされました。',
    'ui__server/certificate__done' => '操作が正常に完了しました',
    'ui__server/cp-certificate-download__done' => "Plesk の SSL/TLS 証明書がダウンロードされました。",
    'ui__server/crontab/properties__done' => '%1 のスケジュール済みタスクが変更されました',
    'ui__server/crontab/task/delete__done' => 'タスクが削除されました',
    'ui__server/crontab/task/delete_multi__done' => 'タスクが削除されました',
    'ui__server/crontab/task/properties__done' => 'スケジュール済みタスクがアップデートされました。',
    'ui__server/crontab/task/properties_new__done' => '新規タスクがスケジューリングされました',
    'ui__server/crontab/task/toggle_disable__done' => 'スケジュール済みタスク %1 が無効にされました',
    'ui__server/crontab/task/toggle_enable__done' => 'スケジュール済みタスク %1 が有効にされました',
    'ui__server/crontab__done' => '操作が正常に完了しました',
    'ui__server/dns__done' => '操作が正常に完了しました',
    'ui__server/ip-address/client/delete__done' => "ユーザの IP プールから削除された IP アドレス",
    'ui__server/ip-address/client/delete_multi__done' => "IP アドレスがユーザの IP プールから削除されました",
    'ui__server/ip-address/client/properties_new__done' => 'IP アドレスをユーザに割り当てました',
    'ui__server/ip-address/ip-address/add-to-clients_add-target__done' => '選択した顧客に IP アドレス %1 を割り当てました',
    'ui__server/ip-addresses__done' => "操作が正常に完了しました",
    'ui__server/mail/statistics/spam/recipients__done' => "操作が正常に完了しました",
    'ui__server/mail/statistics/spam/summary__done' => "操作が正常に完了しました",
    'ui__server/mail/statistics/spam__done' => "操作が正常に完了しました",
    'ui__server/mail/statistics/virus/recipients__done' => "操作が正常に完了しました",
    'ui__server/mail/statistics/virus/summary__done' => "操作が正常に完了しました",
    'ui__server/mail/statistics/virus/viruses__done' => "操作が正常に完了しました",
    'ui__server/mail/statistics/virus__done' => "操作が正常に完了しました",
    'ui__server/mail/statistics__done' => "操作が正常に完了しました",
    'ui__server/mail__done' => 'メールサーバ設定を変更しました',
    'ui__server/maillists__done' => '操作が正常に完了しました',
    'ui__server/mpc-certificates__done' => '使用可能な SSL/TLS 証明書を示すオンラインストアページが開きました。',
    'ui__server/pmm__done' => '操作が正常に完了しました',
    'ui__server/preferences__done' => "サーバ設定を変更しました",
    'ui__server/register__done' => 'MyPlesk.com ページが開きました',
    'ui__server/services__done' => '操作が正常に完了しました',
    'ui__server/sitebuilder__done' => '操作が正常に完了しました',
    'ui__server/skeleton__done' => '操作が正常に完了しました',
    'ui__server/spam-filter/black-list/address/delete__done' => 'アドレス %1 をサーバ全体のブラックリストから削除しました',
    'ui__server/spam-filter/black-list/address/delete_multi__done' => 'そのアドレスをサーバ全体のブラックリストから削除しました',
    'ui__server/spam-filter/black-list/address/properties_new__done' => 'アドレスがブラックリストに追加されました',
    'ui__server/spam-filter/black-list/address__done' => 'アドレスがブラックリストに追加されました',
    'ui__server/spam-filter/black-list__done' => '操作が正常に完了しました', // PFU
    'ui__server/spam-filter/properties__done' => 'スパムフィルタ設定が変更されました',
    'ui__server/spam-filter/toggle_disable__done' => 'スパムフィルタがシステム全体で無効になりました',
    'ui__server/spam-filter/toggle_enable__done' => 'スパムフィルタがシステム全体で有効になりました',
    'ui__server/spam-filter/white-list/address/delete__done' => 'アドレス %1 をサーバ全体のホワイトリストから削除しました',
    'ui__server/spam-filter/white-list/address/delete_multi__done' => 'そのアドレスをサーバ全体のホワイトリストから削除しました',
    'ui__server/spam-filter/white-list/address/properties_new__done' => 'アドレスがホワイトリストに追加されました',
    'ui__server/spam-filter/white-list/address__done' => 'アドレスをホワイトリストに追加しました',
    'ui__server/spam-filter/white-list__done' => '操作が正常に完了しました', // PFU
    'ui__server/spam-filter__done' => '操作が正常に完了しました',
    'ui__server/statistics__done' => '操作が正常に完了しました',
    'ui__server/time__done' => "システム日時が変更されました",
    'ui__server__done' => "操作が正常に完了しました",
    'ui__sessions/properties__done' => '操作が正常に完了しました',
    'ui__sessions__done' => '操作が正常に完了しました',
    'ui__sessions/delete__done' => '選択したセッションが削除されました',
    'ui__start-page__done' => '操作が正常に完了しました',
    'ui__support__done' => 'サポートリクエストのフォームは、別のブラウザウインドウまたはタブが開いて表示されます。',

    ///
    /// END OF DONE MESSAGES
    ///

    ///
    /// ASSORTED COMMON KEYS / TBI
    ///

    // non-UI
    '__no_files_to_upload' => 'アップロードするファイルがありません',
    'login_up__access_denied_no_permission' => "アクセス拒否されました。 ログインパーミッションが付与されていません。",
    'mail__unable_remove_pattern' => "サーバブラックリストよりアドレスを削除できません。%1", // PFW
    'mail__incorrect_network_format' => '無効なネットワークフォーマット：%1', // PFW
    'initconf__unable_change_passwd' => "管理者のパスワードを変更できません：%1",
    'initconf__unable_get_passwd' => '現在の管理者パスワードを取得できません：%1 が失敗：%2',
    'initconf__invalid_hostname' => 'ホスト名 "%1" にエラーがあります',
    'initconf__unable_reconfig' => 'Plesk を構成できません：reconfig が失敗：%1',
    'initconf__unable_update_admin' => '管理者の連絡先情報を更新できません：%1',
    '__refresh' => '更新',
    '__dalias_not_exist' => 'ドメインエイリアスが存在しません',
    '__bug146523_explanation' => '以前のバージョンの Plesk では、FTP ユーザ名に最大 16 文字まで使用できました。現在のバージョンでは、FTP ユーザ名の最大文字数は 15 文字に制限されています。この問題を解決するには、影響のある FTP ユーザ名を最大 15 文字に短縮し、FTP ユーザ名を 1 文字以上変更してユーザ名の競合を回避してください。お手数をお掛けしまして申し訳ありません。',
    'domain__cannot_change_webmail' => 'ドメインのウェブメールを変更できません。 %1',
    'sb_publish_disable_warning' => 'Presence Builder によるウェブサイト作成をオフにすると、以前に Presence Builder で作成したウェブサイトは削除され、ウェブサイトデータがすべて失われます。続けるには［OK］をクリックしてください。',
    '__sbnet_client_use_sbnet' => "Presence Builder で関連ユーザアカウントを作成",
    'mail_resp_activate' => '自動応答をアクティブ化',
    'limitsManger__limit_available_error' => '必要なリソース量（%%limitName%%）を割り当てることができません。当該アカウントでは %%available%% のみ利用できます。',
    'limitsManger__limit_reserved_error' => '既に使用済みのリソースより少ないリソース（%%limitName%%）を割り当てることはできません。',
    'domain__unable_to_rename_vhost_dir_already_exists' => 'ドメイン名を変更できません。指定した名前の仮想ディレクトリは既に存在します。',
    'domain_unable_to_rename' => 'ドメインの名前を変更できません。',

    // Greylisting
    'spamfilter__general_settings_legend' => '全般',
    'spamfilter__spamassassin_status_legend' => 'SpamAssassin スパムフィルタ',
    'spamfilter__spamassassin_settings_legend' => 'SpamAssassin 設定',
    'spamfilter__spamassassin_server_status_legend' =>  "サーバ全体に対する SpamAssassin スパムフィルタをオンにする",
    'spamfilter__spamassassin_user_status_legend' => 'SpamAssassin スパムフィルタをオンにする',
    'spamfilter__greylisting_status_legend' => 'サーバ全体に対するグレイリストスパム防御をオンにする',
    'spamfilter__personal_settings_not_allowed' => '個別のスパムフィルタ設定の使用はシステムポリシーで許可されていません。',
    'spamfilter__required_score' => 'メッセージをスパムとして判断するスコア値',
    'spamfilter__rewrite_header_subject' => 'スパムとして検出されたメッセージの件名の先頭に、以下のテキストを追加',
    'spamfilter__use_mailuser_prefs' => 'スパムフィルタにユーザごとの設定を適用する',
    'spamfilter_addresses__text_hint' => '複数のアドレスは、改行して入力するか、スペース、タブ、カンマ、セミコロンで区切って入力してください。非 ASCII 文字を @ の左側のアドレス部分に含めることはできません。アドレス指定には、"*" および "?" ワイルドカードを使用できます（*@domain.com、user?@*.com など）。ドメイン名の非 ASCII 文字の部分にワイルドカードを使用しないでください。',
    'spamfilter__score_error' => 'スコアはマイナスにできません。小数点前の部分は 100 未満とし、小数点以下は 2 桁以内にします。',
    'spamfilter__rewrite_header_error' => 'メッセージの件名には、番号記号（#）以外のすべての表示可能文字を使用できます。',

    // template conflict keys
    'nonexistent_mail__mode_bounce' => 'バウンス',
    'nonexistent_mail__mode_discard' => '拒否',
    'nonexistent_mail__mode_catch_addr' => 'メールアドレスへの転送',
    'nonexistent_mail__mode_catch_ip' => '右のIP に転送',
    'nonexistent_mail__bounce_not_supported' => 'バウンスモードがサポートされていません',
    'nonexistent_mail__discard_not_supported' => '拒否モードがサポートされていません',
    'nonexistent_mail__catch_not_supported' => 'メールアドレスへの転送がサポートされていません。',
    'nonexistent_mail__redirect_not_supported' => 'IP への転送がサポートされていません',
    'nonexistent_mail__ip_used_on_this_host' => 'IP アドレスはローカルホストに解決されます。',
    'nonexistent_mail_address_should_be_local_domain' => '送信メールの制御がオンになっているため、存在しない受信者のメールアドレス %1 は選択したドメインに属していなければなりません。オンではない場合、転送の代わりに［拒否］ポリシーが適用されます。',
    'nonexistent_mail_address_should_be_local_domain_not_restricted' => '送信メールの制御がオンになっているため、メール転送用に指定されているメールアドレス（%1）は選択したドメインに属している必要があります。オンになっていない場合、このアドレス宛てに送信されたメッセージは送信メールの制御でカウントされません。',
    // mail acc extras
    '__antivirus' => "アンチウイルス",

    // web apps

    // none available
    'ui__admin-alias__none-available' => '追加管理者アカウントがありません', // PFW
    'ui__client/domain/certificate__none-available' => '顧客が SSL/TLS 証明書を所有していません。',
    'ui__client/domain/certificate__none-available__1' => '顧客に SSL/TLS 証明書付きのドメインがありません。',
    'ui__client/domain/certificate__none-available__2' => 'ドメインに SSL/TLS 証明書がありません。',
    'ui__reseller/client__none-available' => '顧客がいるリセラーがありません',

    // empty selection for lists
    'ui__client/ipaddress/delete__empty_selection' => 'IP プールから削除する IP アドレスを選択する必要があります。',
    'ui__server/ip-address/client/delete__empty_selection' => 'IP プール から IP アドレスを削除するリセラーアカウントを選択する必要があります。',
    'ui__server/crontab/task/delete__empty_selection' => 'キャンセルするタスクを選択する必要があります。',

    // scripting languages errors
    'phosting__php_not_enabled' => 'PHP サポートはこのウェブサイトに対してオフになっています。',
    'phosting__aspdotnet_not_enabled' => 'ASP.NET サポートがこのウェブサイトに対してオフになっています。',
    'phosting__php_forced_by_site_isolation' => 'PHP 設定は変更できません。サーバ全体のセキュリティポリシーをオーバーライドするパーミッションが付与されていません。',
    'phosting__option_forced_by_site_isolation' => '%1 設定を変更できません。サーバ全体のセキュリティポリシーをオーバーライドするパーミッションが付与されていません。',
    'phosting__php_handler_id_not_registered' => 'PHP ハンドラはサイト分離設定で許可されていません。デフォルトの PHP ハンドラが使用されます。',
    'phosting__php_served_by_nginx_is_not_available' => 'PHP ハンドラ（FPM アプリケーション + nginx）はサイト隔離設定で許可されません。デフォルトの PHP ハンドラが使用されます。',

    // various UI
    'ui__client/ipaddress/properties_readonly__short-title' => 'IP アドレス一覧を表示',
    'ui__client/ipaddress/properties_readonly__title' => 'IP アドレス一覧を表示',
    'ui__client/ipaddress/properties_readonly__description' => 'このユーザが使用できる IP アドレスの一覧を表示します。',
    'ui__server/certificate__short-title' => 'SSL/TLS 証明書',
    'ui__server/certificate__title' => 'SSL/TLS 証明書',
    'ui__server/certificate__description' => 'SSL/TLS 証明書を表示・管理します。',

    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__short-title' => 'MIME タイプの削除',
    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__title' => 'MIME タイプの削除',
    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__description' => '選択した MIME タイプの削除',
    'ui__client/domain/hosting/web-directories/mime-type/properties_unknown-new__short-title' => 'MIME タイプを追加',
    'ui__client/domain/hosting/web-directories/mime-type/properties_unknown-new__title' => 'MIME タイプを追加',
    'ui__client/domain/hosting/web-directories/mime-type/properties_unknown-new__description' => 'MIME タイプを登録します。',

    'ui__client/ipaddress/delete_multi__wizard-title' => 'IP アドレスの削除',
    'ui__client/ipaddress/delete_multi__wizard__2_multi' => '顧客 %1 の IP プールから削除する IP アドレスを選択します。',

    // mail

    'ui__client/ipaddress__short-title' => 'IP アドレス',
    'ui__client/ipaddress__title' => 'IP アドレス',
    'ui__client/ipaddress__description' => 'IP アドレスに関する情報を表示します。',
    'ui__server/ip-address__short-title' => 'IP アドレス',
    'ui__server/ip-address__title' => 'IP アドレス',
    'ui__server/ip-address__description' => 'IP アドレスに関する情報を表示します。',
    'ui__client/domain/hosting/setup__short-title' => 'ウェブホスティング設定',
    'ui__client/domain/hosting/setup__title' => 'ウェブホスティング設定',
    'ui__client/domain/hosting/setup__description' => 'ウェブサイト %1 のウェブホスティングを設定します。',
    'ui__client/domain/hosting/web-directories/mime-type/properties__short-title' => 'MIME タイプ', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties__title' => 'MIME タイププロパティ', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties__description' => 'MIME タイプのプロパティを表示する', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__short-title' => 'エラードキュメント', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__title' => 'エラードキュメント', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__description' => 'エラードキュメントプロパティ', // PFW

    // tooltips

    'b_resellerreportslist_remove' => '選択したレポートレイアウトの削除',
    'b_resellerreportslist_search' => '検索文字列を入力し、レポートレイアウトを検索する',
    'b_resellerreportslist_show_all' => 'すべてのレポートレイアウトを表示する',

    'l_resellerreportslist_auto' => '配信が自動であるか否かに基づいてレポートレイアウトを並べ替える',
    'l_resellerreportslist_clients' => '顧客情報に基づきレポートのレイアウトを並べ替えます。',
    'l_resellerreportslist_domains' => 'ドメイン情報に基づきレポートのレイアウトを並べ替えます。',
    'l_resellerreportslist_general' => '一般情報に基づきレポートのレイアウトを並べ替えます。',
    'l_resellerreportslist_name' => 'レポート名に基づきレポートレイアウトを並べ替える',
    'l_resellerreportslist_personal_domains' => '個人ドメイン情報に基づきレポートのレイアウトを並べ替えます。',

    'b_adminreportslist_remove' => '選択したレポートレイアウトの削除',
    'b_adminreportslist_search' => '検索文字列を入力し、レポートレイアウトを検索する',
    'b_adminreportslist_show_all' => 'すべてのレポートレイアウトを表示する',

    'l_adminreportslist_auto' => '自動配信であるかに基づいてレポートレイアウトを並べ替える',
    'l_adminreportslist_clients' => '顧客情報に基づきレポートのレイアウトを並べ替えます。',
    'l_adminreportslist_domains' => 'ドメイン情報に基づきレポートのレイアウトを並べ替えます。',
    'l_adminreportslist_general' => '一般情報に基づきレポートのレイアウトを並べ替えます。',
    'l_adminreportslist_name' => 'レポート名に基づきレポートレイアウトを並べ替える',
    'l_adminreportslist_personal_clients' => '自社の顧客情報に基づきレポートのレイアウトを並べ替えます。',
    'l_adminreportslist_personal_domains' => '自社のドメイン情報に基づきレポートのレイアウトを並べ替えます。',
    'l_adminreportslist_resellers' => 'リセラー情報に基づきレポートのレイアウトを並べ替えます。',

    'b_get_password_cancel' => 'メールを送信せずに前の画面に戻ります。',
    'b_get_password_send' => '［OK］をクリックすると、システムに登録されたメールアドレス宛てにパスワード復元用メッセージが送信されます。',



    'b_personaltrafficlist_search' => '検索文字列を入力し、ドメインを検索する',
    'b_personaltrafficlist_show_all' => 'すべてのドメインを表示する',

    'b_back' => '前のページに戻る',
    'b_next' => '次のページに進む',

    'b_dnsnstemplatelist_remove' => '選択したネームサーバを削除',
    'b_dnsnstemplatelist_search' => '検索文字列を入力し、ネームサーバを検索します。',
    'b_dnsnstemplatelist_show_all' => 'すべてのネームサーバを表示',

    'l_dnsnstemplatelist_ns' => 'ネームサーバによりDNS ゾーンテンプレートレコードを並べ替えます。',

    // filesharing management tool
    'cu__serverfilesharing_fsLinksAsHttps' => 'ファイルとフォルダへの安全なリンクを生成',
    'cu__serverfilesharing_fsPublicFolderEnabled' => 'パブリックファイルを有効化',
    'cu__serverfilesharing_fsPublicFolder' => 'パブリックファイルの保存用フォルダ',
    'cu__serverfilesharing_fsPublicUrl' => '訪問者がパブリックファイルにアクセスするための URL',
    'cu__serverfilesharing_fsPartnerFolderEnabled' => 'パブリックファイルのパスワード保護を有効化',
    'cu__serverfilesharing_fsPartnerFolder' => 'パスワード保護されたファイルの保存用フォルダ',
    'cu__serverfilesharing_fsPartnersLogin' => 'ファイルアクセス用ユーザ名',
    'cu__serverfilesharing_fsPartnersPassword' => 'ファイルアクセス用パスワード',
    'cu__serverfilesharing_fsDomain' => 'ウェブフォルダのルート URL。ドメイン名',
    'cu__serverfilesharing_fsPrefix' => 'ウェブフォルダのルート URL。プレフィックス',
    'cu__serverfilesharing_commandUpdate' => 'ファイル共有設定を更新',
    'cu__serverfilesharing_commandInfo' => '現在のファイル共有設定を表示',
    'subscription_rename_is_forbidden' => '契約の名前を変更することは、サーバ全体のポリシーで禁止されています。',
    ///
    /// END OF RANDOM COMMON KEYS
    ///

    ////
    //// CRONTAB - temporary
    ////

    // wizard:

    'ui__server/crontab/task_unknown__wizard-title' => 'サーバのスケジュール済みタスクを管理する',
    'ui__server/crontab/task_unknown__wizard__2_unknown' => 'スケジュール済みタスクを管理したいシステムユーザを選択してください。',

    'ui__server/crontab/task__short-title' => '%1',
    'ui__server/crontab/task__title' => 'スケジュール済みタスク %1',
    'ui__server/crontab/task__description' => 'スケジュール済みタスク %1 のプロパティを表示する',

    ///
    /// SERVER
    ///

    'ui__server/crontab_unknown__short-title' => 'システムユーザ',
    'ui__server/crontab_unknown__title' => 'システムユーザ',
    'ui__server/crontab_unknown__description' => 'スケジュール済みタスクの所有者である可能性があるシステムユーザ',


    'ui__server/crontab__none-available' => 'システムユーザアカウントがありません',
    'ui__server/crontab_readonly-unknown__description' => 'スケジュール済みタスクを参照する',
    'ui__server/crontab_readonly-unknown__short-title' => 'スケジュール済みタスク',
    'ui__server/crontab_readonly-unknown__title' => 'スケジュール済みタスクを参照する',
    'ui__server/crontab_readonly-unknown__wizard-title' => 'スケジュール済みタスクを参照する',
    'ui__server/crontab_readonly__description' => '%1 のスケジュール済みタスクを表示する',
    'ui__server/crontab_readonly__short-title' => '%1 のスケジュール済みタスク',
    'ui__server/crontab_readonly__title' => '%1 のスケジュール済みタスクを表示する',
    'ui__server/crontab_unknown__wizard-title' => 'スケジュール済みタスクを管理する',

    'ui__server/crontab/properties__description' => '%1 のスケジュール済みタスクを編集する',

    'ui__server/crontab/properties__short-title' => '設定',
    'ui__server/crontab/properties__title' => '%1 のスケジュール済みタスクを編集する',
    'ui__server/crontab/properties_readonly-unknown__description' => 'スケジュール済みタスクを参照する',
    'ui__server/crontab/properties_readonly-unknown__short-title' => '設定',
    'ui__server/crontab/properties_readonly-unknown__title' => 'スケジュール済みタスクを参照する',
    'ui__server/crontab/properties_readonly-unknown__wizard-title' => 'スケジュール済みタスクを参照する',
    'ui__server/crontab/properties_readonly__description' => '%1 のスケジュール済みタスクを参照する',
    'ui__server/crontab/properties_readonly__short-title' => '設定',
    'ui__server/crontab/properties_readonly__title' => '%1 のスケジュール済みタスクを参照する',
    'ui__server/crontab/properties_unknown__description' => 'スケジュール済みタスクを編集する',
    'ui__server/crontab/properties_unknown__short-title' => 'プロパティ',
    'ui__server/crontab/properties_unknown__title' => 'スケジュール済みタスクを編集する',
    'ui__server/crontab/properties_unknown__wizard-title' => 'スケジュール済みタスクを編集する',
    'ui__server/crontab/properties_unknown__wizard__2_readonly-unknown' => 'タスクを参照したいシステムユーザを選択する',
    'ui__server/crontab/properties_unknown__wizard__2_unknown' => 'タスクを変更したいシステムユーザを選択する',
    'ui__server/crontab/properties_unknown__wizard__3' => '終了をクリックして変更を適用し、ウィザードを終了してください',
    'ui__server/crontab/properties_unknown__wizard__3_readonly' => '終了をクリックしてウィザードを終了してください',

    'ui__server/crontab/task__none-available' => 'スケジュール済みタスクがありません',
    'ui__server/crontab/task__none-available__2' => 'システムユーザ %1 にスケジュール済みタスクが指定されていません',
    'ui__server/crontab/task_readonly-unknown__description' => 'スケジュール済みタスク',
    'ui__server/crontab/task_readonly-unknown__short-title' => 'タスク',
    'ui__server/crontab/task_readonly-unknown__title' => 'スケジュール済みタスク',

    'ui__server/crontab/task/delete__description' => 'スケジュール済みタスク %1 を削除する',

    'ui__server/crontab/task/delete__short-title' => '削除',
    'ui__server/crontab/task/delete__title' => 'スケジュール済みタスク %1 を削除する',
    'ui__server/crontab/task/delete_multi__description' => 'スケジュール済みタスクを削除する',

    'ui__server/crontab/task/delete_multi__short-title' => '削除',
    'ui__server/crontab/task/delete_multi__title' => 'スケジュール済みタスクを削除する',
    'ui__server/crontab/task/delete_multi__wizard-title' => 'スケジュール済みタスクを削除する',
    'ui__server/crontab/task/delete_multi__wizard__2_unknown' => 'タスクを削除したいシステムユーザを選択する',
    'ui__server/crontab/task/delete_multi__wizard__3_multi' => '削除したいタスクを選択する',
    'ui__server/crontab/task/delete_multi__wizard__4_multi' => 'タスクの削除を確認するにはチェックボックスを選択し、終了をクリックしてウィザードを終了してください',
    'ui__server/crontab/task/delete_unknown__description' => 'スケジュール済みタスクを削除する',
    'ui__server/crontab/task/delete_unknown__short-title' => '削除',
    'ui__server/crontab/task/delete_unknown__title' => 'スケジュール済みタスクを削除する',
    'ui__server/crontab/task/delete_unknown__wizard-title' => 'スケジュール済みタスクを削除する',
    'ui__server/crontab/task/delete_unknown__wizard__2_unknown' => '削除したいシステムユーザを選択する',
    'ui__server/crontab/task/delete_unknown__wizard__3_unknown' => '削除したいタスクを選択する',
    'ui__server/crontab/task/delete_unknown__wizard__4' => 'タスクの削除を確認するにはチェックボックスを選択し、終了をクリックしてウィザードを終了してください',

    'ui__server/crontab/task/properties__description' => 'スケジュール済みタスクを編集する',

    'ui__server/crontab/task/properties__short-title' => 'タスク %1 を編集する',
    'ui__server/crontab/task/properties__title' => 'スケジュール済みタスクを編集する',
    'ui__server/crontab/task/properties_new__description' => '%1 にスケジュール済みタスクを作成します。',

    'ui__server/crontab/task/properties_new__short-title' => 'タスクを追加',
    'ui__server/crontab/task/properties_new__title' => '%1 にスケジュール済みタスクを作成',
    'ui__server/crontab/task/properties_new__wizard-title' => 'スケジュール済みタスクを作成します。',
    'ui__server/crontab/task/properties_new__wizard__2_unknown' => 'スケジュール済みタスクを作成したいシステムユーザを選択してください。',
    'ui__server/crontab/task/properties_new__wizard__4_new' => '終了をクリックして変更を適用し、ウィザードを終了してください',
    'ui__server/crontab/task/properties_readonly-unknown__description' => 'スケジュール済みタスクを参照する',
    'ui__server/crontab/task/properties_readonly-unknown__short-title' => 'プロパティ',
    'ui__server/crontab/task/properties_readonly-unknown__title' => 'スケジュール済みタスクを参照する',
    'ui__server/crontab/task/properties_readonly-unknown__wizard-title' => 'スケジュール済みタスクを参照する',
    'ui__server/crontab/task/properties_readonly__description' => 'スケジュール済みタスクを参照する',
    'ui__server/crontab/task/properties_readonly__short-title' => 'タスク %1 を閲覧する',
    'ui__server/crontab/task/properties_readonly__title' => 'スケジュール済みタスクを参照する',
    'ui__server/crontab/task/properties_unknown-new__description' => 'スケジュール済みタスクを作成します。',
    'ui__server/crontab/task/properties_unknown-new__short-title' => 'タスクを追加',
    'ui__server/crontab/task/properties_unknown-new__title' => 'スケジュール済みタスクを作成',
    'ui__server/crontab/task/properties_unknown__description' => 'スケジュール済みタスクを編集する',
    'ui__server/crontab/task/properties_unknown__short-title' => 'プロパティ',
    'ui__server/crontab/task/properties_unknown__title' => 'スケジュール済みタスクを編集する',
    'ui__server/crontab/task/properties_unknown__wizard-title' => 'スケジュール済みタスクを編集する',
    'ui__server/crontab/task/properties_unknown__wizard__2_readonly-unknown' => 'タスクを参照したいシステムユーザを選択する',
    'ui__server/crontab/task/properties_unknown__wizard__2_unknown' => 'タスクを変更したいシステムユーザを選択する',
    'ui__server/crontab/task/properties_unknown__wizard__3_readonly-unknown' => 'スケジュール済みタスクを選択してください。',
    'ui__server/crontab/task/properties_unknown__wizard__3_unknown' => '変更したいスケジュール済みタスクを選択する',
    'ui__server/crontab/task/properties_unknown__wizard__4' => '終了をクリックして変更を適用し、ウィザードを終了してください',
    'ui__server/crontab/task/properties_unknown__wizard__4_readonly' => '終了をクリックしてウィザードを終了してください',

    'ui__server/crontab/task/toggle_disable__description' => 'スケジュール済みタスク %1 を無効にする',

    'ui__server/crontab/task/toggle_disable__short-title' => '無効化',
    'ui__server/crontab/task/toggle_disable__title' => 'スケジュール済みタスク %1 を無効にする',
    'ui__server/crontab/task/toggle_enable__description' => 'スケジュール済みタスク %1 を有効にする',

    'ui__server/crontab/task/toggle_enable__short-title' => '有効化',
    'ui__server/crontab/task/toggle_enable__title' => 'スケジュール済みタスク %1 を有効にする',
    'ui__server/crontab/task/toggle_unknown__description' => 'スケジュール済みタスクを有効または無効にする',
    'ui__server/crontab/task/toggle_unknown__short-title' => '有効または無効',
    'ui__server/crontab/task/toggle_unknown__title' => 'スケジュール済みタスクを有効または無効にする',
    'ui__server/crontab/task/toggle_unknown__wizard-title' => 'スケジュール済みタスクを有効または無効にする',
    'ui__server/crontab/task/toggle_unknown__wizard__2_unknown' => 'タスクを有効または無効にしたいシステムユーザを選択する',
    'ui__server/crontab/task/toggle_unknown__wizard__3_unknown' => '有効または無効にしたいタスクを選択する',


    /// not used on HP:

    'ui__client_unknown__short-title' => '顧客アカウント', // not used on HP?
    'ui__client_unknown__title' => '顧客アカウント', // not used on HP?
    'ui__client_unknown__description' => '顧客アカウントを管理します。', // not used on HP?
    'ui__client/domain/disable_unknown__title' => 'ドメインを一時停止', // not used on HP
    'ui__client/domain/disable_unknown__short-title' => 'ドメインを一時停止', // not used on HP,
    'ui__client/domain/disable_unknown__description' => 'ドメインを一時停止します。', // not used on HP
    'ui__client/domain/enable_unknown__title' => 'ドメインをアクティブ化', // not used on HP
    'ui__client/domain/enable_unknown__short-title' => 'ドメインをアクティブ化', // not used on HP
    'ui__client/domain/enable_unknown__description' => 'ドメインをアクティブ化します。', // not used on HP

    //Additional FTP Accounts
    'ftp__management_domain' => "ドメイン %1 の下の FTP アカウント", // for Additional FTP Accounts
    '__ftp_users_list' => "FTP アカウント",
    'ftp__user_name' => "FTP アカウント名",
    'ftp__user_home' => "ホームディレクトリ",
    'ftp__invalid_path' => "無効なパスが指定されました",
    'i_ftp_ses_sub_user' => 'FTP アカウントのセッション',
    '__new_passwd' => "新しい%1パスワード",

    ////
    //// Errors with custom template of Apache configuration
    ////

    'apacheConfigurationFailedMessageSubject' => 'ホスト <%%host%%> 上でウェブサーバを構成できません',
    'apacheConfigurationFailedMessageBody' => "以下のエラーが原因で、ホスト <%%host%%> 上でウェブサーバ構成ファイルを生成できません。\n\n%%error%%\n\nウェブサーバの構成テンプレートでエラーを修正し、ファイルを再生成してください。",

    'apacheConfigurationMessageAdminTitle' => 'ウェブサーバの設定に失敗しました',
    'apacheConfigurationMessageClientTitle' => '注意',

    'apacheConfigurationFailedAdminHomeMessage' => '構成テンプレートのエラーが原因で、新規構成ファイルが作成されませんでした。詳細なエラーメッセージをメールにて送信しました。メール内容を確認してエラーを修正し、%1 をクリックして構成の生成をもう一度試してください。',
    'apacheConfigurationFailedAdminHomeMessageLink' => 'こちら', //used on linked text in apacheConfigurationFailedAdminHomeMessage
    'apacheConfigurationFailedAdminDomainMessage' =>  'ドメイン %1 の新しい構成が、テンプレートのエラーにより作成されませんでした。詳細なエラーメッセージをメールにて送信しました。メール内容を確認してエラーを修正し、%2 をクリックして構成の生成をもう一度試してください。',
    'apacheConfigurationFailedAdminDomainMessageLink' => 'こちら', //used on linked text in apacheConfigurationFailedAdminDomainMessage

    'apacheConfigurationFailedUserDomainMessage' => 'ドメイン %1 のウェブサーバ設定に矛盾がある可能性があります。 サーバ管理者に連絡して問題を解決してください。',

    'apacheConfigurationFailedAdminDomainsMessage' => '構成テンプレートのエラーが原因で、一部のドメインに対して新規構成が構築されませんでした。詳細なエラーメッセージをメールにて送信しました。メール内容を確認してエラーを修正し、%1 をクリックして構成の生成をもう一度試してください。',
    'apacheConfigurationFailedAdminDomainsMessageLink' => 'こちら', //used on linked text in apacheConfigurationFailedAdminDomainsMessage

    'apacheConfigurationFailedUserDomainsMessage' => 'いくつかのドメインのウェブサーバ設定に矛盾がある可能性があります。 サーバ管理者に連絡して問題を解決してください。',



    ///HOSTING PARAMETERS
    '__apache_errdocs' => "カスタムエラードキュメント",
    'dom_pref__webusers_script' => "ウェブユーザにスクリプトの使用を許可",
    '__seoRedirect' => '優先ドメインを構成 -',
    '__seoRedirectToLanding' => 'domain.tld',
    '__seoRedirectToWww' => 'www.domain.tld',
    '__seoRedirectNone' => 'なし',

    '__sites' => 'ドメイン',
    'domain_plan__perm_denied_manage_phosting' => 'ホスティング設定を管理するパーミッションが付与されていません',
    '__owned_by_client' => '顧客が所有',
    'ui__client/permissions_readonly__description' => "顧客 %1 が Plesk で実行できるアクションを示します。",
    'backup__restore__object_client_template' => '顧客テンプレート',
    '__template_name' => 'サービスプラン名',
    'template__not_exists' => 'そのようなサービスプランは存在しません',
    'template__exists' => '%1 という名前のプランは既に存在します。',
    'clientOwnerChanger__ip_not_in_pool' => '指定した IP アドレスがリセラーのプール内に含まれていません。',

    //// Change owner of subscription
    'chown__select_title' => "新しい契約者の選択",
    'ui__client/domain/chowner_multi__wizard__3_multi-select' => '選択した契約の新しい所有者を選択して、［次へ >>］をクリックしてください',
    'domains__client_info' => "契約 %1 件、有効な契約 %2 件、ディスクスペース使用量 %3、トラフィック使用量 %4",
    '__possible_owners' => '契約の新規所有者の候補',

    'clients_list__filter_owner__filter_title' => 'プロバイダ',
    'clients_list__filter_owner_any' => 'すべてのユーザ',
    'clients_list__filter_owner_my' => 'マイ契約者のみ',
    'clients_list__filter_owner_name__filter_title' => 'プロバイダの名前',

    '__owner' => "プロバイダ",
    'l_clientslist_owner' => 'プロバイダに基づきユーザアカウントを並べ替えます。',
    'l_clientslist_date' => '作成日に基づきユーザアカウントを並べ替えます。',
    'l_clientslist_name' => '名前に基づきユーザアカウントを並べ替えます。',
    'l_clientslist_domains' => 'ドメインに基づきユーザアカウントを並べ替えます。',
    'l_clientslist_cname' => '会社名に基づきユーザアカウントを並べ替えます。',

    'ui__client/domain/chowner_multi__wizard-title' => '選択した契約の再割り当て',
    'chown__check_title' => '契約者を変更',

    'ui__client/domain/chowner_multi__wizard__3_multi' => "［終了］をクリックして再割り当てを完了します。 完了すると、選択した契約が新しい所有者に割り当てられ、そのプロバイダが新しい所有者のプロバイダに変更され、それらがサービスプランから外されて「カスタム」になります。",

    'chown__error_check' => '契約の一部を新しい所有者に割り当てようとして問題が発生しました',
    'domain_chown_subscription_will_be_anonymous' => "契約は現在のサービスプランとの紐付けが解除され、「カスタム」になります。",
    'chown__error_domains_exclude' => "契約の一部を新しい所有者に割り当てようとして問題が発生しました。 問題があった契約は強調表示されています。",
    'chown__ip_not_in_client_pool' => "この契約に割り当てられている IP アドレスは、新しい所有者の IP プールに割り当てられていません。",
    'chown__already_owned_by_client' => "この契約は既にこのユーザに属しています。",

    /// Protected directories

    'ui__client/domain/hosting/protected-directories/path__short-title' => '/%1',
    'ui__client/domain/hosting/protected-directories/path__title' => '保護ディレクトリ /%1',
    'ui__client/domain/hosting/protected-directories/path__description' => '保護ディレクトリ /%1 を管理',
    'ui__client/domain/hosting/protected-directories/path/properties_new__title' => 'サイト %1 下に保護ディレクトリを作成します。',
    'ui__client/domain/hosting/protected-directories/path/properties_new__short-title' => '保護ディレクトリを追加',
    'ui__client/domain/hosting/protected-directories/path/properties_new__description' => '保護ディレクトリを作成します。',
    'ui__client/domain/hosting/protected-directories/path/properties_new__done' => '保護ディレクトリ /%1 を作成しました',
    'ui__client/domain/hosting/protected-directories/path/properties__title' => '保護ディレクトリ /%1 の設定',
    'ui__client/domain/hosting/protected-directories/path/properties__short-title' => 'ディレクトリ設定',
    'ui__client/domain/hosting/protected-directories/path/properties__description' => '保護ディレクトリのロケーション、名前、およびエリアタイトルを変更します。',
    'ui__client/domain/hosting/protected-directories/path/properties__done' => '保護ディレクトリの設定を変更しました',
    'ui__client/domain/hosting/protected-directories/path/delete_multi__title' => '解除の確認',
    'ui__client/domain/hosting/protected-directories/path/delete_multi__short-title' => '保護を解除',
    'ui__client/domain/hosting/protected-directories/path/delete_multi__description' => '選択したディレクトリの保護を解除します。',
    'ui__client/domain/hosting/protected-directories/path/delete__empty_selection' => '保護を削除するディレクトリを選択してください',
    'ui__client/domain/hosting/protected-directories/path/delete#legend__description' => 'この処理によって、ディレクトリの保護が解除されます。 インターネットユーザがそのディレクトリに自由にアクセスできるようになります。',
    'ui__client/domain/hosting/protected-directories/path/delete_multi__done' => '選択したディレクトリの保護を解除しました',
    'ui__client/domain/hosting/protected-directories/path/user/properties_new__title' => 'ユーザを追加',
    'ui__client/domain/hosting/protected-directories/path/user/properties_new__short-title' => 'ユーザを追加',
    'ui__client/domain/hosting/protected-directories/path/user/properties_new__description' => '保護ディレクトリ %1 にアクセスするユーザアカウントの設定',
    'ui__client/domain/hosting/protected-directories/path/user/properties_new__done' => '保護ディレクトリ %1 にアクセスするユーザアカウントが作成されました',
    'ui__client/domain/hosting/protected-directories/path/user/properties__done' => "ユーザのクレデンシャルが保存されました。",
    'ui__client/domain/hosting/protected-directories/path/user/delete_multi__title' => '保護ディレクトリユーザの削除',
    'ui__client/domain/hosting/protected-directories/path/user/delete__empty_selection' => '削除するユーザを選択します。',
    'ui__client/domain/hosting/protected-directories/path/user/delete_multi__short-title' => '削除',
    'ui__client/domain/hosting/protected-directories/path/user/delete_multi__description' => 'ディレクトリユーザを削除します。',
    'ui__client/domain/hosting/protected-directories/path/user/delete#legend__description' => '保護ディレクトリの以下のユーザが削除されます。',
    'ui__client/domain/hosting/protected-directories/path/user/delete_multi__done' => '選択したユーザアカウントを削除しました',

    '__redirect_hint' => '15 秒以内に新しいアドレスに転送されます。 自動的に転送されない場合は、Java スクリプトを有効にするかハイパーリンク［%%link%%］をクリックしてください。',

    'backup__restore__object_maillist' => 'メーリングリスト',
    'backup__restore__object_site' => 'サイト',
    'backup__restore__object_user' => 'ユーザ',
    'backup__restore__object_role' => '役割',

    'limit__name_max_site' => 'サイト',

    'iis_pool__unable_rename_client' => "IIS アプリケーションプールを名前変更できません。 %1",

    'anonftp__is_not_supported_for_addon_domains' => '匿名 FTP サービスは、契約のメインドメインに対してのみサポートしています。',
    'anonftp__is_not_supported_for_addon_domains_powerUser' => '匿名 FTP サービスは、契約のメインドメインでのみサポートされます。',

    '__gb' => 'GB',
    '__tb' => 'TB',
    '__gb_month' => 'GB/月',
    '__tb_month' => 'TB/月',

    '__customers' => '顧客',
    '__customer_name' => '顧客名',
    '__customer_total' => '顧客の合計',
    '__site' => 'サイト',
    '__def_site' => 'デフォルトサイト',
    '__subscription_name' => '契約名',
    '__subscription_name_powerUser' => '契約名',

    'limit__units_max_traffic_suffix' => '/月',

    'dom_pref__discard' => "拒否",

    'mail__pattern_already_exists' => 'パターン「%1」は既にブラックリストに記載されています。',

    '__not_supported' => 'サポートされていない',

    'plesk_key__sitebuilder' => 'Presence Builder で公開するサイト数',
    'limit__name_max_site_builder' => 'Presence Builder で公開するサイト数',
    'plesk_key__wpb-multi-language-sites-support' => 'Presence Builder で多言語サイトをサポート',

    'ui__client/domain/traffic-hosting__title' => '<b>%1</b> のデータ転送統計',
    'ui__client/domain/traffic-hosting__title_powerUser' => '<b>%1</b> のデータ転送統計',
    'ui__client/domain/traffic-hosting#list__title' => "サービスのデータ転送統計",

    'login_up__access_denied_no_subscriptions' => "アクセス拒否されました。 このアカウントに使用可能な契約はありません。",

    'interval__day' => '%1 日',
    'interval__hour' => '%1 時間',
    'interval__minute' => '%1 分',
    'interval__second' => '%1 秒',

    ///License options
    'plesk_key__backward_incompatibility' => '他の Plesk バージョン用に作成されたライセンスキーを使用しようとしています。Plesk 営業担当までご相談のうえ、適切なライセンスキーをご購入ください。',
    //Standalone or virtualization
    'virtualization_any' => "物理サーバまたは任意の仮想化ソリューション",
    'virtualization_pvc' => "Virtuozzo containers",
    'virtualization_vmware' => "VMWare",
    'virtualization_hyperv' => "Microsoft Hyper-V",
    'virtualization_xen' => "Xen",
    'virtualization_kvm' => "KVM",
    'virtualization_parallels_server' => "Virtuozzo サーバ",
    'plesk_key__virtualization' => "有効になる環境：",
    'plesk_key__virtualization_only_key' => 'このライセンスキーは、%1 仮想環境内の Plesk での使用を前提としています。',
    'plesk_key__virtualizations_only_key' => 'このライセンスキーは、次の仮想環境内の Plesk での使用を前提としています。%1。',
    //Language options
    'plesk_key__invalid_locale_signature' => 'カスタム言語パックの使用は禁止されています。',
    'plesk_key__allowed-locales' => '使用可能な言語',
    'plesk_key__allowed-locales-any' => 'すべての言語',

    /// Web hosting settings on domain/subdomain

    '__cgi_bin_mode' => 'cgi-bin ディレクトリの場所：',
    '_cgi_bin_mode_webspace' => '契約のルートディレクトリ',
    '_cgi_bin_mode_www_root' => 'このドメインのドキュメントルート',

    /// Custom buttons
    'custom_button__sort_key' => '優先度',
    'custom_button__place' => '場所',
    'custom_button__place_navigation' => '共通アクセス',
    'custom_button__place_admin' => '管理者のホームページ',
    'custom_button__place_admin-settings' => '管理者の［ツールと設定］ページ',
    'custom_button__place_reseller' => "リセラーのホームページ",
    'custom_button__place_reseller-settings' => 'リセラーの［ツールとユーティリティ］ページ',
    'custom_button__place_client' => '顧客のホームページ',
    'custom_button__place_domain' => "契約の［ウェブサイトとドメイン］ページ",
    'custom_button__place_domain_powerUser' => "契約の［ウェブサイトとドメイン］ページ",
    'custom_button__place_domain-properties' => 'ウェブサイトツール',
    'custom_button__private' => '自分にのみ表示する',
    'custom_button__image' => '背景画像',
    'custom_button__conhelp' => "ヘルプのテキスト",
    'custom_button__edit' => "追加サービスへのリンクの設定",
    'custom_button__include_client_cname' => "顧客の会社名を含める",
    'custom_button__include_client_email' => "顧客のメールアドレスを含める",
    'custom_button__include_client_id' => "顧客 ID を含める",
    'custom_button__include_client_pname' => "顧客の担当者名を含める",
    'custom_button__include_domain_id' => "契約 ID、ドメイン ID、およびドメインエイリアス ID を含める",
    'custom_button__include_domain_id_powerUser' => "契約 ID、ドメイン ID、およびドメインエイリアス ID を含める",

    'custom_button__include_domain_name' => "プライマリドメイン名を含める",
    'custom_button__include_ftp_user' => "FTP ユーザ名を含める",
    'custom_button__include_ftp_pass' => "FTP パスワードを含める",
    'custom_button__internal_open' => "URL を Plesk で開く",
    'custom_button__text' => "ボタンラベル",
    'custom_button__url' => "URL",

    'custom_button__not_image' => 'このファイルはイメージファイルではありません。',
    'custom_button__big_image' => 'ファイルサイズは 100 KB 以内でなければなりません。',
    'custom_button__failed_copy_image' => 'ファイルをコピーできません。%1',


    'backup__restore__cannot_restore_non_power_user_dump_in_power_user_mode' => 'パワーユーザ以外のバックアップをパワーユーザビューで復元することはできません。',
    '__unknown_network_interface' => '不明なネットワークインターフェース',

    'init_conf__ip_address' => 'IP アドレス',

    //Confirmation page
    'bt_confirm' => '同意する',
    'b_confirm' => 'サイトの所有権を確認します。',

    'performance__iss_app_pool_forced_by_site_isolation' => '専用 IIS アプリケーションプールの設定は、サーバ全体のセキュリティポリシー（サイト分離設定）に準じて設定されます。',
    'performance__iss_app_pool_forced_by_server_wide_settings' => '専用 IIS アプリケーションプールの設定は、サーバ全体のパフォーマンス設定に準じて設定されます。',

    '__current' => '現行',
    'ui__client/domain/hosting/web-directories/protection/user/properties__done' => 'ユーザプロパティが更新されました',



    //// New Promos Block

    'promo__you_are_about_to_exceed_license_limit_max_dom' => 'Plesk ライセンスで提供されている大部分（90% 以上）のドメインを使用済みです。',
    'promo__you_are_about_to_exceed_license_limit_max_dom_title' => 'ほぼすべてのドメインを使用済みです。',
    'promo__you_are_about_to_exceed_license_limit_max_site_builder' => 'Plesk ライセンスで提供されている Presence Builder サイトの大部分（90% 以上）を使用済みです。',
    'promo__you_are_about_to_exceed_license_limit_max_site_builder_title' => 'Presence Builder サイトの大部分を使い切りました。',
    'promo__button_hide' => '隠す',
    'promo__button_next' => '次へ >>',
    'promo__button_prev' => '<< 前へ',
    'promo__button_license' => 'ライセンスをアップデートする',

    'promo__google_integration_title' => 'Google サービスとの統合',
    'promo__google_integration' => 'AdSense、Google Apps、ウェブマスターツールなどの Google サービスとの統合を設定します。',
    'promo__google_integration_button' => '構成',

    'promo__button_learn_more' => 'さらに詳しく',

    //// Plesk Branding in 10.1
    'panel_branding__description' => 'カスタムテーマを使用して、インターフェースの外観とブランド設定をカスタマイズできます。Plesk テーマのカスタマイズ方法は、%1 を参照してください。',
    'panel_branding__description_link' => '次のドキュメント',

    ///// File Manager new buttons
    'bt_extract_archive' => 'ファイルを展開',
    'b_filemanager__extract' => '選択したアーカイブから現在のディレクトリにファイルを抽出します。ファイル名に国別文字を使用している場合は、正しく表示されない場合がありますのでご注意ください。',
    'filemanager_error_extracting_files' => 'アーカイブファイル %1 の抽出時にエラーが発生しました',
    'filemanager_no_archive_files_specified' => '抽出するアーカイブを指定してください。',
    'filemanager_not_zip_archive_specified' => '%1 は ZIP アーカイブではないため、抽出できません。',
    'filemanager_files_successfully_extracted' => 'アーカイブファイルは抽出されました。',
    'filemanager_error_file_download' => 'ファイルのダウンロードに失敗しました：%1',
    'filemanager__user_poolgrp' => 'アプリケーションプールグループ',

    'loading' => '読み込み中...',
    'bt_create_archive' => 'アーカイブに追加',
    'filemanager__pack' => "アーカイブのパス：%1",
    'filemanager__archive_name' => 'アーカイブファイル名',
    'filemanager__empty_filename' => 'アーカイブファイル名を入力してください。',
    'filemanager_archive_created' => 'アーカイブが正常に作成されました。',
    'filemanager_error_creating_archive' => 'アーカイブを作成できません。 %1',

    'cmd_dns__aaaa_dns_record_already_exist' => "このレコードは、ゾーンの AAAA レコードと競合します。",
    'defaultcomponents__ftp_ipv6_hosting_not_supported' => "（FTP サーバが IPv6 アドレスをサポートしていません。）",
    'cmd_dns__glue_dns_record_conflict' => 'このレコードは、ゾーン「%1」のグルーレコードと競合します。',
    '__ftp_ipv6_not_supported' => "（FTP サーバが IPv6 アドレスをサポートしていません。）",
    '__ipv6_not_supported' => 'IPv6 をサポートしていません。',
    'mail__ipv6_not_supported' => 'メールサーバが IPv6 をサポートしていません。',
    'mail__relay_while_list_ipv6_not_supported' => 'メールサーバが IPv6 リレーホワイトリストをサポートしていません。',
    'mail__relay_while_list_ipv6_mask_mul_16' => 'マスクの値は 16 の倍数でなければなりません。',
    'mail__ip_or_mask_is_invalid' => 'IP アドレスまたはマスクが無効です。',
    'nonexistent_mail__redirect_ipv6_not_supported' => 'IPv6 IP アドレスへの転送はサポートされていません。',
    'sa__invalid_trusted_networks' => '信頼できるネットワークが正しく指定されていません。%1',
    'dns_add__enter_ipv6_address' => "IPv6 アドレス",
    'license_trial_days_left' => 'Plesk は現在、トライアルライセンスで機能しており、残り %1 日で期限が切れます。',
    'excl_ipv6_num' => '専用 IPv6 アドレス',
    '__ip_mask' => "サブネットマスク",
    '__ipv4_addr' => 'IPv4 アドレス',
    '__ipv6_addr' => 'IPv6 アドレス',
    'template__num_excl_ipv6s' => 'リセラーに専用 IPv6 アドレスを割り当てる',
    'anonftp__exclusive_ipv4_required' => '匿名 FTP サービスを使用するためには専用 IPv4 アドレスが必要です。',
    'anonftp__ipv4_already_used' => 'このサイトには匿名 FTP サービスをセットアップできません。このサービスは同じ IPv4 アドレスの他のドメインに対して既に構成されています。',


    'restart__kav' => "Kaspersky アンチウイルス",
    '__view_migration_log_detailed_info' => 'ログを表示',

    'chown__ip_address_warn' => '契約を新しい所有者に移管する前に、契約に対して新しい IP アドレスを選択する必要があります。',
    'chown__no_ip_address' => 'なし',
    'chown__no_ipv4_address' => 'IPv4 アドレスがありません',
    'chown__no_ipv6_address' => 'IPv6 アドレスがありません',
    'chown__domain_exclude_already_owned_by_client' => '契約 %1 は既にこのユーザに属しています。',
    'chown__error_ip_absent_in_ip_pool' => 'IP アドレス %1 がターゲットユーザの IP アドレスに存在しません。',
    'chown__error_ip_not_exist' => 'ID が「%1」の IP アドレスが存在しません。',
    'chown__error_domain_ip_not_selected' => 'ドメイン %1 に対して 1 つ以上の IP アドレスを選択する必要があります。IP マッピングに対して選択された値を確認してください。',

    '__new_passwd_single' => "パスワード",
    '__confirm_passwd_single' => "パスワードの確認",

    'mail__ip_or_mask_is_invalid_ipv6' => 'IPv6 アドレスまたはマスクが無効です。IP アドレスは有効なユニキャストアドレスである必要があります。',

    '__subscriptions' => '契約',

    '__owned_by_reseller' => 'リセラーが所有',
    '__owned_by_provider' => 'プロバイダが所有',

    'service_plan__anonymous' => 'カスタム',
    'subscription_not_locked__change_limits_warning' => 'この契約はロックされていません。サービスプランとの同期中にリソースの使用量制限が変更されます。',
    'subscription_not_locked__change_permissions_warning' => 'この契約はロックされていません。サービスプランとの同期中にパーミッションが変更されます。',

    'subscription__conflict_resolution_policy' => '競合解決ポリシー',
    'subscription__conflict_resolution_policy_lock' => "契約をロックする",

    'backup__list__backup_warnings' => '警告',
    'backup__list__backup_info' => '情報',
    'backup__restore__object_reseller_template' => 'リセラーテンプレート',
    'backup__restore__object_domain_template' => 'ドメインテンプレート',

    'ui__client/permissions_readonly__title' => 'パーミッション',
    'ui__client/permissions_readonly__short-title' => 'パーミッション',

    'subscription__unable_lock_anonymous' => 'この契約はサービスプランに関連付けられていないため、ロック解除できません。',
    'subscription__unable_sync_anonymous' => 'この契約はサービスプランに関連付けられていないため、同期できません。',
    'subscription__unable_sync_locked' => 'この契約はロックされており、同期できません。',
    'subscription__locked' => 'この契約はロックされています。',
    'component_name__urlrewrite' => "URL Rewrite",
    '__quantity' => '量',
    'hst__www_root_dir_absent' =>  '警告：文書のルートとして指定されたディレクトリが存在しません。',
    'object_creation__domain_is_not_a_webspace' => 'このオブジェクトは契約内でのみ作成できます。',
    'phosting__webspace_hosting_with_sites_cannot_be_deleted' => '契約にサイトが含まれるため、ホスティングタイプを変更したり、削除することはできません。',
    'phosting__addon_domain_ip_must_match_webspace' => 'エラー：IP アドレスの更新に失敗しました。アドオンドメインには、契約のメインドメインに割り当てられていない IP アドレスは割り当てることができません。',
    'domain_plan__unable_change' => 'サービスプランを変更できません。 %1.',
    'domain_plan__different_hosting_type' => '現在のホスティングタイプは、サービスプランに指定されているタイプと異なります。',
    'domain_plan__addon_text' => 'アドオンプラン',
    'domain_plan__addon_description' => 'アドオンプランはホスティングプランの補足として使用されます。',
    'asp_net__managed_runtime_version' => 'ASP.NET マネージドランタイムバージョン',
    'plan__can_not_change_hosting_type' => 'プランの編集時にホスティングタイプを変更することはできません。',
    'plan__apply_problems' => '次の機能に問題があるため、このプランは適用されませんでした：%1',
    'plan_save__subscription_update_problem' => '%1 にプランの変更を適用することはできません。',
    '__perm_denied_subscription_suspended_by_backuprestore' => "契約は、バックアップまたは復元のプロセスが完了するまで一時停止されています。後でもう一度やり直してください。",
    '__login_incorrect_plain_shadow_password' => '管理者のアカウントに指定したパスワードが正しくありません。システム管理者（root）のクレデンシャルを使用するか、正しいパスワードを取得してください。パスワードの取得について詳しくは、/etc/psa/README.psa.shadow ファイルで説明しています。',

    '__perm_denied_ip' => '所有していない IP アドレスを送信することはできません',

    'dns__dns_zone_not_synchronized' => 'DNS ゾーンが変更されました。DNS テンプレートの変更をこのゾーンに適用するには、このページの［DNS テンプレートの変更を適用］をクリックするか、サーバ管理パネルの［ツールと設定］>［DNS テンプレート設定］>［DNS テンプレート設定］で［すべてのゾーンに変更を適用する］オプションを選択してください。',
    'dns__dns_zone_synchronize_link' => 'クリック',
    'dns__dns_zone_synchronize_done' => 'DNS ゾーンが正常に同期されました。',

    'dns__dns_zone_template_error' => 'DNS ゾーンを DNS ゾーンテンプレートと同期する際に問題が発生しました。%1',

    'dns__soa_rname_type_owner' => 'ウェブサイト所有者のメールアドレス',
    'dns__soa_rname_type_domain' => 'ドメインのメールアドレス',
    'dns__soa_rname_type_external' => '外部のメールアドレス',
    'dns__soa_rname_enforce_email' => 'ドメインごとに RNAME メールアドレスを変更することを禁止',
    'dns__soa_rname_label' => 'メールアドレス（RNAME）',
    'dns__soa_rname_hint' => 'ドメインの DNS ゾーンの責任者のメールアドレス。SOA クエリへの応答として DNS サーバから返されました。',

    'dns__dns_zone_soa_sync_title' => '既存のすべてのドメインの SOA 設定をオーバーライドする',
    'dns__dns_zone_soa_sync_legend' => '確認が必要',
    'dns__dns_zone_soa_sync_text' => 'SOA テンプレートに加えた変更を適用して、ホストされているすべてのドメインの SOA レコードを更新しますか？',

    'cu_db__repair_mysql_dbus' => "MySQL ユーザパスワードを修復します。この作業は、旧バージョンから Plesk 11 にアップグレードした場合に必要です。",

    'scheduled_backup_settings__start_at_hint' => 'スケジュールされているバックアップタスクのチェック間隔は 15 分です。決まった時間にバックアップタスクを開始させる場合、タスクを必要な時間より最低 15 分以上前にスケジュールしてください。',
    'cu_scheduled_backup_comment' => 'スケジュール済みバックアップ',
    'cu_scheduled_backup_error' => 'バックアップ処理中にエラーが発生しました：%1',
    'cu_scheduled_backup_mail_subject' => '<%1> スケジュール済みバックアップ中にエラーが発生しました。',
    'cu_scheduled_backup_mail_message' => "%1\nPlesk エントリポイント：%2\n\nスケジュール済みバックアップの処理中に以下のエラーが発生しました：\n\n%3",
    'cu_scheduled_backup_comment_backup_all' => 'スケジュール済みバックアップ。すべての構成とコンテンツ。',
    'cu_scheduled_backup_comment_backup_vhost' => 'スケジュール済みバックアップ。メール以外のすべての構成とコンテンツ。',
    'cu_scheduled_backup_comment_backup_mail' => 'スケジュール済みバックアップ。メールの構成とコンテンツのみ。',
    'cu_scheduled_backup_comment_backup_domain' => 'スケジュール済みバックアップ。ドメインの構成。',
    'cu_scheduled_backup_to_cloud_not_allowed' => 'リモートクラウドストレージにスケジュール済みバックアップを保存するのは有料機能です。利用するにはホスティング事業者までお問い合わせください。',

    'i_backup_invalid_file' => 'このバックアップは無効ですこのファイルからデータを復元できません。詳しくはバックアップ名をクリックしてください。',

    'ui__server/migration/download-agent__short-title' => '移行・移管エージェントのダウンロード',
    'ui__server/migration/download-agent__title' => '移行・移管エージェントのダウンロード',
    'ui__server/migration/download-agent__description' => 'Plesk ウェブサイトから最新バージョンの移行・移管エージェントをダウンロードします。',

    'filemanager_resulting_archive_exists' => 'ファイル %1 はターゲットディレクトリに既に存在します。',

    'agent_unable_to_connect' => '「%2」でのエージェントへの接続に失敗しました。エージェントがインストール済みで稼働しており、ホスト「%2」との接続で問題が発生していないことを確認してください。',
    'agent_test_connection_failed' => '「%2」でのエージェントへの接続に失敗しました。',

    'agent_unable_to_resolve_host' => 'リモートホスト「%1」が見つかりません。ホストとの接続で問題が発生していないことを確認してください。',
    'agent_unknown_curl_error' => '「%2」のエージェントへの接続中にエラー「%1」が発生しました。',
    'agent_unexpected_htp_code' => '「%2」のエージェントへの HTTP 要求で、予期しない HTTP コード「%1」が受信されました。',
    'agent_unable_to_auth' => 'ホスト \'%1\' で認証できませんでした。この問題を解決するには、http://kb.plesk.com/jp/116606 の指示に従ってください。',
    'agent_internal_server_error' => 'リモートホスト「%1」でのコマンド実行中に内部サーバエラーが発生しました。',
    'agent_response_is_empty' => '「%1」のエージェントへの HTTP 要求で空の応答が受信されました。',

    'migration__disabled_due_to_local_file_does_not_exist' => 'ローカルキャッシュで移行・移管エージェントが見つかりません。問題を解決するには、移行・移管マネージャを再び開いてください。',

    '__hosting_webdeploy' => "Web Deploy パブリッシング",
    'cu_domain__webdeploy' => "Web Deploy パブリッシング（デフォルト：%1）",
    'cu_dom_tpl__webdeploy' => "Web Deploy パブリッシング（デフォルト：%1）",
    'cu_subdomain__webdeploy' => "Web Deploy パブリッシング（デフォルト：%1）",
    'webdeploy__not_installed' => "Microsoft Web Deploy がサーバにインストールされていません。",
    'webdeploy__forced_by_site_isolation' => "Web Deploy パブリッシング設定を変更できません。サーバ全体のセキュリティポリシーをオーバーライドするパーミッションが付与されていません。詳細はプロバイダまでお問い合わせください。",



    'backup__restore_options__admin__server_configuration_license' => 'ライセンスキー',
    'migration_start_migrate_server_license' => 'ライセンスキーを移管',

    'defaultcomponents__delegation_rule_not_exist' => '（必要な委任ルール appPoolPipeline, appPoolNetFx が存在しません）',

    '__o' => 'O',

    'i_backup_created_by_admin' => '管理者がバックアップを作成しました。',
    'i_backup_created_by_reseller' => 'リセラーがバックアップを作成しました。',
    'i_backup_created_by_client' => '顧客がバックアップを作成しました。',

    'migration__object_exists_on_target_host' => '（ターゲットホストに既に存在）',

    '__customers_total' => '顧客別の合計',
    '__resellers_total' => 'リセラー別合計',
    '__reseller_total' => 'リセラー合計',


    'cu_cl_pref__manage_website_maintenance' => '詳細オペレーションへのアクセス：ウェブサイトのコピー',
    'cu_cl_pref__manage_protected_dirs' => 'パスワード保護ディレクトリ管理',
    'cu_cl_pref__manage_mail_settings' => 'メール設定の変更',


    'cu__command_update_php_settings' => 'PHP 設定を更新します。',
    'cu__php_settings_option' => 'PHP ディレクティブのファイルへのパスを設定します。',

    'cu__additional_php_settings_option' => '追加 PHP ディレクティブのファイルへのパスを設定します。',
    'cu__command_show_php_settings' => '現在の PHP 設定を表示します。',
    'cu__general_settings' => '一般設定：',
    'cu__performance_settings' => 'パフォーマンス設定：',
    'cu__php_fpm_settings' => 'PHP-FPM 設定：',
    'cu__additional_directives' => '追加ディレクティブ：',

    'php_settings_permission_required' => '共通 PHP 設定管理',
    'php_settings_performance_permission_required' => 'ホスティングパフォーマンス設定管理',
    'php_settings_customized' => 'PHP 設定がカスタマイズされました。',
    'php_settings_synchronized_with_plan' => 'PHP 設定をプランと同期する必要があります。',
    'phosting__unknown_shell_type' => '利用可能ではないシェル',

    'login_up__access_denied_subscription_deleted' => 'アクセス拒否されました。契約は削除されました。',

    'role_restricted_to_subscription' => '（契約 %1 で移管）',

    'filemanager__extract' => "ファイルを %1 に抽出",

    'cu__license_command_check_installed_license' => 'インストールされたライセンスキーの有効性をチェック（キーが有効な場合は 0 終了コードを、無効な場合は 1 を返します）',

    'promo__mobile_manager_title' => 'Plesk Server Mobile Manager',
    'promo__mobile_manager' => "Plesk の機能が拡張され、モバイルデバイス（BlackBerry、iPhone、Android）でサーバをコントロールまたはモニタリングできるようになります。",
    'promo__mobile_monitor_title' => 'Plesk Server Mobile Monitor',
    'promo__mobile_monitor' => 'モバイルデバイス（BlackBerry、iPhone、Android）を使用していつでもどこからでも Plesk サーバに関する重要情報を収集することができます。',
    'promo__mobile_button' => 'さらに詳しく',

    'ui__server/migration/video__short-title' => 'ビデオチュートリアル',
    'ui__server/migration/video__title' => 'ビデオチュートリアルを再生',
    'ui__server/migration/video__description' => 'ビデオチュートリアルを再生します。',

    'subDomainNameHint' => 'ワイルドカードサブドメインを作成するには、サブドメイン名に「*」と入力してください。サイト訪問者は、ブラウザに入力したサブドメイン名を問わず、このサブドメインにリダイレクトされます。',
    'subdomains__wildcard_name_invalid' => "サブドメイン名は無効です。ワイルドカードサブドメイン名には英数字、ハイフン（-）、アスタリスク（*）のみを使用できます。",
    'subdomains__name_invalid' => "サブドメイン名は無効です。サブドメイン名には英数字とハイフン（-）のみを使用できます。",

    'domain__wildcard_no_www_prefix' => 'ワイルドカードサブドメインに www プレフィックスを使用することはできません。',

    '__service_title__milter' => "Plesk Postfix メールフィルタ",
    '__service_description__milter' => "Plesk Postfix メールフィルタ",
    '__milter' => "Postfix メールフィルタ",
    'restart__milter' => "Plesk メールフィルタ（%1）",
    'restart__pop3' => "Courier POP3 サーバ",
    'restart__pop3s' => "Courier POP3 サーバ、SSL/TLS サポート",
    'restart__imap' => "Courier IMAP サーバ",
    'restart__imaps' => "Courier IMAP サーバ、SSL/TLS サポート",
    'restart__authdaemon' => "Courier IMAP 認証デーモン",
    'restart__imap-pop3' => "Dovecot IMAP および POP3 サーバ",


    'addon_packages_not_supported' => 'APS パッケージされたウェブアプリケーション用のアドオンはサポートされていません。',
    'cu_domain__unable_to_automaticaly_select_ip' => 'ドメインに IP アドレスを自動的に割り当てることができません。-ip オプションを使用して IP アドレスを指定してください。',

    'plesk_key__mb_accounts' => 'Customer and Business Manager のユーザアカウント（リセラーおよび顧客）',

    'actionlog__subdomain_dns' => 'サブドメイン DNS ゾーン',
    'actionlog__site_subdomain_dns' => '追加ドメイン下のサブドメインの DNS ゾーン',

    // PfW only
    'actionlog__event_site_create' => 'ドメインの作成',
    'actionlog__event_site_delete' => 'ドメインの削除',
    'actionlog__event_site_update' => 'ドメインの更新',

    'actionlog__event_site_status_update' => 'ドメインステータスの更新',
    'actionlog__event_site_dns_update' => 'ドメイン DNS ゾーンの更新',
    'actionlog__event_site_guid_update' => 'ドメイン GUID の更新',

    'actionlog__event_site_subdomain_create' => 'サブドメインの作成',
    'actionlog__event_site_subdomain_delete' => 'サブドメインの削除',
    'actionlog__event_site_subdomain_update' => 'サブドメインの更新',

    'actionlog__event_site_alias_create' => 'ドメインエイリアスの作成',
    'actionlog__event_site_alias_delete' => 'ドメインエイリアスの削除',
    'actionlog__event_site_alias_update' => 'ドメインエイリアスの更新',

    'actionlog__event_site_alias_dns_update' => 'ドメインエイリアスの DNS ゾーンの更新',
    'actionlog__event_subdomain_dns_update' => 'デフォルトドメイン下のサブドメインの DNS ゾーン更新',
    'actionlog__event_site_subdomain_dns_update' => 'サブドメインの DNS ゾーンの更新',
    // End of PfW only

    'win_policy__bad_password' => '検証に失敗しました。パスワードが無効です',
    'win_policy__password_too_short' => '検証に失敗しました。パスワードが短すぎるため、ポリシー要件を満たしていません',
    'win_policy__password_too_long' => '検証に失敗しました。パスワードが長すぎるため、ポリシー要件を満たしていません',
    'win_policy__password_not_complex_enough' => '検証に失敗しました。パスワードが十分に複雑ではなく、パスワードポリシーの要件を満たしていません。強力なパスワードには、最低でも次のすべてが含まれる必要があります：長さ 8 文字以上、大文字/小文字 が 1 つ、数字が 3 つと特殊文字（!、@、#、$、%、^、&、*、?、_、~）が 1 つ（または数字が 1 つと特殊文字が 2 つ）。',

    //// Activation Code feature
    'plesk_key__license_update_failed' => '製品ライセンスを更新できません。',


    'filemanager__error_path_is_not_allowed' => '許可されていないパスです',
    'filemanager__error_path_is_invalid' => '無効なパス',
    'filemanager__error_path_not_found' => 'パスが見つかりません',
    'filemanager__error_path_already_exists' => 'パスは既に存在します。',
    'filemanager__error_access_is_denied' => 'アクセス拒否',
    'filemanager__error_directory_not_empty' => 'フォルダは空ではありません',
    'filemanager__error_sharing_violation' => '共有違反',
    'filemanager__error_not_same_device' => '移動先パスは同じデバイス上にありません',
    'filemanager__binary_data_access' => 'バイナリファイルです。本当に開きますか？',
    'filemanager__unable_to_resolve_realpath' => "指定されたロケーションにファイル %1 が見つかりません",
    'filemanager__access_to_realpath_denied' => "realpath へのアクセスが拒否されました： %1 から %2",
    'bt_exit' => '終了',

    'filemanager__chdir_error__' => "ディレクトリを%1に変更することができません。%2",
    'filemanager__chmod_dir' => "ディレクトリ%1のパーミッションを変更する",
    'filemanager__chmod_error__' => "ファイル%1のパーミッションを変更することができません。%2",
    'filemanager__chmod_file' => "ファイル%1のパーミッションを変更する",
    'filemanager__copy_error__' => "%2に%1をコピーすることができません。%3",
    'filemanager__copy_move' => "%1 からファイルをコピー（移動）",
    'filemanager__count_size__' => '選択したサイズ： %1',
    'filemanager__count_size_error__' => '%1 のサイズを計測することができません。%2',
    'filemanager__create_dir' => "ディレクトリ作成",
    'filemanager__create_dir_error__' => "ディレクトリ%1を作成することができません。%2",
    'filemanager__dir_not_exists' => "ディレクトリ %1 が存在しません",
    'filemanager__dirname' => "ディレクトリ名",
    'filemanager__filename' => "ファイル名",
    'filemanager__is_no_such' => "%1という名前のファイル、ディレクトリはありません",
    'filemanager__empty_selection' => "ファイルが選択されていません。",
    'filemanager__file_exists' => "ファイル %1 は既に存在します。",
    'filemanager__move_error__' => "%2に%1を移動させることができません。%3",
    'filemanager__new_dir' => "ディレクトリ名",
    'filemanager__not_allowed' => "ファイルのパーミッションを変更するパーミッションがありません",
    'filemanager__r_perm_dir' => "リストディレクトリ",
    'filemanager__r_perm_file' => "読み込みデータ",
    'filemanager__remove' => "%1からファイルを削除します。",
    'filemanager__remove_error__' => "ファイル%1を削除することができません。%2",
    'filemanager__rename_dir' => "ディレクトリ%1の名前を変更します。",
    'filemanager__rename_error__' => "%1を%2に変更することができません。%3",
    'filemanager__rename_file' => "ファイル %1 の名前変更",
    'filemanager__set_win_permissions_dir' => "%1フォルダのパーミッションを設定します。",
    'filemanager__set_win_permissions_file' => "%1ファイルのパーミッションを設定します。",
    'filemanager__touch_confirm' => "選択したファイルのタイムスタンプを変更しますか？",
    'filemanager__no_perms_or_unsupported_file_type' => 'ファイルを読み込むことができないか、サポートされていないファイルフォーマットです',
    'filemanager__upload_error__' => "%1を%2にアップロードすることはできません。%3",
    'filemanager__upload_file' => "ファイルアップロード",
    'filemanager__upload_file_src' => "ファイルパス",
    'filemanager__username' => "ユーザ",
    'filemanager__w_perm_dir' => "ファイル作成",
    'filemanager__w_perm_file' => "データ書き込み",
    'filemanager__x_perm_dir' => "Traverse ディレクトリ",
    'filemanager__x_perm_file' => "実行ファイル",
    'filemanager__max_image_size_exceeded' => 'イメージを表示できません。%2 バイトより大きいイメージサイズは許可されません。',

    '__fastcgi_unix_support' => 'FastCGI サポート',

    'dns__subdomain_dns_zone_parent' => 'このサブドメインの DNS レコードは親 DNS ゾーンに保存されています。親ゾーン %1 を変更するか、サブドメインに別のゾーンを作成することができます。',
    'dns__subdomain_dns_zone_parent_link' => 'こちら',
    'dns__no_dns_zone' => 'ドメインに割り当てられた DNS ゾーンがありません。ドメイン用の DNS ゾーンを管理するには、［デフォルトを復元］ボタンを押してください。',
    'dns__unable_turn_on_subdomain_zone' => 'サブドメインのゾーンをオンにできません。このサブドメインには、親ドメインのゾーンに CNAME レコードがあります。',

    '__hosting_write_modify' => '追加の書き込み/変更パーミッション',

    'aspdotnet__group_framework_version' => "フレームワークバージョン",
    'aspdotnet__param_version' => "バージョン",

    'bt_restore_default' => "リセット",
    'b_aspdotnet' => 'ASP.NET 構成設定を編集する',
    'b_aspdotnet__restore_default' => 'デフォルト ASP.NET 設定を復元します。',
    'b_aspdotnet__restore_wdir_default' => "この仮想ディレクトリ用の親ディレクトリの ASP.NET 設定を復元する",
    'b_aspdotnet__restore_default_disabled' => 'デフォルト ASP.NET 設定を復元できません。 サーバ上または親ディレクトリレベルで ASP.NET 設定が破損している可能性があります。',
    'b_autoinstaller' => 'Plesk またはそのコンポーネントを更新します。',
    'b_autoinstaller_configure' => '設定を更新してください。',
    'b_autoinstaller_install' => '選択したコンポーネントをインストールする',

    '__iis_app_pool__use_dedicated' => '専用 IIS アプリケーションプール',
    '__iis_app_pool__use_dedicated_addons' => '各ウェブサイト用の専用 IIS アプリケーションプール',
    '__iis_app_pool__enable_32bit_app_on_win64' => '32 ビットアプリケーションを有効にする',
    'bt_iis_app_pool' => "IIS アプリケーションプール",

    'performance__cpu_usage' => '最大 CPU 使用率（%）',
    'performance__cpu_usage_action' => '制限動作',
    'performance__cpu_usage_interval' => '制限間隔（分）',
    'performance__cpu_usage_action_not_supported' => '指定した動作はウェブサーバでサポートされません。',

    'performance__idle_timeout_action_not_supported' => '指定したアイドルタイムアウト動作はウェブサーバでサポートされません。',
    'performance__max_worker_processes' => '最大ワーカプロセス数',
    'performance__idle_timeout' => 'アイドルタイムアウト（分）',
    'performance__idle_timeout_action' => 'アイドルタイムアウト動作',
    'performance__recycling_by_time' => '定期リサイクル（分）',
    'performance__recycling_by_requests' => '最大リクエスト数に達した場合にリサイクル',
    'performance__recycling_by_virtual_memory' => '仮想メモリの使用が上限に達した場合のリサイクル',
    'performance__recycling_by_private_memory' => '専用メモリの使用が上限に達した場合のリサイクル',
    'performance__managed_pipeline_mode' => 'マネージパイプラインモード',
    'performance__managed_pipeline_mode_not_supported' => '指定したモードはウェブサーバでサポートされません。',

    'iis_app_pool' => 'IISアプリケーションツール管理',
    'b_iis_app_pool' => 'IIS アプリケーションプール管理',
    'iis_app_pool_cl_dom' => 'IIS アプリケーションプール管理',

    'i_webdirs_not_protected' => 'このディレクトリは保護されていません',
    'i_webdirs_protected' => 'このディレクトリは保護されています。',
    'i_webdirs_manage_protection' => '保護を管理します。',
    'i_webdirs_open' => 'ブラウザでディレクトリ/ファイルを開きます。',
    'i_webdirs_preferences_disabled' => 'これは仮想ディレクトリではありません。',
    'i_webdirs_permissions' => 'パーミッションを管理します。',
    'i_webdirs_permissions_disabled' => 'ディレクトリパーミッション管理は現在使用できません',
    'i_webdirs_type_dir' => '物理ディレクトリ',
    'i_webdirs_type_vdir' => '仮想ディレクトリ',
    'i_webdirs_browse' => 'ディレクトリコンテンツをブラウズします。',
    'i_webdirs_preferences' => 'ウェブディレクトリ設定管理',

    'l_webdirslist_type' => 'タイプ順にディレクトリを並べ替える',
    'l_webdirslist_protected' => '保護ステータス順にディレクトリを並べ替える',
    'l_webdirslist_name' => '名前順にディレクトリを並べ替える',

    'b_webdirslist_remove' => '選択した仮想ディレクトリを削除します。',
    'b_webdirslist_search' => '検索文字列を入力し、仮想ディレクトリを検索します。',
    'b_webdirslist_show_all' => 'すべてのウェブディレクトリを表示します。',

    'l_webdirerrordocslist_code' => 'エラードキュメントをエラー番号順に並べ替える',
    'l_webdirerrordocslist_name' => 'エラードキュメントを説明順に並べ替える',
    'l_webdirerrordocslist_type' => 'エラードキュメントをエラードキュメントタイプ順に並べ替える',
    'l_webdirerrordocslist_location' => 'エラードキュメントを保存場所順に並べ替える',

    'b_webdirerrordocslist_search' => 'エラードキュメントを検索するには、検索パターンを入力し、ここをクリックします。',
    'b_webdirerrordocslist_remove' => '選択されたエラードキュメントを削除する',
    'b_webdirerrordocslist_show_all' => 'すべてのエラードキュメントを表示します。',

    'l_webdirmimetypeslist_name' => 'MIME タイプを拡張子順に並べ替える',
    'l_webdirmimetypeslist_content' => 'MIME タイプを内容順に並べ替える',

    'b_webdirmimetypeslist_remove' => '選択された MIME タイプを削除します。',
    'b_webdirmimetypeslist_search' => '検索パターンを入力してクリックし、MIME タイプを検索する',
    'b_webdirmimetypeslist_show_all' => 'すべての MIME タイプを表示します。',

    'b_webdir_preferences' => "仮想ディレクトリを設定します。",
    'b_webdir_permissions' => "仮想ディレクトリのパーミッション",
    'b_webdir_permissions_disabled' => "ディレクトリパーミッション管理は現在使用できません",
    'b_to_webdirs' => 'ディレクトリの管理に戻ります。',
    'b_to_webdir_mime_types' => 'MIME タイプの管理に戻ります。',
    'b_to_webdir_error_docs' => 'エラードキュメントの管理に戻ります。',
    'b_to_webdir_protection' => '仮想ディレクトリ保護の管理に戻ります。',

    'webdirs__title' => '仮想ディレクトリ %1',
    'webdirs__preferences_title' => '仮想ディレクトリの設定',
    'webdirs__list_legend' => '仮想ディレクトリ',
    'webdirs__list_type' => 'T',
    'webdirs__list_protected' => 'P',
    'webdirs__list_name' => '名前',
    'webdirs__list_header' => '%1 アイテム',
    'webdirs__tabs_general' => '全般',
    'webdirs__tabs_mime_types' => 'MIME タイプ',
    'webdirs__tabs_error_docs' => 'エラードキュメント',

    'webdirs__tabs_permissions' => 'パーミッション',
    'webdir__remove_vdirs' => '以下の仮想ディレクトリが削除されます。',
    'webdir__remove_mime_types' => '次の MIME タイプは削除されます。',
    'webdir__mime_types_title' => 'MIME タイプ',
    'webdir__protection_disable_confirm' => 'このディレクトリから保護を削除しますか？',
    'webdir__protect_title' => '保護されたディレクトリのユーザ',
    'webdirs__permissions_title' => '仮想ディレクトリのパーミッション',
    'webdirs__browse_content_permission_denied' => 'このディレクトリのコンテンツを表示するパーミッションがありません。',
    'error_doc__list_code' => 'エラー',
    'error_doc__list_code_description' => '説明',
    'error_doc__list_type' => 'タイプ',
    'error_doc__list_location' => '場所',
    'error_doc__code' => 'エラー',
    'error_doc__type' => 'タイプ',
    'error_doc__type_file' => 'ファイル',
    'error_doc__type_url' => 'URL',
    'error_doc__location' => '場所',
    'error_doc__legend' => 'エラードキュメント',
    'error_doc__edit_title' => 'エラードキュメントを編集',
    'error_doc_erorr_invalid_url_location' => 'この URL は無効です。正しい URL を指定してください。',
    'error_doc_erorr_invalid_file_location' => 'このファイルパスは無効です。正しいファイルパスを指定してください。',
    'error_doc__type_default' => 'デフォルト',

    'webdirs__tabs_protection' => '保護',
    'pb_webdirs' => '仮想ディレクトリ',

    'webdirs_remove_title' => '以下の仮想ディレクトリが削除されます。',
    'webdirs_mime_types_remove_title' => '次の MIME タイプは削除されます。',
    'webdirs_preferences_title' => '仮想ディレクトリの設定',
    'webdirs_permissions_title' => 'ファイルとフォルダに対する特別なパーミッション',
    'webdi_protection_disable_confirm' => '仮想ディレクトリから保護を削除しますか？すべての保護ディレクトリユーザとディレクトリ保護設定も削除されます。',
    'bt_protect' => '保護',
    'bt_unprotect' => '保護を解除',
    'bt_show_additional_users' => '表示するユーザを増やす',
    'bt_hide_additional_users' => '表示するユーザを減らす',
    'error_doc__list_title' => 'エラードキュメント',
    'error_doc__list_header' => 'エラードキュメント',
    'error_doc__code_400' => 'Bad Request（不正な要求）',
    'error_doc__code_401' => 'Unauthorized（認証失敗）',
    'error_doc__code_401.1' => 'Unauthorized - Login failed（認証失敗 - ログインに失敗しました）',
    'error_doc__code_401.2' => 'Unauthorized - Login failed due to server configuration（認証失敗 - サーバ構成によりログインに失敗しました）',
    'error_doc__code_401.3' => 'Unauthorized - Unauthorized due to ACL on resource（認証エラー - リソースに定義された ACL によりアクセスが拒否されました）',
    'error_doc__code_401.4' => 'Unauthorized - Authorization failed by filter（認証失敗 - フィルタにより認証が失敗しました）',
    'error_doc__code_401.5' => 'Unauthorized - Authorization failed by ISAPI/CGI app（認証失敗 - ISAPI/CGI アプリケーションで認証に失敗しました）',
    'error_doc__code_401.7' => 'Unauthorized - Denied due to URL authorization policy（認証失敗 - URL アクセスポリシーにより拒否されました）',
    'error_doc__code_403' => 'Forbidden（アクセス不可）',
    'error_doc__code_403.1' => 'Forbidden - Execute access denied（禁止 - 実行アクセスが拒否されました）',
    'error_doc__code_403.2' => 'Forbidden - Read access denied（禁止 - 読み取りアクセスが拒否されました）',
    'error_doc__code_403.3' => 'Forbidden - Write access denied（禁止 - 書き込みアクセスが拒否されました）',
    'error_doc__code_403.4' => 'Forbidden - SSL required（アクセス不可 - SSL が必要です）',
    'error_doc__code_403.5' => 'Forbidden - SSL 128 required（アクセス不可 - SSL 128 が必要です）',
    'error_doc__code_403.6' => 'Forbidden - IP address rejected（アクセス不可 - IP アドレスが拒否されました）',
    'error_doc__code_403.7' => 'Forbidden - Client certificate required（アクセス不可 - クライアント証明書が必要です）',
    'error_doc__code_403.8' => 'Forbidden - Site access denied（禁止 - サイトアクセスが拒否されました）',
    'error_doc__code_403.9' => 'Forbidden - Too many users（アクセス不可 - ユーザが多すぎます）',
    'error_doc__code_403.10' => 'Forbidden - Invalid configuration（アクセス不可 - 無効な構成です）',
    'error_doc__code_403.11' => 'Forbidden - Password change（アクセス不可 - パスワード変更）',
    'error_doc__code_403.12' => 'Forbidden - Mapper denied access（禁止 - マッパがアクセスを拒否しました）',
    'error_doc__code_403.13' => 'Forbidden - Client certificate revoked（アクセス不可 - クライアント証明書が無効になっています）',
    'error_doc__code_403.14' => 'Forbidden - Directory listing denied（禁止 - ディレクトリのリスト作成が拒否されました）',
    'error_doc__code_403.15' => 'Forbidden - Client access licenses exceeded（アクセス不可 - クライアントアクセスライセンス数の上限に達しました）',
    'error_doc__code_403.16' => 'Forbidden - Client certificate untrusted or malformed（アクセス不可 - クライアント証明書は信頼できないか不正な形式です）',
    'error_doc__code_403.17' => 'Forbidden - Client certificate has expired or is not yet valid（アクセス不可 - クライアント証明書が期限切れであるか、有効になっていません）',
    'error_doc__code_403.18' => 'Forbidden - Cannot execute request from this application pool（アクセス不可 - このアプリケーションプールからの要求を実行できません）',
    'error_doc__code_403.19' => 'Forbidden - CGI access denied（禁止 - CGI アクセスが拒否されました）',
    'error_doc__code_403.20' => 'Forbidden - Passport login failed（アクセス不可 - パスワードログインに失敗しました）',
    'error_doc__code_404' => 'Not found（ページが見つかりません）',
    'error_doc__code_404.2' => 'Not Found - Denied due to lockdown policy（見つかりません - Lockdown ポリシーにより拒否されました）',
    'error_doc__code_404.3' => 'Not Found - Denied due to MIMEMAP policy（見つかりません - MIMEMAP ポリシーにより拒否されました）',
    'error_doc__code_405' => 'Method not allowed（禁止されたメソッドです）',
    'error_doc__code_406' => 'Not acceptable（受信不可）',
    'error_doc__code_407' => 'Proxy authentication required（プロキシ認証が必要です）',
    'error_doc__code_412' => 'Precondition failed（前提条件が失敗しました）',
    'error_doc__code_414' => 'Request-URI too long（Request-URI が長すぎます）',
    'error_doc__code_415' => 'Unsupported media type（サポートされないメディアタイプです）',
    'error_doc__code_500' => 'Internal server error（内部サーバエラー）',
    'error_doc__code_500.12' => 'Internal server error - Application restarting（内部サーバエラー - アプリケーションの再起動中です）',
    'error_doc__code_500.13' => 'Internal server error - Server too busy（内部サーバエラー - サーバがビジー状態です）',
    'error_doc__code_500.15' => 'Internal server error - Direct requests for GLOBAL.ASA forbidden（内部サーバエラー - GLOBAL.ASA に対するダイレクトリクエストは禁止されています）',
    'error_doc__code_500.16' => 'Internal server error - UNC access error（内部サーバエラー - UNC アクセスエラー）',
    'error_doc__code_500.17' => 'Internal server error - URL authorization store not found（内部サーバエラー - URL 認証ストアが見つかりません）',
    'error_doc__code_500.18' => 'Internal server error - URL authorization store cannot be opened（内部サーバエラー - URL 認証ストアを開けません）',
    'error_doc__code_500.19' => 'Internal server error - Bad file metadata（内部サーバエラー - 不正なファイルメタデータ）',
    'error_doc__code_500.100' => 'Internal server error - ASP error（内部サーバエラー - ASP エラーです）',
    'error_doc__code_501' => 'Not implemented（実装されていません）',
    'error_doc__code_502' => 'Bad gateway（不正なゲートウェイ）',
    'error_doc__code_503' => 'Service temporarily unavailable（サービスは現在使用できません）',

    'mimetype__extension' => 'エクステンション',
    'mimetype__content' => 'コンテンツ',
    'mimetypeslist__title' => 'MIME タイプ',
    'mimetypes__title' => 'MIME タイプ',
    'mimetypes__select_to_remove' => '削除する MIME タイプを選択します。',
    'mimetypes__select_for_remove' => "削除する MIME タイプを選択してください。",
    'mimetypes_remove__title' => 'MIME タイプを削除',
    'mimetype__legend' => 'MIME タイプ',
    'mimetype_edit__title' => 'MIME タイプを編集',
    'mimetype_edit__already_exists' => 'この MIME タイプは既にこの拡張子に対して定義されています。',
    'mimetype_edit__not_exists' => 'この MIME タイプは存在しません。',
    'mimetype__content_type_other' => 'カスタム...',

    'b_webdir_protection_enable' => 'そのディレクトリに対応する URL をパスワード保護します。',
    'b_webdir_protection_disable' => 'そのディレクトリに対応する URL に誰でもアクセスできるようにします。',
    'b_webdir_protection_disabled' => '仮想ディレクトリ保護が無効です',

    'b_pd_usr_create' => 'この保護 URL ユーザを作成します。',
    'php__changeversion_title' => "PHP バージョンを選択する",
    'php__group_php_version' => "PHP バージョン",

    'virtualdir__name' => '名前',
    'virtualdir__path' => 'パス',
    'virtualdir__read' => '読み取りパーミッション',
    'virtualdir__read_short' => 'R',
    'virtualdir__write' => '書き込みパーミッション',
    'virtualdir__write_short' => 'W',
    'virtualdir__source' => 'スクリプトソースへのアクセス',
    'virtualdir__source_short' => 'S',
    'virtualdir__browse' => 'ディレクトリ参照',
    'virtualdir__browse_short' => 'B',
    'virtualdir__script_execute' => '実行パーミッション',
    'virtualdir__script_execute_short' => 'E',
    'virtualdir__log_visits' => '訪問をログに保存する',
    'virtualdir__app_create' => 'アプリケーションの作成',
    'virtualdir__app_create_short' => 'A',
    'virtualdir__auth_anon' => '匿名認証をオンにします。',
    'virtualdir__auth_windows' => 'Windows 認証をオンにします。',
    'virtualdir__auth_not_enabled' => '匿名認証または Windows 認証をオンにする必要があります。',
    'virtualdir__require_ssl' => 'SSL/TLS が必要',
    'virtualdir__enable_default_doc' => 'デフォルトドキュメントを使用',
    'virtualdir__default_doc' => 'デフォルトドキュメントの検索順序',
    'virtualdir__enable_parent_paths' => '親パスの使用を許可する',
    'virtualdir__execute_in_mta' => 'MTA（マルチスレッドアパートメント）モードでのアプリケーション実行を許可する',
    'virtualdir_create__title' => '%1 に仮想ディレクトリを作成します。',
    'virtualdir_edit__title' => '仮想ディレクトリ %1 のプロパティ',
    'virtualdir_edit__legend' => '仮想ディレクトリ',
    'virtualdir_edit__application_legend' => 'アプリケーション設定',
    'virtualdir_edit__security_legend' => 'ディレクトリのセキュリティ',
    'virtualdir_edit__documents_legend' => 'ドキュメント',
    'virtualdir_edit__list_legend' => 'ネスト化された仮想ディレクトリ',
    'virtualdir_error__path_not_in__' => '指定されたパスは無効です',
    'virtualdir_error__already_exists' => 'この名前のディレクトリは既に存在します。',
    'virtualdir_root' => '仮想ディレクトリ',
    'virtualdir_root__title' => '仮想ディレクトリ',
    'virtualdir_root__list_legend' => '仮想ディレクトリ',
    'virtualdir_se__none' => 'なし',
    'virtualdir_se__script' => 'スクリプトのみ',
    'virtualdir_se__script_execute' => 'スクリプトと実行可能ファイル',
    'virtualdirs__title' => '仮想ディレクトリ',
    'virtualdirs__path_not_exists' => '無効なパス',
    'virtualdirs__select_for_remove' => "削除する仮想ディレクトリを選択する",
    'virtualdirs_remove__title' => '仮想ディレクトリの削除',
    'virtualdirs_phys_dir_exist' => 'この名前の物理ディレクトリは既に存在します。続行すると、このディレクトリにアクセスできなくなります。続行しますか？',
    'virtualdir_auto_create_dir' => "仮想ディレクトリと同名の物理ディレクトリを作成する",

    'asp_max_default_text' => '親ディレクトリの定義を使用（%1 KB）',
    'asp_max_default_text_site' => 'IIS の定義を使用（%1 KB）',
    'asp_max_buffer_text' =>'ASP バッファの最大サイズ（KB）',
    'asp_max_body_text' => 'ASP 要求のエンティティボディの最大サイズ（KB）',
    'asp_buffers_legend' =>'ASP 設定',

    'asp_debug_default_text' =>'親ディレクトリの定義を使用',
    'asp_debug_default_text_site' =>'IIS の定義を使用',
    'asp_client_debug_text' =>'ASP クライアントサイドスクリプトのデバッグを有効にする',
    'asp_server_debug_text' =>'ASP サーバサイドスクリプトのデバッグを有効にする',

    'webdirs__list_with_broken_dirs' => "存在しない物理フォルダにリンクされた仮想ディレクトリがあります。",
    'webdirs__vdir_physical_path_not_exist' => "この仮想ディレクトリは、存在しない物理フォルダに関連付けられています。",
    'webdirs__physical_path_not_exist' => "指定のパスが存在しません。",

    'filemanager__new_dir_title' => 'ディレクトリを作成',
    'php__configuration_title' => "PHP 構成",

    'permissions__title' => 'アクセスパーミッションの設定',
    'permissions__title_advanced' => '詳細なアクセスパーミッションのセットアップ',
    'permissions__inherit_from_parent' => '親からこのオブジェクトおよびすべての子オブジェクトへの継承パーミッションのプロパゲーションを許可する。ここで明示的に定義したエントリも含む。',
    'permissions__replace_on_children' => 'すべての子オブジェクトのパーミッションエントリを、ここに表示されたエントリに置き換える。',
    'permissions__group_or_user_name' => 'グループまたはユーザ名',
    'permissions__Permissions_for' => 'パーミッション：',
    'permissions__allow' => '許可',
    'permissions__deny' => '拒否',
    'permissions__FullControl' => 'フルコントロール',
    'permissions__Modify' => '編集',
    'permissions__ReadAndExecute' => '読み込みおよび実行',
    'permissions__ListFolderContents' => 'リストフォルダコンテンツ',
    'permissions__Read' => '読み取り',
    'permissions__Write' => '書き込み',
    'permissions__ReadControl' => '読み込みコントロール',
    'permissions__WriteControl' => '書き込みコントロール',
    'permissions__ExecuteControl' => '実行コントロール',
    'permissions__TraverseFolderOrExecuteFile' => 'トラバースフォルダ / 実行ファイル',
    'permissions__ListFolderOrRead' => 'リストフォルダ / 読み込みデータ',
    'permissions__CreateFilesOrWrite' => 'ファイルの作成/データの書き込み',
    'permissions__CreateFoldersOrAppend' => 'フォルダの作成/データの付加',
    'permissions__DeleteSubfoldersandFiles' => 'サブフォルダおよびファイルの削除',
    'permissions__Delete' => '削除',
    'permissions__ChangePermissions' => 'パーミッション変更',
    'permissions__TakeOwnership' => '所有権取得',
    'permissions__inherited_from' => '以下から継承',
    'permissions__not_inherited' => '<継承されません>',
    'permissions__apply_to' => '適用先',
    'permissions__apply_onto' => '適用先：',
    'permissions__apply_onto1' => 'このフォルダのみ',
    'permissions__apply_onto2' => 'サブフォルダのみ',
    'permissions__apply_onto3' => 'フォルダおよびサブフォルダ',
    'permissions__apply_onto4' => 'ファイルのみ',
    'permissions__apply_onto5' => 'このフォルダおよびファイル',
    'permissions__apply_onto6' => 'サブフォルダおよびファイルのみ',
    'permissions__apply_onto7' => 'このフォルダ、サブフォルダ、およびファイル',

    'filemanager__not_allowed_dir' => "このフォルダのパーミッションを変更するパーミッションがありません",

    'filemanager__allow' => "許可",
    'filemanager__deny' => "拒否",
    'filemanager__user_domusr' => 'ウェブサイト管理者',
    'filemanager__user_webusr' => 'ウェブユーザ',
    'filemanager__user_admins' => 'ローカル管理者',
    'filemanager__user_system' => 'システム ユーザ',
    'filemanager__user_aspnet' => 'ASP.NETユーザ',
    'filemanager__user_poolusr' => 'アプリケーションプールユーザ',
    'filemanager__user_sysaccount' => 'その他のシステムユーザ',

    'bt_permissions_advanced' => '詳細',
    'b_permissions_advanced' => '特別なパーミッションを設定・閲覧します。',

    'hotlink-protection_invalid_friend_domain' => 'フレンドリードメインの名前が無効です。',
    'hotlink-protection_duplicate_friend_domain' => 'フレンドリードメインの名前が重複しています。',
    'hotlink-protection_invalid_extensions' => 'ファイル拡張子に不適切な文字が含まれています。',

    'i_domain_alias_status_on' => 'ドメインエイリアスは有効です',
    'i_domain_alias_status_off' => 'ドメインエイリアスは無効です',
    'i_domain_alias_status_with_parent' => 'ドメインがオフであるため、ドメインエイリアスは無効になっています。',
    'i_domain_alias_turn_off' => '無効化します。',
    'i_domain_alias_turn_on' => '有効化します。',
    'i_domain_alias_mail_on' => 'このドメインエイリアスにてメールサービスは有効です',
    'i_domain_alias_mail_off' => 'このドメインエイリアスにてメールサービスは無効です',
    'i_domain_alias_mail_with_parent' => 'ドメインエイリアスがオフのため、メールサービスは無効です',
    'i_domain_alias_web_on' => 'このドメインエイリアスではウェブサービスは有効です。',
    'i_domain_alias_web_off' => 'このドメインエイリアスではウェブサービスは無効です。',
    'i_domain_alias_web_with_parent' => 'ドメインエイリアスが無効なので、ウェブサービスは無効です。',
    'i_domain_alias_dns_on' => 'DNS エイリアスサービスがこのドメインエイリアスでオンになっています。',
    'i_domain_alias_dns_off' => 'DNS エイリアスサービスがこのドメインエイリアスでオフになっています。',
    'i_domain_alias_dns_with_parent' => 'ドメインエイリアスがオフになっているため、親ドメインとの DNS 同期は無効化されています。',
    'i_domain_alias_seoRedirect_on' => 'このドメインエイリアスでは HTTP コード 301 でのリダイレクトはオフになっています。',
    'i_domain_alias_seoRedirect_off' => 'このドメインエイリアスでは HTTP コード 301 でのリダイレクトはオフになっています。',
    'i_domain_alias_seoRedirect_with_parent' => 'ドメインエイリアスがオフになっているので、HTTP コード 301 でのリダイレクトがオフになっています。',

    'domain_alias__control_title' => 'ドメインエイリアス %1',
    'domain_alias__control_info_legend' => '情報',
    'domain_alias__control_status_title' => 'S',
    'domain_alias__control_name_title' => 'サービス名',
    'domain_alias__control_details_title' => '詳細',

    'domain_alias__invalid_values' => '指定したドメイン名は無効です。ドメイン名には、文字、数字、ハイフンを使用できます。ドメイン名のドット間の長さは、63 文字以内にしてください。',
    'domain_alias__domain_already_exists' => "ドメインエイリアス %1 の名前が正しくありません。ドメイン %1 は既に存在します。",
    'domain_alias__www_prefix_domain_already_exists' => "ドメインエイリアス名 www.%1 は正しくありません。このエイリアスはドメイン %1 に対して既に作成されています。",
    'domain_alias__webmail_enabled_domain_already_exists' => 'ドメインエイリアス名 webmail.%1 は正しくありません。このエイリアスはドメイン %1 に対して既に作成されています。',
    'domain_alias__lists_enabled_domain_already_exists' => 'ドメインエイリアス名 lists.%1 は正しくありません。このエイリアスはドメイン %1 に対して既に作成されています。',
    'domain_alias__dns_record_already_exists' => 'ドメインエイリアス %1 をセットアップできません。ホスト %1 をポイントする DNS レコードは既に存在します。',
    'domain_alias__domain_alias_already_exists' => "この名前のドメインエイリアスは既に存在します。",
    'domain_aliases__mail_server_not_support_aliases' => '当該メールサーバはドメインエイリアス機能をサポートしません。ドメインエイリアスが正常に動作しない可能性があります。',
    'domain_alias__restrict_domain_creation' => 'ドメインエイリアスに対して指定した名前が、サーバ全体のポリシーで禁止されています。このドメインエイリアス名がご自分に属している場合、ホスティング事業者までお問い合わせください。',
    'domain_alias__restrict_creation_with_www' => '\'www\' プレフィックスなしでドメイン名を入力してください。ドメインの www プレフィックスはウェブサーバの構成に自動的に追加されます。',
    'domain_unable_to_set_name' => '名前 %1 が正しくありません。',

    'domain_alias__domain_service_dns_disabled' => 'このドメインは他の DNS サーバによって運用されています。',
    'domain_alias__domain_service_dns_enabled_master' => 'この DNS サーバは、この DNS ゾーンのプライマリネームサーバとして機能します。',
    'domain_alias__domain_service_dns_enabled_slave' => 'この DNS サーバは、この DNS ゾーンのセカンダリネームサーバとして機能します。',
    'domain_alias__domain_service_mail_enabled' => 'このドメインではメールサービスがオンになっています。',
    'domain_alias__domain_service_mail_disabled' => 'このドメインではメールサービスがオフになっています。',
    'domain_alias__domain_service_mail_mx' => '%1 はメールサーバとして使用されています。',

    'domain_alias__service_seoRedirect_hint' => '訪問者がエイリアスの URL を開くと、プライマリドメインの URL にリダイレクトされます。Plesk は検索エンジンフレンドリーな HTTP 301 リダイレクトを使用します。つまり、検索エンジンランキングではリダイレクト元 URL とリダイレクト先 URL が区別されません。',

    'bt_task_run_now' => '今すぐ実行',
    'ftp__read_perm' => "読み取りパーミッション",
    'ftp__write_perm' => "書き込みパーミッション",

    'filemanager__upload_backup_file_hint' => 'ここで Plesk ストレージにバックアップファイルをアップロードできます。最大ファイルサイズは 2 GB に制限されています。',

    '__default_for_mssql' => 'MS SQL のデフォルト',

    '__login_does_not_pass_validation' => "ユーザ名は無効です。以下の要件を満たしていることを確認してください。%1",
    '__login_allowed_symbols' => '英数字、ピリオド、ダッシュ、アンダースコアのみが許可されます。先頭は英数字にしてください。',

    'restart__nginx' => 'リバースプロキシサーバ（nginx）',
    'restart__php-fpm' => 'PHP-FPM %1',

    'admin_ed__i_would_like_recieve_announce' => "Plesk から一般的な製品情報とアナウンスを受け取る",
    'admin_ed__i_would_like_recieve_tech_announce' => "Plesk からセキュリティ情報やその他の技術情報を受け取る",

    '__login_status_inactive' => 'アカウントはアクティブではありません。Plesk 管理者までお問い合わせください。',

    'migration__task_keep_in_process' => 'OK',
    'migration__task_keep_in_process_conhelp' => '［ツールと設定］ページに戻ります。移行はバックグラウンドで続行されます。',

    'ui__admin-alias-info__description' => "追加管理者アカウントの連絡先情報を編集する。",
    'ui__admin-alias-info__short-title' => "連絡先情報",
    'ui__admin-alias-info__title' => "追加管理者アカウント情報",
    'ui__admin-alias-password__description' => "追加管理者パスワードを変更する。",

    'ui__admin-alias-password__short-title' => "パスワード変更",
    'ui__admin-alias-password__title' => "追加管理者のパスワード",
    'ui__admin-alias__description' => "追加管理者のアカウント情報を表示および変更する。",

    'chk_js__warning_about_login_syntax' => "ユーザ名には小文字の英数字、ダッシュ（-）、アンダースコア（_）を使用できます。ユーザ名の先頭はアルファベットにする必要があります。パスワードにユーザ名や引用符を含めることはできません。",
    'chk_js__warning_about_ftp_login_syntax' => "ユーザ名には英数字、ダッシュ、アンダースコアを使用できます。",
    'chk_js__warning_about_login_syntax_win' => "ユーザ名には小文字の英数字、ダッシュ（-）、ドット（.）、アンダースコア（_）を使用できます。ユーザ名の先頭は英数字にする必要があります。パスワードにユーザ名や引用符を含めることはできません。",
    'chk_js__warning_about_passwd_syntax' => "パスワードに引用符、スペース、国別文字を使用しないでください。 \nパスワードの長さは %1 ～ %2 文字の間で指定し、ユーザ名を使用しないでください。",
    'chk_js__warning_about_plesk_login_syntax' => "ユーザ名には小文字の英数字、ダッシュ、アンダースコアを使用できます。",
    'chk_js__warning_about_plesk_login_syntax_win' => "ユーザ名には小文字の英数字、ダッシュ、アンダースコアを使用できます。先頭はアルファベットにする必要があります。",
    'chk_js__warning_about_plesk_passwd_syntax' => "パスワードに引用符、スペース、国別文字を使用しないでください。 \nパスワードの長さは %1 ～ %2 文字の間で指定し、ユーザ名を含めないようにしてください。",
    'chk_js__warning_about_pam_passwd_error' => "指定したシステムユーザアカウントが正しくありません。 %1",

    'cmd_server__admin_alias_not_found' => "追加の管理者アカウントが見つかりません。",

    'panel_branding__skins_already_exists' => "注：テーマ「%1」は既に存在しますが、現在インストールしているテーマに置き換えられます。",
    'panel_branding__skins_file_exists' => "テーマ '%1' 用にディレクトリを作成できません。この名前のファイルは既に存在します。",

    'actionlog__login_failed' => 'ログインに失敗',
    'actionlog__event_cp_user_login_failed' => 'Plesk ユーザがログインに失敗',
    'actionlog__api_login_failed' => 'API 経由のログインに失敗',
    'actionlog__event_cp_user_api_login_failed' => 'Plesk ユーザが API 経由のログインに失敗',
    'actionlog__pw_reset' => 'パスワードのリセットをリクエストしました',

    'ch_pass_admin__email_subject' => "Plesk パスワードリマインダ",
    'ch_pass_admin__email_body' => "%1 さん、こんにちは。\n\nセキュリティ上の理由により、管理者のパスワードをメールで送信することはできません。\n\n「admin」としてログインするには、「plesk login」コマンドを使用してください。\n\n新しい「admin」パスワードを設定するには、「plesk bin admin --set-password -passwd <new_password>」コマンドを使用してください。\n\n",
    'ch_pass_admin__message_send_error' => 'メールを送信できません。%1',

    'ch_pass_by_secret__email_subject' => "Plesk パスワードリマインダ",
    'ch_pass_by_secret__email_body' => "%2 さん、こんにちは\n\n新しいパスワードを設定するには、リンクに移動してください：%1\n\nログイン名：%3",
    'ch_pass_by_secret__message_send_error' => 'シークレットコードを送信する際エラーが発生しました。%1',
    'ch_pass_by_secret__title' => 'パスワード変更',
    'ch_pass_by_secret__secret' => 'シークレットコード',

    'custom_button__noframe' => "フレームを使用しない",

    'custom_button__internal_hint' => 'URL を Plesk 内のページで開くか、新しいブラウザウィンドウで開くかを指定してください。',
    'custom_button__noframe_hint' => 'Plesk 拡張やアプリケーションにリンクするカスタムボタンを顧客パネルに追加する場合、この拡張/アプリケーションの表示形態（フレーム内に表示、Plesk GUI の一部として表示）を指定できます。',


    'actionlog__patch' => '更新',
    'actionlog__patch_available' => '使用可能',
    'actionlog__event_patch_available' => 'アップデートを適用可能',
    'actionlog__patch_installed' => 'インストール済み',
    'actionlog__event_patch_installed' => 'アップデートのインストール',

    'actionlog__extension' => '拡張',
    'actionlog__extension_status' => '拡張ステータス',
    'actionlog__cloning' => 'サーバ複製',
    'actionlog__cloning_complete' => '完了',
    'actionlog__event_cloning_complete' => 'サーバ複製完了',

    'actionlog__ssl_web_binding' => 'ドメインの SSL/TLS 証明書',
    'actionlog__ssl_web_binding_update' => '割り当て/割り当て解除',
    'actionlog__event_ssl_web_binding_update' => 'ドメインの SSL/TLS 証明書の割り当て/割り当て解除',

    'actionlog__ssl_web_mail_binding' => 'ウェブメールの SSL/TLS 証明書',
    'actionlog__ssl_web_mail_binding_update' => '割り当て/割り当て解除',
    'actionlog__event_ssl_web_mail_binding_update' => 'ウェブメールの SSL/TLS 証明書の割り当て/割り当て解除',

    'actionlog__ssl_mail_binding' => 'メールサーバの SSL/TLS 証明書',
    'actionlog__ssl_mail_binding_update' => '割り当て/割り当て解除',
    'actionlog__event_ssl_mail_binding_update' => 'メールサーバの SSL/TLS 証明書の割り当て/割り当て解除',

    'actionlog__ssl_panel_binding' => 'Plesk の SSL/TLS 証明書',
    'actionlog__ssl_panel_binding_update' => '割り当て/割り当て解除',
    'actionlog__event_ssl_panel_binding_update' => 'Plesk の SSL/TLS 証明書の割り当て/割り当て解除',

    'actionlog__hostname' => 'サーバのホスト名',
    'actionlog__hostname_changed' => '変更',

    'actionlog__smb_user' => '追加ユーザ',
    'actionlog__smb_user_create' => '追加ユーザが作成されました',
    'actionlog__smb_user_delete' => '追加ユーザが削除れました',
    'actionlog__smb_user_update' => '追加ユーザが更新されました',

    'actionlog__event_mail_management_status_update' => 'メール管理ステータスの更新',
    'actionlog__mail_management' => 'メール管理ステータス',
    'actionlog__mail_management_status_update' => '更新',

    'virtualization_openvz' => 'OpenVZ',

    '__domains_total' => 'ドメイン別の合計',

    'chk_js__warning_about_admin_passwd_syntax' => "引用符、スペース、セミコロン、および国別文字をパスワードに使用しないでください。パスワードは %1～%2 文字の間である必要があり、ログイン名をパスワードの中に含めないようにしてください。",

    'passwordSecurityLevelCheckFailed' => 'このパスワードは、サーバセキュリティポリシーを満たす強度がありません。パスワードの強度は少なくとも「%1」でなければなりません。数字、英字の大文字/小文字、特殊文字（!、@、#、$、%、^、&、*、?、_、~ など）を使用して、パスワードを強化してください。',
    'passwordSecurityLevelCheckFailedVeryWeak' => '最弱',
    'passwordSecurityLevelCheckFailedWeak' => '弱',
    'passwordSecurityLevelCheckFailedMediocre' => '中',
    'passwordSecurityLevelCheckFailedStrong' => '強',
    'passwordSecurityLevelCheckFailedStronger' => '非常に強い',

    'filemanager__invalid_path' => "無効なパスが指定されました",

    'ui__client/domain/dns/sync__description' => 'サーバ全体の DNS テンプレートの変更をゾーンに適用します。',
    'ui__client/domain/dns/sync__disabled-warning' => 'ゾーンに DNS テンプレートの変更を適用できません。このゾーンは他の DNS サーバによって運用されています。',
    'ui__client/domain/dns/sync__short-title' => 'DNS テンプレートの変更を適用',
    'ui__client/domain/dns/sync__done' => 'DNS テンプレートの変更がゾーンに適用されました。',
    'ui__client/domain/domain-alias/dns/sync__description' => 'サーバ全体の DNS テンプレートの変更をゾーンに適用します。',
    'ui__client/domain/domain-alias/dns/sync__disabled-warning' => 'ゾーンに DNS テンプレートの変更を適用できません。このゾーンは他の DNS サーバによって運用されています。',
    'ui__client/domain/domain-alias/dns/sync__short-title' => 'DNS テンプレートの変更を適用',
    'ui__client/domain/domain-alias/dns/sync__done' => 'DNS テンプレートの変更がゾーンに適用されました。',
    'dns__dns_default_ipv4_modified' => 'この IP アドレスのレコードは、「ユーザが変更済み」だと見なされ、サーバ全体の DNS テンプレートと同期されません。',
    'dns__dns_default_ipv6_modified' => 'この IP アドレスのレコードは、「ユーザが変更済み」だと見なされ、サーバ全体の DNS テンプレートと同期されません。',

    'dns__view_dns_record_master_title' => 'リソースレコードの表示',
    'dns__view_dns_record_off_title' => 'ネームサーバレコードの表示',
    'dns__view_dns_record_slave_title' => 'プライマリ DNS サーバレコードの表示',

    'dns_unable_to_resolve_hostname' => "ホスト名 \"%1\" を解決できません。%2\nOS の DNS リゾルバがセットアップされており、正しく機能することを確認してください。",

    'no_database_server_available' => 'この契約で利用可能なデータベースサーバはありません。',

    'database_used_by_application_can_not_be_moved' => 'データベースを削除できません。このデータベースを使用しているウェブサイトアプリケーションがあります。',
    'database_user_update_orphaned_is_restricted' => '孤立したデータベースユーザアカウントの更新は禁止されています。削除または修復のみが可能です。',

    'database_unable_to_get_max_filesize_default_message' => 'データベースの最大ファイルサイズ \'%1\' を確認できません。',
    'database_unable_to_set_max_filesize_default_message' => 'データベースの最大ファイルサイズ \'%1\' を設定できません。',
    'database_unable_to_get_max_log_filesize_default_message' => 'データベースの最大ログファイルサイズ \'%1\' を確認できません。',
    'database_unable_to_set_max_log_filesize_default_message' => 'データベースの最大ログファイルサイズ \'%1\' を設定できません。',

    'database_unable_to_get_max_filesize' => 'Microsoft SQL データベース \'%1\' のファイルサイズの現在の制限を確認できません。新しい制限を設定できません。',
    'database_unable_to_set_max_filesize' => 'Microsoft SQL データベース \'%1\' のファイルサイズに制限を設定できません。',
    'database_unable_to_get_max_log_filesize' => 'Microsoft SQL データベース \'%1\' のログファイルサイズの現在の制限を確認できません。新しい制限を設定できません。',
    'database_unable_to_set_max_log_filesize' => 'Microsoft SQL データベース \'%1\' のログファイルサイズに制限を設定できません。',

    'database_unable_to_create_because_max_filesize' => 'Microsoft SQL データベース \'%1\' を作成できません。ファイルサイズが許可される最大サイズを超えています。',
    'database_unable_to_move_because_max_filesize' => 'Microsoft SQL データベース \'%1\' を移動できません。ファイルサイズが許可される最大サイズ %2 を超えています。',
    'database_unable_to_create_because_max_log_filesize' => 'Microsoft SQL データベース \'%1\' を作成できません。ログファイルサイズが許可される最大サイズを超えています。',
    'database_unable_to_move_because_max_log_filesize' => 'Microsoft SQL データベース \'%1\' を移動できません。ログファイルサイズが許可される最大サイズ %2 を超えています。',
    'database_unable_to_restore_because_max_filesize' => 'Microsoft SQL データベース \'%1\' を復元できません。ファイルサイズが許可される最大サイズを超えています。',

    'sandbox_mssql_server_registered_as_usual_db_server' => '既に同一 MS SQL サーバが Plesk に登録されています。別の MS SQL サーバをサンドボックスとして指定してください。',
    'database_server__mssql_server_registered_as_sandbox' => '既に同一のサンドボックス MS SQL サーバが Plesk に登録されています。別の MS SQL サーバをサンドボックスとして指定してください。',

    'database_server_mysql_unable_to_connect_via_cli' => '\'%1\' 経由でサーバに接続できませんでした：%2',

    'bu_conflict_resolver_feature_not_available' => '機能 %1 は以下のサービスノードでサポートされていません。%2。この機能は、これらのノード上で作成されたすべてのオブジェクトに対して無効化されます。',
    'bu_conflict_resolver_feature_not_available_single_server' => '機能 %1 はこのサーバでサポートされていません。この機能は、復元されたすべてのオブジェクトに対して無効化されます。',
    'bu_conflict_resolver_component_unavailable_in_sites' => 'コンポーネント %1 はインストールされていません。次のウェブサイトに対しては使用できません。{{objects}}',
    'bu_conflict_resolver_component_replaced_in_sites' => 'コンポーネント %1 はインストールされていません。次のウェブサイトに対して、%2 に変更されます。{{objects}}',

    'bu_conflict_resolver_restoration_of_object_end_to_dot_not_supported' => '現在の Plesk バージョンは、ピリオド（.）記号の含まれるユーザ名をサポートしません。このようなユーザ名の顧客とリセラーは復元されません。',
    'bu_conflict_resolver_unable_to_find_backup_part' => '%1 %2 用のデータが含まれるバックアップファイルが見つかりません。%1 %2 用のデータは復元されません。',

    'bu_conflict_resolver_zone_master_removed' => "プライマリ DNS レコードを復元できません。セカンダリゾーン内のレコードが、既存の IP アドレス %1 をポイントしています。プライマリ DNS レコードはセカンダリゾーンから削除されます。",

    'bu_conflict_resolver_not_available_scripting' => '%1 はサポートされません。',
    'bu_conflict_resolver_not_available_scripting_in_sites' => '%1 はサポートされません。次のウェブサイトに対しては使用できません。{{objects}}',
    'bu_conflict_resolver_not_available_component' => 'コンポーネント %1 はインストールされていません。',
    'bu_conflict_resolver_disabled_in_multi_server' => '次のサービスノードに対しては使用できません。{{objects}}',
    'bu_conflict_resolver_disabled_in_single_server' => '次のオブジェクトに対しては使用できません。{{objects}}',
    'bu_conflict_resolver_not_available_db' => 'このサーバには次のデータベースサーバがありません。%1。',

    'bu_conflict_resolver_mssql_native_dump_restore_not_available' => 'MS SQL データベースのバックアップファイルは MS SQL ネイティブ形式で保存されます。これを復元できるのは、ローカル MS SQL サーバか、バックアップ設定が完全に構成されたリモート MS SQL サーバのみです。適切な MS SQL サーバが存在しないため、一部のデータベースが復元されていません。影響を受けたドメイン：{{objects}}。 ホスティング事業者にお問い合わせください。',

    'bu_conflict_resolver_not_available_webmail' => 'ウェブメールサービス %1 を使用できません。次のオブジェクトに対して、%2 に置き換えられます。{{objects}}',
    'bu_conflict_resolver_not_available_webmail_plan' => 'ウェブメールサービス %1 を使用できません。次のサービスプランに対して、%2 に置き換えられます。{{objects}}',
    'bu_conflict_resolver_not_available_rename_db_user' => "%1 タイプのデータベースは、データベース名と重複するユーザ名をサポートできません。ユーザ名 %2 はデータベース %4 に対して「%3」と変更されます。",

    'bu_conflict_resolver_wrong_hard_quota_value' => 'ディスクスペースの使用制限が宛先サーバの構成に設定されていません。この設定の値は「無制限」に変更されます。',
    'bu_conflict_resolver_wrong_max_connections_value' => '接続数の制限が宛先サーバの構成に設定されていません。この設定の値は「無制限」に変更されます。',
    'bu_conflict_resolver_wrong_traffic_bandwidth_value' => 'トラフィックの使用制限が宛先サーバの構成に設定されていません。この設定の値は「無制限」に変更されます。',
    'cu__pleskrestore_backup_file_extracted' => 'バックアップファイルが「%1」に抽出されました。',
    '__mod_bw_not_supported' => 'ファイルシステムの構成により、モジュール mod_bw は Apache ウェブサーバに対してサポートされません。トラフィック使用量の上限と最大接続数が機能しません。',
    'bu_conflict_resolver_pop3_only_relay_auth_not_supported' => 'メールリレー用の POP3 認証はサポートされません。代わりに POP3 before SMTP 認証が使用されます。（{{objects}}）',
    'bu_conflict_resolver_service_plan_name' => 'サービスプラン「%1」',
    'bu_conflict_resolver_replaced_in_plans' => '%1 はサポートされません。次のサービスプランに対し、%2 に変更されます。{{objects}}',
    'bu_conflict_resolver_replaced_in_sites' => '%1 はサポートされません。次のウェブサイトに対し、%2 に変更されます。{{objects}}',
    'bu_conflict_resolver_absent_objects_in_dump' => '次のオブジェクトがバックアップファイルにありません。%1',
    'bu_conflict_resolver_absent_domains' => '一部のオブジェクトを復元することができません。これらのオブジェクトが、Plesk 内に存在しない次のドメインに属しているためです。%1',
    'bu_conflict_resolver_absent_parent_domains' => "一部のウェブサイトを復元することができません。これらのオブジェクトが、Plesk 内に存在しない次の親ドメインに属しているためです。\n%1",
    'bu_conflict_resolver_dns_not_supported' => 'DNS ゾーンを復元することができません。DNS サービスがサーバ構成でオフになっています。',
    'bu_conflict_resolver_mail_not_supported' => 'メールボックスを復元することができません。メールサービスがサーバ構成でオフになっています。',
    'bu_conflict_resolver__idle_timeout_action_not_supported' => '指定したアイドルタイムアウトが IIS ウェブサーバでサポートされていません。値は %1 にリセットされます。',
    'bu_conflict_resolver__cpu_limit_action_not_supported' => '指定した CPU 制限アクションが IIS ウェブサーバでサポートされていません。値は %1 にリセットされます。',
    'bu_conflict_detector_server_ssl_cert_name' => 'サーバ SSL/TLS 証明書 %1',
    'bu_conflict_detector_domain_ssl_cert_name' => 'ドメイン %1 の SSL/TLS 証明書 %2',
    'bu_conflict_detector_ssl_cert_name' => 'SSL/TLS 証明書 %1',
    'bu_conflict_resolver_absent_objects' => '次のオブジェクトのコンテンツを復元することができません。Plesk 内にこれらのオブジェクトが存在しないためです。%1',
    'bu_conflict_resolver_absent_objects_mailuser' => '次のメールボックスのコンテンツを復元することができません。Plesk 内にこれらのメールボックスが存在しないためです。%1',
    'bu_conflict_resolver_absent_objects_maillist' => '次のメーリングリストのコンテンツを復元することができません。Plesk 内にこれらのメーリングリストが存在しないためです。%1',
    'bu_conflict_resolver_absent_objects_database' => '次のデータベースのコンテンツを復元することができません。Plesk 内にこれらのデータベースが存在しないためです。%1',
    'bu_conflict_resolver__remove_conflicted_aps_app' => '"%2" でアプリケーション "%1" の復元が失敗しました。既に別のアプリケーションが "%3" にインストールされています。インストールしたアプリケーションを削除してやり直してください。',
    'bu_conflict_resolver_not_available_mail_autoresponders' => 'メールの自動応答機能はサポートされていません。',
    'bu_conflict_resolver_not_available_mail_content' => 'メール内容の復元はサポートされていません。',
    'bu_conflict_resolver_invalid_mail_name' => '以下のメールボックスは復元されていません。メールのサブアドレスが有効になっており、一部のメールアドレスに "%1" 記号が含まれるためです：%2',
    'bu_conflict_resolver_invalid_user_name' => '以下のユーザは復元されていません。メールのサブアドレスが有効になっており、一部のメールアドレスに "%1" 記号が含まれるためです：%2',
    'bu_conflict_resolver_licenses_expired' => '以下のライセンスは期限切れで、復元できません：{{objects}}',
    'bu_conflict_resolver_licenses_invalid' => '以下のライセンスは有効ではないか期限切れで復元できません：{{objects}}',
    'expiration_unsupported' => "リミット「expiration」はサポートされません。",

    'component_name__dbconnector' => "データベースコネクタ",
    'component_name__mysqlserver' => 'MySQL サーバ',
    'component_name__troubleshooting' => 'トラブルシューティング',
    'component_name__savi' => 'Sophos Anti-Virus インターフェース',

    '__subscription_has_no_license_key' => '契約リソースはサービスノード #%1 によって提供されており、このノードにはライセンスキーが関連付けられていません。',
    '__subscription_has_expired_license_key' => '契約リソースはサービスノード #%1 によって提供されており、このノードのライセンスキー %2 は失効しています。',

    '__cfgmonConfigurationFileSaveErrorSubject' => '<%%host%%> 構成ファイルを保存できません',
    '__cfgmonConfigurationFileSaveErrorBody' => "ホスト <%%host%%> に一部の構成ファイルを保存できません。以下のエラーが発生しました。\n\n%%errors%%",

    'mail__enable_email_subaddressing_cli_desc' => 'このオプションにより、メールリストで VERP 形式のメールアドレスの構成が可能になります',
    'mail__enter_right_ip_mask' => "IP マスクを 1～32 の範囲で入力します。",
    'mail__enter_right_ip_mask_24' => "IP マスクを 24～32 の範囲で入力します。",
    'mail__invalid_dom_name' => "ドメイン名 %1 が無効です。",
    'mail__invalid_pop_lock_time' => "POP3 ロックタイムが無効です",
    'mail__invalid_rbl_server' => "DNS ゾーン名が無効です。",
    'mail__total_files_size' => "リポジトリの合計サイズ： %1",
    'mail__filename_already_in_repository' => "同じ名前のファイルがリポジトリに既に存在します。",
    'mail__no_white_list_mask_feature_24' => "24 以上のマスク値を使用してください。マスクの設定がメールサーバでサポートされていません。値が 24 以上である場合のみ、マスクの設定をエミュレートできます。",
    'mail__unable_add_new_mail_name' => "メールアカウント %1 を追加できません",
    'mail_server_is_not_installed' => 'メールサーバ（Postfix または Qmail）がインストールされていません。インストールしてから作業を続けてください。',
    'mail_server_not_available' => 'サービスノードでサポートされるメールサーバがありません。',
    '__not_installed' => '（未インストール）',
    'mail__service_node_outgoing_messages_is_disabled' => '送信メールメッセージに対するスパムフィルタリングが無効になっています。',
    'mail__service_node_does_not_support_outgoing_messages_domain_limit' => 'このサービスノードでは、ドメイン %1 用のドメインからの送信メールメッセージ数を制限することはサポートされていません。',
    'mail__service_node_does_not_support_outgoing_messages_mbox_limit' => 'このサービスノードでは、ドメイン %1 用のメールボックスからの送信メールメッセージ数を制限することはサポートされていません。',

    'mail__outgoing_email_mode_explicit_ip_unspecified' => '少なくとも 1 つのタイプ（IPv4 または IPv6）のアドレスを指定してください。',

    'mail__outgoing_email_mode_invalid' => '無効な送信メールモードが指定されました。',
    'mail__outgoing_email_mode_explicit_ip_v4_invalid' => '無効な IPv4 アドレスが指定されました。',
    'mail__outgoing_email_mode_explicit_ip_v6_invalid' => '無効な IPv6 アドレスが指定されました。',
    'mail__outgoing_email_mode_unavailable' => '送信メールモードの変更がサポートされていません。おそらく、このサーバには Postfix メールサーバがインストールされていません。',

    'mail__autoresponder_attachment_not_supported' => '現在使用されているメールサーバは、自動応答の添付管理をサポートしていません。',

    'mail__smtp_white_list_not_supported' => '現在使用されているメールサーバが IP アドレスのホワイトリスト機能をサポートしていません。',
    'mail__smtp_whitelist_cidr_not_supported' => '現在選択されているメールサーバで CIDR マスクがサポートされていません。「192.*.0.*」形式で IP アドレスを指定してください。',
    'mail__smtp_whitelist_mask_not_supported' => '現在選択されているメールサーバでワイルドカード IP パターンがサポートされていません。「192.0.0.0/8」形式で IP アドレスを指定してください。',

    'sfdk_server_wide_verify_failed' => 'DKIM 検証サービス用の設定を変更できません',

    'sfdk_domain__serverwide_disabled' => 'サーバポリシーに基づいてスイッチオフ済み',
    'feature__domainkeys__serverwide_disabled' => 'サーバ全体の DKIM スパム防御はオフになっています',

    'defaultcomponents__error_set_default' => '%1 をデフォルトの %2 として設定できません：%3',
    'defaultcomponents__error_set_default_none' => '%1 にデフォルトコンポーネントを設定できません：%2',
    'defaultcomponents__required_package_not_default' => '作業に必要なコンポーネント %1 はデフォルトではありません。',

    '__percentage' => '%',
    '__seconds' => '秒',
    '__resource_remain' => '残量',

    '__not_registered' => '（未登録）',
    '__php_handler_id' => 'PHP バージョン',
    '__php_handler_id_string' => 'PHP %1（%2）',
    '__php_handler_not_registered' => 'PHP ハンドラ "%1" は登録されていません。サーバから削除された可能性があります。同じプロパティでハンドラを登録し、やり直してください。',
    '__php_handler_not_registered_on_domain' => 'ドメイン "%1"：PHP ハンドラ "%2" は登録されていません。サーバから削除された可能性があります。同じプロパティでハンドラを登録し、やり直してください。',
    '__php_fpm_handler' => 'FPM アプリケーション',
    '__php_fpm-dedicated_handler' => '専用 FPM アプリケーション',

    'mailname_create_assigned_user_dublicate_error' => 'このメールボックス用のユーザを作成することはできません。ユーザ名 %1 のユーザは既に存在しており、別のメールボックスが割り当てられています。',
    'mailname_create_assigned_user_role_absent_error' => 'このメールボックス用のユーザを作成することはできません。ユーザのデフォルト役割 %1 が存在しません。',

    'gphd__mime_types' => 'MIME タイプ',
    'gphd__handlers' => 'Apache ハンドラ',
    'gphd__ip_restrictions_allow' => '指定したホストとネットワークに対してサイトへのアクセスを許可する（拒否されるものを除く）',
    'gphd__ip_restrictions_deny' => '指定したホストとネットワークに対してサイトへのアクセスを拒否する',
    'gphd__directory_index' => 'インデックスファイル',
    'gphd__nginx_transparent_mode' => 'Apache で静的コンテンツと動的コンテンツの両方を処理し、nginx は HTTP 要求/応答を変更せずに受け渡すモードです。',
    'gphd__nginx_serve_static' => '静的ファイルを nginx で直接処理',
    'gphd__nginx_static_extensions' => 'nginx で処理する静的ファイルの拡張子',
    'gphd__nginx_serve_php' => 'PHP ファイルを nginx で処理',
    'gphd__www_root' => 'WWW ルートディレクトリ',

    'eol__none' => '編集しない',
    'eol__lf' => 'Unix スタイルに変換',
    'eol__cr' => 'MacOS スタイルに変換',
    'eol__crlf' => 'Windows スタイルに変換',

    'ui__dns_bad_zone' => 'ゾーン "%1" の不整合：',
    'ui__dns_ns_has_no_address_records' => 'NS レコード "%1" にアドレスレコード（A または AAAA）がありません。',
    '__dns_bad_zone' => 'ゾーン "%1" の不整合：',
    '__dns_ns_has_no_address_records' => 'NS レコード "%1" にアドレスレコード（A または AAAA）がありません。',
    '__dns_ptr_is_wildcard' => 'PTR レコード "%1" が無効です。このレコードはワイルドカードドメインをポイントしています。',

    'firewall_database_user_remote_access_rule_name' => '[%1][%2] 顧客 \'%4\' のデータベースユーザ \'%3\' に対してリモートアクセスを許可',
    'firewall_database_user_remote_access_rule_name_removed' => '[%1][%2] %3',
    'firewall_database_user_remote_access_mssql_server_port_undefined' => 'データベースユーザ \'%1\' に対してリモート接続を許可することができません。Microsoft SQL Server \'%2\' が TCP ポート番号を決定できません。考えられる理由は次のとおりです。TCP/IP プロトコルがサーバネットワーク構成で有効化されていないか、サーバが動的 TCP ポートを使用するように構成されている。特定の固定 TCP ポートを listen するようにサーバを構成し、リモート接続を再試行してください。',

    'command__convertResellerHasCustomer' => 'リセラーアカウント %1 は複数の顧客アカウントを所有しています。このリセラーアカウントを顧客アカウントに変換するには、まずこれらの顧客アカウントを新しい所有者に移管するかリセラーアカウントに変換してください。',
    'command__convertResellerNotReseller' => '顧客アカウントに変換することができるのは、リセラーアカウントのみです。\'%1\' はリセラーではありません。',
    'command__convertResellerToCustomerSubscriptionNotSynchronized' => '契約をサービスプランと同期できませんでした。次の契約設定がサービスプランと相反しています：%%problems%%。',

    'moveCustomer__wrong_customer_type' => 'アカウント %1 はリセラーアカウントです。リセラーアカウントの所有者はサービス管理者なので、新しい所有者に移動することはできません。',
    'moveCustomer__wrong_owner_type' => "顧客アカウント '%1' はリセラーまたは管理者のみに移動することができ、別の顧客に移動することはできません。",
    'moveCustomer__customer_already_belongs_to_owner' => '顧客アカウント %1 は、選択した所有者に既に属しています。',
    'upgradeClient__user_is_admin' => 'アカウント \'%1\' をリセラーアカウントに変換することができません。これは管理者アカウントです。',

    'mail__error_setting_max_connections_courier' => '最大接続数を設定できません（IMAP、POP3、IMAP over SSL/TLS、または POP3 over SSL/TLS）：%1',
    'mail__error_setting_max_connections_dovecot' => '最大接続数を設定できません（IMAP、POP3、IMAP over SSL/TLS、または POP3 over SSL/TLS）：%1',
    'mail__error_setting_max_connections_per_ip_courier' => 'IP アドレスあたりの最大接続数を設定できません（IMAP、POP3、IMAP over SSL/TLS、または POP3 over SSL/TLS）：%1',
    'mail__error_setting_max_connections_per_ip_dovecot' => '特定のメールユーザに対して IP アドレスあたりの最大接続数を設定できません（IMAP、POP3、IMAP over SSL/TLS、または POP3 over SSL/TLS）：%1',
    'outgoing_messages_limit_value_invalid' => '値は %%MIN%%～%%MAX%% の範囲内にしてください。この設定を調整することができるのは、Plesk 管理者のみです。',
    'outgoing_messages_server_settings_catch_address_are_not_local' => "以下のドメインは、存在しないアドレスに送信されたメールの転送に外部メールアドレスを使用します。これらのアドレスに送信されたメッセージは、送信メールの制御でカウントされません。\n%1",
    'outgoing_messages_white_list_not_empty' => '送信メールの上限は、メールサーバのホワイトリストに IP アドレスが含まれているメール送信者に対しては適用されません。例えば、ホワイトリストにローカルホスト（127.0.0.0 / 8, ::1 / 128）が含まれる場合、ローカルサーバからのすべてのメールが上限を問わず正常に送信されます。メール送信者は、ローカル IP アドレス（ローカルサーバ上でホストされるウェブサイトおよびカスタムスクリプト）または外部 IP アドレス（自分のコンピュータまたはモバイルデバイスにインストールしたメールクライアントからメールを送信する顧客）のいずれかを使用できます。すべてのメール送信者（ローカルと外部の両方）に対して上限を機能させるには、ホワイトリストからすべての IP アドレスとネットワークを削除してください。ホワイトリストからローカルホスト（127.0.0.0 / 8, ::1 / 128）を削除すると、このサーバからメールを送信するウェブサイトやスクリプトの動作に支障をきたす可能性があります。送信メールの上限について詳しくは、管理者ガイドの「アウトバウンドパムから防御する」を参照してください。',
    'outgoing_messages_relay_open' => 'メールリレーがオープンです。送信メールの上限は適用されません。',

    'notification_aps_app_updates_available' => '以下のアプリケーションはアップデートが提供されています。',
    'notification_aps_app_updates_installed' => '以下のアプリケーションに対してアップデートが自動インストールされました。',
    'notification_aps_app_updates_requirements' => '以下のアプリケーションはアップデートが提供されていますが、該当するウェブサイトのホスティング設定がインストール要件を満たしていないため、インストールすることができません。',
    'notification_admin_aps_app_updates_available_item' => '%%name%%（%%url%%）。インストール済みバージョン：%%from%%。使用可能バージョン：%%to%%。',
    'notification_admin_aps_app_updates_available_plugin_item' => '%%parentName%%（%%url%%）上のプラグイン "%%name%%"。インストール済みバージョン：%%from%%。使用可能バージョン：%%to%%。',
    'notification_admin_aps_app_updates_available_theme_item' => '%%parentName%%（%%url%%）上のテーマ "%%name%%"。インストール済みバージョン：%%from%%。使用可能バージョン：%%to%%。',
    'notification_reseller_aps_app_updates_available_item' => '%%name%%（%%url%%）。インストール済みバージョン：%%from%%。使用可能バージョン：%%to%%。',
    'notification_reseller_aps_app_updates_available_plugin_item' => '%%parentName%%（%%url%%）上のプラグイン "%%name%%"。インストール済みバージョン：%%from%%。使用可能バージョン：%%to%%。',
    'notification_reseller_aps_app_updates_available_theme_item' => '%%parentName%%（%%url%%）上のテーマ "%%name%%"。インストール済みバージョン：%%from%%。使用可能バージョン：%%to%%。',
    'notification_client_aps_app_updates_available_item' => '%%name%%（%%url%%）。現在のバージョン：%%from%%。使用可能バージョン：%%to%%。',
    'notification_client_aps_app_updates_available_plugin_item' => '%%parentName%%（%%url%%）上のプラグイン "%%name%%"。現在のバージョン：%%from%%。使用可能バージョン：%%to%%。',
    'notification_client_aps_app_updates_available_theme_item' => '%%parentName%%（%%url%%）上のテーマ "%%name%%"。現在のバージョン：%%from%%。使用可能バージョン：%%to%%。',
    'notification_admin_aps_app_updates_installed_item' => '%%name%%（%%url%%）。新規バージョン：%%to%%。旧バージョン：%%from%%。',
    'notification_reseller_aps_app_updates_installed_item' => '%%name%%（%%url%%）。新規バージョン：%%to%%。旧バージョン：%%from%%。',
    'notification_client_aps_app_updates_installed_item' => '%%name%%（%%url%%）。新規バージョン：%%to%%。旧バージョン：%%from%%。',
    'notification_admin_aps_app_updates_requirements_item' => '%%name%%（%%url%%）。インストール済みバージョン：%%from%%。使用可能バージョン：%%to%%。',
    'notification_reseller_aps_app_updates_requirements_item' => '%%name%%（%%url%%）。インストール済みバージョン：%%from%%。使用可能バージョン：%%to%%。',
    'notification_client_aps_app_updates_requirements_item' => '%%name%%（%%url%%）。現在のバージョン：%%from%%。使用可能バージョン：%%to%%。',
    'notification_aps_app_updates_no_installation_url' => '外部アプリケーション',

    'notification_outgoing_mail_exceeded_limits_domains' => 'ドメイン',
    'notification_outgoing_mail_exceeded_limits_mails' => 'メールアドレス',
    'notification_outgoing_mail_exceeded_limits_subscriptions' => '契約',
    'notification_outgoing_mail_exceeded_limits_limit_value' => '1 時間あたり %1 件',
    'notification_outgoing_mail_exceeded_limits_limit_value_unlimited' => '無制限',
    'notification_outgoing_mail_exceeded_limits_object' => '%1、上限：%2',
    'notification_outgoing_mail_exceeded_limits_attempt' => '上限を超えた送信試行が %1 回発生（%2～%3）',
    'notification_outgoing_mail_exceeded_limits_attempt_still_exceeding' => '上限を超えた送信試行が %1 回発生（%2 ～現在）',

    'restart__docker' => "Docker",
    'restart__fail2ban' => "IP アドレスによるアクセス制限（Fail2ban）",

    'backup__restore__capability_fail2ban_not_installed_text' => 'Fail2ban コンポーネントが宛先サーバにインストールされていません。',
    'backup__restore__capability_fail2ban_not_installed_resolution' => 'Fail2ban をインストールします。これには数分かかる可能性があります。',

    'plesk_key__no_reseller_support' => 'ライセンス上の制約により、リセラーを管理することができません。',
    'plesk_key__no_customers_support' => 'ライセンス上の制約により、顧客を管理することができません。',
    'panel_interface_uimodes__service_provider_view_not_allowed' => 'ライセンスの制限により、サービスプロバイダビューに切り替えることができません。',
    'plesk_key__no_security_core_support' => 'ライセンス上の制約により、セキュリティコア機能（ModSecurity および Fail2ban）を使用することができません。',
    'plesk_key__outgoing-antispam' => '送信メールの制御',
    'plesk_key__security-core' => 'セキュリティコア（ModSecurity および Fail2ban）',
    'plesk_key__can-manage-accounts' => 'アカウント管理',
    'plesk_key__can-manage-subscriptions' => '契約管理',
    'plesk_key__can-manage-customers' => '顧客管理',
    'plesk_key__can-manage-resellers' => 'リセラー管理',
    'plesk_key__can-manage-custom-view' => '制限モードを使用可能',
    'plesk_key__limits_exceeded_no_subscriptions_management' => '契約管理がオフになっていますが、複数の契約があります（%1）。',
    'plesk_key__limits_exceeded_no_resellers_management' => 'リセラー管理がオフになっていますが、複数のリセラーがあります（%1）。',
    'plesk_key__limits_exceeded_no_customers_management' => '顧客管理がオフになっていますが、複数の顧客があります（%1）。',
    'plesk_key__limits_unlimited_subscriptions' => 'Plesk インターフェースで今後管理できない特定の契約リソース（メールボックスやドメインのディスク容量の制限など）は無制限に設定されます。',
    'plesk_key__no_subscriptions_support' => 'ライセンス上の制約により、契約を管理することができません。',
    'plesk_key__no_custom_view_support' => 'ライセンスに制限があるため、制限モードを使用できません。',
    'plesk_key__trial_forbidden_region' => '申し訳ありませんが、Plesk は現在、お客様のリージョンではご利用いただけません。',
    'additional_key__main_key' => 'このキーはメインキーです。メインキーを追加キーとしてアップロードすることはできません。',

    'gch__hosting_waf_rule_engine' => 'ウェブアプリケーションファイアウォールのモード',

    'backup__fieldset__restoration_options' => '復元オプション',
    'backup__restore_options__restore' => '復元',
    'backup__restore_options__domain__domain_configuration' => 'ドメイン構成',
    'backup__restore_options__domain__virtual_host_content' => '仮想ホストのコンテンツ',
    'backup__restore_options__domain__mail' => 'メール',
    'backup__restore_options__domain__databases' => 'データベース',
    'backup__restore_options__client__client_configuration' => '顧客アカウントの構成',
    'backup__restore_options__client__domains' => "顧客のドメイン",
    'backup__restore_options__reseller__reseller_configuration' => 'リセラーアカウントの構成',
    'backup__restore_options__reseller__personal_domains' => "リセラーのドメイン",
    'backup__restore_options__reseller__clients' => "リセラーの顧客",
    'backup__restore_options__admin__server_configuration' => 'サーバ設定',
    'backup__restore_options__admin__administrator_configuration' => '管理者アカウントの構成',
    'backup__restore_options__admin__personal_domains' => "管理者のドメイン",
    'backup__restore_options__admin__personal_clients' => "管理者の顧客",
    'backup__restore_options__admin__resellers' => 'リセラー',

    'badge_new' => '新規',
    'upgrade_php_on_subscription' => '契約の PHP をバージョン 5.3.0 以上にアップグレードします。',

    'pkey_notify__body_expiration_notification' => 'このライセンスキーは失効しました。一部の機能が使用できない可能性があります。ホスティング事業者にお問い合わせください。',

    'crontab__crontab_entry_exists' => "このスケジュール済みタスクは既に存在します。",
    'crontab__crontab_entry_not_exists' => "スケジュール済みタスクが存在しません",
    'crontab__invalid_values_found' => "パラメータ値が無効です",
    'crontab__cmd_max_len' => "このコマンドは %1 文字より長くできません。",

    'domain__domain_exists' => "プレフィックス 'www' が付き、同じ名前 %1.%2 のドメインがあります。",
    'domain__subdomain_exists' => "プレフィックス 'www' が付き、同じ名前 %1.%2 のサブドメインがあります。",
    'domain__dalias_exists' => "プレフィックス 'www' が付き、同じ名前 %1.%2 のドメインエイリアスがあります。",
    'domain__record_exists' => "ホスト %1.%2 を参照する DNS レコードがあります。",

    'ip_addr__cannot_assign_certificate' => "証明書 '%1' をデフォルトとして設定できません。秘密キーがありません。",
    'ip_addr__update_dns_error' => 'DNS ゾーン内の IP アドレスの更新中に問題が発生しました。%1',
    'ip_addr__cannot_add_dhcp_enabled' => 'IP アドレスを追加できません。このネットワークインターフェースは IP アドレスを自動的に取得します。',
    'ip_addr__cannot_remove_dhcp_enabled' => 'IP アドレス %1 を削除できません。このネットワークインターフェースは IP アドレスを自動的に取得します。',
    'ip_addr__cannot_repair_dhcp_enabled' => 'IP アドレス %1 を修復できません。このネットワークインターフェースは IP アドレスを自動的に取得します。',
    'ip_addr__cannot_change_interface_dhcp_enabled' => 'IP アドレス %1 のインターフェースを変更できません。ネットワークインターフェース %2 は IP アドレスを自動的に取得します。',

    'shm_lmsg__limit_for_resource_exceeded' => '契約に規定された %%type%% の数の上限を超過しています。上限は %%limit%% で、現在 %%usage%% を使用中です。',
    'shm_lmsg__resource_is_forbidden_for_creation' => 'この契約では %%type%% の作成が禁止されています。',
    'shm_lmsg__resource_title__db-mysql' => 'MySQL データベース',
    'shm_lmsg__resource_title__db-mssql' => 'MS SQL データベース',
    'shm_lmsg__resource_title__db-postgresql' => 'PostgreSQL データベース',
    'shm_lmsg__resource_title__db-user' => 'データベースユーザ',
    'shm_lmsg__resource_title__iis-application-pool' => 'IIS アプリケーションプール',
    'shm_lmsg__resource_title__additional-ftp-account' => '追加 FTP アカウント',

    'db_user_unable_remove_mysql_global_privileges' => 'データベースユーザ %1 の MySQL グローバル権限を削除できません。理由：%2',
    'report__client_description' => '説明',

    'db__user_role_error' => '正しくないデータベースユーザの役割 %1 が指定されています。 以下のいずれかの役割を選択してください：%2。',

    'subscription_unable_to_set_max_filesize_warning' => '次の Microsoft SQL Server データベースはファイルサイズが大きいため、ファイルサイズ上限を設定できません：%1',
    'subscription_unable_to_set_max_log_filesize_warning' => '次の Microsoft SQL Server データベースはログファイルサイズが大きいため、ログファイルサイズ上限を設定できません：%1',
    'ipaddress__cannot_set_up_public_ip_need_ipaddress' => 'パブリック IP アドレスをセットアップできません。プライベート IP アドレスが存在する必要があります。',
    'ipaddress__cannot_set_up_public_ip_need_ipv6' => 'IPv6 アドレスに対してパブリック IPv4 アドレスをセットアップできません。',
    'ipaddress__cannot_set_up_public_ip_need_ipv4' => 'IPv4 アドレスに対してパブリック IPv6 アドレスをセットアップできません。',
    'ipaddress__cannot_set_up_public_ip_invalid' => 'パブリック IP アドレスをセットアップできません。IP アドレスが無効です。',

    '__user_already_exists' => "ユーザ %1 は既に存在します。",
    '__user_name_is_empty' => "ユーザ名を指定してください。",

    'upgrade_php_on_domain' => 'いずれかの WordPress ドメインで PHP バージョン 5.3.0 以降が見つかりません。PHP のアップグレードを試みてください。',

    'component_name__waf' => 'ウェブアプリケーションファイアウォール',
    'component_name__vcs' => 'バージョン管理システム',

    'virtualization_lxc' => 'LXC',
    'virtualization_docker' => 'Docker',
    'possibleSpoofingDetected' => 'なりすましの疑いが検出されました。このリンクは、関係のないコンテンツの表示を試みました。',
    'forceResetPasswordUpdated' => 'パスワードが変更されました。新しいパスワードを使用して Plesk にログインしてください。',

    'php_handlers_error_no_available_instance' => 'ドメインを作成できません。使用可能な PHP ハンドラがありません。',
    'domain_error_unable_to_apply_hosting_settings' => 'ホスティング設定を適用できません。%1',

    'plesk_not_configured' => 'Plesk が構成されていません。コントロールパネルを開き、インストール後の構成を実行してください。',
    'cmd_mail__mail_password_duplicated' => '指定されたメールアドレスとパスワードの組み合わせは、既にメールサーバに登録されています。別のメールアドレスかパスワードを指定してください。',

    'extensionRequirementOs' => 'OS（%1）はこのパッケージでサポートされません。',
    'extensionRequirementPleskMinVersion' => 'このパッケージでサポートされる最初のバージョンは Plesk %1 です。',
    'extensionRequirementPleskMaxVersion' => 'Plesk %1 以降のバージョンはこのパッケージでサポートされません。',
    'extensionBlacklisted' => '拡張子 %1 のインストールは許可されません。',
    'extensionDisabled' => '拡張は無効です。',


    'optimization_settings__unable_set_mpm_event' => 'mpm_event モードを設定できません。Apache PHP5 モジュールがオフになっている必要がありますが、このモジュールはドメインに使用されています。',
    'optimization_settings__unable_turn_off_php' => 'Apache PHP5 モジュールをオフにできません。ドメインに使用されています。',

    'hst_def__fp_admin_login' =>  'FTP ユーザ名',
    'hst_def__fp_admin_passwd' =>  'FTP パスワード',

    'database_user_orphaned_old_password_wrong' => "孤立ユーザ '%1' の修復ができません。パスワードが正しくありません。",
    'cannot_load_partner_central_property_key_no_exist' => "カスタムプロパティを取得できません。ライセンスキーは存在しません。",
    'extensionScriptFailure' => "%1 の実行が失敗しました。メッセージ：%3",
    '__ssl_redirect' => "SEO に対応する HTTP から HTTPS への恒久的 301 リダイレクト",
    'component_name__dotnetcore' => '.NET Core',
    'mail__dkim_not_supported' => 'DKIM 管理はサポートされていません。',
    'mail__dmarc_not_supported' => 'DMARC 管理はサポートされていません。',
    'mail__relay_white_list_not_supported' => 'リレーのホワイトリスト管理はサポートされていません。',
    'mail__black_list_not_supported' => 'ブラックリスト管理はサポートされていません。',
    'mail__autoresponder_not_supported' => '自動応答機能の管理はサポートされていません。',
    'defaultcomponents__not_supported_version' => '（未サポートバージョン）',
    'component_name__nodejs' => 'Node.js',

    'certificate__not_found' => '証明書 \'%1\' が見つかりませんでした。',
    'certificate__unable_setup_certificate' => '証明書をインストールできません：秘密キーと証明書コンテンツが不足しています。',
    'certificate__used_by_panel' => '削除しようとしている証明書のいずれかが Plesk のセキュリティ強化に使用されています。',
    'certificate__used_by_mail_server' => '削除しようとしている証明書のいずれかがメールサーバのセキュリティ強化に使用されています。',
    'certificate__used_by_domain_service' => '削除しようとしている証明書のいずれかがドメインサービスで使用されています。',
    'mail_server__not_installed' => 'メールサーバがインストールされていないため、メールサーバ用に証明書をインストールできません。',

    'email_activation_mail_subject' => 'Plesk でアカウントをアクティブ化してください',
    'email_activation_mail_body' => "Plesk サーバにアカウントが作成されました %1 アカウントの詳細：名前：%2 メールアドレス：%3 この情報が正しく、あなた用に作成されたアカウントである場合、以下のリンクからアクティブ化してください：%4 アカウントをアクティブ化することで、サーバの所有者に対してあなたの個人データ（名前とメールアドレス）の収集、保存、処理、使用を許可することになります。この情報は、現在有効なデータ保護法に従い、契約の一貫として、アカウントを作成し、サポートするために使用されます。",

    'backup_transport_permission_name' => '%1 管理',
    'backup_transport_permission_description' => 'バックアップの保存に %1 の使用を許可します。',

    'domain_move_err_target_no_hosting' => 'ホスティングのない契約にドメインを移行できません。',
    'domain_move_err_already_in_target' => 'このドメインは既にターゲット契約に属しています。',
    'domain_move_err_main_domain' => 'メインドメインは移行できません。',
    'domain_move_err_subdomain_without_parent' => '親ドメイン %2 のないサブドメイン %1 は移行できません。',
    'domain_move_err_root_exists' => 'www_root %1 のターゲットパスは既に存在します。',
    'domain_move_err_nested_roots' => 'ドメインを移行できません。他のドメインとドキュメントルートを共有しています：%1。',
    'domain_move_err_no_mail_service' => 'ドメインを移行できません。メールサービスがターゲット契約で無効になっています。',
    'domain_move_err_app' => "%1 にインストールされたアプリケーションは契約 %2 に移行されませんでした：%3",
    'domain_move_database_used_by_app' => "データベース %1（%2）は移行済みアプリケーションで使用されています。データベースを %3 に割り当て直すには、`plesk bin database --assign-to-subscription` を実行してください",
    'domain_move_target_locked' => "ターゲット契約 %1 の同期がロックされました。",
    'domain_move_filesharing_disabled' => 'ファイル共有が無効になりました。',
    'domain_move_website_preview_disabled' => 'ウェブサイトのプレビューが無効化されました。',
    'domain_move_additional_webserver_settings' => "構成の破損を防止するために、ドメインの追加のウェブサーバディレクティブをレビューしてください。",
    'domain_move_no_permission' => "%1 は契約 %2 に許可されていません。",
    'domain_move_no_access' => "契約 %1 にアクセスできません。",
    'domain_split_no_create_permission' => "ドメインの作成は許可されません。",
    'domain_split_empty_login' => 'システムユーザのログイン名が必要です。',
    'domain_split_empty_password' => 'システムユーザのパスワードが必要です。',
    'domain_split_err_home_exists' => 'ドメイン %1 を移動できません。ターゲットホームパスが既に %2 にあります。新しい契約に移動するには、ドメインの名前を変更してください。',
    'domain_split_err_no_hosting_subdomains' => 'ドメインを新しい契約に移動できません。ドメインにホスティングはありませんがサブドメインがあります。ドメインを移動するには、（ホスティング設定で）［ホスティングタイプ］の値を［ウェブサイトホスティング］に変更してください。',
    'domain_split_target_locked' => "ターゲット契約 %1 の同期はロックされています。",
    'domain_split_target_unsynced' => "ターゲット契約 %1 は次の理由でプランと同期されませんでした：%2。",
    'domain_merge_scheduled_backup_deactivated' => "スケジュール済みバックアップが %1 で非アクティブ化されました。",
    'domain_merge_database_error' => "%2 のデータベース %1 は契約 %3 に移動されませんでした：%4",
    'domain_merge_anon_ftp_deactivated' => "%1 の匿名 FTP がオフになりました。",
    'domain_merge_smb_user_access' => "追加ユーザ %1 が契約 %2 に移動されましたが、このユーザの契約へのアクセス許可は取り消されました。",
    'domain_merge_scheduled_tasks' => "スケジュール済みタスクがターゲット契約に移動されました。タスクの構成を確認してください。",
    'domain_merge_scheduled_tasks_deactivated' => "スケジュール済みタスクがターゲット契約に移動され、非アクティブ化されました。タスクの構成を確認してください。",
    'domain_merge_no_remove_permission' => "契約の削除は許可されません。",
    'domain_merge_err_has_addons' => 'メインドメインを追加ドメインとともに移動することはできません。まずドメイン %1 を移動してください。',
    'domain_merge_err_has_webusers' => 'ウェブユーザのあるメインドメインは移動できません。',
    'domain_merge_err_root_exists' => '%1 ターゲットパスは既に存在します。',

    'database_server_edit_used_for_psa' => 'ローカル MySQL データベースサーバの更新は許可されません。',
    'suggest_repair_main_suggestion_ui' => '<b>このエラーは、</b>`plesk repair` ユーティリティを使用すれば修正できます。',
    'suggest_repair_main_suggestion_cli' =>  'このエラーは、`plesk repair` ユーティリティを使用すれば修正できます。',
    'suggest_repair_repair_kit_link_title' => '［診断して修復］に移動',
    'suggest_repair_using_cli_and_ui' => 'それには、CLI で `plesk repair %1` コマンドを実行するか、%2して［Plesk データベース］の横で［修復］をクリックしてください',
    'suggest_repair_using_cli' => 'それには、CLI で `plesk repair %1` コマンドを実行してください',

    'backup__restore__capability_duplicate_php_handler_resolution' => '',
    'bu_conflict_resolver_dns_not_available' => 'バックアップの作成時に DNS サービスを使用できませんでした。ただし、バックアップにはアクティブな DNS ゾーンがあるため、以下のオブジェクトに対して有効化されます：{{objects}}',
    'plesk_key__system-resources-limits-enabled' => 'リソースコントローラ（cgroups）',
    'plesk_key__remote-smartermail-enabled' => 'リモート SmarterMail のサポート',
    'plesk_key__complete-backup-solution' => 'Backup to Cloud Pro',
    'defaultcomponents__no_license' => '（ライセンスキーで許可されていません）',
    'plesk_key__validation_failed' => '%1（エラーコード：%2）',
    'promo__button_details' => '詳細',
    'promo__extension_catalog_title' => '拡張カタログ',
    'promo__extension_catalog_description' => '新しい拡張カタログを確認し、高機能な拡張の数々で Plesk をパワーアップしましょう！',
    'promo__button_open_catalog' => 'カタログを開く',

    'backup__repository_check_login' => "ストレージにアクセスできません：%1 ストレージの正しいクレデンシャルを入力したことを確認してください。",
    'backup__repository_check_error_list' => "ストレージにアクセスできません：%1 正しいストレージ設定を入力したことを確認してください。",
    'backup__repository_check_error_mkdir' => "ディレクトリトリを作成できません：%1 ストレージでフォルダを作成する権限があるか確認してください。",
    'backup__repository_check_error_upload' => "ストレージにファイルをアップロードできません：%1 ストレージにファイルをアップロードする権限があるか確認してください。",
    'backup__repository_check_error_download' => "ストレージからファイルをダウンロードできません：%1 ストレージでファイルのアップロードとダウンロードを行う権限があるか確認してください。",
    'backup__repository_check_error_resume-upload' => "ストレージへのファイルのアップロードを再開できません：%1 ストレージへのファイルのアップロードを再開する権限があるか確認してください。",
    'backup__repository_check_error_resume-download' => "ストレージからのファイルのダウンロードを再開できません：%1 ストレージからのファイルのダウンロードを再開する権限があるか確認してください。",
    'backup__repository_check_error_enable-utf8' => "ストレージを操作できません：%1 ストレージが UTF8 エンコーディングに対応していることを確認してください。",
    'backup__repository_check_error_rm' => "ストレージを操作できません：%1 ストレージからファイルを削除する権限があるか確認してください。",
    'backup__repository_check_error_rmdir' => "ストレージを操作できません：%1 ストレージからフォルダを削除する権限があるか確認してください。",

    'backup__ftp_repository_check_login' => "%1 次のコマンドで個別にチェックできます：%2",
    'backup__ftp_repository_check_error_list' => "%1 次のコマンドで個別にチェックできます：%2",
    'backup__ftp_repository_check_error_mkdir' => "%1 次のコマンドで個別にチェックできます：%2",
    'backup__ftp_repository_check_error_upload' => "%1 次のコマンドで個別にチェックできます：%2 %3",
    'backup__ftp_repository_check_error_download' => "%1 次のコマンドで個別にチェックできます： %2 %3",
    'backup__ftp_repository_check_error_resume-upload' => "%1 次のコマンドで個別にチェックできます： %2 %3 %4",
    'backup__ftp_repository_check_error_resume-download' => "%1 次のコマンドで個別にチェックできます：%2 %3",
    'backup__ftp_repository_check_error_enable-utf8' => "%1 次のコマンドで個別にチェックできます：%2",
    'backup__ftp_repository_check_error_rm' => "%1 次のコマンドで個別にチェックできます：%2 %3",
    'backup__ftp_repository_check_error_rmdir' => "%1 次のコマンドで個別にチェックできます：%2 %3",

    'sfdmarc_server_wide_enable_failed' => 'DMARC の設定は変更できません。このオプションを有効にするには、DKIM および SPF によるスパム防御をオンにしてください。',
    'spf_server_wide_disable_failed' => 'SPF スパム防御の設定は変更できません。SPF を無効にするには、受信メールに対して DMARC をオフにしてください。',
    'sfdk_server_wide_verify_disable_failed' => 'DKIM スパム防御の設定は変更できません。DKIM を無効にするには、受信メールに対して DMARC をオフにしてください。',

    'ccs_not_supported' => 'IIS Central Certificate Store がシステムで構成されていません。',
    'ccs_not_enabled' => 'IIS Central Certificate Store 管理が Plesk で有効ではありません。',
    'ad_not_supported' => 'このサーバはドメインに追加されていません。',

    'component_name__appinit' => "アプリケーションの初期化",
    'component_name__httpcompression' => 'HTTP コンテンツ比較',
    'common_feature_is_not_supported' => 'この機能はサポート対象外になりました。',
    'common_feature_is_not_supported_in_proto' => 'この機能はプロトコルのバージョン %1 でサポートされません。',
    'autoinstaller__plesk_component' => 'Plesk コンポーネント',
    'plesk_key__key_expired' => 'ライセンスキーの有効期限が切れました。Plesk の利用を続けるには、無期限の商用 %1 をご購入ください。',
    'plesk_key__key_purchase' => 'ライセンスキー',

    'sa_action_move' => 'スパムを「迷惑メール」フォルダに移動',

    'bu_conflict_resolver_tomcat_not_supported' => 'Java アプリケーションはサポート対象外になりました。以下のウェブサイトで利用できなくなります：{{objects}}',
    'bu_conflict_resolver_unity_mobile_not_supported' => 'UNITY Mobile でホストされていたモバイル版ウェブサイトはサポート対象外になりました。以下のウェブサイトで利用できなくなります：{{objects}}',
    'bu_conflict_resolver_antivirus_personal_management_not_allowed' => 'サーバ全体の使用ポリシーにより、アンチウイルスの個人設定の使用が許可されていません。これらの設定は、以下のドメインのメールアカウントで不完全に復元されます：{{objects}}',

    'module__not_installed' => "拡張 %1 はインストールされていません",

    'mail__mail_autodiscovery_server_error' => 'メール自動検出用にカスタムドメイン名を指定できません',
    'mail__error_mail_autodiscovery_enable' => 'メール自動検出を設定できません：%1',
    'mail__error_mail_autodiscovery_server' => 'メール自動検出用にカスタムドメイン名を設定できません：%1',
    'mail__error_mail_autodiscovery_reconfigure_dns' => 'ドメイン自動検出 DNS レコードを再構成できません：%1',

    '__invalid_url' => 'URL "%1" は無効です',
    'actionlog__cloning_start' => '開始',
    'actionlog__event_cloning_start' => 'サーバの複製の開始',

    '__UPLOAD_ERR_FORM_SIZE' => "アップロードされたファイルは許可されたサイズを超過しています。",
    '__UPLOAD_ERR_INI_SIZE' => "アップロードされたファイルは許可されたサイズを超過しています。",
    '__UPLOAD_ERR_NO_FILE' => "ファイルを受信していません",
    '__UPLOAD_ERR_OK' => "ファイルは正常にアップロードされました",
    '__UPLOAD_ERR_PARTIAL' => "ファイルの一部が既にアップロードされています。再度実行してください",
    '__UPLOAD_ERR_NO_TMP_DIR' => '一時フォルダが見つかりません',
    '__UPLOAD_ERR_CANT_WRITE' => 'ディスクにファイルを書き込めません',
    '__UPLOAD_ERR_UNKNOWN' => '不明なファイルアップロードエラーが発生しました',
    '__accounts' => "アカウント",
    '__access' => "アクセス",
    '__address' => "アドレス",
    '__addresses' => "アドレス",
    '__acl_records' => 'ACL レコード',
    '__admin_repository' => "管理者リポジトリ",
    '__all' => 'すべて',
    '__allowed' => "許可",
    '__anonftp_status' => "匿名 FTP",
    '__antispam' => "アンチスパム",
    '__apache_restart' => "...%1 ウェブサーバを再起動しています。しばらくお待ちください...",
    '__asp' => "Microsoft ASP",
    '__asp_dot_net' => "Microsoft ASP.NET",
    '__asp_dot_net_support' => "Microsoft ASP.NET サポート",
    '__asp_win_support' => "Microsoft ASP サポート",
    '__attachments' => "添付ファイル",
    '__attachments_list' => "添付ファイル",
    '__author' => '作成者',
    '__autoresp_name_already_exists' => "名前が %1 の自動応答は既に存在します。",
    '__autoresponder' => "自動応答",
    '__autoresponders' => "自動応答",
    '__autoresponders_list' => "自動応答",
    '__autoresponder_attachment_files' => "自動応答の添付ファイル",
    '__auto_updates_list' => '使用可能なアップデート',
    '__avail' => "使用可能",
    '__backup_utilites' => "バックアップ ユーティリティ",
    '__bind_status' => "DNS サーバの状態",
    '__bu_is_not_installed' => "バックアップユーティリティがインストールされていないため、現在このサービスは使用できません。",
    '__bu_not_support_in_key' => "ライセンスキーにてバックアップ機能がサポートされていません",
    '__notifications_not_support_in_key' => '通知がライセンスキーにてサポートされていません',
    'disabled_by_key' => 'ライセンスキーにてサポートされていません',
    '__bytes' => "バイト",
    '__can_not_use_reserved_words' => "予約されている単語は使用できません。",
    '__certificate' => "証明書",
    '__cgi_support' => "CGI サポート",
    '__change_date' => "変更日時",
    '__city' => "市区町村",
    '__cl_not_exist' => "顧客アカウントが存在しません",
    '__client' => '顧客',
    '__client_card' => "顧客のカード",
    '__client_contact_name' => "顧客の担当者名",
    '__client_form' => "個人情報",
    '__client_ip_pool' => "顧客の IP プール",
    '__client_limits' => "顧客アカウントの上限",
    '__client_permissions' => "顧客のパーミッション",
    '__client_preferences' => "顧客のプリファレンス",
    '__client_status' => "顧客のステータス",
    '__client_name' => "顧客の名前",
    '__client_total' => "顧客の合計",
    '__client_with_login_name_already_exists' => "ユーザ名が「%1」のユーザは既に存在します。",
    '__client_domuser_with_login_already_exists' => "ユーザ名 '%1' は、既にドメイン管理者 '%1' によって使用されています。",
    '__clients_global_changes' => "選択した顧客アカウントの変更",
    '__clients_list' => "顧客",
    '__cmd_not_found' => "未知のコマンド： %1",
    '__comments' => "コメント",
    '__company_name' => "会社名",
    '__component_version' => "コンポーネントバージョン",
    '__component_not_installed' => "コンポーネント %1 がインストールされていません",
    '__confirm_del' => "削除を確認する必要があります。",
    '__confirm_overwrite' => "上書きしてもよいか確認する",
    '__confirm_stop' => "プロセス停止を確認する必要があります。",
    '__confirm_passwd' => "%1 パスワードの確認",
    '__confirm_removal' => "確認して削除を実行",
    '__conhelp' => "説明",
    '__contact_name' => "担当者名",
    '__country' => "国",
    '__countries' => '国',
    '__country_unknown' => '国のサブコードを認識できません。',
    '__courier-imap' => 'Courier サーバ',
    '__create_domain' => 'ドメインを作成',
    '__crypted' => '暗号化',
    '__cp_access' => "Plesk へのアクセス",
    '__cp_user' => "Plesk ユーザ",
    '__create' => "作成",
    '__create_client_template_without_template' => "テンプレートを使わずにクライアントを作成する",
    '__create_domain_for' => "<b>%1</b> のドメインを作成",
    '__create_domain_template_without_template' => "テンプレートを使わずにドメインを作成する",
    '__creation_date' => "作成日",
    '__crontab_unix' => "スケジューラ",
    '__crontab_win' => "スケジューラ",
    '__ct_month_jan' => '1 月',
    '__ct_month_feb' => '2 月',
    '__ct_month_mar' => '3 月',
    '__ct_month_apr' => '4 月',
    '__ct_month_may' => '5 月',
    '__ct_month_jun' => '6 月',
    '__ct_month_jul' => '7  月',
    '__ct_month_aug' => '8 月',
    '__ct_month_sep' => '9 月',
    '__ct_month_oct' => '10 月',
    '__ct_month_nov' => '11 月',
    '__ct_month_dec' => '12 月',
    '__custom_button' => "カスタムボタン",
    '__custom_buttons_list' => "追加サービスへのリンク",
    '__daily' => "毎日",
    '__database_not_activated' => "サーバ管理ページで %1 がアクティブ化されていません。",
    '__database_not_installed' => "データベース %1 はインストールされていません",
    '__database_not_run' => "データベース %1 は起動していません",
    '__database_is_corrupt' => "Plesk のデータベースが破損しています。Reconfigurator ユーティリティを起動して修復してください。",
    '__databases' => "データベース",
    '__databases_list' => "データベース",
    '__database_type_not_supported_by_key' => '%1 サーバを使用するためには、ライセンスキーでこれがサポートされている必要があります。Plesk 営業担当までお問い合わせください。',
    '__date_immediately' => "当日",
    '__date_never' => "なし",
    '__day(s)' => "日",
    '__day0' => "日",
    '__day1' => "ヶ月",
    '__day2' => "火曜",
    '__day3' => "水",
    '__day4' => "木曜",
    '__day5' => "金",
    '__day6' => "土",
    '__days' => "%1 日",
    '__db_admin_login_empty' => "ユーザ名が空欄のため、インターフェースにおいて %1 によるコントロールが無効になります。 続行しますか？",
    '__db_unable_to_unregister' => 'データベース接続パラメータを削除できません',
    '__db_db_exists' => 'サーバ上にデータベースが 1 つ以上存在します。',
    '__db_unable_to_change_server_name' => 'そのサーバ名の変更は出来ません',
    '__db_unable_to_change_port' => 'そのサーバのポートは変更できません',
    '__db_already_exist' => "データベース %1 は既に存在します。",
    '__db_credentials_invalid' => "データベースクレデンシャルが無効です。",
    '__db_invalid_password_characters' => 'パスワードに無効な文字が含まれています',
    '__db_engine' => "データベースエンジン", // indirect
    '__db_type' => "データベースのタイプ",
    '__db_user' => "データベースユーザ",
    '__db_server' => 'データベースサーバ',
    '__def_domain' => "デフォルトドメイン",
    '__default_for_mysql' => 'MySQL のデフォルト',
    '__default_for_mariadb' => 'MariaDB のデフォルト',
    '__default_for_percona' => 'Percona のデフォルト',
    '__default_for_postgresql' => 'PostgreSQL のデフォルト',
    '__delete' => "削除",
    '__demo' => "当該機能はデモバージョンでは利用できません",
    '__directory' => "ディレクトリ",
    '__disable_lock_screen' => 'インターフェース画面が完全に読み込まれるまで、ユーザがコントロールパネルで作業することはできません。',
    '__dismiss_news?' => "ニュースブロックを完全に隠してよろしいですか？ \n\n新しいニュースが公開されるまで、ニュースブロックは表示されません。",
    '__description' => "説明",
    '__disabled' => "オフ",
    '__disk_space_limit' => "ディスクスペース上限",
    '__cgroups_cpu_usage_limit' => 'CPU 使用率の上限',
    '__cgroups_ram_usage_limit' => 'RAM 使用量の上限',
    '__cgroups_disk_read_usage_limit' => 'ディスク読込帯域幅の上限',
    '__cgroups_disk_write_usage_limit' => 'ディスク書込帯域幅の上限',
    '__disk_usage_by' => "%1が使用しているディスクスペース",
    '__dns' => "DNS",
    '__dns_record_already_exist' => "DNS レコード「%1」は既に存在します。",
    '__dns_master_should_be_remote' => "異なるホスト上に存在する、2 つの認証ネームサーバを登録する必要があります。",
    '__dns_record_not_exist' => "DNS レコードが存在しません",
    '__dns_server' => "DNS サーバ", // indirect
    '__dom_id_is_undefined' => "ドメイン ID が定義されていません",
    '__dom_name' => "ドメイン名",
    '__dom_name_is_invalid' => "ドメイン名が無効です。ドメイン名は、半角英数字、ドットおよびハイフンからのみ構成されており、255 文字以下である必要があります。またドットにて分割されているドメイン名の各部分は、63 文字以下である必要があります。",
    '__dom_not_exist' => "ドメインが存在しません",
    '__domain' => "ドメイン",
    '__domain_' => 'ドメイン %1',
    '__domain_form' => "ドメインフォーム",
    '__domain_id' => "ドメイン ID",
    '__domain_is_turned_off_for_backup' => "ウェブサイト %1 はバックアップまたは復元のために一時的に無効化されており、現在使用できません",
    '__domain_limits' => "ドメイン上限",
    '__domain_name' => "ドメイン名",
    '__mail_name_in_ASCII_form' => "メールアカウント名（ASCII フォーマット）",
    '__message_error' => 'エラー',
    '__message_warning' => '注意',
    '__message_info' => '情報',
    '__domain_name_in_ASCII_form' => "ASCII 形式にてドメイン名を指定します。",
    '__domain_repository' => "ドメイン %1 のリポジトリ",
    '__domain_status' => "ドメインステータス",
    '__domain_dns' => 'ドメイン DNS ゾーン',
    '__domain_total' => "契約全体での統計",
    '__domain_total_powerUser' => "契約全体での統計",
    '__domain_user' => "ドメイン管理者",
    '__domains_global_changes' => "ドメイン一括操作",
    '__mailnames_global_changes' => "メールアカウントへのグループ操作",
    '__backup_manager' => 'バックアップマネージャ',
    '__domains_list' => "ドメイン",
    'domains_list__list_header' => "ドメイン", //this is a part of phrases like No domains (and others), so it should not be capitalized
    '__double_www_warning' => "ドメイン名の先頭は www ですが、使用されているプレフィックスは WWW です。続行しますか？",
    '__dovecot' => 'Dovecot IMAP および POP3 サーバ',
    '__dsmail' => "メールサービス",
    '__dsmaillist' => "メーリングリストサービス",
    '__dsr_db' => "DB",
    '__dsr_dname' => "ドメイン名",
    '__dsr_du' => "DU",
    '__dsr_ma' => "MA",
    '__dsr_mg' => "MF",
    '__dsr_ml' => "ML",
    '__dsr_mn' => "MBox",
    '__dsr_pname' => "顧客の名前",
    '__dsr_sd' => "SD",
    '__dsr_tr' => "TR",
    '__dsr_wu' => "WU",
    '__dumps_tot_size' => "ローカルストレージでのバックアップファイルの合計サイズ",
    '__email' => "メール",
    '__email_addr_is_invalid' => "メールアドレスが無効です。",
    '__enabled' => "オン",
    '__enter_cert_text' => "証明書テキストを入力",
    '__enter_size' => "サイズ入力",
    '__exclusive' => "専用",
    '__expiration_date' => "有効期限",
    '__fax' => "ファックス",
    '__file' => "ファイル",
    '__file_is_empty' => "ファイルが空です。",
    '__file_name' => "ファイル名",
    '__file_type' => 'ファイルタイプ',
    '__filemanager' => "ファイルマネージャ",
    '__filepath_is_empty' => "ファイルへのパスが空です",
    '__files_list' => "ファイル",
    '__frontpage' => "Microsoft FrontPage",
    '__ftp' => "FTP", // +indirect
    '__ftp_settings' => "FTP 設定",
    '__ftp_serv' => "FTP サーバ", // indirect
    '__ftp_server_parameters_are_empty' => "まず最初に、FTP アカウントのプロパティを設定する必要があります。",
    '__ftp_status' => "FTP サーバの状態",
    '__full_day0' => "日曜日",
    '__full_day1' => "月曜日",
    '__full_day2' => "火曜日",
    '__full_day3' => "水曜日",
    '__full_day4' => "木曜日",
    '__full_day5' => "金曜日",
    '__full_day6' => "土曜日",
    '__full_month1' => "1 月",
    '__full_month10' => "10 月",
    '__full_month11' => "11 月",
    '__full_month12' => "12 月",
    '__full_month2' => "2 月",
    '__full_month3' => "3 月",
    '__full_month4' => "4 月",
    '__full_month5' => "5 月",
    '__full_month6' => "6 月",
    '__full_month7' => "7  月",
    '__full_month8' => "8 月",
    '__full_month9' => "9 月",
    '__giga' => "G",
    '__group' => "グループ",
    '__h' => "H",
    '__hard_disk_quota' => "ハードディスククォータ",
    '__hard_disk_quota_not_supported' => 'ハードディスククォータは、サーバファイルシステムの設定によりサポートされていません',
    '__header_text_is_invalid' => "保護エリアのタイトルが無効です",
    '__help_topic_not_found' => '要求されたヘルプトピック（%1）は存在しません。',
    '__hosting_ip_dns_ip_not_equiv' => "DNS の A レコードで指定された IP アドレスと、ホスティング用のIP アドレスが一致しません",
    '__hosting_scripting' => "ホスティングスクリプティング対応",
    '__hosting_setup_page_title' => "ドメイン %1 の物理ホスティング設定ページ",
    '__hosting_title' => "ホスティング（%1）",
    '__hosting_type' => "ホスティングタイプ",
    '__hostname_is_empty' => "ホスト名が無効です",
    '__hour(s)' => '時間',
    '__hst_type_incorrect' => "ホスティングタイプが無効です",
    '__http' => "HTTP", //indirect
    '__htype' => "H",
    '__idle_time' => "アイドル時間",
    '__iface' => "インターフェース",
    '__image' => "画像",
    '__imap_status' => "IMAP サーバの状態",
    '__in' => "In",
    '__in_%' => "%",
    '__incorrect_databases_login_pass' => "PostgreSQL 接続用に指定したクレデンシャルが無効です。",
    '__incorrect_ip_or_network_address' => '無効なIP アドレスまたはネットワークです',
    '__info' => '情報',
    '__install' => "インストール",
    '__install_prefix' => "インストールプレフィックス",
    '__invalid_cert_id' => "無効な証明書 ID",
    '__invalid_context' => "コンテキストが正しくありません。%1",
    '__invalid_db_usr_name' => "データベースユーザ名が正しくありません",
    '__invalid_dir_name' => "ディレクトリ名が無効です",
    '__invalid_dom_name' => "ドメイン名が正しくありません",
    '__invalid_filename' => "ファイル名が正しくありません。単一引用符や「../」の組み合わせなどは使用しないでください。",
    '__invalid_id' => "識別子が正しくありません",
    '__invalid_lines_num' => "行数が無効な値です。数値のみ指定可能です",
    '__invalid_max_letter_size' => "最大メッセージサイズが無効です",
    '__invalid_pdir_name' => "保護ディレクトリ名が正しくありません",
    '__invalid_restart_apache_interval' => "Apache を再起動する間隔が無効です",
    '__invalid_tmpl_name' => "テンプレート名が正しくありません",
    '__invalid_value' => "値が正しくありません",
    '__ip_addr' => "IP アドレス",
    '__ip_address_and_mask' => "IP アドレスとサブネットマスク",
    '__ip_alias__mask' => "IP アドレスとサブネットマスク",
    '__ip_addr_is_invalid' => "IP アドレスが正しくありません",
    '__ip_addr_list' => "IP アドレス",
    '__ip_address_and_mask_hint' => '例： %1',
    '__is_owner' => "O",
    '__java_engine' => "Java", // indirect
    '__jdk' => "JDK",
    '__kb' => "KB",
    '__kbps' => "KB/s",
    '__kbytes' => "KB",
    '__key_for_virtuozzo_only' => "このライセンスキーは、Virtuozzo containers のみを対象としています。",
    '__key_limits_exceeding' => "このアクションはソフトウェアライセンスの制限を超えています。プロバイダもしくはメーカーにご確認ください",
    '__kilo' => "K",
    '__keywords' => 'キーワード',
    '__lang_unknown' => '言語を特定することができません',
    '__languages' => '言語',
    '__learn_more' => 'さらに詳しく',
    '__loading' => '読み込み中...',
    '__locales' => "言語パック",
    '__lists' => "メーリングリスト",
    '__literal_bytes' => "B",
    '__processing' => "しばらくお待ちください。<br>読み込み中です ...",
    '__locale' => "インターフェース言語",
    '__locale_is_not_defined' => "インターフェース言語が設定されていません。",
    '__local_server_mysql' => 'ローカル MySQL サーバ',
    '__local_server_postgresql' => 'ローカル PostgreSQL サーバ',
    '__local_server_mssql' => 'ローカル MS SQL サーバ',
    '__log_and_statistics_files' => 'ログファイルおよび統計レポート',
    '__config_files' => '構成ファイル',
    '__chroot_files' => 'Chrooted 環境',
    '__login' => "%1 ログイン名",
    '__login1' => "ログイン名",
    '__login_disabled' => "ログイン禁止",
    '__login_enabled' => "ログイン許可",
    '__login_incorrect' => "ユーザ名またはパスワードが正しくありません",
    '__login_name' => "%1 ユーザ名",
    '__login_name_is_invalid' => "%1 ユーザ名が正しくありません",
    '__logon_time' => "ログオン時間",
    '__ma' => "メールエイリアス",
    '__mail' => "メール",
    '__mail_alias_name' => "メールエイリアス名",
    '__mail_autodiscovery' => 'メール自動検出',
    '__mail_exchanger_name_is_invalid' => "メールエクスチェンジャー名が正しくありません",
    '__mail_groups' => "メールグループ",
    '__mail_list_engine' => "メーリングリストソフトウェア",
    '__mail_name' => "メールアカウント",
    '__mail_name_form' => "メールアカウントプロパティ",
    '__mail_names' => "メールアカウント",
    '__mail_serv' => "メールサーバ",
    '__mail_user' => 'メールユーザ',
    '__mailgroup' => "メールグループ",
    '__maillist' => "メーリングリスト",
    '__maillists' => "メーリングリスト",
    '__maillist_member' => 'メーリングリストメンバ',
    '__mailname' => "メールアカウント",
    '__mailname_redir_self' => "メールアカウントはそれ自身のアドレスへは転送できません",
    '__max_dom_num_reached_for_cl' => "この顧客アカウントはドメインの上限数に達しました",
    '__max_file_size_available' => "%1の上限ファイルサイズ",
    '__max_subdom_num_reached_for_cl' => "この顧客アカウントはサブドメインの上限数に達しました",
    '__max_subdom_num_reached_for_dom' => "ドメインはサブドメインの上限値に達しました",
    '__max_subdom_num_reached_for_key' => "ライセンスキーで許可しているサブドメインの上限数に達しました",
    '__max_traffic_limit' => "トラフィック制限",
    '__maximum_excl_ip_num' => "メールアカウント",
    '__mb' => "MB",
    '__mbytes' => "MB",
    '__mb_month' => "MB/月",
    '__mb_sec' => "MB/秒",
    '__gb_sec' => "GB/秒",
    '__tb_sec' => "TB/秒",
    '__mega' => "M",
    '__minute(s)' => '分',
    '__mls_not_in_key' => "お使いのプロダクトキーが多言語インターフェースに対応していません。",
    '__modification_date' => "変更日時",
    '__module' => "エクステンション",
    '__month' => "ヶ月",
    '__month(s)' => "ヶ月",
    '__month1' => "1 月",
    '__month10' => "10 月",
    '__month11' => "11 月",
    '__month12' => "12 月",
    '__month2' => "2 月",
    '__month3' => "3 月",
    '__month4' => "4 月",
    '__month5' => "5 月",
    '__month6' => "6 月",
    '__month7' => "7  月",
    '__month8' => "8 月",
    '__month9' => "9月",
    '__monthly' => "毎月",
    '__months' => "ヶ月",
    '__moved_permanently' => '恒久的に移動しました',
    '__mssql' => "Microsoft SQL Server（mssql）",
    '__mssql__server' => "サーバ",
    'mssql__server' => "Microsoft SQL サーバ名",
    'mssql__unable_to_change_server_name_db_exists' => "そのサーバの名前を変更できません。サーバ上に 1 つ以上のデータベースが存在します。",
    '__mssql_status' => "Microsoft SQL server の状態",
    '__multiply_login_deny' => "ログインできません。別のユーザが同じユーザ名（%1）で Plesk にログインしています。",
    '__mysql' => "MySQL",
    '__mysql_status' => "MySQL サーバの状態",
    '__mysql_version' => "MySQL バージョン",
    '__mariadb' => "MariaDB",
    '__mariadb_status' => "MariaDB サーバのステータス",
    '__mariadb_version' => "MariaDB のバージョン",
    '__percona' => "Percona",
    '__percona_status' => "Percona サーバのステータス",
    '__percona_version' => "Percona のバージョン",
    '__name' => "名前",
    '__name_invalid' => "名前が正しくありません",
    '__nameserver' => "ネームサーバ",
    '__network' => "ネットワーク",
    '__networks' => "ネットワーク",
    '__no' => "いいえ",
    '__no_ip_address_with_properly_type_available' => "復元に必要である適切な IP アドレスが存在しないため、バックアップしたデータを復元できません。",
    '__no_clients_specified' => "顧客アカウントが指定されていません",
    '__no_comments' => "コメントがありません",
    '__nologin' => "Forbidden（アクセス不可）",
    '__none' => "なし",
    '__not_configured' => "未構成",
    '__not_implemented_yet' => "実装されていません",
    '__not_supported_by_ftp' => "（FTP サーバでサポートされていません）",
    '__notification' => "通知",
    '__num_displayed' => "%2 のうち %1 表示",
    '__num_is_invalid' => "数値が正しくありません",
    '__object_not_found' => 'オブジェクトが見つかりません。%1',
    '__of_all' => "全体に占める割合（%）",
    '__off' => "オフ",
    '__ok' => "OK",
    '__old_passwd' => "古い%1パスワード",
    '__on' => "オン",
    '__others' => "その他",
    '__other_ip__will_be_added' => 'その他の使用可能な IP アドレス（顧客の IP プールに追加されます）',
    '__out' => "Out",
    '__p' => "P",
    '__passwd' => "%1パスワード",
    '__passwd_is_invalid' => "%1パスワードが正しくありません",
    '__passwd_not_match' => "パスワードが一致しません",
    '__path' => "パス",
    '__perl_unix_support' => "Perl サポート",
    '__perl_win_support' => "Perl サポート",
    '__perm_denied' => "パーミッション拒否",
    '__permissions' => "パーミッション",
    '__personal_name' => "個人名",
    '__pg_admin_not_activated' => "サーバ管理セクションで PostgreSQL がアクティブ化されていません。",
    '__pg_not_inst' => "PostgreSQL がインストールされていません",
    '__pg_not_run_or_inst' => "PostgreSQL がインストールされていないか、起動していません",
    '__pg_not_support_in_key' => "ライセンスキーにて PostgreSQL がサポートされていません",
    '__phone' => "電話",
    '__phosting' => "物理ホスティング",
    '__php_support' => "PHP サポート",
    '__php_run_as_isapi' => "ISAPI エクステンションとして実行",
    '__php_safe_mode' => "PHP safe_mode を有効化",
    '__php_version' => "PHP バージョン",
    '__physical' => "物理ホスティング",
    '__plesk_stat_pdir' => "保護ディレクトリ「/plesk-stat/webstat/」",
    '__plesk_stat_dir_name' => "ドメイン統計",
    '__plesk_stat_protect' => "ユーザの FTP ユーザ名とパスワードでウェブ統計へのアクセスを保護する",
    '__plesk_stat_protect_install' => "パスワード保護されたディレクトリ「/plesk-stat/webstat/」からアクセス可能",
    '__pop3_imap' => "POP3/IMAP", // indirect
    '__pop3_status' => "POP3 サーバの状態",
    '__popen_error' => "popen 関数を読み出す際エラーが発生しました",
    '__port' => 'ポート',
    '__postgres' => "PostgreSQL",
    '__postgresql' => "PostgreSQL",
    '__postgresql_status' => "PostgreSQL の状態",
    '__preferences' => "設定",
    '__account_preferences' => "アカウント設定",
    '__interface_preferences_general' => '全般',
    '__interface_preferences_default' => 'デフォルトのインターフェース設定',
    '__interface_preferences_admin' => "管理者インターフェースのプリファレンス",
    '__interface_template' => 'インターフェースカスタマイズテンプレート',
    '__interface_preferences' => "インターフェース設定",
    '__proceed?' => "このまま続行しますか？",
    '__protect_dir_user' => "保護ディレクトリユーザ",
    '__protect_dir_users' => "保護ディレクトリユーザ",
    '__protect_dirs' => "保護ディレクトリ",
    '__provider_contact_name' => "所有者の担当者名",
    '__python_unix_support' => "Python サポート",
    '__python_win_support' => "Python サポート",
    '__quota' => "クォータ",
    '__r' => "R",
    '__reconfigure' => "再構成",
    '__record_type' => "レコードタイプ",
    '__release' => "リリース",
    '__remote_db_not_supported_by_key' => 'リモートデータベースホスティングはライセンスキーにおいてサポートされていません',
    '__remove' => "削除",
    '__remove_confirmation' => "確認して削除を実行",
    '__remove_protection' => '保護を解除',
    '__report' => "レポート",
    '__report_auto' => '配信スケジュール',
    '__report_form' => "レポートフォーム",
    '__report_size_na' => "サービスは利用できません",
    '__reports_list' => "レポート",
    '__requested' => "要求済み",
    '__required_fields' => "必須フィールド",
    '__resp_name_invalid' => "自動返信名が無効です。 アルファベット、ドット（.）、下線（_）、および半角スペース（ ）のみ使用できます。",
    '__c' => "A", // Access to panel
    '__s' => "S",
    '__server_name_is_invalid' => "サーバ名は無効です",
    '__screenshots' => 'スクリーンショット',
    '__script_warning' => "このドメインからスクリプティング機能を削除すると、ドメイン上のすべての関連スクリプトは、ブラウザでテキスト形式で表示されるようになります。管理者は当該ドメインからスクリプトを削除しておくことをお勧めします。",
    '__sec' => "秒",
    '__second(s)' => "秒",
    '__see_list_of_logged_in' => "現在ログインしているユーザの一覧を表示する",
    '__select_certs_to_remove' => "削除する証明書の選択",
    '__select_domains_to_default_host' => "デフォルトとして選択するドメインを選択してください。",
    '__select_files_to_remove' => "削除するファイルの選択",
    '__select_ip' => "IP アドレスの割り当て",
    '__select_ip_to_remove' => "削除するIP アドレスの選択",
    '__select_domain_template' => "ドメインテンプレート設定を使用",
    '__select_templates_to_remove' => "削除するテンプレートの選択",
    '__server' => "サーバ",
    '__server_total' => "サーバトータル",
    '__service' => "サービス",
    '__service_title__plesk' => "Plesk",
    '__service_description__plesk' => "Plesk",
    '__service_title__mysql' => "MySQL データベースサーバ",
    '__service_description__mysql' => "MySQL データベースサーバ",
    '__service_title__web' => "ウェブサーバ",
    '__service_description__web' => "ウェブサーバ",
    '__service_title__smtp' => "SMTP サーバ",
    '__service_description__smtp' => "SMTP サーバ",
    '__service_title__mail' => "IMAP/POP3 サーバ",
    '__service_description__mail' => "IMAP/POP3 サーバ",
    '__service_title__dns' => "DNS サーバ",
    '__service_description__dns' => "DNS サーバ",
    '__service_title__postgresq' => "PostgreSQL データベースサーバ",
    '__service_description__postgresq' => "PostgreSQL データベースサーバ",
    '__service_title__spamassassin' => "SpamAssassin スパムフィルタリングサービス",
    '__service_description__spamassassin' => "SpamAssassin スパムフィルタリングサービス",
    '__services' => "サービス",
    '__all_services' => "すべてのサービス",
    '__sessions' => "セッション",
    'sessions__feature_ftp_session_manager_not_supported' => "現在の FTP サーバは FTP セッション機能をサポートしていません",
    '__sessions_list' => "セッション",
    '__set' => "オンにする",
    '__shared' => "共有",
    '__shell_access_warning' => "システムへのアクセスを許可することは、システムのセキュリティ上、とても危険です。その危険性を理解しており、信頼できるユーザにのみアクセスを許可してください。アクセスを許可しますか？",
    '__siteapp_not_support_in_key' => "ウェブアプリケーションはライセンスキーにおいてサポートされていません",
    '__siteapp_cannot_reconfigure_with_remote_database' => 'このウェブアプリケーションの構成が手動で変更されました。手動での変更を保護するために、Plesk での再構成は無効になっています。',
    '__site_management' => "Web 発行", // indirect
    '__size' => "サイズ",
    '__skeleton' => '仮想ホストテンプレート',
    '__skins' => 'スキン',
    '__smtp' => "SMTP", // indirect
    '__smtp_status' => "SMTP サーバの状態",
    '__some_fields_are_empty_or_invalid' => "いくつかのフィールドが空であるか、無効な値が指定されています。",
    '__unable_to_set_parameters' => "コンポーネントのパラメータを設定できません",
    '__spamassassin' => "スパムフィルタ",
    '__spamassassin_status' => "SpamAssassin ステータス",
    '__spamd_status' => 'スパムフィルタのステータス',
    '__splited_backup' => "（マルチボリュームバックアップ）",
    '__split_backup_file' => "マルチボリュームバックアップを作成する",
    '__split_backup_size' => "ボリュームサイズ",
    '__split_backup_less_than_500' => "500MB 未満のボリュームサイズはサポートされていません",
    '__ssi' => "SSI",
    '__ssi_support' => "SSI サポート",
    '__ssi_with_html' => "*.htm と *.html ファイルに SSI を使用",
    '__ssl' => 'SSL/TLS',
    '__ssl_support' => "SSL/TLS サポート",
    '__same_ssl' => "SSL/TLS コンテンツと非 SSL/TLS コンテンツの保存に単一のディレクトリを使用",
    '__same_ssl_cu' => "共通の SSL/TLS および非 SSL/TLS コンテンツ",
    '__state' => "都道府県",

    '__status__Active' => 'アクティブ',
    '__status__active' => 'アクティブ',
    '__status__Passive' => 'オフ',
    '__status__passive' => 'オフ',
    '__status__off' => 'オフ',
    '__status__with_parent' => 'オフ',
    '__status__backup_restore' => '一時的に停止されたバックアップまたは復元',
    '__status__admin' => 'サーバ管理者により一時停止',
    '__status__resseler' => 'リセラーにより一時停止',
    '__status__client' => '顧客により一時停止',
    '__status__unknown' => 'ステータスが不明です',

    '__status_of' => "%1の状態",
    // end of akss part

    // shramko part

    '__stunnel' => "Stunnel",
    '__stunnel_server' => "Stunnel サーバ", // indirect
    '__subdomain' => "サブドメイン",
    '__subdomain_name' => "サブドメイン名",
    '__subdomain_name_in_ASCII_form' => "サブドメイン名（ASCII フォーマット）",
    '__subdomains' => "サブドメイン",
    '__domainaliases' => "ドメインエイリアス",
    '__subdomains_list' => "サブドメイン",
    '__subdomains_not_support_in_key' => "サブドメイン操作が、ライセンスキーにてサポートされていません",
    '__sys_user_type' => "FTP ユーザ",
    '__sys_user_type_main' => "メインドメインの FTP ユーザアカウントを使用",
    '__sys_user_type_native' => "このサブドメイン用に異なる FTP ユーザを作成する",
    '__t' => "T",
    '__target_domain' => "ターゲットドメイン",
    '__template' => "テンプレート",
    '__template_not_accepted' => "テンプレートを適用できません。以下の制限を超過しています。",
    '__templates' => "テンプレート",
    '__templates_list' => "テンプレート",
    '__tera' => "T",
    '__title' => "タイトル",
    '__tools' => "ツール",
    '__total' => "トータル%1",
    '__total_size' => "トータルサイズ",
    '__total_used' => "総使用",
    '__traffic' => "トラフィック",
    '__traffic_by_client' => "顧客ごとのトラフィック",
    '__traffic_by_domain' => "ドメインごとのトラフィック",
    '__traffic_by_service' => "サービスのトラフィック",
    '__traffic_history' => "トラフィック履歴",
    '__unable_change_locale' => "インターフェース言語を変更できません。%1",
    '__unable_create_new_dom' => "ドメイン %1 を作成できません",
    '__unable_define_dom_name' => "ドメイン名を定義することができません。%1",
    '__unable_define_necessary_properties' => "必要なプロパティを定義することができません",
    '__unable_define_properties' => "プロパティを定義することができません。%1",
    '__unable_exec_util' => "ユーティリティを実行することができません%1",
    '__unable_get_dns_a_recs' => "このホスティングアカウント用の DNS A レコードについて、IP アドレスを取得できません。%1",
    '__unable_get_mbox_quota' => "メールボックスサイズ制限の情報を取得できません",
    '__unable_redirect_to_myself' => "同じアカウントへは転送できません",
    '__unable_redirect_to_my_alias' => "メールエイリアスにメールを転送することはできません",
    '__default_domain_redirect_to_myself' => "ドメインを IP アドレスにおいてデフォルト指定できません。\n 自身へのリダイレクトを検出しました",
    '__unable_remove_client' => "顧客を削除できません。 %1",
    '__unable_set_up_mbox_quota' => "メールボックスクォータを設定することができません。%1",
    '__unable_setup_pass' => "パスワードを設定することができません%1",
    '__unable_to_create_new_account' => "アカウント %1 を作成できません",
    '__unable_to_define_db_size' => "データベースサイズを定義できません",
    '__unable_to_enable_short_names' => "POP3/IMAP アカウントにおける短いメールアカウントの使用を許可できません",
    '__unable_to_fetch_data_from_submit' => "送信データをフェッチすることができません。：%1",
    '__unable_to_open_file' => "ファイル %1 を開くことができません。%2",
    '__unable_to_update_subdomain' => "サブドメインに変更を適用することができません。%1",
    '__unable_update_cl_data' => "ユーザアカウントへの変更を保存できません。%1",
    '__unable_update_db_params' => "データベースパラメータを更新することができません。%1",
    '__unable_update_dom_data' => "ドメイン情報を更新することができません。%1",
    '__undefined' => "未定義",
    '__uninstall' => "アンインストール",
    '__unknown_error' => "未知のエラー",
    '__unlimited_lower' => "無制限",
    '__unset' => "オフにする",
    '__update' => "更新",
    '__uploaded_file_is_invalid' => "アップロードしたファイルが不正です。%1",
    '__url' => "URL",
    '__usage' => "ディスク使用量",
    '__user' => 'ユーザ',
    '__user_already_logged' => "別のユーザが同じユーザ名（%1）で Plesk にログインしています。",
    '__version' => "バージョン",
    '__aps_license' => "ライセンスキー",
    '__vh_type' => "仮想ホストタイプ",
    '__vhosts_apache_status' => "ウェブサーバのステータス",
    '__wrong_charset_conversion' => '誤った文字コードです。「%1」から「%2」への変換は行うことができません',
    '__warning_' => "警告：",
    '__warning_excl_ip_num' => "専用 IP アドレス",
    '__warning_expiration' => "有効期限",
    '__web_scripting' => "ウェブスクリプティング", // indirect
    '__web_serv' => "ウェブサーバ", // indirect
    '__web_statistic' => "ウェブ統計", // indirect
    '__webmail' => "ウェブメール", // +indirect
    '__webstat_not_installed' => "Webalizer はサーバにインストールされていません。 Webalizer のインストールについて、サービスプロバイダまでお問い合わせください。",
    '__webstat_support' => "ウェブ統計",
    '__webstat_awstats_support' => "AWstats",
    '__webstat_webalizer_support' => "Webalizer",
    '__webstat_awstats' => "AWstats",
    '__webstat_webalizer' => "Webalizer",
    '__webstat_type_change_warning' => "統計プログラムを切り替えた場合、前に使用していた統計プログラムで作成したレポートはすべて削除されます。ログファイルから読み取った情報に従い、新しいレポートが作成され、サーバに保存されます。 つまり、1 ヶ月間しかログファイルを保存しないようにシステムを構成すると（［ドメイン］ > ［ドメイン名］ > ［ログマネージャ］ > ［ログローテーション］）、最近 1 ヶ月分のウェブ統計しか有効でありません。 他の統計パッケージに変更しますか？",
    '__webstat_perm_denied' => 'ウェブ統計を管理するパーミッションがありません',
    '__webuser' => "ウェブユーザ",
    '__sysusers_list' => "システムユーザ",
    '__sysuser' => "システムユーザ",
    '__weekly' => "毎週",
    '__whats_new_in_version' => "Plesk %1 の新機能",
    '__wrong_hosting_type__virtual_required' => "この操作は、ウェブホスティング付きのドメインでのみ実行できます。",
    '__wrong_hosting_type__none' => 'ドメイン %1 にはウェブホスティングが設定されていません。',
    '__wrong_hosting_type__std_fwd' => 'ドメイン %1 には標準転送が設定されています。 この操作は、ウェブホスティングされたドメインのみ使用可能です。',
    '__wrong_hosting_type__frm_fwd' => 'ドメイン %1 にはフレーム転送が設定されています。 この操作は、ウェブホスティングされたドメインのみ使用可能です。',
    '__wu' => "ウェブユーザ",
    '__www' => "WWW",
    '__www_prefix_was_changed' => "WWW プレフィックスが変更されました。SSL/TLS 証明書も必ず変更してください。",
    '__year' => "年",
    '__year(s)' => "年",
    '__yes' => "はい",
    '__you' => "あなた",
    '__zip_code' => "郵便番号",
    '__form_normal' => "中",
    '__form_advanced' => "詳細",

    'admin_ed__edit_administrator_info' => "管理者プロファイルの編集",
    'admin_ed__create_default_client' => "デフォルト顧客アカウントを作成します。",
    'admin_ed__unable_update' => "管理者情報を更新できません。%1",

    'auth__update_admin_info' => "管理者情報を入力してください。%1 を操作するためにこれらの情報が必要です。",
    'auth__you_not_have_perm' => "当該ドメインを管理するパーミッションがありません",
    'auth__key_expired_admin' => 'Plesk ライセンスの期限が切れました。Plesk を使い続ける場合、ライセンスを更新するか新規購入してください。',
    'auth__key_expired_admin_restricted' => 'Plesk ライセンスの期限が切れました。Plesk を使い続ける場合、サービスプロバイダまでお問い合わせください。',
    'auth__key_expired_client' => 'Plesk ライセンスの期限が切れました。ホスティング事業者までお問い合わせください。',
    'autoinstaller__not_installed' => '自動インストーラコンポーネントがインストールされていません',
    'autoinstaller__release_action' => '利用できるオペレーション',
    'autoinstaller__release_action_icon' => 'S',
    'autoinstaller__release_action_upgrade' => 'Plesk を新バージョンにアップグレードします。',
    'autoinstaller__release_action_update' => '新しいコンポーネントの追加またはアップデート',
    'autoinstaller__release_action_up2date' => '最新バージョンです',
    'autoinstaller__component_action' => 'ステータス',
    'autoinstaller__component_action_icon' => 'S',
    'autoinstaller__component_action_install' => '未インストール',
    'autoinstaller__component_action_update' => 'アップデートが提供されています',
    'autoinstaller__component_action_upgrade' => 'アップデートが利用できます。',
    'autoinstaller__component_action_up2date' => '最新バージョンです',
    'autoinstaller__component_action_error' => '利用可能なアップデートがありません',
    'autoinstaller__component_serverbuildtime' => '最新のリリース',
    'autoinstaller__component_localbuildtime' => 'あなたのリリース',
    'autoinstaller__component_installed_version' => '現在のバージョン',
    'autoinstaller__component_available_version' => '最新バージョン',
    'autoinstaller__component' => 'コンポーネント',
    'autoinstaller__components' => 'コンポーネント',
    'autoinstaller__components_title' => '%1 コンポーネント',
    'autoinstaller__component_dependency_note' => '選択したコンポーネントをインストールするために必要です',
    'autoinstaller__install_confirm' => 'これらのコンポーネントをインストールする',
    'autoinstaller__install_confirm_request' => '確認のためチェックボックスを選択してください',
    'autoinstaller__install_title' => '選択したコンポーネントのインストレーションを確認してください',
    'autoinstaller__key_update_confirm' => 'キーアップデートのスキップおよび標準キーインストールを確認します。',
    'autoinstaller__key_update_confirm_request' => '確認のためチェックボックスを選択してください',
    'autoinstaller__key_update_failed' => '<p> Plesk が製品ライセンスを更新できません。</p> <p> %1</p> <p> 適切な製品ライセンスなしにアップグレードを続けると、機能制限付きでデフォルトライセンスがインストールされます。管理者は、製品のアップグレードを続ける前に、適切なライセンスキーを入手することが推奨されます。</p>',
    'autoinstaller__email' => '通知の送信先',
    'autoinstaller__email_admin' => "管理者のメールアドレス",
    'autoinstaller__email_email' => 'カスタムメールアドレス...',
    'autoinstaller__release' => 'リリース名',
    'autoinstaller__releases' => '利用できるリリース',
    'autoinstaller__releases_title' => 'Plesk アップデータ',
    'autoinstaller__select_components_to_install' => 'インストールするコンポーネントを選択してください',
    'autoinstaller__status_error' => 'エラー：%1',
    'autoinstaller__status_install_error' => 'インストールを開始できません。%1',
    'autoinstaller__status_install_busy' => 'インストールを開始することができません。他のインストールが現在進行中です',
    'autoinstaller__status_install_ok' => 'インストールが開始されました。インストールの進行状況はメールでお知らせします（%1）。',
    'autoinstaller__status_query_busy' => 'インストール中です。',
    'autoinstaller__status_query_error' => 'インストレーションの情報を取得できませんでした。%1',
    'autoinstaller__status_unknown' => '自動インストーラの状態を取得できません',
    'autoinstaller__status_busy' => '自動インストーラが実行中です。しばらくお待ちください',
    'autoinstaller__configure_title' => 'アップデータの設定',
    'autoinstaller__preferences_legend' => '設定',
    'autoinstaller__target' => '一時ダウンロードディレクトリ',
    'autoinstaller__target_invalid' => "絶対パスを指定します。",
    'autoinstaller__check_updates' => '管理者が Plesk にログインしたときにアップデートを確認する',
    'autoinstaller__check_updates_warning' => '%2 の<a href="%1">アップデート</a>が利用可能です',
    'autoinstaller__source_type' => 'ソースタイプ',
    'autoinstaller__source' => 'ソース URL',
    'autoinstaller_source__preferences_legend' => '設定',
    'autoinstaller_source__type' => 'ソースタイプ',
    'autoinstaller_source__url_invalid' => '無効なソース',
    'autoinstaller_source__url_invalid_network' => '無効なソース URL（例：http://source、ftp://source）',
    'autoinstaller_source__url' => 'ソース URL',
    'autoinstaller__source_invalid_network' => '無効なネットワークアドレスを指定しています。',
    'backup__repository' => 'バックアップファイルの保存場所',
    'backup__error_notify_email' => 'バックアップ中にエラーが発生した場合、メールで通知',
    'backup__dump_info' => "ダンプ情報",
    'backup__dump_file_name_not_defined' => "ダンプするファイル名が定義されていません",
    'backup__local_file' => 'ローカルバックアップファイル',
    'backup__domain_ftp' => 'リモートFTP サーバ',
    'backup__wrong_path' => "バックアップファイルストレージへのパスが正しくありません。../../ という文字列を使用しないでください",
    'backup__unable_to_connect_to_ftp_server' => "FTP サーバ（%1）に接続できません",
    'backup__unable_to_read_file' => 'バックアップファイルを読み込めません',
    'backup__backup_task_does_not_exist' => "バックアップタスクが存在しません。バックアップタスクは実行する前に作成しておく必要があります。",
    'backup__restore_params' => "復元パラメータ",
    'backup__confirmation' => "警告：バックアップ/復元中、ドメインは使用できません。",
    'backup__backup_method' => 'バックアップメソッド',
    'backup__dumpfile_name' => "バックアップファイル名",
    'backup__dumpfile_name_is_invalid' => "バックアップファイル名が無効です。英数字、ダッシュ、ドット、アンダースコアのみを使用できます。 「description.*」のようなバックアップファイル名は使用しないでください。",
    'backup__email_required' => "バックアップ/復元の進行状況の通知にはメールアドレスが必要です。アカウント詳細にメールアドレスを入力してください。",
    'backup__error_during_backup' => "バックアップファイルを作成することができません。%1",
    'backup__input_email_warning' => "通知メールアドレスを指定するか、チェックボックスをクリアする必要があります。",
    'backup__make_download' => "ダウンロードのみ実行し、ストレージにバックアップファイルを保存しない",
    'backup__make_dump' => 'バックアップファイルを作成してローカルストレージに保存する',
    'backup__makedump_to_ftp' => 'バックアップファイルを作成してリモート FTP サーバに保存する',
    'backup__restore_ip' => "復元用 IP アドレス",
    'backup__select_dumpfile' => "バックアップファイルの選択",
    'backup__time' => "バックアップ時間",
    'backup__day' => 'バックアップ日',
    'backup__view_dump_info' => "ドメイン %1 のバックアップ情報を閲覧します。",
    'backup__wrong_domain_name' => "バックアップファイルにはドメイン %1 のデータが含まれているため、ドメイン %2 上に復元できません",
    'backup__incorrect_ftp_user_or_passwd' => "無効なFTP ユーザまたはパスワードです。FTP アカウントプロパティを確認してください",
    'backup__access_denied' => "アクセス拒否されました。FTP アカウントプロパティを確認してください",
    'backup__restore_from' => "%1 の復元",
    'backup__domain_session_failed' => 'ドメイン %1 はバックアップされていません',
    'backup__client_session_failed' => '顧客 %1 はバックアップされていません',
    'backup__domain_session_restore_failed' => 'ドメイン %1 は復元されませんでした',
    'backup__client_session_restore_failed' => '顧客アカウント %1 は復元されていません',
    'backup__domain_session_complete' => 'ドメイン %1 はバックアップされました',
    'backup__domain_session_backup' => 'ドメイン %1 のバックアップ',
    'backup__client_session_backup' => '顧客 %1 のバックアップ',
    'backup__domain_stop_title' => 'ドメイン %1 のバックアップをキャンセル',
    'backup__client_stop_title' => '顧客アカウント %1 のバックアップのキャンセル',
    'backup__domain_restore_stop_title' => 'ドメイン %1 の復元のキャンセル',
    'backup__client_restore_stop_title' => '顧客アカウント %1 の復元をキャンセルする',
    'backup__domain_session_backup_stop' => '進行中のバックアップ処理を一時停止しようとしています。 バックアップファイルは作成されません。',
    'backup__backup_stop_confirm' => 'はい、バックアッププロセスを停止してください',
    'backup__restore_stop_confirm' => 'はい、復元処理を停止します。',
    'backup__domain_session_restore' => 'ドメイン %1 の復元',
    'backup__domain_session_restore_stop' => '進行中の復元処理を一時停止しようとしています。',
    'backup__domain_backup_file_info' => 'ドメインバックアップファイル情報',
    'backup__domain_backup_file_list' => '存在するバックアップファイル',
    'backup__domain_backup_progress' => 'ウェブサイト %1 のバックアップの進行状況',
    'backup__domain_restore_progress' => 'ウェブサイト %1 の復元の進行状況',
    'backup__domain_backup_progress_elapsed_time' => '経過時間： %1',
    'backup__domain_restore_progress_elapsed_time' => '経過時間： %1',
    'backup__ip_map_legend' => 'IP マッピング',
    'backup__ip_map_list_count' => 'IP アドレス',
    'backup__domain_restore_session_complete' => 'ドメイン %1 が復元されました。',
    'backup__domain_restore_session_complete_message' => 'ドメイン %1 が復元されました。',
    'backup__domain_backup_file_delete' => '以下のバックアップファイルが削除されます。',
    'backup__domain_backup_file_for_remove' => '削除するバックアップファイルを選択',
    'backup__backup_overwrite_file_confirm' => '置き換えの確認',
    'backup__backup_overwrite_file_confirm_text' => '名前が %1 のバックアップファイルは既に存在します。置換しますか？',
    'backup__backup_confirm_overwrite' => 'ファイル置き換えを確認',
    'backup__backup_overwrite_legeng' => '置き換え',
    'backup__backup_not_contain_domain' => 'バックアップファイルにはドメイン %1 の情報が含まれていません',
    'backup__backup_not_contain_client' => 'バックアップファイルに顧客アカウント %1 の情報が含まれていません',
    'backup__backup_client_info' => "顧客の設定とアカウント詳細のバックアップを作成します。",
    'backup__client_backup_progress' => '顧客アカウント %1 のバックアップの進行状況',
    'backup__client_session_complete' => '顧客アカウント %1 のバックアップが作成されました',
    'backup__client_backup_file_info' => '顧客バックアップファイル情報',
    'backup__restore_client_info' => "顧客の設定とアカウント詳細を復元します。",
    'backup__client_session_restore' => '顧客アカウント %1 を復元します。',
    'backup__client_db_server_map' => 'データベースサーバマッピング',
    'backup__domain_db_server_map' => 'データベースサーバマッピング',
    'backup__client_restore_session_complete_message' => '顧客アカウント %1 を復元しました。',
    'backup__client_restore_session_complete' => '顧客アカウント %1 を復元しました。',
    'backup__restore_select_some' => '復元するオブジェクトを選択してください',
    'backup__client_restore_progress' => '顧客アカウント %1 の復元の進行状況',
    'backup__new_backup' => '新しいバックアップを作成',
    'backup__done' => '実行済み:',
    'backup__done_domains' => 'ドメイン %1/%2',
    'backup__done_clients' => '顧客 %1/%2',
    'backup__remaining' => '残り:',
    'backup__remaining_domains' => '%1 ドメイン',
    'backup__remaining_clients' => '%1 顧客',
    'backup__overall_backup_progress' => '全体的なバックアップ進行度',
    'backup__comment_n_a' => 'なし',
    'backup__command_ignore' => 'コマンド %1  は拒否されました',
    'backup__no_objects' => 'バックアップ用のオブジェクトが存在しません',
    'backup__cli_warning_not_enough_ip' => '警告：デフォルト IP マッピングに十分な IP アドレスがありません',
    'backup__local_repository' => "Plesk のストレージ",
    'backup__ftp_repository' => 'FTP ストレージ',
    'backup__ftp_login' => 'ユーザ名',
    'backup__ftp_password' => 'パスワード',
    'backup__ftp_directory_hint' => '例: /myfolder/mybackups',
    'backup__ftp_account_settings' => 'FTP アカウント設定',
    'backup__ftp_account_preferences' => 'FTP アカウント設定',
    'backup__repository_not_exist' => 'ディレクトリが存在しません',
    'backup__repository_not_readable' => '指定されたディレクトリを読み込めません',
    'backup__ftp_repository_not_configure' => 'FTP バックアップストレージを使用するには、まず<a href="%1">FTP アカウントを指定します</a>。',
    'backup__ftp_repository_list_not_configure' => 'アカウント設定が指定されていません',
    'backup__repository_list_unable_listing' => 'ファイルの一覧を取得できません',
    'backup__ftp_repository_unable_listing' => 'ディレクトリ「%1」の一覧を取得できません。',
    'backup__repository_legend' => 'バックアップファイルストレージ',
    'backup__store_in_repository' => 'ファイルの保存先',
    'backup__local_repository_lable' => 'ローカルストレージ',
    'backup__ftp_repository_lable' => 'FTP ストレージ',
    'backup__ftp_repository_not_configure_hint' => '（アカウント設定が指定されていません）',
    'backup__ftp_repository_not_configure_or_forbidden_hint' => '（FTP アカウントが指定されていないか、サポートされていません）',
    'backup__ftp_directory_not_exist' => '指定したディレクトリが存在しません',
    'backup__other_user_process_modified' => '他のユーザがバックアップまたは移行プロセスを停止しました',
    'backup__another_user_exist' => '実行中の操作は、別の Plesk ユーザが開始したものです。このユーザはまだ Plesk にログインしています。',
    'backup__ftp_repository_wait' => 'FTP ストレージについて情報を取得するまでお待ちください。',
    'backup__ftp_write_test_failed' => 'FTP アカウント %1 へのデータ書き込みテストに失敗しました。',
    'bt_upload_to_repository' => 'ファイルをローカルストレージにアップロード',
    'bt_new_restore' => "復元",
    'bt_backup_schedule' => "計画済みバックアップ",
    'backup_exist_backups' => "存在するバックアップファイル",
    'backup_dialog__page_title' => "バックアップファイル作成",
    'backup_dialog__please_wait' => "バックアッププロセスが開始されます。この処理には時間がかかります。しばらくお待ちください...",
    'backup_conf__page_title' => 'バックアップ構成',
    'bt_accept' => "同意する",
    'bt_access' => "アクセス",
    'bt_action_log' => "アクションログ",
    'bt_add' => "追加",
    'bt_add_client' => "ユーザに割り当てる",
    'bt_database_server_add' => 'データベースサーバ追加',
    'bt_add_services' => "サービス追加",
    'bt_anonftp_stats' => "匿名 FTP 統計",
    'bt_anonymous_ftp' => "匿名 FTP",
    'bt_aspdotnet' => "ASP.NET",
    'bt_attach' => "添付",
    'bt_autoinstaller' => 'アップデータ',
    'bt_auto-updates' => 'アップデータ',
    'bt_back' => "<<戻る",
    'bt_backup' => "バックアップ",
    'bt_backup_configure' => "バックアップ設定",
    'bt_buy_certs' => "証明書を購入",
    'bt_card' => "カード",
    'bt_cert' => "証明書",
    'bt_certificates' => "証明書",
    'bt_change_passwd' => "パスワード変更",
    'bt_clear' => "クリア",
    'bt_client_templates' => "顧客テンプレート",
    'bt_clients' => "顧客",
    'bt_codepage_change' => 'エンコーディングを変更する',
    'bt_comp_info' => "コンポーネント管理",
    'bt_configure_maillists' => "Mailman 設定",
    'bt_configure' => '構成',
    'bt_copy' => "コピー",
    'bt_copy_move' => "コピー/移動",
    'bt_create' => "作成",
    'bt_create_account' => "アカウントを作成",
    'bt_create_dir' => "ディレクトリを追加",
    'bt_create_file' => "ファイルを追加",
    'bt_count_size' => "サイズ計算",
    'bt_crontab_unix' => "Crontab",
    'bt_crontab_win' => "タスクスケジューラ",
    'bt_custom_button_new' => "ボタンを追加",
    'bt_custom_buttons' => "カスタムボタン",
    'bt_customize' => "カスタマイズ",
    'bt_databases' => "データベース",
    'bt_database_servers' => 'データベースサーバ',
    'bt_sqlservers' => "データベースサーバ",
    'bt_db_usr_new' => "データベースユーザを追加",
    'bt_db_new' => "データベースを追加",
    'bt_db_phpmyadmin' => "MySQL アドミン",
    'bt_dbuser_default' => "DB Webadmin のデフォルトに指定する",
    'bt_decline' => "同意しない",
    'bt_default' => "デフォルト",
    'bt_defaultcomponents' => "サードパーティーサービス",
    'bt_defaults' => "デフォルト",
    'bt_delete' => "削除",
    'bt_directories' => "保護ディレクトリ",
    'bt_disable' => "オフにする",
    'bt_dns_zone_sync' => 'DNS テンプレートの変更を適用',
    'bt_dnsrecord_add' => 'レコードを追加',
    'bt_do_backup' => "バックアップ",
    'bt_do_restore' => "復元",
    'bt_do_upload' => "アップロード",
    'bt_domain_aliases' => "ドメインエイリアス",
    'bt_domain_templates' => "ドメインテンプレート",
    'bt_domain_user' => "ドメイン管理者",
    'bt_domain_user_passwd' => "ドメイン管理者パスワード",
    'bt_domains' => "ドメイン",
    'bt_domain_alias_add' => 'ドメインエイリアスを追加',
    'bt_download' => "ダウンロード",
    'bt_edit' => "編集",
    'bt_enable' => "オンにする",
    'bt_export' => 'エクスポート',
    'bt_extras' => "その他",
    'bt_finish' => "完了",
    'bt_ftp_account' => "FTPアカウントのプロパティ",
    'bt_forget_password' => "パスワードを忘れた場合",
    'bt_fp_ssl_webadmin' => "FP-SSL/TLS Webadmin",
    'bt_fp_webadmin' => "FP Webadmin",
    'bt_ftp_stats' => "FTP 統計",
    'bt_get_password' => "パスワード入手",
    'bt_global_changes' => "編集",
    'bt_help' => "ヘルプ",
    'bt_hide_aliases' => "エイリアスを隠す",
    'bt_hide_toolbar' => 'ツールバーを隠す',
    'bt_hide_subdomains' => "サブドメインを隠す",
    'bt_hide_domainaliases' => "ドメインエイリアスを隠す",
    'bt_home' => "ホーム",
    'bt_hosting' => "ホスティング",
    'bt_icf' => 'ファイアウォール',
    'bt_install' => "インストール",
    'bt_ip_aliasing' => "IP アドレス",
    'bt_ip_add' => "IP アドレスを追加",
    'bt_ip_pool' => "IP プール",
    'bt_key_info' => "ライセンス情報",
    'bt_key_buyonline_addons' => 'Plesk アドオンを注文します。',
    'bt_key_buyonline_upgrades' => 'Plesk アップグレードを注文する',
    'bt_key_buyonline_new' => '新規キーを注文',
    'bt_limits' => "上限",
    'bt_locale_add' => 'ロケールを追加',
    'bt_locales' => 'ロケール',
    'bt_log_manager' => "ログマネージャ",
    'bt_login' => "ログイン",
    'bt_logo' => "ブランディング",
    'bt_logo_send_link' => "リンク",
    'bt_logo_send_logo' => "ロゴ添付",
    'bt_logout' => "ログアウト",
    'bt_logrotation' => "ログローテーション",
    'bt_mail' => "メール",
    'bt_mail_alias_add' => "メールエイリアスを追加",
    'bt_mail_aliases' => "メールエイリアス",
    'bt_mail_group_add' => "メンバーを追加",
    'bt_mail_groups' => "グループ",
    'bt_mail_name_add' => "メールアカウントを追加",
    'bt_mail_preferences' => "設定",
    'bt_mail_group' => "メールグループ",
    'bt_mail_mailbox' => "メールボックス",
    'bt_mail_redirect' => "フォワーダ",
    'bt_mail_resp_add' => "自動応答を追加",
    'bt_mail_resp_attach_add' => "添付ファイルを追加",
    'bt_mail_resp_files' => "添付ファイル",
    'bt_mail_responders' => "自動応答",
    'bt_mail_spamfilter' => "スパムフィルタ",
    'bt_mail_webmail' => "ウェブメール",
    'bt_maillist_new' => "メーリングリストを追加",
    'bt_maillists' => "メーリングリスト",
    'bt_mailman' => "Mailman",
    'bt_make_dump' => "バックアップの作成",
    'bt_manage' => "管理",
    'bt_master' => "マスター",
    'bt_migrate' => '移行',
    'bt_modules_add' => '拡張を追加',
    'bt_modules_manage' => '拡張管理',
    'bt_move' => "移動",
    'bt_mimetypes' => 'MIME タイプ',
    'bt_mimetype_new' => 'MIME タイプを追加',
    'bt_new_client' => "顧客アカウントを追加",
    'bt_new_domain' => "ドメインを追加",
    'bt_next' => "次へ >>",
    'bt_next_page' => "次へ",
    'bt_network_add' => "ネットワークを追加",
    'bt_notifications' => "通知",
    'bt_off' => "オフ",
    'bt_on' => "オン",
    'bt_on_off' => "オン/オフ",
    'bt_pd_new' => "保護ディレクトリを追加",
    'bt_pd_user_new' => "ユーザを追加する",
    'bt_performance' => 'パフォーマンス',
    'bt_permissions' => "パーミッション",
    'bt_phpmyadmin' => "PhpMyAdmin",
    'bt_postgre_sql' => "PostgreSQL",
    'bt_preferences' => "設定",
    'bt_prev_page' => "前へ",
    'bt_preview' => 'サイトプレビュー',
    'bt_print' => "印刷",
    'bt_reboot' => "再起動",
    'bt_reload' => "再読み込み",
    'bt_refresh' => "更新",
    'bt_register' => "登録",
    'bt_remove' => "削除",
    'bt_enable_selected' => 'オンにする',
    'bt_disable_selected' => 'オフにする',
    'bt_repair_ip' => "IP 復元",
    'bt_report' => "レポート",
    'bt_report_auto' => 'レポート送信',
    'bt_report_auto_new' => '配信スケジュールを追加',
    'bt_report_new' => "レイアウトを追加",
    'bt_reset' => "リセット",
    'bt_restart_services' => "サービス管理",
    'bt_save' => "保存",
    'bt_send_by_email' => "メールで送信",
    'bt_send_file' => "ファイル送信",
    'bt_send_mail' => "メール送信",
    'bt_send_passwd' => "パスワード送信",
    'bt_send_text' => "テキスト送信",
    'bt_server' => "サーバ",
    'bt_server_add' => "サーバを追加",
    'bt_server_preferences' => "サーバ設定",
    'bt_servers_list' => "サーバ",
    'bt_sessions' => "セッション",
    'bt_set' => "設定",
    'bt_set_as_default' => "デフォルトとして選択",
    'bt_setup' => 'セットアップ',
    'bt_show_aliases' => "エイリアスを表示する",
    'bt_show_subdomains' => "サブドメインを表示する",
    'bt_show_domainaliases' => "ドメインエイリアスの表示",
    'bt_shutdown' => "シャットダウン",
    'bt_site_apppkgs' => "アプリケーションヴォルト",
    'bt_site_apppool' => "アプリケーションプール",
    'bt_application-pool' => "ウェブアプリケーション",
    'bt_site_apps' => "ウェブアプリケーション",
    'bt_site_app_add' => "アプリケーションのインストール",
    'bt_site_builder' => "Presence Builder サポート",
    'bt_skeleton' => '仮想ホストテンプレート',
    'bt_skins' => 'スキン',
    'bt_skin_add' => 'スキンを追加',
    'bt_skin_manual' => 'カスタム Plesk スキンの参考情報', // not used
    'bt_skin_download' => 'スキンをダウンロード',
    'bt_skin_replace' => 'スキンを更新',
    'bt_skip' => 'スキップ',
    'bt_spamassassin' => "スパムフィルタ",
    'bt_spamassassin_train' => "学習",
    'bt_spamfilter' => "スパムフィルタ",
    'bt_start' => "開始",
    'bt_stop' => "停止",
    'bt_recycle' => "リサイクル",
    'bt_statistics' => "統計",
    'bt_subdomain_new' => "サブドメインを追加",
    'bt_subdomains' => "サブドメイン",
    'bt_submit' => "送信",
    'bt_summary_report' => "概要レポート",
    'bt_support' => "サポート",
    'bt_switch' => "スイッチ",
    'bt_system_time' => "システム時間",
    'bt_task_new' => "タスクを追加",
    'bt_dom_tmpl_add' => 'ドメインテンプレートを追加',
    'bt_cl_tmpl_add' => '顧客テンプレートを追加',
    'bt_cron_backup' => 'スケジュール済みバックアップの設定',
    'bt_test' => "テスト接続",
    'bt_text' => "テキスト",
    'bt_touch' => "タイムスタンプを変更",
    'bt_traffic' => "トラフィック",
    'bt_traffic_history' => "転送量履歴",
    'bt_update' => "更新",
    'bt_upload' => "アップロード",
    'bt_upload_from_ftp' => "FTPによるアップロード",
    'bt_virtualdirs' => '仮想ディレクトリ',
    'bt_virtualdir_new' => '仮想ディレクトリを追加',
    'bt_virtualdir_add' => '仮想ディレクトリを追加',
    'bt_web_app_new' => "Java アプリケーションのインストール",
    'bt_web_stats' => "ウェブ統計",
    'bt_web_stats_ssl' => "ウェブ統計 SSL/TLS",
    'bt_web_user_add' => "ウェブユーザを追加",
    'bt_web_users' => "ウェブユーザ",
    'bt_webadmin' => "Webadmin",
    'bt_webalizer' => "Webalizer",
    'bt_whats_new_full' => "変更をすべて表示する",
    'cert_add__unable_set_ca_cert' => "CA 証明書をセットできません。%1",
    'cert_add__unable_set_cert' => "証明書をセットすることができません。%1",
    'cert_add__unable_set_private_key' => "秘密キーを設定できません。%1",
    'certificates_list__certificate_used_as_default' => "削除しようとしている証明書のいずれかが、デフォルト証明書として使用されています。",
    'certificates_list__certificates_assigned_on_ip' => "1 つまたは複数の証明書が IP アドレス/ドメインに割り当てられています。",
    'ch_pass__admin_pass' => "管理者パスワードの変更",
    'ch_pass__old_pass' => "旧パスワード",
    'ch_pass__pass_confirm' => "同意する",
    'ch_pass__unable_change_admin_pass' => "管理者のパスワードを変更できません：%1",
    'check_mail_cycle__aliases' => "メールループが検出されました。アドレス「%1」は、このメールアカウントのエイリアスに含まれています。",
    'check_mail_cycle__autoresponders' => "メールループが検出されました。 アドレス「%1」は、このメールアカウントの自動応答に含まれています。",
    'check_mail_cycle__mail_groups' => "メールループが検出されました。アドレス「%1」は、このメールアカウントのメールグループに含まれています。",
    'check_mail_cycle__mail_name' => "メールループが検出されました。アドレス「%1」は、このメールアカウントと同じです。",
    'check_mail_cycle__redirect' => "メールループが検出されました。 アドレス「%1」は、このメールアカウントのフォワーダと同じです。",
    'check_mail_dup__redirect' => "転送の重複が検出されました。 メールアドレス「%1」はこのメールアカウントの転送アドレスと一致しています。",
    'check_mail_dup__mail_groups' => "転送の重複が検出されました。 メールアドレス「%1」はこのメールアカウントのメールグループに含まれています。",
    'check_maillist_cycle__admin' => "メールループが検出されました。管理者メールアドレス「%1」は、メーリングリストのアドレスと同じです。",
    'check_maillist_cycle__member' => "メールループが検出されました。メールアドレス「%1」は、メーリングリストのアドレスと同じです。",
    'chk_js__enter_login_and_passwd' => "ユーザ名とパスワードを入力してください。",
    'chk_js__enter_login_name' => "ユーザ名を入力してください。",
    'chk_js__enter_passwd' => "パスワードの入力",

    // end of shramko part

    // serge part
    'cl_ed__edit_cl' => "%1のアカウント詳細",
    'cl_limits__cl' => "顧客 %1 の上限",
    'cl_logo__setup_logo_pref' => "顧客 %1 にロゴプロパティを設定します。",
    'cl_new__enter_new_cl_data' => "新しい顧客の情報を入力します。",
    'cl_new__unable_to_sent_notification' => 'ユーザアカウントは作成されましたが、顧客への通知の送信に失敗しました。 %1',
    'cl_perm__all_ip' => "利用可能な全IP",
    'cl_perm__all_ip_based_hst_will_be_nb' => "顧客の IP ベースのホスティングアカウントはすべて名前ベースに変換されます。",
    'cl_perm__allow_client_create_domain' => "選択するフィールドは、顧客がドメイン作成を許可されている場合のみ適用されます。",
    'cl_perm__allow_create_nb_w_ip' => "顧客は %1 を用いて名前ベースのホスティングを作成できます。",
    'cl_perm__allow_creation_ip_based_hosting' => "IP ベースのホスティングアカウントを許可する",
    'cl_perm__available_ips' => "利用可能な IP アドレス",
    'cl_perm__change_limits' => "制限の調整",
    'cl_perm__cl_disk_space' => "利用可能なディスクスペースの合計",
    'cl_perm__cl_expiration' => "顧客アカウントの有効期間",
    'cl_perm__cl_max_box' => "メールボックス",
    'cl_perm__cl_max_db' => "データベース",
    'cl_perm__cl_max_dom' => "ドメイン",
    'cl_perm__cl_max_maillists' => "メーリングリスト",
    'cl_perm__cl_max_subdom' => "サブドメイン",
    'cl_perm__cl_max_traffic' => "利用可能な総トラフィック量",
    'cl_perm__cl_max_wu' => "ウェブユーザ",
    'cl_perm__cl_mbox_quota' => "このユーザアカウントのメールボックスサイズ制限",
    'cl_perm__current_maximum_exp_date' => "ドメインの有効期限における現在の最大値は %1 です; %2 必要です",
    'cl_perm__current_maximum_mailbox_quota' => "このユーザアカウントにて現在割り当てられているメールボックス用のディスクスペースは %1 ですが、%2 必要です",
    'cl_perm__current_total_requested' => "%1 のドメイン制限における現在の合計値は %2 です; %3 必要です",
    'cl_perm__current_total_requested_dom' => "この顧客に属する %1 の現在の数は %2 ですが、%3 必要です",
    'cl_perm__disk_space' => "ディスクスペースの最大値",
    'cl_perm__dashboard_stdgui' => 'ユーザインターフェース',
    'cl_perm__dashboard' => 'ホームページビュー',
    'cl_perm__stdgui' => '標準ビュー',
    'cl_perm__manage_dashboard' => 'ホームページ管理',
    'cl_perm__dashboard_and_stdgui' => 'ホームページビューおよび標準ビューを許可する',
    'cl_perm__dashboard_only' => 'ホームページ表示のみ許可',
    'cl_perm__stdgui_only' => '標準表示のみ許可',
    'cl_perm__edit_cl' => "顧客 %1 のパーミッション",
    'cl_perm__exp_date_exceeded' => "設定しようとしている有効期間は、この顧客関連の各ドメインで指定した上限を超過しています。",
    'cl_perm__invalid_value' => "無効な値です。数値でのみ指定可能です",
    'cl_perm__limit_disk_space' => "%1 最大ディスクスペースを制限します。",
    'cl_perm__limit_expiration' => "%1 は顧客アカウントの有効期間を制限します。",
    'cl_perm__limit_max_box' => "%1 最大メールボックス数を制限",
    'cl_perm__limit_max_db' => "%1 最大データベース数を制限",
    'cl_perm__limit_max_dom' => "%1 最大ドメイン数を制限",
    'cl_perm__limit_max_maillists' => "%1 最大メーリングリスト数を制限",
    'cl_perm__limit_max_subdom' => "%1 最大サブドメイン数を制限",
    'cl_perm__limit_max_traffic' => "%1 は総トラフィック量を制限します。",
    'cl_perm__limit_max_wu' => "%1 最大ウェブユーザ数を制限",
    'cl_perm__limit_mbox_quota' => "%1 メールボックスクォータ設定",
    'cl_perm__limits_exceeded' => "設定しようとしている上限値のうち、この顧客に属する各ドメインで定義した上限値を既に超過しているものがあります。\n顧客に対する上限値は、その顧客の下に存在する各ドメインの上限値の合計以上でなければいけません。",
    'cl_perm__mailbox_quota_exceeded' => "設定しようとしているメールボックス用のディスクスペースの上限値は、この顧客アカウント関連の各ドメインで指定した上限値を超過しています。",
    'cl_perm__mailbox_quota_exceeds_server_limit' => "メールボックスのディスクスペースの上限を、サーバレベルの上限以上に設定しようとしています。",
    'cl_perm__make_dumps' => "データのバックアップおよび復元",

    'cl_perm__max_box' => "最大メールボックス数",
    'cl_perm__max_db' => "最大データベース数",
    'cl_perm__max_dom' => "ドメイン",
    'cl_perm__max_maillists' => "最大メーリングリスト数",
    'cl_perm__max_subdom' => "サブドメイン",
    'cl_perm__max_traffic' => "トラフィックの上限量",
    'cl_perm__max_wu' => "最大ウェブユーザ数",
    'cl_perm__max_dom_aliases' => "ドメインエイリアス",
    'cl_perm__mbox_quota' => "メールボックスクォータ",
    'cl_perm__not_allow_create_nb_hst' => "顧客は名前ベースのホスティングを作成できません",
    'cl_perm__this_ip_used_vrt_hst' => "この IP アドレスは仮想ホスティングで使用されています。 \nこの IP アドレスを削除するには、ホスティングサービスを削除するか、タイプを名前ベースに変更する必要があります。",
    'cl_perm__unable_off_ipb_creating' => "顧客は既に、IP ベースのホスティングサービスを設定しています。顧客に対してこの機能を非アクティブ化するには、［ドメイン作成］チェックボックスをオフにするか、すべての IP ベースのホスティングアカウントを削除してください。",
    'cl_perm__unable_off_nb_creating' => "顧客は既に、名前ベースのホスティングサービスを設定しています。 顧客に対してこの機能を非アクティブ化するには、［ドメイン作成］チェックボックスをオフにするか、すべての名前ベースのホスティングアカウントを削除してください。",
    'cl_perm__unable_set_domain_limit' => "最大ドメイン数を制限できません。 顧客は既に %1 ドメインを運用しています。",
    'cl_perm__unable_update_client_limitations' => "顧客アカウントの上限を変更できません。 %1",
    'cl_pref__edit_cl' => "顧客 %1 のプリファレンス",
    'class_anonftp__create_ftp_domain' => "この dom_id の仮想 FTP ドメインはありません。まず、仮想 FTP ドメインを作成してください。",
    'class_anonftp__incoming_disk_space_should_be_lower' => "設定しようとしているディスクスペース上限（%1）が、ドメインレベルの合計ディスクスペース上限（%2）を超えないようにしてください。",
    'class_anonftp__invalid_input_only_digits' => "無効な値が指定されています。数値にて指定してください",
    'class_anonftp__unable_change_ownerships' => "クォータファイル：%1の所有者またはパーミッションを変更することができません",
    'class_anonftp__unable_copy_quota_file' => "クォータファイルをコピーすることができません。%1",
    'class_anonftp__unable_get_disk_usage' => "incoming ディレクトリのディスク使用情報を取得することができません。%1",
    'class_anonftp__unable_parse_quota_file' => "クォータファイルを解析できません。",
    'class_anonftp__unable_read_quota_file' => "クォータファイルを読むことができません。%1",
    'class_anonftp__unable_update_quota' => "クォータを更新できません。受信ディレクトリにあるファイルのディスクスペース使用量は既に%1 KBに達しており、新しいクォータ値を超えています。",
    'class_anonftp__unable_write_temp_file' => "一時ファイルに書き込むことができません。%1",
    'class_bsdomain__warn_max_date__' => "有効期限が %1 に設定されました",
    'class_cList__empty' => "アイテムがありません。",
    'class_cList__header' => "%1（%2）",
    'class_cList__not_found' => "%2（%3 / %4）で <b>\"%1\"</b> に一致する項目がありません。",
    'class_cList__search_result' => "%2（%3 / %4）での<b>「%1」</b>の検索結果",
    'class_client__client_creation_notification' => "顧客の作成通知",
    'class_client__client_with_contact_name_already_exists' => "名前が %1 の顧客は既に存在します。",
    'class_client__disk_space' => "ディスクスペース",
    'class_client__invalid_max_dom' => "無効なドメイン数の指定です。数値にて指定してください",
    'class_client__limit_exceed' => "顧客 %2 のアカウントに対する割当量（%3）を超過しているため、要求された量の %1 を割り当てられません。リソースをさらに割り当てるには、［顧客］> 顧客名 >［制限］を開き、必要に応じて割当量を変更してください。 その後この画面に戻り、割当量を再調整してください。",
    'class_client__limit_exceed_unlimited' => "リソース量（%1）を無制限に設定したい場合、［顧客］> 顧客名 >［制限］を開き、必要なリソースタイプについて［無制限］チェックボックスをオンにしてください。 その後この画面に戻り、割当量を再調整します。",
    'class_client__max_box' => "メールボックス",
    'class_client__max_db' => "データベース",
    'class_client__max_maillists' => "メーリングリスト",
    'class_client__max_subdom' => "サブドメイン",
    'class_client__max_traffic' => "最大トラフィック",
    'class_client__max_wu' => "ウェブユーザ",
    'class_client__max_dom_aliases' => "ドメインエイリアス",
    'class_client__mbox_quota' => "メールボックスクォータ",
    'class_client__unable_define_cl_status' => "顧客アカウントのステータスを定義できません。 %1",
    'class_client__unable_define_inactive_dom' => "無効なドメイン %1 を定義できません",
    'class_client__unable_del_ip' => "IP を削除することができません。%1",
    'class_db__db_name_not_set' => "データベース名が定義されていません",
    'class_db__db_not_exist_for_curr_dom' => "データベースはこのドメインに存在しません",
    'class_db__invalid_db_or_dom_name' => "ドメインまたはデータベース ID が無効か、データベース名が定義されていません",
    'class_db__invalid_pass' => "パスワードが無効です",
    'class_db__mailgrp_member_exist' => "メールグループメンバが既に存在します。",
    'class_db__access_hosts_notsupport' => 'このデータベースタイプにおいてアクセスホスト設定はサポートされていません',
    'class_db__unable_add' => 'アクセスホストレコード %1 を追加できません',
    'class_db__unable_del' => 'アクセスホストレコード %1 を削除することができません',
    'class_db__inc_user_not_exist' => 'データベースユーザ「%1」は存在しません',
    'class_db__inc_access_record_exist' => '当該アクセスレコードは既に存在します。',
    'class_db__inc_access_record_not_exist' => '与えられたアクセスレコードは存在しません',
    'class_db__inc_unable_del_last_record' => '最終アクセスホストレコードを削除することはできません',
    'class_domtmpleditform__dns_master' => "プライマリ",
    'class_domtmpleditform__dns_slave' => "セカンダリ",
    'class_domtmpleditform__dns_type' => "ドメイン DNS ゾーンタイプ",
    'class_traffichistory__no_data_available' => "データが見つかりません",
    'class_traffichistory__traffic_usage' => "トラフィック使用",
    'clienttrafficlist_header' => "ドメインのトラフィック",
    'clienttrafficlist_header_of_client__' => "顧客 %1 のドメインのトラフィック",
    'cmd_dns__a_dns_record_already_exist' => "このレコードは、ゾーンの A レコードと競合します。",
    'cmd_dns__domain_last_ns' => 'ドメインの最後の NS DNS レコードを削除できません。',
    'cmd_dns__canonical_dom_name_is_invalid' => "ドメインの正規名が無効です。",
    'cmd_dns__cname_dns_record_already_exist' => "このレコードは、ゾーンの CNAME レコードと競合します。",
    'cmd_dns__cname_in_rr_combination' => 'DNS ゾーンに無効な DNS レコードの組み合わせが存在します。',
    'cmd_dns__cname_coexist_with_data' => 'CNAME レコードは、同一ゾーン上では他の DNS レコードとともに記述できません',
    'cmd_dns__dns_record_type_is_invalid' => "DNS レコードタイプが無効です",
    'cmd_dns__ext_host_is_not_resolved' => "正規名 %1 は A または AAAA レコードに解決しません。",
    'cmd_dns__domain_restore_dns_zone_failed_add_record' => 'ゾーン %2 に %1 レコードを追加できません。 %3',
    'cmd_dns__mail_dom_name_is_invalid' => "メールエクスチェンジャー名が正しくありません",
    'cmd_dns__mx_priority_is_invalid' => "MX レコードの優先度が無効です",
    'cmd_dns__name_server_is_invalid' => "ネームサーバが無効です",
    'cmd_dns__network_mask_should_be_24_16_or_8' => "ネットマスクの値は、24、16、または 8 にする必要があります。",
    'cmd_dns__this_dns_record_already_exists' => "このような DNS レコードは既に存在します。",
    'cmd_dns__unable_add_record' => "レコード「%1」を追加できません。%2",
    'cmd_dns__unable_add_a_record' => "A レコードを追加できません。%1",
    'cmd_dns__unable_add_cname_record' => "CNAME レコードを追加できません。%1",
    'cmd_dns__unable_add_dns_record' => "DNS レコードを追加できません。%1",
    'cmd_dns__unable_add_ext_ns_record' => "EXT_NS レコードを追加できません。%1",
    'cmd_dns__unable_add_ns_record' => "NS レコードを追加できません。%1",
    'cmd_dns__unable_add_ptr_record' => "PTR レコードを追加できません。%1",
    'cmd_dns__unable_add_txt_record' => "TXT レコードを追加できません。%1",
    'cmd_dns__unable_create_dns_zone' => "DNS ゾーンを作成することができません。%1",
    'cmd_dns__unable_define_dns_record' => "DNS レコード %1 を定義できません",
    'cmd_dns__unable_get_default_dns_zone_status_set_true' => "デフォルト DNS ゾーンの状態情報を取得することができません。%1",
    'cmd_dns__unable_insert_a_record' => "A レコードを挿入できません。%1",
    'cmd_dns__unable_insert_mx_record' => "MX レコードを挿入できません。%1",
    'cmd_dns__unable_insert_ns_record' => "NS レコードを挿入できません。%1",
    'cmd_dns__unable_set_dns_zone_status' => "DNS ゾーンの状態を設定することができません。%1",
    'cmd_domains__dom_already_exists' => "ドメイン %1 は既に存在します。",
    'cmd_domains__dns_record_already_exists' => "ドメイン %1 を作成できません。ホスト %1 を参照する DNS レコードが既に存在します。",
    'cmd_domains__dom_already_exists1' => "このドメインには%2のサブドメインがあります。ドメイン%1は既に存在しています。",
    'cmd_domains__dom_already_exists2' => "サブドメイン %1 は既に存在します。",
    'cmd_domains__dalias_already_exists' => "このエイリアスは存在します。",
    'cmd_domains__domain_alias_already_exists' => 'この名前のドメインエイリアスは既に存在します。',
    'cmd_domains__unable_del_mail_for_dom' => "このドメインのメールサービスを削除することができません。%1",
    'cmd_domains__unable_delete_anonymous_ftp' => "このドメインの匿名 FTP アカウントを削除することができません。%1",
    'cmd_domains__unable_update_dom_param' => "ドメインパラメータを更新することができません。%1.",
    'cmd_domains__unable_rename_client_exist' => "ドメイン管理者のユーザ名は既に使用されています。",
    'cmd_hosting__hst_type_is_not_physical_hst' => "ホスティングが物理ホスティングでありません",
    'cmd_hosting__unable_create_user' => "ユーザ%2を作成することができません。%1",
    'cmd_hosting__unable_define_ip_addr_for_name_based_virtual_hosts' => "名前ベースの仮想ホストの IP アドレスを定義できません。%1",
    'cmd_hosting__unable_del_old_hst' => "前に設定されたホスティング削除できません。%1",
    'cmd_hosting__unable_del_protected_directory' => "保護ディレクトリを削除することができません。%1",
    'cmd_hosting__unable_del_web_user' => "ウェブユーザを削除することができません。%1",
    'cmd_hosting__unable_make/update_virtual_host' => "仮想ホストを作成または更新できません。%1",
    'cmd_hosting__unable_make_frame_forward_hst' => "フレーム転送ホスティングを設定できません",
    'cmd_hosting__unable_rebuild_ftp_config' => "proftpd 設定ファイルを再構築できません。%1",
    'cmd_hosting__unable_set_up_ssl' => "SSL/TLS をセットアップできません。%1。",
    'cmd_hosting__unable_unprotect_ssl_directory' => "SSL/TLS ディレクトリから保護を解除できません。%1",
    'cmd_hosting__unable_update_dest_url' => "移行先URLを更新できません。%1",
    'cmd_hosting__unable_update_dns_zone_for_dom_unable_exec_util' => "ドメインの DNS ゾーンをアップデートできません。ユーティリティの実行に失敗しました",
    'cmd_hosting__unable_update_ftp_passwd' => "FTPパスワード %1 を更新できません",
    'cmd_hosting__unable_update_user' => "ユーザ%2を更新できません。%1",
    'cmd_hosting__unknown_hst_type' => "不明なホスティングタイプ",
    'cmd_hosting__you_not_have_permission_del_hst' => "ホスティングサービスを終了させるパーミッションがありません",
    'cmd_mail__autoresponder__not_configured' => "このメールアカウントにおいて自動応答が設定されていません",
    'cmd_mail__addr_already_used_in_mail_redirect' => "アドレス %1 はメール転送で既に使用しています。",
    'cmd_mail__alias_already_exists' => "エイリアスが既に存在します。",
    'cmd_mail__autoresp_id_and_mailname_id_not_match' => "自動返信の ID とメールアカウントの ID が一致しません",
    'cmd_mail__autoresp_id_is_undefined' => "自動返信の ID が定義されていません",
    'cmd_mail__mail_alias_already_exists_in_mail_name' => "この名前のメールエイリアスはメールアカウント %1 に対して既に存在します。",
    'cmd_mail__mail_name_already_exists_in_maillists' => "メールアカウント %1 は既にメーリングリストに登録されています。",
    'cmd_mail__mail_name_alredy_exist_in_dom' => "メールアカウント %1 は既にこのドメインに登録されています。",
    'cmd_mail__mail_name_not_exist' => "メールアカウントが存在しません",
    'cmd_mail__mail_name_passwd_part' => "パスワードには、メールアカウントを含まない文字列を指定するようにしてください",
    'cmd_mail__maillist_already_exist_in_this_dom' => "このドメイン上に、メーリングリスト %1 は既に存在します。",
    'cmd_mail__mailname_already_exist_in_mg' => "メールアカウント %1 はメールグループに存在します。",
    'cmd_mail__mailname_already_exist_in_this_dom' => "メールアカウント %1 は既にこのドメインに登録されています。",
    'cmd_mail__mailname_already_exists' => "メールアカウントは既に存在します。",
    'cmd_mail__mailname_is_invalid' => "メールアカウント名 %1 は無効です",
    'cmd_mail__mailname_unable_update' => "メールアカウントプロパティをアップデートできません。",
    'cmd_mail__max_autoresp_reached_for_this_dom' => "このドメインの最大自動応答数に達しました。",
    'cmd_mail__max_mail_groups_num_has_been_reached_for_this_dom' => "このドメインの最大メールグループ数に達しました",
    'cmd_mail__max_num_of_redirects_has_been_reached_for_this_dom' => "このドメインの最大メールフォワーダ数に達しました",
    'cmd_mail__max_postboxes_num_has_been_reached' => "最大メールボックス数に達しました",
    'cmd_mail__no_members_specified' => "メンバが指定されていません",
    'cmd_mail__the_passwd_is_too_simple_choose_another' => "パスワードが簡単すぎます。他の文字列を指定してください",
    'cmd_mail__this_addr_already_exist_in_mg_or_mn' => "このメールアドレスは既に使用されています。",
    'cmd_mail__unable_define_autoresp_id' => "自動応答 ID %1 を定義できません。",
    'cmd_mail__unable_update_mail_for_dom' => "ドメイン %1 のメールサービス設定変更に失敗しました",
    'cmd_mail__unable_del_mail_for_dom' => "ドメイン %1 からメールサービスを削除することはできません。",
    'cmd_mail__unable_del_mail_redirection' => "メール転送サービス %1 を削除できません",
    'cmd_mail__unable_remove_autoresp' => "自動応答を削除できません。%1",
    'cmd_mail__unable_remove_mail_group_members' => "メールグループメンバを削除することができません。%1",
    'cmd_mail__unable_turn_off_mail_group' => "メールグループのスイッチオフに失敗しました。%1",
    'cmd_mail__unable_update_mail_redirect' => "メール転送サービス %1 を再構成できません。",
    'cmd_mail__uploaded_file_is_too_big' => "アップロードされたファイルサイズが大きすぎます。",
    'cmd_mail__additionally' => "追加 :",
    'cmd_pd__invalid_login' => "ユーザ名が無効です",
    'cmd_pd__this_user_already_exist' => "このようなユーザは既に存在します。",
    'cmd_pd__unable_define_hst_type' => "ホスティングタイプを定義できません",
    'cmd_pd__unable_upd_pd_usr' => "保護ディレクトリユーザのプロパティを更新できません。%1",
    'cmd_pd__user_is_undefined' => "ユーザが定義されていません",
    'cmd_server__no_enough_free_disk_space' => "ディスクスペースが不十分です",
    'cmd_server__old_passwd_is_incorrect_please_try_again' => "旧パスワード正しくありません。入力し直してください。",
    'cmd_web_usr__max_web_users_reached_for_this_dom' => "このドメインの最大ウェブユーザ数に達しました",
    'cmd_web_usr__unable_create_user' => "システムユーザを作成することができません。%1",
    'cmd_web_usr__unable_define_max_web_users_limit' => "ウェブユーザ数の上限を定義できません。%1",
    'cmd_web_usr__user_already_exists' => "ユーザは既に存在します。",
    'cmd_web_usr__web_user_name_is_invalid' => "ウェブユーザ名 %1 は無効です",
    'cmd_web_usr__web_user_not_exist' => "ウェブユーザが存在しません",
    'common_func__exec_bad_argument' => "実行引数には引用符を含めないでください",
    '__eol' => '改行',
    'eol__binary_file' => 'バイナリファイルでは改行方法を変更できません',
    'comp_info__header' => 'コンポーネント',
    'comp_info__comp_name' => "コンポーネント名",
    'comp_info__comp_disabled' => 'オフ',
    'comp_info__comp_active' => 'アクティブ',
    'comp_info__comp_not_configured' => '未構成',
    'comp_info__comp_not_started' => '開始前、コンポーネント設定を確認してください',
    'comp_info__comp_version' => "コンポーネントバージョン",
    'comp_info__integration_error' => "統合エラー",
    'comp_info__title' => "Plesk コンポーネント",
    'comp_info__service_name' => "サービス",
    'comp_info__last_updated' => '（最終更新日：%1）',
    'cp_access_admin_deny' => "現在適用されている IP アクセス制限ポリシーにより、アドレス「%1」からの管理者アクセスは制限されています。",
    'create_domain_warn__' => "ドメイン作成の間、次の事項が発生します。",
    'create_domain__client_select' => 'ドメインを作成する顧客を選択：',

    'dashboard__nav_button_name' => "ホーム",
    'dalias__list_title' => 'ドメイン %1 のドメインエイリアス',
    'dalias__list_legend' => 'ドメインエイリアス',
    'dalias__list_header' => 'ドメインエイリアス',
    'dalias__list_status' => 'S',
    'dalias__list_name' => 'ドメインエイリアス名',
    'dalias__list_ascii_name' => 'ASCII フォーマット',
    'dalias__remove_title' => 'ドメイン %1 から、以下のドメインエイリアスが削除されます。',
    'dalias__select_domain_aliases_to_remove' => '削除するドメインエイリアスを選択してください',
    'dalias__mail_turn_on_failed' => 'メールサーバを有効にできません。%1',
    'dalias__web_turn_on_failed' => 'ウェブサービスを有効にできません。 %1',
    'db_usr_edit__db_usr_name_old' => "古いデータベースユーザ名",
    'database_server_edit_form__cannot_infer_type' => '提供されたデータから接続方法を推測できません。提供されたポートで TCP/IP 経由で接続するにはデータベースサーバのホスト名として「127.0.0.1」と指定してください。または、Unix ソケット「%1」を使用する場合はポートフィールドを空のままにしてください。',
    'database_server_edit_form__duplicate' => 'このホストアドレスおよびポート番号を利用するデータベースサーバは既に登録されています。',
    'database_server_edit_form__host_is_invalid' => '入力したホスト名は無効です。',
    'database_server_edit_form__port_is_invalid' => '入力したポート番号は無効です。',
    'database_server_error__consult_admin' => 'Pleskサーバの管理者にお問い合わせください',
    'database_server_error__last__connection_failed' => 'ネットワークの問題により、前回このデータベースサーバのコントロールに失敗しています。',
    'database_server_error__last__permission_denied' => 'アカウントに管理者権限が付与されていないため、前回このデータベースサーバのコントロールに失敗しています。',
    'database_server_error__last__credentials_not_set' => "前回、このサーバへの接続の試行が失敗しました。有効な管理者のユーザ名とパスワードが指定されていませんでした。",
    'database_server_error__last__other_error' => '前回このデータベースサーバのコントロールに失敗しています。',
    'database_server_error__real__connection_failed' => 'ネットワークの問題により、データベースサーバへの接続に失敗しました',
    'database_server_error__real__permission_denied' => 'アカウントに管理者権限が付与されていないため、データベースサーバへの接続に失敗しました。',
    'database_server_error__real__duplicate_object' => '名前のクラッシュにより、データベースサーバへの接続に失敗しました。',
    'database_server_error__real__unacceptable_name' => '無効なオブジェクト名のため、データベースサーバへの接続に失敗しました。',
    'database_server_error__real__unacceptable_password' => 'パスワードが異なるため、データベースサーバへの接続に失敗しました',
    'database_server_error__real__credentials_not_set' => "有効な管理者ユーザ名とパスワードが指定されていないため、Plesk はデータベースサーバに接続できません。",
    'database_server_error__real__other_error' => 'データベースサーバへの接続に失敗しました。',
    'database_server_error__test__connection_failed' => 'ネットワークの障害により、データベースサーバへのテスト接続が失敗しました。',
    'database_server_error__test__permission_denied' => 'データベースサーバへのテスト接続が失敗しました。指定されたアカウントに管理者権限がありません。',
    'database_server_error__test__duplicate_object' => '名前の衝突により、データベースサーバへのテスト接続が失敗しました。',
    'database_server_error__test__unacceptable_name' => '無効なオブジェクト名により、データベースサーバへのテスト接続が失敗しました。',
    'database_server_error__test__unacceptable_password' => '許可されないパスワードにより、データベースサーバへのテスト接続が失敗しました。',
    'database_server_error__test__credentials_not_set' => "このサーバへのテスト接続が失敗しました。有効な管理者のユーザ名とパスワードが指定されていませんでした。",
    'database_server_error__test__other_error' => 'データベースサーバへのテスト接続が失敗しました。',

    'db__create_new_db' => "データベースを追加",
    'db__db_add' => "データベースを追加",
    'db__db_for_dom' => "ウェブサイト %1 のデータベース",
    'db__db_id_undefined' => "データベース ID が定義されていません",
    'db__db_name' => "データベース名",
    'db__db_not_exist' => "データベースが存在しません",
    'db__db_type' => "タイプ",
    'db__db_server' => "データベースサーバ",
    'db_server_not_exist' => "データベースサーバが存在しません",
    'db__db_user_not_exist' => "データベースユーザが存在しません",
    'db__domain_not_exist' => "ドメインが存在しません",
    'db__enter_db_name' => "新しいデータベース名を入力してください。",
    'db__invalid_db_id' => "データベース識別子が無効です",
    'db__invalid_db_name' => "データベース名が無効です。データベース名に使用できるのは英数字、アンダースコア、ダッシュのみで、63 文字以内にしてください。",
    'db__max_db_reached_for_dom' => "このドメインにおける最大データベース数に達しました",
    'db__max_mssql_db_reached_for_dom' => "当該ドメインにおける Microsoft SQL サーバの最大データベース数に達しました",
    'db__postgres_not_connect_for_admin' => "PostgreSQL に接続できません。サーバ管理ページで、PostgreSQL サポートをオンにしてください。",
    'db__postgres_not_connect_for_client' => "PostgreSQLに接続できません。システム管理者までお問い合わせください",
    'db__remove_db_on_domain' => "顧客 %1 が所有するウェブサイト %2 の、以下のデータベースが削除されます。",
    'db__remove_db_on_domain_of_cl' => "顧客 %1 が所有するドメイン %2 の、以下のデータベースが削除されます。",
    'db__remove_db_linked_resource' => 'このデータベースはウェブアプリケーションで使用されています。このウェブアプリケーションをアンインストールしなければ削除できません。',
    'db__remove_db_users' => "顧客 %1 が所有する %2 のデータベース %3 の、以下のユーザが削除されます。",
    'db__remove_db_users_of_cl' => "顧客 %1 が所有する %2 のデータベース %3 の、以下のユーザが削除されます。",
    'db__select_db_for_remove' => "削除するデータベースを選択してください：",
    'db__select_db_users_for_remove' => "削除するデータベースユーザの選択",
    'db__unable_create_db_user' => "データベースユーザを作成できません。%1",
    'db__unable_define_db_name' => "データベース名を定義できません。%1",
    'db__unable_define_db_user' => "データベースユーザを定義できません。%1",
    'db__unable_define_db_users' => "データベースユーザを定義できません。%1",
    'db__unable_select_dom_name' => "ドメイン名を選択できません。%1",
    'db_edit__db_for_dom' => "ドメイン %2 のデータベース %1 のユーザ",
    'db_edit__invalid_db_name' => "データベース名が無効です",
    'db_edit__no_users' => "このデータベース用のクレデンシャルを持つユーザはありません。",
    'db_edit__unable_define_db_usrs' => "データベースユーザを定義できません。%1",
    'db_edit__unable_select_db_usr' => "データベースユーザを選択できません",
    'db_edit__db_user_password_for_' => "データベースユーザ %1 のパスワードを入力してください",
    'db_list__tab_title_db_type' => "T",
    'db_usr_edit__add_db_usr' => "データベースユーザを追加",
    'db_usr_edit__db_usr_name' => "データベースユーザ名",
    'db_usr_edit__edit_db_usr' => "データベースユーザアカウントのクレデンシャルを設定する",
    'db_usr_edit__for_db' => "%1 データベース",
    'db_usr_edit__not_create_pass' => "この操作を実行すると、データベースのユーザアカウントがパスワードなしで作成されます。 \nパスワードを割り当てずにユーザを作成しますか？",
    'dbuser__only_one_user_can_be_default' => "デフォルト指定できるユーザはひとつのみです",
    'db_server__cannot_delete_default' => "デフォルトデータベースサーバは削除できません",
    'db_server__cannot_delete_local' => "ローカルデータベースサーバを削除できません",
    'db_server__cannot_delete_used' => 'あるデータベースサーバ上でホスティングされているデータベースやデータベースユーザが存在する場合、このデータベースサーバを削除することはできません。',
    'demo__disabled_in_demo' => "デモバージョンにてこの操作はサポートされていません",
    'defaultcomponents__title' => "サード パーティ サービスの選択",
    'defaultcomponents__select_default' => "デフォルト %1 コンポーネントを選択する",//to check
    'defaultcomponents__not_installed' => "（未インストール）",
    'defaultcomponents__not_configured' => "（未構成）", // to check
    'defaultcomponents__not_opted_to_install_support_files' => "サービスカテゴリの中に無効な選択があるか、何も選択されていません",
    'defaultcomponents__depends_on' => "（%1 が必要です）",
    'defaultcomponents__parameters' => "%1 のパラメータ",
    'component_name__antivirus' => "アンチウイルス",
    'component_name__database' => "SQL Server",
    'component_name__sqladmin' => "MySQL Webadmin",
    'component_name__sqladminmysql' => "MySQL Webadmin",
    'component_name__dnsserver' => "DNS サーバ",
    'component_name__firewall' => "ファイアウォール",
    'component_name__ftpserver' => "FTP サーバ",
    'component_name__java' => "Java",
    'component_name__mailserver' => "メールサーバ",
    'component_name__local_mailserver' => "ローカルメールサーバ",
    'component_name__psa' => "Plesk",
    'component_name__script' => "ウェブスクリプティング",
    'component_name__spamfilter' => "スパムフィルタ",
    'component_name__stats' => "ウェブ統計",
    'component_name__stunnel' => "SSL/TLS ラッパ",
    'component_name__webmail' => "ウェブメール",
    'component_name__webpublish' => "Web 発行",
    'component_name__webserver' => "ウェブサーバ",
    'dns__dns_record_invalid_values' => '正しくない DNS レコード値が指定されました：%1：%2',
    'dns__dns_record_not_found' => 'DNS レコードが見つかりませんでした',
    'dns__dns_zone_invalid_values' => '無効な DNS ゾーンパラメータが指定されています。',

    'dns__soa_mname_title' => 'プライマリネームサーバ',
    'dns__soa_mname_legend' => 'ネームサーバ',
    'dns__soa_mname_autoselect' => '（Autoselect）',

    'dns__dns_zone_off_remove_title' => "以下のリソースレコードがゾーン %1 から削除されます。",
    'dns__dns_zone_master_remove_title' => "DNS ゾーン %1 からリソースレコードを削除します。",
    'dns__dns_zone_slave_remove_title' => "以下の %1 用プライマリネームサーバのレコードが削除されます。",
    'dns_add__param_ttl' => "TTL",
    'dns_add__enter_spf' => 'レコード文字列の入力',
    'dns_add__is_spf_syntax' => 'SPFレコード',
    'dns_add__spf_value_is_invalid' => "SPF レコードの値が正しくありません。レコードの先頭は「v=spf」にしてください。",
    'dns__dns_zone_status' => "DNS ゾーンのステータス",
    'dns__dns_zone_template' => 'DNS 設定',
    'dns__invalid_ip_address' => "新しいプライマリ DNS サーバの IP アドレスが無効または空です。",
    'dns__ip_address' => "IP アドレス",
    'dns__master_dns_type' => "プライマリ DNS サーバ",
    'dns__masters' => "プライマリ DNS サーバ",
    'dns__soa_minimum_too_large' => 'ネガティブ応答を 3 時間以上キャッシュする設定は推奨しません',
    'dns__select_masters_to_remove' => "削除するプライマリ DNS サーバを選択します。　",
    'dns__select_template_record_to_remove' => '削除する DNS テンプレートレコードを選択します。',
    'dns__nameservers_for_domain' => "ドメインのネームサーバ",
    'dns__remove_dns_zone_of_domain__' => "ドメイン %1 のDNSレコード削除",
    'dns__remove_dns_zone_template__' => "以下の DNS レコードがテンプレートから削除されます。",
    'dns__remove_this_dns_record?' => "この DNS レコードを削除しますか？",
    'dns__restore_default' => "テンプレートより DNS ゾーンを復元します。",
    'dns__restore_default_confirm' => "DNS ゾーンを復元すると、現在の DNS ゾーン構成が削除されます。 復元しますか？",
    'dns__restore_default_error' => "DNS ゾーンの復元エラー：",
    'dns__slave_dns_type' => "セカンダリ DNS サーバ",
    'dns__subdomain_dns_rec_removed' => "サブドメインゾーン %1 から A レコードが削除されました。",
    'dns__zone_switched_off_no_ns' => "ゾーンに必要な NS レコード %1 がないため、ゾーンはオフになっています。ゾーンにレコードを追加するには、［レコード追加］ボタンをクリックしてください。",
    'dns__cant_switch_on_no_ns' => "ゾーンに必要な NS レコード %1 がないため、ゾーンをオンにできません。ゾーンにレコードを追加するには、［レコード追加］ボタンをクリックしてください。",
    'dns__unable_activate/deactivate_dns' => "DNS をアクティブ化/非アクティブ化できません。%1",
    'dns__unable_add_dns_master_duplicate_entry' => "プライマリ DNS サーバを追加できません。重複エントリです。",
    'dns__unable_add_dns_master_local_ip' => "プライマリ DNS サーバに IP アドレスを追加できません。このレコードはリモートサーバで作成する必要があります。",
    'dns__unable_define_dns_record' => "DNSレコードを定義できません。%1",
    'dns__unable_get_dns_template_status' => "DNS テンプレート状態を取得できません",
    'dns__unable_remove_dns_rec' => "DNSレコードを削除できません。%1",
    'dns__warnings__' => "DNS ゾーン変更の結果：",
    'dns__you_not_have_perm_manage_dns' => "このドメインの DNS ゾーンを管理するパーミッションがありません",
    'dns__cant_create_record_with_server_ip' => "この IP アドレスは、この Plesk で管理されているサーバの IP アドレスと同じであるため、追加できません。",

    'dns__tabs_acl' => "ゾーン転送",
    'dns__acl_add_network_legend' => "ネットワークを追加",
    'dns__acl_add_ip_legend' => "IP アドレスを追加",
    'dns__acl_network_not_allowed' => "このネットワークアドレスは Windows の DNS では許可されません。",
    'dns__acl_enter_ip_address_with_mask' => "IP アドレス/マスク",
    'dns__acl_enter_ip_address' => "IP アドレス",
    'dns__acl_list_network_legend' => "DNS ゾーンのコピーを取得可能なサーバのネットワーク",
    'dns__acl_list_ip_legend' => "DNS ゾーンのコピーを取得可能なサーバの IP ゾーン",
    'bt_dns_acl_add_network' => "ネットワークを追加",
    'bt_dns_acl_add_ip' => "IP アドレスを追加",

    'dns_add__add_rec_for_zone' => "ゾーン %2 に %1 を追加",
    'dns_add__canonical_dom_name_is_invalid' => "ドメインの正規名が無効です。",
    'dns_add__enter_canonical_name' => "正規名",
    'dns_add__enter_dom_name' => "ドメイン名",
    'dns_add__enter_ip_address' => "IP アドレス",
    'dns_add__enter_ip_mask' => "IP アドレスとネットワークマスク",
    'dns_add__enter_mail_domain' => "メールドメイン",
    'dns_add__enter_mail_exchanger' => "メールエクスチェンジサーバ",
    'dns_add__enter_nameserver' => "ネームサーバ",
    'dns_add__enter_txt_record' => "TXT レコード",
    'dns_add__enter_service_name' => "サービス名",
    'dns_add__hint_service_name' => "例：SIP（下線符号なし）",
    'dns_add__enter_protocol' => "プロトコル",
    'dns_add__hint_protocol_name' => "例：TCP（下線符号なし）",
    'dns_add__protocol_tcp' => "TCP",
    'dns_add__protocol_udp' => "UDP",
    'dns_add__enter_srv_priority' => "優先度",
    'dns_add__specify_weight_of_service' => "同じ優先度のレコードに対する相対的な重み",
    'dns_add__enter_target_host' => "ターゲットホスト",
    'dns_add__hint_target_host' => "例：example.com",
    'dns_add__enter_target_port' => "ターゲットポート",
    'dns_add__caa_tag' => "タグ",
    'dns_add__caa_value' => "値",
    'dns_add-invalid-A_ip' => "IP アドレスが正しくありません",
    'dns_add-invalid-AAAA_ip' => "IP アドレスが正しくありません",
    'dns_add-invalid-PTR_ip_mask' => "無効な IP アドレス/ネットマスクのペア",
    'dns_add-invalid-SRV_service_name' => "無効なサービス名",
    'dns_add-invalid-SRV_protocol_name' => "無効なプロトコル",
    'dns_add-invalid-SRV_target_port' => "無効なターゲットポート",

    'dns_add__invalid_ip' => "IP アドレスが正しくありません",
    'dns_add__low' => "低",
    'dns_add__mail_dom_name_is_invalid' => "メールドメイン名が適切でありません",
    'dns_add__nameserver_is_invalid' => "ネームサーバが無効です",
    'dns_add__record' => "%1レコード",
    'dns_add__select_prefer_for_mail_exchange_server' => "メールエクスチェンジサーバの優先度を指定",
    'dns_add__unable_insert_new_dns_rec' => "新しい DNS レコードを挿入できません。%1",
    'dns_add__very_high' => "とても高い",
    'dom_ctrl__allowed' => "許可",
    'dom_ctrl__db' => "MySQL データベース",
    'dom_ctrl__mssql_db' => "MS SQL データベース",
    'dom_ctrl__disk_space' => "ディスクスペース",
    'dom_ctrl__dom_adm' => "ドメイン %1/%2",
    'dom_ctrl__dom_cl' => "ドメイン %1",
    'dom_ctrl__domain_has_forwarding_with_undefined_fwd_url' => "ドメインは未定義のURLで転送設定されています。",
    'dom_ctrl__domain_has_frame_forwarding' => "ドメインは URL %1 にフレーム転送されます。",
    'dom_ctrl__domain_has_no_hosting' => "ドメインはホスティング設定されていません",
    'dom_ctrl__domain_has_physical_hosting' => "IP アドレス %1 上でこのドメインに対してウェブホスティングが設定されています。",
    'dom_ctrl__domain_has_standard_forwarding' => "ドメインは URL %1 に標準転送されます。",
    'dom_ctrl__maillists' => "メーリングリスト",
    'dom_ctrl__mboxes' => "メールボックス",
    'dom_ctrl__mg' => "メール転送",
    'dom_ctrl__resource_name' => "リソース",
    'dom_ctrl__resp' => "自動応答",
    'dom_ctrl__subdom' => "サブドメイン",
    'dom_ctrl__dom_aliases' => "ドメインエイリアス",
    'dom_ctrl__traffic' => "トラフィック",
    'dom_ctrl__unable_activate/deactivate_dom' => "ドメインをアクティブ化/非アクティブ化できません。%1",
    'dom_ctrl__used' => "使用中",
    // end of serge part

    // maverick part
    'dom_ctrl__wu' => "ウェブユーザ",
    'dom_pref__bounce_with_phrase' => "メッセージ付きでバウンス",
    'dom_pref__bounce' => "バウンス",
    'dom_pref__catch_addr' => "指定アドレスに転送",
    'dom_pref__reject' => '拒否',
    'dom_pref__confirm_domain_removing' => "忘れずにドメインユーザにドメイン名の変更を通知してください。ドメインの名前を変更しますか？",
    'dom_pref__db_inconsystency' => "データベース不整合",
    'dom_pref__dbs' => "データベース",
    'dom_pref__delete_traffic_stat' => "ウェブおよびトラフィック統計を保持",
    'dom_pref__delete_traffic_stat_older' => "ウェブおよびトラフィック統計を保持",
    'dom_pref__dom_level_name_conflict' => "ドメイン管理者のユーザ名が、顧客のユーザ名と競合しています。",
    'dom_pref__invalid_disk_space_limit' => "無効なディスクスペース制限です。最大値は %1 です",
    'dom_pref__invalid_expiration_date_limit' => "無効な有効期限",
    'dom_pref__invalid_max_traffic_limit' => "無効なトラフィック制限です。最大値は %1 です",
    'dom_pref__limits_of_dom' => "ドメイン %1 の制限",
    'dom_pref__mail_grps' => "メールグループ",
    'dom_pref__mail_nonexistent_user' => "存在しないユーザに送信されたメールの処理方法",
    'dom_pref__mail_redirs' => "メール転送",
    'dom_pref__mail_resps' => "自動応答メール",
    'dom_pref__max_limit_is_invalid' => "%1 は無効です",
    'dom_pref__max_num_of_%objects_is_invalid' => "%1 の最大数が無効です",
    'dom_pref__new_limit_less_currently_used' => "%1：要求 - %2、現在の使用 - %3",
    'dom_pref__older_that' => "for",
    'dom_pref__postboxes' => "メールボックス",
    'dom_pref__preferences_of_dom' => "ドメイン %1 の設定",
    'dom_pref__redirect_to_itself' => "ドメインは自身に転送されます。",
    'dom_pref__traffic_logging_period_couldnt_be_lower' => "指定されたドメイントラフィック統計の保持期間が、サーバに定義されている合計値より短くなっています（%1 ヶ月）。統計の保持期間はサーバのデフォルト値（%1 ヶ月）に設定されます。",
    'dom_pref__unable_add_www_prefix_in_dom' => "ドメイン %1 には www プレフィックスを追加できません",
    'dom_pref__unable_define_physical_hst_param' => "物理ホスティングパラメータを定義できません。%1",
    'dom_pref__unable_rename_domain' => "ドメイン %1 の名前を変更できません：%2",
    'dom_pref__unable_set_up_mbox_quota' => "このドメインのメールボックスクォータを設定することができません。%1",
    'dom_pref__unable_set_up_web_user_script' => "ウェブユーザに対してスクリプティングをセットアップできません。%1",
    'dom_pref__unlimited' => "無制限",
    'dom_pref__web_usrs' => "ウェブユーザ",
    'dom_pref__you_already_have_%object' => "%1 を既に所有しています。",
    'cu_domain__error_unable_update_ftp_users' => 'ドメイン FTP ユーザの更新に失敗しました：%1',
    'dom_cli__warning_ignore_quota' => '警告："-hard_quota" オプションは無視されます。ハードディスククォータはサポートされていません。',
    'dom_user_client_login_exist' => "ドメイン %1 でドメイン管理者の Plesk へのアクセスを許可することができません。このユーザ名は既に使用されています。",
    'domain__unable_to_turn_on_service' => "%1 サービスのスイッチオンに失敗しました。",
    'domains__change_the_status_of_domain?' => "ドメイン %1 の状態を変更しますか？",
    'domains__client_info_hiding_traffic' => "%1 件のドメイン、%2 件のアクティブドメイン、%3 使用済みディスクスペース",
    'domains__unable_to_change_client_status' => "顧客アカウントのステータスを変更できません。 %1",
    'domains__unable_update_apache_settings' => "Apache の設定を更新できません",
    'domains__you_do_not_have_permissions_to_delete_domains' => "ドメインを削除するパーミッションがありません",
    'domains__you_want_change_the_status_of_the_cl??' => "顧客アカウントの状態を変更しますか？",
    'domains__you_want_change_the_cp_access_of_the_cl??' => "この操作を実行しますか？",
    'domains_list__unable_remove_doms' => "ドメインを削除できません。%1",
    'domaintrafficlist_header_of_domain__' => "ドメイン %1 のトラフィック",

    'domain_aliases_remove__select_domain_aliases_for_remove' => '削除するドメインエイリアスを選択してください',
    'domain_aliases_remove__title' => 'ドメインエイリアスを削除する',
    'domain_aliases__max_aliases_reached_for_dom' => "このドメインにて許可されている最大のエイリアス数に達しています。",
    'domain_edit__edit_title' => 'ドメインエイリアス名を編集',
    'domain_alias_edit__type' => 'ドメインエイリアスタイプ',
    'domain_aliases__list_header' => 'ドメインエイリアス',
    'domain_aliases__name' => '名前',
    'domain_aliases__type' => 'タイプ',
    'domain_aliases__type_full' => '説明',
    'domain_aliases__type_web_ftp' => 'ウェブ + FTP',
    'domain_aliases__page_title' => 'ドメインエイリアス',
    'domain_aliases__legend' => 'ドメインエイリアス',
    'domain_alias__domain_exists' => 'この名前のドメインは既に存在します。',
    'domain_alias__subdomain_exists' => 'この名前のサブドメインは既に存在します。',
    'domain_alias__dns_record_exists' => '指定したドメインエイリアス名の DNS レコードは既に存在します。',
    'domain_alias__domain_alias_exists' => "この名前のドメインエイリアスは既に存在します。",
    'domain_alias__invalid_type_full' => 'メールサーバがドメインエイリアスをサポートしていません',
    'domain_alias__redirect_exists' => 'それ自身へのリダイレクトが検出されました',

    'ds__anonymous_ftp' => "匿名 FTP",
    'drweb__pagetitle' => 'アンチウイルス設定',
    'drweb__drweb' => 'アンチウイルスメールチェック',
    'drweb__drweb_direction' => 'メールにウイルスが含まれていないかチェック中',
    'drweb__drweb_direction_off' => 'ウイルスチェックしない',
    'drweb__drweb_direction_any' => '送信メールと受信メール',
    'drweb__drweb_direction_from' => '送信メールのみ',
    'drweb__drweb_direction_to' => '受信メールのみ',
    'drweb__disable_reason_key' => 'このライセンスキーではアンチウイルスはサポートされていません。',
    'drweb__disable_reason_perm' => 'アンチウイルスを管理するパーミッションがありません。',
    'drweb__disable_reason_install' => 'アンチウイルスがインストールされていません。',
    'drweb__filters' => 'アンチウイルスフィルタ',
    'ds__dns' => "DNS ゾーン",
    'ds__mail' => "メール",
    'dsr__of_client_title' => "%1のドメイン概要レポート",
    'dsr__report_has_been_sent_email' => "メールアドレス %1 宛てにレポートが送信されました。",
    'dsr__title' => "ドメイン概要レポート",
    'dumps_list__deletion_page_title' => "ドメイン %1 のバックアップファイルが削除されます。",
    'dumps_list__dumpfile_is_invalid' => "ファイル %1 は有効なドメインバックアップファイルではありません",
    'dumps_list__page_title' => "バックアップファイルストレージ",
    'dumps_upload__page_title' => "バックアップファイルをストレージにアップロード",
    'dumps_list__repository_is_not_exist' => "バックアップファイルストレージが存在しません。",
    'dumps_list__unable_to_remove' => "バックアップファイルを削除することができません。%1",
    'dumps_list__dumpfile_can_conflict' => "指定したファイル名は、ファイル %1 と競合しています。他のファイル名を指定してください。",
    'dusr_ed__allow_dl_usr_access' => "ドメイン管理者アクセスを許可する",
    'dusr_ed__information' => "ドメイン %1 の管理者プロパティ",
    'dusr_ed__locale' => "ドメイン管理者の言語",
    'dusr_ed__skin' => "ドメイン管理者のインターフェーススキン",
    'dusr_ed__personal_information' => '個人情報',
    'ess__error' => "エラー",
    'example__' => "例：%1",
    'extras__allow_certificate_purchasing' => "MyPleskでの証明書購入を許可する",
    'extras__allow_domain_registration' => "MyPleskでのドメイン登録を許可する",
    'extras__allow_extras' => "MyPleskへのアクセスを許可する",
    'extras__buy_new_key' => "現在のライセンスキーでは、これらのオブジェクトの編集は許可されません。",
    'extras__setup_services' => "追加サービスをセットアップする",

    'ruleeditform__error' => 'ファイアウォールルールを更新できません。',
    'ruleeditform__name_is_required' => 'ルール名を指定します。',
    'ruleeditform__profiles_is_required' => 'プロファイルを少なくとも 1 つ選択してください。',
    'ruleeditform__invalid_ip' => '指定された IP アドレスまたはネットワークは無効です。',
    'ruleeditform__invalid_port' => '指定されたポートは無効です。可能な値は 1000 または 1000-1051 です。',

    'filemanager__items' => '件数 - ディレクトリ "%1" 内',
    'filemanager__items_paging' => '件数 - ディレクトリ "%1" 内',

    'get_password__encrypted_password' => "パスワード情報を送信できません。 パスワードは暗号化されて保存されています。",
    'get_password__mail_error' => "メールアドレス %1 へのパスワード送信時にエラーが発生しました。%2",
    'get_password__mail_ok' => "メールアドレス %1 宛てにパスワードを送信しました。",
    'get_password__message' => "システムアクセス用のユーザ名：%1\nパスワードは %2 です",
    'get_password__subject' => "システムアクセス用パスワード",
    'groups__available' => "利用可能なメールグループ",
    'groups__groups_for_mailname' => "メールアカウント %1 が登録されているメールグループ",
    'groups__member_of' => "以下のメールグループのメンバ",
    'help__help_area' => "ヘルプエリア",
    'hst_def__auth_disabled' => "禁止",
    'hst_def__auth_enabled' => "許可",
    'hst_def__change_curr_dns_ip' => "DNS のA レコードにおける現在のIP アドレスが変更されます。",
    'hst_def__cr_hosting_ip_dns_ip_not_equiv' => "ホスティングアカウントに作成され割り当てられた IP アドレスと、DNS における A レコードに指定されたIP アドレスが一致しません",
    'hst_def__dest_url' => "転送先 URL",
    'hst_def__disk_quota' => "ディスククォータ",
    'hst_def__disk_space_limit_exceed_incoming_quota' => "匿名 FTP の受信ディレクトリに設定されているディスクスペース上限が、設定しようとしているディスクスペース上限より大きくなっています。匿名 FTP の受信ディレクトリのディスクスペース上限をドメインのディスクスペース上限より大きくすることはできません",
    'hst_def__frame_forwarding_definition' => "ドメイン %1 のフレーム転送",
    'hst_def__ftpuser_for_hst_not_exist_in_system' => "警告： FTP ユーザ %1 はホスティングアカウント設定で使用されていますが、システム上に存在しません。",
    'hst_def__hst_type_is_not_defined' => "ホスティングタイプが定義されていません",
    'hst_def__ip_based' => "IP ベース",
    'hst_def__name_based_power_anonymous_ftp_down' => "ホスティングアカウントを共有 IP アドレスへと変更した場合、当該ドメインで匿名 FTP サービスが利用できなくなります。続行しますか？",
    'hst_def__password_is_invalid_password_syntax' => "パスワードが無効です。 引用符および国別文字はパスワードに使用しないでください。 パスワードは 5～14 文字以内で指定する必要があります。 パスワード内にログイン名を含めないでください。",
    'hst_def__shell' => "契約のシステムユーザとしてサーバシェルへ SSH アクセス",
    'hst_def__shell_windows' => "契約のシステムユーザとしてサーバへリモートデスクトップアクセス",
    'hst_def__standard_forwarding_definition' => "ドメイン %1 の標準転送",
    'hst_def__title_name_based' => "名前ベース",
    'hst_def__unable_create/update_physic_hst' => "物理ホスティングを作成/更新できません。%1",
    'hst_def__unable_create/update_std_fwd' => "標準転送を作成/更新することができません。%1",
    'hst_def__unable_create_forwarding_myself' => "ドメインそれ自身に転送は作成できません",
    'hst_def__unable_turn_same_ssl_while_ssl_off' => "SSL/TLS コンテンツと非 SSL/TLS コンテンツの保存に単一のディレクトリを使用することを許可できません。SSL/TLS サポートがオンになっていません。",
    'hst_def__unable_turn_on_ssl_cert_not_defined' => "SSL/TLS サポートをオンにできません。インストールされた SSL/TLS 証明書がありません。",
    'hst_def__url_is_invalid' => "URL が無効です",
    'hst_def__virtual_host_access' => "ドメイン %1 の仮想ホストアクセス",
    'hst_def__virtual_host_uses_non_existed_ip_address' => "警告：この仮想ホストでは、存在しない IP アドレスをホスティングに使用しています。",
    'hst_def__you_have_no_ips' => "利用可能な IP アドレスがないため、名前ベースのホスティングの作成を許可されていません",
    'hst_sel__header' => "このサーバ上でウェブサイトをホスティングするには、物理ホスティングオプションを選択してください。\nドメインを他のマシン上のサイトに転送する場合は、フレーム転送または標準転送オフションを選択してください。\n標準転送では、ユーザはそのサイトに転送され、実際のサイトの URL がユーザのブラウザに表示されるため、ユーザは転送されていることを把握できます。 フレーム転送では、ユーザはそのサイトが実際は別の場所にあることを知らずに転送されます。",
    'hst_sel__physical_hst' => "物理ホスティング",
    'hst_sel__select_hst_type' => "ドメインのホスティングタイプを選択する",
    'hst_sel__select_hst_type_warning' => "ドメインのホスティングタイプを選択する",
    'hst_sel__hosting_exists' => "このドメインには既にホスティングが設定されています。ホスティング管理ページに転送されます。",
    'hst_sel__standard_frw' => "標準転送",
    'hst_sel__frame_frw' => "フレーム転送",
    '__frame_frw' => "フレーム転送",
    '__hosting_exists' => "このドメインには既にホスティングが設定されています。ホスティング管理ページに転送されます。",
    '__choose_hst_type' => "ホスティングタイプを選択してください",
    '__no_hst_conf' => "このドメインにはホスティングが設定されていません",
    '__physical_hst' => "物理ホスティング",
    '__select_hst_type' => "ドメインのホスティングタイプを選択する",
    '__standard_frw' => "標準転送",
    '__warning' => "警告：設定されているすべてのパラメータが破棄されます。ホスティングのタイプを変更しますか？",
    'i_cl_off' => "顧客は無効です",
    'i_cl_off_by_admin' => "顧客アカウントはサーバ管理者により一時停止されています。",
    'i_cl_off_expired' => "顧客アカウントは期限切れです",
    'i_cl_on' => "顧客は有効です",

    'icf__title' => 'インターネット接続ファイアウォール',
    'icf__if_legend' => 'インターフェース',
    'icf__mode' => 'モード',

    'invalid_value' => '値は無効です',

    'ip_addr__already_exists' => "IP アドレス %1 は既に存在します。",
    'ip_addr__cant_add' => "IP %1 は存在しないか、他の顧客の IP プールに属しています。",
    'ip_alias__interface' => "インターフェース",
    'ip_alias__invalid_ip_nm_bsd_vrt_hsts' => "名前ベースの仮想ホスト用の IP アドレス %1 は無効です。",
    'ip_alias__invalid_ip_or_netmask' => "無効な IP アドレス/ネットマスクのペア",
    'ip_alias__orig_ip_can_not_be_deleted' => "IP アドレス %1 はオリジナルサーバ IP のため、削除できません",
    'ip_alias__ip_is_invalid' => "%1 IP アドレスは無効です",
    'ip_alias__ip_mask_is_invalid' => "%1 IP マスクは無効です",
    'ip_alias__ip_not_exist' => "IP アドレス %1 が存在しません",
    'ip_alias__ip_address_and_mask' => 'IP アドレスとサブネットマスク',
    'ip_alias__mask' => "サブネットマスク",
    'ip_alias__remove_selected_ip_aliases?' => "選択した IP アドレスを削除しますか？",
    'ip_alias__select_ip' => "一覧から削除する IP アドレスを選択します。",
    'ip_alias__this_ip_used_for_domain' => "(%1) この IP アドレスはドメイン %2 用に使用されています。",
    'ip_alias__this_ip_used_for_nm_bsd_vrt_hsts' => "（%1）この IP アドレスは名前ベースの仮想ホストで使用されています。",
    'ip_alias__unable_add_ip' => "IP アドレスを追加できません。%1",
    'ip_alias__unable_remove_ip' => "IP アドレスを削除できません。%1",
    'ip_ctrl__anonymous_ftp_exists_in_domain' => "ドメイン「%1」で匿名 FTP が利用不能になるため、IP アドレスのタイプを共有に変更することはできません。",
    'ip_ctrl__ip_addr' => "インターフェース %1 の IP アドレス %2",
    'ip_ctrl__ip_exists_many_pools' => "IP タイプを変更できません。IP アドレスが複数のクライアントのプールに属しています。",
    'ip_ctrl__ssl_cert' => "SSL/TLS 証明書",
    'limit__date_in_past' => "有効期限が無効です。%1 は過去の日時です",
    'limit__enter_date' => "入力日",
    'limit__max_db' => "データベース",
    'limit__name_disk_space' => "ディスクスペース",
    'limit__name_max_box' => "メールボックス",
    'limit__name_max_db' => "MySQL データベース",
    'limit__name_max_dom' => "ドメイン",
    'limit__name_max_maillists' => "メーリングリスト",
    'limit__name_max_subdom' => "サブドメイン",
    'limit__name_max_traffic' => "トラフィック",
    'limit__name_max_wu' => "ウェブユーザ",
    'limit__name_mbox_quota' => "メールボックスクォータ",
    'limit__name_max_mn' => "メールアカウント",
    'limit__name_max_cl' => 'クライアント',
    'limit__name_total_mboxes_quota' => "総メールボックスクォータ",
    'limit__name_mysql_dbase_space' => "MySQL データベーススペース",
    'limit__name_mssql_dbase_space' => "MSSQL データベース領域",
    'limit__name_expiration' => '有効期限',

    'locale_upload__unable_to_install' => '言語パックファイルをインストールすることができません',
    'locale_upload__wrong_package' => 'アップロードしたファイルに、この Plesk バージョンで有効な言語パックが含まれていません。',
    'locale_upload__wrong_locale' => 'アップロードされたファイルには、有効な言語パックが含まれていません',
    
    'ma__create_title' => '%1 のメールエイリアス作成',
    'ma__edit_title' => "メールエイリアス %1 の編集",
    'ma__enter_new_alias' => "新しいエイリアスの入力",
    'ma__invalid_alias' => "無効なメールエイリアス",
    'ma__mail_aliases_mailname' => "メールアカウント %1 のメールエイリアス",
    'ma__mailname_does_not_exist' => "メールアカウントが存在しません",
    'ma__select_ma_for_remove' => "削除するメールエイリアスの選択",
    'ma__unable_to_add_new_ma' => "メールエイリアス %1 を追加できません",

    'mail_queue__not_allowed_by_license_key' => 'メールキュー管理がライセンスキーにて許可されていません',
    'maillist__' => "メーリングリスト %1",
    'maillist__already_exists' => "メーリングリストは既に存在します。",
    'maillist__mail_alias_already_exists_in_this_domain' => "このドメインにてメールエイリアス %1 が既に存在します。",
    'maillists__' => "メーリングリスト %1",
    'maillists__limit_cl_max_maillists' => "顧客はメーリングリスト上限数に達しました（上限 %1 件、使用 %2 件）",
    'maillists__limit_dom_max_maillists' => "ドメインはメーリングリストの上限値に達しました",
    'maillists__list' => "メーリングリスト",
    'maillists__mailman_not_installed_or_conf' => "Mailman サーバエクステンションが現在インストールされていないか、サーバ上に設定されていない可能性があります。管理者に連絡し、 Mailman サーバエクステンションがインストールされているか、または正常に設定されているか確認してください",
    'maillists__status' => "メーリングリストサービスがオンになっています",
    'maillists__unable_to_delete__' => "メーリングリストを削除することができません。%1",
    'maillists__disabled_text' => 'Mailman メーリングリストサーバコンポーネントがインストールされていないか設定されていないため、メーリングリストを管理できません',
    'maillist_member__already_exists' => 'メーリングリストにはメンバが存在しています。',
    'maillist_member__not_exists' => 'メーリングリストにはメンバが存在していません',
    'mailserver_switching_warning' => "警告：\n\nメールサーバの変更は、初期設定時にのみ行います。このサーバを既に使用している場合は、設定とメールボックス内容が失われる問題が発生する可能性があります。また、新たに使用しているサーバが既に構成されている場合、様々な問題が発生する可能性があります。\nこのサーバを現在使用中であり、別のサーバに切り替えることによる影響を認識されている場合は、顧客にメールのダウンロードや保存を促すために、予¥定している作業について通知することができます。",
    'manager__access_denied' => "アクセス拒否： %1",
    'manager__admin' => "管理者",
    'manager__client' => '顧客',
    'manager__domain' => "ドメイン",
    'manager__domain_cl_limit_exceeding' => "この顧客アカウントはドメインの上限数に達しました",
    'manager__domain_is_not_yours' => "ドメイン %1 はこのアカウントに属していません",
    'manager__domain_key_limit_exceeding' => "ライセンスキーにて定義されているドメイン作成数の制限値に達しました",
    'manager__no_perm_to_call' => "%1 を呼び出すパーミッションがありません",
    'manager__no_perm_to_create_domains' => "ドメインを作成するパーミッションがありません",
    'manager__no_perm_to_modify_domain' => "ドメイン %1 を変更するパーミッションがありません",
    'manager__no_perm_to_modify_domains' => "ドメインを編集するパーミッションがありません",
    'manager__no_perm_to_remove_domain' => "ドメイン %1 を削除するパーミッションがありません",
    'manager__no_perm_to_remove_domains' => "ドメインを削除するパーミッションがありません",
    'manager__node_doesnt_exist' => "%1 が存在しません",
    'manager__user_disabled' => "アカウントは一時停止されています。システムを操作できません",
    'mail_quota_unsupported' => "メールサーバが未対応",
    'mbox_quota_unsupported' => "メールサーバが未対応",
    'mn__create_title' => "メールアカウントの作成",
    'mn__edit_title' => "設定",
    'mn__files_list_title' => "添付ファイル",
    'mn__files_remove' => "添付リポジトリからファイルを削除します。 このファイルは自動返信で使用されている可能性があり、リポジトリと自動返信の両方から削除されます。",
    'mn__files_select_for_remove' => "削除するファイルの選択",
    'mn__mail_alias_form' => "メールエイリアスフォーム",
    'mn__mail_aliases_list' => "メールエイリアス",
    'mn__mailbox' => "メールボックス管理",
    'mn__unable_define_mn' => "メールアカウントをセットアップできません。%1",
    'mn__unable_remove_mbox_quota' => "メールボックスクォータを削除できません。%1",
    'mn__upload_file' => "ファイルアップロード",
    'mn_edit__attach_filename_changed' => 'アップロードしたファイルの名前 %1 は、非 ASCII 文字を含んでいるため、%2 に変更されました',
    'mn_edit__add_mail_group_members_or_turn_off_box' => "メールグループを有効にする前にメールグループにメンバを追加してください",
    'mn_edit__add_resp_or_turn_off_box' => "自動応答を追加するか、自動応答チェックボックスをクリアする必要があります。",
    'mn_edit__attachments' => "添付ファイル",
    'mn_edit__dom_quota_less_then_quota' => "このメールボックスのサイズを、当該ドメインのメールボックスに割り当てられたディスクスペースの上限より大きく設定することはできません",
    'mn_edit__enter_external_rcpnt_email' => "外部メールグループメンバーのメールアドレスを入力",
    'mn_edit__enter_mail_redir_or_turn_off_box' => "メール転送アドレスを入力するか、チェックボックスの選択を外してください",
    'mn_edit__ext_rcpnt_email_invalid' => "外部受信者のメールアドレスが無効です。",
    'mn_edit__file_exists' => "ファイルは存在します。上書きしますか？",
    'mn_edit__files_deld_from_repository' => "これらのファイルはリポジトリと自動応答から削除されます。続行しますか？",
    'mn_edit__mail_name' => "メールアカウント",
    'mn_edit__mail_name_invalid' => "メールアカウント名が無効です",
    'mn_edit__mail_redir' => "メール転送",
    'mn_edit__mail_redir_add' => "メールグループメンバを追加",
    'mn_edit__mail_resps' => "自動応答メール",
    'mn_edit__mailbox' => "メールボックス",
    'mn_edit__enable_mailbox' => "メールボックス",
    'mn_edit__mailgroup' => "メールグループ",
    'mn_edit__mailgroup_addresses' => "メールグループメンバ",
    'mn_edit__mailgroup_disabled' => "メールアカウントが既に追加されている場合のみ利用可能　",
    'mn_edit__max_dom_quota' => "ドメイン（%1）のデフォルト",
    'mn_edit__mbox_quota_invalid' => "メールボックスクォータが正しくありません",
    'mn_edit__new_resp_name' => "新規の自動応答名",
    'mn_edit__no_autoresponders' => "自動応答サービスを有効または無効にするには、自動応答を 1 つ以上追加する必要があります。",
    'mn_edit__no_file_sel' => "ファイルが選択されていません",
    'mn_edit__no_mail_addresses' => "メールアドレスが指定されていないか、選択されていません。",
    'mn_edit__none' => "なし",
    'mn_edit__not_create_pass' => "このアカウントのパスワードは生成されません。\nパスワードを設定しない限り、ユーザはメールを送受信できません。",
    'mn_edit__redir_email_invalid' => "転送先アドレスが無効です",
    'mn_edit__redirect_addr' => "転送先アドレス",
    'mn_edit__remove_autoresp?' => "自動応答を削除しますか？",
    'mn_edit__remove_rcpnts?' => "受信者を削除しますか？",
    'mn_edit__repository' => "リポジトリ",
    'mn_edit__resps_attach' => "自動応答の添付ファイル",
    'mn_edit__select_rcpnt_from_list' => "一覧から削除する受信者を 1 人以上選択します。",
    'mn_edit__select_registered_users' => "登録済みユーザの選択",
    'mn_edit__selected_postbox_have_not_setup_passwd' => "メールボックスのパスワードが設定されていません",
    'mn_edit__unable_act_deact_mail_group' => "メールグループをアクティブ化/非アクティブ化できません。%1",
    'mn_edit__unable_act_deact_mail_redir' => "メール転送をアクティブ化/非アクティブ化できません。%1",
    'mn_edit__unable_act_deact_postbox' => "メールボックスアクティブ化/非アクティブ化できません。%1",
    'mn_edit__unable_act_deact_resp' => "自動応答をアクティブ化/非アクティブ化できません。%1",
    'mn_edit__unable_add_attach' => "添付ファイルを追加できません。%1",
    'mn_edit__unable_add_mail_group_member' => "メールグループメンバを追加できません。%1",
    'mn_edit__unable_add_resp' => "自動応答を追加できません。%1",
    'mn_edit__unable_change_mail_name' => "メールアカウント名を変更できません。%1",
    'mn_edit__unable_deactivate_mail_group' => "メールグループを非アクティブ化できません。%1",
    'mn_edit__unable_deactivate_resp' => "自動応答メールを非アクティブ化できません。%1",
    'mn_edit__unable_define_resp_id' => "自動応答 ID を定義できません。%1",
    'mn_edit__unable_remove_attach' => "添付ファイルを削除できません。%1",
    'mn_edit__unable_remove_autoresp' => "自動応答を削除できません。%1",
    'mn_edit__unable_remove_mail_group_member' => "メールグループメンバを削除できません。%1",
    'mn_edit__wrong_way' => '%1 宛てのメッセージは配送されません。このメールアカウントに対してオンになっているメールボックスまたはメールフォワーダはありません。',
    'mn_edit__mailbox_is_disabled_mail_not_removed' => 'アドレス %1 のメールボックスがオフになりました。メールボックス内のメッセージは削除されていませんが、今後は IMAP または POP3 プロトコル経由で取得できなくなります。',
    'mn_list__mail_names_for_domain' => "ドメイン %1 のメールアカウント",
    'mn_list__sa_cannot_unable' => "スパムフィルタをオンにできません",
    'mn_list__tab_cp_access' => "L",
    'mn_list__tab_title_client' => '顧客',
    'mn_list__tab_title_domain' => 'ドメイン',
    'mn_list__tab_title_autoresp' => "A",
    'mn_list__tab_title_box' => "B",
    'mn_list__tab_title_group' => "G",
    'mn_list__tab_title_name' => "名前",
    'mn_list__tab_title_redirect' => "F",
    'mn_list__tab_title_spamfilter' => "S",
    'mn_list__tab_title_virusfilter' => 'AV',
    'mn_list__tab_title_drweb' => 'AV',
    'mn_list__unable_remove_mns' => "メールアカウントを削除することができません。%1",
    'module_upload__module_was_installed' => 'このモジュールは既にインストールされています。このモジュールの新しいバージョンをインストールしたい場合は、Plesk でモジュールをアンインストールしてから、インストールを試みてください。',
    'module_upload__unable_to_install' => 'モジュールパッケージファイルをインストールすることができません',
    'module_upload__wrong_package' => 'アップロードされたファイルは、サポートされているモジュールパッケージではありません',
    'module_upload__wrong_module' => 'アップロードされたファイルには、モジュールパッケージが含まれていません',

    'news_articles_title' => 'Plesk ニュース',
    'notification_text__invalid_subject_length' => "通知の件名の長さが無効です。1～255 文字にする必要があります。",
    'notification_text__invalid_text_length' => "無効な通知テキストの長さです。1 から 65533 文字の間で指定する必要があります。",
    'notification_text__subject' => "通知の件名",
    'notification_text__text' => "通知テキスト",
    'notification_text__title' => "通知の編集",
    'notification_text__unable_set_text' => "通知テキストを修正できません。",

    'odbc__cant_add_dsn' => "DSN %1を追加することができません。%2",
    'odbc__cant_connect' => "定義された設定でデータソースに接続することができません。サーバの返り値：%1",
    'odbc__cant_delete_dsn' => "DSN %1を削除することができません。%2",
    'odbc__cant_get_drivers_info' => "ドライバ情報を取得できません",
    'odbc__cant_get_drivers' => "ODBC ドライバのリストを取得できません。%1",
    'odbc__cant_open_info_file' => "ODBC ドライバ情報を含むファイルを開けません。",
    'odbc__cant_parse_string' => "接続文字列を解析できません",
    'odbc__driver_not_set' => "ドライバが設定されていません",
    'odbc__driver_or_name_not_set' => "ドライバまたは ODBC 接続名が設定されていません",
    'odbc__dsn_already_exists' => "システムにこの名前の DSN（%1）が既に存在します。",
    'odbc__dsn_not_exists' => "この DSN は存在しません",
    'odbc__enter_dsn_name' => "DSN 名の入力",
    'odbc__invalid_dsn_name' => "ODBC 接続名（%1）の構文エラー： 英数字のみを使用してください。",
    'odbc__no_such_driver' => "このような名前（%1）の ODBC ドライバはサポートされていません。",
    'odbc__unknown_driver' => "不明なドライバ名です（%1）。",
    'odbc_dsn_system' => "システムDSN",

    'pb__aliases' => "エイリアス",
    'pb__anonftp' => "匿名 FTP",
    'pb__autoinstaller_releases' => 'アップデータ',
    'pb__cert' => "証明書",
    'pb__cl_pool' => "IP アドレス",
    'pb__cl_pool_ctrl' => "%1",
    'pb__cl_pref' => "設定",
    'pb__cl_rpt' => "レポート",
    'pb__cl_rpt_list' => "カスタマイズ",
    'pb__cl_templates' => "顧客テンプレート",
    'pb__cl_traffic' => "トラフィック",
    'pb__cl_traffic_history' => "トラフィック履歴",
    'pb__cl_traffic_of' => "%1のトラフィック",
    'pb__client' => "%1",
    'pb__clients' => "顧客",
    'pb__comp_info' => "サーバコンポーネント",
    'pb__common_acl' => 'ACL の転送を許可する',
    'pb__cp_access' => "アクセス",
    'pb__crontab' => "スケジューラ",
    'pb__scheduler' => "スケジューラ",
    'pb__custom_buttons' => "カスタムボタン",
    'pb__databases_db' => 'データベース',
    'pb__sqlservers_db' => 'SQL サーバ',//to check
    'pb__db' => "データベース",
    'pb__db_edit' => "%1",
    'pb__db_server_edit' => '%1',
    'pb__db_servers' => 'データベースサーバ',
    'pb__dl_usr_ed' => "ドメイン管理者",
    'pb__dns' => "DNS",
    'pb__dns_template' => "DNS",
    'pb__dns_t' => "DNS",
    'pb__dom_ctrl' => "%1",
    'pb__dom_lim' => "ドメイン上限",
    'pb__dom_pref' => "設定",
    'pb__dom_sum_report' => "ドメイン概要レポート",
    'pb__dom_templates' => "ドメインテンプレート",
    'pb__dom_traffic' => "%1のトラフィック",
    'pb__domains' => "ドメイン",
    'pb__domain_aliases' => 'ドメインエイリアス',
    'pb__dumps_list' => "バックアップファイルストレージ",
    'pb__forwarding_setup' => "転送設定",
    'pb__filemanager' => "ファイルマネージャ",
    'pb__ip_aliasing' => "IP アドレス",
    'pb__ip_clients' => "IP アドレス削除",
    'pb__license_management' => 'ライセンス情報',
    'pb__locales' => 'ロケール',
    'pb__log_files' => "ログファイル",
    'pb__mail' => 'メール',
    'pb__mail_name_files' => "添付ファイル",
    'pb__mail_name_redirects' => "メール転送",
    'pb__mail_name_resp_attach_add' => "新しい添付ファイル",
    'pb__mail_name_resp_edit' => "%1",
    'pb__mail_name_responders' => "自動応答メール",
    'pb__mail_names' => "メール",
    'pb__maillists' => "メーリングリスト",
    'pb__mimetypes' => 'MIME タイプ',
    'pb__modules' => 'モジュール',
    'pb__modules_management' => 'モジュール管理',
    'pb__notifications' => "通知",
    'pb__odbc' => "ODBC",
    'pb__phosting_setup' => "物理ホスティング設定",
    'pb__prtd_dirs' => "保護ディレクトリ",
    'pb__prtdir_edit' => "%1",
    'pb__report' => "レポート",
    'pb__report_auto' => "%1の配信スケジュール",
    'pb__report_list' => "カスタマイズ",
    'pb__server' => "サーバ",
    'pb__sessions' => "セッション",
    'pb__sapp_pool' => "ウェブアプリケーションプール",
    'pb__siteapp_install' => 'ウェブアプリケーションのインストレーション',
    'pb__site_app_pkgs' => 'ウェブアプリケーション',
    'pb__site_apps' => "ウェブアプリケーション",
    'pb__additional_key_info' => 'キーのプロパティ',
    'pb__additional_key_properties' => 'キーのプロパティ',
    'pb__skeleton' => '仮想ホストテンプレート',
    'pb__skins' => 'スキン',
    'pb__skin_info' => '%1',
    'pb__spamassassin' => "スパムフィルタ",
    'pb__statistics' => "統計",
    'pb__subdom_ctrl' => "%1",
    'pb__subdomains' => "サブドメイン",
    'pb__templates' => "テンプレート",
    'pb__virtualdirs' => '仮想ディレクトリ',
    'pb__web_users' => "ウェブユーザ",
    'pdir__enter_dir_name' => "ディレクトリ名の入力",
    'pdir__invalid_hst' => "ホスティングタイプが無効です。物理ホスティングを指定してください",
    'pdir__pd_id_is_undefined' => "保護ディレクトリ ID が定義されていません",
    'pdir__pdir_exist' => "同名の保護ディレクトリが存在し保護されています。",
    'pdir__pdir_not_exist' => "保護ディレクトリが存在しません",
    'pdir__pdir_usr_not_exist' => "保護ディレクトリユーザが存在しません",
    'pdir__prdirs_for_domain' => "%1 の保護ディレクトリ",
    'pdir__prdirs_for_subdomain' => "サブドメイン %1 の保護ディレクトリ",
    'pdir__remove_pdir_usrs' => "ウェブサイト %1 の保護ディレクトリ %2 の、以下のユーザが削除されます。",
    'pdir__remove_pdir_usrs_on_subdom' => "サブドメイン %1 の保護ディレクトリ %2 の、以下のユーザが削除されます。",
    'pdir__remove_pdirs_on_dom' => "この操作により、顧客 %1 が所有するウェブサイト %2 からディレクトリ保護が解除されますが、ディレクトリ自体は削除されません。",
    'pdir__remove_pdirs_on_subdom' => "この処理によって、サブドメイン %1 のディレクトリ保護が解除されます。 ディレクトリは削除されません。",
    'pdir__select_pdir_usrs_for_remove' => "削除する保護ディレクトリユーザの選択",
    'pdir__select_pdirs_to_remove' => "保護フォームを削除するディレクトリを選択する",
    'pdir__unable_define_pdir_users' => "保護ディレクトリユーザを定義できません",
    'pdir__unable_define_pdirs_properties' => "保護ディレクトリのプロパティを設定できません。%1",
    'pdir__unable_select_dom_param' => "ドメインパラメータを選択できません。%1",
    'pdir_ed__create_pdir_for_domain' => "%1 の下に保護ディレクトリを作成",
    'pdir_ed__create_pdir_for_subdomain' => "サブドメイン %1 下に保護ディレクトリを作成",
    'pdir_ed__dir_already_protect' => "このディレクトリは既に保護されています。",
    'pdir_ed__head_txt' => "保護エリアのタイトル",
    'pdir_ed__invalid_login' => "入力したユーザ名が無効です",
    'pdir_ed__login_exists' => "このユーザは既に存在します。 別のユーザ名を指定してください。",
    'pdir_ed__new_usr' => "ユーザ名",
    'pdir_ed__non_ssl' => "非 SSL/TLS",
    'pdir_ed__cgi_bin' => "cgi-bin",
    'pdir_ed__path' => "ディレクトリ名",
    'pdir_ed__pdir_for_domain' => "ドメイン %2 の保護ディレクトリ %1",
    'pdir_ed__pdir_for_subdomain' => "サブドメイン %2 の保護ディレクトリ %1",
    'pdir_ed__pdir_location' => "ディレクトリの位置",
    'pdir_ed__pdir_users' => "保護ディレクトリユーザ",
    'pdir_ed__ssl' => "SSL/TLS",
    'pdir_ed__ssl_or_nonssl_should_be_checked' => "SSL/TLS チェックボックスまたは非 SSL/TLS チェックボックスのどちらかまたは両方を選択してください",
    'pdir_ed__unable_cr_pdir_usr' => "保護ディレクトリユーザを作成することができません。%1",
    'pdir_ed__unable_create_pdir' => "保護ディレクトリを作成することができません。%1",
    'pdir_ed__unable_define_hst_type' => "ホスティングタイプを定義できません",
    'pdir_ed__unable_update_pdir' => "保護ディレクトリの設定を保存できません。 %1",
    'pdir_ed__wrong_symbol_in_header' => "ディレクトリタイトルに文字 %1 を使用しないでください",
    'pdir_usr_ed__create_pdir_usr_for_pd' => "保護ディレクトリ %1 のユーザ作成",
    'pdir_usr_ed__not_create_pass' => "新しい保護ディレクトリユーザのパスワードは作成されません。ユーザがログインするためには、パスワードを指定する必要があります。",
    'pdir_usr_ed__pass_for_pdir_usr' => "保護ディレクトリユーザのパスワード：%1",
    'pdir_usr_ed__unable_select_pdir_usr' => "保護ディレクトリユーザを選択することができません。%1",
    'pdir_usrs_list__unable_define_pdir_usrs' => "保護ディレクトリユーザを定義することができません。%1",
    'pdir_usrs_list__unable_remove_pd_usrs' => "保護ディレクトリユーザを削除することができません。%1",
    'pdirs_list__name' => "名前",
    'pdirs_list__tab_title_non_secure_dir' => "N",
    'pdirs_list__tab_title_secure_dir' => "S",
    'pdirs_list__tab_title_cgi_bin_dir' => "C",
    'pdirs_list__unable_remove_pdirs' => "保護ディレクトリを削除することができません。%1",
    'phosting__anonftp_encrypt' => 'FTP ユーザのパスワードは暗号化されており、ディレクトリ /plesk-stat/webstat/ の保護に使用できません。FTP パスワードを再入力するか、［パスワード保護ディレクトリ「/plesk-stat/webstat/」からアクセス可能］オプションをオフにしてください。',
    'phosting__hosting_and_dns_ip_difference_warning' => "ドメイン名 %%domain_name%% は IP アドレス %%dns_ip_address%% に変換されます。 ウェブサイトは IP アドレス %%hosting_ip_address%% に割り当てられています。 ウェブサイトをウェブブラウザよりドメイン名で参照できない場合、DNS 管理画面（［ドメイン］> ドメイン名 >［DNS］）に移動し、A リソースレコードのプロパティを変更してください（ドメイン名 %%domain_name%% に IP アドレス %%hosting_ip_address%% を割り当ててください）。",
    'phosting__ip_change_warning' => "IP アドレスが変更され、関連する変更がドメインの DNS ゾーンに適用されました。",
    'phosting__other_hosting_exists_on_ip' => "この IP アドレスが他のホスティングアカウントでも使用されているため、証明書を変更することができません",
    'phosting__unable_to_change_certificate' => "証明書をインストールできません。%1",
    'phosting__unable_to_change_ip_address' => "IP アドレスを変更できません。%1",
    'phosting__unable_to_set_cert' => "SSL/TLS 証明書を設定できません。%1",
    'phosting__unable_update' => "ホスティング設定を更新できません。%1",
    'phosting__unable_manage' => "ホスティングを管理できません。%1",
    'phosting__failed_to_add_logs_fail2ban' => "ドメインのログを追跡するように fail2ban を構成できませんでした。fail2ban サービスの次回の再起動時に、ログは自動的に追跡されます。\n%1",

    'picker_acl_record__tittle' => 'ACL レコードを選択する',
    'picker_autoresponder__title' => '自動返信を選択する',
    'picker_black_list__domain_name' => 'ドメイン名を選択する',
    'picker_certificate' => 'SSL/TLS 証明書を選択',

    'picker_dns_zone_template__title' => 'リソースレコードの選択',
    'picker_domain__title' => 'ウェブサイトを選択します。',
    'picker_domain_alias__title' => 'ドメインエイリアスの選択',
    'picker_resource_record__title' => 'リソースレコードの選択',
    'picker_disabled_resource_record__title' => 'ネームサーバを選択',
    'picker_ip_address__title' => 'IP アドレスを選択する',
    'picker_ip_address_clients__title' => 'この IP アドレスを使用する顧客を選択します。',
    'picker_mail_queue' => 'メールメッセージを選択',
    'picker_site_application__title' => 'ウェブアプリケーションの選択',
    'picker_subdomain__title' => 'サブドメインを選択する',
    'picker_web_user__title' => 'ウェブユーザを選択する',
    'picker_custom_button__title' => 'カスタムボタンを選択する',
    'picker_license_key__title' => "ライセンスキー選択",
    'picker_spamfilter_address__title' => 'スパムフィルタアドレスを選択する',
    'picker_white_list__networks' => 'ネットワーク選択',

    'plesk_key__action_logs' => "Plesk ユーザが実行するアクションのロギング",
    'plesk_key__app_vault' => "アプリケーションヴォルト",
    'plesk_key__backup' => "バックアップおよび復元機能",
    'plesk_key__client_templs' => "サーバプラン管理",
    'plesk_key__clients' => "ユーザアカウント（リセラーと顧客）",
    'plesk_key__resellers_only' => "ユーザアカウント(リセラー)",
    'plesk_key__customers_only' => "ユーザアカウント（顧客）",
    'plesk_key__domains' => "ドメイン",
    'plesk_key__domain_aliases' => "ドメインエイリアス",
    'plesk_key__manage_dashboard' => 'ホームページのカスタマイズ',
    'plesk_key__drweb' => "アンチウイルス管理",
    'plesk_key__event_manager' => "イベントマネージャ",
    'plesk_key__expirations' => "アカウント有効期限を管理",
    'plesk_key__group_ops' => "複数のオブジェクトを一括変更",
    'plesk_key__expiration' => "キーの有効期限",
    'plesk_key__edition_name' => "Plesk エディション",
    'plesk_key__key_number' => "キー番号",
    'plesk_key__languages' => "言語パック",
    'plesk_key__mailnames' => "メールアカウント",
    'plesk_key__migration_manager' => "移行・移管マネージャ",
    'plesk_key__mssql' => "Microsoft SQL サーバのサポート",
    'plesk_key__myplesk_func' => "SSL/TLS 証明書およびドメイン登録サービスの購入用リンク",
    'plesk_key__myplesk_server_id' => "MyPleskスレーブサーバ識別子",
    'plesk_key__notifications' => "通知管理",
    'plesk_key__postgresql' => "PostgreSQL データベースサーバのサポート",
    'plesk_key__qmail_queue' => 'メールキュー管理',
    'plesk_key__remote_db' => 'リモートデータベースホスティング',
    'plesk_key__slave_servers' => "スレーブサーバ",
    'plesk_key__spamassassin' => "スパムフィルタ管理",
    'plesk_key__subdomains' => "サブドメイン管理",
    'plesk_key__sys_access' => "サーバアクセスの管理",
    'plesk_key__traffic_reports' => "トラフィック使用量レポート",
    'plesk_key__tts' => "ヘルプデスク",
    'plesk_key__virtuozzo' => "Virtuozzo containers でのみ有効",
    'plesk_key__webusers' => "ウェブユーザ",
    'plesk_key__license_update_date' => '次回のライセンスキーアップデート',
    'plesk_key__autoinstaller_config' => 'アップデータ設定管理',
    'plesk_key__check_wrong' => "ライセンスキーが無効です。Plesk を使用するには、新しい有効なライセンスキーを入手してインストールしてください。",
    'plesk_key__upload_check_wrong' => 'アップロードされたライセンスキーは有効ではありません',
    'plesk_key__revert_check_wrong' => '以前インストールされたライセンスキーは有効ではありません',
    'plesk_key__update_check_wrong' => 'アップデートされたライセンスキーは有効ではありません',
    'plesk_key__viruozzo_only_key' => 'このライセンスキーは、Virtuozzo containers 環境内の Plesk でのみ使用できます。',
    'plesk_key__ip_ranges_exceeded' => 'このライセンス付与された Plesk では、次の IP アドレスのみ使用することができます。%2。次の IP アドレスは、お持ちのライセンスの対象ではありません。%1。', //%1 not allowed addresses list separated by comma, %2 allowed IP addresses list separated by comma
    'plesk_key__limits_exceeded' => '現在のリソース使用量が、ライセンスに定義された上限を超えています。',
    'plesk_key__wp-toolkit-deluxe' => 'WP Toolkit Deluxe',
    // For the keys below: %1 limit value, %2 used value, %3 delta value
    'plesk_key__limits_exceeded_lim_dom' => 'サーバでホスティングしているウェブサイト数が、ライセンスで定義している上限を超過しています。 %2 サイトをホスティングしていますが、ライセンスが許可しているのは %1 サイトのみです。',
    'plesk_key__limits_exceeded_lim_domain_aliases' => 'サーバ上のドメインエイリアス数はライセンスにおける定義数を超過しています。現在 %2 ドメインエイリアス存在しますが、ライセンスにおいては %1 ドメインエイリアスのみ許可されています。',
    'plesk_key__limits_exceeded_lim_cl' => 'サービス提供されている顧客アカウント数が、ライセンスで定義している上限を超過しています。 現在 %2 顧客アカウントにサービス提供していますが、ライセンスが許可しているのは %1 顧客アカウントのみです。',
    'plesk_key__limits_exceeded_lim_mn' => '提供されているメールアカウント数が、ライセンスに定義された上限を超えています。現在、%2 件のメールアカウントを利用されていますが、ライセンスでは %1 件までしか許可されていません。',
    'plesk_key__limits_exceeded_lim_wu' => '提供されているウェブユーザアカウント数が、ライセンスに定義されている制限を超過しています。現在提供しているウェブユーザアカウント数は %2 件ですが、ライセンスで提供が許可されているのは %1 件のみです。',
    'plesk_key__limits_exceeded_MLS' => 'サーバ上の言語パック数がライセンスによる制限値を超過しています。現在 %2 言語パック存在しますが、ライセンスにおいては %1 言語パックのみ許可されています。',
    'plesk_key__wrong_version' => '他の Plesk バージョン用に作成されたライセンスキーを使用しようとしています。Plesk 営業担当までご相談のうえ、適切なライセンスキーをご購入ください。',
    'plesk_key__other_product' => '他の製品用に作成されたライセンスキーを使用しようとしています。Plesk 営業担当までご相談のうえ、適切なライセンスキーをご購入ください。',
    'plesk_key__invalid_machine_id_trial' => '現在のライセンスは有効ではありません。別の Plesk サーバ上で既にアクティブ化されているためです。Plesk の使用を続けるには、新しいライセンスをインストールするか、アクティベーションコードがもしあれば入力して現在のライセンスをもう一度インストールしてください。',
    'plesk_key__invalid_machine_id_retail' => '現在のライセンスは有効ではありません。別の Plesk サーバ上で既にアクティブ化されているためです。Plesk の EULA（https://www.plesk.com/legal/）では、単一のライセンスを 2 つ以上のサーバで同時に使用することが禁止されています。Plesk の使用を続けるには、新しいライセンスをインストールするか、アクティベーションコードを入力して現在のライセンスをもう一度インストールしてください。アクティベーションコードはライセンスの購入時に送信されています。<br>アクティベーションコードが見つからない場合は、Plesk 360 を使用して確認できます。ライセンスの購入に使用したメールアドレスで https://platform360.io/ にログインして、［Licenses］タブに移動すると、ライセンスのアクティベーションコードが表示されます。あるいは、オンラインフォーム（https://www.plesk.com/licensing-and-purchase-support/）で Plesk ライセンス・購入サポートまでお問い合わせください。フォームの「How can we help you?」（どのようなサポートが必要ですか？）欄でライセンス番号を必ずお知らせください。',
    'plesk_key__limits_exceeded_error' => 'ライセンスキーをインストールできません。現在、アップロードされたライセンスキーの許容範囲を超えたリソースを使用しています。',
    'plesk_key__limits_exceeded_note' => '現在、アップロードされたライセンスキーの許容範囲を超えたリソースを使用しています。',
    'plesk_key__key_file_invalid' => 'アップロードされたキーファイルは有効ではないか、またはライセンスキーが含まれていません',
    'plesk_key__server_request_error' => 'ライセンスを更新できませんでした。ライセンスサーバ ka.plesk.com への接続が TCP ポート番号 %1 でブロックされていないか確認してください。<a href="https://support.plesk.com/hc/en-us/articles/12388137260695" target="_blank">方法を確認</a>',
    'key__no_key_file_in_zip' => 'アップロードされた .zip ファイルにキーファイルが含まれません',
    'key__key_upload' => 'ライセンスキーのインストール',
    'additional_key__prop_name' => 'プロパティ',
    'additional_key__prop_value' => '値',
    'additional_key__descr_name' => 'キー名',
    'additional_key__descr_key_number' => 'キー番号',
    'additional_key__descr_key_vz' => "このライセンスキーは、Virtuozzo containers のみを対象としています。",
    'additional_key__descr_key_mailboxes' => 'メールボックス',
    'additional_key__descr_lim_date' => '有効期限',
    'additional_key__descr_license_update_date' => '次回のライセンスキーアップデート',
    'additional_key__file_invalid' => 'アップロードされたキーファイルは有効ではないか、またはライセンスキーが含まれていません',
    'additional_key__file_incompatible' => 'アップロードされたキーファイルは、このアプリケーションで有効ではありません',
    'additional_key__expired' => 'この追加キーの期限が切れました',
    'additional_key__not_exists' => 'ライセンスキーはインストールされていません',
    'additional_key__viruozzo_only_key' => 'このライセンスキーは、Virtuozzo containers にインストールされた Plesk のみを対象としています。',
    'additional_key_update__result_response' => 'ライセンスサーバの応答：%1',
    'additional_key_update__result_network' => 'ライセンスサーバに接続することができません。ネットワークが %1 への接続を許可しているか確認してください。%2',
    'additional_key_update__result_lock' => 'キーアップデートは既に実行中です',
    'additional_key_update__result_internal_error' => 'ライセンスキーのアップデート中エラーが発生しました。%1',

    'proceed_to_cl_pool' => "顧客の IP プール設定に進む",
    'proceed_to_hosting_setup' => "ホスティング設定に進む",
    'removeCerts__remove_certificates_cp' => "次の証明書が削除されます。",
    'removeCerts__remove_certificates_domain' => "%1の次の証明書が削除されます。",
    'removeClientsIP_remove_clients_ip' => "この IP アドレスは、次の顧客のプールから削除されます。",
    'removeMailAliases__remove_mail_aliases' => "メールアカウント%1 における以下のメールエイリアスが削除されます。",
    'removeMailNames__remove_mailnames' => "ドメイン %1 における以下のメールアカウントおよびエイリアスが削除されます。",
    'removeMailNames__remove_mailnames_of_cl' => "顧客 %1 が所有するドメイン %2 から、以下のメールアカウントとエイリアスが削除されます。",
    'removeMailNames__these_mailnames_will_not_delete' => "これらのメールアカウントは削除されません。",
    'removeFtpSessions__remove_title' => "以下の FTP セッションは切断されます。",
    'removeTemplates__remove_templates' => "次のテンプレートが削除されます。",
    'report_auto__list_title' => 'D',
    'report_auto__list_auto' => '頻度',
    'report_auto__list_last' => '最終配信日',
    'report_auto__list_recipient' => '宛先',
    'report_auto__list_select' => 'レポート先',
    'report_auto__title' => '%1の配信スケジュール',
    'report_auto__recipient_email' => '指定したメールアドレス',
    'report_auto__recipient_admin' => 'サーバ管理者',
    'report_auto__recipient_client' => '顧客',
    'report_auto__recipient_domain' => 'ドメイン管理者',
    'report_auto_edit__select' => 'レポート先',
    'report_auto__select_client_report_all' => 'すべての顧客',
    'report_auto__select_client_report_current' => 'この顧客',
    'report_auto__select_client_report_other_client' => '%1',
    'report_auto__select_domain_report_all' => 'すべてのドメイン',
    'report_auto__select_domain_report_other_client' => '%1 のすべてのドメイン',
    'report_auto__select_domain_report_client' => 'この顧客の全ドメイン',
    'report_auto__select_domain_report_reseller' => 'このリセラーのすべてのドメイン',
    'report_auto__select_domain_report_current' => 'このドメイン',
    'report_auto__select_domain_report_other_domain' => '%1',
    'report_auto__legend' => '配信スケジュール',
    'report_auto__select_for_remove' => "削除する配信スケジュールを選択してください",
    'report_auto_remove__title' => "削除対象のレポート配信スケジュール：",
    'report_auto_edit__title' => '配信スケジュールのプロパティ',
    'report_auto_edit__recipient' => '宛先',
    'report_auto_edit__target' => 'レポート先',
    'report_auto_edit__auto' => '配信頻度',
    'resp_edit__always_respond' => "常に返信します。",
    'resp_edit__reply_subject' => "返信の件名",
    'resp_edit__answer_subject' => "返信時の件名",
    'resp_edit__answer_txt' => "返信テキスト",
    'resp_edit__attach' => "ファイル添付",
    'resp_edit__default_subject' => "Re: %1",
    'resp_edit__for' => "for",
    'resp_edit__frw_rqst_email' => "自動応答時に、オリジナルメッセージを指定メールアドレスに転送",
    'resp_edit__fwd_email_invalid' => "宛先メールアドレスが無効です。",
    'resp_edit__in_body' => "-本文中に-",
    'resp_edit__in_subject' => "-件名中に-",
    'resp_edit__invalid_resp_freq' => "応答頻度が無効です",
    'resp_edit__invalid_rqst_txt' => "無効な要求テキスト",
    'resp_edit__invalid_store_lim_num' => "制限値が無効です",
    'resp_edit__limits_title' => "上限",
    'resp_edit__maximum_allowed_resp_freq_reached' => "一日あたりの上限応答数が、定義された値を超過しました。指定：%1、要求：%2",
    'resp_edit__no_files_sel' => "ファイルが選択されていません",
    'resp_edit__no_txt_supplied' => "テキストが入力されていません",
    'resp_edit__reply_title' => "返信",
    'resp_edit__reply_to_address' => "返信先アドレス",
    'resp_edit__reply_to_invalid' => "返信先アドレスが正しくありません",
    'resp_edit__reply_uniq_email' => "同一のアドレスへの返信上限回数：",
    'resp_edit__conditions_title' => "状態",
    'resp_edit__request_title' => "リクエスト",
    'resp_edit__resp' => "自動応答",
    'resp_edit__resp_name' => "自動応答名",
    'resp_edit__resp_not_exist' => "自動応答が存在しません。",
    'resp_edit__resp_status' => "自動応答のステータス",
    'resp_edit__rqst_txt' => '指定ワード',
    'resp_edit__select_files_on_server_for_attach' => "添付ファイルを選択",
    'resp_edit__store_up_to' => "保存-",
    'resp_edit__subj_line_invalid' => "件名ラインが無効です",
    'resp_edit__text_too_big' => "返信メッセージテキストが長すぎます。",
    'resp_edit__times_in_a_day' => "回/日",
    'resp_edit__unable_define_resp_cond' => "自動応答の状態を定義できません。%1",
    'resp_edit__unable_define_resp_status' => "自動応答のステータスを定義できません。%1",
    'resp_edit__unable_turn_on_resp' => "自動応答を有効にできません。%1",
    'resp_edit__uniq_email' => "同一のメールアドレス",
    'resp_edit__content_type' => 'メール送信時のフォーマット',
    'resp_edit__content_type_text' => 'テキスト',
    'resp_edit__content_type_html' => 'HTML メール',
    'resp_edit__charset' => 'エンコーディング',
    'restart__dns' => 'DNS サーバ（%1）',
    'restart__drweb' => 'Plesk Premium Antivirus',
    'restart__mail' => "IMAP/POP3 サーバ（%1）",
    'restart__mssql' => "Microsoft SQL server",
    'restart__mysql' => "MySQL サーバ",
    'restart__postgresql' => "PostgreSQL",
    'restart__psa' => "サービス",
    'restart__smtp' => "SMTP サーバ（%1）",
    'restart__spamd' => "スパムフィルタ",
    'restart__spamassassin' => "SpamAssassin",
    'restart__stunnel' => "Stunnel",
    'restart__web' => "ウェブサーバ（%1）",
    'restart__ftp' => "FTP サーバ（%1）",
    'restart__service_start' => 'サービスが起動するまで、しばらくお待ちください。',
    'restart__service_stop' => 'サービスが停止するまで、しばらくお待ちください。',
    'restart__service_restart' => 'サービスが再起動するまで、しばらくお待ちください。',
    'rm_domains__some_domains_are_not_exist' => "指定したドメインのうち存在しないものがあります。 他のユーザが削除した可能性があります。",
    'rpt_cl_dom_data_bases' => "DBMySQL",
    'rpt_cl_dom_mssql_data_bases' => "DBMSSQL",
    'rpt_cl_dom_mail_groups' => "メールグループ",
    'rpt_cl_dom_mail_lists' => "メーリングリスト",
    'rpt_cl_dom_mail_resps' => "自動応答",
    'rpt_cl_dom_mail_antispam' => "アンチスパム",
    'rpt_cl_dom_mail_antivirus' => "アンチウイルス",
    'rpt_cl_dom_postboxes' => "メールボックス",
    'rpt_cl_dom_redirects' => "フォワーダ",
    'rpt_cl_dom_subdomains' => "サブドメイン",
    'rpt_cl_dom_domain_aliases' => "ドメインエイリアス",
    'rpt_cl_dom_web_users' => "ウェブユーザ",
    'rpt_cl_report_for_admin__' => "管理者 %1 のレポート",
    'rpt_cl_report_for_reseller__' => "リセラー %1 のレポート",
    'rpt_cl_report_for_cl__' => "顧客 %1 のレポート",
    'rpt_cl_section_domains' => "ドメイン",
    'rpt_cl_section_full_domains' => "ドメイン",
    'rpt_cl_section_general' => "全般",
    'rpt_create' => "レポート作成",
    'rpt_empty' => "レポートには 1 つ以上のセクションが含まれる必要があります。",
    'rpt_default_report' => "デフォルトレポートとして使用",
    'rpt_dom_report_for_dom__' => "ドメイン %1 のレポート",
    'rpt_dom_section_databases' => "データベース",
    'rpt_dom_section_full_databases' => "データベース",
    'rpt_dom_section_full_maillists' => "メーリングリスト",
    'rpt_dom_section_full_mailnames' => "メールアカウント",
    'rpt_dom_section_full_webusers' => "ウェブユーザ",
    'rpt_dom_section_full_siteapps' => 'ウェブアプリケーション',
    'rpt_dom_section_full_aspnetapps' => 'ASP.NET ウェブアプリケーション',
    'rpt_dom_section_general' => "全般",
    'rpt_dom_section_hosting' => "ホスティング",
    'rpt_dom_section_maillists' => "メーリングリスト",
    'rpt_dom_section_mailnames' => "メールアカウント",
    'rpt_dom_section_siteapps' => 'ウェブアプリケーション',
    'rpt_dom_section_aspnetapps' => 'ASP.NET ウェブアプリケーション',
    'rpt_dom_section_webusers' => "ウェブユーザ",
    'rpt_dom_title_wa_status' => "S",
    'rpt_edit__' => "レポート %1 を編集",
    'rpt_enter_email_address' => "レポート送信先のメールアドレスを入力します。",
    'rpt_list' => "カスタムレポートレイアウト",
    'rpt_name' => "レポート名",
    'rpt_remove_reports' => "以下のレポートレイアウトは削除されます。",
    'rpt_reports' => "レポート",
    'rpt_section_full' => "フル",
    'rpt_section_none' => "なし",
    'rpt_section_summary' => "概要",
    'rpt_select_reports_for_remove' => "削除するレポートレイアウトの選択",
    'rpt_default_full' => '詳細レポート',
    'rpt_default_summary' => '概要レポート',

    // end of kooper part

    // pit part

    'rpt_send_report_by_email_error__' => "レポートの送信時にエラーが発生しました。%1",
    'rpt_send_report_by_email_ok__' => "レポートは %1 に送信されました",
    'sa_action' => "アクション",
    'sa_action_del' => "削除",
    'sa_action_desc' => "スパムメールの処理",
    'sa_action_save' => "スパムとしてマークし、メールボックスに保存する",
    'sa_admin_blacklist' => "管理者のブラックリスト",
    'sa_admin_whitelist' => "管理者のホワイトリスト",
    'sa_db_del_confirm' => "スパムフィルタデータベースをクリアしますか？",
    'sa_eml_in_ignorelist' => "メールアドレスは拒否リストに含まれています。",
    'sa_empty_email' => "空のメールパターンは追加できません。",
    'sa_exists_email' => "このメールパターンは既に存在します。",
    'sa_disabled__mailname_not_filtering' => "現在のサーバ設定では、このメールアカウントにおけるメールフィルタリングが許可されていません",
    'sa_disabled__filtering_is_disabled' => 'スパムフィルタはサーバ管理者によってオフになっています',
    'sa_disabled__hasnt_mailbox' => "メールボックスなしに、スパムフィルタリングをオンにすることはできません",
    'sa_enable_filter' => "スパムフィルタをオンにする",
    'sa_forget' => "無視",
    'sa_from' => "From",
    'sa_ham' => "ham",
    'sa_pattern_is_invalid' => "パターンは適切でありません",
    'sa_spam' => "スパム",
    'sa_trainer__page_title' => 'スパムフィルタの学習',
    'sa_trainer__tools_legend' => 'ツール',
    'sa_trainer__info_legend' => '情報',
    'sa_trainer__messages_list_legend' => 'メールボックス内のメッセージ',
    'sa_trainer__c' => 'T',
    'sa_trainer__l' => 'L',
    'sa_trainer__subject' => '件名',
    'sa_trainer__from' => 'From',
    'sa_trainer__date' => '日付',
    'sa_trainer__info_text' => '学習済みメッセージ：全 %3 件のうち、%1 がスパムであり %2 件はスパムではありません。',
    'sa_trainer__messages' => 'メッセージ',
    'sa_trainer__select__all' => 'すべて',
    'sa_trainer__select__spam_only' => 'スパム',
    'sa_trainer__select__ham_only' => 'スパムではない',
    'sa_trainer__select__unknown_only' => '不明',
    'sa_trainer__cannot_remove_messages' => '選択されたメッセージをメールボックスから削除できません',
    'sa_trainer__remove_messages_confirm' => '選択したメッセージをメールボックスから削除しますか？',
    'sa_subj' => "件名",
    'sa_training' => "スパムフィルタの学習",
    'sa_training_legend' => "ベイジアンフィルタの学習",
    'sa_use_srv_settings' => "サーバ全体の設定を使用",
    'sa_user_blacklist' => "ユーザのブラックリスト",
    'sa_user_whitelist' => "ユーザのホワイトリスト",
    'sa_usr_disabled_by_srv' => "サーバ管理者により、個々のスパムフィルタ設定が許可されていません",
    'sa_usr_no_postbox' => "スパムフィルタを有効化できません。このメールアカウントではメールボックスがオフになっています。",
    'sa_filters' => 'スパムフィルタ',
    'spamfilter__tools_legend' => 'ツール',
    'spamfilter__prefs_legend' => '設定',
    'spamfilter__max_children' => '実行するワーカ spamd プロセスの最大数',
    'spamfilter__rewrite_header_subject_hint' => 'テキストを追加したくない場合は、このフィールドを空白のまま残してください。メッセージの件名にスコアを含めたい場合は、_SCORE_ と入力してください。',
    'spamfilter__reject_spam' => 'メールボックスでの受信時にスパムを削除する',
    'spamfilter__enabled' => 'オン',
    'spamfilter_addresses_list__tools_legend' => 'ツール',
    'spamfilter_addresses_list__list_legend' => 'アドレス',
    'spamfilter_addresses_list__items' => 'アドレス',
    'spamfilter_addresses_list__status' => 'S',
    'spamfilter_addresses_list__level' => 'L',
    'spamfilter_addresses_list__address' => 'アドレス',
    'spamfilter_addresses__file_legend' => 'ファイルより取得',
    'spamfilter_addresses__file_label' => 'ファイル名',
    'spamfilter_addresses__file_hint' => 'UTF-8 エンコーディングでファイルをアップロードする',
    'spamfilter_addresses__text_legend' => 'リストより取得',
    'spamfilter_addresses__text_label' => 'メールアドレス',
    'spamfilter_addresses__remove_title' => '以下のアドレスが一覧から削除されます。',
    'spamfilter_addresses__empty_selection' => 'アドレスが選択されていません',
    'server__admin_info' => "管理者情報",
    'server__ctrl_panel' => "Plesk",
    'server__enter_bug_essence_below' => "以下にバグの詳細を入力してください",
    'server__power_management' => "電源管理",
    'server__services' => "サービス",
    'server__system' => "システム",
    'server__title' => "サーバ管理",
    'server_preferences__admin_skin' => "管理者インターフェーススキン",
    'server_preferences__default_language' => "デフォルト言語",
    'server_preferences__default_skin' => "デフォルトスキン",
    'server_preferences__restart_apache_interval' => "Apache 再起動間隔",
    'server_preferences__system' => 'システム設定',
    'mail__tabs_preferences' => "設定",
    'mail__tabs_white_list' => "ホワイトリスト",
    'server_preferences__use_vocabulary' => "メールボックスのパスワードが推測されやすい値かチェックする",
    'sessions__agreement' => "はい、これらのセッションを切断します。",
    'sessions__select_sessions_for_remove' => "切断するセッションの選択",
    'sessions__tabs_cp_sessions' => 'Plesk セッション',
    'sessions__tabs_ftp_sessions' => 'FTP セッション',
    'sessions__ftp_sessions_login' => 'FTP アカウントユーザ名',
    'sessions__ftp_sessions_domain' => 'ドメイン名',
    'sessions__ftp_sessions_path' => '現在のロケーション',
    'sessions__ftp_sessions_file' => 'ファイル名',
    'sessions__ftp_sessions_action' => 'ステータス',
    'sessions__ftp_sessions_speed' => '速度（KB/秒）',
    'sessions__ftp_sessions_comp' => '進捗（%）',

    'site_apps__access_level' => 'アクセスレベル',
    'site_apps__access_level_commercial' => '有料',
    'site_apps__access_level_free' => '無料',
    'site_apps__action_installer' => "ウェブアプリケーションのインストレーション",
    'site_apps__action_reconfigure' => "ウェブアプリケーション再構成",
    'site_apps__custom_button_level' => 'このアプリケーションにアクセスするためのカスタムボタンを作成しますか？',
    'site_apps__custom_button_level_false_domain_user_only' => 'いいえ',
    'site_apps__custom_button_level_domain_user_only' => 'はい',
    'site_apps__custom_button_level_false' => 'いいえ',
    'site_apps__custom_button_level_domain' => 'はい。現在のドメインでのみ使用可能にする',
    'site_apps__custom_button_level_client' => 'はい。顧客の全ドメインで使用可能にする',
    'site_apps__custom_button_level_admin' => 'はい。すべてのドメインで使用可能にする',
    'site_apps__description' => "説明",
    'site_apps__dir_used_by_sapp__' => "ディレクトリ「%1」は他のウェブアプリケーションに使用されています。",
    'site_apps__dir_used_by_unknown__' => "ディレクトリ「%1」は既に存在します。続行するとコンテンツは上書きされます。",
    'site_apps__dir_invalid_name__' => "ディレクトリ名 %1 が無効です",
    'site_apps__file_name' => 'ウェブアプリケーションファイル名',
    'site_apps__invalid_install_prefix' => "無効なインストレーションプレフィックス",
    'site_apps__invalid_package' => "ウェブアプリケーションが無効です",
    'site_apps__key_status' => 'ライセンシング',
    'site_apps__key_status_free' => '自由に頒布可能です。ライセンスキーは必要ありません',
    'site_apps__key_status_ok' => '必要なライセンスキーはインストールされています。',
    'site_apps__key_status_problem' => '必要なライセンスキーがインストールされていません',
    'site_apps__name' => "名前",
    'site_apps__no_domains' => 'ウェブアプリケーションをインストールできません。このドメインのルートディレクトリに、他のウェブアプリケーションが既にインストールされています。ウェブアプリケーション用にサブドメインを作成してください',
    'site_apps__package_info_' => "ウェブアプリケーション情報",
    'site_apps__package_integrated' => "ビルドインアプリケーションであり、削除できません",
    'site_apps__pool_select_packages_to_add' => 'プールに追加するウェブアプリケーションを選択する',
    'site_apps__release' => "リリース",
    'site_apps__resource_used_by_sapp' => "このリソースはインストール済みウェブアプリケーションに使用されています。",
    'site_apps__root_used_by_sapp' => "このリソースはインストールされているウェブアプリケーションによって使用されています。",
    'site_apps__these_domains_will_not_delete' => 'これらの（サブ）ドメインは削除されません',
    'site_apps__upload_site_app_pkg_title' => '新しいウェブアプリケーションのアップロード',
    'site_apps__version' => "バージョン",
    'site_apps__access_to' => "%1 へアクセス",
    'site_builder_requires' => '%1 - %3',
    'skeleton__admin_label' => "仮想ホストテンプレート",
    'skeleton__client_label' => "%1 仮想ホストテンプレート",
    'skeleton__admin_page' => "仮想ホストテンプレートを管理",
    'skeleton__files_list' => "ファイルとディレクトリ",
    'skeleton__archiver_not_installed' => "アーカイブを展開できません。サーバ上に解凍用ソフトウェアがインストールされていない可能性があります。 {$PROD_NAME} の管理者まで連絡し、解凍用ソフトウェアがインストールされているかご確認ください",
    'skeleton__client_page' => "仮想ホストテンプレートを管理",
    'skeleton__archive_corrupted' => "アーカイブチェックにより、圧縮ファイルが不正か圧縮ファイルのタイプがサポートされていない可能性があります。",
    'skeleton__archive_too_large' => "アーカイブチェックにより、圧縮ファイルが大きすぎる可能性があることが検出されました",
    'skeleton__not_supported_archive_type' => "このタイプのアーカイブ（ファイル %1）はサポートされません。",
    'skeleton__upload_archive_file' => "アーカイブファイルのアップロード",
    'skin_download__title' => 'スキンをダウンロード',
    'skin_download_now__title' => 'スキンのダウンロードを実行中です',
    'skin_download_now__text' => 'スキンパッケージを作成中です。<br>この処理にはしばらく時間がかかります。<br>ダイアログ画面が開くと、Plesk での作業を続けることができます。',
    'skin_file__help_for_using_types' => "以下のフォーマットのスキンアーカイブを使用してください：",
    'skin_info__title' => 'スキンのプロパティ',
    'skin_mng_err__rpm_not_skin' => 'この RPM は Plesk スキンパッケージではありません',
    'skin_mng_err__psa_install_noreloc' => '指定された位置への、RPM ベースのスキンのインストールに失敗しました',
    'skin_mng_err__already_exists' => 'スキンのインストールディレクトリは既に存在しており、スキンパッケージが展開済みです',
    'skin_mng_err__rpm_upgrade_nonrpm' => 'アップロードされたファイルは、有効なRPM スキンパッケージではありません',
    'skin_mng_err__rpm_upgrade_noskin' => 'アップロードされたファイルは、有効なスキンパッケージではありません',
    'skin_mng_err__rpm_upgrade_base' => "アップロードされたファイルは、有効な {$PROD_NAME} スキンパッケージではありません",
    'skin_mng_err__rpm_upgrade_other' => 'スキンをインストールできません。スキンのフォーマットが無効です。',
    'skin_mng_err__no_a_skin' => "アップロードされたファイルは、有効な {$PROD_NAME} スキンパッケージではありません",
    'skin_upload__title' => '新しいスキンをアップロードします。',
    'skin_upload__already_exists' => "スキン「%1」は既に存在します。",
    'skin_upload__unable_to_apply' => "アップロードしたファイルに Plesk スキンが含まれていないか、サポートされていないアーカイブフォーマットです。",
    'skin_upload__unable_to_rename__' => "スキンの名前 %2 を %1 に変更できません。%3",
    'skin_upload__file_name' => 'スキンパッケージファイルへのパス',
    'skins_list__title' => 'スキンリポジトリ',
    'skins_remove__title' => 'スキンを削除',
    'skins_remove__select_skins_for_remove' => '削除するスキンの選択',

    'spf__unable_update' => 'SPF パラメータをアップデートできません',
    'statistics__active_domains' => "アクティブドメイン",
    'statistics__clients' => "顧客",
    'statistics__subdomains' => "サブドメイン",
    'statistics__cpu' => "CPU",
    'statistics__databases' => "データベース",
    'statistics__db_users' => "データベースユーザ",
    'statistics__dirs' => "保護ディレクトリ",
    'statistics__dom_active' => "アクティブ",
    'statistics__dom_passive' => "パッシブ",
    'statistics__dom_problem' => "問題",
    'statistics__domains' => "ドメイン",
    'statistics__domains_with_host' => "ホスティングしているドメイン",
    'statistics__doms' => "ドメイン",
    'statistics__filesystem' => "ファイルシステム",
    'statistics__general' => "全般",
    'statistics__hdd_available' => "使用可能",
    'statistics__hdd_capacity' => "キャパシティ",
    'statistics__hdd_total' => "合計",
    'statistics__hdd_usage' => "ハードディスク使用状況",
    'statistics__hdd_used' => "使用中",
    'statistics__ip' => "IP アドレス",
    'statistics__key_number' => "キー番号",
    'statistics__l1' => "過去 1 分間",
    'statistics__l15' => "過去 15 分間",
    'statistics__l5' => "過去 5 分間",
    'statistics__la' => "CPU 使用率",
    'statistics__mail_autoresponders' => "自動応答",
    'statistics__mail_boxes' => "メールボックス",
    'statistics__mail_groups' => "メールグループ",
    'statistics__mail_lists' => "メーリングリスト",
    'statistics__mail_redirects' => "メール転送",
    'statistics__mem' => "メモリ使用率",
    'statistics__mem_usage' => "使用量",
    'statistics__memory_available' => "使用可能",
    'statistics__memory_buffer' => "バッファ",
    'statistics__memory_cached' => "キャッシュ",
    'statistics__memory_free' => "無料",
    'statistics__memory_shared' => "共有",
    'statistics__memory_total' => "合計",
    'statistics__memory_used' => "使用中",
    'statistics__os' => "OS",
    'statistics__problem_clients' => "問題のある顧客",
    'statistics__problem_domains' => "問題のあるドメイン",
    'statistics__swap' => "スワップ使用率",
    'statistics__swap_free' => "無料",
    'statistics__swap_total' => "合計",
    'statistics__swap_usage' => "使用量",
    'statistics__swap_used' => "使用中",
    'statistics__system_stat' => "サーバ情報",
    'statistics__unable_define_active_doms' => "アクティブドメイン数を検出することができません。%1",
    'statistics__unable_define_inactive_doms' => "無効なドメイン数を検出できません。%1",
    'statistics__failed_define_swap_usage' => 'スワップ使用率の定義に失敗しました',
    'statistics__failed_define_load_averages' => 'ロードアベレージの定義に失敗しました',
    'statistics__up_time' => "システム稼働時間：",
    'statistics__ver' => "バージョン",
    'statistics__web_users' => "ウェブユーザ",
    'statistics__mem_win' => "物理メモリ使用状況",
    'statistics__memory_total_win' => "合計",
    'statistics__memory_used_win' => "使用中",
    'statistics__memory_free_win' => "使用可能",
    'statistics__swap_win' => "仮想メモリ使用状況",
    'statistics__swap_total_win' => "合計",
    'statistics__swap_used_win' => "使用中",
    'statistics__swap_free_win' => "使用可能",
    'status__domain_has_reasons_to_be_off' => "ドメインは以下の理由により一時停止されたままの状態です。%1",
    'subdomain__create__' => "ドメイン %1 上にサブドメインを生成する",
    'subdomain__edit__' => "サブドメイン %1 を管理",
    'subdomain__invalid_name' => "無効なサブドメイン名：英数字およびダッシュ記号のみ使用してください。",
    'subdomain__incorrect_name' => "無効なサブドメイン名です",
    'subdomains__maillists_enabled_in_domain' => "サブドメイン名 lists.%1 は無効です。このドメイン名はドメイン %1 で既にメーリングリスト用に使用されています。",
    'subdomains__dalias_exists' => 'この名前のドメインエイリアスは既に存在します。',
    'subdomains__name_exists' => "この名前のサブドメインは既に存在します。",
    'subdomains__regular_domain_exists' => "この名前のドメインは既に存在します。",
    'subdomains__domain_alias_exists' => 'この名前のドメインエイリアスは既に存在します。',
    'subdomains__remove_subdomains_on_domain' => "ドメイン %1 の次のサブドメインが削除されます。",
    'subdomains__select_subdomains_for_remove' => "削除するサブドメインの選択",
    'subdomains__webmail_enabled_in_domain' => "サブドメイン名 webmail.%1 は無効です。 このドメイン名はドメイン %1 でウェブメールへのアクセスに使用されています。",
    'subdomains__dns_record_already_exists' => 'ホスト %1 を参照する DNS レコードが既に存在するため、サブドメイン %1 を作成できません',
    'subdomains__www_prefix_in_domain' => "www.%1 は、無効なサブドメイン名です。ドメイン %1 には既に WWW プレフィックスが存在します。",
    'subdomains__user_type_quota_exceeds' => '割り当てられたディスクスペースを超過する可能性があるため、ユーザアカウントを変更できません',
    'subdomains__creation_in_dns_slave' => "Plesk のネームサーバは、このドメインのセカンダリネームサーバとして動作しています。サブドメインが正しく変換されるように、プライマリ DNS サーバのゾーンファイルにレコード %1 が含まれていることを確認してください。",
    'sys_user__attributes_not_changed' => "以下のシステムユーザの属性は変更されません。%1",
    'sys_user__no_access_without_password' => "パスワードを設定していません。システムユーザが作成されますが、パスワードがつけられるまで、システムにログインすることはできません。続行しますか？",
    'sys_user__no_hard_quota' => "サポート対象外",
    'sysuser__zero_quota_is_unlimited' => "無制限として 0 を指定",
    'template__num_excl_ips' => "顧客に専用 IP アドレスを割り当てる",
    'template__sel_sh_ips' => "共有 IP アドレスの選択",
    'template__av_sh_ips' => "利用可能な共有 IP アドレス",
    'template__up_to_excl_ip' => "%1 IP アドレスまで",
    'templates__all_clients' => "すべての顧客",
    'templates__cl_domain_templates' => "%1のテンプレート",
    'templates__cl_templates' => "顧客テンプレート",
    'time__invalid_ip' => "無効な IP アドレスまたはドメイン名",
    '__please_select_country' => 'あなたの国を選択してください',
    'time__unable_set_time' => "システム時間を設定できません。%1",
    'time__sinchronization_setup_error' => '同期をセットアップできません。timemng が失敗しました：%1',
    'time__sinchronization_disable_error' => '時刻の同期を無効にできません。timemng が失敗しました：%1',
    'tmpl__create' => "テンプレート作成",
    'tmpl__edit__' => 'テンプレート %1',
    'tmpl__logrotation_warn' => "このテンプレートにより設定されたドメイン上のログローテーションは、物理ホスティングアカウント作成後有効になります。",
    'tmpl__name' => "テンプレート名",
    'tmpl__dom_exist' => "同じ名前のドメインテンプレートが、管理者または顧客のテンプレートプールに既に存在します。",
    'tmpl__name_invalid' => "テンプレート名が無効または空です",
    'tmpl__use_next_ip_addr' => "次の空き IP アドレスが使用されます。",
    'tmpl_name_already_exists' => "名前が「%1」のテンプレートが既に存在します。",
    'traffic__no_periods_found' => "ウェブとトラフィック統計を表示できません。 この機能は次回の統計データ計測後に使用可能になります。",

    'vh_based__no_free_ip_for_vh' => "IP ベースの仮想ホスティングで使用できる IP アドレスがありません。IP アドレスを追加してください。",

    'wu__at_domains_text' => "webuser@%1 というアクセスフォーマットを許可する",
    'wu__unable_create' => "ウェブユーザを作成できません。%1",
    'wu_edit__disk_quota' => "ディスククォータ",
    'wu_edit__invalid_pass' => "パスワードが無効です",
    'wu_edit__invalid_quota' => "指定されたディスククォータ値は無効です。正の整数を指定してください。",
    'wu_edit__invalid_quota_value' => "ディスクスペース使用量（%1MB）が指定クォータを超過しており、 一部の機能が使用できなくなる恐れがあります。続行しますか？",
    'wu_edit__not_create_pass' => "この操作では、新しいウェブユーザのパスワードが設定されません。 ユーザがログインするためには、パスワードを指定する必要があります。",
    'wu_edit__unable_update' => "ウェブユーザプロパティを更新できません。%1",

    'bt_webdirs' => '仮想ディレクトリ',

    'dns__tabs_general' => 'ゾーン設定',
    'dns__tabs_zone_settings' => 'SOA レコード',
    'soa__seconds' => '秒',
    'soa__minutes' => '分',
    'soa__hours' => '時間',
    'soa__days' => '日',

    'DomainSubdirectory' => '送り先サブディレクトリ',

    'filemanager__select_codepage' => 'Codepageの選択：',

    'bt_server_app_add' => 'サーバアプリケーションを追加',
    'packages_list' => 'サーバアプリケーション',

    'bt_packages_management' => 'パッケージ管理',
    'pb__packages_management' => 'アプリケーション管理',
    'bt_package_new' => 'アプリケーションを追加',
    '__packages' => 'サーバアプリケーション',

    'dom_ctrl__mysql_dbase_space' => '合計 MySQL データベースクォータ',
    'dom_ctrl__mssql_dbase_space' => '合計 MS SQL データベースクォータ',

    'dns_add__enter_ixfr_path' => 'IXFRパスを入力',

    'cmd_dns__txt_dns_record_already_exist' => 'SPF TXT レコードは既に存在します。SPF レコードは 1 つだけ可能です。レコードを追加するには、まず既存のレコードを削除してください。',

    'component_name__network' => 'ネットワーク',
    'component_name__sitebuilder' => 'Presence Builder',

    'bt_skin_set' => 'スキンをセット',
    'bt_set_skin' => 'スキンをセット',
    'firewall__rule_already_exists' => '名前が "%1" のルールは既に存在します。',
    'firewall__rule_readonly' => 'ルール「%1」は読み取り専用です',
    'pb__firewall' => 'ファイアウォール',

    '__webstat_smarterstats' => 'SmarterStats',

    'error_doc__erorr_invalid_file_location' => '無効なファイルロケーション',

    'error_doc__erorr_invalid_url_location' =>  '無効なURLです',

    'mn_list__tab_title_antivirus' => 'AV',

    'bt_antivirus' => 'アンチウイルス',
    'antivirus__antivirus' => 'アンチウイルス保護',
    'antivirus__antivirus_direction_off' => 'オフ',
    'antivirus__antivirus_direction_any' => '送信メールと受信メール',
    'antivirus__antivirus_direction_from' => '送信メールのみ',
    'antivirus__antivirus_direction_to' => '受信メールのみ',
    'antivirus__unable_to_update_settings' => 'アンチウイルス設定を変更できません。%1',




    '__normal' => '中',
    '__low' => '低',
    '__high' => '高',

    'mail__antivirus' => "内部メールサーバのアンチウイルス",
    'mail__use_internal_antivirus' => '内蔵されたアンチウイルスを使用',

    'sa__tabs_blacklist' => 'ブラックリスト',

    '__mysql_databases' => 'MySQL データベース',

    'cl_perm__mysql_dbase_space' => '合計 MySQL データベースクォータ',
    'cl_perm__mssql_dbase_space' => '合計 MS SQL データベースクォータ',
    'cl_perm__max_mssql_db' => '最大 Microsoft SQL サーバデータベース数',
    'cl_perm__total_mboxes_quota' => '総メールボックスクォータ',

    'i_i_cl_on' => '顧客アカウントは有効です',
    'i_i_cl_off_by_admin' => '顧客アカウントは管理者により一時停止されています。',

    'sa_exists_tn' => 'そのネットワークは既にリストに存在しています。',

    'webdir__select_vdirs_to_remove' => '削除するディレクトリを選択',
    'webdir__select_mime_types_to_remove' => '削除する MIME タイプを選択',

    'defaultcomponents__not_activated' => '非アクティブ',

    'bt_traffic_at_domains' => 'トラフィック',

    '__awstats_perl_warning' => 'Perl がインストールされていない場合、ユーザは AWStats を用いて昨年以前の統計を確認することができません',

    'class_client__mysql_dbase_space' => 'この値は顧客の制限を超過しています。',
    'class_client__mssql_dbase_space' => 'この値は顧客の制限を超過しています。',
    'class_client__max_mssql_db' => 'この値は顧客の制限を超過しています。',

    'dns__remove_transfer_restrictions_list_items' => 'アクセスコントロールリストから、以下のネットワークが削除されます。',

    'bt_up' => "1 つ上のレベルへ",
    'bt_down' => "下へ",
    'virtualdir__type_default_doc_name_to_add' => 'リストに追加するファイル名を入力',
    'virtualdir__select_default_doc_to_remove' => 'リストから削除するファイルを選択してください',
    'virtualdir__select_directory' => 'ディレクトリを選択',

    'bt_install_selected' => 'ライセンスキーをインストール', // SELECTED


    'dom_pref__the_domain_resolves_to_another_ip_address' => 'このドメインは他の IP アドレス（%1）に解決されます。DNS の設定を確認してください。',

    'mn_edit__mailbox_enable_if_mailgroup_enabled' => '現在使用中のメールサーバは、メールボックスとメールグループを同時にオンにすることをサポートしていません。 メールグループをオフにしてメールボックスをオンにするには［OK］をクリックしてください。そのままにしておくには［キャンセル］をクリックしてください。',

    'mn_edit__mailgroup_enable_if_mailbox_enabled' => '現在使用されているメールサーバは、メールボックスとメールグループを同時にオンにすることをサポートしていません。メールボックスをオフにしてメールグループをオンにするには［OK］をクリックしてください。このままにするには［キャンセル］をクリックしてください。',

    'mysql_dbase_space_limit' => 'MySQL データベーススペースの上限',
    'mysql_dbase_usage' => 'MySQL データベーススペースの使用率',
    'mssql_dbase_space_limit' => 'Microsoft SQL サーバデータベースのスペース制限',
    'mssql_dbase_usage' => 'Microsoft SQL サーバデータベースのスペース利用率',

    '__statistics' => "統計", //indirect

    'dns__soa_minimum_value_is_big' => '最小 TTL 値を 3 時間以上に設定すると、一部のドメイン管理者が御社のドメインにアクセスできなくなる可能性があります。ドメイン名レジストラが推奨している場合にのみ、このような値に設定するようお勧めします。',

    'virusfilter__interface_not_available' => '利用できるウイルスフィルタがありません',
    'virusfilter__none_virus_filter' => 'なし',
    'virusfilter__mailname_status_text' => 'アンチウイルス（%1）',
    'virusfilter__status_none' => 'オフ',
    'virusfilter__status_any' => '送信メールと受信メール',
    'virusfilter__status_outgoing' => '送信メールのみ',
    'virusfilter__status_incoming' => '受信メールのみ',

    'visibility__root_override_parse_error' => 'ファイル %1 の %2 行目で構文エラーが発生しています。',

    'sb__not_support_publishing_api' => "自動公開はコンポーネントにおいてサポートされていません",

    'component_name__cphosting' => "Plesk ホスティング",

    'dom_pref__unable_set_up_total_mboxes_quota' => 'メールボックスクォータは現在のメールサーバでサポートされていません。',
    '__unable_get_total_mboxes_quota' => 'メールボックスクォータは現在のメールサーバでサポートされていません。',

    'install_prefix__parent_not_exists' => "親ディレクトリが存在しません",

    'bt_change_version' => 'バージョン変更',
    'aspdotnet__changeversion_title' => 'ASP.NET バージョンの選択',
    'pb__aspdotnet' => 'ASP.NET',

    '__check_all' => "すべて選択",
    '__uncheck_all' => "すべてクリアする",

    'dns__editing_domain_controller_zone' => "ドメインコントローラの DNS ゾーンレコードを編集した場合、ドメインの動作に影響を及ぼす可能性があります。",

    'pb__interface_management' => "インターフェース管理",
    'interface_management__tabs_skins' => "スキン",
    'interface_management__tabs_interface_templates' => "インターフェーステンプレート",
    'interface_management__tabs_locales' => "ロケール",
    'locales_list__title' => "言語パックのリポジトリ",
    'locales_list__legend' => "使用可能な言語",
    'locales_list__active_title' => "S",
    'locales_list__locale_title' => "言語パック",
    'locales_list__lang_title' => "言語",
    'locales_list__country_title' => "国",
    'locales_list__used_title' => "使用中",

    'backup__suspend_warning_during_backup' => "バックアッププロセスの間、ドメインは利用できません",
    'backup__suspend_warning_during_restore' => "復元処理中、ドメインは利用できません",
    'backup__suspend_domain' => "ドメインを一時停止",

    'locales_list__mls_limit' => "現在の Plesk ライセンスでは、%2 言語を使用することができます。現在、ユーザが %1 言語を使用できるように設定していますが、これはライセンスで許可されている数を超えています。使用したい言語を %2 種類選択し、残りの言語については［S］列でアイコンをクリックして使用不可能にしてください。",

    'bt_change_owner' => '新しい所有者を割り当てる',
    'chown__new_owner' => '新しい所有者',
    'chown__selected_domains' => '選択した契約',
    'chown__limits_legend' => 'リソース',
    'chown__limit_name' => 'リソース名',
    'chown__limit_value' => '割当リソース',
    'chown__limit_assigned_before' => '転送前に割り当てられていたリソースの総量',
    'chown__limit_assigned_after' => '転送後割り当てられているリソースの総量',
    'chown__error_limits' => "契約を移管できません。 この契約には、所有者のプロバイダが用意することができる以上のリソースが必要です。",
    'chown__error_no_domains' => '契約を移管できません。 契約が選択されていないか、選択した契約が既に宛先ユーザに属しています。',
    'chown__error_empty_ip_pool' => "契約を移管できません。 新しい所有者のプロバイダの IP プールが空です。プロバイダのプールに IP アドレスが少なくとも 1 つ必要です。",
    'chown__please_select_new_domain_owner' => 'この契約の新しい所有者を選択してください。',
    'chown__old_ip_address' => '現在の IP アドレス',
    'chown__new_ip_address' => '新しいIP アドレス',

    'chown__error_ssl_already_used' => "SSL/TLS サポートは既に以下の宛先 IP で使用されています（%1）。そのため、以下の SSL/TLS サポート付きドメインを移管できませんでした（%2）。問題を修正してからやり直してください。",
    'chown__sitebuilder_not_installed' => 'Presence Builder がインストールされていません',
    'chown__domain_exclude_sitebuilder_not_installed' => 'Presence Builder がインストールされていないため、ドメイン %1 を他の所有者に移管できません。',

    'backup__backup_time' => 'バックアップ時間',
    'backup__backup_time_hour' => '時間',
    'backup__backup_time_minute' => '分',
    'backup__every' => '毎',
    'backup__day_of_month' => '日',

    'subdomain__select_hst_type' => 'サブドメインのホスティングタイプを選択',
    'hst_sel__subdom_subfolder_hst' => 'サブフォルダ上のサブドメイン',
    'subdomain__www_root_folder_not_exists' => 'サイトホームディレクトリ %1 が存在しません',
    '__site_home_dir' => 'サイトホームディレクトリ',
    'subdomain__aspnet_disabled_domain' => 'ドメインによりスイッチオフ済み',

    'domains__remove_description' => 'ドメインおよびそれぞれのサブドメインコンテンツおよび設定、ウェブアプリケーションデータ、メールボックスコンテンツ、メール/アンチウイルス/スパムフィルタの設定、ログファイル、ドメインバックアップリポジトリデータ、SSL/TLS 証明書を含むすべてのドメインデータが削除されます。ローカルマシンにバックアップファイルがない場合、すべてのデータが恒久的に失われます。',
    'subdomains__remove_description' => 'すべてのサブドメインデータが削除されます（サブドメイン上のコンテンツおよび設定、ウェブアプリケーションデータおよびログファイルを含む）。ローカル PC にバックアップファイルを保存していない限り、これらのデータは完全に削除されます。',

    'mail__tabs_spam_filtering' => 'スパムフィルタ',
    'mail__tabs_antivirus' => 'アンチウイルス',
    'antivirus__use_server_settings_scan' => 'デフォルトのサーバ全体設定を使用（スキャン）',
    'antivirus__use_server_settings_no_scan' => 'デフォルトのサーバ全体設定を使用（スキャンしない）',
    'antivirus__check_for_viruses' => 'ウイルスをスキャンする',
    'antivirus__dont_check_for_viruses' => 'ウイルススキャンしない',
    'antivirus__incoming_mail' => '受信メール',
    'antivirus__outgoing_mail' => '送信メール',

    'domain_alias__CNAME_dns_record_exists' => 'この名前の DNS CNAME レコードは既に存在します。',
    'domain_alias__A_dns_record_exists' => 'この名前の DNS A レコードは既に存在します。',
    'domain_alias__bad_prefix' => 'ドメインエイリアスのプレフィックスが正しくありません',
    'domain_alias__domain_doesnt_exist' => "ドメインが存在しません",

    'dns__zone_ttl_message_info' => 'TTL 値を指定しない場合、SOA レコードテンプレートの TTL 値（%1）がこの DNS レコードに使用されます。',

    '__webalizer_support' => 'Webalizer',
    '__awstats_support' => 'AWstats',
    '__smarterstats_support' => 'SmarterStats',

    'site_apps__make_default_warning_message' => "選択したウェブアプリケーションへのリダイレクトのために、index.html というファイルが作成されます。既に index.html ファイルが存在する場合、以前のものは index.html.old と名称変更され、新しいものに置き換わります。問題がなければ［OK］をクリックしてください。",

    'bt_ftp_ctrl' => "追加 FTP アカウント",
    'ftp_users_no_permission' => "このドメインにおける FTP サブアカウントの管理パーミッションを所有していません",
    'ftp_users_limit_reached' => "このドメインにおける FTP アカウントの制限数に達しました",
    'pb__ftp_ctrl' => "FTP 管理",
    'class_client__max_subftp_users' => "追加 FTP アカウント",

    '__client_form_settings' => "顧客の設定",
    '__sbnet_client_keep_sbnet' => "Presence Builder に関連ユーザアカウントを保持",
    '__sbnet_cant_add_more_sites' => "この顧客が Presence Builder を使用して作成できるサイトの上限数に達しました",
    '__sbnet_legend_text' => "Presence Builder 統合",
    '__sbnet_synchronize_user_with_sbnet' => "Presence Builder で関連ユーザアカウントを作成",
    '__sbnet_client_warning_delete_sb_user' => "この顧客に関連付けられている Presence Builder ユーザアカウントを削除しようとしています。これによって、Presence Builder システムからユーザのウェブサイトと関連設定がすべて削除されます。後日このオプションをオンに戻しても、既存のウェブサイトを Presence Builder で編集することはできません。Presence Builder ユーザアカウントを再び作成する場合、すべてのウェブサイトを最初から作成して公開し直す必要があります。Presence Builder でのウェブサイトの作成と公開を本当にオフにしますか？",
    'sb__build_site_with_subdomains' => "Blog および Photo Gallery サブドメインを作成する",
    '__sbnet_client_dont_have_sbuser' => "Presence Builder を使用してサイトを作成し、公開することができません。Presence Builder ユーザが存在しません。",

    '__component_disabled' => "オフになっているコンポーネント",

    'subdomains__physical_path_not_exist' => "存在しない物理フォルダにリンクするサブドメインが存在します。",

    'dnsserver_bind_to_msdns_switching_warning' => "警告：アクセスコントロールリストでネットマスクが /8 または /16 のサブネットは、先頭から 254 個の IP アドレスのみが転送されます。これらは個別 IP アドレスとして転送されます。実行しますか？",

    '__sbnet_net_framework_required_for_site' => "Presence Builder サイトでは、ドメインで ASP.NET 2.0 がサポートされている必要がある可能性があります。PresenceBuilder を使用している場合、ASP.NET 2.0 を有効化することをお勧めします。",

    'subdomain_auto_create_dir' => "サブドメイン用に物理ディレクトリを作成",

    'sa_trainer__unable_to_get_messages_list' => "メッセージボックスからメッセージの一覧を取得できません。%1",
    'sa_trainer__pass_doesnt_exist' => "このメールアカウントにおけるパスワードが見つかりません",

    '__sitebuilder_error' => "Presence Builder への接続中にエラーが発生しました。サービスプロバイダまでお問い合わせください。",
    'wsb_error_user_not_exist' => "この Presence Builder ユーザアカウントは存在しません。",
    'wsb_error_site_already_exist' => "このサイトは既に Presence Builder に存在します。",
    'wsb_error_site_limit_reached' => "Presence Builder サイトの上限数に達しました。",
    'wsb_error_internal_error' => "Presence Builder で内部エラーが発生しました。サービスプロバイダまでお問い合わせください。",
    'wsb_error_user_already_exist' => "同じ名前の Presence Builder ユーザが Presence Builder に既に存在します。",
    'sb_error_user_not_exist' => "Presence Builder ユーザは存在しません。",
    'wsb_error_object_not_found' => "Presence Builder は、正しいホストエントリを検出できませんでした。",

    'mg_no_mail_groups' => "メールグループはありません",

    'drweb__drweb_incoming' => '受信メールのアンチウイルスチェック',
    'drweb__drweb_outgoing' => '送信メールのアンチウイルスチェック',
    'drweb__disable_reason_serv' => 'メールサーバはメールボックスレベルにおけるアンチウイルスフィルタ設定をサポートしていません',

    'vz_sitebuilder3_client_cant_be_created' => "顧客アカウントを作成できません。 SiteBuilder バージョン 3.1 以降がインストールされていません。",

    'chown__client_without_sitebuilder_support' => "契約を移管できません。新しい所有者またはそのプロバイダのサービスプランに、Presence Builder サービスが含まれていません。",

    // new limits

    'class_client__max_odbc' => "ODBC 接続",
    'cl_perm__max_odbc' => "最大 ODBC 接続数",

    // domain aliases DNS
    'domain_alias__list_status' => 'S',
    'domain_alias__list_name' => 'ドメインエイリアス名',
    'domain_alias__list_ascii_name' => 'ASCII フォーマット',


    // Interface Customization Templates
    'interface_preferences' => 'インターフェース管理',
    'pb__interface_templates' => 'インターフェース管理',
    'pb__interface_clients' => '顧客は %1 を使用しています。',

    // service management
    'bt_service_showall' => "すべてを表示",
    'bt_service_hideall' => "すべてを非表示",
    'bt_service_start' => "開始",
    'bt_service_stop' => "停止",
    'bt_service_restart' => "再起動",
    'bt_service_disable' => "オフにする",
    'bt_service_manual' => "手動",
    'bt_service_auto' => "自動",
    'comp_info__statup_type' => '起動タイプ',
    'service_startup_auto' => '自動',
    'service_startup_manual' => '手動',
    'service_startup_disabled' => 'オフ',
    'service_action_ok' => "%1 サービスの操作は正常に完了しました",
    'service_action_failed_disabled_service' => "オフになっているため、%1 サービスの操作を完了できません",
    'service_action_failed_error' => "操作を完了できません。%1",
    'service_group_action_ok' => "以下のサービスに対する操作が正常に完了しました。%1",
    'service_group_action_disabled' => "オフになっているため、以下のサービスに対する操作を完了できません。%1",
    'service_group_action_failed' => "以下のサービスにて作業を完了できません。%1 詳細なエラー情報を参照するには、個々のサービスをそれぞれ実行してください。",

    // php 4vs5
    'bt_php' => "PHP 設定",

    // Mass mail

    'massmail__resellers_list_available_for_select' => '使用可能なリセラー',
    'massmail__resellers_list_selected' => '選択したリセラー',
    'massmail__clients_list_available_for_select' => '使用可能な顧客',
    'massmail__clients_list_selected' => '選択した顧客',
    'massmail__advanced' => '詳細',
    'bt_massmail_send' => '送信',
    'massmail__save_template_name' => 'テキストを新しい新しいテンプレート名で保存する',
    'massmail__template' => 'テンプレート',
    'massmail__compose_mail' => 'メッセージ',
    'massmail__from' => 'From',
    'massmail__to' => '宛先',
    'massmail__subject' => '件名',
    'massmail__body' => 'メッセージテキスト',
    'massmail__body_hint' => '<name> 変数を使用して、メッセージにユーザ名を自動的に挿入できます。',
    'massmail__send_to_clients' => "顧客",
    'massmail__send_to_domainusers' => "ドメイン管理者",
    'massmail__send_to_admins' => "Plesk 管理者",
    'massmail_select' => 'アドレスを選択する',
    'massmail_showhide_selected' => "選択内容を表示/非表示",
    'massmail_send_all' => "すべて",
    'massmail_send_selected' => "選択のみ",
    'massmail_send_except' => "選択以外すべて",
    'bt_new_mass_mail_template' => "一括メールテンプレートを追加",
    '__mass_mail_templates_list' => "一括メールメッセージテンプレートのリスト",
    'massmail__template_name' => 'テンプレート名',
    'massmail__receivers' => '受信者',
    'massmail__created' => '送信者',
    'massmail__date_created' => '作成日',
    'massmail__compose' => '送信',
    'mass_mail__resellers_all' => 'すべてのリセラー',
    'mass_mail__clients_all' => 'すべての顧客',
    'mass_mail__domainusers_all' => 'すべてのドメイン管理者',
    'mass_mail__resellers_selected' => '選択したリセラー',
    'mass_mail__clients_selected' => '選択した顧客',
    'mass_mail__domainusers_selected' => '選択したドメイン管理者',
    'mass_mail__resellers_except' => '選択した以外のすべてのリセラー',
    'mass_mail__clients_except' => '選択以外のすべての顧客',
    'mass_mail__domainusers_except' => '選択以外のすべてのドメイン管理者',
    'mass_mail__admins_all' => 'すべての管理者',
    'massmailtemplateslist__title' => '一括メールメッセージテンプレート',
    'massmail__insert_from_template' => "テンプレートよりデータを挿入する",
    'massmail__select_template' => "テンプレートを選択する",
    'massmail__body_short_hint' => "（テキスト形式のみ）",
    'massmail__from_short_hint' => "（メールアドレスまたは名前）",
    'bt_insert' => "挿入",
    'massmail__mail_send_successfully' => "メッセージは正常に送信されました",
    'massmail__mail_send_successfully_with_some_errors' => "メッセージは送信されましたが、いくつかのエラーが発生しました。一部の受信者はメッセージを受信できない可能性があります。詳細についてはログファイル %plesk_dir%\\admin\\logs\\send_mass_mail.log を参照してください。",
    'massmail__mail_send_failed' => "メッセージは送信されませんでした。受信者が少なくとも 1 人選択されており、Plesk メールサーバが正常に機能していることを確認してください。詳しくは、次のログファイルを参照してください。%plesk_dir%\\admin\\logs\\send_mass_mail.log",
    'massmail__template_data_inserted' => "テンプレート %1 からのデータが正常に挿入されました",
    'massmail__template_added_successfully' => "メッセージテンプレートが %1 と言う名前で保存されました",

    // wsb integration
    'wsb_error_sitebuilder_database_error' => "Presence Builder にデータベースエラーが発生しました。サービスプロバイダまでお問い合わせください。",
    'wsb_error_sitebuilder_access_denied_error' => "ファイルにアクセスできません。Presence Builder に、必要なファイルまたはフォルダへのアクセス権限がありません。サービスプロバイダまでお問い合わせください。",
    'wsb_error_sitebuilder_connection_failed' => "接続が切断されたため、Presence Builder に接続できません。サービスプロバイダまでお問い合わせください。",
    'wsb_error_critical_during_operation' => "Presence Builder で重大なエラーが発生しました。\n%1",
    'wsb_error_license_during_operation' => "Presence Builder でライセンスエラーが発生しました。\n%1",
    'wsb_error_during_operation' => "Presence Builder でエラーが発生しました。\n%1",
    'wsb_error_license_error' => "Presence Builder ライセンスリミットに達しました。",

    // Other
    '__confrim_service_stop' => "警告：サービス %1 を停止すると、Plesk が動作を停止する可能性があります。サービス %1 を停止しますか？",
    'virtualdir__name_is_reserved' => "この名称は予約済みです",
    'index_redirect_help_text' => '必要なウェブサイトに自動的にリダイレクトされます。ブラウザがリダイレクトをサポートしていない場合、%1 ここ %2 をクリックしてください。',
    'bt_default_settings' => "デフォルトに復元",
    'logfiles__remove_failed' => "ファイル %1 を削除できません。ファイルはその他のアプリケーションによりロックされています。再度実行してください。",
    'subdomain__invalid_homedirectory' => "指定されたサブドメインホームディレクトリは無効です",
    'scheduler_item__empty_filename' => "実行する実行可能ファイルを指定してください。",
    'subdomains__overlapped_domain_exists' => 'サブドメインはドメイン %1 の DNS ゾーンによってオーバラップされます。',
    'subdomains__overlapped_domain_alias_exists' => 'サブドメインはドメインエイリアス %1 の DNS ゾーンによってオーバラップされます。',
    'services_action_none_selected' => '操作を完了できません。必要なサービスを選択してください。',
    'cl_perm__max_subftp_users' => "追加 FTP アカウントの最大数",
    'login_up__access_denied_no_cp_access' => 'アクセス拒否されました。Plesk にアクセスする権限がありません。',
    'drweb__disable_reason_admin' => "プロバイダのポリシーにより、メールボックスレベルでのアンチウイルスフィルタ設定は許可されていません。",

    'webdirs__name_is_invalid' => 'ディレクトリ名には、英数字、下線、およびダッシュのみ使用できます。',
    'webdirs__physical_path_is_invalid' => '物理パスが無効か、存在しません',
    '__use_default' => 'デフォルトを使用',

    'webalizer_hidden_referrer__already_exist' => 'このようなエントリは既に存在します。',
    'webalizer_group_referrer__already_exist' => 'この名前のグループリファラは既に存在します。',

    'pb__dashboard' => 'ホーム',

    'server_interface__page_title' => 'サーバインターフェース設定',
    'server_interface__tabs_locales' => 'ロケール',
    'server_interface__tabs_skins' => 'スキン',
    'server_interface__tabs_interface_templates' => 'インターフェーステンプレート',
    'bt_server_interface' => 'インターフェース設定',
    'pb__server_interface' => 'インターフェース設定',

    'bt_wizard_next' => '次へ >>',
    'bt_wizard_prev' => '<<戻る',

    '__limit_exceeded_max_dom_server' => 'ライセンスキーによりサーバ上で許可されているドメインの上限数に達したため、このサーバ上でこれ以上ドメインを作成できません。 サービスプロバイダまでお問い合わせください。',
    '__limit_exceeded_max_subdom_server' => 'このサーバ上でこれ以上サブドメインをホスティングできません。 サービスプロバイダまでお問い合わせください。',
    '__limit_exceeded_max_dom_aliases_server' => 'このサーバ上でドメインエイリアスをこれ以上設定できません。 サービスプロバイダまでお問い合わせください。',
    '__limit_exceeded_max_wu_server' => 'ライセンスキーにおいてサーバで許可されているウェブユーザの上限数に達したため、これ以上ウェブユーザを作成できません。 サービスプロバイダまでお問い合わせください。',
    '__limit_exceeded_max_mn_server' => 'ライセンスキーにおいてサーバで許可されているメールアカウントの上限数に達したため、これ以上メールアカウントを作成できません。 サービスプロバイダまでお問い合わせください。',

    '__limit_exceeded_max_cl_useradmin' => 'ライセンスキーに定義された顧客アカウントの上限数に達しました（%2）',
    '__limit_exceeded_max_dom_useradmin' => 'ライセンスキーに定義されているドメイン数の上限（%2）に達しました',
    '__limit_exceeded_max_subdom_useradmin' => 'ライセンスキーに定義されているサブドメイン数の上限（%2）に達しました',
    '__limit_exceeded_max_dom_aliases_useradmin' => 'ライセンスキーに定義されているドメインエイリアス数の上限（%2）に達しました',
    '__limit_exceeded_disk_space_useradmin' => '空きディスクスペースがありません',
    '__limit_exceeded_max_wu_useradmin' => 'ライセンスキーに定義されているウェブユーザアカウント数の上限（%2）に達しました',
    '__limit_exceeded_max_db_useradmin' => 'ライセンスキーに定義されているデータベース数の上限（%2）に達しました',
    '__limit_exceeded_max_box_useradmin' => 'ライセンスキーに定義されているメールボックス数の上限（%2）に達しました',
    '__limit_exceeded_max_mn_useradmin' => 'ライセンスキー（%2）に定義されているメールアカウントの上限に達しました。',
    '__limit_exceeded_max_maillists_useradmin' => 'ライセンスキーに定義されているメーリングリスト数の上限（%2）に達しました',

    '__limit_exceeded_max_dom_userclient' => 'ドメイン数の上限（%2）に達しました',
    '__limit_exceeded_max_subdom_userclient' => 'サービスプロバイダに許可されているサブドメイン数の上限（%2）に達しました',
    '__limit_exceeded_max_dom_aliases_userclient' => 'ドメインエイリアス数の上限（%2）に達しました',
    '__limit_exceeded_disk_space_userclient' => 'ディスクスペース使用量の上限（%2）に到達しました',
    '__limit_exceeded_max_traffic_userclient' => '毎月の帯域幅使用率の上限（%2）に到達しました',
    '__limit_exceeded_max_wu_userclient' => 'サービスプロバイダに許可されているウェブユーザアカウント数の上限（%2）に達しました。',
    '__limit_exceeded_max_db_userclient' => 'データベース数（%2）の上限に達しました',
    '__limit_exceeded_max_box_userclient' => 'メールボックス数の上限（%2）に達しました',
    '__limit_exceeded_max_maillists_userclient' => 'メーリングリスト数の上限（%2）に達しました',
    '__limit_exceeded_expiration_userclient' => 'アカウントは %2 に期限切れを迎えます。',

    '__limit_exceeded_max_subdom_userdomain' => 'サービスプロバイダに許可されているサブドメイン数の上限（%2）に達しました',
    '__limit_exceeded_max_dom_aliases_userdomain' => 'ドメインエイリアス数の上限（%2）に達しました',
    '__limit_exceeded_disk_space_userdomain' => 'ディスクスペース使用量の上限（%2）に到達しました',
    '__limit_exceeded_max_traffic_userdomain' => '毎月の帯域幅使用率の上限（%2）に到達しました',
    '__limit_exceeded_max_wu_userdomain' => 'ウェブユーザアカウント数の上限（%2）に達しました',
    '__limit_exceeded_max_db_userdomain' => 'データベース数（%2）の上限に達しました',
    '__limit_exceeded_max_box_userdomain' => 'メールボックス数の上限（%2）に達しました',
    '__limit_exceeded_max_maillists_userdomain' => 'メーリングリスト数の上限（%2）に達しました',
    '__limit_exceeded_expiration_userdomain' => 'アカウントは %2 に期限切れを迎えます。',

    'mmt__to_none' => 'なし',
    'mmt__to_admin' => '管理者',
    'mmt__to_resellers_all' => 'すべてのリセラー',
    'mmt__to_resellers_select' => '選択したリセラー',
    'mmt__to_resellers_select__available' => '使用可能なリセラー',
    'mmt__to_resellers_except' => '選択した以外のすべてのリセラー',
    'mmt__to_clients_all' => 'すべての顧客',
    'mmt__to_clients_select' => '選択した顧客',
    'mmt__to_clients_select__available' => '使用可能な顧客',
    'mmt__to_clients_except' => '選択以外のすべての顧客',

    'mmt__unable_send_empty_selection' => 'メールを一括送信できません。メールアドレスが選択されていません。',
    'mmt__unable_send_to__' => '一括メールメッセージを送信できません。',
    'mmt__unable_send_to_email' => '%1 <%2>',

    'sapp_error_validation_not_found' => '必要なファイル（%1）が見つからないため、ウェブアプリケーションを検証できません。詳細についてはテクニカルサポートまでお問い合わせください。',
    'sapp_error_validation_spec_failed' => 'アップロードされたウェブアプリケーションは、アプリケーションパックの要件を満たしていません。%1',
    'sapp_error_validation_register' => 'ディレクトリ "%1" に配置されているサイトアプリケーションを登録できません。%2ウェブアプリケーションが適切に動作しないため、サーバから削除する必要があります。',

    'sapp__install_failed' => 'ウェブアプリケーションのインストールに失敗しました。%1',
    'sapp__install_res_failed' => '要求されたリソースの作成に失敗しました',

    'server_preferences__subdomains_blog_and_photo' => 'デフォルトでブログおよび画像ギャラリーサブドメインを作成する',
    'plesk_key__blog_and_photo' => 'ブログおよび画像ギャラリ用サブドメインを作成するチェックボックスのデフォルト状態を管理する機能',
    'ip_ctrl__cannot_make_exclusive_ip_with_more_than_one_client' => 'この IP アドレスは複数のユーザに割り当てられているため、IP アドレスタイプを専用に変更できません。',

    // 8.1.1

    '__write_modify_warning' => '追加の書込/変更パーミッションを選択すると、一部のウェブアプリケーションは正しく機能するようになりますが、セキュリティ上の脆弱性をが高まる危険性もありますのでご注意ください',
    '__write_modify_subdomain_warning' => '追加の書込/変更パーミッションを選択すると、一部のウェブアプリケーションは正しく機能するようになりますが、セキュリティ上の脆弱性をが高まる危険性もありますのでご注意ください',

    'phosting__php_incorrect_version_used' => "PHP バージョンに関する問題が検出されました。これらの問題を改善するには、必要な PHP バージョンのチェックボックスをオンにして［OK］をクリックしてください。このドメインで PHP をオフにするには、PHP バージョンを選択せずに［OK］をクリックしてください。",
    'fp__mail_preferences' => 'メール設定',

    'mail__invalid_white_pattern' => '指定した値が無効です。メールアドレスの正しい形式は「mail@example.com」、ドメインの正しい形式は「example.com」です。',
    'mail__invalid_black_pattern' => '指定した値が無効です。メールアドレスの正しい書式は「mail@example.com」、ドメインは「example.com」です。',

    'resp_edit__reply_as_html' => 'HTML メールとして送信',
    'exception__path_very_long' => "パスが長すぎます。 %1 文字より短い長さで指定しているかご確認ください。",

    // 8.2


    //SAPP
    'sapp_on' => 'オン',
    'sapp_off' => 'オフ',
    'sapp_directive_aspect' => '必須',
    'sapp_databases_num' => 'データベース',
    'sapp_db_required' => '必須',
    'sapp_Required' => '必須',
    'sapp_Variant' => '変化',
    'sapp_db_id' => 'データベース ID',
    'sapp_db_id_type' => 'データベース（ID：%1）タイプ',
    'sapp_db_id_min_version' => 'データベース（ID：%1）最小バージョン',
    'sapp_db_id_table_prefix' => 'データベース（ID：%1）テーブルのプレフィックス',
    'sapp_Default' => 'デフォルト値',
    'sapp_apache_mod_req' => 'Apache モジュール',
    'sapp_dbtype_not_installed' => '未インストール',
    'sapp_apache_mod_not_installed' => '未インストール',
    'sapp__value_error_empty' => '空の値は許可されません。',
    'sapp_error_invalid_type' => 'アプリケーション「%1」は要求された操作をサポートしていません',
    'sapp_error_unknown_app_type' => 'アプリケーションでサポートされないタイプ：%1',
    'sapp__ssl_text' => '「http://」または「https://」仮想ホストにアプリケーションをインストールしますか？',
    'sapp__app_to_upgrade' => 'アップグレードされるアプリケーション',
    'sapp__upgrade_apps_title' => 'アプリケーションのアップグレード',
    'sapp__upgrade_to_ver' => 'アップグレードバージョン',
    'sapp__choose_pkg_ver' => 'パッケージの選択...',
    'sapp__pkg_cant_upgrade_pkg' => 'パッケージ "%1" はウェブアプリケーション "%2" のアップグレードに使用できません。',
    'sapp__app_ugrade_error' => 'アプリケーションをアップグレードできません。%1 システム管理者までお問い合わせください',
    'sapp__no_suitable_db_found' => '適合するデータベースが見つかりません',
    'sapp__upgrade_success' =>  'アプリケーションが正常にアップグレードされました',
    'sapp__pkg_info_changelog' => '変更履歴',
    'sapp_requirement_legend' => 'アプリケーションで必要なホスティング機能',

    // other
    'bt_apply' => '適用する',
    'mn_edit__add_alias_if_mailbox_disabled' => 'メールエイリアスを作成するには、当該メールアカウントでメールボックスがオンになっている必要があります。メールボックスをオンにしますか？',
    'mn_edit__mailbox_disable_if_has_alias' => 'メールボックスをオフにすると、メールエイリアスは機能が停止するため削除されます。メールボックスをオフにしますか？',
    'antivirus__disable_reason_install' => 'アンチウイルスはインストールされていないため、管理できません。',
    'antivirus__disable_reason_key' => 'アンチウイルスは適切なライセンスキーでアクティブ化されていないため、管理できません。',
    'antivirus__disable_reason_deny_personal_settings' => 'サーバポリシーで個々のアンチウイルス設定が却下されているため、アンチウイルスを管理できません。',
    'change_foreign_user_password' => 'パスワード変更',
    'change_foreign_user_password_hint' => "ユーザはこのアプリケーションに属していません。リンクをクックして他のアプリケーションに移動し、ユーザパスワードを変更してください。これを実行するには、アプリケーションにおいて有効な権限を有している必要があります。",
    'cf_url_text' => 'JDBC URL',
    'cf_sendStringParametersAsUnicode_text' => '文字列フォーマット',
    'lang_unknown' => '不明な言語',
    'pb__cl_ed' => '顧客の詳細',
    'pb__actionlog' => 'アクションログ',
    'pb__cl_limits' => '顧客の上限',
    'pb__edit' => '編集',
    'pb__subdom_edit' => 'ホスティング設定',

    // NEW 8.3 FEATURES

    'backup_mail_content' => 'メールボックスのコンテンツをバックアップする',

    'maillist_import_result' => "ファイル内のメールアドレス数の合計： %1\nインポートされたメールアドレス数： %2\n既存のメールアドレス数： %3\n指定ファイル内の重複メールアドレス数： %4\nファイル内の無効メールアドレス数： %5",
    'maillist_import_error' => 'メールアドレスリストのインポートに失敗しました',

    //  spaw

    'spaw__unable_to_edit_no_body' => "選択されたファイルが空であるか、選択したエンコーディングの有効な HTML ドキュメントではありません。正しいエンコーディングを選択するか、ファイルにコンテンツを追加してください。",

    'dom_pref__external_mail_srv' => "指定 IP アドレスの外部メールサーバにリダイレクト：",
    'mn_edit__store_messages' => 'メールボックス',

    // aps

    'sapp__before_upgrade_notice' => 'アップグレードプロセスを開始するまえに、ユーザデータおよびアプリケーションをバックアップすることをお勧めします。',
    'sapp__application_properties' => 'アプリケーションプロパティ',
    'sapp__application_root_descr' => 'アプリケーションのメインページ',

    'sapp__aps_license_invalid_id' => 'ライセンスキーに無効な ID が指定されています。%1',
    'sapp__aps_lic_key_alredy_exists' => 'キー番号 %1 のライセンスが、データベース上に既に存在します。',
    'sapp__aps_lic_del_used' => 'ライセンスキーを削除できません。インストール済みのアプリケーションで使用されています。',
    'sapp__aps_lic_del_unknown' => 'ライセンスキーを削除できません。%1',
    'sapp__aps_cappi_duplicate' => "このアプリケーションは、既に顧客のアプリケーションプールに存在します。",
    'sapp__appi_not_shared_no_install' => "顧客のアプリケーションプールに該当するアプリケーションがありません。 このアプリケーションをサイトにインストールするには、まず顧客のアプリケーションプールにこのアプリケーションを追加する必要があります。",
    'sapp__appi_shared_not_client' => "顧客のアプリケーションプールに該当するアプリケーションがありません。 アプリケーションを特定のバージョンにアップグレードするには、まず顧客のアプリケーションプールにこのアプリケーションを追加する必要があります。",
    'sapp__apply_license_script_not_found' => 'このウェブアプリケーション用の "apply-license" スクリプトが見つかりません',
    'sapp__unable_to_activate_key' => 'ライセンスキーのアクティブ化を試行中にエラーが発生しました。%1',
    'sapp__unable_to_delete_ai_instances_exists' => 'システム内に、このアプリケーションパッケージが存在していることが必須条件であるインストール済みウェブアプリケーションが存在します。',
    'sapp__unable_to_delete_ai_in_pool' => 'このアプリケーションはまだ顧客のプール内に存在しています。 このアプリケーションを削除するには、まず全顧客のアプリケーションプールから削除するか、無償に変更する必要があります。',
    'sapp__unable_to_delete_app_template' => 'アプリケーション #%1 を削除できません。%2',
    'sapp__limit_exceeded_client' => 'このウェブアプリケーションの最大インストール数に達しました（%2）。',


    // atis module

    '_week_on' => '実行週',
    '__week_first' => '1',
    '__week_second' => '第2週',
    '__week_third' => '第3週',
    '__week_fourth' => '第4週',
    '__week_last' => '最終',
    '__not_started' => '待機中',
    '__started' => '実行中',
    '__cancel_pending' => 'キャンセル中',
    '__canceled' => 'キャンセル',
    '__error' => 'エラー',
    '__done' => '完了',

    '__php_cgi_handler' => 'CGI アプリケーション',
    '__php_isapi_handler' => 'ISAPI エクステンション',
    '__php_fastcgi_handler' => 'FastCGI アプリケーション',
    '__php_module_handler' => 'mod_php',
    '__php_run_as' => '実行',

    'cf_dbfolder_text' =>'データベースフォルダ',
    'cf_isnewdb_text' => 'データベース作成',
    'cf_isnewdb_title' => 'データベースを作成する必要がある場合、チェックボックスを選択する',

    'pb__site_apps_upgrade' => 'ウェブアプリケーションのアップグレード',

    'detach' => '切り離す',
    'preferences' => "パスワード変更",

    'toolsbar__switch_user?' => "他のユーザアカウントでログインしますか？",
    '__aps_left' => '残りインストレーション数',
    'aps__license_key' => 'ライセンスキー',
    'aps__download_code' => 'ライセンスキーのダウンロードおよびアクティベーションコード',
    'aps__license_key_hint' => 'アクティベーションコードを使用してライセンスサーバから取得する',
    'aps__database_not_available' => '使用できません。 ドメインまたは顧客の上限を確認してください。',
    'aps__yes' => 'はい',
    'aps__no' => 'いいえ',
    '__click_to_enlarge' => 'クリックして拡大',
    'site_apps__back_to_list' => '一覧に戻る',
    'sapp__pkg_info_installation_requirements' => 'インストール条件',
    '__close_window' => '閉じる',

    //SAPP END

    'skin_info__already_default' => 'スキンは既にデフォルト設定されています。',

    //move this to other file after splitting drweb to module
    'drweb:virus_filter_full_name' => 'Plesk Premium Antivirus',
    'drweb:properties_page_title' => '%1 用の Plesk Premium Antivirus 設定',
    'drweb:properties_legend' => '設定',
    'drweb:status' => 'メールにウイルスが含まれていないかチェック中',

    // sb integration
    'sitebuilder_wizard' => 'Presence Builder ウィザード',
    'dom_site_builder' => 'Presence Builder ウィザードを開きます。',
    'sb_plesk_admin_url' => 'Presence Builder サーバの URL。このアドレスが DNS で正しく解決されることを確認してください。',
    'sb_plesk_admin_login' => 'サーバ管理者の Presence Builder ログイン用ユーザ名',
    'sb_plesk_admin_password' => '管理者パスワード',
    'sb_sitebuilder_preferences' => 'Presence Builder 管理者のクレデンシャル',
    'sb__server' => 'Presence Builder 管理者のクレデンシャル',
    'sb__sitebuilder_support' => 'Presence Builder サポート',
    'sb_keep_sb_user' => 'Presence Builder に関連ユーザアカウントを保持',
    'sb_create_sb_user' => 'Presence Builder で関連ユーザアカウントを作成',
    'sb__build_site_using_sitebuilder' => "Presence Builder を使用してウェブサイトを作成",
    'sb_no_current_sb_server_set' => 'Presence Builder への接続が構成されていません。DNS ゾーンテンプレートに、Presence Builder サーバをポイントする A レコードを追加する必要があります。',
    'sb_unable_update_sb_server_sb_return_message' => "Presence Builder システムから情報を収集できませんでした。\n%1",
    'sb_unable_connect_sb_wrong_con_params' => "Presence Builder に接続できません。ユーザ名またはパスワードが正しくありません。",
    'sb_init_sb_manager' => "Presence Builder マネージャを初期化中： %1",
    'sb_err_couldnt_connect_sb' => "Presence Builder システムへの接続に失敗しました。",
    'sb_err_client_dont_have_sbuser' => "この顧客は、Presence Builder にユーザアカウントを持ちません。",
    'sb_err_sitebuilder_not_configured' => "Presence Builder が未構成です。",
    'sb_err_you_dont_have_sbaccount' => "Presence Builder での認証に失敗しました。",
    'sb_error_critical_during_operation' => "Presence Builder で次のエラーが発生しています。\n%1",
    'sb_err_sso_is_not_enabled' => "シングルサインオン（SSO）サポートが、Plesk でオンになっていません。",

    'warning__super_zone_exist' => "ゾーン %1 が作成されましたが、このゾーン名は既に存在するゾーン %2 のサブゾーンであり、ユーザ %3 に属しています。問題はありませんが、正しいユーザアカウントを選択しているかご確認ください",
    'error__super_zone_exist' => "スーパーゾーンが他のユーザに属しているため、DNS ゾーンを作成できません",

    'locales__files_not_exits' => 'ロケールを変更できません。指定されたインターフェース言語パックファイルがシステム上に存在しません。',
    'locales__unavailable' => 'ロケールを変更できません。指定されたインターフェース言語パックは使用可能ではありません。',

    // DB BU

    'pb__dbbackup_list' => 'データベースバックアップファイル',
    // server
    'dbbackup__server_backup_settings' => 'バックアップ',
    'dbbackup__network_temp_dir' => '一時ネットワークディレクトリ',
    'dbbackup__network_user' => 'ユーザ名',
    'dbbackup__network_pass' => 'パスワード',
    // domain
    'dbbackup__add_database_legend' => 'バックアップされたデータベースの復元',
    'dbbackup__add_database_restore' => 'バックアップファイルよりデータベースを復元します。',
    'dbbackup__add_database_file' => 'データベースバックアップファイル',
    'dbbackup__add_database_user' => 'デフォルトユーザ名',
    'dbbackup__add_database_pass' => 'デフォルトユーザパスワード',
    'dbbackup__add_database_pass2' => 'デフォルトユーザパスワードの確認',

    'bt_dbbackup_now' => 'バックアップ',

    'bt_repair' => '修復',

    'dbbackup__mssql_dump_upload_not_allowed' => 'SQL Server データベースダンプのアップロードは、ホスティング事業者により禁止されています。',

    // APS categories

    'cf_invalid_password' => 'パスワードに 16 文字より長い文字列を指定できません',
    'cf_invalid_description_length' => '詳細は 257 文字以上にはできません',
    'ip_addr__ip_used_by_external_mail_server' => 'IP アドレス %1 は既に外部メールサーバで使用されています。',

    // 8.4.1

    '__ftp_login_is_invalid' => 'FTP アカウントのユーザ名またはパスワードが無効です。 正しい FTP ユーザクレデンシャルを指定してください。',

    // 8.6

    'dns__dns_serial_update_limit_warning' => 'シリアル番号変更の上限値に達しました。 本日これ以上 DNS ゾーン変更を行うことはできません。',
    'dns__zone_apply_changes' => 'DNS レコードへの変更が保存されていません。変更内容はハイライト表示されています。［更新］をクリックして DNS ゾーンに変更を適用するか、［戻す］をクリックして変更を破棄します。',
    'dns__update_dns_zone' => 'DNS レコードへの変更を保存します。',
    'dns__revert_dns_zone' => 'DNS レコードへの変更をキャンセルします。',
    'bt_revert' => '戻す',
    'dns__dns_zone_has_beed_updated' => 'DNS レコードへの変更が保存されました',
    'dns__dns_zone_has_beed_reverted' => 'DNS レコードへの変更がキャンセルされました',
    'db__nondefault_server_not_allowed' => 'デフォルトではないデータベースサーバの利用は許可されていません',


    //// UI POINTER CAPTIONS START HERE
    ////
    // *** The strings below have been generated automatically from @@CAPTION directives.

    'ui__client__description' => '顧客 %1 のアカウントとドメインです。',
    'ui__client__disabled-warning' => '顧客 %1 のアカウントを一時停止しました',
    'ui__client__none-available' => '設定済みの顧客アカウントはありません',
    'ui__client__short-title' => '%1',
    'ui__client__title' => '顧客 %1',
    'ui__client_self__description' => '自分のドメインのリスト',
    'ui__client_self__short-title' => 'マイ・ドメイン',
    'ui__client_self__title' => 'マイ・ドメイン',


    'site_apps__non_removable' => 'アイテムを削除できません',
    'site_apps__non_removable_items' => '以下のウェブアプリケーションを削除できません。',

    'ui__client/custom-buttons/custom-button__none-available' => 'カスタムボタンがありません',
    'ui__client/custom-buttons/custom-button__none-available__1' => '顧客 %1 の顧客パネルにカスタムボタンはありません。',

    'ui__client/custom-buttons/custom-button/delete__description' => 'ボタン %1 を削除します。',
    'ui__client/custom-buttons/custom-button/delete__short-title' => '削除',
    'ui__client/custom-buttons/custom-button/delete__title' => 'ボタン %1 を削除',
    'ui__client/custom-buttons/custom-button/delete_multi__description' => '顧客の顧客パネルからカスタムボタンを削除',
    'ui__client/custom-buttons/custom-button/delete_multi__short-title' => '削除',
    'ui__client/custom-buttons/custom-button/delete_multi__title' => 'カスタムボタンを削除',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard-title' => 'ボタンを削除',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard__1_unknown' => 'カスタムボタンを削除する顧客を選択して、［次へ >>］をクリックしてください。',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard__3_multi' => '削除するボタンを選択して、［次へ >>］をクリックしてください。',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard__4_multi' => 'ボタンの削除を確認するには、当該画面でチェックボックスをオンにして、［終了］をクリックしてください。',
    'ui__client/custom-buttons/custom-button/delete_unknown__description' => '顧客の顧客パネルからカスタムボタンを削除します。',
    'ui__client/custom-buttons/custom-button/delete_unknown__short-title' => '削除',
    'ui__client/custom-buttons/custom-button/delete_unknown__title' => 'カスタムボタンを削除',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard-title' => 'カスタムボタンを削除',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard__1_unknown' => 'カスタムボタンを削除する顧客を選択して、［次へ >>］をクリックしてください。',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard__3_unknown' => '削除するカスタムボタンをクリックして、［次へ >>］をクリックしてください。',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard__4' => 'カスタムボタンの削除を確認するには、当該画面でチェックボックスをオンにして、［終了］をクリックしてください。',

    'ui__client/custom-buttons/custom-button/properties__description' => '顧客レベルボタン %1 のプロパティを編集します。',
    'ui__client/custom-buttons/custom-button/properties__short-title' => '設定',
    'ui__client/custom-buttons/custom-button/properties__title' => '顧客のカスタムボタン %1 を変更',
    'ui__client/custom-buttons/custom-button/properties_new__wizard-title' => 'カスタムボタンを追加',
    'ui__client/custom-buttons/custom-button/properties_new__wizard__1_unknown' => 'どの顧客の顧客パネルにカスタムボタンを作成するのかを選択し、［次へ >>］をクリックしてください。',
    'ui__client/custom-buttons/custom-button/properties_new__wizard__4_new' => '［終了］をクリックして、ボタンを作成してください。',
    'ui__client/custom-buttons/custom-button/properties_unknown__description' => '顧客の顧客パネルでボタンのプロパティを変更します。',
    'ui__client/custom-buttons/custom-button/properties_unknown__short-title' => 'プロパティ',
    'ui__client/custom-buttons/custom-button/properties_unknown__title' => '顧客の顧客パネルでボタンのプロパティを変更します。',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard-title' => 'カスタムボタンプロパティを変更する',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard__1_unknown' => 'カスタムボタンを変更する顧客を選択して、［次へ >>］をクリックしてください。',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard__3_unknown' => '編集するカスタムボタンを選択して、［次へ>>］をクリックしてください。',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard__4' => 'ボタンプロパティの編集を完了後、［終了］をクリックして変更を適用した後で、ウィザードを終了してください。',

    'ui__client/custom-buttons/custom-button/toggle_private__description' => '顧客に対してボタン %1 を利用不可にします。',
    'ui__client/custom-buttons/custom-button/toggle_private__short-title' => '顧客に対して利用不可にする',
    'ui__client/custom-buttons/custom-button/toggle_private__title' => '顧客に対してボタン %1 を利用不可にする',
    'ui__client/custom-buttons/custom-button/toggle_public__description' => '顧客のユーザに対してボタン %1 を表示します。',
    'ui__client/custom-buttons/custom-button/toggle_public__short-title' => '顧客に対して利用可能にする',
    'ui__client/custom-buttons/custom-button/toggle_public__title' => '顧客のユーザに対してボタン %1 を表示する',
    'ui__client/custom-buttons/custom-button/toggle_unknown__description' => '顧客に対してカスタムボタンを利用可能/利用不可にします。',
    'ui__client/custom-buttons/custom-button/toggle_unknown__short-title' => '顧客が利用可能/利用不可',
    'ui__client/custom-buttons/custom-button/toggle_unknown__title' => '顧客に対してカスタムボタンを利用可能/利用不可にする',
    'ui__client/custom-buttons/custom-button/toggle_unknown__wizard-title' => '顧客に対してカスタムボタンを利用可能/利用不可にします。',
    'ui__client/custom-buttons/custom-button/toggle_unknown__wizard__1_unknown' => '顧客のユーザに対してカスタムボタンを使用可能にするために、顧客を選択して［次へ >>］をクリックしてください。',
    'ui__client/custom-buttons/custom-button/toggle_unknown__wizard__3_unknown' => '顧客に対して利用可能/利用不可にするカスタムボタンを選択して、［次へ >>］をクリックしてください。',

    'ui__client/domain__description' => 'ドメイン %1 を管理',
    'ui__client/domain__disabled-warning' => 'ドメイン %1 は一時停止されています。',
    'ui__client/domain__none-available' => 'ドメインを所有していません',
    'ui__client/domain__none-available__1' => '%1 のアカウントにはドメインが登録されていません',
    'ui__client/domain__none-available__2' => '%1 のアカウントにはドメインが登録されていません',
    'ui__client/domain__short-title' => '%1',
    'ui__client/domain__title' => 'ドメイン %1',
    'ui__client/domain_self__description' => 'ドメイン管理',
    'ui__client/domain_self__disabled-warning' => 'ドメインは一時停止されています。',
    'ui__client/domain_self__quick-search' => 'マイ・ドメイン',
    'ui__client/domain_self__short-title' => 'マイ・ドメイン',
    'ui__client/domain_self__title' => 'マイ・ドメイン',

    'ui__client/domain/custom-buttons/custom-button__none-available' => '顧客の顧客パネルにカスタムボタンがありません。',
    'ui__client/domain/custom-buttons/custom-button__none-available__1' => '顧客 %1 の顧客パネルにはカスタムボタンがありません。',
    'ui__client/domain/custom-buttons/custom-button__none-available__2' => 'ドメイン %1 のカスタムボタンがありません',
    'ui__client/domain/custom-buttons/custom-button/delete__description' => 'カスタムボタン %1 を削除します。',
    'ui__client/domain/custom-buttons/custom-button/delete__short-title' => '削除',
    'ui__client/domain/custom-buttons/custom-button/delete__title' => 'カスタムボタン %1 を削除',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__description' => 'カスタムボタンを削除します。',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__short-title' => '削除',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__title' => 'カスタムボタンを削除',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard-title' => 'カスタムボタンを削除',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__1_unknown' => 'ボタンを削除するドメイン管理者パネルを所有する顧客を選択して、［次へ >>］をクリックしてください。',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__2_unknown' => '管理パネルからカスタムボタンを削除するドメインを選択して、［次へ >>］をクリックしてください。',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__4_multi' => '削除するボタンを選択して、［次へ >>］をクリックしてください。',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__5_multi' => 'ボタンの削除を確認するには、該当するチェックボックスをオンにし、［終了］をクリックしてボタンを削除して、ウィザードを終了してください。',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__description' => 'カスタムボタンを削除します。',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__short-title' => '削除',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__title' => 'カスタムボタンを削除',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard-title' => 'カスタムボタンを削除',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__1_unknown' => 'カスタムボタンを削除するドメイン管理者パネルを所有する顧客を選択し、［次へ >>］をクリックしてください。',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__2_unknown' => '管理パネルからカスタムボタンを削除したいドメインを選択し、［次へ >>］をクリックしてください。',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__4_unknown' => '削除するカスタムボタンを選択し、［次へ］をクリックしてください。',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__5' => '削除するカスタムボタンのチェックボックスをオンにして、［完了］をクリックしてください。削除が実行され、ウィザードが終了します。',

    'ui__client/domain/custom-buttons/custom-button/properties__title' => "カスタムボタン %1 のプロパティを変更する",
    'ui__client/domain/custom-buttons/custom-button/properties__short-title' => "プロパティ",
    'ui__client/domain/custom-buttons/custom-button/properties__description' => "顧客パネルにあるカスタムボタン %1 のプロパティを変更します。",

    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard-title' => 'ボタンを追加',
    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard__1_unknown' => 'どの顧客の顧客パネルにボタンを作成するのかを選択し、［次へ >>］をクリックしてください。',
    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard__2_unknown' => 'ボタンを変更したい契約を選択し、［次へ >>］をクリックしてください。',
    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard__5_new' => '［終了］をクリックしてボタンを作成し、ウィザードを終了してください。',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__description' => "顧客パネル上のボタンのプロパティを変更します。",
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__short-title' => 'プロパティ',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__title' => '顧客パネル上のボタンのプロパティを変更します。',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__wizard-title' => 'ボタンのプロパティを変更する',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__wizard__4_unknown' => "設定を修正したいカスタムボタンを選択し、［次へ >>］をクリックしてください。",
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__wizard__5' => 'ボタンプロパティの変更を完了後、［終了］をクリックして変更を適用した後で、ウィザードを終了してください。',

    'ui__client/domain/custom-buttons/custom-button/toggle_private__description' => 'このドメイン下のメールユーザに対してボタン %1 を使用不可にします。',
    'ui__client/domain/custom-buttons/custom-button/toggle_private__short-title' => 'メールユーザに対して使用不可',
    'ui__client/domain/custom-buttons/custom-button/toggle_private__title' => 'このドメイン下のメールユーザに対してボタン %1 を使用不可にする',
    'ui__client/domain/custom-buttons/custom-button/toggle_public__description' => 'このドメイン下のメールユーザに対してボタン %1 を表示します。',

    'ui__client/domain/custom-buttons/custom-button/toggle_public__short-title' => 'このドメイン以下のメールユーザにおいてアクセス可能とする',
    'ui__client/domain/custom-buttons/custom-button/toggle_public__title' => 'このドメイン下でカスタムボタン %1 を表示する',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__description' => '他のユーザに対してカスタムボタンを使用可能/使用不可にします。',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__short-title' => '他のユーザに対して使用可能/使用不可',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__title' => 'メールユーザに対して、カスタムボタンを利用可能/利用不可にする',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__wizard-title' => '他のユーザに対して、カスタムボタンを利用可能/利用不可にする',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__wizard__2_unknown' => 'ボタンを追加するドメインを選択し、［次へ >>］をクリックしてください。',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__wizard__4_unknown' => '他のユーザに対して使用可能/使用不可にしたいカスタムボタンを選択して［次へ >>］をクリックしてください。',

    'ui__client/domain/delete__description' => 'ドメイン %1 を削除します。',
    'ui__client/domain/delete__short-title' => '削除',
    'ui__client/domain/delete__title' => 'ドメイン %1 を削除',
    'ui__client/domain/delete_multi__description' => 'ドメインを削除します。',

    'ui__client/domain/delete_multi__short-title' => '削除',
    'ui__client/domain/delete_multi__title' => 'ドメインを削除',
    'ui__client/domain/delete_multi__wizard-title' => 'ドメインを削除',
    'ui__client/domain/delete_multi__wizard__2_multi' => '削除するドメインを選択し、［次へ >>］をクリックしてください。',
    'ui__client/domain/delete_multi__wizard__3_multi' => 'ドメインの削除を確定するには、チェックボックスをオンにしてから［終了］をクリックして、ウィザードを終了してください。',
    'ui__client/domain/delete_unknown__description' => 'ドメインを削除します。',
    'ui__client/domain/delete_unknown__short-title' => '削除',
    'ui__client/domain/delete_unknown__title' => 'ドメインを削除',
    'ui__client/domain/delete_unknown__wizard-title' => 'ドメインを削除',
    'ui__client/domain/delete_unknown__wizard__2_unknown' => '削除するドメインを選択して、［次へ >>］をクリックしてください。',
    'ui__client/domain/delete_unknown__wizard__3' => 'ドメインの削除を確認するには、チェックボックスをオンにし、［終了］をクリックして削除を実行し、ウィザードを終了してください。',

    'ui__client/domain/hosting__none-available' => 'ウェブホスティング設定されたドメインがありません。この機能を利用するには、ドメインを作成しウェブホスティングを設定してください。',
    'ui__client/domain/hosting__none-available__1' => 'このユーザアカウントにはウェブホスティングが構成されているドメインがありません。この機能を使用するには、必要なドメイン上でウェブホスティングを構成してください。',
    'ui__client/domain/hosting__none-available__2' => 'ドメイン %1 にウェブホスティングが設定されていません。この機能を利用するには、ドメイン %1 にウェブホスティングを設定してください。',

    'ui__client/domain/hosting/application#list_header__clients_number__title' => "顧客",
    'ui__client/domain/hosting/application#list_header__description__title' => "説明",
    'ui__client/domain/hosting/application#list_header__items_number__title' => "アイテム",
    'ui__client/domain/hosting/application#list_header__name__title' => "名前",
    'ui__client/domain/hosting/application#list_header__release__title' => "リリース",
    'ui__client/domain/hosting/application#list_header__sort_by_clients_number__title' => "顧客順に並べ替える",
    'ui__client/domain/hosting/application#list_header__sort_by_description__title' => "詳細順に並べ替える",
    'ui__client/domain/hosting/application#list_header__sort_by_items_number__title' => "アイテム順に並べ替える",
    'ui__client/domain/hosting/application#list_header__sort_by_name__title' => "名前順に並べ替える",
    'ui__client/domain/hosting/application#list_header__sort_by_release__title' => "リリース順に並べ替える",
    'ui__client/domain/hosting/application#list_header__sort_by_version__title' => "バージョン順に並べ替える",
    'ui__client/domain/hosting/application#list_header__title' => "ウェブアプリケーション",
    'ui__client/domain/hosting/application#list_header__version__title' => "バージョン",

    'rpt_reseller_section_general' => '全般',
    'rpt_reseller_section_domains' => 'ドメイン',
    'rpt_reseller_section_clients' => '顧客',
    'statistics__cl_active_domains' => "アクティブドメイン",
    'rpt_reseller_cl_domains' => "ドメイン",
    'rpt_reseller_cl_subdomains' => "サブドメイン",
    'by__cl_domains' => "クライアントのドメイン",
    'dom_ctrl__cl_mboxes' => "メールボックス",
    'rpt_reseller_cl_redirects' => "フォワーダ",
    'rpt_reseller_cl_mail_groups' => "メールグループ",
    'rpt_reseller_cl_mail_resps' => "自動応答",
    'rpt_reseller_cl_mail_lists' => "メーリングリスト",
    'rpt_reseller_cl_web_users' => "ウェブユーザ",
    'rpt_reseller_cl_data_bases' => "データベース",

    'statistics__active_clients' => '契約が有効な顧客',
    'statistics__clients_active_domains' => 'アクティブドメイン',
    'statistics__clients_doms' => 'ドメイン',
    'statistics__cl_doms' => 'ドメイン',
    '__clients_subdomains' => 'サブドメイン',
    '__clients_domains' => 'ドメイン',
    'dom_ctrl__clients_mboxes' => 'メールボックス',
    'dom_ctrl__clients_redir' => 'フォワーダ',
    'dom_ctrl__clients_mg' => 'メールグループ',
    'dom_ctrl__clients_resp' => '自動応答',
    'dom_ctrl__clients_maillists' => 'メーリングリスト',
    'dom_ctrl__clients_wu' => 'ウェブユーザ',
    'dom_ctrl__clients_db' => 'データベース',

    'dom_ctrl__cl_redir' => 'フォワーダ', // to resolve!
    'dom_ctrl__cl_mg' => 'メールグループ', // to resolve!
    'dom_ctrl__cl_resp' => '自動応答', // to resolve!
    'dom_ctrl__cl_maillists' => 'メーリングリスト', // to resolve!
    'dom_ctrl__cl_wu' => 'ウェブユーザ', // to resolve!
    'dom_ctrl__cl_db' => 'データベース', // to resolve!

    'rpt_cl_section_clients' => '顧客',

    'rpt_admin_section_general' => '全般',
    'rpt_admin_section_resellers' => 'リセラー',
    'rpt_admin_section_clients' => '顧客',
    'rpt_admin_section_personal_clients' => '自社の顧客',
    'rpt_admin_section_domains' => 'ドメイン',
    'rpt_admin_section_personal_domains' => '個人ドメイン',

    'rpt_reseller_section_personal_domains' => '個人ドメイン',

    'ui__client/domain/toggle_unknown__wizard__2_unknown' => '一時停止またはアクティブ化するドメインを選択してください。',
    'ui__client/domain/toggle_unknown__wizard-title' => 'ドメインを一時停止/アクティブ化',

    'ui__client/ip-pool__description' => '顧客 %1 への IP アドレスおよび SSL/TLS 証明書の割り当てまたは割り当て解除を行います。',
    'ui__client/ip-pool__short-title' => 'IP プール',
    'ui__client/ip-pool__title' => '顧客 %1 の IP プール',
    'ui__client/ip-pool_self__description' => 'IP プール参照',
    'ui__client/ip-pool_self__short-title' => 'IP プール',
    'ui__client/ip-pool_self__title' => 'マイ IP プール',
    'ui__client/ip-pool/properties__description' => '顧客 %1 の IP プールを設定します。',

    'ui__client/ip-pool/properties__short-title' => 'IP プール',
    'ui__client/ip-pool/properties__title' => '顧客 %1 の IP プール設定',
    'ui__client/ip-pool/properties_self__description' => 'IP プール参照',

    'ui__client/ip-pool/properties_self__short-title' => 'マイ IP プール',
    'ui__client/ip-pool/properties_self__title' => 'マイ IP プール',
    'ui__client/ip-pool/properties_unknown__description' => '顧客への IP アドレスおよび SSL/TLS 証明書の割り当てまたは割り当て解除を行います。',
    'ui__client/ip-pool/properties_unknown__short-title' => 'IP プール',
    'ui__client/ip-pool/properties_unknown__title' => '顧客の IP プールをセットアップ',
    'ui__client/ip-pool/properties_unknown__wizard-title' => '顧客の IP プールをセットアップ',
    'ui__client/ip-pool/properties_unknown__wizard__1_unknown' => 'IP プールをセットアップする顧客を選択してください。',
    'ui__client/ip-pool/properties_unknown__wizard__3' => 'クライアントIP プールの編集を完了した後で、［終了］をクリックして変更を適用しウィザードを終了してください。',


    'ui__client/limits_readonly-unknown__description' => '顧客に対するリソースの上限値を表示します。',
    'ui__client/limits_readonly-unknown__short-title' => 'リソース制限',
    'ui__client/limits_readonly-unknown__title' => '顧客アカウントに対するリソースの上限値を表示します。',
    'ui__client/limits_readonly-unknown__wizard-title' => '顧客に対するリソース上限値を表示/変更する',

    'ui__client/limits_unknown__wizard-title' => '顧客に対するリソース上限値を表示/変更する',
    'ui__client/limits_unknown__wizard__1_readonly-unknown' => '顧客を選択してください。',
    'ui__client/limits_unknown__wizard__1_unknown' => '顧客を選択してください。',
    'ui__client/limits_unknown__wizard__2' => '変更を適用するには、［終了］をクリックしてください。',
    'ui__client/limits_unknown__wizard__2_readonly' => 'ウィザードを完了するには、［終了］をクリックしてください。',
    'ui__client/limits_unknown__wizard__2_readonly-self' => 'ウィザードを完了するには、［終了］をクリックしてください。',
    'ui__client/limits_unknown__wizard__2_readonly-self-reseller' => 'ウィザードを完了するには、［終了］をクリックしてください。',

    'ui__client/permissions_unknown__wizard-title' => '顧客のパーミッションを表示/変更する',
    'ui__client/permissions_unknown__wizard__1/properties_self' => 'パーミッションの参照が完了した後で、［終了］をクリックして変更を適用し、ウィザードを終了してください。',
    'ui__client/permissions_unknown__wizard__1_unknown' => 'パーミッションを変更/表示する顧客を選択してください。',
    'ui__client/permissions_unknown__wizard__2' => '顧客のパーミッションを変更したら、［終了］をクリックして変更を適用し、ウィザードを終了してください。',

    'ui__client/preferences_unknown__wizard-title' => '顧客のプリファレンスを編集する',
    'ui__client/preferences_unknown__wizard__1_unknown' => 'セッションとインターフェース設定を管理する顧客を選択してください。',
    'ui__client/preferences_unknown__wizard__2' => '顧客のプリファレンス変更が完了したら、［終了］をクリックしてください。',
    'ui__client/preferences_unknown__wizard__2_self' => 'プリファレンス変更が完了したら、［終了］をクリックしてください。',

    'ui__custom-buttons/custom-button__none-available' => 'カスタムボタンがありません',
    'ui__custom-buttons/custom-button/delete__description' => 'カスタムボタン %1 を削除します。',
    'ui__custom-buttons/custom-button/delete__short-title' => '削除',
    'ui__custom-buttons/custom-button/delete__title' => 'カスタムボタン %1 を削除',
    'ui__custom-buttons/custom-button/delete_multi__description' => 'カスタムボタンを削除します。',

    'ui__custom-buttons/custom-button/delete_multi__short-title' => '削除',
    'ui__custom-buttons/custom-button/delete_multi__title' => 'カスタムボタンを削除',
    'ui__custom-buttons/custom-button/delete_multi__wizard-title' => 'カスタムボタンを削除',
    'ui__custom-buttons/custom-button/delete_multi__wizard__2_multi' => '削除したいボタンを選択してください。',
    'ui__custom-buttons/custom-button/delete_multi__wizard__3_multi' => 'ボタンの削除を確認するには、チェックボックスをオンにし、［終了］をクリックしてウィザードを完了してください。',
    'ui__custom-buttons/custom-button/delete_unknown__description' => 'カスタムボタンを削除します。',
    'ui__custom-buttons/custom-button/delete_unknown__short-title' => '削除',
    'ui__custom-buttons/custom-button/delete_unknown__title' => 'カスタムボタンを削除',
    'ui__custom-buttons/custom-button/delete_unknown__wizard-title' => 'カスタムボタンを削除',
    'ui__custom-buttons/custom-button/delete_unknown__wizard__2_unknown' => '削除したいカスタムボタンを選択してください。',
    'ui__custom-buttons/custom-button/delete_unknown__wizard__3' => 'ボタンの削除を確認するにはチェックボックスを選択し、［終了］をクリックしてウィザードを完了してください。',
    'ui__custom-buttons/custom-button/properties__description' => 'ボタン %1 のプロパティを変更する',

    'ui__custom-buttons/custom-button/properties__short-title' => 'プロパティ',
    'ui__custom-buttons/custom-button/properties__title' => 'ボタン %1 のプロパティを変更する',

    'ui__custom-buttons/custom-button/properties_new__wizard-title' => 'ボタンを作成する',
    'ui__custom-buttons/custom-button/properties_new__wizard__3_new' => '［終了］をクリックして、ボタンを作成してください。',
    'ui__custom-buttons/custom-button/properties_unknown__description' => 'カスタムボタンのプロパティを変更',
    'ui__custom-buttons/custom-button/properties_unknown__short-title' => 'プロパティ',
    'ui__custom-buttons/custom-button/properties_unknown__title' => 'カスタムボタンのプロパティを変更',
    'ui__custom-buttons/custom-button/properties_unknown__wizard-title' => 'カスタムボタンのプロパティを変更',
    'ui__custom-buttons/custom-button/properties_unknown__wizard__2_unknown' => 'プロパティを変更したいカスタムボタンを選択してください。',
    'ui__custom-buttons/custom-button/properties_unknown__wizard__3' => '変更を適用するには、［終了］をクリックしてください。',
    'ui__custom-buttons/custom-button/toggle_private__description' => '他のユーザがカスタムボタン %1 を使用できないようにします。',

    'ui__custom-buttons/custom-button/toggle_private__short-title' => 'その他のユーザは使用不可',
    'ui__custom-buttons/custom-button/toggle_private__title' => '他のユーザに対してカスタムボタン %1 を使用不可にする',
    'ui__custom-buttons/custom-button/toggle_public__description' => '他のユーザに対してカスタムボタン %1 を使用可能にします。',

    'ui__custom-buttons/custom-button/toggle_public__short-title' => 'その他のユーザが使用可能',
    'ui__custom-buttons/custom-button/toggle_public__title' => '他のユーザに対してカスタムボタン %1 を使用可能にする',
    'ui__custom-buttons/custom-button/toggle_unknown__description' => '他のユーザに対して、カスタムボタンを利用可能/利用不可にします。',
    'ui__custom-buttons/custom-button/toggle_unknown__short-title' => '他のユーザに対して使用可能/使用不可',
    'ui__custom-buttons/custom-button/toggle_unknown__title' => '他のユーザに対して、カスタムボタンを利用可能/利用不可にする',
    'ui__custom-buttons/custom-button/toggle_unknown__wizard-title' => '他のユーザに対して、カスタムボタンを利用可能/利用不可にする',
    'ui__custom-buttons/custom-button/toggle_unknown__wizard__2_unknown' => '他のユーザに対して使用可能/使用不可にしたいカスタムボタンを選択して［次へ >>］をクリックしてください。',

    'ui__longtasks#list_header__name__title' => "名前",
    'ui__longtasks#list_header__owner__title' => "所有者",
    'ui__longtasks#list_header__start_time__title' => "作成日",
    'ui__longtasks#list_header__status__title' => "ステータス",
    'ui__longtasks#list_header__title' => "タスク",
    'ui__longtasks#list_header__finish_time__title' => "完了時間",
    'ui__longtasks#task_list_legend__title' => "タスク",
    'ui__longtasks#tools_legend__title' => "ツール",
    'ui__longtasks__description' => "バックグラウンドタスクを管理",
    'ui__longtasks__short-title' => "バックグラウンドタスク",
    'ui__longtasks__title' => "バックグラウンドタスク",
    'ui__longtasks/longtask/properties#current_operation__title' => "現在の操作：",
    'ui__longtasks/longtask/properties#finish_time__title' => "予想完了時間：",
    'ui__longtasks/longtask/properties#general_legend__title' => "全般",
    'ui__longtasks/longtask/properties#owner__title' => "タスク開始ユーザ：",
    'ui__longtasks/longtask/properties#progress__title' => "進行状態：",
    'ui__longtasks/longtask/properties#start_time__title' => "タスク開始時間：",
    'ui__longtasks/longtask/properties#status_legend__title' => "タスク状態",
    'ui__longtasks/longtask/properties__description' => "バックグラウンドタスク状態および情報",

    'ui__longtasks/properties__description' => "バックグラウンドタスクの設定",
    'ui__longtasks/properties__short-title' => "設定",
    'ui__longtasks/properties__title' => "バックグラウンドタスク",

    // updated
    'ui__mass-mail/template#list_header__title' => '一括メールメッセージテンプレート',
    'ui__mass-mail/template#list_header__name__title' => 'テンプレート名',
    'ui__mass-mail/template#list_header__from_email__title' => '送信者',
    'ui__mass-mail/template#list_header__to__title' => '受信者',
    'ui__mass-mail/template#list_header__subject__title' => '件名',
    'ui__mass-mail/template#list_header__cdate__title' => '作成日',
    'ui__mass-mail/template#list_header__send__title' => '送信',

    'ui__mass-mail/template/properties__short-title' => '%1',
    'ui__mass-mail/template/properties__title' => '一括メールメッセージテンプレートを編集',
    'ui__mass-mail/template/properties__description' => 'この一括メールメッセージテンプレートを編集します。',

    'ui__mass-mail/template/properties_unknown-new__short-title' => '一括メールテンプレートを追加',
    'ui__mass-mail/template/properties_unknown-new__title' => '一括メールテンプレートを追加',
    'ui__mass-mail/template/properties_unknown-new__description' => '一括メールメッセージテンプレートを追加します。',
    'ui__mass-mail/send__short-title' => '一括メールを送信',
    'ui__mass-mail/send__title' => '一括メールメッセージを送信',
    'ui__mass-mail/send__description' => '選択した受信者に一括メールメッセージを送信します。',
    'ui__mass-mail/template/delete_multi__short-title' => '一括メールテンプレートを削除',
    'ui__mass-mail/template/delete_multi__title' => '一括メールメッセージテンプレートを削除：',
    'ui__mass-mail/template/delete_multi__description' => '選択した一括メールメッセージテンプレートを削除します。',
    'ui__mass-mail/template/delete_multi__done' => '選択したメッセージテンプレートは削除されました',
    'ui__mass-mail/template/properties__invalid_values' => '無効な値が指定されています。',


    // old
    'ui__mass-mail#body_text__description' => 'メッセージテキスト内で変数 <name> を使用できます（ただし、ヘッダを除く）。この変数は、顧客またはリセラーの担当者名に置き換えられます。',
    'ui__mass-mail#body_text__title' => 'メッセージテキスト',
    'ui__mass-mail#compose_legend__title' => 'メッセージ',
    'ui__mass-mail#from_email_text__title' => '送信元（メールアドレス）',
    'ui__mass-mail#list_header__cdate__title' => '作成日',
    'ui__mass-mail#list_header__from_email__title' => 'From',
    'ui__mass-mail#list_header__name__title' => '名前',
    'ui__mass-mail#list_header__send__title' => 'メッセージを作成',
    'ui__mass-mail#list_header__subject__title' => '件名',
    'ui__mass-mail#list_header__title' => '一括メールメッセージテンプレート',
    'ui__mass-mail#list_header__to__title' => '宛先',
    'ui__mass-mail#list_legend__title' => '一括メールメッセージテンプレート',
    'ui__mass-mail#load_template_text__title' => '読込',
    'ui__mass-mail#name_text__title' => 'テンプレート名',
    'ui__mass-mail#option_mode_all__title' => 'すべて',
    'ui__mass-mail#option_mode_except__title' => '選択以外すべて',
    'ui__mass-mail#option_mode_select__title' => '選択のみ',
    'ui__mass-mail#option_select_template__title' => '--- テンプレート選択---',
    'ui__mass-mail#picker_legend__title' => 'メールメッセージテンプレート',
    'ui__mass-mail#picker_title__title' => 'テンプレートを選択する',
    'ui__mass-mail#save_as_legend__title' => 'テンプレートとして保存する',
    'ui__mass-mail#save_as_text__title' => '作成したメッセージを新しいテンプレートに保存',
    'ui__mass-mail#subject_text__title' => '件名',
    'ui__mass-mail#template_legend__title' => 'テンプレート',
    'ui__mass-mail#to_admin_text__title' => 'Plesk 管理者',
    'ui__mass-mail#to_clients_text__title' => '顧客',
    'ui__mass-mail#to_domains_text__title' => 'ドメイン管理者',
    'ui__mass-mail#to_select_text__title' => 'アドレスを選択',
    'ui__mass-mail#to_show_hide_text__title' => '選択を表示/非表示',
    'ui__mass-mail#to_text__title' => '宛先',
    'ui__mass-mail#tools_legend__title' => 'ツール',
    'ui__mass-mail__already_exists' => '名前が %1 のテンプレートは存在します。',
    'ui__mass-mail__none-available' => 'メッセージテンプレートがありません',

    'ui__mass-mail/delete__description' => '一括メールメッセージテンプレート %1 を削除',

    'ui__mass-mail/delete__empty_selection' => '削除したいテンプレートを選択してください',
    'ui__mass-mail/delete__short-title' => '%1 を削除',
    'ui__mass-mail/delete__title' => '一括メールメッセージテンプレート %1 を削除',
    'ui__mass-mail/delete_multi__description' => '一括メールメッセージテンプレートを削除します。',

    'ui__mass-mail/delete_multi__short-title' => '削除',
    'ui__mass-mail/delete_multi__title' => '一括メールメッセージテンプレートを削除',
    'ui__mass-mail/delete_multi__wizard-title' => '一括メールメッセージテンプレートの削除',
    'ui__mass-mail/delete_multi__wizard__1_multi' => '削除する一括メールメッセージテンプレートを選択してください。',
    'ui__mass-mail/delete_multi__wizard__2_multi' => 'チェックボックスを選択してテンプレートの削除を確認し、［終了］をクリックしてウィザードを終了してください。',
    'ui__mass-mail/delete_unknown__description' => '一括メールメッセージテンプレートを削除します。',
    'ui__mass-mail/delete_unknown__short-title' => '削除',
    'ui__mass-mail/delete_unknown__title' => '一括メールメッセージテンプレートを削除',
    'ui__mass-mail/delete_unknown__wizard-title' => '一括メールメッセージテンプレートの削除',
    'ui__mass-mail/delete_unknown__wizard__1_unknown' => '削除する一括メールメッセージテンプレートを選択してください。',
    'ui__mass-mail/delete_unknown__wizard__2' => 'チェックボックスを選択してテンプレートの削除を確認し、［終了］をクリックしてウィザードを終了します。',

    'ui__mass-mail/properties__description' => 'メールメッセージテンプレート %1 を編集します。',

    'ui__mass-mail/properties__invalid_values' => '無効な値を指定しています。',
    'ui__mass-mail/properties__short-title' => '%1',
    'ui__mass-mail/properties__title' => 'メールメッセージテンプレート %1 を編集',

    'ui__mass-mail/properties_new__wizard-title' => '一括メールメッセージテンプレートを作成',
    'ui__mass-mail/properties_unknown-new__description' => '一括メールメッセージテンプレートを作成します。',
    'ui__mass-mail/properties_unknown-new__short-title' => 'メールメッセージテンプレートを追加',
    'ui__mass-mail/properties_unknown-new__title' => 'メールメッセージテンプレートを作成',
    'ui__mass-mail/properties_unknown__wizard-title' => '一括メールメッセージテンプレートを編集',
    'ui__mass-mail/properties_unknown__wizard__1_unknown' => '編集するテンプレートを選択し、［次へ >>］をクリックしてください。',
    'ui__mass-mail/properties_unknown__wizard__2' => 'テンプレートの編集が完了次第、［終了］をクリックして変更を適用し、ウィザードを終了してください。',

    'ui__mass-mail/send__invalid_values' => '無効な値を指定しています。',

    'ui__mass-mail/send_new__wizard-title' => 'メッセージテンプレートを作成してメールを送信',
    'ui__mass-mail/send_unknown-new__description' => '選択した受信者にメールを送信',

    'ui__mass-mail/send_unknown-new__short-title' => '一括メールを送信',
    'ui__mass-mail/send_unknown-new__title' => '一括メールメッセージを送信',
    'ui__mass-mail/send_unknown__description' => '選択した受信者にメールを送信',

    'ui__mass-mail/send_unknown__short-title' => '一括メールを送信',
    'ui__mass-mail/send_unknown__title' => '一括メールメッセージを送信',
    'ui__mass-mail/send_unknown__wizard-title' => '一括メールメッセージを送信',
    'ui__mass-mail/send_unknown__wizard__1_unknown' => '必要なテンプレートを選択し、［次へ >>］をクリックしてください。',
    'ui__mass-mail/send_unknown__wizard__2' => 'テンプレートのプロパティ編集が完了次第、［終了］をクリックしてメッセージを送信し、ウィザードを終了してください。',

    'ui__mass-email/delete__description' => '選択した一括メールメッセージテンプレートを削除します。',

    'ui__mass-email/delete__empty_selection' => "削除するテンプレートを選択します。",
    'ui__mass-email/delete__short-title' => "%1 を削除",
    'ui__mass-email/delete__title' => "一括メールメッセージテンプレート %1 を削除",
    'ui__mass-email/delete_multi__description' => "一括メールメッセージテンプレートを削除します。",

    'ui__mass-email/delete_multi__short-title' => "削除",
    'ui__mass-email/delete_multi__title' => "一括メールメッセージテンプレートを削除",
    'ui__mass-email/delete_multi__wizard__mass-mail/delete_multi' => "チェックボックスを選択してテンプレートの削除を確認し、［終了］をクリックしてウィザードを終了してください。",
    'ui__mass-email/delete_multi__wizard__mass-mail_multi' => "削除する一括メールメッセージテンプレートを選択してください。",
    'ui__mass-email/delete_multi__wizard-title' => "一括メールメッセージテンプレートの削除",
    'ui__mass-email/delete_unknown__description' => "一括メールメッセージテンプレートを削除します。",
    'ui__mass-email/delete_unknown__short-title' => "削除",
    'ui__mass-email/delete_unknown__title' => "一括メールメッセージテンプレートを削除",
    'ui__mass-email/delete_unknown__wizard__mass-mail/delete' => "チェックボックスを選択してテンプレートの削除を確認し、［終了］をクリックしてウィザードを終了します。",
    'ui__mass-email/delete_unknown__wizard__mass-mail_unknown' => "削除する一括メールメッセージテンプレートを選択してください。",
    'ui__mass-email/delete_unknown__wizard-title' => "一括メールメッセージテンプレートの削除",
    'ui__mass-email/send__description' => "選択した受信者にメールを送信",
    'ui__mass-email/send__short-title' => "一括メールを送信",
    'ui__mass-email/send__title' => "一括メールメッセージを送信",
    'ui__mass-email/send_main__description' => "選択した受信者にメールを送信",

    'ui__mass-email/send_main__short-title' => "一括メールを送信",
    'ui__mass-email/send_main__title' => "一括メールメッセージを送信",
    'ui__mass-email/send_selectresellers__title' => 'リセラーの選択',
    'ui__mass-email/send_selectresellers__short-title' => 'リセラー',
    'ui__mass-email/send_selectresellers__description' => 'リセラーアカウントの選択',

    'ui__mass-email/send_selectclients__description' => "顧客アカウントの選択",

    'ui__mass-email/send_selectclients__short-title' => "顧客",
    'ui__mass-email/send_selectclients__title' => "顧客の選択",
    'ui__mass-email/send_selectdomainusers__description' => "ドメイン管理者アカウントの選択",

    'ui__mass-email/send_selectdomainusers__short-title' => "ドメイン管理者",
    'ui__mass-email/send_selectdomainusers__title' => "ドメイン管理者の選択",
    'ui__mass-email/template/properties_main__description' => "一括メールメッセージテンプレートを作成",
    'ui__mass-email/template/properties_main__short-title' => "テンプレートを編集する",
    'ui__mass-email/template/properties_main__title' => "一括メールメッセージテンプレートを編集",
    'ui__mass-email/template/properties_new-main__description' => "一括メールメッセージ用のテンプレートを作成します。",
    'ui__mass-email/template/properties_new-main__short-title' => "一括メールメッセージテンプレートを作成",
    'ui__mass-email/template/properties_new-main__title' => "一括メールメッセージテンプレートを作成",
    'ui__mass-email/template/properties_new-selectclients__description' => "このテンプレートに基づく一括メールメッセージの送信先とする顧客を選択します。",
    'ui__mass-email/template/properties_new-selectclients__title' => "このテンプレートに基づく一括メールメッセージの送信先とする顧客を選択します。",
    'ui__mass-email/template/properties_new-selectdomainusers__description' => "このテンプレートに基づく一括メールメッセージの送信先とするドメイン管理者を選択します。",
    'ui__mass-email/template/properties_new-selectdomainusers__title' => "このテンプレートに基づく一括メールメッセージの送信先とするドメイン管理者を選択します。",
    'ui__mass-email/template/properties_selectclients__title' => "このテンプレートに基づく一括メールメッセージの送信先とする顧客を選択します。",
    'ui__mass-email/template/properties_selectdomainusers__title' => "このテンプレートに基づく一括メールメッセージの送信先とするドメイン管理者を選択します。",

    'ui__mass-email/template/properties_unknown-new__description' => "一括メールメッセージテンプレートを作成",
    'ui__mass-email/template/properties_unknown-new__short-title' => "テンプレート作成",
    'ui__mass-email/template/properties_unknown-new__title' => "一括メールメッセージテンプレートを作成",
    'ui__news/dismiss__description' => 'ニュースフレームを閉じます。ニュース記事が更新されるまで、Plesk はこのフレームを表示しません。',

    'ui__news/dismiss__title' => 'ニュースを閉じる',

    'ui__server__description' => 'サーバ管理',
    'ui__server__short-title' => 'サーバ管理',
    'ui__server__title' => 'サーバ管理',


    // UNUSED SINCE 9.2



    // END OF UNUSED SINCE 9.2

    'ui__server/ip-address__disabled-warning' => 'IP アドレス %1 が利用できません',
    'ui__server/ip-address__none-available' => 'IP アドレスがありません',
    'ui__server/ip-addresses/ip-address__title' => "IP アドレス",
    'ui__server/ip-address/client/properties_new__description' => "IP アドレス %1 をリセラーに割り当てます。",
    'ui__server/ip-address/client/properties_new__short-title' => '割り当て',
    'ui__server/ip-address/client/properties_new__title' => "IP アドレス %1 をリセラーに割り当て",
    'ui__server/ip-address/client__none-available' => 'ユーザアカウントがありません',
    'ui__server/ip-address/client_unknown__quick_search' => 'ユーザ',
    'ui__server/ip-address/client_unknown__wizard-title' => 'この IP アドレスを使用しているユーザの一覧',
    'ui__server/ip-address/client_unknown__wizard__3_unknown' => 'IP アドレスを選択してください。',
    'ui__server/ip-address/client/delete__description' => 'リセラーからの IP アドレス割り当て解除',
    'ui__server/ip-address/client/delete__short-title' => '割り当て解除',
    'ui__server/ip-address/client/delete__title' => 'リセラーからの IP アドレス割り当て解除',
    'ui__server/ip-address/client/delete_multi__description' => "リセラーのプールから IP アドレスの割り当てを解除します。",

    'ui__server/ip-address/client/delete_multi__short-title' => '割り当て解除',
    'ui__server/ip-address/client/delete_multi__title' => 'リセラーからの IP アドレス割り当て解除',
    'ui__server/ip-address/client/delete_multi__wizard-title' => "ユーザのプールから IP アドレスを削除します。",
    'ui__server/ip-address/client/delete_multi__wizard__3_unknown' => 'ユーザからIP アドレスを割り当て解除したい場合、該当する IP を選択し、［次へ >>］をクリックしてください。',
    'ui__server/ip-address/client/delete_multi__wizard__3_multi' => 'IP アドレスを割り当て解除したいユーザを選択し、［次へ >>］をクリックしてください。',
    'ui__server/ip-address/client/delete_multi__wizard__4_multi' => 'ユーザからの IP アドレス解除を確認するには、チェックボックスを選択し［終了］をクリックしてウィザードを完了してください。',
    'ui__server/ip-address/client/delete_unknown__description' => 'リセラーからの IP アドレス割り当て解除',
    'ui__server/ip-address/client/delete_unknown__short-title' => '割り当て解除',
    'ui__server/ip-address/client/delete_unknown__title' => 'リセラーからの IP アドレス割り当て解除',
    'ui__server/ip-address/client/delete_unknown__wizard-title' => 'ユーザから IP アドレスを解除する',
    'ui__server/ip-address/client/delete_unknown__wizard__3_unknown' => 'ユーザからIP アドレスを割り当て解除したい場合、該当する IP を選択し、［次へ >>］をクリックしてください。',
    'ui__server/ip-address/client/delete_unknown__wizard__4_unknown' => 'IP アドレスを解除したいユーザを選択し、［次へ >>］をクリックしてください。',
    'ui__server/ip-address/client/delete_unknown__wizard__5' => 'ユーザからの IP アドレス解除を確認するには、チェックボックスを選択し［終了］をクリックしてウィザードを完了してください。',

    'ui__server/ip-address/domain__description' => "IP アドレス %1 上のすべてのドメイン",
    'ui__server/ip-address/domain__short-title' => "ドメイン",
    'ui__server/ip-address/domain__title' => "IP アドレス %1 上のドメイン",
    'ui__server/ip-address/domain_unknown__description' => "IP アドレス上のすべてのドメイン",
    'ui__server/ip-address/domain_unknown__short-title' => "ドメイン",
    'ui__server/ip-address/domain_unknown__title' => "IP アドレス上のドメイン",
    'ui__server/ip-address/domain_unknown__wizard__3_unknown' => "必要な IP アドレスを選択し、［次へ >>］をクリックしてください。",

    'ui__server/ip-address/properties__description' => 'IP アドレス %1 のプロパティを変更する',
    'ui__server/ip-address/properties__short-title' => 'プロパティ',
    'ui__server/ip-address/properties__title' => 'IP アドレス %1 のプロパティを変更する',

    'ui__server/ip-address/properties_new__wizard-title' => 'IP アドレスを追加',
    'ui__server/ip-address/properties_new__wizard__4_new' => 'IP アドレスのプロパティを変更したら、［終了］をクリックして変更を適用してください。',
    'ui__server/ip-address/properties_unknown__description' => 'IP アドレスのプロパティを変更する',
    'ui__server/ip-address/properties_unknown__short-title' => 'プロパティ',
    'ui__server/ip-address/properties_unknown__title' => 'IP アドレスのプロパティを変更する',
    'ui__server/ip-address/properties_unknown__wizard-title' => 'IP アドレスのプロパティを変更する',
    'ui__server/ip-address/properties_unknown__wizard__3_unknown' => 'プロパティを変更したい IP アドレスを選択してください。',
    'ui__server/ip-address/properties_unknown__wizard__4' => 'IP アドレスのプロパティを変更したら、［終了］をクリックして変更を適用してください。',

    'ui__server/spam-filter/black-list__description' => 'サーバ全体のスパムフィルタにブラックリストを設定する',
    'ui__server/spam-filter/black-list__short-title' => 'ブラックリスト',
    'ui__server/spam-filter/black-list__title' => 'サーバ全体に対するスパムフィルタのブラックリスト',

    'ui__server/spam-filter/black-list/address__addresses_available' => '最初の %1 件のメールアドレスまで追加されます。',
    'ui__server/spam-filter/black-list/address__description' => 'スパムフィルタのブラックリストアドレス',

    'ui__server/spam-filter/black-list/address__empty_content' => 'リストにメールアドレスが含まれていません。',
    'ui__server/spam-filter/black-list/address__file_size' => 'アップロードされたファイルが無効です',
    'ui__server/spam-filter/black-list/address__invalid_addresses' => '次のメールアドレスが無効です。%1。',
    'ui__server/spam-filter/black-list/address__none-available' => 'スパムフィルタのブラックリストにアドレスが含まれていません。',
    'ui__server/spam-filter/black-list/address__short-title' => 'アドレス',
    'ui__server/spam-filter/black-list/address__title' => 'ブラックリストアドレス %1',
    'ui__server/spam-filter/black-list/address_unknown__description' => 'ブラックリストにアドレスを追加する',
    'ui__server/spam-filter/black-list/address_unknown__short-title' => 'アドレスを追加',
    'ui__server/spam-filter/black-list/address_unknown__title' => 'ブラックリストにアドレスを追加する',

    'ui__server/spam-filter/black-list/address/delete__description' => 'アドレス %1 をサーバ全体のブラックリストから削除します。',

    'ui__server/spam-filter/black-list/address/delete__short-title' => '削除',
    'ui__server/spam-filter/black-list/address/delete__title' => 'アドレス %1 をサーバ全体のブラックリストから削除',
    'ui__server/spam-filter/black-list/address/delete_multi__description' => 'サーバ全体のブラックリストからアドレスを削除する',

    'ui__server/spam-filter/black-list/address/delete_multi__short-title' => '削除',
    'ui__server/spam-filter/black-list/address/delete_multi__title' => 'サーバ全体のブラックリストからアドレスを削除する',
    'ui__server/spam-filter/black-list/address/delete_multi__wizard-title' => 'サーバ全体に対するスパムフィルタで使用するブラックリストから、アドレスを削除する',
    'ui__server/spam-filter/black-list/address/delete_multi__wizard__4_multi' => '削除するアドレスを選択し、［次へ >>］をクリックしてください。',
    'ui__server/spam-filter/black-list/address/delete_multi__wizard__5_multi' => 'チェックボックスをオンにしてスパムフィルタアドレスの削除を確認して［終了］をクリックすると、アドレスが完全に削除されます。',
    'ui__server/spam-filter/black-list/address/delete_unknown__description' => 'サーバ全体のブラックリストからアドレスを削除する',
    'ui__server/spam-filter/black-list/address/delete_unknown__short-title' => '削除',
    'ui__server/spam-filter/black-list/address/delete_unknown__title' => 'サーバ全体のブラックリストからアドレスを削除する',
    'ui__server/spam-filter/black-list/address/delete_unknown__wizard-title' => 'サーバ全体に対するスパムフィルタで使用するブラックリストから、アドレスを削除する',
    'ui__server/spam-filter/black-list/address/delete_unknown__wizard__4_unknown' => '削除するアドレスを選択し、［次へ >>］をクリックしてください。',
    'ui__server/spam-filter/black-list/address/delete_unknown__wizard__5' => 'チェックボックスをオンにしてスパムフィルタアドレスの削除を確認して［終了］をクリックすると、アドレスが完全に削除されます。',

    'ui__server/spam-filter/black-list/address/properties__addresses_available' => '最初の %1 件のメールアドレスまで追加されます。',
    'ui__server/spam-filter/black-list/address/properties__empty_content' => 'リストにメールアドレスが含まれていません。',
    'ui__server/spam-filter/black-list/address/properties__file_size' => 'ファイルをアップロードできません。アップロードできるファイルの最大サイズは %1 です。',
    'ui__server/spam-filter/black-list/address/properties__invalid_addresses' => '次のメールアドレスが無効です。%1。',

    'ui__server/spam-filter/black-list/address/properties_unknown-new__description' => 'ブラックリストにアドレスを追加する',
    'ui__server/spam-filter/black-list/address/properties_unknown-new__short-title' => 'アドレスを追加',
    'ui__server/spam-filter/black-list/address/properties_unknown-new__title' => 'ブラックリストにアドレスを追加する',

    'ui__server/spam-filter/properties__description' => 'サーバ全体のスパムフィルタを設定する',

    'ui__server/spam-filter/properties__short-title' => '設定',
    'ui__server/spam-filter/properties__title' => 'スパムフィルタ設定',

    'ui__server/spam-filter/toggle_disable__description' => 'システム全体に対してスパムフィルタを無効にする',

    'ui__server/spam-filter/toggle_disable__short-title' => '無効化',
    'ui__server/spam-filter/toggle_disable__title' => 'スパムフィルタを無効にする',
    'ui__server/spam-filter/toggle_enable__description' => 'サーバ全体に対してスパムフィルタを有効にする',

    'ui__server/spam-filter/toggle_enable__short-title' => '有効化',
    'ui__server/spam-filter/toggle_enable__title' => 'スパムフィルタを有効にする',
    'ui__server/spam-filter/toggle_unknown__description' => 'サーバ全体に対するスパムフィルタを有効または無効にする',
    'ui__server/spam-filter/toggle_unknown__short-title' => '有効または無効',
    'ui__server/spam-filter/toggle_unknown__title' => 'スパムフィルタを有効または無効にする',
    'ui__server/spam-filter/toggle_unknown__wizard-title' => 'スパムフィルタを有効または無効にする',

    'ui__server/spam-filter/white-list__description' => 'システム全体に対するスパムフィルタホワイトリストを設定する',
    'ui__server/spam-filter/white-list__short-title' => 'ホワイトリスト',
    'ui__server/spam-filter/white-list__title' => 'システム全体に対するスパムフィルタホワイトリスト',

    'ui__server/spam-filter/white-list/address__addresses_available' => '最初の %1 件のメールアドレスまで追加されます。',
    'ui__server/spam-filter/white-list/address__description' => 'スパムフィルタのホワイトリストアドレス',

    'ui__server/spam-filter/white-list/address__empty_content' => 'リストにメールアドレスが含まれていません。',
    'ui__server/spam-filter/white-list/address__file_size' => 'アップロードされたファイルが無効です',
    'ui__server/spam-filter/white-list/address__invalid_addresses' => '次のメールアドレスが無効です。%1。',
    'ui__server/spam-filter/white-list/address__none-available' => 'スパムフィルタのサーバ全体に対するホワイトリストに、アドレスが含まれていません',
    'ui__server/spam-filter/white-list/address__short-title' => 'アドレス',
    'ui__server/spam-filter/white-list/address__title' => 'ホワイトリストアドレス %1',
    'ui__server/spam-filter/white-list/address_unknown__description' => 'ホワイトリストにアドレスを追加する',
    'ui__server/spam-filter/white-list/address_unknown__short-title' => 'アドレスを追加',
    'ui__server/spam-filter/white-list/address_unknown__title' => 'ホワイトリストにアドレスを追加する',

    'ui__server/spam-filter/white-list/address/delete__description' => 'サーバ全体のブラックリストからドレス %1 を削除する',

    'ui__server/spam-filter/white-list/address/delete__short-title' => '削除',
    'ui__server/spam-filter/white-list/address/delete__title' => 'サーバ全体のホワイトリストからアドレス %1 を削除する',
    'ui__server/spam-filter/white-list/address/delete_multi__description' => 'サーバ全体のホワイトリストからアドレスを削除する',

    'ui__server/spam-filter/white-list/address/delete_multi__short-title' => '削除',
    'ui__server/spam-filter/white-list/address/delete_multi__title' => 'サーバ全体のホワイトリストからアドレスを削除する',
    'ui__server/spam-filter/white-list/address/delete_multi__wizard-title' => 'サーバ全体に対するスパムフィルタで使用するホワイトリストからアドレスを除外する',
    'ui__server/spam-filter/white-list/address/delete_multi__wizard__4_multi' => '削除するアドレスを選択し、［次へ >>］をクリックしてください。',
    'ui__server/spam-filter/white-list/address/delete_multi__wizard__5_multi' => 'チェックボックスをオンにしてスパムフィルタアドレスの削除を確認して［終了］をクリックすると、アドレスが完全に削除されます。',
    'ui__server/spam-filter/white-list/address/delete_unknown__description' => 'サーバ全体のホワイトリストからアドレスを削除する',
    'ui__server/spam-filter/white-list/address/delete_unknown__short-title' => '削除',
    'ui__server/spam-filter/white-list/address/delete_unknown__title' => 'サーバ全体のホワイトリストからアドレスを削除する',
    'ui__server/spam-filter/white-list/address/delete_unknown__wizard-title' => 'サーバ全体に対するスパムフィルタで使用するホワイトリストからアドレスを除外する',
    'ui__server/spam-filter/white-list/address/delete_unknown__wizard__4_unknown' => '削除するアドレスを選択し、［次へ >>］をクリックしてください。',
    'ui__server/spam-filter/white-list/address/delete_unknown__wizard__5' => 'チェックボックスをオンにしてスパムフィルタアドレスの削除を確認して［終了］をクリックすると、アドレスが完全に削除されます。',

    'ui__server/spam-filter/white-list/address/properties__addresses_available' => '最初の %1 件のメールアドレスまで追加されます。',
    'ui__server/spam-filter/white-list/address/properties__empty_content' => 'リストにメールアドレスが含まれていません。',
    'ui__server/spam-filter/white-list/address/properties__file_size' => 'ファイルをアップロードできません。アップロードできるファイルの最大サイズは %1 です。',
    'ui__server/spam-filter/white-list/address/properties__invalid_addresses' => '次のメールアドレスが無効です。%1。',

    'ui__server/spam-filter/white-list/address/properties_unknown-new__description' => 'ホワイトリストにアドレスを追加する',
    'ui__server/spam-filter/white-list/address/properties_unknown-new__short-title' => 'アドレスを追加',
    'ui__server/spam-filter/white-list/address/properties_unknown-new__title' => 'ホワイトリストにアドレスを追加する',

    'ui__server/mail/statistics#apply__description' => "フィルタの適用",
    'ui__server/mail/statistics#apply__title' => "適用する",
    'ui__server/mail/statistics#custom_from__title' => "From",
    'ui__server/mail/statistics#custom_to__title' => "宛先",
    'ui__server/mail/statistics#period_all__title' => "すべて",
    'ui__server/mail/statistics#period_custom__title' => "カスタム",
    'ui__server/mail/statistics#period_month__title' => "今月",
    'ui__server/mail/statistics#period_prev_month__title' => "先月",
    'ui__server/mail/statistics#period_prev_week__title' => "先週",
    'ui__server/mail/statistics#period_today__title' => "今日",
    'ui__server/mail/statistics#period_week__title' => "今週",
    'ui__server/mail/statistics#period_yesterday__title' => "昨日",
    'ui__server/mail/statistics#show_for_period__title' => "表示期間",
    'ui__server/mail/statistics#tools_legend__title' => "ツール",
    'ui__server/mail/statistics__description' => "スパムとウイルス統計の表示",

    'ui__server/mail/statistics__short-title' => "統計",
    'ui__server/mail/statistics__title' => "統計",
    'ui__server/mail/statistics/spam#statistics_legend__title' => "スパム統計",
    'ui__server/mail/statistics/spam#tools_legend__title' => "ツール",
    'ui__server/mail/statistics/spam__description' => "スパム統計の表示",

    'ui__server/mail/statistics/spam__short-title' => "スパム統計",
    'ui__server/mail/statistics/spam__title' => "スパム統計",
    'ui__server/mail/statistics/spam/recipients#list_header__name__title' => "メール名",
    'ui__server/mail/statistics/spam/recipients#list_header__ratio__title' => "%",
    'ui__server/mail/statistics/spam/recipients#list_header__sort_by_name__title' => "メールアカウント順に並べ替える",
    'ui__server/mail/statistics/spam/recipients#list_header__sort_by_ratio__title' => "全体に占める割合（%）に従って並べ替える",
    'ui__server/mail/statistics/spam/recipients#list_header__sort_by_val__title' => "受信スパム数順に並べ替える　",
    'ui__server/mail/statistics/spam/recipients#list_header__title' => "メールアカウント",
    'ui__server/mail/statistics/spam/recipients#list_header__val__title' => "受信したスパム",
    'ui__server/mail/statistics/spam/recipients__description' => "受信者",

    'ui__server/mail/statistics/spam/recipients__short-title' => "受信者",
    'ui__server/mail/statistics/spam/recipients__title' => "受信者",
    'ui__server/mail/statistics/spam/summary#clean__title' => "クリーン",
    'ui__server/mail/statistics/spam/summary#infected__title' => "感染",
    'ui__server/mail/statistics/spam/summary#list_header__name__title' => "ステータス",
    'ui__server/mail/statistics/spam/summary#list_header__ratio__title' => "%",
    'ui__server/mail/statistics/spam/summary#list_header__val__title' => "件数",
    'ui__server/mail/statistics/spam/summary#protected__title' => "保護",
    'ui__server/mail/statistics/spam/summary#skipped__title' => "未チェック",
    'ui__server/mail/statistics/spam/summary__description' => "概要",

    'ui__server/mail/statistics/spam/summary__short-title' => "概要",
    'ui__server/mail/statistics/spam/summary__title' => "概要",
    'ui__server/mail/statistics/virus#statistics_legend__title' => "ウイルス統計",
    'ui__server/mail/statistics/virus#tools_legend__title' => "ツール",
    'ui__server/mail/statistics/virus__description' => "ウイルス統計の表示",

    'ui__server/mail/statistics/virus__short-title' => "ウイルス統計",
    'ui__server/mail/statistics/virus__title' => "ウイルス統計",
    'ui__server/mail/statistics/virus/recipients#list_header__name__title' => "メールアカウント",
    'ui__server/mail/statistics/virus/recipients#list_header__ratio__title' => "%",
    'ui__server/mail/statistics/virus/recipients#list_header__sort_by_name__title' => "メール名順に並べ替える",
    'ui__server/mail/statistics/virus/recipients#list_header__sort_by_ratio__title' => "全体に占める割合（%）に従って並べ替える",
    'ui__server/mail/statistics/virus/recipients#list_header__sort_by_val__title' => "受信ウイルス数順に並べ替える",
    'ui__server/mail/statistics/virus/recipients#list_header__title' => "メールアカウント",
    'ui__server/mail/statistics/virus/recipients#list_header__val__title' => "受信したウイルス",
    'ui__server/mail/statistics/virus/recipients__description' => "受信者",

    'ui__server/mail/statistics/virus/recipients__short-title' => "受信者",
    'ui__server/mail/statistics/virus/recipients__title' => "受信者",
    'ui__server/mail/statistics/virus/summary#clean__title' => "クリーン",
    'ui__server/mail/statistics/virus/summary#infected__title' => "感染",
    'ui__server/mail/statistics/virus/summary#list_header__name__title' => "ステータス",
    'ui__server/mail/statistics/virus/summary#list_header__ratio__title' => "%",
    'ui__server/mail/statistics/virus/summary#list_header__val__title' => "件数",
    'ui__server/mail/statistics/virus/summary#protected__title' => "保護",
    'ui__server/mail/statistics/virus/summary#skipped__title' => "未チェック",
    'ui__server/mail/statistics/virus/summary__description' => "概要",

    'ui__server/mail/statistics/virus/summary__short-title' => "概要",
    'ui__server/mail/statistics/virus/summary__title' => "概要",
    'ui__server/mail/statistics/virus/viruses#list_header__name__title' => "名前",
    'ui__server/mail/statistics/virus/viruses#list_header__ratio__title' => "%",
    'ui__server/mail/statistics/virus/viruses#list_header__sort_by_name__title' => "名前順に並べ替える",
    'ui__server/mail/statistics/virus/viruses#list_header__sort_by_ratio__title' => "全体に占める割合（%）に従って並べ替える",
    'ui__server/mail/statistics/virus/viruses#list_header__sort_by_val__title' => "感染オブジェクト数順に並べ替える",
    'ui__server/mail/statistics/virus/viruses#list_header__title' => "ウイルス",
    'ui__server/mail/statistics/virus/viruses#list_header__val__title' => "感染したオブジェクト",
    'ui__server/mail/statistics/virus/viruses__description' => "ウイルス",

    'ui__server/mail/statistics/virus/viruses__short-title' => "ウイルス",
    'ui__server/mail/statistics/virus/viruses__title' => "ウイルス",

    'ui__support#param_company__title' => "会社",
    'ui__support#param_email__title' => "メール",
    'ui__support#param_firstname__title' => "名前（名）",
    'ui__support#param_keynumber__title' => "プロダクトキー番号",
    'ui__support#param_operatingsystem__title' => "オペレーティングシステム",
    'ui__support#param_phone__title' => "電話",
    'ui__support#param_psabuild__title' => "Plesk ビルド",
    'ui__support#param_psainsttype__title' => "Plesk インストールタイプ",
    'ui__support#param_psaversion__title' => "Plesk バージョン",

    // *** The strings above have been generated automatically from @@CAPTION directives.

    ////
    //// UI POINTER CAPTIONS END HERE


    // RESELLERS

    // Resellers
    'ui__reseller#tools__title' => "ツール",

    'ui__reseller/traffic-history_unknown__short-title' => "リセラーのトラフィックを表示",
    'ui__reseller/traffic-history_unknown__title' => "リセラーのトラフィックを表示",
    'ui__reseller/traffic-history_unknown__description' => "リセラーアカウントごとにトラフィックを表示します。",
    'ui__reseller#list__title' => "リセラー",
    'accounts_list__name__filter_title' => "名前",
    'accounts_list__resource__filter_title' => "リソース使用",
    'resellers_list__filter_resource_usage_any' => "すべて",
    'resellers_list__filter_resource_usage_overuse' => "利用超過",
    'resellers_list__filter_resource_usage_normal' => "制限内",
    'accounts_list__status__filter_title' => "ステータス",
    'resellers_list__filter_status_any' => "すべて",
    'resellers_list__filter_status_blocked' => "一時停止",
    'resellers_list__filter_status_active' => "アクティブ",
    'resellers_list__filter_clients__filter_title' => "表示する",
    'resellers_list__filter_clients_on' => "リセラーとその顧客",
    'resellers_list__filter_clients_off' => "リセラーのみ",
    '__disk_usage' => "使用済みディスクスペース",
    'ui__reseller/traffic_unknown__short-title' => "リセラーのトラフィックを表示",
    'ui__reseller/traffic_unknown__title' => "リセラーのトラフィックを表示",
    'ui__reseller/traffic#list__title' => "リセラーごとのトラフィック",
    'ui__reseller/traffic_unknown__description' => "トラフィック使用量レポートの表示",

    // Resellers > Traffic by resellers
    '__traffic_by_reseller' => "リセラーごとのトラフィック",

    '__reseller_name' => "リセラー名",
    '__reseller' => "リセラー",
    'resellertrafficlist_header' => "リセラーのトラフィックを表示",
    '__reseller_personal' => "リセラーのドメインで使用しているトラフィック",
    'ui__reseller/traffic-history__short-title' => "リセラーごとのトラフィック",
    'ui__reseller/traffic-history__title' => "リセラーごとのトラフィック",
    'ui__reseller/traffic-history__description' => "トラフィック使用量レポートの表示",

    // Resellers > Create Reseller Account
    'ui__reseller__short-title' => "%1",

    // Resellers > Reseller preferences

    // Resellers > Reseller Account Templates

    // Resellers > Reseller Account Templates > Create Reseller Account Template
    'limits__oversell_text' => "販売超過を許可",
    'limits__reseller_oversell_description' => "販売超過では、リセラーが実際に割り当てられている以上のリソースを販売することを許可します。販売超過が許可されている場合、リセラーは最初に割り当てられたリソース量ではなく、実際のリソース使用量によって管理されます。",
    'limits__overuse_block_text' => "利用超過ポリシー",
    'limits__overuse_block_true_text' => "利用超過を許可しない",
    'limits__reseller_overuse_block_true_description' => "リソースの利用超過をブロックしません。実際のリソース使用量は、設定時のリソース割り当てを超過できません",
    'limits__overuse_block_false_text' => "利用超過を許可する",
    'limits__reseller_overuse_block_false_description' => "リソースの利用超過をブロックせず、設定時の割り当て以上のリソースを利用することを許可します。設定時のリソース量を超過するリソースを利用できます。",
    'limits__reseller_overuse_notify_text' => "リソース制限値に達したリセラーに通知します。",
    'reseller_perm__manage_sh_access_disabled' => "リセラーはシェルアクセスを許可または禁止できません",
    'reseller_perm__manage_sh_access_chrooted' => "リセラーは Chrooted 環境のみアクセスを許可できます。",
    'reseller_perm__manage_sh_access_any' => "リセラーはすべてのタイプのシェルアクセスを許可できます。",
    'template__reseller_num_excl_ips' => "リセラーに専用 IP アドレスを割り当てる",

    // Reseller's Home page
    'ui__reseller#tools2__title' => "アカウント",
    'ui__reseller#info__title' => "情報",
    'ui__reseller#clientsTab__title' => "顧客",
    'ui__reseller#domainsTab__title' => "ドメイン",
    'ui__reseller__title' => "%1 のリセラーアカウントを管理",
    'domains__reseller_info' => "%1 顧客、%2 ドメイン、%3 ディスク使用量、%4 データ転送",
    'domains__reseller_info_hiding_traffic' => "%1 顧客、%2 ドメイン、%3 ディスクスペースを使用。",
    'ui__reseller__description' => "リセラーアカウント管理",

    'ui__reseller/limits_unknown__wizard-title' => 'リセラーのリソース制限を表示/変更する',
    'ui__reseller/limits_unknown__wizard__1_unknown' => '必要なリセラーを選択してください。',
    'ui__reseller/limits_unknown__wizard__2' => '変更を適用するには、［終了］をクリックしてください。',

    'ui__client/report_reseller__short-title' => "レポート",
    'ui__client/report_reseller__title' => "アカウントレポートの表示",
    'ui__client/report_reseller__description' => "リセラーアカウントレポートの表示",
    'ui__client/ip-pool_reseller__short-title' => "IP プール",
    'ui__client/ip-pool_reseller__description' => "リセラーアカウントに IP アドレスおよび SSL/TLS 証明書を割り当てます。",

    //'ui__client/preferences_reseller__short-title' => "Settings",
    //'ui__client/preferences_reseller__description' => "Set Plesk session settings.",

    'ui__reseller/preferences_unknown__wizard__2_self' => "アカウント設定を入力し、［終了］をクリックします。",

    //'ui__client/permissions_reseller__short-title' => "Permissions",
    //'ui__client/permissions_reseller__description' => "View or change permissions for the reseller's account.",

    'ui__reseller/permissions_unknown__wizard-title' => 'リセラーのパーミッションを表示または変更する',
    'ui__reseller/permissions_unknown__wizard__1_unknown' => 'パーミッションを表示または変更するリセラーを選択してください。',
    //'ui__reseller/permissions_unknown__wizard__1/properties_self' => 'When done with viewing your permissions, click Finish to to apply the changes and exit the wizard.',
    'ui__reseller/permissions_unknown__wizard__2' => 'リセラーのパーミッション変更を完了するには、［終了］をクリックして変更を適用した後、ウィザードを終了してください。',

    // Customers > create customer account

    '__resellers_list' => 'リセラー',
    'picker_reseller__title' => 'リセラーを選択する',

    // Resellers > reseller name > customer name
    'ui__client#tools1__title' => "ツール",
    'ui__client#tools2__title' => "アカウント",
    'ui__client#info__title' => "情報",
    'ui__client#clientslist__title' => "顧客",
    'ui__client#domainslist__title' => "ドメイン",

    // Reseller's session in the Customer Panel - Home page

    'feature__aps_categories__reseller' => "すべてのウェブアプリケーションはカテゴリにより分類されています。これにより、インストールするべきアプリケーションを選択することが簡単になりました",
    'feature__domainkeys__reseller' => "DKIM メール送信者認証メカニズムを使用して、スパムメールとフィッシングメールを減らすことができます。",

    '__reseller_form' => "リセラーフォーム",

    // Reseller's session in the control panel - Home page > Manage Customer Settings
    'ui__client/preferences_unknown__wizard__reseller' => "設定を変更する顧客アカウントを選択してください。",

    // Reseller's session in the control panel - Home page > Suspend/Activate Customer Account

    // Reseller's session in the control panel - Home page > Change Customer Limits
    'ui__client/limits_unknown__wizard__1' => "リソース使用量の上限を変更するには、［リソース制限］をクリックしてください。",

    // Reseller's session in the control panel - Home page > Change Customer Permissions
    'ui__client/permissions_unknown__wizard__1' => "顧客が Plesk で実行できる操作のパーミッションを変更するには、［パーミッション］をクリックしてください。",

    // Reseller's session in the control panel - Home page > Create Customer Template
    'template__shared_text' => "他のユーザに対してこのテンプレートを使用可能にする",
    'template__shared_description' => "このオプションをオンにすると、顧客がこのテンプレートを使用できるようになります。",

    // CLIENT (updated for reseller feature):

    // Customers
    'ui__client#tools__title' => 'ツール',

    'ui__client/traffic-history_unknown__short-title' => '顧客ごとのトラフィックの表示',
    'ui__client/traffic-history_unknown__title' => '顧客ごとのトラフィック',
    'ui__client/traffic-history_unknown__description' => '全顧客のトラフィック使用量レポートを表示する',
    'ui__client/traffic-history__short-title' => '顧客ごとのトラフィック',
    'ui__client/traffic-history__title' => '顧客ごとのトラフィックの表示',
    'ui__client/traffic-history__description' => '全顧客のトラフィック使用量レポートを表示する',

    'ui__client/traffic#list__title' => '顧客ごとのトラフィック',
    'ui__reseller/client/traffic#list__title' => '顧客ごとのトラフィック',

    'clients_list__filter_type__filter_title' => '表示する',
    'clients_list__filter_type_any' => '顧客とリセラー',
    'clients_list__filter_type_clients' => '顧客のみ',
    'clients_list__filter_type_resellers' => 'リセラーのみ',
    'ui__client/domain_unknown-new__short-title' => "ドメインを作成",

    // Customers > View traffic by customers
    '__personal' => "ユーザのドメインで使用されているトラフィック",
    'PersonalTrafficList_header_of_client__' => "アカウントのトラフィック使用量レポートを表示する",

    // DOMAINS

    // Domain > Domain Admin Permissions

    'domain_perm__manage_sh_access_disabled' => "ドメイン管理者アカウントにてシェルアクセスを許可または禁止できません",
    'domain_perm__manage_sh_access_chrooted' => "ドメイン管理者は Chrooted 環境へのアクセスを許可することが可能です",
    'domain_perm__manage_sh_access_any' => "ドメイン管理者はいかなるタイプのシェルへのアクセスを許可することが可能です",

    // APS Catalog
    'bt_add_to_vault' => "ヴォルトに追加",
    'bt_hide_updates' => "利用可能なアップデートを隠す",
    'bt_show_updates' => "利用可能なアップデートの表示",

    '__site_apps__applications' => "アプリケーション",
    //search elements
    // Application; Vendor; Packager; Certification level;

    '__site_apps__apps_selected_to_add_to_vault' => "ヴォルトに追加するアプリケーションを選択する",
    'site_apps__application_selected' => "選択済み",
    'site_apps__currently_in_vault' => "他のバージョンがヴォルトに存在します。",
    'site_apps__new_versions' => "新しいバージョン：",
    'site_apps__patches' => "パッチ：F16011",
    'site_apps__applications_have_been_scheduled_for_adding_to_application_vault' => "ヴォルトに追加される予定のアプリケーション数：%1",
    'site_apps__applications_downloading_now' => "以下のアプリケーションをダウンロードしています。%1", // temporary workaround string, to be removed later

    'site_apps__package_already_exist_in_vault' => "ヴォルトに既に存在します。",

    // Server > Action Log
    'bt_skin_edit' => "スキンの詳細を編集",
    'domains__you_want_change_the_status_of_the_reseller??' => "リセラーアカウントの状態を変更しますか？",
    'limits__oversell_legend' => "販売超過",
    'limitsManager__limit_available_error' => "必要なリソース量（%%quantity%% %%limitName%%）を割り当てることができません。%%available%% %%limitName%% のみ使用可能です。",
    'limitsManager__limit_reserved_error' => "リソース使用量の上限（%%quantity%% %%limitName%%）を設定できません。新しい値は顧客に対して予約済みであるか使用済みであるリソース量（%%reserved%% %%limitName%%）より少なくなっています。",
    'limitsManager__limit_used_error' => "リソース使用制限（%%quantity%% %%limitName%%）を設定できません。新しい値は、アカウントおよびサイトで実際に使用されているリソース量より低くなっています（%%used%% %%limitName%%）。",

    'ui__client/domain/traffic#list__title' => "サービスによる帯域幅使用状況",

    'ui__client/domain/traffic_unknown-reseller__short-title' => "トラフィック使用量レポートの表示",
    'ui__client/domain/traffic_unknown-reseller__title' => "トラフィック使用量レポートの表示",

    'ui__client/domain_new__short-title' => "ドメインを作成",

    'ui__client_reseller__description' => "リセラーアカウント %1 を管理",
    'ui__client_reseller__short-title' => "%1",
    'ui__client_reseller__title' => "リセラーアカウントを管理",

    '__owner_name' => "所有者名",
    'domains_list__resource__filter_title' => "リソース利用状況",

    // APS CATALOG
    'site_apps__application_catalog_preferences' => "APS アプリケーションカタログ",
    'site_apps__applications_have_updates' => "以下のアプリケーションのアップデートバージョンを利用できます。\n%1\nアップデートを参照するには検索エリアが表示されていることを確認し、<b>アップデートのみ表示する</b> チェックボックスを選択し必要なアプリケーションを検索してください",
    'site_apps__progress_adding_to_vault' => "ヴォルトに追加：",
    'site_apps__progress_done_message' => "進行状況：",
    'site_apps__progress_applications_left' => "アプリケーションの残り %1/%2",
    'site_apps__download_item_long_task_title' => "APS アプリケーション（%1）のダウンロード",
    'site_apps__download_transaction_long_task_title' => "APS カタログより APS アプリケーションをダウンロードする",
    'site_apps__last_check_for_updates' => "アップデートの最終確認日：%1",
    'site_apps__all_sucessfully_added_to_app_vault' => "すべてのスケジュール済みアプリケーションが、アプリケーションヴォルトへと正常に追加されました　",
    'site_apps__number_of_apps_sucessfully_added_to_app_vault' => "%1 スケジューリング済みのアプリケーションがアプリケーションヴォルトへと正常に追加されました",
    'site_apps__no_search_results' => 'アプリケーションが見つかりません。他の検索文字列を試すか、アプリケーションのカテゴリ検索をお試しください',
    'site_apps__search_results_title' => '検索結果',
    '__site_apps__search_by_application' => 'アプリケーション名',
    '__site_apps__search_by_vendor' => 'ベンダー',
    '__site_apps__search_by_vendor__all' => 'すべてのベンダー',
    '__site_apps__search_by_packager' => 'パッケージャ',
    '__site_apps__search_by_certification_level' => '認証レベル',
    '__site_apps__search_by_cert__any' => 'すべて',
    '__site_apps__search_by_cert__silver_and_higher' => 'シルバー以上',
    '__site_apps__search_by_cert__gold_and_higher' => 'ゴールド以上',
    '__retry' => '再試行',
    'site_apps__application_packager_site' => 'パッケージャ',
    'site_apps__add_to_pool_message' => "［すべてで使用可能］とマークされたアプリケーションは、すべてのリセラーおよび顧客に対してインストール回数無制限で配信されます。制限のあるアプリケーションの場合、すべてのリセラーおよび顧客に対して、インストール回数を明示的に指定して個別に手動で配信する必要があります。",
    'site_apps__make_available_for_all' => "選択したアプリケーションをすべてのユーザが利用可能にする",

    'site_apps__broadcast_app_text' => "［すべてで使用可能］とマークされたアプリケーションは、すべてのリセラーおよび顧客に対してインストール回数無制限で配信されます。制限のあるアプリケーションの場合、すべてのリセラーおよび顧客に対して、インストール回数を明示的に指定して個別に手動で配信する必要があります。",
    'site_apps__broadcast_app_name' => 'アプリケーションをすべてのユーザに対して使用可能にする',

    // User Application Pool per application
    'site_apps__available_clients' => '使用可能なユーザ',
    'site_apps__no_more_clients_to_add_to_pool' => 'このアプリケーションを提供できるユーザアカウントがありません',

    // Installed application instances
    'site_apps__installations' => 'インストレーション',

    // Hosting setup redesign
    '__domain_name_and_ip_address' => "ドメイン名と IP アドレス",
    '__assign_ip_address' => "IP アドレスの割り当て",
    '__switch_on_service' => "サービスをオンにする",
    '__hosting_configuration' => "ホスティング構成",
    '__vrt_hst' => "ウェブサイトホスティング",
    '__vrt_hst_hint' => "このサーバ上でウェブサイトをホスティングする",
    '__fwd' => "転送",
    '__web_hosting_settings' => "ホスティング設定",
    '__fwd_hint' => "訪問者を他のウェブサイトにリダイレクトします。",
    '__none_hint' => "現時点ではウェブサイトをホスティングしません",
    '__login_hint' => "このユーザ名を使用して、FTP 経由でウェブサイトにアクセスします。",
    '__password_hint' => "このパスワードを使用して、FTP 経由でウェブサイトにアクセスします。",
    '__advanced_hosting_setup' => "詳細なウェブサイトホスティング設定",
    '__domain_creation_successful' => "ドメインが作成されました",
    'bt_hosting_settings' => "ホスティング設定",
    '__change_hosting_type' => "ドメイン %1 のホスティングタイプの変更",
    '__hosting_type_change_warning' => "ホスティングタイプを転送に変更した場合、サイトに係るすべてのファイルとディレクトリはサーバから削除されます。サイトについてローカル環境にコピーしておくことをお勧めします。",
    '__current_hosting_type' => "現在のホスティングタイプ",
    '__new_hosting_type' => "新しいホスティングタイプ",
    '__fwd_settings' => "転送設定",
    '__fwd_settings_legend' => "転送設定",
    '__fwd_destination_url' => "転送先 URL",
    '__fwd_type' => "転送タイプ",
    '__fwd_type_standart' => "標準転送",
    '__fwd_type_standart_hint' => "ウェブサイトの訪問者を他のサイトへリダイレクトして転送先のアドレスを表示します。 そのため、訪問者は転送されていることを把握できます。",
    '__fwd_type_frame' => "フレーム転送",
    '__fwd_type_frame_hint' => "ウェブサイトの訪問者を他のサイトへリダイレクトしますが、転送先のアドレスは表示しません。 そのため、訪問者は転送されていることを把握できまません。",
    '__hosting_type_template_warning' => "選択したホスティングタイプが、テンプレートで指定しているタイプと異なります。 続行すると、選択したテンプレートのウェブホスティング設定は無視されます。 選択したホスティングタイプを設定しますか？",

    '__no_resellers_selected' => "少なくともひとつのリセラーアカウントを選択する必要があります。",

    'ui__client/logo_unknown__wizard-title' => 'ロゴをセットアップする',
    'ui__client/logo_unknown__wizard__1_unknown' => 'ロゴプロパティを変更する顧客を選択してください。',
    'ui__client/logo_unknown__wizard__2' => '［終了］をクリックして、変更を適用します。',
    'ui__client/logo_unknown__wizard__2_self' => '［終了］をクリックして、変更を適用します。',

    'ui__client/ipaddress/properties_new__short-title' => "IP アドレスを追加",
    'ui__client/ipaddress/properties_new__title' => 'IP アドレスを追加',
    'ui__client/ipaddress/properties_new__description' => "IP アドレスを追加します。",
    'ui__client/ipaddress/properties_unknown-new__short-title' => "IP アドレスを追加",
    'ui__client/ipaddress/properties_unknown-new__title' => "IP アドレスを追加",
    'ui__client/ipaddress/properties_unknown-new__description' => "IP アドレスを追加",
    'ui__client/ipaddress/delete_multi__short-title' => "IP アドレスの削除",
    'ui__client/ipaddress/delete_multi__description' => "IP アドレスを削除します。",
    'ippool_Manager__no_available_ips' => "IP プール内に空き IP アドレスがありません。",
    'ippool_Manager__ip_shared' => "共用",
    'ippool_Manager__ip_exclusive' => "専用",
    'ui__client/ipaddress/properties__title' => "IP アドレスを管理",
    'ui__client/ipaddress/properties__description' => "IP アドレスプロパティの表示または変更",
    'ui__client/ipaddress_unknown-new__title' => "IP アドレスを追加",
    'ui__client/ipaddress_unknown-new__short-title' => "IP アドレスを追加",
    'ui__client/ipaddress_unknown-new__description' => "IP アドレスを追加します。",

    'ui__mass-mail#to_resellers_text__title' => "リセラー",
    'ui__mass-mail#to_domainusers_text__title' => "ドメイン管理者",
    'ui__mass-email#tools_legend__title' => "ツール",
    'ui__mass-email#list_legend__title' => '一括メールメッセージテンプレート',
    'ui__mass-email#template_legend__title' => "テンプレート",
    'ui__mass-email#from_email_text__title' => "From",
    'ui__mass-email#to_text__title' => '宛先',
    'ui__mass-email#to_resellers_text__title' => "リセラー",
    'ui__mass-email#to_clients_text__title' => "顧客",
    'ui__mass-email#to_domainusers_text__title' => "ドメイン管理者",
    'ui__mass-email#to_admin_text__title' => "Plesk 管理者",
    'ui__mass-email#option_mode_all__title' => "すべて",
    'ui__mass-email#option_mode_select__title' => "選択のみ",
    'ui__mass-email#option_mode_except__title' => "選択以外すべて",
    'ui__mass-email#option_select_template__title' => '--- テンプレート選択---',
    'ui__mass-email#subject_text__title' => "件名",
    'ui__mass-email#body_text__title' => "メッセージテキスト",
    'ui__mass-email#save_as_legend__title' => "テンプレートとして保存する",
    'ui__mass-email#save_as_text__title' => "作成したメッセージを新しいテンプレートに保存",
    'ui__reseller/preferences_unknown__wizard-title' => "アカウント設定を変更する",
    'ui__reseller/preferences_unknown__wizard__1_unknown' => "アカウント設定を変更するリセラーを選択し、［次へ］をクリックします。",
    'ui__reseller/preferences_unknown__wizard__2' => "アカウント設定を入力し、［OK］をクリックします。",
    'ippoolManager__ip_shared' => "共用",
    'ippoolManager__ip_exclusive' => "専用",

    '__users_list' => "ユーザ",
    '__users' => "ユーザ",
    '__user_name' => "ユーザ名",

    'limit__name_max_dom_aliases' => "ドメインエイリアス",
    'limit__name_max_subftp_users' => "追加 FTP アカウント",
    'limit__name_max_mssql_db' => "Microsoft SQL サーバデータベース",
    'limit__name_max_iis_app_pools' => "IIS アプリケーションプール",
    'limit__name_max_odbc' => "ODBC 接続",
    'total_mboxes_quota_unsupported' => 'メールサーバが未対応',
    'limit_soft__disk_space' => 'ディスクスペースの上限に達した場合に通知する',
    'limit_soft__max_traffic' => 'トラフィックの上限に達した場合に通知する',
    'dsr__of_reseller_title' => "ドメインごとのリソース利用状況",
    'limitsManager__commit_failed' => "リソース制限を保存できません",
    'limitsManager__date_in_past' => "無効な有効期限 %1",
    'limitsManager__limit_not_supported' => "リソースタイプ  %1 の制限を設定できません",
    'limitsManager__limit_oversell_inconsistency' => "販売超過が無効の状態で、指定されたリソース量を割り当てることができません",
    'limitsManager__limit_overuse_inconsistency' => "リソース使用量が指定された制限値を超過しています。",
    'limitsManager__no_resource_available' => "このタイプのリソース（%%limitName%%）はもう残りがありません。要求数：%%quantity%%、残り：%%unused%%",
    'limitsManager__no_total_resource_available' => "サービスプロバイダからこのタイプのリソースを使用できません（%%limitName%%）。 要求量：%%quantity%%、空き：%%unused%%",
    'limitsManager__invalid_expiration_limit' => "有効期限は %1 以前である必要があります。",
    'limitsManager__invalid_disk_space_limit' => "ディスクスペースは %1 以下である必要があります。",
    'limitsManager__invalid_max_traffic_limit' => "トラフィック量は %1 以下である必要があります。",
    'ippoolManager__ip_has_suballocations' => "既にユーザに割り当てられている IP アドレスタイプを変更できません。IP アドレス %%ip%% が %%reserved%% IP アドレスとして既に割り当てられています。",
    'ippoolManager__ip_is_already_in_pool' => "この IP アドレスは既にユーザに割り当てられています。",
    'ippoolManager__ip_is_not_in_pool' => "プールに IP アドレス %%ip%% がありません",
    'ippoolManager__can_not_allocate_ip' => "IP アドレス %%ip%% は %%available%% としてのみ利用可能です",
    'ippoolManager__unable_to_set_default_type' => "IP アドレス %%ip%% を専用に割り当てることはできません。",
    'ippoolManager__ip_used_by_hst_or_frw' => "IP アドレス %%ip%% は既にホスティングに使用されています。",
    'ippoolManager__active_anon_ftp_on_ip' => "匿名 FTP アクセスは IP アドレス %%ip%% に既にスイッチされました",
    'ippoolManager__no_vacant_ips' => "空き IP アドレスがありません",
    'ippoolManager__no_available_ips' => "利用可能な IP アドレスがありません",
    'templates__dublicate_name' => "この名前のテンプレートは既に存在します。このテンプレートに、別の名前を選択してください。",
    'cl_perm__client_limits_exceeded' => "指定されたリソース制限値は、ホスティングプランで許可される値より大きいか、サイトで現在使用されているリソース量より低くなっています。",
    'cl_perm__reseller_limits_exceeded' => "指定されたリソース制限値は、ホスティングプランで許可される値より大きいか、ユーザアカウントおよびサイトで現在使用されているリソース量より低くなっています。",

    'site_apps__preferences_show_all_versions_title' => "カタログより取得したアプリケーションのバージョン一覧を表示する",
    'site_apps__preferences_show_all_versions_hint' => "このオプションが選択された場合、カタログを開く度にアプリケーションごとのすべてのバージョンを取得するため一定時間を必要とします。このオプションが選択されない場合、最新バージョンが表示されます。",
    '__select_user_template' => "テンプレートに基づきユーザアカウントを作成する",
    'ip_already_added_to_all_clients' => "この IP アドレスは既にすべてのユーザに割り当てられています。",
    'ui__server/ip-address/client/delete#legend__description' => "以下の IP アドレスがシステムおよびユーザの IP アドレスから削除されます。",

    'site_apps__cancelled_apps' => "以下のアプリケーション追加をキャンセルしました。%2",

    'sb_url_is_not_resolved' => 'URL を解決できません。DNS 設定を確認してください。URL %1 は、Presence Builder がインストールされたサーバの IP アドレスに解決される必要があります。',

    'ip_addr__is_last_on_interface' => 'IP アドレスがネットワークインターフェース上に存在するため、IP アドレス %%ip%% を削除できません。',
    'ip_addr__used_for_current_session' => 'IP アドレス %%ip%% を削除できません。アクティブセッションで使用されています。',
    'ip_addr__used_for_hosting' => 'IP アドレス %%ip%% はウェブサイトホスティングに使用されているため削除できません',
    'ip_addr__is_main' => 'ネットワークインターフェースのプライマリ IP アドレスであるため、IP アドレス %%ip%% を削除できません。',
    'ip_addr__ip_used_by_message_submission' => 'メールメッセージのサブミッション用に用いられているため、IP アドレス %%ip%% を削除できません',

    // RESELLER ACTION LOG

    '__cl_domains' => '顧客のドメイン',
    'excl_ip_num' => '専用 IP アドレス',

    'sb_err_sitebuilder_not_installed' => 'Presence Builder が未インストールです。',

    '__perm_allow_oversell_can_not_be_revoked' => '販売超過を許可するパーミッションをユーザから取り消すことはできません。既にこのユーザには使用可能なリソースより多くのリソースが割り当てられています。販売超過モードへと移行します。',
    'limitsManager__invalid_limit_value' => '制限 %%limit_name%% に指定された無効な値 %%value%%',
    'confirmationForm_default_agreement_text' => '操作を完了させる',
    'confirmationForm_default_confirm_message' => 'オペレーションを確認してください',
    'limit__max_mn' => 'メールアカウント数の上限',

    'limits__client_overuse_description' => '利用超過ポリシーは、リソース使用量がリソースの初期割当を超過した場合に Plesk がどのように処理すべきかを定義します。',
    'limits__client_overuse_block_true_description' => 'リソースの利用超過をブロックしません。実際のリソース使用量は、設定時のリソース割り当てを超過できません',
    'limits__client_overuse_block_false_description' => 'リソースの利用超過をブロックせず、最初に設定した以上のリソースを利用することを許可します。 実際のリソース使用量は、最初のリソース割り当て量を超過することが可能です。',
    'limits__client_overuse_notify_text' => 'リソースが上限値に達することを顧客に通知します。',

    'limits__domain_overuse_description' => '利用超過ポリシーは、リソース使用量がリソースの初期割当を超過した場合に Plesk がどのように処理すべきかを定義します。',
    'limits__domain_overuse_block_true_description' => 'Plesk は利用超過ポリシーにより、リソースの利用超過が発生したときにどのように処理するかを判断します。',
    'limits__domain_overuse_block_false_description' => 'リソースの利用超過をブロックせず、設定時の割り当て以上のリソースを利用することを許可します。設定時のリソース量を超過するリソースを利用できます。',
    'limits__domain_overuse_notify_text' => 'リソース制限値に達したドメイン所有者に通知します。',


    'cancel_remove' => 'すべての変更を破棄して、前のページに戻ります。',
    'php_not_installed' => 'PHP がインストールされていません',

    'dns__dns_rr_delete' => '削除されるアイテム',
    'dns__delete_rr' => '以下の DNS レコードが DNS ゾーンから削除されます。',
    'dns__dns_rr_delete_non_removable' => 'アイテムを削除できません',
    'dns__non_delete_rr' => '以下の DNS ゾーンを削除できません。',
    'dns__dns_rr_delete_confirm_message' => 'DNS レコード削除の確認',

    'site_apps__format_is_unsupported_broadcast_not_set' => '不明なウェブアプリケーションフォーマットです。ウェブアプリケーションをインストールおよび利用することはできません',

    '__php_handler_type_desc' => 'PHP の実行タイプ',
    'sfdk_domain_sign__failed' => 'ドメインで DKIM によるメールの署名を有効にしようとした時に、未知のエラーが発生しました。詳細はサーバのエラーログを参照してください。',

    // key management ported from cpp to php
    'pkey_notify__subj_update_success_notification' => 'Plesk キーアップデート成功通知',
    'pkey_notify__subj_update_deferral_notification' => 'Plesk キーアップデート遅延通知',
    'pkey_notify__subj_update_error_notification' => 'Plesk キーアップデートエラー通知',
    'pkey_notify__update_successful' => '%1 のアップデートが正常に完了しました',
    'pkey_notify__update_failed_no_more_try' => '%1 に更新できません。送信しようとしているキーは無効です。このキーの更新はしないでください。',
    'pkey_notify__update_failed_try_later' => '%1 を更新できません。キーの処理でエラーが発生しました。Plesk でキーを手動で取得するか（［ツールと設定］>［ライセンス情報］）、24 時間以内に Plesk にキーを更新させることができます。今後、この通知を受信したくない場合、Plesk からこのキーを削除してください。',

    // spam assassin error messages
    'ui__server/spam-filter/toggle__unable_disable' => 'サーバ全体のスパムフィルタをオフにできません。',
    'ui__server/spam-filter/toggle__unable_enable' => 'サーバ全体のスパムフィルタをオンにできません',

    // Application vault/ application pool for admin mapping - TEMPORARY

    // report
    'report_auto__recipient_reseller' => 'このリセラー',
    'report_auto__select_reseller_report_all' => 'すべてのリセラー',
    'report_auto__select_reseller_report_client' => 'この顧客の全リセラー',
    'report_auto__select_reseller_report_current' => 'このリセラー',
    'report_auto__select_reseller_report_reseller' => '%1',
    'report_auto__select_client_report_reseller' => 'このリセラーの全顧客',
    'report_auto__select_client_report_client' => 'この顧客',
    'report_auto__select_client_report_other_reseller' => '%1',
    'report_auto__select_admin_report_all' => 'リセラー、顧客、およびドメイン',

    'rpt_reseller_section_full_domains' => 'ドメイン',
    'rpt_reseller_dom_subdomains' => 'サブドメイン',
    'rpt_reseller_dom_domain_aliases' => 'ドメインエイリアス',
    'rpt_reseller_dom_postboxes' => 'メールボックス',
    'rpt_reseller_dom_redirects' => 'フォワーダ',
    'rpt_reseller_dom_mail_groups' => 'メールグループ',
    'rpt_reseller_dom_mail_resps' => '自動応答',
    'rpt_reseller_dom_mail_antispam' => 'アンチスパム',
    'rpt_reseller_dom_mail_antivirus' => 'アンチウイルス',
    'rpt_reseller_dom_mail_lists' => 'メーリングリスト',
    'rpt_reseller_dom_web_users' => 'ウェブユーザ',
    'rpt_reseller_dom_data_bases' => 'DBMySQL',
    'rpt_reseller_dom_mssql_data_bases' => 'DBMSSQL',

    'rpt_reseller_section_full_clients' => '顧客',
    '__cl_name' => '顧客名',
    '__cl_creation_date' => '作成日',
    '__clients_traffic' => '顧客のトラフィック',
    'rpt_reseller_cl_mail_antispam' => 'アンチスパム',
    'rpt_reseller_cl_mail_antivirus' => 'アンチウイルス',

    // CONHELPS FOR HOME PAGE
    // common:
    'sitebuilder_not_installed' => 'Presence Builder が未インストールです。',
    'sitebuilder_disabled' => 'Presence Builder はオフになっています。',
    'b_sitebuilder_disabled' => 'Presence Builder はオフになっています。',
    'webmail_not_installed' => 'ウェブメールのソフトウェアがインストールされていません',
    'webmail_disabled' => 'ウェブメールサービスはオフになっています。',
    'spamassassin_not_installed' => 'SpamAssassin がインストールされていません',
    // pfu:
    'anonymous_ftp_shared' => '匿名 FTP を設定できません。共有 IP アドレスタイプです。',
    'anonymous_ftp_used' => '匿名 FTP をセットアップできません。この IP アドレスは他のドメインで匿名 FTP サービス用に使用されています。',
    // pfw:
    'aspdotnet_not_installed' => 'ASP.NET がインストールされていません。',
    'site_builder_no_package' => 'Presence Builder を使用できません。Presence Builder がインストールされており、アクティブコンポーネントとして選択されていることを確認してください。',
    'site_builder_not_configured' => 'Presence Builder が未構成です。',

    // LIST OF CLIENTS
    // under reseller
    'ui__reseller/client#tools__title' => 'ツール',
    'ui__reseller/client#clientslist__title' => '顧客',

    //reseller accounts removal





    // NEW HOME PAGE WIZARDS

    // PFW-only

    'ui__client/domain/hosting/web-directories_unknown__wizard-title' => 'ウェブサイトの仮想ディレクトリを管理する',
    'ui__client/domain/hosting/web-directories_unknown__wizard__2_unknown' => "ディレクトリを管理するウェブサイトを選択します。",

    // COMMON WIZARDS


    'ui__client/domain/hosting/anonymous-ftp_unknown__wizard-title' => 'ドメインに匿名 FTP をセットアップする',
    'ui__client/domain/hosting/anonymous-ftp_unknown__wizard__2_unknown' => '匿名 FTP をセットアップするドメインを選択してください。',

    'ui__client/domain/hosting/protected-directories_unknown__wizard-title' => 'ドメイン上のパスワード保護されたディレクトリを管理する',
    'ui__client/domain/hosting/protected-directories_unknown__wizard__2_unknown' => 'パスワード保護されたディレクトリを管理したいドメインを選択してください。',

    'ui__client/domain/hosting/logs_unknown__wizard-title' => 'ドメインにログマネージャをセットアップし、ドメインログファイルを表示する',
    'ui__client/domain/hosting/logs_unknown__wizard__2_unknown' => 'ログマネージャをセットアップしてログファイルを参照したいドメインを選択してください。',

    'ui__client/domain/certificate_unknown__wizard-title' => 'ドメインの SSL/TLS 証明書を管理',
    'ui__client/domain/certificate_unknown__wizard__2_unknown' => 'SSL/TLS 証明書を管理したいドメインを選択してください。',

    'ui__client/domain/disable_multi__wizard-title' => 'ドメインを一時停止',
    'ui__client/domain/disable_multi__wizard__2_multi' => '一時停止するドメインを選択してください。',

    'ui__client/domain/enable_multi__wizard-title' => 'ドメインをアクティブ化',
    'ui__client/domain/enable_multi__wizard__2_multi' => 'アクティブ化するドメインを選択してください。',

    'ui__client/domain_unknown__wizard-title' => 'ドメインを表示',
    'ui__client/domain_unknown__wizard__1_unknown' => 'ドメインを表示する顧客を選択してください。',

    'ui__client/domain/register_unknown__wizard-title' => 'ドメインを登録',
    'ui__client/domain/register_unknown__wizard__2_unknown' => '登録したいドメインを選択してください。',

    'ui__client/domain/extras_unknown__wizard-title' => 'MyPlesk.com のツールを使用',
    'ui__client/domain/extras_unknown__wizard__2_unknown' => 'MyPlesk.com のツールで管理したいドメインを選択してください。',

    // various

    'ui__server/ip-address/client_unknown__short-title' => 'IP アドレスユーザ',
    'ui__server/ip-address/client_unknown__title' => 'IP アドレスユーザ',
    'ui__server/ip-address/client_unknown__description' => 'IP アドレス %1 のユーザ',

    'disabled_by_admin' => 'サーバ管理者により無効にされました',






    'ui__client/domain/chowner_multi__short-title' => '所有者を変更',
    'ui__client/domain/chowner_multi__title' => '契約の所有者を変更',
    'ui__client/domain/chowner_multi__description' => '契約の所有者を変更',

    'ui__client/domain/chowner_multi__wizard__2_multi' => '所有者を変更するドメインを選択して、［次へ >>］をクリックしてください。',
    'ui__client/domain/chowner_unknown__short-title' => '所有者を変更',
    'ui__client/domain/chowner_unknown__title' => '契約の所有者を変更',
    'ui__client/domain/chowner_unknown__description' => '契約の所有者を変更',

    'ui__client/domain/chowner_unknown__wizard-title' => '契約の所有者を変更',

    //custom buttons reseller home support
    //ui captions
    'ui__reseller/custom-buttons/custom-button__none-available' => 'カスタムボタンがありません',
    'ui__reseller/custom-buttons/custom-button__none-available__1' => 'リセラー %1 のインターフェースにカスタムボタンがありません。',

    'ui__reseller/custom-buttons/custom-button/delete__description' => 'ボタン %1 を削除します。',

    'ui__reseller/custom-buttons/custom-button/delete__short-title' => '削除',
    'ui__reseller/custom-buttons/custom-button/delete__title' => 'ボタン %1 を削除',
    'ui__reseller/custom-buttons/custom-button/delete_multi__description' => 'リセラーのインターフェースからカスタムボタンを削除',

    'ui__reseller/custom-buttons/custom-button/delete_multi__short-title' => '削除',
    'ui__reseller/custom-buttons/custom-button/delete_multi__title' => 'カスタムボタンを削除',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard-title' => 'ボタンを削除',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard__1_unknown' => 'カスタムボタンを削除したいリセラーを選択し、［次へ >>］をクリックしてください。',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard__3_multi' => '削除するボタンを選択して、［次へ >>］をクリックしてください。',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard__4_multi' => 'ボタンの削除を確認するには、当該画面でチェックボックスをオンにして、［終了］をクリックしてください。',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__description' => 'リセラーのインターフェースからカスタムボタンを削除します。',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__short-title' => '削除',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__title' => 'カスタムボタンを削除',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard-title' => 'カスタムボタンを削除',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard__1_unknown' => 'カスタムボタンを削除したいリセラーを選択し、［次へ >>］をクリックします。',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard__3_unknown' => '削除するカスタムボタンをクリックして、［次へ >>］をクリックしてください。',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard__4' => 'カスタムボタンの削除を確認するには、当該画面でチェックボックスをオンにして、［終了］をクリックしてください。',

    'ui__reseller/custom-buttons/custom-button/properties__description' => 'リセラーレベルのカスタムボタン %1 のプロパティを編集する',

    'ui__reseller/custom-buttons/custom-button/properties__short-title' => '設定',
    'ui__reseller/custom-buttons/custom-button/properties__title' => 'リセラーカスタムボタン %1 を編集',

    'ui__reseller/custom-buttons/custom-button/properties_new__wizard-title' => 'カスタムボタンを追加',
    'ui__reseller/custom-buttons/custom-button/properties_new__wizard__1_unknown' => 'インターフェースにカスタムボタンを作成するリセラーを選択し、［次へ>>］をクリックしてください。',
    'ui__reseller/custom-buttons/custom-button/properties_new__wizard__4_new' => '［終了］をクリックして、ボタンを作成してください。',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__description' => 'リセラーのインターフェースでボタンのプロパティを変更します。',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__short-title' => 'プロパティ',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__title' => 'リセラーのインターフェースでボタンのプロパティを変更します。',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard-title' => 'カスタムボタンプロパティを変更する',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard__1_unknown' => 'カスタムボタンを編集したいリセラーを選択し、［次へ >>］をクリックします。',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard__3_unknown' => '編集するカスタムボタンを選択して、［次へ>>］をクリックしてください。',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard__4' => 'ボタンプロパティの編集を完了後、［終了］をクリックして変更を適用した後で、ウィザードを終了してください。',

    'ui__reseller/custom-buttons/custom-button/toggle_private__description' => '顧客に対してボタン %1 を利用不可にします。',

    'ui__reseller/custom-buttons/custom-button/toggle_private__short-title' => '顧客に対して利用不可にする',
    'ui__reseller/custom-buttons/custom-button/toggle_private__title' => '顧客に対してボタン %1 を利用不可にする',
    'ui__reseller/custom-buttons/custom-button/toggle_public__description' => 'リセラーの顧客に対して、ボタン %1 を利用可能にします。',
    'ui__reseller/custom-buttons/custom-button/toggle_public__short-title' => '顧客に対して利用可能にする',
    'ui__reseller/custom-buttons/custom-button/toggle_public__title' => 'リセラーの顧客に対して、ボタン %1 を表示する',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__description' => '顧客に対してカスタムボタンを利用可能/利用不可にします。',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__short-title' => '顧客が利用可能/利用不可',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__title' => '顧客に対してカスタムボタンを利用可能/利用不可にする',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__wizard-title' => '顧客に対してカスタムボタンを利用可能/利用不可にします。',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__wizard__1_unknown' => '顧客のコントロールパネル上でカスタムボタンを表示したいリセラーを選択し、［次へ >>］をクリックします。',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__wizard__3_unknown' => '顧客に対して利用可能/利用不可にするカスタムボタンを選択して、［次へ >>］をクリックしてください。',

    '__not_allowed' => '許可しない',

    'ui__client/domain/chowner__wizard__3' => '',
    'ui__client/domain/chowner__wizard__3_select' => 'ドメインの新しい所有者を選択してください。',

    '__ip_addr_state_unknown' => "システムが要求された処理を実行しているため、IP アドレスは現在操作できません。しばらくお待ちください",


    'resellers_list__accounts' => 'ユーザ',

    'ip_addr__repair_is_not_allowed' => 'Virtuozzo 環境下の IP アドレスは修復できません',

    'ui__reseller/client__none-available__1' => 'リセラー %1 に顧客がありません',

    'ippoolManager__ip_used_by_nohost_domain' => "IP アドレス %%ip%% を削除できません。ホスティングのない 1 つ以上のドメインで使用されています。",
    'ippoolManager__ip_used_for_mail_service' => "IP アドレス %%ip%% を削除できません。1 つ以上のドメインにより、メールサービスの IP アドレスとして使用されています。",
    'ippoolManager__ip_used_for_send_emails' => "IP アドレス %%ip%% を削除できません。特定の IP からのメール送信に使用されています（［メールサーバ設定］を参照）。",
    'ippoolManager__ip_used_in_dns_zone' => 'ドメインの DNS ゾーン上で指定されているため、IP アドレス %%ip%% を削除できません',
    'ip_ctrl__cannot_manage_on_vz' => 'インストールされている Plesk は、Virtuozzo containers 環境で機能しています。新しい IP アドレスを追加できるのは、Virtuozzo containers ノードの管理者のみです。',

    'client_template__limits_auto_adjusted' => '顧客テンプレートで指定した上限が自動的に調整されました',

    '__entries' => 'エントリ',

    '__path_is_not_set' => 'パスが指定されていません。有効なパスを指定してください',

    'defaultcomponents__imap_required' => '（現在のメールサーバは IMAP をサポートしていません）',

    '__commercial_web_stats_not_installed' => 'Plesk は、サブドメインの統計計算用に商用のウェブ統計ソフトウェアのみをサポートしています。該当するソフトウェアがシステムにインストールされていません。',

    'mail__spamassassin_personal_settings_disallowed' => '個人用スパムフィルタ設定を適用する権限は、サーバ管理者によってオフになっています。以下に指定されているスパムフィルタ設定は適用されません。',

    'server_settings_invalid_traffic_statistics' => 'トラフィック統計保存のパラメータが無効です。',
    'server_settings_invalid_logrotate_period' => 'ログローテーション期間のパラメータが無効です。',
];