<?php
// Copyright 1999-2023. Plesk International GmbH. All rights reserved.
$messages = [
    'anonymous-ftp.description' => 'إذا كان الموقع الخاص بك تتم استضافته على عنوان IP مخصص (غير مشترك مع مستخدمين آخرين أو مواقع أخرى)، فيمكنك إعداد دليل داخل الموقع حيث يمكن للمستخدمين الآخرين تحميل الملفات أو تنزيلها باسم مجهول من خلال اتصال FTP. بمجرد تشغيل اتصال FTP باسم مجهول، سيتمكن المستخدمون من تسجيل الدخول إلى الدليل على عنوان مثل ftp://ftp.your-domain.com باستخدام اسم مستخدم مجهول وأي كلمة مرور.',
    'anonymous-ftp.displayLogin' => 'عرض رسالة تسجيل الدخول',
    'anonymous-ftp.loginText' => 'نص الرسالة',
    'anonymous-ftp.incomingDir' => 'السماح بالتحميل إلى دليل الوارد',
    'anonymous-ftp.incomingSubDir' => 'السماح بإنشاء دلائل في دليل الوارد',
    'anonymous-ftp.incomingReadable' => 'السماح بالتنزيل من دليل الوارد',
    'anonymous-ftp.quota' => 'تحديد مساحة القرص في دليل الوارد',
    'anonymous-ftp.maxConnections' => 'تحديد عدد الاتصالات المتزامنة',
    'anonymous-ftp.bandwidth' => 'تحديد النطاق الترددي للتنزيل بالنسبة إلى مجال FTP الظاهري',
    'anonymous-ftp.unlimited' => 'غير محدود',

    'aps.catalog.loading' => 'جارٍ التحميل...',
    'aps.catalog.searchName' => 'التطبيق',
    'aps.catalog.searchVendor' => 'البائع',
    'aps.catalog.searchPackager' => 'جهة الجمع',
    'aps.catalog.searchLicenseType' => 'نوع الترخيص',
    'aps.catalog.searchLicenseTypeAny' => 'أي',
    'aps.catalog.searchLicenseTypeFreeware' => 'مجاني',
    'aps.catalog.searchLicenseTypeCommercial' => 'تجاري',
    'aps.catalog.showSearch' => 'إظهار البحث',
    'aps.catalog.hideSearch' => 'إخفاء البحث',
    'aps.catalog.buttonSearch' => 'بحث',
    'aps.catalog.buttonResetSearch' => 'إعادة تعيين البحث',
    'aps.catalog.showCategories' => 'حدد فئة أدناه أو ابحث عن التطبيقات باستخدام مربع البحث',
    'aps.catalog.searchResults' => 'نتائج البحث',
    'aps.catalog.buttonInstall' => 'تثبيت',
    'aps.catalog.buttonInstallTooltip' => 'قم بتثبيت أحدث إصدار من التطبيق بسرعة باستخدام المعلمات الافتراضية المثالية.',
    'aps.catalog.buttonAdvancedInstall' => 'تثبيت (مخصص)',
    'aps.catalog.buttonAdvancedInstallTooltip' => 'تثبيت أحدث إصدار من التطبيق، وتخصيص جميع المعلمات.',
    'aps.catalog.buttonInstallOldVersion' => 'تثبيت الإصدار',
    'aps.catalog.buttonInstallOldVersionTooltip' => 'قم بتثبيت الإصدار المحدد من التطبيق، مع تخصيص جميع المعلمات.',
    'aps.catalog.buttonInstallDescription' => 'قم بتثبيت التطبيق على أحد المواقع إذا كان لديك رمز تنشيط بالفعل، أو إذا كنت تريد تجربته فقط.',
    'aps.catalog.buttonInstallDescriptionFree' => 'قم بتثبيت هذا التطبيق المجاني على أحد المواقع.',
    'aps.catalog.version' => 'الإصدار',
    'aps.catalog.moreVersions' => 'المزيد من الإصدارات',
    'aps.catalog.release' => 'إصدار',
    'aps.catalog.overview' => 'نظرة عامة',
    'aps.catalog.noApplicationsInCategory' => 'لا تتوفر تطبيقات في هذه الفئة. حدد فئة أخرى.',
    'aps.catalog.noCategoriesSelected' => 'حدد فئة لاستعراض جميع التطبيقات المتوفرة في هذه الفئة.',
    'aps.catalog.noSearchResults' => 'لا يطابق بحثك أيًا من التطبيقات.',
    'aps.catalog.connectionFailed' => 'فشل الاتصال بكتالوج التطبيق. %%retryLink%%.',
    'aps.catalog.retry' => 'إعادة المحاولة',
    'aps.catalog.categoriesError' => 'لا يمكن تحميل قائمة الفئات في الوقت الحالي.',
    'aps.catalog.applicationsError' => 'لا يمكن تحميل قائمة التطبيقات في الوقت الحالي.',
    'aps.catalog.detailsError' => 'لا يمكن تحميل تفاصيل التطبيق في الوقت الحالي.',
    'aps.catalog.searchError' => 'لا يمكن تحميل نتائج البحث في الوقت الحالي.',
    'aps.catalog.changelogEntry' => 'v%%version%% (Release %%release%%) - %%description%%',
    'aps.catalog.changelog' => 'سجل التغييرات',
    'aps.catalog.officialApplicationSite' => 'معلومات البائع',
    'aps.catalog.returnToCategories' => '<< الرجوع إلى قائمة التطبيقات',
    'aps.catalog.buttonUninstall' => 'إزالة',
    'aps.catalog.gotoHome' => 'الصفحة الرئيسية',
    'aps.catalog.all' => 'الجميع',
    'aps.catalog.buttonDetails' => 'معرفة المزيد',
    'aps.catalog.buttonBuy' => 'شراء الآن',
    'aps.catalog.buttonBuyTooltip' => 'شراء التطبيق',
    'aps.catalog.buttonBuyDescription' => 'قم بزيارة متجرنا لشراء رمز تنشيط للتطبيق.',
    'aps.catalog.buttonDownload' => 'تنزيل',
    'aps.catalog.buttonDownloadDescription' => 'قم بتنزيل التطبيق إذا كان لديك رمز تنشيط بالفعل، أو كنت تريد تجربته فقط.',
    'aps.catalog.marketplaceMoreInfo' => 'للحصول على المزيد من المعلومات، قم بزيارة %%link%%.',
    'aps.catalog.marketplaceMoreInfoLink' => 'موقع بائع التطبيق على الويب',

    'aps.configure.installedAt' => "مثبت في",
    'aps.configure.otherSettings' => "أخرى",
    'aps.configure.globalSettings' => 'إعدادات الحزمة',
    'aps.configure.passwordConfirmation' => 'تأكيد كلمة المرور',
    'aps.configure.databaseParams' => 'معلمات قاعدة البيانات',
    'aps.configure.noInstallationUrlAvailable' => 'بلا (تطبيق خارجي)',
    'aps.configure.updateSettingsSection' => 'تحديث الإعدادات',
    'aps.configure.forceUpdates' => 'تحديث هذا التطبيق تلقائيًا عند توفر تحديثات',
    'aps.configure.forceUpdatesHint' => 'سيتلقى هذا التطبيق تحديثات تلقائية إلى إصدارات أحدث. تحذير: استخدم هذا الخيار بعناية لأن التحديثات قد تؤثر بدرجة كبيرة على وظيفة التطبيق. على سبيل المثال، قد تؤدي امتدادات التطبيق إلى إيقاف العمل باستخدام إصدار آخر من التطبيق.',

    'aps.install.showAllSettings' => 'عرض جميع الإعدادات',
    'aps.install.showLessSettings' => 'عرض الحد الأدني من الإعدادات',
    'aps.install.install' => 'تثبيت',
    'aps.install.otherSettings' => 'إعدادات أخرى',
    'aps.install.globalSettings' => 'إعدادات الحزمة',
    'aps.install.passwordConfirmation' => 'تأكيد كلمة المرور',
    'aps.install.provisionsSectionLabel' => 'مسار التثبيت',
    'aps.install.context' => 'حدد الموقع حيث يجب تثبيت تطبيق الويب هذا.',
    'aps.install.registerAsWebmailSection' => 'تسجيل بريد الويب',
    'aps.install.registerAsWebmailDescription' => "حدد هذا الخيار إذا كان التطبيق هو عميل بريد الويب. وهذا قد يجعل التطبيق يظهر بين خدمات بريد الويب المتوفرة في إعدادات البريد الخاصة بالاشتراكات وخطط الخدمة. يمكن أن يقوم المسؤول بتكوين عنوان URL للوصول العام الخاص ببريد الويب في Server Management (إعدادات الخادم)> Settings (الإعدادات)/> Webmail (بريد الويب).",
    'aps.install.registerAsWebmailLabel' => 'التسجيل كخدمة لبريد الويب',
    'aps.install.addItem' => 'إضافة',
    'aps.install.removeItem' => 'إزالة',
    'aps.install.updateSettingsSection' => 'تحديث الإعدادات',
    'aps.install.forceUpdates' => 'تحديث هذا التطبيق تلقائيًا عند توفر تحديثات',
    'aps.install.forceUpdatesHint' => 'سيتلقى هذا التطبيق تحديثات تلقائية إلى إصدارات أحدث. تحذير: استخدم هذا الخيار بعناية لأن التحديثات قد تؤثر بدرجة كبيرة على وظيفة التطبيق. على سبيل المثال، قد تؤدي امتدادات التطبيق إلى إيقاف العمل باستخدام إصدار آخر من التطبيق.',

    'aps.invalid-requirements.requirementsLegend' => 'المتطلبات',
    'aps.invalid-requirements.domainLegend' => 'موقع ويب',
    'aps.invalid-requirements.context' => 'اختيار موقع ويب آخر',
    'aps.invalid-requirements.backToApplicationList' => 'الرجوع إلى قائمة التطبيقات',

    'aps.license.title' => 'تثبيت %%packageName%%',
    'aps.license.doYouAcceptLicense' => 'لتثبيت هذا التطبيق، يجب قراءة اتفاقية الترخيص للمستخدم النهائي والموافقة على بنودها.',
    'aps.license.licenseAgree' => 'أوافق على بنود اتفاقية الترخيص',

    'aps.services-list-customization.settings' => 'الإعدادات',

    'asp-dot-net.change-version.frameworkVersion' => 'إصدار ASP.NET framework',

    'asp-dot-net.settings.casSettingsSection' => "أمان الوصول إلى الرمز",
    'asp-dot-net.settings.clientScriptsSection' => "إعدادات مكتبة البرنامج النصي",
    'asp-dot-net.settings.connStringsSection' => "مدير سلسلة الاتصال",
    'asp-dot-net.settings.customErrorsSection' => "إعدادات الخطأ المخصص",
    'asp-dot-net.settings.frameworkVersionSection' => "إصدار Framework",
    'asp-dot-net.settings.globalizationSection' => "إعدادات التعميم",
    'asp-dot-net.settings.otherSection' => "إعدادات الجلسة",
    'asp-dot-net.settings.pageAndRuntimeSection' => "التجميع وتصحيح الأخطاء",
    'asp-dot-net.settings.authMode' => "وضع المصادقة",
    'asp-dot-net.settings.connStrings' => "سلاسل الاتصال",
    'asp-dot-net.settings.connStringsInvalid' => "بعض الحقول فارغة أو تحتوي على قيم غير مناسبة.",
    'asp-dot-net.settings.connStringName' => "الاسم",
    'asp-dot-net.settings.connStringValue' => "معلمات الاتصال",
    'asp-dot-net.settings.connStringsDescription' => "الاسم / معلمات الاتصال",
    'asp-dot-net.settings.culture' => "الثقافة",
    'asp-dot-net.settings.customErrMode' => "وضع الخطأ المخصص",
    'asp-dot-net.settings.customErrorRedirect' => "إعادة توجيه عنوان URL",
    'asp-dot-net.settings.customErrorStatus' => "رمز الحالة",
    'asp-dot-net.settings.customErrorStatusInvalid' => "يجب أن يكون رمز الحالة رقمًا صحيحًا.",
    'asp-dot-net.settings.customErrors' => "أخطاء مخصصة",
    'asp-dot-net.settings.customErrorsDescription' => "رمز الحالة / عنوان URL لإعادة التوجيه",
    'asp-dot-net.settings.customErrorsInvalid' => "بعض الحقول فارغة أو تحتوي على قيم غير مناسبة.",
    'asp-dot-net.settings.debugMode' => "تشغيل تصحيح الأخطاء",
    'asp-dot-net.settings.defLanguage' => "لغة صفحة الويب الافتراضية",
    'asp-dot-net.settings.tempDirectory' => "دليل مؤقت",
    'asp-dot-net.settings.fileEnc' => "ترميز الملف",
    'asp-dot-net.settings.fileEncInvalid' => "إن القيمة المحددة لمعلمة ترميز الملف غير صالحة.",
    'asp-dot-net.settings.pathToLib' => "مسار إلى مكتبة البرنامج النصي من Microsoft",
    'asp-dot-net.settings.pathToLibInstall' => "تثبيت",
    'asp-dot-net.settings.reqEnc' => "ترميز الطلب",
    'asp-dot-net.settings.reqEncInvalid' => "إن القيمة المحددة لمعلمة ترميز الطلب غير صالحة.",
    'asp-dot-net.settings.resEnc' => "ترميز الرد",
    'asp-dot-net.settings.resEncInvalid' => "إن القيمة المحددة لمعلمة ترميز الرد غير صالحة.",
    'asp-dot-net.settings.sessTimeout' => "مهلة جلسة العمل (دقائق)",
    'asp-dot-net.settings.sessTimeoutInvalid' => "إن القيمة المحددة لمعلمة مهلة جلسة العمل غير صالحة. أدخل عددًا صحيحًا موجبًا أقل من أو يساوي %%max%%.",
    'asp-dot-net.settings.connStringDuplicate' => "اسم سلسلة الاتصال قيد الاستخدام بالفعل.",
    'asp-dot-net.settings.customErrorInvalidCode' => "The status code has to be between 100 and 999",
    'asp-dot-net.settings.customErrorDuplicate' => "رمز الحالة قيد الاستخدام بالفعل.",
    'asp-dot-net.settings.trustLevel' => "مستوى ثقة CAS",
    'asp-dot-net.settings.uiCulture' => "ثقافة واجهة المستخدم",
    'asp-dot-net.settings.version' => "الإصدار",
    'asp-dot-net.settings.trustLevelAllowOverride' => 'السماح بتجاوز مستوى ثقة CAS على موقع الويب',
    'asp-dot-net.settings.addConnStrings' => 'إضافة سلسلة اتصال',
    'asp-dot-net.settings.addCustomErrors' => 'حدث خطأ عند إضافة عميل',
    'asp-dot-net.settings.buttonRemove' => 'إزالة',
    'asp-dot-net.settings.updateSuccess' => 'نجح التحديث',

    'database.clone.formDescription' => 'قم بنسخ محتويات قاعدة البيانات إلى قاعدة بيانات جديدة أو أخرى موجودة. عند النسخ إلى قاعدة بيانات موجودة، تتم إضافة جداول قاعدة بيانات المصدر إلى قائمة الجداول في قاعدة بيانات الوجهة. تحذير: في حالة تطابق أسماء الجداول، فسيحل الجدول من المصدر مكان الجدول في الوجهة.',
    'database.clone.copyData' => 'إنشاء نسخة كاملة',
    'database.clone.copyDataHint' => 'عند تحديد هذا الاختيار، سيتم نسخ قاعدة البيانات بأكملها (بما في ذلك البنية والبيانات). إذا تم إلغاء نسخ هذا الاختيار، فسيتم نسخ بنية الجداول فقط.',
    'database.clone.server' => 'خادم قاعدة بيانات الوجهة',
    'database.clone.versionCut' => 'v%%version%%',
    'database.clone.externalServer' => 'أخرى...',
    'database.clone.database' => 'قاعدة بيانات الوجهة',
    'database.clone.newDatabase' => 'إنشاء قاعدة بيانات بالاسم',
    'database.clone.existingDatabase' => 'نسخ إلى قاعدة البيانات الموجودة',
    'database.clone.externalDbHost' => 'اسم المضيف أو عنوان IP',
    'database.clone.externalDbLogin' => 'اسم المستخدم',
    'database.clone.externalDbPassword' => 'كلمة المرور',
    'database.clone.subscription' => 'اشتراك الوجهة',
    'database.clone.subscription_powerUser' => 'مساحة ويب الوجهة',
    'database.clone.cloneInProgress' => 'نسخ قاعدة البيانات %%source%% إلى قاعدة البيانات %%destination%%. سيتم إعلامك بالتقدم عن طريق البريد الإلكتروني (%%email%%).',
    'database.clone.unableToClone' => 'يتعذر نسخ قاعدة البيانات "%%source%%".',
    'database.clone.unableToCreateExternalDatabase' => 'يتعذر إنشاء قاعدة بيانات "%%destination%%" على الخادم المحدد.',
    'database.clone.databaseCloned' => 'تم نسخ قاعدة البيانات "%%source%%".',
    'database.clone.emailSubjSuccess' => 'تم نسخ قاعدة البيانات "%%sourceDatabase%%".',
    'database.clone.emailSubjFailure' => 'فشل نسخ قاعدة البيانات "%%sourceDatabase%%".',
    'database.clone.emailBodySuccess' => 'تم نسخ قاعدة البيانات (%%sourceDatabase%%" (%%sourceHost%%" إلى قاعدة البيانات (%%destDatabase%%" (%%destHost%%".',
    'database.clone.emailBodyFailure' => 'يتعذر نسخ قاعدة البيانات (%%sourceDatabase%%" (%%sourceHost%%" إلى قاعدة البيانات (%%destDatabase%%" (%%destHost%%". فشل إجراء النسخ.',
    'database.clone.localServer' => 'الخادم المحلي',

    'database.repair-orphaned.formDescription' => 'تم عزل هذا المستخدم بعد عملية الاستعادة. يُرجى توفير كلمة مرور لهذا المستخدم لحل هذه المشكلة. إذا كان يُفترض لهذا المستخدم أن يكون مستخدمًا للنظام دون كلمة مرور، فقم بتشغيل أداة الإصلاح مع ترك حقل كلمة المرور فارغًا.',
    'database.repair-orphaned.login' => 'اسم مستخدم قاعدة البيانات',
    'database.repair-orphaned.pass' => 'كلمة المرور',
    'database.repair-orphaned.pass2' => 'تأكيد كلمة المرور',
    'database.repair-orphaned.users' => 'يحتاج بعض المستخدمين إلى الاهتمام. يوجد العديد من المستخدمين المعزولين الذين يجب إصلاح حالتهم من أجل العمل بشكل سليم.',
    'database.repair-orphaned.orphaned' => 'المستخدم معزول. %%gui begin:link%%إصلاح الآن%%gui end:link%%.',
    'database.repair-orphaned.repair' => 'إصلاح',

    'database.repair.fixSelected' => 'الإصلاح المحدد',
    'database.repair.fix' => 'إصلاح',

    'database.user.password' => 'كلمة المرور',
    'database.user.passwordConfirmation' => 'تأكيد كلمة المرور',
    'database.user.server' => 'خادم قاعدة البيانات',
    'database.user.versionCut' => 'v%%version%%',
    'database.user.database' => 'قاعدة بيانات',
    'database.user.anyDatabase' => 'أي',
    'database.user.dataAccess' => 'الوصول إلى البيانات',
    'database.user.structureAccess' => 'الوصول إلى البنية',
    'database.user.globalAccess' => 'امتيازات عامة',
    'database.user.globalAccessHint' => 'تعمل الامتيازات العامة مع جميع قواعد البيانات ضمن الحساب المضيف هذا.',
    'database.user.aclRadio' => 'التحكم في الوصول',
    'database.user.aclLocalhost' => 'السماح بالاتصالات المحلية فقط',
    'database.user.aclAny' => 'السماح بالاتصالات البعيدة من أي مضيف',
    'database.user.aclCustom' => 'السماح بالاتصالات البعيدة من',
    'database.user.aclExample' => "thomas.loc.gov %.loc.gov x.y.% 144.155.166.177 144.155.166.% 144.155.166.0/255.255.255.0 يُسمح للمضيفين المحددين بالوصول إلى قاعدة البيانات نيابة عن هذا المستخدم.",
    'database.user.remoteAccess' => 'الوصول عن بُعد',
    'database.user.remoteAccessExample' => "10.1.0.0/16 192.168.1.110 يُسمح لعناوين IP المحددة بالوصول إلى قاعدة البيانات نيابة عن هذا المستخدم. سيتم التنظيم المسبق للتغييرات في هذه القائمة عن طريق موفر خدمة الاستضافة لديك.",
    'database.user.example' => "على سبيل المثال: %%example%%",
    'database.user.denied' => 'استخدام قواعد لجدار حماية النظام',
    'database.user.allowed' => 'السماح بالاتصالات البعيدة من',
    'database.user.default' => 'استخدم بيانات الاعتماد الخاصة بهذا المستخدم بشكل افتراضي عن طريق الوصول إلى %%webadmin%%',
    'database.user.remoteAccessHint' => 'يُرجى الاتصال بموفر خدمة الاستضافة والتأكد من توافق الاختيار الذي حددته أعلاه مع قواعد جدار الحماية الحالي من أجل الوصول الوارد إلى MySQL.',
    'database.user.phpMyAdmin' => 'phpMyAdmin',
    'database.user.myLittleAdmin' => 'myLittleAdmin',
    'database.user.webAdmin' => 'مسؤول الويب',
    'database.user.role' => 'الدور',
    'database.user.roleReadWrite' => 'القراءة والكتابة',
    'database.user.roleWriteOnly' => 'الكتابة فقط',
    'database.user.roleReadOnly' => 'القراءة فقط',
    'database.user.roleCustom' => 'مخصص',

    'database.generalSection' => 'عام',
    'database.name' => 'اسم قاعدة البيانات',
    'database.server' => 'خادم قاعدة البيانات',
    'database.versionCut' => 'v%%version%%',
    'database.relatedDomain' => 'موقع ذو صلة',
    'database.noDomainRelations' => 'لا توجد مواقع ذات صلة',
    'database.userSection' => 'المستخدمون',
    'database.userSectionDescription' => 'إنشاء مستخدم افتراضي لقاعدة البيانات. سيقوم تطبيق Plesk بالوصول إلى قاعدة البيانات نيابة عن هذا المستخدم. إذا لم يتم تعيين مستخدمي قاعدة بيانات إليها، فلن يمكن الوصول إليها.',
    'database.createUser' => 'إنشاء مستخدم لقاعدة البيانات',
    'database.username' => 'اسم مُستخدِم قاعدة البيانات',
    'database.password' => 'كلمة المرور',
    'database.passwordConfirmation' => 'تأكيد كلمة المرور',
    'database.allDbAccess' => 'يتمتع المستخدم بالوصول إلى جميع قواعد البيانات داخل الاشتراك المحدد',
    'database.aclRadio' => 'التحكم في الوصول',
    'database.aclLocalhost' => 'السماح بالاتصالات المحلية فقط',
    'database.aclAny' => 'السماح بالاتصالات البعيدة من أي مضيف',
    'database.aclCustom' => 'السماح بالاتصالات البعيدة من',
    'database.aclExample' => "thomas.loc.gov %.loc.gov x.y.% 144.155.166.177 144.155.166.% 144.155.166.0/255.255.255.0 يُسمح للمضيفين المحددين بالوصول إلى قاعدة البيانات نيابة عن هذا المستخدم.",
    'database.remoteAccess' => 'الوصول عن بُعد',
    'database.remoteAccessExample' => "10.1.0.0/16 192.168.1.110 يُسمح لعناوين IP المحددة بالوصول إلى قاعدة البيانات نيابة عن هذا المستخدم. سيتم التنظيم المسبق للتغييرات في هذه القائمة عن طريق موفر خدمة الاستضافة لديك.",
    'database.example' => "على سبيل المثال: %%example%%",
    'database.denied' => 'استخدام قواعد لجدار حماية النظام',
    'database.allowed' => 'السماح بالاتصالات البعيدة من',

    'deployment-section.deploymentDisabledHint' => 'تحميل ملفات من مستودع Git',
    'deployment-section.deploymentEnabledHint' => '‫تمكين دعم Git‬',
    'deployment-section.deploymentSectionLegend' => 'ملفاتك المخصصة للنسخ للاستضافة',
    'deployment-section.deploymentSectionDescriptionHint' => 'إذا أبقيت على دعم Git معطلاً، فسيتم إنشاء دلائل الجذر (جذر الموقع الإلكتروني/التطبيق وجذر الوثيقة) فارغة، وسيعرض الموقع الصفحة الافتراضية في المستعرض. ستحتاج إلى تحميل ملفات موقعك إلى جذر الوثيقة باستخدام FTP او مدير الملفات. بدلاً من ذلك، قم بتمكين Git الآن أو لاحقًا (في المواقع الإلكترونية والنطاقات) وقم بتحميل الملفات من مستودع Git.',

    'dns-zone.add-acl-record.description' => 'يُسمح بإضافة عنوان IP لخادم DNS للحصول على نسخة من منطقة DNS.',
    'dns-zone.add-acl-record.ipAddress' => 'عنوان IP',
    'dns-zone.add-acl-record.ipAddressWithMask' => 'عنوان/قناع IP',

    'dns-zone.record.add-title' => "إضافة سجل المورد إلى قالب المنطقة",
    'dns-zone.record.add-ns-title' => "إضافة خادم الاسم",
    'dns-zone.record.edit-title' => "تحرير سجل المورد",
    'dns-zone.record.edit-success' => "تم تحديث سجل DNS.",
    'dns-zone.record.add-success' => "تم إنشاء سجل DNS.",
    'dns-zone.record.type' => "نوع السجل",
    'dns-zone.record.domainName' => "اسم المجال",
    'dns-zone.record.domainNamePostfix' => ".<domain>",
    'dns-zone.record.nameServer' => "خادم اسم",
    'dns-zone.record.protocol' => "البروتوكول",
    'dns-zone.record.priority' => "الأولوية",
    'dns-zone.record.priorityLow' => "منخفضة (%%priority%%)",
    'dns-zone.record.priorityHigh' => "مرتفعة جدًا (%%priority%%)",
    'dns-zone.record.weightLow' => "منخفض (%%weight%%)",
    'dns-zone.record.weightHigh' => "مرتفع جدًا (%%weight%%)",
    'dns-zone.record.ipAddress' => "عنوان IP",
    'dns-zone.record.ipAddressDescription' => "مثال: 123.123.123.123",
    'dns-zone.record.ipAddressDescriptionExt' => "على سبيل المثال، <ip>، 123.123.123.123",
    'dns-zone.record.ipAddressV6' => "عنوان IPv6",
    'dns-zone.record.ipAddressV6Description' => "مثال: 2002:7b7b:7b7b::1",
    'dns-zone.record.ipAddressV6DescriptionExt' => "على سبيل المثال، <ipv6>، 2002:7b7b:7b7b::1",
    'dns-zone.record.ipAddressWithMaskDescription' => "مثال:2002:7b7b:7b7b::1/48، 123.123.123.123/16",
    'dns-zone.record.ipAddressWithMaskDescriptionExt' => "على سبيل المثال، <ipv6>، <ip>، 2002:7b7b:7b7b::1/48, 123.123.123.123/16",
    'dns-zone.record.masterIpAddressDescription' => "على سبيل المثال، 2002:7b7b:7b7b::1، و123.123.123.123",
    'dns-zone.record.canonicalName' => "الاسم المتعارف عليه",
    'dns-zone.record.mailDomain' => "مجال البريد",
    'dns-zone.record.mxServer' => "خادم تبادل البريد",
    'dns-zone.record.mxServerPriority' => "حدد أولوية خادم تبادل البريد",
    'dns-zone.record.txtRecord' => "سجل TXT",
    'dns-zone.record.txtRecordString' => "أدخل سلسلة سجل",
    'dns-zone.record.txtSpfSyntax' => "سجل SPF",
    'dns-zone.record.txtRecordDescription' => "",
    'dns-zone.record.invalidTxtRecord' => "تم تحديد قيم غير صحيحة لسجل TXT.",
    'dns-zone.record.dsRecord' => "سجل DS",
    'dns-zone.record.dsRecordDescription' => "على سبيل المثال، 60485 5 1 2BB183AF5F22588179A53B0A98631FAD1A292118",
    'dns-zone.record.invalidDsRecord' => "تم تحديد قيمة غير صحيحة لسجل DS.",
    'dns-zone.record.serviceName' => "اسم الخدمة",
    'dns-zone.record.serviceNameDescription' => "مثال: SIP (بدون رمز تسطير)",
    'dns-zone.record.protocolNameDescription' => "مثال: TCP (بدون رمز تسطير)",
    'dns-zone.record.srvWeight' => "أهمية السجلات النسبية بالأولوية ذاتها",
    'dns-zone.record.targetHost' => "المضيف الهدف",
    'dns-zone.record.targetHostDescription' => "مثال: example.com",
    'dns-zone.record.targetPort' => "المنفذ الهدف",
    'dns-zone.record.retrieveDataError' => "لم يتم العثور على بيانات السجل.",
    'dns-zone.record.unknownTypeError' => "نوع سجل DNS غير معروف",
    'dns-zone.record.nullMxRecordMustBeTheOnly' => 'يتعذر إعداد سجل NULL MX أثناء توافر سجلات MX أخرى.',
    'dns-zone.record.cannotHaveMxNullRecordAndMxRecord' => 'يتعذر إعداد سجل غير NULL MX أثناء توافر سجل NULL MX.',
    'dns-zone.record.masterShouldBeRemote' => "ينبغي أن يتوافر لديك خادمي أسماء موثوقين مختلفين على مضيفين منفصلين.",
    'dns-zone.record.caaTag' => "علامة",
    'dns-zone.record.caaRecord' => "القيمة",
    'dns-zone.record.caaRecordDescription' => "",
    'dns-zone.record.ttl' => "TTL",
    'dns-zone.record.ttl-seconds' => "ثوانٍ",
    'dns-zone.record.invalidValue' => 'القيمة غير صحيحة. يمكن أن تكون من 1 ثانية إلى 2147483647 ثانية.',
    'dns-zone.record.ttlDefaultValue' => 'القيمة الافتراضية: %%value%% ثانية',
    'dns-zone.record.invalidTTL' => 'قيمة TTL المحددة غير صالحة.',
    'dns-zone.record.invalidIpAddress' => 'عنوان IP المحدد غير صالح.',
    'dns-zone.record.invalidIpMaskPair' => 'عنوان IP المحدد / زوج قناع الشبكة غير صالح.',
    'dns-zone.record.invalidCName' => 'الاسم المتعارف عليه المحدد غير صالح.',
    'dns-zone.record.invalidSRVPort' => 'المنفذ المحدد غير صالح.',

    'dns-zone.restore-default.formHint' => "فيما يلي يمكنك استرداد تكوين المنطقة الأصلية بالتوافق مع إعدادات قالب DNS الافتراضي المستخدمة على الخادم. حدد عناوين IP المراد استخدامها لاستعادة المنطقة وحدد ما إذا كان الاسم المستعار www ضروريًا للمجال أم لا.",
    'dns-zone.restore-default.ipv4' => "عنوان IPv4",
    'dns-zone.restore-default.ipv4Hint' => "مثال: 123.123.123.123",
    'dns-zone.restore-default.ipv6' => "عنوان IPv6",
    'dns-zone.restore-default.ipv6Hint' => "مثال: 2002:7b7b:7b7b::1",
    'dns-zone.restore-default.invalidIpAddress' => 'عنوان IP المحدد غير صالح.',
    'dns-zone.restore-default.customIpHint' => "سيتم اعتبار السجلات التي تستخدم عنوان IP هذا كسجلات معدلة من قِبل المستخدم ولن تتزامن مع قالب DNS الخاص بالخادم.",
    'dns-zone.restore-default.wwwPrefix' => "البادئة www",
    'dns-zone.restore-default.previewRecords' => "استعادة السجلات المستخدمة من أجل معاينة الموقع",

    'dns-zone.soa-record.soaMnameSection' => 'خادم الاسم الرئيسي',
    'dns-zone.soa-record.soaMname' => 'خادم الاسم',
    'dns-zone.soa-record.soaMnameAutoselect' => '(التحديد التلقائي)',
    'dns-zone.soa-record.soaRecordSection' => 'سجل SOA',
    'dns-zone.soa-record.ttl' => 'TTL',
    'dns-zone.soa-record.refresh' => 'تحديث',
    'dns-zone.soa-record.retry' => 'إعادة المحاولة',
    'dns-zone.soa-record.expire' => 'انتهاء الصلاحية',
    'dns-zone.soa-record.minimum' => 'الحد الأدنى',
    'dns-zone.soa-record.rnameType' => 'البريد الإلكتروني (RNAME)',
    'dns-zone.soa-record.rnameTypeHint' => 'عنوان البريد الإلكتروني للشخص المسؤول عن منطقة DNS الخاصة بالنطاق. تمت إعادته بواسطة خادم DNS استجابة لاستعلامات SOA.',
    'dns-zone.soa-record.rnameTypeOwner' => 'عنوان البريد الإلكتروني لمالك موقع الويب',
    'dns-zone.soa-record.rnameTypeDomain' => 'عنوان البريد الإلكتروني للمجال',
    'dns-zone.soa-record.rnameTypeDomainHint' => 'لا تُدخل سوى الجزء المحلي (قبل @<domain>)',
    'dns-zone.soa-record.rnameTypeExternal' => 'عنوان البريد الإلكتروني الخارجي',
    'dns-zone.soa-record.rnameEnforceEmail' => 'منع تغيير عنوان البريد الإلكتروني RNAME على أساس كل نطاق',
    'dns-zone.soa-record.invalidValue' => 'القيمة غير صالحة. يمكن أن تتراوح بين ثانية واحدة و68 عامًا.',
    'dns-zone.soa-record.advancedSection' => '‫ميزات DNS المتقدمة‬',
    'dns-zone.soa-record.serialNumberFormat' => 'استخدم تنسيق الرقم التسلسلي الموصى به من قِبل IETF وRIPE',
    'dns-zone.soa-record.serialNumberFormatHint' => 'حدد الخيار إذا كان يوجد بنطاقك الخاص مشاكل في اجتياز فحص SOA للمسجّل. يتطلب العديد من مسجّلي النطاقات تنسيق الرقم التسلسلي هذا.',
    'dns-zone.soa-record.restoreDefaultButton' => 'استخدام الإعدادات الافتراضية',
    'dns-zone.soa-record.zoneDefaultsSection' => 'الإعدادات الافتراضية للمنطقة',
    'dns-zone.soa-record.unitSeconds' => 'ثوانٍ',
    'dns-zone.soa-record.unitMinutes' => 'دقائق',
    'dns-zone.soa-record.unitHours' => 'ساعات',
    'dns-zone.soa-record.unitDays' => 'أيام',
    'dns-zone.soa-record.unitWeeks' => 'أسابيع',
    'dns-zone.soa-record.refreshValueIsSmallWarning' => 'قيمة الفاصل الزمني للتحديث أقل من ساعة، مما قد يزيد بشكل كبير من استخدام الموارد وعدد زوار الخادم.',
    'dns-zone.soa-record.minimumValueIsBigWarning' => 'يمكن أن يجعل تعيين الحد الأدنى لقيمة TTL التي هي أكبر من 3 ساعات مجالاتك لا يمكن الوصول إليها لبعض مسؤولي المجال. ينصح بعدم تعيين هذه القيمة إلا إذا كان مسجل أسماء المجال يصر على ذلك.',
    'dns-zone.soa-record.success' => 'تم تحديث خصائص سجل SOA.',
    'dns-zone.soa-record.restoreDefaultSuccess' => 'تمت استعادة سجل SOA الافتراضي.',

    'domain-info-section.domainName' => 'اسم المجال',
    'domain-info-section.emptyDomainName' => 'يرجى إدخال اسم مجال.',
    'domain-info-section.ipAddress' => 'عنوان IP',
    'domain-info-section.shared' => 'مشترك',
    'domain-info-section.exclusive' => 'مخصص',
    'domain-info-section.ipAddressHint' => "عنوان IP الذي تتم استضافة مواقع الويب عليه هو عنوان شبكة للمضيف الظاهري لموقع الويب. سيتم استخدام عنوان IP هذا مع كل مواقع الويب التي تم إنشاؤها ضِمن الاشتراك.",
    'domain-info-section.ipAddressHint_powerUser' => "عنوان IP الذي تتم استضافة مواقع الويب عليه هو عنوان شبكة للمضيف الظاهري لموقع الويب. سيتم استخدام عنوان IP هذا مع كل مواقع الويب التي تم إنشاؤها ضِمن مساحة الويب.",
    'domain-info-section.userName' => 'اسم المستخدم',
    'domain-info-section.userNameHint' => 'حساب مستخدم النظام المرتبط بمساحة الويب والمستخدم للوصول إلى الملفات المُستضافة عبر FTP وSSH.',
    'domain-info-section.emptyLogin' => 'يُرجى إدخال اسم مستخدم.',
    'domain-info-section.password' => 'كلمة المرور',
    'domain-info-section.emptyPassword' => 'يُرجى إدخال كلمة مرور.',
    'domain-info-section.passwordConfirmation' => 'تكرار كلمة المرور',

    'email-address.generalTab' => 'عام',
    'email-address.generalHint' => '‫إذا كان عنوان البريد الإلكتروني هذا مرتبطًا بمستخدم إضافي (الوصول إلى لوحة العميل مُمكّن)، فإن التغييرات التي تقوم بها على هذه الصفحة تؤثر على إعدادات هذا المستخدم.‬ ‫وبشكل خاص، إذا قمت بتغيير عنوان البريد الإلكتروني وكلمة المرور، فسيتم تغيير بيانات تسجيل دخول المستخدم الإضافي وكلمة مروره إلى القيم الجديدة أيضًا.‬',
    'email-address.redirectTab' => 'إعادة التوجيه',
    'email-address.redirectHint' => 'إعداد إعادة توجيه رسائل البريد الإلكتروني إلى عنوان بريد إلكتروني واحد أو أكثر.',
    'email-address.aliasesTab' => 'الأسماء المستعارة للبريد الإلكتروني',
    'email-address.autoResponderTab' => 'الرد التلقائي',
    'email-address.antispamTab' => 'عامل تصفية البريد العشوائي',
    'email-address.autoResponderHint' => 'قم بإعداد رد تلقائي على أي رسالة بريد تصل إلى عنوان بريدك الإلكتروني. يُعد الرد التلقائي وسيلة قياسية لإعلام المستقبلين لديك بأنك خارج المكتب أو في عطلة.',
    'email-address.antivirusTab' => 'برنامج مكافحة الفيروسات',
    'email-address.name' => 'عنوان البريد الإلكتروني',
    'email-address.externalEmail' => 'عنوان البريد الإلكتروني الخارجي',
    'email-address.externalEmailHint' => 'سيتم استخدامه لإعادة تعيين كلمة مرورك إذا فقدت إمكانية الوصول إلى عنوان البريد الإلكتروني الأساسي.',
    'email-address.user' => 'مُعيّن إلى',
    'email-address.password' => 'كلمة المرور',
    'email-address.passwordConfirmation' => 'تأكيد كلمة المرور',
    'email-address.responderEnable' => 'تشغيل الرد التلقائي',
    'email-address.responderSubject' => 'عنوان رسالة الرد التلقائي',
    'email-address.responderContentType' => 'تنسيق الرسالة',
    'email-address.responderContentTypeHint' => 'يُدعم تنسيق النص العادي من جميع برامج عميل البريد، لذا يرى جميع المستلمين الرسالة بالطريقة نفسها التي تراها أنت. تبدو رسائل HTML بمظهر أفضل لأنها تتيح لك إدخال النص المُنسق بأنماط خط مختلفة. ومع ذلك، لا يدعم بعض عملاء البريد رسائل HTML وقد لا يرى بعض المستلمين النص المُنسق.',
    'email-address.responderContentTypeTextPlain' => 'نص عادي',
    'email-address.responderContentTypeTextHtml' => 'HTML',
    'email-address.responderCodepage' => 'ترميز',
    'email-address.responderCodepageHint' => 'يحدد الترميز كيفية عرض أحرف النص. الترميز المستحسن هو UTF-8.',
    'email-address.responderReplyTo' => 'إعادة توجيه إلى',
    'email-address.responderReplyToHint' => 'عندما يتم إرسال رد تلقائي، يتم إعادة توجيه الرسالة الأصلية إلى عنوان البريد الإلكتروني المحدد.',
    'email-address.responderForwardAddress' => 'إعادة توجيه إلى',
    'email-address.responderForwardAddressHint' => 'عندما يتم إرسال رد تلقائي، يتم إعادة توجيه الرسالة الأصلية إلى عنوان البريد الإلكتروني المحدد.',
    'email-address.responderMessage' => 'نص رسالة البريد الإلكتروني',
    'email-address.responderReplyToEqualsEmail' => 'عنوان إعادة التوجيه المحدد هو عنوان البريد نفسه هذا.',
    'email-address.responderForwardAddressEqualsEmail' => 'عنوان إعادة التوجيه المحدد هو عنوان البريد نفسه هذا.',
    'email-address.responderReplyLimit' => '‫أرسل ردًا تلقائيًا إلى عنوان بريد إلكتروني فريد لا يزيد عن (من المرات يوميًا)‬',
    'email-address.buttonAddResponderAttachment' => 'إضافة مرفقات',
    'email-address.buttonRemoveResponderAttachment' => 'إزالة',
    'email-address.responderAttachment' => 'إرفاق ملف',
    'email-address.redirectEnable' => 'تشغيل إعادة توجيه البريد',
    'email-address.redirectRemoveEnable' => 'لا تُسلم نسخ من رسائل البريد الإلكتروني المُعاد توجيهها إلى صندوق بريد منصة Plesk',
    'email-address.redirectAddress' => 'إعادة توجيه الرسائل الواردة إلى عنوان البريد الإلكتروتي التالي',
    'email-address.redirectAddressHint' => 'تحديد عناوين البريد الإلكتروني. يمكنك كتابة كل عنوان في سطر جديد، أو فصل العناوين بمسافات خالية، أو فاصلات أو فاصلات منقوطة.',
    'email-address.role' => 'دور المستخدم',
    'email-address.roleHint' => 'تمنح أدوار المستخدم المستخدمين امتيازات إدارية وإمكانية الوصول إلى التطبيقات التي قمت بتحديدها من أجل الدور.',
    'email-address.errorRedirectAddress' => 'لقد حددت عنوان بريد إلكتروني غير صالح: %value%.',
    'email-address.errorRedirectAddressMultiple' => 'لقد حددت عناوين بريد إلكتروني غير صالحة: %value%.',
    'email-address.mailAlias' => "اسم مستعار للبريد الإلكتروني",
    'email-address.mailAliasNone' => 'بلا',
    'email-address.mailAliasHint' => "تُعد الأسماء المستعارة للبريد الإلكتروني عناوين بديلة للبريد الإلكتروني وهي ترتبط بعنوان بريد إلكتروني أساسي. سيتسلّم عنوان البريد الإلكتروني الأساسي جميع رسائل البريد المُرسلة إلى الأسماء المستعارة للبريد الإلكتروني.",
    'email-address.buttonAddMailAlias' => 'إضافة اسم مستعار للبريد الإلكتروني',
    'email-address.buttonRemoveMailAlias' => 'إزالة',
    'email-address.emptyEmail' => 'حدد عنوان البريد الإلكتروني الذي يجب إعادة توجيه جميع الرسائل الواردة إليه.',
    'email-address.emailsIsEqual' => 'عنوان البريد الإلكتروني الخارجي متطابق مع عنوان البريد الإلكتروني الأساسي. حدد عنوان بريد إلكتروني خارجي آخر مختلف.',
    'email-address.emptyPassword' => 'يجب إدخال كلمة مرور.',
    'email-address.emptyPasswordConfirmation' => 'يجب تأكيد كلمة المرور.',
    'email-address.emptyAlias' => "حدد اسمًا مستعارًا للبريد الإلكتروني لعنوان البريد الإلكتروني هذا.",
    'email-address.aliasEqualsEmail' => 'الاسم المستعار للبريد الإلكتروني المحدد هو الاسم المستعار نفسه لعنوان البريد الإلكتروني.',
    'email-address.passwordHint' => 'سيتم استخدامه للوصول إلى صندوق البريد وللتسجيل إلى منصة Plesk (في حالة تمكين الخيار المقابل).',
    'email-address.cyclicRedirect' => 'لا يمكن إعداد عنوان البريد الإلكتروني بحيث تتم إعادة توجيه رسائل البريد الإلكتروني إلى نفسه.',
    'email-address.errorMailnameReserved' => 'عنوان البريد الإلكتروني المحدد قيد الاستخدام بالفعل.',
    'email-address.antivirusEnable' => 'تشغيل حماية مكافحة الفيروسات لعنوان البريد الإلكتروني هذا',
    'email-address.antivirusHint' => 'تعمل خدمة مكافحة الفيروسات على حظر رسائل البريد الإلكتروني التي تتضمن فيروسات، وتخبر كلاً من المُرسل والمُستقبل حول ذلك.',
    'email-address.antivirusSettings' => 'الكشف عن الفيروسات',
    'email-address.antivirusSettingOnlyIncomingMail' => 'البريد الوارد فقط',
    'email-address.antivirusSettingOnlyOutgoingMail' => 'البريد الصادر فقط',
    'email-address.antivirusSettingOnlyIncomingAndOutgoingMail' => 'البريد الوارد والصادر',
    'email-address.antispamHint' => 'تتحقق خدمة تصفية البريد العشوائي من الرسائل العشوائية المُرسلة إلى عنوان البريد الإلكتروني. يمكنك تعيين عامل تصفية البريد العشوائي بحيث يتم حذف الرسائل العشوائية، أو وضع علامة عليها كرسائل عشوائية عن طريق تغيير موضوعها، أو نقلها إلى مجلد مخصص للبريد العشوائي يمكن لعملاء الويب الوصول إليه من خلال IMAP. يستخدم عامل تصفية البريد العشوائي مجموعة كبيرة من الاختبارات المحلية وعلى مستوى الشبكة للتعرف على توقيعات البريد العشوائي.',
    'email-address.antispamEnable' => 'تشغيل تصفية البريد العشوائي لعنوان البريد الإلكتروني هذا',
    'email-address.antispamSettings' => 'يتم تصنيف ما يتم عمله مع الرسائل على أنه عشوائي',
    'email-address.antispamSettingsMark' => 'ضع علامة على رسائل البريد العشوائي عن طريق إضافة النص التالي إلى موضوع الرسالة',
    'email-address.antispamSettingsMarkHint' => 'اترك هذا الحقل فارغًا إذا لم تكن ترغب في إضافة أي نص. اكتب _SCORE_ إذا أردت تضمين النتيجة في موضوع الرسالة.',
    'email-address.antispamReportTextHint' => 'اكتب النص الذي تريد إضافته إلى نصوص رسالة البريد الإلكتروني العشوائي.',
    'email-address.antispamSettingsDelete' => 'حذف جميع الرسائل العشوائية',
    'email-address.antispamSettingsDeleteHint' => 'سيتم حذف الرسائل العشوائية من علبة البريد لديك.',
    'email-address.antispamSettingsMove' => 'نقل البريد العشوائي إلى مجلد البريد العشوائي',
    'email-address.antispamSettingsMoveHint' => 'نقل جميع رسائل البريد العشوائي إلى مجلد يسمى "البريد العشوائي". يمكن الوصول إلى هذا المجلد من برنامج عميل الويب أو بريد الويب. إذا كنت تستخدم حساب بريد IMAP، فستتمكن من استخدام مجلد "البريد العشوائي" لتدريب عامل تصفية البريد العشوائي.',
    'email-address.antispamSettingsMoveWarning' => 'لا يعمل خيار "نقل رسائل البريد العشوائي إلى مجلد رسائل البريد العشوائي" ما لم تقم بتعطيل الخيار "عدم تسليم نسخ من رسائل البريد الإلكتروني المُعاد توجيهها" في علامة التبويب "إعادة التوجيه".',
    'email-address.antispamSettingsMoveJunk' => 'انقل الرسائل غير المرغوب بها إلى مجلد "البريد الإلكتروني غير المهم"',
    'email-address.antispamSettingsMoveJunkHint' => 'انقل جميع الرسائل غير المرغوب بها إلى المجلد المسمى بـ "البريد الإلكتروني غير المهم". ويمكن الوصول إلى هذا المجلد من برنامج البريد بجهازك أو بريد الويب. إذا كنت تستخدم حساب بريد IMAP، فيمكنك استخدام مجلد "البريد الإلكتروني غير المهم" لتوجيه عامل تصفية الرسائل غير المرغوب بها.',
    'email-address.antispamShowAdvancedSection' => 'إظهار الإعدادات المتقدمة',
    'email-address.antispamHideAdvancedSection' => 'إخفاء الإعدادات المتقدمة',
    'email-address.antispamLearnMore' => 'تعرف على كيفية تدريب عامل تصفية البريد العشوائي.',
    'email-address.antispamFilterScoreTitle' => 'حساسية عامل التصفية',
    'email-address.antispamFilterScoreHint' => 'تُجري تصفية البريد العشوائي عددًا من الاختبارات المختلفة على المحتويات وسطر الموضوع لكل رسالة. ونتيجة لذلك، تحصل على رسالة على عددٍ من النقاط. وكلما زاد الرقم، زاد احتمال أن تصبح الرسالة من البريد العشوائي. وبشكل افتراضي، يتم تعيين حساسية عامل التصفية بحيث يتم تصنيف جميع الرسائل التي تحصل على 7 درجات أو أكثر على أنها بريد عشوائي. إذا تسلمت الكثير من الرسائل العشوائية مع الإعداد الحالي، ولزيادة حساسية عامل التصفية، جرّب إعداد قيمة أقل مثل 6. إذا كنت تفقد البريد الإلكتروني لأن عامل تصفية البريد العشوائي يعتقد أنه بريد غير هام، فجرّب تقليل حساسية عامل التصفية عن طريق تعيين قيمة أكبر مثل 8.',
    'email-address.antispamFilterScore' => 'حساسية تصفية البريد العشوائي',
    'email-address.antispamWhiteListTitle' => 'القائمة البيضاء',
    'email-address.antispamWhiteListHint' => 'لم يتم فحص رسائل البريد الإلكتروني الواردة من المرسلين المسجلين في القائمة البيضاء بواسطة فلتر الرسائل غير المرغوب فيها.',
    'email-address.antispamWhiteListField' => 'القائمة البيضاء',
    'email-address.antispamWhiteListFieldHint' => 'اكتب أسماء المجال، اسم مجال واحد لكل سطر. يمكن أن يتضمن العنوان أحرف البدل "*" و"؟" (مثال: *@domain.com، user?@*.com).',
    'email-address.antispamBlackListTitle' => 'القائمة السوداء',
    'email-address.antispamBlackListHint' => 'تم تصنيف رسائل البريد الإلكتروني الواردة من المرسلين المسجلين في القائمة السوداء على أنها رسائل غير مرغوب فيها.',
    'email-address.antispamBlackListField' => 'القائمة السوداء',
    'email-address.antispamBlackListFieldHint' => 'اكتب أسماء المجال، مجال واحد لكل سطر. يمكن أن يتضمن العنوان أحرف البدل "*" و"؟" (مثال: *@domain.com، user?@*.com).',
    'email-address.antispamTrustedLanguagesTitle' => 'اللغات الموثوق بها',
    'email-address.antispamTrustedLanguagesHint' => 'ستجتاز رسائل البريد الإلكتروني المكتوبة بهذه اللغة عامل التصفية دومًا.',
    'email-address.antispamTrustedLocalesTitle' => 'الإعدادات المحلية الموثوق بها',
    'email-address.antispamTrustedLocalesHint' => 'ستجتاز رسائل البريد الإلكتروني التي تستخدم مجموعات محلية محددة، عامل التصفية دومًا. تتضمن مجموعة الإعدادات المحلية مجموعات الأحرف الأكثر استخدامًا. على سبيل المثال، تتضمن مجموعة الأحرف الغربية ترميزات للأحرف المستخدمة في اللغات الإنجليزية ولغات غرب أوروبا.',
    'email-address.antispamTrustedNetworksTitle' => 'الشبكات الموثوق بها',
    'email-address.antispamTrustedNetworksHint' => 'من غير المحتمل أن يقوم المتطفلون بتشغيل مضيفي الترحيل على الشبكات الموثوق بها، كما لا يمكنهم فتح الترحيلات أو الوكلاء.',
    'email-address.antispamIpAddressesField' => 'عناوين IP',
    'email-address.antispamIpAddressesFieldHint' => 'حدد عنوان IP والقناع الخاص بالشبكة.',
    'email-address.mailBoxQuotaDomainDefault' => 'الحجم الافتراضي (%%domainMboxQuota%%)',
    'email-address.mailBoxQuotaDomainDefaultNew' => 'الحجم الافتراضي',
    'email-address.mailBoxOutgoingMessages' => 'الحد الأقصى لعدد رسائل البريد الصادرة',
    'email-address.mailBoxOutgoingMessagesDomainDefault' => 'افتراضي (%%domainOutgoingMessages%% من الرسائل في الساعة)',
    'email-address.mailBoxOutgoingMessagesDomainSpecific' => 'قيمة مخصصة لعلبة البريد',
    'email-address.mailBoxOutgoingMessagesDomainSpecificHint' => 'الرسائل',
    'email-address.mailBoxOutgoingMessagesDomainDefaultNew' => 'افتراضي',
    'email-address.mailBoxQuotaDomainDefaultReadonly' => 'الحجم الافتراضي',
    'email-address.mailBoxQuotaDomainSpecific' => 'حجم آخر',
    'email-address.mailBoxQuotaDomainSpecificReadonly' => 'حجم علبة البريد',
    'email-address.mailBoxQuotaUnlimited' => 'غير محدود',
    'email-address.mailBoxLimitReached' => 'تم الوصول إلى الحد على عدد علب البريد.',
    'email-address.postboxEnabled' => 'علبة البريد',
    'email-address.postboxEnabledYes' => 'تشغيل',
    'email-address.postboxEnabledNo' => 'إيقاف تشغيل',
    'email-address.description' => 'الوصف في تطبيق Plesk',
    'email-address.descriptionHint' => 'يكون الوصف مرئيًا لجميع الأشخاص الذين يتمتعون بإمكانية الوصول إلى حساب البريد الإلكتروني هذا.',
    'email-address.longDescription' => 'الوصف المحدد طويل جدًا. لا يمكن أن يكون أطول من %%max%% رمزًا.',
    'email-address.loginAsUser' => 'يمكن استخدامه لتسجيل الدخول إلى منصة Plesk',
    'email-address.loginAsUserDescription' => '(اسم المستخدم: %%username%%)',
    'email-address.maxCustomSizeDesc' => 'لا يمكن أن يتجاوز حجم علبة البريد الحجم الافتراضي.',
    'email-address.endDateEnable' => 'إيقاف تشغيل الرد التلقائي في',

    'failed-request.enable-tracing.description' => 'إن عملية تتبع الطلبات التي تعرضت للفشل هي عملية تستخدم المصدر بشدة. سيتوقف التتبع تلقائيًا خلال %%days%% يومًا (أيام). يمكنك إيقافها يدويًا في أي وقت.',
    'failed-request.enable-tracing.statusCodes' => 'رموز الحالة',
    'failed-request.enable-tracing.statusCodesDescription' => 'مثال: 401.3-999، 405',
    'failed-request.enable-tracing.provider' => 'الموفر',

    'file-manager.show.buttonReload' => 'إعادة تحميل',
    'file-manager.show.buttonSave' => 'حفظ',
    'file-manager.show.buttonSaveAs' => 'حفظ باسم',
    'file-manager.show.buttonReset' => 'إعادة تعيين',
    'file-manager.show.buttonTextCodeEditor' => 'تحرير في محرر التعليمات البرمجية',
    'file-manager.show.buttonTextEdit' => 'تحرير في محرر النصوص',
    'file-manager.show.buttonWysiwygEdit' => 'تحرير في محرر HTML',
    'file-manager.show.eolLabel' => 'نوع فاصل السطر:',
    'file-manager.show.saveAs' => 'حفظ باسم:',
    'file-manager.show.saveCodepage' => 'حفظ بالترميز التالي:',
    'file-manager.show.loadCodepage' => 'عرض الملف الأصلي بالترميز التالي:',
    'file-manager.show.loadCodepageHint' => 'تحذير: ستُفقد أي تغييرات غير محفوظة عند إعادة تحميل الملف.',
    'file-manager.show.fileExists' => "الملف أو المجلد %%fileName%% موجود بالفعل. لا يمكن أن يكون لديك مجلد وملف بالاسم نفسه.",
    'file-manager.show.popupTitle' => 'حفظ باسم',
    'file-manager.show.popupFilename' => 'اسم الملف:',

    'file-manager.permissions.filePermissions' => 'أذونات الملف',
    'file-manager.permissions.directoryPermissions' => 'أذونات الدليل',
    'file-manager.permissions.buttonSubmit' => '‫حفظ‬',
    'file-manager.permissions.buttonApply' => 'حفظ واستئناف',
    'file-manager.permissions.buttonCancel' => 'إلغاء',
    'file-manager.permissions.buttonAdvanced' => 'خيارات متقدمة',

    'file-manager.unix-file-permissions.group' => 'مجموعة',
    'file-manager.unix-file-permissions.owner' => 'المالك',
    'file-manager.unix-file-permissions.others' => 'أخرى',
    'file-manager.unix-file-permissions.readMode' => 'القراءة',
    'file-manager.unix-file-permissions.writeMode' => 'كتابة',
    'file-manager.unix-file-permissions.execMode' => 'تنفيذ/بحث',
    'file-manager.unix-file-permissions.changeRecursive' => 'تغيير الأذونات بشكل متكرر',

    'file-manager.windows-permissions.allow' => 'السماح',
    'file-manager.windows-permissions.deny' => 'رفض',
    'file-manager.windows-permissions.inheritFromParent' => 'السماح للأذونات المكتسبة من الأصل بالنشر إلى هذا الكائن وجميع الكائنات الفرعية. تضمين ذلك في المدخلات الموضحة بشكل صريح هنا',
    'file-manager.windows-permissions.replaceOnChildren' => 'استبدال مدخلات الإذن على جميع الكائنات الفرعية باستخدام المدخلات المعروضة هنا',
    'file-manager.windows-permissions.buttonAdvanced' => 'خيارات متقدمة',
    'file-manager.windows-permissions.applyTo' => 'تطبيق على:',
    'file-manager.windows-permissions.folderOnly' => 'هذا المجلد فقط',
    'file-manager.windows-permissions.subfolderOnly' => 'المجلدات الفرعية فقط',
    'file-manager.windows-permissions.filesOnly' => 'الملفات فقط',
    'file-manager.windows-permissions.permissionsFor' => 'الأذونات الخاصة بـ',
    'file-manager.windows-permissions.applyOnto1' => 'هذا المجلد فقط',
    'file-manager.windows-permissions.applyOnto2' => 'المجلدات الفرعية فقط',
    'file-manager.windows-permissions.applyOnto3' => 'هذا المجلد والمجدات الفرعية',
    'file-manager.windows-permissions.applyOnto4' => 'الملفات فقط',
    'file-manager.windows-permissions.applyOnto5' => 'هذا المجلد والملفات',
    'file-manager.windows-permissions.applyOnto6' => 'المجلد الفرعي والملفات فقط',
    'file-manager.windows-permissions.applyOnto7' => 'هذا المجلد والملفات الفرعية والملفات',
    'file-manager.windows-permissions.notInherited' => '<غير مكتسب>',

    'file-manager.editor.titleTextEditor' => 'محرر النص',
    'file-manager.editor.titleCodeEditor' => 'محرر الرمز',
    'file-manager.editor.titleCodeViewer' => 'عرض',
    'file-manager.editor.buttonSubmit' => '‫حفظ‬',
    'file-manager.editor.buttonApply' => 'حفظ واستئناف',
    'file-manager.editor.buttonSaveAs' => 'حفظ كـ ...',
    'file-manager.editor.buttonCancel' => 'إلغاء',
    'file-manager.editor.exitConfirmationYes' => '‫نعم‬',
    'file-manager.editor.exitConfirmationNo' => '‫لا‬',
    'file-manager.editor.fileOverwrite' => 'الملف موجود بالفعل.',
    'file-manager.editor.fileOverwriteDescription' => 'يوجد بالفعل ملف بنفس الاسم. هل تريد استبداله؟',
    'file-manager.editor.exitConfirmation' => 'هل تريد بالتأكيد إغلاق الملف وتجاهل التغييرات التي لم يتم حفظها؟',
    'file-manager.editor.buttonCodeEditor' => 'التحرير في محرر التعليمات البرمجية',
    'file-manager.editor.buttonTextEditor' => 'التحرير في محرر النص',
    'file-manager.editor.buttonHtmlEditor' => 'التحرير في محرر HTML',

    'file-manager.import-file.buttonSubmit' => 'استيراد',
    'file-manager.import-file.fieldUrl' => 'عنوان URL الخاص بالملف',
    'file-manager.import-file.fieldUrlDescription' => 'حدد عنوان URL المصدر، على سبيل المثال، "https://example.com/example.tgz".',
    'file-manager.import-file.fieldUrlFullDescription' => 'نمط عنوان URL الكامل هو كالتالي: "https://user:password@example.com/example.tgz". اسم المُستخدِم وكلمة المرور اختياريان. البروتوكولات المدعومة هي http وhttps وftp وftps. استخدم ترميز عنوان URL لأجزاء عنوان URL التي تحتوي على أحرف خاصة أو مسافات.',
    'file-manager.import-file.failure' => 'تعذر استيراد الملف.',

    'file-manager.rotation-settings.title' => 'إعدادات تدوير سلة المحذوفات',
    'file-manager.rotation-settings.rotationBySize' => 'التدوير حسب الحجم',
    'file-manager.rotation-settings.rotationBySizeUnits' => 'ميغابايت',
    'file-manager.rotation-settings.rotationBySizeHint' => 'يحذف الخيار الملفات الجديدة طالما تم تجاوز الحد المعين لسلة المحذوفات.',
    'file-manager.rotation-settings.rotationByDate' => 'التدوير حسب التاريخ',
    'file-manager.rotation-settings.rotationByDateUnits' => 'أيام',
    'file-manager.rotation-settings.rotationByDateHint' => 'يحذف هذا الخيار الملفات المخزنة في سلة المحذوفات لأكثر من عدد محدد من الأيام.',

    'ftp-user.description' => 'إذا كنت تعمل على موقعك الإلكتروني مع شخص آخر أو إذا كنت تستضيف مجالات فرعية لمستخدمين آخرين، فقد ترغب في إنشاء حسابات FTP منفصلة لها.',
    'ftp-user.generalSection' => 'عام',
    'ftp-user.login' => 'اسم حساب FTP',
    'ftp-user.home' => 'دليل الصفحة الرئيسية',
    'ftp-user.systemArea' => 'أنشئ حساب FTP يتمتع بإمكانية الوصول إلى الملفات خارج الدليل الرئيسي',
    'ftp-user.password' => 'كلمة المرور',
    'ftp-user.passwordConfirmation' => 'تأكيد كلمة المرور',
    'ftp-user.hardQuotaSection' => 'حصة القرص الثابت',
    'ftp-user.hardQuota' => 'حصة القرص الثابت',
    'ftp-user.hardQuotaUnlimited' => 'غير محدود',
    'ftp-user.permissionsSection' => 'الأذونات',
    'ftp-user.permissionRead' => 'إذن القراءة',
    'ftp-user.permissionWrite' => 'إذن الكتابة',
    'ftp-user.popupTitle' => 'تحديد دليل',

    'mail-list.listName' => 'عنوان قائمة المراسلة',
    'mail-list.enabled' => 'قيد التشغيل',
    'mail-list.administratorEmail' => 'البريد الإلكتروني لمسؤول قائمة المراسلة',
    'mail-list.password' => 'كلمة المرور',
    'mail-list.passwordConfirmation' => 'تأكيد كلمة المرور',
    'mail-list.subscribers' => 'المشتركون',
    'mail-list.subscribersHint' => 'تحديد عناوين البريد الإلكتروني. يمكنك كتابة كل عنوان في سطر جديد، أو فصل العناوين بمسافة، أو رموز الفاصلة، أو الفاصلات المنقوطة.',
    'mail-list.notify' => 'إعلام المسؤول عند إنشاء قائمة مراسلة',
    'mail-list.emptyPassword' => 'إدخال كلمة مرور.',
    'mail-list.emptyPasswordConfirmation' => 'يُرجى تأكيد كلمة المرور.',
    'mail-list.errorSubscribers' => 'عناوين بريد إلكتروني غير صالحة:  %value%.',
    'mail-list.errorMaillistReserved' => 'عنوان قائمة المراسلة المحدد قيد الاستخدام بالفعل.',

    'mail-settings.hint' => 'وهذا هو المكان الذي يمكنك من خلاله تغيير إعدادات خدمة البريد لهذا المجال.',
    'mail-settings.service' => 'تنشيط خدمة البريد على هذا المجال',
    'mail-settings.nonExist' => 'ما ينبغي القيام به مع مستخدمي البريد غير الموجودين',
    'mail-settings.nonExistBounceWithMessage' => 'بريد مرتد باستخدام رسالة',
    'mail-settings.nonExistBounce' => 'ارتداد',
    'mail-settings.nonExistCatch' => 'إعادة التوجيه إلى عنوان',
    'mail-settings.nonExistCatchDescription' => 'ينبغي أن يتنمي العنوان إلى المجال المحدد. يمكن للمسؤول وحده تحديد عنوان خارجي أو عنوان واحد لمجالات متعددة.',
    'mail-settings.nonExistExternal' => 'إعادة التوجيه إلى خادم بريد خارجي باستخدام عنوان IP',
    'mail-settings.nonExistReject' => 'رفض',
    'mail-settings.nonExistDiscard' => 'رفض',
    'mail-settings.webmail' => 'بريد الويب',
    'mail-settings.webmailNone' => 'بلا',
    'mail-settings.webmailComponentNotInstalled' => 'إن مكون بريد الويب غير مثبت.',
    'mail-settings.webmailSubdomainAlreadyExists' => 'يوجد مجال فرعي بالاسم %%subdomain%%.',
    'mail-settings.webmailCertificate' => 'شهادة SSL/TLS لبريد الويب.',
    'mail-settings.webmailCertificateNone' => 'غير محدد',
    'mail-settings.mailCertificate' => 'شهادة SSL/TLS للبريد',
    'mail-settings.mailCertificateNone' => 'لم يتم التحديد',
    'mail-settings.serverCertificateNotSelected' => 'تم تعيين الشهادة، ولكن لم يتم تأمين البريد للمجال. لإنهاء تأمين البريد للمجال، %%certLink%%.',
    'mail-settings.serverCertificatesList' => 'تأمين خادم البريد',
    'mail-settings.mailLists' => 'تمكين قوائم المراسلة',
    'mail-settings.mailAutodiscovery' => 'تمكين الاكتشاف التلقائي للبريد',
    'mail-settings.mailAutodiscoveryDescription' => 'تعرِّف على كيفية عملها في %%link%%',
    'mail-settings.mailAutodiscoveryDescriptionLink' => 'قاعدة المعرفة',
    'mail-settings.domainKeys' => 'استخدم نظام الحماية من البريد العشوائي بآلية DKIM للتحقق من رسائل البريد الإلكتروني الصادرة',
    'mail-settings.greyListing' => 'تشغيل الحماية من البريد العشوائي الخاصة بالقائمة الرمادية بالنسبة إلى جميع حسابات البريد ضِمن هذا المجال',
    'mail-settings.howToConfigureExternalDns' => 'كيفية تكوين DNS الخارجي',
    'mail-settings.howToConfigureExternalDnsAlways' => 'لتمكين توقيع DKIM إذا كنت تستخدم خادم DNS خارجي، فستحتاج إلى تكوين سجلات DKIM DNS على خادم DNS بنفسك.',
    'mail-settings.howToConfigureExternalDnsEnabled' => 'للقيام بذلك، استخدم سجلات DKIM DNS الواردة أدناه:',
    'mail-settings.howToConfigureExternalDnsEnabledAliases' => 'إذا كانت لديك أسماء نطاق مستعارة تستخدمها لإرسال البريد، فأضف سجلات DKIM DNS لها أيضًا. استخدم نفس السجلات الخاصة بالنطاق الرئيسي ولكن مع اسم النطاق المستعار.',
    'mail-settings.howToConfigureExternalDnsDisabled' => 'لرؤية سجلات DKIM DNS التي تحتاج إلى تكوينها، حدد مربع الاختيار "%%option%%"، واستخدمه وافتح هذه النافذة المنبثقة مرة أخرى.',
    'mail-settings.mailServiceDisabled' => 'مُعطَّل',
    'mail-settings.mailServiceDisabledIncoming' => 'معطَّلة للبريد الوارد',
    'mail-settings.mailServiceDisabledHint' => 'لن تقدم Plesk أي خدمات بريدية على هذا المجال.',
    'mail-settings.mailServiceDisabledIncomingHint' => 'لا يمكن لهذا المجال سوى إرسال البريد وعدم استخدام سوى Sendmail.',
    'mail-settings.mailServiceEnabled' => 'مُمكّن',
    'mail-settings.mailServiceEnabledHint' => 'يمكن لهذا المجال إرسال البريد واستلامه.',
    'mail-settings.mailServiceNotConfigured' => 'لم يتم تكوينه',
    'mail-settings.mailServiceNotConfiguredHint' => 'لن تقدم Plesk أي خدمات بريدية على هذا المجال.',
    'mail-settings.warning' => 'سيؤدي ذلك إلى إزالة صناديق بريد المجال نهائيًا مع جميع رسائل البريد الإلكتروني المستلمة والمرسلة.',
    'mail-settings.show.title' => 'أزل جميع صناديق البريد ورسائل البريد الإلكتروني الخاصة بـ %%domain%%',
    'mail-settings.show.checkbox' => 'أزل جميع صناديق البريد الخاصة بـ <b>%%domain%%</b> نهائيًا، بما في ذلك رسائل البريد الإلكتروني المستلمة والمرسلة.',

    'role.roleSection' => 'عام',
    'role.name' => 'اسم دور المستخدم',
    'role.description' => 'الوصف',
    'role.generalPermissionsSection' => 'الوصول إلى خدمات Plesk',
    'role.applicationsAccessSection' => 'الوصول إلى التطبيقات',
    'role.permissionAllow' => 'مضمون',
    'role.permissionDeny' => 'مرفوض',
    'role.emptyRoleName' => 'يرجى إدخال اسم دور معين.',
    'role.installedAt' => 'مثبت في',
    'role.noInstallationUrlAvailable' => 'تطبيق خارجي',
    'role.invalidRoleName' => 'اسم دور المستخدم المحدد غير صالح. لا يمكن استخدام علامات الاستفهام والتنصيص في اسم الدور.',
    'role.longRoleName' => 'اسم دور المستخدم المحدد طويل جدًا.',
    'role.somePermissionsAreNotAllowedForSomeSubscriptions' => 'قد لا تكون بعض العمليات متاحة للأسباب التالية: لم يتم منح الإذن للعملية باستخدام الاشتراك المحدد حاليًا، أو كمية الموارد المخصصة غير كافية لإجراء عملية معينة.',
    'role.servicesPermissionsDescription' => 'قم بتحديد إمكانية الوصول إلى التطبيقات المثبتة أو خدمات Plesk بالنسبة إلى جميع المستخدمين أصحاب هذا الدور. إذا منحت أحد المستخدمين إمكانية الوصول إلى تطبيق معين، فسيصبح التطبيق متاحًا له في "لوحة العميل".',
    'role.emailActivation' => 'قم بتفعيل الحسابات الخاصة بهذا الدور/هذه الأدوار عبر البريد الإلكتروني',

    'service.admin-access.adminAccess' => 'وصول إداري',
    'service.admin-access.customCredentialsDescriptionNoEntryPoints' => 'سيتم استخدام بيانات التعريف هذه من أجل الوصول الإداري إلى هذا التطبيق.',
    'service.admin-access.login' => 'اسم مستخدم إداري',
    'service.admin-access.password' => 'كلمة مرور إدارية',
    'service.admin-access.passwordConfirmation' => 'تأكيد كلمة المرور',

    'service.info.service-entry-point.availableAt' => 'متوفر في',
    'service.info.service-entry-point.customize' => 'تخصيص الاختصار',
    'service.info.service-entry-point.displayNameLabel' => 'اسم الاختصار',
    'service.info.service-entry-point.displayNameDescription' => 'توفير اسم لهذا الاختصار. يتم عرض الاسم أسفل رمز الاختصار. يتم وضع الاختصارات على صفحات "خدماتي" الخاصة بالمستخدمين الذين مُنحوا إمكانية الوصول إلى هذا التطبيق.',
    'service.info.service-entry-point.descriptionLabel' => 'وصف الاختصار',
    'service.info.service-entry-point.descriptionDescription' => 'توفير وصف لهذا الاختصار. يتم عرض هذا الوصف كتلميح أداة عندما يتم تحريك مؤشر الماوس فوق الاختصار.',
    'service.info.service-entry-point.iconLabel' => 'انقر لتحديد رمز الاختصار',
    'service.info.service-entry-point.iconCurrent' => 'الرمز الحالي',
    'service.info.service-entry-point.errorEmptyName' => 'يجب عليك إدخال اسم للاختصار',
    'service.info.service-entry-point.errorLongName' => 'يجب أن يتراوح طول اسم الاختصار بين حرف واحد و255 حرفًا.',
    'service.info.service-entry-point.errorLongDescription' => 'يجب أن يتراوح وصف الاختصار بين 0 و255 حرفًا.',
    'service.info.service-entry-point.hiddenLabel' => 'إخفاء الاختصار',
    'service.info.service-entry-point.hiddenDescription' => 'عدم عرض هذا الاختصار على المستخدمين.',

    'service.info.service-permission.assignedUser' => "منح المسؤول إمكانية الوصول إلى هذا المستخدم",
    'service.info.service-permission.assignedUserNone' => 'لم يتم تعيين مستخدم',

    'shared-ssl.master-ssl.switchedOn' => 'تشغيل SSL/TLS المشتركة',
    'shared-ssl.master-ssl.domainName' => 'اسم النطاق لموقع ستتم مشاركة شهادة SSL/TLS الخاصة به مع مواقع أخرى',
    'shared-ssl.master-ssl.none' => 'بلا',
    'shared-ssl.master-ssl.noDomainsWithSslWarning' => 'يتعذر تشغيل SSL/TLS المشتركة بسبب عدم وجود نطاقات تتمتع بدعم SSL/TLS ممكّن.',

    'user.email.email' => 'عنوان البريد الإلكتروني',
    'user.email.emptyEmail' => 'يلزم عليك توفير عنوان بريد إلكتروني.',
    'user.email.internalEmailHint' => 'قم بإنشاء عنوان بريد إلكتروني جديد في منصة Plesk أو استخدم عنوان بريد إلكتروني خارجي.',
    'user.email.longInternalEmail' => 'عنوان البريد الإلكتروني طويل جدًا.',
    'user.email.longInternalEmailMailboxAddressMailServer' => 'إن جزء اسم المستخدم للبريد الإلكتروني طويل جدًا بالنسبة إلى خادم البريد هذا. يُرجى تحديد اسم مستخدم لا يزيد طوله عن %%max%% رمزًا.',
    'user.email.longInternalEmailFullAddressMailServer' => 'عنوان البريد الإلكتروني طويل جدًا بالنسبة إلى خادم البريد هذا. يُرجى تحديد عنوان بريد إلكتروني لا يزيد طوله عن %%max%% رمزًا.',
    'user.email.externalEmail' => 'عنوان البريد الإلكتروني الخارجي',
    'user.email.externalEmailHint' => 'سيتم استخدامه لإعادة تعيين كلمة مرورك إذا فقدت إمكانية الوصول إلى عنوان البريد الإلكتروني الأساسي.',
    'user.email.emailsIsEqual' => 'عنوان البريد الإلكتروني الخارجي متطابق مع عنوان البريد الإلكتروني الأساسي. حدد عنوان بريد إلكتروني خارجي آخر مختلف.',
    'user.email.atLeastOneEmailShouldBeSet' => 'يرجى تحديد عنوان بريد إلكتروني داخلي أو خارجي.',

    'user.profileSection' => 'معلومات عامة',
    'user.contactName' => 'اسم جهة الاتصال',
    'user.email' => 'عنوان البريد الإلكتروني',
    'user.role' => 'دور المستخدم',
    'user.accountSection' => 'تفضيلات Plesk',
    'user.login' => 'اسم المستخدم',
    'user.password' => 'كلمة المرور',
    'user.buttonBack' => 'رجوع',
    'user.generalTab' => 'عام',
    'user.applicationsAccessSection' => 'خدمات',
    'user.generalPermissionsSection' => 'الامتيازات',
    'user.contactsTab' => 'تفاصيل الاتصال',
    'user.passwordConfirmation' => 'تأكيد كلمة المرور',
    'user.internalEmailPasswordChanged' => 'سيؤدي تغيير كلمة المرور أيضًا إلى تغيير كلمة مرور عنوان البريد الإلكتروني الداخلي.',
    'user.emailName' => 'عنوان البريد الإلكتروني',
    'user.emailType' => 'نوع البريد الإلكتروني',
    'user.companyName' => 'اسم الشركة',
    'user.phone' => 'رقم الهاتف',
    'user.imNumber' => 'المراسلة الفورية',
    'user.fax' => 'رقم الفاكس',
    'user.address' => 'عنوان',
    'user.city' => 'المدينة',
    'user.state' => 'الولاية أو المقاطعة',
    'user.zip' => 'الرمز البريدي',
    'user.country' => 'البلد',
    'user.additionalInfo' => 'معلومات إضافية',
    'user.additionalInfoHint' => 'نص عادي فقط: سيتم تجاهل جميع علامات HTML.',
    'user.language' => 'لغة تطبيق Plesk',
    'user.buttonChangePassword' => 'تغيير كلمة المرور',
    'user.permissionAllow' => 'مضمون',
    'user.permissionDeny' => 'مرفوض',
    'user.permissionInherited' => 'محدد حسب الدور',
    'user.emptyContactName' => 'يجب إدخال اسم اتصال.',
    'user.emptyLogin' => 'يجب إدخال اسم مستخدم.',
    'user.emptyPassword' => 'يجب إدخال كلمة مرور.',
    'user.emptyPasswordConfirmation' => 'يجب تأكيد كلمة المرور.',
    'user.chooseDomainBoxTitle' => 'حدد مجالا آخر:',
    'user.userIsActive' => 'المستخدم نشط',
    'user.userIsActiveHint' => 'بإمكان المستخدمين النشطين الوصول إلى Plesk.',
    'user.emailActivation' => 'قم بتفعيل الحساب عن طريق البريد الإلكتروني',
    'user.emailHint' => 'لإعطاء المستخدم عنوان بريد إلكتروني مستضافًا على هذا الخادم، انتقل إلى علامة تبويب البريد، وأنشئ عنوان بريد إلكتروني محددًا وقم بربطه مع هذا المستخدم.',
    'user.emailContactHint' => 'اتصل بموفر الخدمة إذا كنت تريد استخدام عنوان البريد الإلكتروني المستضاف على هذا الخادم.',
    'user.personalEmailHint' => "يمكن تغيير عنوان البريد الإلكتروني لهذا المستخدم في علامة تبويب البريد.",
    'user.externalMailRedirectHint' => 'يمكن تنشيط إعادة التوجيه لعناوين البريد الإلكتروني المستضافة على هذا الخادم فقط. لإنشاء عنوان بريد إلكتروني، انتقل إلى علامة تبويب البريد.',
    'user.externalMailRedirectHint2' => 'يمكن تنشيط إعادة التوجيه لعناوين البريد الإلكتروني المستضافة على هذا الخادم فقط.',
    'user.externalMailAutoResponderHint' => 'يمكن تنشيط الرد التلقائي لعناوين البريد الإلكتروني المستضافة على هذا الخادم فقط. لإنشاء عنوان بريد إلكتروني، انتقل إلى علامة تبويب البريد.',
    'user.externalMailAutoResponderHint2' => 'يمكن تنشيط الرد التلقائي لعناوين البريد الإلكتروني المستضافة على هذا الخادم فقط.',
    'user.roleHint' => 'تمنح أدوار المستخدم المستخدمين امتيازات إدارية وإمكانية الوصول إلى التطبيقات التي قمت بتحديدها من أجل الدور.',
    'user.cannotManageMail' => "ليس لديك الإذن لإدارة إعدادات البريد والخدمات.",
    'user.longCompanyName' => 'اسم الشركة المحدد طويل جدًا.',
    'user.longPhone' => 'رقم الهاتف المحدد طويل جدًا.',
    'user.longFax' => 'رقم الفاكس المحدد طويل جدًا.',
    'user.longAddress' => 'العنوان المحدد طويل جدًا.',
    'user.longCity' => 'اسم المدينة المحدد طويل جدًا.',
    'user.phoneRegexNotMatch' => 'رقم الهاتف المحدد غير صالح.',
    'user.faxRegexNotMatch' => 'رقم الفاكس المحدد غير صالح.',
    'user.shortCity' => 'اسم المدينة المحدد قصير جدًا.',
    'user.limitSubscription' => 'الوصول إلى الاشتراكات',
    'user.limitSubscriptionHint' => 'السماح للمستخدمين بالوصول إلى الاشتراك المحدد فقط. تمنح القيمة "All" (الجميع) إمكانية الوصول إلى كل الاشتراكات في حساب الاستضافة الخاص بك.',
    'user.limitSubscriptionAll' => 'الجميع',
    'user.deletedSubscription' => 'تمت إزالة الاشتراك',

    'web.add-domain-alias.title' => 'إضافة اسم مستعار للمجال',
    'web.add-domain-alias.createdSuccessfully' => "تم إنشاء الاسم المستعار %%name%% للمجال.",
    'web.add-domain-alias.domainAliasName' => 'اسم الاسم المستعار للمجال',
    'web.add-domain-alias.domainAliasNameHint' => 'على سبيل المثال، example.net',
    'web.add-domain-alias.forDomain' => 'للمجال',
    'web.add-domain-alias.settingsSectionLegend' => 'الإعدادات',
    'web.add-domain-alias.settingsDns' => 'مزامنة منطقة DNS مع المجال الأساسي',
    'web.add-domain-alias.settingsMail' => 'خدمة البريد',
    'web.add-domain-alias.settingsWeb' => 'خدمة الويب',
    'web.add-domain-alias.settingsSeoRedirect' => 'إعادة التوجيه باستخدام رمز HTTP 301',
    'web.add-domain-alias.settingsSeoRedirectHint' => 'عندما يقوم الزائرون بفتح عنوان URL للاسم المستعار، ستتم إعادة توجيههم إلى عنوان URL للمجال الأساسي. يستخدم Plesk إعادة التوجيه HTTP 301 المناسب لمحرك البحث، والذي يعني أن تصنيف محرك البحث سيتم تقسيمه بين عناوين URL.',
    'web.add-domain-alias.settingsTomcat' => 'تطبيقات الويب المرتبطة بـ Java',
    'web.add-domain-alias.invalidDomainGuid' => 'مجال غير صالح',

    'web.add-domain.formTitle' => 'إضافة نطاق جديد',
    'web.add-domain.portalLink' => 'بوابة الخدمات',
    'web.add-domain.domainName' => 'اسم المجال',
    'web.add-domain.domainNameHint' => "على سبيل المثال، example.com",
    'web.add-domain.assignToCustomer' => 'تعيين هذا المجال إلى أحد العملاء',
    'web.add-domain.customer' => 'تحديد عميل',
    'web.add-domain.createNewCustomer' => 'إنشاء عميل جديد',
    'web.add-domain.selectExistingCustomer' => 'تحديد أحد العملاء الموجودين:',
    'web.add-domain.customerContactInfoHint' => 'أدخل معلومات الاتصال بالعميل. يمكنك تحديد جميع المعلومات الأخرى مثل رقم الهاتف والعنوان بعد ذلك.',
    'web.add-domain.customerLoginInfoHint' => 'بيانات الاعتماد للوحة العملاء',
    'web.add-domain.target' => 'مساحة الويب',
    'web.add-domain.createNewTarget' => 'إنشاء اشتراك جديد',
    'web.add-domain.createNewTarget_powerUser' => 'إنشاء مساحة ويب جديدة',
    'web.add-domain.selectExistingTarget' => 'تحديد اشتراك موجود:',
    'web.add-domain.selectExistingTarget_powerUser' => 'تحديد مساحة ويب موجودة:',
    'web.add-domain.dns' => 'تنشيط خدمة DNS',
    'web.add-domain.dnsHint' => '',
    'web.add-domain.mail' => 'تنشيط خدمة البريد',
    'web.add-domain.mailHint' => '',
    'web.add-domain.mailHintNoPermission' => 'تعمل إذا كانت إعدادات الاشتراك تسمح بإدارة إذن البريد لكل نطاق. أما إذا كانت لا تسمح الإعدادات بذلك، يتم تأمين بريد الويب باستخدام الشهادة المحددة.',
    'web.add-domain.hostingManagementOptions' => 'نوع الاستضافة',
    'web.add-domain.websiteHosting' => 'استضافة مواقع الويب',
    'web.add-domain.websiteForwarding' => 'إعادة التوجيه',
    'web.add-domain.websiteNoHosting' => 'لا توجد استضافة',
    'web.add-domain.hostingSettingsSectionLegend' => 'إعدادات الاستضافة',
    'web.add-domain.domainCreatedSuccessfully' => 'تم إنشاء المجال %%domainName%%بنجاح.',
    'web.add-domain.webspaceLegend' => 'إعدادات مساحة الويب',
    'web.add-domain.addWhmWebsiteTitle' => 'إضافة موقع ويب جديد',
    'web.add-domain.addWhmWebsiteHint' => "يمكنك اختيار استضافة موقع ويب على الخادم.",
    'web.add-domain.selectWhmDomain' => 'تحديد مجال',
    'web.add-domain.customerLegend' => 'معلومات العميل',
    'web.add-domain.credentials' => 'بيانات اعتماد مُستخدِم النظام',
    'web.add-domain.credentialsHint' => 'للوصول إلى الملفات المستضافة عبر FTP وSSH',
    'web.add-domain.credentialsHintWin' => 'للوصول إلى الملفات المستضافة عبر FTP وRDP',
    'web.add-domain.buttonAddDomain' => 'إضافة نطاق',

    'web.add-subdomain.formTitle' => 'إضافة مجال فرعي',
    'web.add-subdomain.formGeneralHint' => 'المجالات الفرعية هي عناوين إنترنت لأجزاء مختلفة من موقعك الإلكتروني. وهي تستخدم اسم المجال الرئيسي الخاص بك وبادئة. على سبيل المثال: إذا كان المجال الخاص بك هو domain.com، فقد يكون المجال الفرعي هو store.domain.com.',
    'web.add-subdomain.formGeneralHintAdditional' => 'كما يمكنك أيضًا إنشاء مجال فرعي بديل عن طريق إدخال رمز النجمة * بدلاً من الاسم. ستتم إعادة توجيه زائري الموقع إلى هذا المجال الفرعي بصرف النظر عن اسم المجال الفرعي الذي أدخلوه في المستعرض.',
    'web.add-subdomain.subdomainName' => 'اسم المجال الفرعي',
    'web.add-subdomain.subdomainNameHint' => 'أدخل علامة النجمة * لإنشاء مجال فرعي بديل.',
    'web.add-subdomain.forDomain' => 'المجال الأصلي',
    'web.add-subdomain.subdomainCreatedSuccessfully' => 'تم إنشاء المجال الفرعي.',
    'web.add-subdomain.hostingSettingsSectionLegend' => 'إعدادات الاستضافة',

    'web.change-hosting.formGeneralHint' => 'يمكنك اختيار استضافة موقع الويب على الخادم (استضافة مواقع الويب)، لإعداد إعادة توجيه الويب إلى موقع ويب آخر (إعادة التوجيه)، أو لاستخدام منطقة DNS للمجال من أجل الحصول على علب البريد ضِمن اسم المجال هذا (عدم الاستضافة).',
    'web.change-hosting.changed' => 'تم تغيير نوع الاستضافة الخاص بـ %%domainName%% بنجاح.',
    'web.change-hosting.hostingManagementOptions' => 'نوع الاستضافة',
    'web.change-hosting.websiteHosting' => 'استضافة مواقع الويب',
    'web.change-hosting.websiteForwarding' => 'إعادة التوجيه',
    'web.change-hosting.websiteNoHosting' => 'لا توجد استضافة ويب',
    'web.change-hosting.hostingSettingsSectionLegend' => 'إعدادات الاستضافة',
    'web.change-hosting.userName' => 'اسم المستخدم',
    'web.change-hosting.userNameHint' => 'مستخدم النظام لإدارة الملفات والمجلدات ضِمن الاشتراك.',
    'web.change-hosting.userNameHint_powerUser' => 'مستخدم النظام لإدارة الملفات والمجلدات ضِمن مساحة الويب.',
    'web.change-hosting.emptyLogin' => 'يجب تحديد اسم مستخدم.',
    'web.change-hosting.password' => 'كلمة المرور',
    'web.change-hosting.emptyPassword' => 'يجب تحديد كلمة مرور.',
    'web.change-hosting.passwordConfirmation' => 'تأكيد كلمة المرور',
    'web.change-hosting.warningInstalledApplications' => 'توجد تطبيقات ويب مثبتة على الموقع. إذا قمت بتغيير نوع الاستضافة، فلن تعد التطبيقات قابلة للوصول.',
    'web.change-hosting.removeWebsiteHostingTitle' => 'تحذير: سيتم حذف محتوى موقع الويب.',
    'web.change-hosting.removeWebsiteHostingDescription' => 'هل ترغب في تغيير نوع الاستضافة لموقعك على الويب؟',
    'web.change-hosting.removeWebsiteHostingDescriptionFolders' => 'سيتم حذف المجلدات التالية ومحتواها بالكامل:',
    'web.change-hosting.removeWebsiteHostingDescriptionAllFolders' => 'سيتم حذف جميع محتويات المجلد الجذر webspace.',

    'web.change-status.changed' => 'تم تغيير حالة موقع الويب %%domainName%% بنجاح.',
    'web.change-status.statusManagementOptions' => 'حالة موقع الويب',
    'web.change-status.statusDisabled' => 'مُعطل (معروف سابقًا باسم "مجمد")',
    'web.change-status.statusSuspended' => 'معلّق',
    'web.change-status.statusActive' => 'نشط',
    'web.change-status.statusDisabledHint' => 'لن يظل موقع الويب مستضافًا على الخادم، ولن يتوفر إلا لعملاء FTP وإدارة الملفات. سيشاهد الزائرون الصفحة الافتراضية لخادم الويب. لن تكون خدمة البريد متوفرة.',
    'web.change-status.statusSuspendedHint' => 'سيظل موقع الويب مستضافًا على الخادم، ولكن ستتم إعادة توجيه الزائرين باستخدام الرمز 503 HTTP إلى صفحة مستند الخطأ المخصص. ستظل خدمة البريد متوفرة. فيما يلي يمكنك %%link%%.',
    'web.change-status.statusSuspendedHintNoLink' => 'ستتم إعادة توجيه الزائرين باستخدام الرمز 503 HTTP الذي يستخدمه محرك البحث إلى صفحة مخصصة لمستند الخطأ، على الرغم من استمرار استضافة موقع الويب على الخادم. ستظل خدمة البريد متوفرة.',
    'web.change-status.error503PageLink' => 'تحرير مستند الخطأ المخصص',
    'web.change-status.statusActiveHint' => 'سيعمل موقع الويب كالمعتاد.',
    'web.change-status.notActivatedSuspended' => 'لا يمكن تنشيط المجال أو موقع الويب %%domainName%% لأنه تم تجميده من قِبل موفر خدمة الاستضافة.',
    'web.change-status.notActivatedDisabled' => 'لا يمكن تنشيط المجال أو موقع الويب %%domainName%% لأنه معطل من قِبل موفر خدمة الاستضافة.',

    'web.edit.formTitle' => 'الوصول إلى استضافة الويب لـ %%name%%.',
    'web.edit.formGeneralHint' => 'فيما يلي يمكنك عرض عناوين IP المرتبطة باشتراكك، وتغيير اسم المستخدم وكلمة مرور مستخدم النظام الخاصة بك.',
    'web.edit.formGeneralHint_powerUser' => 'فيما يلي يمكنك عرض عناوين IP المرتبطة بمساحة الويب هذه، وتغيير اسم المستخدم وكلمة مرور مستخدم النظام الخاصة بك.',
    'web.edit.ipAddressesLegend' => 'عناوين IP',
    'web.edit.ipAddresses' => 'عناوين IP',
    'web.edit.certificateLegend' => 'الشهادة',
    'web.edit.certificateFromDomainRepository' => '(%%name%% (%%repositoryName%%',
    'web.edit.certificateFromOtherRepository' => '%%name%% (مملوك لمستخدم آخر)',
    'web.edit.userAccountLegend' => 'مستخدم النظام',
    'web.edit.systemUserHint' => 'فيما يلي يمكنك تحديد مستخدم لنظام التشغيل لإدارة الملفات والمجلدات ضِمن الاشتراك عن طريق FTP أو إدارة الملفات. كما يُستخدم مستخدم النظام أيضًا للوصول إلى Plesk عبر SSH (في نظام تشغيل Linux) أو RDP في نظام تشغيل Windows) في حالة منح الأذونات المقابلة.',
    'web.edit.systemUserHint_powerUser' => 'فيما يلي يمكنك تحديد مستخدم لنظام التشغيل لإدارة الملفات والمجلدات ضِمن مساحة الويب عن طريق FTP أو إدارة الملفات. كما يُستخدم مستخدم النظام أيضًا للوصول إلى Plesk عبر SSH (في نظام تشغيل Linux) أو RDP في نظام تشغيل Windows) في حالة منح الأذونات المقابلة.',
    'web.edit.login' => 'اسم المستخدم',
    'web.edit.emptyLogin' => 'يُرجى تحديد اسم مستخدم.',
    'web.edit.password' => 'كلمة المرور',
    'web.edit.passwordConfirmation' => 'تأكيد كلمة المرور',
    'web.edit.emptyPassword' => 'يُرجى تحديد كلمة مرور.',
    'web.edit.emptyPasswordConfirmation' => 'يُرجى تأكيد كلمة المرور.',
    'web.edit.shellUnix' => "الوصول إلى الخادم عبر SSH",
    'web.edit.shellHintUnix' => "الوصول إلى الخادم عبر SSH باستخدام بيانات تعريف مستخدم النظام.",
    'web.edit.shellWin' => 'الوصول إلى الخادم عبر سطح المكتب البعيد',
    'web.edit.shellHintWin' => "الوصول إلى الخادم عبر سطح المكتب البعيد باستخدام بيانات تعريف مستخدم النظام.",
    'web.edit.diskQuotaLegend' => 'حصة ثابتة في مساحة القرص',
    'web.edit.diskQuotaHint' => 'الحصة الثابتة في مساحة القرص هي الحد على كم مساحة القرص التي يمكن استخدامها. إذا تم تعيين الحصة الثابتة، وتم استخدام كل مساحة القرص المخصصة، فلن يكون من الممكن إجراء عمليات إضافية على الملفات.',
    'web.edit.diskQuota' => 'حصة ثابتة في مساحة القرص',
    'web.edit.diskQuotaUnlimited' => 'غير محدود',
    'web.edit.diskQuotaLimited' => '%%limit%%ميغابايت',
    'web.edit.diskQuotaNotSupported' => 'غير محدود. إن حصة القرص الثابت غير معتمدة بسبب تكوين نظام ملف الخادم.',
    'web.edit.limitMbUnits' => 'ميجابايت',
    'web.edit.successfullyUpdated' => 'تم تحديث إعدادات الاستضافة بنجاح.',
    'web.edit.affectedDomainsLegend' => 'مواقع الويب التي سيتم تطبيق هذه الإعدادات عليها',
    'web.edit.affectedDomainsHint' => 'ترتبط مواقع الويب التالية مع مستخدم النظام الحالي. سيتم تطبيق التغييرات في إعدادات الوصول إلى استضافة الويب التي تقوم بها على هذه الصفحة على جميع مواقع الويب.',

    'web.mobile.create.formTitle' => 'إنشاء موقع للهاتف المحمول',
    'web.mobile.create.formGeneralHint' => 'تحديد اسم لموقع الهاتف المحمول - وهو عنوان URL يمكن الوصول إلى موقع الهاتف المحمول من خلاله. وعادة، يتم استخدام بادئات مثل "m"، و"mob"، و"mobi"، و"mobile" وما إلى ذلك، على سبيل المثال: mobile.example.com. يمكنك استخدام عنوان URL هذا ثم في رابط مثل "إصدار الهاتف المحمول" على موقعك العادي، بحيث يتمكن زائرو موقعك من التبديل بين إصدارات الهاتف المحمول والإصدارات العادية.',
    'web.mobile.create.prefix' => 'اسم الموقع',
    'web.mobile.create.emptySiteName' => 'لا يمكن أن يكون اسم موقع الهاتف المحمول فارغًا، لأنه قد يتعارض مع موقعك العادي على الويب.',

    'web.security-section.securitySectionLegend' => 'الأمان',
    'web.security-section.securitySectionHint' => 'لتأمين التعاملات مع موقعك، استخدم بروتوكول SSL/TLS، الذي يشفر جميع البيانات وينقلها عبر اتصال آمن. لاستخدام SSL/TLS، انقل هذا الموقع إلى عنوان IP مخصص، وقم بتثبيت شهادة SSL/TLS في الموقع، ثم حددها أدناه.',
    'web.security-section.securitySectionSniHint' => 'لتأمين التعاملات مع موقعك، استخدم بروتوكول SSL/TLS، الذي يشفر جميع البيانات وينقلها عبر اتصال آمن. لاستخدام SSL/TLS، قم بتثبيت شهادة SSL/TLS في الموقع، ثم حددها أدناه.',
    'web.security-section.enableSslSupport' => 'دعم SSL/TLS',
    'web.security-section.enableSslRedirect' => 'إعادة التوجيه الدائم SEO-safe 301 من HTTP إلى HTTPS',

    'web.seo-settings.seoRedirectDirection' => 'المجال المفضل',
    'web.seo-settings.seoRedirectDirectionHint' => 'حدد عنوان URL (إما باستخدام البادئة .www أو بدونها) الذي سيتم توجيه زائري الموقع إليه عبر إعادة التوجيه HTTP 301 الآمن الخاص بـ SEO.',
    'web.seo-settings.seoRedirectDirectionNone' => 'بلا',

    'web.settings.formGeneralHint' => 'هنا حيث تُكوّن إعدادات استضافة مواقع الويب وتحدد الميزات المتوفرة لموقعك.',
    'web.settings.hostingType' => 'نوع الاستضافة',
    'web.settings.websiteHosting' => 'موقع ويب',
    'web.settings.forwardingHosting' => 'إعادة التوجيه',
    'web.settings.noHosting' => 'لا توجد استضافة',
    'web.settings.changeHosting' => 'تغيير',
    'web.settings.websiteStatus' => 'حالة موقع الويب',
    'web.settings.changeStatus' => 'تغيير',
    'web.settings.active' => 'نشط',
    'web.settings.suspended' => 'معلّق',
    'web.settings.disabled' => 'مُعطّل',
    'web.settings.webScriptingSectionLegend' => 'البرمجة النصية للويب والإحصائيات',
    'web.settings.webScriptingSectionHint' => 'حدد أي من لغات البرمجة والبرمجة النصية التالية يجب تطبيقها أو تنفيذها أو معالجتها عن طريق خادم الويب.',
    'web.settings.__asp_win_support' => 'دعم Microsoft ASP',
    'web.settings.__asp_dot_net_support' => 'دعم Microsoft ASP.NET',
    'web.settings.__asp_dot_net_version' => 'الإصدار',
    'web.settings.__asp_dot_net_version_readonly' => 'الإصدار %%value%%',
    'web.settings.__ssi_support' => 'دعم SSI',
    'web.settings.__ssi_with_html' => 'استخدام SSI لملفات .htm*، وhtml.*',
    'web.settings.__php_support' => 'دعم PHP',
    'web.settings.__php_run_as' => 'تشغيل PHP كـ',
    'web.settings.__php_served_by_apache' => 'متوفر من قِبل Apache',
    'web.settings.__php_served_by_nginx' => 'متوفر من قِبل nginx',
    'web.settings.__cgi_support' => 'دعم CGI',
    'web.settings.__cgi_bin_mode' => 'يوجد دليل cgi-bin في',
    'web.settings.__cgi_bin_mode_webspace' => 'دليل الجذر لمساحة الويب',
    'web.settings.__cgi_bin_mode_www_root' => 'جذر المستند لهذا المجال',
    'web.settings.__cgi_bin_mode_old_style' => 'الجذر من الطراز القديم لهذا المجال',
    'web.settings.__cgi_bin_mode_readonly' => 'يوجد دليل cgi-bin في %%value%%',
    'web.settings.__perl_unix_support' => 'دعم Perl',
    'web.settings.__perl_win_support' => 'دعم Perl',
    'web.settings.__python_unix_support' => 'دعم Python',
    'web.settings.__python_win_support' => 'دعم Python',
    'web.settings.__fastcgi_unix_support' => 'دعم FastCGI',
    'web.settings.__webstat_support' => 'إحصائيات الويب',
    'web.settings.__plesk_stat_protect' => 'حماية الوصول إلى إحصائيات الويب الخاصة بك باستخدام اسم مستخدم FTP وكلمة المرور الخاصة به',
    'web.settings.__plesk_stat_protected' => 'يتم حماية الوصول إلى إحصاءات الويب الخاص بك باستخدام اسم المستخدم وكلمة المرور الخاصة بك لبروتوكول نقل الملفات "FTP"',
    'web.settings.__apache_errdocs' => 'مستندات خطأ مخصصة',
    'web.settings.__php_module_handler' => 'mod_php',
    'web.settings.__php_fastcgi_handler' => 'تطبيق FastCGI',
    'web.settings.__php_cgi_handler' => 'تطبيق CGI',
    'web.settings.__php_isapi_handler' => 'امتداد ISAPI',
    'web.settings.__php_version' => 'إصدار PHP',
    'web.settings.__hosting_write_modify' => 'أذونات كتابة/تعديل إضافية',
    'web.settings.__hosting_webdeploy' => 'نشر Web Deploy',
    'web.settings.awstats' => 'AWStats',
    'web.settings.webalizer' => 'Webalizer',
    'web.settings.smarterstats' => 'SmarterStats',
    'web.settings.__none' => 'بلا',
    'web.settings.activate' => 'تنشيط',
    'web.settings.deactivate' => 'تعليق',
    'web.settings.__php_support_readonly' => 'الإصدار: %%version%%؛ المعالج: %%handler%%',
    'web.settings.__php_support_readonly_not_registered' => 'غير مسجل',
    'web.settings.domainName' => 'اسم المجال',
    'web.settings.domainNameHint' => "على سبيل المثال، example.com",
    'web.settings.sameSslCompatibilitySectionLegend' => 'وضع التوافق للخيار القديم "الفصل بين محتوى SSL/TLS وغير SSL/TLS"',
    'web.settings.sameSslCompatibilityModeCheckbox' => 'قم بتشغيل موقع الويب في وضع التوافق للخيار القديم "الفصل بين محتوى SSL/TLS وغير SSL/TLS"',
    'web.settings.sameSslCompatibilityHint' => 'أنت ترى هذا القسم لأنك استخدمت الخيار "الفصل بين محتوى SSL/TLS وغير SSL/TLS" قبل الترقية. تم تجاهل هذا الخيار في Plesk 11. تستخدم جميع مواقع الويب التي تم إنشاؤها في Plesk 11 الدليل نفسه لتخزين المحتوى المتوفر عبر اتصالات HTTP وHTTPS. ويعني هذا أن هذا الموقع سيستمر في العمل في وضع التوافق، ولكن سيتعذر عليك إدارته عبر Plesk. من المستحسن بشدة نقل جميع بياناتك من دليل httpsdocs/ إلى httpdocs/، وإيقاف تشغيل وضع التوافق بعد ذلك. بعد إيقاف تشغيل وضع التوافق، لن يكون بمقدورك تشغيله مرة أخرى، ولن يظهر هذا القسم مرة أخرى. لاحظ أنه إذا قمت بتثبيت تطبيقات في الدليل httpsdocs/ أثناء تشغيل وضع التوافق، فلن يمكن الوصول إلى التطبيقات عبر الإنترنت. إذا أردت تثبيت التطبيقات في httpsdocs/، فقم بإيقاف تشغيل وضع التوافق.',
    'web.settings.willBeAppliedAfterApacheRestartInterval' => 'سيتم تطبيق إعدادات موقع الويب خلال %%restartInterval%% دقيقة.',
    'web.settings.phpSettingsDescription' => 'تعرض هذه الصفحة تكوين PHP لموقع الويب. هذه الإعدادات تخص موقع الويب ولا تؤثر على مواقع ويب أخرى في الاشتراك. يمكنك تغيير تكوين PHP إذا كان موفر خدمة الاستضافة يمنحك الإذن المقابل. يمكن استخدام تكوين PHP المخصص، على سبيل المثال، لتحديد استهلاك موارد النظام من قِبل برامج PHP النصية، أو تلبية متطلبات تطبيق ويب معين. عند تعيين قيمة المعلمة إلى "Default" (افتراضي)، فإن PHP يستخدم قيمة المعلمة من تكوين PHP على مستوى الخادم.',
    'web.settings.phpSettingsAvailableVariables' => 'يمكن استخدام العناصر النائبة التالية في قيم المعلمة:',
    'web.settings.phpSettingsVariableDocroot' => '{DOCROOT} لدليل جذر المستند لموقع الويب. القيمة الحالية هي %%DOCROOT%%. %%HTTPS_DOCROOT%%',
    'web.settings.phpSettingsVariableDocrootHttpsSame' => 'إن دليل جذر مستند HTTPS هو نفسه بالنسبة إلى http.',
    'web.settings.phpSettingsVariableDocrootHttpsDifferent' => 'دليل جذر مستند HTTPS هو %%DOCROOT%%.',
    'web.settings.phpSettingsVariableWebspaceRoot' => '{WEBSPACEROOT} لدليل جذر المستند لموقع الويب الأساسي الخاص بالاشتراك.',
    'web.settings.phpSettingsVariableTmp' => '{TMP} للدليل الذي يخزن الملفات المؤقتة.',
    'web.settings.phpSettingsPhpVersion' => 'إصدار PHP الخاص بك هو %%version%%.',
    'web.settings.phpSettingsPhpDisabled' => 'PHP قيد إيقاف التشغيل.',
    'web.settings.phpHandlerTypeHint' => 'لاحظ أن تغيير نوع معالج PHP قد يعطل تشغيل برامج PHP النصية الموجودة على موقع الويب هذا.',
    'web.settings.fpmDedicatedHandlerHint' => 'يؤدي استخدام هذا المعالج إلى زيادة استقرار موقع الويب، ولكنه يتسبب أيضًا في مزيد من الاستهلاك للذاكرة.',
    'web.settings.phpHandlerChangeHint' => 'لقد قمت بتغيير إعدادات معالج PHP.  في حالة حفظ هذه التغييرات، فيمكن أن تتوقف البرامج النصية لـ PHP على موقعك الإلكتروني لمدة %%interval%% ثانية نظرًا لتهيئة الخادم الخاص بك.',
    'web.settings.phpHandlerTypeHelpLink' => 'تعرف على كيفية اختيار إعدادات PHP الأكثر ملاءمة',
    'web.settings.phpHandlerTypeNotAvailableHint' => 'يتعذر تمكين دعم PHP لنظرًا لأن تكوين الاستضافة الحالي لا يتضمن أي إصدارات PHP متاحة لهذا النطاق.',
    'web.settings.phpHandlerTypeNotAvailableHelpLink' => 'تعرف على كيفية تمكين إصدارات PHP الأخرى.',
    'web.settings.phpHandlerBroken' => 'إن معالج PHP المحدد حاليًا تالف. حدد معالجًا مختلفًا.',
    'web.settings.phpHandlerOutdated' => '(قديم)',
    'web.settings.phpHandlerDeprecated' => '(مهمل)',

    'web.setupService.formTitle' => 'إعداد الخدمة: %%serviceReference%%',
    'web.setupService.successfullyUpdated' => 'تم تحديث الخدمة \'\\%%serviceReference%%\'\\ بنجاح.',

    'web.site-copy.subdomainsGroup' => 'المجالات الفرعية لـ %%siteName%%:',
    'web.site-copy.destinationTypeSection' => 'نسخ الوجهة',
    'web.site-copy.destinationType' => 'حدد المكان الذي يجب نسخ ملفات الموقع فيه',
    'web.site-copy.destinationTypeSite' => 'موقع الويب في تطبيق Plesk',
    'web.site-copy.destinationTypeSiteDescription' => 'نسخ ملفات الموقع إلى موقع آخر تابع لك ومستضاف ضِمن هذا الحساب. إذا كنت تتمتع بإمكانية وصول FTP إلى حساب آخر على هذا الخادم، فاستخدم خيار مخزن FTP.',
    'web.site-copy.destinationTypeSiteDescription_powerUser' => 'نسخ ملفات الموقع إلى موقع مستضاف على هذا الخادم.',
    'web.site-copy.destinationTypeSiteSelect' => 'اسم الموقع',
    'web.site-copy.destinationSiteRootIsSubDirOfSourceRoot' => "لا يمكن نسخ ملفات الموقع %%source%% إلى %%destination%% لأن %%destination%% هي أيضًا جزء من الملفات - كما أن جذر المستند هو دليل فرعي من جذر المستند %%source%%.",
    'web.site-copy.unableToDeleteSourceRootIsSubdirOfDestinationRoot' => "لا يمكن إزالة ملفات الموقع %%destination%% لأن ملفات %%source%% هي جزء منه - كما أن جذر المستند %%source%% هو دليل فرعي لـ %%destination%%.",
    'web.site-copy.destinationTypeFtp' => 'مخزن FTP',
    'web.site-copy.destinationTypeFtpDescription' => 'نسخ ملفات موقع الويب إلى حساب FTP على هذا الخادم أو على خادم خارجي.',
    'web.site-copy.destinationTypeFtpDescription_powerUser' => 'نسخ ملفات موقع الويب إلى حساب FTP على خادم خارجي.',
    'web.site-copy.destinationTypeFtpHost' => "اسم مضيف الخادم",
    'web.site-copy.destinationTypeFtpPort' => "منفذ",
    'web.site-copy.destinationTypeFtpFolder' => 'دليل',
    'web.site-copy.destinationTypeFtpUser' => 'اسم المستخدم',
    'web.site-copy.destinationTypeFtpPassword' => 'كلمة المرور',
    'web.site-copy.destinationTypeFtpMode' => 'طريقة اتصال FTP',
    'web.site-copy.destinationTypeFtpModeActive' => 'الوضع النشط',
    'web.site-copy.destinationTypeFtpModeActiveDescription' => 'في الوضع النشط، يرسل تطبيق Plesk عنوان IP ورقم المنفذ الخاص به الذي سيتم تثبيته على خادم خارجي، ويبدأ الخادم اتصال TCP. يوصى بهذا الوضع عندما لا يكون خادم Plesk المُدار غير محمي بجدار حماية.',
    'web.site-copy.destinationTypeFtpModePassive' => 'الوضع السلبي',
    'web.site-copy.destinationTypeFtpModePassiveDescription' => 'يمكن استخدام الوضع السلبي عندما يكون خادم Plesk المُدار محميًا بجدار حماية ويتعذر الموافقة على اتصالات TCP الواردة.',
    'web.site-copy.existingFiles' => 'ما يجب فعله بالملفات التالية',
    'web.site-copy.existingFilesKeep' => 'الاحتفاظ بالملفات الموجودة على الموقع الوجهة',
    'web.site-copy.existingFilesKeepDescription' => 'الكتابة فوق الملفات الموجودة مع مطابقة الأسماء على الموقع الوجهة.',
    'web.site-copy.existingFilesDelete' => 'حذف جميع الملفات التالية',
    'web.site-copy.existingFilesDeleteDescription' => 'حذف جميع الملفات على الموقع الوجهة قبل النسخ.',
    'web.site-copy.emptyLogin' => 'حدد اسم مستخدم لحساب FTP.',
    'web.site-copy.emptyHost' => 'حدد اسم مضيف الخادم.',
    'web.site-copy.emptyPort' => 'حدد منفذًا لمضيف الخادم.',
    'web.site-copy.copyInProgress' => 'نسخ موقع ويب %%sourceName%% إلى %%destinationName%%. سيتم إعلامك بالتقدم عن طريق البريد الإلكتروني (%%email%%).',
    'web.site-copy.unableToCopy' => 'فشل نسخ ملفات موقع الويب.',
    'web.site-copy.siteCopied' => 'تم نسخ ملفات موقع الويب.',
    'web.site-copy.emailSubjSuccess' => 'تم نسخ ملفات موقع الويب "%%source%%".',
    'web.site-copy.emailSubjFailure' => 'فشل نسخ ملفات موقع الويب "%%source%%".',
    'web.site-copy.emailBodySuccess' => 'تم نسخ ملفات موقع الويب "%%source%%" إلى "%%destination%%".',
    'web.site-copy.emailBodyFailure' => 'فشل نسخ ملفات موقع الويب %%source%% إلى "%%destination%%": %%message%%',

    'web._shared.forwardingSettingsSectionLegend' => 'إعدادات إعادة التوجيه',
    'web._shared.forwardDestination' => 'عنوان الوجهة',
    'web._shared.forwardDestinationHint' => 'عنوان URL لموقع الويب المستهدف.',
    'web._shared.forwardingTypeOptions' => 'نوع إعادة التوجيه',
    'web._shared.forwardingFrame' => 'إعادة توجيه الإطار',
    'web._shared.forwardingFrameHint' => 'أعد توجيه زائري موقع الويب إلى موقع آخر، مع عدم إظهار عنوان الوجهة لهم، بحيث لا يشعرون بإعادة التوجيه.',
    'web._shared.forwardingHttpCode301' => 'تم النقل بشكل دائم (الرمز 301)',
    'web._shared.forwardingHttpCode301Hint' => 'أعد توجيه زائري موقع الويب إلى موقع آخر واعرض لهم عنوان الوجهة. ستحافظ إعادة التوجيه هذه على تصنيفات محرك البحث الخاصة بالموقع.',
    'web._shared.forwardingHttpCode302' => 'تم النقل بشكل مؤقت (الرمز 302)',
    'web._shared.forwardingHttpCode302Hint' => 'أعد توجيه زائري موقع الويب إلى نسخة موقع مؤقتة عندما لا ترغب في فهرسة محركات البحث لهذا الموقع المؤقت.',
    'web._shared.documentRoot' => 'جذر المستند',
    'web._shared.documentRootHint' => 'مسار الدليل الرئيسي لموقع الويب.',
    'web._shared.documentRootHintDisabledDueApplications' => 'لا يمكن تغيير جذر المستند لوجود تطبيقات ويب مُثبّتة على موقع الويب هذا.',
    'web._shared.ipAddress' => 'عنوان IP',
    'web._shared.shared' => 'مشترك',
    'web._shared.exclusive' => 'مخصص',
    'web._shared.ipAddressHint' => "عنوان IP الذي يتم استضافة موقع الويب عليه هو عنوان شبكة المضيف الظاهري لموقع الويب.",
    'web._shared.certificateFromDomainRepository' => '(%%name%% (%%repositoryName%%',
    'web._shared.certificateFromOtherRepository' => '%%name%% (مستودع آخر)',
    'web._shared.certificate' => 'الشهادة',
    'web._shared.sameCertificatesHint' => 'ستُستخدم الشهادة المحددة لجميع المواقع المستضافة على عنوان IP المخصص نفسه.',
    'web._shared.differentCertificatesHint' => 'يقترن هذا الاشتراك بعنواني IP مخصصين بشهادتين مختلفتين. ستحل الشهادة المحددة محل أي شهادات مُثبّتة على المواقع المستضافة على عنواني IP هذين.',
    'web._shared.differentIpTypesCertificateHint' => 'يقترن هذا الاشتراك مع عنوان IP مشترك وآخر مخصص. ستُستخدم الشهادة المحددة أيضًا لجميع المواقع الأخرى المستضافة على عنوان IP المخصص.',
    'web._shared.certificateNotSelected' => 'غير محدد',
    'web._shared.sslCertificatesRepositoryIsEmptyHint' => 'لا توجد شهادات SSL/TLS في المستودع لديك. لإضافة شهادة، انتقل إلى %%link%%.',
    'web._shared.sslCertificatesRepositoryLink' => 'هذه الصفحة',

    'web-user.settings.allowScripts' => 'السماح للمستخدمين باستخدام البرامج النصية',

    'web-user.name' => 'اسم المستخدم لربط الخادم عبر اتصال FTP',
    'web-user.longName' => 'اسم المستخدم هذا طويل جدًا (الحد الأقصى المسموح به من الرموز هو %max%).',
    'web-user.password' => 'كلمة المرور',
    'web-user.passwordConfirmation' => 'تأكيد كلمة المرور',
    'web-user.hardDiskQuota' => 'حصة القرص الثابت',
    'web-user.hardDiskQuotaUnlimited' => 'غير محدود',
    'web-user.hardDiskQuotaIsNotSupported' => '(حصة القرص الثابت غير معتمدة بسبب تكوين نظام ملف الخادم)',
    'web-user.megabytes' => 'ميغابايت',

    'requiredFields' => 'حقول إلزامية',
];