<?php
// Copyright 1999-2023. Plesk International GmbH. All rights reserved.
// This file contains structured and commented locale keys for Plesk 9.x

global $PROD_NAME;

$GLOBALS['lmsg_arr'] += [
    ////
    //// LOGIN SCREEN
    ////

    'login_up__access_denied_account_disabled' => "Acces interzis. Contul a fost suspendat.",
    'login_up__login_has_been_locked' => "Ați greșit parola de prea multe ori. Din considerente de securitate, o perioadă nu vă veți putea conecta cu acest nume de utilizator.",
    'login_up__unable_to_check_pass' => "Imposibil de verificat parola: %1",
    'login_up__warning_limits_licence_key' => "Unele dintre elementele de mai jos au depășit limita definită de cheia de licență: numărul de conturi de utilizator, de domenii, de conturi de e-mail sau de utilizatori web găzduite pe server.\nContactați departamentul de vânzări Plesk pentru a cumpăra o cheie care să vă permită să găzduiți numărul dorit de utilizatori și de domenii. În cazul în care considerați că ați primit acest mesaj din greșeală, contactați departamentul de asistență tehnică Plesk.\nLimita stabilită prin licență pentru numărul de conturi de utilizator/domenii/conturi de e-mail/utilizatori web/pachete lingvistice: %2.\nNumărul de conturi de utilizator/domenii/conturi de e-mail/utilizatori web/pachete lingvistice găzduite în prezent: %3.", // PFW
    'login_up__short_warning_limits_licence_key' => "Volumul de resurse cu care lucrați depășește limitele definite de licența de produs actuală. Contactați departamentul de vânzări Plesk și cumpărați o cheie de licență nouă.",
    'login_up__grace_period' => 'În acest moment sunteți în perioada de grație a licenței de produs. Pentru a actualiza licența de produs, selectați opțiunea Obținere chei din %1Pagina Informații despre licență%2.',
    'login_up__partner_license_message' => 'Utilizați o licență de produs limitată, care necesită înregistrare pentru a activa setul complet de caracteristici. Pentru a actualiza licența de produs, selectați opțiunea Obținere chei din %1Pagina Informații despre licență%2.',
    'login_up__system_admin_disabled' => 'Din considerente de securitate, superutilizatorul (contul root sau administrator) nu se poate conecta la Plesk.',

    ///
    /// Online help keys:
    ///

    'plesk_guide' => "Ghidul administratorului Plesk",
    'plesk_guide_reseller' => "Ghidul resellerului Plesk",
    'plesk_guide_client' => "Ghidul clientului Plesk",
    'plesk_guide_domain_admin' => "Ghidul administratorului de domeniu Plesk",
    'plesk_guide_mailuser' => "Ghidul utilizatorului de e-mail Plesk",

    ////
    //// COMMON KEYS FOR NAVIGATION THROUGHOUT PANEL
    ////

    ///
    /// NAVIGATION PANE
    ///

    'bt_search' => 'Căutare', // multiple usage: TBI
    'ui__client_unknown__quick-search' => 'Clienți',
    'ui__reseller_unknown__quick-search' => 'Reselleri',
    'ui__client/domain_unknown__quick-search' => 'Domenii',
    'nav__general' => 'Meniu principal',
    '__home' => 'Pagina de pornire',
    '__resellers' => 'Reselleri',
    '__clients' => 'Clienți',
    '__domains' => 'Domenii',
    '__applications' => 'Aplicații',
    '__settings' => 'Setări',
    'nav__system' => 'Sistem',
    '__master' => 'Principal',

    ///
    /// END OF NAVIGATION PANE
    ///

    ///
    /// NAVIGATION KEYS
    ///

    // up level
    'bt_up_level' => 'Nivel superior',

    // object switcher

    ///
    /// END OF NAVIGATION KEYS
    ///

    ///
    /// LISTS
    ///

    // common operations on list objects
    'bt_remove_selected' => 'Ștergere',
    'bt_make_default' => 'Setare ca implicit',

    // common list object operation errors
    'class_cList__empty_selection' => 'Niciun obiect selectat.',

    // common list object search keys
    'clist__search_show' => 'Afișare căutare',
    'clist__search_hide' => 'Ascundere căutare',

    'bt_show_all' => "Resetare căutare",

    // common object list info keys
    'clist__first' => 'Prima',
    'clist__last' => 'Ultima',
    'clist__prev' => '&lt;&lt;',
    'clist__next' => '&gt;&gt;',
    'clist__page' => 'Pagini',
    'clist__page_size' => 'Intrări pe pagină',
    'clist__info' => 'Nr. total de %1: %4',
    'clist__info_empty' => 'Listă de %1 goală',
    'clist__info_filter' => '%5 %1 găsite (total %4)',
    'clist__info_paging' => '%2-%3 %1 din %4 în total',
    'clist__info_paging_filter' => '%2-%3 %1 din %5 găsite (total %4)',

    ///
    /// END OF LISTS
    ///

    ////
    //// KEYS FOR USER HOME PAGES
    ////

    ///
    /// COMMON HOME PAGE KEYS
    ///

    // business object controls
    '__object_on' => 'Activ',
    '__object_off' => 'Suspendat',

    '__home_description' => 'Revenire la pagina de pornire.',
    'indicator_title' => '%1% utilizat, %2% disponibil', // tooltip for visual stats area

    ///
    /// END OF COMMON HOME PAGE KEYS
    ///

    ///
    /// SERVER ADMINISTRATOR
    ///

    '__invalid_url_requested' => 'S-a solicitat un URL incorect.',

    // accounts
    // icons
    'ui__reseller_unknown__short-title' => "Conturi de reseller",
    'ui__reseller_unknown__title' => "Conturi de reseller",
    'ui__reseller_unknown__description' => "Administrarea conturilor de reseller.",
    'ui__reseller/client_unknown__short-title' => 'Conturi de client',
    'ui__reseller/client_unknown__title' => 'Conturi de client',
    'ui__reseller/client_unknown__description' => 'Administrarea conturilor de client.',
    // dropdowns
    'ui__admin-alias_unknown__title' => "Conturi de administratori suplimentare", // PFW
    'ui__admin-alias_unknown__short-title' => "Conturi de administratori suplimentare", // PFW
    'ui__admin-alias_unknown__description' => "Vizualizați și administrați conturi de administrator suplimentare.", // PFW

    // server
    // icons
    'ui__server/mail__short-title' => "Setări server de e-mail",
    'ui__server/mail__title' => "Setări server de e-mail",
    'ui__server/mail__description' => "Configurarea serverului de e-mail și a setărilor de e-mail la nivel de server.",
    'ui__server/dns__short-title' => 'Setări DNS',
    'ui__server/dns__title' => 'Setări DNS',
    'ui__server/dns__description' => 'Verificarea și actualizarea setărilor DNS la nivel de server.',
    'ui__server/services__title' => 'Administrare servicii',
    'ui__server/services__description' => 'Pornirea, oprirea sau repornirea serviciilor Plesk.',
    'ui__server/crontab/task_unknown__short-title' => 'Sarcini programate',
    'ui__server/crontab/task_unknown__title' => 'Sarcini programate',
    'ui__server/crontab/task_unknown__description' => 'Adăugarea sau ștergerea sarcinilor programate la nivel de server.',
    'ui__server/ip-address_unknown__short-title' => 'Adrese IP',
    'ui__server/ip-address_unknown__title' => 'Adrese IP',
    'ui__server/ip-address_unknown__description' => 'Vizualizarea, adăugarea și ștergerea adreselor IP, atribuirea adreselor IP către reselleri.',
    // dropdowns
    'ui__server/time__title' => 'Ora sistemului',
    'ui__server/time__short-title' => 'Ora sistemului',
    'ui__server/time__description' => 'Modificarea orei și a datei sistemului, configurarea sincronizării cu un server NTP.',
    'ui__server/odbc__title' => 'Surse de date ODBC', // PFW
    'ui__server/odbc/dsn/properties__title' => 'Configurarea unei conexiuni ODBC',
    'ui__server/odbc/dsn/properties_unknown-new__title' => 'Adăugare DSN ODBC',
    'ui__server/odbc__short-title' => 'Surse de date ODBC', // PFW
    'ui__server/odbc__description' => 'Configurarea surselor de date ODBC.', // PFW
    'ui__server/maillists__title' => 'Configurarea serverului de liste de e-mail', // PFU
    'ui__server/maillists__short-title' => 'Configurarea serverului de liste de e-mail', // PFU
    'ui__server/maillists__description' => 'Configurarea serverului de liste de e-mail Mailman.', // PFU
    'ui__mass-email__short-title' => "Mesaje de e-mail în masă", // PFW
    'ui__mass-email__title' => "Mesaje de e-mail în masă", // PFW
    'ui__mass-email__description' => "Trimiterea mesajelor de e-mail către mai mulți destinatari în același timp.", // PFW
    'ui__mass-mail__title' => 'Mesaje de e-mail în masă', // PFU
    'ui__mass-mail__short-title' => 'Mesaje de e-mail în masă', // PFU
    'ui__mass-mail__description' => 'Trimiterea mesajelor de e-mail către mai mulți destinatari în același timp.', // PFU
    'ui__server/spam-filter__title' => 'Setări filtru antispam',
    'ui__server/spam-filter__short-title' => 'Setări filtru antispam',
    'ui__server/spam-filter__description' => 'Configurarea filtrului antispam la nivel de server.',
    'ui__server/preferences__title' => "Setări de server",
    'ui__server/preferences__short-title' => "Setări de server",
    'ui__server/preferences__description' => "Configurarea statisticilor la nivel de server, modificarea numelui de gazdă al serverului și modificarea altor setări de server.",

    // help & support
    // icons
    'ui__support__short-title' => 'Asistență',
    'ui__support__title' => 'Asistență',
    'ui__support__description' => 'Înregistrarea unei solicitări adresare asistenței tehnice sau consultarea tichetelor de suport create de clienții dvs.',
    'ui__license__short-title' => 'Informații despre licență',
    'ui__license__title' => 'Informații despre licența Plesk',
    'ui__license__description' => 'Vizualizarea informațiilor despre licența Plesk și plasarea comenzii pentru chei de licență noi.',
    'ui__help__short-title' => 'Ajutor',
    'ui__help__title' => 'Ajutor online',
    'ui__help__description' => 'Vizualizarea ajutorului online.',
    'ui__news__short-title' => "Noutăți",
    'ui__news__title' => "Noutăți",
    'ui__news__description' => "Afișarea listei schimbărilor din această versiune de Plesk.",
    'ui__server/autoinstaller__short-title' => 'Actualizări',
    'ui__server/autoinstaller__title' => 'Actualizări',
    'ui__server/autoinstaller__description' => 'Actualizarea Plesk și a componentelor sale.',
    // dropdowns

    // domains
    // icons
    'ui__client/domain_unknown__short-title' => 'Domenii',
    'ui__client/domain_unknown__title' => 'Domenii',
    'ui__client/domain_unknown__description' => 'Administrarea domeniilor.',
    'ui__server/skeleton__short-title' => 'Șablon de gazdă virtuală',
    'ui__server/skeleton__title' => 'Șablon de gazdă virtuală',
    'ui__server/skeleton__description' => 'Specificarea fișierelor și a directoarelor care trebuie amplasate în directoarele domeniilor nou create.',
    // dropdowns
    'ui__client/domain/chowner_multi-select__title' => 'Atribuirea unui nou proprietar abonamentelor',
    'ui__client/domain/chowner_multi-select__short-title' => 'Atribuirea unui nou proprietar de abonament',
    'ui__client/domain/chowner_multi-select__description' => 'Atribuirea unui nou proprietar abonamentelor selectate',
    'ui__client/domain/disable_multi__title' => 'Suspendare domenii',
    'ui__client/domain/disable_multi__short-title' => 'Suspendare domenii',
    'ui__client/domain/disable_multi__description' => 'Suspendarea domeniilor selectate',
    'ui__client/domain/enable_multi__title' => 'Activare domenii',
    'ui__client/domain/enable_multi__short-title' => 'Activare domenii',
    'ui__client/domain/enable_multi__description' => 'Activarea domeniilor selectate',

    // icons
    'ui__admin/extras-domain__short-title' => 'Instrumente de la MyPlesk.com',
    'ui__admin/extras-domain__title' => 'Instrumente de la MyPlesk.com',
    'ui__admin/extras-domain__description' => 'Cumpărați instrumente și servicii suplimentare de la MyPlesk.com.',
    'ui__server/aspdotnet__short-title' => 'Setări ASP.NET', // PFW
    'ui__server/aspdotnet__title' => 'Setări ASP.NET', // PFW
    'ui__server/aspdotnet__description' => 'Configurarea setărilor ASP.NET la nivel de server.', // PFW
    'ui__server/sitebuilder__short-title' => 'Setări Presence Builder', // PFU
    'ui__server/sitebuilder__title' => 'Setări Presence Builder', // PFU
    'ui__server/sitebuilder__description' => 'Configurarea Presence Builder pentru editarea site-urilor găzduite pe acest server.', // PFU
    // dropdowns
    'ui__admin/register-domain__title' => 'Înregistrare domeniu',
    'ui__admin/register-domain__short-title' => 'Înregistrare domeniu',
    'ui__admin/register-domain__description' => 'Înregistrarea unui nume de domeniu prin MyPlesk.com.',
    'ui__admin/manage-domain__title' => 'Administrare domeniu',
    'ui__admin/manage-domain__short-title' => 'Administrare domeniu',
    'ui__admin/manage-domain__description' => 'Administrarea numelor de domenii înregistrate prin MyPlesk.com.',
    'ui__server/register__title' => 'Înregistrarea serverului',
    'ui__server/register__short-title' => 'Înregistrare server',
    'ui__server/register__description' => 'Înregistrați-vă serverul pentru a vă alătura programului de afiliere',

    // logs & statistics
    // icons
    'ui__actionlog__short-title' => 'Jurnal de acțiuni',
    'ui__actionlog__title' => 'Jurnal de acțiuni',
    'ui__actionlog__description' => 'Descărcarea jurnalului de acțiuni și administrarea setărilor jurnalului de acțiuni.',
    // dropdowns
    'ui__server/statistics__short-title' => 'Informații server',
    'ui__server/statistics__title' => 'Informații server',
    'ui__server/statistics__description' => 'Statistici despre serviciile administrate de Plesk.',
    'ui__admin/report__title' => 'Raport rezumat',
    'ui__admin/report__short-title' => 'Raport rezumat',
    'ui__admin/report__description' => 'Vizualizarea raportului de utilizare a traficului și a resurselor de către reselleri, clienți și domenii.',

    // security
    // icons
    'ui__sessions/properties__short-title' => 'Timp de inactivitate sesiune',
    'ui__sessions/properties__title' => 'Timp de inactivitate sesiune',
    'ui__sessions/properties__description' => 'Configurarea timpului de inactivitate pentru sesiunile Plesk.',
    'ui__cp-access__short-title' => 'Acces la Plesk',
    'ui__cp-access__title' => 'Acces la Plesk',
    'ui__cp-access__description' => 'Restricționarea accesului la Plesk.',
    'ui__sessions__short-title' => 'Sesiuni active',
    'ui__sessions__title' => 'Sesiuni active',
    'ui__sessions__description' => 'Vizualizarea sesiunilor Plesk active.',
    // dropdowns
    'ui__server/certificate_unknown__title' => 'Certificate SSL/TLS',
    'ui__server/certificate_unknown__short-title' => 'Certificate SSL/TLS',
    'ui__server/certificate_unknown__description' => 'Lista certificatelor SSL/TLS.',

    // account
    // icons
    'ui__admin-info__short-title' => 'Date personale',
    'ui__admin-info__title' => 'Date personale',
    'ui__admin-info__description' => 'Modificarea datelor personale din contul dvs.',
    'ui__admin-password__short-title' => 'Schimbare parolă',
    'ui__admin-password__title' => 'Schimbare parolă',
    'ui__admin-password__description' => 'Schimbarea parolei contului.',
    // dropdowns

    ///
    /// END OF SERVER ADMINISTRATOR
    ///

    ///
    /// RESELLER
    ///

    // business objects

    // files
    // icons
    'ui__client/domain/hosting/file-manager_unknown__short-title' => 'Manager de fișiere',
    'ui__client/domain/hosting/file-manager_unknown__title' => 'Manager de fișiere',
    'ui__client/domain/hosting/file-manager_unknown__description' => 'Administrarea fișierelor și a directoarelor prin managerul de fișiere.',
    'ui__client/domain/hosting/ssh-terminal_unknown__short-title' => 'Terminal SSH', // PFU
    'ui__client/domain/hosting/ssh-terminal_unknown__title' => 'Terminal SSH', // PFU
    'ui__client/domain/hosting/ssh-terminal_unknown__description' => 'Accesarea serverului cu terminal SSH.', // PFU
    'ui__client/domain/hosting/protected-directories_unknown__short-title' => 'Directoare protejate prin parolă',
    'ui__client/domain/hosting/protected-directories_unknown__title' => 'Directoare protejate prin parolă',
    'ui__client/domain/hosting/protected-directories_unknown__description' => 'Protejarea accesului la anumite zone ale site-ului.',
    'ui__client/domain/hosting/web-directories_unknown__title' => 'Directoare virtuale', // PFW
    'ui__client/domain/hosting/web-directories_unknown__short-title' => 'Directoare virtuale', // PFW
    'ui__client/domain/hosting/web-directories_unknown__description' => 'Lucrul cu fișiere și directoare fizice și virtuale din site-ul dvs.', // PFW

    // statistics
    // icons
    'ui__reseller/limits__short-title' => 'Utilizare resurse',
    'ui__reseller/limits__title' => 'Utilizare resurse',
    'ui__reseller/limits__description' => 'Vizualizarea și administrarea utilizării resurselor de către resellerul %1.',
    'ui__reseller/limits_unknown__short-title' => 'Utilizare resurse',
    'ui__reseller/limits_unknown__title' => 'Utilizare resurse',
    'ui__reseller/limits_unknown__description' => 'Vizualizarea și modificarea utilizării resurselor de către un reseller.',
    'ui__reseller/limits_self__short-title' => 'Utilizare resurse',
    'ui__reseller/limits_self__title' => 'Utilizare resurse',
    'ui__reseller/limits_self__description' => "Vizualizarea și administrarea utilizării resurselor.",
    'ui__reseller/limits_readonly-self__short-title' => 'Utilizare resurse',
    'ui__reseller/limits_readonly-self__title' => 'Utilizare resurse',
    'ui__reseller/limits_readonly-self__description' => "Vizualizarea resurselor pe care le-ați utilizat.",
    'ui__reseller/client/traffic_unknown__short-title' => 'Utilizarea traficului pe clienți',
    'ui__reseller/client/traffic_unknown__title' => 'Vizualizarea utilizării traficului pe clienți',
    'ui__reseller/client/traffic_unknown__description' => 'Vizualizarea rapoartelor de utilizare a traficului pentru conturile de client.',
    'ui__client/traffic_unknown__short-title' => "Utilizarea traficului pe clienți", // temporary for presets
    'ui__client/traffic_unknown__title' => "Vizualizarea utilizării traficului pe clienți", // temporary for presets
    'ui__client/traffic_unknown__description' => "Vizualizarea rapoartelor de utilizare a traficului pentru conturile de client.", //  temporary for presets
    'ui__client/domain/hosting/logs_unknown__short-title' => 'Manager de jurnale',
    'ui__client/domain/hosting/logs_unknown__title' => 'Manager de jurnale',
    'ui__client/domain/hosting/logs_unknown__description' => 'Vizualizarea jurnalelor și configurarea rotației fișierelor de jurnal.',
    // dropdowns
    'ui__reseller/report__title' => 'Raport rezumat',
    'ui__reseller/report__short-title' => 'Raport rezumat',
    'ui__reseller/report__description' => 'Vizualizarea utilizării traficului și a resurselor de acest reseller.',
    'ui__reseller/report_unknown__title' => 'Raport rezumat',
    'ui__reseller/report_unknown__short-title' => 'Raport rezumat',
    'ui__reseller/report_unknown__description' => 'Vizualizarea raportului de utilizare a traficului și a resurselor pentru reseller.',
    'ui__reseller/report_self__title' => 'Raport rezumat',
    'ui__reseller/report_self__short-title' => 'Raport rezumat',
    'ui__reseller/report_self__description' => 'Vizualizarea raportului privind utilizarea traficului și a resurselor de către dvs.',

    // account
    // icons
    'ui__client/logo_reseller__title' => 'Branding de sistem Plesk',
    'ui__client/logo_reseller__short-title' => 'Branding de sistem Plesk',
    'ui__client/logo_reseller__description' => 'Rebranding de sistem Plesk pentru resellerul %1.',
    'ui__client/logo_unknown__title' => 'Branding de sistem Plesk', // temporary for presets
    'ui__client/logo_unknown__short-title' => 'Branding de sistem Plesk', // temporary for presets
    'ui__client/logo_unknown__description' => 'Rebranding de sistem Plesk.', // temporary for presets
    'ui__client/logo_self-reseller__title' => 'Branding de sistem Plesk',
    'ui__client/logo_self-reseller__short-title' => 'Branding de sistem Plesk',
    'ui__client/logo_self-reseller__description' => 'Rebranding de sistem Plesk.',
    'ui__reseller/permissions__title' => 'Permisiuni',
    'ui__reseller/permissions__short-title' => 'Permisiuni',
    'ui__reseller/permissions__description' => "Vizualizarea sau modificarea acțiunilor pe care resellerul %1 le poate executa în Plesk.",
    'ui__reseller/permissions_unknown__short-title' => 'Permisiuni',
    'ui__reseller/permissions_unknown__title' => 'Permisiuni',
    'ui__reseller/permissions_unknown__description' => "Vizualizarea sau modificarea acțiunilor pe care resellerul le poate executa în Plesk.",
    'ui__reseller/permissions_self__title' => 'Permisiuni',
    'ui__reseller/permissions_self__short-title' => 'Permisiuni',
    'ui__reseller/permissions_self__description' => 'Vizualizarea listei acțiunilor pe care le puteți executa în Plesk.',
    'ui__reseller/permissions_readonly-self__title' => 'Permisiuni',
    'ui__reseller/permissions_readonly-self__short-title' => 'Permisiuni',
    'ui__reseller/permissions_readonly-self__description' => 'Vizualizarea listei acțiunilor pe care le puteți executa în Plesk.',

    // domains
    // icons
    // Domains - see SERVER ADMINISTRATOR/DOMAINS
    // Domain Templates - see SERVER ADMINISTRATOR/DOMAINS
    'ui__client/skeleton__title' => 'Șablon de gazdă virtuală',
    'ui__client/skeleton__short-title' => 'Șablon de gazdă virtuală',
    'ui__client/skeleton__description' => 'Specificarea fișierelor și a directoarelor care trebuie amplasate în directoarele domeniilor nou create.',
    'ui__client/skeleton_unknown__short-title' => 'Șablon de gazdă virtuală',
    'ui__client/skeleton_unknown__title' => 'Șablon de gazdă virtuală',
    'ui__client/skeleton_unknown__description' => 'Specificarea fișierelor și a directoarelor care trebuie amplasate în directoarele domeniilor nou create.',

    // website
    // icons
    'ui__client/domain/domain-alias_unknown__short-title' => 'Aliasuri de domeniu',
    'ui__client/domain/domain-alias_unknown__title' => 'Aliasuri de domeniu',
    'ui__client/domain/domain-alias_unknown__description' => 'Vizualizarea listei numelor alternative pentru domeniul dvs.',
    //dropdowns
    'ui__client/domain/dns_unknown__title' => 'Setări DNS',
    'ui__client/domain/dns_unknown__short-title' => 'Setări DNS',
    'ui__client/domain/dns_unknown__description' => 'Administrarea setărilor zonei DNS pentru un domeniu.',
    'ui__client/domain/dns_readonly-unknown__title' => 'Setări DNS',
    'ui__client/domain/dns_readonly-unknown__short-title' => 'Setări DNS',
    'ui__client/domain/dns_readonly-unknown__description' => 'Vizualizarea setărilor zonei DNS pentru un domeniu.',

    // applications & services
    // icons
    'ui__reseller/extras-domain__short-title' => 'Instrumente de la MyPlesk.com',
    'ui__reseller/extras-domain__title' => 'Instrumente de la MyPlesk.com',
    'ui__reseller/extras-domain__description' => 'Cumpărați instrumente și servicii suplimentare de la MyPlesk.com.',
    'ui__reseller/extras-domain_unknown__short-title' => 'Instrumente de la MyPlesk.com',
    'ui__reseller/extras-domain_unknown__title' => 'Instrumente de la MyPlesk.com',
    'ui__reseller/extras-domain_unknown__description' => 'Cumpărați instrumente și servicii suplimentare de la MyPlesk.com.',
    'ui__reseller/extras-domain_self__short-title' => 'Instrumente de la MyPlesk.com',
    'ui__reseller/extras-domain_self__title' => 'Instrumente de la MyPlesk.com',
    'ui__reseller/extras-domain_self__description' => 'Cumpărați instrumente și servicii suplimentare de la MyPlesk.com.',
    'ui__client/domain/odbc_unknown__short-title' => 'Surse de date ODBC', // PFW
    'ui__client/domain/odbc_unknown__title' => 'Surse de date ODBC', // PFW
    'ui__client/domain/odbc_unknown__description' => 'Configurarea surselor de date ODBC pentru un domeniu.', // PFW
    'ui__reseller/register-domain__short-title' => 'Înregistrare domeniu',
    'ui__reseller/register-domain__title' => 'Înregistrare domeniu',
    'ui__reseller/register-domain__description' => 'Înregistrarea unui nume de domeniu prin MyPlesk.com.',
    'ui__reseller/register-domain_unknown__short-title' => 'Înregistrare domeniu',
    'ui__reseller/register-domain_unknown__title' => 'Înregistrare domeniu',
    'ui__reseller/register-domain_unknown__description' => 'Înregistrarea unui nume de domeniu prin MyPlesk.com.',
    'ui__reseller/register-domain_self__short-title' => 'Înregistrare domeniu',
    'ui__reseller/register-domain_self__title' => 'Înregistrare domeniu',
    'ui__reseller/register-domain_self__description' => 'Înregistrarea unui nume de domeniu prin MyPlesk.com.',
    // dropdowns
    'ui__reseller/manage-domain__title' => 'Administrare domeniu',
    'ui__reseller/manage-domain__short-title' => 'Administrare domeniu',
    'ui__reseller/manage-domain__description' => 'Administrarea numelor de domenii înregistrate prin MyPlesk.com.',
    'ui__reseller/manage-domain_unknown__title' => 'Administrare domeniu',
    'ui__reseller/manage-domain_unknown__short-title' => 'Administrare domeniu',
    'ui__reseller/manage-domain_unknown__description' => 'Administrarea numelor de domenii înregistrate prin MyPlesk.com.',
    'ui__reseller/manage-domain_self__title' => 'Administrare domeniu',
    'ui__reseller/manage-domain_self__short-title' => 'Administrare domeniu',
    'ui__reseller/manage-domain_self__description' => 'Administrarea numelor de domenii înregistrate prin MyPlesk.com.',

    // additional tools
    // icons
    'ui__client/ipaddress_unknown-reseller__title' => 'Adrese IP',
    'ui__client/ipaddress_unknown-reseller__short-title' => 'Adrese IP',
    'ui__client/ipaddress_unknown-reseller__description' => 'Administrarea adreselor IP.',
    'ui__client/domain/certificate_unknown__short-title' => 'Certificate SSL/TLS',
    'ui__client/domain/certificate_unknown__title' => 'Certificate SSL/TLS',
    'ui__client/domain/certificate_unknown__description' => 'Instalarea și administrarea certificatelor SSL/TLS.',
    'ui__client/domain/hosting/hotlink-protection_unknown__short-title' => 'Protecție hotlink', // PFW
    'ui__client/domain/hosting/hotlink-protection_unknown__title' => 'Protecție hotlink', // PFW
    'ui__client/domain/hosting/hotlink-protection_unknown__description' => 'Protejarea fișierelor împotriva practicilor de hotlinking.', // PFW
    'ui__reseller/sessions__short-title' => 'Sesiuni active',
    'ui__reseller/sessions__title' => 'Sesiuni active',
    'ui__reseller/sessions__description' => 'Vizualizarea sesiunilor Plesk active.',
    'ui__reseller/sessions_unknown__short-title' => 'Sesiuni active',
    'ui__reseller/sessions_unknown__title' => 'Sesiuni active',
    'ui__reseller/sessions_unknown__description' => 'Vizualizarea sesiunilor Plesk active.',
    'ui__reseller/sessions_self__short-title' => 'Sesiuni active',
    'ui__reseller/sessions_self__title' => 'Sesiuni active',
    'ui__reseller/sessions_self__description' => 'Vizualizarea sesiunilor Plesk active.',
    'ui__client/domain/hosting/performance_unknown__short-title' => 'Limitare lățime de bandă',
    'ui__client/domain/hosting/performance_unknown__title' => 'Limitare lățime de bandă',
    'ui__client/domain/hosting/performance_unknown__description' => 'Vizualizarea și reglarea limitei de utilizare a lățimii de bandă și a numărului de conexiuni simultane la un site web.',
    'ui__client/domain/hosting/performance_readonly-unknown__short-title' => 'Limitare lățime de bandă',
    'ui__client/domain/hosting/performance_readonly-unknown__title' => 'Limitare lățime de bandă',
    'ui__client/domain/hosting/performance_readonly-unknown__description' => 'Vizualizarea limitei de utilizare a lățimii de bandă și a numărului de conexiuni simultane la un site web.',

    ///
    /// END OF RESELLER
    ///

    ///
    /// CLIENT
    ///

    // business objects
    'mn_list__mail_names_for_client' => 'Contul de e-mail pentru contul de utilizator %1',

    // domains
    // icons
    // Domains - SERVER ADMINISTRATOR/DOMAINS
    // Domain Templates - SERVER ADMINISTRATOR/DOMAINS
    // Virtual host template - RESELLER/DOMAINS
    'ui__client/skeleton_self__short-title' => 'Șablon de gazdă virtuală',
    'ui__client/skeleton_self__title' => 'Șablon de gazdă virtuală',
    'ui__client/skeleton_self__description' => 'Specificarea fișierelor și a directoarelor care trebuie amplasate în directoarele domeniilor nou create.',
    // dropdowns
    // Create domain - see RESELLER/DOMAINS
    // Create domain template - see RESELLER/DOMAINS
    // Assign new owner for domains - see SERVER ADMINISTRATOR/DOMAINS
    // Convert Domain Administrator Accounts to Client Accounts - see SERVER ADMINISTRATOR/DOMAINS
    // Update Properties of Multiple Domains - see SERVER ADMINISTRATOR/DOMAINS

    // Suspend domains - see SERVER ADMINISTRATOR/DOMAINS
    // Activate domains - see SERVER ADMINISTRATOR/DOMAINS

    // mail
    // icons
    // Mail accounts - RESELLER/MAIL
    // Create mail account - RESELLER/MAIL
    // Create forwarder - RESELLER/MAIL
    // Create autoresponder - RESELLER/MAIL
    // Mailing lists - RESELLER/MAIL
    // Virus protection - RESELLER/MAIL
    // Spam filtering - RESELLER/MAIL
    // Open Webmail - RESELLER/MAIL
    // dropdowns
    // Mail settings - RESELLER/MAIL
    //Create mailing list - RESELLER/MAIL

    // files
    // icons
    // File manager - RESELLER/FILES
    // Anonymous FTP - RESELLER/FILES
    // FTP accounts - RESELLER/FILES    // PFW
    // SSH terminal - RESELLER/FILES    // PFU
    // Password protected directories - RESELLER/FILES
    // Virtual directories - RESELLER/FILES    // PFW
    // Web directories - RESELLER/FILES    // PFW

    // statistics
    // icons
    // Web statistics - RESELLER/STATISTICS
    'ui__client/limits__short-title' => 'Utilizare resurse',
    'ui__client/limits__title' => 'Utilizare resurse',
    'ui__client/limits__description' => "Vizualizarea și administrarea utilizării resurselor de către clientul %1.",
    'ui__client/limits_unknown__short-title' => 'Utilizare resurse',
    'ui__client/limits_unknown__title' => 'Utilizare resurse',
    'ui__client/limits_unknown__description' => 'Vizualizarea și administrarea utilizării resurselor de către un client.',
    'ui__client/limits_readonly__short-title' => 'Utilizare resurse',
    'ui__client/limits_readonly__title' => 'Utilizare resurse',
    'ui__client/limits_readonly__description' => 'Vizualizarea utilizării resurselor de către clientul %1.',
    'ui__client/limits_self__short-title' => 'Utilizare resurse',
    'ui__client/limits_self__title' => 'Utilizare resurse',
    'ui__client/limits_self__description' => "Vizualizarea și administrarea utilizării resurselor.",
    'ui__client/limits_readonly-self__short-title' => 'Utilizare resurse',
    'ui__client/limits_readonly-self__title' => 'Utilizare resurse',
    'ui__client/limits_readonly-self__description' => "Vizualizarea resurselor pe care le-ați utilizat.",
    'ui__client/domain/traffic_unknown__short-title' => "Utilizarea traficului pe domenii %1",
    'ui__client/domain/traffic_unknown__title' => "Vizualizarea utilizării traficului pe domenii",
    'ui__client/domain/traffic_unknown__description' => "Vizualizarea raportului de utilizare a traficului din domeniile dvs.",
    // Log manager - RESELLER/STATISTICS
    // dropdowns
    'ui__client/report__title' => 'Raport rezumat',
    'ui__client/report__short-title' => 'Raport rezumat',
    'ui__client/report__description' => 'Vizualizarea raportului utilizării traficului și a resurselor de către acest client.',
    'ui__client/report_unknown__short-title' => 'Raport rezumat',
    'ui__client/report_unknown__title' => 'Raport rezumat',
    'ui__client/report_unknown__description' => 'Vizualizarea raportului de utilizare a traficului și a resurselor de către client.',
    'ui__client/report_self__short-title' => 'Raport rezumat',
    'ui__client/report_self__title' => 'Raport rezumat',
    'ui__client/report_self__description' => 'Vizualizarea raportului de utilizare a traficului și a resurselor.',

    // account
    // icons
    'ui__client/preferences__short-title' => 'Preferințe de interfață',
    'ui__client/preferences__title' => 'Preferințe de interfață',
    'ui__client/preferences__description' => 'Configurarea preferințelor de interfață Plesk pentru clientul %1.',
    'ui__client/preferences_unknown__short-title' => 'Preferințe de interfață',
    'ui__client/preferences_unknown__title' => 'Preferințe de interfață',
    'ui__client/preferences_unknown__description' => "Configurarea preferințelor de interfață în sistemul Plesk al clientului.",
    'ui__client/preferences_self__short-title' => 'Preferințe de interfață',
    'ui__client/preferences_self__title' => 'Preferințe de interfață',
    'ui__client/preferences_self__description' => 'Configurarea preferințelor de interfață în sistemul dvs. Plesk.',
    'ui__client/logo__title' => 'Branding de sistem Plesk',
    'ui__client/logo__short-title' => 'Branding de sistem Plesk',
    'ui__client/logo__description' => "Rebranding de sistem Plesk pentru clientul %1.",
    'ui__client/logo_self__title' => 'Branding de sistem Plesk',
    'ui__client/logo_self__short-title' => 'Branding de sistem Plesk',
    'ui__client/logo_self__description' => 'Rebranding de sistem Plesk, modificarea imaginii siglă și a barei de titlu din browser.',
    'ui__client/permissions__title' => 'Permisiuni',
    'ui__client/permissions__short-title' => 'Permisiuni',
    'ui__client/permissions__description' => "Vizualizarea sau modificarea acțiunilor pe care clientul %1 le poate executa în Plesk.",
    'ui__client/permissions_unknown__short-title' => 'Permisiuni',
    'ui__client/permissions_unknown__title' => 'Permisiuni',
    'ui__client/permissions_unknown__description' => "Vizualizarea sau modificarea acțiunilor pe care clientul le poate executa în Plesk.",
    'ui__client/permissions_self__title' => 'Permisiuni',
    'ui__client/permissions_self__short-title' => 'Permisiuni',
    'ui__client/permissions_self__description' => "Vizualizarea listei acțiunilor pe care le puteți executa în Plesk.",
    'ui__client/permissions_readonly-self__title' => 'Permisiuni',
    'ui__client/permissions_readonly-self__short-title' => 'Permisiuni',
    'ui__client/permissions_readonly-self__description' => "Vizualizarea listei acțiunilor pe care le puteți executa în Plesk.",

    // website
    // icons
    // Edit in SiteBuilder - RESELLER/WEBSITE
    // Web hosting settings - RESELLER/WEBSITE
    // Subdomains - RESELLER/WEBSITE
    // Domain aliases - RESELLER/ADDITIONAL TOOLS
    // Frontpage Webadmin - RESELLER/WEBSITE
    // Frontpage SSL/TLS Webadmin - RESELLER/WEBSITE
    // Web users - RESELLER/WEBSITE
    // Site preview - RESELLER/WEBSITE
    // dropdowns
    // DNS settings - RESELLER/WEBSITE
    // Change hosting type - RESELLER/WEBSITE
    // FrontPage management - RESELLER/WEBSITE    // PFW
    // Create subdomain - RESELLER/WEBSITE

    // applications & services
    // icons
    // Web applications - RESELLER/APPLICATIONS & SERVICES
    'ui__client/extras-domain__short-title' => 'Instrumente de la MyPlesk.com',
    'ui__client/extras-domain__title' => 'Instrumente de la MyPlesk.com',
    'ui__client/extras-domain__description' => 'Cumpărați instrumente și servicii suplimentare de la MyPlesk.com.',
    'ui__client/extras-domain_unknown__short-title' => 'Instrumente de la MyPlesk.com',
    'ui__client/extras-domain_unknown__title' => 'Instrumente de la MyPlesk.com',
    'ui__client/extras-domain_unknown__description' => 'Cumpărați instrumente și servicii suplimentare de la MyPlesk.com.',
    'ui__client/extras-domain_self__short-title' => 'Instrumente de la MyPlesk.com',
    'ui__client/extras-domain_self__title' => 'Instrumente de la MyPlesk.com',
    'ui__client/extras-domain_self__description' => 'Cumpărați instrumente și servicii suplimentare de la MyPlesk.com.',
    // Databases - RESELLER/APPLICATIONS & SERVICES
    // ODBC data sources - RESELLER/APPLICATIONS & SERVICES    // PFW
    // Java applications - RESELLER/APPLICATIONS & SERVICES    // PFU
    'ui__client/register-domain__title' => 'Înregistrare domeniu',
    'ui__client/register-domain__short-title' => 'Înregistrare domeniu',
    'ui__client/register-domain__description' => 'Înregistrarea unui nume de domeniu prin MyPlesk.com.',
    'ui__client/register-domain_unknown__title' => 'Înregistrare domeniu',
    'ui__client/register-domain_unknown__short-title' => 'Înregistrare domeniu',
    'ui__client/register-domain_unknown__description' => 'Înregistrarea unui nume de domeniu prin MyPlesk.com.',
    'ui__client/register-domain_self__title' => 'Înregistrare domeniu',
    'ui__client/register-domain_self__short-title' => 'Înregistrare domeniu',
    'ui__client/register-domain_self__description' => 'Înregistrarea unui nume de domeniu prin MyPlesk.com.',
    // dropdowns
    // Install web application - RESELLER/APPLICATIONS & SERVICES
    // Create database - RESELLER/APPLICATIONS & SERVICES
    // Create database user - RESELLER/APPLICATIONS & SERVICES
    // Install Java application - RESELLER/APPLICATIONS & SERVICES
    'ui__client/manage-domain__title' => 'Administrare domeniu',
    'ui__client/manage-domain__short-title' => 'Administrare domeniu',
    'ui__client/manage-domain__description' => 'Administrarea numelor de domenii înregistrate prin MyPlesk.com.',
    'ui__client/manage-domain_unknown__title' => 'Administrare domeniu',
    'ui__client/manage-domain_unknown__short-title' => 'Administrare domeniu',
    'ui__client/manage-domain_unknown__description' => 'Administrarea numelor de domenii înregistrate prin MyPlesk.com.',
    'ui__client/manage-domain_self__title' => 'Administrare domeniu',
    'ui__client/manage-domain_self__short-title' => 'Administrare domeniu',
    'ui__client/manage-domain_self__description' => 'Administrarea numelor de domenii înregistrate prin MyPlesk.com.',

    // additional tools
    // icons
    'ui__client/ipaddress_unknown__title' => 'Adrese IP',
    'ui__client/ipaddress_unknown__short-title' => "Adrese IP",
    'ui__client/ipaddress_unknown__description' => "Administrarea adreselor IP.",
    'ui__client/domain/domain-alias_readonly-unknown__short-title' => 'Aliasuri de domeniu',
    'ui__client/domain/domain-alias_readonly-unknown__title' => 'Aliasuri de domeniu',
    'ui__client/domain/domain-alias_readonly-unknown__description' => 'Vizualizarea listei numelor alternative pentru domeniul dvs.',
    // Scheduled tasks - RESELLER/ADDITIONAL TOOLS
    // SSL/TLS certificates - RESELLER/ADDITIONAL TOOLS
    // Hotlink protection - RESELLER/ADDITIONAL TOOLS    // PFW
    'ui__client/sessions__short-title' => 'Sesiuni active',
    'ui__client/sessions__title' => 'Sesiuni active',
    'ui__client/sessions__description' => 'Vizualizarea sesiunilor Plesk active.',
    'ui__client/sessions_unknown__short-title' => 'Sesiuni active',
    'ui__client/sessions_unknown__title' => 'Sesiuni active',
    'ui__client/sessions_unknown__description' => 'Vizualizarea sesiunilor Plesk active.',
    'ui__client/sessions_self__short-title' => 'Sesiuni active',
    'ui__client/sessions_self__title' => 'Sesiuni active',
    'ui__client/sessions_self__description' => 'Vizualizarea sesiunilor Plesk active.',
    // Shared SSL/TLS - RESELLER/ADDITIONAL TOOLS    // PFW
    // ASP.NET settings - RESELLER/ADDITIONAL TOOLS    // PFW
    // PHP settings - RESELLER/ADDITIONAL TOOLS    // PFW
    // dropdowns
    //Schedule new task - RESELLER/ADDITIONAL TOOLS

    ///
    /// END OF CLIENT
    ///

    ///
    /// DOMAIN / DOMAIN ADMINISTRATOR
    ///

    // files
    // icons
    'ui__client/domain/hosting/file-manager__short-title' => 'Manager de fișiere',
    'ui__client/domain/hosting/file-manager__title' => 'Administrare fișiere pe domeniul %1',
    'ui__client/domain/hosting/file-manager__description' => "Administrarea fișierelor și a directoarelor pe domeniul %1 prin managerul de fișiere.",
    'ui__client/domain/hosting/file-manager_self__short-title' => 'Manager de fișiere',
    'ui__client/domain/hosting/file-manager_self__title' => 'Manager de fișiere',
    'ui__client/domain/hosting/file-manager_self__description' => "Administrarea propriilor fișiere și directoare prin managerul de fișiere.",
    'ui__client/domain/hosting/ssh-terminal__short-title' => 'Terminal SSH', // PFU
    'ui__client/domain/hosting/ssh-terminal__title' => 'Terminal SSH', // PFU
    'ui__client/domain/hosting/ssh-terminal__description' => 'Accesarea serverului cu terminal SSH.', // PFU
    'ui__client/domain/hosting/ssh-terminal_self__short-title' => 'Terminal SSH', // PFU
    'ui__client/domain/hosting/ssh-terminal_self__title' => 'Terminal SSH', // PFU
    'ui__client/domain/hosting/ssh-terminal_self__description' => 'Accesarea serverului cu terminal SSH.', // PFU
    'ui__client/domain/hosting/protected-directories__short-title' => 'Directoare protejate prin parolă',
    'ui__client/domain/hosting/protected-directories__title' => 'Directoare protejate prin parolă',
    'ui__client/domain/hosting/protected-directories__description' => 'Protejarea accesului la anumite zone ale site-ului.',
    'ui__client/domain/hosting/protected-directories_self__short-title' => 'Directoare protejate prin parolă',
    'ui__client/domain/hosting/protected-directories_self__title' => 'Directoare protejate prin parolă',
    'ui__client/domain/hosting/protected-directories_self__description' => 'Protejarea accesului la anumite zone ale site-ului.',
    'ui__client/domain/hosting/web-directories__title' => 'Directoare virtuale', // PFW
    'ui__client/domain/hosting/web-directories__short-title' => 'Directoare virtuale', // PFW
    'ui__client/domain/hosting/web-directories__description' => 'Lucrul cu fișiere și directoare fizice și virtuale din site-ul %1.', // PFW
    'ui__client/domain/hosting/web-directories_self__title' => 'Directoare virtuale', // PFW
    'ui__client/domain/hosting/web-directories_self__short-title' => 'Directoare virtuale', // PFW
    'ui__client/domain/hosting/web-directories_self__description' => 'Lucrul cu fișiere și directoare fizice și virtuale din site-ul web.', // PFW

    // statistics
    // icons
    'ui__client/domain/traffic__short-title' => '%1 Utilizare trafic',
    'ui__client/domain/traffic__title' => 'Statistici privind transferurile de date pentru <b>%1</b>',
    'ui__client/domain/traffic__description' => 'Vizualizarea statisticilor privind transferurile de date pentru domeniul %1.',
    'ui__client/domain/traffic_self__short-title' => 'Utilizare trafic',
    'ui__client/domain/traffic_self__title' => 'Vizualizarea utilizării traficului din domeniul dvs.',
    'ui__client/domain/traffic_self__description' => 'Vizualizarea raportului de utilizare a traficului din domeniul dvs.',
    'ui__client/domain/hosting/logs__short-title' => 'Manager de jurnale',
    'ui__client/domain/hosting/logs__title' => 'Manager de jurnale',
    'ui__client/domain/hosting/logs__description' => 'Vizualizarea jurnalelor și configurarea rotației fișierelor de jurnal.',
    'ui__client/domain/hosting/logs_self__short-title' => 'Manager de jurnale',
    'ui__client/domain/hosting/logs_self__title' => 'Manager de jurnale',
    'ui__client/domain/hosting/logs_self__description' => 'Vizualizarea jurnalelor și configurarea rotației fișierelor de jurnal.',

    // domain administration
    // dropdowns
    'ui__client/domain/rename__title' => 'Redenumire domeniu',
    'ui__client/domain/rename__short-title' => 'Redenumire domeniu',
    'ui__client/domain/rename__description' => 'Redenumirea domeniului %1.',
    'ui__client/domain/rename_unknown__short-title' => 'Redenumire domeniu',
    'ui__client/domain/rename_unknown__title' => 'Redenumire domeniu',
    'ui__client/domain/rename_unknown__description' => 'Redenumirea unui domeniu.',
    'ui__client/domain/chowner_select__title' => 'Atribuiți proprietar nou domeniului',
    'ui__client/domain/chowner_select__short-title' => 'Atribuirea unui nou proprietar abonamentului',
    'ui__client/domain/chowner_select__description' => 'Atribuirea unui nou proprietar abonamentului',
    'ui__client/domain/chowner_unknown-select__short-title' => 'Atribuirea unui nou proprietar abonamentului',
    'ui__client/domain/chowner_unknown-select__title' => 'Atribuirea unui nou proprietar abonamentului',
    'ui__client/domain/chowner_unknown-select__description' => 'Atribuirea unui nou proprietar unui abonament.',
    'ui__client/domain/toggle__title' => 'Suspendare sau activare domeniu', // for HP customization
    'ui__client/domain/toggle__short-title' => 'Suspendare sau activare domeniu', // for HP customization
    'ui__client/domain/toggle__description' => 'Suspendarea sau activarea domeniului %1.', // for HP customization
    'ui__client/domain/toggle_unknown__title' => 'Suspendare sau activare domeniu', // for HP customization
    'ui__client/domain/toggle_unknown__short-title' => 'Suspendare sau activare domeniu', // for HP customization
    'ui__client/domain/toggle_unknown__description' => 'Suspendarea sau activarea unui domeniu.', // for HP customization
    'ui__client/domain/toggle_enable__title' => 'Activare domeniu',
    'ui__client/domain/toggle_enable__short-title' => 'Activare domeniu',
    'ui__client/domain/toggle_enable__description' => 'Activarea domeniului %1.',
    'ui__client/domain/toggle_disable__title' => 'Suspendare domeniu',
    'ui__client/domain/toggle_disable__short-title' => 'Suspendare domeniu',
    'ui__client/domain/toggle_disable__description' => 'Suspendarea domeniului %1.',

    // website
    // icons
    // dropdowns
    'ui__client/domain/dns__title' => 'Setări DNS',
    'ui__client/domain/dns__short-title' => 'Setări DNS',
    'ui__client/domain/dns__description' => 'Administrarea setărilor zonei DNS pentru domeniul %1.',
    'ui__client/domain/dns_self__title' => 'Setări DNS',
    'ui__client/domain/dns_self__short-title' => 'Setări DNS',
    'ui__client/domain/dns_self__description' => 'Administrarea setărilor zonei DNS pentru domeniul dvs.',
    'ui__client/domain/dns_disabled__title' => 'Setări DNS',
    'ui__client/domain/dns_disabled__short-title' => 'Setări DNS',
    'ui__client/domain/dns_disabled__description' => 'Administrarea setărilor zonei DNS pentru domeniul %1.',
    'ui__client/domain/dns_self-disabled__title' => 'Setări DNS',
    'ui__client/domain/dns_self-disabled__short-title' => 'Setări DNS',
    'ui__client/domain/dns_self-disabled__description' => 'Administrarea setărilor zonei DNS pentru domeniul dvs.',
    'ui__client/domain/dns_readonly__title' => 'Setări DNS',
    'ui__client/domain/dns_readonly__short-title' => 'Setări DNS',
    'ui__client/domain/dns_readonly__description' => 'Vizualizare setărilor zonei DNS pentru domeniul %1.',
    'ui__client/domain/dns_readonly-self__title' => 'Setări DNS',
    'ui__client/domain/dns_readonly-self__short-title' => 'Setări DNS',
    'ui__client/domain/dns_readonly-self__description' => 'Vizualizarea setărilor zonei DNS pentru domeniul dvs.',
    'ui__client/domain/dns_readonly-self-disabled__title' => 'Setări DNS',
    'ui__client/domain/dns_readonly-self-disabled__short-title' => 'Setări DNS',
    'ui__client/domain/dns_readonly-self-disabled__description' => 'Vizualizarea setărilor zonei DNS pentru domeniul dvs.',
    'ui__client/domain/dns_readonly-self-slave__title' => 'Setări DNS',
    'ui__client/domain/dns_readonly-self-slave__short-title' => 'Setări DNS',
    'ui__client/domain/dns_readonly-self-slave__description' => 'Vizualizarea setărilor zonei DNS pentru domeniul dvs.',
    'ui__client/domain/dns_slave__title' => 'Setări DNS',
    'ui__client/domain/dns_slave__short-title' => 'Setări DNS',
    'ui__client/domain/dns_slave__description' => 'Administrarea setărilor zonei DNS pentru domeniul %1.',
    'ui__client/domain/dns_self-slave__title' => 'Setări DNS',
    'ui__client/domain/dns_self-slave__short-title' => 'Setări DNS',
    'ui__client/domain/dns_self-slave__description' => 'Administrarea setărilor zonei DNS pentru domeniul dvs.',
    // FrontPage management - RESELLER/WEBSITE    // PFW

    // applications & services
    // icons
    'ui__client/domain/extras__short-title' => 'Instrumente de la MyPlesk.com',
    'ui__client/domain/extras__title' => 'Instrumente de la MyPlesk.com',
    'ui__client/domain/extras__description' => 'Cumpărați instrumente și servicii suplimentare de la MyPlesk.com.',
    'ui__client/domain/extras_unknown__short-title' => 'Instrumente de la MyPlesk.com',
    'ui__client/domain/extras_unknown__title' => 'Instrumente de la MyPlesk.com',
    'ui__client/domain/extras_unknown__description' => 'Cumpărați instrumente și servicii suplimentare de la MyPlesk.com.',
    'ui__client/domain/extras_self__short-title' => 'Instrumente de la MyPlesk.com',
    'ui__client/domain/extras_self__title' => 'Instrumente de la MyPlesk.com',
    'ui__client/domain/extras_self__description' => 'Cumpărați instrumente și servicii suplimentare de la MyPlesk.com.',
    'ui__client/domain/odbc__short-title' => 'Surse de date ODBC', // PFW
    'ui__client/domain/odbc__title' => 'Surse de date ODBC', // PFW
    'ui__client/domain/odbc__description' => 'Configurarea surselor de date ODBC pentru domeniul %1.', // PFW
    'ui__client/domain/odbc_self__short-title' => 'Surse de date ODBC', // PFW
    'ui__client/domain/odbc_self__title' => 'Surse de date ODBC', // PFW
    'ui__client/domain/odbc_self__description' => 'Setați sursele de date ODBC pentru domeniul dvs.', // PFW
    // Java applications - RESELLER/APPLICATIONS & SERVICES    // PFU
    'ui__client/domain/register__short-title' => 'Înregistrare domeniu',
    'ui__client/domain/register__title' => 'Înregistrare domeniu',
    'ui__client/domain/register__description' => 'Înregistrarea unui nume de domeniu prin MyPlesk.com.',
    'ui__client/domain/register_unknown__short-title' => 'Înregistrare domeniu',
    'ui__client/domain/register_unknown__title' => 'Înregistrare domeniu',
    'ui__client/domain/register_unknown__description' => 'Înregistrarea unui nume de domeniu prin MyPlesk.com.',
    'ui__client/domain/register_self__short-title' => 'Înregistrare domeniu',
    'ui__client/domain/register_self__title' => 'Înregistrare domeniu',
    'ui__client/domain/register_self__description' => 'Înregistrarea unui nume de domeniu prin MyPlesk.com.',
    // dropdowns
    // Create database user - RESELLER/APPLICATIONS & SERVICES

    // additional tools
    // icons
    // Domain aliases - RESELLER/ADDITIONAL TOOLS
    // Scheduled tasks - RESELLER/ADDITIONAL TOOLS    // PFU
    // SSL/TLS certificates - RESELLER/ADDITIONAL TOOLS
    'ui__client/domain/hosting/hotlink-protection__short-title' => 'Protecție hotlink', // PFW
    'ui__client/domain/hosting/hotlink-protection__title' => 'Protecție hotlink', // PFW
    'ui__client/domain/hosting/hotlink-protection__description' => 'Protejarea fișierelor din domeniul %1 împotriva practicilor de hotlinking.', // PFW
    'ui__client/domain/hosting/hotlink-protection_self__short-title' => 'Protecție hotlink', // PFW
    'ui__client/domain/hosting/hotlink-protection_self__title' => 'Protecție hotlink', // PFW
    'ui__client/domain/hosting/hotlink-protection_self__description' => 'Protejarea fișierelor proprii împotriva practicilor de hotlinking.', // PFW
    'ui__client/domain/hosting/performance__short-title' => 'Limitare lățime de bandă',
    'ui__client/domain/hosting/performance__title' => 'Limita de utilizare a lățimii de bandă și numărul de conexiuni simultane la site-ul web',
    'ui__client/domain/hosting/performance__description' => 'Vizualizarea și reglarea limitei de utilizare a lățimii de bandă pentru domeniul %1 și a numărului de conexiuni simultane la acesta.',
    'ui__client/domain/hosting/performance_readonly__short-title' => 'Limitare lățime de bandă',
    'ui__client/domain/hosting/performance_readonly__title' => 'Limite de utilizare a lățimii de bandă și ale numărului de conexiuni simultane la site-ul web',
    'ui__client/domain/hosting/performance_readonly__description' => 'Vizualizarea limitei de utilizare a lățimii de bandă pentru domeniul %1 și a numărului de conexiuni simultane la acesta.',
    'ui__client/domain/hosting/performance_self__short-title' => 'Limitare lățime de bandă',
    'ui__client/domain/hosting/performance_self__title' => 'Limitare lățime de bandă',
    'ui__client/domain/hosting/performance_self__description' => 'Vizualizarea și reglarea limitei de utilizare a lățimii de bandă pentru domeniul dvs. și a numărului de conexiuni simultane la acesta.',
    'ui__client/domain/hosting/performance_readonly-self__short-title' => 'Limitare lățime de bandă',
    'ui__client/domain/hosting/performance_readonly-self__title' => 'Limitare lățime de bandă',
    'ui__client/domain/hosting/performance_readonly-self__description' => 'Vizualizarea limitei de utilizare a lățimii de bandă pentru domeniul dvs. și a numărului de conexiuni simultane la acesta.',

    // dropdowns


    ///
    /// END OF DOMAIN / DOMAIN ADMINISTRATOR
    ///

    ////
    //// KEYS FOR BUSINESS OBJECT LISTS/PAGES (RESELLERS, CLIENTS, DOMAINS)
    ////

    ///
    /// DOMAINS
    ///

    // Domains list page title - ui__client/domain_unknown__short-title (HOME)

    // tools
    'ui__client/domain#tools__title' => "Instrumente",
    // Below: TBD
    'ui__client/domain-summary-report_unknown__short-title' => 'Vizualizare statistici',
    'ui__client/domain-summary-report_unknown__title' => 'Vizualizare statistici',
    'ui__client/domain-summary-report_unknown__description' => 'Vizualizarea informațiilor despre utilizarea resurselor pe domenii.',
    'ui__client/domain-summary-report__short-title' => "Vizualizare statistici",
    'ui__client/domain-summary-report__title' => "Vizualizare statistici",
    'ui__client/domain-summary-report__description' => "Vizualizarea informațiilor despre utilizarea resurselor pe domenii.",
    'ui__client/domain-summary-report_self__short-title' => "Vizualizare statistici",
    'ui__client/domain-summary-report_self__title' => "Vizualizare statistici",
    'ui__client/domain-summary-report_self__description' => "Vizualizarea informațiilor despre utilizarea resurselor în domeniile dvs.",
    // Traffic usage - ui__client/domain/traffic_unknown__short-title

    'ui__client/domain#list__title' => "Domenii", // DOMAINS

    // list object operation errors
    'ui__client/domain/delete__empty_selection' => 'Trebuie să selectați domeniile pe care doriți să le ștergeți',
    'ui__client/domain/chowner__empty_selection' => 'Trebuie să selectați domeniile pe care doriți să le atribuiți noilor proprietari',

    // list objects filtering
    'domains_list__name__filter_title' => 'Nume',
    'domains_list__state__filter_title' => 'Utilizare resurse',
    'domains_list__filter_state_any' => 'Oricare',
    'domains_list__filter_state_overuse' => 'Suprautilizare',
    'domains_list__filter_state_normal' => 'În limitele admise',
    'domains_list__status__filter_title' => 'Stare',
    'domains_list__filter_status_any' => 'Oricare',
    'domains_list__filter_status_blocked' => 'Suspendat',
    'domains_list__filter_status_active' => 'Activ',
    'domains_list__ownership__filter_title' => 'Proprietate',
    'domains_list__filter_ownership_all' => 'Toate domeniile',
    'domains_list__filter_ownership_personal' => 'Doar domeniile mele',
    'domains_list__filter_owner_pname__filter_title' => 'Nume proprietar',
    'domains_list__subrows__filter_title' => 'Afișare',
    'domains_list__subrows_off' => 'Doar domenii',
    'domains_list__subrows_subdomain_domainaliases' => 'Cu subdomenii și aliasuri',
    'domains_list__subrows_subdomain' => 'Cu subdomenii',
    'domains_list__subrows_domainaliases' => 'Cu aliasuri',

    // objects list
    'domains_list__owner__title' => 'Proprietar',

    ///
    /// END OF DOMAINS
    ///

    ////
    //// KEYS FOR APPLICATION VAULT AND WEB APPLICATION MANAGEMENT
    ////

    ///
    /// APPLICATION VAULT / APS CATALOG
    ///

    // Application Vault / APS Catalog promotional block
    'site_apps__promo_browse_for_applications' => "Căutare aplicații",
    'site_apps__promo_main_text' => "Catalogul Applicațion Packaging Standard (APS) conține lista de aplicații care poate fi furnizată unui domeniu sau spațiu web. Dacă doriți să furnizați aplicații care nu se află în catalog, puteți face acest lucru urmând instrucțiunile de împachetare APS pe www.apsstandard.com",
    'site_apps__promo_download_now' => "Descărcare aplicații:",
    'site_apps__promo_close' => "Închiderea acestui bloc",
    'site_apps__promo_preset__mostused' => '%1 cele mai populare',
    'site_apps__promo_preset__lessused' => 'Următoarele %1 în ordinea popularității',
    'site_apps__promo_preset__all' => "Toate",
    'site_apps__promo_disclaimer_note' => 'Rețineți: aplicațiile instalate din catalogul APS sunt furnizate de terțe părți. Plesk nu oferă asistență pentru acestea.',
    'site_apps__promo_preset__page_title' => '%1 aplicații APS',

    // Progress bar
    'site_apps__progress_initialization_message' => 'Se adaugă aplicațiile...',

    // Errors
    'site_apps__no_applications_for_update' => 'Nu aveți aplicații instalate în Seiful de aplicații.',
    'site_apps__incorrect_download_preset_configuration' => 'S-au găsit erori în configurația presetării de descărcare a catalogului APS.',
    'site_apps__aps_catalog_url_is_invalid' => 'URL-ul specificat nu este corect.',
    'site_apps__no_updates_at_the_moment' => 'În acest moment nu sunt disponibile noi actualizări de aplicații.',
    'site_apps__incorrect_content_returned_by_catalog' => 'S-au primit informații incorecte de la catalogul de aplicații APS. Încercați mai târziu.',
    'site_apps__entered_aps_catalog_url_is_not_valid' => 'Setările de catalog APS au fost salvate, dar Plesk nu a putut stabili o conexiune cu catalogul APS specificat în acestea (%1). Asigurați-vă că adresa catalogului APS este corectă și catalogul APS de la această adresă este activ.',
    'site_apps__cannot_retrieve_updates' => 'Actualizările de aplicație nu pot fi descărcate pentru moment: nu se poate stabili o conexiune la catalogul APS (%1). Asigurați-vă că adresa catalogului APS este corectă și catalogul APS de la această adresă este activ.',
    'site_apps__no_site_applications_in_client_pool_to_install' => 'Nu există aplicații web disponibile pentru instalare.',
    'site_apps__site_applications_already_installed_in_root' => 'În directoarele rădăcină ale acestor gazde virtuale sunt instalate deja alte aplicații web',
    'site_apps__dot_net_packages_not_supported_on_unix_platform' => "Aplicațiile .NET nu sunt acceptate pe platformele Unix/Linux",
    'site_apps__server_wide_packages_not_supported' => 'Aplicații web la nivel de server nu sunt acceptate',
    'site_apps__applications_added_to_queue_for_adding_to_application_vault' => "Încă %1 aplicații web sunt programate pentru a fi adăugate în Seiful de aplicații.",
    'site_apps__applications_all_in_vault' => "Aplicațiile web selectate sunt deja în Seiful de aplicații.",
    'site_apps__applications_already_in_download_queue' => "În acest moment %1 aplicații web selectate sunt adăugate în Seiful de aplicații.",
    'site_apps__applications_already_in_valut' => "%1 aplicații web selectate se află deja în Seiful de aplicații.",

    // UI errors

    ///
    /// END OF APPLICATION VAULT / APS CATALOG
    ///

    ///
    /// APS CATEGORIES
    ///

    // General
    'site_apps__not_categorized' => 'Altul (necategorizat)',

    // Errors
    'site_apps__no_applications_in_category' => 'Nu există aplicații disponibile în această categorie. Selectați o altă categorie.',
    'site_apps__no_category_selected__please_specify' => 'Selectați o categorie din meniul din stânga. Toate aplicațiile disponibile din categoria selectată vor apărea în această fereastră.',

    // Category: Back office
    // Category: Collaboration
    // Category: Front Office
    // Category: Infrastructure
    // Category: Personal
    // Category: Web

    ///
    /// END OF APS CATEGORIES
    ///

    ///
    /// APPLICATION VAULT
    ///

    //removal


    ///
    /// END OF APPLICATION VAULT
    ///

    ////
    //// KEYS FOR SETTINGS PAGE
    ////

    ///
    /// SERVER ADMINISTRATOR SETTINGS
    ///

    'administrator_account' => 'Cont administrator',
    // Personal data - HOME/SERVER ADMINISTRATOR/ACCOUNT
    // Change password - HOME/SERVER ADMINISTRATOR/ACCOUNT
    // Interface preferences - HOME/SERVER ADMINISTRATOR/ACCOUNT

    'general' => 'General',
    // Server settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_change_hostname' => 'Modificarea numelui de gazdă',
    // System time - HOME/SERVER ADMINISTRATOR/SERVER
    // IP addresses - HOME/SERVER ADMINISTRATOR/SERVER
    // Scheduled tasks - HOME/SERVER ADMINISTRATOR/SERVER
    // FTP settings - HOME/SERVER ADMINISTRATOR/SERVER    // PFW

    'security' => 'Securitate',
    'bt_setup_firewall' => 'Configurare firewall',
    'bt_manage_firewall_rules' => 'Administrarea regulilor de firewall',
    'cu_firewall__rule' => 'Crearea unei reguli de firewall',
    'cu_firewall__protocol' => 'Setarea unui protocol pentru regulă („tcp” sau „udp”)',
    'cu_firewall__name' => "Setarea unui nume de regulă",
    'cu_firewall__disabled' => 'Dacă valoarea este „true”, regula este dezactivată după creare',
    // Session idle time - HOME/SERVER ADMINISTRATOR/SECURITY
    // SSL/TLS certificates - HOME/SERVER ADMINISTRATOR/SECURITY
    // Shared SSL/TLS - HOME/SERVER ADMINISTRATOR/SECURITY    // PFW

    'dns' => 'DNS',
    'bt_select_dns_server' => 'Selectați serverul DNS', // PFW
    'bt_soa_records_template' => 'Șablon de înregistrare SOA',
    'bt_restrict_creation_of_subzones' => 'Restricționarea creării de subzone',

    'databases' => 'Baze de date',
    'bt_select_mssqlwebadmin' => 'Selectare administrare prin web MS SQL', // PFW
    // Database hosting preferences - HOME/SERVER ADMINISTRATOR/SERVER

    'applications' => 'Aplicații',
    // ASP.NET settings - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES    // PFW
    // IIS application pool - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES    // PFW
    // SiteBuilder settings - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES

    'mail' => 'E-mail',
    'bt_select_mailserver' => 'Selectați serverul de e-mail', // PFW
    // Mail server settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_select_antivirus' => 'Selectare antivirus', // PFW
    'bt_virus_protection_settings' => 'Setări de protecție antivirus',
    'bt_select_spamfilter' => 'Selectați filtrul de spam', // PFW
    // Spam filter settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_select_webmail' => 'Selectare e-mail prin web',
    // Set up mailing lists server - HOME/SERVER ADMINISTRATOR/SERVER    // PFU

    'logs_and_statistics' => 'Jurnale și statistici',
    'bt_server_statistics_settings' => 'Setări pentru statisticile de server',
    'bt_select_web_statistics' => 'Produse software de statistici web disponibile', // PFW
    // Action log - HOME/SERVER ADMINISTRATOR/LOGS & STATISTICS

    'control_panel_interface' => 'Interfață Plesk',

    'components_and_modules' => 'Componente și module',
    // Server components - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_setup_watchdog' => 'Configurare Watchdog', // PFU
    'bt_setup_vpn' => 'Configurare VPN', // PFU
    'bt_setup_samba' => 'Configurare Samba',    // PFU

    ///
    /// END OF SERVER ADMINISTRATOR SETTINGS
    ///

    ///
    /// DOMAIN SETTINGS
    ///

    'ui__client/domain/settings_self__title' => 'Setări',
    'ui__client/domain/settings_self__short-title' => 'Setări',
    'ui__client/domain/settings_self__description' => 'Vizualizarea și modificarea setărilor de domeniu.',

    'domain_administrator_account' => 'Cont de administrator de domeniu',
    // Interface preferences - HOME/DOMAIN ADMINISTRATOR/DOMAIN
    'bt_account_settings' => 'Setări cont',

    'domain' => 'Domeniu',
    'bt_dns_soa_records' => 'Înregistrări DNS SOA',
    // Mail settings - HOME/DOMAIN ADMINISTRATOR/MAIL
    'bt_task_scheduler_settings' => 'Setările programatorului de activități',

    'website' => 'Site',
    // Web hosting settings - HOME/DOMAIN ADMINISTRATOR/WEBSITE
    // Bandwidth limiting - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS
    'bt_web_users_scripting' => 'Scripturi pentru utilizatorii web',
    // Anonymous FTP - HOME/DOMAIN ADMINISTRATOR/FILES

    // Applications - SETTINGS/SERVER/APPLICATIONS    // PFW
    // ASP.NET settings - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW
    // PHP settings - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW
    // IIS application pool - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW

    // Security - SETTINGS/SERVER/SECURITY
    // Password protected directories - HOME/DOMAIN ADMINISTRATOR/FILES
    'bt_select_ssl_certificate' => 'Selectare certificat SSL/TLS',
    // Hotlink protection - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW
    // Shared SSL/TLS - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW

    // Logs & statistics - SETTINGS/SERVER/LOGS & STATISTICS
    'bt_web_statistics' => 'Statistici web',
    'bt_log_rotation_settings' => 'Setări de rotație pentru jurnal',

    ///
    /// END OF DOMAIN SETTINGS
    ///

    ////
    //// KEYS FOR LIMITS AND PERMISSIONS
    ////

    ///
    /// LIMITS
    ///

    '__limits' => "Limite", // template

    // overuse & oversell
    'limits__overuse_oversell_policy_legend' => "Politica de suprautilizare și supravânzare",
    'limits__overuse_policy_legend' => "Suprautilizare",
    'limits__oversell_policy_legend' => "Supravânzare",
    'limits__reseller_overuse_description' => "Politica de suprautilizare comunică sistemului Plesk ce măsuri trebuie luate în cazul suprautilizării resurselor.",
    'limits__overuse_text' => "Politică de suprautilizare",

    // limit names
    'limit_group__disk_space_and_traffic' => 'Spațiu pe disc și trafic',
    'limit__disk_space' => 'Spațiu pe disc',
    'limit__max_traffic' => 'Trafic',
    'limit_group__client' => 'Clienți',
    'limit__max_cl' => 'Clienți',
    'limit_group__domain' => 'Domenii',
    'limit__max_dom' => 'Domenii',
    'limit__max_dom_powerUser' => 'Abonamente',
    'limit__max_subdom' => 'Subdomenii',
    'limit__max_dom_aliases' => 'Aliasuri de domeniu',
    'limit__max_wu' => 'Utilizatori web',
    'limit__max_subftp_users' => 'Conturi FTP suplimentare', // PFW
    'limit_group__mail' => 'E-mail',
    'limit__max_box' => 'Căsuțe poștale',
    'limit__mbox_quota' => 'Dimensiune căsuță poștală',
    'limit__total_mboxes_quota' => 'Cota totală a căsuțelor poștale', // PFW
    'limit__max_maillists' => 'Liste de e-mail',
    'limit_group__database' => 'Baze de date',
    'limit__max_mssql_db' => 'Baze de date Microsoft SQL Server', // PFW
    'limit__mssql_dbase_space' => 'Cotă totală pentru bazele de date MS SQL', // PFW
    'limit__max_odbc' => 'Conexiuni ODBC', // PFW
    // limit__max_db - CONFLICTED
    'limit__mysql_dbase_space' => 'Cotă pentru bazele de date MySQL', // PFW?
    'limit_group__application' => 'Aplicații',
    'limit__max_iis_app_pools' => 'Liste de aplicații IIS', // PFW
    'limit_group__security' => 'Securitate',
    'limit_group__validity' => 'Data expirării',
    'limit__expiration' => 'Data expirării',
    'limit__validity' => 'Perioada de valabilitate',
    'limit__max_site_builder' => 'Site-uri publicate cu Presence Builder',
    'limit__max_site' => 'Domenii',
    'limit__mssql_dbase_filesize' => 'Dimensiunea de fișier a bazei de date MS SQL',
    'limit__mssql_dbase_log_filesize' => 'Dimensiunea de fișier jurnal a bazei de date MS SQL',
    'limit__mssql_dbase_filesize_hint' => 'Dimensiunea maximă a unui fișier bază de date Microsoft SQL.',
    'limit__mssql_dbase_log_filesize_hint' => 'Dimensiunea maximă a unui fișier jurnal al bazei de date Microsoft SQL.',
    'limit__units_mssql_dbase_filesize' => "MB",
    'limit__units_mssql_dbase_log_filesize' => "MB",

    'dom_pref__invalid_max_site_limit' => 'Limite de domeniu incorecte. Valoarea minimă este 1.',

    'property__has_wrong_value' => 'Proprietatea %1 are o valoare incorectă.',
    'property__name_outgoing_messages_domain_limit' => 'Stabilește numărul limită de mesaje trimise dintr-un domeniu (pe oră). Pentru a seta valoarea Nelimitat, specificați „-1”. Specificați „default” pentru a seta valoarea setată la nivel de server.',
    'property__name_outgoing_messages_mbox_limit' => 'Stabilește numărul limită de mesaje trimise dintr-o căsuță poștală (pe oră). Pentru a seta valoarea Nelimitat, specificați „-1”. Specificați „implicit” pentru a seta valoarea setată la nivel de server.',
    'property__name_outgoing_messages_subscription_limit' => 'Stabilește numărul limită de mesaje trimise dintr-un abonament (pe oră). Pentru a seta valoarea Nelimitat, specificați „-1”. Specificați „implicit” pentru a seta valoarea setată la nivel de server.',

    // for CLI report & email notifications
    '__resource_notify' => 'Se trimite notificare',
    '__general' => 'General',
    '__template_shared' => 'Șablon partajat',
    'limit__overuse' => 'Politică de suprautilizare',
    'limit__max_traffic_soft' => 'Notificare la atingerea limitei de trafic',
    'limit__disk_space_soft' => 'Notificare la atingerea limitei de utilizare a spațiului pe disc',
    '__overuse' => 'Politică de suprautilizare',
    'performance__title' => 'Performanță',
    'performance__bandwidth' => 'Limita maximă de utilizare a lățimii de bandă (KB/s)',
    'performance__max_connections' => 'Conexiuni limitate la',

    'gch__hosting_php_isapi' => 'PHP se execută ca extensie ISAPI',
    'gch__hosting_ssi_html' => 'Pentru fișierele *.htm, *.html se utilizează SSI',
    'gch__hosting_php_handler_type' => 'PHP se execută ca',
    'gch__hosting_php_handler_id' => 'PHP se execută ca',
    'gch__hosting_php_served_by_nginx' => 'PHP este deservit de nginx',
    'gch__hosting_unpaid_website_status' => 'Starea site-urilor web în abonamentele suspendate',
    'gch__mn_no_autoresponder' => 'Nu există răspunsuri automate configurate pentru contul de e-mail.',
    'gch__no_clients_selected' => "Niciun cont de client selectat",
    'gch__no_domains_selected' => "Niciun domeniu selectat",

    // limit units
    'limit__units_disk_space' => "MB",
    'limit__units_max_traffic' => "MB/lună",
    'limit__units_mbox_quota' => "KB",
    'limit__units_mysql_dbase_space' => "MB", // PFW
    'limit__units_mssql_dbase_space' => "MB", // PFW
    'limit__units_total_mboxes_quota' => "MB", // PFW

    // manipulations and statuses of limits
    '__resource_name' => 'Nume resursă',
    '__resource_usage' => 'Utilizat',
    '__resource_limit' => 'Limită',

    '__used' => 'Utilizat',
    '__limit' => 'Limită',

    '__never_expires' => 'Nu expiră niciodată',
    '__resource_free' => '%1 disponibil din %2',
    '__resource_unlimited' => '%1 utilizat din Nelimitat',

    '__unlimited' => 'Nelimitat',
    '__increment' => "Creștere (+)",
    '__decrement' => "Reducere (-)",
    '__pt' => 'unități',
    '__procent' => '%',
    '__overused' => 'Suprautilizat',
    '__left' => 'rămase',
    '__available' => 'disponibil',
    '__not_available' => 'Neinclus',

    ///
    /// END OF LIMITS
    ///

    ///
    /// PERMISSIONS
    ///

    //permissions hints

    ///
    /// END OF PERMISSIONS
    ///

    ////
    //// KEYS FOR STATISTICS AND REPORTS
    ////

    ///
    /// REPORT
    ///

    // administrator

    'ui__admin/report/traffic-history__short-title' => 'Vizualizarea istoricului de trafic',
    'ui__admin/report/traffic-history__title' => 'Vizualizarea istoricului de trafic',
    'ui__admin/report/traffic-history__description' => 'Vizualizarea istoricului de trafic pentru reselleri, clienți și domenii.',
    'admin_traffic_history__title' => 'Istoric de trafic',

    'ui__admin/report/layout/auto_unknown__short-title' => 'Programarea livrărilor',
    'ui__admin/report/layout/auto_unknown__title' => 'Plan de trimitere a rapoartelor',
    'ui__admin/report/layout/auto_unknown__description' => 'Alegeți planul de trimitere pentru un aspect de raport.',
    'ui__admin/report/layout/auto/properties_new__short-title' => 'Adăugare plan de trimitere a rapoartelor',
    'ui__admin/report/layout/auto/properties_new__title' => 'Adăugare plan de trimitere a rapoartelor',
    'ui__admin/report/layout/auto/properties_new__description' => 'Adăugați un plan de livrare pentru raportul %1.',
    'ui__admin/report/layout/auto/properties__short-title' => 'Plan de trimitere a rapoartelor',
    'ui__admin/report/layout/auto/properties__title' => 'Plan de trimitere a rapoartelor',
    'ui__admin/report/layout/auto/properties__description' => 'Vizualizarea sau modificarea proprietăților planului de trimitere a rapoartelor.',
    'ui__admin/report/layout/auto/delete_multi__short-title' => 'Ștergere plan de trimitere a rapoartelor',
    'ui__admin/report/layout/auto/delete_multi__title' => 'Ștergere plan de trimitere a rapoartelor',
    'ui__admin/report/layout/auto/delete_multi__description' => 'Eliminarea planurilor de trimitere a rapoartelor selectate.',

    'ui__admin/report/layout_unknown__short-title' => 'Aspecte de raport',
    'ui__admin/report/layout_unknown__title' => 'Aspecte de raport',
    'ui__admin/report/layout_unknown__description' => 'Vizualizarea și administrarea aspectelor de raport.',
    'ui__admin/report/layout/properties_unknown-new__short-title' => 'Creare aspect de raport',
    'ui__admin/report/layout/properties_unknown-new__title' => 'Creare aspect de raport',
    'ui__admin/report/layout/properties_unknown-new__description' => 'Crearea unui aspect de raport.',
    'ui__admin/report/layout/delete_multi__short-title' => 'Ștergerea aspectelor de raport',
    'ui__admin/report/layout/delete_multi__title' => 'Ștergerea aspectelor de raport',
    'ui__admin/report/layout/delete_multi__description' => 'Ștergerea aspectelor de raport selectate',
    'ui__admin/report/layout/properties__short-title' => 'Proprietăți',
    'ui__admin/report/layout/properties__title' => 'Proprietățile aspectului de raport',
    'ui__admin/report/layout/properties__description' => 'Editarea proprietăților aspectului de raport.',

    // reseller
    'reseller_traffic_history__title' => "Istoricul de trafic al resellerului %1",

    'ui__reseller/traffic__short-title' => '%1',
    'ui__reseller/traffic__title' => 'Vizualizarea utilizării traficului pentru <b>%1</b>',
    'ui__reseller/traffic__description' => 'Vizualizarea raportului de utilizare a traficului pentru contul de reseller %1.',
    'ui__reseller/traffic_self__short-title' => 'Mele',
    'ui__reseller/traffic_self__title' => 'Vizualizarea utilizării traficului pe clienți',
    'ui__reseller/traffic_self__description' => 'Vizualizarea rapoartelor de utilizare a traficului pentru conturile dvs. de client.',

    'ui__reseller/report/traffic-history__short-title' => 'Vizualizarea istoricului de trafic',
    'ui__reseller/report/traffic-history__title' => 'Vizualizarea istoricului de trafic',
    'ui__reseller/report/traffic-history__description' => "Vizualizarea istoricului de trafic pentru resellerul %1.",
    'ui__reseller/report/traffic-history_self__short-title' => 'Vizualizarea istoricului de trafic',
    'ui__reseller/report/traffic-history_self__title' => 'Vizualizarea istoricului de trafic',
    'ui__reseller/report/traffic-history_self__description' => 'Vizualizarea propriului istoric de trafic.',

    'ui__reseller/report/layout/auto_unknown__short-title' => 'Programarea livrărilor',
    'ui__reseller/report/layout/auto_unknown__title' => 'Plan de trimitere a rapoartelor',
    'ui__reseller/report/layout/auto_unknown__description' => 'Alegeți planul de trimitere pentru un aspect de raport.',
    'ui__reseller/report/layout/auto/properties_new__short-title' => 'Adăugare plan de trimitere a rapoartelor',
    'ui__reseller/report/layout/auto/properties_new__title' => 'Adăugare plan de trimitere a rapoartelor',
    'ui__reseller/report/layout/auto/properties_new__description' => 'Adăugați un plan de livrare pentru raportul %1.',
    'ui__reseller/report/layout/auto/properties__short-title' => 'Plan de trimitere a rapoartelor',
    'ui__reseller/report/layout/auto/properties__title' => 'Plan de trimitere a rapoartelor',
    'ui__reseller/report/layout/auto/properties__description' => 'Vizualizarea sau modificarea proprietăților planului de trimitere a rapoartelor.',
    'ui__reseller/report/layout/auto/delete_multi__short-title' => 'Ștergere plan de trimitere a rapoartelor',
    'ui__reseller/report/layout/auto/delete_multi__title' => 'Ștergere plan de trimitere a rapoartelor',
    'ui__reseller/report/layout/auto/delete_multi__description' => 'Eliminarea planurilor de trimitere a rapoartelor selectate.',

    'ui__reseller/report/layout_unknown__short-title' => 'Aspecte de raport',
    'ui__reseller/report/layout_unknown__title' => 'Aspecte de raport',
    'ui__reseller/report/layout_unknown__description' => 'Vizualizarea și administrarea aspectelor de raport.',
    'ui__reseller/report/layout/properties_unknown-new__short-title' => 'Creare aspect de raport',
    'ui__reseller/report/layout/properties_unknown-new__title' => 'Creare aspect de raport',
    'ui__reseller/report/layout/properties_unknown-new__description' => 'Crearea unui aspect de raport.',
    'ui__reseller/report/layout/properties_new__short-title' => 'Creare aspect de raport',
    'ui__reseller/report/layout/properties_new__title' => 'Creare aspect de raport',
    'ui__reseller/report/layout/properties_new__description' => 'Crearea unui aspect de raport.',
    'ui__reseller/report/layout/delete_multi__short-title' => 'Ștergerea aspectelor de raport',
    'ui__reseller/report/layout/delete_multi__title' => 'Ștergerea aspectelor de raport',
    'ui__reseller/report/layout/delete_multi__description' => 'Ștergerea aspectelor de raport selectate',
    'ui__reseller/report/layout/properties__short-title' => 'Proprietăți',
    'ui__reseller/report/layout/properties__title' => 'Proprietățile aspectului de raport',
    'ui__reseller/report/layout/properties__description' => 'Editarea proprietăților aspectului de raport.',

    // customer
    'cl_traffic_history__title' => "Istoricul de trafic al clientului %1",

    'ui__client/traffic__short-title' => '%1',
    'ui__client/traffic__title' => 'Vizualizarea utilizării traficului pentru <b>%1</b>',
    'ui__client/traffic__description' => 'Vizualizarea rapoartelor de utilizare a traficului pentru contul de client %1.',
    'ui__client/traffic_self__short-title' => 'Utilizare trafic',
    'ui__client/traffic_self__title' => 'Utilizarea traficului pe domenii',
    'ui__client/traffic_self__description' => 'Vizualizarea rapoartelor de utilizare a traficului pentru domeniile dvs.',

    'ui__client/report/traffic-history__short-title' => 'Vizualizarea istoricului de trafic',
    'ui__client/report/traffic-history__title' => 'Vizualizarea istoricului de trafic',
    'ui__client/report/traffic-history__description' => 'Vizualizarea istoricului de trafic pentru clientul %1.',
    'ui__client/report/traffic-history_self__short-title' => 'Vizualizarea istoricului de trafic',
    'ui__client/report/traffic-history_self__title' => 'Vizualizarea istoricului de trafic',
    'ui__client/report/traffic-history_self__description' => 'Vizualizarea propriului istoric de trafic.',


    ///
    /// END OF REPORT
    ///

    ///
    /// SUMMARY / FULL REPORT
    ///

    // common full report
    'report__full_p' => 'P',
    'report__full_s' => 'S',
    'report__full_h' => 'H',
    'report__full_reseller_name' => 'Nume reseller', // reseller report
    'report__full_client_name' => 'Nume client', // customer report
    'report__full_domain_name' => 'Nume domeniu', // domain report
    'report__full_owner' => 'Proprietar', // customer & domain reports
    'report__full_creation_date' => 'Data creării',
    'report__full_size' => 'Dimensiune',
    'report__full_traffic' => 'Trafic',
    'report__full_active_clients' => 'Clienți activi', // reseller report
    'report__full_clients' => 'Clienți', // reseller report
    'report__full_active_domains' => 'Domenii active', // reseller & customer reports
    'report__full_domains' => 'Domenii', // reseller & customer reports
    'report__full_subdomains' => 'Subdomenii',
    'report__full_mboxes' => 'Căsuțe poștale',
    'report__full_disk_space' => 'Spațiu pe disc',
    'report__full_mail_groups' => 'RedirM',
    'report__full_mail_autoresp' => 'Răspunsuri auto',
    'report__full_mail_antispam' => 'Antispam',
    'report__full_mail_antivirus' => 'Antivirus',
    'report__full_mail_lists' => 'Liste e-mail',
    'report__full_web_users' => 'Utilizatori web',
    'report__full_mysql_databases' => 'Baze de date MySQL',
    'report__full_mssql_databases' => 'Baze de date MSSQL',

    // common summary report
    'report__section_general' => 'General',
    'report__version' => 'Versiune produs',
    'report__build' => 'Compilare produs',
    'report__status' => 'Stare',
    'report__company_name' => 'Nume companie',
    'report__personal_name' => 'Nume personal',
    'report__login' => 'Nume utilizator',
    'report__phone' => 'Telefon',
    'report__fax' => 'Fax',
    'report__email' => 'E-mail',
    'report__address' => 'Adresă',
    'report__city' => 'Localitate',
    'report__state' => 'Stat/județ',
    'report__zip_code' => 'Cod poștal/ZIP',
    'report__country' => 'Țară',
    'report__creation_date' => 'Data creării',
    'report__expiration_date' => 'Data expirării',
    'report__dumps_total_size' => 'Dimensiune totală a fișierelor copie de rezervă',
    'report__section_resellers' => 'Reselleri',
    'report__active_resellers' => 'Reselleri cu abonamente active',
    'report__resellers' => 'Reselleri',
    'report__section_full_resellers' => 'Reselleri',
    'report__section_clients' => 'Clienți',
    'report__active_clients' => 'Clienți cu abonamente active',
    'report__clients' => 'Clienți',
    'report__section_full_clients' => 'Clienți',
    'report__section_personal_clients' => 'Clienți proprii',
    'report__active_personal_clients' => 'Clienții dvs. cu abonamente active',
    'report__personal_clients' => 'Clienți proprii',
    'report__section_full_personal_clients' => 'Clienți proprii',
    'report__section_domains' => 'Domenii',
    'report__disk_usage' => 'Utilizare disc',
    'report__traffic' => 'Trafic',
    'report__active_domains' => 'Domenii active',
    'report__domains' => 'Domenii',
    'report__subdomains' => 'Subdomenii',
    'report__mboxes' => 'Căsuțe poștale',
    'report__mail_groups' => 'Redirecționări de e-mailuri',
    'report__mail_autoresp' => 'Răspunsuri automate',
    'report__mail_lists' => 'Liste de e-mail',
    'report__web_users' => 'Utilizatori web',
    'report__mysql_databases' => 'Baze de date MySQL',
    'report__mssql_databases' => 'Baze de date MSSQL',
    'report__section_full_domains' => 'Domenii',
    'report__section_personal_domains' => 'Domenii personale',
    // keys here are the same as in report__section_domains section
    'report__section_full_personal_domains' => 'Domenii personale',

    //New for Plesk 10
    'report__sitebuilder_sites' => 'Site-uri publicate cu Presence Builder',
    'report__invalid_email' => 'Specificați o adresă de e-mail corectă.',


    // CLI-specific sections
    'report__section_hosting' => 'Găzduire',
    'report__section_webusers' => 'Utilizatori web',
    'report__section_mailnames' => 'Conturi de e-mail',
    'report__section_maillists' => 'Liste de e-mail',
    'report__section_databases' => 'Baze de date',
    'report__section_siteapps' => 'Aplicații web',
    'report__section_aspnetapps' => 'Aplicații ASP.NET', // PFW
    'report__owner_pname' => "Nume personal al furnizorului",
    'report__owner_login' => "Numele de utilizator al furnizorului",

    ///
    /// END OF SUMMARY / FULL REPORT
    ///

    ////
    //// KEYS FOR VARIOUS FEATURES
    ////

    ///
    /// SERVER INTERFACE
    ///

    // Locales
    // errors
    'locales__not_allowed' => 'Pachetul lingvistic specificat este instalat, dar nu este activat în sistem.',

    ///
    /// END OF SERVER INTERFACE
    ///

    ///
    /// HOME PAGE CUSTOMIZATION
    ///

    ///
    /// SESSIONS
    ///

    // Entry keys are under respective HP/ADDITIONAL TOOLS/ACTIVE SESSIONS

    // administrator
    'ui__sessions/delete__short-title' => 'Ștergere sesiuni',
    'ui__sessions/delete__title' => 'Ștergere sesiuni',
    'ui__sessions/delete__description' => 'Ștergerea sesiunilor selectate.',
    'ui__ftp-sessions__short-title' => 'Sesiuni FTP',
    'ui__ftp-sessions__title' => 'Sesiuni FTP',
    'ui__ftp-sessions__description' => 'Vizualizarea sesiunilor FTP.',
    'ui__ftp-sessions/delete__short-title' => 'Ștergere sesiuni FTP',
    'ui__ftp-sessions/delete__title' => 'Ștergere sesiuni FTP',
    'ui__ftp-sessions/delete__description' => 'Ștergerea sesiunilor FTP selectate.',
    'ui__ts-sessions__short-title' => 'Sesiuni TS',
    'ui__ts-sessions__title' => 'Sesiuni TS',
    'ui__ts-sessions__description' => 'Vizualizarea sesiunilor de serviciu terminal.',
    'ui__ts-sessions/properties__title' => 'Proprietățile sesiunii',

    // reseller
    'ui__reseller/sessions/delete__short-title' => 'Ștergere sesiuni',
    'ui__reseller/sessions/delete__title' => 'Ștergere sesiuni',
    'ui__reseller/sessions/delete__description' => 'Ștergerea sesiunilor selectate.',
    'ui__reseller/sessions/delete_self__short-title' => 'Ștergere sesiuni',
    'ui__reseller/sessions/delete_self__title' => 'Ștergere sesiuni',
    'ui__reseller/sessions/delete_self__description' => 'Ștergerea sesiunilor selectate.',
    'ui__reseller/ftp-sessions__short-title' => 'Sesiuni FTP',
    'ui__reseller/ftp-sessions__title' => 'Sesiuni FTP',
    'ui__reseller/ftp-sessions__description' => 'Vizualizarea sesiunilor FTP.',
    'ui__reseller/ftp-sessions_self__short-title' => 'Sesiuni FTP',
    'ui__reseller/ftp-sessions_self__title' => 'Sesiuni FTP',
    'ui__reseller/ftp-sessions_self__description' => 'Vizualizarea sesiunilor FTP.',
    'ui__reseller/ftp-sessions/delete__short-title' => 'Ștergere sesiuni FTP',
    'ui__reseller/ftp-sessions/delete__title' => 'Ștergere sesiuni FTP',
    'ui__reseller/ftp-sessions/delete__description' => 'Ștergerea sesiunilor FTP selectate.',
    'ui__reseller/ftp-sessions/delete_self__short-title' => 'Ștergere sesiuni FTP',
    'ui__reseller/ftp-sessions/delete_self__title' => 'Ștergere sesiuni FTP',
    'ui__reseller/ftp-sessions/delete_self__description' => 'Ștergerea sesiunilor FTP selectate.',

    // customer
    'ui__client/sessions/delete__short-title' => 'Ștergere sesiuni',
    'ui__client/sessions/delete__title' => 'Ștergere sesiuni',
    'ui__client/sessions/delete__description' => 'Ștergerea sesiunilor selectate.',
    'ui__client/sessions/delete_self__short-title' => 'Ștergere sesiuni',
    'ui__client/sessions/delete_self__title' => 'Ștergere sesiuni',
    'ui__client/sessions/delete_self__description' => 'Ștergerea sesiunilor selectate.',

    // domain administrator

    'forgery_token_expired' => 'Tokenul de sesiune a expirat.',

    ///
    /// END OF SESSIONS
    ///

    ///
    /// USER ACCOUNT CONVERSION
    ///

    //
    // USER ACCOUNT TYPE CHANGES
    //

    // resellers > customers
    'downgradeResellers__downgrade_resellers' => 'Următoarele conturi de reseller vor fi transformate în conturi client',
    'downgradeResellers__downgrade' => 'Conturi reseller pentru care se va face conversia',
    // controls
    'downgradeResellers__submit_downgrade' => 'Efectuarea conversiei contului.',
    'downgradeResellers__cancel_downgrade' => 'Revocarea conversiei contului.',
    'downgradeResellers__confirm' => 'Confirmare conversie',
    'downgradeResellers__confirm_message' => 'Confirmați conversia contului pentru a continua',
    // errors

    // customers > resellers
    'picker_client_multi__title' => 'Selectați conturile de client',
    'upgradeClients__upgrade_clients' => 'Următoarele conturi de client vor fi transformate în conturi reseller',
    'upgradeClients__upgrade' => 'Conturi de client pentru care se va face conversia',
    // controls
    'upgradeClients__submit_upgrade' => 'Efectuarea conversiei contului.',
    'upgradeClients__cancel_upgrade' => 'Revocarea conversiei contului.',
    'upgradeClients__confirm' => 'Confirmare conversie',
    'upgradeClients__confirm_message' => 'Confirmați conversia contului pentru a continua',
    // errors
    'upgradeClient__user_is_already_reseller' => 'Imposibil de transformat contul „%1” în cont de reseller: „%1” este deja reseller.',

    // domain administrators > customers
    'upgradeDomainUser__upgrade_domain_users' => 'Următoarele conturi de administrator de domeniu vor fi transformate în conturi de client',
    'upgradeDomainUser__upgrade' => 'Conturi de administrator de domeniu pentru care urmează să se realizeze conversia',
    // controls
    'upgradeDomainUser__submit_upgrade' => 'Efectuarea conversiei contului.',
    'upgradeDomainUser__cancel_upgrade' => 'Revocarea conversiei contului.',
    'upgradeDomainUser__confirm' => 'Confirmare conversie',
    'upgradeDomainUser__confirm_message' => 'Confirmați conversia contului pentru a continua',
    // errors
    'upgradeDomainUser__non_upgradeable' => 'Conturi de administrator de domeniu pentru care nu se poate face conversie',
    'upgradeDomainUser__non_upgradeable_domain_users' => 'Imposibil de transformat conturile de administrator de domeniu selectate în conturi de client:',
    'upgradeDomainUser__some_domains_were_not_converted' => 'Mai multe conturi de administrator de domeniu nu au putut fi transformate în conturi de client. %%domainsList%%',
    'upgradeDomainUser__domain_user_does_not_exist' => 'Contul de administrator de domeniu nu există',
    'upgradeDomainUser__domain_owner_must_be_a_reseller' => "Domeniul ar trebui să aparțină direct administratorului de server sau unui reseller.",
    'upgradeDomainUser__all_logins_already_used' => 'Imposibil de creat un cont pentru clientul rezultat.',
    // notifications
    'upgradeDomainUser__upgrade_notification_subject' => 'Contul de administrator de domeniu a fost transformat',
    'upgradeDomainUser__upgrade_notification_body' => 'Contul de administrator de domeniu a fost transformat în cont de client cu numele de utilizator „%%login%%” și cu parola „%%password%%”.',

    //
    // USER ACCOUNT OWNER CHANGES
    //

    // Customer owner change
    // customers selection - reseller & admin home
    'picker_client__title' => 'Selectați conturile de client',
    // errors
    'clientOwnerChanger__owner_has_no_permission' => 'Resellerul selectat nu are permisiune „%1”, dar unii dintre clienți au această permisiune.',
    'clientOwnerChanger__application_not_allowed' => 'Aplicația „%1” nu este disponibilă pentru resellerul selectat, dar este disponibilă pentru anumiți clienți.',

    // Domain owner change
    'ui__client/domain/chowner_multi-select__wizard-title' => 'Reatribuirea abonamentelor selectate',
    // errors
    'domain_chown__empty_selection' => 'Trebuie să alegeți un nou proprietar al domeniilor selectate',



    //
    // USER ACCOUNT STATE CHANGES
    //


    ///
    /// END OF USER ACCOUNT CONVERSION
    ///

    ///
    /// BANDWIDTH LIMITING
    ///

    'hosting_performance__title' => 'Performanță',
    'hosting_performance__traffic_bandwidth_legend' => 'Activare limitare lățime de bandă',
    'hosting_performance__traffic_bandwidth_legend_ro' => 'Limitare lățime de bandă',
    'hosting_performance__traffic_bandwidth_label' => 'Limită maximă de utilizare a lățimii de bandă (%1)',
    'hosting_performance__traffic_bandwidth_hint' => 'Limita de utilizare a lățimii de bandă se aplică doar la datele transferate prin protocolul HTTP.',
    'hosting_performance__max_connection_legend' => 'Activare limitare conexiuni',
    'hosting_performance__max_connection_legend_ro' => 'Limitare conexiuni',
    'hosting_performance__max_connection_label' => 'Conexiuni limitate la',
    'hosting_performance__max_connection_hint' => 'Dacă limitați utilizarea lățimii de bandă, că recomandăm să limitați și numărul de conexiuni simultane la site. În caz contrar, dacă se trimit frecvent solicitări către site, procesele de server web vor crește încărcarea serverului.',

    // errors:
    'performance__qos_not_installed' => 'Funcție dezactivată: QoS nu este instalat',
    'performance__bandwidth_throttling' => 'Nu puteți controla utilizarea lățimii de bandă pentru că nu este instalat QoS.',
    'performance__invalid_value' => "Valoarea este incorectă. Valoarea trebuie să fie cuprinsă între %1 și %2.",

    ///
    /// END OF BANDWIDTH LIMITING
    ///

    ///
    /// WEBMAIL SELECTION (these keys are currently PfU-only)
    ///

    'webmail__server_legend' => 'Webmail',
    'webmail__server_text' => 'Programe client de e-mail disponibile',
    'webmail__none' => 'Niciunul',

    ///
    /// END OF WEBMAIL SELECTION
    ///


    ////
    //// BACKUP/RESTORATION
    ////

    // random common keys:
    'backup__ip_mapping__server_ip' => 'Domeniu de adrese IP al serverului',

    ///
    /// END OF BACKUP MANAGER ACTIONS
    ///

    ///
    /// LISTS
    ///


    // Common info/errors:
    'migration_db_server_not_find' => 'Baza de date nu va fi restaurată: nu există niciun server de baze de date potrivit',

    ///
    /// END OF LISTS
    ///

    ///
    /// COMMON SCREENS
    ///

    // Back Up
    // Comments - __comments
    '__default_backup_comment_server' => "Copie de rezervă cu datele de pe server.",
    '__default_backup_comment_reseller' => "Copie de rezervă cu contul de reseller, creată de %1.",
    '__default_backup_comment_client' => "Copie de rezervă cu contul de client, creată de %1.",
    '__default_backup_comment_domain' => "Copie de rezervă cu abonamentul, creată de %1.",

    // Restoration & backup information

    // IP mapping
    'backup__ip_mapping__title' => 'Definirea mapării de adrese IP',
    'backup__ip_mapping__download' => 'Salvarea mapării IP curente în fișier',
    'b_backup__ip_mapping__download' => 'Faceți clic pentru descărcarea configurației de mapări IP.',
    'b_backup__ip_mapping__download_is_empty' => 'Configurarea de mapări IP este goală.',
    'backup__ip_mapping_upload__title' => 'Încărcarea fișierului de mapări IP',
    'backup__ip_mapping__upload' => 'Încărcarea fișierului de mapări IP',
    'b_backup__ip_mapping__upload' => 'Faceți clic pentru încărcarea configurației de mapări IP.',
    'backup__ip_mapping__list__header' => 'Mapare IP',
    'backup__ip_mapping__list__adddress' => 'Adrese IP vechi',
    'backup__ip_mapping__list__select_ip' => 'Adrese IP noi',
    'backup__ip_mapping__clients_ip' => "Domeniul de adrese IP al clientului %1",
    'backup__ip_mapping__resellers_ip' => "Domeniul de adrese IP al resellerului %1",
    'backup__ip_mapping__exclusive_ip_must_be_unique' => 'Adresele IP dedicate trebuie să fie mapate la adrese IP unice. Selectați o adresă IP unică pentru fiecare adresă IP dedicată din listă.',
    'backup__ip_mapping__legend' => 'Mapare IP',
    'backup__ip_mapping__upload_legend' => 'Încărcare',
    'backup__ip_mapping__upload_file_text' => 'Fișier de mapări IP',
    'backup__ip_mapping__upload_file_hint' => 'Fișierul de mapări IP este un fișier text. Fiecare rând al acestui fișier conține o mapare IP în următorul format: <adresa IP veche> <adresa IP nouă>',
    'backup__ip_mapping__ip_address_not_found' => 'Nu este disponibilă nicio adresă IP de acest tip.',
    'backup__ip_mapping__ip_address_not_found_hint' => 'Imposibil de transferat datele: Maparea de adrese IP este incompletă pentru că în domeniul de adrese IP al serverului destinație nu există nicio adresă liberă.',
    'backup__ip_mapping__ftp_will_be_disabled' => 'Conexiunile nesecurizate FTP vor fi interzise pentru domeniile cu această adresă IP.',
    'backup__ip_mapping__ftps_will_be_disabled' => 'Conexiunile securizate FTPS vor fi interzise pentru domeniile cu această adresă IP.',

    // Conflicts occured
    'legend_conflicts_occured' => 'Conflicte',
    'backup__restore__object_vhost' => 'Gazdă virtuală',
    'backup__restore__object_plesk_admin' => 'Administrator Plesk',
    'backup__restore__object_ftpuser' => 'Cont FTP',
    'backup__restore__object_frontpageuser' => 'Cont Frontpage',
    'backup__restore__object_webuser' => 'utilizator web',
    'backup__restore__object_domain' => 'domeniu',
    'backup__restore__object_subdomain' => 'subdomeniu',
    'backup__restore__object_domainalias' => 'alias de domeniu',
    'backup__restore__object_client' => 'client',
    'backup__restore__object_reseller' => 'reseller',
    'backup__restore__object_autoresponder' => 'răspuns automat',
    'backup__restore__object_mailalias' => 'alias de e-mail',
    'backup__restore__object_database' => 'bază de date',
    'backup__restore__object_mailname' => 'cont de e-mail',
    'backup__restore__object_db_user' => 'utilizator de baze de date',
    'backup__restore__object_ssl_certificate' => 'Certificat SSL/TLS',
    'backup__restore__resellers_cannot_restore_converted_to_customers' => 'Următorii reselleri nu pot fi restaurați pentru că au fost transformați în clienți: „%1”.',
    'backup__restore__customers_cannot_restore_converted_to_resellers' => 'Următorii clienți nu pot fi restaurați pentru că au fost transformați în reselleri: „%1”.',
    'backup__restore__customers_cannot_restore_moved_to_another_owners' => 'Următorii clienți nu pot fi restaurați pentru că au fost transferați la un alt proprietar: „%1”.',

    // Before migration starts
    'backup__restore__capability_not_enough_disk_text' => 'Spațiul disponibil pe discul serverului destinație este insuficient pentru transferul tuturor abonamentelor selectate. Disponibil: %1 MB. Necesar: %2 MB. Rețineți faptul că necesarul de spațiu se calculează ca sumă a spațiilor necesare pentru conținutul web, e-mail, respectiv bază de date din domenii. Necesarul de spațiu se calculează o singură dată pe zi și se păstrează în cache. Drept urmare, dimensiunile efective ale domeniilor pot fi diferite de cele calculate. Dacă v-ați asigurat că domeniile selectate nu necesită mai mult spațiu decât este disponibil, puteți continua procesul de transfer.',
    'backup__restore__capability_not_enough_disk_resolution' => 'Eliberați spațiu pe discul serverului destinație.',
    'backup__restore__capability_source_not_enough_disk_text' => 'Spațiu insuficient pe discul serverului sursă pentru stocarea fișierelor temporare necesare transferului. Disponibil: %1 MB. Necesar: %2 MB.',
    'backup__restore__capability_source_not_enough_disk_resolution' => 'Eliberați spațiu pe discul serverului sursă.',
    'backup__restore__capability_not_enough_disk_resolution_url_text' => 'Informații server',

    'backup__restore__capability_not_installed_component_text' => 'Componenta %1 nu este instalată pe serverul destinație. %1 nu va fi disponibilă pentru toate obiectele restaurate.',
    'backup__restore__capability_not_installed_component_resolution' => 'Instalați %1. Atenție: operația poate dura câteva minute.',
    'backup__restore__capability_existing_sys_user_text' => 'Pe serverul destinație există deja un utilizator de sistem cu numele %1.',
    'backup__restore__capability_existing_sys_user_resolution' => 'Redenumiți utilizatorul de sistem existent de pe serverul destinație.',
    'backup__restore__capability_license_usage_text' => 'În urma transferului de date, limitele de resurse menționate mai jos (definite de cheie de licență) vor fi depășite pe serverul destinație.',
    'backup__restore__capability_license_usage_resolution' => 'Instalați o altă cheie de licență pe serverul destinație, care asigură volumul de resurse necesar.',
    'backup__restore__capability_max_allowed_packet_text' => "Parametrul „max_allowed_packet” de pe serverul sursă de baze de date este %1, mai mare decât pe serverul destinație, unde este %2. Este posibil ca unele obiecte de bază de date din domeniile specificate mai jos să nu fie restaurate.",
    'backup__restore__capability_max_allowed_packet_resolution' => "Măriți valoarea „max_allowed_packet” pe serverul destinație de baze de date.",

    'backup__restore__capability_postgres_to_lower_version_text' => 'Imposibil de transferat bazele de date PostgreSQL, pentru că versiunea serverului PostgreSQL de pe serverul destinație este mai veche decât pe serverul sursă. Versiunea curentă este %1, fiind necesară versiunea %2.',
    'backup__restore__capability_postgres_to_lower_version_text_resolution' => 'Instalați versiunea de PostgreSQL necesară pe serverul destinație.',
    'backup__restore__capability_db_server_connection_problems' => 'Imposibil de conectat la serverul destinație de baze de date PostgreSQL. Bazele de date nu vor fi transferate decât dacă restabiliți conexiunea.',
    'backup__restore__capability_db_server_connection_problems_resolution' => 'Verificați setările de conectare de pe serverul destinație de baze de date.',
    'backup__restore__capability_component_not_enabled_server_wide_text' => 'Componenta %1 este dezactivată pe serverul destinație.',
    'backup__restore__capability_component_not_enabled_server_wide_resolution' => 'Porniți %1 pe serverul destinație.',
    'backup__restore__capability_not_configured_component_text' => 'Componenta %1 nu este configurată pe serverul destinație.',
    'backup__restore__capability_not_configured_component_resolution' => 'Configurați %1 în pagina Instrumente și setări.',

    'backup__restore__capability_webmail_is_not_available' => 'Serviciul de e-mail prin web %1 nu este disponibil pe serverul destinație. În locul acestuia Plesk va utiliza următorul serviciu de e-mail prin web: %2.',
    'backup__restore__capability_webmail_is_not_available_resolution' => 'Pentru a putea utiliza același serviciu de webmail ca pe serverul sursă, trebuie să-l instalați pe acest server.',
    'backup__restore__capability_webmail_is_not_installed_resolution' => 'Pentru a utiliza același serviciu de e-mail prin web ca pe serverul sursă, trebuie să-l instalați pe serverul destinație.',
    'backup__restore__capability_webmail_is_not_available_changed_on_subscriptions' => "Serviciul de e-mail prin web „%1” nu este disponibil pe serverul destinație. În locul acestuia, pentru abonamentele %3, Plesk va utiliza următorul serviciu de e-mail prin web: %2.",
    'backup__restore__capability_webmail_is_not_installed_custom_resolution' => 'Instalați pe serverul destinație serviciul de e-mail prin web necesar.',
    'backup__restore__capability_webmail_is_not_available_url_text' => 'Setări de e-mail prin web',

    'backup__restore__capability_shell_is_not_available' => 'Shellul %1 nu este disponibil pe serverul destinație. Se va utiliza unul dintre shellurile disponibile.',
    'backup__restore__capability_shell_is_not_available_resolution' => 'Pentru a utiliza același shell ca pe serverul sursă, trebuie să-l activați (în /etc/shells) sau să-l instalați pe serverul destinație.',

    'backup__restore__capability_acl_network_not_allowed_dns_template' => 'Serverul DNS destinație nu acceptă rețelele în șablonul de restricții de transfer. Nu se vor restaura înregistrările cu adresele IP ale rețelei trecute în restricțiile de transfer DNS.',
    'backup__restore__capability_acl_network_not_allowed_dns_zone' => 'Serverul DNS destinație nu acceptă rețelele în șablonul de restricții de transfer, dar unele abonamente au rețele trecute în restricțiile de transfer DNS. Nu se vor restaura înregistrările cu adresele IP ale rețelei trecute în restricțiile de transfer DNS.',

    'backup__restore__capability_wrong_php_handler_text' => 'Handlerul PHP %1 nu este disponibil pe serverul destinație. În locul acestuia Plesk va utiliza următorul handler PHP: %2.',
    'backup__restore__capability_wrong_php_handler_resolution' => 'Pentru a utiliza același handler PHP ca pe serverul sursă, trebuie să-l activați sau să-l instalați pe serverul destinație.',
    'bu_conflict_resolver_php_handler_replaced_in_plans' => 'Handlerul PHP %1 nu este disponibil. În locul acestuia Plesk va folosi %2 pentru următoarele planuri de servicii: {{objects}}',
    'bu_conflict_resolver_php_handler_replaced_in_sites' => 'Handlerul PHP %1 nu este disponibil. În locul acestuia Plesk va folosi %2 pentru următoarele site-uri web: {{objects}}',
    'bu_conflict_resolver_php_handler_not_allowed_in_sites' => 'Handlerul PHP %1 nu este disponibil. Nu va fi disponibil pentru următoarele site-uri web: {{objects}}',

    'backup__restore__capability_wrong_component_version_text' => 'Componenta %1 %2 nu este disponibilă pe serverul destinație. Se va utiliza versiunea implicită.',
    'backup__restore__capability_wrong_component_version_resolution' => 'Pentru a utiliza aceeași componentă %1 ca pe serverul sursă, trebuie să o activați sau să o instalați pe serverul destinație.',

    'backup__restore__capability_antivirus_not_allowed_outgoing_text' => 'Politica de utilizare antivirus pe serverul destinație nu permite setări antivirus personale (specifice adresei de e-mail) pentru mesajele trimise. Aceste setări nu vor fi transferate.',
    'backup__restore__capability_antivirus_not_allowed_incoming_text' => 'Politica de utilizare antivirus pe serverul destinație nu permite setări antivirus personale (specifice adresei de e-mail) pentru mesajele primite. Aceste setări nu vor fi transferate.',
    'backup__restore__capability_antivirus_not_allowed_personal_settings_text' => 'Politica de utilizare antivirus pe serverul destinație nu permite setări antivirus personale (specifice adresei de e-mail). Aceste setări nu vor fi transferate.',
    'backup__restore__capability_antivirus_not_allowed_personal_settings_resolution' => "Pentru a transfera setările antivirus personale (specifice adresei de e-mail), activați opțiunile corespunzătoare în Instrumente și setări> Setări de protecție antivirus.",
    'backup__restore__capability_antivirus_not_active_text' => 'Nu există software antivirus activat. Setările antivirus de pe serverul sursă nu vor funcționa până când nu selectați software-ul antivirus de pe serverul destinație.',
    'backup__restore__capability_antivirus_not_active_resolution' => 'Selectați software-ul antivirus în Instrumente și setări> Setări de protecție antivirus> secțiunea Setări antivirus.',

    'backup__restore__capability_antivirus_another_active_text' => 'Software-ul antivirus %2 nu este disponibil pe serverul destinație. Se va folosi %1.',
    'backup__restore__capability_antivirus_another_active_resolution' => 'Pentru a utiliza același antivirus ca pe serverul sursă, instalați-l, apoi selectați-l în Instrumente și setări> Setări de protecție antivirus> secțiunea Setări antivirus.',
    'backup__restore__capability_not_available_sni_text' => 'SNI nu este disponibil pe serverul destinație. Site-urile web care au aceeași adresă IP nu vor putea folosi certificate SSL/TLS individuale.',
    'backup__restore__capability_not_available_sni_resolution' => "Asigurați-vă că sistemul de operare de pe serverul destinație acceptă SNI și suportul pentru SNI este activat în Plesk (caseta de selectare „Activare suport SNI, ceea ce permite utilizarea unor certificate SSL/TLS individuale pe site-urile web cu aceeași adresă IP” în Instrumente și setări> Setări de server).",
    'backup__restore__capability_not_available_sni_resolution_url_text' => 'Setări de server',

    'backup__restore__capability_vhost_already_exists_text' => 'Site-ul web %1 nu se poate transfera: pe serverul destinație există deja un site cu același nume.',
    'backup__restore__capability_vhost_already_exists_resolution' => 'Redenumiți sau ștergeți site-ul web cu același nume de pe server.',
    'backup__restore__capability_removed_vhosts' => 'Următoarele abonamente nu vor fi restaurate, deoarece conțin numele de domenii care există deja pe serverul destinație: %1',
    'backup__restore__capability_duplicate_php_handler_text' => 'Pe serverul sursă sunt %3 programe handler PHP de tipul %1 și versiunea %2. În locul acestora, pe serverul destinație se va utiliza un program handler de tipul și versiunea corespunzătoare. Rețineți faptul că setările PHP de pe serverul sursă pot fi diferite de cele de pe serverul destinație.',

    'backup__restore__capability_not_installed_frontpage_resolution' => 'Plesk Installer nu acceptă Microsoft Frontpage.',
    'backup__restore__capability_not_installed_python_resolution' => 'Plesk Installer nu acceptă Python. Instalați manual Python.',

    'backup__restore__capability_mail_spamfilter_domain_keys_resolution_url_text' => 'Setări server de e-mail',

    'backup__restore__capability_ftps_disabled' => 'Utilizarea serviciului securizat FTPS este permisă pe serverul sursă, dar interzisă pe cel destinație. Este posibil să nu funcționeze corect acele aplicații ale utilizatorilor, care utilizează FTP.',
    'backup__restore__capability_ftps_required' => 'Utilizarea serviciului nesecurizat FTP este permisă pe serverul sursă, dar interzisă pe cel destinație. Este posibil să nu funcționeze corect acele aplicații ale utilizatorilor, care utilizează FTP.',
    'backup__restore__capability_ftps_policy_resolution' => 'Schimbați politica FTP securizat în Instrumente și setări> Politică de securitate.',

    'backup__restore__capability_too_much_download_time_text' => 'Se vor muta %1 megabyți de date de pe serverul sursă pe cel destinație, în %2 ore.',
    'backup__restore__capability_too_much_download_time_resolution' => 'Pentru ca transferul să se realizeze mai repede, verificați conexiunea prin rețea între serverele sursă și destinație și rezolvați eventualele probleme.',
    'backup__restore__too_low_download_speed' => "sub 0,01",
    'backup__restore__capability_too_slow_download_speed_resolution' => 'Pentru ca transferul să se realizeze mai repede, verificați conexiunea prin rețea între serverele sursă și destinație și rezolvați eventualele probleme.',
    'backup__restore__capability_zero_download_speed_text' => 'Viteza de descărcare minimă acceptabilă este de %1 MBps. Viteza de descărcare între serverele sursă și destinație este de 0 MBps. Cauza poate fi o problemă de conexiune prin rețea. Transferul nu este posibil.',
    'backup__restore__capability_zero_download_speed_resolution' => 'Verificați conexiunea prin rețea între serverele sursă și destinație și rezolvați problemele.',
    'backup__restore__capability_too_slow_download_speed_text' => 'Viteza de descărcare minimă acceptabilă este de %2 MBps. Viteza de descărcare între serverele sursă și destinație este de %1 MBps. Acest lucru poate prelungi timpul de transfer. În mediul actual, migrarea unui volum de %3 MB va dura %4 ore.',
    'backup__restore__capability_too_slow_download_speed_text_without_diskusage' => 'Viteza de descărcare minimă acceptabilă este de %2 MBps. Viteza de descărcare între serverele sursă și destinație este de %1 MBps. Acest lucru poate prelungi timpul de transfer.',

    'backup__restore__capability_remote_database_migration' => "Următoarele domenii utilizează baze de date la distanță: %1",
    'backup__restore__capability_remote_database_migration_resolution' => "Dacă versiunea Plesk de pe serverul sursă este mai veche decât 11.5, nu ștergeți aceste domenii de pe serverul sursă după transfer! În schimb, puteți să le suspendați. Dacă ștergeți domeniile, bazele de date vor fi șterse de pe serverul la distanță. Rețineți: Fișierele dump ale bazelor de date la distanță vor fi stocate pe serverul sursă în directorul %1.",

    'backup__restore__capability_mysql_50_to_51_migration' => 'Este posibil ca fișierele copie de rezervă ale serverelor de baze de date MySQL anterioare versiunii 5.1 (%1) să nu fie restaurate pe MySQL 5.1.x, întrucât MySQL 5.1.x lucrează altfel cu caracterele Unicode.',
    'backup__restore__capability_mysql_50_to_51_migration_resolution' => '',
    'backup__restore__capability_mysql_50_to_51_migration_kb_link_title' => 'Referitor la acest aspect, citiți articolul din baza de date #136850',

    'backup__restore__capability_firewall_not_installed_text' => 'Extensia Firewall nu este instalată pe serverul destinație. Dacă ați stabilit reguli de restricționare a accesului, acestea nu vor funcționa.',
    'backup__restore__capability_firewall_not_installed_resolution' => 'Instalați extensia Firewall folosind Plesk Installer.',
    'backup__restore__capability_courier_not_installed_text' => 'Courier-IMAP nu este instalat pe serverul destinație.',
    'backup__restore__capability_courier_not_installed_resolution' => 'Instalați Courier-IMAP folosind Plesk Installer.',
    'backup__restore__capability_dovecot_not_installed_text' => 'Dovecot nu este instalat pe serverul destinație.',
    'backup__restore__capability_dovecot_not_installed_resolution' => 'Instalați Dovecot folosind Plesk Installer.',

    'backup__restore__wrong_stat_ttl_value_text' => 'Perioada de păstrare a datelor statistice despre trafic, din configurările următoarelor obiecte, este mai mică decât setarea la nivelul serverului destinație.',
    'backup__restore__wrong_stat_ttl_value_resolution' => 'Modificați valoarea setării la nivel de server legate de timpul de păstrare a datelor statistice pe serverul destinație. Setați această perioadă la o valoare egală cu sau mai mică decât cea mai mică din configurațiile de domenii.',
    'bu_conflict_resolver_wrong_stat_ttl_value' => 'Perioada de păstrare a datelor statistice despre trafic, setată pentru unele domenii, este mai scurtă decât cea setată la nivel de server (%1). Pentru aceste domenii, valoarea va fi modificată în %1.',
    'bu_conflict_resolver_wrong_stat_ttl_template_value' => 'Perioada de păstrare a datelor statistice despre trafic, setată în anumite planuri de servicii, este mai scurtă decât cea setată la nivel de server (%1). Pentru aceste planuri de servicii, valoarea va fi modificată în %1.',

    'backup__ip_mapping__map_dedicated_to_shared_ip' => 'Maparea unei adrese IP exclusive la una partajate va duce la dezactivarea serviciilor FTP anonim și HTTPS (cu excepția cazului în care suportul SNI este activat).',

    'backup__restore__no_postgresql_commands_text' => 'Abonamentul utilizează o bază de date PostgreSQL la distanță. Nu se poate genera fișierul copie de rezervă temporar al acestuia, deoarece comenzile pg_dump și psql lipsesc de pe serverul sursă.',
    'backup__restore__no_postgresql_commands_resolution' => 'Instalați orice pachet de client PostgreSQL care acceptă aceste comenzi.',
    'backup__restore__capability_apache_modules_disabled_text' => 'Următoarele module Apache sunt dezactivate pe serverul destinație: %1.',
    'backup__restore__capability_apache_modules_disabled_resolution' => 'Activați aceste module pentru a preveni eventualele probleme.',
    'backup__restore__capability_apache_modules_not_installed_text' => 'Următoarele module Apache nu sunt instalate pe serverul destinație: %1.',
    'backup__restore__capability_apache_modules_not_installed_resolution' => 'Instalați și activați aceste module pentru a preveni eventualele probleme.',

    'backup__restore__capability_license_not_supported_outgoing_antispam' => 'Licența nu permite limitarea numărului de mesaje trimise. Setările de configurare corespunzătoare nu vor fi transferate.',
    'backup__restore__capability_license_not_supported_outgoing_antispam_resolution' => 'Instalați o altă cheie de licență pe serverul destinație, care asigură funcțiile necesare.',
    'backup__restore__capability_disabled_outgoing_antispam' => 'Limitarea numărului de mesaje trimise este dezactivată pe serverul destinație. Setările de configurare corespunzătoare nu vor fi transferate.',
    'backup__restore__capability_disabled_outgoing_antispam_resolution' => 'Activați limitarea numărului de mesaje trimise pe serverul destinație.',
    'backup__restore__capability_disabled_outgoing_antispam_resolution_url_text' => 'Setări de e-mail la nivel server',

    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported' => 'Limitarea numărului de mesaje trimise dintr-o căsuță poștală nu este acceptată de serverul de e-mail utilizat pe serverul destinație. Valoarea acestei limite nu va fi transferată.',
    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported_resolution' => 'Schimbați serverul de e-mail astfel încât să fie același ca pe serverul sursă.',
    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported_resolution_url_text' => 'Setări de e-mail la nivel server',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported' => 'Limitarea numărului de mesaje trimise dintr-un domeniu nu este acceptată de serverul de e-mail utilizat pe serverul destinație. Valoarea acestei limite nu va fi transferată.',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported_resolution' => 'Schimbați serverul de e-mail astfel încât să fie același ca pe serverul sursă.',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported_resolution_url_text' => 'Setări de e-mail la nivel server',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported' => 'Limitarea numărului de mesaje trimise dintr-un abonament nu este acceptată de serverul de e-mail utilizat pe serverul destinație. Valoarea acestei limite nu va fi transferată.',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported_resolution' => 'Schimbați serverul de e-mail astfel încât să fie același ca pe serverul sursă.',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported_resolution_url_text' => 'Setări de e-mail la nivel server',

    'bu_conflict_resolver_absent_phosting' => 'Imposibil de restaurat fișierele specificate: nu există găzduire fizică pentru restaurarea acestora. Creați întâi un domeniu cu găzduire fizică, apoi reporniți procesul de restaurare a copiei de rezervă.',
    'bu_conflict_resolver_resellers_management_is_not_supported' => 'Datele resellerilor nu se vor restaura pentru că administrarea resellerilor nu este acceptată.',

    'backup__restore__capability_modsecurity_not_installed_text' => 'Componenta ModSecurity nu este instalată pe serverul destinație.',
    'backup__restore__capability_modsecurity_not_installed_resolution' => 'Instalați ModSecurity pentru a menține în funcțiune firewallul de aplicații web pentru site-urile transferate. Atenție: instalarea poate dura câteva minute.',
    'backup__restore__capability_modsecurity_not_installed_resolution_for_server' => 'Instalați ModSecurity dacă doriți să transferați setările firewallului de aplicații web. Atenție: instalarea poate dura câteva minute.',
    'backup__restore__capability_modsecurity_not_configured_text' => 'Componenta ModSecurity nu este configurată pe serverul destinație.',
    'backup__restore__capability_modsecurity_not_configured_resolution' => 'Configurați ModSecurity dacă doriți să mențineți în funcțiune firewallul de aplicații web pentru site-urile transferate.',
    'backup__restore__capability_modsecurity_not_configured_resolution_url_text' => 'Firewall de aplicații web (ModSecurity)',
    'backup__restore__capability_modsecurity_not_active_text' => 'ModSecurity este dezactivat pe serverul destinație.',
    'backup__restore__capability_modsecurity_not_active_resolution' => 'Activați ModSecurity dacă doriți să mențineți în funcțiune firewallul de aplicații web pentru site-urile transferate.',
    'backup__restore__capability_modsecurity_not_active_resolution_url_text' => 'Firewall de aplicații web (ModSecurity)',
    'bu_conflict_resolver_modsecurity_not_installed' => 'Componenta ModSecurity nu este instalată. Setările de firewall de aplicații web nu vor fi restaurate pentru următoarele obiecte: {{objects}}',
    'bu_conflict_resolver_absent_websites_subscription' => "Site-urile web nu pot fi restaurate pentru că aparțin abonamentului %1, care nu se regăsește în Plesk.",
    'backup__restore__capability_not_installed_dns_text' => 'Componenta %1 nu este instalată pe serverul destinație. Serviciul DNS nu va fi disponibil. Setările DNS se vor pierde. Toate site-urile web ale clienților se vor opri.',
    'bu_conflict_resolver_dns_not_installed' => 'Serviciul DNS nu este instalat. Setările DNS nu vor fi restaurate pentru următoarele obiecte: {{objects}}',
    'backup__restore__subscriptions_cannot_restore_moved_to_another_owners' => 'Următoarele abonamente nu pot fi restaurate pentru că au fost transferate la alți proprietari: „%1”',
    'backup__restore__subscriptions_cannot_restore_moved_to_another_vendors' => 'Următoarele abonamente nu pot fi restaurate pentru că au fost transferate la alți furnizori: „%1”',
    'bu_conflict_resolver_sitebuilder_restore_util_is_not_installed' => 'Imposibil de găsit utilitarul de restaurare pentru Web Presence Builder pentru a restaura datele corespunzătoare. Probabil că Web Presence Builder nu este instalat.',
    'backup__restore__capability_renamed_db' => 'Numele de bază de date „%1” este utilizat deja de un alt abonament. Numele bazei de date restaurate va fi modificat în „%2”.',
    'backup__restore__capability_renamed_db_user' => 'Numele de utilizator de baze de date „%1” este utilizat deja de un alt abonament. Numele utilizatorului de baze de date restaurat va fi modificat în „%2”.',
    'backup__restore__capability_not_installed_perl_resolution' => 'Plesk Installer nu acceptă Perl. Instalați manual ActiveState Perl.',
    'backup__restore__capability_php_handler' => '%%version%% %%type%% (id=%%id%%)',
    'backup__restore__capability_php_handler_served_by_apache' => '%%version%% %%type%% deservit(ă) de Apache (id=%%id%%)',
    'backup__restore__capability_php_handler_served_by_nginx' => '%%version%% %%type%% deservit(ă) de nginx (id=%%id%%)',


    '__sni' => 'SNI',
    '__kav' => 'Antivirus Kaspersky',
    '__drweb' => 'Antivirus Odin Premium',

    // Timing conflicts
    'backup__restore__timing_conflicts' => 'Conflicte de sincronizare',
    'backup__restore__hint_timing_conflicts' => 'Conflictele de sincronizare apar atunci când obiectul restaurat există deja în sistem (cu o dată a modificării mai recentă) sau nu este prezent în sistem.',
    'backup__restore__text_timing_resolution_policy_overwrite' => 'Se utilizează configurările și datele din copia de rezervă',
    'backup__restore__hint_timing_resolution_policy_overwrite' => 'Se suprascriu toate configurările și datele obiectului, prezente în sistem, cu configurările și cu datele din fișierul copie de rezervă. Dacă obiectul restaurat aparține altui proprietar, se va restaura pentru proprietarul anterior.',
    'backup__restore__text_timing_resolution_policy_proceed' =>  'Se utilizează configurările din sistem și datele din copia de rezervă',
    'backup__restore__hint_timing_resolution_policy_proceed' => 'Se suprascriu datele obiectului curent cu datele din fișierul copie de rezervă, dar se păstrează configurările de obiect actuale din sistem. Dacă obiectul restaurat aparține altui proprietar, se va restaura pentru proprietarul curent.',
    'backup__restore__text_timing_resolution_policy_do_not_restore' => 'Nu se restaurează',
    'backup__restore__hint_timing_resolution_policy_do_not_restore' => 'Nu se restaurează obiectele care produc conflicte de sincronizare.',
    // Resource usage conflicts
    'backup__restore__resource_useage_conflicts' => 'Conflicte de utilizare a resurselor',
    'backup__restore__hint_resource_usage_conflicts' => 'Conflictele de utilizare a resurselor apar atunci când limitele de utilizare a resurselor impuse obiectului restaurat sunt depășite în urma restaurării.',
    'backup__restore__text_resource_usage_resolution_policy_overusage' => 'Se permite suprautilizarea',
    'backup__restore__hint_resource_usage_resolution_policy_overusage' => 'Refaceți obiectul și permiteți utilizarea acestuia de către mai multe resurse decât cele alocate inițial.',
    'backup__restore__text_resource_usage_resolution_policy_do_not_restore' => 'Nu se restaurează',
    'backup__restore__hint_resource_usage_resolution_policy_do_not_restore' => 'Nu se restaurează obiectele care produc conflicte de utilizare a resurselor.',
    // Configuration conflicts
    'backup__restore__configuration_conflicts' => 'Conflicte de configurare',
    'backup__restore__hint_configuration_conflicts' => 'Conflictele de configurare apar în cazul în care obiectul restaurat are setări și aplicații web care nu sunt disponibile sau sunt interzise de politica serverului sau al proprietarului obiectului. De exemplu, conflictele de configurare vor apărea în cazul în care conturile de e-mail au setări de spam individuale, în timp ce politica la nivel de server interzice aceste setări individuale.',
    'backup__restore__text_configuration_resolution_policy_automatic' => 'Automat',
    'backup__restore__hint_configuration_resolution_policy_automatic' => 'Se restaurează obiectul și se activează automat toate opțiunile de configurare conflictuale pe care aveți permisiunea să le administrați.',
    'backup__restore__text_configuration_resolution_policy_do_not_restore' => 'Nu se restaurează',
    'backup__restore__hint_configuration_resolution_policy_do_not_restore' => 'Nu se restaurează obiectele care produc conflicte de configurare.',

    'backup__restore__dedicated_app_pool_restore_to_shared_text' => 'Setările de liste de aplicații IIS nu permit listele de aplicații IIS dedicate.',
    'backup__restore__dedicated_app_pool_restore_to_shared_resolution' => 'Modificați setările legate de lista de aplicații IIS în Instrumente și setări> Listă de aplicații IIS> Setări globale.',
    'backup__restore__shared_app_pool_restore_to_dedicated_text' => 'Setările de liste de aplicații IIS nu permit listele de aplicații IIS partajate.',
    'backup__restore__shared_app_pool_restore_to_dedicated_resolution' => 'Modificați setările legate de lista de aplicații IIS în Instrumente și setări> Listă de aplicații IIS> Setări globale.',

    'backup__restore__unable_allow_short_pop3 _names_text' => 'Serverul destinație nu acceptă nume scurte ale conturilor de e-mail POP3/IMAP.',
    'backup__restore__unable_allow_short_pop3 _names_resolution' => 'După restaurarea datelor nu vor mai fi disponibile numele scurte ale conturilor de e-mail.',

    // Restore status messages & errors:
    'backup__unable_to_open_log_file' => 'Imposibil de deschis fișierul jurnal.',
    'backup__restore__customer_cannot_restore_nonexistent_subscription' => 'Imposibil de restaurat abonamentul %1: acesta a fost șters din contul dvs. și nu aveți permisiunea de a crea abonamente. Dacă trebuie să-l restaurați, luați legătura cu furnizorul de servicii.',

    'backup__error11' => 'Spațiu pe disc insuficient pentru crearea copiei de rezervă.',
    'backup__error3011' => 'Conexiunea a fost refuzată: Niciun program nu așteaptă conexiuni la adresa și la portul respectiv.',
    'backup__error3012' => 'Conexiunea a expirat.',
    'backup__error3013' => 'Rețeaua nu poate fi contactată.',
    'backup__error3014' => 'Nu există rută către gazdă.',
    'backup__error3015' => 'Conectarea nu a reușit.',
    'backup__error3016' => 'Imposibil de rezolvat numele de gazdă.',
    'backup__error3017' => 'Nume de utilizator sau parolă incorecte.',
    'backup__error3018' => 'Conectarea SSH nu a reușit.',

    'backup__error3110' => 'Imposibil de conectat la agentul de migrare la distanță: Nu este disponibilă conexiunea la gazdă.',
    'backup__error3111' => 'Agentul de migrare este blocat de o sarcină de migrare nereușită sau este utilizat de un alt proces de migrare. Reporniți serverul de migrare pe serverul sursă.',
    'backup__error3112' => 'Conexiunea la gazdă nu este disponibilă sau agentul de migrare nu se execută pe gazda sursă.',
    'backup__error3113' => 'Imposibil de implementat agentul de migrare pe o gazdă Linux. Verificați conexiunea SSH cu gazda sursă.',
    'backup__error3114' => 'Imposibil de implementat agentul de migrare pe o gazdă Linux: Conectarea SSH nu a reușit.',
    'backup__error3115' => 'Nume de utilizator sau parolă incorecte.',
    'backup__error3116' => 'Utilizatorul specificat nu are privilegii administrative.',

    'backup__scheduled_backup_settings__backup_of_domain_all_at_domain' => 'Toate configurările și datele',
    'backup__scheduled_backup_settings__backup_of_domain_vhost_only' => 'Toate configurările și toate datele, cu excepția e-mailului',
    'backup__scheduled_backup_settings__backup_of_domain_mail_only' => 'Doar configurările și datele de e-mail',

    'dns_t__unable_to_remove_ns_record' => 'Imposibil de șters înregistrarea NS din șablonul DNS: Fiecare zonă DNS trebuie să aibă cel puțin o înregistrare NS.',
    'dns__unsupported_server_zone_transfer' => 'Imposibil de transferat șablonul de restricții de transfer din cauza configurației DNS la nivel de server: Pe serverul sursă se permite transferul de zonă pentru următoarele adrese de rețea, dar aceste adrese sunt interzise de serverul DNS Microsoft : %1',
    'dns__unsupported_domain_zone_transfer' => 'Imposibil de transferat șablonul de restricții de transfer din cauza configurației DNS a domeniului: În unele domenii se permite transferul de zonă pentru următoarele adrese de rețea, dar aceste adrese sunt interzise de serverul DNS Microsoft: %1',
    ///
    /// END OF COMMON SCREENS
    ///

    ///
    /// DATABASE BACKUP - PFW // TBD
    ///

    // Actions

    'backup__db_mapping__title' => 'Definirea mapării serverelor de baze de date',
    'dbbackup__check_network_settings_failed' => 'Imposibil de accesat directorul de rețea temporar partajat pentru copiile de rezervă ale fișierelor. Verificați setările legate de directorul din rețea, de numele utilizatorului și de parolă. Eroare: %1',

    'migration_select_exist_db_server' => 'Selectați serverul destinație de baze de date',

    'dbbackup__temp_dir_wrong_value' => 'S-a specificat o valoare incorectă pentru directorul temporar.',
    'dbbackup__network_temp_dir_wrong_value' => 'S-a specificat o valoare incorectă pentru directorul de rețea temporar.',
    'dbbackup__server_backup_not_configured' => 'Setările de creare a copiilor de rezervă ale bazelor de date nu sunt configurate pe server.',
    'dbbackup__temp_dir' => 'Director temporar',
    'dbbackup__temp_dir_hint' => 'Calea către folderul fizic de pe serverul la distanță, în care se află serverul MS SQL. Serverul MS SQL trebuie să aibă acces la acest folder pentru a putea citi din și scrie în fișierele copie de rezervă temporare. De exemplu, C:\\CaleDirector',
    'dbbackup__network_temp_dir_hint' => 'Calea către locația partajată din rețea mapată la folderul fizic specificat de mai sus. Plesk va accesa folderul partajat pentru descărcarea și pentru încărcarea fișierelor copie de rezervă. De exemplu, \\\\NumeServer\\CaleDirector',
    'dbbackup__network_user_hint' => 'Numele utilizatorului de rețea creat pe serverul la distanță. De exemplu, NumeServer\\NumeUtilizator. Utilizatorul trebuie să aibă acces la folderul partajat specificat mai sus.',
    'dbbackup__network_password_hint' => 'Parola utilizatorului de rețea',

    'dbbackup__success_import_without_dublicate_users' => 'Nu au fost importați următorii utilizatori: %1. Aceștia există deja pe serverul de baze de date.',

    ///
    /// END OF DATABASE BACKUP
    ///

    ///
    /// LOGS & LOG ROTATION
    ///

    'log_rot__compress' => "Fișierele jurnal se comprimă",
    'log_rot__log_rot_status' => "Stare de rotație a jurnalului",
    'log_rot__log_rot_period' => "Condiție de rotație a jurnalelor",
    'log_rot__log_rot_size' => "în funcție de dimensiune",
    'log_rot__log_rot_time' => "în funcție de timp",
    'log_rot__logrotation_enable' => "Activarea rotației jurnalelor",
    'log_rot__mail' => "Trimiterea fișierelor jurnal procesate la adresa de e-mail",
    'log_rot__max_number_of_logfiles' => "Număr maxim de fișiere jurnal",
    'log_rot__time_period' => "perioada",
    'log_rot__unable_turn_off' => 'Nu se poate dezactiva rotația jurnalelor pentru că această setare este impusă la nivel de server',
    'log_rot__unable_set_period' => 'Nu se poate seta perioada de rotație a jurnalelor la altceva decât „zilnic”, pentru că această setare este impusă la nivel de server',
    'log_rot__unable_set_max_log_files' => 'Imposibil de setat un număr maxim de fișiere jurnal mai mare decât limita setată la nivel de server %1',

    /// action log
    // common/various
    'actionlog__digit_expected' => "Este necesar un număr: %1",
    'actionlog__incorrect_rotation' => "S-au specificat valori incorecte pentru parametrii de rotație a fișierelor jurnal: %1",
    'actionlog__unknown_rot_period' => "Perioadă de rotație necunoscută: %1",
    'actionlog__unknown_rot_type' => "Tip de rotație necunoscut: %1",
    'actionlog__session_preferences' => 'Setări de sesiune',
    // items (PFU schema)
    'actionlog__admin_info' => 'Informații administrator',
    'actionlog__admin_preferences' => "Preferințele administratorului",
    'actionlog__service' => 'Serviciu',
    'actionlog__ip_addr' => 'Adresă IP',
    'actionlog__client' => 'Cont de client',
    'actionlog__client_status' => 'Starea contului de client',
    'actionlog__client_preferences' => "Preferințe de interfață ale clientului",
    'actionlog__client_ip_pool' => "Domeniul de adrese IP al clientului",
    'actionlog__client_siteapp' => "Lista de aplicații web a clientului",
    'actionlog__client_guid' => "GUID client",
    'actionlog__domain' => 'Domeniu implicit (primul domeniu adăugat la un abonament)',
    'actionlog__domain_owner' => 'Proprietar abonament',
    'actionlog__domain_plan' => 'Planul de serviciu al abonamentului',
    'actionlog__domain_status' => 'Domeniu implicit, stare',
    'actionlog__domain_dns' => 'Domeniu implicit, zonă DNS',
    'actionlog__subdomain' => 'Subdomeniul unui domeniu implicit',
    'actionlog__domain_alias' => 'Domeniu implicit, alias',
    'actionlog__domain_alias_dns' => 'Domeniu implicit, zonă DNS a aliasului',
    'actionlog__site' => 'Domeniu',
    'actionlog__site_status' => 'Stare domeniu',
    'actionlog__site_dns' => 'Zona DNS a domeniului',
    'actionlog__site_guid' => 'GUID-ul domeniului',
    'actionlog__site_subdomain' => 'Subdomeniu',
    'actionlog__site_alias' => 'Alias de domeniu',
    'actionlog__site_alias_dns' => 'Zona DNS a aliasului de domeniu',
    'actionlog__domain_limits' => 'Limite abonament',
    'actionlog__domain_limit_size' => 'Limită de spațiu pe disc pentru abonament',
    'actionlog__domain_limit_traffic' => 'Limită de trafic pentru abonament',
    'actionlog__domain_limits_powerUser' => 'Limitele abonamentului',
    'actionlog__domain_limit_size_powerUser' => 'Limita de spațiu pe disc a abonamentului',
    'actionlog__domain_limit_traffic_powerUser' => 'Limita de trafic a abonamentului',
    'actionlog__domain_guid' => "Domeniu implicit, GUID",
    'actionlog__cp_user' => 'Utilizator Plesk',
    'actionlog__mailname' => 'Cont de e-mail',
    'actionlog__maillist' => 'Liste e-mail',
    'actionlog__phosting' => 'Setări de găzduire',
    'actionlog__forwarding' => 'Găzduire cu redirecționare standard sau cu cadre',
    'actionlog__webuser' => 'Cont de utilizator Web',
    'actionlog__site_application' => 'Aplicație web',
    'actionlog__license' => 'Cheie de licență',
    'actionlog__additional_license' => 'Cheie de licență suplimentară',
    'actionlog__template_domain' => "Planul de serviciu al resellerului",
    'actionlog__template_admin' => "Planul de serviciu al administratorului",
    'actionlog__template_reseller' => 'Planul resellerului',
    'actionlog__admin_alias' => 'Cont de administrator suplimentar', // PFW
    'actionlog__ftpuser' => 'Cont FTP suplimentar', // PFW
    'actionlog__db_server' => 'Server de baze de date',
    'actionlog__db' => 'Bază de date',
    'actionlog__db_user' => 'Cont utilizator bază de date',
    'actionlog__client_sapppkg_pool' => "Aplicația web a clientului", // PFW, not used?
    'actionlog__remote_dns' => 'Starea serverului DNS la distanță', // PFW
    'actionlog__reseller' => 'Cont de reseller',
    'actionlog__reseller_guid' => 'GUID de reseller',
    'actionlog__reseller_ip_pool' => "Domeniu de adrese IP al resellerului",
    'actionlog__reseller_limit_size' => 'Limită de spațiu pe disc a contului de reseller',
    'actionlog__reseller_limit_traffic' => 'Limită de trafic a contului de reseller',
    'actionlog__reseller_limits' => 'Limite cont reseller',
    'actionlog__reseller_permissions' => 'Permisiuni reseller',
    'actionlog__reseller_preferences' => "Preferințe de interfață reseller",
    'actionlog__reseller_siteapp' => "Aplicații web în lista resellerului",
    'actionlog__reseller_status' => 'Stare cont reseller',
    'actionlog__health_status' => 'Starea de bună funcţionare a serverului',
    // actions (PFU schema)
    'actionlog__limit_reached' => 'atingere',
    'actionlog__added' => 'adăugare',
    'actionlog__removed' => 'eliminare',
    'actionlog__change' => 'modificare',
    'actionlog__update' => 'actualizare',
    'actionlog__move' => 'mutat',
    'actionlog__upgrade' => 'upgrade', // PFU?
    'actionlog__update_or_add' => 'actualizare sau adăugare',
    'actionlog__expired' => 'expirare',
    'actionlog__create' => 'creare',
    'actionlog__delete' => 'ștergere',
    'actionlog__service_stop' => 'oprire',
    'actionlog__service_restart' => 'repornire',
    'actionlog__service_start' => 'pornire',
    'actionlog__login' => 'conectare deconectare',
    'actionlog__logout' => 'Listă de e-mail',
    'actionlog__install' => 'instalare',
    'actionlog__uninstall' => 'dezinstalare',
    'actionlog__reconfigure' => 'reconfigurare',
    // events (PFW schema)
    'actionlog__event_pw_reset' => 'Solicitare de resetare a parolei',
    'actionlog__event_admin_update' => 'Informațiile administrator au fost actualizate',
    'actionlog__event_admin_preferences_update' => "Preferințele administratorului au fost actualizate",
    'actionlog__event_service_restart' => 'Serviciul a fost repornit',
    'actionlog__event_service_start' => 'Serviciul a fost pornit',
    'actionlog__event_service_stop' => 'Serviciul a fost oprit',
    'actionlog__event_ip_address_create' => 'Adresa IP a fost creată',
    'actionlog__event_ip_address_delete' => 'Adresa IP a fost ștearsă',
    'actionlog__event_ip_address_update' => 'Adresa IP a fost actualizată',
    'actionlog__event_client_create' => 'Contul de client a fost creat',
    'actionlog__event_client_delete' => 'Contul de client a fost șters',
    'actionlog__event_client_update' => 'Contul de client a fost actualizat',
    'actionlog__event_client_status_update' => 'Starea contului de client a fost actualizată',
    'actionlog__event_client_preferences_update' => "Preferințele de interfață ale clientului au fost actualizate",
    'actionlog__event_client_siteapp_added' => "Aplicația web a fost adăugată în lista de aplicații a contului de client",
    'actionlog__event_client_siteapp_removed' => "Aplicația web a fost eliminată din lista de aplicații a contului de client",
    'actionlog__event_domain_limit_size_reached' => 'A fost atinsă limita de spațiu pe disc pentru abonament',
    'actionlog__event_domain_limit_traffic_reached' => 'A fost atinsă limita de trafic pentru abonament',
    'actionlog__event_domain_limit_size_reached_powerUser' => 'Limita de spațiu pe disc a abonamentului a fost atinsă',
    'actionlog__event_domain_limit_traffic_reached_powerUser' => 'Limita de trafic a abonamentului a fost atinsă',

    'actionlog__domain_limit_database' => 'Cotă de baze de date pentru abonament',
    'actionlog__event_domain_limit_mysql_quota_reached' => 'A fost atinsă cota de baze de date MySQL pentru abonament',
    'actionlog__event_domain_limit_mysql_soft_quota_reached' => 'A fost atinsă cota soft de baze de date MySQL pentru abonament',
    'actionlog__event_domain_limit_mssql_quota_reached' => 'A fost atinsă cota de baze de date Microsoft SQL Server pentru abonament',
    'actionlog__event_domain_limit_mssql_soft_quota_reached' => 'A fost atinsă cota soft de baze de date Microsoft SQL Server pentru abonament',
    'actionlog__event_plesk_component_upgrade' => 'Componenta Plesk a fost actualizată',
    'actionlog__event_plesk_component_install' => 'Componenta Plesk a fost instalată',
    'actionlog__event_plesk_component_uninstall' => 'Componenta Plesk a fost dezinstalată',
    'actionlog__event_domain_create' => 'Domeniul implicit (primul domeniu adăugat la un abonament) a fost creat',
    'actionlog__event_domain_delete' => 'Domeniul implicit (primul domeniu adăugat la un abonament) a fost șters',
    'actionlog__event_domain_update' => 'Domeniul implicit (primul domeniu adăugat la un abonament) a fost actualizat',
    'actionlog__event_domain_owner_change' => 'Proprietarul abonamentului a fost modificat',
    'actionlog__event_domain_plan_change' => 'Planul de serviciu al abonamentului s-a modificat',
    'actionlog__event_domain_status_update' => 'Domeniu implicit, starea a fost actualizată',
    'actionlog__event_domain_dns_update' => 'Domeniu implicit, zona DNS a fost actualizată',
    'actionlog__event_subdomain_create' => 'Subdomeniul unui domeniu implicit a fost creat',
    'actionlog__event_subdomain_delete' => 'Subdomeniul unui domeniu implicit a fost șters',
    'actionlog__event_subdomain_update' => 'Subdomeniul unui domeniu implicit a fost actualizat',
    'actionlog__event_domain_alias_create' => 'Domeniu implicit, aliasul a fost creat',
    'actionlog__event_domain_alias_delete' => 'Domeniu implicit, aliasul a fost șters',
    'actionlog__event_domain_alias_update' => 'Domeniu implicit, aliasul a fost actualizat',
    'actionlog__event_domain_limits_update' => 'Limitele abonamentului au fost actualizate',
    'actionlog__event_cp_user_login' => 'Utilizatorul Plesk s-a conectat',
    'actionlog__event_cp_user_logout' => 'Utilizatorul Plesk s-a deconectat',
    'actionlog__event_mailname_create' => 'Contul de e-mail a fost creat',
    'actionlog__event_mailname_delete' => 'Contul de e-mail a fost șters',
    'actionlog__event_mailname_update' => 'Contul de e-mail a fost actualizat',
    'actionlog__event_maillist_create' => 'Lista de e-mail a fost creată',
    'actionlog__event_maillist_delete' => 'Lista de e-mail a fost ștearsă',
    'actionlog__event_maillist_update' => 'Lista de e-mail a fost actualizată',
    'actionlog__event_phys_hosting_create' => 'Găzduirea fizică a fost creată',
    'actionlog__event_phys_hosting_delete' => 'Găzduirea fizică a fost ștearsă',
    'actionlog__event_phys_hosting_update' => 'Găzduirea fizică a fost actualizată',
    'actionlog__event_forwarding_create' => 'Găzduirea cu redirecționare standard sau cu cadre a fost creată',
    'actionlog__event_forwarding_delete' => 'Găzduirea cu redirecționare standard sau cu cadre a ștearsă',
    'actionlog__event_forwarding_update' => 'Găzduirea cu redirecționare standard sau cu cadre a fost actualizată',
    'actionlog__event_webuser_create' => 'Contul de utilizator web a fost creat',
    'actionlog__event_webuser_delete' => 'Contul de utilizator web a fost șters',
    'actionlog__event_webuser_update' => 'Contul de utilizator web a fost actualizat',
    'actionlog__event_siteapp_install' => 'Aplicația web a fost instalată',
    'actionlog__event_siteapp_reconfigure' => 'Aplicația web a fost reconfigurată',
    'actionlog__event_siteapp_uninstall' => 'Aplicația web a fost dezinstalată',
    'actionlog__event_license_update' => 'Cheia de licență a fost actualizată',
    'actionlog__event_admin_alias_create' => 'Contul de administrator suplimentar a fost creat',
    'actionlog__event_admin_alias_delete' => 'Contul de administrator suplimentar a fost șters',
    'actionlog__event_admin_alias_update' => 'Contul de administrator suplimentar a fost actualizat',
    'actionlog__event_ftpuser_create' => 'Contul FTP suplimentar a fost creat',
    'actionlog__event_ftpuser_update' => 'Contul FTP suplimentar a fost actualizat',
    'actionlog__event_ftpuser_delete' => 'Contul FTP suplimentar a fost șters',
    'actionlog__event_template_domain_create' => "Planul de serviciu al resellerului a fost creat",
    'actionlog__event_template_domain_update' => "Planul de serviciu al resellerului a fost actualizat",
    'actionlog__event_template_domain_delete' => "Planul de serviciu al resellerului a fost șters",
    'actionlog__event_template_admin_create' => "Planul de serviciu al administratorului a fost creat",
    'actionlog__event_template_admin_update' => "Planul de serviciu al administratorului a fost actualizat",
    'actionlog__event_template_admin_delete' => "Planul de serviciu al administratorului a fost șters",
    'actionlog__event_database_server_create' => 'Serverul de baze de date a fost creat',
    'actionlog__event_database_server_update' => 'Serverul de baze de date a fost actualizat',
    'actionlog__event_database_server_delete' => 'Serverul de baze de date a fost șters',
    'actionlog__event_remote_dns_status_update' => 'Starea serverului DNS la distanță a fost actualizată',
    'actionlog__event_session_preferences_update' => 'Setările de sesiune au fost actualizate',
    'actionlog__event_domain_alias_dns_update' => 'Domeniu implicit, zona DNS a aliasului de domeniu a fost actualizată',
    'actionlog__event_domain_move' => 'Domeniu implicit mutat în abonament nou',
    'actionlog__event_site_move' => 'Domeniu mutat în abonament nou',
    'actionlog__event_site_subdomain_move' => 'Subdomeniu mutat în abonament nou',
    'actionlog__event_subdomain_move' => 'Subdomeniul unui domeniu implicit mutat în abonament nou',
    'actionlog__event_license_expired' => 'Licența Plesk a expirat',
    'actionlog__event_database_create' => 'Baza de date a fost creată',
    'actionlog__event_database_delete' => 'Baza de date a fost ștearsă',
    'actionlog__event_database_user_create' => 'Contul de utilizator de bază de date a fost creat',
    'actionlog__event_database_user_update' => 'Setările contului de utilizator de bază de date au fost actualizate',
    'actionlog__event_database_user_delete' => 'Contul de utilizator de bază de date a fost șters',
    'actionlog__event_client_guid_update' => "GUID client a fost actualizat",
    'actionlog__event_domain_guid_update' => 'Domeniu implicit, GUID-ul a fost actualizat',
    'actionlog__event_reseller_create' => 'Contul de reseller a fost creat',
    'actionlog__event_reseller_delete' => 'Contul de reseller a fost șters',
    'actionlog__event_reseller_update' => 'Contul de reseller a fost actualizat',
    'actionlog__event_reseller_guid_update' => 'GUID-ul de reseller a fost actualizat',
    'actionlog__event_reseller_ip_pool_update' => "Domeniul de adrese IP al resellerului a fost actualizat",
    'actionlog__event_reseller_limit_size_reached' => 'A fost atinsă limita de spațiu pe disc a contului de reseller',
    'actionlog__event_reseller_limit_traffic_reached' => 'A fost atinsă limita de trafic a contului de reseller',
    'actionlog__event_reseller_limits_update' => 'Limitele contului de reseller au fost actualizate',
    'actionlog__event_reseller_permissions_update' => 'Permisiunile contului de reseller au fost actualizate',
    'actionlog__event_reseller_preferences_update' => "Au fost actualizate preferințele de interfață ale resellerului",
    'actionlog__event_reseller_siteapp_added' => "Aplicația a fost adăugată în lista de aplicații a resellerului",
    'actionlog__event_reseller_siteapp_removed' => "Aplicația a fost eliminată din lista de aplicații a resellerului",
    'actionlog__event_reseller_status_update' => 'Starea contului de reseller a fost actualizată',
    'actionlog__event_template_reseller_create' => 'Planul resellerului a fost creat',
    'actionlog__event_template_reseller_delete' => 'Planul resellerului a fost șters',
    'actionlog__event_template_reseller_update' => 'Planul resellerului a fost actualizat',
    'actionlog__event_health_status_change' => 'Starea de bună funcţionare a serverului a fost modificată',
    'actionlog__event_siteapp_upgrade' => 'S-a făcut upgrade la aplicația web',
    'actionlog__event_extension_install' => 'Instalarea extensiei s-a terminat',
    'actionlog__event_extension_uninstall' => 'Dezinstalarea extensiei s-a terminat',
    'actionlog__event_extension_upgrade' => 'Upgrade-ul de extensie a fost instalat corect',
    'actionlog__event_extension_status_update' => 'Starea extensiei a fost actualizată',
    'actionlog__event_additional_license_expired' => 'Cheia de licență suplimentară a expirat',
    'actionlog__event_hostname_changed' => 'Numele de gazdă al serverului s-a schimbat',
    'actionlog__event_smb_user_create' => 'Utilizator suplimentar creat',
    'actionlog__event_smb_user_delete' => 'Utilizator suplimentar șters',
    'actionlog__event_smb_user_update' => 'Utilizator suplimentar actualizat',

    // REMOTE SESSION
    'rsession_no_api_rpc_errmsg' => "RPC API Plesk nu este instalat pe serverul la distanță. Contactați furnizorul de servicii pentru a primi asistență.",
    'rsession_no_account_errmsg' => "Serviciul la distanță nu poate fi accesat din acest cont. Cel mai frecvent motiv este că serviciul nu este activat încă pentru acest cont. Așteptați câteva minute, apoi încercați din nou. Dacă eroarea apare din nou, contactați administratorul de sistem.",
    'rsession_no_domain_errmsg' => "Serviciul la distanță al acestui domeniu nu poate fi accesat. Cel mai frecvent motiv este că serviciul nu este activat încă pentru acest domeniu. Așteptați câteva minute, apoi încercați din nou. Dacă eroarea apare din nou, contactați administratorul de sistem.",
    'rsession_unknown_errmsg' => "Serverul la distanță a refuzat încercarea de inițiere a unei sesiuni. Contactați administratorul de sistem pentru a solicita ajutor. Eroarea a fost: %1",
    'rsession_unknown2_errmsg' => "Eroare la inițierea unei sesiuni la distanță. Probabil că serverul la distanță nu trimite un răspuns corespunzător sau nu răspunde deloc. Rugați administratorul de sistem să verifice detaliile erorii în jurnalul de erori al serverului web.",
    'rsession_no_connect_errmsg' => "Serviciul la distanță nu poate fi accesat: conectarea la sesiunea la distanță nu a reușit. Contactați administratorul de sistem pentru a solicita ajutor.",

    // ANONYMOUS FTP
    'anonftp__allow_upload_incoming' => "Se permite încărcarea de fișiere în directorul „incoming”",
    'anonftp__allow_create_dirs' => 'Se permite crearea de directoare în directorul „incoming”',
    'anonftp__allow_download_incoming' => 'Se permite descărcarea de fișiere din directorul „incoming”',
    'anonftp__display_login' => 'Afișare mesaj de conectare',
    'anonftp__login_text' => 'Textul mesajului',
    'anonftp__limit_incoming_disk_space' => "Limitarea spațiului pe disc în directorul de primire",
    'anonftp__limit_maximum_bandwidth' => "Limitarea lățimii de bandă la descărcare pentru acest domeniu FTP virtual",
    'anonftp__limit_maximum_connections' => "Limitarea numărului de conexiuni simultane",
    'anonftp__unable_init' => "Imposibil de inițializat contul FTP anonim: %1",
    'anonftp__unable_set_quota' => "Imposibil de setat limita de spațiu pe disc în directorul de primire: %1",
    'anonftp__unable_update' => "Imposibil de actualizat proprietățile contului FTP anonim: %1",

    ///
    /// SSL/TLS CERTIFICATES
    ///

    // common keys
    '__certificates' => 'Certificate SSL/TLS', // page title
    // errors
    'class_sslcertificate__ca_not_signs' => "Certificatul CA nu semnează certificatul.",
    'class_sslcertificate__incompatible_pvt_key_cert' => "Pereche incompatibilă: cheie privată/certificat.",
    'class_sslcertificate__invalid_cert_format' => "Format de certificat incorect.",
    'class_sslcertificate__invalid_private_key_format' => "Format de cheie privată incorect.",
    'class_sslcertificate__prob_invalid_priv_key' => "Probabil că formatul chei private este incorect.",

    ///
    ///END OF SSL/TLS CERTIFICATES
    ///

    ///
    /// WEB DIRECTORIES (PFW)
    ///

    //
    // DOMAIN
    //

    // Web Directories tab
    // Web Directories - ui__client/domain/hosting/web-directories__title (HOME/DOMAIN)
    'ui__client/domain/hosting/web-directories/create-virtual-dir__short-title' => 'Creare director virtual',
    'ui__client/domain/hosting/web-directories/create-virtual-dir__title' => 'Creare director virtual',
    'ui__client/domain/hosting/web-directories/create-virtual-dir__description' => 'Crearea unui director virtual.',
    'ui__client/domain/hosting/web-directories/create-virtual-dir_self__short-title' => 'Creare director virtual',
    'ui__client/domain/hosting/web-directories/create-virtual-dir_self__title' => 'Creare director virtual',
    'ui__client/domain/hosting/web-directories/create-virtual-dir_self__description' => 'Crearea unui director virtual.',
    'ui__client/domain/hosting/web-directories/create-dir__short-title' => 'Creare director',
    'ui__client/domain/hosting/web-directories/create-dir__title' => 'Creare director',
    'ui__client/domain/hosting/web-directories/create-dir__description' => 'Crearea unui director.',
    'ui__client/domain/hosting/web-directories/create-dir_self__short-title' => 'Creare director',
    'ui__client/domain/hosting/web-directories/create-dir_self__title' => 'Creare director',
    'ui__client/domain/hosting/web-directories/create-dir_self__description' => 'Crearea unui director.',
    'ui__client/domain/hosting/web-directories/properties__short-title' => 'Proprietăți director',
    'ui__client/domain/hosting/web-directories/properties__title' => 'Proprietăți director virtual',
    'ui__client/domain/hosting/web-directories/properties__description' => 'Vizualizarea și modificarea proprietăților directorului virtual.',
    'ui__client/domain/hosting/web-directories/properties_self__short-title' => 'Proprietăți director',
    'ui__client/domain/hosting/web-directories/properties_self__title' => 'Proprietăți director virtual',
    'ui__client/domain/hosting/web-directories/properties_self__description' => 'Vizualizarea și modificarea proprietăților directorului virtual.',
    'ui__client/domain/hosting/web-directories/permissions__short-title' => 'Permisiuni de acces de director',
    'ui__client/domain/hosting/web-directories/permissions__title' => 'Permisiuni de acces de director',
    'ui__client/domain/hosting/web-directories/permissions__description' => 'Setați permisiunile de acces la directoare.',
    'ui__client/domain/hosting/web-directories/permissions_self__short-title' => 'Permisiuni de acces de director',
    'ui__client/domain/hosting/web-directories/permissions_self__title' => 'Permisiuni de acces de director',
    'ui__client/domain/hosting/web-directories/permissions_self__description' => 'Setați permisiunile de acces la directoare.',
    'ui__client/domain/hosting/web-directories/aspdotnet__short-title' => 'Setări ASP.NET',
    'ui__client/domain/hosting/web-directories/aspdotnet__title' => 'Setări ASP.NET pentru %1',
    'ui__client/domain/hosting/web-directories/aspdotnet__description' => 'Configurarea setărilor ASP.NET pentru directorul virtual %1.',
    'ui__client/domain/hosting/web-directories/aspdotnet_self__short-title' => 'Setări ASP.NET',
    'ui__client/domain/hosting/web-directories/aspdotnet_self__title' => 'Setări ASP.NET pentru %1',
    'ui__client/domain/hosting/web-directories/aspdotnet_self__description' => 'Configurarea setărilor ASP.NET pentru directorul virtual %1.',
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version__short-title' => 'Modificare versiune',
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version__title' => 'Modificare versiune',
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version__description' => 'Modificarea versiunii ASP.NET utilizate de directorul virtual %1.',
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version_self__short-title' => 'Modificare versiune',
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version_self__title' => 'Modificare versiune',
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version_self__description' => 'Modificarea versiunii ASP.NET utilizate de directorul virtual %1.',
    'ui__client/domain/hosting/web-directories/php__short-title' => 'Setări PHP',
    'ui__client/domain/hosting/web-directories/php__title' => 'Setări PHP pentru %1',
    'ui__client/domain/hosting/web-directories/php__description' => 'Configurarea setărilor PHP pentru directorul virtual %1.',
    'ui__client/domain/hosting/web-directories/php_self__short-title' => 'Setări PHP',
    'ui__client/domain/hosting/web-directories/php_self__title' => 'Setări PHP pentru %1',
    'ui__client/domain/hosting/web-directories/php_self__description' => 'Configurarea setărilor PHP pentru directorul virtual %1.',

    // list object operations
    'ui__client/domain/hosting/web-directories/delete__short-title' => 'Ștergere',
    'ui__client/domain/hosting/web-directories/delete__title' => 'Ștergerea directoarelor virtuale',
    'ui__client/domain/hosting/web-directories/delete__description' => 'Ștergerea directoarelor virtuale selectate.',
    'ui__client/domain/hosting/web-directories/delete_self__short-title' => 'Ștergere',
    'ui__client/domain/hosting/web-directories/delete_self__title' => 'Ștergerea directoarelor virtuale',
    'ui__client/domain/hosting/web-directories/delete_self__description' => 'Ștergerea directoarelor virtuale selectate.',
    'ui__client/domain/hosting/web-directories/delete#legend__description' => 'Se vor șterge următoarele directoare virtuale:',
    'ui__client/domain/hosting/web-directories/delete__empty_selection' => 'Trebuie să selectați directoarele pe care doriți să le ștergeți.',

    // MIME Types tab
    'ui__client/domain/hosting/web-directories/mime-type_unknown__short-title' => 'Tipuri MIME',
    'ui__client/domain/hosting/web-directories/mime-type_unknown__title' => 'Tipuri MIME',
    'ui__client/domain/hosting/web-directories/mime-type_unknown__description' => 'Vizualizarea listei tipurilor MIME înregistrate.',
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__short-title' => 'Adăugare tip NIME',
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__title' => 'Adăugarea unui tip MIME',
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__description' => 'Înregistrarea unui nou tip MIME.',

    // Error documents tab
    'ui__client/domain/hosting/web-directories/error-doc_unknown__short-title' => 'Documente de eroare',
    'ui__client/domain/hosting/web-directories/error-doc_unknown__title' => 'Documente de eroare',
    'ui__client/domain/hosting/web-directories/error-doc_unknown__description' => 'Vizualizarea și modificarea documentelor de eroare.',

    // Protection tab
    'ui__client/domain/hosting/web-directories/protection__short-title' => 'Protecție',
    'ui__client/domain/hosting/web-directories/protection__title' => 'Protecție director',
    'ui__client/domain/hosting/web-directories/protection__description' => 'Restricționarea accesului la director prin protecție cu parolă.',
    'ui__client/domain/hosting/web-directories/protection_self__short-title' => 'Protecție',
    'ui__client/domain/hosting/web-directories/protection_self__title' => 'Protecție director',
    'ui__client/domain/hosting/web-directories/protection_self__description' => 'Restricționarea accesului la director prin protecție cu parolă.',
    'ui__client/domain/hosting/web-directories/protection/properties__short-title' => 'Setări',
    'ui__client/domain/hosting/web-directories/protection/properties__description' => 'Vizualizarea locației directorului și specificarea unui titlu pentru zona protejată.',
    'ui__client/domain/hosting/web-directories/protection/user/properties__title' => 'Setări de utilizator',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__title' => 'Adăugare utilizator',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__short-title' => 'Adăugare utilizator',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__description' => 'Adăugarea unui cont de utilizator pentru a permite accesul la directorul protejat.',
    'ui__client/domain/hosting/web-directories/protection/properties__done' => 'Noile setări au fost aplicate.',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__done' => 'Contul de utilizator a fost adăugat.',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__short-title' => 'Ștergere',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__description' => 'Ștergerea utilizatorilor directorului protejat.',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__title' => 'Ștergere conturi utilizator',
    'ui__client/domain/hosting/web-directories/protection/user/delete#legend__description' => 'Confirmarea ștergerii conturilor de utilizator.',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__done' => 'Conturile de utilizator au fost șterse.',

    //
    // SUBDOMAIN
    //

    // Web Directories tab

    // list object operations

    // MIME Types tab

    // Protection tab
    // Error documents tab

    ///
    /// END OF WEB DIRECTORIES
    ///

    ///
    /// SUBDOMAIN PAGE
    ///


    ///
    /// END OF SUBDOMAIN PAGE
    ///

    ///
    /// DONE MESSAGES
    ///

    // UI
    'ui____done' => 'Operație finalizată cu succes.',
    'ui__admin/extras-domain__done' => 'Pagina MyPlesk.com a fost deschisă.',
    'ui__admin/report/layout/delete_multi__done' => 'Aspectele de raport selectate au fost șterse.',
    'ui__admin/report/traffic-history__done' => 'Operație finalizată cu succes.',
    'ui__admin/report__done' => 'Operație finalizată cu succes.',
    'ui__admin-alias/delete_multi__done' => "Conturile suplimentare de administrator selectate au fost eliminate.",
    'ui__admin-alias/properties__done' => "Proprietățile contului de administrator suplimentar au fost actualizate.",
    'ui__admin-alias/properties_new__done' => "Cont de administrator suplimentar a fost creat.",
    'ui__admin-alias/properties_unknown__done' => "Proprietățile contului de administrator suplimentar au fost actualizate.",
    'ui__admin-alias__done' => "Informațiile contului de administrator suplimentar au fost actualizate.",
    'ui__admin/manage-domain__done' => 'Pagina MyPlesk.com a fost deschisă.',
    'ui__admin/register-domain__done' => 'Pagina MyPlesk.com a fost deschisă.',
    'ui__admin/report/layout/auto/delete_multi__done' => 'Planurile de trimitere a rapoartelor selectate au fost șterse.',
    'ui__admin/report/layout/auto/properties__done' => 'Planul de trimitere a rapoartelor a fost actualizat.',
    'ui__admin/report/layout/auto/properties_new__done' => 'Planul de trimitere a rapoartelor a fost creat.',
    'ui__admin/report/layout/properties__done' => 'Aspectul de raport %1 a fost actualizat.',
    'ui__admin/report/layout/properties_new__done' => 'Aspectul de raport %1 a fost creat.',
    'ui__client/domain/certificate/properties__done' => 'Proprietățile certificatului SSL/TLS au fost actualizate.',
    'ui__client/domain/certificate/properties_new__done' => 'A fost adăugat un nou certificat SSL/TLS. Pentru a-l face să funcționeze, nu uitați să-l selectați în setările de găzduire de site-uri web (în fila Site-uri web și domenii> numele domeniului).',
    'ui__client/domain/certificate__done' => 'Operație finalizată cu succes.',
    'ui__client/domain/certificate_self__done' => 'Operație finalizată cu succes.',
    'ui__client/domain/chowner__done' => 'Abonamentul %1 aparține acum unui alt utilizator.',
    'ui__client/domain/chowner_multi__done' => 'Proprietarul abonamentului a fost modificat.',
    'ui__client/domain/chowner_multi-select__done' => 'Operație finalizată cu succes.',
    'ui__client/domain/chowner_select__done' => 'Operație finalizată cu succes.',
    'ui__client/domain/dbbackup/create__done' => "Copia de rezervă a bazei de date a fost creată cu succes.", // PFW
    'ui__client/domain/dbbackup/get__done' => "Copia de rezervă a bazei de date a fost creată cu succes.", // PFW
    'ui__client/domain/dbbackup/orphaned__done' => "Utilizatorul trecut în stare de orfan a fost reparat cu succes.", // PFW
    'ui__client/domain/dbbackup/remove__done' => "Fișierele copie de rezervă au fost șterse cu succes.", // PFW
    'ui__client/domain/dbbackup/restore__done' => "Conținutul bazei de date a fost restaurat cu succes.", // PFW
    'ui__client/domain/dbbackup/upload__done' => "Operație finalizată cu succes.", // PFW
    'ui__client/domain/dbbackup__done' => "Operație finalizată cu succes.", // PFW
    'ui__client/domain/dbbackup_self__done' => "Operație finalizată cu succes.", // PFW
    'ui__client/domain/dbbackup_unknown__done' => "Operație finalizată cu succes.", // PFW
    'ui__client/domain/delete__done' => "Domeniul %1 a fost șters.",
    'ui__client/domain/delete_multi__done' => "Domeniile au fost șterse.",
    'ui__client/domain/disable__done' => 'Domeniul %1 a fost suspendat.',
    'ui__client/domain/disable_multi__done' => 'Domeniile selectate au fost suspendate.',
    'ui__client/domain/enable__done' => 'Site-ul web %1 a fost activat.',
    'ui__client/domain/enable_multi__done' => 'Site-urile web selectate au fost activate.',
    'ui__client/domain/extras__done' => 'Pagina MyPlesk.com a fost deschisă.',
    'ui__client/domain/extras_self__done' => 'Pagina MyPlesk.com a fost deschisă.',
    'ui__client/domain/hosting/file-manager/copy-move__done' => 'Fișierele și directoarele selectate au fost copiate sau mutate.',
    'ui__client/domain/hosting/file-manager/create-dir__done' => 'Directorul a fost creat.',
    'ui__client/domain/hosting/file-manager/create-file__done' => 'Fișierul a fost creat.',
    'ui__client/domain/hosting/file-manager/edit__done' => 'Fișierul a fost actualizat.',
    'ui__client/domain/hosting/file-manager/permissions__done' => 'Permisiunile de acces ale fișierului sau ale directorului au fost actualizate.', // PFU
    'ui__client/domain/hosting/file-manager/rename__done' => 'Directorul sau fișierul a fost redenumit.',
    'ui__client/domain/hosting/file-manager/remove__done' => 'Fișierele și directoarele selectate au fost șterse.',
    'ui__client/domain/hosting/file-manager/remove_self__done' => 'Fișierele și directoarele selectate au fost șterse.',
    'ui__client/domain/hosting/file-manager/view__done' => 'Operație finalizată cu succes.',
    'ui__client/domain/hosting/file-manager__done' => 'Operație finalizată cu succes.',
    'ui__client/domain/hosting/file-manager_self__done' => 'Operație finalizată cu succes.',
    'ui__client/domain/hosting/hotlink-protection__done' => 'Operație finalizată cu succes.', // PFW
    'ui__client/domain/hosting/hotlink-protection_self__done' => 'Operație finalizată cu succes.', // PFW
    'ui__client/domain/hosting/logs/rotation__done' => 'Setările de rotație ale jurnalului au fost modificate.',
    'ui__client/domain/hosting/logs/rotation_self__done' => 'Setările de rotație ale jurnalului au fost modificate.',
    'ui__client/domain/hosting/logs__done' => 'Operație finalizată cu succes.',
    'ui__client/domain/hosting/logs_self__done' => 'Operație finalizată cu succes.',
    'ui__client/domain/hosting/performance__done' => 'Setările de performanță ale găzduirii web pentru site-ul %1 au fost modificate.',
    'ui__client/domain/hosting/performance_self__done' => 'Setările de performanță ale găzduirii web pentru site au fost modificate.',
    'ui__client/domain/hosting/performance_unknown__done' => 'Setările de performanță ale găzduirii web au fost modificate.',
    'ui__client/domain/hosting/protected-directories__done' => 'Operație finalizată cu succes.',
    'ui__client/domain/hosting/protected-directories_self__done' => 'Operație finalizată cu succes.',
    'ui__client/domain/hosting/setup__done' => 'Găzduirea pentru %1 a fost configurată.',
    'ui__client/domain/hosting/ssh-terminal__done' => 'Operație finalizată cu succes.', // PFU
    'ui__client/domain/hosting/ssh-terminal_self__done' => 'Operație finalizată cu succes.', // PFU
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version__done' => 'Versiunea ASP.NET a fost modificată.', // PFW
    'ui__client/domain/hosting/web-directories/aspdotnet__done' => 'Setările ASP.NET pentru %1 au fost modificate.', // PFW
    'ui__client/domain/hosting/web-directories/create-dir__done' => 'Directorul virtual a fost creat în site-ul web %1.', // PFW
    'ui__client/domain/hosting/web-directories/create-virtual-dir__done' => 'Directorul virtual a fost creat.', // PFW
    'ui__client/domain/hosting/web-directories/delete__done' => 'Directoarele selectate au fost șterse.', // PFW
    'ui__client/domain/hosting/web-directories/delete_self__done' => 'Directoarele selectate au fost șterse.', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__done' => 'Documentele de eroare particularizate au fost actualizate.', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__done' => 'Tipurile MIME selectate au fost șterse', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__done' => 'A fost înregistrat un nou tip MIME.', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties__done' => 'Operație finalizată cu succes.', // PFW
    'ui__client/domain/hosting/web-directories/permissions__done' => 'Permisiunile de acces la directoare au fost actualizate.', // PFW
    'ui__client/domain/hosting/web-directories/permissions_self__done' => 'Permisiunile de acces la directoare au fost actualizate.', // PFW
    'ui__client/domain/hosting/web-directories/php__done' => 'Setările PHP pentru %1 au fost actualizate.', // PFW
    'ui__client/domain/hosting/web-directories/php_self__done' => 'Setările PHP pentru %1 au fost actualizate.', // PFW
    'ui__client/domain/hosting/web-directories/properties__done' => 'Proprietățile directorului au fost actualizate.', // PFW
    'ui__client/domain/hosting/web-directories/properties_self__done' => 'Proprietățile directorului au fost actualizate.', // PFW
    'ui__client/domain/hosting/web-directories/protection__done' => 'Setările de protecție a directorului au fost actualizate.', // PFW
    'ui__client/domain/hosting/web-directories/protection_self__done' => 'Setările de protecție a directorului au fost actualizate.', // PFW
    'ui__client/domain/hosting/web-directories__done' => 'Operație finalizată cu succes.', // PFW
    'ui__client/domain/hosting/web-directories_self__done' => "Operație finalizată cu succes.", // PFW
    'ui__client/domain/mpc-certificates__done' => 'Certificate SSL/TLS disponibile în spațiul de stocare online',
    'ui__client/domain/mpc-certificates_self__done' => 'Certificate SSL/TLS disponibile în spațiul de stocare online',
    'ui__client/domain/odbc__done' => 'Operație finalizată cu succes.', // PFW
    'ui__client/domain/odbc_self__done' => 'Operație finalizată cu succes.', // PFW
    'ui__client/domain/register__done' => 'Pagina MyPlesk.com a fost deschisă.',
    'ui__client/domain/register_self__done' => 'Pagina MyPlesk.com a fost deschisă.',
    'ui__client/domain/rename__done' => 'Numele domeniului a fost modificat.',
    'ui__client/domain/rename_self__done' => "Numele domeniului a fost modificat cu succes.",
    'ui__client/domain/settings_self__done' => 'Operație finalizată cu succes.',
    'ui__client/domain/toggle_disable__done' => "Domeniul %1 a fost suspendat.",
    'ui__client/domain/toggle_enable__done' => "Domeniul %1 a fost activat.",
    'ui__client/domain/traffic__done' => 'Operație finalizată cu succes.',
    'ui__client/domain/traffic_self__done' => 'Operație finalizată cu succes.',
    'ui__client/domain/traffic_unknown__done' => 'Operație finalizată cu succes.',
    'ui__client/domain-summary-report__done' => 'Operație finalizată cu succes.',
    'ui__client/domain-summary-report_self__done' => 'Operație finalizată cu succes.',
    'ui__client/domain-summary-report_unknown__done' => 'Operație finalizată cu succes.',
    'ui__client/extras-domain__done' => 'Pagina MyPlesk.com a fost deschisă.',
    'ui__client/extras-domain_self__done' => 'Pagina MyPlesk.com a fost deschisă.',
    'ui__client/ipaddress/delete_multi__done' => 'Operație finalizată cu succes.',
    'ui__client/ipaddress/properties__done' => 'Operație finalizată cu succes.',
    'ui__client/ipaddress/properties_new__done' => 'Operație finalizată cu succes.',
    'ui__client/ip-pool/properties__done' => "Domeniul de adrese IP al clientului %1 a fost actualizat.",
    'ui__client/ip-pool/properties_self__done' => 'Operație finalizată cu succes.',
    'ui__client/limits__done' => "Limitele de resurse aferente clientului %1 au fost modificate.",
    'ui__client/limits_self__done' => 'Operație finalizată cu succes.',
    'ui__client/logo__done' => 'Noile setări de branding ale clientului %1 au fost aplicate.',
    'ui__client/logo_reseller__done' => 'Noile setări de branding pentru panou au fost aplicate.',
    'ui__client/logo_self__done' => 'Setările de branding au fost aplicate.',
    'ui__client/logo_self-reseller__done' => 'Setările de branding pentru panou au fost aplicate.',
    'ui__client/manage-domain__done' => 'Pagina MyPlesk.com a fost deschisă.',
    'ui__client/manage-domain_self__done' => 'Pagina MyPlesk.com a fost deschisă.',
    'ui__client/permissions__done' => "Permisiunile clientului %1 au fost modificate.",
    'ui__client/permissions_self__done' => 'Operație finalizată cu succes.',
    'ui__client/preferences__done' => "Preferințele clientului %1 au fost modificate.",
    'ui__client/preferences_self__done' => "Preferințele dvs. au fost modificate.",
    'ui__client/register-domain__done' => 'Pagina MyPlesk.com a fost deschisă.',
    'ui__client/register-domain_self__done' => 'Pagina MyPlesk.com a fost deschisă.',
    'ui__client/report/traffic-history__done' => 'Operație finalizată cu succes.',
    'ui__client/report/traffic-history_self__done' => 'Operație finalizată cu succes.',
    'ui__client/report__done' => 'Operație finalizată cu succes.',
    'ui__client/report_self__done' => 'Operație finalizată cu succes.',
    'ui__client/sessions/delete__done' => 'Operație finalizată cu succes.',
    'ui__client/sessions/delete_self__done' => 'Operație finalizată cu succes.',
    'ui__client/sessions__done' => 'Operație finalizată cu succes.',
    'ui__client/sessions_self__done' => 'Operație finalizată cu succes.',
    'ui__client/skeleton__done' => 'Operație finalizată cu succes.',
    'ui__client/skeleton_self__done' => 'Operație finalizată cu succes.',
    'ui__client/traffic__done' => "Operație finalizată cu succes.",
    'ui__client/traffic_unknown__done' => 'Operație finalizată cu succes.',
    'ui__cp-access__done' => 'Operație finalizată cu succes.',
    'ui__cp-session/properties__done' => 'Operație finalizată cu succes.',
    'ui__cp-session__done' => 'Operație finalizată cu succes.',
    'ui__ftp-sessions__done' => 'Operație finalizată cu succes.',
    'ui__license__done' => 'Operație finalizată cu succes.',
    'ui__logo__done' => "Proprietățile de branding ale sistemului Plesk au fost modificate.",
    'ui__longtasks/longtask/properties__done' => "Setările de sarcini executate în fundal au fost modificate cu succes.",
    'ui__mass-email/delete__done' => "Șablonul %1 a fost șters.", // PFW
    'ui__mass-email/delete_multi__done' => "Șabloanele de mesaj au fost șterse.",  // PFW
    'ui__mass-email/send_main__done' => "Operație finalizată cu succes.",  // PFW
    'ui__mass-email/send_selectclients__done' => "Conturile de client au fost selectate cu succes.",  // PFW
    'ui__mass-email/send_selectdomainusers__done' => "Conturile de administrator de domeniu au fost selectate cu succes.",  // PFW
    'ui__mass-email/send_selectresellers__done' => 'Conturile de reseller au fost selectate cu succes.',  // PFW
    'ui__mass-email/template/properties_main__done' => 'Modificările șablonului de mesaje e-mail în masă au fost salvate.', // PFW
    'ui__mass-email/template/properties_new-main__done' => 'Șablonul de mesaje e-mail în masă a fost creat.', // PFW
    'ui__mass-email/template/properties_new-selectclients__done' => 'Conturile de client corespunzătoare șablonului de mesaje e-mail în masă au fost selectate.',  // PFW
    'ui__mass-email/template/properties_new-selectdomainusers__done' => 'Conturile de administrator de domeniu corespunzătoare șablonului de mesaje e-mail în masă au fost selectate.', // PFW
    'ui__mass-email/template/properties_new-selectresellers__done' => 'Conturile de reseller corespunzătoare șablonului de mesaje e-mail în masă au fost selectate.',  // PFW
    'ui__mass-email/template/properties_unknown__done' => "Șablonul de mesaje e-mail în masă a fost modificat.",  // PFW
    'ui__mass-email/template/properties__invalid_values' => 'Au fost specificate valori incorecte.', // PFW
    'ui__mass-email__done' => "Operație finalizată cu succes.", // PFW
    'ui__mass-mail__done' => "Operație finalizată cu succes.", // PFU
    'ui__mass-mail/delete__done' => 'Șablonul %1 a fost șters.', // PFU
    'ui__mass-mail/delete_multi__done' => 'Șabloanele de mesaj au fost șterse.', // PFU
    'ui__mass-mail/properties__done' => 'Șablonul %1 a fost modificat.', // PFU
    'ui__mass-mail/properties_new__done' => 'Șablonul %1 a fost creat.', // PFU
    'ui__mass-mail/send__done' => 'Mesajele au fost trimise.', // PFU
    'ui__mass-mail/send_new__done' => 'Mesajele au fost trimise.', // PFU
    'ui__mass-mail/send_unknown__done' => 'Mesajele au fost trimise.',  // PFU
    'ui__mass-mail/send_unknown-new__done' => 'Mesajele au fost trimise.', // PFU
    'ui__mass-mail/template/properties_new__done' => 'Noul șablon de mesaje a fost creat.', // PFU
    'ui__mass-mail/template/properties__done' => 'Șablonul de mesaje a fost modificat.', // PFU
    'ui__modules/watchdog/disk/properties__done' => 'Noile setări de monitorizare a discului au fost aplicate.', // PFU
    'ui__modules__done' => 'Operație finalizată cu succes.',
    'ui__modules__short-title' => 'Extensii',
    'ui__modules__title' => 'Extensii',
    'ui__reseller/client/traffic_unknown__done' => 'Operație finalizată cu succes.',
    'ui__reseller/extras-domain__done' => 'Pagina MyPlesk.com a fost deschisă.',
    'ui__reseller/extras-domain_self__done' => 'Pagina MyPlesk.com a fost deschisă.',
    'ui__reseller/ftp-sessions_self__done' => 'Operație finalizată cu succes.',
    'ui__reseller/limits__done' => "Limitele de resurse și politicile de utilizare a resurselor, valabile pentru reseller, au fost modificate.",
    'ui__reseller/limits_readonly-self__done' => 'Operație finalizată cu succes.',
    'ui__reseller/limits_self__done' => 'Limitele de resurse și politicile de utilizare a resurselor, valabile pentru dvs., au fost modificate.',
    'ui__reseller/manage-domain__done' => 'Pagina MyPlesk.com a fost deschisă.',
    'ui__reseller/manage-domain_self__done' => 'Pagina MyPlesk.com a fost deschisă.',
    'ui__reseller/permissions__done' => 'Permisiunile resellerului %1 au fost modificate.',
    'ui__reseller/permissions_readonly-self__done' => '',
    'ui__reseller/permissions_self__done' => 'Operație finalizată cu succes.',
    'ui__reseller/register-domain__done' => 'Pagina MyPlesk.com a fost deschisă.',
    'ui__reseller/register-domain_self__done' => 'Pagina MyPlesk.com a fost deschisă.',
    'ui__reseller/report/layout/auto/delete_multi__done' => 'Planurile de trimitere a rapoartelor selectate au fost șterse.',
    'ui__reseller/report/layout/auto/properties__done' => 'Planul de trimitere a rapoartelor a fost actualizat.',
    'ui__reseller/report/layout/auto/properties_new__done' => 'Planul de trimitere a raportului a fost adăugat.',
    'ui__reseller/report/layout/properties__done' => 'Aspectul de raport a fost modificat.',
    'ui__reseller/report/layout/properties_new__done' => 'A fost creat un aspect de raport nou.',
    'ui__reseller/report/traffic-history__done' => 'Operație finalizată cu succes.',
    'ui__reseller/report/traffic-history_self__done' => 'Operație finalizată cu succes.',
    'ui__reseller/report__done' => 'Operație finalizată cu succes.',
    'ui__reseller/report_self__done' => 'Operație finalizată cu succes.',
    'ui__reseller/sessions/delete__done' => 'Operație finalizată cu succes.',
    'ui__reseller/sessions/delete_self__done' => 'Operație finalizată cu succes.',
    'ui__reseller/sessions__done' => 'Operație finalizată cu succes.',
    'ui__reseller/sessions_self__done' => 'Operație finalizată cu succes.',
    'ui__reseller/traffic__done' => 'Operație finalizată cu succes.',
    'ui__reseller/traffic_self__done' => 'Operație finalizată cu succes.',
    'ui__reseller/traffic_unknown__done' => 'Operație finalizată cu succes.',
    'ui__reseller/logo_self__title' => 'Branding de sistem Plesk',
    'ui__reseller/logo_self__done' => 'Setările de branding Plesk au fost aplicate.',
    'ui__server/aspdotnet__done' => 'Setările ASP.NET la nivel de server au fost modificate.', // PFW
    'ui__server/certificate/default_multi__done' => 'Certificatul SSL/TLS selectat a fost configurat pentru securizarea conexiunilor la site-urile nou găzduite.',
    'ui__server/certificate/delete_multi__done' => 'Certificatele SSL/TLS selectate au fost șterse.',
    'ui__server/certificate/download__done' => 'Certificatul SSL/TLS a fost descărcat.',
    'ui__server/certificate/properties__done' => 'Proprietățile certificatului SSL/TLS au fost actualizate.',
    'ui__server/certificate/properties_new__done' => 'Certificatul SSL/TLS %1 a fost creat.',
    'ui__server/certificate/setup_multi__done' => 'Certificatul SSL/TLS selectat a fost configurat pentru securizarea conexiunilor la Plesk.',
    'ui__server/certificate__done' => 'Operație finalizată cu succes.',
    'ui__server/cp-certificate-download__done' => "Certificatul SSL/TLS al Plesk a fost descărcat.",
    'ui__server/crontab/properties__done' => 'Sarcinile programate pentru %1 au fost modificate.',
    'ui__server/crontab/task/delete__done' => 'Sarcina a fost ștearsă.',
    'ui__server/crontab/task/delete_multi__done' => 'Sarcinile au fost șterse.',
    'ui__server/crontab/task/properties__done' => 'Sarcinile programate au fost actualizate.',
    'ui__server/crontab/task/properties_new__done' => 'A fost programată o sarcină nouă.',
    'ui__server/crontab/task/toggle_disable__done' => 'Sarcina programată %1 a fost dezactivată.',
    'ui__server/crontab/task/toggle_enable__done' => 'Sarcina programată %1 a fost activată.',
    'ui__server/crontab__done' => 'Operație finalizată cu succes.',
    'ui__server/dns__done' => 'Operație finalizată cu succes.',
    'ui__server/ip-address/client/delete__done' => "Adresa IP a fost ștearsă din domeniul de adrese IP al utilizatorului.",
    'ui__server/ip-address/client/delete_multi__done' => "Adresa IP a fost ștearsă din domeniile de adrese IP ale utilizatorului.",
    'ui__server/ip-address/client/properties_new__done' => 'Adresa IP a fost atribuită utilizatorilor.',
    'ui__server/ip-address/ip-address/add-to-clients_add-target__done' => 'Adresa IP %1 a fost atribuită clienților selectați.',
    'ui__server/ip-addresses__done' => "Operație finalizată cu succes.",
    'ui__server/mail/statistics/spam/recipients__done' => "Operație finalizată cu succes.",
    'ui__server/mail/statistics/spam/summary__done' => "Operație finalizată cu succes.",
    'ui__server/mail/statistics/spam__done' => "Operație finalizată cu succes.",
    'ui__server/mail/statistics/virus/recipients__done' => "Operație finalizată cu succes.",
    'ui__server/mail/statistics/virus/summary__done' => "Operație finalizată cu succes.",
    'ui__server/mail/statistics/virus/viruses__done' => "Operație finalizată cu succes.",
    'ui__server/mail/statistics/virus__done' => "Operație finalizată cu succes.",
    'ui__server/mail/statistics__done' => "Operație finalizată cu succes.",
    'ui__server/mail__done' => 'Setările serverului de e-mail au fost modificate.',
    'ui__server/maillists__done' => 'Operație finalizată cu succes.',
    'ui__server/mpc-certificates__done' => 'A fost deschisă pagina spațiului de stocare online cu lista certificatelor SSL/TLS disponibile.',
    'ui__server/odbc__done' => 'Setările ODBC la nivel de server au fost modificate.', // PFW
    'ui__server/pmm__done' => 'Operație finalizată cu succes.',
    'ui__server/preferences__done' => "Setările serverului au fost modificate.",
    'ui__server/register__done' => 'Pagina MyPlesk.com a fost deschisă.',
    'ui__server/services__done' => 'Operație finalizată cu succes.',
    'ui__server/sitebuilder__done' => 'Operație finalizată cu succes.',
    'ui__server/skeleton__done' => 'Operație finalizată cu succes.',
    'ui__server/spam-filter/black-list/address/delete__done' => 'Adresa %1 a fost eliminată din lista neagră la nivel de server.',
    'ui__server/spam-filter/black-list/address/delete_multi__done' => 'Adresele au fost eliminate din lista neagră la nivel de server.',
    'ui__server/spam-filter/black-list/address/properties_new__done' => 'Adresele au fost adăugate în lista de neagră.',
    'ui__server/spam-filter/black-list/address__done' => 'Adresele au fost adăugate în lista de neagră.',
    'ui__server/spam-filter/black-list__done' => 'Operație finalizată cu succes.', // PFU
    'ui__server/spam-filter/properties__done' => 'Setările filtrului antispam au fost modificate.',
    'ui__server/spam-filter/toggle_disable__done' => 'Filtrarea antispam a fost dezactivată la nivel de server.',
    'ui__server/spam-filter/toggle_enable__done' => 'Filtrarea antispam a fost activată la nivel de server.',
    'ui__server/spam-filter/white-list/address/delete__done' => 'Adresa %1 a fost eliminată din lista albă la nivel de server.',
    'ui__server/spam-filter/white-list/address/delete_multi__done' => 'Adresele au fost eliminate din lista albă la nivel de server.',
    'ui__server/spam-filter/white-list/address/properties_new__done' => 'Adresele au fost adăugate în lista de permisiuni.',
    'ui__server/spam-filter/white-list/address__done' => 'Adresele au fost adăugate la lista albă.',
    'ui__server/spam-filter/white-list__done' => 'Operație finalizată cu succes.', // PFU
    'ui__server/spam-filter__done' => 'Operație finalizată cu succes.',
    'ui__server/statistics__done' => 'Operație finalizată cu succes.',
    'ui__server/time__done' => "Data și ora sistemului au fost modificate.",
    'ui__server__done' => "Operație finalizată cu succes.",
    'ui__sessions/properties__done' => 'Operație finalizată cu succes.',
    'ui__sessions__done' => 'Operație finalizată cu succes.',
    'ui__sessions/delete__done' => 'Sesiunile selectate au fost șterse.',
    'ui__start-page__done' => 'Operație finalizată cu succes.',
    'ui__support__done' => 'Formularul de solicitare a asistenței a fost deschis într-o fereastră sau filă de browser nouă.',
    'ui__ts-sessions__done' => 'Operație finalizată cu succes.',

    ///
    /// END OF DONE MESSAGES
    ///

    ///
    /// ASSORTED COMMON KEYS / TBI
    ///

    // non-UI
    '__no_files_to_upload' => 'Niciun fișier de încărcat.',
    'login_up__access_denied_no_permission' => "Acces interzis. Nu aveți permisiunea să vă conectați.",
    'mail__unable_remove_pattern' => "Adresa nu poate fi ștearsă din lista neagră a serverului: %1", // PFW
    'mail__incorrect_network_format' => 'Format de rețea incorect: %1', // PFW
    'initconf__unable_change_passwd' => "Imposibil de schimbat parola de administrator: %1",
    'initconf__unable_get_passwd' => 'Nu se poate obține parola de administrator actuală: %1 nu a reușit: %2',
    'initconf__invalid_hostname' => 'Eroare în numele de gazdă „%1”',
    'initconf__unable_reconfig' => 'Imposibil de configurat Plesk: reconfig nu a reușit: %1',
    'initconf__unable_update_admin' => 'Informațiile de contact ale administratorului nu se pot actualiza: %1',
    '__refresh' => 'Reîmprospătare',
    '__dalias_not_exist' => 'Aliasul de domeniu nu există.',
    '__bug146523_explanation' => 'Versiunile de Plesk anterioare permiteau utilizarea a maximum 16 caractere în numele de utilizatori FTP. Această versiune de Plesk limitează la 15 numărul maxim de caractere permise în numele de utilizatori FTP. Pentru a rezolva această problemă, scurtați numele de utilizator FTP afectate la 15 caractere. Pentru a evita dublurile, schimbați cel puțin un caracter în numele de utilizator FTP afectate. Ne cerem scuze pentru eventualele neplăceri provocate.',
    'domain__cannot_change_webmail' => 'Imposibil de modificat serviciul de e-mail prin web pentru domeniu: %1',
    'sb_publish_disable_warning' => 'Dacă dezactivați crearea site-urilor web cu Presence Builder, site-ul creat anterior cu Presence Builder va fi șters și toate datele acestuia se vor pierde. Dacă doriți să continuați, faceți clic pe OK.',
    '__sbnet_client_use_sbnet' => "Crearea unui cont de utilizator corespunzător în Presence Builder",
    'mail_resp_activate' => 'Activare răspuns automat',
    'limitsManger__limit_available_error' => 'Imposibil de alocat resursele solicitate („%%limitName%%”). Disponibil pentru contul dvs.: %%available%%.',
    'limitsManger__limit_reserved_error' => 'Nu se pot aloca mai puține resurse („%%limitName%%”) decât cele utilizate deja.',
    'domain__unable_to_rename_vhost_dir_already_exists' => 'Imposibil de redenumit domeniul: Deja există un director virtual cu numele specificat.',
    'domain_unable_to_rename' => 'Imposibil de redenumit domeniul.',

    // Greylisting
    'spamfilter__general_settings_legend' => 'General',
    'spamfilter__spamassassin_status_legend' => 'Filtru antispam SpamAssassin',
    'spamfilter__spamassassin_settings_legend' => 'Setări SpamAssassin',
    'spamfilter__spamassassin_server_status_legend' =>  "Se activează filtrul antispam SpamAssassin la nivel de server",
    'spamfilter__spamassassin_user_status_legend' => 'Se activează filtrul antispam SpamAssassin',
    'spamfilter__greylisting_status_legend' => 'Se activează protecția antispam la nivel de server cu liste gri',
    'spamfilter__personal_settings_not_allowed' => 'Politica de sistem nu permite utilizarea setărilor de filtrare antispam individuale.',
    'spamfilter__required_score' => 'Punctajul de la care mesajul este considerat spam',
    'spamfilter__rewrite_header_subject' => 'Se adaugă următorul text la începutul subiectului fiecărui mesaj identificat ca spam',
    'spamfilter__use_mailuser_prefs' => 'Se aplică setări individuale pentru filtrarea de spam',
    'spamfilter_addresses__text_hint' => 'Dacă aveți mai multe adrese, separați-le cu caractere rând nou, spațiu alb, virgulă sau punct și virgulă. În stânga semnului @ nu trebuie să apară niciun caracter non-ASCII. Adresele pot conține caracterele generice „*” și „?” (de exemplu, *@domeniu.com, utilizator?@*.com). Părțile non-ASCII ale numelor de domeniu nu pot conține caractere generice.',
    'spamfilter__score_error' => 'Punctajul nu poate fi negativ, partea întreagă trebuie să fie mai mică decât 100, numărul maxim al zecimalelor este 2.',
    'spamfilter__rewrite_header_error' => 'Subiectul mesajului poate conține orice caracter imprimabil, cu excepția caracterului diez (#).',

    // template conflict keys
    'nonexistent_mail__mode_bounce' => 'Se refuză',
    'nonexistent_mail__mode_discard' => 'Renunțare',
    'nonexistent_mail__mode_catch_addr' => 'Redirecționare către o adresă de e-mail',
    'nonexistent_mail__mode_catch_ip' => 'Redirecționare către adresă IP',
    'nonexistent_mail__bounce_not_supported' => 'Modul de refuzare nu este acceptat',
    'nonexistent_mail__discard_not_supported' => 'Modul de renunțare nu este acceptat',
    'nonexistent_mail__catch_not_supported' => 'Redirecționarea către o adresă de e-mail nu este acceptată',
    'nonexistent_mail__redirect_not_supported' => 'Redirecționarea către adresă IP nu este acceptată',
    'nonexistent_mail__ip_used_on_this_host' => 'Rezolvarea adresei IP este localhost',
    'nonexistent_mail_address_should_be_local_domain' => 'Întrucât controlul mesajelor de e-mail trimise este dezactivat, adresa de %1 pentru destinatari inexistenți trebuie să aparțină domeniului selectat. În caz contrar se va aplica politica „Refuzare” în loc de redirecționare.',
    'nonexistent_mail_address_should_be_local_domain_not_restricted' => 'Întrucât controlul mesajelor de e-mail trimise este activat, adresa de e-mail specificată pentru redirecționare (%1) trebuie să aparțină domeniului selectat. În caz contrar mesajele trimise la această adresă nu vor fi numărate în Controlul mesajelor de e-mail trimise.',
    // mail acc extras
    '__antivirus' => "AntiVirus",

    // web apps

    // none available
    'ui__admin-alias__none-available' => 'Nu sunt disponibile conturi de administrator suplimentare.', // PFW
    'ui__client/domain/certificate__none-available' => 'Clientul nu are certificate SSL/TLS.',
    'ui__client/domain/certificate__none-available__1' => 'Clientul nu are domenii cu certificate SSL/TLS.',
    'ui__client/domain/certificate__none-available__2' => 'Domeniul nu are niciun certificate SSL/TLS.',
    'ui__reseller/client__none-available' => 'Nu există reselleri cu clienți.',

    // empty selection for lists
    'ui__client/ipaddress/delete__empty_selection' => 'Trebuie să selectați adresele IP pe care doriți să le eliminați din domeniul de adrese.',
    'ui__server/ip-address/client/delete__empty_selection' => 'Trebuie să selectați conturile de reseller din ale căror domenii de adrese IP doriți să revocați o adresă IP.',
    'ui__server/crontab/task/delete__empty_selection' => 'Trebuie să selectați sarcinile pe care doriți să le revocați.',

    // scripting languages errors
    'phosting__php_not_enabled' => 'Suportul PHP este dezactivat pentru acest site web.',
    'phosting__aspdotnet_not_enabled' => 'Suportul ASP.NET este dezactivat pentru acest site web.',
    'phosting__php_forced_by_site_isolation' => 'Imposibil de modificat setările PHP: permisiunea de a înlocui politica de securitate definită la nivel de server nu a fost acordată.',
    'phosting__option_forced_by_site_isolation' => 'Imposibil de modificat setările %1: permisiunea de a înlocui politica de securitate definită la nivel de server nu a fost acordată.',
    'phosting__mod_bw_disabled_by_vps_optimized' => 'mod_bw este dezactivat pentru că Plesk funcționează în modul optimizat VPS.',
    'phosting__mod_php_disabled_by_vps_optimized' => 'mod_php este dezactivat pentru că Plesk funcționează în modul optimizat VPS.',
    'phosting__perl_disabled_by_vps_optimized' => 'Perl este dezactivat pentru că Plesk funcționează în modul optimizat VPS.',
    'phosting__asp_disabled_by_vps_optimized' => 'ASP este dezactivat pentru că Plesk funcționează în modul optimizat VPS.',
    'phosting__python_disabled_by_vps_optimized' => 'Python este dezactivat pentru că Plesk funcționează în modul optimizat VPS.',
    'phosting__fastcgi_disabled_by_vps_optimized' => 'fastcgi este dezactivat pentru că Plesk funcționează în modul optimizat VPS.',
    'phosting__php_handler_id_not_registered' => 'Handlerul PHP nu este permis în setările de izolare a site-urilor. Se va utiliza handlerul PHP implicit.',
    'phosting__php_served_by_nginx_is_not_available' => 'Handlerul PHP (aplicație FPM deservită de nginx) nu este permis în setările de izolare a site-urilor. Se va utiliza handlerul PHP implicit.',

    // various UI
    'ui__client/ipaddress/properties_readonly__short-title' => 'Vizualizarea listei adreselor IP',
    'ui__client/ipaddress/properties_readonly__title' => 'Vizualizarea listei adreselor IP',
    'ui__client/ipaddress/properties_readonly__description' => 'Vizualizarea listei adreselor IP disponibile pentru acest utilizator.',
    'ui__server/certificate__short-title' => 'Certificate SSL/TLS',
    'ui__server/certificate__title' => 'Certificate SSL/TLS',
    'ui__server/certificate__description' => 'Vizualizarea și administrarea certificatelor SSL/TLS.',

    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__short-title' => 'Ștergere tipuri MIME',
    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__title' => 'Ștergere tipuri MIME',
    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__description' => 'Ștergerea tipurile MIME selectate.',
    'ui__client/domain/hosting/web-directories/mime-type/properties_unknown-new__short-title' => 'Adăugare tip NIME',
    'ui__client/domain/hosting/web-directories/mime-type/properties_unknown-new__title' => 'Adăugare tip MIME',
    'ui__client/domain/hosting/web-directories/mime-type/properties_unknown-new__description' => 'Înregistrarea unui tip MIME.',

    'ui__client/ipaddress/delete_multi__wizard-title' => 'Ștergere adrese IP',
    'ui__client/ipaddress/delete_multi__wizard__2_multi' => 'Selectați adresele IP pe care doriți să le eliminați din domeniul de adrese al clientului %1',

    // mail

    // for future use
    'ui__client/domain/hosting/file-manager/create-file__short-title' => 'Creare fișier',
    'ui__client/domain/hosting/file-manager/create-file__title' => 'Creare fișier',
    'ui__client/domain/hosting/file-manager/create-file__description' => 'Crearea unui fișier.',
    'ui__client/domain/hosting/file-manager/create-dir__short-title' => 'Creare director',
    'ui__client/domain/hosting/file-manager/create-dir__title' => 'Creare director',
    'ui__client/domain/hosting/file-manager/create-dir__description' => 'Crearea unui folder.',
    'ui__client/domain/hosting/file-manager/edit__short-title' => 'Editare fișier sau director',
    'ui__client/domain/hosting/file-manager/edit__title' => 'Editare fișier sau director',
    'ui__client/domain/hosting/file-manager/edit__description' => 'Editarea fișierului sau a directorului selectat.',
    'ui__client/domain/hosting/file-manager/rename__short-title' => 'Redenumire fișier sau folder',
    'ui__client/domain/hosting/file-manager/rename__title' => 'Redenumire fișier sau folder',
    'ui__client/domain/hosting/file-manager/rename__description' => 'Redenumirea fișierului sau a folderului selectat.',
    'ui__client/domain/hosting/file-manager/permissions__short-title' => 'Modificare permisiuni',
    'ui__client/domain/hosting/file-manager/permissions__title' => 'Modificare permisiuni',
    'ui__client/domain/hosting/file-manager/permissions__description' => 'Modificarea permisiunilor de acces pentru un fișier sau un folder.',
    'ui__client/domain/hosting/file-manager/remove__short-title' => 'Ștergere fișier sau folder',
    'ui__client/domain/hosting/file-manager/remove__title' => 'Ștergere fișier sau folder',
    'ui__client/domain/hosting/file-manager/remove__description' => 'Ștergerea acestui fișier sau folder.',
    'ui__client/domain/hosting/file-manager/remove_self__short-title' => 'Ștergere fișier sau folder',
    'ui__client/domain/hosting/file-manager/remove_self__title' => 'Ștergere fișier sau folder',
    'ui__client/domain/hosting/file-manager/remove_self__description' => 'Ștergerea acestui fișier sau folder.',
    'ui__client/domain/hosting/file-manager/copy-move__short-title' => 'Copiere sau mutare de fișier sau director',
    'ui__client/domain/hosting/file-manager/copy-move__title' => 'Copiere sau mutare de fișier sau director',
    'ui__client/domain/hosting/file-manager/copy-move__description' => 'Copierea sau mutarea fișierelor sau directoarelor selectate.',
    'ui__client/domain/hosting/file-manager/view__short-title' => 'Vizualizare fișier',
    'ui__client/domain/hosting/file-manager/view__title' => 'Vizualizare fișier',
    'ui__client/domain/hosting/file-manager/view__description' => 'Vizualizarea fișierului selectat.',

    'ui__client/ipaddress__short-title' => 'Adresă IP',
    'ui__client/ipaddress__title' => 'Adresă IP',
    'ui__client/ipaddress__description' => 'Vizualizarea informațiilor despre adresa IP.',
    'ui__server/ip-address__short-title' => 'Adresă IP',
    'ui__server/ip-address__title' => 'Adresă IP',
    'ui__server/ip-address__description' => 'Vizualizarea informațiilor despre adresa IP.',
    'ui__client/domain/hosting/setup__short-title' => 'Setări de găzduire web',
    'ui__client/domain/hosting/setup__title' => 'Setări de găzduire web',
    'ui__client/domain/hosting/setup__description' => 'Configurarea setărilor de găzduire web pentru site-ul %1.',
    'ui__client/domain/hosting/web-directories/mime-type/properties__short-title' => 'Tip MIME', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties__title' => 'Proprietăți tip MIME', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties__description' => 'Adăugare tip NIME Vizualizarea proprietăților tipului MIME.', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__short-title' => 'Document de eroare', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__title' => 'Document de eroare', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__description' => 'Proprietățile documentului de eroare.', // PFW

    // tooltips

    'b_resellerreportslist_remove' => 'Ștergerea aspectelor de raport selectate.',
    'b_resellerreportslist_search' => 'Introduceți un model de căutare și faceți clic pentru a găsi aspecte de raport.',
    'b_resellerreportslist_show_all' => 'Afișarea tuturor aspectelor de raport disponibile.',

    'l_resellerreportslist_auto' => 'Sortarea aspectelor de raport după automatizarea livrării.',
    'l_resellerreportslist_clients' => 'Sortarea aspectelor de rapoarte după prezența informațiilor despre clienți.',
    'l_resellerreportslist_domains' => 'Sortarea aspectelor de rapoarte după prezența informațiilor despre domenii.',
    'l_resellerreportslist_general' => 'Sortarea aspectelor de rapoarte după prezența informațiilor generale.',
    'l_resellerreportslist_name' => 'Sortarea aspectelor de raport după numele raportului.',
    'l_resellerreportslist_personal_domains' => 'Sortarea aspectelor de rapoarte după prezența informațiilor despre domeniile personale.',

    'b_adminreportslist_remove' => 'Ștergerea aspectelor de raport selectate.',
    'b_adminreportslist_search' => 'Introduceți un model de căutare și faceți clic pentru a găsi aspecte de raport.',
    'b_adminreportslist_show_all' => 'Afișarea tuturor aspectelor de raport disponibile.',

    'l_adminreportslist_auto' => 'Sortarea aspectelor de raport după automatizarea livrării.',
    'l_adminreportslist_clients' => 'Sortarea aspectelor de rapoarte după prezența informațiilor despre clienți.',
    'l_adminreportslist_domains' => 'Sortarea aspectelor de rapoarte după prezența informațiilor despre domenii.',
    'l_adminreportslist_general' => 'Sortarea aspectelor de rapoarte după prezența informațiilor generale.',
    'l_adminreportslist_name' => 'Sortarea aspectelor de raport după numele raportului.',
    'l_adminreportslist_personal_clients' => 'Sortarea aspectelor de rapoarte după prezența informațiilor despre clienții dvs.',
    'l_adminreportslist_personal_domains' => 'Sortarea aspectelor de rapoarte după prezența informațiilor despre domeniile dvs.',
    'l_adminreportslist_resellers' => 'Sortarea aspectelor de rapoarte după prezența informațiilor despre reselleri.',

    'b_get_password_cancel' => 'Revenire la ecranul anterior fără a trimite e-mailul.',
    'b_get_password_send' => 'Faceți clic pe OK pentru a trimite mesajul de recuperare a parolei la adresa de e-mail înregistrată în sistem.',



    'b_personaltrafficlist_search' => 'Introduceți un șir de căutare și faceți clic pentru a găsi domenii.',
    'b_personaltrafficlist_show_all' => 'Afișarea tuturor domeniilor.',

    'b_back' => 'Revenire la pagina anterioară.',
    'b_next' => 'Salt la pagina următoare.',

    'b_dnsnstemplatelist_remove' => 'Ștergerea serverelor de nume selectate.',
    'b_dnsnstemplatelist_search' => 'Introduceți un șir de căutare și faceți clic pentru a căuta servere de nume.',
    'b_dnsnstemplatelist_show_all' => 'Afișarea tuturor serverelor de nume.',

    'l_dnsnstemplatelist_ns' => 'Sortarea înregistrărilor șablon DNS după serverul de nume.',

    // filesharing management tool
    'cu__serverfilesharing_fsLinksAsHttps' => 'Se generează linkuri securizate la fișiere și foldere',
    'cu__serverfilesharing_fsPublicFolderEnabled' => 'Se activează fișierele publice',
    'cu__serverfilesharing_fsPublicFolder' => 'Folder de stocare a fișierelor publice',
    'cu__serverfilesharing_fsPublicUrl' => 'URL pentru accesul de tip vizitator la fișierele publice',
    'cu__serverfilesharing_fsPartnerFolderEnabled' => 'Se activează protecția prin parolă a fișierelor publice',
    'cu__serverfilesharing_fsPartnerFolder' => 'Folder de stocare a fișierelor protejate prin parolă',
    'cu__serverfilesharing_fsPartnersLogin' => 'Nume utilizator pentru accesul la fișiere',
    'cu__serverfilesharing_fsPartnersPassword' => 'Parolă pentru accesul la fișiere',
    'cu__serverfilesharing_fsDomain' => 'URL-ul rădăcină al folderului web. Nume domeniu',
    'cu__serverfilesharing_fsPrefix' => 'URL-ul rădăcină al folderului web. Prefix',
    'cu__serverfilesharing_commandUpdate' => 'Actualizarea setărilor de partajare a fișierelor',
    'cu__serverfilesharing_commandInfo' => 'Afișarea setărilor curente de partajare a fișierelor',
    'subscription_rename_is_forbidden' => 'Politica la nivel de server interzice redenumirea abonamentelor.',
    ///
    /// END OF RANDOM COMMON KEYS
    ///

    ////
    //// CRONTAB - temporary
    ////

    // wizard:

    'ui__server/crontab/task_unknown__wizard-title' => 'Administrarea sarcinilor programate pe server',
    'ui__server/crontab/task_unknown__wizard__2_unknown' => 'Selectați utilizatorul de sistem ale cărui sarcini programate doriți să le administrați.',

    'ui__server/crontab/task__short-title' => '%1',
    'ui__server/crontab/task__title' => 'Sarcina programată %1',
    'ui__server/crontab/task__description' => 'Vizualizarea proprietăților sarcinii programate %1.',

    ///
    /// SERVER
    ///

    'ui__server/crontab_unknown__short-title' => 'Utilizatori de sistem',
    'ui__server/crontab_unknown__title' => 'Utilizatori de sistem',
    'ui__server/crontab_unknown__description' => 'Utilizatori de sistem care pot fi proprietari de sarcini programate.',


    'ui__server/crontab__none-available' => 'Nu aveți niciun cont de utilizator de sistem.',
    'ui__server/crontab_readonly-unknown__description' => 'Vizualizarea sarcinilor programate.',
    'ui__server/crontab_readonly-unknown__short-title' => 'Sarcini programate',
    'ui__server/crontab_readonly-unknown__title' => 'Vizualizarea sarcinilor programate',
    'ui__server/crontab_readonly-unknown__wizard-title' => 'Vizualizarea sarcinilor programate.',
    'ui__server/crontab_readonly__description' => 'Vizualizarea sarcinilor programate ale %1.',
    'ui__server/crontab_readonly__short-title' => 'Sarcina programată a %1',
    'ui__server/crontab_readonly__title' => 'Vizualizarea sarcinilor programate ale %1',
    'ui__server/crontab_unknown__wizard-title' => 'Administrarea sarcinilor programate.',

    'ui__server/crontab/properties__description' => 'Editarea sarcinilor programate pentru %1.',

    'ui__server/crontab/properties__short-title' => 'Setări',
    'ui__server/crontab/properties__title' => 'Editare sarcini programate pentru %1',
    'ui__server/crontab/properties_readonly-unknown__description' => 'Vizualizarea sarcinilor programate.',
    'ui__server/crontab/properties_readonly-unknown__short-title' => 'Setări',
    'ui__server/crontab/properties_readonly-unknown__title' => 'Vizualizarea sarcinilor programate',
    'ui__server/crontab/properties_readonly-unknown__wizard-title' => 'Vizualizarea sarcinilor programate.',
    'ui__server/crontab/properties_readonly__description' => 'Vizualizarea sarcinilor programate ale %1.',
    'ui__server/crontab/properties_readonly__short-title' => 'Setări',
    'ui__server/crontab/properties_readonly__title' => 'Vizualizarea sarcinilor programate ale %1',
    'ui__server/crontab/properties_unknown__description' => 'Editarea sarcinilor programate.',
    'ui__server/crontab/properties_unknown__short-title' => 'Proprietăți',
    'ui__server/crontab/properties_unknown__title' => 'Editare sarcini programate',
    'ui__server/crontab/properties_unknown__wizard-title' => 'Editarea sarcinilor programate.',
    'ui__server/crontab/properties_unknown__wizard__2_readonly-unknown' => 'Selectați utilizatorul de sistem ale cărui sarcini doriți să le vizualizați.',
    'ui__server/crontab/properties_unknown__wizard__2_unknown' => 'Selectați utilizatorul de sistem ale cărui sarcini doriți să le modificați.',
    'ui__server/crontab/properties_unknown__wizard__3' => 'Faceți clic pe Terminare pentru a aplica modificările, apoi închideți expertul.',
    'ui__server/crontab/properties_unknown__wizard__3_readonly' => 'Faceți clic pe Terminare pentru a închide expertul.',

    'ui__server/crontab/task__none-available' => 'Nu aveți nicio sarcină programată.',
    'ui__server/crontab/task__none-available__2' => 'Utilizatorul de sistem %1 nu are sarcini programate.',
    'ui__server/crontab/task_readonly-unknown__description' => 'Sarcini programate.',
    'ui__server/crontab/task_readonly-unknown__short-title' => 'Sarcini',
    'ui__server/crontab/task_readonly-unknown__title' => 'Sarcini programate',

    'ui__server/crontab/task/delete__description' => 'Ștergerea sarcinii programate %1',

    'ui__server/crontab/task/delete__short-title' => 'Ștergere',
    'ui__server/crontab/task/delete__title' => 'Ștergerea sarcinii programate %1',
    'ui__server/crontab/task/delete_multi__description' => 'Ștergerea sarcinilor programate.',

    'ui__server/crontab/task/delete_multi__short-title' => 'Ștergere',
    'ui__server/crontab/task/delete_multi__title' => 'Ștergerea sarcinilor programate',
    'ui__server/crontab/task/delete_multi__wizard-title' => 'Ștergerea sarcinilor programate.',
    'ui__server/crontab/task/delete_multi__wizard__2_unknown' => 'Selectați utilizatorul de sistem ale cărui sarcini doriți să le ștergeți.',
    'ui__server/crontab/task/delete_multi__wizard__3_multi' => 'Selectați sarcinile pe care doriți să le ștergeți.',
    'ui__server/crontab/task/delete_multi__wizard__4_multi' => 'Confirmați ștergerea sarcinii prin bifarea căsuței, apoi faceți clic pe Terminare pentru a finaliza execuția expertului.',
    'ui__server/crontab/task/delete_unknown__description' => 'Ștergerea unei sarcini programate.',
    'ui__server/crontab/task/delete_unknown__short-title' => 'Ștergere',
    'ui__server/crontab/task/delete_unknown__title' => 'Ștergere sarcină programată',
    'ui__server/crontab/task/delete_unknown__wizard-title' => 'Ștergerea unei sarcini programate.',
    'ui__server/crontab/task/delete_unknown__wizard__2_unknown' => 'Selectați utilizatorul de sistem ale cărui sarcină doriți să o ștergeți.',
    'ui__server/crontab/task/delete_unknown__wizard__3_unknown' => 'Selectați sarcina pe care doriți să o ștergeți.',
    'ui__server/crontab/task/delete_unknown__wizard__4' => 'Confirmați ștergerea sarcinii prin bifarea căsuței, apoi faceți clic pe Terminare pentru a finaliza execuția expertului.',

    'ui__server/crontab/task/properties__description' => 'Editarea sarcinilor programate.',

    'ui__server/crontab/task/properties__short-title' => 'Editarea sarcinii %1',
    'ui__server/crontab/task/properties__title' => 'Editare sarcini programate',
    'ui__server/crontab/task/properties_new__description' => 'Crearea sarcinilor programate pentru %1.',

    'ui__server/crontab/task/properties_new__short-title' => 'Adăugare sarcină',
    'ui__server/crontab/task/properties_new__title' => 'Crearea sarcinilor programate pentru %1',
    'ui__server/crontab/task/properties_new__wizard-title' => 'Crearea unei sarcini programate.',
    'ui__server/crontab/task/properties_new__wizard__2_unknown' => 'Selectați utilizatorul de sistem pentru care doriți să creați sarcina programată.',
    'ui__server/crontab/task/properties_new__wizard__4_new' => 'Faceți clic pe Terminare pentru a aplica modificările, apoi închideți expertul.',
    'ui__server/crontab/task/properties_readonly-unknown__description' => 'Vizualizarea sarcinilor programate.',
    'ui__server/crontab/task/properties_readonly-unknown__short-title' => 'Proprietăți',
    'ui__server/crontab/task/properties_readonly-unknown__title' => 'Vizualizare sarcini programate',
    'ui__server/crontab/task/properties_readonly-unknown__wizard-title' => 'Vizualizarea sarcinilor programate.',
    'ui__server/crontab/task/properties_readonly__description' => 'Vizualizarea sarcinilor programate.',
    'ui__server/crontab/task/properties_readonly__short-title' => 'Vizualizarea sarcinii %1',
    'ui__server/crontab/task/properties_readonly__title' => 'Vizualizarea sarcinilor programate',
    'ui__server/crontab/task/properties_unknown-new__description' => 'Crearea sarcinilor programate.',
    'ui__server/crontab/task/properties_unknown-new__short-title' => 'Adăugare sarcină',
    'ui__server/crontab/task/properties_unknown-new__title' => 'Crearea sarcinilor programate',
    'ui__server/crontab/task/properties_unknown__description' => 'Editarea sarcinilor programate.',
    'ui__server/crontab/task/properties_unknown__short-title' => 'Proprietăți',
    'ui__server/crontab/task/properties_unknown__title' => 'Editare sarcini programate',
    'ui__server/crontab/task/properties_unknown__wizard-title' => 'Editarea sarcinilor programate.',
    'ui__server/crontab/task/properties_unknown__wizard__2_readonly-unknown' => 'Selectați utilizatorul de sistem ale cărui sarcini doriți să le vizualizați.',
    'ui__server/crontab/task/properties_unknown__wizard__2_unknown' => 'Selectați utilizatorul de sistem ale cărui sarcini doriți să le modificați.',
    'ui__server/crontab/task/properties_unknown__wizard__3_readonly-unknown' => 'Selectarea sarcinii programate.',
    'ui__server/crontab/task/properties_unknown__wizard__3_unknown' => 'Selectați sarcina programată pe care doriți să o modificați.',
    'ui__server/crontab/task/properties_unknown__wizard__4' => 'Faceți clic pe Terminare pentru a aplica modificările, apoi închideți expertul.',
    'ui__server/crontab/task/properties_unknown__wizard__4_readonly' => 'Faceți clic pe Terminare pentru a închide expertul.',

    'ui__server/crontab/task/toggle_disable__description' => 'Dezactivarea sarcinii selectate %1.',

    'ui__server/crontab/task/toggle_disable__short-title' => 'Dezactivare',
    'ui__server/crontab/task/toggle_disable__title' => 'Dezactivarea sarcinii selectate %1',
    'ui__server/crontab/task/toggle_enable__description' => 'Activarea sarcinii programate %1.',

    'ui__server/crontab/task/toggle_enable__short-title' => 'Activare',
    'ui__server/crontab/task/toggle_enable__title' => 'Activarea sarcinii programate %1',
    'ui__server/crontab/task/toggle_unknown__description' => 'Activarea sau dezactivarea sarcinilor programate.',
    'ui__server/crontab/task/toggle_unknown__short-title' => 'Activare sau dezactivare',
    'ui__server/crontab/task/toggle_unknown__title' => 'Activarea sau dezactivarea sarcinilor programate',
    'ui__server/crontab/task/toggle_unknown__wizard-title' => 'Activarea sau dezactivarea sarcinilor programate',
    'ui__server/crontab/task/toggle_unknown__wizard__2_unknown' => 'Selectați contul de utilizator de sistem ale cărui sarcini doriți să le activați sau să le dezactivați.',
    'ui__server/crontab/task/toggle_unknown__wizard__3_unknown' => 'Selectați sarcina pe care doriți să o activați sau să o dezactivați.',


    /// not used on HP:

    'ui__client_unknown__short-title' => 'Conturi de client', // not used on HP?
    'ui__client_unknown__title' => 'Conturi de client', // not used on HP?
    'ui__client_unknown__description' => 'Administrarea conturilor de client.', // not used on HP?
    'ui__client/domain/disable_unknown__title' => 'Suspendare domeniu', // not used on HP
    'ui__client/domain/disable_unknown__short-title' => 'Suspendare domeniu', // not used on HP,
    'ui__client/domain/disable_unknown__description' => 'Suspendarea unui domeniu.', // not used on HP
    'ui__client/domain/enable_unknown__title' => 'Activare domenii', // not used on HP
    'ui__client/domain/enable_unknown__short-title' => 'Activare domenii', // not used on HP
    'ui__client/domain/enable_unknown__description' => 'Activarea unui domeniu.', // not used on HP

    //Additional FTP Accounts
    'directory_browser__select_folder' => 'Selectare folder',
    'ftp__management_domain' => "Conturi FTP din domeniul %1", // for Additional FTP Accounts
    '__ftp_users_list' => "Conturi FTP",
    'ftp__user_name' => "Nume cont FTP",
    'ftp__user_home' => "Director de pornire",
    'ftp__invalid_path' => "Calea specificată este incorectă",
    'ftp__physical_path_not_exist' => "Calea fizică nu există",
    'i_ftp_ses_sub_user' => 'Sesiune de cont FTP.',
    '__new_passwd' => "Noua parolă %1",

    ////
    //// Errors with custom template of Apache configuration
    ////

    'apacheConfigurationFailedMessageSubject' => 'Imposibil de configurat un server web pe gazda <%%host%%>',
    'apacheConfigurationFailedMessageBody' => "Imposibil de generat fișierul de configurație a serverului web pe gazda <%%host%%> din cauza următoarelor erori: %%error%% Corectați erorile din șabloanele de configurare a serverului web și regenerați fișierul.",

    'apacheConfigurationMessageAdminTitle' => 'Generarea configurației de server web nu a reușit',
    'apacheConfigurationMessageClientTitle' => 'Avertizare',

    'apacheConfigurationFailedAdminHomeMessage' => 'Noul fișier de configurație nu a fost generat pentru că există erori în șabloanele de configurare. Mesajul de eroare detaliat v-a fost trimis prin e-mail. Citiți mesajul, corectați erorile, apoi faceți clic %1 pentru a încerca din nou să generați configurația.',
    'apacheConfigurationFailedAdminHomeMessageLink' => 'aici', //used on linked text in apacheConfigurationFailedAdminHomeMessage
    'apacheConfigurationFailedAdminDomainMessage' =>  'Noua configurație a domeniului %1 nu a fost generată pentru că există erori în șabloanele de configurare. Mesajul de eroare detaliat v-a fost trimis prin e-mail. Citiți mesajul, corectați erorile, apoi faceți clic %2 pentru a încerca din nou să generați configurația.',
    'apacheConfigurationFailedAdminDomainMessageLink' => 'aici', //used on linked text in apacheConfigurationFailedAdminDomainMessage

    'apacheConfigurationFailedUserDomainMessage' => 'Este posibil să existe inconsecvențe în configurația serverului web din domeniul %1. Luați legătura cu administratorul de server pentru a rezolva problema.',

    'apacheConfigurationFailedAdminDomainsMessage' => 'Noua configurație a unor domenii nu a fost generată pentru că există erori în șabloanele de configurare. Mesajul de eroare detaliat v-a fost trimis prin e-mail. Citiți mesajul, corectați erorile, apoi faceți clic %1 pentru a încerca din nou să generați configurația.',
    'apacheConfigurationFailedAdminDomainsMessageLink' => 'aici', //used on linked text in apacheConfigurationFailedAdminDomainsMessage

    'apacheConfigurationFailedUserDomainsMessage' => 'Este posibil să existe inconsecvențe în configurația de server web din unele domenii. Luați legătura cu administratorul de server pentru a rezolva problema.',



    ///HOSTING PARAMETERS
    '__apache_errdocs' => "Documente de eroare personalizate",
    'dom_pref__webusers_script' => "Utilizatorilor web li se permite să utilizeze scripturi",
    '__seoRedirect' => 'Configurarea domeniului preferat ca',
    '__seoRedirectToLanding' => 'domain.tld',
    '__seoRedirectToWww' => 'www.domain.tld',
    '__seoRedirectNone' => 'Niciunul',

    '__sites' => 'Domenii',
    'domain_plan__perm_denied_manage_phosting' => 'Nu aveți permisiunea de a administra setările de găzduire.',
    '__owned_by_client' => 'deținut de proprietar',
    'ui__client/permissions_readonly__description' => "Vizualizarea acțiunilor pe care le poate executa clientul %1 în Plesk.",
    'backup__restore__object_client_template' => 'Șablon client',
    '__template_name' => 'Nume plan de servicii',
    'template__not_exists' => 'Nu există un astfel de plan de servicii',
    'template__exists' => 'Deja există un plan cu numele %1.',
    'clientOwnerChanger__ip_not_in_pool' => 'Adresa IP specificată nu face parte din domeniul de adrese al resellerului.',

    //// Change owner of subscription
    'chown__select_title' => "Alegeți noul abonat",
    'ui__client/domain/chowner_multi__wizard__3_multi-select' => 'Alegeți noul proprietar al abonamentelor selectate și faceți clic pe „Următorul>>”.',
    'domains__client_info' => "%1 abonamente, %2 abonamente active, %3 spațiu pe disc ocupat, %4 trafic utilizat",
    '__possible_owners' => 'Posibili proprietari noi de abonamente',

    'clients_list__filter_owner__filter_title' => 'Furnizor',
    'clients_list__filter_owner_any' => 'Toți utilizatorii',
    'clients_list__filter_owner_my' => 'Doar abonații mei',
    'clients_list__filter_owner_name__filter_title' => 'Nume furnizor',

    '__owner' => "Furnizor",
    'l_clientslist_owner' => 'Sortarea conturilor de utilizator după furnizor.',
    'l_clientslist_date' => 'Sortarea conturilor de utilizator după data creării.',
    'l_clientslist_name' => 'Sortarea conturilor de utilizator după nume.',
    'l_clientslist_domains' => 'Sortarea conturilor de utilizator după domenii.',
    'l_clientslist_cname' => 'Sortarea conturilor de utilizator după numele de companie.',

    'ui__client/domain/chowner_multi__wizard-title' => 'Reatribuirea abonamentelor selectate',
    'chown__check_title' => 'Modificare abonat',

    'ui__client/domain/chowner_multi__wizard__3_multi' => "Faceți clic pe Terminare pentru a finaliza reatribuirea. Când ați terminat, abonamentele selectate vor fi atribuite noului proprietar, furnizorul acestora va fi schimbat cu cel al noului proprietar. Abonamentele vor fi desprinse de planurile de servicii asociate și vor deveni „Personalizate”.",

    'chown__error_check' => 'Au apărut probleme la încercarea de a atribui unele dintre abonamente unui proprietar nou.',
    'domain_chown_subscription_will_be_anonymous' => "Abonaților li se vor anula planurile de servicii actuale. Acestea vor deveni „Personalizate”.",
    'chown__error_domains_exclude' => "Au apărut probleme la încercarea de a atribui unele dintre abonamente unui proprietar nou. Acesta abonamente sunt evidențiate.",
    'chown__ip_not_in_client_pool' => "Adresa IP asociată acestui abonament nu a fost adăugată în domeniul de adrese IP al noului proprietar.",
    'chown__already_owned_by_client' => "Acest abonament aparține deja unui utilizator.",

    /// Protected directories

    'ui__client/domain/hosting/protected-directories/path__short-title' => '/%1',
    'ui__client/domain/hosting/protected-directories/path__title' => 'Director protejat /%1',
    'ui__client/domain/hosting/protected-directories/path__description' => 'Administrarea directorului protejat /%1',
    'ui__client/domain/hosting/protected-directories/path/properties_new__title' => 'Crearea unui director protejat în site-ul %1',
    'ui__client/domain/hosting/protected-directories/path/properties_new__short-title' => 'Adăugare director protejat',
    'ui__client/domain/hosting/protected-directories/path/properties_new__description' => 'Crearea unui director protejat.',
    'ui__client/domain/hosting/protected-directories/path/properties_new__done' => 'Directorul protejat %1 a fost creat cu succes.',
    'ui__client/domain/hosting/protected-directories/path/properties__title' => 'Setările directorului protejat %1',
    'ui__client/domain/hosting/protected-directories/path/properties__short-title' => 'Setări de director',
    'ui__client/domain/hosting/protected-directories/path/properties__description' => 'Modificarea locației, a numelui și a titlului de zonă ale directorului protejat.',
    'ui__client/domain/hosting/protected-directories/path/properties__done' => 'Setările directorului protejat au fost modificate.',
    'ui__client/domain/hosting/protected-directories/path/delete_multi__title' => 'Confirmare ștergere',
    'ui__client/domain/hosting/protected-directories/path/delete_multi__short-title' => 'Ștergere protecție',
    'ui__client/domain/hosting/protected-directories/path/delete_multi__description' => 'Eliminarea protecției directoarelor selectate.',
    'ui__client/domain/hosting/protected-directories/path/delete__empty_selection' => 'Selectați un director a cărui protecție doriți să o eliminați.',
    'ui__client/domain/hosting/protected-directories/path/delete#legend__description' => 'Această operație va duce la eliminarea protecției directoarelor. Directoarele vor deveni accesibile utilizatorilor de internet.',
    'ui__client/domain/hosting/protected-directories/path/delete_multi__done' => 'Protecția directoarelor selectate a fost eliminată cu succes.',
    'ui__client/domain/hosting/protected-directories/path/user/properties_new__title' => 'Adăugarea unui utilizator',
    'ui__client/domain/hosting/protected-directories/path/user/properties_new__short-title' => 'Adăugarea unui utilizator',
    'ui__client/domain/hosting/protected-directories/path/user/properties_new__description' => 'Configurați un cont de utilizator pentru accesarea directorului protejat %1',
    'ui__client/domain/hosting/protected-directories/path/user/properties_new__done' => 'Contul de utilizator pentru accesarea directorului protejat a fost creat.',
    'ui__client/domain/hosting/protected-directories/path/user/properties__done' => "Acreditările utilizatorului au fost salvate.",
    'ui__client/domain/hosting/protected-directories/path/user/delete_multi__title' => 'Ștergerea utilizatorilor de director protejat',
    'ui__client/domain/hosting/protected-directories/path/user/delete__empty_selection' => 'Selectați utilizatorii pe care doriți să îi ștergeți.',
    'ui__client/domain/hosting/protected-directories/path/user/delete_multi__short-title' => 'Ștergere',
    'ui__client/domain/hosting/protected-directories/path/user/delete_multi__description' => 'Ștergerea utilizatorilor de director protejat.',
    'ui__client/domain/hosting/protected-directories/path/user/delete#legend__description' => 'Se vor șterge următorii utilizatori ai directorului protejat:',
    'ui__client/domain/hosting/protected-directories/path/user/delete_multi__done' => 'Conturile de utilizator selectate au fost șterse.',

    '__redirect_hint' => 'Veți fi redirecționat la noua adresă în 15 secunde... Dacă nu ajungeți automat la noua locație, activați javascript sau faceți clic pe linkul %%link%%.',

    'backup__restore__object_maillist' => 'Listă de e-mail',
    'backup__restore__object_site' => 'Site',
    'backup__restore__object_user' => 'Utilizator',
    'backup__restore__object_role' => 'Rol',

    'limit__name_max_site' => 'site-uri',

    'iis_pool__unable_rename_client' => "Imposibil de redenumit lista de aplicații IIS: %1.",

    'anonftp__is_not_supported_for_addon_domains' => 'Serviciul FTP anonim este acceptat numai pentru domeniul principal al abonamentului.',
    'anonftp__is_not_supported_for_addon_domains_powerUser' => 'Serviciul de FTP anonim este acceptat numai pentru domeniul principal al abonamentului.',

    '__gb' => 'GB',
    '__tb' => 'TB',
    '__gb_month' => 'GB/lună',
    '__tb_month' => 'TB/lună',

    '__customers' => 'Clienți',
    '__customer_name' => 'Nume client',
    '__customer_total' => 'Total client',
    '__site' => 'Site',
    '__def_site' => 'Site implicit',
    '__subscription_name' => 'Nume abonament',
    '__subscription_name_powerUser' => 'Nume abonament',

    'limit__units_max_traffic_suffix' => '/lună',

    'dom_pref__discard' => "Refuzare",

    'mail__pattern_already_exists' => 'Modelul „%1” este deja în lista neagră.',

    '__not_supported' => 'Neacceptat',

    'plesk_key__sitebuilder' => 'Site-uri publicate cu Presence Builder',
    'limit__name_max_site_builder' => 'Site-uri publicate cu Presence Builder',
    'plesk_key__wpb-multi-language-sites-support' => 'Suport pentru site-uri în mai multe limbi în Presence Builder',

    'ui__client/domain/traffic-hosting__title' => 'Statistici privind transferurile de date pentru <b>%1</b>',
    'ui__client/domain/traffic-hosting__title_powerUser' => 'Statistici privind transferurile de date pentru <b>%1</b>',
    'ui__client/domain/traffic-hosting#list__title' => "Transfer de date pe servicii",

    'login_up__access_denied_no_subscriptions' => "Acces interzis. Nu există abonamente valabile pentru acest cont.",

    'interval__day' => '%1 zi(le)',
    'interval__hour' => '%1 ore',
    'interval__minute' => '%1 minute',
    'interval__second' => '%1 secunde',

    ///License options
    'plesk_key__backward_incompatibility' => 'Încercați să utilizați o cheie de licență creată pentru o altă versiune de Plesk. Contactați reprezentanții de vânzări Plesk pentru a obține o cheie de licență corespunzătoare.',
    //Standalone or virtualization
    'virtualization_any' => "Server fizic sau o soluție de virtualizare",
    'virtualization_pvc' => "Containere Virtuozzo",
    'virtualization_vmware' => "VMWare",
    'virtualization_hyperv' => "Microsoft Hyper-V",
    'virtualization_xen' => "Xen",
    'virtualization_kvm' => "KVM",
    'virtualization_parallels_server' => "Server Virtuozzo",
    'plesk_key__virtualization' => "Valabil pentru următoarele medii:",
    'plesk_key__virtualization_only_key' => 'Cheia de licență este destinată exclusiv sistemelor Plesk care funcționează într-un mediu virtual %1.',
    'plesk_key__virtualizations_only_key' => 'Cheia de licență este destinată exclusiv sistemelor Plesk care funcționează în următoarele medii virtuale: %1.',
    //Language options
    'plesk_key__invalid_locale_signature' => 'Utilizarea pachetelor lingvistice personalizate este interzisă.',
    'plesk_key__allowed-locales' => 'Limbi disponibile',
    'plesk_key__allowed-locales-any' => 'Orice limbă',

    /// Web hosting settings on domain/subdomain

    '__cgi_bin_mode' => 'directorul cgi-bin se află în',
    '_cgi_bin_mode_webspace' => 'directorul rădăcină al abonamentului',
    '_cgi_bin_mode_www_root' => 'rădăcina de documente a acestui domeniu',

    ///ODBC DSN data sources
    'ui__server/odbc/dsn/properties_unknown-new__short-title' => 'Adăugarea unui DSN ODBC',
    'ui__server/odbc/dsn/properties_unknown-new__description' => 'Adăugarea unei surse de date ODBC.',
    'ui__server/odbc/dsn/delete_multi__short-title' => 'Ștergere',
    'ui__server/odbc/dsn/delete_multi__title' => 'Confirmare ștergere',
    'ui__server/odbc/dsn/delete_multi__description' => 'Ștergerea surselor de date DSN ODBC selectate.',
    'ui__server/odbc/dsn/delete#legend__description' => 'Următoarele conexiuni DSN ODBC vor fi șterse:',
    'ui__server/odbc/dsn/delete__empty_selection' => 'Nicio conexiune DSN ODBC selectată.',
    'ui__server/odbc/dsn/delete_multi__done' => 'Sursele de date selectate au fost șterse.',
    'ui__server/odbc/dsn__title' => 'Conexiunea DSN ODBC %1',

    'ui__client/domain/odbc/dsn/properties_new__short-title' => 'Adăugarea unui DSN ODBC',
    'ui__client/domain/odbc/dsn/properties_new__description' => 'Adăugarea unei surse de date ODBC.',
    'ui__client/domain/odbc/dsn/delete_multi__short-title' => 'Ștergere',
    'ui__client/domain/odbc/dsn/delete_multi__title' => 'Confirmare ștergere',
    'ui__client/domain/odbc/dsn/delete_multi__description' => 'Ștergerea surselor de date DSN ODBC selectate.',
    'ui__client/domain/odbc/dsn/delete#legend__description' => 'Următoarele conexiuni DSN ODBC vor fi șterse:',
    'ui__client/domain/odbc/dsn/delete__empty_selection' => 'Nicio conexiune DSN ODBC selectată.',
    'ui__client/domain/odbc/dsn/delete_multi__done' => 'Sursele de date selectate au fost șterse.',
    'ui__client/domain/odbc/dsn__title' => 'Conexiunea DSN ODBC %1',


    /// Custom buttons
    'custom_button__sort_key' => 'Nivel de prioritate',
    'custom_button__place' => 'Locație',
    'custom_button__place_navigation' => 'Acces comun',
    'custom_button__place_admin' => 'Pagina de pornire a administratorului',
    'custom_button__place_admin-settings' => 'Pagina Instrumente și setări a administratorului',
    'custom_button__place_reseller' => "Pagina de pornire a resellerului",
    'custom_button__place_reseller-settings' => 'Pagina Instrumente și utilitare a resellerului',
    'custom_button__place_client' => 'Pagina de pornire a clientului',
    'custom_button__place_domain' => "Pagina Site-uri web și domenii din Abonament",
    'custom_button__place_domain_powerUser' => "Pagina Site-uri web și domenii din Abonament",
    'custom_button__place_domain-properties' => 'Instrumente de site web',
    'custom_button__private' => 'Vizibil doar mie',
    'custom_button__image' => 'Imagine de fundal',
    'custom_button__conhelp' => "Text de sfat ecran",
    'custom_button__edit' => "Setările unui link la un serviciu suplimentar",
    'custom_button__include_client_cname' => "Se include numele companiei clientului",
    'custom_button__include_client_email' => "Se include e-mailul clientului",
    'custom_button__include_client_id' => "Se include ID-ul clientului",
    'custom_button__include_client_pname' => "Se include numele de contact al clientului",
    'custom_button__include_domain_id' => "Se includ ID-urile de abonament, de domeniu și de alias de domeniu",
    'custom_button__include_domain_id_powerUser' => "Se includ ID-urile de abonament, de domeniu și de alias de domeniu",

    'custom_button__include_domain_name' => "Se include numele de domeniu principal",
    'custom_button__include_ftp_user' => "Se include numele de utilizator FTP",
    'custom_button__include_ftp_pass' => "Se include parola FTP",
    'custom_button__internal_open' => "Deschidere URL în Plesk",
    'custom_button__text' => "Etichetă de buton",
    'custom_button__url' => "URL",

    'custom_button__not_image' => 'Fișier nu este de tip imagine.',
    'custom_button__big_image' => 'Dimensiunea fișierului nu poate depăși 100 KB.',
    'custom_button__failed_copy_image' => 'Imposibil de copiat fișierul: %1',


    'backup__restore__cannot_restore_non_power_user_dump_in_power_user_mode' => 'În vizualizarea Utilizator privilegiat nu se poate restaura o copie de rezervă care nu a fost creată de un utilizator privilegiat.',
    '__unknown_network_interface' => 'Interfață de rețea necunoscută',

    'init_conf__ip_address' => 'Adresă IP',

    //Confirmation page
    'bt_confirm' => 'Confirmare',
    'b_confirm' => 'Confirmarea proprietarului unuia dintre site-urile dvs.',

    'performance__iss_app_pool_forced_by_site_isolation' => 'Setările listei dedicate de aplicații IIS sunt configurate conform setărilor de securitate la nivel de server (configurația de izolare a site-urilor).',
    'performance__iss_app_pool_forced_by_server_wide_settings' => 'Setările listei dedicate de aplicații IIS sunt configurate conform setărilor de performanță la nivel de server.',

    '__current' => 'Curent',
    'ui__client/domain/hosting/web-directories/protection/user/properties__done' => 'Proprietățile utilizatorului au fost actualizate.',



    //// New Promos Block

    'promo__you_are_about_to_exceed_license_limit_max_dom' => 'Numărul de domenii pe care vi-l asigură licența Plesk este aproape epuizat (în proporție de 90% sau peste).',
    'promo__you_are_about_to_exceed_license_limit_max_dom_title' => 'Ați utilizat aproape toate domeniile.',
    'promo__you_are_about_to_exceed_license_limit_max_site_builder' => 'Numărul de site-uri Presence Builder pe care vi-l asigură licența Plesk este aproape epuizat (în proporție de 90% sau peste).',
    'promo__you_are_about_to_exceed_license_limit_max_site_builder_title' => 'Ați utilizat aproape toate site-urile Presence Builder.',
    'promo__button_hide' => 'Ascundere',
    'promo__button_next' => 'Următorul>>',
    'promo__button_prev' => '<< Anteriorul',
    'promo__button_license' => 'Actualizare licență',

    'promo__google_integration_title' => 'Integrare cu serviciile Google',
    'promo__google_integration' => 'Configurarea integrării cu serviciile Google, cum ar fi AdSense, Google Apps, instrumentele Webmaster.',
    'promo__google_integration_button' => 'Configurare',

    'promo__button_learn_more' => 'Informații suplimentare',

    //// Plesk Branding in 10.1
    'panel_branding__description' => 'Aveți posibilitatea să personalizați setările legate de aspectul interfeței și de branding, prin intermediul temelor personalizate. Pentru instrucțiuni de personalizare a temelor Plesk, consultați %1.',
    'panel_branding__description_link' => 'următorul document',

    ///// File Manager new buttons
    'bt_extract_archive' => 'Extragere fișiere',
    'b_filemanager__extract' => 'Extragerea fișierelor din arhivele selectate în directorul curent. Rețineți: dacă numele fișierelor conțin diacritice, este posibil ca acestea să fie afișate incorect după dezarhivare.',
    'filemanager_error_extracting_files' => 'Eroare de decomprimarea fișierelor arhivă: %1',
    'filemanager_no_archive_files_specified' => 'Specificați arhivele pe care doriți să le decomprimați.',
    'filemanager_not_zip_archive_specified' => 'Imposibil de decomprimat %1, nu este o arhivă ZIP.',
    'filemanager_files_successfully_extracted' => 'Fișierele arhivă au fost decomprimate.',
    'filemanager_error_file_download' => 'Descărcarea fișierului nu a reușit: %1',
    'filemanager__user_poolgrp' => 'Grup listă de aplicații',

    'loading' => 'Se încarcă...',
    'bt_create_archive' => 'Adăugare la arhivă',
    'filemanager__pack' => "Calea către arhivă: %1",
    'filemanager__archive_name' => 'Nume fișier arhivă',
    'filemanager__empty_filename' => 'Introduceți numele fișierului arhivă.',
    'filemanager_archive_created' => 'Arhiva a fost creată cu succes.',
    'filemanager_error_creating_archive' => 'Imposibil de creat arhiva: %1',

    'cmd_dns__aaaa_dns_record_already_exist' => "Această înregistrare intră în conflict cu înregistrarea AAAA a zonei.",
    'defaultcomponents__ftp_ipv6_hosting_not_supported' => "(Serverul FTP nu acceptă adresele IPv6.)",
    'cmd_dns__glue_dns_record_conflict' => 'Această înregistrare intră în conflict cu înregistrarea de legătură a zonei „%1”.',
    '__ftp_ipv6_not_supported' => "(Serverul FTP nu acceptă adresele IPv6.)",
    '__ipv6_not_supported' => 'Nu se acceptă IPv6.',
    'mail__ipv6_not_supported' => 'Serverul de e-mail nu acceptă Ipv6.',
    'mail__relay_while_list_ipv6_not_supported' => 'Serverul de e-mail nu acceptă lista albă IPv6 pentru transmitere.',
    'mail__relay_while_list_ipv6_mask_mul_16' => 'Valoarea măștii trebuie să fie multiplu de 16.',
    'mail__ip_or_mask_is_invalid' => 'Adresa IP sau masca sunt incorecte.',
    'nonexistent_mail__redirect_ipv6_not_supported' => 'Redirecționarea către adrese IPv6 nu este acceptată.',
    'sa__invalid_trusted_networks' => 'Rețele de încredere specificate incorect: %1',
    'dns_add__enter_ipv6_address' => "Adresă IPv6",
    'license_trial_days_left' => 'Plesk funcționează cu o licență de încercare. Aceasta va expira în %1 zile.',
    'excl_ipv6_num' => 'Adresă IPv6 dedicată',
    '__ip_mask' => "Mască de subrețea",
    '__ipv4_addr' => 'Adresă IPv4',
    '__ipv6_addr' => 'Adresă IPv6',
    'template__num_excl_ipv6s' => 'Alocarea adreselor Ipv6 dedicate către reseller',
    'anonftp__exclusive_ipv4_required' => 'Configurarea și utilizarea serviciului FTP anonim necesită o adresă IPv4 dedicată.',
    'anonftp__ipv4_already_used' => 'Nu puteți configura serviciul FTP anonim pentru acest site, pentru că acesta este configurat deja într-un alt domeniu la aceeași adresă IPv4.',


    'restart__kav' => "Antivirus Kaspersky",
    '__view_migration_log_detailed_info' => 'Vizualizarea jurnalului',

    'chown__ip_address_warn' => 'Înainte de a muta abonamentul la noul proprietar, trebuie să selectați o adresă IP nouă pentru abonament.',
    'chown__no_ip_address' => 'Niciunul',
    'chown__no_ipv4_address' => 'Nicio adresă IPv4',
    'chown__no_ipv6_address' => 'Nicio adresă IPv6',
    'chown__domain_exclude_already_owned_by_client' => 'Abonamentul %1 aparține deja utilizatorului respectiv.',
    'chown__error_ip_absent_in_ip_pool' => 'Adresa IP %1 nu face parte din domeniul de adrese al utilizatorului țintă.',
    'chown__error_ip_not_exist' => 'Adresa IP cu ID-ul „%1” nu există.',
    'chown__error_domain_ip_not_selected' => 'Trebuie selectată cel puțin o adresă IP pentru domeniul %1. Bifați valorile selectate pentru maparea IP.',

    '__new_passwd_single' => "Parolă",
    '__confirm_passwd_single' => "Confirmare parolă",

    'mail__ip_or_mask_is_invalid_ipv6' => 'Adresa Ipv6 sau masca sunt incorecte: Adresa IP trebuie să fie o adresă unicast corectă.',

    '__subscriptions' => 'Abonamente',

    '__owned_by_reseller' => 'deținut de reseller',
    '__owned_by_provider' => 'deținut de furnizor',

    'service_plan__anonymous' => 'Personalizat',
    'subscription_not_locked__change_limits_warning' => 'Acest abonament nu este blocat: Limitele impuse utilizării resurselor se vor modifica în timpul sincronizării cu planul de servicii.',
    'subscription_not_locked__change_permissions_warning' => 'Acest abonament nu este blocat: Permisiunile se vor modifica în timpul sincronizării cu planul de servicii.',

    'subscription__conflict_resolution_policy' => 'Politică de rezolvare a conflictelor',
    'subscription__conflict_resolution_policy_lock' => "Blocarea abonamentului",

    'backup__list__backup_warnings' => 'Avertizări',
    'backup__list__backup_info' => 'Informații',
    'backup__restore__object_reseller_template' => 'Șablon reseller',
    'backup__restore__object_domain_template' => 'Șablon de domeniu',

    'ui__client/permissions_readonly__title' => 'Permisiuni',
    'ui__client/permissions_readonly__short-title' => 'Permisiuni',

    'subscription__unable_lock_anonymous' => 'Acest abonament nu este legat de niciun plan de servicii, de aceea, nu poate fi deblocat.',
    'subscription__unable_sync_anonymous' => 'Acest abonament nu este legat de niciun plan de servicii, de aceea, nu poate fi sincronizat.',
    'subscription__unable_sync_locked' => 'Acest abonament este blocat, de aceea, nu poate fi sincronizat.',
    'subscription__locked' => 'Abonamentul este blocat.',
    'component_name__urlrewrite' => "Rescriere URL",
    '__quantity' => 'Cantitate',
    'hst__www_root_dir_absent' =>  'Avertisment: Directorul specificat drept rădăcină pentru documente nu există.',
    'object_creation__domain_is_not_a_webspace' => 'Acest obiect se poate crea numai într-un abonament.',
    'phosting__webspace_hosting_with_sites_cannot_be_deleted' => 'Abonamentul conține site-uri. Drept urmare, nu-i puteți schimba tipul de găzduire și nici nu-l puteți șterge.',
    'phosting__addon_domain_ip_must_match_webspace' => 'Eroare: Actualizarea adresei IP nu a reușit. Unui domeniu add-on nu i se poate atribui o adresă IP neatribuită domeniului principal al abonamentului.',
    'domain_plan__unable_change' => 'Imposibil de modificat planul de servicii: %1.',
    'domain_plan__different_hosting_type' => 'Tipul de găzduire actual este diferit de cel specificat în planul de servicii.',
    'domain_plan__addon_text' => 'Plan add-on',
    'domain_plan__addon_description' => 'Se folosește un plan add-on pentru a suplimenta planul de găzduire.',
    'asp_net__managed_runtime_version' => 'Versiune de executare gestionată de ASP.NET',
    'plan__can_not_change_hosting_type' => 'Imposibil de modificat tipul de găzduire în timpul editării planului.',
    'plan__apply_problems' => 'Planul nu a fost aplicat din cauza unor probleme cu următoarea funcție: %1',
    'plan_save__subscription_update_problem' => 'Imposibil de aplicat modificările în %1.',
    '__perm_denied_subscription_suspended_by_backuprestore' => "Abonamentul este suspendat temporar, până la terminarea procesului de creare a copiei de rezervă sau de restaurare a datelor. Reveniți mai târziu.",
    '__login_incorrect_plain_shadow_password' => 'Ați specificat o parolă incorectă pentru contul de administrator. Utilizați acreditările administratorului de sistem (root) sau obțineți parola corectă. Pentru a afla mai multe despre obținerea parolei, citiți fișierul /etc/psa/README.psa.shadow.',

    '__perm_denied_ip' => 'Nu puteți trimite adresa IP dacă nu o dețineți',

    'dns__dns_zone_not_synchronized' => 'Zona DNS a fost modificată. Dacă doriți să aplicați acestei zone modificările șablonului DNS, faceți clic pe butonul „Aplicarea modificărilor de șablon DNS” din această pagină sau alegeți opțiunea „Aplicarea modificărilor la toate zonele” din Panoul de administrare a serverului> Instrumente și setări> Setări șablon DNS> Aplicarea modificărilor de șablon DNS.',
    'dns__dns_zone_synchronize_link' => 'Faceți clic',
    'dns__dns_zone_synchronize_done' => 'Zona DNS a fost sincronizată cu succes.',

    'dns__dns_zone_template_error' => 'Au apărut probleme la sincronizarea zonelor DNS cu șablonul de zone DNS.%1',

    'dns__soa_rname_type_owner' => 'Adresa de e-mail a proprietarului site-ului',
    'dns__soa_rname_type_domain' => 'Adresa de e-mail a domeniului',
    'dns__soa_rname_type_external' => 'Adresă de e-mail externă',
    'dns__soa_rname_enforce_email' => 'Interzicerea modificării adresei de e-mail RNAME la nivel de domeniu',
    'dns__soa_rname_label' => 'E-mail (RNAME)',
    'dns__soa_rname_hint' => 'Adresa de e-mail a persoanei responsabile pentru zona DNS a domeniului. Returnat de serverul DNS ca răspuns la interogările SOA.',

    'dns__dns_zone_soa_sync_title' => 'Suprascrierea setărilor SOA pentru toate domeniile existente',
    'dns__dns_zone_soa_sync_legend' => 'Este necesară o confirmare',
    'dns__dns_zone_soa_sync_text' => 'Actualizați înregistrările SOA ale tuturor domeniilor găzduite prin aplicarea modificărilor făcute în șablonul SOA?',

    'cu_db__repair_mysql_dbus' => "Repararea parolelor de utilizator MySQL. Această operație este necesară dacă ați făcut upgrade la Plesk 11 de la o versiune anterioară.",

    'scheduled_backup_settings__start_at_hint' => 'Intervalul de verificare pentru sarcinile de creare programată a copiilor de rezervă este de 15 minute. Dacă doriți ca Plesk să pornească procesul de creare a copiilor de rezervă la o anumită oră, programați sarcina cu cel puțin 15 minute înainte de ora respectivă.',
    'cu_scheduled_backup_comment' => 'Creare programată a copiei de rezervă',
    'cu_scheduled_backup_error' => 'A apărut o eroare în timpul creării copiei de rezervă: %1',
    'cu_scheduled_backup_mail_subject' => '<%1> A apărut o eroare în timpul creării programate a copiei de rezervă.',
    'cu_scheduled_backup_mail_message' => "%1\nPunct de intrare Plesk: %2\n\nÎn timpul creării programate a copiei de rezervă au apărut următoarele erori:\n\n%3",
    'cu_scheduled_backup_comment_backup_all' => 'Crearea copiei de rezervă a fost programată. Toate configurările și tot conținutul.',
    'cu_scheduled_backup_comment_backup_vhost' => 'Crearea copiei de rezervă a fost programată. Toate configurările și tot conținutul, cu excepția e-mailului.',
    'cu_scheduled_backup_comment_backup_mail' => 'Crearea copiei de rezervă a fost programată. Doar configurările și conținutul de e-mail.',
    'cu_scheduled_backup_comment_backup_domain' => 'Crearea copiei de rezervă a fost programată. Configurarea domeniului.',
    'cu_scheduled_backup_to_cloud_not_allowed' => 'Stocarea copiilor de rezervă programate în spații de stocare cloud la distanță este o funcție premium. Pentru a o debloca, luați legătura cu furnizorul de servicii de găzduire.',

    'i_backup_invalid_file' => 'Aceasta nu este o copie de rezervă corectă. Imposibil de restaurat date din acest fișier. Pentru detalii, faceți clic pe numele copiei de rezervă.',

    'ui__server/migration/download-agent__short-title' => 'Descărcarea Agentului de migrare și transfer',
    'ui__server/migration/download-agent__title' => 'Descărcarea Agentului de migrare și transfer',
    'ui__server/migration/download-agent__description' => 'Descărcați cea mai recentă versiune disponibilă a Agentului de migrare și transfer, de pe site-ul web Plesk.',

    'filemanager_resulting_archive_exists' => 'Fișierul %1 există deja în directorul țintă.',

    'agent_unable_to_connect' => 'Imposibil de conectat la agent la „%2”. Asigurați-vă că agentul este instalat și pornit și că nu există probleme de conexiune cu gazda „%2”.',
    'agent_test_connection_failed' => 'Conectarea la agent la „%2” nu a reușit.',

    'agent_unable_to_resolve_host' => 'Imposibil de localizat gazda la distanță „%1”. Asigurați-vă că nu există probleme de conexiune cu gazda.',
    'agent_unknown_curl_error' => 'În timpul conectării la agent la „%2” a apărut eroarea „%1”.',
    'agent_unexpected_htp_code' => 'S-a primit codul HTTP „%1” drept răspuns la solicitarea HTTP trimisă agentului la „%2”.',
    'agent_unable_to_auth' => 'Imposibil de autentificat pe gazda „%1”. Pentru a rezolva această problemă, urmați instrucțiunile din pagina http://kb.plesk.com/116606.',
    'agent_internal_server_error' => 'Eroare internă de server la executarea comenzii pe gazda la distanță „%1”.',
    'agent_response_is_empty' => 'S-a primit un răspuns gol la solicitarea HTTP trimisă agentului la „%1”.',

    'migration__disabled_due_to_local_file_does_not_exist' => 'Imposibil de găsit Agentul de migrare și transfer în cache-ul local. Redeschideți Managerul de migrare și transfer pentru a rezolva problema.',

    '__hosting_webdeploy' => "Publicare Web Deploy",
    'cu_domain__webdeploy' => "Publicare Web Deploy (implicit: %1)",
    'cu_dom_tpl__webdeploy' => "Publicare Web Deploy (implicit: %1)",
    'cu_subdomain__webdeploy' => "Publicare Web Deploy (implicit: %1)",
    'webdeploy__not_installed' => "Microsoft Web Deploy nu este instalat pe server",
    'webdeploy__forced_by_site_isolation' => "Imposibil de modificat setările de publicare Web Deploy: Nu aveți permisiunea să vă ocoliți politica de securitate la nivel de server. Contactați furnizorul pentru a primi detalii.",



    'backup__restore_options__admin__server_configuration_license' => 'Cheie de licență',
    'migration_start_migrate_server_license' => 'Transfer de cheie de licență',

    'defaultcomponents__delegation_rule_not_exist' => '(nu există regula de delegare necesară „appPoolPipeline, appPoolNetFx”)',

    '__o' => 'O',

    'i_backup_created_by_admin' => 'Copia de rezervă a fost creată de administrator.',
    'i_backup_created_by_reseller' => 'Copia de rezervă a fost creată de reseller.',
    'i_backup_created_by_client' => 'Copia de rezervă a fost creată de client.',

    'migration__object_exists_on_target_host' => '(există deja pe serverul destinație)',

    '__customers_total' => 'Total pe clienți',
    '__resellers_total' => 'Total reselleri',
    '__reseller_total' => 'Total reseller',


    'cu__mailserver_update_webmail_command' => "Specificarea clientului de e-mail prin web de activat sau dezactivat",
    'cu__mailserver_webmail_state' => "Specificarea stării clientului de e-mail prin web selectat („true” activează clientul, „false” îl dezactivează)",

    'cu_db_set_default_user' => 'Setarea unui utilizator specificat drept implicit pentru o bază de date. Opțiunea este utilizată cu comenzile: add_user, update_user',

    'cu_role__opt_subscription_name' => 'Utilizatorilor li se permite să acceseze doar abonamentul specificat',
    'cu_role__opt_for_all_subscription' => 'Utilizatorilor li se permite să acceseze toate abonamentele cu un cont de găzduire',
    'cu_role__subscription_not_found_role_is_not_limited' => 'Imposibil de aplicat modificările asupra rolului: Abonamentul %1 nu a fost găsit.',

    'cu_cl_pref__manage_website_maintenance' => 'Acces la operațiile avansate: Copiere de site web',
    'cu_cl_pref__manage_protected_dirs' => 'Administrarea directoarelor protejate prin parolă',
    'cu_cl_pref__manage_mail_settings' => 'Posibilitate de a modifica setările de e-mail',


    'cu__command_update_php_settings' => 'Actualizarea setărilor PHP.',
    'cu__php_settings_option' => 'Setarea căii către fișierul cu setări PHP.',

    'cu__additional_php_settings_option' => 'Setarea căii către fișierul cu directive PHP suplimentare.',
    'cu__command_show_php_settings' => 'Afișarea setărilor PHP actuale.',
    'cu__general_settings' => 'Setări generale:',
    'cu__performance_settings' => 'Setări de performanță:',
    'cu__php_fpm_settings' => 'Setări PHP-FPM:',
    'cu__additional_directives' => 'Directive suplimentare:',

    'b_filemanager__pack' => 'Adăugarea fișierelor selectate la o arhivă.',

    'php_settings_permission_required' => 'Administrarea setărilor PHP comune',
    'php_settings_performance_permission_required' => 'Administrarea setărilor de performanță a găzduirii',
    'php_settings_customized' => 'Setările PHP au fost personalizate.',
    'php_settings_synchronized_with_plan' => 'Setările PHP trebuie sincronizate cu planul.',
    'phosting__unknown_shell_type' => 'Shell indisponibil',

    'login_up__access_denied_subscription_deleted' => 'Acces interzis: Abonamentul a fost eliminat.',

    'role_restricted_to_subscription' => '(transferat cu abonamentul: %1)',

    'filemanager__extract' => "Decomprimare fișiere în: %1",

    'cu__license_command_check_installed_license' => 'Verificați valabilitatea cheii de licență instalate (returnează codul de ieșire 0 în cazul în care cheia este valabilă și 1 dacă nu este valabilă)',

    'promo__mobile_manager_title' => 'Manager de server Plesk pentru mobil',
    'promo__mobile_manager' => "Extindeți funcțiile Plesk pentru a putea controla și urmări serverul folosind dispozitive mobile (BlackBerry, iPhone și Android).",
    'promo__mobile_monitor_title' => 'Monitor de server Plesk pentru mobil',
    'promo__mobile_monitor' => 'Aflați cele mai importante informații despre serverele Plesk în orice moment și de oriunde, folosind un dispozitiv mobil (BlackBerry, iPhone și Android).',
    'promo__mobile_button' => 'Informații suplimentare',

    'ui__server/migration/video__short-title' => 'Tutoriale video',
    'ui__server/migration/video__title' => 'Urmăriți tutorialele video',
    'ui__server/migration/video__description' => 'Urmăriți tutorialele video.',

    'subDomainNameHint' => 'Introduceți * ca nume de subdomeniu pentru a crea un subdomeniu generic. Vizitatorii site-ului vor fi redirecționați către acest subdomeniu, indiferent de numele de subdomeniu pe care îl introduc în browser.',
    'subdomains__wildcard_name_invalid' => "Numele subdomeniului este incorect. În numele de subdomenii generice puteți utiliza doar caractere alfanumerice, o cratimă (-) și un asterisc (*).",
    'subdomains__name_invalid' => "Numele subdomeniului este incorect. În numele de subdomenii puteți utiliza doar caractere alfanumerice și o cratimă (-).",

    'domain__wildcard_no_www_prefix' => 'Prefixul www nu se poate utiliza în cazul subdomeniilor generice.',

    '__service_title__milter' => "Filtru de e-mail Plesk Postfix",
    '__service_description__milter' => "Filtru de e-mail Plesk Postfix",
    '__milter' => "Filtru de e-mail Postfix",
    'restart__milter' => "Filtru de e-mailuri Plesk (%1)",
    'restart__pop3' => "Server POP3 Courier",
    'restart__pop3s' => "Server POP3 Courier cu suport SSL/TLS",
    'restart__imap' => "Server IMAP Courier",
    'restart__imaps' => "Server IMAP Courier cu suport SSL/TLS",
    'restart__authdaemon' => "Proces daemon de autentificare IMAP Courier",
    'restart__imap-pop3' => "Server IMAP și POP3 Dovecot",


    'addon_packages_not_supported' => 'Nu se acceptă add-onuri pentru aplicațiile web împachetate APS.',
    'cu_domain__unable_to_automaticaly_select_ip' => 'Imposibil de atribuit automat adresa IP unui domeniu Specificați o adresă IP, cu opțiunea -ip.',

    'plesk_key__mb_accounts' => 'Conturile utilizator (reselleri și clienți) în Managerul de clienți și business',

    'actionlog__subdomain_dns' => 'Zona DNS a subdomeniului',
    'actionlog__site_subdomain_dns' => 'Zona DNS a unui subdomeniu dintr-un domeniu suplimentar',

    // PfW only
    'actionlog__event_site_create' => 'Domeniul a fost creat',
    'actionlog__event_site_delete' => 'Domeniul a fost șters',
    'actionlog__event_site_update' => 'Domeniul a fost actualizat',

    'actionlog__event_site_status_update' => 'Starea domeniului a fost actualizată',
    'actionlog__event_site_dns_update' => 'Zona DNS a domeniului a fost actualizată',
    'actionlog__event_site_guid_update' => 'GUID-ul domeniului a fost actualizat',

    'actionlog__event_site_subdomain_create' => 'Subdomeniul a fost creat',
    'actionlog__event_site_subdomain_delete' => 'Subdomeniul a fost șters',
    'actionlog__event_site_subdomain_update' => 'Subdomeniul a fost actualizat',

    'actionlog__event_site_alias_create' => 'Aliasul de domeniu a fost creat',
    'actionlog__event_site_alias_delete' => 'Aliasul de domeniu a fost șters',
    'actionlog__event_site_alias_update' => 'Aliasul de domeniu a fost actualizat',

    'actionlog__event_site_alias_dns_update' => 'Zona DNS a unui alias de domeniu a fost actualizat',
    'actionlog__event_subdomain_dns_update' => 'Zona DNS a unui subdomeniu din domeniul implicit a fost actualizată',
    'actionlog__event_site_subdomain_dns_update' => 'Zona DNS a unui subdomeniu a fost actualizată',
    // End of PfW only

    'win_policy__bad_password' => 'Validarea nu a reușit. Parola nu este corectă.',
    'win_policy__password_too_short' => 'Validarea nu a reușit. Parola nu respectă cerințele politicii de parole, întrucât este prea scurtă.',
    'win_policy__password_too_long' => 'Validarea nu a reușit. Parola nu respectă cerințele politicii de parole, întrucât este prea lungă.',
    'win_policy__password_not_complex_enough' => 'Validarea nu a reușit. Parola nu este suficient de complexă și nu îndeplinește cerințele politicii de parole. Parolele complexe trebuie să îndeplinească toate cerințele următoare: opt caractere; o literă mare sau mică; trei cifre și un caracter special (!, @, #, $, %, ^, &, *, ?, _, ~) sau o cifră și două caractere speciale.',

    //// Activation Code feature
    'plesk_key__license_update_failed' => 'Licența de produs nu se poate actualiza.',


    'filemanager__error_path_is_not_allowed' => 'Calea nu este permisă',
    'filemanager__error_path_is_invalid' => 'Calea este incorectă',
    'filemanager__error_path_not_found' => 'Cale negăsită',
    'filemanager__error_path_already_exists' => 'Calea există deja',
    'filemanager__error_access_is_denied' => 'Acces interzis',
    'filemanager__error_directory_not_empty' => 'Folderul nu este gol',
    'filemanager__error_sharing_violation' => 'Încălcare a regulilor de partajare',
    'filemanager__error_not_same_device' => 'Calea destinație nu se află pe același dispozitiv',
    'filemanager__binary_data_access' => 'Acest fișier poate fi unul binar. Îl deschideți?',
    'filemanager__unable_to_resolve_realpath' => "Imposibil de găsit fișierul %1 în locația specificată",
    'filemanager__access_to_realpath_denied' => "Accesul la calea reală a fost refuzat: %1 la %2.",
    'bt_exit' => 'Ieșire',

    'filemanager__chdir_error__' => "Imposibil de schimbat directorul în %1: %2",
    'filemanager__chmod_dir' => "Schimbarea permisiunilor pentru directorul %1",
    'filemanager__chmod_error__' => "Imposibil de schimbat permisiunile pentru fișierul %1: %2",
    'filemanager__chmod_file' => "Schimbarea permisiunilor pentru fișierul %1",
    'filemanager__copy_error__' => "Imposibil de copiat %1 în %2: %3",
    'filemanager__copy_move' => "Copierea (mutarea) fișierelor din %1",
    'filemanager__count_size__' => 'Dimensiune selecție: %1',
    'filemanager__count_size_error__' => 'Imposibil de calculat dimensiunea %1: %2',
    'filemanager__create_dir' => "Creare director",
    'filemanager__create_dir_error__' => "Imposibil de creat directorul %1: %2",
    'filemanager__dir_not_exists' => "Directorul %1 nu există.",
    'filemanager__dirname' => "Nume director",
    'filemanager__filename' => "Nume fișier",
    'filemanager__is_no_such' => "Nu există fișier sau director cu numele %1",
    'filemanager__empty_selection' => "Niciun fișier selectat.",
    'filemanager__file_exists' => "Fișierul %1 există deja.",
    'filemanager__move_error__' => "Imposibil de mutat %1 în %2: %3",
    'filemanager__new_dir' => "Nume director",
    'filemanager__not_allowed' => "Nu aveți dreptul să schimbați permisiunile pentru acest fișier.",
    'filemanager__r_perm_dir' => "Listare director",
    'filemanager__r_perm_file' => "Citire date",
    'filemanager__remove' => "Eliminare fișiere din %1",
    'filemanager__remove_error__' => "Imposibil de eliminat fișierul %1: %2",
    'filemanager__rename_dir' => "Redenumire director %1",
    'filemanager__rename_error__' => "Imposibil de redenumit %1 în %2: %3",
    'filemanager__rename_file' => "Redenumire fișier %1",
    'filemanager__set_win_permissions_dir' => "Setarea permisiunilor pentru %1 folder",
    'filemanager__set_win_permissions_file' => "Setarea permisiunilor pentru %1 fișier",
    'filemanager__touch_confirm' => "Sigur schimbați marcajele de timp ale fișierelor selectate?",
    'filemanager__no_perms_or_unsupported_file_type' => 'Imposibil de citit fișierul sau formatul acestuia nu este acceptat.',
    'filemanager__upload_error__' => "Imposibil de încărcat %1 în %2: %3",
    'filemanager__upload_file' => "Încărcare fișier",
    'filemanager__upload_file_src' => "Calea către fișier",
    'filemanager__username' => "Utilizator",
    'filemanager__w_perm_dir' => "Creare fișiere",
    'filemanager__w_perm_file' => "Scriere date",
    'filemanager__x_perm_dir' => "Parcurgere director",
    'filemanager__x_perm_file' => "Executare fișier",
    'filemanager__max_image_size_exceeded' => 'Imposibil de afișat imaginea. Dimensiunea imaginii nu poate depăși %2 byți',

    '__fastcgi_unix_support' => 'Suport FastCGI',

    'ts_sessions_list' => 'Această pagină prezintă lista tuturor sesiunilor Servicii terminal.',
    'b_tssessionslist_search' => 'Căutarea sesiunilor după nume.',
    'b_tssessionslist_show_all' => 'Afișarea tuturor sesiunilor de Servicii terminal.',
    'l_tssessionslist_state' => 'Sortare după stare.',
    'l_tssessionslist_name' => 'Sortare după nume.',
    'l_tssessionslist_user' => 'Sortare după utilizator.',
    'b_tssessionslist_logoff' => 'Faceți clic pentru a deconecta sesiunile selectate.',
    'b_tssessionslist_disconnect' => 'Faceți clic pentru a deconecta sesiunile selectate.',
    'tssessions_info' => 'Vizualizarea proprietăților sesiunii.',
    'tssessions_disconnect' => 'Bifați caseta de selectare Confirmare ștergere și faceți clic pe OK pentru a închide sesiunile de server de terminal selectate.',
    'tssessions_logoff' => 'Bifați caseta de selectare Confirmare ștergere și faceți clic pe OK pentru a deconecta sesiunile de server de terminal selectate.',
    'b_tssession_disconnect_submit' => 'Faceți clic pentru a trimite modificările.',
    'b_tssession_logoff' => 'Faceți clic pentru a deconecta sesiunea.',
    'b_tssession_logoff_submit' => 'Faceți clic pentru a trimite modificările.',
    'i_tssession_active' => 'Activ',
    'i_tssession_connected' => 'Conectat',
    'i_tssession_disconnected' => 'Deconectat',
    'i_tssession_listen' => 'Așteaptă conexiuni',
    'tssessions__tssessionslist' => 'Sesiuni',
    'tssessionslist__state' => 'S',
    'tssessionslist__name' => 'Nume',
    'tssessionslist__user' => 'Utilizator',
    'bt_logoff_selected' => 'Deconectare',
    'bt_logoff' => "Deconectare",
    'bt_disconnect_selected' => 'Deconectare',
    'bt_tssession_logoff' => 'Deconectare',
    'bt_tssession_disconnect' => 'Deconectare',
    'bt_tssession_disconect' => 'Deconectare',
    'b_tssession_disconnect' => 'Faceți clic pentru a deconecta sesiunea.',
    'b_tssession_logoff_disabled' => 'Imposibil de deconectat sesiunea.',
    'b_tssession_disconnect_disabled' => 'Imposibil de deconectat sesiunea.',
    'tssessions_info__title' => 'Proprietățile sesiunii %1',
    'tssessions_info__property_name' => 'Nume proprietate',
    'tssessions_info__property_value' => 'Valoare proprietate',
    'tssessions__disconnect_title' => 'Următoarele sesiuni de Servicii terminal vor fi închise:',
    'tssessions__session_cant_disconnect' => 'această sesiune nu se poate închide',
    'tssessions__logoff_title' => 'Următoarele sesiuni de Servicii terminal vor fi deconectate:',
    'tssessions__session_cant_logoff' => 'această sesiune nu se poate deconecta',
    'tssessions__select_sessions_to_logoff' => 'Selectați sesiunile de deconectat.',
    'tssessions__select_sessions_to_disconnect' => 'Selectați sesiunile de închis.',
    'dns__subdomain_dns_zone_parent' => 'Înregistrările DNS ale acestui subdomeniu sunt stocate în zona DNS părinte. Puteți modifica zona părinte %1 sau puteți crea o zonă separată pentru subdomeniu.',
    'dns__subdomain_dns_zone_parent_link' => 'aici',
    'dns__no_dns_zone' => 'Nu există nicio zonă DNS atribuită domeniului. Pentru a administra zona DNS a domeniului dvs., trebuie să apăsați butonul „Restabilire valori implicite”.',
    'dns__unable_turn_on_subdomain_zone' => 'Imposibil de activat zona subdomeniului pentru că există o înregistrare CNAME pentru acesta în zona domeniului părinte.',

    '__hosting_write_modify' => 'Permisiuni de scriere/modificare suplimentare',


    'aspdotnet__title' => "Configurație ASP.NET la nivel de server",
    'aspdotnet__dom_title' => "Configurație ASP.NET pentru site",
    'aspdotnet__wdir_title' => "Configurație ASP.NET pentru directorul virtual %1",
    'aspdotnet__group_cas_settings' => "Securitatea accesului la resurse prin cod",
    'aspdotnet__group_client_scripts' => "Setările bibliotecii de scripturi",
    'aspdotnet__group_conn_strings' => "Manager șir de conectare",
    'aspdotnet__group_custom_errors' => "Setări de erori personalizate",
    'aspdotnet__group_framework_version' => "Versiune framework",
    'aspdotnet__group_globalization' => "Setări de globalizare",
    'aspdotnet__group_other' => "Setări de sesiune",
    'aspdotnet__group_page_and_runtime' => "Compilare și depanare",
    'aspdotnet__invalid_dom_config_file' => "Fișierul de configurare ASP.NET al acestui site web este deteriorat. Pentru a-l reface, aplicați configurația ASP.NET implicită a serverului: faceți clic pe Setare la implicit.",
    'aspdotnet__invalid_file_enc' => "Valoare incorectă a parametrului Codificare fișier.",
    'aspdotnet__invalid_req_enc' => "Valoare incorectă a parametrului Codificare solicitare.",
    'aspdotnet__invalid_res_enc' => "Valoare incorectă a parametrului Codificare răspuns.",
    'aspdotnet__invalid_parent_wdir_config_file' => "Fișierul de configurare ASP.NET este deteriorat din cauza deteriorării fișierului de configurare ASP.NET corespunzător directorului părinte %1. Pentru a rezolva această problemă, restaurați configurația ASP.NET %1.",
    'aspdotnet__invalid_global_config_file_admin' => "Configurația ASP.NET este deteriorată din cauza deteriorării fișierului de configurare ASP.NET de pe server.",
    'aspdotnet__invalid_global_config_file' => "Configurația ASP.NET este deteriorată din cauza deteriorării fișierului de configurare ASP.NET de pe server. Contactați furnizorul de servicii pentru a primi asistență.",
    'aspdotnet__invalid_sess_timeout' => "Valoare incorectă a parametrului Expirare sesiune. Introduceți un număr întreg mai mic decât sau egal cu %1.",
    'aspdotnet__invalid_wdir_config_file' => "Fișierul de configurare ASP.NET corespunzător acestui director virtual este deteriorat. Pentru a-l reface, aplicați configurația ASP.NET a directorului virtual părinte: faceți clic pe Setare la implicit.",
    'aspdotnet__param_auth_mode' => "Mod autentificare",
    'aspdotnet__param_conn_strings' => "Șiruri de conectare",
    'aspdotnet__param_conn_string_name' => "Nume",
    'aspdotnet__param_conn_string_value' => "Parametri de conectare",
    'aspdotnet__param_culture' => "Setări de limbă și regionale",
    'aspdotnet__param_custom_err_mode' => "Mod erori personalizate",
    'aspdotnet__param_custom_error_redirect' => "URL de redirecționare",
    'aspdotnet__param_custom_error_status' => "Cod de stare",
    'aspdotnet__param_custom_errors' => "Erori personalizate",
    'aspdotnet__param_debug_mode' => "Pornire depanare",
    'aspdotnet__param_def_language' => "Limba implicită a paginilor web",
    'aspdotnet__param_temp_directory' => "Director temporar",
    'aspdotnet__param_file_enc' => "Codificare fișier",
    'aspdotnet__param_req_enc' => "Codificare solicitare",
    'aspdotnet__param_res_enc' => "Codificare răspuns",
    'aspdotnet__param_sess_timeout' => "Expirare sesiune (minute)",
    'aspdotnet__param_trust_level' => "Nivel de încredere CAS",
    'aspdotnet__param_ui_culture' => "Setări de limbă și regionale pentru interfață",
    'aspdotnet__param_version' => "Versiune",
    'aspdotnet__param_trust_level_allow_override' => 'Se permite modificarea nivelului de încredere CAS pentru site-uri web individuale',
    'aspdotnet__restore_default_confirm' => "Restaurați setările ASP.NET implicite?",

    'bt_restore_default' => "Setare la valoare implicită",
    'b_aspdotnet' => 'Editarea setărilor de configurare ASP.NET.',
    'b_aspdotnet__restore_default' => 'Restaurarea setărilor ASP.NET implicite.',
    'b_aspdotnet__restore_wdir_default' => "Restaurarea setărilor ASP.NET ale directorului părinte pentru acest director virtual.",
    'b_aspdotnet__restore_default_disabled' => 'Restaurarea configurației ASP.NET implicite nu este disponibilă: Configurația ASP.NET este defectă, fie la nivel de server, fie la nivel de director părinte.',
    'b_autoinstaller' => 'Actualizarea Plesk sau a componentelor sale.',
    'b_autoinstaller_configure' => 'Actualizați setările.',
    'b_autoinstaller_install' => 'Instalarea componentelor selectate.',

    '__iis_app_pool__use_dedicated' => 'Listă dedicată de aplicații IIS',
    '__iis_app_pool__use_dedicated_addons' => 'Listă dedicată de aplicații IIS pentru fiecare site web',
    '__iis_app_pool__enable_32bit_app_on_win64' => 'Se acceptă aplicațiile pe 32 de biți',
    'bt_iis_app_pool' => "Listă de aplicații IIS",

    'performance__cpu_usage' => 'Grad maxim de ocupare CPU (%)',
    'performance__cpu_usage_action' => 'Acțiune la atingerea limitei',
    'performance__cpu_usage_interval' => 'Limitare interval (minute)',
    'performance__cpu_usage_action_not_supported' => 'Serverul web nu acceptă acțiunea specificată.',

    'performance__idle_timeout_action_not_supported' => 'Serverul web nu acceptă acțiunea specificată pentru expirarea conexiunii din cauză de inactivitate.',
    'performance__max_worker_processes' => 'Numărul maxim de procese de lucru care se pot executa',
    'performance__idle_timeout' => 'Expirare din cauza inactivității (minute)',
    'performance__idle_timeout_action' => 'Acțiune la expirare din cauza inactivității',
    'performance__recycling_by_time' => 'Se reciclează la intervale regulate (minute)',
    'performance__recycling_by_requests' => 'Se reciclează la atingerea numărului maxim de procese de lucru',
    'performance__recycling_by_virtual_memory' => 'Se reciclează atunci când se folosește volumul maxim de memorie virtuală',
    'performance__recycling_by_private_memory' => 'Se reciclează atunci când se folosește volumul maxim de memorie privată',
    'performance__managed_pipeline_mode' => 'Mod conductă gestionată',
    'performance__managed_pipeline_mode_not_supported' => 'Serverul web nu acceptă modul specificat.',

    'iis_app_pool' => 'Administrarea listei de aplicații IIS.',
    'b_iis_app_pool' => 'Administrarea listei de aplicații IIS.',
    'iis_app_pool_cl_dom' => 'Administrarea listei de aplicații IIS.',

    'i_webdirs_not_protected' => 'Acest director nu este protejat.',
    'i_webdirs_protected' => 'Acest director este protejat.',
    'i_webdirs_manage_protection' => 'Administrarea protecției.',
    'i_webdirs_open' => 'Deschiderea directorului/fișierului în browser.',
    'i_webdirs_preferences_disabled' => 'Acest director nu este unul virtual.',
    'i_webdirs_permissions' => 'Administrarea permisiunilor.',
    'i_webdirs_permissions_disabled' => 'Administrarea permisiunilor pentru directoare nu este disponibilă.',
    'i_webdirs_type_dir' => 'Director fizic',
    'i_webdirs_type_vdir' => 'Director virtual',
    'i_webdirs_browse' => 'Parcurgerea conținutului directorului.',
    'i_webdirs_preferences' => 'Administrarea setărilor de directoare web.',

    'l_webdirslist_type' => 'Sortarea directoarelor după tip.',
    'l_webdirslist_protected' => 'Sortarea directoarelor după starea protecției.',
    'l_webdirslist_name' => 'Sortarea directoarelor după nume.',

    'b_webdirslist_remove' => 'Ștergerea directoarelor virtuale selectate.',
    'b_webdirslist_search' => 'Introduceți un șir de căutare și faceți clic pentru a căuta directoarele virtuale.',
    'b_webdirslist_show_all' => 'Afișarea tuturor directoarelor.',

    'l_webdirerrordocslist_code' => 'Sortarea documentelor de eroare după codul erorii.',
    'l_webdirerrordocslist_name' => 'Sortarea documentelor de eroare după descrierea erorii.',
    'l_webdirerrordocslist_type' => 'Sortarea documentelor de eroare după tipul documentului de eroare.',
    'l_webdirerrordocslist_location' => 'Sortarea documentelor de eroare după locația documentului de eroare.',

    'b_webdirerrordocslist_search' => 'Introduceți un șir de căutare și faceți clic pentru a căuta documentele de eroare.',
    'b_webdirerrordocslist_remove' => 'Ștergerea documentelor de eroare selectate.',
    'b_webdirerrordocslist_show_all' => 'Afișarea tuturor documentelor de eroare.',

    'l_webdirmimetypeslist_name' => 'Sortarea tipurilor MIME după extensie.',
    'l_webdirmimetypeslist_content' => 'Sortarea tipurilor MIME după conținut.',

    'b_webdirmimetypeslist_remove' => 'Ștergerea tipurilor MIME selectate.',
    'b_webdirmimetypeslist_search' => 'Introduceți un șir de căutare și faceți clic pentru a căuta tipurile MIME.',
    'b_webdirmimetypeslist_show_all' => 'Afișarea tuturor tipurilor MIME.',

    'b_webdir_preferences' => "Setări de directoare virtuale.",
    'b_webdir_permissions' => "Permisiuni pentru directoarele virtuale.",
    'b_webdir_permissions_disabled' => "Administrarea permisiunilor pentru directoare nu este disponibilă.",
    'b_to_webdirs' => 'Revenire la administrarea directoarelor.',
    'b_to_webdir_mime_types' => 'Revenire la administrarea tipurilor de MIME.',
    'b_to_webdir_error_docs' => 'Revenire la administrarea documentelor de eroare.',
    'b_to_webdir_protection' => 'Revenire la administrarea protecției directoarelor virtuale.',

    'webdirs__title' => 'Directorul virtual %1',
    'webdirs__preferences_title' => 'Setări de directoare virtuale',
    'webdirs__list_legend' => 'Directoare virtuale',
    'webdirs__list_type' => 'T',
    'webdirs__list_protected' => 'P',
    'webdirs__list_name' => 'Nume',
    'webdirs__list_header' => '%1 elemente',
    'webdirs__tabs_general' => 'General',
    'webdirs__tabs_mime_types' => 'Tipuri MIME',
    'webdirs__tabs_error_docs' => 'Documente de eroare',

    'webdirs__tabs_permissions' => 'Permisiuni',
    'webdir__remove_vdirs' => 'Se vor șterge următoarele directoare virtuale:',
    'webdir__remove_mime_types' => 'Următoarele tipuri MIME vor fi șterse:',
    'webdir__mime_types_title' => 'Tipuri MIME',
    'webdir__protection_disable_confirm' => 'Sigur înlăturați protecția directorului?',
    'webdir__protect_title' => 'Utilizatori URL protejat',
    'webdirs__permissions_title' => 'Permisiuni pentru directoarele virtuale',
    'webdirs__browse_content_permission_denied' => 'Nu aveți permisiunea de a vizualiza conținutul acestui director.',
    'error_doc__list_code' => 'Eroare',
    'error_doc__list_code_description' => 'Descriere',
    'error_doc__list_type' => 'Tip',
    'error_doc__list_location' => 'Locație',
    'error_doc__code' => 'Eroare',
    'error_doc__type' => 'Tip',
    'error_doc__type_file' => 'Fișier',
    'error_doc__type_url' => 'URL',
    'error_doc__location' => 'Locație',
    'error_doc__legend' => 'Document de eroare',
    'error_doc__edit_title' => 'Editare document de eroare',
    'error_doc_erorr_invalid_url_location' => 'URL-ul este incorect. Specificați URL-ul corect.',
    'error_doc_erorr_invalid_file_location' => 'Calea de fișier este incorectă. Specificați calea de fișier corectă.',
    'error_doc__type_default' => 'Implicit',

    'webdirs__tabs_protection' => 'Protecție',
    'pb_webdirs' => 'Directoare virtuale',

    'webdirs_remove_title' => 'Se vor șterge următoarele directoare virtuale:',
    'webdirs_mime_types_remove_title' => 'Următoarele tipuri MIME vor fi șterse:',
    'webdirs_preferences_title' => 'Setări de directoare virtuale',
    'webdirs_permissions_title' => 'Permisiuni speciale pentru fișiere și foldere',
    'webdi_protection_disable_confirm' => 'Sigur înlăturați protecția directorului virtual? Această acțiune duce și la ștergerea tuturor utilizatorilor de director protejat și a setărilor de director protejat.',
    'bt_protect' => 'Protecție',
    'bt_unprotect' => 'Ștergere protecție',
    'bt_show_additional_users' => 'Se afișează mai mulți utilizatori',
    'bt_hide_additional_users' => 'Se afișează mai puțini utilizatori',
    'error_doc__list_title' => 'Documente de eroare',
    'error_doc__list_header' => 'Documente de eroare',
    'error_doc__code_400' => 'Solicitare incorectă',
    'error_doc__code_401' => 'Neautorizat',
    'error_doc__code_401.1' => 'Neautorizat – Conectarea nu a reușit',
    'error_doc__code_401.2' => 'Neautorizat – Conectarea nu a reușit din cauza configurației serverului',
    'error_doc__code_401.3' => 'Neautorizat – Neautorizat prin lista de control al accesului la resursă',
    'error_doc__code_401.4' => 'Neautorizat – Autorizarea nu a reușit din cauza filtrului',
    'error_doc__code_401.5' => 'Neautorizat – Autorizarea nu a reușit din cauza aplicației ISAPI/CGI',
    'error_doc__code_401.7' => 'Neautorizat – Refuzat în baza politicii de autorizare de URL',
    'error_doc__code_403' => 'Interzis',
    'error_doc__code_403.1' => 'Interzis – Accesul pentru executare a fost refuzat',
    'error_doc__code_403.2' => 'Interzis – Accesul pentru citire a fost refuzat',
    'error_doc__code_403.3' => 'Interzis – Accesului pentru scriere a fost refuzat',
    'error_doc__code_403.4' => 'Interzis – SSL obligatoriu',
    'error_doc__code_403.5' => 'Interzis – SSL 128 obligatoriu',
    'error_doc__code_403.6' => 'Interzis – Adresa IP a fost refuzată',
    'error_doc__code_403.7' => 'Interzis – Certificatul de client este obligatoriu',
    'error_doc__code_403.8' => 'Interzis – Accesul al site a fost refuzat',
    'error_doc__code_403.9' => 'Interzis – Prea mulți utilizatori',
    'error_doc__code_403.10' => 'Interzis – Configurație incorectă',
    'error_doc__code_403.11' => 'Interzis – Schimbare parolă',
    'error_doc__code_403.12' => 'Interzis – Componenta de mapare nu a acordat acces',
    'error_doc__code_403.13' => 'Interzis – Certificat de client revocat',
    'error_doc__code_403.14' => 'Interzis – Listarea directoarelor nu este permisă',
    'error_doc__code_403.15' => 'Interzis – S-a depășit numărul de licențe de acces client',
    'error_doc__code_403.16' => 'Interzis – Certificatul de client nu prezintă încredere sau nu are format corect',
    'error_doc__code_403.17' => 'Interzis – Certificatul de client a expirat sau nu a intrat încă în vigoare',
    'error_doc__code_403.18' => 'Interzis – Nu se pot executa solicitările provenite din această listă de aplicații',
    'error_doc__code_403.19' => 'Interzis – Accesul CGI a fost refuzat',
    'error_doc__code_403.20' => 'Interzis – Conectarea cu pașaport nu a reușit',
    'error_doc__code_404' => 'Negăsit',
    'error_doc__code_404.2' => 'Negăsit – Refuzat în baza politicii de blocare',
    'error_doc__code_404.3' => 'Negăsit – Refuzat în baza politicii MIMEMAP',
    'error_doc__code_405' => 'Metodă nepermisă',
    'error_doc__code_406' => 'Inacceptabil',
    'error_doc__code_407' => 'Este necesară autentificarea proxy',
    'error_doc__code_412' => 'Precondiție neîndeplinită',
    'error_doc__code_414' => 'URI solicitare prea lung',
    'error_doc__code_415' => 'Tip media neacceptat',
    'error_doc__code_500' => 'Eroare internă pe server',
    'error_doc__code_500.12' => 'Eroare internă pe server – Se repornește aplicația',
    'error_doc__code_500.13' => 'Eroare internă pe server – Serverul este suprasolicitat',
    'error_doc__code_500.15' => 'Eroare internă pe server – Solicitările directe de GLOBAL.ASA sunt interzise',
    'error_doc__code_500.16' => 'Eroare internă pe server – Eroare de acces UNC',
    'error_doc__code_500.17' => 'Eroare internă pe server – Stocarea de autorizare URL nu a fost găsită',
    'error_doc__code_500.18' => 'Eroare internă pe server – Imposibil de deschis stocarea de autorizare URL',
    'error_doc__code_500.19' => 'Eroare internă pe server – Metadate de fișier incorecte',
    'error_doc__code_500.100' => 'Eroare internă pe server – Eroare ASP',
    'error_doc__code_501' => 'Neimplementat',
    'error_doc__code_502' => 'Gateway incorect',
    'error_doc__code_503' => 'Serviciul este temporar indisponibil',

    'mimetype__extension' => 'Extensie',
    'mimetype__content' => 'Conținut',
    'mimetypeslist__title' => 'Tipuri MIME',
    'mimetypes__title' => 'Tipuri MIME',
    'mimetypes__select_to_remove' => 'Selectați tipurile MIME pe care doriți să le ștergeți.',
    'mimetypes__select_for_remove' => "Selectați tipurile MIME de șters.",
    'mimetypes_remove__title' => 'Ștergere tip MIME',
    'mimetype__legend' => 'Tip MIME',
    'mimetype_edit__title' => 'Editarea tipului MIME',
    'mimetype_edit__already_exists' => 'Tipul MIME este definit deja de această extensie.',
    'mimetype_edit__not_exists' => 'Tipul MIME nu există.',
    'mimetype__content_type_other' => 'Personalizat...',

    'b_webdir_protection_enable' => 'Setarea URL-ului de director drept protejat prin parolă.',
    'b_webdir_protection_disable' => 'Setarea URL-ului de director drept accesibil tuturor.',
    'b_webdir_protection_disabled' => 'Protecția de directoare virtuale este dezactivată.',

    'b_pd_usr_create' => 'Faceți clic pentru a crea acest utilizator de URL protejat.',
    'php__changeversion_title' => "Selectați versiunea PHP",
    'php__group_php_version' => "Versiune PHP",

    'virtualdir__name' => 'Nume',
    'virtualdir__path' => 'Cale',
    'virtualdir__read' => 'Permisiune de citire',
    'virtualdir__read_short' => 'R',
    'virtualdir__write' => 'Permisiune de scriere',
    'virtualdir__write_short' => 'W',
    'virtualdir__source' => 'Acces la sursa scripturilor',
    'virtualdir__source_short' => 'S',
    'virtualdir__browse' => 'Navigare în directoare',
    'virtualdir__browse_short' => 'B',
    'virtualdir__script_execute' => 'Permisiuni de executare',
    'virtualdir__script_execute_short' => 'E',
    'virtualdir__log_visits' => 'Înregistrarea în jurnal a vizitelor',
    'virtualdir__app_create' => 'Creare aplicație',
    'virtualdir__app_create_short' => 'A',
    'virtualdir__auth_anon' => 'Activează autentificarea anonimă.',
    'virtualdir__auth_windows' => 'Activează autentificarea Windows.',
    'virtualdir__auth_not_enabled' => 'Autentificarea anonimă sau Windows trebuie să fie activată.',
    'virtualdir__require_ssl' => 'Obligatoriu SSL/TLS',
    'virtualdir__enable_default_doc' => 'Se utilizează documentele implicite',
    'virtualdir__default_doc' => 'Ordinea implicită de căutare a documentelor',
    'virtualdir__enable_parent_paths' => 'Se permite utilizarea căilor părinte',
    'virtualdir__execute_in_mta' => 'Se permite executarea aplicațiilor în modul MTA (multi-threaded apartment)',
    'virtualdir_create__title' => 'Creare director virtual în %1',
    'virtualdir_edit__title' => 'Proprietățile directorului virtual %1',
    'virtualdir_edit__legend' => 'Director virtual',
    'virtualdir_edit__application_legend' => 'Setări de aplicație',
    'virtualdir_edit__security_legend' => 'Securitate director',
    'virtualdir_edit__documents_legend' => 'Documente',
    'virtualdir_edit__list_legend' => 'Directoare virtuale imbricate',
    'virtualdir_error__path_not_in__' => 'Calea specificată este incorectă',
    'virtualdir_error__already_exists' => 'Deja există un director cu acest nume.',
    'virtualdir_root' => 'Directoare virtuale',
    'virtualdir_root__title' => 'Directoare virtuale',
    'virtualdir_root__list_legend' => 'Directoare virtuale',
    'virtualdir_se__none' => 'Niciunul',
    'virtualdir_se__script' => 'Doar scripturi',
    'virtualdir_se__script_execute' => 'Scripturi și fișiere executabile',
    'virtualdirs__title' => 'Directoare virtuale',
    'virtualdirs__path_not_exists' => 'Cale incorectă.',
    'virtualdirs__select_for_remove' => "Selectați directoarele virtuale pe care doriți să le ștergeți.",
    'virtualdirs_remove__title' => 'Ștergerea directoarelor virtuale',
    'virtualdirs_phys_dir_exist' => 'Deja există un director fizic cu acest nume. În cazul în care continuați, acesta va deveni inaccesibil. Continuați?',
    'virtualdir_auto_create_dir' => "Creare director fizic cu nume identic cu al directorului virtual",

    'asp_max_default_text' => 'Definit de directorul părinte (%1 KB)',
    'asp_max_default_text_site' => 'Definit de IIS (%1 KB)',
    'asp_max_buffer_text' =>'Dimensiunea maximă a zonei tampon ASP (KB)',
    'asp_max_body_text' => 'Dimensiunea maximă a corpului de entitate al unei solicitări ASP (KB)',
    'asp_buffers_legend' =>'Setări ASP',

    'asp_debug_default_text' =>'Definit de directorul părinte',
    'asp_debug_default_text_site' =>'Definit de IIS',
    'asp_client_debug_text' =>'Se permite depanarea scripturilor ASP pe client',
    'asp_server_debug_text' =>'Se permite depanarea scripturilor ASP pe server',

    'webdirs__list_with_broken_dirs' => "Există directoare virtuale legate de foldere fizice inexistente.",
    'webdirs__vdir_physical_path_not_exist' => "Directorul virtual este legat de un folder fizic inexistent.",
    'webdirs__physical_path_not_exist' => "Calea specificată nu există.",

    'filemanager__new_dir_title' => 'Creare director',
    'php__configuration_title' => "Configurare PHP",

    'permissions__title' => 'Configurarea permisiunilor de acces',
    'permissions__title_advanced' => 'Configurare avansată a permisiunilor de acces',
    'permissions__inherit_from_parent' => 'Se permite propagarea tuturor permisiunilor care se pot moșteni, de la părinte către acest obiect și cele subordonate obiectului. Se includ acestea împreună cu intrările definite explicit aici.',
    'permissions__replace_on_children' => 'Intrările de permisiuni ale tuturor obiectelor copil se înlocuiesc cu cele afișate aici.',
    'permissions__group_or_user_name' => 'Nume de grup sau de utilizator',
    'permissions__Permissions_for' => 'Permisiuni de',
    'permissions__allow' => 'Se permite',
    'permissions__deny' => 'Refuzare',
    'permissions__FullControl' => 'Control complet',
    'permissions__Modify' => 'Modificare',
    'permissions__ReadAndExecute' => 'Citire și executare',
    'permissions__ListFolderContents' => 'Listarea conținutului de folder',
    'permissions__Read' => 'Citire',
    'permissions__Write' => 'Scriere',
    'permissions__ReadControl' => 'Controlul citirii',
    'permissions__WriteControl' => 'Control de scriere',
    'permissions__ExecuteControl' => 'Controlul executării',
    'permissions__TraverseFolderOrExecuteFile' => 'Traversare folder/executare fișier',
    'permissions__ListFolderOrRead' => 'Listarea conținutului de folder/citire date',
    'permissions__CreateFilesOrWrite' => 'Creare fișiere/scriere date',
    'permissions__CreateFoldersOrAppend' => 'Creare foldere/adăugare date',
    'permissions__DeleteSubfoldersandFiles' => 'Ștergerea subfolderelor și a fișierelor',
    'permissions__Delete' => 'Ștergere',
    'permissions__ChangePermissions' => 'Modificare permisiuni',
    'permissions__TakeOwnership' => 'Preluare proprietate',
    'permissions__inherited_from' => 'Moștenit de la',
    'permissions__not_inherited' => '<fără moștenire>',
    'permissions__apply_to' => 'Se aplică',
    'permissions__apply_onto' => 'Se aplică la:',
    'permissions__apply_onto1' => 'Doar acestui folder',
    'permissions__apply_onto2' => 'Doar subfolderelor',
    'permissions__apply_onto3' => 'Acestui folder și subfolderelor sale',
    'permissions__apply_onto4' => 'Doar fișierelor',
    'permissions__apply_onto5' => 'Acestui folder și fișierelor din acesta',
    'permissions__apply_onto6' => 'Doar subfolderelor și fișierelor',
    'permissions__apply_onto7' => 'Acestui folder, subfolderelor și fișierelor',

    'filemanager__not_allowed_dir' => "Nu aveți dreptul să schimbați permisiunile pentru acest folder.",

    'filemanager__allow' => "Se permite",
    'filemanager__deny' => "Refuzare",
    'filemanager__user_domusr' => 'Administrator site web',
    'filemanager__user_webusr' => 'Utilizator web',
    'filemanager__user_admins' => 'Administratori',
    'filemanager__user_system' => 'SISTEM',
    'filemanager__user_aspnet' => 'Utilizator ASP.NET',
    'filemanager__user_poolusr' => 'Utilizator listă de aplicații',
    'filemanager__user_sysaccount' => 'Utilizator de sistem suplimentar',

    'bt_permissions_advanced' => 'Avansat',
    'b_permissions_advanced' => 'Faceți clic pentru a vizualiza și a seta permisiunile speciale.',

    'b_hotlinkprotection' => 'Configurarea protecției hotlink pentru site-ul web.',
    'b_hotlinkprotection_on' => 'Activarea protecției hotlink a conținutului de site web.',
    'b_hotlinkprotection_off' => 'Dezactivarea protecției hotlink a conținutului de site web.',

    'bt_hotlinkprotection' => 'Protecție hotlink',
    'hotlinkprotection__title' =>'Protecție hotlink',
    'hotlinkprotection__friend_domains' => 'Adresele site-urilor web prietenoase',
    'hotlinkprotection__extensions' => 'Extensii de fișiere protejate',

    'hotlinkprotection_invalid_friend_domains' => 'Nume incorecte pentru domeniile prietenoase.',
    'hotlinkprotection_invalid_extensions' => 'Extensiile de fișiere conțin caractere incorecte.',

    'i_domain_alias_status_on' => 'Aliasul de domeniu este activat.',
    'i_domain_alias_status_off' => 'Aliasul de domeniu este dezactivat.',
    'i_domain_alias_status_with_parent' => 'Aliasul de domeniu este dezactivat pentru că domeniul este dezactivat.',
    'i_domain_alias_turn_off' => 'Faceți clic pentru a dezactiva.',
    'i_domain_alias_turn_on' => 'Faceți clic pentru a activa.',
    'i_domain_alias_mail_on' => 'Serviciul de e-mail este activat pentru acest alias de domeniu.',
    'i_domain_alias_mail_off' => 'Serviciul de e-mail este dezactivat pentru acest alias de domeniu.',
    'i_domain_alias_mail_with_parent' => 'Serviciul de e-mail dezactivat pentru că aliasul de domeniu este dezactivat.',
    'i_domain_alias_web_on' => 'Serviciul web este activat pentru acest alias de domeniu.',
    'i_domain_alias_web_off' => 'Serviciul web este dezactivat pentru acest alias de domeniu.',
    'i_domain_alias_web_with_parent' => 'Serviciul web dezactivat pentru că aliasul de domeniu este dezactivat.',
    'i_domain_alias_dns_on' => 'Serviciul de aliasuri DNS este activat pentru acest alias de domeniu.',
    'i_domain_alias_dns_off' => 'Serviciul de aliasuri DNS este dezactivat pentru acest alias de domeniu.',
    'i_domain_alias_dns_with_parent' => 'Sincronizarea DNS cu domeniul părinte este dezactivată pentru că aliasul de domeniu este dezactivat.',
    'i_domain_alias_seoRedirect_on' => 'Redirecționarea cu codul HTTP 301 este activată pentru acest alias de domeniu.',
    'i_domain_alias_seoRedirect_off' => 'Redirecționarea cu codul HTTP 301 este dezactivată pentru acest alias de domeniu.',
    'i_domain_alias_seoRedirect_with_parent' => 'Redirecționarea cu codul HTTP 301 este dezactivată pentru că aliasul de domeniu este dezactivat.',

    'domain_alias__control_title' => 'Alias de domeniu %1',
    'domain_alias__control_info_legend' => 'Informații',
    'domain_alias__control_status_title' => 'S',
    'domain_alias__control_name_title' => 'Nume serviciu',
    'domain_alias__control_details_title' => 'Detalii',

    'domain_alias__invalid_values' => 'Numele de domeniu specificat este incorect. Numele de domenii nu pot conține decât litere, cifre și cratime. Fiecare parte a numelui de domeniu, cuprinsă între puncte, trebuie să aibă o lungime de cel mult 63 de simboluri.',
    'domain_alias__domain_already_exists' => "Nume incorect pentru aliasul de domeniu %1. Domeniul %1 există deja.",
    'domain_alias__www_prefix_domain_already_exists' => "Nume incorect al aliasului de domeniu www.%1. Acest alias a fost creat deja pentru domeniul %1.",
    'domain_alias__webmail_enabled_domain_already_exists' => 'Nume incorect pentru serviciul de e-mail prin web corespunzător aliasului de domeniu. %1. Acest alias a fost creat deja pentru domeniul %1.',
    'domain_alias__lists_enabled_domain_already_exists' => 'Nume incorect pentru lista de aliasuri de domeniu. %1. Acest alias a fost creat deja pentru domeniul %1.',
    'domain_alias__dns_record_already_exists' => 'Imposibil de configurat aliasul de domeniu %1: deja există o înregistrare DNS care indică gazda %1.',
    'domain_alias__domain_alias_already_exists' => "Deja există un alias de domeniu cu acest nume.",
    'domain_aliases__mail_server_not_support_aliases' => 'Serverul de e-mail nu acceptă funcția de aliasuri de domeniu. Este posibil ca aliasurile de domeniu să nu funcționeze corect.',
    'domain_alias__restrict_domain_creation' => 'Numele specificat pentru aliasul de domeniu este interzis de politica la nivel de server. Dacă acest nume de alias de domeniu vă aparține, contactați furnizorul de servicii de găzduire.',
    'domain_alias__restrict_creation_with_www' => 'Introduceți un nume de domeniu fără prefixul „www”. Prefixul „www” va fi adăugat automat la configurația serverului web.',
    'domain_unable_to_set_name' => 'Nume incorect %1.',

    'domain_alias__domain_service_dns_disabled' => 'Acest domeniul este deservit de un alt server DNS.',
    'domain_alias__domain_service_dns_enabled_master' => 'Acest server DNS are rol de server de nume principal în această zonă DNS.',
    'domain_alias__domain_service_dns_enabled_slave' => 'Acest server DNS are rol de server de nume secundar în această zonă DNS.',
    'domain_alias__domain_service_mail_enabled' => 'Serviciul de e-mail este activat în domeniu.',
    'domain_alias__domain_service_mail_disabled' => 'Serviciul de e-mail este dezactivat în domeniu.',
    'domain_alias__domain_service_mail_mx' => '%1 este utilizat ca server de e-mail.',

    'domain_alias__service_seoRedirect_hint' => 'Atunci când vizitatorii deschid URL-ul corespunzător aliasului, vor fi redirecționați către URL-ul domeniului principal. Plesk utilizează redirecționarea HTTP 301, compatibilă cu motoarele de căutare, ceea ce înseamnă că în clasamentul întocmit de motorul de căutare URL-urile nu vor apărea separat.',

    'bt_task_run_now' => 'Executare imediată',
    'ftp__read_perm' => "Permisiune de citire",
    'ftp__write_perm' => "Permisiune de scriere",

    'filemanager__upload_backup_file_hint' => 'Aici puteți încărca fișierele copie de rezervă în spațiul de stocare Plesk. Dimensiunea de fișier maximă este limitată la doi gigabyți.',

    '__default_for_mssql' => 'implicit pentru MS SQL',

    '__login_does_not_pass_validation' => "Numele de utilizator este incorect. Asigurați-vă că respectă următoarele cerințe: %1",
    '__login_allowed_symbols' => 'Se acceptă doar caracterele alfanumerice, inclusiv punctele, cratimele și liniuțele de subliniere. Primul caracter trebuie să fie alfanumeric.',

    'restart__nginx' => 'Server proxy invers (nginx)',
    'restart__php-fpm' => 'PHP-FPM %1',

    'admin_ed__i_would_like_recieve_announce' => "Doresc să primesc de la Plesk informații și anunțuri generale despre produse.",
    'admin_ed__i_would_like_recieve_tech_announce' => "Doresc să primesc de la Plesk informații legate de securitate și alte anunțuri tehnice.",

    '__login_status_inactive' => 'Contul dvs. este inactiv. Contactați administratorul Plesk.',

    'migration__task_keep_in_process' => 'OK',
    'migration__task_keep_in_process_conhelp' => 'Revenire la pagina Instrumente și setări. Migrarea va continua în fundal.',

    'ui__admin-alias-info__description' => "Editarea informațiilor de contact ale contului de administrator suplimentar.",
    'ui__admin-alias-info__short-title' => "Informații de contact",
    'ui__admin-alias-info__title' => "Informații despre contul de administrator suplimentar",
    'ui__admin-alias-password__description' => "Schimbarea parolei de administrator suplimentar.",

    'ui__admin-alias-password__short-title' => "Schimbare parolă",
    'ui__admin-alias-password__title' => "Parola administratorului suplimentar",
    'ui__admin-alias__description' => "Vizualizarea și modificarea informațiilor despre contul de administrator suplimentar.",

    'chk_js__warning_about_login_syntax' => "În numele de utilizator puteți utiliza litere mici, cifre, cratime și caractere de subliniere. Numele de utilizator trebuie să înceapă cu o literă. Parola nu poate conține numele de utilizator, nici ghilimele.",
    'chk_js__warning_about_ftp_login_syntax' => "În numele de utilizator puteți utiliza litere, cifre, cratime și caractere de subliniere.",
    'chk_js__warning_about_login_syntax_win' => "În numele de utilizator puteți utiliza litere mici, cifre, cratime, puncte și caractere de subliniere. Numele de utilizator trebuie să înceapă cu o literă sau cu o cifră. Parola nu poate conține numele de utilizator, nici ghilimele.",
    'chk_js__warning_about_passwd_syntax' => "Nu folosiți ghilimele, spații și diacritice în parolă.\nLungimea parolei trebuie să fie cuprinsă între %1 și %2 caractere. Parola nu poate conține numele utilizatorului.",
    'chk_js__warning_about_plesk_login_syntax' => "În numele de utilizator puteți utiliza litere mici, cifre, puncte, cratime și caractere de subliniere.",
    'chk_js__warning_about_plesk_login_syntax_win' => "În numele de utilizator puteți utiliza litere mici, cifre, cratime și caractere de subliniere. Numele de utilizator trebuie să înceapă cu o literă.",
    'chk_js__warning_about_plesk_passwd_syntax' => "Nu folosiți ghilimele, spații și diacritice în parolă.\nLungimea parolei trebuie să fie cuprinsă între %1 și %2 caractere. Parola nu poate conține numele utilizatorului.",
    'chk_js__warning_about_pam_passwd_error' => "S-a specificat un cont de utilizator de sistem incorect: %1",

    'cmd_server__admin_alias_not_found' => "Imposibil de găsit contul de administrator suplimentar.",

    'panel_branding__skins_already_exists' => "Rețineți: Tema „%1” există deja. Va fi înlocuită cu tema pe care o instalați acum.",
    'panel_branding__skins_file_exists' => "Imposibil de creat directorul pentru tema „%1”: Deja există un fișier cu acest nume.",

    'actionlog__login_failed' => 'nu a reușit să se conecteze',
    'actionlog__event_cp_user_login_failed' => 'Utilizatorul Plesk nu a reușit să se conecteze',
    'actionlog__api_login_failed' => 'nu a reușit să se conecteze prin API',
    'actionlog__event_cp_user_api_login_failed' => 'Utilizatorul Plesk nu a reușit să se conecteze prin API',
    'actionlog__pw_reset' => 's-a solicitat resetarea parolei',

    'ch_pass_admin__email_subject' => "Memento de parolă Plesk",
    'ch_pass_admin__email_body' => "Bună ziua, %1.\n\nDin motive de securitate, parola de administrator nu se poate trimite prin e-mail.\n\nPentru a vă conecta ca „admin”, utilizați comanda „plesk login”.\n\nPentru a seta o nouă parolă de „admin”, utilizați comanda „plesk bin admin --set-password -passwd <new_password>”.\n\n",
    'ch_pass_admin__message_send_error' => 'Imposibil de trimis e-mailul: %1',

    'ch_pass_by_secret__email_subject' => "Memento de parolă Plesk",
    'ch_pass_by_secret__email_body' => "Bună ziua, %2, \n\nPentru a defini o parolă nouă, urmați linkul: %1 \n\nNumele de conectare: %3",
    'ch_pass_by_secret__message_send_error' => 'Eroare la trimiterea codului secret: %1',
    'ch_pass_by_secret__title' => 'Schimbare parolă',
    'ch_pass_by_secret__secret' => 'Cod secret',

    'custom_button__noframe' => "Nu se utilizează cadre",

    'custom_button__internal_hint' => 'Specificați dacă URL-ul se va deschide într-o pagină Plesk sau într-o nouă fereastră de browser.',
    'custom_button__noframe_hint' => 'Dacă adăugați un buton personalizat care conduce la o extensie Plesk sau la o aplicație în Panoul de control, puteți specifica modul în care se va afișa extensia/aplicația: într-un cadru sau ca parte a interfeței grafice Plesk.',


    'actionlog__patch' => 'Actualizare',
    'actionlog__patch_available' => 'disponibil',
    'actionlog__event_patch_available' => 'Este disponibilă o actualizare',
    'actionlog__patch_installed' => 'instalat',
    'actionlog__event_patch_installed' => 'Actualizarea a fost instalată',

    'actionlog__extension' => 'Extensie',
    'actionlog__extension_status' => 'Starea extensiei',
    'actionlog__cloning' => 'Clonare server',
    'actionlog__cloning_complete' => 'finalizată',
    'actionlog__event_cloning_complete' => 'Clonarea de server s-a terminat',

    'actionlog__ssl_web_binding' => 'Certificatul SSL/TLS al domeniului',
    'actionlog__ssl_web_binding_update' => 'a fost atribuit/atribuirea acestuia a fost anulată',
    'actionlog__event_ssl_web_binding_update' => 'Certificatul SSL/TLS al domeniului a fost atribuit/atribuirea acestuia a fost anulată',

    'actionlog__ssl_web_mail_binding' => 'Certificatul SSL/TLS al sistemului webmail',
    'actionlog__ssl_web_mail_binding_update' => 'a fost atribuit/atribuirea acestuia a fost anulată',
    'actionlog__event_ssl_web_mail_binding_update' => 'Certificatul SSL/TLS al sistemului de webmail a fost atribuit/atribuirea acestuia a fost anulată',

    'actionlog__ssl_mail_binding' => 'Certificatul SSL/TLS al serverului de e-mail',
    'actionlog__ssl_mail_binding_update' => 'a fost atribuit/atribuirea acestuia a fost anulată',
    'actionlog__event_ssl_mail_binding_update' => 'Certificatul SSL/TLS al serverului de e-mail a fost atribuit/atribuirea acestuia a fost anulată',

    'actionlog__ssl_panel_binding' => 'Certificatul SSL/TLS al sistemului Plesk',
    'actionlog__ssl_panel_binding_update' => 'a fost atribuit/atribuirea acestuia a fost anulată',
    'actionlog__event_ssl_panel_binding_update' => 'Certificatul SSL/TLS al sistemului Plesk a fost atribuit/atribuirea acestuia a fost anulată',

    'actionlog__hostname' => 'Nume de gazdă server',
    'actionlog__hostname_changed' => 'modificare',

    'actionlog__smb_user' => 'Utilizator suplimentar',
    'actionlog__smb_user_create' => 'Utilizator suplimentar creat',
    'actionlog__smb_user_delete' => 'Utilizator suplimentar șters',
    'actionlog__smb_user_update' => 'Utilizator suplimentar actualizat',

    'actionlog__event_mail_management_status_update' => 'Informare despre starea gestionării de e-mail',
    'actionlog__mail_management' => 'Starea gestionării de e-mail',
    'actionlog__mail_management_status_update' => 'actualizare',

    'virtualization_openvz' => 'OpenVZ',

    '__domains_total' => 'Total pe domenii',

    'chk_js__warning_about_admin_passwd_syntax' => "Nu folosiți ghilimele, caractere punct și virgulă, spații și diacritice în parolă. Lungimea parolei trebuie să fie cuprinsă între %1 și %2 caractere. Parola nu poate conține numele utilizatorului.",

    'passwordSecurityLevelCheckFailed' => 'Parola nu este suficient de complexă. Conform politicii de server, gradul de complexitate minim al parolei este %1. Pentru a îmbunătăți complexitatea parolei, utilizați cifre, litere mici și mari, precum și caractere speciale ca !,@,#,$,%,^,&,*,?,_,~',
    'passwordSecurityLevelCheckFailedVeryWeak' => 'Foarte scăzut',
    'passwordSecurityLevelCheckFailedWeak' => 'Scăzut',
    'passwordSecurityLevelCheckFailedMediocre' => 'Mediu',
    'passwordSecurityLevelCheckFailedStrong' => 'Ridicat',
    'passwordSecurityLevelCheckFailedStronger' => 'Foarte ridicat',

    'cu__php_settings__command_update_all' => "Actualizarea setărilor PHP la nivel de domeniu pentru toate domeniile, conform fișierului php.ini la nivel de server.",
    'cu__php_settings__update_all_done' => "Setările PHP la nivel de domeniu ale tuturor domeniilor au fost încărcate cu succes.",

    'filemanager__invalid_path' => "Calea specificată este incorectă",

    'ui__client/domain/dns/sync__description' => 'Aplicarea modificărilor din șablonul DNS la nivel de server zonei.',
    'ui__client/domain/dns/sync__disabled-warning' => 'Modificările din șablonul DNS nu se pot aplica zonei, deoarece zona este deservită de un alt server DNS.',
    'ui__client/domain/dns/sync__short-title' => 'Aplicarea modificărilor de șablon DNS',
    'ui__client/domain/dns/sync__done' => 'Modificările din șablonul DNS au fost aplicate cu succes zonei.',
    'ui__client/domain/domain-alias/dns/sync__description' => 'Aplicarea modificărilor din șablonul DNS la nivel de server zonei.',
    'ui__client/domain/domain-alias/dns/sync__disabled-warning' => 'Modificările din șablonul DNS nu se pot aplica zonei, deoarece zona este deservită de un alt server DNS.',
    'ui__client/domain/domain-alias/dns/sync__short-title' => 'Aplicarea modificărilor de șablon DNS',
    'ui__client/domain/domain-alias/dns/sync__done' => 'Modificările din șablonul DNS au fost aplicate cu succes zonei.',
    'dns__dns_default_ipv4_modified' => 'Înregistrările cu această adresă IP vor fi considerate modificate de către utilizator și nu vor fi sincronizate cu șablonul DNS la nivel de server.',
    'dns__dns_default_ipv6_modified' => 'Înregistrările cu această adresă IP vor fi considerate modificate de către utilizator și nu vor fi sincronizate cu șablonul DNS la nivel de server.',

    'dns__view_dns_record_master_title' => 'Vizualizarea înregistrărilor resursă',
    'dns__view_dns_record_off_title' => 'Vizualizarea înregistrărilor server de nume',
    'dns__view_dns_record_slave_title' => 'Vizualizarea înregistrărilor server DNS principal',

    'dns_unable_to_resolve_hostname' => "Imposibil de rezolvat numele de gazdă „%1”: %2 Asigurați-vă că programul de rezolvare DNS din sistemul de operare este instalat și funcționează corect.",

    'no_database_server_available' => 'Nu există servere de baze de date disponibile pentru acest abonament.',

    'database_used_by_application_can_not_be_moved' => 'Imposibil de mutat baza de date: O aplicație web utilizează această bază de date.',
    'database_user_update_orphaned_is_restricted' => 'Actualizarea conturilor de utilizator de baze de date rămase orfane nu este permisă. Sunt posibile doar operațiile de ștergere, respectiv de reparare.',

    'database_unable_to_get_max_filesize_default_message' => 'Imposibil de determinat dimensiunea de fișier maximă a bazei de date Microsoft SQL: „%1”',
    'database_unable_to_set_max_filesize_default_message' => 'Imposibil de setat dimensiunea de fișier maximă a bazei de date Microsoft SQL: „%1”',
    'database_unable_to_get_max_log_filesize_default_message' => 'Imposibil de determinat dimensiunea maximă a fișierului jurnal al bazei de date Microsoft SQL: „%1”',
    'database_unable_to_set_max_log_filesize_default_message' => 'Imposibil de setat dimensiunea maximă a fișierului jurnal al bazei de date Microsoft SQL: „%1”',

    'database_unable_to_get_max_filesize' => 'Imposibil de determinat limita actuală a dimensiunii de fișier a bazei de date Microsoft SQL „%1”. Nu se poate seta o limită nouă.',
    'database_unable_to_set_max_filesize' => 'Imposibil de setat limita dimensiunii de fișier a bazei de date Microsoft SQL „%1”.',
    'database_unable_to_get_max_log_filesize' => 'Imposibil de determinat limita actuală a dimensiunii fișierului jurnal al bazei de date Microsoft SQL „%1”. Nu se poate seta o limită nouă.',
    'database_unable_to_set_max_log_filesize' => 'Imposibil de setat limita dimensiunii fișierului jurnal al bazei de date Microsoft SQL „%1”.',

    'database_unable_to_create_because_max_filesize' => 'Imposibil de creat baza de date Microsoft SQL „%1”: Dimensiunea de fișier depășește limita maximă admisă.',
    'database_unable_to_move_because_max_filesize' => 'Imposibil de mutat baza de date Microsoft SQL „%1”: Dimensiunea de fișier depășește limita maximă admisă: %2.',
    'database_unable_to_create_because_max_log_filesize' => 'Imposibil de creat baza de date Microsoft SQL „%1”: Dimensiunea fișierului jurnal depășește limita maximă admisă.',
    'database_unable_to_move_because_max_log_filesize' => 'Imposibil de mutat baza de date Microsoft SQL „%1”: Dimensiunea fișierului jurnal depășește limita maximă admisă: %2.',
    'database_unable_to_restore_because_max_filesize' => 'Imposibil de restaurat baza de date Microsoft SQL „%1”: Dimensiunea de fișier depășește limita maximă admisă.',

    'sandbox_mssql_server_registered_as_usual_db_server' => 'În Plesk este înregistrat deja un server MS SQL identic. Specificați un alt server MS SQL pentru teste.',
    'database_server__mssql_server_registered_as_sandbox' => 'În Plesk este înregistrat deja un server MS SQL pentru teste identic. Specificați un alt server MS SQL pentru teste.',

    'database_server_mysql_unable_to_connect_via_cli' => 'Imposibil de conectat la server prin „%1”: %2',

    'bu_conflict_resolver_feature_not_available' => 'Funcția %1 nu este acceptată de următoarele noduri de serviciu: %2. Funcția va fi dezactivată pentru toate obiectele create pe aceste noduri.',
    'bu_conflict_resolver_feature_not_available_single_server' => 'Funcția %1 nu este acceptată de acest server. Funcția va fi dezactivată pentru toate obiectele restaurate.',
    'bu_conflict_resolver_component_unavailable_in_sites' => 'Componenta %1 nu este instalată. Nu va fi disponibilă pentru următoarele site-uri web: {{objects}}',
    'bu_conflict_resolver_component_replaced_in_sites' => 'Componenta %1 nu este instalată. Va fi înlocuită cu %2 pentru următoarele site-uri web: {{objects}}',

    'bu_conflict_resolver_restoration_of_object_end_to_dot_not_supported' => 'Versiunea Plesk actuală nu acceptă numele de utilizatori care conțin caracterul punct (.) Clienții și resellerii cu asemenea nume de utilizatori nu vor fi restaurați.',
    'bu_conflict_resolver_unable_to_find_backup_part' => 'Imposibil de găsit fișierul copie de rezervă cu datele de %1 %2. Datele de %1 %2 nu vor fi restaurate.',

    'bu_conflict_resolver_zone_master_removed' => "Imposibil de restaurat înregistrarea DNS principală: Înregistrarea din zona secundară indică adresa IP existentă %1. Înregistrarea DNS principală va fi ștearsă din zona secundară.",

    'bu_conflict_resolver_not_available_scripting' => 'Funcția %1 nu este acceptată.',
    'bu_conflict_resolver_not_available_scripting_in_sites' => 'Funcția %1 nu este acceptată. Nu va fi disponibilă pentru următoarele site-uri web: {{objects}}',
    'bu_conflict_resolver_not_available_component' => 'Componenta %1 nu este instalată.',
    'bu_conflict_resolver_disabled_in_multi_server' => 'Nu va fi disponibilă pentru următoarele noduri de serviciu: {{objects}}',
    'bu_conflict_resolver_disabled_in_single_server' => 'Nu va fi disponibilă pentru următoarele obiecte: {{objects}}',
    'bu_conflict_resolver_not_available_db' => 'Următoarele servere de baze de date nu sunt disponibile pe acest server: %1.',

    'bu_conflict_resolver_mssql_native_dump_restore_not_available' => 'Fișierul cu copia de rezervă a bazei de date MS SQL are formatul propriu MS SQL, care se poate restaura numai pe serverul MS SQL local sau pe un server MS SQL la distanță cu setări de copie de rezervă complet configurate. Unele dintre bazele de date nu au fost restaurate pentru că nu există un server MS SQL corespunzător înregistrat în Plesk. Au fost afectate următoarele domenii: {{objects}}. Contactați furnizorul de servicii de găzduire.',

    'bu_conflict_resolver_not_available_webmail' => 'Serviciul de e-mail prin web %1 nu este disponibil. Va fi înlocuit cu %2 pentru următoarele obiecte: {{objects}}',
    'bu_conflict_resolver_not_available_webmail_plan' => 'Serviciul de e-mail prin web %1 nu este disponibil. Va fi înlocuit cu %2 pentru următoarele planuri de servicii: {{objects}}',
    'bu_conflict_resolver_not_available_rename_db_user' => "Bazele de date de tipul „%1” nu acceptă numele de utilizatori care coincid cu numele bazei de date. Utilizatorul „%2” va fi redenumit în „%3” în baza de date „%4”.",

    'bu_conflict_resolver_wrong_hard_quota_value' => 'În configurația serverului destinație nu este setată limita de utilizare a spațiului pe disc. Valoarea acestei setări va fi schimbată în „Nelimitat”.',
    'bu_conflict_resolver_wrong_max_connections_value' => 'În configurația serverului destinație nu este setat numărul limită de conexiuni. Valoarea acestei setări va fi schimbată în „Nelimitat”.',
    'bu_conflict_resolver_wrong_traffic_bandwidth_value' => 'În configurația serverului destinație nu este setată limita de utilizare traficului. Valoarea acestei setări va fi schimbată în „Nelimitat”.',
    'cu__pleskrestore_backup_file_extracted' => 'Fișierul copie de rezervă a fost dezarhivat în „%1”.',
    '__mod_bw_not_supported' => 'Modulul mod_bw al serverului web Apache nu este acceptat din cauza configurației sistemului de fișiere. Limitele de utilizare a traficului și numărul maxim de conexiuni nu vor funcționa.',
    'bu_conflict_resolver_pop3_only_relay_auth_not_supported' => 'Autorizația POP3 pentru transmiterea de e-mailuri nu este acceptată, se va folosi autorizația POP3 înainte de SMTP. ({{objects}})',
    'bu_conflict_resolver_service_plan_name' => 'Plan de servicii „%1”',
    'bu_conflict_resolver_replaced_in_plans' => 'Funcția %1 nu este acceptată. Va fi înlocuită cu %2 pentru următoarele planuri de servicii: {{objects}}',
    'bu_conflict_resolver_replaced_in_sites' => 'Funcția %1 nu este acceptată. Va fi înlocuită cu %2 pentru următoarele site-uri web: {{objects}}',
    'bu_conflict_resolver_absent_objects_in_dump' => 'Următoarele obiecte nu au fost găsite în fișierul copie de rezervă: %1',
    'bu_conflict_resolver_absent_domains' => 'Unele obiecte nu se pot restaura pentru că aparțin următoarelor domenii care nu se regăsesc în Plesk: %1',
    'bu_conflict_resolver_absent_parent_domains' => "Unele site-uri web nu se pot restaura pentru că aparțin următoarelor domenii părinte care nu se regăsesc în Plesk: %1",
    'bu_conflict_resolver_dns_not_supported' => 'Imposibil de restaurat zonele DNS: Serviciul DNS este dezactivat în configurația de server.',
    'bu_conflict_resolver_mail_not_supported' => 'Imposibil de restaurat căsuțele poștale: Serviciul de e-mail este dezactivat în configurația de server.',
    'bu_conflict_resolver__idle_timeout_action_not_supported' => 'Serverul web IIS nu acceptă perioada de inactivitate specificată. Valoarea va fi resetată la %1.',
    'bu_conflict_resolver__cpu_limit_action_not_supported' => 'Serverul web IIS nu acceptă acțiunea specificată în caz de atingere a unei limite de ocupare a procesorului. Valoarea va fi resetată la %1.',
    'bu_conflict_detector_server_ssl_cert_name' => 'certificatul SSL/TLS de server %1',
    'bu_conflict_detector_domain_ssl_cert_name' => 'Certificatul SSL/TLS %2 al domeniului %1',
    'bu_conflict_detector_ssl_cert_name' => 'Certificatul SSL/TLS %1',
    'bu_conflict_resolver_absent_objects' => 'Conținutul următoarelor obiecte nu se poate restaura pentru că obiectele nu se regăsesc în Plesk: %1',
    'bu_conflict_resolver_absent_objects_mailuser' => 'Conținutul următoarelor căsuțe poștale nu se poate restaura deoarece căsuțele nu se regăsesc în Plesk: %1',
    'bu_conflict_resolver_absent_objects_maillist' => 'Conținutul următoarelor liste de e-mail nu se poate restaura pentru că listele nu se regăsesc în Plesk: %1',
    'bu_conflict_resolver_absent_objects_database' => 'Conținutul următoarelor baze de date nu se poate restaura pentru că bazele de date nu se regăsesc în Plesk: %1',
    'bu_conflict_resolver__remove_conflicted_aps_app' => 'Restaurarea aplicației „%1” pe „%2” nu a reușit: în „%3” este instalată deja o altă aplicație. Puteți să ștergeți aplicația instalată și să încercați din nou.',
    'bu_conflict_resolver_not_available_mail_autoresponders' => 'Funcția de răspuns automat la e-mail nu este acceptată.',
    'bu_conflict_resolver_not_available_mail_content' => 'Funcția de restaurare a conținutului de e-mail nu este acceptată.',
    'bu_conflict_resolver_invalid_mail_name' => 'Următoarele căsuțe poștale nu au fost restaurate pentru că este activat lucrul cu subadrese de e-mail și unele adrese conțin semnul „%1”: %2',
    'bu_conflict_resolver_invalid_user_name' => 'Următorii utilizatori nu au fost restaurați pentru că este activat lucrul cu subadrese de e-mail și unele adrese conțin semnul „%1”: %2',
    'bu_conflict_resolver_licenses_expired' => 'Următoarele licențe au expirat și nu vor fi restaurate: {{objects}}',
    'bu_conflict_resolver_licenses_invalid' => 'Următoarele licențe nu sunt valabile sau au expirat și nu vor fi restaurate: {{objects}}',
    'expiration_unsupported' => "Limita „expiration” nu este acceptată.",

    'component_name__dbconnector' => "Conector de bază de date",
    'component_name__mysqlserver' => 'MySQL Server',
    'component_name__troubleshooting' => 'Depanare',

    '__subscription_has_no_license_key' => 'Resursele corespunzătoare abonamentului sunt asigurate de nodul de serviciu nr. %1, care nu are nicio cheie de licență asociată.',
    '__subscription_has_expired_license_key' => 'Resursele corespunzătoare abonamentului sunt asigurate de nodul de serviciu nr. %1, a cărui cheie de licență %2 a expirat.',

    '__cfgmonConfigurationFileSaveErrorSubject' => '<%%host%%> Imposibil de salvat fișiere de configurare',
    '__cfgmonConfigurationFileSaveErrorBody' => "Imposibil de salvat unele fișiere de configurare pe gazda <%%host%%>: Au apărut următoarele erori: %%errors%%",

    'mail__enable_email_subaddressing_cli_desc' => 'Această opțiune activează posibilitatea de a configura adrese de e-mail VERP pentru listele de e-mail',
    'mail__enter_right_ip_mask' => "Introduceți masca IP, între 1 și 32",
    'mail__enter_right_ip_mask_24' => "Introduceți masca IP, între 24 și 32",
    'mail__invalid_dom_name' => "Numele de domeniu %1 este incorect.",
    'mail__invalid_pop_lock_time' => "Timpul de blocare POP3 este incorect.",
    'mail__invalid_rbl_server' => "Numele zonei DNS este incorect.",
    'mail__total_files_size' => "Dimensiunea totală a depozitului: %1",
    'mail__filename_already_in_repository' => "În depozit există deja un fișier cu același nume",
    'mail__no_white_list_mask_feature_24' => "Utilizați o valoare a măștii de cel puțin 24. Serverul de e-mail nu acceptă setarea măștilor. Putem emula setări de mască numai pentru valori care nu sunt mai mici decât 24.",
    'mail__unable_add_new_mail_name' => "Imposibil de adăugat contul de e-mail: %1",
    'mail_server_is_not_installed' => 'Serverul de e-mail (Postfix sau Qmail) nu este instalat. Instalați-l pentru a putea continua.',
    'mail_server_not_available' => 'Pe nodul de servicii nu există niciun server de e-mail acceptat.',
    '__not_installed' => '(neinstalat)',
    'mail__service_node_outgoing_messages_is_disabled' => 'Filtrarea antispam a mesajelor de e-mail trimise este dezactivată.',
    'mail__service_node_does_not_support_outgoing_messages_domain_limit' => 'Pentru domeniul %1 nodul de servicii nu acceptă limitarea numărului de mesaje de e-mail trimise dintr-un domeniu.',
    'mail__service_node_does_not_support_outgoing_messages_mbox_limit' => 'Pentru domeniul %1 nodul de servicii nu acceptă limitarea numărului de mesaje de e-mail trimise dintr-o căsuță poștală.',

    'mail__outgoing_email_mode_explicit_ip_unspecified' => 'Specificați o adresă pentru cel puțin un tip (IPv4 sau IPv6).',

    'mail__outgoing_email_mode_invalid' => 'S-a specificat un mod de trimitere a e-mailurilor incorect.',
    'mail__outgoing_email_mode_explicit_ip_v4_invalid' => 'S-a specificat o adresă IPv4 incorectă.',
    'mail__outgoing_email_mode_explicit_ip_v6_invalid' => 'S-a specificat o adresă IPv6 incorectă.',
    'mail__outgoing_email_mode_unavailable' => 'Nu se acceptă modificarea modului de trimitere a e-mailurilor, probabil din cauză că serverul de e-mail Postfix nu este instalat pe acest server.',

    'mail__autoresponder_attachment_not_supported' => 'Serverul de e-mail utilizat nu acceptă administrarea atașărilor de răspunsuri automate.',

    'mail__smtp_white_list_not_supported' => 'Serverul de e-mail în uz nu acceptă crearea de liste de adrese IP permise.',
    'mail__smtp_whitelist_cidr_not_supported' => 'Măștile CIDR nu sunt acceptate de serverul de e-mail selectat în acest moment. Specificați adresa IP în formatul „192.*.0.*”.',
    'mail__smtp_whitelist_mask_not_supported' => 'Modelele de IP cu caractere generice nu sunt acceptate de serverul de e-mail selectat în acest moment. Specificați adresa IP în formatul „192.0.0.0/8”.',

    'sfdk_server_wide_verify_failed' => 'Imposibil de modificat setările serviciului de verificare DKIM',

    'sfdk_domain__serverwide_disabled' => 'Dezactivat conform politicii de server',
    'feature__domainkeys__serverwide_disabled' => 'Protecție antispam DKIM la nivel de server este dezactivată',

    'defaultcomponents__error_set_default' => 'Imposibil de setat %1 ca setare implicită pentru %2: %3',
    'defaultcomponents__error_set_default_none' => 'Imposibil de setat lipsa de componentă implicită pentru %1: %2',
    'defaultcomponents__required_package_not_default' => 'Componenta %1, necesară pentru funcționare, nu este instalată.',

    '__percentage' => '%',
    '__seconds' => 'Secunde',
    '__resource_remain' => 'Rămas',

    '__not_registered' => '(neînregistrat)',
    '__php_handler_id' => 'Versiune PHP',
    '__php_handler_id_string' => 'PHP %1 (%2)',
    '__php_handler_not_registered' => 'Handlerul PHP „%1” nu este înregistrat. Probabil că a fost șters de pe server. Înregistrați un handler cu aceleași proprietăți, apoi încercați din nou.',
    '__php_handler_not_registered_on_domain' => 'Domeniul „%1”: handlerul PHP „%2” nu este înregistrat. Probabil că a fost șters de pe server. Înregistrați un handler cu aceleași proprietăți, apoi încercați din nou.',
    '__php_fpm_handler' => 'Aplicație FPM',
    '__php_fpm-dedicated_handler' => 'Aplicație dedicată FPM',

    'mailname_create_assigned_user_dublicate_error' => 'Imposibil de creat utilizatorul de căsuță poștală. Utilizatorul cu numele %1 există deja și are o altă căsuță poștală.',
    'mailname_create_assigned_user_role_absent_error' => 'Imposibil de creat utilizatorul de căsuță poștală. Nu există rolul implicit %1 al utilizatorului.',

    'gphd__mime_types' => 'Tipuri MIME',
    'gphd__handlers' => 'Handlere Apache',
    'gphd__ip_restrictions_allow' => 'Se permite accesarea site-ului de pe gazdele și din rețelele specificate (exclusiv cele refuzate)',
    'gphd__ip_restrictions_deny' => 'Se refuză accesul la site de pe gazdele și din rețelele specificate',
    'gphd__directory_index' => 'Fișiere index',
    'gphd__nginx_transparent_mode' => 'Modul în care Apache gestionează atât conținutul static, cât și cel dinamic, în timp ce nginx doar transmite solicitările și răspunsurile HTTP, fără a le modifica.',
    'gphd__nginx_serve_static' => 'Fișierele statice se deservesc direct din nginx',
    'gphd__nginx_static_extensions' => 'Extensiile de fișiere statice trebuie să fie gestionate de nginx',
    'gphd__nginx_serve_php' => 'Fișierele PHP vor fi procesate de nginx',
    'gphd__www_root' => 'Directorul rădăcină WWW',

    'eol__none' => 'nu se modifică',
    'eol__lf' => 'conversie în stil Unix',
    'eol__cr' => 'conversie în stil MacOS',
    'eol__crlf' => 'conversie în stil Windows',

    'ui__dns_bad_zone' => 'Zonă cu inconsecvență „%1”:',
    'ui__dns_ns_has_no_address_records' => 'Înregistrarea NS „%1” nu are înregistrări de adresă (A sau AAAA).',
    '__dns_bad_zone' => 'Zonă cu inconsecvență „%1”:',
    '__dns_ns_has_no_address_records' => 'Înregistrarea NS „%1” nu are înregistrări de adresă (A sau AAAA).',
    '__dns_ptr_is_wildcard' => 'Înregistrarea PRT „%1” este incorectă: Înregistrarea trimite la un domeniu generic.',

    'firewall_database_user_remote_access_rule_name' => '[%1][%2] Se permite accesul la distanță pentru utilizatorul de baze de date „%3” al clientului „%4”',
    'firewall_database_user_remote_access_rule_name_removed' => '[%1][%2] %3',
    'firewall_database_user_remote_access_mssql_server_port_undefined' => 'Imposibil de permis conexiunile la distanță pentru utilizatorul de bază de date „%1”: Imposibil de determinat numărul de port TCP utilizat de Microsoft SQL Server „%2”. Motivele posibile sunt următoarele: protocolul TCP/IP nu este activat în configurația de rețea a serverului sau serverul este configurat să utilizeze porturi TCP dinamice. Configurați serverul astfel încât să aștepte conexiuni la un anumit port TCP fix și încercați din nou să permiteți conexiunile la distanță.',

    'command__convertResellerHasCustomer' => 'Contul de reseller „%1” are unul sau mai multe conturi client. Pentru a transforma acest cont de reseller în cont de client, transferați conturile client respective la un proprietar nou sau transformați-le în conturi de reseller.',
    'command__convertResellerNotReseller' => 'Doar conturile de reseller se pot transforma în conturi client. „%1” nu este un reseller.',
    'command__convertResellerToCustomerSubscriptionNotSynchronized' => 'Imposibil de sincronizat abonamentul cu planul de servicii. Următoarele setări ale abonamentului intră în conflict cu planul de servicii: %%problems%%.',

    'moveCustomer__wrong_customer_type' => 'Contul „%1” este un cont de reseller. Conturile de reseller nu pot fi mutate la proprietari noi, pentru că acestea sunt proprietatea administratorului de server.',
    'moveCustomer__wrong_owner_type' => "Contul de client „%1” poate fi mutat numai la un reseller sau la un administrator, nu la un alt client.",
    'moveCustomer__customer_already_belongs_to_owner' => 'Contul de client „%1” aparține deja proprietarului selectat.',
    'upgradeClient__user_is_admin' => 'Contul „%1” nu poate fi transformat în cont de reseller pentru că este cont de administrator.',

    'mail__error_setting_max_connections_courier' => 'Imposibil de setat numărul maxim de conexiuni (IMAP, POP3, IMAP prin SSL/TLS sau POP3 prin SSL/TLS): %1',
    'mail__error_setting_max_connections_dovecot' => 'Imposibil de setat numărul maxim de conexiuni (IMAP, POP3, IMAP prin SSL/TLS sau POP3 prin SSL/TLS): %1',
    'mail__error_setting_max_connections_per_ip_courier' => 'Imposibil de setat numărul maxim de conexiuni (IMAP, POP3, IMAP prin SSL/TLS sau POP3 prin SSL/TLS) per adresă IP: %1',
    'mail__error_setting_max_connections_per_ip_dovecot' => 'Imposibil de setat numărul maxim de conexiuni (IMAP, POP3, IMAP prin SSL/TLS sau POP3 prin SSL/TLS) per adresă IP pentru un anumit utilizator de e-mail: %1',
    'outgoing_messages_limit_value_invalid' => 'Valoarea trebuie să fie cuprinsă în intervalul %%MIN%% - %%MAX%%. Doar administratorul Plesk poate modifica această setare.',
    'outgoing_messages_server_settings_catch_address_are_not_local' => "Următoarele domenii utilizează adrese de e-mail externe pentru redirecționarea mesajelor trimise la adrese inexistente. Mesajele trimise la aceste adrese nu vor fi numărate în Controlul mesajelor de e-mail trimise: %1",
    'outgoing_messages_white_list_not_empty' => 'Este posibil ca limitele de trimitere a mesajelor de e-mail să nu funcționeze în cazul programelor de trimitere ale căror adrese apar în lista albă a serverului de e-mail. De exemplu, dacă gazda localhost (127.0.0.0 / 8, ::1 / 128) se află în lista albă, toate e-mailurile de le serverul local vor fi trimise cu succes, indiferent de limitări. Programele de trimitere pot folosi adrese IP locale (site-uri web sau scripturi găzduite pe serverul local) sau externe (clienții care trimit mesaje din programe client de e-mail instalate pe propriile computere sau dispozitive mobile). Pentru a putea impune limitele tuturor programelor de trimitere (locale și externe), eliminați din lista albă toate adresele IP și rețelele. Rețineți: eliminarea gazdei localhost (127.0.0.0 / 8, ::1 / 128) din lista albă poate împiedica funcționarea site-urilor web și a scripturilor care trimit e-mailuri de pe acest server. Pentru detalii despre limitele impuse trimiterilor de e-mail, consultați Ghidul Administratorului, Protecție împotriva trimiterilor de spam.',
    'outgoing_messages_relay_open' => 'Funcția de transmitere a mesajelor de e-mail este deschisă? Limitele de trimitere a mesajelor de e-mail nu vor funcționa.',

    'notification_aps_app_updates_available' => 'Sunt disponibile actualizări pentru următoarele aplicații:',
    'notification_aps_app_updates_installed' => 'Actualizările pentru următoarele aplicații au fost instalate automat:',
    'notification_aps_app_updates_requirements' => 'Sunt disponibile actualizări pentru următoarele aplicații, dar nu pot fi instalate pentru că setările de găzduire ale site-urilor web corespunzătoare nu respectă cerințele de instalare:',
    'notification_admin_aps_app_updates_available_item' => '%%name%% (%%url%%). Versiune instalată: %%from%%. Versiune disponibilă: %%to%%.',
    'notification_admin_aps_app_updates_available_plugin_item' => 'Pluginul „%%name%%” din %%parentName%% (%%url%%). Versiune instalată: %%from%%. Versiune disponibilă: %%to%%.',
    'notification_admin_aps_app_updates_available_theme_item' => 'Tema %%name%%” din %%parentName%% (%%url%%). Versiune instalată: %%from%%. Versiune disponibilă: %%to%%.',
    'notification_reseller_aps_app_updates_available_item' => '%%name%% (%%url%%). Versiune instalată: %%from%%. Versiune disponibilă: %%to%%.',
    'notification_reseller_aps_app_updates_available_plugin_item' => 'Pluginul „%%name%%” din %%parentName%% (%%url%%). Versiune instalată: %%from%%. Versiune disponibilă: %%to%%.',
    'notification_reseller_aps_app_updates_available_theme_item' => 'Tema %%name%%” din %%parentName%% (%%url%%). Versiune instalată: %%from%%. Versiune disponibilă: %%to%%.',
    'notification_client_aps_app_updates_available_item' => '%%name%% (%%url%%). Versiunea dvs.: %%from%%. Versiune disponibilă: %%to%%.',
    'notification_client_aps_app_updates_available_plugin_item' => 'Pluginul „%%name%%” din %%parentName%% (%%url%%). Versiunea dvs.: %%from%%. Versiune disponibilă: %%to%%.',
    'notification_client_aps_app_updates_available_theme_item' => 'Tema %%name%%” din %%parentName%% (%%url%%). Versiunea dvs.: %%from%%. Versiune disponibilă: %%to%%.',
    'notification_admin_aps_app_updates_installed_item' => '%%name%% (%%url%%). Versiune nouă: %%to%%. Versiune anterioară: %%from%%.',
    'notification_reseller_aps_app_updates_installed_item' => '%%name%% (%%url%%). Versiune nouă: %%to%%. Versiune anterioară: %%from%%.',
    'notification_client_aps_app_updates_installed_item' => '%%name%% (%%url%%). Versiune nouă: %%to%%. Versiune anterioară: %%from%%.',
    'notification_admin_aps_app_updates_requirements_item' => '%%name%% (%%url%%). Versiune instalată: %%from%%. Versiune disponibilă: %%to%%.',
    'notification_reseller_aps_app_updates_requirements_item' => '%%name%% (%%url%%). Versiune instalată: %%from%%. Versiune disponibilă: %%to%%.',
    'notification_client_aps_app_updates_requirements_item' => '%%name%% (%%url%%). Versiunea dvs.: %%from%%. Versiune disponibilă: %%to%%.',
    'notification_aps_app_updates_no_installation_url' => 'aplicație externă',

    'notification_outgoing_mail_exceeded_limits_domains' => 'Domenii',
    'notification_outgoing_mail_exceeded_limits_mails' => 'Adrese de e-mail',
    'notification_outgoing_mail_exceeded_limits_subscriptions' => 'Abonamente',
    'notification_outgoing_mail_exceeded_limits_limit_value' => 'Mesaje pe oră: %1',
    'notification_outgoing_mail_exceeded_limits_limit_value_unlimited' => 'Nelimitat',
    'notification_outgoing_mail_exceeded_limits_object' => '%1, limita este %2',
    'notification_outgoing_mail_exceeded_limits_attempt' => '%1 încercări de a depăși limitele de %2 până %3',
    'notification_outgoing_mail_exceeded_limits_attempt_still_exceeding' => '%1 încercări de a depăși limitele de %2 până acum',

    'restart__docker' => "Docker",
    'restart__fail2ban' => "Interzicere de adrese IP (Fail2Ban)",

    'backup__restore__capability_fail2ban_not_installed_text' => 'Componenta Fail2Ban nu este instalată pe serverul destinație.',
    'backup__restore__capability_fail2ban_not_installed_resolution' => 'Instalați Fail2Ban. Atenție: operația poate dura câteva minute.',

    'plesk_key__no_reseller_support' => 'Nu puteți administra resellerii din cauza restricțiilor impuse de licență.',
    'plesk_key__no_customers_support' => 'Nu puteți administra clienții din cauza restricțiilor impuse de licență.',
    'panel_interface_uimodes__service_provider_view_not_allowed' => 'Restricțiile de licență nu permit trecerea la vizualizarea Furnizor de servicii.',
    'plesk_key__no_security_core_support' => 'Funcțiile esențiale de securitate (ModSecurity și Fail2Ban) nu sunt disponibile din cauza restricțiilor impuse de licență.',
    'plesk_key__outgoing-antispam' => 'Controlul mesajelor de e-mail trimise',
    'plesk_key__security-core' => 'Funcții esențiale de securitate (ModSecurity și Fail2Ban)',
    'plesk_key__can-manage-accounts' => 'Administrarea conturilor',
    'plesk_key__can-manage-subscriptions' => 'Administrarea abonamentelor',
    'plesk_key__can-manage-customers' => 'Administrarea clienților',
    'plesk_key__can-manage-resellers' => 'Administrarea resellerilor',
    'plesk_key__can-manage-custom-view' => 'Disponibilitatea modului restricționat',
    'plesk_key__limits_exceeded_no_subscriptions_management' => 'Administrarea abonamentelor este dezactivată, dar aveți mai multe abonamente (%1).',
    'plesk_key__limits_exceeded_no_resellers_management' => 'Administrarea resellerilor este dezactivată, dar aveți mai mulți reselleri (%1).',
    'plesk_key__limits_exceeded_no_customers_management' => 'Administrarea clienților este dezactivată, dar aveți mai multe clienți (%1).',
    'plesk_key__no_subscriptions_support' => 'Nu puteți administra abonamentele din cauza restricțiilor impuse de licență.',
    'plesk_key__no_custom_view_support' => 'Nu puteți utiliza modul restricționat din cauza restricțiilor impuse de licență.',
    'plesk_key__trial_forbidden_region' => 'Ne pare rău, în prezent Plesk nu este disponibil în regiunea dvs.',
    'additional_key__main_key' => 'Cheia este una principală: Nu puteți încărca o cheie principală drept cheie suplimentară.',

    'gch__hosting_waf_rule_engine' => 'Mod firewall de aplicații web',

    'backup__fieldset__restoration_options' => 'Opțiuni de restaurare',
    'backup__restore_options__restore' => 'Restaurare',
    'backup__restore_options__domain__domain_configuration' => 'Configurările domeniului',
    'backup__restore_options__domain__virtual_host_content' => 'Conținutul gazdei virtuală',
    'backup__restore_options__domain__mail' => 'E-mail',
    'backup__restore_options__domain__databases' => 'Baze de date',
    'backup__restore_options__client__client_configuration' => 'Configurarea contului de client',
    'backup__restore_options__client__domains' => "Domeniile clientului",
    'backup__restore_options__reseller__reseller_configuration' => 'Configurările contului de reseller',
    'backup__restore_options__reseller__personal_domains' => "Domeniile resellerului",
    'backup__restore_options__reseller__clients' => "Clienții resellerului",
    'backup__restore_options__admin__server_configuration' => 'Setări de server',
    'backup__restore_options__admin__administrator_configuration' => 'Configurare cont de administrator',
    'backup__restore_options__admin__personal_domains' => "Domeniile administratorului",
    'backup__restore_options__admin__personal_clients' => "Clienții administratorului",
    'backup__restore_options__admin__resellers' => 'Reselleri',

    'badge_new' => 'Nou',
    'upgrade_php_on_subscription' => 'Faceți upgrade la sistemul PHP din abonament la versiunea 5.3.0 sau una ulterioară.',

    'pkey_notify__body_expiration_notification' => 'Cheia de licență a expirat. Este posibil ca unele funcții să nu fie disponibile. Contactați furnizorul de servicii de găzduire.',

    'crontab__crontab_entry_exists' => "Sarcina programată există deja.",
    'crontab__crontab_entry_not_exists' => "Sarcina programată nu există.",
    'crontab__invalid_values_found' => "Valori de parametri incorecte.",
    'crontab__cmd_max_len' => "Comanda nu poate depăși lungimea de %1 caractere.",

    'domain__domain_exists' => "Există un domeniu cu prefixul „www” și cu același nume: %1.%2.",
    'domain__subdomain_exists' => "Există un subdomeniu cu prefixul „www” și cu același nume: %1.%2.",
    'domain__dalias_exists' => "Există un alias de domeniu cu prefixul „www” și cu același nume: %1.%2.",
    'domain__record_exists' => "Exista deja o înregistrare DNS care indică gazda %1.%2.",

    'ip_addr__cannot_assign_certificate' => "Certificatul „%1” nu poate fi setat drept implicit: lipsește cheia privată.",
    'ip_addr__update_dns_error' => 'Au apărut probleme la actualizarea adresei IP în zonele DNS. %1',
    'ip_addr__cannot_add_dhcp_enabled' => 'Nu se poate adăuga adresa IP. Această interfață de rețea obține automat adresele IP.',
    'ip_addr__cannot_remove_dhcp_enabled' => 'Adresa IP %1 nu se poate elimina. Această interfață de rețea obține automat adresele IP.',
    'ip_addr__cannot_repair_dhcp_enabled' => 'Adresa IP %1 nu se poate repara. Această interfață de rețea obține automat adresele IP.',
    'ip_addr__cannot_change_interface_dhcp_enabled' => 'Imposibil de modificat interfața adresei IP %1 pentru că interfața de rețea %2 obține automat adresele IP.',

    'shm_lmsg__limit_for_resource_exceeded' => 'Numărul limită din abonament pentru %%type%% este depășit. Limita este %%limit%%, în prezent se utilizează %%usage%%.',
    'shm_lmsg__resource_is_forbidden_for_creation' => 'Pentru acest abonament nu se permite crearea de %%type%%.',
    'shm_lmsg__resource_title__db-mysql' => 'Baze de date MySQL',
    'shm_lmsg__resource_title__db-mssql' => 'Baze de date MS SQL',
    'shm_lmsg__resource_title__db-postgresql' => 'baze de date PostgreSQL',
    'shm_lmsg__resource_title__db-user' => 'utilizatori de baze de date',
    'shm_lmsg__resource_title__iis-application-pool' => 'Liste de aplicații IIS',
    'shm_lmsg__resource_title__additional-ftp-account' => 'conturi FTP suplimentare',

    'db_user_unable_remove_mysql_global_privileges' => 'Imposibil de retras privilegiile globale MySQL ale utilizatorului de bază de date %1. Motiv: %2',
    'report__client_description' => 'Descriere',

    'db__user_role_error' => 'S-a specificat un rol de utilizator de baze de date incorect: %1. Alegeți unul dintre următoarele roluri: %2.',

    'subscription_unable_to_set_max_filesize_warning' => 'Imposibil de setat limita de dimensiune pentru fișierele următoarelor baze de date Microsoft SQL Server, pentru că au dimensiuni de fișier mai mari: %1.',
    'subscription_unable_to_set_max_log_filesize_warning' => 'Imposibil de setat limita de dimensiune pentru fișierele jurnal ale următoarelor baze de date Microsoft SQL Server, pentru că au dimensiuni de fișier jurnal mai mari: %1.',
    'ipaddress__cannot_set_up_public_ip_need_ipaddress' => 'Imposibil de configurat o adresă IP publică: trebuie să existe o adresă IP privată.',
    'ipaddress__cannot_set_up_public_ip_need_ipv6' => 'Imposibil de configurat o adresă IPv4 publică pentru adresa IPv6.',
    'ipaddress__cannot_set_up_public_ip_need_ipv4' => 'Imposibil de configurat o adresă IPv6 publică pentru adresa IPv4.',
    'ipaddress__cannot_set_up_public_ip_invalid' => 'Imposibil de configurat o adresă IP publică: adresă IP incorectă.',

    '__user_already_exists' => "Utilizatorul %1 există deja.",
    '__user_name_is_empty' => "Specificați un nume de utilizator corect.",

    'upgrade_php_on_domain' => 'În niciuna dintre domeniile dvs. WordPress nu s-a găsit versiunea PHP 5.3.0 sau una mai recentă. Încercați să faceți upgrade la PHP.',

    'component_name__waf' => 'Firewall de aplicații web',
    'component_name__vcs' => 'Sistem de control al versiunilor',

    'virtualization_lxc' => 'LXC',
    'virtualization_docker' => 'Docker',
    'possibleSpoofingDetected' => 'S-a detectat un posibil atac prin uzurparea identității: Linkul a încercat să afișeze conținut nerelevant.',
    'forceResetPasswordUpdated' => 'Parola a fost schimbată. Conectați-vă la Plesk cu noua parolă.',

    'php_handlers_error_no_available_instance' => 'Imposibil de creat un domeniu: nu este disponibil niciun handler PHP.',
    'domain_error_unable_to_apply_hosting_settings' => 'Imposibil de aplicat setările de găzduire: %1',

    'plesk_not_configured' => 'Plesk nu este configurat. Accesați panoul de control pentru a face configurările post-instalare.',
    'cmd_mail__mail_password_duplicated' => 'Perechea de adresă de e-mail și parolă pe care ați specificat-o există deja pe serverul de e-mail. Specificați o altă adresă de e-mail sau o altă parolă.',

    'extensionRequirementOs' => 'Pachetul nu acceptă sistemul de operare (%1).',
    'extensionRequirementPleskMinVersion' => 'Plesk %1 este cea mai veche versiune acceptată de pachet.',
    'extensionRequirementPleskMaxVersion' => 'Pachetul nu acceptă versiunile de Plesk începând de la %1.',
    'extensionBlacklisted' => 'Instalarea extensiei %1 nu este permisă.',
    'extensionDisabled' => 'Extensia este dezactivată.',


    'optimization_settings__unable_set_mpm_event' => 'Imposibil de setat modul mpm_event: acest lucru necesită dezactivarea modulului Apache PHP5, dar acesta este utilizat de domenii.',
    'optimization_settings__unable_turn_off_php' => 'Imposibil de dezactivat modulul Apache PHP5: acesta este utilizat de domenii.',

    'hst_def__fp_admin_login' =>  'Nume utilizator FTP',
    'hst_def__fp_admin_passwd' =>  'Parolă FTP',

    'database_user_orphaned_old_password_wrong' => "Imposibil de reparat utilizatorul trecut în stare de orfan „%1”: parola este incorectă.",
    'cannot_load_partner_central_property_key_no_exist' => "Imposibil de obținut proprietățile personalizate: cheia de licență nu există.",
    'extensionScriptFailure' => "Executarea %1 nu a reușit. Mesaj: %3",
    '__ssl_redirect' => "Redirecționare 301 permanentă, sigură pentru SEO, de la HTTP la HTTPS",
    'component_name__dotnetcore' => 'Nucleu .NET',
    'mail__dkim_not_supported' => 'Gestionarea DKIM nu este acceptată.',
    'mail__dmarc_not_supported' => 'Gestionarea DMARC nu este acceptată.',
    'mail__relay_white_list_not_supported' => 'Gestionarea listelor albe de transmitere nu este acceptată.',
    'mail__black_list_not_supported' => 'Gestionarea listelor negre nu este acceptată.',
    'mail__autoresponder_not_supported' => 'Gestionarea utilitarului de răspunsuri automate nu este acceptată.',
    'defaultcomponents__not_supported_version' => '(versiune neacceptată)',
    'component_name__nodejs' => 'Node.js',

    'certificate__not_found' => 'Certificatul „%1” nu a fost găsit.',
    'certificate__unable_setup_certificate' => 'Imposibil de instalat certificatul: Lipsesc cheia privată și conținutul de certificat.',
    'certificate__used_by_panel' => 'Unul dintre certificatele pe care doriți să le ștergeți este utilizat pentru securizarea sistemului Plesk.',
    'certificate__used_by_mail_server' => 'Unul dintre certificatele pe care doriți să le ștergeți este utilizat pentru securizarea serverului de e-mail.',
    'certificate__used_by_domain_service' => 'Unul dintre certificatele pe care doriți să le ștergeți este utilizat de serviciul de domenii.',
    'mail_server__not_installed' => 'Imposibil de instalat certificatul pentru serverul de e-mail, deoarece serverul de e-mail nu este instalat.',

    'email_activation_mail_subject' => 'Activați-vă contul în Plesk',
    'email_activation_mail_body' => "Pe serverul Plesk %1 a fost creat un cont. Detaliile contului: Nume: %2 Adresă de e-mail: %3 Dacă aceste informații sunt corecte și contul a fost creat pentru dvs., activați-l prin intermediul următorului link: %4 Prin activarea contului autorizați deținătorul serverului să colecteze, să stocheze, să proceseze și să utilizeze datele dvs. personale (nume și adresă de e-mail) în vederea creării și ținerii în funcțiune a contului, conform legislației în vigoare privind protecția datelor, în cadrul contractului.",

    'backup_transport_permission_name' => 'Administrare %1',
    'backup_transport_permission_description' => 'Permite utilizarea a %1 pentru stocarea fișierelor copie de rezervă.',

    'domain_move_err_target_no_hosting' => 'Imposibil de mutat domeniul într-un abonament fără găzduire.',
    'domain_move_err_already_in_target' => 'Domeniul aparține deja abonamentului destinație.',
    'domain_move_err_main_domain' => 'Domeniul principal nu poate fi mutat.',
    'domain_move_err_subdomain_without_parent' => 'Imposibil de mutat subdomeniul %1 fără domeniul părinte %2.',
    'domain_move_err_root_exists' => 'Calea destinație pentru www_root %1 există deja.',
    'domain_move_err_nested_roots' => 'Domeniul nu poate fi mutat pentru că folosește directorul rădăcină de documente în comun cu un alt domeniu: %1.',
    'domain_move_err_no_mail_service' => 'Domeniul nu poate fi mutat pentru că serviciul de e-mail nu este activ în abonamentul destinație.',
    'domain_move_err_app' => "Aplicația instalată în %1 nu a fost mutată în abonamentul „%2”: %3",
    'domain_move_database_used_by_app' => "Baza de date „%1” de pe %2 este utilizată de aplicația mutată. Pentru a reatribui baza de date la „%3”, executați „plesk bin database --assign-to-subscription”",
    'domain_move_target_locked' => "Abonamentul destinație „%1” a fost blocat pentru sincronizare.",
    'domain_move_filesharing_disabled' => 'Partajarea de fișiere a fost dezactivată.',
    'domain_move_website_preview_disabled' => 'Previzualizarea de site a fost dezactivată.',
    'domain_move_additional_webserver_settings' => "Verificați directivele de server web suplimentare ale domeniului pentru a evita o configurație defectă.",
    'domain_move_no_permission' => "Nu se permite %1 pentru abonamentul „%2”.",
    'domain_move_no_access' => "Abonamentul „%1” este inaccesibil.",
    'domain_split_no_create_permission' => "Crearea de domeniu nu este permisă.",
    'domain_split_empty_login' => 'Numele de conectare al utilizatorului de sistem este obligatoriu.',
    'domain_split_empty_password' => 'Parola utilizatorului de sistem este obligatorie.',
    'domain_split_err_home_exists' => 'Domeniul %1 nu poate fi mutat deoarece calea de pornire destinație există deja în %2. Redenumiți domeniul pentru a-l putea muta într-un alt abonament.',
    'domain_split_err_no_hosting_subdomains' => 'Domeniul nu poate fi mutat într-un abonament nou pentru că domeniul nu are găzduire, dar are subdomenii. Pentru a muta domeniul, modificați „Tip găzduire” în „Găzduire de site web” (în Setări de găzduire).',
    'domain_split_target_locked' => "Abonamentul destinație „%1” este blocat pentru sincronizare.",
    'domain_split_target_unsynced' => "Abonamentul destinație „%1” nu a fost sincronizat cu planul. Cauza: %2.",
    'domain_merge_scheduled_backup_deactivated' => "Crearea programată a copiilor de rezervă a fost dezactivată pe „%1”.",
    'domain_merge_database_error' => "Baza de date „%1” de pe %2 nu a fost mutată în abonamentul „%3”: %4",
    'domain_merge_anon_ftp_deactivated' => "FTP anonim pe „%1” a fost oprit.",
    'domain_merge_smb_user_access' => "Utilizatorul suplimentar „%1” a fost mutat în abonamentul „%2”, dar accesul utilizatorului la abonament a fost revocat.",
    'domain_merge_scheduled_tasks' => "Sarcinile programate au fost mutate în abonamentul destinație. Verificați configurația de sarcini.",
    'domain_merge_scheduled_tasks_deactivated' => "Sarcinile programate au fost mutate în abonamentul destinație și au fost dezactivate. Verificați configurația de sarcini.",
    'domain_merge_no_remove_permission' => "Eliminarea abonamentelor nu este permisă.",
    'domain_merge_err_has_addons' => 'Imposibil de mutat domeniul principal cu domenii suplimentare. Mutați întâi domeniul/domeniile %1.',
    'domain_merge_err_has_webusers' => 'Imposibil de mutat domeniul principal cu utilizatorii web.',
    'domain_merge_err_root_exists' => 'Calea destinație %1 există deja.',

    'database_server_edit_used_for_psa' => 'Nu este permisă actualizarea serverului de baze de date MySQL local.',
    'suggest_repair_main_suggestion_ui' => '<b>Eroare se poate corecta</b> cu utilitarul „plesk repair”.',
    'suggest_repair_main_suggestion_cli' =>  'Eroare se poate corecta cu utilitarul „plesk repair”.',
    'suggest_repair_repair_kit_link_title' => 'accesați Diagnosticare și reparare',
    'suggest_repair_using_cli_and_ui' => 'În acest scop, lansați comanda „plesk repair %1” din linia de comandă sau %2 și faceți clic pe Reparare la „Baza de date Plesk”',
    'suggest_repair_using_cli' => 'În acest scop, lansați comanda „plesk repair %1” din linia de comandă',

    'backup__restore__capability_duplicate_php_handler_resolution' => '',
    'bu_conflict_resolver_dns_not_available' => 'Serviciul DNS nu era disponibil în momentul creării copiei de rezervă. În copia de rezervă sunt zone DNS, acestea vor fi activate pentru următoarele obiecte: {{objects}}',
    'plesk_key__system-resources-limits-enabled' => 'Controler de resurse (Cgroups)',
    'plesk_key__remote-smartermail-enabled' => 'Compatibilitate SmarterMail la distanță',
    'plesk_key__complete-backup-solution' => 'Creare copie de rezervă în Cloud Pro',
    'defaultcomponents__no_license' => '(nu este permisă de cheia licență)',
    'plesk_key__validation_failed' => '%1 (Cod de eroare: %2)',
    'promo__button_details' => 'Detalii',
    'promo__extension_catalog_title' => 'Catalog de extensii',
    'promo__extension_catalog_description' => 'Consultați cel mai nou catalog de extensii și completați Plesk cu diferite extensii puternice!',
    'promo__button_open_catalog' => 'Deschiderea catalogului',

    'backup__repository_check_login' => "Imposibil de accesat spațiul de stocare: %1 Asigurați-vă că ați introdus corect acreditările de acces la spațiul de stocare.",
    'backup__repository_check_error_list' => "Imposibil de accesat spațiul de stocare: %1 Asigurați-vă că ați introdus setările de stocare corecte.",
    'backup__repository_check_error_mkdir' => "Imposibil de creat directorul: %1 Verificați dacă aveți permisiune de creare de foldere în spațiul de stocare.",
    'backup__repository_check_error_upload' => "Imposibil de încărcat fișierul în spațiul de stocare: %1 Verificați dacă aveți permisiunea de încărcare a fișierelor în spațiul de stocare.",
    'backup__repository_check_error_download' => "Imposibil de descărcat fișierul din spațiul de stocare: %1 Verificați dacă aveți permisiuni pentru încărcarea fișierelor în, respectiv descărcarea acestora din spațiul de stocare.",
    'backup__repository_check_error_resume-upload' => "Imposibil de reluat încărcarea fișierului în spațiul de stocare: %1 Verificați dacă aveți permisiunea de reluare a încărcării fișierelor în spațiul de stocare.",
    'backup__repository_check_error_resume-download' => "Imposibil de reluat descărcarea fișierului din spațiul de stocare: %1 Verificați dacă aveți permisiunea de reluare a descărcării fișierelor din spațiul de stocare.",
    'backup__repository_check_error_enable-utf8' => "Imposibil de utilizat spațiul de stocare: %1 Verificați dacă spațiul de stocare acceptă codificarea UTF8.",
    'backup__repository_check_error_rm' => "Imposibil de utilizat spațiul de stocare: %1 Verificați dacă aveți permisiunea de a șterge fișiere din spațiul de stocare.",
    'backup__repository_check_error_rmdir' => "Imposibil de utilizat spațiul de stocare: %1 Verificați dacă aveți permisiunea de a șterge foldere din spațiul de stocare.",

    'backup__ftp_repository_check_login' => "%1 Puteți verifica independent cu comanda: %2",
    'backup__ftp_repository_check_error_list' => "%1 Puteți verifica independent cu comanda: %2",
    'backup__ftp_repository_check_error_mkdir' => "%1 Puteți verifica independent cu comanda: %2",
    'backup__ftp_repository_check_error_upload' => "%1 Puteți verifica independent cu comenzile: %2 %3",
    'backup__ftp_repository_check_error_download' => "%1 Puteți verifica independent cu comenzile: %2 %3",
    'backup__ftp_repository_check_error_resume-upload' => "%1 Puteți verifica independent cu comenzile: %2 %3 %4",
    'backup__ftp_repository_check_error_resume-download' => "%1 Puteți verifica independent cu comenzile: %2 %3",
    'backup__ftp_repository_check_error_enable-utf8' => "%1 Puteți verifica independent cu comanda: %2",
    'backup__ftp_repository_check_error_rm' => "%1 Puteți verifica independent cu comenzile: %2 %3",
    'backup__ftp_repository_check_error_rmdir' => "%1 Puteți verifica independent cu comenzile: %2 %3",

    'sfdmarc_server_wide_enable_failed' => 'Imposibil de modificat setările DMARC. Pentru a activa această opțiune, activați protecția antispam DKIM și SPF.',
    'spf_server_wide_disable_failed' => 'Imposibil de modificat setările de protecție antispam SPF. Pentru a dezactiva SPF, dezactivați DMARC pentru e-mailurile primite.',
    'sfdk_server_wide_verify_disable_failed' => 'Imposibil de modificat setările de protecție antispam DKIM. Pentru a dezactiva DKIM, dezactivați DMARC pentru e-mailurile primite.',

    'ccs_not_supported' => 'IIS Central Certificate Store nu este configurat în Plesk.',
    'ccs_not_enabled' => 'Administrarea de IIS Central Certificate Store nu este activată în Plesk.',
    'ad_not_supported' => 'Serverul nu a fost introdus în domeniu.',

    'component_name__appinit' => "Inițializare aplicație",
    'component_name__httpcompression' => 'Compresie conținut HTTP',
    'common_feature_is_not_supported' => 'Această funcție nu mai este acceptată.',
    'common_feature_is_not_supported_in_proto' => 'Această funcție nu mai este acceptată pentru versiunea de protocol %1.',
    'autoinstaller__plesk_component' => 'Componentă Plesk',
    'plesk_key__key_expired' => 'Cheia de licență a expirat. Pentru a putea folosi Plesk în continuare, cumpărați o %1 comercială care nu expiră.',
    'plesk_key__key_purchase' => 'cheie de licență',

    'sa_action_move' => 'Mutarea mesajelor spam în folderul „E-mail nedorit”',

    'bu_conflict_resolver_tomcat_not_supported' => 'Aplicațiile Java nu mai sunt acceptate. Acestea vor înceta să fie disponibile pe următoarele site-uri: {{objects}}',
    'bu_conflict_resolver_unity_mobile_not_supported' => 'Versiunile pentru mobil ale site-urilor web găzduite de UNITY Mobile nu mai sunt acceptate. Acestea vor înceta să fie disponibile pe următoarele site-uri: {{objects}}',
    'bu_conflict_resolver_antivirus_personal_management_not_allowed' => 'Politica de utilizare la nivel de server nu permite utilizarea setărilor de antivirus personale. Restaurarea va fi incompletă pentru conturile de e-mail din următoarele domenii: {{objects}}',

    'module__not_installed' => "Extensia %1 nu este instalată",

    'mail__mail_autodiscovery_server_error' => 'Specificați un nume de domeniu personalizat pentru descoperirea automată de e-mail',
    'mail__error_mail_autodiscovery_enable' => 'Imposibil de setat descoperirea automată de e-mail: %1',
    'mail__error_mail_autodiscovery_server' => 'Imposibil de setat numele personalizat de domeniu pentru descoperirea automată de e-mail: %1',
    'mail__error_mail_autodiscovery_reconfigure_dns' => 'Imposibil de reconfigurat înregistrările DNS de descoperire automată în domeniu: %1.',

    '__invalid_url' => 'URL-ul „%1” este incorect.',
    'actionlog__cloning_start' => 'pornire',
    'actionlog__event_cloning_start' => 'Pornirea clonării de server',

    '__UPLOAD_ERR_FORM_SIZE' => "Fișierul încărcat depășește dimensiunea permisă",
    '__UPLOAD_ERR_INI_SIZE' => "Fișierul încărcat depășește dimensiunea permisă",
    '__UPLOAD_ERR_NO_FILE' => "Nu s-a primit niciun fișier",
    '__UPLOAD_ERR_OK' => "Fișier încărcat cu succes",
    '__UPLOAD_ERR_PARTIAL' => "Fișierul s-a încărcat parțial, încercați din nou",
    '__UPLOAD_ERR_NO_TMP_DIR' => 'Folderul temporar lipsește',
    '__UPLOAD_ERR_CANT_WRITE' => 'Scrierea fișierului pe disc nu a reușit',
    '__UPLOAD_ERR_UNKNOWN' => 'Eroare necunoscută la încărcarea fișierului',
    '__accounts' => "Conturi",
    '__access' => "Acces",
    '__address' => "Adresă",
    '__addresses' => "Adrese",
    '__acl_records' => 'Înregistrări ACL',
    '__admin_repository' => "Depozitul administratorului",
    '__all' => 'Toate',
    '__allowed' => "Permis",
    '__anonftp_status' => "FTP anonim",
    '__antispam' => "Antispam",
    '__apache_restart' => "...serverul web %1 repornește, așteptați...",
    '__asp' => "Microsoft ASP",
    '__asp_dot_net' => "Microsoft ASP.NET",
    '__asp_dot_net_support' => "Suport Microsoft ASP.NET",
    '__asp_win_support' => "Suport Microsoft ASP",
    '__attachments' => "Atașări",
    '__attachments_list' => "Atașări",
    '__author' => 'Autor',
    '__autoresp_name_already_exists' => "Deja există răspunsul automat cu numele %1.",
    '__autoresponder' => "Răspuns automat",
    '__autoresponders' => "Răspunsuri automate",
    '__autoresponders_list' => "Răspunsuri automate",
    '__autoresponder_attachment_files' => "Fișiere atașate la răspunsurile automate",
    '__auto_updates_list' => 'Actualizări disponibile',
    '__avail' => "Disponibil",
    '__backup_utilites' => "Utilitare pentru copii de rezervă",
    '__bind_status' => "Stare server DNS",
    '__bu_is_not_installed' => "Serviciul nu este disponibil în acest moment pentru că utilitarele de creare a copiilor de rezervă nu a fost instalate.",
    '__bu_not_support_in_key' => "Cheia de licență nu acceptă crearea de copii de rezervă.",
    '__notifications_not_support_in_key' => 'Cheia de licență nu acceptă notificările',
    'disabled_by_key' => 'Nu este acceptat de cheia de licență',
    '__bytes' => "byți",
    '__can_not_use_reserved_words' => "Nu puteți utiliza cuvintele rezervate.",
    '__certificate' => "Certificat",
    '__cgi_support' => "Suport CGI",
    '__change_date' => "Data modificării",
    '__city' => "Localitate",
    '__cl_not_exist' => "Contul de client nu există.",
    '__client' => 'Client',
    '__client_card' => "Card client",
    '__client_contact_name' => "Nume contact client",
    '__client_form' => "Informații personale",
    '__client_ip_pool' => "Domeniul de adrese IP al clientului",
    '__client_limits' => "Limitele contului de client",
    '__client_permissions' => "Permisiuni client",
    '__client_preferences' => "Preferințe client",
    '__client_status' => "Stare client",
    '__client_name' => "Nume client",
    '__client_total' => "Total client",
    '__client_with_login_name_already_exists' => "Utilizatorul cu numele „%1” există deja.",
    '__client_domuser_with_login_already_exists' => "Numele de utilizator „%1” este utilizat deja de administratorul domeniului „%1”.",
    '__clients_global_changes' => "Modificarea conturilor de client selectate",
    '__clients_list' => "Clienți",
    '__cmd_not_found' => "Comandă necunoscută: %1",
    '__comments' => "Comentarii",
    '__company_name' => "Nume companie",
    '__component_version' => "Versiunea componentei",
    '__component_not_installed' => "Componenta %1 nu a fost instalată",
    '__confirm_del' => "Trebuie să confirmați ștergerea.",
    '__confirm_overwrite' => "Confirmați suprascrierea.",
    '__confirm_stop' => "Trebuie să confirmați oprirea procesului.",
    '__confirm_passwd' => "Confirmarea parolei %1",
    '__confirm_removal' => "Confirmare ștergere",
    '__conhelp' => "Descriere",
    '__contact_name' => "Nume contact",
    '__country' => "Țară",
    '__countries' => 'Țară',
    '__country_unknown' => 'Imposibil de recunoscut subcodul de țară.',
    '__courier-imap' => 'Server Courier',
    '__create_domain' => 'Creare domeniu',
    '__crypted' => 'criptat',
    '__cp_access' => "Acces la Plesk",
    '__cp_user' => "Utilizator Plesk",
    '__create' => "Creare",
    '__create_client_template_without_template' => "Crearea unui cont de utilizator fără șablon",
    '__create_domain_for' => "Creare domeniu pentru <b>%1</b>",
    '__create_domain_template_without_template' => "Crearea unui domeniu fără șablon",
    '__creation_date' => "Data creării",
    '__crontab_unix' => "Programator",
    '__crontab_win' => "Programator",
    '__ct_month_jan' => 'ianuarie',
    '__ct_month_feb' => 'februarie',
    '__ct_month_mar' => 'martie',
    '__ct_month_apr' => 'aprilie',
    '__ct_month_may' => 'Mai',
    '__ct_month_jun' => 'iunie',
    '__ct_month_jul' => 'iulie',
    '__ct_month_aug' => 'august',
    '__ct_month_sep' => 'septembrie',
    '__ct_month_oct' => 'octombrie',
    '__ct_month_nov' => 'noiembrie',
    '__ct_month_dec' => 'decembrie',
    '__custom_button' => "Buton personalizat",
    '__custom_buttons_list' => "Linkuri la servicii suplimentare",
    '__daily' => "Zilnic",
    '__database_not_activated' => "%1 nu a fost activat în pagina de administrare server.",
    '__database_not_installed' => "Baza de date %1 nu este instalată.",
    '__database_not_run' => "Baza de date %1 nu este în funcțiune.",
    '__database_is_corrupt' => "Baza de date Plesk este deteriorată. Lansați utilitarul Reconfigurator pentru a o repara.",
    '__databases' => "Baze de date",
    '__databases_list' => "Baze de date",
    '__database_type_not_supported_by_key' => 'Pentru a putea utiliza serverul %1, aveți nevoie de o cheie de licență care acceptă acest lucru. Consultați un reprezentant de vânzări Plesk.',
    '__date_immediately' => "azi",
    '__date_never' => "niciodată",
    '__day(s)' => "Zile",
    '__day0' => "D",
    '__day1' => "L",
    '__day2' => "Ma",
    '__day3' => "Mi",
    '__day4' => "J",
    '__day5' => "V",
    '__day6' => "S",
    '__days' => "%1 zi(le)",
    '__db_admin_login_empty' => "Ați introdus un nume de utilizator gol, dezactivând controlul de %1 în interfață. Continuați?",
    '__db_unable_to_unregister' => 'Imposibil de șters parametrii de conectare la baza de date',
    '__db_db_exists' => 'Pe server există cel puțin o bază de date',
    '__db_unable_to_change_server_name' => 'Numele serverului nu se poate modifica',
    '__db_unable_to_change_port' => 'Portul serverului nu se poate modifica',
    '__db_already_exist' => "Baza de date %1 există deja.",
    '__db_credentials_invalid' => "Acreditările de acces la baza de date sunt incorecte.",
    '__db_invalid_password_characters' => 'Parola conține caractere neacceptate',
    '__db_engine' => "Motorul bazei de date", // indirect
    '__db_type' => "Tipul bazei de date",
    '__db_user' => "Utilizator de baze de date",
    '__db_server' => 'Server de baze de date',
    '__def_domain' => "Domeniu implicit",
    '__default_for_mysql' => 'implicit pentru MySQL',
    '__default_for_mariadb' => 'implicit pentru MariaDB',
    '__default_for_percona' => 'implicit pentru Percona',
    '__default_for_postgresql' => 'implicit pentru PostgreSQL',
    '__delete' => "Ștergere",
    '__demo' => "Această funcție nu este disponibilă în versiunea demo.",
    '__directory' => "Director",
    '__disable_lock_screen' => 'Utilizatorii nu vor putea lucra cu Plesk înainte de încărcarea completă a ecranelor de interfață',
    '__dismiss_news?' => "Sigur închideți blocul de noutăți? Nu veți vedea blocul de noutăți până când nu apar alte știri.",
    '__description' => "Descriere",
    '__disabled' => "oprit",
    '__disk_space_limit' => "Limita spațiului pe disc",
    '__cgroups_cpu_usage_limit' => 'Limită de ocupare CPU',
    '__cgroups_ram_usage_limit' => 'Limită de utilizare RAM',
    '__cgroups_disk_read_usage_limit' => 'Limită de operații de citire de pe disc',
    '__cgroups_disk_write_usage_limit' => 'Limită de operații de scriere pe disc',
    '__disk_usage_by' => "Spațiul pe disc utilizat de %1",
    '__dns' => "DNS",
    '__dns_record_already_exist' => "Înregistrarea DNS „%1” există deja.",
    '__dns_master_should_be_remote' => "Trebuie să aveți două servere de nume autorizate pe gazde diferite.",
    '__dns_record_not_exist' => "Înregistrarea DNS nu există.",
    '__dns_server' => "Server DNS", // indirect
    '__dom_id_is_undefined' => "Identificatorul domeniului este nedefinit.",
    '__dom_name' => "Nume domeniu",
    '__dom_name_is_invalid' => "Numele domeniului este incorect. Asigurați-vă că numele domeniului nu conține decât caractere alfanumerice, puncte și cratime și că nu depășește lungimea de 255 de simboluri. Nicio parte a numelui de domeniu, aflată între două puncte, nu poate depăși lungimea de 63 de simboluri.",
    '__dom_not_exist' => "Domeniul nu există.",
    '__domain' => "Domeniu",
    '__domain_' => 'Domeniul %1',
    '__domain_form' => "Formă domeniu",
    '__domain_id' => "ID domeniu",
    '__domain_is_turned_off_for_backup' => "Site-ul %1 este temporar dezactivat pentru crearea copiei de rezervă sau pentru restaurare. În acest moment nu este accesibil.",
    '__domain_limits' => "Limite domeniu",
    '__domain_name' => "Nume domeniu",
    '__mail_name_in_ASCII_form' => "Nume e-mail în format ASCII",
    '__message_error' => 'Eroare',
    '__message_warning' => 'Avertizare',
    '__message_info' => 'Informații',
    '__domain_name_in_ASCII_form' => "Nume domeniu în format ASCII",
    '__domain_repository' => "Depozit pentru domeniul %1",
    '__domain_status' => "Stare domeniu",
    '__domain_dns' => 'Zona DNS a domeniului',
    '__domain_total' => "Valoare totală pentru abonament",
    '__domain_total_powerUser' => "Valoare totală pentru abonament",
    '__domain_user' => "Administrator de domeniu",
    '__domains_global_changes' => "Modificarea domeniilor selectate",
    '__mailnames_global_changes' => "Modificarea conturilor de e-mail selectate",
    '__backup_manager' => 'Manager copii de rezervă',
    '__domains_list' => "Domenii",
    'domains_list__list_header' => "domenii", //this is a part of phrases like No domains (and others), so it should not be capitalized
    '__double_www_warning' => "Numele de domeniu începe cu www, cu toate că se folosește prefixul WWW. Continuați?",
    '__dovecot' => 'Server IMAP și POP3 Dovecot',
    '__dsmail' => "Serviciu de e-mail",
    '__dsmaillist' => "Serviciu listă de e-mail",
    '__dsr_db' => "Bază de date",
    '__dsr_dname' => "Nume domeniu",
    '__dsr_du' => "Utilizator domeniu",
    '__dsr_ma' => "Cont e-mail",
    '__dsr_mg' => "RM",
    '__dsr_ml' => "Listă e-mail",
    '__dsr_mn' => "Căsuță poștală",
    '__dsr_pname' => "Nume client",
    '__dsr_sd' => "Subdomeniu",
    '__dsr_tr' => "Trafic",
    '__dsr_wu' => "Utilizator web",
    '__dumps_tot_size' => "Dimensiunea totală a fișierelor copie de rezervă în spațiul de stocare local",
    '__email' => "E-mail",
    '__email_addr_is_invalid' => "Adresa de e-mail este incorectă.",
    '__enabled' => "pornit",
    '__enter_cert_text' => "Introduceți textul certificatului",
    '__enter_size' => "Introduceți dimensiunea",
    '__exclusive' => "Dedicată",
    '__expiration_date' => "Data expirării",
    '__fax' => "Fax",
    '__file' => "Fișier",
    '__file_is_empty' => "Fișierul este gol.",
    '__file_name' => "Nume fișier",
    '__file_type' => 'Tip fișier',
    '__filemanager' => "Manager de fișiere",
    '__filepath_is_empty' => "Calea către fișier este goală",
    '__files_list' => "Fișiere",
    '__frontpage' => "Microsoft FrontPage",
    '__ftp' => "FTP", // +indirect
    '__ftp_settings' => "Setări FTP",
    '__ftp_serv' => "Server FTP", // indirect
    '__ftp_server_parameters_are_empty' => "Întâi trebuie să configurați proprietățile contului FTP!",
    '__ftp_status' => "Stare server FTP",
    '__full_day0' => "Duminică",
    '__full_day1' => "Luni",
    '__full_day2' => "Marți",
    '__full_day3' => "Miercuri",
    '__full_day4' => "Joi",
    '__full_day5' => "Vineri",
    '__full_day6' => "Sâmbătă",
    '__full_month1' => "ianuarie",
    '__full_month10' => "octombrie",
    '__full_month11' => "noiembrie",
    '__full_month12' => "decembrie",
    '__full_month2' => "februarie",
    '__full_month3' => "martie",
    '__full_month4' => "aprilie",
    '__full_month5' => "Mai",
    '__full_month6' => "iunie",
    '__full_month7' => "iulie",
    '__full_month8' => "august",
    '__full_month9' => "septembrie",
    '__giga' => "G",
    '__group' => "Grup",
    '__h' => "H",
    '__hard_disk_quota' => "Cotă spațiu pe disc",
    '__hard_disk_quota_not_supported' => 'cota de hard disk nu este acceptată din cauza configurării sistemului de fișiere pe server',
    '__header_text_is_invalid' => "Titlul zonei protejate este incorect.",
    '__help_topic_not_found' => 'Subiectul de ajutor căutat (%1) nu există.',
    '__hosting' => "Găzduire",
    '__hosting_ip_dns_ip_not_equiv' => "Niciuna dintre adresele IP specificate în înregistrările A DNS nu se potrivește cu cea folosită pentru găzduire.",
    '__hosting_scripting' => "Suport utilizare scripturi pentru găzduire",
    '__hosting_setup_page_title' => "Configurarea găzduirii web pentru domeniul %1",
    '__hosting_title' => "Găzduire (%1)",
    '__hosting_type' => "Tip găzduire",
    '__hostname' => "Nume gazdă",
    '__hostname_is_empty' => "Numele de gazdă este necompletat.",
    '__hour(s)' => 'Ore',
    '__hst_type_incorrect' => "Tipul de găzduire este incorect.",
    '__http' => "HTTP", //indirect
    '__htype' => "H",
    '__idle_time' => "Timp de inactivitate",
    '__iface' => "Interfață",
    '__image' => "Imagine",
    '__imap_status' => "Stare server IMAP",
    '__in' => "Intrare",
    '__in_%' => "în %",
    '__incorrect_databases_login_pass' => "Acreditările specificate pentru accesarea PostgreSQL sunt incorecte.",
    '__incorrect_ip_or_network_address' => 'Adresă IP sau de rețea incorectă.',
    '__info' => 'Informații',
    '__install' => "Instalare",
    '__install_prefix' => "Prefix de instalare",
    '__invalid_cert_id' => "ID certificat incorect",
    '__invalid_context' => "Context incorect: %1",
    '__invalid_db_usr_name' => "Numele utilizatorului de baze de date este incorect.",
    '__invalid_dir_name' => "Numele directorului este incorect",
    '__invalid_dom_name' => "Numele domeniului este incorect.",
    '__invalid_filename' => "Numele de fișier este incorect. Nu utilizați caractere apostrof și/sau combinația „../”.",
    '__invalid_id' => "Identificator incorect.",
    '__invalid_lines_num' => "Valoare incorectă la numărul de rânduri, nu se acceptă decât cifre.",
    '__invalid_max_letter_size' => "Dimensiunea maximă a mesajelor este incorectă.",
    '__invalid_pdir_name' => "Numele directorului protejat este incorect.",
    '__invalid_restart_apache_interval' => "Intervalul de repornire Apache este incorect.",
    '__invalid_tmpl_name' => "Numele șablonului este incorect.",
    '__invalid_value' => "Valoare incorectă.",
    '__ip_addr' => "Adresă IP",
    '__ip_address_and_mask' => "Adresă IP și mască de subrețea",
    '__ip_alias__mask' => "Adresă IP și mască de subrețea",
    '__ip_addr_form' => "Formă adresă IP",
    '__ip_addr_is_invalid' => "Adresa IP este incorectă.",
    '__ip_addr_list' => "Adrese IP",
    '__ip_address_does_not_exist' => "Adresa IP nu există.",
    '__ip_addresses' => "Adrese IP",
    '__ip_address_and_mask_hint' => 'De exemplu, %1',
    '__is_owner' => "O",
    '__java_engine' => "Java", // indirect
    '__jdk' => "JDK",
    '__kb' => "KB",
    '__kbps' => "KB/s",
    '__kbytes' => "Kbyți",
    '__key_for_virtuozzo_only' => "Cheia de licență este destinată exclusiv utilizării în containere Virtuozzo.",
    '__key_limits_exceeding' => "Această acțiune depășește limitele stabilite prin licența software. Dacă ați primit acest mesaj, puteți să contactați furnizorul sau producătorul pentru a clarifica sau a extinde limitările acestei licențe.",
    '__kilo' => "K",
    '__keywords' => 'Cuvinte cheie',
    '__lang_unknown' => 'Imposibil de recunoscut limba.',
    '__languages' => 'Limbă',
    '__learn_more' => 'Informații suplimentare',
    '__loading' => 'Se încarcă...',
    '__locales' => "Pachete lingvistice",
    '__lists' => "Liste de e-mail",
    '__literal_bytes' => "B",
    '__processing' => "Așteptați. <br>Se încarcă...",
    '__locale' => "Limba interfeței",
    '__locale_is_not_defined' => "Limba interfeței nu este definită.",
    '__local_server_mysql' => 'Server MySQL local',
    '__local_server_postgresql' => 'Server PostgreSQL local',
    '__local_server_mssql' => 'MS SQL Server local',
    '__log_and_statistics_files' => 'Fișiere jurnal și rapoarte statistice',
    '__config_files' => 'Fișiere de configurare',
    '__chroot_files' => 'Mediu cu chroot',
    '__login' => "%1 Conectare",
    '__login1' => "Conectare",
    '__login_disabled' => "Conectare interzisă",
    '__login_enabled' => "Conectare permisă",
    '__login_incorrect' => "Ați introdus un nume utilizator incorect sau o parolă incorectă.",
    '__login_name' => "Nume utilizator %1",
    '__login_name_is_invalid' => "Numele de utilizator %1 este incorect.",
    '__logon_time' => "Timp de conectare",
    '__ma' => "Aliasuri de e-mail",
    '__mail' => "E-mail",
    '__mail_alias_name' => "Nume alias e-mail",
    '__mail_autodiscovery' => 'Descoperire automată e-mail',
    '__mail_exchanger_name_is_invalid' => "Numele programului de schimb de e-mailuri este incorect.",
    '__mail_groups' => "Grupuri de e-mail",
    '__mail_list_engine' => "Software liste de e-mail",
    '__mail_name' => "Cont de e-mail",
    '__mail_name_form' => "Proprietăți cont de e-mail",
    '__mail_names' => "Conturi de e-mail",
    '__mail_serv' => "Server e-mail",
    '__mail_user' => 'Utilizator e-mail',
    '__mailgroup' => "Grup de e-mail",
    '__maillist' => "Liste e-mail",
    '__maillists' => "Liste de e-mail",
    '__maillist_member' => 'Membru listă de e-mail',
    '__mailname' => "Cont de e-mail",
    '__mailname_redir_self' => "Contul de e-mail nu poate redirecționa mesajul către propria adresă.",
    '__max_dom_num_reached_for_cl' => "S-a atins numărul limită de domenii în acest cont de client.",
    '__max_file_size_available' => "Dimensiunea maximă permisă a unui fișier %1",
    '__max_subdom_num_reached_for_cl' => "S-a atins numărul limită de subdomenii în acest cont de client.",
    '__max_subdom_num_reached_for_dom' => "S-a atins numărul limită de subdomenii în acest domeniu.",
    '__max_subdom_num_reached_for_key' => "S-a atins numărul limită de subdomenii permis de cheia de licență.",
    '__max_traffic_limit' => "Limită de trafic",
    '__maximum_excl_ip_num' => "Conturi de e-mail",
    '__mb' => "MB",
    '__mbytes' => "megabyți",
    '__mb_month' => "MB/lună",
    '__mb_sec' => "MB/sec",
    '__gb_sec' => "GB/sec",
    '__tb_sec' => "TB/sec",
    '__mega' => "M",
    '__minute(s)' => 'Minute',
    '__mls_not_in_key' => "Cheia de produs nu acceptă interfața în mai multe limbi.",
    '__modification_date' => "Data modificării",
    '__module' => "Extensie",
    '__month' => "Lună",
    '__month(s)' => "Luni",
    '__month1' => "Ian",
    '__month10' => "oct",
    '__month11' => "nov",
    '__month12' => "dec",
    '__month2' => "feb",
    '__month3' => "mar",
    '__month4' => "aprilie",
    '__month5' => "Mai",
    '__month6' => "iunie",
    '__month7' => "iulie",
    '__month8' => "aug",
    '__month9' => "Sep",
    '__monthly' => "Lunar",
    '__months' => "Luni",
    '__moved_permanently' => 'Mutat definitiv',
    '__mssql' => "Microsoft SQL Server",
    '__mssql__server' => "Server",
    'mssql__server' => "Nume server Microsoft SQL Server",
    'mssql__unable_to_change_server_name_db_exists' => "numele serverului nu se poate modifica: există cel puțin o bază de date pe acesta.",
    '__mssql_status' => "Stare Microsoft SQL Server",
    '__multiply_login_deny' => "Imposibil de conectat. Un alt utilizator cu același nume (%1) este conectat deja la Plesk.",
    '__mysql' => "MySQL",
    '__mysql_status' => "Stare server MySQL",
    '__mysql_version' => "Versiune Mysql",
    '__mariadb' => "MariaDB",
    '__mariadb_status' => "Stare server MariaDB",
    '__mariadb_version' => "Versiune MariaDB",
    '__percona' => "Percona",
    '__percona_status' => "Stare server Percona",
    '__percona_version' => "Versiune Percona",
    '__name' => "Nume",
    '__name_invalid' => "Numele este incorect.",
    '__nameserver' => "server de nume",
    '__network' => "Rețea",
    '__networks' => "Rețele",
    '__no' => "Nu",
    '__no_ip_address_with_properly_type_available' => "Imposibil de restaurat datele din copiile de rezervă: nu există adresele IP potrivite necesare pentru restaurare.",
    '__no_clients_specified' => "Niciun cont de client specificat.",
    '__no_comments' => "Fără comentarii.",
    '__no_ip_specified' => "Nu s-a specificat nicio adresă IP.",
    '__nologin' => "Interzis",
    '__none' => "Niciunul",
    '__not_configured' => "Neconfigurat",
    '__not_implemented_yet' => "Neimplementat",
    '__not_supported_by_ftp' => "(nu este acceptat de serverul FTP)",
    '__notification' => "Notificare",
    '__num_displayed' => "afișate %1 din %2",
    '__num_is_invalid' => "Numărul este incorect.",
    '__object_not_found' => 'Obiect negăsit: %1',
    '__of_all' => "% din total",
    '__off' => "Oprit",
    '__ok' => "OK",
    '__old_passwd' => "Vechea parolă %1",
    '__on' => "Pornit",
    '__others' => "Alții",
    '__other_ip__will_be_added' => 'Alte adrese IP disponibile (vor fi adăugat în domeniul de adrese IP al clientului)',
    '__out' => "Oprit",
    '__p' => "P",
    '__passwd' => "Parola %1",
    '__passwd_is_invalid' => "Parola %1 este incorectă.",
    '__passwd_not_match' => "Parolele nu sunt identice!",
    '__path' => "Cale",
    '__perl_unix_support' => "Suport Perl",
    '__perl_win_support' => "Suport Perl",
    '__perm_denied' => "Permisiune refuzată.",
    '__permissions' => "Permisiuni",
    '__personal_name' => "Nume personal",
    '__pg_admin_not_activated' => "PostgreSQL nu a fost activat în pagina de administrare server.",
    '__pg_not_inst' => "PostgreSQL nu a fost instalat.",
    '__pg_not_run_or_inst' => "PostgreSQL nu a fost instalat sau nu funcționează.",
    '__pg_not_support_in_key' => "PostgreSQL nu este acceptat de cheia de licență.",
    '__phone' => "Telefon",
    '__phosting' => "Găzduire fizică",
    '__php_support' => "Suport PHP",
    '__php_run_as_isapi' => "se execută ca extensie ISAPI",
    '__php_safe_mode' => "PHP „safe_mode” este activat",
    '__php_version' => "Versiune PHP",
    '__physical' => "Găzduire fizică",
    '__plesk_stat_pdir' => "Protejare director „/plesk-stat/webstat/”",
    '__plesk_stat_dir_name' => "Statistici despre domeniu",
    '__plesk_stat_protect' => "Accesul la statisticile web se protejează cu numele de utilizator și parola FTP ale utilizatorului",
    '__plesk_stat_protect_install' => "accesibil prin directorul protejat cu parolă „/plesk-stat/webstat/”",
    '__pop3_imap' => "POP3/IMAP", // indirect
    '__pop3_status' => "Stare server POP3",
    '__popen_error' => "Eroare la apelarea funcției popen.",
    '__port' => 'Port',
    '__postgres' => "PostgreSQL",
    '__postgresql' => "PostgreSQL",
    '__postgresql_status' => "Stare PostgreSQL",
    '__preferences' => "Setări",
    '__account_preferences' => "Setări cont",
    '__interface_preferences_general' => 'General',
    '__interface_preferences_default' => 'Preferințe de interfață implicite',
    '__interface_preferences_admin' => "Preferințe interfață de administrator",
    '__interface_template' => 'Șablon de personalizare a interfeței',
    '__interface_preferences' => "Preferințe de interfață",
    '__proceed?' => "Continuați?",
    '__protect_dir_user' => "Utilizator director protejat",
    '__protect_dir_users' => "Utilizatori director protejat",
    '__protect_dirs' => "Directoare protejate",
    '__provider_contact_name' => "Nume de contact al proprietarului",
    '__python_unix_support' => "Suport Python",
    '__python_win_support' => "Suport Python",
    '__quota' => "Cotă",
    '__r' => "R",
    '__reconfigure' => "Reconfigurare",
    '__record_type' => "Tip înregistrare",
    '__release' => "Nr. de lansare",
    '__remote_db_not_supported_by_key' => 'Cheia de licență nu acceptă găzduirea bazei de date la distanță.',
    '__remove' => "Ștergere",
    '__remove_confirmation' => "Confirmare ștergere",
    '__remove_protection' => 'Ștergere protecție',
    '__report' => "Raport",
    '__report_auto' => 'Programarea livrărilor',
    '__report_form' => "Formular de raport",
    '__report_size_na' => "Serviciul este indisponibil",
    '__reports_list' => "Rapoarte",
    '__requested' => "Solicitat",
    '__required_fields' => "Câmpuri obligatorii",
    '__resp_name_invalid' => "Numele răspunsului automat este incorect. Utilizați numai litere, cifre, puncte, caractere de subliniere și caractere de tip spațiu.",
    '__c' => "A", // Access to panel
    '__s' => "S",
    '__server_name_is_invalid' => "Numele serverului este incorect.",
    '__screenshots' => 'Capturi de ecran',
    '__script_warning' => "Dacă eliminați posibilitatea de a utiliza scripturile în acest domeniu, toate scripturile afectate vor apărea ca text simplu la apelarea acestora în browser.  Se recomandă ca administratorul să elimine toate scripturile dependente din domeniul în cauză.",
    '__sec' => "Secunde",
    '__second(s)' => "Secunde",
    '__see_list_of_logged_in' => "Vizualizarea listei utilizatorilor conectați în acest moment.",
    '__select_certs_to_remove' => "Selectați certificatele ce vor fi șterse.",
    '__select_domains_to_default_host' => "Selectați domeniul care va fi setat ca implicit.",
    '__select_domains_to_remove' => "Selectați domeniile ce vor fi șterse.",
    '__type_domain_name_to_add' => "Tastați numele domeniului de adăugat.",
    '__select_files_to_remove' => "Selectați fișierele care vor fi șterse.",
    '__select_ip' => "Atribuire adresă IP",
    '__select_ip_to_remove' => "Selectați adresa IP care va fi ștearsă.",
    '__select_domain_template' => "Se utilizează setările șablonului de domeniu",
    '__select_templates_to_remove' => "Selectați șabloanele care vor fi șterse.",
    '__server' => "Server",
    '__server_total' => "Total server",
    '__service' => "Serviciu",
    '__service_title__plesk' => "Plesk",
    '__service_description__plesk' => "Plesk",
    '__service_title__mysql' => "Server de baze de date MySQL",
    '__service_description__mysql' => "Server de baze de date MySQL",
    '__service_title__web' => "Server web",
    '__service_description__web' => "Server web",
    '__service_title__smtp' => "Server SMTP",
    '__service_description__smtp' => "Server SMTP",
    '__service_title__mail' => "Server IMAP/POP3",
    '__service_description__mail' => "Server IMAP/POP3",
    '__service_title__dns' => "Server DNS",
    '__service_description__dns' => "Server DNS",
    '__service_title__postgresq' => "Server de baze de date PostgreSQL",
    '__service_description__postgresq' => "Server de baze de date PostgreSQL",
    '__service_title__spamassassin' => "Serviciul de filtrare antispam SpamAssassin",
    '__service_description__spamassassin' => "Serviciul de filtrare antispam SpamAssassin",
    '__services' => "Servicii",
    '__all_services' => "Toate serviciile",
    '__sessions' => "Sesiuni",
    'sessions__feature_ftp_session_manager_not_supported' => "Serverul de FTP actual nu acceptă funcția Sesiuni FTP.",
    '__sessions_list' => "Sesiuni",
    '__set' => "Activare",
    '__shared' => "Partajat",
    '__shell_access_warning' => "Permiterea accesului de shell la sistem este deosebit de periculoasă pentru securitatea sistemului. Permiteți accesul la sistem numai dacă înțelegeți ce înseamnă acest lucru, și numai utilizatorilor de încredere. Sigur permiteți accesul?",
    '__siteapp_not_support_in_key' => "Cheia de licență nu acceptă aplicațiile web",
    '__siteapp_cannot_reconfigure_with_remote_database' => 'Configurația acestei aplicații web a fost modificată manual. Pentru a proteja modificările manuale, reconfigurarea prin Plesk nu mai este disponibilă.',
    '__site_management' => "Publicarea pe web", // indirect
    '__size' => "Dimensiune",
    '__skeleton' => 'Șablon de gazdă virtuală',
    '__skins' => 'Prezentări',
    '__smtp' => "SMTP", // indirect
    '__smtp_status' => "Stare server SMTP",
    '__some_fields_are_empty_or_invalid' => "Unele câmpuri sunt necompletate sau conțin o valoare necorespunzătoare.",
    '__unable_to_set_parameters' => "Imposibil de setat parametrii componentei",
    '__spamassassin' => "Filtru antispam",
    '__spamassassin_status' => "Stare SpamAssassin",
    '__spamd_status' => 'Stare filtru antispam',
    '__splited_backup' => "(copie de rezervă multivolum)",
    '__split_backup_file' => "Crearea unei copii de rezervă multivolum",
    '__split_backup_size' => "Dimensiune volum",
    '__split_backup_less_than_500' => "Volumele mai mici decât 500 de MB nu sunt acceptate",
    '__ssi' => "SSI",
    '__ssi_support' => "Suport SSI",
    '__ssi_with_html' => "pentru fișierele *.htm, *.html se utilizează SSI",
    '__ssl' => 'SSL/TLS',
    '__ssl_support' => "Suport SSL/TLS",
    '__same_ssl' => "Conținutul SSL/TLS și cel non-SSL/TLS se pun în același director",
    '__same_ssl_cu' => "Conținut comun SSL/TLS și non-SSL/TLS",
    '__state' => "Stat/județ",

    '__status__Active' => 'Activ',
    '__status__active' => 'activ',
    '__status__Passive' => 'Oprit',
    '__status__passive' => 'oprit',
    '__status__off' => 'oprit',
    '__status__with_parent' => 'oprit',
    '__status__backup_restore' => 'suspendat temporar pentru crearea sau restaurarea copiei de rezervă',
    '__status__admin' => 'suspendat de către administratorul de server',
    '__status__resseler' => 'suspendat de reseller',
    '__status__client' => 'suspendat de client',
    '__status__unknown' => 'starea este necunoscută',

    '__status_of' => "Stare %1",
    // end of akss part

    // shramko part

    '__stunnel' => "Stunnel",
    '__stunnel_server' => "Server Stunnel", // indirect
    '__subdomain' => "Subdomeniu",
    '__subdomain_name' => "Nume subdomeniu",
    '__subdomain_name_in_ASCII_form' => "Nume subdomeniu în format ASCII",
    '__subdomains' => "Subdomenii",
    '__domainaliases' => "Aliasuri de domeniu",
    '__subdomains_list' => "Subdomenii",
    '__subdomains_not_support_in_key' => "Cheia de licență nu permite operațiile cu subdomenii",
    '__sys_user_type' => "Utilizator FTP",
    '__sys_user_type_main' => "Se utilizează contul de utilizator FTP al domeniului principal",
    '__sys_user_type_native' => "Se creează un cont de utilizator FTP separat pentru acest subdomeniu",
    '__t' => "T",
    '__target_domain' => "Domeniu țintă",
    '__template' => "Șablon",
    '__template_not_accepted' => "Imposibil de acceptat șablonul: următoarele limitări sunt depășite.",
    '__templates' => "Șabloane",
    '__templates_list' => "Șabloane",
    '__tera' => "T",
    '__title' => "Titlu",
    '__tools' => "Instrumente",
    '__total' => "Total %1",
    '__total_size' => "Dimensiune totală",
    '__total_used' => "Total utilizat",
    '__traffic' => "Trafic",
    '__traffic_by_client' => "Trafic pe clienți",
    '__traffic_by_domain' => "Trafic pe domeniu",
    '__traffic_by_service' => "Trafic pe serviciu",
    '__traffic_history' => "Istoric de trafic",
    '__unable_change_locale' => "Imposibil de schimbat limba interfeței: %1",
    '__unable_create_new_dom' => "Imposibil de creat un domeniu: %1",
    '__unable_define_dom_name' => "Imposibil de definit numele de domeniu: %1",
    '__unable_define_necessary_properties' => "Imposibil de definit toate proprietățile obligatorii.",
    '__unable_define_properties' => "Imposibil de definit proprietățile: %1",
    '__unable_exec_util' => "Imposibil de executat utilitarul: %1",
    '__unable_get_dns_a_recs' => "Nu se pot obține adresele IP pentru înregistrările A DNS ale acestui cont de găzduire: %1",
    '__unable_get_mbox_quota' => "Imposibil de obținut informațiile despre capacitatea căsuței poștale.",
    '__unable_redirect_to_myself' => "Imposibil de redirecționat către același cont.",
    '__unable_redirect_to_my_alias' => "Imposibil de redirecționat către un alias de e-mail.",
    '__default_domain_redirect_to_myself' => "Imposibil de setat domeniul drept implicit pentru adresa IP: s-a detectat o redirecționare spre propria adresă.",
    '__unable_remove_client' => "Imposibil de șters clientul: %1",
    '__unable_set_up_mbox_quota' => "Imposibil de setat limita de dimensiune a căsuței poștale pentru domeniul: %1",
    '__unable_setup_pass' => "Imposibil de setat parola: %1",
    '__unable_to_create_new_account' => "Imposibil de creat un cont: %1",
    '__unable_to_define_db_size' => "Imposibil de definit dimensiunea bazei de date.",
    '__unable_to_enable_short_names' => "Imposibil de permis utilizarea numelor scurte pentru conturile de e-mail POP3/IMAP.",
    '__unable_to_fetch_data_from_submit' => "Imposibil de preluat informațiile transmise: %1",
    '__unable_to_open_file' => "Imposibil de deschis fișierul %1: %2",
    '__unable_to_update_subdomain' => "Imposibil de modificat subdomeniul: %1",
    '__unable_update_cl_data' => "Imposibil de salvat modificările în contul de utilizator: %1",
    '__unable_update_db_params' => "Imposibil de actualizat parametrii bazei de date: %1",
    '__unable_update_dom_data' => "Imposibil de actualizat datele privind domeniul: %1",
    '__undefined' => "nedefinit",
    '__uninstall' => "Dezinstalare",
    '__unknown_error' => "Eroare necunoscută",
    '__unlimited_lower' => "Nelimitat",
    '__unset' => "Oprire",
    '__update' => "Actualizare",
    '__uploaded_file_is_invalid' => "Fișierul încărcat este incorect: %1",
    '__url' => "URL",
    '__usage' => "Utilizare disc",
    '__user' => 'Utilizator',
    '__user_already_logged' => "Un alt utilizator cu același nume (%1) este conectat deja la Plesk.",
    '__version' => "Versiune",
    '__aps_license' => "Cheie de licență",
    '__vh_type' => "Tip gazdă virtuală",
    '__vhosts_apache_status' => "Stare server web",
    '__wrong_charset_conversion' => 'Set de caractere incorect, conversia din „%1” la „%2” este interzisă',
    '__warning_' => "Avertisment!",
    '__warning_excl_ip_num' => "Adresă IP dedicată",
    '__warning_expiration' => "Data expirării",
    '__web_scripting' => "Scripturi Web", // indirect
    '__web_serv' => "Server web", // indirect
    '__web_statistic' => "Statistici web", // indirect
    '__webmail' => "Webmail", // +indirect
    '__webstat_not_installed' => "Webalizer nu este instalat pe server. Contactați furnizorul de servicii pentru a primi ajutor în instalarea Webalizer.",
    '__webstat_support' => "Statistici web",
    '__webstat_awstats_support' => "AWStats",
    '__webstat_webalizer_support' => "Webalizer",
    '__webstat_awstats' => "AWStats",
    '__webstat_webalizer' => "Webalizer",
    '__webstat_type_change_warning' => "Atunci când treceți de la un program de statistică la altul, se șterg toate rapoartele create cu programul vechi și se creează altele noi, conform informațiilor citite din fișierele jurnal păstrate pe server. Acest lucru înseamnă că dacă ați configurat sistemul (prin Domenii> nume domeniu> Manager de jurnale> Rotația fișierelor jurnal) să păstreze fișierele jurnal pe o perioadă de o lună, statisticile vor fi disponibile numai pentru ultima lună. Treceți la alt pachet de statistică?",
    '__webstat_perm_denied' => 'Nu aveți permisiunea de a administra statisticile web.',
    '__webuser' => "Utilizator web",
    '__sysusers_list' => "Utilizatori de sistem",
    '__sysuser' => "Utilizator de sistem",
    '__weekly' => "Săptămânal",
    '__whats_new_in_version' => "Noutățile din Plesk %1",
    '__wrong_hosting_type__none' => 'Nu există găzduire web configurată pentru domeniul %1.',
    '__wrong_hosting_type__std_fwd' => 'Domeniul %1 are configurată redirecționarea standard. Această operație este valabilă numai în cazul domeniilor cu găzduire web.',
    '__wrong_hosting_type__frm_fwd' => 'Domeniul %1 are configurată redirecționarea cu cadre. Această operație este valabilă numai în cazul domeniilor cu găzduire web.',
    '__wu' => "Utilizatori web",
    '__www' => "WWW",
    '__www_prefix_was_changed' => "Prefixul WWW a fost modificat. Modificați corespunzător certificatul SSL/TLS.",
    '__year' => "An",
    '__year(s)' => "Ani",
    '__yes' => "Da",
    '__you' => "Dvs.",
    '__zip_code' => "Cod poștal/ZIP",
    '__form_normal' => "Normal",
    '__form_advanced' => "Avansat",

    'admin_ed__edit_administrator_info' => "Editarea profilului de administrator",
    'admin_ed__create_default_client' => "Doresc să creez un cont de client implicit.",
    'admin_ed__unable_update' => "Imposibil de actualizat informațiile despre administrator: %1",

    'auth__update_admin_info' => "Introduceți informațiile despre administrator. Aceste informații sunt necesare pentru utilizarea %1.",
    'auth__you_not_have_perm' => "Nu aveți permisiuni de administrare a acestui domeniu.",
    'auth__key_expired_admin' => 'Licența Plesk a expirat. Pentru a putea utiliza Plesk în continuare, reînnoiți licența sau cumpărați una nouă.',
    'auth__key_expired_admin_restricted' => 'Licența Plesk a expirat. Contactați furnizorul de servicii pentru a putea utiliza Plesk în continuare.',
    'auth__key_expired_client' => 'Licența Plesk a expirat Contactați furnizorul de servicii de găzduire.',
    'autoinstaller__not_installed' => 'Componenta de instalare automată nu este instalată.',
    'autoinstaller__release_action' => 'Operații disponibile',
    'autoinstaller__release_action_icon' => 'S',
    'autoinstaller__release_action_upgrade' => 'Upgrade la noua versiune Plesk',
    'autoinstaller__release_action_update' => 'Actualizarea sau adăugarea unor componente noi',
    'autoinstaller__release_action_up2date' => 'Aveți o versiune la zi',
    'autoinstaller__component_action' => 'Stare',
    'autoinstaller__component_action_icon' => 'S',
    'autoinstaller__component_action_install' => 'Nu este instalat',
    'autoinstaller__component_action_update' => 'Sunt disponibile actualizări',
    'autoinstaller__component_action_upgrade' => 'Este disponibilă o actualizare',
    'autoinstaller__component_action_up2date' => 'Aveți o versiune la zi',
    'autoinstaller__component_action_error' => 'Nu este disponibilă nicio actualizare',
    'autoinstaller__component_serverbuildtime' => 'Ultimul nr. de lansare',
    'autoinstaller__component_localbuildtime' => 'Nr. dvs. de lansare',
    'autoinstaller__component_installed_version' => 'Versiunea dvs.',
    'autoinstaller__component_available_version' => 'Ultima versiune',
    'autoinstaller__component' => 'Componentă',
    'autoinstaller__components' => 'Componente',
    'autoinstaller__components_title' => '%1 componente',
    'autoinstaller__component_dependency_note' => 'necesară pentru instalarea componentelor pe care le-ați selectat',
    'autoinstaller__install_confirm' => 'Da, vreau să instalez aceste componente',
    'autoinstaller__install_confirm_request' => 'Bifați caseta de selectare pentru a confirma',
    'autoinstaller__install_title' => 'Confirmarea instalării componentelor selectate',
    'autoinstaller__key_update_confirm' => 'Se confirmă ignorarea actualizării cheii și instalarea cheii implicite',
    'autoinstaller__key_update_confirm_request' => 'Bifați caseta de selectare pentru a confirma.',
    'autoinstaller__key_update_failed' => '<p>Plesk nu poate actualiza licența de produs.</p><p>%1</p><p>Continuarea procesului de upgrade fără o licență de produs corespunzătoare va duce la instalarea unei licențe implicite, cu funcții limitate. Administratorilor li se recomandă să cumpere cheia de licență corespunzătoare înainte de a continua procesul de upgrade al produsului.</p>',
    'autoinstaller__email' => 'Se trimite notificare la',
    'autoinstaller__email_admin' => "Adresa de e-mail a administratorului",
    'autoinstaller__email_email' => 'Adresă e-mail personalizată...',
    'autoinstaller__release' => 'Descriere nr. de lansare',
    'autoinstaller__releases' => 'Nr. de lansare disponibile',
    'autoinstaller__releases_title' => 'Plesk Updater',
    'autoinstaller__select_components_to_install' => 'Selectați componentele de instalat',
    'autoinstaller__status_error' => 'Eroare: %1',
    'autoinstaller__status_install_error' => 'Imposibil de început instalarea: %1',
    'autoinstaller__status_install_busy' => 'Imposibil de început instalarea: în acest moment se execută o altă procedură de instalare.',
    'autoinstaller__status_install_ok' => 'Instalarea a început. Veți primi prin e-mail notificări privind desfășurarea instalării (%1).',
    'autoinstaller__status_query_busy' => 'Instalare în desfășurare.',
    'autoinstaller__status_query_error' => 'Imposibil de obținut starea instalării: %1',
    'autoinstaller__status_unknown' => 'Imposibil de obținut starea programului de instalare automată.',
    'autoinstaller__status_busy' => 'Programul de instalare automată este ocupat, așteptați.',
    'autoinstaller__configure_title' => 'Setările programului de actualizare',
    'autoinstaller__preferences_legend' => 'Setări',
    'autoinstaller__target' => 'Director de descărcare temporară',
    'autoinstaller__target_invalid' => "Specificați calea absolută",
    'autoinstaller__check_updates' => 'Căutarea actualizărilor după conectarea administratorului la Plesk',
    'autoinstaller__check_updates_warning' => 'Sunt disponibile <a href="%1">actualizări</a> noi pentru %2',
    'autoinstaller__source_type' => 'Tip sursă',
    'autoinstaller__source' => 'URL sursă',
    'autoinstaller_source__preferences_legend' => 'Setări',
    'autoinstaller_source__type' => 'Tip sursă',
    'autoinstaller_source__url_invalid' => 'Sursă incorectă',
    'autoinstaller_source__url_invalid_network' => 'URL sursă incorect (exemplu: http://source, ftp://source)',
    'autoinstaller_source__url' => 'URL sursă',
    'autoinstaller__source_invalid_network' => 'Ați specificat o adresă de rețea incorectă',
    'backup__repository' => 'Locația spațiului de stocare a fișierelor copie de rezervă',
    'backup__error_notify_email' => 'Dacă apar erori în timpul creării copiei de rezervă, se trimite notificare la adresa de e-mail',
    'backup__dump_info' => "Informații copie de rezervă",
    'backup__dump_file_name_not_defined' => "Numele fișierului copie de rezervă nu este specificat",
    'backup__local_file' => 'Fișier copie de rezervă local',
    'backup__domain_ftp' => 'server FTP la distanță',
    'backup__wrong_path' => "Cale incorectă către spațiul de stocare a fișierelor copie de rezervă: Nu utilizați secvența de caractere ../../",
    'backup__unable_to_connect_to_ftp_server' => "Imposibil de conectat la serverul FTP: %1",
    'backup__unable_to_read_file' => 'Imposibil de citit fișierul copie de rezervă.',
    'backup__backup_task_does_not_exist' => "Nu există sarcina de creare a copiei de rezervă, trebuie să-l creați înainte de activare.",
    'backup__restore_params' => "Parametrii de restaurare",
    'backup__confirmation' => "Avertisment: domeniul nu va fi disponibil în timpul realizării copiilor de rezervă/restaurării.",
    'backup__backup_method' => 'Metoda de realizare a copiilor de rezervă',
    'backup__dumpfile_name' => "Numele fișierului copie de rezervă",
    'backup__dumpfile_name_is_invalid' => "Numele fișierului copie de rezervă este incorect: utilizați doar caractere alfanumerice, cratime, puncte și caractere de subliniere. Nu utilizați nume ca descriere.* pentru fișierul copie de rezervă.",
    'backup__email_required' => "Adresa de e-mail este necesară pentru a vă putea ține la curent în legătură cu procesele de creare, respectiv restaurare a copiilor de rezervă. Specificați adresa de e-mail în detaliile contului.",
    'backup__error_during_backup' => "Imposibil de creat fișierul copie de rezervă: %1",
    'backup__input_email_warning' => "Trebuie să specificați o adresă de e-mail pentru notificări sau să goliți caseta de selectare.",
    'backup__make_download' => "fișierul copie de rezervă nu se păstrează în spațiul de stocare, doar se descarcă",
    'backup__make_dump' => 'se creează fișierul copie de rezervă și se păstrează în spațiul de stocare local',
    'backup__makedump_to_ftp' => 'crearea fișierului copie de rezervă și stocarea acestuia pe serverul FTP',
    'backup__restore_ip' => "Adresa IP pentru restaurare",
    'backup__select_dumpfile' => "Selectați un fișier copie de rezervă.",
    'backup__time' => "Ora creării copiei de rezervă",
    'backup__day' => 'Ziua creării copiei de rezervă',
    'backup__view_dump_info' => "Vizualizați informațiile despre fișierul copie de rezervă din domeniul %1",
    'backup__wrong_domain_name' => "Fișierul copie de rezervă conține datele din domeniu. %1. Drept urmare, nu se poate restaura în domeniul %2",
    'backup__incorrect_ftp_user_or_passwd' => "Utilizator sau parolă FTP incorecte. Corectați proprietățile contului FTP",
    'backup__access_denied' => "Acces interzis. Corectați proprietățile contului FTP",
    'backup__restore_from' => "Restaurare %1",
    'backup__domain_session_failed' => 'Copia de rezervă a domeniului %1 nu a fost creată',
    'backup__client_session_failed' => 'Copia de rezervă cu datele clientului %1 nu a fost creată',
    'backup__domain_session_restore_failed' => 'Domeniul %1 nu a fost restaurat',
    'backup__client_session_restore_failed' => 'Contul de client %1 nu a fost restaurat',
    'backup__domain_session_complete' => 'S-a creat copia de rezervă a domeniului %1',
    'backup__domain_session_backup' => 'Copie de rezervă a domeniului %1',
    'backup__client_session_backup' => 'Creare copie de rezervă cu datele clientului %1',
    'backup__domain_stop_title' => 'Se revocă crearea copiei de rezervă a domeniului %1',
    'backup__client_stop_title' => 'Se revocă crearea copiei de siguranță pentru contul de client %1',
    'backup__domain_restore_stop_title' => 'Se revocă restaurarea domeniului %1',
    'backup__client_restore_stop_title' => 'Se revocă restaurarea contului de client %1',
    'backup__domain_session_backup_stop' => 'Sunteți pe cale să revocați procesul activ de creare a unei copii de rezervă. Fișierul copie de rezervă nu se va crea.',
    'backup__backup_stop_confirm' => 'Da, doresc să opresc procesul de creare a copiei de rezervă',
    'backup__restore_stop_confirm' => 'Da, doresc să opresc procesul de restaurare',
    'backup__domain_session_restore' => 'Se restaurează domeniul %1',
    'backup__domain_session_restore_stop' => 'Sunteți pe cale să revocați procesul activ de restaurare.',
    'backup__domain_backup_file_info' => 'Informații despre fișierul copie de rezervă de domeniu',
    'backup__domain_backup_file_list' => 'fișiere copie de rezervă existente',
    'backup__domain_backup_progress' => 'Desfășurarea procesului de creare a copiei de rezervă cu site-ul web %1',
    'backup__domain_restore_progress' => 'Desfășurarea procesului de restaurare a site-ului web %1',
    'backup__domain_backup_progress_elapsed_time' => 'Timp scurs: %1',
    'backup__domain_restore_progress_elapsed_time' => 'Timp scurs: %1',
    'backup__ip_map_legend' => 'Mapare IP',
    'backup__ip_map_list_count' => 'Adrese IP',
    'backup__domain_restore_session_complete' => 'Domeniul %1 este restaurat.',
    'backup__domain_restore_session_complete_message' => 'Domeniul %1 a fost restaurat.',
    'backup__domain_backup_file_delete' => 'Următoarele fișiere copie de rezervă vor fi șterse:',
    'backup__domain_backup_file_for_remove' => 'Selectați fișierele copie de rezervă pe care doriți să le ștergeți',
    'backup__backup_overwrite_file_confirm' => 'Confirmare înlocuire',
    'backup__backup_overwrite_file_confirm_text' => 'Deja există un fișier copie de rezervă cu numele „%1”. Îl înlocuiți?',
    'backup__backup_confirm_overwrite' => 'Confirmare suprascriere fișier',
    'backup__backup_overwrite_legeng' => 'Înlocuire',
    'backup__backup_not_contain_domain' => 'Fișierul copie de rezervă nu conține informații despre domeniul %1',
    'backup__backup_not_contain_client' => 'Fișierul copie de rezervă nu conține informații despre contul de client %1',
    'backup__backup_client_info' => "Crearea unei copii de rezervă cu setările și cu detaliile contului clientului",
    'backup__client_backup_progress' => 'Desfășurarea procesului de creare a copiei de rezervă cu contul de client %1',
    'backup__client_session_complete' => 'S-a creat copia de rezervă cu datele contului de client %1',
    'backup__client_backup_file_info' => 'Informații despre fișierul copie de rezervă de client',
    'backup__restore_client_info' => "Restaurarea setărilor și a detaliilor contului de client",
    'backup__client_session_restore' => 'Se restaurează contul de client %1',
    'backup__client_db_server_map' => 'Maparea serverelor de baze de date',
    'backup__domain_db_server_map' => 'Maparea serverelor de baze de date',
    'backup__client_restore_session_complete_message' => 'Contul de client %1 a fost restaurat.',
    'backup__client_restore_session_complete' => 'Contul de client %1 a fost restaurat.',
    'backup__restore_select_some' => 'Selectați obiectele pe care doriți să le restaurați.',
    'backup__client_restore_progress' => 'Desfășurarea procesului de restaurare a contului de client %1',
    'backup__new_backup' => 'Crearea unei noi copii de rezervă',
    'backup__done' => 'Terminat:',
    'backup__done_domains' => '%1 domenii din %2',
    'backup__done_clients' => '%1 clienți din %2',
    'backup__remaining' => 'Rămase:',
    'backup__remaining_domains' => '%1 domenii',
    'backup__remaining_clients' => '%1 clienți',
    'backup__overall_backup_progress' => 'Progres general al procesului de creare a copiei de rezervă',
    'backup__comment_n_a' => 'nu este cazul',
    'backup__command_ignore' => 'Comanda „%1” este ignorată',
    'backup__no_objects' => 'nu există niciun obiect pentru copia de rezervă',
    'backup__cli_warning_not_enough_ip' => 'AVERTISMENT: nu există destule adrese IP pentru a putea executa maparea IP implicită:',
    'backup__local_repository' => "Spațiu de stocare Plesk",
    'backup__ftp_repository' => 'Spațiu de stocare FTP',
    'backup__ftp_login' => 'Nume utilizator',
    'backup__ftp_password' => 'Parolă',
    'backup__ftp_directory_hint' => 'Exemplu: /myfolder/mybackups',
    'backup__ftp_account_settings' => 'Setări cont FTP',
    'backup__ftp_account_preferences' => 'Setări cont FTP',
    'backup__repository_not_exist' => 'Director inexistent',
    'backup__repository_not_readable' => 'Directorul specificat nu este accesibil la citire',
    'backup__ftp_repository_not_configure' => 'Pentru a utiliza spațiul de stocare FTP, <a href="%1">specificați întâi contul FTP</a> .',
    'backup__ftp_repository_list_not_configure' => 'Nu s-au specificat setările contului',
    'backup__repository_list_unable_listing' => 'Imposibil de obținut lista fișierelor',
    'backup__ftp_repository_unable_listing' => 'Imposibil de obținut lista conținutului directorului „%1”:',
    'backup__repository_legend' => 'Spațiul de stocare a fișierelor copie de rezervă',
    'backup__store_in_repository' => 'Fișierele se stochează în',
    'backup__local_repository_lable' => 'Spațiu de stocare local',
    'backup__ftp_repository_lable' => 'Spațiu de stocare FTP',
    'backup__ftp_repository_not_configure_hint' => '(setările contului nu sunt specificate)',
    'backup__ftp_repository_not_configure_or_forbidden_hint' => '(contul FTP nu este specificat sau nu este acceptat)',
    'backup__ftp_directory_not_exist' => 'Directorul specificat nu există',
    'backup__other_user_process_modified' => 'Un alt utilizator a oprit procesul de creare a copiei de rezervă sau de migrare.',
    'backup__another_user_exist' => 'Operația în desfășurare a fost inițiată de un alt utilizator Plesk. Acest utilizator este conectat în continuare la Plesk.',
    'backup__ftp_repository_wait' => 'Așteptați preluarea informațiilor despre spațiul de stocare FTP',
    'backup__ftp_write_test_failed' => 'Eroare la scrierea datelor de test în contul FTP %1:',
    'bt_upload_to_repository' => 'Încărcare fișiere în spațiul de stocare local',
    'bt_new_restore' => "Restaurare",
    'bt_backup_schedule' => "Programarea creării copiei de rezervă",
    'backup_exist_backups' => "Fișiere copie de rezervă existente",
    'backup_dialog__page_title' => "Creare fișier copie de rezervă",
    'backup_dialog__please_wait' => "Procesul de crea a copiei de rezervă este pe cale să înceapă. Această operație poate fi de durată. Așteptați...",
    'backup_conf__page_title' => 'Configurarea copiilor de rezervă',
    'bt_accept' => "Acceptare",
    'bt_access' => "Acces",
    'bt_action_log' => "Jurnal de acțiuni",
    'bt_add' => "Adăugare",
    'bt_add_client' => "Atribuire către utilizatori",
    'bt_database_server_add' => 'Adăugare server baze de date',
    'bt_add_services' => "Adăugare servicii",
    'bt_anonftp_stats' => "Stat. FTP anon.",
    'bt_anonymous_ftp' => "FTP anonim",
    'bt_aspdotnet' => "ASP.NET",
    'bt_attach' => "Atașare",
    'bt_autoinstaller' => 'Program de actualizare',
    'bt_auto-updates' => 'Program de actualizare',
    'bt_back' => "<< Înapoi",
    'bt_backup' => "Se creează o copie de rezervă cu",
    'bt_backup_configure' => "Setări legate de copiile de rezervă",
    'bt_buy_certs' => "Cumpărare certificate",
    'bt_card' => "Card",
    'bt_cert' => "Certificat",
    'bt_certificates' => "Certificate",
    'bt_change_passwd' => "Schimbare parolă",
    'bt_clear' => "Ștergere",
    'bt_client_templates' => "Șabloane de client",
    'bt_clients' => "Clienți",
    'bt_codepage_change' => 'Schimbarea codificării',
    'bt_comp_info' => "Administrare componente",
    'bt_configure_maillists' => "Configurare Mailman",
    'bt_configure_odbc' => "Surse de date ODBC",
    'bt_configure' => 'Configurare',
    'bt_copy' => "Copiere",
    'bt_copy_move' => "Copiere/mutare",
    'bt_create' => "Creare",
    'bt_create_account' => "Creare cont",
    'bt_create_dir' => "Adăugare director",
    'bt_create_file' => "Adăugare fișier",
    'bt_count_size' => "Calculul dimensiunii totale",
    'bt_crontab_unix' => "Crontab",
    'bt_crontab_win' => "Programator sarcini",
    'bt_custom_button_new' => "Adăugare buton",
    'bt_custom_buttons' => "Butoane personalizate",
    'bt_customize' => "Personalizare",
    'bt_databases' => "Baze de date",
    'bt_database_servers' => 'Servere de baze de date',
    'bt_sqlservers' => "Servere de baze de date",
    'bt_db_usr_new' => "Adăugare utilizator de baze de date",
    'bt_db_new' => "Adăugare bază de date",
    'bt_db_phpmyadmin' => "Administrator MySQL",
    'bt_dbuser_default' => "Setare ca opțiune implicită pentru DB Webadmin",
    'bt_decline' => "Refuzare",
    'bt_default' => "Implicit",
    'bt_defaultcomponents' => "Servicii de la terți",
    'bt_defaults' => "Implicite",
    'bt_delete' => "Ștergere",
    'bt_directories' => "Directoare protejate",
    'bt_disable' => "Dezactivare",
    'bt_dns' => "Setări DNS",
    'bt_dns_enable' => 'Activare',
    'bt_dns_disable' => 'Dezactivare',
    'bt_dns_default' => 'Resetare la valoarea implicită',
    'bt_dns_zone_sync' => 'Aplicarea modificărilor de șablon DNS',
    'bt_dnsrecord_add' => 'Adăugare înregistrare',
    'bt_do_backup' => "Creare copie de rezervă",
    'bt_do_restore' => "Restaurare",
    'bt_do_upload' => "Încărcare",
    'bt_domain_aliases' => "Aliasuri de domeniu",
    'bt_domain_templates' => "Șabloane de domeniu",
    'bt_domain_user' => "Administrator de domeniu",
    'bt_domain_user_passwd' => "Parolă administrator de domeniu",
    'bt_domains' => "Domenii",
    'bt_domain_alias_add' => 'Adăugare alias de domeniu',
    'bt_download' => "Descărcare",
    'bt_edit' => "Editare",
    'bt_enable' => "Activare",
    'bt_export' => 'Export',
    'bt_extras' => "Suplimentar",
    'bt_file_manager' => "Manager de fișiere",
    'bt_finish' => "Terminare",
    'bt_ftp_account' => "Proprietățile contului FTP",
    'bt_forget_password' => "Ați uitat parola?",
    'bt_fp_ssl_webadmin' => "Webadmin FP-SSL/TLS",
    'bt_fp_webadmin' => "Administrator web FP",
    'bt_ftp_stats' => "Statistici FTP",
    'bt_get_password' => "Obținere parolă",
    'bt_global_changes' => "Modificare",
    'bt_help' => "Ajutor",
    'bt_hide_aliases' => "Ascundere aliasuri",
    'bt_hide_toolbar' => 'Ascundere bară de instrumente',
    'bt_hide_subdomains' => "Ascundere subdomenii",
    'bt_hide_domainaliases' => "Ascundere aliasuri de domeniu",
    'bt_home' => "Pagina de pornire",
    'bt_hosting' => "Găzduire",
    'bt_icf' => 'Firewall',
    'bt_install' => "Instalare",
    'bt_ip_aliasing' => "Adrese IP",
    'bt_ip_add' => "Adăugare adresă IP",
    'bt_ip_pool' => "Domeniu de adrese IP",
    'bt_key_info' => "Informații despre licență",
    'bt_key_buyonline_addons' => 'Comandă de componente add-on pentru Plesk',
    'bt_key_buyonline_upgrades' => 'Comandă de upgrade-uri Plesk',
    'bt_key_buyonline_new' => 'Comandă de cheie nouă',
    'bt_limits' => "Limite",
    'bt_locale_add' => 'Adăugare limbă',
    'bt_locales' => 'Limbi',
    'bt_log_manager' => "Manager de jurnale",
    'bt_login' => "Conectare",
    'bt_logo' => "Branding",
    'bt_logo_send_link' => "Atașare link",
    'bt_logo_send_logo' => "Atașare siglă",
    'bt_logout' => "Deconectare",
    'bt_logrotation' => "Rotație fișiere jurnal",
    'bt_mail' => "E-mail",
    'bt_mail_alias_add' => "Adăugare alias de e-mail",
    'bt_mail_aliases' => "Aliasuri de e-mail",
    'bt_mail_group_add' => "Adăugare membru",
    'bt_mail_groups' => "Grupuri",
    'bt_mail_name_add' => "Adăugare cont de e-mail",
    'bt_mail_preferences' => "Setări",
    'bt_mail_group' => "Grup de e-mail",
    'bt_mail_mailbox' => "Căsuță poștală",
    'bt_mail_redirect' => "Redirecționare",
    'bt_mail_resp_add' => "Adăugare răspuns automat",
    'bt_mail_resp_attach_add' => "Adăugare atașare",
    'bt_mail_resp_files' => "Fișiere atașate",
    'bt_mail_responders' => "Răspunsuri automate",
    'bt_mail_spamfilter' => "Filtru antispam",
    'bt_mail_webmail' => "Webmail",
    'bt_maillist_new' => "Adăugare listă de e-mail",
    'bt_maillists' => "Liste de e-mail",
    'bt_mailman' => "Mailman",
    'bt_make_dump' => "Creare copie de rezervă",
    'bt_manage' => "Administrare",
    'bt_master' => "Principal",
    'bt_migrate' => 'Migrare',
    'bt_modules_add' => 'Adăugare extensie',
    'bt_modules_manage' => 'Administrare extensii',
    'bt_move' => "Mutare",
    'bt_mimetypes' => 'Tipuri MIME',
    'bt_mimetype_new' => 'Adăugare tip NIME',
    'bt_new_client' => "Adăugare cont de client",
    'bt_new_domain' => "Adăugare domeniu",
    'bt_next' => "Următorul>>",
    'bt_next_page' => "Următorul",
    'bt_network_add' => "Adăugare rețea",
    'bt_notifications' => "Notificări",
    'bt_odbc_dsn_add' => "Adăugare DSN ODBC",
    'bt_off' => "Oprit",
    'bt_on' => "Pornit",
    'bt_on_off' => "Pornit/oprit",
    'bt_pd_new' => "Adăugare director protejat",
    'bt_pd_user_new' => "Adăugare utilizator",
    'bt_performance' => 'Performanță',
    'bt_permissions' => "Permisiuni",
    'bt_phpmyadmin' => "PhpMyAdmin",
    'bt_postgre_sql' => "PostgreSQL",
    'bt_preferences' => "Setări",
    'bt_prev_page' => "Anterior",
    'bt_preview' => 'Previzualizare site',
    'bt_print' => "Imprimare",
    'bt_reboot' => "Repornire",
    'bt_reload' => "Reîncărcare",
    'bt_refresh' => "Reîmprospătare",
    'bt_register' => "Înregistrare",
    'bt_remove' => "Ștergere",
    'bt_enable_selected' => 'Activare',
    'bt_disable_selected' => 'Dezactivare',
    'bt_repair_ip' => "Reparare IP",
    'bt_report' => "Raport",
    'bt_report_auto' => 'Raport de livrare',
    'bt_report_auto_new' => 'Adăugare program de livrare',
    'bt_report_new' => "Adăugare aspect",
    'bt_reset' => "Resetare",
    'bt_restart_services' => "Administrare servicii",
    'bt_save' => "Salvare",
    'bt_send_by_email' => "Trimitere prin e-mail",
    'bt_send_file' => "Trimitere fișier",
    'bt_send_mail' => "Trimitere e-mail",
    'bt_send_passwd' => "Trimitere parolă",
    'bt_send_text' => "Trimitere text",
    'bt_server' => "Server",
    'bt_server_add' => "Adăugare server",
    'bt_server_preferences' => "Setările de server",
    'bt_servers_list' => "Servere",
    'bt_sessions' => "Sesiuni",
    'bt_set' => "Setare",
    'bt_set_as_default' => "Setare ca valoare implicită",
    'bt_setup' => 'Configurare',
    'bt_show_aliases' => "Afișare aliasuri",
    'bt_show_subdomains' => "Afișare subdomenii",
    'bt_show_domainaliases' => "Afișarea aliasurilor de domeniu",
    'bt_shutdown' => "Închidere",
    'bt_site_apppkgs' => "Seif de aplicații",
    'bt_site_apppool' => "Listă de aplicații",
    'bt_application-pool' => "Aplicații web",
    'bt_site_apps' => "Aplicații web",
    'bt_site_app_add' => "Instalare aplicație",
    'bt_site_builder' => "Suport Presence Builder",
    'bt_skeleton' => 'Șablon de gazdă virtuală',
    'bt_skins' => 'Prezentări',
    'bt_skin_add' => 'Adăugare prezentare',
    'bt_skin_manual' => 'Referință despre prezentările personalizate în Plesk', // not used
    'bt_skin_download' => 'Descărcare prezentare',
    'bt_skin_replace' => 'Actualizarea prezentare',
    'bt_skip' => 'Omitere',
    'bt_spamassassin' => "Filtru antispam",
    'bt_spamassassin_train' => "Instruire",
    'bt_spamfilter' => "Filtru antispam",
    'bt_sshterm' => 'Terminal SSH',
    'bt_start' => "Pornire",
    'bt_stop' => "Oprire",
    'bt_recycle' => "Reciclare",
    'bt_statistics' => "Statistici",
    'bt_subdomain_new' => "Adăugare subdomeniu",
    'bt_subdomains' => "Subdomenii",
    'bt_submit' => "Trimitere",
    'bt_summary_report' => "Raport rezumat",
    'bt_support' => "Asistență",
    'bt_switch' => "Comutare",
    'bt_system_time' => "Ora sistemului",
    'bt_task_new' => "Adăugare sarcină",
    'bt_dom_tmpl_add' => 'Adăugare șablon de domeniu',
    'bt_cl_tmpl_add' => 'Adăugare șablon client',
    'bt_cron_backup' => 'Setări pentru crearea programată a copiilor de rezervă',
    'bt_test' => "Testare conexiune",
    'bt_text' => "Text",
    'bt_touch' => "Schimbarea marcajului de timp",
    'bt_traffic' => "Trafic",
    'bt_traffic_history' => "Istoric de trafic",
    'bt_update' => "Actualizare",
    'bt_upload' => "Încărcare",
    'bt_upload_from_ftp' => "Încărcare FTP",
    'bt_virtualdirs' => 'Directoare virtuale',
    'bt_virtualdir_new' => 'Adăugare director virtual',
    'bt_virtualdir_add' => 'Adăugare director virtual',
    'bt_web_app_new' => "Instalare aplicație Java",
    'bt_web_stats' => "Statistici web",
    'bt_web_stats_ssl' => "Statistici web SSL/TLS",
    'bt_web_user_add' => "Adăugare utilizator web",
    'bt_web_users' => "Utilizatori web",
    'bt_webadmin' => "Webadmin",
    'bt_webalizer' => "Webalizer",
    'bt_whats_new_full' => "Afișarea listei complete a schimbărilor",
    'cert_add__unable_set_ca_cert' => "Imposibil de setat certificatul CA: %1",
    'cert_add__unable_set_cert' => "Imposibil de setat certificatul: %1",
    'cert_add__unable_set_private_key' => "Imposibil de setat cheia privată: %1",
    'certificates_list__certificate_used_as_default' => "Unul din certificatele pe care doriți să le ștergeți este utilizat drept certificat implicit.",
    'certificates_list__certificates_assigned_on_ip' => "Unul sau mai multe certificate sunt atribuite adreselor IP/domeniilor.",
    'ch_pass__admin_pass' => "Schimbarea parolei de administrator",
    'ch_pass__old_pass' => "Parola veche",
    'ch_pass__pass_confirm' => "Confirmare",
    'ch_pass__unable_change_admin_pass' => "Imposibil de schimbat parola de administrator: %1",
    'check_mail_cycle__aliases' => "S-a detectat o ciclare de e-mailuri, adresa „%1” apare în aliasurile acestui cont de e-mail.",
    'check_mail_cycle__autoresponders' => "S-a detectat o ciclare de e-mailuri, adresa „%1” apare în răspunsurile automate din acest cont de e-mail.",
    'check_mail_cycle__mail_groups' => "S-a detectat o ciclare de e-mailuri, adresa „%1” apare în grupul de e-mail al acestui cont de e-mail.",
    'check_mail_cycle__mail_name' => "S-a detectat o ciclare de e-mailuri, adresa „%1” coincide cu acest cont de e-mail.",
    'check_mail_cycle__redirect' => "S-a detectat o ciclare de e-mailuri, adresa „%1” coincide cu redirecționarea din acest cont de e-mail.",
    'check_mail_dup__redirect' => "S-a detectat o redirecționare dublă, adresa „%1” coincide cu adresa de redirecționare din acest cont de e-mail.",
    'check_mail_dup__mail_groups' => "S-a detectat o redirecționare dublă, adresa „%1” apare în grupul de e-mail al acestui cont de e-mail.",
    'check_maillist_cycle__admin' => "S-a detectat o ciclare de e-mailuri, adresa „%1” a administratorului coincide cu adresa listei de e-mail.",
    'check_maillist_cycle__member' => "S-a detectat o ciclare de e-mailuri, adresa „%1” coincide cu adresa listei de e-mail.",
    'chk_js__enter_login_and_passwd' => "Introduceți numele de utilizator și parola corespunzătoare.",
    'chk_js__enter_login_name' => "Introduceți numele de utilizator.",
    'chk_js__enter_passwd' => "Introduceți parola.",

    // end of shramko part

    // serge part
    'cl_ed__edit_cl' => "Detalii de cont %1",
    'cl_limits__cl' => "Limitele clientului %1",
    'cl_logo__setup_logo_pref' => "Setarea proprietăților siglei pentru clientul %1",
    'cl_new__enter_new_cl_data' => "Introduceți informațiile despre noul client",
    'cl_new__unable_to_sent_notification' => 'Contul de utilizator a fost creat, dar trimiterea notificării către client nu a reușit: %1',
    'cl_perm__all_ip' => "Toate adresele IP disponibile",
    'cl_perm__all_ip_based_hst_will_be_nb' => "Toate conturile de găzduire pe bază de adrese IP ale clientului vor fi transformate în conturi de tip Pe bază de nume.",
    'cl_perm__allow_client_create_domain' => "Câmpurile pe care încercați să le selectați sunt valabile doar pentru clienții care au dreptul să creeze domenii.",
    'cl_perm__allow_create_nb_w_ip' => "Clientul poate crea găzduire pe bază de nume folosind %1",
    'cl_perm__allow_creation_ip_based_hosting' => "Se permite crearea conturilor de găzduire pe bază de adresă IP",
    'cl_perm__available_ips' => "IP-uri disponibile",
    'cl_perm__change_limits' => "Ajustarea limitelor",
    'cl_perm__cl_disk_space' => "Total spațiu pe disc disponibil",
    'cl_perm__cl_expiration' => "Perioada de valabilitate a contului de client",
    'cl_perm__cl_max_box' => "Căsuțe poștale",
    'cl_perm__cl_max_db' => "Baze de date",
    'cl_perm__cl_max_dom' => "Domenii",
    'cl_perm__cl_max_maillists' => "Liste de e-mail",
    'cl_perm__cl_max_subdom' => "Subdomenii",
    'cl_perm__cl_max_traffic' => "Total trafic disponibil",
    'cl_perm__cl_max_wu' => "Utilizatori web",
    'cl_perm__cl_mbox_quota' => "Limita de dimensiune a căsuței poștale pentru acest cont de utilizator",
    'cl_perm__current_maximum_exp_date' => "Valoarea actuală maximă a perioadei de validitate a domeniului este %1; se solicită %2.",
    'cl_perm__current_maximum_mailbox_quota' => "Valoarea actuală maximă a spațiului pe disc alocat căsuțelor poștale din acest cont de utilizator este %1; se solicită %2",
    'cl_perm__current_total_requested' => "Valoarea actuală totală a limitelor domeniului pentru %1 este %2; se solicită %3.",
    'cl_perm__current_total_requested_dom' => "Numărul actual de %1 care aparțin acestui client este %2. Numărul solicitat: %3.",
    'cl_perm__disk_space' => "spațiu pe disc maxim",
    'cl_perm__dashboard_stdgui' => 'Interfață utilizator',
    'cl_perm__dashboard' => 'Vizualizare pagină de pornire',
    'cl_perm__stdgui' => 'Vizualizare standard',
    'cl_perm__manage_dashboard' => 'Administrarea paginii de start',
    'cl_perm__dashboard_and_stdgui' => 'Se permit vizualizările pagină de pornire și standard',
    'cl_perm__dashboard_only' => 'Se permite doar vizualizarea pagină de pornire',
    'cl_perm__stdgui_only' => 'Se permite doar vizualizarea standard',
    'cl_perm__edit_cl' => "Permisiunile clientului %1",
    'cl_perm__exp_date_exceeded' => "Perioada de valabilitate pe care încercați să o setați depășește limitele specificate în domeniile individuale legate de acest client.",
    'cl_perm__invalid_value' => "Valoare incorectă, se acceptă doar cifre.",
    'cl_perm__limit_disk_space' => "%1 Limitare spațiu total pe disc",
    'cl_perm__limit_expiration' => "%1 Limitarea perioadei de valabilitate a contului de client",
    'cl_perm__limit_max_box' => "%1 Limitare număr maxim de căsuțe poștale",
    'cl_perm__limit_max_db' => "%1 Limitare număr maxim de baze de date",
    'cl_perm__limit_max_dom' => "%1 Limitare număr maxim de domenii",
    'cl_perm__limit_max_maillists' => "%1 Limitare număr maxim de liste de e-mailuri",
    'cl_perm__limit_max_subdom' => "%1 Limitare număr maxim de subdomenii",
    'cl_perm__limit_max_traffic' => "%1 Limitare volum total de trafic",
    'cl_perm__limit_max_wu' => "%1 Limitare număr maxim de utilizatori web",
    'cl_perm__limit_mbox_quota' => "%1 Setare cotă de căsuță e-mail",
    'cl_perm__limits_exceeded' => "Una sau mai multe limite pe care încercați să le setați depășesc limitele specificate în domeniile individuale care aparțin acestui client. Limita totală a clientului trebuie să fie mai mare decât sau egală cu totalul limitelor pe domenii definite pentru acest cont de client.",
    'cl_perm__mailbox_quota_exceeded' => "Limita de spațiu pe disc alocat pentru căsuțele poștale, pe care încercați să o setați, depășește limitele impuse domeniilor individuale legate de acest cont de client.",
    'cl_perm__mailbox_quota_exceeds_server_limit' => "Limita de spațiu pe disc alocat pentru căsuțele poștale, pe care încercați să o setați, depășește limitările impuse la nivel de server.",
    'cl_perm__make_dumps' => "Crearea copiilor de rezervă și restaurarea datelor",

    'cl_perm__max_box' => "număr maxim de căsuțe poștale",
    'cl_perm__max_db' => "număr maxim de baze de date",
    'cl_perm__max_dom' => "domenii",
    'cl_perm__max_maillists' => "număr maxim de liste de e-mail",
    'cl_perm__max_subdom' => "subdomenii",
    'cl_perm__max_traffic' => "volum maxim de trafic",
    'cl_perm__max_wu' => "număr maxim de utilizatori web",
    'cl_perm__max_dom_aliases' => "aliasuri de domeniu",
    'cl_perm__mbox_quota' => "cotă de căsuță poștală",
    'cl_perm__not_allow_create_nb_hst' => "Clientul nu poate crea găzduire Pe bază de nume găzduire.",
    'cl_perm__select_ip_addrs' => "Selectare adrese IP",
    'cl_perm__this_ip_used_vrt_hst' => "Această adresă IP este utilizată pentru găzduirea virtuală. Pentru a șterge această adresă IP, ștergeți serviciul de găzduire sau schimbați-i tipul în găzduire pe bază de nume.",
    'cl_perm__unable_off_ipb_creating' => "Clientul are deja configurat serviciul Pe bază de adresă IP. Dacă doriți să dezactivați această funcție pentru client, goliți caseta de selectare „Creare domeniu” sau ștergeți toate conturile de găzduire Pe bază de adresă IP.",
    'cl_perm__unable_off_nb_creating' => "Clientul are deja configurat serviciul Pe bază de nume. Dacă doriți să dezactivați această funcție pentru client, goliți caseta de selectare „Creare domeniu” sau ștergeți toate conturile de găzduire Pe bază de nume.",
    'cl_perm__unable_set_domain_limit' => "Imposibil de limitat numărul maxim de domenii: clientul are deja %1 domenii",
    'cl_perm__unable_update_client_limitations' => "Imposibil de modificat limitele contului de client: %1",
    'cl_pref__edit_cl' => "Preferințele clientului %1",
    'class_anonftp__create_ftp_domain' => "Nu există niciun domeniu FTP virtual pentru acest dom_id, întâi încercați să-l creați.",
    'class_anonftp__incoming_disk_space_should_be_lower' => "Limita de spațiu pe disc pe care încercați să o setați (%1) nu trebuie să depășească limita totală definită la nivel de domeniu (%2).",
    'class_anonftp__invalid_input_only_digits' => "A fost specificată o valoare incorectă, nu se acceptă decât cifre.",
    'class_anonftp__unable_change_ownerships' => "Imposibil de schimbat proprietarul sau permisiunile pentru fișierul de cote: %1",
    'class_anonftp__unable_copy_quota_file' => "Imposibil de copiat fișierul de cote: %1",
    'class_anonftp__unable_get_disk_usage' => "Imposibil de obținut informațiile de utilizare a spațiului în directorul de primire: %1",
    'class_anonftp__unable_parse_quota_file' => "Imposibil de analizat fișierul de cote.",
    'class_anonftp__unable_read_quota_file' => "Imposibil de citit fișierul de cote: %1",
    'class_anonftp__unable_update_quota' => "Imposibil de actualizat cota: fișierele din directorul de primire utilizează %1 KB din spațiul pe disc, ceea ce depășește noua valoare a cotei.",
    'class_anonftp__unable_write_temp_file' => "Imposibil de scris în fișierul temporar: %1",
    'class_bsdomain__warn_max_date__' => "Dată expirării a fost setată la %1",
    'class_cList__empty' => "Niciun element.",
    'class_cList__header' => "%1 (%2)",
    'class_cList__not_found' => "Nu s-a găsit nicio potrivire pentru <b>„%1”</b> în %2 (%3 din %4).",
    'class_cList__search_result' => "Rezultatele căutării după <b>„%1”</b> în %2 (%3 din %4).",
    'class_client__client_creation_notification' => "Notificare de creare a clientului.",
    'class_client__client_with_contact_name_already_exists' => "Clientul cu numele %1 există deja.",
    'class_client__disk_space' => "Spațiu pe disc",
    'class_client__invalid_max_dom' => "Valoare incorectă la numărul de domenii, nu se acceptă decât cifre.",
    'class_client__limit_exceed' => "Nu se poate aloca volumul solicitat de %1, pentru că s-ar depăși cota alocată contului clientului %2 (%3). Dacă doriți să alocați mai multe resurse, accesați Clienți> nume client> Limite și modificați alocările în funcție de necesități. Reveniți apoi la acest ecran și încercați să modificați din nou alocările.",
    'class_client__limit_exceed_unlimited' => "Dacă doriți să alocați resurse în cuantum nelimitat (%1), trebuie să accesați întâi Clienți> nume client> Limite și să bifați caseta de selectare Nelimitat în dreptul tipului de resursă necesar. Reveniți apoi la acest ecran și încercați să modificați din nou alocările.",
    'class_client__max_box' => "Căsuțe poștale",
    'class_client__max_db' => "Baze de date",
    'class_client__max_maillists' => "Liste de e-mail",
    'class_client__max_subdom' => "Subdomenii",
    'class_client__max_traffic' => "Trafic maxim",
    'class_client__max_wu' => "Utilizatori web",
    'class_client__max_dom_aliases' => "Aliasuri de domeniu",
    'class_client__mbox_quota' => "Cotă de căsuță poștală",
    'class_client__unable_define_cl_status' => "Imposibil de definit starea contului de client: %1",
    'class_client__unable_define_inactive_dom' => "Imposibil de definit domeniile inactive %1.",
    'class_client__unable_del_ip' => "Imposibil de șters adresele IP: %1",
    'class_db__db_name_not_set' => "Numele bazei de date nu este definit.",
    'class_db__db_not_exist_for_curr_dom' => "Baza de date nu există pentru acest domeniu.",
    'class_db__invalid_db_or_dom_name' => "ID-ul domeniului sau al bazei de date este incorect sau numele bazei de date nu este definit.",
    'class_db__invalid_pass' => "Parola nu este corectă.",
    'class_db__mailgrp_member_exist' => "Membrul grupului de e-mail există deja.",
    'class_db__access_hosts_notsupport' => 'Setarea de acces la gazdă nu este acceptată pentru acest tip de bază de date',
    'class_db__unable_add' => 'Imposibil de adăugat înregistrarea de acces gazdă: %1',
    'class_db__unable_del' => 'Imposibil de șters înregistrarea de acces gazdă: %1',
    'class_db__inc_user_not_exist' => 'Utilizatorul de bază de date „%1” nu există',
    'class_db__inc_access_record_exist' => 'Această înregistrare de acces există deja',
    'class_db__inc_access_record_not_exist' => 'Înregistrarea de acces dată nu există',
    'class_db__inc_unable_del_last_record' => 'Imposibil de șters ultima înregistrare de acces gazdă',
    'class_domtmpleditform__dns_master' => "Principal",
    'class_domtmpleditform__dns_slave' => "Secundar",
    'class_domtmpleditform__dns_type' => "Tip zonă DNS de domeniu",
    'class_traffichistory__no_data_available' => "Nu sunt disponibile date.",
    'class_traffichistory__traffic_usage' => "Utilizare trafic",
    'clienttrafficlist_header' => "Trafic pe domenii",
    'clienttrafficlist_header_of_client__' => "Traficul în domeniile clientului %1",
    'cmd_dns__a_dns_record_already_exist' => "Această înregistrare intră în conflict cu înregistrarea A a zonei.",
    'cmd_dns__domain_last_ns' => 'Ultima înregistrare NS DNS a domeniului nu poate fi ștearsă.',
    'cmd_dns__canonical_dom_name_is_invalid' => "Numele canonic al domeniului este incorect.",
    'cmd_dns__cname_dns_record_already_exist' => "Această înregistrare intră în conflict cu înregistrarea CNAME a zonei.",
    'cmd_dns__cname_in_rr_combination' => 'În zona DNS este prezentă o combinație incorectă de înregistrări DNS',
    'cmd_dns__cname_coexist_with_data' => 'O înregistrare de zonă DNS CNAME nu poate coexista cu alte înregistrări DNS în aceeași zonă.',
    'cmd_dns__dns_record_type_is_invalid' => "Tipul de înregistrare DNS este incorect.",
    'cmd_dns__ext_host_is_not_resolved' => "Rezolvarea numelui canonic %1 nu indică o înregistrare A sau AAAA.",
    'cmd_dns__domain_restore_dns_zone_failed_add_record' => 'Imposibil de adăugat înregistrarea %1 la zona %2: %3',
    'cmd_dns__mail_dom_name_is_invalid' => "Numele programului de schimb de e-mailuri este incorect.",
    'cmd_dns__mx_priority_is_invalid' => "Prioritatea MX este incorectă.",
    'cmd_dns__name_server_is_invalid' => "Serverul de nume este incorect.",
    'cmd_dns__network_mask_should_be_24_16_or_8' => "Valoarea măștii de rețea trebuie să fie 24, 16 sau 8.",
    'cmd_dns__this_dns_record_already_exists' => "Deja există o asemenea înregistrare DNS.",
    'cmd_dns__unable_add_record' => "Imposibil de adăugat înregistrarea „%1”: %2",
    'cmd_dns__unable_add_a_record' => "Imposibil de adăugat înregistrarea de tip A: %1",
    'cmd_dns__unable_add_cname_record' => "Imposibil de adăugat înregistrarea de tip CNAME: %1",
    'cmd_dns__unable_add_dns_record' => "Imposibil de adăugat înregistrarea de tip DNS: %1.",
    'cmd_dns__unable_add_ext_ns_record' => "Imposibil de adăugat înregistrarea de tip EXT_NS: %1",
    'cmd_dns__unable_add_ns_record' => "Imposibil de adăugat înregistrarea de tip NS: %1",
    'cmd_dns__unable_add_ptr_record' => "Imposibil de adăugat înregistrarea de tip PTR: %1",
    'cmd_dns__unable_add_txt_record' => "Imposibil de adăugat înregistrarea de tip TXT: %1",
    'cmd_dns__unable_create_dns_zone' => "Imposibil de creat zona DNS %1",
    'cmd_dns__unable_define_dns_record' => "Imposibil de definit înregistrarea DNS %1.",
    'cmd_dns__unable_get_default_dns_zone_status_set_true' => "Imposibil de obținut starea implicită a zonei DNS: %1",
    'cmd_dns__unable_insert_a_record' => "Imposibil de inserat înregistrarea de tip A: %1",
    'cmd_dns__unable_insert_mx_record' => "Imposibil de inserat înregistrarea de tip MX: %1",
    'cmd_dns__unable_insert_ns_record' => "Imposibil de inserat înregistrarea de tip NS: %1",
    'cmd_dns__unable_set_dns_zone_status' => "Imposibil de setat starea zonei DNS: %1",
    'cmd_domains__dom_already_exists' => "Domeniul %1 există deja.",
    'cmd_domains__dns_record_already_exists' => "Imposibil de creat domeniul %1: deja există o înregistrare DNS care indică gazda %1.",
    'cmd_domains__dom_already_exists1' => "În acest domeniu sunt %2 subdomenii. Domeniul %1 există deja.",
    'cmd_domains__dom_already_exists2' => "subdomeniul %1 există deja.",
    'cmd_domains__dalias_already_exists' => "Acest alias există deja.",
    'cmd_domains__domain_alias_already_exists' => 'Deja există un alias de domeniu cu acest nume.',
    'cmd_domains__unable_del_mail_for_dom' => "Imposibil de șters serviciile de e-mail pentru domeniul: %1",
    'cmd_domains__unable_delete_anonymous_ftp' => "Imposibil de șters contul de FTP anonim pentru domeniul: %1",
    'cmd_domains__unable_update_dom_param' => "Imposibil de actualizat parametrii domeniului: %1.",
    'cmd_domains__unable_rename_client_exist' => "numele de utilizator al administratorului de domeniu este deja în uz.",
    'cmd_hosting__hst_type_is_not_physical_hst' => "Tipul de găzduire nu este fizic.",
    'cmd_hosting__unable_create_user' => "Imposibil de creat utilizatorul %2: %1",
    'cmd_hosting__unable_define_ip_addr_for_name_based_virtual_hosts' => "Imposibil de definit adresa IP pentru gazdele virtuale pe bază de nume: %1",
    'cmd_hosting__unable_del_old_hst' => "Imposibil de șters găzduirea configurată anterior : %1",
    'cmd_hosting__unable_del_protected_directory' => "Imposibil de șters directorul protejat: %1.",
    'cmd_hosting__unable_del_web_user' => "Imposibil de șters utilizatorul web: %1",
    'cmd_hosting__unable_make/update_virtual_host' => "Imposibil de creat sau de actualizat gazda virtuală: %1",
    'cmd_hosting__unable_make_frame_forward_hst' => "Imposibil de configurat găzduirea cu redirecționare de cadre.",
    'cmd_hosting__unable_rebuild_ftp_config' => "Imposibil de reconstituit fișierul de configurare proftpd: %1.",
    'cmd_hosting__unable_set_up_ssl' => "Imposibil de configurat SSL/TLS: %1.",
    'cmd_hosting__unable_unprotect_ssl_directory' => "Imposibil de eliminat protecția din directorul SSL/TLS: %1",
    'cmd_hosting__unable_update_dest_url' => "Imposibil de actualizat URL-ul de destinație %1.",
    'cmd_hosting__unable_update_dns_zone_for_dom_unable_exec_util' => "Imposibil de actualizat zona DNS pentru domeniu: executarea utilitarului nu a reușit.",
    'cmd_hosting__unable_update_ftp_passwd' => "Imposibil de actualizat parola FTP %1.",
    'cmd_hosting__unable_update_user' => "Imposibil de actualizat utilizatorul %2: %1",
    'cmd_hosting__unknown_hst_type' => "Tip de găzduire necunoscut.",
    'cmd_hosting__you_not_have_permission_del_hst' => "Nu aveți permisiunea de a închide serviciul de găzduire.",
    'cmd_mail__autoresponder__not_configured' => "Răspunsul automat nu este configurat pentru acest cont de e-mail",
    'cmd_mail__addr_already_used_in_mail_redirect' => "Adresa %1 se utilizează deja pentru redirecționarea de e-mailuri.",
    'cmd_mail__alias_already_exists' => "aliasul există deja.",
    'cmd_mail__autoresp_id_and_mailname_id_not_match' => "ID-ul răspunsului automat și cel al contului de e-mail nu se potrivesc.",
    'cmd_mail__autoresp_id_is_undefined' => "ID-ul răspunsului automat este nedefinit.",
    'cmd_mail__mail_alias_already_exists_in_mail_name' => "În contul de e-mail %1 există deja un alias de e-mail cu acest nume.",
    'cmd_mail__mail_name_already_exists_in_maillists' => "Contul de e-mail %1 este abonat deja la această listă de e-mail.",
    'cmd_mail__mail_name_alredy_exist_in_dom' => "Contul de e-mail %1 există deja în acest domeniu.",
    'cmd_mail__mail_name_not_exist' => "Contul de e-mail nu există.",
    'cmd_mail__mail_name_passwd_part' => "Parola nu trebuie să conțină denumirea contului de e-mail.",
    'cmd_mail__maillist_already_exist_in_this_dom' => "Lista de e-mail %1 există deja în acest domeniu.",
    'cmd_mail__mailname_already_exist_in_mg' => "Contul de e-mail %1 este deja într-un grup de e-mail.",
    'cmd_mail__mailname_already_exist_in_this_dom' => "Contul de e-mail %1 există deja în acest domeniu.",
    'cmd_mail__mailname_already_exists' => "Contul de e-mail există deja.",
    'cmd_mail__mailname_is_invalid' => "Numele de cont de e-mail %1 este incorect.",
    'cmd_mail__mailname_unable_update' => "Imposibil de actualizat proprietățile contului de e-mail:",
    'cmd_mail__max_autoresp_reached_for_this_dom' => "S-a atins numărul maxim de răspunsuri automate în acest domeniu.",
    'cmd_mail__max_mail_groups_num_has_been_reached_for_this_dom' => "S-a atins numărul maxim de grupuri de e-mail în acest domeniu.",
    'cmd_mail__max_num_of_redirects_has_been_reached_for_this_dom' => "S-a atins numărul maxim de redirecționări în acest domeniu.",
    'cmd_mail__max_postboxes_num_has_been_reached' => "S-a atins numărul maxim de căsuțe poștale.",
    'cmd_mail__no_members_specified' => "nu au fost specificați membrii.",
    'cmd_mail__the_passwd_is_too_simple_choose_another' => "Parola este prea simplă, vă rugăm să alegeți alta.",
    'cmd_mail__this_addr_already_exist_in_mg_or_mn' => "Adresa de e-mail este deja în uz.",
    'cmd_mail__unable_define_autoresp_id' => "Imposibil de definit ID-ul răspunsului automat %1.",
    'cmd_mail__unable_update_mail_for_dom' => "Modificarea setărilor serviciului de e-mail pentru domeniul %1 nu a reușit",
    'cmd_mail__unable_del_mail_for_dom' => "Imposibil de eliminat serviciul de e-mail din domeniul %1.",
    'cmd_mail__unable_del_mail_redirection' => "Imposibil de eliminat serviciul de redirecționare a e-mailurilor %1.",
    'cmd_mail__unable_remove_autoresp' => "Imposibil de șters răspunsurile automate: %1",
    'cmd_mail__unable_remove_mail_group_members' => "Imposibil de eliminat membrii grupului de e-mail: %1",
    'cmd_mail__unable_turn_off_mail_group' => "Dezactivarea grupului de e-mail nu a reușit: %1",
    'cmd_mail__unable_update_mail_redirect' => "Imposibil de reconfigurat serviciul de redirecționare a e-mailurilor %1.",
    'cmd_mail__uploaded_file_is_too_big' => "Fișierul încărcat este prea mare.",
    'cmd_mail__additionally' => "În plus:",
    'cmd_pd__invalid_login' => "Nume utilizator incorect.",
    'cmd_pd__this_user_already_exist' => "Deja există un asemenea utilizator.",
    'cmd_pd__unable_define_hst_type' => "Imposibil de definit tipul de găzduire.",
    'cmd_pd__unable_upd_pd_usr' => "Imposibil de actualizat proprietățile utilizatorului directorului protejat: %1.",
    'cmd_pd__user_is_undefined' => "Utilizatorul nu este definit.",
    'cmd_server__no_enough_free_disk_space' => "Spațiu pe disc insuficient.",
    'cmd_server__old_passwd_is_incorrect_please_try_again' => "vechea parolă nu este corectă. Încercați din nou.",
    'cmd_web_usr__max_web_users_reached_for_this_dom' => "a fost atins numărul maxim de utilizatori web pentru acest domeniu.",
    'cmd_web_usr__unable_create_user' => "imposibil de creat utilizatorul de sistem: %1",
    'cmd_web_usr__unable_define_max_web_users_limit' => "imposibil de definit limita maximă de utilizatori web: %1",
    'cmd_web_usr__user_already_exists' => "utilizatorul există deja.",
    'cmd_web_usr__web_user_name_is_invalid' => "numele utilizatorului web %1 este incorect.",
    'cmd_web_usr__web_user_not_exist' => "utilizatorul web nu există.",
    'common_func__exec_bad_argument' => "Argumentul la executare nu trebuie să conțină caracterul apostrof.",
    '__eol' => 'Caractere rând nou',
    'eol__binary_file' => 'Stilul caracterului de sfârșit de rând nu poate fi schimbat în fișierul binar.',
    'comp_info__header' => 'Componente',
    'comp_info__comp_name' => "Numele componentei",
    'comp_info__comp_disabled' => 'Oprit',
    'comp_info__comp_active' => 'Activ',
    'comp_info__comp_not_configured' => 'Neconfigurat',
    'comp_info__comp_not_started' => 'Nu este pornit, verificați setările componentei',
    'comp_info__comp_version' => "Versiunea componentei",
    'comp_info__integration_error' => "Eroare de integrare",
    'comp_info__title' => "Componente Plesk",
    'comp_info__service_name' => "Serviciu",
    'comp_info__last_updated' => '(ultima actualizare: %1)',
    'cp_access_admin_deny' => "Accesul administratorului de la adresa „%1” este restricționat conform politicii actuale de acces prin IP.",
    'create_domain_warn__' => "La crearea domeniului s-au făcut următoarele excepții:",
    'create_domain__client_select' => 'Selectați clientul pentru care creați domeniul',

    'dashboard__nav_button_name' => "Pagina de pornire",
    'dalias__list_title' => 'Aliasurile domeniului %1',
    'dalias__list_legend' => 'Aliasuri de domeniu',
    'dalias__list_header' => 'Aliasuri de domeniu',
    'dalias__list_status' => 'S',
    'dalias__list_name' => 'Denumire alias de domeniu',
    'dalias__list_ascii_name' => 'În format ASCII',
    'dalias__remove_title' => 'Următoarele aliasuri ale domeniului %1 vor fi șterse:',
    'dalias__select_domain_aliases_to_remove' => 'Selectați aliasurile de șters.',
    'dalias__mail_turn_on_failed' => 'Imposibil de activat serviciul de e-mail: %1',
    'dalias__web_turn_on_failed' => 'Imposibil de activat serviciul web: %1',
    'db_usr_edit__db_usr_name_old' => "Nume vechi de utilizator de bază de date",
    'database_server_edit_form__cannot_infer_type' => 'Datele furnizate nu permit determinarea metodei de conectare. Specificați „127.0.0.1” drept nume de gazdă al serverului de baze de date pentru a realiza conexiunea prin TCP/IP la portul specificat sau lăsați câmpul Port necompletat pentru a folosi socketul Unix „%1”.',
    'database_server_edit_form__duplicate' => 'Deja este înregistrat un server de baze de date cu această combinație de adresă de gazdă și număr de port.',
    'database_server_edit_form__host_is_invalid' => 'Numele de gazdă specificat este incorect.',
    'database_server_edit_form__port_is_invalid' => 'Numărul de port specificat este incorect.',
    'database_server_error__consult_admin' => 'Contactați administratorul de server.',
    'database_server_error__last__connection_failed' => 'Ultima încercare de a controla acest server de baze de date nu a reușit din cauza unor probleme cu rețeaua.',
    'database_server_error__last__permission_denied' => 'Ultima încercare de a controla acest server de baze de date nu a reușit, deoarece contul specificat nu are privilegii administrative.',
    'database_server_error__last__credentials_not_set' => "Ultima încercare de conectare la acest server nu a reușit pentru că nu s-au specificat corect numele de utilizator și parola administratorului.",
    'database_server_error__last__other_error' => 'Ultima încercare de a controla acest server de baze de date nu a reușit.',
    'database_server_error__real__connection_failed' => 'Conectarea la serverul de baze de date nu a reușit din cauza unor probleme cu rețeaua:',
    'database_server_error__real__permission_denied' => 'Conectarea la serverul de baze de date nu a reușit, deoarece contul specificat nu are privilegii administrative:',
    'database_server_error__real__duplicate_object' => 'Conectarea la serverul de baze de date nu a reușit din cauza unui conflict de denumiri:',
    'database_server_error__real__unacceptable_name' => 'Conectarea la serverul de baze de date nu a reușit din cauza unei denumiri de obiect incorecte:',
    'database_server_error__real__unacceptable_password' => 'Conectarea la serverul de baze de date nu a reușit din cauza unei parole care nu a putut fi acceptată:',
    'database_server_error__real__credentials_not_set' => "Plesk nu se poate conecta la serverul de baze de date pentru că nu s-au specificat corect numele de utilizator și parola administratorului.",
    'database_server_error__real__other_error' => 'Conectarea la serverul de baze de date nu a reușit:',
    'database_server_error__test__connection_failed' => 'Conectarea de test la serverul de baze de date nu a reușit din cauza unor probleme cu rețeaua:',
    'database_server_error__test__permission_denied' => 'Conectarea de test la serverul de baze de date nu a reușit, deoarece contul specificat nu are privilegii administrative:',
    'database_server_error__test__duplicate_object' => 'Conectarea de test la serverul de baze de date nu a reușit din cauza unui conflict de denumiri:',
    'database_server_error__test__unacceptable_name' => 'Conectarea de test la serverul de baze de date nu a reușit din cauza unei denumiri de obiect incorecte:',
    'database_server_error__test__unacceptable_password' => 'Conectarea de test la serverul de baze de date nu a reușit din cauza unei parole care nu a putut fi acceptată:',
    'database_server_error__test__credentials_not_set' => "Conectarea de test la acest server nu a reușit pentru că nu s-au specificat corect numele de utilizator și parola administratorului.",
    'database_server_error__test__other_error' => 'Conectarea de test la serverul de baze de date nu a reușit:',

    'db__create_new_db' => "Adăugare bază de date",
    'db__db_add' => "Adăugare bază de date",
    'db__db_for_dom' => "Bazele de date ale site-ului web %1",
    'db__db_id_undefined' => "ID-ul de bază de date nu este definit.",
    'db__db_name' => "Nume bază de date",
    'db__db_not_exist' => "Baza de date nu există.",
    'db__db_type' => "Tip",
    'db__db_server' => "Server de baze de date",
    'db_server_not_exist' => "Serverul de baze de date nu există.",
    'db__db_user_not_exist' => "Utilizatorul de bază de date nu există.",
    'db__domain_not_exist' => "Domeniul nu există.",
    'db__enter_db_name' => "Introduceți numele noii baze de date.",
    'db__invalid_db_id' => "Identificatorul de bază de date este incorect.",
    'db__invalid_db_name' => "Numele bazei de date este incorect. Numele bazei de date poate conține doar caractere ale alfabetului latin, cifre, caractere de subliniere și cratime. Nu poate depăși lungimea de 63 de caractere.",
    'db__max_db_reached_for_dom' => "S-a atins numărul limită de baze de date în acest domeniu.",
    'db__max_mssql_db_reached_for_dom' => "S-a atins numărul limită de baze de date Microsoft SQL Server în acest domeniu",
    'db__postgres_not_connect_for_admin' => "Imposibil de conectat la PostgreSQL. Activați suportul PostgreSQL în pagina de administrare a serverului.",
    'db__postgres_not_connect_for_client' => "Imposibil de conectat la PostgreSQL. Adresați-vă administratorului de sistem pentru ajutor.",
    'db__remove_db_on_domain' => "Următoarele baze de date ale site-ului %2, deținut de clientul %1, vor fi șterse:",
    'db__remove_db_on_domain_of_cl' => "Următoarele baze de date din domeniul %2, deținut de clientul %1, vor fi șterse:",
    'db__remove_db_linked_resource' => 'Această bază de date este utilizată de o aplicație web. Poate fi ștearsă numai după dezinstalarea aplicației.',
    'db__remove_db_users' => "Următorii utilizatori ai bazei de date %3 a site-ului %2, deținut de clientul %1, vor fi șterși:",
    'db__remove_db_users_of_cl' => "Următorii utilizatori ai bazei de date %3 a site-ului %2, deținut de clientul %1, vor fi șterși:",
    'db__select_db_for_remove' => "Selectați bazele de date ce vor fi șterse.",
    'db__select_db_users_for_remove' => "Selectați utilizatorii de bază de date care vor fi șterși.",
    'db__unable_create_db_user' => "Imposibil de creat utilizatorul de bază de date: %1",
    'db__unable_define_db_name' => "Imposibil de definit numele bazei de date: %1",
    'db__unable_define_db_user' => "Imposibil de definit utilizatorul de bază de date: %1",
    'db__unable_define_db_users' => "Imposibil de definit utilizatorii de bază de date: %1",
    'db__unable_select_dom_name' => "Imposibil de selectat numele de domeniu: %1",
    'db_edit__db_for_dom' => "Utilizatorii bazei de date %1 din domeniul %2",
    'db_edit__invalid_db_name' => "Numele bazei de date este incorect.",
    'db_edit__no_users' => "Nu există utilizatori cu acreditări pentru această bază de date.",
    'db_edit__unable_define_db_usrs' => "Imposibil de definit utilizatorii bazei de date: %1",
    'db_edit__unable_select_db_usr' => "Imposibil de selectat utilizatorul de bază de date.",
    'db_edit__db_user_password_for_' => "Tastați parola pentru a vă conecta ca utilizatorul de bază de date %1",
    'db_list__tab_title_db_type' => "T",
    'db_usr_edit__add_db_usr' => "Adăugare utilizator de bază de date",
    'db_usr_edit__db_usr_name' => "Nume utilizator bază de date",
    'db_usr_edit__edit_db_usr' => "Configurare acreditări pentru contul de utilizator de bază de date",
    'db_usr_edit__for_db' => "în baza de date %1",
    'db_usr_edit__not_create_pass' => "Această operație va duce la crearea unui cont de utilizator de bază de date fără parolă. Creați utilizatorul fără să-i alocați o parolă?",
    'dbuser__only_one_user_can_be_default' => "Un singur utilizator poate fi setat drept implicit.",
    'db_server__cannot_delete_default' => "Serverul de baze de date implicit nu se poate șterge.",
    'db_server__cannot_delete_local' => "Serverul de baze de date local nu se poate șterge.",
    'db_server__cannot_delete_used' => 'Un server de baze de date nu se poate șterge cât timp găzduiește baze de date sau utilizatori de baze de date.',
    'demo__disabled_in_demo' => "Această operație nu este permisă în versiunea demo.",
    'defaultcomponents__title' => "Selectarea componentelor implicite",
    'defaultcomponents__select_default' => "Selectați componente %1 implicită",//to check
    'defaultcomponents__not_installed' => "(neinstalat)",
    'defaultcomponents__not_configured' => "(neconfigurată)", // to check
    'defaultcomponents__not_opted_to_install_support_files' => "Unele categorii de servicii conține selecții incorecte sau nu au nicio selecție.",
    'defaultcomponents__depends_on' => "(necesar %1)",
    'defaultcomponents__parameters' => "Parametrii pentru %1",
    'component_name__antivirus' => "Antivirus",
    'component_name__database' => "SQL Server",
    'component_name__sqladmin' => "MySQL Webadmin",
    'component_name__sqladminmysql' => "MySQL Webadmin",
    'component_name__dnsserver' => "Server DNS",
    'component_name__firewall' => "Firewall",
    'component_name__ftpserver' => "Server FTP",
    'component_name__java' => "Java",
    'component_name__mailserver' => "Server e-mail",
    'component_name__local_mailserver' => "Server de e-mail local",
    'component_name__psa' => "Plesk",
    'component_name__script' => "Scripturi Web",
    'component_name__spamfilter' => "Filtru antispam",
    'component_name__stats' => "Statistici web",
    'component_name__stunnel' => "Wrapper SSL/TLS",
    'component_name__webmail' => "Webmail",
    'component_name__webpublish' => "Publicarea pe web",
    'component_name__webserver' => "Server web",
    'dns__dns_record_invalid_values' => 'Au fost specificate valori de înregistrare DNS incorecte: %1: %2',
    'dns__dns_record_not_found' => 'Înregistrare DNS negăsită',
    'dns__dns_zone_invalid_values' => 'Au fost specificați parametri de zonă DNS incorecți.',

    'dns__soa_mname_title' => 'Server de nume principal',
    'dns__soa_mname_legend' => 'Server de nume',
    'dns__soa_mname_autoselect' => '(Selectare automată)',

    'dns__dns_zone_default' => 'Valori implicite zone',
    'dns__dns_soa_legend' => 'Înregistrare SOA',
    'dns__dns_soa_ttl' => 'TTL',
    'dns__dns_soa_refresh' => 'Reîmprospătare',
    'dns__dns_soa_retry' => 'Reîncercare',
    'dns__dns_soa_expire' => 'Expirare',
    'dns__dns_soa_minimum' => 'Minimum',
    'dns__dns_soa_ttl_error' => 'Valoarea TTL este incorectă. Trebuie să fie cuprinsă între 1 secundă și 68 de ani.',
    'dns__dns_soa_refresh_error' => 'Valoarea câmpului Reîmprospătare este incorectă. Trebuie să fie cuprinsă între 1 secundă și 68 de ani.',
    'dns__dns_soa_retry_error' => 'Valoarea câmpului Reîncercare este incorectă. Trebuie să fie cuprinsă între 1 secundă și 68 de ani.',
    'dns__dns_soa_expire_error' => 'Valoarea câmpului Expirare este incorectă. Trebuie să fie cuprinsă între 1 secundă și 68 de ani.',
    'dns__dns_soa_minimum_error' => 'Valoarea minimă este incorectă. Trebuie să fie cuprinsă între 1 secundă și 68 de ani.',
    'dns__dns_default_title' => 'Restaurarea zonei DNS',
    'dns__dns_default_legend' => "Opțiuni de restaurare a zonei",
    'dns__dns_default_text' => "Alegeți setările pentru restaurarea zonei DNS, confirmați-le și faceți clic pe OK",
    'dns__dns_default_confirm' => "Confirmați restaurarea zonei DNS",
    'dns__dns_default_confirm_required' => "Confirmați restaurarea zonei DNS",
    'dns__dns_default_invalid_ip_address' => 'Adresă IP incorectă',

    'dns_t__dns_default_title' => 'Restaurarea șablonului implicit de zonă DNS',
    'dns_t__dns_default_legend' => "Opțiuni de restaurare",
    'dns_t__dns_default_text' => 'Confirmați restaurarea configurației implicite a șablonului de zonă DNS.',
    'dns_t__dns_default_confirm' => "Confirmare restaurare",
    'dns_t__dns_default_confirm_required' => "Confirmați restaurarea șablonului de zonă DNS",
    'dns_t__add_dns_record_master_title' => 'Adăugare înregistrare de resursă la șablonul de zonă',
    'dns_t__add_dns_record_off_title' => 'Adăugare server de nume',
    'dns_t__edit_dns_record_master_title' => 'Editare înregistrare resursă',
    'dns_t__edit_dns_record_off_title' => 'Editare server de nume',
    'dns_t__edit_dns_record_ttl' => 'TTL',

    'dns__dns_zone_off_remove_title' => "Următoarele resurse vor fi șterse din zona %1:",
    'dns__dns_zone_master_remove_title' => "Ștergerea înregistrărilor de resurse din zona DNS %1",
    'dns__dns_zone_slave_remove_title' => "Vor fi șterse următoarele servere de nume principale pentru  %1:",
    'dns_add__param_ttl' => "TTL",
    'dns_add__enter_spf' => 'Introduceți șirul de înregistrare',
    'dns_add__is_spf_syntax' => 'Înregistrare SPF',
    'dns_add__spf_value_is_invalid' => "Valoarea înregistrării SPF este incorectă, trebuie să înceapă cu „v=spf”",
    'dns__dns_zone_status' => "Starea zonei DNS.",
    'dns__dns_zone_template' => 'Setări DNS',
    'dns__host' => "Gazdă",
    'dns__ttl' => "TTL",
    'dns__invalid_ip_address' => "Adresa IP a noului server DNS principal este incorectă sau necompletată.",
    'dns__ip_address' => "Adresă IP",
    'dns__master_dns_type' => "este server DNS principal",
    'dns__masters' => "Servere DNS principale",
    'dns__soa_minimum_too_large' => 'Nu se recomandă păstrarea în cache a răspunsurilor negative timp de peste trei ore.',
    'dns__select_masters_to_remove' => "Selectați serverele principale DNS de șters.",
    'dns__select_template_record_to_remove' => 'Selectați înregistrările șablon DNS de șters.',
    'dns__nameservers_for_domain' => "Servere de nume pentru domeniu",
    'dns__ns' => "Server de nume",
    'dns__ns_record' => "Servere de nume",
    'dns__remove_dns_zone_of_domain__' => "Ștergerea înregistrărilor DNS din domeniul %1",
    'dns__remove_dns_zone_template__' => "Următoarele înregistrări DNS vor fi șterse din șablon:",
    'dns__remove_this_dns_record?' => "Sigur ștergeți această înregistrare DNS?",
    'dns__restore_default' => "Restaurare zonei DNS prin utilizarea șablonului",
    'dns__restore_default_confirm' => "Revenirea la o zonă DNS anterioară va duce la ștergerea configurării actuale a zonei DNS. Continuați?",
    'dns__restore_default_error' => "Eroare la restaurarea zonei DNS:",
    'dns__slave_dns_type' => "este server DNS secundar",
    'dns__soa_refresh_value_is_small' => 'Intervalul de reîmprospătare este sub o oră, ceea ce poate duce la o creștere critică a traficului serverului și a utilizării resurselor. Continuați cu această valoare?',
    'dns__subdomain_dns_rec_removed' => "Înregistrarea A a fost ștearsă din zona de subdomeniu %1.",
    'dns__zone_switched_off_no_ns' => "Zona a fost dezactivată deoarece nu există nicio înregistrare NS %1, care trebuie să fie prezentă în zonă. Pentru a adăuga înregistrarea la zonă, faceți clic pe butonul Adăugare înregistrare.",
    'dns__cant_switch_on_no_ns' => "Zona nu poate fi activată pentru că nu există nicio înregistrare NS %1, care trebuie să fie prezentă în zonă. Pentru a adăuga înregistrarea la zonă, faceți clic pe butonul Adăugare înregistrare.",
    'dns__type' => "Tip înregistrare",
    'dns__unable_activate/deactivate_dns' => "Imposibil de activat/dezactivat DNS: %1",
    'dns__unable_add_dns_master_duplicate_entry' => "Imposibil de adăugat serverul DNS principal: înregistrare dublată.",
    'dns__unable_add_dns_master_local_ip' => "Imposibil de adăugat adresa IP a serverului DNS principal: această înregistrare trebuie creată pe serverul la distanță.",
    'dns__unable_define_dns_record' => "Imposibil de definit înregistrarea DNS: %1",
    'dns__unable_get_dns_template_status' => "Imposibil de obținut starea șablonului DNS.",
    'dns__unable_remove_dns_rec' => "Imposibil de șters înregistrare DNS: %1",
    'dns__val' => "Valoare",
    'dns__warnings__' => "Rezultatul modificării zonei DNS:",
    'dns__you_not_have_perm_manage_dns' => "Nu aveți permisiunea de a administra zona DNS pentru acest domeniu.",
    'dns__zone_record' => "Înregistrări DNS",
    'dns__cant_create_record_with_server_ip' => "Imposibil de adăugat această adresă IP pentru că se potrivește cu adresa IP a acestui server administrat de Plesk.",

    'dns__tabs_acl' => "Transferuri de zone",
    'dns__acl_add_network_legend' => "Adăugare rețea",
    'dns__acl_add_ip_legend' => "Adăugare adresă IP",
    'dns__acl_network_not_allowed' => "Această adresă de rețea nu este permisă de DNS din Windows.",
    'dns__acl_enter_ip_address_with_mask' => "Adresă IP/mască",
    'dns__acl_enter_ip_address' => "Adresă IP",
    'dns__acl_list_network_legend' => "Rețele care pot obține o copie a zonei DNS",
    'dns__acl_list_ip_legend' => "Adrese IP care pot obține o copie a zonei DNS",
    'bt_dns_acl_add_network' => "Adăugare rețea",
    'bt_dns_acl_add_ip' => "Adăugare adresă IP",

    'dns_add__add_rec_for_zone' => "Adăugare %1 pentru zona %2",
    'dns_add__canonical_dom_name_is_invalid' => "Numele canonic al domeniului este incorect.",
    'dns_add__enter_canonical_name' => "Nume canonic",
    'dns_add__enter_dom_name' => "Nume domeniu",
    'dns_add__enter_ip_address' => "Adresă IP",
    'dns_add__enter_ip_mask' => "Adresă IP și mască de rețea",
    'dns_add__enter_mail_domain' => "Domeniu de e-mail",
    'dns_add__enter_mail_exchanger' => "Server de schimb de e-mailuri",
    'dns_add__enter_nameserver' => "Server de nume",
    'dns_add__enter_txt_record' => "Înregistrare TXT",
    'dns_add__enter_service_name' => "Nume serviciu",
    'dns_add__hint_service_name' => "Exemplu: SIP (fără caracter de subliniere)",
    'dns_add__enter_protocol' => "Protocol",
    'dns_add__hint_protocol_name' => "Exemplu: TCP (fără caracter de subliniere)",
    'dns_add__protocol_tcp' => "TCP",
    'dns_add__protocol_udp' => "UDP",
    'dns_add__enter_srv_priority' => "Nivel de prioritate",
    'dns_add__specify_weight_of_service' => "Ponderea relativă a înregistrărilor cu aceeași prioritate",
    'dns_add__enter_target_host' => "Gazda de destinație",
    'dns_add__hint_target_host' => "Exemplu: exemplu.com",
    'dns_add__enter_target_port' => "Port de destinație",
    'dns_add__caa_tag' => "Etichetă",
    'dns_add__caa_value' => "Valoare",
    'dns_add-invalid-A_ip' => "Adresa IP este incorectă.",
    'dns_add-invalid-AAAA_ip' => "Adresa IP este incorectă.",
    'dns_add-invalid-PTR_ip_mask' => "Pereche adresă IP/mască de rețea incorectă.",
    'dns_add-invalid-SRV_service_name' => "Nume de serviciu incorect",
    'dns_add-invalid-SRV_protocol_name' => "Protocol incorect",
    'dns_add-invalid-SRV_target_port' => "Port destinație incorect",

    'dns_add__invalid_ip' => "Adresa IP este incorectă.",
    'dns_add__low' => "scăzut",
    'dns_add__mail_dom_name_is_invalid' => "Numele de domeniu e-mail este incorect.",
    'dns_add__nameserver_is_invalid' => "Serverul de nume este incorect.",
    'dns_add__record' => "%1 înregistrare",
    'dns_add__select_prefer_for_mail_exchange_server' => "Specificați prioritatea serverului de schimb de e-mailuri",
    'dns_add__unable_insert_new_dns_rec' => "Imposibil de inserat noua înregistrare DNS: %1",
    'dns_add__very_high' => "foarte ridicat",
    'dom_ctrl__allowed' => "Permis",
    'dom_ctrl__db' => "Baze de date MySQL",
    'dom_ctrl__mssql_db' => "Baze de date MS SQL",
    'dom_ctrl__disk_space' => "Spațiu pe disc",
    'dom_ctrl__dom_adm' => "Domeniul %1 din %2",
    'dom_ctrl__dom_cl' => "Domeniul %1",
    'dom_ctrl__domain_has_forwarding_with_undefined_fwd_url' => "Domeniul are setată redirecționarea cu un URL de redirecționare nedefinit",
    'dom_ctrl__domain_has_frame_forwarding' => "Domeniul are redirecționare cu cadre către URL-ul %1",
    'dom_ctrl__domain_has_no_hosting' => "Domeniul nu are găzduirea configurată",
    'dom_ctrl__domain_has_physical_hosting' => "Găzduirea web este configurată pentru acest domeniu la adresa IP %1",
    'dom_ctrl__domain_has_standard_forwarding' => "Domeniul are redirecționare standard către URL-ul %1",
    'dom_ctrl__maillists' => "Liste de e-mail",
    'dom_ctrl__mboxes' => "Căsuțe poștale",
    'dom_ctrl__mg' => "Redirecționări de e-mailuri",
    'dom_ctrl__resource_name' => "Resursă",
    'dom_ctrl__resp' => "Răspunsuri automate",
    'dom_ctrl__subdom' => "Subdomenii",
    'dom_ctrl__dom_aliases' => "Aliasuri de domeniu",
    'dom_ctrl__traffic' => "Trafic",
    'dom_ctrl__unable_activate/deactivate_dom' => "Imposibil de activat/dezactivat domeniul: %1",
    'dom_ctrl__used' => "Utilizat",
    // end of serge part

    // maverick part
    'dom_ctrl__wu' => "Utilizatori web",
    'dom_pref__bounce_with_phrase' => "Se refuză cu mesaj",
    'dom_pref__bounce' => "Se refuză",
    'dom_pref__catch_addr' => "Se redirecționează la adresa",
    'dom_pref__reject' => 'Refuzare',
    'dom_pref__confirm_domain_removing' => "Nu uitați să informați utilizatorii domeniului în legătură cu schimbarea numelui acestuia. Sigur schimbați numele domeniului?",
    'dom_pref__db_inconsystency' => "inconsistență în baza de date.",
    'dom_pref__dbs' => "bazele de date",
    'dom_pref__delete_traffic_stat' => "Păstrare date statistice despre web și trafic",
    'dom_pref__delete_traffic_stat_older' => "Păstrare date statistice despre web și trafic",
    'dom_pref__dom_level_name_conflict' => "Numele de utilizator al administratorului de domeniu intră în conflict cu numele utilizator de unuia dintre clienți.",
    'dom_pref__invalid_disk_space_limit' => "Limita spațiului pe disc este incorectă. Valoare maximă: %1",
    'dom_pref__invalid_expiration_date_limit' => "Perioadă de valabilitate incorectă.",
    'dom_pref__invalid_max_traffic_limit' => "Limită de trafic incorectă. Valoare maximă: %1",
    'dom_pref__limits_of_dom' => "Limite pentru domeniul %1",
    'dom_pref__mail_grps' => "grupuri de e-mail",
    'dom_pref__mail_nonexistent_user' => "Ce se întâmplă cu mesajele trimise unor utilizator inexistenți",
    'dom_pref__mail_redirs' => "redirecționări de e-mail",
    'dom_pref__mail_resps' => "răspunsuri automate la e-mailuri",
    'dom_pref__max_limit_is_invalid' => "%1 este incorect.",
    'dom_pref__max_num_of_%objects_is_invalid' => "Numărul maxim de %1 este incorect.",
    'dom_pref__new_limit_less_currently_used' => "%1: solicitat - %2, în uz - %3",
    'dom_pref__older_that' => "pentru",
    'dom_pref__postboxes' => "căsuțe poștale",
    'dom_pref__preferences_of_dom' => "Setări pentru domeniul %1",
    'dom_pref__redirect_to_itself' => "Domeniul va avea redirecționarea setată către același domeniu",
    'dom_pref__traffic_logging_period_couldnt_be_lower' => "Ați specificat ca timpul de păstrare a statisticilor de trafic în domeniu să fie mai mic decât valoarea totală definită pentru server (%1 luni). Perioada de păstrare a statisticilor este setată astfel încât să fie egală cu valoarea implicită pentru server (%1 luni).",
    'dom_pref__unable_add_www_prefix_in_dom' => "Imposibil de adăugat prefixul www pentru domeniul: %1",
    'dom_pref__unable_define_physical_hst_param' => "Imposibil de definit parametrii de găzduire fizică: %1",
    'dom_pref__unable_rename_domain' => "Imposibil de redenumit domeniul %1: %2",
    'dom_pref__unable_set_up_mbox_quota' => "Imposibil de setat cota de căsuță poștală pentru domeniul: %1",
    'dom_pref__unable_set_up_web_user_script' => "Imposibil de configurat scripturile pentru utilizatorii web: %1",
    'dom_pref__unlimited' => "Nelimitat",
    'dom_pref__web_usrs' => "utilizatori web",
    'dom_pref__you_already_have_%object' => "Aveți deja %1",
    'cu_domain__error_unable_update_ftp_users' => 'Imposibil de actualizat utilizatorii FTP din domeniu: %1',
    'dom_cli__warning_ignore_quota' => 'AVERTISMENT: Opțiunea „-hard_quota” e ignorată: cota de hard disc nu este acceptată',
    'dom_user_client_login_exist' => "Imposibil de permis accesul de administrator de domeniu la Plesk în domeniul %1: acest nume de utilizator este deja în uz.",
    'domain__unable_to_turn_on_service' => "Activarea serviciului %1 nu a reușit.",
    'domains__change_the_status_of_domain?' => "Sigur schimbați starea domeniului %1?",
    'domains__client_info_hiding_traffic' => "%1 domenii, %2 domenii active, %3 spațiu pe disc utilizat",
    'domains__unable_to_change_client_status' => "Imposibil de schimbat starea contului de client: %1",
    'domains__unable_update_apache_settings' => "Imposibil de actualizat setările Apache.",
    'domains__you_do_not_have_permissions_to_delete_domains' => "Nu aveți permisiunea de a șterge domenii.",
    'domains__you_want_change_the_status_of_the_cl??' => "Sigur schimbați starea contului de client?",
    'domains__you_want_change_the_cp_access_of_the_cl??' => "Sigur efectuați această operație?",
    'domains_list__unable_remove_doms' => "Imposibil de șters domeniile: %1",
    'domaintrafficlist_header_of_domain__' => "Trafic în domeniul %1",

    'domain_aliases_remove__select_domain_aliases_for_remove' => 'Selectați aliasurile de șters.',
    'domain_aliases_remove__title' => 'Ștergerea aliasurilor de domeniu',
    'domain_aliases__max_aliases_reached_for_dom' => "S-a atins numărul limită de aliasuri în acest domeniu.",
    'domain_edit__edit_title' => 'Editare denumire alias de domeniu',
    'domain_alias_edit__type' => 'Tip alias de domeniu',
    'domain_aliases__list_header' => 'Aliasuri de domeniu',
    'domain_aliases__name' => 'Nume',
    'domain_aliases__type' => 'Tip',
    'domain_aliases__type_full' => 'Web+FTP+E-mail',
    'domain_aliases__type_web_ftp' => 'Web+FTP',
    'domain_aliases__page_title' => 'Aliasuri de domeniu',
    'domain_aliases__legend' => 'Aliasuri de domeniu',
    'domain_alias__domain_exists' => 'Deja există un domeniu cu acest nume',
    'domain_alias__subdomain_exists' => 'Deja există un subdomeniu cu acest nume',
    'domain_alias__dns_record_exists' => 'Deja există o înregistrare DNS cu numele de alias de domeniu specificat',
    'domain_alias__domain_alias_exists' => "Deja există un alias de domeniu cu acest nume",
    'domain_alias__invalid_type_full' => 'Serverul de e-mail nu acceptă aliasurile de domeniu',
    'domain_alias__redirect_exists' => 'S-a detectat o redirecționare către propria adresă.',

    'ds__anonymous_ftp' => "FTP anonim",
    'drweb__pagetitle' => 'Setări antivirus',
    'drweb__drweb' => 'Verificare antivirus a e-mailurilor',
    'drweb__drweb_direction' => 'Verificarea antivirus a e-mailurilor',
    'drweb__drweb_direction_off' => 'Nu se face verificare antivirus',
    'drweb__drweb_direction_any' => 'E-mailuri primite și trimise',
    'drweb__drweb_direction_from' => 'Doar e-mailuri trimise',
    'drweb__drweb_direction_to' => 'Doar e-mailuri primite',
    'drweb__disable_reason_key' => 'Antivirusul nu este acceptat de cheia de licență.',
    'drweb__disable_reason_perm' => 'Nu aveți permisiunea de a administra antivirusul.',
    'drweb__disable_reason_install' => 'Antivirusul nu este instalat.',
    'drweb__filters' => 'Filtre antivirus',
    'ds__dns' => "Zonă DNS",
    'ds__mail' => "E-mail",
    'dsr__of_client_title' => "Raport rezumat pentru domeniul %1",
    'dsr__report_has_been_sent_email' => "Raportul a fost trimis prin e-mail: %1",
    'dsr__title' => "Raport rezumat pentru domeniu",
    'dumps_list__deletion_page_title' => "Următoarele fișiere copie de rezervă ale domeniului %1 vor fi șterse:",
    'dumps_list__dumpfile_is_invalid' => "%1 nu este un fișier corect cu copie de rezervă a domeniului.",
    'dumps_list__page_title' => "Spațiul de stocare a fișierelor copie de rezervă",
    'dumps_upload__page_title' => "Încărcarea fișierelor copie de rezervă în spațiul de stocare",
    'dumps_list__repository_is_not_exist' => "Spațiul de stocare de fișiere copie de rezervă nu există.",
    'dumps_list__unable_to_remove' => "Imposibil de șters fișierul copie de rezervă: %1",
    'dumps_list__dumpfile_can_conflict' => "Numele de fișier specificată intră în conflict cu fișierul %1. Specificați un alt nume de fișier.",
    'dusr_ed__allow_dl_usr_access' => "Permiteți accesul administratorului domeniului",
    'dusr_ed__information' => "Proprietățile administratorului domeniului %1",
    'dusr_ed__locale' => "Limba administratorului de domeniu",
    'dusr_ed__skin' => "Prezentarea de interfață a administratorului de domeniu",
    'dusr_ed__personal_information' => 'Informații personale',
    'ess__error' => "Eroare",
    'example__' => "Exemplu: %1",
    'extras__allow_certificate_purchasing' => "Se permite cumpărarea de certificate",
    'extras__allow_domain_registration' => "Se permite înregistrarea de domenii",
    'extras__allow_extras' => "Se permit serviciile suplimentare",
    'extras__buy_new_key' => "Licența actuală nu vă permite să modificați aceste obiecte.",
    'extras__setup_services' => "Configurarea serviciilor suplimentare",

    'ruleeditform__error' => 'Imposibil de actualizat regula de firewall.',
    'ruleeditform__name_is_required' => 'Specificați numele regulii',
    'ruleeditform__profiles_is_required' => 'Selectați cel puțin un profil.',
    'ruleeditform__invalid_ip' => 'Adresa IP sau rețeaua specificată este incorectă.',
    'ruleeditform__invalid_port' => 'Portul specificat este incorect. Valorile posibile sunt 1000 sau 1000-1051',

    'filemanager__items' => 'elemente în directorul %1',
    'filemanager__items_paging' => 'elemente în directorul %1',

    'get_password__encrypted_password' => "Nu se poate trimite parola: parola se stochează în formă criptată.",
    'get_password__mail_error' => "Eroare la încercarea de a trimite parola la adresa de e-mail %1: %2",
    'get_password__mail_ok' => "Parola a fost trimisă prin e-mail: %1",
    'get_password__message' => "Numele de utilizator pentru accesarea sistemului. %1 Parola este %2",
    'get_password__subject' => "Parolă pentru accesul la sistem",
    'groups__available' => "Grupuri de e-mail disponibile",
    'groups__groups_for_mailname' => "Grupuri de e-mail la care este abonat contul de e-mail %1",
    'groups__member_of' => "Membru al următoarelor grupuri de e-mail",
    'help__help_area' => "Zona Ajutor.",
    'hst_def__auth_disabled' => "interzis",
    'hst_def__auth_enabled' => "permis",
    'hst_def__change_curr_dns_ip' => "Adresa IP actuală a înregistrării DNS de tip A va fi schimbată",
    'hst_def__cr_hosting_ip_dns_ip_not_equiv' => "Niciuna dintre adresele IP ale înregistrării DNS de tip A nu se potrivește cu adresa IP alocată contului de găzduire în curs de creare",
    'hst_def__dest_url' => "URL destinație",
    'hst_def__disk_quota' => "Cotă de disc",
    'hst_def__disk_space_limit_exceed_incoming_quota' => "Limita de spațiu pe disc pe care încercați să o setați este depășită de limita de spațiu pe disc din directorul de primire utilizat pentru FTP anonim. Limita de spațiu pe disc din directorul de primire utilizat pentru FTP anonim nu trebuie să depășească limita de spațiu pe disc a domeniului.",
    'hst_def__frame_forwarding_definition' => "Alocarea redirecționării cu cadre pentru domeniul %1",
    'hst_def__ftpuser_for_hst_not_exist_in_system' => "Avertisment: Utilizatorul FTP %1 este folosit în setările contului de găzduire, dar nu există în sistem.",
    'hst_def__hst_type_is_not_defined' => "Tipul de găzduire nu este definit",
    'hst_def__ip_based' => "Pe bază de IP",
    'hst_def__name_based_power_anonymous_ftp_down' => "Dacă transferați acest cont de găzduire la o adresă IP partajată, serviciul FTP anonim se va dezactivat pentru acest domeniu. Continuați?",
    'hst_def__password_is_invalid_password_syntax' => "Parola este incorectă. Nu folosiți apostrofuri și diacritice în parolă. Lungimea parolei trebuie să fie cuprinsă între 5 și 14 caractere. Parola nu poate conține numele utilizatorului.",
    'hst_def__shell' => "Acces prin SSH la shellul de pe server pentru utilizatorul de sistem al abonamentului",
    'hst_def__shell_windows' => "Acces prin desktop la distanță la server pentru utilizatorul de sistem al abonamentului",
    'hst_def__standard_forwarding_definition' => "Alocare redirecționare standard pentru domeniul %1",
    'hst_def__title_name_based' => "Pe bază de nume",
    'hst_def__unable_create/update_physic_hst' => "Imposibil de creat/actualizat găzduirea fizică: %1",
    'hst_def__unable_create/update_std_fwd' => "Imposibil de creat/actualizat redirecționarea standard: %1",
    'hst_def__unable_create_forwarding_myself' => "Imposibil de creat redirecționarea către același domeniu.",
    'hst_def__unable_turn_same_ssl_while_ssl_off' => "Imposibil de permis utilizarea aceluiași director pentru stocarea conținutului SSL/TLS și non-SSL/TLS: suportul SSL/TLS nu este activat.",
    'hst_def__unable_turn_on_ssl_cert_not_defined' => "Imposibil de activat suportul SSL/TLS: nu este instalat niciun certificat SSL/TLS.",
    'hst_def__url_is_invalid' => "URL-ul este incorect.",
    'hst_def__virtual_host_access' => "Acces de gazdă virtuală pentru domeniul %1",
    'hst_def__virtual_host_uses_non_existed_ip_address' => "AVERTISMENT. Această gazdă virtuală folosește o adresă IP inexistentă pentru găzduire.",
    'hst_def__you_have_no_ips' => "Nu aveți adrese IP disponibile și nu aveți drepturile necesare pentru a crea găzduire pe bază de nume.",
    'hst_sel__header' => "Pentru a găzdui un site web pe acest server, selectați opțiunea Găzduire fizică. Pentru a configura redirecționarea de domeniu către un site de pe un alt computer, selectați opțiunea Redirecționare de cadre sau Redirecționare standard. În cazul redirecționării standard, utilizatorul este redirecționat la site, iar URL-ul efectiv al acestuia apare în browser, astfel încât utilizatorul află de redirecționare. În cazul redirecționării de cadre, utilizatorul este redirecționat către site fără a afla că acesta se află de fapt într-o altă locație.",
    'hst_sel__physical_hst' => "Găzduire fizică",
    'hst_sel__select_hst_type' => "Selectați tipul găzduirii pentru domeniu",
    'hst_sel__select_hst_type_warning' => "Selectați tipul găzduirii pentru domeniu",
    'hst_sel__hosting_exists' => "Imposibil de creat găzduirea, pentru că este deja configurată pentru domeniu. Veți fi redirecționat la pagina de administrare a găzduirii.",
    'hst_sel__standard_frw' => "Redirecționare standard",
    'hst_sel__frame_frw' => "Redirecționare cu cadre",
    '__frame_frw' => "Redirecționare cu cadre",
    '__hosting_exists' => "Imposibil de creat găzduirea, pentru că este deja configurată pentru domeniu. Veți fi redirecționat la pagina de administrare a găzduirii.",
    '__choose_hst_type' => "Selectați tipul de găzduire potrivit.",
    '__no_hst_conf' => "Nu există găzduire configurată pentru domeniu.",
    '__physical_hst' => "Găzduire fizică",
    '__select_hst_type' => "Selectați tipul găzduirii pentru domeniu",
    '__standard_frw' => "Redirecționare standard",
    '__warning' => "Avertisment! Toți parametrii setați anterior vor fi înlăturați. Sigur schimbați tipul de găzduire?",
    'i_cl_off' => "Clientul este inactiv.",
    'i_cl_off_by_admin' => "Contul de client este suspendat de către administratorul de server.",
    'i_cl_off_expired' => "Contul client este expirat.",
    'i_cl_on' => "Clientul este activ.",

    'icf__title' => 'Firewall de conexiune internet',
    'icf__if_legend' => 'Interfețe',
    'icf__mode' => 'Mod',

    'invalid_value' => 'Valoarea este incorectă',

    'ip_addr__already_exists' => "Adresa IP %1 există deja.",
    'ip_addr__cant_add' => "Adresa IP %1 nu există sau aparține domeniului de adrese IP al unui alt client",
    'ip_addr__cl_list_for_ip' => "Resellerii care utilizează adresa IP %1 %2",
    'ip_addr__cl_list_for_ip_add' => "Adăugare adresă IP la domeniul de adrese al resellerului",
    'ip_addr__domains_list_for_ip' => "Site-uri web care utilizează adresa IP %1 %2",
    'ip_addr__ip_used_by_hst_or_frw' => "Adresa IP %1 este utilizată pentru găzduire sau redirecționare.",
    'ip_addr__only_one_ip_and_client_have_domain' => "Această adresă IP nu poate fi ștearsă pentru că există domenii găzduite la această adresă.",
    'ip_addr__remove_ip_addr' => "Următoarele adrese IP vor fi șterse din sistem:",
    'ip_addr__select_clients' => "Selectare clienți",
    'ip_addr__select_ip_addr_to_remove' => "Selectați adresa IP ce urmează să fie ștearsă.",
    'ip_addr__unallowed_by_license' => "Această copie Plesk nu are licență pentru a funcționa la adresa IP %1. Intervalele de adrese IP permise sunt: %2.",
    'ip_alias__interface' => "Interfață",
    'ip_alias__invalid_ip_nm_bsd_vrt_hsts' => "%1 adresa IP pentru găzduirea virtuală pe bază de nume este incorectă.",
    'ip_alias__invalid_ip_or_netmask' => "Pereche adresă IP/mască de rețea incorectă.",
    'ip_alias__orig_ip_can_not_be_deleted' => "%1 este adresa IP originală a serverului, de aceea nu se poate șterge.",
    'ip_alias__ip_is_invalid' => "Adresa IP %1 este incorectă.",
    'ip_alias__ip_mask_is_invalid' => "Masca IP %1 este incorectă.",
    'ip_alias__ip_not_exist' => "Adresa IP %1 nu există.",
    'ip_alias__ip_address_and_mask' => 'Adresă IP și mască de subrețea',
    'ip_alias__mask' => "Mască de subrețea",
    'ip_alias__remove_selected_ip_aliases?' => "Sigur ștergeți adresele IP selectate?",
    'ip_alias__select_ip' => "Selectați cel puțin o adresă IP din listă pentru a o șterge.",
    'ip_alias__this_ip_used_for_domain' => "(%1) această adresă IP este utilizată pentru domeniul %2.",
    'ip_alias__this_ip_used_for_nm_bsd_vrt_hsts' => "(%1) această adresă IP este utilizată pentru gazde virtuale pe bază de nume.",
    'ip_alias__unable_add_ip' => "Imposibil de adăugat adresa IP: %1",
    'ip_alias__unable_remove_ip' => "Imposibil de șters adresa IP: %1",
    'ip_ctrl__anonymous_ftp_exists_in_domain' => "Nu puteți schimba tipul adresei IP în partajat pentru că serviciul FTP anonim va deveni indisponibil pentru domeniul „%1”.",
    'ip_ctrl__ip_addr' => "Adresa IP %2 pe interfața %1",
    'ip_ctrl__ip_exists_many_pools' => "Nu puteți schimba tipul de IP. Adresa IP aparține domeniilor mai multor utilizatori în același timp.",
    'ip_ctrl__ssl_cert' => "Certificat SSL/TLS",
    'ip_pool__ip_address_is_absend_in_pool' => "Adresa IP lipsește.",
    'ip_pool__ip_pool_for_client' => "Domeniul de adrese IP al clientului %1",
    'ip_pool__no_cliens_avail' => "Nu există clienți disponibili.",
    'ip_pool__no_vacant_ips' => "Nu există adrese IP libere.",
    'ip_pool__pool_is_empty' => "Domeniul de adrese IP este gol.",
    'ip_pool__remove_ip_addr' => "Aceste adrese IP vor fi șterse din domeniul %1:",
    'ip_pool__select_free_ips' => "Adrese IP libere",
    'limit__date_in_past' => "Perioada de valabilitate este incorectă. %1 a trecut deja.",
    'limit__enter_date' => "Introduceți data",
    'limit__max_db' => "Baze de date",
    'limit__name_disk_space' => "spațiu pe disc",
    'limit__name_max_box' => "căsuțe poștale",
    'limit__name_max_db' => "Baze de date MySQL",
    'limit__name_max_dom' => "domenii",
    'limit__name_max_maillists' => "liste de e-mail",
    'limit__name_max_subdom' => "subdomenii",
    'limit__name_max_traffic' => "trafic",
    'limit__name_max_wu' => "utilizatori web",
    'limit__name_mbox_quota' => "cotă de căsuță poștală",
    'limit__name_max_mn' => "conturi de e-mail",
    'limit__name_max_cl' => 'clienți',
    'limit__name_total_mboxes_quota' => "cota totală a căsuțelor poștale",
    'limit__name_mysql_dbase_space' => "Spațiu de baze de date MySQL",
    'limit__name_mssql_dbase_space' => "Spațiu de bază de date MSSQL",
    'limit__name_expiration' => 'data expirării',

    'locale_upload__title' => 'Adăugare limbă',
    'locale_upload__file_name' => 'Calea către fișierele pachetului lingvistic',
    'locale_upload__unable_to_install' => 'Imposibil de instalat fișierul de pachet lingvistic',
    'locale_upload__wrong_package' => 'Fișierul încărcat nu conține un pachet lingvistic corect pentru această versiune Plesk.',
    'locale_upload__wrong_locale' => 'Fișierul încărcat nu conține un pachet lingvistic corect.',

    'locales_remove__title' => 'Ștergerea limbilor',
    'locales_remove__select_locales_for_remove' => 'Selectați limbile de șters.',
    'locales__can_not_remove' => 'Imposibil de șters pachetul lingvistic pentru limba %1: %2',

    'ma__create_title' => 'Se creează alias de e-mail pentru %1',
    'ma__edit_title' => "Editarea aliasului de e-mail %1",
    'ma__enter_new_alias' => "Introduceți aliasul nou.",
    'ma__invalid_alias' => "Alias de e-mail incorect.",
    'ma__mail_aliases_mailname' => "Aliasuri pentru contul de e-mail %1",
    'ma__mailname_does_not_exist' => "Contul de e-mail nu există.",
    'ma__select_ma_for_remove' => "Selectați aliasurile de e-mail ce vor fi șterse.",
    'ma__unable_to_add_new_ma' => "Imposibil de adăugat un alias de e-mail: %1",

    'mail_queue__not_allowed_by_license_key' => 'Cheia de licență nu permite administrarea cozilor de e-mail.',
    'maillist__' => "Lista de e-mail %1",
    'maillist__already_exists' => "Lista de e-mail există deja.",
    'maillist__mail_alias_already_exists_in_this_domain' => "Aliasul de e-mail %1 există deja în acest domeniu",
    'maillists__' => "Liste de e-mail %1",
    'maillists__limit_cl_max_maillists' => "Numărul limită de liste de e-mail al clientului a fost atins (limită: %1, utilizat: %2)",
    'maillists__limit_dom_max_maillists' => "Numărul limită de liste de e-mail al domeniului a fost atins.",
    'maillists__list' => "Liste de e-mail",
    'maillists__mailman_not_installed_or_conf' => "Extensiile de server Mailman nu sunt instalate sau nu sunt configurate pe server. Contactați administratorul de server pentru a instala această sau a configura corect Extensiile de server Mailman.",
    'maillists__status' => "Serviciul liste de e-mail este activat",
    'maillists__unable_to_delete__' => "Imposibil de șters lista de e-mail: %1",
    'maillists__disabled_text' => 'Imposibil de administrat listele de e-mail; componenta de server de liste Mailman nu este instalată sau nu este configurată.',
    'maillist_member__already_exists' => 'Abonatul listei de e-mail există deja.',
    'maillist_member__not_exists' => 'Nu există un astfel de utilizator în lista de e-mail.',
    'mailserver_switching_warning' => "Avertisment! Funcția de schimbare a serverului de e-mail server a fost concepută numai pentru configurarea inițială. Dacă serverul este deja în uz, apar următoarele probleme: pierderea setărilor și a conținutului căsuței poștale. Dacă serverul la care treceți este configurat deja, pot apărea diferite conflicte. Dacă în acest moment serverul este în uz și sigur doriți să treceți la un altul, vă puteți anunța clienții în legătură cu modificarea pe care urmează să o faceți, astfel încât să-și poată descărca mesajele și să și le poată salva.",
    'manager__access_denied' => "Acces interzis: %1",
    'manager__admin' => "Administrator",
    'manager__client' => 'Client',
    'manager__domain' => "Domeniu",
    'manager__domain_cl_limit_exceeding' => "S-a atins numărul limită de domenii în acest cont de client.",
    'manager__domain_is_not_yours' => "Domeniul %1 nu vă aparține.",
    'manager__domain_key_limit_exceeding' => "A fost atins numărul limită de creări de domenii, definită prin cheia de licență.",
    'manager__no_perm_to_call' => "Nu aveți permisiunea să apelați %1.",
    'manager__no_perm_to_create_domains' => "Nu aveți permisiunea să creați domenii.",
    'manager__no_perm_to_modify_domain' => "Nu aveți permisiunea să modificați domeniul %1.",
    'manager__no_perm_to_modify_domains' => "Nu aveți permisiunea să modificați domenii.",
    'manager__no_perm_to_remove_domain' => "Nu aveți permisiunea să ștergeți domeniul %1.",
    'manager__no_perm_to_remove_domains' => "Nu aveți permisiunea să ștergeți domenii.",
    'manager__node_doesnt_exist' => "%1 nu există.",
    'manager__user_disabled' => "Contul dvs. este suspendat. Nu puteți utiliza sistemul.",
    'mail_quota_unsupported' => "nu este acceptat de serverul de e-mail",
    'mbox_quota_unsupported' => "nu este acceptat de serverul de e-mail",
    'mn__create_title' => "Creare cont de e-mail",
    'mn__edit_title' => "Setări",
    'mn__files_list_title' => "Fișiere atașate",
    'mn__files_remove' => "Ștergerea fișierelor din depozitul de atașări. Este posibil ca aceste fișiere să fie utilizate în răspunsuri automate. Acestea vor fi șterse atât din depozit, cât și din răspunsurile automate care le utilizează.",
    'mn__files_select_for_remove' => "Selectați fișierele care vor fi șterse.",
    'mn__mail_alias_form' => "Formă alias de e-mail",
    'mn__mail_aliases_list' => "Aliasuri de e-mail",
    'mn__mailbox' => "Administrare căsuță poștală",
    'mn__unable_define_mn' => "Imposibil de configurat conturile de e-mail: %1",
    'mn__unable_remove_mbox_quota' => "Imposibil de eliminat cota de căsuță poștală: %1",
    'mn__upload_file' => "Încărcare fișier",
    'mn_edit__attach_filename_changed' => 'Fișierul încărcat %1 a fost redenumit în %2 pentru că numele original conținea caractere non-ASCII.',
    'mn_edit__add_mail_group_members_or_turn_off_box' => "Pentru a putea activa grupul de e-mail, trebuie să adăugați un membru în acesta.",
    'mn_edit__add_resp_or_turn_off_box' => "Trebuie să adăugați un răspuns automat sau să goliți caseta de selectare corespunzătoare acestei opțiuni.",
    'mn_edit__attachments' => "Atașări",
    'mn_edit__dom_quota_less_then_quota' => "Dimensiunea căsuței poștale nu poate depăși spațiul total pe disc alocat căsuțelor poștale din domeniu.",
    'mn_edit__enter_external_rcpnt_email' => "Introduceți adresa de e-mail a membrului de grup extern",
    'mn_edit__enter_mail_redir_or_turn_off_box' => "Tastați o adresă de redirecționare sau goliți caseta de selectare corespunzătoare acestei opțiuni.",
    'mn_edit__ext_rcpnt_email_invalid' => "Adresa de e-mail a destinatarului extern este incorectă.",
    'mn_edit__file_exists' => "Fișierul există. Suprascrieți?",
    'mn_edit__files_deld_from_repository' => "Aceste fișiere vor fi șterse din depozit și din răspunsurile automate care le conțin. Continuați?",
    'mn_edit__mail_name' => "Cont de e-mail",
    'mn_edit__mail_name_invalid' => "Numele contului de e-mail este incorect.",
    'mn_edit__mail_redir' => "Redirecționări de e-mail",
    'mn_edit__mail_redir_add' => "Adăugare membru în grupul de e-mail",
    'mn_edit__mail_resps' => "Răspunsuri automate la e-mailuri",
    'mn_edit__mailbox' => "Căsuță poștală",
    'mn_edit__enable_mailbox' => "Căsuță poștală",
    'mn_edit__mailgroup' => "Grup de e-mail",
    'mn_edit__mailgroup_addresses' => "Membrii grupului de e-mail",
    'mn_edit__mailgroup_disabled' => "Disponibil doar când contul de e-mail este deja adăugat.",
    'mn_edit__max_dom_quota' => "Implicit pentru domeniu (%1)",
    'mn_edit__mbox_quota_invalid' => "Dimensiunea de căsuță poștală este incorectă.",
    'mn_edit__new_resp_name' => "Nume răspuns automat nou",
    'mn_edit__no_autoresponders' => "Pentru a putea activa/dezactiva serviciul de răspunsuri automate, trebuie să adăugați cel puțin un răspuns automat.",
    'mn_edit__no_file_sel' => "Niciun fișier selectat.",
    'mn_edit__no_mail_addresses' => "Nicio adresă de e-mail specificată sau selectată.",
    'mn_edit__none' => "Niciunul",
    'mn_edit__not_create_pass' => "Nu se va crea o parolă pentru acest cont. Fără parolă, utilizatorul nu va avea posibilitatea de a vizualiza și/sau a trimite e-mailuri.",
    'mn_edit__redir_email_invalid' => "Adresa de redirecționare este incorectă.",
    'mn_edit__redirect_addr' => "Adresă de redirecționare",
    'mn_edit__remove_autoresp?' => "Sigur ștergeți răspunsul automat?",
    'mn_edit__remove_rcpnts?' => "Sigur ștergeți acești destinatari?",
    'mn_edit__repository' => "Depozit",
    'mn_edit__resps_attach' => "Fișiere atașate la răspunsurile automate",
    'mn_edit__select_rcpnt_from_list' => "Selectați cel puțin un destinatar din listă pentru a-l șterge.",
    'mn_edit__select_registered_users' => "Selectați utilizatorii înregistrați",
    'mn_edit__selected_postbox_have_not_setup_passwd' => "Ați ales să aveți un cont de e-mail, dar nu ați setat o parolă pentru acesta.",
    'mn_edit__unable_act_deact_mail_group' => "Imposibil de activat/dezactivat grupul de e-mail: %1",
    'mn_edit__unable_act_deact_mail_redir' => "Imposibil de activat/dezactivat redirecționarea de e-mailuri: %1",
    'mn_edit__unable_act_deact_postbox' => "Imposibil de activat/dezactivat căsuța poștală: %1",
    'mn_edit__unable_act_deact_resp' => "Imposibil de activat/dezactivat răspunsurile automate: %1",
    'mn_edit__unable_add_attach' => "Imposibil de atașat fișierul: %1",
    'mn_edit__unable_add_mail_group_member' => "Imposibil de adăugat membrul de grup de e-mail: %1",
    'mn_edit__unable_add_resp' => "Imposibil de adăugat răspunsul automat: %1",
    'mn_edit__unable_change_mail_name' => "Imposibil de modificat numele contului de e-mail: %1",
    'mn_edit__unable_deactivate_mail_group' => "Imposibil de dezactivat grupul de e-mail: %1",
    'mn_edit__unable_deactivate_resp' => "Imposibil de dezactivat răspunsurile automate la e-mailuri: %1",
    'mn_edit__unable_define_resp_id' => "Imposibil de definit ID-ul răspunsului automat: %1.",
    'mn_edit__unable_remove_attach' => "Imposibil de eliminat fișierele atașate: %1",
    'mn_edit__unable_remove_autoresp' => "Imposibil de șters răspunsul automat: %1.",
    'mn_edit__unable_remove_mail_group_member' => "Imposibil de eliminat membrii grupului de e-mail: %1",
    'mn_edit__wrong_way' => 'Nu se pot livra mesajele către %1 nu: acest cont de e-mail nu are căsuță poștală sau redirecționare activată.',
    'mn_edit__mailbox_is_disabled_mail_not_removed' => 'Căsuța poștală a adresei %1 a fost dezactivată. Mesajele din căsuța poștală nu au fost șterse, dar nu le puteți accesa prin protocoalele IMAP sau POP3.',
    'mn_list__mail_names_for_domain' => "Conturi e-mail din domeniul %1",
    'mn_list__sa_cannot_unable' => "Imposibil de activat filtrarea antispam",
    'mn_list__tab_cp_access' => "L",
    'mn_list__tab_title_client' => 'Client',
    'mn_list__tab_title_domain' => 'Domeniu',
    'mn_list__tab_title_autoresp' => "A",
    'mn_list__tab_title_box' => "B",
    'mn_list__tab_title_group' => "G",
    'mn_list__tab_title_name' => "Nume",
    'mn_list__tab_title_redirect' => "F",
    'mn_list__tab_title_spamfilter' => "S",
    'mn_list__tab_title_virusfilter' => 'AV',
    'mn_list__tab_title_drweb' => 'AV',
    'mn_list__unable_remove_mns' => "Imposibil de eliminat conturile de e-mail: %1",
    'module_upload__module_was_installed' => 'Acest modul este instalat deja. Dacă doriți să instalați o versiune mai nouă a modulului, dezinstalați-l prin Plesk, apoi încercați să-l reinstalați.',
    'module_upload__unable_to_install' => 'Imposibil de instalat pachetul de modul',
    'module_upload__wrong_package' => 'Fișierul încărcat nu este un pachet de modul acceptat.',
    'module_upload__wrong_module' => 'Fișierul încărcat nu conține un pachet de modul.',

    'news_articles_title' => 'Plesk News',
    'notification_text__invalid_subject_length' => "Lungime incorectă a subiectului notificării. Lungimea trebuie să fie cuprinsă între 1 și 255 caractere.",
    'notification_text__invalid_text_length' => "Lungimea textului de notificare este incorectă. Trebuie să fie cuprinsă între 1 și 65533 caractere.",
    'notification_text__subject' => "Subiect notificare",
    'notification_text__text' => "Textul notificării",
    'notification_text__title' => "Editare notificare",
    'notification_text__unable_set_text' => "Imposibil de modificat textul de notificare:",

    'odbc__cant_add_dsn' => "Imposibil de adăugat DSN %1: %2",
    'odbc__cant_build_connection_string' => "Imposibil de conectat cu parametrii specificați. Încercați din nou, cu alți parametri. Utilitarul a returnat: %1",
    'odbc__cant_connect' => "Imposibil de conectat la sursa de date utilizând setările definite. Serverul a returnat: %1",
    'odbc__cant_delete_dsn' => "Imposibil de șters DSN %1: %2",
    'odbc__cant_get_drivers_info' => "Imposibil de obținut informații despre drivere.",
    'odbc__cant_get_drivers' => "Imposibil de obținut lista driverelor ODBC: %1",
    'odbc__cant_get_list' => "Imposibil de obținut lista de DSN existente: %1",
    'odbc__cant_get_servers_list' => "Imposibil de obținut lista de servere.",
    'odbc__cant_open_info_file' => "Imposibil de deschis fișierul cu informații despre driverele ODBC.",
    'odbc__cant_parse_string' => "Imposibil de analizat șirul de conectare.",
    'odbc__connect_success' => "Conectare reușită",
    'odbc__driver_not_set' => "Driverul nu este setat",
    'odbc__driver_or_name_not_set' => "Driverul sau numele conexiunii ODBC nu au fost setate",
    'odbc__dsn_already_exists' => "În sistem există deja un DSN cu acest nume (%1)",
    'odbc__dsn_not_exists' => "Acest DSN nu există",
    'odbc__enter_connection_params' => "Configurarea unei conexiuni ODBC",
    'odbc__enter_dsn_name' => "Introduceți numele DSN",
    'odbc__invalid_dsn_name' => "Sintaxă greșită în numele de conexiune ODBC (%1): folosiți doar simboluri alfanumerice.",
    'odbc__no_such_driver' => "Nu se acceptă un driver ODBC cu acest nume (%1).",
    'odbc__remove_page_title' => "Următoarele conexiuni DSN ODBC vor fi șterse:",
    'odbc__select_dsn_to_remove' => "Selectați DSN-urile ce vor fi șterse.",
    'odbc__unknown_driver' => "Nume driver necunoscut (%1).",
    'odbc_add_new' => "Adăugare conexiune DSN",
    'odbc_driver' => "Driver",
    'odbc_dsn_description' => "Descrierea conexiunii",
    'odbc_dsn_list' => "Conexiuni DSN ODBC",
    'odbc_dsn_name' => "Nume conexiune",
    'odbc_dsn_system' => "DSN sistem",
    'odbc_dsn_text' => "DSN ODBC",
    'odbc_dsn_add__title' => 'Adăugare DSN ODBC',
    'odbc_req_field_not_set' => "Parametrii obligatorii nu sunt specificați.",

    // Descriptions of parameters of ODBC connection string
    'odbc__access_dbq' => 'Cale fișier bază de date',
    'odbc__access_pagetimeout' => 'Perioada, exprimată în zecimi de secundă, de păstrare a unei pagini nefolosite în buffer. Această opțiune este valabilă pentru toate sursele de date care utilizează driverul Microsoft Access.',
    'odbc__access_maxbuffersize' => 'Dimensiunea bufferului intern, exprimată în KB, se aliniază la 256 KB.',
    'odbc__access_readonly' => 'Setarea bazei de date drept „doar în citire” pentru a împiedica toate actualizările.',
    'odbc__access_exclusive' => 'Setarea bazei de date drept exclusivă pentru a împiedica actualizările partajate.',
    'odbc__access_safetransactions' => 'Dacă opțiunea este setată la 0 (setarea implicită), salvarea definitivă a tuturor tranzacțiilor se face imediat. Dacă este setată la 1, salvarea definitivă a tranzacțiilor se face numai la operația de COMMIT, dar performanțele vor fi ușor mai slabe.',
    'odbc__access_threads' => 'Numărul de fire de execuție în fundal pe care le va utiliza motorul de bază de date.',
    'odbc__access_maxscanrows' => "Numărul de rânduri de scanat la setarea tipului de dată al coloanei în funcție de datele existente.",
    'odbc__access_implicitcommitsync' => 'Specifică modul în care se scriu în baza de date modificările făcute în afara unei tranzacții.',
    'odbc__access_usercommitsync' => 'Stabilește dacă driverul MS Access execută în mod asincron tranzacțiile definite explicit de utilizator.',
    'odbc__mssql_server' => 'Server',
    'odbc__mssql_uid' => 'ID de conectare',
    'odbc__mssql_pwd' => 'Parolă',
    'odbc__mssql_database' => 'Bază de date implicită pentru sursa de date ODBC',
    'odbc__mssql_app' => 'Nume aplicație',
    'odbc__mssql_wid' => 'ID stație de lucru',
    'odbc__mssql_language' => 'Limbă implicită de utilizat',
    'odbc__mssql_oemtoansi' => 'Conversia caracterelor extinse în valori OEM',
    'odbc__mysql_server' => 'Numele de gazdă al serverului MySQL',
    'odbc__mysql_database' => 'Bază de date implicită',
    'odbc__mysql_user' => 'Numele de utilizator utilizat pentru conectarea la MySQL',
    'odbc__mysql_password' => 'Parola contului de utilizator pe server',
    'odbc__mysql_port' => 'Portul TCP/IP de utilizat dacă serverul nu este gazda locală',
    'odbc__mysql_socket' => 'Conductă denumită Windows pentru conectare în cazul în care serverul este gazda locală',
    'odbc__mysql_option' => 'Opțiunile care specifică modul de funcționare a MyODBC. Afișare <a target="_blank" href="http://www.linuxtopia.org/online_books/database_guides/mysql_5.1_database_reference_guide_OLD/connection-parameters.html">http://www.linuxtopia.org/online_books/database_guides/mysql_5.1_database_reference_guide_OLD/connection-parameters.html.</a>',
    'odbc__excel_dbq' => 'Cale fișier bază de date',
    'odbc__excel_defaultdir' => 'Director de date implicit',
    'odbc__excel_fil' => 'Versiune bază de date',
    'odbc__excel_maxbuffersize' => 'Dimensiune maximă buffer',
    'odbc__excel_pagetimeout' => 'Expirare pagină',

    'pb__aliases' => "Aliasuri",
    'pb__anonftp' => "FTP anonim",
    'pb__autoinstaller_releases' => 'Program de actualizare',
    'pb__cert' => "Certificate",
    'pb__cl_pool' => "Adrese IP",
    'pb__cl_pool_ctrl' => "%1",
    'pb__cl_pref' => "Setări",
    'pb__cl_rpt' => "Raport",
    'pb__cl_rpt_list' => "Personalizare",
    'pb__cl_templates' => "Șabloane de client",
    'pb__cl_traffic' => "Trafic",
    'pb__cl_traffic_history' => "Istoric de trafic",
    'pb__cl_traffic_of' => "Trafic %1",
    'pb__client' => "%1",
    'pb__clients' => "Clienți",
    'pb__comp_info' => "Componente server",
    'pb__common_acl' => 'Se permite transfer ACL',
    'pb__cp_access' => "Acces",
    'pb__crontab' => "Programator",
    'pb__scheduler' => "Programator",
    'pb__custom_buttons' => "Butoane personalizate",
    'pb__databases_db' => 'Baze de date',
    'pb__sqlservers_db' => 'Servere SQL Server',//to check
    'pb__db' => "Baze de date",
    'pb__db_edit' => "%1",
    'pb__db_server_edit' => '%1',
    'pb__db_servers' => 'Servere de baze de date',
    'pb__dl_usr_ed' => "Administrator de domeniu",
    'pb__dns' => "DNS",
    'pb__dns_template' => "DNS",
    'pb__dns_t' => "DNS",
    'pb__dom_ctrl' => "%1",
    'pb__dom_lim' => "Limite domeniu",
    'pb__dom_pref' => "Setări",
    'pb__dom_sum_report' => "Raport rezumat pentru domeniu",
    'pb__dom_templates' => "Șabloane de domeniu",
    'pb__dom_traffic' => "Trafic %1",
    'pb__domains' => "Domenii",
    'pb__domain_aliases' => 'Aliasuri de domeniu',
    'pb__dumps_list' => "Spațiul de stocare a fișierelor copie de rezervă",
    'pb__forwarding_setup' => "Configurarea redirecționării",
    'pb__filemanager' => "Manager de fișiere",
    'pb__ip_aliasing' => "Adrese IP",
    'pb__ip_clients' => "Ștergere adrese IP",
    'pb__license_management' => 'Informații despre licență',
    'pb__locales' => 'Limbi',
    'pb__log_files' => "Fișiere jurnal",
    'pb__mail' => 'E-mail',
    'pb__mail_name_files' => "Fișiere atașate",
    'pb__mail_name_redirects' => "Redirecționări de e-mail",
    'pb__mail_name_resp_attach_add' => "Atașare nouă",
    'pb__mail_name_resp_edit' => "%1",
    'pb__mail_name_responders' => "Răspunsuri automate la e-mailuri",
    'pb__mail_names' => "E-mail",
    'pb__maillists' => "Liste de e-mail",
    'pb__mimetypes' => 'Tipuri MIME',
    'pb__modules' => 'Module',
    'pb__modules_management' => 'Administrare module',
    'pb__notifications' => "Notificări",
    'pb__odbc' => "ODBC",
    'pb__phosting_setup' => "Configurare găzduire fizică",
    'pb__prtd_dirs' => "Directoare protejate",
    'pb__prtdir_edit' => "%1",
    'pb__report' => "Raport",
    'pb__report_auto' => "Program de livrare pentru %1",
    'pb__report_list' => "Personalizare",
    'pb__server' => "Server",
    'pb__sessions' => "Sesiuni",
    'pb__sapp_pool' => "Lista de aplicații web",
    'pb__siteapp_install' => 'Instalare aplicație web',
    'pb__site_app_pkgs' => 'Aplicații web',
    'pb__site_apps' => "Aplicații web",
    'pb__additional_key_info' => 'Proprietăți cheie',
    'pb__additional_key_properties' => 'Proprietăți cheie',
    'pb__skeleton' => 'Șablon de gazdă virtuală',
    'pb__skins' => 'Prezentări',
    'pb__skin_info' => '%1',
    'pb__spamassassin' => "Filtru antispam",
    'pb__statistics' => "Statistici",
    'pb__subdom_ctrl' => "%1",
    'pb__subdomains' => "Subdomenii",
    'pb__templates' => "Șabloane",
    'pb__virtualdirs' => 'Directoare virtuale',
    'pb__web_users' => "Utilizatori web",
    'pdir__enter_dir_name' => "Introduceți numele directorului.",
    'pdir__invalid_hst' => "Tipul de găzduire este incorect. Trebuie să fie de tip fizic.",
    'pdir__pd_id_is_undefined' => "ID-ul directorului protejat nu este definit.",
    'pdir__pdir_exist' => "Directorul cu acest nume este protejat deja.",
    'pdir__pdir_not_exist' => "Directorul protejat nu există.",
    'pdir__pdir_usr_not_exist' => "Utilizatorul directorului protejat nu există.",
    'pdir__prdirs_for_domain' => "Directoare protejate ale %1",
    'pdir__prdirs_for_subdomain' => "Directoare protejate în subdomeniul %1",
    'pdir__remove_pdir_usrs' => "Se vor șterge următorii utilizatori ai directorului protejat %2 din site-ul %1:",
    'pdir__remove_pdir_usrs_on_subdom' => "Se vor șterge următorii utilizatori ai directorului protejat %2 din subdomeniul %1:",
    'pdir__remove_pdirs_on_dom' => "Această operație va duce la eliminarea protecției directoarelor din site-ul %2 deținut de clientul %1. Directoarele nu vor fi șterse.",
    'pdir__remove_pdirs_on_subdom' => "Această operație va duce la eliminarea protecției directoarelor din subdomeniul %1. Directoarele nu vor fi șterse.",
    'pdir__select_pdir_usrs_for_remove' => "Selectați utilizatorii directorului protejat ce vor fi șterși.",
    'pdir__select_pdirs_to_remove' => "Selectați directoarele pentru care veți înlătura protecția.",
    'pdir__unable_define_pdir_users' => "Imposibil de definit utilizatorii de director protejat.",
    'pdir__unable_define_pdirs_properties' => "Imposibil de setat proprietățile directoarelor protejate: %1",
    'pdir__unable_select_dom_param' => "Imposibil de selectat parametrii de domeniu: %1",
    'pdir_ed__create_pdir_for_domain' => "Crearea unui director protejat în %1",
    'pdir_ed__create_pdir_for_subdomain' => "Crearea unui director protejat în subdomeniul %1",
    'pdir_ed__dir_already_protect' => "Acest director este protejat deja.",
    'pdir_ed__head_txt' => "Titlul zonei protejate",
    'pdir_ed__invalid_login' => "Ați specificat un nume de utilizator incorect.",
    'pdir_ed__login_exists' => "Acest utilizator există deja. Încercați să specificați un alt nume de utilizator.",
    'pdir_ed__new_usr' => "Nume utilizator",
    'pdir_ed__non_ssl' => "non-SSL/TLS",
    'pdir_ed__cgi_bin' => "cgi-bin",
    'pdir_ed__path' => "Nume director",
    'pdir_ed__pdir_for_domain' => "Director protejat %1 în domeniul %2",
    'pdir_ed__pdir_for_subdomain' => "Directorul protejat %1 în subdomeniul %2",
    'pdir_ed__pdir_location' => "Locație director",
    'pdir_ed__pdir_users' => "Utilizatori director protejat",
    'pdir_ed__ssl' => "SSL/TLS",
    'pdir_ed__ssl_or_nonssl_should_be_checked' => "Trebuie să bifați cel puțin una dintre casetele de selectare SSL/TLS și non-SSL/TLS.",
    'pdir_ed__unable_cr_pdir_usr' => "Imposibil de creat utilizatorul de director protejat: %1",
    'pdir_ed__unable_create_pdir' => "Imposibil de creat directorul protejat: %1",
    'pdir_ed__unable_define_hst_type' => "Imposibil de definit tipul de găzduire.",
    'pdir_ed__unable_update_pdir' => "Imposibil de salvat setările directorului protejat: %1",
    'pdir_ed__wrong_symbol_in_header' => "Nu utilizați caracterul %1 în titlul directorului.",
    'pdir_usr_ed__create_pdir_usr_for_pd' => "Crearea unui utilizator pentru directorul protejat %1",
    'pdir_usr_ed__not_create_pass' => "Această operație nu va crea o parolă pentru noul utilizator de director protejat. Fără parolă utilizatorul nu se va putea conecta.",
    'pdir_usr_ed__pass_for_pdir_usr' => "Parolă utilizator director protejat %1",
    'pdir_usr_ed__unable_select_pdir_usr' => "Imposibil de selectat utilizatorul de director protejat: %1",
    'pdir_usrs_list__unable_define_pdir_usrs' => "Imposibil de definit utilizatorii de director protejat: %1",
    'pdir_usrs_list__unable_remove_pd_usrs' => "Imposibil de șters utilizatorii de director protejat: %1",
    'pdirs_list__name' => "Nume",
    'pdirs_list__tab_title_non_secure_dir' => "N",
    'pdirs_list__tab_title_secure_dir' => "S",
    'pdirs_list__tab_title_cgi_bin_dir' => "C",
    'pdirs_list__unable_remove_pdirs' => "Imposibil de eliminat directoarele protejate: %1",
    'phosting__anonftp_encrypt' => 'Parola utilizatorului FTP este criptată și interfața nu poate fi utilizată pentru protejarea directorului /plesk-stat/webstat/. Reintroduceți parola FTP sau deselectați opțiunea „accesibil prin directorul protejat cu parola /plesk-stat/webstat/”',
    'phosting__hosting_and_dns_ip_difference_warning' => "Rezolvarea numelui de domeniu %%domain_name%% este adresa IP %%dns_ip_address%%. Adresa IP atribuită site-ului dvs. este %%hosting_ip_address%%. Dacă site-ul nu se deschide în browser la adresarea cu numele de domeniu, accesați ecranul de administrare DNS (Domenii> Nume domeniu> DNS) și modificați proprietățile înregistrării de resursă A: atribuiți adresa %%hosting_ip_address%% numelui de domeniu %%domain_name%%.",
    'phosting__ip_change_warning' => "Adresei IP s-a schimbat. S-au făcut schimbările corespunzătoare și în zona DNS a domeniului.",
    'phosting__other_hosting_exists_on_ip' => "Imposibil de modificat certificatul: această adresă IP este utilizată în unul sau mai multe conturi de găzduire.",
    'phosting__unable_to_change_certificate' => "Imposibil de instalat certificatul: %1",
    'phosting__unable_to_change_ip_address' => "Imposibil de modificat adresa IP: %1",
    'phosting__unable_to_set_cert' => "Imposibil de setat certificatul SSL/TLS: %1",
    'phosting__unable_update' => "Imposibil de actualizat setările de găzduire: %1",
    'phosting__unable_manage' => "Imposibil de administrat găzduirea: %1",
    'phosting__failed_to_add_logs_fail2ban' => "Nu a reușit încercarea de a configura fail2ban să urmărească jurnalele domeniului. Jurnalele vor fi urmărite automat după următoarea repornire a serviciului fail2ban.\n%1",

    'picker_acl_record__tittle' => 'Selectare înregistrare ACL',
    'picker_autoresponder__title' => 'Selectați un răspuns automat',
    'picker_black_list__domain_name' => 'Selectare nume de domeniu',
    'picker_certificate' => 'Selectarea unui certificat SSL/TLS',

    'picker_dns_zone_template__title' => 'Selectare înregistrare resursă',
    'picker_domain__title' => 'Selectați un site web',
    'picker_domain_alias__title' => 'Selectare alias de domeniu',
    'picker_resource_record__title' => 'Selectare înregistrare resursă',
    'picker_disabled_resource_record__title' => 'Selectare server de nume',
    'picker_ip_address__title' => 'Selectare adresă IP',
    'picker_ip_address_clients__title' => 'Selectați clienții care folosesc această adresă IP',
    'picker_mail_queue' => 'Selectați mesajele de e-mail',
    'picker_site_application__title' => 'Selectare aplicație web',
    'picker_subdomain__title' => 'Selectare subdomeniu',
    'picker_web_user__title' => 'Selectare utilizator web',
    'picker_custom_button__title' => 'Selectare buton personalizat',
    'picker_license_key__title' => "Selectați o cheie de licență",
    'picker_spamfilter_address__title' => 'Selectare adresă de filtru antispam',
    'picker_white_list__networks' => 'Selectare rețele',

    'plesk_key__action_logs' => "Înregistrarea în jurnal a acțiunilor întreprinse de utilizatorii Plesk",
    'plesk_key__app_vault' => "Seif de aplicații",
    'plesk_key__backup' => "Funcții de creare și de restaurare a copiilor de rezervă",
    'plesk_key__client_templs' => "Administrarea planurilor de servicii",
    'plesk_key__clients' => "Conturi utilizator (reselleri și clienți)",
    'plesk_key__resellers_only' => "Conturile de utilizatori (reselleri)",
    'plesk_key__customers_only' => "Conturile de utilizatori (clienți)",
    'plesk_key__domains' => "Domenii",
    'plesk_key__domain_aliases' => "Aliasuri de domeniu",
    'plesk_key__manage_dashboard' => 'Personalizarea paginii de pornire',
    'plesk_key__drweb' => "Administrarea de antivirus",
    'plesk_key__event_manager' => "Manager de evenimente",
    'plesk_key__expirations' => "Administrarea datelor de expirare a conturilor",
    'plesk_key__group_ops' => "Modificarea mai multor obiecte în același timp",
    'plesk_key__expiration' => "Data expirării cheii",
    'plesk_key__edition_name' => "Ediție Plesk",
    'plesk_key__key_number' => "Număr cheie",
    'plesk_key__languages' => "Pachete lingvistice",
    'plesk_key__mailnames' => "Conturi de e-mail",
    'plesk_key__migration_manager' => "Manager de migrare și transfer",
    'plesk_key__mssql' => "Suport Microsoft SQL Server",
    'plesk_key__myplesk_func' => "Linkuri pentru cumpărarea de certificate SSL/TLS și servicii de înregistrare a domeniilor",
    'plesk_key__myplesk_server_id' => "Identificator de server MPC secundar",
    'plesk_key__notifications' => "Administrarea notificărilor",
    'plesk_key__postgresql' => "Suport pentru servere de baze de date PostgreSQL",
    'plesk_key__qmail_queue' => 'Administrarea cozilor de e-mail',
    'plesk_key__remote_db' => 'Găzduirea bazelor de date la distanță',
    'plesk_key__slave_servers' => "Servere secundare",
    'plesk_key__spamassassin' => "Administrarea filtrelor antispam",
    'plesk_key__subdomains' => "Administrarea subdomeniilor",
    'plesk_key__sys_access' => "Administrarea accesului la server",
    'plesk_key__traffic_reports' => "Rapoarte despre utilizarea traficului",
    'plesk_key__tts' => "Birou de asistență",
    'plesk_key__virtuozzo' => "Valabil doar pentru containere Virtuozzo",
    'plesk_key__webusers' => "Utilizatori web",
    'plesk_key__license_update_date' => 'Următoarea dată de actualizare a cheii de licență',
    'plesk_key__autoinstaller_config' => 'Administrarea setărilor programului de actualizare',
    'plesk_key__check_wrong' => "Cheia de licență este incorectă. Pentru a putea utiliza Plesk, obțineți și instalați o nouă cheie de licență valabilă.",
    'plesk_key__upload_check_wrong' => 'Cheia de licență încărcată nu este corectă.',
    'plesk_key__revert_check_wrong' => 'Cheia de licență instalată anterior nu este corectă.',
    'plesk_key__update_check_wrong' => 'Cheia de licență actualizată nu este corectă.',
    'plesk_key__viruozzo_only_key' => 'Cheia de licență este destinată exclusiv sistemelor Plesk care funcționează în containere Virtuozzo.',
    'plesk_key__ip_ranges_exceeded' => 'Această copie licențiată de Plesk se poate utiliza numai cu următoarele adrese IP: %2. Licența nu este valabilă pentru următoarele adrese IP: %1.', //%1 not allowed addresses list separated by comma, %2 allowed IP addresses list separated by comma
    'plesk_key__limits_exceeded' => 'Volumul de resurse utilizate depășește limitele definite de licență.',
    // For the keys below: %1 limit value, %2 used value, %3 delta value
    'plesk_key__limits_exceeded_lim_dom' => 'Numărul de site-uri web găzduite pe server depășește limita definită de licență. Aveți %2 site-uri găzduite; licența permite doar %1.',
    'plesk_key__limits_exceeded_lim_domain_aliases' => 'Numărul aliasurilor de domeniu pe server depășește limita definită de licență. Aveți %2 aliasuri de domeniu; licența permite găzduirea a doar %1 aliasuri de domeniu.',
    'plesk_key__limits_exceeded_lim_cl' => 'Numărul de conturi de client deservite depășește limita definită de licență. Aveți %2 conturi de client, licența permite doar %1.',
    'plesk_key__limits_exceeded_lim_mn' => 'Numărul de conturi de e-mail deservite depășește limita definită de licență. Aveți %2 conturi de e-mail, licența permite doar %1.',
    'plesk_key__limits_exceeded_lim_wu' => 'Numărul utilizatorilor web deserviți depășește limita definită de licență. Aveți %2 conturi, licența permite doar %1 conturi de utilizatori web.',
    'plesk_key__limits_exceeded_MLS' => 'Numărul pachetelor lingvistice instalate depășește limita definită de licență. Aveți %2 pachete instalate, licența permite instalarea a doar %1 pachete.',
    'plesk_key__wrong_version' => 'Încercați să utilizați o cheie de licență creată pentru o altă versiune de Plesk. Contactați reprezentanții de vânzări Plesk pentru a obține cheia de licență corespunzătoare.',
    'plesk_key__other_product' => 'Încercați să utilizați o cheie de licență creată pentru un alt produs. Contactați reprezentanții de vânzări Plesk pentru a obține cheia de licență corespunzătoare.',
    'plesk_key__invalid_machine_id' => 'Încercați să utilizați o cheie de licență creată pentru o altă instanță de server Plesk. Contactați reprezentanții de vânzări Plesk pentru a obține cheia de licență corespunzătoare.',
    'plesk_key__limits_exceeded_error' => 'Imposibil de instalat cheia de licență: volumele de resurse utilizate în prezent depășesc limitele definite în cheia de licență încărcată.',
    'plesk_key__limits_exceeded_note' => 'Volumele de resurse utilizate în prezent depășesc limitele definite în cheia de licență încărcată.',
    'plesk_key__key_file_invalid' => 'Fișierul cheie încărcat nu este valabil sau nu conține nicio cheie de licență.',
    'plesk_key__server_request_error' => 'Licența nu se poate actualiza. Asigurați-vă că nu sunt blocate conexiunile la serverul de licență ka.plesk.com prin portul TCP %1. <a href="https://support.plesk.com/hc/en-us/articles/213383529" target="_blank">Aflați cum se face acest lucru</a>.',
    'key__no_key_file_in_zip' => 'Fișierul .zip încărcat nu conține fișierul cu cheie de licență',
    'key__key_upload' => 'Instalarea cheii de licență',
    'additional_key__prop_name' => 'Proprietate',
    'additional_key__prop_value' => 'Valoare',
    'additional_key__descr_name' => 'Nume cheie',
    'additional_key__descr_key_number' => 'Număr cheie',
    'additional_key__descr_key_vz' => "Această cheie de licență este destinată exclusiv utilizării în containere Virtuozzo.",
    'additional_key__descr_key_mailboxes' => 'Căsuțe poștale',
    'additional_key__descr_lim_date' => 'Data expirării',
    'additional_key__descr_license_update_date' => 'Următoarea dată de actualizare a cheii de licență',
    'additional_key__file_invalid' => 'Fișierul cheie încărcat nu este valabil sau nu conține nicio cheie de licență.',
    'additional_key__file_incompatible' => 'Fișierul cheie încărcat nu este valabil pentru această aplicație.',
    'additional_key__expired' => 'Această cheie suplimentară a expirat.',
    'additional_key__not_exists' => 'Nicio cheie de licență instalată.',
    'additional_key__viruozzo_only_key' => 'Această cheie de licență este destinată exclusiv utilizării în Plesk instalat în containere Virtuozzo.',
    'additional_key_update__result_response' => 'Răspunsul serverului de licență: %1',
    'additional_key_update__result_network' => 'Imposibil de conectat la serverul de licență. Asigurați-vă că rețeaua permite comunicarea cu %1: %2.',
    'additional_key_update__result_lock' => 'Actualizarea cheii este deja în desfășurare',
    'additional_key_update__result_internal_error' => 'Eroare la actualizarea cheii de licență: %1',

    'proceed_to_cl_pool' => "Continuare spre configurarea domeniului de adrese IP al clientului",
    'proceed_to_hosting_setup' => "Începeți configurarea găzduirii",
    'removeCerts__remove_certificates_cp' => "Următoarele certificate vor fi șterse:",
    'removeCerts__remove_certificates_domain' => "Următoarele certificate deținute de %1 vor fi șterse:",
    'removeClientsIP_remove_clients_ip' => "Această adresă IP va fi ștearsă din domeniile de adrese ale următorilor clienți:",
    'removeMailAliases__remove_mail_aliases' => "Următoarele aliasuri ale contului de e-mail %1 vor fi șterse:",
    'removeMailNames__remove_mailnames' => "Următoarele conturi de e-mail și aliasuri vor fi șterse din domeniul %1:",
    'removeMailNames__remove_mailnames_of_cl' => "Următoarele conturi de e-mail și aliasuri vor fi șterse din domeniul %2 deținut de clientul %1:",
    'removeMailNames__these_mailnames_will_not_delete' => "Aceste conturi e-mail nu vor fi șterse.",
    'removeFtpSessions__remove_title' => "Următoarele sesiuni FTP vor fi închise:",
    'removeTemplates__remove_templates' => "Următoarele șabloane vor fi șterse:",
    'report_auto__list_title' => 'D',
    'report_auto__list_auto' => 'Frecvență',
    'report_auto__list_last' => 'Ultima dată de livrare',
    'report_auto__list_recipient' => 'Livrare la',
    'report_auto__list_select' => 'Raport despre',
    'report_auto__title' => 'Programarea livrărilor pentru %1',
    'report_auto__recipient_email' => 'adresa de e-mail specificată',
    'report_auto__recipient_admin' => 'administratorul de server',
    'report_auto__recipient_client' => 'client',
    'report_auto__recipient_domain' => 'administratorul de domeniu',
    'report_auto_edit__select' => 'Raport despre',
    'report_auto__select_client_report_all' => 'toți clienții',
    'report_auto__select_client_report_current' => 'acest client',
    'report_auto__select_client_report_other_client' => '%1',
    'report_auto__select_domain_report_all' => 'toate domeniile',
    'report_auto__select_domain_report_other_client' => 'toate domeniile ale %1',
    'report_auto__select_domain_report_client' => 'toate domeniile acestui client',
    'report_auto__select_domain_report_reseller' => 'toate domeniile acestui reseller',
    'report_auto__select_domain_report_current' => 'domeniul actual',
    'report_auto__select_domain_report_other_domain' => '%1',
    'report_auto__legend' => 'Programe de livrare',
    'report_auto__select_for_remove' => "Selectați programările de livrare ce vor fi șterse.",
    'report_auto_remove__title' => "Următoarele programări de livrare a rapoartelor vor fi șterse:",
    'report_auto_edit__title' => 'Proprietățile programării de livrare',
    'report_auto_edit__recipient' => 'Livrare la',
    'report_auto_edit__target' => 'Raport despre',
    'report_auto_edit__auto' => 'Frecvența de livrare',
    'resp_edit__always_respond' => "răspunde întotdeauna",
    'resp_edit__reply_subject' => "Subiect răspuns",
    'resp_edit__answer_subject' => "Răspuns cu subiect",
    'resp_edit__answer_txt' => "Răspuns cu text",
    'resp_edit__attach' => "Atașare fișiere",
    'resp_edit__default_subject' => "Răspuns: %1",
    'resp_edit__for' => "pentru",
    'resp_edit__frw_rqst_email' => "După trimiterea răspunsului automat mesajul original se redirecționează către adresa de e-mail specificată",
    'resp_edit__fwd_email_invalid' => "Adresa de e-mail de destinație este incorectă.",
    'resp_edit__in_body' => "în textul mesajului",
    'resp_edit__in_subject' => "în subiectul mesajului",
    'resp_edit__invalid_resp_freq' => "Frecvența răspunsului este incorectă.",
    'resp_edit__invalid_rqst_txt' => "Textul solicitării este incorect.",
    'resp_edit__invalid_store_lim_num' => "Valoarea limită este incorectă.",
    'resp_edit__limits_title' => "Limite",
    'resp_edit__maximum_allowed_resp_freq_reached' => "Numărul maxim de răspunsuri pe zi depășește cota definită. Permis: %1, solicitat: %2",
    'resp_edit__no_files_sel' => "Niciun fișier selectat.",
    'resp_edit__no_txt_supplied' => "Nu s-a introdus text.",
    'resp_edit__reply_title' => "Răspuns",
    'resp_edit__reply_to_address' => "Adresă răspuns",
    'resp_edit__reply_to_invalid' => "Adresa de răspuns este incorectă.",
    'resp_edit__reply_uniq_email' => "Număr maxim de răspunsuri care se pot trimite la o adresă de e-mail",
    'resp_edit__conditions_title' => "Condiții",
    'resp_edit__request_title' => "Solicitare",
    'resp_edit__resp' => "Răspuns automat",
    'resp_edit__resp_name' => "Nume răspuns automat",
    'resp_edit__resp_not_exist' => "Răspunsul automat nu există.",
    'resp_edit__resp_status' => "Stare răspuns automat",
    'resp_edit__rqst_txt' => 'Specificați condițiile acestui răspuns automat',
    'resp_edit__select_files_on_server_for_attach' => "Selectați fișierele de atașat",
    'resp_edit__store_up_to' => "Stocare până la",
    'resp_edit__subj_line_invalid' => "Subiectul este incorect.",
    'resp_edit__text_too_big' => "Textul mesajului de răspuns este prea lung.",
    'resp_edit__times_in_a_day' => "ori pe zi.",
    'resp_edit__unable_define_resp_cond' => "Imposibil de definit condiția de trimitere a răspunsului automat: %1",
    'resp_edit__unable_define_resp_status' => "Imposibil de definit starea răspunsului automat: %1",
    'resp_edit__unable_turn_on_resp' => "Imposibil de activat răspunsul automat: %1",
    'resp_edit__uniq_email' => "adrese de e-mail unice",
    'resp_edit__content_type' => 'Format de e-mail',
    'resp_edit__content_type_text' => 'Text simplu',
    'resp_edit__content_type_html' => 'HTML',
    'resp_edit__charset' => 'Codificare',
    'restart__dns' => 'Server DNS (%1)',
    'restart__drweb' => 'Antivirus Plesk Premium',
    'restart__mail' => "Server IMAP/POP3 (%1)",
    'restart__mssql' => "Server Microsoft SQL",
    'restart__mysql' => "Server MySQL",
    'restart__postgresql' => "PostgreSQL",
    'restart__psa' => "Servicii",
    'restart__smtp' => "Server SMTP (%1)",
    'restart__spamd' => "Filtru antispam",
    'restart__spamassassin' => "SpamAssassin",
    'restart__stunnel' => "Stunnel",
    'restart__web' => "Server web (%1)",
    'restart__ftp' => "Server FTP (%1)",
    'restart__service_start' => 'Așteptați pornirea serviciului.',
    'restart__service_stop' => 'Așteptați oprirea serviciului.',
    'restart__service_restart' => 'Așteptați repornirea serviciului.',
    'rm_domains__some_domains_are_not_exist' => "Unele dintre domeniile specificate nu există. Este posibil să le fi șters un alt utilizator.",
    'rpt_cl_dom_data_bases' => "Bază de date MySQL",
    'rpt_cl_dom_mssql_data_bases' => "Bază de date MSSQL",
    'rpt_cl_dom_mail_groups' => "Grupuri e-mail",
    'rpt_cl_dom_mail_lists' => "Liste e-mail",
    'rpt_cl_dom_mail_resps' => "Răspuns automat",
    'rpt_cl_dom_mail_antispam' => "Antispam",
    'rpt_cl_dom_mail_antivirus' => "Antivirus",
    'rpt_cl_dom_postboxes' => "Căsuțe poștale",
    'rpt_cl_dom_redirects' => "Redirecționări",
    'rpt_cl_dom_subdomains' => "Subdomenii",
    'rpt_cl_dom_domain_aliases' => "Aliasuri de baze date",
    'rpt_cl_dom_web_users' => "Utilizatori web",
    'rpt_cl_report_for_admin__' => "Raport pentru administrator %1",
    'rpt_cl_report_for_reseller__' => "Raport pentru resellerul %1",
    'rpt_cl_report_for_cl__' => "Raport despre clientul %1",
    'rpt_cl_section_domains' => "Domenii",
    'rpt_cl_section_full_domains' => "Domenii",
    'rpt_cl_section_general' => "General",
    'rpt_create' => "Creare raport",
    'rpt_empty' => "Raportul trebuie să conțină cel puțin o secțiune",
    'rpt_default_report' => "Utilizare ca raport implicit",
    'rpt_dom_report_for_dom__' => "Raport de domeniu pentru %1",
    'rpt_dom_section_databases' => "Baze de date",
    'rpt_dom_section_full_databases' => "Baze de date",
    'rpt_dom_section_full_maillists' => "Liste de e-mail",
    'rpt_dom_section_full_mailnames' => "Conturi de e-mail",
    'rpt_dom_section_full_webusers' => "Utilizatori web",
    'rpt_dom_section_full_siteapps' => 'Aplicații web',
    'rpt_dom_section_full_aspnetapps' => 'Aplicații web ASP.NET',
    'rpt_dom_section_general' => "General",
    'rpt_dom_section_hosting' => "Găzduire",
    'rpt_dom_section_maillists' => "Liste de e-mail",
    'rpt_dom_section_mailnames' => "Conturi de e-mail",
    'rpt_dom_section_siteapps' => 'Aplicații web',
    'rpt_dom_section_aspnetapps' => 'Aplicații web ASP.NET',
    'rpt_dom_section_webusers' => "Utilizatori web",
    'rpt_dom_title_wa_status' => "S",
    'rpt_edit__' => "Editarea raportului %1",
    'rpt_enter_email_address' => "Introduceți adresa de e-mail la care se va trimite raportul.",
    'rpt_list' => "Aspecte de raport personalizate",
    'rpt_name' => "Nume raport",
    'rpt_remove_reports' => "Următoarele aspecte de raport vor fi șterse:",
    'rpt_reports' => "Rapoarte",
    'rpt_section_full' => "Complet",
    'rpt_section_none' => "Niciunul",
    'rpt_section_summary' => "Rezumat",
    'rpt_select_reports_for_remove' => "Selectați aspectele de raport ce vor fi șterse.",
    'rpt_default_full' => 'Raport complet',
    'rpt_default_summary' => 'Raport rezumat',

    // end of kooper part

    // pit part

    'rpt_send_report_by_email_error__' => "Eroare trimitere raport: %1",
    'rpt_send_report_by_email_ok__' => "Raportul a fost trimis la %1",
    'sa_action' => "Acțiune",
    'sa_action_del' => "Ștergere",
    'sa_action_desc' => "Ce se întâmplă cu mesajele spam",
    'sa_action_save' => "Marcare ca spam și stocare în contul de e-mail",
    'sa_admin_blacklist' => "Lista neagră a administratorului",
    'sa_admin_whitelist' => "Lista albă a administratorului",
    'sa_db_del_confirm' => "Sigur goliți baza de date a filtrului antispam?",
    'sa_eml_in_ignorelist' => "Adresa de e-mail este în lista de ignorare",
    'sa_empty_email' => "Imposibil de adăugat un model de e-mail necompletat.",
    'sa_exists_email' => "Deja există un asemenea model de e-mail.",
    'sa_disabled__mailname_not_filtering' => "Setările de server curente nu permit utilizarea filtrului de e-mail pentru acest cont de e-mail",
    'sa_disabled__filtering_is_disabled' => 'Administratorul de server a dezactivat filtrarea antispam',
    'sa_disabled__hasnt_mailbox' => "Imposibil de activat filtrarea antispam fără o căsuță poștală",
    'sa_enable_filter' => "Activare filtrare antispam",
    'sa_forget' => "eliminare",
    'sa_from' => "De",
    'sa_ham' => "ham",
    'sa_pattern_is_invalid' => "Modelul este incorect.",
    'sa_spam' => "spam",
    'sa_trainer__page_title' => 'Instruirea filtrului antispam',
    'sa_trainer__tools_legend' => 'Instrumente',
    'sa_trainer__info_legend' => 'Informații',
    'sa_trainer__messages_list_legend' => 'Mesaje în căsuța poștală',
    'sa_trainer__c' => 'T',
    'sa_trainer__l' => 'L',
    'sa_trainer__subject' => 'Subiect',
    'sa_trainer__from' => 'De',
    'sa_trainer__date' => 'Data',
    'sa_trainer__info_text' => 'Mesaje memorate: %1 spam, %2 non-spam, %3 în total.',
    'sa_trainer__messages' => 'mesaje',
    'sa_trainer__select__all' => 'Toate',
    'sa_trainer__select__spam_only' => 'Spam',
    'sa_trainer__select__ham_only' => 'Non-spam',
    'sa_trainer__select__unknown_only' => 'Necunoscut',
    'sa_trainer__cannot_remove_messages' => 'Imposibil de șters mesajele selectate din căsuța poștală.',
    'sa_trainer__remove_messages_confirm' => 'Sigur ștergeți mesajele selectate din căsuța poștală?',
    'sa_subj' => "Subiect",
    'sa_training' => "Instruirea filtrului antispam",
    'sa_training_legend' => "Instruirea filtrului bayesian",
    'sa_use_srv_settings' => "Se utilizează setările la nivel de server",
    'sa_user_blacklist' => "Lista neagră a utilizatorului",
    'sa_user_whitelist' => "Lista albă a utilizatorului",
    'sa_usr_disabled_by_srv' => "Administratorul de server nu permite setările de filtrare antispam individuale",
    'sa_usr_no_postbox' => "Filtrul antispam nu se poate activa deoarece căsuța poștală este dezactivată pentru acest cont de e-mail.",
    'sa_filters' => 'Filtre antispam',
    'spamfilter__tools_legend' => 'Instrumente',
    'spamfilter__prefs_legend' => 'Setări',
    'spamfilter__max_children' => 'Numărul maxim de procese spamd care se pot executa',
    'spamfilter__rewrite_header_subject_hint' => 'Lăsați acest câmp necompletat dacă nu doriți să adăugați text. Tastați _SCORE_ dacă doriți să includeți punctajul în subiectul mesajului.',
    'spamfilter__reject_spam' => 'Mesajele spam se șterg la sosirea în căsuța poștală',
    'spamfilter__enabled' => 'Activat',
    'spamfilter_addresses_list__tools_legend' => 'Instrumente',
    'spamfilter_addresses_list__list_legend' => 'Adrese',
    'spamfilter_addresses_list__items' => 'adrese',
    'spamfilter_addresses_list__status' => 'S',
    'spamfilter_addresses_list__level' => 'L',
    'spamfilter_addresses_list__address' => 'Adresă',
    'spamfilter_addresses__file_legend' => 'Din fișier',
    'spamfilter_addresses__file_label' => 'Nume fișier',
    'spamfilter_addresses__file_hint' => 'Încărcați un fișier cu codificare UTF-8.',
    'spamfilter_addresses__text_legend' => 'Din listă',
    'spamfilter_addresses__text_label' => 'Adrese de e-mail',
    'spamfilter_addresses__remove_title' => 'Următoarele adrese vor fi șterse din listă:',
    'spamfilter_addresses__empty_selection' => 'Nicio adresă selectată.',
    'server__admin_info' => "Informații administrator",
    'server__ctrl_panel' => "Plesk",
    'server__enter_bug_essence_below' => "Introduceți mai jos descrierea erorii",
    'server__power_management' => "Administrarea consumului de electricitate",
    'server__services' => "Servicii",
    'server__system' => "Sistem",
    'server__title' => "Administrare server",
    'server_preferences__admin_skin' => "Prezentarea interfeței administratorului",
    'server_preferences__default_language' => "Limba implicită",
    'server_preferences__default_skin' => "Prezentarea implicită",
    'server_preferences__restart_apache_interval' => "Interval de repornire Apache",
    'server_preferences__system' => 'Setări de sistem',
    'mail__tabs_preferences' => "Setări",
    'mail__tabs_white_list' => "Listă albă",
    'server_preferences__use_vocabulary' => "Verificarea parolelor pentru conturile de e-mail în dicționar",
    'sessions__agreement' => "Da, doresc să închid aceste sesiuni.",
    'sessions__select_sessions_for_remove' => "Selectați sesiunile ce vor fi închise.",
    'sessions__tabs_cp_sessions' => 'Sesiuni Plesk',
    'sessions__tabs_ftp_sessions' => 'Sesiuni FTP',
    'sessions__ftp_sessions_login' => 'Nume utilizator de cont FTP',
    'sessions__ftp_sessions_domain' => 'Nume domeniu',
    'sessions__ftp_sessions_path' => 'Locație actuală',
    'sessions__ftp_sessions_file' => 'Nume fișier',
    'sessions__ftp_sessions_action' => 'Stare',
    'sessions__ftp_sessions_speed' => 'Viteza, KB/S',
    'sessions__ftp_sessions_comp' => 'Progres, %',

    'site_apps__access_level' => 'Nivel de acces',
    'site_apps__access_level_commercial' => 'Comercial',
    'site_apps__access_level_free' => 'Gratuit',
    'site_apps__action_installer' => "Instalare aplicație web",
    'site_apps__action_reconfigure' => "Reconfigurare aplicație web",
    'site_apps__custom_button_level' => 'Creați un buton personalizat pentru accesul la aplicație?',
    'site_apps__custom_button_level_false_domain_user_only' => 'Nu',
    'site_apps__custom_button_level_domain_user_only' => 'Da',
    'site_apps__custom_button_level_false' => 'Nu',
    'site_apps__custom_button_level_domain' => 'Da, se pune la dispoziția domeniului curent',
    'site_apps__custom_button_level_client' => 'Da. Butonul va fi disponibil în toate domeniile clientului',
    'site_apps__custom_button_level_admin' => 'Da, se pune la dispoziția tuturor domeniilor',
    'site_apps__description' => "Descriere",
    'site_apps__dir_used_by_sapp__' => "Directorul „%1” este utilizat de o altă aplicație web",
    'site_apps__dir_used_by_unknown__' => "Directorul „%1” există deja. În cazul în care continuați, conținutul acestuia va fi suprascris.",
    'site_apps__dir_invalid_name__' => "Numele de director %1 este incorect",
    'site_apps__file_name' => 'Nume fișier aplicație web',
    'site_apps__invalid_install_prefix' => "Prefix de instalare incorect",
    'site_apps__invalid_package' => "Aplicația web este incorectă",
    'site_apps__key_status' => 'Licențiere',
    'site_apps__key_status_free' => 'Se distribuie gratuit. Nu este necesară nicio cheie de licență',
    'site_apps__key_status_ok' => 'Cheia de licență necesară este instalată',
    'site_apps__key_status_problem' => 'Cheia de licență necesară nu este instalată',
    'site_apps__name' => "Nume",
    'site_apps__no_domains' => 'Imposibil de instalat aplicația web. Există deja o aplicație web instalată în directorul rădăcină al acestui domeniu. Creați un subdomeniu pentru această aplicație web.',
    'site_apps__package_info_' => "Informații despre aplicația web",
    'site_apps__package_integrated' => "aplicație inclusă, nu se poate șterge",
    'site_apps__pool_select_packages_to_add' => 'Selectați aplicațiile web care vor fi adăugate în listă',
    'site_apps__release' => "Nr. de lansare",
    'site_apps__resource_used_by_sapp' => "Resursa este utilizată de aplicația web instalată",
    'site_apps__root_used_by_sapp' => "Resursa este utilizată de o aplicație web instalată",
    'site_apps__these_domains_will_not_delete' => 'Aceste (sub)domenii nu vor fi șterse',
    'site_apps__upload_site_app_pkg_title' => 'Încărcare aplicație web nouă',
    'site_apps__version' => "Versiune",
    'site_apps__access_to' => "Acces la %1",
    'site_builder_requires' => '%1 - %3',
    'skeleton__admin_label' => "Șablon de gazdă virtuală",
    'skeleton__client_label' => "Șablon de gazdă virtuală %1",
    'skeleton__admin_page' => "Administrare șablon de găzduire virtuală",
    'skeleton__files_list' => "Fișiere și directoare",
    'skeleton__archiver_not_installed' => "Imposibil de decomprimat arhiva. Este posibil ca aplicația de arhivare să nu fie instalată pe server. Contactați administratorul de {$PROD_NAME} pentru a instala software-ul de arhivare.",
    'skeleton__client_page' => "Administrare șablon de găzduire virtuală",
    'skeleton__archive_corrupted' => "La verificarea arhivei s-a constatat că fișierul arhivă este deteriorat sau este de un tip neacceptat.",
    'skeleton__archive_too_large' => "La verificarea arhivei s-a constatat că fișierul arhivă este prea mare.",
    'skeleton__not_supported_archive_type' => "Acest tip de arhivă (fișier %1) nu este acceptat.",
    'skeleton__upload_archive_file' => "Încărcare fișier arhivă",
    'skin_download__title' => 'Descărcare prezentare',
    'skin_download_now__title' => 'Desfășurarea descărcării de prezentare',
    'skin_download_now__text' => 'Crearea pachetului de prezentare este în desfășurare.<br>Procedura poate fi de durată.<br> După ce apare fereastra de dialog, nu puteți continua lucru cu Plesk.',
    'skin_file__help_for_using_types' => "Utilizați arhivele de prezentări în formatele următoare:",
    'skin_info__title' => 'Proprietăți prezentare',
    'skin_mng_err__rpm_not_skin' => 'Acest RPM nu este un pachet de prezentare Plesk',
    'skin_mng_err__psa_install_noreloc' => 'Instalarea prezentării rpm în locația specificată nu a reușit.',
    'skin_mng_err__already_exists' => 'Directorul de instalare pentru prezentări există deja. Deja a fost implementat un pachet de prezentări.',
    'skin_mng_err__rpm_upgrade_nonrpm' => 'Fișierul încărcat nu este un pachet de prezentări RPM corect.',
    'skin_mng_err__rpm_upgrade_noskin' => 'Fișierul încărcat nu este un pachet de prezentări corect.',
    'skin_mng_err__rpm_upgrade_base' => "Fișierul încărcat nu este un pachet de prezentări {$PROD_NAME} corect.",
    'skin_mng_err__rpm_upgrade_other' => 'Imposibil de instalat prezentarea: format incorect.',
    'skin_mng_err__no_a_skin' => "Fișierul încărcat nu este un pachet de prezentări {$PROD_NAME} corect.",
    'skin_upload__title' => 'Încărcare prezentare nouă',
    'skin_upload__already_exists' => "Prezentarea „%1” există deja.",
    'skin_upload__unable_to_apply' => "Fișierul încărcat nu conține o prezentare Plesk sau formatul arhivei nu este acceptat.",
    'skin_upload__unable_to_rename__' => "Imposibil de redenumit prezentarea %2 în %1: %3.",
    'skin_upload__file_name' => 'Calea către fișierul pachet de prezentări',
    'skins_list__title' => 'Depozit de prezentări',
    'skins_remove__title' => 'Ștergere prezentare',
    'skins_remove__select_skins_for_remove' => 'Selectați prezentările pe care doriți să le ștergeți',

    'spf__unable_update' => 'Imposibil de actualizat parametrii SPF',
    'sshterm__title' => 'Terminal SSH',
    'sshterm__password_authentication_warning' => 'Notă: Autentificarea prin parolă este dezactivată în configurația serverului SSH local. Dacă nu reușiți să vă conectați cu ajutorul Terminalului SSH, rugați administratorul de sistem să seteze opțiunea „PasswordAuthentication yes” în fișierul /etc/ssh/sshd_config.',
    'sshterm__password_authentication_warning_admin' => 'Notă: Autentificarea prin parolă este dezactivată în configurația serverului SSH local. Dacă nu reușiți să vă conectați cu ajutorul Terminalului SSH, setați opțiunea „PasswordAuthentication yes” în fișierul /etc/ssh/sshd_config.',
    'statistics__active_domains' => "Domenii active",
    'statistics__clients' => "Clienți",
    'statistics__subdomains' => "Subdomenii",
    'statistics__cpu' => "CPU",
    'statistics__databases' => "Baze de date",
    'statistics__db_users' => "Utilizatori de baze de date",
    'statistics__dirs' => "Directoare protejate",
    'statistics__dom_active' => "Activ",
    'statistics__dom_passive' => "Pasive",
    'statistics__dom_problem' => "Problemă",
    'statistics__domains' => "Domenii",
    'statistics__domains_with_host' => "Domenii cu găzduire",
    'statistics__doms' => "Domenii",
    'statistics__filesystem' => "Sistem de fișiere",
    'statistics__general' => "General",
    'statistics__hdd_available' => "Disponibil",
    'statistics__hdd_capacity' => "Capacitate",
    'statistics__hdd_total' => "Total",
    'statistics__hdd_usage' => "Utilizare hard disk",
    'statistics__hdd_used' => "Utilizat",
    'statistics__ip' => "Adresă IP",
    'statistics__key_number' => "Număr cheie",
    'statistics__l1' => "Ultimul minut",
    'statistics__l15' => "Ultimele 15 minute",
    'statistics__l5' => "Ultimele 5 minute",
    'statistics__la' => "Utilizare CPU",
    'statistics__mail_autoresponders' => "Răspunsuri automate",
    'statistics__mail_boxes' => "Căsuțe poștale",
    'statistics__mail_groups' => "Grupuri de e-mail",
    'statistics__mail_lists' => "Liste de e-mail",
    'statistics__mail_redirects' => "Redirecționări de e-mail",
    'statistics__mem' => "Utilizare memorie",
    'statistics__mem_usage' => "Utilizare",
    'statistics__memory_available' => "Disponibil",
    'statistics__memory_buffer' => "Buffer",
    'statistics__memory_cached' => "Cache",
    'statistics__memory_free' => "Gratuit",
    'statistics__memory_shared' => "Partajat",
    'statistics__memory_total' => "Total",
    'statistics__memory_used' => "Utilizat",
    'statistics__os' => "SO",
    'statistics__problem_clients' => "Clienți problematici",
    'statistics__problem_domains' => "Domenii cu probleme",
    'statistics__swap' => "Utilizare swap",
    'statistics__swap_free' => "Gratuit",
    'statistics__swap_total' => "Total",
    'statistics__swap_usage' => "Utilizare",
    'statistics__swap_used' => "Utilizat",
    'statistics__system_stat' => "Informații server",
    'statistics__unable_define_active_doms' => "Imposibil de determinat numărul de domenii active: %1",
    'statistics__unable_define_inactive_doms' => "Imposibil de determinat numărul de domenii inactive: %1",
    'statistics__failed_define_swap_usage' => 'Definirea utilizării de swap nu a reușit',
    'statistics__failed_define_load_averages' => 'Definirea încărcării medii nu a reușit',
    'statistics__up_time' => "Timp de funcționare sistem:",
    'statistics__ver' => "Versiune",
    'statistics__web_users' => "Utilizatori web",
    'statistics__mem_win' => "Utilizare memorie fizică",
    'statistics__memory_total_win' => "Total",
    'statistics__memory_used_win' => "Utilizat",
    'statistics__memory_free_win' => "Disponibil",
    'statistics__swap_win' => "Utilizare memorie virtuală",
    'statistics__swap_total_win' => "Total",
    'statistics__swap_used_win' => "Utilizat",
    'statistics__swap_free_win' => "Disponibil",
    'status__domain_has_reasons_to_be_off' => "Domeniul este în continuare suspendat din următorul motiv: %1",
    'subdomain__create__' => "Creare subdomeniu pentru domeniul %1",
    'subdomain__edit__' => "Administrare subdomeniu %1",
    'subdomain__invalid_name' => "Nume subdomeniu incorect: utilizați doar caractere alfanumerice și cratime.",
    'subdomain__incorrect_name' => "Nume subdomeniu incorect.",
    'subdomains__maillists_enabled_in_domain' => "Liste de nume de subdomenii incorecte. %1: acest nume de domeniu este deja utilizat de listele de e-mail din domeniul %1.",
    'subdomains__dalias_exists' => 'Deja există un alias de domeniu cu acest nume.',
    'subdomains__name_exists' => "Deja există un subdomeniu cu acest nume.",
    'subdomains__regular_domain_exists' => "Deja există un domeniu cu acest nume.",
    'subdomains__domain_alias_exists' => 'Deja există un alias de domeniu cu acest nume.',
    'subdomains__remove_subdomains_on_domain' => "Următoarele subdomenii din domeniul %1 vor fi șterse:",
    'subdomains__select_subdomains_for_remove' => "Selectați subdomeniile ce vor fi șterse.",
    'subdomains__webmail_enabled_in_domain' => "Nume de subdomeniu webmail incorect. %1: acest nume de domeniu este utilizat deja pentru accesarea e-mailului prin web în domeniul %1.",
    'subdomains__dns_record_already_exists' => 'Imposibil de creat subdomeniul %1: deja există o înregistrare DNS care indică gazda %1.',
    'subdomains__www_prefix_in_domain' => "Nume de subdomeniu incorect www.%1: domeniul %1 are deja prefixul WWW.",
    'subdomains__user_type_quota_exceeds' => 'Contul de utilizator nu poate fi modificat pentru că acesta ar depăși spațiul de disc alocat.',
    'subdomains__creation_in_dns_slave' => "Serverul de nume Plesk are rol de server de nume secundar pentru acest domeniu. În vederea rezolvării corecte a adresei subdomeniului, asigurați-vă că fișierul de zonă de pe serverul principal conține înregistrarea %1.",
    'sys_user__attributes_not_changed' => "Următoarele atribute ale utilizatorului de sistem nu au fost schimbate: %1",
    'sys_user__no_access_without_password' => "Nu ați setat nicio parolă. Se va crea un utilizator de sistem, dar nu se va putea autentifica în sistem, până când nu va primi o parolă. Continuați?",
    'sys_user__no_hard_quota' => "neacceptat",
    'sysuser__zero_quota_is_unlimited' => "0 pentru nelimitat",
    'template__num_excl_ips' => "Alocați clientului adrese IP dedicate",
    'template__sel_sh_ips' => "Adrese IP partajate selectate",
    'template__av_sh_ips' => "Adrese IP partajate disponibile",
    'template__up_to_excl_ip' => "Până la %1 adrese IP",
    'templates__all_clients' => "toți clienții",
    'templates__cl_domain_templates' => "Șabloane pentru %1",
    'templates__cl_templates' => "Șabloane de client",
    'time__invalid_ip' => "Valoarea incorectă pentru nume domeniu sau adresă IP.",
    '__please_select_country' => 'Selectați țara de proveniență',
    'time__unable_set_time' => "Imposibil de setat ora de sistem: %1",
    'time__sinchronization_setup_error' => 'Imposibil de configurat sincronizarea orei: timemng nu a reușit: %1',
    'time__sinchronization_disable_error' => 'Imposibil de dezactivat sincronizarea orei: timemng nu a reușit: %1',
    'tmpl__create' => "Creare șablon",
    'tmpl__edit__' => 'Șablon %1',
    'tmpl__logrotation_warn' => "Rotația fișierelor jurnal din domeniul creat prin acest șablon va avea loc doar în cazul creării ulterioare a unui cont de găzduire fizică pentru acesta.",
    'tmpl__name' => "Nume șablon",
    'tmpl__dom_exist' => "În lista de șabloane a administratorului sau a clientului există deja un șablon de domeniu cu acest nume.",
    'tmpl__name_invalid' => "Numele de șablon este gol sau incorect.",
    'tmpl__use_next_ip_addr' => "Se va utiliza următoarea adresă IP liberă",
    'tmpl_name_already_exists' => "Șablonul cu numele „%1” există deja.",
    'traffic__no_periods_found' => "Imposibil de afișat datele statistice despre web și trafic. Această funcție va fi disponibilă doar la următoarea procesare a statisticilor.",

    'vh_based__no_free_ip_for_vh' => "Nu există adrese IP libere pentru găzduirea virtuală pe bază de IP. Adăugați o adresă IP.",

    'wu__at_domains_text' => "Se acceptă formatul de acces utilizator_web@%1",
    'wu__unable_create' => "Imposibil de creat utilizatorul web: %1",
    'wu_edit__disk_quota' => "Cotă de disc",
    'wu_edit__invalid_pass' => "Parola este incorectă.",
    'wu_edit__invalid_quota' => "Valoarea cotei de spațiu pe disc este incorectă. Introduceți un număr întreg pozitiv.",
    'wu_edit__invalid_quota_value' => "Cota de spațiu pe disc specificată este mai mică decât spațiul utilizat în prezent (%1 MB). Este posibil ca unele funcții să nu mai fie disponibile. Sigur continuați?",
    'wu_edit__not_create_pass' => "Această operație nu va crea parolă pentru noul utilizator web. Fără parolă utilizatorul nu se va putea conecta.",
    'wu_edit__unable_update' => "Imposibil de actualizat proprietatea de utilizator web: %1",

    'bt_webdirs' => 'Directoare virtuale',

    'dns__tabs_general' => 'Setări de zonă',
    'dns__tabs_zone_settings' => 'Înregistrări SOA',
    'soa__seconds' => 'secunde',
    'soa__minutes' => 'minute',
    'soa__hours' => 'ore',
    'soa__days' => 'zile',

    'DomainSubdirectory' => 'Subdirector destinație',

    'filemanager__select_codepage' => 'Selectați pagina de codificare:',

    'bt_server_app_add' => 'Adăugare aplicație server',
    'packages_list' => 'Aplicații server',

    'bt_packages_management' => 'Administrarea pachetelor',
    'pb__packages_management' => 'Administrarea aplicațiilor',
    'bt_package_new' => 'Adăugare aplicație',
    '__packages' => 'Aplicații server',

    'dom_ctrl__mysql_dbase_space' => 'Cotă totală pentru bazele de date MySQL',
    'dom_ctrl__mssql_dbase_space' => 'Cotă totală pentru bazele de date MS SQL',

    'dns_add__enter_ixfr_path' => 'Introduceți calea IXFR',

    'cmd_dns__txt_dns_record_already_exist' => 'Înregistrarea SPF TXT există deja. Nu se admite decât o singură înregistrare SPF. Pentru a putea adăuga înregistrarea, ștergeți-o pe cea existentă.',

    'component_name__network' => 'Rețele',
    'component_name__sitebuilder' => 'Presence Builder',

    'bt_skin_set' => 'Setare prezentare',
    'bt_set_skin' => 'Setare prezentare',
    'firewall__rule_already_exists' => 'Regula cu numele „%1” există deja',
    'firewall__rule_readonly' => 'Regula „%1” este doar în citire',
    'pb__firewall' => 'Firewall',

    '__webstat_smarterstats' => 'SmarterStats',

    'error_doc__erorr_invalid_file_location' => 'Locația fișierului este incorectă.',

    'error_doc__erorr_invalid_url_location' =>  'Format de URL incorect. Introduceți URL-ul absolut pe gazda virtuală (site).',

    'mn_list__tab_title_antivirus' => 'AV',

    'bt_antivirus' => 'Antivirus',
    'antivirus__antivirus' => 'Protecție antivirus',
    'antivirus__antivirus_direction_off' => 'Oprit',
    'antivirus__antivirus_direction_any' => 'E-mailuri primite și trimise',
    'antivirus__antivirus_direction_from' => 'Doar e-mailuri trimise',
    'antivirus__antivirus_direction_to' => 'Doar e-mailuri primite',
    'antivirus__unable_to_update_settings' => 'Imposibil de modificat setările antivirus: %1',




    '__normal' => 'Normal',
    '__low' => 'Scăzut',
    '__high' => 'Ridicat',

    'mail__antivirus' => "Antivirusul de pe serverele interne",
    'mail__use_internal_antivirus' => 'Se utilizează antivirusul intern',

    'sa__tabs_blacklist' => 'Listă neagră',

    '__mysql_databases' => 'Baze de date MySQL',

    'cl_perm__mysql_dbase_space' => 'Cotă totală pentru bazele de date MySQL',
    'cl_perm__mssql_dbase_space' => 'Cotă totală pentru bazele de date MS SQL',
    'cl_perm__max_mssql_db' => 'numărul maxim de baze de date Microsoft SQL Server',
    'cl_perm__total_mboxes_quota' => 'Cota totală a căsuțelor poștale',

    'i_i_cl_on' => 'Contul client este activ.',
    'i_i_cl_off_by_admin' => 'Contul de client este suspendat de către administrator.',

    'sa_exists_tn' => 'Rețeaua este deja în listă.',

    'webdir__select_vdirs_to_remove' => 'Selectați directoarele pe care doriți să le ștergeți',
    'webdir__select_mime_types_to_remove' => 'Selectați tipurile MIME pe care doriți să le ștergeți',

    'defaultcomponents__not_activated' => 'neactivată',

    'bt_traffic_at_domains' => 'Trafic',

    '__awstats_perl_warning' => 'Dacă Perl nu este instalat, AWStats nu le va permite utilizatorilor să consulta statistici din anii anteriori.',

    'class_client__mysql_dbase_space' => 'Valoarea depășește limita clientului',
    'class_client__mssql_dbase_space' => 'Valoarea depășește limita clientului',
    'class_client__max_mssql_db' => 'Valoarea depășește limita clientului',

    'dns__remove_transfer_restrictions_list_items' => 'Următoarele rețele vor fi șterse din lista de control al accesului:',

    'bt_up' => "Sus",
    'bt_down' => "Jos",
    'virtualdir__type_default_doc_name_to_add' => 'Introduceți numele fișierului de adăugat în listă',
    'virtualdir__select_default_doc_to_remove' => 'Selectați fișierele pe care doriți să le ștergeți din listă',

    'bt_install_selected' => 'Instalarea cheilor de licență selectate', // SELECTED


    'dom_pref__the_domain_resolves_to_another_ip_address' => 'Rezolvarea numelui de domeniu are drept rezultat o altă adresă IP: (%1). Corectați setările DNS.',

    'mn_edit__mailbox_enable_if_mailgroup_enabled' => 'În prezent, serverul de e-mail nu acceptă activarea simultană a căsuței poștale și a grupurilor de e-mail. Apăsați OK pentru a activa căsuța poștală și a renunța la activarea grupurilor de e-mail. Apăsați Revocare pentru a lăsa totul nemodificat.',

    'mn_edit__mailgroup_enable_if_mailbox_enabled' => 'În prezent, serverul de e-mail nu acceptă activarea simultană a căsuței poștale și a grupurilor de e-mail. Apăsați OK pentru a activa grupurile de e-mail și a renunța la activarea căsuței poștale. Apăsați Revocare pentru a lăsa totul nemodificat.',

    'mysql_dbase_space_limit' => 'Limită de spațiu pentru baza de date MySQL',
    'mysql_dbase_usage' => 'Utilizarea spațiului în baza de date MySQL',
    'mssql_dbase_space_limit' => 'Limită de spațiu pentru baza de date Microsoft SQL Server',
    'mssql_dbase_usage' => 'Utilizarea spațiului în baza de date Microsoft SQL Server',

    '__statistics' => "statistici", //indirect

    'dns__soa_minimum_value_is_big' => 'Setarea unei valori TTL minime de peste 3 ore poate împiedica accesul la domeniu al anumitor administratori de domeniu. Se recomandă să setați o asemenea valoare numai dacă instituția de înregistrare insistă asupra acestui lucru.',

    'virusfilter__interface_not_available' => 'Nu este disponibil niciun filtru antivirus.',
    'virusfilter__none_virus_filter' => 'Niciunul',
    'virusfilter__mailname_status_text' => 'Antivirus (%1)',
    'virusfilter__status_none' => 'oprit',
    'virusfilter__status_any' => 'pentru mesajele primite și trimise',
    'virusfilter__status_outgoing' => 'numai pentru mesajele trimise',
    'virusfilter__status_incoming' => 'numai pentru mesajele primite',

    'visibility__adminonly' => 'Numai admin',
    'visibility__button_sets' => 'Controale',
    'visibility__control' => 'Faceți clic pentru a personaliza acest control.',
    'visibility__customization_footnote' => 'Faceți clic pe OK pentru a finaliza personalizarea acestui ecran.',
    'visibility__default' => 'Implicit',
    'visibility__export_note' => "Setările de personalizare pe care le-ați făcut sunt gata pentru a fi exportate. Se va descărca un script de shell pe computer. Pentru a aplica aceste setări pe un alt server Plesk, prin suprascrierea setărilor existente de administrare a interfeței, încărcați scriptul pe serverul respectiv și executați-l acolo. Rețineți: dacă ați făcut modificări în acest ecran, dar încă nu ați făcut clic pe OK, datele exportate nu vor conține ultimele modificări.",
    'visibility__hide' => 'Ascundere',
    'visibility__reset_all' => 'Resetare totală la valorile implicite',
    'visibility__reset_screen' => 'Restabilirea aspectului original al ecranului',
    'visibility__root_override_parse_error' => 'Eroare de sintaxă în fișierul %1, pe rândul %2.',
    'visibility__screen_title' => 'Administrare interfață',
    'visibility__set_billing_enabled' => 'Deconectare Manager de clienți și business',
    'visibility__set_cert_puchasing' => 'Ascunderea butoanelor de achiziție a certificatelor',
    'visibility__set_domain_registration' => 'Ascunderea butoanelor de înregistrare a domeniilor',
    'visibility__set_extras' => 'Ascunderea butoanelor pentru servicii suplimentare',
    'visibility__set_mail_bounce' => 'Ascunderea controalelor pentru mesajele de refuzare corespunzătoare adreselor de e-mail inexistente',
    'visibility__show' => 'Afișare',
    'visibility__show_toolbar' => 'Afișarea barei de instrumente pentru administrarea interfeței',
    'visibility__standby_footnote' => 'Faceți clic aici pentru a personaliza controalele din această pagină.',
    'visibility__standby_footnote_nocontrols' => 'Nu există controale personalizabile în această pagină.',

    'bt_mpc' => "MyPlesk.com",
    'sb__not_support_publishing_api' => "Componenta nu acceptă automatizarea publicării",

    'component_name__cphosting' => "Găzduire Plesk",

    'dom_pref__unable_set_up_total_mboxes_quota' => 'Serverul de e-mail actual nu acceptă configurarea cotelor pentru căsuțele poștale.',
    '__unable_get_total_mboxes_quota' => 'Serverul de e-mail actual nu acceptă configurarea cotelor pentru căsuțele poștale.',

    'install_prefix__parent_not_exists' => "Director părinte nu există.",

    'bt_change_version' => 'Modificare versiune',
    'aspdotnet__changeversion_title' => 'Selectarea versiunii ASP.NET',
    'pb__aspdotnet' => 'ASP.NET',

    '__check_all' => "Selectare totală",
    '__uncheck_all' => "Deselectare totală",

    'dns__editing_domain_controller_zone' => "Editarea înregistrărilor de zone DNS pentru controlerul de domeniu poate duce la probleme în funcționarea domeniului",

    'pb__interface_management' => "Administrare interfață",
    'interface_management__tabs_skins' => "Prezentări",
    'interface_management__tabs_interface_templates' => "Șabloane de interfață",
    'interface_management__tabs_locales' => "Limbi",
    'locales_list__title' => "Depozit de pachetele lingvistice",
    'locales_list__legend' => "Limbi disponibile",
    'locales_list__active_title' => "S",
    'locales_list__locale_title' => "Pachet lingvistic",
    'locales_list__lang_title' => "Limbă",
    'locales_list__country_title' => "Țară",
    'locales_list__used_title' => "Utilizat",

    'backup__suspend_warning_during_backup' => "Domeniul nu va fi disponibil în timpul procesului de creare a copiei de rezervă",
    'backup__suspend_warning_during_restore' => "Domeniul nu va fi disponibil în timpul procesului de restaurare",
    'backup__suspend_domain' => "Suspendare domeniu",

    'locales_list__mls_limit' => "Licența Plesk actuală permite utilizarea unui număr de %2 limbi. În acest moment aveți %1 limbi setate drept disponibile utilizatorilor. acest număr depășește limita stabilită prin licență. Selectați %2 limbi pe care doriți să le utilizați, apoi setați restul limbilor drept indisponibile: faceți clic pe pictogramele acestora în coloana „S”.",

    'bt_change_owner' => 'Atribuire proprietar nou',
    'chown__new_owner' => 'Noul proprietar',
    'chown__selected_domains' => 'Abonamente selectate',
    'chown__limits_legend' => 'Resurse',
    'chown__limit_name' => 'Nume resursă',
    'chown__limit_value' => 'Resurse alocate',
    'chown__limit_assigned_before' => 'Înainte de transfer',
    'chown__limit_assigned_after' => 'După transfer',
    'chown__error_limits' => "Transferul de abonament nu poate continua: acest abonament necesită mai multe resurse decât poate asigura furnizorul noului proprietar.",
    'chown__error_no_domains' => 'Transferul de abonament nu poate continua: nu s-a selectat niciun abonament sau abonamentele selectate aparțin deja utilizatorului țintă.',
    'chown__error_empty_ip_pool' => "Transferul de abonament nu poate continua: Domeniul de adrese IP al noului proprietar este gol. Asigurați-vă că furnizorul are cel puțin o adresă în domeniul său de adrese IP.",
    'chown__please_select_new_domain_owner' => 'Selectați noul proprietar al acestui abonament',
    'chown__old_ip_address' => 'Adresa IP curentă',
    'chown__new_ip_address' => 'Noua adresă IP',

    'chown__error_ssl_already_used' => "Suportul SSL/TLS este utilizat deja la următoarele adrese IP destinație: %1 Drept urmare, următoarele domenii cu suport SSL/TLS nu pot fi transferate: %2. Rezolvați problema și încercați din nou",
    'chown__sitebuilder_not_installed' => 'Presence Builder nu este instalat',
    'chown__domain_exclude_sitebuilder_not_installed' => 'Domeniul %1 nu poate fi transferat la un alt proprietar pentru că Presence Builder nu este instalat.',

    'backup__backup_time' => 'Ora creării copiei de rezervă',
    'backup__backup_time_hour' => 'ore',
    'backup__backup_time_minute' => 'minute',
    'backup__every' => 'în fiecare',
    'backup__day_of_month' => 'ziua din lună',

    'subdomain__select_hst_type' => 'Selectați tipul găzduirii pentru subdomeniu',
    'hst_sel__subdom_subfolder_hst' => 'Subdomeniu în subfolder',
    'subdomain__www_root_folder_not_exists' => 'Directorul de pornire al site-ului %1 nu există',
    '__site_home_dir' => 'Director de pornire al site-ului',
    'subdomain__aspnet_disabled_domain' => 'dezactivat de domeniu',

    'domains__remove_description' => 'Se vor șterge toate datele domeniului, inclusiv conținutul și setările domeniului și ale subdomeniilor sale, datele aplicațiilor web, conținutul căsuțelor poștale, setările de e-mail, antivirus și filtrare antispam, fișierele jurnal, datele din depozitul de copii de rezervă ale domeniu și certificatele SSL/TLS. Dacă nu aveți un fișier copie de rezervă pe computerul local, toate datele se vor pierde definitiv.',
    'subdomains__remove_description' => 'Se vor șterge toate datele subdomeniului, inclusiv conținutul și setările subdomeniului, datele aplicațiilor web și fișierele jurnal. Dacă nu aveți un fișier copie de rezervă pe computerul local, toate datele se vor pierde definitiv.',

    'mail__tabs_spam_filtering' => 'Filtrare antispam',
    'mail__tabs_antivirus' => 'Antivirus',
    'antivirus__use_server_settings_scan' => 'Se utilizează setările implicite la nivel de server (Scanare)',
    'antivirus__use_server_settings_no_scan' => 'Se utilizează setările implicite la nivel de server (Nu se scanează)',
    'antivirus__check_for_viruses' => 'Scanare antivirus',
    'antivirus__dont_check_for_viruses' => 'Nu se scanează',
    'antivirus__incoming_mail' => 'Doar e-mailuri primite',
    'antivirus__outgoing_mail' => 'Doar e-mailuri trimise',

    'domain_alias__CNAME_dns_record_exists' => 'Deja există o înregistrare DNS CNAME cu acest nume',
    'domain_alias__A_dns_record_exists' => 'Deja există o înregistrare DNS A cu acest nume',
    'domain_alias__bad_prefix' => 'Prefix incorect al aliasului de domeniu',
    'domain_alias__domain_doesnt_exist' => "Domeniul nu există",

    'dns__zone_ttl_message_info' => 'Dacă valoarea TTL nu este specificată, pentru această înregistrare DNS se va folosi valoarea TTL din șablonul de înregistrare SOA (%1).',

    '__webalizer_support' => 'Webalizer',
    '__awstats_support' => 'AWStats',
    '__smarterstats_support' => 'SmarterStats',

    'site_apps__make_default_warning_message' => "Se va crea un fișier denumit index.html pentru redirectarea la aplicația web selectată. Dacă deja există un fișier denumit index.html, se va crea o copie de rezervă a acestuia, denumită index.html.old, iar originalul va fi suprascris cu fișierul nou. Apăsați OK pentru a confirma",

    'bt_ftp_ctrl' => "Conturi FTP suplimentare",
    'ftp_users_no_permission' => "Nu aveți permisiunea de a administra conturile FTP din acest domeniu",
    'ftp_users_limit_reached' => "A fost atins numărul maxim de conturi FTP pentru acest domeniu",
    'pb__ftp_ctrl' => "Administrare FTP",
    'class_client__max_subftp_users' => "Conturi FTP suplimentare",

    '__client_form_settings' => "Setări client",
    '__sbnet_client_keep_sbnet' => "Se păstrează contul de utilizator corespunzător în Presence Builder",
    '__sbnet_cant_add_more_sites' => "S-a atins numărul limită de site-uri care pot utiliza Presence Builder, definit pentru acest client",
    '__sbnet_legend_text' => "Integrare Presence Builder",
    '__sbnet_synchronize_user_with_sbnet' => "Crearea unui cont de utilizator corespunzător în Presence Builder",
    '__sbnet_client_warning_delete_sb_user' => "Tocmai încercați să ștergeți contul de utilizator Presence Builder asociat acestui client. Această operație va duce la ștergerea din sistemul Presence Builder a tuturor site-urilor utilizatorului și a tuturor celorlalte setări conexe. Drept urmare, utilizatorul nu va mai putea edita site-urile existent prin Presence Builder, nici măcar dacă ulterior reactivați această opțiune. Dacă ulterior creați din nou un cont de utilizator Presence Builder, va trebui să creați și să publicați toate site-urile pornind de la zero. Dezactivați crearea și publicarea de site-uri web prin Presence Builder?",
    'sb__build_site_with_subdomains' => "Crearea subdomeniilor de blog și galerie foto",
    '__sbnet_client_dont_have_sbuser' => "Imposibil de creat și publicat site-ul cu Presence Builder: utilizatorul Presence Builder nu există",

    '__component_disabled' => "Componentă oprită",

    'subdomains__physical_path_not_exist' => "Există subdomenii legate de foldere fizice inexistente",

    'dnsserver_bind_to_msdns_switching_warning' => "Avertizare: se vor transfera doar primele 254 de adrese IP de subrețele cu măști /8 și /16 din lista de control al accesului. Acestea vor fi transferate ca adrese IP separate. Continuați?",

    '__sbnet_net_framework_required_for_site' => "Site-urile Presence Builder pot necesita suport ASP.NET 2.0 în domeniu. Dacă utilizați Presence Builder, vă recomandăm să activați suportul ASP.NET 2.0.",

    'subdomain_auto_create_dir' => "Creare director fizic pentru subdomeniu",

    'sa_trainer__unable_to_get_messages_list' => "Imposibil de obținut lista de mesaje din căsuța poștală: %1",
    'sa_trainer__pass_doesnt_exist' => "Lipsește parola corespunzătoare acestui cont",

    '__sitebuilder_error' => "Eroare în timpul încercării de conectare la Presence Builder. Contactați furnizorul de servicii pentru a primi asistență.",
    'wsb_error_user_not_exist' => "Contul de utilizator Presence Builder nu există.",
    'wsb_error_site_already_exist' => "Site-ul există deja în Presence Builder.",
    'wsb_error_site_limit_reached' => "A fost atins numărul limită de site-uri Presence Builder.",
    'wsb_error_internal_error' => "Eroare internă în Presence Builder. Contactați furnizorul de servicii pentru a primi asistență.",
    'wsb_error_user_already_exist' => "Deja există un utilizator cu acest nume în Presence Builder.",
    'sb_error_user_not_exist' => "Presence Builder nu există.",
    'wsb_error_object_not_found' => "Presence Builder nu a găsit intrarea de gazdă corectă.",

    'mg_no_mail_groups' => "Niciun grup de e-mail",

    'drweb__drweb_incoming' => 'Verificarea antivirus a e-mailurilor primite',
    'drweb__drweb_outgoing' => 'Verificarea antivirus a e-mailurilor trimise',
    'drweb__disable_reason_serv' => 'Serverul de e-mail nu acceptă setările de filtrare antivirus la nivel de căsuță poștală',

    'vz_sitebuilder3_client_cant_be_created' => "Imposibil de creat contul de client: Nu aveți instalat SiteBuilder 3.1 sau o versiune mai recentă",

    'chown__client_without_sitebuilder_support' => "Transferul de abonament nu poate continua: Serviciul Presence Builder nu este inclus în planul de servicii al noului proprietar sau al furnizorului său.",

    // new limits

    'class_client__max_odbc' => "Conexiuni ODBC",
    'cl_perm__max_odbc' => "numărul maxim de conexiuni ODBC",

    // domain aliases DNS
    'domain_alias__list_status' => 'S',
    'domain_alias__list_name' => 'Denumire alias de domeniu',
    'domain_alias__list_ascii_name' => 'În format ASCII',


    // Interface Customization Templates
    'interface_preferences' => 'Administrare interfață',
    'pb__interface_templates' => 'Administrare interfață',
    'pb__interface_clients' => 'Clienți care utilizează %1',

    // service management
    'bt_service_showall' => "Afișare totală",
    'bt_service_hideall' => "Ascundere totală",
    'bt_service_start' => "Pornire",
    'bt_service_stop' => "Oprire",
    'bt_service_restart' => "Repornire",
    'bt_service_disable' => "Dezactivare",
    'bt_service_manual' => "Manual",
    'bt_service_auto' => "Auto",
    'comp_info__statup_type' => 'Tip de pornire',
    'service_startup_auto' => 'Automat',
    'service_startup_manual' => 'Manual',
    'service_startup_disabled' => 'Oprit',
    'service_action_ok' => "Operația cu serviciul %1 s-a terminat cu succes",
    'service_action_failed_disabled_service' => "Imposibil de finalizat operația cu serviciul %1, pentru că acesta este dezactivat",
    'service_action_failed_error' => "Imposibil de finalizat operația: %1",
    'service_group_action_ok' => "Operația s-a terminat cu succes cu următoarele servicii: %1",
    'service_group_action_disabled' => "Imposibil de finalizat operația cu următoarele servicii, pentru că sunt dezactivate: %1",
    'service_group_action_failed' => "Imposibil de finalizat operația cu următoarele servicii: %1 Pentru a primi informații detaliate despre eroare, executați operația separat cu fiecare serviciu",

    // php 4vs5
    'bt_php' => "Setări PHP",

    // Mass mail

    'massmail__resellers_list_available_for_select' => 'Resellerii disponibili',
    'massmail__resellers_list_selected' => 'Resellerii selectați',
    'massmail__clients_list_available_for_select' => 'Clienți disponibili',
    'massmail__clients_list_selected' => 'Clienți selectați',
    'massmail__advanced' => 'Avansat',
    'bt_massmail_send' => 'Trimitere',
    'massmail__save_template_name' => 'Salvarea textului într-un șablon nou, cu numele',
    'massmail__template' => 'Șablon',
    'massmail__compose_mail' => 'Mesaj',
    'massmail__from' => 'De',
    'massmail__to' => 'Către',
    'massmail__subject' => 'Subiect',
    'massmail__body' => 'Textul mesajului',
    'massmail__body_hint' => 'Se utilizează variabila <name> pentru a insera automat numele de utilizator în mesaj.',
    'massmail__send_to_clients' => "Clienți",
    'massmail__send_to_domainusers' => "Administratori de domeniu",
    'massmail__send_to_admins' => "Administratori Plesk",
    'massmail_select' => 'Selectați adresele',
    'massmail_showhide_selected' => "Afișarea/ascunderea elementelor selectate",
    'massmail_send_all' => "Toate",
    'massmail_send_selected' => "Doar cele selectate",
    'massmail_send_except' => "Toate, cu excepția celor selectate",
    'bt_new_mass_mail_template' => "Adăugare șablon de e-mail în masă",
    '__mass_mail_templates_list' => "Lista șabloanelor de mesaje e-mail în masă",
    'massmail__template_name' => 'Nume șablon',
    'massmail__receivers' => 'Destinatari',
    'massmail__created' => 'Expeditor',
    'massmail__date_created' => 'Data creării',
    'massmail__compose' => 'Trimitere',
    'mass_mail__resellers_all' => 'Toți resellerii',
    'mass_mail__clients_all' => 'Toți clienții',
    'mass_mail__domainusers_all' => 'Toți administratorii de domeniu',
    'mass_mail__resellers_selected' => 'Resellerii selectați',
    'mass_mail__clients_selected' => 'Clienți selectați',
    'mass_mail__domainusers_selected' => 'Administratorii de domeniu selectați',
    'mass_mail__resellers_except' => 'Toți resellerii, cu excepția celor selectați',
    'mass_mail__clients_except' => 'Toți clienții, cu excepția celor selectați',
    'mass_mail__domainusers_except' => 'Toți administratorii de domeniu, cu excepția celor selectați',
    'mass_mail__admins_all' => 'Toți administratorii',
    'massmailtemplateslist__title' => 'Șabloane de mesaje e-mail în masă',
    'massmail__insert_from_template' => "Inserare dată din șablon",
    'massmail__select_template' => "Selectare șablon",
    'massmail__body_short_hint' => "(doar text simplu)",
    'massmail__from_short_hint' => "(adresă de e-mail sau nume)",
    'bt_insert' => "Inserare",
    'massmail__mail_send_successfully' => "Mesajul a fost trimis cu succes",
    'massmail__mail_send_successfully_with_some_errors' => "Mesajul a fost trimis, dar au apărut mai multe erori. Este posibil ca unii dintre destinatari să nu primească mesajul. Pentru mai multe informații, consultați fișierul jurnal: %plesk_dir%\\admin\\logs\\send_mass_mail.log",
    'massmail__mail_send_failed' => "Mesajul nu a fost trimis. Asigurați-vă că ați selectat cel puțin un destinatar și că serverul de e-mail Plesk funcționează corect. Pentru mai multe informații, consultați fișierul jurnal: %plesk_dir%\\admin\\logs\\send_mass_mail.log",
    'massmail__template_data_inserted' => "Datele din șablonul %1 au fost inserate cu succes.",
    'massmail__template_added_successfully' => "Șablonul de mesaj a fost salvat cu numele %1.",

    // wsb integration
    'wsb_error_sitebuilder_database_error' => "Eroare de bază de date în Presence Builder. Contactați furnizorul de servicii pentru a primi asistență.",
    'wsb_error_sitebuilder_access_denied_error' => "Imposibil de accesat fișierul: Presence Builder nu are drepturi de acces la fișierul sau la folderul obligatoriu. Contactați furnizorul de servicii pentru a primi asistență.",
    'wsb_error_sitebuilder_connection_failed' => "Imposibil de conectat la Presence Builder: conexiunea s-a pierdut. Contactați furnizorul de servicii pentru a primi asistență.",
    'wsb_error_critical_during_operation' => "Eroare critică în Presence Builder: %1",
    'wsb_error_license_during_operation' => "Eroare de licență în Presence Builder: %1",
    'wsb_error_during_operation' => "Eroare în Presence Builder: %1",
    'wsb_error_license_error' => "A apărut o limitare prin licență în Presence Builder.",

    // Other
    '__confrim_service_stop' => "Avertisment! Dacă opriți serviciul %1, Plesk poate înceta să funcționeze. Sigur opriți serviciul %1?",
    'virtualdir__name_is_reserved' => "Acest nume este rezervat",
    'index_redirect_help_text' => 'Acum veți fi redirecționat automat la pagina site-ului corespunzător. Dacă browserul nu acceptă redirecționarea, faceți clic %1 aici %2',
    'bt_default_settings' => "Restabilirea valorilor implicite",
    'logfiles__remove_failed' => "Imposibil de șters fișierul %1: acesta este blocat de o altă aplicație. Încercați mai târziu",
    'subdomain__invalid_homedirectory' => "Directorul de pornire specificat pentru subdomeniu este incorect",
    'scheduler_item__empty_filename' => "Specificați fișierul executabil de rulat",
    'subdomains__overlapped_domain_exists' => 'Zona DNS a domeniului %1 se suprapune cu subdomeniul',
    'subdomains__overlapped_domain_alias_exists' => 'Zona DNS a aliasului de domeniu %1 se suprapune cu subdomeniul',
    'services_action_none_selected' => 'Imposibil de finalizat operația: selectați serviciile necesare',
    'cl_perm__max_subftp_users' => "numărul maxim de conturi FTP suplimentare",
    'login_up__access_denied_no_cp_access' => 'Acces interzis. Nu aveți permisiunea de a accesa Plesk.',
    'drweb__disable_reason_admin' => "Setările de filtru antivirus la nivel de căsuță poștală nu sunt permise de politica de server.",

    'webdirs__name_is_invalid' => 'Un nume de director nu poate conține decât litere, cifre, cratime și caractere de subliniere.',
    'webdirs__physical_path_is_invalid' => 'Calea fizică este incorectă sau nu există',
    '__use_default' => 'Se utilizează setarea implicită',
    'odbc__dsn_list_legend' => 'Conexiuni DSN ODBC',

    'webalizer_hidden_referrer__already_exist' => 'Deja există o asemenea intrare.',
    'webalizer_group_referrer__already_exist' => 'Deja există o sursă de referință de grup cu acest nume.',

    'pb__dashboard' => 'Pagina de pornire',

    'server_interface__page_title' => 'Setări de interfață server',
    'server_interface__tabs_locales' => 'Limbi',
    'server_interface__tabs_skins' => 'Prezentări',
    'server_interface__tabs_interface_templates' => 'Șabloane de interfață',
    'bt_server_interface' => 'Preferințe de interfață',
    'pb__server_interface' => 'Preferințe de interfață',

    'bt_wizard_next' => 'Următorul>>',
    'bt_wizard_prev' => '<< Înapoi',

    '__limit_exceeded_max_dom_server' => 'Nu puteți găzdui mai multe domenii pe acest server, pentru că a fost atins numărul limită de domenii care se pot crea pe server conform cheii de licență. Contactați furnizorul de servicii pentru a rezolva problema.',
    '__limit_exceeded_max_subdom_server' => 'Nu puteți găzdui mai multe subdomenii pe acest server. Contactați furnizorul de servicii.',
    '__limit_exceeded_max_dom_aliases_server' => 'Nu puteți configura mai multe aliasuri de domeniu pe acest server. Contactați furnizorul de servicii.',
    '__limit_exceeded_max_wu_server' => 'Nu mai puteți crea utilizatori web pe acest server, pentru că a fost atins numărul limită de utilizatori web care se pot crea pe server conform cheii de licență. Contactați furnizorul de servicii pentru a rezolva problema.',
    '__limit_exceeded_max_mn_server' => 'Nu puteți crea mai multe conturi de e-mail pe acest server, pentru că a fost atins numărul limită de asemenea conturi care se pot crea pe server conform cheii de licență. Contactați furnizorul de servicii pentru a rezolva problema.',

    '__limit_exceeded_max_cl_useradmin' => 'Ați atins numărul limită de conturi client, definit de cheia de licență (%2)',
    '__limit_exceeded_max_dom_useradmin' => 'Ați atins numărul limită de domenii, definit de cheia de licență (%2)',
    '__limit_exceeded_max_subdom_useradmin' => 'Ați atins numărul limită de subdomenii, definit de cheia de licență (%2)',
    '__limit_exceeded_max_dom_aliases_useradmin' => 'Ați atins numărul limită de aliasuri de domeniu, definit de cheia de licență (%2)',
    '__limit_exceeded_disk_space_useradmin' => 'Nu aveți spațiu liber pe disc',
    '__limit_exceeded_max_wu_useradmin' => 'Ați atins numărul limită de conturi de utilizatori web, definit de cheia de licență (%2)',
    '__limit_exceeded_max_db_useradmin' => 'Ați atins numărul limită de baze de date, definit de cheia de licență (%2)',
    '__limit_exceeded_max_box_useradmin' => 'Ați atins numărul limită de căsuțe poștale, definit de cheia de licență (%2)',
    '__limit_exceeded_max_mn_useradmin' => 'Ați atins numărul limită de conturi de e-mail, definit de cheia de licență (%2)',
    '__limit_exceeded_max_maillists_useradmin' => 'Ați atins numărul limită de liste de e-mail, definit de cheia de licență (%2)',

    '__limit_exceeded_max_dom_userclient' => 'Ați atins numărul limită de domenii (%2)',
    '__limit_exceeded_max_subdom_userclient' => 'Ați atins numărul limită de subdomenii (%2), permis de furnizorul de servicii',
    '__limit_exceeded_max_dom_aliases_userclient' => 'Ați atins numărul limită de aliasuri de domeniu (%2)',
    '__limit_exceeded_disk_space_userclient' => 'Ați atins limita de utilizare a spațiului pe disc (%2)',
    '__limit_exceeded_max_traffic_userclient' => 'Ați atins limita lunară de utilizare a lățimii de bandă (%2)',
    '__limit_exceeded_max_wu_userclient' => 'Ați atins numărul limită de conturi de utilizator web (%2), permis de furnizorul de servicii.',
    '__limit_exceeded_max_db_userclient' => 'Ați atins numărul limită de baze de date (%2)',
    '__limit_exceeded_max_box_userclient' => 'Ați atins numărul limită de căsuțe poștale (%2)',
    '__limit_exceeded_max_maillists_userclient' => 'Ați atins numărul limită de liste de e-mail (%2)',
    '__limit_exceeded_expiration_userclient' => 'Contul dvs. a expirat pe %2',

    '__limit_exceeded_max_subdom_userdomain' => 'Ați atins numărul limită de subdomenii (%2), permis de furnizorul de servicii',
    '__limit_exceeded_max_dom_aliases_userdomain' => 'Ați atins numărul limită de aliasuri de domeniu (%2)',
    '__limit_exceeded_disk_space_userdomain' => 'Ați atins limita de utilizare a spațiului pe disc (%2)',
    '__limit_exceeded_max_traffic_userdomain' => 'Ați atins limita de lățime de bandă utilizată într-o lună (%2)',
    '__limit_exceeded_max_wu_userdomain' => 'Ați atins numărul limită de conturi de utilizator web (%2)',
    '__limit_exceeded_max_db_userdomain' => 'Ați atins numărul limită de baze de date (%2)',
    '__limit_exceeded_max_box_userdomain' => 'Ați atins numărul limită de căsuțe poștale (%2)',
    '__limit_exceeded_max_maillists_userdomain' => 'Ați atins numărul limită de liste de e-mail (%2)',
    '__limit_exceeded_expiration_userdomain' => 'Contul dvs. a expirat pe %2',

    'mmt__to_none' => 'Niciunul',
    'mmt__to_admin' => 'Administrator',
    'mmt__to_resellers_all' => 'Toți resellerii',
    'mmt__to_resellers_select' => 'Resellerii selectați',
    'mmt__to_resellers_select__available' => 'Resellerii disponibili',
    'mmt__to_resellers_except' => 'Toți resellerii, cu excepția celor selectați',
    'mmt__to_clients_all' => 'Toți clienții',
    'mmt__to_clients_select' => 'Clienți selectați',
    'mmt__to_clients_select__available' => 'Clienți disponibili',
    'mmt__to_clients_except' => 'Toți clienții, cu excepția celor selectați',

    'mmt__unable_send_empty_selection' => 'Imposibil de trimis mesajul în masă, nicio adresă de e-mail selectată.',
    'mmt__unable_send_to__' => 'Imposibil de trimis mesajul în masă către:',
    'mmt__unable_send_to_email' => '%1 <%2>',

    'sapp_error_validation_not_found' => 'Aplicația web nu poate fi validată deoarece fișierele necesare (%1) nu au fost găsite. Contactați reprezentantul departamentului de asistență tehnică.',
    'sapp_error_validation_spec_failed' => 'Aplicația web încărcată nu corespunde specificațiilor AppPacks: %1.',
    'sapp_error_validation_register' => 'Aplicația web din directorul „%1” nu poate fi înregistrată: %2 Trebuie să ștergeți aplicația web de pe server pentru că nu va funcționa corect.',

    'sapp__install_failed' => 'Instalarea aplicației web nu a reușit: %1',
    'sapp__install_res_failed' => 'Crearea resursei solicitate nu a reușit.',

    'server_preferences__subdomains_blog_and_photo' => 'În mod implicit se creează subdomeniile de blog și galerie foto',
    'plesk_key__blog_and_photo' => 'Posibilitatea de a administra starea implicită a casetelor de selectare Creare blog și Galerie foto',
    'ip_ctrl__cannot_make_exclusive_ip_with_more_than_one_client' => 'Imposibil de modificat tipul adresei IP în dedicat: adresa este atribuită mai multor utilizatori.',

    // 8.1.1

    '__write_modify_warning' => 'Dacă selectați și alte permisiuni de scriere/modificare, unele aplicații web vor funcționa corect, dar și riscurile de securitate vor crește semnificativ',
    '__write_modify_subdomain_warning' => 'Dacă selectați și alte permisiuni de scriere/modificare, unele aplicații web vor funcționa corect, dar și riscurile de securitate vor crește semnificativ',

    'phosting__php_incorrect_version_used' => "Au fost detectate probleme cu versiunea PHP. Pentru a le rezolva, bifați mai jos caseta de selectare corespunzătoare versiunii PHP corecte, apoi faceți clic pe OK. Pentru a dezactiva PHP în acest domeniu, faceți clic pe OK fără a selecta vreo versiune PHP.",
    'fp__mail_preferences' => 'Setări de e-mail',

    'mail__invalid_white_pattern' => 'Valoarea specificată este incorectă. Respectați următoarele formate: mail@exemplu.ro pentru adresele de e-mail, exemplu.ro pentru domenii.',
    'mail__invalid_black_pattern' => 'Valoarea specificată este incorectă. Respectați următorul format: mail@exemplu.ro pentru adresele de e-mail, exemplu.ro pentru domenii.',

    'resp_edit__reply_as_html' => 'Trimitere ca HTML',
    'exception__path_very_long' => "Calea este prea lungă. Asigurați-vă că aveți mai puțin de %1 caractere în cale.",

    // 8.2


    //SAPP
    'sapp_on' => 'Pornit',
    'sapp_off' => 'Oprit',
    'sapp_directive_aspect' => 'Obligatoriu',
    'sapp_databases_num' => 'Baze de date',
    'sapp_db_required' => 'Obligatoriu',
    'sapp_Required' => 'Obligatoriu',
    'sapp_Variant' => 'Variantă',
    'sapp_db_id' => 'ID bază de date',
    'sapp_db_id_type' => 'Tip BD (id: %1)',
    'sapp_db_id_min_version' => 'Versiune min. BD (id: %1)',
    'sapp_db_id_table_prefix' => 'Prefix tabel BD (id: %1)',
    'sapp_Default' => 'Valoare implicită',
    'sapp_apache_mod_req' => 'Modul Apache',
    'sapp_dbtype_not_installed' => 'nu este instalat',
    'sapp_apache_mod_not_installed' => 'nu este instalat',
    'sapp__value_error_empty' => 'Valoare necompletată nu este permisă.',
    'sapp_error_invalid_type' => 'Aplicația „%1” nu acceptă acțiunea solicitată.',
    'sapp_error_unknown_app_type' => 'Tip de aplicație neacceptat: %1.',
    'sapp__ssl_text' => 'Instalați aplicația pe gazdă virtuală „http://„ sau „https://”?',
    'sapp__app_to_upgrade' => 'Aplicații la care se va face upgrade',
    'sapp__upgrade_apps_title' => 'Upgrade de aplicații',
    'sapp__upgrade_to_ver' => 'Upgrade la versiunea',
    'sapp__choose_pkg_ver' => 'Selectați un pachet...',
    'sapp__pkg_cant_upgrade_pkg' => 'Pachetul „%1” nu poate fi utilizat pentru a face upgrade la aplicația web „%2”.',
    'sapp__app_ugrade_error' => 'Imposibil de făcut upgrade la aplicația: %1. Contactați administratorul de sistem.',
    'sapp__no_suitable_db_found' => 'Nu s-a găsit nicio bază de date corespunzătoare.',
    'sapp__upgrade_success' =>  'S-a făcut upgrade cu succes la aplicația.',
    'sapp__pkg_info_changelog' => 'Istoricul modificărilor',
    'sapp_requirement_legend' => 'Caracteristici de găzduire necesare pentru aplicație',

    // other
    'odbc__mssql_wsid' => 'ID stație de lucru',
    'odbc__mssql_driver' => 'Driver',
    'bt_apply' => 'Aplicare',
    'mn_edit__add_alias_if_mailbox_disabled' => 'Pentru a crea un alias de e-mail, căsuța poștală trebuie să fie activată în acest cont de e-mail. Activați căsuța poștală?',
    'mn_edit__mailbox_disable_if_has_alias' => 'Dezactivarea căsuței poștale va duce la ștergerea aliasurilor de e-mail, întrucât acestea vor înceta să funcționeze. Dezactivați căsuța poștală?',
    'odbc__mysql_driver' => 'Driver ODBC MySQL',
    'antivirus__disable_reason_install' => 'Nu puteți administra antivirusul pentru că nu este instalat.',
    'antivirus__disable_reason_key' => 'Nu puteți administra antivirusul pentru că nu este activat cu o cheie de licență corectă.',
    'antivirus__disable_reason_deny_personal_settings' => 'Nu puteți administra antivirusul pentru că politica de server interzice setările antivirus individuale.',
    'component_name__sqladminmssql' => 'Microsoft SQL Webadmin',
    'change_foreign_user_password' => 'Schimbare parolă',
    'change_foreign_user_password_hint' => "Utilizatorul nu aparține acestei aplicații. Faceți clic pe link pentru a trece la o altă aplicație și a modifica parola utilizatorului în aceasta. Pentru a putea face acest lucru, trebuie să aveți drepturi corespunzătoare în aplicație.",
    'cf_url_text' => 'URL JDBC',
    'cf_sendStringParametersAsUnicode_text' => 'Format de șir de caractere',
    'lang_unknown' => 'Limbă necunoscută',
    'odbc__access_driver' => 'Driver',
    'odbc__access_pwd' => 'Parolă',
    'odbc__access_uid' => 'ID de conectare',
    'odbc__excel_driver' => 'Driver',
    'pb__cl_ed' => 'Detalii clienți',
    'pb__actionlog' => 'Jurnal de acțiuni',
    'pb__cl_limits' => 'Limite clienți',
    'pb__edit' => 'Editare',
    'pb__subdom_edit' => 'Setări de găzduire',
    'cf__select_dsn_to_remove' => 'Selectați cel puțin un DSN pentru a-l șterge',

    // NEW 8.3 FEATURES

    'backup_mail_content' => 'Crearea unei copii de rezervă cu conținutul căsuțelor poștale',

    'maillist_import_result' => "Număr total de adrese de e-mail în fișier: %1 numărul adreselor de e-mail importate : %2 numărul adreselor de e-mail existente: %3 numărul adreselor de e-mail dublate în fișierul specificat: %4 numărul adreselor de e-mail incorecte din fișier: %5",
    'maillist_import_error' => 'Imposibili de importat lista adreselor de e-mail',

    //  spaw

    'spaw__unable_to_edit_no_body' => "Fișierul pe care l-ați selectat este gol sau nu este un document HTML corect cu codificarea selectată. Selectați codificarea corectă sau adăugați conținut în fișier.",

    'dom_pref__external_mail_srv' => "Se redirecționează către un server de e-mail extern cu adresa IP:",
    'mn_edit__store_messages' => 'Căsuță poștală',

    // aps

    'sapp__before_upgrade_notice' => 'Se recomandă crearea unei copii de rezervă a aplicațiilor și a datelor de utilizator înainte de a porni procesul de upgrade.',
    'sapp__application_properties' => 'Proprietăți aplicație',
    'sapp__application_root_descr' => 'Pagina principală a aplicației',

    'sapp__aps_license_invalid_id' => 'Cheia de licență are ID incorect: %1.',
    'sapp__aps_lic_key_alredy_exists' => 'Licența cu numărul de cheie %1 există deja în baza de date.',
    'sapp__aps_lic_del_used' => 'Imposibil de șters cheia de licență: este utilizată de una dintre aplicațiile instalate.',
    'sapp__aps_lic_del_unknown' => 'Imposibil de șters cheia de licență: %1',
    'sapp__aps_cappi_duplicate' => "Această aplicație este deja în lista de aplicații a clientului",
    'sapp__appi_not_shared_no_install' => "Nu există asemenea aplicație în lista de aplicații a clientului. Dacă doriți să instalați această aplicație pe un site, întâi trebuie să o adăugați la lista de aplicații a clientului.",
    'sapp__appi_shared_not_client' => "Nu există asemenea aplicație în lista de aplicații a clientului. Dacă doriți să faceți upgrade acestei aplicații la versiunea specificată, întâi trebuie să adăugați versiunea la lista de aplicații a clientului.",
    'sapp__apply_license_script_not_found' => 'Imposibil de găsit scriptul „aplicare-licență” pentru această aplicație web.',
    'sapp__unable_to_activate_key' => 'Eroare la încercarea de activare a cheii de licență: %1',
    'sapp__unable_to_delete_ai_instances_exists' => 'Exista aplicații web instalate care necesită prezența acestei aplicații în sistem.',
    'sapp__unable_to_delete_ai_in_pool' => 'Această aplicație este în continuare în lista de aplicații a clientului. Dacă doriți să ștergeți această aplicație, întâi trebuie să o eliminați din toate listele de aplicații ale clienților sau să o faceți gratuită.',
    'sapp__unable_to_delete_app_template' => 'Imposibil de eliminat aplicația nr. %1: %2',
    'sapp__limit_exceeded_client' => 'Ați atins numărul limită de instalări ale acestei aplicații (%2).',


    // atis module

    '_week_on' => 'săptămână în',
    '__week_first' => 'prima',
    '__week_second' => 'a doua',
    '__week_third' => 'a treia',
    '__week_fourth' => 'a patra',
    '__week_last' => 'ultima',
    '__not_started' => 'În așteptare',
    '__started' => 'În execuție',
    '__cancel_pending' => 'Se revocă',
    '__canceled' => 'Revocat',
    '__error' => 'Eroare',
    '__done' => 'Terminat',

    '__php_cgi_handler' => 'Aplicație CGI',
    '__php_isapi_handler' => 'Extensie ISAPI',
    '__php_fastcgi_handler' => 'Aplicație FastCGI',
    '__php_module_handler' => 'mod_php',
    '__php_run_as' => 'executare ca',

    'cf_dbfolder_text' =>'Folder bază de date',
    'cf_isnewdb_text' => 'Creare bază de date',
    'cf_isnewdb_title' => 'Bifați caseta de selectare dacă baza de date trebuie creată',

    'pb__site_apps_upgrade' => 'Upgrade de aplicație web',

    'detach' => 'Deconectare',
    'preferences' => "Schimbare parolă",

    'toolsbar__switch_user?' => "Sigur vă conectați cu un alt cont de utilizator?",
    '__aps_left' => 'Instalări rămase',
    'aps__license_key' => 'Cheie de licență',
    'aps__download_code' => 'Descărcarea cheii de licențiere și a codului de activare',
    'aps__license_key_hint' => 'Preluare de pe serverul de licențiere folosind codul de activare',
    'aps__database_not_available' => 'nu este disponibilă, verificați limitele domeniului sau ale clientului',
    'aps__yes' => 'da',
    'aps__no' => 'nu',
    '__click_to_enlarge' => 'Faceți clic pentru a mări',
    'site_apps__back_to_list' => 'Revenire la listă',
    'sapp__pkg_info_installation_requirements' => 'Cerințe pentru instalare',
    '__close_window' => 'Închidere',

    //SAPP END

    'skin_info__already_default' => 'Prezentarea este setată deja ca implicită.',

    //move this to other file after splitting drweb to module
    'drweb:virus_filter_full_name' => 'Antivirus Plesk Premium',
    'drweb:properties_page_title' => 'Setări Antivirus Plesk Premium pentru %1',
    'drweb:properties_legend' => 'Setări',
    'drweb:status' => 'Verificarea antivirus a e-mailurilor',

    // sb integration
    'sitebuilder_wizard' => 'Expert Presence Builder',
    'dom_site_builder' => 'Faceți clic pentru a deschide Expertul Presence Builder.',
    'sb_plesk_admin_url' => 'URL-ul serverului Presence Builder. Asigurați-vă că această adresă poate fi rezolvată corect de DNS',
    'sb_plesk_admin_login' => 'Nume de utilizator pentru conectarea administratorului de server la Presence Builder',
    'sb_plesk_admin_password' => 'Parolă administrator',
    'sb_sitebuilder_preferences' => 'Acreditări de administrator Presence Builder',
    'sb__server' => 'Preferințele administratorului de sistem Presence Builder',
    'sb__sitebuilder_support' => 'Asistență Presence Builder',
    'sb_keep_sb_user' => 'Se păstrează contul de utilizator corespunzător în Presence Builder',
    'sb_create_sb_user' => 'Crearea unui cont de utilizator corespunzător în Presence Builder',
    'sb__build_site_using_sitebuilder' => "Crearea unui site web cu Presence Builder",
    'sb_no_current_sb_server_set' => 'Conexiunea la Presence Builder nu este configurată încă: trebuie să adăugați o înregistrare A în șablonul de zonă DNS, care să trimită la serverul Presence Builder.',
    'sb_unable_update_sb_server_sb_return_message' => "Imposibil de obținut informațiile din sistemul Presence Builder: %1",
    'sb_unable_connect_sb_wrong_con_params' => "Imposibil de conectat la Presence Builder: nume utilizator incorect sau parolă incorectă.",
    'sb_init_sb_manager' => "Inițializarea managerului Presence Builder: %1",
    'sb_err_couldnt_connect_sb' => "Conectarea la sistemul Presence Builder nu a reușit.",
    'sb_err_client_dont_have_sbuser' => "Acest client nu are cont de utilizator în Presence Builder.",
    'sb_err_sitebuilder_not_configured' => "Presence Builder nu este configurat.",
    'sb_err_you_dont_have_sbaccount' => "Autorizarea dvs. în Presence Builder nu a reușit.",
    'sb_error_critical_during_operation' => "Au apărut următoarele erori în Presence Builder: %1",
    'sb_err_sso_is_not_enabled' => "Suportul pentru sign-on unic nu este activat în Plesk.",

    'warning__super_zone_exist' => "Zona %1 a fost creată, dar acest nume de zonă este subzona unei alte zone existente, %2, care aparține altui utilizator, %3. Acest lucru este posibil, dar verificați dacă ați ales contul de utilizator corect.",
    'error__super_zone_exist' => "Imposibil de creat zona DNS: superzona acestuia aparține altui utilizator.",

    'locales__files_not_exits' => 'Imposibil de schimbat limba: fișierele pachetului lingvistic de interfață specificate nu există în sistem.',
    'locales__unavailable' => 'Imposibil de schimbat limba: pachetul lingvistic de interfață specificat nu este disponibil.',

    // DB BU

    'pb__dbbackup_list' => 'Fișiere cu copii de rezervă ale bazei de date',
    // server
    'dbbackup__server_backup_settings' => 'Copii de rezervă',
    'dbbackup__network_temp_dir' => 'Director temporar de rețea',
    'dbbackup__network_user' => 'Nume utilizator',
    'dbbackup__network_pass' => 'Parolă',
    // domain
    'dbbackup__add_database_legend' => 'Restaurare bazei de date pentru care s-a creat copie de rezervă',
    'dbbackup__add_database_restore' => 'Restaurarea bazei de date din fișierul copie de rezervă',
    'dbbackup__add_database_file' => 'Fișier cu copie de rezervă a bazei de date',
    'dbbackup__add_database_user' => 'Nume utilizator implicit',
    'dbbackup__add_database_pass' => 'Parolă implicită',
    'dbbackup__add_database_pass2' => 'Confirmare parolă implicită',

    'bt_dbbackup_now' => 'Creare copie de rezervă',

    'bt_repair' => 'Reparare',

    'dbbackup__mssql_dump_upload_not_allowed' => 'Încărcarea fișierelor dump de bază de date SQL Server este interzis de furnizorul de servicii de găzduire.',

    // APS categories

    'cf_invalid_password' => 'Lungimea parolei nu poate depăși 16 caractere',
    'cf_invalid_description_length' => 'Descrierea poate avea cel mult 256 simboluri',
    'ip_addr__ip_used_by_external_mail_server' => 'Adresa IP „%1” este utilizată deja de un server de e-mail extern',

    // 8.4.1

    '__ftp_login_is_invalid' => 'Numele de utilizator FTP sau parola nu sunt corecte. Specificați acreditări de utilizator FTP corecte.',

    // 8.6

    'dns__dns_serial_update_limit_warning' => 'S-a atins numărul maxim de modificări ale numărului serial. Astăzi nu se mai pot face modificări în zona DNS.',
    'dns__zone_apply_changes' => 'Modificările aduse înregistrărilor DNS nu au fost salvate încă. Modificările făcute sunt evidențiate mai jos. Faceți clic pe Actualizare pentru a aplica modificările zonei DNS sau faceți clic pe Restabilire pentru a abandona modificările.',
    'dns__update_dns_zone' => 'Faceți clic pentru a salva modificările aduse înregistrărilor DNS',
    'dns__revert_dns_zone' => 'Faceți clic pentru a revoca modificările aduse înregistrărilor DNS',
    'bt_revert' => 'Restabilire',
    'dns__dns_zone_has_beed_updated' => 'Modificările aduse înregistrărilor DNS au fost salvate.',
    'dns__dns_zone_has_beed_reverted' => 'Modificările aduse înregistrărilor DNS au fost revocate',
    'db__nondefault_server_not_allowed' => 'Nu este permisă utilizarea unui alt server de baze de date, decât a celui implicit',


    //// UI POINTER CAPTIONS START HERE
    ////
    // *** The strings below have been generated automatically from @@CAPTION directives.

    'ui__client__description' => 'Contul și domeniile clientului %1.',
    'ui__client__disabled-warning' => 'Contul clientului %1 este suspendat.',
    'ui__client__none-available' => 'Nu există niciun cont de client configurat.',
    'ui__client__short-title' => '%1',
    'ui__client__title' => 'Clientul %1',
    'ui__client_self__description' => 'Lista domeniilor mele.',
    'ui__client_self__short-title' => 'Domeniile mele',
    'ui__client_self__title' => 'Domeniile mele',


    'site_apps__non_removable' => 'Articole care nu pot fi șterse',
    'site_apps__non_removable_items' => 'Următoarele aplicații web nu pot fi șterse:',

    'ui__client/custom-buttons/custom-button__none-available' => 'Nu există butoane personalizate.',
    'ui__client/custom-buttons/custom-button__none-available__1' => 'Nu există butoane personalizate în Panoul de client al clientului %1.',

    'ui__client/custom-buttons/custom-button/delete__description' => 'Ștergerea butonului %1.',
    'ui__client/custom-buttons/custom-button/delete__short-title' => 'Ștergere',
    'ui__client/custom-buttons/custom-button/delete__title' => 'Ștergerea butonului %1',
    'ui__client/custom-buttons/custom-button/delete_multi__description' => 'Ștergerea butoanelor personalizate din Panoul de client al clientului',
    'ui__client/custom-buttons/custom-button/delete_multi__short-title' => 'Ștergere',
    'ui__client/custom-buttons/custom-button/delete_multi__title' => 'Ștergere butoane personalizate',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard-title' => 'Ștergere butoane',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard__1_unknown' => 'Selectați clientul ale cărui butoane personalizate doriți să le ștergeți, apoi faceți clic pe Următorul>>.',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard__3_multi' => 'Selectați butoanele pe care doriți să le ștergeți și apăsați Următorul >>.',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard__4_multi' => 'Confirmați ștergerea butoanelor prin bifarea casetei din această pagină, apoi faceți clic pe Terminare.',
    'ui__client/custom-buttons/custom-button/delete_unknown__description' => 'Ștergerea unui buton personalizat din Panoul de client al clientului.',
    'ui__client/custom-buttons/custom-button/delete_unknown__short-title' => 'Ștergere',
    'ui__client/custom-buttons/custom-button/delete_unknown__title' => 'Ștergerea unui buton personalizat',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard-title' => 'Ștergere buton personalizat',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard__1_unknown' => 'Selectați clientul al cărui buton personalizat doriți să îl ștergeți, apoi faceți clic pe Următorul>>.',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard__3_unknown' => 'Selectați butonul personalizat pe care doriți să îl ștergeți și faceți clic pe Următorul >>.',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard__4' => 'Confirmați ștergerea butonului personalizat prin bifarea casetei din acest ecran, apoi faceți clic pe Terminare.',

    'ui__client/custom-buttons/custom-button/properties__description' => 'Editarea proprietăților butonului la nivel de client %1.',
    'ui__client/custom-buttons/custom-button/properties__short-title' => 'Setări',
    'ui__client/custom-buttons/custom-button/properties__title' => 'Modificarea butonului personalizat al clientului %1',
    'ui__client/custom-buttons/custom-button/properties_new__wizard-title' => 'Adăugare buton personalizat',
    'ui__client/custom-buttons/custom-button/properties_new__wizard__1_unknown' => 'Selectați clientul în al cărui Panou de client doriți să creați butonul personalizat, apoi faceți clic pe Următorul>/>.',
    'ui__client/custom-buttons/custom-button/properties_new__wizard__4_new' => 'Faceți clic pe Terminare pentru a crea butonul.',
    'ui__client/custom-buttons/custom-button/properties_unknown__description' => 'Modificarea proprietăților unui buton din Panoul de client al clientului.',
    'ui__client/custom-buttons/custom-button/properties_unknown__short-title' => 'Proprietăți',
    'ui__client/custom-buttons/custom-button/properties_unknown__title' => 'Modificarea proprietăților unui buton din Panoul de client al clientului',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard-title' => 'Modificarea proprietăților butonului personalizat',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard__1_unknown' => 'Selectați clientul al cărui buton personalizat doriți să îl modificați, apoi faceți clic pe Următorul>>.',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard__3_unknown' => 'Selectați butonul personalizat pe care doriți să-l modificați și apăsați Următorul >>.',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard__4' => 'După ce ați terminat de editat proprietățile butonului faceți clic pe Terminare pentru a aplica schimbările și pentru a închide expertul.',

    'ui__client/custom-buttons/custom-button/toggle_private__description' => 'Setarea butonului personalizat %1 ca inaccesibil clienților.',
    'ui__client/custom-buttons/custom-button/toggle_private__short-title' => 'Butonul nu va fi accesibil clienților',
    'ui__client/custom-buttons/custom-button/toggle_private__title' => 'Setarea butonului personalizat %1 ca inaccesibil clienților',
    'ui__client/custom-buttons/custom-button/toggle_public__description' => 'Setarea butonului %1 drept vizibil pentru utilizatorii clientului.',
    'ui__client/custom-buttons/custom-button/toggle_public__short-title' => 'Butonul va fi accesibil clienților',
    'ui__client/custom-buttons/custom-button/toggle_public__title' => 'Setarea butonului %1 drept vizibil pentru utilizatorii clientului',
    'ui__client/custom-buttons/custom-button/toggle_unknown__description' => 'Setarea unui buton personalizat drept accesibil/inaccesibil clienților.',
    'ui__client/custom-buttons/custom-button/toggle_unknown__short-title' => 'Butonul va fi accesibil/inaccesibil clienților',
    'ui__client/custom-buttons/custom-button/toggle_unknown__title' => 'Setarea unui buton personalizat drept accesibil sau inaccesibil clienților',
    'ui__client/custom-buttons/custom-button/toggle_unknown__wizard-title' => 'Setarea unui buton personalizat drept accesibil/inaccesibil clienților.',
    'ui__client/custom-buttons/custom-button/toggle_unknown__wizard__1_unknown' => 'Selectați clientul al cărui buton personalizat doriți să îl faceți disponibil utilizatorilor clientului, apoi faceți clic pe Următorul>>.',
    'ui__client/custom-buttons/custom-button/toggle_unknown__wizard__3_unknown' => 'Selectați butonul personalizat pe care doriți să îl setați drept accesibil sau inaccesibil clienților, apoi faceți clic pe Următorul >>.',

    'ui__client/domain__description' => 'Administrarea domeniului %1.',
    'ui__client/domain__disabled-warning' => 'Domeniul %1 a fost suspendat.',
    'ui__client/domain__none-available' => 'Nu aveți niciun domeniu.',
    'ui__client/domain__none-available__1' => 'Contul %1 nu are niciun domeniu.',
    'ui__client/domain__none-available__2' => 'Contul %1 nu are niciun domeniu.',
    'ui__client/domain__short-title' => '%1',
    'ui__client/domain__title' => 'Domeniul %1',
    'ui__client/domain_self__description' => 'Administrarea domeniului dvs.',
    'ui__client/domain_self__disabled-warning' => 'Domeniul dvs. este suspendat.',
    'ui__client/domain_self__quick-search' => 'Domeniile mele',
    'ui__client/domain_self__short-title' => 'Domeniul meu',
    'ui__client/domain_self__title' => 'Domeniul meu',

    'ui__client/domain/custom-buttons/custom-button__none-available' => 'În Panoul de client al clientului nu a fost amplasat niciun buton personalizat.',
    'ui__client/domain/custom-buttons/custom-button__none-available__1' => 'Clientul %1 nu are butoane personalizate în Panoul de client.',
    'ui__client/domain/custom-buttons/custom-button__none-available__2' => 'Nu există butoane personalizate în domeniul %1.',
    'ui__client/domain/custom-buttons/custom-button/delete__description' => 'Ștergerea butonului personalizat %1.',
    'ui__client/domain/custom-buttons/custom-button/delete__short-title' => 'Ștergere',
    'ui__client/domain/custom-buttons/custom-button/delete__title' => 'Ștergerea butonului personalizat %1',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__description' => 'Ștergerea butoanelor personalizate.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__short-title' => 'Ștergere',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__title' => 'Ștergere butoane personalizate',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard-title' => 'Ștergere butoane personalizate',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__1_unknown' => 'Selectați clientul din al cărui panou de administrare a domeniului doriți să ștergeți butoanele, apoi faceți clic pe Următorul>>.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__2_unknown' => 'Selectați domeniul din al cărui panou de administrare doriți să ștergeți butoanele, apoi faceți clic pe Următorul >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__4_multi' => 'Selectați butoanele pe care doriți să le ștergeți și apăsați Următorul >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__5_multi' => 'Confirmați ștergerea butoanelor prin bifarea casetelor corespunzătoare, apoi faceți clic pe Terminare pentru a șterge butoanele și a închide expertul.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__description' => 'Ștergerea unui buton personalizat.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__short-title' => 'Ștergere',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__title' => 'Ștergerea unui buton personalizat',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard-title' => 'Ștergerea unui buton personalizat',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__1_unknown' => 'Selectați clientul din al cărui panou de administrare a domeniului doriți să ștergeți butonul personalizat, apoi faceți clic pe Următorul>>.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__2_unknown' => 'Selectați domeniul din al cărui panou de administrare doriți să ștergeți butonul, apoi faceți clic pe Următorul >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__4_unknown' => 'Selectați butonul personalizat pe care doriți să-l îndepărtați, apoi faceți clic pe Următorul >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__5' => 'Confirmați ștergerea butonului personalizat prin bifarea casetei, apoi faceți clic pe Terminare pentru a șterge butonul și a închide expertul.',

    'ui__client/domain/custom-buttons/custom-button/properties__title' => "Modificarea proprietăților butonului personalizat %1",
    'ui__client/domain/custom-buttons/custom-button/properties__short-title' => "Proprietăți",
    'ui__client/domain/custom-buttons/custom-button/properties__description' => "Modificarea proprietăților butonului personalizat %1 din Panoul de client.",

    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard-title' => 'Adăugare buton',
    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard__1_unknown' => 'Selectați clientul în al cărui Panou de client doriți să amplasați butonul, apoi faceți clic pe Următorul>>.',
    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard__2_unknown' => 'Selectați abonamentul în care doriți să modificați butonul, apoi faceți clic pe Următorul>>.',
    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard__5_new' => 'Faceți clic pe Terminare pentru a crea butonul și a închide expertul.',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__description' => "Modificarea proprietăților unui buton din Panoul de client.",
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__short-title' => 'Proprietăți',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__title' => 'Modificarea proprietăților unui buton din Panoul de client',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__wizard-title' => 'Modificare proprietăți buton',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__wizard__4_unknown' => "Selectați butonul personalizat ale cărui setări doriți să le modificați și faceți clic pe Următorul >>.",
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__wizard__5' => 'Când ați terminat de modificat proprietățile butonului, faceți clic pe Terminare pentru a aplica modificările și a închide expertul.',

    'ui__client/domain/custom-buttons/custom-button/toggle_private__description' => 'Setarea butonului personalizat %1 drept inaccesibil utilizatorilor de e-mail din acest domeniu.',
    'ui__client/domain/custom-buttons/custom-button/toggle_private__short-title' => 'Inaccesibil utilizatorilor de e-mail',
    'ui__client/domain/custom-buttons/custom-button/toggle_private__title' => 'Setarea butonului personalizat %1 drept inaccesibil utilizatorilor de e-mail din acest domeniu',
    'ui__client/domain/custom-buttons/custom-button/toggle_public__description' => 'Setarea butonului personalizat %1 drept vizibil utilizatorilor de e-mail din acest domeniu.',

    'ui__client/domain/custom-buttons/custom-button/toggle_public__short-title' => 'Accesibil utilizatorilor de e-mail din acest domeniu',
    'ui__client/domain/custom-buttons/custom-button/toggle_public__title' => 'Setarea butonului personalizat %1 drept vizibil utilizatorilor de e-mail din acest domeniu',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__description' => 'Setarea unui buton personalizat drept accesibil sau inaccesibil altor utilizatori.',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__short-title' => 'Accesibil/inaccesibil altor utilizatori',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__title' => 'Setarea unui buton personalizat drept accesibil sau inaccesibil utilizatorilor de e-mail',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__wizard-title' => 'Setarea unui buton personalizat drept accesibil sau inaccesibil altor utilizatori',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__wizard__2_unknown' => 'Selectați domeniul în care se va plasa comanda va fi plasată, apoi faceți clic pe Următorul >>.',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__wizard__4_unknown' => 'Selectați butonul pe care doriți să îl setați drept accesibil sau inaccesibil altor utilizatori, apoi faceți clic pe Următorul >>.',

    'ui__client/domain/delete__description' => 'Ștergerea domeniului %1.',
    'ui__client/domain/delete__short-title' => 'Ștergere',
    'ui__client/domain/delete__title' => 'Ștergerea domeniului %1',
    'ui__client/domain/delete_multi__description' => 'Ștergerea domeniilor.',

    'ui__client/domain/delete_multi__short-title' => 'Ștergere',
    'ui__client/domain/delete_multi__title' => 'Ștergere domenii',
    'ui__client/domain/delete_multi__wizard-title' => 'Ștergere domenii',
    'ui__client/domain/delete_multi__wizard__2_multi' => 'Selectați domeniile pe care doriți să le ștergeți, apoi faceți clic pe Următorul >>.',
    'ui__client/domain/delete_multi__wizard__3_multi' => 'Confirmați ștergerea domeniilor prin bifarea casetelor, apoi faceți clic pe Terminare pentru a le șterge și a închide expertul.',
    'ui__client/domain/delete_unknown__description' => 'Ștergerea unui domeniu.',
    'ui__client/domain/delete_unknown__short-title' => 'Ștergere',
    'ui__client/domain/delete_unknown__title' => 'Ștergere domeniu',
    'ui__client/domain/delete_unknown__wizard-title' => 'Ștergerea unui domeniu',
    'ui__client/domain/delete_unknown__wizard__2_unknown' => 'Selectați domeniul pe care doriți să-l ștergeți, apoi faceți clic pe Următorul >>.',
    'ui__client/domain/delete_unknown__wizard__3' => 'Confirmați ștergerea domeniului prin bifarea casetei, apoi faceți clic pe Terminare pentru a-l șterge și a închide expertul.',

    'ui__client/domain/hosting__none-available' => 'Nu există domenii cu găzduirea web configurată. Creați un domeniu și configurați găzduirea web pe acesta pentru a avea acces la această funcție.',
    'ui__client/domain/hosting__none-available__1' => 'Acest cont de utilizator nu are niciun domeniu cu găzduirea web configurată. Configurați găzduirea web în domeniul necesar pentru a beneficia de această funcție.',
    'ui__client/domain/hosting__none-available__2' => 'Găzduirea web nu este configurată pentru domeniul %1. Configurați găzduirea web în domeniul %1 pentru a beneficia de această funcție.',

    'ui__client/domain/hosting/file-manager_unknown__wizard-title' => 'Administrare fișiere și directoare proprii',
    'ui__client/domain/hosting/file-manager_unknown__wizard__2_unknown' => 'Selectați domeniul ale cărui fișiere doriți să le utilizați.',
    'ui__client/domain/hosting/file-manager_unknown__wizard__3/properties_phosting' => 'Găzduirea nu este configurată încă pentru domeniu. Configurați găzduirea fizică și faceți clic pe Următorul >> pentru a accesa managerul de fișiere.',
    'ui__client/domain/hosting/file-manager_unknown__wizard__3/properties_self-phosting' => 'Găzduirea nu este configurată încă pentru domeniul dvs. Configurați găzduirea fizică și faceți clic pe Următorul >> pentru a accesa managerul de fișiere.',
    'ui__client/domain/hosting/file-manager_unknown__wizard__4' => 'Când ați terminat lucrul cu fișiere și cu directoare, faceți clic pe Terminare pentru a închide expertul.',
    'ui__client/domain/hosting/file-manager_unknown__wizard__4_self' => 'Când ați terminat lucrul cu fișiere și cu directoare, faceți clic pe Terminare pentru a închide expertul.',

    'ui__client/domain/hosting/performance_readonly-unknown__wizard-title' => 'Vizualizarea setărilor de performanță a găzduirii',

    'ui__client/domain/hosting/performance_unknown__wizard-title' => 'Modificarea setărilor de performanță ale găzduirii web',
    'ui__client/domain/hosting/performance_unknown__wizard__2_readonly-unknown' => 'Selectați domeniul pentru care doriți să vizualizați setările de performanță a găzduirii, apoi faceți clic pe Următorul >>.',
    'ui__client/domain/hosting/performance_unknown__wizard__2_unknown' => 'Selectați domeniul pentru care doriți să configurați setările de performanță a găzduirii, apoi faceți clic pe Următorul >>.',
    'ui__client/domain/hosting/performance_unknown__wizard__4' => 'Reglați setările de performanță a găzduirii pentru domeniu, apoi faceți clic pe Terminare.',
    'ui__client/domain/hosting/performance_unknown__wizard__4_readonly' => 'Când ați terminat de vizualizat setările de performanță a găzduirii pentru domeniu, faceți clic pe Terminare.',
    'ui__client/domain/hosting/performance_unknown__wizard__4_readonly-self' => 'Când ați terminat de vizualizat setările de performanță a găzduirii pentru domeniul dvs., faceți clic pe Terminare.',
    'ui__client/domain/hosting/performance_unknown__wizard__4_readonly-unknown' => 'Când ați terminat de vizualizat setările de performanță a găzduirii pentru domeniu, faceți clic pe Terminare.',
    'ui__client/domain/hosting/performance_unknown__wizard__4_self' => 'Când ați terminat de configurat setările de performanță a găzduirii pentru domeniul dvs., faceți clic pe Terminare.',
    'ui__client/domain/hosting/performance_unknown__wizard__4_unknown' => 'Când ați terminat de configurat setările de performanță a găzduirii pentru domeniu, faceți clic pe Terminare.',

    'ui__client/domain/hosting/application#list_header__clients_number__title' => "Clienți",
    'ui__client/domain/hosting/application#list_header__description__title' => "Descriere",
    'ui__client/domain/hosting/application#list_header__items_number__title' => "Elemente",
    'ui__client/domain/hosting/application#list_header__name__title' => "Nume",
    'ui__client/domain/hosting/application#list_header__release__title' => "Nr. de lansare",
    'ui__client/domain/hosting/application#list_header__sort_by_clients_number__title' => "Sortare după clienți",
    'ui__client/domain/hosting/application#list_header__sort_by_description__title' => "Sortare după descriere",
    'ui__client/domain/hosting/application#list_header__sort_by_items_number__title' => "Sortare după elemente",
    'ui__client/domain/hosting/application#list_header__sort_by_name__title' => "Sortare după nume",
    'ui__client/domain/hosting/application#list_header__sort_by_release__title' => "Sortare după nr. de lansare",
    'ui__client/domain/hosting/application#list_header__sort_by_version__title' => "Sortare după versiuni",
    'ui__client/domain/hosting/application#list_header__title' => "Aplicații web",
    'ui__client/domain/hosting/application#list_header__version__title' => "Versiuni",

    'rpt_reseller_section_general' => 'General',
    'rpt_reseller_section_domains' => 'Domenii',
    'rpt_reseller_section_clients' => 'Clienți',
    'statistics__cl_active_domains' => "Domenii active",
    'rpt_reseller_cl_domains' => "Domenii",
    'rpt_reseller_cl_subdomains' => "Subdomenii",
    'by__cl_domains' => "domeniile clientului",
    'dom_ctrl__cl_mboxes' => "Căsuțe poștale",
    'rpt_reseller_cl_redirects' => "Redirecționări",
    'rpt_reseller_cl_mail_groups' => "Grupuri de e-mail",
    'rpt_reseller_cl_mail_resps' => "Răspunsuri automate",
    'rpt_reseller_cl_mail_lists' => "Liste de e-mail",
    'rpt_reseller_cl_web_users' => "Utilizatori web",
    'rpt_reseller_cl_data_bases' => "Baze de date",

    'statistics__active_clients' => 'Clienți cu abonamente active',
    'statistics__clients_active_domains' => 'Domenii active',
    'statistics__clients_doms' => 'Domenii',
    'statistics__cl_doms' => 'Domenii',
    '__clients_subdomains' => 'Subdomenii',
    '__clients_domains' => 'Domenii',
    'dom_ctrl__clients_mboxes' => 'Căsuțe poștale',
    'dom_ctrl__clients_redir' => 'Redirecționări',
    'dom_ctrl__clients_mg' => 'Grupuri de e-mail',
    'dom_ctrl__clients_resp' => 'Răspunsuri automate',
    'dom_ctrl__clients_maillists' => 'Liste de e-mail',
    'dom_ctrl__clients_wu' => 'Utilizatori web',
    'dom_ctrl__clients_db' => 'Baze de date',

    'dom_ctrl__cl_redir' => 'Redirecționări', // to resolve!
    'dom_ctrl__cl_mg' => 'Grupuri de e-mail', // to resolve!
    'dom_ctrl__cl_resp' => 'Răspunsuri automate', // to resolve!
    'dom_ctrl__cl_maillists' => 'Liste de e-mail', // to resolve!
    'dom_ctrl__cl_wu' => 'Utilizatori web', // to resolve!
    'dom_ctrl__cl_db' => 'Baze de date', // to resolve!

    'rpt_cl_section_clients' => 'Clienți',

    'rpt_admin_section_general' => 'General',
    'rpt_admin_section_resellers' => 'Reselleri',
    'rpt_admin_section_clients' => 'Clienți',
    'rpt_admin_section_personal_clients' => 'Clienți proprii',
    'rpt_admin_section_domains' => 'Domenii',
    'rpt_admin_section_personal_domains' => 'Domenii personale',

    'rpt_reseller_section_personal_domains' => 'Domenii personale',

    'ui__client/domain/toggle_unknown__wizard__2_unknown' => 'Selectați domeniul pe care doriți să-l suspendați sau să-l activați.',
    'ui__client/domain/toggle_unknown__wizard-title' => 'Suspendare sau activare domeniu',

    'ui__client/ip-pool__description' => 'Atribuirea și anularea atribuirii adreselor IP și a certificatelor SSL/TLS către clientul %1.',
    'ui__client/ip-pool__short-title' => 'Domeniu de adrese IP',
    'ui__client/ip-pool__title' => 'Domeniul de adrese IP al clientului %1',
    'ui__client/ip-pool_self__description' => 'Vizualizarea propriului domeniu de adrese IP.',
    'ui__client/ip-pool_self__short-title' => 'Domeniu de adrese IP',
    'ui__client/ip-pool_self__title' => 'Domeniul meu de adrese IP',
    'ui__client/ip-pool/properties__description' => 'Configurarea unui domeniu de adrese IP pentru clientul %1.',

    'ui__client/ip-pool/properties__short-title' => 'Domeniu de adrese IP',
    'ui__client/ip-pool/properties__title' => 'Configurare domeniu de adrese IP pentru clientul %1',
    'ui__client/ip-pool/properties_self__description' => 'Vizualizarea propriului domeniu de adrese IP.',

    'ui__client/ip-pool/properties_self__short-title' => 'Domeniul meu de adrese IP',
    'ui__client/ip-pool/properties_self__title' => 'Domeniul meu de adrese IP',
    'ui__client/ip-pool/properties_unknown__description' => 'Atribuiți sau anulați atribuirea adreselor IP și a certificatelor SSL/TLS contului de client.',
    'ui__client/ip-pool/properties_unknown__short-title' => 'Domeniu de adrese IP',
    'ui__client/ip-pool/properties_unknown__title' => 'Configurarea domeniului de adrese IP al clientului',
    'ui__client/ip-pool/properties_unknown__wizard-title' => 'Configurarea domeniului de adrese IP al clientului',
    'ui__client/ip-pool/properties_unknown__wizard__1_unknown' => 'Selectați clientul al cărui domeniu de adrese IP doriți să îl configurați.',
    'ui__client/ip-pool/properties_unknown__wizard__3' => 'Când ați terminat de configurat domeniul de adrese IP, faceți clic pe Terminare pentru a aplica modificările și a închide expertul.',


    'ui__client/limits_readonly-unknown__description' => 'Vizualizarea limitelor de resurse pentru un client.',
    'ui__client/limits_readonly-unknown__short-title' => 'Limite resurse',
    'ui__client/limits_readonly-unknown__title' => 'Vizualizarea limitelor de resurse pentru un cont de client',
    'ui__client/limits_readonly-unknown__wizard-title' => 'Vizualizarea sau modificarea limitelor de resurse pentru un client',

    'ui__client/limits_unknown__wizard-title' => 'Vizualizarea sau modificarea limitelor de resurse pentru un client',
    'ui__client/limits_unknown__wizard__1_readonly-unknown' => 'Selectați clientul dorit.',
    'ui__client/limits_unknown__wizard__1_unknown' => 'Selectați clientul dorit.',
    'ui__client/limits_unknown__wizard__2' => 'Pentru a aplica modificările, faceți clic pe Terminare.',
    'ui__client/limits_unknown__wizard__2_readonly' => 'Pentru a închide expertul, faceți clic pe Terminare.',
    'ui__client/limits_unknown__wizard__2_readonly-self' => 'Pentru a închide expertul, faceți clic pe Terminare.',
    'ui__client/limits_unknown__wizard__2_readonly-self-reseller' => 'Pentru a închide expertul, faceți clic pe Terminare.',

    'ui__client/permissions_unknown__wizard-title' => 'Vizualizarea sau modificarea permisiunilor unui client',
    'ui__client/permissions_unknown__wizard__1/properties_self' => 'Când ați terminat de vizualizat permisiunile, faceți clic pe Terminare pentru a aplica modificările și a închide expertul.',
    'ui__client/permissions_unknown__wizard__1_unknown' => 'Selectați clientul ale cărui permisiuni doriți să le vizualizați sau să le modificați.',
    'ui__client/permissions_unknown__wizard__2' => 'Când ați terminat de modificat permisiunile clientului, faceți clic pe Terminare pentru a aplica schimbările și a închide expertul.',

    'ui__client/preferences_unknown__wizard-title' => 'Editarea preferințelor clientului',
    'ui__client/preferences_unknown__wizard__1_unknown' => 'Selectați clientul al cărui preferințe legate de sesiuni și de interfață doriți să le administrați.',
    'ui__client/preferences_unknown__wizard__2' => 'Când ați terminat de modificat preferințele clientului, faceți clic pe Terminare.',
    'ui__client/preferences_unknown__wizard__2_self' => 'Când ați terminat de modificat propriile preferințe, faceți clic pe Terminare.',

    'ui__custom-buttons/custom-button__none-available' => 'Nu aveți butoane personalizate.',
    'ui__custom-buttons/custom-button/delete__description' => 'Ștergerea butonului personalizat %1.',
    'ui__custom-buttons/custom-button/delete__short-title' => 'Ștergere',
    'ui__custom-buttons/custom-button/delete__title' => 'Ștergerea butonului personalizat %1',
    'ui__custom-buttons/custom-button/delete_multi__description' => 'Ștergerea butoanelor personalizate.',

    'ui__custom-buttons/custom-button/delete_multi__short-title' => 'Ștergere',
    'ui__custom-buttons/custom-button/delete_multi__title' => 'Ștergere butoane personalizate',
    'ui__custom-buttons/custom-button/delete_multi__wizard-title' => 'Ștergere butoane personalizate',
    'ui__custom-buttons/custom-button/delete_multi__wizard__2_multi' => 'Selectați butoanele pe care doriți să le ștergeți.',
    'ui__custom-buttons/custom-button/delete_multi__wizard__3_multi' => 'Confirmați ștergerea butoanelor prin bifarea casetei, apoi faceți clic pe Terminare.',
    'ui__custom-buttons/custom-button/delete_unknown__description' => 'Ștergerea butoanelor personalizate.',
    'ui__custom-buttons/custom-button/delete_unknown__short-title' => 'Ștergere',
    'ui__custom-buttons/custom-button/delete_unknown__title' => 'Ștergere butoane personalizate',
    'ui__custom-buttons/custom-button/delete_unknown__wizard-title' => 'Ștergere butoane personalizate',
    'ui__custom-buttons/custom-button/delete_unknown__wizard__2_unknown' => 'Selectați butonul personalizat pe care doriți să îl ștergeți.',
    'ui__custom-buttons/custom-button/delete_unknown__wizard__3' => 'Confirmați ștergerea comenzii prin bifarea casetei, apoi faceți clic pe Terminare pentru a închide expertul.',
    'ui__custom-buttons/custom-button/properties__description' => 'Modificarea proprietăților butonului %1.',

    'ui__custom-buttons/custom-button/properties__short-title' => 'Proprietăți',
    'ui__custom-buttons/custom-button/properties__title' => 'Modificarea proprietăților butonului %1',

    'ui__custom-buttons/custom-button/properties_new__wizard-title' => 'Creare buton',
    'ui__custom-buttons/custom-button/properties_new__wizard__3_new' => 'Faceți clic pe Terminare pentru a crea butonul.',
    'ui__custom-buttons/custom-button/properties_unknown__description' => 'Schimbarea proprietăților unui buton personalizat.',
    'ui__custom-buttons/custom-button/properties_unknown__short-title' => 'Proprietăți',
    'ui__custom-buttons/custom-button/properties_unknown__title' => 'Schimbare proprietăți buton personalizat',
    'ui__custom-buttons/custom-button/properties_unknown__wizard-title' => 'Schimbare proprietăți buton personalizat',
    'ui__custom-buttons/custom-button/properties_unknown__wizard__2_unknown' => 'Selectați butonul personalizat ale cărui proprietăți doriți să le modificați.',
    'ui__custom-buttons/custom-button/properties_unknown__wizard__3' => 'Pentru a aplica modificările, faceți clic pe Terminare.',
    'ui__custom-buttons/custom-button/toggle_private__description' => 'Setarea butonului personalizat %1 drept accesibil sau inaccesibil altor utilizatori.',

    'ui__custom-buttons/custom-button/toggle_private__short-title' => 'Inaccesibil altor utilizatori',
    'ui__custom-buttons/custom-button/toggle_private__title' => 'Setarea butonului personalizat %1 drept inaccesibil altor utilizatori',
    'ui__custom-buttons/custom-button/toggle_public__description' => 'Setarea butonului personalizat %1 drept accesibil altor utilizatori.',

    'ui__custom-buttons/custom-button/toggle_public__short-title' => 'Accesibil altor utilizatori',
    'ui__custom-buttons/custom-button/toggle_public__title' => 'Setarea butonului personalizat %1 drept accesibil altor utilizatori',
    'ui__custom-buttons/custom-button/toggle_unknown__description' => 'Setarea butonului personalizat drept accesibil sau inaccesibil altor utilizatori.',
    'ui__custom-buttons/custom-button/toggle_unknown__short-title' => 'Accesibil sau inaccesibil altor utilizatori',
    'ui__custom-buttons/custom-button/toggle_unknown__title' => 'Setarea butonului personalizat drept accesibil sau inaccesibil altor utilizatori',
    'ui__custom-buttons/custom-button/toggle_unknown__wizard-title' => 'Setarea butonului personalizat drept accesibil sau inaccesibil altor utilizatori',
    'ui__custom-buttons/custom-button/toggle_unknown__wizard__2_unknown' => 'Selectați butonul personalizat pe care doriți să îl setați drept accesibil sau inaccesibil altor utilizatori, apoi faceți clic pe Următorul >>.',

    'ui__longtasks#list_header__name__title' => "Nume",
    'ui__longtasks#list_header__owner__title' => "Proprietar",
    'ui__longtasks#list_header__start_time__title' => "Ora creării",
    'ui__longtasks#list_header__status__title' => "Stare",
    'ui__longtasks#list_header__title' => "Sarcini",
    'ui__longtasks#list_header__finish_time__title' => "Ora finalizării",
    'ui__longtasks#task_list_legend__title' => "Sarcini",
    'ui__longtasks#tools_legend__title' => "Instrumente",
    'ui__longtasks__description' => "Administrare sarcini de fundal",
    'ui__longtasks__short-title' => "Sarcini de fundal",
    'ui__longtasks__title' => "Sarcini de fundal",
    'ui__longtasks/longtask/properties#current_operation__title' => "Operația curentă:",
    'ui__longtasks/longtask/properties#finish_time__title' => "Ora estimată a finalizării:",
    'ui__longtasks/longtask/properties#general_legend__title' => "General",
    'ui__longtasks/longtask/properties#owner__title' => "Sarcina începută de:",
    'ui__longtasks/longtask/properties#progress__title' => "Progres general:",
    'ui__longtasks/longtask/properties#start_time__title' => "Ora începerii sarcinii:",
    'ui__longtasks/longtask/properties#status_legend__title' => "Stare sarcină",
    'ui__longtasks/longtask/properties__description' => "Starea sarcinii de fundal și informații",

    'ui__longtasks/properties__description' => "Setări sarcini de fundal",
    'ui__longtasks/properties__short-title' => "Setări",
    'ui__longtasks/properties__title' => "Sarcini de fundal",

    // updated
    'ui__mass-mail/template#list_header__title' => 'Șabloane de mesaje e-mail în masă',
    'ui__mass-mail/template#list_header__name__title' => 'Nume șablon',
    'ui__mass-mail/template#list_header__from_email__title' => 'Expeditor',
    'ui__mass-mail/template#list_header__to__title' => 'Destinatari',
    'ui__mass-mail/template#list_header__subject__title' => 'Subiect',
    'ui__mass-mail/template#list_header__cdate__title' => 'Data creării',
    'ui__mass-mail/template#list_header__send__title' => 'Trimitere',

    'ui__mass-mail/template/properties__short-title' => '%1',
    'ui__mass-mail/template/properties__title' => 'Editare șablon de mesaje e-mail în masă',
    'ui__mass-mail/template/properties__description' => 'Editarea acestui șablon de mesaje e-mail în masă.',

    'ui__mass-mail/template/properties_unknown-new__short-title' => 'Adăugare șablon de e-mail în masă',
    'ui__mass-mail/template/properties_unknown-new__title' => 'Adăugare șablon de e-mail în masă',
    'ui__mass-mail/template/properties_unknown-new__description' => 'Adăugarea unui șablon de mesaje e-mail în masă.',
    'ui__mass-mail/send__short-title' => 'Trimitere e-mail în masă',
    'ui__mass-mail/send__title' => 'Trimitere mesaj de e-mail în masă',
    'ui__mass-mail/send__description' => 'Trimitere mesaj de e-mail în masă către destinatarii selectați.',
    'ui__mass-mail/template/delete_multi__short-title' => 'Ștergere șabloane de e-mail în masă',
    'ui__mass-mail/template/delete_multi__title' => 'Ștergerea acestor șabloane de mesaje e-mail în masă:',
    'ui__mass-mail/template/delete_multi__description' => 'Ștergerea șabloanelor de mesaje e-mail în masă selectate.',
    'ui__mass-mail/template/delete_multi__done' => 'Șabloanele de mesaje selectate au fost șterse.',
    'ui__mass-mail/template/properties__invalid_values' => 'Au fost specificate valori incorecte',


    // old
    'ui__mass-mail#body_text__description' => 'Puteți folosi variabila <name> în textul mesajului (nu și în antet). Aceasta va fi înlocuită cu numele persoanei de contact a clientului sau a resellerului.',
    'ui__mass-mail#body_text__title' => 'Textul mesajului',
    'ui__mass-mail#compose_legend__title' => 'Mesaj',
    'ui__mass-mail#from_email_text__title' => 'De la (adresă e-mail)',
    'ui__mass-mail#list_header__cdate__title' => 'Data creării',
    'ui__mass-mail#list_header__from_email__title' => 'De',
    'ui__mass-mail#list_header__name__title' => 'Nume',
    'ui__mass-mail#list_header__send__title' => 'Creare mesaj',
    'ui__mass-mail#list_header__subject__title' => 'Subiect',
    'ui__mass-mail#list_header__title' => 'Șabloane de mesaje e-mail în masă',
    'ui__mass-mail#list_header__to__title' => 'Către',
    'ui__mass-mail#list_legend__title' => 'Șabloane de mesaje e-mail în masă',
    'ui__mass-mail#load_template_text__title' => 'Încărcare',
    'ui__mass-mail#name_text__title' => 'Nume șablon',
    'ui__mass-mail#option_mode_all__title' => 'Toate',
    'ui__mass-mail#option_mode_except__title' => 'Toate, cu excepția celor selectate',
    'ui__mass-mail#option_mode_select__title' => 'Doar cele selectate',
    'ui__mass-mail#option_select_template__title' => '---Selectați un șablon---',
    'ui__mass-mail#picker_legend__title' => 'Șabloane de mesaje e-mail',
    'ui__mass-mail#picker_title__title' => 'Selectați un șablon',
    'ui__mass-mail#save_as_legend__title' => 'Salvare ca șablon',
    'ui__mass-mail#save_as_text__title' => 'Salvarea mesajului scris într-un șablon nou, cu numele',
    'ui__mass-mail#subject_text__title' => 'Subiect',
    'ui__mass-mail#template_legend__title' => 'Șablon',
    'ui__mass-mail#to_admin_text__title' => 'Administrator Plesk',
    'ui__mass-mail#to_clients_text__title' => 'Clienți',
    'ui__mass-mail#to_domains_text__title' => 'Administratori de domeniu',
    'ui__mass-mail#to_select_text__title' => 'Selectați adresele',
    'ui__mass-mail#to_show_hide_text__title' => 'Afișarea/ascunderea elementelor selectate',
    'ui__mass-mail#to_text__title' => 'Către',
    'ui__mass-mail#tools_legend__title' => 'Instrumente',
    'ui__mass-mail__already_exists' => 'Șablonul cu numele %1 există deja',
    'ui__mass-mail__none-available' => 'Nu aveți șabloane de mesaje.',

    'ui__mass-mail/delete__description' => 'Ștergerea șablonului de mesaje e-mail în masă %1',

    'ui__mass-mail/delete__empty_selection' => 'Selectați șabloanele pe care doriți să le ștergeți',
    'ui__mass-mail/delete__short-title' => 'Ștergere %1',
    'ui__mass-mail/delete__title' => 'Ștergerea șablonului de mesaje e-mail în masă %1',
    'ui__mass-mail/delete_multi__description' => 'Ștergerea șabloanelor de mesaje e-mail în masă.',

    'ui__mass-mail/delete_multi__short-title' => 'Ștergere',
    'ui__mass-mail/delete_multi__title' => 'Ștergerea șabloanelor de mesaje e-mail în masă',
    'ui__mass-mail/delete_multi__wizard-title' => 'Ștergerea șabloanelor de mesaje e-mail în masă',
    'ui__mass-mail/delete_multi__wizard__1_multi' => 'Selectați șabloanele de mesaje de e-mail în masă pe care doriți să le ștergeți.',
    'ui__mass-mail/delete_multi__wizard__2_multi' => 'Confirmați ștergerea șabloanelor prin bifarea casetei, apoi faceți clic pe Terminare pentru a închide expertul.',
    'ui__mass-mail/delete_unknown__description' => 'Ștergerea șabloanelor de mesaje e-mail în masă.',
    'ui__mass-mail/delete_unknown__short-title' => 'Ștergere',
    'ui__mass-mail/delete_unknown__title' => 'Ștergerea șabloanelor de mesaje e-mail în masă',
    'ui__mass-mail/delete_unknown__wizard-title' => 'Ștergerea șabloanelor de mesaje e-mail în masă.',
    'ui__mass-mail/delete_unknown__wizard__1_unknown' => 'Selectați șablonul de mesaje de e-mail în masă pe care doriți să-l ștergeți.',
    'ui__mass-mail/delete_unknown__wizard__2' => 'Confirmați ștergerea șablonului prin bifarea casetei, apoi faceți clic pe Terminare pentru a închide expertul.',

    'ui__mass-mail/properties__description' => 'Editarea șablonului de mesaje e-mail %1.',

    'ui__mass-mail/properties__invalid_values' => 'Valorile specificate sunt incorecte',
    'ui__mass-mail/properties__short-title' => '%1',
    'ui__mass-mail/properties__title' => 'Editarea șablonului de mesaje e-mail %1',

    'ui__mass-mail/properties_new__wizard-title' => 'Creare șablon de mesaje e-mail în masă',
    'ui__mass-mail/properties_unknown-new__description' => 'Crearea unui șablon de mesaje e-mail în masă.',
    'ui__mass-mail/properties_unknown-new__short-title' => 'Adăugare șablon de mesaje e-mail',
    'ui__mass-mail/properties_unknown-new__title' => 'Creare șablon de mesaje e-mail',
    'ui__mass-mail/properties_unknown__wizard-title' => 'Editare șablon de mesaje e-mail în masă',
    'ui__mass-mail/properties_unknown__wizard__1_unknown' => 'Selectați șablonul pe care doriți să îl modificați, apoi faceți clic pe Următorul >>.',
    'ui__mass-mail/properties_unknown__wizard__2' => 'Când ați terminat editarea șablonului, faceți clic pe Terminare pentru a aplica modificările și a închide expertul.',

    'ui__mass-mail/send__invalid_values' => 'Ați specificat valori incorecte',

    'ui__mass-mail/send_new__wizard-title' => 'Creare șablon de mesaje și trimiterea e-mailului',
    'ui__mass-mail/send_unknown-new__description' => 'Trimitere e-mail la destinatarii selectați',

    'ui__mass-mail/send_unknown-new__short-title' => 'Trimitere e-mail în masă',
    'ui__mass-mail/send_unknown-new__title' => 'Trimitere mesaj de e-mail în masă',
    'ui__mass-mail/send_unknown__description' => 'Trimitere e-mail la destinatarii selectați',

    'ui__mass-mail/send_unknown__short-title' => 'Trimitere e-mail în masă',
    'ui__mass-mail/send_unknown__title' => 'Trimitere mesaj de e-mail în masă',
    'ui__mass-mail/send_unknown__wizard-title' => 'Trimitere mesaj de e-mail în masă',
    'ui__mass-mail/send_unknown__wizard__1_unknown' => 'Selectați șablonul dorit și faceți clic pe Următorul >>.',
    'ui__mass-mail/send_unknown__wizard__2' => 'Când ați terminat editarea proprietăților șablonului, faceți clic pe Terminare pentru a aplica modificările și a închide expertul.',

    'ui__mass-email/delete__description' => 'Ștergerea șabloanelor de mesaje e-mail în masă selectate.',

    'ui__mass-email/delete__empty_selection' => "Selectați șabloanele pe care doriți să le ștergeți.",
    'ui__mass-email/delete__short-title' => "Ștergere %1",
    'ui__mass-email/delete__title' => "Ștergerea șablonului de mesaje e-mail în masă %1",
    'ui__mass-email/delete_multi__description' => "Ștergerea șabloanelor de mesaje e-mail în masă.",

    'ui__mass-email/delete_multi__short-title' => "Ștergere",
    'ui__mass-email/delete_multi__title' => "Ștergerea șabloanelor de mesaje e-mail în masă",
    'ui__mass-email/delete_multi__wizard__mass-mail/delete_multi' => "Confirmați ștergerea șabloanelor prin bifarea casetei, apoi faceți clic pe Terminare pentru a închide expertul.",
    'ui__mass-email/delete_multi__wizard__mass-mail_multi' => "Selectați șabloanele de mesaje de e-mail în masă pe care doriți să le ștergeți.",
    'ui__mass-email/delete_multi__wizard-title' => "Ștergerea șabloanelor de mesaje e-mail în masă",
    'ui__mass-email/delete_unknown__description' => "Ștergerea șabloanelor de mesaje e-mail în masă.",
    'ui__mass-email/delete_unknown__short-title' => "Ștergere",
    'ui__mass-email/delete_unknown__title' => "Ștergerea șabloanelor de mesaje e-mail în masă",
    'ui__mass-email/delete_unknown__wizard__mass-mail/delete' => "Confirmați ștergerea șablonului prin bifarea casetei, apoi faceți clic pe Terminare pentru a închide expertul.",
    'ui__mass-email/delete_unknown__wizard__mass-mail_unknown' => "Selectați șablonul de mesaje de e-mail în masă pe care doriți să-l ștergeți.",
    'ui__mass-email/delete_unknown__wizard-title' => "Ștergerea șabloanelor de mesaje e-mail în masă.",
    'ui__mass-email/send__description' => "Trimitere e-mail la destinatarii selectați",
    'ui__mass-email/send__short-title' => "Trimitere e-mail în masă",
    'ui__mass-email/send__title' => "Trimitere mesaj de e-mail în masă",
    'ui__mass-email/send_main__description' => "Trimitere e-mail la destinatarii selectați",

    'ui__mass-email/send_main__short-title' => "Trimitere e-mail în masă",
    'ui__mass-email/send_main__title' => "Trimitere mesaj de e-mail în masă",
    'ui__mass-email/send_selectresellers__title' => 'Selectați resellerii',
    'ui__mass-email/send_selectresellers__short-title' => 'Reselleri',
    'ui__mass-email/send_selectresellers__description' => 'Selectați conturile de reseller',

    'ui__mass-email/send_selectclients__description' => "Selectați conturile de client",

    'ui__mass-email/send_selectclients__short-title' => "Clienți",
    'ui__mass-email/send_selectclients__title' => "Selectare clienți",
    'ui__mass-email/send_selectdomainusers__description' => "Selectați conturile de administratori de domeniu",

    'ui__mass-email/send_selectdomainusers__short-title' => "Administratori de domeniu",
    'ui__mass-email/send_selectdomainusers__title' => "Selectați administratorii de domeniu",
    'ui__mass-email/template/properties_main__description' => "Creare șablon de mesaje e-mail în masă",
    'ui__mass-email/template/properties_main__short-title' => "Editare șablon",
    'ui__mass-email/template/properties_main__title' => "Editare șablon de mesaje e-mail în masă",
    'ui__mass-email/template/properties_new-main__description' => "Crearea unui șablon pentru mesaje de e-mail în masă.",
    'ui__mass-email/template/properties_new-main__short-title' => "Creare șablon de mesaje e-mail în masă",
    'ui__mass-email/template/properties_new-main__title' => "Creare șablon de mesaje e-mail în masă",
    'ui__mass-email/template/properties_new-selectclients__description' => "Selectați clienții care trebuie să primească mesajele de e-mail în masă care se bazează pe acest șablon",
    'ui__mass-email/template/properties_new-selectclients__title' => "Selectați clienții care trebuie să primească mesajele de e-mail în masă care se bazează pe acest șablon",
    'ui__mass-email/template/properties_new-selectdomainusers__description' => "Selectați administratorii de domeniu care trebuie să primească mesajele de e-mail în masă care se bazează pe acest șablon.",
    'ui__mass-email/template/properties_new-selectdomainusers__title' => "Selectați administratorii de domeniu care trebuie să primească mesajele de e-mail în masă care se bazează pe acest șablon.",
    'ui__mass-email/template/properties_selectclients__title' => "Selectați clienții care trebuie să primească mesajele de e-mail în masă care se bazează pe acest șablon",
    'ui__mass-email/template/properties_selectdomainusers__title' => "Selectați administratorii de domeniu care trebuie să primească mesajele de e-mail în masă care se bazează pe acest șablon.",

    'ui__mass-email/template/properties_unknown-new__description' => "Creare șablon de mesaje e-mail în masă",
    'ui__mass-email/template/properties_unknown-new__short-title' => "Creare șablon",
    'ui__mass-email/template/properties_unknown-new__title' => "Crearea șablonului de mesaje e-mail în masă",
    'ui__news/dismiss__description' => 'Faceți clic pentru a închide cadrul cu știri. Plesk nu va afișa acest cadru decât după actualizarea articolelor de știri.',

    'ui__news/dismiss__title' => 'Închiderea ferestrei cu noutăți',

    'ui__server__description' => 'Administrarea serverului.',
    'ui__server__short-title' => 'Administrare server propriu',
    'ui__server__title' => 'Administrare server',


    // UNUSED SINCE 9.2



    // END OF UNUSED SINCE 9.2

    'ui__server/ip-address__disabled-warning' => 'Adresa IP %1 nu este disponibilă.',
    'ui__server/ip-address__none-available' => 'Nu există adrese IP.',
    'ui__server/ip-addresses/ip-address__title' => "Adrese IP",
    'ui__server/ip-address/client/properties_new__description' => "Atribuirea adresei IP %1 către reselleri.",
    'ui__server/ip-address/client/properties_new__short-title' => 'Atribuire',
    'ui__server/ip-address/client/properties_new__title' => "Atribuirea adresei IP %1 către reselleri",
    'ui__server/ip-address/client__none-available' => 'Nu există conturi de utilizator',
    'ui__server/ip-address/client_unknown__quick_search' => 'Utilizatori',
    'ui__server/ip-address/client_unknown__wizard-title' => 'Lista utilizatorilor care folosesc această adresă IP.',
    'ui__server/ip-address/client_unknown__wizard__3_unknown' => 'Selectați adresa IP.',
    'ui__server/ip-address/client/delete__description' => 'Anularea atribuirii adresei IP către reselleri.',
    'ui__server/ip-address/client/delete__short-title' => 'Anulare atribuire',
    'ui__server/ip-address/client/delete__title' => 'Anularea atribuirii adresei IP către reseller',
    'ui__server/ip-address/client/delete_multi__description' => "Anularea atribuirii adresei IP la domeniile de adrese ale resellerului.",

    'ui__server/ip-address/client/delete_multi__short-title' => 'Anulare atribuire',
    'ui__server/ip-address/client/delete_multi__title' => 'Anularea atribuirii unei adrese IP către un reseller',
    'ui__server/ip-address/client/delete_multi__wizard-title' => "Ștergerea adresei din domeniile de adrese IP ale utilizatorilor.",
    'ui__server/ip-address/client/delete_multi__wizard__3_unknown' => 'Selectați adresa IP pentru care doriți să anulați atribuirea către utilizatori și faceți clic pe Următorul >>.',
    'ui__server/ip-address/client/delete_multi__wizard__3_multi' => 'Selectați utilizatorii pentru care doriți să anulați atribuirea adresei IP și faceți clic pe Următorul >>.',
    'ui__server/ip-address/client/delete_multi__wizard__4_multi' => 'Confirmați anularea atribuirii adresei IP către utilizatori prin bifarea casetei corespunzătoare și faceți clic pe Terminare pentru a închide expertul.',
    'ui__server/ip-address/client/delete_unknown__description' => 'Anularea atribuirii unei adrese IP către reselleri.',
    'ui__server/ip-address/client/delete_unknown__short-title' => 'Anulare atribuire',
    'ui__server/ip-address/client/delete_unknown__title' => 'Anularea atribuirii adresei IP către reselleri',
    'ui__server/ip-address/client/delete_unknown__wizard-title' => 'Anularea atribuirii unei adrese IP către utilizatori',
    'ui__server/ip-address/client/delete_unknown__wizard__3_unknown' => 'Selectați adresa IP pentru care doriți să anulați atribuirea către utilizatori și faceți clic pe Următorul >>.',
    'ui__server/ip-address/client/delete_unknown__wizard__4_unknown' => 'Selectați utilizatorul pentru care doriți să anulați atribuirea adresei IP și faceți clic pe Următorul >>.',
    'ui__server/ip-address/client/delete_unknown__wizard__5' => 'Confirmați anularea atribuirii adresei IP către utilizatori prin bifarea casetei corespunzătoare și faceți clic pe Terminare pentru a închide expertul.',

    'ui__server/ip-address/domain__description' => "Toate domeniile de la adresa IP %1.",
    'ui__server/ip-address/domain__short-title' => "Domenii",
    'ui__server/ip-address/domain__title' => "Domeniile de la adresa IP %1",
    'ui__server/ip-address/domain_unknown__description' => "Toate domeniile de la adresa IP.",
    'ui__server/ip-address/domain_unknown__short-title' => "Domenii",
    'ui__server/ip-address/domain_unknown__title' => "Domenii la adresa IP",
    'ui__server/ip-address/domain_unknown__wizard__3_unknown' => "Selectați adresa IP dorită și faceți clic pe Următorul >>.",

    'ui__server/ip-address/properties__description' => 'Modificarea proprietăților adresei IP %1.',
    'ui__server/ip-address/properties__short-title' => 'Proprietăți',
    'ui__server/ip-address/properties__title' => 'Modificarea proprietăților adresei IP %1',

    'ui__server/ip-address/properties_new__wizard-title' => 'Adăugare adresă IP',
    'ui__server/ip-address/properties_new__wizard__4_new' => 'Când ați terminat de modificat proprietățile adresei IP, faceți clic pe Terminare pentru a aplica modificările.',
    'ui__server/ip-address/properties_unknown__description' => 'Modificarea proprietăților adresei IP.',
    'ui__server/ip-address/properties_unknown__short-title' => 'Proprietăți',
    'ui__server/ip-address/properties_unknown__title' => 'Modificarea proprietăților adresei IP',
    'ui__server/ip-address/properties_unknown__wizard-title' => 'Modificarea proprietăților adresei IP',
    'ui__server/ip-address/properties_unknown__wizard__3_unknown' => 'Selectați adresa IP ale cărei proprietăți doriți să le modificați.',
    'ui__server/ip-address/properties_unknown__wizard__4' => 'Când ați terminat de modificat proprietățile adresei IP, faceți clic pe Terminare pentru a aplica modificările.',

    'ui__server/spam-filter/black-list__description' => 'Configurarea listei negre a filtrului antispam la nivel de server.',
    'ui__server/spam-filter/black-list__short-title' => 'Listă neagră',
    'ui__server/spam-filter/black-list__title' => 'Lista neagră a filtrului antispam la nivel de server',

    'ui__server/spam-filter/black-list/address__addresses_available' => 'Se vor adăuga doar primele %1 adrese de e-mail unice.',
    'ui__server/spam-filter/black-list/address__description' => 'Adresa de listă neagră a filtrului antispam.',

    'ui__server/spam-filter/black-list/address__empty_content' => 'Nu există adrese de e-mail în listă.',
    'ui__server/spam-filter/black-list/address__file_size' => 'Fișierul încărcat este gol.',
    'ui__server/spam-filter/black-list/address__invalid_addresses' => 'Următoarele adrese de e-mail sunt incorecte: %1.',
    'ui__server/spam-filter/black-list/address__none-available' => 'Nu există adrese în lista neagră a filtrului antispam.',
    'ui__server/spam-filter/black-list/address__short-title' => 'Adresă',
    'ui__server/spam-filter/black-list/address__title' => 'Adresă de listă neagră %1',
    'ui__server/spam-filter/black-list/address_unknown__description' => 'Adăugarea adreselor la lista neagră.',
    'ui__server/spam-filter/black-list/address_unknown__short-title' => 'Adăugare adrese',
    'ui__server/spam-filter/black-list/address_unknown__title' => 'Adăugarea adreselor la lista neagră',

    'ui__server/spam-filter/black-list/address/delete__description' => 'Ștergerea adresei %1 din lista neagră la nivel de server.',

    'ui__server/spam-filter/black-list/address/delete__short-title' => 'Ștergere',
    'ui__server/spam-filter/black-list/address/delete__title' => 'Ștergerea adresei %1 din lista neagră la nivel de server',
    'ui__server/spam-filter/black-list/address/delete_multi__description' => 'Ștergerea adreselor din lista neagră la nivel de server.',

    'ui__server/spam-filter/black-list/address/delete_multi__short-title' => 'Ștergere',
    'ui__server/spam-filter/black-list/address/delete_multi__title' => 'Ștergerea adreselor din lista neagră la nivel de server',
    'ui__server/spam-filter/black-list/address/delete_multi__wizard-title' => 'Ștergerea adreselor din lista neagră a filtrului antispam la nivel de server',
    'ui__server/spam-filter/black-list/address/delete_multi__wizard__4_multi' => 'Selectați adresele de filtru antispam pe care doriți să le ștergeți, apoi faceți clic pe Următorul >>.',
    'ui__server/spam-filter/black-list/address/delete_multi__wizard__5_multi' => 'Confirmați ștergerea adreselor de filtru antispam prin bifarea casetei, apoi faceți clic pe Terminare pentru a executa ștergerea și a închide expertul.',
    'ui__server/spam-filter/black-list/address/delete_unknown__description' => 'Ștergerea adresei din lista neagră la nivel de server.',
    'ui__server/spam-filter/black-list/address/delete_unknown__short-title' => 'Ștergere',
    'ui__server/spam-filter/black-list/address/delete_unknown__title' => 'Ștergerea adresei din lista neagră la nivel de server',
    'ui__server/spam-filter/black-list/address/delete_unknown__wizard-title' => 'Ștergerea adreselor din lista neagră a filtrului antispam la nivel de server',
    'ui__server/spam-filter/black-list/address/delete_unknown__wizard__4_unknown' => 'Selectați adresa de filtru antispam pe care doriți să o ștergeți, apoi faceți clic pe Următorul >>.',
    'ui__server/spam-filter/black-list/address/delete_unknown__wizard__5' => 'Confirmați ștergerea adresei de filtru antispam prin bifarea casetei, apoi faceți clic pe Terminare pentru a finaliza ștergerea și a închide expertul.',

    'ui__server/spam-filter/black-list/address/properties__addresses_available' => 'Se vor adăuga doar primele %1 adrese de e-mail unice.',
    'ui__server/spam-filter/black-list/address/properties__empty_content' => 'Nu există adrese de e-mail în listă.',
    'ui__server/spam-filter/black-list/address/properties__file_size' => 'Imposibil de încărcat fișierul. Dimensiunea maximă a fișierului încărcat este de %1.',
    'ui__server/spam-filter/black-list/address/properties__invalid_addresses' => 'Următoarele adrese de e-mail sunt incorecte: %1.',

    'ui__server/spam-filter/black-list/address/properties_unknown-new__description' => 'Adăugarea adreselor la lista neagră.',
    'ui__server/spam-filter/black-list/address/properties_unknown-new__short-title' => 'Adăugare adrese',
    'ui__server/spam-filter/black-list/address/properties_unknown-new__title' => 'Adăugarea adreselor la lista neagră',

    'ui__server/spam-filter/properties__description' => 'Configurarea filtrului antispam la nivel de server.',

    'ui__server/spam-filter/properties__short-title' => 'Setări',
    'ui__server/spam-filter/properties__title' => 'Setări filtru antispam',

    'ui__server/spam-filter/toggle_disable__description' => 'Dezactivarea filtrului antispam pentru întregul sistem.',

    'ui__server/spam-filter/toggle_disable__short-title' => 'Dezactivare',
    'ui__server/spam-filter/toggle_disable__title' => 'Dezactivare filtru antispam',
    'ui__server/spam-filter/toggle_enable__description' => 'Activarea filtrului antispam pentru întregul server.',

    'ui__server/spam-filter/toggle_enable__short-title' => 'Activare',
    'ui__server/spam-filter/toggle_enable__title' => 'Activare filtru antispam',
    'ui__server/spam-filter/toggle_unknown__description' => 'Activarea sau dezactivarea filtrului spam pentru întregul server.',
    'ui__server/spam-filter/toggle_unknown__short-title' => 'Activare sau dezactivare',
    'ui__server/spam-filter/toggle_unknown__title' => 'Activarea sau dezactivarea filtrului antispam',
    'ui__server/spam-filter/toggle_unknown__wizard-title' => 'Activare sau dezactivare filtru antispam',

    'ui__server/spam-filter/white-list__description' => 'Configurarea listei albe a filtrului antispam la nivel de server.',
    'ui__server/spam-filter/white-list__short-title' => 'Listă albă',
    'ui__server/spam-filter/white-list__title' => 'Lista albă a filtrului antispam la nivel de server',

    'ui__server/spam-filter/white-list/address__addresses_available' => 'Se vor adăuga doar primele %1 adrese de e-mail unice.',
    'ui__server/spam-filter/white-list/address__description' => 'Adresa de listă albă a filtrului antispam.',

    'ui__server/spam-filter/white-list/address__empty_content' => 'Nu există adrese de e-mail în listă.',
    'ui__server/spam-filter/white-list/address__file_size' => 'Fișierul încărcat este gol.',
    'ui__server/spam-filter/white-list/address__invalid_addresses' => 'Următoarele adrese de e-mail sunt incorecte: %1.',
    'ui__server/spam-filter/white-list/address__none-available' => 'Nu există adrese în lista albă a filtrului antispam la nivel de server.',
    'ui__server/spam-filter/white-list/address__short-title' => 'Adresă',
    'ui__server/spam-filter/white-list/address__title' => 'Adresa de listă albă %1',
    'ui__server/spam-filter/white-list/address_unknown__description' => 'Adăugarea adreselor în lista albă.',
    'ui__server/spam-filter/white-list/address_unknown__short-title' => 'Adăugare adrese',
    'ui__server/spam-filter/white-list/address_unknown__title' => 'Adăugarea adreselor în lista albă',

    'ui__server/spam-filter/white-list/address/delete__description' => 'Ștergerea adresei %1 din lista albă la nivel de server.',

    'ui__server/spam-filter/white-list/address/delete__short-title' => 'Ștergere',
    'ui__server/spam-filter/white-list/address/delete__title' => 'Ștergerea adresei %1 din lista albă la nivel de server',
    'ui__server/spam-filter/white-list/address/delete_multi__description' => 'Ștergerea adreselor din lista albă la nivel de server.',

    'ui__server/spam-filter/white-list/address/delete_multi__short-title' => 'Ștergere',
    'ui__server/spam-filter/white-list/address/delete_multi__title' => 'Ștergerea adreselor din lista albă la nivel de server',
    'ui__server/spam-filter/white-list/address/delete_multi__wizard-title' => 'Ștergerea adreselor din lista albă a filtrului antispam la nivel de server',
    'ui__server/spam-filter/white-list/address/delete_multi__wizard__4_multi' => 'Selectați adresele de filtru antispam pe care doriți să le ștergeți, apoi faceți clic pe Următorul >>.',
    'ui__server/spam-filter/white-list/address/delete_multi__wizard__5_multi' => 'Confirmați ștergerea adreselor de filtru antispam prin bifarea casetei, apoi faceți clic pe Terminare pentru a executa ștergerea și a închide expertul.',
    'ui__server/spam-filter/white-list/address/delete_unknown__description' => 'Ștergerea adresei din lista albă la nivel de server.',
    'ui__server/spam-filter/white-list/address/delete_unknown__short-title' => 'Ștergere',
    'ui__server/spam-filter/white-list/address/delete_unknown__title' => 'Ștergerea adresei din lista albă la nivel de server',
    'ui__server/spam-filter/white-list/address/delete_unknown__wizard-title' => 'Ștergerea adreselor din lista albă a filtrului antispam la nivel de server',
    'ui__server/spam-filter/white-list/address/delete_unknown__wizard__4_unknown' => 'Selectați adresa de filtru antispam pe care doriți să o ștergeți, apoi faceți clic pe Următorul >>.',
    'ui__server/spam-filter/white-list/address/delete_unknown__wizard__5' => 'Confirmați ștergerea adresei de filtru antispam prin bifarea casetei, apoi faceți clic pe Terminare pentru a finaliza ștergerea și a închide expertul.',

    'ui__server/spam-filter/white-list/address/properties__addresses_available' => 'Se vor adăuga doar primele %1 adrese de e-mail unice.',
    'ui__server/spam-filter/white-list/address/properties__empty_content' => 'Nu există adrese de e-mail în listă.',
    'ui__server/spam-filter/white-list/address/properties__file_size' => 'Imposibil de încărcat fișierul. Dimensiunea maximă a fișierului încărcat este de %1.',
    'ui__server/spam-filter/white-list/address/properties__invalid_addresses' => 'Următoarele adrese de e-mail sunt incorecte: %1.',

    'ui__server/spam-filter/white-list/address/properties_unknown-new__description' => 'Adăugarea adreselor în lista albă.',
    'ui__server/spam-filter/white-list/address/properties_unknown-new__short-title' => 'Adăugare adrese',
    'ui__server/spam-filter/white-list/address/properties_unknown-new__title' => 'Adăugarea adreselor în lista albă',

    'ui__server/mail/statistics#apply__description' => "Aplicare filtru",
    'ui__server/mail/statistics#apply__title' => "Aplicare",
    'ui__server/mail/statistics#custom_from__title' => "de la",
    'ui__server/mail/statistics#custom_to__title' => "până la",
    'ui__server/mail/statistics#period_all__title' => "Toate",
    'ui__server/mail/statistics#period_custom__title' => "Personalizat",
    'ui__server/mail/statistics#period_month__title' => "Luna curentă",
    'ui__server/mail/statistics#period_prev_month__title' => "Luna anterioară",
    'ui__server/mail/statistics#period_prev_week__title' => "Săptămâna anterioară",
    'ui__server/mail/statistics#period_today__title' => "Azi",
    'ui__server/mail/statistics#period_week__title' => "Săptămâna curentă",
    'ui__server/mail/statistics#period_yesterday__title' => "Ieri",
    'ui__server/mail/statistics#show_for_period__title' => "Afișare pentru perioada",
    'ui__server/mail/statistics#tools_legend__title' => "Instrumente",
    'ui__server/mail/statistics__description' => "Vizualizare statistici spam și viruși",

    'ui__server/mail/statistics__short-title' => "Statistici",
    'ui__server/mail/statistics__title' => "Setări de e-mail",
    'ui__server/mail/statistics/spam#statistics_legend__title' => "Statistici spam",
    'ui__server/mail/statistics/spam#tools_legend__title' => "Instrumente",
    'ui__server/mail/statistics/spam__description' => "Vizualizare statistici spam",

    'ui__server/mail/statistics/spam__short-title' => "Statistici spam",
    'ui__server/mail/statistics/spam__title' => "Statistici spam",
    'ui__server/mail/statistics/spam/recipients#list_header__name__title' => "Nume e-mail",
    'ui__server/mail/statistics/spam/recipients#list_header__ratio__title' => "% din total",
    'ui__server/mail/statistics/spam/recipients#list_header__sort_by_name__title' => "Sortare după contul de e-mail",
    'ui__server/mail/statistics/spam/recipients#list_header__sort_by_ratio__title' => "Sortare după % din total",
    'ui__server/mail/statistics/spam/recipients#list_header__sort_by_val__title' => "Sortare după spamul primit",
    'ui__server/mail/statistics/spam/recipients#list_header__title' => "conturi de e-mail",
    'ui__server/mail/statistics/spam/recipients#list_header__val__title' => "Spam primit",
    'ui__server/mail/statistics/spam/recipients__description' => "Destinatari",

    'ui__server/mail/statistics/spam/recipients__short-title' => "Destinatari",
    'ui__server/mail/statistics/spam/recipients__title' => "Destinatari",
    'ui__server/mail/statistics/spam/summary#clean__title' => "Curat",
    'ui__server/mail/statistics/spam/summary#infected__title' => "Infectat",
    'ui__server/mail/statistics/spam/summary#list_header__name__title' => "Stare",
    'ui__server/mail/statistics/spam/summary#list_header__ratio__title' => "% din total",
    'ui__server/mail/statistics/spam/summary#list_header__val__title' => "Număr",
    'ui__server/mail/statistics/spam/summary#protected__title' => "Protejat",
    'ui__server/mail/statistics/spam/summary#skipped__title' => "Neverificat",
    'ui__server/mail/statistics/spam/summary__description' => "Rezumat",

    'ui__server/mail/statistics/spam/summary__short-title' => "Rezumat",
    'ui__server/mail/statistics/spam/summary__title' => "Rezumat",
    'ui__server/mail/statistics/virus#statistics_legend__title' => "Statistici viruși",
    'ui__server/mail/statistics/virus#tools_legend__title' => "Instrumente",
    'ui__server/mail/statistics/virus__description' => "Vizualizare statistici viruși",

    'ui__server/mail/statistics/virus__short-title' => "Statistici viruși",
    'ui__server/mail/statistics/virus__title' => "Statistici viruși",
    'ui__server/mail/statistics/virus/recipients#list_header__name__title' => "Cont de e-mail",
    'ui__server/mail/statistics/virus/recipients#list_header__ratio__title' => "% din total",
    'ui__server/mail/statistics/virus/recipients#list_header__sort_by_name__title' => "Sortare după numele de e-mail",
    'ui__server/mail/statistics/virus/recipients#list_header__sort_by_ratio__title' => "Sortare după % din total",
    'ui__server/mail/statistics/virus/recipients#list_header__sort_by_val__title' => "Sortare după virușii primiți",
    'ui__server/mail/statistics/virus/recipients#list_header__title' => "Conturi de e-mail",
    'ui__server/mail/statistics/virus/recipients#list_header__val__title' => "Viruși primiți",
    'ui__server/mail/statistics/virus/recipients__description' => "Destinatari",

    'ui__server/mail/statistics/virus/recipients__short-title' => "Destinatari",
    'ui__server/mail/statistics/virus/recipients__title' => "Destinatari",
    'ui__server/mail/statistics/virus/summary#clean__title' => "Curat",
    'ui__server/mail/statistics/virus/summary#infected__title' => "Infectat",
    'ui__server/mail/statistics/virus/summary#list_header__name__title' => "Stare",
    'ui__server/mail/statistics/virus/summary#list_header__ratio__title' => "% din total",
    'ui__server/mail/statistics/virus/summary#list_header__val__title' => "Număr",
    'ui__server/mail/statistics/virus/summary#protected__title' => "Protejat",
    'ui__server/mail/statistics/virus/summary#skipped__title' => "Neverificat",
    'ui__server/mail/statistics/virus/summary__description' => "Rezumat",

    'ui__server/mail/statistics/virus/summary__short-title' => "Rezumat",
    'ui__server/mail/statistics/virus/summary__title' => "Rezumat",
    'ui__server/mail/statistics/virus/viruses#list_header__name__title' => "Nume",
    'ui__server/mail/statistics/virus/viruses#list_header__ratio__title' => "% din total",
    'ui__server/mail/statistics/virus/viruses#list_header__sort_by_name__title' => "Sortare după nume",
    'ui__server/mail/statistics/virus/viruses#list_header__sort_by_ratio__title' => "Sortare după % din total",
    'ui__server/mail/statistics/virus/viruses#list_header__sort_by_val__title' => "Sortare după obiectele infectate",
    'ui__server/mail/statistics/virus/viruses#list_header__title' => "Viruși",
    'ui__server/mail/statistics/virus/viruses#list_header__val__title' => "Obiecte infectate",
    'ui__server/mail/statistics/virus/viruses__description' => "Viruși",

    'ui__server/mail/statistics/virus/viruses__short-title' => "Viruși",
    'ui__server/mail/statistics/virus/viruses__title' => "Viruși",

    'ui__support#param_company__title' => "Companie",
    'ui__support#param_email__title' => "E-mail",
    'ui__support#param_firstname__title' => "Prenume",
    'ui__support#param_keynumber__title' => "Număr cheie produs",
    'ui__support#param_operatingsystem__title' => "Sistem de operare",
    'ui__support#param_phone__title' => "Telefon",
    'ui__support#param_psabuild__title' => "Compilare Plesk",
    'ui__support#param_psainsttype__title' => "Tip de instalare Plesk",
    'ui__support#param_psaversion__title' => "Versiune Plesk",

    // *** The strings above have been generated automatically from @@CAPTION directives.

    ////
    //// UI POINTER CAPTIONS END HERE


    // RESELLERS

    // Resellers
    'ui__reseller#tools__title' => "Instrumente",

    'ui__reseller/traffic-history_unknown__short-title' => "Vizualizarea traficului pe reselleri",
    'ui__reseller/traffic-history_unknown__title' => "Vizualizarea traficului pe reselleri",
    'ui__reseller/traffic-history_unknown__description' => "Vizualizarea traficului defalcat pe conturile de reseller.",
    'ui__reseller#list__title' => "Reselleri",
    'accounts_list__name__filter_title' => "Nume",
    'accounts_list__resource__filter_title' => "Utilizare resurse",
    'resellers_list__filter_resource_usage_any' => "Oricare",
    'resellers_list__filter_resource_usage_overuse' => "Suprautilizare",
    'resellers_list__filter_resource_usage_normal' => "În limitele admise",
    'accounts_list__status__filter_title' => "Stare",
    'resellers_list__filter_status_any' => "Oricare",
    'resellers_list__filter_status_blocked' => "Suspendat",
    'resellers_list__filter_status_active' => "Activ",
    'resellers_list__filter_clients__filter_title' => "Afișare",
    'resellers_list__filter_clients_on' => "Reselleri cu clienții lor",
    'resellers_list__filter_clients_off' => "Doar reselleri",
    '__disk_usage' => "Spațiu pe disc utilizat",
    'ui__reseller/traffic_unknown__short-title' => "Vizualizarea traficului pe reselleri",
    'ui__reseller/traffic_unknown__title' => "Vizualizarea traficului pe reselleri",
    'ui__reseller/traffic#list__title' => "Trafic pe reselleri",
    'ui__reseller/traffic_unknown__description' => "Vizualizarea rapoartelor despre utilizarea traficului.",

    // Resellers > Traffic by resellers
    '__traffic_by_reseller' => "Trafic pe reselleri",

    '__reseller_name' => "Nume reseller",
    '__reseller' => "Reselleri",
    'resellertrafficlist_header' => "Vizualizarea traficului pe reselleri",
    '__reseller_personal' => "Traficul utilizat de domeniile resellerului",
    'ui__reseller/traffic-history__short-title' => "Trafic pe reselleri",
    'ui__reseller/traffic-history__title' => "Trafic pe reselleri",
    'ui__reseller/traffic-history__description' => "Vizualizarea rapoartelor despre utilizarea traficului.",

    // Resellers > Create Reseller Account
    'ui__reseller__short-title' => "%1",

    // Resellers > Reseller preferences

    // Resellers > Reseller Account Templates

    // Resellers > Reseller Account Templates > Create Reseller Account Template
    'limits__oversell_text' => "Se permite supravânzarea",
    'limits__reseller_oversell_description' => "Supravânzarea permite resellerului vânzarea de resurse peste nivelurile alocate inițial. Dacă supravânzarea este permisă, activitatea resellerului este reglementată în funcție de utilizarea efectivă a resurselor, nu de alocarea inițială.",
    'limits__overuse_block_text' => "Politică de suprautilizare",
    'limits__overuse_block_true_text' => "Nu se permite suprautilizarea",
    'limits__reseller_overuse_block_true_description' => "Se blochează suprautilizarea resurselor. Utilizarea efectivă a resurselor nu poate depăși alocarea inițială",
    'limits__overuse_block_false_text' => "Se permite suprautilizarea",
    'limits__reseller_overuse_block_false_description' => "Nu se blochează suprautilizarea resurselor, resellerul poate utiliza mai multe resurse decât a primit inițial. Utilizarea efectivă a resurselor poate depăși alocarea inițială",
    'limits__reseller_overuse_notify_text' => "Se trimite o notificare resellerului în legătură cu atingerea limitelor de resurse",
    'reseller_perm__manage_sh_access_disabled' => "Resellerul nu poate permite, nici interzice accesul la shell",
    'reseller_perm__manage_sh_access_chrooted' => "Resellerul poate permite accesul numai la un mediu cu chroot",
    'reseller_perm__manage_sh_access_any' => "Resellerul poate permite accesul la orice tip de shell",
    'template__reseller_num_excl_ips' => "Alocați resellerului adrese IP dedicate",

    // Reseller's Home page
    'ui__reseller#tools2__title' => "Cont",
    'ui__reseller#info__title' => "Informații",
    'ui__reseller#clientsTab__title' => "Clienți",
    'ui__reseller#domainsTab__title' => "Domenii",
    'ui__reseller__title' => "Administrarea contului de reseller %1",
    'domains__reseller_info' => "%1 clienți, %2 domenii, %3 de spațiu pe disc utilizat, %4 de date transferate.",
    'domains__reseller_info_hiding_traffic' => "%1 clienți, %2 domenii, %3 de spațiu pe disc utilizat.",
    'ui__reseller__description' => "Administrarea contului de reseller.",

    'ui__reseller/limits_unknown__wizard-title' => 'Vizualizarea sau modificarea limitelor de resurse pentru un reseller',
    'ui__reseller/limits_unknown__wizard__1_unknown' => 'Selectați resellerul dorit.',
    'ui__reseller/limits_unknown__wizard__2' => 'Pentru a aplica modificările, faceți clic pe Terminare.',

    'ui__client/report_reseller__short-title' => "Raport",
    'ui__client/report_reseller__title' => "Vizualizare raport de cont",
    'ui__client/report_reseller__description' => "Vizualizarea raportului de cont de reseller.",
    'ui__client/ip-pool_reseller__short-title' => "Domeniu de adrese IP",
    'ui__client/ip-pool_reseller__description' => "Atribuirea adreselor IP și a certificatelor SSL/TLS contului de reseller.",

    //'ui__client/preferences_reseller__short-title' => "Settings",
    //'ui__client/preferences_reseller__description' => "Set Plesk session settings.",

    'ui__reseller/preferences_unknown__wizard__2_self' => "Specificați setările de cont, apoi faceți clic pe Terminare.",

    //'ui__client/permissions_reseller__short-title' => "Permissions",
    //'ui__client/permissions_reseller__description' => "View or change permissions for the reseller's account.",

    'ui__reseller/permissions_unknown__wizard-title' => 'Vizualizarea sau modificarea permisiunilor unui reseller',
    'ui__reseller/permissions_unknown__wizard__1_unknown' => 'Selectați resellerul ale cărui permisiuni doriți să le vizualizați sau să le modificați.',
    //'ui__reseller/permissions_unknown__wizard__1/properties_self' => 'When done with viewing your permissions, click Finish to to apply the changes and exit the wizard.',
    'ui__reseller/permissions_unknown__wizard__2' => 'Când ați terminat de modificat permisiunile resellerului, faceți clic pe Terminare pentru a aplica schimbările și a închide expertul.',

    // Customers > create customer account

    '__resellers_list' => 'Reselleri',
    'picker_reseller__title' => 'Selectare reseller',

    // Resellers > reseller name > customer name
    'ui__client#tools1__title' => "Instrumente",
    'ui__client#tools2__title' => "Cont",
    'ui__client#info__title' => "Informații",
    'ui__client#clientslist__title' => "Clienți",
    'ui__client#domainslist__title' => "Domenii",

    // Reseller's session in the Customer Panel - Home page

    'feature__aps_categories__reseller' => "Toate aplicațiile web sunt acum sortate pe categorii, cea ce facilitează selectarea aplicației corecte în vederea instalării.",
    'feature__domainkeys__reseller' => "Puteți utiliza mecanismul de autentificare a expeditorului de e-mail DKIM pentru a reduce numărul e-mailurilor de spam și de phishing.",

    '__reseller_form' => "Formular de reseller",

    // Reseller's session in the control panel - Home page > Manage Customer Settings
    'ui__client/preferences_unknown__wizard__reseller' => "Selectați un cont de client ale cărui setări doriți să le modificați.",

    // Reseller's session in the control panel - Home page > Suspend/Activate Customer Account

    // Reseller's session in the control panel - Home page > Change Customer Limits
    'ui__client/limits_unknown__wizard__1' => "Pentru a modifica limitele de utilizare a resurselor, faceți clic pe Limite resurse.",

    // Reseller's session in the control panel - Home page > Change Customer Permissions
    'ui__client/permissions_unknown__wizard__1' => "Pentru a modifica permisiunile aferente operațiilor pe care clientul le poate executa în Plesk, faceți clic pe Permisiuni.",

    // Reseller's session in the control panel - Home page > Create Customer Template
    'template__shared_text' => "Acest șablon va fi disponibil pentru alți utilizatori",
    'template__shared_description' => "Selectați această opțiune dacă doriți ca clienții să poată utiliza acest șablon.",

    // CLIENT (updated for reseller feature):

    // Customers
    'ui__client#tools__title' => 'Instrumente',

    'ui__client/traffic-history_unknown__short-title' => 'Vizualizare trafic pe clienți',
    'ui__client/traffic-history_unknown__title' => 'Trafic pe clienți',
    'ui__client/traffic-history_unknown__description' => 'Vizualizarea raportului de utilizare a traficului pentru toți clienții',
    'ui__client/traffic-history__short-title' => 'Trafic pe clienți',
    'ui__client/traffic-history__title' => 'Vizualizare trafic pe clienți',
    'ui__client/traffic-history__description' => 'Vizualizarea raportului de utilizare a traficului pentru toți clienții',

    'ui__client/traffic#list__title' => 'Trafic pe clienți',
    'ui__reseller/client/traffic#list__title' => 'Trafic pe clienți',

    'clients_list__filter_type__filter_title' => 'Afișare',
    'clients_list__filter_type_any' => 'Clienți și reselleri',
    'clients_list__filter_type_clients' => 'Doar clienți',
    'clients_list__filter_type_resellers' => 'Doar reselleri',
    'ui__client/domain_unknown-new__short-title' => "Creare domeniu",

    // Customers > View traffic by customers
    '__personal' => "Traficul utilizat de domeniile utilizatorului",
    'PersonalTrafficList_header_of_client__' => "Vizualizarea raportului de utilizare a traficului în contul dvs.",

    // DOMAINS

    // Domain > Domain Admin Permissions

    'domain_perm__manage_sh_access_disabled' => "Administratorul de domeniu nu poate permite, nici interzice accesul la shell",
    'domain_perm__manage_sh_access_chrooted' => "Administratorul de domeniu poate permite accesul numai la un mediu cu chroot",
    'domain_perm__manage_sh_access_any' => "Administratorul de domeniu poate permite acces la orice tip de shell",

    // APS Catalog
    'bt_add_to_vault' => "Adăugare la Seif",
    'bt_hide_updates' => "Ascundere actualizări disponibile",
    'bt_show_updates' => "Afișare actualizări disponibile",

    '__site_apps__applications' => "Aplicații",
    //search elements
    // Application; Vendor; Packager; Certification level;

    '__site_apps__apps_selected_to_add_to_vault' => "Aplicații selectate pentru adăugare la Seif",
    'site_apps__application_selected' => "Selectată",
    'site_apps__currently_in_vault' => "Alte versiuni aflate deja în Seif:",
    'site_apps__new_versions' => "Versiuni noi:",
    'site_apps__patches' => "Corecții:",
    'site_apps__applications_have_been_scheduled_for_adding_to_application_vault' => "Numărul aplicațiilor programate pentru adăugare la Seif: %1",
    'site_apps__applications_downloading_now' => "Se descarcă următoarele aplicații: %1", // temporary workaround string, to be removed later

    'site_apps__package_already_exist_in_vault' => "Se afla deja în Seif",

    // Server > Action Log
    'bt_skin_edit' => "Editarea descrierii prezentării",
    'domains__you_want_change_the_status_of_the_reseller??' => "Sigur modificați starea contului de reseller?",
    'limits__oversell_legend' => "Supravânzare",
    'limitsManager__limit_available_error' => "Imposibil de alocat resursele solicitate (%%quantity%% %%limitName%%). Disponibil: %%available%% %%limitName%%.",
    'limitsManager__limit_reserved_error' => "Imposibil de setat limita de resursă solicitată (%%quantity%% %%limitName%%): noua valoare este mai mică decât resursele rezervate pentru clienții dvs. sau cele pe care le utilizați (%%reserved%% %%limitName%%).",
    'limitsManager__limit_used_error' => "Imposibil de setat limita de resursă solicitată (%%quantity%% %%limitName%%): noua valoare este mai mică decât resursele utilizate de contul și de site-urile dvs. (%%used%% %%limitName%%).",

    'ui__client/domain/traffic#list__title' => "Utilizarea lățimii de bandă, pe servicii",

    'ui__client/domain/traffic_unknown-reseller__short-title' => "Vizualizare raport de utilizare a traficului",
    'ui__client/domain/traffic_unknown-reseller__title' => "Vizualizare raport de utilizare a traficului",

    'ui__client/domain_new__short-title' => "Creare domeniu",

    'ui__client_reseller__description' => "Administrarea contului de reseller %1.",
    'ui__client_reseller__short-title' => "%1",
    'ui__client_reseller__title' => "Administrare cont reseller",

    '__owner_name' => "Nume proprietar",
    'domains_list__resource__filter_title' => "Utilizare resurse",

    // APS CATALOG
    'site_apps__application_catalog_preferences' => "Catalog aplicații APS",
    'site_apps__applications_have_updates' => "Sunt disponibile versiuni actualizate ale următoarelor aplicații: %1 Pentru a vizualiza actualizările, asigurați-vă că zona Căutare este vizibilă, bifați caseta de selectare <b>Se afișează doar actualizările</b> și căutați aplicațiile dorite.",
    'site_apps__progress_adding_to_vault' => "Adăugare la Seif:",
    'site_apps__progress_done_message' => "Progres:",
    'site_apps__progress_applications_left' => "au rămas %1 din %2 aplicații",
    'site_apps__download_item_long_task_title' => "Descărcare aplicație APS (%1)",
    'site_apps__download_transaction_long_task_title' => "Descărcare aplicații APS din catalogul APS",
    'site_apps__last_check_for_updates' => "ultima verificare a actualizărilor: %1",
    'site_apps__all_sucessfully_added_to_app_vault' => "Toate aplicațiile programate au fost adăugate cu succes în Seiful de aplicații",
    'site_apps__number_of_apps_sucessfully_added_to_app_vault' => "%1 de aplicații programate au fost adăugate cu succes în Seiful de aplicații.",
    'site_apps__no_search_results' => 'Nu s-a găsit nicio aplicație. Încercați o altă căutare sau căutați aplicații pe categorii.',
    'site_apps__search_results_title' => 'Rezultatele căutării',
    '__site_apps__search_by_application' => 'Nume aplicație',
    '__site_apps__search_by_vendor' => 'Furnizor',
    '__site_apps__search_by_vendor__all' => 'Toți vânzătorii',
    '__site_apps__search_by_packager' => 'Utilitar de împachetare',
    '__site_apps__search_by_certification_level' => 'Nivel de certificare',
    '__site_apps__search_by_cert__any' => 'Oricare',
    '__site_apps__search_by_cert__silver_and_higher' => 'Silver sau mai avansat',
    '__site_apps__search_by_cert__gold_and_higher' => 'Gold sau mai avansat',
    '__retry' => 'Reîncercare',
    'site_apps__application_packager_site' => 'Utilitar de împachetare',
    'site_apps__add_to_pool_message' => "Aplicațiile marcate ca „disponibile tuturor” se distribuie automat tuturor resellerilor și clienților, cu număr de instalări nelimitat. Aplicațiile restricționate se distribuie tuturor resellerilor și clienților, de la caz la caz, cu numărul de instalări disponibile specificat explicit.",
    'site_apps__make_available_for_all' => "Aplicațiile selectate vor fi disponibile pentru toți utilizatorii",

    'site_apps__broadcast_app_text' => "Aplicațiile marcate ca „disponibile tuturor” se distribuie automat tuturor resellerilor și clienților, cu număr de instalări nelimitat. Aplicațiile restricționate se distribuie tuturor resellerilor și clienților, de la caz la caz, cu numărul de instalări disponibile specificat explicit.",
    'site_apps__broadcast_app_name' => 'Aplicațiile se pun la dispoziția tuturor utilizatorilor',

    // User Application Pool per application
    'site_apps__available_clients' => 'Utilizatori disponibili',
    'site_apps__no_more_clients_to_add_to_pool' => 'Nu mai există conturi de utilizatori cărora să le puteți furniza aplicația',

    // Installed application instances
    'site_apps__installations' => 'Instalări',

    // Hosting setup redesign
    '__domain_name_and_ip_address' => "Nume și adresă IP domeniu",
    '__assign_ip_address' => "Atribuire adresă IP",
    '__switch_on_service' => "Pornire serviciu",
    '__hosting_configuration' => "Configurare găzduire",
    '__vrt_hst' => "Găzduire de site web",
    '__vrt_hst_hint' => "Găzduire de site web pe acest server.",
    '__fwd' => "Redirecționare",
    '__web_hosting_settings' => "Setări de găzduire",
    '__fwd_hint' => "Redirecționarea vizitatorilor spre un alt site web.",
    '__none_hint' => "Pentru moment nu se găzduiește niciun site.",
    '__login_hint' => "Acest nume de utilizator este folosit pentru accesarea site-ului dvs. prin FTP",
    '__password_hint' => "Această parolă este folosită pentru accesarea site-ului prin FTP",
    '__advanced_hosting_setup' => "Configurarea setărilor avansate de găzduire web",
    '__domain_creation_successful' => "Domeniul a fost creat.",
    'bt_hosting_settings' => "Setări de găzduire",
    '__change_hosting_type' => "Modificarea tipului de găzduire pentru domeniul %1",
    '__hosting_type_change_warning' => "Când schimbați tipul de găzduire în redirecționare sau în fără găzduire, toate fișierele și directoarele legate de site-ul dvs. sunt șterse de pe server. Nu uitați să salvați local o copie a site-ului.",
    '__current_hosting_type' => "Tip de găzduire curent",
    '__new_hosting_type' => "Tip de găzduire nou",
    '__fwd_settings' => "Setări de redirecționare",
    '__fwd_settings_legend' => "Setări de redirecționare",
    '__fwd_destination_url' => "URL destinație",
    '__fwd_type' => "Tip de redirecționare",
    '__fwd_type_standart' => "Redirecționare standard",
    '__fwd_type_standart_hint' => "Vizitatorii sunt redirecționați către un alt site și li se arată adresa destinație, astfel încât află de redirecționare.",
    '__fwd_type_frame' => "Redirecționare cu cadre",
    '__fwd_type_frame_hint' => "Vizitatorii sunt redirecționați către un alt site, dar nu li se arată adresa destinație, deci nu află despre redirecționare.",
    '__hosting_type_template_warning' => "Tipul de găzduire selectat este diferit de cel specificat în șablon. În cazul în care continuați, setările de găzduire web din șablonul selectat vor fi ignorate. Sigur setați tipul de găzduire selectat?",

    '__no_resellers_selected' => "Trebuie să selectați cel puțin un cont de reseller.",

    'ui__client/logo_unknown__wizard-title' => 'Configurarea unei sigle',
    'ui__client/logo_unknown__wizard__1_unknown' => 'Selectați clientul ale cărui proprietăți de siglă doriți să le modificați.',
    'ui__client/logo_unknown__wizard__2' => 'Faceți clic pe Terminare pentru a aplica schimbările.',
    'ui__client/logo_unknown__wizard__2_self' => 'Faceți clic pe Terminare pentru a aplica schimbările.',

    'ui__client/ipaddress/properties_new__short-title' => "Adăugare adresă IP",
    'ui__client/ipaddress/properties_new__title' => 'Adăugare adresă IP',
    'ui__client/ipaddress/properties_new__description' => "Adăugarea adresei IP.",
    'ui__client/ipaddress/properties_unknown-new__short-title' => "Adăugare adresă IP",
    'ui__client/ipaddress/properties_unknown-new__title' => "Adăugare adresă IP",
    'ui__client/ipaddress/properties_unknown-new__description' => "Adăugare adresă IP",
    'ui__client/ipaddress/delete_multi__short-title' => "Ștergerea adresei IP",
    'ui__client/ipaddress/delete_multi__description' => "Ștergerea adreselor IP.",
    'ippool_Manager__no_available_ips' => "Nu există adrese IP libere în domeniul de adrese.",
    'ippool_Manager__ip_shared' => "partajată",
    'ippool_Manager__ip_exclusive' => "dedicată",
    'ui__client/ipaddress/properties__title' => "Administrare adrese IP",
    'ui__client/ipaddress/properties__description' => "Vizualizarea sau modificarea proprietăților adresei IP.",
    'ui__client/ipaddress_unknown-new__title' => "Adăugare adresă IP",
    'ui__client/ipaddress_unknown-new__short-title' => "Adăugare adresă IP",
    'ui__client/ipaddress_unknown-new__description' => "Adăugare adrese IP.",

    'ui__mass-mail#to_resellers_text__title' => "Reselleri",
    'ui__mass-mail#to_domainusers_text__title' => "Administratori de domeniu",
    'ui__mass-email#tools_legend__title' => "Instrumente",
    'ui__mass-email#list_legend__title' => 'Șabloane de mesaje e-mail în masă',
    'ui__mass-email#template_legend__title' => "Șablon",
    'ui__mass-email#from_email_text__title' => "De",
    'ui__mass-email#to_text__title' => 'Către',
    'ui__mass-email#to_resellers_text__title' => "Reselleri",
    'ui__mass-email#to_clients_text__title' => "Clienți",
    'ui__mass-email#to_domainusers_text__title' => "Administratori de domeniu",
    'ui__mass-email#to_admin_text__title' => "Administrator Plesk",
    'ui__mass-email#option_mode_all__title' => "Toate",
    'ui__mass-email#option_mode_select__title' => "Doar cele selectate",
    'ui__mass-email#option_mode_except__title' => "Toate, cu excepția celor selectate",
    'ui__mass-email#option_select_template__title' => '---Selectați un șablon---',
    'ui__mass-email#subject_text__title' => "Subiect",
    'ui__mass-email#body_text__title' => "Textul mesajului",
    'ui__mass-email#save_as_legend__title' => "Salvare ca șablon",
    'ui__mass-email#save_as_text__title' => "Salvarea mesajului scris într-un șablon nou, cu numele",
    'ui__reseller/preferences_unknown__wizard-title' => "Modificarea setărilor de cont",
    'ui__reseller/preferences_unknown__wizard__1_unknown' => "Selectați resellerul ale cărui setări de cont doriți să le modificați, apoi faceți clic pe Următorul.",
    'ui__reseller/preferences_unknown__wizard__2' => "Specificați setările de cont, apoi faceți clic pe OK.",
    'ippoolManager__ip_shared' => "partajată",
    'ippoolManager__ip_exclusive' => "dedicată",

    '__users_list' => "Utilizatori",
    '__users' => "Utilizatori",
    '__user_name' => "Nume utilizator",

    'limit__name_max_dom_aliases' => "aliasuri de domeniu",
    'limit__name_max_subftp_users' => "conturi FTP suplimentare",
    'limit__name_max_mssql_db' => "Baze de date Microsoft SQL Server",
    'limit__name_max_iis_app_pools' => "Liste de aplicații IIS",
    'limit__name_max_odbc' => "Conexiuni ODBC",
    'total_mboxes_quota_unsupported' => 'nu este acceptat de serverul de e-mail',
    'limit_soft__disk_space' => 'Se trimite notificare la atingerea limitei de spațiu pe disc',
    'limit_soft__max_traffic' => 'Se trimite notificare la atingerea limitei de trafic',
    'dsr__of_reseller_title' => "Utilizarea resurselor de domenii",
    'limitsManager__commit_failed' => "Imposibil de modificat limitele de resurse.",
    'limitsManager__date_in_past' => "Dată de expirare incorectă %1.",
    'limitsManager__limit_not_supported' => "Nu se pot seta limitele pentru tipul de resurse %1.",
    'limitsManager__limit_oversell_inconsistency' => "Imposibil de alocat volumele de resurse specificate: funcția de supravânzare este dezactivată.",
    'limitsManager__limit_overuse_inconsistency' => "Utilizarea resurselor depășește limitele definite.",
    'limitsManager__no_resource_available' => "Nu mai există resurse disponibile de acest tip (%%limitName%%). Necesar: %%quantity%% Disponibil: %%unused%%.",
    'limitsManager__no_total_resource_available' => "Nu mai sunt disponibile resurse de acest tip (%%limitName%%) de la furnizorul de servicii. Necesar: %%quantity%% Disponibil: %%unused%%.",
    'limitsManager__invalid_expiration_limit' => "Data expirării trebuie să fie anterioară sau egală cu %1.",
    'limitsManager__invalid_disk_space_limit' => "Spațiul de disc trebuie să fie mai mic decât sau egal cu %1.",
    'limitsManager__invalid_max_traffic_limit' => "Volumul de trafic trebuie să fie mai mic decât sau egal cu %1.",
    'ippoolManager__ip_has_suballocations' => "Imposibil de modificat tipul adresei IP deja alocate unui utilizator. Adresa IP %%ip%% este alocată deja utilizatorilor ca adresă IP %%reserved%%.",
    'ippoolManager__ip_is_already_in_pool' => "Această adresă IP este atribuită deja utilizatorului.",
    'ippoolManager__ip_is_not_in_pool' => "În domeniul de adrese nu există adresa IP %%ip%%.",
    'ippoolManager__can_not_allocate_ip' => "Adresa IP %%ip%% este disponibilă numai ca %%available%%.",
    'ippoolManager__unable_to_set_default_type' => "Adresa IP %%ip%% nu se poate aloca drept dedicată.",
    'ippoolManager__ip_used_by_hst_or_frw' => "Adresa IP %%ip%% este utilizată deja pentru găzduire.",
    'ippoolManager__active_anon_ftp_on_ip' => "Accesul la serviciul FTP anonim este activat deja pentru adresa IP %%ip%%",
    'ippoolManager__no_vacant_ips' => "Nu există adrese IP libere.",
    'ippoolManager__no_available_ips' => "Nu există adrese IP disponibile.",
    'templates__dublicate_name' => "Deja există un șablon cu acest nume. Selectați un alt nume pentru acest șablon.",
    'cl_perm__client_limits_exceeded' => "Limitele de resurse specificate depășesc valoarea permisă de planul de găzduire sau vă asigură mai puține resurse decât cele utilizate de site-urile dvs.",
    'cl_perm__reseller_limits_exceeded' => "Limitele de resurse specificate depășesc valoarea permisă de planul de găzduire sau vă asigură mai puține resurse decât cele utilizate de conturile de utilizator și de site-urile dvs.",

    'site_apps__preferences_show_all_versions_title' => "Se afișează lista completă a versiunilor fiecărei aplicații preluate din catalog",
    'site_apps__preferences_show_all_versions_hint' => "Dacă această opțiune este selectată, este posibil ca preluarea recuperarea tuturor versiunilor fiecărei aplicații să dureze mult la fiecare deschidere a catalogului. Dacă opțiunea nu este selectată, se afișează doar ultimele versiuni.",
    '__select_user_template' => "Crearea unui cont de utilizator pornind de la un șablon",
    'ip_already_added_to_all_clients' => "Această adresă IP este deja atribuită tuturor utilizatorilor.",
    'ui__server/ip-address/client/delete#legend__description' => "Următoarele adrese IP vor fi șterse din sistem și din domeniile de adrese IP ale utilizatorilor:",

    'site_apps__cancelled_apps' => "Ați revocat adăugarea următoarelor aplicații: %2",

    'sb_url_is_not_resolved' => 'Imposibil de rezolvat URL-ul: verificați setările de DNS. Rezolvarea URL-ului %1 trebuie să fie adresa IP a serverului pe care este instalat sistemul Presence Builder.',

    'ip_addr__is_last_on_interface' => 'Adresa IP %%ip%% nu poate fi ștearsă pentru că este ultima adresă IP prezentă pe o interfață de rețea.',
    'ip_addr__used_for_current_session' => 'Adresa IP %%ip%% nu poate fi ștearsă pentru că este utilizată de o sesiune activă.',
    'ip_addr__used_for_hosting' => 'Adresa IP %%ip%% nu poate fi ștearsă pentru că este utilizată pentru găzduirea unui site web.',
    'ip_addr__is_main' => 'Adresa IP %%ip%% nu poate fi ștearsă pentru că este adresa IP principală a unei interfețe de rețea.',
    'ip_addr__ip_used_by_message_submission' => 'Adresa IP %%ip%% nu poate fi ștearsă pentru că este utilizată pentru trimiterea mesajelor de e-mail',

    // RESELLER ACTION LOG

    '__cl_domains' => 'domeniile clienților',
    'excl_ip_num' => 'Adresă IP dedicată',

    'sb_err_sitebuilder_not_installed' => 'Presence Builder nu este instalat.',

    '__perm_allow_oversell_can_not_be_revoked' => 'Permisiunea de supravânzare nu se poate revoca de la utilizator pentru că deja i s-au alocat mai multe resurse decât cele disponibile. Se trece în modul supravânzare.',
    'limitsManager__invalid_limit_value' => 'Valoare incorectă %%value%% specificată pentru limita %%limit_name%%',
    'ip_alias__type' => "Adresă IP distribuită ca",
    'ip_alias__in_type' => 'Adresă IP alocată ca',
    'ui__client/ipaddress/delete_multi__title' => 'Ștergere adrese IP',
    'ui__client/ipaddress/delete#legend__short-title' => 'Articole care vor fi șterse',
    'ui__client/ipaddress/delete#legend__description' => "Următoarele adrese IP vor fi șterse din domeniul de adrese IP al utilizatorului:",
    'ui__client/ipaddress/delete#nlegend__short-title' => 'Articole care nu pot fi șterse',
    'ui__client/ipaddress/delete#nlegend__description' => 'Următoarele adrese IP nu pot fi șterse:',
    'ui__server/ip-address/delete#legend__description' => 'Următoarele adrese IP vor fi șterse din domeniul de adrese IP al serverului:',
    'confirmationForm_default_agreement_text' => 'Confirmați operația',
    'confirmationForm_default_confirm_message' => 'Confirmați operația.',
    'limit__max_mn' => 'Număr maxim de conturi e-mail',

    'limits__client_overuse_description' => 'Politica de suprautilizare comunică sistemului Plesk ce măsuri trebuie luate în cazul în care se utilizează resurse dincolo de alocarea inițială.',
    'limits__client_overuse_block_true_description' => 'Se blochează suprautilizarea resurselor. Utilizarea efectivă a resurselor nu poate depăși alocarea inițială',
    'limits__client_overuse_block_false_description' => 'Nu se blochează suprautilizarea resurselor, clientul poate utiliza mai multe resurse decât cele alocate inițial. Utilizarea efectivă a resurselor poate depăși alocarea inițială',
    'limits__client_overuse_notify_text' => 'Se trimite o notificare clientului în legătură cu atingerea limitelor de resurse',

    'limits__domain_overuse_description' => 'Politica de suprautilizare comunică sistemului Plesk ce măsuri trebuie luate în cazul în care se utilizează resurse dincolo de alocarea inițială.',
    'limits__domain_overuse_block_true_description' => 'Politica de suprautilizare comunică sistemului Plesk ce măsuri trebuie luate în cazul suprautilizării resurselor.',
    'limits__domain_overuse_block_false_description' => 'Nu se blochează suprautilizarea resurselor, domeniul poate utiliza mai multe resurse decât a primit inițial. Utilizarea efectivă a resurselor poate depăși alocarea inițială',
    'limits__domain_overuse_notify_text' => 'Se trimite o notificare proprietarului de domeniu în legătură cu atingerea limitelor de resurse',


    'cancel_remove' => 'Renunțare la modificări și revenire la pagina anterioară.',
    'php_not_installed' => 'PHP nu este instalat',

    'dns__dns_rr_delete' => 'Articole care vor fi șterse',
    'dns__delete_rr' => 'Următoarele înregistrări DNS vor fi șterse din zona DNS:',
    'dns__dns_rr_delete_non_removable' => 'Articole care nu pot fi șterse',
    'dns__non_delete_rr' => 'Următoarele înregistrări DNS nu pot fi șterse:',
    'dns__dns_rr_delete_confirm_message' => 'Confirmați ștergerea înregistrărilor DNS',

    'site_apps__format_is_unsupported_broadcast_not_set' => 'Format necunoscut de aplicație web: aplicația poate fi indisponibilă pentru instalare și utilizare.',

    '__php_handler_type_desc' => 'PHP se execută ca',
    'sfdk_domain_sign__failed' => 'Eroare neidentificată la încercarea de a activa semnarea e-mailurilor cu DKIM în domeniu. Pentru informații suplimentare, consultați jurnalul de erori de pe server.',

    // key management ported from cpp to php
    'pkey_notify__subj_update_success_notification' => 'Notificare de actualizare cu succes a cheii Plesk',
    'pkey_notify__subj_update_deferral_notification' => 'Notificare de amânare a actualizării cheii Plesk',
    'pkey_notify__subj_update_error_notification' => 'Notificare de eroare la actualizarea cheii Plesk',
    'pkey_notify__update_successful' => '%1 actualizare finalizată cu succes.',
    'pkey_notify__update_failed_no_more_try' => 'Imposibil de actualizat %1. Cheia pe care încercați să o trimiteți este incorectă. Nu trebuie să faceți alte încercări de actualizare a acestei chei.',
    'pkey_notify__update_failed_try_later' => 'Imposibil de actualizat %1: eroare la prelucrarea cheii. Puteți încerca să preluați manual cheia în Plesk (Instrumente și setări> Informații despre licență) sau să lăsați Plesk să facă o tentativă de actualizare a acesteia în următoarele 24 de ore. Dacă nu doriți să mai primiți această notificare, ștergeți această cheie din Plesk.',

    // spam assassin error messages
    'ui__server/spam-filter/toggle__unable_disable' => 'Imposibil de dezactivat filtrul antispam la nivel de server.',
    'ui__server/spam-filter/toggle__unable_enable' => 'Imposibil de activat filtrul antispam la nivel de server',

    // Application vault/ application pool for admin mapping - TEMPORARY

    // report
    'report_auto__recipient_reseller' => 'Acest reseller',
    'report_auto__select_reseller_report_all' => 'Toți resellerii',
    'report_auto__select_reseller_report_client' => 'Toți resellerii acestui client',
    'report_auto__select_reseller_report_current' => 'Acest reseller',
    'report_auto__select_reseller_report_reseller' => '%1',
    'report_auto__select_client_report_reseller' => 'Toți clienții acestui reseller',
    'report_auto__select_client_report_client' => 'Acest client',
    'report_auto__select_client_report_other_reseller' => '%1',
    'report_auto__select_admin_report_all' => 'Reselleri, domenii și clienți',

    'rpt_reseller_section_full_domains' => 'Domenii',
    'rpt_reseller_dom_subdomains' => 'Subdomenii',
    'rpt_reseller_dom_domain_aliases' => 'Aliasuri de baze date',
    'rpt_reseller_dom_postboxes' => 'Căsuțe poștale',
    'rpt_reseller_dom_redirects' => 'Redirecționări',
    'rpt_reseller_dom_mail_groups' => 'Grupuri e-mail',
    'rpt_reseller_dom_mail_resps' => 'Răspuns automat',
    'rpt_reseller_dom_mail_antispam' => 'Antispam',
    'rpt_reseller_dom_mail_antivirus' => 'Antivirus',
    'rpt_reseller_dom_mail_lists' => 'Liste e-mail',
    'rpt_reseller_dom_web_users' => 'Utilizatori web',
    'rpt_reseller_dom_data_bases' => 'Bază de date MySQL',
    'rpt_reseller_dom_mssql_data_bases' => 'Bază de date MSSQL',

    'rpt_reseller_section_full_clients' => 'Clienți',
    '__cl_name' => 'Nume client',
    '__cl_creation_date' => 'Data creării',
    '__clients_traffic' => 'Trafic client',
    'rpt_reseller_cl_mail_antispam' => 'Antispam',
    'rpt_reseller_cl_mail_antivirus' => 'Antivirus',

    // CONHELPS FOR HOME PAGE
    // common:
    'sitebuilder_not_installed' => 'Presence Builder nu este instalat.',
    'sitebuilder_disabled' => 'Presence Builder este dezactivat.',
    'b_sitebuilder_disabled' => 'Presence Builder este dezactivat.',
    'webmail_not_installed' => 'Software-ul de e-mail prin web nu este instalat.',
    'webmail_disabled' => 'Serviciul de e-mail prin web este dezactivat.',
    'spamassassin_not_installed' => 'SpamAssassin nu este instalat.',
    // pfu:
    'anonymous_ftp_shared' => 'Imposibil de configurat FTP anonim: tip adresă IP partajată.',
    'anonymous_ftp_used' => 'Imposibil de configurat FTP anonim: adresa IP este utilizată de un alt domeniu pentru serviciul FTP anonim.',
    'sshterm__not_installed' => 'Terminalul SSH nu este instalat.',
    'sshterm__empty_shell' => 'Pentru a putea utiliza clientul de terminal, trebuie să permiteți accesul shell pentru acest domeniu.',
    // pfw:
    'aspdotnet_not_installed' => 'ASP.NET nu este instalat.',
    'site_builder_no_package' => 'Presence Builder nu este disponibil. Verificați dacă Presence Builder este instalat și selectat drept componentă activă.',
    'site_builder_not_configured' => 'Presence Builder nu este configurat.',

    // LIST OF CLIENTS
    // under reseller
    'ui__reseller/client#tools__title' => 'Instrumente',
    'ui__reseller/client#clientslist__title' => 'Clienți',

    //reseller accounts removal





    // NEW HOME PAGE WIZARDS

    // PFW-only

    'ui__client/domain/odbc_unknown__wizard-title' => "Configurarea surselor de date ODBC pentru site",
    'ui__client/domain/odbc_unknown__wizard__2_unknown' => "Selectați site-ul pentru ale cărui aplicații doriți să configurați sursele de date ODBC.",

    'ui__client/domain/hosting/web-directories_unknown__wizard-title' => 'Administrarea directoarelor virtuale ale unui site web',
    'ui__client/domain/hosting/web-directories_unknown__wizard__2_unknown' => "Selectați site-ul ale cărui directoare doriți să le administrați.",

    'ui__client/domain/hosting/hotlink-protection_unknown__wizard-title' => "Configurarea protecției hotlink pentru domeniu",
    'ui__client/domain/hosting/hotlink-protection_unknown__wizard__2_unknown' => "Selectați domeniul ale cărui fișiere doriți să le protejați împotriva practicilor de hotlinking.",

    // COMMON WIZARDS


    'ui__client/domain/hosting/anonymous-ftp_unknown__wizard-title' => 'Configurare FTP anonim pentru un domeniu',
    'ui__client/domain/hosting/anonymous-ftp_unknown__wizard__2_unknown' => 'Selectați domeniul pentru care doriți să configurați FTP anonim.',

    'ui__client/domain/hosting/protected-directories_unknown__wizard-title' => 'Administrare directoare protejate cu parolă din domeniu',
    'ui__client/domain/hosting/protected-directories_unknown__wizard__2_unknown' => 'Selectați domeniul în care doriți să administrați directoarele protejate prin parolă.',

    'ui__client/domain/hosting/logs_unknown__wizard-title' => 'Configurarea managerului de jurnale pentru domeniu și vizualizarea fișierelor jurnal de domeniu',
    'ui__client/domain/hosting/logs_unknown__wizard__2_unknown' => 'Selectați domeniul al cărui manager de jurnale doriți să îl configurați și ale cărui fișiere jurnal doriți să le vizualizați.',

    'ui__client/domain/certificate_unknown__wizard-title' => 'Administrare certificate SSL/TLS pentru domeniu',
    'ui__client/domain/certificate_unknown__wizard__2_unknown' => 'Selectați domeniul ale cărui certificate SSL/TLS doriți să le administrați.',

    'ui__client/domain/disable_multi__wizard-title' => 'Suspendare domenii',
    'ui__client/domain/disable_multi__wizard__2_multi' => 'Selectați domeniile pe care doriți să le suspendați.',

    'ui__client/domain/enable_multi__wizard-title' => 'Activare domenii',
    'ui__client/domain/enable_multi__wizard__2_multi' => 'Selectați domeniile pe care doriți să le activați.',

    'ui__client/domain_unknown__wizard-title' => 'Vizualizare domenii',
    'ui__client/domain_unknown__wizard__1_unknown' => 'Selectați clientul ale cărui domenii doriți să le vizualizați.',

    'ui__client/domain/register_unknown__wizard-title' => 'Înregistrare domenii',
    'ui__client/domain/register_unknown__wizard__2_unknown' => 'Selectați domeniul pe care doriți să îl înregistrați.',

    'ui__client/domain/extras_unknown__wizard-title' => 'Utilizați Instrumente din MyPlesk.com',
    'ui__client/domain/extras_unknown__wizard__2_unknown' => 'Selectați domeniul pe care doriți să îl administrați cu instrumente de la MyPlesk.com.',



    'ui__client/domain/hosting/ssh-terminal_unknown__wizard-title' => 'Accesare server prin SSH', // PFU
    'ui__client/domain/hosting/ssh-terminal_unknown__wizard__2_unknown' => 'Selectați gazda virtuală la care doriți să vă conectați prin SSH.', // PFU

    // various

    'ui__server/ip-address/client_unknown__short-title' => 'Utilizatori adresă IP',
    'ui__server/ip-address/client_unknown__title' => 'Utilizatori adresă IP',
    'ui__server/ip-address/client_unknown__description' => 'Utilizatorii adresei IP %1',

    'disabled_by_admin' => 'Dezactivat de administratorul de server',






    'ui__client/domain/chowner_multi__short-title' => 'Schimbare proprietar',
    'ui__client/domain/chowner_multi__title' => 'Modificarea proprietarului abonamentului',
    'ui__client/domain/chowner_multi__description' => 'Modificarea proprietarului abonamentului.',

    'ui__client/domain/chowner_multi__wizard__2_multi' => 'Selectați domeniul pentru care doriți să doriți să modificați proprietarul și faceți clic pe Următorul >>.',
    'ui__client/domain/chowner_unknown__short-title' => 'Schimbare proprietar',
    'ui__client/domain/chowner_unknown__title' => 'Modificarea proprietarului abonamentului',
    'ui__client/domain/chowner_unknown__description' => 'Modificarea proprietarului abonamentului.',

    'ui__client/domain/chowner_unknown__wizard-title' => 'Modificarea proprietarului abonamentului',

    //custom buttons reseller home support
    //ui captions
    'ui__reseller/custom-buttons/custom-button__none-available' => 'Nu există butoane personalizate.',
    'ui__reseller/custom-buttons/custom-button__none-available__1' => 'Nu există butoane personalizate în interfața resellerului %1.',

    'ui__reseller/custom-buttons/custom-button/delete__description' => 'Ștergerea butonului %1.',

    'ui__reseller/custom-buttons/custom-button/delete__short-title' => 'Ștergere',
    'ui__reseller/custom-buttons/custom-button/delete__title' => 'Ștergerea butonului %1',
    'ui__reseller/custom-buttons/custom-button/delete_multi__description' => 'Ștergerea butoanelor personalizate din interfața resellerului',

    'ui__reseller/custom-buttons/custom-button/delete_multi__short-title' => 'Ștergere',
    'ui__reseller/custom-buttons/custom-button/delete_multi__title' => 'Ștergere butoane personalizate',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard-title' => 'Ștergere butoane',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard__1_unknown' => 'Selectați resellerul ale cărui butoane personalizate doriți să le ștergeți, apoi faceți clic pe Următorul >>.',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard__3_multi' => 'Selectați butoanele pe care doriți să le ștergeți și apăsați Următorul >>.',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard__4_multi' => 'Confirmați ștergerea butoanelor prin bifarea casetei din această pagină, apoi faceți clic pe Terminare.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__description' => 'Ștergerea unui buton personalizat din interfața resellerului.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__short-title' => 'Ștergere',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__title' => 'Ștergerea unui buton personalizat',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard-title' => 'Ștergere buton personalizat',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard__1_unknown' => 'Selectați resellerul al cărui buton personalizat doriți să îl ștergeți, apoi faceți clic pe Următorul >>.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard__3_unknown' => 'Selectați butonul personalizat pe care doriți să îl ștergeți și faceți clic pe Următorul >>.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard__4' => 'Confirmați ștergerea butonului personalizat prin bifarea casetei din acest ecran, apoi faceți clic pe Terminare.',

    'ui__reseller/custom-buttons/custom-button/properties__description' => 'Editarea proprietăților butonului personalizat %1 al resellerului.',

    'ui__reseller/custom-buttons/custom-button/properties__short-title' => 'Setări',
    'ui__reseller/custom-buttons/custom-button/properties__title' => 'Modificarea butonului personalizat %1 a resellerului',

    'ui__reseller/custom-buttons/custom-button/properties_new__wizard-title' => 'Adăugare buton personalizat',
    'ui__reseller/custom-buttons/custom-button/properties_new__wizard__1_unknown' => 'Selectați resellerul în al cărui panou de comandă doriți să creați butonul personalizat, apoi faceți clic pe control>>.',
    'ui__reseller/custom-buttons/custom-button/properties_new__wizard__4_new' => 'Faceți clic pe Terminare pentru a crea butonul.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__description' => 'Modificarea proprietăților butonului din panoul de control al resellerului.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__short-title' => 'Proprietăți',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__title' => 'Modificarea proprietăților butonului din panoul de control al resellerului',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard-title' => 'Modificarea proprietăților butonului personalizat',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard__1_unknown' => 'Selectați resellerul al cărui buton personalizat doriți să îl modificați și faceți clic pe Următorul >>.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard__3_unknown' => 'Selectați butonul personalizat pe care doriți să-l modificați și apăsați Următorul >>.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard__4' => 'După ce ați terminat de editat proprietățile butonului faceți clic pe Terminare pentru a aplica schimbările și pentru a închide expertul.',

    'ui__reseller/custom-buttons/custom-button/toggle_private__description' => 'Setarea butonului personalizat %1 ca inaccesibil clienților.',

    'ui__reseller/custom-buttons/custom-button/toggle_private__short-title' => 'Butonul nu va fi accesibil clienților',
    'ui__reseller/custom-buttons/custom-button/toggle_private__title' => 'Setarea butonului personalizat %1 ca inaccesibil clienților',
    'ui__reseller/custom-buttons/custom-button/toggle_public__description' => 'Setarea butonului %1 drept vizibil pentru clienții resellerului.',
    'ui__reseller/custom-buttons/custom-button/toggle_public__short-title' => 'Butonul va fi accesibil clienților',
    'ui__reseller/custom-buttons/custom-button/toggle_public__title' => 'Setarea butonului %1 drept vizibil pentru clienții resellerului',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__description' => 'Setarea unui buton personalizat drept accesibil/inaccesibil clienților.',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__short-title' => 'Butonul va fi accesibil/inaccesibil clienților',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__title' => 'Setarea unui buton personalizat drept accesibil sau inaccesibil clienților',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__wizard-title' => 'Setarea unui buton personalizat drept accesibil/inaccesibil clienților.',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__wizard__1_unknown' => 'Selectați un reseller al cărui buton personalizat doriți să îl faceți disponibil clienților, apoi faceți clic pe Următorul >>.',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__wizard__3_unknown' => 'Selectați butonul personalizat pe care doriți să îl setați drept accesibil sau inaccesibil clienților, apoi faceți clic pe Următorul >>.',




    'ui__server/ip-addresses__short-title' => 'Adrese IP',
    'ui__server/ip-addresses__title' => 'Administrare adrese IP',
    'ui__server/ip-addresses__description' => 'Adăugarea, ștergerea și atribuirea adreselor IP.',

    'ip_ctrl__allow_ftps' => 'Se permite FTP prin SSL/TLS',
    '__ftps' => 'FTP prin SSL/TLS',
    '__not_allowed' => 'Nu se permite',



    'ui__client/ipaddress/domain_unknown__short-title' => 'Domenii care utilizează %2',
    'ui__client/ipaddress/domain_unknown__title' => 'Domenii care utilizează adresa IP %1 %2',
    'ui__client/ipaddress/domain_unknown__description' => 'Vizualizarea listei de domenii care utilizează adresa IP %1 %2',

    'ui__client/ipaddress__none-available' => 'Nu există nicio adresă IP disponibilă',
    'ui__client/ipaddress__none-available__1' => 'Nu există nicio adresă IP disponibilă',

    'ui__client/domain/chowner__wizard__3' => '',
    'ui__client/domain/chowner__wizard__3_select' => 'Selectați noul proprietar al domeniului.',

    '__ip_addr_state_unknown' => "Adresa IP nu este operaționala pentru că sistemul încă procesează solicitarea dvs. Vă rugăm să așteptați.",


    'resellers_list__accounts' => 'Utilizatori',

    'ip_addr__repair_is_not_allowed' => 'Adresa IP nu poate fi reparată în mediul Virtuozzo.',

    'ui__reseller/client__none-available__1' => 'Resellerul %1 nu are clienți.',

    'ippoolManager__ip_used_by_nohost_domain' => "Adresa IP %%ip%% nu poate fi ștearsă pentru că este utilizată de una sau mai multe domenii fără găzduire.",
    'ippoolManager__ip_used_for_mail_service' => "Adresa IP %%ip%% nu poate fi ștearsă pentru că este utilizată de unu sau mai multe domenii drept adresă IP a serviciului de e-mail.",
    'ippoolManager__ip_used_for_send_emails' => "Adresa IP %%ip%% nu poate fi ștearsă pentru că este utilizată pentru trimiterea de e-mailuri de la o adresă IP determinată (consultați Setările serverului de e-mail).",
    'ippoolManager__ip_used_in_dns_zone' => 'Adresa IP %%ip%% nu poate fi ștearsă pentru că este utilizată de zona DNS a unei sau mai multe domenii.',
    'ip_ctrl__cannot_manage_on_vz' => 'Această instalare de Plesk funcționează în containere Virtuozzo. Doar administratorul de nod al containerelor Virtuozzo poate adăuga adrese IP noi.',

    'client_template__limits_auto_adjusted' => 'Limitele din șablonul de client au fost ajustate automat.',

    '__entries' => 'Intrări',

    '__path_is_not_set' => 'Cale nespecificată. Specificați o cale corectă.',

    'defaultcomponents__imap_required' => '(Serverul de e-mail actual nu acceptă IMAP)',

    // Hotlink protection conhelp // PFW
    'i_hotlinkprotection_on' => 'Serviciul de protecție de hotlink este activat pentru acest domeniu.',
    'i_hotlinkprotection_off' => 'Serviciul de protecție de hotlink este dezactivat pentru acest domeniu.',

    '__commercial_web_stats_not_installed' => 'Plesk acceptă calculul statisticilor pentru subdomenii numai cu software comercial de statistici web. În prezent nu există asemenea software instalat în sistem.',

    'mail__spamassassin_personal_settings_disallowed' => 'Administratorul de server a dezactivat posibilitatea de a aplica setări de filtrare antispam personale. Setările de filtrare antispam specificate nu vor fi aplicate',

    // CLI keys, should be moved to separate file after 9.0
    'cu__unable_create_object' => 'Imposibil de creat obiectul %1: %2',
    'cu_dom_pref__invalid_expiration_date' => 'Dată a expirării incorectă: %1',
    'cu_cl_pref__illegal_date_val' => 'Ați specificat o valoare a datei neacceptată („%1”)',
    'cu_cl_pref__illegal_date_greater_less' => 'Introduceți anul, cuprins între „%1” și „%2”',
    'cu_initconf__unable_set_ip_alias_type' => 'Tipul de alias IP nu poate fi setat: %1',
    'cu_mlist__unable_change_status' => "Starea listei de e-mail nu poate fi modificată: %1",
    'cu_initconf__unable_change_passwd' => "Parola de administrator nu poate fi schimbată: %1",
    'cu_serverpref__option_description_include_remote_databases' => 'Includerea bazelor de date MySQL la distanță în calculul utilizării spațiului pe disc.',
    'cu_siteapp_item__add_to_pool_success' => 'Aplicația web a fost adăugată la lista de aplicații.',
    'cu_siteapp_item__remove_from_pool_success' => 'Aplicația web a fost ștearsă din lista de aplicații.',
    'cu_traffic_command_description_add_user' => 'Înregistrarea unui anumit volum de trafic ca utilizat deja de client/reseller',
    'cu_traffic_command_description_sub_user' => 'Scăderea unui anumit volum de trafic din volumul înregistrat pentru client/reseller',
    'cu_traffic_command_description_add_batch_user' => 'Înregistrarea unui anumit volum de trafic ca utilizat deja de client/reseller (mod lot)',
    'cu_traffic_command_description_del_user' => 'Resetarea la zero a traficului înregistrat pentru acest client/reseller',
    'cu_resellerpref__option_lock_screen' => 'Îi împiedică pe utilizatori să lucreze cu Plesk înainte de încărcarea completă a ecranelor de interfață',

    'server_settings_invalid_traffic_statistics' => 'Parametru de păstrare a statisticilor de trafic incorect.',
    'server_settings_invalid_logrotate_period' => 'Parametru de perioadă de rotație a jurnalelor incorect.',
];