<?php
// Copyright 1999-2023. Plesk International GmbH. All rights reserved.
$messages = [
    'action-log.logFiles' => "Archivos de registro",
    'action-log.fromDate' => "Desde:",
    'action-log.toDate' => "Hasta:",
    'action-log.clearLog' => "Borrar registro",
    'action-log.downloadLog' => "Descargar",
    'action-log.loggedActions' => "Acciones registradas",
    'action-log.storeLogsInDb' => "Guardar registros en la base de datos",
    'action-log.storeNumber' => "Entradas",
    'action-log.dontRemoveRecs' => "No eliminar registros",
    'action-log.confirmCleanLog' => "¿Está seguro de que desea eliminar los registros de acción seleccionados?",
    'action-log.incorrectDate' => "Fecha especificada no válida.",
    'action-log.incorrectNumPeriods' => "Período de rotación especificado no válido.",
    'action-log.incorrectNumRecords' => "Número de registros especificado no válido.",
    'action-log.yes' => "Sí",
    'action-log.no' => "No",
    'action-log.mixed' => "(combinado)",
    'action-log.period' => "Periodo",
    'action-log.invalidDatePeriod' => "Periodo de fecha no válido",
    'action-log.submitDone' => "Los cambios en la configuración del registro de acciones han sido guardados.",
    'action-log.clearDone' => "Registro de acciones eliminado.",
    'action-log.periodDay' => "días",
    'action-log.periodWeek' => "semanas",
    'action-log.periodMonth' => "meses",

    'admin-info.adminInfoSection' => 'Información para el administrador',
    'admin-info.description-admin' => 'Descripción del administrador',
    'admin-info.description-reseller' => 'Descripción del revendedor',
    'admin-info.description-owner' => 'Descripción del propietario',
    'admin-info.description' => 'Descripción',
    'admin-info.descriptionSuccess' => 'La descripción ha sido actualizada.',
    'admin-info.longDescription' => 'La descripción indicada es demasiado larga. Esta no puede tener más de %%max%% símbolos.',
    'admin-info.add' => 'Añadir descripción',
    'admin-info.edit' => 'Editar',
    'admin-info.remove' => 'Eliminar',
    'admin-info.confirmOnRemove' => '¿Desea eliminar esta descripción?',
    'admin-info.popupTitle-customer' => '%%descriptionType%% del cliente %%name%%',
    'admin-info.popupTitle-reseller' => '%%descriptionType%% del revendedor %%name%%',
    'admin-info.popupTitle-subscription' => '%%descriptionType%% de la suscripción %%name%%',
    'admin-info.popupTitle-site' => '%%descriptionType%% de %%name%%',
    'admin-info.popupHint-admin' => 'Esta descripción solo es visible para el administrador.',
    'admin-info.popupHint-reseller' => 'Esta descripción es visible para el revendedor y el administrador.',
    'admin-info.popupHint-owner' => 'Esta descripción es visible para la persona que la ha escrito y para el proveedor de hosting de dicha persona.',
    'admin-info.customerDescriptionHint' => 'Los clientes no pueden ver esta descripción.',
    'admin-info.subscriptionDescriptionHint' => "Esta información únicamente la verá el proveedor de hosting (el revendedor o administrador de Plesk).",

    'apache-settings.formGeneralHint' => 'Aquí puede configurar los parámetros del servidor web Apache para este sitio web. Por ejemplo, la configuración personalizada de Apache puede resultarle útil si desea utilizar un nuevo tipo de archivos de índice en su sitio web o si desea asociar un determinado tipo MIME a ciertas extensiones de nombre de archivo. El valor Predeterminado indica que Apache utilizará la directiva correspondiente de la configuración a nivel del servidor. Si Apache se está ejecutando con nginx como servidor frontend, aquí también puede editar la configuración de nginx.',
    'apache-settings.general' => 'Configuración común de Apache',
    'apache-settings.example' => "Por ejemplo:\n%%example%%",
    'apache-settings.settingOn' => 'Activado',
    'apache-settings.settingOff' => 'Desactivado (predeterminado)',
    'apache-settings.settingDefault' => 'Predeterminado',
    'apache-settings.settingCustom' => 'Introduzca un valor personalizado',
    'apache-settings.mimeTypes' => 'Tipos MIME',
    'apache-settings.mimeTypesExample' => "text/plain .txt\nimage/jpeg .jpeg",
    'apache-settings.mimeTypesFullDescription' => 'Los tipos MIME asocian extensiones de archivo con tipos de archivo. Generalmente esto se usa para crear una extensión de archivo personalizada para tipos de archivo comunes.',
    'apache-settings.handlers' => 'Controladores',
    'apache-settings.handlersExample' => "php-script .php\ncgi-script .cgi",
    'apache-settings.handlersFullDescription' => "Los controladores Apache definen la forma en la que el servidor web procesa los archivos de determinadas extensiones cuando son solicitados. Por ejemplo, la cadena 'php-script .script' significa que Apache gestionará los archivos .script como scripts php.",
    'apache-settings.deny' => 'Denegar acceso al sitio',
    'apache-settings.allow' => 'A excepción de',
    'apache-settings.denyExample' => "10.1.0.0/16\n192.168.1.110\n\nLos hosts y las redes especificados no disponen de permiso de acceso al sitio. Utilice '*' para denegar todas las conexiones.",
    'apache-settings.allowExample' => "192.168.0.0/16\n10.1.1.21\n\nLos hosts y las redes especificados disponen de permiso de acceso al sitio.",
    'apache-settings.directoryIndex' => 'Archivos de índice',
    'apache-settings.directoryIndexExample' => "index.htm index.php index.pl",
    'apache-settings.directoryIndexFullDescription' => "Apache buscará los archivos especificados cuando se solicite la página de índice del sitio.",
    'apache-settings.expires' => 'Expira',
    'apache-settings.expiresStaticOnly' => 'responder con encabezados Expira únicamente para archivos estáticos',
    'apache-settings.expiresFullDescription' => 'El servidor web añadirá los encabezados de respuesta "Expira" a las páginas web. La marca de hora de expiración se obtiene añadiendo la cantidad de tiempo indicada arriba a la hora en la que se solicitó una página web.',
    'apache-settings.expiresStaticOnlyDescription' => 'El encabezado "Expira" sólo se añadirá a archivos estáticos. Las opciones "Procesamiento inteligente de archivos estáticos" y "Servir archivos estáticos directamente mediante nginx" son las que determinan los archivos que se tratan como estáticos.',
    'apache-settings.expiresUnitDays' => 'días',
    'apache-settings.expiresUnitHours' => 'horas',
    'apache-settings.expiresUnitMinutes' => 'minutos',
    'apache-settings.expiresUnitSeconds' => 'segundos',
    'apache-settings.headers' => 'Encabezados adicionales',
    'apache-settings.headersExample' => "Cache-Control: public\nStrict-Transport-Security: max-age=63072000\nX-Frame-Options: DENY",
    'apache-settings.headersFullDescription' => "El servidor web añadirá los encabezados de respuesta HTTP especificados.",
    'apache-settings.restrictFollowSymLinks' => 'Limitar la habilidad para seguir enlaces simbólicos',
    'apache-settings.restrictFollowSymLinksDescription' => "Seleccione esta opción para prohibir a los usuarios hacer uso de la directiva FollowSymLink en .htaccess para así mejorar la seguridad del servidor.",
    'apache-settings.nginx' => 'configuración nginx',
    'apache-settings.nginxProxyMode' => 'Modo proxy',
    'apache-settings.nginxProxyModeDescription' => 'Peticiones de proxys Nginx a Apache Desactívelo para dejar de usar Apache.',
    'apache-settings.nginxTransparentMode' => 'Procesamiento inteligente de archivos estáticos',
    'apache-settings.nginxTransparentModeDescription' => 'Si se desactiva esta opción, Apache procesará todas las solicitudes para los archivos estáticos. nginx se limitará a pasar solicitudes y respuestas sin modificarlas. Desactive esta opción únicamente para la resolución de problemas.',
    'apache-settings.nginxServeStatic' => 'Servir archivos estáticos directamente mediante nginx',
    'apache-settings.nginxStaticExtensions' => 'Especifique las extensiones de los archivos separadas por espacios o por el símbolo "|". Las solicitudes para estos archivos serán administradas por nginx y no llegarán a Apache. Atención: La regla de reescritura de Apache no se aplicará.',
    'apache-settings.nginxServePhp' => 'Procesar PHP mediante nginx',
    'apache-settings.nginxServePhpDescription' => 'Los archivos PHP (.php) serán administrados por nginx y PHP-FPM. Si se desactiva, los archivos PHP serán procesados por Apache.',
    'apache-settings.nginxClientMaxBodySize' => 'Tamaño máximo permitido del cuerpo de la petición HTTP',
    'apache-settings.nginxClientMaxBodySizeDescription' => 'Las peticiones con un cuerpo superior al límite serán descartadas con HTTP 413 Payload Too Large (configura el valor de la directiva "client_max_body_size" de nginx).',
    'apache-settings.nginxClientMaxBodySizeDisabled' => 'La opción está desactivada globalmente mediante un valor vacío/zero de la directiva "clientMaxBodySize" en panel.ini',
    'apache-settings.nginxCacheEnabled' => 'Activar copia en caché nginx',
    'apache-settings.nginxCacheEnabledDescription' => 'La copia en caché puede reducir el tiempo de respuesta del sitio web y la carga del servidor, si bien debe usarse con precaución.',
    'apache-settings.nginxCacheSize' => 'Tamaño de la caché',
    'apache-settings.nginxCacheSizeGb' => 'GB',
    'apache-settings.nginxCacheSizeMb' => 'MB',
    'apache-settings.nginxCacheSizeKb' => 'KB',
    'apache-settings.nginxCacheSizeBytes' => 'B',
    'apache-settings.nginxCacheTimeout' => 'Tiempo de espera de caché',
    'apache-settings.nginxCacheTimeoutDays' => 'días',
    'apache-settings.nginxCacheTimeoutHours' => 'horas',
    'apache-settings.nginxCacheTimeoutMinutes' => 'minutos',
    'apache-settings.nginxCacheTimeoutSeconds' => 'segundos',
    'apache-settings.nginxCacheKey' => 'Clave de caché',
    'apache-settings.nginxCacheCookies' => 'Peticiones de la caché con cookies',
    'apache-settings.nginxCacheBypassLocations' => 'Desactivar copia en caché para ubicaciones',
    'apache-settings.nginxCacheBypass' => 'Omitir caché cuando',
    'apache-settings.nginxCacheBypassHeaderNocache' => 'Se reciban encabezados HTTP no-cache en la petición',
    'apache-settings.nginxCacheBypassHeaderAuth' => 'Se reciban encabezados de autorización HTTP en la petición',
    'apache-settings.nginxCacheBypassGetNocache' => 'Se reciba el parámetro GET nocache en la petición',
    'apache-settings.nginxCacheUseStale' => 'Devolver registros de estado copiados en caché',
    'apache-settings.nginxCacheUseStale5xx' => 'La subida devuelve un error de servidor 5xx',
    'apache-settings.nginxCacheUseStale4xx' => 'La subida devuelve un error de cliente 4xx',
    'apache-settings.nginxCacheUseStaleUpdating' => 'La caché está actualizándose',
    'apache-settings.additional' => 'Directivas adicionales de Apache',
    'apache-settings.additionalSettingsDescription' => 'Si no encuentra determinadas opciones, añádalas en los campos que se muestran a continuación. Estos ajustes sustituirán a las directivas de todo el servidor Apache. Las directivas del primer campo se utilizan cuando un visitante accede al sitio mediante HTTP. El segundo campo contiene las directivas para HTTPS. Generalmente, es necesario que añada sus directivas a ambos campos. Use la misma sintaxis que la usada para httpd.include. Por ejemplo, si desea establecer una página de error personalizada, añada la línea: ErrorDocument 401 /my_error_page.html',
    'apache-settings.additionalSettings' => 'Directivas adicionales para HTTP',
    'apache-settings.additionalSslSettings' => 'Directivas adicionales para HTTPS',
    'apache-settings.additionalSettingsError' => 'Configuración de Apache inválida:  %%error%%',
    'apache-settings.rollbackFailed' => 'No se puede utilizar el archivo de configuración Apache actual y revertir a la versión anterior del archivo porque contienen configuraciones inválidas.',
    'apache-settings.additionalNginx' => 'Directivas adicionales de nginx',
    'apache-settings.additionalNginxSettingsDescription' => 'Aquí puede especificar los ajustes del servidor nginx como proxy inverso de Apache. Los ajustes que establezca sustituirán a la configuración de todo el servidor nginx. Por ejemplo, en el caso de que desee cambiar el tiempo de espera de conexión o comprimir peticiones con gzip. Use la misma sintaxis que la usada para nginx.conf. Por ejemplo, si desea comprimir todas las peticiones autorizadas con gzip, añada la línea: \'gzip_proxied any;\'.',
    'apache-settings.additionalNginxSettings' => 'Directivas adicionales de nginx',
    'apache-settings.additionalNginxSettingsError' => 'Configuración de nginx inválida:  %%error%%',
    'apache-settings.nginxRollbackFailed' => 'No se puede utilizar el archivo de configuración nginx actual y revertir a la versión anterior del mismo porque ambos contienen configuraciones inválidas.',
    'apache-settings.clearCache' => 'Vaciar caché',
    'apache-settings.clearCacheHint' => 'Vaciar caché de nginx para %%website%%',
    'apache-settings.cacheHasClearedSuccessfuly' => 'La caché se ha vaciado correctamente',

    'backup.backup-password-protection.securitySettingsSection' => 'Configuración de seguridad de backups',
    'backup.backup-password-protection.backupPasswordFromFtpSettings' => 'Obtener contraseña a través de la configuración de almacenamiento remoto',
    'backup.backup-password-protection.backupPasswordManualInput' => 'Introducir contraseña manualmente',
    'backup.backup-password-protection.providePasswordCheckbox' => 'Indique la contraseña',
    'backup.backup-password-protection.backupPassword' => 'Contraseña',
    'backup.backup-password-protection.inputPasswordType' => 'Tipo de contraseña',
    'backup.backup-password-protection.confirmBackupPassword' => 'Confirme la contraseña',
    'backup.backup-password-protection.backupPasswordHint' => 'Si la ha olvidado, deseleccione esta opción. Tenga en cuenta que, en este caso, algunos datos confidenciales no serán restaurados correctamente. Por ejemplo, las contraseñas de usuario serán reemplazadas por contraseñas aleatorias, se perderán la información acerca de las aplicaciones APS instaladas, etc.',
    'backup.backup-password-protection.backupPasswordFtpHint' => 'Si utilizó protección con contraseña para este backup, introduzca la contraseña en los campos que aparecen a continuación. Tenga en cuenta que si proporciona una contraseña incorrecta, Plesk no restaurará el backup. En su lugar, el backup se copiará al almacenamiento local.',

    'backup.conflict-database.dbMappingLegend' => 'Asignación de servidor de bases de datos',
    'backup.conflict-database.serverType' => 'Tipo de servidor',
    'backup.conflict-database.hostName' => 'Nombre del host',
    'backup.conflict-database.port' => 'Puerto',
    'backup.conflict-database.destinationDbServer' => 'Servidor de bases de datos de destino',
    'backup.conflict-database.mysql' => 'MySQL',
    'backup.conflict-database.postgresql' => 'PostgreSQL',
    'backup.conflict-database.mssql' => 'MSSQL',
    'backup.conflict-database.migrationDbServerNotFind' => 'La base de datos no puede restaurarse: no existe ningún servidor de base de datos apropiado.',

    'backup.conflict-ip.buttonUploadMappingFile' => 'Cargar archivo de asignación de IPs',
    'backup.conflict-ip.ipMappingLegend' => 'Mapeo IP',
    'backup.conflict-ip.buttonSaveCurrentMapping' => 'Guardar asignación IP actual en archivo',
    'backup.conflict-ip.ipAddressNotFound' => 'No hay disponible ninguna dirección IP de este tipo.',
    'backup.conflict-ip.sharedIp' => 'compartida',
    'backup.conflict-ip.dedicatedIp' => 'dedicada',
    'backup.conflict-ip.fileNotFound' => 'El archivo no debe estar vacío.',
    'backup.conflict-ip.invalidIpToMap' => 'Valor incorrecto para una dirección IP anterior: %%ip%%',
    'backup.conflict-ip.invalidMappingValue' => 'Valor incorrecto para una dirección IP nueva: %%ip%%',
    'backup.conflict-ip.ipNotFound' => 'La dirección IP %%ip%% no ha podido ser encontrada en la base de datos.',
    'backup.conflict-ip.uploadIpMappingFileLegend' => 'Cargar archivo de asignación de IPs',
    'backup.conflict-ip.ipMappingFileHint' => 'Un archivo de asignación de IPs es un archivo de texto sin formato. Cada una de las líneas de este archivo contiene una asignación de IP en el siguiente formato: <dirección IP anterior> <dirección IP nueva>',
    'backup.conflict-ip.oldIp' => 'Direcciones IP anteriores',
    'backup.conflict-ip.newIp' => 'Direcciones IP nuevas',

    'backup.copy-to-server.ignoreBackupSign' => 'Cargar archivos de backup sin una firma válida',
    'backup.copy-to-server.wrongPassword' => 'La contraseña especificada no es correcta. Durante la restauración del backup, Plesk le pedirá que vuelva a introducir la contraseña.',
    'backup.copy-to-server.corruptedSignatureUploaded' => 'El archivo de backup cargado %%fileName%% fue modificado, dañado o creado en otro servidor o en una versión anterior de Plesk que no soporta la firma de backups. Antes de restaurar los datos de este archivo de backup, compruebe que confía en el origen de este archivo.',
    'backup.copy-to-server.corruptedSignatureNotUploadedUser' => 'No se pudo cargar el archivo de backup %%fileName%%. El archivo contiene datos modificados o dañados o bien fue creado en otro servidor o en una versión anterior de Plesk. Para restaurar los datos de este archivo, póngase en contacto con su proveedor de hosting.',
    'backup.copy-to-server.corruptedSignatureNotUploadedAdmin' => 'No se pudo cargar el archivo de backup %%fileName%%. El archivo fue modificado, dañado o creado en otro servidor o en una versión anterior de Plesk que no soporta la firma de backups. Si confía en este backup, seleccione la opción "Cargar archivos de backup sin firmas válidas" y repita el proceso de carga.',
    'backup.copy-to-server.unableToMoveToLocalRepository' => "No se pudo mover el backup seleccionado %%fileName%% al almacenamiento del servidor. Error: %%error%%.",
    'backup.copy-to-server.missedPartsWarning' => "No se copiaron las siguientes partes del backup incremental:%%endl%%%%missedParts%%%%endl%%Copie las partes que faltan.",

    'backup.ftp-settings.isActive' => 'Usar almacenamiento FTP(S)',
    'backup.ftp-settings.host' => 'IP o nombre de host del servidor FTP',
    'backup.ftp-settings.directory' => 'Directorio donde guardar los archivos de backup',
    'backup.ftp-settings.directoryHint' => 'Por ejemplo, /myfolder/mybackups/',
    'backup.ftp-settings.ftpLogin' => 'Nombre de usuario FTP',
    'backup.ftp-settings.ftpPassword' => 'Contraseña FTP',
    'backup.ftp-settings.usePassiveMode' => 'Usar modo pasivo',
    'backup.ftp-settings.useFtps' => 'Usar FTPS',
    'backup.ftp-settings.errorHostIsLocal' => 'Se prohíbe el uso del servidor FTP del Plesk local como almacenamiento remoto. Especifique una ubicación remota.',
    'backup.ftp-settings.warningHostIsLocal' => 'El almacenamiento FTP(S) personal se configuró para almacenar backups en el servidor donde se encuentran los archivos de sus suscripciones. No se recomienda aplicar esta configuración debido al riesgo que supone de pérdida de datos y sobreuso del espacio en disco.',
    'backup.ftp-settings.enterFtpLogin' => 'Indique un nombre de usuario correcto.',
    'backup.ftp-settings.enterFtpPassword' => 'Indique una contraseña correcta.',

    'backup.remote-settings.isActive' => 'Usar el almacenamiento',
    'backup.remote-settings.initError' => 'No pudo inicializarse la página de configuración de %%extName%%: %%error%%',

    'backup.remote-storages.backupSecuritySettings' => 'Configuración de seguridad de backups',

    'backup.restore.detailsSection' => 'Detalles',
    'backup.restore.contentInfoSection' => 'Contenido del backup',
    'backup.restore.restorationOptionsSection' => 'Opciones de restauración',
    'backup.restore.emailNotification' => 'Una vez completada la restauración, enviar una notificación a',
    'backup.restore.comments' => 'Comentarios',
    'backup.restore.creationDate' => 'Fecha de creación',
    'backup.restore.systemNotes' => 'Notas del sistema',
    'backup.restore.ownerAdmin' => 'Creado por el administrador.',
    'backup.restore.ownerReseller' => 'Creado por un revendedor.',
    'backup.restore.ownerCustomer' => 'Creado por un cliente.',
    'backup.restore.ownerServiceUser' => 'Creado por otro usuario.',
    'backup.restore.partOfParentBackup' => 'Parte del backup %%type%%.',
    'backup.restore.server' => 'servidor',
    'backup.restore.reseller' => 'revendedor',
    'backup.restore.client' => 'cliente',
    'backup.restore.incremental' => 'Incremental.',
    'backup.restore.multiVolume' => 'Multivolumen.',
    'backup.restore.backupSize' => 'Tamaño del backup',
    'backup.restore.backupSizeFirstIncremental' => '%%this%% (esta adición) + %%base%% (backup inicial) = %%total%%',
    'backup.restore.backupSizeIncremental' => '%%this%% (esta adición) + %%prev%% (adiciones anteriores) + %%base%% (backup inicial) = %%total%%',
    'backup.restore.download' => 'Descargar',
    'backup.restore.downloadHint' => 'Descargue el archivo de backup a su ordenador local.',
    'backup.restore.downloadDisabled' => 'En este momento no es posible descargar archivos de backup. Inténtelo de nuevo transcurridos unos minutos o póngase en contacto con su proveedor de servicios.',
    'backup.restore.copy' => 'Copiar al almacenamiento del servidor',
    'backup.restore.copyHint' => 'Copie los archivos de backup seleccionados al almacenamiento del servidor.',
    'backup.restore.contentInfo' => 'El backup contiene',
    'backup.restore.restoreButton' => 'Restaurar',
    'backup.restore.mail' => 'Correo',
    'backup.restore.domainConfiguration' => 'Configuración de dominio',
    'backup.restore.virtualHost' => 'Contenido del host virtual',
    'backup.restore.database' => 'Bases de datos',
    'backup.restore.serverConfiguration' => 'Configuración del servidor',
    'backup.restore.serverConfigurationLicense' => 'Llave de licencia',
    'backup.restore.serverPersonalConfiguration' => 'Configuración de la cuenta de administrador',
    'backup.restore.serverPersonalDomains' => 'Dominios del administrador',
    'backup.restore.serverPersonalClients' => 'Clientes del administrador',
    'backup.restore.resellers' => 'Revendedores',
    'backup.restore.resellerPersonalConfiguration' => 'Configuración de cuenta de revendedor',
    'backup.restore.resellerPersonalDomains' => 'Dominios del revendedor',
    'backup.restore.resellerPersonalClients' => 'Clientes del revendedor',
    'backup.restore.clientPersonalConfiguration' => 'Configuración de cuenta de cliente',
    'backup.restore.clientPersonalDomains' => 'Dominios del cliente',
    'backup.restore.restoreModifiedSection' => 'Restaurar el archivo de backup aunque presente una firma dañada',
    'backup.restore.restoreModifiedDump' => 'Restaurar este backup aunque no presente una firma válida',
    'backup.restore.resolutionPolicy' => 'Directiva de resolución',
    'backup.restore.resolutionPolicyDescription' => 'Los conflictos de sincronización se producen cuando el objeto restaurado ya existe en el sistema con una fecha de modificación más reciente o cuando el objeto restaurado no está presente en el sistema en este momento.',
    'backup.restore.backupRestoreFtpWrongPassword' => 'La contraseña especificada no es correcta. El archivo de backup se copiará al almacenamiento local del servidor.',
    'backup.restore.backupRestoreLocalWrongPassword' => 'No se puede restaurar el backup. La contraseña especificada no es correcta.',
    'backup.restore.serverContentAndConfiguration' => 'Contenido y configuración del servidor',
    'backup.restore.serverConfigurationOnly' => 'Configuración del servidor',
    'backup.restore.resellerContentAndConfiguration' => 'Configuración y contenido de la cuenta de revendedor',
    'backup.restore.resellerConfigurationOnly' => 'Configuración de cuenta de revendedor',
    'backup.restore.clientContentAndConfiguration' => 'Contenido y configuración de la cuenta de cliente',
    'backup.restore.clientConfigurationOnly' => 'Configuración de cuenta de cliente',
    'backup.restore.domainContentAndConfiguration' => 'Contenido y configuración del dominio',
    'backup.restore.domainConfigurationOnly' => 'Configuración de dominio',
    'backup.restore.restoreType' => '¿Qué desea restaurar?',
    'backup.restore.restoreTypeFull' => 'Todos los objetos (todo el sistema)',
    'backup.restore.restoreTypeGranular' => 'Objetos seleccionados',
    'backup.restore.restoreObjectType' => 'Tipo de objeto a restaurar',
    'backup.restore.restoreObjectTypeSubscriptions' => 'Suscripción',
    'backup.restore.restoreObjectTypeCustomers' => 'Cliente',
    'backup.restore.restoreObjectTypeResellers' => 'Revendedor',
    'backup.restore.restoreObjectTypeMailUsers' => 'Cuenta de correo',
    'backup.restore.restoreObjectTypeDatabases' => 'Base de datos',
    'backup.restore.restoreObjectTypeCertificates' => 'Certificados SSL/TLS',
    'backup.restore.restoreObjectTypeSites' => 'Sitios',
    'backup.restore.restoreObjectTypeDnsZones' => 'Zona DNS',
    'backup.restore.restoreObjectTypeMailLists' => 'Listas de correo',
    'backup.restore.restoreObjectTypeWebContent' => 'Archivos de los dominios',
    'backup.restore.restoreObjects' => '%%objectType%%',
    'backup.restore.restoreObjectsWebContent' => 'Archivos seleccionados',
    'backup.restore.restoreSubscriptionLookup' => 'Suscripción',
    'backup.restore.restoreComponents' => 'Componentes a restaurar',
    'backup.restore.errorLog' => 'Registro de errores',
    'backup.restore.backupDetailsLogDoesntExist' => 'El registro de backup no está disponible.',
    'backup.restore.dumpFailedSection' => 'Registro de errores',
    'backup.restore.dumpFailed' => 'No se pudieron restaurar los datos porque el archivo de backup no es válido.',
    'backup.restore.granularNotSupported' => 'Solo pueden seleccionarse los objetos a restaurar cuando está efectuando una restauración a través de backups creados en Plesk 12.0 o versiones posteriores.',
    'backup.restore.fullNotSupportedInResellerPowerUser' => 'En el modo de visualización Power User de revendedor no se soporta la restauración de todos los datos mediante backups. Seleccione los objetos a restaurar. Puede cambiar el modo en el que visualiza el interfaz en %%interfaceLink%%',
    'backup.restore.interfaceLink' => 'Preferencias del interfaz',
    'backup.restore.contentRestoreType' => 'Restaurar',
    'backup.restore.contentRestoreTypeSettingsOnly' => 'Solo la configuración de los objetos seleccionados',
    'backup.restore.contentRestoreTypeFull' => 'Configuración y contenidos de los objetos seleccionados',
    'backup.restore.errorWrongFormat' => 'No se puede restaurar el backup: el archivo tiene el formato incorrecto.',
    'backup.restore.errorContentError' => 'Es posible que no se restauren todos los datos: el backup presenta errores de contenido.',
    'backup.restore.warningSignError' => 'No se pudo validar la firma del backup. Puede que el archivo de backup haya sido modificado, haya resultado dañado o bien fuera creado en otro servidor o en una versión anterior de Plesk.',
    'backup.restore.warningSignErrorNotAdmin' => 'Este backup solo puede ser restaurado por el administrador de Plesk.',
    'backup.restore.warningPartial' => "No se pudieron encontrar las siguientes partes del backup incremental:%%endl%%%%missedParts%%%%endl%%Puede que no sea posible restaurar todos los archivos. Cargue las partes no encontradas y vuelva a intentar la restauración.",
    'backup.restore.warningDeprecatedBackupVersion' => 'El backup que está intentando restaurar se creó en una versión no soportada de Plesk y no puede restaurarse. Use la extensión Plesk Migrator para transferir sus datos de versiones anteriores de Plesk.',
    'backup.restore.encryptionKeyError' => 'No es posible restaurar las contraseñas de una o más cuentas en este backup y estas serán restablecidas. Probablemente, este backup se creó en otro servidor Plesk y se cifró con su clave de cifrado.',
    'backup.restore.errorCorruptedContent' => 'No fue posible encontrar los archivos detallados a continuación o estos están dañados: ',
    'backup.restore.statusSection' => 'Estado del backup',
    'backup.restore.statusDetails' => 'Detalles de estado',
    'backup.restore.restoreBlocked' => 'El backup no puede restaurarse.',
    'backup.restore.restoreBlockedDescription' => 'En este momento no puede restaurarse un backup de tipo %%backupType%%. Para restaurarlo, inicie sesión como el propietario del backup y haga clic en el nombre de este backup en el Administrador de backups.',

    'backup.schedule.scheduleSection' => 'Programación',
    'backup.schedule.backupEnable' => 'Activar esta tarea de backup',
    'backup.schedule.backupPeriod' => 'Ejecutar esta tarea de backup',
    'backup.schedule.on' => 'el',
    'backup.schedule.at' => 'a las',
    'backup.schedule.useIncremental' => 'Usar backup incremental',
    'backup.schedule.fullBackupPeriod' => 'Realizar backup completo',
    'backup.schedule.daily' => 'Diariamente',
    'backup.schedule.weekly' => 'Semanalmente',
    'backup.schedule.monthly' => 'Mensualmente',
    'backup.schedule.yearly' => 'Anualmente',
    'backup.schedule.days' => 'días',
    'backup.schedule.weeks' => 'semanas',
    'backup.schedule.months' => 'meses',
    'backup.schedule.years' => 'años',
    'backup.schedule.backupTimeDescription' => 'Zona horaria: %%timezone%%.',
    'backup.schedule.systemTimeZone' => 'Zona horaria del sistema predeterminada',
    'backup.schedule.first' => 'primero',
    'backup.schedule.last' => 'último',
    'backup.schedule.dayOfMonth' => 'día',
    'backup.schedule.email' => 'De producirse algún error durante la ejecución de esta tarea de backup, enviar una notificación por email a',
    'backup.schedule.invalidFields' => 'Algunos campos están vacíos o contienen un valor que no es válido: %%fields%%.',
    'backup.schedule.maxDumpFiles' => 'Número máximo de archivos de backup completo a almacenar (incluyendo tanto los backups programados como los manuales)',
    'backup.schedule.maxDumpFilesUnlimitedDescription' => 'Deje este campo vacío si no desea eliminar los backups completos de forma automática.',
    'backup.schedule.maxDumpFilesLimitedDescription' => 'El límite especificado por el proveedor de hosting para el almacenamiento de servidor es %%max%%. Su límite debe ser igual o inferior a %%max%%.',
    'backup.schedule.backupToCloudIsNotAllowed' => 'El almacenamiento de backups programados de la suscripción en un almacenamiento cloud remoto es una prestación premium que puede contratarse en la tienda online de Plesk.',

    'backup.secure-backup.hint' => 'Puede usar una contraseña para cifrar las contraseñas de los usuarios presentes en la base de datos de Plesk en un backup. Tenga en cuenta que la restauración de un backup protegido con contraseña sin proporcionar la contraseña ocasionará la generación aleatoria de contraseñas de usuarios por parte de Plesk.',
    'backup.secure-backup.hintAdmin' => 'Puede cifrar las contraseñas de la base de datos de Plesk presentes en backups con la clave de cifrado de Plesk o con una contraseña. La clave es única para cada una de las instalaciones de Plesk. Los backups cifrados con la clave solo pueden restaurarse en la instalación de Plesk donde se crearon, no pudiéndose restaurar en otra instalación de Plesk. Tenga en cuenta que Plesk no protege todos los datos confidenciales en un backup. Le recomendamos guardar los backups en un almacenamiento cloud remoto y activar el cifrado de backups a nivel del almacenamiento cloud.',
    'backup.secure-backup.usePasswordProtection' => 'Usar protección con contraseña (recomendado)',
    'backup.secure-backup.backupPasswordSource' => 'Tipo de contraseña',
    'backup.secure-backup.pleskKey' => 'Clave de cifrado de Plesk',
    'backup.secure-backup.userPassword' => 'Contraseña especificada',
    'backup.secure-backup.password' => 'Contraseña',
    'backup.secure-backup.passwordConfirmation' => 'Confirme la contraseña',

    'backup.subform.settingsSection' => 'Configuración de backup',
    'backup.subform.prefix' => 'Añadir un prefijo al nombre del backup',
    'backup.subform.comment' => 'Comentarios',
    'backup.subform.splitSize' => 'Crear una backup multivolumen, tamaño del volumen (en MB)',
    'backup.subform.repository' => 'Guardar en',
    'backup.subform.repositoryDescription' => 'No ha especificado la configuración del almacenamiento FTP(S). %%configure%%',
    'backup.subform.localAndSpecialRepositoryBackup' => 'Tanto el almacenamiento de servidor como %%name%%',
    'backup.subform.remoteRepository' => 'almacenamiento remoto',
    'backup.subform.remoteRepositoryText' => 'Seleccione el almacenamiento remoto en la nube',
    'backup.subform.configureRemoteRepositories' => 'Puede <a href="%%url%%">configurar almacenamientos remotos</a> para conservar sus backups en la nube',
    'backup.subform.configureFtpRepository' => 'Puede <a href="%%url%%">configurar un almacenamiento FTP</a> para así almacenar sus backups',
    'backup.subform.repositoryConfigure' => 'Configurar',
    'backup.subform.email' => 'Cuando se complete una tarea de backup, enviar un email a',
    'backup.subform.contentSection' => 'Contenido del backup',
    'backup.subform.domainConfiguration' => 'Configuración',
    'backup.subform.domainConfigurationVhost' => 'Archivos de usuario y bases de datos',
    'backup.subform.domainConfigurationMail' => 'Mensajes de correo',
    'backup.subform.content' => 'Copiar',
    'backup.subform.backupAll' => 'Todo el contenido y la configuración',
    'backup.subform.backupConfiguration' => 'Solo configuración',
    'backup.subform.backupVhost' => 'Toda la configuración y contenido excepto los mensajes de correo',
    'backup.subform.backupMail' => 'Solo configuración y mensajes de correo',
    'backup.subform.mssqlNativeBackup' => 'De ser posible, usar la funcionalidad de backups nativa de MS SQL',
    'backup.subform.mssqlNativeBackupAdmin' => 'Utilizar la funcionalidad de backups nativa de MS SQL. En el caso de bases de datos remotas, compruebe que ha configurado debidamente la configuración de backup del servidor MS SQL remoto en Herramientas y configuración>Servidores de bases de datos.',
    'backup.subform.localRepository' => 'Almacenamiento del servidor',
    'backup.subform.localRepositoryPath' => 'Almacenamiento del servidor en %%path%%',
    'backup.subform.backupNodeRepository' => '',
    'backup.subform.ftpRepository' => 'Almacenamiento FTP(S) en %%uri%% <a href="%%link%%">Cambiar configuración</a>',
    'backup.subform.ftpRepositoryText' => 'Almacenamiento FTP(S) en %%uri%%',
    'backup.subform.type' => 'Tipo',
    'backup.subform.typeFullBackup' => 'Completo',
    'backup.subform.typeIncremental' => 'Incremental',
    'backup.subform.typeIncrementalDescription' => 'Crear un backup de los datos de hosting de correo y web que experimentaron cambios desde el último backup (las bases de datos siempre se copian en su totalidad).',
    'backup.subform.incrementalNotAvailable' => 'Si desea crear backups incrementales, primero deberá crear un backup completo.',
    'backup.subform.excludeLogs' => 'Excluir archivos de registro',
    'backup.subform.excludeFiles' => 'Excluir determinados archivos del backup',
    'backup.subform.excludeFilesDescription' => 'Sólo puede excluir archivos presentes en espacios web. Especifique la ruta o rutas relativas a la raíz del espacio web, separando los archivos individuales con comas. Asimismo, también se permite el uso del símbolo de máscara (por ejemplo /somedir/log*).',

    'backup.upload.uploadHint' => 'Aquí puede cargar archivos de backup al repositorio de Plesk. El tamaño máximo del archivo es de dos gigabytes.',
    'backup.upload.backupFile' => 'Archivo de backup',
    'backup.upload.removeLink' => 'Eliminar',
    'backup.upload.addFileLink' => 'Cargar más archivos',
    'backup.upload.backupSecuritySettings' => 'Configuración de seguridad de backups',
    'backup.upload.signatureHint' => 'Plesk comprueba que los archivos de backup presentan una firma y una estructura válida. Los archivos modificados, dañados o creados en otro servidor son descartados. La opción que se muestra a continuación le permite restaurar datos de este tipo de archivos. Seleccione esta opción únicamente si confía en el origen del backup, puesto que la carga de este tipo de archivos puede comprometer su seguridad o interrumpir la operatividad del servidor. Nota: los archivos de backup creados en versiones de Plesk anteriores a la versión 11.5 son descartados porque no presentan firmas. Restaure este tipo de archivos si confía en su origen.',
    'backup.upload.ignoreSign' => 'Cargar archivos de backup sin una firma válida',
    'backup.upload.passwordHint' => 'Si utilizó protección con contraseña para este backup, introduzca la contraseña en los campos que aparecen a continuación. Tenga en cuenta que si proporciona una contraseña incorrecta, Plesk le mostrará una advertencia pero cargará el backup al servidor de todas formas. Durante la restauración del backup, se le pedirá que vuelva a introducir la contraseña.',
    'backup.upload.alreadyExistsWarning' => 'En el almacenamiento local del servidor ya existe un archivo de backup denominado %%fileName%%.',
    'backup.upload.incorrectPasswordWarning' => 'La contraseña especificada no es correcta. Durante la restauración del backup, Plesk le pedirá que vuelva a introducir la contraseña.',
    'backup.upload.deprecatedDumpError' => 'El backup que está intentando cargar se creó en una versión no soportada de Plesk y no puede importarse. Use la extensión Plesk Migrator para transferir sus datos de versiones anteriores de Plesk.',
    'backup.upload.mailFormatWarning' => 'El archivo de backup %%fileName%% ha sido cargado al almacenamiento. ¡Importante! El archivo de backup %%fileName%% incluye contenido de correo que no será restaurado porque no se soporta su formato (Plesk 8.3 - 8.6). Para poder restaurar este contenido de correo, cópielo usando la herramienta de backup de Plesk, seleccione la opción Copiar contenido de los buzones y seleccione la opción con volcado restaurado en cualquier servidor de correo.',
    'backup.upload.corruptedSignatureAdminWarning' => 'El archivo de backup cargado (%%fileName%%) fue modificado, dañado o creado en otro servidor o en una versión anterior de Plesk que no soporta la firma de backups. Antes de restaurar los datos de este archivo de backup, compruebe que confía en el origen de este archivo.',
    'backup.upload.corruptedSignatureAdminError' => 'No se pudo cargar el archivo de backup (%%fileName%%). El archivo fue modificado, dañado o creado en otro servidor o en una versión anterior de Plesk que no soporta la firma de backups. Si confía en este backup, seleccione la opción "Cargar archivos de backup sin firmas válidas" y repita el proceso de carga.',
    'backup.upload.corruptedSignatureUserWarning' => 'El archivo de backup cargado (%%fileName%%) contiene datos modificados o dañados o fue creado en otro servidor o en una versión anterior de Plesk.',
    'backup.upload.corruptedSignatureUserError' => 'No se pudo cargar el archivo de backup (%%fileName%%). El archivo contiene datos modificados o dañados o bien fue creado en otro servidor o en una versión anterior de Plesk. Para restaurar los datos de este archivo, póngase en contacto con su proveedor de hosting.',
    'backup.upload.uploadError' => 'No se pudo cargar %%fileName%% al almacenamiento del servidor: %%error%%',
    'backup.upload.fileNotSelected' => 'No se han seleccionado archivos para cargar. Seleccione al menos un archivo.',
    'backup.upload.missedPartsWarning' => "No se cargaron las siguientes partes del backup incremental:%%endl%%%%missedParts%%%%endl%%Cargue las partes que faltan.",
    'backup.upload.unknownType' => 'Tipo de objeto desconocido',
    'backup.upload.storageLink' => 'otro almacenamiento',
    'backup.upload.anotherStorage' => 'El volcado de datos se ha cargado en %%storageLink%%.',
    'backup.upload.resellerNotFound' => 'El revendedor %%name%% no se ha encontrado. Deberá crearlo primero para restaurar el volcado de datos cargado.',
    'backup.upload.clientNotFound' => 'El cliente %%name%% no se ha encontrado. Deberá crearlo primero para restaurar el volcado de datos cargado.',
    'backup.upload.domainNotFound' => 'El dominio %%name%% no se ha encontrado. Deberá crearlo primero para restaurar el volcado de datos cargado.',

    'backup.web-content-dynamic.addButtonTitle' => 'Añadir archivos',
    'backup.web-content-dynamic.noItems' => 'No ha seleccionado ningún archivo',
    'backup.web-content-dynamic.hint' => 'Use las casillas correspondientes para seleccionar archivos y carpetas.',
    'backup.web-content-dynamic.title' => 'Seleccionar archivos',
    'backup.web-content-dynamic.columnName' => 'Nombre',
    'backup.web-content-dynamic.columnChangeDate' => 'Modificación',
    'backup.web-content-dynamic.columnSize' => 'Tamaño',
    'backup.web-content-dynamic.columnPermissions' => 'Permisos',
    'backup.web-content-dynamic.columnUser' => 'Usuario',
    'backup.web-content-dynamic.columnGroup' => 'Grupo',
    'backup.web-content-dynamic.waitButtonTitle' => 'Espere',
    'backup.web-content-dynamic.loadingTitle' => 'Espere. Cargando...',

    'backup.invalidFields' => 'Algunos campos están vacíos o contienen un valor incorrecto.',
    'backup.notEnoughDiskSpace' => 'En %%path%% no existe suficiente espacio en disco para crear un backup. Al menos debe disponer de %%required%% GB (%%available%% GB disponibles)',

    'change-subscriptions-owner.infoTitle' => 'Información',
    'change-subscriptions-owner.infoDescription' => '%%total%% suscripciones, %%active%% suscripciones activas, %%diskSpace%% espacio en disco usado, %%traffic%% tráfico usado',
    'change-subscriptions-owner.possibleOwnersTitle' => 'Posibles propietarios nuevos de suscripciones',
    'change-subscriptions-owner.selectedSubscriptions' => 'Suscripciones seleccionadas',
    'change-subscriptions-owner.subscriptionName' => 'Nombre de la suscripción',
    'change-subscriptions-owner.ownerName' => 'Nombre del propietario',
    'change-subscriptions-owner.currentIpAddress' => 'Dirección IP actual',
    'change-subscriptions-owner.newIpAddress' => 'Dirección IP nueva',
    'change-subscriptions-owner.submit' => 'Volver a asignar',

    'cgroups-settings.cgroupsSettingsTab' => 'RAM, CPU, E/S disco',
    'cgroups-settings.cgroupsSettingsTabDescription' => 'Establezca límites de consumo de los recursos del sistema para una suscripción. Con el fin de garantizar que no se exceden los límites establecidos, Plesk utiliza una prestación del kernel de Linux denominada grupos de control (cgroups).',
    'cgroups-settings.cpuSettings' => 'CPU',
    'cgroups-settings.cpuSettingsDescription' => 'Limite suscripciones individuales a la cantidad especificada de uso de CPU.',
    'cgroups-settings.cpuPeriodLimit' => 'Periodo durante el cual se verifica el uso de la CPU',
    'cgroups-settings.percentUsageDescription' => 'La cantidad total de tiempo de CPU para su servidor es de %%total%%%%units%%',
    'cgroups-settings.ramSettings' => 'RAM',
    'cgroups-settings.ramSettingsDescription' => 'Limite suscripciones individuales a la cantidad especificada de uso de RAM. Tenga en cuenta que si una suscripción supera el límite indicado, se detendrá el proceso que consuma más RAM.',
    'cgroups-settings.ramPeriodLimit' => 'Periodo durante el cual se verifica el uso de la RAM',
    'cgroups-settings.diskSettings' => 'E/S disco',
    'cgroups-settings.diskReadSettings' => 'Lectura del disco',
    'cgroups-settings.diskReadSettingsDescription' => 'Permita a suscripciones individuales utilizar únicamente el ancho de banda de lectura de disco permitido por el límite especificado.',
    'cgroups-settings.diskReadPeriodLimit' => 'Periodo durante el cual se verifica el uso de la lectura del disco',
    'cgroups-settings.diskWriteSettings' => 'Escritura del disco',
    'cgroups-settings.diskWriteSettingsDescription' => 'Permita a suscripciones individuales utilizar únicamente el ancho de banda de escritura de disco permitido por el límite especificado.',
    'cgroups-settings.diskWritePeriodLimit' => 'Periodo durante el cual se verifica el uso de la escritura del disco',
    'cgroups-settings.limit' => 'Límite',
    'cgroups-settings.threshold' => 'Notificar al exceder',
    'cgroups-settings.limitNotificationEnabled' => 'Notificación activada',
    'cgroups-settings.periodFiveMinutes' => '5 minutos',
    'cgroups-settings.periodHour' => '1 hora',
    'cgroups-settings.periodDay' => '1 día (24 horas)',
    'cgroups-settings.mb' => 'MB',
    'cgroups-settings.mbs' => 'MB/seg',

    'custom-button.privateLabel' => 'Solo mostrármelo a mí',
    'custom-button.textLabel' => 'Etiqueta del botón',
    'custom-button.tooltipLabel' => 'Texto de información sobre herramientas',
    'custom-button.iconLabel' => 'Imagen de fondo',
    'custom-button.priorityLabel' => 'Prioridad',
    'custom-button.urlLabel' => 'URL',
    'custom-button.urlParamsLabel' => 'Añadir parámetros a URL',
    'custom-button.placeLabel' => 'Ubicación',
    'custom-button.internalLabel' => 'Abrir URL en Plesk',
    'custom-button.internalDescription' => 'Especifique si desea abrir la URL en una página de Plesk o en una nueva ventana del navegador.',
    'custom-button.noFrameLabel' => 'No utilizar marcos',
    'custom-button.noFrameDescription' => 'Si añade un botón personalizado que redirecciona a una extensión de Plesk o a una app en el panel del cliente, puede especificar la forma en la que debería mostrarse esta extensión o app − en un marco o como parte del GUI de Plesk.',
    'custom-button.urlParamLabel_dom_id' => 'Incluir ID de la suscripción, ID del dominio e ID del alias de dominio',
    'custom-button.urlParamLabel_dom_name' => 'Incluir nombre del dominio principal',
    'custom-button.urlParamLabel_ftp_user' => 'Incluir nombre de usuario FTP',
    'custom-button.urlParamLabel_ftp_pass' => 'Incluir contraseña FTP',
    'custom-button.urlParamLabel_cl_id' => 'Incluir ID de cliente',
    'custom-button.urlParamLabel_cname' => 'Incluir nombre de la empresa del cliente',
    'custom-button.urlParamLabel_pname' => 'Incluir nombre de contacto del cliente',
    'custom-button.urlParamLabel_email' => 'Incluir email del cliente',
    'custom-button.buttonPlace_navigation' => 'Acceso común',
    'custom-button.buttonPlace_admin' => 'Página principal del administrador',
    'custom-button.buttonPlace_admin-settings' => 'Página Herramientas y configuración del administrador',
    'custom-button.buttonPlace_reseller' => "Página principal del revendedor",
    'custom-button.buttonPlace_reseller-settings' => 'Página Herramientas y utilidades del revendedor',
    'custom-button.buttonPlace_client' => 'Página principal del cliente',
    'custom-button.buttonPlace_domain' => "Página Sitios web y dominios de la suscripción",
    'custom-button.buttonPlace_domain_powerUser' => "Página Sitios web y dominios del espacio web",
    'custom-button.buttonPlace_domain-properties' => 'Herramientas para sitios web',

    'database-server-change-password.adminPassword' => 'Contraseña del administrador',
    'database-server-change-password.success' => 'La contraseña del administrador se ha actualizado correctamente.',

    'database-server-create.general' => 'General',
    'database-server-create.type' => 'Tipo de servidor de bases de datos',
    'database-server-create.unixSocket' => '(conexión local)',
    'database-server-create.host' => 'Dirección IP o nombre de host',
    'database-server-create.port' => 'Nº puerto',
    'database-server-create.portDescription' => 'Déjelo en blanco para usar el número de puerto predeterminado',
    'database-server-create.version' => 'Versión del servidor de bases de datos',
    'database-server-create.default' => 'Utilizar este servidor como predeterminado para %%type%%',
    'database-server-create.externalConnections' => 'Permitir al servidor MySQL local aceptar conexiones externas',
    'database-server-create.externalConnectionsDescription' => 'De modificar este parámetro, se reiniciará el servidor MySQL local. Si desea activar el acceso remoto a otros servidores MySQL registrados en Plesk, modifique su configuración de forma manual.',
    'database-server-create.authentication' => 'Autenticación',
    'database-server-create.authenticationAddDescription' => 'Especifique las credenciales del administrador de la base de datos que Plesk usará para acceder al servidor de bases de datos. En el servidor de bases de datos ya debe existir una cuenta de administrador con estas credenciales.',
    'database-server-create.authenticationEditDescription' => 'Aquí puede cambiar las credenciales que Plesk utiliza para acceder al servidor de bases de datos. Estas credenciales deben coincidir con las credenciales del administrador de la base de datos. Por ejemplo, una vez haya cambiado las credenciales del administrador en el servidor de bases de datos, también deberá cambiarlas en Plesk.',
    'database-server-create.authenticationChangeDescription' => 'Aquí puede cambiar las credenciales que Plesk utiliza para acceder al servidor de bases de datos. Si modifica el nombre de usuario y la contraseña aquí abajo, se actualizará la cuenta del usuario de la base de datos con permisos administrativos tanto en el servidor de bases de datos como en Plesk.',
    'database-server-create.adminLogin' => 'Nombre de usuario',
    'database-server-create.adminPassword' => 'Contraseña',
    'database-server-create.createSuccess' => 'El servidor de base de datos se ha creado correctamente.',
    'database-server-create.createError' => 'El servidor de base de datos se creó con un error: %%error%%',
    'database-server-create.updateSuccess' => 'El servidor de base de datos se ha actualizado correctamente.',
    'database-server-create.updateError' => 'El servidor de base de datos se actualizó con un error: %%error%%.',
    'database-server-create.backupSettings' => 'Backup',
    'database-server-create.backupTempDir' => 'Directorio temporal',
    'database-server-create.backupTempDirDescription' => 'La ruta a una carpeta física presente en el servidor remoto donde se encuentra el servidor MS SQL. Este servidor debe poder acceder a esta carpeta para leer y escribir en archivos temporales de backup. Por ejemplo: C:\\DirectoryPath',
    'database-server-create.backupNetworkTempDir' => 'Directorio de red temporal',
    'database-server-create.backupNetworkTempDirDescription' => 'La ruta al recurso compartido de red asignado a la carpeta físico indicada arriba. Plesk accederá a la carpeta compartida para descargar y cargar archivos de backup. Por ejemplo, \\\\ServerName\\DirectoryPath',
    'database-server-create.backupNetworkUser' => 'Nombre de usuario',
    'database-server-create.backupNetworkUserDescription' => 'El nombre de usuario de un usuario de red creado en el servidor remoto, como por ejemplo, ServerName\\UserName. El usuario debe poder acceder a la carpeta compartida especificada arriba.',
    'database-server-create.backupNetworkPassword' => 'Contraseña',

    'domain.connection-info.title' => 'Información de la conexión',
    'domain.connection-info.systemUserCredentials' => 'Credenciales del usuario del sistema',
    'domain.connection-info.systemUserCredentialsHint' => 'El acceso mediante FTP siempre está activado, acceso mediante SSH o Escritorio Remoto — solo si %%details%%.',
    'domain.connection-info.systemUserCredentialsHintDetails' => 'se ha concedido el permiso',
    'domain.connection-info.systemUserRemoveAccessEnabled' => 'Su acceso mediante SSH o Escritorio Remoto está activado y no puede gestionar su estado.',
    'domain.connection-info.systemUserRemoveAccessDisabled' => 'Su acceso mediante SSH o Escritorio Remoto está desactivado y no puede gestionar su estado.',
    'domain.connection-info.ipAddress' => 'Dirección IP',
    'domain.connection-info.copyToClipboard' => 'Copiar al portapapeles',
    'domain.connection-info.username' => 'Nombre de usuario',
    'domain.connection-info.password' => 'Contraseña',
    'domain.connection-info.changeSystemUserPasswordTitle' => 'Cambio de contraseña de usuario de sistema',
    'domain.connection-info.changePasswordTooltip' => 'Cambiar la contraseña',
    'domain.connection-info.newPassword' => 'Contraseña nueva',
    'domain.connection-info.manageAccess' => 'Administrar acceso',
    'domain.connection-info.additionalFtpAccounts' => 'Cuentas FTP adicionales',
    'domain.connection-info.database' => 'Base de datos',
    'domain.connection-info.databaseHint' => '1 de %%number%% bases de datos pertenecientes a la suscripción.',
    'domain.connection-info.databaseNotCreatedHint' => 'Base de datos no creada.',
    'domain.connection-info.databaseType.mysql' => 'MySQL',
    'domain.connection-info.databaseType.mssql' => 'Servidor MS SQL',
    'domain.connection-info.databaseType.postgresql' => 'PostgreSQL',
    'domain.connection-info.databaseType.mariadb' => 'MariaDB',
    'domain.connection-info.databaseType.percona' => 'Percona',
    'domain.connection-info.databaseHost' => 'Host',
    'domain.connection-info.databaseHostValue' => '%%value%% (%%fork%%)',
    'domain.connection-info.databaseName' => 'Nombre de la base de datos',
    'domain.connection-info.addDatabase' => 'Añadir base de datos',
    'domain.connection-info.manageDatabases' => 'Administre bases de datos',
    'domain.connection-info.phpMyAdmin' => 'phpMyAdmin',
    'domain.connection-info.myLittleAdmin' => 'myLittleAdmin',
    'domain.connection-info.changeDatabaseUserPasswordTitle' => 'Cambio de contraseña del usuario de la base de datos',
    'domain.connection-info.changeDatabaseUserPasswordNotice' => 'No olvide actualizar la contraseña en los archivos de configuración de su aplicación una vez la haya cambiado aquí.',
    'domain.connection-info.buttonSave' => 'Guardar',
    'domain.connection-info.buttonSaving' => 'Guardando...',
    'domain.connection-info.buttonCancel' => 'Cancelar',

    'domain.move.title' => 'Mover el dominio %%name%%',
    'domain.move.hint' => 'El dominio se moverá a una nueva suscripción junto con su contenido, archivos de configuración, archivos de registro y aplicaciones APS.',
    'domain.move.hintMain' => 'El dominio se transferirá a la suscripción nueva junto con su contenido, archivos de configuración y de registro, bases de datos, usuarios de bases de datos, usuarios FTP adicionales, tareas programadas, usuarios smb y aplicaciones APS.',
    'domain.move.hintSubdomains' => 'Se moverán los subdominios %%subdomains%% junto con el dominio principal.',
    'domain.move.hintAliases' => 'Se moverán los alias de dominio %%aliases%% junto con el dominio principal.',
    'domain.move.hintSubdomainsAndAliases' => 'Se moverán los subdominios %%subdomains%% y los alias de dominio %%aliases%% junto con el dominio principal.',
    'domain.move.labelDatabases' => 'Una vez movido el dominio, abra la pestaña "Bases de datos" para transferir las bases de datos asociadas.',
    'domain.move.hintDatabases' => 'Si es necesario, mueva las bases de datos por separado.',

    'domain.move.Form.submitButton' => 'Mover',
    'domain.move.Form.cancelButton' => 'Cancelar',

    'domain.move.selectTarget' => 'Suscripciones disponibles',
    'domain.move.nothingFound' => 'No se encontró nada',
    'domain.move.targetIsRequred' => 'Seleccione la suscripción a la que desea mover el dominio.',
    'domain.move.selectNewSubscription' => 'Crear una nueva suscripción',
    'domain.move.ipv4Address' => 'Dirección IPv4',
    'domain.move.ipv4AddressHint' => 'La dirección IP donde se aloja el sitio web es una dirección de red del host virtual del sitio web.',
    'domain.move.ipv6Address' => 'Dirección IPv6',
    'domain.move.ipv6AddressHint' => 'La dirección IP donde se aloja el sitio web es una dirección de red del host virtual del sitio web.',
    'domain.move.ipAddressIsNotSelected' => 'Seleccione al menos una dirección IP.',
    'domain.move.username' => 'Nombre de usuario',
    'domain.move.usernameHint' => 'La cuenta del usuario de sistema asociada con el espacio web. Se usa para acceder a los archivos alojados mediante FTP y SSH.',
    'domain.move.usernameIsRequred' => 'Indique un nombre de usuario.',
    'domain.move.password' => 'Contraseña',
    'domain.move.passwordIsRequred' => 'Indique una contraseña.',
    'domain.move.noAvailableSubscriptions' => 'Ninguna suscripción disponible',
    'domain.move.noWebHosting' => 'Ahora no se creará ningún usuario del sistema, puesto que el dominio no dispone de hosting web.',

    'domain.rename.title' => 'Cambiar nombre de dominio',
    'domain.rename.titleAlias' => 'Cambiar nombre del alias de dominio',
    'domain.rename.hint' => 'Ahora está cambiando el nombre de dominio %%domainName%%',
    'domain.rename.hintAlias' => 'Ahora está cambiando el nombre del alias de dominio %%domainName%%',
    'domain.rename.name' => 'Nombre de dominio nuevo',
    'domain.rename.nameAlias' => 'Nombre de alias de dominio nuevo',
    'domain.rename.domainNameIsRequired' => 'Este campo obligatorio está vacío. Indique un valor para este campo.',
    'domain.rename.submitButton' => 'Cambiar',
    'domain.rename.submitButtonProgress' => 'Cambiando',
    'domain.rename.successMessage' => 'El nombre de dominio %%oldName%% se ha cambiado a %%newName%%.',
    'domain.rename.successMessageAlias' => 'El nombre del alias de dominio %%oldName%% se ha cambiado a %%newName%%.',

    'domain.rename.Form.cancelButton' => 'Cancelar',

    'domain.outgoing-messages.hint' => 'Aquí puede cambiar el límite de correos salientes para este dominio. No se podrán enviar más mensajes de los especificados en dicho límite.',
    'domain.outgoing-messages.domainOutgoingMessagesSubscriptionDefault' => 'Predeterminado (%%domainOutgoingMessages%% mensajes por hora)',
    'domain.outgoing-messages.domainOutgoingMessagesSpecificHint' => 'mensajes por hora',
    'domain.outgoing-messages.domainOutgoingMessages' => 'Límite de correos salientes',
    'domain.outgoing-messages.domainOutgoingMessagesCustomLimit' => 'Valor personalizado para este dominio',

    'domain.tech-domain-name.title' => 'Seleccionar su nombre de dominio',
    'domain.tech-domain-name.techDomainTitle' => 'Nombre de dominio temporal',
    'domain.tech-domain-name.customDomainTitle' => 'Nombre de dominio registrado',
    'domain.tech-domain-name.techDomainText' => 'Todavía no he registrado ningún nombre de dominio',
    'domain.tech-domain-name.customDomainText' => 'Ya he registrado un nombre de dominio',
    'domain.tech-domain-name.techDomain' => 'Su nombre de dominio temporal',
    'domain.tech-domain-name.customDomain' => 'Nombre de dominio registrado',
    'domain.tech-domain-name.domainName' => 'Nombre de dominio',
    'domain.tech-domain-name.techDomainDesc' => 'Los nombres de dominio temporales se usan para acceder a su sitio antes de que registre y compre un nombre de dominio apropiado. Estos se proporcionan de forma gratuita con las siguientes condiciones:',
    'domain.tech-domain-name.techDomainRandom' => 'Los nombres se generan aleatoriamente',
    'domain.tech-domain-name.techDomainDns' => 'Estos se alojan en la zona en la zona DNS .plesk.page',
    'domain.tech-domain-name.techDomainSwitch' => 'Puede pasar a un nombre de dominio registrado en cualquier momento más adelante cambiando el nombre de su dominio en la configuración del dominio.',
    'domain.tech-domain-name.error' => 'Se ha producido un error inesperado.',
    'domain.tech-domain-name.errorNoIpAddress' => 'Seleccione la dirección IP.',
    'domain.tech-domain-name.generating' => 'Generando...',

    'get-password.label' => 'Restablecer la contraseña',
    'get-password.text' => 'Introduzca su dirección de email o el nombre de usuario registrado en Plesk y le enviaremos un email para el restablecimiento de la contraseña.',
    'get-password.emailLabel' => 'Dirección de email',
    'get-password.loginLabel' => 'Nombre de usuario',
    'get-password.send' => 'Enviar',
    'get-password.cancel' => 'Cancelar',
    'get-password.errorInvalidEmail' => 'No se reconoce la dirección de email. Compruébelo e inténtelo de nuevo.',
    'get-password.messageSend' => "El email de restablecimiento de la contraseña se ha enviado a la dirección de email asociada.\nSi no lo recibe, póngase en contacto con su administrador de Plesk.",

    'iis-settings.formGeneralHint' => 'Aquí puede configurar los ajustes del servidor web IIS para su sitio web cambiando los valores predeterminados. La configuración personalizada de IIS es útil, por ejemplo, cuando desea utilizar un nuevo tipo de archivos de índice en su sitio web o para asociar un determinado tipo MIME a ciertas extensiones de nombre de archivo. Los valores por omisión están determinados por su proveedor de hosting.',
    'iis-settings.formGeneralHint_powerUser' => 'Aquí puede configurar los ajustes del servidor web IIS para este sitio web. La configuración personalizada de IIS es útil, por ejemplo, cuando desea utilizar un nuevo tipo de archivos de índice en su sitio web o para asociar un determinado tipo MIME a ciertas extensiones de nombre de archivo. Los valores predeterminados indican que IIS utilizará las directivas correspondientes de su configuración por omisión.',
    'iis-settings.virtualDirectoryLoadError' => 'No se han podido obtener las propiedades del directorio virtual especificado: %%errorMessage%%',
    'iis-settings.general' => 'Configuración común',
    'iis-settings.example' => "Por ejemplo:\n%%example%%",
    'iis-settings.settingOn' => 'Activado',
    'iis-settings.settingOff' => 'Desactivado (predeterminado)',
    'iis-settings.settingDefault' => 'Predeterminado',
    'iis-settings.settingCustom' => 'Introduzca un valor personalizado',
    'iis-settings.mimeTypes' => 'Tipos MIME',
    'iis-settings.mimeTypesExample' => "text/plain .mytxt\nimage/jpeg .myjpeg",
    'iis-settings.mimeTypesFullDescription' => 'Los tipos MIME asocian extensiones de archivo con tipos de archivo. Generalmente esto se usa para crear una extensión de archivo personalizada para tipos de archivo comunes.',
    'iis-settings.documents' => 'Documentos predeterminados',
    'iis-settings.documentsOff' => 'Desactivado',
    'iis-settings.documentsCustom' => 'Indique los valores',
    'iis-settings.documentsExample' => "Index.html\nIndex.htm\nIndex.cfm",
    'iis-settings.documentsExampleFullDescription' => 'Cuando los navegadores no proporcionen el nombre de un documento de su sitio, IIS buscará los documentos predeterminados especificados y servirá el que encuentre primero. Si no indica los documentos predeterminados pero activa la exploración de directorios, en los navegadores se mostrará la lista de directorios en vez de la página de índice.',
    'iis-settings.expires' => 'Expira',
    'iis-settings.expiresFullDescription' => 'El servidor web añadirá los encabezados de respuesta "Expira" a las páginas web. La marca de hora de expiración se obtiene añadiendo la cantidad de tiempo indicada arriba a la hora en la que se solicitó una página web.',
    'iis-settings.expiresUnitDays' => 'días',
    'iis-settings.expiresUnitHours' => 'horas',
    'iis-settings.expiresUnitMinutes' => 'minutos',
    'iis-settings.expiresUnitSeconds' => 'segundos',
    'iis-settings.headers' => 'Encabezados adicionales',
    'iis-settings.headersExample' => "Cache-Control: public\nStrict-Transport-Security: max-age=63072000; includeSubdomains;\nX-Frame-Options: DENY",
    'iis-settings.headersFullDescription' => 'El servidor web añadirá los encabezados de respuesta HTTP especificados.',
    'iis-settings.directoryBrowsing' => 'Examen de directorios',
    'iis-settings.directoryBrowsingDescription' => 'Permite a los usuarios ver la lista de directorios en los navegadores web, por ejemplo, cuando la página de índice predeterminada no esté disponible.',
    'iis-settings.securityTabDirectory' => 'Configuración de seguridad del directorio',
    'iis-settings.allowAnonymous' => 'Autenticación anónima',
    'iis-settings.allowAnonymousDescription' => 'La autenticación anónima permite a los usuarios acceder al contenido público de su sitio. Los usuarios anónimos no dispondrán de acceso al contenido de su sitio protegido con contraseña ni a cualquier otro contenido protegido a nivel de sistema de archivos.',
    'iis-settings.allowWindows' => 'Autenticación de Windows',
    'iis-settings.allowWindowsDescription' => 'La autenticación de Windows (anteriormente denominada NTLM) protege el contenido de su sitio a nivel del sistema de archivos.',
    'iis-settings.requireSsl' => 'Requerir SSL/TLS',
    'iis-settings.requireSslDescription' => 'Al habilitar el soporte SSL/TLS para su sitio, obligará a los clientes web (exploradores) a utilizar únicamente conexiones HTTPS seguras.',
    'iis-settings.securityTabIpDeny' => 'Configuración de restricción de acceso',
    'iis-settings.deny' => 'Denegar acceso al sitio',
    'iis-settings.denyOff' => 'Predeterminado',
    'iis-settings.denyCustom' => 'Indique un valor personalizado',
    'iis-settings.allow' => 'A excepción de',
    'iis-settings.denyExample' => "10.1.0.0/16\n192.168.1.110\n\nLos hosts y las redes especificados no disponen de permiso de acceso al sitio.Utilice '*' para denegar todas las conexiones.",
    'iis-settings.allowExample' => "192.168.0.0/16\n10.1.1.21\n\nLos hosts y las redes especificados disponen de permiso de acceso al sitio.",
    'iis-settings.dynamicIpSecurity' => 'Prevención de ataques DoS mediante la restricción de IPs dinámicas de IIS',
    'iis-settings.isDenyByConcurrentRequests' => 'Denegar direcciones IP basándose en el número de peticiones concurrentes desde una única dirección IP',
    'iis-settings.maxConcurrentRequests' => 'Número máximo de peticiones concurrentes',
    'iis-settings.isDenyByRequestRate' => 'Denegar direcciones IP basándose en el número de peticiones realizadas en un período de tiempo',
    'iis-settings.maxRequests' => 'Número máximo de peticiones',
    'iis-settings.requestInterval' => 'Período de tiempo (en milisegundos)',

    'ip-addresses-selector.ipAddress' => 'Dirección IP',
    'ip-addresses-selector.ipv4Address' => 'Dirección IPv4',
    'ip-addresses-selector.ipv4AddressHint' => "La dirección IP donde se aloja el sitio web es una dirección de red del host virtual del sitio web.",
    'ip-addresses-selector.ipv6Address' => 'Dirección IPv6',
    'ip-addresses-selector.ipv6AddressHint' => "La dirección IP donde se aloja el sitio web es una dirección de red del host virtual del sitio web.",
    'ip-addresses-selector.noIpAddressHint' => 'Ninguna',
    'ip-addresses-selector.shared' => 'compartida',
    'ip-addresses-selector.exclusive' => 'dedicada',
    'ip-addresses-selector.ipV6OnlyNotSupported' => 'El servidor FTP no soporta IPv6. Asigne al menos una dirección IPv4, ya que de lo contrario el usuario no podrá cargar archivos al servidor vía FTP.',

    'license-key-revert.description' => 'Se restaurará la llave de licencia con las siguientes propiedades:',
    'license-key-revert.submitButton' => 'Revertir',

    'license-key-upload.description' => 'Instale su llave de licencia introduciendo un código de activación.',
    'license-key-upload.descriptionWithFileUpload' => 'Instale su llave de licencia introduciendo un código de activación o cargando un archivo de llave de licencia.',
    'license-key-upload.type' => 'Seleccione una de las siguientes opciones:',
    'license-key-upload.code' => 'Introduzca un código de activación',
    'license-key-upload.codeDescription' => 'Pegue el código de activación recibido.',
    'license-key-upload.file' => 'Cargar un archivo de llave de licencia',
    'license-key-upload.fileDescription' => 'Especifique la ruta al archivo que contiene la llave de licencia.',
    'license-key-upload.submitButton' => 'Instalar',

    'log-rotation.customLogsDescription' => 'Tenga en cuenta que sus registros personalizados no son rotados.',
    'log-rotation.logRotation' => 'Rotación de registros',
    'log-rotation.logRotationCondition' => 'Condición de rotación de registros',
    'log-rotation.logRotationBySize' => 'Por tamaño',
    'log-rotation.logRotationByTime' => 'Por hora',
    'log-rotation.logRotationDaily' => 'Diariamente',
    'log-rotation.logRotationWeekly' => 'Semanalmente',
    'log-rotation.logRotationMonthly' => 'Mensualmente',
    'log-rotation.logRotationSizeDescription' => 'El valor de tamaño debe estar entre %%min%% y %%max%% kB.',
    'log-rotation.maximumNumberOfFiles' => 'Número máximo de archivos de registro',
    'log-rotation.compress' => 'Comprimir archivos de registro',
    'log-rotation.sendLogToEmail' => 'Una vez Plesk haya recuperado los datos presentes en los archivos de registro de los servidores FTP y web, enviar los archivos de registro por email a esta dirección',
    'log-rotation.kb' => 'KB',
    'log-rotation.logRotationPeriodGreater' => 'El periodo no puede ser superior al límite a nivel del servidor de %%max%%.',

    'login.loginLabel' => 'Nombre de usuario',
    'login.passwdLabel' => 'Contraseña',
    'login.localeLabel' => 'Idioma del interfaz',
    'login.defaultLocale' => 'Predeterminado',
    'login.loginButtonLabel' => 'Iniciar sesión',
    'login.enterUsername' => 'Indique su nombre de usuario.',
    'login.enterPassword' => 'Indique su contraseña.',
    'login.whatUsernamePassword' => '¿Qué nombre de usuario y contraseña desea usar?',
    'login.forgotPasswordLabel' => '¿Ha olvidado su contraseña?',
    'login.cookies' => 'Directiva de cookies en Plesk',
    'login.avoidSSLWarningsMsg' => 'Con el fin de evitar la aparición de advertencias SSL durante el acceso a Plesk, use %%link%%',
    'login.digitalOceanMsg' => '¿Nuevo en Plesk en DigitalOcean? Use "root" y la contraseña indicada cuando cree este droplet para iniciar sesión. %%link%%',
    'login.amazonLightsailMsg' => '¿Nuevo en Plesk en Lightsail? Para iniciar sesión en Plesk, acceda al servidor mediante SSH y use el comando "plesk login". %%link%%',
    'login.readGuide' => 'Lea la lista completa.',
    'login.mobileApplicationMessage' => 'Si desea disfrutar de una mejor experiencia, le recomendamos instalar la aplicación %%name%%.',
    'login.mobileApplicationInstall' => 'Instalar ahora',
    'login.mobileApplicationHide' => 'No, gracias',

    'force-reset-password.saveButton' => 'Guardar',
    'force-reset-password.title' => 'Cambie su contraseña',
    'force-reset-password.passwordLabel' => 'Contraseña nueva',

    'panel-access.title' => 'Personalización de URL de Plesk',
    'panel-access.hint' => 'Escoja URLs personalizadas para acceder a Plesk. Esto no hará que ya no pueda acceder a Plesk mediante el puerto %%httpsPort%%. %%link%%',
    'panel-access.details' => 'Más información',
    'panel-access.proxyEnabled' => 'Todos los dominios y subdominios que resuelven a la dirección IP del servidor pero que no se usan para el hosting',
    'panel-access.proxyDomain' => 'El dominio o subdominio indicado que resuelve a la dirección IP del servidor pero no usado para el hosting',
    'panel-access.proxyDisabled' => 'Ninguna URL personalizada. Solo https://<server-IP-or-hostname>:%%httpsPort%%',

    'panel-access.Form.submitButton' => 'Guardar',
    'panel-access.Form.cancelButton' => 'Cancelar',

    'panel-access.domainNameIsRequired' => 'Indique un nombre de dominio.',
    'panel-access.successMessage' => 'Se ha aplicado la forma seleccionada de acceso.',
    'panel-access.notSupported' => 'Su Plesk no soporta la forma seleccionada de inicio de sesión.',
    'panel-access.notViaDomainName' => 'Para aplicar esta forma de inicio de sesión, seleccione la primera opción ("Todos los dominios y subdominios..."), acceda a Plesk mediante https://%%domainName%% y seleccione la segunda opción.',
    'panel-access.notViaPort' => 'Para aplicar esta forma de inicio de sesión, acceda a Plesk mediante https://<server-IP-or-hostname>:%%httpsPort%%.',

    'php-settings.performance' => 'Configuración de seguridad y rendimiento',
    'php-settings.settings' => 'Configuración común',
    'php-settings.fastCgiSettings' => 'Configuración de FastCGI',
    'php-settings.fpmSettings' => 'Configuración de PHP-FPM',
    'php-settings.enableFastcgi' => 'Habilitar la configuración de FastCGI',
    'php-settings.plainTextEditing' => 'Directivas adicionales',
    'php-settings.placeAdditionalCustomizationDirectivesHere' => 'Puede definir cualquier parámetro PHP introduciéndolo en el campo que aparece a continuación. Las directivas se incluirán en la configuración de PHP. Use la misma sintaxis que la que usaría para php.ini. Por ejemplo, si desea cargar la extensión mSQL automáticamente, añada la siguiente línea: extension=msql.so.',
    'php-settings.placeAdditionalCustomizationDirectivesHereAddonPlan' => 'Si no encuentra determinados parámetros PHP, añádalos en el campo que se muestra a continuación. Estas directivas se combinarán con las directivas del plan de servicio principal. Use la misma sintaxis que la usada para php.ini. Por ejemplo, si desea cargar la extensión mSQL automáticamente, añada la siguiente línea: extension=msql.so.',
    'php-settings.placeFpmAdditionalCustomizationDirectivesHere' => 'Puede definir cualquier parámetro PHP introduciéndolo en el campo que aparece a continuación. Las directivas se incluirán en la configuración de PHP. Use la misma sintaxis que la que usaría para php.ini. Por ejemplo, si desea cargar la extensión mSQL automáticamente, añada la siguiente línea: extension=msql.so. Para personalizar la configuración del grupo PHP-FPM, añada el separador [php-fpm-pool-settings] e introduzca la configuración deseada a continuación.',
    'php-settings.additionalConfigurationDirectives' => 'Directivas de configuración adicional',
    'php-settings.defaultValue' => 'Predeterminado',
    'php-settings.predefinedValue' => 'Seleccione un valor',
    'php-settings.customValue' => 'Introduzca un valor personalizado',
    'php-settings.phpSettingDescription_memory_limit' => 'La cantidad máxima de memoria en bytes que puede asignar un script.',
    'php-settings.phpSettingDescription_max_execution_time' => 'El tiempo máximo en segundos que puede ejecutarse un script antes de que sea terminado.',
    'php-settings.phpSettingDescription_max_input_time' => 'El tiempo máximo en segundos que un script puede analizar datos de entrada.',
    'php-settings.phpSettingDescription_post_max_size' => 'El tamaño máximo de bytes de datos que pueden publicarse con el método POST. Generalmente debería ser superior a upload_max_filesize e inferior a memory_limit.',
    'php-settings.phpSettingDescription_upload_max_filesize' => 'El tamaño máximo en bytes de un archivo cargado.',
    'php-settings.phpSettingDescription_safe_mode' => 'El modo seguro de PHP incluye varias restricciones relacionadas con la ejecución de scripts, principalmente por motivos de seguridad.',
    'php-settings.phpSettingDescription_safe_mode_include_dir' => 'Cuando la directiva safe_mode está activa, es posible acceder a los archivos presentes en el directorio especificado mediante scripts PHP. El directorio también debe estar en include_path.',
    'php-settings.phpSettingDescription_safe_mode_exec_dir' => 'Cuando la directiva safe_mode está activa, los programas presentes en el directorio especificado pueden ejecutarse mediante scripts PHP.',
    'php-settings.phpSettingDescription_include_path' => 'La lista de directorios donde los scripts realizan búsquedas de archivos (similar a la variable PATH del sistema). Para separar los directorios, use dos puntos (:) en Linux y punto y coma (;) en Windows.',
    'php-settings.phpSettingDescription_sessionsave_path' => 'El directorio donde se almacenan los archivos de sesión  de PHP.',
    'php-settings.phpSettingDescription_mailforce_extra_parameters' => 'Parámetros adicionales para la función mail().',
    'php-settings.phpSettingDescription_register_globals' => 'Registre el contenido de las variables EGPCS (Environment, GET, POST, Cookie, Server) como variables globales.',
    'php-settings.phpSettingDescription_open_basedir' => 'Es posible acceder a los archivos presentes en los directorios especificados mediante scripts PHP. Para separar los directorios, use dos puntos (:) en Linux y punto y coma (;) en Windows.',
    'php-settings.phpSettingDescription_error_reporting' => 'El nivel de información del error.',
    'php-settings.phpSettingDescription_display_errors' => 'Determina si los errores deberían mostrarse como parte de la salida.',
    'php-settings.phpSettingDescription_log_errors' => 'Active el registro de los errores PHP.',
    'php-settings.phpSettingDescription_allow_url_fopen' => 'Permite a las funciones de archivo PHP recuperar datos de ubicaciones remotas mediante FTP o HTTP.',
    'php-settings.phpSettingDescription_file_uploads' => 'Permite cargar archivos mediante HTTP.',
    'php-settings.phpSettingDescription_short_open_tag' => 'Permite la forma breve ( ) de la etiqueta abierta de PHP.',
    'php-settings.phpSettingDescription_magic_quotes_gpc' => 'Establece el estado magic_quotes para las operaciones GPC (Get/Post/Cookie). Cuando magic_quotes está habilitado, todos los caracteres nulos, comillas simples, comillas dobles y barras diagonales inversas son terminados automáticamente con una barra diagonal inversa.',
    'php-settings.phpSettingDescription_disable_functions' => 'Esta directiva le permite desactivar algunas funciones. Esta efectúa una lista delimitada por comas de nombres de función',
    'php-settings.phpSupport' => 'Soporte para PHP',
    'php-settings.phpRunAs' => 'ejecutar PHP como',
    'php-settings.phpVersion' => 'Versión de PHP',
    'php-settings.phpHandlerOutdated' => '(Obsoleto)',
    'php-settings.phpHandlerDeprecated' => '(En desuso)',
    'php-settings.phpServedByApache' => 'servido por Apache',
    'php-settings.phpServedByNginx' => 'servido por nginx',
    'php-settings.phpSettingsPhpVersion' => 'Su versión de PHP es %%version%%.',
    'php-settings.phpSettingsPhpDisabled' => 'PHP está desactivado.',
    'php-settings.phpHandlerTypeHint' => 'A continuación puede ver la configuración PHP del sitio web. Puede cambiar la configuración PHP siempre que el proveedor de hosting le conceda el permiso correspondiente.',
    'php-settings.fpmDedicatedHandlerHint' => 'El uso de este controlador aumenta la estabilidad de un sitio web, si bien consume más memoria.',
    'php-settings.phpHandlerChangeHint' => 'Ha modificado la configuración de controlador de PHP. Si guarda los cambios, es posible que los scripts PHP presentes en su sitio web se detengan durante %%interval%% segundos debido a la configuración de su servidor.',
    'php-settings.phpHandlerTypeHelpLink' => 'Descubra cómo escoger la configuración PHP más adecuada',
    'php-settings.phpHandlerTypeNotAvailableHint' => 'No es posible activar el soporte de PHP porque la configuración de hosting actual no incluye ninguna versión de PHP disponible para este dominio.',
    'php-settings.phpHandlersNotAvailableHint' => 'No puede activarse el soporte de PHP porque la configuración actual de Plesk no incluye ninguna versión disponible de PHP.',
    'php-settings.phpHandlerTypeNotAvailableHelpLink' => 'Descubra cómo activar otras versiones de PHP.',
    'php-settings.phpSupportEditable' => '(Versión de PHP %%version%%, ejecutar PHP como %%handler%%) %%link%%',
    'php-settings.phpSupportReadonly' => '(versión: %%version%%; controlador: %%handler%%) %%link%%',
    'php-settings.phpSupportReadonlyNotRegistered' => '(no registrado) %%link%%',
    'php-settings.showPhpInfo' => 'Ver la página phpinfo()',
    'php-settings.phpSettingsFormError' => 'No fue posible recuperar la configuración PHP porque no se encontraron los datos requeridos.',
    'php-settings.phpSettingsFormBrokenPhpHandler' => 'No se ha podido recuperar la configuración de PHP porque esta versión de PHP no está instalada. Para continuar, instale la versión seleccionada de PHP o seleccione otra versión para el dominio.',
    'php-settings.showPhpInfoTitle' => 'Ver phpinfo()',
    'php-settings.showPhpInfoDescription' => 'Algunas de las modificaciones efectuada en la configuración de PHP todavía no se han guardado. Para ver los nuevos valores en la página phpinfo(), aplique primero los cambios. En caso contrario, se mostrarán los valores actuales.',
    'php-settings.showPhpInfoButton' => 'Ver phpinfo()',
    'php-settings.onState' => 'Habilitado',
    'php-settings.offState' => 'Desactivado',

    'pmm.agent.sync.check' => 'El agente de migraciones y transferencias está buscando actualizaciones.',
    'pmm.agent.sync.updating' => 'Sincronizando y descargando el agente de migraciones y transferencias',
    'pmm.agent.sync.done' => 'El agente de migraciones y transferencias se ha sincronizado correctamente.',
    'pmm.agent.sync.downloadLink' => 'Haga clic para descargar el archivo del agente de migraciones y transferencias que debería instalarse en el host de origen antes de que se inicie la migración.',
    'pmm.agent.sync.error' => 'El agente de migraciones y transferencias no pudo obtener las actualizaciones. Inténtelo de nuevo transcurridos unos minutos.',

    'restore-password.title' => 'Cambie su contraseña',
    'restore-password.passwordLabel' => 'Contraseña nueva',
    'restore-password.buttonRestore' => 'Guardar',
    'restore-password.buttonCancel' => 'Cancelar',
    'restore-password.isEmpty' => 'El campo obligatorio está vacío. Indique algún valor.',
    'restore-password.errorInvalidSecret' => 'Código secreto no válido',
    'restore-password.errorNotFoundSecret' => 'Solicite un nuevo código secreto',
    'restore-password.restoreSuccess' => 'Su contraseña ha sido actualizada. Use la contraseña nueva para acceder a Plesk o a su dirección de email.',

    'scheduler.settings.schedulerNotification' => 'Notificación del programador',
    'scheduler.settings.notificationOff' => "Desactivado",
    'scheduler.settings.notificationDefault' => "Enviar a la dirección de email predeterminada (%%email%%)",
    'scheduler.settings.notificationCustom' => "Enviar a la dirección de email que especifique",
    'scheduler.settings.crontabSecureShell' => 'Crontab shell',
    'scheduler.settings.schedulerTimezoneSelector' => 'Mostrar programación de tareas usando una zona horaria',
    'scheduler.settings.schedulerTimezoneSelectorDefaultWithLabel' => 'Usar la zona horaria predeterminada del sistema (%%timezone%%)',
    'scheduler.settings.schedulerTimezoneSelectorDefault' => 'Usar la zona horaria predeterminada del sistema',
    'scheduler.settings.schedulerTimezoneSelectorCustom' => 'Usar la zona horaria que especifico',

    'scheduler.task.active' => 'Activa',
    'scheduler.task.subscription' => 'Suscripción',
    'scheduler.task.subscription_powerUser' => 'Espacio web',
    'scheduler.task.type' => 'Tipo de tarea',
    'scheduler.task.typeCommand' => 'Ejecutar un comando',
    'scheduler.task.typeUrl' => 'Obtener una URL',
    'scheduler.task.typeScript' => 'Ejecutar un script PHP',
    'scheduler.task.command' => 'Comando',
    'scheduler.task.arguments' => 'con argumentos',
    'scheduler.task.url' => 'URL',
    'scheduler.task.urlDescription' => 'Especifique una URL absoluta, como por ejemplo http://example.com. Si el código de estado de la respuesta es 2xx o 3xx, se considerará que la tarea se ha ejecutado correctamente.',
    'scheduler.task.script' => 'Ruta de acceso del script',
    'scheduler.task.scriptRelativePathDescription' => 'Ejemplo: %%path%%',
    'scheduler.task.scriptAbsolutePathDescription' => 'Indique la ruta completa al script. Ejemplo: %%path%%',
    'scheduler.task.scriptPhpVersion' => 'Usar la versión PHP',
    'scheduler.task.scriptPathPopupTitle' => 'Ruta de acceso del script',
    'scheduler.task.run' => 'Ejecutar',
    'scheduler.task.on' => 'el',
    'scheduler.task.at' => 'en',
    'scheduler.task.sysUser' => 'Usuario del sistema',
    'scheduler.task.hourly' => 'Cada hora',
    'scheduler.task.daily' => 'Diariamente',
    'scheduler.task.weekly' => 'Cada semana',
    'scheduler.task.monthly' => 'Cada mes',
    'scheduler.task.yearly' => 'Anualmente',
    'scheduler.task.cronStyle' => 'Estilo cron',
    'scheduler.task.cronStyleError' => 'La sintaxis crontab no es válida.',
    'scheduler.task.cronStyleErrorWin' => 'No se permite el uso de barras (/) ni guiones (-).',
    'scheduler.task.cronStyleHint' => 'Use el formato crontab UNIX  "minuto hora día del mes mes día de la semana". Por ejemplo "0 22 * * 1-5". Plesk utilizará la zona horaria predeterminada del sistema para ejecutar la tarea.',
    'scheduler.task.cronStyleWinHint' => 'Use el formato "minuto hora día del mes mes día de la semana". Por ejemplo "0 22 * * 6,7". Plesk utilizará la zona horaria predeterminada del sistema para ejecutar la tarea.',
    'scheduler.task.notify' => 'Notificar',
    'scheduler.task.notifyIgnore' => 'No notificar',
    'scheduler.task.notifyErrors' => 'Solo errores',
    'scheduler.task.notifyAlways' => 'Siempre',
    'scheduler.task.notifyErrorsHint' => 'Las notificaciones contienen la secuencia estándar de error del comando. Si la secuencia está vacía, no se enviará ninguna notificación.',
    'scheduler.task.notifyErrorsHintWin' => 'Las notificaciones contienen la salida del comando y solo se envían si el código de salida no es cero.',
    'scheduler.task.notifyAlwaysHint' => 'Las notificaciones contienen la salida del comando. Si la salida está vacía, no se enviará ninguna notificación.',
    'scheduler.task.notifyAlwaysHintWin' => 'Las notificaciones contienen la salida del comando y se envían sea cual sea el código de salida del comando.',
    'scheduler.task.emailType' => 'Enviar notificaciones a',
    'scheduler.task.emailTypeDefault' => 'Usuario predeterminado del sistema (%%email%%)',
    'scheduler.task.emailTypeOwner' => 'Propietario de la suscripción (%%email%%)',
    'scheduler.task.emailTypeOwnerAdmin' => 'Administrador (%%email%%)',
    'scheduler.task.emailTypeCustom' => 'Otros usuarios',
    'scheduler.task.emailTypeCustomDescription' => 'Puede introducir varias direcciones separándolas con comas.',
    'scheduler.task.minute' => 'minuto',
    'scheduler.task.shortMinute' => 'min',
    'scheduler.task.dayOfMonth' => 'día',
    'scheduler.task.description' => 'Descripción',
    'scheduler.task.scheduleTimezoneHint' => 'La zona horaria para la ejecución de la tarea es %%timezone%%',
    'scheduler.task.runTaskNow' => 'Ejecutar ahora',
    'scheduler.task.runningTask' => 'Ejecutando la tarea "%%task%%"...',

    'server-settings.submitDone' => "La configuración del servidor ha sido modificada.",
    'server-settings.systemSettings' => "Configuración del sistema",
    'server-settings.fullHostName' => "Nombre de host completo",
    'server-settings.trafficStatisticsPeriod' => "Conservar estadísticas de tráfico y web durante",
    'server-settings.trafficStatisticsPeriodUnit' => "meses",
    'server-settings.diskSpaceUsageCalculation' => "¿Qué desea incluir en el cálculo de uso de espacio en disco?",
    'server-settings.includeLogs' => "archivos de registro e informes estadísticos",
    'server-settings.includeMysqlDatabases' => "Bases de datos MySQL",
    'server-settings.includeMssqlDatabases' => "Bases de datos Microsoft SQL",
    'server-settings.includeDatabases' => "bases de datos",
    'server-settings.includeRemoteDatabases' => "Bases de datos remotas",
    'server-settings.includeMailboxes' => "buzones de correo",
    'server-settings.includeMailLists' => "listas de correo",
    'server-settings.includeDomainDumps' => "archivos de backup del dominio",
    'server-settings.includeAdminDumps' => "archivos de backup creados por el administrador",
    'server-settings.calculatingDiskSpaceUsage' => "Al calcular el uso del espacio en disco, contabilizar",
    'server-settings.typeByte' => "tamaño del archivo",
    'server-settings.typeBlock' => "cantidad de espacio en disco usado",
    'server-settings.trafficCalculation' => "¿Qué desea incluir en el cálculo de tráfico?",
    'server-settings.inboundAndOutbound' => "tráfico entrante y saliente",
    'server-settings.onlyInbound' => "solo tráfico entrante",
    'server-settings.onlyOutbound' => "solo tráfico saliente",
    'server-settings.forbidCreateDnsSubZone' => "No permitir a los usuarios crear subzonas DNS en las súper zonas DNS de otros usuarios",
    'server-settings.webDeployIncludePassword' => "Incluir la contraseña del usuario en el archivo con la configuración de publicación de Web Deploy",
    'server-settings.forbidSysUserRename' => "Los clientes pueden modificar el nombre de sus usuarios de sistema",
    'server-settings.alwaysAllowSysUserRename' => "siempre",
    'server-settings.ifPermissionIsGrantedAllowSysUserRename' => "únicamente si se concede el permiso de administración del hosting",
    'server-settings.neverAllowSysUserRename' => "nunca",
    'server-settings.forbidSubscriptionRename' => "Prohibir a los clientes y revendedores cambiar su nombre de dominio principal",
    'server-settings.preferredDomain' => "Dominio preferido para los sitios web",
    'server-settings.preferredDomainNone' => "ninguna",
    'server-settings.preferredDomainToLanding' => "domain.tld",
    'server-settings.preferredDomainToWww' => "www.domain.tld",
    'server-settings.ipLogging' => "Registro de IPs",
    'server-settings.disableIpLogging' => "Desactivar registro de IPs en IIS, FTP y registros de correo",
    'server-settings.disableIpLoggingDescription' => "De seleccionarse, IIS y MailEnable ya no escribirán direcciones IP en archivos de registro",
    'server-settings.anonymizeIps' => "Anonimizar direcciones IP",
    'server-settings.logrotateAnonymizeIps' => "Anonimizar las direcciones IP durante la rotación de registros y la recopilación de estadísticas web",
    'server-settings.logrotateAnonymizeIpsDescription' => 'El script postrotate reemplaza el último octeto de direcciones IPv4 en los archivos de registro rotados por "0" antes del archivado. En el caso de las direcciones IPv6, el script reemplaza la última sección de la dirección (dos octetos tras los últimos dos puntos) por "0000" (en forma completa) o por "0" (en forma abreviada)',
    'server-settings.logrotate' => "Rotación de registros",
    'server-settings.logrotateForce' => "Forzar la rotación diaria para todos los dominios",
    'server-settings.allowToStoreLogs' => "Permitir el almacenamiento de registros de sitio web durante",
    'server-settings.logrotatePeriod' => "días",
    'server-settings.configureUpdatePolicy' => "Configurar directiva de actualización",

    'service-plan.mail.outgoing-messages.outgoingMessagesDefault' => 'Valor predeterminado a nivel del servidor (%%default%% mensajes por hora)',
    'service-plan.mail.outgoing-messages.outgoingMessagesSpecificPlan' => 'Valor personalizado para el plan',
    'service-plan.mail.outgoing-messages.outgoingMessagesSpecificSubscription' => 'Valor personalizado para la suscripción',
    'service-plan.mail.outgoing-messages.outgoingMessagesSpecificHint' => 'mensajes',
    'service-plan.mail.outgoing-messages.mboxOutgoingMessages' => 'Correos salientes desde un buzón (por hora)',
    'service-plan.mail.outgoing-messages.domainOutgoingMessages' => 'Correos salientes desde un dominio (por hora)',
    'service-plan.mail.outgoing-messages.subscriptionOutgoingMessages' => 'Correos salientes desde una suscripción (por hora)',
    'service-plan.mail.outgoing-messages.outgoingMessagesOverLimit' => 'El porcentaje de mensajes por encima del límite por hora que debería enviarse durante la próxima hora',
    'service-plan.mail.outgoing-messages.outgoingMessagesOverLimitDescription' => 'Si el límite de correos salientes por hora desde un buzón es 100 y el porcentaje es 10%, el usuario podrá enviar 110 mensajes cada hora. 100 mensajes se enviarán durante una hora y los 10 restantes se pondrán en la cola y se programará su entrega para al cabo de una hora.',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmail' => 'Política de uso de Sendmail',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailDefault' => 'Configuración predeterminada a nivel del servidor (Se permite el uso de Sendmail)',
    'service-plan.mail.outgoing-messages.outgoingMessagesNotEnableSendmailDefault' => 'Configuración predeterminada a nivel del servidor (No se permite el uso de Sendmail)',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomPlan' => 'Configuración personalizada para el plan',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomSubscription' => 'Configuración personalizada para la suscripción',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomLabel' => 'Permitir el uso de Sendmail para scripts y usuarios en esta suscripción',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomHint' => 'Los scripts y usuarios podrán enviar emails (en nombre del usuario de sistema de la suscripción) usando Sendmail incluso si se han excedido los límites de un buzón de correo y un dominio. El número máximo de mensajes que puede enviarse mediante Sendmail se definirá por el límite para toda una suscripción.',

    'setup.hint' => 'Bienvenido a Plesk, un panel de control que le ayuda a gestionar su servidor. Plesk le proporciona un entorno preparado para código y un completo conjunto de potentes extensiones a través de las cuales puede desarrollar aplicaciones y sitios web. Complete el proceso de configuración para así poder empezar a usar Plesk. Solo le llevará un minuto.',
    'setup.contactInfoSection' => 'Información de contacto',
    'setup.contactInfoSectionHint' => 'Introduzca su nombre y su dirección de correo para así poder identificarse como el propietario del servidor y recibir notificaciones importantes sobre el servidor. Si es administrador de un servidor corporativo, no indique su nombre ni su dirección de email personal. En su lugar, indique su cargo y la dirección de email de la empresa para así evitar posibles infracciones de la ley de protección de datos.',
    'setup.contactName' => 'Su nombre de contacto',
    'setup.emptyContactName' => 'Proporcione un nombre de contacto.',
    'setup.contactNameTooLong' => 'El nombre de contacto es demasiado largo (se permiten un máximo de %max% símbolos).',
    'setup.email' => 'Email',
    'setup.emptyEmail' => 'Indique una dirección de email.',
    'setup.passwordSection' => 'Contraseña',
    'setup.passwordSectionHint' => 'La próxima vez que acceda a Plesk, use el nombre de usuario \'admin\' y la contraseña que ha indicado abajo.',
    'setup.password' => 'Contraseña',
    'setup.licenseSection' => 'Licencia',
    'setup.licenseSectionHint' => 'Para empezar a usar Plesk, instale una licencia.',
    'setup.licenseType' => 'Seleccione el tipo de licencia',
    'setup.licenseTypePaid' => 'Proceder con una licencia de pago',
    'setup.onlineStoreLink' => 'Tienda online',
    'setup.licenseTypeTrial' => 'Proceder con una licencia de prueba totalmente funcional',
    'setup.activationCodeHint' => 'Si ya ha comprado una licencia de Plesk, pegue el código de activación recibido aquí. De lo contrario, puede comprar una licencia en nuestra %%onlineStoreLink%%.',
    'setup.privacyPolicyLink' => 'Directiva de privacidad de Plesk',
    'setup.trialLicenseAgreement' => 'Con el fin de poder emitir la licencia de prueba, Plesk International GmbH usará y procesará la información indicada en sus sistemas internos conforme a la %%privacyPolicyLink%%.',
    'setup.eulaAgreementLabel' => 'Confirmo que he leído y que acepto los %%link%%',
    'setup.eula' => 'Contrato de licencia del usuario final',
    'setup.invalidEulaAgreementValue' => 'Acepte el contrato de licencia del usuario final',
    'setup.sendButton' => 'Acceder a Plesk >>',
    'setup.resetPasswordOnFirstLogin' => 'Restablecer la contraseña admin en el próximo inicio de sesión',

    'ssl-certificate.add.name' => 'Nombre del certificado',
    'ssl-certificate.add.longName' => 'El nombre del certificado especificado es demasiado largo. La longitud máxima permitida es de %max% símbolos.',
    'ssl-certificate.add.certificateNameUsed' => 'Ya existe un certificado denominado %%name%%.',
    'ssl-certificate.add.certificateAdded' => 'El certificado SSL/TLS ha sido emitido. Para que se aplique correctamente, asigne el certificado para la protección de un dominio, correo o webmail.',
    'ssl-certificate.add.certificateUpdated' => 'El certificado SSL/TLS se ha actualizado correctamente.',
    'ssl-certificate.add.settings' => 'Configuración',
    'ssl-certificate.add.settingsHint' => 'Use este formulario para generar una petición de certificado, para comprar un certificado a su proveedor o para generar un certificado autofirmado.',
    'ssl-certificate.add.settingsHint2' => 'Una petición es un archivo CSR que contiene información acerca del dominio especificado en el formulario. Puede enviar la petición a una autoridad de certificación para que emitan un certificado para usted. Posteriormente, usted lo cargará mediante una de las opciones que aparecen a continuación.',
    'ssl-certificate.add.settingsHint3' => 'Un certificado autofirmado es un certificado de identidad firmado por su creador. Si usa este tipo de certificado, usted será el que verificará la identidad de sus sitios. Aunque los certificados autofirmados permiten el uso de SSL/TLS, los usuarios no confían tanto en estos porque creen que son menos seguros.',
    'ssl-certificate.add.bits' => 'Bits',
    'ssl-certificate.add.country' => 'País',
    'ssl-certificate.add.state' => 'Estado o provincia',
    'ssl-certificate.add.longState' => 'El nombre del estado o provincia especificado es demasiado largo.',
    'ssl-certificate.add.city' => 'Lugar (ciudad)',
    'ssl-certificate.add.longCity' => 'El nombre de ciudad especificado es demasiado largo.',
    'ssl-certificate.add.shortCity' => 'El nombre de ciudad especificado es demasiado corto.',
    'ssl-certificate.add.companyName' => 'Nombre de la empresa',
    'ssl-certificate.add.longCompanyName' => 'El nombre de empresa especificado es demasiado largo.',
    'ssl-certificate.add.companyUnitName' => 'Nombre del departamento/división de la empresa',
    'ssl-certificate.add.longCompanyUnitName' => 'El nombre del departamento de la organización especificado es demasiado largo. La longitud máxima permitida es de %max% símbolos.',
    'ssl-certificate.add.domainName' => 'Nombre del dominio',
    'ssl-certificate.add.email' => 'Email',
    'ssl-certificate.add.request' => 'Solicitar',
    'ssl-certificate.add.buyCertificate' => 'Comprar certificado SSL/TLS',
    'ssl-certificate.add.selfSigned' => 'Autofirmado',
    'ssl-certificate.add.invalidCertificateParams' => 'Algunos campos están en blanco o contienen valores incorrectos. Los valores están limitados a 64 caracteres. Si está usando nombres de dominios internacionales, verifique que ninguna parte del nombre de dominio entre puntos excede los 63 caracteres una vez transformado al formato ASCII. Compruebe los siguientes campos:',
    'ssl-certificate.add.unableCreateCsr' => 'No se pudo crear un CSR: %%error%%',
    'ssl-certificate.add.unableCreateSelfSigned' => 'No se pudo crear un certificado autofirmado: %%error%%',
    'ssl-certificate.add.unableCreateUpload' => 'No se pudieron establecer los datos del certificado: %%error%%',
    'ssl-certificate.add.unableSaveCertificate' => 'No se pudo guardar el certificado en la base de datos: %%error%%',
    'ssl-certificate.add.uploadFiles' => 'Cargar los archivos del certificado',
    'ssl-certificate.add.uploadFilesHint' => 'Use este formulario para cargar los componentes de un certificado como archivos constituyentes.',
    'ssl-certificate.add.csr' => 'CSR',
    'ssl-certificate.add.privateKey' => "Clave privada (*.key)",
    'ssl-certificate.add.certificate' => "Certificado (*.crt)",
    'ssl-certificate.add.caCertificate' => "Certificado CA (*-ca.crt)",
    'ssl-certificate.add.sendFiles' => "Cargar certificado",
    'ssl-certificate.add.fileNotUploaded' => 'No se pudo cargar el archivo del certificado: %%name%%.',
    'ssl-certificate.add.unableSetPrivateKey' => 'No se pudo establecer la clave privada: %%error%%',
    'ssl-certificate.add.unableSetCertificate' => 'No se pudo establecer el certificado: %%error%%',
    'ssl-certificate.add.unableSetCaCertificate' => 'No se pudo establecer el certificado CA: %%error%%',
    'ssl-certificate.add.unableCheckCaCertificate' => 'No se pudo comprobar si el certificado CA firma el certificado: %%error%%',
    'ssl-certificate.add.removeCaCertificate' => 'Eliminar',
    'ssl-certificate.add.removeCaCertificateConfirmation' => '¿Desea eliminar el certificado CA?',
    'ssl-certificate.add.unableRemoveCaCertificate' => 'No se pudo borrar el certificado CA: %%error%%',
    'ssl-certificate.add.caCertificateRemoved' => 'La parte CA del certificado ha sido eliminada.',
    'ssl-certificate.add.rename' => 'Cambiar nombre',
    'ssl-certificate.add.unableRenameCertificate' => 'No se pudo cambiar el nombre del certificado: %%error%%',
    'ssl-certificate.add.certificateRenamed' => 'El nombre del certificado se ha cambiado a %%name%%.',
    'ssl-certificate.add.uploadText' => "Cargar el certificado como texto",
    'ssl-certificate.add.uploadTextHint' => 'Use este formulario para cargar los componentes de un certificado como texto. Copie el contenido de un archivo y péguelo al campo correspondiente.',
    'ssl-certificate.add.sendText' => "Cargar certificado",
    'ssl-certificate.add.componentIsMissing' => 'No se ha podido encontrar el componente.',

    'ssl-certificate.find-private-key.findPrivateKey' => 'Cargue el certificado aquí',
    'ssl-certificate.find-private-key.formGeneralHint' => 'Si creó una petición de firma de certificado en este servidor y recibió el archivo de certificado, cárguelo aquí. Si desea cargar un certificado y un par de claves privadas generados en otro servidor o si desea generar un certificado autofirmado, haga clic en <b> Añadir certificado SSL/TLS</b>.',
    'ssl-certificate.find-private-key.formCertificateAddingHint' => 'Tras añadir un certificado SSL/TLS a un dominio, deberá activar el soporte para SSL/TLS y seleccionar dicho certificado en la configuración de hosting de sitios web: <b>Sitios web y dominios</b> > <b>Configuración de hosting</b> de este dominio > <b>Seguridad</b>.',
    'ssl-certificate.find-private-key.uploadCertificate' => 'Certificado (*.crt)',
    'ssl-certificate.find-private-key.sendFile' => 'Cargar certificado',
    'ssl-certificate.find-private-key.fileNotUploaded' => 'No se pudo cargar el archivo del certificado.',
    'ssl-certificate.find-private-key.invalidCertificateFormat' => 'Formato del certificado no válido.',
    'ssl-certificate.find-private-key.unableFindPrivateKey' => 'No se puede encontrar la clave privada apropiada para el certificado.',

    'ssl-certificate.secure.certificate' => 'Seleccionar certificado',
    'ssl-certificate.secure.serverPool' => 'Grupo de servidores',
    'ssl-certificate.secure.certificateName' => '%%certificateName%% (%%repositoryName%%)',

    'system-time.date' => "Fecha",
    'system-time.dateAndTime' => "Fecha y hora",
    'system-time.daylight' => "Ajustar el reloj automáticamente según el horario de verano",
    'system-time.dayMonthYear' => "Día-Mes-Año",
    'system-time.domainNameOrIp' => "Nombre de dominio o IP",
    'system-time.hoursMinutesSeconds' => "Horas:Minutos:Segundos",
    'system-time.networkTime' => "Hora de red",
    'system-time.submitDone' => "La configuración de la hora del sistema ha sido modificada.",
    'system-time.synchronizedSystemTime' => "Sincronizar fecha y hora del sistema",
    'system-time.title' => "Fecha y hora del sistema",
    'system-time.timezone' => "Zona horaria",
    'system-time.time' => "Hora",
    'system-time.updateSystemTime' => "Actualizar fecha y hora del sistema",
    'system-time.yourTimezone' => "Su zona horaria",

    'web-app-firewall.pageHint' => 'El firewall para aplicaciones web protege las aplicaciones web de ataques mediante la comprobación y el filtrado de peticiones HTTP entrantes basándose en reglas definidas por el usuario.',
    'web-app-firewall.webSitePageHint' => 'Aquí puede configurar el firewall para aplicaciones web (ModSecurity).',
    'web-app-firewall.ruleEngine' => 'Modo de firewall para aplicaciones web',
    'web-app-firewall.ruleEngineOn' => 'Activado',
    'web-app-firewall.ruleEngineOnDescription' => 'Cada petición HTTP entrante y la respuesta relacionada se comprueban con un conjunto de reglas. Si la verificación es correcta, la petición HTTP se envía al contenido del sitio web. Si no lo es, el evento se registra, se envía una notificación y se proporciona la respuesta HTTP con un código de error.',
    'web-app-firewall.ruleEngineOff' => 'Deshabilitado',
    'web-app-firewall.ruleEngineOffDescription' => 'Las peticiones HTTP entrantes y las respuestas relacionadas no son verificadas.',
    'web-app-firewall.ruleEngineDetectionOnly' => 'Solo detección',
    'web-app-firewall.ruleEngineDetectionOnlyDescription' => 'Cada petición HTTP entrante y la respuesta relacionada se comprueba con un conjunto de reglas. Si la verificación es correcta, la petición HTTP se envía al contenido del sitio web. Si no lo es, el evento se registra y ModSecurity no efectúa ninguna otra acción. Los demás servicios (como por ejemplo Fail2ban) pueden seguir efectuando sus propias acciones relacionadas con las peticiones HTTP que produjeron errores durante la verificación.',
    'web-app-firewall.ruleSetsSection' => 'Conjuntos de reglas',
    'web-app-firewall.ruleSetsSectionHint' => 'Seleccione el conjunto de reglas (un paquete de archivos que incluya reglas de seguridad) a usar para comprobar las peticiones HTTP entrantes.',
    'web-app-firewall.ruleSet' => 'Conjunto de reglas',
    'web-app-firewall.ruleSetCrs' => 'OWASP (gratuito)',
    'web-app-firewall.ruleSetCrsDescription' => 'OWASP ModSecurity Core Rule Set es muy restrictivo y puede bloquear algunas funciones (como la compartición de archivos o el webmail) i algunas prestaciones de aplicaciones web (como puede ser el caso de los plugins de WordPress).',
    'web-app-firewall.ruleSetCrsConfirmTitle' => '¿Desea aplicar los cambios?',
    'web-app-firewall.ruleSetCrsConfirmDescription' => 'Las reglas OWASP pueden resultar demasiado restrictivas y como consecuencia bloquear algunas funciones, como por ejemplo la compartición de archivos, el servicio de webmail y algunas aplicaciones web.',
    'web-app-firewall.ruleSetTortix' => 'Atomic Standard (gratuito, puede mejorarse a Atomic Advanced)',
    'web-app-firewall.ruleSetTortixDescription' => 'Versión inicial de ModSecurity Rules de Atomicorp. Proporciona protección básica y se actualiza cada mes.',
    'web-app-firewall.ruleSetTortixHowTo' => 'Si desea mejorar este conjunto de reglas a Atomic Advanced:',
    'web-app-firewall.ruleSetTortixBuy' => 'Compre %%linkPleskStore%% en el sitio web de Plesk y %%linkDocumentation%%.',
    'web-app-firewall.ruleSetTortixLinkPleskStoreLabel' => 'Reglas de ModSecurity avanzadas de Atomicorp',
    'web-app-firewall.ruleSetTortixLinkDocumentationLabel' => 'instale la llave de licencia adicional comprada',
    'web-app-firewall.ruleSetTortixSelect' => 'Seleccione este conjunto de reglas, lo que cambiará su nombre a “Atomic Advanced (comprado a través de Plesk)”',
    'web-app-firewall.ruleSetTortixPro' => 'Atomic Advanced (comprado a través de Plesk)',
    'web-app-firewall.ruleSetTortixProDescription' => 'Advanced ModSecurity Rules de Atomicorp incluye las reglas Atomic Standard y varias prestaciones avanzadas.',
    'web-app-firewall.ruleSetAtomic' => 'Atomic Advanced (comprado a través de Atomicorp)',
    'web-app-firewall.ruleSetAtomicDescription' => 'Advanced ModSecurity Rules de Atomicorp incluye las reglas Atomic Standard y varias prestaciones avanzadas.',
    'web-app-firewall.ruleSetAtomicInstall' => 'Cambie a otra cuenta de Atomicorp.',
    'web-app-firewall.ruleSetAtomicInstalled' => 'El conjunto de reglas está activado.',
    'web-app-firewall.ruleSetAtomicHowTo' => 'Si ya dispone de la cuenta de Atomicorp habiendo comprado las reglas Atomic Advanced, indique las credenciales de la cuenta a continuación para activar este conjunto de reglas.',
    'web-app-firewall.ruleSetAtomicSwitchHowTo' => 'Si ya dispone de la cuenta de Atomicorp habiendo comprado las reglas Atomic Advanced, indique las credenciales de la cuenta a continuación para cambiar de cuenta.',
    'web-app-firewall.ruleSetAtomicLogin' => 'Nombre de usuario',
    'web-app-firewall.ruleSetAtomicPassword' => 'Contraseña',
    'web-app-firewall.ruleSetComodo' => 'Comodo (suscripción gratuita)',
    'web-app-firewall.ruleSetComodoDescription' => 'Free ModSecurity Rules de Comodo. Proporciona protección básica.',
    'web-app-firewall.ruleSetComodoInstall' => 'Cambie a otra cuenta de Comodo.',
    'web-app-firewall.ruleSetComodoInstalled' => 'El conjunto de reglas está activado.',
    'web-app-firewall.ruleSetComodoHowTo' => 'Para habilitar este conjunto de reglas:',
    'web-app-firewall.ruleSetComodoSwitchHowTo' => 'Para cambiar a otra cuenta:',
    'web-app-firewall.ruleSetComodoRegister' => 'Regístrese en el sitio web de Comodo.',
    'web-app-firewall.ruleSetComodoCredentials' => 'Indique su nombre de usuario y contraseña para dicho sitio web.',
    'web-app-firewall.ruleSetComodoLogin' => 'Nombre de usuario',
    'web-app-firewall.ruleSetComodoPassword' => 'Contraseña',
    'web-app-firewall.ruleSetComodoFree' => 'Comodo (gratuito)',
    'web-app-firewall.ruleSetComodoFreeDescription' => 'Free ModSecurity Rules de Comodo. Proporciona protección básica.',
    'web-app-firewall.ruleSetCustom' => 'Conjunto de reglas personalizado',
    'web-app-firewall.ruleSetCustomDescription' => 'Cargue un conjunto de reglas personalizado para el firewall para aplicaciones web. Se soportan los siguientes formatos: zip, tar.gz, tgz, tar.bz2, conf.',
    'web-app-firewall.ruleSetCustomUpload' => 'Seleccionar otro archivo',
    'web-app-firewall.ruleSetError' => 'Error al instalar el conjunto de reglas de ModSecurity: %%error%%',
    'web-app-firewall.ruleSetOWASPMissingError' => 'No se encuentra el conjunto de reglas OWASP. Vuelva a instalar ModSecurity usando Plesk Installer.',
    'web-app-firewall.ruleSetCustomMissingError' => 'No se encuentra el conjunto de reglas personalizado. Vuélvalo a instalar.',
    'web-app-firewall.ruleSetAuthError' => 'El nombre de usuario o la contraseña especificados no son válidos.',
    'web-app-firewall.ruleSetInvalid' => 'El conjunto de reglas seleccionado no puede ejecutarse en %%webServer%%.',
    'web-app-firewall.ruleSetSelectedInvalid' => 'El conjunto de reglas seleccionado no puede ejecutarse en el servidor web seleccionado.',
    'web-app-firewall.webServer' => 'Ejecutar reglas el',
    'web-app-firewall.webServerHint' => 'Seleccione la combinación deseada de servidor web y versión de ModSecurity para ver los conjuntos de reglas compatibles.',
    'web-app-firewall.webServerApache' => 'Apache (ModSecurity 2.9)',
    'web-app-firewall.webServerNginx' => 'Nginx (ModSecurity 3.0)',
    'web-app-firewall.webServerIis' => 'IIS (ModSecurity 2.9)',
    'web-app-firewall.nginxNotRunning' => 'El servidor proxy inverso (nginx) está desactivado y no puede usarse para procesar peticiones. Seleccione <a href="%%serverUrl%%">otro servidor web</a> o active el servidor proxy inverso en la <a href="%%servicesUrl%%">página de administración de servicios</a>.',
    'web-app-firewall.nginxIsIncompatible' => 'Es posible que no se pueda seleccionar otra versión de ModSecurity en algunas opciones. Por ejemplo, no puede usar expresiones regulares para desactivar reglas de seguridad con ModSecurity3. Compruebe que su configuración funciona correctamente tras haber aplicado los cambios. Otra opción es restablecer la configuración que desactiva las reglas de seguridad a los valores predeterminados.',
    'web-app-firewall.nginxResetCustomizations' => 'Restablezca la configuración de los dominios y del servidor que desactivan las reglas de seguridad a los valores predeterminados.',
    'web-app-firewall.ruleSetUpdate' => 'Actualizar conjuntos de reglas',
    'web-app-firewall.ruleSetUpdateDaily' => 'Diariamente',
    'web-app-firewall.ruleSetUpdateWeekly' => 'Semanalmente',
    'web-app-firewall.ruleSetUpdateMonthly' => 'Mensualmente',
    'web-app-firewall.currentRuleSet' => 'Conjunto de reglas',
    'web-app-firewall.currentRuleSetValue' => '%%ruleSet%% %%changeRuleSetLink%%',
    'web-app-firewall.currentRuleSetRunningOn' => '%%ruleSet%% ejecutándose en %%webServer%%',
    'web-app-firewall.changeRuleSetLink' => 'Cambiar conjunto de reglas',
    'web-app-firewall.ruleSetRollbackFailed' => 'No se pudo utilizar el conjunto de reglas actual de ModSecurity ni revertir a la versión anterior porque este contiene reglas que no son válidas.',
    'web-app-firewall.configurationSection' => 'Configuración',
    'web-app-firewall.configurationSectionHint' => 'Configure el firewall para aplicaciones web usando un conjunto predefinido de parámetros o sus directivas personalizadas de ModSecurity.',
    'web-app-firewall.configPreset' => 'Conjunto predefinido de valores',
    'web-app-firewall.configPresetFast' => 'Rápido',
    'web-app-firewall.configPresetFastDescription' => 'Se analizarán la URI de la petición HTTP y partes de los encabezados.',
    'web-app-firewall.configPresetTradeOff' => 'Equilibrado',
    'web-app-firewall.configPresetTradeOffDescription' => 'Se analizará la URI de la petición HTTP, los encabezados y los datos POST de la petición.',
    'web-app-firewall.configPresetThrough' => 'Exhaustivo',
    'web-app-firewall.configPresetThroughDescription' => 'Se analizarán de forma completa los encabezados de la petición HTTP así como los datos POST de la petición y el contenido del cuerpo de la respuesta HTTP.',
    'web-app-firewall.configCustom' => 'Directivas personalizadas',
    'web-app-firewall.configCustomDescription' => "Introduzca aquí una directiva para ModSecurity. Esta sobrescribirá las directivas especificadas anteriormente (conjuntos de reglas, reglas específicas, el conjunto de valores predefinido, etc.).\nPor ejemplo: SecDebugLogLevel 6",
    'web-app-firewall.configCustomError' => 'La configuración de ModSecurity no es válida: %%error%%',
    'web-app-firewall.configRollbackFailed' => 'No se pudo utilizar el archivo de configuración actual de ModSecurity ni revertir a la versión anterior del archivo porque este contiene una configuración que no es válida.',
    'web-app-firewall.rulesSection' => 'Desactivación de reglas de seguridad',
    'web-app-firewall.rulesSectionHint' => 'Aquí puede desactivar reglas de seguridad. Esto resulta útil si descubre que una determinada regla de seguridad es demasiado restrictiva para algunos sitios web. Si desea desactivar reglas de seguridad, especifique sus IDs (por ejemplo, 340003 o 340005-340007), etiquetas (por ejemplo, CVE-2011-4898) o expresiones regulares usadas en mensajes de regla (por ejemplo, XSS).',
    'web-app-firewall.rulesSectionNginxHint' => 'Aquí puede desactivar reglas de seguridad. Esto resulta útil si descubre que una determinada regla de seguridad es demasiado restrictiva para algunos sitios web. Si desea desactivar reglas de seguridad, especifique sus IDs (por ejemplo, 340003 o 340005-340007), etiquetas (por ejemplo, CVE-2011-4898) o mensajes de regla (por ejemplo, Found User-Agent asociado al analizador de seguridad).',
    'web-app-firewall.filterById' => 'IDs de reglas de seguridad',
    'web-app-firewall.filterByIdInvalid' => 'Los siguientes valores no son válidos: %%values%%. El ID de la regla debe estar formado por dígitos o un intervalo de dígitos como 913100, 913105-913107.',
    'web-app-firewall.filterByIdInvalidRanges' => 'Los siguientes rangos no son válidos: %%ranges%%.',
    'web-app-firewall.filterByTag' => 'Etiquetas',
    'web-app-firewall.filterByTagActive' => 'Activas:',
    'web-app-firewall.filterByTagDeactivated' => 'Desactivadas:',
    'web-app-firewall.filterByTagInvalid' => 'Los siguientes valores seleccionados no son válidos: %%values%%.',
    'web-app-firewall.filterByRegexp' => 'Expresiones regulares en mensajes de regla',
    'web-app-firewall.filterByRegexpInvalid' => 'Los siguientes valores no son válidos: %%values%%. Estos no deberían incluir caracteres \', ".',
    'web-app-firewall.filterByRegexpNginx' => 'Mensajes de regla',
    'web-app-firewall.filterByRegexpNginxHint' => 'Solo se soportan coincidencias estrictas.',
    'web-app-firewall.filterByRegexpNginxInvalid' => 'Los siguientes valores no son válidos: %%values%%. El mensaje de regla debe estar formado por letras, dígitos, espacios o caracteres -:;.,!?#&$%*()/.',
    'web-app-firewall.auditLogSection' => 'Registro de auditoría de ModSecurity',
    'web-app-firewall.auditLogHint1' => 'El archivo de registro de auditoría de ModSecurity es la información más útil en el sistema. Cuando ModSecurity detecta que se está produciendo cualquier evento, este genera una entrada en el archivo de registro de auditoría.',
    'web-app-firewall.auditLogHint2' => 'Un sitio web puede dejar de funcionar tal y como era de esperar una vez cambiado el modo del firewall para aplicaciones web de Activado a Desactivado o Solo detección. En este caso, examine el registro de auditoría de ModSecurity para ver lo que está sucediendo. Puede desactivar reglas de seguridad que sean demasiado restrictivas o ajustar el sitio web.',
    'web-app-firewall.auditLogHint3' => 'Para descubrir el motivo por el que la petición HTTP no pudo completarse para un sitio web:',
    'web-app-firewall.auditLogPoint1' => 'Haga clic en el enlace Archivo de registro de ModSecurity que aparece a continuación y abra el registro de auditoría en una ventana nueva del navegador.',
    'web-app-firewall.auditLogPoint2' => 'Use la combinación de teclas de búsqueda (Ctrl+F en la mayoría de navegadores web) para encontrar los eventos del sitio web (el nombre de dominio) que experimentan problemas. Por ejemplo, your_domain.tld. El navegador destacará entradas como HOST: your_domain.tld.',
    'web-app-firewall.auditLogPoint3' => 'En las tres líneas anteriores a la entrada destacada, busque una cadena de texto como --eece5138-B--. Los ocho símbolos que aparecen entre guiones (en nuestro ejemplo, eece5138) es el ID del evento desencadenado por la petición HTTP.',
    'web-app-firewall.auditLogPoint4' => 'Busque otras entradas con el mismo ID de evento. Busque cualquier entrada con la letra H detrás del ID del evento (en nuestro ejemplo, eece5138-H--). Esta entrada contiene el ID y la descripción de la regla de seguridad desencadenada durante la comprobación de la petición HTTP. El ID de la regla de seguridad es un número entero que empieza por 3, que está entrecomillado y que presenta el ID de prefijo entre corchetes. Por ejemplo, [id "340003"].',
    'web-app-firewall.auditLogPoint5' => 'En el evento, busque el ID de la regla de seguridad usando una subcadena [id "3.',
    'web-app-firewall.auditLogPoint6' => 'Desactive la regla de seguridad con este ID en la sección de reglas de seguridad que puede ver a continuación: introduzca el ID de la regla de seguridad (solo los dígitos) en el campo de IDs de reglas de seguridad y haga clic en ACEPTAR.',
    'web-app-firewall.auditLogViewLink' => 'Archivo de registro de ModSecurity',
    'web-app-firewall.auditLogListLink' => 'Archivo comprimido de registros',
    'web-app-firewall.errorLogSection' => 'Registro de errores',
    'web-app-firewall.errorLogSectionHint' => 'Un sitio web puede dejar de funcionar tal y como era de esperar una vez cambiado el modo del firewall para aplicaciones web de Activado a Desactivado o Solo detección. En este caso, examine el registro de errores para ver lo que está sucediendo. Puede desactivar reglas de seguridad que sean demasiado restrictivas o ajustar el sitio web.',
    'web-app-firewall.errorLogViewLink' => 'Archivo de registro de errores',
    'web-app-firewall.notificationStateEnabled' => 'Las notificaciones de la IU de Plesk sobre actualizaciones de conjuntos de reglas están activadas. %%notificationLink%%',
    'web-app-firewall.notificationStateDisabled' => 'Las notificaciones de la IU de Plesk sobre actualizaciones de conjuntos de reglas están desactivadas.%%notificationLink%%',
    'web-app-firewall.notificationLink' => 'Gestiónelas en la página de notificaciones',
    'web-app-firewall.tradeoffAndThoroughModeWarning' => 'La selección de las opciones "Equilibrado" o "Exhaustivo" puede ocasionar un mal funcionamiento de los sitios WordPress, entre otros efectos colaterales no deseados, debido a la siguiente <a href="https://github.com/SpiderLabs/ModSecurity/issues/562" target="_blank">incidencia de ModSecurity</a>.',
];