<?php
// Copyright 1999-2022. Plesk International GmbH. All rights reserved.
$messages = [
    'app.instances.title' => 'インストール済みアプリケーション',
    'app.instances.buttonCheckForUpdates' => 'アップデートの確認',
    'app.instances.buttonScan' => 'スキャン',
    'app.instances.hintButtonScan' => 'アプリケーション用の契約でファイルをスキャンします。',
    'app.instances.taskScan' => 'アプリケーションをスキャン中...',
    'app.instances.undefinedApp' => '未定義',
    'app.instances.name' => '名前',
    'app.instances.installedTo' => 'インストールパス',
    'app.instances.uninstall' => '削除',
    'app.instances.update' => '更新が可能です',
    'app.instances.noUpdates' => 'アップデートが見つかりません。すべてのアプリケーションは最新状態です。',
    'app.instances.foundUpdates' => '更新可能：',
    'app.instances.noInstallationUrlAvailable' => 'なし',

    'app.packages.title' => '使用可能なアプリケーション',
    'app.packages.name' => '名前',
    'app.packages.version' => 'バージョン',
    'app.packages.summary' => '概要',
    'app.packages.install' => 'インストール',

    'app.services.title' => '使用可能なサービス',
    'app.services.serviceID' => 'サービス ID',
    'app.services.name' => '名前',
    'app.services.summary' => '概要',
    'app.services.instantiate' => 'インスタンスの作成',

    'app.subserviceinstances.remove' => '削除',
    'app.subserviceinstances.hintRemove' => '選択したサービスインスタンスを削除します。',
    'app.subserviceinstances.confirmOnDelete' => '選択したサービスインスタンスを削除しますか？',
    'app.subserviceinstances.serviceName' => 'サービス名',
    'app.subserviceinstances.userName' => 'ユーザ',

    'contentfiles.name' => '名前',
    'contentfiles.changeDate' => '変更日',
    'contentfiles.size' => 'サイズ',
    'contentfiles.permissions' => 'パーミッション',
    'contentfiles.user' => 'ユーザ',
    'contentfiles.group' => 'グループ',
    'contentfiles.buttonUploadFiles' => 'ファイルをアップロード',
    'contentfiles.buttonUploadDirectory' => 'ディレクトリをアップロード',
    'contentfiles.buttonImportFileViaUrl' => 'URL 経由でファイルをインポート',
    'contentfiles.hintUploadFiles' => '現在のディレクトリにファイルをアップロードします。',
    'contentfiles.buttonDeleteFile' => '削除',
    'contentfiles.hintDeleteFile' => '選択したファイルを削除します。',
    'contentfiles.buttonPurgeFile' => '削除',
    'contentfiles.hintPurgeFile' => '選択したファイルを完全に削除します。',
    'contentfiles.buttonPurgeAll' => 'ごみ箱を空にする',
    'contentfiles.buttonRotationSettings' => 'ローテーション設定',
    'contentfiles.hintRotationSettings' => 'ローテーション設定をカスタマイズ',
    'contentfiles.hintPurgeAll' => 'ごみ箱からすべてのファイルとディレクトリを完全に削除しますか？',
    'contentfiles.buttonCopyFiles' => 'コピー',
    'contentfiles.hintCopyFiles' => '選択したファイルを別のディレクトリにコピーします。',
    'contentfiles.buttonMoveFiles' => '移動',
    'contentfiles.hintMoveFiles' => '選択したファイルを別のディレクトリに移動します。',
    'contentfiles.buttonMoreActions' => 'その他',
    'contentfiles.buttonCalculateSize' => 'サイズ計算',
    'contentfiles.hintCalculateSize' => '選択したファイルの合計サイズを計算します。',
    'contentfiles.buttonChangeTimestamp' => 'タイムスタンプを変更',
    'contentfiles.hintChangeTimestamp' => '選択したファイルのタイムスタンプを変更します。',
    'contentfiles.buttonArchiveActions' => 'アーカイブ',
    'contentfiles.buttonExtractArchive' => 'ファイルを展開',
    'contentfiles.hintExtractArchive' => '選択したアーカイブから現在のディレクトリにファイルを抽出します。',
    'contentfiles.buttonCreateArchive' => 'アーカイブに追加',
    'contentfiles.hintCreateArchive' => '選択したファイルをアーカイブに追加します。',
    'contentfiles.buttonNewActions' => '新規',
    'contentfiles.buttonNewFile' => 'ファイルを作成',
    'contentfiles.hintNewFile' => 'ファイルを作成します。',
    'contentfiles.buttonNewDirectory' => 'ディレクトリを作成',
    'contentfiles.hintNewDirectory' => 'ディレクトリを作成します。',
    'contentfiles.rootDirectory' => 'ホームディレクトリ',
    'contentfiles.buttonView' => 'オプションを表示',
    'contentfiles.hintView' => 'ファイルマネージャ設定を変更します。',
    'contentfiles.confirmOnDelete' => '{count, plural, =1 {{name}} one {# 件の選択されたファイルとディレクトリ} other {# 件の選択されたファイルとディレクトリ}}を完全に削除してよろしいですか？',
    'contentfiles.confirmOnDeleteToTrash' => '{count, plural, =1 {{name}} one {# 件の選択されたファイルとディレクトリ} other {# 件の選択されたファイルとディレクトリ}}をごみ箱に移動しますか？',
    'contentfiles.deleteWithForce' => 'ごみ箱をスキップして、{count, plural, =1 {{name}} one {# 件の選択されたファイルとディレクトリ} other {# 件の選択されたファイルとディレクトリ}}を完全に削除します。',
    'contentfiles.confirmOnPurge' => '{count, plural, =1 {{name}} one {# 件の選択されたファイルとディレクトリ} other {# 件の選択されたファイルとディレクトリ}}を完全に削除しますか？',
    'contentfiles.confirmOnPurgeAll' => 'ごみ箱からすべてのファイルとディレクトリを完全に削除しますか？',
    'contentfiles.waitMessage' => 'お待ちください...',
    'contentfiles.readonlyHint' => 'このディレクトリは読取専用です。ファイルまたはディレクトリの作成はできません。',
    'contentfiles.directoryNotFound' => 'ディレクトリ %%directory%% が見つかりません。%%error%%',
    'contentfiles.symlinksOutOfWebspaceProhibited' => 'ウェブスペース外のシンボリックリンク %%symlink%% は禁止されています。%%error%%',
    'contentfiles.dragAndDropArea' => 'ここにディレクトリまたはファイルをドロップするとアップロードされます',
    'contentfiles.nonUTF8' => 'ファイルマネージャでは、名前に非 UTF-8 文字が含まれるファイルやディレクトリを開けません。',
    'contentfiles.non4ByteChar' => '名前に 4 バイト文字が含まれるファイルやディレクトリをファイルマネージャで開くことはできません。',
    'contentfiles.searchInFilename' => 'ファイル名を検索',
    'contentfiles.searchInFilenameAndContent' => 'ファイル名とコンテキスト内を検索',
    'contentfiles.searchInContent' => 'コンテキスト内を検索',
    'contentfiles.menuItemFilename' => 'ファイル名のみ',
    'contentfiles.menuItemFilenameAndContent' => 'ファイル名とコンテンツ',
    'contentfiles.menuItemContent' => 'コンテンツのみ',
    'contentfiles.noEntriesFound' => 'アイテムが見つかりません',
    'contentfiles.loadingTitle' => '検索中...',
    'contentfiles.searchError' => '現在のディレクトリではファイルを検索できません。',
    'contentfiles.searchErrorTimeout' => '検索に時間がかかり過ぎたためキャンセルされました。',
    'contentfiles.item-action-view' => '表示',
    'contentfiles.item-action-textCodeEditor' => 'コードエディタで編集',
    'contentfiles.item-action-visualEdit' => 'HTML エディタで編集',
    'contentfiles.item-action-textEdit' => 'テキストエディタで編集',
    'contentfiles.item-action-browse' => 'ブラウザで開く',
    'contentfiles.item-action-logBrowser' => 'ログブラウザで開く',
    'contentfiles.item-action-download' => 'ダウンロード',
    'contentfiles.item-action-permissions' => 'パーミッション変更',
    'contentfiles.item-action-rename' => '名前変更',
    'contentfiles.item-action-extractArchive' => 'ファイルを抽出',
    'contentfiles.item-action-imageView' => '表示',
    'contentfiles.imageViewer' => '画像ビューア',
    'contentfiles.tooltipReadOnly' => '現在のディレクトリは読取専用です。ファイルまたはディレクトリの作成はできません。',

    'database.issues.type' => 'タイプ',
    'database.issues.table' => 'テーブル',
    'database.issues.code' => 'コード',
    'database.issues.problem' => '問題',
    'database.issues.icon-title-att' => '警告',
    'database.issues.icon-title-warning' => 'エラー',

    'database.users.login' => '名前',
    'database.users.server' => 'データベースサーバ',
    'database.users.database' => 'データベース',
    'database.users.remove' => '削除',
    'database.users.hintRemove' => '選択したデータベースユーザを削除しますか？',
    'database.users.confirmOnDelete' => '{count, plural, =1 {データベースユーザ {login} } other {# 件の選択されたデータベースユーザ}}を削除してよろしいですか？',
    'database.users.disabledSelectHint' => 'インストールされたウェブアプリケーションで使用',
    'database.users.orphanedHint' => '復元プロセス後に孤立しました。ユーザを%%orphanedRepairLink%%する必要があります。',
    'database.users.orphanedRepairLink' => '修復',
    'database.users.anyDatabase' => 'すべてのデータベース',
    'database.users.serverTypeMysql' => 'MySQL',
    'database.users.serverTypeMariadb' => 'MariaDB',
    'database.users.serverTypePercona' => 'Percona',
    'database.users.serverTypePostgresql' => 'PostgreSQL',
    'database.users.serverTypeMssql' => 'MS SQL',

    'databases.assignToSubscription' => '契約に移動',
    'databases.assignToSubscription_powerUser' => 'ウェブスペースに移動',
    'databases.assignToSubscriptionPopupTitle' => 'データベースを別の契約に移動',
    'databases.assignToSubscriptionPopupTitle_powerUser' => 'データベースを別のウェブスペースに移動',
    'databases.assignToSubscriptionPopupDesc' => '選択したデータベースが、選択した契約に移動されます。他のデータベースへのアクセス権を持たない限り、データベースユーザも移動されます。',
    'databases.assignToSubscriptionPopupDesc_powerUser' => '選択したデータベースが、選択したウェブスペースに移動されます。他のデータベースへのアクセス権を持たない限り、データベースユーザも移動されます。移動後、以前のユーザは Plesk 内のリンクを使用してデータベースを開き、その内容を管理できなくなります。',
    'databases.loading' => 'ロード中...',
    'databases.name' => '名前',
    'databases.type' => 'T',
    'databases.server' => 'データベースサーバ',
    'databases.users' => 'ユーザ',
    'databases.remove' => '削除',
    'databases.hintRemove' => '選択したデータベースを削除します。',
    'databases.confirmOnDelete' => '{count, plural, =1 {データベース {name} } other {# 件の選択されたデータベース}}を削除してよろしいですか？',
    'databases.typeMysql' => 'MySQL',
    'databases.typeMariadb' => 'MariaDB',
    'databases.typePercona' => 'Percona',
    'databases.typePostgresql' => 'PostgreSQL',
    'databases.typeMssql' => 'MS SQL サーバ',
    'databases.serverMysql' => 'ローカル MySQL サーバ',
    'databases.serverPostgresql' => 'ローカル PostgreSQL サーバ',
    'databases.serverMssql' => 'ローカル MS SQL サーバ',
    'databases.disabledSelectHint' => 'インストールされたウェブアプリケーションで使用',
    'databases.buttonMakeCopy' => 'コピー',
    'databases.buttonMakeCopyHint' => 'データベースの完全なコピーを作成するか、データベースのコンテンツを既存データベースにコピーします。',
    'databases.buttonWebadmin' => 'Webadmin',
    'databases.buttonWebadminHint' => 'ウェブインターフェースを使用してデータベースを管理します。',
    'databases.buttonConnectionInfo' => '接続情報',
    'databases.buttonConnectionInfoHint' => 'ホスト名やデータベースユーザのクレデンシャルなど、このデータベースへの接続に必要となる情報です。',
    'databases.buttonPhpMyAdmin' => 'PhpMyAdmin',
    'databases.buttonMyLittleAdmin' => 'myLittleAdmin',
    'databases.buttonDownloadDump' => 'ダンプをエクスポート',
    'databases.buttonDownloadDumpHint' => 'このデータベースのコピーをエクスポートします。',
    'databases.buttonUploadDump' => 'ダンプをインポート',
    'databases.buttonUploadDumpHint' => 'このデータベースのコピーをインポートします。',
    'databases.buttonDelete' => 'データベースを削除',
    'databases.buttonDeleteHint' => 'このデータベースを削除します。',
    'databases.buttonDeleteDisabledHint' => 'データベースを削除できません。インストールされたウェブアプリケーションで使用されています。',
    'databases.buttonDeleteConfirmationText' => 'データベース %%name%% を削除してよろしいですか？',
    'databases.buttonActiveList' => 'アクティブリスト',
    'databases.buttonActiveListHint' => '表示モードを切り替えます。',
    'databases.buttonCheckAndFix' => 'チェックして修復',
    'databases.buttonCheckAndFixHint' => 'テーブル構造の破損などの問題をチェックし、修復します。',
    'databases.buttonAssignToSubscription' => '契約に移動',
    'databases.buttonAssignToSubscriptionHint' => 'データベースを別の契約に移動します。',
    'databases.buttonAssignToSubscription_powerUser' => 'ウェブスペースに移動',
    'databases.buttonAssignToSubscriptionHint_powerUser' => 'データベースを別のウェブスペースに移動します。',
    'databases.promptPassword' => 'データベースユーザ %%login%% としてログインするには、パスワードを入力してください。',
    'databases.promptPasswordPopupTitle' => 'パスワードを入力',
    'databases.taskCheckDatabase' => 'データベースをチェック',
    'databases.taskRepairDatabase' => 'データベースを修復',
    'databases.downloadTask' => '%%database%% ダンプをエクスポート用に準備中...',
    'databases.downloadPopupTitle' => 'ダンプをエクスポート',
    'databases.downloadHint' => '%%database%% のダンプを作成し、ダウンロードしようとしています。',
    'databases.downloadRelativePath' => '以下のディレクトリにダンプを保存',
    'databases.downloadDumpName' => 'ファイル名をダンプ',
    'databases.downloadDumpAutomatically' => '作成後にダンプを自動的にダウンロード',
    'databases.errorDumpNameEmpty' => 'ダンプ名を入力してください。',
    'databases.errorDumpNameInvalid' => 'ダンプ名には %%chars%% を使用できません。',
    'databases.errorDumpNameTooLong' => 'ダンプファイル名が長すぎます。ダンプのフルパスは %%maxLength%% 文字以内にする必要があります。',
    'databases.uploadTask' => '%%database%% のダンプをインポート中...',
    'databases.uploadPopupTitle' => 'データベースダンプをインポート',
    'databases.uploadHint' => 'ローカルコンピュータからダンプをアップロードするか、ホスティングサーバに保存したダンプをインポートします。',
    'databases.uploadFromFile' => 'アップロード',
    'databases.uploadFromWebspace' => 'インポート',
    'databases.recreateDatabase' => 'データベースを再作成',
    'databases.uploading' => 'インポート中...',
    'databases.waitMessage' => 'お待ちください...',
    'databases.rootDirectory' => 'ルートディレクトリ',
    'databases.connectionInfoTitle' => '%%database%% の接続情報',
    'databases.connectionInfoDesc' => 'これらの接続情報は、ウェブアプリケーションのインストール時に要求された場合などに使用できます。',
    'databases.connectionInfoServerAddress' => 'ホスト',
    'databases.connectionInfoDatabaseName' => 'データベース名',
    'databases.connectionInfoUserLogin' => 'ユーザ名',
    'databases.connectionInfoUserPassword' => 'パスワード',
    'databases.connectionInfoNoUserLogin' => 'デフォルトユーザ',
    'databases.buttonClose' => '閉じる',
    'databases.nothingFound' => "該当するものが見つかりません",
    'databases.moreObjectsAvailable' => 'この他に %%count%% オブジェクトがあります。',

    'dnsaclrecords.value' => 'IP アドレス',
    'dnsaclrecords.add' => 'IP アドレスを追加',
    'dnsaclrecords.remove' => '削除',
    'dnsaclrecords.hintRemove' => '選択した IP アドレスを削除します。',
    'dnsaclrecords.confirmOnDelete' => '選択した IP アドレスを削除しますか？',
    'dnsaclrecords.emptyViewTitle' => 'ゾーン転送は許可されません',
    'dnsaclrecords.emptyViewDescription1' => 'セキュリティ上の理由から、DNS ゾーンの転送が許可されるのは、ゾーンの NS レコードに指定されているサーバへのみです。',
    'dnsaclrecords.emptyViewDescription2' => '転送先として許可するサーバを 1 つ以上指定するには、［IP アドレスを追加］をクリックします。',

    'dnsrecords.host' => 'ホスト',
    'dnsrecords.type' => 'レコードタイプ',
    'dnsrecords.value' => '値',
    'dnsrecords.nameServer' => 'ネームサーバ',
    'dnsrecords.ipAddress' => 'IP アドレス',
    'dnsrecords.ttl' => 'TTL',
    'dnsrecords.buttonCheckHint' => 'ネームサーバで DNS ゾーンをテストします。',
    'dnsrecords.remove' => '削除',
    'dnsrecords.removeRecord' => '%%selectedRowTitle%% を削除しますか？このアクションを取り消すことはできません。',
    'dnsrecords.removeRecords' => '%%selectedRows%% レコードを削除しますか？このアクションを取り消すことはできません。',
    'dnsrecords.hintRemove' => '選択した DNS レコードを削除しますか？',
    'dnsrecords.confirmOnDelete' => '{count, plural, =1 {DNS レコード {host} } one {# 件の選択された DNS レコード} other {# 件の選択された DNS レコード}}を削除してよろしいですか？',
    'dnsrecords.turnOff' => '無効化',
    'dnsrecords.hintTurnOff' => 'DNS ゾーン %%name%% に対してローカル DNS サービスをオフにする',
    'dnsrecords.turnOn' => '有効化',
    'dnsrecords.hintTurnOn' => 'DNS ゾーン %%name%% に対してローカル DNS サービスをオンにする',
    'dnsrecords.toggleTypeToSlave' => 'スレーブに切り替える',
    'dnsrecords.toggleTypeToMaster' => 'マスターに切り替える',
    'dnsrecords.hintToggleTypeToMaster' => 'ゾーン %%name%% に対し、このサーバをマスターネームサーバとして機能させます。',
    'dnsrecords.hintToggleTypeToSlave' => 'DNS ゾーン %%name%% サービスモードをスレーブに切り替えます。',
    'dnsrecords.hintToggleTypeDisabled' => 'DNS ゾーンサービスモードを切り替えることができません。DNS ゾーン %%name%% は別のサーバによって管理されています。',
    'dnsrecords.addRecord' => 'レコードを追加',
    'dnsrecords.hintSpecifyNameServer' => '%%name%% の新規ネームサーバを指定',
    'dnsrecords.hintAddPrimaryDns' => '%%name%% のプライマリ DNS サーバを追加',
    'dnsrecords.hintAddRecord' => 'DNS ゾーン %%name%% にリソースレコードを作成',
    'dnsrecords.restoreDefault' => 'デフォルトにリセット',
    'dnsrecords.hintRestoreDefault' => 'サーバ全体の DNS テンプレートに従って DNS ゾーンを再作成します。カスタムリソースレコードがすべて削除され、ユーザがゾーンに対して行った変更がすべて失われます。',
    'dnsrecords.syncZone' => 'DNS テンプレートを適用',
    'dnsrecords.hintSyncZone' => 'サーバ全体の DNS テンプレートに対して行われた変更をゾーンに適用します。新しいリソースレコードが追加され、既存のレコードが削除される可能性があります。ユーザが追加または編集したリソースレコードは影響を受けません。',
    'dnsrecords.applyChanges' => 'DNS レコードに加えた変更がまだ保存されていません。変更は、レコードリスト内でマークが付いています。［更新］をクリックすると、DNS ゾーンに変更が適用されます。［戻す］をクリックすると、変更がキャンセルされます。',
    'dnsrecords.updateButtonTitle' => '更新',
    'dnsrecords.updateButtonDescription' => 'DNS レコードに加えた変更を保存します。',
    'dnsrecords.revertButtonTitle' => '戻す',
    'dnsrecords.revertButtonDescription' => 'DNS レコードに加えた変更をキャンセルします。',
    'dnsrecords.syncZoneFrom' => 'DNS テンプレートの変更を適用',
    'dnsrecords.moreActions' => 'その他のアクション',
    'dnsrecords.search' => '検索...',
    'dnsrecords.templateNotSynchronized' => 'DNS ゾーンテンプレートは変更されました。新規作成されるすべてのドメインに適用されます。%%link%%ことも可能です',
    'dnsrecords.templateNotSynchronizedLinkText' => 'ホストされているすべてのドメインに変更を適用する',
    'dnsrecords.soaTemplateNotSynchronized' => 'SOA テンプレートは変更されました。新規作成されるすべてのドメインに適用されます。%%link%%ことも可能です',

    'emails.name' => 'メールアドレス',
    'emails.owner' => 'ユーザ',
    'emails.remove' => '削除',
    'emails.addNewEmail' => 'メールアドレスを作成',
    'emails.hintAddNewEmail' => 'メールアドレスを作成してユーザに割り当てます。',
    'emails.recalculateUsage' => '使用量統計を更新',
    'emails.hintRecalculateUsage' => 'メールボックスで使用される実際のディスク容量を再計算します。',
    'emails.outgoingSpamSettings' => '送信メッセージの上限',
    'emails.hintOutgoingSpamSettings' => '選択したメールボックスに対し、送信メッセージ数の上限を設定します。各メールボックスから、指定上限を超えてメッセージを送信することはできなくなります。',
    'emails.searchByEmail' => 'メールアドレス',
    'emails.hintRemove' => '選択したメールアドレスを削除します。',
    'emails.webMailDisabledHint' => 'ウェブメールのソフトウェアがインストールされていません',
    'emails.webMailHint' => '新しいブラウザウィンドウでこのメールアドレスのウェブメールを開きます。',
    'emails.editHint' => 'メールクライアントプログラム（Microsoft Outlook、Outlook Express、Thunderbird、Apple Mail など）でメールアカウントを設定する方法を表示します。',
    'emails.confirmOnDelete' => '{count, plural, =1 {メールアドレス {name} } one {# 件の選択されたメールアドレス} other {# 件の選択されたメールアドレス}}を削除してよろしいですか？',
    'emails.redirectDetailsSingle' => '%%firstAddress%%',
    'emails.redirectDetailsMultiple' => '%%firstAddress%% （さらに %%countLeft%%）',
    'emails.autoresponderEnabled' => '自動応答はオンになっています。',
    'emails.autoresponderEnabledTill' => '自動応答は %%endDate%% までオンになっています。',
    'emails.spaceUsage' => '使用量',
    'emails.noMailbox' => 'メールボックスなし',
    'emails.statusNotOperable' => 'メールサービスはオフになっています。',

    'failedrequestfiles.downloadZip' => 'ZIP をダウンロード',
    'failedrequestfiles.downloadZipHint' => '選択したファイルを ZIP 形式でダウンロードします。',
    'failedrequestfiles.name' => '名前',
    'failedrequestfiles.modificationDate' => '変更日時',
    'failedrequestfiles.remove' => '削除',
    'failedrequestfiles.hintRemove' => '選択されている失敗した要求のファイルを削除します。',
    'failedrequestfiles.confirmOnDelete' => '選択されている失敗した要求のファイルを削除しますか？',
    'failedrequestfiles.viewHint' => '失敗した要求のファイルを表示します。',
    'failedrequestfiles.buttonChangeTracing' => 'トレースオプションを変更',
    'failedrequestfiles.buttonChangeTracingHint' => '現在定義されている失敗した要求トレース設定を変更します。',
    'failedrequestfiles.buttonDisableTracing' => 'トレースを停止',
    'failedrequestfiles.buttonDisableTracingHint' => 'トレースを停止します。',
    'failedrequestfiles.buttonEnableTracing' => 'トレースを開始',
    'failedrequestfiles.buttonEnableTracingHint' => 'トレースを開始します。',
    'failedrequestfiles.buttonRefresh' => '更新',
    'failedrequestfiles.buttonRefreshHint' => '指定された条件を満たす失敗した要求をすべて表示するには、ここをクリックします。新しくロギングされた失敗した要求は自動的に表示されません。',

    'files.name' => '名前',
    'files.modificationDate' => '変更日',
    'files.size' => 'サイズ',
    'files.share' => '共有',
    'files.shareHint' => '選択したファイルを共有ファイルフォルダに移動し、Plesk で許可されているすべての従業員がアクセスできるようにします。',
    'files.publish' => '公開',
    'files.publishHint' => '選択したファイルをパブリックファイルフォルダに移動して、顧客とウェブサイト訪問者に対して公的にアクセス可能にします。 これらのファイルへのアクセスをパスワードで保護することができます。',
    'files.email' => 'メールリンク',
    'files.emailHint' => '選択したファイルへのアクセス用のリンクを同僚や顧客にメール送信します。',
    'files.delete' => '削除',
    'files.deleteHint' => '選択したファイルの削除',
    'files.moreActions' => 'その他',
    'files.createFolder' => '新しいフォルダ',
    'files.createFolderHint' => '現在のフォルダにフォルダを作成',
    'files.copy' => 'コピー',
    'files.copyHint' => '選択したファイルまたはフォルダを選択した宛先にコピーします。',
    'files.move' => '移動',
    'files.moveHint' => '選択したファイルまたはフォルダを選択した宛先に移動します。',
    'files.protectedDescription' => 'このファイル内のファイルへのアクセスはパスワード保護されています。 これらのファイルへアクセスするには、このパスワードを入力する必要があります。',
    'files.nothingSelected' => 'ファイルまたはフォルダが選択されていません',

    'gitrepositories.lastCommitInfo' => '最終コミット情報：',
    'gitrepositories.deploymentActions' => '追加デプロイメントアクション：',

    'logfiles.name' => '名前',
    'logfiles.path' => 'パス',
    'logfiles.modificationDate' => '変更日時',
    'logfiles.fileSize' => 'サイズ',
    'logfiles.logRotation' => 'ログローテーション',
    'logfiles.logRotationHint' => 'ウェブサイトのログローテーションをセットアップします。',
    'logfiles.logRotationTitle' => 'ログローテーションの構成',
    'logfiles.remove' => '削除',
    'logfiles.hintRemove' => '選択したログファイルを削除します。処理したログファイルのみを削除できます。',
    'logfiles.confirmOnDelete' => '選択したログファイルを削除しますか？',
    'logfiles.viewHint' => 'ログファイルを表示します。',
    'logfiles.buttonDownloadHint' => 'ログファイルをダウンロードします。',
    'logfiles.buttonViewHint' => 'ログファイルを新しいウィンドウに表示します。',
    'logfiles.addCustomLog' => 'カスタムログを追加',
    'logfiles.addCustomLogHint' => 'ログブラウザですべてのファイルを開く',
    'logfiles.customLogPopupTitle' => 'カスタムログを追加',
    'logfiles.invalidLogFormat' => 'サポートされない形式のログファイルです。',
    'logfiles.buttonUnlinkHint' => 'ログブラウザでこのファイルの更新状況の追跡を終了するには、こちらをクリックしてください。',
    'logfiles.buttonUnlinkConfirmationDescription' => 'ログブラウザでこのファイルの更新状況の追跡を終了しますか？',
    'logfiles.buttonUnlinkConfirmationYes' => 'はい',
    'logfiles.buttonUnlinkConfirmationNo' => 'いいえ',
    'logfiles.accessLog' => 'Apache アクセス',
    'logfiles.accessLogProcessed' => 'Apache アクセス（ローテーション）',
    'logfiles.accessSslLog' => 'Apache SSL/TLS アクセス',
    'logfiles.accessSslLogProcessed' => 'Apache SSL/TLS アクセス（ローテーション）',
    'logfiles.errorLog' => 'Apache エラー',
    'logfiles.proxyAccessLog' => 'nginx アクセス',
    'logfiles.proxyAccessSslLog' => 'nginx SSL/TLS アクセス',
    'logfiles.proxyErrorLog' => 'nginx エラー',
    'logfiles.phpErrorLog' => 'PHP エラー',
    'logfiles.iisAccessLog' => 'IIS アクセス',
    'logfiles.iisLog' => 'IIS（%%name%%）',
    'logfiles.audit' => 'ModSecurity',
    'logfiles.passenger' => 'Node.js',
    'logfiles.iisnode' => 'Node.js',
    'logfiles.laravel' => 'Laravel',
    'logfiles.dotnetcore' => '.NET Core',

    'maillists.title' => 'メーリングリスト',
    'maillists.remove' => '削除',
    'maillists.name' => 'アドレス',
    'maillists.subscribers' => 'ML メンバー',
    'maillists.hintRemove' => '選択したメーリングリストを削除します。',
    'maillists.confirmOnDelete' => '選択したメーリングリストを削除しますか？',
    'maillists.openWebPanel' => 'リスト管理',
    'maillists.statusNotEnabled' => 'オフ',
    'maillists.statusNotOperable' => 'メーリングリストサービスがオフになっています。',

    'mailsettings.name' => 'ドメイン名',
    'mailsettings.mailService' => 'メールサービス',
    'mailsettings.webmail' => 'ウェブメール',
    'mailsettings.nonexist' => '存在しないユーザ宛てに送信されたメール',
    'mailsettings.webmailNone' => 'なし',
    'mailsettings.nonExistBounce' => 'メッセージ付きでバウンス',
    'mailsettings.nonExistCatch' => '%%catchAddress%% に転送',
    'mailsettings.nonExistCatchDescription' => 'アドレスは、選択したドメインに属している必要があります。外部アドレスを指定したり、複数ドメインに 1 つのアドレスを指定できるのは、管理者のみです',
    'mailsettings.nonExistExternal' => '%%catchIp%% へリダイレクト',
    'mailsettings.nonExistReject' => '拒否',
    'mailsettings.nonExistDiscard' => '拒否',
    'mailsettings.statusEnabled' => 'オン',
    'mailsettings.statusDisabled' => 'オフ',
    'mailsettings.searchByName' => 'ドメイン名',
    'mailsettings.editOutgoingSpamSettings' => '上限を編集',
    'mailsettings.numberOutgoingMessages' => '送信メッセージ数',

    'roles.title' => 'ユーザ役割',
    'roles.name' => '役割名',
    'roles.description' => '説明',
    'roles.remove' => '削除',
    'roles.numberOfUsers' => 'ユーザ',
    'roles.hintRemove' => '選択したユーザ役割を削除します。 役割は別のユーザアカウントに割り当てられていない場合にのみ削除できます。',
    'roles.disabledSelectHint' => 'この役割はユーザアカウントに割り当て済みです。 役割は、どのユーザアカウントにも割り当てられていない場合にのみ削除できます。',
    'roles.builtInItemHint' => 'この役割は編集または削除できません',
    'roles.confirmOnDelete' => '選択したユーザ役割を削除しますか？',

    'sites.selectdns.domain' => 'ドメイン',
    'sites.selectdns.dnsStatus' => 'ステータス',
    'sites.selectdns.statusOff' => 'DNS ゾーン管理はオフになっています。',
    'sites.selectdns.statusMaster' => 'DNS ゾーンはマスターモードです',
    'sites.selectdns.statusSlave' => 'DNS ゾーンはスレーブモードです',
    'sites.selectdns.linkManage' => '管理',

    'sites.selectfrontpage.domain' => 'ドメイン',
    'sites.selectfrontpage.linkManage' => '管理',

    'sites.selectsimple.domain' => 'ドメイン',
    'sites.selectsimple.linkManage' => '管理',
    'sites.selectsimple.linkView' => '表示',

    'sites.selectstatistics.domain' => 'ドメイン',
    'sites.selectstatistics.linkView' => '表示',

    'sites.selecttrafficstatistics.domain' => 'ドメイン',
    'sites.selecttrafficstatistics.linkView' => '表示',

    'sites.selectwebdeploy.domain' => 'ドメイン',
    'sites.selectwebdeploy.linkDownload' => 'ダウンロード',

    'sites.unitymobile.website' => 'ウェブサイト',
    'sites.unitymobile.mobileSite' => 'モバイルサイト名',
    'sites.unitymobile.createSite' => 'モバイルサイトを作成',
    'sites.unitymobile.launchEditor' => 'サイトコンテンツを編集する',
    'sites.unitymobile.changeSiteName' => 'サイト名を変更する',
    'sites.unitymobile.delete' => '削除',
    'sites.unitymobile.confirmDeleteTitle' => 'このモバイルサイトを削除しますか？',
    'sites.unitymobile.confirmDeleteDescription' => 'サイトのコンテンツがすべて失われます。',

    'sites.domainHeader' => 'ドメイン',
    'sites.hostingHeader' => 'ホスティング',
    'sites.diskUsage' => 'ディスク使用量',
    'sites.traffic' => 'トラフィック',
    'sites.buttonAddDomain' => 'ドメインを追加',
    'sites.buttonAddDomainHint' => 'このサーバで新規ウェブサイトをホスティングするか、別のサイトへのウェブ転送をセットアップするか、ドメイン DNS ゾーンだけセットアップします（このドメインにメールアドレスしか存在しない場合）。',
    'sites.buttonAddSubdomain' => 'サブドメインを追加',
    'sites.buttonAddSubdomainHint' => 'サードレベルドメイン名のサイトを作成します（例：shop.example.com）',
    'sites.buttonAddDomainAlias' => 'ドメインエイリアスを追加',
    'sites.buttonAddDomainAliasHint' => 'サイトの追加ドメイン名をセットアップします。',
    'sites.buttonRemove' => '削除',
    'sites.buttonRemoveHint' => '選択したサイトとそのウェブコンテンツ（アプリケーションやメールデータを含む）を削除します。',
    'sites.buttonActivate' => 'アクティブ化',
    'sites.buttonSuspend' => '一時停止',
    'sites.buttonClassicList' => 'クラシックリスト',
    'sites.buttonClassicListHint' => '表示モードを切り替えます。',
    'sites.buttonActiveList' => 'アクティブリスト',
    'sites.buttonActiveListHint' => '表示モードを切り替えます。',
    'sites.buttonDynamicList' => '動的リスト',
    'sites.buttonDynamicListHint' => '表示モードを切り替えます。',
    'sites.buttonFileManager' => 'ファイルマネージャ',
    'sites.buttonMail' => 'メール',
    'sites.buttonDatabases' => 'データベース',
    'sites.buttonDatabasesCreate' => 'データベースを追加',
    'sites.buttonDatabasesTogglerText' => 'または',
    'sites.buttonDatabasesToggle' => '既存のデータベースを選択',
    'sites.buttonDatabasesEdit' => '開く',
    'sites.buttonDatabasesPromptPassword' => 'データベースユーザ %%login%% としてログインするには、パスワードを入力してください。',
    'sites.removeConfirmation' => '{count, plural, =1 {サイト {name} } one {# 件の選択されたサイト} other {# 件の選択されたサイト}}を削除してよろしいですか？',
    'sites.removeConfirmationSubscription' => "次のサイトも削除されます：\n%%domains%%",
    'sites.manageFilesHint' => 'ウェブサイトフォルダに進み、ウェブサイトのファイルを管理します。',
    'sites.sitebuilderHint' => 'Presence Builder でサイトを編集します。',
    'sites.sitebuilderOldHint' => 'SiteBuilder 4 または Site Editor でサイトを編集します。',
    'sites.webstatisticsHint' => 'ウェブサイト訪問統計を表示します。',
    'sites.webstatisticsSslHint' => 'SSL/TLS 経由でのウェブサイト訪問データのレポートを表示します。',
    'sites.certificatesHint' => 'SSL/TLS 証明書を管理します。',
    'sites.logsHint' => 'ログを表示します。',
    'sites.previewHint' => 'ブラウザでウェブサイトをプレビューします。',
    'sites.dnsHint' => 'DNS ゾーン設定を変更します。',
    'sites.disabledSelectHint' => 'ドメインを削除できません。',
    'sites.websiteAt' => 'ウェブサイト：',
    'sites.noHosting' => 'ウェブホスティングなし',
    'sites.forwardingTo' => '転送先',
    'sites.add' => '追加',
    'sites.name' => 'ドメイン名',
    'sites.inactive' => '無効',
    'sites.disabled' => '無効',
    'sites.suspended' => '一時停止',
    'sites.moreActions' => 'その他のアクション',
    'sites.domainAliasDescription' => '%%siteDisplayName%% %%servicesDescription%% のエイリアス',
    'sites.domainAliasServiceDescription' => '（アクティブなサービス：%%service%%)',
    'sites.domainAliasServicesDescription' => '（アクティブなサービス：%%services%%)',
    'sites.web' => 'ウェブ',
    'sites.mail' => 'メール',
    'sites.dns' => 'DNS',
    'sites.tomcat' => 'Java アプリケーション',
    'sites.seoRedirect' => 'リダイレクト',
    'sites.sitebuilder' => 'Presence Builder',
    'sites.sitebuilderLegacy' => 'SiteBuilder 4 または Site Editor',
    'sites.sitebuilderLink' => 'ウェブサイトを編集',
    'sites.error503PageLink' => 'エラーページを編集',
    'sites.modeTitle' => '表示モード',
    'sites.quickStart' => 'いずれかの方法でウェブサイトの作成を開始：',
    'sites.quickStartSitebuilderName' => 'Presence Builder を使用',
    'sites.quickStartSitebuilderDescription' => 'サイト作成ツールを使用してサイトを作成します。',
    'sites.quickStartSitebuilderLink' => 'サイト作成',
    'sites.quickStartApplicationsName' => 'アプリケーションをインストール',
    'sites.quickStartApplicationsDescription' => 'ウェブアプリケーション（Joomla 、Drupal など）をインストールしてサイトを作成します。',
    'sites.quickStartApplicationsLink' => 'アプリケーションをインストール',
    'sites.quickStartCustomName' => 'カスタムウェブサイトを作成',
    'sites.quickStartCustomDescription' => 'ウェブコンテンツをアップロードし、データベースを追加します。',
    'sites.quickStartCustomFilesLink' => 'ファイル',
    'sites.quickStartCustomDatabasesLink' => 'データベース',
    'sites.resellerDescription' => 'リセラー',
    'sites.ownerDescription' => '顧客',

    'sslcertificates.name' => '名前',
    'sslcertificates.used' => '使用中',
    'sslcertificates.csrHint' => 'CSR 部分が提供されました。',
    'sslcertificates.noCsrHint' => 'CSR 部分が提供されていません。',
    'sslcertificates.privateKeyHint' => '秘密キー部分が提供されました。',
    'sslcertificates.noPrivateKeyHint' => '秘密キー部分が提供されていません。',
    'sslcertificates.certificateHint' => '証明書部分が提供されました。',
    'sslcertificates.noCertificateHint' => '証明書部分が提供されていません。',
    'sslcertificates.caCertificateHint' => 'CA 証明書部分が提供されました。',
    'sslcertificates.noCaCertificateHint' => 'CA 証明書部分が提供されていません。',
    'sslcertificates.buttonDownloadHint' => 'すべての証明書コンポーネントをダウンロードします。',
    'sslcertificates.webmail' => 'ウェブメールのセキュリティ強化',
    'sslcertificates.hintWebmail' => '選択した SSL/TLS 証明書を使用してドメインのウェブメールをセキュリティ強化します。',
    'sslcertificates.remove' => '削除',
    'sslcertificates.hintRemove' => '選択した SSL/TLS 証明書をドメインリポジトリから削除します。',
    'sslcertificates.confirmOnDelete' => '選択した SSL/TLLS 証明書を削除しますか？',
    'sslcertificates.addCertificate' => 'SSL/TLS 証明書を追加',
    'sslcertificates.hintAddCertificate' => 'SSL/TLS 証明書を追加します。',
    'sslcertificates.viewCertificates' => '証明書を表示',
    'sslcertificates.hintViewCertificates' => 'プロバイダから購入した SSL/TLS 証明書の一覧を表示します。',
    'sslcertificates.webmailCertificate' => 'ウェブメールをセキュリティ強化',
    'sslcertificates.mailCertificate' => 'メールをセキュリティ強化',
    'sslcertificates.mailAndWebmailCertificate' => 'メールとウェブメールの両方をセキュリティ強化',
    'sslcertificates.mail' => 'メールのセキュリティを強化',
    'sslcertificates.hintMail' => '選択された SSL/TLS 証明書を使用してドメインのメールのセキュリティを強化します。',

    'subscriptions.subscription' => '契約',
    'subscriptions.price' => '料金',
    'subscriptions.renewalDate' => '有効期限',
    'subscriptions.setupDate' => 'セットアップ日',
    'subscriptions.domains' => 'ウェブサイト',
    'subscriptions.systemUser' => 'システムユーザ',
    'subscriptions.ipAddress' => 'IP アドレス',
    'subscriptions.addonDomains' => 'アドオンドメイン',
    'subscriptions.diskSpace' => 'ディスクスペース',
    'subscriptions.moreDomains' => '... ドメインがさらに %%count%% 件あり',
    'subscriptions.buy' => '新しい契約の購入',
    'subscriptions.create' => '契約の作成',
    'subscriptions.create_powerUser' => 'ウェブスペースを作成',
    'subscriptions.renew' => '更新',
    'subscriptions.confirmOnCancel' => '契約をキャンセルしますか？',
    'subscriptions.subscriptionSuspended' => '一時停止',
    'subscriptions.myResources' => 'マイ・リソース',
    'subscriptions.planName' => 'サービスプラン',
    'subscriptions.switchToLink' => '契約に切り替え',
    'subscriptions.switchToLinkHint' => 'この契約に切り替えます。',
    'subscriptions.switchToLinkPowerUser' => 'ウェブスペースに切り替える',
    'subscriptions.switchToLinkHintPowerUser' => 'このウェブスペースに切り替えます',
    'subscriptions.buttonRemove' => '削除',
    'subscriptions.buttonRemoveDescription' => '選択したウェブスペースを削除',
    'subscriptions.confirmOnDelete' => '選択したウェブスペースを削除しますか？',
    'subscriptions.buttonAddNew' => 'ウェブスペースを追加',
    'subscriptions.buttonAddNewDescription' => 'ウェブスペースを作成',
    'subscriptions.subscription_powerUser' => 'ウェブスペース',
    'subscriptions.subscriptionPowerUser' => 'ウェブスペース',
    'subscriptions.confirmOnCancel_powerUser' => 'ウェブスペースをキャンセルしますか？',
    'subscriptions.subscriptionSuspended_powerUser' => '一時停止',
    'subscriptions.switchToLink_powerUser' => 'ウェブスペースに切り替える',
    'subscriptions.switchToLinkHint_powerUser' => 'このウェブスペースに切り替えます',
    'subscriptions.primaryDomain' => 'プライマリドメイン',
    'subscriptions.ftpAccess' => 'FTP アクセス',

    'users.contactName' => '担当者名',
    'users.email' => 'メールアドレス',
    'users.role' => '役割',
    'users.contacts' => '連絡先',
    'users.phone' => '電話',
    'users.roleFilter' => 'ユーザ役割',
    'users.filterAnyRole' => 'すべて',
    'users.activate' => 'アクティブ化',
    'users.deactivate' => '一時停止',
    'users.remove' => '削除',
    'users.status' => 'ステータス',
    'users.statusBlocked' => '非アクティブ',
    'users.buttonAddNewUser' => 'ユーザアカウント作成',
    'users.hintAddNewUser' => 'ユーザアカウントを作成します。',
    'users.hintRemove' => '選択したユーザアカウントを削除します。',
    'users.disabledSelectHint' => 'このユーザアカウントは、内蔵されいるか自分のユーザアカウントであるため、削除できません',
    'users.confirmOnDelete' => '選択したユーザアカウントを削除しますか？',

    'webusers.name' => '名前',
    'webusers.add' => 'ウェブユーザを追加',
    'webusers.hintAdd' => 'ウェブユーザアカウントを追加します。%%resourceUsage%%',
    'webusers.settings' => '設定',
    'webusers.hintSettings' => "ウェブユーザの設定",
    'webusers.remove' => '削除',
    'webusers.hintRemove' => '選択したウェブユーザを削除します。',
    'webusers.confirmOnDelete' => '選択したウェブユーザを削除しますか？',
    'webusers.buttonOpenHomepageHint' => "ウェブユーザのホームページをウェブブラウザで表示します。",
];