<?php
// Copyright 1999-2022. Plesk International GmbH. All rights reserved.
$messages = [
    'problem-detail.nginx-upstream-sent-too-big-header.name' => 'Nginx“502无效网关：上游读取响应头时发送了太大的信息头”',
    'problem-detail.nginx-upstream-sent-too-big-header.description' => '快准备好了。',
    'problem-detail.nginx-upstream-sent-too-big-header.cause' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.title' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.text' => '',
    'problem-detail.apache-followsymlinks-not-allowed.name' => 'Apache“500内部服务器错误：此处不允许选项 FollowSymLinks”',
    'problem-detail.apache-followsymlinks-not-allowed.description' => '快准备好了。',
    'problem-detail.apache-followsymlinks-not-allowed.cause' => '',
    'problem-detail.phpfpm-server-reached-max-children.name' => 'PHP-FPM "服务器达到 max_children 设置"',
    'problem-detail.phpfpm-server-reached-max-children.description' => '<h4>症状</h4><ul><li><p>有 PHP 处理程序的网站设置为 <strong>Apache 服务的 FPM 应用程序</strong>或<strong>nginx 服务的 FPM 应用程序</strong>（位于 <strong>域名</strong> &gt; <strong>example.com</strong> &gt;）<strong>PHP 设置</strong>遇到以下当中的一个问题：</p><ul><li><p>加载慢</p></li><li><p>不可访问（永久或定期），web 浏览器中出现50x错误：</p><pre>502 无效网关</pre><hr><pre>503 服务暂时不可用</pre><hr><pre>504 网关超时</pre></li></ul></li><li><p>以下信息出现在 PHP-FPM 错误日志文件<code>/var/log/plesk-php<strong>XX</strong>-fpm/error.log</code>中（其中 <em>XX</em> 是网站使用的 PHP 版本）：</p><pre>警告： [pool example.com] 服务器达到 max_children 设置 (*)，考虑将其提升</pre><ul><li><p>以上信息通常伴随此错误：</p><pre>无法读取子代所说的内容：错误的文件描述符(9)</pre></li></ul></li><li><p>如果在服务器上启用了nginx，则域名的错误日志文件中可能会出现以下错误消息之一 <code>/var/www/vhosts/system/example.com/logs/proxy_error_log</code>:</p><pre style="white-space: pre-wrap;">[error] 11456#0: *118348 connect() to unix:///var/www/vhosts/system/example.com/php-fpm.sock failed (11: 资源临时不可用)，连接上游时，客户端：203.0.113.2，服务器：example.com，请求： "GET / HTTP/1.1"，上游："fastcgi://unix:///var/www/vhosts/system/example.com/php-fpm.sock:"，主机："example.com"</pre><hr><pre style="white-space: pre-wrap;">[error] 20058#0: *4725139 从上游读取响应头时，上游连接过早关闭连接，客户端：203.0.113.2，服务器：example.com，请求："POST /path/to/some/file HTTP/2.0"，上游：</pre></li></ul>',
    'problem-detail.phpfpm-server-reached-max-children.cause' => ' <p>网站已达到 PHP-FPM <code>pm.max_children</code>。</p>',
    'problem-detail.phpfpm-server-reached-max-children.solution1.title' => '增加 pm.max_children 限制',
    'problem-detail.phpfpm-server-reached-max-children.solution1.text' => '<p>提高受影响的域名的 <code>pm.max_children</code> 限制：</p><ol><li><p>连接到 Plesk 服务器，通过 <a href="https://support.plesk.com/hc/en-us/articles/115000172834" target="_blank" rel="noopener">SSH</a>。</p></li><li><p>使用以下命令查找受影响的域名：</p><div class="pul-alert pul-alert--info pul-status-message pul-status-message--info"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>注意：</strong> 左边的数据表示网站已达到 <code>pm.max_children</code> 限制的次数。</div><pre style="white-space: pre-wrap;"># grep -r "服务器已达到 max_children 设置" /var/log/*php*-fpm/error.log | cut -d\' \' -f5 | tr -d \']\' | sort | uniq -c | sort -nr<br><br>100 example.com<br>50 example.net<br>25 example.org<br>&lt;...&gt;</pre></li><li><p><a href="https://support.plesk.com/hc/en-us/articles/213413369" target="_blank" rel="noopener">登录到 Plesk</a>。</p></li><li><p>转到 <strong>域名</strong> &gt; <strong>example.com</strong> &gt; <strong>PHP 设置</strong> &gt; <strong>PHP-FPM 设置</strong>.</p></li><li><p>增加域名的 <code>pm.max_children</code> 值并应用更改。在第2步骤为所有列出的域名增加此值。</p></li></ol>',
    'problem-detail.nginx-too-many-open-files.name' => 'Nginx "太多打开的文件"',
    'problem-detail.nginx-too-many-open-files.description' => '<p>nginx 无法在 Plesk 服务器上启动/加载：太多打开的文件</p><h4>症状</h4><ul><li><p>nginx 服务无法启动/加载，在 <code>/var/log/nginx/error.log</code> 文件中出现以下问题：</p><pre style="white-space: pre-wrap;">nginx: [emerg] open() "/var/www/vhosts/system/example.com/logs/proxy_access_ssl_log" failed (24: 太多打开的文件)</pre></li><li><p>某些或所有的网站不可访问</p></li><li><p>警告在<strong>工具与设置 &gt;诊断与修复</strong>中显示：</p><pre style="white-space: pre-wrap;">查找nginx ULIMIT 值，在服务器上找到 N 个域名。可能会出现已打开文件的 nginx 默认限制的问题</pre></li><li><p>NodeJS和Rubyweb应用程序在执行一些Plesk任务时显示502无效网关错误，例如在创建域名、订阅或在Apache或Nginx上更改时：</p><pre style="white-space: pre-wrap;">服务器错误<br>502 无效网关<br>Web服务器在作为网关或代理服务器时收到了一个无效的响应。</pre></li><li><p>在<a href="https://support.plesk.com/hc/en-us/articles/213946825-How-to-install-SSL-certificate-for-a-domain-in-Plesk" target="_blank" rel="noopener noreferrer">为域名安装新的证书后</a>，旧的证书仍会在web 浏览器中显示，但是会在 <strong>域名 &gt; example.com &gt; 主机设置</strong> 页面中选定正确的证书。</p></li></ul>',
    'problem-detail.nginx-too-many-open-files.cause' => '<p>Nginx的虚拟主机为带有物理主机的每个虚拟主机打开了 4 个日志文件：</p><ul><li>proxy_access_log</li><li>proxy_access_ssl_log</li><li>webmail_access_log</li><li>webmail_access_ssl_log</li></ul><p>因域名众多（通常超过100个）所以会导致超过nginx服务器可打开的文件的最大数量。</p>',
    'problem-detail.nginx-too-many-open-files.solution1.title' => '增加打开的文件限制',
    'problem-detail.nginx-too-many-open-files.solution1.text' => '<div class="pul-alert pul-alert--warning pul-status-message pul-status-message--warning"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>警告：</strong> 执行<code>websrv_ulimits</code> 工具而无<strong>--no-restart</strong> 选项会启动为所有域名重建 web 配置文件，可能会因为托管网站数量众多而导致严重的宕机。<br><br>在维护期间框架内执行该命令</div><p>最好是将打开的文件限制值设置至少不超过<strong>Plesk * 16</strong> 中域名的数量。在下面的示例中，提供了如何设置限制为4096的操作步骤：</p><ol><li><p>通过<a href="https://support.plesk.com/hc/en-us/articles/115000172834" target="_blank" rel="noopener noreferrer">SSH连接到服务器</a></p></li><li><p>为Apache和 Nginx将打开的文件限制设置为4096：</p><pre># /usr/local/psa/admin/sbin/websrv_ulimits --set 4096 --no-restart</pre></li><li><p>在 <strong><a href="https://support.plesk.com/hc/en-us/articles/213413369" target="_blank" rel="noopener noreferrer">Plesk</a> &gt;</strong> <strong>工具 &amp; 设置 &gt; 服务管理</strong> 重启Apache 和 nginx以应用更改。</p></li><li><p>在web服务重启后检查 \'打开文件限制最大值\' 是否正确应用：</p><pre># grep \'Max open files\' /proc/$(cat /var/run/nginx.pid)/limits<br>打开文件最大值 4096 4096 个文件</pre></li><li><p>若上述方案没有帮助，请使用 <code>ulimit</code> 工具设置限制：</p><pre># ulimit -n 4096</pre></li></ol>',
    'problem-detail.apache-modsec-response-body-too-large.name' => 'ModSecurity "响应主体太大"',
    'problem-detail.apache-modsec-response-body-too-large.description' => '快准备好了。',
    'problem-detail.apache-modsec-response-body-too-large.cause' => '',
    'problem-detail.modsec-access-denied.name' => 'ModSecurity "访问被拒，代码 403"',
    'problem-detail.modsec-access-denied.description' => '<h4>问题</h4><ul><li><p>ModSecurity 已安装且在 <strong>工具与设置 > Web 应用防火墙 (ModSecurity) > Web 应用防火墙模式 > 启用</strong> 中启用。</p></li><li>在Plesk中托管的网站无法加载。不可能在网站上执行操作，如管理WordPress、访问web邮箱或访问<code>robots.txt</code>文件。浏览器可能会显示以下错误之一：<pre>ERR_CONNECTION_REFUSED</pre><hr><pre>403 Forbidden</pre><hr><pre>500 Internal Server Error</pre><hr><pre>ERR_CONNECTION_TIMED_OUT</pre></li><li> ModSecurity 错误信息，如在 <code>/var/log/modsec_audit.log</code> 日志文件或 Plesk 日志页面(<strong>域名</strong> &gt; <strong>example.com</strong> &gt; <strong>Logs</strong>)：<pre>ModSecurity: 访问被拒，带有 403 (2期). Operator GE matched 5 at TX:anomaly_score. [file "/etc/apache2/modsecurity.d/rules/owasp_modsecurity_crs_3-plesk/REQUEST-949-BLOCKING-EVALUATION.conf"] [line "57"] [id "949110"] [msg "Inbound Anomaly Score Exceeded (Total Score: 5)"] [severity "CRITICAL"] [tag "application-multi"] [tag "language-multi"] [tag "platform-multi"] [tag "attack-generic"] [hostname "example.com"] [uri "/robots.txt"] [unique_id "XPsROH8AAQEAABEiZFcAAABC"]</pre></li>',
    'problem-detail.modsec-access-denied.cause' => '<p>ModSecurity Web Application Firewall应用程序防火墙启用了非常严格的规则集，如OWASP、Comodo 或一个自定义规则集，如 Imunify360。限制性规则集可以阻止网站上的某些操作。</p><p><Strong>注意：</storon>ModSecurity错误可能表明对服务器的攻击。只有当您确定模式安全阻止了您的网站的有效使用时，才能使用以下解决方案。</p>',
    'problem-detail.modsec-access-denied.solution1.title' => '禁用通过ID或标记设置的 ModSecurity 规则',
    'problem-detail.modsec-access-denied.solution1.text' => '<ol><li><p>找到阻止合法使用您网站的规则的ID。您可以在<code>/var/log/modsec_audit.log</code> 日志文件中找到错误消息中的 ID。ID是方括号中带有前缀 <code>id</code> 的引号中的一个整数，例如，<strong>[id "210831"]</strong>。</p></li><li><a href="https://support.plesk.com/hc/en-us/articles/115002531753" target="_blank" rel="noopener">禁用 Plesk 中的指定规则集</a>。</li></ol>',
    'problem-detail.modsec-access-denied.solution2.title' => '切换到另一个ModSecurity规则集',
    'problem-detail.modsec-access-denied.solution2.text' => '<ol><li><p>切换到限制较少的ModSecurity规则集，例如，“Atomic ModSecurity规则集”。要实现此目的，请转到<strong>工具与设置</strong> > <strong>Web 应用防火墙 (ModSecurity)</strong> > <strong>设置</strong>，选择 <strong>Atomic Standard</strong>，然后点击 <strong>确定</strong>以应用更改。</p></li></ol>',
    'problem-detail.php-allowed-memory-size-exhausted.name' => 'PHP "内部服务器错误 500: 允许的内存容量 XXX 已耗尽"',
    'problem-detail.php-allowed-memory-size-exhausted.description' => '<h4>问题</h4><ul><li><p>在Plesk中托管的网站不可访问：</p><pre>500 内部服务器错误</pre></li><li><p>以下错误在网站日志中显示：</p><pre>Got error "PHP message: PHP Fatal error: Allowed memory size of 4194304 bytes exhausted (tried to allocate 4000032 bytes) in /var/www/vhosts/try.me/httpdocs/somethingBig.php on line 3</pre></li> </ul>',
    'problem-detail.php-allowed-memory-size-exhausted.cause' => '<p>该网站没有分配足够的内存来进行处理。</p>',
    'problem-detail.php-allowed-memory-size-exhausted.solution1.title' => '增加网站的 memory_limit',
    'problem-detail.php-allowed-memory-size-exhausted.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/115000304194" target="_blank" rel="noopener">请参阅 KB 文章并按照说明执行</a>。</p></li></ol>',
    'problem-detail.php-open-basedir-restriction-in-effect.name' => 'PHP "open_basedir 限制有效"',
    'problem-detail.php-open-basedir-restriction-in-effect.description' => '<h4>问题</h4><ul><li><p>如果web浏览器出现以下错误之一，则无法访问网站：</p><pre>404 file not found</pre><hr><pre>500 Internal Server Error</pre><hr><pre>Error 500 move_uploaded_file(): open_basedir restriction in effect. File(/path/to/the/directory) is not within the allowed path(s): (/var/www/vhosts/example.com/:/tmp/)</pre></li><li><p>在域名的“日志”页面上，会出现以下错误消息(<strong>域名</strong> > <strong>example.com</strong> > <strong>日志</strong>)：</p><pre><...> open_basedir restriction in effect. File(/path/to/the/directory) is not within the allowed path(s) <...></pre><hr><pre>Uncaught Exception: Session: Configured save path "/path/to/the/directory" is not a directory, doesn\'t exist or cannot be created.</pre></li></ul>',
    'problem-detail.php-open-basedir-restriction-in-effect.cause' => 'PHP脚本正在尝试访问不允许访问的目录。此限制由每个域名的PHP<code>open_basedir</code> 指令单独定义。默认情况下，<code>open_basedir</code>允许访问 <code>tmp</code> 和域名的文档根目录，以及系统的默认会话路径。',
    'problem-detail.php-open-basedir-restriction-in-effect.solution1.title' => '将其它路径添加到 open_basedir 指令中',
    'problem-detail.php-open-basedir-restriction-in-effect.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/115000278993" target="_blank" rel="noopener">请参阅 KB 文章并按照说明执行</a>。</p></li></ol>',
    'problem-detail.php-open-basedir-restriction-in-effect.solution2.title' => '禁用open_basedir指令',
    'problem-detail.php-open-basedir-restriction-in-effect.solution2.text' => '<ol><li><p>转到 <strong>域名 &gt example.com &gt PHP 设置</strong> 页面并设置<code>open_basedir</code> 指令为 "无"。</p></li></ol>',
    'problem-detail.apache-client-denied-by-server.name' => 'Apache .htaccess "403禁止AH01797：客户端被服务器配置拒绝"',
    'problem-detail.apache-client-denied-by-server.description' => '<h4>问题</h4><ul><li><p>该网站显示了一个类似错误：</p><pre>Server Error 403<br>Forbidden</pre></li><li><p><code>/var/www/vhosts/system/example.com/logs/error_log</code>日志文件包含如下错误：</p><pre>AH01797: client denied by server configuration: /var/www/vhosts/example.com/index.php</pre></li></ul>',
    'problem-detail.apache-client-denied-by-server.cause' => '<p>自定义Apache配置不允许访问网站。</p>',
    'problem-detail.apache-client-denied-by-server.solution1.title' => '检查服务器配置和 .htaccess 文件',
    'problem-detail.apache-client-denied-by-server.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/214528485" target="_blank" rel="noopener">请参阅 KB 文章并按照说明执行</a>。</p></li></ol>',
    'problem-detail.apache-no-directory-index.name' => 'Apache“无法访问Plesk中的网站目录：403禁止”',
    'problem-detail.apache-no-directory-index.description' => '<h4>问题</h4><ul><li><p>无法访问一个网站的特定位置，例如，<code>http://example.com/some_folder</code>。发生以下错误：</p><pre>Server Error 403<br>Forbidden</pre></li><li><p>以下错误出现在 <code>/var/www/vhosts/example.com/logs/error_log<code/> 文件中：</p><pre>[autoindex:error] [pid 16314:tid 140300215322368] [client 203.0.113.2:55714] AH01276: Cannot serve directory /var/www/vhosts/example.com/httpdocs/some_folder/: No matching DirectoryIndex (index.html,index.cgi,index.pl,index.php,index.xhtml,index.htm,index.shtml) found, and server-generated directory index forbidden by Options directive</pre></li></ul>',
    'problem-detail.apache-no-directory-index.cause' => '<p>所请求的目录不包含索引文件，或者未启用目录浏览。</p>',
    'problem-detail.apache-no-directory-index.solution1.title' => '添加索引文件到目录',
    'problem-detail.apache-no-directory-index.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/214528485" target="_blank" rel="noopener">请参阅 KB 文章并按照说明执行</a>。</p></li></ol>',
    'problem-detail.apache-no-directory-index.solution2.title' => '启用目录浏览',
    'problem-detail.apache-no-directory-index.solution2.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/360002534354" target="_blank" rel="noopener">请参阅 KB 文章并按照说明执行</a>。</p></li></ol>',
    'problem-detail.nginx-no-directory-index.name' => 'Nginx“无法访问Plesk中的网站目录：403禁止”',
    'problem-detail.nginx-no-directory-index.description' => '<h4>问题</h4><ul><li><p>无法访问一个网站的特定位置，例如，<code>http://example.com/some_folder</code>。发生以下错误：</p><pre>Server Error 403<br>Forbidden</pre></li><li><p>以下错误出现在 <code>/var/www/vhosts/example.com/logs/error_log file</code>中：</p><pre>[autoindex:error] [pid 16314:tid 140300215322368] [client 203.0.113.2:55714] AH01276: Cannot serve directory /var/www/vhosts/example.com/httpdocs/some_folder/: No matching DirectoryIndex (index.html,index.cgi,index.pl,index.php,index.xhtml,index.htm,index.shtml) found, and server-generated directory index forbidden by Options directive</pre></li></ul>',
    'problem-detail.nginx-no-directory-index.cause' => '<p>所请求的目录不包含索引文件，或者未启用目录浏览。</p>',
    'problem-detail.nginx-no-directory-index.solution1.title' => '添加索引文件到目录',
    'problem-detail.nginx-no-directory-index.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/214528485" target="_blank" rel="noopener">请参阅 KB 文章并按照说明执行</a>。</p></li></ol>',
    'problem-detail.nginx-no-directory-index.solution2.title' => '启用目录浏览',
    'problem-detail.nginx-no-directory-index.solution2.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/360002534354" target="_blank" rel="noopener">请参阅 KB 文章并按照说明执行</a>。</p></li></ol>',
    'problem-detail.apache-reached-max-request-workers.name' => 'Apache "服务器达到了 MaxRequestWorkers 设置"',
    'problem-detail.apache-reached-max-request-workers.description' => '快准备好了。',
    'problem-detail.apache-reached-max-request-workers.cause' => '',
    'problem-detail.php-post-content-length-exceeds-limit.name' => 'PHP请求主体限制“客户端计划发送过大主体”',
    'problem-detail.php-post-content-length-exceeds-limit.description' => '快准备好了。',
    'problem-detail.php-post-content-length-exceeds-limit.cause' => '',
    'problem-detail.nginx-client-sent-too-large-body.name' => 'PHP请求主体限制“客户端计划发送过大主体”',
    'problem-detail.nginx-client-sent-too-large-body.description' => '快准备好了。',
    'problem-detail.nginx-client-sent-too-large-body.cause' => '',
    'problem-detail.php-failed-to-read-session-data.name' => 'PHP会话“503内部服务器错误”或“读取会话数据失败”',
    'problem-detail.php-failed-to-read-session-data.description' => '快准备好了。',
    'problem-detail.php-failed-to-read-session-data.cause' => '',
    'problem-detail.apache-unable-to-check-htaccess-file.name' => 'Apache .htaccess "403 Forbidden: pcfg_openfile: 无法检查htaccess文件，以确保其可读性”',
    'problem-detail.apache-unable-to-check-htaccess-file.description' => '<h4>问题</h4><ul><li><p>在Plesk中托管的一个网站不工作：</p><pre>您没有访问此服务器的权限。<br> 此外，在尝试使用 ErrorDocument 处理请求时，遇到了403禁止错误。</pre><p>您还可以看到空白页，而不是上述错误。</p></li><li><p>在<strong>域名 &gt example.com &gt 日志</strong>中的域名错误日志包含以下：</p><pre>(13)Permission denied: [client 203.0.113.2:39024] AH00529: /var/www/vhosts/example.com/httpdocs/.htaccess pcfg_openfile: unable to check htaccess file, ensure it is readable and that "/var/www/vhosts/example.com/httpdocs/" is executable</pre></li></ul>',
    'problem-detail.apache-unable-to-check-htaccess-file.cause' => '域名的文件或文件夹的权限不正确。',
    'problem-detail.apache-unable-to-check-htaccess-file.solution1.title' => '网站内容的修复权限',
    'problem-detail.apache-unable-to-check-htaccess-file.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/213939685" target="_blank" rel="noopener">请参阅 KB 文章并按照说明执行</a>。</p></li></ol>',
];