<?php
// Copyright 1999-2022. Plesk International GmbH. All rights reserved.
$messages = [
    'problem-detail.nginx-upstream-sent-too-big-header.name' => 'Nginx "502 Bad Gateway: upstream sent too big header while reading response header"',
    'problem-detail.nginx-upstream-sent-too-big-header.description' => 'Текст скоро появится.',
    'problem-detail.nginx-upstream-sent-too-big-header.cause' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.title' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.text' => '',
    'problem-detail.apache-followsymlinks-not-allowed.name' => 'Apache "Внутренняя ошибка сервера 500: опция FollowSymLinks не разрешена здесь"',
    'problem-detail.apache-followsymlinks-not-allowed.description' => 'Текст скоро появится.',
    'problem-detail.apache-followsymlinks-not-allowed.cause' => '',
    'problem-detail.phpfpm-server-reached-max-children.name' => 'PHP-FPM "server reached max_children setting"',
    'problem-detail.phpfpm-server-reached-max-children.description' => '<h4>Симптомы</h4><ul><li><p>На сайтах, где обработчик PHP установлен как <strong>приложение FPM, обслуживаемое Apache,</strong> или <strong>приложение FPM, обслуживаемое nginx,</strong> на странице <strong>Домены</strong> &gt; <strong>example.com</strong> &gt; <strong>Настройки PHP</strong> возникает одна из следующих проблем:</p><ul><li><p>медленная загрузка</p></li><li><p>отсутствие доступа (постоянно или периодически) с ошибкой 50x в ​​веб-браузере:</p><pre>502 Недопустимый шлюз</pre><hr><pre>503 Сервис временно недоступен</pre><hr><pre>504 Таймаут соединения со шлюзом</pre></li></ul></li><li><p>Следующее сообщение появляется в файле журнала ошибок PHP-FPM <code>/var/log/plesk-php<strong>XX</strong>-fpm/error.log</code> (где <em>XX</em> – версия PHP, используемая сайтами):</p><pre>ВНИМАНИЕ: для сервера [pool example.com] достигнуто значение настройки max_children (*), рассмотрите возможность его увеличения</pre><ul><li><p>Сообщение выше обычно сопровождается этой ошибкой:</p><pre>unable to read what child say: Bad file descriptor (9)</pre></li></ul></li><li><p>Если на сервере включен nginx, в файле журнала ошибок домена может появиться одно из следующих сообщений об ошибке <code>/var/www/vhosts/system/example.com/logs/proxy_error_log</code>:</p><pre style="white-space: pre-wrap;">[error] 11456#0: *118348 connect() to unix:///var/www/vhosts/system/example.com/php-fpm.sock failed (11: Resource temporarily unavailable) while connecting to upstream, client: 203.0.113.2, server: example.com, request: "GET / HTTP/1.1", upstream: "fastcgi://unix:///var/www/vhosts/system/example.com/php-fpm.sock:", host: "example.com"</pre><hr><pre style="white-space: pre-wrap;">[error] 20058#0: *4725139 upstream prematurely closed connection while reading response header from upstream, client: 203.0.113.2, server: example.com, request: "POST /path/to/some/file HTTP/2.0", upstream:</pre></li></ul>',
    'problem-detail.phpfpm-server-reached-max-children.cause' => ' <p>Сайты достигли PHP-FPM <code>pm.max_children</code>.</p>',
    'problem-detail.phpfpm-server-reached-max-children.solution1.title' => 'Увеличить лимит pm.max_children',
    'problem-detail.phpfpm-server-reached-max-children.solution1.text' => '<p>Увеличьте ограничение <code>pm.max_children</code> для затронутых доменов:</p><ol><li><p>Подключитесь к серверу Plesk через <a href="https://support.plesk.com/hc/en-us/articles/115000172834" target="_blank" rel="noopener">SSH</a>.</p></li><li><p>Найдите затронутые домены с помощью команды ниже:</p><div class="pul-alert pul-alert--info pul-status-message pul-status-message--info"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Примечание:</strong> Число слева показывает, сколько раз сайт достиг предела <code>pm.max_children</code>.</div><pre style="white-space: pre-wrap;"># grep -r "server reached max_children setting" /var/log/*php*-fpm/error.log | cut -d\' \' -f5 | tr -d \']\' | sort | uniq -c | sort -nr<br><br>100 example.com<br>50 example.net<br>25 example.org<br>&lt;...&gt;</pre></li><li><p><a href="https://support.plesk.com/hc/en-us/articles/213413369" target="_blank" rel="noopener">Войдите в Plesk</a>.</p></li><li><p>Перейдите на страницу <strong>Домены</strong> &gt; <strong>example.com</strong> &gt; <strong>Настройки PHP</strong> &gt; <strong>Настройки PHP-FPM</strong>.</p></li><li><p>Увеличьте значение <code>pm.max_children</code> для домена и примените изменения. Увеличьте это значение для всех доменов, перечисленных на шаге 2.</p></li></ol>',
    'problem-detail.nginx-too-many-open-files.name' => 'Nginx "Слишком много открытых файлов"',
    'problem-detail.nginx-too-many-open-files.description' => '<p>nginx не запускается/не перезагружается на сервере Plesk: слишком много открытых файлов</p><h4>Симптомы</h4><ul><li><p>Служба nginx не запускается/не перезагружается со следующей ошибкой в файле <code>/var/log/nginx/error.log</code>:</p><pre style="white-space: pre-wrap;">nginx: [emerg] open() "/var/www/vhosts/system/example.com/logs/proxy_access_ssl_log" failed (24: Too many open files)</pre></li><li><p>Некоторые или все сайты недоступны</p></li><li><p>Предупреждение отображается в разделе <strong>Инструменты и настройки &gt; Диагностировать и исправить</strong>:</p><pre style="white-space: pre-wrap;">Проверка значения ULIMIT nginx На сервере найдено N доменов. Возможна проблема с лимитом nginx по умолчанию для открытых файлов</pre></li><li><p>Веб-приложения NodeJS и Ruby показывают ошибку 502 Недопустимый шлюз при выполнении некоторых задач Plesk, таких как создание доменов, подписок, изменения в Apache или Nginx и т. д.:</p><pre style="white-space: pre-wrap;">Ошибка сервера<br>502 Недопустимый шлюз <br>Веб-сервер получил неверный ответ, выступая в качестве шлюза или прокси-сервера.</pre></li><li><p>После <a href="https://support.plesk.com/hc/en-us/articles/213946825-How-to-install-SSL-certificate-for-a-domain-in-Plesk" target="_blank" rel="noopener noreferrer">установки нового сертификата для домена</a>, старый по-прежнему отображается в браузере, однако правильный сертификат можно выбрать на странице <strong>Домены &gt; example.com &gt; Настройки хостинга</strong>.</p></li></ul>',
    'problem-detail.nginx-too-many-open-files.cause' => '<p>Виртуальный хост nginx открывает 4 файла журнала для каждого виртуального хоста с физическим хостингом:</p><ul><li>proxy_access_log</li><li>proxy_access_ssl_log</li><li>webmail_access_log</li><li>webmail_access_ssl_log</li></ul><p>В результате сервер nginx превышает максимальное количество открытых файлов из-за большого количества доменов (обычно более 100).</p>',
    'problem-detail.nginx-too-many-open-files.solution1.title' => 'Увеличить лимит открытых файлов',
    'problem-detail.nginx-too-many-open-files.solution1.text' => '<div class="pul-alert pul-alert--warning pul-status-message pul-status-message--warning"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Внимание!</strong> Выполнение утилиты <code>websrv_ulimits</code> без опции <strong>--no-restart</strong> запускает пересборку файлов веб-конфигурации для всех доменов и может привести к значительному простою в случае большого количества размещенных сайтов.<br><br>Выполните команду в течение периода обслуживания.</div><p>Рекомендуется установить значение лимита открытых файлов по меньшей мере больше, чем <strong>количество доменов в Plesk * 16</strong>. В приведенном ниже примере приведены действия, как установить ограничение на 4096:</p><ol><li><p>Подключитесь к серверу через <a href="https://support.plesk.com/hc/en-us/articles/115000172834" target="_blank" rel="noopener noreferrer">SSH</a></p></li><li><p>Установите ограничение на количество открытых файлов до 4096 для Apache и Nginx:</p><pre># /usr/local/psa/admin/sbin/websrv_ulimits --set 4096 --no-restart</pre></li><li><p>Перезапустите службы Apache и nginx в <strong><a href="https://support.plesk.com/hc/en-us/articles/213413369" target="_blank" rel="noopener noreferrer">Plesk</a> &gt;</strong> <strong>Инструменты и настройки &gt; Управление службами</strong>, чтобы применить изменения.</p></li><li><p>Проверьте правильность применения параметра "Максимальное ограничение количества открытых файлов" после перезапуска веб-служб:</p><pre># grep \'Max open files\' /proc/$(cat /var/run/nginx.pid)/limits<br>Max open files 4096 4096 file</pre></li><li><p>Если приведенное выше решение не поможет, установите ограничение с помощью утилиты <code>ulimit</code>:</p><pre># ulimit -n 4096</pre></li></ol>',
    'problem-detail.apache-modsec-response-body-too-large.name' => 'ModSecurity "Слишком большое тело ответа"',
    'problem-detail.apache-modsec-response-body-too-large.description' => 'Текст скоро появится.',
    'problem-detail.apache-modsec-response-body-too-large.cause' => '',
    'problem-detail.modsec-access-denied.name' => 'ModSecurity "Отказано в доступе с кодом 403"',
    'problem-detail.modsec-access-denied.description' => '<h4>Симптомы</h4><ul><li><p>ModSecurity установлен и включен в разделе <strong>Инструменты и настройки > Брандмауэр для веб-приложений (ModSecurity) > Режим работы брандмауэра > Включен</strong>.</p></li><li>Сайт, размещенный в Plesk, не загружается. На сайте невозможно выполнять такие операции, как управление WordPress, доступ к веб-почте или доступ к файлу <code>robots.txt</code>. Браузер может отображать одну из следующих ошибок: <pre>ERR_CONNECTION_REFUSED</pre><hr><pre>403 Forbidden</pre><hr><pre>500 Internal Server Error</pre><hr><pre>ERR_CONNECTION_TIMED_OUT</pre></li><li>Сообщение об ошибке ModSecurity, подобное приведенному ниже, появляется в файле журнала <code>/var/log/modsec_audit.log</code> или на странице журналов в Plesk (<strong>Домены</strong> &gt; <strong>example.com</strong> &gt; <strong>Журналы</strong>): <pre>ModSecurity: Access denied with code 403 (phase 2). Operator GE matched 5 at TX:anomaly_score. [file "/etc/apache2/modsecurity.d/rules/owasp_modsecurity_crs_3-plesk/REQUEST-949-BLOCKING-EVALUATION.conf"] [line "57"] [id "949110"] [msg "Inbound Anomaly Score Exceeded (Total Score: 5)"] [severity "CRITICAL"] [tag "application-multi"] [tag "language-multi"] [tag "platform-multi"] [tag "attack-generic"] [hostname "example.com"] [uri "/robots.txt"] [unique_id "XPsROH8AAQEAABEiZFcAAABC"]</pre></li>',
    'problem-detail.modsec-access-denied.cause' => '<p>Брандмауэр веб-приложений ModSecurity включен с очень строгим набором правил, таким как OWASP, Comodo, или настраиваемым набором правил, таким как Imunify360. Строгие наборы правил могут блокировать некоторые операции на сайте.</p><p><Strong>Примечание:</strong> Ошибка ModSecurity может указывать на атаку на ваш сервер. Используйте приведенные ниже решения, только если вы уверены, что ModSecurity блокирует допустимое использование вашего сайта.</p>',
    'problem-detail.modsec-access-denied.solution1.title' => 'Отключить набор правил ModSecurity по ID или тегу',
    'problem-detail.modsec-access-denied.solution1.text' => '<ol><li><p>Find the ID of the rule that blocks the legitimate usage of your website. You can find the IDs inside error messages in the <code>/var/log/modsec_audit.log</code> log file. The ID is an integer number in quotation marks with the prefix <code>id</code> in square brackets, for example, <strong>[id "210831"]</strong>.</p></li><li><a href="https://support.plesk.com/hc/en-us/articles/115002531753" target="_blank" rel="noopener">Disable specific rule sets in Plesk</a>.</li></ol>',
    'problem-detail.modsec-access-denied.solution2.title' => 'Переключиться на другой набор правил ModSecurity',
    'problem-detail.modsec-access-denied.solution2.text' => '<ol><li><p>Переключитесь на менее строгий набор правил ModSecurity, например, "Набор правил Atomic ModSecurity". Для этого перейдите в раздел <strong>Инструменты и настройки</strong> > <strong>Брандмауэр для веб-приложений (ModSecurity)</strong> > <strong>Настройки</strong>, выберите <strong>Atomic Standard</strong>, а затем нажмите <strong>ОК</strong>, чтобы применить изменения.</p></li></ol>',
    'problem-detail.php-allowed-memory-size-exhausted.name' => 'PHP "Внутренняя ошибка сервера 500: допустимый размер памяти XXX исчерпан"',
    'problem-detail.php-allowed-memory-size-exhausted.description' => '<h4>Симптомы</h4><ul><li><p>Сайт, размещенный в Plesk, недоступен:</p><pre>500 Internal Server Error</pre></li><li><p>В журнале сайта отображается следующая ошибка:</p><pre>Got error "PHP message: PHP Fatal error: Allowed memory size of 4194304 bytes exhausted (tried to allocate 4000032 bytes) in /var/www/vhosts/try.me/httpdocs/somethingBig.php on line 3</pre></li> </ul>',
    'problem-detail.php-allowed-memory-size-exhausted.cause' => '<p>На сайте недостаточно памяти, выделенной для обработки.</p>',
    'problem-detail.php-allowed-memory-size-exhausted.solution1.title' => 'Увеличить memory_limit сайта',
    'problem-detail.php-allowed-memory-size-exhausted.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/115000304194" target="_blank" rel="noopener">Прочтите статью базы знаний и следуйте инструкциям</a>.</p></li></ol>',
    'problem-detail.php-open-basedir-restriction-in-effect.name' => 'PHP "действует ограничение open_basedir"',
    'problem-detail.php-open-basedir-restriction-in-effect.description' => '<h4>Симптомы</h4><ul><li><p>Сайт недоступен из-за одной из следующих ошибок в браузере:</p><pre>404 file not found</pre><hr><pre>500 Internal Server Error</pre><hr><pre>Error 500 move_uploaded_file(): open_basedir restriction in effect. File(/path/to/the/directory) is not within the allowed path(s): (/var/www/vhosts/example.com/:/tmp/)</pre></li><li><p>На странице журналов домена появляется следующее сообщение об ошибке (<strong>Домены</strong> > <strong>example.com</strong> > <strong>Журналы</strong>):</p><pre><...> open_basedir restriction in effect. File(/path/to/the/directory) is not within the allowed path(s) <...></pre><hr><pre>Uncaught Exception: Session: Configured save path "/path/to/the/directory" is not a directory, doesn\'t exist or cannot be created.</pre></li></ul>',
    'problem-detail.php-open-basedir-restriction-in-effect.cause' => 'PHP-скрипт пытается получить доступ к каталогу, доступ к которому запрещен. Это ограничение определяется директивой PHP <code>open_basedir</code> индивидуально для каждого домена. По умолчанию <code>open_basedir</code> разрешает доступ к <code>tmp</code> и корневым каталогам домена, а также к системному пути сеансов по умолчанию.',
    'problem-detail.php-open-basedir-restriction-in-effect.solution1.title' => 'Добавить дополнительный путь в директиву open_basedir',
    'problem-detail.php-open-basedir-restriction-in-effect.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/115000278993" target="_blank" rel="noopener">Прочтите статью базы знаний и следуйте инструкциям</a>.</p></li></ol>',
    'problem-detail.php-open-basedir-restriction-in-effect.solution2.title' => 'Отключить директиву open_basedir',
    'problem-detail.php-open-basedir-restriction-in-effect.solution2.text' => '<ol><li><p>Перейдите на страницу <strong>Домены &gt example.com &gt Настройки PHP</strong> и задайте для директивы <code>open_basedir</code> значение "none".</p></li></ol>',
    'problem-detail.apache-client-denied-by-server.name' => 'Apache .htaccess "403 Доступ запрещен AH01797: клиент отклонен конфигурацией сервера"',
    'problem-detail.apache-client-denied-by-server.description' => '<h4>Симптомы</h4><ul><li><p>На сайте отображается ошибка, наподобие следующей:</p><pre>Server Error 403<br>Forbidden</pre></li><li><p>Файл журнала <code>/var/www/vhosts/system/example.com/logs/error_log</code> содержит ошибки, подобные следующей:</p><pre>AH01797: client denied by server configuration: /var/www/vhosts/example.com/index.php</pre></li></ul>',
    'problem-detail.apache-client-denied-by-server.cause' => '<p>Пользовательская конфигурация Apache не разрешает доступ к сайту.</p>',
    'problem-detail.apache-client-denied-by-server.solution1.title' => 'Проверить конфигурацию сервера и файлы .htaccess',
    'problem-detail.apache-client-denied-by-server.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/214528485" target="_blank" rel="noopener">Прочтите статью базы знаний и следуйте инструкциям</a>.</p></li></ol>',
    'problem-detail.apache-no-directory-index.name' => 'Apache "Не удается получить доступ к каталогу сайта в Plesk: 403 Доступ запрещен"',
    'problem-detail.apache-no-directory-index.description' => '<h4>Симптомы</h4><ul><li><p>Не удается получить доступ к определенному месту сайта, например, <code>http://example.com/some_folder</code>. Возникает следующая ошибка:</p><pre>Server Error 403<br>Forbidden</pre></li><li><p>В файле <code>/var/www/vhosts/example.com/logs/error_log<code/> появляется следующая ошибка:</p><pre>[autoindex:error] [pid 16314:tid 140300215322368] [client 203.0.113.2:55714] AH01276: Cannot serve directory /var/www/vhosts/example.com/httpdocs/some_folder/: No matching DirectoryIndex (index.html,index.cgi,index.pl,index.php,index.xhtml,index.htm,index.shtml) found, and server-generated directory index forbidden by Options directive</pre></li></ul>',
    'problem-detail.apache-no-directory-index.cause' => '<p>Запрошенный каталог не содержит индексных файлов или просмотр каталога не включен.</p>',
    'problem-detail.apache-no-directory-index.solution1.title' => 'Добавить индексный файл в каталог',
    'problem-detail.apache-no-directory-index.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/214528485" target="_blank" rel="noopener">Прочтите статью базы знаний и следуйте инструкциям</a>.</p></li></ol>',
    'problem-detail.apache-no-directory-index.solution2.title' => 'Включить просмотр каталога',
    'problem-detail.apache-no-directory-index.solution2.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/360002534354" target="_blank" rel="noopener">Прочтите статью базы знаний и следуйте инструкциям</a>.</p></li></ol>',
    'problem-detail.nginx-no-directory-index.name' => 'Nginx "Не удается получить доступ к каталогу сайта в Plesk: 403 Доступ запрещен"',
    'problem-detail.nginx-no-directory-index.description' => '<h4>Симптомы</h4><ul><li><p>Не удается получить доступ к определенному месту сайта, например, <code>http://example.com/some_folder</code>. Возникает следующая ошибка:</p><pre>Server Error 403<br>Forbidden</pre></li><li><p>В файле <code>/var/www/vhosts/example.com/logs/error_log появляется следующая ошибка</code>:</p><pre>[autoindex:error] [pid 16314:tid 140300215322368] [client 203.0.113.2:55714] AH01276: Cannot serve directory /var/www/vhosts/example.com/httpdocs/some_folder/: No matching DirectoryIndex (index.html,index.cgi,index.pl,index.php,index.xhtml,index.htm,index.shtml) found, and server-generated directory index forbidden by Options directive</pre></li></ul>',
    'problem-detail.nginx-no-directory-index.cause' => '<p>Запрошенный каталог не содержит индексных файлов или просмотр каталога не включен.</p>',
    'problem-detail.nginx-no-directory-index.solution1.title' => 'Добавить индексный файл в каталог',
    'problem-detail.nginx-no-directory-index.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/214528485" target="_blank" rel="noopener">Прочтите статью базы знаний и следуйте инструкциям</a>.</p></li></ol>',
    'problem-detail.nginx-no-directory-index.solution2.title' => 'Включить просмотр каталога',
    'problem-detail.nginx-no-directory-index.solution2.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/360002534354" target="_blank" rel="noopener">Прочтите статью базы знаний и следуйте инструкциям</a>.</p></li></ol>',
    'problem-detail.apache-reached-max-request-workers.name' => 'Apache "сервер достиг настройки MaxRequestWorkers"',
    'problem-detail.apache-reached-max-request-workers.description' => 'Текст скоро появится.',
    'problem-detail.apache-reached-max-request-workers.cause' => '',
    'problem-detail.php-post-content-length-exceeds-limit.name' => 'Ограничение тела запроса PHP "клиент намеревался отправить слишком большой запрос"',
    'problem-detail.php-post-content-length-exceeds-limit.description' => 'Текст скоро появится.',
    'problem-detail.php-post-content-length-exceeds-limit.cause' => '',
    'problem-detail.nginx-client-sent-too-large-body.name' => 'Ограничение тела запроса PHP "клиент намеревался отправить слишком большой запрос"',
    'problem-detail.nginx-client-sent-too-large-body.description' => 'Текст скоро появится.',
    'problem-detail.nginx-client-sent-too-large-body.cause' => '',
    'problem-detail.php-failed-to-read-session-data.name' => 'Сеансы PHP "503 Внутренняя ошибка сервера" или "Не удалось прочитать данные сеанса"',
    'problem-detail.php-failed-to-read-session-data.description' => 'Текст скоро появится.',
    'problem-detail.php-failed-to-read-session-data.cause' => '',
    'problem-detail.apache-unable-to-check-htaccess-file.name' => 'Apache .htaccess "403 Доступ запрещен: pcfg_openfile: невозможно проверить файл htaccess, убедитесь, что он читаем"',
    'problem-detail.apache-unable-to-check-htaccess-file.description' => '<h4>Симптомы</h4><ul><li><p>Сайт, размещенный в Plesk, не работает:</p><pre>You don\'t have permission to access / on this server. <br> Кроме того, при попытке использовать ErrorDocument для обработки запроса возникла ошибка 403 Forbidden.</pre><p>Вместо вышеуказанной ошибки вы также можете увидеть пустую страницу.</p></li><li><p>Журнал ошибок домена на странице <strong>Домены &gt example.com &gt Журналы</strong> содержит следующее:</p><pre>(13)Permission denied: [client 203.0.113.2:39024] AH00529: /var/www/vhosts/example.com/httpdocs/.htaccess pcfg_openfile: unable to check htaccess file, ensure it is readable and that "/var/www/vhosts/example.com/httpdocs/" is executable</pre></li></ul>',
    'problem-detail.apache-unable-to-check-htaccess-file.cause' => 'Неправильные права для файлов или папок домена.',
    'problem-detail.apache-unable-to-check-htaccess-file.solution1.title' => 'Исправить права для контента сайта',
    'problem-detail.apache-unable-to-check-htaccess-file.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/213939685" target="_blank" rel="noopener">Прочтите статью базы знаний и следуйте инструкциям</a>.</p></li></ol>',
];