<?php
// Copyright 1999-2022. Plesk International GmbH. All rights reserved.
$messages = [
    'title' => 'Comprobación de registro de sitios web',

    'regularCheck' => 'Comprobación automática',
    'manualCheck' => 'Comprobación manual',

    'promoTitle' => 'Rápida detección de no disponibilidad o de un funcionamiento incorrecto de sus sitios web',
    'promoDescription' => 'Suele ser habitual que las incidencias en los sitios web sean percibidas por los visitantes pero no por los administradores, a menos que estos analicen los registros del sitio de forma constante. Nuestra comprobación de registro de sitios web automatiza esta rutina y ayuda a resolver las incidencias detectadas de forma eficiente.',
    'promoMore' => 'Más información',
    'promoButton' => '¡Entendido!',
    'checkEnabledTitle' => 'La comprobación automática está activada',
    'checkDisabledTitle' => 'La comprobación automática está desactivada',
    'disabledDescription' => 'Actívela para detectar incidencias automáticamente que puedan hacer que los sitios web ya no estén disponibles o bien ocasionar un funcionamiento incorrecto de estos.',
    'websitesAllChecked' => '{count, plural, one {# sitio web se comprueba} other {# sitios web se comprueban}} a diario',
    'websitesAllCheckedAt' => '{count, plural, one {# sitio web se comprueba} other {# sitios web se comprueban}} a diario a las %%time%%',
    'websitesChecked' => '%%count%% de %%totalCount%% sitios web se comprueban a diario',
    'websitesCheckedAt' => '%%count%% de %%totalCount%% sitios web se comprueban a diario a las %%time%%',
    'checkedWebsites' => 'Lista de sitios web comprobados',
    'lastCheckDescription' => 'La última comprobación tardó %%duration%% minutos en completarse.',
    'durationLess' => 'menos de 0.1',
    'month0' => '%%date%% Ene',
    'month1' => '%%date%% Feb',
    'month2' => '%%date%% Mar',
    'month3' => '%%date%% Abr',
    'month4' => '%%date%% May',
    'month5' => '%%date%% Jun',
    'month6' => '%%date%% Jul',
    'month7' => '%%date%% Ago',
    'month8' => '%%date%% Sep',
    'month9' => '%%date%% Oct',
    'month10' => '%%date%% Nov',
    'month11' => '%%date%% Dic',
    'export' => 'Exportar el informe a CSV',
    'buttonRun' => 'Ejecutar comprobación manual',
    'buttonRunDescription' => 'Para volver a comprobar sitios web corregidos o detectar incidencias no encontradas en la última comprobación.',

    'websites.title' => 'Sitios web a comprobar',
    'websites.description' => 'Se han seleccionado %%selected%% de %%total%% sitios web',
    'websites.search' => 'Encontrar sitios web...',
    'websites.new' => 'Todos los sitios creados recientemente',
    'websites.newHint' => 'Seleccione iniciar automáticamente la comprobación de todos los sitios web nuevos.',
    'websites.existing' => 'Todos los sitios web existentes',
    'websites.buttonSave' => 'Guardar',
    'websites.buttonCancel' => 'Cancelar',
    'websites.updateSuccess' => 'La configuración ha sido actualizada',

    'tabs.problemDetails' => 'Detalles de la incidencia',
    'tabs.affectedWebsites' => 'Sitios web afectados',

    'chart.requests' => 'Peticiones',
    'chart.errors' => 'Errores',

    'affected-websites.selected' => 'Se han seleccionado %%selectedCount%% de %%totalCount%% sitios web',
    'affected-websites.none' => 'Ninguno',
    'affected-websites.all' => 'Todos',
    'affected-websites.searchForWebsite' => 'Buscar sitios web',
    'affected-websites.websites' => 'Sitios web',
    'affected-websites.showProblemDetails' => 'Mostrar los detalles del problema',

    'problem-report.domainTitle' => 'Se informó de una incidencia en %%domain%%',
    'problem-report.cumulativeTitle' => 'Se notificó una incidencia en {count, plural, one {# sitio web} other {# sitios web}}',
    'problem-report.serverwideTitle' => 'Incidencia a nivel del servidor notificada',
    'problem-report.problemAppearsOn' => 'La incidencia aparece en {count, plural, one {# sitio web} other {# sitios web}} en total',
    'problem-report.seeTheConsolidatedReport' => 'Examine el informe consolidado',
    'problem-report.cause' => 'Causa principal',
    'problem-report.possibleSolutions' => 'Posibles soluciones',
    'problem-report.useAnOption' => 'Usar una opción para solución automática',
    'problem-report.repairTheWebsite' => 'Reparar el sitio web',
    'problem-report.selectAndRepair' => 'Seleccionar y reparar varios sitios web',
    'problem-report.distributionOfTheProblem' => 'Distribución de la incidencia a lo largo del tiempo',
    'problem-report.serverTimezone' => 'Zona horaria del servidor (UTC%%utcShift%%)',
    'problem-report.yourTimezone' => 'Su zona horaria (UTC%%utcShift%%)',
    'problem-report.logEntries' => 'Ejemplos de entradas del registro que indican la incidencia',
    'problem-report.pleaseKeepInMind' => 'Nota: Plesk rota los registros de forma constante y eventualmente archiva o elimina las entradas del registro mencionadas.',
    'problem-report.weRecommendToRecheck' => '%%recheckWebsite%%— lo recomendamos tras cada intento de corrección.',
    'problem-report.recheckWebsite' => 'Vuelva a comprobar el sitio web manualmente',
    'problem-report.option' => 'Opción %%number%%:',
    'problem-report.recommended' => 'recomendado',
    'problem-report.numberOfEntries' => 'Nº entradas',
    'problem-report.logEntry' => 'Entrada de registro',
    'problem-report.logFile' => 'Archivo de registro',
    'problem-report.openWebsiteLogs' => 'Abrir registros del sitio web',
    'problem-report.thisIsServerWideProblem' => 'Se trata de una incidencia a nivel del servidor que afecta a todos los sitios web alojados',
    'problem-report.serverWideTitle' => 'Incidencia a nivel del servidor notificada',
    'problem-report.checkDetectedIssue' => 'La comprobación ha detectado la incidencia (Zona horaria del servidor - UTC%%timezone%%):',
    'problem-report.todayAt' => 'hoy a las %%time%%',
    'problem-report.yesterdayAt' => 'ayer a las %%time%%',
    'problem-report.dateAt' => '%%date%% a las %%time%%',
    'problem-report.firstProblemTime' => 'Primera vez - %%info%%',
    'problem-report.lastProblemTime' => 'Última vez - %%info%%',

    'distribution-over-time.title' => 'Distribución de la incidencia a lo largo del tiempo',
    'distribution-over-time.titleYesterday' => 'Distribución de la incidencia a lo largo del tiempo (Ayer)',
    'distribution-over-time.titleToday' => 'Distribución de la incidencia a lo largo del tiempo (Hoy)',
    'distribution-over-time.serverTimezone' => 'Zona horaria del servidor (UTC%%utcShift%%)',
    'distribution-over-time.yourTimezone' => 'Su zona horaria (UTC%%utcShift%%)',
    'distribution-over-time.weRecomendComparing' => 'Le recomendamos comparar el gráfico de distribución de errores con %%link%% en Monitoring',
    'distribution-over-time.resourceUsageCharts' => 'Gráficos de uso de recursos',
    'distribution-over-time.noDataForRecentTime' => 'Ningún dato recientemente. %%suggestion%%',
    'distribution-over-time.pleseEnableRegularCheck' => 'Active la verificación estándar o lleve a cabo una verificación manual del sitio web',
    'distribution-over-time.pleseIncludeWebsiteForCheck' => 'Incluya el sitio web en la lista de verificaciones estándar o lleve a cabo una verificación manual del sitio web',
    'distribution-over-time.pleaseWaitUntilRegularCheckWillBeStarted' => 'Espere a que se inicie la verificación estándar o lleve a cabo una verificación manual del sitio web',
    'distribution-over-time.enableRegularCheck' => 'Activar verificación estándar',
    'distribution-over-time.addWebsiteToRegularCheckList' => 'Añadir el sitio web a la lista de verificaciones estándar',
    'distribution-over-time.runManualCheck' => 'Ejecutar comprobación manual',

    'report.title' => 'Informe sobre la última verificación',
    'report.groupByWebsites' => 'Agrupados por sitios web',
    'report.groupByProblems' => 'Por incidencias',
    'report.columnWebsite' => 'Sitio web',
    'report.columnStatus' => 'Incidencias',
    'report.columnProblem' => 'Incidencia',
    'report.columnAppearedOn' => 'Detected on',
    'report.serverWideName' => 'Incidencias a nivel del servidor',
    'report.serverWideDescription' => 'Estas incidencias afectan a todo el servidor y a sus sitios web alojados.',
    'report.statusProblemsFound' => '%%count%% encontrados',
    'report.statusProblemsFoundFull' => '{count, plural, one {# incidencia detectada} other {# incidencias detectadas}}',
    'report.statusProblemsSolved' => '%%count%% desaparecieron',
    'report.statusProblemsSolvedFull' => '{count, plural, one {# incidencia desapareció} other {# incidencias desaparecieron}}',
    'report.statusSuccess' => 'Ninguna incidencia',
    'report.serverWide' => 'Todo el servidor',
    'report.appearedOn' => '{count, plural, one {# sitio web} other {# sitios web}}',
    'report.recheckWebsite' => 'Volver a comprobar el sitio web',
    'report.actionOpen' => 'Abrir',
    'report.actionManage' => 'Administrar',
    'report.actionLogs' => 'Ver registros',
    'report.searchWebsite' => 'Encontrar sitios web...',
    'report.searchProblem' => 'Detectando incidencias...',
    'report.groupByProblemsTotal' => '{totalRows, plural, one {# incidencia} other {# incidencias}} en {websitesCount, plural, one {# sitio web} other {# sitios web}}',
    'report.noProblemsTitle' => 'No se detectó ninguna incidencia en {websitesCount, plural, one {# sitio web} other {# sitios web}}',
    'report.noProblemsDescription' => 'Parece que trata a sus sitios web con mucho cariño. ¡Bien hecho!',

    'problems.columnTitle' => 'Incidencia',
    'problems.columnRegular' => 'Comprobación automática',
    'problems.columnManual' => 'Comprobación manual',
    'problems.run' => '%%fromTime%% %%fromDate%% - %%toTime%% %%toDate%%',
    'problems.runSameDay' => '%%fromTime%% - %%toTime%% el %%toDate%%',
    'problems.notRun' => 'todavía no realizado',
    'problems.resultDetected' => 'Detectado',
    'problems.resultNotDetected' => 'No detectado',
    'problems.resultNoProblems' => 'Ninguna incidencia',

    'new-check.title' => 'Comprobación manual',
    'new-check.titleForWebsite' => 'Comprobación manual de %%website%%',
    'new-check.titleRunning' => 'Comprobación manual de {count, plural, one {# sitio web} other {# sitios web}}',
    'new-check.description' => 'Se han seleccionado %%selected%% de %%total%% sitios web',
    'new-check.depth' => 'Periodo de comprobación',
    'new-check.checkTheLast' => 'Check the last',
    'new-check.selectHours' => 'Horas',
    'new-check.selectMinutes' => 'Minutos',
    'new-check.ifYouHaveAnyProblemActivities' => 'Si intentó corregir las incidencias del sitio web, establezca el periodo de tiempo tras este intento. De lo contrario, Plesk puede detectar incidencias que ya hayan sido resueltas.',
    'new-check.weAlsoRecommendVisiting' => 'Antes de efectuar una comprobación manual, le recomendamos %%visitingTheWebsite%% e intentar reproducir la incidencia.',
    'new-check.visitingTheWebsite' => 'visitar el sitio web',
    'new-check.hours' => 'últimas horas',
    'new-check.websites' => 'Sitios web a comprobar',
    'new-check.buttonSave' => 'Comprobar',
    'new-check.buttonCancel' => 'Cancelar',
    'new-check.search' => 'Encontrar sitios web...',
    'new-check.checkProblems' => 'Sitios web con incidencias durante la última comprobación',
    'new-check.allWebsites' => 'Todos los sitios web',
];