<?php
// Copyright 1999-2022. Plesk International GmbH. All rights reserved.
$messages = [
    'problem-detail.nginx-upstream-sent-too-big-header.name' => 'Nginx "502 Bad Gateway: upstream sent too big header while reading response header"',
    'problem-detail.nginx-upstream-sent-too-big-header.description' => 'To be ready soon.',
    'problem-detail.nginx-upstream-sent-too-big-header.cause' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.title' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.text' => '',
    'problem-detail.apache-followsymlinks-not-allowed.name' => 'Apache "Внутренняя ошибка сервера 500: опция FollowSymLinks не разрешена здесь"',
    'problem-detail.apache-followsymlinks-not-allowed.description' => 'To be ready soon.',
    'problem-detail.apache-followsymlinks-not-allowed.cause' => '',
    'problem-detail.phpfpm-server-reached-max-children.name' => 'PHP-FPM "server reached max_children setting"',
    'problem-detail.phpfpm-server-reached-max-children.description' => '<h4>Симптомы</h4><ul><li><p>На сайтах, где обработчик PHP установлен как <strong>приложение FPM, обслуживаемое Apache,</strong> или <strong>приложение FPM, обслуживаемое nginx,</strong> на странице <strong>Домены</strong> &gt; <strong>example.com</strong> &gt; <strong>Настройки PHP</strong> возникает одна из следующих проблем:</p><ul><li><p>медленная загрузка</p></li><li><p>отсутствие доступа (постоянно или периодически) с ошибкой 50x в ​​веб-браузере:</p><pre>502 Недопустимый шлюз</pre><hr><pre>503 Сервис временно недоступен</pre><hr><pre>504 Таймаут соединения со шлюзом</pre></li></ul></li><li><p>Следующее сообщение появляется в файле журнала ошибок PHP-FPM <code>/var/log/plesk-php<strong>XX</strong>-fpm/error.log</code> (где <em>XX</em> – версия PHP, используемая сайтами):</p><pre>ВНИМАНИЕ: для сервера [pool example.com] достигнуто значение настройки max_children (*), рассмотрите возможность его увеличения</pre><ul><li><p>Сообщение выше обычно сопровождается этой ошибкой:</p><pre>unable to read what child say: Bad file descriptor (9)</pre></li></ul></li><li><p>Если на сервере включен nginx, в файле журнала ошибок домена может появиться одно из следующих сообщений об ошибке <code>/var/www/vhosts/system/example.com/logs/proxy_error_log</code>:</p><pre style="white-space: pre-wrap;">[error] 11456#0: *118348 connect() to unix:///var/www/vhosts/system/example.com/php-fpm.sock failed (11: Resource temporarily unavailable) while connecting to upstream, client: 203.0.113.2, server: example.com, request: "GET / HTTP/1.1", upstream: "fastcgi://unix:///var/www/vhosts/system/example.com/php-fpm.sock:", host: "example.com"</pre><hr><pre style="white-space: pre-wrap;">[error] 20058#0: *4725139 upstream prematurely closed connection while reading response header from upstream, client: 203.0.113.2, server: example.com, request: "POST /path/to/some/file HTTP/2.0", upstream:</pre></li></ul>',
    'problem-detail.phpfpm-server-reached-max-children.cause' => ' <p>Сайты достигли PHP-FPM <code>pm.max_children</code>.</p>',
    'problem-detail.phpfpm-server-reached-max-children.solution1.title' => 'Увеличить лимит pm.max_children',
    'problem-detail.phpfpm-server-reached-max-children.solution1.text' => '<p>Увеличьте ограничение <code>pm.max_children</code> для затронутых доменов:</p><ol><li><p>Подключитесь к серверу Plesk через <a href="https://support.plesk.com/hc/en-us/articles/115000172834" target="_blank" rel="noopener">SSH</a>.</p></li><li><p>Найдите затронутые домены с помощью команды ниже:</p><div class="pul-alert pul-alert--info pul-status-message pul-status-message--info"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Примечание:</strong> Число слева показывает, сколько раз сайт достиг предела <code>pm.max_children</code>.</div><pre style="white-space: pre-wrap;"># grep -r "server reached max_children setting" /var/log/*php*-fpm/error.log | cut -d\' \' -f5 | tr -d \']\' | sort | uniq -c | sort -nr<br><br>100 example.com<br>50 example.net<br>25 example.org<br>&lt;...&gt;</pre></li><li><p><a href="https://support.plesk.com/hc/en-us/articles/213413369" target="_blank" rel="noopener">Войдите в Plesk</a>.</p></li><li><p>Перейдите на страницу <strong>Домены</strong> &gt; <strong>example.com</strong> &gt; <strong>Настройки PHP</strong> &gt; <strong>Настройки PHP-FPM</strong>.</p></li><li><p>Увеличьте значение <code>pm.max_children</code> для домена и примените изменения. Увеличьте это значение для всех доменов, перечисленных на шаге 2.</p></li></ol>',
    'problem-detail.nginx-too-many-open-files.name' => 'Nginx "Слишком много открытых файлов"',
    'problem-detail.nginx-too-many-open-files.description' => '<p>nginx не запускается/не перезагружается на сервере Plesk: слишком много открытых файлов</p><h4>Симптомы</h4><ul><li><p>Служба nginx не запускается/не перезагружается со следующей ошибкой в файле <code>/var/log/nginx/error.log</code>:</p><pre style="white-space: pre-wrap;">nginx: [emerg] open() "/var/www/vhosts/system/example.com/logs/proxy_access_ssl_log" failed (24: Too many open files)</pre></li><li><p>Некоторые или все сайты недоступны</p></li><li><p>Предупреждение отображается в разделе <strong>Инструменты и настройки &gt; Диагностировать и исправить</strong>:</p><pre style="white-space: pre-wrap;">Проверка значения ULIMIT nginx На сервере найдено N доменов. Возможна проблема с лимитом nginx по умолчанию для открытых файлов</pre></li><li><p>Веб-приложения NodeJS и Ruby показывают ошибку 502 Недопустимый шлюз при выполнении некоторых задач Plesk, таких как создание доменов, подписок, изменения в Apache или Nginx и т. д.:</p><pre style="white-space: pre-wrap;">Ошибка сервера<br>502 Недопустимый шлюз <br>Веб-сервер получил неверный ответ, выступая в качестве шлюза или прокси-сервера.</pre></li><li><p>После <a href="https://support.plesk.com/hc/en-us/articles/213946825-How-to-install-SSL-certificate-for-a-domain-in-Plesk" target="_blank" rel="noopener noreferrer">установки нового сертификата для домена</a>, старый по-прежнему отображается в браузере, однако правильный сертификат можно выбрать на странице <strong>Домены &gt; example.com &gt; Настройки хостинга</strong>.</p></li></ul>',
    'problem-detail.nginx-too-many-open-files.cause' => '<p>Виртуальный хост nginx открывает 4 файла журнала для каждого виртуального хоста с физическим хостингом:</p><ul><li>proxy_access_log</li><li>proxy_access_ssl_log</li><li>webmail_access_log</li><li>webmail_access_ssl_log</li></ul><p>В результате сервер nginx превышает максимальное количество открытых файлов из-за большого количества доменов (обычно более 100).</p>',
    'problem-detail.nginx-too-many-open-files.solution1.title' => 'Увеличить лимит открытых файлов',
    'problem-detail.nginx-too-many-open-files.solution1.text' => '<div class="pul-alert pul-alert--warning pul-status-message pul-status-message--warning"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Внимание!</strong> Выполнение утилиты <code>websrv_ulimits</code> без опции <strong>--no-restart</strong> запускает пересборку файлов веб-конфигурации для всех доменов и может привести к значительному простою в случае большого количества размещенных сайтов.<br><br>Выполните команду в течение периода обслуживания.</div><p>Рекомендуется установить значение лимита открытых файлов по меньшей мере больше, чем <strong>количество доменов в Plesk * 16</strong>. В приведенном ниже примере приведены действия, как установить ограничение на 4096:</p><ol><li><p>Подключитесь к серверу через <a href="https://support.plesk.com/hc/en-us/articles/115000172834" target="_blank" rel="noopener noreferrer">SSH</a></p></li><li><p>Установите ограничение на количество открытых файлов до 4096 для Apache и Nginx:</p><pre># /usr/local/psa/admin/sbin/websrv_ulimits --set 4096 --no-restart</pre></li><li><p>Перезапустите службы Apache и nginx в <strong><a href="https://support.plesk.com/hc/en-us/articles/213413369" target="_blank" rel="noopener noreferrer">Plesk</a> &gt;</strong> <strong>Инструменты и настройки &gt; Управление службами</strong>, чтобы применить изменения.</p></li><li><p>Проверьте правильность применения параметра "Максимальное ограничение количества открытых файлов" после перезапуска веб-служб:</p><pre># grep \'Max open files\' /proc/$(cat /var/run/nginx.pid)/limits<br>Max open files 4096 4096 file</pre></li><li><p>Если приведенное выше решение не поможет, установите ограничение с помощью утилиты <code>ulimit</code>:</p><pre># ulimit -n 4096</pre></li></ol>',
    'problem-detail.apache-modsec-response-body-too-large.name' => 'ModSecurity "Слишком большое тело ответа"',
    'problem-detail.apache-modsec-response-body-too-large.description' => 'To be ready soon.',
    'problem-detail.apache-modsec-response-body-too-large.cause' => '',
    'problem-detail.modsec-access-denied.name' => 'ModSecurity "Отказано в доступе с кодом 403"',
    'problem-detail.modsec-access-denied.description' => '<h4>Symptoms</h4><ul><li><p>ModSecurity is installed and enabled in <strong>Tools & Settings > Web Application Firewall (ModSecurity) > Web application firewall mode > On</strong>.</p></li><li>A website hosted in Plesk fails to load. It is not possible to perform operations on the website such as manage WordPress, access webmail, or access <code>robots.txt</code> file. The browser can display one of the following errors: <pre>ERR_CONNECTION_REFUSED</pre><hr><pre>403 Forbidden</pre><hr><pre>500 Internal Server Error</pre><hr><pre>ERR_CONNECTION_TIMED_OUT</pre></li><li>A ModSecurity error message like the one below appears in the <code>/var/log/modsec_audit.log</code> log file or on the Logs page in Plesk (<strong>Domains</strong> &gt; <strong>example.com</strong> &gt; <strong>Logs</strong>): <pre>ModSecurity: Access denied with code 403 (phase 2). Operator GE matched 5 at TX:anomaly_score. [file "/etc/apache2/modsecurity.d/rules/owasp_modsecurity_crs_3-plesk/REQUEST-949-BLOCKING-EVALUATION.conf"] [line "57"] [id "949110"] [msg "Inbound Anomaly Score Exceeded (Total Score: 5)"] [severity "CRITICAL"] [tag "application-multi"] [tag "language-multi"] [tag "platform-multi"] [tag "attack-generic"] [hostname "example.com"] [uri "/robots.txt"] [unique_id "XPsROH8AAQEAABEiZFcAAABC"]</pre></li>',
    'problem-detail.modsec-access-denied.cause' => '<p>ModSecurity Web Application Firewall is enabled with a very restrictive rule set such as OWASP, Comodo, or a custom rule set like Imunify360. Restrictive rule sets can block some operations on the website.</p><p><Strong>Note:</strong> The ModSecurity error might indicate an attack on your server. Use the solutions below only if you are sure that ModSecurity blocks valid usage of your website.</p>',
    'problem-detail.modsec-access-denied.solution1.title' => 'Disable the ModSecurity rule set by ID or Tag',
    'problem-detail.modsec-access-denied.solution1.text' => '<ol><li><p>Find the ID of the rule that blocks the legitimate usage of your website. You can find the IDs inside error messages in the <code>/var/log/modsec_audit.log</code> lof file. The ID is an integer number in quotation marks with the prefix <code>id</code> in square brackets, for example, <strong>[id "210831"]</strong>.</p></li><li><a href="https://support.plesk.com/hc/en-us/articles/115002531753" target="_blank" rel="noopener">Disable specific rule sets in Plesk</a>.</li></ol>',
    'problem-detail.modsec-access-denied.solution2.title' => 'Switch to another ModSecurity rule set',
    'problem-detail.modsec-access-denied.solution2.text' => '<ol><li><p>Switch to a less restrictive ModSecurity rule set, for example, "Atomic ModSecurity Ruleset". To do so, go to <strong>Tools & Settings</strong> > <strong>Web Application Firewall (ModSecurity)</strong> > <strong>Settings</strong>, select <strong>Atomic Standard</strong>, and then click <strong>OK</strong> to apply the changes.</p></li></ol>',
    'problem-detail.php-allowed-memory-size-exhausted.name' => 'PHP "Внутренняя ошибка сервера 500: допустимый размер памяти XXX исчерпан"',
    'problem-detail.php-allowed-memory-size-exhausted.description' => '<h4>Symptoms</h4><ul><li><p>A website hosted in Plesk is not accessible:</p><pre>500 Internal Server Error</pre></li><li><p>The following error is shown in the website log:</p><pre>Got error "PHP message: PHP Fatal error: Allowed memory size of 4194304 bytes exhausted (tried to allocate 4000032 bytes) in /var/www/vhosts/try.me/httpdocs/somethingBig.php on line 3</pre></li> </ul>',
    'problem-detail.php-allowed-memory-size-exhausted.cause' => '<p>The website does not have enough memory allocated to be processed.</p>',
    'problem-detail.php-allowed-memory-size-exhausted.solution1.title' => 'Increase memory_limit of the website',
    'problem-detail.php-allowed-memory-size-exhausted.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/115000304194" target="_blank" rel="noopener">Read the KB article and follow the instructions</a>.</p></li></ol>',
    'problem-detail.php-open-basedir-restriction-in-effect.name' => 'PHP "действует ограничение open_basedir"',
    'problem-detail.php-open-basedir-restriction-in-effect.description' => '<h4>Symptoms</h4><ul><li><p>A website is not accessible with one of the following errors in the web browser:</p><pre>404 file not found</pre><hr><pre>500 Internal Server Error</pre><hr><pre>Error 500 move_uploaded_file(): open_basedir restriction in effect. File(/path/to/the/directory) is not within the allowed path(s): (/var/www/vhosts/example.com/:/tmp/)</pre></li><li><p>The following error message appears on the domain\'s Logs page (<strong>Domains</strong> > <strong>example.com</strong> > <strong>Logs</strong>):</p><pre><...> open_basedir restriction in effect. File(/path/to/the/directory) is not within the allowed path(s) <...></pre><hr><pre>Uncaught Exception: Session: Configured save path "/path/to/the/directory" is not a directory, doesn\'t exist or cannot be created.</pre></li></ul>',
    'problem-detail.php-open-basedir-restriction-in-effect.cause' => 'The PHP script is trying to access the directory for which access is not allowed. This restriction is defined by the PHP <code>open_basedir</code> directive individually for each domain. By default, <code>open_basedir</code> allows access to the <code>tmp</code> and domain\'s document root directories, as well as the system\'s default sessions path.',
    'problem-detail.php-open-basedir-restriction-in-effect.solution1.title' => 'Add the additional path to the open_basedir directive',
    'problem-detail.php-open-basedir-restriction-in-effect.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/115000278993" target="_blank" rel="noopener">Read the KB article and follow the instructions</a>.</p></li></ol>',
    'problem-detail.php-open-basedir-restriction-in-effect.solution2.title' => 'Disable the open_basedir directive',
    'problem-detail.php-open-basedir-restriction-in-effect.solution2.text' => '<ol><li><p>Go to <strong>Domains &gt example.com &gt PHP Settings</strong> page and set the <code>open_basedir</code> directive to "none".</p></li></ol>',
    'problem-detail.apache-client-denied-by-server.name' => 'Apache .htaccess "403 Доступ запрещен AH01797: клиент отклонен конфигурацией сервера"',
    'problem-detail.apache-client-denied-by-server.description' => '<h4>Symptoms</h4><ul><li><p>The website shows an error similar to the following one:</p><pre>Server Error 403<br>Forbidden</pre></li><li><p>The <code>/var/www/vhosts/system/example.com/logs/error_log</code> log file contains errors like the following one:</p><pre>AH01797: client denied by server configuration: /var/www/vhosts/example.com/index.php</pre></li></ul>',
    'problem-detail.apache-client-denied-by-server.cause' => '<p>Custom Apache configuration does not allow access to the website.</p>',
    'problem-detail.apache-client-denied-by-server.solution1.title' => 'Check the server configuration and .htaccess files',
    'problem-detail.apache-client-denied-by-server.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/214528485" target="_blank" rel="noopener">Read the KB article and follow the instructions</a>.</p></li></ol>',
    'problem-detail.apache-no-directory-index.name' => 'Apache "Не удается получить доступ к каталогу сайта в Plesk: 403 Доступ запрещен"',
    'problem-detail.apache-no-directory-index.description' => '<h4>Symptoms</h4><ul><li><p>Cannot access a specific location of a website, for example, <code>http://example.com/some_folder</code>. The following error occurs:</p><pre>Server Error 403<br>Forbidden</pre></li><li><p>The following error appears in the <code>/var/www/vhosts/example.com/logs/error_log<code/> file:</p><pre>[autoindex:error] [pid 16314:tid 140300215322368] [client 203.0.113.2:55714] AH01276: Cannot serve directory /var/www/vhosts/example.com/httpdocs/some_folder/: No matching DirectoryIndex (index.html,index.cgi,index.pl,index.php,index.xhtml,index.htm,index.shtml) found, and server-generated directory index forbidden by Options directive</pre></li></ul>',
    'problem-detail.apache-no-directory-index.cause' => '<p>The requested directory does not contain index files or directory browsing is not enabled.</p>',
    'problem-detail.apache-no-directory-index.solution1.title' => 'Add an index file to the directory',
    'problem-detail.apache-no-directory-index.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/214528485" target="_blank" rel="noopener">Read the KB article and follow the instructions</a>.</p></li></ol>',
    'problem-detail.apache-no-directory-index.solution2.title' => 'Enable directory browsing',
    'problem-detail.apache-no-directory-index.solution2.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/360002534354" target="_blank" rel="noopener">Read the KB article and follow the instructions</a>.</p></li></ol>',
    'problem-detail.nginx-no-directory-index.name' => 'Nginx "Не удается получить доступ к каталогу сайта в Plesk: 403 Доступ запрещен"',
    'problem-detail.nginx-no-directory-index.description' => '<h4>Symptoms</h4><ul><li><p>Cannot access a specific location of a website, for example, <code>http://example.com/some_folder</code>. The following error occurs:</p><pre>Server Error 403<br>Forbidden</pre></li><li><p>The following error appears in the <code>/var/www/vhosts/example.com/logs/error_log file</code>:</p><pre>[autoindex:error] [pid 16314:tid 140300215322368] [client 203.0.113.2:55714] AH01276: Cannot serve directory /var/www/vhosts/example.com/httpdocs/some_folder/: No matching DirectoryIndex (index.html,index.cgi,index.pl,index.php,index.xhtml,index.htm,index.shtml) found, and server-generated directory index forbidden by Options directive</pre></li></ul>',
    'problem-detail.nginx-no-directory-index.cause' => '<p>The requested directory does not contain index files or directory browsing is not enabled.</p>',
    'problem-detail.nginx-no-directory-index.solution1.title' => 'Add an index file to the directory',
    'problem-detail.nginx-no-directory-index.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/214528485" target="_blank" rel="noopener">Read the KB article and follow the instructions</a>.</p></li></ol>',
    'problem-detail.nginx-no-directory-index.solution2.title' => 'Enable directory browsing',
    'problem-detail.nginx-no-directory-index.solution2.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/360002534354" target="_blank" rel="noopener">Read the KB article and follow the instructions</a>.</p></li></ol>',
    'problem-detail.apache-reached-max-request-workers.name' => 'Apache "сервер достиг настройки MaxRequestWorkers"',
    'problem-detail.apache-reached-max-request-workers.description' => 'To be ready soon.',
    'problem-detail.apache-reached-max-request-workers.cause' => '',
    'problem-detail.php-post-content-length-exceeds-limit.name' => 'Ограничение тела запроса PHP "клиент намеревался отправить слишком большой запрос"',
    'problem-detail.php-post-content-length-exceeds-limit.description' => 'To be ready soon.',
    'problem-detail.php-post-content-length-exceeds-limit.cause' => '',
    'problem-detail.nginx-client-sent-too-large-body.name' => 'Ограничение тела запроса PHP "клиент намеревался отправить слишком большой запрос"',
    'problem-detail.nginx-client-sent-too-large-body.description' => 'To be ready soon.',
    'problem-detail.nginx-client-sent-too-large-body.cause' => '',
    'problem-detail.php-failed-to-read-session-data.name' => 'Сеансы PHP "503 Внутренняя ошибка сервера" или "Не удалось прочитать данные сеанса"',
    'problem-detail.php-failed-to-read-session-data.description' => 'To be ready soon.',
    'problem-detail.php-failed-to-read-session-data.cause' => '',
    'problem-detail.apache-unable-to-check-htaccess-file.name' => 'Apache .htaccess "403 Доступ запрещен: pcfg_openfile: невозможно проверить файл htaccess, убедитесь, что он читаем"',
    'problem-detail.apache-unable-to-check-htaccess-file.description' => '<h4>Symptoms</h4><ul><li><p>A website hosted in Plesk is not working:</p><pre>You don\'t have permission to access / on this server. <br> Additionally, a 403 Forbidden error was encountered while trying to use an ErrorDocument to handle the request.</pre><p>Instead of the above error, you can also see the blank page.</p></li><li><p>The domain error log in <strong>Domains &gt example.com &gt Logs</strong> contains the following:</p><pre>(13)Permission denied: [client 203.0.113.2:39024] AH00529: /var/www/vhosts/example.com/httpdocs/.htaccess pcfg_openfile: unable to check htaccess file, ensure it is readable and that "/var/www/vhosts/example.com/httpdocs/" is executable</pre></li></ul>',
    'problem-detail.apache-unable-to-check-htaccess-file.cause' => 'Incorrect permissions for the domain\'s files or folders.',
    'problem-detail.apache-unable-to-check-htaccess-file.solution1.title' => 'Repair permissions for the website content',
    'problem-detail.apache-unable-to-check-htaccess-file.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/213939685" target="_blank" rel="noopener">Read the KB article and follow the instructions</a>.</p></li></ol>',
];