<?php
// Copyright 1999-2022. Plesk International GmbH. All rights reserved.
$messages = [
    'problem-detail.nginx-upstream-sent-too-big-header.name' => 'Nginx "502 잘못된 게이트웨이: 응답 헤더를 읽는 동안 업스트림이 너무 큰 헤더를 보냈습니다"',
    'problem-detail.nginx-upstream-sent-too-big-header.description' => '준비 중입니다.',
    'problem-detail.nginx-upstream-sent-too-big-header.cause' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.title' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.text' => '',
    'problem-detail.apache-followsymlinks-not-allowed.name' => 'Apache "500 내부 서버 오류: FollowSymLinks 옵션이 허용되지 않습니다"',
    'problem-detail.apache-followsymlinks-not-allowed.description' => '준비 중입니다.',
    'problem-detail.apache-followsymlinks-not-allowed.cause' => '',
    'problem-detail.phpfpm-server-reached-max-children.name' => 'PHP-FPM "서버가 max_children 설정에 도달했습니다"',
    'problem-detail.phpfpm-server-reached-max-children.description' => '<h4>증상</h4><ul><li><p>PHP 핸들러가 <strong>Apache에서 제공하는 FPM 애플리케이션</strong> 또는 <strong>nginx에서 제공하는 FPM 애플리케이션</strong>으로 설정된 웹사이트 <strong>도메인</strong> &gt; <strong>example.com</strong> &gt; <strong>PHP 설정에서</strong> 다음 문제 중 하나가 발생합니다:</p><ul><li><p>천천히 로드</p></li><li><p>웹 브라우저에서 (주기적 또는 영구적으로) 50x 오류로 액세스할 수 없음:</p><pre>502 잘못된 게이트웨이</pre><hr><pre>503 서비스를 일시적으로 사용할 수 없음</pre><hr><pre>504 게이트웨이 시간 초과</pre></li></ul></li><li><p>PHP-FPM 오류 로그 파일에 다음 메시지가 나타납니다 <code>/var/log/plesk-php<strong>XX</strong>-fpm/error.log</code> (여기서 <em>XX</em>는 웹 사이트에서 사용하는 PHP 버전):</p><pre>경고: [pool example.com] 서버가 max_children 설정 (*)에 도달, 설정을 높이는 것이 좋습니다.</pre><ul><li><p>위 메시지는 일반적으로 다음 오류와 함께 표시됩니다:</p><pre>어린이가 말하는 내용을 읽을 수 없음: 잘못된 파일 설명자 (9)</pre></li></ul></li><li><p>nginx가 서버에서 활성화된 경우 도메인의 오류 록 파일 <code>/var/www/vhosts/system/example.com/logs/proxy_error_log</code>에 다음 오류 메시지 중 하나가 나타날 수 있습니다:</p><pre style="white-space: pre-wrap;">[error] 11456#0: *118348 unix:///var/www/vhosts/system/example.com/php-fpm.sock에 연결() 실패 (11: 리소스를 일시적으로 사용할 수 없음) 업스트림에 연결하는 동안 클라이언트: 203.0.113.2, 서버: example.com, 요청: "GET / HTTP/1.1", 업스트림: "fastcgi://unix:///var/www/vhosts/system/example.com/php-fpm.sock:", 호스트: "example.com"</pre><hr><pre style="white-space: pre-wrap;">[error] 20058#0: *4725139 업스트림에서 응답 헤더를 읽는 동안 업스트림 연결이 너무 일찍 닫혔습니다, 클라이언트: 203.0.113.2, 서버: example.com, 요청: "POST /path/to/some/file HTTP/2.0", 업스트림:</pre></li></ul>',
    'problem-detail.phpfpm-server-reached-max-children.cause' => ' <p>웹사이트에서 PHP-FPM <code>pm.max_children</code>에 도달했습니다.</p>',
    'problem-detail.phpfpm-server-reached-max-children.solution1.title' => 'pm.max_children 제한 증가',
    'problem-detail.phpfpm-server-reached-max-children.solution1.text' => '<p>영향을 받는 도메인에 대한 <code>pm.max_children</code> 제한을 늘립니다:</p><ol><li><p>Plesk 서버에 <a href="https://support.plesk.com/hc/en-us/articles/115000172834" target="_blank" rel="noopener">SSH를 통해 연결</a>.</p></li><li><p>아래 명령을 사용하여 영향을 받는 도메인 찾기:</p><div class="pul-alert pul-alert--info pul-status-message pul-status-message--info"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>참고:</strong> 왼쪽의 숫자는 웹사이트에서 <code>pm.max_children</code> 제한에 도달한 횟수를 나타냅니다.</div><pre style="white-space: pre-wrap;"># grep -r "서버가 max_children 설정에 도달했습니다" /var/log/*php*-fpm/error.log | cut -d\' \' -f5 | tr -d \']\' | sort | uniq -c | sort -nr<br><br>100 example.com<br>50 example.net<br>25 example.org<br>&lt;...&gt;</pre></li><li><p><a href="https://support.plesk.com/hc/en-us/articles/213413369" target="_blank" rel="noopener">Plesk</a>.</p></li><li><p>다음 <strong>도메인으로 이동</strong> &gt; <strong>example.com</strong> &gt; <strong>PHP 설정</strong> &gt; <strong>PHP-FPM 설정</strong>.</p></li><li><p>도메인의 <code>pm.max_children</code> 값을 늘리고 변경 사항을 적용합니다. 2단계에 나열된 모든 도메인에 대해 이 값을 늘립니다.</p></li></ol>',
    'problem-detail.nginx-too-many-open-files.name' => 'Nginx "열린 파일이 너무 많음"',
    'problem-detail.nginx-too-many-open-files.description' => '<p>nginx가 Plesk 서버에서 시작/다시 로드하지 못함: 열려있는 파일이 너무 많음</p><h4>증상</h4><ul><li><p>nginx 서비스가 다음과 함께 시작/다시 로드하지 못함 <code>/var/log/nginx/error.log</code> 파일의 오류:</p><pre style="white-space: pre-wrap;">nginx: [emerg] open()
"/var/www/vhosts/system/example.com/logs/proxy_access_ssl_log" 실패 (24: 열린 파일이 너무 많음)</pre></li><li><p>일부 또는 모든 웹사이트에 액세스할 수 없음</p></li><li><p>경고가 <strong>도구 &amp; 설정 &gt; 진단 &amp; 수리</strong>에 표시됩니다:</p><pre style="white-space: pre-wrap;">nginx ULIMIT 값 확인 N 도메인이 서버에서 발견되었습니다. 열린 파일에 대한 nginx 기본 제한 문제가 발생할 수 있습니다</pre></li><li><p>NodeJS 및 Ruby 웹 응용 프로그램은 도메인 생성, 구독, Apache 또는 Nginx 변경 등과 같은 일부 Plesk 작업을 수행할 때 502 잘못된 Gateway 오류를 표시합니다:</p><pre style="white-space: pre-wrap;">서버 오류<br>502 잘못된 Gateway <br>웹 서버가 게이트웨이 또는 프록시 서버 역할을 하는 동안 잘못된 응답을 받았습니다.</pre></li><li><p>도메인에 대한<a href="https://support.plesk.com/hc/en-us/articles/213946825-How-to-install-SSL-certificate-for-a-domain-in-Plesk" target="_blank" rel="noopener noreferrer">새 인증서를 설치한 후</a>, 이전 인증서는 웹 브라우저에 계속 표시되지만, <strong>도메인 &gt; example.com &gt; 호스팅 설정</strong> 페이지에서 올바른 인증서가 선택됩니다.</p></li></ul>',
    'problem-detail.nginx-too-many-open-files.cause' => '<p>Nginx의 가상 호스트는 물리적 호스팅이 있는 각 가상 호스트에 대해 4개의 로그 파일을 엽니다:</p><ul><li>proxy_access_log</li><li>proxy_access_ssl_log</li><li>webmail_access_log</li><li>webmail_access_ssl_log</li></ul><p>이 사실의 결과로 많은 수의 도메인(보통 100개 이상)으로 인해 nginx 서버에서 최대 열린 파일 수를 초과했습니다.</p>',
    'problem-detail.nginx-too-many-open-files.solution1.title' => '열린 파일 제한 증가',
    'problem-detail.nginx-too-many-open-files.solution1.text' => '<div class="pul-alert pul-alert--warning pul-status-message pul-status-message--warning"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>경고:</strong><code>websrv_ulimits</code> 유틸리티를 실행할 때 <strong>--다시 시작 안 함</strong> 옵션 없이 실행하면 모든 도메인에 대한 웹 구성 파일의 재구축이 시작되며 호스팅된 웹 사이트의 수가 많은 경우 상당한 다운타임이 발생할 수 있습니다.<br><br>유지 관리 기간 동안 명령을 실행합니다.</div><p>열린 파일 제한 값을 <strong>Plesk의 도메인 수 * 16</strong> 이상으로 설정하는 것이 좋습니다. 아래 예시에서 제한을 4096으로 설정하는 방법을 제공했습니다:</p><ol><li><p>다음 <a href="https://support.plesk.com/hc/en-us/articles/115000172834" target="_blank" rel="noopener noreferrer">SSH를 통해 서버에 연결</a></p></li><li><p>Apache 및 Nginx 모두에 대해 열린 파일 제한을 4096으로 설정:</p><pre># /usr/local/psa/admin/sbin/websrv_ulimits --4096 설정 --다시 시작 안 함</pre></li><li><p>변경 사항을 적용하려면 <strong><a href="https://support.plesk.com/hc/en-us/articles/213413369" target="_blank" rel="noopener noreferrer">Plesk</a> &gt;</strong> <strong>도구 &amp; 설정 &gt; 서비스 관리</strong>에서 Apache 및 nginx 서비스를 다시 시작하십시오.</p></li><li><p>웹 서비스를 다시 시작한 후 \'최대 파일 열기 제한\'이 제대로 적용되었는지 확인:</p><pre># grep \'최대 파일 열기\' /proc/$(cat /var/run/nginx.pid)/limits<br>최대 열린 파일 수 4096 4096 파일</pre></li><li><p>위 해결 방법이 도움이 되지 않으면 <code>ulimit</code> 유틸리티를 사용하여 제한을 설정하십시오:</p><pre># ulimit -n 4096</pre></li></ol>',
    'problem-detail.apache-modsec-response-body-too-large.name' => 'ModSecurity "응답 본문이 너무 큼"',
    'problem-detail.apache-modsec-response-body-too-large.description' => '준비 중입니다.',
    'problem-detail.apache-modsec-response-body-too-large.cause' => '',
    'problem-detail.modsec-access-denied.name' => 'ModSecurity "코드 403으로 액세스가 거부되었습니다"',
    'problem-detail.modsec-access-denied.description' => '<h4>증상</h4><ul><li><p>ModSecurity가 설치되었으며 "<strong>도구 및 설정 > 웹 응용 프로그램 방화벽(ModSecurity) > 웹 응용 프로그램 방화벽 모드 > 켜짐</strong>"에서 활성화되었습니다.</p></li><li>Plesk에 호스팅된 웹 사이트가 로드되지 않습니다. 웹사이트에서 WordPress에서 관리, 웹메일 액세스, <code>robots.txt</code> 파일 액세스 등의 작업을 수행할 수 없습니다. 브라우저에 다음 오류 중 하나가 표시될 수 있습니다: <pre>ERR_CONNECTION_REFUSED</pre><hr><pre>403 Forbidden</pre><hr><pre>500 Internal Server Error</pre><hr><pre>ERR_CONNECTION_TIMED_OUT</pre></li><li>다음과 같은 ModSecurity 오류 메시지가 <code>/var/log/modsec_audit.log</code> 로그 파일 또는 Plesk의 로그 페이지(<strong>도메인</strong> &gt; <strong>example.com</strong> &gt; <strong>로그</strong>)에 등장합니다: <pre>ModSecurity: Access denied with code 403 (phase 2). Operator GE matched 5 at TX:anomaly_score. [file "/etc/apache2/modsecurity.d/rules/owasp_modsecurity_crs_3-plesk/REQUEST-949-BLOCKING-EVALUATION.conf"] [line "57"] [id "949110"] [msg "Inbound Anomaly Score Exceeded (Total Score: 5)"] [severity "CRITICAL"] [tag "application-multi"] [tag "language-multi"] [tag "platform-multi"] [tag "attack-generic"] [hostname "example.com"] [uri "/robots.txt"] [unique_id "XPsROH8AAQEAABEiZFcAAABC"]</pre></li>',
    'problem-detail.modsec-access-denied.cause' => '<p>ModSecurity 웹 응용 프로그램 방화벽이 OWASP, Comodo 또는 Imunify360와 같은 사용자 지정 규칙 집합 등 매우 제한적인 규칙 집합으로 활성화되어 있습니다. 제한적인 규칙을 사용하면 웹사이트에서 일부 작업이 차단될 수 있습니다.</p><p><Strong>참고:</strong> ModSecurity 오류가 표시될 경우 서버가 공격받고 있을 수 있습니다. ModSecurity가 웹 사이트의 유효한 사용을 차단하고 있다고 확신할 때에만 다음 해결법을 사용하십시오.</p>',
    'problem-detail.modsec-access-denied.solution1.title' => 'ID 또는 태그로 ModSecurity 규칙 집합을 비활성화하십시오.',
    'problem-detail.modsec-access-denied.solution1.text' => '<ol><li><p>웹 사이트의 적법한 사용을 차단하고 있는 규칙의 ID를 찾으십시오. ID는 <code>/var/log/modsec_audit.log</code> lof 파일 내의 오류 메시지에서 확인할 수 있습니다. ID는 대괄호 안에 <code>id</code> 접미어 뒤에 있는 정수입니다(예: <strong>[id "210831"]</strong>).</p></li><li><a href="https://support.plesk.com/hc/en-us/articles/115002531753" target="_blank" rel="noopener">Plesk에서 특정 규칙 집합 비활성화하기</a>.</li></ol>',
    'problem-detail.modsec-access-denied.solution2.title' => '다른 ModSecurity 규칙 집합으로 변경하십시오.',
    'problem-detail.modsec-access-denied.solution2.text' => '<ol><li><p>"Atomic ModSecurity Ruleset" 등 덜 제한적인 ModSecurity 규칙 집합으로 변경하십시오. 변경하려면 <strong>도구 및 설정</strong> > <strong>웹 응용 프로그램 방화벽(ModSecurity)</strong> > <strong>설정</strong>으로 이동한 후, <strong>Atomic Standard</strong>를 선택한 다음 <strong>확인</strong>을 클릭하여 변경 사항을 적용하십시오.</p></li></ol>',
    'problem-detail.php-allowed-memory-size-exhausted.name' => 'PHP "내부 서버 오류 500: XXX의 허용된 메모리 용량이 소진되었습니다"',
    'problem-detail.php-allowed-memory-size-exhausted.description' => '<h4>증상</h4><ul><li><p>Plesk에 호스팅된 웹 사이트에 액세스할 수 없습니다:</p><pre>500 Internal Server Error</pre></li><li><p>웹 사이트 로그에 다음 오류가 표시됩니다:</p><pre>Got error "PHP message: PHP Fatal error: Allowed memory size of 4194304 bytes exhausted (tried to allocate 4000032 bytes) in /var/www/vhosts/try.me/httpdocs/somethingBig.php on line 3</pre></li> </ul>',
    'problem-detail.php-allowed-memory-size-exhausted.cause' => '<p>웹 사이트에 할당된 메모리가 부족하여 처리할 수 없습니다.</p>',
    'problem-detail.php-allowed-memory-size-exhausted.solution1.title' => '웹 사이트의 memory_limit을 늘리십시오.',
    'problem-detail.php-allowed-memory-size-exhausted.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/115000304194" target="_blank" rel="noopener">KB 문서를 읽고 지침을 따르십시오</a>.</p></li></ol>',
    'problem-detail.php-open-basedir-restriction-in-effect.name' => 'PHP "open_basedir 제한 적용 중"',
    'problem-detail.php-open-basedir-restriction-in-effect.description' => '<h4>증상</h4><ul><li><p>웹 사이트에 액세스할 수 없으며 웹 브라우저에 다음 오류 중 하나가 표시됩니다:</p><pre>404 file not found</pre><hr><pre>500 Internal Server Error</pre><hr><pre>Error 500 move_uploaded_file(): open_basedir restriction in effect. File(/path/to/the/directory) is not within the allowed path(s): (/var/www/vhosts/example.com/:/tmp/)</pre></li><li><p>도메인의 로그 페이지(<strong>도메인</strong> > <strong>example.com</strong> > <strong>로그</strong>)에 다음 오류 메시지가 표시됩니다:</p><pre><...> open_basedir restriction in effect. File(/path/to/the/directory) is not within the allowed path(s) <...></pre><hr><pre>Uncaught Exception: Session: Configured save path "/path/to/the/directory" is not a directory, doesn\'t exist or cannot be created.</pre></li></ul>',
    'problem-detail.php-open-basedir-restriction-in-effect.cause' => 'PHP 스크립트가 액세스가 허용되지 않은 디렉터리에 액세스를 시도하고 있습니다. 이 제한은 도메인마다 개별적으로 PHP <code>open_basedir</code> 지시문에 의해 정의됩니다. 기본적으로 <code>open_basedir</code>는 <code>tmp</code>, 도메인의 문서 루트 디렉터리, 시스템의 기본 세션 경로에 대한 액세스를 허용합니다.',
    'problem-detail.php-open-basedir-restriction-in-effect.solution1.title' => 'open_basedir 지시문에 경로를 하나 더 추가하십시오.',
    'problem-detail.php-open-basedir-restriction-in-effect.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/115000278993" target="_blank" rel="noopener">KB 문서를 읽고 지침을 따르십시오</a>.</p></li></ol>',
    'problem-detail.php-open-basedir-restriction-in-effect.solution2.title' => 'open_basedir 지시문을 비활성화하십시오.',
    'problem-detail.php-open-basedir-restriction-in-effect.solution2.text' => '<ol><li><p><strong>도메인 &gt example.com &gt PHP 설정</strong> 페이지로 이동하여 <code>open_basedir</code> 지시문을 "없음"으로 지정하십시오.</p></li></ol>',
    'problem-detail.apache-client-denied-by-server.name' => 'Apache .htaccess "403 사용 권한 없음 AH01797: 클라이언트가 서버 구성에 의해 거부되었습니다"',
    'problem-detail.apache-client-denied-by-server.description' => '<h4>증상</h4><ul><li><p>웹 사이트에 다음과 유사한 오류 메시지를 표시됩니다:</p><pre>Server Error 403<br>Forbidden</pre></li><li><p><code>/var/www/vhosts/system/example.com/logs/error_log</code> 로그 파일에 다음과 같은 오류가 포함되어 있습니다:</p><pre>AH01797: client denied by server configuration: /var/www/vhosts/example.com/index.php</pre></li></ul>',
    'problem-detail.apache-client-denied-by-server.cause' => '<p>사용자 지정 Apache 구성이 웹 사이트 액세스를 허용하지 않습니다.</p>',
    'problem-detail.apache-client-denied-by-server.solution1.title' => '서버 구성 및 .htaccess 파일을 확인하십시오.',
    'problem-detail.apache-client-denied-by-server.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/214528485" target="_blank" rel="noopener">KB 문서를 읽고 지침을 따르십시오</a>.</p></li></ol>',
    'problem-detail.apache-no-directory-index.name' => 'Apache "Plesk에서 웹사이트 디렉토리에 액세스할 수 없음: 403 사용 권한 없음"',
    'problem-detail.apache-no-directory-index.description' => '<h4>증상</h4><ul><li><p><code>http://example.com/some_folder</code> 등 웹 사이트의 특정 위치에 액세스할 수 없습니다. 다음 오류가 발생합니다:</p><pre>Server Error 403<br>Forbidden</pre></li><li><p><code>/var/www/vhosts/example.com/logs/error_log<code/> 파일에 다음 오류가 등장합니다:</p><pre>[autoindex:error] [pid 16314:tid 140300215322368] [client 203.0.113.2:55714] AH01276: Cannot serve directory /var/www/vhosts/example.com/httpdocs/some_folder/: No matching DirectoryIndex (index.html,index.cgi,index.pl,index.php,index.xhtml,index.htm,index.shtml) found, and server-generated directory index forbidden by Options directive</pre></li></ul>',
    'problem-detail.apache-no-directory-index.cause' => '<p>요청된 디렉토리에 인덱스 파일이 포함되어 있지 않거나 디렉터리 탐색이 활성화되지 않았습니다.</p>',
    'problem-detail.apache-no-directory-index.solution1.title' => '디렉터리에 인덱스 파일을 추가하십시오.',
    'problem-detail.apache-no-directory-index.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/214528485" target="_blank" rel="noopener">KB 문서를 읽고 지침을 따르십시오</a>.</p></li></ol>',
    'problem-detail.apache-no-directory-index.solution2.title' => '디렉터리 검색을 활성화하십시오.',
    'problem-detail.apache-no-directory-index.solution2.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/360002534354" target="_blank" rel="noopener">KB 문서를 읽고 지침을 따르십시오</a>.</p></li></ol>',
    'problem-detail.nginx-no-directory-index.name' => 'Nginx "Plesk에서 웹사이트 디렉토리에 액세스할 수 없음: 403 사용 권한 없음"',
    'problem-detail.nginx-no-directory-index.description' => '<h4>증상</h4><ul><li><p><code>http://example.com/some_folder</code> 등 웹 사이트의 특정 위치에 액세스할 수 없습니다. 다음 오류가 발생합니다:</p><pre>Server Error 403<br>Forbidden</pre></li><li><p><code>/var/www/vhosts/example.com/logs/error_log 파일</code>에 다음 오류가 등장합니다:</p><pre>[autoindex:error] [pid 16314:tid 140300215322368] [client 203.0.113.2:55714] AH01276: Cannot serve directory /var/www/vhosts/example.com/httpdocs/some_folder/: No matching DirectoryIndex (index.html,index.cgi,index.pl,index.php,index.xhtml,index.htm,index.shtml) found, and server-generated directory index forbidden by Options directive</pre></li></ul>',
    'problem-detail.nginx-no-directory-index.cause' => '<p>요청된 디렉토리에 인덱스 파일이 포함되어 있지 않거나 디렉터리 탐색이 활성화되지 않았습니다.</p>',
    'problem-detail.nginx-no-directory-index.solution1.title' => '디렉터리에 인덱스 파일을 추가하십시오.',
    'problem-detail.nginx-no-directory-index.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/214528485" target="_blank" rel="noopener">KB 문서를 읽고 지침을 따르십시오</a>.</p></li></ol>',
    'problem-detail.nginx-no-directory-index.solution2.title' => '디렉터리 검색을 활성화하십시오.',
    'problem-detail.nginx-no-directory-index.solution2.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/360002534354" target="_blank" rel="noopener">KB 문서를 읽고 지침을 따르십시오</a>.</p></li></ol>',
    'problem-detail.apache-reached-max-request-workers.name' => 'Apache "서버가 MaxRequestWorkers 설정에 도달했습니다"',
    'problem-detail.apache-reached-max-request-workers.description' => '준비 중입니다.',
    'problem-detail.apache-reached-max-request-workers.cause' => '',
    'problem-detail.php-post-content-length-exceeds-limit.name' => 'PHP 요청 본문 제한 "클라이언트가 너무 큰 본문을 보내려고 함"',
    'problem-detail.php-post-content-length-exceeds-limit.description' => '준비 중입니다.',
    'problem-detail.php-post-content-length-exceeds-limit.cause' => '',
    'problem-detail.nginx-client-sent-too-large-body.name' => 'PHP 요청 본문 제한 "클라이언트가 너무 큰 본문을 보내려고 함"',
    'problem-detail.nginx-client-sent-too-large-body.description' => '준비 중입니다.',
    'problem-detail.nginx-client-sent-too-large-body.cause' => '',
    'problem-detail.php-failed-to-read-session-data.name' => 'PHP 세션 "503 내부 서버 오류" 또는 "세션 데이터 읽기 실패"',
    'problem-detail.php-failed-to-read-session-data.description' => '준비 중입니다.',
    'problem-detail.php-failed-to-read-session-data.cause' => '',
    'problem-detail.apache-unable-to-check-htaccess-file.name' => 'Apache .htaccess "403 사용 권한 없음: pcfg_openfile: htaccess 파일을 확인할 수 없습니다, 읽을 수 있는지 확인하십시오"',
    'problem-detail.apache-unable-to-check-htaccess-file.description' => '<h4>증상</h4><ul><li><p>Plesk에 호스팅된 웹 사이트가 작동하지 않습니다:</p><pre>You don\'t have permission to access / on this server. <br> Additionally, a 403 Forbidden error was encountered while trying to use an ErrorDocument to handle the request.</pre><p>상기한 오류 외에도 빈 페이지가 표시될 수도 있습니다.</p></li><li><p><strong>도메인 &gt example.com &gt 로그</strong>의 도메인 오류 로그에 다음이 포함되어 있습니다:</p><pre>(13)Permission denied: [client 203.0.113.2:39024] AH00529: /var/www/vhosts/example.com/httpdocs/.htaccess pcfg_openfile: unable to check htaccess file, ensure it is readable and that "/var/www/vhosts/example.com/httpdocs/" is executable</pre></li></ul>',
    'problem-detail.apache-unable-to-check-htaccess-file.cause' => '도메인의 파일 또는 폴더에 대한 액세스 권한이 올바르지 않습니다.',
    'problem-detail.apache-unable-to-check-htaccess-file.solution1.title' => '웹 사이트 콘텐츠에 대한 권한을 복구하십시오.',
    'problem-detail.apache-unable-to-check-htaccess-file.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/213939685" target="_blank" rel="noopener">KB 문서를 읽고 지침을 따르십시오</a>.</p></li></ol>',
];