<?php
// Copyright 1999-2022. Plesk International GmbH. All rights reserved.
$messages = [
    'problem-detail.nginx-upstream-sent-too-big-header.name' => 'Nginx "502 잘못된 게이트웨이: 응답 헤더를 읽는 동안 업스트림이 너무 큰 헤더를 보냈습니다"',
    'problem-detail.nginx-upstream-sent-too-big-header.description' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.cause' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.title' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.text' => '',
    'problem-detail.apache-followsymlinks-not-allowed.name' => 'Apache "500 내부 서버 오류: FollowSymLinks 옵션이 허용되지 않습니다"',
    'problem-detail.apache-followsymlinks-not-allowed.description' => '',
    'problem-detail.apache-followsymlinks-not-allowed.cause' => '',
    'problem-detail.phpfpm-server-reached-max-children.name' => 'PHP-FPM "서버가 max_children 설정에 도달했습니다"',
    'problem-detail.phpfpm-server-reached-max-children.description' => '<h4>증상</h4><ul><li><p>PHP 핸들러가 <strong>Apache에서 제공하는 FPM 애플리케이션</strong> 또는 <strong>nginx에서 제공하는 FPM 애플리케이션</strong>으로 설정된 웹사이트 <strong>도메인</strong> &gt; <strong>example.com</strong> &gt; <strong>PHP 설정에서</strong> 다음 문제 중 하나가 발생합니다:</p><ul><li><p>천천히 로드</p></li><li><p>웹 브라우저에서 (주기적 또는 영구적으로) 50x 오류로 액세스할 수 없음:</p><pre>502 잘못된 게이트웨이</pre><hr><pre>503 서비스를 일시적으로 사용할 수 없음</pre><hr><pre>504 게이트웨이 시간 초과</pre></li></ul></li><li><p>PHP-FPM 오류 로그 파일에 다음 메시지가 나타납니다 <code>/var/log/plesk-php<strong>XX</strong>-fpm/error.log</code> (여기서 <em>XX</em>는 웹 사이트에서 사용하는 PHP 버전):</p><pre>경고: [pool example.com] 서버가 max_children 설정 (*)에 도달, 설정을 높이는 것이 좋습니다.</pre><ul><li><p>위 메시지는 일반적으로 다음 오류와 함께 표시됩니다:</p><pre>어린이가 말하는 내용을 읽을 수 없음: 잘못된 파일 설명자 (9)</pre></li></ul></li><li><p>nginx가 서버에서 활성화된 경우 도메인의 오류 록 파일 <code>/var/www/vhosts/system/example.com/logs/proxy_error_log</code>에 다음 오류 메시지 중 하나가 나타날 수 있습니다:</p><pre style="white-space: pre-wrap;">[error] 11456#0: *118348 unix:///var/www/vhosts/system/example.com/php-fpm.sock에 연결() 실패 (11: 리소스를 일시적으로 사용할 수 없음) 업스트림에 연결하는 동안 클라이언트: 203.0.113.2, 서버: example.com, 요청: "GET / HTTP/1.1", 업스트림: "fastcgi://unix:///var/www/vhosts/system/example.com/php-fpm.sock:", 호스트: "example.com"</pre><hr><pre style="white-space: pre-wrap;">[error] 20058#0: *4725139 업스트림에서 응답 헤더를 읽는 동안 업스트림 연결이 너무 일찍 닫혔습니다, 클라이언트: 203.0.113.2, 서버: example.com, 요청: "POST /path/to/some/file HTTP/2.0", 업스트림:</pre></li></ul>',
    'problem-detail.phpfpm-server-reached-max-children.cause' => ' <p>웹사이트에서 PHP-FPM <code>pm.max_children</code>에 도달했습니다.</p>',
    'problem-detail.phpfpm-server-reached-max-children.solution1.title' => 'pm.max_children 제한 증가',
    'problem-detail.phpfpm-server-reached-max-children.solution1.text' => '<p>영향을 받는 도메인에 대한 <code>pm.max_children</code> 제한을 늘립니다:</p><ol><li><p>Plesk 서버에 <a href="https://support.plesk.com/hc/en-us/articles/115000172834" target="_blank" rel="noopener">SSH를 통해 연결</a>.</p></li><li><p>아래 명령을 사용하여 영향을 받는 도메인 찾기:</p><div class="pul-alert pul-alert--info pul-status-message pul-status-message--info"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>참고:</strong> 왼쪽의 숫자는 웹사이트에서 <code>pm.max_children</code> 제한에 도달한 횟수를 나타냅니다.</div><pre style="white-space: pre-wrap;"># grep -r "서버가 max_children 설정에 도달했습니다" /var/log/*php*-fpm/error.log | cut -d\' \' -f5 | tr -d \']\' | sort | uniq -c | sort -nr<br><br>100 example.com<br>50 example.net<br>25 example.org<br>&lt;...&gt;</pre></li><li><p><a href="https://support.plesk.com/hc/en-us/articles/213413369" target="_blank" rel="noopener">Plesk</a>.</p></li><li><p>다음 <strong>도메인으로 이동</strong> &gt; <strong>example.com</strong> &gt; <strong>PHP 설정</strong> &gt; <strong>PHP-FPM 설정</strong>.</p></li><li><p>도메인의 <code>pm.max_children</code> 값을 늘리고 변경 사항을 적용합니다. 2단계에 나열된 모든 도메인에 대해 이 값을 늘립니다.</p></li></ol>',
    'problem-detail.nginx-too-many-open-files.name' => 'Nginx "열린 파일이 너무 많음"',
    'problem-detail.nginx-too-many-open-files.description' => '<p>nginx가 Plesk 서버에서 시작/다시 로드하지 못함: 열려있는 파일이 너무 많음</p><h4>증상</h4><ul><li><p>nginx 서비스가 다음과 함께 시작/다시 로드하지 못함 <code>/var/log/nginx/error.log</code> 파일의 오류:</p><pre style="white-space: pre-wrap;">nginx: [emerg] open()
"/var/www/vhosts/system/example.com/logs/proxy_access_ssl_log" 실패 (24: 열린 파일이 너무 많음)</pre></li><li><p>일부 또는 모든 웹사이트에 액세스할 수 없음</p></li><li><p>경고가 <strong>도구 &amp; 설정 &gt; 진단 &amp; 수리</strong>에 표시됩니다:</p><pre style="white-space: pre-wrap;">nginx ULIMIT 값 확인 N 도메인이 서버에서 발견되었습니다. 열린 파일에 대한 nginx 기본 제한 문제가 발생할 수 있습니다</pre></li><li><p>NodeJS 및 Ruby 웹 응용 프로그램은 도메인 생성, 구독, Apache 또는 Nginx 변경 등과 같은 일부 Plesk 작업을 수행할 때 502 잘못된 Gateway 오류를 표시합니다:</p><pre style="white-space: pre-wrap;">서버 오류<br>502 잘못된 Gateway <br>웹 서버가 게이트웨이 또는 프록시 서버 역할을 하는 동안 잘못된 응답을 받았습니다.</pre></li><li><p>도메인에 대한<a href="https://support.plesk.com/hc/en-us/articles/213946825-How-to-install-SSL-certificate-for-a-domain-in-Plesk" target="_blank" rel="noopener noreferrer">새 인증서를 설치한 후</a>, 이전 인증서는 웹 브라우저에 계속 표시되지만, <strong>도메인 &gt; example.com &gt; 호스팅 설정</strong> 페이지에서 올바른 인증서가 선택됩니다.</p></li></ul>',
    'problem-detail.nginx-too-many-open-files.cause' => '<p>Nginx의 가상 호스트는 물리적 호스팅이 있는 각 가상 호스트에 대해 4개의 로그 파일을 엽니다:</p><ul><li>proxy_access_log</li><li>proxy_access_ssl_log</li><li>webmail_access_log</li><li>webmail_access_ssl_log</li></ul><p>이 사실의 결과로 많은 수의 도메인(보통 100개 이상)으로 인해 nginx 서버에서 최대 열린 파일 수를 초과했습니다.</p>',
    'problem-detail.nginx-too-many-open-files.solution1.title' => '열린 파일 제한 증가',
    'problem-detail.nginx-too-many-open-files.solution1.text' => '<div class="pul-alert pul-alert--warning pul-status-message pul-status-message--warning"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>경고:</strong><code>websrv_ulimits</code> 유틸리티를 실행할 때 <strong>--다시 시작 안 함</strong> 옵션 없이 실행하면 모든 도메인에 대한 웹 구성 파일의 재구축이 시작되며 호스팅된 웹 사이트의 수가 많은 경우 상당한 다운타임이 발생할 수 있습니다.<br><br>유지 관리 기간 동안 명령을 실행합니다.</div><p>열린 파일 제한 값을 <strong>Plesk의 도메인 수 * 16</strong> 이상으로 설정하는 것이 좋습니다. 아래 예시에서 제한을 4096으로 설정하는 방법을 제공했습니다:</p><ol><li><p>다음 <a href="https://support.plesk.com/hc/en-us/articles/115000172834" target="_blank" rel="noopener noreferrer">SSH를 통해 서버에 연결</a></p></li><li><p>Apache 및 Nginx 모두에 대해 열린 파일 제한을 4096으로 설정:</p><pre># /usr/local/psa/admin/sbin/websrv_ulimits --4096 설정 --다시 시작 안 함</pre></li><li><p>변경 사항을 적용하려면 <strong><a href="https://support.plesk.com/hc/en-us/articles/213413369" target="_blank" rel="noopener noreferrer">Plesk</a> &gt;</strong> <strong>도구 &amp; 설정 &gt; 서비스 관리</strong>에서 Apache 및 nginx 서비스를 다시 시작하십시오.</p></li><li><p>웹 서비스를 다시 시작한 후 \'최대 파일 열기 제한\'이 제대로 적용되었는지 확인:</p><pre># grep \'최대 파일 열기\' /proc/$(cat /var/run/nginx.pid)/limits<br>최대 열린 파일 수 4096 4096 파일</pre></li><li><p>위 해결 방법이 도움이 되지 않으면 <code>ulimit</code> 유틸리티를 사용하여 제한을 설정하십시오:</p><pre># ulimit -n 4096</pre></li></ol>',
    'problem-detail.apache-modsec-response-body-too-large.name' => 'ModSecurity "응답 본문이 너무 큼"',
    'problem-detail.apache-modsec-response-body-too-large.description' => '',
    'problem-detail.apache-modsec-response-body-too-large.cause' => '',
    'problem-detail.modsec-access-denied.name' => 'ModSecurity "코드 403으로 액세스가 거부되었습니다"',
    'problem-detail.modsec-access-denied.description' => '',
    'problem-detail.modsec-access-denied.cause' => '',
    'problem-detail.php-allowed-memory-size-exhausted.name' => 'PHP "내부 서버 오류 500: XXX의 허용된 메모리 용량이 소진되었습니다"',
    'problem-detail.php-allowed-memory-size-exhausted.description' => '',
    'problem-detail.php-allowed-memory-size-exhausted.cause' => '',
    'problem-detail.php-open-basedir-restriction-in-effect.name' => 'PHP "open_basedir 제한 적용 중"',
    'problem-detail.php-open-basedir-restriction-in-effect.description' => '',
    'problem-detail.php-open-basedir-restriction-in-effect.cause' => '',
    'problem-detail.apache-client-denied-by-server.name' => 'Apache .htaccess "403 사용 권한 없음 AH01797: 클라이언트가 서버 구성에 의해 거부되었습니다"',
    'problem-detail.apache-client-denied-by-server.description' => '',
    'problem-detail.apache-client-denied-by-server.cause' => '',
    'problem-detail.apache-no-directory-index.name' => 'Apache "Plesk에서 웹사이트 디렉토리에 액세스할 수 없음: 403 사용 권한 없음"',
    'problem-detail.apache-no-directory-index.description' => '',
    'problem-detail.apache-no-directory-index.cause' => '',
    'problem-detail.nginx-no-directory-index.name' => 'Nginx "Plesk에서 웹사이트 디렉토리에 액세스할 수 없음: 403 사용 권한 없음"',
    'problem-detail.nginx-no-directory-index.description' => '',
    'problem-detail.nginx-no-directory-index.cause' => '',
    'problem-detail.apache-reached-max-request-workers.name' => 'Apache "서버가 MaxRequestWorkers 설정에 도달했습니다"',
    'problem-detail.apache-reached-max-request-workers.description' => '',
    'problem-detail.apache-reached-max-request-workers.cause' => '',
    'problem-detail.php-post-content-length-exceeds-limit.name' => 'PHP 요청 본문 제한 "클라이언트가 너무 큰 본문을 보내려고 함"',
    'problem-detail.php-post-content-length-exceeds-limit.description' => '',
    'problem-detail.php-post-content-length-exceeds-limit.cause' => '',
    'problem-detail.nginx-client-sent-too-large-body.name' => 'PHP 요청 본문 제한 "클라이언트가 너무 큰 본문을 보내려고 함"',
    'problem-detail.nginx-client-sent-too-large-body.description' => '',
    'problem-detail.nginx-client-sent-too-large-body.cause' => '',
    'problem-detail.php-failed-to-read-session-data.name' => 'PHP 세션 "503 내부 서버 오류" 또는 "세션 데이터 읽기 실패"',
    'problem-detail.php-failed-to-read-session-data.description' => '',
    'problem-detail.php-failed-to-read-session-data.cause' => '',
    'problem-detail.apache-unable-to-check-htaccess-file.name' => 'Apache .htaccess "403 사용 권한 없음: pcfg_openfile: htaccess 파일을 확인할 수 없습니다, 읽을 수 있는지 확인하십시오"',
    'problem-detail.apache-unable-to-check-htaccess-file.description' => '',
    'problem-detail.apache-unable-to-check-htaccess-file.cause' => '',
];