<?php
// Copyright 1999-2022. Plesk International GmbH. All rights reserved.
$messages = [
    'title' => 'Website Log Check',

    'regularCheck' => 'Automatic check',
    'manualCheck' => 'Vérification manuelle',

    'promoTitle' => 'Détection rapide des dysfonctionnements ou de l\'indisponibilité de vos sites Web',
    'promoDescription' => 'Website issues are often visible to visitors but not to administrators unless they constantly analyze website logs. Our brand new Website Log Check automates this routine and helps to resolve found issues efficiently.',
    'promoMore' => 'En savoir plus',
    'promoButton' => 'J\'ai compris !',
    'checkEnabledTitle' => 'Automatic check is on',
    'checkDisabledTitle' => 'Automatic check is off',
    'disabledDescription' => 'Turn on to automatically detect issues that can make websites unavailable or cause their incorrect operation.',
    'websitesAllChecked' => '{count, plural, one {# website gets} other {# websites get}} checked daily',
    'websitesAllCheckedAt' => '{count, plural, one {# site Web est vérifié} other {# sites Web sont vérifiés}} tous les jours à %%time%%',
    'websitesChecked' => '%%count%% sur %%totalCount%% sites Web seront vérifiés tous les jours',
    'websitesCheckedAt' => '%%count%% sur %%totalCount%% sites Web seront vérifiés tous les jours à %%time%%',
    'checkedWebsites' => 'Liste des sites Web vérifiés',
    'lastCheckDescription' => 'The last check took %%duration%% minutes.',
    'durationLess' => 'moins de 0,1',
    'month0' => '%%date%% jan',
    'month1' => '%%date%% fév',
    'month2' => '%%date%% mar',
    'month3' => '%%date%% avr',
    'month4' => '%%date%% mai',
    'month5' => '%%date%% jun',
    'month6' => '%%date%% jul',
    'month7' => '%%date%% aoû',
    'month8' => '%%date%% sep',
    'month9' => '%%date%% oct',
    'month10' => '%%date%% nov',
    'month11' => '%%date%% déc',
    'export' => 'Exporter le rapport au format CSV',
    'buttonRun' => 'Run manual check',
    'buttonRunDescription' => 'To recheck fixed websites or find issues that did not appear during the last check.',

    'websites.title' => 'Sites Web à vérifier',
    'websites.description' => '%%selected%% sur %%total%% sites Web sont sélectionnés',
    'websites.search' => 'Trouver des sites Web...',
    'websites.new' => 'Tous les sites Web créés récemment',
    'websites.newHint' => 'Select to automatically start checking all new websites.',
    'websites.existing' => 'Tous les sites Web existants',
    'websites.buttonSave' => 'Enregistrer',
    'websites.buttonCancel' => 'Annuler',
    'websites.updateSuccess' => 'Les paramètres ont été mis à jour',

    'tabs.problemDetails' => 'Issue details',
    'tabs.affectedWebsites' => 'Sites Web concernés',

    'chart.requests' => 'Requêtes',
    'chart.errors' => 'Erreurs',

    'affected-websites.selected' => '%%selectedCount%% sur %%totalCount%% sites Web ont été sélectionnés',
    'affected-websites.none' => 'Aucun',
    'affected-websites.all' => 'Tout',
    'affected-websites.searchForWebsite' => 'Rechercher des sites Web',
    'affected-websites.websites' => 'Sites Web',

    'problem-report.domainTitle' => 'Issue reported on %%domain%%',
    'problem-report.cumulativeTitle' => 'Issue reported on {count, plural, one {# website} other {# websites}}',
    'problem-report.serverwideTitle' => 'Server-wide issue reported',
    'problem-report.problemAppearsOn' => 'The issue appears on {count, plural, one {# website} other {# websites}} in total',
    'problem-report.seeTheConsolidatedReport' => 'Voir le rapport consolidé',
    'problem-report.cause' => 'Cause principale',
    'problem-report.possibleSolutions' => 'Solutions possibles',
    'problem-report.useAnOption' => 'Utiliser une option pour une solution automatique',
    'problem-report.repairTheWebsite' => 'Réparer le site Web',
    'problem-report.selectAndRepair' => 'Sélectionner et réparer plusieurs sites Web',
    'problem-report.distributionOfTheProblem' => 'Distribution of the issue over time',
    'problem-report.serverTimezone' => 'Fuseau horaire du serveur (UTC%%utcShift%%)',
    'problem-report.yourTimezone' => 'Votre fuseau horaire (UTC%%utcShift%%)',
    'problem-report.weRecomendComparing' => 'We recommend that you compare the error distribution chart with %%link%% in Monitoring',
    'problem-report.resourceUsageCharts' => 'Graphique d\'utilisation des ressources',
    'problem-report.logEntries' => 'Examples of log entries indicating the issue',
    'problem-report.pleaseKeepInMind' => 'Note: Plesk constantly rotates logs and will eventually archive or delete the mentioned log entries.',
    'problem-report.weRecommendToRecheck' => '%%recheckWebsite%%—we recommend it after each fixing attempt.',
    'problem-report.recheckWebsite' => 'Revérifier le site Web manuellement',
    'problem-report.recommended' => 'recommandé',
    'problem-report.numberOfEntries' => 'Nombre d\'entrées',
    'problem-report.logEntry' => 'Entrée du journal',
    'problem-report.logFile' => 'Fichier journal',
    'problem-report.openWebsiteLogs' => 'Ouvrir les journaux du site Web',
    'problem-report.thisIsServerWideProblem' => 'This is a server-wide issue that affects all hosted websites',
    'problem-report.serverWideTitle' => 'Server-wide issue reported',

    'distribution-over-time.title' => 'Distribution of the issue over time',
    'distribution-over-time.serverTimezone' => 'Fuseau horaire du serveur (UTC%%utcShift%%)',
    'distribution-over-time.yourTimezone' => 'Votre fuseau horaire (UTC%%utcShift%%)',
    'distribution-over-time.weRecomendComparing' => 'We recommend that you compare the error distribution chart with %%link%% in Monitoring',
    'distribution-over-time.resourceUsageCharts' => 'Graphique d\'utilisation des ressources',

    'report.title' => 'Rapport de la dernière vérification',
    'report.groupByWebsites' => 'Regroupé par sites Web',
    'report.groupByProblems' => 'By issues',
    'report.columnWebsite' => 'Site Web',
    'report.columnStatus' => 'Issues',
    'report.columnProblem' => 'Issue',
    'report.columnAppearedOn' => 'Detected on',
    'report.serverWideName' => 'Server-wide issues',
    'report.serverWideDescription' => 'These issues affect the whole server and its hosted websites.',
    'report.statusProblemsFound' => '%%count%% trouvé(s)',
    'report.statusProblemsFoundFull' => '{count, plural, one {# issue} other {# issues}} found',
    'report.statusProblemsSolved' => '%%count%% disappeared',
    'report.statusProblemsSolvedFull' => '{count, plural, one {# issue} other {# issues}} disappeared',
    'report.statusSuccess' => 'No issue',
    'report.serverWide' => 'Tout le serveur',
    'report.appearedOn' => '{count, plural, one {# site Web} other {# sites Web}}',
    'report.recheckWebsite' => 'Revérifier le site Web',
    'report.actionOpen' => 'Ouvrir',
    'report.actionManage' => 'Gérer',
    'report.actionLogs' => 'Afficher les logs',
    'report.searchWebsite' => 'Trouver des sites Web...',
    'report.searchProblem' => 'Find issues...',
    'report.groupByProblemsTotal' => '{totalRows, plural, one {# issue} other {# issues}} on {websitesCount, plural, one {# website} other {# websites}}',
    'report.noProblemsTitle' => 'No issues were found on {websitesCount, plural, one {# website} other {# websites}}',
    'report.noProblemsDescription' => 'Apparemment, vos sites Web fonctionnent bien, bravo !',

    'problems.columnTitle' => 'Issue',
    'problems.columnRegular' => 'Automatic check',
    'problems.columnManual' => 'Vérification manuelle',
    'problems.run' => '%%fromTime%% %%fromDate%% - %%toTime%% %%toDate%%',
    'problems.runSameDay' => '%%fromTime%% - %%toTime%% à %%toDate%%',
    'problems.notRun' => 'not performed yet',
    'problems.resultDetected' => 'Détecté',
    'problems.resultNotDetected' => 'Non détecté',
    'problems.resultNoProblems' => 'No issues',

    'new-check.title' => 'Vérification manuelle',
    'new-check.titleForWebsite' => 'Vérification manuelle du site %%website%%',
    'new-check.titleRunning' => 'Vérification manuelle : {count, plural, one {# site Web} other {# sites Web}}',
    'new-check.description' => '%%selected%% sur %%total%% sites Web sont sélectionnés',
    'new-check.depth' => 'Période de vérification',
    'new-check.checkTheLast' => 'Check the last',
    'new-check.selectHours' => 'Heures',
    'new-check.selectMinutes' => 'Minutes',
    'new-check.ifYouHaveAnyProblemActivities' => 'If you tried fixing the website issues, set the time period after this attempt. Otherwise Plesk can detect issues you have already resolved.',
    'new-check.weAlsoRecommendVisiting' => 'Before running a manual check, we recommend that you %%visitingTheWebsite%% and try to reproduce the issue.',
    'new-check.visitingTheWebsite' => 'visit the website',
    'new-check.hours' => 'dernières heures',
    'new-check.websites' => 'Sites Web à vérifier',
    'new-check.buttonSave' => 'Vérifier',
    'new-check.buttonCancel' => 'Annuler',
    'new-check.search' => 'Trouver des sites Web...',
    'new-check.checkProblems' => 'Websites with issues during the last check',
    'new-check.allWebsites' => 'Tous les sites Web',
];