<?= $this->doctype() ?>
<html <?= $this->htmlDoc() ?>>
<head>
<?= $this->headMeta() ?>
<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
<meta name="SKYPE_TOOLBAR" content="SKYPE_TOOLBAR_PARSER_COMPATIBLE">
<meta name="format-detection" content="telephone=no">
<title>{TITLE}</title>
<meta name="plesk-build" content="<?php echo StatInfo::make()->getProductVersion()['plesk_build']; ?>">
<meta name="plesk-revision" content="<?php echo StatInfo::make()->getProductVersion()['plesk_revision']; ?>">
<meta name="forgery_protection_token" id="forgery_protection_token" content="<?php echo Session::get()->panel()->forgeryProtectionToken; ?>">
<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
<link rel="shortcut icon" href="<?php echo \Session::get()->panel()->baseUrl . $this->cacheStamp('/favicon.ico'); ?>">
<?php echo $GLOBALS['skin']->getThemeCssIncludes(); ?>
<?php $this->jsLoad()->requireJs(); ?>
<?php $this->jsLoad()->prepend('/javascript/main.js'); ?>
<?php $this->jsLoad()->prepend('/javascript/vendors.js'); ?>
<?php $this->jsLoad()->uiLibrary(); ?>
<?php $this->jsLoad()->prepend('/javascript/externals/prototype.js'); ?>
<?php echo $this->headScript(); ?>
<script type="text/javascript">
    Jsw.skinUrl = <?= $this->jsEscape($this->skinUrl('/')) ?>;
</script>
<?php echo $this->layout()->extensionsAdditionalHead; ?>
<?php if ($this->layout()->googleTagManagerId): ?>
<?php echo $this->partial('partials/google-tag-manager.phtml'); ?>
<?php endif; ?>
</head>

<body>
<?php echo $this->plesk()->run(); ?>
<?php if ($this->layout()->googleTagManagerId): ?>
<?php echo $this->partial('partials/google-tag-manager-noscript.phtml'); ?>
<?php endif; ?>
</body>
</html>
