<?php
// Copyright 1999-2021. Plesk International GmbH. All rights reserved.
$messages = [
    'admin-info.adminInfoSection' => 'Информация для администратора',
    'admin-info.descriptionAdmin' => 'Описание администратора',
    'admin-info.descriptionReseller' => 'Описание реселлера',
    'admin-info.descriptionOwner' => 'Описание владельца',
    'admin-info.description' => 'Описание',
    'admin-info.descriptionSuccess' => 'Описание обновлено.',
    'admin-info.longDescription' => 'Слишком длинное описание. Максимальное количество символов ‒ %%max%%.',
    'admin-info.add' => 'Добавить описание',
    'admin-info.edit' => 'Изменить',
    'admin-info.remove' => 'Удалить',
    'admin-info.confirmOnRemove' => 'Удалить это описание?',
    'admin-info.popupTitleCustomer' => '%%descriptionType%% для клиента %%name%%',
    'admin-info.popupTitleReseller' => '%%descriptionType%% для реселлера %%name%%',
    'admin-info.popupTitleSubscription' => '%%descriptionType%% для подписки %%name%%',
    'admin-info.popupHintAdmin' => 'Это описание видно только администратору.',
    'admin-info.popupHintReseller' => 'Это описание видно реселлеру и администратору.',
    'admin-info.popupHintOwner' => 'Это описание видно его автору и хостинг-провайдеру автора.',
    'admin-info.customerDescriptionHint' => 'Это описание не показывается клиентам.',
    'admin-info.subscriptionDescriptionHint' => "Эта информация видна только хостинг-провайдеру (администратору или реселлеру Plesk).",

    'apache-settings.formGeneralHint' => 'Здесь вы можете указать настройки веб-сервера Apache для текущего сайта. Индивидуальная конфигурация Apache может пригодиться, например, если вы захотите использовать на своем сайте новый вид стартовых страниц или привязать тот или иной тип MIME к определенным расширениям файлов. Значение по умолчанию означает, что Apache будет использовать соответствующую директиву из своей серверной конфигурации. Если Apache работает в связке с nginx, то на этой странице вы также можете настроить параметры nginx.',
    'apache-settings.general' => 'Общие настройки Apache',
    'apache-settings.example' => "Пример:\n%%example%%",
    'apache-settings.settingOn' => 'Вкл.',
    'apache-settings.settingOff' => 'Откл. (по умолчанию)',
    'apache-settings.settingDefault' => 'По умолчанию',
    'apache-settings.settingCustom' => 'Ввести свое значение',
    'apache-settings.mimeTypes' => 'Типы MIME',
    'apache-settings.mimeTypesExample' => "text/plain .txt\nimage/jpeg .jpeg \n\nТипы MIME обеспечивают привязку расширений файлов к типам файлов. Обычно это используется для создания дополнительных расширений файлов для стандартных типов файлов.",
    'apache-settings.handlers' => 'Обработчики',
    'apache-settings.handlersExample' => "php-script .php\ncgi-script .cgi \n\nОбработчики Apache определяют, как веб-сервер обрабатывает файлы с определенными расширениями, когда они запрашиваются посетителями. Например, строка 'php-script .script' означает, что Apache будет обрабатывать файлы с расширением .script как скрипты php.",
    'apache-settings.deny' => 'Запретить доступ к сайту',
    'apache-settings.allow' => 'Исключения',
    'apache-settings.denyExample' => "10.1.0.0/16\n192.168.1.110\n\nУказанным здесь серверам и сетям будет запрещен доступ к текущему сайту. Чтобы запретить все подключения, введите '*'.",
    'apache-settings.allowExample' => "192.168.0.0/16\n10.1.1.21\n\nУказанным здесь серверам и сетям будет разрешен доступ к текущему сайту.",
    'apache-settings.directoryIndex' => 'Стартовые страницы',
    'apache-settings.directoryIndexExample' => "index.htm index.php index.pl \n\nЭто файлы, которые Apache будет искать в ответ на запрос к стартовой странице.",
    'apache-settings.expires' => 'Заканчивается',
    'apache-settings.expiresStaticOnly' => 'использовать заголовки ответов Expires только для статических файлов',
    'apache-settings.expiresDescription' => 'Веб-сервер добавит на веб-страницы заголовки ответов “Expires”. Временная метка истечения срока хранения страницы получается путем добавления указанного выше количества времени к времени запроса страницы.',
    'apache-settings.expiresStaticOnlyDescription' => 'Заголовок ответа "Expires" будет добавлен только для статических файлов. То, какие файлы считаются статическими, определяется опциями "Интеллектуальная обработка статических файлов" и "Обрабатывать статические файлы с помощью nginx".',
    'apache-settings.expiresUnitDays' => 'дней',
    'apache-settings.expiresUnitHours' => 'часов',
    'apache-settings.expiresUnitMinutes' => 'минут',
    'apache-settings.expiresUnitSeconds' => 'секунд',
    'apache-settings.headers' => 'Дополнительные заголовки',
    'apache-settings.headersExample' => "Cache-Control: public\nStrict-Transport-Security: max-age=63072000\nX-Frame-Options: DENY\n\nВеб-сервер добавит указанные заголовки HTTP-ответов.",
    'apache-settings.restrictFollowSymLinks' => 'Запретить открывать символьные ссылки',
    'apache-settings.restrictFollowSymLinksDescription' => "Эта опция позволяет повысить безопасность сервера, запретив пользователям использовать директиву FollowSymLink в .htaccess.",
    'apache-settings.nginx' => 'Настройки nginx',
    'apache-settings.nginxProxyMode' => 'Режим прокси',
    'apache-settings.nginxProxyModeDescription' => 'Nginx проксирует запросы к Apache. Отключить, чтобы перестать использовать Apache.',
    'apache-settings.nginxTransparentMode' => 'Интеллектуальная обработка статических файлов',
    'apache-settings.nginxTransparentModeDescription' => 'Если отключить эту опцию, то все запросы к статическим файлам будут обрабатываться Apache. nginx будет использоваться только для передачи запросов и ответов без внесения в них каких-либо изменений. Рекомендуем отключать эту опцию только в целях диагностики проблем.',
    'apache-settings.nginxServeStatic' => 'Обрабатывать статические файлы с помощью nginx.',
    'apache-settings.nginxStaticExtensions' => 'Укажите расширения файлов, разделяя их пробелом или символом "|". Запросы к этим файлам будут обрабатываться nginx, не доходя до Apache. Внимание: правила перезаписи Apache применяться не будут.',
    'apache-settings.nginxServePhp' => 'Обрабатывать PHP-файлы с помощью nginx',
    'apache-settings.nginxServePhpDescription' => 'PHP-файлы (.php) будут обрабатываться nginx и PHP-FPM. Если отключить эту опцию, PHP-файлы будут обрабатываться Apache.',
    'apache-settings.nginxCacheEnabled' => 'Включить кэширование с помощью nginx',
    'apache-settings.nginxCacheEnabledDescription' => 'Кэширование может сократить время отклика сайта и уменьшить нагрузку на сервер, однако его следует использовать с осторожностью.',
    'apache-settings.nginxCacheSize' => 'Размер кэша',
    'apache-settings.nginxCacheSizeGb' => 'Гб',
    'apache-settings.nginxCacheSizeMb' => 'Mб',
    'apache-settings.nginxCacheSizeKb' => 'Кб',
    'apache-settings.nginxCacheSizeBytes' => 'Байт',
    'apache-settings.nginxCacheTimeout' => 'Время ожидания кэша',
    'apache-settings.nginxCacheTimeoutDays' => 'дней',
    'apache-settings.nginxCacheTimeoutHours' => 'часов',
    'apache-settings.nginxCacheTimeoutMinutes' => 'минут',
    'apache-settings.nginxCacheTimeoutSeconds' => 'секунд',
    'apache-settings.nginxCacheKey' => 'Ключ кэша',
    'apache-settings.nginxCacheCookies' => 'Кэшировать запросы с cookie-файлами',
    'apache-settings.nginxCacheBypassLocations' => 'Запретить кэширование для адресов',
    'apache-settings.nginxCacheBypass' => 'Не кэшировать, если',
    'apache-settings.nginxCacheBypassHeaderNocache' => 'В запросе получены заголовки HTTP no-cache',
    'apache-settings.nginxCacheBypassHeaderAuth' => 'В запросе получены заголовки авторизации HTTP',
    'apache-settings.nginxCacheBypassGetNocache' => 'В запросе GET получен параметр nocache',
    'apache-settings.nginxCacheUseStale' => 'Возвращать устаревшие записи кэша',
    'apache-settings.nginxCacheUseStale5xx' => 'Вышестоящий сервер возвращает ошибку сервера 5xx',
    'apache-settings.nginxCacheUseStale4xx' => 'Вышестоящий сервер возвращает ошибку клиента 4xx',
    'apache-settings.nginxCacheUseStaleUpdating' => 'Кэш обновляется',
    'apache-settings.additional' => 'Дополнительные директивы Apache',
    'apache-settings.additionalSettingsDescription' => 'Если вы не смогли найти те или иные настройки, добавьте их в расположенные ниже поля. Эти настройки заменят собой глобальные директивы Apache. Директивы из первого поля используются, когда посетитель заходит на сайт по HTTP. Второе поле содержит директивы для HTTPS. Как правило, директивы добавляются в оба поля. При добавлении используйте такой же синтаксис, как для httpd.include. Например, если вы хотите использовать собственную страницу ошибки, добавьте следующую строку: ErrorDocument 401 /my_error_page.html.',
    'apache-settings.additionalSettings' => 'Дополнительные директивы для HTTP',
    'apache-settings.additionalSslSettings' => 'Дополнительные директивы для HTTPS',
    'apache-settings.additionalSettingsError' => 'Неверная конфигурация Apache: %%error%%',
    'apache-settings.rollbackFailed' => 'Невозможно использовать текущий конфигурационный файл Apache и вернуться к предыдущей версии файла, так как они содержат неисправную конфигурацию.',
    'apache-settings.additionalNginx' => 'Дополнительные директивы nginx',
    'apache-settings.additionalNginxSettingsDescription' => 'В этом разделе вы можете указать настройки обратного прокси-сервера nginx, работающего в связке с Apache. Введенные здесь директивы заменят собой глобальные настройки nginx. Например, вы можете изменить время ожидания подключения или назначить в качестве упаковщика запросов утилиту gzip. Синтаксис используйте такой же, как в nginx.conf. К примеру, чтобы сжать все переданные через прокси-сервер запросы с помощью gzip, добавьте следующую строку: \'gzip_proxied any;\'.',
    'apache-settings.additionalNginxSettings' => 'Дополнительные директивы nginx',
    'apache-settings.additionalNginxSettingsError' => 'Неверная конфигурация nginx: %%error%%',
    'apache-settings.nginxRollbackFailed' => 'Невозможно использовать текущий конфигурационный файл nginx и вернуться к предыдущей версии файла, так как оба они содержат неисправную конфигурацию.',

    'backup.backup-password-protection.securitySettingsSection' => 'Настройки безопасности резервного копирования',
    'backup.backup-password-protection.backupPasswordFromFtpSettings' => 'Получить пароль из настроек удаленного хранилища',
    'backup.backup-password-protection.backupPasswordManualInput' => 'Ввести пароль вручную',
    'backup.backup-password-protection.providePasswordCheckbox' => 'Предоставить пароль',
    'backup.backup-password-protection.backupPassword' => 'Пароль',
    'backup.backup-password-protection.inputPasswordType' => 'Тип пароля',
    'backup.backup-password-protection.confirmBackupPassword' => 'Повторите пароль',
    'backup.backup-password-protection.backupPasswordHint' => 'Если вы забыли свой пароль, отключите эту опцию. Обратите внимание, что в этом случае некоторые конфиденциальные данные будут восстановлены неполностью. Например, пароли пользователей будут заменены на случайные, будет потеряна информация об уже установленных приложениях и так далее.',
    'backup.backup-password-protection.backupPasswordFtpHint' => 'Если эта резервная копия защищена паролем, введите этот пароль в расположенные ниже поля. Обратите внимание, что если вы укажете неверный пароль, резервная копия не будет восстановлена. Вместо этого она будет скопирована в локальное хранилище.',

    'backup.conflict-database.dbMappingLegend' => 'Сопоставление серверов баз данных',
    'backup.conflict-database.serverType' => 'Тип сервера',
    'backup.conflict-database.hostName' => 'Имя сервера',
    'backup.conflict-database.port' => 'Порт',
    'backup.conflict-database.destinationDbServer' => 'Целевой сервер баз данных',
    'backup.conflict-database.mysql' => 'MySQL',
    'backup.conflict-database.postgresql' => 'PostgreSQL',
    'backup.conflict-database.mssql' => 'MSSQL',
    'backup.conflict-database.migrationDbServerNotFind' => 'База данных не может быть восстановлена: отсутствует подходящий сервер баз данных.',

    'backup.conflict-ip.buttonUploadMappingFile' => 'Загрузить файл сопоставления IP-адресов',
    'backup.conflict-ip.ipMappingLegend' => 'Сопоставление IP-адресов',
    'backup.conflict-ip.buttonSaveCurrentMapping' => 'Сохранить текущее сопоставление IP-адресов в файл',
    'backup.conflict-ip.ipAddressNotFound' => 'Нет ни одного свободного IP-адреса этого типа.',
    'backup.conflict-ip.sharedIp' => 'общий',
    'backup.conflict-ip.dedicatedIp' => 'выделенный',
    'backup.conflict-ip.fileNotFound' => 'Файл не должен быть пустым.',
    'backup.conflict-ip.invalidIpToMap' => 'Недопустимый старый IP-адрес: %%ip%%',
    'backup.conflict-ip.invalidMappingValue' => 'Недопустимый новый IP-адрес: %%ip%%',
    'backup.conflict-ip.ipNotFound' => 'IP-адрес %%ip%% не найден в базе данных.',
    'backup.conflict-ip.uploadIpMappingFileLegend' => 'Загрузить файл сопоставления IP-адресов',
    'backup.conflict-ip.ipMappingFileHint' => 'Файл сопоставления IP-адресов ‒ это обычный текстовый файл. Каждая строка такого файла содержит сопоставление IP-адресов в следующем формате: <старый IP-адрес> <новый IP-адрес>',
    'backup.conflict-ip.oldIp' => 'Старые IP-адреса',
    'backup.conflict-ip.newIp' => 'Новые IP-адреса',

    'backup.copy-to-server.ignoreBackupSign' => 'Загружать резервные копии, не имеющие действительной подписи',
    'backup.copy-to-server.wrongPassword' => 'Неверно указан пароль. Во время восстановления резервной копии Plesk попросит вас снова ввести пароль.',
    'backup.copy-to-server.corruptedSignatureUploaded' => 'Загруженный файл резервной копии %%fileName%% был изменен, поврежден или создан на другом сервере или в более ранней версии Plesk, которая не поддерживает подписи резервных копий. Прежде чем восстановить данные из этого файла, убедитесь, что он происходит из надежного источника.',
    'backup.copy-to-server.corruptedSignatureNotUploadedUser' => 'Не удалось загрузить файл резервной копии %%fileName%%. Этот файл содержит измененные или поврежденные данные или был создан на другом сервере или в более ранней версии Plesk. Чтобы восстановить данные из этого файла, обратитесь к своему хостинг-провайдеру.',
    'backup.copy-to-server.corruptedSignatureNotUploadedAdmin' => 'Не удалось загрузить файл резервной копии %%fileName%%. Этот файл был изменен, поврежден, создан на другом сервере или в более ранней версии Plesk, которая не поддерживает подписи резервных копий. Если вы уверены в надежности этого файла, включите опцию "Загружать резервные копии, не имеющие действительной подписи" и повторите попытку.',
    'backup.copy-to-server.unableToMoveToLocalRepository' => "Невозможно перенести выбранную резервную копию (%%fileName%%) в серверное хранилище. Ошибка: %%error%%.",
    'backup.copy-to-server.missedPartsWarning' => "Следующие части инкрементной резервной копии не были скопированы:%%endl%%%%missedParts%%%%endl%%Пожалуйста, скопируйте недостающие части.",

    'backup.ftp-settings.isActive' => 'Использовать FTP(S)-хранилище',
    'backup.ftp-settings.host' => 'IP-адрес или имя FTP-сервера',
    'backup.ftp-settings.directory' => 'Папка для хранения резервных копий',
    'backup.ftp-settings.directoryHint' => 'Например, /myfolder/mybackups/',
    'backup.ftp-settings.ftpLogin' => 'Имя FTP-пользователя',
    'backup.ftp-settings.ftpPassword' => 'Пароль FTP-пользователя',
    'backup.ftp-settings.usePassiveMode' => 'Использовать пассивный режим',
    'backup.ftp-settings.useFtps' => 'Использовать FTPS',
    'backup.ftp-settings.errorHostIsLocal' => 'Локальный FTP-сервер Plesk нельзя использовать как удаленное хранилище. Пожалуйста, укажите удаленный компьютер.',
    'backup.ftp-settings.warningHostIsLocal' => 'FTP(S)-хранилище настроено на сохранение резервных копий на сервере с файлами ваших подписок. Такая конфигурация не рекомендуется, так как это может привести к потере данных и переполнению диска.',
    'backup.ftp-settings.enterFtpLogin' => 'Введите верное имя пользователя.',
    'backup.ftp-settings.enterFtpPassword' => 'Введите верный пароль.',

    'backup.remote-settings.isActive' => 'Использовать хранилище',
    'backup.remote-settings.initError' => 'Не удалось инициализировать страницу настроек расширения %%extName%%: %%error%%',

    'backup.remote-storages.backupSecuritySettings' => 'Настройки безопасности резервного копирования',

    'backup.restore.detailsSection' => 'Подробности',
    'backup.restore.contentInfoSection' => 'Содержимое резервной копии',
    'backup.restore.restorationOptionsSection' => 'Параметры восстановления',
    'backup.restore.emailNotification' => 'Сообщить о завершении восстановления на',
    'backup.restore.comments' => 'Комментарии',
    'backup.restore.creationDate' => 'Дата создания',
    'backup.restore.systemNotes' => 'Системные оповещения',
    'backup.restore.ownerAdmin' => 'Создан администратором.',
    'backup.restore.ownerReseller' => 'Создан реселлером.',
    'backup.restore.ownerCustomer' => 'Создан клиентом.',
    'backup.restore.ownerServiceUser' => 'Создан дополнительным пользователем.',
    'backup.restore.partOfParentBackup' => 'Часть резервной копии типа %%type%%.',
    'backup.restore.server' => 'сервер',
    'backup.restore.reseller' => 'реселлер',
    'backup.restore.client' => 'клиент',
    'backup.restore.incremental' => 'Инкрементный.',
    'backup.restore.multiVolume' => 'Многотомный.',
    'backup.restore.backupSize' => 'Размер резервной копии',
    'backup.restore.backupSizeFirstIncremental' => '%%this%% (это дополнение) + %%base%% (первоначальная резервная копия) = %%total%%',
    'backup.restore.backupSizeIncremental' => '%%this%% (это дополнение) + %%prev%% (предыдущее дополнение) + %%base%% (первоначальная резервная копия) = %%total%%',
    'backup.restore.download' => 'Скачать',
    'backup.restore.downloadHint' => 'Скачать эту резервную копию на локальный компьютер.',
    'backup.restore.downloadDisabled' => 'Скачивание файлов резервных копий временно недоступно. Пожалуйста, повторите попытку позднее или обратитесь к своему сервис-провайдеру.',
    'backup.restore.copy' => 'Копировать в серверное хранилище',
    'backup.restore.copyHint' => 'Копировать выбранные резервные копии в серверное хранилище.',
    'backup.restore.contentInfo' => 'Резервная копия содержит',
    'backup.restore.restoreButton' => 'Восстановить',
    'backup.restore.mail' => 'Почта',
    'backup.restore.domainConfiguration' => 'Настройки домена',
    'backup.restore.virtualHost' => 'Контент виртуального сервера',
    'backup.restore.database' => 'Базы данных',
    'backup.restore.serverConfiguration' => 'Настройки сервера',
    'backup.restore.serverConfigurationLicense' => 'Ключ лицензии',
    'backup.restore.serverPersonalConfiguration' => 'Настройки учетной записи администратора',
    'backup.restore.serverPersonalDomains' => 'Домены администратора',
    'backup.restore.serverPersonalClients' => 'Клиенты администратора',
    'backup.restore.resellers' => 'Реселлеры',
    'backup.restore.resellerPersonalConfiguration' => 'Настройки реселлера',
    'backup.restore.resellerPersonalDomains' => 'Домены реселлера',
    'backup.restore.resellerPersonalClients' => 'Клиенты реселлера',
    'backup.restore.clientPersonalConfiguration' => 'Настройки клиента',
    'backup.restore.clientPersonalDomains' => 'Домены клиента',
    'backup.restore.restoreModifiedSection' => 'Восстановить резервную копию несмотря на поврежденную подпись',
    'backup.restore.restoreModifiedDump' => 'Восстановить эту резервную копию несмотря на отсутствие правильной подписи',
    'backup.restore.resolutionPolicy' => 'Политика разрешения конфликтов',
    'backup.restore.resolutionPolicyDescription' => 'Конфликты возникают, когда восстанавливаемый объект уже существует в системе с более поздней датой изменения либо отсутствует в системе.',
    'backup.restore.backupRestoreFtpWrongPassword' => 'Неверно указан пароль. Файл резервной копии будет скопирован в локальное хранилище сервера.',
    'backup.restore.backupRestoreLocalWrongPassword' => 'Не удалось восстановить резервную копию. Неверно указан пароль.',
    'backup.restore.serverContentAndConfiguration' => 'Настройки и контент сервера',
    'backup.restore.serverConfigurationOnly' => 'Настройки сервера',
    'backup.restore.resellerContentAndConfiguration' => 'Настройки и контент реселлера',
    'backup.restore.resellerConfigurationOnly' => 'Настройки реселлера',
    'backup.restore.clientContentAndConfiguration' => 'Настройки и контент клиента',
    'backup.restore.clientConfigurationOnly' => 'Настройки клиента',
    'backup.restore.domainContentAndConfiguration' => 'Настройки и контент домена',
    'backup.restore.domainConfigurationOnly' => 'Настройки домена',
    'backup.restore.restoreType' => 'Что вы хотите восстановить?',
    'backup.restore.restoreTypeFull' => 'Все объекты (система целиком)',
    'backup.restore.restoreTypeGranular' => 'Выбранные объекты',
    'backup.restore.restoreObjectType' => 'Тип объекта для восстановления',
    'backup.restore.restoreObjectTypeSubscriptions' => 'Подписка',
    'backup.restore.restoreObjectTypeCustomers' => 'Клиент',
    'backup.restore.restoreObjectTypeResellers' => 'Реселлер',
    'backup.restore.restoreObjectTypeMailUsers' => 'Учетная запись почты',
    'backup.restore.restoreObjectTypeDatabases' => 'База данных',
    'backup.restore.restoreObjectTypeCertificates' => 'SSL/TLS-сертификаты',
    'backup.restore.restoreObjectTypeSites' => 'Сайты',
    'backup.restore.restoreObjectTypeDnsZones' => 'DNS-зона',
    'backup.restore.restoreObjectTypeMailLists' => 'Списки рассылки',
    'backup.restore.restoreObjectTypeWebContent' => 'Файлы доменов',
    'backup.restore.restoreObjects' => '%%objectType%%',
    'backup.restore.restoreObjectsWebContent' => 'Выбранные файлы',
    'backup.restore.restoreSubscriptionLookup' => 'Подписка',
    'backup.restore.restoreComponents' => 'Компоненты для восстановления',
    'backup.restore.errorLog' => 'Журнал ошибок',
    'backup.restore.backupDetailsLogDoesntExist' => 'Журнал резервного копирования недоступен.',
    'backup.restore.dumpFailedSection' => 'Журнал ошибок',
    'backup.restore.dumpFailed' => 'Не удалось восстановить данные: неверный файл резервного копирования.',
    'backup.restore.granularNotSupported' => 'Объекты для восстановления можно выбрать, только если резервная копия была создана в Plesk 12.0 или выше.',
    'backup.restore.fullNotSupportedInResellerPowerUser' => 'В режиме Power User не поддерживается восстановление всех данных из резервных копий. Выберите объекты для восстановления. Режим интерфейса можно изменить на странице %%interfaceLink%%',
    'backup.restore.interfaceLink' => 'Настройки интерфейса',
    'backup.restore.contentRestoreType' => 'Восстановить',
    'backup.restore.contentRestoreTypeSettingsOnly' => 'Только настройки выбранных объектов',
    'backup.restore.contentRestoreTypeFull' => 'Настройки и контент выбранных объектов',
    'backup.restore.errorWrongFormat' => 'Не удалось восстановить резервную копию: неверное форматирование файла.',
    'backup.restore.errorContentError' => 'Не все данные можно восстановить: в резервной копии имеются ошибки содержания.',
    'backup.restore.warningSignError' => 'Не удалось подтвердить правильность подписи резервной копии. Возможно, эта резервная копия была изменена, повреждена, создана на другом сервере или в более ранней версии Plesk.',
    'backup.restore.warningSignErrorNotAdmin' => 'Эту резервную копию может восстановить только администратор Plesk.',
    'backup.restore.warningPartial' => "Следующие части инкрементной резервной копии не были найдены:%%endl%%%%missedParts%%%%endl%%Могут быть восстановлены не все файлы. Загрузите недостающие части и попробуйте повторить восстановление.",
    'backup.restore.warningDeprecatedBackupVersion' => 'Резервная копия, которую вы пытаетесь восстановить, была создана в неподдерживаемой версии Plesk и не может быть восстановлена. Используйте расширение Plesk Migrator для переноса данных со старых версий Plesk.',
    'backup.restore.encryptionKeyError' => 'Пароли для одной или более учетных записей в этой резервной копии не могут быть восстановлены и будут сброшены. Возможно, эта резервная копия была создана на другом сервере Plesk и зашифрована с помощью его ключа шифрования.',
    'backup.restore.errorCorruptedContent' => 'Следующие файлы не найдены или повреждены: ',
    'backup.restore.statusSection' => 'Состояние резервного копирования',
    'backup.restore.statusDetails' => 'Информация о состоянии',
    'backup.restore.restoreBlocked' => 'Не удается восстановить резервную копию.',
    'backup.restore.restoreBlockedDescription' => 'Невозможно восстановить резервную копию типа %%backupType%%. Чтобы ее восстановить, войдите как владелец этой резервной копии и нажмите ее имя в разделе Резервное копирование.',

    'backup.schedule.scheduleSection' => 'Расписание',
    'backup.schedule.backupEnable' => 'Включить регулярное резервное копирование',
    'backup.schedule.backupPeriod' => 'Выполнять эту задачу резервного копирования',
    'backup.schedule.on' => 'Вкл',
    'backup.schedule.at' => 'в',
    'backup.schedule.useIncremental' => 'Использовать инкрементное резервное копирование',
    'backup.schedule.fullBackupPeriod' => 'Выполнять полное резервное копирование',
    'backup.schedule.daily' => 'День',
    'backup.schedule.weekly' => 'Неделя',
    'backup.schedule.monthly' => 'Месяц',
    'backup.schedule.yearly' => 'Ежегодно',
    'backup.schedule.days' => 'дней',
    'backup.schedule.weeks' => 'недель',
    'backup.schedule.months' => 'месяцев',
    'backup.schedule.years' => 'лет',
    'backup.schedule.backupTimeDescription' => 'Часовой пояс: %%timezone%%.',
    'backup.schedule.systemTimeZone' => 'Часовой пояс системы по умолчанию',
    'backup.schedule.first' => 'первый',
    'backup.schedule.last' => 'последний',
    'backup.schedule.dayOfMonth' => 'день',
    'backup.schedule.email' => 'Сообщать об ошибках на этот адрес',
    'backup.schedule.invalidFields' => 'Некоторые поля не заполнены или заполнены неправильно: %%fields%%.',
    'backup.schedule.maxDumpFiles' => 'Максимальное количество хранимых полных резервных копий (включая созданные по расписанию и вручную)',
    'backup.schedule.maxDumpFilesUnlimitedDescription' => 'Если вы не хотите автоматически удалять полные резервные копии, оставьте это поле пустым.',
    'backup.schedule.maxDumpFilesLimitedDescription' => 'Ограничение хостинг-провайдера для хранилища сервера составляет %%max%%. Ваше ограничение для него должно быть меньше или равно %%max%%.',
    'backup.schedule.backupToCloudIsNotAllowed' => 'Хранение запланированных резервных копий подписок в удаленном облачном хранилище – дополнительная функция, которую вы можете купить в интернет-магазине Plesk.',

    'backup.secure-backup.hint' => 'Вы можете использовать пароль для шифрования паролей пользователей, содержащихся в базе данных Plesk в резервной копии. Имейте в виду, что при восстановлении защищенной паролем резервной копии без предоставления пароля Plesk сгенерирует пароли пользователей случайным образом.',
    'backup.secure-backup.hintAdmin' => 'Вы можете зашифровать пароли, содержащиеся в базе данных Plesk в резервных копиях, с помощью ключа шифрования или с помощью пароля. Ключ уникален для каждой установки Plesk. Резервные копии, зашифрованные таким ключом, могут быть восстановлены только на той же установке Plesk, где были созданы, и не могут быть восстановлены на других установках Plesk. Имейте в виду, что Plesk не защищает все конфиденциальные данные в резервной копии. Мы рекомендуем вам сохранять резервные копии в удаленном облачном хранилище и включить шифрование резервных копий на стороне хранилища.',
    'backup.secure-backup.usePasswordProtection' => 'Включить защиту паролем (рекомендуется)',
    'backup.secure-backup.backupPasswordSource' => 'Тип пароля',
    'backup.secure-backup.pleskKey' => 'Ключ шифрования Plesk',
    'backup.secure-backup.userPassword' => 'Указанный пароль',
    'backup.secure-backup.password' => 'Пароль',
    'backup.secure-backup.passwordConfirmation' => 'Повторите пароль',

    'backup.subform.settingsSection' => 'Настройки резервного копирования',
    'backup.subform.prefix' => 'Добавить префикс к имени резервной копии',
    'backup.subform.comment' => 'Комментарии',
    'backup.subform.splitSize' => 'Создать многотомную резервную копию, размер тома (Мб)',
    'backup.subform.repository' => 'Хранить в',
    'backup.subform.repositoryDescription' => 'FTP(S)-хранилище не настроено. %%configure%%',
    'backup.subform.localAndSpecialRepositoryBackup' => 'Серверном хранилище и %%name%%',
    'backup.subform.remoteRepository' => 'удаленное хранилище',
    'backup.subform.remoteRepositoryText' => 'Выберите удаленное облачное хранилище',
    'backup.subform.configureRemoteRepositories' => 'Вы можете <a href="%%url%%">настроить удаленные хранилища</a> на хранение ваших резервных копий в облаке',
    'backup.subform.configureFtpRepository' => 'Вы можете <a href="%%url%%">настроить FTP-хранилище</a> на хранение ваших резервных копий',
    'backup.subform.repositoryConfigure' => 'Настроить',
    'backup.subform.email' => 'Сообщить о завершении резервного копирования на',
    'backup.subform.contentSection' => 'Содержимое резервной копии',
    'backup.subform.domainConfiguration' => 'Настройка',
    'backup.subform.domainConfigurationVhost' => 'Пользовательские файлы и базы данных',
    'backup.subform.domainConfigurationMail' => 'Почтовые сообщения',
    'backup.subform.content' => 'Копировать',
    'backup.subform.backupAll' => 'Все настройки и контент',
    'backup.subform.backupConfiguration' => 'Только настройки',
    'backup.subform.backupVhost' => 'Все настройки и контент, кроме почтовых сообщений',
    'backup.subform.backupMail' => 'Только настройки и почтовые сообщения',
    'backup.subform.mssqlNativeBackup' => 'Если возможно, выполнять резервное копирование средствами MS SQL',
    'backup.subform.mssqlNativeBackupAdmin' => 'Используйте собственную функциональность резервного копирования MS SQL (для удаленных баз данных нужно сначала настроить удаленный сервер MSSQL на странице Инструменты и настройки >  Серверы баз данных)',
    'backup.subform.localRepository' => 'Серверное хранилище',
    'backup.subform.localRepositoryPath' => 'Серверном хранилище в %%path%%',
    'backup.subform.backupNodeRepository' => '',
    'backup.subform.ftpRepository' => 'FTP(S)-хранилище на %%uri%% <a href="%%link%%">Изменить настройки</a>',
    'backup.subform.ftpRepositoryText' => 'FTP(S)-хранилище на %%uri%%',
    'backup.subform.type' => 'Тип',
    'backup.subform.typeFullBackup' => 'Полный',
    'backup.subform.typeIncremental' => 'Инкрементный',
    'backup.subform.typeIncrementalDescription' => 'Копировать изменения данных веб- и почтового хостинга с момента последнего резервного копирования (базы данных всегда копируются полностью).',
    'backup.subform.incrementalNotAvailable' => 'Для создания инкрементной резервной копии сначала создайте полную резервную копию.',
    'backup.subform.excludeLogs' => 'Исключить файлы журналов',
    'backup.subform.excludeFiles' => 'Исключить определенные файлы из резервной копии',
    'backup.subform.excludeFilesDescription' => 'Вы можете исключить только файлы внутри веб-пространств. Укажите путь или пути относительно корня веб-пространства, разделяя файлы между собой запятыми. Можно использовать символ маски (например, /somedir/log*).',

    'backup.upload.uploadHint' => 'Здесь вы можете загрузить резервные копии в хранилище Plesk. Максимальный размер файла составляет 2 Гб.',
    'backup.upload.backupFile' => 'Файл резервной копии',
    'backup.upload.removeLink' => 'Удалить',
    'backup.upload.addFileLink' => 'Загрузить еще один файл',
    'backup.upload.backupSecuritySettings' => 'Настройки безопасности резервного копирования',
    'backup.upload.signatureHint' => 'В Plesk существует проверка файлов резервных копий на правильность структуры и подписи. Файлы, которые были изменены, повреждены или созданы на другом сервере, считаются ненадежными. Расположенная ниже опция позволяет восстанавливать данные из таких файлов. Используйте ее, только если резервная копия попала к вам из проверенного источника, так как загрузка такого файла может создать угрозу безопасности или нарушить работу сервера. Примечание: резервные копии, созданные в версиях ниже 11.5, считаются ненадежными, так как не имеют подписей. Такие файлы следует восстанавливать, только если вы доверяете их источнику.',
    'backup.upload.ignoreSign' => 'Загружать резервные копии, не имеющие действительной подписи',
    'backup.upload.passwordHint' => 'Если эта резервная копия защищена паролем, введите этот пароль в расположенные ниже поля. Обратите внимание, что если вы укажете неверный пароль, Plesk выдаст предупреждение, но все равно загрузит эту резервную копию на сервер. Во время ее восстановления вам нужно будет снова ввести этот пароль.',
    'backup.upload.alreadyExistsWarning' => 'Резервная копия %%fileName%% уже существует в локальном хранилище сервера.',
    'backup.upload.incorrectPasswordWarning' => 'Неверно указан пароль. Во время восстановления резервной копии Plesk попросит вас снова ввести пароль.',
    'backup.upload.deprecatedDumpError' => 'Резервная копия, которую вы пытаетесь загрузить, была создана в неподдерживаемой версии Plesk и не может быть импортирована. Используйте расширение Plesk Migrator для переноса данных со старых версий Plesk.',
    'backup.upload.mailFormatWarning' => 'Резервная копия %%fileName%% загружена в хранилище. Важно: резервная копия %%fileName%% содержит почтовые данные, которые не будут восстановлены, так как имеют неподдерживаемый формат (Plesk 8.3-8.6). Чтобы их восстановить, сохраните их резервную копию с помощью инструмента Plesk Backup и выберите опцию Back up mailboxes content /&amp;gt; with dump restored to any mail server.',
    'backup.upload.corruptedSignatureAdminWarning' => 'Файл резервной копии %%fileName%% был изменен, поврежден или создан на другом сервере или в более ранней версии Plesk, которая не поддерживает подписи резервных копий. Прежде чем восстановить данные из этого файла, убедитесь, что он происходит из надежного источника.',
    'backup.upload.corruptedSignatureAdminError' => 'Не удалось загрузить файл резервной копии (%%fileName%%). Этот файл был изменен, поврежден, создан на другом сервере или в более ранней версии Plesk, которая не поддерживает подписи резервных копий. Если вы уверены в надежности этого файла, включите опцию "Загружать резервные копии, не имеющие действительной подписи" и повторите попытку.',
    'backup.upload.corruptedSignatureUserWarning' => 'Файл резервной копии %%fileName%% содержит измененные или поврежденные данные или был создан на другом сервере или в более ранней версии Plesk.',
    'backup.upload.corruptedSignatureUserError' => 'Не удалось загрузить файл резервной копии (%%fileName%%). Этот файл содержит измененные или поврежденные данные или был создан на другом сервере или в более ранней версии Plesk. Чтобы восстановить данные из этого файла, обратитесь к своему хостинг-провайдеру.',
    'backup.upload.uploadError' => 'Невозможно загрузить %%fileName%% в серверное хранилище: %%error%%',
    'backup.upload.fileNotSelected' => 'Не выбраны файлы для загрузки. Выберите хотя бы один файл.',
    'backup.upload.missedPartsWarning' => "Следующие части инкрементной резервной копии не были загружены:%%endl%%%%missedParts%%%%endl%%Пожалуйста, загрузите недостающие части.",
    'backup.upload.unknownType' => 'Неизвестный тип объекта',
    'backup.upload.storageLink' => 'другое хранилище',
    'backup.upload.anotherStorage' => 'Дамп был загружен в %%storageLink%%.',
    'backup.upload.resellerNotFound' => 'Реселлер %%name%% не найден. Сначала создайте его, чтобы восстановить загруженный дамп.',
    'backup.upload.clientNotFound' => 'Клиент %%name%% не найден. Сначала создайте его, чтобы восстановить загруженный дамп.',
    'backup.upload.domainNotFound' => 'Домен %%name%% не найден. Сначала создайте его, чтобы восстановить загруженный дамп.',

    'backup.web-content-dynamic.addButtonTitle' => 'Добавить файлы',
    'backup.web-content-dynamic.noItems' => 'Файлы не выбраны',
    'backup.web-content-dynamic.hint' => 'Выделите нужные файлы и папки с помощью галочек.',
    'backup.web-content-dynamic.title' => 'Выбрать файлы',
    'backup.web-content-dynamic.columnName' => 'Имя',
    'backup.web-content-dynamic.columnChangeDate' => 'Дата последнего изменения',
    'backup.web-content-dynamic.columnSize' => 'Размер',
    'backup.web-content-dynamic.columnPermissions' => 'Права',
    'backup.web-content-dynamic.columnUser' => 'Пользователь',
    'backup.web-content-dynamic.columnGroup' => 'Группа',
    'backup.web-content-dynamic.waitButtonTitle' => 'Пожалуйста, подождите',
    'backup.web-content-dynamic.loadingTitle' => 'Пожалуйста, подождите. Загрузка...',

    'backup.invalidFields' => 'Некоторые поля не заполнены или заполнены неправильно.',
    'backup.notEnoughDiskSpace' => 'Недостаточно места на диске по пути %%path%% для создания резервной копии. Необходимо как минимум %%required%% Гб свободного места (доступно %%available%% Гб)',

    'cgroups-settings.cgroupsSettingsTab' => 'Память, процессор, ввод-вывод диска',
    'cgroups-settings.cgroupsSettingsTabDescription' => 'Установить ограничения на потребление подпиской системных ресурсов. Plesk использует функцию ядра Linux control groups (cgroups) для контроля за тем, чтобы ограничения не превышались.',
    'cgroups-settings.cpuSettings' => 'Процессор',
    'cgroups-settings.cpuSettingsDescription' => 'Установить для отдельных подписок указанное ограничение на использование процессора.',
    'cgroups-settings.cpuPeriodLimit' => 'Период проверки загрузки процессора',
    'cgroups-settings.percentUsageDescription' => 'Общее количество используемого процессорного времени для вашего сервера составляет %%total%%%%units%%',
    'cgroups-settings.ramSettings' => 'Память',
    'cgroups-settings.ramSettingsDescription' => 'Установить для отдельных подписок указанное ограничение на использование памяти. Обратите внимание на то, что если подписка превышает ограничение, будет остановлен процесс, потребляющий наибольшее количество ресурса.',
    'cgroups-settings.ramPeriodLimit' => 'Период проверки использования памяти',
    'cgroups-settings.diskSettings' => 'Ввод-вывод диска',
    'cgroups-settings.diskReadSettings' => 'Чтение диска',
    'cgroups-settings.diskReadSettingsDescription' => 'Установить для отдельных подписок указанное ограничение на использование пропускной способности чтения с диска.',
    'cgroups-settings.diskReadPeriodLimit' => 'Период проверки скорости чтения диска',
    'cgroups-settings.diskWriteSettings' => 'Запись на диск',
    'cgroups-settings.diskWriteSettingsDescription' => 'Установить для отдельных подписок указанное ограничение на использование пропускной способности записи на диск.',
    'cgroups-settings.diskWritePeriodLimit' => 'Период проверки скорости записи на диск',
    'cgroups-settings.limit' => 'Ограничение',
    'cgroups-settings.threshold' => 'Уведомить при превышении',
    'cgroups-settings.limitNotificationEnabled' => 'Уведомления включены',
    'cgroups-settings.periodFiveMinutes' => '5 минут',
    'cgroups-settings.periodHour' => '1 час',
    'cgroups-settings.periodDay' => '1 день (24 часа)',
    'cgroups-settings.mb' => 'Mб',
    'cgroups-settings.mbs' => 'Мб/с',

    'custom-button.privateLabel' => 'Показывать только мне',
    'custom-button.textLabel' => 'Название кнопки',
    'custom-button.tooltipLabel' => 'Текст подсказки',
    'custom-button.iconLabel' => 'Фоновое изображение',
    'custom-button.priorityLabel' => 'Приоритет',
    'custom-button.urlLabel' => 'URL-адрес',
    'custom-button.urlParamsLabel' => 'Добавить параметры в URL-адрес',
    'custom-button.placeLabel' => 'Расположение',
    'custom-button.internalLabel' => 'Открыть ссылку в Plesk',
    'custom-button.internalDescription' => 'Укажите, где следует открывать ссылку: на странице Plesk или в новом окне браузера.',
    'custom-button.noFrameLabel' => 'Не использовать фреймы',
    'custom-button.noFrameDescription' => 'Если персональная кнопка ведет на какое-либо расширение Plesk или приложение в Панели клиента, вы можете указать, как его следует показывать: во фрейме или как часть интерфейса Plesk.',
    'custom-button.urlParamLabel_dom_id' => 'Включить ID подписки, домена и псевдонима домена',
    'custom-button.urlParamLabel_dom_name' => 'Включить основное имя домена',
    'custom-button.urlParamLabel_ftp_user' => 'Включить имя пользователя FTP',
    'custom-button.urlParamLabel_ftp_pass' => 'Включить пароль FTP',
    'custom-button.urlParamLabel_cl_id' => 'Включить ID клиента',
    'custom-button.urlParamLabel_cname' => 'Включить название компании клиента',
    'custom-button.urlParamLabel_pname' => 'Включить контактное имя клиента',
    'custom-button.urlParamLabel_email' => 'Включить адрес электронной почты клиента',
    'custom-button.buttonPlace_navigation' => 'Общий доступ',
    'custom-button.buttonPlace_admin' => 'Домашняя страница администратора',
    'custom-button.buttonPlace_admin-settings' => 'Страница Инструменты и настройки в панели администратора',
    'custom-button.buttonPlace_reseller' => "Домашняя страница реселлера",
    'custom-button.buttonPlace_reseller-settings' => 'Страница Инструменты и утилиты в панели реселлера',
    'custom-button.buttonPlace_client' => 'Домашняя страница клиента',
    'custom-button.buttonPlace_domain' => "Страница подписки Сайты и домены",
    'custom-button.buttonPlace_domain_powerUser' => "Страница Сайты и домены веб-пространства",
    'custom-button.buttonPlace_domain-properties' => 'Инструментарий сайтов',

    'domain.connection-info.title' => 'Информация о подключении',
    'domain.connection-info.systemUserCredentials' => 'Учетные данные системного пользователя',
    'domain.connection-info.systemUserCredentialsHint' => 'Доступ по FTP включен всегда, а доступ по SSH или по протоколу удаленного рабочего стола — только, если %%details%%.',
    'domain.connection-info.systemUserCredentialsHintDetails' => 'есть соответствующее право',
    'domain.connection-info.systemUserRemoveAccessEnabled' => 'Доступ по SSH или протоколу рабочего стола включен, и вы не можете управлять его состоянием.',
    'domain.connection-info.systemUserRemoveAccessDisabled' => 'Доступ по SSH или протоколу рабочего стола отключен, и вы не можете управлять его состоянием.',
    'domain.connection-info.ipAddress' => 'IP-адрес',
    'domain.connection-info.copyToClipboard' => 'Скопировать в буфер обмена',
    'domain.connection-info.username' => 'Имя пользователя',
    'domain.connection-info.password' => 'Пароль',
    'domain.connection-info.changeSystemUserPasswordTitle' => 'Изменение пароля системного пользователя',
    'domain.connection-info.changePasswordTooltip' => 'Изменить пароль',
    'domain.connection-info.newPassword' => 'Новый пароль',
    'domain.connection-info.manageAccess' => 'Управление доступом',
    'domain.connection-info.additionalFtpAccounts' => 'Дополнительные учетные записи FTP',
    'domain.connection-info.database' => 'База данных',
    'domain.connection-info.databaseHint' => '1 из %%number%% баз данных, принадлежащих подписке.',
    'domain.connection-info.databaseNotCreatedHint' => 'База данных не создана.',
    'domain.connection-info.databaseType.mysql' => 'MySQL',
    'domain.connection-info.databaseType.mssql' => 'MS SQL Server',
    'domain.connection-info.databaseType.postgresql' => 'PostgreSQL',
    'domain.connection-info.databaseType.mariadb' => 'MariaDB',
    'domain.connection-info.databaseType.percona' => 'Percona',
    'domain.connection-info.databaseHost' => 'Хост',
    'domain.connection-info.databaseHostValue' => '%%value%% (%%fork%%)',
    'domain.connection-info.databaseName' => 'Имя базы данных',
    'domain.connection-info.addDatabase' => 'Добавить базу данных',
    'domain.connection-info.manageDatabases' => 'Управление базами данных',
    'domain.connection-info.phpMyAdmin' => 'phpMyAdmin',
    'domain.connection-info.myLittleAdmin' => 'myLittleAdmin',
    'domain.connection-info.changeDatabaseUserPasswordTitle' => 'Изменение пароля пользователя базы данных',
    'domain.connection-info.changeDatabaseUserPasswordNotice' => 'После изменения пароля не забудьте обновить его в файлах конфигурации или в своем приложении.',
    'domain.connection-info.buttonSave' => 'Сохранить',
    'domain.connection-info.buttonSaving' => 'Сохранение...',
    'domain.connection-info.buttonCancel' => 'Отмена',

    'domain.move.title' => 'Переместить домен %%name%%',
    'domain.move.hint' => 'Домен будет перемещен в новую подписку вместе с содержимым, файлами конфигурации, файлами журналов и APS-приложениями.',
    'domain.move.hintMain' => 'Домен будет перемещен в новую подписку вместе с содержимым, файлами конфигурации, файлами журналов, базами данных, пользователями баз данных, дополнительными FTP-пользователями, запланированными задачами, smb-пользователями и APS-приложениями.',
    'domain.move.hintSubdomains' => 'Субдомены %%subdomains%% будут перемещены вместе с родительским доменом.',
    'domain.move.hintAliases' => 'Псевдонимы домена %%aliases%% будут перемещены вместе с родительским доменом.',
    'domain.move.hintSubdomainsAndAliases' => 'Субдомены %%subdomains%% и псевдонимы доменов %%aliases%% будут перемещены вместе с родительским доменом.',
    'domain.move.labelDatabases' => 'После перемещения домена открыть вкладку "Базы данных" для перемещения соответствующих баз данных.',
    'domain.move.hintDatabases' => 'Если необходимо, переместите базы данных отдельно.',

    'domain.move.Form.submitButton' => 'Переместить',
    'domain.move.Form.cancelButton' => 'Отмена',

    'domain.move.selectTarget' => 'Доступные подписки',
    'domain.move.nothingFound' => 'Ничего не найдено',
    'domain.move.targetIsRequred' => 'Выбрать подписку, чтобы переместить на нее домен.',
    'domain.move.selectNewSubscription' => 'Создать новую подписку',
    'domain.move.ipv4Address' => 'IPv4-адрес',
    'domain.move.ipv4AddressHint' => 'IP-адрес сайта является сетевым адресом его виртуального сервера.',
    'domain.move.ipv6Address' => 'IPv6-адрес',
    'domain.move.ipv6AddressHint' => 'IP-адрес сайта является сетевым адресом его виртуального сервера.',
    'domain.move.ipAddressIsNotSelected' => 'Выберите хотя бы один IP-адрес.',
    'domain.move.username' => 'Имя пользователя',
    'domain.move.usernameHint' => 'Системная учетная запись, связанная с веб-пространством. Используется для доступа к размещенным файлам по FTP and SSH.',
    'domain.move.usernameIsRequred' => 'Необходимо указать имя пользователя.',
    'domain.move.password' => 'Пароль',
    'domain.move.passwordIsRequred' => 'Вы должны указать пароль.',
    'domain.move.noAvailableSubscriptions' => 'Нет доступных подписок',
    'domain.move.noWebHosting' => 'Системный пользователь не будет создан, так как у домена нет веб-хостинга.',

    'domain.rename.title' => 'Изменить имя домена',
    'domain.rename.titleAlias' => 'Изменить имя псевдонима домена',
    'domain.rename.hint' => 'Здесь вы можете переименовать домен %%domainName%%',
    'domain.rename.hintAlias' => 'Здесь вы можете переименовать псевдоним домена %%domainName%%',
    'domain.rename.name' => 'Новое имя домена',
    'domain.rename.nameAlias' => 'Новое имя псевдонима домена',
    'domain.rename.domainNameIsRequired' => 'Это обязательное поле. Пожалуйста, заполните его.',
    'domain.rename.submitButton' => 'Изменить',
    'domain.rename.submitButtonProgress' => 'Изменение',
    'domain.rename.successMessage' => 'Имя домена %%oldName%% изменено на %%newName%%.',
    'domain.rename.successMessageAlias' => 'Имя псевдонима домена %%oldName%% изменено на %%newName%%.',

    'domain.rename.Form.cancelButton' => 'Отмена',

    'domain.outgoing-messages.hint' => 'Здесь вы можете изменить ограничение на количество исходящих сообщений для данного домена. Отправка сообщений свыше этого ограничения будет невозможна.',
    'domain.outgoing-messages.domainOutgoingMessagesSubscriptionDefault' => 'По умолчанию (%%domainOutgoingMessages%% сообщений в час)',
    'domain.outgoing-messages.domainOutgoingMessagesSpecificHint' => 'сообщений в час',
    'domain.outgoing-messages.domainOutgoingMessages' => 'Ограничение на исходящие сообщения',
    'domain.outgoing-messages.domainOutgoingMessagesCustomLimit' => 'Отдельное значение',

    'domain.tech-domain-name.title' => 'Выберите имя домена',
    'domain.tech-domain-name.techDomainTitle' => 'Временное имя домена',
    'domain.tech-domain-name.customDomainTitle' => 'Зарегистрированное имя домена',
    'domain.tech-domain-name.techDomainText' => 'У меня пока нет зарегистрированного имени домена',
    'domain.tech-domain-name.customDomainText' => 'У меня уже есть зарегистрированное имя домена',
    'domain.tech-domain-name.techDomain' => 'Ваше временное имя домена',
    'domain.tech-domain-name.customDomain' => 'Зарегистрированное имя домена',
    'domain.tech-domain-name.domainName' => 'Имя домена',
    'domain.tech-domain-name.techDomainDesc' => 'Временные имена доменов используются для получения доступа к сайту до того, как вы зарегистрируете и купите подходящее имя домена. Они предоставляются бесплатно на следующих условиях:',
    'domain.tech-domain-name.techDomainRandom' => 'Имена генерируются случайным образом',
    'domain.tech-domain-name.techDomainDns' => 'Они резмещаются в DNS-зоне .plesk.page',
    'domain.tech-domain-name.techDomainMail' => 'Вы не можете использовать почту с временным именем домена',
    'domain.tech-domain-name.techDomainSwitch' => 'Вы можете начать использовать зарегистрированное имени домена в любой момент позже, переименовав домен в настройках домена.',
    'domain.tech-domain-name.error' => 'Произошла непредвиденная ошибка.',
    'domain.tech-domain-name.errorNoIpAddress' => 'Необходимо выбрать IP-адрес.',
    'domain.tech-domain-name.generating' => 'Создание...',

    'get-password.label' => 'Сбросить пароль',
    'get-password.text' => 'Введите свой адрес электронной почты или имя пользователя, зарегистрированное в Plesk, и мы отправим вам письмо для сброса пароля.',
    'get-password.emailLabel' => 'Электронная почта',
    'get-password.loginLabel' => 'Имя пользователя',
    'get-password.send' => 'Отправить',
    'get-password.cancel' => 'Отмена',
    'get-password.errorInvalidEmail' => 'Адрес электронной почты не распознан. Пожалуйста, проверьте его еще раз и повторите попытку.',
    'get-password.messageSend' => "Письмо для сброса пароля отправлено на зарегистрированный адрес электронной почты.\nЕсли это письмо еще не пришло, пожалуйста, обратитесь к своему администратору Plesk.",

    'iis-settings.formGeneralHint' => 'Здесь вы можете указать настройки веб-сервера IIS для своего сайта, внеся необходимые изменения в стандартные значения. Индивидуальная конфигурация IIS может пригодиться, например, если вы захотите использовать на своем сайте новый вид стартовых страниц или привязать тот или иной тип MIME к определенным расширениям файлов. Значения по умолчанию задаются вашим хостинг-провайдером.',
    'iis-settings.formGeneralHint_powerUser' => 'Здесь вы можете указать настройки веб-сервера IIS для текущего сайта. Индивидуальная конфигурация IIS может пригодиться, например, если вы захотите использовать на своем сайте новый вид стартовых страниц или привязать тот или иной тип MIME к определенным расширениям файлов. Значения по умолчанию означают, что IIS будет использовать соответствующие директивы из своей стандартной конфигурации.',
    'iis-settings.virtualDirectoryLoadError' => 'Невозможно получить свойства указанной виртуальной папки: %%errorMessage%%',
    'iis-settings.general' => 'Общие настройки',
    'iis-settings.example' => "Пример:\n%%example%%",
    'iis-settings.settingOn' => 'Вкл.',
    'iis-settings.settingOff' => 'Откл. (по умолчанию)',
    'iis-settings.settingDefault' => 'По умолчанию',
    'iis-settings.settingCustom' => 'Ввести свое значение',
    'iis-settings.mimeTypes' => 'Типы MIME',
    'iis-settings.mimeTypesExample' => "text/plain .mytxt\nimage/jpeg .myjpeg \n\nТипы MIME обеспечивают привязку расширений файлов к типам файлов. Обычно это используется для создания дополнительных расширений файлов для стандартных типов файлов.",
    'iis-settings.documents' => 'Документы по умолчанию',
    'iis-settings.documentsOff' => 'Отключено',
    'iis-settings.documentsCustom' => 'Ввести значения',
    'iis-settings.documentsExample' => "Index.html\nIndex.htm\nIndex.cfm \n\nЕсли окажется так, что браузер не сможет определить имя того или иного документа внутри вашего сайта, IIS попробует найти заданные вами документы по умолчанию и выдаст первый из их списка. Если вы не укажете ни одного документа по умолчанию и при этом включите опцию Просмотр папки, то вместо стартовой страницы в браузере будет показано содержимое папки вашего сайта.",
    'iis-settings.expires' => 'Заканчивается',
    'iis-settings.expiresDescription' => 'Веб-сервер добавит на веб-страницы заголовки ответов "Expires". Временная метка истечения срока хранения страницы получается путем добавления указанного выше количества времени к времени запроса страницы.',
    'iis-settings.expiresUnitDays' => 'дней',
    'iis-settings.expiresUnitHours' => 'часов',
    'iis-settings.expiresUnitMinutes' => 'минут',
    'iis-settings.expiresUnitSeconds' => 'секунд',
    'iis-settings.headers' => 'Дополнительные заголовки',
    'iis-settings.headersExample' => "Cache-Control: public\nStrict-Transport-Security: max-age=63072000; includeSubdomains;\nX-Frame-Options: DENY\n\nВеб-сервер добавит указанные заголовки HTTP-ответов.",
    'iis-settings.directoryBrowsing' => 'Просмотр папки',
    'iis-settings.directoryBrowsingDescription' => 'Позволяет пользователям просматривать содержимое папки сайта в браузере, например, когда недоступна стартовая страница по умолчанию.',
    'iis-settings.securityTabDirectory' => 'Настройки безопасности папки',
    'iis-settings.allowAnonymous' => 'Анонимный доступ',
    'iis-settings.allowAnonymousDescription' => 'Анонимный доступ обеспечивает пользователям доступ к публичному контенту вашего сайта. Контент, защищенный паролем или средствами файловой системы, анонимным пользователям будет недоступен.',
    'iis-settings.allowWindows' => 'Аутентификация Windows',
    'iis-settings.allowWindowsDescription' => 'Аутентификация Windows (ранее NTLM) защищает контент вашего сайта на уровне файловой системы.',
    'iis-settings.requireSsl' => 'Принудительное использование SSL/TLS',
    'iis-settings.requireSslDescription' => 'Если на вашем сайте включена поддержка SSL/TLS, то данная опция позволит сделать так, чтобы веб-клиенты (браузеры) в принудительном порядке использовали только защищенные HTTPS-соединения.',
    'iis-settings.securityTabIpDeny' => 'Настройки ограничения доступа',
    'iis-settings.deny' => 'Запретить доступ к сайту',
    'iis-settings.denyOff' => 'По умолчанию',
    'iis-settings.denyCustom' => 'Ввести свое значение',
    'iis-settings.allow' => 'Исключения',
    'iis-settings.denyExample' => "10.1.0.0/16\n192.168.1.110\n\nУказанным здесь серверам и сетям будет запрещен доступ к текущему сайту. Чтобы запретить все подключения, введите '*'.",
    'iis-settings.allowExample' => "192.168.0.0/16\n10.1.1.21\n\nУказанным здесь серверам и сетям будет разрешен доступ к текущему сайту.",
    'iis-settings.dynamicIpSecurity' => 'Защита от DoS-атак с помощью динамического ограничения IP-адресов (IIS)',
    'iis-settings.isDenyByConcurrentRequests' => 'Ограничивать доступ по количеству одновременных запросов с уникального IP-адреса',
    'iis-settings.maxConcurrentRequests' => 'Максимальное количество одновременных запросов',
    'iis-settings.isDenyByRequestRate' => 'Ограничивать доступ по количеству запросов за определенный период',
    'iis-settings.maxRequests' => 'Максимальное количество запросов',
    'iis-settings.requestInterval' => 'Период времени (в миллисекундах)',

    'ip-addresses-selector.ipAddress' => 'IP-адрес',
    'ip-addresses-selector.ipv4Address' => 'IPv4-адрес',
    'ip-addresses-selector.ipv4AddressHint' => "IP-адрес сайта является сетевым адресом его виртуального сервера.",
    'ip-addresses-selector.ipv6Address' => 'IPv6-адрес',
    'ip-addresses-selector.ipv6AddressHint' => "IP-адрес сайта является сетевым адресом его виртуального сервера.",
    'ip-addresses-selector.noIpAddressHint' => 'Нет',
    'ip-addresses-selector.shared' => 'общий',
    'ip-addresses-selector.exclusive' => 'выделенный',
    'ip-addresses-selector.ipV6OnlyNotSupported' => 'FTP-сервер не поддерживает IPv6. Предоставьте хотя бы один IPv4-адрес, иначе пользователь не сможет загружать файлы на сервер по FTP.',

    'log-rotation.customLogsDescription' => 'Обратите внимание на то, что ваши персональные журналы не обрабатываются.',
    'log-rotation.logRotation' => 'Ротация журналов',
    'log-rotation.logRotationCondition' => 'Условие ротации журналов',
    'log-rotation.logRotationBySize' => 'По объему',
    'log-rotation.logRotationByTime' => 'По времени',
    'log-rotation.logRotationDaily' => 'Ежедневно',
    'log-rotation.logRotationWeekly' => 'Еженедельно',
    'log-rotation.logRotationMonthly' => 'Ежемесячно',
    'log-rotation.logRotationSizeDescription' => 'Размер должен находиться в диапазоне от %%min%% до %%max%% Кб.',
    'log-rotation.maximumNumberOfFiles' => 'Максимальное количество журналов',
    'log-rotation.compress' => 'Архивировать журналы',
    'log-rotation.sendLogToEmail' => 'После того как Plesk получит данные из журналов веб- и FTP-серверов, отправить журналы на этот адрес',
    'log-rotation.kb' => 'Кб',
    'log-rotation.logRotationPeriodGreater' => 'Период не может превышать серверное ограничение %%max%%.',

    'login.loginLabel' => 'Имя пользователя',
    'login.passwdLabel' => 'Пароль',
    'login.localeLabel' => 'Язык интерфейса',
    'login.defaultLocale' => 'По умолчанию',
    'login.loginButtonLabel' => 'Войти',
    'login.enterLoginAndPasswd' => 'Введите ваше имя пользователя и пароль.',
    'login.whatUsernamePassword' => 'Какой логин и пароль использовать?',
    'login.forgotPasswordLabel' => 'Забыли пароль?',
    'login.cookies' => 'Политика файлов cookie в Plesk',
    'login.avoidSSLWarningsMsg' => 'Чтобы избежать предупреждений SSL во время входа в Plesk, используйте %%link%%',
    'login.digitalOceanMsg' => 'Впервые в Plesk на DigitalOcean? Используйте "root" и пароль, введенный при создании этого дроплета для входа в систему.%%link%%',
    'login.amazonLightsailMsg' => 'Впервые в Plesk на Lightsail? Чтобы войти в Plesk, войдите на сервер через SSH и используйте команду "plesk login".%%link%%',
    'login.readGuide' => 'Прочтите полное руководство.',

    'panel-access.title' => 'Изменение URL-адреса Plesk',
    'panel-access.hint' => 'Выберите персональные URL-адреса для входа в Plesk. Это не отменит возможности входа в Plesk через порт %%httpsPort%%. %%link%%',
    'panel-access.details' => 'Подробнее',
    'panel-access.proxyEnabled' => 'Все домены или субдомены, которые преобразуются в IP-адрес сервера, но не используются для хостинга',
    'panel-access.proxyDomain' => 'Указанный домен или субдомен, который преобразуется в IP-адрес сервера, но не используется для хостинга',
    'panel-access.proxyDisabled' => 'Персональные URL-адреса недоступны. Доступен только адрес https://<server-IP-or-hostname>:%%httpsPort%%',

    'panel-access.Form.submitButton' => 'Сохранить',
    'panel-access.Form.cancelButton' => 'Отмена',

    'panel-access.domainNameIsRequired' => 'Необходимо указать имя домена.',
    'panel-access.successMessage' => 'Выбранный способ входа применен.',
    'panel-access.notSupported' => 'Ваш Plesk не поддерживает выбранный способ входа.',
    'panel-access.notViaDomainName' => 'Чтобы применить этот способ, выберите первую опцию ("Все домены и субдомены..."), войдите в Plesk по ссылке https://%%domainName%%, а затем выберите вторую опцию.',
    'panel-access.notViaPort' => 'Чтобы применить этот способ, сначала войдите в Plesk по ссылке https://<server-IP-or-hostname>:%%httpsPort%%.',

    'php-settings.performance' => 'Настройки производительности и безопасности',
    'php-settings.settings' => 'Общие настройки',
    'php-settings.fastCgiSettings' => 'Настройки FastCGI',
    'php-settings.fpmSettings' => 'Настройки PHP-FPM',
    'php-settings.enableFastcgi' => 'Включить настройки FastCGI',
    'php-settings.plainTextEditing' => 'Дополнительные директивы',
    'php-settings.placeAdditionalCustomizationDirectivesHere' => 'Вы можете задать любые параметры PHP, введя их в поле ниже. Эти директивы будут включены в конфигурацию PHP. Используйте тот же синтаксис, что и в файле php.ini. Например, чтобы автоматически загрузить расширение mSQL, добавьте строку: extension=msql.so.',
    'php-settings.placeAdditionalCustomizationDirectivesHereAddonPlan' => 'Если вы не нашли нужные параметры PHP в приведенном выше списке, вы можете добавить их вручную. Эти дополнительные директивы будут объединены с директивами основного тарифного плана. Пожалуйста, используйте такой же синтаксис, как для php.ini. Например, чтобы включить автоматическую загрузку расширения mSQL, добавьте следующую строку: extension=msql.so.',
    'php-settings.placeFpmAdditionalCustomizationDirectivesHere' => 'Вы можете задать любые параметры PHP, введя их в поле ниже. Эти директивы будут включены в конфигурацию PHP. Используйте тот же синтаксис, что и в файле php.ini. Например, чтобы автоматически загрузить расширение mSQL, добавьте строку: extension=msql.so. Чтобы изменить настройки пула PHP-FPM, добавьте разделитель [php-fpm-pool-settings] и введите ниже необходимые настройки.',
    'php-settings.additionalConfigurationDirectives' => 'Дополнительные директивы',
    'php-settings.defaultValue' => 'По умолчанию',
    'php-settings.predefinedValue' => 'Выбрать значение',
    'php-settings.customValue' => 'Ввести свое значение',
    'php-settings.phpSettingDescription_memory_limit' => 'Максимальное количество памяти в байтах, которое может выделить скрипт.',
    'php-settings.phpSettingDescription_max_execution_time' => 'Максимальная продолжительность исполнения скрипта до его прерывания (в секундах).',
    'php-settings.phpSettingDescription_max_input_time' => 'Максимальная продолжительность интерпретации входных данных скриптом (в секундах).',
    'php-settings.phpSettingDescription_post_max_size' => 'Максимальный размер данных, которые могут быть переданы методом POST (в байтах). Обычно это значение больше upload_max_filesize и меньше memory_limit.',
    'php-settings.phpSettingDescription_upload_max_filesize' => 'Максимальный размер загружаемого файла в байтах.',
    'php-settings.phpSettingDescription_safe_mode' => 'Безопасный режим PHP накладывает ряд ограничений на выполнение скриптов главным образом из соображений безопасности.',
    'php-settings.phpSettingDescription_safe_mode_include_dir' => 'Скрипты PHP имеют доступ к файлам в указанных папках, когда используется директива safe_mode. Эта папка также должна быть в include_path.',
    'php-settings.phpSettingDescription_safe_mode_exec_dir' => 'Программы в указанных папках могут выполняться скриптами PHP, когда используется директива safe_mode.',
    'php-settings.phpSettingDescription_include_path' => 'Список папок, в которых скрипты будут искать файлы (аналог системной переменной PATH). В качестве разделителя используйте двоеточие (:) в Linux и точку с запятой (;) в Windows.',
    'php-settings.phpSettingDescription_sessionsave_path' => 'Папка для хранения файлов сессий PHP.',
    'php-settings.phpSettingDescription_mailforce_extra_parameters' => 'Дополнительные параметры функции mail().',
    'php-settings.phpSettingDescription_register_globals' => 'Зарегистрировать содержимое переменных EGPCS (Environment, GET, POST, Cookie, Server) в качестве глобальных переменных.',
    'php-settings.phpSettingDescription_open_basedir' => 'Скрипты PHP имеют доступ к файлам в указанных папках. В качестве разделителя используйте двоеточие (:) в Linux и точку с запятой (;) в Windows.',
    'php-settings.phpSettingDescription_error_reporting' => 'Уровень сообщений об ошибках.',
    'php-settings.phpSettingDescription_display_errors' => 'Определяет, нужно ли показывать ошибки в выводе.',
    'php-settings.phpSettingDescription_log_errors' => 'Включить ведение журнала ошибок PHP.',
    'php-settings.phpSettingDescription_allow_url_fopen' => 'Позволяет функциям файла PHP получать данные из удаленных источников по FTP или HTTP.',
    'php-settings.phpSettingDescription_file_uploads' => 'Позволяет загружать файлы по HTTP.',
    'php-settings.phpSettingDescription_short_open_tag' => 'Позволяет использовать сокращенную форму ( ) открывающего тега PHP.',
    'php-settings.phpSettingDescription_magic_quotes_gpc' => 'Включает режим magic_quotes для операций GPC (Get/Post/Cookie). При включенном режиме magic_quotes все специальные символы: одинарные кавычки, двойные кавычки, обратная косая черта и нулевые символы — автоматически экранируются обратной косой чертой.',
    'php-settings.phpSettingDescription_disable_functions' => 'Эта директива позволяет отключить некоторые функции. Она принимает на вход список имен функций, разделенных запятыми.',
    'php-settings.phpSupport' => 'Поддержка PHP',
    'php-settings.phpRunAs' => 'запускать PHP как',
    'php-settings.phpVersion' => 'Версия PHP',
    'php-settings.phpHandlerOutdated' => '(Устаревшая опция)',
    'php-settings.phpHandlerDeprecated' => '(Не рекомендуется)',
    'php-settings.phpServedByApache' => 'обслуживается Apache',
    'php-settings.phpServedByNginx' => 'обслуживается nginx',
    'php-settings.phpSettingsPhpVersion' => 'Ваша версия PHP — %%version%%.',
    'php-settings.phpSettingsPhpDisabled' => 'PHP отключен.',
    'php-settings.phpHandlerTypeHint' => 'Ниже показаны настройки PHP для сайта. Вы можете изменять настройки PHP, если это разрешено хостинг-провайдером.',
    'php-settings.fpmDedicatedHandlerHint' => 'Использование этого обработчика увеличивает стабильность веб-сайта, но также потребляет 
дополнительное количество памяти.',
    'php-settings.phpHandlerChangeHint' => 'Вы изменили настройки обработчика PHP. Если вы сохраните эти изменения, выполнение скриптов PHP на вашем сайте может остановиться на %%interval%% секунд из-за конфигурации вашего сервера.',
    'php-settings.phpHandlerTypeHelpLink' => 'Узнайте, как выбрать оптимальные настройки PHP',
    'php-settings.phpHandlerTypeNotAvailableHint' => 'Невозможно включить поддержку PHP, так как текущая конфигурация хостинга не содержит версий PHP, доступных для этого домена.',
    'php-settings.phpHandlersNotAvailableHint' => 'Невозможно включить поддержку PHP, так как текущая конфигурация Plesk не содержит доступных версий PHP.',
    'php-settings.phpHandlerTypeNotAvailableHelpLink' => 'Узнайте, как включить другие версии PHP.',
    'php-settings.phpSupportReadonly' => '(версия: %%version%%; обработчик: %%handler%%) %%link%%',
    'php-settings.phpSupportReadonlyNotRegistered' => '(не зарегистрирована) %%link%%',
    'php-settings.showPhpInfo' => 'Просмотр страницы phpinfo()',
    'php-settings.phpSettingsFormError' => 'Невозможно получить настройки PHP, потому что отсутствуют необходимые данные.',
    'php-settings.phpSettingsFormBrokenPhpHandler' => 'Невозможно получить настройки PHP, потому что поврежден обработчик.',
    'php-settings.showPhpInfoTitle' => 'Просмотр phpinfo()',
    'php-settings.showPhpInfoDescription' => 'Некоторые настройки PHP были изменены, но изменения еще не сохранены. Чтобы увидеть новые значения на странице phpinfo(), пожалуйста, сначала примените изменения. Иначе, вы увидите текущие значения.',
    'php-settings.showPhpInfoButton' => 'Просмотр phpinfo()',

    'pmm.agent.sync.check' => 'Агент миграции и переноса проверяет наличие обновлений.',
    'pmm.agent.sync.updating' => 'Синхронизация и скачивание Агента миграции и переноса',
    'pmm.agent.sync.done' => 'Агент миграции и переноса успешно синхронизирован.',
    'pmm.agent.sync.downloadLink' => 'Нажмите, чтобы скачать Агент миграции и переноса, который должен быть установлен на исходном сервере перед началом миграции.',
    'pmm.agent.sync.error' => 'Не удалось получить обновления. Пожалуйста, попробуйте позднее.',

    'restore-password.title' => 'Изменить пароль',
    'restore-password.passwordLabel' => 'Новый пароль',
    'restore-password.buttonRestore' => 'Сохранить',
    'restore-password.buttonCancel' => 'Отмена',
    'restore-password.isEmpty' => 'Обязательное поле не заполнено. Пожалуйста, заполните его.',
    'restore-password.errorInvalidSecret' => 'Неверный секретный код',
    'restore-password.errorNotFoundSecret' => 'Пожалуйста, запросите новый секретный код',
    'restore-password.restoreSuccess' => 'Ваш пароль изменен. Используйте новый пароль для входа в Plesk или в ваш адрес электронной почты.',

    'scheduler.settings.schedulerNotification' => 'Уведомления',
    'scheduler.settings.notificationOff' => "Отключить",
    'scheduler.settings.notificationDefault' => "Отправлять на адрес по умолчанию (%%email%%)",
    'scheduler.settings.notificationCustom' => "Отправлять на указанный адрес",
    'scheduler.settings.crontabSecureShell' => 'Оболочка планировщика',
    'scheduler.settings.schedulerTimezoneSelector' => 'Показать расписание задач с использованием часового пояса',
    'scheduler.settings.schedulerTimezoneSelectorDefaultWithLabel' => 'Использовать часовой пояс системы по умолчанию (%%timezone%%)',
    'scheduler.settings.schedulerTimezoneSelectorDefault' => 'Использовать часовой пояс системы по умолчанию',
    'scheduler.settings.schedulerTimezoneSelectorCustom' => 'Использовать указанный мной часовой пояс',

    'scheduler.task.active' => 'Активен',
    'scheduler.task.subscription' => 'Подписка',
    'scheduler.task.subscription_powerUser' => 'Веб-пространство',
    'scheduler.task.type' => 'Тип задачи',
    'scheduler.task.typeCommand' => 'Выполнить команду',
    'scheduler.task.typeUrl' => 'Получить URL-адрес',
    'scheduler.task.typeScript' => 'Выполнить PHP-скрипт',
    'scheduler.task.command' => 'Команда',
    'scheduler.task.arguments' => 'с аргументами',
    'scheduler.task.url' => 'URL-адрес',
    'scheduler.task.urlDescription' => 'Укажите абсолютный URL-адрес, например, http://example.com. Если получен код состояния ответа 2xx или 3xx, задача считается выполненной успешно.',
    'scheduler.task.script' => 'Путь к скрипту',
    'scheduler.task.scriptRelativePathDescription' => 'Пример: %%path%%',
    'scheduler.task.scriptAbsolutePathDescription' => 'Укажите полный путь к скрипту. Пример: %%path%%',
    'scheduler.task.scriptPhpVersion' => 'Использовать версию PHP',
    'scheduler.task.scriptPathPopupTitle' => 'Путь к скрипту',
    'scheduler.task.run' => 'Запустить',
    'scheduler.task.on' => 'Вкл',
    'scheduler.task.at' => 'в',
    'scheduler.task.sysUser' => 'Системный пользователь',
    'scheduler.task.hourly' => 'Ежечасно',
    'scheduler.task.daily' => 'Ежедневно',
    'scheduler.task.weekly' => 'Еженедельно',
    'scheduler.task.monthly' => 'Ежемесячно',
    'scheduler.task.yearly' => 'Ежегодно',
    'scheduler.task.cronStyle' => 'Стиль cron',
    'scheduler.task.cronStyleError' => 'Неверные синтаксис crontab.',
    'scheduler.task.cronStyleErrorWin' => 'Косую черту (/) и дефис (-) использовать нельзя.',
    'scheduler.task.cronStyleHint' => 'Использовать формат UNIX crontab "минута час день-месяца месяц день-недели". Пример: "0 22 * * 1-5". Для выполнения задачи Plesk будет использовать часовой пояс системы по умолчанию.',
    'scheduler.task.cronStyleWinHint' => 'Использовать формат "минута час день-месяца месяц день-недели", например, "0 22 * * 6,7". Для выполнения задачи Plesk будет использовать часовой пояс системы по умолчанию.',
    'scheduler.task.notify' => 'Уведомлять',
    'scheduler.task.notifyIgnore' => 'Не уведомлять',
    'scheduler.task.notifyErrors' => 'Только ошибки',
    'scheduler.task.notifyAlways' => 'Каждый раз',
    'scheduler.task.notifyErrorsHint' => 'Уведомления содержат стандартный поток сообщений об ошибках команды. Если поток пуст, уведомление не отправляется.',
    'scheduler.task.notifyErrorsHintWin' => 'Уведомления содержат вывод команды и отправляются только при ненулевом коде завершения команды.',
    'scheduler.task.notifyAlwaysHint' => 'Уведомления содержат вывод команды. Если вывод пуст, уведомление не отправляется.',
    'scheduler.task.notifyAlwaysHintWin' => 'Уведомления содержат вывод команды и отправляются независимо от кода завершения команды.',
    'scheduler.task.emailType' => 'Отправлять уведомления',
    'scheduler.task.emailTypeDefault' => 'Системному пользователю по умолчанию (%%email%%)',
    'scheduler.task.emailTypeOwner' => 'Владельцу подписки (%%email%%)',
    'scheduler.task.emailTypeOwnerAdmin' => 'Администратору (%%email%%)',
    'scheduler.task.emailTypeCustom' => 'Другим пользователям',
    'scheduler.task.emailTypeCustomDescription' => 'Можно указать несколько адресов через запятую.',
    'scheduler.task.minute' => 'минута',
    'scheduler.task.shortMinute' => 'мин',
    'scheduler.task.dayOfMonth' => 'день',
    'scheduler.task.description' => 'Описание',
    'scheduler.task.scheduleTimezoneHint' => 'Часовой пояс для запуска задачи %%timezone%%',
    'scheduler.task.runTaskNow' => 'Запустить',
    'scheduler.task.runningTask' => 'Запускается задача "%%task%%"...',

    'service-plan.mail.outgoing-messages.outgoingMessagesDefault' => 'Использовать ограничение сервера (%%default%% сообщений в час)',
    'service-plan.mail.outgoing-messages.outgoingMessagesSpecificPlan' => 'Отдельное значение',
    'service-plan.mail.outgoing-messages.outgoingMessagesSpecificSubscription' => 'Отдельное значение',
    'service-plan.mail.outgoing-messages.outgoingMessagesSpecificHint' => 'сообщений',
    'service-plan.mail.outgoing-messages.mboxOutgoingMessages' => 'Исходящие сообщения от почтового ящика (в час)',
    'service-plan.mail.outgoing-messages.domainOutgoingMessages' => 'Исходящие сообщения от домена (в час)',
    'service-plan.mail.outgoing-messages.subscriptionOutgoingMessages' => 'Исходящие сообщения от подписки (в час)',
    'service-plan.mail.outgoing-messages.outgoingMessagesOverLimit' => 'Сколько сообщений из превысивших ограничение отправлять в следующий час (%)',
    'service-plan.mail.outgoing-messages.outgoingMessagesOverLimitDescription' => 'Если ограничение составляет 100 сообщений в час, а доля сообщений для последующей отправки ‒ 10%, значит пользователю разрешено отправлять 110 сообщений в час: 100 в течение одного часа и еще 10 в течение следующего.',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmail' => 'Политика использования Sendmail',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailDefault' => 'По умолчанию (Sendmail разрешен)',
    'service-plan.mail.outgoing-messages.outgoingMessagesNotEnableSendmailDefault' => 'По умолчанию (Sendmail запрещен)',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomPlan' => 'Отдельное значение',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomSubscription' => 'Отдельное значение',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomLabel' => 'Разрешть использование Sendmail для скриптов и пользователей этой подписки',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomHint' => 'Это позволит скриптам и пользователям отправлять сообщения (от лица системного пользователя), даже если превышены ограничения, установленные для почтового ящика и домена. Максимальное количество сообщений, которое можно отправить через Sendmail, определяется на уровне подписки.',

    'setup.hint' => 'Добро пожаловать в Plesk, панель управления, которая помогает работать с сервером. Plesk предоставляет готовую среду разработки и предлагает вам набор мощных расширений, чтобы помочь вам в разработке сайтов и приложений. Завершите процесс установки, чтобы начать использовать Plesk (это займет всего минуту).',
    'setup.contactInfoSection' => 'Контактная информация',
    'setup.contactInfoSectionHint' => 'Введите ваше имя и адрес электронной почты, чтобы обозначить себя как владельца сервера и получать важные уведомления о сервере. Если вы – администратор корпоративного сервера, не вводите свое персональное имя или адрес электронной почты. Вместо этого используйте название вашей организации и корпоративный адрес электронной почты, чтобы избежать возможного нарушения закона о защите данных.',
    'setup.contactName' => 'Ваше контактное имя',
    'setup.emptyContactName' => 'Пожалуйста, укажите контактное имя.',
    'setup.contactNameTooLong' => 'Контактное имя слишком длинное (максимальная длина - %max% символов).',
    'setup.email' => 'Электронная почта',
    'setup.emptyEmail' => 'Пожалуйста, укажите адрес электронной почты.',
    'setup.passwordSection' => 'Пароль',
    'setup.passwordSectionHint' => 'При следующем входе в Plesk используйте имя пользователя \'admin\' и введенный ниже пароль.',
    'setup.password' => 'Пароль',
    'setup.licenseSection' => 'Лицензия',
    'setup.licenseSectionHint' => 'Вам надо установить лицензию, чтобы начать работу в Plesk.',
    'setup.licenseType' => 'Выберите тип лицензии',
    'setup.licenseTypePaid' => 'Продолжить с платной лицензией',
    'setup.onlineStoreLink' => 'Интернет-магазин',
    'setup.licenseTypeTrial' => 'Продолжить с полнофункциональной пробной лицензией',
    'setup.activationCodeHint' => 'Если вы уже купили лицензию на Plesk, вставьте сюда полученный код активации. Если нет - вы можете купить новую лицензию на %%onlineStoreLink%%.',
    'setup.privacyPolicyLink' => 'Политикой конфиденциальности Plesk',
    'setup.trialLicenseAgreement' => 'Для выпуска пробной лицензии Plesk International GmbH будет использовать и обрабатывать предоставленную мной информацию в своих внутренних системах в соответствии с %%privacyPolicyLink%%.',
    'setup.eulaAgreementLabel' => 'Я подтверждаю, что прочитал и принимаю %%link%%',
    'setup.eula' => 'Лицензионное соглашение с конечным пользователем',
    'setup.invalidEulaAgreementValue' => 'Необходимо принять лицензионное соглашение с конечным пользователем',
    'setup.sendButton' => 'Войти в Plesk >>',

    'ssl-certificate.add.name' => 'Имя сертификата',
    'ssl-certificate.add.longName' => 'Слишком длинное имя сертификата (максимальное количество символов — %max%).',
    'ssl-certificate.add.certificateNameUsed' => 'Сертификат с именем %%name%% уже существует.',
    'ssl-certificate.add.certificateAdded' => 'SSL/TLS-сертификат выпущен. Чтобы он начал работать, назначьте его для защиты домена, почты или веб-почты.',
    'ssl-certificate.add.certificateUpdated' => 'SSL/TLS-сертификат успешно обновлен.',
    'ssl-certificate.add.settings' => 'Настройки',
    'ssl-certificate.add.settingsHint' => 'Здесь вы можете создать запрос на сертификат, купить сертификат у провайдера или создать самозаверенный сертификат.',
    'ssl-certificate.add.settingsHint2' => 'Запрос ‒ это CSR-файл, содержащий данные, которые вы укажете в этой форме. Вы отправляете его в подходящий центр сертификации и в ответ получаете готовый сертификат. Полученный сертификат нужно загрузить с помощью одной из расположенных ниже форм.',
    'ssl-certificate.add.settingsHint3' => 'Самозаверенный сертификат - это сертификат, заверяемый непосредственно его владельцем. Если вы используете такой сертификат, это означает, что вы сами подтверждаете подлинность своих сайтов. Хотя самозаверенные сертификаты позволяют использовать SSL/TLS, они считаются менее надежными.',
    'ssl-certificate.add.bits' => 'Длина ключа (бит)',
    'ssl-certificate.add.country' => 'Страна',
    'ssl-certificate.add.state' => 'Республика, область или край',
    'ssl-certificate.add.longState' => 'Слишком длинное название области или региона.',
    'ssl-certificate.add.city' => 'Город',
    'ssl-certificate.add.longCity' => 'Слишком длинное название города.',
    'ssl-certificate.add.shortCity' => 'Слишком короткое название города.',
    'ssl-certificate.add.companyName' => 'Организация',
    'ssl-certificate.add.longCompanyName' => 'Слишком длинное название компании.',
    'ssl-certificate.add.companyUnitName' => 'Отдел или подразделение',
    'ssl-certificate.add.longCompanyUnitName' => 'Слишком длинное название подразделения (максимальное количество символов — %max%).',
    'ssl-certificate.add.domainName' => 'Имя домена',
    'ssl-certificate.add.email' => 'Электронная почта',
    'ssl-certificate.add.request' => 'Запросить',
    'ssl-certificate.add.buyCertificate' => 'Купить SSL/TLS-сертификат',
    'ssl-certificate.add.selfSigned' => 'Самозаверенный',
    'ssl-certificate.add.invalidCertificateParams' => 'Некоторые поля не заполнены или заполнены неправильно. Максимальная длина значений ‒ 64 символа. Если вы используете международное имя домена, убедитесь, что в формате ASCII ни одна из его частей не превышает 63 символа. Проверьте следующие поля:',
    'ssl-certificate.add.unableCreateCsr' => 'Не удалось создать запрос на сертификат: %%error%%',
    'ssl-certificate.add.unableCreateSelfSigned' => 'Не удалось создать самозаверенный сертификат: %%error%%',
    'ssl-certificate.add.unableCreateUpload' => 'Не удалось установить данные сертификата: %%error%%',
    'ssl-certificate.add.unableSaveCertificate' => 'Не удалось сохранить сертификат в базе данных: %%error%%.',
    'ssl-certificate.add.uploadFiles' => 'Загрузить файлы сертификата',
    'ssl-certificate.add.uploadFilesHint' => 'С помощью этой формы вы можете загрузить компоненты сертификата в виде составляющих файлов.',
    'ssl-certificate.add.csr' => 'Запрос на подписание сертификата',
    'ssl-certificate.add.privateKey' => "Закрытый ключ (*.key)",
    'ssl-certificate.add.certificate' => "Сертификат (*.crt)",
    'ssl-certificate.add.caCertificate' => "Корневой сертификат (*-ca.crt)",
    'ssl-certificate.add.sendFiles' => "Загрузить сертификат",
    'ssl-certificate.add.fileNotUploaded' => 'Не удалось загрузить сертификат: %%name%%.',
    'ssl-certificate.add.unableSetPrivateKey' => 'Невозможно установить закрытый ключ: %%error%%',
    'ssl-certificate.add.unableSetCertificate' => 'Невозможно установить сертификат: %%error%%',
    'ssl-certificate.add.unableSetCaCertificate' => 'Невозможно установить корневой сертификат: %%error%%',
    'ssl-certificate.add.unableCheckCaCertificate' => 'Не удалось проверить, заверяет ли этот корневой сертификат указанный сертификат: %%error%%',
    'ssl-certificate.add.removeCaCertificate' => 'Удалить',
    'ssl-certificate.add.removeCaCertificateConfirmation' => 'Удалить корневой сертификат?',
    'ssl-certificate.add.unableRemoveCaCertificate' => 'Не удалось удалить корневой сертификат: %%error%%',
    'ssl-certificate.add.caCertificateRemoved' => 'Корневая часть сертификата была удалена.',
    'ssl-certificate.add.rename' => 'Переименовать',
    'ssl-certificate.add.unableRenameCertificate' => 'Не удалось переименовать сертификат: %%error%%',
    'ssl-certificate.add.certificateRenamed' => 'Сертификат был переименован в %%name%%.',
    'ssl-certificate.add.uploadText' => "Загрузить сертификат как текст",
    'ssl-certificate.add.uploadTextHint' => 'С помощью этой формы вы можете загрузить компоненты сертификата в виде текста. Просто скопируйте содержимое файлов в соответствующие поля.',
    'ssl-certificate.add.sendText' => "Загрузить сертификат",
    'ssl-certificate.add.componentIsMissing' => 'Компонент отсутствует.',

    'ssl-certificate.find-private-key.findPrivateKey' => 'Загрузить сертификат',
    'ssl-certificate.find-private-key.formGeneralHint' => 'Если вы создали запрос на подпись сертификата на этом сервере и получили файл сертификата, загрузите его здесь. Если вы хотите загрузить сертификат и закрытый ключ, созданные на другом сервере, или создать самозаверенный сертификат, нажмите <b> Добавить SSL/TLS-сертификат</b>.',
    'ssl-certificate.find-private-key.formCertificateAddingHint' => 'После установки SSL/TLS-сертификата на домене нужно включить поддержку SSL/TLS и выбрать его в настройках хостинга сайта: <b>Сайты и домены</b> > <b>Настройки хостинга</b> соответствующего домена > <b>Безопасность</b>.',
    'ssl-certificate.find-private-key.uploadCertificate' => 'Сертификат (*.crt)',
    'ssl-certificate.find-private-key.sendFile' => 'Загрузить сертификат',
    'ssl-certificate.find-private-key.fileNotUploaded' => 'Не удалось загрузить файл сертификата.',
    'ssl-certificate.find-private-key.invalidCertificateFormat' => 'Недопустимый формат сертификата.',
    'ssl-certificate.find-private-key.unableFindPrivateKey' => 'Не удалось найти подходящий закрытый ключ для данного сертификата.',

    'ssl-certificate.secure.certificate' => 'Выбрать сертификат',
    'ssl-certificate.secure.serverPool' => 'пул сервера',
    'ssl-certificate.secure.certificateName' => '%%certificateName%% (%%repositoryName%%)',

    'web-app-firewall.pageHint' => 'Брандмауэр веб-приложений защищает веб-приложения от атак, проверяя и фильтруя входящие HTTP-запросы на основании правил, заданных пользователем.',
    'web-app-firewall.webSitePageHint' => 'Здесь вы можете настроить брандмауэр для веб-приложений (ModSecurity).',
    'web-app-firewall.ruleEngine' => 'Режим работы брандмауэра для веб-приложений:',
    'web-app-firewall.ruleEngineOn' => 'Включен',
    'web-app-firewall.ruleEngineOnDescription' => 'Каждый входящий HTTP-запрос и относящийся к нему ответ проверяется на соответствие ряду правил. Если проверка пройдена, запрос передается на сайт. Если проверка не пройдена, брандмауэр сохраняет ее результат в журнале событий, отправляет уведомление и выдает HTTP-ответ с кодом ошибки.',
    'web-app-firewall.ruleEngineOff' => 'Отключен',
    'web-app-firewall.ruleEngineOffDescription' => 'Входящие HTTP-запросы и соответствующие ответы не проверяются.',
    'web-app-firewall.ruleEngineDetectionOnly' => 'Только обнаружение',
    'web-app-firewall.ruleEngineDetectionOnlyDescription' => 'Каждый входящий HTTP-запрос и относящийся к нему ответ проверяется на соответствие ряду правил. Если проверка пройдена, запрос передается на сайт. Если проверка не пройдена, ModSecurity сохраняет ее результат в журнале событий, но больше никаких действий не совершает. Другие службы (например, Fail2ban) по-прежнему могут совершать необходимые действия с HTTP-запросами, которые не прошли проверку.',
    'web-app-firewall.ruleSetsSection' => 'Наборы правил',
    'web-app-firewall.ruleSetsSectionHint' => 'Выберите набор правил (пакет файлов, содержащих правила безопасности), который будет использоваться для проверки входящих HTTP-запросов.',
    'web-app-firewall.ruleSet' => 'Набор правил',
    'web-app-firewall.ruleSetCrs' => 'OWASP (бесплатно)',
    'web-app-firewall.ruleSetCrsDescription' => 'Набор правил OWASP ModSecurity Core Rule Set очень строгий, он может заблокировать некоторые функции (например, общий доступ к файлам, веб-почту) и некоторые функции веб-приложений (например, плагины WordPress).',
    'web-app-firewall.ruleSetCrsConfirmTitle' => 'Применить изменения?',
    'web-app-firewall.ruleSetCrsConfirmDescription' => 'Правила OWASP могут оказаться слишком строгими и блокировать некоторые функции, такие как общий доступ к файлам, веб-почта и некоторые веб-приложения.',
    'web-app-firewall.ruleSetTortix' => 'Atomic Standard (бесплатно, можно обновить до Atomic Advanced)',
    'web-app-firewall.ruleSetTortixDescription' => 'Начальная версия правил ModSecurity Rules от Atomicorp. Эти правила предоставляют базовую защиту и обновляются ежемесячно.',
    'web-app-firewall.ruleSetTortixHowTo' => 'Чтобы обновить этот набор правил до Atomic Advanced:',
    'web-app-firewall.ruleSetTortixBuy' => 'Купите %%linkPleskStore%% в интернет-магазине Plesk и %%linkDocumentation%%.',
    'web-app-firewall.ruleSetTortixLinkPleskStoreLabel' => 'Advanced ModSecurity Rules от Atomicorp',
    'web-app-firewall.ruleSetTortixLinkDocumentationLabel' => 'установите купленный дополнительный ключ лицензии',
    'web-app-firewall.ruleSetTortixSelect' => 'Выберите этот набор правил. При этом его название изменится на “Atomic Advanced (куплен у Plesk)”',
    'web-app-firewall.ruleSetTortixPro' => 'Atomic Advanced (куплен у Plesk)',
    'web-app-firewall.ruleSetTortixProDescription' => 'Набор правил Advanced ModSecurity Rules от Atomicorp включает в себя набор правил Atomic Standard Rules плюс некоторое количество расширенных функций.',
    'web-app-firewall.ruleSetAtomic' => 'Atomic Advanced (куплен у Atomicorp)',
    'web-app-firewall.ruleSetAtomicDescription' => 'Набор правил Advanced ModSecurity Rules от Atomicorp включает в себя набор правил Atomic Standard Rules плюс некоторое количество расширенных функций.',
    'web-app-firewall.ruleSetAtomicInstall' => 'Переключиться на другую учетную запись Atomicorp.',
    'web-app-firewall.ruleSetAtomicInstalled' => 'Набор правил активирован.',
    'web-app-firewall.ruleSetAtomicHowTo' => 'Если у вас уже есть учетная запись Atomicorp и куплен набор правил Atomic Advanced, введите ниже учетные данные, чтобы включить этот набор правил.',
    'web-app-firewall.ruleSetAtomicSwitchHowTo' => 'Если у вас уже есть учетная запись Atomicorp и куплен набор правил Atomic Advanced, введите ниже учетные данные, чтобы включить эту учетную запись.',
    'web-app-firewall.ruleSetAtomicLogin' => 'Имя пользователя',
    'web-app-firewall.ruleSetAtomicPassword' => 'Пароль',
    'web-app-firewall.ruleSetComodo' => 'Comodo (бесплатная подписка)',
    'web-app-firewall.ruleSetComodoDescription' => 'Бесплатный набор правил ModSecurity Rules от Comodo. Он обеспечивает базовую защиту.',
    'web-app-firewall.ruleSetComodoInstall' => 'Переключиться на другую учетную запись Comodo.',
    'web-app-firewall.ruleSetComodoInstalled' => 'Набор правил активирован.',
    'web-app-firewall.ruleSetComodoHowTo' => 'Чтобы включить этот набор правил:',
    'web-app-firewall.ruleSetComodoSwitchHowTo' => 'Чтобы переключиться на другую учетную запись:',
    'web-app-firewall.ruleSetComodoRegister' => 'Зарегитрируйтесь на сайте Comodo.',
    'web-app-firewall.ruleSetComodoCredentials' => 'Введите ваше имя пользователя и пароль с этого сайта.',
    'web-app-firewall.ruleSetComodoLogin' => 'Имя пользователя',
    'web-app-firewall.ruleSetComodoPassword' => 'Пароль',
    'web-app-firewall.ruleSetComodoFree' => 'Comodo (бесплатно)',
    'web-app-firewall.ruleSetComodoFreeDescription' => 'Бесплатный набор правил ModSecurity Rules от Comodo. Он обеспечивает базовую защиту.',
    'web-app-firewall.ruleSetCustom' => 'Другой набор правил',
    'web-app-firewall.ruleSetCustomDescription' => 'Загрузить свой набор правил брандмауэра для веб-приложений. Поддерживаемые форматы: zip, tar.gz, tgz, tar.bz2, conf.',
    'web-app-firewall.ruleSetCustomUpload' => 'Выбрать другой файл',
    'web-app-firewall.ruleSetError' => 'Не удалось установить набор правил ModSecurity: %%error%%',
    'web-app-firewall.ruleSetAuthError' => 'неверное имя пользователя или пароль.',
    'web-app-firewall.ruleSetInvalid' => 'Выбранный набор правил не может быть запущен на %%webServer%%.',
    'web-app-firewall.ruleSetSelectedInvalid' => 'Выбранный набор правил не может быть запущен на выбранном веб-сервере.',
    'web-app-firewall.webServer' => 'Запустить правила на',
    'web-app-firewall.webServerHint' => 'Выберите нужную комбинацию веб-сервера и версии ModSecurity, чтобы посмотреть совместимые наборы правил.',
    'web-app-firewall.webServerApache' => 'Apache (ModSecurity 2.9)',
    'web-app-firewall.webServerNginx' => 'Nginx (ModSecurity 3.0)',
    'web-app-firewall.webServerIis' => 'IIS (ModSecurity 2.9)',
    'web-app-firewall.nginxNotRunning' => 'Обратный прокси-сервер (nginx) отключен и не может быть использован для обработки запросов. Выберите <a href="%%serverUrl%%">другой веб-сервер</a> или включите обратный прокси-сервер на странице <a href="%%servicesUrl%%">Управление службами</a>.',
    'web-app-firewall.nginxIsIncompatible' => 'Выбор другой версии ModSecurity может привести к тому, что некоторые настройки перестанут работать (например, в ModSecurity 3 вы не сможете использовать регулярные выражения при отключении правил безопасности). Убедитесь, что после применения изменений ваши настройки работают так, как ожидалось. Вы также можете вернуть настройки отключения правил безопасности к значениям по умолчанию.',
    'web-app-firewall.nginxResetCustomizations' => 'Вернуть настройки сервера и доменов, которые отключают правила безопасности, к значениям по умолчанию.',
    'web-app-firewall.ruleSetUpdate' => 'Обновлять набор правил',
    'web-app-firewall.ruleSetUpdateDaily' => 'Ежедневно',
    'web-app-firewall.ruleSetUpdateWeekly' => 'Еженедельно',
    'web-app-firewall.ruleSetUpdateMonthly' => 'Ежемесячно',
    'web-app-firewall.currentRuleSet' => 'Набор правил',
    'web-app-firewall.currentRuleSetValue' => '%%ruleSet%% %%changeRuleSetLink%%',
    'web-app-firewall.currentRuleSetRunningOn' => '%%ruleSet%% запущен на %%webServer%%',
    'web-app-firewall.changeRuleSetLink' => 'Изменить набор правил',
    'web-app-firewall.ruleSetRollbackFailed' => 'Невозможно использовать текущий набор правил ModSecurity и вернуться к предыдущей версии, потому что в них содержатся недействительные правила.',
    'web-app-firewall.configurationSection' => 'Настройка',
    'web-app-firewall.configurationSectionHint' => 'Настройте брандмауэр для веб-приложений, используя готовый набор параметров или собственные директивы ModSecurity.',
    'web-app-firewall.configPreset' => 'Готовый набор значений',
    'web-app-firewall.configPresetFast' => 'Быстрая проверка',
    'web-app-firewall.configPresetFastDescription' => 'Проверяются фрагменты заголовков и универсальный код ресурса (URI) HTTP-запроса.',
    'web-app-firewall.configPresetTradeOff' => 'Оптимальная проверка',
    'web-app-firewall.configPresetTradeOffDescription' => 'Проверяются заголовки, URI и POST-данные HTTP-запроса.',
    'web-app-firewall.configPresetThrough' => 'Тщательная проверка',
    'web-app-firewall.configPresetThroughDescription' => 'Проверяются полные заголовки и POST-данные HTTP-запроса, а также текст HTTP-ответа.',
    'web-app-firewall.configCustom' => 'Пользовательские директивы',
    'web-app-firewall.configCustomDescription' => "Введите нужную вам директиву ModSecurity. Она переопределит все указанные ранее директивы (наборы правил, конкретные правила, готовый набор значений и т.д.).\nПример: SecDebugLogLevel 6",
    'web-app-firewall.configCustomError' => 'Неисправная конфигурация ModSecurity: %%error%%',
    'web-app-firewall.configRollbackFailed' => 'Невозможно использовать текущий конфигурационный файл ModSecurity и вернуться к предыдущей версии файла, так как они содержат неисправную конфигурацию.',
    'web-app-firewall.rulesSection' => 'Отключение правил безопасности',
    'web-app-firewall.rulesSectionHint' => 'Здесь вы можете отключить отдельные правила безопасности. Это может потребоваться, если то или иное правило окажется слишком строгим для некоторых сайтов. Чтобы отключить правила, укажите их идентификаторы (например, 340003 или 340005-340007), теги (например, CVE-2011-4898) или регулярные выражения, используемые в сообщениях правил (например, XSS).',
    'web-app-firewall.rulesSectionNginxHint' => 'Здесь вы можете отключить отдельные правила безопасности. Это может потребоваться, если то или иное правило окажется слишком строгим для некоторых сайтов. Чтобы отключить правило, укажите его идентификатор (например, 340003 или 340005-340007), тег (например, CVE-2011-4898) или сообщение правила (например, "Found User-Agent associated with security scanner").',
    'web-app-firewall.filterById' => 'Идентификаторы правил безопасности',
    'web-app-firewall.filterByIdInvalid' => 'Недопустимые значения: %%values%%. ID правила должен состоять из цифр или быть диапазоном цифр, например, 913100 или 913105-913107.',
    'web-app-firewall.filterByIdInvalidRanges' => 'Следующие диапазоны заданы некорректно: %%ranges%%.',
    'web-app-firewall.filterByTag' => 'Теги',
    'web-app-firewall.filterByTagActive' => 'Активные:',
    'web-app-firewall.filterByTagDeactivated' => 'Деактивированные:',
    'web-app-firewall.filterByTagInvalid' => 'Выбраны следующие недопустимые значения: %%values%%.',
    'web-app-firewall.filterByRegexp' => 'Регулярные выражения в сообщениях правил',
    'web-app-firewall.filterByRegexpInvalid' => 'Эти значения заданы некорректно: %%values%%. Они не должны содержать символы \' или ".',
    'web-app-firewall.filterByRegexpNginx' => 'Сообщения правил',
    'web-app-firewall.filterByRegexpNginxHint' => 'Поддерживаются только точные соответствия.',
    'web-app-firewall.filterByRegexpNginxInvalid' => 'Эти значения заданы некорректно: %%values%%. Они не должны содержать буквы, цифры, пробелы или символы -:;.,!?#&$%*()/.',
    'web-app-firewall.auditLogSection' => 'Журнал ModSecurity',
    'web-app-firewall.auditLogHint1' => 'Журнал ModSecurity ‒ это самый полезный источник информации в системе. В нем ModSecurity фиксирует все происходящие события.',
    'web-app-firewall.auditLogHint2' => 'После включения ModSecurity некоторые сайты могут начать работать с ошибками. В этом случае проверьте журнал ModSecurity, чтобы выяснить точную причину проблемы. Вы можете отключить слишком строгие правила безопасности или изменить параметры соответствующего сайта.',
    'web-app-firewall.auditLogHint3' => 'Чтобы понять, почему не был выполнен HTTP-запрос к тому или иному сайту:',
    'web-app-firewall.auditLogPoint1' => 'Откройте журнал ModSecurity, щелкнув по приведенной ниже ссылке.',
    'web-app-firewall.auditLogPoint2' => 'В открывшемся журнале выполните поиск (Ctrl+F в большинстве браузеров) по доменному имени сайта, испытывающего проблемы. Например, ваш-домен.ru. Браузер выделит строку вида HOST: ваш-домен.ru.',
    'web-app-firewall.auditLogPoint3' => 'Чуть выше выделенной строки вы увидите запись вида --eece5138-B--. Восемь символов между дефисами (в нашем примере это eece5138) ‒ это идентификатор события, вызванного HTTP-запросом.',
    'web-app-firewall.auditLogPoint4' => 'Найдите другие записи с таким же идентификатором события. Вам нужна запись, у которой после идентификатора события стоит буква H (в нашем примере это eece5138-H--). Эта запись содержит идентификатор и описание правила безопасности, проверявшего данный HTTP-запрос. Идентификатор правила безопасности ‒ это целое число, начинающееся с цифры 3 и заключенное в кавычки и ‒ вместе с префиксом id ‒ в квадратные скобки. Например, [id "340003"].',
    'web-app-firewall.auditLogPoint5' => 'Найдите идентификатор правила безопасности по фрагменту [id "3.',
    'web-app-firewall.auditLogPoint6' => 'Отключите правило безопасности с этим идентификатором в расположенной ниже области: введите найденный идентификатор (только цифры) в поле "Идентификаторы правил безопасности" и нажмите "ОК".',
    'web-app-firewall.auditLogViewLink' => 'Журнал ModSecurity',
    'web-app-firewall.auditLogListLink' => 'Архив журналов',
    'web-app-firewall.errorLogSection' => 'Журнал ошибок',
    'web-app-firewall.errorLogSectionHint' => 'После включения ModSecurity некоторые сайты могут начать работать с ошибками. В этом случае проверьте журнал ошибок, чтобы выяснить точную причину проблемы. Вы можете отключить слишком строгие правила безопасности или изменить параметры соответствующего сайта.',
    'web-app-firewall.errorLogViewLink' => 'Журнал ошибок',
    'web-app-firewall.notificationStateEnabled' => 'Уведомления в интерфейсе Plesk об обновлении набора правил включены. %%notificationLink%%',
    'web-app-firewall.notificationStateDisabled' => 'Уведомления в интерфейсе Plesk об обновлении набора правил отключены. %%notificationLink%%',
    'web-app-firewall.notificationLink' => 'Вы можете управлять ими на странице уведомлений',
];