<?php
// Copyright 1999-2024. WebPros International GmbH. All rights reserved.
global $PROD_NAME;

$GLOBALS['lmsg_arr'] += [
    //===============Button conhelp================//

    'b_disabled' => '現在利用できない機能です',
    'b_disabled_by_key' => 'ライセンスキーの制限により利用できません',
    'b_disabled_by_permissions' => '検索操作を実行するパーミッションがありません',
    'b_accept' => "{$PROD_NAME} を使用するにはこのライセンス契約に同意していただく必要があります。",
    'b_action_log' => 'アクションログ設定',
    'b_add_ip' => "クライアントの IP プールに IP アドレスを追加",
    'b_database_server_add' => 'データベースサーバを追加します。',
    'b_adm_skeleton' => '仮想ホストテンプレートを管理',

    'b_auto-updates' => "Plesk またはそのコンポーネントを更新します。",

    'b_codepage_change' => 'エンコーディングを変更します。',
    'b_configure_maillists' => 'メーリングリストインストール後の構成',
    'b_comp_info' => 'コンポーネント情報',
    'b_decline' => "ライセンスを却下すると、{$PROD_NAME} を使用できなくなります。",
    'b_dumps_list' => 'バックアップ/復元機能にアクセスし、バックアップファイルストレージを管理します。',
    'b_dumps_list_disabled' => 'バックアップユーティリティがインストールされていないため、サービスを使用できません。',
    'b_add_services' => '追加的サービス管理ページ',
    'b_add_ip_for_clients' => "この IP アドレスの所有者を追加します。",
    'b_anonymous_ftp' => 'ドメインに匿名 FTP をセットアップします。',
    'b_attach_add' => '添付ファイルを追加します。',
    'b_attach_remove' => '添付ファイルを削除します。',
    'b_backup_ok' => 'バックアップが完了しました。クリックするとバックアップファイルストレージに移動します。',
    'b_restore_ok' => '復元が完了しました。クリックするとバックアップファイルストレージに移動します。',
    'b_cancel' => 'すべての変更を破棄して、前のページに戻ります。',
    'b_card' => '個人情報を編集します。',
    'b_clean_log' => 'ログを消去します。',
    'b_cl_skeleton' => '仮想ホストテンプレートを管理',
    'b_dashboard' => 'ホームページに移動します。',
    'b_dashboard_shortcut_remove' => 'ホームページからショートカットを削除する',
    'b_domain_restore' => 'バックアップファイルからドメインを復元します。',
    'b_domain_user' => 'ドメイン管理者アクセスの許可と設定を行います。',
    'b_do_backup' => 'ドメインをバックアップします。この処理中、顧客パネルではドメイン管理機能を利用できません。',
    'b_do_upload' => 'ダンプをストレージにアップロードします。',
    'b_backup_configure' => 'バックアップマネージャ構成',
    'b_domain_alias_add' => 'ウェブサイトの追加ドメイン名を設定します。',
    'b_domain_aliases_limit_reached' => 'ドメインエイリアスの上限数に達しました',
    'b_create_client_back' => 'パラメータを破棄して、前のページに戻ります。',
    'b_create_client_update' => '提案されたパラメータを適用して、顧客の作成に進みます。',
    'b_create_domain_back' => 'パラメータを破棄して、前のページに戻ります。',
    'b_create_domain_update' => '提案されたパラメータを適用して、ドメイン作成へと進みます。',
    'b_create_domain_client_select' => '顧客を選択して［OK］をクリックすると、ドメインが作成されます。',
    'b_crontab_unix' => 'スケジュールタスクを管理',
    'b_crontab_win' => 'スケジュールタスクを管理',
    'b_crontab_unix_turn_on' => 'スケジュール済みタスクをオンにします。',
    'b_crontab_win_turn_on' => 'スケジュール済みタスクをオンにします。',
    'b_crontab_unix_turn_off' => 'スケジュール済みタスクを一時停止します。',
    'b_crontab_win_turn_off' => 'スケジュール済みタスクを一時停止します。',
    'b_extcert_send_file' => '指定したファイルから購入した証明書をアップロードします。',
    'b_extras_admin' => '追加的サーバツール',
    'b_extras_client' => '追加的ドメインツール',
    'b_cl_ed' => "顧客の情報を編集します。",
    'b_cl_ed_update' => "顧客の情報を更新します。",
    'b_cl_limits' => '顧客アカウントの上限を表示または設定します。',
    'b_cl_new_update' => '顧客アカウントを作成します。',
    'b_cl_not_cr_dom' => 'ドメインを作成する権限が顧客にありません。',
    'b_cl_on' => "顧客アカウントおよび全顧客のウェブサイトをアクティブ化します。",
    'b_cl_off' => "顧客アカウントおよび顧客のすべてのウェブサイトを一時停止します。",
    'b_cl_permissions' => '顧客に割り当てられたリソースのパーミッションを表示または設定します。',
    'b_cl_pref_up_level' => "更新せずに顧客の設定ページに戻ります。",
    'b_default_db_user' => "選択したデータベースユーザのクレデンシャルを使用してデータベース管理者インターフェースにログインします。",
    'b_edit_tpl__add_ip' => 'IP アドレスを追加します。',
    'b_edit_tpl__cancel_ip' => 'キャンセルします。',
    'b_icf' => 'ファイアウォールをセットアップします。',
    'b_ip_clients__add' => '追加します。',
    'b_ip_clients__cancel' => 'キャンセルします。',
    'b_client_templates' => '顧客テンプレートの管理',
    'b_create_login' => '新しい MyPlesk.com アカウントを作成します。',
    'b_skins_managment' => 'スキンを管理します。',
    'b_skin_add' => 'Plesk に新しいスキンをアップロードします。',
    'b_skin_manual' => "カスタム Plesk スキンの作成に関するユーザマニュアルを開きます。",
    'b_skin_manual_not_installed' => "カスタム Plesk スキンの作成に関するユーザマニュアルがインストールされていません。",
    'b_skin_download' => 'スキンをダウンロードします。',
    'b_skin_replace' => '現在のスキンを新しいスキンに置換します。',
    'b_spamassassin' => 'SpamAssassinサーバ設定',

    'b_subdom_update' => 'サブドメインを更新します。',
    'b_subdom_create' => 'サブドメインを作成します。',
    'b_switch_user' => '他のアカウントでログインする',
    'b_clients' => 'クライアントアカウントを管理',
    'b_client_traffic' => "クライアントのトラフィック",
    'b_change_passwd' => "管理者パスワードを変更します。",
    'b_change_cert_name' => '証明書名を変更します。',
    'b_databases' => 'データベースおよびデータベースユーザの作成および管理',
    'b_databases__change_server_passwd' => 'パスワード変更ページに進みます。',
    'b_directories' => 'SSL/TLS または非 SSL/TLS のパスワード保護ディレクトリを作成します。',
    'b_db_access' => "データベース管理者のクレデンシャルをセットアップします。",
    'b_pgsql_access' => "PostgreSQL 管理者のクレデンシャルを設定する",
    'b_pgsql_not_access' => 'PostgreSQLはインストールされていません',
    'b_db_add' => 'データベースサーバを追加します。',
    'b_db_add__lim' => 'このドメインにデータベースを追加することはできません。データベース数が上限に達しました。',
    'b_db_add_update' => '新しいデータベース名を入力してクリックすると、追加されます。',
    'b_db_del' => 'データベースを削除します。',
    'b_db_admin_not_installed' => 'Webadmin がインストールされていません。 ホスティングサービスプロバイダまでお問い合わせください。',
    'b_db_no_default_user' => 'Webadmin にアクセスできません。 Webadmin のデフォルトユーザが指定されていません。',
    'b_db_dbserver_not_configured' => 'Webadmin にアクセスできません。 データベースサーバが構成されていません。',
    'b_db_usr_add' => 'データベースユーザを追加します。',
    'b_db_user_del' => 'データベースユーザを削除します。',
    'b_db_usr_update' => 'パスワードを変更します。',
    'b_db_rm_submit' => '選択したデータベースを削除します。',
    'b_db_not_started' => 'データベースサーバが起動されていません',
    'b_db_not_configured' => 'データベースサーバが設定されていません',
    'b_db_not_installed' => 'データベースサーバがインストールされていません',
    'b_default_text' => 'デフォルトの通知テキストを設定します。',
    'b_du_rm_submit' => 'データベースユーザを削除',
    'b_dns' => 'ドメインのDNS設定を管理します。',
    'b_dns_soa_set' => 'すべての変更を適応する',
    'b_dns_acl_add' => 'IP アドレスまたはサブネットマスクを追加します。',
    'b_dns_rec_del' => 'DNS ゾーンからこのレコードを削除します。', //to remove
    'b_dns_rec_new' => '新しいレコードタイプを選択してから、クリックして追加します。', //to remove
    'b_dnsrecord_add' => 'DNS ゾーンにリソースレコードを追加します。',
    'b_dns_soa' => 'SOA 設定を構成します。',
    'b_dns_soa_default' => 'デフォルト SOA 設定を復元します。',
    'b_dns_default' => 'DNS ゾーンを復元します。',

    'b_dns_master_add' => 'プライマリ DNS サーバを追加します。', //to remove
    'b_dns_new_ns' => 'ネームサーバを追加します。', //to remove
    'b_dns_on' => 'ゾーンに対してローカル DNS サービスをオンにします。',
    'b_dns_off' => 'ゾーンのローカル DNS サービスをオフにします。',
    'b_dns_not_perm' => 'このドメインの DNS ゾーンを管理するパーミッションがありません',

    'b_dom_deact' => 'ドメインを無効にできません',
    'b_dom_del' => 'すべてのドメイン情報を削除します。',
    'b_log_manager' => 'ログファイルとログ処理オプションを管理',
    'b_dom_new' => 'ドメインを作成します。',
    'b_dom_new_no_clients' => 'ドメインを作成できません。クライアントアカウントがありません。',
    'b_dom_new_update' => 'ドメインを作成します。',
    'b_dom_on' => 'ドメインを有効にする',
    'b_dom_off' => 'ドメインを無効にする',
    'b_dom_pref' => 'ドメインの設定を行います。',
    'b_dom_limits' => 'ドメインの制限を閲覧/設定します。',
    'b_domain_traffic' => 'ドメインのトラフィック',
    'b_dom_reg' => 'このドメインの登録',
    'b_dom_usr_del' => 'ドメインレベルのユーザアクセスを削除します。',
    'b_doms_mng' => 'Plesk 経由で登録されたドメインを管理します。',
    'b_doms_reg' => 'ドメインを登録',
    'b_report' => 'レポートを表示',
    'b_report_saem' => '状態レポートを指定したアドレスに送信します。',
    'b_domains' => 'ドメイン管理',
    'b_domain_templates' => 'ドメインテンプレートの作成、編集および削除',
    'b_download_log' => 'ログファイルをローカルマシンにダウンロードします。',
    'b_dumps_rm_submit' => 'バックアップファイルを削除します。',
    'b_edit_adm' => '管理者情報を編集します。',
    'b_custom_buttons' => 'カスタムボタンを管理します。',
    'b_custom_button_add' => 'カスタムボタンを追加します。',
    'b_custom_buttons_rm_submit' => '選択したカスタムボタンを削除します。',
    'b_hide_aliases' => 'エイリアスを隠す',
    'b_hide_domainaliases' => 'ドメインエイリアスを隠す',
    'b_hide_subdomains' => 'サブドメインを隠す',
    'b_home' => 'ホームページに進みます。',
    'b_hosting' => 'ドメインのウェブホスティングを設定/管理します。',
    'b_hst_del' => '現在のホスティング構成を削除します。',
    'b_hst_not_set' => 'ホスティングが設定されていません',
    'b_hst_wo_ip' => 'ホスティングが IP ベースでありません',
    'b_hst_wo_ip_or_not_ssl' => 'ホスティングが IP ベースではないか、SSL/TLS サポートがアクティブではありません。',
    'b_not_phys_hst' => 'ホスティングが物理タイプでありません',
    'b_web_stat_not_set' => "ウェブ統計は保存されていません。統計記録を保持しておきたい場合、ホスティングアカウントのプロパティ（［ドメイン］ > ［ドメイン名］ > ［セットアップ］ > ［ウェブ統計］メニュー）に移動し、利用する統計プログラムを選択してください",
    'b_white_list' => 'ホワイトリストを管理します。',
    'b_white_list_add' => 'ホワイトリストに IP アドレスを追加します。',
    'b_hst_sel_next' => '選択したホスティングタイプを設定します。',
    'b_hst_update' => 'すべての変更を適応する',
    'b_int_ip_del' => 'リストから IP アドレスを選択してクリックするとインターフェースから削除されます。',
    'b_ip_new' => 'IP アドレスを追加します。',
    'b_ip_new_virtuozzo' => 'Virtuozzo containers に IP アドレスを追加できません。',
    'b_ip_new_lycos' => 'Lycos に IP アドレスを追加できません。',
    'b_ip_aliasing' => 'サーバ上の IP アドレスを管理します。',
    'b_ip_del' => 'リスト IP アドレス/マスクを選択してクリックすると削除します。',
    'b_ip_rm_submit' => 'IP アドレスを削除します。',
    'b_ip_cl_rm_submit' => 'IP プールから IP アドレスを削除します。',
    'b_ip_pool' => "顧客の IP プールの管理",
    'b_language' => 'デフォルトインターフェース言語を設定します。',
    'b_login' => 'Plesk にログインします。',
    'b_logo' => 'ページの上部に表示されるロゴをカスタマイズします。',
    'b_logo_default' => 'デフォルトロゴを復元します。',
    'b_logo_send_file' => '新しいロゴファイルの名前を入力してクリックすると、アップロードされます。',
    'b_logo_send_link' => '新しいロゴリンクを入力してクリックすると、添付されます。',
    'b_logo_send_logo' => '新しいロゴファイルの名前を入力してクリックすると、アップロードされます。',
    'b_log_rm_submit' => 'ログファイルを削除します。',
    'b_ma_rm_submit' => 'メールエイリアスを削除します。',

    'b_mail' => 'サーバ全体のメールシステムを設定します。',
    'b_mail_disabled_by_admin' => 'このドメインのメールサービスはサーバ管理者によってオフになっています。',

    'b_mail_resp_on' => '自動応答をアクティブ化します。',
    'b_mail_resp_off' => '自動応答を非アクティブ化します。',
    'b_mail_resp_add' => '自動応答を作成します。',
    'b_mail_resp_files' => '添付ファイルリポジトリを管理する',
    'b_mail_resp_files_no_mailbox' => 'このメールアカウントの下にメールボックスをセットアップされていないため、現在この機能は使用できません。',
    'b_mail_resp_upload' => '添付ファイルリポジトリにファイルをアップロードする',
    'b_mail_resp_attach_add' => '添付を作成します。',

    'b_mail_names' => 'メールサービスを管理します（POP3 メールボックス、転送、グループ、自動返信）。',
    'b_mail_name_resp_attach_selected' => '選択したファイルを自動返信に添付します。',

    'b_mail_on' => 'このドメインのメールサービスをアクティブ化します。',
    'b_mail_off' => 'このドメインのメールサービスを非アクティブ化します。',
    'b_mail_preferences' => '存在しないユーザのメール受信設定を構成します。',

    'b_mn_alias_new' => 'メールエイリアスを追加します。',
    'b_mn_mail_group' => 'メールグループを管理します。',
    'b_mn_mailbox' => 'メールボックスを管理します。',
    'b_mn_preferences' => 'メールアカウントを設定します。',
    'b_mn_responders' => '自動返信を管理します。',
    'b_mn_resp_rm_submit' => '自動返信を削除します。',
    'b_mn_redir_rm_submit' => 'メール転送を削除します。',
    'b_mn_redirect' => 'メール転送を管理します。',
    'b_mn_files_rm_submit' => 'ファイルを削除します。',
    'b_mn_attach_rm_submit' => '添付を削除します。',
    'b_mn_groups' => 'メールグループを管理します。',
    'b_mn_spamfilter_on' => 'スパムフィルタを管理します。',
    'b_mn_spamfilter_off' => 'スパムフィルタリングは現在使用できません。使用するには、スパムフィルタソフトウェアをインストールし、メールボックス -> スパムフィルタページで、ユーザレベルのスパムフィルタリングを有効にする必要があります。',
    'b_mn_spamfilter_srv' => '管理者により、ユーザがスパムフィルタを構成する権限が無効になっています。',

    'b_make_dump' => 'ドメインをバックアップします。',
    'b_ftp_account_for_dumps_repository' => '外部 FTP サーバにドメインバックアップを保存できるようにするには、サーバへのアクセスに使用する　FTP アカウントのプロパティを指定する必要があります。',
    'b_cron_task_backup' => 'スケジュール済みバックアップを管理',

    'b_mg_mem_del' => 'リストからメールグループのメンバを選択して、クリックすると削除されます。',
    'b_mg_add' => '選択したメールグループにメールアカウントを追加する',
    'b_mg_cancel' => 'キャンセルします。',
    'b_mg_del' => '選択したメールグループからメールアカウントを削除します。',
    'b_mg_mem_new' => 'メールグループメンバーを追加します。',
    'b_mg_turn_on' => 'クリックしてメールグループをオンにします。',
    'b_mg_turn_off' => 'クリックして、メールグループをオフにします。',
    'b_mg_update' => '変更を適用します。',
    'b_mn_rm_submit' => 'メールアカウントを削除します。',
    'b_mn_webmail_on' => 'ウェブメールを開きます。',
    'b_mn_webmail_off' => 'この機能は現在使用できません。メール設定でウェブメールサポートがオンになっていないか、メールボックスがアクティブ化されていません。',

    'b_modules_manage' => 'Plesk にインストールされたモジュールを管理し、これらのモジュールの機能にアクセスします。',
    'b_notifications' => '通知を編集します。',
    'b_permissions' => '顧客のパーミッションを表示または設定する',
    'b_performance' => '各ドメインのパフォーマンス管理',
    'b_first_page' => '既に先頭ページです。',
    'b_anonftp_stats' => '匿名 FTP トランザクション統計。',
    'b_ftp_stats' => 'FTP サーバログファイル分析',
    'b_ftp_stats_disable' => 'ウェブ統計が有効でないか、匿名 FTP サービスがスイッチオンされていない、または物理ホスティングモードではありません。',
    'b_last_page' => '既に最終ページです。',
    'b_next_page' => '次のページに進む',
    'b_prs_rm_submit' => '優先度を削除します。',
    'b_preferences' => "インターフェース設定をセットアップします。",
    'b_prev_page' => '前のページに戻ります。',
    'b_preview' => 'DNS プロパゲーションの前にサイトをプレビューします。',
    'b_qus_rm_submit' => '優先度を削除します。',
    'b_repair_ip' => 'IP アドレスを追加します。',
    'b_repair_ip_status_ok' => 'このIP アドレスは修復する必要はありません',
    'b_reboot' => 'サーバをリブートします。',
    'b_refresh' => '画面上のデータを更新します。',
    'b_key_buyonline_addons' => 'Plesk アドオンを注文します。',
    'b_key_buyonline_upgrades' => 'Plesk アップグレードを注文する',
    'b_key_buyonline_new' => '新しいライセンスキーを注文する',
    'b_quick_search' => '検索条件に一致するアイテムの一覧を表示する',
    'b_remove_ip' => "リストから IP アドレスを選択し、顧客の IP プールから削除します。",
    'b_restart_services' => "{$PROD_NAME} サービスを管理",
    'b_send_passwd' => 'パスワードをメールで送信します。',
    'b_server' => 'サーバ全体の設定をセットアップします。',
    'b_database_servers' => 'データベースサーバ管理',
    'b_server_pref' => 'システムおよびインターフェースの設定',
    'b_sessions' => 'セッションを管理します。',
    'b_sess_rm_submit' => 'セッションを削除します。',
    'b_set_time' => 'システム日時を設定します。',
    'b_set_time_virtuozzo' => 'Virtuozzo containers でシステム日付/時刻を変更できません。',
    'b_site_apps' => 'ウェブアプリケーション管理',
    'b_site_apppkgs' => 'ウェブアプリケーションパッケージ管理',
    'b_site_apppkgs_pool' => 'ウェブアプリケーションパッケージを管理',
    'b_site_apps_rm_submit' => '選択したウェブアプリケーションを削除します。',
    'b_additional_key_is_active' => '言語パックは既に有効になっています。',
    'b_additional_key_activate' => 'ライセンスキーをアクティアクティブ化します。',
    'b_site_builder' => 'Presence Builder との統合を有効化します。',
    'b_dom_site_builder' => 'Presence Builder ウィザードを開きます。',
    'site_builder_no_permission' => 'サイトビルダーを使用するパーミッションがありません',
    'b_site_builder_no_package' => 'サイトビルダーがインストールされていません',
    'b_site_builder_no_requires' => 'ホスティング要項が満たされていないため、サイトビルダーを起動できません',
    'b_site_builder_no_vrt_hst' => 'Mambo CMS を使用可能にするには、このドメインに対して物理ホスティングをセットアップする必要があります。',
    'b_site_builder_setup' => 'Mambo CMS を実行（初めて実行する場合、アプリケーションが構成されます）',
    'b_show_aliases' => 'エイリアスを表示する',
    'b_show_domainaliases' => 'ドメインエイリアスを表示',
    'b_show_subdomains' => 'サブドメインを表示する',
    'b_shutdown' => 'サーバをシャットダウンします。',
    'b_statistics' => 'サーバ統計を閲覧します。',
    'b_system_time' => 'システム日時を管理します。',
    'b_support' => 'テクニカルサポートに連絡します。',
    'b_summary_report' => 'レポートを閲覧します。',
    'b_subdom_hosting' => 'サブドメイン・ホスティングを管理・設定する',
    'b_subdomains' => 'サブドメインの作成および管理',
    'b_traffic_history' => 'トラフィック履歴を表示します。',
    'b_set_timezone' => 'タイムゾーンを設定します。',
    'b_set_timezone_virtuozzo' => 'Virtuozzo containers でタイムゾーンを変更できません。',
    'b_uninst_submit' => "{$PROD_NAME} をアンインストールします。",
    'b_uninst_cancel' => 'アンインストールをキャンセルします。',
    'b_upload_from_ftp' => 'FTP サーバのダンプリストを確認します。',
    'b_ok' => 'すべての変更を適応する',
    'b_update' => 'すべての変更を適応する',
    'b_update_db_access' => 'データベースアクセス用クレデンシャルへの変更を保存する',
    'b_updtntp' => 'NTPサーバとの同期を開始/停止します。',
    'b_updtntp_virtuozzo' => 'Virtuozzo containers で NTP サーバとの時刻同期をセットアップできません。',
    'b_updtpswd' => "管理者パスワードを変更します。",
    'b_upload_dump' => 'バックアップストレージにバックアップファイルをアップロードします。',
    'b_no_dumps_on_ftp' => 'リモートストレージが空です。',
    'b_web_stats' => 'ウェブサーバログファイル分析',
    'b_web_stats_disable' => 'ウェブ統計がアクティブでないか、ホスティングが物理ホスティングでありません。',
    'b_web_stats_ssl' => 'セキュアウェブサーバログファイル分析',
    'b_web_stats_ssl_disable' => 'ウェブ統計がアクティブでないか、セキュアウェブサーバが構成されていないか、またはホスティングが物理ホスティングでありません。',
    'b_web_users' => 'ドメインのセカンダリウェブユーザを設定します。',
    'b_vhost_app_add' => 'ドメインにウェブアプリケーションを追加する',
    'b_vhost_app_add_no_domains' => 'これらの仮想ホストのルートディレクトリには、ウェブアプリケーションがインストール済みです。',
    'b_interface_management' => 'Plesk の各種項目の表示/非表示を変更します。',
    'b_virtualdirs' => '仮想ディレクトリを管理する',
    'b_virtualdir_add' => '仮想ディレクトリを追加します。',
    'b_zone_switch_master' => 'DNS ゾーンタイプをプライマリに切り替えます。',
    'b_zone_switch_slave' => 'DNS ゾーンタイプをセカンダリに切り替えます。',

    'b_logrotation_update' => 'ログローテーション設定を変更します。',
    'b_logrotation_on' => 'ログローテーションをオンにします。',
    'b_logrotation_off' => 'ログローテーションをオフにします。',

    'b_dom_tmpl_add' => 'ドメインテンプレートを作成します。',
    'b_cl_tmpl_add' => 'クライアントテンプレートを作成します。',
    'b_tmpl_update' => 'テンプレートプロパティを更新します。',
    'b_tmpl_rm_subm' => 'テンプレートを削除します。',

    'b_defaultcomponents' => 'サードパーティのサービスを選択します。',
    'b_defaultcomponents__update' => '選択したサービスをインストールすることを確認し、そのサービスの設定へ進みます。',
    'b_defaultcomponents__cancel' => 'すべての変更を破棄して、前のページに戻ります。',

    'b_locale_add' => '新しい言語パックをアップロードします。',
    'b_locales_managment' => 'インターフェース言語を管理します。',

    'b_subdom_performance' => '各サブドメインのパフォーマンス管理',

    'b_anon_on' => 'ドメインの匿名 FTP サービスをオンにする',
    'b_anon_off' => 'ドメインの匿名 FTP サービスをオフにする',

    'b_maillists' => 'メーリングリストを編集します。',
    'b_maillist_new' => 'メーリングリストを作成します。',
    'b_maillist_edit' => 'メーリングリスト管理ページにアクセスします。',
    'b_maillist_turn_on_off' => 'メーリングリストの状態を変更します。',
    'b_maillists_on' => 'メーリングリストサービスをアクティブ化します。',
    'b_maillists_off' => 'メーリングリストサービスを非アクティブ化します。',
    'b_maillist_off_disabled' => '現在のメールサーバはメーリングリストを無効化をサポートしていません',
    'b_maillists_invert_on_off' => '選択したメーリングリストの状態を変更します。',

    'b_dom_performance_edit' => '各ドメインのパフォーマンスを設定する',
    'b_dom_performance_readonly' => '各ドメインのパフォーマンス設定を参照する',
    'b_dom_performance_disabled' => 'QoS がネットワークデバイスに適用されていない限り、この機能は利用できません',
    'b_subdom_performance_disabled' => 'QoS がネットワークデバイスに適用されていない限り、この機能は利用できません',

    //=============return to up level conhelp =====================

    'b_to_admin' => "ヘルプデスクの管理に戻る",
    'b_to_aliases' => 'メールエイリアス管理ページに戻ります。',
    'b_to_autoinstaller_components' => 'コンポーネント選択ページに戻ります。',
    'b_to_autoinstaller_releases' => 'リリース選択ページに戻ります。',
    'b_to_custom_buttons' => 'カスタムボタン設定/管理ページに戻ります。',
    'b_to_cl_traffic' => "顧客のトラフィックページに戻ります。",
    'b_to_cl_templates' => "顧客テンプレートのリストに戻ります。",
    'b_to_cl_pref' => '顧客設定に戻ります。',
    'b_to_comp_info' => "Plesk のコンポーネントの管理に戻ります。",
    'b_to_dom_rep' => 'ドメイン情報ページに戻ります。',
    'b_to_filemanager' => 'ファイルマネージャページに戻ります。',
    'b_to_subdomains' => 'サブドメインのリストに戻ります。',
    'b_to_sessions' => 'セッションに戻ります。',
    'b_to_databases_db' => "データベース管理者のクレデンシャルおよびツールページに戻ります。",
    'b_to_dumps_list' => 'ドメインバックアップファイルのストレージに戻ります。',
    'b_to_backup_manager' => 'バックアップ管理ページに戻る',
    'b_to_log_files' => 'ログファイルリストに戻ります。',
    'b_to_domains' => 'ドメインリストに戻ります。',
    'to_domain_aliases' => 'ドメインエイリアスのページに戻る',
    'b_to_clients' => '顧客リストに戻ります。',
    'b_to_client_home' => "顧客のホームページに戻ります。",
    'b_to_cp_access' => 'IP アクセス制限管理ページに戻ります。',
    'b_to_crontab_unix' => 'Crontab 管理ページに戻ります。',
    'b_to_crontab_win' => 'スケジューラ管理ページに戻ります。',
    'b_to_dns' => 'DNS ゾーンに戻ります。',
    'b_to_dom_ctrl' => 'ドメイン管理ページに戻る',
    'b_to_license_management' => 'ライセンス情報に戻る',
    'b_to_mail' => 'サーバ全体のメール設定に戻ります。',
    'b_to_maillists' => 'メーリングリスト管理に戻ります。',
    'b_to_maillist_members' => 'メーリングリストメンバー管理に戻ります。',
    'b_to_mail_names' => 'メールアカウントの管理に戻る',
    'b_to_mail_name_responders' => '自動応答管理に戻ります。',
    'b_to_mail_name_resp_edit' => '自動返信プロパティの編集に戻ります。',
    'b_to_mail_name_resp_attach_add' => '新しい添付ファイルの作成ページに戻ります。',
    'b_to_mail_name_redirects' => 'メール転送の管理に戻ります。',
    'b_to_mail_name_files' => 'メールアカウントの添付ファイルリポジトリに戻る',
    'b_to_mail_white_list' => 'ホワイトリストエントリの管理に戻ります。',
    'b_to_notifications' => '通知編集に戻ります。',
    'b_to_server' => 'サーバ管理ページに戻ります。',
    'b_to_spamassassin' => 'スパムフィルタの構成に戻る',
    'b_to_skins' => 'スキンの管理に戻る',
    'b_to_skin_info' => 'スキンプロパティの確認に戻ります。',
    'b_to_scheduler' => 'スケジューラ管理ページに戻ります。',
    'b_to_subdom_ctrl' => 'サブドメイン管理ページに戻る',
    'b_to_prs' => '優先度に戻ります。',
    'b_to_responders' => '自動応答管理に戻ります。',
    'b_to_virtualdirs' => '仮想ディレクトリ管理に戻る',
    'b_to_virtualdir_edit' => '前の仮想ディレクトリに戻ります。',
    'b_to_virtualdir_root' => '仮想ディレクトリのリストに戻ります。',
    'b_to_web_users' => 'ウェブユーザのリストに戻ります。',
    'b_to_cert' => '証明書管理に戻ります。',
    'b_to_cl_rep' => "クライアント情報に戻る",
    'b_to_report' => '情報ページに戻ります。',
    'b_to_report_list' => 'カスタムレポートレイアウトページに戻ります。',
    'b_to_db_list' => 'データベースのリストに戻ります。',
    'b_to_db_usr_lst' => 'データベースユーザのリストに戻る',
    'b_to_db_servers' => 'データベースサーバの一覧に戻る',
    'b_to_dns_template' => 'DNS テンプレートレコードのリストに戻ります。', //to remove
    'b_to_log_files_list' => 'ログファイルの管理に戻ります。',
    'b_to_log_rotation' => 'ログローテーション設定に戻ります。',
    'b_to_locales' => 'Plesk 言語の管理に戻ります。',
    'b_to_modules' => 'モジュール管理に戻ります。',
    'b_to_modules_management' => 'モジュール管理に戻ります。',
    'b_to_cl_pool' => 'IP プール管理に戻ります。',
    'b_to_db' => 'データベースの管理に戻ります。',
    'b_to_db_edit' => 'データベースユーザ管理に戻る',
    'b_to_dom_templates' => 'ドメインテンプレートの管理に戻ります。',
    'b_to_dom_sum_report' => 'ドメイン概要レポートに戻る',
    'b_to_statistics' => 'トラフィック統計に戻ります。',
    'b_to_ip_aliasing' => 'IP アドレス管理に戻る',
    'b_to_qus' => '通し番号のリストに戻ります。',
    'b_to_site_apps' => 'ウェブアプリケーションの一覧に戻る',
    'b_to_site_app_pkgs' => 'サイトアプリケーションヴォルトに戻ります。',
    'b_to_siteapp_install' => 'ウェブアプリケーションインストールウィザードに戻る',
    'b_to_siteapppackage_info' => 'ウェブアプリケーションパッケージプロパティに戻る',
    'b_to_additional_key_info' => 'ライセンスキーのプロパティに戻ります。',
    'b_to_additional_key_properties' => 'ライセンスキーのプロパティに戻ります。',


    //===============Href conhelp==================//
    'b_components_choice_default' => 'この機能のデフォルトコンポネントを変更する',
    'b_components_configure' => "このコンポーネントの構成パラメータをセットアップします。",


    //===============Icon conhelp==================//

    'i_db_conn_none' => 'この機能は使用できません。ライセンスキーでサポートされていないか、サービスがインストールされていません。',
    'i_db_conn_ok' => 'データベースに接続しました',
    'i_db_conn_att' => 'データベースサーバが起動していないか、指定したクレデンシャルが間違っています。',
    'i_db_conn_stopped' => 'データベースサーバは起動していません',
    'i_db_conn_login_failed' => 'データベース接続用のクレデンシャルが正しくありません',

    'i_drweb_off' => "このメールアカウントではアンチウイルスチェックが有効ではありません",
    'i_drweb_any' => '送信/受信メールのアンチウイルスチェックが有効です。',
    'i_drweb_from' => '送信メールのアンチウイルスチェックが有効です。',
    'i_drweb_to' => '受信メールのアンチウイルスチェックが有効です。',
    'i_drweb_turn_key' => 'このライセンスキーではアンチウイルスはサポートされていません。',
    'i_drweb_turn_perm' => 'アンチウイルスを管理するパーミッションがありません。',
    'i_drweb_turn_install' => 'アンチウイルスがインストールされていません。',
    'i_drweb_turn_pref' => 'アンチウイルス設定を管理します。',

    'i_client_ok' => 'クライアントのリソース使用量は制限内です',
    'i_cl_ok' => 'クライアントのリソース使用量は制限内です',
    'i_cl_!' => "クライアントのリソース使用量が上限を超過しています。",
    'i_client_on' => 'このユーザアカウントは有効です',

    'i_client_cp_access_on' => '顧客パネルへの顧客のアクセスは許可されます。',
    'i_client_cp_access_off' => '顧客パネルへの顧客のアクセスは許可されません。',
    'i_click_to_cl_cp_access_on_off' => "顧客パネルへの顧客のアクセスを許可または禁止します。",

    'i_custom_errors_del' => 'リストからアイテムを削除します。',
    'i_custom_errors_del_disabled' => 'サーバにおけるデフォルトカスタムエラーページの削除はできません',

    'i_open_subdomain' => 'ウェブブラウザでサイトを表示します。',
    'i_open_domain' => 'ウェブブラウザでサイトを表示します。',
    'i_open_domain_disabled' => 'ドメインのホスティングは設定されていません',

    'i_dom_ok' => 'このドメインのリソース使用量は制限値以内です',

    'i_dom_tmpl__owner_admin' => 'このテンプレートはシステム管理者によって作成されました',
    'i_dom_tmpl__owner_client' => 'このテンプレートは顧客によって作成されました。',

    'i_dns_on' => 'この DNS ゾーンはローカル DNS サーバにより提供されています。',
    'i_dns_off' => 'この DNS ゾーンは外部 DNS サーバにより提供されています。',
    'i_click_to_dom_on_off' => 'ドメインをアクティブ化/非アクティブ化します。',
    'i_click_to_cl_on_off' => "顧客アカウントと顧客のドメインをアクティブ化/非アクティブ化します。",
    'i_dom_!' => 'このドメインによるリソース使用量の上限を超過しました。',
    'i_dom_on' => 'ドメインは有効です',
    'i_dom_off' => 'ドメインは無効です',
    'i_dom_off_by_admin' => 'ドメインは管理者により一時停止されています。',
    'i_dom_off_by_reseller' => 'ドメインはリセラーにより一時停止されています。',
    'i_dom_off_by_client' => 'ドメインはクライアントにより一時停止されています。',
    'i_dom_off_expired' => 'ドメインが有効期限切れです',
    'i_dom_off_with_parent' => "このユーザアカウントおよびユーザドメインは一時停止されています。",
    'i_dom_off_backup_restore' => 'バックアップまたは復元中のため、ドメインは一時的に停止されています。',

    'i_locale_active_true' => 'この言語は Plesk ユーザに対して使用可能になっています。',
    'i_locale_active_att' => '許可されている言語の上限数を超えたため、ユーザはこの言語を使用できなくなりました',
    'i_locale_active_false' => 'この言語はユーザに対して使用不可になっています。',
    'i_locale_set_active_true' => 'このアイコンをクリックすると、ユーザに対してこの言語が使用可能になります。',
    'i_locale_set_active_false' => 'このアイコンをクリックすると、ユーザに対してこの言語が使用不可になります。',
    'i_locale_default_locale' => 'これはデフォルト言語です。ユーザに対して使用不可にすることはできません。',

    'i_log_rot_enabled' => 'ログローテーションがオンになっています。',
    'i_log_rot_disabled' => 'ログローテーションはオフになっています。',
    'i_log_rot_disabled_by_parent' => 'ウェブサイトがオフになっているため、ログローテーションはオフです。',

    'i_spamfilter_on' => 'スパムフィルタはオンになっています。',
    'i_spamfilter_off' => 'スパムフィルタはオフになっています。',
    'i_spamfilter_turn_srv' => '個別のスパム防御設定の使用は、サーバポリシーによって許可されていません。',
    'i_spamfilter_turn_key' => 'SpamAssassinが利用できるライセンスキーではありません',
    'i_spamfilter_turn_component' => 'SpamAssassin コンポーネントがインストールされていません',
    'i_spamfilter_service_off' => 'SpamAssassin サービスは停止中です',
    'i_spamfilter_turn_is_disabled_system_wide' => "ホスティングサービス事業者によってスパム防御がオフになっています。",
    'i_spamfilter_turn_permission' => 'スパムフィルタを管理するパーミッションが付与されていません。',

    'i_additional_key_free' => '配布自由なソフトウェアです。ライセンスキーは必要ではありません',
    'i_additional_key_ok' => '必要なライセンスキーはインストールされています。',
    'i_additional_key_problem' => '必要なライセンスキーがインストールされていません',
    'i_additional_key_info' => 'ライセンスキー管理をするには、アイコンをクリックします。',
    'i_additional_key_download' => 'ライセンスキーをダウンロードします。',

    'i_vcard' => 'アドレスブックにユーザを追加します。',

    'i_autoinstaller_component_action_error' => 'アップデートが利用できません',

    'i_autoinstaller_release_action_upgrade' => 'Plesk を新バージョンにアップグレードします。',
    'i_autoinstaller_release_action_update' => '新しいコンポーネントのアップデートまたは追加をします。',
    'i_autoinstaller_release_action_up2date' => '既に最新バージョンを利用しています。',
    'i_autoinstaller_release_action_error' => 'リリースに関する情報取得時のエラー',

    'i_autoinstaller_component_action_install' => '未インストール',
    'i_autoinstaller_component_action_update' => 'アップデートが提供されています',
    'i_autoinstaller_component_action_upgrade' => 'アップデートが提供されています',
    'i_autoinstaller_component_action_up2date' => '最新バージョンが既に導入されています。',

    'i_mail_resp_on' => '自動応答はオンになっています。',
    'i_mail_resp_turn_off' => 'このアイコンをオフにする',
    'i_mail_resp_off' => '自動応答はオフになっています。',
    'i_mail_resp_turn_on' => 'このアイコンをオンにする',
    'i_mail_resp_att' => 'すべての自動応答がこのメールアカウントに対してオフになっています。',

    'i_anonftp_on' => 'ドメインの匿名 FTP アカウントはオンになっています。',
    'i_anonftp_off' => 'ドメインの匿名 FTP アカウントはオフになっています。',

    'i_sapp_ssl' => 'ウェブアプリケーションが SSL/TLS ディレクトリにインストールされています。',
    'i_sapp_non_ssl' => 'ウェブアプリケーションが非 SSL/TLS ディレクトリにインストールされています。',
    'i_serv_drweb_up_dis' => "サービスを起動します。",
    'i_serv_none' => 'サービスがインストールされていません。',
    'i_serv_not_configured' => 'サービスが構成されていません。',
    'i_serv_on' => 'サービスは実行中です。',
    'i_serv_off' => 'サービスが実行されていません。',
    'i_serv_up' => 'サービスを起動します。',
    'i_serv_up_dis' => 'サービスは既に起動しています。',
    'i_serv_down' => 'サービスを停止します。',
    'i_serv_down_dis' => 'サービスは既に停止しています。',
    'i_serv_up_n_down' => 'サービスを再起動します。',
    'i_serv_up_n_down_dis' => 'サービスは停止しています。',
    'i_serv_key_dsbld_not_inst' => 'この機能は使用できません。ライセンスキーでサポートされていないか、サービスがインストールされていないか、適切に構成されていません。',

    'i_skin_download' => 'スキンをダウンロードします。',

    'i_virtualdirs_read_enabled' => '仮想ディレクトリの読み取りパーミッションが有効です。',
    'i_virtualdirs_read_disabled' => '仮想ディレクトリの読み取りパーミッションが無効です。',
    'i_virtualdirs_write_enabled' => '仮想ディレクトリの書き込みパーミッションが有効です。',
    'i_virtualdirs_write_disabled' => '仮想ディレクトリの書き込みパーミッションが無効です。',
    'i_virtualdirs_source_enabled' => '仮想ディレクトリスクリプトのソースへのアクセスパーミッションが有効です。',
    'i_virtualdirs_source_disabled' => '仮想ディレクトリスクリプトのソースへのアクセスパーミッションが無効です。',
    'i_virtualdirs_browse_enabled' => '仮想ディレクトリのディレクトリ参照パーミッションが有効です。',
    'i_virtualdirs_browse_disabled' => '仮想ディレクトリのディレクトリ参照パーミッションが無効です。',
    'i_virtualdirs_change_status' => 'パーミッションを有効/無効にします。',

    'b_show_additional_users' => 'ユーザ/ユーザグループのリストを展開して、未定義パーミッションのユーザを表示します。',
    'b_hide_additional_users' => 'ユーザ/ユーザグループのリストを圧縮して、未定義パーミッションのユーザを隠します。',

    'i_prtd_ssl' => 'SSL/TLS ディレクトリはパスワード保護されています。',
    'i_prtd_no_ssl' => 'SSL/TLS ディレクトリはパスワード保護されていません。',
    'i_prtd_nonssl' => '非 SSL/TLS ディレクトリはパスワード保護されています。',
    'i_prtd_no_nonssl' => '非 SSL/TLS ディレクトリはパスワード保護されていません。',
    'i_prtd_cgi_bin' => 'cgi-bin ディレクトリはパスワードで保護されています。',
    'i_prtd_no_cgi_bin' => 'cgi-bin ディレクトリはパスワードで保護されていません',

    'i_htype_none' => 'ホスティングが設定されていません',
    'i_htype_vrt_hst' => '物理ホスティング',
    'i_htype_frm_fwd' => 'フレーム転送',
    'i_htype_std_fwd' => '標準転送',

    'i_click_to_hosting' => 'ホスティング設定ページに進みます。',

    'i_ftp_ses_domain' => 'ドメイン管理者のセッション',
    'i_ftp_ses_sub_domain' => 'サブドメイン管理者のセッション',
    'i_ftp_ses_web_user' => 'ウェブユーザのセッション',
    'i_ftp_ses_anonymous' => '匿名 FTP ユーザのセッション',
    'i_ftp_ses_not_plesk' => 'Plesk に登録されていない FTP ユーザです。',
    'i_ftp_ses_idle' => 'アイドル（実行中のトランザクションなし）。',
    'i_ftp_ses_upload' => 'アップロード中です。',
    'i_ftp_ses_download' => 'ダウンロード中です。',
    'i_ftp_ses_list' => 'ディレクトリ一覧をダウンロードしています。',
    'i_ftp_ses_not_know' => '認識されていない FTP アクティビティです。',


    //===============Page conhelp==================//

    'admin_ed' => '管理者情報',
    'anonftp' => 'このページで匿名 FTP 機能を構成します。',
    'actionlog' => 'アクションログ設定を管理します。',
    'auto_updates' => "{$PROD_NAME} の利用可能なアップデート",
    'autoinstaller_releases' => '利用可能なコンポーネントのリストにアクセスするには、必要なリリース名を選択してください',
    'autoinstaller_components' => '必要なコンポーネントを選択して、インストールをクリックするとインストールされます。',
    'autoinstaller_install' => 'インストレーションを確認して、OKをクリックしてくださいインストールがはじまります。',
    'autoinstaller_configure' => 'アップデータ設定',
    'backup_dialog' => 'このページでは、ドメインをバックアップできます。作成されたバックアップファイルは、ローカルまたはリモートのバックアップストレージに格納することも、ローカルディスクにダウンロードすることもできます。',
    'backup_configure' => 'バックアップマネージャ構成ページ',
    'card' => '個人情報を編集します。',
    'cat_edit' => 'カテゴリ設定ページ',
    'cert' => '証明書リポジトリ',
    'cert_dom' => '証明書リポジトリ',
    'cert_add' => '証明書を追加します。',
    'cert_add_dom' => '証明書を追加します。',
    'cert_edit' => '証明書編集ページ',
    'cl_ed' => "顧客の情報を編集して［OK］をクリックしてください。",
    'cl_home' => '顧客ホームページ',
    'cl_new' => "顧客の情報を入力して［OK］をクリックすると、顧客アカウントが作成されます。",
    'cl_perm' => "顧客のパーミッションをセットアップします。",
    'cl_limits' => "顧客の上限をセットアップします。",
    'cl_logo' => "顧客の顧客パネル用にロゴをセットアップします。",
    'cl_pool' => '顧客に割り当てられた IP アドレス範囲です',
    'cl_pool_add' => "顧客に IP アドレスを割り当てます。",
    'cl_pool_first_time' => '顧客に IP アドレスを割り当てます。',
    'cl_pool_ctrl' => 'IP アドレスプロパティ',
    'cl_pref' => "顧客の設定",
    'cl_traffic_history' => '顧客のトラフィック履歴ページです',
    'cl_templates' => 'このページには顧客テンプレートが表示されます。',
    'cl_traffic' => "顧客のトラフィック",
    'clients' => 'このページには、システムに登録されたすべての顧客アカウントが表示されます。',
    'component_conf' => "コンポネントのパラメータ設定",
    'custom_buttons_admin' => 'カスタムボタンを作成および管理',
    'custom_buttons_domain' => 'カスタムボタンを作成および管理',
    'custom_buttons_client' => 'カスタムボタンを作成および管理',
    'custom_buttons_reseller' => 'カスタムボタンを作成および管理',
    'custom_buttons_remove' => '選択したカスタムボタンを削除します。',
    'custom_button_admin_edit' => 'カスタムボタンを編集します。',
    'custom_button_domain_edit' => 'カスタムボタンを編集します。',
    'custom_button_client_edit' => 'カスタムボタンを編集します。',
    'custom_button_reseller_edit' => 'カスタムボタンを編集します。',
    'configure' => 'インストール後設定ページ',
    'comp_info' => 'コンポーネント情報',
    'common_acl' => 'ゾーン転送が許可されているすべての IP アドレスが表示されています。',
    'to_common_acl' => '共通アクセス制御リストに戻ります。',
    'common_acl_add' => 'このページでは、共有ゾーン転送許可 ACL にレコードを追加できます。',
    'common_acl_remove' => '選択した ACL レコードを削除する',
    'cp_access' => 'Plesk へのアクセスの管理。',
    'cp_access_add_edit' => 'ネットワークプロパティ',
    'cp_access_remove' => 'IP アクセス制限リストからネットワークを削除します。',
    'crontab_unix' => 'システム内でスケジュールされているすべてのタスクを表示しています。',
    'crontab_win' => 'システム内でスケジュールされているすべてのタスクを表示しています。',
    'crontab_unix_add_edit' => '必要なデータを入力してから、［OK］をクリックしてタスクをスケジュールします。',
    'crontab_win_add_edit' => '必要なデータを入力してから、［OK］をクリックしてタスクをスケジュールします。',
    'crontab_unix_remove' => '選択したタスクを削除します。',
    'crontab_win_remove' => '選択したタスクを削除します。',
    'scheduler' => 'このページには、システム上でスケジューリングされているタスクの一覧が含まれています。',
    'scheduler_edit' => '必要な項目を入力して、OKをクリックするとスケジューラにタスクを追加します。',
    'scheduler_remove' => '選択したスケジュール済みタスクを削除する',
    'b_databases_access' => '外部データベースサーバへのアクセス用クレデンシャルを設定する',
    'databases_db' =>  'データベース接続管理ツール',
    'databases_server' =>  'このページでは、データベース サーバへのアクセスに使用されるパスワードを変更できます。',
    'db' => 'Plesk で管理するすべてのデータベースが表示されます。',
    'db_add' => '新規データベース追加ページ',
    'db_edit' => 'データベースユーザリスト',
    'db_usr_edit' => 'データベースユーザのパスワードを設定します。',
    'defaultcomponents' => 'サードパーティのサービス選択',
    'dl_usr_ed' => "ドメイン管理者アカウントを管理",
    'dns_add' => 'ドメインの DNS ゾーンにレコードを追加します。',
    'dns_soa' => 'SOA 設定の構成',
    'dns_check' => 'DNS ゾーンテスト結果',
    'dns_rec_edit' => 'リソースレコードの編集',
    'dns_default' => 'DNS ゾーンを復元',
    'mail_name_drweb' => 'アンチウイルスを構成する',
    'dom_ctrl' => 'ドメイン管理',
    'dom_traffic' => 'ドメインのトラフィック',
    'dom_templates' => 'ドメインテンプレートとは、ドメイン固有の制限、オプション、ホスティングパラメータをあらかじめ定義したセットであり、これらの設定をドメインに自動的に割り当てることでドメインの作成を簡素化することを目的としています。',
    'create_domain' => '顧客用にドメインを作成するには、新しいドメイン名を入力してください。',
    'create_domain_client_select' => 'ドメインを作成する顧客を選択します。',
    'dom_pref' => 'ドメイン設定',
    'dom_lim' => 'ドメイン制限',
    'domain_report' => 'ドメイン情報',
    'domain_aliases' => 'ドメインエイリアスを管理',
    'client_app_item_info' => 'ウェブアプリケーション情報',
    'client_report' => '顧客情報',
    'cl_rpt_list' => 'カスタムレイアウトを管理します。',
    'dom_rpt_list' => 'カスタムレイアウトを管理します。',
    'dom_rpt_edit' => 'クライアントレポートを編集します。',
    'dom_sum_report' => 'システムに登録されたすべてのドメインの概要レポートを表示しています。',
    'domains' => 'システムに登録されたすべてのドメインを表示しています。',
    'dumps_list' => 'ドメインバックアップ機能を使用し、バックアップファイルのストレージを管理します。',
    'download_dialog' => 'バックアップファイルを作成します。',
    'extras' => '追加的サービス管理ページ',
    'edit_dom_tmpl' => 'このページではドメインテンプレートを編集できます。',
    'edit_cl_tmpl' => '顧客テンプレートを編集できます。',

    'interface_templates' => 'インターフェーステンプレート管理',
    'interface_templates_remove' => "削除するには、チェックボックスを選択して削除を確認し、［OK］ボタンをクリックしてください。 ［キャンセル］をクリックすると、削除はキャンセルされます。",

    'b_to_interface_templates' => 'インターフェーステンプレートの一覧に戻ります。',
    'b_interface_template_make_default' => 'インターフェーステンプレートを選択し、クリックしてデフォルトとして指定します。',
    'interface_template_upload' => 'インターフェーステンプレートをアップロードします。',
    'interface_clients' => 'インターフェーステンプレートを使用しているクライアントの一覧です。',
    'b_to_interface_clients' => 'インターフェーステンプレートを使用しているクライアントの一覧に戻ります。',
    'interface_clients_add' => 'このインターフェーステンプレートを使用するクライアントを指定してください。',
    'interface_clients_remove' => 'このインターフェーステンプレートを使用すべきではないクライアントを指定してください。',

    'ftp_account' => 'このページでは、リモートバックアップファイルの保管ディレクトリにアクセスする FTP アカウントを管理することができます。',
    'ftp_dumps_list' => "FTP サーバ上のバックアップファイルストレージの内容が一覧表示されます。バックアップファイルを選択し、ドメインのストレージにアップロードすることができます。",

    'filemanager' => 'このページでファイルとディレクトリを管理します。',
    'filemanager_rename_file' => 'ファイルの名前を変更します。',
    'filemanager_rename_dir' => 'ディレクトリの名前を変更します。',
    'filemanager_chmod' => 'ファイルのアクセス権限を変更します。',
    'filemanager_copy_move' => 'ファイルをコピー（移動）しています。',
    'filemanager_create_file' => 'ファイルを作成します。',
    'filemanager_show' => 'ファイルを閲覧します。',
    'filemanager_edit' => 'ファイルを編集します。',
    'filemanager_remove' => 'ファイルを削除します。',
    'filemanager_owner_row' => 'ファイル所有者',
    'filemanager_new_file' => 'ファイルを作成します。',
    'filemanager_new_dir' => 'ディレクトリ作成',

    'gl_list' => 'グローバルヘルプデスク。',
    'groups' => 'メールグループ管理ページ',
    'icf' => 'ファイアウォール設定',
    'ip_clients' => 'プールにこの IP アドレスを所有するユーザの一覧',
    'ip_clients_add' => 'クライアントを選択し、［OK］をクリックしてクライアントプールに IP アドレスを追加します。',

    'frm_fwd' => '転送先 URL を入力してください。',
    'std_fwd' => '転送先 URL を入力してください。',
    'performance' => '各ドメインのパフォーマンス設定',
    'phosting_setup' => 'ホスティングアカウントのセットアップ。IP アドレスのタイプ（専用/共有）、FTP アカウントユーザ名とパスワード、その他のホスティング関連パラメータを選択してください。',
    'phosting_setup_dom_usr' => 'ホスティングアカウントパラメータ設定',
    'webusers' => 'ドメインのウェブユーザが表示されています。',
    'hst_type_sel' => '設定するホスティングのタイプを選択してください',
    'key_update' => 'キーアップデートのステータス',
    'key_revert' => 'ライセンスキーのロールバック',
    'interface_management' => 'ユーザインターフェース上の項目について、表示/非表示を変更します。',
    'ip_aliasing' => 'ネットワークインターフェースから IP アドレスを追加または削除します。',
    'ip_aliasing_clients' => 'IP プールにこの IP アドレスを持つユーザの一覧を表示する',
    'ip_aliasing_hosting' => 'ホスティングされている、またはこのIP アドレスから転送されているドメインを確認します。',
    'ip_add' => 'IP アドレスを追加',
    'ip_ctrl' => 'IP アドレスパラメータの変更',
    'license' => 'ライセンス契約をよくお読みください。',
    'logo' => 'ロゴのイメージと URL を変更します。',
    'log_files' => 'ドメインに関係したログファイルが表示されています。',
    'log_rotation' => 'ログローテーション設定',

    'locale_upload' => '言語パックをアップロードします。',
    'locales' => 'Plesk 言語を管理します。',
    'locales_remove' => '削除するには、チェックボックスを選択して削除を確認し、［OK］ボタンをクリックしてください。 ［キャンセル］をクリックすると、削除はキャンセルされます。',
    'mail_blocked_domains' => 'ブラックリストを管理',

    'mail_white_list' => 'ホワイトリストを管理します。',
    'mail_white_list_edit' => 'IP アドレスをホワイトリストに追加します。',
    'mail_white_list_remove' => "削除するには、チェックボックスを選択して削除を確認し、［OK］ボタンをクリックしてください。 ［キャンセル］をクリックすると、削除はキャンセルされます。",

    'mail_name_alias_edit' => 'メールエイリアスを作成または編集します。',
    'mail_name_groups' => 'メールグループメンバシップ管理ページ',
    'mail_name_mailbox' => 'メールボックス管理ページ',
    'mail_name_preferences' => 'メールアカウント設定',
    'mail_name_redirects' => 'メール転送管理',
    'mail_name_redirects_add' => 'メールグループメンバを追加します。',
    'mail_name_redirects_remove' => 'メールグループメンバ削除ページ',
    'mail_name_resp_edit' => '自動応答を構成します。',
    'mail_name_resp_attach_add' => '添付するファイルを選択してください',
    'mail_name_resp_attach_del' => '自動返信の添付ファイルを削除します。',
    'mail_name_resp_remove' => '自動応答を削除します。',
    'mail_name_responders' => '自動応答管理',
    'mail_name_files' => 'メールアカウント添付ファイルのリポジトリ',
    'mail_name_files_remove' => 'ファイルを削除します。',
    'mail_names' => 'メールアカウント（メールボックス、メール転送、メールグループ、自動返信）',
    'mail_preferences' => 'メール設定',

    'maillists' => 'ドメインのすべてのメーリングリストを表示しています。',
    'maillists_conf' => 'メインメーリングリスト作成ページ',
    'maillist_edit' => 'メーリングリストパラメータを変更します。',
    'maillist_new' => 'メーリングリスト追加',
    'maillist_del' => 'メーリングリストを削除します。',

    'maillist_members' => 'メーリングリストメンバー。',
    'maillist_members_remove' => 'メーリングリストメンバーを削除します。',
    'maillist_member_edit' => 'メーリングリストユーザを追加',

    'upload_module' => '拡張をアップロード',
    'modules_management' => '拡張管理',

    'b_modules_add' => '拡張を追加',
    'modules_manaege' => '拡張を追加または削除',
    'modules' => 'Plesk にインストールされた拡張で提供される機能にアクセスできます。',

    'notifications' => '通知システムを管理',
    'notification_text' => '通知のテキストを編集します。',
    'pg_manage' => 'PostgreSQL管理者情報を追加/編集します。',
    'prtd_dirs' => 'パスワード保護ディレクトリ',
    'reboot' => 'システムは再起動しています。',
    'responders' => '自動応答メール',
    'redirects' => 'メール転送',
    'restart_services' => 'サービス管理',
    'server' => 'サーバ管理',
    'sessions' => 'セッション設定を変更します。',
    'sessions_list' => 'すべてのセッションを表示しています。',
    'ftp_sessions_list' => 'このページはすべての FTP セッションのリストを表示しています。',
    'cl_skeleton' => '仮想ホストテンプレートを管理',
    'skeleton' => '仮想ホストテンプレートを管理',
    'skins' => 'Plesk スキンを管理します。',
    'skin_info' => 'スキン情報',
    'skin_download' => 'スキンをダウンロード',
    'skin_download_now' => 'スキンのダウンロードを実行中です',
    'skin_upload' => 'スキンをアップロード',
    'skins_remove' => "削除するには、チェックボックスを選択して削除を確認し、［OK］ボタンをクリックしてください。 ［キャンセル］をクリックすると、削除はキャンセルされます。",
    'shutdown' => 'システムはシャットダウンしています。',
    'site_app_pkgs_add' => 'ウェブアプリケーションパッケージを追加します。',
    'site_app_pkgs_list' => '利用可能なウェブアプリケーションパッケージ',
    'site_app_pkgs_instances' => 'アプリケーションインストレーション',
    'siteapp_install' => 'ウェブアプリケーションのインストール',
    'siteapp_reconfigure' => 'ウェブアプリケーション再構成',
    'sitepackage_install_config' => 'ウェブアプリケーションのインストール設定',
    'sitepackage_install_agreement' => 'ウェブアプリケーションのライセンス契約',
    'siteapp_extra_files' => 'ファイルに対する操作を指定してください',
    'siteapppackage_info_server' => 'ウェブアプリケーションパッケージのプロパティ',
    'siteapppackage_info_domain' => 'ウェブアプリケーションパッケージのプロパティ',

    'statistics' => 'システム統計',
    'sys_time' => 'システム日時を設定したり、NTPサーバと同期します。',
    'subdomains' => 'サブドメインの管理を行います。このページからサブドメインの追加、編集、削除が可能です',
    'subdom_ctrl' => 'サブドメイン管理ページ',
    'subdom_edit' => 'サブドメインプロパティの設定',
    'subdom_create' => 'サブドメインの作成',
    'subdom_remove' => '選択したサブドメインを削除します。',
    'templates' => 'すべてのドメインテンプレートを表示しています。',
    'view_info' => 'バックアップファイルプロパティおよびドメイン復元機能を表示しています。',

    'visibility_adminonly' => 'このコントロールボタンを、管理者のみに表示する',
    'visibility_cancel' => 'この画面における、コントロールボタンのカスタマイズをキャンセルします。',
    'visibility_control' => 'このコントロールをカスタマイズします。',
    'visibility_customize' => 'この画面における、それぞれのコントロールボタンをカスタマイズします。',
    'visibility_default' => 'このコントロールボタンをデフォルト設定に戻します。',
    'visibility_export' => 'この画面における設定をシェルスクリプト形式でエクスポートします。Plesk で管理されるサーバでこのスクリプトを実行すると、設定がインポートされます。',
    'visibility_hide' => 'このコントロールボタンを隠します。',
    'visibility_hide_toolbar' => 'このツールバーを隠します。',
    'visibility_ok' => 'この画面における、コントロールボタンの変更を保存します。',
    'visibility_reset_all' => 'すべての画面上の全コントロールボタンを、デフォルト設定に戻します。',
    'visibility_reset_screen' => 'この画面上のすべてのコントロールボタンを、デフォルト設定に戻します。',
    'visibility_show' => 'このコントロールボタンを表示させます。',

    'virtualdirs' => '仮想ディレクトリ管理',
    'virtualdir_create' => '仮想ディレクトリを作成します。',
    'virtualdir_edit' => '仮想ディレクトリの編集',
    'virtualdirs_remove' => '仮想ディレクトリの削除',
    'web_users' => 'ウェブユーザ',
    'web_users_preferences' => "追加ウェブユーザ設定",
    'wu_edit' => 'ウェブユーザの FTP パスワードを設定します。',
    'lang' => 'このページでデフォルトインターフェース言語を設定してください。',
    'ch_pass' => "このページで管理者パスワードを変更してください",
    'dns_template' => 'DNS ゾーンテンプレート管理', //to remove
    'dns_template_add' => 'DNS ゾーンテンプレートにレコードを追加します。', //to remove

    'dns_t' => 'この画面では、サーバ全体の DNS ゾーンテンプレートのリソースレコードを表示します。',
    'dns_t_add' => 'DNS ゾーンテンプレートにレコードを追加します。',
    'dns_t_soa' => 'SOA 設定の構成',
    'dns_t_rec_edit' => 'リソースレコードの編集',
    'dns_t_rec_remove' => '削除するには、チェックボックスを選択して削除を確認し、［OK］ボタンをクリックしてください。 ［キャンセル］をクリックすると、削除はキャンセルされます。',
    'dns_t_default' => 'DNS ゾーンテンプレートの復元',
    'b_to_dns_t' => 'DNS テンプレートレコードのリストに戻ります。',

    'web_app_add' => 'Java アプリケーションを追加します。',

    'qu_edit' => '通し番号設定ページ',
    'qus' => 'キューのリストを表示しています。',

    'remove_modules' => "削除するには、チェックボックスを選択して削除を確認し、［OK］ボタンをクリックしてください。 ［キャンセル］をクリックすると、削除はキャンセルされます。",
    'removeServers' => "削除するには、チェックボックスを選択して削除を確認し、［OK］ボタンをクリックしてください。 ［キャンセル］をクリックすると、削除はキャンセルされます。",
    'removeCerts' => "削除するには、チェックボックスを選択して削除を確認し、［OK］ボタンをクリックしてください。 ［キャンセル］をクリックすると、削除はキャンセルされます。",
    'removeMailAliases' => "削除するには、チェックボックスを選択して削除を確認し、［OK］ボタンをクリックしてください。 ［キャンセル］をクリックすると、削除はキャンセルされます。",
    'removeDataBases' => "削除するには、チェックボックスを選択して削除を確認し、［OK］ボタンをクリックしてください。 ［キャンセル］をクリックすると、削除はキャンセルされます。",
    'removeDataBaseUsers' => "削除するには、チェックボックスを選択して削除を確認し、［OK］ボタンをクリックしてください。 ［キャンセル］をクリックすると、削除はキャンセルされます。",
    'removeCrontabTask' => "削除するには、チェックボックスを選択して削除を確認し、［OK］ボタンをクリックしてください。 ［キャンセル］をクリックすると、削除はキャンセルされます。",
    'removeDomains' => "削除するには、チェックボックスを選択して削除を確認し、［OK］ボタンをクリックしてください。 ［キャンセル］をクリックすると、削除はキャンセルされます。",
    'removeDNS' => "削除するには、チェックボックスを選択して削除を確認し、［OK］ボタンをクリックしてください。 ［キャンセル］をクリックすると、削除はキャンセルされます。",
    'removeClients' => "削除するには、チェックボックスを選択して削除を確認し、［OK］ボタンをクリックしてください。 ［キャンセル］をクリックすると、削除はキャンセルされます。",
    'removeLogFiles' => "削除するには、チェックボックスを選択して削除を確認し、［OK］ボタンをクリックしてください。 ［キャンセル］をクリックすると、削除はキャンセルされます。",
    'removeDumps' => "削除するには、チェックボックスを選択して削除を確認し、［OK］ボタンをクリックしてください。 ［キャンセル］をクリックすると、削除はキャンセルされます。",
    'removeMailNames' => "削除するには、チェックボックスを選択して削除を確認し、［OK］ボタンをクリックしてください。 ［キャンセル］をクリックすると、削除はキャンセルされます。",
    'removeWebUsers' => "削除するには、チェックボックスを選択して削除を確認し、［OK］ボタンをクリックしてください。 ［キャンセル］をクリックすると、削除はキャンセルされます。",
    'removeSessions' => "削除するには、チェックボックスを選択して削除を確認し、［OK］ボタンをクリックしてください。 ［キャンセル］をクリックすると、削除はキャンセルされます。",
    'removeTemplates' => "削除するには、チェックボックスを選択して削除を確認し、［OK］ボタンをクリックしてください。 ［キャンセル］をクリックすると、削除はキャンセルされます。",
    'removeIPAddress' => "削除するには、チェックボックスを選択して削除を確認し、［OK］ボタンをクリックしてください。 ［キャンセル］をクリックすると、削除はキャンセルされます。",
    'removeClientsIP' => "削除するには、チェックボックスを選択して削除を確認し、［OK］ボタンをクリックしてください。 ［キャンセル］をクリックすると、削除はキャンセルされます。",

    'cat_remove' => "削除するには、チェックボックスを選択して削除を確認し、［OK］ボタンをクリックしてください。 ［キャンセル］をクリックすると、削除はキャンセルされます。",
    'pr_remove' => "削除するには、チェックボックスを選択して削除を確認し、［OK］ボタンをクリックしてください。 ［キャンセル］をクリックすると、削除はキャンセルされます。",
    'qu_remove' => "削除するには、チェックボックスを選択して削除を確認し、［OK］ボタンをクリックしてください。 ［キャンセル］をクリックすると、削除はキャンセルされます。",

    'pr_edit' => '優先度設定',
    'prs' => 'このページは優先度を表示します。',

    'spamassassin' => 'SpamAssassin 設定',
    'spamassassin_train' => 'ベイジアンフィルタで使用する統計データベースの学習。メールボックス内のメールをスパムメールと通常メールに分類してください。',
    'spamassassin_train_view_message_source' => 'メッセージソースを閲覧します。',
    'spamassassin_user_conf' => '個人SpamAssassin設定',
    'spaw' => 'HTML エディタ。',
    'upload_dump' => "バックアップファイルを選択し、［アップロード］をクリックして、ファイルをストレージにアップロードします。マルチボリュームバックアップをアップロードするには、ボリュームの最初の部分を指定して、［次のボリュームを指定する］リンクをクリックし、次のボリュームを指定してください。バックアップの全ボリュームを指定するまでこれを繰り返します。完了したら、［アップロード］をクリックします。",
    'subdom_performance' => 'サブドメインのパフォーマンス設定。',

    'dom_performance_edit' => '各ドメインのパフォーマンス設定',
    'dom_performance_readonly' => 'ドメインのパフォーマンス設定の表示',

    //===============List table header conhelp==================//

    'l_inv' => 'チェックボックスの選択を反対にします。',
    'l_rad' => 'ラジオボタンを選択してください',

    'b_wizard_prev' => 'ウィザードの前のステップに戻ります。',
    'b_wizard_next' => 'ウィザードの次のステップに進みます。',
    'b_finish' => '画面上の変更を適用し、次のステップに進まずにウィザードを終了させます。',

    // pacif add

    'b_backup_ftp_settings' => 'FTP アカウント設定を指定します。',
    'b_backup_scheduled_settings' => 'バックアップスケジューリングをセットアップします。',
    'b_backup_ftp_not_configured' => 'FTP アカウントが設定されていません',
    'backup_client_front' => 'ユーザアカウントのバックアップと復元を行い、バックアップのスケジュールを設定します。',
    'backup_domain_front' => 'ウェブサイトのバックアップと復元を行い、バックアップのスケジュールを設定します。',
    'backup_client_new' => 'ユーザアカウントのバックアップを作成します。',
    'backup_domain_new' => 'ウェブサイトのバックアップを作成します。',
    'backup_ftp_settings' => 'リモートストレージとして使用する FTP アカウントの設定を指定してください。',

    'backup_overwrite' => 'ファイルを置き換えるには、チェックボックスをオンにして置き換えを確認し、［OK］をクリックしてください。',
    'b_backup_file_overwrite' => '現在のバックアップファイルを新しいファイルに置き換えます。',
    'b_backup_file_overwrite_cancel' => 'ファイル置換をキャンセルし、バックアッププロパティのセットアップに戻ります。',
    'b_backup_cancel' => 'バックアッププロセスを停止します。',

    'b_backup_cancel_creating' => 'バックアップ作成をキャンセルし、前のページに戻ります。',
    'b_backup_cancel_ftp_settings' => 'FTP アカウント設定を破棄し、元のページに戻ります。',
    'b_restore_cancel' => '復元処理を停止します。',
    'backup_progress' => 'バックアップの進行状態を表示しています。キャンセルをクリックし、バックアップ作業を停止することが可能です',
    'restore_progress' => '復元の進行状況を表示します。 ［キャンセル］をクリックすると、復元処理は停止します。',
    'b_backup_new_restore' => '復元の開始',
    'b_restore_cancel_creating' => '復元をキャンセルし、元のページに戻ります。',
    'b_backup_file_delete' => 'バックアップファイルを削除します。',
    'backup_delete' => 'バックアップファイルの削除を確認するには、チェックボックスを選択して［OK］ をクリックしてください。',
    'backup_result' => 'バックアップの結果を確認します。完了させるにはOK をクリックし、バックアップマネージャに戻ります。',
    'backup_restore_results' => '復元結果を確認したら、［OK］ をクリックしてバックアップマネージャに戻ります。',

    'i_backup_domain_can_restore' => 'このドメインは復元可能です',
    'i_backup_domain_exist_other_client' => '他のユーザに属している同じ名前のドメインがあるため、このドメインは復元できません。',
    'backup_failed' => 'バックアップに失敗しました。',
    'backup_stop' => 'バックアップ処理を停止するには［OK］ をクリックします。 バックアップを続ける場合は［キャンセル］をクリックします。',
    'restore_stop' => '［OK］をクリックすると、復元処理は停止します。 ［キャンセル］をクリックすると、復元処理は続行します。',
    'backup_info_domain' => 'このバックアップファイルからデータを復元するには、［次へ>>］をクリックします。',
    'backup_info_domain_restore' => 'このバックアップファイルからデータを復元するには、復元をクリックしてください',
    'backup_info_client' => 'このバックアップファイルからデータを復元するには、必要なアイテムを選択して［次へ>>］をクリックします。',
    'backup_ip_mapping_domain' => 'バックアップアップファイルに登録されている IP アドレスを、Plesk 上に存在するアドレスにマッピングします。',
    'backup_ip_mapping_client' => 'バックアップアップファイルに登録されている IP アドレスを、Plesk 上に存在するアドレスにマッピングします。',
    'backup__db_server_mapping' => 'バックアップ内のデータベースサーバのマッピング先として、Plesk で構成されているデータベースサーバを選択してください。',

    'b_restore_ip_mapping' => '復元用の IP マッピングをセットアップします。',
    'learn_more' => 'この新機能をより詳しく知る',
    'try_new_feature' => '新機能をお試しください',
    'whats_new_full' => 'このリリースの新しい機能と更新の詳細情報',
    'b_migration_dump_all' => 'リモートホスト上のすべてのアカウントを移行します。',
    'i_migration_not_exist_account' => 'このアカウントは移行可能です',
    'i_migration_exist_account' => "このアカウントを移行できません : 既に {$PROD_NAME} に存在します。",
    'i_migration_not_exist_domain' => 'このドメインは移行可能です',
    'i_migration_exist_domain' => "このドメインを移行できません。既に {$PROD_NAME} に存在します。",
    'i_migration_bad_domain' => 'このドメインは移行できません。ドメインネームが不正です',
    'i_migration_con_exist_domain' => 'いくつかのドメインは、既にこのアカウントに移行されています。',
    'i_migration_all_domain_exist' => "アカウント情報のみ移行します。このアカウントに関連するすべてのドメインが既に {$PROD_NAME} に存在します。",
    'migration_upload' => '移行・移管エージェントをホストにアップロードするには、ソースプラットフォームを選択し、ソースホスト名とログインクレデンシャルを指定して［次へ］をクリックしてください。',
    'migration_progress' => '移行の進行状況を確認し、もし必要であれば移行を中止します。',
    'b_migration_host_info' => 'リモートホスト上の情報を表示し、移行するオブジェクトを選択する',
    'b_migration_single_info' => 'ダンプからすべてのデータをインポートするか、インポートするオブジェクトを選択することができます。このページでは、展開時の設定を行うことも可能です',
    'migration_content_download' => 'リモートホスト上のコンテンツのダウンロード状況を確認し、必要であれば停止することができます。',
    'migration_content_download_not_space' => 'リモートホストからダウンロードするために必要な、十分なディスクスペースがありません',
    'migration_objects_select' => '移行用に、アカウントとドメインを選択する',
    'migration_account_select' => '選択したドメインの移行先とする Plesk ユーザアカウントを選択してください。',
    'migration_ip_mapping' => 'リモートホストの IP アドレスをマッピングする Plesk の IP アドレスを選択してください。',
    'migration_stop' => '移行を停止し、リモートホストから移行・移管エージェントを削除するには、チェックボックスをオンにして［OK］をクリックしてください。',
    'migration_result' => '移行の結果を確認し、終了ボタンをクリックして移行を終了させてください',
    'migration_failed' => '移行に失敗しました',
    'b_migrate' => '移行を開始する',
    'b_migrate_cancel' => '移行を停止します。',
    'b_migration_reload' => 'データを更新します。',
    'b_migrate_domains' => '選択したドメインを移行します。',
    'b_migrate_accounts' => '選択したアカウントを移行します。',
    'b_migrate_set_accounts' => 'オブジェクト移行用にアカウントを定義します。',
    'b_migrate_set_ip_map' => 'オブジェクト移行用に IP　マッピングをセットアップします。',
    'b_migrate_set_db_server_map' => '移行したデータベースのマッピングをセットアップします。',
    'b_migration_begin' => '新しい移行を開始します。',
    'b_migration_more' => 'このホストから追加のオブジェクトを移行します。',
    'b_migration_retry' => 'ディスクスペースの解放後、移行を続行します。',
    'b_migration_ignore' => '移行を続行します。',
    'b_migrate_single' => 'シングルホスト移行',

    'b_migration_session_add' => '移行セッションを作成します。',
    'b_to_migration_manager' => '移行セッションのリストに戻ります。',
    'b_to_ip_map_page' => 'IP マッピングページに戻ります。',
    'migration_upload_ipmap_file' => 'IP マッピングファイルのアップロード',
    'b_ipmap_download' => 'IP マッピングファイルをダウンロードする',
    'b_ipmap_upload' => 'IP マッピングファイルのアップロード',

    'b_install' => 'ウェブ アプリケーションのインストール',

    'b_sb_menu_desktop' => "Presence Builder システム管理者のホームページに進みます。",
    'b_sb_menu_users' => "顧客のユーザアカウントとサービスプランを追加および管理する",
    'b_sb_menu_sites' => "ウェブサイトを追加および管理します。",
    'b_sb_menu_server' => "Presence Builder システムをセットアップします。",
    'b_sb_menu_logs' => "Presence Builder システムおよびセキュリティログを表示します。",
    'b_sb_server_configure' => "Presence Builder との統合をセットアップします。",
    'sb_server_configure_page_description' => "Plesk が Presence Builder での認証時に使用するユーザ名とパスワードを指定してください。これらのユーザ名とパスワードは、事前に Presence Builder で設定しておく必要があります。",
    'b_sb_site_wizard' => "Presence Builder に移動してウェブサイトを作成・管理します。",

    'b_connect' => 'ローカルアカウントをグローバルアカウントに接続する',
    'b_disconnect' => 'グローバルアカウントよりローカルアカウントを接続解除する',
    'b_fi_change_passwd' => 'グローバルアカウントのパスワードを変更する',
    'connect' => 'ローカルアカウントをグローバルアカウントに接続する',
    'disconnect' => 'グローバルアカウントよりローカルアカウントを接続解除する',
    'fi_change_passwd' => 'グローバルアカウントのパスワード変更',

    'sapp__no_license_key' => 'ライセンスキーリポジトリにキーを追加するまで、アプリケーションパッケージを作成することはできません',

    'b_dns__tabs_general' => '一般 DNS 設定ページ',
    'sessions__tabs_soa_record' => 'SOAレコードのカスタマイズ',

    'packages_preinstall' => 'ウェブアプリケーションのインストール設定',

    'packages_info_server' => 'アプリケーションパッケージの情報を表示します。',
    'packages_info_domain' => 'アプリケーションパッケージの情報を表示します。',
    'b_to_packages_info' => 'パッケージ情報ページに戻ります。',
    'packages_install' => 'パッケージのインストール設定を指定します。',

    'b_server_app_add' => '新しいサーバアプリケーションインストレーションページに移動します。',
    'b_help_install' => 'アプリケーションのインストールを開始する',
    'b_help_cancel' => 'アプリケーションインストールのキャンセル',
    'packages_reconfigure' => 'サーバアプリケーション再構成',
    'packages_remove' => '削除するには、チェックボックスを選択して削除を確認し、［OK］ボタンをクリックしてください。 ［キャンセル］をクリックすると、削除はキャンセルされます。',

    'b_packages_management' => 'サーバアプリケーション管理',
    'packages_management' => 'サーバにサーバアプリケーションをインストールしたり、削除することができます。',
    'b_to_packages_management' => 'サーバアプリケーション管理ページに戻る',

    'i_ftp_ses_type' => '顧客が最後に送信したコマンドは TYPE です。',
    'i_ftp_ses_pass' => '顧客が最後に送信したコマンドは PASS です。',
    'i_ftp_ses_noop' => '顧客が最後に送信したコマンドは NOOP です。',

    'virtualdirs__remove_submit' => '選択した仮想ディレクトリを削除します。実際の物理ディレクトリは削除されません。',

    'b_set_skin' => '現在のスキンをデフォルト Plesk スキンにします。',
    'set_skin__already_default' => '現在のスキンは、既にデフォルト Plesk スキンに設定されています。',

    'i_custom_errors_add' => '必要な情報を入力し、クリックしてカスタムエラーメッセージを追加します。',

    'i_antivirus_off' => 'このメールボックスのアンチウイルス プロテクションは有効です',
    'i_antivirus_on' => 'このメールボックスのアンチウイルス プロテクションは無効です',
    'i_antivirus_turn_pref' => 'アンチウイルス防御設定をセットアップします。',
    'i_antivirus_turn_key' => 'アンチウイルス プロテクションは現在のライセンスではサポートされていません',
    'i_antivirus_turn_perm' => 'アンチウイルスを管理するパーミッションを与えられていません',

    'b_acl_add' => 'ゾーン転送許可 ACL にアドレスを追加します。',
    'dns_acl' => 'ゾーン転送が許可されているすべての IP アドレスが表示されています。',

    'i_antivirus_any' => 'アンチウイルス プロテクションは送受信に対してセットされています。',
    'i_antivirus_from' => 'アンチウイルス プロテクションは送信に対してセットされています。',
    'i_antivirus_to' => 'アンチウイルス プロテクションは受信に対してセットされています。',

    'i_ip_fail_no_interface' => 'この IP アドレスにはインターフェースが関連付けられていません。',

    'b_test' => 'テスト接続',

    'b_language_groups_add' => '信頼する言語のリストに言語グループを追加します。',
    'b_language_groups_del' => '信頼する言語のリストから言語グループを削除します。',
    'b_locale_groups_add' => '信頼するロケールのリストにロケールグループを追加します。',
    'b_locale_groups_del' => '信頼するロケールのリストからロケールグループを削除します。',
    'spam_trustednetworks_new' => '信頼するネットワークのリストにネットワークを追加します。',
    'spam_trustednetworks_remove' => '信頼するネットワークのリストからネットワークを削除します。',


    'i_i_client_on' => '顧客アカウントは有効です',
    'i_i_client_off_by_admin' => '顧客アカウントは管理者により無効になっています。',


    'b_virtualdir_add_disabled' => '仮想ディレクトリを作成できません',

    'b_db_add_disabled' => 'データベース サーバ接続設定が行われていません。[サーバ]->[データベース] ページから設定できます。',

    'b_databases__change_server_passwd_disabled' => "ポート 8306 で接続する設定になっているため、Plesk 内部のデータベースサーバを使用しています。そのため、［設定］>［パスワード変更］ページでパスワードを変更する必要があります。",

    'b_traffic_at_domains' => 'サーバ上の各ドメインのトラフィック統計を確認します。',
    'traffic_at_domains' => 'システム上にあるすべてのドメインのトラフィック統計',

    'b_rdp_session__open_new' => '新規ターミナルセッションをオープンします。',

    'removeDNS_acl' => '削除するには、チェックボックスを選択して削除を確認し、［OK］ボタンをクリックしてください。 ［キャンセル］をクリックすると、削除はキャンセルされます。',

    'i_additional_key_installed' => 'キーがアプリケーションにインストールされています。',
    'i_additional_key_not_installed' => 'キーがアプリケーションにインストールされていません',

    'b_unhandlederror_showinfo' => 'エラーの詳細情報を確認します。',
    'b_unhandlederror_hideinfo' => 'エラーの追加情報を隠します。',
    'b_unhandlederror_submitticket' => 'サポートサービスにエラーを報告します。',
    'unhandlederror' => '実行に失敗しました',

    'permissions' => 'ファイルまたはフォルダのパーミッションを設定します。',

    'permissions_advanced' => 'ファイルまたはフォルダの詳細なパーミッションをセットアップします。',

    'i_conn_strings_add' => '接続文字列を追加します。',
    'i_conn_strings_add_disabled' => '接続文字列の追加を現在利用できません',
    'i_conn_strings_del' => '接続文字列を削除します。',
    'i_conn_strings_del_disabled' => '接続文字列の削除を現在利用できません',

    'dns_acl_remove' => '削除するには、チェックボックスを選択して削除を確認し、［OK］ボタンをクリックしてください。 ［キャンセル］をクリックすると、削除はキャンセルされます。',

    'to_interface_management' => "インターフェース管理ページに戻る",
    't_locales' => "インターフェース言語を管理します。",
    't_skins' => "スキンを管理します。",
    't_interface_templates' => "インターフェーステンプレートを管理します。",
    'b_locale_make_default' => "言語パックを選択し、クリックしてデフォルト指定する",
    'b_skin_make_default' => "スキンを選択し、クリックしてデフォルト指定する",

    'wu_limits_exceeding' => "当該ドメインにおけるウェブユーザ数の上限に達したため、新規作成できません。",

    'mail_setenable_off' => '当該機能はメールサーバにおいてサポートされていません',
    'domain_aliases__status_ok' => 'ドメインエイリアスは正常に動作しています。',

    'i_htype_sub_hst' => 'サブフォルダ上のサブドメイン',
    'mail_antivirus' => 'アンチウイルス設定',

    'dom_new_no_clients' => 'ドメインを追加する前に、顧客アカウントを作成する必要があります。',

    'dns_t_acl' => 'アクセスコントロールリスト設定',

    'dns_t_acl_remove' => "削除するには、チェックボックスを選択して削除を確認し、［OK］ボタンをクリックしてください。 ［キャンセル］をクリックすると、削除はキャンセルされます。",

    'b_sapp_make_default' => "選択したウェブアプリケーションをデフォルト指定する",

    'b_ftp_ctrl' => "ドメインの追加 FTP アカウントを管理します。",
    'ftp_ctrl' => "ドメインの追加 FTP アカウントを管理します。",
    'b_ftp_user_add' => "FTP アカウントを追加します。",
    'b_ftp_users_limit_reached' => "FTP アカウントの上限数に達しました",
    'ftp_user_edit' => "FTP アカウント設定",
    'ftp_users' => "ドメインの追加 FTP アカウントを管理します。",
    'removeFtpUsers' => "削除するには、チェックボックスを選択して削除を確認し、［OK］ボタンをクリックしてください。 ［キャンセル］をクリックすると、削除はキャンセルされます。",
    'to_ftp_ctrl' => "FTP サブアカウント管理ページに戻る",

    'b_sb_desktop' => "Presence Builder の主要機能の概要",
    'b_sb_users' => "Presence Builder に登録されたユーザアカウントを管理します。",
    'b_sb_sites' => "各種 Presence Builder サイトを追加および管理します。",
    'b_sb_server' => "Presence Builder 管理",
    'b_sb_logs' => "Presence Builder システムおよびセキュリティログのレコードを表示します。",

    'dns_recursion' => "DNS 再帰問い合わせ管理",

    'subdom_hst_type_sel' => "サブドメイン用に設定するホスティングタイプを選択する",

    'i_wu_open_help' => "ブラウザ上でウェブユーザページを開きます。",

    'i_i_client_off_expired' => "この顧客アカウントの有効期間が終了しました",

    'i_antivirus_turn_install' => 'アンチウイルスソフトがインストールされていないか、正常に設定されていません',

    'b_ftp_users_no_permission' => "追加 FTP アカウントを管理するパーミッションがありません",

    // Plesk 8 keys

    'b_search' => "顧客、ドメイン、およびメールアカウントを検索します。",

    // services management
    'b_service_showall' => 'すべてのサービスを表示します。',
    'b_service_hideall' => "すべてのサービスを隠す。",
    'b_service_start' => "選択したサービスを起動する",
    'b_service_stop' => "選択したサービスを停止する",
    'b_service_restart' => "選択したサービスを再起動する",
    'b_service_disable' => "選択したサービスを無効にする",
    'b_service_manual' => "選択したサービスの手動起動タイプを選択する",
    'b_service_auto' => "選択したサービスの自動起動タイプを選択する",
    'i_serv_group_on' => 'グループにて動作しているすべてのサービス',
    'i_serv_group_none' => 'グループ内のいくつかのサービスは無効か停止しています。',
    'i_serv_group_off' => 'グループ内のすべてのサービスは無効か停止しています。',
    'i_serv_key_disabled' => 'サービスは無効です。',

    // php4v5
    'php' => "現在の仮想ディレクトリの PHP 設定を参照・変更する",
    'php_changeversion' => "現在の仮想ディレクトリにおける PHP 構成",
    'php_dom' => "ドメインの PHP 設定を変更する",
    'php_subdom' => "サブドメインの PHP 設定を変更する",
    'php_changeversion_dom' => "ドメイン用の PHP 構成",
    'php_changeversion_subdom' => "サブドメイン用の PHP 構成",

    // mass mail
    'b_new_mass_mail_template' => '一括メールメッセージテンプレートを追加します。',
    'b_massmail_send' => "選択した受信者にメールを送信",

    // Other
    'b_additional_key_is_install' => '追加キーをインストールする',
    'i_domain_sitebuilder_disabled' => "このドメインに対する Presence Builder サポートは無効です。",
    'i_subdomain_sitebuilder_disabled' => "このサブドメインに対する Presence Builder サポートは無効です。",
    'i_subdomain_sitebuilder_wizard' => "Presence Builder ウィザードでこのサブドメインを管理します。",
    'i_domain_sitebuilder_wizard' => "Presence Builder ウィザードでこのドメインを管理します。",
    'sitebuilder_page' => '現在、Presence Builder ウィンドウで作業しています。詳しくは Presence Builder マニュアルを参照してください。',
    'removeFpseUsers' => '削除するには、チェックボックスを選択して削除を確認し、［OK］ボタンをクリックしてください。 ［キャンセル］をクリックすると、削除はキャンセルされます。',
    'b_insert' => '選択したテンプレートから一括メールメッセージにデータを挿入します。',
    'i_spamfilter_turn_install' => 'スパムフィルタがインストールされていません',

    // help desk

    // 8.2

    // other

    'b_db_preferences' => 'データベース接続パラメータを変更する',
    'b_disabled_hosting' => '物理ホスティングが構成されていないため、この機能は使用できません',
    'net_apps' => 'ASP.NET 1.1 ウェブアプリケーションを管理',
    'site_apps' => "標準ウェブアプリケーションを管理",

    'b_default_cert' => '新たにホストするウェブサイトに安全に接続するために、選択した証明書を使用します。',
    'b_setup_cp' => '選択した証明書を使用して、Plesk への接続のセキュリティを強化する',
    'b_to_actionlog' => 'アクションログに戻る',

    // 8.3

    'additional_key_update' => '追加キーの更新または取得ステータス',
    'admin_alias_password_update' => 'パスワード変更の確認',
    'removeTasks' => "選択したタスクの削除を確認し、OK をクリックしてください。　",

    'b_license_key_remove' => 'ライセンスキーを削除します。',
    'fi-attach' => '接続したいグローバルアカウントを指定する',
    'fi-detach' => 'グローバルアカウントから現在のローカルアカウント接続解除を確認し、クリックして実行する',
    'fi-update' => 'グローバルアカウント設定のアップデート',

    // 8.4
    // RESELLERS
    'b_resellers' => 'リセラーアカウントを管理',
    'i_reseller_on' => "このユーザアカウントは有効です",
    'i_reseller_off_by_parent' => "このユーザアカウントはサービスプロバイダにより一時停止されました",
    'i_reseller_off_by_expired' => "このユーザアカウントの契約アイテムの期限が切れました",
    'i_reseller_off_backup_restore' => "このユーザアカウントは、データのバックアップまたは復元のために一時的に停止されました",
    'i_reseller_ok' => "リセラーのリソース使用量は制限内です",
    'i_reseller_cp_access_on' => "このリセラーは Plesk へのアクセスが許可されています。",
    'i_reseller_cp_access_off' => "このリセラーは Plesk へのアクセスが許可されていません。",
    'i_click_to_reseller_cp_access_on_off' => "リセラーの Plesk へのアクセスを許可または禁止します。",

    // CLIENTS (upgraded for resellers)

    // 'upgradeclients__submit_update' => 'Click',
    'b_upgradeClients__cancel_upgrade' => 'すべての変更を破棄して、前のページに戻ります。',
    'b_upgradeClients__submit_upgrade' => '適切な顧客アカウントをリセラーアカウントに変換します。',
    'b_upgradeDomainUser__cancel_upgrade' => 'すべての変更を破棄して、前のページに戻ります。',
    'b_upgradeDomainUser__submit_upgrade' => '適切なドメイン管理者アカウントを顧客アカウントに変換します。',

    //APS Catalog
    'b_hide_updates' => "アップデートを隠す",
    'b_show_updates' => "アップデートの表示",
    'b_add_to_vault' => "アプリケーションヴォルトに選択したアプリケーションを追加します。",

    // new and unsorted
    'b_to_server_interface' => "利用可能なスキンの一覧に戻る",
    'b_skin_edit' => "スキンの詳細を編集",
    'b_to_phosting_setup' => "ホスティング設定に戻る",
    // Hosting setup redesign
    'b_dom_hosting_update' => "ホスティング設定を保存する",
    'b_downgradeResellers__submit_downgrade' => "操作を完了します。",
    'b_rs_pool_add' => "リセラーに IP アドレスを割り当てる",
    'b_cl_pool_add' => "クライアントに IP アドレスを割り当てる",
    'b_ippoolManager__no_available_ips' => "IP プール内に空き IP アドレスがありません。",
    'b_ip_already_added_to_all_clients' => "この IP アドレスは、既にすべてのユーザの IP プール内に存在します。",

    // SERVER/SETTINGS
    'b_change_hostname_conhelp' => 'サーバホスト名を変更します。',
    'b_setup_firewall_conhelp' => 'サーバを保護するためファイアウォールを設定する',
    'b_setup_firewall_none_available_conhelp' => 'ファイアウォール機能が利用できません。ファイアウォールがインストールされていません',
    'b_manage_firewall_rules_conhelp' => 'ファイアウォールルールを作成、編集および削除する',
    'b_manage_firewall_rules_none_available_conhelp' => 'ファイアウォール機能が利用できません。ファイアウォールがインストールされていません',
    'b_select_dns_server_conhelp' => 'サーバで使用し、Plesk で管理する DNS サーバソフトウェアを選択します。',
    'b_select_dns_server_none_available_conhelp' => 'その他の DNS サーバが利用できません',
    'b_soa_records_template_conhelp' => 'ドメインの DNS ゾーンを作成する際にテンプレートとして使用される SOA レコードを構成します。',
    'b_dns_recursion_conhelp' => 'ドメインの DNS ゾーンを作成する際にテンプレートとして使用する DNS 再帰設定を構成します。',
    'b_restrict_creation_of_subzones_conhelp' => "他のユーザの DNS スーパーゾーンでの DNS サブゾーンの作成を制限する",
    'b_select_mailserver_conhelp' => 'サーバで使用し、Plesk で管理するメールサーバソフトウェアを選択します。',
    'b_select_mailserver_none_available_conhelp' => 'その他のメールサーバが利用できません',
    'b_select_antivirus_conhelp' => 'サーバで使用し、Plesk で管理するアンチウイルスソフトウェアを選択します。',
    'b_select_antivirus_none_available_conhelp' => 'その他のアンチウイルスプログラムはありません。',
    'b_virus_protection_settings_conhelp' => 'サーバ全体のウイルス防御設定を構成します。',
    'b_select_spamfilter_conhelp' => 'サーバで使用し、Plesk で管理するスパムフィルタリングソフトウェアを選択します。',
    'b_select_spamfilter_none_available_conhelp' => 'その他のスパム検出プログラムはありません。',
    'b_select_webmail_conhelp' => 'メールユーザに対して提供するウェブメールソフトウェアを選択します。',
    'b_select_webmail_none_available_conhelp' => 'その他のウェブメールプログラムは使用できません',
    'b_server_statistics_settings_conhelp' => 'サーバ全体の統計に含める計測値を選択する',
    'b_select_ssl_certificate_conhelp' => 'ドメインの保護に使用する SSL/TLS 証明書を選択します。',
    'b_select_ssl_certificate_none_available_conhelp' => 'ウェブホスティングはこの機能にアクセスするために必要です',
    'b_select_web_statistics_conhelp' => 'ドメイン所有者が使用可能とするウェブ統計ソフトウェアを選択します。',
    'b_select_web_statistics_none_available_conhelp' => 'その他のウェブ統計プログラムは使用できません',
    'b_interface_management_conhelp' => '各種 Plesk インターフェースオプションをセットアップします。',
    'b_setup_watchdog_conhelp' => 'Watchdog サーバモニタリングモジュールの設定',
    'b_setup_watchdog_none_available_conhelp' => 'Watchdog モジュールはインストールされていません',
    'b_setup_vpn_conhelp' => 'サーバの VPN アクセスを設定する',
    'b_setup_vpn_none_available_conhelp' => 'VPN アクセス拡張がインストールされていません。',
    'b_setup_samba_conhelp' => 'サーバの samba アクセスを設定する',
    'b_setup_samba_none_available_conhelp' => 'Samba アクセス拡張がインストールされていません。',

    // DOMAIN/SETTINGS
    'b_account_settings_conhelp' => 'アカウント設定の表示と変更',
    'b_dns_soa_records_conhelp' => 'ドメインの DNS SOA レコードを表示および変更する',
    'b_task_scheduler_settings_conhelp' => 'ドメインのタスクスケジューラを設定する',
    'b_task_scheduler_settings_none_available_conhelp' => 'ウェブホスティングはこの機能にアクセスするために必要です',
    'b_web_users_scripting_conhelp' => 'ウェブユーザによるスクリプトの使用を許可/禁止します。',
    'b_web_statistics_conhelp' => 'ドメインの訪問者数統計を表示する',
    'b_log_rotation_settings_conhelp' => 'ドメインのログローテーションを設定する',

    // navbar
    'b_mailnames' => 'メールアカウント一覧に移動する',
    'b_applications' => 'ウェブアプリケーション一覧に移動する',
    'b_settings' => '様々な設定を行う',

    // templates
    'i_tmpl__shared_template' => 'このテンプレートはホスティング事業者が作成したものです。事業者が共有設定している場合は使用できます。',
    'i_tmpl__owned_template' => 'このテンプレートはお客様ご自身で作成されたものです。許可された場合、お客様のユーザが使用することもできます。',

    'b_load' => '以前保存したテンプレートからメッセージを読み込む',

    'b_sh_ip_add' => '共有 IP アドレスの一覧に IP アドレスを追加',
    'b_sh_ip_del' => '共有 IP アドレスの一覧から IP アドレスを削除',
];