<?php
/**
 * Copyright 2010 Kolab Systems AG
 * Copyright 2010-2016 Horde LLC (http://www.horde.org/)
 *
 * See the enclosed file COPYING for license information (LGPL). If you did
 * not receive this file, see http://www.horde.org/licenses/lgpl21 LGPL.
 *
 * @category Horde
 * @package  Itip
 * @author   Gunnar Wrobel <wrobel@pardus.de>
 * @license  http://www.horde.org/licenses/lgpl21 LGPL
 * @link     http://pear.horde.org/index.php?package=Itip
 */

/**
 * Simple information provider for an invited resource.
 *
 * @category Horde
 * @package  Itip
 * @author   Gunnar Wrobel <wrobel@pardus.de>
 * @license  http://www.horde.org/licenses/lgpl21 LGPL
 * @link     http://pear.horde.org/index.php?package=Itip
 */
class Horde_Itip_Resource_Base implements Horde_Itip_Resource
{
    /**
     * The mail address.
     *
     * @var string
     */
    protected $_mail;

    /**
     * The common name.
     *
     * @var string
     */
    protected $_common_name;

    /**
     * Constructor.
     *
     * @param string $mail        The mail address.
     * @param string $common_name The common name.
     */
    public function __construct($mail, $common_name)
    {
        $this->_mail        = $mail;
        $this->_common_name = $common_name;
    }

    /**
     * Retrieve the mail address of the resource.
     *
     * @return string The mail address.
     */
    public function getMailAddress()
    {
        return $this->_mail;
    }

    /**
     * Retrieve the reply-to address for the resource.
     *
     * @return string The reply-to address.
     */
    public function getReplyTo()
    {
    }

    /**
     * Retrieve the common name of the resource.
     *
     * @return string The common name.
     */
    public function getCommonName()
    {
        return $this->_common_name;
    }

    /**
     * Retrieve the "From" address for this resource.
     *
     * @return string The "From" address.
     */
    public function getFrom()
    {
        return sprintf('%s <%s>', $this->_common_name, $this->_mail);
    }
}