<?php
// Copyright 1999-2022. Plesk International GmbH. All rights reserved.
// This file contains structured and commented locale keys for Plesk 9.x

global $PROD_NAME;

$GLOBALS['lmsg_arr'] += [
    ////
    //// LOGIN SCREEN
    ////

    'login_up__access_denied_account_disabled' => "Käyttö estetty.  Tilisi keskeytettiin.",
    'login_up__login_has_been_locked' => "Olet yrittänyt kirjautua sisään virheellisellä salasanalla liian monta kertaa. Turvallisuussyistä väliaikaisesti et voi kirjautua sisään tällä käyttäjätunnuksella.",
    'login_up__unable_to_check_pass' => "Salasanaa ei voi tarkistaa: %1",
    'login_up__warning_limits_licence_key' => "Jokin seuraavista kohteista on ylittänyt käyttöoikeusavaimesi määrittämän rajan: palvelimella isännöityjen käyttäjätilien, toimialueiden, sähköpostitilien tai verkkokäyttäjien määrän.\nOta yhteyttä Plesk-myyntiosastoon hankkiaksesi avaimen, joka sallii haluamasi käyttäjä- ja toimialuemäärän isännöimisen. Ota yhteyttä tekniseen Plesk-tukipalveluun, jos luulet saaneesi tämän viestin vahingossa.\nKäyttöoikeuden asettama käyttäjätilien/toimialueiden/sähköpostitilien/verkkokäyttäjien/kielipakettien raja: %2.\nNykyinen isännöityjen käyttäjätilien/toimialueiden/sähköpostitilien/verkkokäyttäjien/kielipakettien määrä: %3.", // PFW
    'login_up__short_warning_limits_licence_key' => "Käyttämäsi resurssimäärä on ylittänyt nykyisen tuotteen käyttöoikeutesi salliman maksimimäärän. Ota yhteyttä Pleskin myyntiosastoon ja hanki uusi käyttöoikeusavain.",
    'login_up__grace_period' => 'Toimit tällä hetkellä tuotelisenssisi voimassaoloajan puitteissa. Voit päivittää tuotelisenssisi valitsemalla Avainten haku -vaihtoehdon %1License Information page%2.',
    'login_up__partner_license_message' => 'Käytössäsi on tällä hetkellä rajoitettu tuotelisenssi, joka edellyttää rekisteröintiä ennen kaikkien ominaisuuksien aktivointia. Voit päivittää tuotelisenssisi valitsemalla Avainten haku -vaihtoehdon %1License Information page%2.',
    'login_up__system_admin_disabled' => 'Pääkäyttäjä (pääkäyttäjän tai järjestelmänvalvojan tili) ei saa kirjautua sisään Pleskiin turvallisuussyistä.',

    ///
    /// Online help keys:
    ///

    'plesk_guide' => "Plesk -järjestelmänvalvojan opas",
    'plesk_guide_reseller' => "Plesk -jälleenmyyjän opas",
    'plesk_guide_client' => "Plesk -asiakkaan opas",
    'plesk_guide_domain_admin' => "Plesk -toimialueen järjestelmänvalvojan opas",
    'plesk_guide_mailuser' => "Plesk -sähköpostikäyttäjän opas",

    ////
    //// COMMON KEYS FOR NAVIGATION THROUGHOUT PANEL
    ////

    ///
    /// NAVIGATION PANE
    ///

    'bt_search' => 'Etsi', // multiple usage: TBI
    'ui__client_unknown__quick-search' => 'Asiakkaat',
    'ui__reseller_unknown__quick-search' => 'Jälleenmyyjät',
    'ui__client/domain_unknown__quick-search' => 'Toimialueet',
    'nav__general' => 'Päävalikko',
    '__home' => 'Kotisivu',
    '__resellers' => 'Jälleenmyyjät',
    '__clients' => 'Asiakkaat',
    '__domains' => 'Toimialueet',
    '__applications' => 'Sovellukset',
    '__settings' => 'Asetukset',
    'nav__system' => 'Järjestelmä',
    '__master' => 'Perus',

    ///
    /// END OF NAVIGATION PANE
    ///

    ///
    /// NAVIGATION KEYS
    ///

    // up level
    'bt_up_level' => 'Taso ylös',

    // object switcher

    ///
    /// END OF NAVIGATION KEYS
    ///

    ///
    /// LISTS
    ///

    // common operations on list objects
    'bt_remove_selected' => 'Poista',
    'bt_make_default' => 'Aseta oletukseksi',

    // common list object operation errors
    'class_cList__empty_selection' => 'Objekteja ei ole valittu.',

    // common list object search keys
    'clist__search_show' => 'Näytä Etsi',
    'clist__search_hide' => 'Piilota hakutoiminto',

    'bt_show_all' => "Palauta haku",

    // common object list info keys
    'clist__first' => 'Ensimmäinen',
    'clist__last' => 'Viimeinen',
    'clist__prev' => '&lt;&lt;',
    'clist__next' => '&gt;&gt;',
    'clist__page' => 'Sivut',
    'clist__page_size' => 'Merkinnät sivua kohti',
    'clist__info' => 'Yhteensä %1: %4',
    'clist__info_empty' => 'Nro %1',
    'clist__info_filter' => '%5 %1 löytyi (yhteensä %4)',
    'clist__info_paging' => '%2-%3 %1 / %4',
    'clist__info_paging_filter' => '%2-%3 %1 / %5 löytyi (yhteensä %4)',

    ///
    /// END OF LISTS
    ///

    ////
    //// KEYS FOR USER HOME PAGES
    ////

    ///
    /// COMMON HOME PAGE KEYS
    ///

    // business object controls
    '__object_on' => 'Akt.',
    '__object_off' => 'Keskeytetty',

    '__home_description' => 'Takaisin kotisivulle.',
    'indicator_title' => '%1% käytetty, %2% vapaa', // tooltip for visual stats area

    ///
    /// END OF COMMON HOME PAGE KEYS
    ///

    ///
    /// SERVER ADMINISTRATOR
    ///

    '__invalid_url_requested' => 'Virheellistä URL-osoitetta pyydettiin.',

    // accounts
    // icons
    'ui__reseller_unknown__short-title' => "Jälleenmyyjätilit",
    'ui__reseller_unknown__title' => "Jälleenmyyjätilit",
    'ui__reseller_unknown__description' => "Hallitse jälleenmyyjätilejä.",
    'ui__reseller/client_unknown__short-title' => 'Asiakastilit',
    'ui__reseller/client_unknown__title' => 'Asiakastilit',
    'ui__reseller/client_unknown__description' => 'Hallitse käyttäjätilejä.',
    // dropdowns
    'ui__reseller/client/chowner_multi-select__title' => 'Määritä asiakastileille uusi omistaja',
    'ui__reseller/client/chowner_multi-select__short-title' => 'Määritä uusi omistaja',
    'ui__reseller/client/chowner_multi-select__description' => 'Määritä valituille asiakastileille uusi omistaja.',
    'ui__client/to-reseller_multi__title' => 'Muunna asiakastilit jälleenmyyjätileiksi',
    'ui__client/to-reseller_multi__short-title' => 'Muuta jälleenmyyjiksi',
    'ui__client/to-reseller_multi__description' => 'Muuta valitut asiakastilit jälleenmyyjän tileiksi.',
    'ui__reseller/to-client_multi__title' => 'Muunna jälleenmyyjätilit asiakastileiksi',
    'ui__reseller/to-client_multi__short-title' => 'Muunna asiakkaiksi',
    'ui__reseller/to-client_multi__description' => 'Muuta valitut jälleenmyyjän tilit asiakastileiksi',
    'ui__admin-alias_unknown__title' => "Muut järjestelmänvalvojatilit", // PFW
    'ui__admin-alias_unknown__short-title' => "Muut järjestelmänvalvojatilit", // PFW
    'ui__admin-alias_unknown__description' => "Näytä ja hallitse ylimääräisiä järjestelmänvalvojan tilejä.", // PFW

    // server
    // icons
    'ui__server/mail__short-title' => "Postipalvelimen asetukset",
    'ui__server/mail__title' => "Postipalvelimen asetukset",
    'ui__server/mail__description' => "Aseta sähköpostipalvelin ja määritä palvelimen laajuiset sähköpostiasetukset.",
    'ui__server/dns__short-title' => 'DNS-asetukset',
    'ui__server/dns__title' => 'DNS-asetukset',
    'ui__server/dns__description' => 'Tarkista ja päivitä palvelimenlaajuiset DNS-asetukset.',
    'ui__server/components__short-title' => 'Palvelinkomponentit',
    'ui__server/components__title' => 'Palvelinkomponentit',
    'ui__server/components__description' => 'Näytä tietoa palvelimeen asennetuista ja Pleskin käyttämistä järjestelmäkomponenteista.',
    'ui__server/services__short-title' => 'Palveluiden hallinta',
    'ui__server/services__title' => 'Palveluiden hallinta',
    'ui__server/services__description' => 'Käynnistä, pysäytä tai käynnistä uudelleen Plesk -palvelut.',
    'ui__server/crontab/task_unknown__short-title' => 'Ajoitetut tehtävät',
    'ui__server/crontab/task_unknown__title' => 'Ajoitetut tehtävät',
    'ui__server/crontab/task_unknown__description' => 'Lisää tai poista palvelimen laajuiset aikataulutetut tehtävät.',
    'ui__server/ip-address_unknown__short-title' => 'IP-osoitteet',
    'ui__server/ip-address_unknown__title' => 'IP-osoitteet',
    'ui__server/ip-address_unknown__description' => 'Näytä, lisää ja poista IP-osoitteita ja määritä IP-osoitteet jälleenmyyjille.',
    'ui__promotion/smartermail__short-title' => 'Lataa SmarterMail',
    'ui__promotion/smartermail__title' => 'Lataa SmarterMail',
    'ui__promotion/smartermail__description' => 'Avaa uudessa ikkunassa SmarterMail-verkkosivusto, jossa voit ladata SmarterMail-sähköpostipalvelimen uusimman version. SmarterMail-verkkosivuston tuotannosta ja tuesta vastaa SmarterTools Inc. Plesk ei ota vastuuta SmarterMail-verkkosivuston sisällöstä, eikä se myöskään tarjoa tukea SmarterMail Lite -sähköpostipalvelimelle.',
    // dropdowns
    'ui__server/time__title' => 'Järjestelmän kellonaika',
    'ui__server/time__short-title' => 'Järjestelmän kellonaika',
    'ui__server/time__description' => 'Muuta järjestelmän päivämäärää ja aikaa, aseta synkronointi NTP-palvelimella.',
    'ui__server/odbc__title' => 'ODBC-tietolähteet', // PFW
    'ui__server/odbc__short-title' => 'ODBC-tietolähteet', // PFW
    'ui__server/odbc__description' => 'Määritä ODBC-tietolähteet.', // PFW
    'ui__server/ftp-settings__short-title' => "FTP-asetukset", // PFW
    'ui__server/ftp-settings__title' => "FTP-asetukset", // PFW
    'ui__server/ftp-settings__description' => "Määritä palvelimen laajuiset FTP-asetukset.", // PFW
    'ui__server/maillists__title' => 'Aseta postituslistapalvelin', // PFU
    'ui__server/maillists__short-title' => 'Aseta postituslistapalvelin', // PFU
    'ui__server/maillists__description' => 'Aseta Mailman-postituslistapalvelin.', // PFU
    'ui__mass-email__short-title' => "Massasähköpostiviestit", // PFW
    'ui__mass-email__title' => "Massasähköpostiviestit", // PFW
    'ui__mass-email__description' => "Lähetä sähköpostiviestejä usealle käyttäjälle samanaikaisesti.", // PFW
    'ui__mass-mail__title' => 'Massasähköpostiviestit', // PFU
    'ui__mass-mail__short-title' => 'Massasähköpostiviestit', // PFU
    'ui__mass-mail__description' => 'Lähetä sähköpostiviestejä usealle käyttäjälle samanaikaisesti.', // PFU
    'ui__server/spam-filter__title' => 'Roskapostisuodattimen asetukset',
    'ui__server/spam-filter__short-title' => 'Roskapostisuodattimen asetukset',
    'ui__server/spam-filter__description' => 'Aseta palvelimenlaajuinen roskapostisuodatin.',
    'ui__server/preferences__title' => "Palvelimen asetukset",
    'ui__server/preferences__short-title' => "Palvelimen asetukset",
    'ui__server/preferences__description' => "Aseta palvelimen laajuisten tilastotietojen laskenta, muuta palvelimen isännän nimeä ja muuta muita palvelinasetuksia.",

    // help & support
    // icons
    'ui__support__short-title' => 'Tuki',
    'ui__support__title' => 'Tuki',
    'ui__support__description' => 'Lähetä pyyntö tekniseen tukeen tai tarkista asiakkaidesi tekemät tukipyynnöt.',
    'ui__license__short-title' => 'Lisenssin tiedot',
    'ui__license__title' => 'Plesk-lisenssin tiedot',
    'ui__license__description' => 'Näytä tietoa Plesk -käyttöoikeudestasi ja tilaa uudet käyttöoikeusavaimet.',
    'ui__help__short-title' => 'Ohje',
    'ui__help__title' => 'Online-ohje',
    'ui__help__description' => 'Näytä online-ohje.',
    'ui__news__short-title' => "Uutuudet",
    'ui__news__title' => "Uutuudet",
    'ui__news__description' => "Katso tämän Plesk -version muutosluettelo.",
    'ui__server/autoinstaller__short-title' => 'Paivitykset',
    'ui__server/autoinstaller__title' => 'Paivitykset',
    'ui__server/autoinstaller__description' => 'Päivitä Plesk ja sen komponentit.',
    // dropdowns

    // domains
    // icons
    'ui__client/domain_unknown__short-title' => 'Toimialueet',
    'ui__client/domain_unknown__title' => 'Toimialueet',
    'ui__client/domain_unknown__description' => 'Hallitse toimialueita.',
    'ui__server/skeleton__short-title' => 'Virtuaalisen isännän malli',
    'ui__server/skeleton__title' => 'Virtuaalisen isännän malli',
    'ui__server/skeleton__description' => 'Määritä tiedostot ja kansiot, jotka haluat sijoittaa juuri perustettujen toimialueiden hakemistoihin.',
    // dropdowns
    'ui__client/domain/properties_unknown-new__title' => 'Luo arvoalue',
    'ui__client/domain/properties_unknown-new__short-title' => 'Luo arvoalue',
    'ui__client/domain/properties_unknown-new__description' => 'Luo ja määritä toimialue.',
    'ui__client/domain/chowner_multi-select__title' => 'Määritä tilauksille uusi omistaja',
    'ui__client/domain/chowner_multi-select__short-title' => 'Määritä uusi tilauksen omistaja',
    'ui__client/domain/chowner_multi-select__description' => 'Määritä valituille tilauksille uusi omistaja',
    'ui__client/domain/to-client_multi__title' => 'Muunna toimialueen järjestelmänvalvojan tilit asiakastileiksi',
    'ui__client/domain/to-client_multi__short-title' => 'Muunna asiakkaiksi',
    'ui__client/domain/to-client_multi__description' => 'Muuta valitut toimialueen järjestelmänvalvojan tilit asiakastileiksi',
    'ui__client/domain/disable_multi__title' => 'Peruuta toimialueet',
    'ui__client/domain/disable_multi__short-title' => 'Peruuta toimialueet',
    'ui__client/domain/disable_multi__description' => 'Keskeytä valitut toimialueet',
    'ui__client/domain/enable_multi__title' => 'Aktivoi toimialueet',
    'ui__client/domain/enable_multi__short-title' => 'Aktivoi toimialueet',
    'ui__client/domain/enable_multi__description' => 'Aktivoi valitut toimialueet',

    // icons
    'ui__admin/extras-domain__short-title' => 'Työkalut MyPlesk.com-sivulta',
    'ui__admin/extras-domain__title' => 'Työkalut MyPlesk.com-sivulta',
    'ui__admin/extras-domain__description' => 'Hae lisätyökaluja ja -palveluja osoitteesta MyPlesk.com.',
    'ui__server/aspdotnet__short-title' => 'ASP.NET-asetukset', // PFW
    'ui__server/aspdotnet__title' => 'ASP.NET-asetukset', // PFW
    'ui__server/aspdotnet__description' => 'Määritä palvelimen laajuiset ASP.NET-asetukset.', // PFW
    'ui__server/sitebuilder__short-title' => 'Presence Builderin asetukset', // PFU
    'ui__server/sitebuilder__title' => 'Presence Builderin asetukset', // PFU
    'ui__server/sitebuilder__description' => 'Aseta Presence Builder tällä palvelimella isännöityjen verkkosivustojen muokkaamiseksi.', // PFU
    // dropdowns
    'ui__admin/register-domain__title' => 'Rekisteröi toimialue',
    'ui__admin/register-domain__short-title' => 'Rekisteröi toimialue',
    'ui__admin/register-domain__description' => 'Rekisteröi toimialueen nimi MyPlesk.com-sivun avulla.',
    'ui__admin/manage-domain__title' => 'Hallitse toimialuetta',
    'ui__admin/manage-domain__short-title' => 'Hallitse toimialuetta',
    'ui__admin/manage-domain__description' => 'Hallitse rekisteröityjä toimialueen nimiä MyPlesk.com-sivun avulla.',
    'ui__server/register__title' => 'Rekisteröi palvelimesi',
    'ui__server/register__short-title' => 'Rekisteröi palvelin',
    'ui__server/register__description' => 'Rekisteröi palvelin konserniyhtiön ohjelmaan',

    // logs & statistics
    // icons
    'ui__actionlog__short-title' => 'Toimintoloki',
    'ui__actionlog__title' => 'Toimintoloki',
    'ui__actionlog__description' => 'Lataa tehtäväloki ja hallitse tehtävälokien asetuksia.',
    'ui__notification_unknown__short-title' => 'Ilmoitukset',
    'ui__notification_unknown__title' => 'Ilmoitukset',
    'ui__notification_unknown__description' => 'Näytä tärkeiden Plesk -tapahtumien ilmoitukset ja muokkaa niitä.',
    'ui__server/resources__short-title' => 'Resurssien käyttö',
    'ui__server/resources__title' => 'Resurssien käyttö',
    'ui__server/resources__description' => 'Näytä järjestelmän resurssien käyttö.',
    // dropdowns
    'ui__server/statistics__short-title' => 'Palvelimen tiedot',
    'ui__server/statistics__title' => 'Palvelimen tiedot',
    'ui__server/statistics__description' => 'Pleskin hallitsemien palvelujen tilastotiedot.',
    'ui__admin/report__title' => 'Yhteenvetoraportti',
    'ui__admin/report__short-title' => 'Yhteenvetoraportti',
    'ui__admin/report__description' => 'Näytä raportti jälleenmyyjien, asiakkaiden ja toimialueiden liikenteen ja resurssien käytöstä.',

    // security
    // icons
    'ui__sessions/properties__short-title' => 'Istunnon käyttämättömänäoloaika',
    'ui__sessions/properties__title' => 'Istunnon käyttämättömänäoloaika',
    'ui__sessions/properties__description' => 'Aseta istunnon käyttämätön aika Plesk -istunnoille.',
    'ui__cp-access__short-title' => 'Pleskin käyttöoikeus',
    'ui__cp-access__title' => 'Pleskin käyttöoikeus',
    'ui__cp-access__description' => 'Rajoita Pleskin käyttöä.',
    'ui__sessions__short-title' => 'Aktiiviset istunnot',
    'ui__sessions__title' => 'Aktiiviset istunnot',
    'ui__sessions__description' => 'Näytä aktiiviset Plesk -istunnot.',
    // dropdowns
    'ui__server/certificate_unknown__title' => 'SSL/TLS-varmenteet',
    'ui__server/certificate_unknown__short-title' => 'SSL/TLS-varmenteet',
    'ui__server/certificate_unknown__description' => 'SSL/TLS-varmenteiden luettelo.',

    // account
    // icons
    'ui__admin-info__short-title' => 'Henkilötiedot',
    'ui__admin-info__title' => 'Henkilötiedot',
    'ui__admin-info__description' => 'Muuta tilisi henkilökohtaiset tiedot.',
    'ui__admin-password__short-title' => 'Muuta salasana',
    'ui__admin-password__title' => 'Muuta salasana',
    'ui__admin-password__description' => 'Vaihda tilisi salasanaa.',
    'ui__admin/interface__short-title' => 'Liittymämääritykset',
    'ui__admin/interface__title' => 'Järjestelmänvalvojan liittymän omat asetukset',
    'ui__admin/interface__description' => 'Muuta palvelimen järjestelmänvalvojan liittymän asetuksia.',
    // dropdowns

    ///
    /// END OF SERVER ADMINISTRATOR
    ///

    ///
    /// RESELLER
    ///

    // business objects

    // files
    // icons
    'ui__client/domain/hosting/file-manager_unknown__short-title' => 'Tiedostonhallinta',
    'ui__client/domain/hosting/file-manager_unknown__title' => 'Tiedostonhallinta',
    'ui__client/domain/hosting/file-manager_unknown__description' => 'Työskentele tiedostojen ja hakemistojen kanssa tiedostonhallinnan kautta.',
    'ui__client/domain/hosting/ssh-terminal_unknown__short-title' => 'SSH-pääte', // PFU
    'ui__client/domain/hosting/ssh-terminal_unknown__title' => 'SSH-pääte', // PFU
    'ui__client/domain/hosting/ssh-terminal_unknown__description' => 'Käytä SSH-päätettä käyttääksesi palvelinta.', // PFU
    'ui__client/domain/hosting/protected-directories_unknown__short-title' => 'Salasanasuojatut hakemistot',
    'ui__client/domain/hosting/protected-directories_unknown__title' => 'Salasanasuojatut hakemistot',
    'ui__client/domain/hosting/protected-directories_unknown__description' => 'Suojaa valittujen verkkosivustoalueiden käyttö.',
    'ui__client/domain/hosting/virtual-directories_unknown__short-title' => 'Näennäiskansiot', // PFW
    'ui__client/domain/hosting/virtual-directories_unknown__title' => 'Näennäiskansiot', // PFW
    'ui__client/domain/hosting/virtual-directories_unknown__description' => 'Luo ja hallitse toimialueen näennäishakemistoja.', // PFW
    'ui__client/domain/hosting/web-directories_unknown__title' => 'Näennäiskansiot', // PFW
    'ui__client/domain/hosting/web-directories_unknown__short-title' => 'Näennäiskansiot', // PFW
    'ui__client/domain/hosting/web-directories_unknown__description' => 'Käytä fyysisiä ja näennäistiedostoja sekä -hakemistoja verkkosivustolla.', // PFW

    // statistics
    // icons
    'ui__client/domain/report/web-stats_unknown__short-title' => 'Verkkosivuston tilastot',
    'ui__client/domain/report/web-stats_unknown__title' => 'Verkkosivuston tilastot',
    'ui__client/domain/report/web-stats_unknown__description' => 'Näytä verkkosivuston vierailutilastot.',
    'ui__reseller/limits__short-title' => 'Resurssien käyttö',
    'ui__reseller/limits__title' => 'Resurssien käyttö',
    'ui__reseller/limits__description' => 'Näytä jälleenmyyjän %1 resurssin käyttö ja hallitse sitä.',
    'ui__reseller/limits_unknown__short-title' => 'Resurssien käyttö',
    'ui__reseller/limits_unknown__title' => 'Resurssien käyttö',
    'ui__reseller/limits_unknown__description' => 'Näytä jälleenmyyjän resurssin käyttö ja hallitse sitä.',
    'ui__reseller/limits_self__short-title' => 'Resurssien käyttö',
    'ui__reseller/limits_self__title' => 'Resurssien käyttö',
    'ui__reseller/limits_self__description' => "Tarkastele ja hallitse resurssien käyttöä.",
    'ui__reseller/limits_readonly-self__short-title' => 'Resurssien käyttö',
    'ui__reseller/limits_readonly-self__title' => 'Resurssien käyttö',
    'ui__reseller/limits_readonly-self__description' => "Näytä resurssien käyttö.",
    'ui__reseller/client/traffic_unknown__short-title' => 'Asiakkaiden liikenteen kuormitus',
    'ui__reseller/client/traffic_unknown__title' => 'Näytä asiakkaiden liikenteen kuormitus',
    'ui__reseller/client/traffic_unknown__description' => 'Näytä asiakastilien liikenteen kuormitusraportit.',
    'ui__client/traffic_unknown__short-title' => "Asiakkaiden liikenteen kuormitus", // temporary for presets
    'ui__client/traffic_unknown__title' => "Näytä asiakkaiden liikenteen kuormitus", // temporary for presets
    'ui__client/traffic_unknown__description' => "Näytä asiakastilien liikenteen kuormitusraportit.", //  temporary for presets
    'ui__client/domain/hosting/logs_unknown__short-title' => 'Lokinhallinta',
    'ui__client/domain/hosting/logs_unknown__title' => 'Lokinhallinta',
    'ui__client/domain/hosting/logs_unknown__description' => 'Näytä lokit ja määritä lokikierto.',
    // dropdowns
    'ui__reseller/report__title' => 'Yhteenvetoraportti',
    'ui__reseller/report__short-title' => 'Yhteenvetoraportti',
    'ui__reseller/report__description' => 'Näytä raportti tämän jälleenmyyjän liikenteen ja resurssien käytöstä.',
    'ui__reseller/report_unknown__title' => 'Yhteenvetoraportti',
    'ui__reseller/report_unknown__short-title' => 'Yhteenvetoraportti',
    'ui__reseller/report_unknown__description' => 'Näytä raportti jälleenmyyjän liikenteen ja resurssien käytöstä.',
    'ui__reseller/report_self__title' => 'Yhteenvetoraportti',
    'ui__reseller/report_self__short-title' => 'Yhteenvetoraportti',
    'ui__reseller/report_self__description' => 'Näytä raportti liikenteen ja resurssien käytöstäsi.',

    // account
    // icons
    'ui__client/logo_reseller__title' => 'Pleskin tuotemukautus',
    'ui__client/logo_reseller__short-title' => 'Pleskin tuotemukautus',
    'ui__client/logo_reseller__description' => 'Määritä jälleenmyyjän %1 Pleskin uusi tuotemukautus.',
    'ui__client/logo_unknown__title' => 'Pleskin tuotemukautus', // temporary for presets
    'ui__client/logo_unknown__short-title' => 'Pleskin tuotemukautus', // temporary for presets
    'ui__client/logo_unknown__description' => 'Määritä Pleskin tuotemukautus.', // temporary for presets
    'ui__client/logo_self-reseller__title' => 'Pleskin tuotemukautus',
    'ui__client/logo_self-reseller__short-title' => 'Pleskin tuotemukautus',
    'ui__client/logo_self-reseller__description' => 'Määritä Pleskisi tuotemukautus.',
    'ui__reseller/permissions__title' => 'Käyttöoikeudet',
    'ui__reseller/permissions__short-title' => 'Käyttöoikeudet',
    'ui__reseller/permissions__description' => "Näytä jälleenmyyjän %1 saatavilla olevat Plesk -toiminnot tai muuta niitä.",
    'ui__reseller/permissions_unknown__short-title' => 'Käyttöoikeudet',
    'ui__reseller/permissions_unknown__title' => 'Käyttöoikeudet',
    'ui__reseller/permissions_unknown__description' => "Näytä jälleenmyyjän saatavilla olevat Plesk -toiminnot tai muuta niitä.",
    'ui__reseller/permissions_self__title' => 'Käyttöoikeudet',
    'ui__reseller/permissions_self__short-title' => 'Käyttöoikeudet',
    'ui__reseller/permissions_self__description' => 'Näytä Pleskissa suoritettavissa olevien toimintojen luettelo.',
    'ui__reseller/permissions_readonly-self__title' => 'Käyttöoikeudet',
    'ui__reseller/permissions_readonly-self__short-title' => 'Käyttöoikeudet',
    'ui__reseller/permissions_readonly-self__description' => 'Näytä Pleskissa suoritettavissa olevien toimintojen luettelo.',
    // dropdowns
    'ui__reseller/to-client__title' => 'Muunna jälleenmyyjätili asiakastiliksi',
    'ui__reseller/to-client__short-title' => 'Muunna jälleenmyyjä asiakkaaksi',
    'ui__reseller/to-client__description' => 'Muuta tämä jälleenmyyjän tili asiakastiliksi.',
    'ui__reseller/to-client_unknown__title' => 'Muunna jälleenmyyjätili asiakastiliksi',
    'ui__reseller/to-client_unknown__short-title' => 'Muunna jälleenmyyjä asiakkaaksi',
    'ui__reseller/to-client_unknown__description' => 'Muuta jälleenmyyjän tili asiakastiliksi.',

    // domains
    // icons
    // Domains - see SERVER ADMINISTRATOR/DOMAINS
    // Domain Templates - see SERVER ADMINISTRATOR/DOMAINS
    'ui__client/skeleton__title' => 'Virtuaalisen isännän malli',
    'ui__client/skeleton__short-title' => 'Virtuaalisen isännän malli',
    'ui__client/skeleton__description' => 'Määritä tiedostot ja kansiot, jotka haluat sijoittaa juuri perustettujen toimialueiden hakemistoihin.',
    'ui__client/skeleton_unknown__short-title' => 'Virtuaalisen isännän malli',
    'ui__client/skeleton_unknown__title' => 'Virtuaalisen isännän malli',
    'ui__client/skeleton_unknown__description' => 'Määritä tiedostot ja kansiot, jotka haluat sijoittaa juuri perustettujen toimialueiden hakemistoihin.',
    // dropdowns
    'ui__client/domain/properties_new__title' => 'Luo arvoalue',
    'ui__client/domain/properties_new__short-title' => 'Luo arvoalue',
    'ui__client/domain/properties_new__description' => "Luo toimialue kohteelle %1.",
    // Assign new owner for domains - see SERVER ADMINISTRATOR/DOMAINS
    // Convert domain administrator accounts to customer accounts - see SERVER ADMINISTRATOR/DOMAINS
    // Update Properties of Multiple Domains - see SERVER ADMINISTRATOR/DOMAINS
    // Suspend domains - see SERVER ADMINISTRATOR/DOMAINS
    // Activate domains - see SERVER ADMINISTRATOR/DOMAINS

    // website
    // icons
    'ui__client/domain/domain-alias_unknown__short-title' => 'Toimialueen aliakset',
    'ui__client/domain/domain-alias_unknown__title' => 'Toimialueen aliakset',
    'ui__client/domain/domain-alias_unknown__description' => 'Näytä toimialueesi vaihtoehtoisten nimien luettelo.',
    //dropdowns
    'ui__client/domain/dns_unknown__title' => 'DNS-asetukset',
    'ui__client/domain/dns_unknown__short-title' => 'DNS-asetukset',
    'ui__client/domain/dns_unknown__description' => 'Hallitse toimialueen DNS-vyöhykeasetuksia.',
    'ui__client/domain/dns_readonly-unknown__title' => 'DNS-asetukset',
    'ui__client/domain/dns_readonly-unknown__short-title' => 'DNS-asetukset',
    'ui__client/domain/dns_readonly-unknown__description' => 'Näytä toimialueen DNS-vyöhykeasetukset.',

    // applications & services
    // icons
    'ui__reseller/extras-domain__short-title' => 'Työkalut MyPlesk.com-sivulta',
    'ui__reseller/extras-domain__title' => 'Työkalut MyPlesk.com-sivulta',
    'ui__reseller/extras-domain__description' => 'Hae lisätyökaluja ja -palveluja osoitteesta MyPlesk.com.',
    'ui__reseller/extras-domain_unknown__short-title' => 'Työkalut MyPlesk.com-sivulta',
    'ui__reseller/extras-domain_unknown__title' => 'Työkalut MyPlesk.com-sivulta',
    'ui__reseller/extras-domain_unknown__description' => 'Hae lisätyökaluja ja -palveluja osoitteesta MyPlesk.com.',
    'ui__reseller/extras-domain_self__short-title' => 'Työkalut MyPlesk.com-sivulta',
    'ui__reseller/extras-domain_self__title' => 'Työkalut MyPlesk.com-sivulta',
    'ui__reseller/extras-domain_self__description' => 'Hae lisätyökaluja ja -palveluja osoitteesta MyPlesk.com.',
    'ui__client/domain/odbc_unknown__short-title' => 'ODBC-tietolähteet', // PFW
    'ui__client/domain/odbc_unknown__title' => 'ODBC-tietolähteet', // PFW
    'ui__client/domain/odbc_unknown__description' => 'Aseta ODBC-tietolähteet toimialueeseen.', // PFW
    'ui__reseller/register-domain__short-title' => 'Rekisteröi toimialue',
    'ui__reseller/register-domain__title' => 'Rekisteröi toimialue',
    'ui__reseller/register-domain__description' => 'Rekisteröi toimialueen nimi MyPlesk.com-sivun avulla.',
    'ui__reseller/register-domain_unknown__short-title' => 'Rekisteröi toimialue',
    'ui__reseller/register-domain_unknown__title' => 'Rekisteröi toimialue',
    'ui__reseller/register-domain_unknown__description' => 'Rekisteröi toimialueen nimi MyPlesk.com-sivun avulla.',
    'ui__reseller/register-domain_self__short-title' => 'Rekisteröi toimialue',
    'ui__reseller/register-domain_self__title' => 'Rekisteröi toimialue',
    'ui__reseller/register-domain_self__description' => 'Rekisteröi toimialueen nimi MyPlesk.com-sivun avulla.',
    // dropdowns
    'ui__reseller/manage-domain__title' => 'Hallitse toimialuetta',
    'ui__reseller/manage-domain__short-title' => 'Hallitse toimialuetta',
    'ui__reseller/manage-domain__description' => 'Hallitse rekisteröityjä toimialueen nimiä MyPlesk.com-sivun avulla.',
    'ui__reseller/manage-domain_unknown__title' => 'Hallitse toimialuetta',
    'ui__reseller/manage-domain_unknown__short-title' => 'Hallitse toimialuetta',
    'ui__reseller/manage-domain_unknown__description' => 'Hallitse rekisteröityjä toimialueen nimiä MyPlesk.com-sivun avulla.',
    'ui__reseller/manage-domain_self__title' => 'Hallitse toimialuetta',
    'ui__reseller/manage-domain_self__short-title' => 'Hallitse toimialuetta',
    'ui__reseller/manage-domain_self__description' => 'Hallitse rekisteröityjä toimialueen nimiä MyPlesk.com-sivun avulla.',

    // additional tools
    // icons
    'ui__client/ipaddress_unknown-reseller__title' => 'IP-osoitteet',
    'ui__client/ipaddress_unknown-reseller__short-title' => 'IP-osoitteet',
    'ui__client/ipaddress_unknown-reseller__description' => 'Hallitse IP-osoitteita.',
    'ui__client/domain/certificate_unknown__short-title' => 'SSL/TLS-varmenteet',
    'ui__client/domain/certificate_unknown__title' => 'SSL/TLS-varmenteet',
    'ui__client/domain/certificate_unknown__description' => 'Asenna ja hallitse SSL/TLS-varmenteita.',
    'ui__client/domain/hosting/hotlink-protection_unknown__short-title' => 'Pikalinkkisuojaus', // PFW
    'ui__client/domain/hosting/hotlink-protection_unknown__title' => 'Pikalinkkisuojaus', // PFW
    'ui__client/domain/hosting/hotlink-protection_unknown__description' => 'Suojaa tiedostosi suoralinkitykseltä.', // PFW
    'ui__reseller/sessions__short-title' => 'Aktiiviset istunnot',
    'ui__reseller/sessions__title' => 'Aktiiviset istunnot',
    'ui__reseller/sessions__description' => 'Näytä aktiiviset Plesk -istunnot.',
    'ui__reseller/sessions_unknown__short-title' => 'Aktiiviset istunnot',
    'ui__reseller/sessions_unknown__title' => 'Aktiiviset istunnot',
    'ui__reseller/sessions_unknown__description' => 'Näytä aktiiviset Plesk -istunnot.',
    'ui__reseller/sessions_self__short-title' => 'Aktiiviset istunnot',
    'ui__reseller/sessions_self__title' => 'Aktiiviset istunnot',
    'ui__reseller/sessions_self__description' => 'Näytä aktiiviset Plesk -istunnot.',
    'ui__client/domain/hosting/performance_unknown__short-title' => 'Kaistanleveysrajoitus',
    'ui__client/domain/hosting/performance_unknown__title' => 'Kaistanleveysrajoitus',
    'ui__client/domain/hosting/performance_unknown__description' => 'Näytä ja säädä kaistanleveyden käyttöraja sekä verkkosivuston samanaikaisten yhteyksien määrä.',
    'ui__client/domain/hosting/performance_readonly-unknown__short-title' => 'Kaistanleveysrajoitus',
    'ui__client/domain/hosting/performance_readonly-unknown__title' => 'Kaistanleveysrajoitus',
    'ui__client/domain/hosting/performance_readonly-unknown__description' => 'Näytä kaistanleveyden käyttöraja sekä verkkosivuston samanaikaisten yhteyksien määrä.',
    'ui__client/domain/hosting/php_unknown__short-title' => 'PHP-asetukset', // PFW
    'ui__client/domain/hosting/php_unknown__title' => 'PHP-asetukset', // PFW
    'ui__client/domain/hosting/php_unknown__description' => 'Määritä PHP toimialueeseen.', // PFW

    ///
    /// END OF RESELLER
    ///

    ///
    /// CLIENT
    ///

    // business objects
    'mn_list__mail_names_for_client' => 'Käyttäjätilin %1 sähköpostitilit',

    // domains
    // icons
    // Domains - SERVER ADMINISTRATOR/DOMAINS
    // Domain Templates - SERVER ADMINISTRATOR/DOMAINS
    // Virtual host template - RESELLER/DOMAINS
    'ui__client/skeleton_self__short-title' => 'Virtuaalisen isännän malli',
    'ui__client/skeleton_self__title' => 'Virtuaalisen isännän malli',
    'ui__client/skeleton_self__description' => 'Määritä tiedostot ja kansiot, jotka haluat sijoittaa juuri perustettujen toimialueiden hakemistoihin.',
    // dropdowns
    // Create domain - see RESELLER/DOMAINS
    // Create domain template - see RESELLER/DOMAINS
    // Assign new owner for domains - see SERVER ADMINISTRATOR/DOMAINS
    // Convert Domain Administrator Accounts to Client Accounts - see SERVER ADMINISTRATOR/DOMAINS
    // Update Properties of Multiple Domains - see SERVER ADMINISTRATOR/DOMAINS

    // Suspend domains - see SERVER ADMINISTRATOR/DOMAINS
    // Activate domains - see SERVER ADMINISTRATOR/DOMAINS

    // mail
    // icons
    // Mail accounts - RESELLER/MAIL
    // Create mail account - RESELLER/MAIL
    // Create forwarder - RESELLER/MAIL
    // Create autoresponder - RESELLER/MAIL
    // Mailing lists - RESELLER/MAIL
    // Virus protection - RESELLER/MAIL
    // Spam filtering - RESELLER/MAIL
    // Open Webmail - RESELLER/MAIL
    // dropdowns
    // Mail settings - RESELLER/MAIL
    //Create mailing list - RESELLER/MAIL

    // files
    // icons
    // File manager - RESELLER/FILES
    // Anonymous FTP - RESELLER/FILES
    // FTP accounts - RESELLER/FILES    // PFW
    // SSH terminal - RESELLER/FILES    // PFU
    // Password protected directories - RESELLER/FILES
    // Virtual directories - RESELLER/FILES    // PFW
    // Web directories - RESELLER/FILES    // PFW

    // statistics
    // icons
    // Web statistics - RESELLER/STATISTICS
    'ui__client/limits__short-title' => 'Resurssien käyttö',
    'ui__client/limits__title' => 'Resurssien käyttö',
    'ui__client/limits__description' => "Näytä asiakkaan %1 resurssin käyttö ja hallitse sitä.",
    'ui__client/limits_unknown__short-title' => 'Resurssien käyttö',
    'ui__client/limits_unknown__title' => 'Resurssien käyttö',
    'ui__client/limits_unknown__description' => 'Näytä asiakkaan resurssin käyttö ja hallitse sitä.',
    'ui__client/limits_readonly__short-title' => 'Resurssien käyttö',
    'ui__client/limits_readonly__title' => 'Resurssien käyttö',
    'ui__client/limits_readonly__description' => 'Näytä asiakkaan %1 resurssin käyttö.',
    'ui__client/limits_self__short-title' => 'Resurssien käyttö',
    'ui__client/limits_self__title' => 'Resurssien käyttö',
    'ui__client/limits_self__description' => "Tarkastele ja hallitse resurssien käyttöä.",
    'ui__client/limits_readonly-self__short-title' => 'Resurssien käyttö',
    'ui__client/limits_readonly-self__title' => 'Resurssien käyttö',
    'ui__client/limits_readonly-self__description' => "Näytä resurssien käyttö.",
    'ui__client/domain/traffic_unknown__short-title' => "Liikenteen käyttö toimialueiden %1 mukaan",
    'ui__client/domain/traffic_unknown__title' => "Näytä liikenteen käyttö toimialueiden mukaan",
    'ui__client/domain/traffic_unknown__description' => "Näytä toimialueiden liikenteen käyttöä koskevat raportit.",
    // Log manager - RESELLER/STATISTICS
    // dropdowns
    'ui__client/report__title' => 'Yhteenvetoraportti',
    'ui__client/report__short-title' => 'Yhteenvetoraportti',
    'ui__client/report__description' => 'Näytä raportti tämän asiakkaan liikenteen ja resurssien käytöstä.',
    'ui__client/report_unknown__short-title' => 'Yhteenvetoraportti',
    'ui__client/report_unknown__title' => 'Yhteenvetoraportti',
    'ui__client/report_unknown__description' => 'Näytä raportti asiakkaan liikenteen ja resurssien käytöstä.',
    'ui__client/report_self__short-title' => 'Yhteenvetoraportti',
    'ui__client/report_self__title' => 'Yhteenvetoraportti',
    'ui__client/report_self__description' => 'Näytä liikenteen ja resurssien käyttöraportti.',

    // account
    // icons
    'ui__client/preferences__short-title' => 'Liittymämääritykset',
    'ui__client/preferences__title' => 'Liittymämääritykset',
    'ui__client/preferences__description' => 'Aseta Plesk -liittymän asetukset asiakkaalle %1.',
    'ui__client/preferences_unknown__short-title' => 'Liittymämääritykset',
    'ui__client/preferences_unknown__title' => 'Liittymämääritykset',
    'ui__client/preferences_unknown__description' => "Aseta asiakkaan Plesk -liittymän asetukset.",
    'ui__client/preferences_self__short-title' => 'Liittymämääritykset',
    'ui__client/preferences_self__title' => 'Liittymämääritykset',
    'ui__client/preferences_self__description' => 'Aseta Plesk -käyttöliittymän määritykset.',
    'ui__client/logo__title' => 'Pleskin tuotemukautus',
    'ui__client/logo__short-title' => 'Pleskin tuotemukautus',
    'ui__client/logo__description' => "Mukauta asiakkaan %1 Plesk.",
    'ui__client/logo_self__title' => 'Pleskin tuotemukautus',
    'ui__client/logo_self__short-title' => 'Pleskin tuotemukautus',
    'ui__client/logo_self__description' => 'Muuta Pleskin mukautusta muuttamalla logokuvaa ja selaimen otsikkoriviä.',
    'ui__client/permissions__title' => 'Käyttöoikeudet',
    'ui__client/permissions__short-title' => 'Käyttöoikeudet',
    'ui__client/permissions__description' => "Näytä asiakkaan %1 saatavilla olevat Plesk -toiminnot tai muuta niitä.",
    'ui__client/permissions_unknown__short-title' => 'Käyttöoikeudet',
    'ui__client/permissions_unknown__title' => 'Käyttöoikeudet',
    'ui__client/permissions_unknown__description' => "Näytä asiakkaan saatavilla olevat Plesk -toiminnot tai muuta niitä.",
    'ui__client/permissions_self__title' => 'Käyttöoikeudet',
    'ui__client/permissions_self__short-title' => 'Käyttöoikeudet',
    'ui__client/permissions_self__description' => "Näytä Pleskissa suoritettavissa olevien toimintojen luettelo.",
    'ui__client/permissions_readonly-self__title' => 'Käyttöoikeudet',
    'ui__client/permissions_readonly-self__short-title' => 'Käyttöoikeudet',
    'ui__client/permissions_readonly-self__description' => "Näytä Pleskissa suoritettavissa olevien toimintojen luettelo.",
    // dropdowns
    'ui__client/chowner_select__title' => 'Määritä asiakastilille uusi omistaja',
    'ui__client/chowner_select__short-title' => 'Määritä asiakkaalle uusi omistaja',
    'ui__client/chowner_select__description' => 'Määritä tälle asiakastilille uusi omistaja.',
    'ui__client/chowner_unknown-select__short-title' => 'Määritä asiakastilille uusi omistaja',
    'ui__client/chowner_unknown-select__title' => 'Määritä asiakkaalle uusi omistaja',
    'ui__client/chowner_unknown-select__description' => 'Määritä asiakastilille uusi omistaja.',
    'ui__client/to-reseller__title' => 'Muunna asiakastili jälleenmyyjätiliksi',
    'ui__client/to-reseller__short-title' => 'Muunna asiakas jälleenmyyjäksi',
    'ui__client/to-reseller__description' => 'Muunna tämä asiakastili jälleenmyyjätiliksi.',
    'ui__client/to-reseller_unknown__title' => 'Muunna asiakastili jälleenmyyjätiliksi',
    'ui__client/to-reseller_unknown__short-title' => 'Muunna asiakas jälleenmyyjäksi',
    'ui__client/to-reseller_unknown__description' => 'Muunna tämä asiakastili jälleenmyyjätiliksi.',

    // website
    // icons
    // Edit in SiteBuilder - RESELLER/WEBSITE
    // Web hosting settings - RESELLER/WEBSITE
    // Subdomains - RESELLER/WEBSITE
    // Domain aliases - RESELLER/ADDITIONAL TOOLS
    // Frontpage Webadmin - RESELLER/WEBSITE
    // Frontpage SSL/TLS Webadmin - RESELLER/WEBSITE
    // Web users - RESELLER/WEBSITE
    // Site preview - RESELLER/WEBSITE
    // dropdowns
    // DNS settings - RESELLER/WEBSITE
    // Change hosting type - RESELLER/WEBSITE
    // FrontPage management - RESELLER/WEBSITE    // PFW
    // Create subdomain - RESELLER/WEBSITE

    // applications & services
    // icons
    // Web applications - RESELLER/APPLICATIONS & SERVICES
    'ui__client/extras-domain__short-title' => 'Työkalut MyPlesk.com-sivulta',
    'ui__client/extras-domain__title' => 'Työkalut MyPlesk.com-sivulta',
    'ui__client/extras-domain__description' => 'Hae lisätyökaluja ja -palveluja osoitteesta MyPlesk.com.',
    'ui__client/extras-domain_unknown__short-title' => 'Työkalut MyPlesk.com-sivulta',
    'ui__client/extras-domain_unknown__title' => 'Työkalut MyPlesk.com-sivulta',
    'ui__client/extras-domain_unknown__description' => 'Hae lisätyökaluja ja -palveluja osoitteesta MyPlesk.com.',
    'ui__client/extras-domain_self__short-title' => 'Työkalut MyPlesk.com-sivulta',
    'ui__client/extras-domain_self__title' => 'Työkalut MyPlesk.com-sivulta',
    'ui__client/extras-domain_self__description' => 'Hae lisätyökaluja ja -palveluja osoitteesta MyPlesk.com.',
    // Databases - RESELLER/APPLICATIONS & SERVICES
    // ODBC data sources - RESELLER/APPLICATIONS & SERVICES    // PFW
    // Java applications - RESELLER/APPLICATIONS & SERVICES    // PFU
    'ui__client/register-domain__title' => 'Rekisteröi toimialue',
    'ui__client/register-domain__short-title' => 'Rekisteröi toimialue',
    'ui__client/register-domain__description' => 'Rekisteröi toimialueen nimi MyPlesk.com-sivun avulla.',
    'ui__client/register-domain_unknown__title' => 'Rekisteröi toimialue',
    'ui__client/register-domain_unknown__short-title' => 'Rekisteröi toimialue',
    'ui__client/register-domain_unknown__description' => 'Rekisteröi toimialueen nimi MyPlesk.com-sivun avulla.',
    'ui__client/register-domain_self__title' => 'Rekisteröi toimialue',
    'ui__client/register-domain_self__short-title' => 'Rekisteröi toimialue',
    'ui__client/register-domain_self__description' => 'Rekisteröi toimialueen nimi MyPlesk.com-sivun avulla.',
    // dropdowns
    // Install web application - RESELLER/APPLICATIONS & SERVICES
    // Create database - RESELLER/APPLICATIONS & SERVICES
    // Create database user - RESELLER/APPLICATIONS & SERVICES
    // Install Java application - RESELLER/APPLICATIONS & SERVICES
    'ui__client/manage-domain__title' => 'Hallitse toimialuetta',
    'ui__client/manage-domain__short-title' => 'Hallitse toimialuetta',
    'ui__client/manage-domain__description' => 'Hallitse rekisteröityjä toimialueen nimiä MyPlesk.com-sivun avulla.',
    'ui__client/manage-domain_unknown__title' => 'Hallitse toimialuetta',
    'ui__client/manage-domain_unknown__short-title' => 'Hallitse toimialuetta',
    'ui__client/manage-domain_unknown__description' => 'Hallitse rekisteröityjä toimialueen nimiä MyPlesk.com-sivun avulla.',
    'ui__client/manage-domain_self__title' => 'Hallitse toimialuetta',
    'ui__client/manage-domain_self__short-title' => 'Hallitse toimialuetta',
    'ui__client/manage-domain_self__description' => 'Hallitse rekisteröityjä toimialueen nimiä MyPlesk.com-sivun avulla.',

    // additional tools
    // icons
    'ui__client/ipaddress_unknown__title' => 'IP-osoitteet',
    'ui__client/ipaddress_unknown__short-title' => "IP-osoitteet",
    'ui__client/ipaddress_unknown__description' => "Hallitse IP-osoitteita.",
    'ui__client/domain/domain-alias_readonly-unknown__short-title' => 'Toimialueen aliakset',
    'ui__client/domain/domain-alias_readonly-unknown__title' => 'Toimialueen aliakset',
    'ui__client/domain/domain-alias_readonly-unknown__description' => 'Näytä toimialueesi vaihtoehtoisten nimien luettelo.',
    // Scheduled tasks - RESELLER/ADDITIONAL TOOLS
    // SSL/TLS certificates - RESELLER/ADDITIONAL TOOLS
    // Hotlink protection - RESELLER/ADDITIONAL TOOLS    // PFW
    'ui__client/sessions__short-title' => 'Aktiiviset istunnot',
    'ui__client/sessions__title' => 'Aktiiviset istunnot',
    'ui__client/sessions__description' => 'Näytä aktiiviset Plesk -istunnot.',
    'ui__client/sessions_unknown__short-title' => 'Aktiiviset istunnot',
    'ui__client/sessions_unknown__title' => 'Aktiiviset istunnot',
    'ui__client/sessions_unknown__description' => 'Näytä aktiiviset Plesk -istunnot.',
    'ui__client/sessions_self__short-title' => 'Aktiiviset istunnot',
    'ui__client/sessions_self__title' => 'Aktiiviset istunnot',
    'ui__client/sessions_self__description' => 'Näytä aktiiviset Plesk -istunnot.',
    // Shared SSL/TLS - RESELLER/ADDITIONAL TOOLS    // PFW
    // ASP.NET settings - RESELLER/ADDITIONAL TOOLS    // PFW
    // PHP settings - RESELLER/ADDITIONAL TOOLS    // PFW
    // dropdowns
    //Schedule new task - RESELLER/ADDITIONAL TOOLS

    ///
    /// END OF CLIENT
    ///

    ///
    /// DOMAIN / DOMAIN ADMINISTRATOR
    ///

    // files
    // icons
    'ui__client/domain/hosting/file-manager__short-title' => 'Tiedostonhallinta',
    'ui__client/domain/hosting/file-manager__title' => 'Hallitse tiedostoja toimialueella %1',
    'ui__client/domain/hosting/file-manager__description' => "Työskentele tiedostojen ja hakemistojen kanssa toimialueella %1 tiedostonhallinnan kautta.",
    'ui__client/domain/hosting/file-manager_self__short-title' => 'Tiedostonhallinta',
    'ui__client/domain/hosting/file-manager_self__title' => 'Tiedostonhallinta',
    'ui__client/domain/hosting/file-manager_self__description' => "Työskentele tiedostojesi ja hakemistojesi kanssa tiedostonhallinnan kautta.",
    'ui__client/domain/hosting/ssh-terminal__short-title' => 'SSH-pääte', // PFU
    'ui__client/domain/hosting/ssh-terminal__title' => 'SSH-pääte', // PFU
    'ui__client/domain/hosting/ssh-terminal__description' => 'Käytä SSH-päätettä käyttääksesi palvelinta.', // PFU
    'ui__client/domain/hosting/ssh-terminal_self__short-title' => 'SSH-pääte', // PFU
    'ui__client/domain/hosting/ssh-terminal_self__title' => 'SSH-pääte', // PFU
    'ui__client/domain/hosting/ssh-terminal_self__description' => 'Käytä SSH-päätettä käyttääksesi palvelinta.', // PFU
    'ui__client/domain/hosting/protected-directories__short-title' => 'Salasanasuojatut hakemistot',
    'ui__client/domain/hosting/protected-directories__title' => 'Salasanasuojatut hakemistot',
    'ui__client/domain/hosting/protected-directories__description' => 'Suojaa valittujen verkkosivustoalueiden käyttö.',
    'ui__client/domain/hosting/protected-directories_self__short-title' => 'Salasanasuojatut hakemistot',
    'ui__client/domain/hosting/protected-directories_self__title' => 'Salasanasuojatut hakemistot',
    'ui__client/domain/hosting/protected-directories_self__description' => 'Suojaa valittujen verkkosivustoalueiden käyttö.',
    'ui__client/domain/hosting/virtual-directories__short-title' => 'Näennäiskansiot', // PFW
    'ui__client/domain/hosting/virtual-directories__title' => 'Näennäiskansiot', // PFW
    'ui__client/domain/hosting/virtual-directories__description' => 'Luo ja hallitse toimialueen %1 näennäishakemistoja.', // PFW
    'ui__client/domain/hosting/virtual-directories_self__short-title' => 'Näennäiskansiot', // PFW
    'ui__client/domain/hosting/virtual-directories_self__title' => 'Näennäiskansiot', // PFW
    'ui__client/domain/hosting/virtual-directories_self__description' => 'Luo ja hallitse toimialueesi näennäishakemistoja.', // PFW
    'ui__client/domain/hosting/web-directories__title' => 'Näennäiskansiot', // PFW
    'ui__client/domain/hosting/web-directories__short-title' => 'Näennäiskansiot', // PFW
    'ui__client/domain/hosting/web-directories__description' => 'Käytä fyysisiä ja näennäistiedostoja sekä -hakemistoja verkkosivustolla %1.', // PFW
    'ui__client/domain/hosting/web-directories_self__title' => 'Näennäiskansiot', // PFW
    'ui__client/domain/hosting/web-directories_self__short-title' => 'Näennäiskansiot', // PFW
    'ui__client/domain/hosting/web-directories_self__description' => 'Käytä fyysisiä ja näennäistiedostoja sekä -hakemistoja verkkosivustollasi.', // PFW

    // statistics
    // icons
    'ui__client/domain/report/web-stats__short-title' => 'Verkkosivuston tilastot',
    'ui__client/domain/report/web-stats__title' => 'Verkkosivuston tilastot',
    'ui__client/domain/report/web-stats__description' => 'Näytä verkkosivuston vierailutilastot.',
    'ui__client/domain/report/web-stats_self__short-title' => 'Verkkosivuston tilastot',
    'ui__client/domain/report/web-stats_self__title' => 'Verkkosivuston tilastot',
    'ui__client/domain/report/web-stats_self__description' => 'Näytä verkkosivuston vierailutilastot.',
    'ui__client/domain/traffic__short-title' => '%1 liikenteen käyttö',
    'ui__client/domain/traffic__title' => 'Tiedonsiirtotilastot kohteelle <b>%1</b>',
    'ui__client/domain/traffic__description' => 'Näytä tiedonsiirron tilastotiedot toimialueeseen %1.',
    'ui__client/domain/traffic_self__short-title' => 'Liikenteen kuormitus',
    'ui__client/domain/traffic_self__title' => 'Näytä toimialueesi liikenteen käyttö',
    'ui__client/domain/traffic_self__description' => 'Näytä toimialueesi liikenteen käyttöä koskeva raportti.',
    'ui__client/domain/hosting/logs__short-title' => 'Lokinhallinta',
    'ui__client/domain/hosting/logs__title' => 'Lokinhallinta',
    'ui__client/domain/hosting/logs__description' => 'Näytä lokit ja määritä lokikierto.',
    'ui__client/domain/hosting/logs_self__short-title' => 'Lokinhallinta',
    'ui__client/domain/hosting/logs_self__title' => 'Lokinhallinta',
    'ui__client/domain/hosting/logs_self__description' => 'Näytä lokit ja määritä lokikierto.',
    // dropdowns
    'ui__client/domain/report__title' => 'Yhteenvetoraportti',
    'ui__client/domain/report__short-title' => 'Yhteenvetoraportti',
    'ui__client/domain/report__description' =>  'Näytä liikenteen ja resurssien käyttöraportti.',
    'ui__client/domain/report_unknown__short-title' => 'Yhteenvetoraportti',
    'ui__client/domain/report_unknown__title' => 'Yhteenvetoraportti',
    'ui__client/domain/report_unknown__description' => 'Näytä liikenteen ja resurssien käyttöraportti.',
    'ui__client/domain/report_self__short-title' => 'Yhteenvetoraportti',
    'ui__client/domain/report_self__title' => 'Yhteenvetoraportti',
    'ui__client/domain/report_self__description' => 'Näytä liikenteen ja resurssien käyttöraportti.',

    // domain administration
    // icons
    'ui__client/domain/properties__short-title' => 'Henkilötiedot',
    'ui__client/domain/properties__title' => 'Henkilötiedot',
    'ui__client/domain/properties__description' => 'Muuta toimialueen järjestelmänvalvojan tilin henkilötietoja.',
    'ui__client/domain/properties_unknown__short-title' => 'Henkilötiedot',
    'ui__client/domain/properties_unknown__title' => 'Henkilötiedot',
    'ui__client/domain/properties_unknown__description' => 'Muuta tilin henkilötietoja.',
    'ui__client/domain/properties_self__short-title' => 'Henkilötiedot',
    'ui__client/domain/properties_self__title' => 'Henkilötiedot',
    'ui__client/domain/properties_self__description' => 'Muuta tilisi henkilökohtaiset tiedot.',
    // dropdowns
    'ui__client/domain/rename__title' => 'Nimeä toimialue uudelleen',
    'ui__client/domain/rename__short-title' => 'Nimeä toimialue uudelleen',
    'ui__client/domain/rename__description' => 'Nimeä toimialue %1 uudelleen.',
    'ui__client/domain/rename_unknown__short-title' => 'Nimeä toimialue uudelleen',
    'ui__client/domain/rename_unknown__title' => 'Nimeä toimialue uudelleen',
    'ui__client/domain/rename_unknown__description' => 'Nimeä toimialue uudelleen',
    'ui__client/domain/chowner_select__title' => 'Määritä toimialueelle uusi omistaja',
    'ui__client/domain/chowner_select__short-title' => 'Määritä tilaukselle uusi omistaja',
    'ui__client/domain/chowner_select__description' => 'Määritä tilaukselle uusi omistaja',
    'ui__client/domain/chowner_unknown-select__short-title' => 'Määritä tilaukselle uusi omistaja',
    'ui__client/domain/chowner_unknown-select__title' => 'Määritä tilaukselle uusi omistaja',
    'ui__client/domain/chowner_unknown-select__description' => 'Määritä tilaukselle uusi omistaja.',
    'ui__client/domain/to-client__title' => 'Muunna toimialueen järjestelmänvalvojan tili asiakastiliksi',
    'ui__client/domain/to-client__short-title' => 'Muunna toimialueen järjestelmänvalvoja asiakkaaksi',
    'ui__client/domain/to-client__description' => 'Muuta tämä toimialueen järjestelmänvalvojan tili asiakastiliksi',
    'ui__client/domain/to-client_unknown__short-title' => 'Muunna toimialueen järjestelmänvalvoja asiakkaaksi',
    'ui__client/domain/to-client_unknown__title' => 'Muunna toimialueen järjestelmänvalvojan tili asiakastiliksi',
    'ui__client/domain/to-client_unknown__description' => 'Muuta toimialueen järjestelmänvalvojan tili asiakastiliksi',
    'ui__client/domain/toggle__title' => 'Peruuta tai aktivoi toimialue', // for HP customization
    'ui__client/domain/toggle__short-title' => 'Peruuta tai aktivoi toimialue', // for HP customization
    'ui__client/domain/toggle__description' => 'Keskeytä tai aktivoi toimialue %1.', // for HP customization
    'ui__client/domain/toggle_unknown__title' => 'Peruuta tai aktivoi toimialue', // for HP customization
    'ui__client/domain/toggle_unknown__short-title' => 'Peruuta tai aktivoi toimialue', // for HP customization
    'ui__client/domain/toggle_unknown__description' => 'Keskeytä tai aktivoi toimialue.', // for HP customization
    'ui__client/domain/toggle_enable__title' => 'Aktivoi toimialue',
    'ui__client/domain/toggle_enable__short-title' => 'Aktivoi toimialue',
    'ui__client/domain/toggle_enable__description' => 'Aktivoi toimialue %1.',
    'ui__client/domain/toggle_disable__title' => 'Peruuta toimialue',
    'ui__client/domain/toggle_disable__short-title' => 'Peruuta toimialue',
    'ui__client/domain/toggle_disable__description' => 'Peruuta toimialue %1.',

    // website
    // icons
    // dropdowns
    'ui__client/domain/dns__title' => 'DNS-asetukset',
    'ui__client/domain/dns__short-title' => 'DNS-asetukset',
    'ui__client/domain/dns__description' => 'Hallitse toimialueen %1 DNS-vyöhykkeen asetuksia.',
    'ui__client/domain/dns_self__title' => 'DNS-asetukset',
    'ui__client/domain/dns_self__short-title' => 'DNS-asetukset',
    'ui__client/domain/dns_self__description' => 'Hallitse toimialueesi DNS-vyöhykkeen asetuksia.',
    'ui__client/domain/dns_disabled__title' => 'DNS-asetukset',
    'ui__client/domain/dns_disabled__short-title' => 'DNS-asetukset',
    'ui__client/domain/dns_disabled__description' => 'Hallitse toimialueen %1 DNS-vyöhykkeen asetuksia.',
    'ui__client/domain/dns_self-disabled__title' => 'DNS-asetukset',
    'ui__client/domain/dns_self-disabled__short-title' => 'DNS-asetukset',
    'ui__client/domain/dns_self-disabled__description' => 'Hallitse toimialueesi DNS-vyöhykkeen asetuksia.',
    'ui__client/domain/dns_readonly__title' => 'DNS-asetukset',
    'ui__client/domain/dns_readonly__short-title' => 'DNS-asetukset',
    'ui__client/domain/dns_readonly__description' => 'Näytä toimialueen %1 DNS-vyöhykeasetukset.',
    'ui__client/domain/dns_readonly-self__title' => 'DNS-asetukset',
    'ui__client/domain/dns_readonly-self__short-title' => 'DNS-asetukset',
    'ui__client/domain/dns_readonly-self__description' => 'Näytä toimialueesi DNS-vyöhykkeen asetukset.',
    'ui__client/domain/dns_readonly-self-disabled__title' => 'DNS-asetukset',
    'ui__client/domain/dns_readonly-self-disabled__short-title' => 'DNS-asetukset',
    'ui__client/domain/dns_readonly-self-disabled__description' => 'Näytä toimialueesi DNS-vyöhykkeen asetukset.',
    'ui__client/domain/dns_readonly-self-slave__title' => 'DNS-asetukset',
    'ui__client/domain/dns_readonly-self-slave__short-title' => 'DNS-asetukset',
    'ui__client/domain/dns_readonly-self-slave__description' => 'Näytä toimialueesi DNS-vyöhykkeen asetukset.',
    'ui__client/domain/dns_slave__title' => 'DNS-asetukset',
    'ui__client/domain/dns_slave__short-title' => 'DNS-asetukset',
    'ui__client/domain/dns_slave__description' => 'Hallitse toimialueen %1 DNS-vyöhykkeen asetuksia.',
    'ui__client/domain/dns_self-slave__title' => 'DNS-asetukset',
    'ui__client/domain/dns_self-slave__short-title' => 'DNS-asetukset',
    'ui__client/domain/dns_self-slave__description' => 'Hallitse toimialueesi DNS-vyöhykkeen asetuksia.',
    // FrontPage management - RESELLER/WEBSITE    // PFW

    // applications & services
    // icons
    'ui__client/domain/extras__short-title' => 'Työkalut MyPlesk.com-sivulta',
    'ui__client/domain/extras__title' => 'Työkalut MyPlesk.com-sivulta',
    'ui__client/domain/extras__description' => 'Hae lisätyökaluja ja -palveluja osoitteesta MyPlesk.com.',
    'ui__client/domain/extras_unknown__short-title' => 'Työkalut MyPlesk.com-sivulta',
    'ui__client/domain/extras_unknown__title' => 'Työkalut MyPlesk.com-sivulta',
    'ui__client/domain/extras_unknown__description' => 'Hae lisätyökaluja ja -palveluja osoitteesta MyPlesk.com.',
    'ui__client/domain/extras_self__short-title' => 'Työkalut MyPlesk.com-sivulta',
    'ui__client/domain/extras_self__title' => 'Työkalut MyPlesk.com-sivulta',
    'ui__client/domain/extras_self__description' => 'Hae lisätyökaluja ja -palveluja osoitteesta MyPlesk.com.',
    'ui__client/domain/odbc__short-title' => 'ODBC-tietolähteet', // PFW
    'ui__client/domain/odbc__title' => 'ODBC-tietolähteet', // PFW
    'ui__client/domain/odbc__description' => 'Aseta ODBC-tietolähteet toimialueeseen %1.', // PFW
    'ui__client/domain/odbc_self__short-title' => 'ODBC-tietolähteet', // PFW
    'ui__client/domain/odbc_self__title' => 'ODBC-tietolähteet', // PFW
    'ui__client/domain/odbc_self__description' => 'Aseta ODBC-tietolähteet toimialueeseesi.', // PFW
    // Java applications - RESELLER/APPLICATIONS & SERVICES    // PFU
    'ui__client/domain/register__short-title' => 'Rekisteröi toimialue',
    'ui__client/domain/register__title' => 'Rekisteröi toimialue',
    'ui__client/domain/register__description' => 'Rekisteröi toimialueen nimi MyPlesk.com-sivun avulla.',
    'ui__client/domain/register_unknown__short-title' => 'Rekisteröi toimialue',
    'ui__client/domain/register_unknown__title' => 'Rekisteröi toimialue',
    'ui__client/domain/register_unknown__description' => 'Rekisteröi toimialueen nimi MyPlesk.com-sivun avulla.',
    'ui__client/domain/register_self__short-title' => 'Rekisteröi toimialue',
    'ui__client/domain/register_self__title' => 'Rekisteröi toimialue',
    'ui__client/domain/register_self__description' => 'Rekisteröi toimialueen nimi MyPlesk.com-sivun avulla.',
    // dropdowns
    // Create database user - RESELLER/APPLICATIONS & SERVICES

    // additional tools
    // icons
    // Domain aliases - RESELLER/ADDITIONAL TOOLS
    // Scheduled tasks - RESELLER/ADDITIONAL TOOLS    // PFU
    // SSL/TLS certificates - RESELLER/ADDITIONAL TOOLS
    'ui__client/domain/hosting/hotlink-protection__short-title' => 'Pikalinkkisuojaus', // PFW
    'ui__client/domain/hosting/hotlink-protection__title' => 'Pikalinkkisuojaus', // PFW
    'ui__client/domain/hosting/hotlink-protection__description' => 'Suojaa tiedostot toimialueella %1 suoralinkitykseltä.', // PFW
    'ui__client/domain/hosting/hotlink-protection_self__short-title' => 'Pikalinkkisuojaus', // PFW
    'ui__client/domain/hosting/hotlink-protection_self__title' => 'Pikalinkkisuojaus', // PFW
    'ui__client/domain/hosting/hotlink-protection_self__description' => 'Suojaa tiedostosi suoralinkitykseltä.', // PFW
    'ui__client/domain/hosting/performance__short-title' => 'Kaistanleveysrajoitus',
    'ui__client/domain/hosting/performance__title' => 'Kaistanleveyden käyttöraja ja verkkosivustosi sallittujen yhteyksien määrä',
    'ui__client/domain/hosting/performance__description' => 'Näytä ja säädä kaistanleveyden käyttöraja toimialueeseen %1 sekä sen samanaikaisten yhteyksien määrä.',
    'ui__client/domain/hosting/performance_readonly__short-title' => 'Kaistanleveysrajoitus',
    'ui__client/domain/hosting/performance_readonly__title' => 'Kaistanleveyden käyttörajat ja verkkosivustosi sallittujen yhteyksien määrä',
    'ui__client/domain/hosting/performance_readonly__description' => 'Näytä kaistanleveyden käyttöraja toimialueeseen %1 sekä sen samanaikaisten yhteyksien määrä.',
    'ui__client/domain/hosting/performance_self__short-title' => 'Kaistanleveysrajoitus',
    'ui__client/domain/hosting/performance_self__title' => 'Kaistanleveysrajoitus',
    'ui__client/domain/hosting/performance_self__description' => 'Näytä ja säädä kaistanleveyden käyttöraja toimialueeseen sekä sen samanaikaisten yhteyksien määrä.',
    'ui__client/domain/hosting/performance_readonly-self__short-title' => 'Kaistanleveysrajoitus',
    'ui__client/domain/hosting/performance_readonly-self__title' => 'Kaistanleveysrajoitus',
    'ui__client/domain/hosting/performance_readonly-self__description' => 'Näytä kaistanleveyden käyttöraja toimialueeseen sekä sen samanaikaisten yhteyksien määrä.',
    'ui__client/domain/hosting/php__short-title' => 'PHP-asetukset', // PFW
    'ui__client/domain/hosting/php__title' => 'PHP-asetukset', // PFW
    'ui__client/domain/hosting/php__description' => 'Määritä PHP toimialueelle %1.', // PFW
    'ui__client/domain/hosting/php_self__short-title' => 'PHP-asetukset', // PFW
    'ui__client/domain/hosting/php_self__title' => 'PHP-asetukset', // PFW
    'ui__client/domain/hosting/php_self__description' => 'Määritä PHP toimialueeseesi.', // PFW

    // dropdowns


    ///
    /// END OF DOMAIN / DOMAIN ADMINISTRATOR
    ///

    ////
    //// KEYS FOR BUSINESS OBJECT LISTS/PAGES (RESELLERS, CLIENTS, DOMAINS)
    ////

    ///
    /// CLIENTS
    ///

    // list object operations

    // list object operation errors
    'ui__client/to-reseller__empty_selection' => 'Sinun on valittava asiakastilit, jotka haluat muuttaa jälleenmyyjän tileiksi',
    'ui__client/chowner__empty_selection' => 'Sinun on valittava asiakastilit, jotka haluat määrittää uudelle omistajalle',

    ///
    /// END OF CLIENTS
    ///

    ///
    /// DOMAINS
    ///

    // Domains list page title - ui__client/domain_unknown__short-title (HOME)

    // tools
    'ui__client/domain#tools__title' => "Työkalut",
    // Create domain - ui__client/domain/properties_unknown-new__short-title (HOME)
    // Below: TBD
    'ui__client/domain-summary-report_unknown__short-title' => 'Näytä tilastot',
    'ui__client/domain-summary-report_unknown__title' => 'Näytä tilastot',
    'ui__client/domain-summary-report_unknown__description' => 'Näytä toimialueiden resurssien käyttöä koskevat tiedot.',
    'ui__client/domain-summary-report__short-title' => "Näytä tilastot",
    'ui__client/domain-summary-report__title' => "Näytä tilastot",
    'ui__client/domain-summary-report__description' => "Näytä toimialueiden resurssien käyttöä koskevat tiedot.",
    'ui__client/domain-summary-report_self__short-title' => "Näytä tilastot",
    'ui__client/domain-summary-report_self__title' => "Näytä tilastot",
    'ui__client/domain-summary-report_self__description' => "Näytä toimialueidesi resurssin käyttöä koskevat tiedot.",
    // Traffic usage - ui__client/domain/traffic_unknown__short-title

    'ui__client/domain#list__title' => "Toimialueet", // DOMAINS

    // list object operations
    'ui__client/domain/check-permissions_multi__short-title' => 'Tarkista käyttöoikeudet',
    'ui__client/domain/check-permissions_multi__title' => 'Käyttöoikeustarkistus',
    'ui__client/domain/check-permissions_multi__description' => 'Tarkista tiedoston ja kansion käyttöoikeudet toimialueella. Jos virheitä löytyy, ne korjataan automaattisesti.',

    // list object operation errors
    'ui__client/domain/delete__empty_selection' => 'Sinun on valittava toimialueet, jotka haluat poistaa',
    'ui__client/domain/properties__empty_selection' => 'Sinun on valittava toimialueet, joita haluat muuttaa',
    'ui__client/domain/chowner__empty_selection' => 'Sinun on valittava toimialueet, jotka haluat määrittää uudelle omistajalle',
    'ui__client/domain/check-permissions__empty_selection' => 'Sinun on valittava toimialueet, joiden tiedostojen ja kansioiden käyttöoikeudet haluat tarkistaa',
    'ui__client/domain/to-client__empty_selection' => 'Sinun on valittava toimialueet, joiden järjestelmänvalvojan tilit haluat muuttaa asiakastileiksi',

    // list objects filtering
    'domains_list__name__filter_title' => 'Nimi',
    'domains_list__state__filter_title' => 'Resurssien käyttö',
    'domains_list__filter_state_any' => 'Mikä tahansa',
    'domains_list__filter_state_overuse' => 'Liikakäyttö',
    'domains_list__filter_state_normal' => 'Rajojen sisällä',
    'domains_list__status__filter_title' => 'Tila',
    'domains_list__filter_status_any' => 'Mikä tahansa',
    'domains_list__filter_status_blocked' => 'Keskeytetty',
    'domains_list__filter_status_active' => 'Akt.',
    'domains_list__ownership__filter_title' => 'Omistus',
    'domains_list__filter_ownership_all' => 'Kaikki toimialueet',
    'domains_list__filter_ownership_personal' => 'Vain omat toimialueet',
    'domains_list__filter_owner_pname__filter_title' => 'Omistajan nimi',
    'domains_list__subrows__filter_title' => 'Näytä',
    'domains_list__subrows_off' => 'Vain toimialueet',
    'domains_list__subrows_subdomain_domainaliases' => 'Alitoimialueilla ja aliaksilla',
    'domains_list__subrows_subdomain' => 'Alitoimialueilla',
    'domains_list__subrows_domainaliases' => 'Aliaksilla',

    // objects list
    'domains_list__owner__title' => 'Omistaja',

    ///
    /// END OF DOMAINS
    ///

    ////
    //// KEYS FOR APPLICATION VAULT AND WEB APPLICATION MANAGEMENT
    ////

    ///
    /// APPLICATION VAULT / APS CATALOG
    ///

    // Application Vault / APS Catalog promotional block
    'site_apps__promo_browse_for_applications' => "Selaa sovelluksia",
    'site_apps__promo_main_text' => "Application Packaging Standard (APS) -luettelo sisältää luettelon sovelluksista, jotka voidaan liittää toimialueeseen tai verkkotilaan. Jos haluat saada sovelluksia, joita ei ole luettelossa, voit APS tehdä sen helposti noudattamalla APS-pakkausohjeita www.apsstandard.com",
    'site_apps__promo_download_now' => "Lataa sovelluksia:",
    'site_apps__promo_close' => "Sulje tämä osio",
    'site_apps__promo_preset__mostused' => '%1 suosituimmat',
    'site_apps__promo_preset__lessused' => 'Seuraavaksi %1 suosituin',
    'site_apps__promo_preset__all' => "Kaikki",
    'site_apps__promo_disclaimer_note' => 'Huomaa, että APS-luettelosta asennetut sovellukset tarjoaa kolmas osapuoli eikä Plesk tue niitä.',
    'site_apps__promo_preset__page_title' => '%1 APS-sovellukset',

    // Progress bar
    'site_apps__progress_initialization_message' => 'Lisätään sovelluksia...',

    // Errors
    'site_apps__no_applications_for_update' => 'Et ole asentanut sovelluksia sovellusvalikoimaan.',
    'site_apps__incorrect_download_preset_configuration' => 'APS-luettelon latauksen esiasetuksissa löytyi määritysvirheitä.',
    'site_apps__aps_catalog_url_is_invalid' => 'Määritetty URL-osoite on virheellinen.',
    'site_apps__no_updates_at_the_moment' => 'Tällä hetkellä ei ole saatavana sovelluspäivityksiä.',
    'site_apps__incorrect_content_returned_by_catalog' => 'APS-sovellusluettelolta saatiin virheellistä tietoa. Yritä myöhemmin uudelleen.',
    'site_apps__entered_aps_catalog_url_is_not_valid' => 'APS-luettelon asetukset tallennettiin, mutta Plesk ei voinut luoda yhteyttä APS-luettelon asetuksissa (%1) määritettyyn APS-luetteloon. Varmista, että APS-luettelon osoite on oikein, ja että tässä osoitteessa oleva APS-luettelo on aktiivinen.',
    'site_apps__cannot_retrieve_updates' => 'Sovelluspäivityksiä ei voida ladata tällä hetkellä: yhteyttä ei voida luoda APS-luetteloon (%1). Varmista, että APS-luettelon osoite on oikein, ja että tässä osoitteessa oleva APS-luettelo on aktiivinen.',
    'site_apps__no_site_applications_in_client_pool_to_install' => 'Verkkosovelluksia ei ole saatavilla asennukseen.',
    'site_apps__site_applications_already_installed_in_root' => 'Näiden näennäisisäntien päähakemistoihin on jo asennettu muita verkkosovelluksia',
    'site_apps__dot_net_packages_not_supported_on_unix_platform' => "Unix/Linux-alusta ei tue .NET -verkkosovelluksia",
    'site_apps__server_wide_packages_not_supported' => 'Palvelimen laajuisia verkkosovelluksia ei tueta',
    'site_apps__applications_added_to_queue_for_adding_to_application_vault' => "%1 muuta verkkosovellusta on aikataulutettu lisättäväksi sovellusvalikoimaan.",
    'site_apps__applications_all_in_vault' => "Valitut verkkosovellukset ovat jo olemassa sovellusvalikoimassa.",
    'site_apps__applications_already_in_download_queue' => "%1 valittua verkkosovellusta lisätään tällä hetkellä sovellusvalikoimaan.",
    'site_apps__applications_already_in_valut' => "%1 valitut verkkosovellukset ovat jo sovellusvalikoimassa.",

    // UI errors

    ///
    /// END OF APPLICATION VAULT / APS CATALOG
    ///

    ///
    /// APS CATEGORIES
    ///

    // General
    'site_apps__not_categorized' => 'Muu (ei luokitusta)',

    // Errors
    'site_apps__no_applications_in_category' => 'Tässä luokassa ei ole käytettävissä olevia sovellussarjoja. Valitse jokin toinen luokka.',
    'site_apps__no_category_selected__please_specify' => 'Valitse kategoria vasemmasta valikosta. Kaikki valitussa kategoriassa saatavilla olevat sovellukset luetellaan tässä ikkunassa.',

    // Category: Back office
    // Category: Collaboration
    // Category: Front Office
    // Category: Infrastructure
    // Category: Personal
    // Category: Web

    ///
    /// END OF APS CATEGORIES
    ///

    ///
    /// APPLICATION VAULT
    ///

    //removal


    ///
    /// END OF APPLICATION VAULT
    ///

    ////
    //// KEYS FOR SETTINGS PAGE
    ////

    ///
    /// SERVER ADMINISTRATOR SETTINGS
    ///

    'administrator_account' => 'Järjestelmänvalvojatili',
    // Personal data - HOME/SERVER ADMINISTRATOR/ACCOUNT
    // Change password - HOME/SERVER ADMINISTRATOR/ACCOUNT
    // Interface preferences - HOME/SERVER ADMINISTRATOR/ACCOUNT

    'general' => 'Yleiset',
    // Server settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_change_hostname' => 'Muuta isäntänimeä',
    // System time - HOME/SERVER ADMINISTRATOR/SERVER
    // IP addresses - HOME/SERVER ADMINISTRATOR/SERVER
    // Scheduled tasks - HOME/SERVER ADMINISTRATOR/SERVER
    // FTP settings - HOME/SERVER ADMINISTRATOR/SERVER    // PFW

    'security' => 'Suojaus',
    'bt_setup_firewall' => 'Aseta palomuuri',
    'bt_manage_firewall_rules' => 'Palomuurisääntöjen hallinta',
    'cu_firewall__rule' => 'Luo palomuurisääntö',
    'cu_firewall__protocol' => 'Aseta protokolla sääntöön (\'tcp\' tai \'udp\')',
    'cu_firewall__name' => "Aseta säännön nimi",
    'cu_firewall__disabled' => 'Jos \'true\', sääntö poistetaan käytöstä luomisen jälkeen',
    // Session idle time - HOME/SERVER ADMINISTRATOR/SECURITY
    // SSL/TLS certificates - HOME/SERVER ADMINISTRATOR/SECURITY
    // Shared SSL/TLS - HOME/SERVER ADMINISTRATOR/SECURITY    // PFW

    'dns' => 'DNS',
    'bt_select_dns_server' => 'Valitse DNS-palvelin', // PFW
    'bt_soa_records_template' => 'SOA-tietueiden malli',
    'bt_restrict_creation_of_subzones' => 'Rajoita alivyöhykkeiden luontia',

    'databases' => 'Tietokannat',
    'bt_select_mssqlwebadmin' => 'Valitse MS SQL Webadmin', // PFW
    // Database hosting preferences - HOME/SERVER ADMINISTRATOR/SERVER

    'applications' => 'Sovellukset',
    // ASP.NET settings - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES    // PFW
    // IIS application pool - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES    // PFW
    // SiteBuilder settings - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES

    'mail' => 'Sähköposti',
    'bt_select_mailserver' => 'Valitse postipalvelin', // PFW
    // Mail server settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_select_antivirus' => 'Valitse virustentorjunta', // PFW
    'bt_virus_protection_settings' => 'Virussuojausasetukset',
    'bt_select_spamfilter' => 'Valitse roskapostisuodatin', // PFW
    // Spam filter settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_select_webmail' => 'Valitse verkkosähköposti',
    // Set up mailing lists server - HOME/SERVER ADMINISTRATOR/SERVER    // PFU

    'logs_and_statistics' => 'Lokit ja tilastot',
    'bt_server_statistics_settings' => 'Palvelimen tilastotietojen asetukset',
    'bt_select_web_statistics' => 'Saatavilla oleva verkkotilastotieto-ohjelmisto', // PFW
    // Action log - HOME/SERVER ADMINISTRATOR/LOGS & STATISTICS

    'control_panel_interface' => 'Plesk-liittymä',

    'components_and_modules' => 'Komponentit ja moduulit',
    // Server components - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_setup_watchdog' => 'Aseta Watchdog', // PFU
    'bt_setup_vpn' => 'Aseta VPN', // PFU
    'bt_setup_samba' => 'Aseta Samba',    // PFU

    ///
    /// END OF SERVER ADMINISTRATOR SETTINGS
    ///

    ///
    /// DOMAIN SETTINGS
    ///

    'ui__client/domain/settings_self__title' => 'Asetukset',
    'ui__client/domain/settings_self__short-title' => 'Asetukset',
    'ui__client/domain/settings_self__description' => 'Tarkastele ja muuta toimialueasetuksia.',

    'domain_administrator_account' => 'Toimialueen järjestelmänvalvojan tili',
    // Interface preferences - HOME/DOMAIN ADMINISTRATOR/DOMAIN
    'bt_account_settings' => 'Tilin asetukset',

    'domain' => 'Toimialue',
    'bt_dns_soa_records' => 'DNS SOA -tietueet',
    // Mail settings - HOME/DOMAIN ADMINISTRATOR/MAIL
    'bt_task_scheduler_settings' => 'Tehtävien ajoituksen asetukset',

    'website' => 'Verkkosivusto',
    // Web hosting settings - HOME/DOMAIN ADMINISTRATOR/WEBSITE
    // Bandwidth limiting - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS
    'bt_web_users_scripting' => 'Verkkokäyttäjien komentosarjat',
    // Anonymous FTP - HOME/DOMAIN ADMINISTRATOR/FILES

    // Applications - SETTINGS/SERVER/APPLICATIONS    // PFW
    // ASP.NET settings - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW
    // PHP settings - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW
    // IIS application pool - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW

    // Security - SETTINGS/SERVER/SECURITY
    // Password protected directories - HOME/DOMAIN ADMINISTRATOR/FILES
    'bt_select_ssl_certificate' => 'Valitse yksi SSL/TLS-varmenne',
    // Hotlink protection - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW
    // Shared SSL/TLS - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW

    // Logs & statistics - SETTINGS/SERVER/LOGS & STATISTICS
    'bt_web_statistics' => 'Verkkosivuston tilastot',
    'bt_log_rotation_settings' => 'Lokin kierron asetukset',

    ///
    /// END OF DOMAIN SETTINGS
    ///

    ////
    //// KEYS FOR LIMITS AND PERMISSIONS
    ////

    ///
    /// LIMITS
    ///

    '__limits' => "Rajat", // template

    // overuse & oversell
    'limits__overuse_oversell_policy_legend' => "Ylikäyttö- ja ylimyyntikäytäntö",
    'limits__overuse_policy_legend' => "Liikakäyttö",
    'limits__oversell_policy_legend' => "Ylimyynti",
    'limits__reseller_overuse_description' => "Ylikäyttökäytäntö kertoo Pleskille miten toimia, kun käytetään liikaa resursseja.",
    'limits__overuse_text' => "Liikakäyttökäytäntö",

    // limit names
    'limit_group__disk_space_and_traffic' => 'Levytila ja liikenne',
    'limit__disk_space' => 'Levytila',
    'limit__max_traffic' => 'Liikenne',
    'limit_group__client' => 'Asiakkaat',
    'limit__max_cl' => 'Asiakkaat',
    'limit_group__domain' => 'Toimialueet',
    'limit__max_dom' => 'Toimialueet',
    'limit__max_dom_powerUser' => 'Tilaukset',
    'limit__max_subdom' => 'Alitoimialueet',
    'limit__max_dom_aliases' => 'Toimialueen aliakset',
    'limit__max_wu' => 'Internet-käyttäjät',
    'limit__max_subftp_users' => 'FTP-lisätilit', // PFW
    'limit_group__mail' => 'Sähköposti',
    'limit__max_box' => 'Postilaatikot',
    'limit__mbox_quota' => 'Postilaatikon koko',
    'limit__total_mboxes_quota' => 'Postilaatikoiden kokonaiskiintiö', // PFW
    'limit__max_maillists' => 'Postituslistat',
    'limit_group__database' => 'Tietokannat',
    'limit__max_mssql_db' => 'Microsoft SQL Server -tietokannat', // PFW
    'limit__mssql_dbase_space' => 'MS SQL -tietokantojen kokonaiskiintiö', // PFW
    'limit__max_odbc' => 'ODBC-yhteydet', // PFW
    // limit__max_db - CONFLICTED
    'limit__mysql_dbase_space' => 'MySQL-tietokannan kiintiö', // PFW?
    'limit_group__application' => 'Sovellukset',
    'limit__max_iis_app_pools' => 'IIS-sovellussarjat', // PFW
    'limit_group__security' => 'Suojaus',
    'limit_group__validity' => 'Vanhentumispäivä',
    'limit__expiration' => 'Vanhentumispäivä',
    'limit__validity' => 'Voimassaolokausi',
    'limit__max_site_builder' => 'Presence Builderilla julkaistut sivustot',
    'limit__max_site' => 'Toimialueet',
    'limit__mssql_dbase_filesize' => 'MS SQL -tietokannan tiedostokoko',
    'limit__mssql_dbase_log_filesize' => 'MS SQL -tietokannan lokitiedoston koko',
    'limit__mssql_dbase_filesize_hint' => 'Microsoft SQL -tietokannan tiedoston maksimikoko.',
    'limit__mssql_dbase_log_filesize_hint' => 'Microsoft SQL -tietokannan lokitiedoston maksimikoko.',
    'limit__units_mssql_dbase_filesize' => "MT",
    'limit__units_mssql_dbase_log_filesize' => "MT",

    'dom_pref__invalid_max_site_limit' => 'Virheellinen toimialueen raja. Vähimmäisarvo on 1.',

    'property__has_wrong_value' => 'Ominaisuuden %1 arvo on virheellinen.',
    'property__name_outgoing_messages_domain_limit' => 'Asettaa toimialueen lähtevien viestien rajan (tuntia kohti). Aseta rajoittamaton arvo syöttämällä arvo "-1". Määritä "oletus" asettaaksesi palvelimen laajuisissa asetuksissa annetun arvon.',
    'property__name_outgoing_messages_mbox_limit' => 'Asettaa postilaatikon lähtevien viestien rajan (tuntia kohti). Aseta rajoittamaton arvo syöttämällä arvo "-1". Määritä "oletus" asettaaksesi palvelimen laajuisissa asetuksissa annetun arvon.',
    'property__name_outgoing_messages_subscription_limit' => 'Asettaa tilauksen lähtevien viestien rajan (tuntia kohti). Aseta rajoittamaton arvo syöttämällä arvo "-1". Määritä "oletus" asettaaksesi palvelimen laajuisissa asetuksissa annetun arvon.',

    // for CLI report & email notifications
    '__resource_notify' => 'Ilmoita',
    '__general' => 'Yleiset',
    '__template_shared' => 'Jaettu malli',
    'limit__overuse' => 'Liikakäyttökäytäntö',
    'limit__max_traffic_soft' => 'Ilmoita, kun liikenteen käyttö saavuttaa',
    'limit__disk_space_soft' => 'Ilmoita, kun levyn tilan käyttö saavuttaa',
    '__overuse' => 'Liikakäyttökäytäntö',
    'performance__title' => 'Suorituskyky',
    'performance__bandwidth' => 'Maksimaalinen kaistanleveyden käyttö (Kt/s)',
    'performance__max_connections' => 'Yhteyksien rajoitus',

    'gch__hosting_php_isapi' => 'Suorita PHP ISAPI-tunnisteena',
    'gch__hosting_ssi_html' => 'Käytä SSI:tä *.htm- ja *.html-tiedostoille',
    'gch__hosting_php_handler_type' => 'Suorita PHP',
    'gch__hosting_php_handler_id' => 'Suorita PHP',
    'gch__hosting_php_served_by_nginx' => 'nginx tukema PHP',
    'gch__hosting_unpaid_website_status' => 'Verkkosivustojen tila peruutetuissa tilauksissa',
    'gch__mn_no_autoresponder' => 'Sähköpostitilille ei ole asetettu automaattisia vastauksia.',
    'gch__no_clients_selected' => "Mitään asiakastiliä ei ole valittu",
    'gch__no_domains_selected' => "Toimialueita ei ole valittu",

    // limit units
    'limit__units_disk_space' => "MT",
    'limit__units_max_traffic' => "Mt/kk",
    'limit__units_mbox_quota' => "KT",
    'limit__units_mysql_dbase_space' => "MT", // PFW
    'limit__units_mssql_dbase_space' => "MT", // PFW
    'limit__units_total_mboxes_quota' => "MT", // PFW

    // manipulations and statuses of limits
    '__resource_name' => 'Resurssin nimi',
    '__resource_usage' => 'Käytetty',
    '__resource_limit' => 'Raja',

    '__used' => 'Käytetty',
    '__limit' => 'Raja',

    '__never_expires' => 'Ei vanhene',
    '__resource_free' => '%1/%2 vapaana',
    '__resource_unlimited' => '%1 käytetty rajoittamattomasta',

    '__unlimited' => 'Rajoittamaton',
    '__increment' => "Lisää (+)",
    '__decrement' => "Vähennä (-)",
    '__pt' => 'Yksiköt',
    '__procent' => '%',
    '__overused' => 'Ylikäytetty',
    '__left' => 'vasen',
    '__available' => 'käytettävissä',
    '__not_available' => 'Ei sisälly',

    ///
    /// END OF LIMITS
    ///

    ///
    /// PERMISSIONS
    ///

    //permissions hints

    ///
    /// END OF PERMISSIONS
    ///

    ////
    //// KEYS FOR STATISTICS AND REPORTS
    ////

    ///
    /// REPORT
    ///

    // administrator

    'ui__admin/report/traffic-history__short-title' => 'Näytä liikennehistoria',
    'ui__admin/report/traffic-history__title' => 'Näytä liikennehistoria',
    'ui__admin/report/traffic-history__description' => 'Näytä jälleenmyyjien, asiakkaiden ja toimialueiden liikennehistoria.',
    'admin_traffic_history__title' => 'Liikennehistoria',

    'ui__admin/report/layout/auto_unknown__short-title' => 'Toimitusaikataulu',
    'ui__admin/report/layout/auto_unknown__title' => 'Raportin toimitusaikataulu',
    'ui__admin/report/layout/auto_unknown__description' => 'Valitse raportin toimitusaikataulu raporttiasettelua varten.',
    'ui__admin/report/layout/auto/properties_new__short-title' => 'Lisää raportin toimitusaikataulu',
    'ui__admin/report/layout/auto/properties_new__title' => 'Lisää raportin toimitusaikataulu',
    'ui__admin/report/layout/auto/properties_new__description' => 'Lisää raportin toimitusaikataulu raportille %1.',
    'ui__admin/report/layout/auto/properties__short-title' => 'Raportin toimitusaikataulu',
    'ui__admin/report/layout/auto/properties__title' => 'Raportin toimitusaikataulu',
    'ui__admin/report/layout/auto/properties__description' => 'Näytä raportin toimitusaikataulun ominaisuudet ja muokkaa niitä',
    'ui__admin/report/layout/auto/delete_multi__short-title' => 'Poista raportin toimitusaikataulu',
    'ui__admin/report/layout/auto/delete_multi__title' => 'Poista raportin toimitusaikataulu',
    'ui__admin/report/layout/auto/delete_multi__description' => 'Poista valitut raportin toimitusaikataulut.',

    'ui__admin/report/layout_unknown__short-title' => 'Raporttiasettelut',
    'ui__admin/report/layout_unknown__title' => 'Raporttiasettelut',
    'ui__admin/report/layout_unknown__description' => 'Näytä raporttiasettelut ja hallitse niitä.',
    'ui__admin/report/layout/properties_unknown-new__short-title' => 'Luo raporttiasettelu',
    'ui__admin/report/layout/properties_unknown-new__title' => 'Luo raporttiasettelu',
    'ui__admin/report/layout/properties_unknown-new__description' => 'Luo raporttiasettelu.',
    'ui__admin/report/layout/delete_multi__short-title' => 'Poista raporttiasettelut',
    'ui__admin/report/layout/delete_multi__title' => 'Poista raporttiasettelut',
    'ui__admin/report/layout/delete_multi__description' => 'Poista valitut raporttiasettelut',
    'ui__admin/report/layout/properties__short-title' => 'Ominaisuudet...',
    'ui__admin/report/layout/properties__title' => 'Raporttiasettelun ominaisuudet',
    'ui__admin/report/layout/properties__description' => 'Muokkaa raporttiasettelun ominaisuuksia.',

    // reseller
    'reseller_traffic_history__title' => "Jälleenmyyjän liikennehistoria %1",

    'ui__reseller/traffic__short-title' => '%1',
    'ui__reseller/traffic__title' => 'Katso liikenteen käyttöä kohteelle <b>%1</b>',
    'ui__reseller/traffic__description' => 'Näytä jälleenmyyjän tilisi %1 liikenteen käyttöä koskevat raportit.',
    'ui__reseller/traffic_self__short-title' => 'Oma',
    'ui__reseller/traffic_self__title' => 'Näytä asiakkaiden liikenteen kuormitus',
    'ui__reseller/traffic_self__description' => 'Näytä asiakastiliesi liikenteen käyttöä koskevat raportit.',

    'ui__reseller/report/traffic-history__short-title' => 'Näytä liikennehistoria',
    'ui__reseller/report/traffic-history__title' => 'Näytä liikennehistoria',
    'ui__reseller/report/traffic-history__description' => "Näytä jälleenmyyjän %1 liikennehistoria.",
    'ui__reseller/report/traffic-history_self__short-title' => 'Näytä liikennehistoria',
    'ui__reseller/report/traffic-history_self__title' => 'Näytä liikennehistoria',
    'ui__reseller/report/traffic-history_self__description' => 'Näytä liikennehistoria.',

    'ui__reseller/report/layout/auto_unknown__short-title' => 'Toimitusaikataulu',
    'ui__reseller/report/layout/auto_unknown__title' => 'Raportin toimitusaikataulu',
    'ui__reseller/report/layout/auto_unknown__description' => 'Valitse raportin toimitusaikataulu raporttiasettelua varten.',
    'ui__reseller/report/layout/auto/properties_new__short-title' => 'Lisää raportin toimitusaikataulu',
    'ui__reseller/report/layout/auto/properties_new__title' => 'Lisää raportin toimitusaikataulu',
    'ui__reseller/report/layout/auto/properties_new__description' => 'Lisää raportin toimitusaikataulu raportille %1.',
    'ui__reseller/report/layout/auto/properties__short-title' => 'Raportin toimitusaikataulu',
    'ui__reseller/report/layout/auto/properties__title' => 'Raportin toimitusaikataulu',
    'ui__reseller/report/layout/auto/properties__description' => 'Näytä raportin toimitusaikataulun ominaisuudet ja muokkaa niitä',
    'ui__reseller/report/layout/auto/delete_multi__short-title' => 'Poista raportin toimitusaikataulu',
    'ui__reseller/report/layout/auto/delete_multi__title' => 'Poista raportin toimitusaikataulu',
    'ui__reseller/report/layout/auto/delete_multi__description' => 'Poista valitut raportin toimitusaikataulut.',

    'ui__reseller/report/layout_unknown__short-title' => 'Raporttiasettelut',
    'ui__reseller/report/layout_unknown__title' => 'Raporttiasettelut',
    'ui__reseller/report/layout_unknown__description' => 'Näytä raporttiasettelut ja hallitse niitä.',
    'ui__reseller/report/layout/properties_unknown-new__short-title' => 'Luo raporttiasettelu',
    'ui__reseller/report/layout/properties_unknown-new__title' => 'Luo raporttiasettelu',
    'ui__reseller/report/layout/properties_unknown-new__description' => 'Luo raporttiasettelu.',
    'ui__reseller/report/layout/properties_new__short-title' => 'Luo raporttiasettelu',
    'ui__reseller/report/layout/properties_new__title' => 'Luo raporttiasettelu',
    'ui__reseller/report/layout/properties_new__description' => 'Luo raporttiasettelu.',
    'ui__reseller/report/layout/delete_multi__short-title' => 'Poista raporttiasettelut',
    'ui__reseller/report/layout/delete_multi__title' => 'Poista raporttiasettelut',
    'ui__reseller/report/layout/delete_multi__description' => 'Poista valitut raporttiasettelut',
    'ui__reseller/report/layout/properties__short-title' => 'Ominaisuudet...',
    'ui__reseller/report/layout/properties__title' => 'Raporttiasettelun ominaisuudet',
    'ui__reseller/report/layout/properties__description' => 'Muokkaa raporttiasettelun ominaisuuksia.',

    // customer
    'cl_traffic_history__title' => "Asiakkaan liikennehistoria %1",

    'ui__client/traffic__short-title' => '%1',
    'ui__client/traffic__title' => 'Katso liikenteen käyttöä kohteelle <b>%1</b>',
    'ui__client/traffic__description' => 'Näytä asiakastilisi %1 liikenteen käyttöä koskevat raportit.',
    'ui__client/traffic_self__short-title' => 'Liikenteen kuormitus',
    'ui__client/traffic_self__title' => 'Toimialueiden liikenteen kuormitus',
    'ui__client/traffic_self__description' => 'Näytä toimialueidesi liikenteen käyttöä koskevat raportit.',

    'ui__client/report/traffic-history__short-title' => 'Näytä liikennehistoria',
    'ui__client/report/traffic-history__title' => 'Näytä liikennehistoria',
    'ui__client/report/traffic-history__description' => 'Näytä asiakkaan %1 liikennehistoria.',
    'ui__client/report/traffic-history_self__short-title' => 'Näytä liikennehistoria',
    'ui__client/report/traffic-history_self__title' => 'Näytä liikennehistoria',
    'ui__client/report/traffic-history_self__description' => 'Näytä liikennehistoria.',

    // Web Statistics - ui__client/domain/report/web-stats__short-title (HOME)
    'ui__client/domain/report/web-stats-ssl__short-title' => 'Verkkosivuston suojattujen vierailujen tilastotiedot',
    'ui__client/domain/report/web-stats-ssl__title' => 'Sivustosi %1 suojattujen vierailujen tilastotiedot',
    'ui__client/domain/report/web-stats-ssl__description' => 'Sivustosi %1 suojattujen vierailujen tilastotiedot.',
    'ui__client/domain/report/web-stats-ssl_self__short-title' => 'Verkkotilastot SSL/TLS',
    'ui__client/domain/report/web-stats-ssl_self__title' => 'Verkkosivustosi suojattujen vierailujen tilastotiedot',
    'ui__client/domain/report/web-stats-ssl_self__description' => 'Verkkosivustosi suojattujen vierailujen tilastotiedot.',
    'ui__client/domain/report/ftp-stats__short-title' => 'FTP-tilastotiedot',
    'ui__client/domain/report/ftp-stats__title' => 'Toimialueen %1 FTP-tilastot',
    'ui__client/domain/report/ftp-stats__description' => 'Toimialueen %1 FTP-tilastot',
    'ui__client/domain/report/ftp-stats_self__short-title' => 'FTP-tilastotiedot',
    'ui__client/domain/report/ftp-stats_self__title' => 'Toimialueesi FTP-tilastotiedot',
    'ui__client/domain/report/ftp-stats_self__description' => 'Toimialueesi FTP-tilastotiedot.',
    'ui__client/domain/report/anon-ftp-stats__short-title' => 'Anonyymin FTP:n tilastotiedot',
    'ui__client/domain/report/anon-ftp-stats__title' => 'Toimialueen %1 anonyymit FTP-tilastot',
    'ui__client/domain/report/anon-ftp-stats__description' => 'Toimialueen %1 anonyymit FTP-tilastot',
    'ui__client/domain/report/anon-ftp-stats_self__short-title' => 'Anonyymin FTP:n tilastotiedot',
    'ui__client/domain/report/anon-ftp-stats_self__title' => 'Toimialueen %1 anonyymit FTP-tilastot',
    'ui__client/domain/report/anon-ftp-stats_self__description' => 'Toimialueen %1 anonyymit FTP-tilastot',

    'ui__client/domain/report/webalizer-preferences__short-title' => 'Webalizerin asetukset',
    'ui__client/domain/report/webalizer-preferences__title' => 'Webalizerin asetukset kohteelle %1',
    'ui__client/domain/report/webalizer-preferences__description' => 'Muokkaa Webalizerilla luotujen tilastoraporttien esitystä kohteelle %1.',
    'ui__client/domain/report/webalizer-preferences_self__short-title' => 'Webalizerin asetukset',
    'ui__client/domain/report/webalizer-preferences_self__title' => 'Webalizerin asetukset kohteelle %1',
    'ui__client/domain/report/webalizer-preferences_self__description' => 'Muokkaa Webalizerilla luotujen tilastoraporttien esitystä kohteelle %1.',

    ///
    /// END OF REPORT
    ///

    ///
    /// SUMMARY / FULL REPORT
    ///

    // common full report
    'report__full_p' => 'P',
    'report__full_s' => 'S',
    'report__full_h' => 'H',
    'report__full_reseller_name' => 'Jälleenmyyjän nimi', // reseller report
    'report__full_client_name' => 'Asiakkaan nimi', // customer report
    'report__full_domain_name' => 'Toimialueen nimi', // domain report
    'report__full_owner' => 'Omistaja', // customer & domain reports
    'report__full_creation_date' => 'Luontipäivä',
    'report__full_size' => 'Koko',
    'report__full_traffic' => 'Liikenne',
    'report__full_active_clients' => 'Aktiiviset asiakkaat', // reseller report
    'report__full_clients' => 'Asiakkaat', // reseller report
    'report__full_active_domains' => 'Aktiiviset toimialueet', // reseller & customer reports
    'report__full_domains' => 'Toimialueet', // reseller & customer reports
    'report__full_subdomains' => 'Alitoimialue',
    'report__full_mboxes' => 'MBoxes',
    'report__full_disk_space' => 'Levytila',
    'report__full_mail_groups' => 'MForw',
    'report__full_mail_autoresp' => 'Vast.',
    'report__full_mail_antispam' => 'ASpam',
    'report__full_mail_antivirus' => 'AVir',
    'report__full_mail_lists' => 'MailList',
    'report__full_web_users' => 'WebUsr',
    'report__full_mysql_databases' => 'MySQL-tietokanta',
    'report__full_mssql_databases' => 'MSSQL DB',

    // common summary report
    'report__section_general' => 'Yleiset',
    'report__version' => 'Tuoteversio',
    'report__build' => 'Tuotteen koontiversio',
    'report__status' => 'Tila',
    'report__company_name' => 'Yrityksen nimi',
    'report__personal_name' => 'Nimi',
    'report__login' => 'Käyttäjänimi',
    'report__phone' => 'Puhelin',
    'report__fax' => 'Faksi',
    'report__email' => 'Sähköposti',
    'report__address' => 'Osoite',
    'report__city' => 'Kaupunki',
    'report__state' => 'Osavaltio/Provinssi',
    'report__zip_code' => 'Postinumero',
    'report__country' => 'Maa',
    'report__creation_date' => 'Luontipäivä',
    'report__expiration_date' => 'Vanhentumispäivä',
    'report__dumps_total_size' => 'Varmuuskopiotiedoston koko yhteensä',
    'report__section_resellers' => 'Jälleenmyyjät',
    'report__active_resellers' => 'Jälleenmyyjät aktiivisilla tilauksilla',
    'report__resellers' => 'Jälleenmyyjät',
    'report__section_full_resellers' => 'Jälleenmyyjät',
    'report__section_clients' => 'Asiakkaat',
    'report__active_clients' => 'Asiakkaat, joilla on aktiivisia tilauksia',
    'report__clients' => 'Asiakkaat',
    'report__section_full_clients' => 'Asiakkaat',
    'report__section_personal_clients' => 'Omat asiakkaat',
    'report__active_personal_clients' => 'Omat asiakkaasi aktiivisilla tilauksilla',
    'report__personal_clients' => 'Omat asiakkaat',
    'report__section_full_personal_clients' => 'Omat asiakkaat',
    'report__section_domains' => 'Toimialueet',
    'report__disk_usage' => 'Levytilan käyttö',
    'report__traffic' => 'Liikenne',
    'report__active_domains' => 'Aktiiviset toimialueet',
    'report__domains' => 'Toimialueet',
    'report__subdomains' => 'Alitoimialueet',
    'report__mboxes' => 'Postilaatikot',
    'report__mail_groups' => 'Postin edelleenlähetykset',
    'report__mail_autoresp' => 'Automaattiset vastaukset',
    'report__mail_lists' => 'Postituslistat',
    'report__web_users' => 'Internet-käyttäjät',
    'report__mysql_databases' => 'MySQL-tietokannat',
    'report__mssql_databases' => 'MSSQL-tietokannat',
    'report__section_full_domains' => 'Toimialueet',
    'report__section_personal_domains' => 'Henkilökohtaiset toimialueet',
    // keys here are the same as in report__section_domains section
    'report__section_full_personal_domains' => 'Henkilökohtaiset toimialueet',

    //New for Plesk 10
    'report__sitebuilder_sites' => 'Presence Builderilla julkaistut sivustot',
    'report__invalid_email' => 'Anna kelvollinen sähköpostiosoite.',


    // CLI-specific sections
    'report__section_hosting' => 'Isännöinti',
    'report__section_webusers' => 'Internet-käyttäjät',
    'report__section_mailnames' => 'Sähköpostitilit',
    'report__section_maillists' => 'Postituslistat',
    'report__section_databases' => 'Tietokannat',
    'report__section_siteapps' => 'Verkkosovellukset',
    'report__section_aspnetapps' => 'ASP.NET-sovellukset', // PFW
    'report__owner_pname' => "Tarjoajan oma nimi",
    'report__owner_login' => "Tarjoajan käyttäjätunnus",

    ///
    /// END OF SUMMARY / FULL REPORT
    ///

    ////
    //// KEYS FOR VARIOUS FEATURES
    ////

    ///
    /// SERVER INTERFACE
    ///

    // Locales
    // errors
    'locales__not_allowed' => 'Annettu kielipakkaus on asennettu, mutta sitä ei ole otettu käyttöön järjestelmässä.',

    ///
    /// END OF SERVER INTERFACE
    ///

    ///
    /// HOME PAGE CUSTOMIZATION
    ///

    ///
    /// SESSIONS
    ///

    // Entry keys are under respective HP/ADDITIONAL TOOLS/ACTIVE SESSIONS

    // administrator
    'ui__sessions/delete__short-title' => 'Poista istunnot',
    'ui__sessions/delete__title' => 'Poista istunnot',
    'ui__sessions/delete__description' => 'Poista valitut istunnot.',
    'ui__ftp-sessions__short-title' => 'FTP-istunnot',
    'ui__ftp-sessions__title' => 'FTP-istunnot',
    'ui__ftp-sessions__description' => 'Näytä FTP-istunnot.',
    'ui__ftp-sessions/delete__short-title' => 'Poista FTP-istunnot.',
    'ui__ftp-sessions/delete__title' => 'Poista FTP-istunnot.',
    'ui__ftp-sessions/delete__description' => 'Poista valitut FTP-istunnot.',
    'ui__ts-sessions__short-title' => 'Päätepalveluistunnot',
    'ui__ts-sessions__title' => 'Päätepalveluistunnot',
    'ui__ts-sessions__description' => 'Näytä päätepalveluistunnot.',

    // reseller
    'ui__reseller/sessions/delete__short-title' => 'Poista istunnot',
    'ui__reseller/sessions/delete__title' => 'Poista istunnot',
    'ui__reseller/sessions/delete__description' => 'Poista valitut istunnot.',
    'ui__reseller/sessions/delete_self__short-title' => 'Poista istunnot',
    'ui__reseller/sessions/delete_self__title' => 'Poista istunnot',
    'ui__reseller/sessions/delete_self__description' => 'Poista valitut istunnot.',
    'ui__reseller/ftp-sessions__short-title' => 'FTP-istunnot',
    'ui__reseller/ftp-sessions__title' => 'FTP-istunnot',
    'ui__reseller/ftp-sessions__description' => 'Näytä FTP-istunnot.',
    'ui__reseller/ftp-sessions_self__short-title' => 'FTP-istunnot',
    'ui__reseller/ftp-sessions_self__title' => 'FTP-istunnot',
    'ui__reseller/ftp-sessions_self__description' => 'Näytä FTP-istunnot.',
    'ui__reseller/ftp-sessions/delete__short-title' => 'Poista FTP-istunnot.',
    'ui__reseller/ftp-sessions/delete__title' => 'Poista FTP-istunnot.',
    'ui__reseller/ftp-sessions/delete__description' => 'Poista valitut FTP-istunnot.',
    'ui__reseller/ftp-sessions/delete_self__short-title' => 'Poista FTP-istunnot.',
    'ui__reseller/ftp-sessions/delete_self__title' => 'Poista FTP-istunnot.',
    'ui__reseller/ftp-sessions/delete_self__description' => 'Poista valitut FTP-istunnot.',

    // customer
    'ui__client/sessions/delete__short-title' => 'Poista istunnot',
    'ui__client/sessions/delete__title' => 'Poista istunnot',
    'ui__client/sessions/delete__description' => 'Poista valitut istunnot.',
    'ui__client/sessions/delete_self__short-title' => 'Poista istunnot',
    'ui__client/sessions/delete_self__title' => 'Poista istunnot',
    'ui__client/sessions/delete_self__description' => 'Poista valitut istunnot.',

    // domain administrator

    'forgery_token_expired' => 'Istunnon tunnus on erääntynyt.',

    ///
    /// END OF SESSIONS
    ///

    ///
    /// USER ACCOUNT CONVERSION
    ///

    //
    // USER ACCOUNT TYPE CHANGES
    //

    // resellers > customers
    'downgradeResellers__downgrade_resellers' => 'Seuraavat jälleenmyyjän tilit muutetaan asiakastileiksi',
    'downgradeResellers__downgrade' => 'Muutettavat jälleenmyyjän tilit',
    // controls
    'downgradeResellers__submit_downgrade' => 'Suorita tilin muuntaminen.',
    'downgradeResellers__cancel_downgrade' => 'Peruuta tilin muuntaminen.',
    'downgradeResellers__confirm' => 'Vahvista muuntaminen',
    'downgradeResellers__confirm_message' => 'Vahvista tilin muuntaminen jatkaaksesi',
    // errors

    // customers > resellers
    'picker_client_multi__title' => 'Valitse asiakastilit',
    'upgradeClients__upgrade_clients' => 'Seuraavat asiakastilit muutetaan jälleenmyyjän tileiksi',
    'upgradeClients__upgrade' => 'Asiakastilit, jotka muutetaan',
    // controls
    'upgradeClients__submit_upgrade' => 'Suorita tilin muuntaminen.',
    'upgradeClients__cancel_upgrade' => 'Peruuta tilin muuntaminen.',
    'upgradeClients__confirm' => 'Vahvista muuntaminen',
    'upgradeClients__confirm_message' => 'Vahvista tilin muuntaminen jatkaaksesi',
    // errors
    'upgradeClient__user_is_already_reseller' => 'Tiliä \'%1\' ei voida muuttaa jälleenmyyjän tiliksi: \'%1\' on jo jälleenmyyjä.',

    // domain administrators > customers
    'upgradeDomainUser__upgrade_domain_users' => 'Seuraavat toimialueen järjestelmänvalvojan tilit muutetaan asiakastileiksi',
    'upgradeDomainUser__upgrade' => 'Toimialueen järjestelmänvalvojan tilit, jotka muutetaan',
    // controls
    'upgradeDomainUser__submit_upgrade' => 'Suorita tilin muuntaminen.',
    'upgradeDomainUser__cancel_upgrade' => 'Peruuta tilin muuntaminen.',
    'upgradeDomainUser__confirm' => 'Vahvista muuntaminen',
    'upgradeDomainUser__confirm_message' => 'Vahvista tilin muuntaminen jatkaaksesi',
    // errors
    'upgradeDomainUser__non_upgradeable' => 'Toimialueen järjestelmänvalvojan tilit, joita ei voida muuttaa',
    'upgradeDomainUser__non_upgradeable_domain_users' => 'Seuraavia toimialueen järjestelmänvalvojan tilejä ei voitu muuttaa asiakastileiksi:',
    'upgradeDomainUser__some_domains_were_not_converted' => 'Useita toimialueen järjestelmänvalvojan tilejä ei voitu muuttaa asiakastileiksi. %%domainsList%%',
    'upgradeDomainUser__domain_user_does_not_exist' => 'Toimialueen järjestelmänvalvojan tiliä ei ole.',
    'upgradeDomainUser__domain_owner_must_be_a_reseller' => "Toimialueen tulee kuulua suoraan palvelimen järjestelmänvalvojalle tai jälleenmyyjälle.",
    'upgradeDomainUser__all_logins_already_used' => 'Tiliä ei voida luoda lopulliselle asiakkaalle.',
    // notifications
    'upgradeDomainUser__upgrade_notification_subject' => 'Toimialueen järjestelmänvalvojan tili muutettiin',
    'upgradeDomainUser__upgrade_notification_body' => 'Toimialueen järjestelmänvalvojan tilisi muutettiin asiakastiliksi käyttäjätunnuksella \'%%login%%\' ja salasanalla \'%%password%%\'.',

    //
    // USER ACCOUNT OWNER CHANGES
    //

    // Customer owner change
    // wizard title
    'ui__client/chowner_unknown__wizard-title' => 'Määritä asiakastilille %1 uusi omistaja', // customer home
    'ui__client/chowner_multi__wizard-title' => 'Määritä valituille asiakastileille uusi omistaja', // list of customers
    'ui__reseller/client/chowner_multi__wizard-title' => 'Määritä valituille käyttäjätileille uusi omistaja', // reseller & admin home
    // customers selection - reseller & admin home
    'picker_client__title' => 'Valitse asiakastilit',
    'ui__reseller/client/chowner_multi__wizard__2_multi' => 'Valitse asiakastilit, jotka haluat siirtää toiselle omistajalle.',
    //  owner selection
    'client_chown__select_title' => 'Valitse asiakastilin uusi omistaja',
    'client_chown__select-multi_title' => 'Valitse asiakastilien uusi omistaja',
    'ui__reseller/client/chowner_multi__wizard__2_multi-select' => "Valitse valituille asiakastileille uusi omistaja.", // customer home
    'ui__client/chowner_multi__wizard__2_multi-select' => 'Valitse valituille asiakastileille uusi omistaja.', // customers list
    'ui__reseller/client/chowner_multi__wizard__3_multi-select' => 'Valitse valituille asiakastileille uusi omistaja.', // reseller & admin home
    // changes check page
    'client_chown__check_title' => 'Tarkista muutokset ja lopeta ohjattu toiminto',
    'ui__client/chowner__wizard__2' => 'Tarkista muutokset ja suorita ohjattu toiminto loppuun valitsemalla Valmis.', // customer home
    'ui__client/chowner_multi__wizard__2_multi' => 'Tarkista muutokset ja suorita ohjattu toiminto loppuun valitsemalla Valmis.', // customers list
    'ui__reseller/client/chowner_multi__wizard__3_multi' => 'Tarkista muutokset ja suorita ohjattu toiminto loppuun valitsemalla Valmis.', // admin "accounts" dropdown:
    // errors
    'client_chown__empty_selection' => 'Sinun on valittava valittujen asiakastilien uusi omistaja',
    'clientOwnerChanger__unable_to_transfer_some_clients' => 'Yhtä tai useampaa valituista käyttäjätileistä ei voida siirtää uudelle omistajalle.',
    'client_chown__client_warn' => 'Kuvaus',

    'clientOwnerChanger__owner_has_no_permission' => 'Valitulla jälleenmyyjällä ei ole lupaa \'%1\', mutta joillakin asiakkailla on kyseinen lupa.',
    'clientOwnerChanger__application_not_allowed' => 'Sovellus \'%1\' ei ole valitun jälleenmyyjän saatavilla, se on kuitenkin joidenkin asiakkaiden saatavilla.',

    // Domain owner change
    'ui__client/domain/chowner_multi-select__wizard-title' => 'Varataan valitut tilaukset uudelleen',
    // errors
    'domain_chown__empty_selection' => 'Sinun on valittava valittujen toimialueiden uusi omistaja',



    //
    // USER ACCOUNT STATE CHANGES
    //


    ///
    /// END OF USER ACCOUNT CONVERSION
    ///

    ///
    /// BANDWIDTH LIMITING
    ///

    'hosting_performance__title' => 'Suorituskyky',
    'hosting_performance__traffic_bandwidth_legend' => 'Ota käyttöön kaistanleveyden rajoitus',
    'hosting_performance__traffic_bandwidth_legend_ro' => 'Kaistanleveysrajoitus',
    'hosting_performance__traffic_bandwidth_label' => 'Maksimaalinen kaistanleveyden käyttö (%1)',
    'hosting_performance__traffic_bandwidth_hint' => 'Kaistanleveyden käyttöraja koskee ainoastaan HTTP-protokollan kautta siirrettyjä tietoja.',
    'hosting_performance__max_connection_legend' => 'Ota käyttöön yhteyksien rajoitus',
    'hosting_performance__max_connection_legend_ro' => 'Yhteyksien rajoitus',
    'hosting_performance__max_connection_label' => 'Yhteyksien rajoitus',
    'hosting_performance__max_connection_hint' => 'Jos rajoitat kaistanleveyden käyttöä, suosittelemme rajoittamaan myös sivuston samanaikaisten yhteyksien määrää. Muutoin verkkopalvelimen prosessit lisäävät palvelimen kuormitusta, jos sivustoon kohdistuu usein pyyntöjä.',

    // errors:
    'performance__qos_not_installed' => 'Toiminto poistettu käytöstä, koska QoS:ta ei ole asennettu',
    'performance__bandwidth_throttling' => 'Et voi hallita kaistanleveyden rajoituksia, koska QoS:aa ei ole asennettu.',
    'performance__invalid_value' => "Arvo on virheellinen. Arvon on oltava %1-%2.",

    ///
    /// END OF BANDWIDTH LIMITING
    ///

    ///
    /// WEBMAIL SELECTION (these keys are currently PfU-only)
    ///

    'webmail__server_legend' => 'WWW-sähköpostipalvelu',
    'webmail__server_text' => 'Saatavilla olevat verkkosähköpostiasiakkaat',
    'webmail__none' => 'Ei ole',

    ///
    /// END OF WEBMAIL SELECTION
    ///


    ////
    //// BACKUP/RESTORATION
    ////

    // random common keys:
    'backup__ip_mapping__server_ip' => 'Palvelimen IP-ryhmä',

    ///
    /// END OF BACKUP MANAGER ACTIONS
    ///

    ///
    /// LISTS
    ///


    // Common info/errors:
    'migration_db_server_not_find' => 'Tietokantaa ei palauteta: hyväksyttävää tietokantapalvelinta ei ole',

    ///
    /// END OF LISTS
    ///

    ///
    /// COMMON SCREENS
    ///

    // Back Up
    // Comments - __comments
    '__default_backup_comment_server' => "Palvelimen varmuuskopioiminen.",
    '__default_backup_comment_reseller' => "Jälleenmyyjän tilin varmuuskopion on luonut %1.",
    '__default_backup_comment_client' => "Asiakastilin varmuuskopion on luonut %1.",
    '__default_backup_comment_domain' => "Tilauksen varmuuskopion on luonut %1.",

    // Restoration & backup information

    // IP mapping
    'backup__ip_mapping__title' => 'Määritä IP-osoitteiden määritykset',
    'backup__ip_mapping__download' => 'Tallenna nykyinen IP-määritys tiedostoon',
    'b_backup__ip_mapping__download' => 'Lataa IP-määritykset napsauttamalla.',
    'b_backup__ip_mapping__download_is_empty' => 'IP-määritykset ovat tyhjät.',
    'backup__ip_mapping_upload__title' => 'Lataa IP-yhdistämistiedosto',
    'backup__ip_mapping__upload' => 'Lataa IP-yhdistämistiedosto',
    'b_backup__ip_mapping__upload' => 'Lataa IP-määritykset napsauttamalla.',
    'backup__ip_mapping__list__header' => 'IP-määritys',
    'backup__ip_mapping__list__adddress' => 'Vanhat IP-osoitteet',
    'backup__ip_mapping__list__select_ip' => 'Uudet IP-osoitteet',
    'backup__ip_mapping__clients_ip' => "Asiakkaan %1 IP-sarja",
    'backup__ip_mapping__resellers_ip' => "Jälleenmyyjän %1 IP-sarja",
    'backup__ip_mapping__exclusive_ip_must_be_unique' => 'Varatut IP-osoitteet tulee määrittää yksilöllisiin IP-osoitteisiin. Valitse yksilöllinen IP-osoite kaikkiin luettelon varattuihin IP-osoitteisiin.',
    'backup__ip_mapping__legend' => 'IP-määritys',
    'backup__ip_mapping__upload_legend' => 'Lataa palvelimeen',
    'backup__ip_mapping__upload_file_text' => 'IP-määritystiedosto',
    'backup__ip_mapping__upload_file_hint' => 'IP-määritystiedosto on tekstitiedosto. Tämän tiedoston kukin rivi sisältää IP-määrityksen seuraavassa muodossa: <vanha IP-osoite> <uusi IP-osoite>',
    'backup__ip_mapping__ip_address_not_found' => 'Saatavilla ei ole tämän tyyppisiä vapaita IP-osoitteita.',
    'backup__ip_mapping__ip_address_not_found_hint' => 'Tiedonsiirtoa ei voida suorittaa: IP-osoitteiden määritys on puutteellinen, koska vapaita IP-osoitteita ei ole kohdepalvelimen sarjassa.',
    'backup__ip_mapping__ftp_will_be_disabled' => 'Suojaamattomat FTPS-yhteydet ovat kiellettyjä toimialueille, joilla on tämä IP-osoite.',
    'backup__ip_mapping__ftps_will_be_disabled' => 'Suojatut FTPS-yhteydet ovat kiellettyjä toimialueille, joilla on tämä IP-osoite.',

    // Conflicts occured
    'legend_conflicts_occured' => 'Ristiriidat',
    'backup__restore__object_vhost' => 'Näennäisisäntä',
    'backup__restore__object_plesk_admin' => 'Pleskin järjestelmänvalvoja',
    'backup__restore__object_ftpuser' => 'FTP-tili',
    'backup__restore__object_frontpageuser' => 'FrontPage-tili',
    'backup__restore__object_webuser' => 'Internet-käyttäjä',
    'backup__restore__object_domain' => 'toimialue',
    'backup__restore__object_subdomain' => 'alitoimialue',
    'backup__restore__object_domainalias' => 'toimialueen alias',
    'backup__restore__object_client' => 'asiakas',
    'backup__restore__object_reseller' => 'jälleenmyyjä',
    'backup__restore__object_autoresponder' => 'Automaattinen vastaus',
    'backup__restore__object_mailalias' => 'sähköpostin alias',
    'backup__restore__object_database' => 'tietokanta',
    'backup__restore__object_mailname' => 'sähköpostitili',
    'backup__restore__object_db_user' => 'tietokannan käyttäjä',
    'backup__restore__object_ssl_certificate' => 'SSL/TLS-varmenne',
    'backup__restore__resellers_cannot_restore_converted_to_customers' => 'Seuraavia jälleenmyyjiä ei voida palauttaa, koska ne muutetaan asiakkaiksi: \'%1\'.',
    'backup__restore__customers_cannot_restore_converted_to_resellers' => 'Seuraavia asiakkaita ei voida palauttaa, koska ne muutetaan jälleenmyyjiksi: \'%1\'.',
    'backup__restore__customers_cannot_restore_moved_to_another_owners' => 'Seuraavia asiakkaita ei voida palauttaa, koska ne siirretään toiselle omistajalle: \'%1\'.',

    // Before migration starts
    'backup__restore__capability_not_enough_disk_text' => 'Kohdepalvelimella ei ole riittävästi levytilaa kaikkien valittujen tilauksien siirtoa varten. Käytettävissä: %1 Mt. Edellytys: %2 Mt. Vaadittu tila lasketaan toimialueiden verkkosisällön, postin ja tietokannan sisältöjen kokonaismäärästä. Vaadittu tila lasketaan kerran päivässä ja se tallennetaan välimuistiin, toimialueiden todellinen koko voi täten poiketa hiukan lasketusta koosta. Jos varmistat, että valitut toimialueet eivät vie enemmän tilaa kuin on käytettävissä, voit aloittaa siirron.',
    'backup__restore__capability_not_enough_disk_resolution' => 'Vapauta levytilaa kohdepalvelimella.',
    'backup__restore__capability_source_not_enough_disk_text' => 'Lähdepalvelimella ei ole riittävästi levytilaa väliaikaisten tiedostojen tallentamiseksi siirtoa varten. Käytettävissä: %1 Mt. Edellytys: %2 Mt.',
    'backup__restore__capability_source_not_enough_disk_resolution' => 'Vapauta levytilaa lähdepalvelimella.',
    'backup__restore__capability_not_enough_disk_resolution_url_text' => 'Palvelimen tiedot',

    'backup__restore__capability_not_installed_component_text' => 'Osaa %1 ei ole asennettu kohdepalvelimeen. %1 ei ole käytettävissä kaikkiin palautettuihin kohteisiin.',
    'backup__restore__capability_not_installed_component_resolution' => 'Asenna %1. Tämä voi viedä joitakin minuutteja.',
    'backup__restore__capability_existing_sys_user_text' => 'Järjestelmäkäyttäjä %1 on jo olemassa kohdepalvelimella.',
    'backup__restore__capability_existing_sys_user_resolution' => 'Nimeä olemassa oleva järjestelmäkäyttäjä uudelleen kohdepalvelimella.',
    'backup__restore__capability_license_usage_text' => 'Seuraavat resurssirajat (käyttöoikeusavaimen määrittämä) ylitetään kohdepalvelimella tiedonsiirron jälkeen:',
    'backup__restore__capability_license_usage_resolution' => 'Asenna kohdepalvelimelle toinen käyttöoikeusavain, joka tarjoaa vaaditun määrän resursseja.',
    'backup__restore__capability_max_allowed_packet_text' => "'max_allowed_packet' -parametri lähdetietokantapalvelimella on %1, se on kohdepalvelimen arvoa %2 suurempi. Joitakin alla määritettyjen toimialueiden tietokantakohteita ei välttämättä palauteta.",
    'backup__restore__capability_max_allowed_packet_resolution' => "Aseta arvo 'max_allowed_packet' suuremmaksi kohdetietokantapalvelimella.",

    'backup__restore__capability_postgres_to_lower_version_text' => 'PostgreSQL-tietokantoja ei voida siirtää, koska PostgreSQL-versio kohdepalvelimella on lähdepalvelimen versiota aikaisempi. Nykyinen versio on %1, tarvittava versio on %2.',
    'backup__restore__capability_postgres_to_lower_version_text_resolution' => 'Asenna PostgreSQL:n vaadittu versio kohdepalvelimelle.',
    'backup__restore__capability_db_server_connection_problems' => 'Kohteen PostgreSQL-tietokantapalvelimelle ei saada yhteyttä. Tietokantoja ei siirretä, ellet palauta yhteyttä.',
    'backup__restore__capability_db_server_connection_problems_resolution' => 'Tarkista yhteyden asetukset kohdetietokantapalvelimella.',
    'backup__restore__capability_component_not_enabled_server_wide_text' => 'Komponentti %1 on pois käytöstä kohdepalvelimessa.',
    'backup__restore__capability_component_not_enabled_server_wide_resolution' => 'Ota %1 käyttöön kohdepalvelimella.',
    'backup__restore__capability_not_configured_component_text' => 'Osaa %1 ei ole määritetty kohdepalvelimessa.',
    'backup__restore__capability_not_configured_component_resolution' => 'Määritä %1 sivulla Työkalut & Asetukset.',

    'backup__restore__capability_webmail_is_not_available' => 'Verkkosähköpostipalvelu %1 ei ole saatavilla kohdepalvelimessa. Plesk tulee käyttämään sen sijaan seuraavaa verkkosähköpostipalvelua: %2.',
    'backup__restore__capability_webmail_is_not_available_resolution' => 'Voit käyttää samaa verkkosähköpostia kuin lähdepalvelin asentamalla se tähän palvelimeen.',
    'backup__restore__capability_webmail_is_not_installed_resolution' => 'Lähdepalvelimen mukaisen verkkosähköpostin käyttämiseksi se tulee asentaa kohdepalvelimelle.',
    'backup__restore__capability_webmail_is_not_available_changed_on_subscriptions' => "Verkkosähköposti '%1' ei ole saatavilla kohdepalvelimessa. Seuraavissa tilauksissa: %3, Plesk tulee käyttämään sen sijaan seuraavaa verkkosähköpostipalvelua: %2.",
    'backup__restore__capability_webmail_is_not_installed_custom_resolution' => 'Asenna vaadittu verkkosähköposti kohdepalvelimelle.',
    'backup__restore__capability_webmail_is_not_available_url_text' => 'Verkkosähköpostin asetukset',

    'backup__restore__capability_shell_is_not_available' => 'Liittymää %1 ei löydy kohdepalvelimesta. Sen sijaan asennetaan yksi saatavilla olevista liittymistä.',
    'backup__restore__capability_shell_is_not_available_resolution' => 'Lähdepalvelimen mukaisen liittymän käyttämiseksi se tulee ottaa käyttöön (/etc/shells) tai asentaa kohdepalvelimelle.',

    'backup__restore__capability_acl_network_not_allowed_dns_template' => 'DNS-kohdepalvelin ei tue siirtorajoitusmallin verkkoja. Tietueita, joilla on IP-osoitteita DNS-siirtorajoituksissa, ei palauteta.',
    'backup__restore__capability_acl_network_not_allowed_dns_zone' => 'DNS-kohdepalvelin ei tue siirtorajoitusmallin verkkoja, mutta joissakin tilauksissa on verkkoja DNS-siirtorajoituksissa. Tietueita, joilla on IP-osoitteita DNS-siirtorajoituksissa, ei palauteta.',

    'backup__restore__capability_wrong_php_handler_text' => 'PHP-käsittelijä %1 ei ole saatavilla kohdepalvelimessa. Plesk tulee käyttämään sen sijaan seuraavaa PHP-käsittelijää: %2.',
    'backup__restore__capability_wrong_php_handler_resolution' => 'Lähdepalvelimen mukaisen PHP-käsittelijän käyttämiseksi se tulee ottaa käyttöön tai asentaa kohdepalvelimelle.',
    'bu_conflict_resolver_php_handler_replaced_in_plans' => 'PHP-käsittelijää %1 ei ole saatavilla. Sen sijaan Plesk käyttää %2 seuraaviin palvelumalleihin: {{objects}}',
    'bu_conflict_resolver_php_handler_replaced_in_sites' => 'PHP-käsittelijää %1 ei ole saatavilla. Sen sijaan Plesk käyttää %2 seuraavien verkkosivustojen kohdalla: {{objects}}',
    'bu_conflict_resolver_php_handler_not_allowed_in_sites' => 'PHP-käsittelijä %1 ei ole saatavilla. Se ei ole käytössä seuraaville verkkosivustoille: {{objects}}',

    'backup__restore__capability_wrong_component_version_text' => 'Kohdetta %1 %2 ei löydy kohdepalvelimesta. Sen sijasta käytetään oletusversiota.',
    'backup__restore__capability_wrong_component_version_resolution' => 'Lähdepalvelimen mukaisen %1 käyttämiseksi se tulee ottaa käyttöön tai asentaa kohdepalvelimelle.',

    'backup__restore__capability_antivirus_not_allowed_outgoing_text' => 'Kohdepalvelimen virustentorjunnan käyttöä koskeva käytäntö ei salli henkilökohtaisten (sähköpostiosoitetta kohti) virustentorjunta-asetuksien asettamista lähtevälle postille. Näitä asetuksia ei siirretä.',
    'backup__restore__capability_antivirus_not_allowed_incoming_text' => 'Kohdepalvelimen virustentorjunnan käyttöä koskeva käytäntö ei salli henkilökohtaisten (sähköpostiosoitetta kohti) virustentorjunta-asetuksien asettamista saapuvalle postille. Näitä asetuksia ei siirretä.',
    'backup__restore__capability_antivirus_not_allowed_personal_settings_text' => 'Kohdepalvelimen virustentorjunnan käyttöä koskeva käytäntö ei salli henkilökohtaisten (sähköpostiosoitetta kohti) virustentorjunta-asetuksien asettamista. Näitä asetuksia ei siirretä.',
    'backup__restore__capability_antivirus_not_allowed_personal_settings_resolution' => "Voit siirtää hankilökohtaiset (sähköpostiosoitetta kohti) virustentorjunta-asetukset ottamalla käyttöön vastaavan valinnan asetuksissa Työkalut & Asetukset > Virustentorjunnan asetukset.",
    'backup__restore__capability_antivirus_not_active_text' => 'Virustentorjuntaohjelmaa ei ole käynnistetty. Kaikki lähdepalvelimen virustentorjunta-asetukset eivät toimi, ennen kuin valitset virustentorjuntaohjelman kohdepalvelimelta.',
    'backup__restore__capability_antivirus_not_active_resolution' => 'Valitse virustentorjuntaohjelmisto osiossa Työkalut & Asetukset > Virustentorjunnan asetukset > Virustentorjuntaohjelmien asetukset.',

    'backup__restore__capability_antivirus_another_active_text' => 'Virustentorjuntaohjelmisto %2 ei ole saatavilla kohdepalvelimessa. sen sijaan tullaan käyttämään kohdetta %1.',
    'backup__restore__capability_antivirus_another_active_resolution' => 'Voit käyttää samaa virustentorjuntaa kuin lähdepalvelimessa asentamalla sen ja valitsemalla sen osiossa Työkalut & Asetukset > Virustentorjunnan asetukset > Virustentorjuntaohjelmien asetukset.',
    'backup__restore__capability_not_available_sni_text' => 'SNI ei ole käytettävissä kohdepalvelimessa. Samaa IP-osoitetta käyttävät verkkosivustot eivät voi käyttää erillisiä SSL/TLS-varmenteita.',
    'backup__restore__capability_not_available_sni_resolution' => "Tarkista, että kohdepalvelimen käyttöjärjestelmä tukee SNI:a ja että SNI-tuki on otettu käyttöön Pleskissa (ruutu 'Ota käyttöön SNI-tuki, joka mahdollistaa yksittäisten SSL/TLS-varmisteiden käyttämisen saman IP-osoitteen omaavissa verkkosivustoissa' osiossa Työkalut & Asetukset> Palvelimen asetukset).",
    'backup__restore__capability_not_available_sni_resolution_url_text' => 'Palvelimen asetukset',

    'backup__restore__capability_vhost_already_exists_text' => 'Verkkosivustoa %1 ei voida siirtää: samanniminen verkkosivusto on jo olemassa kohdepalvelimella.',
    'backup__restore__capability_vhost_already_exists_resolution' => 'Nimeä verkkosivusto uudelleen tai poista samanniminen verkkosivusto palvelimelta.',
    'backup__restore__capability_removed_vhosts' => 'Seuraavia tilauksia ei siirretä, koska ne sisältävät kohdepalvelimella jo olemassa olevat toimialueen nimet: %1',
    'backup__restore__capability_duplicate_php_handler_text' => 'Lähdepalvelimella on %3 eri PHP-käsittelijää, joiden tyyppi on %1 ja versio %2. Niiden sijaan käytetään yhtä tyypiltään ja versioltaan sopivaa käsittelijää kohdepalvelimella. Lähde- ja kohdepalvelimen PHP-asetukset voivat poiketa toisistaan.',

    'backup__restore__capability_not_installed_frontpage_resolution' => 'Plesk Installer ei tue Microsoft FrontPage -ohjelmaa.',
    'backup__restore__capability_not_installed_python_resolution' => 'Plesk Installer ei tue Microsoft Python -ohjelmaa. Asenna Python manuaalisesti.',

    'backup__restore__capability_mail_spamfilter_domain_keys_resolution_url_text' => 'Postipalvelimen asetukset',

    'backup__restore__capability_ftps_disabled' => 'Suojatun FTPS:n käyttö on sallittua lähdepalvelimella, mutta kiellettyä kohdepalvelimella.  Käyttäjän sovellukset, jotka käyttävät FTP:tä, eivät välttämättä toimi oikein.',
    'backup__restore__capability_ftps_required' => 'Suojaamattoman FTP:n käyttö on sallittua lähdepalvelimella, mutta kiellettyä kohdepalvelimella. Käyttäjän sovellukset, jotka käyttävät FTP:tä, eivät välttämättä toimi oikein.',
    'backup__restore__capability_ftps_policy_resolution' => 'Muuta suojattua FTP-käytäntöä\' asetuksissa Työkalut & Asetukset > Suojauskäytäntö.',

    'backup__restore__capability_too_much_download_time_text' => '%1 megatavua tietoa siirretään lähdepalvelimelta kohdepalvelimelle %2 tunnissa.',
    'backup__restore__capability_too_much_download_time_resolution' => 'Mahdollistaaksesi nopeamman siirron tarkista lähde- ja kohdepalvelimen välinen verkkoyhteys ja selvitä ongelmat, jos niitä ilmenee.',
    'backup__restore__too_low_download_speed' => "pienempi kuin 0,01",
    'backup__restore__capability_too_slow_download_speed_resolution' => 'Mahdollistaaksesi nopeamman siirron tarkista lähde- ja kohdepalvelimen välinen verkkoyhteys ja selvitä ongelmat, jos niitä ilmenee.',
    'backup__restore__capability_zero_download_speed_text' => 'Alhaisin hyväksyttävä lataamisnopeus on %1 Mt/s.  Latausnopeus lähde- ja kohdepalvelimen välillä on 0 MBps. Tämä voi johtua verkkoyhteysongelmista. Siirtoa ei voi tehdä.',
    'backup__restore__capability_zero_download_speed_resolution' => 'Tarkista lähde- ja kohdepalvelimien välinen verkkoyhteys ja ratkaise ongelmat.',
    'backup__restore__capability_too_slow_download_speed_text' => 'Alhaisin hyväksyttävä lataamisnopeus on %2 Mt/s. Latausnopeus lähde- ja kohdepalvelimen välillä on %1 MBps. Tämä voi lisätä siirtoaikaa. Nykyisessä ympäristössä %3 Mt siirto vie %4 tuntia.',
    'backup__restore__capability_too_slow_download_speed_text_without_diskusage' => 'Alhaisin hyväksyttävä lataamisnopeus on %2 Mt/s. Latausnopeus lähde- ja kohdepalvelimen välillä on %1 MBps. Tämä voi lisätä siirtoaikaa.',

    'backup__restore__capability_remote_database_migration' => "Seuraavat toimialueet käyttävät etätietokantoja: %1",
    'backup__restore__capability_remote_database_migration_resolution' => "Älä poista kyseisiä toimialueita lähdepalvelimelta siirron jälkeen, jos Plesk -versio lähdepalvelimella on versiota 11.5 aikaisempi! Keskeytä ne sen sijaan. Jos poistat toimialueet, tietokannat poistetaan etäpalvelimelta. Huomaa: etätietokantojen vedostiedostot palautetaan lähdepalvelimelle hakemistossa %1.",

    'backup__restore__capability_mysql_50_to_51_migration' => 'Versiota 5.1 (%1) aikaisempien MySQL-tietokantapalvelimien varmuuskopiointitiedostoja ei välttämättä palauteta kohteeseen MySQL 5.1.x, koska MySQL 5.1.x käsittelee Unicode-merkit eri tavalla.',
    'backup__restore__capability_mysql_50_to_51_migration_resolution' => '',
    'backup__restore__capability_mysql_50_to_51_migration_kb_link_title' => 'Lue vastaava Kowledge Base -artikkeli #136850',

    'backup__restore__capability_firewall_not_installed_text' => 'Palomuurin laajennusta ei ole asennettu kohdepalvelimeen. Jos määrität käyttörajoituksen sääntöjä, säännöt eivät toimi.',
    'backup__restore__capability_firewall_not_installed_resolution' => 'Asenna palomuurin laajennus käyttämällä Plesk -asennusohjelmaa.',
    'backup__restore__capability_courier_not_installed_text' => 'Courier-IMAP:ia ei ole asennettu kohdepalvelimeen.',
    'backup__restore__capability_courier_not_installed_resolution' => 'Asenna Courier-IMAP käyttämällä Plesk -asennusohjelmaa.',
    'backup__restore__capability_dovecot_not_installed_text' => 'Dovecotia ei ole asennettu kohdepalvelimeen.',
    'backup__restore__capability_dovecot_not_installed_resolution' => 'Asenna Dovecot käyttämällä Plesk -asennusohjelmaa.',

    'backup__restore__wrong_stat_ttl_value_text' => 'Seuraavien kohteiden määrityksien liikenteen tilastotietojen säilytysaika on pienempi kuin palvelimen laajuinen arvo kohdepalvelimella.',
    'backup__restore__wrong_stat_ttl_value_resolution' => 'Muuta kohdepalvelimen tilastotietojen säilytysaikaa koskevaa palvelimen laajuista arvoa. Aseta ajaksi arvo, joka on yhtä suuri tai pienempi kuin toimialueen määrityksien pienin arvo.',
    'bu_conflict_resolver_wrong_stat_ttl_value' => 'Liikennetilastotietojen säilytysaika joillakin toimialueilla on pienempi kuin palvelimen laajuinen arvo (%1). Arvo muutetaan näiden toimialueiden kohdalla arvoon %1.',
    'bu_conflict_resolver_wrong_stat_ttl_template_value' => 'Liikennetilastotietojen säilytysaika joissakin palvelusuunnitelmissa on pienempi kuin palvelimen laajuinen arvo (%1). Arvo muutetaan näiden palvelusuunnitelmien kohdalla arvoon %1.',

    'backup__ip_mapping__map_dedicated_to_shared_ip' => 'Ainutkertaisen IP-osoitteen määritys jaetulle poistaa käytöstä anonyymin FTP:n ja HTTPS:n (ellei SNI-tuki ole kytketty toimintaan).',

    'backup__restore__no_postgresql_commands_text' => 'Tilaus käyttää PostgreSQL-etätietokantaa, sen väliaikaista varmuuskopiointitiedostoa ei voida luoda, koska pg_dump ja psql -komennot puuttuvat lähdepalvelimelta.',
    'backup__restore__no_postgresql_commands_resolution' => 'Asenna PostgreSQL-asiakaspaketti, joka tukee näitä komentoja.',
    'backup__restore__capability_apache_modules_disabled_text' => 'Seuraavat Apache-moduulit on poistettu käytöstä kohdepalvelimella: %1.',
    'backup__restore__capability_apache_modules_disabled_resolution' => 'Ota kyseiset moduulit käyttöön estääksesi mahdolliset ongelmat.',
    'backup__restore__capability_apache_modules_not_installed_text' => 'Seuraavia Apache-moduuleja ei ole asennettu kohdepalvelimella: %1.',
    'backup__restore__capability_apache_modules_not_installed_resolution' => 'Asenna ja ota kyseiset moduulit käyttöön estääksesi mahdolliset ongelmat.',

    'backup__restore__capability_license_not_supported_outgoing_antispam' => 'Käyttöoikeutesi ei tue lähtevien viestien rajoitusta. Vastaavia määritysasetuksia ei siirretä.',
    'backup__restore__capability_license_not_supported_outgoing_antispam_resolution' => 'Asenna kohdepalvelimelle toinen käyttöoikeusavain, joka tarjoaa vaaditut ominaisuudet.',
    'backup__restore__capability_disabled_outgoing_antispam' => 'Lähtevien viestien rajoitus on pois käytöstä kohdepalvelimessa.  Vastaavia määritysasetuksia ei siirretä.',
    'backup__restore__capability_disabled_outgoing_antispam_resolution' => 'Ota lähtevien viestien rajoitus käyttöön kohdepalvelimella.',
    'backup__restore__capability_disabled_outgoing_antispam_resolution_url_text' => 'Palvelimenlaajuiset postiasetukset',

    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported' => 'Kohdepalvelimella käytössä oleva postipalvelin ei tue postilaatikosta lähtevien viestien rajoitusta. Tämän rajoituksen arvoa ei siirretä.',
    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported_resolution' => 'Muuta postipalvelin lähdepalvelimella käytössä olevaan postipalvelimeen.',
    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported_resolution_url_text' => 'Palvelimenlaajuiset postiasetukset',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported' => 'Kohdepalvelimella käytössä oleva postipalvelin ei tue toimialueelta lähtevien viestien rajoitusta. Tämän rajoituksen arvoa ei siirretä.',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported_resolution' => 'Muuta postipalvelin lähdepalvelimella käytössä olevaan postipalvelimeen.',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported_resolution_url_text' => 'Palvelimenlaajuiset postiasetukset',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported' => 'Kohdepalvelimella käytössä oleva postipalvelin ei tue tilauksesta lähtevien viestien rajoitusta. Tämän rajoituksen arvoa ei siirretä.',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported_resolution' => 'Muuta postipalvelin lähdepalvelimella käytössä olevaan postipalvelimeen.',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported_resolution_url_text' => 'Palvelimenlaajuiset postiasetukset',

    'bu_conflict_resolver_absent_phosting' => 'Annettuja tiedostoja ei voida palauttaa, koska fyysistä isännöintiä niiden palautukselle ei ole olemassa. Luo ensin toimialue fyysisellä isännöinnillä ja käynnistä sen jälkeen varmuuskopion palautus uudelleen.',
    'bu_conflict_resolver_resellers_management_is_not_supported' => 'Jälleenmyyjän tietoja ei palauteta, koska jälleenmyyjän hallintaa ei tueta.',

    'backup__restore__capability_modsecurity_not_installed_text' => 'ModSecurity-komponenttia ei ole asennettu kohdepalvelimeen.',
    'backup__restore__capability_modsecurity_not_installed_resolution' => 'Asenna ModSecurity, jos haluat verkkosovelluksen palomuurin toimivan siirrettyjen sivustojen kohdalla. Asennus voi viedä joitakin minuutteja.',
    'backup__restore__capability_modsecurity_not_installed_resolution_for_server' => 'Asenna ModSecurity, jos haluat siirtää verkkosovelluksen palomuurin asetukset. Asennus voi viedä joitakin minuutteja.',
    'backup__restore__capability_modsecurity_not_configured_text' => 'ModSecurity-komponenttia ei ole määritetty kohdepalvelimessa.',
    'backup__restore__capability_modsecurity_not_configured_resolution' => 'Määritä ModSecurity, jos haluat verkkosovelluksen palomuurin toimivan siirrettyjen sivustojen kohdalla.',
    'backup__restore__capability_modsecurity_not_configured_resolution_url_text' => 'Verkkosovelluksen palomuuri (ModSecurity)',
    'backup__restore__capability_modsecurity_not_active_text' => 'ModSecurity on pois käytöstä kohdepalvelimessa.',
    'backup__restore__capability_modsecurity_not_active_resolution' => 'Aktivoi ModSecurity, jos haluat verkkosovelluksen palomuurin toimivan siirrettyjen sivustojen kohdalla.',
    'backup__restore__capability_modsecurity_not_active_resolution_url_text' => 'Verkkosovelluksen palomuuri (ModSecurity)',
    'bu_conflict_resolver_modsecurity_not_installed' => 'ModSecurity-komponenttia ei ole asennettu. Verkkosovelluksen palomuuriasetuksia ei palauteta seuraavissa kohteissa: {{objects}}',
    'bu_conflict_resolver_absent_websites_subscription' => "Verkkosivustoja ei voida palauttaa, koska ne kuuluvat tilaukseen %1, jota ei löydy Pleskistä.",
    'backup__restore__capability_not_installed_dns_text' => 'Osaa %1 ei ole asennettu kohdepalvelimeen. DNS-palvelu ei ole enää käytettävissä ja DNS-asetukset menetetään. Kaikkien asiakkaiden verkkosivustot ovat pois käytöstä.',
    'bu_conflict_resolver_dns_not_installed' => 'DNS-palvelua ei ole asennettu. Verkkosovelluksen palomuuriasetuksia ei palauteta seuraavissa kohteissa: {{objects}}',
    'backup__restore__subscriptions_cannot_restore_moved_to_another_owners' => 'Seuraavia tilauksia ei voida palauttaa, koska ne siirrettiin toisille omistajille: \'%1\'',
    'backup__restore__subscriptions_cannot_restore_moved_to_another_vendors' => 'Seuraavia tilauksia ei voida palauttaa, koska ne siirrettiin toisille toimittajille: \'%1\'',
    'bu_conflict_resolver_sitebuilder_restore_util_is_not_installed' => 'Web Presence Builder -palautusohjelmaa ei löydy Web Presence Builder -tietojen palauttamiseksi. Web Presence Builderia ei ole luultavasti asennettu.',
    'backup__restore__capability_renamed_db' => 'Tietokannan nimi "%1" on jo toisen tilauksen käytössä. Palautetun tietokannan nimeksi muutetaan "%2".',
    'backup__restore__capability_renamed_db_user' => 'Tietokannan käyttäjänimi "%1" on jo toisen tilauksen käytössä. Palautetun tietokannan käyttäjän nimeksi muutetaan "%2".',
    'backup__restore__capability_not_installed_perl_resolution' => 'Plesk Installer ei tue Perl -ohjelmaa. Asenna ActiveState Perl manuaalisesti.',
    'backup__restore__capability_php_handler' => '%%version%% %%type%% (id=%%id%%)',
    'backup__restore__capability_php_handler_served_by_apache' => '%%version%% %%type%% Apachen tukema (id=%%id%%)',
    'backup__restore__capability_php_handler_served_by_nginx' => '%%version%% %%type%% nginx tukema (id=%%id%%)',


    '__sni' => 'NUMA-Aware Scalability',
    '__kav' => 'Kaspersky Anti-Virus',
    '__drweb' => 'Odin Premium Antivirus',

    // Timing conflicts
    'backup__restore__timing_conflicts' => 'Aikatauluristiriitoja',
    'backup__restore__hint_timing_conflicts' => 'Ajoituksessa on ristiriitoja joko silloin, kun palautettu kohde on jo olemassa järjestelmässä uudemmalla muutospäivämäärällä tai kun palautettua kohdetta ei ole järjestelmässä.',
    'backup__restore__text_timing_resolution_policy_overwrite' => 'Käytä varmuuskopion määrityksiä ja tietoja',
    'backup__restore__hint_timing_resolution_policy_overwrite' => 'Kirjoita kokonaan kohteen määrityksien ja järjestelmässä olevien tietojen päälle käyttäen varmuuskopiointitiedoston määrityksiä ja tietoja. Jos palautettu kohde kuuluu toiselle omistajalle, kohde palautetaan aikaisemman omistajan nimellä.',
    'backup__restore__text_timing_resolution_policy_proceed' =>  'Käytä nykyisen järjestelmän määrityksiä ja varmuuskopion tietoja',
    'backup__restore__hint_timing_resolution_policy_proceed' => 'Kirjoita nykyisten kohteen tietojen päälle varmuuskopiointitiedoston tietoja käyttäen, mutta säilytä järjestelmässä olevat kohteen nykyiset määritykset. Jos palautettu kohde kuuluu toiselle omistajalle, kohde palautetaan nykyisen omistajan nimellä.',
    'backup__restore__text_timing_resolution_policy_do_not_restore' => 'Älä palauta',
    'backup__restore__hint_timing_resolution_policy_do_not_restore' => 'Älä palauta kohteita, joissa on aikaa koskevia ristiriitoja.',
    // Resource usage conflicts
    'backup__restore__resource_useage_conflicts' => 'Resurssienkäyttöristiriitoja',
    'backup__restore__hint_resource_usage_conflicts' => 'Resurssin käytössä on ristiriitoja, kun palautetun kohteen resurssin käyttörajat ylitetään palautuksen yhteydessä.',
    'backup__restore__text_resource_usage_resolution_policy_overusage' => 'Salli liikakäyttö',
    'backup__restore__hint_resource_usage_resolution_policy_overusage' => 'Palauta kohde ja salli sen käyttää enemmän resursseja kuin alustavasti määritetty.',
    'backup__restore__text_resource_usage_resolution_policy_do_not_restore' => 'Älä palauta',
    'backup__restore__hint_resource_usage_resolution_policy_do_not_restore' => 'Älä palauta kohteita, joissa on resurssin käyttöä koskevia ristiriitoja.',
    // Configuration conflicts
    'backup__restore__configuration_conflicts' => 'Määritysristiriitoja',
    'backup__restore__hint_configuration_conflicts' => 'Määrityksessä tapahtuu ristiriitoja, kun palautettu kohde sisältää asetuksia ja verkkosovelluksia, jotka eivät ole saatavilla tai jotka nykyinen palvelin tai kohteen omistajan käytäntö kieltää. Määrityksen ristiriitoja tapahtuu esimerkiksi silloin, jos palautetuissa sähköpostitileissä on yksilöllisiä roskapostisuodatusasetuksia, kun nykyinen palvelimen laajuinen käytäntö kieltää kyseiset sähköpostitilien asetukset.',
    'backup__restore__text_configuration_resolution_policy_automatic' => 'Automaatinen',
    'backup__restore__hint_configuration_resolution_policy_automatic' => 'Palauta kohde ja ota kaikki käyttöoikeuksien mukaiset ristiriidassa olevat määrityksen automaattisesti käyttöön.',
    'backup__restore__text_configuration_resolution_policy_do_not_restore' => 'Älä palauta',
    'backup__restore__hint_configuration_resolution_policy_do_not_restore' => 'Älä palauta kohteita, joissa on ristiriidassa olevia määrityksiä.',

    'backup__restore__dedicated_app_pool_restore_to_shared_text' => 'Varatut IIS-sovellussarjat eivät ole sallittuja IIS-sovellussarjan asetuksissa.',
    'backup__restore__dedicated_app_pool_restore_to_shared_resolution' => 'Muuta IIS-sovellussarjan asetukset kohdassa Työkalut & asetukset > IIS-sovellussarja > Yleiset asetukset.',
    'backup__restore__shared_app_pool_restore_to_dedicated_text' => 'Jaetut IIS-sovellussarjat eivät ole sallittuja IIS-sovellussarjan asetuksissa.',
    'backup__restore__shared_app_pool_restore_to_dedicated_resolution' => 'Muuta IIS-sovellussarjan asetukset kohdassa Työkalut & asetukset > IIS-sovellussarja > Yleiset asetukset.',

    'backup__restore__unable_allow_short_pop3 _names_text' => 'Lyhyitä POP3/IMAP-sähköpostinimiä ei sallita kohdepalvelimella.',
    'backup__restore__unable_allow_short_pop3 _names_resolution' => 'Sähköpostitilien lyhyet nimet eivät ole käytettävissä tietojen palautuksen jälkeen.',

    // Restore status messages & errors:
    'backup__unable_to_open_log_file' => 'Lokitiedostoa ei voi avata.',
    'backup__restore__customer_cannot_restore_nonexistent_subscription' => 'Tilausta %1 ei voida palauttaa: se poistettiin tililtäsi ja sinulla ei ole lupaa luoda tilauksia. Jos sen palautus on tarpeen, ota yhteyttä palveluntarjoajaan.',

    'backup__error11' => 'Riittämätön levyn tila varmuuskopiointia varten.',
    'backup__error3011' => 'Yhteys evättiin: ei ohjelmia, jotka kuuntelisivat annettua osoitetta ja porttia.',
    'backup__error3012' => 'Yhteyden aikakatkaisu.',
    'backup__error3013' => 'Verkko ei ole käytettävissä.',
    'backup__error3014' => 'Ei reittiä isäntään.',
    'backup__error3015' => 'Yhteys epäonnistui.',
    'backup__error3016' => 'Isäntänimeä ei voi selvittää.',
    'backup__error3017' => 'Virheellinen käyttäjänimi tai salasana.',
    'backup__error3018' => 'SSH-yhteys epäonnistui.',

    'backup__error3110' => 'Yhteyttä ei voida luoda Migration Agent -etäjärjestelmään: ei saatavilla olevaa yhteyttä isäntään.',
    'backup__error3111' => 'Migration Agent on lukittu epäonnistuneen siirtotehtävän vuoksi tai toinen siirtoprosessi käyttää sitä. Käynnistä Migration Agent uudelleen lähdepalvelimella.',
    'backup__error3112' => 'Yhteys ei ole saatavilla isäntään tai Migration Agent ei käy lähdeisännällä.',
    'backup__error3113' => 'Migration Agent -järjestelmää ei voida käyttää Linux-isäntään. Tarkista lähdeisännän SSH-yhteys.',
    'backup__error3114' => 'Migration Agent -järjestelmää ei voida käyttää Linux-isäntään: SSH-yhteys epäonnistui.',
    'backup__error3115' => 'Virheellinen käyttäjänimi tai salasana.',
    'backup__error3116' => 'Annetulla käyttäjällä ei ole järjestelmänvalvojan oikeuksia.',

    'backup__scheduled_backup_settings__backup_of_domain_all_at_domain' => 'Kaikki määritykset ja sisältö',
    'backup__scheduled_backup_settings__backup_of_domain_vhost_only' => 'Kaikki määritykset ja sisältö sähköpostia lukuun ottamatta',
    'backup__scheduled_backup_settings__backup_of_domain_mail_only' => 'Vain sähköpostin määritykset ja sisältö',

    'dns_t__unable_to_remove_ns_record' => 'NS-tietuetta ei voida poistaa DNS-mallista: kaikilla DNS-vyöhykkeillä on oltava vähintään yksi NS-tietue.',
    'dns__unsupported_server_zone_transfer' => 'Siirtorajoitusmallia ei voida siirtää palvelimen laajuisten DNS-määrityksen vuoksi: lähdepalvelimella seuraavat verkko-osoitteet sallitaan vyöhykesiirtoon, mutta Microsoft DNS -palvelin estää kyseiset osoitteet: %1',
    'dns__unsupported_domain_zone_transfer' => 'Siirtorajoitusmallia ei voida siirtää toimialueiden DNS-määrityksen vuoksi: joillakin toimialueilla seuraavat verkko-osoitteet sallitaan vyöhykesiirtoon, mutta Microsoft DNS -palvelin estää kyseiset osoitteet: %1',
    ///
    /// END OF COMMON SCREENS
    ///

    ///
    /// DATABASE BACKUP - PFW // TBD
    ///

    // Actions

    'backup__db_mapping__title' => 'Määritä tietokantapalvelimien määritys',
    'dbbackup__check_network_settings_failed' => 'Varmuuskopiointitiedostojen jaettuun väliaikaiseen verkkohakemistoon ei päästä. Tarkista verkkohakemiston, käyttäjänimen ja salasanan asetukset. Virhe: %1',

    'migration_select_exist_db_server' => 'Valitse kohdetietokannan palvelin',

    'dbbackup__temp_dir_wrong_value' => 'Väliaikaisen hakemiston määritetty arvo on virheellinen.',
    'dbbackup__network_temp_dir_wrong_value' => 'Väliaikaisen verkkohakemiston määritetty arvo on virheellinen.',
    'dbbackup__server_backup_not_configured' => 'Tietokannan varmuuskopiointiasetuksia ei ole määritetty palvelimeen.',
    'dbbackup__temp_dir' => 'Väliaikainen hakemisto',
    'dbbackup__temp_dir_hint' => 'Polku etäpalvelimen fyysiseen kansioon, jossa MS SQL -palvelin sijaitsee. MS SQL -palvelimen tulee päästä tähän kansioon väliaikaisten varmuuskopiointitiedostojen lukemista ja kirjoitusta varten. Esimerkiksi, C:\\DirectoryPath',
    'dbbackup__network_temp_dir_hint' => 'Polku jaettuun verkkoresurssiin yhdistetty yllä määritettyyn fyysiseen kansioon. Plesk käyttää jaettua kansiosta varmuuskopiointitiedostojen lataamiseen. Esimerkiksi \\\\ServerName\\DirectoryPath',
    'dbbackup__network_user_hint' => 'Etäpalvelimella luotu verkkokäyttäjän käyttäjänimi. Esimerkiksi, ServerName\\UserName. Käyttäjällä on oltava yllä määritetyn jaetun kansion käyttöoikeus.',
    'dbbackup__network_password_hint' => 'Verkkokäyttäjän salasana',

    'dbbackup__success_import_without_dublicate_users' => 'Seuraavia käyttäjiä ei tuotu: %1. Ne ovat jo olemassa tietokannan palvelimessa.',

    ///
    /// END OF DATABASE BACKUP
    ///

    ///
    /// LOGS & LOG ROTATION
    ///

    'log_rot__compress' => "Pakkaa lokitiedostot",
    'log_rot__log_rot_status' => "Lokin kierron tila",
    'log_rot__log_rot_period' => "Lokikierron ehto",
    'log_rot__log_rot_size' => "koon mukaan",
    'log_rot__log_rot_time' => "ajan mukaan",
    'log_rot__logrotation_enable' => "Ota käyttöön lokin kierto",
    'log_rot__mail' => "Lähetä käsitellyt lokitiedostot sähköpostiin",
    'log_rot__max_number_of_logfiles' => "Lokitiedostojen enimmäismäärä",
    'log_rot__time_period' => "Kausi",
    'log_rot__unable_turn_off' => 'Lokin kiertoaikaa ei voida poistaa käytöstä, koska se on asetettu palvelintasolla',
    'log_rot__unable_set_period' => 'Lokin kiertoaikaa ei voida asettaa arvosta \'daily\\’ poikkeavaksi, koska se on asetettu palvelintasolla',
    'log_rot__unable_set_max_log_files' => 'Lokitiedostojen maksimimäärää ei voida asettaa palvelimen laajuista rajaa %1 suuremmaksi',

    /// action log
    // common/various
    'actionlog__digit_expected' => "Puuttuva luku: %1",
    'actionlog__incorrect_rotation' => "Määritetty lokin kiertoparametrit ovat virheelliset: %1",
    'actionlog__unknown_rot_period' => "Tuntematon kiertoaika: %1",
    'actionlog__unknown_rot_type' => "Tuntematon kiertotyyppi: %1",
    'actionlog__session_preferences' => 'Istunnon asetukset',
    // items (PFU schema)
    'actionlog__admin_info' => 'Järjestelmänvalvojan tiedot',
    'actionlog__admin_preferences' => "Järjestelmänvalvojan määritykset",
    'actionlog__service' => 'Palvelu',
    'actionlog__ip_addr' => 'IP-osoite',
    'actionlog__client' => 'Asiakastili',
    'actionlog__client_status' => 'Asiakastilin tila',
    'actionlog__client_preferences' => "Asiakasliittymän omat asetukset",
    'actionlog__client_ip_pool' => "Asiakkaan IP-ryhmä",
    'actionlog__client_siteapp' => "Asiakkaan verkkosovellussarja",
    'actionlog__client_guid' => "Asiakkaan GUID-tunnus",
    'actionlog__domain' => 'Oletustoimialue (ensimmäinen tilaukseen lisätty toimialue)',
    'actionlog__domain_owner' => 'Tilauksen omistaja',
    'actionlog__domain_plan' => 'Tilauksen palvelusuunnitelma',
    'actionlog__domain_status' => 'Oletustoimialue, tila',
    'actionlog__domain_dns' => 'Oletustoimialue, DNS-vyöhyke',
    'actionlog__subdomain' => 'Oletustoimialueen alitoimialue',
    'actionlog__domain_alias' => 'Oletustoimialue, alias',
    'actionlog__domain_alias_dns' => 'Oletustoimialue, alias DNS-vyöhyke',
    'actionlog__site' => 'Toimialue',
    'actionlog__site_status' => 'Toimialueen tila',
    'actionlog__site_dns' => 'Toimialueen DNS-vyöhyke',
    'actionlog__site_guid' => 'Toimialueen GUID-tunnus',
    'actionlog__site_subdomain' => 'Alitoimialue',
    'actionlog__site_alias' => 'Toimialueen alias',
    'actionlog__site_alias_dns' => 'Toimialue alias DNS-vyöhyke',
    'actionlog__domain_limits' => 'Tilausrajoitukset',
    'actionlog__domain_limit_size' => 'Tilauksen levytilan raja',
    'actionlog__domain_limit_traffic' => 'Tilauksen liikenneraja',
    'actionlog__domain_limits_powerUser' => 'Tilausrajoitukset',
    'actionlog__domain_limit_size_powerUser' => 'Tilauksen levytilan raja',
    'actionlog__domain_limit_traffic_powerUser' => 'Tilauksen liikenneraja',
    'actionlog__domain_guid' => "Oletustoimialue, GUID",
    'actionlog__cp_user' => 'Plesk-käyttäjä',
    'actionlog__mailname' => 'Sähköpostitili',
    'actionlog__maillist' => 'Postituslista',
    'actionlog__phosting' => 'Isännöintiasetukset',
    'actionlog__forwarding' => 'Vakio- tai kehyksen edelleenlähetyksen isännöinti',
    'actionlog__webuser' => 'Internet-käyttäjän tili',
    'actionlog__site_application' => 'Web-sovellus',
    'actionlog__license' => 'Käyttöoikeusavain',
    'actionlog__additional_license' => 'Lisäkäyttöoikeusavain',
    'actionlog__template_domain' => "Jälleenmyyjän palvelusuunnitelma",
    'actionlog__template_admin' => "Järjestelmävalvojan palvelusuunnitelma",
    'actionlog__template_reseller' => 'Jälleenmyyjän suunnitelma',
    'actionlog__admin_alias' => 'Järjestelmänvalvojan lisätili', // PFW
    'actionlog__ftpuser' => 'FTP-lisätili', // PFW
    'actionlog__db_server' => 'Tietokantapalvelin',
    'actionlog__db' => 'Tietokanta',
    'actionlog__db_user' => 'Käyttäjätilien tietokanta',
    'actionlog__client_sapppkg_pool' => "Käyttäjän verkkosovellus", // PFW, not used?
    'actionlog__remote_dns' => 'DNS-etäpalvelimen tila', // PFW
    'actionlog__reseller' => 'Jälleenmyyjän tili',
    'actionlog__reseller_guid' => 'Jälleenmyyjän GUID',
    'actionlog__reseller_ip_pool' => "Jälleenmyyjän IP-sarja",
    'actionlog__reseller_limit_size' => 'Jälleenmyyjän tilin levytilan raja',
    'actionlog__reseller_limit_traffic' => 'Jälleenmyyjän tilin liikenneraja',
    'actionlog__reseller_limits' => 'Jälleenmyyjän tilirajat',
    'actionlog__reseller_permissions' => 'Jälleenmyyjän käyttöoikeudet',
    'actionlog__reseller_preferences' => "Jälleenmyyjän liittymän omat asetukset",
    'actionlog__reseller_siteapp' => "Jälleenmyyjän sarjan verkkosovellukset",
    'actionlog__reseller_status' => 'Jälleenmyyjätilin tila',
    'actionlog__health_status' => 'Palvelimen kunnon tila',
    // actions (PFU schema)
    'actionlog__limit_reached' => 'saavutettiin',
    'actionlog__added' => 'lisätty',
    'actionlog__removed' => 'poistettu',
    'actionlog__change' => 'muutettu',
    'actionlog__update' => 'päivitetty',
    'actionlog__move' => 'siirretty',
    'actionlog__upgrade' => 'päivitetty', // PFU?
    'actionlog__update_or_add' => 'päivitetty tai lisätty',
    'actionlog__expired' => 'Vanhentunut',
    'actionlog__create' => 'luotu',
    'actionlog__delete' => 'poistettu',
    'actionlog__service_stop' => 'pysäytetty',
    'actionlog__service_restart' => 'käynnistettiin uudelleen',
    'actionlog__service_start' => 'Aloitettu',
    'actionlog__login' => 'Kirjautunut sisään',
    'actionlog__logout' => 'Kirjautunut ulos',
    'actionlog__install' => 'Asennettu',
    'actionlog__uninstall' => 'poistettu',
    'actionlog__reconfigure' => 'määritettiin uudelleen',
    // events (PFW schema)
    'actionlog__event_pw_reset' => 'Salasanan nollauspyyntö',
    'actionlog__event_admin_update' => 'Järjestelmänvalvojan tiedot päivitettiin',
    'actionlog__event_admin_preferences_update' => "Järjestelmänvalvojan asetukset päivitetty",
    'actionlog__event_service_restart' => 'Palvelu käynnistetty uudelleen',
    'actionlog__event_service_start' => 'Palvelu käynnistyi',
    'actionlog__event_service_stop' => 'Palvelu pysäytetty',
    'actionlog__event_ip_address_create' => 'IP-osoite luotiin',
    'actionlog__event_ip_address_delete' => 'IP-osoite poistettiin',
    'actionlog__event_ip_address_update' => 'IP-osoite päivitettiin',
    'actionlog__event_client_create' => 'Asiakastili luotiin',
    'actionlog__event_client_delete' => 'Asiakastili poistettiin',
    'actionlog__event_client_update' => 'Asiakastili päivitettiin',
    'actionlog__event_client_status_update' => 'Asiakastilin tila päivitetty',
    'actionlog__event_client_preferences_update' => "Asiakasliittymän omat asetukset päivitetty",
    'actionlog__event_client_siteapp_added' => "Verkkosovellus lisätty asiakastilin sovellussarjaan",
    'actionlog__event_client_siteapp_removed' => "Verkkosovellus poistettu asiakastilin sovellussarjasta",
    'actionlog__event_domain_limit_size_reached' => 'Tilauksen levytilan raja saavutettu',
    'actionlog__event_domain_limit_traffic_reached' => 'Tilauksen liikenneraja saavutettu',
    'actionlog__event_domain_limit_size_reached_powerUser' => 'Tilauksen levytilan raja saavutettu',
    'actionlog__event_domain_limit_traffic_reached_powerUser' => 'Tilauksen liikenneraja saavutettu',

    'actionlog__domain_limit_database' => 'Tietokannan kiintiö tilaukseen',
    'actionlog__event_domain_limit_mysql_quota_reached' => 'MySQL-tietokantojen kiintiö tilaukseen saavutettu',
    'actionlog__event_domain_limit_mysql_soft_quota_reached' => 'MySQL-tietokantojen pehmeä kiintiö tilaukseen saavutettu',
    'actionlog__event_domain_limit_mssql_quota_reached' => 'Microsoft SQL -palvelimen tietokantojen kiintiö tilaukselle saavutettu',
    'actionlog__event_domain_limit_mssql_soft_quota_reached' => 'Microsoft SQL -palvelimen tietokantojen pehmeä kiintiö tilaukselle saavutettu',
    'actionlog__event_plesk_component_upgrade' => 'Pleskin komponentti päivitetty',
    'actionlog__event_plesk_component_install' => 'Pleskin komponentti asennettu',
    'actionlog__event_plesk_component_uninstall' => 'Pleskin komponentin asennus poistettu',
    'actionlog__event_domain_create' => 'Oletustoimialue (ensimmäinen tilaukseen lisätty toimialue) luotiin',
    'actionlog__event_domain_delete' => 'Oletustoimialue (ensimmäinen tilaukseen lisätty toimialue) poistettiin',
    'actionlog__event_domain_update' => 'Oletustoimialue (ensimmäinen tilaukseen lisätty toimialue) päivitettiin',
    'actionlog__event_domain_owner_change' => 'Tilauksen omistajaa muutettu',
    'actionlog__event_domain_plan_change' => 'Tilauksen palvelusuunnitelma muuttunut',
    'actionlog__event_domain_status_update' => 'Oletustoimialue, tila päivitetty',
    'actionlog__event_domain_dns_update' => 'Oletustoimialue, DNS-vyöhyke päivitetty',
    'actionlog__event_subdomain_create' => 'Oletustoimialueen alitoimialue luotu',
    'actionlog__event_subdomain_delete' => 'Oletustoimialueen alitoimialue poistettu',
    'actionlog__event_subdomain_update' => 'Oletustoimialueen alitoimialue päivitettiin',
    'actionlog__event_domain_alias_create' => 'Oletustoimialue, alias luotu',
    'actionlog__event_domain_alias_delete' => 'Oletustoimialue, alias poistettu',
    'actionlog__event_domain_alias_update' => 'Oletustoimialue, alias päivitetty',
    'actionlog__event_domain_limits_update' => 'Tilauksen rajat päivitetty',
    'actionlog__event_cp_user_login' => 'Plesk -käyttäjä kirjautunut sisään',
    'actionlog__event_cp_user_logout' => 'Plesk -käyttäjä kirjautunut ulos',
    'actionlog__event_mailname_create' => 'Sähköpostitili luotu',
    'actionlog__event_mailname_delete' => 'Sähköpostitili poistettu',
    'actionlog__event_mailname_update' => 'Sähköpostitili päivitetty',
    'actionlog__event_maillist_create' => 'Postituslista luotu',
    'actionlog__event_maillist_delete' => 'Postituslista poistettu',
    'actionlog__event_maillist_update' => 'Postituslista päivitetty',
    'actionlog__event_phys_hosting_create' => 'Fyysinen isännöinti luotiin',
    'actionlog__event_phys_hosting_delete' => 'Fyysinen isännöinti poistettiin',
    'actionlog__event_phys_hosting_update' => 'Fyysinen isännöinti päivitettiin',
    'actionlog__event_forwarding_create' => 'Vakio- tai kehyksen edelleenlähetyksen isännöinti luotiin',
    'actionlog__event_forwarding_delete' => 'Vakio- tai kehyksen edelleenlähetyksen isännöinti poistettiin',
    'actionlog__event_forwarding_update' => 'Vakio- tai kehyksen edelleenlähetyksen isännöinti päivitettiin',
    'actionlog__event_webuser_create' => 'Verkkokäyttäjän tili luotu',
    'actionlog__event_webuser_delete' => 'Verkkokäyttäjän tili poistettu',
    'actionlog__event_webuser_update' => 'Verkkokäyttäjän tili päivitetty',
    'actionlog__event_siteapp_install' => 'Verkkosovellus asennettiin',
    'actionlog__event_siteapp_reconfigure' => 'Verkkosovellus määritettiin uudelleen',
    'actionlog__event_siteapp_uninstall' => 'Verkkosovellus poistettiin',
    'actionlog__event_license_update' => 'Käyttöoikeusavain päivitettiin',
    'actionlog__event_admin_alias_create' => 'Ylimääräinen järjestelmänvalvojan tili luotu',
    'actionlog__event_admin_alias_delete' => 'Ylimääräinen järjestelmänvalvojan tili poistettu',
    'actionlog__event_admin_alias_update' => 'Ylimääräinen järjestelmänvalvojan tili päivitetty',
    'actionlog__event_ftpuser_create' => 'Ylimääräinen FTP-tili luotu',
    'actionlog__event_ftpuser_update' => 'Ylimääräinen FTP-tili päivitetty',
    'actionlog__event_ftpuser_delete' => 'Ylimääräinen FTP-tili poistettu',
    'actionlog__event_template_domain_create' => "Jälleenmyyjän palvelusuunnitelma luotu",
    'actionlog__event_template_domain_update' => "Jälleenmyyjän palvelusuunnitelma päivitetty",
    'actionlog__event_template_domain_delete' => "Jälleenmyyjän palvelusuunnitelma poistettu",
    'actionlog__event_template_admin_create' => "Järjestelmävalvojan palvelusuunnitelma luotu",
    'actionlog__event_template_admin_update' => "Järjestelmävalvojan palvelusuunnitelma päivitetty",
    'actionlog__event_template_admin_delete' => "Järjestelmävalvojan palvelusuunnitelma poistettu",
    'actionlog__event_database_server_create' => 'Tietokantapalvelin luotiin',
    'actionlog__event_database_server_update' => 'Tietokantapalvelin päivitetty',
    'actionlog__event_database_server_delete' => 'Tietokantapalvelin poistettu',
    'actionlog__event_remote_dns_status_update' => 'DNS-etäpalvelimen tila päivitetty',
    'actionlog__event_session_preferences_update' => 'Istunnon asetukset päivitetty',
    'actionlog__event_domain_alias_dns_update' => 'Oletustoimialue, toimialueen aliaksen DNS-vyöhyke päivitetty',
    'actionlog__event_domain_move' => 'Oletustoimialue siirretty uuteen tilaukseen',
    'actionlog__event_site_move' => 'Toimialue siirretty uuteen tilaukseen',
    'actionlog__event_site_subdomain_move' => 'Alitoimialue siirretty uuteen tilaukseen',
    'actionlog__event_subdomain_move' => 'Oletustoimialueen alitoimialue siirretty uuteen tilaukseen',
    'actionlog__event_license_expired' => 'Plesk -käyttöoikeus mennyt umpeen',
    'actionlog__event_database_create' => 'Tietokanta luotu',
    'actionlog__event_database_delete' => 'Tietokanta poistettu',
    'actionlog__event_database_user_create' => 'Tietokannan käyttäjätili luotu',
    'actionlog__event_database_user_update' => 'Tietokannan käyttäjätilin asetukset päivitetty',
    'actionlog__event_database_user_delete' => 'Tietokannan käyttäjätili poistettu',
    'actionlog__event_client_guid_update' => "Asiakkaan GUID päivitetty",
    'actionlog__event_domain_guid_update' => 'Oletustoimialue, GUID päivitetty',
    'actionlog__event_reseller_create' => 'Jälleenmyyjän tili luotu',
    'actionlog__event_reseller_delete' => 'Jälleenmyyjän tili poistettu',
    'actionlog__event_reseller_update' => 'Jälleenmyyjän tili päivitetty',
    'actionlog__event_reseller_guid_update' => 'Jälleenmyyjän GUID päivitetty',
    'actionlog__event_reseller_ip_pool_update' => "Jälleenmyyjän IP-sarja päivitetty",
    'actionlog__event_reseller_limit_size_reached' => 'Jälleenmyyjän tilin levytilan raja saavutettu',
    'actionlog__event_reseller_limit_traffic_reached' => 'Jälleenmyyjän tilin liikenneraja saavutettu',
    'actionlog__event_reseller_limits_update' => 'Jälleenmyyjän tilirajat päivitetty',
    'actionlog__event_reseller_permissions_update' => 'Jälleenmyyjän tilin käyttöoikeudet päivitetty',
    'actionlog__event_reseller_preferences_update' => "Jälleenmyyjän liittymän omat asetukset päivitetty",
    'actionlog__event_reseller_siteapp_added' => "Sovellus lisätty jälleenmyyjän tilin sovellussarjaan",
    'actionlog__event_reseller_siteapp_removed' => "Sovellus poistettu jälleenmyyjän tilin sovellussarjasta",
    'actionlog__event_reseller_status_update' => 'Jälleenmyyjän tilin tila päivitetty',
    'actionlog__event_template_reseller_create' => 'Jälleenmyyjän suunnitelma luotu',
    'actionlog__event_template_reseller_delete' => 'Jälleenmyyjän suunnitelma poistettu',
    'actionlog__event_template_reseller_update' => 'Jälleenmyyjän suunnitelma päivitetty',
    'actionlog__event_health_status_change' => 'Palvelimen kunnon tilaa muutettu',
    'actionlog__event_siteapp_upgrade' => 'Verkkosovellus päivitetty',
    'actionlog__event_extension_install' => 'Laajennus asennettu',
    'actionlog__event_extension_uninstall' => 'Laajennuksen asennus poistettu',
    'actionlog__event_extension_upgrade' => 'Laajennus päivitetty',
    'actionlog__event_extension_status_update' => 'Laajennuksen tila päivitetty',
    'actionlog__event_additional_license_expired' => 'Lisäkäyttöoikeus on erääntynyt',
    'actionlog__event_hostname_changed' => 'Palvelimen isäntänimi muutettu',

    // REMOTE SESSION
    'rsession_no_api_rpc_errmsg' => "Plesk API RPC -yksikköä ei ole asennettu etäisäntään. Kysy ohjeita palveluntarjoajalta.",
    'rsession_no_account_errmsg' => "Etäpalveluun ei päästä tililläsi. Yleisin syy on, ettei tilisi palvelua ole vielä aktivoitu. Odota usean minuutin ajan ja yritä sitten uudelleen. Jos kohtaat tämän ongelman uudelleen, ota yhteys järjestelmänvalvojaan.",
    'rsession_no_domain_errmsg' => "Tämän toimialueen etäpalveluun ei päästä. Yleisin syy on, että tämän toimialueen palvelua ei ole vielä aktivoitu. Odota usean minuutin ajan ja yritä sitten uudelleen. Jos kohtaat tämän ongelman uudelleen, ota yhteys järjestelmänvalvojaan.",
    'rsession_unknown_errmsg' => "Etäpalvelin on torjunut istunnon luontiyrityksen. Pyydä tukea järjestelmänvalvojalta. Virhe oli: %1",
    'rsession_unknown2_errmsg' => "Tuntematon virhe etäistunnon luomisen aikana. Todennäköisesti etäpalvelin ei vastaa oikein tai se ei vastaa ollenkaan. Pyydä järjestelmänvalvojaa tarkistamaan virhetiedot verkkopalvelimen virhelokista.",
    'rsession_no_connect_errmsg' => "Etäpalveluun ei päästä: yhteyden luominen etäistuntoon epäonnistui. Pyydä tukea järjestelmänvalvojalta.",

    // ANONYMOUS FTP
    'anonftp__allow_upload_incoming' => "Salli lataus saapuvien hakemistoon",
    'anonftp__allow_create_dirs' => 'Salli hakemistojen luominen saapuvien hakemistossa',
    'anonftp__allow_download_incoming' => 'Salli lataus saapuvien hakemistosta',
    'anonftp__display_login' => 'Näytä kirjautumissanoma',
    'anonftp__login_text' => 'Viestin teksti',
    'anonftp__limit_incoming_disk_space' => "Rajoita levytilaa saapuvien hakemistossa",
    'anonftp__limit_maximum_bandwidth' => "Rajoita latauksen kaistanleveyttä tällä FTP-näennäistoimialueella",
    'anonftp__limit_maximum_connections' => "Rajoita samanaikaisten yhteyksien määrää",
    'anonftp__unable_init' => "Anonyymin FTP-tilin alustus ei onnistu: %1",
    'anonftp__unable_set_quota' => "Saapuvien hakemiston levytilan rajaa ei voida asettaa: %1",
    'anonftp__unable_update' => "Anonyymin FTP-tilin ominaisuuksien päivitys ei onnistu: %1",

    ///
    /// SSL/TLS CERTIFICATES
    ///

    // common keys
    '__certificates' => 'SSL/TLS-varmenteet', // page title
    // errors
    'class_sslcertificate__ca_not_signs' => "CA-varmenne ei allekirjoita varmennetta.",
    'class_sslcertificate__incompatible_pvt_key_cert' => "Yhteensopimaton yksityinen avain/varmenne.",
    'class_sslcertificate__invalid_cert_format' => "Virheellinen varmennemuoto.",
    'class_sslcertificate__invalid_private_key_format' => "Virheellinen yksityisen avaimen muoto.",
    'class_sslcertificate__prob_invalid_priv_key' => "Yksityisen avaimen muoto on virheellinen.",

    ///
    ///END OF SSL/TLS CERTIFICATES
    ///

    ///
    /// WEB DIRECTORIES (PFW)
    ///

    //
    // DOMAIN
    //

    // Web Directories tab
    // Web Directories - ui__client/domain/hosting/web-directories__title (HOME/DOMAIN)
    'ui__client/domain/hosting/web-directories/create-virtual-dir__short-title' => 'Luo virtuaalihakemisto',
    'ui__client/domain/hosting/web-directories/create-virtual-dir__title' => 'Luo virtuaalihakemisto',
    'ui__client/domain/hosting/web-directories/create-virtual-dir__description' => 'Luo virtuaalihakemisto.',
    'ui__client/domain/hosting/web-directories/create-virtual-dir_self__short-title' => 'Luo virtuaalihakemisto',
    'ui__client/domain/hosting/web-directories/create-virtual-dir_self__title' => 'Luo virtuaalihakemisto',
    'ui__client/domain/hosting/web-directories/create-virtual-dir_self__description' => 'Luo virtuaalihakemisto.',
    'ui__client/domain/hosting/web-directories/create-dir__short-title' => 'Luo hakemisto',
    'ui__client/domain/hosting/web-directories/create-dir__title' => 'Luo hakemisto',
    'ui__client/domain/hosting/web-directories/create-dir__description' => 'Luo hakemisto.',
    'ui__client/domain/hosting/web-directories/create-dir_self__short-title' => 'Luo hakemisto',
    'ui__client/domain/hosting/web-directories/create-dir_self__title' => 'Luo hakemisto',
    'ui__client/domain/hosting/web-directories/create-dir_self__description' => 'Luo hakemisto.',
    'ui__client/domain/hosting/web-directories/properties__short-title' => 'Hakemiston ominaisuudet',
    'ui__client/domain/hosting/web-directories/properties__title' => 'Virtuaalihakemiston ominaisuudet',
    'ui__client/domain/hosting/web-directories/properties__description' => 'Tarkastele ja muuta virtuaalihakemiston ominaisuuksia.',
    'ui__client/domain/hosting/web-directories/properties_self__short-title' => 'Hakemiston ominaisuudet',
    'ui__client/domain/hosting/web-directories/properties_self__title' => 'Virtuaalihakemiston ominaisuudet',
    'ui__client/domain/hosting/web-directories/properties_self__description' => 'Tarkastele ja muuta virtuaalihakemiston ominaisuuksia.',
    'ui__client/domain/hosting/web-directories/permissions__short-title' => 'Hakemiston käyttöoikeudet',
    'ui__client/domain/hosting/web-directories/permissions__title' => 'Hakemiston käyttöoikeudet',
    'ui__client/domain/hosting/web-directories/permissions__description' => 'Aseta hakemiston käyttöoikeudet.',
    'ui__client/domain/hosting/web-directories/permissions_self__short-title' => 'Hakemiston käyttöoikeudet',
    'ui__client/domain/hosting/web-directories/permissions_self__title' => 'Hakemiston käyttöoikeudet',
    'ui__client/domain/hosting/web-directories/permissions_self__description' => 'Aseta hakemiston käyttöoikeudet.',
    'ui__client/domain/hosting/web-directories/aspdotnet__short-title' => 'ASP.NET-asetukset',
    'ui__client/domain/hosting/web-directories/aspdotnet__title' => 'ASP.NET-asetukset kohteelle %1',
    'ui__client/domain/hosting/web-directories/aspdotnet__description' => 'Määritä ASP.NET -asetukset näennäishakemistoon %1.',
    'ui__client/domain/hosting/web-directories/aspdotnet_self__short-title' => 'ASP.NET-asetukset',
    'ui__client/domain/hosting/web-directories/aspdotnet_self__title' => 'ASP.NET-asetukset kohteelle %1',
    'ui__client/domain/hosting/web-directories/aspdotnet_self__description' => 'Määritä ASP.NET -asetukset näennäishakemistoon %1.',
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version__short-title' => 'Muuta versiota',
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version__title' => 'Muuta versiota',
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version__description' => 'Muuta virtuaalihakemiston %1 käyttämä ASP.NET-versio.',
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version_self__short-title' => 'Muuta versiota',
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version_self__title' => 'Muuta versiota',
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version_self__description' => 'Muuta virtuaalihakemiston %1 käyttämä ASP.NET-versio.',
    'ui__client/domain/hosting/web-directories/php__short-title' => 'PHP-asetukset',
    'ui__client/domain/hosting/web-directories/php__title' => 'Kohteen %1 PHP-asetukset',
    'ui__client/domain/hosting/web-directories/php__description' => 'Määritä virtuaalihakemiston %1 PHP-asetukset.',
    'ui__client/domain/hosting/web-directories/php_self__short-title' => 'PHP-asetukset',
    'ui__client/domain/hosting/web-directories/php_self__title' => 'Kohteen %1 PHP-asetukset',
    'ui__client/domain/hosting/web-directories/php_self__description' => 'Määritä virtuaalihakemiston %1 PHP-asetukset.',

    // list object operations
    'ui__client/domain/hosting/web-directories/delete__short-title' => 'Poista',
    'ui__client/domain/hosting/web-directories/delete__title' => 'Poista virtuaalihakemistot',
    'ui__client/domain/hosting/web-directories/delete__description' => 'Poista valitut virtuaalihakemistot.',
    'ui__client/domain/hosting/web-directories/delete_self__short-title' => 'Poista',
    'ui__client/domain/hosting/web-directories/delete_self__title' => 'Poista virtuaalihakemistot',
    'ui__client/domain/hosting/web-directories/delete_self__description' => 'Poista valitut virtuaalihakemistot.',
    'ui__client/domain/hosting/web-directories/delete#legend__description' => 'Seuraavat virtuaalihakemistot poistetaan:',
    'ui__client/domain/hosting/web-directories/delete__empty_selection' => 'Sinun on valittava hakemistot, jotka haluat poistaa.',

    // MIME Types tab
    'ui__client/domain/hosting/web-directories/mime-type_unknown__short-title' => 'MIME-tyypit',
    'ui__client/domain/hosting/web-directories/mime-type_unknown__title' => 'MIME-tyypit',
    'ui__client/domain/hosting/web-directories/mime-type_unknown__description' => 'Näytä rekisteröityjen MIME-tyyppien luettelo.',
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__short-title' => 'Lisää MIME-tyyppi',
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__title' => 'Lisää MIME-tyyppi',
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__description' => 'Rekisteröi uusi MIME tyyppi.',

    // Error documents tab
    'ui__client/domain/hosting/web-directories/error-doc_unknown__short-title' => 'Virheasiakirjoja',
    'ui__client/domain/hosting/web-directories/error-doc_unknown__title' => 'Virheasiakirjoja',
    'ui__client/domain/hosting/web-directories/error-doc_unknown__description' => 'Näytä ja muuta virheasiakirjoja.',

    // Protection tab
    'ui__client/domain/hosting/web-directories/protection__short-title' => 'Suojaus',
    'ui__client/domain/hosting/web-directories/protection__title' => 'Hakemiston suojaus',
    'ui__client/domain/hosting/web-directories/protection__description' => 'Rajoita hakemiston käyttöä salasanasuojauksella.',
    'ui__client/domain/hosting/web-directories/protection_self__short-title' => 'Suojaus',
    'ui__client/domain/hosting/web-directories/protection_self__title' => 'Hakemiston suojaus',
    'ui__client/domain/hosting/web-directories/protection_self__description' => 'Rajoita hakemiston käyttöä salasanasuojauksella.',
    'ui__client/domain/hosting/web-directories/protection/properties__short-title' => 'Asetukset',
    'ui__client/domain/hosting/web-directories/protection/properties__description' => 'Näytä hakemiston sijainti ja määritä suojatun alueen otsikko.',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__short-title' => 'Lisää käyttäjä',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__description' => 'Lisää käyttäjätili pääsyn mahdollistamiseksi suojattuun hakemistoon.',
    'ui__client/domain/hosting/web-directories/protection/properties__done' => 'Uudet asetukset käytettiin.',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__done' => 'Käyttäjätili lisättiin.',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__short-title' => 'Poista',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__description' => 'Poista suojatun hakemiston käyttäjät.',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__title' => 'Poista käyttäjätilejä',
    'ui__client/domain/hosting/web-directories/protection/user/delete#legend__description' => 'Vahvista käyttäjätilien poisto.',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__done' => 'Verkkokäyttäjätilit poistettiin.',

    //
    // SUBDOMAIN
    //

    // Web Directories tab

    // list object operations

    // MIME Types tab

    // Protection tab
    // Error documents tab

    ///
    /// END OF WEB DIRECTORIES
    ///

    ///
    /// SUBDOMAIN PAGE
    ///


    ///
    /// END OF SUBDOMAIN PAGE
    ///

    ///
    /// DONE MESSAGES
    ///

    // non-UI
    'check_permissions_done' => 'Käyttölupien tarkistusprosessi aloitettiin. Kun tarkistusprosessi on suoritettu, ilmoitus lähetetään seuraavaan sähköpostiosoitteeseen: %1', // PFW

    // UI
    'ui____done' => 'Toiminto onnistui.',
    'ui__admin/extras-domain__done' => 'MyPlesk.com-sivu avattiin.',
    'ui__admin/interface__done' => 'Muutokset palvelimen järjestelmänvalvojan liittymän asetuksiin tallennettiin.',
    'ui__admin/report/layout/delete_multi__done' => 'Valitut raporttiasettelut poistettiin.',
    'ui__admin/report/traffic-history__done' => 'Toiminto onnistui.',
    'ui__admin/report__done' => 'Toiminto onnistui.',
    'ui__admin-alias/delete_multi__done' => "Valitut ylimääräiset järjestelmänvalvojan tilit poistettiin.",
    'ui__admin-alias/properties__done' => "Järjestelmänvalvojan lisätilin ominaisuudet on muutettu.",
    'ui__admin-alias/properties_new__done' => "Ylimääräinen järjestelmänvalvojan tili luotiin.",
    'ui__admin-alias/properties_unknown__done' => "Järjestelmänvalvojan lisätilin ominaisuudet on muutettu.",
    'ui__admin-alias__done' => "Ylimääräisen järjestelmänvalvojan tilin tiedot päivitettiin onnistuneesti.",
    'ui__admin/manage-domain__done' => 'MyPlesk.com-sivu avattiin.',
    'ui__admin/register-domain__done' => 'MyPlesk.com-sivu avattiin.',
    'ui__admin/report/layout/auto/delete_multi__done' => 'Valitut raportin toimitusaikataulut poistettiin.',
    'ui__admin/report/layout/auto/properties__done' => 'Raportin toimitusaikataulu on päivitetty.',
    'ui__admin/report/layout/auto/properties_new__done' => 'Raportin toimitusaikataulu luotiin.',
    'ui__admin/report/layout/properties__done' => 'Raporttiasettelu %1 päivitettiin.',
    'ui__admin/report/layout/properties_new__done' => 'Raporttiasettelu %1 luotiin.',
    'ui__client/chowner__done' => 'Asiakastilin %1 uusi omistaja määritettiin.',
    'ui__client/chowner_multi__done' => "Valitut käyttäjätilit siirrettiin toiselle omistajalle.",
    'ui__client/chowner_multi-select__done' => 'Toiminto onnistui.',
    'ui__client/chowner_select__done' => 'Toiminto onnistui.',
    'ui__client/domain/certificate/properties__done' => 'SSL/TLS-varmenteen ominaisuudet päivitettiin.',
    'ui__client/domain/certificate/properties_new__done' => 'Uusi SSL/TLS-varmenne lisättiin. Ottaaksesi sen käyttöön, sinun on valittava se verkkosivuston isännöintiasetuksista (Verkkosivustot & toimialueet -välilehti> toimialueen nimi).',
    'ui__client/domain/certificate__done' => 'Toiminto onnistui.',
    'ui__client/domain/certificate_self__done' => 'Toiminto onnistui.',
    'ui__client/domain/check-permissions_multi__done' => 'Käyttöoikeustarkistus valituilla toimialueilla suoritettiin loppuun.', // PFW
    'ui__client/domain/chowner__done' => 'Tilaus %1 kuuluu nyt toiselle käyttäjälle.',
    'ui__client/domain/chowner_multi__done' => 'Tilauksen omistajuutta muutettiin.',
    'ui__client/domain/chowner_multi-select__done' => 'Toiminto onnistui.',
    'ui__client/domain/chowner_select__done' => 'Toiminto onnistui.',
    'ui__client/domain/dbbackup/create__done' => "Tietokannan varmuuskopiointi onnistui.", // PFW
    'ui__client/domain/dbbackup/get__done' => "Tietokannan varmuuskopiointi onnistui.", // PFW
    'ui__client/domain/dbbackup/orphaned__done' => "Yhteydetön käyttäjä korjattiin onnistuneesti.", // PFW
    'ui__client/domain/dbbackup/remove__done' => "Varmuuskopiointitiedostot poistettiin onnistuneesti.", // PFW
    'ui__client/domain/dbbackup/restore__done' => "Tietokannan sisältö palautettiin onnistuneesti.", // PFW
    'ui__client/domain/dbbackup/upload__done' => "Toiminto onnistui.", // PFW
    'ui__client/domain/dbbackup__done' => "Toiminto onnistui.", // PFW
    'ui__client/domain/dbbackup_self__done' => "Toiminto onnistui.", // PFW
    'ui__client/domain/dbbackup_unknown__done' => "Toiminto onnistui.", // PFW
    'ui__client/domain/delete__done' => "Toimialue %1 poistettiin.",
    'ui__client/domain/delete_multi__done' => "Toimialueet poistettiin.",
    'ui__client/domain/disable__done' => 'Toimialue %1 keskeytettiin.',
    'ui__client/domain/disable_multi__done' => 'Valitut toimialueet on peruutettu.',
    'ui__client/domain/enable__done' => 'Verkkosivusto %1 aktivoitiin.',
    'ui__client/domain/enable_multi__done' => 'Valitut verkkosivustot aktivoitiin.',
    'ui__client/domain/extras__done' => 'MyPlesk.com-sivu avattiin.',
    'ui__client/domain/extras_self__done' => 'MyPlesk.com-sivu avattiin.',
    'ui__client/domain/hosting/file-manager/copy-move__done' => 'Valitut tiedostot ja hakemistot kopioitiin tai siirrettiin.',
    'ui__client/domain/hosting/file-manager/create-dir__done' => 'Hakemisto luotiin.',
    'ui__client/domain/hosting/file-manager/create-file__done' => 'Tiedosto luotiin.',
    'ui__client/domain/hosting/file-manager/edit__done' => 'Tiedosto päivitettiin.',
    'ui__client/domain/hosting/file-manager/permissions__done' => 'Tiedoston tai hakemiston käyttöoikeudet päivitettiin.', // PFU
    'ui__client/domain/hosting/file-manager/rename__done' => 'Hakemisto tai tiedosto nimettiin uudelleen.',
    'ui__client/domain/hosting/file-manager/remove__done' => 'Valitut tiedostot ja hakemistot poistettiin.',
    'ui__client/domain/hosting/file-manager/remove_self__done' => 'Valitut tiedostot ja hakemistot poistettiin.',
    'ui__client/domain/hosting/file-manager/view__done' => 'Toiminto onnistui.',
    'ui__client/domain/hosting/file-manager__done' => 'Toiminto onnistui.',
    'ui__client/domain/hosting/file-manager_self__done' => 'Toiminto onnistui.',
    'ui__client/domain/hosting/hotlink-protection__done' => 'Toiminto onnistui.', // PFW
    'ui__client/domain/hosting/hotlink-protection_self__done' => 'Toiminto onnistui.', // PFW
    'ui__client/domain/hosting/logs/rotation__done' => 'Lokikierron asetukset on muutettu.',
    'ui__client/domain/hosting/logs/rotation_self__done' => 'Lokikierron asetukset on muutettu.',
    'ui__client/domain/hosting/logs__done' => 'Toiminto onnistui.',
    'ui__client/domain/hosting/logs_self__done' => 'Toiminto onnistui.',
    'ui__client/domain/hosting/performance__done' => 'Verkkosivuston %1 isännöinnin suorituskykyasetuksia muutettiin.',
    'ui__client/domain/hosting/performance_self__done' => 'Verkkosivustosi isännöinnin suorituskykyasetuksia muutettiin.',
    'ui__client/domain/hosting/performance_unknown__done' => 'Verkkosivuston isännöinnin suorituskykyasetuksia muutettiin.',
    'ui__client/domain/hosting/php__done' => 'PHP-asetuksia muutettiin.', // PFW
    'ui__client/domain/hosting/php_self__done' => 'Toiminto onnistui.', // PFW
    'ui__client/domain/hosting/protected-directories__done' => 'Toiminto onnistui.',
    'ui__client/domain/hosting/protected-directories_self__done' => 'Toiminto onnistui.',
    'ui__client/domain/hosting/setup__done' => '%1:n isännöinti määritettiin.',
    'ui__client/domain/hosting/ssh-terminal__done' => 'Toiminto onnistui.', // PFU
    'ui__client/domain/hosting/ssh-terminal_self__done' => 'Toiminto onnistui.', // PFU
    'ui__client/domain/hosting/virtual-directories__done' => 'Toiminto onnistui.', // PFW
    'ui__client/domain/hosting/virtual-directories_self__done' => 'Toiminto onnistui.', // PFW
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version__done' => 'ASP.NET-versio muutettiin.', // PFW
    'ui__client/domain/hosting/web-directories/aspdotnet__done' => 'ASP.NET-asetuksia %1 muutettiin.', // PFW
    'ui__client/domain/hosting/web-directories/create-dir__done' => 'Näennäishakemisto luotiin verkkosivustossa %1.', // PFW
    'ui__client/domain/hosting/web-directories/create-virtual-dir__done' => 'Näennäishakemisto luotiin.', // PFW
    'ui__client/domain/hosting/web-directories/delete__done' => 'Valitut hakemistot poistettiin.', // PFW
    'ui__client/domain/hosting/web-directories/delete_self__done' => 'Valitut hakemistot poistettiin.', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__done' => 'Mukautetut virheasiakirjat päivitettiin.', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__done' => 'Valitut MIME-tyypit poistettiin', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__done' => 'Uusi MIME-tyyppi rekisteröitiin.', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties__done' => 'Toiminto onnistui.', // PFW
    'ui__client/domain/hosting/web-directories/permissions__done' => 'Hakemiston käyttöoikeudet päivitettiin.', // PFW
    'ui__client/domain/hosting/web-directories/permissions_self__done' => 'Hakemiston käyttöoikeudet päivitettiin.', // PFW
    'ui__client/domain/hosting/web-directories/php__done' => '%1:n PHP-asetukset päivitettiin.', // PFW
    'ui__client/domain/hosting/web-directories/php_self__done' => '%1:n PHP-asetukset päivitettiin.', // PFW
    'ui__client/domain/hosting/web-directories/properties__done' => 'Hakemiston ominaisuudet päivitettiin.', // PFW
    'ui__client/domain/hosting/web-directories/properties_self__done' => 'Hakemiston ominaisuudet päivitettiin.', // PFW
    'ui__client/domain/hosting/web-directories/protection__done' => 'Hakemiston suojausasetukset päivitettiin.', // PFW
    'ui__client/domain/hosting/web-directories/protection_self__done' => 'Hakemiston suojausasetukset päivitettiin.', // PFW
    'ui__client/domain/hosting/web-directories__done' => 'Toiminto onnistui.', // PFW
    'ui__client/domain/hosting/web-directories_self__done' => "Toiminto onnistui.", // PFW
    'ui__client/domain/mpc-certificates__done' => 'Verkkokaupassa käytettävissä olevat SSL/TLS-varmenteet',
    'ui__client/domain/mpc-certificates_self__done' => 'Verkkokaupassa käytettävissä olevat SSL/TLS-varmenteet',
    'ui__client/domain/odbc__done' => 'Toiminto onnistui.', // PFW
    'ui__client/domain/odbc_self__done' => 'Toiminto onnistui.', // PFW
    'ui__client/domain/properties__done' => "Toimialueen järjestelmänvalvojan tiliä muutettiin.",
    'ui__client/domain/properties_new__done' => "Toimialue %1 on luotu.",
    'ui__client/domain/properties_self__done' => "Toimialueen ominaisuuksia muutettiin.",
    'ui__client/domain/register__done' => 'MyPlesk.com-sivu avattiin.',
    'ui__client/domain/register_self__done' => 'MyPlesk.com-sivu avattiin.',
    'ui__client/domain/rename__done' => 'Toimialueen nimeä muutettiin.',
    'ui__client/domain/rename_self__done' => "Toimialueen nimen vaihtaminen onnistui.",
    'ui__client/domain/report/anon-ftp-stats__done' => 'Toiminto onnistui.',
    'ui__client/domain/report/ftp-stats__done' => 'Toiminto onnistui.',
    'ui__client/domain/report/ftp-stats_self__done' => 'Toiminto onnistui.',
    'ui__client/domain/report/traffic-history__done' => 'Toiminto onnistui.',
    'ui__client/domain/report/traffic-history_self__done' => 'Toiminto onnistui.',
    'ui__client/domain/report/webalizer-preferences__done' => 'Toiminto onnistui.', // PFU
    'ui__client/domain/report/webalizer-preferences_self__done' => 'Toiminto onnistui.', // PFU
    'ui__client/domain/report/web-stats__done' => 'Verkkosivuston tilastosivu avattiin.',
    'ui__client/domain/report/web-stats_self__done' => 'Verkkosivuston tilastosivu avattiin.',
    'ui__client/domain/report/web-stats-ssl__done' => 'Verkkosivuston tilastosivu avattiin.',
    'ui__client/domain/report/web-stats-ssl_self__done' => 'Verkkosivuston tilastosivu avattiin.',
    'ui__client/domain/report__done' => 'Toiminto onnistui.',
    'ui__client/domain/report_self__done' => 'Toiminto onnistui.',
    'ui__client/domain/settings_self__done' => 'Toiminto onnistui.',
    'ui__client/domain/to-client__done' => 'Toimialueen järjestelmänvalvojan tili %1 muutettiin asiakastiliksi.',
    'ui__client/domain/to-client_multi__done' => 'Toimialueen järjestelmänvalvojan tilit muutettiin asiakastileiksi.',
    'ui__client/domain/toggle_disable__done' => "Toimialue %1 keskeytettiin.",
    'ui__client/domain/toggle_enable__done' => "Toimialue %1 aktivoitiin.",
    'ui__client/domain/traffic__done' => 'Toiminto onnistui.',
    'ui__client/domain/traffic_self__done' => 'Toiminto onnistui.',
    'ui__client/domain/traffic_unknown__done' => 'Toiminto onnistui.',
    'ui__client/domain/web-stats__done' => 'Toiminto onnistui.',
    'ui__client/domain-summary-report__done' => 'Toiminto onnistui.',
    'ui__client/domain-summary-report_self__done' => 'Toiminto onnistui.',
    'ui__client/domain-summary-report_unknown__done' => 'Toiminto onnistui.',
    'ui__client/extras-domain__done' => 'MyPlesk.com-sivu avattiin.',
    'ui__client/extras-domain_self__done' => 'MyPlesk.com-sivu avattiin.',
    'ui__client/ipaddress/delete_multi__done' => 'Toiminto onnistui.',
    'ui__client/ipaddress/properties__done' => 'Toiminto onnistui.',
    'ui__client/ipaddress/properties_new__done' => 'Toiminto onnistui.',
    'ui__client/ip-pool/properties__done' => "Asiakkaan %1 IP-sarja päivitettiin.",
    'ui__client/ip-pool/properties_self__done' => 'Toiminto onnistui.',
    'ui__client/limits__done' => "Asiakkaan %1 resurssirajoja muutettiin.",
    'ui__client/limits_self__done' => 'Toiminto onnistui.',
    'ui__client/logo__done' => 'Asiakkaan %1 uudet tuotemukautuksen asetukset käytettiin.',
    'ui__client/logo_reseller__done' => 'Uudet paneelin tuotemukautuksen asetukset käytettiin.',
    'ui__client/logo_self__done' => 'Tuotemukautuksen asetukset käytettiin.',
    'ui__client/logo_self-reseller__done' => 'Ohjauspaneeliin mukautusasetukset on otettu käyttöön.',
    'ui__client/manage-domain__done' => 'MyPlesk.com-sivu avattiin.',
    'ui__client/manage-domain_self__done' => 'MyPlesk.com-sivu avattiin.',
    'ui__client/permissions__done' => "Asiakkaan %1 käyttölupia muutettiin.",
    'ui__client/permissions_self__done' => 'Toiminto onnistui.',
    'ui__client/preferences__done' => "Asiakkaan %1 omia asetuksia muutettiin.",
    'ui__client/preferences_self__done' => "Omia asetuksiasi muutettiin.",
    'ui__client/register-domain__done' => 'MyPlesk.com-sivu avattiin.',
    'ui__client/register-domain_self__done' => 'MyPlesk.com-sivu avattiin.',
    'ui__client/report/traffic-history__done' => 'Toiminto onnistui.',
    'ui__client/report/traffic-history_self__done' => 'Toiminto onnistui.',
    'ui__client/report__done' => 'Toiminto onnistui.',
    'ui__client/report_self__done' => 'Toiminto onnistui.',
    'ui__client/sessions/delete__done' => 'Toiminto onnistui.',
    'ui__client/sessions/delete_self__done' => 'Toiminto onnistui.',
    'ui__client/sessions__done' => 'Toiminto onnistui.',
    'ui__client/sessions_self__done' => 'Toiminto onnistui.',
    'ui__client/skeleton__done' => 'Toiminto onnistui.',
    'ui__client/skeleton_self__done' => 'Toiminto onnistui.',
    'ui__client/to-reseller__done' => 'Asiakastili %1 muutettiin jälleenmyyjän tiliksi.',
    'ui__client/to-reseller_multi__done' => "Valitut asiakastilit muutettiin jälleenmyyjän tileiksi.",
    'ui__client/traffic__done' => "Toiminto onnistui.",
    'ui__client/traffic_unknown__done' => 'Toiminto onnistui.',
    'ui__cp-access__done' => 'Toiminto onnistui.',
    'ui__cp-session/properties__done' => 'Toiminto onnistui.',
    'ui__cp-session__done' => 'Toiminto onnistui.',
    'ui__ftp-sessions__done' => 'Toiminto onnistui.',
    'ui__license__done' => 'Toiminto onnistui.',
    'ui__logo__done' => "Plesk -tuotemukautuksen ominaisuuksia muutettiin.",
    'ui__longtasks/longtask/properties__done' => "Taustatoimintojen asetuksia muutettiin onnistuneesti.",
    'ui__mass-email/delete__done' => "Viestin malli %1 poistettiin.", // PFW
    'ui__mass-email/delete_multi__done' => "Viestin mallit poistettiin.",  // PFW
    'ui__mass-email/send_main__done' => "Toiminto onnistui.",  // PFW
    'ui__mass-email/send_selectclients__done' => "Asiakastilit valittiin onnistuneesti.",  // PFW
    'ui__mass-email/send_selectdomainusers__done' => "Toimialueen järjestelmänvalvojan tilit valittiin onnistuneesti.",  // PFW
    'ui__mass-email/send_selectresellers__done' => 'Jälleenmyyjän tilit valittiin onnistuneesti.',  // PFW
    'ui__mass-email/template/properties_main__done' => 'Muutokset massasähköpostiviestin malliin tallennettiin.', // PFW
    'ui__mass-email/template/properties_new-main__done' => 'Massasähköpostiviestin mallin luotiin.', // PFW
    'ui__mass-email/template/properties_new-selectclients__done' => 'Massasähköpostiviestin mallin asiakastilit valittiin.',  // PFW
    'ui__mass-email/template/properties_new-selectdomainusers__done' => 'Massasähköpostiviestin mallin toimialueen järjestelmänvalvojan tilit valittiin.', // PFW
    'ui__mass-email/template/properties_new-selectresellers__done' => 'Massasähköpostiviestin mallin jälleenmyyjän tilit valittiin.',  // PFW
    'ui__mass-email/template/properties_unknown__done' => "Massasähköpostiviestin mallia muutettiin.",  // PFW
    'ui__mass-email/template/properties__invalid_values' => 'Virheelliset arvot määritetty.', // PFW
    'ui__mass-email__done' => "Toiminto onnistui.", // PFW
    'ui__mass-mail__done' => "Toiminto onnistui.", // PFU
    'ui__mass-mail/delete__done' => 'Viestin malli %1 poistettiin.', // PFU
    'ui__mass-mail/delete_multi__done' => 'Viestin mallit poistettiin.', // PFU
    'ui__mass-mail/properties__done' => 'Mallia %1 muutettiin.', // PFU
    'ui__mass-mail/properties_new__done' => 'Malli %1 luotiin.', // PFU
    'ui__mass-mail/send__done' => 'Viestit lähetettiin.', // PFU
    'ui__mass-mail/send_new__done' => 'Viestit lähetettiin.', // PFU
    'ui__mass-mail/send_unknown__done' => 'Viestit lähetettiin.',  // PFU
    'ui__mass-mail/send_unknown-new__done' => 'Viestit lähetettiin.', // PFU
    'ui__mass-mail/template/properties_new__done' => 'Uusi viestimallin luotiin.', // PFU
    'ui__mass-mail/template/properties__done' => 'Viestimallia muutettiin.', // PFU
    'ui__modules/watchdog/disk/properties__done' => 'Uudet levyn tarkkailuasetukset käytettiin.', // PFU
    'ui__modules__done' => 'Toiminto onnistui.',
    'ui__modules__short-title' => 'Tunnisteet',
    'ui__modules__title' => 'Tunnisteet',
    'ui__reseller/client/chowner_multi__done' => 'Valitut asiakastilit siirrettiin toiselle omistajalle.',
    'ui__reseller/client/chowner_multi-select__done' => 'Toiminto onnistui.',
    'ui__reseller/client/traffic_unknown__done' => 'Toiminto onnistui.',
    'ui__reseller/extras-domain__done' => 'MyPlesk.com-sivu avattiin.',
    'ui__reseller/extras-domain_self__done' => 'MyPlesk.com-sivu avattiin.',
    'ui__reseller/ftp-sessions_self__done' => 'Toiminto onnistui.',
    'ui__reseller/limits__done' => "Jälleenmyyjän resurssirajoja ja resurssin käyttöä koskevia käytäntöjä muutettiin.",
    'ui__reseller/limits_readonly-self__done' => 'Toiminto onnistui.',
    'ui__reseller/limits_self__done' => 'Resurssirajojasi ja resurssin käyttöä koskevia käytäntöjä muutettiin.',
    'ui__reseller/manage-domain__done' => 'MyPlesk.com-sivu avattiin.',
    'ui__reseller/manage-domain_self__done' => 'MyPlesk.com-sivu avattiin.',
    'ui__reseller/permissions__done' => 'Jälleenmyyjän %1 käyttölupia muutettiin.',
    'ui__reseller/permissions_readonly-self__done' => '',
    'ui__reseller/permissions_self__done' => 'Toiminto onnistui.',
    'ui__reseller/register-domain__done' => 'MyPlesk.com-sivu avattiin.',
    'ui__reseller/register-domain_self__done' => 'MyPlesk.com-sivu avattiin.',
    'ui__reseller/report/layout/auto/delete_multi__done' => 'Valitut raportin toimitusaikataulut poistettiin.',
    'ui__reseller/report/layout/auto/properties__done' => 'Raportin toimitusaikataulu on päivitetty.',
    'ui__reseller/report/layout/auto/properties_new__done' => 'Raportin toimitusaikataulu lisättiin.',
    'ui__reseller/report/layout/properties__done' => 'Raportin asetelmaa muutettiin.',
    'ui__reseller/report/layout/properties_new__done' => 'Uusi raportin asetelma luotiin.',
    'ui__reseller/report/traffic-history__done' => 'Toiminto onnistui.',
    'ui__reseller/report/traffic-history_self__done' => 'Toiminto onnistui.',
    'ui__reseller/report__done' => 'Toiminto onnistui.',
    'ui__reseller/report_self__done' => 'Toiminto onnistui.',
    'ui__reseller/sessions/delete__done' => 'Toiminto onnistui',
    'ui__reseller/sessions/delete_self__done' => 'Toiminto onnistui',
    'ui__reseller/sessions__done' => 'Toiminto onnistui.',
    'ui__reseller/sessions_self__done' => 'Toiminto onnistui.',
    'ui__reseller/to-client__done' => 'Jälleenmyyjän tili %1 muutettiin asiakastiliksi.',
    'ui__reseller/to-client_multi__done' => "Valitut jälleenmyyjän tilit muutettiin asiakastileiksi.",
    'ui__reseller/traffic__done' => 'Toiminto onnistui.',
    'ui__reseller/traffic_self__done' => 'Toiminto onnistui.',
    'ui__reseller/traffic_unknown__done' => 'Toiminto onnistui.',
    'ui__reseller/logo_self__title' => 'Pleskin tuotemukautus',
    'ui__reseller/logo_self__done' => 'Pleskin mukautusasetukset on otettu käyttöön.',
    'ui__server/aspdotnet__done' => 'Palvelimen laajuisia ASP.NET-asetuksia muutettiin.', // PFW
    'ui__server/certificate/default_multi__done' => 'Valittu SSL/TLS-varmenne asetettiin uusien isännöityjen verkkosivustojen yhteyksien suojaamiseksi.',
    'ui__server/certificate/delete_multi__done' => 'Valitut SSL/TLS-varmenteet poistettiin.',
    'ui__server/certificate/download__done' => 'SSL/TLS-varmenne ladattiin.',
    'ui__server/certificate/properties__done' => 'SSL/TLS-varmenteen ominaisuudet päivitettiin.',
    'ui__server/certificate/properties_new__done' => 'SSL/TLS-varmenne %1 luotiin.',
    'ui__server/certificate/setup_multi__done' => 'SSL/TLS-varmenne asetettiin Pleskin yhteyksien suojaamiseksi.',
    'ui__server/certificate__done' => 'Toiminto onnistui.',
    'ui__server/components__done' => 'Toiminto onnistui.',
    'ui__server/cp-certificate-download__done' => "Pleskin SSL/TLS-varmenne ladattiin.",
    'ui__server/crontab/properties__done' => 'Aikataulutettuja tehtäviä %1 muutettiin.',
    'ui__server/crontab/task/delete__done' => 'Tehtävä poistettiin.',
    'ui__server/crontab/task/delete_multi__done' => 'Tehtävät poistettiin.',
    'ui__server/crontab/task/properties__done' => 'Aikataulutetut tehtävät päivitettiin.',
    'ui__server/crontab/task/properties_new__done' => 'Uusi tehtävä on ajoitettu.',
    'ui__server/crontab/task/toggle_disable__done' => 'Aikataulutettu tehtävä %1 poistettiin käytöstä.',
    'ui__server/crontab/task/toggle_enable__done' => 'Aikataulutettu tehtävä %1 otettiin käyttöön.',
    'ui__server/crontab__done' => 'Toiminto onnistui.',
    'ui__server/dns__done' => 'Toiminto onnistui.',
    'ui__server/ftp-settings__done' => "SSL-asetuksia muutettiin onnistuneesti.",
    'ui__server/ip-address/client/delete__done' => "IP-osoite poistettiin käyttäjän IP-sarjoista.",
    'ui__server/ip-address/client/delete_multi__done' => "IP-osoite poistettiin käyttäjien IP-sarjoista.",
    'ui__server/ip-address/client/properties_new__done' => 'IP-osoite määritettiin käyttäjille.',
    'ui__server/ip-address/ip-address/add-to-clients_add-target__done' => 'IP-osoite %1 määritettiin valituille asiakkaille.',
    'ui__server/ip-addresses__done' => "Toiminto onnistui.",
    'ui__server/mail/statistics/spam/recipients__done' => "Toiminto onnistui.",
    'ui__server/mail/statistics/spam/summary__done' => "Toiminto onnistui.",
    'ui__server/mail/statistics/spam__done' => "Toiminto onnistui.",
    'ui__server/mail/statistics/virus/recipients__done' => "Toiminto onnistui.",
    'ui__server/mail/statistics/virus/summary__done' => "Toiminto onnistui.",
    'ui__server/mail/statistics/virus/viruses__done' => "Toiminto onnistui.",
    'ui__server/mail/statistics/virus__done' => "Toiminto onnistui.",
    'ui__server/mail/statistics__done' => "Toiminto onnistui.",
    'ui__server/mail__done' => 'Sähköpostipalvelimen asetuksia muutettiin.',
    'ui__server/maillists__done' => 'Toiminto onnistui.',
    'ui__server/mpc-certificates__done' => 'Verkkotallennuksen sivu, jossa on luettelo saatavilla olevista SSL/TLS-varmenteista, avattiin.',
    'ui__server/odbc__done' => 'Palvelimen laajuisia ODBC-asetuksia muutettiin.', // PFW
    'ui__server/pmm__done' => 'Toiminto onnistui.',
    'ui__server/preferences__done' => "Palvelimen asetuksia muutettiin.",
    'ui__server/register__done' => 'MyPlesk.com-sivu avattiin.',
    'ui__server/resources__done' => 'Toiminto onnistui.',
    'ui__server/services__done' => 'Toiminto onnistui.',
    'ui__server/sitebuilder__done' => 'Toiminto onnistui.',
    'ui__server/skeleton__done' => 'Toiminto onnistui.',
    'ui__server/spam-filter/black-list/address/delete__done' => 'Osoite %1 poistettiin palvelimen laajuiselta mustalta listalta.',
    'ui__server/spam-filter/black-list/address/delete_multi__done' => 'Osoitteet poistettiin palvelimen laajuiselta mustalta listalta.',
    'ui__server/spam-filter/black-list/address/properties_new__done' => 'Osoitteet lisättiin mustalle listalle.',
    'ui__server/spam-filter/black-list/address__done' => 'Osoitteet lisättiin mustalle listalle.',
    'ui__server/spam-filter/black-list__done' => 'Toiminto onnistui.', // PFU
    'ui__server/spam-filter/properties__done' => 'Roskapostisuodattimen asetuksia muutettiin.',
    'ui__server/spam-filter/toggle_disable__done' => 'Roskapostisuodatus otettiin pois käytöstä järjestelmän laajuisesti.',
    'ui__server/spam-filter/toggle_enable__done' => 'Roskapostisuodatus otettiin käyttöön järjestelmän laajuisesti.',
    'ui__server/spam-filter/white-list/address/delete__done' => 'Osoite %1 poistettiin palvelimen laajuiselta sallittujen listalta.',
    'ui__server/spam-filter/white-list/address/delete_multi__done' => 'Osoitteet poistettiin palvelimen laajuiselta sallittujen listalta.',
    'ui__server/spam-filter/white-list/address/properties_new__done' => 'Osoitteet lisättiin valkoiselle listalle.',
    'ui__server/spam-filter/white-list/address__done' => 'Osoitteet lisättiin valkoiselle listalle.',
    'ui__server/spam-filter/white-list__done' => 'Toiminto onnistui.', // PFU
    'ui__server/spam-filter__done' => 'Toiminto onnistui.',
    'ui__server/statistics__done' => 'Toiminto onnistui.',
    'ui__server/time__done' => "Järjestelmän päivämäärää ja aikaa muutettiin.",
    'ui__server__done' => "Toiminto onnistui.",
    'ui__sessions/properties__done' => 'Toiminto onnistui.',
    'ui__sessions__done' => 'Toiminto onnistui.',
    'ui__sessions/delete__done' => 'Valitut istunnot poistettiin.',
    'ui__start-page__done' => 'Toiminto onnistui.',
    'ui__support__done' => 'Tukipyyntölomake avattiin selaimen uudessa ikkunassa tai uudella välilehdellä.',
    'ui__ts-sessions__done' => 'Toiminto onnistui.',

    ///
    /// END OF DONE MESSAGES
    ///

    ///
    /// ASSORTED COMMON KEYS / TBI
    ///

    // non-UI
    '__no_files_to_upload' => 'Ei ladattavia tiedostoja.',
    'login_up__access_denied_no_permission' => "Käyttö estetty. Sinulla ei ole kirjautumisoikeutta.",
    'mail__unable_remove_pattern' => "Osoitetta ei voida poistaa palvelimen mustalta listalta: %1", // PFW
    'mail__incorrect_network_format' => 'Virheellinen verkkomuoto: %1', // PFW
    'initconf__unable_change_passwd' => "Järjestelmänvalvojan salasanaa ei voi vaihtaa: %1",
    'initconf__unable_get_passwd' => 'Nykyistä järjestelmänvalvojan salasanaa ei voitu saada: %1 epäonnistui: %2',
    'initconf__invalid_hostname' => 'Virhe isäntänimessä "%1"',
    'initconf__unable_reconfig' => 'Pleskiä ei voitu määrittää: reconfig epäonnistui: %1',
    'initconf__unable_update_admin' => 'Järjestelmänvalvojan yhteystietoja ei voitu päivittää: %1',
    '__refresh' => 'Päivitä',
    '__dalias_not_exist' => 'Toimialueen aliasta ei ole.',
    '__bug146523_explanation' => 'Edelliset Plesk -versiot sallivat jopa 16 merkin käytön FTP-käyttäjätunnuksissa. Tämä Plesk -versio rajoittaa FTP-käyttäjätunnuksien merkkien maksimimäärään 15. Tämä ongelma voidaan ratkaista lyhentämällä FTP-käyttäjätunnuksen pituus 15 merkkiin kyseessä olevien FTP-käyttäjätunnuksien kohdalla ja muuttamalla vähintään yksi merkki kyseessä olevissa FTP-käyttäjätunnuksissa käyttäjätunnuksen ristiriitojen välttämiseksi. Pahoittelemme mahdollisista tämän ongelman aiheuttamista ongelmista.',
    'domain__cannot_change_webmail' => 'Verkkosähköpostia ei voida muuttaa toimialueella: %1',
    'sb_publish_disable_warning' => 'Jos poistat käytöstä verkkosivuston luomisen Presence Builderilla, aikaisemmin Presence Builderissa luotu verkkosivusto poistetaan ja kaikki verkkosivuston tiedot menetetään. Jatka napsauttamalla OK.',
    '__sbnet_client_use_sbnet' => "Luo vastaava käyttäjätili Presence Builderissa",
    'mail_resp_activate' => 'Ota käyttöön automaattinen vastaus',
    'limitsManger__limit_available_error' => 'Vaadittua resurssimäärää ("%%limitName%%") ei voida määrittää: vain %%available%% on saatavilla tilillesi.',
    'limitsManger__limit_reserved_error' => 'Käytössä olevaa pienempää resurssimäärää ("%%limitName%%") ei voida määrittää.',
    'domain__unable_to_rename_vhost_dir_already_exists' => 'Toimialuetta ei voida nimetä uudelleen: samanniminen näennäishakemisto on jo olemassa.',
    'domain_unable_to_rename' => 'Toimialuetta ei voi nimetä uudelleen.',

    // Greylisting
    'spamfilter__general_settings_legend' => 'Yleiset',
    'spamfilter__spamassassin_status_legend' => 'SpamAssassin-roskapostisuodatus',
    'spamfilter__spamassassin_settings_legend' => 'SpamAssassin-asetukset',
    'spamfilter__spamassassin_server_status_legend' =>  "Ota palvelimen laajuinen SpamAssassin-roskapostisuodatus käyttöön",
    'spamfilter__spamassassin_user_status_legend' => 'Ota SpamAssassin-roskapostisuodatus käyttöön',
    'spamfilter__greylisting_status_legend' => 'Ota käyttöön palvelimen laajuinen harmaan listan roskapostisuodatus',
    'spamfilter__personal_settings_not_allowed' => 'Järjestelmän käytäntö ei salli yksittäisiä roskapostisuodatuksen asetuksia.',
    'spamfilter__required_score' => 'Pistemäärä, jonka sähköpostin on saatava roskapostiluokituksessa',
    'spamfilter__rewrite_header_subject' => 'Lisää seuraava teksti aiheen alkuun kaikissa roskapostiksi luokitelluissa viesteissä',
    'spamfilter__use_mailuser_prefs' => 'Käytä yksittäisiä asetuksia roskapostisuodatukseen',
    'spamfilter_addresses__text_hint' => 'Erota useat osoitteet uudella rivillä, välilyönnillä, välilehdellä, pilkulla tai puolipisteellä. Muita kuin ASCII-merkkejä ei saa olla merkin @ vasemmalla puolella. Osoitteissa voi olla "*" ja "?" yleismerkkejä (esim. *@domain.com, user?@*.com). Toimialueiden muut kuin ASCII-osat eivät saa sisältää yleismerkkejä.',
    'spamfilter__score_error' => 'Pistemäärä ei saa olla negatiivinen, desimaalipistettä edeltävän osan on oltava alle 100, se voi sisältää korkeintaan kaksi numeroa desimaalipisteen jälkeen.',
    'spamfilter__rewrite_header_error' => 'Viestin aihekentässä voi olla tulostettavia merkkejä, numeromerkkiä (#) lukuun ottamatta.',

    // template conflict keys
    'nonexistent_mail__mode_bounce' => 'Bounce',
    'nonexistent_mail__mode_discard' => 'Hylkää',
    'nonexistent_mail__mode_catch_addr' => 'Lähetä edelleen sähköpostiosoitteeseen',
    'nonexistent_mail__mode_catch_ip' => 'Lähetä edelleen IP-osoitteeseen',
    'nonexistent_mail__bounce_not_supported' => 'Bounce-tilaa ei tueta',
    'nonexistent_mail__discard_not_supported' => 'Hylkäystilaa ei tueta',
    'nonexistent_mail__catch_not_supported' => 'Edelleenlähetystä sähköpostiosoitteeseen ei tueta',
    'nonexistent_mail__redirect_not_supported' => 'Edelleenlähetystä IP-osoitteeseen ei tueta',
    'nonexistent_mail__ip_used_on_this_host' => 'IP-osoite kohdistuu paikalliseen isäntään',
    'nonexistent_mail_address_should_be_local_domain' => 'Koska lähtevän postin valvonta on käytössä, muiden kuin olemassa olevien vastaanottajien sähköpostiosoitteen %1 tulee kuulua valittuun toimialueeseen. Muussa tapauksessa sovelletaan "Reject" -käytäntöä edelleenlähetyksen sijaan.',
    'nonexistent_mail_address_should_be_local_domain_not_restricted' => 'Koska lähtevän postin hallinta on päällä, postin edelleenlähetykseen määritetyn sähköpostiosoitteen (%1) tulee kuulua valittuun toimialueeseen. Muussa tapauksessa lähtevän postin hallinta ei huomioi kyseiseen osoitteeseen lähetettyjä viestejä.',
    // mail acc extras
    '__antivirus' => "AntiVirus",

    // web apps

    // none available
    'ui__admin-alias__none-available' => 'Ylimääräisiä järjestelmänvalvojan tilejä ei ole saatavilla.', // PFW
    'ui__client/domain/certificate__none-available' => 'Asiakkaalla ei ole SSL/TLS-varmenteita.',
    'ui__client/domain/certificate__none-available__1' => 'Asiakkaalla ei ole toimialueita SSL/TLS-varmenteilla.',
    'ui__client/domain/certificate__none-available__2' => 'Toimialueella ei ole SSL/TLS-varmenteita.',
    'ui__reseller/client__none-available' => 'Asiakkaita omaavia jälleenmyyjiä ei ole.',

    // empty selection for lists
    'ui__client/ipaddress/delete__empty_selection' => 'Sinun on valittava IP-osoitteet, jotka haluat poistaa IP-sarjasta.',
    'ui__reseller/client/chowner__empty_selection' => 'Sinun on valittava asiakastilit, jotka haluat määrittää uudelle omistajalle.',
    'ui__server/ip-address/client/delete__empty_selection' => 'Sinun tulee valita ne jälleenmyyjien tilit, joiden IP-sarjoista haluat torjua IP-osoitteen.',
    'ui__server/crontab/task/delete__empty_selection' => 'Sinun täytyy valita tehtävä, jonka haluat peruuttaa.',

    // scripting languages errors
    'phosting__php_not_enabled' => 'PHP-tuki on poistettu käytöstä tämän verkkosivuston kohdalla.',
    'phosting__aspdotnet_not_enabled' => 'ASP.NET -tuki on poistettu käytöstä tämän verkkosivuston kohdalla.',
    'phosting__php_forced_by_site_isolation' => 'PHP-asetuksia ei voida muuttaa: käyttöoikeus ei salli palvelimen laajuisen turvallisuuskäytännön ylikirjoitusta.',
    'phosting__option_forced_by_site_isolation' => 'Asetuksia %1 ei voida muuttaa: käyttöoikeus ei salli palvelimen laajuisen turvallisuuskäytännön ylikirjoitusta.',
    'phosting__mod_bw_disabled_by_vps_optimized' => 'mod_bw on poistettu käytöstä, koska Plesk toimii VPS-optimoidussa tilassa.',
    'phosting__mod_php_disabled_by_vps_optimized' => 'mod_php on poistettu käytöstä, koska Plesk toimii VPS-optimoidussa tilassa.',
    'phosting__perl_disabled_by_vps_optimized' => 'Perl on poistettu käytöstä, koska Plesk toimii VPS-optimoidussa tilassa.',
    'phosting__asp_disabled_by_vps_optimized' => 'ASP on poistettu käytöstä, koska Plesk toimii VPS-optimoidussa tilassa.',
    'phosting__python_disabled_by_vps_optimized' => 'Python on poistettu käytöstä, koska Plesk toimii VPS-optimoidussa tilassa.',
    'phosting__fastcgi_disabled_by_vps_optimized' => 'fastcgi on poistettu käytöstä, koska Plesk toimii VPS-optimoidussa tilassa.',
    'phosting__php_handler_id_not_registered' => 'PHP-käsittelijää ei sallita sivuston eristysasetuksissa. PHP-oletuskäsittelijää käytetään.',
    'phosting__php_served_by_nginx_is_not_available' => 'PHP-käsittelijää (FPM-sovellus, jota palvelee nginx) ei sallita sivuston eristysasetuksissa. PHP-oletuskäsittelijää käytetään.',

    // various UI
    'ui__client/ipaddress/properties_readonly__short-title' => 'Näytä IP-osoitteiden luettelo',
    'ui__client/ipaddress/properties_readonly__title' => 'Näytä IP-osoitteiden luettelo',
    'ui__client/ipaddress/properties_readonly__description' => 'Näytä luettelo tälle käyttäjälle saatavilla olevista IP-osoitteista.',
    'ui__server/certificate__short-title' => 'SSL/TLS-varmenteet',
    'ui__server/certificate__title' => 'SSL/TLS-varmenteet',
    'ui__server/certificate__description' => 'Näytä ja hallitse SSL/TLS-varmenteita.',

    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__short-title' => 'Poista MIME tyypit',
    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__title' => 'Poista MIME tyypit',
    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__description' => 'Poista valitut MIME tyypit.',
    'ui__client/domain/hosting/web-directories/mime-type/properties_unknown-new__short-title' => 'Lisää MIME-tyyppi',
    'ui__client/domain/hosting/web-directories/mime-type/properties_unknown-new__title' => 'Lisää MIME-tyyppi',
    'ui__client/domain/hosting/web-directories/mime-type/properties_unknown-new__description' => 'Rekisteröi MIME tyyppi.',

    'ui__client/ipaddress/delete_multi__wizard-title' => 'Poista IP-osoitteet',
    'ui__client/ipaddress/delete_multi__wizard__2_multi' => 'Valitse IP-osoitteet, jotka haluat poistaa asiakkaan %1 IP-sarjasta',

    // mail

    // for future use
    'ui__client/domain/hosting/file-manager/create-file__short-title' => 'Luo tiedosto',
    'ui__client/domain/hosting/file-manager/create-file__title' => 'Luo tiedosto',
    'ui__client/domain/hosting/file-manager/create-file__description' => 'Luo tiedosto.',
    'ui__client/domain/hosting/file-manager/create-dir__short-title' => 'Luo kansio',
    'ui__client/domain/hosting/file-manager/create-dir__title' => 'Luo kansio',
    'ui__client/domain/hosting/file-manager/create-dir__description' => 'Luo kansio.',
    'ui__client/domain/hosting/file-manager/edit__short-title' => 'Muokkaa tiedostoa tai kansiota',
    'ui__client/domain/hosting/file-manager/edit__title' => 'Muokkaa tiedostoa tai kansiota',
    'ui__client/domain/hosting/file-manager/edit__description' => 'Muokkaa valittua tiedostoa tai kansiota.',
    'ui__client/domain/hosting/file-manager/rename__short-title' => 'Nimeä tiedosto tai kansio uudelleen',
    'ui__client/domain/hosting/file-manager/rename__title' => 'Nimeä tiedosto tai kansio uudelleen',
    'ui__client/domain/hosting/file-manager/rename__description' => 'Nimeää valitun tiedoston tai kansion uudelleen.',
    'ui__client/domain/hosting/file-manager/permissions__short-title' => 'Muuta käyttöoikeuksia',
    'ui__client/domain/hosting/file-manager/permissions__title' => 'Muuta käyttöoikeuksia',
    'ui__client/domain/hosting/file-manager/permissions__description' => 'Muuta tiedoston tai kansion käyttöoikeuksia.',
    'ui__client/domain/hosting/file-manager/remove__short-title' => 'Poista tiedosto tai kansio',
    'ui__client/domain/hosting/file-manager/remove__title' => 'Poista tiedosto tai kansio',
    'ui__client/domain/hosting/file-manager/remove__description' => 'Poista tämä tiedosto tai kansio.',
    'ui__client/domain/hosting/file-manager/remove_self__short-title' => 'Poista tiedosto tai kansio',
    'ui__client/domain/hosting/file-manager/remove_self__title' => 'Poista tiedosto tai kansio',
    'ui__client/domain/hosting/file-manager/remove_self__description' => 'Poista tämä tiedosto tai kansio.',
    'ui__client/domain/hosting/file-manager/copy-move__short-title' => 'Kopioi tai siirrä tiedosto tai hakemisto',
    'ui__client/domain/hosting/file-manager/copy-move__title' => 'Kopioi tai siirrä tiedosto tai hakemisto',
    'ui__client/domain/hosting/file-manager/copy-move__description' => 'Kopioi ja siirrä valitut tiedostot tai hakemistot.',
    'ui__client/domain/hosting/file-manager/view__short-title' => 'Näytä tiedosto',
    'ui__client/domain/hosting/file-manager/view__title' => 'Näytä tiedosto',
    'ui__client/domain/hosting/file-manager/view__description' => 'Näytä valittu tiedosto.',

    'ui__client/ipaddress__short-title' => 'IP-osoite',
    'ui__client/ipaddress__title' => 'IP-osoite',
    'ui__client/ipaddress__description' => 'Näytä IP-osoitteen tiedot.',
    'ui__server/ip-address__short-title' => 'IP-osoite',
    'ui__server/ip-address__title' => 'IP-osoite',
    'ui__server/ip-address__description' => 'Näytä IP-osoitteen tiedot.',
    'ui__client/domain/hosting/setup__short-title' => 'Verkkosivuston isännöintiasetukset',
    'ui__client/domain/hosting/setup__title' => 'Verkkosivuston isännöintiasetukset',
    'ui__client/domain/hosting/setup__description' => 'Aseta verkkosivuston %1 isännöintiasetukset.',
    'ui__reseller/client/chowner_multi__description' => 'Valitse valittujen asiakastilien uusi omistaja.',
    'ui__client/domain/hosting/web-directories/mime-type/properties__short-title' => 'MIME-tyyppi', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties__title' => 'MIME-tyypin ominaisuudet', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties__description' => 'Näytä MIME-tyypin ominaisuudet.', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__short-title' => 'Virheasiakirja', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__title' => 'Virheasiakirja', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__description' => 'Virheasiakirjan ominaisuudet.', // PFW

    // tooltips

    'b_resellerreportslist_remove' => 'Poista valitut raporttiasettelut.',
    'b_resellerreportslist_search' => 'Anna hakumalli ja napsauta etsiäksesi raporttiasetteluja.',
    'b_resellerreportslist_show_all' => 'Näytä kaikki käytettävissä olevat raporttiasettelut.',

    'l_resellerreportslist_auto' => 'Lajittele raporttiasettelut automaattisen toimituksen mukaan.',
    'l_resellerreportslist_clients' => 'Lajittele raporttiasettelut asiakkaita koskevien tietojen mukaan.',
    'l_resellerreportslist_domains' => 'Lajittele raporttiasettelut toimialueita koskevien tietojen mukaan.',
    'l_resellerreportslist_general' => 'Lajittele raporttiasettelut yleisten tietojen mukaan.',
    'l_resellerreportslist_name' => 'Lajittele raporttiasettelut raportin nimen mukaan.',
    'l_resellerreportslist_personal_domains' => 'Lajittele raportin asetelmat henkilökohtaisia toimialueita koskevien tietojen mukaan.',

    'b_adminreportslist_remove' => 'Poista valitut raporttiasettelut.',
    'b_adminreportslist_search' => 'Anna hakumalli ja napsauta etsiäksesi raporttiasetteluja.',
    'b_adminreportslist_show_all' => 'Näytä kaikki käytettävissä olevat raporttiasettelut.',

    'l_adminreportslist_auto' => 'Lajittele raporttiasettelut automaattisen toimituksen mukaan.',
    'l_adminreportslist_clients' => 'Lajittele raporttiasettelut asiakkaita koskevien tietojen mukaan.',
    'l_adminreportslist_domains' => 'Lajittele raporttiasettelut toimialueita koskevien tietojen mukaan.',
    'l_adminreportslist_general' => 'Lajittele raporttiasettelut yleisten tietojen mukaan.',
    'l_adminreportslist_name' => 'Lajittele raporttiasettelut raportin nimen mukaan.',
    'l_adminreportslist_personal_clients' => 'Lajittele raportin asetelmat omia asiakkaita koskevien tietojen mukaan.',
    'l_adminreportslist_personal_domains' => 'Lajittele raportin asetelmat omia toimialueita koskevien tietojen mukaan.',
    'l_adminreportslist_resellers' => 'Lajittele raportin asetelmat jälleenmyyjiä koskevien tietojen mukaan.',

    'b_clientsonlylist_remove' => 'Poista valitut asiakastilit.',
    'b_clientsonlylist_search' => 'Anna hakumalli ja napsauta etsiäksesi asiakastilejä.',
    'b_clientsonlylist_show_all' => 'Näytä kaikki asiakastilit.',
    'l_clientsonlylist_cname' => 'Lajittele asiakastilit yhtiön nimen mukaan.',
    'l_clientsonlylist_date' => 'Lajittele asiakastilit luomispäivämäärän mukaan.',
    'l_clientsonlylist_domains' => 'Lajittele asiakastilit toimialueiden määrän mukaan.',
    'l_clientsonlylist_name' => 'Lajittele asiakastilit nimen mukaan.',
    'l_clientsonlylist_owner' => 'Lajittele asiakastilit omistajan mukaan.',
    'l_clientsonlylist_type' => 'Lajittele asiakastilit tyypin mukaan.',

    'b_get_password_cancel' => 'Palaa edelliseen näyttöön sähköpostia lähettämättä.',
    'b_get_password_send' => 'Napsauta OK lähettääksesi salasanan palautusviestin järjestelmään rekisteröityyn sähköpostiosoitteeseen.',



    'b_personaltrafficlist_search' => 'Anna hakumalli ja napsauta etsiäksesi toimialueita.',
    'b_personaltrafficlist_show_all' => 'Näytä kaikki toimialueet.',

    'b_back' => 'Palaa edelliselle sivulle.',
    'b_next' => 'Siirry seuraavaan sivuun.',

    'b_dnsnstemplatelist_remove' => 'Poista valitut nimipalvelimet.',
    'b_dnsnstemplatelist_search' => 'Anna hakumalli ja napsauta etsiäksesi nimipalvelimia.',
    'b_dnsnstemplatelist_show_all' => 'Näytä kaikki nimipalvelimet.',

    'l_dnsnstemplatelist_ns' => 'Lajittele DNS-mallin tietueet nimipalvelimen mukaan.',

    // filesharing management tool
    'cu__serverfilesharing_fsLinksAsHttps' => 'Luo turvalliset linkit tiedostoihin ja kansioihin',
    'cu__serverfilesharing_fsPublicFolderEnabled' => 'Ota julkiset tiedostot käyttöön',
    'cu__serverfilesharing_fsPublicFolder' => 'Julkisten tiedostojen tallennuskansio',
    'cu__serverfilesharing_fsPublicUrl' => 'URL-osoite julkisten tiedostojen käyttöä varten',
    'cu__serverfilesharing_fsPartnerFolderEnabled' => 'Ota julkisten tiedostojen salasanasuojaus käyttöön',
    'cu__serverfilesharing_fsPartnerFolder' => 'Salasanasuojattujen tiedostojen tallennuskansio',
    'cu__serverfilesharing_fsPartnersLogin' => 'Tiedoston käytön käyttäjänimi',
    'cu__serverfilesharing_fsPartnersPassword' => 'Tiedoston käytön salasana',
    'cu__serverfilesharing_fsDomain' => 'Verkkokansion URL-pääosoite. Toimialueen nimi',
    'cu__serverfilesharing_fsPrefix' => 'Verkkokansion URL-pääosoite. Etuliite',
    'cu__serverfilesharing_commandUpdate' => 'Päivitä tiedostojaon asetukset',
    'cu__serverfilesharing_commandInfo' => 'Näytä nykyiset tiedostojaon asetukset',
    'subscription_rename_is_forbidden' => 'Palvelimen laajuinen käytäntö kieltää tilauksien uudelleen nimeämisen.',
    ///
    /// END OF RANDOM COMMON KEYS
    ///

    ////
    //// CRONTAB - temporary
    ////

    // wizard:

    'ui__server/crontab/task_unknown__wizard-title' => 'Hallitse palvelimen ajoitettuja tehtäviä',
    'ui__server/crontab/task_unknown__wizard__2_unknown' => 'Valitse järjestelmän käyttäjä, jonka aikataulutettuja tehtäviä haluat hallita.',

    'ui__server/crontab/task__short-title' => '%1',
    'ui__server/crontab/task__title' => 'Ajoitettu tehtävä %1',
    'ui__server/crontab/task__description' => 'Näytä aikataulutetun tehtävän %1 ominaisuudet.',

    ///
    /// SERVER
    ///

    'ui__server/crontab_unknown__short-title' => 'Järjestelmäkäyttäjät',
    'ui__server/crontab_unknown__title' => 'Järjestelmäkäyttäjät',
    'ui__server/crontab_unknown__description' => 'Järjestelmäkäyttäjät, jotka voivat olla ajoitettujen tehtävien omistajia.',


    'ui__server/crontab__none-available' => 'Sinulla ei ole järjestelmän käyttäjätilejä.',
    'ui__server/crontab_readonly-unknown__description' => 'Näytä ajoitetut tehtävät.',
    'ui__server/crontab_readonly-unknown__short-title' => 'Ajoitetut tehtävät',
    'ui__server/crontab_readonly-unknown__title' => 'Näytä ajoitetut tehtävät',
    'ui__server/crontab_readonly-unknown__wizard-title' => 'Näytä ajoitetut tehtävät.',
    'ui__server/crontab_readonly__description' => 'Näytä %1:n ajoitetut tehtävät.',
    'ui__server/crontab_readonly__short-title' => '%1:n ajoitettu tehtävä',
    'ui__server/crontab_readonly__title' => 'Näytä %1:n ajoitetut tehtävät',
    'ui__server/crontab_unknown__wizard-title' => 'Ajoitettujen tehtävien hallinta.',

    'ui__server/crontab/properties__description' => 'Muokkaa %1:n ajoitettuja tehtäviä.',

    'ui__server/crontab/properties__short-title' => 'Asetukset',
    'ui__server/crontab/properties__title' => 'Muokkaa %1:n ajoitettuja tehtäviä',
    'ui__server/crontab/properties_readonly-unknown__description' => 'Näytä ajoitetut tehtävät.',
    'ui__server/crontab/properties_readonly-unknown__short-title' => 'Asetukset',
    'ui__server/crontab/properties_readonly-unknown__title' => 'Näytä ajoitetut tehtävät',
    'ui__server/crontab/properties_readonly-unknown__wizard-title' => 'Näytä ajoitetut tehtävät.',
    'ui__server/crontab/properties_readonly__description' => 'Näytä %1:n ajoitetut tehtävät.',
    'ui__server/crontab/properties_readonly__short-title' => 'Asetukset',
    'ui__server/crontab/properties_readonly__title' => 'Näytä %1:n ajoitetut tehtävät',
    'ui__server/crontab/properties_unknown__description' => 'Muokkaa ajoitettuja tehtäviä.',
    'ui__server/crontab/properties_unknown__short-title' => 'Ominaisuudet...',
    'ui__server/crontab/properties_unknown__title' => 'Muokkaa ajoitettuja tehtäviä',
    'ui__server/crontab/properties_unknown__wizard-title' => 'Muokkaa ajoitettuja tehtäviä.',
    'ui__server/crontab/properties_unknown__wizard__2_readonly-unknown' => 'Valitse järjestelmäkäyttäjä, jonka tehtäviä haluat tarkastella.',
    'ui__server/crontab/properties_unknown__wizard__2_unknown' => 'Valitse järjestelmäkäyttäjä, jonka tehtäviä haluat muuttaa.',
    'ui__server/crontab/properties_unknown__wizard__3' => 'Ota muutokset käyttöön valitsemalla Valmis ja poistu ohjatusta toiminnosta.',
    'ui__server/crontab/properties_unknown__wizard__3_readonly' => 'Poistu ohjatusta toiminnosta valitsemalla Valmis.',

    'ui__server/crontab/task__none-available' => 'Sinulla ei ole aikataulutettuja tehtäviä.',
    'ui__server/crontab/task__none-available__2' => 'Järjestelmäkäyttäjällä %1 ei ole aikataulutettuja tehtäviä.',
    'ui__server/crontab/task_readonly-unknown__description' => 'Ajoitetut tehtävät.',
    'ui__server/crontab/task_readonly-unknown__short-title' => 'Tehtävät',
    'ui__server/crontab/task_readonly-unknown__title' => 'Ajoitetut tehtävät',

    'ui__server/crontab/task/delete__description' => 'Poista ajoitettu tehtävä %1',

    'ui__server/crontab/task/delete__short-title' => 'Poista',
    'ui__server/crontab/task/delete__title' => 'Poista ajoitettu tehtävä %1',
    'ui__server/crontab/task/delete_multi__description' => 'Poista ajoitetut tehtävät.',

    'ui__server/crontab/task/delete_multi__short-title' => 'Poista',
    'ui__server/crontab/task/delete_multi__title' => 'Poista ajoitetut tehtävät',
    'ui__server/crontab/task/delete_multi__wizard-title' => 'Poista ajoitetut tehtävät.',
    'ui__server/crontab/task/delete_multi__wizard__2_unknown' => 'Valitse järjestelmäkäyttäjä, jonka tehtäviä haluat poistaa.',
    'ui__server/crontab/task/delete_multi__wizard__3_multi' => 'Valitse tehtävät, jotka haluat poistaa.',
    'ui__server/crontab/task/delete_multi__wizard__4_multi' => 'Vahvista tehtävän poisto valitsemalla valintaruutu ja suorita ohjattu toiminto loppuun valitsemalla Valmis.',
    'ui__server/crontab/task/delete_unknown__description' => 'Poista ajoitettu tehtävä.',
    'ui__server/crontab/task/delete_unknown__short-title' => 'Poista',
    'ui__server/crontab/task/delete_unknown__title' => 'Poista ajoitettu tehtävä',
    'ui__server/crontab/task/delete_unknown__wizard-title' => 'Poista ajoitettu tehtävä.',
    'ui__server/crontab/task/delete_unknown__wizard__2_unknown' => 'Valitse järjestelmäkäyttäjä, jonka tehtävän haluat poistaa.',
    'ui__server/crontab/task/delete_unknown__wizard__3_unknown' => 'Valitse tehtävä, jonka haluat poistaa.',
    'ui__server/crontab/task/delete_unknown__wizard__4' => 'Vahvista tehtävän poisto valitsemalla valintaruutu ja suorita ohjattu toiminto loppuun valitsemalla Valmis.',

    'ui__server/crontab/task/properties__description' => 'Muokkaa ajoitettuja tehtäviä.',

    'ui__server/crontab/task/properties__short-title' => 'Muokkaa tehtävää %1',
    'ui__server/crontab/task/properties__title' => 'Muokkaa ajoitettuja tehtäviä',
    'ui__server/crontab/task/properties_new__description' => 'Luo aikataulutettu tehtävä kohteelle %1.',

    'ui__server/crontab/task/properties_new__short-title' => 'Lisää tehtävä',
    'ui__server/crontab/task/properties_new__title' => 'Luo aikataulutettu tehtävä kohteelle %1',
    'ui__server/crontab/task/properties_new__wizard-title' => 'Luo ajoitettu tehtävä.',
    'ui__server/crontab/task/properties_new__wizard__2_unknown' => 'Valitse järjestelmäkäyttäjä, jolle haluat luoda aikataulutetun tehtävän.',
    'ui__server/crontab/task/properties_new__wizard__4_new' => 'Ota muutokset käyttöön valitsemalla Valmis ja poistu ohjatusta toiminnosta.',
    'ui__server/crontab/task/properties_readonly-unknown__description' => 'Näytä ajoitetut tehtävät.',
    'ui__server/crontab/task/properties_readonly-unknown__short-title' => 'Ominaisuudet...',
    'ui__server/crontab/task/properties_readonly-unknown__title' => 'Näytä aikataulutetut tehtävät',
    'ui__server/crontab/task/properties_readonly-unknown__wizard-title' => 'Näytä ajoitetut tehtävät.',
    'ui__server/crontab/task/properties_readonly__description' => 'Näytä ajoitetut tehtävät.',
    'ui__server/crontab/task/properties_readonly__short-title' => 'Näytä tehtävä %1',
    'ui__server/crontab/task/properties_readonly__title' => 'Näytä ajoitetut tehtävät',
    'ui__server/crontab/task/properties_unknown-new__description' => 'Lisää ajoitettuja tehtäviä.',
    'ui__server/crontab/task/properties_unknown-new__short-title' => 'Lisää tehtävä',
    'ui__server/crontab/task/properties_unknown-new__title' => 'Lisää ajoitettuja tehtäviä',
    'ui__server/crontab/task/properties_unknown__description' => 'Muokkaa ajoitettuja tehtäviä.',
    'ui__server/crontab/task/properties_unknown__short-title' => 'Ominaisuudet...',
    'ui__server/crontab/task/properties_unknown__title' => 'Muokkaa ajoitettuja tehtäviä',
    'ui__server/crontab/task/properties_unknown__wizard-title' => 'Muokkaa ajoitettuja tehtäviä.',
    'ui__server/crontab/task/properties_unknown__wizard__2_readonly-unknown' => 'Valitse järjestelmäkäyttäjä, jonka tehtäviä haluat tarkastella.',
    'ui__server/crontab/task/properties_unknown__wizard__2_unknown' => 'Valitse järjestelmäkäyttäjä, jonka tehtäviä haluat muuttaa.',
    'ui__server/crontab/task/properties_unknown__wizard__3_readonly-unknown' => 'Valitse aikataulutettu tehtävä.',
    'ui__server/crontab/task/properties_unknown__wizard__3_unknown' => 'Valitse ajoitettu tehtävä, jonka haluat muuttaa.',
    'ui__server/crontab/task/properties_unknown__wizard__4' => 'Ota muutokset käyttöön valitsemalla Valmis ja poistu ohjatusta toiminnosta.',
    'ui__server/crontab/task/properties_unknown__wizard__4_readonly' => 'Poistu ohjatusta toiminnosta valitsemalla Valmis.',

    'ui__server/crontab/task/toggle_disable__description' => 'Poista aikataulutettu tehtävä %1 käytöstä.',

    'ui__server/crontab/task/toggle_disable__short-title' => 'Poista käytöstä',
    'ui__server/crontab/task/toggle_disable__title' => 'Poista aikataulutettu tehtävä %1 käytöstä',
    'ui__server/crontab/task/toggle_enable__description' => 'Ota käyttöön aikataulutettu tehtävä %1.',

    'ui__server/crontab/task/toggle_enable__short-title' => 'Ota käyttöön',
    'ui__server/crontab/task/toggle_enable__title' => 'Ota käyttöön aikataulutettu tehtävä %1',
    'ui__server/crontab/task/toggle_unknown__description' => 'Ota käyttöön tai poista käytöstä ajoitetut tehtävät.',
    'ui__server/crontab/task/toggle_unknown__short-title' => 'Ota käyttöön / poista käytöstä',
    'ui__server/crontab/task/toggle_unknown__title' => 'Ota käyttöön tai poista käytöstä ajoitetut tehtävät',
    'ui__server/crontab/task/toggle_unknown__wizard-title' => 'Ota käyttöön tai poista käytöstä ajoitetut tehtävät',
    'ui__server/crontab/task/toggle_unknown__wizard__2_unknown' => 'Valitse järjestelmän käyttäjätili, jonka tehtävät haluat ottaa käyttöön tai poistaa käytöstä.',
    'ui__server/crontab/task/toggle_unknown__wizard__3_unknown' => 'Valitse tehtävä, jonka haluat ottaa käyttöön tai poistaa käytöstä.',


    /// not used on HP:

    'ui__client_unknown__short-title' => 'Asiakastilit', // not used on HP?
    'ui__client_unknown__title' => 'Asiakastilit', // not used on HP?
    'ui__client_unknown__description' => 'Hallitse käyttäjätilejä.', // not used on HP?
    'ui__client/domain/disable_unknown__title' => 'Peruuta toimialue', // not used on HP
    'ui__client/domain/disable_unknown__short-title' => 'Peruuta toimialue', // not used on HP,
    'ui__client/domain/disable_unknown__description' => 'Keskeytä toimialue.', // not used on HP
    'ui__client/domain/enable_unknown__title' => 'Aktivoi toimialue', // not used on HP
    'ui__client/domain/enable_unknown__short-title' => 'Aktivoi toimialue', // not used on HP
    'ui__client/domain/enable_unknown__description' => 'Aktivoi toimialue.', // not used on HP


    // to customer home page
    'ui__client/chowner_multi-select__title' => 'Määritä asiakastileille uusi omistaja',
    'ui__client/chowner_multi-select__short-title' => 'Määritä uusi omistaja',
    'ui__client/chowner_multi-select__description' => 'Määritä valituille asiakastileille uusi omistaja.',


    //Additional FTP Accounts
    'directory_browser__select_folder' => 'Valitse kansio',
    'ftp__management_domain' => "FTP-tilit toimialueella %1", // for Additional FTP Accounts
    '__ftp_users_list' => "FTP-tilit",
    'ftp__user_name' => "FTP-tilin nimi",
    'ftp__user_home' => "Kotihakemisto",
    'ftp__invalid_path' => "Määritettiin virheellinen polku",
    'ftp__physical_path_not_exist' => "Fyysistä polkua ei ole olemassa",
    'i_ftp_ses_sub_user' => 'FTP-tilin istunto.',
    '__new_passwd' => "Uusi %1 salasana",

    ////
    //// Errors with custom template of Apache configuration
    ////

    'apacheConfigurationFailedMessageSubject' => 'Verkkopalvelinta ei voitu määrittää isäntään <%%host%%>',
    'apacheConfigurationFailedMessageBody' => "Verkkopalvelimen määritystiedostoa ei voitu luoda isäntään <%%host%%> seuraavien virheiden vuoksi:\n\n%%error%%\n\nRatkaise virheet verkkopalvelimen määritysmalleissa ja luo tiedosto uudelleen.",

    'apacheConfigurationMessageAdminTitle' => 'Verkkopalvelimen määrityksen luonti epäonnistui',
    'apacheConfigurationMessageClientTitle' => 'Varoitus',

    'apacheConfigurationFailedAdminHomeMessage' => 'Uutta määritystiedostoa ei suoritettu kokoonpanomallien virheiden vuoksi. Yksityiskohtainen virhesanoma lähetettiin sähköpostiisi. Tarkasta sähköpostisi, korjaa virheet ja napsauta %1 luodaksesi määrityksen uudelleen.',
    'apacheConfigurationFailedAdminHomeMessageLink' => 'tätä', //used on linked text in apacheConfigurationFailedAdminHomeMessage
    'apacheConfigurationFailedAdminDomainMessage' =>  'Toimialueen %1 uutta määritystä ei suoritettu kokoonpanomallien virheiden vuoksi. Yksityiskohtainen virhesanoma lähetettiin sähköpostiisi. Tarkasta sähköpostisi, korjaa virheet ja napsauta %2 luodaksesi määrityksen uudelleen.',
    'apacheConfigurationFailedAdminDomainMessageLink' => 'tätä', //used on linked text in apacheConfigurationFailedAdminDomainMessage

    'apacheConfigurationFailedUserDomainMessage' => 'Toimialueen %1 verkkopalvelimen määritys voi olla epäyhdenmukainen. Ota yhteyttä palvelimen järjestelmänvalvojaan ongelman ratkaisemiseksi.',

    'apacheConfigurationFailedAdminDomainsMessage' => 'Joidenkin toimialueiden määritystä ei suoritettu kokoonpanomallien virheiden vuoksi. Yksityiskohtainen virhesanoma lähetettiin sähköpostiisi. Tarkasta sähköpostisi, korjaa virheet ja napsauta %1 luodaksesi määrityksen uudelleen.',
    'apacheConfigurationFailedAdminDomainsMessageLink' => 'tätä', //used on linked text in apacheConfigurationFailedAdminDomainsMessage

    'apacheConfigurationFailedUserDomainsMessage' => 'Joidenkin toimialueiden verkkopalvelimen määritys voi olla epäyhtenäinen. Ota yhteyttä palvelimen järjestelmänvalvojaan ongelman ratkaisemiseksi.',



    ///HOSTING PARAMETERS
    '__apache_errdocs' => "Mukautetut virheasiakirjat",
    'dom_pref__webusers_script' => "Salli Internet-käyttäjille komentosarjojen käyttö",
    '__seoRedirect' => 'Määritä haluamasi toimialue nimellä',
    '__seoRedirectToLanding' => 'domain.tld',
    '__seoRedirectToWww' => 'www.domain.tld',
    '__seoRedirectNone' => 'Ei ole',

    '__sites' => 'Toimialueet',
    'domain_plan__perm_denied_manage_phosting' => 'Sinulla ei ole tarvittavia käyttöoikeuksia isännöintiasetusten hallitsemista varten.',
    '__owned_by_client' => 'asiakkaan käyttämä',
    'ui__client/permissions_readonly__description' => "Näytä asiakkaan %1 saatavilla olevat Plesk -toiminnot.",
    'client_chown_subscription_will_be_anonymous' => 'Asiakkaiden nykyisten palvelusuunnitelmien tilaukset poistetaan.',
    'backup__restore__object_client_template' => 'Asiakasmalli',
    '__template_name' => 'Palvelusuunnitelman nimi',
    'template__not_exists' => 'Kyseistä palvelusuunnitelmaa ei ole',
    'template__exists' => 'Suunnitelma nimeltä %1 on jo olemassa.',
    'clientOwnerChanger__has_domains_subscribed_to_reseller_plans' => 'Asiakkaalla on toimialueita, joissa on %1 -palvelusuunnitelman tilaus.',
    'clientOwnerChanger__ip_not_in_pool' => 'Annettua IP-osoitetta ei ole jälleenmyyjän sarjassa.',

    //// Change owner of subscription
    'chown__select_title' => "Valitse uusi tilaaja",
    'ui__client/domain/chowner_multi__wizard__3_multi-select' => 'Valitse uusi omistaja valituille tilauksille ja napsauta Seuraava >>.',
    'domains__client_info' => "%1 tilausta, %2 aktiivista tilausta, %3 käytetty levytila, %4 käytetty liikenne",
    '__possible_owners' => 'Tilauksien mahdolliset uudet omistajat',

    'clients_list__filter_owner__filter_title' => 'Palveluntarjoaja',
    'clients_list__filter_owner_any' => 'Kaikki käyttäjät',
    'clients_list__filter_owner_my' => 'Vain omat tilaajat',
    'clients_list__filter_owner_name__filter_title' => 'Tarjoajan nimi',

    '__owner' => "Palveluntarjoaja",
    'l_clientslist_owner' => 'Lajittele käyttäjätilit tarjoajan mukaan.',
    'l_clientslist_date' => 'Lajittele käyttäjätilit luomispäivämäärän mukaan.',
    'l_clientslist_name' => 'Lajittele käyttäjätilit nimen mukaan.',
    'l_clientslist_domains' => 'Lajittele käyttäjätilit toimialueiden mukaan.',
    'l_clientslist_cname' => 'Lajittele käyttäjätilit yhtiön nimen mukaan.',

    'ui__client/domain/chowner_multi__wizard-title' => 'Varataan valitut tilaukset uudelleen',
    'chown__check_title' => 'Muuta tilaaja',

    'ui__client/domain/chowner_multi__wizard__3_multi' => "Lopeta uudelleenvaraus valitsemalla Valmis. Tämän jälkeen valitut tilaukset määritetään uudelle omistajalle, heidän tarjoajaksi muutetaan uuden omistajan tarjoajaksi, ja niiden yhteydet poistetaan vastaavista palvelusuunnitelmista ja niistä tulee 'Mukautettu'.",

    'chown__error_check' => 'Ongelmia yritettäessä määrittää joitakin tilauksia uudelle omistajalle.',
    'domain_chown_subscription_will_be_anonymous' => "Tilaukset poistetaan niiden nykyisistä palvelusuunnitelmista ja niistä tulee 'Mukautettu'.",
    'chown__error_domains_exclude' => "Ongelmia yritettäessä määrittää joitakin tilauksia uudelle omistajalle. Nämä tilaukset on korostettu.",
    'chown__ip_not_in_client_pool' => "Tähän tilaukseen yhdistettyä IP-osoitetta ei lisätty uuden omistajan IP-sarjaan.",
    'chown__already_owned_by_client' => "Tämä tilaus kuuluu jo tälle käyttäjälle.",

    /// Protected directories

    'ui__client/domain/hosting/protected-directories/path__short-title' => '/%1',
    'ui__client/domain/hosting/protected-directories/path__title' => 'Suojattu hakemisto /%1',
    'ui__client/domain/hosting/protected-directories/path__description' => 'Suojatun hakemiston /%1 hallinta',
    'ui__client/domain/hosting/protected-directories/path/properties_new__title' => 'Luo suojattu hakemisto sivustolla %1',
    'ui__client/domain/hosting/protected-directories/path/properties_new__short-title' => 'Lisää suojattu hakemisto',
    'ui__client/domain/hosting/protected-directories/path/properties_new__description' => 'Luo suojattu hakemisto.',
    'ui__client/domain/hosting/protected-directories/path/properties_new__done' => 'Suojatun hakemiston /%1 luominen onnistui.',
    'ui__client/domain/hosting/protected-directories/path/properties__title' => 'Suojatun hakemiston /%1 asetukset',
    'ui__client/domain/hosting/protected-directories/path/properties__short-title' => 'Hakemistoasetukset',
    'ui__client/domain/hosting/protected-directories/path/properties__description' => 'Muuta suojatun hakemiston sijaintia, nimeä sekä alueen otsikkoa.',
    'ui__client/domain/hosting/protected-directories/path/properties__done' => 'Suojatut hakemiston asetukset muutettiin.',
    'ui__client/domain/hosting/protected-directories/path/delete_multi__title' => 'Poistovahvistus',
    'ui__client/domain/hosting/protected-directories/path/delete_multi__short-title' => 'Poista suojaus',
    'ui__client/domain/hosting/protected-directories/path/delete_multi__description' => 'Poista suojaus valituista hakemistoista.',
    'ui__client/domain/hosting/protected-directories/path/delete__empty_selection' => 'Valitse hakemisto, josta haluat poistaa suojan.',
    'ui__client/domain/hosting/protected-directories/path/delete#legend__description' => 'Tämä toimenpide johtaa suojan poistamiseen hakemistoista. Hakemistot tulevat verkkokäyttäjien saataville.',
    'ui__client/domain/hosting/protected-directories/path/delete_multi__done' => 'Suojaus poistettiin onnistuneesti valituista hakemistoista.',
    'ui__client/domain/hosting/protected-directories/path/user/properties_new__title' => 'Lisää käyttäjä',
    'ui__client/domain/hosting/protected-directories/path/user/properties_new__short-title' => 'Lisää käyttäjä',
    'ui__client/domain/hosting/protected-directories/path/user/properties_new__description' => 'Aseta suojatun hakemiston %1 käyttäjätili',
    'ui__client/domain/hosting/protected-directories/path/user/properties_new__done' => 'Suojatun hakemiston käyttäjätili luotiin.',
    'ui__client/domain/hosting/protected-directories/path/user/properties__done' => "Käyttäjän tunnukset tallennettiin.",
    'ui__client/domain/hosting/protected-directories/path/user/delete_multi__title' => 'Suojatun hakemiston käyttäjien poisto',
    'ui__client/domain/hosting/protected-directories/path/user/delete__empty_selection' => 'Valitse käyttäjät, jotka haluat poistaa.',
    'ui__client/domain/hosting/protected-directories/path/user/delete_multi__short-title' => 'Poista',
    'ui__client/domain/hosting/protected-directories/path/user/delete_multi__description' => 'Poista hakemiston käyttäjät.',
    'ui__client/domain/hosting/protected-directories/path/user/delete#legend__description' => 'Seuraavat suojatun hakemiston käyttäjät poistetaan:',
    'ui__client/domain/hosting/protected-directories/path/user/delete_multi__done' => 'Valitut käyttäjätilit poistettiin.',

    '__redirect_hint' => 'Sinut ohjataan uudelleen uuteen osoitteeseen 15 sekunnissa... Jos sinua ei siirretä automaattisesti uuteen kohteeseen, ota käyttöön Javascript tai napsauta linkkiä %%link%%.',

    'backup__restore__object_maillist' => 'Postituslista',
    'backup__restore__object_site' => 'Sivusto',
    'backup__restore__object_user' => 'Käyttäjä',
    'backup__restore__object_role' => 'Rooli',

    'limit__name_max_site' => 'sivustot',

    'iis_pool__unable_rename_client' => "IIS-sovellussarjan uudelleen nimeäminen ei onnistu: %1.",

    'anonftp__is_not_supported_for_addon_domains' => 'Anonyymiä FTP-palvelua tuetaan vain tilauksen päätoimialueella.',
    'anonftp__is_not_supported_for_addon_domains_powerUser' => 'Anonyymiä FTP-palvelua tuetaan vain tilauksen päätoimialueella.',

    '__gb' => 'GT',
    '__tb' => 'TB',
    '__gb_month' => 'Gt/kk',
    '__tb_month' => 'Tt/kk',

    '__customers' => 'Asiakkaat',
    '__customer_name' => 'Asiakkaan nimi',
    '__customer_total' => 'Asiakas yhteensä',
    '__site' => 'Sivusto',
    '__def_site' => 'Oletustoimipaikka',
    '__subscription_name' => 'Tilauksen nimi',
    '__subscription_name_powerUser' => 'Tilauksen nimi',

    'limit__units_max_traffic_suffix' => '/kuukausi',

    'dom_pref__discard' => "Hylkää",

    'mail__pattern_already_exists' => 'Malli "%1" on jo mustalla listalla.',

    '__not_supported' => 'Ei tuettu',

    'plesk_key__sitebuilder' => 'Presence Builderilla julkaistut sivustot',
    'limit__name_max_site_builder' => 'Presence Builderilla julkaistut sivustot',
    'plesk_key__wpb-multi-language-sites-support' => 'Monikielisten sivustojen tuki Presence Builderissä',

    'ui__client/domain/traffic-hosting__title' => 'Tiedonsiirtotilastot kohteelle <b>%1</b>',
    'ui__client/domain/traffic-hosting__title_powerUser' => 'Tiedonsiirtotilastot kohteelle <b>%1</b>',
    'ui__client/domain/traffic-hosting#list__title' => "Tiedonsiirto palvelujen mukaan",

    'login_up__access_denied_no_subscriptions' => "Käyttö estetty. Tämän tilin käytettävissä ei ole tilauksia.",

    'interval__day' => '%1 päivä(ä)',
    'interval__hour' => '%1 tunti(a)',
    'interval__minute' => '%1 minuutti(a)',
    'interval__second' => '%1 sekunti(a)',

    ///License options
    'plesk_key__backward_incompatibility' => 'Yrität käyttää käyttöoikeusavainta, joka on luotu toiselle Plesk -versiolle. Ota yhteyttä Plesk-myyntiosastoon hyväksyttävän käyttöoikeusavaimen saamiseksi.',
    //Standalone or virtualization
    'virtualization_any' => "Fyysinen palvelin tai mikä tahansa virtualisointiratkaisu",
    'virtualization_pvc' => "Virtuozzo containers",
    'virtualization_vmware' => "VMWare",
    'virtualization_hyperv' => "Microsoft Hyper-V",
    'virtualization_xen' => "Xen",
    'virtualization_kvm' => "KVM",
    'virtualization_parallels_server' => "Virtuozzo-palvelin",
    'plesk_key__virtualization' => "Voimassa seuraaville ympäristöille:",
    'plesk_key__virtualization_only_key' => 'Käyttöoikeusavain on tarkoitettu käytettäväksi vain Plesk -ratkaisussa, joka toimii näennäisympäristössä %1.',
    'plesk_key__virtualizations_only_key' => 'Käyttöoikeusavain on tarkoitettu käytettäväksi vain Plesk -ratkaisussa, joka toimii seuraavissa näennäisympäristöissä: %1.',
    //Language options
    'plesk_key__invalid_locale_signature' => 'Mukautettujen kielipakettien käyttö on kiellettyä.',
    'plesk_key__allowed-locales' => 'Käytettävissä olevat kielet',
    'plesk_key__allowed-locales-any' => 'Mikä tahansa kieli',

    /// Web hosting settings on domain/subdomain

    '__cgi_bin_mode' => 'cgi-bin-hakemisto sijaitsee kohteessa',
    '_cgi_bin_mode_webspace' => 'tilauksen päähakemisto',
    '_cgi_bin_mode_www_root' => 'tämän toimialueen pääkansio',

    ///ODBC DSN data sources
    'ui__server/odbc/dsn/properties_unknown-new__short-title' => 'Lisää ODBC DSN',
    'ui__server/odbc/dsn/properties_unknown-new__description' => 'Lisää ODBC-tietolähde.',
    'ui__server/odbc/dsn/delete_multi__short-title' => 'Poista',
    'ui__server/odbc/dsn/delete_multi__title' => 'Poistovahvistus',
    'ui__server/odbc/dsn/delete_multi__description' => 'Poista valitut ODBC DSN -tietolähteet.',
    'ui__server/odbc/dsn/delete#legend__description' => 'Seuraavat ODBC DSN -yhteydet poistetaan:',
    'ui__server/odbc/dsn/delete__empty_selection' => 'Mitään ODBC DSN -yhteyttä ei ole valittu.',
    'ui__server/odbc/dsn/delete_multi__done' => 'Valitut tietolähteet poistettiin.',
    'ui__server/odbc/dsn__title' => 'ODBC DSN -yhteys %1',

    'ui__client/domain/odbc/dsn/properties_new__short-title' => 'Lisää ODBC DSN',
    'ui__client/domain/odbc/dsn/properties_new__description' => 'Lisää ODBC-tietolähde.',
    'ui__client/domain/odbc/dsn/delete_multi__short-title' => 'Poista',
    'ui__client/domain/odbc/dsn/delete_multi__title' => 'Poistovahvistus',
    'ui__client/domain/odbc/dsn/delete_multi__description' => 'Poista valitut ODBC DSN -tietolähteet.',
    'ui__client/domain/odbc/dsn/delete#legend__description' => 'Seuraavat ODBC DSN -yhteydet poistetaan:',
    'ui__client/domain/odbc/dsn/delete__empty_selection' => 'Mitään ODBC DSN -yhteyttä ei ole valittu.',
    'ui__client/domain/odbc/dsn/delete_multi__done' => 'Valitut tietolähteet poistettiin.',
    'ui__client/domain/odbc/dsn__title' => 'ODBC DSN -yhteys %1',


    /// Custom buttons
    'custom_button__sort_key' => 'Prioriteetti',
    'custom_button__place' => 'Sijainti',
    'custom_button__place_navigation' => 'Yleinen käyttö',
    'custom_button__place_admin' => 'Järjestelmänvalvojan kotisivu',
    'custom_button__place_admin-settings' => 'Järjestelmänvalvojan Työkalut & Asetukset -asetukset',
    'custom_button__place_reseller' => "Jälleenmyyjän kotisivu",
    'custom_button__place_reseller-settings' => 'Jälleenmyyjän Työkalut & Apuohjelmat -sivu',
    'custom_button__place_client' => 'Asiakkaan kotisivu',
    'custom_button__place_domain' => "Tilauksen verkkosivustot ja toimialueet",
    'custom_button__place_domain_powerUser' => "Tilauksen verkkosivustot ja toimialueet",
    'custom_button__place_domain-properties' => 'Verkkosivuston työkalut',
    'custom_button__private' => 'Näytä vain minulle',
    'custom_button__image' => 'Taustakuva',
    'custom_button__conhelp' => "Työkaluvihjeen teksti",
    'custom_button__edit' => "Linkin asettaminen lisäpalveluun",
    'custom_button__include_client_cname' => "Sisällytä asiakkaan yrityksen nimi",
    'custom_button__include_client_email' => "Sisällytä asiakkaan sähköposti",
    'custom_button__include_client_id' => "Sisällytä asiakkaan tunnus",
    'custom_button__include_client_pname' => "Sisällytä asiakkaan yhteystiedon nimi",
    'custom_button__include_domain_id' => "Sisällytä tilauksen tunnus, toimialueen tunnus ja toimialueen aliaksen tunnus",
    'custom_button__include_domain_id_powerUser' => "Sisällytä tilauksen tunnus, toimialueen tunnus ja toimialueen aliaksen tunnus",

    'custom_button__include_domain_name' => "Sisällytä ensisijainen toimialueen nimi",
    'custom_button__include_ftp_user' => "Sisällytä FTP-käyttäjänimi",
    'custom_button__include_ftp_pass' => "Sisällytä FTP-salasana",
    'custom_button__internal_open' => "Avaa URL Pleskissa",
    'custom_button__text' => "Painikkeen nimi",
    'custom_button__url' => "URL",

    'custom_button__not_image' => 'Tiedosto ei ole kuvatiedosto.',
    'custom_button__big_image' => 'Tiedosto saa olla korkeintaan 100 KB.',
    'custom_button__failed_copy_image' => 'Tiedostoa ei voi kopioida: %1',


    'backup__restore__cannot_restore_non_power_user_dump_in_power_user_mode' => 'Muun kuin Power-User-käyttäjän varmuuskopiota ei voida palauttaa Power User -näkymässä.',
    '__unknown_network_interface' => 'Tuntematon verkkoliittymä',

    'init_conf__ip_address' => 'IP-osoite',

    //Confirmation page
    'bt_confirm' => 'Vahvista',
    'b_confirm' => 'Vahvista sivustojesi omistajuus.',

    //// New VZPP Integration
    '__vzpp_integration_warning' => 'Tämä Plesk -esiintymä on asennettu kohteeseen Virtuozzo container. Nykyisten verkon ulkopuolisten Container-hallinta-asetuksien mukaan Plesk ei ole käytettävissä.',
    '__vzpp_integration_contact_admin' => 'Jos sinulla on riittävät edut Container-määrityksien muuttamiseen, %1. Ota muussa tapauksessa yhteyttä tarjoajaan.',
    '__vzpp_integration_help_link' => 'muuta verkon ulkopuolisia hallinta-asetuksia',



    'performance__iss_app_pool_forced_by_site_isolation' => 'Varatun IIS-sovellussarjan asetukset asetetaan palvelimen laajuisten turvallisuuskäytännön mukaan (sivuston eristyksen määritys).',
    'performance__iss_app_pool_forced_by_server_wide_settings' => 'Varatun IIS-sovellussarjan asetukset asetetaan palvelimen laajuisten suorituskykyasetuksien mukaan.',

    '__current' => 'Nykyinen',
    'ui__client/domain/hosting/web-directories/protection/user/properties__done' => 'Käyttäjän ominaisuudet päivitettiin.',



    //// New Promos Block

    'promo__you_are_about_to_exceed_license_limit_max_dom' => 'Olet käyttänyt lähes kaikki Plesk -käyttöoikeusavaimen tarjoamat toimialueet (90 % tai enemmän).',
    'promo__you_are_about_to_exceed_license_limit_max_dom_title' => 'Olet käyttänyt lähes kaikki toimialueet.',
    'promo__you_are_about_to_exceed_license_limit_max_site_builder' => 'Olet käyttänyt lähes kaikki Plesk -käyttöoikeusavaimen tarjoamat Presence Builder -sivustot (90 % tai enemmän).',
    'promo__you_are_about_to_exceed_license_limit_max_site_builder_title' => 'Olet käyttänyt lähes kaikki Presence Builder -sivustot.',
    'promo__button_hide' => 'Piilota',
    'promo__button_next' => 'Seuraava >>',
    'promo__button_prev' => '<< Edellinen',
    'promo__button_license' => 'Päivitä käyttöoikeus',

    'promo__google_integration_title' => 'Integrointi Google-palveluihin',
    'promo__google_integration' => 'Määritä integrointi Google-palveluihin, joita ovat mm. AdSense, Google Apps, Webmaster-työkalut.',
    'promo__google_integration_button' => 'Määritä',

    'promo__button_learn_more' => 'Lisätietoja',

    //// Plesk Branding in 10.1
    'panel_branding__description' => 'Voit mukauttaa liittymän ulkomuodon ja tuotemukautuksen asetukset mukautetuilla teemoilla. Katso lisäohjeita Plesk -teemoista osiosta %1.',
    'panel_branding__description_link' => 'seuraava asiakirja',

    ///// File Manager new buttons
    'bt_extract_archive' => 'Pura tiedostot',
    'b_filemanager__extract' => 'Pura tiedostot valituista arkistoista nykyiseen hakemistoon. Huomaa, että tiedoston nimet voivat näkyä virheellisesti purkamisen jälkeen, jos ne sisältävät maakohtaisia merkkejä.',
    'filemanager_error_extracting_files' => 'Virhe tapahtui arkiston tiedostoja purkaessa: %1',
    'filemanager_no_archive_files_specified' => 'Määritä purettavat arkistot.',
    'filemanager_not_zip_archive_specified' => 'Kohdetta %1 ei voida purkaa, se ei ole ZIP-arkisto.',
    'filemanager_files_successfully_extracted' => 'Arkiston tiedostot purettiin.',
    'filemanager_error_file_download' => 'Tiedoston lataaminen epäonnistui: %1',
    'filemanager__user_poolgrp' => 'Sovellussarjan ryhmä',

    'loading' => 'Ladataan...',
    'bt_create_archive' => 'Lisää arkistoon',
    'filemanager__pack' => "Polku arkistoon: %1",
    'filemanager__archive_name' => 'Arkiston tiedostonimi',
    'filemanager__empty_filename' => 'Syötä arkiston tiedostonimi.',
    'filemanager_archive_created' => 'Arkiston luonti onnistui.',
    'filemanager_error_creating_archive' => 'Arkistoa ei voi luoda: %1',

    'cmd_dns__aaaa_dns_record_already_exist' => "Tämä tietue voi olla ristiriidassa vyöhykkeen AAAA -tietueeseen.",
    'defaultcomponents__ftp_ipv6_hosting_not_supported' => "(FTP-palvelin ei tue IPv6-osoitteita.)",
    'cmd_dns__glue_dns_record_conflict' => 'Tämä tietue voi olla ristiriidassa vyöhykkeen \'%1\' tietueeseen.',
    '__ftp_ipv6_not_supported' => "(FTP-palvelin ei tue IPv6-osoitteita.)",
    '__ipv6_not_supported' => 'IPv6:ta ei tueta.',
    'mail__ipv6_not_supported' => 'Sähköpostipalvelin ei tue IPv6:ta.',
    'mail__relay_while_list_ipv6_not_supported' => 'Sähköpostipalvelin ei tue IPv6-välityksen sallittujen listaa.',
    'mail__relay_while_list_ipv6_mask_mul_16' => 'Peitteen arvon on oltava 16:lla jaollinen.',
    'mail__ip_or_mask_is_invalid' => 'IP-osoite tai peite on virheellinen.',
    'nonexistent_mail__redirect_ipv6_not_supported' => 'Edelleenlähetystä IPv6 IP -osoitteisiin ei tueta.',
    'sa__invalid_trusted_networks' => 'Virheellisesti määritetyt luotettavat verkot: %1',
    'dns_add__enter_ipv6_address' => "IPv6-osoite",
    'license_trial_days_left' => 'Plesk toimii kokeiluversion käyttöoikeudella, joka menee umpeen %1 päivän kuluttua.',
    'excl_ipv6_num' => 'Varattu IPv6-osoite',
    '__ip_mask' => "Aliverkon peite",
    '__ipv4_addr' => 'IPv4-osoite',
    '__ipv6_addr' => 'IPv6-osoite',
    'template__num_excl_ipv6s' => 'Määritä varatut IPv6-osoitteet jälleenmyyjälle',
    'anonftp__exclusive_ipv4_required' => 'Varattu IPv4-osoite vaaditaan anonyymin FTP-palvelun asettamiseen ja käyttämiseen.',
    'anonftp__ipv4_already_used' => 'Anonyymiä FTP-palvelua ei voida asettaa tälle sivustolle, koska se on jo määritetty toiseen toimialueeseen samassa IPv4-osoitteessa.',


    'restart__kav' => "Kaspersky Anti-Virus",
    '__view_migration_log_detailed_info' => 'Näytä loki',

    'chown__ip_address_warn' => 'Ennen kuin tilaus siirretään uudelle omistajalle, sinun tulee valita uusi IP-osoite kyseiseen tilaukseen.',
    'chown__no_ip_address' => 'Ei ole',
    'chown__no_ipv4_address' => 'Ei IPv4-osoitetta',
    'chown__no_ipv6_address' => 'Ei IPv6-osoitetta',
    'chown__domain_exclude_already_owned_by_client' => 'Tilaus %1 kuuluu jo kyseiselle käyttäjälle.',
    'chown__error_ip_absent_in_ip_pool' => 'IP-osoitetta %1 ei ole kohdekäyttäjän IP-sarjassa.',
    'chown__error_ip_not_exist' => 'IP-osoitetta, jonka tunnus on \'%1\', ei ole.',
    'chown__error_domain_ip_not_selected' => 'Vähintään yksi toimialueen %1 IP-osoite tulee valita . Tarkista IP-määrityksen valitut arvot.',

    '__new_passwd_single' => "Salasana",
    '__confirm_passwd_single' => "Vahvista salasana",

    'mail__ip_or_mask_is_invalid_ipv6' => 'IPv6-osoite tai peite on virheellinen: IP-osoitteen on oltava hyväksyttävä unicast-osoite.',

    '__subscriptions' => 'Tilaukset',

    '__owned_by_reseller' => 'jälleenmyyjän käyttämä',
    '__owned_by_provider' => 'tarjoajan käyttämä',

    'service_plan__anonymous' => 'Mukautettu',
    'subscription_not_locked__change_limits_warning' => 'Tätä tilausta ei ole lukittu: resurssin käyttörajaa muutetaan palvelusuunnitelmaan tapahtuvan synkronoinnin aikana.',
    'subscription_not_locked__change_permissions_warning' => 'Tätä tilausta ei ole lukittu: käyttöoikeuksia muutetaan palvelusuunnitelmaan tapahtuvan synkronoinnin aikana.',

    'subscription__conflict_resolution_policy' => 'Ristiriitojen ratkaisukäytäntö',
    'subscription__conflict_resolution_policy_lock' => "Lukitse tilaus",

    'backup__list__backup_warnings' => 'Varoitukset',
    'backup__list__backup_info' => 'Tiedot',
    'backup__restore__object_reseller_template' => 'Jälleenmyyjän malli',
    'backup__restore__object_domain_template' => 'Toimialueen malli',

    'ui__client/permissions_readonly__title' => 'Käyttöoikeudet',
    'ui__client/permissions_readonly__short-title' => 'Käyttöoikeudet',

    'subscription__unable_lock_anonymous' => 'Tätä tilausta ei ole sidottu palvelusuunnitelmaan, joten sen lukitusta ei voida avata.',
    'subscription__unable_sync_anonymous' => 'Tätä tilausta ei ole sidottu palvelusuunnitelmaan, joten sitä ei voida synkronoida.',
    'subscription__unable_sync_locked' => 'Tätä tilausta ei ole lukittu, joten sitä ei voida synkronoida.',
    'subscription__locked' => 'Tilaus on lukittu.',
    'component_name__urlrewrite' => "URL-osoitteen uudelleenkirjoitus",
    '__quantity' => 'Määrä',
    'hst__www_root_dir_absent' =>  'Varoitus: asiakirjan päähakemistoksi määritettyä hakemistoa ei ole.',
    'object_creation__domain_is_not_a_webspace' => 'Tämä kohde voidaan luoda vain tilauksessa.',
    'phosting__webspace_hosting_with_sites_cannot_be_deleted' => 'Tilaus sisältää sivustoja, siksi et voi muuttaa isännöintityyppiä tai poistaa sitä.',
    'phosting__addon_domain_ip_must_match_webspace' => 'Virhe: IP-osoitteen päivitys epäonnistui. Laajennuksen toimialueisiin ei voida määrittää IP-osoitetta, jota ei ole määritetty tilauksen päätoimialueeseen.',
    'domain_plan__unable_change' => 'Palvelusuunnitelmaa ei voida muuttaa: %1.',
    'domain_plan__different_hosting_type' => 'Nykyinen isännöintityyppi on erilainen kuin palvelusuunnitelmassa määritetty tyyppi.',
    'domain_plan__addon_text' => 'Laajennussuunnitelma',
    'domain_plan__addon_description' => 'Lisä-osasuunnitelmaa käytetään isännöintisuunnitelman täydentämiseen.',
    'asp_net__managed_runtime_version' => 'Versiossa ASP.NET-hallittu suoritusaika',
    'plan__can_not_change_hosting_type' => 'Isännöintityyppiä ei voi vaihtaa, kun suunnitelmaa muokataan.',
    'plan__apply_problems' => 'Suunnitelmaa ei otettu käyttöön seuraavan toiminnon ongelmien vuoksi: %1',
    'plan_save__subscription_update_problem' => 'Suunnitelman muutoksia ei voida käyttää kohteeseen %1.',
    '__perm_denied_subscription_suspended_by_backuprestore' => "Tilaus on keskeytetty väliaikaisesti, kunnes varmuuskopiointi- tai palautusprosessi on suoritettu. Palaan takaisin myöhemmin.",
    '__login_incorrect_plain_shadow_password' => 'Märitit virheellisen salasanan järjestelmänvalvojan tiliin. Käytä järjestelmänvalvojan (pääkäyttäjä) tunnuksia tai hanki oikea salasana. Lue lisätietoa salasanan saamisesta tiedostosta /etc/psa/README.psa.shadow.',

    '__perm_denied_ip' => 'Et voi lähettää IP-osoitetta, jota et omista',

    'dns__dns_zone_not_synchronized' => 'DNS-vyöhykettä muutettiin. Jos haluat käyttää DNS-mallin muutoksia tähän vyöhykkeeseen, napsauta joko \'Ota DNS-mallin muutokset käyttöön\' -painiketta tällä sivulla tai valitse \'Käytä muutokset kaikkiin vyöhykkeisiin\' -valinta Palvelimen hallintapaneeli > Työkalut & Asetukset > DNS-mallin asetukset > Käytä DNS-mallin muutokset.',
    'dns__dns_zone_synchronize_link' => 'Napsauta',
    'dns__dns_zone_synchronize_done' => 'DNS-vyöhyke synkronoitiin onnistuneesti.',

    'dns__dns_zone_template_error' => 'Virheitä esiintyi synkronoidessa DNS-vyöhykkeitä DNS-vyöhykemalliin.%1',

    'dns__soa_rname_type_owner' => 'Verkkosivuston omistajan sähköpostiosoite',
    'dns__soa_rname_type_domain' => 'Toimialueen sähköpostiosoite',
    'dns__soa_rname_type_external' => 'Ulkoinen sähköpostiosoite',
    'dns__soa_rname_enforce_email' => 'Estä RNAME-sähköpostiosoitteen muuttaminen toimialuekohtaisesti',
    'dns__soa_rname_label' => 'Sähköposti (RNAME)',
    'dns__soa_rname_hint' => 'Toimialueen DNS-vyöhykkeestä vastaavan henkilön sähköpostiosoite. DNS-palvelimen palauttama vastauksena SOA-kyselyihin.',

    'dns__dns_zone_soa_sync_title' => 'Ohita SOA-asetukset kaikissa olemassa olevissa toimialueissa',
    'dns__dns_zone_soa_sync_legend' => 'Vahvistus vaaditaan',
    'dns__dns_zone_soa_sync_text' => 'Haluatko päivittää kaikkien isännöityjen toimialueiden SOA-tietueet SOA-malliin tehdyillä muutoksilla?',

    'cu_db__repair_mysql_dbus' => "Korjaa MySQL-käyttäjän salasanat. Tämä toimenpide vaaditaan, jos päivitit versioon Plesk 11 aikaisimmista versioista.",

    'scheduled_backup_settings__start_at_hint' => 'Aikataulutettujen varmuuskopiointitehtävien tarkistusväli on 15 minuuttia. Jos haluat Pleskin aloittavan varmuuskopiointiprosessin tiettynä ajankohtana, aikatauluta tehtävä vähintään 15 minuuttia haluttua aikaa aikaisemmin.',
    'cu_scheduled_backup_comment' => 'Ajoitettu varmuuskopiointi',
    'cu_scheduled_backup_error' => 'Varmuuskopioinnin aikana tapahtui virhe: %1',
    'cu_scheduled_backup_mail_subject' => '<%1> Aikataulutetun varmuuskopioinnin aikana tapahtui virhe.',
    'cu_scheduled_backup_mail_message' => "%1\nPleskin aloituskohta: %2\n\nSeuraavat virheet tapahtuivat aikataulutetun varmuuskopioinnin aikana:\n\n%3",
    'cu_scheduled_backup_comment_backup_all' => 'Ajoitettu varmuuskopiointi. Kaikki määritykset ja sisältö.',
    'cu_scheduled_backup_comment_backup_vhost' => 'Ajoitettu varmuuskopiointi. Kaikki määritykset ja sisältö sähköpostia lukuun ottamatta.',
    'cu_scheduled_backup_comment_backup_mail' => 'Ajoitettu varmuuskopiointi. Vain sähköpostin määritykset ja sisältö.',
    'cu_scheduled_backup_comment_backup_domain' => 'Ajoitettu varmuuskopiointi. Toimialueen määritys.',
    'cu_scheduled_backup_to_cloud_not_allowed' => 'Ajoitettujen varmuuskopiointien tallennus pilven etäsäilytystilaan on premium-toiminto. Voit ottaa sen käyttöön ottamalla yhteyttä isännöintipalvelusi tarjoajaan.',

    'i_backup_invalid_file' => 'Varmuuskopio ei kelpaa. Tietojen palauttaminen tästä tiedostosta ei onnistu. Saat lisätietoja napsauttamalla varmuuskopion nimeä.',

    'ui__server/migration/download-agent__short-title' => 'Lataa Migration & Transfer Agent',
    'ui__server/migration/download-agent__title' => 'Lataa Migration & Transfer Agent',
    'ui__server/migration/download-agent__description' => 'Lataa Migration & Transfer Agent -järjestelmän uusin versio Plesk-verkkosivustolta.',

    'filemanager_resulting_archive_exists' => 'Kohdehakemisto sisältää jo tiedoston %1.',

    'agent_unable_to_connect' => 'Yhteyden muodostaminen agenttiin kohteessa \'%2\' ei onnistu. Varmista, että agentti on asennettu ja käynnissä, ja ettei yhteysongelmia ole isäntään \'%2\'.',
    'agent_test_connection_failed' => 'Yhteys agenttiin kohteessa \'%2\' epäonnistui.',

    'agent_unable_to_resolve_host' => 'Etäisäntää \'%1\' ei voitu paikantaa. Varmista, että yhteysongelmia isäntään ei ole.',
    'agent_unknown_curl_error' => 'Virhe \'%1\' tapahtui yhteyden aikana agenttiin kohteessa \'%2\'.',
    'agent_unexpected_htp_code' => 'Odottamaton HTTP-koodi \'%1\' saatiin HTTP-pyyntöön agentille kohteessa \'%2\'.',
    'agent_unable_to_auth' => 'Todennusta ei voitu suorittaa isännässä \'%1\'. Voit ratkaista ongelman noudattamalla osoitteessa http://kb.plesk.com/116606 olevia ohjeita.',
    'agent_internal_server_error' => 'Sisäinen palvelimen virhe tapahtui komennon suorituksen aikana etäisännässä \'%1\'.',
    'agent_response_is_empty' => 'Tyhjä vastaus saatiin HTTP-pyyntöön agentille kohteessa \'%1\'.',

    'migration__disabled_due_to_local_file_does_not_exist' => 'Migration & Transfer Agent -järjestelmää ei löydetä paikallisesta välimuistista. Avaa uudelleen Migration &Transfer Manager ongelman korjaamiseksi.',

    '__hosting_webdeploy' => "Julkaisu Web Deploylla",
    'cu_domain__webdeploy' => "Julkaisu Web Deploylla (oletus: %1)",
    'cu_dom_tpl__webdeploy' => "Julkaisu Web Deploylla (oletus: %1)",
    'cu_subdomain__webdeploy' => "Julkaisu Web Deploylla (oletus: %1)",
    'webdeploy__not_installed' => "Microsoft Web Deploy -sovellusta ei ole asennettu palvelimeen",
    'webdeploy__forced_by_site_isolation' => "Web Deploy -julkaisuasetuksia ei voida muuttaa: sinulla ei ole oikeutta kirjoittaa palvelimen laajuisen turvallisuuskäytännön yli. Pyydä lisätietoa palveluntarjoajaltasi.",



    'backup__restore_options__admin__server_configuration_license' => 'Käyttöoikeusavain',
    'migration_start_migrate_server_license' => 'Siirron käyttöoikeusavain',

    'defaultcomponents__delegation_rule_not_exist' => '(vaadittua delegointisääntöä \'appPoolPipeline, appPoolNetFx\' ei ole olemassa)',

    '__o' => 'O',

    'i_backup_created_by_admin' => 'Järjestelmänvalvoja loi varmuuskopion.',
    'i_backup_created_by_reseller' => 'Jälleenmyyjä loi varmuuskopion.',
    'i_backup_created_by_client' => 'Asiakas loi varmuuskopion.',

    'migration__object_exists_on_target_host' => '(jo olemassa kohdeisännällä)',

    '__customers_total' => 'Yhteensä asiakkaiden mukaan',
    '__resellers_total' => 'Yhteensä jälleenmyyjien mukaan',
    '__reseller_total' => 'Jälleenmyyjä yhteensä',


    'cu__mailserver_update_webmail_command' => "Määrittää verkkosähköpostiasiakkaan, jonka haluat ottaa käyttöön tai poistaa käytöstä",
    'cu__mailserver_webmail_state' => "Määrittää valitun verkkosähköpostiasiakkaan tilan (hyväksyttävä ottaa asiakkaan käyttöön, virheellinen poistaa sen käytöstä)",

    'cu_db_set_default_user' => 'Aseta määritetty käyttäjä tietokannan oletukseksi. Valintaa käytetään komennoilla: add_user, update_user',

    'cu_role__opt_subscription_name' => 'Salli käyttäjien käyttää vain määritettyä tilausta',
    'cu_role__opt_for_all_subscription' => 'Salli käyttäjille isännöintitilin kaikkien tilausten käyttö',
    'cu_role__subscription_not_found_role_is_not_limited' => 'Rooliin ei voida tehdä muutoksia: tilausta %1 ei löytynyt.',

    'cu_cl_pref__manage_website_maintenance' => 'Pääsy lisätoimintoihin: verkkosivuston kopiointi',
    'cu_cl_pref__manage_protected_dirs' => 'Salasanasuojattu hakemistojen hallinta',
    'cu_cl_pref__manage_mail_settings' => 'Sähköpostiasetusten muuttamismahdollisuus',


    'cu__command_update_php_settings' => 'Päivittää PHP-asetukset.',
    'cu__php_settings_option' => 'Asettaa polun tiedostoon PHP-asetuksilla.',

    'cu__additional_php_settings_option' => 'Asettaa polun tiedostoon PHP-lisädirektiiveillä.',
    'cu__command_show_php_settings' => 'Näyttää nykyiset PHP-asetukset.',
    'cu__general_settings' => 'Yleiset asetukset:',
    'cu__performance_settings' => 'Suorituskyvyn määritykset:',
    'cu__php_fpm_settings' => 'PHP-FPM-asetukset:',
    'cu__additional_directives' => 'Lisädirektiivit:',

    'b_filemanager__pack' => 'Lisää valitut tiedostot arkistoon.',

    'php_settings_permission_required' => 'Yleisten PHP-asetusten hallinta',
    'php_settings_performance_permission_required' => 'Isännöinnin suorituskykyasetusten hallinta',
    'php_settings_customized' => 'PHP-asetukset mukautettiin.',
    'php_settings_synchronized_with_plan' => 'PHP-asetukset on synkronoitava suunnitelmaan.',
    'phosting__unknown_shell_type' => 'Liittymä ei käytössä',

    'login_up__access_denied_subscription_deleted' => 'Käyttöoikeus torjuttu: tilauksesi poistettiin.',

    'role_restricted_to_subscription' => '(siirretty tilauksella: %1)',

    'filemanager__extract' => "Pura tiedostot kohteeseen: %1",

    'cu__license_command_check_installed_license' => 'Tarkista asennetun käyttöoikeusavaimen voimassaolo (palauttaa lopetuskoodin 0, jos avain on voimassa ja 1, jos se ei ole voimassa)',

    'promo__mobile_manager_title' => 'Plesk Mobile Server Manager',
    'promo__mobile_manager' => "Laajenna Plesk -toimintoja, joiden avulla voit hallita ja valvoa palvelinta mobiililaitteista (BlackBerry, iPhone ja Android).",
    'promo__mobile_monitor_title' => 'Plesk Mobile Server Monitor',
    'promo__mobile_monitor' => 'Saa tärkeää tietoa Plesk -palvelimista milloin ja missä tahansa mobiililaitteella (BlackBerry, iPhone ja Android).',
    'promo__mobile_button' => 'Lisätietoja',

    'ui__server/migration/video__short-title' => 'Video-oppaat',
    'ui__server/migration/video__title' => 'Katso video-oppaita',
    'ui__server/migration/video__description' => 'Katsele ohjevideot.',

    'subDomainNameHint' => 'Syötä * alitoimialueen nimeksi yleismerkin alitoimialueen luomiseksi. Verkkosivuston vierailijat ohjataan tälle alitoimialueelle riippumatta siitä, minkä alitoimialueen nimen he syöttävät selaimeen.',
    'subdomains__wildcard_name_invalid' => "Alitoimialueen nimi on virheellinen. Yleismerkkien alitoimialueiden nimissä saa käyttää vain aakkosnumeerisia merkkejä, viivaa (-) ja tähtimerkkiä (*).",
    'subdomains__name_invalid' => "Alitoimialueen nimi on virheellinen. Alitoimialueiden nimissä saa käyttää vain aakkosnumeerisia merkkejä ja viivaa (-).",

    'domain__wildcard_no_www_prefix' => 'Etuliitettä www ei voida käyttää yleismerkkien alitoimialueisiin.',

    '__service_title__milter' => "Plesk Postfix -postisuodatin",
    '__service_description__milter' => "Plesk Postfix -sähköpostisuodatin",
    '__milter' => "Postfix-postisuodatin",
    'restart__milter' => "Plesk-postisuodatin (%1)",
    'restart__pop3' => "Kuriirin POP3-palvelin",
    'restart__pop3s' => "Kuriirin POP3-palvelin SSL/TLS-tuella",
    'restart__imap' => "Kuriirin IMAP-palvelin",
    'restart__imaps' => "Kuriirin IMAP-palvelin SSL/TLS-tuella",
    'restart__authdaemon' => "Kuriirin IMAP-todennusohjelma",
    'restart__imap-pop3' => "Dovecot IMAP ja POP3 -palvelin",


    'addon_packages_not_supported' => 'APS-pakettien verkkosovelluksien liitännäisiä ei tueta.',
    'cu_domain__unable_to_automaticaly_select_ip' => 'IP-osoitetta ei voida määrittää automaattisesti toimialueelle. Määritä IP-osoite valintaa -ip käyttämällä.',

    'plesk_key__mb_accounts' => 'Käyttäjätilit (jälleenmyyjät ja asiakkaat) Customer and Business Manager -järjestelmässä',

    'actionlog__subdomain_dns' => 'Alitoimialueen DNS-vyöhyke',
    'actionlog__site_subdomain_dns' => 'Alitoimialueen DNS-vyöhyke ylimääräisellä toimialueella',

    // PfW only
    'actionlog__event_site_create' => 'Toimialue luotu',
    'actionlog__event_site_delete' => 'Toimialue poistettu',
    'actionlog__event_site_update' => 'Toimialue päivitetty',

    'actionlog__event_site_status_update' => 'Toimialueen tila päivitetty',
    'actionlog__event_site_dns_update' => 'Toimialueen DNS-vyöhyke päivitettiin',
    'actionlog__event_site_guid_update' => 'Toimialueen GUID päivitetty',

    'actionlog__event_site_subdomain_create' => 'Alitoimialue luotu',
    'actionlog__event_site_subdomain_delete' => 'Alitoimialue poistettu',
    'actionlog__event_site_subdomain_update' => 'Alitoimialue päivitetty',

    'actionlog__event_site_alias_create' => 'Toimialueen alias luotu',
    'actionlog__event_site_alias_delete' => 'Toimialueen alias poistettu',
    'actionlog__event_site_alias_update' => 'Toimialueen alias päivitetty',

    'actionlog__event_site_alias_dns_update' => 'Toimialueen aliaksen DNS-vyöhyke päivitetty',
    'actionlog__event_subdomain_dns_update' => 'Alitoimialueen DNS-vyöhyke oletustoimialueella päivitettiin',
    'actionlog__event_site_subdomain_dns_update' => 'Alitoimialueen DNS-vyöhyke päivitetty',
    // End of PfW only

    'win_policy__bad_password' => 'Vahvistus epäonnistui. Salasana ei kelpaa.',
    'win_policy__password_too_short' => 'Vahvistus epäonnistui. Salasana ei vastaa salasanakäytännön vaatimuksia, koska se on liian lyhyt.',
    'win_policy__password_too_long' => 'Vahvistus epäonnistui. Salasanaa ei täytä salasanakäytännön vaatimuksia, koska se on liian pitkä.',
    'win_policy__password_not_complex_enough' => 'Validointi epäonnistui. Salasana ei ole tarpeeksi vahva eikä täytä salasanavaatimuksia. Vahvoissa salasanoissa on oltava vähintään kaikki seuraavat: kahdeksan merkkiä; yksi iso tai pieni kirjain; kolme numeroa ja yksi erikoismerkki (!, @, #, $, %, ^, &, *, ?, _, ~) tai yksi numero ja kaksi erikoismerkkiä.',

    //// Activation Code feature
    'plesk_key__license_update_failed' => 'Tuotteen käyttöoikeutta ei voida päivittää.',


    'filemanager__error_path_is_not_allowed' => 'Polku ei ole sallittu',
    'filemanager__error_path_is_invalid' => 'Polku on virheellinen',
    'filemanager__error_path_not_found' => 'Polkua ei löydy',
    'filemanager__error_path_already_exists' => 'Polku on jo olemassa',
    'filemanager__error_access_is_denied' => 'Käyttö estetty',
    'filemanager__error_directory_not_empty' => 'Kansio ei ole tyhjä',
    'filemanager__error_sharing_violation' => 'Yhteiskäyttövirhe',
    'filemanager__error_not_same_device' => 'Kohdepolku ei ole samassa laitteessa',
    'filemanager__binary_data_access' => 'Tämä tiedosto voi olla binaaritiedosto. Haluatko avata sen?',
    'filemanager__unable_to_resolve_realpath' => "Tiedostoa %1 ei löydy määritetystä kohteesta",
    'filemanager__access_to_realpath_denied' => "Pääsy todelliseen polkuun kielletty: %1 - %2.",
    'bt_exit' => 'Lopeta',

    'filemanager__chdir_error__' => "Hakemistoa ei voi muuttaa kohteeksi %1: %2",
    'filemanager__chmod_dir' => "Muuta hakemiston %1 käyttöoikeuksia",
    'filemanager__chmod_error__' => "Tiedoston %1 käyttöoikeuksia ei voida muuttaa: %2",
    'filemanager__chmod_file' => "Muuta tiedoston %1 käyttöoikeuksia",
    'filemanager__copy_error__' => "Kohdetta %1 ei voi kopioida kohteeseen %2: %3",
    'filemanager__copy_move' => "Kopioi (siirrä) tiedostot kohteesta %1",
    'filemanager__count_size__' => 'Valinnan koko: %1',
    'filemanager__count_size_error__' => 'Kokoa ei voida laskea kohteelle %1: %2',
    'filemanager__create_dir' => "Hakemiston luonti",
    'filemanager__create_dir_error__' => "Hakemistoa %1: %2 ei voi luoda",
    'filemanager__dir_not_exists' => "Kansiota %1 ei ole.",
    'filemanager__dirname' => "Hakemiston nimi",
    'filemanager__filename' => "Tiedoston nimi",
    'filemanager__is_no_such' => "Nimellä %1 tallennettua tiedostoa tai hakemistoa ei ole",
    'filemanager__empty_selection' => "Tiedosto(j)a ei ole valittu.",
    'filemanager__file_exists' => "Tiedosto %1 on jo olemassa.",
    'filemanager__move_error__' => "Kohdetta %1 ei voi siirtää kohteeseen %2: %3",
    'filemanager__new_dir' => "Hakemiston nimi",
    'filemanager__not_allowed' => "Tämän tiedoston käyttöoikeuksien muuttaminen ei ole sallittua.",
    'filemanager__r_perm_dir' => "Näytä hakemisto",
    'filemanager__r_perm_file' => "Lue tieto",
    'filemanager__remove' => "Poista tiedostot kohteesta %1",
    'filemanager__remove_error__' => "Tiedostoa %1: %2 ei voitu poistaa",
    'filemanager__rename_dir' => "Uudelleennimeä hakemisto %1",
    'filemanager__rename_error__' => "Kohdetta %1 ei voi nimetä uudelleen kohteeksi %2: %3",
    'filemanager__rename_file' => "Uudelleennimeä tiedosto %1",
    'filemanager__set_win_permissions_dir' => "Aseta käyttöluvat kansioon %1",
    'filemanager__set_win_permissions_file' => "Aseta käyttöluvat tiedostoon %1",
    'filemanager__touch_confirm' => "Haluatko varmasti muuttaa valittujen tiedostojen aikaleiman?",
    'filemanager__no_perms_or_unsupported_file_type' => 'Tiedostoa ei voida lukea tai tiedostoformaattia ei tueta.',
    'filemanager__upload_error__' => "Kohdetta %1 ei voida ladata kohteeseen %2: %3",
    'filemanager__upload_file' => "Lataa tiedosto",
    'filemanager__upload_file_src' => "Tiedoston polku",
    'filemanager__username' => "Käyttäjä",
    'filemanager__w_perm_dir' => "Luo tiedostot",
    'filemanager__w_perm_file' => "Kirjoita tieto",
    'filemanager__x_perm_dir' => "Kansiopuut",
    'filemanager__x_perm_file' => "Suorita tiedosto",
    'filemanager__max_image_size_exceeded' => 'Kuvaa ei voi näyttää. Kuvan koko saa olla korkeintaan %2 tavua.',

    '__fastcgi_unix_support' => 'FastCGI-tukipalvelu',

    'ts_sessions_list' => 'Tämä sivu näyttää luettelon kaikista päätepalveluistunnoista.',
    'b_tssessionslist_search' => 'Etsi istuntoja nimen mukaan.',
    'b_tssessionslist_show_all' => 'Näytä kaikki päätepalveluistunnot.',
    'l_tssessionslist_state' => 'Lajittele tilan mukaan.',
    'l_tssessionslist_name' => 'Lajittele nimen mukaan.',
    'l_tssessionslist_user' => 'Lajittele käyttäjän mukaan.',
    'b_tssessionslist_logoff' => 'Kirjaudu ulos valituista istunnoista napsauttamalla.',
    'b_tssessionslist_disconnect' => 'Napsauta katkaistaksesi yhteyden valittuihin istuntoihin.',
    'tssessions_info' => 'Istunnon ominaisuuksien tarkistus.',
    'tssessions_disconnect' => 'Valitse Vahvista poisto -ruutu ja napsauta OK valitun päätepalvelimen istuntojen yhteyden katkaisemiseksi.',
    'tssessions_logoff' => 'Valitse Vahvista poisto -ruutu ja napsauta OK valitun päätepalvelimen istuntojen lopettamiseksi.',
    'b_tssession_disconnect_submit' => 'Lähetä muutokset napsauttamalla tätä.',
    'b_tssession_logoff' => 'Kirjaudu ulos istunnosta napsauttamalla.',
    'b_tssession_logoff_submit' => 'Lähetä muutokset napsauttamalla tätä.',
    'i_tssession_active' => 'Akt.',
    'i_tssession_connected' => 'Yhdistetty',
    'i_tssession_disconnected' => 'Yhteys katkaistu',
    'i_tssession_listen' => 'Kuunnellaan',
    'tssessions__tssessionslist' => 'Istunnot',
    'tssessionslist__state' => 'S',
    'tssessionslist__name' => 'Nimi',
    'tssessionslist__user' => 'Käyttäjä',
    'bt_logoff_selected' => 'Kirjaudu ulos',
    'bt_logoff' => "Kirjaudu ulos",
    'bt_disconnect_selected' => 'Katkaise yhteys',
    'bt_tssession_logoff' => 'Kirjaudu ulos',
    'bt_tssession_disconnect' => 'Katkaise yhteys',
    'bt_tssession_disconect' => 'Katkaise yhteys',
    'b_tssession_disconnect' => 'Katkaise istunto napsauttamalla.',
    'b_tssession_logoff_disabled' => 'Istunnosta ei voida kirjautua ulos.',
    'b_tssession_disconnect_disabled' => 'Yhteyden katkaiseminen istuntoon ei onnistu.',
    'tssessions_info__title' => 'Istunnon %1 ominaisuudet',
    'tssessions_info__property_name' => 'Ominaisuuden nimi',
    'tssessions_info__property_value' => 'Ominaisuuden arvo',
    'tssessions__disconnect_title' => 'Seuraavien päätepalveluistuntojen yhteys katkaistaan:',
    'tssessions__session_cant_disconnect' => 'istunnon yhteyttä ei voida katkaista',
    'tssessions__logoff_title' => 'Seuraavien päätepalveluistuntojen yhteys lopetetaan:',
    'tssessions__session_cant_logoff' => 'istuntoa ei voida lopettaa',
    'tssessions__select_sessions_to_logoff' => 'Valitse istunnot, jotka on lopetettava.',
    'tssessions__select_sessions_to_disconnect' => 'Valitse istunnot, joiden yhteys on katkaistava.',
    'dns__subdomain_dns_zone_parent' => 'Tämän alitoimialueen DNS-tietueita säilytetään DNS-pääalueella. Voit muuttaa pääaluetta %1 tai luoda erillisen vyöhykkeen alitoimialueelle.',
    'dns__subdomain_dns_zone_parent_link' => 'tätä',
    'dns__no_dns_zone' => 'DNS-vyöhykkeitä ei ole määritetty toimialueeseen. Voit hallita toimialueesi DNS-vyöhykettä painamalla \'Palauta oletukset\' -painiketta.',
    'dns__unable_turn_on_subdomain_zone' => 'Alitoimialueen vyöhykettä ei voida ottaa käyttöön, koska tälle alitoimialueelle on olemassa CNAME-tietue sen päätoimialueen vyöhykkeellä.',

    '__hosting_write_modify' => 'Ylimääräiset kirjoitus-/muokkausoikeudet',


    'aspdotnet__title' => "ASP.NET palvelimen laajuinen määritys",
    'aspdotnet__dom_title' => "Verkkosivuston ASP.NET-määritys",
    'aspdotnet__wdir_title' => "ASP.NET -määritys näennäishakemistoon %1",
    'aspdotnet__group_cas_settings' => "Koodin käytön suojaus",
    'aspdotnet__group_client_scripts' => "Komentosarjakirjaston asetukset",
    'aspdotnet__group_conn_strings' => "Yhteysmerkkijononhallinta",
    'aspdotnet__group_custom_errors' => "Mukautetun virheen asetukset",
    'aspdotnet__group_framework_version' => "Framework-versio",
    'aspdotnet__group_globalization' => "Maailmanlaajuiset asetukset",
    'aspdotnet__group_other' => "Istunnon asetukset",
    'aspdotnet__group_page_and_runtime' => "Käännös ja virheenkorjaus",
    'aspdotnet__invalid_dom_config_file' => "Tämän verkkosivuston ASP.NET -määritystiedosto on vaurioitunut. Voit palauttaa sen käyttämällä palvelimen ASP.NET -oletusmääritystä napsauttamalla Aseta oletusarvoksi.",
    'aspdotnet__invalid_file_enc' => "Tiedoston koodausparametrin virheellinen arvo.",
    'aspdotnet__invalid_req_enc' => "Pyynnön koodausparametrin virheellinen arvo.",
    'aspdotnet__invalid_res_enc' => "Vastauksen koodausparametrin virheellinen arvo.",
    'aspdotnet__invalid_parent_wdir_config_file' => "ASP.NET -määritystiedosto on vaurioitunut ASP.NET -määrityksen vaurioiden vuoksi %1 ylätason hakemistoon. \nRatkaise ongelma palauttamalla %1 ASP.NET -määritys.",
    'aspdotnet__invalid_global_config_file_admin' => "ASP.NET -määritys on vaurioitunut palvelimen ASP.NET määritystiedoston vaurioiden vuoksi.",
    'aspdotnet__invalid_global_config_file' => "ASP.NET -määritys on vaurioitunut palvelimen ASP.NET määritystiedoston vaurioiden vuoksi. Kysy ohjeita palveluntarjoajalta.",
    'aspdotnet__invalid_sess_timeout' => "Istunnon aikarajaparametrin virheellinen arvo. Anna positiivinen kokonaisluku, joka on pienempi tai yhtä suuri kuin %1.",
    'aspdotnet__invalid_wdir_config_file' => "Tämän näennäishakemiston ASP.NET -määritystiedosto on vaurioitunut. Voit palauttaa sen käyttämällä ylätason näennäishakemiston ASP.NET -määritystä napsauttamalla Aseta oletusarvoksi.",
    'aspdotnet__param_auth_mode' => "Todennustila",
    'aspdotnet__param_conn_strings' => "Yhteysmerkkijonot",
    'aspdotnet__param_conn_string_name' => "Nimi",
    'aspdotnet__param_conn_string_value' => "Yhteysparametrit",
    'aspdotnet__param_culture' => "Maa-asetus",
    'aspdotnet__param_custom_err_mode' => "Mukautetun virheen tila",
    'aspdotnet__param_custom_error_redirect' => "URL-osoitteen uudelleenohjaus",
    'aspdotnet__param_custom_error_status' => "Tilakoodi",
    'aspdotnet__param_custom_errors' => "Mukautettavat virheet",
    'aspdotnet__param_debug_mode' => "Ota virheenkorjaus käyttöön",
    'aspdotnet__param_def_language' => "Verkkosivuston oletuskieli",
    'aspdotnet__param_temp_directory' => "Väliaikainen hakemisto",
    'aspdotnet__param_file_enc' => "Tiedostojen koodaus",
    'aspdotnet__param_req_enc' => "Pyynnön koodaus",
    'aspdotnet__param_res_enc' => "Vastauksen koodaus",
    'aspdotnet__param_sess_timeout' => "Istunnon aikakatkaisu (minuutteina)",
    'aspdotnet__param_trust_level' => "CAS-luottamustaso",
    'aspdotnet__param_ui_culture' => "UI-kulttuuri",
    'aspdotnet__param_version' => "Versio",
    'aspdotnet__param_trust_level_allow_override' => 'Salli yksittäisten verkkosivustojen CAS-luottamustason muuttaminen',
    'aspdotnet__restore_default_confirm' => "Haluatko palauttaa ASP.NET -oletusasetukset?",

    'bt_restore_default' => "Aseta oletusarvoksi",
    'b_aspdotnet' => 'Muokkaa ASP.NET-määritysasetuksia.',
    'b_aspdotnet__restore_default' => 'Palauta ASP.NET -oletusasetukset.',
    'b_aspdotnet__restore_wdir_default' => "Palauta ylätason hakemiston ASP.NET -asetukset tämän näennäishakemiston kohdalla.",
    'b_aspdotnet__restore_default_disabled' => 'ASP.NET -oletusmäärityksen palautus ei ole käytettävissä: ASP.NET -määritys on vaurioitunut joko palvelimella tai ylätason hakemistossa.',
    'b_autoinstaller' => 'Päivitä Plesk tai sen komponentit.',
    'b_autoinstaller_configure' => 'Asetusten päivittäminen.',
    'b_autoinstaller_install' => 'Asenna valitut osat.',

    '__iis_app_pool__use_dedicated' => 'Varattu IIS-sovellussarja',
    '__iis_app_pool__use_dedicated_addons' => 'Varattu IIS-sovellussarja kuhunkin verkkosivustoon',
    '__iis_app_pool__enable_32bit_app_on_win64' => 'Ota 32-bittiset sovellukset käyttöön',
    'bt_iis_app_pool' => "IIS-sovellussarja",

    'performance__cpu_usage' => 'Suorittimen enimmäiskäyttö (%)',
    'performance__cpu_usage_action' => 'Rajoitustoiminto',
    'performance__cpu_usage_interval' => 'Rajoitusväli (minuuttia)',
    'performance__cpu_usage_action_not_supported' => 'Verkkopalvelin ei tue annettua toimintoa.',

    'performance__idle_timeout_action_not_supported' => 'Verkkopalvelin ei tue annettua käyttämättömyyden aikakatkaisutoimintoa.',
    'performance__max_worker_processes' => 'Työprosessien maksimimäärä',
    'performance__idle_timeout' => 'Käyttämättömyyden aikakatkaisu (minuuttia)',
    'performance__idle_timeout_action' => 'Käyttämättömyyden aikakatkaisutoiminto',
    'performance__recycling_by_time' => 'Kierrätetään säännöllisin aikavälein (minuuttia)',
    'performance__recycling_by_requests' => 'Kierrätetään, kun maksimimäärä pyyntöjä saavutetaan',
    'performance__recycling_by_virtual_memory' => 'Kierrätetään, kun maksimimäärä näennäismuistia on käytetty',
    'performance__recycling_by_private_memory' => 'Kierrätetään, kun maksimimäärä yksityistä muistia on käytetty',
    'performance__managed_pipeline_mode' => 'Hallittu putkitila',
    'performance__managed_pipeline_mode_not_supported' => 'Verkkopalvelin ei tue määritettyä tilaa.',

    'iis_app_pool' => 'IIS-sovellussarjan hallinta.',
    'b_iis_app_pool' => 'Hallitse IIS-sovellussarjaa.',
    'iis_app_pool_cl_dom' => 'IIS-sovellussarjan hallinta.',

    'i_webdirs_not_protected' => 'Tätä hakemistoa ei ole suojattu.',
    'i_webdirs_protected' => 'Tämä hakemisto on suojattu.',
    'i_webdirs_manage_protection' => 'Hallitse suojausta.',
    'i_webdirs_open' => 'Avaa hakemisto/tiedosto selaimessa.',
    'i_webdirs_preferences_disabled' => 'Tämä hakemisto ei ole näennäishakemisto.',
    'i_webdirs_permissions' => 'Hallitse käyttöoikeuksia.',
    'i_webdirs_permissions_disabled' => 'Hakemiston käyttöoikeuksien hallinta ei ole käytettävissä.',
    'i_webdirs_type_dir' => 'Fyysinen kansio',
    'i_webdirs_type_vdir' => 'Näennäishakemisto',
    'i_webdirs_browse' => 'Selaa hakemiston sisältöä.',
    'i_webdirs_preferences' => 'Verkkohakemiston asetuksien hallinta.',

    'l_webdirslist_type' => 'Lajittele hakemistot tyypin mukaan.',
    'l_webdirslist_protected' => 'Lajittele hakemistot suojaustilan mukaan.',
    'l_webdirslist_name' => 'Lajittele hakemistot nimen mukaan.',

    'b_webdirslist_remove' => 'Poista valitut virtuaalihakemistot.',
    'b_webdirslist_search' => 'Anna hakumalli ja napsauta etsiäksesi virtuaalihakemistoja.',
    'b_webdirslist_show_all' => 'Näytä kaikki hakemistot.',

    'l_webdirerrordocslist_code' => 'Lajittele virheasiakirjat virhekoodin numeron mukaan.',
    'l_webdirerrordocslist_name' => 'Lajittele virheasiakirjat virheen kuvauksen mukaan.',
    'l_webdirerrordocslist_type' => 'Lajittele virheasiakirjat virheasiakirjan tyypin mukaan.',
    'l_webdirerrordocslist_location' => 'Lajittele virheasiakirjat virheasiakirjan sijainnin mukaan.',

    'b_webdirerrordocslist_search' => 'Syötä hakumalli ja napsauta löytääksesi virheasiakirjoja.',
    'b_webdirerrordocslist_remove' => 'Poista valitut virheasiakirjat.',
    'b_webdirerrordocslist_show_all' => 'Näytä kaikki virhesiakirjat.',

    'l_webdirmimetypeslist_name' => 'Lajittele MIME-tyypit tunnisteen mukaan.',
    'l_webdirmimetypeslist_content' => 'Lajittele MIME-tyypit sisällön mukaan.',

    'b_webdirmimetypeslist_remove' => 'Poista valitut MIME-tyypit.',
    'b_webdirmimetypeslist_search' => 'Anna hakumalli ja napsauta etsiäksesi MIME-tyyppejä.',
    'b_webdirmimetypeslist_show_all' => 'Näytä kaikki MIME-tyypit.',

    'b_webdir_preferences' => "Virtuaalihakemiston asetukset.",
    'b_webdir_permissions' => "Virtuaalihakemiston käyttöoikeudet.",
    'b_webdir_permissions_disabled' => "Hakemiston käyttöoikeuksien hallinta ei ole käytettävissä.",
    'b_to_webdirs' => 'Palaa hakemistojen hallintaan.',
    'b_to_webdir_mime_types' => 'Palaa MIME-tyyppien hallintaan.',
    'b_to_webdir_error_docs' => 'Palaa virheasiakirjojen hallintaan.',
    'b_to_webdir_protection' => 'Palaa näennäishakemiston suojauksen hallintaan.',

    'webdirs__title' => 'Virtuaalihakemisto %1',
    'webdirs__preferences_title' => 'Virtuaalihakemiston asetukset',
    'webdirs__list_legend' => 'Näennäiskansiot',
    'webdirs__list_type' => 'T',
    'webdirs__list_protected' => 'P',
    'webdirs__list_name' => 'Nimi',
    'webdirs__list_header' => '%1 kohdetta',
    'webdirs__tabs_general' => 'Yleiset',
    'webdirs__tabs_mime_types' => 'MIME-tyypit',
    'webdirs__tabs_error_docs' => 'Virheasiakirjoja',

    'webdirs__tabs_permissions' => 'Käyttöoikeudet',
    'webdir__remove_vdirs' => 'Seuraavat virtuaalihakemistot poistetaan:',
    'webdir__remove_mime_types' => 'Seuraavat MIME-tyypit poistetaan:',
    'webdir__mime_types_title' => 'MIME-tyypit',
    'webdir__protection_disable_confirm' => 'Haluatko varmasti poistaa suojauksen hakemistosta?',
    'webdir__protect_title' => 'Suojatut URL-käyttäjät.',
    'webdirs__permissions_title' => 'Virtuaalihakemiston käyttöoikeudet',
    'webdirs__browse_content_permission_denied' => 'Sinulla ei ole oikeutta tarkastella tämän hakemiston sisältöä.',
    'error_doc__list_code' => 'Virhe',
    'error_doc__list_code_description' => 'Kuvaus',
    'error_doc__list_type' => 'Tyyppi',
    'error_doc__list_location' => 'Sijainti',
    'error_doc__code' => 'Virhe',
    'error_doc__type' => 'Tyyppi',
    'error_doc__type_file' => 'Tiedosto',
    'error_doc__type_url' => 'URL',
    'error_doc__location' => 'Sijainti',
    'error_doc__legend' => 'Virheasiakirja',
    'error_doc__edit_title' => 'Muokkaa virheasiakirjaa',
    'error_doc_erorr_invalid_url_location' => 'URL ei kelpaa. Määritä oikea URL-osoite.',
    'error_doc_erorr_invalid_file_location' => 'Tiedoston polku ei kelpaa. Määritä oikea tiedostopolku.',
    'error_doc__type_default' => 'Oletus',

    'webdirs__tabs_protection' => 'Suojaus',
    'pb_webdirs' => 'Näennäiskansiot',

    'webdirs_remove_title' => 'Seuraavat virtuaalihakemistot poistetaan:',
    'webdirs_mime_types_remove_title' => 'Seuraavat MIME-tyypit poistetaan:',
    'webdirs_preferences_title' => 'Virtuaalihakemiston asetukset',
    'webdirs_permissions_title' => 'Tiedostojen ja kansioiden erityisoikeudet',
    'webdi_protection_disable_confirm' => 'Haluatko varmasti poistaa suojauksen virtuaalihakemistosta? Tämä poistaa myös kaikki suojatut hakemistokäyttäjät ja hakemiston suojauksen asetukset.',
    'bt_protect' => 'Suojaa',
    'bt_unprotect' => 'Poista suojaus',
    'bt_show_additional_users' => 'Näytä enemmän käyttäjiä',
    'bt_hide_additional_users' => 'Näytä vähemmän käyttäjiä',
    'error_doc__list_title' => 'Virheasiakirjoja',
    'error_doc__list_header' => 'Virheasiakirjoja',
    'error_doc__code_400' => 'Virheellinen pyyntö',
    'error_doc__code_401' => 'Ei valtuutettu',
    'error_doc__code_401.1' => 'Valtuuttamaton - Kirjautuminen epäonnistui',
    'error_doc__code_401.2' => 'Valtuuttamaton - Kirjautuminen epäonnistui palvelimen määrityksien vuoksi',
    'error_doc__code_401.3' => 'Valtuuttamaton - Luvaton resurssin ACL:n vuoksi',
    'error_doc__code_401.4' => 'Valtuuttamaton - Valtuutus epäonnistui suodattimessa',
    'error_doc__code_401.5' => 'Valtuuttamaton - Valtuutus epäonnistui ISAPI/CGI-sovelluksessa',
    'error_doc__code_401.7' => 'Valtuuttamaton - Kielletty URL:n valtuuskäytännön vuoksi',
    'error_doc__code_403' => 'Kielletty',
    'error_doc__code_403.1' => 'Kielletty - Suorituskäyttö torjuttu',
    'error_doc__code_403.2' => 'Kielletty - Lukuoikeus torjuttu',
    'error_doc__code_403.3' => 'Kielletty - Lukuoikeus torjuttu',
    'error_doc__code_403.4' => 'Käyttö estetty - SSL 128 tarvitaan',
    'error_doc__code_403.5' => 'Käyttö estetty - SSL 128 tarvitaan',
    'error_doc__code_403.6' => 'Kielletty - IP-osoite torjuttu',
    'error_doc__code_403.7' => 'Kielletty - Client-varmenne vaaditaan',
    'error_doc__code_403.8' => 'Kielletty - Sivuston käyttöoikeus torjuttu',
    'error_doc__code_403.9' => 'Kielletty - Liian monta käyttäjää',
    'error_doc__code_403.10' => 'Kielletty - Virheellinen määritys',
    'error_doc__code_403.11' => 'Kielletty - Salasanan vaihto',
    'error_doc__code_403.12' => 'Kielletty - Kartoitin torjui käyttöoikeuden',
    'error_doc__code_403.13' => 'Kielletty - Clientin varmenne kumottu',
    'error_doc__code_403.14' => 'Kielletty - Hakemistolista torjuttu',
    'error_doc__code_403.15' => 'Kielletty - Clientin käyttöoikeudet ylitetty',
    'error_doc__code_403.16' => 'Kielletty - Client-varmenne luottamaton tai virheellinen',
    'error_doc__code_403.17' => 'Käyttö estetty - Asiakasvarmenne on vanhentunut, tai se ei ole vielä voimassa',
    'error_doc__code_403.18' => 'Kielletty - Tämän sovellussarjan pyyntöä ei voida suorittaa',
    'error_doc__code_403.19' => 'Kielletty - CGI-oikeus torjuttu',
    'error_doc__code_403.20' => 'Kielletty - Passport-kirjautuminen epäonnistui',
    'error_doc__code_404' => 'Ei löydy',
    'error_doc__code_404.2' => 'Ei löytynyt - Torjuttu lukituskäytännön vuoksi',
    'error_doc__code_404.3' => 'Ei löytynyt - Torjuttu MIMEMAP-käytännön vuoksi',
    'error_doc__code_405' => 'Menetelmä ei ole sallittu',
    'error_doc__code_406' => 'Ei hyväksyttävä',
    'error_doc__code_407' => 'Vaaditaan välityspalvelimen todennus',
    'error_doc__code_412' => 'Esiehto epäonnistui',
    'error_doc__code_414' => 'Pyynnön URI liian pitkä',
    'error_doc__code_415' => 'Tietovälinetyyppiä ei tueta',
    'error_doc__code_500' => 'Sisäinen palvelinvirhe',
    'error_doc__code_500.12' => 'Sisäinen palvelimen virhe - Sovellus käynnistyy uudelleen',
    'error_doc__code_500.13' => 'Sisäinen palvelimen virhe - Palvelin varattu',
    'error_doc__code_500.15' => 'Sisäinen palvelimen virhe - Suorat GLOBAL.ASA-pyynnöt kiellettyjä',
    'error_doc__code_500.16' => 'Sisäinen palvelimen virhe - UNC-käyttöoikeusvirhe',
    'error_doc__code_500.17' => 'Sisäinen palvelimen virhe - URL-valtuutustietosäilöä ei löydy',
    'error_doc__code_500.18' => 'Sisäinen palvelimen virhe - URL-valtuutustietosäilöä ei voida avata',
    'error_doc__code_500.19' => 'Sisäinen palvelimen virhe - Tiedoston metatiedot virheelliset',
    'error_doc__code_500.100' => 'Sisäinen palvelimen virhe - ASP-virhe',
    'error_doc__code_501' => 'Ei toteutettu',
    'error_doc__code_502' => 'Virheellinen yhdyskäytävä',
    'error_doc__code_503' => 'Palvelu on tilapäisesti poissa käytöstä',

    'mimetype__extension' => 'Tunniste',
    'mimetype__content' => 'Sisältö',
    'mimetypeslist__title' => 'MIME-tyypit',
    'mimetypes__title' => 'MIME-tyypit',
    'mimetypes__select_to_remove' => 'Valitse poistettavat MIME-tyypit.',
    'mimetypes__select_for_remove' => "Valitse poistettavat MIME-tyypit.",
    'mimetypes_remove__title' => 'Poista MIME-tyyppi',
    'mimetype__legend' => 'MIME-tyyppi',
    'mimetype_edit__title' => 'Muokkaa MIME-tyyppiä',
    'mimetype_edit__already_exists' => 'MIME-tyyppi on jo määritetty tälle tunnisteelle.',
    'mimetype_edit__not_exists' => 'MIME-tyyppiä ei ole olemassa.',
    'mimetype__content_type_other' => 'Mukautettu...',

    'b_webdir_protection_enable' => 'Suojaa hakemistoa vastaava URL salasanalla.',
    'b_webdir_protection_disable' => 'Aseta hakemistoa vastaava URL kaikkien saataville.',
    'b_webdir_protection_disabled' => 'Näennäishakemiston suojaus poistettu käytöstä.',

    'b_pd_usr_create' => 'Napsauta luodaksesi tämän suojatun URL-käyttäjän.',
    'php__changeversion_title' => "Valitse PHP-versio",
    'php__group_php_version' => "PHP-versio",

    'virtualdir__name' => 'Nimi',
    'virtualdir__path' => 'Polku',
    'virtualdir__read' => 'Lukuoikeus',
    'virtualdir__read_short' => 'R',
    'virtualdir__write' => 'Kirjoitusoikeus',
    'virtualdir__write_short' => 'W',
    'virtualdir__source' => 'Komentosarjan lähdekoodin käyttöoikeus',
    'virtualdir__source_short' => 'S',
    'virtualdir__browse' => 'Kansioiden selausoikeus',
    'virtualdir__browse_short' => 'B',
    'virtualdir__script_execute' => 'Suoritusoikeudet',
    'virtualdir__script_execute_short' => 'E',
    'virtualdir__log_visits' => 'Kirjaa käynnit lokiin',
    'virtualdir__app_create' => 'Luo sovellus',
    'virtualdir__app_create_short' => 'A',
    'virtualdir__auth_anon' => 'Kytkee päälle anonyymin todentamisen.',
    'virtualdir__auth_windows' => 'Kytkee päälle Windows-todentamisen.',
    'virtualdir__auth_not_enabled' => 'Anonyymi tai Windows-todentaminen tulee kytkeä päälle.',
    'virtualdir__require_ssl' => 'Vaadi SSL/TLS',
    'virtualdir__enable_default_doc' => 'Käytä oletusasiakirjoja',
    'virtualdir__default_doc' => 'Oletusasiakirjojen hakujärjestys',
    'virtualdir__enable_parent_paths' => 'Salli pääpolkujen käyttö',
    'virtualdir__execute_in_mta' => 'Salli sovelluksen suoritus MTA-tilassa (multi-threaded apartment)',
    'virtualdir_create__title' => 'Luo virtuaalihakemisto kohteeseen %1',
    'virtualdir_edit__title' => 'Näennäishakemiston %1 ominaisuudet',
    'virtualdir_edit__legend' => 'Näennäishakemisto',
    'virtualdir_edit__application_legend' => 'Sovelluksen asetukset',
    'virtualdir_edit__security_legend' => 'Hakemistosuojaus',
    'virtualdir_edit__documents_legend' => 'Tiedostot',
    'virtualdir_edit__list_legend' => 'Sisäkkäiset virtuaalihakemistot',
    'virtualdir_error__path_not_in__' => 'Määritettiin virheellinen polku',
    'virtualdir_error__already_exists' => 'Samanniminen hakemisto on jo olemassa.',
    'virtualdir_root' => 'Näennäiskansiot',
    'virtualdir_root__title' => 'Näennäiskansiot',
    'virtualdir_root__list_legend' => 'Näennäiskansiot',
    'virtualdir_se__none' => 'Ei ole',
    'virtualdir_se__script' => 'Vain komentosarjat',
    'virtualdir_se__script_execute' => 'Komentosarjat ja suoritettavat tiedostot',
    'virtualdirs__title' => 'Näennäiskansiot',
    'virtualdirs__path_not_exists' => 'Virheellinen polku.',
    'virtualdirs__select_for_remove' => "Valitse poistettavat näennäishakemistot.",
    'virtualdirs_remove__title' => 'Poista virtuaalihakemistot',
    'virtualdirs_phys_dir_exist' => 'Samanniminen fyysinen hakemisto on jo olemassa. Jos jatkat, siihen ei päästä enää. Haluatko jatkaa?',
    'virtualdir_auto_create_dir' => "Luo fyysinen hakemisto näennäishakemiston nimellä",

    'asp_max_default_text' => 'Ylätason hakemiston määrittämä (%1 Kt)',
    'asp_max_default_text_site' => 'IIS:n määrittämä (%1 Kt)',
    'asp_max_buffer_text' =>'ASP-puskurin maksimikoko (Kt)',
    'asp_max_body_text' => 'ASP-pyynnön entiteettikokonaisuuden maksimikoko (Kt)',
    'asp_buffers_legend' =>'ASP-asetukset',

    'asp_debug_default_text' =>'Ylätason hakemiston määrittämä',
    'asp_debug_default_text_site' =>'IIS:n määrittämä',
    'asp_client_debug_text' =>'Ota käyttöön asiakkaan ASP-komentosarjan virheenetsintä',
    'asp_server_debug_text' =>'Ota käyttöön palvelimen ASP-komentosarjan virheenetsintä',

    'webdirs__list_with_broken_dirs' => "Näennäishakemistoja on yhdistetty olemassa olemattomiin fyysisiin kansioihin.",
    'webdirs__vdir_physical_path_not_exist' => "Näennäishakemisto on yhdistetty fyysiseen kansioon, jota ei ole olemassa.",
    'webdirs__physical_path_not_exist' => "Määritettyä polkua ei ole.",

    'filemanager__new_dir_title' => 'Luo hakemisto',
    'php__configuration_title' => "PHP-määritys",

    'permissions__title' => 'Määritä käyttöoikeudet',
    'permissions__title_advanced' => 'Lisäkäyttöoikeuksien asettaminen',
    'permissions__inherit_from_parent' => 'Salli periytyvien oikeuksien välitys pääobjektista tälle objektille ja kaikille aliobjekteille. Sisällytä nämä tässä nimenomaan määritettyihin tietoihin.',
    'permissions__replace_on_children' => 'Korvaa käyttölupatiedot kaikissa aliobjekteissa tässä esitetyillä arvoilla.',
    'permissions__group_or_user_name' => 'Ryhmä- tai käyttäjänimet',
    'permissions__Permissions_for' => 'Käyttöoikeudet:',
    'permissions__allow' => 'Salli',
    'permissions__deny' => 'Estä',
    'permissions__FullControl' => 'Täydet oikeudet',
    'permissions__Modify' => 'Muokkaa',
    'permissions__ReadAndExecute' => 'Lue & suorita',
    'permissions__ListFolderContents' => 'Luetteloi kansion sisältö',
    'permissions__Read' => 'Luettu',
    'permissions__Write' => 'Kirjoitus',
    'permissions__ReadControl' => 'Luvun valvonta',
    'permissions__WriteControl' => 'Kirjoituksen hallinta',
    'permissions__ExecuteControl' => 'Suorituksen hallinta',
    'permissions__TraverseFolderOrExecuteFile' => 'Käy kansio läpi tai suorita tiedosto',
    'permissions__ListFolderOrRead' => 'Luetteloi kansion sisältö / lue tiedot',
    'permissions__CreateFilesOrWrite' => 'Luo tiedostot / kirjoita tiedot',
    'permissions__CreateFoldersOrAppend' => 'Luo kansiot / liitä tiedot',
    'permissions__DeleteSubfoldersandFiles' => 'Poista alikansiot ja tiedostot',
    'permissions__Delete' => 'Poista',
    'permissions__ChangePermissions' => 'Muuta käyttöoikeuksia',
    'permissions__TakeOwnership' => 'Omistukseen otto',
    'permissions__inherited_from' => 'Peritty kohteesta',
    'permissions__not_inherited' => '<ei peritty>',
    'permissions__apply_to' => 'Käytä',
    'permissions__apply_onto' => 'Käytä:',
    'permissions__apply_onto1' => 'Vain tämä kansio',
    'permissions__apply_onto2' => 'Vain alikansiot',
    'permissions__apply_onto3' => 'Tämä kansio ja alikansiot',
    'permissions__apply_onto4' => 'Vain tiedostot',
    'permissions__apply_onto5' => 'Tämä kansio ja tiedostot',
    'permissions__apply_onto6' => 'Vain alikansiot ja tiedostot',
    'permissions__apply_onto7' => 'Tämä kansio, alikansiot ja tiedostot',

    'filemanager__not_allowed_dir' => "Et voi muuttaa tämän kansion käyttöoikeuksia.",

    'filemanager__allow' => "Salli",
    'filemanager__deny' => "Estä",
    'filemanager__user_domusr' => 'Verkkosivuston järjestelmävalvoja',
    'filemanager__user_webusr' => 'Internet-käyttäjä',
    'filemanager__user_admins' => 'Järjestelmänvalvojat',
    'filemanager__user_system' => 'JÄRJESTELMÄ',
    'filemanager__user_aspnet' => 'ASP.NET -käyttäjä',
    'filemanager__user_poolusr' => 'Sovellussarjan käyttäjä',
    'filemanager__user_sysaccount' => 'Järjestelmän lisäkäyttäjä',

    'bt_permissions_advanced' => 'Lisäasetukset',
    'b_permissions_advanced' => 'Napsauta nähdäksesi ja asettaaksesi erityislupia.',

    'b_hotlinkprotection' => 'Aseta verkkosivuston suoralinkkisuoja.',
    'b_hotlinkprotection_on' => 'Ota verkkosivuston sisällön suoralinkkisuoja käyttöön.',
    'b_hotlinkprotection_off' => 'Poista verkkosivuston sisällön suoralinkkisuoja käytöstä.',

    'bt_hotlinkprotection' => 'Pikalinkkisuojaus',
    'hotlinkprotection__title' =>'Pikalinkkisuojaus',
    'hotlinkprotection__friend_domains' => 'Hyväksyttävien verkkosivustojen osoitteet',
    'hotlinkprotection__extensions' => 'Suojatut tiedostojen tunnisteet',

    'hotlinkprotection_invalid_friend_domains' => 'Hyväksyttävien toimialueiden virheelliset nimet.',
    'hotlinkprotection_invalid_extensions' => 'Tiedoston tunnisteissa on virheellisiä merkkejä.',

    'i_domain_alias_status_on' => 'Toimialueen alias on käytössä.',
    'i_domain_alias_status_off' => 'Toimialueen alias on pois käytöstä.',
    'i_domain_alias_status_with_parent' => 'Toimialueen alias on poistettu käytöstä, sillä toimialue on poistettu käytöstä.',
    'i_domain_alias_turn_off' => 'Poista käytöstä napsauttamalla.',
    'i_domain_alias_turn_on' => 'Ota käyttöön napsauttamalla.',
    'i_domain_alias_mail_on' => 'Sähköpostipalvelu on käytössä tämän toimialueen aliaksen kohdalla.',
    'i_domain_alias_mail_off' => 'Sähköpostipalvelu on pois käytöstä tämän toimialueen aliaksen kohdalla.',
    'i_domain_alias_mail_with_parent' => 'Sähköpostipalvelu on poistettu käytöstä, sillä toimialueen alias on poistettu käytöstä.',
    'i_domain_alias_web_on' => 'Verkkosähköpostipalvelu on käytössä tämän toimialueen aliaksen kohdalla.',
    'i_domain_alias_web_off' => 'Verkkosähköpostipalvelu on pois käytöstä tämän toimialueen aliaksen kohdalla.',
    'i_domain_alias_web_with_parent' => 'Verkkosähköpostipalvelu on poistettu käytöstä, sillä toimialueen alias on poistettu käytöstä.',
    'i_domain_alias_dns_on' => 'DNS-aliaspalvelu on käytössä tämän toimialueen aliaksen kohdalla.',
    'i_domain_alias_dns_off' => 'DNS-aliaspalvelu on pois käytöstä tämän toimialueen aliaksen kohdalla.',
    'i_domain_alias_dns_with_parent' => 'DNS-synkronointi päätoimialueella on poistettu käytöstä, koska toimialueen alias on poistettu käytöstä.',
    'i_domain_alias_seoRedirect_on' => 'Uudelleenohjaus HTTP 301 -koodilla on käytössä tämän toimialueen aliaksen kohdalla.',
    'i_domain_alias_seoRedirect_off' => 'Uudelleenohjaus HTTP 301 -koodilla on pois käytöstä tämän toimialueen aliaksen kohdalla.',
    'i_domain_alias_seoRedirect_with_parent' => 'Uudelleenohjaus HTTP 301 -koodilla on pois käytöstä, koska toimialueen alias on pois käytöstä.',

    'domain_alias__control_title' => 'Toimialueen alias %1',
    'domain_alias__control_info_legend' => 'Tiedot',
    'domain_alias__control_status_title' => 'S',
    'domain_alias__control_name_title' => 'Palvelun nimi',
    'domain_alias__control_details_title' => 'Tiedot',

    'domain_alias__invalid_values' => 'Määritetty toimialueen nimi on virheellinen. Toimialueiden nimet voivat koostua kirjaimista, numeroista ja viivoista. Toimialueen nimen kaikkien pisteiden välillä olevien osien tulee olla yli 63 merkkiä pitkiä.',
    'domain_alias__domain_already_exists' => "Toimialueen aliaksen %1 virheellinen nimi. Toimialue %1 on jo olemassa.",
    'domain_alias__www_prefix_domain_already_exists' => "Toimialueen virheellinen aliaksen nimi www.%1. Tämä alias on jo luotu toimialueelle %1.",
    'domain_alias__webmail_enabled_domain_already_exists' => 'Toimialueen virheellinen aliaksen nimi webmail.%1. Tämä alias on jo luotu toimialueelle %1.',
    'domain_alias__lists_enabled_domain_already_exists' => 'Toimialueen virheellinen aliaksen nimi lists.%1. Tämä alias on jo luotu toimialueelle %1.',
    'domain_alias__dns_record_already_exists' => 'Toimialueen aliasta %1 ei voida asettaa, koska isäntään %1 kohdistuva DNS-tietue on jo olemassa.',
    'domain_alias__domain_alias_already_exists' => "Toimialueen alias, jolla on määritetty nimi, on jo olemassa.",
    'domain_aliases__mail_server_not_support_aliases' => 'Sähköpostipalvelin ei tue toimialueen aliastoimintoa. Toimialueen aliakset eivät välttämättä toimi oikein.',
    'domain_alias__restrict_domain_creation' => 'Palvelimen laajuinen käytäntö kieltää toimialueen aliaksen annetun nimen. Jos tämä toimialueen aliaksen nimi kuuluu sinulle, ota yhteyttä isännöintipalvelujen tarjoajaan.',
    'domain_alias__restrict_creation_with_www' => 'Syötä toimialueen nimi ilman etuliitettä \'www\'. Toimialueen etuliite www lisätään automaattisesti verkkopalvelimen määrityksiin.',
    'domain_unable_to_set_name' => 'Virheellinen nimi %1.',

    'domain_alias__domain_service_dns_disabled' => 'Toinen DNS-palvelin käyttää tätä toimialuetta.',
    'domain_alias__domain_service_dns_enabled_master' => 'Tämä DNS-palvelin toimii päänimipalvelimena tällä DNS-vyöhykkeellä.',
    'domain_alias__domain_service_dns_enabled_slave' => 'Tämä DNS-palvelin toimii lisänimipalvelimena tällä DNS-vyöhykkeellä.',
    'domain_alias__domain_service_mail_enabled' => 'Sähköpostipalvelu on otettu käyttöön toimialueen kohdalla.',
    'domain_alias__domain_service_mail_disabled' => 'Sähköpostipalvelu on poistettu käytöstä toimialueen kohdalla.',
    'domain_alias__domain_service_mail_mx' => '%1 käytetään sähköpostipalvelimena.',

    'domain_alias__service_seoRedirect_hint' => 'Kun vierailijat avaavat aliaksen URL-osoitteen, heidät ohjataan ensisijaisen toimialueen URL-osoitteeseen. Plesk käyttää hakukoneisiin sopivaa HTTP 301 -uudelleenohjausta, mikä tarkoittaa, että hakukoneiden luokitusta ei jaeta URL-osoitteiden kesken.',

    'bt_task_run_now' => 'Suorita nyt',
    'ftp__read_perm' => "Lukuoikeus",
    'ftp__write_perm' => "Kirjoitusoikeus",

    'filemanager__upload_backup_file_hint' => 'Tässä voit ladata varmuuskopiointitiedostoja Pleskin säilytystilaan. Tiedoston maksimikoko on rajoitettu kahteen gigatavuun.',

    '__default_for_mssql' => 'MS SQL -oletus',

    '__login_does_not_pass_validation' => "Käyttäjänimi on virheellinen. Varmista, että se täyttää seuraavat vaatimukset: %1",
    '__login_allowed_symbols' => 'Vain aakkosnumeeriset merkit, pisteet, viivat ja alaviivat mukaan lukien, sallitaan. Ensimmäisen merkin on oltava aakkosnumeerinen.',

    'restart__nginx' => 'Käänteinen välityspalvelin (nginx)',
    'restart__php-fpm' => 'PHP-FPM %1',

    'admin_ed__i_would_like_recieve_announce' => "Haluan saada yleisiä tuotetietoja ja ilmoituksia Pleskilta.",
    'admin_ed__i_would_like_recieve_tech_announce' => "Haluan saada turvallisuuteen liittyvää tietoa ja muita teknisiä ilmoituksia Pleskilta.",

    '__login_status_inactive' => 'Tili on pois käytöstä. Ota yhteys Pleskin järjestelmänvalvojaan.',

    'migration__task_keep_in_process' => 'OK',
    'migration__task_keep_in_process_conhelp' => 'Palaa Työkalut & Asetukset -sivulle. Siirtoa jatketaan taustalla.',

    'ui__admin-alias-info__description' => "Muokkaa ylimääräisen järjestelmänvalvojan tilin yhteystietoja.",
    'ui__admin-alias-info__short-title' => "Yhteystiedot",
    'ui__admin-alias-info__title' => "Ylimääräisen järjestelmänvalvojan tilin tiedot",
    'ui__admin-alias-password__description' => "Muuta ylimääräisen järjestelmänvalvojan salasanaa.",

    'ui__admin-alias-password__short-title' => "Muuta salasana",
    'ui__admin-alias-password__title' => "Ylimääräinen järjestelmänvalvojan salasana",
    'ui__admin-alias__description' => "Näytä ja muuta ylimääräisten järjestelmänvalvojan tilien tietoja.",

    'chk_js__warning_about_login_syntax' => "Voit käyttää käyttäjänimessä pieniä aakkosnumeerisia merkkejä, ajatusviivaa ja alaviivaa. Käyttäjänimen täytyy alkaa aakkosmerkillä. Salasana ei saa sisältää käyttäjänimeä tai lainausmerkkejä.",
    'chk_js__warning_about_ftp_login_syntax' => "Voit käyttää käyttäjänimessä aakkosnumeerisia merkkejä, ajatusviivaa ja alaviivaa.",
    'chk_js__warning_about_login_syntax_win' => "Voit käyttää käyttäjänimessä pieniä aakkosnumeerisia merkkejä, ajatusviivaa, pistettä ja alaviivaa.  Käyttäjätunnuksen tulee alkaa aakkosnumeerisella symbolilla tai numerolla. Salasana ei saa sisältää käyttäjänimeä tai lainausmerkkejä.",
    'chk_js__warning_about_passwd_syntax' => "Älä käytä salasanassa lainausmerkkejä, välilyöntiä tai kansallisia kirjainmerkkejä.\nSalasanan on oltava %1–%2 merkin pituinen, ja se ei saa sisältää käyttäjätunnusta.",
    'chk_js__warning_about_plesk_login_syntax' => "Voit käyttää käyttäjätunnuksessa pieniä aakkosnumeerisia merkkejä, pistettä, viivaa ja alaviivaa.",
    'chk_js__warning_about_plesk_login_syntax_win' => "Voit käyttää käyttäjänimessä pieniä aakkosnumeerisia merkkejä, ajatusviivaa ja alaviivaa. Käyttäjänimen täytyy alkaa aakkosmerkillä.",
    'chk_js__warning_about_plesk_passwd_syntax' => "Älä käytä salasanassa lainausmerkkejä, välilyöntiä tai kansallisia aakkosmerkkejä.\nSalasanan on oltava %1–%2 merkkiä pitkä ja se ei saa sisältää käyttäjätunnusta.",
    'chk_js__warning_about_pam_passwd_error' => "Määritetty järjestelmän käyttäjätili on virheellinen: %1",

    'cmd_server__admin_alias_not_found' => "Järjestelmänvalvojan lisätiliä ei löydy.",

    'panel_branding__skins_already_exists' => "Huomaa: Teema '%1' on jo olemassa. Se korvataan teemalla, jota asennat tällä hetkellä.",
    'panel_branding__skins_file_exists' => "Hakemistoa ei voida luoda aiheelle '%1': samanniminen tiedosto on jo olemassa.",

    'actionlog__login_failed' => 'sisään kirjautuminen epäonnistui',
    'actionlog__event_cp_user_login_failed' => 'Plesk -käyttäjän sisään kirjautuminen epäonnistui',
    'actionlog__api_login_failed' => 'kirjautuminen API:n kautta epäonnistui',
    'actionlog__event_cp_user_api_login_failed' => 'Plesk -käyttäjän kirjautuminen API:n kautta epäonnistui',
    'actionlog__pw_reset' => 'pyydetty salasanan nollaus',

    'ch_pass_admin__email_subject' => "Pleskin salasanan muistutus",
    'ch_pass_admin__email_body' => "Terve, %1.\n\nYlläpitäjän salasanaa ei voi lähettää sähköpostitse turvallisuussyistä.\n\nKirjaudu sisään 'admin'-käyttäjänä komennolla 'plesk login'.\n\nAseta uusi 'admin'-salasana komennolla 'plesk bin admin --set-password -passwd <new_password>'\n\n",
    'ch_pass_admin__message_send_error' => 'Ei voitu lähettää sähköpostia: %1',

    'ch_pass_by_secret__email_subject' => "Pleskin salasanan muistutus",
    'ch_pass_by_secret__email_body' => "Hei %2,\n\nAseta uusi salasana käyttämällä linkkiä: %1\n\nKirjautumistunnukset: %3",
    'ch_pass_by_secret__message_send_error' => 'Salakoodin lähetys ei onnistu: %1',
    'ch_pass_by_secret__title' => 'Muuta salasana',
    'ch_pass_by_secret__secret' => 'Salainen koodi',

    'custom_button__noframe' => "Älä käytä kehyksiä",

    'custom_button__internal_hint' => 'Määritä, avataanko URL-osoite Plesk -sivulla vai uudessa selainikkunassa.',
    'custom_button__noframe_hint' => 'Jos lisäät mukautetun painikkeen, joka johtaa Plesk -laajennukseen tai ohjauspaneelissa olevaan sovellukseen, voit määrittää, miten tämä laajennus/sovellus tulee näyttää: kehyksessä vai osana Pleskin graafista käyttölittymää.',


    'actionlog__patch' => 'Päivitä',
    'actionlog__patch_available' => 'käytettävissä',
    'actionlog__event_patch_available' => 'Päivitys saatavana',
    'actionlog__patch_installed' => 'Asennettu',
    'actionlog__event_patch_installed' => 'Päivitys asennettiin',

    'actionlog__extension' => 'Tunniste',
    'actionlog__extension_status' => 'Laajennuksen tila',
    'actionlog__cloning' => 'Palvelimen kloonaus',
    'actionlog__cloning_complete' => 'valmis',
    'actionlog__event_cloning_complete' => 'Palvelimen kloonaus suoritettu',

    'actionlog__ssl_web_binding' => 'Toimialueen SSL/TLS-varmenne',
    'actionlog__ssl_web_binding_update' => 'määritetty/määrittämätön',
    'actionlog__event_ssl_web_binding_update' => 'Toimialueen SSL/TLS-varmenne määritetty/määrittämätön',

    'actionlog__ssl_web_mail_binding' => 'Verkkosähköpostin SSL/TLS-varmenne',
    'actionlog__ssl_web_mail_binding_update' => 'määritetty/määrittämätön',
    'actionlog__event_ssl_web_mail_binding_update' => 'Verkkosähköpostin SSL/TLS-varmenne määritetty/määrittämätön',

    'actionlog__ssl_mail_binding' => 'Postipalvelimen SSL/TLS-varmenne',
    'actionlog__ssl_mail_binding_update' => 'määritetty/määrittämätön',
    'actionlog__event_ssl_mail_binding_update' => 'Postipalvelimen SSL/TLS-varmenne määritetty/määrittämätön',

    'actionlog__ssl_panel_binding' => 'Pleskin SSL/TLS-varmenne',
    'actionlog__ssl_panel_binding_update' => 'määritetty/määrittämätön',
    'actionlog__event_ssl_panel_binding_update' => 'Pleskin SSL/TLS-varmenne määritetty/määrittämätön',

    'actionlog__hostname' => 'Palvelimen isäntänimi',
    'actionlog__hostname_changed' => 'muutettu',

    'actionlog__event_mail_management_status_update' => 'Postin hallinnan tilapäivitys',
    'actionlog__mail_management' => 'Postin hallinnan tila',
    'actionlog__mail_management_status_update' => 'päivitetty',

    'virtualization_openvz' => 'OpenVZ',

    '__domains_total' => 'Yhteensä toimialueiden mukaan',

    'chk_js__warning_about_admin_passwd_syntax' => "Älä käytä salasanassa heittomerkkejä, välilyöntiä, puolipistettä ja maakohtaisia aakkosmerkkejä.\nSalasanan on oltava %1 - %2 merkkiä pitkä ja se ei saa sisältää käyttäjätunnusta.",

    'passwordSecurityLevelCheckFailed' => 'Salasanasi ei ole riittävän monimutkainen. Palvelimen käytännön mukaisesti salasanan vähimmäisvahvuus on %1. Salasanan vahvuuden parantamiseksi tulee käyttää numeroita, isoja ja pieniä kirjaimia sekä erikoismerkkejä, esim. !,@,#,$,%,^,&,*,?,_,~',
    'passwordSecurityLevelCheckFailedVeryWeak' => 'Hyvin heikko',
    'passwordSecurityLevelCheckFailedWeak' => 'Heikko',
    'passwordSecurityLevelCheckFailedMediocre' => 'Normaali',
    'passwordSecurityLevelCheckFailedStrong' => 'Vahva',
    'passwordSecurityLevelCheckFailedStronger' => 'Hyvin vahva',

    'cu__php_settings__command_update_all' => "Päivitä toimialuekohtaiset PHP-asetukset kaikkiin toimialueisiin palvelinlaajuisen php.ini -tiedoston mukaisesti.",
    'cu__php_settings__update_all_done' => "Kaikkien toimialueiden toimialuekohtaiset PHP-asetukset päivitettiin onnistuneesti.",

    'filemanager__invalid_path' => "Määritettiin virheellinen polku",

    'ui__client/domain/dns/sync__description' => 'Ota palvelimenlaajuisen DNS-mallin muutokset käyttöön vyöhykkeeseen.',
    'ui__client/domain/dns/sync__disabled-warning' => 'DNS-mallin muutoksia ei voi ottaa käyttöön vyöhykkeessä, koska vyöhykettä palvelee muu DNS-palvelin.',
    'ui__client/domain/dns/sync__short-title' => 'Ota DNS-mallin muutokset käyttöön',
    'ui__client/domain/dns/sync__done' => 'DNS-mallin muutosten käyttöönottaminen vyöhykkeseen onnistui.',
    'ui__client/domain/domain-alias/dns/sync__description' => 'Ota palvelimenlaajuisen DNS-mallin muutokset käyttöön vyöhykkeeseen.',
    'ui__client/domain/domain-alias/dns/sync__disabled-warning' => 'DNS-mallin muutoksia ei voi ottaa käyttöön vyöhykkeessä, koska vyöhykettä palvelee muu DNS-palvelin.',
    'ui__client/domain/domain-alias/dns/sync__short-title' => 'Ota DNS-mallin muutokset käyttöön',
    'ui__client/domain/domain-alias/dns/sync__done' => 'DNS-mallin muutosten käyttöönottaminen vyöhykkeseen onnistui.',
    'dns__dns_default_ipv4_modified' => 'Tietueita, joilla on tämä IP-osoite, pidetään käyttäjän muokkaamina, eikä niitä synkronoida palvelimenlaajuisen DNS-mallin kanssa.',
    'dns__dns_default_ipv6_modified' => 'Tietueita, joilla on tämä IP-osoite, pidetään käyttäjän muokkaamina, eikä niitä synkronoida palvelimenlaajuisen DNS-mallin kanssa.',

    'dns__view_dns_record_master_title' => 'Resurssitietueiden näyttäminen',
    'dns__view_dns_record_off_title' => 'Nimipalvelimen tietueiden näyttäminen',
    'dns__view_dns_record_slave_title' => 'Ensisijaisen DNS-palvelimen tietueet',

    'dns_unable_to_resolve_hostname' => "Isäntänimeä \"%1\" ei voi selvittää: %2\nVarmista, että käyttöjärjestelmän DNS-selvitys on asetettu ja että se toimii virheettömästi.",

    'no_database_server_available' => 'Tämän tilauksen käytettävissä ei ole tietokantapalvelimia.',

    'database_used_by_application_can_not_be_moved' => 'Tietokannan siirto ei onnistu: verkkosivuston sovallus käyttää tätä tietokantaa.',
    'database_user_update_orphaned_is_restricted' => 'Yhteydettömien tietokannan käyttäjätilien päivitys on kiellettyä. Voit ainoastaan poistaa tai korjata ne.',

    'database_unable_to_get_max_filesize_default_message' => 'Tietokannan tiedoston maksimikokoa ei voida määrittää: \'%1\'',
    'database_unable_to_set_max_filesize_default_message' => 'Tietokannan tiedoston maksimikokoa ei voida asettaa: \'%1\'',
    'database_unable_to_get_max_log_filesize_default_message' => 'Tietokannan lokitiedoston maksimikokoa ei voida määrittää: \'%1\'',
    'database_unable_to_set_max_log_filesize_default_message' => 'Tietokannan lokitiedoston maksimikokoa ei voida asettaa: \'%1\'',

    'database_unable_to_get_max_filesize' => 'Microsoft SQL -tietokannan \'%1\' tiedoston koon nykyistä rajaa ei voida määrittää. Uutta rajaa ei voida asettaa.',
    'database_unable_to_set_max_filesize' => 'Microsoft SQL -tietokannan \'%1\' tiedoston kokorajaa ei voida asettaa.',
    'database_unable_to_get_max_log_filesize' => 'Microsoft SQL -tietokannan \'%1\' lokitiedoston koon nykyistä rajaa ei voida määrittää. Uutta rajaa ei voida asettaa.',
    'database_unable_to_set_max_log_filesize' => 'Microsoft SQL -tietokannan \'%1\' lokitiedoston kokorajaa ei voida asettaa.',

    'database_unable_to_create_because_max_filesize' => 'Microsoft SQL -tietokantaa \'%1\' ei voida luoda: sen tiedostokoko ylittää suurimman sallitun koon.',
    'database_unable_to_move_because_max_filesize' => 'Microsoft SQL -tietokantaa \'%1\' ei voida siirtää: sen tiedostokoko ylittää suurimman sallitun koon: %2.',
    'database_unable_to_create_because_max_log_filesize' => 'Microsoft SQL -tietokantaa \'%1\' ei voida luoda: sen lokitiedoston koko ylittää suurimman sallitun koon.',
    'database_unable_to_move_because_max_log_filesize' => 'Microsoft SQL -tietokantaa \'%1\' ei voida siirtää: sen lokitiedoston koko ylittää suurimman sallitun koon: %2.',
    'database_unable_to_restore_because_max_filesize' => 'Microsoft SQL -tietokantaa \'%1\' ei voida palauttaa: sen tiedostokoko ylittää suurimman sallitun koon.',

    'sandbox_mssql_server_registered_as_usual_db_server' => 'Identtinen MS SQL -palvelin on jo rekisteröity Pleskiin. Määritä toinen MS SQL -palvelin eristykseen.',
    'database_server__mssql_server_registered_as_sandbox' => 'Identtinen eristyksen MS SQL -palvelin on jo rekisteröity Pleskiin. Määritä toinen MS SQL -palvelin eristykseen.',

    'database_server_mysql_unable_to_connect_via_cli' => 'Ei voida muodostaa yhteyttä palvelimeen reittiä: \'%1\': %2',

    'bu_conflict_resolver_feature_not_available' => 'Seuraavat palvelusolmut eivät tue toimintoa %1: %2. Kyseinen toiminto on poistettu käytöstä näissä solmuissa luoduissa kohteissa.',
    'bu_conflict_resolver_feature_not_available_single_server' => 'Palvelin ei tue ominaisuutta %1. Tämä toiminto poistetaan käytöstä kaikkien palautettujen kohteiden kohdalla.',
    'bu_conflict_resolver_component_unavailable_in_sites' => 'Osaa %1 ei ole asennettu. Se ei ole käytössä seuraavien verkkosivustojen kohdalla: {{objects}}',
    'bu_conflict_resolver_component_replaced_in_sites' => 'Osaa %1 ei ole asennettu. Se korvataan arvolla %2 seuraavien verkkosivustojen kohdalla: {{objects}}',

    'bu_conflict_resolver_restoration_of_object_end_to_dot_not_supported' => 'Nykyinen Plesk -versio ei tue käyttäjätunnuksia, joissa on piste (.) merkki. Jos asiakkaiden tai jälleenmyyjien käyttäjätunnuksissa on niitä, niitä ei tallenneta.',
    'bu_conflict_resolver_unable_to_find_backup_part' => 'Varmuuskopiointitiedostoa ei löydy tiedoilla %1 %2. Kohteiden %1 %2 tietoja ei palauteta.',

    'bu_conflict_resolver_zone_master_removed' => "DNS-päätietuetta ei voida palauttaa: lisävyöhykkeen tietue on kohdistettu olemassa olevaan IP-osoitteeseen %1. DNS-päätietue poistetaan lisävyöhykkeeltä.",

    'bu_conflict_resolver_not_available_scripting' => 'Kohdetta %1 ei tueta.',
    'bu_conflict_resolver_not_available_scripting_in_sites' => 'Kohdetta %1 ei tueta. Se ei ole käytössä seuraavien verkkosivustojen kohdalla: {{objects}}',
    'bu_conflict_resolver_not_available_component' => 'Osaa %1 ei ole asennettu.',
    'bu_conflict_resolver_disabled_in_multi_server' => 'Se ei ole käytössä seuraavien palvelusolmujen kohdalla: {{objects}}',
    'bu_conflict_resolver_disabled_in_single_server' => 'Se ei ole käytössä seuraavien kohteiden kohdalla: {{objects}}',
    'bu_conflict_resolver_not_available_db' => 'Seuraavat tietokantapalvelimet eivät ole käytettävissä tässä palvelimessa: %1.',

    'bu_conflict_resolver_mssql_native_dump_restore_not_available' => 'MS SQL -tietokannan varmuuskopiointitiedosto on tallennettu alkuperäiseen MS SQL -muotoon, joka voidaan palauttaa vain paikalliseen MS SQL -palvelimeen tai MS SQL -etäpalvelimeen täysin määritetyillä varmuuskopiointiasetuksilla. Joitakin tietokannoistasi ei palautettu, koska Pleskiin ei ole rekisteröity asianmukaista MS SQL -palvelinta. Tämä vaikutti seuraaviin toimialueisiin: {{objects}}. Ota yhteys isännöintipalvelujen tarjoajaan.',

    'bu_conflict_resolver_not_available_webmail' => 'WWW-sähköpostipalvelu %1 ei ole käytettävissä. Se korvataan arvolla %2 seuraavien kohteiden kohdalla: {{objects}}',
    'bu_conflict_resolver_not_available_webmail_plan' => 'WWW-sähköpostipalvelu %1 ei ole käytettävissä. %2 korvaa sen seuraavissa palvelusuunnitelmissa: {{objects}}',
    'bu_conflict_resolver_not_available_rename_db_user' => "Tyypin '%1' tietokannat eivät tue käyttäjätunnuksia, jotka vastaavat tietokannan nimiä. Käyttäjä '%2' nimetään uudelleen arvoon '%3' tietokantaan '%4'.",

    'bu_conflict_resolver_wrong_hard_quota_value' => 'Levytilan käyttörajaa ei ole asetettu kohdepalvelimen määrityksissä. Tämän asetuksen arvo muutetaan tilaan "Rajoittamaton".',
    'bu_conflict_resolver_wrong_max_connections_value' => 'Yhteyksien maksimimäärä ei ole asetettu kohdepalvelimen määrityksissä. Tämän asetuksen arvo muutetaan tilaan "Rajoittamaton".',
    'bu_conflict_resolver_wrong_traffic_bandwidth_value' => 'Liikenteen käyttörajaa ei ole asetettu kohdepalvelimen määrityksissä. Tämän asetuksen arvo muutetaan tilaan "Rajoittamaton".',
    'cu__pleskrestore_backup_file_extracted' => 'Varmuuskopiointitiedosto purettiin arvoon "%1".',
    '__mod_bw_not_supported' => 'Moduulia mod_bw Apache-verkkopalvelimessa ei tueta tiedostojärjestelmän määrityksien mukaan. Liikenteen käytön rajat ja yhteyksien maksimimäärä eivät toimi.',
    'bu_conflict_resolver_pop3_only_relay_auth_not_supported' => 'Sähköpostivälityksen POP3-valtuutusta ei tueta, POP3:ta tullaan käyttämään sen sijaan ennen SMTP-valtuutusta. ({{objects}})',
    'bu_conflict_resolver_service_plan_name' => 'Palvelusuunnitelma \'%1\'',
    'bu_conflict_resolver_replaced_in_plans' => 'Kohdetta %1 ei tueta. %2 korvaa sen seuraavissa palvelusuunnitelmissa: {{objects}}',
    'bu_conflict_resolver_replaced_in_sites' => 'Kohdetta %1 ei tueta. Se korvataan arvolla %2 seuraavien verkkosivustojen kohdalla: {{objects}}',
    'bu_conflict_resolver_absent_objects_in_dump' => 'Seuraavia kohteita ei löytynyt varmuuskopiointitiedostosta: %1',
    'bu_conflict_resolver_absent_domains' => 'Joitakin kohteita ei voida palauttaa, koska ne kuuluvat seuraaville toimialueille, joita ei löydy Pleskistä: %1',
    'bu_conflict_resolver_absent_parent_domains' => "Joitakin verkkosivustoja ei voida palauttaa, koska ne kuuluvat seuraaville päätoimialueille, joita ei löydy Pleskistä:\n%1",
    'bu_conflict_resolver_dns_not_supported' => 'DNS-vyöhykkeitä ei voida palauttaa: DNS-palvelu on poistettu käytöstä palvelimen määrityksissä.',
    'bu_conflict_resolver_mail_not_supported' => 'Postilaatikoita ei voida palauttaa: postipalvelu on poistettu käytöstä palvelimen määrityksissä.',
    'bu_conflict_resolver__idle_timeout_action_not_supported' => 'ISS-verkkopalvelin ei tue annettua käyttämättömyyden aikakatkaisua. Arvo nollataan arvoon %1.',
    'bu_conflict_resolver__cpu_limit_action_not_supported' => 'ISS-verkkopalvelin ei tue annettua suoritinrajan toimintoa.  Arvo nollataan arvoon %1.',
    'bu_conflict_detector_server_ssl_cert_name' => 'palvelimen SSL/TLS-varmenne %1',
    'bu_conflict_detector_domain_ssl_cert_name' => 'SSL/TLS-varmenne %2 toimialueella %1',
    'bu_conflict_detector_ssl_cert_name' => 'SSL/TLS-varmenne %1',
    'bu_conflict_resolver_absent_objects' => 'Seuraavien kohteiden sisältöjä ei voida palauttaa, koska kohteita ei löydy Pleskistä: %1',
    'bu_conflict_resolver_absent_objects_mailuser' => 'Seuraavien postilaatikoiden sisältöjä ei voida palauttaa, koska postilaatikoita ei löydy Pleskistä: %1',
    'bu_conflict_resolver_absent_objects_maillist' => 'Seuraavien postituslistojen sisältöjä ei voida palauttaa, koska postituslistoja ei löydy Pleskistä: %1',
    'bu_conflict_resolver_absent_objects_database' => 'Seuraavien tietokantojen sisältöjä ei voida palauttaa, koska tietokantoja ei löydy Pleskistä: %1',
    'bu_conflict_resolver__remove_conflicted_aps_app' => 'Sovelluksen "%1" palautus kohteessa "%2" epäonnistui, koska toinen sovellus on jo asennettu kohteeseen "%3". Voit poistaa asennetun sovelluksen ja yrittää uudelleen.',
    'bu_conflict_resolver_not_available_mail_autoresponders' => 'Sähköpostin automaattista vastaustoimintoa ei tueta.',
    'bu_conflict_resolver_not_available_mail_content' => 'Sähköpostin sisällön palautusta ei tueta.',
    'bu_conflict_resolver_invalid_mail_name' => 'Seuraavia postilaatikoita ei ole palautettu, koska sähköpostin aliosoitteet ovat käytössä ja joissakin sähköpostiosoitteissa on merkki "%1": %2',
    'bu_conflict_resolver_invalid_user_name' => 'Seuraavia käyttäjiä ei ole palautettu, koska sähköpostin aliosoitteet ovat käytössä ja joissakin sähköpostiosoitteissa on merkki "%1": %2',
    'bu_conflict_resolver_licenses_expired' => 'Seuraavat lisenssit ovat vanhentuneet, eikä niitä palauteta: {{objects}}',
    'expiration_unsupported' => "Rajaa 'expiration' ei tueta.",

    'component_name__dbconnector' => "Tietokantayhteys",
    'component_name__mysqlserver' => 'MySQL-palvelin',
    'component_name__troubleshooting' => 'Vianmääritys',

    '__subscription_has_no_license_key' => 'Tilauksen resurssit tarjoaa palvelusolmu #%1, jossa ei ole vastaavaa käyttöoikeusavainta.',
    '__subscription_has_expired_license_key' => 'Tilauksen resurssit tarjoaa palvelusolmu #%1, jonka käyttöoikeusavain %2 on mennyt umpeen.',

    '__cfgmonConfigurationFileSaveErrorSubject' => '<%%host%%> Määritystiedostoja ei voida tallentaa',
    '__cfgmonConfigurationFileSaveErrorBody' => "Joitakin määritystiedostoja ei voida tallentaa isäntään <%%host%%>: Seuraavat virheet tapahtuivat:\n\n%%errors%%",

    'mail__enable_email_subaddressing_cli_desc' => 'Tämän valitsemalla voit määritellä VERP-tyyliset sähköpostiosoitteet postituslistoille',
    'mail__enter_right_ip_mask' => "Anna IP-peite 1",
    'mail__enter_right_ip_mask_24' => "Anna IP-peite 24",
    'mail__invalid_dom_name' => "Toimialueen nimi %1 ei kelpaa.",
    'mail__invalid_pop_lock_time' => "POP3:n lukitusaika on virheellinen.",
    'mail__invalid_rbl_server' => "DNS-vyöhykkeen nimi on virheellinen.",
    'mail__total_files_size' => "Säilön koko yhteensä: %1",
    'mail__filename_already_in_repository' => "Samanniminen tiedosto on jo säilössä",
    'mail__no_white_list_mask_feature_24' => "Käytä peitteen arvoa 24 tai sitä suurempaa.\nSähköpostipalvelimesi ei tue peitteiden asettamista. Voimme emuloida peitteen asetuksen vain arvoille, jotka ovat pienempiä kuin 24.",
    'mail__unable_add_new_mail_name' => "Sähköpostitiliä ei voi lisätä: %1",
    'mail_server_is_not_installed' => 'Postipalvelinta (Postfix tai Qmail) ei ole asennettu. Jatka asentamalla se.',
    'mail_server_not_available' => 'Palvelusolmulla ei ole saatavilla tuettuja sähköpostipalveluja.',
    '__not_installed' => '(ei asennettu)',
    'mail__service_node_outgoing_messages_is_disabled' => 'Lähtevien sähköpostiviestien roskapostisuodatus on pois käytöstä.',
    'mail__service_node_does_not_support_outgoing_messages_domain_limit' => 'Palvelusolmu ei tue lähtevien sähköpostiviestien rajoitusta joltakin toimialueelta toimialueelle %1.',
    'mail__service_node_does_not_support_outgoing_messages_mbox_limit' => 'Palvelusolmu ei tue lähtevien sähköpostiviestien rajoitusta jostakin postilaatikosta toimialueelle %1.',

    'mail__outgoing_email_mode_explicit_ip_unspecified' => 'Määritä vähintään yhdentyyppinen osoite (IPv4 tai IPv6).',

    'mail__outgoing_email_mode_invalid' => 'Virheellinen lähtevän postin tila annettiin.',
    'mail__outgoing_email_mode_explicit_ip_v4_invalid' => 'Virheellinen IPv4-osoite annettiin.',
    'mail__outgoing_email_mode_explicit_ip_v6_invalid' => 'Virheellinen IPv6-osoite annettiin.',
    'mail__outgoing_email_mode_unavailable' => 'Lähtevän postin tilaa ei voida muuttaa, todennäköisesti koska Postfix-postipalvelinta ei ole asennettu tähän palvelimeen.',

    'mail__autoresponder_attachment_not_supported' => 'Tällä hetkellä käytössä oleva sähköpostipalvelin ei tue automaattisen vastaajan liitteen hallintaa.',

    'mail__smtp_white_list_not_supported' => 'Käytössä oleva postipalvelin ei tue IP-osoitteiden lisäämistä sallittujen luetteloon.',
    'mail__smtp_whitelist_cidr_not_supported' => 'Valittu postipalvelin ei tue CIDR-peitteitä. Määritä IP-osoite muodossa 192.*.0.*.',
    'mail__smtp_whitelist_mask_not_supported' => 'Valittu postipalvelin ei tue korvausmerkin IP-kuvioita. Määritä IP-osoite muodossa 192.0.0.0/8.',

    'sfdk_server_wide_verify_failed' => 'DKIM-skannauspalvelun asetuksia ei voida muuttaa',

    'sfdk_domain__serverwide_disabled' => 'Poistettu käytöstä palvelinkäytännön mukaisesti',
    'feature__domainkeys__serverwide_disabled' => 'Palvelimen laajuinen DKIM-roskapostisuodatus on poistettu käytöstä',

    'defaultcomponents__error_set_default' => 'Kohdetta %1 ei voi asettaa oletukseksi %2: %3',
    'defaultcomponents__error_set_default_none' => 'Ei voitu asettaa oletuskomponentteja kohteelle %1: %2',
    'defaultcomponents__required_package_not_default' => 'Toiminnan edellyttävä komponentti %1 ei ole oletus.',

    '__percentage' => '%',
    '__seconds' => 'Sekuntia',
    '__resource_remain' => 'Jäljellä',

    '__not_registered' => '(ei rekisteröity)',
    '__php_handler_id' => 'PHP-versio',
    '__php_handler_id_string' => 'PHP %1 (%2)',
    '__php_handler_not_registered' => 'PHP-käsittelijää "%1" ei ole rekisteröity. Se on todennäköisesti poistettu palvelimelta. Rekisteröi käsittelijä samoilla ominaisuuksilla ja yritä uudelleen.',
    '__php_handler_not_registered_on_domain' => 'Toimialue "%1": PHP-käsittelijää "%2" ei ole rekisteröity. Se on todennäköisesti poistettu palvelimelta. Rekisteröi käsittelijä samoilla ominaisuuksilla ja yritä uudelleen.',
    '__php_fpm_handler' => 'FPM-sovellussarja',
    '__php_fpm-dedicated_handler' => 'Erillinen FPM-sovellus',

    'mailname_create_assigned_user_dublicate_error' => 'Postilaatikolle ei voi luoda käyttäjää. Käyttäjätunnusta %1 käyttävä käyttäjä on jo olemassa ja hänellä on toinen postilaatikko.',
    'mailname_create_assigned_user_role_absent_error' => 'Postilaatikolle ei voi luoda käyttäjää. Käyttäjän oletusroolia %1 ei ole olemassa.',

    'gphd__mime_types' => 'MIME-tyypit',
    'gphd__handlers' => 'Apache-käsittelijät',
    'gphd__ip_restrictions_allow' => 'Salli pääsy verkkosivustoon määritetyille isännille ja verkoille (lukuun ottamatta torjuttuja)',
    'gphd__ip_restrictions_deny' => 'Torju pääsy verkkosivustoon määritetyille isännille ja verkoille',
    'gphd__directory_index' => 'Indeksitiedostot',
    'gphd__nginx_transparent_mode' => 'Tila, jossa Apache käsittelee sekä staattisen että dynaamisen sisällön, kun nginx hyväksyy vain HTTP-pyynnöt ja vastaa ilman muutoksia.',
    'gphd__nginx_serve_static' => 'Palvele staattisia tiedostoja suoraan nginx:llä',
    'gphd__nginx_static_extensions' => 'Staattiset tiedostojen tunnisteet, jotka nginx:n on käsiteltävä',
    'gphd__nginx_serve_php' => 'Käsittele PHP-tiedostot nginx:n mukaan',
    'gphd__www_root' => 'WWW Päähakemisto',

    'eol__none' => 'älä muokkaa',
    'eol__lf' => 'muuta Unix-tyyliin',
    'eol__cr' => 'muuta MacOS-tyyliin',
    'eol__crlf' => 'muuta Windows-tyyliin',

    'ui__dns_bad_zone' => 'Epäyhdenmukainen vyöhyke "%1":',
    'ui__dns_ns_has_no_address_records' => 'NS-tietueessa "%1" ei ole osoitetietoja (A tai AAAA).',
    '__dns_bad_zone' => 'Epäyhdenmukainen vyöhyke "%1":',
    '__dns_ns_has_no_address_records' => 'NS-tietueessa "%1" ei ole osoitetietoja (A tai AAAA).',
    '__dns_ptr_is_wildcard' => 'PTR-tietue "%1" on virheellinen: tietue on kohdistettu yleismerkkiseen toimialueeseen.',

    'firewall_database_user_remote_access_rule_name' => '[%1][%2] Salli tietokannan käyttäjän \'%3\' etäkäyttö asiakkaassa \'%4\'',
    'firewall_database_user_remote_access_rule_name_removed' => '[%1][%2] %3',
    'firewall_database_user_remote_access_mssql_server_port_undefined' => 'Etäyhteyksiä ei voida sallia tietokannan käyttäjälle \'%1\': Microsoft SQL -palvelimen \'%2\' käyttämän TCP-portin numeroa ei voida määrittää. Mahdolliset syyt ovat seuraavat: TCP/IP-protokollaa ei ole otettu käyttöön palvelinverkon määrityksissä tai palvelin on määritetty käyttämään dynaamisia TCP-portteja. Määritä palvelin kuuntelemaan tietyllä vakiolla TCP-portilla ja yritä sallia etäyhteydet uudelleen.',

    'command__convertResellerHasCustomer' => 'Jälleenmyyjän tili \'%1\' sisältää yhden asiakastilin tai useita asiakastilejä. Voit muuttaa tämän jälleenmyyjän tilin asiakastiliksi siirtämällä kyseiset asiakastilit uudelle omistajalle tai muuttamalla ne jälleenmyyjän tileiksi.',
    'command__convertResellerNotReseller' => 'Vain jälleenmyyjän tilit voidaan muuttaa asiakastileiksi. \'%1\' ei ole jälleenmyyjä.',
    'command__convertResellerToCustomerSubscriptionNotSynchronized' => 'Tilausta ei voitu synkronoida palvelusuunnitelmaan. Seuraavat tilauksen asetukset ovat ristiriidassa palvelusuunnitelmaan: %%problems%%.',

    'moveCustomer__wrong_customer_type' => 'Tili \'%1\' on jälleenmyyjän tili. Jälleenmyyjätilejä ei voi siirtää uudelle omistajalle, koska palvelimen järjestelmänvalvoja omistaa ne.',
    'moveCustomer__wrong_owner_type' => "Asiakastili '%1' voidaan siirtää vain jälleenmyyjälle tai järjestelmänvalvojalle, sitä ei voida siirtää toiselle asiakkaalle.",
    'moveCustomer__customer_already_belongs_to_owner' => 'Asiakastili \'%1\' kuuluu jo valitulle omistajalle.',
    'upgradeClient__user_is_admin' => 'Tiliä \'%1\' ei voida muuttaa jälleenmyyjän tiliksi, koska se on järjestelmänvalvojatili.',

    'mail__error_setting_max_connections_courier' => 'Yhteyksien maksimimäärää ei voida asettaa (IMAP, POP3, IMAP SSL/TLS tai POP3 SSL/TLS): %1',
    'mail__error_setting_max_connections_dovecot' => 'Yhteyksien maksimimäärää ei voida asettaa (IMAP, POP3, IMAP SSL/TLS tai POP3 SSL/TLS): %1',
    'mail__error_setting_max_connections_per_ip_courier' => 'Yhteyksien maksimimäärää ei voida asettaa (IMAP, POP3, IMAP SSL/TLS tai POP3 SSL/TLS) IP-osoitetta kohden: %1',
    'mail__error_setting_max_connections_per_ip_dovecot' => 'Yhteyksien maksimimäärää ei voida asettaa (IMAP, POP3, IMAP SSL/TLS tai POP3 SSL/TLS) IP-osoitetta kohti tietylle sähköpostin käyttäjälle: %1',
    'outgoing_messages_limit_value_invalid' => 'Arvon on oltava välillä %%MIN%%..%%MAX%%. Ainoastaan Pleskin järjestelmänvalvoja voi säätää tätä asetusta.',
    'outgoing_messages_server_settings_catch_address_are_not_local' => "Seuraavat toimialueet käyttävät ulkoisia sähköpostiosoitteita postin edelleenlähetykseen, kun sähköposti on lähetetty olemassa olemattomiin osoitteisiin. Lähtevän postin hallinta ei huomioi kyseisiin osoitteisiin lähetettyjä viestejä:\n%1",
    'outgoing_messages_white_list_not_empty' => 'Lähtevän postin rajat eivät koske postin lähettäjiä, joiden IP-osoitteet kuuluvat sähköpostipalvelimen sallittujen listalle. Jos esimerkiksi sallittujen listalla on paikallinen isäntä (127.0.0.0 / 8, ::1 / 128), kaikki posti lähetetään onnistuneesti paikalliselta palvelimelta rajoituksista huolimatta. Postin lähettäjät voivat käyttää joko paikallisia IP-osoitteita (paikallisella palvelimella isännöidyt verkkosivustot ja mukautetut komentosarjat) tai ulkoisia IP-osoitteita (asiakkaat, jotka lähettävät postia tietokoneisiin tai mobiililaitteisiin asennetuista sähköpostiasiakkaista). Jotta rajat koskisivat kaikkia postin lähettäjiä (paikalliset ja ulkoiset), poista kaikki IP-osoitteet ja verkot sallittujen listalta. Kun paikallinen isäntä (127.0.0.0 / 8, ::1 / 128) poistetaan sallittujen listalta, verkkosivustojen ja postia palvelimelta lähettävien komentosarjojen toiminnassa voi esiintyä häiriöitä. Lue lisätietoa lähtevän postin rajoituksista järjestelmänvalvojan oppaan osiosta Lähtevän postin roskapostisuoja.',
    'outgoing_messages_relay_open' => 'Postin välitys on avoin: lähtevän postin rajat eivät toimi.',

    'notification_aps_app_updates_available' => 'Päivityksiä saatavissa seuraaville sovelluksille:',
    'notification_aps_app_updates_installed' => 'Päivitykset asennettiin automaattisesti seuraaviin sovelluksiin:',
    'notification_aps_app_updates_requirements' => 'Päivityksiä on saatavilla seuraaville sovelluksille, mutta niitä ei voida asentaa, koska vastaavien verkkosivustojen isännöintiasetukset eivät vastaa asennusvaatimuksia:',
    'notification_admin_aps_app_updates_available_item' => '%%name%% (%%url%%). Asennettu versio: %%from%%. Saatavilla oleva versio: %%to%%.',
    'notification_admin_aps_app_updates_available_plugin_item' => 'Laajennus "%%name%%" kohteessa %%parentName%% (%%url%%). Asennettu versio: %%from%%. Saatavilla oleva versio: %%to%%.',
    'notification_admin_aps_app_updates_available_theme_item' => 'Aihe "%%name%%" kohteessa %%parentName%% (%%url%%). Asennettu versio: %%from%%. Saatavilla oleva versio: %%to%%.',
    'notification_reseller_aps_app_updates_available_item' => '%%name%% (%%url%%). Asennettu versio: %%from%%. Saatavilla oleva versio: %%to%%.',
    'notification_reseller_aps_app_updates_available_plugin_item' => 'Laajennus "%%name%%" kohteessa %%parentName%% (%%url%%). Asennettu versio: %%from%%. Saatavilla oleva versio: %%to%%.',
    'notification_reseller_aps_app_updates_available_theme_item' => 'Aihe "%%name%%" kohteessa %%parentName%% (%%url%%). Asennettu versio: %%from%%. Saatavilla oleva versio: %%to%%.',
    'notification_client_aps_app_updates_available_item' => '%%name%% (%%url%%). Versiosi: %%from%%. Saatavilla oleva versio: %%to%%.',
    'notification_client_aps_app_updates_available_plugin_item' => 'Laajennus "%%name%%" kohteessa %%parentName%% (%%url%%). Versiosi: %%from%%. Saatavilla oleva versio: %%to%%.',
    'notification_client_aps_app_updates_available_theme_item' => 'Aihe "%%name%%" kohteessa %%parentName%% (%%url%%). Versiosi: %%from%%. Saatavilla oleva versio: %%to%%.',
    'notification_admin_aps_app_updates_installed_item' => '%%name%% (%%url%%). Uusi versio: %%to%%. Edellinen versio: %%from%%.',
    'notification_reseller_aps_app_updates_installed_item' => '%%name%% (%%url%%). Uusi versio: %%to%%. Edellinen versio: %%from%%.',
    'notification_client_aps_app_updates_installed_item' => '%%name%% (%%url%%). Uusi versio: %%to%%. Edellinen versio: %%from%%.',
    'notification_admin_aps_app_updates_requirements_item' => '%%name%% (%%url%%). Asennettu versio: %%from%%. Saatavilla oleva versio: %%to%%.',
    'notification_reseller_aps_app_updates_requirements_item' => '%%name%% (%%url%%). Asennettu versio: %%from%%. Saatavilla oleva versio: %%to%%.',
    'notification_client_aps_app_updates_requirements_item' => '%%name%% (%%url%%). Versiosi: %%from%%. Saatavilla oleva versio: %%to%%.',
    'notification_aps_app_updates_no_installation_url' => 'ulkoinen sovellus',

    'notification_outgoing_mail_exceeded_limits_domains' => 'Toimialueet',
    'notification_outgoing_mail_exceeded_limits_mails' => 'Sähköpostiosoitteet',
    'notification_outgoing_mail_exceeded_limits_subscriptions' => 'Tilaukset',
    'notification_outgoing_mail_exceeded_limits_limit_value' => '%1 viestiä tunnissa',
    'notification_outgoing_mail_exceeded_limits_limit_value_unlimited' => 'Rajoittamaton',
    'notification_outgoing_mail_exceeded_limits_object' => '%1, raja on %2',
    'notification_outgoing_mail_exceeded_limits_attempt' => '%1 yritys(tä) rajojen %2 - %3 ylittämiseksi',
    'notification_outgoing_mail_exceeded_limits_attempt_still_exceeding' => '%1 yritys(tä) rajojen ylittämiseksi %2 alkaen tähän saakka',

    'restart__docker' => "Docker",
    'restart__fail2ban' => "IP-osoitteen kieltäminen (Fail2Ban)",

    'backup__restore__capability_fail2ban_not_installed_text' => 'Fail2ban-komponenttia ei ole asennettu kohdepalvelimeen.',
    'backup__restore__capability_fail2ban_not_installed_resolution' => 'Asenna Fail2ban. Tämä voi viedä joitakin minuutteja.',

    'plesk_key__no_reseller_support' => 'Jälleenmyyjiä ei voida hallita käyttöoikeuksien rajoituksien vuoksi.',
    'plesk_key__no_customers_support' => 'Asiakkaita ei voida hallita käyttöoikeuksien rajoituksien vuoksi.',
    'panel_interface_uimodes__service_provider_view_not_allowed' => 'Palveluntarjoaja-näkymään ei voida siirtyä käyttöoikeuksien rajoituksien vuoksi.',
    'plesk_key__no_security_core_support' => 'Tärkeimmät turvallisuustoiminnot (ModSecurity ja Fail2Ban) eivät ole saatavilla käyttöoikeuksien rajoituksien vuoksi.',
    'plesk_key__outgoing-antispam' => 'Lähtevän postin hallinta',
    'plesk_key__security-core' => 'Security Core (ModSecurity ja Fail2Ban)',
    'plesk_key__can-manage-accounts' => 'Tilien hallinta',
    'plesk_key__can-manage-subscriptions' => 'Tilauksien hallinta',
    'plesk_key__can-manage-customers' => 'Asiakkaiden hallinta',
    'plesk_key__can-manage-resellers' => 'Jälleenmyyjien hallinta',
    'plesk_key__can-manage-custom-view' => 'Rajoitetun tilan saatavuus',
    'plesk_key__limits_exceeded_no_subscriptions_management' => 'Tilauksien hallinta on poistettu käytöstä, mutta sinulla on useita tilauksia (%1).',
    'plesk_key__limits_exceeded_no_resellers_management' => 'Jälleenmyyjien hallinta on poistettu käytöstä, mutta sinulla on useita jälleenmyyjiä (%1).',
    'plesk_key__limits_exceeded_no_customers_management' => 'Asiakkaiden hallinta on poistettu käytöstä, mutta sinulla on useita asiakkaita (%1).',
    'plesk_key__no_subscriptions_support' => 'Tilauksia ei voida hallita käyttöoikeuksien rajoituksien vuoksi.',
    'plesk_key__no_custom_view_support' => 'Rajoitettua tilaa ei voi käyttää käyttöoikeuksien rajoituksien vuoksi.',
    'plesk_key__trial_forbidden_region' => 'Pahoittelemme, Plesk ei ole tällä hetkellä käytettävissä paikkakunnallasi.',
    'additional_key__main_key' => 'Avain on pääavain: pääavainta ei voida ladata lisäavaimeksi.',

    'gch__hosting_waf_rule_engine' => 'Verkkosovelluksen palomuuritila',

    'backup__fieldset__restoration_options' => 'Palautusvaihtoehdot',
    'backup__restore_options__restore' => 'Palauta',
    'backup__restore_options__domain__domain_configuration' => 'Toimialueen määritys',
    'backup__restore_options__domain__virtual_host_content' => 'Näennäisisännän sisältö',
    'backup__restore_options__domain__mail' => 'Sähköposti',
    'backup__restore_options__domain__databases' => 'Tietokannat',
    'backup__restore_options__client__client_configuration' => 'Asiakastilin määritys',
    'backup__restore_options__client__domains' => "Asiakkaan toimialueet",
    'backup__restore_options__reseller__reseller_configuration' => 'Jälleenmyyjätilin määritys',
    'backup__restore_options__reseller__personal_domains' => "Jälleenmyyjän toimialueet",
    'backup__restore_options__reseller__clients' => "Jälleenmyyjän asiakkaat",
    'backup__restore_options__admin__server_configuration' => 'Palvelimen asetukset',
    'backup__restore_options__admin__administrator_configuration' => 'Järjestelmänvalvojan tilin määritys',
    'backup__restore_options__admin__personal_domains' => "Järjestelmänvalvojan toimialueet",
    'backup__restore_options__admin__personal_clients' => "Järjestelmänvalvojan asiakkaat",
    'backup__restore_options__admin__resellers' => 'Jälleenmyyjät',

    'badge_new' => 'Uusi',
    'upgrade_php_on_subscription' => 'Päivitä tilauksesi PHP versioon 5.3.0 tai sitä uudempaan versioon.',

    'pkey_notify__body_expiration_notification' => 'Käyttöoikeusavain on vanhentunut. Jotkin toiminnoista eivät välttämättä ole käytettävissä. Ota yhteys isännöintipalvelujen tarjoajaan.',

    'crontab__crontab_entry_exists' => "Ajoitettu tehtävä on jo olemassa.",
    'crontab__crontab_entry_not_exists' => "Ajoitettua tehtävää ei ole.",
    'crontab__invalid_values_found' => "Väärät parametriarvot.",
    'crontab__cmd_max_len' => "Komennossa saa olla enintään %1 merkkiä.",

    'domain__domain_exists' => "Toimialue on olemassa etuliitteellä 'www' ja samalla nimellä: %1.%2.",
    'domain__subdomain_exists' => "Alitoimialue on olemassa etuliitteellä 'www' ja samalla nimellä: %1.%2.",
    'domain__dalias_exists' => "Toimialueen alias on olemassa etuliitteellä 'www' ja samalla nimellä: %1.%2.",
    'domain__record_exists' => "Olemassa on DNS-tietue, joka kohdistuu isäntään %1.%2.",

    'ip_addr__cannot_assign_certificate' => "Varmennetta '%1' ei voida asettaa oletukseksi: yksityinen avain puuttuu.",
    'ip_addr__update_dns_error' => 'DNS-vyöhykkeiden IP-osoitteen päivityksessä tapahtui ongelmia. %1',
    'ip_addr__cannot_add_dhcp_enabled' => 'IP-osoitetta ei voida lisätä. Tämä verkkoliittymä saa IP-osoitteet automaattisesti.',
    'ip_addr__cannot_remove_dhcp_enabled' => 'IP-osoitetta %1 ei voida poistaa. Tämä verkkoliittymä saa IP-osoitteet automaattisesti.',
    'ip_addr__cannot_repair_dhcp_enabled' => 'IP-osoitetta %1 ei voida korjata. Tämä verkkoliittymä saa IP-osoitteet automaattisesti.',
    'ip_addr__cannot_change_interface_dhcp_enabled' => 'IP-osoitteen %1 liittymää ei voida muuttaa, koska verkkoliittymä %2 saa IP-osoitteet automaattisesti.',

    'shm_lmsg__limit_for_resource_exceeded' => 'Tilauksien %%type%% määrää koskeva raja on ylitetty. Raja on %%limit%%, josta on tällä hetkellä käytetty %%usage%%.',
    'shm_lmsg__resource_is_forbidden_for_creation' => 'Tyypin %%type%% luominen ei ole sallittua tässä tilauksessa.',
    'shm_lmsg__resource_title__db-mysql' => 'MySQL-tietokannat',
    'shm_lmsg__resource_title__db-mssql' => 'MS SQL-tietokannat',
    'shm_lmsg__resource_title__db-postgresql' => 'PostgreSQL-tietokannat',
    'shm_lmsg__resource_title__db-user' => 'tietokannan käyttäjät',
    'shm_lmsg__resource_title__iis-application-pool' => 'IIS-sovellussarjat',
    'shm_lmsg__resource_title__additional-ftp-account' => 'FTP-lisätilit',

    'db_user_unable_remove_mysql_global_privileges' => 'Tietokannan käyttäjän %1 yleisiä MySQL-oikeuksia ei voida poistaa. Syy: %2',
    'report__client_description' => 'Kuvaus',

    'db__user_role_error' => 'Tietokannan käyttäjän rooli on virheellinen: %1. Valitse jokin seuraavista rooleista: %2.',

    'subscription_unable_to_set_max_filesize_warning' => 'Lokitiedoston kokorajaa ei voida asettaa seuraaville Microsoft SQL -palvelimen tietokannoille, koska niiden lokitiedoston koko on suurempi: %1.',
    'subscription_unable_to_set_max_log_filesize_warning' => 'Lokitiedoston kokorajaa ei voida asettaa seuraaville Microsoft SQL -palvelimen tietokannoille, koska niiden lokitiedoston koko on suurempi: %1.',
    'ipaddress__cannot_set_up_public_ip_need_ipaddress' => 'Yleistä IP-osoitetta ei voida asettaa: yksityisen IP-osoitteen on oltava olemassa.',
    'ipaddress__cannot_set_up_public_ip_need_ipv6' => 'Yleistä IPv4-osoitetta ei voida asettaa IPv6-osoitteelle.',
    'ipaddress__cannot_set_up_public_ip_need_ipv4' => 'Yleistä IPv6-osoitetta ei voida asettaa IPv4-osoitteelle.',
    'ipaddress__cannot_set_up_public_ip_invalid' => 'Julkista IP-osoitetta ei voida asettaa: julkisen IP-osoitteen on oltava olemassa.',

    '__user_already_exists' => "Käyttäjä %1 on jo olemassa.",
    '__user_name_is_empty' => "Määritä käyttäjänimi.",

    'upgrade_php_on_domain' => 'PHP-versiota 5.3.0 tai sitä uudempaa versiota ei löydy WordPress-toimialueiltasi. Kokeile PHP:n päivittämistä.',

    'component_name__waf' => 'Verkkosovelluksen palomuuri',
    'component_name__vcs' => 'Version hallintajärjestelmä',

    'virtualization_lxc' => 'LXC',
    'virtualization_docker' => 'Docker',
    'possibleSpoofingDetected' => 'Mahdollinen osoitehuijausyritys havaittiin: linkki yritti näyttää asiaankuulumatonta sisältöä.',
    'forceResetPasswordUpdated' => 'Salasanasi on vaihdettu. Käytä uutta salasanaa Plesk-kirjautumiseen.',

    'php_handlers_error_no_available_instance' => 'Toimialuetta ei voida luoda: PHP-käsittelijöitä ei ole saatavilla.',
    'domain_error_unable_to_apply_hosting_settings' => 'Isännöintiasetuksia ei voi käyttää: %1',

    'plesk_not_configured' => 'Pleskiä ei ole määritetty. Pleskiä ei ole määritetty.Määritä jälkiasennus ohjauspaneelissa.',
    'cmd_mail__mail_password_duplicated' => 'Syötetty sähköpostiosoitteen ja salasanan yhdistelmä on jo olemassa sähköpostipalvelimessa. Syötä toinen sähköpostiosoite tai salasana.',

    'extensionRequirementOs' => 'Paketti ei tue käyttöjärjestelmää (%1).',
    'extensionRequirementPleskMinVersion' => 'Plesk %1 on vanhin versio, jota paketti tukee.',
    'extensionRequirementPleskMaxVersion' => 'Paketti ei tue versioita Plesk %1 -versiosta alkaen.',
    'extensionBlacklisted' => 'Tunnistetta %1 ei sallita asennuksessa.',
    'extensionDisabled' => 'Laajennus poistetaan käytöstä.',


    'optimization_settings__unable_set_mpm_event' => 'mpm_event -tilaa ei voida asettaa: se edellyttää, että Apache PHP5 -moduuli poistetaan käytöstä, mutta kyseinen moduuli on toimialueiden käytössä.',
    'optimization_settings__unable_turn_off_php' => 'Apache PHP5 -moduulin käytöstä poistaminen ei onnistu: se on toimialueiden käytössä.',

    'hst_def__fp_admin_login' =>  'FTP-käyttäjänimi',
    'hst_def__fp_admin_passwd' =>  'FTP-salasana',

    'database_user_orphaned_old_password_wrong' => "Yhteydetöntä käyttäjää ei voida korjata '%1': salasana on virheellinen.",
    'cannot_load_partner_central_property_key_no_exist' => "Mukautettuja ominaisuuksia ei voida palauttaa: käyttöoikeusavainta ei ole olemassa.",
    'extensionScriptFailure' => "%1:n suoritus epäonnistui seuraavalla viestillä:\n%3",
    '__ssl_redirect' => "Pysyvä SEO-safe 301 ohjattu uudelleen kohteesta HTTP kohteeseen HTTPS",
    'component_name__dotnetcore' => '.NET Core',
    'mail__dkim_not_supported' => 'DKIM-hallintaa ei tueta.',
    'mail__dmarc_not_supported' => 'DMARC-hallintaa ei tueta.',
    'mail__relay_white_list_not_supported' => 'Välityksen sallittujen luettelon hallintaa ei tueta.',
    'mail__black_list_not_supported' => 'Estettyjen luettelon hallintaa ei tueta.',
    'mail__autoresponder_not_supported' => 'Automaattisen vastaajan hallintaa ei tueta.',
    'defaultcomponents__not_supported_version' => '(versiota ei tueta)',
    'component_name__nodejs' => 'Node.js',

    'certificate__not_found' => 'Varmennetta \'%1\' ei löytynyt.',
    'certificate__unable_setup_certificate' => 'Varmenteen asennus ei onnistu: yksityinen avain ja varmenteen sisältö puuttuvat.',
    'certificate__used_by_panel' => 'Yhtä varmenteista, jota olet poistamassa, käytetään Pleskin suojaamiseen.',
    'certificate__used_by_mail_server' => 'Yhtä varmenteista, jota olet poistamassa, käytetään sähköpostipalvelimen suojaamiseen.',
    'certificate__used_by_domain_service' => 'Yhtä varmenteista, jota olet poistamassa, on toimialueen palvelun käytössä.',
    'mail_server__not_installed' => 'Sähköpostipalvelimen varmennetta ei voida asentaa, koska sähköpostipalvelinta ei ole asennettu.',

    'email_activation_mail_subject' => 'Aktivoi tilisi Pleskissä',
    'email_activation_mail_body' => "Tili luotiin Plesk-palvelimeen %1 \n\nTilitiedot: \nNimi: %2 \nSähköpostiosoite: %3 \n\nJos nämä tiedot ovat virheettömiä ja tili luotiin sinulle, aktivoi se seuraavan linkin avulla: \n\n%4 \n\nAktivoimalla tilin annat osana sopimusta palvelimen haltijalle luvan kerätä, tallentaa, käsitellä ja käyttää henkilötietojasi (nimi ja sähköpostiosoite) tilisi luomiseksi ja tukemiseksi voimassa olevien tietosuojalakien mukaisesti.",

    'backup_transport_permission_name' => '%1:n hallinta',
    'backup_transport_permission_description' => 'Mahdollistaa %1 käyttämisen varmuuskopioiden tallentamiseen.',

    'domain_move_err_target_no_hosting' => 'Toimialuetta ei voida siirtää tilaukseen ilman isännöintiä.',
    'domain_move_err_already_in_target' => 'Toimialue kuuluu jo kohdetilaukseen.',
    'domain_move_err_main_domain' => 'Päätoimialuetta ei voida siirtää.',
    'domain_move_err_subdomain_without_parent' => 'Alitoimialuetta %1 ei voida siirtää ilman päätoimialuetta %2.',
    'domain_move_err_root_exists' => 'Kohteen www_root %1 kohdepolku on jo olemassa.',
    'domain_move_err_nested_roots' => 'Toimialuetta ei voida siirtää, koska se jakaa asiakirjan juuren toisen toimialueen kanssa: %1.',
    'domain_move_err_no_mail_service' => 'Toimialuetta ei voida siirtää, koska sähköpostipalvelu on poistettu käytöstä kohdetilauksessa.',
    'domain_move_err_app' => "Kohteeseen %1 asennettua sovellusta ei siirretty tilaukseen '%2': %3",
    'domain_move_database_used_by_app' => "Siirretty sovellus käyttää tietokantaa '%1' kohteessa %2. Määritä tietokanta uudelleen kohteeseen '%3', suorita `plesk bin database --assign-to-subscription`",
    'domain_move_target_locked' => "Kohdetilaus '%1' lukittiin synkronointia varten.",
    'domain_move_filesharing_disabled' => 'Tiedostojen jako poistettiin käytöstä.',
    'domain_move_website_preview_disabled' => 'Verkkosivuston esikatselu poistettiin käytöstä.',
    'domain_move_additional_webserver_settings' => "Tarkista toimialueen verkkopalvelimen lisädirektiivit viallisten määritysten välttämiseksi.",
    'domain_move_no_permission' => "%1 ei sallita tilauksessa '%2'.",
    'domain_move_no_access' => "Ei tilauksen '%1\\’ käyttöoikeutta.",
    'domain_split_no_create_permission' => "Toimialueen luontia ei sallita.",
    'domain_split_empty_login' => 'Järjestelmäkäyttäjän sisäänkirjautuminen on pakollinen.',
    'domain_split_empty_password' => 'Järjestelmäkäyttäjän salasana on pakollinen.',
    'domain_split_err_home_exists' => 'Toimialuetta %1 ei voida siirtää, koska sen kotisivun kohdepolku on jo olemassa kohteessa %2. Nimeä toimialue uudelleen sen siirtämiseksi uuteen tilaukseen.',
    'domain_split_err_no_hosting_subdomains' => 'Toimialuetta ei voida siirtää uuteen tilaukseen, koska toimialueessa ei ole isännöintiä, vaan alitoimialueita. Siirrä toimialue muuttamalla sen "Isännöintityyppi" arvoksi "Verkkosivuston isännöinti" (isännöintiasetuksissa).',
    'domain_split_target_locked' => "Kohdetilaus '%1' on lukittu synkronointia varten.",
    'domain_split_target_unsynced' => "Kohdetilausta '%1' ei synkronoitu suunnitelmaan seuraavasta syystä: %2.",
    'domain_merge_scheduled_backup_deactivated' => "Ajoitettu varmuuskopiointi kytkettiin pois päältä '%1'.",
    'domain_merge_database_error' => "Tietokantaa '%1' kohteessa %2 ei siirretty tilaukseen '%3': %4",
    'domain_merge_anon_ftp_deactivated' => "Nimetön FTP kohteessa '%1' poistettiin käytöstä.",
    'domain_merge_smb_user_access' => "Lisäkäyttäjä '%1' siirrettiin tilaukseen '%2', mutta käyttäjän tilauksen käyttöoikeus mitätöitiin.",
    'domain_merge_scheduled_tasks' => "Ajoitetut tehtävät siirrettiin kohdetilaukseen. Tarkista tehtävien määritykset.",
    'domain_merge_scheduled_tasks_deactivated' => "Ajoitetut tehtävät siirrettiin kohdetilaukseen ja kytkettiin pois käytöstä. Tarkista tehtävien määritykset.",
    'domain_merge_no_remove_permission' => "Tilauksien poistoa ei sallita.",
    'domain_merge_err_has_addons' => 'Päätoimialuetta ei voida siirtää sen ylimääräisillä toimialueilla; siirrä ensin toimialue(et) %1.',
    'domain_merge_err_has_webusers' => 'Päätoimialuetta ei voida siirtää sen verkkokäyttäjillä.',
    'domain_merge_err_root_exists' => 'Kohdepolku %1 on jo olemassa.',

    'database_server_edit_used_for_psa' => 'Muun kuin paikallisen MySQL-tietokantapalvelimen käyttö ei ole sallittua.',
    'suggest_repair_main_suggestion_ui' => '<b>Voit korjata tämän virheen</b> käyttämällä ”plesk repair”-apuohjelmaa.',
    'suggest_repair_main_suggestion_cli' =>  'Voit korjata tämän virheen ”plesk repair”-apuohjelmalla.',
    'suggest_repair_repair_kit_link_title' => 'tai siirtymällä kohtaan Diagnose & Repair',
    'suggest_repair_using_cli_and_ui' => 'Tehdäksesi sen aja ”plesk repair %1”-komento CLI:ssä tai kohteessa %2, ja napsauta Repair kohdan ”Plesk Database” vieressä.',
    'suggest_repair_using_cli' => 'Tehdäksesi sen aja ”plesk repair %1”-komento CLI:ssä',

    'backup__restore__capability_duplicate_php_handler_resolution' => '',
    'bu_conflict_resolver_dns_not_available' => 'DNS-palvelu ei ollut käytettävissä, kun varmuuskopio luotiin. Varmuuskopiossa on kuitenkin aktiivisia DNS-alueita, ja ne otetaan seuraavien objektien käyttöön: {{objects}}',
    'plesk_key__system-resources-limits-enabled' => 'Resurssinhallinta (Cgroups)',
    'plesk_key__remote-smartermail-enabled' => 'Etä-SmarterMail-tuki',
    'plesk_key__complete-backup-solution' => 'Cloud Pro:n varmuuskopio',
    'defaultcomponents__no_license' => '(lisenssiavain ei salli tätä)',
    'plesk_key__validation_failed' => '%1 (Virhekoodi: %2)',
    'promo__button_details' => 'Tiedot',
    'promo__extension_catalog_title' => 'Laajennuskatalogi',
    'promo__extension_catalog_description' => 'Tutustu uusiin laajennuksiin ja tehosta Pleskiä erilaisilla tehokkailla laajennuksilla!',
    'promo__button_open_catalog' => 'Avaa katalogi',

    'backup__repository_check_login' => "Tallennustilaan ei pääse: %1 Varmista, että olet syöttänyt oikeat kirjautumistiedot.",
    'backup__repository_check_error_list' => "Tallennustilaa ei voida käyttää: %1 Varmista, että olet syöttänyt tallennustilalle oikeat tallennusasetukset.",
    'backup__repository_check_error_mkdir' => "Hakemistoa ei voida luoda: %1 Tarkasta, onko sinulla oikeuksia luoda kansioita tallennustilaan.",
    'backup__repository_check_error_upload' => "Tiedosta ei voida lähettää tallennustilaan: %1 Tarkasta, onko sinulla lupaa lähettää tiedostoja tallennustilaan.",
    'backup__repository_check_error_download' => "Tiedostoa ei voida ladata tallennustilasta: %1 Tarkasta, onko sinulla lupaa lähettää ja ladata tiedostoja tallennustilasta.",
    'backup__repository_check_error_resume-upload' => "Tiedoston lähetystä ei voida palauttaa tallennustilaan: %1 Tarkasta, onko sinulla lupaa palauttaa lähetyksiä tallennustilaan.",
    'backup__repository_check_error_resume-download' => "Tiedostoa ei voida palauttaa tallennustilasta: %1 Tarkasta, onko sinulla lupaa palauttaa latauksia tallennustilasta.",
    'backup__repository_check_error_enable-utf8' => "Tallennustilaa ei voida käyttää: %1 Tarkasta, tukeeko tallennustila UTF8-koodausta.",
    'backup__repository_check_error_rm' => "Tallennustilan käyttäminen ei onnistu: %1 Tarkasta, onko sinulla lupaa poistaa tiedostoja tallennustilasta.",
    'backup__repository_check_error_rmdir' => "Tallennustilan käyttäminen ei onnistu: %1 Tarkasta, onko sinulla lupaa poistaa kansioita tallennustilasta.",

    'backup__ftp_repository_check_login' => "%1 Voit tarkastaa ne itsenäisesti komennolla: %2",
    'backup__ftp_repository_check_error_list' => "%1 Voit tarkastaa ne itsenäisesti komennolla: %2",
    'backup__ftp_repository_check_error_mkdir' => "%1 Voit tarkastaa sen itsenäisesti komennolla: %2",
    'backup__ftp_repository_check_error_upload' => "%1 Voit tarkastaa sen itsenäisesti komennoilla: %2 %3",
    'backup__ftp_repository_check_error_download' => "%1 Voit tarkastaa sen itsenäisesti komennoilla: %2 %3",
    'backup__ftp_repository_check_error_resume-upload' => "%1 Voit tarkastaa sen itsenäisesti komennoilla: %2 %3 %4",
    'backup__ftp_repository_check_error_resume-download' => "%1 Voit tarkastaa sen itsenäisesti komennoilla: %2 %3",
    'backup__ftp_repository_check_error_enable-utf8' => "%1 Voit tarkastaa sen itsenäisesti komennolla: %2",
    'backup__ftp_repository_check_error_rm' => "%1 Voit tarkastaa sen itsenäisesti komennoilla: %2 %3",
    'backup__ftp_repository_check_error_rmdir' => "%1 Voit tarkastaa sen itsenäisesti komennoilla: %2 %3",

    'sfdmarc_server_wide_enable_failed' => 'DMARC-asetuksia ei voida muuttaa. Ota tämä toiminto käyttöön käynnistämällä DKIM- ja SPF-roskapostisuojaus.',
    'spf_server_wide_disable_failed' => 'SPF-roskapostisuojauksen asetuksia ei voida muuttaa. Poista SPF käytöstä sammuttamalla saapuvan postin DMARC.',
    'sfdk_server_wide_verify_disable_failed' => 'DKIM-roskapostisuojauksen asetuksia ei voida muuttaa. Poista DKIM käytöstä sammuttamalla saapuvan postin DMARC.',

    'ccs_not_supported' => 'IIS Central Certificate Storea ei ole määritelty järjestelmässä.',
    'ccs_not_enabled' => 'IIS Central Certificate Store -hallinta ei ole käytössä Pleskissä.',
    'ad_not_supported' => 'Palvelinta ei ole liitetty toimialueeseen',

    'component_name__appinit' => "Sovelluksen alustaminen",
    'component_name__httpcompression' => 'HTTP-sisällön pakkaaminen',
    'common_feature_is_not_supported' => 'Tätä ominaisuutta ei enää tueta.',
    'common_feature_is_not_supported_in_proto' => 'Tätä ominaisuutta ei tueta protokollaversiossa %1.',
    'autoinstaller__plesk_component' => 'Pleskin komponentti',
    'plesk_key__key_expired' => 'Käyttöoikeusavaimesi on vanhentunut. Jotta voit jatkaa Pleskin käyttöä, sinun on ostettava vanhentumaton kaupallinen %1.',
    'plesk_key__key_purchase' => 'käyttöoikeusavain',

    'sa_action_move' => 'Siirrä roskaposti roskapostikansioon',

    'bu_conflict_resolver_tomcat_not_supported' => 'Java-sovelluksia ei enää tueta. Ne eivät ole käytössä seuraavilla verkkosivustoilla: {{objects}}',
    'bu_conflict_resolver_unity_mobile_not_supported' => 'UNITY Mobilella ylläpidettyjä verkkosivustojen mobiiliversioita ei enää tueta. Ne eivät ole käytössä seuraavilla verkkosivustoilla: {{objects}}',
    'bu_conflict_resolver_antivirus_personal_management_not_allowed' => 'Palvelimenlaajuinen käyttökäytäntö ei salli henkilökohtaisten antivirusasetusten käyttöä. Ne palautetaan epätäydellisesti seuraavien toimialueiden sähköpostitileistä: {{objects}}',

    'module__not_installed' => "%1-laajennusta ei ole asennettu",

    'mail__mail_autodiscovery_server_error' => 'Määritä sähköpostien automaattiselle haulle mukautettu toimialueen nimi',
    'mail__error_mail_autodiscovery_enable' => 'Automaattista hakua ei voida asettaa: %1',
    'mail__error_mail_autodiscovery_server' => 'Automaattista mukautettujen verkkotunnusten hakua ei voida asettaa: %1',
    'mail__error_mail_autodiscovery_reconfigure_dns' => 'Toimialueen automaattista DNS-tietueiden hakua ei voida määritellä uudelleen: %1',

    '__invalid_url' => 'URL ”%1” on virheellinen.',
    'actionlog__cloning_start' => 'käynnistä',
    'actionlog__event_cloning_start' => 'Palvelimen kloonauksen käynnistyminen',

    '__UPLOAD_ERR_FORM_SIZE' => "Ladattu tiedosto ylittää sallitun koon",
    '__UPLOAD_ERR_INI_SIZE' => "Ladattu tiedosto ylittää sallitun koon",
    '__UPLOAD_ERR_NO_FILE' => "Tiedostoja ei vastaanotettu",
    '__UPLOAD_ERR_OK' => "Tiedoston lataus onnistui",
    '__UPLOAD_ERR_PARTIAL' => "Tiedosto ladattiin osittain, yritä uudelleen",
    '__UPLOAD_ERR_NO_TMP_DIR' => 'Tilapäiskansio puuttuu',
    '__UPLOAD_ERR_CANT_WRITE' => 'Tiedoston kirjoitus levyyn epäonnistui',
    '__UPLOAD_ERR_UNKNOWN' => 'Tiedoston latauksessa tapahtui tuntematon virhe',
    '__accounts' => "Tilit",
    '__access' => "Käyttö",
    '__address' => "Osoite",
    '__addresses' => "Osoitteet",
    '__acl_records' => 'ACL-tietueet',
    '__admin_repository' => "Järjestelmänvalvojan säilö",
    '__all' => 'Kaikki',
    '__allowed' => "Sallittu",
    '__anonftp_status' => "Julkinen FTP",
    '__antispam' => "AntiSpam",
    '__apache_restart' => "...%1 -verkkopalvelinta käynnistetään uudelleen, ole hyvä ja odota...",
    '__asp' => "Microsoft ASP",
    '__asp_dot_net' => "Microsoft ASP.NET",
    '__asp_dot_net_support' => "Microsoft ASP.NET -tuki",
    '__asp_win_support' => "Microsoft ASP -tuki",
    '__attachments' => "Liitteet",
    '__attachments_list' => "Liitteet",
    '__author' => 'Tekijä',
    '__autoresp_name_already_exists' => "Automaattinen vastaus, jonka nimi on %1, on jo olemassa.",
    '__autoresponder' => "Automaattinen vastaus",
    '__autoresponders' => "Automaattiset vastaukset",
    '__autoresponders_list' => "Automaattiset vastaukset",
    '__autoresponder_attachment_files' => "Automaattisen vastauksen liitetiedostot",
    '__auto_updates_list' => 'Saatavissa olevat päivitykset',
    '__avail' => "Käytettävissä",
    '__backup_utilites' => "Varmuuskopioinnin apuohjelmat",
    '__bind_status' => "DNS-palvelimen tila",
    '__bu_is_not_installed' => "Tämä palvelu ei ole tällä hetkellä käytettävissä, koska varmuuskopioinnin apuohjelmia ei ole asennettu.",
    '__bu_not_support_in_key' => "Käyttöoikeusavain ei tue varmuuskopiointiominaisuutta.",
    '__notifications_not_support_in_key' => 'Käyttöoikeusavain ei tue ilmoituksia',
    'disabled_by_key' => 'Ei käyttöoikeusavaimen tukema',
    '__bytes' => "tavua",
    '__can_not_use_reserved_words' => "Varattuja sanoja ei voi käyttää.",
    '__certificate' => "Varmenne",
    '__cgi_support' => "CGI-tuki",
    '__change_date' => "Muokkauspäivämäärä",
    '__city' => "Kaupunki",
    '__cl_not_exist' => "Asiakastiliä ei ole.",
    '__client' => 'Asiakas',
    '__client_card' => "Asiakaskortti",
    '__client_contact_name' => "Asiakkaan yhteystiedon nimi",
    '__client_form' => "Henkilökohtaiset tiedot",
    '__client_ip_pool' => "Asiakkaan IP-ryhmä",
    '__client_limits' => "Asiakastilin rajat",
    '__client_permissions' => "Asiakkaan oikeudet",
    '__client_preferences' => "Asiakkaan määritykset",
    '__client_status' => "Asiakkaan tila",
    '__client_name' => "Asiakkaan nimi",
    '__client_total' => "Asiakas yhteensä",
    '__client_with_login_name_already_exists' => "Käyttäjä, jonka nimi on \"%1\", on jo olemassa.",
    '__client_domuser_with_login_already_exists' => "Käyttäjätunnus '%1' on jo järjestelmänvalvojan toimialueen '%1' käytössä.",
    '__clients_global_changes' => "Muokkaa valittuja asiakastilejä",
    '__clients_list' => "Asiakkaat",
    '__cmd_not_found' => "Tuntematon komento: %1",
    '__comments' => "Kommentit",
    '__company_name' => "Yrityksen nimi",
    '__component_version' => "Osaversio",
    '__component_not_installed' => "Osaa %1 ei ole asennettu",
    '__confirm_del' => "Sinun täytyy vahvistaa poisto.",
    '__confirm_overwrite' => "Vahvista korvaaminen.",
    '__confirm_stop' => "Vahvista prosessin pysäytys.",
    '__confirm_passwd' => "Vahvista %1 salasana",
    '__confirm_removal' => "Vahvista poisto",
    '__conhelp' => "Kuvaus",
    '__contact_name' => "Yhteyshenkilön nimi",
    '__country' => "Maa",
    '__countries' => 'Maa',
    '__country_unknown' => 'Maan alikoodia ei tunnistettu.',
    '__courier-imap' => 'Kuriirin palvelin',
    '__create_domain' => 'Luo arvoalue',
    '__crypted' => 'salattu',
    '__cp_access' => "Pleskin käyttöoikeus",
    '__cp_user' => "Plesk-käyttäjä",
    '__create' => "Luo",
    '__create_client_template_without_template' => "Luo käyttäjätili ilman mallia",
    '__create_domain_for' => "Luo toimialue kohteelle <b />%1</b>",
    '__create_domain_template_without_template' => "Luo toimialue ilman mallia",
    '__creation_date' => "Luontipäivä",
    '__crontab_unix' => "Ajoitustoiminto",
    '__crontab_win' => "Ajoitustoiminto",
    '__ct_month_jan' => 'Tammikuu',
    '__ct_month_feb' => 'Helmikuu',
    '__ct_month_mar' => 'Maaliskuu',
    '__ct_month_apr' => 'Huhti',
    '__ct_month_may' => 'Tou',
    '__ct_month_jun' => 'Kesäkuu',
    '__ct_month_jul' => 'Heinäkuu',
    '__ct_month_aug' => 'Elokuu',
    '__ct_month_sep' => 'Syyskuu',
    '__ct_month_oct' => 'Lokakuu',
    '__ct_month_nov' => 'Marraskuu',
    '__ct_month_dec' => 'Joulukuu',
    '__custom_button' => "Mukautettu painike",
    '__custom_buttons_list' => "Linkit lisäpalveluihin",
    '__daily' => "Päivittäin",
    '__database_not_activated' => "Kohdetta %1 ei aktivoitu palvelimen hallintasivulla.",
    '__database_not_installed' => "Tietokantaa %1 ei ole asennettu.",
    '__database_not_run' => "Tietokanta %1 ei ole käynnissä.",
    '__database_is_corrupt' => "Pleskin tietokanta on vahingoittunut. Käynnistä Reconfigurator-apuohjelma sen korjaamiseksi.",
    '__databases' => "Tietokannat",
    '__databases_list' => "Tietokannat",
    '__database_type_not_supported_by_key' => 'Palvelimen %1 käyttö edellyttää, että käyttöoikeusavaimesi tukee sitä. Ota yhteyttä Pleskin myyntipalveluun.',
    '__date_immediately' => "tänään",
    '__date_never' => "ei koskaan",
    '__day(s)' => "Päivä(ä)",
    '__day0' => "Su",
    '__day1' => "Ma",
    '__day2' => "Ti",
    '__day3' => "Ke",
    '__day4' => "To",
    '__day5' => "Pe",
    '__day6' => "La",
    '__days' => "%1 päivä(ä)",
    '__db_admin_login_empty' => "Käyttäjänimeä ei ole annettu. Kohteen %1 ohjaus poistetaan käytöstä liittymässä. Haluatko jatkaa?",
    '__db_unable_to_unregister' => 'Tietokannan yhteyden parametreja ei voida poistaa',
    '__db_db_exists' => 'Palvelimella on vähintään yksi tietokanta',
    '__db_unable_to_change_server_name' => 'Palvelimen nimeä ei voida muuttaa',
    '__db_unable_to_change_port' => 'Palvelimen porttia ei voida muuttaa',
    '__db_already_exist' => "Tietokanta %1 on jo olemassa.",
    '__db_credentials_invalid' => "Tietokannan tunnukset ovat virheelliset.",
    '__db_invalid_password_characters' => 'Salasanassa on kelvottomia merkkejä',
    '__db_engine' => "Tietokantamoduuli", // indirect
    '__db_type' => "Tietokannan laji",
    '__db_user' => "Tietokannan käyttäjä",
    '__db_server' => 'Tietokantapalvelin',
    '__def_domain' => "Oletustoimialue",
    '__default_for_mysql' => 'oletus MySQL:lle',
    '__default_for_mariadb' => 'MariaDB:n oletus',
    '__default_for_percona' => 'Perconan oletus',
    '__default_for_postgresql' => 'PostgreSQL:n oletus',
    '__delete' => "Poista",
    '__demo' => "Tämä toiminto ei ole käytettävissä esittelyversiossa.",
    '__directory' => "Hakemisto",
    '__disable_lock_screen' => 'Estä käyttäjien työskentely Pleskilla, kunnes liittymän näytöt on ladattu kokonaan',
    '__dismiss_news?' => "Haluatko varmasti sulkea uutisosion kokonaan?\n\nEt näe uutisosiota ennen kuin lisää uutisia on saatavilla.",
    '__description' => "Kuvaus",
    '__disabled' => "sammutettu",
    '__disk_space_limit' => "Levytilarajoitus",
    '__cgroups_cpu_usage_limit' => 'CPU-käyttöraja',
    '__cgroups_ram_usage_limit' => 'RAM-käyttöraja',
    '__cgroups_disk_read_usage_limit' => 'Levyn lukutoiminnon kaistanleveyden raja',
    '__cgroups_disk_write_usage_limit' => 'Levyn kirjoitustoiminnon kaistanleveyden raja',
    '__disk_usage_by' => "Kohteen %1 käyttämä levytila",
    '__dns' => "DNS",
    '__dns_record_already_exist' => "DNS-tietue '%1' on jo luotu.",
    '__dns_master_should_be_remote' => "Sinulla tulee olla kaksi erillistä määräävää nimipalvelinta erillisissä isännissä.",
    '__dns_record_not_exist' => "DNS-tietuetta ei ole.",
    '__dns_server' => "DNS-palvelin", // indirect
    '__dom_id_is_undefined' => "Toimialueen tunnusta ei ole määritetty.",
    '__dom_name' => "Toimialueen nimi",
    '__dom_name_is_invalid' => "Toimialueen nimi on virheellinen. Varmista, että toimialueen nimi sisältää vain aakkosnumeerisia merkkejä, pisteitä ja viivoja, eikä sen pituus ylitä 255 merkkiä. Missään toimialueen nimen pisteillä erotetussa osassa ei saa olla yli 63 merkkiä.",
    '__dom_not_exist' => "Toimialuetta ei ole.",
    '__domain' => "Toimialue",
    '__domain_' => 'Toimialue %1',
    '__domain_form' => "Toimialuelomake",
    '__domain_id' => "Toimialueen Tunnus",
    '__domain_is_turned_off_for_backup' => "Verkkosivusto %1 on poistettu väliaikaisesti käytöstä varmuuskopiointia tai palautusta varten ja se ei ole tällä hetkellä saatavilla.",
    '__domain_limits' => "Toimialueen rajat",
    '__domain_name' => "Toimialueen nimi",
    '__mail_name_in_ASCII_form' => "Sähköpostitilin nimi ASCII-muodossa",
    '__message_error' => 'Virhe',
    '__message_warning' => 'Varoitus',
    '__message_info' => 'Tiedot',
    '__domain_name_in_ASCII_form' => "Toimialueen nimi ASCII-muodossa",
    '__domain_repository' => "Toimialueen %1 säilö",
    '__domain_status' => "Toimialueen tila",
    '__domain_dns' => 'Toimialueen DNS-vyöhyke',
    '__domain_total' => "Tilauksen kokonaismäärä",
    '__domain_total_powerUser' => "Tilauksen kokonaismäärä",
    '__domain_user' => "Toimialueen järjestelmänvalvoja",
    '__domains_global_changes' => "Muokkaa valittuja toimialueita",
    '__mailnames_global_changes' => "Muokkaa valittuja sähköpostitilejä",
    '__backup_manager' => 'Varmuuskopioinnin hallinta',
    '__domains_list' => "Toimialueet",
    'domains_list__list_header' => "toimialueet", //this is a part of phrases like No domains (and others), so it should not be capitalized
    '__double_www_warning' => "Toimialueen nimi alkaa www-tunnuksella, vaikka WWW-etuliitettä on käytetty.\nHaluatko silti jatkaa?",
    '__dovecot' => 'Dovecot IMAP ja POP3 -palvelin',
    '__dsmail' => "Postipalvelu",
    '__dsmaillist' => "Postitusluettelon hallinta",
    '__dsr_db' => "DB",
    '__dsr_dname' => "Toimialueen nimi",
    '__dsr_du' => "DU",
    '__dsr_ma' => "MA",
    '__dsr_mg' => "MF",
    '__dsr_ml' => "ML",
    '__dsr_mn' => "MBox",
    '__dsr_pname' => "Asiakkaan nimi",
    '__dsr_sd' => "SD",
    '__dsr_tr' => "TR",
    '__dsr_wu' => "WU",
    '__dumps_tot_size' => "Paikallisessa säilytystilassa olevien varmuuskopiotiedostojen koko yhteensä",
    '__email' => "Sähköposti",
    '__email_addr_is_invalid' => "Sähköpostiosoite ei kelpaa.",
    '__enabled' => "otettu käyttöön",
    '__enter_cert_text' => "Kirjoita varmenneteksti",
    '__enter_size' => "Anna koko",
    '__exclusive' => "Omistettu",
    '__expiration_date' => "Vanhentumispäivä",
    '__fax' => "Faksi",
    '__file' => "Tiedosto",
    '__file_is_empty' => "Tiedosto on tyhjä.",
    '__file_name' => "Tiedoston nimi",
    '__file_type' => 'Tiedoston tyyppi',
    '__filemanager' => "Tiedostonhallinta",
    '__filepath_is_empty' => "Tiedoston polku on tyhjä",
    '__files_list' => "Tiedostot",
    '__frontpage' => "Microsoft FrontPage",
    '__ftp' => "FTP", // +indirect
    '__ftp_settings' => "FTP-asetukset",
    '__ftp_serv' => "FTP-palvelin", // indirect
    '__ftp_server_parameters_are_empty' => "FTP-tilin ominaisuudet on asetettava ensin!",
    '__ftp_status' => "FTP-palvelimen tila",
    '__full_day0' => "Sunnuntai",
    '__full_day1' => "Maanantai",
    '__full_day2' => "Tiistai",
    '__full_day3' => "Keskiviikko",
    '__full_day4' => "Torstai",
    '__full_day5' => "Perjantai",
    '__full_day6' => "Lauantai",
    '__full_month1' => "Tammikuu",
    '__full_month10' => "Lokakuu",
    '__full_month11' => "Marraskuu",
    '__full_month12' => "Joulukuu",
    '__full_month2' => "Helmikuu",
    '__full_month3' => "Maaliskuu",
    '__full_month4' => "Huhti",
    '__full_month5' => "Tou",
    '__full_month6' => "Kesäkuu",
    '__full_month7' => "Heinäkuu",
    '__full_month8' => "Elokuu",
    '__full_month9' => "Syyskuu",
    '__giga' => "G",
    '__group' => "Ryhmä",
    '__h' => "H",
    '__hard_disk_quota' => "Kiintolevykiintiö",
    '__hard_disk_quota_not_supported' => 'kiintolevykiintiötä ei tueta palvelimen tiedostojärjestelmän määrityksen vuoksi',
    '__header_text_is_invalid' => "Suojatun alueen otsikko on virheellinen.",
    '__help_topic_not_found' => 'Pyytämääsi ohjeaihetta (%1) ei ole.',
    '__hosting' => "Isännöinti",
    '__hosting_ip_dns_ip_not_equiv' => "Mikään A DNS -tietueissa määritetyistä IP-osoitteista ei vastaa isännöinnissä käytettyä IP-osoitetta.",
    '__hosting_scripting' => "Isännöintitilauksen tuki",
    '__hosting_setup_page_title' => "Verkkosivuston isännöinnin määritys toimialueelle %1",
    '__hosting_title' => "Isännöinti (%1)",
    '__hosting_type' => "Isännöintityyppi",
    '__hostname' => "Isäntänimi",
    '__hostname_is_empty' => "Isäntänimi on tyhjä.",
    '__hour(s)' => 'Tunti(a)',
    '__hst_type_incorrect' => "Isännöintityyppi on väärä.",
    '__http' => "HTTP", //indirect
    '__htype' => "H",
    '__idle_time' => "Joutoaika",
    '__iface' => "Liittymä",
    '__image' => "Kuva",
    '__imap_status' => "IMAP-palvelimen tila",
    '__in' => "Ajassa",
    '__in_%' => "kohteessa %",
    '__incorrect_databases_login_pass' => "Tunnistetiedot, jotka määritit PostgreSQL:n käyttöä varten, ovat virheelliset.",
    '__incorrect_ip_or_network_address' => 'Virheellinen IP-osoite tai verkko.',
    '__info' => 'Tiedot',
    '__install' => "Asenna",
    '__install_prefix' => "Asenna etuliite",
    '__invalid_cert_id' => "Virheellinen varmenteen tunnus",
    '__invalid_context' => "Virheellinen konteksti: %1",
    '__invalid_db_usr_name' => "Tietokannan käyttäjänimi ei kelpaa.",
    '__invalid_dir_name' => "Hakemiston nimi on virheellinen",
    '__invalid_dom_name' => "Toimialueen nimi on virheellinen.",
    '__invalid_filename' => "Virheellinen tiedostonimi. Älä käytä heittomerkkejä tai/ja \"../\" -yhdistelmää.",
    '__invalid_id' => "Virheellinen tunnus.",
    '__invalid_lines_num' => "Virheellinen arvo useissa riveissä, vain numerot sallitaan.",
    '__invalid_max_letter_size' => "Viestin enimmäiskoko on virheellinen.",
    '__invalid_pdir_name' => "Suojatun hakemiston nimi ei kelpaa.",
    '__invalid_restart_apache_interval' => "Apachen uudelleenkäynnistysväli on virheellinen.",
    '__invalid_tmpl_name' => "Mallin nimi on virheellinen.",
    '__invalid_value' => "Virheellinen arvo.",
    '__ip_addr' => "IP-osoite",
    '__ip_address_and_mask' => "IP-osoite ja aliverkon peite",
    '__ip_alias__mask' => "IP-osoite ja aliverkon peite",
    '__ip_addr_form' => "IP-osoitelomake",
    '__ip_addr_is_invalid' => "IP-osoite on virheellinen.",
    '__ip_addr_list' => "IP-osoitteet",
    '__ip_address_does_not_exist' => "IP-osoitetta ei ole.",
    '__ip_addresses' => "IP-osoitteet",
    '__ip_address_and_mask_hint' => 'Esimerkiksi, %1',
    '__is_owner' => "O",
    '__java_engine' => "Java", // indirect
    '__jdk' => "JDK",
    '__kb' => "KT",
    '__kbps' => "kt/s",
    '__kbytes' => "kilotavua",
    '__key_for_virtuozzo_only' => "Käyttöoikeusavaimesi on tarkoitettu käytettäväksi vain Virtuozzo containers -järjestelmässä.",
    '__key_limits_exceeding' => "Tämä toiminto ylittää ohjelmiston käyttöoikeuden määrittämät rajat. Jos sait tämän viestin, voit ottaa yhteyttä palveluntarjoajaan tai valmistajaan selventääksesi tilannetta tai lisätäksesi tämän käyttöoikeuden rajoja.",
    '__kilo' => "K",
    '__keywords' => 'Avainsanat',
    '__lang_unknown' => 'Kielen tunnistaminen ei onnistu.',
    '__languages' => 'Kieli',
    '__learn_more' => 'Lisätietoja',
    '__loading' => 'Ladataan...',
    '__locales' => "Kielipaketit",
    '__lists' => "Postituslistat",
    '__literal_bytes' => "B",
    '__processing' => "Odota.<br>Tietoja ladataan...",
    '__locale' => "Käyttöliittymän kieli",
    '__locale_is_not_defined' => "Käyttöliittymän kieltä ei ole määritetty.",
    '__local_server_mysql' => 'Paikallinen MySQL-palvelin',
    '__local_server_postgresql' => 'Paikallinen PostgreSQL-palvelin',
    '__local_server_mssql' => 'Paikallinen MS SQL -palvelin',
    '__log_and_statistics_files' => 'Lokitiedostot ja tilastotietojen raportit',
    '__config_files' => 'Määritystiedostot',
    '__chroot_files' => 'Rajoitettu ympäristö',
    '__login' => "%1 kirjautuminen",
    '__login1' => "Kirjautuminen",
    '__login_disabled' => "Kirjautuminen kielletty",
    '__login_enabled' => "Kirjautuminen sallittu",
    '__login_incorrect' => "Olet antanut virheellisen käyttäjänimen tai salasanan.",
    '__login_name' => "%1 käyttäjänimi",
    '__login_name_is_invalid' => "%1 käyttäjänimi on virheellinen.",
    '__logon_time' => "Kirjautumisaika",
    '__ma' => "Sähköpostialiakset",
    '__mail' => "Sähköposti",
    '__mail_alias_name' => "Sähköpostialiasnimi",
    '__mail_autodiscovery' => 'Automaattinen haku',
    '__mail_exchanger_name_is_invalid' => "Mail Exchange Server -palvelimen nimi ei kelpaa.",
    '__mail_groups' => "Postitusryhmät",
    '__mail_list_engine' => "Postitusluettelo-ohjelmisto",
    '__mail_name' => "Sähköpostitili",
    '__mail_name_form' => "Sähköpostitilien ominaisuudet",
    '__mail_names' => "Sähköpostitilit",
    '__mail_serv' => "Postipalvelin",
    '__mail_user' => 'Sähköpostin käyttäjä',
    '__mailgroup' => "Postitusryhmä",
    '__maillist' => "Postituslista",
    '__maillists' => "Postituslistat",
    '__maillist_member' => 'Postitusluettelon jäsen',
    '__mailname' => "Sähköpostitili",
    '__mailname_redir_self' => "Sähköpostitili ei voi välittää postia itselleen.",
    '__max_dom_num_reached_for_cl' => "Tämän asiakastilin toimialueiden enimmäismäärä saavutettiin.",
    '__max_file_size_available' => "Tiedostokoon sallittu enimmäismäärä %1",
    '__max_subdom_num_reached_for_cl' => "Tämän asiakastilin toimialueiden enimmäismäärä saavutettiin.",
    '__max_subdom_num_reached_for_dom' => "Tämän toimialueen alitoimialueiden enimmäismäärä on saavutettu.",
    '__max_subdom_num_reached_for_key' => "Käyttöoikeusavaimen sallima alitoimialueiden enimmäismäärä on saavutettu.",
    '__max_traffic_limit' => "Liikenteen raja",
    '__maximum_excl_ip_num' => "Sähköpostitilit",
    '__mb' => "MT",
    '__mbytes' => "megatavua",
    '__mb_month' => "Mt/kk",
    '__mb_sec' => "Mt/s",
    '__gb_sec' => "Gt/s",
    '__tb_sec' => "Tt/s",
    '__mega' => "M",
    '__minute(s)' => 'minuutti(a)',
    '__mls_not_in_key' => "Tuoteavaimesi ei tue monikielistä käyttöliittymää.",
    '__modification_date' => "Muokkauspäivämäärä",
    '__module' => "Tunniste",
    '__month' => "Kuukausi",
    '__month(s)' => "Kuukautta",
    '__month1' => "Tam",
    '__month10' => "Lok",
    '__month11' => "Mar",
    '__month12' => "Jou",
    '__month2' => "Hel",
    '__month3' => "Maa",
    '__month4' => "Huhti",
    '__month5' => "Tou",
    '__month6' => "Kesäkuu",
    '__month7' => "Heinäkuu",
    '__month8' => "Elo",
    '__month9' => "Syys",
    '__monthly' => "Kuukausittain",
    '__months' => "Kuukautta",
    '__moved_permanently' => 'Siirretty pysyvästi',
    '__mssql' => "Microsoft SQL Server",
    '__mssql__server' => "Palvelin",
    'mssql__server' => "Microsoft SQL Server -palvelimen nimi",
    'mssql__unable_to_change_server_name_db_exists' => "palvelimen nimeä ei voida muuttaa: se sisältää vähintään yhden tietokannan.",
    '__mssql_status' => "Microsoft SQL Server -tila",
    '__multiply_login_deny' => "Kirjautuminen epäonnistui. Toinen käyttäjä, jolla on sama käyttäjänimi (%1), on jo kirjautunut Pleskiin.",
    '__mysql' => "MySQL",
    '__mysql_status' => "MySQL-palvelimen tila",
    '__mysql_version' => "Mysql-versio",
    '__mariadb' => "MariaDB",
    '__mariadb_status' => "MariaDB-palvelimen tila",
    '__mariadb_version' => "MariaDB-versio",
    '__percona' => "Percona",
    '__percona_status' => "Percona-palvelimen tila",
    '__percona_version' => "Percona-versio",
    '__name' => "Nimi",
    '__name_invalid' => "Nimi ei kelpaa.",
    '__nameserver' => "nimipalvelin",
    '__network' => "Verkko",
    '__networks' => "Verkot",
    '__no' => "Ei",
    '__no_ip_address_with_properly_type_available' => "Varmuuskopioituja tietoja ei voi palauttaa, koska palauttamiselle ei ole olemassa sopivia IP-osoitteita.",
    '__no_clients_specified' => "Asiakastilejä ei ole määritetty.",
    '__no_comments' => "Ei kommentteja.",
    '__no_ip_specified' => "IP:tä ei ole määritetty.",
    '__nologin' => "Kielletty",
    '__none' => "Ei ole",
    '__not_configured' => "Ei määritetty",
    '__not_implemented_yet' => "Ei ole vielä toteutettu",
    '__not_supported_by_ftp' => "(FTP-palvelin ei tue)",
    '__notification' => "Ilmoitus",
    '__num_displayed' => "%1/%2 näytetään",
    '__num_is_invalid' => "Numero on virheellinen.",
    '__object_not_found' => 'Objektia ei löydy: %1',
    '__of_all' => "% kaikista",
    '__off' => "Ei käytössä",
    '__ok' => "OK",
    '__old_passwd' => "Vanha %1 salasana",
    '__on' => "Päällä",
    '__others' => "Muut",
    '__other_ip__will_be_added' => 'Muut saatavilla olevat IP-osoitteet (lisätään asiakkaan IP-ryhmään)',
    '__out' => "Lähtevä",
    '__p' => "P",
    '__passwd' => "%1 salasana",
    '__passwd_is_invalid' => "%1 salasana ei kelpaa.",
    '__passwd_not_match' => "Salasanat eivät täsmää!",
    '__path' => "Polku",
    '__perl_unix_support' => "Perl-tuki",
    '__perl_win_support' => "Perl-tuki",
    '__perm_denied' => "Käyttö estetty.",
    '__permissions' => "Käyttöoikeudet",
    '__personal_name' => "Nimi",
    '__pg_admin_not_activated' => "PostgreSQL:ää ei aktivoitu palvelimen hallintasivulla.",
    '__pg_not_inst' => "PostgreSQL:ää ei asennettu.",
    '__pg_not_run_or_inst' => "PostgreSQL:ää ei asennettu tai se ei ole käynnissä.",
    '__pg_not_support_in_key' => "Käyttöoikeusavain ei tue PostgreSQL-kohdetta.",
    '__phone' => "Puhelin",
    '__phosting' => "Fyysinen isännöinti",
    '__php_support' => "PHP-tuki",
    '__php_run_as_isapi' => "suorita ISAPI-tunnisteena",
    '__php_safe_mode' => "PHP 'safe_mode' käytössä",
    '__php_version' => "PHP-versio",
    '__physical' => "Fyysinen isännöinti",
    '__plesk_stat_pdir' => "Suojaa hakemisto '/plesk-stat/webstat/'",
    '__plesk_stat_dir_name' => "Toimialuetilastot",
    '__plesk_stat_protect' => "Suojele pääsyä verkkotilastoihin käyttäjän FTP:n käyttäjänimellä ja salasanalla",
    '__plesk_stat_protect_install' => "käytettävissä salasanasuojatun hakemiston '/plesk-stat/webstat/' kautta",
    '__plesk_stat_webstat_not_activate' => "Et ole valinnut tälle verkkosivustolle verkkosivuston tilasto-ohjelmaa.",
    '__pop3_imap' => "POP3/IMAP", // indirect
    '__pop3_status' => "POP3-palvelimen tila",
    '__popen_error' => "Virhe kutsuttaessa popen-toimintoa.",
    '__port' => 'Portti',
    '__postgres' => "PostgreSQL",
    '__postgresql' => "PostgreSQL",
    '__postgresql_status' => "PostgreSQL-tila",
    '__preferences' => "Asetukset",
    '__account_preferences' => "Tilin asetukset",
    '__interface_preferences_general' => 'Yleiset',
    '__interface_preferences_default' => 'Liittymän oletusmääritykset',
    '__interface_preferences_admin' => "Järjestelmänvalvojan liittymän omat asetukset",
    '__interface_template' => 'Liittymän mukautusmalli',
    '__interface_preferences' => "Liittymämääritykset",
    '__proceed?' => "Haluatko jatkaa?",
    '__protect_dir_user' => "Suojatun hakemiston käyttäjä",
    '__protect_dir_users' => "Suojatut hakemiston käyttäjät",
    '__protect_dirs' => "Suojatut hakemistot",
    '__provider_contact_name' => "Omistajan nimi",
    '__python_unix_support' => "Python-tuki",
    '__python_win_support' => "Python-tuki",
    '__quota' => "Kiintiö",
    '__r' => "R",
    '__reconfigure' => "Määritä uudelleen",
    '__record_type' => "Tietuetyyppi",
    '__release' => "Julkaisu",
    '__remote_db_not_supported_by_key' => 'Käyttöoikeusavain ei tue etätietokannan isännöintiä.',
    '__remove' => "Poista",
    '__remove_confirmation' => "Vahvista poisto",
    '__remove_protection' => 'Poista suojaus',
    '__report' => "Raportti",
    '__report_auto' => 'Toimitusaikataulu',
    '__report_form' => "Raporttilomake",
    '__report_size_na' => "Palvelu ei ole käytettävissä",
    '__reports_list' => "Raportit",
    '__requested' => "Pyydetty",
    '__required_fields' => "Pakolliset kentät",
    '__resp_name_invalid' => "Automaattisen vastauksen nimi on virheellinen. Käytä vain aakkosnumeerisia merkkejä, pisteitä, alaviivaa ja tyhjiä merkkejä.",
    '__c' => "A", // Access to panel
    '__s' => "S",
    '__server_name_is_invalid' => "Palvelinnimi on virheellinen.",
    '__screenshots' => 'Näyttökuvat',
    '__script_warning' => "Kun komentosarjat poistetaan käytöstä tässä toimialueessa, kaikki kyseiset komentosarjat näkyvät pelkkänä tekstinä, kun selain kutsuu niitä. Suosittelemme, että järjestelmänvalvoja poistaa kaikki riippuvaiset komentosarjat määritetystä toimialueesta.",
    '__sec' => "Sekuntia",
    '__second(s)' => "sekunti(a)",
    '__see_list_of_logged_in' => "Näytä tällä hetkellä kirjautuneiden käyttäjien luettelo.",
    '__select_certs_to_remove' => "Valitse poistettavat varmenteet.",
    '__select_domains_to_default_host' => "Valitse toimialue, jonka haluat asettaa oletukseksi.",
    '__select_domains_to_remove' => "Valitse poistettavat toimialueet.",
    '__type_domain_name_to_add' => "Syötä lisättävän toimialueen nimi.",
    '__select_files_to_remove' => "Valitse poistettavat tiedostot.",
    '__select_ip' => "Määritä IP-osoite",
    '__select_ip_to_remove' => "Valitse poistettava IP-osoite.",
    '__select_domain_template' => "Käytä toimialuemallin asetuksia",
    '__select_templates_to_remove' => "Valitse poistettavat mallit.",
    '__server' => "Palvelin",
    '__server_total' => "Palvelin yhteensä",
    '__service' => "Palvelu",
    '__service_title__plesk' => "Plesk",
    '__service_description__plesk' => "Plesk",
    '__service_title__mysql' => "MySQL-tietokantapalvelin",
    '__service_description__mysql' => "MySQL-tietokantapalvelin",
    '__service_title__web' => "WWW-palvelin",
    '__service_description__web' => "WWW-palvelin",
    '__service_title__smtp' => "SMTP-palvelin",
    '__service_description__smtp' => "SMTP-palvelin",
    '__service_title__mail' => "IMAP/POP3-palvelin",
    '__service_description__mail' => "IMAP/POP3-palvelin",
    '__service_title__dns' => "DNS-palvelin",
    '__service_description__dns' => "DNS-palvelin",
    '__service_title__postgresq' => "PostgreSQL-tietokantapalvelin",
    '__service_description__postgresq' => "PostgreSQL-tietokantapalvelin",
    '__service_title__spamassassin' => "SpamAssassin-roskapostisuodatuspalvelu",
    '__service_description__spamassassin' => "SpamAssassin-roskapostisuodatuspalvelu",
    '__services' => "Palvelut",
    '__all_services' => "Kaikki palvelut",
    '__sessions' => "Istunnot",
    'sessions__feature_ftp_session_manager_not_supported' => "Nykyinen FTP-palvelin ei tue FTP-istuntojen ominaisuutta",
    '__sessions_list' => "Istunnot",
    '__set' => "Ota käyttöön",
    '__shared' => "Jaettu",
    '__shell_access_warning' => "Järjestelmään pääsyn salliminen liittymällä on erittäin vaarallista järjestelmän turvallisuuden kannalta. Salli järjestelmän käyttö vain silloin, kun ymmärrät tarkasti, mitä olet tekemässä. Salli käyttö vain luotettaville käyttäjille. Haluatko varmasti sallia käytön?",
    '__siteapp_not_support_in_key' => "Käyttöoikeusavain ei tue verkkosovelluksia",
    '__siteapp_cannot_reconfigure_with_remote_database' => 'Tämän verkkosovelluksen määritystä muutettiin manuaalisesti. Manuaalisten muutoksien suojaamiseksi uudelleen määritys Pleskin kautta poistettiin käytöstä.',
    '__site_management' => "Julkaiseminen Webissä", // indirect
    '__size' => "Koko",
    '__skeleton' => 'Virtuaalisen isännän malli',
    '__skins' => 'Ulkoasut',
    '__smtp' => "SMTP", // indirect
    '__smtp_status' => "SMTP-palvelimen tila",
    '__some_fields_are_empty_or_invalid' => "Jotkut kentistä ovat tyhjiä tai niissä on virheellinen arvo.",
    '__unable_to_set_parameters' => "Ei voitu asettaa komponenttien parametreja",
    '__spamassassin' => "Roskapostisuodatin",
    '__spamassassin_status' => "SpamAssassin-tila",
    '__spamd_status' => 'Roskapostisuodatuksen tila',
    '__splited_backup' => "(useita osia kattava varmuuskopiointi)",
    '__split_backup_file' => "Luo useita dataosia sisältävä varmuuskopio",
    '__split_backup_size' => "Aseman koko",
    '__split_backup_less_than_500' => "Alle 500 megatavun kokoja ei tueta",
    '__ssi' => "value mapping",
    '__ssi_support' => "SSI-tuki",
    '__ssi_with_html' => "Käytä SSI:tä *.htm- ja *.html-tiedostoille",
    '__ssl' => 'SSL/TLS',
    '__ssl_support' => "SSL/TLS-tuki",
    '__same_ssl' => "Käytä tätä yksittäistä hakemistoa SSL/TLS- ja muun kuin SSL/TLS-sisällön tallentamiseen",
    '__same_ssl_cu' => "Yleinen SSL/TLS ja muu kuin SSL/TLS-sisältö",
    '__state' => "Osavaltio/Provinssi",

    '__status__Active' => 'Akt.',
    '__status__active' => 'akt.',
    '__status__Passive' => 'Sammutettu',
    '__status__passive' => 'sammutettu',
    '__status__off' => 'sammutettu',
    '__status__with_parent' => 'sammutettu',
    '__status__backup_restore' => 'keskeytetty väliaikaisesti varmuuskopiointia tai palautusta varten',
    '__status__admin' => 'palvelimen järjestelmänvalvojan keskeyttämä',
    '__status__resseler' => 'jälleenmyyjän keskeyttämä',
    '__status__client' => 'asiakkaan keskeyttämä',
    '__status__unknown' => 'tila on tuntematon',

    '__status_of' => "%1 tila",
    // end of akss part

    // shramko part

    '__stunnel' => "Stunnel",
    '__stunnel_server' => "Stunnel-palvelin", // indirect
    '__subdomain' => "Alitoimialue",
    '__subdomain_name' => "Alitoimialueen nimi",
    '__subdomain_name_in_ASCII_form' => "Alitoimialueen nimi ASCII-muodossa",
    '__subdomains' => "Alitoimialueet",
    '__domainaliases' => "Toimialueen aliakset",
    '__subdomains_list' => "Alitoimialueet",
    '__subdomains_not_support_in_key' => "Käyttöoikeusavain ei tue alitoimialueen toimintoja.",
    '__sys_user_type' => "FTP-käyttäjä",
    '__sys_user_type_main' => "Käytä päätoimialueen FTP-käyttäjätiliä",
    '__sys_user_type_native' => "Luo tälle alitoimialueelle erillinen FTP-käyttäjätili",
    '__t' => "T",
    '__target_domain' => "Kohdetoimialue",
    '__template' => "Malli",
    '__template_not_accepted' => "Mallia ei voi hyväksyä: seuraavat rajat ylittyvät.",
    '__templates' => "Mallit",
    '__templates_list' => "Mallit",
    '__tera' => "T",
    '__title' => "Otsikko",
    '__tools' => "Työkalut",
    '__total' => "Yhteensä %1",
    '__total_size' => "Koko yhteensä",
    '__total_used' => "Käytetty yhteensä",
    '__traffic' => "Liikenne",
    '__traffic_by_client' => "Liikenne asiakkaan mukaan",
    '__traffic_by_domain' => "Liikenne toimialueen mukaan",
    '__traffic_by_service' => "Liikenne palvelun mukaan",
    '__traffic_history' => "Liikennehistoria",
    '__unable_change_locale' => "Käyttöliittymän kieltä ei voi muuttaa: %1",
    '__unable_create_new_dom' => "Toimialuetta ei voi luoda: %1",
    '__unable_define_dom_name' => "Toimialueen nimeä ei voi määrittää: %1",
    '__unable_define_necessary_properties' => "Kaikkia tarvittavia ominaisuuksia ei voi määrittää.",
    '__unable_define_properties' => "Ominaisuuksia ei voi määrittää: %1",
    '__unable_exec_util' => "Apuohjelmaa ei voi suorittaa: %1",
    '__unable_get_dns_a_recs' => "Tälle isännöintitilille ei voi noutaa A DNS -tietueiden IP-osoitteita: %1",
    '__unable_get_mbox_quota' => "Tietoja postilaatikon kokorajasta ei voida palauttaa.",
    '__unable_redirect_to_myself' => "Välitys samaan tiliin ei onnistu.",
    '__unable_redirect_to_my_alias' => "Postin välitys sähköpostin aliakseen ei onnistu.",
    '__default_domain_redirect_to_myself' => "Toimialuetta ei voida asettaa IP-osoitteen oletukseksi:\n ohjaus samaan kohteeseen havaittu.",
    '__unable_remove_client' => "Asiakasta ei voi poistaa: %1",
    '__unable_set_up_mbox_quota' => "Toimialueelle ei voi määrittää postilaatikon koon rajaa: %1",
    '__unable_setup_pass' => "Salasanaa ei voi asettaa: %1",
    '__unable_to_create_new_account' => "Tiliä ei voi luoda: %1",
    '__unable_to_define_db_size' => "Tietokannan kokoa ei voi määrittää.",
    '__unable_to_enable_short_names' => "Lyhyiden sähköpostitilien nimien käyttöä ei voi sallia POP3/IMAP-tileille.",
    '__unable_to_fetch_data_from_submit' => "Lähetettyjä tietoja ei voi hakea: %1",
    '__unable_to_open_file' => "Tiedostoa %1 ei voi avata: %2",
    '__unable_to_update_subdomain' => "Alitoimialueeseen ei voi tehdä muutoksia: %1",
    '__unable_update_cl_data' => "Käyttäjätiliin ei voi tallentaa muutoksia: %1",
    '__unable_update_db_params' => "Tietokantaparametreja ei voi päivittää: %1",
    '__unable_update_dom_data' => "Toimialueen tietoja ei voi päivittää: %1",
    '__undefined' => "määrittämätön",
    '__uninstall' => "Poista asennus",
    '__unknown_error' => "Tuntematon virhe",
    '__unlimited_lower' => "Rajoittamaton",
    '__unset' => "Sammuta",
    '__update' => "Päivitä",
    '__uploaded_file_is_invalid' => "Ladattu tiedosto ei kelpaa: %1",
    '__url' => "URL",
    '__usage' => "Levytilan käyttö",
    '__user' => 'Käyttäjä',
    '__user_already_logged' => "Toinen käyttäjä, jolla on sama käyttäjänimi (%1), on jo kirjautunut Pleskiin.",
    '__version' => "Versio",
    '__aps_license' => "Käyttöoikeusavain",
    '__vh_type' => "Virtuaalinen isäntätyyppi",
    '__vhosts_apache_status' => "Verkkopalvelimen tila",
    '__wrong_charset_conversion' => 'Virheellinen merkistö, muutosta arvosta "%1" arvoon "%2" ei sallita',
    '__warning_' => "Varoitus!",
    '__warning_excl_ip_num' => "Varattu IP-osoite",
    '__warning_expiration' => "Vanhentumispäivä",
    '__web_scripting' => "WWW-komentosarjat", // indirect
    '__web_serv' => "WWW-palvelin", // indirect
    '__web_statistic' => "Verkkosivuston tilastot", // indirect
    '__webmail' => "WWW-sähköpostipalvelu", // +indirect
    '__webstat_not_installed' => "Webalizeria ei ole asennettu palvelimeen. Kysy Webalizerin asennusohjeita palveluntarjoajalta.",
    '__webstat_support' => "Verkkosivuston tilastot",
    '__webstat_awstats_support' => "AWStats",
    '__webstat_webalizer_support' => "Webalizer",
    '__webstat_awstats' => "AWStats",
    '__webstat_webalizer' => "Webalizer",
    '__webstat_type_change_warning' => "Kun siirryt yhdestä tilastotieto-ohjelmasta toiseen, kaikki aikaisemmin käytetyn tilastotieto-ohjelman luomat raportit poistetaan ja uudet raportit luodaan palvelimen lokitiedostojen tietojen mukaisesti. Tämä tarkoittaa, että jos määritit järjestelmän (Toimialueet > Toimialueen nimi > Lokinhallinta > Lokin kierto) lokitiedostojen säilyttämiseksi vain viimeisen kuukauden ajan, verkkotilastotiedot ovat saatavilla vain viimeisen kuukauden ajan. Haluatko vaihtaa toiseen tilastopakettiin?",
    '__webstat_perm_denied' => 'Sinulla ei ole oikeuksia verkkosivuston tilastojen hallitsemista varten.',
    '__webuser' => "Internet-käyttäjä",
    '__sysusers_list' => "Järjestelmäkäyttäjät",
    '__sysuser' => "Järjestelmän käyttäjä",
    '__weekly' => "Viikoittain",
    '__whats_new_in_version' => "Plesk %1:n uudet ominaisuudet?",
    '__wrong_hosting_type__none' => 'Toimialueelle %1 ei ole määritetty verkkosivuston isännöintiä.',
    '__wrong_hosting_type__std_fwd' => 'Toimialueelle %1 on määritetty vakioedelleenlähetys. Tämä toiminto on saatavilla vain toimialueille, joille on määritetty verkkosivuston isännöinti.',
    '__wrong_hosting_type__frm_fwd' => 'Toimialueelle %1 on määritetty kehyksen edelleenlähetys. Tämä toiminto on saatavilla vain toimialueille, joille on määritetty verkkosivuston isännöinti.',
    '__wu' => "Internet-käyttäjät",
    '__www' => "WWW",
    '__www_prefix_was_changed' => "WWW-etuliite muutettiin. Muista muokata SSL/TLS-varmennetta vastaavasti.",
    '__year' => "Vuosi",
    '__year(s)' => "Vuotta",
    '__yes' => "Kyllä",
    '__you' => "Sinä",
    '__zip_code' => "Postinumero",
    '__form_normal' => "Vakio",
    '__form_advanced' => "Lisäasetukset",

    'admin_ed__edit_administrator_info' => "Muokataan järjestelmänvalvojan profiilia",
    'admin_ed__create_default_client' => "Haluan luoda oletusasiakastilin.",
    'admin_ed__unable_update' => "Järjestelmänvalvojan tietoja ei voi päivittää: %1",

    'auth__update_admin_info' => "Anna järjestelmänvalvojan tiedot. Kohteen %1 käyttö edellyttää näitä tietoja.",
    'auth__you_not_have_perm' => "Sinulla ei ole tarvittavia käyttöoikeuksia tämän toimialueen hallitsemista varten.",
    'auth__key_expired_admin' => 'Plesk -käyttöoikeus mennyt umpeen. Voit jatkaa Pleskin käyttöä uusimalla tai hankkimalla uuden käyttöoikeuden.',
    'auth__key_expired_admin_restricted' => 'Plesk -käyttöoikeus mennyt umpeen. Voit jatkaa Pleskin käyttöä ottamalla yhteyttä palveluntarjoajaan.',
    'auth__key_expired_client' => 'Plesk -käyttöoikeus mennyt umpeen. Ota yhteys isännöintipalvelujen tarjoajaan.',
    'autoinstaller__not_installed' => 'Automaattisen asennuksen osaa ei ole asennettu.',
    'autoinstaller__release_action' => 'Käytettävissä olevat toiminnot',
    'autoinstaller__release_action_icon' => 'S',
    'autoinstaller__release_action_upgrade' => 'Päivitetään uuteen Plesk -versioon',
    'autoinstaller__release_action_update' => 'Päivitetään tai lisätään uusia osia',
    'autoinstaller__release_action_up2date' => 'Versiosi on ajan tasalla',
    'autoinstaller__component_action' => 'Tila',
    'autoinstaller__component_action_icon' => 'S',
    'autoinstaller__component_action_install' => 'Ei asennettu',
    'autoinstaller__component_action_update' => 'Päivityksiä on saatavilla',
    'autoinstaller__component_action_upgrade' => 'Päivitys on saatavana',
    'autoinstaller__component_action_up2date' => 'Versiosi on ajan tasalla',
    'autoinstaller__component_action_error' => 'Päivityksiä ei ole saatavilla',
    'autoinstaller__component_serverbuildtime' => 'Viimeisin julkaisu',
    'autoinstaller__component_localbuildtime' => 'Julkaisusi',
    'autoinstaller__component_installed_version' => 'Versiosi',
    'autoinstaller__component_available_version' => 'Viimeisin versio',
    'autoinstaller__component' => 'Komponentti',
    'autoinstaller__components' => 'Komponentit',
    'autoinstaller__components_title' => '%1 Osat',
    'autoinstaller__component_dependency_note' => 'tarvitaan valitsemiesi osien asentamiseen',
    'autoinstaller__install_confirm' => 'Kyllä, haluan asentaa nämä osat',
    'autoinstaller__install_confirm_request' => 'Valitse valintaruutu vahvistaaksesi',
    'autoinstaller__install_title' => 'Vahvista valittujen osien asennus',
    'autoinstaller__key_update_confirm' => 'Vahvista ohittamalla avaimen päivitys ja asentamalla oletusavain',
    'autoinstaller__key_update_confirm_request' => 'Vahvista valitsemalla ruutu.',
    'autoinstaller__key_update_failed' => '<p>Plesk ei voi päivittää tuotteen käyttöoikeuttasi.</p><p>%1</p><p>Jos jatkat päivitystä ilman hyväksyttävää tuotteen käyttöoikeutta, rajoitetun käytön tarjoava oletuskäyttöoikeus asennetaan. Järjestelmänvalvojien kannattaa hankkia ensin hyväksyttävä käyttöoikeusavain ennen tuotteen päivittämistä.</p>',
    'autoinstaller__email' => 'Lähetä ilmoitus kohteelle',
    'autoinstaller__email_admin' => "Järjestelmänvalvojan sähköposti",
    'autoinstaller__email_email' => 'Mukautettu sähköpostiosoite...',
    'autoinstaller__release' => 'Julkaisun nimi',
    'autoinstaller__releases' => 'Käytettävissä olevat julkaisut',
    'autoinstaller__releases_title' => 'Plesk-päivitystyökalu',
    'autoinstaller__select_components_to_install' => 'Valitse asennettavat osat',
    'autoinstaller__status_error' => 'Virhe: %1',
    'autoinstaller__status_install_error' => 'Asennus ei käynnistynyt: %1',
    'autoinstaller__status_install_busy' => 'Asennus ei käynnistynyt: toinen asennustoimenpide on käynnissä.',
    'autoinstaller__status_install_ok' => 'Asennus käynnistyi. Saat ilmoituksen asennuksen etenemisestä sähköpostitse (%1).',
    'autoinstaller__status_query_busy' => 'Asennus on käynnissä.',
    'autoinstaller__status_query_error' => 'Ei voitu noutaa tietoja asennuksen tilasta: %1',
    'autoinstaller__status_unknown' => 'Automaattisen asennustoiminnon tilaa ei voi palauttaa.',
    'autoinstaller__status_busy' => 'Automaattinen asennustoiminto on käytössä, ole hyvä ja odota.',
    'autoinstaller__configure_title' => 'Päivitystyökalun asetukset',
    'autoinstaller__preferences_legend' => 'Asetukset',
    'autoinstaller__target' => 'Väliaikainen lataushakemisto',
    'autoinstaller__target_invalid' => "Määritä absoluuttinen polku",
    'autoinstaller__check_updates' => 'Tarkista päivitykset järjestelmänvalvojan kirjautuessa sisään Pleskiin',
    'autoinstaller__check_updates_warning' => 'Uusia <a href="%1">päivityksiä</a> on saatavilla kohteeseen %2',
    'autoinstaller__source_type' => 'Lähteen tyyppi',
    'autoinstaller__source' => 'Lähde-URL',
    'autoinstaller_source__preferences_legend' => 'Asetukset',
    'autoinstaller_source__type' => 'Lähteen tyyppi',
    'autoinstaller_source__url_invalid' => 'Virheellinen lähde',
    'autoinstaller_source__url_invalid_network' => 'Virheellinen lähteen URL (esimerkki: http://source, ftp://source)',
    'autoinstaller_source__url' => 'Lähde-URL',
    'autoinstaller__source_invalid_network' => 'Määritetty verkko-osoite on virheellinen',
    'backup__repository' => 'Varmuuskopiotiedostojen tallennustilan sijainti',
    'backup__error_notify_email' => 'Jos varmuuskopioinnin aikana tapahtuu virheitä, lähetä sähköposti-ilmoitus',
    'backup__dump_info' => "Varmuuskopioi tiedot",
    'backup__dump_file_name_not_defined' => "Varmuuskopiotiedostonimeä ei ole määritetty",
    'backup__local_file' => 'Paikallinen varmuuskopiotiedosto',
    'backup__domain_ftp' => 'FTP-etäpalvelin',
    'backup__wrong_path' => "Virheellinen varmuuskopiotiedostojen säilytystilan polku: Älä käytä merkkijoukkoa ../../",
    'backup__unable_to_connect_to_ftp_server' => "Yhteyttä ei voida muodostaa FTP-palvelimeen: %1",
    'backup__unable_to_read_file' => 'Varmuuskopiotiedostoa ei voi lukea.',
    'backup__backup_task_does_not_exist' => "Varmuuskopiointitehtävää ei ole, luo se ennen sen käyttöönottamista.",
    'backup__restore_params' => "Palautusparametrit",
    'backup__confirmation' => "Varoitus: toimialue ei ole käytettävissä varmuuskopioinnin/palautuksen aikana.",
    'backup__backup_method' => 'Varmuuskopiointimenetelmä',
    'backup__dumpfile_name' => "Varmuuskopiotiedoston nimi",
    'backup__dumpfile_name_is_invalid' => "Varmuuskopiotiedoston nimi on virheellinen: käytä vain aakkosnumeerisia merkkejä, ajatusviivaa, pistettä ja alaviivaa, älä käytä nimiä kuten kuvaus.* varmuuskopiotiedoston nimenä.",
    'backup__email_required' => "Sähköpostiosoitteen syöttäminen vaaditaan varmuuskopiointi- ja palautusprosessien edistymistietojen lähettämiseksi. Määritä sähköpostiosoitteesi tilin tiedoissa.",
    'backup__error_during_backup' => "Varmuuskopiotiedoston luominen ei onnistu: %1",
    'backup__input_email_warning' => "Määritä ilmoitusta varten sähköpostiosoite tai poista valinta valintaruudusta.",
    'backup__make_download' => "älä tallenna varmuuskopiotiedostoa säilytystilaan, lataa se ainoastaan",
    'backup__make_dump' => 'luo varmuuskopiotiedosto ja tallenna se paikalliseen säilytystilaan',
    'backup__makedump_to_ftp' => 'luo varmuuskopiotiedosto ja tallenna se FTP-etäpalvelimeen',
    'backup__restore_ip' => "IP-osoite palauttamista varten",
    'backup__select_dumpfile' => "Valitse varmuuskopiotiedosto.",
    'backup__time' => "Varmuuskopiointiaika",
    'backup__day' => 'Varmuuskopiointipäivä',
    'backup__view_dump_info' => "Näytä toimialueen %1 varmuuskopiotiedot",
    'backup__wrong_domain_name' => "Varmuuskopiotiedosto sisältää toimialueen %1 tiedot, eikä sitä voi siksi palauttaa toimialueessa %2",
    'backup__incorrect_ftp_user_or_passwd' => "Virheellinen FTP-käyttäjä tai salasana. Korjaa FTP-tilin ominaisuudet",
    'backup__access_denied' => "Käyttö estetty. Korjaa FTP-tilin ominaisuudet",
    'backup__restore_from' => "Palauta %1",
    'backup__domain_session_failed' => 'Toimialuetta %1 ei varmuuskopioitu',
    'backup__client_session_failed' => 'Asiakasta %1 ei varmuuskopioitu',
    'backup__domain_session_restore_failed' => 'Toimialuetta %1 ei palautettu',
    'backup__client_session_restore_failed' => 'Asiakastiliä %1 ei palautettu',
    'backup__domain_session_complete' => 'Toimialue %1 varmuuskopioitiin',
    'backup__domain_session_backup' => 'Toimialueen %1 varmuuskopiointi',
    'backup__client_session_backup' => 'Asiakkaan %1 varmuuskopiointi',
    'backup__domain_stop_title' => 'Toimialueen %1 varmuuskopioinnin peruutus',
    'backup__client_stop_title' => 'Asiakastilin %1 varmuuskopioinnin peruutus',
    'backup__domain_restore_stop_title' => 'Toimialueen %1 palautuksen peruutus',
    'backup__client_restore_stop_title' => 'Asiakastilin %1 palautuksen peruutus',
    'backup__domain_session_backup_stop' => 'Olet peruuttamassa käynnissä olevaa varmuuskopiointiprosessia. Varmuuskopiointitiedostoa ei luoda.',
    'backup__backup_stop_confirm' => 'Kyllä, haluan pysäyttää varmuuskopiointiprosessin',
    'backup__restore_stop_confirm' => 'Kyllä, haluan pysäyttää palautusprosessin',
    'backup__domain_session_restore' => 'Toimialueen %1 palautus',
    'backup__domain_session_restore_stop' => 'Olet peruuttamassa käynnissä olevaa palautusprosessia.',
    'backup__domain_backup_file_info' => 'Toimialueen varmuuskopiointitiedoston tiedot',
    'backup__domain_backup_file_list' => 'olemassa olevat varmuuskopiotiedostot',
    'backup__domain_backup_progress' => 'Verkkosivuston %1 varmuuskopioinnin edistyminen',
    'backup__domain_restore_progress' => 'Verkkosivuston %1 palautuksen edistyminen',
    'backup__domain_backup_progress_elapsed_time' => 'Kulunut aika: %1',
    'backup__domain_restore_progress_elapsed_time' => 'Kulunut aika: %1',
    'backup__ip_map_legend' => 'IP-määritys',
    'backup__ip_map_list_count' => 'IP-osoitteet',
    'backup__domain_restore_session_complete' => 'Toimialue %1 on palautettu.',
    'backup__domain_restore_session_complete_message' => 'Toimialue %1 palautettiin.',
    'backup__domain_backup_file_delete' => 'Seuraavat varmuuskopiotiedostot poistetaan:',
    'backup__domain_backup_file_for_remove' => 'Valitse varmuuskopiointitiedostot, jotka haluat poistaa',
    'backup__backup_overwrite_file_confirm' => 'Korvauksen vahvistus',
    'backup__backup_overwrite_file_confirm_text' => 'Varmuuskopiotiedosto nimeltä "%1" on jo olemassa. Haluatko korvata sen?',
    'backup__backup_confirm_overwrite' => 'Vahvista tiedoston korvaus',
    'backup__backup_overwrite_legeng' => 'Korvaa',
    'backup__backup_not_contain_domain' => 'Varmuuskopiointitiedosto ei sisällä tietoa toimialueesta %1',
    'backup__backup_not_contain_client' => 'Varmuuskopiointitiedosto ei sisällä tietoa asiakastilistä %1',
    'backup__backup_client_info' => "Varmuuskopioi asiakkaan asetukset ja tilitiedot",
    'backup__client_backup_progress' => 'Asiakastilin %1 varmuuskopioinnin edistyminen',
    'backup__client_session_complete' => 'Asiakastili %1 on varmuuskopioitu',
    'backup__client_backup_file_info' => 'Asiakkaan varmuuskopiointitiedoston tiedot',
    'backup__restore_client_info' => "Palauta asiakkaan asetukset ja tilitiedot",
    'backup__client_session_restore' => 'Asiakastilin %1 palautus',
    'backup__client_db_server_map' => 'Tietokantapalvelimien määritys',
    'backup__domain_db_server_map' => 'Tietokantapalvelimien määritys',
    'backup__client_restore_session_complete_message' => 'Asiakastili %1 palautettiin.',
    'backup__client_restore_session_complete' => 'Asiakastili %1 palautettiin.',
    'backup__restore_select_some' => 'Valitse kohteet, jotka haluat palauttaa.',
    'backup__client_restore_progress' => 'Asiakastilin %1 palautuksen edistäminen',
    'backup__new_backup' => 'Luodaan uusi varmuuskopio',
    'backup__done' => 'Valmis:',
    'backup__done_domains' => '%1 toimialuetta %2 toimialueesta',
    'backup__done_clients' => '%1 asiakasta %2 asiakkaasta',
    'backup__remaining' => 'Jäljellä:',
    'backup__remaining_domains' => '%1 toimialue(tta)',
    'backup__remaining_clients' => '%1 asiakas(ta)',
    'backup__overall_backup_progress' => 'Yleinen varmuuskopioinnin edistyminen',
    'backup__comment_n_a' => 'puuttuu',
    'backup__command_ignore' => 'Komento "%1" ohitetaan',
    'backup__no_objects' => 'varmuuskopioitavia kohteita ei ole',
    'backup__cli_warning_not_enough_ip' => 'VAROITUS: ei riittävästi IP-osoitteita IP-oletusmäärityksen suorittamiseksi:',
    'backup__local_repository' => "Plesk-säilytystila",
    'backup__ftp_repository' => 'FTP-tallennus',
    'backup__ftp_login' => 'Käyttäjänimi',
    'backup__ftp_password' => 'Salasana',
    'backup__ftp_directory_hint' => 'Esimerkki: /myfolder/mybackups',
    'backup__ftp_account_settings' => 'FTP-tilin asetukset',
    'backup__ftp_account_preferences' => 'FTP-tilin asetukset',
    'backup__repository_not_exist' => 'Hakemistoa ei ole',
    'backup__repository_not_readable' => 'Määritetty hakemisto ei ole luettavissa',
    'backup__ftp_repository_not_configure' => 'Voit käyttää FTP-varmuuskopioinnin säilytystilaa, <a href="%1">määritä ensin FTP-tili. </a>',
    'backup__ftp_repository_list_not_configure' => 'Tilin asetuksia ei määritetty',
    'backup__repository_list_unable_listing' => 'Tiedostoluetteloa ei voi noutaa',
    'backup__ftp_repository_unable_listing' => 'Hakemistoluetteloa "%1" ei voida palauttaa:',
    'backup__repository_legend' => 'Varmuuskopiotiedostojen tallennustilaa',
    'backup__store_in_repository' => 'Tallenna tiedostot kohteeseen',
    'backup__local_repository_lable' => 'Paikallinen säilytystila',
    'backup__ftp_repository_lable' => 'FTP-tallennus',
    'backup__ftp_repository_not_configure_hint' => '(tilin asetuksia ei ole määritetty)',
    'backup__ftp_repository_not_configure_or_forbidden_hint' => '(FTP-tiliä ei ole määritetty tai sitä ei tueta)',
    'backup__ftp_directory_not_exist' => 'Määritettyä hakemistoa ei ole',
    'backup__other_user_process_modified' => 'Toinen käyttäjä on pysäyttänyt varmuuskopiointi- tai siirtoprosessin.',
    'backup__another_user_exist' => 'Käynnissä olevaan toiminnon käynnisti toinen Pleskin käyttäjä. Kyseinen käyttäjä on edelleen kirjautuneena Pleskiin.',
    'backup__ftp_repository_wait' => 'Odota, kunnes FTP-säilytystilan tiedot on palautettu',
    'backup__ftp_write_test_failed' => 'Testitietoja ei voida kirjoittaa FTP-tiliin %1:',
    'bt_upload_to_repository' => 'Lataa tiedostot paikalliseen säilytystilaan',
    'bt_new_restore' => "Palauta",
    'bt_backup_schedule' => "Ajoita varmuuskopiointi",
    'backup_exist_backups' => "Olemassa olevat varmuuskopiotiedostot",
    'backup_dialog__page_title' => "Varmuuskopiotiedoston luonti",
    'backup_dialog__please_wait' => "Varmuuskopiointiprosessi on alkamaisillaan. Tämä voi kestää jonkin aikaa. Odota",
    'backup_conf__page_title' => 'Varmuuskopioinnin määritys',
    'bt_accept' => "Hyväksy",
    'bt_access' => "Käyttö",
    'bt_action_log' => "Toimintoloki",
    'bt_add' => "Lisää",
    'bt_add_client' => "Liitä käyttäjille",
    'bt_database_server_add' => 'Lisää uusi tietokantapalvelin',
    'bt_add_services' => "Lisää palveluita",
    'bt_anonftp_stats' => "Anon.FTP tilast",
    'bt_anonymous_ftp' => "Julkinen FTP",
    'bt_aspdotnet' => "ASP.NET",
    'bt_attach' => "Liitä",
    'bt_autoinstaller' => 'Päivitystyökalu',
    'bt_auto-updates' => 'Päivitystyökalu',
    'bt_back' => "<< Edellinen",
    'bt_backup' => "Varmuuskopioi",
    'bt_backup_configure' => "Varmuuskopiointiasetukset",
    'bt_buy_certs' => "Osta varmenteet",
    'bt_card' => "Kortti",
    'bt_cert' => "Varmenne",
    'bt_certificates' => "Varmenteet",
    'bt_change_passwd' => "Muuta salasana",
    'bt_clear' => "Tyhjennä",
    'bt_client_templates' => "Asiakasmallit",
    'bt_clients' => "Asiakkaat",
    'bt_codepage_change' => 'Muuta koodausta',
    'bt_comp_info' => "Osien hallinta",
    'bt_configure_maillists' => "Aseta Mailman",
    'bt_configure_odbc' => "ODBC-tietolähteet",
    'bt_configure' => 'Määritä',
    'bt_copy' => "Kopioi",
    'bt_copy_move' => "Kopioi/siirrä",
    'bt_create' => "Luo",
    'bt_create_account' => "Luo tili",
    'bt_create_dir' => "Lisää hakemisto",
    'bt_create_file' => "Lisää tiedosto",
    'bt_count_size' => "Laske koko",
    'bt_crontab_unix' => "Crontab",
    'bt_crontab_win' => "Tehtävien ajoitus",
    'bt_custom_button_new' => "Painikkeen lisääminen",
    'bt_custom_buttons' => "Mukautetut painikkeet",
    'bt_customize' => "Mukauta",
    'bt_databases' => "Tietokannat",
    'bt_database_servers' => 'Tietokantapalvelimet',
    'bt_sqlservers' => "Tietokantapalvelimet",
    'bt_db_usr_new' => "Lisää tietokannan käyttäjä",
    'bt_db_new' => "Lisää tietokanta",
    'bt_db_phpmyadmin' => "MySQL-järjestelmänvalvoja",
    'bt_dbuser_default' => "Määritä tietokannan Web-hallinnan oletukseksi",
    'bt_decline' => "Hylkää",
    'bt_default' => "Oletus",
    'bt_defaultcomponents' => "Kolmannen osapuolen palvelut",
    'bt_defaults' => "Oletukset",
    'bt_delete' => "Poista",
    'bt_directories' => "Suojatut hakemistot",
    'bt_disable' => "Sammuta",
    'bt_dns' => "DNS-asetukset",
    'bt_dns_enable' => 'Ota käyttöön',
    'bt_dns_disable' => 'Poista käytöstä',
    'bt_dns_default' => 'Palauta oletus',
    'bt_dns_zone_sync' => 'Ota DNS-mallin muutokset käyttöön',
    'bt_dnsrecord_add' => 'Lisää tietue',
    'bt_do_backup' => "Varmuuskopioi",
    'bt_do_restore' => "Palauta",
    'bt_do_upload' => "Lataa palvelimeen",
    'bt_domain_aliases' => "Toimialueen aliakset",
    'bt_domain_templates' => "Toimialuemallit",
    'bt_domain_user' => "Toimialueen järjestelmänvalvoja",
    'bt_domain_user_passwd' => "Toimialueen järjestelmänvalvojan salasana",
    'bt_domains' => "Toimialueet",
    'bt_domain_alias_add' => 'Lisää toimialueen alias',
    'bt_download' => "Lataa",
    'bt_edit' => "Muokkaa",
    'bt_enable' => "Ota käyttöön",
    'bt_export' => 'Vie',
    'bt_extras' => "Ekstrat",
    'bt_file_manager' => "Tiedostonhallinta",
    'bt_finish' => "Valmis",
    'bt_ftp_account' => "FTP-tilin ominaisuudet",
    'bt_forget_password' => "Unohtuiko salasana?",
    'bt_fp_ssl_webadmin' => "FP-SSL/TLS-Web-hallinta",
    'bt_fp_webadmin' => "FP-Web-hallinta",
    'bt_ftp_stats' => "FTP-tilast",
    'bt_get_password' => "Hae salasana",
    'bt_global_changes' => "Muokkaa",
    'bt_help' => "Ohje",
    'bt_hide_aliases' => "Piilota aliakset",
    'bt_hide_toolbar' => 'Piilota työkalurivi',
    'bt_hide_subdomains' => "Piilota alitoimialueet",
    'bt_hide_domainaliases' => "Piilota toimialueen aliakset",
    'bt_home' => "Kotisivu",
    'bt_hosting' => "Isännöinti",
    'bt_icf' => 'Palomuuri',
    'bt_install' => "Asenna",
    'bt_ip_aliasing' => "IP-osoitteet",
    'bt_ip_add' => "Lisää IP-osoite",
    'bt_ip_pool' => "IP-ryhmä",
    'bt_key_info' => "Lisenssin tiedot",
    'bt_key_buyonline_addons' => 'Tilaa Pleskin lisäosia',
    'bt_key_buyonline_upgrades' => 'Tilaa Pleskin päivitykset',
    'bt_key_buyonline_new' => 'Tilaa uusi avain',
    'bt_limits' => "Rajat",
    'bt_locale_add' => 'Lisää aluekohtainen asetus',
    'bt_locales' => 'Aluekohtaiset asetukset',
    'bt_log_manager' => "Lokinhallinta",
    'bt_login' => "Kirjaudu sisään",
    'bt_login_vzpp' => "Kirjaudu Power Paneliin",
    'bt_logo' => "Tuotemukautus",
    'bt_logo_send_link' => "Liitä linkki",
    'bt_logo_send_logo' => "Liitä logo",
    'bt_logout' => "Kirjaudu ulos",
    'bt_logrotation' => "Lokikierto",
    'bt_mail' => "Sähköposti",
    'bt_mail_alias_add' => "Lisää sähköpostialias",
    'bt_mail_aliases' => "Sähköpostialiakset",
    'bt_mail_group_add' => "Lisää jäsen",
    'bt_mail_groups' => "Ryhmät",
    'bt_mail_name_add' => "Lisää sähköpostitili",
    'bt_mail_preferences' => "Asetukset",
    'bt_mail_group' => "Postitusryhmä",
    'bt_mail_mailbox' => "Postilaatikko",
    'bt_mail_redirect' => "Välittäjä",
    'bt_mail_resp_add' => "Lisää automaattinen vastaus",
    'bt_mail_resp_attach_add' => "Lisää liite",
    'bt_mail_resp_files' => "Liitetiedostot",
    'bt_mail_responders' => "Automaattiset vastaukset",
    'bt_mail_spamfilter' => "Roskapostisuodatin",
    'bt_mail_webmail' => "WWW-sähköpostipalvelu",
    'bt_maillist_new' => "Lisää postituslista",
    'bt_maillists' => "Postituslistat",
    'bt_mailman' => "Mailman",
    'bt_make_dump' => "Luo varmuuskopio",
    'bt_manage' => "Hallinta",
    'bt_master' => "Perus",
    'bt_migrate' => 'Siirrä',
    'bt_modules_add' => 'Lisää laajennus',
    'bt_modules_manage' => 'Hallitse tunnisteita',
    'bt_move' => "Siirrä",
    'bt_mimetypes' => 'MIME-tyypit',
    'bt_mimetype_new' => 'Lisää MIME-tyyppi',
    'bt_new_client' => "Lisää asiakastili",
    'bt_new_domain' => "Lisää toimialue",
    'bt_next' => "Seuraava >>",
    'bt_next_page' => "Seuraava",
    'bt_network_add' => "Lisää verkko",
    'bt_notifications' => "Ilmoitukset",
    'bt_odbc_dsn_add' => "Lisää ODBC DSN",
    'bt_off' => "Ei käytössä",
    'bt_on' => "Päällä",
    'bt_on_off' => "Käytössä/Ei käytössä",
    'bt_pd_new' => "Lisää suojattu hakemisto",
    'bt_pd_user_new' => "Lisää käyttäjä",
    'bt_performance' => 'Suorituskyky',
    'bt_permissions' => "Käyttöoikeudet",
    'bt_phpmyadmin' => "PhpMyAdmin",
    'bt_postgre_sql' => "PostgreSQL",
    'bt_preferences' => "Asetukset",
    'bt_prev_page' => "Edell",
    'bt_preview' => 'Sivun esikatselu',
    'bt_print' => "Tulosta",
    'bt_reboot' => "Käynnistä uudelleen",
    'bt_reload' => "Lataa uudelleen",
    'bt_refresh' => "Päivitä",
    'bt_register' => "Rekisteröi",
    'bt_remove' => "Poista",
    'bt_enable_selected' => 'Ota käyttöön',
    'bt_disable_selected' => 'Sammuta',
    'bt_repair_ip' => "Korjaa IP",
    'bt_report' => "Raportti",
    'bt_report_auto' => 'Raportin toimitus',
    'bt_report_auto_new' => 'Lisää toimitusaikataulu',
    'bt_report_new' => "Lisää malli",
    'bt_reset' => "Palauta",
    'bt_restart_services' => "Palveluiden hallinta",
    'bt_save' => "Tallentaa",
    'bt_send_by_email' => "Lähetä sähköpostitse",
    'bt_send_file' => "Lähetä tiedosto",
    'bt_send_mail' => "Lähetä sähköposti",
    'bt_send_passwd' => "Lähetä salasana",
    'bt_send_text' => "Lähetä teksti",
    'bt_server' => "Palvelin",
    'bt_server_add' => "Lisää palvelin",
    'bt_server_preferences' => "Palvelimen asetukset",
    'bt_servers_list' => "Palvelimet",
    'bt_sessions' => "Istunnot",
    'bt_set' => "Aseta",
    'bt_set_as_default' => "Aseta oletukseksi",
    'bt_setup' => 'Asennus',
    'bt_show_aliases' => "Näytä aliakset",
    'bt_show_subdomains' => "Näytä alitoimialueet",
    'bt_show_domainaliases' => "Näytä toimialueen aliakset",
    'bt_shutdown' => "Sammuta",
    'bt_site_apppkgs' => "Sovellusholvi",
    'bt_site_apppool' => "Sovellussarja",
    'bt_application-pool' => "Verkkosovellukset",
    'bt_site_apps' => "Verkkosovellukset",
    'bt_site_app_add' => "Asenna sovellus",
    'bt_site_builder' => "Presence Builder -tuki",
    'bt_skeleton' => 'Virtuaalisen isännän malli',
    'bt_skins' => 'Ulkoasut',
    'bt_skin_add' => 'Lisää ulkoasu',
    'bt_skin_manual' => 'Mukautettujen Plesk -ulkoasujen viite', // not used
    'bt_skin_download' => 'Lataa ulkoasu',
    'bt_skin_replace' => 'Päivitä ulkoasu',
    'bt_skip' => 'Ohita',
    'bt_spamassassin' => "Roskapostisuodatin",
    'bt_spamassassin_train' => "Koulutus",
    'bt_spamfilter' => "Roskapostisuodatin",
    'bt_sshterm' => 'SSH-pääte',
    'bt_start' => "Käynnistä",
    'bt_stop' => "Pysäytä",
    'bt_recycle' => "Siirrä roskakoriin",
    'bt_statistics' => "Tilastot",
    'bt_subdomain_new' => "Lisää alitoimialue",
    'bt_subdomains' => "Alitoimialueet",
    'bt_submit' => "Lähetä",
    'bt_summary_report' => "Yhteenvetoraportti",
    'bt_support' => "Tuki",
    'bt_switch' => "Siirry",
    'bt_system_time' => "Järjestelmän kellonaika",
    'bt_task_new' => "Lisää tehtävä",
    'bt_dom_tmpl_add' => 'Lisää toimialuemalli',
    'bt_cl_tmpl_add' => 'Lisää asiakasmalli',
    'bt_cron_backup' => 'Ajoitetun varmuuskopioinnin asetukset',
    'bt_test' => "Testaa yhteys",
    'bt_text' => "Teksti",
    'bt_touch' => "Muuta aikaleima",
    'bt_traffic' => "Liikenne",
    'bt_traffic_history' => "Liikennehistoria",
    'bt_update' => "Päivitä",
    'bt_upload' => "Lataa palvelimeen",
    'bt_upload_from_ftp' => "FTP:n lataus",
    'bt_virtualdirs' => 'Näennäiskansiot',
    'bt_virtualdir_new' => 'Lisää näennäiskansio',
    'bt_virtualdir_add' => 'Lisää näennäiskansio',
    'bt_web_app_new' => "Asenna Java-sovellus",
    'bt_web_stats' => "Verkkotilastot",
    'bt_web_stats_ssl' => "Verkkotilastot SSL/TLS",
    'bt_web_user_add' => "Lisää Internet-käyttäjä",
    'bt_web_users' => "Internet-käyttäjät",
    'bt_webadmin' => "Web-hallinta",
    'bt_webalizer' => "Webalizer",
    'bt_webalizer_preferences' => "Verkkosivuston tilastojen asetukset",
    'bt_hidden-referrer-add' => 'Piilota tiedot',
    'bt_group-referrer-add' => 'Viittaajaryhmä',
    'bt_whats_new_full' => "Näytä täydellinen muutosluettelo",
    'cert_add__unable_set_ca_cert' => "Myöntäjän varmennetta ei voi määrittää: %1",
    'cert_add__unable_set_cert' => "Varmennetta ei voi määrittää: %1",
    'cert_add__unable_set_private_key' => "Yksityistä avainta ei voi määrittää: %1",
    'certificates_list__certificate_used_as_default' => "Yhtä varmenteista, jota olet poistamassa, käytetään paneelin varmenteena.",
    'certificates_list__certificates_assigned_on_ip' => "yksi tai useampi varmenne on määritetty IP-osoitteille/toimialueille.",
    'ch_pass__admin_pass' => "Vaihdetaan järjestelmänvalvojan salasana",
    'ch_pass__old_pass' => "Vanha salasana",
    'ch_pass__pass_confirm' => "Vahvista",
    'ch_pass__unable_change_admin_pass' => "Järjestelmänvalvojan salasanaa ei voi vaihtaa: %1",
    'check_mail_cycle__aliases' => "Sähköpostisilmukka havaittiin, osoite \"%1\" löytyy tämän sähköpostitilin aliaksista.",
    'check_mail_cycle__autoresponders' => "Postin kierto havaittu, osoite \"%1\" sisältyy tämän sähköpostitilin automaattisiin vastauksiin.",
    'check_mail_cycle__mail_groups' => "Sähköpostisilmukka havaittiin, osoite \"%1\" löytyy tämän sähköpostitilin postiryhmästä.",
    'check_mail_cycle__mail_name' => "Sähköpostisilmukka havaittiin, osoite \"%1\" vastaa tätä sähköpostitiliä.",
    'check_mail_cycle__redirect' => "Postin kierto havaittu, osoite \"%1\" vastaa tämän sähköpostitilin välittäjää.",
    'check_mail_dup__redirect' => "Kopion edelleenlähetys havaittu, osoite \"%1\" vastaa tämän sähköpostitilin edelleenlähetysosoitetta.",
    'check_mail_dup__mail_groups' => "Kopion edelleenlähetys havaittu, osoite \"%1\" sisältyy tämän sähköpostitilin postitusryhmään.",
    'check_maillist_cycle__admin' => "Postin kierto havaittu, järjestelmänvalvojan sähköposti \"%1\" vastaa postituslistan osoitetta.",
    'check_maillist_cycle__member' => "Postin kierto havaittu, osoite \"%1\" vastaa postituslistan osoitetta.",
    'chk_js__enter_login_and_passwd' => "Anna käyttäjänimi ja salasana.",
    'chk_js__enter_login_name' => "Anna käyttäjänimi.",
    'chk_js__enter_passwd' => "Anna salasana.",

    // end of shramko part

    // serge part
    'cl_ed__edit_cl' => "Asiakkaan %1 tilin tiedot",
    'cl_limits__cl' => "Asiakkaan %1 rajat",
    'cl_logo__setup_logo_pref' => "Aseta logo-ominaisuudet asiakkaalle %1",
    'cl_new__enter_new_cl_data' => "Anna uutta asiakasta koskevat tiedot",
    'cl_new__unable_to_sent_notification' => 'Käyttäjätili luotiin, ilmoituksen lähetys asiakkaalle kuitenkin epäonnistui: %1',
    'cl_perm__all_ip' => "Kaikki saatavilla olevat IP:t",
    'cl_perm__all_ip_based_hst_will_be_nb' => "Kaikki asiakkaan IP-pohjaiset isännöintitilit muutetaan nimeen perustuviksi.",
    'cl_perm__allow_client_create_domain' => "Kentät, jotka yrität valita, ovat käytettävissä vain asiakkaille, joilla on oikeus luoda toimialueita.",
    'cl_perm__allow_create_nb_w_ip' => "Asiakas voi luoda nimeen perustuvan isännöinnin käyttämällä kohdetta %1",
    'cl_perm__allow_creation_ip_based_hosting' => "Salli IP-pohjaisten isännöintitilien luonti",
    'cl_perm__available_ips' => "Saatavilla olevat IP:t",
    'cl_perm__change_limits' => "Raja-arvojen säätö",
    'cl_perm__cl_disk_space' => "Käytettävissä oleva levytila yhteensä",
    'cl_perm__cl_expiration' => "Asiakastilin voimassaolokausi",
    'cl_perm__cl_max_box' => "Postilaatikot",
    'cl_perm__cl_max_db' => "Tietokannat",
    'cl_perm__cl_max_dom' => "Toimialueet",
    'cl_perm__cl_max_maillists' => "Postituslistat",
    'cl_perm__cl_max_subdom' => "Alitoimialueet",
    'cl_perm__cl_max_traffic' => "Käytettävissä oleva liikenne yhteensä",
    'cl_perm__cl_max_wu' => "Internet-käyttäjät",
    'cl_perm__cl_mbox_quota' => "Tämän käyttäjätilin postilaatikon kokoraja",
    'cl_perm__current_maximum_exp_date' => "Toimialueen voimassaolokauden nykyinen enimmäisarvo on %1; pyydettiin %2.",
    'cl_perm__current_maximum_mailbox_quota' => "Tällä hetkellä määritetty levytilan raja postilaatikoiden tallennukseen tämän käyttäjätilin kohdalla on %1; pyydetty %2",
    'cl_perm__current_total_requested' => "Toimialueen rajojen nykyinen kokonaisarvo kohteelle %1 on %2; pyydettiin %3.",
    'cl_perm__current_total_requested_dom' => "Tälle asiakkaalle kuuluvan kohteen %1 nykyinen määrä on %2; pyydettiin %3.",
    'cl_perm__disk_space' => "levytilan enimmäismäärä",
    'cl_perm__dashboard_stdgui' => 'Käyttöliittymä',
    'cl_perm__dashboard' => 'Kotisivunäkymä',
    'cl_perm__stdgui' => 'Vakionäkymä',
    'cl_perm__manage_dashboard' => 'Kotisivun hallinta',
    'cl_perm__dashboard_and_stdgui' => 'Kotisivu- ja vakionäkymät ovat sallittuja',
    'cl_perm__dashboard_only' => 'Vain kotisivunäkymä on sallittu',
    'cl_perm__stdgui_only' => 'Vain vakionäkymä on sallittu',
    'cl_perm__edit_cl' => "Asiakkaan %1 käyttöoikeudet",
    'cl_perm__exp_date_exceeded' => "Voimassaolokausi, jonka yrität asettaa, ylittää tämän asiakkaan yksittäisten toimialueiden rajan.",
    'cl_perm__invalid_value' => "Virheellinen arvo, vain numerot ovat sallittuja.",
    'cl_perm__limit_disk_space' => "%1 Rajoita levytilan kokonaismäärä",
    'cl_perm__limit_expiration' => "%1 Rajoita asiakastilin voimassaolokausi",
    'cl_perm__limit_max_box' => "%1 Rajoita postilaatikoiden enimmäismäärä",
    'cl_perm__limit_max_db' => "%1 Rajoita tietokantojen enimmäismäärä",
    'cl_perm__limit_max_dom' => "%1 Rajoita toimialueiden enimmäismäärä",
    'cl_perm__limit_max_maillists' => "%1 Rajoita postituslistojen enimmäismäärä",
    'cl_perm__limit_max_subdom' => "%1 Rajoita alitoimialueiden enimmäismäärä",
    'cl_perm__limit_max_traffic' => "%1 Rajoita liikenteen kokonaismäärä",
    'cl_perm__limit_max_wu' => "%1 Rajoita Internet-käyttäjien enimmäismäärä",
    'cl_perm__limit_mbox_quota' => "%1 Aseta postilaatikon kiintiö",
    'cl_perm__limits_exceeded' => "Yksi tai useampi raja, jonka yrität asettaa, ylittyi jo tälle asiakkaalle kuuluvien yksittäisten toimialueiden määritettyjen rajojen mukaan.\nAsiakkaan kokonaisrajan on oltava suurempi tai yhtä suuri kuin toimialueen rajojen kokonaismäärä, joka on määritetty tälle asiakastilille.",
    'cl_perm__mailbox_quota_exceeded' => "Postilaatikoille varatun levytilan raja, jonka yrität asettaa, ylittää rajan, joka on määritetty tähän asiakastiliin liittyvissä yksittäisissä toimialueissa.",
    'cl_perm__mailbox_quota_exceeds_server_limit' => "Postilaatikoille varatun levytilan raja, jonka yrität asettaa, ylittää palvelintasolla määritetyn rajan.",
    'cl_perm__make_dumps' => "Varmuuskopioi ja palauta tiedot",

    'cl_perm__max_box' => "postilaatikoiden enimmäismäärä",
    'cl_perm__max_db' => "tietokantojen enimmäismäärä",
    'cl_perm__max_dom' => "toimialueet",
    'cl_perm__max_maillists' => "postituslistojen enimmäismäärä",
    'cl_perm__max_subdom' => "alitoimialueet",
    'cl_perm__max_traffic' => "liikenteen enimmäismäärä",
    'cl_perm__max_wu' => "internet-käyttäjien enimmäismäärä",
    'cl_perm__max_dom_aliases' => "toimialueen aliakset",
    'cl_perm__mbox_quota' => "postilaatikon kiintiö",
    'cl_perm__not_allow_create_nb_hst' => "Asiakas ei voi luoda nimeen perustuvaa isännöintiä.",
    'cl_perm__select_ip_addrs' => "Valitse IP-osoitteet",
    'cl_perm__this_ip_used_vrt_hst' => "Tämä IP-osoite on virtuaalisen isännöinnin käytössä.\nKun haluat poistaa tämän IP-osoitteen, poista isännöintipalvelu tai muuta sen tyyppi nimeen perustuvaksi.",
    'cl_perm__unable_off_ipb_creating' => "Asiakas on jo määrittänyt IP-pohjaisen isännöintipalvelun. Kun haluat poistaa tämän toiminnon asiakkaan käytöstä, poista valinta \"Toimialueen luonti\" -valintaruudusta tai poista kaikki IP-pohjaiset isännöintitilit.",
    'cl_perm__unable_off_nb_creating' => "Asiakas on jo määrittänyt nimeen perustuvan isännöintipalvelun. Kun haluat poistaa tämän toiminnon asiakkaan käytöstä, poista valinta \"Toimialueen luonti\" -valintaruudusta tai poista kaikki nimeen perustuvat isännöintitilit.",
    'cl_perm__unable_set_domain_limit' => "Toimialueiden enimmäismäärää ei voi rajoittaa: asiakkaalla on jo %1 toimialuetta",
    'cl_perm__unable_update_client_limitations' => "Asiakastilin rajoituksia ei voi muokata: %1",
    'cl_pref__edit_cl' => "Asiakkaan %1 omat asetukset",
    'class_anonftp__create_ftp_domain' => "Tälle dom_id-tunnukselle ei löydy virtuaalista FTP-toimialuetta, yritä luoda se ensin.",
    'class_anonftp__incoming_disk_space_should_be_lower' => "Levytilarajoitus, jonka yrität asettaa (%1), ei saa ylittää toimialuetasolla (%2) määritettyä kokonaislevytilarajoitusta.",
    'class_anonftp__invalid_input_only_digits' => "Määritetty arvo ei kelpaa, vain numerot ovat sallittuja.",
    'class_anonftp__unable_change_ownerships' => "Kiintiötiedoston omistusta tai oikeuksia ei voi muuttaa: %1",
    'class_anonftp__unable_copy_quota_file' => "Kiintiötiedoston kopiointi ei onnistu: %1",
    'class_anonftp__unable_get_disk_usage' => "Saapuvan hakemiston levytilan käyttötietoja ei voitu noutaa: %1",
    'class_anonftp__unable_parse_quota_file' => "Kiintiötiedostoa ei voi jäsentää.",
    'class_anonftp__unable_read_quota_file' => "Kiintiötiedostoa ei voi lukea: %1",
    'class_anonftp__unable_update_quota' => "Kiintiötä ei voi päivittää: saapuvan hakemiston tiedostot käyttävät %1 kt levytilasta, mikä ylittää uuden kiintiöarvon.",
    'class_anonftp__unable_write_temp_file' => "Ei voi kirjoittaa tilapäistiedostoon: %1",
    'class_bsdomain__warn_max_date__' => "Päättymispäivämäärä asetettiin arvoon %1",
    'class_cList__empty' => "Ei kohteita.",
    'class_cList__header' => "%1 (%2)",
    'class_cList__not_found' => "Tuloksia ei löytynyt kohteelle <b>\"%1\"</b> osiossa %2 (%3 / %4).",
    'class_cList__search_result' => "Hakutulos kohteelle <b>\"%1\"</b> kohteessa %2 (%3 / %4).",
    'class_client__client_creation_notification' => "Asiakkaan luontia koskeva ilmoitus.",
    'class_client__client_with_contact_name_already_exists' => "Asiakas, jonka nimi on %1, on jo olemassa.",
    'class_client__disk_space' => "Levytila",
    'class_client__invalid_max_dom' => "Toimialueen lukumäärän arvo virheellinen, vain numerot ovat sallittuja.",
    'class_client__limit_exceed' => "Vaadittua määrää %1 ei voida määrittää, koska se ylittäisi asiakkaan %2 tilin (%3) määritykset. Jos haluat määrittää enemmän resursseja, valitse Asiakkaat > Asiakkaan nimi > Rajat ja muuta vaadittuja määrityksiä. Palaa sitten tähän näyttöön ja yritä säätää osuudet uudelleen.",
    'class_client__limit_exceed_unlimited' => "Jos haluat määrittää rajoittamattoman määrän resursseja (%1), valitse ensin Asiakkaat > Asiakkaan nimi > Rajat, ja valitse vaadittua resurssityyppiä vastaava Rajoittamaton-ruutu. Palaa sitten tähän näyttöön ja yritä säätää osuudet uudelleen.",
    'class_client__max_box' => "Postilaatikot",
    'class_client__max_db' => "Tietokannat",
    'class_client__max_maillists' => "Postituslistat",
    'class_client__max_subdom' => "Alitoimialueet",
    'class_client__max_traffic' => "Liikenteen enimmäismäärä",
    'class_client__max_wu' => "Internet-käyttäjät",
    'class_client__max_dom_aliases' => "Toimialueen aliakset",
    'class_client__mbox_quota' => "Postilaatikon kiintiö",
    'class_client__unable_define_cl_status' => "Asiakastilin tilaa ei voi määrittää: %1",
    'class_client__unable_define_inactive_dom' => "Ei-aktiivisia toimialueita %1 ei voi määrittää.",
    'class_client__unable_del_ip' => "IP-osoitteita ei voida poistaa: %1",
    'class_db__db_name_not_set' => "Tietokannan nimeä ei ole määritetty.",
    'class_db__db_not_exist_for_curr_dom' => "Tietokantaa ei ole tälle toimialueelle.",
    'class_db__invalid_db_or_dom_name' => "Toimialue tai tietokannan tunnus on virheellinen tai tietokannan nimeä ei ole määritetty.",
    'class_db__invalid_pass' => "Salasana ei kelpaa.",
    'class_db__mailgrp_member_exist' => "Postiryhmän jäsen on jo olemassa.",
    'class_db__access_hosts_notsupport' => 'Käyttöä koskevien isäntien asetusta ei tueta tälle tietokantatyypille',
    'class_db__unable_add' => 'Käytön isäntätietueen lisäys ei onnistu: %1',
    'class_db__unable_del' => 'Käytön isäntätietueen poisto ei onnistu: %1',
    'class_db__inc_user_not_exist' => 'Tietokannan käyttäjää "%1" ei ole',
    'class_db__inc_access_record_exist' => 'Tämä käyttötietue on jo olemassa',
    'class_db__inc_access_record_not_exist' => 'Määritettyä käyttötietoetta ei ole olemassa',
    'class_db__inc_unable_del_last_record' => 'Viimeisen käytön isännän tietuetta ei voitu poistaa',
    'class_domtmpleditform__dns_master' => "Perus",
    'class_domtmpleditform__dns_slave' => "Orja",
    'class_domtmpleditform__dns_type' => "Toimialueen DNS-vyöhykkeen tyyppi",
    'class_traffichistory__no_data_available' => "Ei tietoja käytettävissä.",
    'class_traffichistory__traffic_usage' => "Liikenteen kuormitus",
    'clienttrafficlist_header' => "Toimialueiden liikenne",
    'clienttrafficlist_header_of_client__' => "Asiakkaan %1 toimialueiden liikenne",
    'cmd_dns__a_dns_record_already_exist' => "Tämä tietue voi olla ristiriidassa vyöhykkeen A -tietueeseen.",
    'cmd_dns__domain_last_ns' => 'Toimialueen viimeisintä NS DNS -tietuetta ei voida poistaa.',
    'cmd_dns__canonical_dom_name_is_invalid' => "Kanoninen toimialueen nimi on virheellinen.",
    'cmd_dns__cname_dns_record_already_exist' => "Tämä tietue voi olla ristiriidassa vyöhykkeen CNAME -tietueeseen.",
    'cmd_dns__cname_in_rr_combination' => 'DNS-vyöhykkeessä on DNS-tietueiden virheellinen yhdistelmä',
    'cmd_dns__cname_coexist_with_data' => 'CNAME DNS -vyöhyketietuetta ei voi käyttää muiden DNS-tietueiden kanssa samassa vyöhykkeessä.',
    'cmd_dns__dns_record_type_is_invalid' => "DNS-tietuetyyppi on virheellinen.",
    'cmd_dns__ext_host_is_not_resolved' => "Kanoninen nimi %1 ei yhdistä A- tai AAAA-tietueeseen.",
    'cmd_dns__domain_restore_dns_zone_failed_add_record' => '%1 -tietuetta ei voida lisätä alueelle %2: %3',
    'cmd_dns__mail_dom_name_is_invalid' => "Mail Exchange Server -palvelimen nimi ei kelpaa.",
    'cmd_dns__mx_priority_is_invalid' => "MX-prioriteetti on virheellinen.",
    'cmd_dns__name_server_is_invalid' => "Nimipalvelin on virheellinen.",
    'cmd_dns__network_mask_should_be_24_16_or_8' => "Verkkopeitteen arvon on oltava 24, 16 tai 8.",
    'cmd_dns__this_dns_record_already_exists' => "Tämä A DNS -tietue on jo luotu.",
    'cmd_dns__unable_add_record' => "Tietueen '%1' lisäys ei onnistu: %2",
    'cmd_dns__unable_add_a_record' => "A-tietuetta ei voi lisätä: %1",
    'cmd_dns__unable_add_cname_record' => "CNAME-tietuetta ei voi lisätä: %1",
    'cmd_dns__unable_add_dns_record' => "DNS-tietuetta ei voi lisätä: %1",
    'cmd_dns__unable_add_ext_ns_record' => "EXT_NS -tietuetta ei voi lisätä: %1",
    'cmd_dns__unable_add_ns_record' => "NS-tietuetta ei voi lisätä: %1",
    'cmd_dns__unable_add_ptr_record' => "PTR-tietuetta ei voi lisätä: %1",
    'cmd_dns__unable_add_txt_record' => "TXT-tietueen lisäys ei onnistu: %1",
    'cmd_dns__unable_create_dns_zone' => "DNS-vyöhykettä %1 ei voi luoda",
    'cmd_dns__unable_define_dns_record' => "DNS-tietuetta %1 ei voi määrittää.",
    'cmd_dns__unable_get_default_dns_zone_status_set_true' => "DNS-oletusvyöhykkeen tilaa ei voi noutaa: %1",
    'cmd_dns__unable_insert_a_record' => "A-tietuetta ei voi lisätä: %1",
    'cmd_dns__unable_insert_mx_record' => "MX-tietuetta ei voi lisätä: %1",
    'cmd_dns__unable_insert_ns_record' => "NS-tietuetta ei voi lisätä: %1",
    'cmd_dns__unable_set_dns_zone_status' => "DNS-vyöhykkeen tilaa ei voi määrittää: %1",
    'cmd_domains__dom_already_exists' => "Toimialue %1 on jo olemassa.",
    'cmd_domains__dns_record_already_exists' => "Toimialuetta %1 ei voida luoda, koska isäntään %1 kohdistuva DNS-tietue on jo olemassa.",
    'cmd_domains__dom_already_exists1' => "Tässä toimialueessa on %2 alitoimialuetta. Toimialue %1 on jo luotu.",
    'cmd_domains__dom_already_exists2' => "alitoimialue %1 on jo olemassa.",
    'cmd_domains__dalias_already_exists' => "Tämä alias on jo olemassa.",
    'cmd_domains__domain_alias_already_exists' => 'Toimialueen alias, jolla on määritetty nimi, on jo olemassa.',
    'cmd_domains__unable_del_mail_for_dom' => "Toimialueen postipalveluja ei voi poistaa: %1",
    'cmd_domains__unable_delete_anonymous_ftp' => "Toimialueen anonyymiä FTP-tiliä ei voi poistaa: %1",
    'cmd_domains__unable_update_dom_param' => "Toimialueen parametreja ei voi päivittää: %1",
    'cmd_domains__unable_rename_client_exist' => "toimialueen järjestelmänvalvojan käyttäjänimi on jo käytössä.",
    'cmd_hosting__hst_type_is_not_physical_hst' => "Isännöintityyppi ei ole fyysinen.",
    'cmd_hosting__unable_create_user' => "Käyttäjää %2 ei voi luoda: %1",
    'cmd_hosting__unable_define_ip_addr_for_name_based_virtual_hosts' => "Nimeen perustuville virtuaalisille isännille ei voi määrittää IP-osoitetta: %1",
    'cmd_hosting__unable_del_old_hst' => "Aiemmin määritettyä isännöintiä ei voi poistaa: %1",
    'cmd_hosting__unable_del_protected_directory' => "Suojattua hakemistoa ei voi poistaa: %1.",
    'cmd_hosting__unable_del_web_user' => "Internet-käyttäjää ei voi poistaa: %1",
    'cmd_hosting__unable_make/update_virtual_host' => "Virtuaalista isäntää ei voi luoda tai päivittää: %1",
    'cmd_hosting__unable_make_frame_forward_hst' => "Kehyksen edelleenlähetyksen isännöntiä ei voi määrittää.",
    'cmd_hosting__unable_rebuild_ftp_config' => "proftpd-määritystiedostoa ei voi muodostaa uudelleen: %1.",
    'cmd_hosting__unable_set_up_ssl' => "SSL/TLS:ää ei voi asettaa: %1.",
    'cmd_hosting__unable_unprotect_ssl_directory' => "SSL/TLS-hakemiston suojausta ei voi poistaa: %1.",
    'cmd_hosting__unable_update_dest_url' => "URL-kohdeosoitetta %1 ei voi päivittää.",
    'cmd_hosting__unable_update_dns_zone_for_dom_unable_exec_util' => "DNS-vyöhykettä ei voi päivittää toimialueelle: apuohjelman suoritus epäonnistui.",
    'cmd_hosting__unable_update_ftp_passwd' => "FTP-salasanaa %1 ei voi päivittää.",
    'cmd_hosting__unable_update_user' => "Käyttäjää %2 ei voi päivittää: %1",
    'cmd_hosting__unknown_hst_type' => "Tuntematon isännöintityyppi.",
    'cmd_hosting__you_not_have_permission_del_hst' => "Sinulla ei ole oikeuksia lopettaa isännöintipalvelua.",
    'cmd_mail__autoresponder__not_configured' => "Tämän sähköpostilin automaattista vastausta ei ole määritetty",
    'cmd_mail__addr_already_used_in_mail_redirect' => "Osoitetta %1 käytetään jo postin edelleenlähetykseen.",
    'cmd_mail__alias_already_exists' => "alias on jo olemassa.",
    'cmd_mail__autoresp_id_and_mailname_id_not_match' => "Automaattisen vastauksen tunnus ja sähköpostitilin tunnus eivät täsmää.",
    'cmd_mail__autoresp_id_is_undefined' => "Automaattisten vastausten tunnusta ei ole määritetty.",
    'cmd_mail__mail_alias_already_exists_in_mail_name' => "Sähköpostitilillä %1 on jo tämänniminen sähköpostialias.",
    'cmd_mail__mail_name_already_exists_in_maillists' => "Sähköpostitili %1 on jo tilattu tälle postituslistalle.",
    'cmd_mail__mail_name_alredy_exist_in_dom' => "Sähköpostitili %1 on jo olemassa tässä toimialueessa.",
    'cmd_mail__mail_name_not_exist' => "Sähköpostitiliä ei ole.",
    'cmd_mail__mail_name_passwd_part' => "Salasana ei saa sisältää sähköpostitilin nimeä.",
    'cmd_mail__maillist_already_exist_in_this_dom' => "Postituslista %1 on jo olemassa tässä toimialueessa.",
    'cmd_mail__mailname_already_exist_in_mg' => "Sähköpostitili %1 on jo postiryhmässä.",
    'cmd_mail__mailname_already_exist_in_this_dom' => "Sähköpostitili %1 on jo olemassa tässä toimialueessa.",
    'cmd_mail__mailname_already_exists' => "Sähköpostitili on jo olemassa.",
    'cmd_mail__mailname_is_invalid' => "Sähköpostitilin nimi %1 ei kelpaa.",
    'cmd_mail__mailname_unable_update' => "Sähköpostitilin ominaisuuksia ei voi päivittää:",
    'cmd_mail__max_autoresp_reached_for_this_dom' => "Tämän toimialueen automaattisten vastausten enimmäismäärä saavutettiin.",
    'cmd_mail__max_mail_groups_num_has_been_reached_for_this_dom' => "Tämän toimialueen postiryhmien enimmäismäärä saavutettiin.",
    'cmd_mail__max_num_of_redirects_has_been_reached_for_this_dom' => "Välittimien maksimimäärä saavutettiin tämän toimialueen kohdalla.",
    'cmd_mail__max_postboxes_num_has_been_reached' => "Postilaatikoiden enimmäismäärä saavutettiin.",
    'cmd_mail__no_members_specified' => "jäseniä ei ole määritetty.",
    'cmd_mail__the_passwd_is_too_simple_choose_another' => "Salasana on liian yksinkertainen, valitse toinen salasana.",
    'cmd_mail__this_addr_already_exist_in_mg_or_mn' => "Tämä sähköpostiosoite on jo käytössä.",
    'cmd_mail__unable_define_autoresp_id' => "Automaattisten vastausten tunnusta %1 ei voi määrittää.",
    'cmd_mail__unable_update_mail_for_dom' => "Postipalvelun asetuksien muuttaminen toimialueelle %1 epäonnistui",
    'cmd_mail__unable_del_mail_for_dom' => "Postipalvelua ei voi poistaa toimialueesta %1.",
    'cmd_mail__unable_del_mail_redirection' => "Postin edelleenlähetyspalvelun %1 poisto ei onnistu.",
    'cmd_mail__unable_remove_autoresp' => "Automaattisia vastauksia ei voi poistaa: %1",
    'cmd_mail__unable_remove_mail_group_members' => "Postiryhmän jäseniä ei voi poistaa: %1",
    'cmd_mail__unable_turn_off_mail_group' => "Postiryhmää ei voitu poistaa käytöstä: %1",
    'cmd_mail__unable_update_mail_redirect' => "Postin edelleenlähetyspalvelun %1 uudelleen määritys ei onnistu.",
    'cmd_mail__uploaded_file_is_too_big' => "Ladattu tiedostokoko on liian suuri.",
    'cmd_mail__additionally' => "Lisäksi:",
    'cmd_pd__invalid_login' => "Virheellinen käyttäjätunnus.",
    'cmd_pd__this_user_already_exist' => "Tämä käyttäjä on jo olemassa.",
    'cmd_pd__unable_define_hst_type' => "Isännöintityyppiä ei voi määrittää.",
    'cmd_pd__unable_upd_pd_usr' => "Suojatun hakemiston käyttäjäominaisuuksia ei voi päivittää: %1.",
    'cmd_pd__user_is_undefined' => "Käyttäjää ei ole määritetty.",
    'cmd_server__no_enough_free_disk_space' => "Levytila ei riitä.",
    'cmd_server__old_passwd_is_incorrect_please_try_again' => "vanha salasana on väärä. Yritä uudelleen.",
    'cmd_web_usr__max_web_users_reached_for_this_dom' => "tämän toimialueen Internet-käyttäjien enimmäisraja on saavutettu.",
    'cmd_web_usr__unable_create_user' => "järjestelmäkäyttäjän luonti ei onnistunut: %1",
    'cmd_web_usr__unable_define_max_web_users_limit' => "Internet-käyttäjien enimmäisrajan määritys ei onnistunut: %1",
    'cmd_web_usr__user_already_exists' => "Käyttäjä on jo olemassa.",
    'cmd_web_usr__web_user_name_is_invalid' => "Internet-käyttäjän nimi %1 on virheellinen.",
    'cmd_web_usr__web_user_not_exist' => "Internet-käyttäjää ei ole.",
    'common_func__exec_bad_argument' => "exec-argumentti ei saa sisältää heittomerkkejä.",
    '__eol' => 'Rivinvaihdot',
    'eol__binary_file' => 'Rivinvaihdon tyyliä ei voida muuttaa binaaritiedostossa.',
    'comp_info__header' => 'Komponentit',
    'comp_info__comp_name' => "Komponentin nimi",
    'comp_info__comp_disabled' => 'Sammutettu',
    'comp_info__comp_active' => 'Akt.',
    'comp_info__comp_not_configured' => 'Ei määritetty',
    'comp_info__comp_not_started' => 'Ei käynnistetty, tarkista komponentin asetukset',
    'comp_info__comp_version' => "Osaversio",
    'comp_info__integration_error' => "Integrointivirhe",
    'comp_info__title' => "Pleskin komponentit",
    'comp_info__service_name' => "Palvelu",
    'comp_info__last_updated' => '(viimeksi päivitetty: %1)',
    'cp_access_admin_deny' => "Järjestelmänvalvojan pääsy osoitteesta '%1' on rajoitettu käytössä olevan IP-käyttörajoituskäytännön mukaisesti.",
    'create_domain_warn__' => "Seuraavat poikkeukset tehtiin toimialueen luonnin aikana:",
    'create_domain__client_select' => 'Valitse asiakas, jolle toimialue luodaan',

    'dashboard__nav_button_name' => "Kotisivu",
    'dalias__list_title' => 'Toimialueen %1 toimialueen aliakset',
    'dalias__list_legend' => 'Toimialueen aliakset',
    'dalias__list_header' => 'Toimialueen aliakset',
    'dalias__list_status' => 'S',
    'dalias__list_name' => 'Toimialueen aliasnimi',
    'dalias__list_ascii_name' => 'ASCII-muodossa',
    'dalias__remove_title' => 'Seuraavat toimialueen %1 toimialueen aliakset poistetaan:',
    'dalias__select_domain_aliases_to_remove' => 'Valitse poistettavat toimialueen aliakset.',
    'dalias__mail_turn_on_failed' => 'Postipalvelua ei voida ottaa käyttöön: %1',
    'dalias__web_turn_on_failed' => 'Verkkopalvelua ei voida ottaa käyttöön: %1',
    'db_usr_edit__db_usr_name_old' => "Vanha tietokannan käyttäjän nimi",
    'database_server_edit_form__cannot_infer_type' => 'Yhteysmenetelmää ei voida päätellä annetuista tiedoista. Määritä "127.0.0.1" tietokantapalvelimen isäntänimeksi ja muodosta yhteys TCP/IP:n kautta annetulla portilla, tai jätä porttikenttä tyhjäksi käyttääksesi Unix-pistoketta "%1".',
    'database_server_edit_form__duplicate' => 'Tietokantapalvelin, joka käyttää tätä isäntäosoitteen ja portin numeron yhdistelmää, on jo rekisteröity.',
    'database_server_edit_form__host_is_invalid' => 'Määritetty isäntänimi ei ole kelvollinen.',
    'database_server_edit_form__port_is_invalid' => 'Määritetty porttinumero ei ole kelvollinen.',
    'database_server_error__consult_admin' => 'Ota yhteys palvelimen järjestelmänvalvojaan.',
    'database_server_error__last__connection_failed' => 'Viimeinen yritys ohjata tätä tietokantapalvelinta epäonnistui verkko-ongelmien vuoksi.',
    'database_server_error__last__permission_denied' => 'Viimeinen yritys ohjata tätä tietokantapalvelinta epäonnistui, koska annetulla tilillä ei ole järjestelmänvalvojan oikeuksia.',
    'database_server_error__last__credentials_not_set' => "Tämän palvelimen viimeinen yhdistysyritys epäonnistui, koska voimassa olevaa järjestelmänvalvojan käyttäjänimeä ja salasanaa ei annettu.",
    'database_server_error__last__other_error' => 'Viimeinen yritys ohjata tätä tietokantapalvelinta epäonnistui.',
    'database_server_error__real__connection_failed' => 'Yhteys tietokantapalvelimeen epäonnistui verkko-ongelmien vuoksi:',
    'database_server_error__real__permission_denied' => 'Yhteys tietokantapalvelimeen epäonnistui, koska annetulla tilillä ei ole järjestelmänvalvojan oikeuksia:',
    'database_server_error__real__duplicate_object' => 'Yhteys tietokantapalvelimeen epäonnistui nimiristiriidan vuoksi:',
    'database_server_error__real__unacceptable_name' => 'Yhteys tietokantapalvelimeen epäonnistui virheellisen objektin nimen vuoksi:',
    'database_server_error__real__unacceptable_password' => 'Yhteys tietokantapalvelimeen epäonnistui kelvottoman salasanan vuoksi:',
    'database_server_error__real__credentials_not_set' => "Plesk ei voi muodostaa yhteyttä tietokantapalvelimeen, koska voimassa olevaa järjestelmänvalvojan käyttäjänimeä ja salasanaa ei ole määritetty.",
    'database_server_error__real__other_error' => 'Yhteys tietokantapalvelimeen epäonnistui:',
    'database_server_error__test__connection_failed' => 'Testiyhteys tietokantapalvelimeen epäonnistui verkko-ongelmien vuoksi:',
    'database_server_error__test__permission_denied' => 'Testiyhteys tietokantapalvelimeen epäonnistui, koska annetulla tilillä ei ole järjestelmänvalvojan oikeuksia:',
    'database_server_error__test__duplicate_object' => 'Testiyhteys tietokantapalvelimeen epäonnistui nimiristiriidan vuoksi:',
    'database_server_error__test__unacceptable_name' => 'Testiyhteys tietokantapalvelimeen epäonnistui virheellisen objektin nimen vuoksi:',
    'database_server_error__test__unacceptable_password' => 'Testiyhteys tietokantapalvelimeen epäonnistui kelvottoman salasanan vuoksi:',
    'database_server_error__test__credentials_not_set' => "Tämän palvelimen testiyhteys epäonnistui, koska voimassa olevaa järjestelmänvalvojan käyttäjänimeä ja salasanaa ei annettu.",
    'database_server_error__test__other_error' => 'Testiyhteys tietokantapalvelimeen epäonnistui:',

    'db__create_new_db' => "Lisää tietokanta",
    'db__db_add' => "Lisää tietokanta",
    'db__db_for_dom' => "Verkkosivuston %1 tietokannat",
    'db__db_id_undefined' => "Tietokannan tunnusta ei ole määritetty.",
    'db__db_name' => "Tietokannan nimi",
    'db__db_not_exist' => "Tietokantaa ei ole.",
    'db__db_type' => "Tyyppi",
    'db__db_server' => "Tietokantapalvelin",
    'db_server_not_exist' => "Tietokantapalvelinta ei ole.",
    'db__db_user_not_exist' => "Tietokannan käyttäjää ei ole.",
    'db__domain_not_exist' => "Toimialuetta ei ole.",
    'db__enter_db_name' => "Kirjoita uusi tietokannan nimi.",
    'db__invalid_db_id' => "Tietokannan tunnus ei kelpaa.",
    'db__invalid_db_name' => "Tietokannan nimi on virheellinen. Tietokannan nimi saa sisältää vain latinalaisia aakkosia, numeroita, ala- tai ajatusviivan. Tietokannan nimessä ei saa olla yli 63 merkkiä.",
    'db__max_db_reached_for_dom' => "Tämän toimialueen tietokantojen enimmäismäärä on saavutettu.",
    'db__max_mssql_db_reached_for_dom' => "Microsoft SQL Server -tietokantojen maksimimäärä on saavutettu tämän toimialueen kohdalla",
    'db__postgres_not_connect_for_admin' => "Yhteyden muodostaminen PostgreSQL:ään ei onnistu. Kytke PostgreSQL:n tuki päälle palvelimen hallintasivulla.",
    'db__postgres_not_connect_for_client' => "Yhteyden muodostaminen PostgreSQL:ään ei onnistu. Kysy ohjeita järjestelmänvalvojalta.",
    'db__remove_db_on_domain' => "Seuraavat verkkosivuston %2 tietokannat, joiden omistaja on %1, poistetaan:",
    'db__remove_db_on_domain_of_cl' => "Seuraavat toimialueen %2 tietokannat, joiden omistaja on %1, poistetaan:",
    'db__remove_db_linked_resource' => 'Tämä tietokanta on verkkosovelluksen käytössä. Se voidaan poistaa vasta sitten, kun tämän verkkosovelluksen asennus on poistettu.',
    'db__remove_db_users' => "Seuraavat asiakkaan %1 omistaman verkkosivuston %2 tietokannan käyttäjät %3 poistetaan:",
    'db__remove_db_users_of_cl' => "Seuraavat asiakkaan %1 omistaman verkkosivuston %2 tietokannan käyttäjät %3 poistetaan:",
    'db__select_db_for_remove' => "Valitse poistettavat tietokannat.",
    'db__select_db_users_for_remove' => "Valitse poistettavat tietokannan käyttäjät.",
    'db__unable_create_db_user' => "Tietokannan käyttäjää ei voi luoda: %1",
    'db__unable_define_db_name' => "Tietokannan nimeä ei voi määrittää: %1",
    'db__unable_define_db_user' => "Tietokannan käyttäjää ei voi määrittää: %1",
    'db__unable_define_db_users' => "Tietokannan käyttäjiä ei voi määrittää: %1",
    'db__unable_select_dom_name' => "Toimialueen nimeä ei voi valita: %1",
    'db_edit__db_for_dom' => "Tietokannan %1 käyttäjät toimialueessa %2",
    'db_edit__invalid_db_name' => "Tietokannan nimi on virheellinen.",
    'db_edit__no_users' => "Ei käyttäjiä, joilla on tämän tietokannan tunnistetiedot.",
    'db_edit__unable_define_db_usrs' => "Tietokannan käyttäjiä ei voi määrittää: %1",
    'db_edit__unable_select_db_usr' => "Tietokannan käyttäjän valitseminen ei onnistu.",
    'db_edit__db_user_password_for_' => "Syötä tietokannen käyttäjänä %1 kirjattava salasana",
    'db_list__tab_title_db_type' => "T",
    'db_usr_edit__add_db_usr' => "Lisää tietokannan käyttäjä",
    'db_usr_edit__db_usr_name' => "Tietokannan käyttäjän nimi",
    'db_usr_edit__edit_db_usr' => "Määritä tietokannan käyttäjätilin tunnistetiedot",
    'db_usr_edit__for_db' => "tietokannassa %1",
    'db_usr_edit__not_create_pass' => "Tämän toiminnon aikana luodaan tietokannan käyttäjätili ilman salasanaa.\nHaluatko luoda käyttäjän määrittämättä salasanaa?",
    'dbuser__only_one_user_can_be_default' => "Vain yksi käyttäjä voidaan asettaa oletukseksi.",
    'db_server__cannot_delete_default' => "Oletustietokantapalvelinta ei voi poistaa.",
    'db_server__cannot_delete_local' => "Paikallista tietokantapalvelinta ei voi poistaa.",
    'db_server__cannot_delete_used' => 'Tietokantapalvelinta ei voi poistaa, kun se isännöi tietokantoja tai tietokantojen käyttäjiä.',
    'demo__disabled_in_demo' => "Tätä toimintoa ei tueta esittelyversiossa.",
    'defaultcomponents__title' => "Oletuskomponenttien valitseminen",
    'defaultcomponents__select_default' => "Valitse oletuskomponentti %1",//to check
    'defaultcomponents__not_installed' => "(ei asennettu)",
    'defaultcomponents__not_configured' => "(ei määritetty)", // to check
    'defaultcomponents__not_opted_to_install_support_files' => "Jotkin palvelukategoriat sisältävät virheellisiä valintoja, tai valintoja ei ole tehty.",
    'defaultcomponents__depends_on' => "(tarvitaan %1)",
    'defaultcomponents__parameters' => "Kohteen %1 parametrit",
    'component_name__antivirus' => "Virustentorjunta",
    'component_name__database' => "SQL Server",
    'component_name__sqladmin' => "MySQL Webadmin",
    'component_name__sqladminmysql' => "MySQL Webadmin",
    'component_name__dnsserver' => "DNS-palvelin",
    'component_name__firewall' => "Palomuuri",
    'component_name__ftpserver' => "FTP-palvelin",
    'component_name__java' => "Java",
    'component_name__mailserver' => "Postipalvelin",
    'component_name__local_mailserver' => "Paikallinen sähköpostipalvelin",
    'component_name__psa' => "Plesk",
    'component_name__script' => "WWW-komentosarjat",
    'component_name__spamfilter' => "Roskapostisuodatin",
    'component_name__stats' => "Verkkosivuston tilastot",
    'component_name__stunnel' => "SSL/TLS-paketoija",
    'component_name__webmail' => "WWW-sähköpostipalvelu",
    'component_name__webpublish' => "Julkaiseminen Webissä",
    'component_name__webserver' => "WWW-palvelin",
    'dns__dns_record_invalid_values' => 'Virheelliset DNS-tietuearvot määritettiin: %1: %2',
    'dns__dns_record_not_found' => 'DNS-tietuetta ei löydy',
    'dns__dns_zone_invalid_values' => 'Virheelliset DNS-vyöhykeparametrit määritettiin.',

    'dns__soa_mname_title' => 'Ensisijainen nimipalvelin',
    'dns__soa_mname_legend' => 'Nimipalvelin',
    'dns__soa_mname_autoselect' => '(Automaattinen valinta)',

    'dns__dns_zone_default' => 'Vyöhykkeen oletukset',
    'dns__dns_soa_legend' => 'SOA-tietue',
    'dns__dns_soa_ttl' => 'TTL',
    'dns__dns_soa_refresh' => 'Päivitä',
    'dns__dns_soa_retry' => 'Yritä uudelleen',
    'dns__dns_soa_expire' => 'Umpeutuminen',
    'dns__dns_soa_minimum' => 'Vähintään',
    'dns__dns_soa_ttl_error' => 'TTL-arvo ei kelpaa. Arvo voi olla 1 sekunnista 68 vuoteen.',
    'dns__dns_soa_refresh_error' => 'Päivitysarvo ei kelpaa. Arvo voi olla 1 sekunnista 68 vuoteen.',
    'dns__dns_soa_retry_error' => 'Uudelleenyrityksen arvo ei kelpaa. Arvo voi olla 1 sekunnista 68 vuoteen.',
    'dns__dns_soa_expire_error' => 'Vanhentumisarvo ei kelpaa. Arvo voi olla 1 sekunnista 68 vuoteen.',
    'dns__dns_soa_minimum_error' => 'Vähimmäisarvo ei kelpaa. Arvo voi olla 1 sekunnista 68 vuoteen.',
    'dns__dns_default_title' => 'Palauta DNS-vyöhyke',
    'dns__dns_default_legend' => "Vyöhykkeen palautusvaihtoehdot",
    'dns__dns_default_text' => "Valitse DNS-vyöhykkeen palautuksen asetukset, vahvista ne ja napsauta OK.",
    'dns__dns_default_confirm' => "Vahvista DNS-vyöhykkeen palautus",
    'dns__dns_default_confirm_required' => "Vahvista DNS-vyöhykkeen mallin palautus",
    'dns__dns_default_invalid_ip_address' => 'Virheellinen IP-osoite',

    'dns_t__dns_default_title' => 'Palauta DNS-vyöhykkeen oletusmalli',
    'dns_t__dns_default_legend' => "Palautusvaihtoehdot",
    'dns_t__dns_default_text' => 'Vahvista, että haluat palauttaa DNS-vyöhykkeen mallin oletusmääritykset.',
    'dns_t__dns_default_confirm' => "Vahvista palautus",
    'dns_t__dns_default_confirm_required' => "Vahvista DNS-vyöhykkeen mallin palautus",
    'dns_t__add_dns_record_master_title' => 'Lisää resurssitietue vyöhykkeen malliin',
    'dns_t__add_dns_record_off_title' => 'Lisää nimipalvelin',
    'dns_t__edit_dns_record_master_title' => 'Muokkaa resurssitietuetta',
    'dns_t__edit_dns_record_off_title' => 'Muokkaa nimipalvelinta',
    'dns_t__edit_dns_record_ttl' => 'TTL',

    'dns__dns_zone_off_remove_title' => "Seuraavat resurssitietueet poistetaan vyöhykkeestä %1:",
    'dns__dns_zone_master_remove_title' => "Poistetaan resurssitietueita DNS-vyöhykkeestä %1",
    'dns__dns_zone_slave_remove_title' => "Seuraavat ensisijaiset nimipalvelintietueet kohteelle %1 poistetaan:",
    'dns_add__param_ttl' => "TTL",
    'dns_add__enter_spf' => 'Anna tietuemerkkijono',
    'dns_add__is_spf_syntax' => 'SPF-tietue',
    'dns_add__spf_value_is_invalid' => "SPF-tietueen arvo on virheellinen, sen alussa on oltava 'v=spf'",
    'dns__dns_zone_status' => "DNS-vyöhykkeen tila.",
    'dns__dns_zone_template' => 'DNS-asetukset',
    'dns__host' => "Isäntä",
    'dns__ttl' => "TTL",
    'dns__invalid_ip_address' => "Uuden DNS-pääpalvelimen IP-osoite on virheellinen tai tyhjä.",
    'dns__ip_address' => "IP-osoite",
    'dns__master_dns_type' => "on DNS-pääpalvelin",
    'dns__masters' => "DNS-pääpalvelimet",
    'dns__soa_minimum_too_large' => 'Negatiivisten vastauksien saaminen yli kolmen tunnin ajan ei ole suositeltavaa.',
    'dns__select_masters_to_remove' => "Valitse poistettavat ensisijaiset DNS-palvelimet.",
    'dns__select_template_record_to_remove' => 'Valitse poistettavat DNS-tietueiden mallit.',
    'dns__nameservers_for_domain' => "Toimialueen nimipalvelimet",
    'dns__ns' => "Nimipalvelin",
    'dns__ns_record' => "Nimipalvelimet",
    'dns__remove_dns_zone_of_domain__' => "DNS-tietueiden poisto toimialueesta %1",
    'dns__remove_dns_zone_template__' => "Seuraavat DNS-tietueet poistetaan mallista:",
    'dns__remove_this_dns_record?' => "Haluatko varmasti poistaa tämän DNS-tietueen?",
    'dns__restore_default' => "Palautetaan DNS-vyöhyke mallin avulla",
    'dns__restore_default_confirm' => "DNS-vyöhykkeen palautus poistaa valitun DNS-vyöhykkeen määrityksen. Haluatko silti jatkaa?",
    'dns__restore_default_error' => "Virhe DNS-vyöhykkeen palauttamisen aikana:",
    'dns__slave_dns_type' => "on toissijainen DNS-palvelin",
    'dns__soa_refresh_value_is_small' => 'Päivitysvälin arvo on alle tunti, tämä voi lisätä huomattavasti palvelimen liikennettä ja resurssien käyttöä. Haluatko käyttää tätä arvoa edelleen?',
    'dns__subdomain_dns_rec_removed' => "A-tietue poistettiin alitoimialueen vyöhykkeestä %1.",
    'dns__zone_switched_off_no_ns' => "Vyöhyke poistettiin käytöstä, koska NS-tietuetta %1 ei ole olemassa, se tulee esiasettaa vyöhykkeellä. Lisää tietue vyöhykkeeseen valitsemalla Lisää tietue -painike.",
    'dns__cant_switch_on_no_ns' => "Vyöhykettä ei voida ottaa käyttöön, koska NS-tietuetta %1 ei ole olemassa, se tulee esiasettaa vyöhykkeellä. Lisää tietue vyöhykkeeseen valitsemalla Lisää tietue -painike.",
    'dns__type' => "Tietuetyyppi",
    'dns__unable_activate/deactivate_dns' => "DNS:ää ei voi ottaa käyttöön/poistaa käytöstä: %1",
    'dns__unable_add_dns_master_duplicate_entry' => "DNS-pääpalvelinta ei voi lisätä: kaksoismerkintä.",
    'dns__unable_add_dns_master_local_ip' => "IP-osoitetta ei voida lisätä DNS-pääpalvelimeen: tämä tietue tulee luoda etäpalvelimeen.",
    'dns__unable_define_dns_record' => "DNS-tietuetta ei voi määrittää: %1",
    'dns__unable_get_dns_template_status' => "DNS-mallin tilaa ei voi noutaa.",
    'dns__unable_remove_dns_rec' => "DNS-tietuetta ei voi poistaa: %1",
    'dns__val' => "Arvo",
    'dns__warnings__' => "DNS-vyöhykkeen muuntamisen tulos:",
    'dns__you_not_have_perm_manage_dns' => "Sinulla ei ole oikeutta hallita tämän toimialueen DNS-vyöhykettä.",
    'dns__zone_record' => "DNS-tietueet",
    'dns__cant_create_record_with_server_ip' => "Tätä IP-osoitetta ei voida lisätä, sillä se vastaa tämän Pleskista hallitun palvelimen IP-osoitetta.",

    'dns__tabs_acl' => "Vyöhykesiirrot",
    'dns__acl_add_network_legend' => "Lisää verkko",
    'dns__acl_add_ip_legend' => "Lisää IP-osoite",
    'dns__acl_network_not_allowed' => "Windowsin DNS ei salli tätä verkko-osoitetta.",
    'dns__acl_enter_ip_address_with_mask' => "IP-osoite/Peite",
    'dns__acl_enter_ip_address' => "IP-osoite",
    'dns__acl_list_network_legend' => "Verkot, jotka voivat saada DNS-vyöhykkeen kopion",
    'dns__acl_list_ip_legend' => "IP-osoitteet, jotka voivat saada DNS-vyöhykkeen kopion",
    'bt_dns_acl_add_network' => "Lisää verkko",
    'bt_dns_acl_add_ip' => "Lisää IP-osoite",

    'dns_add__add_rec_for_zone' => "Lisää %1 vyöhykkeeseen %2",
    'dns_add__canonical_dom_name_is_invalid' => "Kanoninen toimialueen nimi on virheellinen.",
    'dns_add__enter_canonical_name' => "Kanoninen nimi",
    'dns_add__enter_dom_name' => "Toimialueen nimi",
    'dns_add__enter_ip_address' => "IP-osoite",
    'dns_add__enter_ip_mask' => "IP-osoite ja verkkopeite",
    'dns_add__enter_mail_domain' => "Sähköpostitoimialue",
    'dns_add__enter_mail_exchanger' => "Mail Exchange Server",
    'dns_add__enter_nameserver' => "Nimipalvelin",
    'dns_add__enter_txt_record' => "TXT-tietue",
    'dns_add__enter_service_name' => "Palvelun nimi",
    'dns_add__hint_service_name' => "Esimerkki: SIP (ilman alaviivaa)",
    'dns_add__enter_protocol' => "Protokolla",
    'dns_add__hint_protocol_name' => "Esimerkki: TCP (ilman alaviivaa)",
    'dns_add__protocol_tcp' => "TCP",
    'dns_add__protocol_udp' => "UDP",
    'dns_add__enter_srv_priority' => "Prioriteetti",
    'dns_add__specify_weight_of_service' => "Saman prioriteetin tietueiden suhteellinen paino",
    'dns_add__enter_target_host' => "Kohdeisäntä",
    'dns_add__hint_target_host' => "Esimerkki: example.com",
    'dns_add__enter_target_port' => "Kohdeportti",
    'dns_add__caa_tag' => "Tunniste",
    'dns_add__caa_value' => "Arvo",
    'dns_add-invalid-A_ip' => "IP-osoite on virheellinen.",
    'dns_add-invalid-AAAA_ip' => "IP-osoite on virheellinen.",
    'dns_add-invalid-PTR_ip_mask' => "Virheellinen IP-osoite/verkkopeitteen pari.",
    'dns_add-invalid-SRV_service_name' => "Virheellinen palvelun nimi",
    'dns_add-invalid-SRV_protocol_name' => "Virheellinen protokolla",
    'dns_add-invalid-SRV_target_port' => "Virheellinen kohdeportti",

    'dns_add__invalid_ip' => "IP-osoite on virheellinen.",
    'dns_add__low' => "pieni",
    'dns_add__mail_dom_name_is_invalid' => "Sähköpostitoimialueen nimi on virheellinen.",
    'dns_add__nameserver_is_invalid' => "Nimipalvelin on virheellinen.",
    'dns_add__record' => "%1 tietue",
    'dns_add__select_prefer_for_mail_exchange_server' => "Määritä Mail Exchange Server -palvelimen prioriteetti",
    'dns_add__unable_insert_new_dns_rec' => "Uutta DNS-tietuetta ei voitu lisätä: %1",
    'dns_add__very_high' => "Erittäin suuri",
    'dom_ctrl__allowed' => "Sallittu",
    'dom_ctrl__db' => "MySQL-tietokannat",
    'dom_ctrl__mssql_db' => "MS SQL-tietokannat",
    'dom_ctrl__disk_space' => "Levytila",
    'dom_ctrl__dom_adm' => "Toimialue %1/%2",
    'dom_ctrl__dom_cl' => "Toimialue %1",
    'dom_ctrl__domain_has_forwarding_with_undefined_fwd_url' => "Toimialueelle on määritetty edelleenlähetys ilman edelleenlähetyksen URL-osoitteen ilmoitusta",
    'dom_ctrl__domain_has_frame_forwarding' => "Toimialueessa on kehyksen edelleenlähetys URL-osoitteeseen %1",
    'dom_ctrl__domain_has_no_hosting' => "Toimialueelle ei ole määritetty isännöintiä",
    'dom_ctrl__domain_has_physical_hosting' => "Tälle toimialueelle on määritetty verkkosivuston isännöinti IP-osoitteessa %1",
    'dom_ctrl__domain_has_standard_forwarding' => "Toimialueessa on vakioedelleenlähetys URL-osoitteeseen %1",
    'dom_ctrl__maillists' => "Postituslistat",
    'dom_ctrl__mboxes' => "Postilaatikot",
    'dom_ctrl__mg' => "Postin edelleenlähetykset",
    'dom_ctrl__resource_name' => "Resurssi",
    'dom_ctrl__resp' => "Automaattiset vastaukset",
    'dom_ctrl__subdom' => "Alitoimialueet",
    'dom_ctrl__dom_aliases' => "Toimialueen aliakset",
    'dom_ctrl__traffic' => "Liikenne",
    'dom_ctrl__unable_activate/deactivate_dom' => "Toimialuetta ei voi ottaa käyttöön/poistaa käytöstä: %1",
    'dom_ctrl__used' => "Käytetty",
    // end of serge part

    // maverick part
    'dom_ctrl__wu' => "Internet-käyttäjät",
    'dom_pref__bounce_with_phrase' => "Lähetä takaisin (bounce) käyttäen viestiä",
    'dom_pref__bounce' => "Bounce",
    'dom_pref__catch_addr' => "Lähetä edelleen osoitteeseen",
    'dom_pref__reject' => 'Hylkää',
    'dom_pref__confirm_domain_removing' => "Muistathan ilmoittaa toimialueen vierailijoille toimialueen nimen muutoksesta. Haluatko varmasti nimetä toimialueen uudelleen?",
    'dom_pref__db_inconsystency' => "Tietokannan epäyhtenäisyys.",
    'dom_pref__dbs' => "tietokannat",
    'dom_pref__delete_traffic_stat' => "Säilytä verkon ja liikenteen tilastotiedot",
    'dom_pref__delete_traffic_stat_older' => "Säilytä verkon ja liikenteen tilastotiedot",
    'dom_pref__dom_level_name_conflict' => "Toimialueen järjestelmänvalvojan käyttäjätunnus on ristiriidassa jonkin asiakkaan käyttäjätunnukseen.",
    'dom_pref__invalid_disk_space_limit' => "Virheellinen levytilarajoitus. Enimmäisarvo: %1",
    'dom_pref__invalid_expiration_date_limit' => "Virheellinen voimassaolokausi.",
    'dom_pref__invalid_max_traffic_limit' => "Virheellinen liikenteen raja. Enimmäisarvo: %1",
    'dom_pref__limits_of_dom' => "Toimialueen %1 rajat",
    'dom_pref__mail_grps' => "postitusryhmät",
    'dom_pref__mail_nonexistent_user' => "Mitä tehdä sähköpostille, joka on lähetetty olemassa olemattomille käyttäjille",
    'dom_pref__mail_redirs' => "sähköpostin välittäjät",
    'dom_pref__mail_resps' => "sähköpostin automaattiset vastaukset",
    'dom_pref__max_limit_is_invalid' => "%1 on virheellinen.",
    'dom_pref__max_num_of_%objects_is_invalid' => "Kohteen %1 enimmäismäärä on virheellinen.",
    'dom_pref__new_limit_less_currently_used' => "%1: pyydettiin - %2, tällä hetkellä käytössä - %3",
    'dom_pref__older_that' => "käyttäjälle",
    'dom_pref__postboxes' => "postilaatikot",
    'dom_pref__preferences_of_dom' => "Toimialueen %1 asetukset",
    'dom_pref__redirect_to_itself' => "Toimialueen edelleenlähetys on asetettu toimialueelle itselleen",
    'dom_pref__traffic_logging_period_couldnt_be_lower' => "Olet määrittänyt toimialueen liikenteen tilastotietojen säilytysajan lyhyemmäksi kuin palvelimen määritetty kokonaisaika (%1 kk). Tilastotietojen säilytysaika on asetettu samaksi kuin palvelimen oletusarvo (%1 kk).",
    'dom_pref__unable_add_www_prefix_in_dom' => "WWW-etuliitettä ei voi lisätä toimialueeseen: %1",
    'dom_pref__unable_define_physical_hst_param' => "Fyysisiä isännöintiparametreja ei voi määrittää: %1",
    'dom_pref__unable_rename_domain' => "Ei voitu nimetä toimialuetta %1: %2",
    'dom_pref__unable_set_up_mbox_quota' => "Tälle toimialueelle ei voi määrittää postilaatikon kiintiötä: %1",
    'dom_pref__unable_set_up_web_user_script' => "Internet-käyttäjiä varten ei voi määrittää komentosarjoja: %1",
    'dom_pref__unlimited' => "Rajoittamaton",
    'dom_pref__web_usrs' => "internet-käyttäjät",
    'dom_pref__you_already_have_%object' => "Sinulla on jo %1",
    'cu_domain__error_unable_update_ftp_users' => 'Toimialueen FTP-käyttäjien päivittäminen epäonnistui: %1',
    'dom_cli__warning_ignore_quota' => 'VAROITUS: Valinta "-hard_quota" ohitetaan: kiintolevyn kiintiötä ei tueta',
    'dom_user_client_login_exist' => "Toimialueen järjestelmänvalvojan pääsyä Pleskiin ei voi sallia toimialueessa %1 : tämä käyttäjänimi on jo käytössä.",
    'domain__unable_to_turn_on_service' => "%1 palvelun käyttöönotto epäonnistui.",
    'domains__change_the_status_of_domain?' => "Haluatko varmasti muuttaa toimialueen %1 tilan?",
    'domains__client_info_hiding_traffic' => "%1 toimialuetta, %2 aktiivista toimialuetta, %3 levytilasta käytetty",
    'domains__unable_to_change_client_status' => "Asiakastilin tilaa ei voi vaihtaa: %1",
    'domains__unable_update_apache_settings' => "Apachen asetusten päivittäminen ei onnistu.",
    'domains__you_do_not_have_permissions_to_delete_domains' => "Sinulla ei ole oikeuksia poistaa toimialueita.",
    'domains__you_want_change_the_status_of_the_cl??' => "Haluatko varmasti muuttaa asiakastilin tilan?",
    'domains__you_want_change_the_cp_access_of_the_cl??' => "Haluatko varmasti suorittaa tämän toiminnon?",
    'domains_list__unable_remove_doms' => "Toimialueita ei voi poistaa: %1",
    'domaintrafficlist_header_of_domain__' => "Liikenne toimialueessa %1",

    'domain_aliases_remove__select_domain_aliases_for_remove' => 'Valitse poistettavat toimialueen aliakset.',
    'domain_aliases_remove__title' => 'Poista toimialueen aliakset',
    'domain_aliases__max_aliases_reached_for_dom' => "Aliaksien maksimimäärä on saavutettu tämän toimialueen kohdalla.",
    'domain_edit__edit_title' => 'Muokkaa toimialueen aliaksen nimeä',
    'domain_alias_edit__type' => 'Toimialueen aliastyyppi',
    'domain_aliases__list_header' => 'Toimialueen aliakset',
    'domain_aliases__name' => 'Nimi',
    'domain_aliases__type' => 'Tyyppi',
    'domain_aliases__type_full' => 'Verkko+FTP+Sähköposti',
    'domain_aliases__type_web_ftp' => 'WWW+FTP',
    'domain_aliases__page_title' => 'Toimialueen aliakset',
    'domain_aliases__legend' => 'Toimialueen aliakset',
    'domain_alias__domain_exists' => 'Samanniminen toimialue on jo olemassa',
    'domain_alias__subdomain_exists' => 'Samanniminen alitoimialue on jo olemassa',
    'domain_alias__dns_record_exists' => 'Syötetyn toimialueen aliaksen nimen omaava DNS-tietue on jo olemassa',
    'domain_alias__domain_alias_exists' => "Samanniminen toimialueen alias on jo olemassa",
    'domain_alias__invalid_type_full' => 'Sähköpostipalvelin ei tue toimialueen aliaksia',
    'domain_alias__redirect_exists' => 'Uudelleenohjaus samaan kohteeseen havaittiin.',

    'ds__anonymous_ftp' => "Julkinen FTP",
    'drweb__pagetitle' => 'Virustentorjunnan asetukset',
    'drweb__drweb' => 'Virustentorjuntaohjelman sähköpostien tarkistus',
    'drweb__drweb_direction' => 'Tarkistetaan postia virusten varalta',
    'drweb__drweb_direction_off' => 'Älä suorita virustarkistusta',
    'drweb__drweb_direction_any' => 'Saapuva ja lähtevä posti',
    'drweb__drweb_direction_from' => 'Vain lähtevä posti',
    'drweb__drweb_direction_to' => 'Vain saapuva posti',
    'drweb__disable_reason_key' => 'Käyttöoikeusavain ei tue virustentorjuntaohjelmaa.',
    'drweb__disable_reason_perm' => 'Sinulla ei ole oikeuksia hallita virustentorjuntaa.',
    'drweb__disable_reason_install' => 'Virustentorjuntaohjelmaa ei ole asennettuna.',
    'drweb__filters' => 'Virustentorjunnan suodattimet',
    'ds__dns' => "DNS-vyöhyke",
    'ds__mail' => "Sähköposti",
    'dsr__of_client_title' => "Kohteen %1 toimialueen yhteenvetoraportti",
    'dsr__report_has_been_sent_email' => "Raportti lähetettiin sähköpostiin: %1",
    'dsr__title' => "Toimialueen yhteenvetoraportti",
    'dumps_list__deletion_page_title' => "Seuraavat toimialueen %1 varmuuskopiotiedostot poistetaan:",
    'dumps_list__dumpfile_is_invalid' => "Tiedosto %1 ei ole kelvollinen toimialueen varmuuskopiotiedosto.",
    'dumps_list__page_title' => "Varmuuskopiotiedostojen tallennustilaa",
    'dumps_upload__page_title' => "Varmuuskopiointitiedostoja ladataan säilytystilaan",
    'dumps_list__repository_is_not_exist' => "Varmuuskopiotiedostojen tallennustilaa ei ole.",
    'dumps_list__unable_to_remove' => "Varmuuskopiotiedoston poistaminen ei onnistu: %1",
    'dumps_list__dumpfile_can_conflict' => "Määrittämäsi tiedoston nimi on ristiriidassa tiedostoon %1. Määritä toinen tiedoston nimi.",
    'dusr_ed__allow_dl_usr_access' => "Salli toimialueen järjestelmänvalvojan pääsy",
    'dusr_ed__information' => "Toimialueen %1 järjestelmänvalvojan ominaisuudet",
    'dusr_ed__locale' => "Toimialueen järjestelmänvalvojan kieli",
    'dusr_ed__skin' => "Toimialueen järjestelmänvalvojan liittymän ulkoasu",
    'dusr_ed__personal_information' => 'Henkilökohtaiset tiedot',
    'ess__error' => "Virhe",
    'example__' => "Esimerkki: %1",
    'extras__allow_certificate_purchasing' => "Salli varmenteen hankkiminen",
    'extras__allow_domain_registration' => "Salli toimialueen rekisteröinti",
    'extras__allow_extras' => "Salli lisäpalvelut",
    'extras__buy_new_key' => "Nykyinen käyttöoikeutesi ei salli näiden objektien muokkaamista.",
    'extras__setup_services' => "Määritä lisäpalvelut",

    'ruleeditform__error' => 'Ei voitu päivittää palomuurisääntöä.',
    'ruleeditform__name_is_required' => 'Määritä säännön nimi.',
    'ruleeditform__profiles_is_required' => 'Valitse vähintään yksi profiili.',
    'ruleeditform__invalid_ip' => 'Määritetty IP-osoite tai verkko ei kelpaa.',
    'ruleeditform__invalid_port' => 'Määritetty portti ei kelpaa. Mahdolliset arvot ovat 1000 tai 1000-1051',

    'filemanager__items' => 'kohdetta hakemistossa %1',
    'filemanager__items_paging' => 'kohdetta hakemistossa %1',

    'get_password__encrypted_password' => "Salasanatietoja ei voida lähettää: salasana on tallennettu salatussa muodossa.",
    'get_password__mail_error' => "Virhe yritettäessä lähettää salasana sähköpostiosoitteeseen %1: %2",
    'get_password__mail_ok' => "Salasana on lähetetty sähköpostiosoitteeseen: %1",
    'get_password__message' => "Käyttäjänimesi järjestelmän käyttöä varten: %1\nSalasanasi on %2",
    'get_password__subject' => "Salasana järjestelmän käyttöä varten",
    'groups__available' => "Käytettävissä olevat postitusryhmät",
    'groups__groups_for_mailname' => "Postitusryhmät, joihin sähköpostitili %1 on tilattu",
    'groups__member_of' => "Seuraavien postitusryhmien jäsen",
    'help__help_area' => "Ohje-alue.",
    'hst_def__auth_disabled' => "kielletty",
    'hst_def__auth_enabled' => "sallittu",
    'hst_def__change_curr_dns_ip' => "A DNS -tietueen nykyinen IP-osoite muutetaan",
    'hst_def__cr_hosting_ip_dns_ip_not_equiv' => "Mikään A DNS -tietueen IP-osoitteista ei vastaa IP-osoitetta, joka on määritetty luotavalle isännöintitilille",
    'hst_def__dest_url' => "Kohde-URL",
    'hst_def__disk_quota' => "Levykiintiö",
    'hst_def__disk_space_limit_exceed_incoming_quota' => "Anonyymin FTP:n saapuvan hakemiston levytilarajoitus ylittää levytilarajoituksen, jonka yrität asettaa. Anonyymin FTP:n saapuvan hakemiston levytilarajoitus ei saa ylittää toimialueen levytilarajoitusta.",
    'hst_def__frame_forwarding_definition' => "Kehyksen edelleenlähetyksen määritys toimialueelle %1",
    'hst_def__ftpuser_for_hst_not_exist_in_system' => "Varoitus: FTP-käyttäjää %1 käytetään isännöintitilin asetuksissa, mutta sitä ei ole järjestelmässä.",
    'hst_def__hst_type_is_not_defined' => "Isännöintityyppiä ei ole määritetty",
    'hst_def__ip_based' => "IP-pohjainen",
    'hst_def__name_based_power_anonymous_ftp_down' => "Tämän isännöintitilin siirtäminen jaettuun IP-osoitteeseen poistaa anonyymin FTP-palvelun käytöstä tässä toimialueessa. Haluatko silti jatkaa?",
    'hst_def__password_is_invalid_password_syntax' => "Salasana ei kelpaa.\nÄlä käytä salasanassa heittomerkkejä tai kansallisia aakkosmerkkejä.\nSalasanan pituuden on oltava 5",
    'hst_def__shell' => "Palvelinliittymään siirtyminen SSH:n kautta tilauksen järjestelmäkäyttäjänä",
    'hst_def__shell_windows' => "Palvelimeen siirtyminen etätyöpöydän kautta tilauksen järjestelmäkäyttäjänä",
    'hst_def__standard_forwarding_definition' => "Vakioedelleenlähetyksen määritys toimialueelle %1",
    'hst_def__title_name_based' => "Nimeen perustuva",
    'hst_def__unable_create/update_physic_hst' => "Fyysistä isännöintiä ei voi luoda tai päivittää: %1",
    'hst_def__unable_create/update_std_fwd' => "Vakioedelleenlähetystä ei voi luoda tai päivittää: %1",
    'hst_def__unable_create_forwarding_myself' => "Edelleenlähetystä toimialueelle itselleen ei voi luoda.",
    'hst_def__unable_turn_same_ssl_while_ssl_off' => "Yksittäisen hakemiston käyttöä ei voida sallia SSL/TLS- ja muiden kuin SSL/TLS-sisältöjen tallentamiseen: SSL/TLS-tukea ei ole otettu käyttöön.",
    'hst_def__unable_turn_on_ssl_cert_not_defined' => "SSL/TLS-tukea ei voi ottaa käyttöön: SSL/TLS-varmennetta ei ole asennettu.",
    'hst_def__url_is_invalid' => "URL on virheellinen.",
    'hst_def__virtual_host_access' => "Toimialueen %1 virtuaalisen isännän käyttö",
    'hst_def__virtual_host_uses_non_existed_ip_address' => "VAROITUS.  Tämä näennäisisäntä käyttää isännöintiin olemassa olematonta IP-osoitetta.",
    'hst_def__you_have_no_ips' => "Käytössäsi ei ole IP-osoitteita, eikä sinulla ole lupaa luoda nimeen perustuvaa isännöintiä.",
    'hst_sel__header' => "Kun haluat isännöidä verkkosivustoa tässä palvelimessa, valitse Fyysinen isännöinti -vaihtoehto.\n Kun haluat määrittää toimialueen edelleenlähetyksen toisessa tietokoneessa olevalle sivustolle, valitse Kehyksen edelleenlähetys- tai Vakioedelleenlähetys-vaihtoehto.\nKun käytät vakioedelleenlähetystä, käyttäjä ohjataan uudelleen kyseiselle sivustolle ja nykyisen sivuston URL näkyy käyttäjän selaimessa merkkinä uudelleenohjauksesta. Kun käytät kehyksen edelleenlähetystä, käyttäjä ohjataan uudelleen kyseiselle sivustolle, mutta hän ei tiedä, että sivusto sijaitsee toisessa paikassa.",
    'hst_sel__physical_hst' => "Fyysinen isännöinti",
    'hst_sel__select_hst_type' => "Valitse toimialueen isännöintityyppi",
    'hst_sel__select_hst_type_warning' => "Valitse toimialueen isännöintityyppi",
    'hst_sel__hosting_exists' => "Isännöintiä ei voi luoda, koska se on jo määritetty tälle toimialueelle. Sinut ohjataan uudelleen isännöinnin hallintasivulle.",
    'hst_sel__standard_frw' => "Vakioedelleenlähetys",
    'hst_sel__frame_frw' => "Kehyksen edelleenlähetys",
    '__frame_frw' => "Kehyksen edelleenlähetys",
    '__hosting_exists' => "Isännöintiä ei voi luoda, koska se on jo määritetty tälle toimialueelle. Sinut ohjataan uudelleen isännöinnin hallintasivulle.",
    '__choose_hst_type' => "Valitse tarvittava isännöintityyppi.",
    '__no_hst_conf' => "Toimialueellesi ei ole määritetty isännöintiä.",
    '__physical_hst' => "Fyysinen isännöinti",
    '__select_hst_type' => "Valitse toimialueen isännöintityyppi",
    '__standard_frw' => "Vakioedelleenlähetys",
    '__warning' => "Varoitus! Kaikki aiemmin asetetut parametrit hylätään. Haluatko varmasti muuttaa isännöintityyppiä?",
    'i_cl_off' => "Asiakas ei ole aktiivinen.",
    'i_cl_off_by_admin' => "Palvelimen järjestelmänvalvoja on peruuttanut asiakastilin.",
    'i_cl_off_expired' => "Asiakastili on vanhentunut.",
    'i_cl_on' => "Asiakas on aktiivinen.",

    'icf__title' => 'Internet-yhteys palomuuri',
    'icf__if_legend' => 'Liittymät',
    'icf__mode' => 'Tila',

    'invalid_value' => 'Arvo on virheellinen',

    'ip_addr__already_exists' => "IP-osoite %1 on jo olemassa.",
    'ip_addr__cant_add' => "IP-osoitetta %1 ei ole tai se kuuluu toisen asiakkaan IP-ryhmään",
    'ip_addr__cl_list_for_ip' => "Jälleenmyyjät, jotka käyttävät %1 -IP-osoitetta %2",
    'ip_addr__cl_list_for_ip_add' => "Lisää IP-osoite jälleenmyyjän ryhmään",
    'ip_addr__domains_list_for_ip' => "Verkkosivustot, jotka käyttävät %1 -IP-osoitetta %2",
    'ip_addr__ip_used_by_hst_or_frw' => "IP-osoitetta %1 käytetään isännöintiin tai edelleenlähetykseen.",
    'ip_addr__only_one_ip_and_client_have_domain' => "Tätä IP-osoitetta ei voi poistaa, koska se isännöi toimialueita.",
    'ip_addr__remove_ip_addr' => "Nämä IP-osoitteet poistetaan järjestelmästä:",
    'ip_addr__select_clients' => "Valitse asiakkaat",
    'ip_addr__select_ip_addr_to_remove' => "Valitse poistettava IP-osoite.",
    'ip_addr__unallowed_by_license' => "Tämä Pleskin kopio ei sisällä oikeuksia toimia IP-osoitteella %1.\nSallitut IP-arvot ovat: %2.",
    'ip_alias__interface' => "Liittymä",
    'ip_alias__invalid_ip_nm_bsd_vrt_hsts' => "Nimeen perustuvan virtuaalisen isännöinnin %1 -IP-osoite on virheellinen.",
    'ip_alias__invalid_ip_or_netmask' => "Virheellinen IP-osoite/verkkopeitteen pari.",
    'ip_alias__orig_ip_can_not_be_deleted' => "IP-osoite %1 on alkuperäinen palvelimen IP, sitä ei voida poistaa.",
    'ip_alias__ip_is_invalid' => "%1 -IP-osoite on virheellinen.",
    'ip_alias__ip_mask_is_invalid' => "%1 IP-peite on virheellinen.",
    'ip_alias__ip_not_exist' => "IP-osoitetta %1 ei ole.",
    'ip_alias__ip_address_and_mask' => 'IP-osoite ja aliverkon peite',
    'ip_alias__mask' => "Aliverkon peite",
    'ip_alias__remove_selected_ip_aliases?' => "Haluatko varmasti poistaa valitut IP-osoitteet?",
    'ip_alias__select_ip' => "Valitse luettelosta vähintään yksi IP-osoite poistaaksesi sen.",
    'ip_alias__this_ip_used_for_domain' => "(%1) tätä IP-osoitetta käytetään toimialueelle %2.",
    'ip_alias__this_ip_used_for_nm_bsd_vrt_hsts' => "(%1) tätä IP-osoitetta käytetään nimeen perustuville virtuaalisille isännille.",
    'ip_alias__unable_add_ip' => "IP-osoitetta ei voi lisätä: %1",
    'ip_alias__unable_remove_ip' => "IP-osoitetta ei voi poistaa: %1",
    'ip_ctrl__anonymous_ftp_exists_in_domain' => "Et voi muuttaa IP-osoitteen tyypiksi jaettu, koska tämä poistaa anonyymin FTP:n käytöstä toimialueessa '%1'.",
    'ip_ctrl__ip_addr' => "IP-osoite %2 liittymässä %1",
    'ip_ctrl__ip_exists_many_pools' => "Et voi muuttaa IP-tyyppiä. Tämä IP-osoite kuuluu useiden käyttäjien ryhmiin.",
    'ip_ctrl__ssl_cert' => "SSL/TLS-varmenne",
    'ip_pool__ip_address_is_absend_in_pool' => "IP-osoite puuttuu.",
    'ip_pool__ip_pool_for_client' => "Asiakkaan %1 IP-ryhmä",
    'ip_pool__no_cliens_avail' => "Asiakkaita ei ole käytettävissä.",
    'ip_pool__no_vacant_ips' => "Vapaita IP-osoitteita ei ole käytettävissä.",
    'ip_pool__pool_is_empty' => "IP-ryhmä on tyhjä.",
    'ip_pool__remove_ip_addr' => "Nämä IP-osoitteet poistetaan ryhmästä %1:",
    'ip_pool__select_free_ips' => "Vapaat IP-osoitteet",
    'limit__date_in_past' => "Voimassaolokausi on virheellinen. %1 on menneisyydessä.",
    'limit__enter_date' => "Anna päivämäärä",
    'limit__max_db' => "Tietokannat",
    'limit__name_disk_space' => "Levytila",
    'limit__name_max_box' => "postilaatikot",
    'limit__name_max_db' => "MySQL-tietokannat",
    'limit__name_max_dom' => "toimialueet",
    'limit__name_max_maillists' => "postituslistat",
    'limit__name_max_subdom' => "alitoimialueet",
    'limit__name_max_traffic' => "liikenne",
    'limit__name_max_wu' => "internet-käyttäjät",
    'limit__name_mbox_quota' => "postilaatikon kiintiö",
    'limit__name_max_mn' => "sähköpostitilit",
    'limit__name_max_cl' => 'asiakkaat',
    'limit__name_total_mboxes_quota' => "postilaatikon kiintiö yhteensä",
    'limit__name_mysql_dbase_space' => "MySQL-tietokannan muistitila",
    'limit__name_mssql_dbase_space' => "MSSQL-tietokannan muistitila",
    'limit__name_expiration' => 'vanhentumispäivä',

    'locale_upload__title' => 'Lisää aluekohtainen asetus',
    'locale_upload__file_name' => 'Polku kielipaketin tiedostokohteeseen',
    'locale_upload__unable_to_install' => 'Kielipaketin tiedostoa ei voida asentaa',
    'locale_upload__wrong_package' => 'Lataamasi tiedosto ei sisällä tähän Plesk -versioon hyväksyttävää kielipakettia.',
    'locale_upload__wrong_locale' => 'Lataamasi tiedosto ei sisällä kelvollista kielipakettia.',

    'locales_remove__title' => 'Aluekohtaisten asetuksien poistaminen',
    'locales_remove__select_locales_for_remove' => 'Valitse poistettavat aluekohtaiset asetukset.',
    'locales__can_not_remove' => 'Kielipaketin poisto ei onnistu alueella %1: %2',

    'ma__create_title' => 'Sähköpostialiaksen %1 luominen',
    'ma__edit_title' => "Muokkaa sähköpostialiasta %1",
    'ma__enter_new_alias' => "Anna uusi alias.",
    'ma__invalid_alias' => "Virheellinen sähköpostialias.",
    'ma__mail_aliases_mailname' => "Sähköpostitilin %1 sähköpostialiakset",
    'ma__mailname_does_not_exist' => "Sähköpostitiliä ei ole.",
    'ma__select_ma_for_remove' => "Valitse poistettavat sähköpostialiakset.",
    'ma__unable_to_add_new_ma' => "Sähköpostialiasta ei voi lisätä: %1",

    'mail_queue__not_allowed_by_license_key' => 'Käyttöoikeusavain ei salli postijonon hallintaa.',
    'maillist__' => "Postituslista %1",
    'maillist__already_exists' => "Postituslista on jo olemassa.",
    'maillist__mail_alias_already_exists_in_this_domain' => "Sähköpostialias %1 on jo olemassa tässä toimialueessa",
    'maillists__' => "Postituslistat %1",
    'maillists__limit_cl_max_maillists' => "Asiakkaan postituslistojen enimmäismäärä on saavutettu (raja: %1, käytetty: %2)",
    'maillists__limit_dom_max_maillists' => "Toimialueen postituslistojen enimmäismäärä on saavutettu.",
    'maillists__list' => "Postituslistat",
    'maillists__mailman_not_installed_or_conf' => "Mailman-palvelinlaajennuksia ei ole tällä hetkellä asennettu tai määritetty\npalvelimessa. Ota yhteys palvelimen järjestelmänvalvojaan Mailman-palvelinlaajennusten asentamiseksi tai määrittämiseksi oikealla tavalla.",
    'maillists__status' => "Postituslistojen palvelu on otettu käyttöön",
    'maillists__unable_to_delete__' => "Postituslistaa ei voi poistaa: %1",
    'maillists__disabled_text' => 'Et voi hallita postituslistoja, koska Mailman-postituslistojen palvelimen komponenttia ei ole asennettu tai määritetty.',
    'maillist_member__already_exists' => 'Postituslistan tilaaja on jo olemassa.',
    'maillist_member__not_exists' => 'Postituslistassa ei ole tällaista käyttäjää.',
    'mailserver_switching_warning' => "Varoitus!\n\nPostipalvelun vaihto on tarkoitettu vain alustavaan asettamiseen, jos palvelin on jo käytössä, seuraavat ongelmat voivat esiintyä: asetuksien ja postilaatikoiden sisällön menetys ja eri ristiriidat, kun palvelin on jo määritetty.\nJos tämä palvelin on nyt käytössä ja olet varma toiseen siirtymisestä, voit ilmoittaa asiakkaillesi toimenpiteestä, jotta he voivat ladata ja tallentaa sähköpostinsa.",
    'manager__access_denied' => "Käyttö estetty: %1",
    'manager__admin' => "Järjestelmänvalvoja",
    'manager__client' => 'Asiakas',
    'manager__domain' => "Toimialue",
    'manager__domain_cl_limit_exceeding' => "Tämän asiakastilin toimialueiden enimmäismäärä on saavutettu.",
    'manager__domain_is_not_yours' => "Toimialue %1 ei kuulu sinulle.",
    'manager__domain_key_limit_exceeding' => "Käyttöoikeusavaimesi määrittämä toimialueen luonnin raja on saavutettu.",
    'manager__no_perm_to_call' => "Sinulla ei ole oikeuksia soittaa kohteeseen %1.",
    'manager__no_perm_to_create_domains' => "Sinulla ei ole oikeuksia luoda toimialueita.",
    'manager__no_perm_to_modify_domain' => "Sinulla ei ole oikeuksia muokata toimialuetta %1.",
    'manager__no_perm_to_modify_domains' => "Sinulla ei ole oikeuksia muokata toimialueita.",
    'manager__no_perm_to_remove_domain' => "Sinulla ei ole oikeuksia poistaa toimialuetta %1.",
    'manager__no_perm_to_remove_domains' => "Sinulla ei ole oikeuksia poistaa toimialueita.",
    'manager__node_doesnt_exist' => "Kohdetta %1 ei ole.",
    'manager__user_disabled' => "Tilisi on peruutettu. Et voi käyttää järjestelmää.",
    'mail_quota_unsupported' => "ei postipalvelimen tukema",
    'mbox_quota_unsupported' => "ei postipalvelimen tukema",
    'mn__create_title' => "Luo sähköpostitili",
    'mn__edit_title' => "Asetukset",
    'mn__files_list_title' => "Liitetiedostot",
    'mn__files_remove' => "Poista tiedostot liitteiden säilöstä. Automaattiset vastaukset voivat käyttää kyseisiä tiedostoja. Ne poistetaan sekä säilöstä että niitä käyttävistä automaattisista vastauksista.",
    'mn__files_select_for_remove' => "Valitse poistettavat tiedostot.",
    'mn__mail_alias_form' => "Sähköpostialiaslomake",
    'mn__mail_aliases_list' => "Sähköpostialiakset",
    'mn__mailbox' => "Postilaatikon hallinta",
    'mn__unable_define_mn' => "Sähköpostitilejä ei voi määrittää: %1",
    'mn__unable_remove_mbox_quota' => "Postilaatikon kiintiötä ei voi poistaa: %1",
    'mn__upload_file' => "Lataa tiedosto",
    'mn_edit__attach_filename_changed' => 'Ladattu tiedosto %1 nimettiin uudelleen nimellä %2, koska sen nimi sisälsi muita kuin ASCII-merkkejä.',
    'mn_edit__add_mail_group_members_or_turn_off_box' => "Sinun on lisättävä postiryhmän jäsen, ennen kuin otat postiryhmän käyttöön.",
    'mn_edit__add_resp_or_turn_off_box' => "Sinun on lisättävä automaattinen vastaus tai poistettava valinta automaattisen vastauksen valintaruudusta.",
    'mn_edit__attachments' => "Liitteet",
    'mn_edit__dom_quota_less_then_quota' => "Tämän postilaatikon koko ei saa ylittää levytilan enimmäismäärää, joka on varattu tämän toimialueen postilaatikoille.",
    'mn_edit__enter_external_rcpnt_email' => "Anna ulkoisen postiryhmän jäsenen sähköposti",
    'mn_edit__enter_mail_redir_or_turn_off_box' => "Syötä osoite postin edelleenlähetykseen tai tyhjennä ruutu.",
    'mn_edit__ext_rcpnt_email_invalid' => "Ulkoisen vastaanottajan sähköpostiosoite on virheellinen.",
    'mn_edit__file_exists' => "Tiedosto on olemassa. Haluatko korvata?",
    'mn_edit__files_deld_from_repository' => "Nämä tiedostot poistetaan säilöstä ja automaattisista vastauksista, joissa nämä tiedostot ovat. Haluatko jatkaa?",
    'mn_edit__mail_name' => "Sähköpostitili",
    'mn_edit__mail_name_invalid' => "Sähköpostitilin nimi ei kelpaa.",
    'mn_edit__mail_redir' => "Sähköpostin välittäjät",
    'mn_edit__mail_redir_add' => "Lisää postiryhmän jäsen",
    'mn_edit__mail_resps' => "Sähköpostin automaattiset vastaukset",
    'mn_edit__mailbox' => "Postilaatikko",
    'mn_edit__enable_mailbox' => "Postilaatikko",
    'mn_edit__mailgroup' => "Postitusryhmä",
    'mn_edit__mailgroup_addresses' => "Postiryhmän jäsenet",
    'mn_edit__mailgroup_disabled' => "Käytettävissä vain silloin, kun sähköpostitili on jo lisätty.",
    'mn_edit__max_dom_quota' => "Oletus toimialueelle (%1)",
    'mn_edit__mbox_quota_invalid' => "Määritetty postilaatikon koko on virheellinen.",
    'mn_edit__new_resp_name' => "Uusi automaattisen vastauksen nimi",
    'mn_edit__no_autoresponders' => "Sinun on lisättävä vähintään yksi automaattinen vastaus ennen kuin otat automaattisen vastauspalvelun käyttöön / pois käytöstä.",
    'mn_edit__no_file_sel' => "Tiedostoja ei ole valittu.",
    'mn_edit__no_mail_addresses' => "Sähköpostiosoitteita ei ole määritetty tai valittu.",
    'mn_edit__none' => "Ei ole",
    'mn_edit__not_create_pass' => "Tällä toiminnolla ei luoda salasanaa kyseiselle tilille.\nKäyttäjä ei voi nähdä ja lähettää sähköpostia ilman salasanaa.",
    'mn_edit__redir_email_invalid' => "Edelleenlähetysosoite on virheellinen.",
    'mn_edit__redirect_addr' => "Edelleenlähetysosoite",
    'mn_edit__remove_autoresp?' => "Haluatko varmasti poistaa automaattisen vastauksen?",
    'mn_edit__remove_rcpnts?' => "Haluatko varmasti poistaa nämä vastaanottajat?",
    'mn_edit__repository' => "Säilö",
    'mn_edit__resps_attach' => "Automaattisen vastauksen liitetiedostot",
    'mn_edit__select_rcpnt_from_list' => "Valitse luettelosta vähintään yksi vastaanottaja poistaaksesi sen.",
    'mn_edit__select_registered_users' => "Valitse rekisteröidyt käyttäjät",
    'mn_edit__selected_postbox_have_not_setup_passwd' => "Olet valinnut postilaatikon käytön, mutta et ole asettanut sille salasanaa.",
    'mn_edit__unable_act_deact_mail_group' => "Postiryhmää ei voi ottaa käyttöön/poistaa käytöstä: %1",
    'mn_edit__unable_act_deact_mail_redir' => "Postin edelleenlähetyksen käyttöönotto tai käytöstäpoisto ei onnistu: %1",
    'mn_edit__unable_act_deact_postbox' => "Postilaatikkoa ei voi ottaa käyttöön/poistaa käytöstä: %1",
    'mn_edit__unable_act_deact_resp' => "Automaattisia vastauksia ei voi ottaa käyttöön/poistaa käytöstä: %1",
    'mn_edit__unable_add_attach' => "Liitetiedostoa ei voi lisätä: %1",
    'mn_edit__unable_add_mail_group_member' => "Postiryhmän jäsentä ei voi lisätä: %1",
    'mn_edit__unable_add_resp' => "Automaattista vastausta ei voi lisätä: %1",
    'mn_edit__unable_change_mail_name' => "Sähköpostitilin nimeä ei voi vaihtaa: %1",
    'mn_edit__unable_deactivate_mail_group' => "Postiryhmää ei voi poistaa käytöstä: %1",
    'mn_edit__unable_deactivate_resp' => "Automaattisia vastauksia ei voi poistaa käytöstä: %1",
    'mn_edit__unable_define_resp_id' => "Automaattisten vastausten tunnusta ei voi määrittää: %1",
    'mn_edit__unable_remove_attach' => "Liitetiedosto(j)a ei voi poistaa: %1",
    'mn_edit__unable_remove_autoresp' => "Automaattista vastausta ei voi poistaa: %1",
    'mn_edit__unable_remove_mail_group_member' => "Postiryhmän jäseniä ei voi poistaa: %1",
    'mn_edit__wrong_way' => 'Kohteelle %1 osoitettuja viestejä ei lähetetä, koska tälle sähköpostitilille ei ole otettu käyttöön postilaatikkoa tai sähköpostin välitystä.',
    'mn_edit__mailbox_is_disabled_mail_not_removed' => 'Postilaatikko osoitteessa %1 poistettiin käytöstä. Postilaatikon viestejä ei poistettu, mutta et voi palauttaa niitä IMAP- tai POP3-protokollan kautta.',
    'mn_list__mail_names_for_domain' => "Toimialueen %1 alaiset sähköpostitilit",
    'mn_list__sa_cannot_unable' => "Roskapostisuodatusta ei voida ottaa käyttöön",
    'mn_list__tab_cp_access' => "L",
    'mn_list__tab_title_client' => 'Asiakas',
    'mn_list__tab_title_domain' => 'Toimialue',
    'mn_list__tab_title_autoresp' => "A",
    'mn_list__tab_title_box' => "B",
    'mn_list__tab_title_group' => "G",
    'mn_list__tab_title_name' => "Nimi",
    'mn_list__tab_title_redirect' => "F",
    'mn_list__tab_title_spamfilter' => "S",
    'mn_list__tab_title_virusfilter' => 'virustentorjuntaohjelma',
    'mn_list__tab_title_drweb' => 'virustentorjuntaohjelma',
    'mn_list__unable_remove_mns' => "Sähköpostitilejä ei voi poistaa: %1",
    'module_upload__module_was_installed' => 'Tämä moduuli on jo asennettu. Jos haluat asentaa tämän moduulin uudemman version, poista moduulin asennus Pleskin kautta ja yritä asennusta sen jälkeen.',
    'module_upload__unable_to_install' => 'Moduulin pakattua tiedostoa ei voida asentaa',
    'module_upload__wrong_package' => 'Ladattu tiedosto ei ole tuettu moduulipaketti.',
    'module_upload__wrong_module' => 'Ladattu tiedosto ei sisällä moduulipakettia.',

    'news_articles_title' => 'Pleskin uutiset',
    'notification_text__invalid_subject_length' => "Huomautuksen aiheen pituus virheellinen. On oltava 1-255 merkkiä.",
    'notification_text__invalid_text_length' => "Huomautustekstin pituus virheellinen. On oltava 1",
    'notification_text__subject' => "Huomautuksen aihe",
    'notification_text__text' => "Huomautusteksti",
    'notification_text__title' => "Muokkaa huomautusta",
    'notification_text__unable_set_text' => "Huomautustekstiä ei voi muokata:",

    'odbc__cant_add_dsn' => "DSN:ää %1 ei voi lisätä: %2",
    'odbc__cant_build_connection_string' => "Yhteyttä ei voida luoda määritetyillä parametreilla, yritä uudelleen muilla parametreilla. Apuohjelma on palauttanut: %1",
    'odbc__cant_connect' => "Yhteyttä ei voi muodostaa tietolähteeseen käyttämällä määritettyjä asetuksia. Palvelin on palauttanut: %1",
    'odbc__cant_delete_dsn' => "DSN:ää %1 ei voi poistaa: %2",
    'odbc__cant_get_drivers_info' => "Ohjaimista ei saada tietoa.",
    'odbc__cant_get_drivers' => "ODBC-ohjainten luettelon noutaminen ei onnistu: %1",
    'odbc__cant_get_list' => "Olemassa olevien DSN:ien luettelon noutaminen ei onnistu: %1",
    'odbc__cant_get_servers_list' => "Palvelinluettelon noutaminen ei onnistu.",
    'odbc__cant_open_info_file' => "Tiedostoa ei voida valita ODBC-ohjaimen tiedoilla.",
    'odbc__cant_parse_string' => "Yhteysmerkkijonoa ei voi jäsentää.",
    'odbc__connect_success' => "Yhteyden muodostaminen onnistui",
    'odbc__driver_not_set' => "Ohjainta ei ole asetettu",
    'odbc__driver_or_name_not_set' => "ODBC-yhteyden ohjainta tai nimeä ei ole asetettu",
    'odbc__dsn_already_exists' => "Järjestelmässä on jo tämänniminen DSN (%1).",
    'odbc__dsn_not_exists' => "Tätä DSN:ää ei ole",
    'odbc__enter_connection_params' => "Määritä ODBC-yhteys",
    'odbc__enter_dsn_name' => "Anna DSN-nimi",
    'odbc__invalid_dsn_name' => "ODBC-yhteysnimen väärä syntaksi (%1): käytä vain aakkosnumeerisia merkkejä.",
    'odbc__no_such_driver' => "Tämännimistä ODBC-ohjainta (%1) ei tueta.",
    'odbc__remove_page_title' => "Seuraavat ODBC DSN -yhteydet poistetaan:",
    'odbc__select_dsn_to_remove' => "Valitse poistettavat DSN:t.",
    'odbc__unknown_driver' => "Tuntematon ohjaimen nimi (%1).",
    'odbc_add_new' => "Lisää DSN-yhteys",
    'odbc_driver' => "Ohjain",
    'odbc_dsn_description' => "Yhteyden kuvaus",
    'odbc_dsn_list' => "ODBC DSN -yhteydet",
    'odbc_dsn_name' => "Yhteyden nimi",
    'odbc_dsn_system' => "Järjestelmä-DSN",
    'odbc_dsn_text' => "ODBC DSN",
    'odbc_dsn_add__title' => 'Lisää ODBC DSN',
    'odbc_req_field_not_set' => "Pakollisia parametreja ei toimitettu.",

    // Descriptions of parameters of ODBC connection string
    'odbc__access_dbq' => 'Tietokannan tiedostopolku',
    'odbc__access_pagetimeout' => 'Käyttämättömän sivun puskuriin jäämisen aikajakso sekunnin kymmenesosissa. Tämä valinta soveltuu kaikkiin tietolähteisiin, jotka käyttävät Microsoft Access -ohjainta.',
    'odbc__access_maxbuffersize' => 'Sisäisen puskurin koko, yksikössä Kt, kohdistettu 256 Kt rajaan.',
    'odbc__access_readonly' => 'Määrittää tietokannan vain luettavaksi päivityksien kieltämiseksi.',
    'odbc__access_exclusive' => 'Määrittää tietokannan eksklusiiviseksi jaettujen päivityksien kieltämiseksi.',
    'odbc__access_safetransactions' => 'Jos arvoksi on asetettu 0 (oletusasetus), kaikki tapahtumat suoritetaan välittömästi. Jos arvoksi on asetettu 1, kaikki tapahtumat tallennetaan vain levyyn toimenpiteen suorituksen jälkeen, mutta tehokkuus heikkenee hiukan.',
    'odbc__access_threads' => 'Moottorin käytettävien taustasäikeiden määrä.',
    'odbc__access_maxscanrows' => "Skannattujen rivien määrä asettaessa sarakkeen tietotyyppiä olemassa olevien tietojen pohjalta.",
    'odbc__access_implicitcommitsync' => 'Määrittää, miten tapahtuman ulkopuoliset muutokset kirjoitetaan tietokantaan.',
    'odbc__access_usercommitsync' => 'Määrittää, suorittaako MS Access -ohjain erityisiä käyttäjän määrittämiä tapahtumia asynkronisesti.',
    'odbc__mssql_server' => 'Palvelin',
    'odbc__mssql_uid' => 'Kirjautumistunnus',
    'odbc__mssql_pwd' => 'Salasana',
    'odbc__mssql_database' => 'ODBC-tietolähteen oletustietokanta',
    'odbc__mssql_app' => 'Sovelluksen nimi',
    'odbc__mssql_wid' => 'Työaseman tunnus',
    'odbc__mssql_language' => 'Maakohtainen oletuskieli',
    'odbc__mssql_oemtoansi' => 'Laajennettujen merkkien muutos OEM-arvoiksi',
    'odbc__mysql_server' => 'MySQL-palvelimen isäntänimi',
    'odbc__mysql_database' => 'Oletustietokanta',
    'odbc__mysql_user' => 'MySQL-yhteyden käyttäjätunnus',
    'odbc__mysql_password' => 'Palvelimen käyttäjätilin salasana',
    'odbc__mysql_port' => 'Käytettävä TCP/IP-portti, jos palvelin ei ole paikallinen isäntä',
    'odbc__mysql_socket' => 'Windows nimesi yhdistettävän putken, jos palvelin on paikallinen isäntä',
    'odbc__mysql_option' => 'Valinnat, jotka määrittävät MyODBC:n toimintaperiaatteen. Katso <a target="_blank" href="http://www.linuxtopia.org/online_books/database_guides/mysql_5.1_database_reference_guide_OLD/connection-parameters.html">http://www.linuxtopia.org/online_books/database_guides/mysql_5.1_database_reference_guide_OLD/connection-parameters.html.</a>',
    'odbc__excel_dbq' => 'Tietokannan tiedostopolku',
    'odbc__excel_defaultdir' => 'Oletustietohakemisto',
    'odbc__excel_fil' => 'Tietokantaversio',
    'odbc__excel_maxbuffersize' => 'Puskurin enimmäiskoko',
    'odbc__excel_pagetimeout' => 'Sivun aikakatkaisu',

    'pb__aliases' => "Tunnukset",
    'pb__anonftp' => "Julkinen FTP",
    'pb__autoinstaller_releases' => 'Päivitystyökalu',
    'pb__cert' => "Varmenteet",
    'pb__cl_pool' => "IP-osoitteet",
    'pb__cl_pool_ctrl' => "%1",
    'pb__cl_pref' => "Asetukset",
    'pb__cl_rpt' => "Raportti",
    'pb__cl_rpt_list' => "Mukauta",
    'pb__cl_templates' => "Asiakasmallit",
    'pb__cl_traffic' => "Liikenne",
    'pb__cl_traffic_history' => "Liikennehistoria",
    'pb__cl_traffic_of' => "Kohteen %1 liikenne",
    'pb__client' => "%1",
    'pb__clients' => "Asiakkaat",
    'pb__comp_info' => "Palvelinkomponentit",
    'pb__common_acl' => 'Salli siirto ACL',
    'pb__cp_access' => "Käyttö",
    'pb__crontab' => "Ajoitustoiminto",
    'pb__scheduler' => "Ajoitustoiminto",
    'pb__custom_buttons' => "Mukautetut painikkeet",
    'pb__databases_db' => 'Tietokannat',
    'pb__sqlservers_db' => 'SQL-palvelimet',//to check
    'pb__db' => "Tietokannat",
    'pb__db_edit' => "%1",
    'pb__db_server_edit' => '%1',
    'pb__db_servers' => 'Tietokantapalvelimet',
    'pb__dl_usr_ed' => "Toimialueen järjestelmänvalvoja",
    'pb__dns' => "DNS",
    'pb__dns_template' => "DNS",
    'pb__dns_t' => "DNS",
    'pb__dom_ctrl' => "%1",
    'pb__dom_lim' => "Toimialueen rajat",
    'pb__dom_pref' => "Asetukset",
    'pb__dom_sum_report' => "Toimialueen yhteenvetoraportti",
    'pb__dom_templates' => "Toimialuemallit",
    'pb__dom_traffic' => "Kohteen %1 liikenne",
    'pb__domains' => "Toimialueet",
    'pb__domain_aliases' => 'Toimialueen aliakset',
    'pb__dumps_list' => "Varmuuskopiotiedostojen tallennustilaa",
    'pb__forwarding_setup' => "Edelleenlähetyksen määritys",
    'pb__filemanager' => "Tiedostonhallinta",
    'pb__ip_aliasing' => "IP-osoitteet",
    'pb__ip_clients' => "IP-osoitteiden poisto",
    'pb__license_management' => 'Lisenssin tiedot',
    'pb__locales' => 'Aluekohtaiset asetukset',
    'pb__log_files' => "Lokitiedostot",
    'pb__mail' => 'Sähköposti',
    'pb__mail_name_files' => "Liitetiedostot",
    'pb__mail_name_redirects' => "Sähköpostin välittäjät",
    'pb__mail_name_resp_attach_add' => "Uusi liite",
    'pb__mail_name_resp_edit' => "%1",
    'pb__mail_name_responders' => "Sähköpostin automaattiset vastaukset",
    'pb__mail_names' => "Sähköposti",
    'pb__maillists' => "Postituslistat",
    'pb__mimetypes' => 'MIME-tyypit',
    'pb__modules' => 'Moduulit',
    'pb__modules_management' => 'Hallitse moduuleja',
    'pb__notifications' => "Ilmoitukset",
    'pb__odbc' => "ODBC",
    'pb__phosting_setup' => "Fyysisen isännöinnin määritys",
    'pb__prtd_dirs' => "Suojatut hakemistot",
    'pb__prtdir_edit' => "%1",
    'pb__report' => "Raportti",
    'pb__report_auto' => "Toimitusaikataulu kohteelle %1",
    'pb__report_list' => "Mukauta",
    'pb__server' => "Palvelin",
    'pb__sessions' => "Istunnot",
    'pb__sapp_pool' => "Web-sovellussarja",
    'pb__siteapp_install' => 'Web-sovelluksen asentaminen',
    'pb__site_app_pkgs' => 'Verkkosovellukset',
    'pb__site_apps' => "Verkkosovellukset",
    'pb__additional_key_info' => 'Avaimen ominaisuudet',
    'pb__additional_key_properties' => 'Avaimen ominaisuudet',
    'pb__skeleton' => 'Virtuaalisen isännän malli',
    'pb__skins' => 'Ulkoasut',
    'pb__skin_info' => '%1',
    'pb__spamassassin' => "Roskapostisuodatin",
    'pb__statistics' => "Tilastot",
    'pb__subdom_ctrl' => "%1",
    'pb__subdomains' => "Alitoimialueet",
    'pb__templates' => "Mallit",
    'pb__virtualdirs' => 'Näennäiskansiot',
    'pb__web_users' => "Internet-käyttäjät",
    'pb__webalizer_preferences' => 'Verkkosivuston tilastojen asetukset',
    'pdir__enter_dir_name' => "Anna hakemistonimi.",
    'pdir__invalid_hst' => "Isännöintityyppi on virheellinen. Täytyy olla fyysinen.",
    'pdir__pd_id_is_undefined' => "Suojatun hakemiston tunnusta ei ole määritetty.",
    'pdir__pdir_exist' => "Tämänniminen hakemisto on jo suojattu.",
    'pdir__pdir_not_exist' => "Suojattua hakemistoa ei ole olemassa.",
    'pdir__pdir_usr_not_exist' => "Suojatun hakemiston käyttäjää ei ole.",
    'pdir__prdirs_for_domain' => "Suojatut hakemistot %1",
    'pdir__prdirs_for_subdomain' => "Alitoimialueen %1 suojatut hakemistot",
    'pdir__remove_pdir_usrs' => "Seuraavat suojatun hakemiston %2 käyttäjät verkkosivustossa %1 poistetaan:",
    'pdir__remove_pdir_usrs_on_subdom' => "Seuraavat suojatun hakemiston %2 käyttäjät alitoimialueessa %1 poistetaan:",
    'pdir__remove_pdirs_on_dom' => "Tämä toimenpide aiheuttaa suojauksen poistamisen verkkosivuston %2 hakemistoista, jotka omistaa asiakas %1. Hakemistoja ei poisteta.",
    'pdir__remove_pdirs_on_subdom' => "Tämä toimenpide aiheuttaa suojauksen poistamisen alitoimialueen %1 hakemistoista. Hakemistoja ei poisteta.",
    'pdir__select_pdir_usrs_for_remove' => "Valitse suojatun hakemiston käyttäjät, jotka haluat poistaa.",
    'pdir__select_pdirs_to_remove' => "Valitse hakemistot, joiden suojauksen haluat poistaa.",
    'pdir__unable_define_pdir_users' => "Suojatun hakemiston käyttäjiä ei voi määrittää.",
    'pdir__unable_define_pdirs_properties' => "Suojattujen hakemistojen ominaisuuksia ei voi määrittää: %1",
    'pdir__unable_select_dom_param' => "Toimialueen parametreja ei voi valita: %1",
    'pdir_ed__create_pdir_for_domain' => "Luo suojattu hakemisto: %1",
    'pdir_ed__create_pdir_for_subdomain' => "Luo suojattu hakemisto alitoimialueeseen %1",
    'pdir_ed__dir_already_protect' => "Tämä hakemisto on jo suojattu.",
    'pdir_ed__head_txt' => "Suojatun alueen otsikko",
    'pdir_ed__invalid_login' => "Määritetty käyttäjänimi on virheellinen.",
    'pdir_ed__login_exists' => "Tämä käyttäjä on jo olemassa. Valitse toinen käyttäjänimi.",
    'pdir_ed__new_usr' => "Käyttäjänimi",
    'pdir_ed__non_ssl' => "Muu kuin SSL/TLS",
    'pdir_ed__cgi_bin' => "cgi-bin",
    'pdir_ed__path' => "Hakemiston nimi",
    'pdir_ed__pdir_for_domain' => "Suojattu hakemisto %1 toimialueella %2",
    'pdir_ed__pdir_for_subdomain' => "Suojattu hakemisto %1 alitoimialueessa %2",
    'pdir_ed__pdir_location' => "Hakemiston sijainti",
    'pdir_ed__pdir_users' => "Suojatut hakemiston käyttäjät",
    'pdir_ed__ssl' => "SSL/TLS",
    'pdir_ed__ssl_not_supported_domain' => "Tämä sivusto ei tue SSL/TLS:ää tai SSL/TLS:ää ei ole tilauksessasi. Kun haluat ottaa SSL/TLS-tuen käyttöön, siirry Verkkosivustot & toimialueet -välilehdelle ja valitse toimialueesi nimi luettelosta. Jos tilaukseesi ei kuulu SSL/TLS-tukea, ota yhteys isännöintipalvelujen tarjoajaan päivittääksesi isännöintisuunnitelmasi.",
    'pdir_ed__ssl_not_supported_domain_powerUser' => "Tämä sivusto ei tue SSL/TLS:ää. Kun haluat ottaa SSL/TLS-tuen käyttöön, siirry Verkkosivustot & toimialueet -välilehdelle ja valitse toimialueen nimi luettelosta.",
    'pdir_ed__ssl_or_nonssl_should_be_checked' => "Vähintään yksi SSL/TLS- ja Muu kuin SSL/TLS -valintaruuduista on valittava.",
    'pdir_ed__unable_cr_pdir_usr' => "Suojatun hakemiston käyttäjää ei voi luoda: %1",
    'pdir_ed__unable_create_pdir' => "Suojattua hakemistoa ei voi luoda: %1",
    'pdir_ed__unable_define_hst_type' => "Isännöintityyppiä ei voi määrittää.",
    'pdir_ed__unable_update_pdir' => "Suojatun hakemiston asetuksia ei voida tallentaa: %1",
    'pdir_ed__wrong_symbol_in_header' => "Älä käytä %1-merkkiä hakemiston otsikossa.",
    'pdir_usr_ed__create_pdir_usr_for_pd' => "Luo käyttäjä suojatulle hakemistolle %1",
    'pdir_usr_ed__not_create_pass' => "Tällöin ei luoda salasanaa uudelle suojatun hakemiston käyttäjälle.\nKäyttäjä ei voi kirjautua sisään ilman salasanaa.",
    'pdir_usr_ed__pass_for_pdir_usr' => "Suojatun hakemiston käyttäjän %1 salasana",
    'pdir_usr_ed__unable_select_pdir_usr' => "Suojatun hakemiston käyttäjää ei voi valita: %1",
    'pdir_usrs_list__unable_define_pdir_usrs' => "Suojatun hakemiston käyttäjiä ei voi määrittää: %1",
    'pdir_usrs_list__unable_remove_pd_usrs' => "Suojatun hakemiston käyttäjiä ei voi poistaa: %1",
    'pdirs_list__name' => "Nimi",
    'pdirs_list__tab_title_non_secure_dir' => "N",
    'pdirs_list__tab_title_secure_dir' => "S",
    'pdirs_list__tab_title_cgi_bin_dir' => "C",
    'pdirs_list__unable_remove_pdirs' => "Suojattuja hakemistoja ei voi poistaa: %1",
    'phosting__anonftp_disabled' => "Anonyymi FTP-palvelu ei ole käytettävissä tässä toimialueessa, koska tämä IP-osoite on jo anonyymin FTP-palvelun käytössä toisessa toimialueessa.",
    'phosting__anonftp_encrypt' => 'FTP-käyttäjän salasana on salattu, sitä ei voida täten käyttää hakemiston /plesk-stat/webstat/ suojaamiseen. Syötä FTP-salasana uudelleen, tai poista valinta valinnasta "käytettävissä salasanalla suojatun hakemiston \'/plesk-stat/webstat/\' kautta"',
    'phosting__hosting_and_dns_ip_difference_warning' => "Toimialueen nimi %%domain_name%% yhdistyy IP-osoitteeseen %%dns_ip_address%%. Verkkosivustollesi on määritetty IP-osoite %%hosting_ip_address%%. Jos verkkosivustosi ei avaudu WWW-selaimessa, kun käytät sen toimialueen nimeä, siirry DNS:n hallintanäyttöön (Toimialueet > Toimialueen nimi > DNS) ja muuta A-resurssitietueen ominaisuuksia: määritä IP-osoite %%hosting_ip_address%% toimialueen nimelle %%domain_name%%.",
    'phosting__ip_change_warning' => "IP-osoite muutettiin. Vastaavat muutokset tehtiin myös toimialueen DNS-vyöhykkeessä.",
    'phosting__other_hosting_exists_on_ip' => "Varmennetta ei voi muuttaa, koska tätä IP-osoitetta käytetään yhdessä tai useammassa isännöintitilissä.",
    'phosting__unable_to_change_certificate' => "Varmennetta ei voi asentaa: %1",
    'phosting__unable_to_change_ip_address' => "IP-osoitetta ei voi muuttaa: %1",
    'phosting__unable_to_set_cert' => "SSL/TLS-varmennetta ei voi määrittää: %1",
    'phosting__unable_update' => "Isännöintiasetuksia ei voi päivittää: %1",
    'phosting__unable_manage' => "Isännöintiä ei voi hallita: %1",
    'phosting__failed_to_add_logs_fail2ban' => "Fail2bania ei voitu määrittää seuraamaan lokeja toimialueelta. Lokeja seurataan automaattisesti, kun Fail2ban-palvelin käynnistyy uudelleen seuraavan kerran.\n%1",

    'picker_acl_record__tittle' => 'Valitse ACL-tietue',
    'picker_autoresponder__title' => 'Valitse automaattinen vastaus',
    'picker_black_list__domain_name' => 'Valitse toimialuenimi',
    'picker_certificate' => 'Valitse yksi SSL/TLS-varmenne',

    'picker_dns_zone_template__title' => 'Valitse resurssitietue',
    'picker_domain__title' => 'Valitse verkkosivusto',
    'picker_domain_alias__title' => 'Valitse toimialueen alias',
    'picker_resource_record__title' => 'Valitse resurssitietue',
    'picker_disabled_resource_record__title' => 'Valitse nimipalvelin',
    'picker_ip_address__title' => 'Valitse IP-osoite',
    'picker_ip_address_clients__title' => 'Valitse asiakkaat, jotka käyttävät tätä IP-osoitetta',
    'picker_mail_queue' => 'Valitse sähköpostiviestit',
    'picker_site_application__title' => 'Valitse Web-sovellus',
    'picker_subdomain__title' => 'Valitse alitoimialue',
    'picker_web_user__title' => 'Valitse Internet-käyttäjä',
    'picker_custom_button__title' => 'Valitse Mukautettu painike',
    'picker_license_key__title' => "Käyttöoikeusavaimen valinta",
    'picker_spamfilter_address__title' => 'Valitse roskapostisuodattimen osoite',
    'picker_white_list__networks' => 'Verkkojen valinta',

    'plesk_key__action_logs' => "Plesk -käyttäjien suorittamien toimintojen kirjaaminen",
    'plesk_key__app_vault' => "Application Vault",
    'plesk_key__backup' => "Varmuuskopiointi- ja palautustoiminnot",
    'plesk_key__client_templs' => "Palvelusuunnitelmien hallinta",
    'plesk_key__clients' => "Käyttäjätilit (jälleenmyyjät ja asiakkaat)",
    'plesk_key__resellers_only' => "Käyttäjätilit (jälleenmyyjät)",
    'plesk_key__customers_only' => "Käyttäjätilit (asiakkaat)",
    'plesk_key__domains' => "Toimialueet",
    'plesk_key__domain_aliases' => "Toimialueen aliakset",
    'plesk_key__manage_dashboard' => 'Kotisivun mukautus',
    'plesk_key__drweb' => "Virustentorjuntaohjelman hallinta",
    'plesk_key__event_manager' => "Tapahtumanhallinta",
    'plesk_key__expirations' => "Tilin päättymispäivien hallinta",
    'plesk_key__group_ops' => "Useiden objektien samanaikainen muokkaus",
    'plesk_key__expiration' => "Avaimen päättymispäivä",
    'plesk_key__edition_name' => "Plesk-versio",
    'plesk_key__key_number' => "Avaimen numero",
    'plesk_key__languages' => "Kielipaketit",
    'plesk_key__mailnames' => "Sähköpostitilit",
    'plesk_key__migration_manager' => "Migration & Transfer Manager",
    'plesk_key__mssql' => "Microsoft SQL Server -tuki",
    'plesk_key__myplesk_func' => "Linkit SSL/TLS-varmenteiden ja toimialueen rekisteröintipalvelujen ostamiseksi",
    'plesk_key__myplesk_server_id' => "MPC-orjapalvelimen tunnus",
    'plesk_key__notifications' => "Ilmoitusten hallinta",
    'plesk_key__postgresql' => "PostgreSQL-tietokantapalvelimen tuki",
    'plesk_key__qmail_queue' => 'Postijonon hallinta',
    'plesk_key__remote_db' => 'Etätietokannan isännöinti',
    'plesk_key__slave_servers' => "Orjapalvelimet",
    'plesk_key__spamassassin' => "Roskapostisuodattimen hallinta",
    'plesk_key__subdomains' => "Alitoimialueiden hallinta",
    'plesk_key__sys_access' => "Palvelimelle pääsyoikeuden hallinta",
    'plesk_key__traffic_reports' => "Liikenteen käyttötietoraportit",
    'plesk_key__tts' => "Tukipalvelu",
    'plesk_key__virtuozzo' => "Kelpaa vain Virtuozzo containers -tuotteelle",
    'plesk_key__webusers' => "Internet-käyttäjät",
    'plesk_key__license_update_date' => 'Seuraava käyttöoikeusavaimen päivitys',
    'plesk_key__autoinstaller_config' => 'Päivitystyökalun asetusten hallinta',
    'plesk_key__check_wrong' => "Käyttöoikeusavain ei kelpaa. Pleskin käyttäminen edellyttää, että saat ja asennat uuden hyväksyttävän käyttöoikeusavaimen.",
    'plesk_key__upload_check_wrong' => 'Ladattu käyttöoikeusavain ei kelpaa.',
    'plesk_key__revert_check_wrong' => 'Aiemmin asennettu käyttöoikeusavain ei kelpaa.',
    'plesk_key__update_check_wrong' => 'Päivitetty käyttöoikeusavain ei kelpaa.',
    'plesk_key__viruozzo_only_key' => 'Käyttöoikeusavain on tarkoitettu käytettäväksi vain Plesk -ratkaisussa Virtuozzo containers -järjestelmässä.',
    'plesk_key__ip_ranges_exceeded' => 'Voit käyttää tätä käyttöoikeuden omaavaa Plesk -kopiota vain seuraavilla IP-osoitteilla: %2. Käyttöoikeutesi ei kata seuraavia IP-osoitteita: %1.', //%1 not allowed addresses list separated by comma, %2 allowed IP addresses list separated by comma
    'plesk_key__limits_exceeded' => 'Tällä hetkellä käytettyjen resurssien määrä ylittää käyttöoikeutesi määrittämät rajat.',
    // For the keys below: %1 limit value, %2 used value, %3 delta value
    'plesk_key__limits_exceeded_lim_dom' => 'Palvelimessa isännöityjen verkkosivustojen määrä ylittää käyttöoikeutesi määrittämät rajat. Hallinnoit tällä hetkellä %2 sivustoa; käyttöoikeutesi sallii vain %1 sivuston hallinnoinnin.',
    'plesk_key__limits_exceeded_lim_domain_aliases' => 'Palvelimen useat toimialueen aliakset ylittävät käyttöoikeutesi määrittämät rajat. Sinulla on %2 toimialueen aliasta; käyttöoikeutesi sallii vain %1 toimialueen aliaksen isännöinnin.',
    'plesk_key__limits_exceeded_lim_cl' => 'Hallinnoitujen asiakastilien määrä ylittää käyttöoikeutesi määrittämät rajat. Hallinnoit tällä hetkellä %2 asiakastiliä; käyttöoikeutesi sallii vain %1 asiakastilin hallinnoinnin.',
    'plesk_key__limits_exceeded_lim_mn' => 'Hallinnoitujen sähköpostitilien määrä ylittää käyttöoikeutesi määrittämät rajat. Hallinnoit tällä hetkellä %2 sähköpostitiliä; käyttöoikeutesi sallii vain %1 sähköpostitilin hallinnoinnin.',
    'plesk_key__limits_exceeded_lim_wu' => 'Hallinnoitujen Internet-käyttäjän tilien määrä ylittää käyttöoikeutesi määrittämät rajat. Hallinnoit tällä hetkellä %2 Internet-käyttäjän tiliä; käyttöoikeutesi sallii vain %1 Internet-käyttäjän tilin hallinnoinnin.',
    'plesk_key__limits_exceeded_MLS' => 'Tällä hetkellä asennettujen kielipakettien määrä ylittää käyttöoikeutesi määrittämät rajat. %2 kielipaketti(a) on asennettu; käyttöoikeutesi sallii vain %1 kielipaketin asennuksen.',
    'plesk_key__wrong_version' => 'Yrität käyttää käyttöoikeusavainta, joka on luotu toiselle Plesk -versiolle. Ota yhteys Pleskin myyntiedustajaan hankkiaksesi oikean käyttöoikeusavaimen.',
    'plesk_key__other_product' => 'Yrität käyttää käyttöoikeusavainta, joka on luotu toiselle tuotteelle. Ota yhteys Pleskin myyntiedustajaan hankkiaksesi oikean käyttöoikeusavaimen.',
    'plesk_key__limits_exceeded_error' => 'Käyttöoikeusavainta ei voida asentaa: nykyinen käytettyjen resurssien määrä ylittää ladatussa käyttöoikeusavaimessa määritetyt rajat.',
    'plesk_key__limits_exceeded_note' => 'Nykyinen käytettyjen resurssien määrä ylittää ladatussa käyttöoikeusavaimessa määritetyt rajat.',
    'plesk_key__key_file_invalid' => 'Ladattu avaintiedosto ei kelpaa tai ei sisällä käyttöoikeusavainta.',
    'plesk_key__server_request_error' => 'Käyttöoikeutta ei voitu päivittää. Varmista, ettei yhteyksiä käyttöoikeuspalvelimeen ka.plesk.com ole estetty TCP-portissa %1. <a href="https://support.plesk.com/hc/en-us/articles/213383529" target="_blank">Katso toimintaohjeet</a>.',
    'key__no_key_file_in_zip' => 'Ladattu .zip-tiedosto ei sisällä avaintiedostoa',
    'key__key_upload' => 'Käyttöoikeusavaimen asennus',
    'additional_key__prop_name' => 'Ominaisuus',
    'additional_key__prop_value' => 'Arvo',
    'additional_key__descr_name' => 'Näppäimen nimi',
    'additional_key__descr_key_number' => 'Avaimen numero',
    'additional_key__descr_key_vz' => "Tämä käyttöoikeusavain on tarkoitettu käytettäväksi vain Virtuozzo containers -järjestelmässä.",
    'additional_key__descr_key_mailboxes' => 'Postilaatikot',
    'additional_key__descr_lim_date' => 'Vanhentumispäivä',
    'additional_key__descr_license_update_date' => 'Seuraava käyttöoikeusavaimen päivitys',
    'additional_key__file_invalid' => 'Ladattu avaintiedosto ei kelpaa tai ei sisällä käyttöoikeusavainta.',
    'additional_key__file_incompatible' => 'Ladattu avaintiedosto ei kelpaa tälle sovellukselle.',
    'additional_key__expired' => 'Tämä lisäavain on vanhentunut.',
    'additional_key__not_exists' => 'Käyttöoikeusavainta ei ole asennettu.',
    'additional_key__viruozzo_only_key' => 'Tämä käyttöoikeusavain on tarkoitettu käytettäväksi vain Plesk -ratkaisuun, joka on asennettu Virtuozzo Containers -järjestelmään.',
    'additional_key_update__result_response' => 'Käyttöoikeuden tarjoavan palvelimen vaste: %1',
    'additional_key_update__result_network' => 'Käyttöoikeuspalvelimelle ei saada yhteyttä. Varmista, että verkkosi sallii viestinnän %1: %2.',
    'additional_key_update__result_lock' => 'Avaimen päivitys on jo käynnissä',
    'additional_key_update__result_internal_error' => 'Virhe tapahtui käyttöoikeusavaimen päivityksen aikana: %1',

    'proceed_to_cl_pool' => "Siirry asiakkaan IP-ryhmän määritykseen",
    'proceed_to_hosting_setup' => "Siirry isännöinnin määritykseen",
    'removeCerts__remove_certificates_cp' => "Seuraavat varmenteet poistetaan:",
    'removeCerts__remove_certificates_domain' => "Seuraavat kohteen %1 omistamat varmenteet poistetaan:",
    'removeClientsIP_remove_clients_ip' => "Tämä IP-osoite poistetaan seuraavien asiakkaiden ryhmistä:",
    'removeMailAliases__remove_mail_aliases' => "Seuraavat sähköpostitilin %1 sähköpostialiakset poistetaan:",
    'removeMailNames__remove_mailnames' => "Seuraavat sähköpostitilit ja aliakset poistetaan toimialueelta %1:",
    'removeMailNames__remove_mailnames_of_cl' => "Seuraavat sähköpostitilit ja aliakset poistetaan toimialueelta %2, jonka omistaa %1:",
    'removeMailNames__these_mailnames_will_not_delete' => "Näitä sähköpostitilejä ei poisteta.",
    'removeFtpSessions__remove_title' => "Seuraavat FTP-istunnot lopetetaan:",
    'removeTemplates__remove_templates' => "Seuraavat mallit poistetaan:",
    'report_auto__list_title' => 'D',
    'report_auto__list_auto' => 'Suoritusväli',
    'report_auto__list_last' => 'Viimeinen toimituspvm',
    'report_auto__list_recipient' => 'Toimitusosoite',
    'report_auto__list_select' => 'Raportoi seuraavasta',
    'report_auto__title' => 'Kohteen %1 toimitusaikataulut',
    'report_auto__recipient_email' => 'sähköposti, jonka määritän',
    'report_auto__recipient_admin' => 'palvelimen järjestelmänvalvoja',
    'report_auto__recipient_client' => 'asiakas',
    'report_auto__recipient_domain' => 'toimialueen järjestelmänvalvoja',
    'report_auto_edit__select' => 'Raportoi seuraavasta',
    'report_auto__select_client_report_all' => 'kaikki asiakkaat',
    'report_auto__select_client_report_current' => 'tämä asiakas',
    'report_auto__select_client_report_other_client' => '%1',
    'report_auto__select_domain_report_all' => 'kaikki toimialueet',
    'report_auto__select_domain_report_other_client' => 'kaikki toimialueet %1',
    'report_auto__select_domain_report_client' => 'kaikki tämän asiakkaan toimialueet',
    'report_auto__select_domain_report_reseller' => 'kaikki tämän jälleenmyyjän toimialueet',
    'report_auto__select_domain_report_current' => 'Tämä toimialue',
    'report_auto__select_domain_report_other_domain' => '%1',
    'report_auto__legend' => 'Toimitusaikataulut',
    'report_auto__select_for_remove' => "Valitse poistettavat toimitusaikataulut.",
    'report_auto_remove__title' => "Seuraavat raportin toimitusaikataulut poistetaan:",
    'report_auto_edit__title' => 'Toimitusaikataulun ominaisuudet',
    'report_auto_edit__recipient' => 'Toimitusosoite',
    'report_auto_edit__target' => 'Raportoi seuraavasta',
    'report_auto_edit__auto' => 'Toimitusväli',
    'resp_edit__always_respond' => "vastaa aina",
    'resp_edit__reply_subject' => "Vastauksen aihe",
    'resp_edit__answer_subject' => "Vastaa aiheella",
    'resp_edit__answer_txt' => "Liitä teksti vastaukseen",
    'resp_edit__attach' => "Liitä tiedostoja",
    'resp_edit__default_subject' => "VS: %1",
    'resp_edit__for' => "käyttäjälle",
    'resp_edit__frw_rqst_email' => "Lähetä alkuperäinen viesti automaattisen vastauksen yhteydessä edelleen määritettyyn sähköpostiin",
    'resp_edit__fwd_email_invalid' => "Kohdesähköpostiosoite on virheellinen.",
    'resp_edit__in_body' => "kun määritetyt sanat löytyvät viestin tekstistä",
    'resp_edit__in_subject' => "kun määritetyt sanat löytyvät viestin aiheesta",
    'resp_edit__invalid_resp_freq' => "Vastaustiheys on virheellinen.",
    'resp_edit__invalid_rqst_txt' => "Virheellinen pyyntöteksti.",
    'resp_edit__invalid_store_lim_num' => "Raja-arvo ei kelpaa.",
    'resp_edit__limits_title' => "Rajat",
    'resp_edit__maximum_allowed_resp_freq_reached' => "Vastausten enimmäismäärä päivässä ylittää määritetyn arvon. Sallittu: %1, pyydetyt : %2",
    'resp_edit__no_files_sel' => "Tiedostoja ei ole valittu.",
    'resp_edit__no_txt_supplied' => "Ei tekstiä.",
    'resp_edit__reply_title' => "Vastaa",
    'resp_edit__reply_to_address' => "Palautusosoite",
    'resp_edit__reply_to_invalid' => "Palautusosoite on virheellinen.",
    'resp_edit__reply_uniq_email' => "Vastausten enimmäismäärä yksilölliseen sähköpostiosoitteeseen:",
    'resp_edit__conditions_title' => "Ehdot",
    'resp_edit__request_title' => "Pyyntö",
    'resp_edit__resp' => "Automaattinen vastaus",
    'resp_edit__resp_name' => "Automaattisen vastauksen nimi",
    'resp_edit__resp_not_exist' => "Automaattista vastausta ei ole.",
    'resp_edit__resp_status' => "Automaattisen vastauksen tila",
    'resp_edit__rqst_txt' => 'Määritä tämän automaattisen vastauksen ehto',
    'resp_edit__select_files_on_server_for_attach' => "Valitse tiedostot, jotka haluat liittää",
    'resp_edit__store_up_to' => "Tallennuksen kesto:",
    'resp_edit__subj_line_invalid' => "Aiherivi on virheellinen.",
    'resp_edit__text_too_big' => "Vastausviestin teksti on liian suuri.",
    'resp_edit__times_in_a_day' => "kertaa päivässä.",
    'resp_edit__unable_define_resp_cond' => "Automaattisen vastauksen ehtoa ei voi määrittää: %1",
    'resp_edit__unable_define_resp_status' => "Automaattisen vastauksen tilaa ei voi määrittää: %1",
    'resp_edit__unable_turn_on_resp' => "Automaattista vastausta ei voi ottaa käyttöön: %1",
    'resp_edit__uniq_email' => "yksilölliset sähköpostiosoitteet",
    'resp_edit__content_type' => 'Sähköpostin lähetysmuoto',
    'resp_edit__content_type_text' => 'Vain teksti',
    'resp_edit__content_type_html' => 'HTML',
    'resp_edit__charset' => 'Koodaus',
    'restart__dns' => 'DNS-palvelin (%1)',
    'restart__drweb' => 'Plesk Premium Antivirus',
    'restart__mail' => "IMAP/POP3-palvelin (%1)",
    'restart__mssql' => "Microsoft SQL Server",
    'restart__mysql' => "MySQL-palvelin",
    'restart__postgresql' => "PostgreSQL",
    'restart__psa' => "Palvelut",
    'restart__smtp' => "SMTP-palvelin (%1)",
    'restart__spamd' => "Roskapostisuodatin",
    'restart__spamassassin' => "SpamAssassin",
    'restart__stunnel' => "Stunnel",
    'restart__web' => "Verkkopalvelin (%1)",
    'restart__ftp' => "FTP-palvelin (%1)",
    'restart__service_start' => 'Odota jonkin aikaa, että palvelu käynnistyy.',
    'restart__service_stop' => 'Odota jonkin aikaa, että palvelu pysähtyy.',
    'restart__service_restart' => 'Odota jonkin aikaa, että palvelu käynnistyy uudelleen.',
    'rm_domains__some_domains_are_not_exist' => "Joitakin määritetyistä toimialueista ei ole. Toinen käyttäjä on voinut poistaa ne.",
    'rpt_cl_dom_data_bases' => "DBMySQL",
    'rpt_cl_dom_mssql_data_bases' => "DBMSSQL",
    'rpt_cl_dom_mail_groups' => "MGroups",
    'rpt_cl_dom_mail_lists' => "MLists",
    'rpt_cl_dom_mail_resps' => "AResp.",
    'rpt_cl_dom_mail_antispam' => "AntiSpam",
    'rpt_cl_dom_mail_antivirus' => "Virustentorjunta",
    'rpt_cl_dom_postboxes' => "MBoxes",
    'rpt_cl_dom_redirects' => "Välittäjät",
    'rpt_cl_dom_subdomains' => "Alitoimialue",
    'rpt_cl_dom_domain_aliases' => "DAliases",
    'rpt_cl_dom_web_users' => "WUsers",
    'rpt_cl_report_for_admin__' => "Järjestelmänvalvojan %1 raportti",
    'rpt_cl_report_for_reseller__' => "Raportti jälleenmyyjästä %1",
    'rpt_cl_report_for_cl__' => "Raportti asiakkaasta %1",
    'rpt_cl_section_domains' => "Toimialueet",
    'rpt_cl_section_full_domains' => "Toimialueet",
    'rpt_cl_section_general' => "Yleiset",
    'rpt_create' => "Luo raportti",
    'rpt_empty' => "Raportissa on oltava vähintään yksi osio",
    'rpt_default_report' => "Käytä oletusraporttina",
    'rpt_dom_report_for_dom__' => "Toimialueen raportti kohteelle %1",
    'rpt_dom_section_databases' => "Tietokannat",
    'rpt_dom_section_full_databases' => "Tietokannat",
    'rpt_dom_section_full_maillists' => "Postituslistat",
    'rpt_dom_section_full_mailnames' => "Sähköpostitilit",
    'rpt_dom_section_full_webusers' => "Internet-käyttäjät",
    'rpt_dom_section_full_siteapps' => 'Verkkosovellukset',
    'rpt_dom_section_full_aspnetapps' => 'ASP.NET-verkkosovellukset',
    'rpt_dom_section_general' => "Yleiset",
    'rpt_dom_section_hosting' => "Isännöinti",
    'rpt_dom_section_maillists' => "Postituslistat",
    'rpt_dom_section_mailnames' => "Sähköpostitilit",
    'rpt_dom_section_siteapps' => 'Verkkosovellukset',
    'rpt_dom_section_aspnetapps' => 'ASP.NET-verkkosovellukset',
    'rpt_dom_section_webusers' => "Internet-käyttäjät",
    'rpt_dom_title_wa_status' => "S",
    'rpt_edit__' => "Muokkaa raporttia %1",
    'rpt_enter_email_address' => "Anna sähköpostiosoite, johon raportti toimitetaan.",
    'rpt_list' => "Mukautetut raporttiasettelut",
    'rpt_name' => "Raportin nimi",
    'rpt_remove_reports' => "Seuraavat raporttiasettelut poistetaan:",
    'rpt_reports' => "Raportit",
    'rpt_section_full' => "Täysi",
    'rpt_section_none' => "Ei ole",
    'rpt_section_summary' => "Yhteenveto",
    'rpt_select_reports_for_remove' => "Valitse poistettavat raporttiasettelut.",
    'rpt_default_full' => 'Täydellinen raportti',
    'rpt_default_summary' => 'Yhteenvetoraportti',

    // end of kooper part

    // pit part

    'rpt_send_report_by_email_error__' => "Virhe lähetettäessä raporttia: %1",
    'rpt_send_report_by_email_ok__' => "Raportti lähetettiin kohteeseen %1",
    'sa_action' => "Toiminto",
    'sa_action_del' => "Poista",
    'sa_action_desc' => "Mitä teen roskapostille",
    'sa_action_save' => "Merkitse roskapostiksi ja tallenna postilaatikkoon",
    'sa_admin_blacklist' => "Järjestelmänvalvojan musta lista",
    'sa_admin_whitelist' => "Järjestelmänvalvojan sallittujen lista",
    'sa_db_del_confirm' => "Haluatko varmasti tyhjentää Roskapostisuodatin-tietokannan?",
    'sa_eml_in_ignorelist' => "Sähköposti on ohita-luettelossa",
    'sa_empty_email' => "Tyhjää sähköpostimallia ei voida lisätä.",
    'sa_exists_email' => "Vastaava sähköpostimalli on jo olemassa.",
    'sa_disabled__mailname_not_filtering' => "Nykyiset palvelinasetukset eivät salli sähköpostin suodattamisen käyttöä tälle sähköpostitilille",
    'sa_disabled__filtering_is_disabled' => 'Palvelimen järjestelmänvalvoja poisti roskapostisuodatuksen käytöstä',
    'sa_disabled__hasnt_mailbox' => "Roskapostisuodatusta ei voida ottaa käyttöön ilman postilaatikkoa",
    'sa_enable_filter' => "Ota roskapostisuodatus käyttöön",
    'sa_forget' => "Unohda",
    'sa_from' => "Lähettäjä",
    'sa_ham' => "hyväksyttävä posti",
    'sa_pattern_is_invalid' => "Malli on virheellinen.",
    'sa_spam' => "roskaposti",
    'sa_trainer__page_title' => 'Roskapostisuodattimen opettaminen',
    'sa_trainer__tools_legend' => 'Työkalut',
    'sa_trainer__info_legend' => 'Tiedot',
    'sa_trainer__messages_list_legend' => 'Postilaatikossasi olevat viestit',
    'sa_trainer__c' => 'T',
    'sa_trainer__l' => 'L',
    'sa_trainer__subject' => 'Aihe',
    'sa_trainer__from' => 'Lähettäjä',
    'sa_trainer__date' => 'Pvm',
    'sa_trainer__info_text' => 'Opitut viestit: %1 roskapostina, %2 ei-roskapostina, %3 yhteensä.',
    'sa_trainer__messages' => 'viesti(ä)',
    'sa_trainer__select__all' => 'Kaikki',
    'sa_trainer__select__spam_only' => 'Roskaposti',
    'sa_trainer__select__ham_only' => 'Ei-roskaposti',
    'sa_trainer__select__unknown_only' => 'Tuntematon',
    'sa_trainer__cannot_remove_messages' => 'Valittuja viestejä ei voi poistaa postilaatikosta.',
    'sa_trainer__remove_messages_confirm' => 'Haluatko varmasti poistaa valitut viestit postilaatikosta?',
    'sa_subj' => "Aihe",
    'sa_training' => "Roskapostisuodattimen opettaminen",
    'sa_training_legend' => "Bayesläinen suodatuksen koulutus",
    'sa_use_srv_settings' => "Käytä palvelinlaajuisia asetuksia",
    'sa_user_blacklist' => "Käyttäjän musta lista",
    'sa_user_whitelist' => "Käyttäjän valkoinen lista",
    'sa_usr_disabled_by_srv' => "Palvelimen järjestelmänvalvoja ei salli yksilöllisiä roskapostisuodatusasetuksia",
    'sa_usr_no_postbox' => "Roskapostin suodatusta ei voida ottaa käyttöön, koska postilaatikko on poistettu käytöstä tässä sähköpostitilissä.",
    'sa_filters' => 'Roskapostisuodattimet',
    'spamfilter__tools_legend' => 'Työkalut',
    'spamfilter__prefs_legend' => 'Asetukset',
    'spamfilter__max_children' => 'Työntekijän suoritettavien roskapostiprosessien maksimimäärä',
    'spamfilter__rewrite_header_subject_hint' => 'Jätä tämä kenttä tyhjäksi, jos et halua lisätä tekstiä. Kirjoita _SCORE_, jos haluat sisällyttää tuloksen viestin aiheeseen.',
    'spamfilter__reject_spam' => 'Poista roskaposti, kun se saapuu postilaatikkoon',
    'spamfilter__enabled' => 'Otettu käyttöön',
    'spamfilter_addresses_list__tools_legend' => 'Työkalut',
    'spamfilter_addresses_list__list_legend' => 'Osoitteet',
    'spamfilter_addresses_list__items' => 'osoitteet',
    'spamfilter_addresses_list__status' => 'S',
    'spamfilter_addresses_list__level' => 'L',
    'spamfilter_addresses_list__address' => 'Osoite',
    'spamfilter_addresses__file_legend' => 'Tiedostosta',
    'spamfilter_addresses__file_label' => 'Tiedoston nimi',
    'spamfilter_addresses__file_hint' => 'Lataa tiedosto UTF-8-koodauksella.',
    'spamfilter_addresses__text_legend' => 'Luettelosta',
    'spamfilter_addresses__text_label' => 'Sähköpostiosoitteet',
    'spamfilter_addresses__remove_title' => 'Seuraavat osoitteet poistetaan luettelosta:',
    'spamfilter_addresses__empty_selection' => 'Osoitteita ei ole valittu.',
    'server__admin_info' => "Järjestelmänvalvojan tiedot",
    'server__ctrl_panel' => "Plesk",
    'server__enter_bug_essence_below' => "Anna seuraava virhekuvaus",
    'server__power_management' => "Virranhallinta",
    'server__services' => "Palvelut",
    'server__system' => "Järjestelmä",
    'server__title' => "Palvelimen hallinta",
    'server_preferences__admin_skin' => "Järjestelmänvalvojan liittymän ulkoasu",
    'server_preferences__default_language' => "Oletuskieli",
    'server_preferences__default_skin' => "Oletusulkoasu",
    'server_preferences__restart_apache_interval' => "Apachen uudelleenkäynnistysväli",
    'server_preferences__system' => 'Järjestelmän asetukset',
    'mail__tabs_preferences' => "Asetukset",
    'mail__tabs_white_list' => "Valkoinen lista",
    'server_preferences__use_vocabulary' => "Tarkista postilaatikoiden salasanat hakemistossa",
    'sessions__agreement' => "Kyllä, haluan lopettaa nämä istunnot.",
    'sessions__select_sessions_for_remove' => "Valitse lopetettavat istunnot.",
    'sessions__tabs_cp_sessions' => 'Plesk-istunnot',
    'sessions__tabs_ftp_sessions' => 'FTP-istunnot',
    'sessions__ftp_sessions_login' => 'FTP-tilin käyttäjänimi',
    'sessions__ftp_sessions_domain' => 'Toimialueen nimi',
    'sessions__ftp_sessions_path' => 'Nykyinen sijainti',
    'sessions__ftp_sessions_file' => 'Tiedoston nimi',
    'sessions__ftp_sessions_action' => 'Tila',
    'sessions__ftp_sessions_speed' => 'Nopeus, kt/s',
    'sessions__ftp_sessions_comp' => 'Edistyminen, %',

    'site_apps__access_level' => 'Käyttöoikeustaso',
    'site_apps__access_level_commercial' => 'Kaupallinen',
    'site_apps__access_level_free' => 'Vapaana',
    'site_apps__action_installer' => "Web-sovelluksen asentaminen",
    'site_apps__action_reconfigure' => "Verkkosovelluksen uudelleenmääritys",
    'site_apps__custom_button_level' => 'Haluatko luoda mukautetun painikkeen tämän sovelluksen käyttöä varten?',
    'site_apps__custom_button_level_false_domain_user_only' => 'Ei',
    'site_apps__custom_button_level_domain_user_only' => 'Kyllä',
    'site_apps__custom_button_level_false' => 'Ei',
    'site_apps__custom_button_level_domain' => 'Kyllä, aseta se vain nykyisen toimialueen käytettäväksi',
    'site_apps__custom_button_level_client' => 'Kyllä, aseta se asiakkaan kaikkien toimialueiden käytettäväksi',
    'site_apps__custom_button_level_admin' => 'Kyllä, aseta se kaikkien toimialueiden käytettäväksi',
    'site_apps__description' => "Kuvaus",
    'site_apps__dir_used_by_sapp__' => "Hakemisto \"%1\" on toisen verkkosovelluksen käytössä",
    'site_apps__dir_used_by_unknown__' => "Hakemisto \"%1\" on jo olemassa. Jos jatkat, sen sisältö korvataan.",
    'site_apps__dir_invalid_name__' => "Hakemiston nimi %1 ei ole kelvollinen",
    'site_apps__file_name' => 'Verkkosovelluksen tiedostonimi',
    'site_apps__invalid_install_prefix' => "Virheellinen asennuksen etuliite",
    'site_apps__invalid_package' => "Verkkosovellus on virheellinen",
    'site_apps__key_status' => 'Käyttöoikeus',
    'site_apps__key_status_free' => 'Jaettu vapaasti. Käyttöoikeusavainta ei tarvita',
    'site_apps__key_status_ok' => 'Tarvittava käyttöoikeusavain on asennettu',
    'site_apps__key_status_problem' => 'Tarvittavaa käyttöoikeusavainta ei ole asennettu',
    'site_apps__name' => "Nimi",
    'site_apps__no_domains' => 'Verkkosovellusta ei voida asentaa. Tämän toimialueen päähakemistoon on jo asennettu toinen verkkosovellus. Harkitse alitoimialueen luomista verkkosovellukseen.',
    'site_apps__package_info_' => "Verkkosovelluksen tiedot",
    'site_apps__package_integrated' => "oletussovellus, ei voi poistaa",
    'site_apps__pool_select_packages_to_add' => 'Valitse sarjaan lisättävät verkkosovellukset',
    'site_apps__release' => "Julkaisu",
    'site_apps__resource_used_by_sapp' => "Asennettu verkkosovellus käyttää tätä resurssia",
    'site_apps__root_used_by_sapp' => "Asennettu verkkosovellus käyttää tätä resurssia",
    'site_apps__these_domains_will_not_delete' => 'Näitä (ali-)toimialueita ei poisteta',
    'site_apps__upload_site_app_pkg_title' => 'Lataa uusi verkkosovellus',
    'site_apps__version' => "Versio",
    'site_apps__access_to' => "Käyttöoikeus %1",
    'site_builder_requires' => '%1 - %3',
    'skeleton__admin_label' => "Virtuaalisen isännän malli",
    'skeleton__client_label' => "%1 virtuaalisen isännän malli",
    'skeleton__admin_page' => "Hallitse virtuaalisen isännän mallia",
    'skeleton__files_list' => "Tiedostot ja hakemistot",
    'skeleton__archiver_not_installed' => "Arkistoa ei voi purkaa. Arkistoijaa ei ole ehkä asennettu palvelimeen. Ota yhteys {$PROD_NAME} -järjestelmänvalvojaan arkistoijaohjelmiston asentamiseksi.",
    'skeleton__client_page' => "Hallitse virtuaalisen isännän mallia",
    'skeleton__archive_corrupted' => "Arkiston tarkastuksen aikana havaittiin, että arkistotiedosto on joko vioittunut tai tätä arkistotyyppiä ei tueta.",
    'skeleton__archive_too_large' => "Arkiston tarkastuksen aikana havaittiin, että arkistotiedosto on liian suuri.",
    'skeleton__not_supported_archive_type' => "Tätä arkistotyyppiä (tiedosto %1) ei tueta.",
    'skeleton__upload_archive_file' => "Lataa arkistotiedosto",
    'skin_download__title' => 'Lataa ulkoasu',
    'skin_download_now__title' => 'Ulkoasun lataus käynnissä',
    'skin_download_now__text' => 'Ulkoasupaketin luonti on käynnissä.<br>Tämä saattaa kestää jonkin aikaa.<br>Kun valintaikkuna tulee näkyviin, voit jatkaa Pleskin käyttöä.',
    'skin_file__help_for_using_types' => "Käytä ulkoasuarkistoja seuraavissa muodoissa:",
    'skin_info__title' => 'Ulkoasun ominaisuudet',
    'skin_mng_err__rpm_not_skin' => 'Tämä RPM ei ole Pleskin ulkoasupaketti',
    'skin_mng_err__psa_install_noreloc' => 'rpm-pohjaisen ulkoasun asennus määritettyyn kohteeseen epäonnistui.',
    'skin_mng_err__already_exists' => 'Ulkoasun asennushakemisto on jo olemassa ja ulkoasupakkausta käytetään.',
    'skin_mng_err__rpm_upgrade_nonrpm' => 'Ladattu tiedosto ei ole kelvollinen RPM-ulkoasupaketti.',
    'skin_mng_err__rpm_upgrade_noskin' => 'Ladattu tiedosto ei ole kelvollinen ulkoasupaketti.',
    'skin_mng_err__rpm_upgrade_base' => "Ladattu tiedosto ei ole kelvollinen {$PROD_NAME} -ulkoasupaketti.",
    'skin_mng_err__rpm_upgrade_other' => 'Ulkoasua ei voitu asentaa: virheellinen ulkoasun muoto.',
    'skin_mng_err__no_a_skin' => "Ladattu tiedosto ei ole kelvollinen {$PROD_NAME} -ulkoasupaketti.",
    'skin_upload__title' => 'Lataa uusi ulkoasu',
    'skin_upload__already_exists' => "Ulkoasu '%1' on jo olemassa.",
    'skin_upload__unable_to_apply' => "Ladattu tiedosto ei sisällä Plesk -ulkoasua tai arkistomuotoa ei tueta.",
    'skin_upload__unable_to_rename__' => "Ulkoasua %2 - %1 ei voitu nimetä: %3.",
    'skin_upload__file_name' => 'Ulkoasupaketin tiedoston polku',
    'skins_list__title' => 'Ulkoasusäilö',
    'skins_remove__title' => 'Ulkoasun poisto',
    'skins_remove__select_skins_for_remove' => 'Valitse poistettavat ulkoasut',

    'spf__unable_update' => 'SPF-parametreja ei voida päivittää',
    'sshterm__title' => 'SSH-pääte',
    'sshterm__password_authentication_warning' => 'Huomautus: Salasanatodennus on poistettu käytöstä paikallisessa SSH-palvelinmäärityksessä. Jos et voi luoda yhteyttä SSH-päätteellä, pyydä järjestelmänvalvojaa asettamaan "PasswordAuthentication yes" tiedostossa /etc/ssh/sshd_config.',
    'sshterm__password_authentication_warning_admin' => 'Huomautus: Salasanatodennus on poistettu käytöstä paikallisessa SSH-palvelinmäärityksessä.  Jos et voi luoda yhteyttä SSH-päätteellä, aseta "PasswordAuthentication yes" tiedostossa /etc/ssh/sshd_config.',
    'statistics__active_domains' => "Aktiiviset toimialueet",
    'statistics__clients' => "Asiakkaat",
    'statistics__subdomains' => "Alitoimialueet",
    'statistics__cpu' => "Suoritin",
    'statistics__databases' => "Tietokannat",
    'statistics__db_users' => "Tietokannan käyttäjät",
    'statistics__dirs' => "Suojatut hakemistot",
    'statistics__dom_active' => "Akt.",
    'statistics__dom_passive' => "Passiivinen",
    'statistics__dom_problem' => "Ongelma",
    'statistics__domains' => "Toimialueet",
    'statistics__domains_with_host' => "Toimialueet, joissa on isännöinti",
    'statistics__doms' => "Toimialueet",
    'statistics__filesystem' => "Tiedostojärjestelmä",
    'statistics__general' => "Yleiset",
    'statistics__hdd_available' => "Käytettävissä",
    'statistics__hdd_capacity' => "Kapasiteetti",
    'statistics__hdd_total' => "Yhteensä",
    'statistics__hdd_usage' => "Kiintolevyn käyttö",
    'statistics__hdd_used' => "Käytetty",
    'statistics__ip' => "IP-osoite",
    'statistics__key_number' => "Avaimen numero",
    'statistics__l1' => "Viim. 1 minuutti",
    'statistics__l15' => "Viim. 15 minuuttia",
    'statistics__l5' => "Viim. 5 minuuttia",
    'statistics__la' => "Suoritinkäyttö",
    'statistics__mail_autoresponders' => "Automaattiset vastaukset",
    'statistics__mail_boxes' => "Postilaatikot",
    'statistics__mail_groups' => "Postitusryhmät",
    'statistics__mail_lists' => "Postituslistat",
    'statistics__mail_redirects' => "Sähköpostin välittäjät",
    'statistics__mem' => "Muistin käyttö",
    'statistics__mem_usage' => "Käyttö",
    'statistics__memory_available' => "Käytettävissä",
    'statistics__memory_buffer' => "Puskuri",
    'statistics__memory_cached' => "Välimuistissa",
    'statistics__memory_free' => "Vapaana",
    'statistics__memory_shared' => "Jaettu",
    'statistics__memory_total' => "Yhteensä",
    'statistics__memory_used' => "Käytetty",
    'statistics__os' => "OS",
    'statistics__problem_clients' => "Ongelma-asiakkaat",
    'statistics__problem_domains' => "Ongelmatoimialueet",
    'statistics__swap' => "Swap:n käyttö",
    'statistics__swap_free' => "Vapaana",
    'statistics__swap_total' => "Yhteensä",
    'statistics__swap_usage' => "Käyttö",
    'statistics__swap_used' => "Käytetty",
    'statistics__system_stat' => "Palvelimen tiedot",
    'statistics__unable_define_active_doms' => "Aktiivisten toimialueiden määrän selvittäminen ei onnistunut: %1",
    'statistics__unable_define_inactive_doms' => "Ei-aktiivisten toimialueiden määrän selvittäminen ei onnistunut: %1",
    'statistics__failed_define_swap_usage' => 'Swap-käytön määritys epäonnistui',
    'statistics__failed_define_load_averages' => 'Kuormituskeskiarvojen määritys epäonnistui',
    'statistics__up_time' => "Järjestelmän toiminta-aika:",
    'statistics__ver' => "Versio",
    'statistics__web_users' => "Internet-käyttäjät",
    'statistics__mem_win' => "Fyysisen muistin käyttö",
    'statistics__memory_total_win' => "Yhteensä",
    'statistics__memory_used_win' => "Käytetty",
    'statistics__memory_free_win' => "Käytettävissä",
    'statistics__swap_win' => "Näennäismuistin käyttö",
    'statistics__swap_total_win' => "Yhteensä",
    'statistics__swap_used_win' => "Käytetty",
    'statistics__swap_free_win' => "Käytettävissä",
    'status__domain_has_reasons_to_be_off' => "Toimialue on edelleen peruutettu seuraavasta syystä: %1",
    'subdomain__create__' => "Luo alitoimialue toimialueelle %1",
    'subdomain__edit__' => "Hallitse alitoimialuetta %1",
    'subdomain__invalid_name' => "Virheellinen alitoimialueen nimi: käytä vain aakkosnumeerisia merkkejä ja viivasymboleja.",
    'subdomain__incorrect_name' => "Virheellinen alitoimialueen nimi.",
    'subdomains__maillists_enabled_in_domain' => "Virheelliset alitoimialueen nimiluettelot.%1: tämä toimialueen nimi on jo postituslistojen käytössä toimialueessa %1.",
    'subdomains__dalias_exists' => 'Toimialueen alias, jolla on määritetty nimi, on jo olemassa.',
    'subdomains__name_exists' => "Samanniminen alitoimialue on jo olemassa.",
    'subdomains__regular_domain_exists' => "Samanniminen toimialue on jo olemassa.",
    'subdomains__domain_alias_exists' => 'Toimialueen alias, jolla on määritetty nimi, on jo olemassa.',
    'subdomains__remove_subdomains_on_domain' => "Seuraavat toimialueen %1 alitoimialueet poistetaan:",
    'subdomains__select_subdomains_for_remove' => "Valitse poistettavat alitoimialueet.",
    'subdomains__webmail_enabled_in_domain' => "Virheellinen alitoimialueen nimen verkkosähköposti.%1: tätä toimialueen nimeä käytetään jo verkkosähköpostin käyttämiseen toimialueella %1.",
    'subdomains__dns_record_already_exists' => 'Alitoimialuetta %1 ei voida luoda, koska olemassa on jo DNS-tietue isäntään %1.',
    'subdomains__www_prefix_in_domain' => "Virheellinen alitoimialueen nimi www.%1: toimialueessa %1 on jo WWW-etuliite.",
    'subdomains__user_type_quota_exceeds' => 'Käyttäjätiliä ei voida muuttaa, koska määritetty levytila ylitettäisiin muutoin.',
    'subdomains__creation_in_dns_slave' => "Plesk -nimipalvelin toimii tämän toimialueen toissijaisena (lisä-) nimipalvelimena. Jotta alitoimialueesi voidaan määrittää virheettömästi, ensisijaisen (pää-) palvelimen vyöhykkeen tiedostossa on oltava tietue %1.",
    'sys_user__attributes_not_changed' => "Seuraavia järjestelmäkäyttäjän määritteitä ei muutettu: %1",
    'sys_user__no_access_without_password' => "Et ole asettanut salasanaa. Järjestelmäkäyttäjä luodaan, mutta hän ei voi kirjautua järjestelmään ennen kuin hänelle on annettu salasana. Haluatko jatkaa?",
    'sys_user__no_hard_quota' => "ei tuettu",
    'sysuser__zero_quota_is_unlimited' => "0 rajoittamattomalle",
    'template__num_excl_ips' => "Kohdista varatut IP-osoitteet asiakkaalle",
    'template__sel_sh_ips' => "Valitut jaetut IP-osoitteet",
    'template__av_sh_ips' => "Käytettävissä olevat jaetut IP-osoitteet",
    'template__up_to_excl_ip' => "Enintään %1 IP-osoitetta",
    'templates__all_clients' => "kaikki asiakkaat",
    'templates__cl_domain_templates' => "Mallit kohteelle %1",
    'templates__cl_templates' => "Asiakasmallit",
    'time__invalid_ip' => "Virheellinen IP-osoite tai toimialueen nimi.",
    '__please_select_country' => 'Valitse maa',
    'time__unable_set_time' => "Järjestelmän kellonaikaa ei voi määrittää: %1",
    'time__sinchronization_setup_error' => 'Ajan synkronointia ei voida määrittää: timemng epäonnistui: %1',
    'time__sinchronization_disable_error' => 'Ajan synkronointia ei voi poistaa käytöstä: timemng epäonnistui: %1',
    'tmpl__create' => "Luo malli",
    'tmpl__edit__' => 'Malli %1',
    'tmpl__logrotation_warn' => "Tämän mallin avulla luotu toimialueen lokikierto suoritetaan vain, jos luot lopuksi fyysisen isännöintitilin.",
    'tmpl__name' => "Mallin nimi",
    'tmpl__dom_exist' => "Samanniminen toimialueen malli on jo olemassa järjestelmänvalvojan tai asiakkaan mallisarjassa.",
    'tmpl__name_invalid' => "Mallin nimi on virheellinen tai tyhjä.",
    'tmpl__use_next_ip_addr' => "Seuraavaa vapaata IP-osoittetta käytetään",
    'tmpl_name_already_exists' => "Malli, jonka nimi on '%1', on jo olemassa.",
    'traffic__no_periods_found' => "Verkon tai liikenteen tilastotietoja ei voida näyttää. Tämä toiminto on käytettävissä vasta seuraavan tilastolaskennan jälkeen.",

    'vh_based__no_free_ip_for_vh' => "IP-pohjaista virtuaalista isännöintiä varten ei ole saatavilla vapaita IP-osoitteita. Lisää IP-osoite.",

    'wu__at_domains_text' => "Salli webuser@%1 -käyttömuoto",
    'wu__unable_create' => "Internet-käyttäjän luominen ei onnistu: %1",
    'wu_edit__disk_quota' => "Levykiintiö",
    'wu_edit__invalid_pass' => "Salasana ei kelpaa.",
    'wu_edit__invalid_quota' => "Määritetty levytilakiintiön arvo on virheellinen. Anna positiivinen kokonaisluku.",
    'wu_edit__invalid_quota_value' => "Määritetty levytilan kiintiö on tällä hetkellä käytettyä tilaa pienempi (%1Mt). Jotkin toiminnot eivät välttämättä ole käytettävissä. Haluatko varmasti jatkaa?",
    'wu_edit__not_create_pass' => "Tämä toiminto ei luo salasanaa uudelle Internet-käyttäjälle.\nKäyttäjä ei voi kirjautua sisään ilman salasanaa.",
    'wu_edit__unable_update' => "Internet-käyttäjän ominaisuutta ei voi päivittää: %1",

    'bt_webdirs' => 'Näennäiskansiot',

    'dns__tabs_general' => 'Alueen asetukset',
    'dns__tabs_zone_settings' => 'SOA-tietueet',
    'soa__seconds' => 'sekuntia',
    'soa__minutes' => 'minuuttia',
    'soa__hours' => 'tuntia',
    'soa__days' => 'päivää',

    'DomainSubdirectory' => 'Kohteen alihakemisto',

    'filemanager__select_codepage' => 'Valitse koodisivu:',

    'bt_server_app_add' => 'Lisää palvelinsovellus',
    'packages_list' => 'Palvelinsovellukset',

    'bt_packages_management' => 'Pakettien hallinta',
    'pb__packages_management' => 'Sovelluksen hallinta',
    'bt_package_new' => 'Lisää sovellus',
    '__packages' => 'Palvelinsovellukset',

    'dom_ctrl__mysql_dbase_space' => 'MySQL -tietokantojen kokonaiskiintiö',
    'dom_ctrl__mssql_dbase_space' => 'MS SQL -tietokantojen kokonaiskiintiö',

    'check_permissions__domains_selection' => 'Seuraavien toimialueiden tiedostojen ja kansion käyttöoikeudet tarkistetaan',

    'dns_add__enter_ixfr_path' => 'Syötä IXFR-polku',

    'cmd_dns__txt_dns_record_already_exist' => 'SPF TXT-tietue on jo olemassa. SPF-tietueita voi olla vain yksi. Voit lisätä tietueen poistamalla olemassa olevan sitä ennen.',

    'component_name__network' => 'Verkkokäyttö',
    'component_name__sitebuilder' => 'Presence Builder',

    'bt_skin_set' => 'Aseta ulkoasu',
    'bt_set_skin' => 'Aseta ulkoasu',
    'firewall__rule_already_exists' => 'Sääntö "%1" on jo olemassa',
    'firewall__rule_readonly' => 'Sääntö "%1" on lukutilassa',
    'pb__firewall' => 'Palomuuri',

    '__webstat_smarterstats' => 'SmarterStats',

    'error_doc__erorr_invalid_file_location' => 'Tiedoston sijainti on virheellinen.',

    'error_doc__erorr_invalid_url_location' =>  'Väärä URL-muoto. Syötä absoluuttinen URL näennäisisännän (sivusto) mukaan.',

    'mn_list__tab_title_antivirus' => 'virustentorjuntaohjelma',

    'bt_antivirus' => 'Virustentorjunta',
    'antivirus__antivirus' => 'Virustentorjunta',
    'antivirus__antivirus_direction_off' => 'Sammutettu',
    'antivirus__antivirus_direction_any' => 'Saapuva ja lähtevä posti',
    'antivirus__antivirus_direction_from' => 'Vain lähtevä posti',
    'antivirus__antivirus_direction_to' => 'Vain saapuva posti',
    'antivirus__unable_to_update_settings' => 'Virustentorjunta-asetuksia ei voi muuttaa: %1',




    '__normal' => 'Vakio',
    '__low' => 'Pieni',
    '__high' => 'Suuri',

    'mail__antivirus' => "Sisäinen postipalvelimen virustentorjunta",
    'mail__use_internal_antivirus' => 'Käytä sisäistä virustentorjuntaohjelmaa',

    'sa__tabs_blacklist' => 'Musta lista',

    '__mysql_databases' => 'MySQL-tietokannat',

    'check_permissions__read_only' => 'Vain tarkistustila',
    'check_permissions__notification_email' => 'Lähetä ilmoitus sähköpostitse',

    'cl_perm__mysql_dbase_space' => 'MySQL -tietokantojen kokonaiskiintiö',
    'cl_perm__mssql_dbase_space' => 'MS SQL -tietokantojen kokonaiskiintiö',
    'cl_perm__max_mssql_db' => 'Microsoft SQL -palvelintietokantojen maksimimäärä',
    'cl_perm__total_mboxes_quota' => 'Postilaatikoiden kokonaiskiintiö',

    'check_permissions_warning' => 'Tämä toimenpide voi kestää kauan, ole kärsivällinen ja vältä peruuttamasta sivun latausta.',

    'i_i_cl_on' => 'Asiakastili on aktiivinen.',
    'i_i_cl_off_by_admin' => 'Järjestelmänvalvoja on peruuttanut asiakastilin.',

    'check_permissions__email_is_invalid' => 'Annettu sähköpostiosoite on virheellinen.',

    'sa_exists_tn' => 'Verkko on jo luettelossa.',

    'webdir__select_vdirs_to_remove' => 'Valitse poistettavat hakemistot',
    'webdir__select_mime_types_to_remove' => 'Valitse poistettavat MIME-tyypit',

    'defaultcomponents__not_activated' => 'Ei aktivoitu',

    'bt_traffic_at_domains' => 'Liikenne',

    '__awstats_perl_warning' => 'Ilman asennettua Perlia AWStats ei salli käyttäjien tarkistaa aikaisempien vuosien tilastotietoja.',

    'class_client__mysql_dbase_space' => 'Arvo ylittää asiakkaan rajan',
    'class_client__mssql_dbase_space' => 'Arvo ylittää asiakkaan rajan',
    'class_client__max_mssql_db' => 'Arvo ylittää asiakkaan rajan',

    'dns__remove_transfer_restrictions_list_items' => 'Seuraavat verkot poistetaan käyttöoikeusluettelosta:',

    'bt_up' => "Ylös",
    'bt_down' => "Alas",
    'virtualdir__type_default_doc_name_to_add' => 'Syötä tiedoston nimi sen lisäämiseksi luetteloon',
    'virtualdir__select_default_doc_to_remove' => 'Valitse tästä luettelosta poistettavat tiedostot',

    'bt_install_selected' => 'Asenna valitut käyttöoikeusavaimet', // SELECTED


    'dom_pref__the_domain_resolves_to_another_ip_address' => 'Toimialue selvittää toisen IP-osoitteen (%1). Korjaa DNS-asetukset.',

    'mn_edit__mailbox_enable_if_mailgroup_enabled' => 'Tällä hetkellä käytössä oleva sähköpostipalvelin ei tue postilaatikon ja postiryhmän samanaikaista käyttöönottoa. Ota postilaatikko käyttöön painamalla OK poistamalla postitusryhmät käytöstä. Valitse Peruuta, kun haluat, että tiedot säilyvät entisellään.',

    'mn_edit__mailgroup_enable_if_mailbox_enabled' => 'Tällä hetkellä käytössä oleva sähköpostipalvelin ei tue postilaatikon ja postiryhmän samanaikaista käyttöönottoa. Ota postitusryhmät käyttöön painamalla OK poistamalla postilaatikon käytöstä. Valitse Peruuta, kun haluat, että tiedot säilyvät entisellään.',

    'mysql_dbase_space_limit' => 'MySQL-tietokannan tilarajoitus',
    'mysql_dbase_usage' => 'MySQL-tietokannan tilan käyttö',
    'mssql_dbase_space_limit' => 'Microsoft SQL Server -tietokannan levytilarajoitus',
    'mssql_dbase_usage' => 'Microsoft SQL Server -tietokannan levytilan käyttö',

    '__statistics' => "tilastot", //indirect

    'dns__soa_minimum_value_is_big' => 'Minimaalisen TTL-arvon asettaminen yli 3 tuntiin voi asettaa toimialueesi pois käytöstä joidenkin toimialueen järjestelmänvalvojien kohdalla. Kyseisen arvon asettaminen on suositeltavaa ainoastaan silloin, kun toimialueen nimien rekisteröijä edellyttää sitä.',

    'virusfilter__interface_not_available' => 'Virussuodattimia ei ole saatavilla.',
    'virusfilter__none_virus_filter' => 'Ei ole',
    'virusfilter__mailname_status_text' => 'Virustentorjunta (%1)',
    'virusfilter__status_none' => 'sammutettu',
    'virusfilter__status_any' => 'saapuva ja lähtevä posti',
    'virusfilter__status_outgoing' => 'vain lähtevä posti',
    'virusfilter__status_incoming' => 'vain saapuva posti',

    'visibility__adminonly' => 'Vain järjestelmänvalvoja',
    'visibility__button_sets' => 'Ohjausobjektit',
    'visibility__control' => 'Mukauta tätä ohjausobjektia napsauttamalla.',
    'visibility__customization_footnote' => 'Lopeta näytön mukautus valitsemalla OK.',
    'visibility__default' => 'Oletus',
    'visibility__export_note' => "Tekemiäsi mukautusasetuksia viedään. Liittymän komentosarja ladataan nyt tietokoneeseesi. Voit käyttää kyseisiä asetuksia toiseen Plesk -palvelimeen kirjoittamalla olemassa olevien liittymän hallinta-asetuksien yli, lataa ja suorita komentosarja.\n\nJos olet tehnyt muutoksia tässä näytössä etkä ole vielä napsauttanut OK, viedyt tiedot eivät sisällä viimeisimpiä muutoksiasi.",
    'visibility__hide' => 'Piilota',
    'visibility__reset_all' => 'Palauta kaikki oletukseksi',
    'visibility__reset_screen' => 'Palauta tämän näytön alkuperäinen asettelu',
    'visibility__root_override_parse_error' => 'Tiedoston %1 rivillä %2 on syntaksivirhe.',
    'visibility__screen_title' => 'Liittymän hallinta',
    'visibility__set_billing_enabled' => 'Katkaise yhteys Customer and Business Manageriin',
    'visibility__set_cert_puchasing' => 'Piilota varmenteen oston painikkeet',
    'visibility__set_domain_registration' => 'Piilota toimialueen rekisteröinnin painikkeet',
    'visibility__set_extras' => 'Piilota lisäpalveluiden painikkeet',
    'visibility__set_mail_bounce' => 'Piilota hylkäysviestiohjausobjektit sähköpostiosoitteille, joita ei ole olemassa',
    'visibility__show' => 'Näytä',
    'visibility__show_toolbar' => 'Näytä liittymän hallinnan työkalurivi',
    'visibility__standby_footnote' => 'Mukauta tämän näytön ohjausobjekteja napsauttamalla.',
    'visibility__standby_footnote_nocontrols' => 'Tässä näytössä ei ole mukautettavia ohjausobjekteja.',

    'bt_mpc' => "MyPlesk.com",
    'sb__not_support_publishing_api' => "Komponentti ei tue julkaisun automaatiota",

    'component_name__cphosting' => "Plesk-isännöinti",

    'dom_pref__unable_set_up_total_mboxes_quota' => 'Nykyinen postipalvelin ei tue postilaatikon kiintiön määritystä.',
    '__unable_get_total_mboxes_quota' => 'Nykyinen postipalvelin ei tue postilaatikon kiintiön määritystä.',

    'install_prefix__parent_not_exists' => "Yläkansiota ei ole olemassa.",

    'bt_change_version' => 'Muuta versiota',
    'aspdotnet__changeversion_title' => 'Valitaan ASP.NET-versio',
    'pb__aspdotnet' => 'ASP.NET',

    '__check_all' => "Valitse kaikki",
    '__uncheck_all' => "Tyhjennä kaikki",

    'dns__editing_domain_controller_zone' => "Toimialueen ohjauskoneen DNS-vyöhyketietueet voivat aiheuttaa ongelmia toimialueen toiminnassa",

    'pb__interface_management' => "Liittymän hallinta",
    'interface_management__tabs_skins' => "Ulkoasut",
    'interface_management__tabs_interface_templates' => "Liittymän mallit",
    'interface_management__tabs_locales' => "Aluekohtaiset asetukset",
    'locales_list__title' => "Kielipakettien säilö",
    'locales_list__legend' => "Käytettävissä olevat kielet",
    'locales_list__active_title' => "S",
    'locales_list__locale_title' => "Kielipaketti",
    'locales_list__lang_title' => "Kieli",
    'locales_list__country_title' => "Maa",
    'locales_list__used_title' => "Käytetty",

    'backup__suspend_warning_during_backup' => "Toimialue ei ole käytettävissä varmuuskopiointiprosessin aikana",
    'backup__suspend_warning_during_restore' => "Toimialue ei ole käytettävissä palautusprosessin aikana",
    'backup__suspend_domain' => "Peruuta toimialue",

    'locales_list__mls_limit' => "Nykyinen Pleskin käyttöoikeus sallii %2 kielen käytön. Tällä hetkellä käyttäjille on määritetty %1 kieltä, mikä ylittää käyttöoikeuden salliman määrän. Valitse %2 kieltä, joita haluat käyttää, ja poista loput kielet käyttäjien käytöstä napsauttamalla vastaavia kuvakkeita 'S'-sarakkeessa.",

    'bt_change_owner' => 'Määritä uusi omistaja',
    'chown__new_owner' => 'Uusi omistaja',
    'chown__selected_domains' => 'Valitut tilaukset',
    'chown__limits_legend' => 'Resurssit',
    'chown__limit_name' => 'Resurssin nimi',
    'chown__limit_value' => 'Varatut resurssit',
    'chown__limit_assigned_before' => 'Ennen siirtoa',
    'chown__limit_assigned_after' => 'Siirron jälkeen',
    'chown__error_limits' => "Tilauksen siirtoa ei voi jatkaa: tämä tilaus tarvitsee enemmän resursseja kuin uuden omistajan palveluntarjoaja voi tarjota.",
    'chown__error_no_domains' => 'Tilauksen siirron jatkaminen ei ole mahdollista: tilauksia ei ole joko valittu tai valitut tilaukset kuuluvat jo kohdekäyttäjälle.',
    'chown__error_empty_ip_pool' => "Tilauksen siirtoa ei voi jatkaa: uuden omistajan palveluntarjoajan IP-ryhmä on tyhjä. Varmista, että palveluntarjoajalla on ryhmässä vähintään yksi IP-osoite.",
    'chown__please_select_new_domain_owner' => 'Valitse tämän tilauksen uusi omistaja',
    'chown__old_ip_address' => 'Nykyinen IP-osoite',
    'chown__new_ip_address' => 'Uusi IP-osoite',

    'chown__error_ssl_already_used' => "SSL/TLS-tukea on jo käytetty seuraavissa kohteiden IP-osoitteissa: %1 Siitä syystä seuraavia toimialueita SSL-tuella ei voitu siirtää: %2. Ratkaise ongelma ja yritä uudelleen",
    'chown__sitebuilder_not_installed' => 'Presence Builderia ei ole asennettu',
    'chown__domain_exclude_sitebuilder_not_installed' => 'Toimialuetta %1 ei voida siirtää toiselle omistajalle, koska Presence Builder -järjestelmää ei ole asennettu.',

    'backup__backup_time' => 'Varmuuskopiointiaika',
    'backup__backup_time_hour' => 'tuntia',
    'backup__backup_time_minute' => 'minuuttia',
    'backup__every' => 'joka',
    'backup__day_of_month' => 'Kuukauden päivä',

    'subdomain__select_hst_type' => 'Valitse isännöintityyppi alitoimialuetta varten',
    'hst_sel__subdom_subfolder_hst' => 'Alitoimialue alikansiossa',
    'subdomain__www_root_folder_not_exists' => 'Verkkosivuston kotihakemistoa %1 ei ole olemassa',
    '__site_home_dir' => 'Sivuston kotihakemisto',
    'subdomain__aspnet_disabled_domain' => 'poistettu käytöstä toimialueen mukaan',

    'domains__remove_description' => 'Kaikki toimialueen tiedot, mukaan lukien toimialueen ja vastaavien alitoimialueiden sisällöt ja asetukset, verkkosovellusten tiedot, postilaatikon sisällöt, posti, virustentorjunnan ja roskapostisuodatuksen asetukset, lokitiedostot, toimialueen varmuuskopiointisäilön tiedot sekä SSL/TLS-varmenteet poistetaan. Jos paikallisessa tietokoneessasi ei ole varmuuskopiota, kaikki tiedot menetetään pysyvästi.',
    'subdomains__remove_description' => 'Kaikki alitoimialueen tiedot, alitoimialueen sisältö ja asetukset, verkkosovelluksien tiedot sekä lokitiedostot poistetaan. Jos paikallisessa tietokoneessasi ei ole varmuuskopiota, kaikki tiedot menetetään pysyvästi.',

    'mail__tabs_spam_filtering' => 'Roskapostisuodatus',
    'mail__tabs_antivirus' => 'Virustentorjunta',
    'antivirus__use_server_settings_scan' => 'Käytä palvelimen laajuisia oletusasetuksia (skannaa)',
    'antivirus__use_server_settings_no_scan' => 'Käytä palvelimen laajuisia oletusasetuksia (älä skannaa)',
    'antivirus__check_for_viruses' => 'Skannaa viruksia',
    'antivirus__dont_check_for_viruses' => 'Älä skannaa viruksia',
    'antivirus__incoming_mail' => 'Saapuva posti',
    'antivirus__outgoing_mail' => 'Lähtevä posti',

    'domain_alias__CNAME_dns_record_exists' => 'Samanniminen DNS CNAME -tietue on jo olemassa',
    'domain_alias__A_dns_record_exists' => 'Samanniminen DNS A -tietue on jo olemassa',
    'domain_alias__bad_prefix' => 'Virheellinen toimialueen aliaksen etuliite',
    'domain_alias__domain_doesnt_exist' => "Toimialuetta ei ole",

    'dns__zone_ttl_message_info' => 'Jos TTL:n arvoa ei ole määritelty, TTL:n arvoa SOA-tietuemallissa (%1) käytetään tässä DNS-tietueessa.',

    '__webalizer_support' => 'Webalizer',
    '__awstats_support' => 'AWStats',
    '__smarterstats_support' => 'SmarterStats',

    'site_apps__make_default_warning_message' => "Tiedosto index.html luodaan uudelleenohjaamiseksi valittuun verkkosovellukseen. Jos tiedosto index.html on jo olemassa, se varmuuskopioidaan nimellä index.html.old ja korvataan uudella. Vahvista painamalla OK",

    'bt_ftp_ctrl' => "FTP-lisätilit",
    'ftp_users_no_permission' => "Sinulla ei ole oikeutta hallita tämän toimialueen FTP-tilejä",
    'ftp_users_limit_reached' => "FTP-tilien maksimiarvo on saavutettu tämän toimialueen kohdalla",
    'pb__ftp_ctrl' => "FTP-hallinta",
    'class_client__max_subftp_users' => "FTP-lisätilit",

    '__client_form_settings' => "Asiakkaan asetukset",
    '__sbnet_client_keep_sbnet' => "Säilytä vastaava käyttäjätili Presence Builderissa",
    '__sbnet_cant_add_more_sites' => "Presence Builder -järjestelmää käyttävien verkkosivustojen maksimimäärä on saavutettu tämän asiakkaan kohdalla",
    '__sbnet_legend_text' => "Presence Builder -järjestelmän integrointi",
    '__sbnet_synchronize_user_with_sbnet' => "Luo vastaava käyttäjätili Presence Builderissa",
    '__sbnet_client_warning_delete_sb_user' => "Yrität poistaa tähän asiakkaaseen liittyvää Presence Builder -käyttäjätiliä. Tämä poistaa kaikki käyttäjän verkkosivustot ja muut niihin liittyvät asetukset Presence Builder -järjestelmästä. Samalla poistuu olemassa olevien verkkosivustojen muokkausmahdollisuus Presence Builderin avulla, vaikka tämä toiminto otettaisiinkin myöhemmin käyttöön. Jos luot Presence Builder -käyttäjätilin uudelleen myöhemmin, sinun täytyy luoda ja julkaista kaikki verkkosivustot uudelleen alusta asti. Haluatko poistaa käytöstä verkkosivuston luonnin ja julkaisun Presence Builderin avulla?",
    'sb__build_site_with_subdomains' => "Luo blogi ja kuvagallerian alitoimialueet",
    '__sbnet_client_dont_have_sbuser' => "Verkkosivustoa ei voida luoda ja julkaista Presence Builder -järjestelmällä: Presence Builder -käyttäjää ei ole olemassa",

    '__component_disabled' => "Komponentti pois käytöstä",

    'subdomains__physical_path_not_exist' => "Alitoimialueita on yhdistetty olemassa olemattomiin fyysisiin kansioihin",

    'dnsserver_bind_to_msdns_switching_warning' => "Varoitus: vain aliverkon 254 ensimmäistä IP-osoitetta, joissa on käyttöoikeusluettelon peitteet /8 ja /16,  siirretään. Ne siirretään erillisinä IP-osoitteina. Haluatko jatkaa?",

    '__sbnet_net_framework_required_for_site' => "Presence Builder -verkkosivustot voivat vaatia ASP.NET 2.0 -tuen toimialueella. Suosittelemme ottamaan käyttöön ASP.NET 2.0 -tuen, jos käytössä on Presence Builder.",

    'subdomain_auto_create_dir' => "Luo fyysinen hakemisto alitoiminimeen",

    'sa_trainer__unable_to_get_messages_list' => "Viestiluetteloa ei voida saada postilaatikkoon: %1",
    'sa_trainer__pass_doesnt_exist' => "Tämän sähköpostitilin salasana puuttuu",

    '__sitebuilder_error' => "Virhe yritettäessä muodostaa yhteys Presence Builderiin. Kysy ohjeita palveluntarjoajalta.",
    'wsb_error_user_not_exist' => "Tätä Presence Builder -käyttäjätiliä ei ole olemassa.",
    'wsb_error_site_already_exist' => "Tämä sivusto on jo olemassa Presence Builder -järjestelmässä.",
    'wsb_error_site_limit_reached' => "Presence Builder -sivustojen enimmäismäärä on saavutettu.",
    'wsb_error_internal_error' => "Internal Presence Builder -virhe tapahtui. Kysy ohjeita palveluntarjoajalta.",
    'wsb_error_user_already_exist' => "Samanniminen Presence Builder -käyttäjä on jo olemassa Presence Builder -järjestelmässä.",
    'sb_error_user_not_exist' => "Presence Builder -käyttäjää ei ole.",
    'wsb_error_object_not_found' => "Presence Builder ei löytänyt oikeaa isäntäkohdetta.",

    'mg_no_mail_groups' => "Ei postitusryhmiä",

    'drweb__drweb_incoming' => 'Saapuvan postin virustentorjunta',
    'drweb__drweb_outgoing' => 'Lähtevän postin virustentorjunta',
    'drweb__disable_reason_serv' => 'Sähköpostipalvelin ei tue virustentorjuntasuodattimen asetuksia postilaatikon tasolla',

    'vz_sitebuilder3_client_cant_be_created' => "Asiakastilin luominen ei onnistu: SiteBuilder-versiota 3.1 tai sitä uudempaa ei ole asennettu",

    'chown__client_without_sitebuilder_support' => "Tilauksen siirtoa ei voida jatkaa: Presence Builder -palvelu ei sisälly uuden omistajan tai sen tarjoajan palvelusuunnitelmaan.",

    // new limits

    'class_client__max_odbc' => "ODBC-yhteydet",
    'cl_perm__max_odbc' => "ODBC-yhteyksien enimmäismäärä",

    // domain aliases DNS
    'domain_alias__list_status' => 'S',
    'domain_alias__list_name' => 'Toimialueen aliasnimi',
    'domain_alias__list_ascii_name' => 'ASCII-muodossa',


    // Interface Customization Templates
    'interface_preferences' => 'Liittymän hallinta',
    'pb__interface_templates' => 'Liittymän hallinta',
    'pb__interface_clients' => 'Asiakkaat käyttävät kohdetta %1',

    // service management
    'bt_service_showall' => "Näytä kaikki",
    'bt_service_hideall' => "Piilota kaikki",
    'bt_service_start' => "Käynnistä",
    'bt_service_stop' => "Pysäytä",
    'bt_service_restart' => "Käynnistä uudelleen",
    'bt_service_disable' => "Sammuta",
    'bt_service_manual' => "Manuaalinen",
    'bt_service_auto' => "Autot",
    'comp_info__statup_type' => 'Käynnistystapa',
    'service_startup_auto' => 'Automaatinen',
    'service_startup_manual' => 'Manuaalinen',
    'service_startup_disabled' => 'Sammutettu',
    'service_action_ok' => "Toiminto %1 palvelulla suoritettiin loppuun",
    'service_action_failed_disabled_service' => "Toimintoa ei voitu suorittaa %1 palvelulla, koska se on pois käytöstä",
    'service_action_failed_error' => "Toimen suorittaminen loppuun epäonnistui: %1",
    'service_group_action_ok' => "Seuraavien palvelujen toiminto suoritettiin onnistuneesti: \n %1",
    'service_group_action_disabled' => "Toimintoa ei voitu suorittaa seuraavilla palveluilla, koska ne ovat pois käytöstä: \n %1",
    'service_group_action_failed' => "Toimintoa ei voida suorittaa seuraavilla palveluilla: \n %1. \n Voit saada tarkat virhetiedot suorittamalla toiminnon erikseen kunkin palvelun kohdalla",

    // php 4vs5
    'bt_php' => "PHP-asetukset",

    // Mass mail

    'massmail__resellers_list_available_for_select' => 'Saatavilla olevat jälleenmyyjät',
    'massmail__resellers_list_selected' => 'Valitut jälleenmyyjät',
    'massmail__clients_list_available_for_select' => 'Saatavilla olevat asiakkaat',
    'massmail__clients_list_selected' => 'Valitut asiakkaat',
    'massmail__advanced' => 'Lisäasetukset',
    'bt_massmail_send' => 'Lähetä',
    'massmail__save_template_name' => 'Tallenna teksti uuteen malliin, jonka nimi on',
    'massmail__template' => 'Malli',
    'massmail__compose_mail' => 'Viesti',
    'massmail__from' => 'Lähettäjä',
    'massmail__to' => 'Vast.ott.',
    'massmail__subject' => 'Aihe',
    'massmail__body' => 'Viestin teksti',
    'massmail__body_hint' => 'Syötä käyttäjän nimi viestiin käyttämällä muuttujaa <name>.',
    'massmail__send_to_clients' => "Asiakkaat",
    'massmail__send_to_domainusers' => "Toimialueen järjestelmänvalvojat",
    'massmail__send_to_admins' => "Pleskin järjestelmänvalvojat",
    'massmail_select' => 'Valitse osoitteet',
    'massmail_showhide_selected' => "Näytä/piilota valitut",
    'massmail_send_all' => "Kaikki",
    'massmail_send_selected' => "Vain valitut",
    'massmail_send_except' => "Kaikki paitsi valitut",
    'bt_new_mass_mail_template' => "Lisää massasähköpostin malli",
    '__mass_mail_templates_list' => "Massasähköpostiviestin malliluettelo",
    'massmail__template_name' => 'Mallin nimi',
    'massmail__receivers' => 'Vastaanottajat',
    'massmail__created' => 'Lähettäjä',
    'massmail__date_created' => 'Luontipäivä',
    'massmail__compose' => 'Lähetä',
    'mass_mail__resellers_all' => 'Kaikki jälleenmyyjät',
    'mass_mail__clients_all' => 'Kaikki asiakkaat',
    'mass_mail__domainusers_all' => 'Kaikki toimialueen järjestelmänvalvojat',
    'mass_mail__resellers_selected' => 'Valitut jälleenmyyjät',
    'mass_mail__clients_selected' => 'Valitut asiakkaat',
    'mass_mail__domainusers_selected' => 'Valitut toimialueen järjestelmänvalvojat',
    'mass_mail__resellers_except' => 'Kaikki paitsi valitut jälleenmyyjät',
    'mass_mail__clients_except' => 'Kaikki paitsi valitut asiakkaat',
    'mass_mail__domainusers_except' => 'Kaikki paitsi valitut toimialueen järjestelmänvalvojat',
    'mass_mail__admins_all' => 'Kaikki järjestelmänvalvojat',
    'massmailtemplateslist__title' => 'Massasähköpostin mallit',
    'massmail__insert_from_template' => "Syötä tietoa mallista",
    'massmail__select_template' => "Valitse malli",
    'massmail__body_short_hint' => "(vain pelkkä teksti)",
    'massmail__from_short_hint' => "(sähköposti tai nimi)",
    'bt_insert' => "Lisää",
    'massmail__mail_send_successfully' => "Viesti on lähetetty",
    'massmail__mail_send_successfully_with_some_errors' => "Viesti lähetettiin, mutta useita virheitä havaittiin. Osa vastaanottajista ei välttämättä saa viestiä. Katso lisätietoa seuraavasta lokitiedostosta: %plesk_dir%\\admin\\logs\\send_mass_mail.log",
    'massmail__mail_send_failed' => "Viestiä ei lähetetty. Varmista, että vähintään yksi vastaanottaja on valittu ja Plesk -sähköpostipalvelin toimii virheettömästi. Katso lisätietoa seuraavasta lokitiedostosta: %plesk_dir%\\admin\\logs\\send_mass_mail.log",
    'massmail__template_data_inserted' => "Mallin %1 tiedot lisättiin onnistuneesti.",
    'massmail__template_added_successfully' => "Viestimalli tallennettiin nimellä %1.",

    // wsb integration
    'wsb_error_sitebuilder_database_error' => "Presence Builder -tietokannassa tapahtui virhe. Kysy ohjeita palveluntarjoajalta.",
    'wsb_error_sitebuilder_access_denied_error' => "Tiedostoon ei päästä: Presence Builder -järjestelmällä ei ole vaaditun tiedoston tai kansion käyttöoikeuksia. Kysy ohjeita palveluntarjoajalta.",
    'wsb_error_sitebuilder_connection_failed' => "Yhteyttä ei voida luoda Presence Builder -järjestelmään, koska yhteys menetettiin. Kysy ohjeita palveluntarjoajalta.",
    'wsb_error_critical_during_operation' => "Critical Presence Builder -virhe tapahtui:\n%1",
    'wsb_error_license_during_operation' => "Presence Builder -käyttöoikeusvirhe tapahtui:\n%1",
    'wsb_error_during_operation' => "Presence Builder -virhe tapahtui:\n%1",
    'wsb_error_license_error' => "Presence Builder -käyttöoikeuden rajoitus havaittiin.",

    // Other
    '__confrim_service_stop' => "Varoitus! Jos lopetat palvelun %1, Plesk voi lakata toimimasta. Haluatko varmasti lopettaa palvelun %1?",
    'virtualdir__name_is_reserved' => "Tämä nimi on varattu",
    'index_redirect_help_text' => 'Sinut ohjataan nyt automaattisesti vaaditulle verkkosivustolle. Jos selaimesi ei tue uudelleenohjausta, napsauta %1 tässä %2',
    'bt_default_settings' => "Palauta oletukset",
    'logfiles__remove_failed' => "Tiedostoa %1 ei voida poistaa: toinen sovellus on lukinnut tiedoston. Yritä myöhemmin uudelleen",
    'subdomain__invalid_homedirectory' => "Määritetyn alitoimialueen kotihakemisto on virheellinen",
    'scheduler_item__empty_filename' => "Määritä suoritettava tiedosto, jota on käytettävä",
    'subdomains__overlapped_domain_exists' => 'Toimialueen %1 DNS-vyöhyke on limittäin alitoimialueeseen',
    'subdomains__overlapped_domain_alias_exists' => 'Toimialueen aliaksen %1 DNS-vyöhyke on limittäin alitoimialueeseen',
    'services_action_none_selected' => 'Toimintoa ei voitu suorittaa: valitse vaaditut palvelut',
    'cl_perm__max_subftp_users' => "FTP-lisätilien maksimimäärä",
    'login_up__access_denied_no_cp_access' => 'Käyttö estetty. Sinulla ei ole Pleskin käyttöoikeutta.',
    'drweb__disable_reason_admin' => "Palvelimen käytäntö ei salli virustentorjuntasuodattimen asetuksia postilaatikon tasolla.",

    'webdirs__name_is_invalid' => 'Käytä ainoastaan aakkosnumeerisia, alaviivaa ja viivaa hakemiston nimessä.',
    'webdirs__physical_path_is_invalid' => 'Fyysinen polku on virheellinen tai sitä ei ole',
    '__use_default' => 'Käytä oletusarvoa',
    'odbc__dsn_list_legend' => 'ODBC DSN -yhteydet',

    'webalizer_preferences__title' => 'Verkkosivuston tilastojen asetukset',
    'webalizer_preferences__tab_hidden_referrers' => 'Piilotetut viittaajat',
    'webalizer_preferences__tab_group_referrers' => 'Ryhmitetyt viittaajat',

    'webalizer_hidden_referrer__edit_title' => 'Piilotettujen tietojen ominaisuudet',
    'webalizer_hidden_referrer__edit_legend' => 'Piilotetut tiedot',
    'webalizer_hidden_referrer__referrer_type' => 'Merkinnän tyyppi',
    'webalizer_hidden_referrer__referrer' => 'Viittaaja',
    'webalizer_hidden_referrer__list_header' => 'Piilotetut viittaajat',
    'webalizer_hidden_referrer__list_legend' => 'Piilotetut viittaajat',
    'webalizer_hidden_referrer__referrer_direct_request' => 'Suora pyyntö',
    'webalizer_hidden_referrer__referrer_custom_referrer' => 'Viittaaja',
    'webalizer_hidden_referrer__remove_empty_selection' => 'Tietoja ei valittu',
    'webalizer_hidden_referrer__remove_title' => 'Seuraavia viittaajia ei ole enää piilotettu:',
    'webalizer_hidden_referrer__already_exist' => 'Tämä merkintä on jo olemassa.',

    'webalizer_group_referrer__list_header' => 'Viittaajaryhmä',
    'webalizer_group_referrer__list_legend' => 'Viittaajaryhmä',
    'webalizer_group_referrer__edit_title' => 'Viittaajaryhmän ominaisuudet',
    'webalizer_group_referrer__edit_legend' => 'Viittaajaryhmän ominaisuudet',
    'webalizer_group_referrer__group' => 'Ryhmä',
    'webalizer_group_referrer__referrer' => 'Viittaaja',
    'webalizer_group_referrer__already_exist' => 'Samanniminen viittaajaryhmä on jo olemassa.',
    'webalizer_group_referrer__remove_empty_selection' => 'Viittaajia ei ole valittu',
    'webalizer_group_referrer__remove_title' => 'Seuraavat viittaajien sivustot poistetaan ryhmityksestä:',

    'pb__dashboard' => 'Kotisivu',

    'server_interface__page_title' => 'Palvelimen liittymäasetukset',
    'server_interface__tabs_locales' => 'Aluekohtaiset asetukset',
    'server_interface__tabs_skins' => 'Ulkoasut',
    'server_interface__tabs_interface_templates' => 'Liittymän mallit',
    'bt_server_interface' => 'Liittymämääritykset',
    'pb__server_interface' => 'Liittymämääritykset',

    'bt_wizard_next' => 'Seuraava >>',
    'bt_wizard_prev' => '<< Edellinen',

    '__limit_exceeded_max_dom_server' => 'Et voi isännöidä tässä palvelimessa enempää toimialueita, koska käyttöoikeusavaimen määrittämä sallittu toimialueen aliasten enimmäismäärä tässä palvelimessa on saavutettu. Ota yhteyttä palveluntarjoajaan ongelman ratkaisemiseksi.',
    '__limit_exceeded_max_subdom_server' => 'Et voi isännöidä enää muita alitoimialueita tällä palvelimella. Ota yhteys palveluntarjoajaan.',
    '__limit_exceeded_max_dom_aliases_server' => 'Et voi asettaa tälle palvelimelle enää muita toimialueen aliaksia. Ota yhteys palveluntarjoajaan.',
    '__limit_exceeded_max_wu_server' => 'Et voi luoda lisää Internet-käyttäjiä, koska käyttöoikeusavaimen määrittämä sallittu Internet-käyttäjien enimmäismäärä tässä palvelimessa on saavutettu. Ota yhteyttä palveluntarjoajaan ongelman ratkaisemiseksi.',
    '__limit_exceeded_max_mn_server' => 'Et voi luoda lisää sähköpostitilejä, koska käyttöoikeusavaimen määrittämä sallittu sähköpostitilien enimmäismäärä tässä palvelimessa on saavutettu. Ota yhteyttä palveluntarjoajaan ongelman ratkaisemiseksi.',

    '__limit_exceeded_max_cl_useradmin' => 'Olet saavuttanut käyttöoikeusavaimen määrittämän asiakastilien maksimimäärän (%2)',
    '__limit_exceeded_max_dom_useradmin' => 'Olet saavuttanut käyttöoikeusavaimen määrittämän toimialueiden maksimimäärän (%2)',
    '__limit_exceeded_max_subdom_useradmin' => 'Olet saavuttanut käyttöoikeusavaimen määrittämän alitoimialueiden maksimimäärän (%2)',
    '__limit_exceeded_max_dom_aliases_useradmin' => 'Olet saavuttanut käyttöoikeusavaimesi (%2) määrittämän toimialueen aliasten enimmäismäärän.',
    '__limit_exceeded_disk_space_useradmin' => 'Vapaata levytilaa ei ole jäljellä',
    '__limit_exceeded_max_wu_useradmin' => 'Olet saavuttanut käyttöoikeusavaimen määrittämän verkkokäyttäjätilien maksimimäärän (%2)',
    '__limit_exceeded_max_db_useradmin' => 'Olet saavuttanut käyttöoikeusavaimen määrittämän tietokantojen maksimimäärän (%2)',
    '__limit_exceeded_max_box_useradmin' => 'Olet saavuttanut käyttöoikeusavaimen määrittämän postilaatikoiden maksimimäärän (%2)',
    '__limit_exceeded_max_mn_useradmin' => 'Olet saavuttanut käyttöoikeusavaimen määrittämän sähköpostitilien maksimimäärän (%2)',
    '__limit_exceeded_max_maillists_useradmin' => 'Olet saavuttanut käyttöoikeusavaimen määrittämän postituslistojen maksimimäärän (%2)',

    '__limit_exceeded_max_dom_userclient' => 'Olet saavuttanut toimialueen enimmäismäärän (%2)',
    '__limit_exceeded_max_subdom_userclient' => 'Olet saavuttanut palveluntarjoajan salliman alitoimialueiden enimmäismäärän (%2)',
    '__limit_exceeded_max_dom_aliases_userclient' => 'Olet saavuttanut toimialueen aliasten enimmäismäärän (%2)',
    '__limit_exceeded_disk_space_userclient' => 'Olet saavuttanut levytilan käyttörajan (%2)',
    '__limit_exceeded_max_traffic_userclient' => 'Olet saavuttanut kaistanleveyden kuukausittaisen käytön maksimirajan (%2)',
    '__limit_exceeded_max_wu_userclient' => 'Olet saavuttanut palveluntarjoajan salliman Internet-käyttäjien enimmäismäärän (%2).',
    '__limit_exceeded_max_db_userclient' => 'Olet saavuttanut tietokantojen enimmäismäärän (%2)',
    '__limit_exceeded_max_box_userclient' => 'Olet saavuttanut postilaatikoiden enimmäismäärän (%2)',
    '__limit_exceeded_max_maillists_userclient' => 'Olet saavuttanut postituslistojen enimmäismäärän (%2)',
    '__limit_exceeded_expiration_userclient' => 'Tilisi on vanhentunut %2',

    '__limit_exceeded_max_subdom_userdomain' => 'Olet saavuttanut palveluntarjoajan salliman alitoimialueiden enimmäismäärän (%2)',
    '__limit_exceeded_max_dom_aliases_userdomain' => 'Olet saavuttanut toimialueen aliasten enimmäismäärän (%2)',
    '__limit_exceeded_disk_space_userdomain' => 'Olet saavuttanut levytilan käyttörajan (%2)',
    '__limit_exceeded_max_traffic_userdomain' => 'Olet saavuttanut kaistanleveyden kuukausittaista käyttöä koskevan maksimirajan (%2)',
    '__limit_exceeded_max_wu_userdomain' => 'Olet saavuttanut verkkokäyttäjätilien maksimimäärän (%2)',
    '__limit_exceeded_max_db_userdomain' => 'Olet saavuttanut tietokantojen enimmäismäärän (%2)',
    '__limit_exceeded_max_box_userdomain' => 'Olet saavuttanut postilaatikoiden enimmäismäärän (%2)',
    '__limit_exceeded_max_maillists_userdomain' => 'Olet saavuttanut postituslistojen enimmäismäärän (%2)',
    '__limit_exceeded_expiration_userdomain' => 'Tilisi on vanhentunut %2',

    'mmt__to_none' => 'Ei ole',
    'mmt__to_admin' => 'Järjestelmänvalvoja',
    'mmt__to_resellers_all' => 'Kaikki jälleenmyyjät',
    'mmt__to_resellers_select' => 'Valitut jälleenmyyjät',
    'mmt__to_resellers_select__available' => 'Saatavilla olevat jälleenmyyjät',
    'mmt__to_resellers_except' => 'Kaikki paitsi valitut jälleenmyyjät',
    'mmt__to_clients_all' => 'Kaikki asiakkaat',
    'mmt__to_clients_select' => 'Valitut asiakkaat',
    'mmt__to_clients_select__available' => 'Saatavilla olevat asiakkaat',
    'mmt__to_clients_except' => 'Kaikki paitsi valitut asiakkaat',

    'mmt__unable_send_empty_selection' => 'Massapostin lähetys ei onnistu, sähköpostiosoitteita ei ole valittu.',
    'mmt__unable_send_to__' => 'Massasähköpostin lähetys ei onnistu kohteeseen:',
    'mmt__unable_send_to_email' => '%1 <%2>',

    'sapp_error_validation_not_found' => 'Verkkosovelluksen vahvistus ei onnistu, koska yksi tarvittavista tiedostoista (%1) ei löytynyt. Saat lisätietoja teknisestä tuesta.',
    'sapp_error_validation_spec_failed' => 'Ladattu verkkosovellus ei ole AppPacks-määritysten mukainen: %1.',
    'sapp_error_validation_register' => 'Hakemistossa "%1" sijaitsevan verkkosovelluksen rekisteröinti ei onnistu: %2 Poista verkkosovellus palvelimesta, koska se ei toimi oikein.',

    'sapp__install_failed' => 'Verkkosovelluksen asennus epäonnistui: %1',
    'sapp__install_res_failed' => 'Pyydetyn resurssin luominen epäonnistui.',

    'server_preferences__subdomains_blog_and_photo' => 'Luo blogi ja kuvagallerian alitoimialueet oletuksena',
    'plesk_key__blog_and_photo' => 'Oikeus hallita Luo blogi ja Kuvagalleria -alitoimialueiden ruudun oletustilaa',
    'ip_ctrl__cannot_make_exclusive_ip_with_more_than_one_client' => 'IP-osoitteen tyyppiä ei voida muuttaa varatuksi, koska se on määritetty useammalle kuin yhdelle käyttäjälle.',

    // 8.1.1

    '__write_modify_warning' => 'Kun valitaan ylimääräisiä kirjoitus-/muokkausoikeuksia, jotkut verkkosovellukset toimivat oikein, mutta tämä lisää huomattavasti turvallisuusriskejä.',
    '__write_modify_subdomain_warning' => 'Kun valitaan ylimääräisiä kirjoitus-/muokkausoikeuksia, jotkut verkkosovellukset toimivat oikein, mutta tämä lisää huomattavasti turvallisuusriskejä.',

    'phosting__php_incorrect_version_used' => "Ongelmia havaittiin PHP-versiossa. Kyseisten ongelmien ratkaisemiseksi valitse alla oleva ruutu vaaditulla PHP-versiolla ja napsauta OK. Poista PHP käytöstä tällä toimialueella napsauttamalla OK valitsematta PHP-versiota",
    'fp__mail_preferences' => 'Postiasetukset',

    'mail__invalid_white_pattern' => 'Määritetty arvo on virheellinen. Käytä seuraavia muotoja: mail@example.com sähköpostiosoitteille, example.com toimialueille.',
    'mail__invalid_black_pattern' => 'Määritetty arvo on virheellinen. Käytä seuraavaa muotoa: mail@example.com sähköpostiosoitteille, example.com toimialueille.',

    'resp_edit__reply_as_html' => 'Lähetä HTML-muodossa',
    'exception__path_very_long' => "Polku on liian pitkä. Varmista, että polussa on alle %1 merkkiä.",

    // 8.2


    //SAPP
    'sapp_on' => 'Päällä',
    'sapp_off' => 'Ei käytössä',
    'sapp_directive_aspect' => 'Pakollinen',
    'sapp_databases_num' => 'Tietokannat',
    'sapp_db_required' => 'Pakollinen',
    'sapp_Required' => 'Pakollinen',
    'sapp_Variant' => 'Variantti',
    'sapp_db_id' => 'Tietokannan tunnus',
    'sapp_db_id_type' => 'DB (id: %1) tyyppi',
    'sapp_db_id_min_version' => 'DB (id: %1) min.versio',
    'sapp_db_id_table_prefix' => 'DB (id: %1) taulukon etul.',
    'sapp_Default' => 'Oletusarvo',
    'sapp_apache_mod_req' => 'Apache-moduuli',
    'sapp_dbtype_not_installed' => 'ei asennettu',
    'sapp_apache_mod_not_installed' => 'ei asennettu',
    'sapp__value_error_empty' => 'Tyhjä arvo ei ole sallittu.',
    'sapp_error_invalid_type' => 'Sovellus "%1" ei tue pyydettyä toimintoa.',
    'sapp_error_unknown_app_type' => 'Sovellustyyppi, jota ei tueta: %1.',
    'sapp__ssl_text' => 'Haluatko asentaa sovelluksen virtuaaliseen isäntään "http://" tai "https://"?',
    'sapp__app_to_upgrade' => 'Päivitettävät sovellukset',
    'sapp__upgrade_apps_title' => 'Päivitä sovellukset',
    'sapp__upgrade_to_ver' => 'Päivitä versioon',
    'sapp__choose_pkg_ver' => 'Valitse paketti...',
    'sapp__pkg_cant_upgrade_pkg' => 'Pakettia "%1" ei voi käyttää verkkosovelluksen "%2" päivitykseen.',
    'sapp__app_ugrade_error' => 'Sovellusta ei voi päivittää: %1. Ota yhteys järjestelmänvalvojaan.',
    'sapp__no_suitable_db_found' => 'Sopivaa tietokantaa ei löytynyt.',
    'sapp__upgrade_success' =>  'Sovelluksen päivitys onnistui.',
    'sapp__pkg_info_changelog' => 'Muutoshistoria',
    'sapp_requirement_legend' => 'Sovelluksen tarvitsemat isännöintiominaisuudet',

    // other
    'odbc__mssql_wsid' => 'Työaseman tunnus',
    'odbc__mssql_driver' => 'Ohjain',
    'bt_apply' => 'Käytä',
    'mn_edit__add_alias_if_mailbox_disabled' => 'Sähköpostin aliaksen luomiseksi postilaatikko tulee ottaa käyttöön kyseisellä sähköpostitilillä.  Otetaanko postilaatikko käyttöön?',
    'mn_edit__mailbox_disable_if_has_alias' => 'Jos postilaatikko poistetaan käytöstä, sähköpostin aliakset poistetaan, sillä ne lakkaavat toimimasta.  Poistetaanko postilaatikko käytöstä?',
    'odbc__mysql_driver' => 'MySQL ODBC-ohjain',
    'antivirus__disable_reason_install' => 'Et voi hallita virustentorjuntaa, koska sitä ei ole asennettu.',
    'antivirus__disable_reason_key' => 'Et voi hallita virustentorjuntaa, koska sitä ei ole aktivoitu hyväksyttävällä käyttöoikeusavaimella.',
    'antivirus__disable_reason_deny_personal_settings' => 'Et voi hallita virustentorjuntaa, koska palvelinkäytäntö estää yksittäiset virustentorjuntasetukset.',
    'component_name__sqladminmssql' => 'Microsoft SQL Webadmin',
    'change_foreign_user_password' => 'Muuta salasana',
    'change_foreign_user_password_hint' => "Käyttäjä ei kuulu tähän sovellukseen. Mene toiseen sovellukseen napsauttamalla linkkiä ja muuta käyttäjän salasana siellä. Voidaksesi tehdä tämän sinulla on oltava tarvittavat oikeudet kyseisessä sovelluksessa.",
    'cf_url_text' => 'JDBC URL',
    'cf_sendStringParametersAsUnicode_text' => 'Merkkijonon muoto',
    'lang_unknown' => 'Tuntematon kieli',
    'odbc__access_driver' => 'Ohjain',
    'odbc__access_pwd' => 'Salasana',
    'odbc__access_uid' => 'Kirjautumistunnus',
    'odbc__excel_driver' => 'Ohjain',
    'pb__cl_ed' => 'Asiakastiedot',
    'pb__actionlog' => 'Toimintoloki',
    'pb__cl_limits' => 'Asiakkaan rajat',
    'pb__edit' => 'Muokkaa',
    'pb__subdom_edit' => 'Isännöintiasetukset',
    'cf__select_dsn_to_remove' => 'Valitse vähintään yksi poistettava DSN',

    // NEW 8.3 FEATURES

    'backup_mail_content' => 'Postilaatikoiden sisällön varmuuskopioiminen',

    'maillist_import_result' => "Sähköpostiosoitteiden kokonaismäärä tiedostossa: %1\ntuotujen sähköpostiosoitteiden määrä: %2\njo olemassa olevien sähköpostiosoitteiden määrä: %3\nkopioitujen sähköpostiosoitteiden määrä määritetyssä tiedostossa: %4\nvirheellisten sähköpostiosoitteiden määrä tiedostossa: %5",
    'maillist_import_error' => 'Sähköpostiosoitteiden luetteloa ei voida tuoda',

    //  spaw

    'spaw__unable_to_edit_no_body' => "Valitsemasi tiedosto on joko tyhjä tai valitussa koodauksessa on virheellinen HTML-asiakirja. Valitse oikea koodaus tai lisää yksinkertaisesti sisältöä tiedostoon.",

    'dom_pref__external_mail_srv' => "Ohjaa ulkoiselle sähköpostipalvelimelle IP-osoitteella:",
    'mn_edit__store_messages' => 'Postilaatikko',

    // aps

    'sapp__before_upgrade_notice' => 'Suosittelemme sovelluksen ja käyttäjätietojen varmuuskopiointia ennen päivityksen aloittamista.',
    'sapp__application_properties' => 'Sovelluksen ominaisuudet',
    'sapp__application_root_descr' => 'Sovelluksen pääsivu',

    'sapp__aps_license_invalid_id' => 'Käyttöoikeusavaimen tunnus on virheellinen: %1.',
    'sapp__aps_lic_key_alredy_exists' => 'Käyttöoikeus avainnumerolla %1 on jo olemassa tietokannassa.',
    'sapp__aps_lic_del_used' => 'Käyttöoikeusavainta ei voi poistaa, jokin asennettu sovellus käyttää sitä.',
    'sapp__aps_lic_del_unknown' => 'Käyttöoikeusavainta ei voi poistaa: %1',
    'sapp__aps_cappi_duplicate' => "Tämä sovellus on jo asiakkaan sovellussarjassa",
    'sapp__appi_not_shared_no_install' => "Asiakkaan sovellussarjassa ei ole tällaista sovellusta. Jos haluat asentaa tämän sovelluksen sivustolle, sinun täytyy ensin lisätä tämä sovellus asiakkaan sovellussarjaan.",
    'sapp__appi_shared_not_client' => "Asiakkaan sovellussarjassa ei ole tällaista sovellusta. Jos haluat päivittää tämän sovelluksen määritettyyn versioon, sinun täytyy ensin lisätä tämä sovellusversio asiakkaan sovellussarjaan.",
    'sapp__apply_license_script_not_found' => 'Tälle verkkosovellukselle ei löydy "apply-license" -komentosarjaa.',
    'sapp__unable_to_activate_key' => 'Virhe käyttöoikeusavaimen aktivointiyrityksen aikana: %1',
    'sapp__unable_to_delete_ai_instances_exists' => 'Jotkut asennetut verkkosovellukset edellyttävät tämän verkkosovelluksen olemassa oloa järjestelmässä.',
    'sapp__unable_to_delete_ai_in_pool' => 'Tämä sovellus on vielä asiakkaan sovellussarjassa.  Jos haluat poistaa tämän sovelluksen, sinun tulee ensin poistaa se kaikista asiakkaiden sovellussarjoista tai tehdä siitä ilmainen.',
    'sapp__unable_to_delete_app_template' => 'Sovellusta #%1 ei voitu poistaa: %2',
    'sapp__limit_exceeded_client' => 'Olet saavuttanut tämän verkkosovelluksen (%2) asennusten enimmäismäärän.',


    // atis module

    '_week_on' => 'viikkoa',
    '__week_first' => 'ensimmäinen',
    '__week_second' => 'sekunti',
    '__week_third' => 'Kolmas',
    '__week_fourth' => 'neljäs',
    '__week_last' => 'viimeinen',
    '__not_started' => 'Odottaa',
    '__started' => 'Suoritetaan',
    '__cancel_pending' => 'Peruutetaan',
    '__canceled' => 'Perutettu',
    '__error' => 'Virhe',
    '__done' => 'Valmis',

    '__php_cgi_handler' => 'CGI-sovellus',
    '__php_isapi_handler' => 'ISAPI-laajennus',
    '__php_fastcgi_handler' => 'FastCGI-sovellus',
    '__php_module_handler' => 'mod_php',
    '__php_run_as' => 'Suorita nimellä',

    'cf_dbfolder_text' =>'Tietokantakansio',
    'cf_isnewdb_text' => 'Luo tietokanta',
    'cf_isnewdb_title' => 'Valitse tekstiruutu, jos tietokanta on luotava',

    'pb__site_apps_upgrade' => 'Verkkosovelluksen päivitys',

    'detach' => 'Katkaise yhteys',
    'preferences' => "Muuta salasana",

    'toolsbar__switch_user?' => "Haluatko varmasti kirjautua sisään toisesta käyttäjätilistä?",
    '__aps_left' => 'Asennuksia jäljellä',
    'aps__license_key' => 'Käyttöoikeusavain',
    'aps__download_code' => 'Käyttöoikeusavaimen lataus- ja aktivointikoodi',
    'aps__license_key_hint' => 'Nouda käyttöoikeuspalvelimelta käyttämällä aktivointikoodia',
    'aps__database_not_available' => 'ei saatavilla, tarkista toimialueen tai asiakkaan rajat',
    'aps__yes' => 'kyllä',
    'aps__no' => 'ei',
    '__click_to_enlarge' => 'Suurenna napsauttamalla',
    'site_apps__back_to_list' => 'Palaa luetteloon',
    'sapp__pkg_info_installation_requirements' => 'Asennusvaatimukset',
    '__close_window' => 'Sulje',

    //SAPP END

    'skin_info__already_default' => 'Ulkoasu on jo asetettu oletukseksi.',

    //move this to other file after splitting drweb to module
    'drweb:virus_filter_full_name' => 'Plesk Premium Antivirus',
    'drweb:properties_page_title' => 'Plesk Premium Antivirus -asetukset kohteeseen %1',
    'drweb:properties_legend' => 'Asetukset',
    'drweb:status' => 'Tarkistetaan postia virusten varalta',

    // sb integration
    'sitebuilder_wizard' => 'Presence Builderin ohjattu toiminto',
    'dom_site_builder' => 'Avaa Presence Builderin ohjattu toiminto napsauttamalla.',
    'sb_plesk_admin_url' => 'Presence Builder -palvelimen URL. Varmista, että tämä osoite kohdistuu oikein DNS-vyöhykkeellä',
    'sb_plesk_admin_login' => 'Käyttäjätunnus palvelimen järjestelmänvalvojan kirjautumiseksi Presence Builder -järjestelmään',
    'sb_plesk_admin_password' => 'Järjestelmänvalvojan salasana',
    'sb_sitebuilder_preferences' => 'Presence Builder -järjestelmänvalvojan tunnukset',
    'sb__server' => 'Presence Builder -järjestelmän järjestelmänvalvojan omat asetukset',
    'sb__sitebuilder_support' => 'Presence Builder -tuki',
    'sb_keep_sb_user' => 'Säilytä vastaava käyttäjätili Presence Builderissa',
    'sb_create_sb_user' => 'Luo vastaava käyttäjätili Presence Builderissa',
    'sb__build_site_using_sitebuilder' => "Luo verkkosivusto Presence Builder -järjestelmällä",
    'sb_no_current_sb_server_set' => 'Yhteyttä Presence Builder -järjestelmään ei ole vielä määritetty: A-tietue on lisättävä DNS-vyöhykkeen malliin, joka yhdistyy Presence Builder -palvelimeen.',
    'sb_unable_update_sb_server_sb_return_message' => "Tietoja Presence Builder -järjestelmästä ei voida palauttaa:\n%1",
    'sb_unable_connect_sb_wrong_con_params' => "Presence Builder -yhteyttä ei voida luoda: virheellinen käyttäjätunnus tai salasana.",
    'sb_init_sb_manager' => "Presence Builder -hallintatoimintoa alustetaan: %1",
    'sb_err_couldnt_connect_sb' => "Presence Builder -järjestelmään ei voitu muodostaa yhteyttä.",
    'sb_err_client_dont_have_sbuser' => "Tällä asiakkaalla ei ole käyttäjätiliä Presence Builder -järjestelmässä.",
    'sb_err_sitebuilder_not_configured' => "Presence Builderia ei ole määritetty.",
    'sb_err_you_dont_have_sbaccount' => "Sinua ei voitu todentaa Presence Builder -järjestelmässä.",
    'sb_error_critical_during_operation' => "Presence Builderissa ilmeni seuraava virhe:\n%1",
    'sb_err_sso_is_not_enabled' => "Yksittäistä Sign-On-tukea ei ole otettu käyttöön Pleskissa.",

    'warning__super_zone_exist' => "Vyöhyke %1 luotiin, mutta tämä vyöhykkeen nimi on toisen jo olemassa olevan vyöhykkeen %2 alivyöhyke, joka kuuluu toiselle käyttäjälle %3. Tämä on mahdollista, mutta varmista silti, että olet valinnut oikean käyttäjätilin.",
    'error__super_zone_exist' => "DNS-vyöhykkeen luonti ei onnistu, koska sen ylävyöhyke kuuluu toiselle käyttäjälle.",

    'locales__files_not_exits' => 'Aluekohtaisia asetuksia ei voi muuttaa: määritettyjä liittymän kielipakettitiedostoja ei ole järjestelmässä.',
    'locales__unavailable' => 'Aluekohtaisia asetuksia ei voi muuttaa: määritetty liittymän kielipaketti ei ole saatavilla.',

    // DB BU

    'pb__dbbackup_list' => 'Tietokannan varmuuskopiotiedostot',
    // server
    'dbbackup__server_backup_settings' => 'Varmuuskopio',
    'dbbackup__network_temp_dir' => 'Väliaikainen verkkohakemisto',
    'dbbackup__network_user' => 'Käyttäjänimi',
    'dbbackup__network_pass' => 'Salasana',
    // domain
    'dbbackup__add_database_legend' => 'Palauta varmuuskopiointitietokanta',
    'dbbackup__add_database_restore' => 'Palauta tietokanta varmuuskopiointitiedostosta',
    'dbbackup__add_database_file' => 'Tietokannan varmuuskopiotiedosto',
    'dbbackup__add_database_user' => 'Oletuskäyttäjänimi',
    'dbbackup__add_database_pass' => 'Käyttäjän oletussalasana',
    'dbbackup__add_database_pass2' => 'Käyttäjän oletussalasanan vahvistus',

    'bt_dbbackup_now' => 'Varmuuskopioi',

    'bt_repair' => 'Korjaa',

    'dbbackup__mssql_dump_upload_not_allowed' => 'SQL Server -tietokannan vedoksien lataus on kiellettyä isännöintipalvelun tarjoajalle.',

    // APS categories

    'cf_invalid_password' => 'Salasana ei voi olla pidempi kuin 16 merkkiä',
    'cf_invalid_description_length' => 'Kuvauksen pituus voi olla enintään 256 merkkiä',
    'ip_addr__ip_used_by_external_mail_server' => 'IP-osoite %1 on jo ulkoisen sähköpostipalvelimen käytössä',

    // 8.4.1

    '__ftp_login_is_invalid' => 'FTP-tilin käyttäjätunnus tai salasana on virheellinen. Määritä virheettömät FTP-käyttäjän tunnukset.',

    // 8.6

    'dns__dns_serial_update_limit_warning' => 'Sarjanumeron muutosten enimmäismäärä on saavutettu. Tänään ei voi suorittaa enempää DNS-vyöhykemuutoksia.',
    'dns__zone_apply_changes' => 'DNS-tietueisiin tehtyjä muutoksia ei ole vielä tallennettu. Tehdyt muutokset on merkitty alapuolella korostettuina. Ota DNS-vyöhykkeen muutokset käyttöön valitsemalla Päivitä tai hylkää muutokset valitsemalla Palauta.',
    'dns__update_dns_zone' => 'Tallenna DNS-tietueisiin tehdyt muutokset napsauttamalla',
    'dns__revert_dns_zone' => 'Peruuta DNS-tietueisiin tehdyt muutokset napsauttamalla',
    'bt_revert' => 'Palauta',
    'dns__dns_zone_has_beed_updated' => 'DNS-tietueisiin tehdyt muutokset tallennettiin.',
    'dns__dns_zone_has_beed_reverted' => 'DNS-tietueisiin tehdyt muutokset peruutettiin',
    'db__nondefault_server_not_allowed' => 'Muun kuin oletustietokantapalvelimen käyttö ei ole sallittu',


    //// UI POINTER CAPTIONS START HERE
    ////
    // *** The strings below have been generated automatically from @@CAPTION directives.

    'ui__client__description' => 'Asiakkaan %1 tili ja toimialueet.',
    'ui__client__disabled-warning' => 'Asiakkaan %1 tili on peruutettu.',
    'ui__client__none-available' => 'Asiakastilejä ei ole määritetty.',
    'ui__client__short-title' => '%1',
    'ui__client__title' => 'Asiakas %1',
    'ui__client_self__description' => 'Omien toimialueiden luettelo',
    'ui__client_self__short-title' => 'Omat toimialueet',
    'ui__client_self__title' => 'Omat toimialueet',


    'site_apps__non_removable' => 'Kohteet, joita ei voi poistaa',
    'site_apps__non_removable_items' => 'Seuraavia verkkosovelluksia ei voi poistaa:',

    'ui__client/custom-buttons/custom-button__none-available' => 'Mukautettuja painikkeita ei ole.',
    'ui__client/custom-buttons/custom-button__none-available__1' => 'Asiakkaan %1 asiakaspaneelissa ei ole mukautettuja painikkeita.',

    'ui__client/custom-buttons/custom-button/delete__description' => 'Poista painike %1.',
    'ui__client/custom-buttons/custom-button/delete__short-title' => 'Poista',
    'ui__client/custom-buttons/custom-button/delete__title' => 'Poista painike %1',
    'ui__client/custom-buttons/custom-button/delete_multi__description' => 'Poista mukautetut painikkeet asiakkaan asiakaspaneelista',
    'ui__client/custom-buttons/custom-button/delete_multi__short-title' => 'Poista',
    'ui__client/custom-buttons/custom-button/delete_multi__title' => 'Poista mukautetut painikkeet',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard-title' => 'Poista painikkeet',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard__1_unknown' => 'Valitse asiakas, jonka mukautetut painikkeet haluat poistaa, ja valitse Seuraava >>.',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard__3_multi' => 'Valitse painikkeet, jotka haluat poistaa, ja valitse Seuraava >>.',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard__4_multi' => 'Vahvista painikkeiden poistaminen valitsemalla tässä näytössä oleva valintaruutu ja valitse sitten Valmis.',
    'ui__client/custom-buttons/custom-button/delete_unknown__description' => 'Poista mukautettu painike asiakkaan asiakaspaneelista.',
    'ui__client/custom-buttons/custom-button/delete_unknown__short-title' => 'Poista',
    'ui__client/custom-buttons/custom-button/delete_unknown__title' => 'Poista mukautettu painike',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard-title' => 'Poista mukautettu painike',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard__1_unknown' => 'Valitse asiakas, jonka mukautetun painikkeen haluat poistaa, ja valitse Seuraava >>.',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard__3_unknown' => 'Valitse mukautettu painike, jonka haluat poistaa, ja valitse Seuraava >>.',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard__4' => 'Vahvista mukautetun painikkeen poistaminen valitsemalla tässä näytössä oleva valintaruutu ja valitse sitten Valmis.',

    'ui__client/custom-buttons/custom-button/properties__description' => 'Muokkaa asiakastasoisen painikkeen %1 ominaisuuksia.',
    'ui__client/custom-buttons/custom-button/properties__short-title' => 'Asetukset',
    'ui__client/custom-buttons/custom-button/properties__title' => 'Muokkaa asiakkaan mukautettua painiketta %1',
    'ui__client/custom-buttons/custom-button/properties_new__wizard-title' => 'Lisää mukautettu painike',
    'ui__client/custom-buttons/custom-button/properties_new__wizard__1_unknown' => 'Valitse asiakas, jonka asiakaspaneeliin haluat luoda mukautetun painikkeen, ja valitse Seuraava>>.',
    'ui__client/custom-buttons/custom-button/properties_new__wizard__4_new' => 'Luo painike napsauttamalla Valmis.',
    'ui__client/custom-buttons/custom-button/properties_unknown__description' => 'Muuta painikkeen ominaisuuksia asiakkaan asiakaspaneelissa.',
    'ui__client/custom-buttons/custom-button/properties_unknown__short-title' => 'Ominaisuudet...',
    'ui__client/custom-buttons/custom-button/properties_unknown__title' => 'Muuta painikkeen ominaisuuksia asiakkaan asiakaspaneelissa',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard-title' => 'Muuta mukautetun painikkeen ominaisuuksia',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard__1_unknown' => 'Valitse asiakas, jonka mukautettua painiketta haluat muokata, ja valitse Seuraava >>.',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard__3_unknown' => 'Valitse mukautettu painike, jota haluat muokata, ja valitse Seuraava >>.',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard__4' => 'Kun olet muokannut painikkeen ominaisuudet, ota muutokset käyttöön valitsemalla Valmis ja poistu ohjatusta toiminnosta.',

    'ui__client/custom-buttons/custom-button/toggle_private__description' => 'Poista painike %1 asiakkaidesi käytöstä.',
    'ui__client/custom-buttons/custom-button/toggle_private__short-title' => 'Poista asiakkaidesi käytöstä',
    'ui__client/custom-buttons/custom-button/toggle_private__title' => 'Poista painike %1 asiakkaidesi käytöstä',
    'ui__client/custom-buttons/custom-button/toggle_public__description' => 'Tuo painike %1 näkyviin asiakkaan käyttäjille.',
    'ui__client/custom-buttons/custom-button/toggle_public__short-title' => 'Tuo asiakkaiden käyttöön',
    'ui__client/custom-buttons/custom-button/toggle_public__title' => 'Tuo painike %1 näkyviin asiakkaan käyttäjille',
    'ui__client/custom-buttons/custom-button/toggle_unknown__description' => 'Tuo mukautettu painike asiakkaiden käyttöön/poista mukautettu painike asiakkaiden käytöstä.',
    'ui__client/custom-buttons/custom-button/toggle_unknown__short-title' => 'Asiakkaidesi käytettävissä/ei asiakkaidesi käytettävissä',
    'ui__client/custom-buttons/custom-button/toggle_unknown__title' => 'Tuo mukautettu painike asiakkaiden käyttöön/poista mukautettu painike asiakkaiden käytöstä',
    'ui__client/custom-buttons/custom-button/toggle_unknown__wizard-title' => 'Tuo mukautettu painike asiakkaiden käyttöön/poista mukautettu painike asiakkaiden käytöstä.',
    'ui__client/custom-buttons/custom-button/toggle_unknown__wizard__1_unknown' => 'Valitse asiakas, jonka mukautetun painikkeen haluat tuoda asiakkaan käyttäjien käyttöön, ja valitse Seuraava >>.',
    'ui__client/custom-buttons/custom-button/toggle_unknown__wizard__3_unknown' => 'Valitse mukautettu painike, jonka haluat tuoda asiakkaiden käyttöön/poistaa asiakkaiden käytöstä, ja valitse Seuraava >>.',

    'ui__client/domain__description' => 'Hallitse toimialuetta %1.',
    'ui__client/domain__disabled-warning' => 'Toimialue %1 on peruutettu.',
    'ui__client/domain__none-available' => 'Sinulla ei ole toimialueita.',
    'ui__client/domain__none-available__1' => 'Kohteen %1 tilillä ei ole toimialueita.',
    'ui__client/domain__none-available__2' => 'Kohteen %1 tilillä ei ole toimialueita.',
    'ui__client/domain__short-title' => '%1',
    'ui__client/domain__title' => 'Toimialue %1',
    'ui__client/domain_self__description' => 'Hallitse toimialuetta.',
    'ui__client/domain_self__disabled-warning' => 'Toimialueesi on peruutettu.',
    'ui__client/domain_self__quick-search' => 'Omat toimialueet',
    'ui__client/domain_self__short-title' => 'Oma toimialue',
    'ui__client/domain_self__title' => 'Oma toimialue',

    'ui__client/domain/custom-buttons/custom-button__none-available' => 'Asiakkaan asiakaspaneelissa ei ole mukautettuja painikkeita.',
    'ui__client/domain/custom-buttons/custom-button__none-available__1' => 'Asiakkaan %1 asiakaspaneelissa ei ole mukautettuja painikkeita.',
    'ui__client/domain/custom-buttons/custom-button__none-available__2' => 'Toimialueessa %1 ei ole mukautettuja painikkeita.',
    'ui__client/domain/custom-buttons/custom-button/delete__description' => 'Poista mukautettu painike %1.',
    'ui__client/domain/custom-buttons/custom-button/delete__short-title' => 'Poista',
    'ui__client/domain/custom-buttons/custom-button/delete__title' => 'Poista mukautettu painike %1',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__description' => 'Poista mukautetut painikkeet.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__short-title' => 'Poista',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__title' => 'Poista mukautetut painikkeet',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard-title' => 'Poista mukautetut painikkeet',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__1_unknown' => 'Valitse asiakas, jonka toimialueen hallintapaneelista haluat poistaa painikkeet, ja valitse Seuraava >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__2_unknown' => 'Valitse toimialue, jonka hallintapaneelista haluat poistaa painikkeet, ja valitse Seuraava >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__4_multi' => 'Valitse painikkeet, jotka haluat poistaa, ja valitse Seuraava >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__5_multi' => 'Vahvista painikkeiden poisto valitsemalla vastaavat valintaruudut, poista painikkeet valitsemalla Valmis ja poistu ohjatusta toiminnosta.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__description' => 'Poista mukautettu painike.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__short-title' => 'Poista',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__title' => 'Poista mukautettu painike',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard-title' => 'Poista mukautettu painike',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__1_unknown' => 'Valitse asiakas, jonka toimialueen hallintapaneelista haluat poistaa mukautetun painikkeen, ja valitse Seuraava >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__2_unknown' => 'Valitse toimialue, jonka hallintapaneelista haluat poistaa painikkeen, ja valitse Seuraava >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__4_unknown' => 'Valitse mukautettu painike, jonka haluat poistaa, ja valitse Seuraava >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__5' => 'Vahvista mukautetun painikkeen poisto valitsemalla valintaruutu, poista painike valitsemalla Valmis ja poistu ohjatusta toiminnosta.',

    'ui__client/domain/custom-buttons/custom-button/properties__title' => "Muuta mukautetun painikkeen %1 ominaisuuksia",
    'ui__client/domain/custom-buttons/custom-button/properties__short-title' => "Ominaisuudet...",
    'ui__client/domain/custom-buttons/custom-button/properties__description' => "Muuta mukautetun painikkeen %1 ominaisuuksia asiakaspaneelissa.",

    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard-title' => 'Painikkeen lisääminen',
    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard__1_unknown' => 'Valitse asiakas, jonka asiakaspaneeliin haluat sijoittaa painikkeen, ja valitse Seuraava>>.',
    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard__2_unknown' => 'Valitse tilaus, jossa haluat muokata painiketta, ja valitse Seuraava >>.',
    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard__5_new' => 'Luo painike valitsemalla Valmis ja poistu ohjatusta toiminnosta.',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__description' => "Muuta painikkeen ominaisuuksia asiakaspaneelissa.",
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__short-title' => 'Ominaisuudet...',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__title' => 'Muuta painikkeen ominaisuuksia asiakaspaneelissa',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__wizard-title' => 'Muuta painikkeen ominaisuuksia',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__wizard__4_unknown' => "Valitse mukautettu painike, jonka asetuksia haluat muuttaa, ja valitse Seuraava >>.",
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__wizard__5' => 'Kun olet muuttanut painikkeen ominaisuudet, ota muutokset käyttöön valitsemalla Valmis ja poistu ohjatusta toiminnosta.',

    'ui__client/domain/custom-buttons/custom-button/toggle_private__description' => 'Poista painike %1 sähköpostin käyttäjien käytöstä tässä toimialueessa.',
    'ui__client/domain/custom-buttons/custom-button/toggle_private__short-title' => 'Ei sähköpostin käyttäjien käytössä',
    'ui__client/domain/custom-buttons/custom-button/toggle_private__title' => 'Poista painike %1 sähköpostin käyttäjien käytöstä tässä toimialueessa',
    'ui__client/domain/custom-buttons/custom-button/toggle_public__description' => 'Tuo painike %1 sähköpostin käyttäjien näkyviin tässä toimialueessa.',

    'ui__client/domain/custom-buttons/custom-button/toggle_public__short-title' => 'Tämän toimialueen sähköpostin käyttäjien käytössä',
    'ui__client/domain/custom-buttons/custom-button/toggle_public__title' => 'Tuo mukautettu painike %1 sähköpostin käyttäjien näkyviin tässä toimialueessa',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__description' => 'Tuo mukautettu painike muiden käyttäjien käyttöön/poista mukautettu painike muiden käyttäjien käytöstä.',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__short-title' => 'Muiden käyttäjien käytössä/ei muiden käyttäjien käytössä',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__title' => 'Tuo mukautettu painike sähköpostin käyttäjien käyttöön/poista mukautettu painike sähköpostin käyttäjien käytöstä',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__wizard-title' => 'Tuo mukautettu painike muiden käyttäjien käyttöön/poista mukautettu painike muiden käyttäjien käytöstä',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__wizard__2_unknown' => 'Valitse toimialue, jossa painike sijaitsee, ja valitse Seuraava >>.',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__wizard__4_unknown' => 'Valitse painike, jonka haluat ottaa muiden käyttäjien käyttöön/poistaa muiden käyttäjien käytöstä, ja valitse Seuraava >>.',

    'ui__client/domain/delete__description' => 'Poista toimialue %1.',
    'ui__client/domain/delete__short-title' => 'Poista',
    'ui__client/domain/delete__title' => 'Poista toimialue %1',
    'ui__client/domain/delete_multi__description' => 'Poista toimialueet.',

    'ui__client/domain/delete_multi__short-title' => 'Poista',
    'ui__client/domain/delete_multi__title' => 'Poista toimialueet',
    'ui__client/domain/delete_multi__wizard-title' => 'Poista toimialueet',
    'ui__client/domain/delete_multi__wizard__2_multi' => 'Valitse toimialueet, jotka haluat poistaa, ja valitse Seuraava >>.',
    'ui__client/domain/delete_multi__wizard__3_multi' => 'Vahvista toimialueiden poisto valitsemalla valintaruutu, poista ne valitsemalla Valmis ja poistu ohjatusta toiminnosta.',
    'ui__client/domain/delete_unknown__description' => 'Poista toimialue.',
    'ui__client/domain/delete_unknown__short-title' => 'Poista',
    'ui__client/domain/delete_unknown__title' => 'Poista toimialue',
    'ui__client/domain/delete_unknown__wizard-title' => 'Poista toimialue',
    'ui__client/domain/delete_unknown__wizard__2_unknown' => 'Valitse toimialue, jonka haluat poistaa, ja valitse Seuraava >>.',
    'ui__client/domain/delete_unknown__wizard__3' => 'Vahvista toimialueen poisto valitsemalla valintaruutu, poista toimialueet valitsemalla Valmis ja poistu ohjatusta toiminnosta.',

    'ui__client/domain/hosting__none-available' => 'Toimialueita, joille on määritetty verkkosivuston isännöinti, ei ole. Luo toimialue ja määritä sille verkkosivuston isännöinti voidaksesi käyttää tätä toimintoa.',
    'ui__client/domain/hosting__none-available__1' => 'Tällä käyttäjätilillä ei ole toimialueita, joille on määritetty verkkosivuston isännöinti. Määritä tarvittavalle toimialueelle verkkosivuston isännöinti voidaksesi käyttää tätä toimintoa.',
    'ui__client/domain/hosting__none-available__2' => 'Verkkosivuston isännöintiä ei ole määritetty toimialueelle %1. Määritä verkkosivuston isännöinti toimialueelle %1 voidaksesi käyttää tätä toimintoa.',

    'ui__client/domain/hosting/file-manager_unknown__wizard-title' => 'Hallitse tiedostoja ja hakemistoja',
    'ui__client/domain/hosting/file-manager_unknown__wizard__2_unknown' => 'Valitse tietokanta, jonka tiedostoja haluat käsitellä.',
    'ui__client/domain/hosting/file-manager_unknown__wizard__3/properties_phosting' => 'Isännöintiä ei ole vielä määritetty toimialueelle. Määritä fyysinen isännöinti ja siirry tiedostonhallintaan valitsemalla Seuraava >>.',
    'ui__client/domain/hosting/file-manager_unknown__wizard__3/properties_self-phosting' => 'Isännöintiä ei ole vielä määritetty toimialueellesi. Määritä fyysinen isännöinti ja siirry tiedostonhallintaan valitsemalla Seuraava >>.',
    'ui__client/domain/hosting/file-manager_unknown__wizard__4' => 'Kun olet käsitellyt tiedostoja ja hakemistoja, poistu ohjatusta toiminnosta valitsemalla Valmis.',
    'ui__client/domain/hosting/file-manager_unknown__wizard__4_self' => 'Kun olet käsitellyt tiedostoja ja hakemistoja, poistu ohjatusta toiminnosta valitsemalla Valmis.',

    'ui__client/domain/hosting/performance_readonly-unknown__wizard-title' => 'Näytä isännöinnin suorituskykyasetukset',

    'ui__client/domain/hosting/performance_unknown__wizard-title' => 'Säädä verkkosivuston isännöinnin suorituskykyasetuksia',
    'ui__client/domain/hosting/performance_unknown__wizard__2_readonly-unknown' => 'Valitse toimialue, jonka isännöinnin suorituskykyasetukset haluat näyttää, ja valitse Seuraava >>.',
    'ui__client/domain/hosting/performance_unknown__wizard__2_unknown' => 'Valitse toimialue, jonka isännöinnin suorituskykyasetukset haluat määrittää, ja valitse Seuraava >>.',
    'ui__client/domain/hosting/performance_unknown__wizard__4' => 'Säädä toimialueen isännöinnin suorituskykyasetuksia ja valitse Valmis.',
    'ui__client/domain/hosting/performance_unknown__wizard__4_readonly' => 'Kun olet näyttänyt toimialueen isännöinnin suorituskykyasetukset, valitse Valmis.',
    'ui__client/domain/hosting/performance_unknown__wizard__4_readonly-self' => 'Kun olet näyttänyt toimialueesi isännöinnin suorituskykyasetukset, valitse Valmis.',
    'ui__client/domain/hosting/performance_unknown__wizard__4_readonly-unknown' => 'Kun olet näyttänyt toimialueen isännöinnin suorituskykyasetukset, valitse Valmis.',
    'ui__client/domain/hosting/performance_unknown__wizard__4_self' => 'Kun olet määrittänyt toimialueesi isännöinnin suorituskykyasetukset, valitse Valmis.',
    'ui__client/domain/hosting/performance_unknown__wizard__4_unknown' => 'Kun olet määrittänyt toimialueen isännöinnin suorituskykyasetukset, valitse Valmis.',

    'ui__client/domain/hosting/application#list_header__clients_number__title' => "Asiakkaat",
    'ui__client/domain/hosting/application#list_header__description__title' => "Kuvaus",
    'ui__client/domain/hosting/application#list_header__items_number__title' => "Kohteet",
    'ui__client/domain/hosting/application#list_header__name__title' => "Nimi",
    'ui__client/domain/hosting/application#list_header__release__title' => "Julkaisu",
    'ui__client/domain/hosting/application#list_header__sort_by_clients_number__title' => "Lajittele asiakkaiden mukaan",
    'ui__client/domain/hosting/application#list_header__sort_by_description__title' => "Lajittele kuvauksen mukaan",
    'ui__client/domain/hosting/application#list_header__sort_by_items_number__title' => "Lajittele kohteiden mukaan",
    'ui__client/domain/hosting/application#list_header__sort_by_name__title' => "Lajittele nimen mukaan",
    'ui__client/domain/hosting/application#list_header__sort_by_release__title' => "Lajittele version mukaan",
    'ui__client/domain/hosting/application#list_header__sort_by_version__title' => "Lajittele version mukaan",
    'ui__client/domain/hosting/application#list_header__title' => "Verkkosovellukset",
    'ui__client/domain/hosting/application#list_header__version__title' => "Versiot",

    'ui__client/domain/properties__client_ip_address_was_assigned' => 'IP-osoite %%ip_address%% on osoitettu kohteelle %%client_name%%.',
    'ui__client/domain/properties__client_ip_pool_is_empty' => 'Käyttäjän IP-ryhmä on tyhjä. Valittu IP-osoite määritetään vastaavalle käyttäjätilille.',

    'ui__client/domain/properties_new-adhoc__wizard__3_new' => 'Uusi toimialue luodaan heti, kun valitset Seuraava >>.',

    'ui__client/domain/properties_new__wizard-title' => 'Luo arvoalue',
    'ui__client/domain/properties_new__wizard__1_unknown' => 'Valitse asiakas, jolle haluat luoda toimialueen.',
    'ui__client/domain/properties_new__wizard__2/hosting/properties' => 'Valitse haluamasi isännöintipalvelutyyppi ja valitse Seuraava >>.',
    'ui__client/domain/properties_new__wizard__2/hosting/properties_forwarding' => 'Kun olet määrittänyt edelleenlähetyksen toimialueessa, ota määritys käyttöön valitsemalla Valmis ja poistu ohjatusta toiminnosta.',
    'ui__client/domain/properties_new__wizard__2/hosting/properties_phosting' => 'Kun olet määrittänyt isännöintipalvelun toimialueessa, ota kaikki muutokset käyttöön valitsemalla Valmis ja poistu ohjatusta toiminnosta.',

    'ui__client/domain/properties_unknown__wizard-title' => 'Määritä toimialueen järjestelmänvalvojan tili',
    'ui__client/domain/properties_unknown__wizard__2_unknown' => 'Valitse toimialue, jolle haluat määrittää toimialueen järjestelmänvalvojan tilin.',
    'ui__client/domain/properties_unknown__wizard__3' => 'Viimeistele toimialueen järjestelmänvalvojan tilin luonti valitsemalla Valmis.',
    'ui__client/domain/properties_unknown__wizard__3_self' => 'Ota muutokset käyttöön ja poistu ohjatusta toiminnosta valitsemalla Valmis.',

    'ui__client/domain/report/anon-ftp-stats_unknown__description' => 'Toimialueen anonyymit FTP-tilastot',
    'ui__client/domain/report/anon-ftp-stats_unknown__short-title' => 'Anonyymin FTP:n tilastotiedot',
    'ui__client/domain/report/anon-ftp-stats_unknown__title' => 'Toimialueen anonyymit FTP-tilastot',

    'ui__client/domain/report/ftp-stats_unknown__description' => 'Toimialueen FTP-tilastot',
    'ui__client/domain/report/ftp-stats_unknown__short-title' => 'FTP-tilastotiedot',
    'ui__client/domain/report/ftp-stats_unknown__title' => 'Toimialueen FTP-tilastot',

    'ui__client/domain/report/traffic__description' => 'Näytä verkkosivuston %1 kaistanleveyden käyttö',
    'ui__client/domain/report/traffic__short-title' => 'Kaistanleveyden käyttö',
    'ui__client/domain/report/traffic__title' => 'Verkkosivuston %1 käyttämä kaistanleveys',

    'ui__client/domain/report/web-stats-ssl_unknown__description' => 'Sivuston suojattujen vierailujen tilastotiedot',
    'ui__client/domain/report/web-stats-ssl_unknown__short-title' => 'SSL/TLS-vierailujen tilastotiedot',
    'ui__client/domain/report/web-stats-ssl_unknown__title' => 'Sivuston suojattujen vierailujen tilastotiedot',

    'rpt_reseller_section_general' => 'Yleiset',
    'rpt_reseller_section_domains' => 'Toimialueet',
    'rpt_reseller_section_clients' => 'Asiakkaat',
    'statistics__cl_active_domains' => "Aktiiviset toimialueet",
    'rpt_reseller_cl_domains' => "Toimialueet",
    'rpt_reseller_cl_subdomains' => "Alitoimialueet",
    'by__cl_domains' => "clientin toimialueet",
    'dom_ctrl__cl_mboxes' => "Postilaatikot",
    'rpt_reseller_cl_redirects' => "Välittäjät",
    'rpt_reseller_cl_mail_groups' => "Postitusryhmät",
    'rpt_reseller_cl_mail_resps' => "Automaattiset vastaukset",
    'rpt_reseller_cl_mail_lists' => "Postituslistat",
    'rpt_reseller_cl_web_users' => "Internet-käyttäjät",
    'rpt_reseller_cl_data_bases' => "Tietokannat",

    'statistics__active_clients' => 'Asiakkaat, joilla on aktiivisia tilauksia',
    'statistics__clients_active_domains' => 'Aktiiviset toimialueet',
    'statistics__clients_doms' => 'Toimialueet',
    'statistics__cl_doms' => 'Toimialueet',
    '__clients_subdomains' => 'Alitoimialueet',
    '__clients_domains' => 'Toimialueet',
    'dom_ctrl__clients_mboxes' => 'Postilaatikot',
    'dom_ctrl__clients_redir' => 'Välittäjät',
    'dom_ctrl__clients_mg' => 'Postitusryhmät',
    'dom_ctrl__clients_resp' => 'Automaattiset vastaukset',
    'dom_ctrl__clients_maillists' => 'Postituslistat',
    'dom_ctrl__clients_wu' => 'Internet-käyttäjät',
    'dom_ctrl__clients_db' => 'Tietokannat',

    'dom_ctrl__cl_redir' => 'Välittäjät', // to resolve!
    'dom_ctrl__cl_mg' => 'Postitusryhmät', // to resolve!
    'dom_ctrl__cl_resp' => 'Automaattiset vastaukset', // to resolve!
    'dom_ctrl__cl_maillists' => 'Postituslistat', // to resolve!
    'dom_ctrl__cl_wu' => 'Internet-käyttäjät', // to resolve!
    'dom_ctrl__cl_db' => 'Tietokannat', // to resolve!

    'rpt_cl_section_clients' => 'Asiakkaat',

    'rpt_admin_section_general' => 'Yleiset',
    'rpt_admin_section_resellers' => 'Jälleenmyyjät',
    'rpt_admin_section_clients' => 'Asiakkaat',
    'rpt_admin_section_personal_clients' => 'Omat asiakkaat',
    'rpt_admin_section_domains' => 'Toimialueet',
    'rpt_admin_section_personal_domains' => 'Henkilökohtaiset toimialueet',

    'rpt_reseller_section_personal_domains' => 'Henkilökohtaiset toimialueet',

    'ui__client/domain/toggle_unknown__wizard__2_unknown' => 'Valitse toimialue, jonka haluat peruuttaa tai aktivoida.',
    'ui__client/domain/toggle_unknown__wizard-title' => 'Peruuta tai aktivoi toimialue',

    'ui__client/ip-pool__description' => 'Määritä asiakkaan %1 IP-osoitteet ja SSL/TLS-varmenteet tai poista niiden määritys asiakkaalta %1.',
    'ui__client/ip-pool__short-title' => 'IP-ryhmä',
    'ui__client/ip-pool__title' => 'Asiakkaan %1 IP-ryhmä',
    'ui__client/ip-pool_self__description' => 'Näytä IP-ryhmäsi.',
    'ui__client/ip-pool_self__short-title' => 'IP-ryhmä',
    'ui__client/ip-pool_self__title' => 'Oma IP-ryhmä',
    'ui__client/ip-pool/properties__description' => 'Määritä IP-ryhmä asiakkaalle %1.',

    'ui__client/ip-pool/properties__short-title' => 'IP-ryhmä',
    'ui__client/ip-pool/properties__title' => 'Määritä IP-ryhmä asiakkaalle %1',
    'ui__client/ip-pool/properties_self__description' => 'Näytä IP-ryhmäsi.',

    'ui__client/ip-pool/properties_self__short-title' => 'Oma IP-ryhmä',
    'ui__client/ip-pool/properties_self__title' => 'Oma IP-ryhmä',
    'ui__client/ip-pool/properties_unknown__description' => 'Määritä IP-osoitteet ja SSL/TLS-varmenteet asiakkaalle tai poista niiden määritys asiakkaalta.',
    'ui__client/ip-pool/properties_unknown__short-title' => 'IP-ryhmä',
    'ui__client/ip-pool/properties_unknown__title' => 'Määritä asiakkaan IP-ryhmä',
    'ui__client/ip-pool/properties_unknown__wizard-title' => 'Määritä asiakkaan IP-ryhmä',
    'ui__client/ip-pool/properties_unknown__wizard__1_unknown' => 'Valitse asiakas, jonka IP-ryhmän haluat määrittää.',
    'ui__client/ip-pool/properties_unknown__wizard__3' => 'Kun olet määrittänyt IP-ryhmän, ota muutokset käyttöön valitsemalla Valmis ja poistu ohjatusta toiminnosta.',


    'ui__client/limits_readonly-unknown__description' => 'Näytä asiakkaan resurssirajat.',
    'ui__client/limits_readonly-unknown__short-title' => 'Resurssirajat',
    'ui__client/limits_readonly-unknown__title' => 'Näytä asiakastilin resurssirajat',
    'ui__client/limits_readonly-unknown__wizard-title' => 'Tarkastele tai muuta asiakkaan resurssirajoja',

    'ui__client/limits_unknown__wizard-title' => 'Tarkastele tai muuta asiakkaan resurssirajoja',
    'ui__client/limits_unknown__wizard__1_readonly-unknown' => 'Valitse tarvitsemasi asiakas.',
    'ui__client/limits_unknown__wizard__1_unknown' => 'Valitse tarvitsemasi asiakas.',
    'ui__client/limits_unknown__wizard__2' => 'Ota muutokset käyttöön valitsemalla Valmis.',
    'ui__client/limits_unknown__wizard__2_readonly' => 'Lopeta ohjattu toiminto napsauttamalla Valmis.',
    'ui__client/limits_unknown__wizard__2_readonly-self' => 'Lopeta ohjattu toiminto napsauttamalla Valmis.',
    'ui__client/limits_unknown__wizard__2_readonly-self-reseller' => 'Lopeta ohjattu toiminto napsauttamalla Valmis.',

    'ui__client/permissions_unknown__wizard-title' => 'Tarkastele tai muuta asiakkaan oikeuksia',
    'ui__client/permissions_unknown__wizard__1/properties_self' => 'Kun olet tarkastellut oikeuksiasi, ota muutokset käyttöön valitsemalla Valmis ja poistu ohjatusta toiminnosta.',
    'ui__client/permissions_unknown__wizard__1_unknown' => 'Valitse asiakas, jonka oikeuksia haluat tarkastella tai muuttaa.',
    'ui__client/permissions_unknown__wizard__2' => 'Kun olet muuttanut asiakkaan oikeudet, ota muutokset käyttöön valitsemalla Valmis ja poistu ohjatusta toiminnosta.',

    'ui__client/preferences_unknown__wizard-title' => 'Muokkaa asiakkaan asetuksia',
    'ui__client/preferences_unknown__wizard__1_unknown' => 'Valitse asiakas, jonka istunto- ja liittymämäärityksiä haluat hallita.',
    'ui__client/preferences_unknown__wizard__2' => 'Kun asiakkaan omat asetukset on muutettu, napsauta Lopeta.',
    'ui__client/preferences_unknown__wizard__2_self' => 'Kun omat asetukset on muutettu, napsauta Lopeta.',

    'ui__custom-buttons/custom-button__none-available' => 'Sinulla ei ole mukautettuja painikkeita.',
    'ui__custom-buttons/custom-button/delete__description' => 'Poista mukautettu painike %1.',
    'ui__custom-buttons/custom-button/delete__short-title' => 'Poista',
    'ui__custom-buttons/custom-button/delete__title' => 'Poista mukautettu painike %1',
    'ui__custom-buttons/custom-button/delete_multi__description' => 'Poista mukautetut painikkeet.',

    'ui__custom-buttons/custom-button/delete_multi__short-title' => 'Poista',
    'ui__custom-buttons/custom-button/delete_multi__title' => 'Poista mukautetut painikkeet',
    'ui__custom-buttons/custom-button/delete_multi__wizard-title' => 'Poista mukautetut painikkeet',
    'ui__custom-buttons/custom-button/delete_multi__wizard__2_multi' => 'Valitse poistettavat painikkeet.',
    'ui__custom-buttons/custom-button/delete_multi__wizard__3_multi' => 'Vahvista painikkeiden poisto valitsemalla valintaruutu ja suorita ohjattu toiminto loppuun valitsemalla Valmis.',
    'ui__custom-buttons/custom-button/delete_unknown__description' => 'Poista mukautetut painikkeet.',
    'ui__custom-buttons/custom-button/delete_unknown__short-title' => 'Poista',
    'ui__custom-buttons/custom-button/delete_unknown__title' => 'Poista mukautetut painikkeet',
    'ui__custom-buttons/custom-button/delete_unknown__wizard-title' => 'Poista mukautetut painikkeet',
    'ui__custom-buttons/custom-button/delete_unknown__wizard__2_unknown' => 'Valitse poistettava mukautettu painike.',
    'ui__custom-buttons/custom-button/delete_unknown__wizard__3' => 'Vahvista painikkeen poisto valitsemalla valintaruutu ja suorita ohjattu toiminto loppuun valitsemalla Valmis.',
    'ui__custom-buttons/custom-button/properties__description' => 'Muuta painikkeen %1 ominaisuuksia.',

    'ui__custom-buttons/custom-button/properties__short-title' => 'Ominaisuudet...',
    'ui__custom-buttons/custom-button/properties__title' => 'Muuta painikkeen %1 ominaisuuksia',

    'ui__custom-buttons/custom-button/properties_new__wizard-title' => 'Luo painike',
    'ui__custom-buttons/custom-button/properties_new__wizard__3_new' => 'Luo painike napsauttamalla Valmis.',
    'ui__custom-buttons/custom-button/properties_unknown__description' => 'Muuta mukautetun painikkeen ominaisuuksia.',
    'ui__custom-buttons/custom-button/properties_unknown__short-title' => 'Ominaisuudet...',
    'ui__custom-buttons/custom-button/properties_unknown__title' => 'Muuta mukautetun painikkeen ominaisuuksia',
    'ui__custom-buttons/custom-button/properties_unknown__wizard-title' => 'Muuta mukautetun painikkeen ominaisuuksia',
    'ui__custom-buttons/custom-button/properties_unknown__wizard__2_unknown' => 'Valitse mukautettu painike, jonka ominaisuuksia haluat muuttaa.',
    'ui__custom-buttons/custom-button/properties_unknown__wizard__3' => 'Ota muutokset käyttöön valitsemalla Valmis.',
    'ui__custom-buttons/custom-button/toggle_private__description' => 'Poista mukautettu painike %1 muiden käyttäjien käytöstä.',

    'ui__custom-buttons/custom-button/toggle_private__short-title' => 'Ei muiden käyttäjien käytössä',
    'ui__custom-buttons/custom-button/toggle_private__title' => 'Poista mukautettu painike %1 muiden käyttäjien käytöstä',
    'ui__custom-buttons/custom-button/toggle_public__description' => 'Tuo mukautettu painike %1 muiden käyttäjien käyttöön.',

    'ui__custom-buttons/custom-button/toggle_public__short-title' => 'Muiden käyttäjien käytössä',
    'ui__custom-buttons/custom-button/toggle_public__title' => 'Tuo mukautettu painike %1 muiden käyttäjien käyttöön',
    'ui__custom-buttons/custom-button/toggle_unknown__description' => 'Tuo mukautettu painike muiden käyttäjien käyttöön/poista mukautettu painike muiden käyttäjien käytöstä.',
    'ui__custom-buttons/custom-button/toggle_unknown__short-title' => 'Muiden käyttäjien käytössä/ei muiden käyttäjien käytössä',
    'ui__custom-buttons/custom-button/toggle_unknown__title' => 'Tuo mukautettu painike muiden käyttäjien käyttöön/poista mukautettu painike muiden käyttäjien käytöstä',
    'ui__custom-buttons/custom-button/toggle_unknown__wizard-title' => 'Tuo mukautettu painike muiden käyttäjien käyttöön/poista mukautettu painike muiden käyttäjien käytöstä',
    'ui__custom-buttons/custom-button/toggle_unknown__wizard__2_unknown' => 'Valitse mukautettu painike, jonka haluat tuoda muiden käyttäjien käyttöön/poistaa muiden käyttäjien käytöstä, ja valitse Seuraava >>.',

    'ui__longtasks#list_header__name__title' => "Nimi",
    'ui__longtasks#list_header__owner__title' => "Omistaja",
    'ui__longtasks#list_header__start_time__title' => "Luontiaika",
    'ui__longtasks#list_header__status__title' => "Tila",
    'ui__longtasks#list_header__title' => "Tehtävät",
    'ui__longtasks#list_header__finish_time__title' => "Suoritusaika",
    'ui__longtasks#task_list_legend__title' => "Tehtävät",
    'ui__longtasks#tools_legend__title' => "Työkalut",
    'ui__longtasks__description' => "Hallitse taustatehtäviä",
    'ui__longtasks__short-title' => "Taustatehtävät",
    'ui__longtasks__title' => "Taustatehtävät",
    'ui__longtasks/longtask/properties#current_operation__title' => "Nykyinen toiminto:",
    'ui__longtasks/longtask/properties#finish_time__title' => "Arvioitu valmistumisaika:",
    'ui__longtasks/longtask/properties#general_legend__title' => "Yleiset",
    'ui__longtasks/longtask/properties#owner__title' => "Tehtävä aloitettiin:",
    'ui__longtasks/longtask/properties#progress__title' => "Edistyminen:",
    'ui__longtasks/longtask/properties#start_time__title' => "Tehtävä aloitettiin:",
    'ui__longtasks/longtask/properties#status_legend__title' => "Tehtävän tila",
    'ui__longtasks/longtask/properties__description' => "Taustatehtävän tila ja tiedot",

    'ui__longtasks/properties__description' => "Taustatehtävien asetukset",
    'ui__longtasks/properties__short-title' => "Asetukset",
    'ui__longtasks/properties__title' => "Taustatehtävät",

    // updated
    'ui__mass-mail/template#list_header__title' => 'Massasähköpostin mallit',
    'ui__mass-mail/template#list_header__name__title' => 'Mallin nimi',
    'ui__mass-mail/template#list_header__from_email__title' => 'Lähettäjä',
    'ui__mass-mail/template#list_header__to__title' => 'Vastaanottajat',
    'ui__mass-mail/template#list_header__subject__title' => 'Aihe',
    'ui__mass-mail/template#list_header__cdate__title' => 'Luontipäivä',
    'ui__mass-mail/template#list_header__send__title' => 'Lähetä',

    'ui__mass-mail/template/properties__short-title' => '%1',
    'ui__mass-mail/template/properties__title' => 'Muokkaa massasähköpostiviestin mallia',
    'ui__mass-mail/template/properties__description' => 'Muokkaa tätä massasähköpostiviestin mallia.',

    'ui__mass-mail/template/properties_unknown-new__short-title' => 'Lisää massasähköpostin malli',
    'ui__mass-mail/template/properties_unknown-new__title' => 'Lisää massasähköpostin malli',
    'ui__mass-mail/template/properties_unknown-new__description' => 'Lisää massasähköpostiviestin malli.',
    'ui__mass-mail/send__short-title' => 'Lähetä massasähköposti',
    'ui__mass-mail/send__title' => 'Lähetä massasähköpostiviesti',
    'ui__mass-mail/send__description' => 'Lähetä massasähköpostiviesti valituille vastaanottajille.',
    'ui__mass-mail/template/delete_multi__short-title' => 'Poista massasähköpostimallit',
    'ui__mass-mail/template/delete_multi__title' => 'Poista nämä massasähköpostiviestin mallit:',
    'ui__mass-mail/template/delete_multi__description' => 'Poista valitut massasähköpostin mallit.',
    'ui__mass-mail/template/delete_multi__done' => 'Valitut viestimallit poistettiin.',
    'ui__mass-mail/template/properties__invalid_values' => 'Virheelliset arvot määritetty',


    // old
    'ui__mass-mail#body_text__description' => '<name>Voit käyttää muuttujaa viestin tekstissä (sitä ei voida käyttää kuitenkaan otsikossa). Se korvataan asiakkaan tai jälleenmyyjän yhteyshenkilön nimellä.',
    'ui__mass-mail#body_text__title' => 'Viestin teksti',
    'ui__mass-mail#compose_legend__title' => 'Viesti',
    'ui__mass-mail#from_email_text__title' => 'Sähköpostista',
    'ui__mass-mail#list_header__cdate__title' => 'Luotu',
    'ui__mass-mail#list_header__from_email__title' => 'Lähettäjä',
    'ui__mass-mail#list_header__name__title' => 'Nimi',
    'ui__mass-mail#list_header__send__title' => 'Luo viesti',
    'ui__mass-mail#list_header__subject__title' => 'Aihe',
    'ui__mass-mail#list_header__title' => 'Massasähköpostin mallit',
    'ui__mass-mail#list_header__to__title' => 'Vast.ott.',
    'ui__mass-mail#list_legend__title' => 'Massasähköpostin mallit',
    'ui__mass-mail#load_template_text__title' => 'Lataa',
    'ui__mass-mail#name_text__title' => 'Mallin nimi',
    'ui__mass-mail#option_mode_all__title' => 'Kaikki',
    'ui__mass-mail#option_mode_except__title' => 'Kaikki paitsi valitut',
    'ui__mass-mail#option_mode_select__title' => 'Vain valitut',
    'ui__mass-mail#option_select_template__title' => '---Valitse malli---',
    'ui__mass-mail#picker_legend__title' => 'Sähköpostiviestin mallit',
    'ui__mass-mail#picker_title__title' => 'Valitse malli',
    'ui__mass-mail#save_as_legend__title' => 'Tallenna mallina',
    'ui__mass-mail#save_as_text__title' => 'Tallenna laadittu viesti uuteen malliin nimellä',
    'ui__mass-mail#subject_text__title' => 'Aihe',
    'ui__mass-mail#template_legend__title' => 'Malli',
    'ui__mass-mail#to_admin_text__title' => 'Pleskin järjestelmänvalvoja',
    'ui__mass-mail#to_clients_text__title' => 'Asiakkaat',
    'ui__mass-mail#to_domains_text__title' => 'Toimialueen järjestelmänvalvojat',
    'ui__mass-mail#to_select_text__title' => 'Valitse osoitteet',
    'ui__mass-mail#to_show_hide_text__title' => 'Näytä/piilota valitut',
    'ui__mass-mail#to_text__title' => 'Vast.ott.',
    'ui__mass-mail#tools_legend__title' => 'Työkalut',
    'ui__mass-mail__already_exists' => 'Malli, jonka nimi on %1, on jo olemassa',
    'ui__mass-mail__none-available' => 'Sinulla ei ole viestimalleja.',

    'ui__mass-mail/delete__description' => 'Poista massasähköpostin malli %1',

    'ui__mass-mail/delete__empty_selection' => 'Valitse mallit, jotka haluat poistaa',
    'ui__mass-mail/delete__short-title' => 'Poista %1',
    'ui__mass-mail/delete__title' => 'Poista massasähköpostin malli %1',
    'ui__mass-mail/delete_multi__description' => 'Poista massasähköpostin mallit.',

    'ui__mass-mail/delete_multi__short-title' => 'Poista',
    'ui__mass-mail/delete_multi__title' => 'Poista massasähköpostin mallit',
    'ui__mass-mail/delete_multi__wizard-title' => 'Massasähköpostin mallien poisto',
    'ui__mass-mail/delete_multi__wizard__1_multi' => 'Valitse massasähköpostin mallit, jotka haluat poistaa.',
    'ui__mass-mail/delete_multi__wizard__2_multi' => 'Vahvista mallien poisto valitsemalla valintaruutu ja suorita ohjattu toiminto loppuun valitsemalla Valmis.',
    'ui__mass-mail/delete_unknown__description' => 'Poista massasähköpostin mallit.',
    'ui__mass-mail/delete_unknown__short-title' => 'Poista',
    'ui__mass-mail/delete_unknown__title' => 'Poista massasähköpostin mallit',
    'ui__mass-mail/delete_unknown__wizard-title' => 'Massasähköpostin mallien poisto.',
    'ui__mass-mail/delete_unknown__wizard__1_unknown' => 'Valitse massasähköpostin malli, jonka haluat poistaa.',
    'ui__mass-mail/delete_unknown__wizard__2' => 'Vahvista mallin poisto valitsemalla valintaruutu ja suorita ohjattu toiminto loppuun valitsemalla Valmis.',

    'ui__mass-mail/properties__description' => 'Muokkaa sähköpostiviestin mallia %1.',

    'ui__mass-mail/properties__invalid_values' => 'Määritetyt arvot ovat virheellisiä',
    'ui__mass-mail/properties__short-title' => '%1',
    'ui__mass-mail/properties__title' => 'Muokkaa sähköpostiviestin mallia %1',

    'ui__mass-mail/properties_new__wizard-title' => 'Luo massasähköpostiviestin malli',
    'ui__mass-mail/properties_unknown-new__description' => 'Luo sähköpostiviestin malli.',
    'ui__mass-mail/properties_unknown-new__short-title' => 'Lisää sähköpostiviestin malli',
    'ui__mass-mail/properties_unknown-new__title' => 'Luo sähköpostiviestin malli',
    'ui__mass-mail/properties_unknown__wizard-title' => 'Muokkaa massasähköpostiviestin mallia',
    'ui__mass-mail/properties_unknown__wizard__1_unknown' => 'Valitse malli, jota haluat muokata, ja valitse Seuraava >>.',
    'ui__mass-mail/properties_unknown__wizard__2' => 'Kun olet muokannut mallia, käytä muutoksia ja poistu toiminnosta napsauttamalla Lopeta.',

    'ui__mass-mail/send__invalid_values' => 'Määrittämäsi arvot ovat virheellisiä',

    'ui__mass-mail/send_new__wizard-title' => 'Luo viestimalli ja lähetä sähköposti',
    'ui__mass-mail/send_unknown-new__description' => 'Lähetä sähköpostiviesti valituille vastaanottajille',

    'ui__mass-mail/send_unknown-new__short-title' => 'Lähetä massasähköposti',
    'ui__mass-mail/send_unknown-new__title' => 'Lähetä massasähköpostiviesti',
    'ui__mass-mail/send_unknown__description' => 'Lähetä sähköpostiviesti valituille vastaanottajille',

    'ui__mass-mail/send_unknown__short-title' => 'Lähetä massasähköposti',
    'ui__mass-mail/send_unknown__title' => 'Lähetä massasähköpostiviesti',
    'ui__mass-mail/send_unknown__wizard-title' => 'Lähetä massasähköpostiviesti',
    'ui__mass-mail/send_unknown__wizard__1_unknown' => 'Valitse vaadittu malli ja napsauta Seuraava >>.',
    'ui__mass-mail/send_unknown__wizard__2' => 'Kun olet muokannut mallin ominaisuuksia, lähetä viesti ja poistu toiminnosta napsauttamalla Lopeta.',

    'ui__mass-email/delete__description' => 'Poista valitut massasähköpostin mallit.',

    'ui__mass-email/delete__empty_selection' => "Valitse poistettavat mallit.",
    'ui__mass-email/delete__short-title' => "Poista %1",
    'ui__mass-email/delete__title' => "Poista massasähköpostin malli %1",
    'ui__mass-email/delete_multi__description' => "Poista massasähköpostin mallit.",

    'ui__mass-email/delete_multi__short-title' => "Poista",
    'ui__mass-email/delete_multi__title' => "Poista massasähköpostin mallit",
    'ui__mass-email/delete_multi__wizard__mass-mail/delete_multi' => "Vahvista mallien poisto valitsemalla valintaruutu ja suorita ohjattu toiminto loppuun valitsemalla Valmis.",
    'ui__mass-email/delete_multi__wizard__mass-mail_multi' => "Valitse massasähköpostin mallit, jotka haluat poistaa.",
    'ui__mass-email/delete_multi__wizard-title' => "Massasähköpostin mallien poisto",
    'ui__mass-email/delete_unknown__description' => "Poista massasähköpostin mallit.",
    'ui__mass-email/delete_unknown__short-title' => "Poista",
    'ui__mass-email/delete_unknown__title' => "Poista massasähköpostin mallit",
    'ui__mass-email/delete_unknown__wizard__mass-mail/delete' => "Vahvista mallin poisto valitsemalla valintaruutu ja suorita ohjattu toiminto loppuun valitsemalla Valmis.",
    'ui__mass-email/delete_unknown__wizard__mass-mail_unknown' => "Valitse massasähköpostin malli, jonka haluat poistaa.",
    'ui__mass-email/delete_unknown__wizard-title' => "Massasähköpostin mallien poisto.",
    'ui__mass-email/send__description' => "Lähetä sähköpostiviesti valituille vastaanottajille",
    'ui__mass-email/send__short-title' => "Lähetä massasähköposti",
    'ui__mass-email/send__title' => "Lähetä massasähköpostiviesti",
    'ui__mass-email/send_main__description' => "Lähetä sähköpostiviesti valituille vastaanottajille",

    'ui__mass-email/send_main__short-title' => "Lähetä massasähköposti",
    'ui__mass-email/send_main__title' => "Lähetä massasähköpostiviesti",
    'ui__mass-email/send_selectresellers__title' => 'Valitse jälleenmyyjät',
    'ui__mass-email/send_selectresellers__short-title' => 'Jälleenmyyjät',
    'ui__mass-email/send_selectresellers__description' => 'Valitse jälleenmyyjän tilit',

    'ui__mass-email/send_selectclients__description' => "Valitse asiakastilit",

    'ui__mass-email/send_selectclients__short-title' => "Asiakkaat",
    'ui__mass-email/send_selectclients__title' => "Valitse asiakkaat",
    'ui__mass-email/send_selectdomainusers__description' => "Valitse toimialueen järjestelmänvalvojan tilit",

    'ui__mass-email/send_selectdomainusers__short-title' => "Toimialueen järjestelmänvalvojat",
    'ui__mass-email/send_selectdomainusers__title' => "Valitse toimialueen järjestelmänvalvojat",
    'ui__mass-email/template/properties_main__description' => "Luo massasähköpostiviestin malli",
    'ui__mass-email/template/properties_main__short-title' => "Muokkaa mallia",
    'ui__mass-email/template/properties_main__title' => "Muokkaa massasähköpostiviestin mallia",
    'ui__mass-email/template/properties_new-main__description' => "Luo malli massasähköpostiviestejä varten.",
    'ui__mass-email/template/properties_new-main__short-title' => "Luo massasähköpostiviestin malli",
    'ui__mass-email/template/properties_new-main__title' => "Luo massasähköpostiviestin malli",
    'ui__mass-email/template/properties_new-selectclients__description' => "Valitse asiakkaat, joille tähän malliin perustuvat massasähköpostiviestit tulisi lähettää",
    'ui__mass-email/template/properties_new-selectclients__title' => "Valitse asiakkaat, joille tähän malliin perustuvat massasähköpostiviestit tulisi lähettää",
    'ui__mass-email/template/properties_new-selectdomainusers__description' => "Valitse toimialueen järjestelmänvalvojat, joille tähän malliin perustuvat massasähköpostiviestit tulisi lähettää.",
    'ui__mass-email/template/properties_new-selectdomainusers__title' => "Valitse toimialueen järjestelmänvalvojat, joille tähän malliin perustuvat massasähköpostiviestit tulisi lähettää.",
    'ui__mass-email/template/properties_selectclients__title' => "Valitse asiakkaat, joille tähän malliin perustuvat massasähköpostiviestit tulisi lähettää",
    'ui__mass-email/template/properties_selectdomainusers__title' => "Valitse toimialueen järjestelmänvalvojat, joille tähän malliin perustuvat massasähköpostiviestit tulisi lähettää.",

    'ui__mass-email/template/properties_unknown-new__description' => "Luo massasähköpostiviestin malli",
    'ui__mass-email/template/properties_unknown-new__short-title' => "Luo malli",
    'ui__mass-email/template/properties_unknown-new__title' => "Massasähköpostiviestin mallin luonti",
    'ui__news/dismiss__description' => 'Sulje uutiskehys napsauttamalla. Plesk ei näytä tätä kehystä ennen kuin uutisartikkelit on päivitetty.',

    'ui__news/dismiss__title' => 'Sulje uutiset',

    'ui__server__description' => 'Palvelimen hallinta.',
    'ui__server__short-title' => 'Hallitse palvelinta',
    'ui__server__title' => 'Palvelimen hallinta',


    // UNUSED SINCE 9.2



    // END OF UNUSED SINCE 9.2

    'ui__server/ip-address__disabled-warning' => 'IP-osoite %1 ei ole käytettävissä.',
    'ui__server/ip-address__none-available' => 'IP-osoitteita ei ole.',
    'ui__server/ip-addresses/ip-address__title' => "IP-osoitteet",
    'ui__server/ip-address/client/properties_new__description' => "Määritä IP-osoite %1 jälleenmyyjille.",
    'ui__server/ip-address/client/properties_new__short-title' => 'Määritä',
    'ui__server/ip-address/client/properties_new__title' => "Määritä IP-osoite %1 jälleenmyyjille",
    'ui__server/ip-address/client__none-available' => 'Käyttäjätilejä ei ole',
    'ui__server/ip-address/client_unknown__quick_search' => 'Käyttäjät',
    'ui__server/ip-address/client_unknown__wizard-title' => 'Tätä IP-osoitetta käyttävien käyttäjien luettelo.',
    'ui__server/ip-address/client_unknown__wizard__3_unknown' => 'Valitse IP-osoite.',
    'ui__server/ip-address/client/delete__description' => 'Poista IP-osoitteen määritys jälleenmyyjältä.',
    'ui__server/ip-address/client/delete__short-title' => 'Poista määritys',
    'ui__server/ip-address/client/delete__title' => 'Poista IP-osoitteen määritys jälleenmyyjältä',
    'ui__server/ip-address/client/delete_multi__description' => "Poista IP-osoitteen määritys jälleenmyyjän ryhmistä.",

    'ui__server/ip-address/client/delete_multi__short-title' => 'Poista määritys',
    'ui__server/ip-address/client/delete_multi__title' => 'Poista IP-osoitteen määritys jälleenmyyjältä',
    'ui__server/ip-address/client/delete_multi__wizard-title' => "Poista IP-osoite käyttäjän ryhmistä.",
    'ui__server/ip-address/client/delete_multi__wizard__3_unknown' => 'Valitse IP-osoite, jonka määrityksen haluat poistaa käyttäjiltä, ja valitse Seuraava >>.',
    'ui__server/ip-address/client/delete_multi__wizard__3_multi' => 'Valitse käyttäjät, joiden IP-osoitteen määrityksen haluat poistaa, ja valitse Seuraava >>.',
    'ui__server/ip-address/client/delete_multi__wizard__4_multi' => 'Vahvista IP-osoitteen määrityksen poisto käyttäjiltä valitsemalla valintaruutu ja suorita ohjattu toiminto loppuun valitsemalla Valmis.',
    'ui__server/ip-address/client/delete_unknown__description' => 'Poista IP-osoitteen määritys jälleenmyyjiltä.',
    'ui__server/ip-address/client/delete_unknown__short-title' => 'Poista määritys',
    'ui__server/ip-address/client/delete_unknown__title' => 'Poista IP-osoitteen määritys jälleenmyyjiltä',
    'ui__server/ip-address/client/delete_unknown__wizard-title' => 'Poista IP-osoitteen määritys käyttäjiltä',
    'ui__server/ip-address/client/delete_unknown__wizard__3_unknown' => 'Valitse IP-osoite, jonka määrityksen haluat poistaa käyttäjiltä, ja valitse Seuraava >>.',
    'ui__server/ip-address/client/delete_unknown__wizard__4_unknown' => 'Valitse käyttäjä, jonka IP-osoitteen määrityksen haluat poistaa, ja valitse Seuraava >>.',
    'ui__server/ip-address/client/delete_unknown__wizard__5' => 'Vahvista IP-osoitteen määrityksen poisto käyttäjiltä valitsemalla valintaruutu ja suorita ohjattu toiminto loppuun valitsemalla Valmis.',

    'ui__server/ip-address/domain__description' => "Kaikki IP-osoitteen %1 toimialueet.",
    'ui__server/ip-address/domain__short-title' => "Toimialueet",
    'ui__server/ip-address/domain__title' => "IP-osoitteen %1 toimialueet",
    'ui__server/ip-address/domain_unknown__description' => "Kaikki IP-osoitteen toimialueet.",
    'ui__server/ip-address/domain_unknown__short-title' => "Toimialueet",
    'ui__server/ip-address/domain_unknown__title' => "IP-osoitteen toimialueet",
    'ui__server/ip-address/domain_unknown__wizard__3_unknown' => "Valitse tarvitsemasi IP-osoite ja valitse Seuraava >>.",

    'ui__server/ip-address/properties__description' => 'Muuta IP-osoitteen ominaisuuksia %1.',
    'ui__server/ip-address/properties__short-title' => 'Ominaisuudet...',
    'ui__server/ip-address/properties__title' => 'Muokkaa IP-osoitteen %1 ominaisuuksia.',

    'ui__server/ip-address/properties_new__wizard-title' => 'Lisää IP-osoite',
    'ui__server/ip-address/properties_new__wizard__4_new' => 'Kun olet muuttanut IP-osoitteen ominaisuudet, ota muutokset käyttöön valitsemalla Valmis.',
    'ui__server/ip-address/properties_unknown__description' => 'Muuta IP-osoitteen ominaisuuksia.',
    'ui__server/ip-address/properties_unknown__short-title' => 'Ominaisuudet...',
    'ui__server/ip-address/properties_unknown__title' => 'Muuta IP-osoitteen ominaisuuksia',
    'ui__server/ip-address/properties_unknown__wizard-title' => 'Muuta IP-osoitteen ominaisuuksia',
    'ui__server/ip-address/properties_unknown__wizard__3_unknown' => 'Valitse IP-osoite, jonka ominaisuuksia haluat muuttaa.',
    'ui__server/ip-address/properties_unknown__wizard__4' => 'Kun olet muuttanut IP-osoitteen ominaisuudet, ota muutokset käyttöön valitsemalla Valmis.',

    'ui__server/spam-filter/black-list__description' => 'Aseta musta lista palvelimen laajuiselle roskapostisuodattimelle.',
    'ui__server/spam-filter/black-list__short-title' => 'Musta lista',
    'ui__server/spam-filter/black-list__title' => 'Musta lista palvelimen laajuiselle roskapostisuodattimelle',

    'ui__server/spam-filter/black-list/address__addresses_available' => 'Vain %1 ensimmäistä yksilöllistä sähköpostiosoitetta lisätään.',
    'ui__server/spam-filter/black-list/address__description' => 'Roskapostisuodattimen mustan listan osoite.',

    'ui__server/spam-filter/black-list/address__empty_content' => 'Listalla ei ole sähköpostiosoitteita.',
    'ui__server/spam-filter/black-list/address__file_size' => 'Ladattu tiedosto on tyhjä.',
    'ui__server/spam-filter/black-list/address__invalid_addresses' => 'Seuraavat sähköpostiosoitteet eivät kelpaa: %1.',
    'ui__server/spam-filter/black-list/address__none-available' => 'Roskapostisuodattimen mustalla listalla ei ole osoitteita.',
    'ui__server/spam-filter/black-list/address__short-title' => 'Osoite',
    'ui__server/spam-filter/black-list/address__title' => 'Mustan listan osoite %1',
    'ui__server/spam-filter/black-list/address_unknown__description' => 'Lisää osoitteet mustalle listalle.',
    'ui__server/spam-filter/black-list/address_unknown__short-title' => 'Lisää osoitteet',
    'ui__server/spam-filter/black-list/address_unknown__title' => 'Lisää osoitteet mustalle listalle',

    'ui__server/spam-filter/black-list/address/delete__description' => 'Poista %1 osoite palvelimen laajuiselta mustalta listalta.',

    'ui__server/spam-filter/black-list/address/delete__short-title' => 'Poista',
    'ui__server/spam-filter/black-list/address/delete__title' => 'Poista %1 osoite palvelimen laajuiselta mustalta listalta',
    'ui__server/spam-filter/black-list/address/delete_multi__description' => 'Poista osoitteet palvelimen laajuiselta mustalta listalta.',

    'ui__server/spam-filter/black-list/address/delete_multi__short-title' => 'Poista',
    'ui__server/spam-filter/black-list/address/delete_multi__title' => 'Poista osoitteet palvelimen laajuiselta mustalta listalta',
    'ui__server/spam-filter/black-list/address/delete_multi__wizard-title' => 'Osoitteiden poisto palvelimenlaajuiselta roskapostisuodattimen mustalta listalta',
    'ui__server/spam-filter/black-list/address/delete_multi__wizard__4_multi' => 'Valitse roskapostisuodattimen osoitteet, jotka haluat poistaa ja valitse Seuraava >>',
    'ui__server/spam-filter/black-list/address/delete_multi__wizard__5_multi' => 'Vahvista roskapostisuodattimen osoitteiden poisto valitsemalla valintaruutu, poista osoitteet kokonaan valitsemalla Valmis ja poistu ohjatusta toiminnosta.',
    'ui__server/spam-filter/black-list/address/delete_unknown__description' => 'Poista osoite palvelimen laajuiselta mustalta listalta.',
    'ui__server/spam-filter/black-list/address/delete_unknown__short-title' => 'Poista',
    'ui__server/spam-filter/black-list/address/delete_unknown__title' => 'Poista osoite palvelimen laajuiselta mustalta listalta',
    'ui__server/spam-filter/black-list/address/delete_unknown__wizard-title' => 'Osoitteiden poisto palvelimenlaajuiselta roskapostisuodattimen mustalta listalta',
    'ui__server/spam-filter/black-list/address/delete_unknown__wizard__4_unknown' => 'Valitse roskapostisuodattimen osoite, jonka haluat poistaa, ja valitse Seuraava >>',
    'ui__server/spam-filter/black-list/address/delete_unknown__wizard__5' => 'Vahvista roskapostisuodattimen osoitteen poisto valitsemalla valintaruutu, poista osoite kokonaan valitsemalla Valmis ja poistu ohjatusta toiminnosta.',

    'ui__server/spam-filter/black-list/address/properties__addresses_available' => 'Vain %1 ensimmäistä yksilöllistä sähköpostiosoitetta lisätään.',
    'ui__server/spam-filter/black-list/address/properties__empty_content' => 'Listalla ei ole sähköpostiosoitteita.',
    'ui__server/spam-filter/black-list/address/properties__file_size' => 'Tiedostoja ei voida ladata. Ladattavan tiedoston maksimikoko on %1.',
    'ui__server/spam-filter/black-list/address/properties__invalid_addresses' => 'Seuraavat sähköpostiosoitteet eivät kelpaa: %1.',

    'ui__server/spam-filter/black-list/address/properties_unknown-new__description' => 'Lisää osoitteet mustalle listalle.',
    'ui__server/spam-filter/black-list/address/properties_unknown-new__short-title' => 'Lisää osoitteet',
    'ui__server/spam-filter/black-list/address/properties_unknown-new__title' => 'Lisää osoitteet mustalle listalle',

    'ui__server/spam-filter/properties__description' => 'Aseta palvelimenlaajuinen roskapostisuodatin.',

    'ui__server/spam-filter/properties__short-title' => 'Asetukset',
    'ui__server/spam-filter/properties__title' => 'Roskapostisuodattimen asetukset',

    'ui__server/spam-filter/toggle_disable__description' => 'Poista koko järjestelmän roskapostisuodatus käytöstä.',

    'ui__server/spam-filter/toggle_disable__short-title' => 'Poista käytöstä',
    'ui__server/spam-filter/toggle_disable__title' => 'Poista roskapostisuodatus käytöstä',
    'ui__server/spam-filter/toggle_enable__description' => 'Ota käyttöön koko palvelimen roskapostisuodatus.',

    'ui__server/spam-filter/toggle_enable__short-title' => 'Ota käyttöön',
    'ui__server/spam-filter/toggle_enable__title' => 'Ota roskapostisuodatus käyttöön',
    'ui__server/spam-filter/toggle_unknown__description' => 'Ota käyttöön tai poista käytöstä koko palvelimen roskapostisuodatus.',
    'ui__server/spam-filter/toggle_unknown__short-title' => 'Ota käyttöön / poista käytöstä',
    'ui__server/spam-filter/toggle_unknown__title' => 'Ota käyttöön tai poista käytöstä roskapostisuodatus',
    'ui__server/spam-filter/toggle_unknown__wizard-title' => 'Ota käyttöön tai poista käytöstä roskapostisuodatin',

    'ui__server/spam-filter/white-list__description' => 'Aseta järjestelmän laajuinen roskapostisuodattimen sallitut lista.',
    'ui__server/spam-filter/white-list__short-title' => 'Valkoinen lista',
    'ui__server/spam-filter/white-list__title' => 'Järjestelmän laajuinen roskapostisuodattimen sallitut lista',

    'ui__server/spam-filter/white-list/address__addresses_available' => 'Vain %1 ensimmäistä yksilöllistä sähköpostiosoitetta lisätään.',
    'ui__server/spam-filter/white-list/address__description' => 'Roskapostisuodattimen sallittujen listan osoite.',

    'ui__server/spam-filter/white-list/address__empty_content' => 'Listalla ei ole sähköpostiosoitteita.',
    'ui__server/spam-filter/white-list/address__file_size' => 'Ladattu tiedosto on tyhjä.',
    'ui__server/spam-filter/white-list/address__invalid_addresses' => 'Seuraavat sähköpostiosoitteet eivät kelpaa: %1.',
    'ui__server/spam-filter/white-list/address__none-available' => 'Roskapostisuodattimen palvelimen laajuisella sallittujen listalla ei ole osoitteita.',
    'ui__server/spam-filter/white-list/address__short-title' => 'Osoite',
    'ui__server/spam-filter/white-list/address__title' => 'Sallittujen listan osoite %1',
    'ui__server/spam-filter/white-list/address_unknown__description' => 'Lisää osoitteet valkoiselle listalle.',
    'ui__server/spam-filter/white-list/address_unknown__short-title' => 'Lisää osoitteet',
    'ui__server/spam-filter/white-list/address_unknown__title' => 'Lisää osoitteet valkoiselle listalle',

    'ui__server/spam-filter/white-list/address/delete__description' => 'Poista %1 osoite palvelimen laajuiselta sallittujen listalta.',

    'ui__server/spam-filter/white-list/address/delete__short-title' => 'Poista',
    'ui__server/spam-filter/white-list/address/delete__title' => 'Poista %1 osoite palvelimen laajuiselta sallittujen listalta',
    'ui__server/spam-filter/white-list/address/delete_multi__description' => 'Poista osoitteet palvelimen laajuiselta sallittujen listalta.',

    'ui__server/spam-filter/white-list/address/delete_multi__short-title' => 'Poista',
    'ui__server/spam-filter/white-list/address/delete_multi__title' => 'Poista osoitteet palvelimen laajuiselta sallittujen listalta',
    'ui__server/spam-filter/white-list/address/delete_multi__wizard-title' => 'Osoitteiden poisto palvelimenlaajuiselta roskapostisuodattimen valkoiselta listalta',
    'ui__server/spam-filter/white-list/address/delete_multi__wizard__4_multi' => 'Valitse roskapostisuodattimen osoitteet, jotka haluat poistaa ja valitse Seuraava >>',
    'ui__server/spam-filter/white-list/address/delete_multi__wizard__5_multi' => 'Vahvista roskapostisuodattimen osoitteiden poisto valitsemalla valintaruutu, poista osoitteet kokonaan valitsemalla Valmis ja poistu ohjatusta toiminnosta.',
    'ui__server/spam-filter/white-list/address/delete_unknown__description' => 'Poista osoite palvelimen laajuiselta sallittujen listalta.',
    'ui__server/spam-filter/white-list/address/delete_unknown__short-title' => 'Poista',
    'ui__server/spam-filter/white-list/address/delete_unknown__title' => 'Poista osoite palvelimen laajuiselta sallittujen listalta',
    'ui__server/spam-filter/white-list/address/delete_unknown__wizard-title' => 'Osoitteiden poisto palvelimenlaajuiselta roskapostisuodattimen valkoiselta listalta',
    'ui__server/spam-filter/white-list/address/delete_unknown__wizard__4_unknown' => 'Valitse roskapostisuodattimen osoite, jonka haluat poistaa, ja valitse Seuraava >>',
    'ui__server/spam-filter/white-list/address/delete_unknown__wizard__5' => 'Vahvista roskapostisuodattimen osoitteen poisto valitsemalla valintaruutu, poista osoite kokonaan valitsemalla Valmis ja poistu ohjatusta toiminnosta.',

    'ui__server/spam-filter/white-list/address/properties__addresses_available' => 'Vain %1 ensimmäistä yksilöllistä sähköpostiosoitetta lisätään.',
    'ui__server/spam-filter/white-list/address/properties__empty_content' => 'Listalla ei ole sähköpostiosoitteita.',
    'ui__server/spam-filter/white-list/address/properties__file_size' => 'Tiedostoja ei voida ladata. Ladattavan tiedoston maksimikoko on %1.',
    'ui__server/spam-filter/white-list/address/properties__invalid_addresses' => 'Seuraavat sähköpostiosoitteet eivät kelpaa: %1.',

    'ui__server/spam-filter/white-list/address/properties_unknown-new__description' => 'Lisää osoitteet valkoiselle listalle.',
    'ui__server/spam-filter/white-list/address/properties_unknown-new__short-title' => 'Lisää osoitteet',
    'ui__server/spam-filter/white-list/address/properties_unknown-new__title' => 'Lisää osoitteet valkoiselle listalle',

    'ui__server/mail/statistics#apply__description' => "Käytä suodatinta",
    'ui__server/mail/statistics#apply__title' => "Käytä",
    'ui__server/mail/statistics#custom_from__title' => "lähettäjä",
    'ui__server/mail/statistics#custom_to__title' => "saakka",
    'ui__server/mail/statistics#period_all__title' => "Kaikki",
    'ui__server/mail/statistics#period_custom__title' => "Mukautettu",
    'ui__server/mail/statistics#period_month__title' => "Kuluva kuukausi",
    'ui__server/mail/statistics#period_prev_month__title' => "Edellinen kuukausi",
    'ui__server/mail/statistics#period_prev_week__title' => "Edellinen viikko",
    'ui__server/mail/statistics#period_today__title' => "Tänään",
    'ui__server/mail/statistics#period_week__title' => "Nykyinen viikko",
    'ui__server/mail/statistics#period_yesterday__title' => "Eilen",
    'ui__server/mail/statistics#show_for_period__title' => "Näytä aikajaksoon",
    'ui__server/mail/statistics#tools_legend__title' => "Työkalut",
    'ui__server/mail/statistics__description' => "Näytä roskapostin ja viruksien tilastotiedot",

    'ui__server/mail/statistics__short-title' => "Tilastot",
    'ui__server/mail/statistics__title' => "Postiasetukset",
    'ui__server/mail/statistics/spam#statistics_legend__title' => "Roskapostitilastot",
    'ui__server/mail/statistics/spam#tools_legend__title' => "Työkalut",
    'ui__server/mail/statistics/spam__description' => "Näytä roskapostitilastot",

    'ui__server/mail/statistics/spam__short-title' => "Roskapostitilastot",
    'ui__server/mail/statistics/spam__title' => "Roskapostitilastot",
    'ui__server/mail/statistics/spam/recipients#list_header__name__title' => "Postin nimi",
    'ui__server/mail/statistics/spam/recipients#list_header__ratio__title' => "% kaikista",
    'ui__server/mail/statistics/spam/recipients#list_header__sort_by_name__title' => "Lajittele sähköpostitilin mukaan",
    'ui__server/mail/statistics/spam/recipients#list_header__sort_by_ratio__title' => "Lajittele kaikkien % mukaan",
    'ui__server/mail/statistics/spam/recipients#list_header__sort_by_val__title' => "Lajittele vastaanotetun roskapostin mukaan",
    'ui__server/mail/statistics/spam/recipients#list_header__title' => "sähköpostitilit",
    'ui__server/mail/statistics/spam/recipients#list_header__val__title' => "Vastaanotettu roskaposti",
    'ui__server/mail/statistics/spam/recipients__description' => "Vastaanottajat",

    'ui__server/mail/statistics/spam/recipients__short-title' => "Vastaanottajat",
    'ui__server/mail/statistics/spam/recipients__title' => "Vastaanottajat",
    'ui__server/mail/statistics/spam/summary#clean__title' => "Puhdista",
    'ui__server/mail/statistics/spam/summary#infected__title' => "Sisältää viruksen",
    'ui__server/mail/statistics/spam/summary#list_header__name__title' => "Tila",
    'ui__server/mail/statistics/spam/summary#list_header__ratio__title' => "% kaikista",
    'ui__server/mail/statistics/spam/summary#list_header__val__title' => "Määrä",
    'ui__server/mail/statistics/spam/summary#protected__title' => "Suojattu",
    'ui__server/mail/statistics/spam/summary#skipped__title' => "Ei valittu",
    'ui__server/mail/statistics/spam/summary__description' => "Yhteenveto",

    'ui__server/mail/statistics/spam/summary__short-title' => "Yhteenveto",
    'ui__server/mail/statistics/spam/summary__title' => "Yhteenveto",
    'ui__server/mail/statistics/virus#statistics_legend__title' => "Virustilastot",
    'ui__server/mail/statistics/virus#tools_legend__title' => "Työkalut",
    'ui__server/mail/statistics/virus__description' => "Näytä virustilastot",

    'ui__server/mail/statistics/virus__short-title' => "Virustilastot",
    'ui__server/mail/statistics/virus__title' => "Virustilastot",
    'ui__server/mail/statistics/virus/recipients#list_header__name__title' => "Sähköpostitili",
    'ui__server/mail/statistics/virus/recipients#list_header__ratio__title' => "% kaikista",
    'ui__server/mail/statistics/virus/recipients#list_header__sort_by_name__title' => "Lajittele postin nimen mukaan",
    'ui__server/mail/statistics/virus/recipients#list_header__sort_by_ratio__title' => "Lajittele kaikkien % mukaan",
    'ui__server/mail/statistics/virus/recipients#list_header__sort_by_val__title' => "Lajittele vastaanotettujen viruksien mukaan",
    'ui__server/mail/statistics/virus/recipients#list_header__title' => "Sähköpostitilit",
    'ui__server/mail/statistics/virus/recipients#list_header__val__title' => "Vastaanotetut virukset",
    'ui__server/mail/statistics/virus/recipients__description' => "Vastaanottajat",

    'ui__server/mail/statistics/virus/recipients__short-title' => "Vastaanottajat",
    'ui__server/mail/statistics/virus/recipients__title' => "Vastaanottajat",
    'ui__server/mail/statistics/virus/summary#clean__title' => "Puhdista",
    'ui__server/mail/statistics/virus/summary#infected__title' => "Sisältää viruksen",
    'ui__server/mail/statistics/virus/summary#list_header__name__title' => "Tila",
    'ui__server/mail/statistics/virus/summary#list_header__ratio__title' => "% kaikista",
    'ui__server/mail/statistics/virus/summary#list_header__val__title' => "Määrä",
    'ui__server/mail/statistics/virus/summary#protected__title' => "Suojattu",
    'ui__server/mail/statistics/virus/summary#skipped__title' => "Ei valittu",
    'ui__server/mail/statistics/virus/summary__description' => "Yhteenveto",

    'ui__server/mail/statistics/virus/summary__short-title' => "Yhteenveto",
    'ui__server/mail/statistics/virus/summary__title' => "Yhteenveto",
    'ui__server/mail/statistics/virus/viruses#list_header__name__title' => "Nimi",
    'ui__server/mail/statistics/virus/viruses#list_header__ratio__title' => "% kaikista",
    'ui__server/mail/statistics/virus/viruses#list_header__sort_by_name__title' => "Lajittele nimen mukaan",
    'ui__server/mail/statistics/virus/viruses#list_header__sort_by_ratio__title' => "Lajittele kaikkien % mukaan",
    'ui__server/mail/statistics/virus/viruses#list_header__sort_by_val__title' => "Lajittele viruksen saaneiden kohteiden mukaan",
    'ui__server/mail/statistics/virus/viruses#list_header__title' => "Virukset",
    'ui__server/mail/statistics/virus/viruses#list_header__val__title' => "Viruksen saaneet kohteet",
    'ui__server/mail/statistics/virus/viruses__description' => "Virukset",

    'ui__server/mail/statistics/virus/viruses__short-title' => "Virukset",
    'ui__server/mail/statistics/virus/viruses__title' => "Virukset",

    'ui__support#param_company__title' => "Yritys",
    'ui__support#param_email__title' => "Sähköposti",
    'ui__support#param_firstname__title' => "Etunimi",
    'ui__support#param_keynumber__title' => "Tuotetunnusnumero",
    'ui__support#param_operatingsystem__title' => "Käyttöjärjestelmä",
    'ui__support#param_phone__title' => "Puhelin",
    'ui__support#param_psabuild__title' => "Plesk-versio",
    'ui__support#param_psainsttype__title' => "Plesk -asennustyyppi",
    'ui__support#param_psaversion__title' => "Plesk-versio",

    // *** The strings above have been generated automatically from @@CAPTION directives.

    ////
    //// UI POINTER CAPTIONS END HERE


    // RESELLERS

    // Resellers
    'ui__reseller#tools__title' => "Työkalut",

    'ui__reseller/traffic-history_unknown__short-title' => "Näytä liikenne jälleenmyyjien mukaan",
    'ui__reseller/traffic-history_unknown__title' => "Näytä liikenne jälleenmyyjien mukaan",
    'ui__reseller/traffic-history_unknown__description' => "Näytä liikenne jälleenmyyjätilien mukaan.",
    'ui__reseller#list__title' => "Jälleenmyyjät",
    'accounts_list__name__filter_title' => "Nimi",
    'accounts_list__resource__filter_title' => "Resurssien käyttö",
    'resellers_list__filter_resource_usage_any' => "Mikä tahansa",
    'resellers_list__filter_resource_usage_overuse' => "Liikakäyttö",
    'resellers_list__filter_resource_usage_normal' => "Rajojen sisällä",
    'accounts_list__status__filter_title' => "Tila",
    'resellers_list__filter_status_any' => "Mikä tahansa",
    'resellers_list__filter_status_blocked' => "Keskeytetty",
    'resellers_list__filter_status_active' => "Akt.",
    'resellers_list__filter_clients__filter_title' => "Näytä",
    'resellers_list__filter_clients_on' => "Jälleenmyyjät ja heidän asiakkaansa",
    'resellers_list__filter_clients_off' => "Vain jälleenmyyjät",
    '__disk_usage' => "Käytetty levytila",
    'ui__reseller/traffic_unknown__short-title' => "Näytä liikenne jälleenmyyjien mukaan",
    'ui__reseller/traffic_unknown__title' => "Näytä liikenne jälleenmyyjien mukaan",
    'ui__reseller/traffic#list__title' => "Liikenne jälleenmyyjän mukaan",
    'ui__reseller/traffic_unknown__description' => "Näytä liikenteen käyttöraportit.",

    // Resellers > Traffic by resellers
    '__traffic_by_reseller' => "Liikenne jälleenmyyjän mukaan",

    '__reseller_name' => "Jälleenmyyjän nimi",
    '__reseller' => "Jälleenmyyjät",
    'resellertrafficlist_header' => "Näytä liikenne jälleenmyyjien mukaan",
    '__reseller_personal' => "Jälleenmyyjän toimialueiden käyttämä liikenne",
    'ui__reseller/traffic-history__short-title' => "Liikenne jälleenmyyjien mukaan",
    'ui__reseller/traffic-history__title' => "Liikenne jälleenmyyjien mukaan",
    'ui__reseller/traffic-history__description' => "Näytä liikenteen käyttöraportit.",

    // Resellers > Create Reseller Account
    'ui__reseller__short-title' => "%1",

    // Resellers > Reseller preferences

    // Resellers > Reseller Account Templates

    // Resellers > Reseller Account Templates > Create Reseller Account Template
    'limits__oversell_text' => "Salli ylimyynti",
    'limits__reseller_oversell_description' => "Ylimyynti sallii jälleenmyyjän myydä enemmän resursseja kuin hänelle tosiasiassa on varattu. Jos ylimyynti on sallittu, jälleenmyyjän laskutus määräytyy tosiasiallisen resurssien käytön mukaan alkuperäisen resurssien varauksen sijaan.",
    'limits__overuse_block_text' => "Liikakäyttökäytäntö",
    'limits__overuse_block_true_text' => "Ylikäyttö ei ole sallittu",
    'limits__reseller_overuse_block_true_description' => "Estä resurssien ylikäyttö. Nykyinen resurssien käyttö ei voi ylittää alkuperäistä resurssien varausta",
    'limits__overuse_block_false_text' => "Ylikäyttö on sallittu",
    'limits__reseller_overuse_block_false_description' => "Älä estä resurssien ylikäyttöä. Ylikäyttö antaa jälleenmyyjälle mahdollisuuden käyttää enemmän resursseja kuin alunperin on määritetty. Nykyinen resurssien käyttö voi ylittää alkuperäisen resurssien varauksen",
    'limits__reseller_overuse_notify_text' => "Ilmoita jälleenmyyjälle resurssien ylärajan saavuttamisesta",
    'reseller_perm__manage_sh_access_disabled' => "Jälleenmyyjä ei voi sallia tai kieltää liittymän käyttöä",
    'reseller_perm__manage_sh_access_chrooted' => "Jälleenmyyjä voi sallia vain chrooted-ympäristön käytön",
    'reseller_perm__manage_sh_access_any' => "Jälleenmyyjä voi sallia kaikentyyppisten liittymien käytön",
    'template__reseller_num_excl_ips' => "Kohdista varatut IP-osoitteet jälleenmyyjälle",

    // Reseller's Home page
    'client_chown__no_clients_selected' => 'Valitse asiakastilit, joille haluat määrittää uuden käyttäjän.',
    'ui__reseller#tools2__title' => "Tili",
    'ui__reseller#info__title' => "Tiedot",
    'ui__reseller#clientsTab__title' => "Asiakkaat",
    'ui__reseller#domainsTab__title' => "Toimialueet",
    'ui__reseller__title' => "Hallitse kohteen %1 jälleenmyyjätiliä",
    'domains__reseller_info' => "%1 asiakasta, %2 toimialuetta, %3 käytetystä levytilasta, %4 siirretyistä tiedoista.",
    'domains__reseller_info_hiding_traffic' => "%1 asiakasta, %2 toimialuetta, %3 käytetystä levytilasta.",
    'ui__reseller__description' => "Hallitse jälleenmyyjätiliä.",

    'ui__reseller/limits_unknown__wizard-title' => 'Tarkastele tai muuta jälleenmyyjän resurssirajoja',
    'ui__reseller/limits_unknown__wizard__1_unknown' => 'Valitse tarvitsemasi jälleenmyyjä.',
    'ui__reseller/limits_unknown__wizard__2' => 'Ota muutokset käyttöön valitsemalla Valmis.',

    'ui__client/report_reseller__short-title' => "Raportti",
    'ui__client/report_reseller__title' => "Näytä tiliraportti",
    'ui__client/report_reseller__description' => "Näytä jälleenmyyjätilin raportti.",
    'ui__client/ip-pool_reseller__short-title' => "IP-ryhmä",
    'ui__client/ip-pool_reseller__description' => "Määritä IP-osoitteet ja SSL/TLS-varmenteet jälleenmyyjätilille.",

    //'ui__client/preferences_reseller__short-title' => "Settings",
    //'ui__client/preferences_reseller__description' => "Set Plesk session settings.",

    'ui__reseller/preferences_unknown__wizard__2_self' => "Määritä tilin asetukset ja valitse Valmis.",

    //'ui__client/permissions_reseller__short-title' => "Permissions",
    //'ui__client/permissions_reseller__description' => "View or change permissions for the reseller's account.",

    'ui__reseller/permissions_unknown__wizard-title' => 'Tarkastele tai muuta jälleenmyyjän oikeuksia',
    'ui__reseller/permissions_unknown__wizard__1_unknown' => 'Valitse jälleenmyyjä, jonka oikeuksia haluat tarkastella tai muuttaa.',
    //'ui__reseller/permissions_unknown__wizard__1/properties_self' => 'When done with viewing your permissions, click Finish to to apply the changes and exit the wizard.',
    'ui__reseller/permissions_unknown__wizard__2' => 'Kun olet muuttanut jälleenmyyjän oikeudet, ota muutokset käyttöön valitsemalla Valmis ja poistu ohjatusta toiminnosta.',

    // Customers > create customer account

    '__resellers_list' => 'Jälleenmyyjät',
    'picker_reseller__title' => 'Valitse jälleenmyyjä',

    // Resellers > reseller name > customer name
    'ui__client#tools1__title' => "Työkalut",
    'ui__client#tools2__title' => "Tili",
    'ui__client#info__title' => "Tiedot",
    'ui__client#clientslist__title' => "Asiakkaat",
    'ui__client#domainslist__title' => "Toimialueet",

    // Reseller's session in the Customer Panel - Home page

    'feature__aps_categories__reseller' => "Kaikki verkkosovellukset lajitellaan nyt luokkien mukaan. Tämä helpottaa halutun asennettavan sovelluksen valintaa.",
    'feature__domainkeys__reseller' => "Voit käyttää DKIM sähköpostinlähettäjän todennusmekanismia, kun haluat vähentää roskapostin ja tietokalasteluviestien määrää.",

    '__reseller_form' => "Jälleenmyyjän lomake",

    // Reseller's session in the control panel - Home page > Manage Customer Settings
    'ui__client/preferences_unknown__wizard__reseller' => "Valitse asiakastili, jonka asetuksia haluat muuttaa.",

    // Reseller's session in the control panel - Home page > Suspend/Activate Customer Account

    // Reseller's session in the control panel - Home page > Change Customer Limits
    'ui__client/limits_unknown__wizard__1' => "Muuta resurssien käyttörajaa valitsemalla Resurssirajat.",

    // Reseller's session in the control panel - Home page > Change Customer Permissions
    'ui__client/permissions_unknown__wizard__1' => "Vaihtaaksesi toimintojen oikeuksia, jotka asiakas voi suorittaa Pleskissa, valitse Oikeudet.",

    // Reseller's session in the control panel - Home page > Create Domain
    'ui__client/domain/properties_new__wizard__reseller' => "Kun haluat luoda toimialueen, joka kuuluu omaan tiliisi, valitse Luo toimialue. Kun haluat luoda toimialueen jollekin asiakkaistasi, valitse halutun asiakkaan nimi ja valitse sitten Luo toimialue.",

    // Reseller's session in the control panel - Home page > Create Customer Template
    'template__shared_text' => "Aseta tämä malli muiden käyttäjien käytettäväksi",
    'template__shared_description' => "Valitse tämä vaihtoehto, jos haluat asiakkaidesi pystyvän käyttämään tätä mallia.",

    // CLIENT (updated for reseller feature):

    // Customers
    'ui__client#tools__title' => 'Työkalut',

    'ui__client/traffic-history_unknown__short-title' => 'Näytä liikenne asiakkaiden mukaan',
    'ui__client/traffic-history_unknown__title' => 'Liikenne asiakkaiden mukaan',
    'ui__client/traffic-history_unknown__description' => 'Näytä kaikkien asiakkaiden liikenteen kuormitusraportti',
    'ui__client/traffic-history__short-title' => 'Liikenne asiakkaiden mukaan',
    'ui__client/traffic-history__title' => 'Näytä liikenne asiakkaiden mukaan',
    'ui__client/traffic-history__description' => 'Näytä kaikkien asiakkaiden liikenteen kuormitusraportti',

    'ui__client/traffic#list__title' => 'Liikenne asiakkaiden mukaan',
    'ui__reseller/client/traffic#list__title' => 'Liikenne asiakkaiden mukaan',

    'clients_list__filter_type__filter_title' => 'Näytä',
    'clients_list__filter_type_any' => 'Asiakkaat ja jälleenmyyjät',
    'clients_list__filter_type_clients' => 'Vain asiakkaat',
    'clients_list__filter_type_resellers' => 'Vain jälleenmyyjät',
    'ui__client/domain_unknown-new__short-title' => "Luo arvoalue",

    // Customers > View traffic by customers
    '__personal' => "Käyttäjän toimialueiden käyttämä liikenne",
    'PersonalTrafficList_header_of_client__' => "Näytä tilisi liikenteen kuormitusraportti",

    // DOMAINS

    // Domain > Domain Admin Permissions

    'domain_perm__manage_sh_access_disabled' => "Toimialueen järjestelmänvalvoja ei voi sallia tai kieltää liittymän käyttöä",
    'domain_perm__manage_sh_access_chrooted' => "Toimialueen järjestelmänvalvoja voi sallia vain chrooted-ympäristön käytön",
    'domain_perm__manage_sh_access_any' => "Toimialueen järjestelmänvalvoja voi sallia kaikentyyppisten liittymien käytön",

    // APS Catalog
    'bt_add_to_vault' => "Lisää säilöön",
    'bt_hide_updates' => "Piilota käytettävissä olevat päivitykset",
    'bt_show_updates' => "Näytä saatavilla olevat päivitykset",

    '__site_apps__applications' => "Sovellukset",
    //search elements
    // Application; Vendor; Packager; Certification level;

    '__site_apps__apps_selected_to_add_to_vault' => "Säilöön lisättävien sovellusten määrä",
    'site_apps__application_selected' => "Valittu",
    'site_apps__currently_in_vault' => "Säilössä jo olevat muut versiot:",
    'site_apps__new_versions' => "Uudet versiot:",
    'site_apps__patches' => "Korjaustiedostot:",
    'site_apps__applications_have_been_scheduled_for_adding_to_application_vault' => "Säilöön lisättävien ajoitettujen sovellusten määrä: %1",
    'site_apps__applications_downloading_now' => "Seuraavat sovellukset ladataan: %1", // temporary workaround string, to be removed later

    'site_apps__package_already_exist_in_vault' => "Jo säilössä",

    // Server > Action Log
    'bt_skin_edit' => "Muokkaa ulkoasun kuvausta",
    'domains__you_want_change_the_status_of_the_reseller??' => "Haluatko varmasti muuttaa jälleenmyyjätilin tilan?",
    'limits__oversell_legend' => "Ylimyynti",
    'limitsManager__limit_available_error' => "Tarvittavaa resurssimäärää (%%quantity%% %%limitName%%) ei voi varata. Vain %%available%% %%limitName%% on saatavilla.",
    'limitsManager__limit_reserved_error' => "Vaadittua resurssin käyttörajaa ei voida asettaa (%%quantity%% %%limitName%%), koska uusi arvo on asiakkaillesi varattuja tai käyttämiäsi resursseja pienempi (%%reserved%% %%limitName%%).",
    'limitsManager__limit_used_error' => "Tarvittavaa resurssien käyttörajaa (%%quantity%% %%limitName%%) ei voi asettaa, koska uusi arvo on pienempi kuin nykyinen resurssimäärä, joka on jo tilisi ja sivustojesi käytössä (%%used%% %%limitName%%).",

    'ui__client/domain/traffic#list__title' => "Kaistanleveyden käyttö palveluiden mukaan",

    'ui__client/domain/traffic_unknown-reseller__short-title' => "Näytä liikenteen käyttöraportti",
    'ui__client/domain/traffic_unknown-reseller__title' => "Näytä liikenteen käyttöraportti",

    'ui__client/domain_new__short-title' => "Luo arvoalue",

    'ui__client_reseller__description' => "Hallitse jälleenmyyjätiliä %1.",
    'ui__client_reseller__short-title' => "%1",
    'ui__client_reseller__title' => "Hallitse jälleenmyyjätiliä",

    '__owner_name' => "Omistajan nimi",
    'domains_list__resource__filter_title' => "Resurssien käyttö",

    // APS CATALOG
    'site_apps__application_catalog_preferences' => "APS-sovellusluettelo",
    'site_apps__applications_have_updates' => "Seuraavien sovellusten päivitetyt versiot ovat saatavilla:\n%1\nKun haluat näyttää päivitykset, varmista, että hakualue on näkyvissä, valitse <b>Näytä vain päivitykset</b> -valintaruutu ja hae tarvitsemiasi sovelluksia.",
    'site_apps__progress_adding_to_vault' => "Lisätään säilöön:",
    'site_apps__progress_done_message' => "Eteneminen:",
    'site_apps__progress_applications_left' => "%1/%2 sovellusta jäljellä",
    'site_apps__download_item_long_task_title' => "Lataa APS-sovellus (%1)",
    'site_apps__download_transaction_long_task_title' => "Lataa APS-sovelluksia APS-luettelosta",
    'site_apps__last_check_for_updates' => "päivitysten viimeinen tarkastus: %1",
    'site_apps__all_sucessfully_added_to_app_vault' => "Kaikki aikataulutetut sovellukset lisättiin Application Vault -säilöön",
    'site_apps__number_of_apps_sucessfully_added_to_app_vault' => "%1 aikataulutetut sovellukset lisättiin Application Vault -säilöön",
    'site_apps__no_search_results' => 'Sovelluksia ei löytynyt. Yritä käyttää eri hakupyyntöä tai selaa sovelluksia luokkien mukaan.',
    'site_apps__search_results_title' => 'Etsinnän tulokset',
    '__site_apps__search_by_application' => 'Sovelluksen nimi',
    '__site_apps__search_by_vendor' => 'Toimittaja',
    '__site_apps__search_by_vendor__all' => 'Kaikki toimittajat',
    '__site_apps__search_by_packager' => 'Pakkaus',
    '__site_apps__search_by_certification_level' => 'Varmennetaso',
    '__site_apps__search_by_cert__any' => 'Mikä tahansa',
    '__site_apps__search_by_cert__silver_and_higher' => 'Hopea ja suurempi',
    '__site_apps__search_by_cert__gold_and_higher' => 'Kulta ja suurempi',
    '__retry' => 'Yritä uudelleen',
    'site_apps__application_packager_site' => 'Pakkaus',
    'site_apps__add_to_pool_message' => "Sovellukset, joissa on merkintä \"kaikkien saatavilla\", jaetaan automaattisesti kaikille jälleenmyyjille ja asiakkaille ilman asennusmäärän rajoitusta. Rajoitetut sovellukset jaetaan kaikille jälleenmyyjille ja asiakkaille manuaalisesti yksittäin ja saatavilla olevien asennusten määrä ilmoitetaan erikseen.",
    'site_apps__make_available_for_all' => "Aseta valitut sovellukset kaikkien käyttäjien käytettäväksi",

    'site_apps__broadcast_app_text' => "Sovellukset, joissa on merkintä \"kaikkien saatavilla\", jaetaan automaattisesti kaikille jälleenmyyjille ja asiakkaille ilman asennusmäärän rajoitusta. Rajoitetut sovellukset jaetaan kaikille jälleenmyyjille ja asiakkaille manuaalisesti yksittäin ja saatavilla olevien asennusten määrä ilmoitetaan erikseen.",
    'site_apps__broadcast_app_name' => 'Tuo sovellus kaikkien käyttäjien käyttöön',

    // User Application Pool per application
    'site_apps__available_clients' => 'Käytettävissä olevat käyttäjät',
    'site_apps__no_more_clients_to_add_to_pool' => 'Saatavilla ei ole käyttäjätilejä, joiden käyttöön tämä sovellus voidaan asettaa',

    // Installed application instances
    'site_apps__installations' => 'Asennukset',

    // Hosting setup redesign
    '__domain_name_and_ip_address' => "Toimialueen nimi ja IP-osoite",
    '__assign_ip_address' => "Määritä IP-osoite",
    '__switch_on_service' => "Ota palvelu käyttöön",
    '__hosting_configuration' => "Isännöinnin määritys",
    '__vrt_hst' => "Verkkosivuston isännöinti",
    '__vrt_hst_hint' => "Isännöi verkkosivustoa tässä palvelimessa.",
    '__fwd' => "Välitetään",
    '__web_hosting_settings' => "Isännöintiasetukset",
    '__fwd_hint' => "Ohjaa vierailijat uudelleen toiselle verkkosivustolle.",
    '__none_hint' => "Älä isännöi verkkosivustoa tällä hetkellä.",
    '__login_hint' => "Käyttäjätunnus, jolla päästään verkkosivustoon FTP:n kautta",
    '__password_hint' => "Salasana, jolla päästään verkkosivustoon FTP:n kautta",
    '__advanced_hosting_setup' => "Määritä verkkosivuston isännöinnin lisäasetukset",
    '__domain_creation_successful' => "Toimialue luotiin.",
    'bt_hosting_settings' => "Isännöintiasetukset",
    '__change_hosting_type' => "Muuta toimialueen %1 isännöintityyppi",
    '__hosting_type_change_warning' => "Kun muutat isännöintityypin edelleenlähetykseksi tai ei isännöintiä -tyypiksi, kaikki sivustoon liittyvät tiedostot ja hakemistot poistetaan palvelimesta. Muista tallentaa paikallinen kopio sivustostasi.",
    '__current_hosting_type' => "Nykyinen isännöintityyppi",
    '__new_hosting_type' => "Uusi isännöintityyppi",
    '__fwd_settings' => "Edelleenlähetysasetukset",
    '__fwd_settings_legend' => "Edelleenlähetysasetukset",
    '__fwd_destination_url' => "Kohde-URL",
    '__fwd_type' => "Edelleenlähetystyyppi",
    '__fwd_type_standart' => "Vakioedelleenlähetys",
    '__fwd_type_standart_hint' => "Ohjaa vierailijat uudelleen toiselle verkkosivustolle ja näytä heille kohdeosoite, jotta he saavat tietää uudelleenohjauksesta.",
    '__fwd_type_frame' => "Kehyksen edelleenlähetys",
    '__fwd_type_frame_hint' => "Ohjaa vierailijat uudelleen toiselle verkkosivustolle, mutta älä näytä heille kohdeosoitetta, jotta he eivät saa tietää uudelleenohjauksesta.",
    '__hosting_type_template_warning' => "Valitsemasi isännöintityyppi poikkeaa mallissa määritetystä tyypistä. Jos jatkat, valitun mallin verkkosivuston isännöintiasetukset jätetään huomiotta. Haluatko varmasti asettaa valitun isännöintityypin?",

    'ui__client/domain/properties#vrt_hst__title' => "Verkkosivuston isännöinti",
    'ui__client/domain/properties#vrt_hst__description' => "Isännöi verkkosivustoa tässä palvelimessa",
    'ui__client/domain/properties#fwd__title' => "Välitetään",
    'ui__client/domain/properties#fwd__description' => "Ohjaa vierailijat uudelleen toiselle verkkosivustolle",
    'ui__client/domain/properties#none__title' => "Ei isännöintiä",
    'ui__client/domain/properties#none__description' => "Älä isännöi verkkosivustoa tällä hetkellä",

    '__no_resellers_selected' => "Sinun täytyy valita vähintään yksi jälleenmyyjätili.",

    'ui__client/logo_unknown__wizard-title' => 'Määritä logo',
    'ui__client/logo_unknown__wizard__1_unknown' => 'Valitse asiakas, jonka logo-ominaisuuksia haluat muuttaa.',
    'ui__client/logo_unknown__wizard__2' => 'Ota muutokset käyttöön valitsemalla Valmis.',
    'ui__client/logo_unknown__wizard__2_self' => 'Ota muutokset käyttöön valitsemalla Valmis.',

    'ui__client/ipaddress/properties_new__short-title' => "Lisää IP-osoite",
    'ui__client/ipaddress/properties_new__title' => 'Lisää IP-osoite',
    'ui__client/ipaddress/properties_new__description' => "Lisää IP-osoite.",
    'ui__client/ipaddress/properties_unknown-new__short-title' => "Lisää IP-osoite",
    'ui__client/ipaddress/properties_unknown-new__title' => "Lisää IP-osoite",
    'ui__client/ipaddress/properties_unknown-new__description' => "Lisää IP-osoite",
    'ui__client/ipaddress/delete_multi__short-title' => "Poista IP-osoite",
    'ui__client/ipaddress/delete_multi__description' => "Poista IP-osoitteet.",
    'ippool_Manager__no_available_ips' => "IP-ryhmässä ei ole vapaita IP-osoitteita.",
    'ippool_Manager__ip_shared' => "jaettu",
    'ippool_Manager__ip_exclusive' => "omistettu",
    'ui__client/ipaddress/properties__title' => "Hallitse IP-osoitteita",
    'ui__client/ipaddress/properties__description' => "Tarkastele tai muuta IP-osoitteen ominaisuuksia.",
    'ui__client/ipaddress_unknown-new__title' => "Lisää IP-osoite",
    'ui__client/ipaddress_unknown-new__short-title' => "Lisää IP-osoite",
    'ui__client/ipaddress_unknown-new__description' => "Lisää IP-osoitteet.",

    'ui__mass-mail#to_resellers_text__title' => "Jälleenmyyjät",
    'ui__mass-mail#to_domainusers_text__title' => "Toimialueen järjestelmänvalvojat",
    'ui__mass-email#tools_legend__title' => "Työkalut",
    'ui__mass-email#list_legend__title' => 'Massasähköpostin mallit',
    'ui__mass-email#template_legend__title' => "Malli",
    'ui__mass-email#from_email_text__title' => "Lähettäjä",
    'ui__mass-email#to_text__title' => 'Vast.ott.',
    'ui__mass-email#to_resellers_text__title' => "Jälleenmyyjät",
    'ui__mass-email#to_clients_text__title' => "Asiakkaat",
    'ui__mass-email#to_domainusers_text__title' => "Toimialueen järjestelmänvalvojat",
    'ui__mass-email#to_admin_text__title' => "Pleskin järjestelmänvalvoja",
    'ui__mass-email#option_mode_all__title' => "Kaikki",
    'ui__mass-email#option_mode_select__title' => "Vain valitut",
    'ui__mass-email#option_mode_except__title' => "Kaikki paitsi valitut",
    'ui__mass-email#option_select_template__title' => '---Valitse malli---',
    'ui__mass-email#subject_text__title' => "Aihe",
    'ui__mass-email#body_text__title' => "Viestin teksti",
    'ui__mass-email#save_as_legend__title' => "Tallenna mallina",
    'ui__mass-email#save_as_text__title' => "Tallenna laadittu viesti uuteen malliin nimellä",
    'ui__reseller/preferences_unknown__wizard-title' => "Muuta tiliasetuksia",
    'ui__reseller/preferences_unknown__wizard__1_unknown' => "Valitse jälleenmyyjä, jonka tilin asetuksia haluat muuttaa ja valitse Seuraava.",
    'ui__reseller/preferences_unknown__wizard__2' => "Määritä tilin asetukset ja valitse OK.",
    'ippoolManager__ip_shared' => "jaettu",
    'ippoolManager__ip_exclusive' => "omistettu",

    '__users_list' => "Käyttäjät",
    '__users' => "Käyttäjät",
    '__user_name' => "Käyttäjän nimi",

    'clientOwnerChanger__wrong_owner_type' => "Voit siirtää valitut asiakastilit vain jälleenmyyjätiliin.",
    'clientOwnerChanger__wrong_client_type' => 'Valittu käyttäjätili on jälleenmyyjätili. Jälleenmyyjätileille ei voi määrittää uutta omistajaa, koska palvelimen järjestelmänvalvoja omistaa nämä tilit.',
    'ui__client/chowner_multi__description' => "Siirrä käyttäjätilit toiselle omistajalle.",
    'client_chown__clients_list_legend' => "Käyttäjätilit",
    'client_chown__client_name' => "Käyttäjän nimi",
    'client_chown__old_owner' => "Edellinen omistaja",
    'client_chown__limits_legend' => "Resurssit",
    'client_chown__limit_name' => "Resurssin nimi",
    'client_chown__limit_value' => "Varatut resurssit",
    'client_chown__usage_before' => "Ennen siirtoa",
    'client_chown_usage_after' => "Siirron jälkeen",
    'limit__name_max_dom_aliases' => "toimialueen aliakset",
    'limit__name_max_subftp_users' => "FTP-lisätilit",
    'limit__name_max_mssql_db' => "Microsoft SQL Server -tietokannat",
    'limit__name_max_iis_app_pools' => "IIS-sovellussarjat",
    'limit__name_max_odbc' => "ODBC-yhteydet",
    'total_mboxes_quota_unsupported' => 'ei postipalvelimen tukema',
    'limit_soft__disk_space' => 'Ilmoita levytilarajoituksen saavuttamisesta',
    'limit_soft__max_traffic' => 'Ilmoita liikenteen enimmäismäärän saavuttamisesta',
    'dsr__of_reseller_title' => "Toimialueiden resurssien käyttö",
    'client_chown__new_owner' => 'Uusi omistaja',
    'ui__reseller/to-client__has_clients_warning' => 'Joitakin valituista jälleenmyyjätileistä ei voi muuntaa asiakastileiksi, koska asiakkaat ovat tilanneet niiden palveluita. Poista tälle jälleenmyyjälle tilatut asiakastilit tai siirrä ne toiselle jälleenmyyjälle.',
    'limitsManager__commit_failed' => "Resurssirajoja ei voi muuttaa.",
    'limitsManager__date_in_past' => "Virheellinen päättymispäivämäärä %1.",
    'limitsManager__limit_not_supported' => "Resurssityypin %1 rajoja ei voi asettaa.",
    'limitsManager__limit_oversell_inconsistency' => "Määritettyä resurssimäärää ei voi varata, kun ylimyynti on poistettu käytöstä.",
    'limitsManager__limit_overuse_inconsistency' => "Resurssien käyttö ylittää määritetyt rajat.",
    'limitsManager__no_resource_available' => "Tämäntyyppisiä resursseja (%%limitName%%) ei ole enää käytettävissä. Vaaditaan: %%quantity%%; available: %%unused%%.",
    'limitsManager__no_total_resource_available' => "Palveluntarjoajalla ei ole enää käytettävissä tämäntyyppisiä resursseja (%%limitName%%). Vaaditaan: %%quantity%%; available: %%unused%%.",
    'limitsManager__invalid_expiration_limit' => "Päättymispäivämäärän on pienempi tai yhtä suuri kuin %1.",
    'limitsManager__invalid_disk_space_limit' => "Levytilan määrän on oltava pienempi tai yhtä suuri kuin %1.",
    'limitsManager__invalid_max_traffic_limit' => "Liikenteen määrän on oltava pienempi tai yhtä suuri kuin %1.",
    'ippoolManager__ip_has_suballocations' => "Käyttäjälle jo määritettyä IP-osoitteen tyyppiä ei voi muuttaa. IP-osoite %%ip%% on jo määritetty käyttäjälle muodossa %%reserved%% -IP-osoite.",
    'ippoolManager__ip_is_already_in_pool' => "Tämä IP-osoite on jo määritetty käyttäjälle.",
    'ippoolManager__ip_is_not_in_pool' => "Ryhmässä ei ole IP-osoitetta %%ip%%.",
    'ippoolManager__can_not_allocate_ip' => "IP-osoite %%ip%% on käytettävissä vain muodossa %%available%%.",
    'ippoolManager__unable_to_set_default_type' => "IP-osoitetta %%ip%% ei voi määrittää varattuna osoitteena.",
    'ippoolManager__ip_used_by_hst_or_frw' => "IP-osoitetta %%ip%% käytetään jo isännöintiin.",
    'ippoolManager__active_anon_ftp_on_ip' => "Anonyymi FTP-käyttö on jo otettu käyttöön IP-osoitteelle %%ip%%",
    'ippoolManager__no_vacant_ips' => "Vapaita IP-osoitteita ei ole käytettävissä.",
    'ippoolManager__no_available_ips' => "IP-osoitteita ei ole käytettävissä.",
    'templates__dublicate_name' => "Samanniminen malli on jo olemassa. Valitse tälle mallille toinen nimi.",
    'cl_perm__client_limits_exceeded' => "Määritetyt resurssiraja-arvot ylittävät arvot, jotka isännöintisuunnitelmasi sallii, tai nämä arvot sallivat vähemmän resursseja kuin sivustosi tällä hetkellä käyttävät.",
    'cl_perm__reseller_limits_exceeded' => "Määritetyt resurssien raja-arvot ylittävät isännöintisuunnitelmasi sallimat arvot tai nämä arvot sallivat vähemmän resursseja kuin asiakastilit ja sivustot tällä hetkellä käyttävät.",

    'site_apps__preferences_show_all_versions_title' => "Näytä kaikkien luettelosta noudettujen sovellusten versioiden täydellinen luettelo",
    'site_apps__preferences_show_all_versions_hint' => "Jos tämä vaihtoehto on valittu, jokaisen sovelluksen kaikkien versioiden noutaminen voi kestää kauan joka kerran, kun avaat luettelon. Jos tätä vaihtoehtoa ei ole valittu, vain uusimmat versiot näytetään.",
    '__select_user_template' => "Luo käyttäjätili mallin pohjalta",
    'ip_already_added_to_all_clients' => "Tämä IP-osoite on jo määritetty kaikille käyttäjille.",
    'ui__server/ip-address/client/delete#legend__description' => "Seuraavat IP-osoitteet poistetaan järjestelmästä ja käyttäjän IP-ryhmistä:",

    'site_apps__cancelled_apps' => "Olet peruuttanut seuraavien sovellusten lisäyksen: %2",

    'sb_url_is_not_resolved' => 'URL-osoitetta ei voida ratkaista: tarkista DNS-asetukset. URL %1 on ratkaistava palvelimen IP-osoite asennetulla Presence Builder -järjestelmällä.',

    'ip_addr__is_last_on_interface' => 'IP-osoitetta %%ip%% ei voi poistaa, koska se on viimeinen verkkoliittymässä oleva IP-osoite.',
    'ip_addr__used_for_current_session' => 'IP-osoitetta %%ip%% ei voi poistaa, koska sitä käytetään aktiivisessa istunnossa.',
    'ip_addr__used_for_hosting' => 'IP-osoitetta %%ip%% ei voi poistaa, koska sitä verkkosivuston isännöintiin.',
    'ip_addr__is_main' => 'IP-osoitetta %%ip%% ei voi poistaa, koska se on verkkoliittymän ensisijainen IP-osoite.',
    'ip_addr__ip_used_by_message_submission' => 'IP-osoitetta %%ip%% ei voi poistaa, koska sitä käytetään sähköpostiviestin lähetykseen',

    // RESELLER ACTION LOG

    '__cl_domains' => 'asiakkaiden toimialueet',
    'excl_ip_num' => 'Varattu IP-osoite',

    'sb_err_sitebuilder_not_installed' => 'Presence Builderia ei ole asennettu.',

    '__perm_allow_oversell_can_not_be_revoked' => 'Ylimyyntioikeutta ei voi kumota, koska käyttäjä on jo varannut enemmän resursseja kuin on saatavilla, ja näin ollen käyttää jo ylimyyntitilaa.',
    'limitsManager__invalid_limit_value' => 'Virheellinen arvo %%value%% rajalle %%limit_name%%',
    'ip_alias__type' => "IP-osoite jaettu muodossa",
    'ip_alias__in_type' => 'IP-osoite määritetty muodossa',
    'ui__client/ipaddress/delete_multi__title' => 'Poista IP-osoitteet',
    'ui__client/ipaddress/delete#legend__short-title' => 'Poistettavat kohteet',
    'ui__client/ipaddress/delete#legend__description' => "Seuraavat IP-osoitteet poistetaan käyttäjän IP-ryhmästä:",
    'ui__client/ipaddress/delete#nlegend__short-title' => 'Kohteet, joita ei voi poistaa',
    'ui__client/ipaddress/delete#nlegend__description' => 'Seuraavia IP-osoitteita ei voi poistaa:',
    'ui__server/ip-address/delete#legend__description' => 'Seuraavat IP-osoitteet poistetaan palvelimen IP-ryhmästä:',
    'confirmationForm_default_agreement_text' => 'Vahvista toiminto',
    'confirmationForm_default_confirm_message' => 'Vahvista toiminto.',
    'limit__max_mn' => 'Sähköpostitilien enimmäismäärä',

    'limits__client_overuse_description' => 'Ylikäyttökäytäntö kertoo Pleskille miten toimia, kun resurssien käyttö ylittää alkuperäisen resurssien varauksen.',
    'limits__client_overuse_block_true_description' => 'Estä resurssien ylikäyttö. Nykyinen resurssien käyttö ei voi ylittää alkuperäistä resurssien varausta',
    'limits__client_overuse_block_false_description' => 'Älä estä resurssien ylikäyttöä. Ylikäyttö antaa asiakkalle mahdollisuuden käyttää enemmän resursseja kuin alunperin on määritetty. Nykyinen resurssien käyttö voi ylittää alkuperäisen resurssien varauksen',
    'limits__client_overuse_notify_text' => 'Ilmoita asiakkaalle resurssien ylärajan saavuttamisesta',

    'limits__domain_overuse_description' => 'Ylikäyttökäytäntö kertoo Pleskille miten toimia, kun resurssien käyttö ylittää alkuperäisen resurssien varauksen.',
    'limits__domain_overuse_block_true_description' => 'Ylikäyttökäytäntö kertoo Pleskille miten toimia, kun käytetään liikaa resursseja.',
    'limits__domain_overuse_block_false_description' => 'Älä estä resurssien ylikäyttöä. Ylikäyttö antaa toimialueelle mahdollisuuden käyttää enemmän resursseja kuin alunperin on määritetty. Nykyinen resurssien käyttö voi ylittää alkuperäisen resurssien varauksen',
    'limits__domain_overuse_notify_text' => 'Ilmoita toimialueen omistajalle resurssien ylärajan saavuttamisesta',


    'cancel_remove' => 'Hylkää kaikki muutokset ja palaa edelliselle sivulle.',
    'php_not_installed' => 'PHP ei ole asennettu',

    'dns__dns_rr_delete' => 'Poistettavat kohteet',
    'dns__delete_rr' => 'Seuraavat DNS-tietueet poistetaan DNS-vyöhykkeestä:',
    'dns__dns_rr_delete_non_removable' => 'Kohteet, joita ei voi poistaa',
    'dns__non_delete_rr' => 'Seuraavia DNS-tietueita ei voi poistaa:',
    'dns__dns_rr_delete_confirm_message' => 'Vahvista DNS-tietueiden poisto',

    'site_apps__format_is_unsupported_broadcast_not_set' => 'Tuntematon verkkosovelluksen muoto: verkkosovellus ei ehkä ole saatavilla asennusta ja käyttöä varten.',

    '__php_handler_type_desc' => 'Suorita PHP',
    'sfdk_domain_sign__failed' => 'Määrittämätön virhe on tapahtunut, kun sähköpostin allekirjoitus pyrittiin ottamaan käyttöön toimialueen DKIM-ratkaisulla. Katso lisätietoa palvelimen virhelokista.',

    // key management ported from cpp to php
    'pkey_notify__subj_update_success_notification' => 'Ilmoitus Plesk-avaimen päivityksen onnistumisesta',
    'pkey_notify__subj_update_deferral_notification' => 'Plesk -avaimen päivityksen lykkäysilmoitus',
    'pkey_notify__subj_update_error_notification' => 'Plesk -avaimen päivityksen virheilmoitus',
    'pkey_notify__update_successful' => 'Kohteen %1 päivitys onnistui.',
    'pkey_notify__update_failed_no_more_try' => 'Kohdetta %1 ei voi päivittää. Avain, jonka yrität lähettää, on virheellinen. Älä yritä päivittää tätä avainta enää.',
    'pkey_notify__update_failed_try_later' => 'Päivitys %1 ei onnistu: avaimesi käsittelyssä tapahtui virhe. Voit yrittää hakea avaimen manuaalisesti Pleskissä (Työkalut ja Asetukset > Lisenssitiedot) tai antaa Pleskin yrittää päivittää se seuraavan 24 tunnin aikana. Jos et halua enää saada tätä ilmoitusta, poista tämä avain Pleskistä.',

    // spam assassin error messages
    'ui__server/spam-filter/toggle__unable_disable' => 'Palvelimenlaajuista roskapostisuodatusta ei voi ottaa pois käytöstä.',
    'ui__server/spam-filter/toggle__unable_enable' => 'Palvelimenlaajuista roskapostisuodatusta ei voi ottaa käyttöön',

    // Application vault/ application pool for admin mapping - TEMPORARY

    // report
    'report_auto__recipient_reseller' => 'Tämä jälleenmyyjä',
    'report_auto__select_reseller_report_all' => 'Kaikki jälleenmyyjät',
    'report_auto__select_reseller_report_client' => 'Kaikki tämän asiakkaan jälleenmyyjät',
    'report_auto__select_reseller_report_current' => 'Tämä jälleenmyyjä',
    'report_auto__select_reseller_report_reseller' => '%1',
    'report_auto__select_client_report_reseller' => 'Kaikki tämän jälleenmyyjän asiakkaat',
    'report_auto__select_client_report_client' => 'Tämä asiakas',
    'report_auto__select_client_report_other_reseller' => '%1',
    'report_auto__select_admin_report_all' => 'Jälleenmyyjät, asiakkaat ja toimialueet',

    'rpt_reseller_section_full_domains' => 'Toimialueet',
    'rpt_reseller_dom_subdomains' => 'Alitoimialue',
    'rpt_reseller_dom_domain_aliases' => 'DAliases',
    'rpt_reseller_dom_postboxes' => 'MBoxes',
    'rpt_reseller_dom_redirects' => 'Välittäjät',
    'rpt_reseller_dom_mail_groups' => 'MGroups',
    'rpt_reseller_dom_mail_resps' => 'AResp.',
    'rpt_reseller_dom_mail_antispam' => 'AntiSpam',
    'rpt_reseller_dom_mail_antivirus' => 'Virustentorjunta',
    'rpt_reseller_dom_mail_lists' => 'MLists',
    'rpt_reseller_dom_web_users' => 'WUsers',
    'rpt_reseller_dom_data_bases' => 'DBMySQL',
    'rpt_reseller_dom_mssql_data_bases' => 'DBMSSQL',

    'rpt_reseller_section_full_clients' => 'Asiakkaat',
    '__cl_name' => 'Asiakkaan nimi',
    '__cl_creation_date' => 'Luontipäivä',
    '__clients_traffic' => 'Asiakkaan liikenne',
    'rpt_reseller_cl_mail_antispam' => 'AntiSpam',
    'rpt_reseller_cl_mail_antivirus' => 'Virustentorjunta',

    // CONHELPS FOR HOME PAGE
    // common:
    'sitebuilder_not_installed' => 'Presence Builderia ei ole asennettu.',
    'sitebuilder_disabled' => 'Presence Builder on poistettu käytöstä.',
    'b_sitebuilder_disabled' => 'Presence Builder on poistettu käytöstä.',
    'webmail_not_installed' => 'WWW-sähköpostiohjelmistoa ei ole asennettu.',
    'webmail_disabled' => 'Sähköpostipalvelu on pois käytöstä.',
    'spamassassin_not_installed' => 'SpamAssassin-järjestelmää ei ole asennettu.',
    // pfu:
    'anonymous_ftp_shared' => 'Anonyymin FTP:n asetus ei onnistu: jaetun IP-osoitteen tyyppi.',
    'anonymous_ftp_used' => 'Anonyymin FTP:n asetus ei onnistu: toinen toimialue käyttää IP-osoitetta anonyymiä FTP-palvelua varten.',
    'sshterm__not_installed' => 'SSH-päätettä ei ole asennettu.',
    'sshterm__empty_shell' => 'Käytä pääte-clientia sallimalla liittymän käyttö tälle toimialueelle.',
    // pfw:
    'aspdotnet_not_installed' => 'ASP.NET ei ole asennettu.',
    'site_builder_no_package' => 'Presence Builder ei ole saatavilla. Tarkista, että Presence Builder on asennettu ja valittu aktiiviseksi komponentiksi.',
    'site_builder_not_configured' => 'Presence Builderia ei ole määritetty.',

    // LIST OF CLIENTS
    // under reseller
    'ui__reseller/client#tools__title' => 'Työkalut',
    'ui__reseller/client#clientslist__title' => 'Asiakkaat',

    //reseller accounts removal





    // NEW HOME PAGE WIZARDS

    // PFW-only

    'ui__client/domain/odbc_unknown__wizard-title' => "Aseta ODBC-tietolähteet verkkosivustoon",
    'ui__client/domain/odbc_unknown__wizard__2_unknown' => "Valitse verkkosivusto, jonka sovelluksiin haluat asettaa ODBC-tietolähteet.",

    'ui__client/domain/hosting/virtual-directories_unknown__wizard-title' => "Hallitse toimialueen näennäishakemistoja",
    'ui__client/domain/hosting/virtual-directories_unknown__wizard__2_unknown' => "Valitse toimialue, jonka näennäishakemistoja haluat hallita.",

    'ui__client/domain/hosting/web-directories_unknown__wizard-title' => 'Hallitse verkkosivuston näennäishakemistoja',
    'ui__client/domain/hosting/web-directories_unknown__wizard__2_unknown' => "Valitse verkkosivusto, jonka hakemistoja haluat hallita.",

    'ui__client/domain/hosting/hotlink-protection_unknown__wizard-title' => "Aseta toimialueen suoralinkkisuoja",
    'ui__client/domain/hosting/hotlink-protection_unknown__wizard__2_unknown' => "Valitse toimialue, jonka tiedostot haluat suojata suoralinkitykseltä.",

    'ui__client/domain/hosting/php_unknown__wizard-title' => "Määritä toimialueen PHP-asetukset",
    'ui__client/domain/hosting/php_unknown__wizard__2_unknown' => "Valitse toimialue, jonka PHP-asetukset haluat määrittää.",

    // COMMON WIZARDS


    'ui__client/domain/hosting/anonymous-ftp_unknown__wizard-title' => 'Aseta toimialueelle anonyymi FTP',
    'ui__client/domain/hosting/anonymous-ftp_unknown__wizard__2_unknown' => 'Valitse toimialue, johon haluat määrittää anonyymin FTP:n.',

    'ui__client/domain/hosting/protected-directories_unknown__wizard-title' => 'Hallitse toimialueen salasanasuojattuja hakemistoja',
    'ui__client/domain/hosting/protected-directories_unknown__wizard__2_unknown' => 'Valitse toimialue, jonka salasanasuojattuja hakemistoja haluat hallita.',




    'ui__client/domain/report/web-stats_unknown__wizard-title' => 'Näytä toimialueen verkkosivuston tilastot',
    'ui__client/domain/report/web-stats_unknown__wizard__2_unknown' => 'Valitse toimialue, jonka verkkosivuston tilastoja haluat tarkastella.',

    'ui__client/domain/hosting/logs_unknown__wizard-title' => 'Aseta toimialueelle lokinhallinta ja tarkastele toimialueen lokitiedostoja',
    'ui__client/domain/hosting/logs_unknown__wizard__2_unknown' => 'Valitse toimialue, jonka lokinhallinnan haluat määrittää, ja jonka lokitiedostoja haluat tarkastella.',

    'ui__client/domain/certificate_unknown__wizard-title' => 'Hallitse toimialueen SSL/TLS-varmenteita',
    'ui__client/domain/certificate_unknown__wizard__2_unknown' => 'Valitse toimialue, jonka SSL/TLS-varmenteita haluat hallita.',

    'ui__client/to-reseller_multi__wizard-title' => 'Muunna asiakastilit jälleenmyyjätileiksi',
    'ui__client/to-reseller_multi__wizard__1_multi' => 'Valitse asiakastilit, jotka haluat muuttaa jälleenmyyjän tileiksi.',

    'ui__reseller/to-client_multi__wizard-title' => 'Muunna jälleenmyyjätilit asiakastileiksi',
    'ui__reseller/to-client_multi__wizard__1_multi' => 'Valitse jälleenmyyjien tilit, jotka haluat muuttaa asiakastileiksi.',

    'ui__client/domain/properties_new__wizard__2/hosting/setup' => 'Määritä toimialueen isännöintiasetukset.',







    'ui__client/domain/disable_multi__wizard-title' => 'Peruuta toimialueet',
    'ui__client/domain/disable_multi__wizard__2_multi' => 'Valitse toimialueet, jotka haluat peruuttaa.',

    'ui__client/domain/enable_multi__wizard-title' => 'Aktivoi toimialueet',
    'ui__client/domain/enable_multi__wizard__2_multi' => 'Valitse aktivoivat toimialueet.',

    'ui__client/domain_unknown__wizard-title' => 'Näytä toimialueet',
    'ui__client/domain_unknown__wizard__1_unknown' => 'Valitse asiakas, jonka toimialueita haluat tarkastella.',

    'ui__client/domain/to-client_multi__wizard-title' => 'Muunna toimialueen järjestelmänvalvojan tilit asiakastileiksi',
    'ui__client/domain/to-client_multi__wizard__2_multi' => 'Valitse toimialueet, joiden järjestelmänvalvojan tilit haluat muuttaa asiakastileiksi',

    'ui__client/domain/register_unknown__wizard-title' => 'Rekisteröi toimialueet',
    'ui__client/domain/register_unknown__wizard__2_unknown' => 'Valitse toimialue, jonka haluat rekisteröidä.',

    'ui__client/domain/extras_unknown__wizard-title' => 'Käytä MyPlesk.com-sivun työkaluja',
    'ui__client/domain/extras_unknown__wizard__2_unknown' => 'Valitse toimialue, jota haluat hallita MyPlesk.com-sivun työkaluilla.',



    'ui__client/domain/hosting/ssh-terminal_unknown__wizard-title' => 'Käytä palvelinta SSH:n kautta', // PFU
    'ui__client/domain/hosting/ssh-terminal_unknown__wizard__2_unknown' => 'Valitse toimialue, jonka virtuaaliseen isäntään haluat muodostaa yhteyden SSH:n kautta.', // PFU

    // various

    'ui__server/ip-address/client_unknown__short-title' => 'IP-osoitteen käyttäjät',
    'ui__server/ip-address/client_unknown__title' => 'IP-osoitteen käyttäjät',
    'ui__server/ip-address/client_unknown__description' => 'IP-osoitteen %1 käyttäjät',

    'disabled_by_admin' => 'Poistettu käytöstä palvelimen järjestelmänvalvojan toimesta',






    'ui__client/domain/chowner_multi__short-title' => 'Muuta omistusta',
    'ui__client/domain/chowner_multi__title' => 'Muuta tilauksen omistusta',
    'ui__client/domain/chowner_multi__description' => 'Muuta tilauksen omistusta.',

    'ui__client/domain/chowner_multi__wizard__2_multi' => 'Valitse toimialueet, joiden omistusta haluat muuttaa, ja valitse Seuraava >>.',
    'ui__client/domain/chowner_unknown__short-title' => 'Muuta omistusta',
    'ui__client/domain/chowner_unknown__title' => 'Muuta tilauksen omistusta',
    'ui__client/domain/chowner_unknown__description' => 'Muuta tilauksen omistusta.',

    'ui__client/domain/chowner_unknown__wizard-title' => 'Muuta tilauksen omistusta',


    'ui__client/chowner__short-title' => 'Muuta asiakkaan omistajaa',
    'ui__client/chowner__title' => 'Muuta asiakastilin omistajaa',
    'ui__client/chowner__description' => 'Määritä tälle asiakastilille uusi omistaja',


    //custom buttons reseller home support
    //ui captions
    'ui__reseller/custom-buttons/custom-button__none-available' => 'Mukautettuja painikkeita ei ole.',
    'ui__reseller/custom-buttons/custom-button__none-available__1' => 'Jälleenmyyjän %1 liittymässä ei ole mukautettuja painikkeita.',

    'ui__reseller/custom-buttons/custom-button/delete__description' => 'Poista painike %1.',

    'ui__reseller/custom-buttons/custom-button/delete__short-title' => 'Poista',
    'ui__reseller/custom-buttons/custom-button/delete__title' => 'Poista painike %1',
    'ui__reseller/custom-buttons/custom-button/delete_multi__description' => 'Poista mukautetut painikkeet jälleenmyyjän liittymästä',

    'ui__reseller/custom-buttons/custom-button/delete_multi__short-title' => 'Poista',
    'ui__reseller/custom-buttons/custom-button/delete_multi__title' => 'Poista mukautetut painikkeet',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard-title' => 'Poista painikkeet',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard__1_unknown' => 'Valitse jälleenmyyjä, jonka mukautetut painikkeet haluat poistaa, ja valitse Seuraava >>.',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard__3_multi' => 'Valitse painikkeet, jotka haluat poistaa, ja valitse Seuraava >>.',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard__4_multi' => 'Vahvista painikkeiden poistaminen valitsemalla tässä näytössä oleva valintaruutu ja valitse sitten Valmis.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__description' => 'Poista mukautettu painike jälleenmyyjän liittymästä.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__short-title' => 'Poista',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__title' => 'Poista mukautettu painike',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard-title' => 'Poista mukautettu painike',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard__1_unknown' => 'Valitse jälleenmyyjä, jonka mukautetun painikkeen haluat poistaa, ja valitse Seuraava >>.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard__3_unknown' => 'Valitse mukautettu painike, jonka haluat poistaa, ja valitse Seuraava >>.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard__4' => 'Vahvista mukautetun painikkeen poistaminen valitsemalla tässä näytössä oleva valintaruutu ja valitse sitten Valmis.',

    'ui__reseller/custom-buttons/custom-button/properties__description' => 'Muuta jälleenmyyjätason mukautetun painikkeen %1 ominaisuuksia.',

    'ui__reseller/custom-buttons/custom-button/properties__short-title' => 'Asetukset',
    'ui__reseller/custom-buttons/custom-button/properties__title' => 'Muokkaa jälleenmyyjän mukautettua painiketta %1',

    'ui__reseller/custom-buttons/custom-button/properties_new__wizard-title' => 'Lisää mukautettu painike',
    'ui__reseller/custom-buttons/custom-button/properties_new__wizard__1_unknown' => 'Valitse jälleenmyyjä, jonka liittymään haluat luoda mukautetun painikkeen, ja valitse Seuraava >>.',
    'ui__reseller/custom-buttons/custom-button/properties_new__wizard__4_new' => 'Luo painike napsauttamalla Valmis.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__description' => 'Muuta painikkeen ominaisuuksia jälleenmyyjän liittymässä.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__short-title' => 'Ominaisuudet...',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__title' => 'Muuta painikkeen ominaisuuksia jälleenmyyjän liittymässä',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard-title' => 'Muuta mukautetun painikkeen ominaisuuksia',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard__1_unknown' => 'Valitse jälleenmyyjä, jonka mukautettua painiketta haluat muokata, ja valitse Seuraava >>.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard__3_unknown' => 'Valitse mukautettu painike, jota haluat muokata, ja valitse Seuraava >>.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard__4' => 'Kun olet muokannut painikkeen ominaisuudet, ota muutokset käyttöön valitsemalla Valmis ja poistu ohjatusta toiminnosta.',

    'ui__reseller/custom-buttons/custom-button/toggle_private__description' => 'Poista painike %1 asiakkaidesi käytöstä.',

    'ui__reseller/custom-buttons/custom-button/toggle_private__short-title' => 'Poista asiakkaidesi käytöstä',
    'ui__reseller/custom-buttons/custom-button/toggle_private__title' => 'Poista painike %1 asiakkaidesi käytöstä',
    'ui__reseller/custom-buttons/custom-button/toggle_public__description' => 'Tuo painike %1 näkyviin jälleenmyyjän asiakkaille.',
    'ui__reseller/custom-buttons/custom-button/toggle_public__short-title' => 'Tuo asiakkaiden käyttöön',
    'ui__reseller/custom-buttons/custom-button/toggle_public__title' => 'Tuo painike %1 näkyviin jälleenmyyjän asiakkaille',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__description' => 'Tuo mukautettu painike asiakkaiden käyttöön/poista mukautettu painike asiakkaiden käytöstä.',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__short-title' => 'Asiakkaidesi käytettävissä/ei asiakkaidesi käytettävissä',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__title' => 'Tuo mukautettu painike asiakkaiden käyttöön/poista mukautettu painike asiakkaiden käytöstä',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__wizard-title' => 'Tuo mukautettu painike asiakkaiden käyttöön/poista mukautettu painike asiakkaiden käytöstä.',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__wizard__1_unknown' => 'Valitse jälleenmyyjä, jonka mukautetun painikkeen haluat tuoda jälleenmyyjän asiakkaiden käyttöön, ja valitse Seuraava >>.',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__wizard__3_unknown' => 'Valitse mukautettu painike, jonka haluat tuoda asiakkaiden käyttöön/poistaa asiakkaiden käytöstä, ja valitse Seuraava >>.',




    'ui__server/ip-addresses__short-title' => 'IP-osoitteet',
    'ui__server/ip-addresses__title' => 'IP-osoitteiden hallinta',
    'ui__server/ip-addresses__description' => 'Lisää, poista ja määritä IP-osoitteita.',

    'ip_ctrl__allow_ftps' => 'Salli FTP SSL/TLS',
    '__ftps' => 'FTP SSL/TLS',
    '__not_allowed' => 'Ei sallittu',



    'ui__client/ipaddress/domain_unknown__short-title' => 'Osoitetta %2 käyttävät toimialueet',
    'ui__client/ipaddress/domain_unknown__title' => 'Toimialueet, jotka käyttävät %1 -IP-osoitetta %2',
    'ui__client/ipaddress/domain_unknown__description' => 'Näytä luettelo toimialueista, jotka käyttävät %1 IP-osoitetta %2',

    'ui__client/ipaddress__none-available' => 'IP-osoitteita ei ole käytettävissä',
    'ui__client/ipaddress__none-available__1' => 'IP-osoitteita ei ole käytettävissä',



    'ui__client/domain/report_unknown__wizard-title' => 'Näytä toimialueraportti',
    'ui__client/domain/report_unknown__wizard__2_unknown' => 'Valitse toimialue, jonka raporttia haluat tarkastella.',


    'ui__client/domain/chowner__wizard__3' => '',
    'ui__client/domain/chowner__wizard__3_select' => 'Valitse toimialueen uusi omistaja.',

    'ui__client/chowner__wizard__2_select' => 'Valitse tämän asiakastilin uusi omistaja.',

    '__ip_addr_state_unknown' => "IP-osoite ei ole tällä hetkellä käytössä, koska järjestelmä käsittelee vielä pyyntöäsi. Odota hetki.",


    'resellers_list__accounts' => 'Käyttäjät',

    'ip_addr__repair_is_not_allowed' => 'IP-osoitetta ei voi korjata Virtuozzo-ympäristössä.',

    'ui__reseller/client__none-available__1' => 'Jälleenmyyjällä %1 ei ole asiakkaita.',

    'ippoolManager__ip_used_by_nohost_domain' => "IP-osoitetta %%ip%% ei voi poistaa, koska yksi tai useampi toimialue käyttää sitä ilman isännöintiä.",
    'ippoolManager__ip_used_for_mail_service' => "IP-osoitetta %%ip%% ei voida poistaa, koska yksi tai useampi toimialue käyttää sitä postipalvelunsa IP-osoitteena.",
    'ippoolManager__ip_used_for_send_emails' => "IP-osoitetta %%ip%% ei voida poistaa, koska sitä käytetään sähköpostien lähettämiseen tietystä IP-osoitteesta (katso postipalvelimen asetukset).",
    'ippoolManager__ip_used_in_dns_zone' => 'IP-osoitetta %%ip%% ei voi poistaa, koska yhden tai useamman toimialueen DNS-vyöhyke käyttää sitä.',
    'ip_ctrl__cannot_manage_on_vz' => 'Tämä Plesk -asennus toimii Virtuozzo containers -järjestelmässä. Vain Virtuozzo containers -solmun järjestelmänvalvoja voi lisätä uusia IP-osoitteita.',

    'client_template__limits_auto_adjusted' => 'Asiakasmallin rajoitukset säädettiin automaattisesti.',

    '__entries' => 'Merkinnät',

    '__path_is_not_set' => 'Polkua ei ole määritetty. Määritä kelvollinen polku.',

    'defaultcomponents__imap_required' => '(Valittu sähköpostipalvelu ei tue IMAP:ta)',

    // Hotlink protection conhelp // PFW
    'i_hotlinkprotection_on' => 'Suoralinkityssuoja on otettu käyttöön tämän toimialueen kohdalla.',
    'i_hotlinkprotection_off' => 'Suoralinkityssuoja on poistettu käytöstä tämän toimialueen kohdalla.',

    '__commercial_web_stats_not_installed' => 'Plesk tukee vain kaupallista verkkotilastotietojen ohjelmistoa alitoimialueen tilastojen laskemiseen. Järjestelmään ei ole asennettu vaadittua ohjelmistoa.',

    'mail__spamassassin_personal_settings_disallowed' => 'Palvelimen järjestelmänvalvoja on kytkenyt henkilökohtaisten roskapostisuodatuksen asetuksien asetustoiminnon pois käytöstä. Alla olevia roskapostisuodatuksen asetuksia ei käytetä',

    // CLI keys, should be moved to separate file after 9.0
    'cu__unable_create_object' => '%1-objektia ei voi luoda: %2',
    'cu_dom_pref__invalid_expiration_date' => 'Virheellinen päättymispäivä: %1',
    'cu_cl_pref__illegal_date_val' => 'Määritit kelvottoman päivämääräarvon ("%1")',
    'cu_cl_pref__illegal_date_greater_less' => 'Syötä vuosi arvosta "%1" arvoon "%2"',
    'cu_initconf__unable_set_ip_alias_type' => 'IP-aliaksen tyyppiä ei voitu asettaa: %1',
    'cu_mlist__unable_change_status' => "Postituslistan tilaa ei voida muuttaa: %1",
    'cu_initconf__unable_change_passwd' => "Järjestelmänvalvojan salasanan muuttaminen ei onnistu: %1",
    'cu_serverpref__option_description_include_remote_databases' => 'Sisällyttää MySQL-etätietokannat levytilan käytön laskentaan.',
    'cu_siteapp_item__add_to_pool_success' => 'Verkkosovellus lisättiin verkkosovellussarjaan.',
    'cu_siteapp_item__remove_from_pool_success' => 'Verkkosovellus poistettiin verkkosovellussarjasta.',
    'cu_traffic_command_description_add_user' => 'Rekisteröi tietyn liikennemäärän, aivan kuin sitä käyttäisi jo asiakas/jälleenmyyjä',
    'cu_traffic_command_description_sub_user' => 'Vähentää tietyn liikennemäärän asiakkaalle/jälleenmyyjälle rekisteröidystä määrästä',
    'cu_traffic_command_description_add_batch_user' => 'Rekisteröi tietyn liikennemäärän, aivan kuin sitä käyttäisi jo asiakas/jälleenmyyjä (erätila)',
    'cu_traffic_command_description_del_user' => 'Nollaa tälle asiakkaalle/jälleenmyyjälle rekisteröidyn liikennemäärän',
    'cu_resellerpref__option_lock_screen' => 'Estää käyttäjiä käyttämästä Pleskia, kunnes liittymän näytöt on ladattu kokonaan',

    'server_settings_invalid_traffic_statistics' => 'Virheellinen retain traffic statistics -parametri.',
    'server_settings_invalid_logrotate_period' => 'Virheellinen log rotation period -parametri.',
];