<?php
// Copyright 1999-2022. Plesk International GmbH. All rights reserved.
$messages = [
    'problem-detail.nginx-upstream-sent-too-big-header.name' => 'Nginx: "502 Bad Gateway: upstream sent too big header while reading response header" (502 – ungültiges Gateway: Upstream hat beim Lesen des Antwort-Headers einen zu großen Header gesendet)',
    'problem-detail.nginx-upstream-sent-too-big-header.description' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.cause' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1' => '',
    'problem-detail.apache-followsymlinks-not-allowed.name' => 'Apache: "500 Internal Server Error: Option FollowSymLinks not allowed here" (500 – interner Serverfehler: Option FollowSymLinks ist hier nicht zulässig)',
    'problem-detail.apache-followsymlinks-not-allowed.description' => '',
    'problem-detail.apache-followsymlinks-not-allowed.cause' => '',
    'problem-detail.phpfpm-server-reached-max-children.name' => 'PHP-FPM: "server reached max_children setting" (Server hat den Grenzwert für die Einstellung max_children erreicht)',
    'problem-detail.phpfpm-server-reached-max-children.description' => '<h4>Symptome</h4><ul><li><p>Bei Websites, bei denen unter <strong>Domains</strong> &gt; <strong>example.com</strong> &gt; <strong>PHP-Einstellungen</strong> als PHP-Handler <strong>Von Apache bereitgestellte FPM-Anwendung</strong> oder <strong>Von Nginx bereitgestellte FPM-Anwendung</strong> festgelegt ist, tritt eines der folgenden Probleme auf:</p><ul><li><p>Wird langsam geladen</p></li><li><p>Ist nicht verfügbar (dauerhaft oder in regelmäßigen Abständen) mit einem 50x-Fehler in einem Webbrowser:</p><pre>502 Bad Gateway</pre><hr><pre>503 Service Temporarily Unavailable</pre><hr><pre>504 Gateway Time-out</pre></li></ul></li><li><p>Die folgende Fehlermeldung ist im PHP-FPM-Fehlerprotokoll <code>/var/log/plesk-php<strong>XX</strong>-fpm/error.log</code> zu finden (hier steht<em>XX</em> für die auf den Websites verwendete PHP-Version):</p><pre>WARNING: [pool example.com] server reached max_children setting (*), consider raising it</pre><ul><li><p>Die Nachricht oben wird in der Regel von diesem Fehler begleitet:</p><pre>unable to read what child say: Bad file descriptor (9)</pre></li></ul></li><li><p>Wenn Nginx auf dem Server aktiviert ist, kann eine der folgenden Fehlermeldungen im Fehlerprotokoll der Domain <code>/var/www/vhosts/system/example.com/logs/proxy_error_log</code> zu finden sein:</p><pre style="white-space: pre-wrap;">[error] 11456#0: *118348 connect() to unix:///var/www/vhosts/system/example.com/php-fpm.sock failed (11: Resource temporarily unavailable) while connecting to upstream, client: 203.0.113.2, server: example.com, request: "GET / HTTP/1.1", upstream: "fastcgi://unix:///var/www/vhosts/system/example.com/php-fpm.sock:", host: "example.com"</pre><hr><pre style="white-space: pre-wrap;">[error] 20058#0: *4725139 upstream prematurely closed connection while reading response header from upstream, client: 203.0.113.2, server: example.com, request: "POST /path/to/some/file HTTP/2.0", upstream:</pre></li></ul>',
    'problem-detail.phpfpm-server-reached-max-children.cause' => ' <p>Der PHP-FPM-Grenzwert <code>pm.max_children</code> wurde von den Websites erreicht.</p>',
    'problem-detail.phpfpm-server-reached-max-children.solution1' => '<p>Erhöhen Sie den Grenzwert <code>pm.max_children</code> für die betroffenen Domains:</p><ol><li><p>Stellen Sie über <a href="https://support.plesk.com/hc/en-us/articles/115000172834" target="_blank" rel="noopener">SSH</a> eine Verbindung zum Plesk Server her.</p></li><li><p>Suchen Sie die betroffenen Domains. Verwenden Sie dazu den folgenden Befehl:</p><div class="pul-alert pul-alert--info pul-status-message pul-status-message--info"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Hinweis:</strong> Die Nummer links gibt Aufschluss darüber, wie oft der Grenzwert <code>pm.max_children</code> von der Website erreicht wurde.</div><pre style="white-space: pre-wrap;"># grep -r "server reached max_children setting" /var/log/*php*-fpm/error.log | cut -d\' \' -f5 | tr -d \']\' | sort | uniq -c | sort -nr<br><br>100 example.com<br>50 example.net<br>25 example.org<br>&lt;...&gt;</pre></li><li><p><a href="https://support.plesk.com/hc/en-us/articles/213413369" target="_blank" rel="noopener">Melden Sie sich in Plesk an</a>.</p></li><li><p>Gehen Sie zu <strong>Domains</strong> &gt; <strong>example.com</strong> &gt; <strong>PHP-Einstellungen </strong> &gt; <strong>PHP-FPM-Einstellungen</strong>.</p></li><li><p>Erhöhen Sie den Wert für die Domain unter <code>pm.max_children</code> und wenden Sie die Änderungen an. Wiederholen Sie diesen Schritt für alle in Schritt 2 genannten Domains.</p></li></ol>',
    'problem-detail.nginx-too-many-open-files.name' => 'Nginx: "Too many open files" (Zu viele Dateien geöffnet)',
    'problem-detail.nginx-too-many-open-files.description' => '<p>Nginx kann nicht auf einem Plesk Server gestartet oder neu geladen werden, weil zu viele Dateien geöffnet sind </p><h4>Symptome</h4><ul><li><p>Der Nginx-Dienst kann nicht gestartet oder neu geladen werden und die folgende Fehlermeldung wird in der Datei <code>/var/log/nginx/error.log</code> ausgegeben:</p><pre style="white-space: pre-wrap;">nginx: [emerg] open() "/var/www/vhosts/system/example.com/logs/proxy_access_ssl_log" failed (24: Too many open files)</pre></li><li><p>Auf einige oder alle Websites kann nicht zugegriffen werden </p></li><li><p>Eine Warnmeldung wird unter <strong>Tools &amp; Einstellungen &gt; Diagnose &amp; Reparatur angezeigt</strong>:</p><pre style="white-space: pre-wrap;">Checking for nginx ULIMIT value N domains have been found on server. Problem with nginx default limit for open files is possible</pre></li><li><p>NodeJS- und Ruby-Webanwendungen zeigen bei einigen Aufgaben in Plesk (z. B. Domains oder Abonnements erstellen oder Apache oder Nginx anpassen) den Fehler "502 Bad Gateway":</p><pre style="white-space: pre-wrap;">Server Error<br>502 Bad Gateway <br>Web server received an invalid response while acting as a gateway or proxy server.</pre></li><li><p>Nachdem Sie <a href="https://support.plesk.com/hc/en-us/articles/213946825-How-to-install-SSL-certificate-for-a-domain-in-Plesk" target="_blank" rel="noopener noreferrer">ein neues Zertifikat für die Domain installiert haben</a>, ist das bisherige Zertifikat noch im Webbrowser sichtbar, aber das korrekte Zertifikat ist unter <strong>Domains &gt; example.com &gt; Hosting-Einstellungen </strong> ausgewählt.</p></li></ul>',
    'problem-detail.nginx-too-many-open-files.cause' => '<p>Der virtuelle Host von Nginx öffnet 4 Protokolldateien für jeden virtuellen Host mit physikalischem Hosting:</p><ul><li>proxy_access_log</li><li>proxy_access_ssl_log</li><li>webmail_access_log</li><li>webmail_access_ssl_log</li></ul><p> Dies hat zur Folge, dass der Nginx-Server im Fall von sehr vielen Domains (in der Regel mehr als 100) die maximale Anzahl geöffneter Dateien überschreitet.</p>',
    'problem-detail.nginx-too-many-open-files.solution1' => '<div class="pul-alert pul-alert--warning pul-status-message pul-status-message--warning"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Achtung:</strong> Wenn Sie das Dienstprogramm <code>websrv_ulimits</code> ohne die Option <strong>--no-restart</strong> ausführen, werden die Webkonfigurationsdateien für alle Domains neu erstellt. Dies kann bei einer großen Anzahl von gehosteten Websites zu erheblichen Ausfallzeiten führen.<br><br>Führen Sie den Befehl während der Wartung aus.</div><p>Es wird empfohlen, den Grenzwert für geöffnete Dateien auf einen Wert zu setzen, der mindestens dem hier entspricht: <strong>Anzahl der Domains in Plesk x 16</strong>. Im folgenden Beispiel sehen Sie, wie der Grenzwert auf 4096 gesetzt wird:</p><ol><li><p> Stellen Sie über <a href="https://support.plesk.com/hc/en-us/articles/115000172834" target="_blank" rel="noopener noreferrer">SSH</a> eine Verbindung zum Server her.</p></li><li><p>Setzen Sie den Grenzwert für geöffnete Dateien für Apache und Nginx auf 4096:</p><pre># /usr/local/psa/admin/sbin/websrv_ulimits --set 4096 --no-restart</pre></li><li><p>Um die Änderungen anzuwenden, starten Sie Apache und Nginx erneut unter <strong><a href="https://support.plesk.com/hc/en-us/articles/213413369" target="_blank" rel="noopener noreferrer">Plesk</a> &gt;</strong> <strong>Tools &amp; Einstellungen &gt; Service-Verwaltung</strong>.</p></li><li><p>Nachdem die Webdienste neu gestartet wurden, überprüfen Sie, ob der Grenzwert "Max open files" angewendet wurde:</p><pre># grep \'Max open files\' /proc/$(cat /var/run/nginx.pid)/limits<br>Max open files 4096 4096 file</pre></li><li><p>Falls Sie das Problem nicht mit den Schritten oben lösen konnten, legen Sie den Grenzwert über das Dienstprogramm <code>ulimit</code> fest:</p><pre># ulimit -n 4096</pre></li></ol>',
    'problem-detail.apache-modsec-response-body-too-large.name' => 'ModSecurity: "Response body too large" (Antworttext zu lang)',
    'problem-detail.apache-modsec-response-body-too-large.description' => '',
    'problem-detail.apache-modsec-response-body-too-large.cause' => '',
    'problem-detail.modsec-access-denied.name' => 'ModSecurity: "Access denied with code 403" (Zugriffsfehler mit dem Code 403)',
    'problem-detail.modsec-access-denied.description' => '',
    'problem-detail.modsec-access-denied.cause' => '',
    'problem-detail.php-allowed-memory-size-exhausted.name' => 'PHP: "Internal Server error 500: Allowed memory size of XXX exhausted" (Interner Serverfehler 500: Zulässige Speichergröße von XXX erreicht)',
    'problem-detail.php-allowed-memory-size-exhausted.description' => '',
    'problem-detail.php-allowed-memory-size-exhausted.cause' => '',
    'problem-detail.php-open-basedir-restriction-in-effect.name' => 'PHP: "open_basedir restriction in effect" (Einschränkung open_basedir gilt)',
    'problem-detail.php-open-basedir-restriction-in-effect.description' => '',
    'problem-detail.php-open-basedir-restriction-in-effect.cause' => '',
    'problem-detail.apache-client-denied-by-server.name' => 'Apache .htaccess: "403 Forbidden AH01797: client denied by server configuration" (403 – verboten AH01797: Client durch Serverkonfiguration verweigert)',
    'problem-detail.apache-client-denied-by-server.description' => '',
    'problem-detail.apache-client-denied-by-server.cause' => '',
    'problem-detail.apache-no-directory-index.name' => 'Apache: "Cannot access a website directory in Plesk: 403 Forbidden" (Kein Zugriff auf ein Websiteverzeichnis in Plesk: 403 – verboten)',
    'problem-detail.apache-no-directory-index.description' => '',
    'problem-detail.apache-no-directory-index.cause' => '',
    'problem-detail.nginx-no-directory-index.name' => 'Nginx: "Cannot access a website directory in Plesk: 403 Forbidden" (Kein Zugriff auf ein Websiteverzeichnis in Plesk: 403 – verboten)',
    'problem-detail.nginx-no-directory-index.description' => '',
    'problem-detail.nginx-no-directory-index.cause' => '',
    'problem-detail.apache-reached-max-request-workers.name' => 'Apache: "server reached MaxRequestWorkers setting" (Server hat den Grenzwert MaxRequestWorkers erreicht)',
    'problem-detail.apache-reached-max-request-workers.description' => '',
    'problem-detail.apache-reached-max-request-workers.cause' => '',
    'problem-detail.php-post-content-length-exceeds-limit.name' => 'Grenzwert für PHP-Anfragentext: "client intended to send too large body" (Client beabsichtigt, einen zu großen Text zu senden)',
    'problem-detail.php-post-content-length-exceeds-limit.description' => '',
    'problem-detail.php-post-content-length-exceeds-limit.cause' => '',
    'problem-detail.nginx-client-sent-too-large-body.name' => 'Grenzwert für PHP-Anfragentext: "client intended to send too large body" (Client beabsichtigt, einen zu großen Text zu senden)',
    'problem-detail.nginx-client-sent-too-large-body.description' => '',
    'problem-detail.nginx-client-sent-too-large-body.cause' => '',
    'problem-detail.php-failed-to-read-session-data.name' => 'PHP-Sitzungen: "503 Internal Server Error" (503 – interner Serverfehler) oder "Failed to read session data" (Sitzungsdaten konnten nicht gelesen werden)',
    'problem-detail.php-failed-to-read-session-data.description' => '',
    'problem-detail.php-failed-to-read-session-data.cause' => '',
    'problem-detail.apache-unable-to-check-htaccess-file.name' => 'Apache .htaccess: "403 Forbidden: pcfg_openfile: unable to check htaccess file, ensure it is readable" (403 – verboten: pcfg_openfile: htaccess-Datei kann nicht überprüft werden; vergewissern Sie sich, dass sie gelesen werden kann)',
    'problem-detail.apache-unable-to-check-htaccess-file.description' => '',
    'problem-detail.apache-unable-to-check-htaccess-file.cause' => '',
];